<?php
// This file was auto-generated from sdk-root/src/data/workmail/2017-10-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon WorkMail is a secure, managed business email and calendaring service with support for existing desktop and mobile email clients. You can access your email, contacts, and calendars using Microsoft Outlook, your browser, or other native iOS and Android email applications. You can integrate WorkMail with your existing corporate directory and control both the keys that encrypt your data and the location in which your data is stored.</p> <p>The WorkMail API is designed for the following scenarios:</p> <ul> <li> <p>Listing and describing organizations</p> </li> </ul> <ul> <li> <p>Managing users</p> </li> </ul> <ul> <li> <p>Managing groups</p> </li> </ul> <ul> <li> <p>Managing resources</p> </li> </ul> <p>All WorkMail API operations are Amazon-authenticated and certificate-signed. They not only require the use of the AWS SDK, but also allow for the exclusive use of AWS Identity and Access Management users and roles to help facilitate access, trust, and permission policies. By creating a role and allowing an IAM user to access the WorkMail site, the IAM user gains full administrative visibility into the entire WorkMail organization (or as set in the IAM policy). This includes, but is not limited to, the ability to create, update, and delete users, groups, and resources. This allows developers to perform the scenarios listed above, as well as give users the ability to grant access on a selective basis using the IAM model.</p>', 'operations' => [ 'AssociateDelegateToResource' => '<p>Adds a member (user or group) to the resource\'s set of delegates.</p>', 'AssociateMemberToGroup' => '<p>Adds a member (user or group) to the group\'s set.</p>', 'CreateAlias' => '<p>Adds an alias to the set of a given member (user or group) of Amazon WorkMail.</p>', 'CreateGroup' => '<p>Creates a group that can be used in Amazon WorkMail by calling the <a>RegisterToWorkMail</a> operation.</p>', 'CreateResource' => '<p>Creates a new Amazon WorkMail resource. </p>', 'CreateUser' => '<p>Creates a user who can be used in Amazon WorkMail by calling the <a>RegisterToWorkMail</a> operation.</p>', 'DeleteAccessControlRule' => '<p>Deletes an access control rule for the specified WorkMail organization.</p>', 'DeleteAlias' => '<p>Remove one or more specified aliases from a set of aliases for a given user.</p>', 'DeleteGroup' => '<p>Deletes a group from Amazon WorkMail.</p>', 'DeleteMailboxPermissions' => '<p>Deletes permissions granted to a member (user or group).</p>', 'DeleteResource' => '<p>Deletes the specified resource. </p>', 'DeleteRetentionPolicy' => '<p>Deletes the specified retention policy from the specified organization.</p>', 'DeleteUser' => '<p>Deletes a user from Amazon WorkMail and all subsequent systems. Before you can delete a user, the user state must be <code>DISABLED</code>. Use the <a>DescribeUser</a> action to confirm the user state.</p> <p>Deleting a user is permanent and cannot be undone. WorkMail archives user mailboxes for 30 days before they are permanently removed.</p>', 'DeregisterFromWorkMail' => '<p>Mark a user, group, or resource as no longer used in Amazon WorkMail. This action disassociates the mailbox and schedules it for clean-up. WorkMail keeps mailboxes for 30 days before they are permanently removed. The functionality in the console is <i>Disable</i>.</p>', 'DescribeGroup' => '<p>Returns the data available for the group.</p>', 'DescribeOrganization' => '<p>Provides more information regarding a given organization based on its identifier.</p>', 'DescribeResource' => '<p>Returns the data available for the resource.</p>', 'DescribeUser' => '<p>Provides information regarding the user.</p>', 'DisassociateDelegateFromResource' => '<p>Removes a member from the resource\'s set of delegates.</p>', 'DisassociateMemberFromGroup' => '<p>Removes a member from a group.</p>', 'GetAccessControlEffect' => '<p>Gets the effects of an organization\'s access control rules as they apply to a specified IPv4 address, access protocol action, or user ID. </p>', 'GetDefaultRetentionPolicy' => '<p>Gets the default retention policy details for the specified organization.</p>', 'GetMailboxDetails' => '<p>Requests a user\'s mailbox details for a specified organization and user.</p>', 'ListAccessControlRules' => '<p>Lists the access control rules for the specified organization.</p>', 'ListAliases' => '<p>Creates a paginated call to list the aliases associated with a given entity.</p>', 'ListGroupMembers' => '<p>Returns an overview of the members of a group. Users and groups can be members of a group.</p>', 'ListGroups' => '<p>Returns summaries of the organization\'s groups.</p>', 'ListMailboxPermissions' => '<p>Lists the mailbox permissions associated with a user, group, or resource mailbox.</p>', 'ListOrganizations' => '<p>Returns summaries of the customer\'s organizations.</p>', 'ListResourceDelegates' => '<p>Lists the delegates associated with a resource. Users and groups can be resource delegates and answer requests on behalf of the resource.</p>', 'ListResources' => '<p>Returns summaries of the organization\'s resources.</p>', 'ListTagsForResource' => '<p>Lists the tags applied to an Amazon WorkMail organization resource.</p>', 'ListUsers' => '<p>Returns summaries of the organization\'s users.</p>', 'PutAccessControlRule' => '<p>Adds a new access control rule for the specified organization. The rule allows or denies access to the organization for the specified IPv4 addresses, access protocol actions, and user IDs. Adding a new rule with the same name as an existing rule replaces the older rule.</p>', 'PutMailboxPermissions' => '<p>Sets permissions for a user, group, or resource. This replaces any pre-existing permissions.</p>', 'PutRetentionPolicy' => '<p>Puts a retention policy to the specified organization.</p>', 'RegisterToWorkMail' => '<p>Registers an existing and disabled user, group, or resource for Amazon WorkMail use by associating a mailbox and calendaring capabilities. It performs no change if the user, group, or resource is enabled and fails if the user, group, or resource is deleted. This operation results in the accumulation of costs. For more information, see <a href="https://aws.amazon.com/workmail/pricing">Pricing</a>. The equivalent console functionality for this operation is <i>Enable</i>. </p> <p>Users can either be created by calling the <a>CreateUser</a> API operation or they can be synchronized from your directory. For more information, see <a>DeregisterFromWorkMail</a>.</p>', 'ResetPassword' => '<p>Allows the administrator to reset the password for a user.</p>', 'TagResource' => '<p>Applies the specified tags to the specified Amazon WorkMail organization resource.</p>', 'UntagResource' => '<p>Untags the specified tags from the specified Amazon WorkMail organization resource.</p>', 'UpdateMailboxQuota' => '<p>Updates a user\'s current mailbox quota for a specified organization and user.</p>', 'UpdatePrimaryEmailAddress' => '<p>Updates the primary email for a user, group, or resource. The current email is moved into the list of aliases (or swapped between an existing alias and the current primary email), and the email provided in the input is promoted as the primary.</p>', 'UpdateResource' => '<p>Updates data for the resource. To have the latest information, it must be preceded by a <a>DescribeResource</a> call. The dataset in the request should be the one expected when performing another <code>DescribeResource</code> call.</p>', ], 'shapes' => [ 'AccessControlRule' => [ 'base' => '<p>A rule that controls access to an Amazon WorkMail organization.</p>', 'refs' => [ 'AccessControlRulesList$member' => NULL, ], ], 'AccessControlRuleAction' => [ 'base' => NULL, 'refs' => [ 'ActionsList$member' => NULL, 'GetAccessControlEffectRequest$Action' => '<p>The access protocol action. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>', ], ], 'AccessControlRuleDescription' => [ 'base' => NULL, 'refs' => [ 'AccessControlRule$Description' => '<p>The rule description.</p>', 'PutAccessControlRuleRequest$Description' => '<p>The rule description.</p>', ], ], 'AccessControlRuleEffect' => [ 'base' => NULL, 'refs' => [ 'AccessControlRule$Effect' => '<p>The rule effect.</p>', 'GetAccessControlEffectResponse$Effect' => '<p>The rule effect.</p>', 'PutAccessControlRuleRequest$Effect' => '<p>The rule effect.</p>', ], ], 'AccessControlRuleName' => [ 'base' => NULL, 'refs' => [ 'AccessControlRule$Name' => '<p>The rule name.</p>', 'AccessControlRuleNameList$member' => NULL, 'DeleteAccessControlRuleRequest$Name' => '<p>The name of the access control rule.</p>', 'PutAccessControlRuleRequest$Name' => '<p>The rule name.</p>', ], ], 'AccessControlRuleNameList' => [ 'base' => NULL, 'refs' => [ 'GetAccessControlEffectResponse$MatchedRules' => '<p>The rules that match the given parameters, resulting in an effect.</p>', ], ], 'AccessControlRulesList' => [ 'base' => NULL, 'refs' => [ 'ListAccessControlRulesResponse$Rules' => '<p>The access control rules.</p>', ], ], 'ActionsList' => [ 'base' => NULL, 'refs' => [ 'AccessControlRule$Actions' => '<p>Access protocol actions to include in the rule. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>', 'AccessControlRule$NotActions' => '<p>Access protocol actions to exclude from the rule. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>', 'PutAccessControlRuleRequest$Actions' => '<p>Access protocol actions to include in the rule. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>', 'PutAccessControlRuleRequest$NotActions' => '<p>Access protocol actions to exclude from the rule. Valid values include <code>ActiveSync</code>, <code>AutoDiscover</code>, <code>EWS</code>, <code>IMAP</code>, <code>SMTP</code>, <code>WindowsOutlook</code>, and <code>WebMail</code>.</p>', ], ], 'Aliases' => [ 'base' => NULL, 'refs' => [ 'ListAliasesResponse$Aliases' => '<p>The entity\'s paginated aliases.</p>', ], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'DescribeOrganizationResponse$ARN' => '<p>The Amazon Resource Name (ARN) of the organization.</p>', 'ListTagsForResourceRequest$ResourceARN' => '<p>The resource ARN.</p>', 'TagResourceRequest$ResourceARN' => '<p>The resource ARN.</p>', 'UntagResourceRequest$ResourceARN' => '<p>The resource ARN.</p>', ], ], 'AssociateDelegateToResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateDelegateToResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateMemberToGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateMemberToGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'BookingOptions' => [ 'base' => '<p>At least one delegate must be associated to the resource to disable automatic replies from the resource.</p>', 'refs' => [ 'DescribeResourceResponse$BookingOptions' => '<p>The booking options for the described resource.</p>', 'UpdateResourceRequest$BookingOptions' => '<p>The resource\'s booking options to be updated.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'BookingOptions$AutoAcceptRequests' => '<p>The resource\'s ability to automatically reply to requests. If disabled, delegates must be associated to the resource.</p>', 'BookingOptions$AutoDeclineRecurringRequests' => '<p>The resource\'s ability to automatically decline any recurring requests.</p>', 'BookingOptions$AutoDeclineConflictingRequests' => '<p>The resource\'s ability to automatically decline any conflicting requests.</p>', ], ], 'CreateAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'Delegate' => [ 'base' => '<p>The name of the attribute, which is one of the values defined in the UserAttribute enumeration.</p>', 'refs' => [ 'ResourceDelegates$member' => NULL, ], ], 'DeleteAccessControlRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccessControlRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMailboxPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMailboxPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRetentionPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRetentionPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterFromWorkMailRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterFromWorkMailResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'DirectoryServiceAuthenticationFailedException' => [ 'base' => '<p>The directory service doesn\'t recognize the credentials supplied by WorkMail.</p>', 'refs' => [], ], 'DirectoryUnavailableException' => [ 'base' => '<p>The directory on which you are trying to perform operations isn\'t available.</p>', 'refs' => [], ], 'DisassociateDelegateFromResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateDelegateFromResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateMemberFromGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateMemberFromGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'EmailAddress' => [ 'base' => NULL, 'refs' => [ 'Aliases$member' => NULL, 'CreateAliasRequest$Alias' => '<p>The alias to add to the member set.</p>', 'DeleteAliasRequest$Alias' => '<p>The aliases to be removed from the user\'s set of aliases. Duplicate entries in the list are collapsed into single entries (the list is transformed into a set).</p>', 'DescribeGroupResponse$Email' => '<p>The email of the described group.</p>', 'DescribeResourceResponse$Email' => '<p>The email of the described resource.</p>', 'DescribeUserResponse$Email' => '<p>The email of the user.</p>', 'Group$Email' => '<p>The email of the group.</p>', 'RegisterToWorkMailRequest$Email' => '<p>The email for the user, group, or resource to be updated.</p>', 'Resource$Email' => '<p>The email of the resource.</p>', 'UpdatePrimaryEmailAddressRequest$Email' => '<p>The value of the email to be updated as primary.</p>', 'User$Email' => '<p>The email of the user.</p>', ], ], 'EmailAddressInUseException' => [ 'base' => '<p>The email address that you\'re trying to assign is already created for a different user, group, or resource.</p>', 'refs' => [], ], 'EntityAlreadyRegisteredException' => [ 'base' => '<p>The user, group, or resource that you\'re trying to register is already registered.</p>', 'refs' => [], ], 'EntityNotFoundException' => [ 'base' => '<p>The identifier supplied for the user, group, or resource does not exist in your organization.</p>', 'refs' => [], ], 'EntityState' => [ 'base' => NULL, 'refs' => [ 'DescribeGroupResponse$State' => '<p>The state of the user: enabled (registered to Amazon WorkMail) or disabled (deregistered or never registered to WorkMail).</p>', 'DescribeResourceResponse$State' => '<p>The state of the resource: enabled (registered to Amazon WorkMail), disabled (deregistered or never registered to WorkMail), or deleted.</p>', 'DescribeUserResponse$State' => '<p>The state of a user: enabled (registered to Amazon WorkMail) or disabled (deregistered or never registered to WorkMail).</p>', 'Group$State' => '<p>The state of the group, which can be ENABLED, DISABLED, or DELETED.</p>', 'Member$State' => '<p>The state of the member, which can be ENABLED, DISABLED, or DELETED.</p>', 'Resource$State' => '<p>The state of the resource, which can be ENABLED, DISABLED, or DELETED.</p>', 'User$State' => '<p>The state of the user, which can be ENABLED, DISABLED, or DELETED.</p>', ], ], 'EntityStateException' => [ 'base' => '<p>You are performing an operation on a user, group, or resource that isn\'t in the expected state, such as trying to delete an active user.</p>', 'refs' => [], ], 'FolderConfiguration' => [ 'base' => '<p>The configuration applied to an organization\'s folders by its retention policy.</p>', 'refs' => [ 'FolderConfigurations$member' => NULL, ], ], 'FolderConfigurations' => [ 'base' => NULL, 'refs' => [ 'GetDefaultRetentionPolicyResponse$FolderConfigurations' => '<p>The retention policy folder configurations.</p>', 'PutRetentionPolicyRequest$FolderConfigurations' => '<p>The retention policy folder configurations.</p>', ], ], 'FolderName' => [ 'base' => NULL, 'refs' => [ 'FolderConfiguration$Name' => '<p>The folder name.</p>', ], ], 'GetAccessControlEffectRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessControlEffectResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDefaultRetentionPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDefaultRetentionPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMailboxDetailsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMailboxDetailsResponse' => [ 'base' => NULL, 'refs' => [], ], 'Group' => [ 'base' => '<p>The representation of an Amazon WorkMail group.</p>', 'refs' => [ 'Groups$member' => NULL, ], ], 'GroupName' => [ 'base' => NULL, 'refs' => [ 'CreateGroupRequest$Name' => '<p>The name of the group.</p>', 'DescribeGroupResponse$Name' => '<p>The name of the described group.</p>', 'Group$Name' => '<p>The name of the group.</p>', ], ], 'Groups' => [ 'base' => NULL, 'refs' => [ 'ListGroupsResponse$Groups' => '<p>The overview of groups for an organization.</p>', ], ], 'InvalidConfigurationException' => [ 'base' => '<p>The configuration for a resource isn\'t valid. A resource must either be able to auto-respond to requests or have at least one delegate associated that can do so on its behalf.</p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => '<p>One or more of the input parameters don\'t match the service\'s restrictions.</p>', 'refs' => [], ], 'InvalidPasswordException' => [ 'base' => '<p>The supplied password doesn\'t match the minimum security constraints, such as length or use of special characters.</p>', 'refs' => [], ], 'IpAddress' => [ 'base' => NULL, 'refs' => [ 'GetAccessControlEffectRequest$IpAddress' => '<p>The IPv4 address.</p>', ], ], 'IpRange' => [ 'base' => NULL, 'refs' => [ 'IpRangeList$member' => NULL, ], ], 'IpRangeList' => [ 'base' => NULL, 'refs' => [ 'AccessControlRule$IpRanges' => '<p>IPv4 CIDR ranges to include in the rule.</p>', 'AccessControlRule$NotIpRanges' => '<p>IPv4 CIDR ranges to exclude from the rule.</p>', 'PutAccessControlRuleRequest$IpRanges' => '<p>IPv4 CIDR ranges to include in the rule.</p>', 'PutAccessControlRuleRequest$NotIpRanges' => '<p>IPv4 CIDR ranges to exclude from the rule.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The request exceeds the limit of the resource.</p>', 'refs' => [], ], 'ListAccessControlRulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccessControlRulesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAliasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAliasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMailboxPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMailboxPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListOrganizationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListOrganizationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceDelegatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceDelegatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersResponse' => [ 'base' => NULL, 'refs' => [], ], 'MailDomainNotFoundException' => [ 'base' => '<p>For an email or alias to be created in Amazon WorkMail, the included domain must be defined in the organization.</p>', 'refs' => [], ], 'MailDomainStateException' => [ 'base' => '<p>After a domain has been added to the organization, it must be verified. The domain is not yet verified.</p>', 'refs' => [], ], 'MailboxQuota' => [ 'base' => NULL, 'refs' => [ 'GetMailboxDetailsResponse$MailboxQuota' => '<p>The maximum allowed mailbox size, in MB, for the specified user.</p>', 'UpdateMailboxQuotaRequest$MailboxQuota' => '<p>The updated mailbox quota, in MB, for the specified user.</p>', ], ], 'MailboxSize' => [ 'base' => NULL, 'refs' => [ 'GetMailboxDetailsResponse$MailboxSize' => '<p>The current mailbox size, in MB, for the specified user.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAliasesRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListGroupMembersRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListGroupsRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListMailboxPermissionsRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListOrganizationsRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListResourceDelegatesRequest$MaxResults' => '<p>The number of maximum results in a page.</p>', 'ListResourcesRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListUsersRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', ], ], 'Member' => [ 'base' => '<p>The representation of a user or group.</p>', 'refs' => [ 'Members$member' => NULL, ], ], 'MemberType' => [ 'base' => NULL, 'refs' => [ 'Delegate$Type' => '<p>The type of the delegate: user or group.</p>', 'Member$Type' => '<p>A member can be a user or group.</p>', 'Permission$GranteeType' => '<p>The type of user, group, or resource referred to in GranteeId.</p>', ], ], 'Members' => [ 'base' => NULL, 'refs' => [ 'ListGroupMembersResponse$Members' => '<p>The members associated to the group.</p>', ], ], 'NameAvailabilityException' => [ 'base' => '<p>The user, group, or resource name isn\'t unique in Amazon WorkMail.</p>', 'refs' => [], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListAliasesRequest$NextToken' => '<p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>', 'ListAliasesResponse$NextToken' => '<p>The token to use to retrieve the next page of results. The value is "null" when there are no more results to return.</p>', 'ListGroupMembersRequest$NextToken' => '<p> The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>', 'ListGroupMembersResponse$NextToken' => '<p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>', 'ListGroupsRequest$NextToken' => '<p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>', 'ListGroupsResponse$NextToken' => '<p>The token to use to retrieve the next page of results. The value is "null" when there are no more results to return.</p>', 'ListMailboxPermissionsRequest$NextToken' => '<p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>', 'ListMailboxPermissionsResponse$NextToken' => '<p>The token to use to retrieve the next page of results. The value is "null" when there are no more results to return.</p>', 'ListOrganizationsRequest$NextToken' => '<p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>', 'ListOrganizationsResponse$NextToken' => '<p>The token to use to retrieve the next page of results. The value is "null" when there are no more results to return.</p>', 'ListResourceDelegatesRequest$NextToken' => '<p>The token used to paginate through the delegates associated with a resource.</p>', 'ListResourceDelegatesResponse$NextToken' => '<p>The token used to paginate through the delegates associated with a resource. While results are still available, it has an associated value. When the last page is reached, the token is empty. </p>', 'ListResourcesRequest$NextToken' => '<p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>', 'ListResourcesResponse$NextToken' => '<p> The token used to paginate through all the organization\'s resources. While results are still available, it has an associated value. When the last page is reached, the token is empty.</p>', 'ListUsersRequest$NextToken' => '<p>The token to use to retrieve the next page of results. The first call does not contain any tokens.</p>', 'ListUsersResponse$NextToken' => '<p> The token to use to retrieve the next page of results. This value is `null` when there are no more results to return.</p>', ], ], 'OrganizationId' => [ 'base' => NULL, 'refs' => [ 'AssociateDelegateToResourceRequest$OrganizationId' => '<p>The organization under which the resource exists.</p>', 'AssociateMemberToGroupRequest$OrganizationId' => '<p>The organization under which the group exists.</p>', 'CreateAliasRequest$OrganizationId' => '<p>The organization under which the member (user or group) exists.</p>', 'CreateGroupRequest$OrganizationId' => '<p>The organization under which the group is to be created.</p>', 'CreateResourceRequest$OrganizationId' => '<p>The identifier associated with the organization for which the resource is created.</p>', 'CreateUserRequest$OrganizationId' => '<p>The identifier of the organization for which the user is created.</p>', 'DeleteAccessControlRuleRequest$OrganizationId' => '<p>The identifier for the organization.</p>', 'DeleteAliasRequest$OrganizationId' => '<p>The identifier for the organization under which the user exists.</p>', 'DeleteGroupRequest$OrganizationId' => '<p>The organization that contains the group.</p>', 'DeleteMailboxPermissionsRequest$OrganizationId' => '<p>The identifier of the organization under which the member (user or group) exists.</p>', 'DeleteResourceRequest$OrganizationId' => '<p>The identifier associated with the organization from which the resource is deleted.</p>', 'DeleteRetentionPolicyRequest$OrganizationId' => '<p>The organization ID.</p>', 'DeleteUserRequest$OrganizationId' => '<p>The organization that contains the user to be deleted.</p>', 'DeregisterFromWorkMailRequest$OrganizationId' => '<p>The identifier for the organization under which the Amazon WorkMail entity exists.</p>', 'DescribeGroupRequest$OrganizationId' => '<p>The identifier for the organization under which the group exists.</p>', 'DescribeOrganizationRequest$OrganizationId' => '<p>The identifier for the organization to be described.</p>', 'DescribeOrganizationResponse$OrganizationId' => '<p>The identifier of an organization.</p>', 'DescribeResourceRequest$OrganizationId' => '<p>The identifier associated with the organization for which the resource is described.</p>', 'DescribeUserRequest$OrganizationId' => '<p>The identifier for the organization under which the user exists.</p>', 'DisassociateDelegateFromResourceRequest$OrganizationId' => '<p>The identifier for the organization under which the resource exists.</p>', 'DisassociateMemberFromGroupRequest$OrganizationId' => '<p>The identifier for the organization under which the group exists.</p>', 'GetAccessControlEffectRequest$OrganizationId' => '<p>The identifier for the organization.</p>', 'GetDefaultRetentionPolicyRequest$OrganizationId' => '<p>The organization ID.</p>', 'GetMailboxDetailsRequest$OrganizationId' => '<p>The identifier for the organization that contains the user whose mailbox details are being requested.</p>', 'ListAccessControlRulesRequest$OrganizationId' => '<p>The identifier for the organization.</p>', 'ListAliasesRequest$OrganizationId' => '<p>The identifier for the organization under which the entity exists.</p>', 'ListGroupMembersRequest$OrganizationId' => '<p>The identifier for the organization under which the group exists.</p>', 'ListGroupsRequest$OrganizationId' => '<p>The identifier for the organization under which the groups exist.</p>', 'ListMailboxPermissionsRequest$OrganizationId' => '<p>The identifier of the organization under which the user, group, or resource exists.</p>', 'ListResourceDelegatesRequest$OrganizationId' => '<p>The identifier for the organization that contains the resource for which delegates are listed.</p>', 'ListResourcesRequest$OrganizationId' => '<p>The identifier for the organization under which the resources exist.</p>', 'ListUsersRequest$OrganizationId' => '<p>The identifier for the organization under which the users exist.</p>', 'OrganizationSummary$OrganizationId' => '<p>The identifier associated with the organization.</p>', 'PutAccessControlRuleRequest$OrganizationId' => '<p>The identifier of the organization.</p>', 'PutMailboxPermissionsRequest$OrganizationId' => '<p>The identifier of the organization under which the user, group, or resource exists.</p>', 'PutRetentionPolicyRequest$OrganizationId' => '<p>The organization ID.</p>', 'RegisterToWorkMailRequest$OrganizationId' => '<p>The identifier for the organization under which the user, group, or resource exists.</p>', 'ResetPasswordRequest$OrganizationId' => '<p>The identifier of the organization that contains the user for which the password is reset.</p>', 'UpdateMailboxQuotaRequest$OrganizationId' => '<p>The identifier for the organization that contains the user for whom to update the mailbox quota.</p>', 'UpdatePrimaryEmailAddressRequest$OrganizationId' => '<p>The organization that contains the user, group, or resource to update.</p>', 'UpdateResourceRequest$OrganizationId' => '<p>The identifier associated with the organization for which the resource is updated.</p>', ], ], 'OrganizationName' => [ 'base' => NULL, 'refs' => [ 'DescribeOrganizationResponse$Alias' => '<p>The alias for an organization.</p>', 'OrganizationSummary$Alias' => '<p>The alias associated with the organization.</p>', ], ], 'OrganizationNotFoundException' => [ 'base' => '<p>An operation received a valid organization identifier that either doesn\'t belong or exist in the system.</p>', 'refs' => [], ], 'OrganizationStateException' => [ 'base' => '<p>The organization must have a valid state (Active or Synchronizing) to perform certain operations on the organization or its members.</p>', 'refs' => [], ], 'OrganizationSummaries' => [ 'base' => NULL, 'refs' => [ 'ListOrganizationsResponse$OrganizationSummaries' => '<p>The overview of owned organizations presented as a list of organization summaries.</p>', ], ], 'OrganizationSummary' => [ 'base' => '<p>The representation of an organization.</p>', 'refs' => [ 'OrganizationSummaries$member' => NULL, ], ], 'Password' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$Password' => '<p>The password for the new user.</p>', 'ResetPasswordRequest$Password' => '<p>The new password for the user.</p>', ], ], 'Permission' => [ 'base' => '<p>Permission granted to a user, group, or resource to access a certain aspect of another user, group, or resource mailbox.</p>', 'refs' => [ 'Permissions$member' => NULL, ], ], 'PermissionType' => [ 'base' => NULL, 'refs' => [ 'PermissionValues$member' => NULL, ], ], 'PermissionValues' => [ 'base' => NULL, 'refs' => [ 'Permission$PermissionValues' => '<p>The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other folder-level permissions set on the mailbox.</p>', 'PutMailboxPermissionsRequest$PermissionValues' => '<p>The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other folder-level permissions set on the mailbox.</p>', ], ], 'Permissions' => [ 'base' => NULL, 'refs' => [ 'ListMailboxPermissionsResponse$Permissions' => '<p>One page of the user, group, or resource mailbox permissions.</p>', ], ], 'PolicyDescription' => [ 'base' => NULL, 'refs' => [ 'PutRetentionPolicyRequest$Description' => '<p>The retention policy description.</p>', ], ], 'PutAccessControlRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutAccessControlRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutMailboxPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutMailboxPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutRetentionPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutRetentionPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'RegisterToWorkMailRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterToWorkMailResponse' => [ 'base' => NULL, 'refs' => [], ], 'ReservedNameException' => [ 'base' => '<p>This user, group, or resource name is not allowed in Amazon WorkMail.</p>', 'refs' => [], ], 'ResetPasswordRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResetPasswordResponse' => [ 'base' => NULL, 'refs' => [], ], 'Resource' => [ 'base' => '<p>The representation of a resource.</p>', 'refs' => [ 'Resources$member' => NULL, ], ], 'ResourceDelegates' => [ 'base' => NULL, 'refs' => [ 'ListResourceDelegatesResponse$Delegates' => '<p>One page of the resource\'s delegates.</p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'AssociateDelegateToResourceRequest$ResourceId' => '<p>The resource for which members (users or groups) are associated.</p>', 'CreateResourceResponse$ResourceId' => '<p>The identifier of the new resource.</p>', 'DeleteResourceRequest$ResourceId' => '<p>The identifier of the resource to be deleted.</p>', 'DescribeResourceRequest$ResourceId' => '<p>The identifier of the resource to be described.</p>', 'DescribeResourceResponse$ResourceId' => '<p>The identifier of the described resource.</p>', 'DisassociateDelegateFromResourceRequest$ResourceId' => '<p>The identifier of the resource from which delegates\' set members are removed. </p>', 'UpdateResourceRequest$ResourceId' => '<p>The identifier of the resource to be updated.</p>', ], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'CreateResourceRequest$Name' => '<p>The name of the new resource.</p>', 'DescribeResourceResponse$Name' => '<p>The name of the described resource.</p>', 'Resource$Name' => '<p>The name of the resource.</p>', 'UpdateResourceRequest$Name' => '<p>The name of the resource to be updated.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource cannot be found.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'CreateResourceRequest$Type' => '<p>The type of the new resource. The available types are <code>equipment</code> and <code>room</code>.</p>', 'DescribeResourceResponse$Type' => '<p>The type of the described resource.</p>', 'Resource$Type' => '<p>The type of the resource: equipment or room.</p>', ], ], 'Resources' => [ 'base' => NULL, 'refs' => [ 'ListResourcesResponse$Resources' => '<p>One page of the organization\'s resource representation.</p>', ], ], 'RetentionAction' => [ 'base' => NULL, 'refs' => [ 'FolderConfiguration$Action' => '<p>The action to take on the folder contents at the end of the folder configuration period.</p>', ], ], 'RetentionPeriod' => [ 'base' => NULL, 'refs' => [ 'FolderConfiguration$Period' => '<p>The period of time at which the folder configuration action is applied.</p>', ], ], 'ShortString' => [ 'base' => NULL, 'refs' => [ 'DeleteRetentionPolicyRequest$Id' => '<p>The retention policy ID.</p>', 'GetDefaultRetentionPolicyResponse$Id' => '<p>The retention policy ID.</p>', 'GetDefaultRetentionPolicyResponse$Name' => '<p>The retention policy name.</p>', 'PutRetentionPolicyRequest$Id' => '<p>The retention policy ID.</p>', 'PutRetentionPolicyRequest$Name' => '<p>The retention policy name.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$DisplayName' => '<p>The display name for the new user.</p>', 'Delegate$Id' => '<p>The identifier for the user or group associated as the resource\'s delegate.</p>', 'DescribeOrganizationResponse$State' => '<p>The state of an organization.</p>', 'DescribeOrganizationResponse$DirectoryId' => '<p>The identifier for the directory associated with an Amazon WorkMail organization.</p>', 'DescribeOrganizationResponse$DirectoryType' => '<p>The type of directory associated with the WorkMail organization.</p>', 'DescribeOrganizationResponse$DefaultMailDomain' => '<p>The default mail domain associated with the organization.</p>', 'DescribeOrganizationResponse$ErrorMessage' => '<p>(Optional) The error message indicating if unexpected behavior was encountered with regards to the organization.</p>', 'DescribeUserResponse$DisplayName' => '<p>The display name of the user.</p>', 'DirectoryServiceAuthenticationFailedException$Message' => NULL, 'DirectoryUnavailableException$Message' => NULL, 'EmailAddressInUseException$Message' => NULL, 'EntityAlreadyRegisteredException$Message' => NULL, 'EntityNotFoundException$Message' => NULL, 'EntityStateException$Message' => NULL, 'GetDefaultRetentionPolicyResponse$Description' => '<p>The retention policy description.</p>', 'InvalidConfigurationException$Message' => NULL, 'InvalidParameterException$Message' => NULL, 'InvalidPasswordException$Message' => NULL, 'LimitExceededException$Message' => NULL, 'MailDomainNotFoundException$Message' => NULL, 'MailDomainStateException$Message' => NULL, 'Member$Id' => '<p>The identifier of the member.</p>', 'Member$Name' => '<p>The name of the member.</p>', 'NameAvailabilityException$Message' => NULL, 'OrganizationNotFoundException$Message' => NULL, 'OrganizationStateException$Message' => NULL, 'OrganizationSummary$ErrorMessage' => '<p>The error message associated with the organization. It is only present if unexpected behavior has occurred with regards to the organization. It provides insight or solutions regarding unexpected behavior.</p>', 'OrganizationSummary$State' => '<p>The state associated with the organization.</p>', 'ReservedNameException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'TooManyTagsException$Message' => NULL, 'UnsupportedOperationException$Message' => NULL, 'User$DisplayName' => '<p>The display name of the user.</p>', ], ], 'Tag' => [ 'base' => '<p>Describes a tag applied to a resource.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key of the tag.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The tag keys.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceResponse$Tags' => '<p>A list of tag key-value pairs.</p>', 'TagResourceRequest$Tags' => '<p>The tag key-value pairs.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value of the tag.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AccessControlRule$DateCreated' => '<p>The date that the rule was created.</p>', 'AccessControlRule$DateModified' => '<p>The date that the rule was modified.</p>', 'DescribeGroupResponse$EnabledDate' => '<p>The date and time when a user was registered to WorkMail, in UNIX epoch time format.</p>', 'DescribeGroupResponse$DisabledDate' => '<p>The date and time when a user was deregistered from WorkMail, in UNIX epoch time format.</p>', 'DescribeOrganizationResponse$CompletedDate' => '<p>The date at which the organization became usable in the WorkMail context, in UNIX epoch time format.</p>', 'DescribeResourceResponse$EnabledDate' => '<p>The date and time when a resource was enabled for WorkMail, in UNIX epoch time format.</p>', 'DescribeResourceResponse$DisabledDate' => '<p>The date and time when a resource was disabled from WorkMail, in UNIX epoch time format.</p>', 'DescribeUserResponse$EnabledDate' => '<p>The date and time at which the user was enabled for Amazon WorkMail usage, in UNIX epoch time format.</p>', 'DescribeUserResponse$DisabledDate' => '<p>The date and time at which the user was disabled for Amazon WorkMail usage, in UNIX epoch time format.</p>', 'Group$EnabledDate' => '<p>The date indicating when the group was enabled for Amazon WorkMail use.</p>', 'Group$DisabledDate' => '<p>The date indicating when the group was disabled from Amazon WorkMail use.</p>', 'Member$EnabledDate' => '<p>The date indicating when the member was enabled for Amazon WorkMail use.</p>', 'Member$DisabledDate' => '<p>The date indicating when the member was disabled from Amazon WorkMail use.</p>', 'Resource$EnabledDate' => '<p>The date indicating when the resource was enabled for Amazon WorkMail use.</p>', 'Resource$DisabledDate' => '<p>The date indicating when the resource was disabled from Amazon WorkMail use.</p>', 'User$EnabledDate' => '<p>The date indicating when the user was enabled for Amazon WorkMail use.</p>', 'User$DisabledDate' => '<p>The date indicating when the user was disabled from Amazon WorkMail use.</p>', ], ], 'TooManyTagsException' => [ 'base' => '<p>The resource can have up to 50 user-applied tags.</p>', 'refs' => [], ], 'UnsupportedOperationException' => [ 'base' => '<p>You can\'t perform a write operation against a read-only directory.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMailboxQuotaRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMailboxQuotaResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePrimaryEmailAddressRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePrimaryEmailAddressResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'User' => [ 'base' => '<p>The representation of an Amazon WorkMail user.</p>', 'refs' => [ 'Users$member' => NULL, ], ], 'UserIdList' => [ 'base' => NULL, 'refs' => [ 'AccessControlRule$UserIds' => '<p>User IDs to include in the rule.</p>', 'AccessControlRule$NotUserIds' => '<p>User IDs to exclude from the rule.</p>', 'PutAccessControlRuleRequest$UserIds' => '<p>User IDs to include in the rule.</p>', 'PutAccessControlRuleRequest$NotUserIds' => '<p>User IDs to exclude from the rule.</p>', ], ], 'UserName' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$Name' => '<p>The name for the new user. Simple AD or AD Connector user names have a maximum length of 20. All others have a maximum length of 64.</p>', 'DescribeUserResponse$Name' => '<p>The name for the user.</p>', 'User$Name' => '<p>The name of the user.</p>', ], ], 'UserRole' => [ 'base' => NULL, 'refs' => [ 'DescribeUserResponse$UserRole' => '<p>In certain cases, other entities are modeled as users. If interoperability is enabled, resources are imported into Amazon WorkMail as users. Because different WorkMail organizations rely on different directory types, administrators can distinguish between an unregistered user (account is disabled and has a user role) and the directory administrators. The values are USER, RESOURCE, and SYSTEM_USER.</p>', 'User$UserRole' => '<p>The role of the user.</p>', ], ], 'Users' => [ 'base' => NULL, 'refs' => [ 'ListUsersResponse$Users' => '<p>The overview of users for an organization.</p>', ], ], 'WorkMailIdentifier' => [ 'base' => NULL, 'refs' => [ 'AssociateDelegateToResourceRequest$EntityId' => '<p>The member (user or group) to associate to the resource.</p>', 'AssociateMemberToGroupRequest$GroupId' => '<p>The group to which the member (user or group) is associated.</p>', 'AssociateMemberToGroupRequest$MemberId' => '<p>The member (user or group) to associate to the group.</p>', 'CreateAliasRequest$EntityId' => '<p>The member (user or group) to which this alias is added.</p>', 'CreateGroupResponse$GroupId' => '<p>The identifier of the group.</p>', 'CreateUserResponse$UserId' => '<p>The identifier for the new user.</p>', 'DeleteAliasRequest$EntityId' => '<p>The identifier for the member (user or group) from which to have the aliases removed.</p>', 'DeleteGroupRequest$GroupId' => '<p>The identifier of the group to be deleted.</p>', 'DeleteMailboxPermissionsRequest$EntityId' => '<p>The identifier of the member (user or group)that owns the mailbox.</p>', 'DeleteMailboxPermissionsRequest$GranteeId' => '<p>The identifier of the member (user or group) for which to delete granted permissions.</p>', 'DeleteUserRequest$UserId' => '<p>The identifier of the user to be deleted.</p>', 'DeregisterFromWorkMailRequest$EntityId' => '<p>The identifier for the member (user or group) to be updated.</p>', 'DescribeGroupRequest$GroupId' => '<p>The identifier for the group to be described.</p>', 'DescribeGroupResponse$GroupId' => '<p>The identifier of the described group.</p>', 'DescribeUserRequest$UserId' => '<p>The identifier for the user to be described.</p>', 'DescribeUserResponse$UserId' => '<p>The identifier for the described user.</p>', 'DisassociateDelegateFromResourceRequest$EntityId' => '<p>The identifier for the member (user, group) to be removed from the resource\'s delegates.</p>', 'DisassociateMemberFromGroupRequest$GroupId' => '<p>The identifier for the group from which members are removed.</p>', 'DisassociateMemberFromGroupRequest$MemberId' => '<p>The identifier for the member to be removed to the group.</p>', 'GetAccessControlEffectRequest$UserId' => '<p>The user ID.</p>', 'GetMailboxDetailsRequest$UserId' => '<p>The identifier for the user whose mailbox details are being requested.</p>', 'Group$Id' => '<p>The identifier of the group.</p>', 'ListAliasesRequest$EntityId' => '<p>The identifier for the entity for which to list the aliases.</p>', 'ListGroupMembersRequest$GroupId' => '<p>The identifier for the group to which the members (users or groups) are associated.</p>', 'ListMailboxPermissionsRequest$EntityId' => '<p>The identifier of the user, group, or resource for which to list mailbox permissions.</p>', 'ListResourceDelegatesRequest$ResourceId' => '<p>The identifier for the resource whose delegates are listed.</p>', 'Permission$GranteeId' => '<p>The identifier of the user, group, or resource to which the permissions are granted.</p>', 'PutMailboxPermissionsRequest$EntityId' => '<p>The identifier of the user, group, or resource for which to update mailbox permissions.</p>', 'PutMailboxPermissionsRequest$GranteeId' => '<p>The identifier of the user, group, or resource to which to grant the permissions.</p>', 'RegisterToWorkMailRequest$EntityId' => '<p>The identifier for the user, group, or resource to be updated.</p>', 'ResetPasswordRequest$UserId' => '<p>The identifier of the user for whom the password is reset.</p>', 'Resource$Id' => '<p>The identifier of the resource.</p>', 'UpdateMailboxQuotaRequest$UserId' => '<p>The identifer for the user for whom to update the mailbox quota.</p>', 'UpdatePrimaryEmailAddressRequest$EntityId' => '<p>The user, group, or resource to update.</p>', 'User$Id' => '<p>The identifier of the user.</p>', 'UserIdList$member' => NULL, ], ], ],];
