<?php
// This file was auto-generated from sdk-root/src/data/transcribe/2017-10-26/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Operations and objects for transcribing speech to text.</p>', 'operations' => [ 'CreateLanguageModel' => '<p>Creates a new custom language model. Use Amazon S3 prefixes to provide the location of your input files. The time it takes to create your model depends on the size of your training data.</p>', 'CreateMedicalVocabulary' => '<p>Creates a new custom vocabulary that you can use to change how Amazon Transcribe Medical transcribes your audio file.</p>', 'CreateVocabulary' => '<p>Creates a new custom vocabulary that you can use to change the way Amazon Transcribe handles transcription of an audio file. </p>', 'CreateVocabularyFilter' => '<p>Creates a new vocabulary filter that you can use to filter words, such as profane words, from the output of a transcription job.</p>', 'DeleteLanguageModel' => '<p>Deletes a custom language model using its name.</p>', 'DeleteMedicalTranscriptionJob' => '<p>Deletes a transcription job generated by Amazon Transcribe Medical and any related information.</p>', 'DeleteMedicalVocabulary' => '<p>Deletes a vocabulary from Amazon Transcribe Medical.</p>', 'DeleteTranscriptionJob' => '<p>Deletes a previously submitted transcription job along with any other generated results such as the transcription, models, and so on.</p>', 'DeleteVocabulary' => '<p>Deletes a vocabulary from Amazon Transcribe. </p>', 'DeleteVocabularyFilter' => '<p>Removes a vocabulary filter.</p>', 'DescribeLanguageModel' => '<p>Gets information about a single custom language model. Use this information to see details about the language model in your AWS account. You can also see whether the base language model used to create your custom language model has been updated. If Amazon Transcribe has updated the base model, you can create a new custom language model using the updated base model. If the language model wasn\'t created, you can use this operation to understand why Amazon Transcribe couldn\'t create it. </p>', 'GetMedicalTranscriptionJob' => '<p>Returns information about a transcription job from Amazon Transcribe Medical. To see the status of the job, check the <code>TranscriptionJobStatus</code> field. If the status is <code>COMPLETED</code>, the job is finished. You find the results of the completed job in the <code>TranscriptFileUri</code> field.</p>', 'GetMedicalVocabulary' => '<p>Retrieves information about a medical vocabulary.</p>', 'GetTranscriptionJob' => '<p>Returns information about a transcription job. To see the status of the job, check the <code>TranscriptionJobStatus</code> field. If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location specified in the <code>TranscriptFileUri</code> field. If you enable content redaction, the redacted transcript appears in <code>RedactedTranscriptFileUri</code>.</p>', 'GetVocabulary' => '<p>Gets information about a vocabulary. </p>', 'GetVocabularyFilter' => '<p>Returns information about a vocabulary filter.</p>', 'ListLanguageModels' => '<p>Provides more information about the custom language models you\'ve created. You can use the information in this list to find a specific custom language model. You can then use the operation to get more information about it.</p>', 'ListMedicalTranscriptionJobs' => '<p>Lists medical transcription jobs with a specified status or substring that matches their names.</p>', 'ListMedicalVocabularies' => '<p>Returns a list of vocabularies that match the specified criteria. If you don\'t enter a value in any of the request parameters, returns the entire list of vocabularies.</p>', 'ListTranscriptionJobs' => '<p>Lists transcription jobs with the specified status.</p>', 'ListVocabularies' => '<p>Returns a list of vocabularies that match the specified criteria. If no criteria are specified, returns the entire list of vocabularies.</p>', 'ListVocabularyFilters' => '<p>Gets information about vocabulary filters.</p>', 'StartMedicalTranscriptionJob' => '<p>Starts a batch job to transcribe medical speech to text.</p>', 'StartTranscriptionJob' => '<p>Starts an asynchronous job to transcribe speech to text. </p>', 'UpdateMedicalVocabulary' => '<p>Updates a vocabulary with new values that you provide in a different text file from the one you used to create the vocabulary. The <code>UpdateMedicalVocabulary</code> operation overwrites all of the existing information with the values that you provide in the request.</p>', 'UpdateVocabulary' => '<p>Updates an existing vocabulary with new values. The <code>UpdateVocabulary</code> operation overwrites all of the existing information with the values that you provide in the request. </p>', 'UpdateVocabularyFilter' => '<p>Updates a vocabulary filter with a new list of filtered words.</p>', ], 'shapes' => [ 'BadRequestException' => [ 'base' => '<p>Your request didn\'t pass one or more validation tests. For example, if the entity that you\'re trying to delete doesn\'t exist or if it is in a non-terminal state (for example, it\'s "in progress"). See the exception <code>Message</code> field for more information.</p>', 'refs' => [], ], 'BaseModelName' => [ 'base' => NULL, 'refs' => [ 'CreateLanguageModelRequest$BaseModelName' => '<p>The Amazon Transcribe standard language model, or base model used to create your custom language model.</p> <p>If you want to use your custom language model to transcribe audio with a sample rate of 16 kHz or greater, choose <code>Wideband</code>.</p> <p>If you want to use your custom language model to transcribe audio with a sample rate that is less than 16 kHz, choose <code>Narrowband</code>.</p>', 'CreateLanguageModelResponse$BaseModelName' => '<p>The Amazon Transcribe standard language model, or base model you\'ve used to create a custom language model.</p>', 'LanguageModel$BaseModelName' => '<p>The Amazon Transcribe standard language model, or base model used to create the custom language model.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'JobExecutionSettings$AllowDeferredExecution' => '<p>Indicates whether a job should be queued by Amazon Transcribe when the concurrent execution limit is exceeded. When the <code>AllowDeferredExecution</code> field is true, jobs are queued and executed when the number of executing jobs falls below the concurrent execution limit. If the field is false, Amazon Transcribe returns a <code>LimitExceededException</code> exception.</p> <p>If you specify the <code>AllowDeferredExecution</code> field, you must specify the <code>DataAccessRoleArn</code> field.</p>', 'LanguageModel$UpgradeAvailability' => '<p>Whether the base model used for the custom language model is up to date. If this field is <code>true</code> then you are running the most up-to-date version of the base model in your custom language model.</p>', 'MedicalTranscriptionSetting$ShowSpeakerLabels' => '<p>Determines whether the transcription job uses speaker recognition to identify different speakers in the input audio. Speaker recognition labels individual speakers in the audio file. If you set the <code>ShowSpeakerLabels</code> field to true, you must also set the maximum number of speaker labels in the <code>MaxSpeakerLabels</code> field.</p> <p>You can\'t set both <code>ShowSpeakerLabels</code> and <code>ChannelIdentification</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>', 'MedicalTranscriptionSetting$ChannelIdentification' => '<p>Instructs Amazon Transcribe Medical to process each audio channel separately and then merge the transcription output of each channel into a single transcription.</p> <p>Amazon Transcribe Medical also produces a transcription of each item detected on an audio channel, including the start time and end time of the item and alternative transcriptions of item. The alternative transcriptions also come with confidence scores provided by Amazon Transcribe Medical.</p> <p>You can\'t set both <code>ShowSpeakerLabels</code> and <code>ChannelIdentification</code> in the same request. If you set both, your request returns a <code>BadRequestException</code> </p>', 'MedicalTranscriptionSetting$ShowAlternatives' => '<p>Determines whether alternative transcripts are generated along with the transcript that has the highest confidence. If you set <code>ShowAlternatives</code> field to true, you must also set the maximum number of alternatives to return in the <code>MaxAlternatives</code> field.</p>', 'Settings$ShowSpeakerLabels' => '<p>Determines whether the transcription job uses speaker recognition to identify different speakers in the input audio. Speaker recognition labels individual speakers in the audio file. If you set the <code>ShowSpeakerLabels</code> field to true, you must also set the maximum number of speaker labels <code>MaxSpeakerLabels</code> field.</p> <p>You can\'t set both <code>ShowSpeakerLabels</code> and <code>ChannelIdentification</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>', 'Settings$ChannelIdentification' => '<p>Instructs Amazon Transcribe to process each audio channel separately and then merge the transcription output of each channel into a single transcription. </p> <p>Amazon Transcribe also produces a transcription of each item detected on an audio channel, including the start time and end time of the item and alternative transcriptions of the item including the confidence that Amazon Transcribe has in the transcription.</p> <p>You can\'t set both <code>ShowSpeakerLabels</code> and <code>ChannelIdentification</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>', 'Settings$ShowAlternatives' => '<p>Determines whether the transcription contains alternative transcriptions. If you set the <code>ShowAlternatives</code> field to true, you must also set the maximum number of alternatives to return in the <code>MaxAlternatives</code> field.</p>', ], ], 'CLMLanguageCode' => [ 'base' => NULL, 'refs' => [ 'CreateLanguageModelRequest$LanguageCode' => '<p>The language of the input text you\'re using to train your custom language model.</p>', 'CreateLanguageModelResponse$LanguageCode' => '<p>The language code of the text you\'ve used to create a custom language model.</p>', 'LanguageModel$LanguageCode' => '<p>The language code you used to create your custom language model.</p>', ], ], 'ConflictException' => [ 'base' => '<p>There is already a resource with that name.</p>', 'refs' => [], ], 'ContentRedaction' => [ 'base' => '<p>Settings for content redaction within a transcription job.</p>', 'refs' => [ 'StartTranscriptionJobRequest$ContentRedaction' => '<p>An object that contains the request parameters for content redaction.</p>', 'TranscriptionJob$ContentRedaction' => '<p>An object that describes content redaction settings for the transcription job.</p>', 'TranscriptionJobSummary$ContentRedaction' => '<p>The content redaction settings of the transcription job.</p>', ], ], 'CreateLanguageModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLanguageModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateMedicalVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMedicalVocabularyResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateVocabularyFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVocabularyFilterResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVocabularyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DataAccessRoleArn' => [ 'base' => NULL, 'refs' => [ 'InputDataConfig$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) that uniquely identifies the permissions you\'ve given Amazon Transcribe to access your Amazon S3 buckets containing your media files or text data.</p>', 'JobExecutionSettings$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of a role that has access to the S3 bucket that contains the input files. Amazon Transcribe assumes this role to read queued media files. If you have specified an output S3 bucket for the transcription results, this role should have access to the output bucket as well.</p> <p>If you specify the <code>AllowDeferredExecution</code> field, you must specify the <code>DataAccessRoleArn</code> field.</p>', ], ], 'DateTime' => [ 'base' => NULL, 'refs' => [ 'CreateMedicalVocabularyResponse$LastModifiedTime' => '<p>The date and time that you created the vocabulary.</p>', 'CreateVocabularyFilterResponse$LastModifiedTime' => '<p>The date and time that the vocabulary filter was modified.</p>', 'CreateVocabularyResponse$LastModifiedTime' => '<p>The date and time that the vocabulary was created.</p>', 'GetMedicalVocabularyResponse$LastModifiedTime' => '<p>The date and time that the vocabulary was last modified with a text file different from the one that was previously used.</p>', 'GetVocabularyFilterResponse$LastModifiedTime' => '<p>The date and time that the contents of the vocabulary filter were updated.</p>', 'GetVocabularyResponse$LastModifiedTime' => '<p>The date and time that the vocabulary was last modified.</p>', 'LanguageModel$CreateTime' => '<p>The time the custom language model was created.</p>', 'LanguageModel$LastModifiedTime' => '<p>The most recent time the custom language model was modified.</p>', 'MedicalTranscriptionJob$StartTime' => '<p>A timestamp that shows when the job started processing.</p>', 'MedicalTranscriptionJob$CreationTime' => '<p>A timestamp that shows when the job was created.</p>', 'MedicalTranscriptionJob$CompletionTime' => '<p>A timestamp that shows when the job was completed.</p>', 'MedicalTranscriptionJobSummary$CreationTime' => '<p>A timestamp that shows when the medical transcription job was created.</p>', 'MedicalTranscriptionJobSummary$StartTime' => '<p>A timestamp that shows when the job began processing.</p>', 'MedicalTranscriptionJobSummary$CompletionTime' => '<p>A timestamp that shows when the job was completed.</p>', 'TranscriptionJob$StartTime' => '<p>A timestamp that shows with the job was started processing.</p>', 'TranscriptionJob$CreationTime' => '<p>A timestamp that shows when the job was created.</p>', 'TranscriptionJob$CompletionTime' => '<p>A timestamp that shows when the job was completed.</p>', 'TranscriptionJobSummary$CreationTime' => '<p>A timestamp that shows when the job was created.</p>', 'TranscriptionJobSummary$StartTime' => '<p>A timestamp that shows when the job started processing.</p>', 'TranscriptionJobSummary$CompletionTime' => '<p>A timestamp that shows when the job was completed.</p>', 'UpdateMedicalVocabularyResponse$LastModifiedTime' => '<p>The date and time that the vocabulary was updated.</p>', 'UpdateVocabularyFilterResponse$LastModifiedTime' => '<p>The date and time that the vocabulary filter was updated.</p>', 'UpdateVocabularyResponse$LastModifiedTime' => '<p>The date and time that the vocabulary was updated.</p>', 'VocabularyFilterInfo$LastModifiedTime' => '<p>The date and time that the vocabulary was last updated.</p>', 'VocabularyInfo$LastModifiedTime' => '<p>The date and time that the vocabulary was last modified.</p>', ], ], 'DeleteLanguageModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMedicalTranscriptionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMedicalVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTranscriptionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVocabularyFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLanguageModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLanguageModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'FailureReason' => [ 'base' => NULL, 'refs' => [ 'BadRequestException$Message' => NULL, 'CreateMedicalVocabularyResponse$FailureReason' => '<p>If the <code>VocabularyState</code> field is <code>FAILED</code>, this field contains information about why the job failed.</p>', 'CreateVocabularyResponse$FailureReason' => '<p>If the <code>VocabularyState</code> field is <code>FAILED</code>, this field contains information about why the job failed.</p>', 'GetMedicalVocabularyResponse$FailureReason' => '<p>If the <code>VocabularyState</code> is <code>FAILED</code>, this field contains information about why the job failed.</p>', 'GetVocabularyResponse$FailureReason' => '<p>If the <code>VocabularyState</code> field is <code>FAILED</code>, this field contains information about why the job failed.</p>', 'LanguageModel$FailureReason' => '<p>The reason why the custom language model couldn\'t be created.</p>', 'MedicalTranscriptionJob$FailureReason' => '<p>If the <code>TranscriptionJobStatus</code> field is <code>FAILED</code>, this field contains information about why the job failed.</p> <p>The <code>FailureReason</code> field contains one of the following values:</p> <ul> <li> <p> <code>Unsupported media format</code>- The media format specified in the <code>MediaFormat</code> field of the request isn\'t valid. See the description of the <code>MediaFormat</code> field for a list of valid values.</p> </li> <li> <p> <code>The media format provided does not match the detected media format</code>- The media format of the audio file doesn\'t match the format specified in the <code>MediaFormat</code> field in the request. Check the media format of your media file and make sure the two values match.</p> </li> <li> <p> <code>Invalid sample rate for audio file</code>- The sample rate specified in the <code>MediaSampleRateHertz</code> of the request isn\'t valid. The sample rate must be between 8000 and 48000 Hertz.</p> </li> <li> <p> <code>The sample rate provided does not match the detected sample rate</code>- The sample rate in the audio file doesn\'t match the sample rate specified in the <code>MediaSampleRateHertz</code> field in the request. Check the sample rate of your media file and make sure that the two values match.</p> </li> <li> <p> <code>Invalid file size: file size too large</code>- The size of your audio file is larger than what Amazon Transcribe Medical can process. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/limits-guidelines.html#limits">Guidelines and Quotas</a> in the <i>Amazon Transcribe Medical Guide</i> </p> </li> <li> <p> <code>Invalid number of channels: number of channels too large</code>- Your audio contains more channels than Amazon Transcribe Medical is configured to process. To request additional channels, see <a href="https://docs.aws.amazon.com/general/latest/gr/transcribe-medical.html">Amazon Transcribe Medical Endpoints and Quotas</a> in the <i>Amazon Web Services General Reference</i> </p> </li> </ul>', 'MedicalTranscriptionJobSummary$FailureReason' => '<p>If the <code>TranscriptionJobStatus</code> field is <code>FAILED</code>, a description of the error.</p>', 'TranscriptionJob$FailureReason' => '<p>If the <code>TranscriptionJobStatus</code> field is <code>FAILED</code>, this field contains information about why the job failed.</p> <p>The <code>FailureReason</code> field can contain one of the following values:</p> <ul> <li> <p> <code>Unsupported media format</code> - The media format specified in the <code>MediaFormat</code> field of the request isn\'t valid. See the description of the <code>MediaFormat</code> field for a list of valid values.</p> </li> <li> <p> <code>The media format provided does not match the detected media format</code> - The media format of the audio file doesn\'t match the format specified in the <code>MediaFormat</code> field in the request. Check the media format of your media file and make sure that the two values match.</p> </li> <li> <p> <code>Invalid sample rate for audio file</code> - The sample rate specified in the <code>MediaSampleRateHertz</code> of the request isn\'t valid. The sample rate must be between 8000 and 48000 Hertz.</p> </li> <li> <p> <code>The sample rate provided does not match the detected sample rate</code> - The sample rate in the audio file doesn\'t match the sample rate specified in the <code>MediaSampleRateHertz</code> field in the request. Check the sample rate of your media file and make sure that the two values match.</p> </li> <li> <p> <code>Invalid file size: file size too large</code> - The size of your audio file is larger than Amazon Transcribe can process. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/limits-guidelines.html#limits">Limits</a> in the <i>Amazon Transcribe Developer Guide</i>.</p> </li> <li> <p> <code>Invalid number of channels: number of channels too large</code> - Your audio contains more channels than Amazon Transcribe is configured to process. To request additional channels, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits-amazon-transcribe">Amazon Transcribe Limits</a> in the <i>Amazon Web Services General Reference</i>.</p> </li> </ul>', 'TranscriptionJobSummary$FailureReason' => '<p>If the <code>TranscriptionJobStatus</code> field is <code>FAILED</code>, a description of the error.</p>', ], ], 'GetMedicalTranscriptionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMedicalTranscriptionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMedicalVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMedicalVocabularyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTranscriptionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTranscriptionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVocabularyFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVocabularyFilterResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVocabularyResponse' => [ 'base' => NULL, 'refs' => [], ], 'InputDataConfig' => [ 'base' => '<p>The object that contains the Amazon S3 object location and access role required to train and tune your custom language model.</p>', 'refs' => [ 'CreateLanguageModelRequest$InputDataConfig' => '<p>Contains the data access role and the Amazon S3 prefixes to read the required input files to create a custom language model.</p>', 'CreateLanguageModelResponse$InputDataConfig' => '<p>The data access role and Amazon S3 prefixes you\'ve chosen to create your custom language model.</p>', 'LanguageModel$InputDataConfig' => '<p>The data access role and Amazon S3 prefixes for the input files used to train the custom language model.</p>', ], ], 'InternalFailureException' => [ 'base' => '<p>There was an internal error. Check the error message and try your request again.</p>', 'refs' => [], ], 'JobExecutionSettings' => [ 'base' => '<p>Provides information about when a transcription job should be executed.</p>', 'refs' => [ 'StartTranscriptionJobRequest$JobExecutionSettings' => '<p>Provides information about how a transcription job is executed. Use this field to indicate that the job can be queued for deferred execution if the concurrency limit is reached and there are no slots available to immediately run the job.</p>', 'TranscriptionJob$JobExecutionSettings' => '<p>Provides information about how a transcription job is executed.</p>', ], ], 'KMSKeyId' => [ 'base' => NULL, 'refs' => [ 'StartMedicalTranscriptionJobRequest$OutputEncryptionKMSKeyId' => '<p>The Amazon Resource Name (ARN) of the AWS Key Management Service (KMS) key used to encrypt the output of the transcription job. The user calling the <a>StartMedicalTranscriptionJob</a> operation must have permission to use the specified KMS key.</p> <p>You use either of the following to identify a KMS key in the current account:</p> <ul> <li> <p>KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"</p> </li> <li> <p>KMS Key Alias: "alias/ExampleAlias"</p> </li> </ul> <p>You can use either of the following to identify a KMS key in the current account or another account:</p> <ul> <li> <p>Amazon Resource Name (ARN) of a KMS key in the current account or another account: "arn:aws:kms:region:account ID:key/1234abcd-12ab-34cd-56ef-1234567890ab"</p> </li> <li> <p>ARN of a KMS Key Alias: "arn:aws:kms:region:account ID:alias/ExampleAlias"</p> </li> </ul> <p>If you don\'t specify an encryption key, the output of the medical transcription job is encrypted with the default Amazon S3 key (SSE-S3).</p> <p>If you specify a KMS key to encrypt your output, you must also specify an output location in the <code>OutputBucketName</code> parameter.</p>', 'StartTranscriptionJobRequest$OutputEncryptionKMSKeyId' => '<p>The Amazon Resource Name (ARN) of the AWS Key Management Service (KMS) key used to encrypt the output of the transcription job. The user calling the <code>StartTranscriptionJob</code> operation must have permission to use the specified KMS key.</p> <p>You can use either of the following to identify a KMS key in the current account:</p> <ul> <li> <p>KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"</p> </li> <li> <p>KMS Key Alias: "alias/ExampleAlias"</p> </li> </ul> <p>You can use either of the following to identify a KMS key in the current account or another account:</p> <ul> <li> <p>Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:region:account ID:key/1234abcd-12ab-34cd-56ef-1234567890ab"</p> </li> <li> <p>ARN of a KMS Key Alias: "arn:aws:kms:region:account ID:alias/ExampleAlias"</p> </li> </ul> <p>If you don\'t specify an encryption key, the output of the transcription job is encrypted with the default Amazon S3 key (SSE-S3). </p> <p>If you specify a KMS key to encrypt your output, you must also specify an output location in the <code>OutputBucketName</code> parameter.</p>', ], ], 'LanguageCode' => [ 'base' => NULL, 'refs' => [ 'CreateMedicalVocabularyRequest$LanguageCode' => '<p>The language code for the language used for the entries in your custom vocabulary. The language code of your custom vocabulary must match the language code of your transcription job. US English (en-US) is the only language code available for Amazon Transcribe Medical.</p>', 'CreateMedicalVocabularyResponse$LanguageCode' => '<p>The language code for the entries in your custom vocabulary. US English (en-US) is the only valid language code for Amazon Transcribe Medical.</p>', 'CreateVocabularyFilterRequest$LanguageCode' => '<p>The language code of the words in the vocabulary filter. All words in the filter must be in the same language. The vocabulary filter can only be used with transcription jobs in the specified language.</p>', 'CreateVocabularyFilterResponse$LanguageCode' => '<p>The language code of the words in the collection.</p>', 'CreateVocabularyRequest$LanguageCode' => '<p>The language code of the vocabulary entries.</p>', 'CreateVocabularyResponse$LanguageCode' => '<p>The language code of the vocabulary entries.</p>', 'GetMedicalVocabularyResponse$LanguageCode' => '<p>The valid language code for your vocabulary entries.</p>', 'GetVocabularyFilterResponse$LanguageCode' => '<p>The language code of the words in the vocabulary filter.</p>', 'GetVocabularyResponse$LanguageCode' => '<p>The language code of the vocabulary entries.</p>', 'MedicalTranscriptionJob$LanguageCode' => '<p>The language code for the language spoken in the source audio file. US English (en-US) is the only supported language for medical transcriptions. Any other value you enter for language code results in a <code>BadRequestException</code> error.</p>', 'MedicalTranscriptionJobSummary$LanguageCode' => '<p>The language of the transcript in the source audio file.</p>', 'StartMedicalTranscriptionJobRequest$LanguageCode' => '<p>The language code for the language spoken in the input media file. US English (en-US) is the valid value for medical transcription jobs. Any other value you enter for language code results in a <code>BadRequestException</code> error.</p>', 'StartTranscriptionJobRequest$LanguageCode' => '<p>The language code for the language used in the input media file.</p>', 'TranscriptionJob$LanguageCode' => '<p>The language code for the input speech.</p>', 'TranscriptionJobSummary$LanguageCode' => '<p>The language code for the input speech.</p>', 'UpdateMedicalVocabularyRequest$LanguageCode' => '<p>The language code of the language used for the entries in the updated vocabulary. US English (en-US) is the only valid language code in Amazon Transcribe Medical.</p>', 'UpdateMedicalVocabularyResponse$LanguageCode' => '<p>The language code for the language of the text file used to update the custom vocabulary. US English (en-US) is the only language supported in Amazon Transcribe Medical.</p>', 'UpdateVocabularyFilterResponse$LanguageCode' => '<p>The language code of the words in the vocabulary filter.</p>', 'UpdateVocabularyRequest$LanguageCode' => '<p>The language code of the vocabulary entries.</p>', 'UpdateVocabularyResponse$LanguageCode' => '<p>The language code of the vocabulary entries.</p>', 'VocabularyFilterInfo$LanguageCode' => '<p>The language code of the words in the vocabulary filter.</p>', 'VocabularyInfo$LanguageCode' => '<p>The language code of the vocabulary entries.</p>', ], ], 'LanguageModel' => [ 'base' => '<p>The structure used to describe a custom language model.</p>', 'refs' => [ 'DescribeLanguageModelResponse$LanguageModel' => '<p>The name of the custom language model you requested more information about.</p>', 'Models$member' => NULL, ], ], 'LimitExceededException' => [ 'base' => '<p>Either you have sent too many requests or your input file is too long. Wait before you resend your request, or use a smaller file and resend the request.</p>', 'refs' => [], ], 'ListLanguageModelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLanguageModelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMedicalTranscriptionJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMedicalTranscriptionJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMedicalVocabulariesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMedicalVocabulariesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTranscriptionJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTranscriptionJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListVocabulariesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListVocabulariesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListVocabularyFiltersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListVocabularyFiltersResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxAlternatives' => [ 'base' => NULL, 'refs' => [ 'MedicalTranscriptionSetting$MaxAlternatives' => '<p>The maximum number of alternatives that you tell the service to return. If you specify the <code>MaxAlternatives</code> field, you must set the <code>ShowAlternatives</code> field to true.</p>', 'Settings$MaxAlternatives' => '<p>The number of alternative transcriptions that the service should return. If you specify the <code>MaxAlternatives</code> field, you must set the <code>ShowAlternatives</code> field to true.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListLanguageModelsRequest$MaxResults' => '<p>The maximum number of language models to return in the response. If there are fewer results in the list, the response contains only the actual results.</p>', 'ListMedicalTranscriptionJobsRequest$MaxResults' => '<p>The maximum number of medical transcription jobs to return in the response. IF there are fewer results in the list, this response contains only the actual results.</p>', 'ListMedicalVocabulariesRequest$MaxResults' => '<p>The maximum number of vocabularies to return in the response.</p>', 'ListTranscriptionJobsRequest$MaxResults' => '<p>The maximum number of jobs to return in the response. If there are fewer results in the list, this response contains only the actual results.</p>', 'ListVocabulariesRequest$MaxResults' => '<p>The maximum number of vocabularies to return in the response. If there are fewer results in the list, this response contains only the actual results.</p>', 'ListVocabularyFiltersRequest$MaxResults' => '<p>The maximum number of filters to return in the response. If there are fewer results in the list, this response contains only the actual results.</p>', ], ], 'MaxSpeakers' => [ 'base' => NULL, 'refs' => [ 'MedicalTranscriptionSetting$MaxSpeakerLabels' => '<p>The maximum number of speakers to identify in the input audio. If there are more speakers in the audio than this number, multiple speakers are identified as a single speaker. If you specify the <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code> field to true.</p>', 'Settings$MaxSpeakerLabels' => '<p>The maximum number of speakers to identify in the input audio. If there are more speakers in the audio than this number, multiple speakers are identified as a single speaker. If you specify the <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code> field to true.</p>', ], ], 'Media' => [ 'base' => '<p>Describes the input media file in a transcription request.</p>', 'refs' => [ 'MedicalTranscriptionJob$Media' => NULL, 'StartMedicalTranscriptionJobRequest$Media' => NULL, 'StartTranscriptionJobRequest$Media' => '<p>An object that describes the input media for a transcription job.</p>', 'TranscriptionJob$Media' => '<p>An object that describes the input media for the transcription job.</p>', ], ], 'MediaFormat' => [ 'base' => NULL, 'refs' => [ 'MedicalTranscriptionJob$MediaFormat' => '<p>The format of the input media file.</p>', 'StartMedicalTranscriptionJobRequest$MediaFormat' => '<p>The audio format of the input media file.</p>', 'StartTranscriptionJobRequest$MediaFormat' => '<p>The format of the input media file.</p>', 'TranscriptionJob$MediaFormat' => '<p>The format of the input media file.</p>', ], ], 'MediaSampleRateHertz' => [ 'base' => NULL, 'refs' => [ 'MedicalTranscriptionJob$MediaSampleRateHertz' => '<p>The sample rate, in Hertz, of the source audio containing medical information.</p> <p>If you don\'t specify the sample rate, Amazon Transcribe Medical determines it for you. If you choose to specify the sample rate, it must match the rate detected by Amazon Transcribe Medical. In most cases, you should leave the <code>MediaSampleHertz</code> blank and let Amazon Transcribe Medical determine the sample rate.</p>', 'StartMedicalTranscriptionJobRequest$MediaSampleRateHertz' => '<p>The sample rate, in Hertz, of the audio track in the input media file.</p> <p>If you do not specify the media sample rate, Amazon Transcribe Medical determines the sample rate. If you specify the sample rate, it must match the rate detected by Amazon Transcribe Medical. In most cases, you should leave the <code>MediaSampleRateHertz</code> field blank and let Amazon Transcribe Medical determine the sample rate.</p>', 'StartTranscriptionJobRequest$MediaSampleRateHertz' => '<p>The sample rate, in Hertz, of the audio track in the input media file. </p> <p>If you do not specify the media sample rate, Amazon Transcribe determines the sample rate. If you specify the sample rate, it must match the sample rate detected by Amazon Transcribe. In most cases, you should leave the <code>MediaSampleRateHertz</code> field blank and let Amazon Transcribe determine the sample rate.</p>', 'TranscriptionJob$MediaSampleRateHertz' => '<p>The sample rate, in Hertz, of the audio track in the input media file. </p>', ], ], 'MedicalTranscript' => [ 'base' => '<p>Identifies the location of a medical transcript.</p>', 'refs' => [ 'MedicalTranscriptionJob$Transcript' => '<p>An object that contains the <code>MedicalTranscript</code>. The <code>MedicalTranscript</code> contains the <code>TranscriptFileUri</code>.</p>', ], ], 'MedicalTranscriptionJob' => [ 'base' => '<p>The data structure that contains the information for a medical transcription job.</p>', 'refs' => [ 'GetMedicalTranscriptionJobResponse$MedicalTranscriptionJob' => '<p>An object that contains the results of the medical transcription job.</p>', 'StartMedicalTranscriptionJobResponse$MedicalTranscriptionJob' => '<p>A batch job submitted to transcribe medical speech to text.</p>', ], ], 'MedicalTranscriptionJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListMedicalTranscriptionJobsResponse$MedicalTranscriptionJobSummaries' => '<p>A list of objects containing summary information for a transcription job.</p>', ], ], 'MedicalTranscriptionJobSummary' => [ 'base' => '<p>Provides summary information about a transcription job.</p>', 'refs' => [ 'MedicalTranscriptionJobSummaries$member' => NULL, ], ], 'MedicalTranscriptionSetting' => [ 'base' => '<p>Optional settings for the <a>StartMedicalTranscriptionJob</a> operation.</p>', 'refs' => [ 'MedicalTranscriptionJob$Settings' => '<p>Object that contains object.</p>', 'StartMedicalTranscriptionJobRequest$Settings' => '<p>Optional settings for the medical transcription job.</p>', ], ], 'ModelName' => [ 'base' => NULL, 'refs' => [ 'CreateLanguageModelRequest$ModelName' => '<p>The name you choose for your custom language model when you create it.</p>', 'CreateLanguageModelResponse$ModelName' => '<p>The name you\'ve chosen for your custom language model.</p>', 'DeleteLanguageModelRequest$ModelName' => '<p>The name of the model you\'re choosing to delete.</p>', 'DescribeLanguageModelRequest$ModelName' => '<p>The name of the custom language model you submit to get more information.</p>', 'LanguageModel$ModelName' => '<p>The name of the custom language model.</p>', 'ListLanguageModelsRequest$NameContains' => '<p>When specified, the custom language model names returned contain the substring you\'ve specified.</p>', 'ModelSettings$LanguageModelName' => '<p>The name of your custom language model.</p>', ], ], 'ModelSettings' => [ 'base' => '<p>The object used to call your custom language model to your transcription job.</p>', 'refs' => [ 'StartTranscriptionJobRequest$ModelSettings' => '<p>Choose the custom language model you use for your transcription job in this parameter.</p>', 'TranscriptionJob$ModelSettings' => '<p>An object containing the details of your custom language model.</p>', 'TranscriptionJobSummary$ModelSettings' => NULL, ], ], 'ModelStatus' => [ 'base' => NULL, 'refs' => [ 'CreateLanguageModelResponse$ModelStatus' => '<p>The status of the custom language model. When the status is <code>COMPLETED</code> the model is ready to use.</p>', 'LanguageModel$ModelStatus' => '<p>The creation status of a custom language model. When the status is <code>COMPLETED</code> the model is ready for use.</p>', 'ListLanguageModelsRequest$StatusEquals' => '<p>When specified, returns only custom language models with the specified status. Language models are ordered by creation date, with the newest models first. If you don\'t specify a status, Amazon Transcribe returns all custom language models ordered by date.</p>', ], ], 'Models' => [ 'base' => NULL, 'refs' => [ 'ListLanguageModelsResponse$Models' => '<p>A list of objects containing information about custom language models.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListLanguageModelsRequest$NextToken' => '<p>When included, fetches the next set of jobs if the result of the previous request was truncated.</p>', 'ListLanguageModelsResponse$NextToken' => '<p>The operation returns a page of jobs at a time. The maximum size of the list is set by the MaxResults parameter. If there are more language models in the list than the page size, Amazon Transcribe returns the <code>NextPage</code> token. Include the token in the next request to the operation to return the next page of language models.</p>', 'ListMedicalTranscriptionJobsRequest$NextToken' => '<p>If you a receive a truncated result in the previous request of <code>ListMedicalTranscriptionJobs</code>, include <code>NextToken</code> to fetch the next set of jobs.</p>', 'ListMedicalTranscriptionJobsResponse$NextToken' => '<p>The <code>ListMedicalTranscriptionJobs</code> operation returns a page of jobs at a time. The maximum size of the page is set by the <code>MaxResults</code> parameter. If the number of jobs exceeds what can fit on a page, Amazon Transcribe Medical returns the <code>NextPage</code> token. Include the token in the next request to the <code>ListMedicalTranscriptionJobs</code> operation to return in the next page of jobs.</p>', 'ListMedicalVocabulariesRequest$NextToken' => '<p>If the result of your previous request to <code>ListMedicalVocabularies</code> was truncated, include the <code>NextToken</code> to fetch the next set of vocabularies.</p>', 'ListMedicalVocabulariesResponse$NextToken' => '<p>The <code>ListMedicalVocabularies</code> operation returns a page of vocabularies at a time. You set the maximum number of vocabularies to return on a page with the <code>MaxResults</code> parameter. If there are more jobs in the list will fit on a page, Amazon Transcribe Medical returns the <code>NextPage</code> token. To return the next page of vocabularies, include the token in the next request to the <code>ListMedicalVocabularies</code> operation .</p>', 'ListTranscriptionJobsRequest$NextToken' => '<p>If the result of the previous request to <code>ListTranscriptionJobs</code> was truncated, include the <code>NextToken</code> to fetch the next set of jobs.</p>', 'ListTranscriptionJobsResponse$NextToken' => '<p>The <code>ListTranscriptionJobs</code> operation returns a page of jobs at a time. The maximum size of the page is set by the <code>MaxResults</code> parameter. If there are more jobs in the list than the page size, Amazon Transcribe returns the <code>NextPage</code> token. Include the token in the next request to the <code>ListTranscriptionJobs</code> operation to return in the next page of jobs.</p>', 'ListVocabulariesRequest$NextToken' => '<p>If the result of the previous request to <code>ListVocabularies</code> was truncated, include the <code>NextToken</code> to fetch the next set of jobs.</p>', 'ListVocabulariesResponse$NextToken' => '<p>The <code>ListVocabularies</code> operation returns a page of vocabularies at a time. The maximum size of the page is set in the <code>MaxResults</code> parameter. If there are more jobs in the list than will fit on the page, Amazon Transcribe returns the <code>NextPage</code> token. To return in the next page of jobs, include the token in the next request to the <code>ListVocabularies</code> operation.</p>', 'ListVocabularyFiltersRequest$NextToken' => '<p>If the result of the previous request to <code>ListVocabularyFilters</code> was truncated, include the <code>NextToken</code> to fetch the next set of collections.</p>', 'ListVocabularyFiltersResponse$NextToken' => '<p>The <code>ListVocabularyFilters</code> operation returns a page of collections at a time. The maximum size of the page is set by the <code>MaxResults</code> parameter. If there are more jobs in the list than the page size, Amazon Transcribe returns the <code>NextPage</code> token. Include the token in the next request to the <code>ListVocabularyFilters</code> operation to return in the next page of jobs.</p>', ], ], 'NotFoundException' => [ 'base' => '<p>We can\'t find the requested resource. Check the name and try your request again.</p>', 'refs' => [], ], 'OutputBucketName' => [ 'base' => NULL, 'refs' => [ 'StartMedicalTranscriptionJobRequest$OutputBucketName' => '<p>The Amazon S3 location where the transcription is stored.</p> <p>You must set <code>OutputBucketName</code> for Amazon Transcribe Medical to store the transcription results. Your transcript appears in the S3 location you specify. When you call the <a>GetMedicalTranscriptionJob</a>, the operation returns this location in the <code>TranscriptFileUri</code> field. The S3 bucket must have permissions that allow Amazon Transcribe Medical to put files in the bucket. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user">Permissions Required for IAM User Roles</a>.</p> <p>You can specify an AWS Key Management Service (KMS) key to encrypt the output of your transcription using the <code>OutputEncryptionKMSKeyId</code> parameter. If you don\'t specify a KMS key, Amazon Transcribe Medical uses the default Amazon S3 key for server-side encryption of transcripts that are placed in your S3 bucket.</p>', 'StartTranscriptionJobRequest$OutputBucketName' => '<p>The location where the transcription is stored.</p> <p>If you set the <code>OutputBucketName</code>, Amazon Transcribe puts the transcript in the specified S3 bucket. When you call the <a>GetTranscriptionJob</a> operation, the operation returns this location in the <code>TranscriptFileUri</code> field. If you enable content redaction, the redacted transcript appears in <code>RedactedTranscriptFileUri</code>. If you enable content redaction and choose to output an unredacted transcript, that transcript\'s location still appears in the <code>TranscriptFileUri</code>. The S3 bucket must have permissions that allow Amazon Transcribe to put files in the bucket. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user">Permissions Required for IAM User Roles</a>.</p> <p>You can specify an AWS Key Management Service (KMS) key to encrypt the output of your transcription using the <code>OutputEncryptionKMSKeyId</code> parameter. If you don\'t specify a KMS key, Amazon Transcribe uses the default Amazon S3 key for server-side encryption of transcripts that are placed in your S3 bucket.</p> <p>If you don\'t set the <code>OutputBucketName</code>, Amazon Transcribe generates a pre-signed URL, a shareable URL that provides secure access to your transcription, and returns it in the <code>TranscriptFileUri</code> field. Use this URL to download the transcription.</p>', ], ], 'OutputLocationType' => [ 'base' => NULL, 'refs' => [ 'MedicalTranscriptionJobSummary$OutputLocationType' => '<p>Indicates the location of the transcription job\'s output.</p> <p>The <code>CUSTOMER_BUCKET</code> is the S3 location provided in the <code>OutputBucketName</code> field when the </p>', 'TranscriptionJobSummary$OutputLocationType' => '<p>Indicates the location of the output of the transcription job.</p> <p>If the value is <code>CUSTOMER_BUCKET</code> then the location is the S3 bucket specified in the <code>outputBucketName</code> field when the transcription job was started with the <code>StartTranscriptionJob</code> operation.</p> <p>If the value is <code>SERVICE_BUCKET</code> then the output is stored by Amazon Transcribe and can be retrieved using the URI in the <code>GetTranscriptionJob</code> response\'s <code>TranscriptFileUri</code> field.</p>', ], ], 'Phrase' => [ 'base' => NULL, 'refs' => [ 'Phrases$member' => NULL, ], ], 'Phrases' => [ 'base' => NULL, 'refs' => [ 'CreateVocabularyRequest$Phrases' => '<p>An array of strings that contains the vocabulary entries. </p>', 'UpdateVocabularyRequest$Phrases' => '<p>An array of strings containing the vocabulary entries.</p>', ], ], 'RedactionOutput' => [ 'base' => NULL, 'refs' => [ 'ContentRedaction$RedactionOutput' => '<p>The output transcript file stored in either the default S3 bucket or in a bucket you specify.</p> <p>When you choose <code>redacted</code> Amazon Transcribe outputs only the redacted transcript.</p> <p>When you choose <code>redacted_and_unredacted</code> Amazon Transcribe outputs both the redacted and unredacted transcripts.</p>', ], ], 'RedactionType' => [ 'base' => NULL, 'refs' => [ 'ContentRedaction$RedactionType' => '<p>Request parameter that defines the entities to be redacted. The only accepted value is <code>PII</code>.</p>', ], ], 'Settings' => [ 'base' => '<p>Provides optional settings for the <code>StartTranscriptionJob</code> operation.</p>', 'refs' => [ 'StartTranscriptionJobRequest$Settings' => '<p>A <code>Settings</code> object that provides optional settings for a transcription job.</p>', 'TranscriptionJob$Settings' => '<p>Optional settings for the transcription job. Use these settings to turn on speaker recognition, to set the maximum number of speakers that should be identified and to specify a custom vocabulary to use when processing the transcription job.</p>', ], ], 'Specialty' => [ 'base' => NULL, 'refs' => [ 'MedicalTranscriptionJob$Specialty' => '<p>The medical specialty of any clinicians providing a dictation or having a conversation. <code>PRIMARYCARE</code> is the only available setting for this object. This specialty enables you to generate transcriptions for the following medical fields:</p> <ul> <li> <p>Family Medicine</p> </li> </ul>', 'MedicalTranscriptionJobSummary$Specialty' => '<p>The medical specialty of the transcription job. <code>Primary care</code> is the only valid value.</p>', 'StartMedicalTranscriptionJobRequest$Specialty' => '<p>The medical specialty of any clinician speaking in the input media.</p>', ], ], 'StartMedicalTranscriptionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartMedicalTranscriptionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartTranscriptionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartTranscriptionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'ConflictException$Message' => NULL, 'InternalFailureException$Message' => NULL, 'LimitExceededException$Message' => NULL, 'NotFoundException$Message' => NULL, ], ], 'Transcript' => [ 'base' => '<p>Identifies the location of a transcription.</p>', 'refs' => [ 'TranscriptionJob$Transcript' => '<p>An object that describes the output of the transcription job.</p>', ], ], 'TranscriptionJob' => [ 'base' => '<p>Describes an asynchronous transcription job that was created with the <code>StartTranscriptionJob</code> operation. </p>', 'refs' => [ 'GetTranscriptionJobResponse$TranscriptionJob' => '<p>An object that contains the results of the transcription job.</p>', 'StartTranscriptionJobResponse$TranscriptionJob' => '<p>An object containing details of the asynchronous transcription job.</p>', ], ], 'TranscriptionJobName' => [ 'base' => NULL, 'refs' => [ 'DeleteMedicalTranscriptionJobRequest$MedicalTranscriptionJobName' => '<p>The name you provide to the <code>DeleteMedicalTranscriptionJob</code> object to delete a transcription job.</p>', 'DeleteTranscriptionJobRequest$TranscriptionJobName' => '<p>The name of the transcription job to be deleted.</p>', 'GetMedicalTranscriptionJobRequest$MedicalTranscriptionJobName' => '<p>The name of the medical transcription job.</p>', 'GetTranscriptionJobRequest$TranscriptionJobName' => '<p>The name of the job.</p>', 'ListMedicalTranscriptionJobsRequest$JobNameContains' => '<p>When specified, the jobs returned in the list are limited to jobs whose name contains the specified string.</p>', 'ListTranscriptionJobsRequest$JobNameContains' => '<p>When specified, the jobs returned in the list are limited to jobs whose name contains the specified string.</p>', 'MedicalTranscriptionJob$MedicalTranscriptionJobName' => '<p>The name for a given medical transcription job.</p>', 'MedicalTranscriptionJobSummary$MedicalTranscriptionJobName' => '<p>The name of a medical transcription job.</p>', 'StartMedicalTranscriptionJobRequest$MedicalTranscriptionJobName' => '<p>The name of the medical transcription job. You can\'t use the strings "<code>.</code>" or "<code>..</code>" by themselves as the job name. The name must also be unique within an AWS account. If you try to create a medical transcription job with the same name as a previous medical transcription job, you get a <code>ConflictException</code> error.</p>', 'StartTranscriptionJobRequest$TranscriptionJobName' => '<p>The name of the job. You can\'t use the strings "<code>.</code>" or "<code>..</code>" by themselves as the job name. The name must also be unique within an AWS account. If you try to create a transcription job with the same name as a previous transcription job, you get a <code>ConflictException</code> error.</p>', 'TranscriptionJob$TranscriptionJobName' => '<p>The name of the transcription job.</p>', 'TranscriptionJobSummary$TranscriptionJobName' => '<p>The name of the transcription job.</p>', ], ], 'TranscriptionJobStatus' => [ 'base' => NULL, 'refs' => [ 'ListMedicalTranscriptionJobsRequest$Status' => '<p>When specified, returns only medical transcription jobs with the specified status. Jobs are ordered by creation date, with the newest jobs returned first. If you don\'t specify a status, Amazon Transcribe Medical returns all transcription jobs ordered by creation date.</p>', 'ListMedicalTranscriptionJobsResponse$Status' => '<p>The requested status of the medical transcription jobs returned.</p>', 'ListTranscriptionJobsRequest$Status' => '<p>When specified, returns only transcription jobs with the specified status. Jobs are ordered by creation date, with the newest jobs returned first. If you don’t specify a status, Amazon Transcribe returns all transcription jobs ordered by creation date. </p>', 'ListTranscriptionJobsResponse$Status' => '<p>The requested status of the jobs returned.</p>', 'MedicalTranscriptionJob$TranscriptionJobStatus' => '<p>The completion status of a medical transcription job.</p>', 'MedicalTranscriptionJobSummary$TranscriptionJobStatus' => '<p>The status of the medical transcription job.</p>', 'TranscriptionJob$TranscriptionJobStatus' => '<p>The status of the transcription job.</p>', 'TranscriptionJobSummary$TranscriptionJobStatus' => '<p>The status of the transcription job. When the status is <code>COMPLETED</code>, use the <code>GetTranscriptionJob</code> operation to get the results of the transcription.</p>', ], ], 'TranscriptionJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListTranscriptionJobsResponse$TranscriptionJobSummaries' => '<p>A list of objects containing summary information for a transcription job.</p>', ], ], 'TranscriptionJobSummary' => [ 'base' => '<p>Provides a summary of information about a transcription job.</p>', 'refs' => [ 'TranscriptionJobSummaries$member' => NULL, ], ], 'Type' => [ 'base' => NULL, 'refs' => [ 'MedicalTranscriptionJob$Type' => '<p>The type of speech in the transcription job. <code>CONVERSATION</code> is generally used for patient-physician dialogues. <code>DICTATION</code> is the setting for physicians speaking their notes after seeing a patient. For more information, see <a>how-it-works-med</a> </p>', 'MedicalTranscriptionJobSummary$Type' => '<p>The speech of the clinician in the input audio.</p>', 'StartMedicalTranscriptionJobRequest$Type' => '<p>The type of speech in the input audio. <code>CONVERSATION</code> refers to conversations between two or more speakers, e.g., a conversations between doctors and patients. <code>DICTATION</code> refers to single-speaker dictated speech, e.g., for clinical notes.</p>', ], ], 'UpdateMedicalVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMedicalVocabularyResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVocabularyFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVocabularyFilterResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVocabularyResponse' => [ 'base' => NULL, 'refs' => [], ], 'Uri' => [ 'base' => NULL, 'refs' => [ 'CreateMedicalVocabularyRequest$VocabularyFileUri' => '<p>The location in Amazon S3 of the text file you use to define your custom vocabulary. The URI must be in the same AWS Region as the resource that you\'re calling. Enter information about your <code>VocabularyFileUri</code> in the following format:</p> <p> <code> https://s3.&lt;aws-region&gt;.amazonaws.com/&lt;bucket-name&gt;/&lt;keyprefix&gt;/&lt;objectkey&gt; </code> </p> <p>The following is an example URI for a vocabulary file that is stored in Amazon S3:</p> <p> <code>https://s3.us-east-1.amazonaws.com/AWSDOC-EXAMPLE-BUCKET/vocab.txt</code> </p> <p>For more information about Amazon S3 object names, see <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys">Object Keys</a> in the <i>Amazon S3 Developer Guide</i>.</p> <p>For more information about custom vocabularies, see <a href="http://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary-med">Medical Custom Vocabularies</a>.</p>', 'CreateVocabularyFilterRequest$VocabularyFilterFileUri' => '<p>The Amazon S3 location of a text file used as input to create the vocabulary filter. Only use characters from the character set defined for custom vocabularies. For a list of character sets, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-vocabulary.html#charsets">Character Sets for Custom Vocabularies</a>.</p> <p>The specified file must be less than 50 KB of UTF-8 characters.</p> <p>If you provide the location of a list of words in the <code>VocabularyFilterFileUri</code> parameter, you can\'t use the <code>Words</code> parameter.</p>', 'CreateVocabularyRequest$VocabularyFileUri' => '<p>The S3 location of the text file that contains the definition of the custom vocabulary. The URI must be in the same region as the API endpoint that you are calling. The general form is </p> <p>For more information about S3 object names, see <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys">Object Keys</a> in the <i>Amazon S3 Developer Guide</i>.</p> <p>For more information about custom vocabularies, see <a href="http://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary">Custom Vocabularies</a>.</p>', 'GetMedicalVocabularyResponse$DownloadUri' => '<p>The location in Amazon S3 where the vocabulary is stored. Use this URI to get the contents of the vocabulary. You can download your vocabulary from the URI for a limited time.</p>', 'GetVocabularyFilterResponse$DownloadUri' => '<p>The URI of the list of words in the vocabulary filter. You can use this URI to get the list of words.</p>', 'GetVocabularyResponse$DownloadUri' => '<p>The S3 location where the vocabulary is stored. Use this URI to get the contents of the vocabulary. The URI is available for a limited time.</p>', 'InputDataConfig$S3Uri' => '<p>The Amazon S3 prefix you specify to access the plain text files that you use to train your custom language model.</p>', 'InputDataConfig$TuningDataS3Uri' => '<p>The Amazon S3 prefix you specify to access the plain text files that you use to tune your custom language model.</p>', 'Media$MediaFileUri' => '<p>The S3 object location of the input media file. The URI must be in the same region as the API endpoint that you are calling. The general form is:</p> <p>For example:</p> <p>For more information about S3 object names, see <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys">Object Keys</a> in the <i>Amazon S3 Developer Guide</i>.</p>', 'MedicalTranscript$TranscriptFileUri' => '<p>The S3 object location of the medical transcript.</p> <p>Use this URI to access the medical transcript. This URI points to the S3 bucket you created to store the medical transcript.</p>', 'Transcript$TranscriptFileUri' => '<p>The S3 object location of the transcript.</p> <p>Use this URI to access the transcript. If you specified an S3 bucket in the <code>OutputBucketName</code> field when you created the job, this is the URI of that bucket. If you chose to store the transcript in Amazon Transcribe, this is a shareable URL that provides secure access to that location.</p>', 'Transcript$RedactedTranscriptFileUri' => '<p>The S3 object location of the redacted transcript.</p> <p>Use this URI to access the redacted transcript. If you specified an S3 bucket in the <code>OutputBucketName</code> field when you created the job, this is the URI of that bucket. If you chose to store the transcript in Amazon Transcribe, this is a shareable URL that provides secure access to that location.</p>', 'UpdateMedicalVocabularyRequest$VocabularyFileUri' => '<p>The location in Amazon S3 of the text file that contains the you use for your custom vocabulary. The URI must be in the same AWS Region as the resource that you are calling. The following is the format for a URI:</p> <p> <code> https://s3.&lt;aws-region&gt;.amazonaws.com/&lt;bucket-name&gt;/&lt;keyprefix&gt;/&lt;objectkey&gt; </code> </p> <p>For example:</p> <p> <code>https://s3.us-east-1.amazonaws.com/AWSDOC-EXAMPLE-BUCKET/vocab.txt</code> </p> <p>For more information about Amazon S3 object names, see <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys">Object Keys</a> in the <i>Amazon S3 Developer Guide</i>.</p> <p>For more information about custom vocabularies in Amazon Transcribe Medical, see <a href="http://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary">Medical Custom Vocabularies</a>.</p>', 'UpdateVocabularyFilterRequest$VocabularyFilterFileUri' => '<p>The Amazon S3 location of a text file used as input to create the vocabulary filter. Only use characters from the character set defined for custom vocabularies. For a list of character sets, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-vocabulary.html#charsets">Character Sets for Custom Vocabularies</a>.</p> <p>The specified file must be less than 50 KB of UTF-8 characters.</p> <p>If you provide the location of a list of words in the <code>VocabularyFilterFileUri</code> parameter, you can\'t use the <code>Words</code> parameter.</p>', 'UpdateVocabularyRequest$VocabularyFileUri' => '<p>The S3 location of the text file that contains the definition of the custom vocabulary. The URI must be in the same region as the API endpoint that you are calling. The general form is </p> <p>For example:</p> <p>For more information about S3 object names, see <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys">Object Keys</a> in the <i>Amazon S3 Developer Guide</i>.</p> <p>For more information about custom vocabularies, see <a href="http://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary">Custom Vocabularies</a>.</p>', ], ], 'Vocabularies' => [ 'base' => NULL, 'refs' => [ 'ListMedicalVocabulariesResponse$Vocabularies' => '<p>A list of objects that describe the vocabularies that match your search criteria.</p>', 'ListVocabulariesResponse$Vocabularies' => '<p>A list of objects that describe the vocabularies that match the search criteria in the request.</p>', ], ], 'VocabularyFilterInfo' => [ 'base' => '<p>Provides information about a vocabulary filter.</p>', 'refs' => [ 'VocabularyFilters$member' => NULL, ], ], 'VocabularyFilterMethod' => [ 'base' => NULL, 'refs' => [ 'Settings$VocabularyFilterMethod' => '<p>Set to <code>mask</code> to remove filtered text from the transcript and replace it with three asterisks ("***") as placeholder text. Set to <code>remove</code> to remove filtered text from the transcript without using placeholder text.</p>', ], ], 'VocabularyFilterName' => [ 'base' => NULL, 'refs' => [ 'CreateVocabularyFilterRequest$VocabularyFilterName' => '<p>The vocabulary filter name. The name must be unique within the account that contains it. If you try to create a vocabulary filter with the same name as another vocabulary filter, you get a <code>ConflictException</code> error.</p>', 'CreateVocabularyFilterResponse$VocabularyFilterName' => '<p>The name of the vocabulary filter.</p>', 'DeleteVocabularyFilterRequest$VocabularyFilterName' => '<p>The name of the vocabulary filter to remove.</p>', 'GetVocabularyFilterRequest$VocabularyFilterName' => '<p>The name of the vocabulary filter for which to return information.</p>', 'GetVocabularyFilterResponse$VocabularyFilterName' => '<p>The name of the vocabulary filter.</p>', 'ListVocabularyFiltersRequest$NameContains' => '<p>Filters the response so that it only contains vocabulary filters whose name contains the specified string.</p>', 'Settings$VocabularyFilterName' => '<p>The name of the vocabulary filter to use when transcribing the audio. The filter that you specify must have the same language code as the transcription job.</p>', 'UpdateVocabularyFilterRequest$VocabularyFilterName' => '<p>The name of the vocabulary filter to update. If you try to update a vocabulary filter with the same name as another vocabulary filter, you get a <code>ConflictException</code> error.</p>', 'UpdateVocabularyFilterResponse$VocabularyFilterName' => '<p>The name of the updated vocabulary filter.</p>', 'VocabularyFilterInfo$VocabularyFilterName' => '<p>The name of the vocabulary filter. The name must be unique in the account that holds the filter.</p>', ], ], 'VocabularyFilters' => [ 'base' => NULL, 'refs' => [ 'ListVocabularyFiltersResponse$VocabularyFilters' => '<p>The list of vocabulary filters. It contains at most <code>MaxResults</code> number of filters. If there are more filters, call the <code>ListVocabularyFilters</code> operation again with the <code>NextToken</code> parameter in the request set to the value of the <code>NextToken</code> field in the response.</p>', ], ], 'VocabularyInfo' => [ 'base' => '<p>Provides information about a custom vocabulary. </p>', 'refs' => [ 'Vocabularies$member' => NULL, ], ], 'VocabularyName' => [ 'base' => NULL, 'refs' => [ 'CreateMedicalVocabularyRequest$VocabularyName' => '<p>The name of the custom vocabulary. This case-sensitive name must be unique within an AWS account. If you try to create a vocabulary with the same name as a previous vocabulary, you get a <code>ConflictException</code> error.</p>', 'CreateMedicalVocabularyResponse$VocabularyName' => '<p>The name of the vocabulary. The name must be unique within an AWS account and is case sensitive.</p>', 'CreateVocabularyRequest$VocabularyName' => '<p>The name of the vocabulary. The name must be unique within an AWS account. The name is case sensitive. If you try to create a vocabulary with the same name as a previous vocabulary you will receive a <code>ConflictException</code> error.</p>', 'CreateVocabularyResponse$VocabularyName' => '<p>The name of the vocabulary.</p>', 'DeleteMedicalVocabularyRequest$VocabularyName' => '<p>The name of the vocabulary that you want to delete.</p>', 'DeleteVocabularyRequest$VocabularyName' => '<p>The name of the vocabulary to delete. </p>', 'GetMedicalVocabularyRequest$VocabularyName' => '<p>The name of the vocabulary that you want information about. The value is case sensitive. </p>', 'GetMedicalVocabularyResponse$VocabularyName' => '<p>The name of the vocabulary returned by Amazon Transcribe Medical.</p>', 'GetVocabularyRequest$VocabularyName' => '<p>The name of the vocabulary to return information about. The name is case sensitive.</p>', 'GetVocabularyResponse$VocabularyName' => '<p>The name of the vocabulary to return.</p>', 'ListMedicalVocabulariesRequest$NameContains' => '<p>Returns vocabularies whose names contain the specified string. The search is not case sensitive. <code>ListMedicalVocabularies</code> returns both "<code>vocabularyname</code>" and "<code>VocabularyName</code>".</p>', 'ListVocabulariesRequest$NameContains' => '<p>When specified, the vocabularies returned in the list are limited to vocabularies whose name contains the specified string. The search is not case sensitive, <code>ListVocabularies</code> returns both "vocabularyname" and "VocabularyName" in the response list.</p>', 'MedicalTranscriptionSetting$VocabularyName' => '<p>The name of the vocabulary to use when processing a medical transcription job.</p>', 'Settings$VocabularyName' => '<p>The name of a vocabulary to use when processing the transcription job.</p>', 'UpdateMedicalVocabularyRequest$VocabularyName' => '<p>The name of the vocabulary to update. The name is case sensitive. If you try to update a vocabulary with the same name as a vocabulary you\'ve already made, you get a <code>ConflictException</code> error.</p>', 'UpdateMedicalVocabularyResponse$VocabularyName' => '<p>The name of the updated vocabulary.</p>', 'UpdateVocabularyRequest$VocabularyName' => '<p>The name of the vocabulary to update. The name is case sensitive. If you try to update a vocabulary with the same name as a previous vocabulary you will receive a <code>ConflictException</code> error.</p>', 'UpdateVocabularyResponse$VocabularyName' => '<p>The name of the vocabulary that was updated.</p>', 'VocabularyInfo$VocabularyName' => '<p>The name of the vocabulary.</p>', ], ], 'VocabularyState' => [ 'base' => NULL, 'refs' => [ 'CreateMedicalVocabularyResponse$VocabularyState' => '<p>The processing state of your custom vocabulary in Amazon Transcribe Medical. If the state is <code>READY</code>, you can use the vocabulary in a <code>StartMedicalTranscriptionJob</code> request.</p>', 'CreateVocabularyResponse$VocabularyState' => '<p>The processing state of the vocabulary. When the <code>VocabularyState</code> field contains <code>READY</code> the vocabulary is ready to be used in a <code>StartTranscriptionJob</code> request.</p>', 'GetMedicalVocabularyResponse$VocabularyState' => '<p>The processing state of the vocabulary. If the <code>VocabularyState</code> is <code>READY</code> then you can use it in the <code>StartMedicalTranscriptionJob</code> operation. </p>', 'GetVocabularyResponse$VocabularyState' => '<p>The processing state of the vocabulary.</p>', 'ListMedicalVocabulariesRequest$StateEquals' => '<p>When specified, returns only vocabularies with the <code>VocabularyState</code> equal to the specified vocabulary state. Use this field to see which vocabularies are ready for your medical transcription jobs.</p>', 'ListMedicalVocabulariesResponse$Status' => '<p>The requested vocabulary state.</p>', 'ListVocabulariesRequest$StateEquals' => '<p>When specified, only returns vocabularies with the <code>VocabularyState</code> field equal to the specified state.</p>', 'ListVocabulariesResponse$Status' => '<p>The requested vocabulary state.</p>', 'UpdateMedicalVocabularyResponse$VocabularyState' => '<p>The processing state of the update to the vocabulary. When the <code>VocabularyState</code> field is <code>READY</code>, the vocabulary is ready to be used in a <code>StartMedicalTranscriptionJob</code> request.</p>', 'UpdateVocabularyResponse$VocabularyState' => '<p>The processing state of the vocabulary. When the <code>VocabularyState</code> field contains <code>READY</code> the vocabulary is ready to be used in a <code>StartTranscriptionJob</code> request.</p>', 'VocabularyInfo$VocabularyState' => '<p>The processing state of the vocabulary. If the state is <code>READY</code> you can use the vocabulary in a <code>StartTranscriptionJob</code> request.</p>', ], ], 'Word' => [ 'base' => NULL, 'refs' => [ 'Words$member' => NULL, ], ], 'Words' => [ 'base' => NULL, 'refs' => [ 'CreateVocabularyFilterRequest$Words' => '<p>The words to use in the vocabulary filter. Only use characters from the character set defined for custom vocabularies. For a list of character sets, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-vocabulary.html#charsets">Character Sets for Custom Vocabularies</a>.</p> <p>If you provide a list of words in the <code>Words</code> parameter, you can\'t use the <code>VocabularyFilterFileUri</code> parameter.</p>', 'UpdateVocabularyFilterRequest$Words' => '<p>The words to use in the vocabulary filter. Only use characters from the character set defined for custom vocabularies. For a list of character sets, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-vocabulary.html#charsets">Character Sets for Custom Vocabularies</a>.</p> <p>If you provide a list of words in the <code>Words</code> parameter, you can\'t use the <code>VocabularyFilterFileUri</code> parameter.</p>', ], ], ],];
