<?php
// This file was auto-generated from sdk-root/src/data/states/2016-11-23/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>AWS Step Functions</fullname> <p>AWS Step Functions is a service that lets you coordinate the components of distributed applications and microservices using visual workflows.</p> <p>You can use Step Functions to build applications from individual components, each of which performs a discrete function, or <i>task</i>, allowing you to scale and change applications quickly. Step Functions provides a console that helps visualize the components of your application as a series of steps. Step Functions automatically triggers and tracks each step, and retries steps when there are errors, so your application executes predictably and in the right order every time. Step Functions logs the state of each step, so you can quickly diagnose and debug any issues.</p> <p>Step Functions manages operations and underlying infrastructure to ensure your application is available at any scale. You can run tasks on AWS, your own servers, or any system that has access to AWS. You can access and use Step Functions using the console, the AWS SDKs, or an HTTP API. For more information about Step Functions, see the <i> <a href="https://docs.aws.amazon.com/step-functions/latest/dg/welcome.html">AWS Step Functions Developer Guide</a> </i>.</p>', 'operations' => [ 'CreateActivity' => '<p>Creates an activity. An activity is a task that you write in any programming language and host on any machine that has access to AWS Step Functions. Activities must poll Step Functions using the <code>GetActivityTask</code> API action and respond using <code>SendTask*</code> API actions. This function lets Step Functions know the existence of your activity and returns an identifier for use in a state machine and when polling from the activity.</p> <note> <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p> </note> <note> <p> <code>CreateActivity</code> is an idempotent API. Subsequent requests won’t create a duplicate resource if it was already created. <code>CreateActivity</code>\'s idempotency check is based on the activity <code>name</code>. If a following request has different <code>tags</code> values, Step Functions will ignore these differences and treat it as an idempotent request of the previous. In this case, <code>tags</code> will not be updated, even if they are different.</p> </note>', 'CreateStateMachine' => '<p>Creates a state machine. A state machine consists of a collection of states that can do work (<code>Task</code> states), determine to which states to transition next (<code>Choice</code> states), stop an execution with an error (<code>Fail</code> states), and so on. State machines are specified using a JSON-based, structured language. For more information, see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a> in the AWS Step Functions User Guide.</p> <note> <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p> </note> <note> <p> <code>CreateStateMachine</code> is an idempotent API. Subsequent requests won’t create a duplicate resource if it was already created. <code>CreateStateMachine</code>\'s idempotency check is based on the state machine <code>name</code>, <code>definition</code>, <code>type</code>, and <code>LoggingConfiguration</code>. If a following request has a different <code>roleArn</code> or <code>tags</code>, Step Functions will ignore these differences and treat it as an idempotent request of the previous. In this case, <code>roleArn</code> and <code>tags</code> will not be updated, even if they are different.</p> </note>', 'DeleteActivity' => '<p>Deletes an activity.</p>', 'DeleteStateMachine' => '<p>Deletes a state machine. This is an asynchronous operation: It sets the state machine\'s status to <code>DELETING</code> and begins the deletion process. </p> <note> <p>For <code>EXPRESS</code>state machines, the deletion will happen eventually (usually less than a minute). Running executions may emit logs after <code>DeleteStateMachine</code> API is called.</p> </note>', 'DescribeActivity' => '<p>Describes an activity.</p> <note> <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p> </note>', 'DescribeExecution' => '<p>Describes an execution.</p> <note> <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p> </note> <p>This API action is not supported by <code>EXPRESS</code> state machines.</p>', 'DescribeStateMachine' => '<p>Describes a state machine.</p> <note> <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p> </note>', 'DescribeStateMachineForExecution' => '<p>Describes the state machine associated with a specific execution.</p> <note> <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p> </note> <p>This API action is not supported by <code>EXPRESS</code> state machines.</p>', 'GetActivityTask' => '<p>Used by workers to retrieve a task (with the specified activity ARN) which has been scheduled for execution by a running state machine. This initiates a long poll, where the service holds the HTTP connection open and responds as soon as a task becomes available (i.e. an execution of a task of this type is needed.) The maximum time the service holds on to the request before responding is 60 seconds. If no task is available within 60 seconds, the poll returns a <code>taskToken</code> with a null string.</p> <important> <p>Workers should set their client side socket timeout to at least 65 seconds (5 seconds higher than the maximum time the service may hold the poll request).</p> <p>Polling with <code>GetActivityTask</code> can cause latency in some implementations. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/bp-activity-pollers.html">Avoid Latency When Polling for Activity Tasks</a> in the Step Functions Developer Guide.</p> </important>', 'GetExecutionHistory' => '<p>Returns the history of the specified execution as a list of events. By default, the results are returned in ascending order of the <code>timeStamp</code> of the events. Use the <code>reverseOrder</code> parameter to get the latest events first.</p> <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p> <p>This API action is not supported by <code>EXPRESS</code> state machines.</p>', 'ListActivities' => '<p>Lists the existing activities.</p> <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p> <note> <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p> </note>', 'ListExecutions' => '<p>Lists the executions of a state machine that meet the filtering criteria. Results are sorted by time, with the most recent execution first.</p> <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p> <note> <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p> </note> <p>This API action is not supported by <code>EXPRESS</code> state machines.</p>', 'ListStateMachines' => '<p>Lists the existing state machines.</p> <p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p> <note> <p>This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.</p> </note>', 'ListTagsForResource' => '<p>List tags for a given resource.</p> <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>', 'SendTaskFailure' => '<p>Used by activity workers and task states using the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token">callback</a> pattern to report that the task identified by the <code>taskToken</code> failed.</p>', 'SendTaskHeartbeat' => '<p>Used by activity workers and task states using the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token">callback</a> pattern to report to Step Functions that the task represented by the specified <code>taskToken</code> is still making progress. This action resets the <code>Heartbeat</code> clock. The <code>Heartbeat</code> threshold is specified in the state machine\'s Amazon States Language definition (<code>HeartbeatSeconds</code>). This action does not in itself create an event in the execution history. However, if the task times out, the execution history contains an <code>ActivityTimedOut</code> entry for activities, or a <code>TaskTimedOut</code> entry for for tasks using the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync">job run</a> or <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token">callback</a> pattern.</p> <note> <p>The <code>Timeout</code> of a task, defined in the state machine\'s Amazon States Language definition, is its maximum allowed duration, regardless of the number of <a>SendTaskHeartbeat</a> requests received. Use <code>HeartbeatSeconds</code> to configure the timeout interval for heartbeats.</p> </note>', 'SendTaskSuccess' => '<p>Used by activity workers and task states using the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token">callback</a> pattern to report that the task identified by the <code>taskToken</code> completed successfully.</p>', 'StartExecution' => '<p>Starts a state machine execution.</p> <note> <p> <code>StartExecution</code> is idempotent. If <code>StartExecution</code> is called with the same name and input as a running execution, the call will succeed and return the same response as the original request. If the execution is closed or if the input is different, it will return a 400 <code>ExecutionAlreadyExists</code> error. Names can be reused after 90 days. </p> </note>', 'StopExecution' => '<p>Stops an execution.</p> <p>This API action is not supported by <code>EXPRESS</code> state machines.</p>', 'TagResource' => '<p>Add a tag to a Step Functions resource.</p> <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>, and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags</a>.</p> <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>', 'UntagResource' => '<p>Remove a tag from a Step Functions resource</p>', 'UpdateStateMachine' => '<p>Updates an existing state machine by modifying its <code>definition</code>, <code>roleArn</code>, or <code>loggingConfiguration</code>. Running executions will continue to use the previous <code>definition</code> and <code>roleArn</code>. You must include at least one of <code>definition</code> or <code>roleArn</code> or you will receive a <code>MissingRequiredParameter</code> error.</p> <note> <p>All <code>StartExecution</code> calls within a few seconds will use the updated <code>definition</code> and <code>roleArn</code>. Executions started immediately after calling <code>UpdateStateMachine</code> may use the previous state machine <code>definition</code> and <code>roleArn</code>. </p> </note>', ], 'shapes' => [ 'ActivityDoesNotExist' => [ 'base' => '<p>The specified activity does not exist.</p>', 'refs' => [], ], 'ActivityFailedEventDetails' => [ 'base' => '<p>Contains details about an activity that failed during an execution.</p>', 'refs' => [ 'HistoryEvent$activityFailedEventDetails' => NULL, ], ], 'ActivityLimitExceeded' => [ 'base' => '<p>The maximum number of activities has been reached. Existing activities must be deleted before a new activity can be created.</p>', 'refs' => [], ], 'ActivityList' => [ 'base' => NULL, 'refs' => [ 'ListActivitiesOutput$activities' => '<p>The list of activities.</p>', ], ], 'ActivityListItem' => [ 'base' => '<p>Contains details about an activity.</p>', 'refs' => [ 'ActivityList$member' => NULL, ], ], 'ActivityScheduleFailedEventDetails' => [ 'base' => '<p>Contains details about an activity schedule failure that occurred during an execution.</p>', 'refs' => [ 'HistoryEvent$activityScheduleFailedEventDetails' => '<p>Contains details about an activity schedule event that failed during an execution.</p>', ], ], 'ActivityScheduledEventDetails' => [ 'base' => '<p>Contains details about an activity scheduled during an execution.</p>', 'refs' => [ 'HistoryEvent$activityScheduledEventDetails' => NULL, ], ], 'ActivityStartedEventDetails' => [ 'base' => '<p>Contains details about the start of an activity during an execution.</p>', 'refs' => [ 'HistoryEvent$activityStartedEventDetails' => NULL, ], ], 'ActivitySucceededEventDetails' => [ 'base' => '<p>Contains details about an activity that successfully terminated during an execution.</p>', 'refs' => [ 'HistoryEvent$activitySucceededEventDetails' => NULL, ], ], 'ActivityTimedOutEventDetails' => [ 'base' => '<p>Contains details about an activity timeout that occurred during an execution.</p>', 'refs' => [ 'HistoryEvent$activityTimedOutEventDetails' => NULL, ], ], 'ActivityWorkerLimitExceeded' => [ 'base' => '<p>The maximum number of workers concurrently polling for activity tasks has been reached.</p>', 'refs' => [], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'ActivityListItem$activityArn' => '<p>The Amazon Resource Name (ARN) that identifies the activity.</p>', 'ActivityScheduledEventDetails$resource' => '<p>The Amazon Resource Name (ARN) of the scheduled activity.</p>', 'CloudWatchLogsLogGroup$logGroupArn' => '<p>The ARN of the the CloudWatch log group to which you want your logs emitted to. The ARN must end with <code>:*</code> </p>', 'CreateActivityOutput$activityArn' => '<p>The Amazon Resource Name (ARN) that identifies the created activity.</p>', 'CreateStateMachineInput$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role to use for this state machine.</p>', 'CreateStateMachineOutput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) that identifies the created state machine.</p>', 'DeleteActivityInput$activityArn' => '<p>The Amazon Resource Name (ARN) of the activity to delete.</p>', 'DeleteStateMachineInput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) of the state machine to delete.</p>', 'DescribeActivityInput$activityArn' => '<p>The Amazon Resource Name (ARN) of the activity to describe.</p>', 'DescribeActivityOutput$activityArn' => '<p>The Amazon Resource Name (ARN) that identifies the activity.</p>', 'DescribeExecutionInput$executionArn' => '<p>The Amazon Resource Name (ARN) of the execution to describe.</p>', 'DescribeExecutionOutput$executionArn' => '<p>The Amazon Resource Name (ARN) that id entifies the execution.</p>', 'DescribeExecutionOutput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) of the executed stated machine.</p>', 'DescribeStateMachineForExecutionInput$executionArn' => '<p>The Amazon Resource Name (ARN) of the execution you want state machine information for.</p>', 'DescribeStateMachineForExecutionOutput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) of the state machine associated with the execution.</p>', 'DescribeStateMachineForExecutionOutput$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role of the State Machine for the execution. </p>', 'DescribeStateMachineInput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) of the state machine to describe.</p>', 'DescribeStateMachineOutput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) that identifies the state machine.</p>', 'DescribeStateMachineOutput$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role used when creating this state machine. (The IAM role maintains security by granting Step Functions access to AWS resources.)</p>', 'ExecutionListItem$executionArn' => '<p>The Amazon Resource Name (ARN) that id entifies the execution.</p>', 'ExecutionListItem$stateMachineArn' => '<p>The Amazon Resource Name (ARN) of the executed state machine.</p>', 'ExecutionStartedEventDetails$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role used for executing AWS Lambda tasks.</p>', 'GetActivityTaskInput$activityArn' => '<p>The Amazon Resource Name (ARN) of the activity to retrieve tasks from (assigned when you create the task using <a>CreateActivity</a>.)</p>', 'GetExecutionHistoryInput$executionArn' => '<p>The Amazon Resource Name (ARN) of the execution.</p>', 'LambdaFunctionScheduledEventDetails$resource' => '<p>The Amazon Resource Name (ARN) of the scheduled lambda function.</p>', 'ListExecutionsInput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) of the state machine whose executions is listed.</p>', 'ListTagsForResourceInput$resourceArn' => '<p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>', 'ResourceNotFound$resourceName' => NULL, 'StartExecutionInput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) of the state machine to execute.</p>', 'StartExecutionOutput$executionArn' => '<p>The Amazon Resource Name (ARN) that id entifies the execution.</p>', 'StateMachineListItem$stateMachineArn' => '<p>The Amazon Resource Name (ARN) that identifies the state machine.</p>', 'StopExecutionInput$executionArn' => '<p>The Amazon Resource Name (ARN) of the execution to stop.</p>', 'TagResourceInput$resourceArn' => '<p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>', 'TooManyTags$resourceName' => NULL, 'UntagResourceInput$resourceArn' => '<p>The Amazon Resource Name (ARN) for the Step Functions state machine or activity.</p>', 'UpdateStateMachineInput$stateMachineArn' => '<p>The Amazon Resource Name (ARN) of the state machine.</p>', 'UpdateStateMachineInput$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role of the state machine.</p>', ], ], 'CloudWatchLogsLogGroup' => [ 'base' => '<p/>', 'refs' => [ 'LogDestination$cloudWatchLogsLogGroup' => '<p>An object describing a CloudWatch log group. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html">AWS::Logs::LogGroup</a> in the AWS CloudFormation User Guide.</p>', ], ], 'ConnectorParameters' => [ 'base' => NULL, 'refs' => [ 'TaskScheduledEventDetails$parameters' => '<p>The JSON data passed to the resource referenced in a task state.</p>', ], ], 'CreateActivityInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateActivityOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateStateMachineInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateStateMachineOutput' => [ 'base' => NULL, 'refs' => [], ], 'Definition' => [ 'base' => NULL, 'refs' => [ 'CreateStateMachineInput$definition' => '<p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>', 'DescribeStateMachineForExecutionOutput$definition' => '<p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>', 'DescribeStateMachineOutput$definition' => '<p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>', 'UpdateStateMachineInput$definition' => '<p>The Amazon States Language definition of the state machine. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a>.</p>', ], ], 'DeleteActivityInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteActivityOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStateMachineInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStateMachineOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeActivityInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeActivityOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExecutionInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExecutionOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStateMachineForExecutionInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStateMachineForExecutionOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStateMachineInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStateMachineOutput' => [ 'base' => NULL, 'refs' => [], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'ActivityDoesNotExist$message' => NULL, 'ActivityLimitExceeded$message' => NULL, 'ActivityWorkerLimitExceeded$message' => NULL, 'ExecutionAlreadyExists$message' => NULL, 'ExecutionDoesNotExist$message' => NULL, 'ExecutionLimitExceeded$message' => NULL, 'InvalidArn$message' => NULL, 'InvalidDefinition$message' => NULL, 'InvalidExecutionInput$message' => NULL, 'InvalidLoggingConfiguration$message' => NULL, 'InvalidName$message' => NULL, 'InvalidOutput$message' => NULL, 'InvalidToken$message' => NULL, 'MissingRequiredParameter$message' => NULL, 'ResourceNotFound$message' => NULL, 'StateMachineAlreadyExists$message' => NULL, 'StateMachineDeleting$message' => NULL, 'StateMachineDoesNotExist$message' => NULL, 'StateMachineLimitExceeded$message' => NULL, 'StateMachineTypeNotSupported$message' => NULL, 'TaskDoesNotExist$message' => NULL, 'TaskTimedOut$message' => NULL, 'TooManyTags$message' => NULL, ], ], 'EventId' => [ 'base' => NULL, 'refs' => [ 'HistoryEvent$id' => '<p>The id of the event. Events are numbered sequentially, starting at one.</p>', 'HistoryEvent$previousEventId' => '<p>The id of the previous event.</p>', ], ], 'ExecutionAbortedEventDetails' => [ 'base' => '<p>Contains details about an abort of an execution.</p>', 'refs' => [ 'HistoryEvent$executionAbortedEventDetails' => NULL, ], ], 'ExecutionAlreadyExists' => [ 'base' => '<p>The execution has the same <code>name</code> as another execution (but a different <code>input</code>).</p> <note> <p>Executions with the same <code>name</code> and <code>input</code> are considered idempotent.</p> </note>', 'refs' => [], ], 'ExecutionDoesNotExist' => [ 'base' => '<p>The specified execution does not exist.</p>', 'refs' => [], ], 'ExecutionFailedEventDetails' => [ 'base' => '<p>Contains details about an execution failure event.</p>', 'refs' => [ 'HistoryEvent$executionFailedEventDetails' => NULL, ], ], 'ExecutionLimitExceeded' => [ 'base' => '<p>The maximum number of running executions has been reached. Running executions must end or be stopped before a new execution can be started.</p>', 'refs' => [], ], 'ExecutionList' => [ 'base' => NULL, 'refs' => [ 'ListExecutionsOutput$executions' => '<p>The list of matching executions.</p>', ], ], 'ExecutionListItem' => [ 'base' => '<p>Contains details about an execution.</p>', 'refs' => [ 'ExecutionList$member' => NULL, ], ], 'ExecutionStartedEventDetails' => [ 'base' => '<p>Contains details about the start of the execution.</p>', 'refs' => [ 'HistoryEvent$executionStartedEventDetails' => NULL, ], ], 'ExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeExecutionOutput$status' => '<p>The current status of the execution.</p>', 'ExecutionListItem$status' => '<p>The current status of the execution.</p>', 'ListExecutionsInput$statusFilter' => '<p>If specified, only list the executions whose current execution status matches the given filter.</p>', ], ], 'ExecutionSucceededEventDetails' => [ 'base' => '<p>Contains details about the successful termination of the execution.</p>', 'refs' => [ 'HistoryEvent$executionSucceededEventDetails' => NULL, ], ], 'ExecutionTimedOutEventDetails' => [ 'base' => '<p>Contains details about the execution timeout that occurred during the execution.</p>', 'refs' => [ 'HistoryEvent$executionTimedOutEventDetails' => NULL, ], ], 'GetActivityTaskInput' => [ 'base' => NULL, 'refs' => [], ], 'GetActivityTaskOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetExecutionHistoryInput' => [ 'base' => NULL, 'refs' => [], ], 'GetExecutionHistoryOutput' => [ 'base' => NULL, 'refs' => [], ], 'HistoryEvent' => [ 'base' => '<p>Contains details about the events of an execution.</p>', 'refs' => [ 'HistoryEventList$member' => NULL, ], ], 'HistoryEventList' => [ 'base' => '<p>Contains details about the events that occurred during an execution.</p>', 'refs' => [ 'GetExecutionHistoryOutput$events' => '<p>The list of events that occurred in the execution.</p>', ], ], 'HistoryEventType' => [ 'base' => NULL, 'refs' => [ 'HistoryEvent$type' => '<p>The type of the event.</p>', ], ], 'Identity' => [ 'base' => NULL, 'refs' => [ 'ActivityStartedEventDetails$workerName' => '<p>The name of the worker that the task is assigned to. These names are provided by the workers when calling <a>GetActivityTask</a>.</p>', ], ], 'IncludeExecutionData' => [ 'base' => NULL, 'refs' => [ 'LoggingConfiguration$includeExecutionData' => '<p>Determines whether execution data is included in your log. When set to <code>FALSE</code>, data is excluded.</p>', ], ], 'InvalidArn' => [ 'base' => '<p>The provided Amazon Resource Name (ARN) is invalid.</p>', 'refs' => [], ], 'InvalidDefinition' => [ 'base' => '<p>The provided Amazon States Language definition is invalid.</p>', 'refs' => [], ], 'InvalidExecutionInput' => [ 'base' => '<p>The provided JSON input data is invalid.</p>', 'refs' => [], ], 'InvalidLoggingConfiguration' => [ 'base' => '<p/>', 'refs' => [], ], 'InvalidName' => [ 'base' => '<p>The provided name is invalid.</p>', 'refs' => [], ], 'InvalidOutput' => [ 'base' => '<p>The provided JSON output data is invalid.</p>', 'refs' => [], ], 'InvalidToken' => [ 'base' => '<p>The provided token is invalid.</p>', 'refs' => [], ], 'LambdaFunctionFailedEventDetails' => [ 'base' => '<p>Contains details about a lambda function that failed during an execution.</p>', 'refs' => [ 'HistoryEvent$lambdaFunctionFailedEventDetails' => NULL, ], ], 'LambdaFunctionScheduleFailedEventDetails' => [ 'base' => '<p>Contains details about a failed lambda function schedule event that occurred during an execution.</p>', 'refs' => [ 'HistoryEvent$lambdaFunctionScheduleFailedEventDetails' => NULL, ], ], 'LambdaFunctionScheduledEventDetails' => [ 'base' => '<p>Contains details about a lambda function scheduled during an execution.</p>', 'refs' => [ 'HistoryEvent$lambdaFunctionScheduledEventDetails' => NULL, ], ], 'LambdaFunctionStartFailedEventDetails' => [ 'base' => '<p>Contains details about a lambda function that failed to start during an execution.</p>', 'refs' => [ 'HistoryEvent$lambdaFunctionStartFailedEventDetails' => '<p>Contains details about a lambda function that failed to start during an execution.</p>', ], ], 'LambdaFunctionSucceededEventDetails' => [ 'base' => '<p>Contains details about a lambda function that successfully terminated during an execution.</p>', 'refs' => [ 'HistoryEvent$lambdaFunctionSucceededEventDetails' => '<p>Contains details about a lambda function that terminated successfully during an execution.</p>', ], ], 'LambdaFunctionTimedOutEventDetails' => [ 'base' => '<p>Contains details about a lambda function timeout that occurred during an execution.</p>', 'refs' => [ 'HistoryEvent$lambdaFunctionTimedOutEventDetails' => NULL, ], ], 'ListActivitiesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListActivitiesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListExecutionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListExecutionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListExecutionsPageToken' => [ 'base' => NULL, 'refs' => [ 'ListExecutionsInput$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>', 'ListExecutionsOutput$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>', ], ], 'ListStateMachinesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListStateMachinesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'LogDestination' => [ 'base' => '<p/>', 'refs' => [ 'LogDestinationList$member' => NULL, ], ], 'LogDestinationList' => [ 'base' => NULL, 'refs' => [ 'LoggingConfiguration$destinations' => '<p>An array of objects that describes where your execution history events will be logged. Limited to size 1. Required, if your log level is not set to <code>OFF</code>.</p>', ], ], 'LogLevel' => [ 'base' => NULL, 'refs' => [ 'LoggingConfiguration$level' => '<p>Defines which category of execution history events are logged.</p>', ], ], 'LoggingConfiguration' => [ 'base' => '<p>The <code>LoggingConfiguration</code> data type is used to set CloudWatch Logs options.</p>', 'refs' => [ 'CreateStateMachineInput$loggingConfiguration' => '<p>Defines what execution history events are logged and where they are logged.</p> <note> <p>By default, the <code>level</code> is set to <code>OFF</code>. For more information see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html">Log Levels</a> in the AWS Step Functions User Guide.</p> </note>', 'DescribeStateMachineForExecutionOutput$loggingConfiguration' => NULL, 'DescribeStateMachineOutput$loggingConfiguration' => NULL, 'UpdateStateMachineInput$loggingConfiguration' => '<p>The <code>LoggingConfiguration</code> data type is used to set CloudWatch Logs options.</p>', ], ], 'MapIterationEventDetails' => [ 'base' => '<p>Contains details about an iteration of a Map state.</p>', 'refs' => [ 'HistoryEvent$mapIterationStartedEventDetails' => '<p>Contains details about an iteration of a Map state that was started.</p>', 'HistoryEvent$mapIterationSucceededEventDetails' => '<p>Contains details about an iteration of a Map state that succeeded.</p>', 'HistoryEvent$mapIterationFailedEventDetails' => '<p>Contains details about an iteration of a Map state that failed.</p>', 'HistoryEvent$mapIterationAbortedEventDetails' => '<p>Contains details about an iteration of a Map state that was aborted.</p>', ], ], 'MapStateStartedEventDetails' => [ 'base' => '<p>Details about a Map state that was started.</p>', 'refs' => [ 'HistoryEvent$mapStateStartedEventDetails' => '<p>Contains details about Map state that was started.</p>', ], ], 'MissingRequiredParameter' => [ 'base' => '<p>Request is missing a required parameter. This error occurs if both <code>definition</code> and <code>roleArn</code> are not specified.</p>', 'refs' => [], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'ActivityListItem$name' => '<p>The name of the activity.</p> <p>A name must <i>not</i> contain:</p> <ul> <li> <p>white space</p> </li> <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li> <li> <p>wildcard characters <code>? *</code> </p> </li> <li> <p>special characters <code>" # % \\ ^ | ~ ` $ &amp; , ; : /</code> </p> </li> <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li> </ul> <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>', 'CreateActivityInput$name' => '<p>The name of the activity to create. This name must be unique for your AWS account and region for 90 days. For more information, see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions"> Limits Related to State Machine Executions</a> in the <i>AWS Step Functions Developer Guide</i>.</p> <p>A name must <i>not</i> contain:</p> <ul> <li> <p>white space</p> </li> <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li> <li> <p>wildcard characters <code>? *</code> </p> </li> <li> <p>special characters <code>" # % \\ ^ | ~ ` $ &amp; , ; : /</code> </p> </li> <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li> </ul> <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>', 'CreateStateMachineInput$name' => '<p>The name of the state machine. </p> <p>A name must <i>not</i> contain:</p> <ul> <li> <p>white space</p> </li> <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li> <li> <p>wildcard characters <code>? *</code> </p> </li> <li> <p>special characters <code>" # % \\ ^ | ~ ` $ &amp; , ; : /</code> </p> </li> <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li> </ul> <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>', 'DescribeActivityOutput$name' => '<p>The name of the activity.</p> <p>A name must <i>not</i> contain:</p> <ul> <li> <p>white space</p> </li> <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li> <li> <p>wildcard characters <code>? *</code> </p> </li> <li> <p>special characters <code>" # % \\ ^ | ~ ` $ &amp; , ; : /</code> </p> </li> <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li> </ul> <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>', 'DescribeExecutionOutput$name' => '<p>The name of the execution.</p> <p>A name must <i>not</i> contain:</p> <ul> <li> <p>white space</p> </li> <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li> <li> <p>wildcard characters <code>? *</code> </p> </li> <li> <p>special characters <code>" # % \\ ^ | ~ ` $ &amp; , ; : /</code> </p> </li> <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li> </ul> <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>', 'DescribeStateMachineForExecutionOutput$name' => '<p>The name of the state machine associated with the execution.</p>', 'DescribeStateMachineOutput$name' => '<p>The name of the state machine.</p> <p>A name must <i>not</i> contain:</p> <ul> <li> <p>white space</p> </li> <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li> <li> <p>wildcard characters <code>? *</code> </p> </li> <li> <p>special characters <code>" # % \\ ^ | ~ ` $ &amp; , ; : /</code> </p> </li> <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li> </ul> <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>', 'ExecutionListItem$name' => '<p>The name of the execution.</p> <p>A name must <i>not</i> contain:</p> <ul> <li> <p>white space</p> </li> <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li> <li> <p>wildcard characters <code>? *</code> </p> </li> <li> <p>special characters <code>" # % \\ ^ | ~ ` $ &amp; , ; : /</code> </p> </li> <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li> </ul> <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>', 'GetActivityTaskInput$workerName' => '<p>You can provide an arbitrary name in order to identify the worker that the task is assigned to. This name is used when it is logged in the execution history.</p>', 'MapIterationEventDetails$name' => '<p>The name of the iteration’s parent Map state.</p>', 'StartExecutionInput$name' => '<p>The name of the execution. This name must be unique for your AWS account, region, and state machine for 90 days. For more information, see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions"> Limits Related to State Machine Executions</a> in the <i>AWS Step Functions Developer Guide</i>.</p> <p>A name must <i>not</i> contain:</p> <ul> <li> <p>white space</p> </li> <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li> <li> <p>wildcard characters <code>? *</code> </p> </li> <li> <p>special characters <code>" # % \\ ^ | ~ ` $ &amp; , ; : /</code> </p> </li> <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li> </ul> <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>', 'StateEnteredEventDetails$name' => '<p>The name of the state.</p>', 'StateExitedEventDetails$name' => '<p>The name of the state.</p> <p>A name must <i>not</i> contain:</p> <ul> <li> <p>white space</p> </li> <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li> <li> <p>wildcard characters <code>? *</code> </p> </li> <li> <p>special characters <code>" # % \\ ^ | ~ ` $ &amp; , ; : /</code> </p> </li> <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li> </ul> <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>', 'StateMachineListItem$name' => '<p>The name of the state machine.</p> <p>A name must <i>not</i> contain:</p> <ul> <li> <p>white space</p> </li> <li> <p>brackets <code>&lt; &gt; { } [ ]</code> </p> </li> <li> <p>wildcard characters <code>? *</code> </p> </li> <li> <p>special characters <code>" # % \\ ^ | ~ ` $ &amp; , ; : /</code> </p> </li> <li> <p>control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)</p> </li> </ul> <p>To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.</p>', 'TaskFailedEventDetails$resourceType' => '<p>The action of the resource called by a task state.</p>', 'TaskFailedEventDetails$resource' => '<p>The service name of the resource in a task state.</p>', 'TaskScheduledEventDetails$resourceType' => '<p>The action of the resource called by a task state.</p>', 'TaskScheduledEventDetails$resource' => '<p>The service name of the resource in a task state.</p>', 'TaskScheduledEventDetails$region' => '<p>The region of the scheduled task</p>', 'TaskStartFailedEventDetails$resourceType' => '<p>The action of the resource called by a task state.</p>', 'TaskStartFailedEventDetails$resource' => '<p>The service name of the resource in a task state.</p>', 'TaskStartedEventDetails$resourceType' => '<p>The action of the resource called by a task state.</p>', 'TaskStartedEventDetails$resource' => '<p>The service name of the resource in a task state.</p>', 'TaskSubmitFailedEventDetails$resourceType' => '<p>The action of the resource called by a task state.</p>', 'TaskSubmitFailedEventDetails$resource' => '<p>The service name of the resource in a task state.</p>', 'TaskSubmittedEventDetails$resourceType' => '<p>The action of the resource called by a task state.</p>', 'TaskSubmittedEventDetails$resource' => '<p>The service name of the resource in a task state.</p>', 'TaskSucceededEventDetails$resourceType' => '<p>The action of the resource called by a task state.</p>', 'TaskSucceededEventDetails$resource' => '<p>The service name of the resource in a task state.</p>', 'TaskTimedOutEventDetails$resourceType' => '<p>The action of the resource called by a task state.</p>', 'TaskTimedOutEventDetails$resource' => '<p>The service name of the resource in a task state.</p>', ], ], 'PageSize' => [ 'base' => NULL, 'refs' => [ 'GetExecutionHistoryInput$maxResults' => '<p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p> <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>', 'ListActivitiesInput$maxResults' => '<p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p> <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>', 'ListExecutionsInput$maxResults' => '<p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p> <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>', 'ListStateMachinesInput$maxResults' => '<p>The maximum number of results that are returned per call. You can use <code>nextToken</code> to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default.</p> <p>This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.</p>', ], ], 'PageToken' => [ 'base' => NULL, 'refs' => [ 'GetExecutionHistoryInput$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>', 'GetExecutionHistoryOutput$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>', 'ListActivitiesInput$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>', 'ListActivitiesOutput$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>', 'ListStateMachinesInput$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>', 'ListStateMachinesOutput$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken</i> error.</p>', ], ], 'ResourceNotFound' => [ 'base' => '<p>Could not find the referenced resource. Only state machine and activity ARNs are supported.</p>', 'refs' => [], ], 'ReverseOrder' => [ 'base' => NULL, 'refs' => [ 'GetExecutionHistoryInput$reverseOrder' => '<p>Lists events in descending order of their <code>timeStamp</code>.</p>', ], ], 'SendTaskFailureInput' => [ 'base' => NULL, 'refs' => [], ], 'SendTaskFailureOutput' => [ 'base' => NULL, 'refs' => [], ], 'SendTaskHeartbeatInput' => [ 'base' => NULL, 'refs' => [], ], 'SendTaskHeartbeatOutput' => [ 'base' => NULL, 'refs' => [], ], 'SendTaskSuccessInput' => [ 'base' => NULL, 'refs' => [], ], 'SendTaskSuccessOutput' => [ 'base' => NULL, 'refs' => [], ], 'SensitiveCause' => [ 'base' => NULL, 'refs' => [ 'ActivityFailedEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'ActivityScheduleFailedEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'ActivityTimedOutEventDetails$cause' => '<p>A more detailed explanation of the cause of the timeout.</p>', 'ExecutionAbortedEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'ExecutionFailedEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'ExecutionTimedOutEventDetails$cause' => '<p>A more detailed explanation of the cause of the timeout.</p>', 'LambdaFunctionFailedEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'LambdaFunctionScheduleFailedEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'LambdaFunctionStartFailedEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'LambdaFunctionTimedOutEventDetails$cause' => '<p>A more detailed explanation of the cause of the timeout.</p>', 'SendTaskFailureInput$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'StopExecutionInput$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'TaskFailedEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'TaskStartFailedEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'TaskSubmitFailedEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', 'TaskTimedOutEventDetails$cause' => '<p>A more detailed explanation of the cause of the failure.</p>', ], ], 'SensitiveData' => [ 'base' => NULL, 'refs' => [ 'ActivityScheduledEventDetails$input' => '<p>The JSON data input to the activity task.</p>', 'ActivitySucceededEventDetails$output' => '<p>The JSON data output by the activity task.</p>', 'DescribeExecutionOutput$input' => '<p>The string that contains the JSON input data of the execution.</p>', 'DescribeExecutionOutput$output' => '<p>The JSON output data of the execution.</p> <note> <p>This field is set only if the execution succeeds. If the execution fails, this field is null.</p> </note>', 'ExecutionStartedEventDetails$input' => '<p>The JSON data input to the execution.</p>', 'ExecutionSucceededEventDetails$output' => '<p>The JSON data output by the execution.</p>', 'LambdaFunctionScheduledEventDetails$input' => '<p>The JSON data input to the lambda function.</p>', 'LambdaFunctionSucceededEventDetails$output' => '<p>The JSON data output by the lambda function.</p>', 'SendTaskSuccessInput$output' => '<p>The JSON output of the task.</p>', 'StartExecutionInput$input' => '<p>The string that contains the JSON input data for the execution, for example:</p> <p> <code>"input": "{\\"first_name\\" : \\"test\\"}"</code> </p> <note> <p>If you don\'t include any JSON input data, you still must include the two braces, for example: <code>"input": "{}"</code> </p> </note>', 'StateEnteredEventDetails$input' => '<p>The string that contains the JSON input data for the state.</p>', 'StateExitedEventDetails$output' => '<p>The JSON output data of the state.</p>', 'TaskSubmittedEventDetails$output' => '<p>The response from a resource when a task has started.</p>', 'TaskSucceededEventDetails$output' => '<p>The full JSON response from a resource when a task has succeeded. This response becomes the output of the related task.</p>', ], ], 'SensitiveDataJobInput' => [ 'base' => NULL, 'refs' => [ 'GetActivityTaskOutput$input' => '<p>The string that contains the JSON input data for the task.</p>', ], ], 'SensitiveError' => [ 'base' => NULL, 'refs' => [ 'ActivityFailedEventDetails$error' => '<p>The error code of the failure.</p>', 'ActivityScheduleFailedEventDetails$error' => '<p>The error code of the failure.</p>', 'ActivityTimedOutEventDetails$error' => '<p>The error code of the failure.</p>', 'ExecutionAbortedEventDetails$error' => '<p>The error code of the failure.</p>', 'ExecutionFailedEventDetails$error' => '<p>The error code of the failure.</p>', 'ExecutionTimedOutEventDetails$error' => '<p>The error code of the failure.</p>', 'LambdaFunctionFailedEventDetails$error' => '<p>The error code of the failure.</p>', 'LambdaFunctionScheduleFailedEventDetails$error' => '<p>The error code of the failure.</p>', 'LambdaFunctionStartFailedEventDetails$error' => '<p>The error code of the failure.</p>', 'LambdaFunctionTimedOutEventDetails$error' => '<p>The error code of the failure.</p>', 'SendTaskFailureInput$error' => '<p>The error code of the failure.</p>', 'StopExecutionInput$error' => '<p>The error code of the failure.</p>', 'TaskFailedEventDetails$error' => '<p>The error code of the failure.</p>', 'TaskStartFailedEventDetails$error' => '<p>The error code of the failure.</p>', 'TaskSubmitFailedEventDetails$error' => '<p>The error code of the failure.</p>', 'TaskTimedOutEventDetails$error' => '<p>The error code of the failure.</p>', ], ], 'StartExecutionInput' => [ 'base' => NULL, 'refs' => [], ], 'StartExecutionOutput' => [ 'base' => NULL, 'refs' => [], ], 'StateEnteredEventDetails' => [ 'base' => '<p>Contains details about a state entered during an execution.</p>', 'refs' => [ 'HistoryEvent$stateEnteredEventDetails' => NULL, ], ], 'StateExitedEventDetails' => [ 'base' => '<p>Contains details about an exit from a state during an execution.</p>', 'refs' => [ 'HistoryEvent$stateExitedEventDetails' => NULL, ], ], 'StateMachineAlreadyExists' => [ 'base' => '<p>A state machine with the same name but a different definition or role ARN already exists.</p>', 'refs' => [], ], 'StateMachineDeleting' => [ 'base' => '<p>The specified state machine is being deleted.</p>', 'refs' => [], ], 'StateMachineDoesNotExist' => [ 'base' => '<p>The specified state machine does not exist.</p>', 'refs' => [], ], 'StateMachineLimitExceeded' => [ 'base' => '<p>The maximum number of state machines has been reached. Existing state machines must be deleted before a new state machine can be created.</p>', 'refs' => [], ], 'StateMachineList' => [ 'base' => NULL, 'refs' => [ 'ListStateMachinesOutput$stateMachines' => NULL, ], ], 'StateMachineListItem' => [ 'base' => '<p>Contains details about the state machine.</p>', 'refs' => [ 'StateMachineList$member' => NULL, ], ], 'StateMachineStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeStateMachineOutput$status' => '<p>The current status of the state machine.</p>', ], ], 'StateMachineType' => [ 'base' => NULL, 'refs' => [ 'CreateStateMachineInput$type' => '<p>Determines whether a Standard or Express state machine is created. The default is <code>STANDARD</code>. You cannot update the <code>type</code> of a state machine once it has been created.</p>', 'DescribeStateMachineOutput$type' => '<p>The <code>type</code> of the state machine (<code>STANDARD</code> or <code>EXPRESS</code>).</p>', 'StateMachineListItem$type' => '<p/>', ], ], 'StateMachineTypeNotSupported' => [ 'base' => '<p/>', 'refs' => [], ], 'StopExecutionInput' => [ 'base' => NULL, 'refs' => [], ], 'StopExecutionOutput' => [ 'base' => NULL, 'refs' => [], ], 'Tag' => [ 'base' => '<p>Tags are key-value pairs that can be associated with Step Functions state machines and activities.</p> <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>, and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags</a>.</p> <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$key' => '<p>The key of a tag.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$tagKeys' => '<p>The list of tags to remove from the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateActivityInput$tags' => '<p>The list of tags to add to a resource.</p> <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>, and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags</a>.</p> <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>', 'CreateStateMachineInput$tags' => '<p>Tags to be added when creating a state machine.</p> <p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>, and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags</a>.</p> <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>', 'ListTagsForResourceOutput$tags' => '<p>An array of tags associated with the resource.</p>', 'TagResourceInput$tags' => '<p>The list of tags to add to a resource.</p> <p>Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - @</code>.</p>', ], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$value' => '<p>The value of a tag.</p>', ], ], 'TaskDoesNotExist' => [ 'base' => NULL, 'refs' => [], ], 'TaskFailedEventDetails' => [ 'base' => '<p>Contains details about a task failure event.</p>', 'refs' => [ 'HistoryEvent$taskFailedEventDetails' => '<p>Contains details about the failure of a task.</p>', ], ], 'TaskScheduledEventDetails' => [ 'base' => '<p>Contains details about a task scheduled during an execution.</p>', 'refs' => [ 'HistoryEvent$taskScheduledEventDetails' => '<p>Contains details about a task that was scheduled.</p>', ], ], 'TaskStartFailedEventDetails' => [ 'base' => '<p>Contains details about a task that failed to start during an execution.</p>', 'refs' => [ 'HistoryEvent$taskStartFailedEventDetails' => '<p>Contains details about a task that failed to start.</p>', ], ], 'TaskStartedEventDetails' => [ 'base' => '<p>Contains details about the start of a task during an execution.</p>', 'refs' => [ 'HistoryEvent$taskStartedEventDetails' => '<p>Contains details about a task that was started.</p>', ], ], 'TaskSubmitFailedEventDetails' => [ 'base' => '<p>Contains details about a task that failed to submit during an execution.</p>', 'refs' => [ 'HistoryEvent$taskSubmitFailedEventDetails' => '<p>Contains details about a task that where the submit failed.</p>', ], ], 'TaskSubmittedEventDetails' => [ 'base' => '<p>Contains details about a task submitted to a resource .</p>', 'refs' => [ 'HistoryEvent$taskSubmittedEventDetails' => '<p>Contains details about a submitted task.</p>', ], ], 'TaskSucceededEventDetails' => [ 'base' => '<p>Contains details about the successful completion of a task state.</p>', 'refs' => [ 'HistoryEvent$taskSucceededEventDetails' => '<p>Contains details about a task that succeeded.</p>', ], ], 'TaskTimedOut' => [ 'base' => NULL, 'refs' => [], ], 'TaskTimedOutEventDetails' => [ 'base' => '<p>Contains details about a resource timeout that occurred during an execution.</p>', 'refs' => [ 'HistoryEvent$taskTimedOutEventDetails' => '<p>Contains details about a task that timed out.</p>', ], ], 'TaskToken' => [ 'base' => NULL, 'refs' => [ 'GetActivityTaskOutput$taskToken' => '<p>A token that identifies the scheduled task. This token must be copied and included in subsequent calls to <a>SendTaskHeartbeat</a>, <a>SendTaskSuccess</a> or <a>SendTaskFailure</a> in order to report the progress or completion of the task.</p>', 'SendTaskFailureInput$taskToken' => '<p>The token that represents this task. Task tokens are generated by Step Functions when tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a workflow enters a task state. See <a>GetActivityTaskOutput$taskToken</a>.</p>', 'SendTaskHeartbeatInput$taskToken' => '<p>The token that represents this task. Task tokens are generated by Step Functions when tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a workflow enters a task state. See <a>GetActivityTaskOutput$taskToken</a>.</p>', 'SendTaskSuccessInput$taskToken' => '<p>The token that represents this task. Task tokens are generated by Step Functions when tasks are assigned to a worker, or in the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html">context object</a> when a workflow enters a task state. See <a>GetActivityTaskOutput$taskToken</a>.</p>', ], ], 'TimeoutInSeconds' => [ 'base' => NULL, 'refs' => [ 'ActivityScheduledEventDetails$timeoutInSeconds' => '<p>The maximum allowed duration of the activity task.</p>', 'ActivityScheduledEventDetails$heartbeatInSeconds' => '<p>The maximum allowed duration between two heartbeats for the activity task.</p>', 'LambdaFunctionScheduledEventDetails$timeoutInSeconds' => '<p>The maximum allowed duration of the lambda function.</p>', 'TaskScheduledEventDetails$timeoutInSeconds' => '<p>The maximum allowed duration of the task.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ActivityListItem$creationDate' => '<p>The date the activity is created.</p>', 'CreateActivityOutput$creationDate' => '<p>The date the activity is created.</p>', 'CreateStateMachineOutput$creationDate' => '<p>The date the state machine is created.</p>', 'DescribeActivityOutput$creationDate' => '<p>The date the activity is created.</p>', 'DescribeExecutionOutput$startDate' => '<p>The date the execution is started.</p>', 'DescribeExecutionOutput$stopDate' => '<p>If the execution has already ended, the date the execution stopped.</p>', 'DescribeStateMachineForExecutionOutput$updateDate' => '<p>The date and time the state machine associated with an execution was updated. For a newly created state machine, this is the creation date.</p>', 'DescribeStateMachineOutput$creationDate' => '<p>The date the state machine is created.</p>', 'ExecutionListItem$startDate' => '<p>The date the execution started.</p>', 'ExecutionListItem$stopDate' => '<p>If the execution already ended, the date the execution stopped.</p>', 'HistoryEvent$timestamp' => '<p>The date and time the event occurred.</p>', 'StartExecutionOutput$startDate' => '<p>The date the execution is started.</p>', 'StateMachineListItem$creationDate' => '<p>The date the state machine is created.</p>', 'StopExecutionOutput$stopDate' => '<p>The date the execution is stopped.</p>', 'UpdateStateMachineOutput$updateDate' => '<p>The date and time the state machine was updated.</p>', ], ], 'TooManyTags' => [ 'base' => '<p>You\'ve exceeded the number of tags allowed for a resource. See the <a href="https://docs.aws.amazon.com/step-functions/latest/dg/limits.html"> Limits Topic</a> in the AWS Step Functions Developer Guide.</p>', 'refs' => [], ], 'UnsignedInteger' => [ 'base' => NULL, 'refs' => [ 'MapIterationEventDetails$index' => '<p>The index of the array belonging to the Map state iteration.</p>', 'MapStateStartedEventDetails$length' => '<p>The size of the array for Map state iterations.</p>', ], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStateMachineInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStateMachineOutput' => [ 'base' => NULL, 'refs' => [], ], ],];
