<?php
// This file was auto-generated from sdk-root/src/data/ssm/2014-11-06/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>AWS Systems Manager</fullname> <p>AWS Systems Manager is a collection of capabilities that helps you automate management tasks such as collecting system inventory, applying operating system (OS) patches, automating the creation of Amazon Machine Images (AMIs), and configuring operating systems (OSs) and applications at scale. Systems Manager lets you remotely and securely manage the configuration of your managed instances. A <i>managed instance</i> is any Amazon Elastic Compute Cloud instance (EC2 instance), or any on-premises server or virtual machine (VM) in your hybrid environment that has been configured for Systems Manager.</p> <p>This reference is intended to be used with the <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/">AWS Systems Manager User Guide</a>.</p> <p>To get started, verify prerequisites and configure managed instances. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-setting-up.html">Setting up AWS Systems Manager</a> in the <i>AWS Systems Manager User Guide</i>.</p> <p>For information about other API actions you can perform on EC2 instances, see the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/">Amazon EC2 API Reference</a>. For information about how to use a Query API, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/making-api-requests.html">Making API requests</a>. </p>', 'operations' => [ 'AddTagsToResource' => '<p>Adds or overwrites one or more tags for the specified resource. Tags are metadata that you can assign to your documents, managed instances, maintenance windows, Parameter Store parameters, and patch baselines. Tags enable you to categorize your resources in different ways, for example, by purpose, owner, or environment. Each tag consists of a key and an optional value, both of which you define. For example, you could define a set of tags for your account\'s managed instances that helps you track each instance\'s owner and stack level. For example: Key=Owner and Value=DbAdmin, SysAdmin, or Dev. Or Key=Stack and Value=Production, Pre-Production, or Test.</p> <p>Each resource can have a maximum of 50 tags. </p> <p>We recommend that you devise a set of tag keys that meets your needs for each resource type. Using a consistent set of tag keys makes it easier for you to manage your resources. You can search and filter the resources based on the tags you add. Tags don\'t have any semantic meaning to and are interpreted strictly as a string of characters. </p> <p>For more information about using tags with EC2 instances, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging your Amazon EC2 resources</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'CancelCommand' => '<p>Attempts to cancel the command specified by the Command ID. There is no guarantee that the command will be terminated and the underlying process stopped.</p>', 'CancelMaintenanceWindowExecution' => '<p>Stops a maintenance window execution that is already in progress and cancels any tasks in the window that have not already starting running. (Tasks already in progress will continue to completion.)</p>', 'CreateActivation' => '<p>Generates an activation code and activation ID you can use to register your on-premises server or virtual machine (VM) with Systems Manager. Registering these machines with Systems Manager makes it possible to manage them using Systems Manager capabilities. You use the activation code and ID when installing SSM Agent on machines in your hybrid environment. For more information about requirements for managing on-premises instances and VMs using Systems Manager, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances.html">Setting up AWS Systems Manager for hybrid environments</a> in the <i>AWS Systems Manager User Guide</i>. </p> <note> <p>On-premises servers or VMs that are registered with Systems Manager and EC2 instances that you manage with Systems Manager are all called <i>managed instances</i>.</p> </note>', 'CreateAssociation' => '<p>A State Manager association defines the state that you want to maintain on your instances. For example, an association can specify that anti-virus software must be installed and running on your instances, or that certain ports must be closed. For static targets, the association specifies a schedule for when the configuration is reapplied. For dynamic targets, such as an AWS Resource Group or an AWS Autoscaling Group, State Manager applies the configuration when new instances are added to the group. The association also specifies actions to take when applying the configuration. For example, an association for anti-virus software might run once a day. If the software is not installed, then State Manager installs it. If the software is installed, but the service is not running, then the association might instruct State Manager to start the service. </p>', 'CreateAssociationBatch' => '<p>Associates the specified Systems Manager document with the specified instances or targets.</p> <p>When you associate a document with one or more instances using instance IDs or tags, SSM Agent running on the instance processes the document and configures the instance as specified.</p> <p>If you associate a document with an instance that already has an associated document, the system returns the AssociationAlreadyExists exception.</p>', 'CreateDocument' => '<p>Creates a Systems Manager (SSM) document. An SSM document defines the actions that Systems Manager performs on your managed instances. For more information about SSM documents, including information about supported schemas, features, and syntax, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-ssm-docs.html">AWS Systems Manager Documents</a> in the <i>AWS Systems Manager User Guide</i>.</p>', 'CreateMaintenanceWindow' => '<p>Creates a new maintenance window.</p> <note> <p>The value you specify for <code>Duration</code> determines the specific end time for the maintenance window based on the time it begins. No maintenance window tasks are permitted to start after the resulting endtime minus the number of hours you specify for <code>Cutoff</code>. For example, if the maintenance window starts at 3 PM, the duration is three hours, and the value you specify for <code>Cutoff</code> is one hour, no maintenance window tasks can start after 5 PM.</p> </note>', 'CreateOpsItem' => '<p>Creates a new OpsItem. You must have permission in AWS Identity and Access Management (IAM) to create a new OpsItem. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting started with OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.</p> <p>Operations engineers and IT professionals use OpsCenter to view, investigate, and remediate operational issues impacting the performance and health of their AWS resources. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">AWS Systems Manager OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>. </p>', 'CreatePatchBaseline' => '<p>Creates a patch baseline.</p> <note> <p>For information about valid key and value pairs in <code>PatchFilters</code> for each supported operating system type, see <a href="http://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html">PatchFilter</a>.</p> </note>', 'CreateResourceDataSync' => '<p>A resource data sync helps you view data from multiple sources in a single location. Systems Manager offers two types of resource data sync: <code>SyncToDestination</code> and <code>SyncFromSource</code>.</p> <p>You can configure Systems Manager Inventory to use the <code>SyncToDestination</code> type to synchronize Inventory data from multiple AWS Regions to a single S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-datasync.html">Configuring Resource Data Sync for Inventory</a> in the <i>AWS Systems Manager User Guide</i>.</p> <p>You can configure Systems Manager Explorer to use the <code>SyncFromSource</code> type to synchronize operational work items (OpsItems) and operational data (OpsData) from multiple AWS Regions to a single S3 bucket. This type can synchronize OpsItems and OpsData from multiple AWS accounts and Regions or <code>EntireOrganization</code> by using AWS Organizations. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resource-data-sync.html">Setting up Systems Manager Explorer to display data from multiple accounts and Regions</a> in the <i>AWS Systems Manager User Guide</i>.</p> <p>A resource data sync is an asynchronous operation that returns immediately. After a successful initial sync is completed, the system continuously syncs data. To check the status of a sync, use the <a>ListResourceDataSync</a>.</p> <note> <p>By default, data is not encrypted in Amazon S3. We strongly recommend that you enable encryption in Amazon S3 to ensure secure data storage. We also recommend that you secure access to the Amazon S3 bucket by creating a restrictive bucket policy. </p> </note>', 'DeleteActivation' => '<p>Deletes an activation. You are not required to delete an activation. If you delete an activation, you can no longer use it to register additional managed instances. Deleting an activation does not de-register managed instances. You must manually de-register managed instances.</p>', 'DeleteAssociation' => '<p>Disassociates the specified Systems Manager document from the specified instance.</p> <p>When you disassociate a document from an instance, it does not change the configuration of the instance. To change the configuration state of an instance after you disassociate a document, you must create a new document with the desired configuration and associate it with the instance.</p>', 'DeleteDocument' => '<p>Deletes the Systems Manager document and all instance associations to the document.</p> <p>Before you delete the document, we recommend that you use <a>DeleteAssociation</a> to disassociate all instances that are associated with the document.</p>', 'DeleteInventory' => '<p>Delete a custom inventory type, or the data associated with a custom Inventory type. Deleting a custom inventory type is also referred to as deleting a custom inventory schema.</p>', 'DeleteMaintenanceWindow' => '<p>Deletes a maintenance window.</p>', 'DeleteParameter' => '<p>Delete a parameter from the system.</p>', 'DeleteParameters' => '<p>Delete a list of parameters.</p>', 'DeletePatchBaseline' => '<p>Deletes a patch baseline.</p>', 'DeleteResourceDataSync' => '<p>Deletes a Resource Data Sync configuration. After the configuration is deleted, changes to data on managed instances are no longer synced to or from the target. Deleting a sync configuration does not delete data.</p>', 'DeregisterManagedInstance' => '<p>Removes the server or virtual machine from the list of registered servers. You can reregister the instance again at any time. If you don\'t plan to use Run Command on the server, we suggest uninstalling SSM Agent first.</p>', 'DeregisterPatchBaselineForPatchGroup' => '<p>Removes a patch group from a patch baseline.</p>', 'DeregisterTargetFromMaintenanceWindow' => '<p>Removes a target from a maintenance window.</p>', 'DeregisterTaskFromMaintenanceWindow' => '<p>Removes a task from a maintenance window.</p>', 'DescribeActivations' => '<p>Describes details about the activation, such as the date and time the activation was created, its expiration date, the IAM role assigned to the instances in the activation, and the number of instances registered by using this activation.</p>', 'DescribeAssociation' => '<p>Describes the association for the specified target or instance. If you created the association by using the <code>Targets</code> parameter, then you must retrieve the association by using the association ID. If you created the association by specifying an instance ID and a Systems Manager document, then you retrieve the association by specifying the document name and the instance ID. </p>', 'DescribeAssociationExecutionTargets' => '<p>Use this API action to view information about a specific execution of a specific association.</p>', 'DescribeAssociationExecutions' => '<p>Use this API action to view all executions for a specific association ID. </p>', 'DescribeAutomationExecutions' => '<p>Provides details about all active and terminated Automation executions.</p>', 'DescribeAutomationStepExecutions' => '<p>Information about all active and terminated step executions in an Automation workflow.</p>', 'DescribeAvailablePatches' => '<p>Lists all patches eligible to be included in a patch baseline.</p>', 'DescribeDocument' => '<p>Describes the specified Systems Manager document.</p>', 'DescribeDocumentPermission' => '<p>Describes the permissions for a Systems Manager document. If you created the document, you are the owner. If a document is shared, it can either be shared privately (by specifying a user\'s AWS account ID) or publicly (<i>All</i>). </p>', 'DescribeEffectiveInstanceAssociations' => '<p>All associations for the instance(s).</p>', 'DescribeEffectivePatchesForPatchBaseline' => '<p>Retrieves the current effective patches (the patch and the approval state) for the specified patch baseline. Note that this API applies only to Windows patch baselines.</p>', 'DescribeInstanceAssociationsStatus' => '<p>The status of the associations for the instance(s).</p>', 'DescribeInstanceInformation' => '<p>Describes one or more of your instances, including information about the operating system platform, the version of SSM Agent installed on the instance, instance status, and so on.</p> <p>If you specify one or more instance IDs, it returns information for those instances. If you do not specify instance IDs, it returns information for all your instances. If you specify an instance ID that is not valid or an instance that you do not own, you receive an error.</p> <note> <p>The IamRole field for this API action is the Amazon Identity and Access Management (IAM) role assigned to on-premises instances. This call does not return the IAM role for EC2 instances.</p> </note>', 'DescribeInstancePatchStates' => '<p>Retrieves the high-level patch state of one or more instances.</p>', 'DescribeInstancePatchStatesForPatchGroup' => '<p>Retrieves the high-level patch state for the instances in the specified patch group.</p>', 'DescribeInstancePatches' => '<p>Retrieves information about the patches on the specified instance and their state relative to the patch baseline being used for the instance.</p>', 'DescribeInventoryDeletions' => '<p>Describes a specific delete inventory operation.</p>', 'DescribeMaintenanceWindowExecutionTaskInvocations' => '<p>Retrieves the individual task executions (one per target) for a particular task run as part of a maintenance window execution.</p>', 'DescribeMaintenanceWindowExecutionTasks' => '<p>For a given maintenance window execution, lists the tasks that were run.</p>', 'DescribeMaintenanceWindowExecutions' => '<p>Lists the executions of a maintenance window. This includes information about when the maintenance window was scheduled to be active, and information about tasks registered and run with the maintenance window.</p>', 'DescribeMaintenanceWindowSchedule' => '<p>Retrieves information about upcoming executions of a maintenance window.</p>', 'DescribeMaintenanceWindowTargets' => '<p>Lists the targets registered with the maintenance window.</p>', 'DescribeMaintenanceWindowTasks' => '<p>Lists the tasks in a maintenance window.</p>', 'DescribeMaintenanceWindows' => '<p>Retrieves the maintenance windows in an AWS account.</p>', 'DescribeMaintenanceWindowsForTarget' => '<p>Retrieves information about the maintenance window targets or tasks that an instance is associated with.</p>', 'DescribeOpsItems' => '<p>Query a set of OpsItems. You must have permission in AWS Identity and Access Management (IAM) to query a list of OpsItems. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting started with OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.</p> <p>Operations engineers and IT professionals use OpsCenter to view, investigate, and remediate operational issues impacting the performance and health of their AWS resources. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">AWS Systems Manager OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>. </p>', 'DescribeParameters' => '<p>Get information about a parameter.</p> <note> <p>Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the response includes information up to the limit specified. The number of items returned, however, can be between zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>. You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.</p> </note>', 'DescribePatchBaselines' => '<p>Lists the patch baselines in your AWS account.</p>', 'DescribePatchGroupState' => '<p>Returns high-level aggregated patch compliance state for a patch group.</p>', 'DescribePatchGroups' => '<p>Lists all patch groups that have been registered with patch baselines.</p>', 'DescribePatchProperties' => '<p>Lists the properties of available patches organized by product, product family, classification, severity, and other properties of available patches. You can use the reported properties in the filters you specify in requests for actions such as <a>CreatePatchBaseline</a>, <a>UpdatePatchBaseline</a>, <a>DescribeAvailablePatches</a>, and <a>DescribePatchBaselines</a>.</p> <p>The following section lists the properties that can be used in filters for each major operating system type:</p> <dl> <dt>WINDOWS</dt> <dd> <p>Valid properties: PRODUCT, PRODUCT_FAMILY, CLASSIFICATION, MSRC_SEVERITY</p> </dd> <dt>AMAZON_LINUX</dt> <dd> <p>Valid properties: PRODUCT, CLASSIFICATION, SEVERITY</p> </dd> <dt>AMAZON_LINUX_2</dt> <dd> <p>Valid properties: PRODUCT, CLASSIFICATION, SEVERITY</p> </dd> <dt>UBUNTU </dt> <dd> <p>Valid properties: PRODUCT, PRIORITY</p> </dd> <dt>REDHAT_ENTERPRISE_LINUX</dt> <dd> <p>Valid properties: PRODUCT, CLASSIFICATION, SEVERITY</p> </dd> <dt>SUSE</dt> <dd> <p>Valid properties: PRODUCT, CLASSIFICATION, SEVERITY</p> </dd> <dt>CENTOS</dt> <dd> <p>Valid properties: PRODUCT, CLASSIFICATION, SEVERITY</p> </dd> </dl>', 'DescribeSessions' => '<p>Retrieves a list of all active sessions (both connected and disconnected) or terminated sessions from the past 30 days.</p>', 'GetAutomationExecution' => '<p>Get detailed information about a particular Automation execution.</p>', 'GetCalendarState' => '<p>Gets the state of the AWS Systems Manager Change Calendar at an optional, specified time. If you specify a time, <code>GetCalendarState</code> returns the state of the calendar at a specific time, and returns the next time that the Change Calendar state will transition. If you do not specify a time, <code>GetCalendarState</code> assumes the current time. Change Calendar entries have two possible states: <code>OPEN</code> or <code>CLOSED</code>. For more information about Systems Manager Change Calendar, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar.html">AWS Systems Manager Change Calendar</a> in the <i>AWS Systems Manager User Guide</i>.</p>', 'GetCommandInvocation' => '<p>Returns detailed information about command execution for an invocation or plugin. </p>', 'GetConnectionStatus' => '<p>Retrieves the Session Manager connection status for an instance to determine whether it is running and ready to receive Session Manager connections.</p>', 'GetDefaultPatchBaseline' => '<p>Retrieves the default patch baseline. Note that Systems Manager supports creating multiple default patch baselines. For example, you can create a default patch baseline for each operating system.</p> <p>If you do not specify an operating system value, the default patch baseline for Windows is returned.</p>', 'GetDeployablePatchSnapshotForInstance' => '<p>Retrieves the current snapshot for the patch baseline the instance uses. This API is primarily used by the AWS-RunPatchBaseline Systems Manager document. </p>', 'GetDocument' => '<p>Gets the contents of the specified Systems Manager document.</p>', 'GetInventory' => '<p>Query inventory information.</p>', 'GetInventorySchema' => '<p>Return a list of inventory type names for the account, or return a list of attribute names for a specific Inventory item type.</p>', 'GetMaintenanceWindow' => '<p>Retrieves a maintenance window.</p>', 'GetMaintenanceWindowExecution' => '<p>Retrieves details about a specific a maintenance window execution.</p>', 'GetMaintenanceWindowExecutionTask' => '<p>Retrieves the details about a specific task run as part of a maintenance window execution.</p>', 'GetMaintenanceWindowExecutionTaskInvocation' => '<p>Retrieves information about a specific task running on a specific target.</p>', 'GetMaintenanceWindowTask' => '<p>Lists the tasks in a maintenance window.</p>', 'GetOpsItem' => '<p>Get information about an OpsItem by using the ID. You must have permission in AWS Identity and Access Management (IAM) to view information about an OpsItem. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting started with OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.</p> <p>Operations engineers and IT professionals use OpsCenter to view, investigate, and remediate operational issues impacting the performance and health of their AWS resources. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">AWS Systems Manager OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>. </p>', 'GetOpsSummary' => '<p>View a summary of OpsItems based on specified filters and aggregators.</p>', 'GetParameter' => '<p>Get information about a parameter by using the parameter name. Don\'t confuse this API action with the <a>GetParameters</a> API action.</p>', 'GetParameterHistory' => '<p>Query a list of all parameters used by the AWS account.</p>', 'GetParameters' => '<p>Get details of a parameter. Don\'t confuse this API action with the <a>GetParameter</a> API action.</p>', 'GetParametersByPath' => '<p>Retrieve information about one or more parameters in a specific hierarchy. </p> <note> <p>Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the response includes information up to the limit specified. The number of items returned, however, can be between zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>. You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.</p> </note>', 'GetPatchBaseline' => '<p>Retrieves information about a patch baseline.</p>', 'GetPatchBaselineForPatchGroup' => '<p>Retrieves the patch baseline that should be used for the specified patch group.</p>', 'GetServiceSetting' => '<p> <code>ServiceSetting</code> is an account-level setting for an AWS service. This setting defines how a user interacts with or uses a service or a feature of a service. For example, if an AWS service charges money to the account based on feature or service usage, then the AWS service team might create a default setting of "false". This means the user can\'t use this feature unless they change the setting to "true" and intentionally opt in for a paid feature.</p> <p>Services map a <code>SettingId</code> object to a setting value. AWS services teams define the default value for a <code>SettingId</code>. You can\'t create a new <code>SettingId</code>, but you can overwrite the default value if you have the <code>ssm:UpdateServiceSetting</code> permission for the setting. Use the <a>UpdateServiceSetting</a> API action to change the default setting. Or use the <a>ResetServiceSetting</a> to change the value back to the original value defined by the AWS service team.</p> <p>Query the current service setting for the account. </p>', 'LabelParameterVersion' => '<p>A parameter label is a user-defined alias to help you manage different versions of a parameter. When you modify a parameter, Systems Manager automatically saves a new version and increments the version number by one. A label can help you remember the purpose of a parameter when there are multiple versions. </p> <p>Parameter labels have the following requirements and restrictions.</p> <ul> <li> <p>A version of a parameter can have a maximum of 10 labels.</p> </li> <li> <p>You can\'t attach the same label to different versions of the same parameter. For example, if version 1 has the label Production, then you can\'t attach Production to version 2.</p> </li> <li> <p>You can move a label from one version of a parameter to another.</p> </li> <li> <p>You can\'t create a label when you create a new parameter. You must attach a label to a specific version of a parameter.</p> </li> <li> <p>You can\'t delete a parameter label. If you no longer want to use a parameter label, then you must move it to a different version of a parameter.</p> </li> <li> <p>A label can have a maximum of 100 characters.</p> </li> <li> <p>Labels can contain letters (case sensitive), numbers, periods (.), hyphens (-), or underscores (_).</p> </li> <li> <p>Labels can\'t begin with a number, "aws," or "ssm" (not case sensitive). If a label fails to meet these requirements, then the label is not associated with a parameter and the system displays it in the list of InvalidLabels.</p> </li> </ul>', 'ListAssociationVersions' => '<p>Retrieves all versions of an association for a specific association ID.</p>', 'ListAssociations' => '<p>Returns all State Manager associations in the current AWS account and Region. You can limit the results to a specific State Manager association document or instance by specifying a filter.</p>', 'ListCommandInvocations' => '<p>An invocation is copy of a command sent to a specific instance. A command can apply to one or more instances. A command invocation applies to one instance. For example, if a user runs SendCommand against three instances, then a command invocation is created for each requested instance ID. ListCommandInvocations provide status about command execution.</p>', 'ListCommands' => '<p>Lists the commands requested by users of the AWS account.</p>', 'ListComplianceItems' => '<p>For a specified resource ID, this API action returns a list of compliance statuses for different resource types. Currently, you can only specify one resource ID per call. List results depend on the criteria specified in the filter.</p>', 'ListComplianceSummaries' => '<p>Returns a summary count of compliant and non-compliant resources for a compliance type. For example, this call can return State Manager associations, patches, or custom compliance types according to the filter criteria that you specify.</p>', 'ListDocumentVersions' => '<p>List all versions for a document.</p>', 'ListDocuments' => '<p>Returns all Systems Manager (SSM) documents in the current AWS account and Region. You can limit the results of this request by using a filter.</p>', 'ListInventoryEntries' => '<p>A list of inventory items returned by the request.</p>', 'ListResourceComplianceSummaries' => '<p>Returns a resource-level summary count. The summary includes information about compliant and non-compliant statuses and detailed compliance-item severity counts, according to the filter criteria you specify.</p>', 'ListResourceDataSync' => '<p>Lists your resource data sync configurations. Includes information about the last time a sync attempted to start, the last sync status, and the last time a sync successfully completed.</p> <p>The number of sync configurations might be too large to return using a single call to <code>ListResourceDataSync</code>. You can limit the number of sync configurations returned by using the <code>MaxResults</code> parameter. To determine whether there are more sync configurations to list, check the value of <code>NextToken</code> in the output. If there are more sync configurations to list, you can request them by specifying the <code>NextToken</code> returned in the call to the parameter of a subsequent call. </p>', 'ListTagsForResource' => '<p>Returns a list of the tags assigned to the specified resource.</p>', 'ModifyDocumentPermission' => '<p>Shares a Systems Manager document publicly or privately. If you share a document privately, you must specify the AWS user account IDs for those people who can use the document. If you share a document publicly, you must specify <i>All</i> as the account ID.</p>', 'PutComplianceItems' => '<p>Registers a compliance type and other compliance details on a designated resource. This action lets you register custom compliance details with a resource. This call overwrites existing compliance information on the resource, so you must provide a full list of compliance items each time that you send the request.</p> <p>ComplianceType can be one of the following:</p> <ul> <li> <p>ExecutionId: The execution ID when the patch, association, or custom compliance item was applied.</p> </li> <li> <p>ExecutionType: Specify patch, association, or Custom:<code>string</code>.</p> </li> <li> <p>ExecutionTime. The time the patch, association, or custom compliance item was applied to the instance.</p> </li> <li> <p>Id: The patch, association, or custom compliance ID.</p> </li> <li> <p>Title: A title.</p> </li> <li> <p>Status: The status of the compliance item. For example, <code>approved</code> for patches, or <code>Failed</code> for associations.</p> </li> <li> <p>Severity: A patch severity. For example, <code>critical</code>.</p> </li> <li> <p>DocumentName: A SSM document name. For example, AWS-RunPatchBaseline.</p> </li> <li> <p>DocumentVersion: An SSM document version number. For example, 4.</p> </li> <li> <p>Classification: A patch classification. For example, <code>security updates</code>.</p> </li> <li> <p>PatchBaselineId: A patch baseline ID.</p> </li> <li> <p>PatchSeverity: A patch severity. For example, <code>Critical</code>.</p> </li> <li> <p>PatchState: A patch state. For example, <code>InstancesWithFailedPatches</code>.</p> </li> <li> <p>PatchGroup: The name of a patch group.</p> </li> <li> <p>InstalledTime: The time the association, patch, or custom compliance item was applied to the resource. Specify the time by using the following format: yyyy-MM-dd\'T\'HH:mm:ss\'Z\'</p> </li> </ul>', 'PutInventory' => '<p>Bulk update custom inventory items on one more instance. The request adds an inventory item, if it doesn\'t already exist, or updates an inventory item, if it does exist.</p>', 'PutParameter' => '<p>Add a parameter to the system.</p>', 'RegisterDefaultPatchBaseline' => '<p>Defines the default patch baseline for the relevant operating system.</p> <p>To reset the AWS predefined patch baseline as the default, specify the full patch baseline ARN as the baseline ID value. For example, for CentOS, specify <code>arn:aws:ssm:us-east-2:733109147000:patchbaseline/pb-0574b43a65ea646ed</code> instead of <code>pb-0574b43a65ea646ed</code>.</p>', 'RegisterPatchBaselineForPatchGroup' => '<p>Registers a patch baseline for a patch group.</p>', 'RegisterTargetWithMaintenanceWindow' => '<p>Registers a target with a maintenance window.</p>', 'RegisterTaskWithMaintenanceWindow' => '<p>Adds a new task to a maintenance window.</p>', 'RemoveTagsFromResource' => '<p>Removes tag keys from the specified resource.</p>', 'ResetServiceSetting' => '<p> <code>ServiceSetting</code> is an account-level setting for an AWS service. This setting defines how a user interacts with or uses a service or a feature of a service. For example, if an AWS service charges money to the account based on feature or service usage, then the AWS service team might create a default setting of "false". This means the user can\'t use this feature unless they change the setting to "true" and intentionally opt in for a paid feature.</p> <p>Services map a <code>SettingId</code> object to a setting value. AWS services teams define the default value for a <code>SettingId</code>. You can\'t create a new <code>SettingId</code>, but you can overwrite the default value if you have the <code>ssm:UpdateServiceSetting</code> permission for the setting. Use the <a>GetServiceSetting</a> API action to view the current value. Use the <a>UpdateServiceSetting</a> API action to change the default setting. </p> <p>Reset the service setting for the account to the default value as provisioned by the AWS service team. </p>', 'ResumeSession' => '<p>Reconnects a session to an instance after it has been disconnected. Connections can be resumed for disconnected sessions, but not terminated sessions.</p> <note> <p>This command is primarily for use by client machines to automatically reconnect during intermittent network issues. It is not intended for any other use.</p> </note>', 'SendAutomationSignal' => '<p>Sends a signal to an Automation execution to change the current behavior or status of the execution. </p>', 'SendCommand' => '<p>Runs commands on one or more managed instances.</p>', 'StartAssociationsOnce' => '<p>Use this API action to run an association immediately and only one time. This action can be helpful when troubleshooting associations.</p>', 'StartAutomationExecution' => '<p>Initiates execution of an Automation document.</p>', 'StartSession' => '<p>Initiates a connection to a target (for example, an instance) for a Session Manager session. Returns a URL and token that can be used to open a WebSocket connection for sending input and receiving outputs.</p> <note> <p>AWS CLI usage: <code>start-session</code> is an interactive command that requires the Session Manager plugin to be installed on the client machine making the call. For information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-working-with-install-plugin.html">Install the Session Manager plugin for the AWS CLI</a> in the <i>AWS Systems Manager User Guide</i>.</p> <p>AWS Tools for PowerShell usage: Start-SSMSession is not currently supported by AWS Tools for PowerShell on Windows local machines.</p> </note>', 'StopAutomationExecution' => '<p>Stop an Automation that is currently running.</p>', 'TerminateSession' => '<p>Permanently ends a session and closes the data connection between the Session Manager client and SSM Agent on the instance. A terminated session cannot be resumed.</p>', 'UpdateAssociation' => '<p>Updates an association. You can update the association name and version, the document version, schedule, parameters, and Amazon S3 output. </p> <p>In order to call this API action, your IAM user account, group, or role must be configured with permission to call the <a>DescribeAssociation</a> API action. If you don\'t have permission to call DescribeAssociation, then you receive the following error: <code>An error occurred (AccessDeniedException) when calling the UpdateAssociation operation: User: &lt;user_arn&gt; is not authorized to perform: ssm:DescribeAssociation on resource: &lt;resource_arn&gt;</code> </p> <important> <p>When you update an association, the association immediately runs against the specified targets.</p> </important>', 'UpdateAssociationStatus' => '<p>Updates the status of the Systems Manager document associated with the specified instance.</p>', 'UpdateDocument' => '<p>Updates one or more values for an SSM document.</p>', 'UpdateDocumentDefaultVersion' => '<p>Set the default version of a document. </p>', 'UpdateMaintenanceWindow' => '<p>Updates an existing maintenance window. Only specified parameters are modified.</p> <note> <p>The value you specify for <code>Duration</code> determines the specific end time for the maintenance window based on the time it begins. No maintenance window tasks are permitted to start after the resulting endtime minus the number of hours you specify for <code>Cutoff</code>. For example, if the maintenance window starts at 3 PM, the duration is three hours, and the value you specify for <code>Cutoff</code> is one hour, no maintenance window tasks can start after 5 PM.</p> </note>', 'UpdateMaintenanceWindowTarget' => '<p>Modifies the target of an existing maintenance window. You can change the following:</p> <ul> <li> <p>Name</p> </li> <li> <p>Description</p> </li> <li> <p>Owner</p> </li> <li> <p>IDs for an ID target</p> </li> <li> <p>Tags for a Tag target</p> </li> <li> <p>From any supported tag type to another. The three supported tag types are ID target, Tag target, and resource group. For more information, see <a>Target</a>.</p> </li> </ul> <note> <p>If a parameter is null, then the corresponding field is not modified.</p> </note>', 'UpdateMaintenanceWindowTask' => '<p>Modifies a task assigned to a maintenance window. You can\'t change the task type, but you can change the following values:</p> <ul> <li> <p>TaskARN. For example, you can change a RUN_COMMAND task from AWS-RunPowerShellScript to AWS-RunShellScript.</p> </li> <li> <p>ServiceRoleArn</p> </li> <li> <p>TaskInvocationParameters</p> </li> <li> <p>Priority</p> </li> <li> <p>MaxConcurrency</p> </li> <li> <p>MaxErrors</p> </li> </ul> <p>If a parameter is null, then the corresponding field is not modified. Also, if you set Replace to true, then all fields required by the <a>RegisterTaskWithMaintenanceWindow</a> action are required for this request. Optional fields that aren\'t specified are set to null.</p>', 'UpdateManagedInstanceRole' => '<p>Changes the Amazon Identity and Access Management (IAM) role that is assigned to the on-premises instance or virtual machines (VM). IAM roles are first assigned to these hybrid instances during the activation process. For more information, see <a>CreateActivation</a>.</p>', 'UpdateOpsItem' => '<p>Edit or change an OpsItem. You must have permission in AWS Identity and Access Management (IAM) to update an OpsItem. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting started with OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.</p> <p>Operations engineers and IT professionals use OpsCenter to view, investigate, and remediate operational issues impacting the performance and health of their AWS resources. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">AWS Systems Manager OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>. </p>', 'UpdatePatchBaseline' => '<p>Modifies an existing patch baseline. Fields not specified in the request are left unchanged.</p> <note> <p>For information about valid key and value pairs in <code>PatchFilters</code> for each supported operating system type, see <a href="http://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html">PatchFilter</a>.</p> </note>', 'UpdateResourceDataSync' => '<p>Update a resource data sync. After you create a resource data sync for a Region, you can\'t change the account options for that sync. For example, if you create a sync in the us-east-2 (Ohio) Region and you choose the Include only the current account option, you can\'t edit that sync later and choose the Include all accounts from my AWS Organizations configuration option. Instead, you must delete the first resource data sync, and create a new one.</p> <note> <p>This API action only supports a resource data sync that was created with a SyncFromSource <code>SyncType</code>.</p> </note>', 'UpdateServiceSetting' => '<p> <code>ServiceSetting</code> is an account-level setting for an AWS service. This setting defines how a user interacts with or uses a service or a feature of a service. For example, if an AWS service charges money to the account based on feature or service usage, then the AWS service team might create a default setting of "false". This means the user can\'t use this feature unless they change the setting to "true" and intentionally opt in for a paid feature.</p> <p>Services map a <code>SettingId</code> object to a setting value. AWS services teams define the default value for a <code>SettingId</code>. You can\'t create a new <code>SettingId</code>, but you can overwrite the default value if you have the <code>ssm:UpdateServiceSetting</code> permission for the setting. Use the <a>GetServiceSetting</a> API action to view the current value. Or, use the <a>ResetServiceSetting</a> to change the value back to the original value defined by the AWS service team.</p> <p>Update the service setting for the account. </p>', ], 'shapes' => [ 'Account' => [ 'base' => NULL, 'refs' => [ 'Accounts$member' => NULL, ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'AccountIdList$member' => NULL, 'AccountSharingInfo$AccountId' => '<p>The AWS account ID where the current document is shared.</p>', ], ], 'AccountIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeDocumentPermissionResponse$AccountIds' => '<p>The account IDs that have permission to use this document. The ID can be either an AWS account or <i>All</i>.</p>', 'ModifyDocumentPermissionRequest$AccountIdsToAdd' => '<p>The AWS user accounts that should have access to the document. The account IDs can either be a group of account IDs or <i>All</i>.</p>', 'ModifyDocumentPermissionRequest$AccountIdsToRemove' => '<p>The AWS user accounts that should no longer have access to the document. The AWS user account can either be a group of account IDs or <i>All</i>. This action has a higher priority than <i>AccountIdsToAdd</i>. If you specify an account ID to add and the same ID to remove, the system removes access to the document.</p>', ], ], 'AccountSharingInfo' => [ 'base' => '<p>Information includes the AWS account ID where the current document is shared and the version shared with that account.</p>', 'refs' => [ 'AccountSharingInfoList$member' => NULL, ], ], 'AccountSharingInfoList' => [ 'base' => '<p>A list of of AWS accounts where the current document is shared and the version shared with each account.</p>', 'refs' => [ 'DescribeDocumentPermissionResponse$AccountSharingInfoList' => '<p>A list of AWS accounts where the current document is shared and the version shared with each account.</p>', ], ], 'Accounts' => [ 'base' => NULL, 'refs' => [ 'TargetLocation$Accounts' => '<p>The AWS accounts targeted by the current Automation execution.</p>', ], ], 'Activation' => [ 'base' => '<p>An activation registers one or more on-premises servers or virtual machines (VMs) with AWS so that you can configure those servers or VMs using Run Command. A server or VM that has been registered with AWS is called a managed instance.</p>', 'refs' => [ 'ActivationList$member' => NULL, ], ], 'ActivationCode' => [ 'base' => NULL, 'refs' => [ 'CreateActivationResult$ActivationCode' => '<p>The code the system generates when it processes the activation. The activation code functions like a password to validate the activation ID. </p>', ], ], 'ActivationDescription' => [ 'base' => NULL, 'refs' => [ 'Activation$Description' => '<p>A user defined description of the activation.</p>', 'CreateActivationRequest$Description' => '<p>A user-defined description of the resource that you want to register with Systems Manager. </p> <important> <p>Do not enter personally identifiable information in this field.</p> </important>', ], ], 'ActivationId' => [ 'base' => NULL, 'refs' => [ 'Activation$ActivationId' => '<p>The ID created by Systems Manager when you submitted the activation.</p>', 'CreateActivationResult$ActivationId' => '<p>The ID number generated by the system when it processed the activation. The activation ID functions like a user name.</p>', 'DeleteActivationRequest$ActivationId' => '<p>The ID of the activation that you want to delete.</p>', 'InstanceInformation$ActivationId' => '<p>The activation ID created by Systems Manager when the server or VM was registered.</p>', ], ], 'ActivationList' => [ 'base' => NULL, 'refs' => [ 'DescribeActivationsResult$ActivationList' => '<p>A list of activations for your AWS account.</p>', ], ], 'AddTagsToResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'AddTagsToResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'AgentErrorCode' => [ 'base' => NULL, 'refs' => [ 'InstanceAssociationStatusInfo$ErrorCode' => '<p>An error code returned by the request to create the association.</p>', ], ], 'AggregatorSchemaOnly' => [ 'base' => NULL, 'refs' => [ 'GetInventorySchemaRequest$Aggregator' => '<p>Returns inventory schemas that support aggregation. For example, this call returns the <code>AWS:InstanceInformation</code> type, because it supports aggregation based on the <code>PlatformName</code>, <code>PlatformType</code>, and <code>PlatformVersion</code> attributes.</p>', ], ], 'AllowedPattern' => [ 'base' => NULL, 'refs' => [ 'ParameterHistory$AllowedPattern' => '<p>Parameter names can include the following letters and symbols.</p> <p>a-zA-Z0-9_.-</p>', 'ParameterMetadata$AllowedPattern' => '<p>A parameter name can include only the following letters and symbols.</p> <p>a-zA-Z0-9_.-</p>', 'PutParameterRequest$AllowedPattern' => '<p>A regular expression used to validate the parameter value. For example, for String types with values restricted to numbers, you can specify the following: AllowedPattern=^\\d+$ </p>', ], ], 'AlreadyExistsException' => [ 'base' => '<p>Error returned if an attempt is made to register a patch group with a patch baseline that is already registered with a different patch baseline.</p>', 'refs' => [], ], 'ApplyOnlyAtCronInterval' => [ 'base' => NULL, 'refs' => [ 'AssociationDescription$ApplyOnlyAtCronInterval' => '<p>By default, when you create a new associations, the system runs it immediately after it is created and then according to the schedule you specified. Specify this option if you don\'t want an association to run immediately after you create it.</p>', 'AssociationVersionInfo$ApplyOnlyAtCronInterval' => '<p>By default, when you create a new associations, the system runs it immediately after it is created and then according to the schedule you specified. Specify this option if you don\'t want an association to run immediately after you create it.</p>', 'CreateAssociationBatchRequestEntry$ApplyOnlyAtCronInterval' => '<p>By default, when you create a new associations, the system runs it immediately after it is created and then according to the schedule you specified. Specify this option if you don\'t want an association to run immediately after you create it.</p>', 'CreateAssociationRequest$ApplyOnlyAtCronInterval' => '<p>By default, when you create a new associations, the system runs it immediately after it is created and then according to the schedule you specified. Specify this option if you don\'t want an association to run immediately after you create it.</p>', 'UpdateAssociationRequest$ApplyOnlyAtCronInterval' => '<p>By default, when you update an association, the system runs it immediately after it is updated and then according to the schedule you specified. Specify this option if you don\'t want an association to run immediately after you update it.</p> <p>Also, if you specified this option when you created the association, you can reset it. To do so, specify the <code>no-apply-only-at-cron-interval</code> parameter when you update the association from the command line. This parameter forces the association to run immediately after updating it and according to the interval specified.</p>', ], ], 'ApproveAfterDays' => [ 'base' => NULL, 'refs' => [ 'PatchRule$ApproveAfterDays' => '<p>The number of days after the release date of each patch matched by the rule that the patch is marked as approved in the patch baseline. For example, a value of <code>7</code> means that patches are approved seven days after they are released. Not supported on Ubuntu Server.</p>', ], ], 'AssociatedInstances' => [ 'base' => '<p>You must disassociate a document from all instances before you can delete it.</p>', 'refs' => [], ], 'Association' => [ 'base' => '<p>Describes an association of a Systems Manager document and an instance.</p>', 'refs' => [ 'AssociationList$member' => NULL, ], ], 'AssociationAlreadyExists' => [ 'base' => '<p>The specified association already exists.</p>', 'refs' => [], ], 'AssociationComplianceSeverity' => [ 'base' => NULL, 'refs' => [ 'AssociationDescription$ComplianceSeverity' => '<p>The severity level that is assigned to the association.</p>', 'AssociationVersionInfo$ComplianceSeverity' => '<p>The severity level that is assigned to the association.</p>', 'CreateAssociationBatchRequestEntry$ComplianceSeverity' => '<p>The severity level to assign to the association.</p>', 'CreateAssociationRequest$ComplianceSeverity' => '<p>The severity level to assign to the association.</p>', 'UpdateAssociationRequest$ComplianceSeverity' => '<p>The severity level to assign to the association.</p>', ], ], 'AssociationDescription' => [ 'base' => '<p>Describes the parameters for a document.</p>', 'refs' => [ 'AssociationDescriptionList$member' => NULL, 'CreateAssociationResult$AssociationDescription' => '<p>Information about the association.</p>', 'DescribeAssociationResult$AssociationDescription' => '<p>Information about the association.</p>', 'UpdateAssociationResult$AssociationDescription' => '<p>The description of the association that was updated.</p>', 'UpdateAssociationStatusResult$AssociationDescription' => '<p>Information about the association.</p>', ], ], 'AssociationDescriptionList' => [ 'base' => NULL, 'refs' => [ 'CreateAssociationBatchResult$Successful' => '<p>Information about the associations that succeeded.</p>', ], ], 'AssociationDoesNotExist' => [ 'base' => '<p>The specified association does not exist.</p>', 'refs' => [], ], 'AssociationExecution' => [ 'base' => '<p>Includes information about the specified association.</p>', 'refs' => [ 'AssociationExecutionsList$member' => NULL, ], ], 'AssociationExecutionDoesNotExist' => [ 'base' => '<p>The specified execution ID does not exist. Verify the ID number and try again.</p>', 'refs' => [], ], 'AssociationExecutionFilter' => [ 'base' => '<p>Filters used in the request.</p>', 'refs' => [ 'AssociationExecutionFilterList$member' => NULL, ], ], 'AssociationExecutionFilterKey' => [ 'base' => NULL, 'refs' => [ 'AssociationExecutionFilter$Key' => '<p>The key value used in the request.</p>', ], ], 'AssociationExecutionFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeAssociationExecutionsRequest$Filters' => '<p>Filters for the request. You can specify the following filters and values.</p> <p>ExecutionId (EQUAL)</p> <p>Status (EQUAL)</p> <p>CreatedTime (EQUAL, GREATER_THAN, LESS_THAN)</p>', ], ], 'AssociationExecutionFilterValue' => [ 'base' => NULL, 'refs' => [ 'AssociationExecutionFilter$Value' => '<p>The value specified for the key.</p>', ], ], 'AssociationExecutionId' => [ 'base' => NULL, 'refs' => [ 'AssociationExecution$ExecutionId' => '<p>The execution ID for the association.</p>', 'AssociationExecutionTarget$ExecutionId' => '<p>The execution ID.</p>', 'DescribeAssociationExecutionTargetsRequest$ExecutionId' => '<p>The execution ID for which you want to view details.</p>', ], ], 'AssociationExecutionTarget' => [ 'base' => '<p>Includes information about the specified association execution.</p>', 'refs' => [ 'AssociationExecutionTargetsList$member' => NULL, ], ], 'AssociationExecutionTargetsFilter' => [ 'base' => '<p>Filters for the association execution.</p>', 'refs' => [ 'AssociationExecutionTargetsFilterList$member' => NULL, ], ], 'AssociationExecutionTargetsFilterKey' => [ 'base' => NULL, 'refs' => [ 'AssociationExecutionTargetsFilter$Key' => '<p>The key value used in the request.</p>', ], ], 'AssociationExecutionTargetsFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeAssociationExecutionTargetsRequest$Filters' => '<p>Filters for the request. You can specify the following filters and values.</p> <p>Status (EQUAL)</p> <p>ResourceId (EQUAL)</p> <p>ResourceType (EQUAL)</p>', ], ], 'AssociationExecutionTargetsFilterValue' => [ 'base' => NULL, 'refs' => [ 'AssociationExecutionTargetsFilter$Value' => '<p>The value specified for the key.</p>', ], ], 'AssociationExecutionTargetsList' => [ 'base' => NULL, 'refs' => [ 'DescribeAssociationExecutionTargetsResult$AssociationExecutionTargets' => '<p>Information about the execution.</p>', ], ], 'AssociationExecutionsList' => [ 'base' => NULL, 'refs' => [ 'DescribeAssociationExecutionsResult$AssociationExecutions' => '<p>A list of the executions for the specified association ID.</p>', ], ], 'AssociationFilter' => [ 'base' => '<p>Describes a filter.</p>', 'refs' => [ 'AssociationFilterList$member' => NULL, ], ], 'AssociationFilterKey' => [ 'base' => NULL, 'refs' => [ 'AssociationFilter$key' => '<p>The name of the filter.</p>', ], ], 'AssociationFilterList' => [ 'base' => NULL, 'refs' => [ 'ListAssociationsRequest$AssociationFilterList' => '<p>One or more filters. Use a filter to return a more specific list of results.</p>', ], ], 'AssociationFilterOperatorType' => [ 'base' => NULL, 'refs' => [ 'AssociationExecutionFilter$Type' => '<p>The filter type specified in the request.</p>', ], ], 'AssociationFilterValue' => [ 'base' => NULL, 'refs' => [ 'AssociationFilter$value' => '<p>The filter value.</p>', ], ], 'AssociationId' => [ 'base' => NULL, 'refs' => [ 'Association$AssociationId' => '<p>The ID created by the system when you create an association. An association is a binding between a document and a set of targets with a schedule.</p>', 'AssociationDescription$AssociationId' => '<p>The association ID.</p>', 'AssociationExecution$AssociationId' => '<p>The association ID.</p>', 'AssociationExecutionTarget$AssociationId' => '<p>The association ID.</p>', 'AssociationIdList$member' => NULL, 'AssociationVersionInfo$AssociationId' => '<p>The ID created by the system when the association was created.</p>', 'DeleteAssociationRequest$AssociationId' => '<p>The association ID that you want to delete.</p>', 'DescribeAssociationExecutionTargetsRequest$AssociationId' => '<p>The association ID that includes the execution for which you want to view details.</p>', 'DescribeAssociationExecutionsRequest$AssociationId' => '<p>The association ID for which you want to view execution history details.</p>', 'DescribeAssociationRequest$AssociationId' => '<p>The association ID for which you want information.</p>', 'InstanceAssociation$AssociationId' => '<p>The association ID.</p>', 'InstanceAssociationStatusInfo$AssociationId' => '<p>The association ID.</p>', 'ListAssociationVersionsRequest$AssociationId' => '<p>The association ID for which you want to view all versions.</p>', 'UpdateAssociationRequest$AssociationId' => '<p>The ID of the association you want to update. </p>', ], ], 'AssociationIdList' => [ 'base' => NULL, 'refs' => [ 'StartAssociationsOnceRequest$AssociationIds' => '<p>The association IDs that you want to run immediately and only one time.</p>', ], ], 'AssociationLimitExceeded' => [ 'base' => '<p>You can have at most 2,000 active associations.</p>', 'refs' => [], ], 'AssociationList' => [ 'base' => NULL, 'refs' => [ 'ListAssociationsResult$Associations' => '<p>The associations.</p>', ], ], 'AssociationName' => [ 'base' => NULL, 'refs' => [ 'Association$AssociationName' => '<p>The association name.</p>', 'AssociationDescription$AssociationName' => '<p>The association name.</p>', 'AssociationVersionInfo$AssociationName' => '<p>The name specified for the association version when the association version was created.</p>', 'CreateAssociationBatchRequestEntry$AssociationName' => '<p>Specify a descriptive name for the association.</p>', 'CreateAssociationRequest$AssociationName' => '<p>Specify a descriptive name for the association.</p>', 'InstanceAssociationStatusInfo$AssociationName' => '<p>The name of the association applied to the instance.</p>', 'UpdateAssociationRequest$AssociationName' => '<p>The name of the association that you want to update.</p>', ], ], 'AssociationOverview' => [ 'base' => '<p>Information about the association.</p>', 'refs' => [ 'Association$Overview' => '<p>Information about the association.</p>', 'AssociationDescription$Overview' => '<p>Information about the association.</p>', ], ], 'AssociationResourceId' => [ 'base' => NULL, 'refs' => [ 'AssociationExecutionTarget$ResourceId' => '<p>The resource ID, for example, the instance ID where the association ran.</p>', ], ], 'AssociationResourceType' => [ 'base' => NULL, 'refs' => [ 'AssociationExecutionTarget$ResourceType' => '<p>The resource type, for example, instance.</p>', ], ], 'AssociationStatus' => [ 'base' => '<p>Describes an association status.</p>', 'refs' => [ 'AssociationDescription$Status' => '<p>The association status.</p>', 'UpdateAssociationStatusRequest$AssociationStatus' => '<p>The association status.</p>', ], ], 'AssociationStatusAggregatedCount' => [ 'base' => NULL, 'refs' => [ 'AssociationOverview$AssociationStatusAggregatedCount' => '<p>Returns the number of targets for the association status. For example, if you created an association with two instances, and one of them was successful, this would return the count of instances by status.</p>', ], ], 'AssociationStatusName' => [ 'base' => NULL, 'refs' => [ 'AssociationStatus$Name' => '<p>The status.</p>', ], ], 'AssociationSyncCompliance' => [ 'base' => NULL, 'refs' => [ 'AssociationDescription$SyncCompliance' => '<p>The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association execution to determine the compliance status. If the association execution runs successfully, then the association is <code>COMPLIANT</code>. If the association execution doesn\'t run successfully, the association is <code>NON-COMPLIANT</code>.</p> <p>In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the <a>PutComplianceItems</a> API action. In this case, compliance data is not managed by State Manager. It is managed by your direct call to the <a>PutComplianceItems</a> API action.</p> <p>By default, all associations use <code>AUTO</code> mode.</p>', 'AssociationVersionInfo$SyncCompliance' => '<p>The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association execution to determine the compliance status. If the association execution runs successfully, then the association is <code>COMPLIANT</code>. If the association execution doesn\'t run successfully, the association is <code>NON-COMPLIANT</code>.</p> <p>In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the <a>PutComplianceItems</a> API action. In this case, compliance data is not managed by State Manager. It is managed by your direct call to the <a>PutComplianceItems</a> API action.</p> <p>By default, all associations use <code>AUTO</code> mode.</p>', 'CreateAssociationBatchRequestEntry$SyncCompliance' => '<p>The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association execution to determine the compliance status. If the association execution runs successfully, then the association is <code>COMPLIANT</code>. If the association execution doesn\'t run successfully, the association is <code>NON-COMPLIANT</code>. </p> <p>In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the <a>PutComplianceItems</a> API action. In this case, compliance data is not managed by State Manager. It is managed by your direct call to the <a>PutComplianceItems</a> API action.</p> <p>By default, all associations use <code>AUTO</code> mode.</p>', 'CreateAssociationRequest$SyncCompliance' => '<p>The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association execution to determine the compliance status. If the association execution runs successfully, then the association is <code>COMPLIANT</code>. If the association execution doesn\'t run successfully, the association is <code>NON-COMPLIANT</code>.</p> <p>In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the <a>PutComplianceItems</a> API action. In this case, compliance data is not managed by State Manager. It is managed by your direct call to the <a>PutComplianceItems</a> API action.</p> <p>By default, all associations use <code>AUTO</code> mode.</p>', 'UpdateAssociationRequest$SyncCompliance' => '<p>The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association execution to determine the compliance status. If the association execution runs successfully, then the association is <code>COMPLIANT</code>. If the association execution doesn\'t run successfully, the association is <code>NON-COMPLIANT</code>.</p> <p>In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the <a>PutComplianceItems</a> API action. In this case, compliance data is not managed by State Manager. It is managed by your direct call to the <a>PutComplianceItems</a> API action.</p> <p>By default, all associations use <code>AUTO</code> mode.</p>', ], ], 'AssociationVersion' => [ 'base' => NULL, 'refs' => [ 'Association$AssociationVersion' => '<p>The association version.</p>', 'AssociationDescription$AssociationVersion' => '<p>The association version.</p>', 'AssociationExecution$AssociationVersion' => '<p>The association version.</p>', 'AssociationExecutionTarget$AssociationVersion' => '<p>The association version.</p>', 'AssociationVersionInfo$AssociationVersion' => '<p>The association version.</p>', 'DescribeAssociationRequest$AssociationVersion' => '<p>Specify the association version to retrieve. To view the latest version, either specify <code>$LATEST</code> for this parameter, or omit this parameter. To view a list of all associations for an instance, use <a>ListAssociations</a>. To get a list of versions for a specific association, use <a>ListAssociationVersions</a>. </p>', 'InstanceAssociation$AssociationVersion' => '<p>Version information for the association on the instance.</p>', 'InstanceAssociationStatusInfo$AssociationVersion' => '<p>The version of the association applied to the instance.</p>', 'UpdateAssociationRequest$AssociationVersion' => '<p>This parameter is provided for concurrency control purposes. You must specify the latest association version in the service. If you want to ensure that this request succeeds, either specify <code>$LATEST</code>, or omit this parameter.</p>', ], ], 'AssociationVersionInfo' => [ 'base' => '<p>Information about the association version.</p>', 'refs' => [ 'AssociationVersionList$member' => NULL, ], ], 'AssociationVersionLimitExceeded' => [ 'base' => '<p>You have reached the maximum number versions allowed for an association. Each association has a limit of 1,000 versions. </p>', 'refs' => [], ], 'AssociationVersionList' => [ 'base' => NULL, 'refs' => [ 'ListAssociationVersionsResult$AssociationVersions' => '<p>Information about all versions of the association for the specified association ID.</p>', ], ], 'AttachmentContent' => [ 'base' => '<p>A structure that includes attributes that describe a document attachment.</p>', 'refs' => [ 'AttachmentContentList$member' => NULL, ], ], 'AttachmentContentList' => [ 'base' => NULL, 'refs' => [ 'GetDocumentResult$AttachmentsContent' => '<p>A description of the document attachments, including names, locations, sizes, and so on.</p>', ], ], 'AttachmentHash' => [ 'base' => NULL, 'refs' => [ 'AttachmentContent$Hash' => '<p>The cryptographic hash value of the document content.</p>', ], ], 'AttachmentHashType' => [ 'base' => NULL, 'refs' => [ 'AttachmentContent$HashType' => '<p>The hash algorithm used to calculate the hash value.</p>', ], ], 'AttachmentIdentifier' => [ 'base' => NULL, 'refs' => [ 'AttachmentsSource$Name' => '<p>The name of the document attachment file.</p>', ], ], 'AttachmentInformation' => [ 'base' => '<p>An attribute of an attachment, such as the attachment name.</p>', 'refs' => [ 'AttachmentInformationList$member' => NULL, ], ], 'AttachmentInformationList' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$AttachmentsInformation' => '<p>Details about the document attachments, including names, locations, sizes, and so on.</p>', ], ], 'AttachmentName' => [ 'base' => NULL, 'refs' => [ 'AttachmentContent$Name' => '<p>The name of an attachment.</p>', 'AttachmentInformation$Name' => '<p>The name of the attachment.</p>', ], ], 'AttachmentUrl' => [ 'base' => NULL, 'refs' => [ 'AttachmentContent$Url' => '<p>The URL location of the attachment content.</p>', ], ], 'AttachmentsSource' => [ 'base' => '<p>Identifying information about a document attachment, including the file name and a key-value pair that identifies the location of an attachment to a document.</p>', 'refs' => [ 'AttachmentsSourceList$member' => NULL, ], ], 'AttachmentsSourceKey' => [ 'base' => NULL, 'refs' => [ 'AttachmentsSource$Key' => '<p>The key of a key-value pair that identifies the location of an attachment to a document.</p>', ], ], 'AttachmentsSourceList' => [ 'base' => NULL, 'refs' => [ 'CreateDocumentRequest$Attachments' => '<p>A list of key and value pairs that describe attachments to a version of a document.</p>', 'UpdateDocumentRequest$Attachments' => '<p>A list of key and value pairs that describe attachments to a version of a document.</p>', ], ], 'AttachmentsSourceValue' => [ 'base' => NULL, 'refs' => [ 'AttachmentsSourceValues$member' => NULL, ], ], 'AttachmentsSourceValues' => [ 'base' => NULL, 'refs' => [ 'AttachmentsSource$Values' => '<p>The value of a key-value pair that identifies the location of an attachment to a document. The format for <b>Value</b> depends on the type of key you specify.</p> <ul> <li> <p>For the key <i>SourceUrl</i>, the value is an S3 bucket location. For example:</p> <p> <code>"Values": [ "s3://my-bucket/my-folder" ]</code> </p> </li> <li> <p>For the key <i>S3FileUrl</i>, the value is a file in an S3 bucket. For example:</p> <p> <code>"Values": [ "s3://my-bucket/my-folder/my-file.py" ]</code> </p> </li> <li> <p>For the key <i>AttachmentReference</i>, the value is constructed from the name of another SSM document in your account, a version number of that document, and a file attached to that document version that you want to reuse. For example:</p> <p> <code>"Values": [ "MyOtherDocument/3/my-other-file.py" ]</code> </p> <p>However, if the SSM document is shared with you from another account, the full SSM document ARN must be specified instead of the document name only. For example:</p> <p> <code>"Values": [ "arn:aws:ssm:us-east-2:111122223333:document/OtherAccountDocument/3/their-file.py" ]</code> </p> </li> </ul>', ], ], 'AttributeName' => [ 'base' => NULL, 'refs' => [ 'ComplianceItemDetails$key' => NULL, 'InventoryItemContentContext$key' => NULL, 'InventoryItemEntry$key' => NULL, 'OpsEntityItemEntry$key' => NULL, 'PatchPropertyEntry$key' => NULL, ], ], 'AttributeValue' => [ 'base' => NULL, 'refs' => [ 'ComplianceItemDetails$value' => NULL, 'InventoryItemContentContext$value' => NULL, 'InventoryItemEntry$value' => NULL, 'OpsEntityItemEntry$value' => NULL, 'PatchPropertyEntry$value' => NULL, ], ], 'AutomationActionName' => [ 'base' => NULL, 'refs' => [ 'StepExecution$Action' => '<p>The action this step performs. The action determines the behavior of the step.</p>', ], ], 'AutomationDefinitionNotFoundException' => [ 'base' => '<p>An Automation document with the specified name could not be found.</p>', 'refs' => [], ], 'AutomationDefinitionVersionNotFoundException' => [ 'base' => '<p>An Automation document with the specified name and version could not be found.</p>', 'refs' => [], ], 'AutomationExecution' => [ 'base' => '<p>Detailed information about the current state of an individual Automation execution.</p>', 'refs' => [ 'GetAutomationExecutionResult$AutomationExecution' => '<p>Detailed information about the current state of an automation execution.</p>', ], ], 'AutomationExecutionFilter' => [ 'base' => '<p>A filter used to match specific automation executions. This is used to limit the scope of Automation execution information returned.</p>', 'refs' => [ 'AutomationExecutionFilterList$member' => NULL, ], ], 'AutomationExecutionFilterKey' => [ 'base' => NULL, 'refs' => [ 'AutomationExecutionFilter$Key' => '<p>One or more keys to limit the results. Valid filter keys include the following: DocumentNamePrefix, ExecutionStatus, ExecutionId, ParentExecutionId, CurrentAction, StartTimeBefore, StartTimeAfter.</p>', ], ], 'AutomationExecutionFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeAutomationExecutionsRequest$Filters' => '<p>Filters used to limit the scope of executions that are requested.</p>', ], ], 'AutomationExecutionFilterValue' => [ 'base' => NULL, 'refs' => [ 'AutomationExecutionFilterValueList$member' => NULL, ], ], 'AutomationExecutionFilterValueList' => [ 'base' => NULL, 'refs' => [ 'AutomationExecutionFilter$Values' => '<p>The values used to limit the execution information associated with the filter\'s key.</p>', ], ], 'AutomationExecutionId' => [ 'base' => NULL, 'refs' => [ 'AutomationExecution$AutomationExecutionId' => '<p>The execution ID.</p>', 'AutomationExecution$ParentAutomationExecutionId' => '<p>The AutomationExecutionId of the parent automation.</p>', 'AutomationExecutionMetadata$AutomationExecutionId' => '<p>The execution ID.</p>', 'AutomationExecutionMetadata$ParentAutomationExecutionId' => '<p>The ExecutionId of the parent Automation.</p>', 'DescribeAutomationStepExecutionsRequest$AutomationExecutionId' => '<p>The Automation execution ID for which you want step execution descriptions.</p>', 'GetAutomationExecutionRequest$AutomationExecutionId' => '<p>The unique identifier for an existing automation execution to examine. The execution ID is returned by StartAutomationExecution when the execution of an Automation document is initiated.</p>', 'SendAutomationSignalRequest$AutomationExecutionId' => '<p>The unique identifier for an existing Automation execution that you want to send the signal to.</p>', 'StartAutomationExecutionResult$AutomationExecutionId' => '<p>The unique ID of a newly scheduled automation execution.</p>', 'StopAutomationExecutionRequest$AutomationExecutionId' => '<p>The execution ID of the Automation to stop.</p>', ], ], 'AutomationExecutionLimitExceededException' => [ 'base' => '<p>The number of simultaneously running Automation executions exceeded the allowable limit.</p>', 'refs' => [], ], 'AutomationExecutionMetadata' => [ 'base' => '<p>Details about a specific Automation execution.</p>', 'refs' => [ 'AutomationExecutionMetadataList$member' => NULL, ], ], 'AutomationExecutionMetadataList' => [ 'base' => NULL, 'refs' => [ 'DescribeAutomationExecutionsResult$AutomationExecutionMetadataList' => '<p>The list of details about each automation execution which has occurred which matches the filter specification, if any.</p>', ], ], 'AutomationExecutionNotFoundException' => [ 'base' => '<p>There is no automation execution information for the requested automation execution ID.</p>', 'refs' => [], ], 'AutomationExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'AutomationExecution$AutomationExecutionStatus' => '<p>The execution status of the Automation.</p>', 'AutomationExecutionMetadata$AutomationExecutionStatus' => '<p>The status of the execution.</p>', 'StepExecution$StepStatus' => '<p>The execution status for this step.</p>', ], ], 'AutomationParameterKey' => [ 'base' => NULL, 'refs' => [ 'AutomationExecution$TargetParameterName' => '<p>The parameter name.</p>', 'AutomationExecutionMetadata$TargetParameterName' => '<p>The list of execution outputs as defined in the Automation document.</p>', 'AutomationParameterMap$key' => NULL, 'StartAutomationExecutionRequest$TargetParameterName' => '<p>The name of the parameter used as the target resource for the rate-controlled execution. Required if you specify targets.</p>', ], ], 'AutomationParameterMap' => [ 'base' => NULL, 'refs' => [ 'AutomationExecution$Parameters' => '<p>The key-value map of execution parameters, which were supplied when calling StartAutomationExecution.</p>', 'AutomationExecution$Outputs' => '<p>The list of execution outputs as defined in the automation document.</p>', 'AutomationExecutionMetadata$Outputs' => '<p>The list of execution outputs as defined in the Automation document.</p>', 'FailureDetails$Details' => '<p>Detailed information about the Automation step failure.</p>', 'MaintenanceWindowAutomationParameters$Parameters' => '<p>The parameters for the AUTOMATION task.</p> <p>For information about specifying and updating task parameters, see <a>RegisterTaskWithMaintenanceWindow</a> and <a>UpdateMaintenanceWindowTask</a>.</p> <note> <p> <code>LoggingInfo</code> has been deprecated. To specify an S3 bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> <p>For AUTOMATION task types, Systems Manager ignores any values specified for these parameters.</p> </note>', 'SendAutomationSignalRequest$Payload' => '<p>The data sent with the signal. The data schema depends on the type of signal used in the request.</p> <p>For <code>Approve</code> and <code>Reject</code> signal types, the payload is an optional comment that you can send with the signal type. For example:</p> <p> <code>Comment="Looks good"</code> </p> <p>For <code>StartStep</code> and <code>Resume</code> signal types, you must send the name of the Automation step to start or resume as the payload. For example:</p> <p> <code>StepName="step1"</code> </p> <p>For the <code>StopStep</code> signal type, you must send the step execution ID as the payload. For example:</p> <p> <code>StepExecutionId="97fff367-fc5a-4299-aed8-0123456789ab"</code> </p>', 'StartAutomationExecutionRequest$Parameters' => '<p>A key-value map of execution parameters, which match the declared parameters in the Automation document.</p>', 'StepExecution$Outputs' => '<p>Returned values from the execution of the step.</p>', 'StepExecution$OverriddenParameters' => '<p>A user-specified list of parameters to override when running a step.</p>', ], ], 'AutomationParameterValue' => [ 'base' => NULL, 'refs' => [ 'AutomationParameterValueList$member' => NULL, ], ], 'AutomationParameterValueList' => [ 'base' => NULL, 'refs' => [ 'AutomationParameterMap$value' => NULL, ], ], 'AutomationStepNotFoundException' => [ 'base' => '<p>The specified step name and execution ID don\'t exist. Verify the information and try again.</p>', 'refs' => [], ], 'AutomationTargetParameterName' => [ 'base' => NULL, 'refs' => [ 'AssociationDescription$AutomationTargetParameterName' => '<p>Specify the target for the association. This target is required for associations that use an Automation document and target resources by using rate controls.</p>', 'CreateAssociationBatchRequestEntry$AutomationTargetParameterName' => '<p>Specify the target for the association. This target is required for associations that use an Automation document and target resources by using rate controls.</p>', 'CreateAssociationRequest$AutomationTargetParameterName' => '<p>Specify the target for the association. This target is required for associations that use an Automation document and target resources by using rate controls.</p>', 'UpdateAssociationRequest$AutomationTargetParameterName' => '<p>Specify the target for the association. This target is required for associations that use an Automation document and target resources by using rate controls.</p>', ], ], 'AutomationType' => [ 'base' => NULL, 'refs' => [ 'AutomationExecutionMetadata$AutomationType' => '<p>Use this filter with <a>DescribeAutomationExecutions</a>. Specify either Local or CrossAccount. CrossAccount is an Automation that runs in multiple AWS Regions and accounts. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html">Running Automation workflows in multiple AWS Regions and accounts</a> in the <i>AWS Systems Manager User Guide</i>. </p>', ], ], 'BaselineDescription' => [ 'base' => NULL, 'refs' => [ 'CreatePatchBaselineRequest$Description' => '<p>A description of the patch baseline.</p>', 'GetPatchBaselineResult$Description' => '<p>A description of the patch baseline.</p>', 'PatchBaselineIdentity$BaselineDescription' => '<p>The description of the patch baseline.</p>', 'UpdatePatchBaselineRequest$Description' => '<p>A description of the patch baseline.</p>', 'UpdatePatchBaselineResult$Description' => '<p>A description of the Patch Baseline.</p>', ], ], 'BaselineId' => [ 'base' => NULL, 'refs' => [ 'CreatePatchBaselineResult$BaselineId' => '<p>The ID of the created patch baseline.</p>', 'DeletePatchBaselineRequest$BaselineId' => '<p>The ID of the patch baseline to delete.</p>', 'DeletePatchBaselineResult$BaselineId' => '<p>The ID of the deleted patch baseline.</p>', 'DeregisterPatchBaselineForPatchGroupRequest$BaselineId' => '<p>The ID of the patch baseline to deregister the patch group from.</p>', 'DeregisterPatchBaselineForPatchGroupResult$BaselineId' => '<p>The ID of the patch baseline the patch group was deregistered from.</p>', 'DescribeEffectivePatchesForPatchBaselineRequest$BaselineId' => '<p>The ID of the patch baseline to retrieve the effective patches for.</p>', 'GetDefaultPatchBaselineResult$BaselineId' => '<p>The ID of the default patch baseline.</p>', 'GetPatchBaselineForPatchGroupResult$BaselineId' => '<p>The ID of the patch baseline that should be used for the patch group.</p>', 'GetPatchBaselineRequest$BaselineId' => '<p>The ID of the patch baseline to retrieve.</p>', 'GetPatchBaselineResult$BaselineId' => '<p>The ID of the retrieved patch baseline.</p>', 'InstancePatchState$BaselineId' => '<p>The ID of the patch baseline used to patch the instance.</p>', 'PatchBaselineIdentity$BaselineId' => '<p>The ID of the patch baseline.</p>', 'RegisterDefaultPatchBaselineRequest$BaselineId' => '<p>The ID of the patch baseline that should be the default patch baseline.</p>', 'RegisterDefaultPatchBaselineResult$BaselineId' => '<p>The ID of the default patch baseline.</p>', 'RegisterPatchBaselineForPatchGroupRequest$BaselineId' => '<p>The ID of the patch baseline to register the patch group with.</p>', 'RegisterPatchBaselineForPatchGroupResult$BaselineId' => '<p>The ID of the patch baseline the patch group was registered with.</p>', 'UpdatePatchBaselineRequest$BaselineId' => '<p>The ID of the patch baseline to update.</p>', 'UpdatePatchBaselineResult$BaselineId' => '<p>The ID of the deleted patch baseline.</p>', ], ], 'BaselineName' => [ 'base' => NULL, 'refs' => [ 'CreatePatchBaselineRequest$Name' => '<p>The name of the patch baseline.</p>', 'GetPatchBaselineResult$Name' => '<p>The name of the patch baseline.</p>', 'PatchBaselineIdentity$BaselineName' => '<p>The name of the patch baseline.</p>', 'UpdatePatchBaselineRequest$Name' => '<p>The name of the patch baseline.</p>', 'UpdatePatchBaselineResult$Name' => '<p>The name of the patch baseline.</p>', ], ], 'BatchErrorMessage' => [ 'base' => NULL, 'refs' => [ 'FailedCreateAssociation$Message' => '<p>A description of the failure.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'Activation$Expired' => '<p>Whether or not the activation is expired.</p>', 'AutomationExecution$StepExecutionsTruncated' => '<p>A boolean value that indicates if the response contains the full list of the Automation step executions. If true, use the DescribeAutomationStepExecutions API action to get the full list of step executions.</p>', 'CreatePatchBaselineRequest$ApprovedPatchesEnableNonSecurity' => '<p>Indicates whether the list of approved patches includes non-security updates that should be applied to the instances. The default value is \'false\'. Applies to Linux instances only.</p>', 'DeleteDocumentRequest$Force' => '<p>Some SSM document types require that you specify a <code>Force</code> flag before you can delete the document. For example, you must specify a <code>Force</code> flag to delete a document of type <code>ApplicationConfigurationSchema</code>. You can restrict access to the <code>Force</code> flag in an AWS Identity and Access Management (IAM) policy.</p>', 'DeregisterTargetFromMaintenanceWindowRequest$Safe' => '<p>The system checks if the target is being referenced by a task. If the target is being referenced, the system returns an error and does not deregister the target from the maintenance window.</p>', 'DescribeAutomationStepExecutionsRequest$ReverseOrder' => '<p>A boolean that indicates whether to list step executions in reverse order by start time. The default value is false.</p>', 'DocumentVersionInfo$IsDefaultVersion' => '<p>An identifier for the default version of the document.</p>', 'GetParameterHistoryRequest$WithDecryption' => '<p>Return decrypted values for secure string parameters. This flag is ignored for String and StringList parameter types.</p>', 'GetParameterRequest$WithDecryption' => '<p>Return decrypted values for secure string parameters. This flag is ignored for String and StringList parameter types.</p>', 'GetParametersByPathRequest$Recursive' => '<p>Retrieve all parameters within a hierarchy.</p> <important> <p>If a user has access to a path, then the user can access all levels of that path. For example, if a user has permission to access path <code>/a</code>, then the user can also access <code>/a/b</code>. Even if a user has explicitly been denied access in IAM for parameter <code>/a/b</code>, they can still call the GetParametersByPath API action recursively for <code>/a</code> and view <code>/a/b</code>.</p> </important>', 'GetParametersByPathRequest$WithDecryption' => '<p>Retrieve all parameters in a hierarchy with their value decrypted.</p>', 'GetParametersRequest$WithDecryption' => '<p>Return decrypted secure string value. Return decrypted values for secure string parameters. This flag is ignored for String and StringList parameter types.</p>', 'GetPatchBaselineResult$ApprovedPatchesEnableNonSecurity' => '<p>Indicates whether the list of approved patches includes non-security updates that should be applied to the instances. The default value is \'false\'. Applies to Linux instances only.</p>', 'InstanceInformation$IsLatestVersion' => '<p>Indicates whether the latest version of SSM Agent is running on your Linux Managed Instance. This field does not indicate whether or not the latest version is installed on Windows managed instances, because some older versions of Windows Server use the EC2Config service to process SSM requests.</p>', 'ListCommandInvocationsRequest$Details' => '<p>(Optional) If set this returns the response of the command executions and any command output. By default this is set to False. </p>', 'PatchRule$EnableNonSecurity' => '<p>For instances identified by the approval rule filters, enables a patch baseline to apply non-security updates available in the specified repository. The default value is \'false\'. Applies to Linux instances only.</p>', 'PutParameterRequest$Overwrite' => '<p>Overwrite an existing parameter. If not specified, will default to "false".</p>', 'ResolvedTargets$Truncated' => '<p>A boolean value indicating whether the resolved target list is truncated.</p>', 'StepExecution$IsEnd' => '<p>The flag which can be used to end automation no matter whether the step succeeds or fails.</p>', 'StepExecution$IsCritical' => '<p>The flag which can be used to help decide whether the failure of current step leads to the Automation failure.</p>', 'UpdateMaintenanceWindowRequest$Replace' => '<p>If True, then all fields that are required by the CreateMaintenanceWindow action are also required for this API request. Optional fields that are not specified are set to null. </p>', 'UpdateMaintenanceWindowTargetRequest$Replace' => '<p>If True, then all fields that are required by the RegisterTargetWithMaintenanceWindow action are also required for this API request. Optional fields that are not specified are set to null.</p>', 'UpdateMaintenanceWindowTaskRequest$Replace' => '<p>If True, then all fields that are required by the RegisterTaskWithMaintenanceWndow action are also required for this API request. Optional fields that are not specified are set to null.</p>', 'UpdatePatchBaselineRequest$ApprovedPatchesEnableNonSecurity' => '<p>Indicates whether the list of approved patches includes non-security updates that should be applied to the instances. The default value is \'false\'. Applies to Linux instances only.</p>', 'UpdatePatchBaselineRequest$Replace' => '<p>If True, then all fields that are required by the CreatePatchBaseline action are also required for this API request. Optional fields that are not specified are set to null.</p>', 'UpdatePatchBaselineResult$ApprovedPatchesEnableNonSecurity' => '<p>Indicates whether the list of approved patches includes non-security updates that should be applied to the instances. The default value is \'false\'. Applies to Linux instances only.</p>', ], ], 'CalendarNameOrARN' => [ 'base' => NULL, 'refs' => [ 'CalendarNameOrARNList$member' => NULL, ], ], 'CalendarNameOrARNList' => [ 'base' => NULL, 'refs' => [ 'GetCalendarStateRequest$CalendarNames' => '<p>The names or Amazon Resource Names (ARNs) of the Systems Manager documents that represent the calendar entries for which you want to get the state.</p>', ], ], 'CalendarState' => [ 'base' => NULL, 'refs' => [ 'GetCalendarStateResponse$State' => '<p>The state of the calendar. An <code>OPEN</code> calendar indicates that actions are allowed to proceed, and a <code>CLOSED</code> calendar indicates that actions are not allowed to proceed.</p>', ], ], 'CancelCommandRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'CancelCommandResult' => [ 'base' => '<p>Whether or not the command was successfully canceled. There is no guarantee that a request can be canceled.</p>', 'refs' => [], ], 'CancelMaintenanceWindowExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelMaintenanceWindowExecutionResult' => [ 'base' => NULL, 'refs' => [], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowRequest$ClientToken' => '<p>User-provided idempotency token.</p>', 'CreatePatchBaselineRequest$ClientToken' => '<p>User-provided idempotency token.</p>', 'DeleteInventoryRequest$ClientToken' => '<p>User-provided idempotency token.</p>', 'RegisterTargetWithMaintenanceWindowRequest$ClientToken' => '<p>User-provided idempotency token.</p>', 'RegisterTaskWithMaintenanceWindowRequest$ClientToken' => '<p>User-provided idempotency token.</p>', ], ], 'CloudWatchLogGroupName' => [ 'base' => NULL, 'refs' => [ 'CloudWatchOutputConfig$CloudWatchLogGroupName' => '<p>The name of the CloudWatch log group where you want to send command output. If you don\'t specify a group name, Systems Manager automatically creates a log group for you. The log group uses the following naming format: aws/ssm/<i>SystemsManagerDocumentName</i>.</p>', ], ], 'CloudWatchOutputConfig' => [ 'base' => '<p>Configuration options for sending command output to CloudWatch Logs.</p>', 'refs' => [ 'Command$CloudWatchOutputConfig' => '<p>CloudWatch Logs information where you want Systems Manager to send the command output.</p>', 'CommandInvocation$CloudWatchOutputConfig' => '<p>CloudWatch Logs information where you want Systems Manager to send the command output.</p>', 'GetCommandInvocationResult$CloudWatchOutputConfig' => '<p>CloudWatch Logs information where Systems Manager sent the command output.</p>', 'MaintenanceWindowRunCommandParameters$CloudWatchOutputConfig' => NULL, 'SendCommandRequest$CloudWatchOutputConfig' => '<p>Enables Systems Manager to send Run Command output to Amazon CloudWatch Logs. </p>', ], ], 'CloudWatchOutputEnabled' => [ 'base' => NULL, 'refs' => [ 'CloudWatchOutputConfig$CloudWatchOutputEnabled' => '<p>Enables Systems Manager to send command output to CloudWatch Logs.</p>', ], ], 'Command' => [ 'base' => '<p>Describes a command request.</p>', 'refs' => [ 'CommandList$member' => NULL, 'SendCommandResult$Command' => '<p>The request as it was received by Systems Manager. Also provides the command ID which can be used future references to this request.</p>', ], ], 'CommandFilter' => [ 'base' => '<p>Describes a command filter.</p> <note> <p>An instance ID can\'t be specified when a command status is <code>Pending</code> because the command hasn\'t run on the instance yet.</p> </note>', 'refs' => [ 'CommandFilterList$member' => NULL, ], ], 'CommandFilterKey' => [ 'base' => NULL, 'refs' => [ 'CommandFilter$key' => '<p>The name of the filter.</p>', ], ], 'CommandFilterList' => [ 'base' => NULL, 'refs' => [ 'ListCommandInvocationsRequest$Filters' => '<p>(Optional) One or more filters. Use a filter to return a more specific list of results.</p>', 'ListCommandsRequest$Filters' => '<p>(Optional) One or more filters. Use a filter to return a more specific list of results. </p>', ], ], 'CommandFilterValue' => [ 'base' => NULL, 'refs' => [ 'CommandFilter$value' => '<p>The filter value. Valid values for each filter key are as follows:</p> <ul> <li> <p> <b>InvokedAfter</b>: Specify a timestamp to limit your results. For example, specify <code>2018-07-07T00:00:00Z</code> to see a list of command executions occurring July 7, 2018, and later.</p> </li> <li> <p> <b>InvokedBefore</b>: Specify a timestamp to limit your results. For example, specify <code>2018-07-07T00:00:00Z</code> to see a list of command executions from before July 7, 2018.</p> </li> <li> <p> <b>Status</b>: Specify a valid command status to see a list of all command executions with that status. Status values you can specify include:</p> <ul> <li> <p> <code>Pending</code> </p> </li> <li> <p> <code>InProgress</code> </p> </li> <li> <p> <code>Success</code> </p> </li> <li> <p> <code>Cancelled</code> </p> </li> <li> <p> <code>Failed</code> </p> </li> <li> <p> <code>TimedOut</code> </p> </li> <li> <p> <code>Cancelling</code> </p> </li> </ul> </li> <li> <p> <b>DocumentName</b>: Specify name of the SSM document for which you want to see command execution results. For example, specify <code>AWS-RunPatchBaseline</code> to see command executions that used this SSM document to perform security patching operations on instances. </p> </li> <li> <p> <b>ExecutionStage</b>: Specify one of the following values:</p> <ul> <li> <p> <code>Executing</code>: Returns a list of command executions that are currently still running.</p> </li> <li> <p> <code>Complete</code>: Returns a list of command executions that have already completed. </p> </li> </ul> </li> </ul>', ], ], 'CommandId' => [ 'base' => NULL, 'refs' => [ 'CancelCommandRequest$CommandId' => '<p>The ID of the command you want to cancel.</p>', 'Command$CommandId' => '<p>A unique identifier for this command.</p>', 'CommandInvocation$CommandId' => '<p>The command against which this invocation was requested.</p>', 'GetCommandInvocationRequest$CommandId' => '<p>(Required) The parent command ID of the invocation plugin.</p>', 'GetCommandInvocationResult$CommandId' => '<p>The parent command ID of the invocation plugin.</p>', 'ListCommandInvocationsRequest$CommandId' => '<p>(Optional) The invocations for a specific command ID.</p>', 'ListCommandsRequest$CommandId' => '<p>(Optional) If provided, lists only the specified command.</p>', ], ], 'CommandInvocation' => [ 'base' => '<p>An invocation is copy of a command sent to a specific instance. A command can apply to one or more instances. A command invocation applies to one instance. For example, if a user runs SendCommand against three instances, then a command invocation is created for each requested instance ID. A command invocation returns status and detail information about a command you ran. </p>', 'refs' => [ 'CommandInvocationList$member' => NULL, ], ], 'CommandInvocationList' => [ 'base' => NULL, 'refs' => [ 'ListCommandInvocationsResult$CommandInvocations' => '<p>(Optional) A list of all invocations. </p>', ], ], 'CommandInvocationStatus' => [ 'base' => NULL, 'refs' => [ 'CommandInvocation$Status' => '<p>Whether or not the invocation succeeded, failed, or is pending.</p>', 'GetCommandInvocationResult$Status' => '<p>The status of this invocation plugin. This status can be different than StatusDetails.</p>', ], ], 'CommandList' => [ 'base' => NULL, 'refs' => [ 'ListCommandsResult$Commands' => '<p>(Optional) The list of commands requested by the user. </p>', ], ], 'CommandMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListCommandInvocationsRequest$MaxResults' => '<p>(Optional) The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListCommandsRequest$MaxResults' => '<p>(Optional) The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'CommandPlugin' => [ 'base' => '<p>Describes plugin details.</p>', 'refs' => [ 'CommandPluginList$member' => NULL, ], ], 'CommandPluginList' => [ 'base' => NULL, 'refs' => [ 'CommandInvocation$CommandPlugins' => NULL, ], ], 'CommandPluginName' => [ 'base' => NULL, 'refs' => [ 'CommandPlugin$Name' => '<p>The name of the plugin. Must be one of the following: aws:updateAgent, aws:domainjoin, aws:applications, aws:runPowerShellScript, aws:psmodule, aws:cloudWatch, aws:runShellScript, or aws:updateSSMAgent. </p>', 'GetCommandInvocationRequest$PluginName' => '<p>(Optional) The name of the plugin for which you want detailed results. If the document contains only one plugin, the name can be omitted and the details will be returned.</p> <p>Plugin names are also referred to as step names in Systems Manager documents.</p>', 'GetCommandInvocationResult$PluginName' => '<p>The name of the plugin for which you want detailed results. For example, aws:RunShellScript is a plugin.</p>', ], ], 'CommandPluginOutput' => [ 'base' => NULL, 'refs' => [ 'CommandPlugin$Output' => '<p>Output of the plugin execution.</p>', ], ], 'CommandPluginStatus' => [ 'base' => NULL, 'refs' => [ 'CommandPlugin$Status' => '<p>The status of this plugin. You can run a document with multiple plugins.</p>', ], ], 'CommandStatus' => [ 'base' => NULL, 'refs' => [ 'Command$Status' => '<p>The status of the command.</p>', ], ], 'Comment' => [ 'base' => NULL, 'refs' => [ 'Command$Comment' => '<p>User-specified information about the command, such as a brief description of what the command should do.</p>', 'CommandInvocation$Comment' => '<p>User-specified information about the command, such as a brief description of what the command should do.</p>', 'GetCommandInvocationResult$Comment' => '<p>The comment text for the command.</p>', 'MaintenanceWindowRunCommandParameters$Comment' => '<p>Information about the commands to run.</p>', 'SendCommandRequest$Comment' => '<p>User-specified information about the command, such as a brief description of what the command should do.</p>', ], ], 'CompletedCount' => [ 'base' => NULL, 'refs' => [ 'Command$CompletedCount' => '<p>The number of targets for which the command invocation reached a terminal state. Terminal states include the following: Success, Failed, Execution Timed Out, Delivery Timed Out, Canceled, Terminated, or Undeliverable.</p>', ], ], 'ComplianceExecutionId' => [ 'base' => NULL, 'refs' => [ 'ComplianceExecutionSummary$ExecutionId' => '<p>An ID created by the system when <code>PutComplianceItems</code> was called. For example, <code>CommandID</code> is a valid execution ID. You can use this ID in subsequent calls.</p>', ], ], 'ComplianceExecutionSummary' => [ 'base' => '<p>A summary of the call execution that includes an execution ID, the type of execution (for example, <code>Command</code>), and the date/time of the execution using a datetime object that is saved in the following format: yyyy-MM-dd\'T\'HH:mm:ss\'Z\'.</p>', 'refs' => [ 'ComplianceItem$ExecutionSummary' => '<p>A summary for the compliance item. The summary includes an execution ID, the execution type (for example, command), and the execution time.</p>', 'PutComplianceItemsRequest$ExecutionSummary' => '<p>A summary of the call execution that includes an execution ID, the type of execution (for example, <code>Command</code>), and the date/time of the execution using a datetime object that is saved in the following format: yyyy-MM-dd\'T\'HH:mm:ss\'Z\'.</p>', 'ResourceComplianceSummaryItem$ExecutionSummary' => '<p>Information about the execution.</p>', ], ], 'ComplianceExecutionType' => [ 'base' => NULL, 'refs' => [ 'ComplianceExecutionSummary$ExecutionType' => '<p>The type of execution. For example, <code>Command</code> is a valid execution type.</p>', ], ], 'ComplianceFilterValue' => [ 'base' => NULL, 'refs' => [ 'ComplianceStringFilterValueList$member' => NULL, ], ], 'ComplianceItem' => [ 'base' => '<p>Information about the compliance as defined by the resource type. For example, for a patch resource type, <code>Items</code> includes information about the PatchSeverity, Classification, and so on.</p>', 'refs' => [ 'ComplianceItemList$member' => NULL, ], ], 'ComplianceItemContentHash' => [ 'base' => NULL, 'refs' => [ 'PutComplianceItemsRequest$ItemContentHash' => '<p>MD5 or SHA-256 content hash. The content hash is used to determine if existing information should be overwritten or ignored. If the content hashes match, the request to put compliance information is ignored.</p>', ], ], 'ComplianceItemDetails' => [ 'base' => NULL, 'refs' => [ 'ComplianceItem$Details' => '<p>A "Key": "Value" tag combination for the compliance item.</p>', 'ComplianceItemEntry$Details' => '<p>A "Key": "Value" tag combination for the compliance item.</p>', ], ], 'ComplianceItemEntry' => [ 'base' => '<p>Information about a compliance item.</p>', 'refs' => [ 'ComplianceItemEntryList$member' => NULL, ], ], 'ComplianceItemEntryList' => [ 'base' => NULL, 'refs' => [ 'PutComplianceItemsRequest$Items' => '<p>Information about the compliance as defined by the resource type. For example, for a patch compliance type, <code>Items</code> includes information about the PatchSeverity, Classification, and so on.</p>', ], ], 'ComplianceItemId' => [ 'base' => NULL, 'refs' => [ 'ComplianceItem$Id' => '<p>An ID for the compliance item. For example, if the compliance item is a Windows patch, the ID could be the number of the KB article; for example: KB4010320.</p>', 'ComplianceItemEntry$Id' => '<p>The compliance item ID. For example, if the compliance item is a Windows patch, the ID could be the number of the KB article.</p>', ], ], 'ComplianceItemList' => [ 'base' => NULL, 'refs' => [ 'ListComplianceItemsResult$ComplianceItems' => '<p>A list of compliance information for the specified resource ID. </p>', ], ], 'ComplianceItemTitle' => [ 'base' => NULL, 'refs' => [ 'ComplianceItem$Title' => '<p>A title for the compliance item. For example, if the compliance item is a Windows patch, the title could be the title of the KB article for the patch; for example: Security Update for Active Directory Federation Services.</p>', 'ComplianceItemEntry$Title' => '<p>The title of the compliance item. For example, if the compliance item is a Windows patch, the title could be the title of the KB article for the patch; for example: Security Update for Active Directory Federation Services. </p>', ], ], 'ComplianceQueryOperatorType' => [ 'base' => NULL, 'refs' => [ 'ComplianceStringFilter$Type' => '<p>The type of comparison that should be performed for the value: Equal, NotEqual, BeginWith, LessThan, or GreaterThan.</p>', ], ], 'ComplianceResourceId' => [ 'base' => NULL, 'refs' => [ 'ComplianceItem$ResourceId' => '<p>An ID for the resource. For a managed instance, this is the instance ID.</p>', 'ComplianceResourceIdList$member' => NULL, 'PutComplianceItemsRequest$ResourceId' => '<p>Specify an ID for this resource. For a managed instance, this is the instance ID.</p>', 'ResourceComplianceSummaryItem$ResourceId' => '<p>The resource ID.</p>', ], ], 'ComplianceResourceIdList' => [ 'base' => NULL, 'refs' => [ 'ListComplianceItemsRequest$ResourceIds' => '<p>The ID for the resources from which to get compliance information. Currently, you can only specify one resource ID.</p>', ], ], 'ComplianceResourceType' => [ 'base' => NULL, 'refs' => [ 'ComplianceItem$ResourceType' => '<p>The type of resource. <code>ManagedInstance</code> is currently the only supported resource type.</p>', 'ComplianceResourceTypeList$member' => NULL, 'PutComplianceItemsRequest$ResourceType' => '<p>Specify the type of resource. <code>ManagedInstance</code> is currently the only supported resource type.</p>', 'ResourceComplianceSummaryItem$ResourceType' => '<p>The resource type.</p>', ], ], 'ComplianceResourceTypeList' => [ 'base' => NULL, 'refs' => [ 'ListComplianceItemsRequest$ResourceTypes' => '<p>The type of resource from which to get compliance information. Currently, the only supported resource type is <code>ManagedInstance</code>.</p>', ], ], 'ComplianceSeverity' => [ 'base' => NULL, 'refs' => [ 'ComplianceItem$Severity' => '<p>The severity of the compliance status. Severity can be one of the following: Critical, High, Medium, Low, Informational, Unspecified.</p>', 'ComplianceItemEntry$Severity' => '<p>The severity of the compliance status. Severity can be one of the following: Critical, High, Medium, Low, Informational, Unspecified.</p>', 'ResourceComplianceSummaryItem$OverallSeverity' => '<p>The highest severity item found for the resource. The resource is compliant for this item.</p>', ], ], 'ComplianceStatus' => [ 'base' => NULL, 'refs' => [ 'ComplianceItem$Status' => '<p>The status of the compliance item. An item is either COMPLIANT or NON_COMPLIANT.</p>', 'ComplianceItemEntry$Status' => '<p>The status of the compliance item. An item is either COMPLIANT or NON_COMPLIANT.</p>', 'ResourceComplianceSummaryItem$Status' => '<p>The compliance status for the resource.</p>', ], ], 'ComplianceStringFilter' => [ 'base' => '<p>One or more filters. Use a filter to return a more specific list of results.</p>', 'refs' => [ 'ComplianceStringFilterList$member' => NULL, ], ], 'ComplianceStringFilterKey' => [ 'base' => NULL, 'refs' => [ 'ComplianceStringFilter$Key' => '<p>The name of the filter.</p>', ], ], 'ComplianceStringFilterList' => [ 'base' => NULL, 'refs' => [ 'ListComplianceItemsRequest$Filters' => '<p>One or more compliance filters. Use a filter to return a more specific list of results.</p>', 'ListComplianceSummariesRequest$Filters' => '<p>One or more compliance or inventory filters. Use a filter to return a more specific list of results.</p>', 'ListResourceComplianceSummariesRequest$Filters' => '<p>One or more filters. Use a filter to return a more specific list of results.</p>', ], ], 'ComplianceStringFilterValueList' => [ 'base' => NULL, 'refs' => [ 'ComplianceStringFilter$Values' => '<p>The value for which to search.</p>', ], ], 'ComplianceSummaryCount' => [ 'base' => NULL, 'refs' => [ 'CompliantSummary$CompliantCount' => '<p>The total number of resources that are compliant.</p>', 'NonCompliantSummary$NonCompliantCount' => '<p>The total number of compliance items that are not compliant.</p>', 'SeveritySummary$CriticalCount' => '<p>The total number of resources or compliance items that have a severity level of critical. Critical severity is determined by the organization that published the compliance items.</p>', 'SeveritySummary$HighCount' => '<p>The total number of resources or compliance items that have a severity level of high. High severity is determined by the organization that published the compliance items.</p>', 'SeveritySummary$MediumCount' => '<p>The total number of resources or compliance items that have a severity level of medium. Medium severity is determined by the organization that published the compliance items.</p>', 'SeveritySummary$LowCount' => '<p>The total number of resources or compliance items that have a severity level of low. Low severity is determined by the organization that published the compliance items.</p>', 'SeveritySummary$InformationalCount' => '<p>The total number of resources or compliance items that have a severity level of informational. Informational severity is determined by the organization that published the compliance items.</p>', 'SeveritySummary$UnspecifiedCount' => '<p>The total number of resources or compliance items that have a severity level of unspecified. Unspecified severity is determined by the organization that published the compliance items.</p>', ], ], 'ComplianceSummaryItem' => [ 'base' => '<p>A summary of compliance information by compliance type.</p>', 'refs' => [ 'ComplianceSummaryItemList$member' => NULL, ], ], 'ComplianceSummaryItemList' => [ 'base' => NULL, 'refs' => [ 'ListComplianceSummariesResult$ComplianceSummaryItems' => '<p>A list of compliant and non-compliant summary counts based on compliance types. For example, this call returns State Manager associations, patches, or custom compliance types according to the filter criteria that you specified.</p>', ], ], 'ComplianceTypeCountLimitExceededException' => [ 'base' => '<p>You specified too many custom compliance types. You can specify a maximum of 10 different types. </p>', 'refs' => [], ], 'ComplianceTypeName' => [ 'base' => NULL, 'refs' => [ 'ComplianceItem$ComplianceType' => '<p>The compliance type. For example, Association (for a State Manager association), Patch, or Custom:<code>string</code> are all valid compliance types.</p>', 'ComplianceSummaryItem$ComplianceType' => '<p>The type of compliance item. For example, the compliance type can be Association, Patch, or Custom:string.</p>', 'PutComplianceItemsRequest$ComplianceType' => '<p>Specify the compliance type. For example, specify Association (for a State Manager association), Patch, or Custom:<code>string</code>.</p>', 'ResourceComplianceSummaryItem$ComplianceType' => '<p>The compliance type.</p>', ], ], 'ComplianceUploadType' => [ 'base' => NULL, 'refs' => [ 'PutComplianceItemsRequest$UploadType' => '<p>The mode for uploading compliance items. You can specify <code>COMPLETE</code> or <code>PARTIAL</code>. In <code>COMPLETE</code> mode, the system overwrites all existing compliance information for the resource. You must provide a full list of compliance items each time you send the request.</p> <p>In <code>PARTIAL</code> mode, the system overwrites compliance information for a specific association. The association must be configured with <code>SyncCompliance</code> set to <code>MANUAL</code>. By default, all requests use <code>COMPLETE</code> mode.</p> <note> <p>This attribute is only valid for association compliance.</p> </note>', ], ], 'CompliantSummary' => [ 'base' => '<p>A summary of resources that are compliant. The summary is organized according to the resource count for each compliance type.</p>', 'refs' => [ 'ComplianceSummaryItem$CompliantSummary' => '<p>A list of COMPLIANT items for the specified compliance type.</p>', 'ResourceComplianceSummaryItem$CompliantSummary' => '<p>A list of items that are compliant for the resource.</p>', ], ], 'ComputerName' => [ 'base' => NULL, 'refs' => [ 'InstanceInformation$ComputerName' => '<p>The fully qualified host name of the managed instance.</p>', ], ], 'ConnectionStatus' => [ 'base' => NULL, 'refs' => [ 'GetConnectionStatusResponse$Status' => '<p>The status of the connection to the instance. For example, \'Connected\' or \'Not Connected\'.</p>', ], ], 'ContentLength' => [ 'base' => NULL, 'refs' => [ 'AttachmentContent$Size' => '<p>The size of an attachment in bytes.</p>', ], ], 'CreateActivationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateActivationResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateAssociationBatchRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAssociationBatchRequestEntries' => [ 'base' => NULL, 'refs' => [ 'CreateAssociationBatchRequest$Entries' => '<p>One or more associations.</p>', ], ], 'CreateAssociationBatchRequestEntry' => [ 'base' => '<p>Describes the association of a Systems Manager SSM document and an instance.</p>', 'refs' => [ 'CreateAssociationBatchRequestEntries$member' => NULL, 'FailedCreateAssociation$Entry' => '<p>The association.</p>', ], ], 'CreateAssociationBatchResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAssociationResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDocumentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDocumentResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateMaintenanceWindowRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMaintenanceWindowResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateOpsItemRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateOpsItemResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePatchBaselineRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePatchBaselineResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateResourceDataSyncRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateResourceDataSyncResult' => [ 'base' => NULL, 'refs' => [], ], 'CreatedDate' => [ 'base' => NULL, 'refs' => [ 'Activation$CreatedDate' => '<p>The date the activation was created.</p>', ], ], 'CustomSchemaCountLimitExceededException' => [ 'base' => '<p>You have exceeded the limit for custom schemas. Delete one or more custom schemas and try again.</p>', 'refs' => [], ], 'DateTime' => [ 'base' => NULL, 'refs' => [ 'Association$LastExecutionDate' => '<p>The date on which the association was last run.</p>', 'AssociationDescription$Date' => '<p>The date when the association was made.</p>', 'AssociationDescription$LastUpdateAssociationDate' => '<p>The date when the association was last updated.</p>', 'AssociationDescription$LastExecutionDate' => '<p>The date on which the association was last run.</p>', 'AssociationDescription$LastSuccessfulExecutionDate' => '<p>The last date on which the association was successfully run.</p>', 'AssociationExecution$CreatedTime' => '<p>The time the execution started.</p>', 'AssociationExecution$LastExecutionDate' => '<p>The date of the last execution.</p>', 'AssociationExecutionTarget$LastExecutionDate' => '<p>The date of the last execution.</p>', 'AssociationStatus$Date' => '<p>The date when the status changed.</p>', 'AssociationVersionInfo$CreatedDate' => '<p>The date the association version was created.</p>', 'AutomationExecution$ExecutionStartTime' => '<p>The time the execution started.</p>', 'AutomationExecution$ExecutionEndTime' => '<p>The time the execution finished.</p>', 'AutomationExecutionMetadata$ExecutionStartTime' => '<p>The time the execution started.</p>', 'AutomationExecutionMetadata$ExecutionEndTime' => '<p>The time the execution finished. This is not populated if the execution is still in progress.</p>', 'Command$ExpiresAfter' => '<p>If this time is reached and the command has not already started running, it will not run. Calculated based on the ExpiresAfter user input provided as part of the SendCommand API.</p>', 'Command$RequestedDateTime' => '<p>The date and time the command was requested.</p>', 'CommandInvocation$RequestedDateTime' => '<p>The time and date the request was sent to this instance.</p>', 'CommandPlugin$ResponseStartDateTime' => '<p>The time the plugin started running. </p>', 'CommandPlugin$ResponseFinishDateTime' => '<p>The time the plugin stopped running. Could stop prematurely if, for example, a cancel command was sent. </p>', 'ComplianceExecutionSummary$ExecutionTime' => '<p>The time the execution ran as a datetime object that is saved in the following format: yyyy-MM-dd\'T\'HH:mm:ss\'Z\'.</p>', 'DocumentDescription$CreatedDate' => '<p>The date when the document was created.</p>', 'DocumentVersionInfo$CreatedDate' => '<p>The date the document was created.</p>', 'GetMaintenanceWindowExecutionResult$StartTime' => '<p>The time the maintenance window started running.</p>', 'GetMaintenanceWindowExecutionResult$EndTime' => '<p>The time the maintenance window finished running.</p>', 'GetMaintenanceWindowExecutionTaskInvocationResult$StartTime' => '<p>The time that the task started running on the target.</p>', 'GetMaintenanceWindowExecutionTaskInvocationResult$EndTime' => '<p>The time that the task finished running on the target.</p>', 'GetMaintenanceWindowExecutionTaskResult$StartTime' => '<p>The time the task execution started.</p>', 'GetMaintenanceWindowExecutionTaskResult$EndTime' => '<p>The time the task execution completed.</p>', 'GetMaintenanceWindowResult$CreatedDate' => '<p>The date the maintenance window was created.</p>', 'GetMaintenanceWindowResult$ModifiedDate' => '<p>The date the maintenance window was last modified.</p>', 'GetPatchBaselineResult$CreatedDate' => '<p>The date the patch baseline was created.</p>', 'GetPatchBaselineResult$ModifiedDate' => '<p>The date the patch baseline was last modified.</p>', 'InstanceAssociationStatusInfo$ExecutionDate' => '<p>The date the instance association ran. </p>', 'InstanceInformation$LastPingDateTime' => '<p>The date and time when agent last pinged Systems Manager service. </p>', 'InstanceInformation$RegistrationDate' => '<p>The date the server or VM was registered with AWS as a managed instance.</p>', 'InstanceInformation$LastAssociationExecutionDate' => '<p>The date the association was last run.</p>', 'InstanceInformation$LastSuccessfulAssociationExecutionDate' => '<p>The last date the association was successfully run.</p>', 'InstancePatchState$OperationStartTime' => '<p>The time the most recent patching operation was started on the instance.</p>', 'InstancePatchState$OperationEndTime' => '<p>The time the most recent patching operation completed on the instance.</p>', 'InstancePatchState$LastNoRebootInstallOperationTime' => '<p>The time of the last attempt to patch the instance with <code>NoReboot</code> specified as the reboot option.</p>', 'MaintenanceWindowExecution$StartTime' => '<p>The time the execution started.</p>', 'MaintenanceWindowExecution$EndTime' => '<p>The time the execution finished.</p>', 'MaintenanceWindowExecutionTaskIdentity$StartTime' => '<p>The time the task execution started.</p>', 'MaintenanceWindowExecutionTaskIdentity$EndTime' => '<p>The time the task execution finished.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$StartTime' => '<p>The time the invocation started.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$EndTime' => '<p>The time the invocation finished.</p>', 'OpsItem$CreatedTime' => '<p>The date and time the OpsItem was created.</p>', 'OpsItem$LastModifiedTime' => '<p>The date and time the OpsItem was last updated.</p>', 'OpsItemSummary$CreatedTime' => '<p>The date and time the OpsItem was created.</p>', 'OpsItemSummary$LastModifiedTime' => '<p>The date and time the OpsItem was last updated.</p>', 'Parameter$LastModifiedDate' => '<p>Date the parameter was last changed or updated and the parameter version was created.</p>', 'ParameterHistory$LastModifiedDate' => '<p>Date the parameter was last changed or updated.</p>', 'ParameterMetadata$LastModifiedDate' => '<p>Date the parameter was last changed or updated.</p>', 'Patch$ReleaseDate' => '<p>The date the patch was released.</p>', 'PatchComplianceData$InstalledTime' => '<p>The date/time the patch was installed on the instance. Note that not all operating systems provide this level of information.</p>', 'PatchStatus$ApprovalDate' => '<p>The date the patch was approved (or will be approved if the status is PENDING_APPROVAL).</p>', 'ServiceSetting$LastModifiedDate' => '<p>The last time the service setting was modified.</p>', 'Session$StartDate' => '<p>The date and time, in ISO-8601 Extended format, when the session began.</p>', 'Session$EndDate' => '<p>The date and time, in ISO-8601 Extended format, when the session was terminated.</p>', 'StepExecution$ExecutionStartTime' => '<p>If a step has begun execution, this contains the time the step started. If the step is in Pending status, this field is not populated.</p>', 'StepExecution$ExecutionEndTime' => '<p>If a step has finished execution, this contains the time the execution ended. If the step has not yet concluded, this field is not populated.</p>', 'UpdatePatchBaselineResult$CreatedDate' => '<p>The date when the patch baseline was created.</p>', 'UpdatePatchBaselineResult$ModifiedDate' => '<p>The date when the patch baseline was last modified.</p>', ], ], 'DefaultBaseline' => [ 'base' => NULL, 'refs' => [ 'PatchBaselineIdentity$DefaultBaseline' => '<p>Whether this is the default baseline. Note that Systems Manager supports creating multiple default patch baselines. For example, you can create a default patch baseline for each operating system.</p>', ], ], 'DefaultInstanceName' => [ 'base' => NULL, 'refs' => [ 'Activation$DefaultInstanceName' => '<p>A name for the managed instance when it is created.</p>', 'CreateActivationRequest$DefaultInstanceName' => '<p>The name of the registered, managed instance as it will appear in the Systems Manager console or when you use the AWS command line tools to list Systems Manager resources.</p> <important> <p>Do not enter personally identifiable information in this field.</p> </important>', ], ], 'DeleteActivationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteActivationResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAssociationResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDocumentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDocumentResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInventoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInventoryResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMaintenanceWindowRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMaintenanceWindowResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteParameterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteParameterResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteParametersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteParametersResult' => [ 'base' => NULL, 'refs' => [], ], 'DeletePatchBaselineRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePatchBaselineResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourceDataSyncRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourceDataSyncResult' => [ 'base' => NULL, 'refs' => [], ], 'DeliveryTimedOutCount' => [ 'base' => NULL, 'refs' => [ 'Command$DeliveryTimedOutCount' => '<p>The number of targets for which the status is Delivery Timed Out.</p>', ], ], 'DeregisterManagedInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterManagedInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterPatchBaselineForPatchGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterPatchBaselineForPatchGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterTargetFromMaintenanceWindowRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterTargetFromMaintenanceWindowResult' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterTaskFromMaintenanceWindowRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterTaskFromMaintenanceWindowResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeActivationsFilter' => [ 'base' => '<p>Filter for the DescribeActivation API.</p>', 'refs' => [ 'DescribeActivationsFilterList$member' => NULL, ], ], 'DescribeActivationsFilterKeys' => [ 'base' => NULL, 'refs' => [ 'DescribeActivationsFilter$FilterKey' => '<p>The name of the filter.</p>', ], ], 'DescribeActivationsFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeActivationsRequest$Filters' => '<p>A filter to view information about your activations.</p>', ], ], 'DescribeActivationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeActivationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssociationExecutionTargetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssociationExecutionTargetsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssociationExecutionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssociationExecutionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAssociationResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAutomationExecutionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAutomationExecutionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAutomationStepExecutionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAutomationStepExecutionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAvailablePatchesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAvailablePatchesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDocumentPermissionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDocumentPermissionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDocumentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDocumentResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEffectiveInstanceAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEffectiveInstanceAssociationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEffectivePatchesForPatchBaselineRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEffectivePatchesForPatchBaselineResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceAssociationsStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceAssociationsStatusResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceInformationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceInformationResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstancePatchStatesForPatchGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstancePatchStatesForPatchGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstancePatchStatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstancePatchStatesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstancePatchesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstancePatchesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInventoryDeletionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInventoryDeletionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowExecutionTaskInvocationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowExecutionTaskInvocationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowExecutionTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowExecutionTasksResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowExecutionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowExecutionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowScheduleResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowTargetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowTargetsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowTasksResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowsForTargetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowsForTargetResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMaintenanceWindowsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOpsItemsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOpsItemsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeParametersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeParametersResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribePatchBaselinesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePatchBaselinesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribePatchGroupStateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePatchGroupStateResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribePatchGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePatchGroupsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribePatchPropertiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePatchPropertiesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSessionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSessionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescriptionInDocument' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$Description' => '<p>A description of the document. </p>', ], ], 'DocumentARN' => [ 'base' => NULL, 'refs' => [ 'Association$Name' => '<p>The name of the Systems Manager document.</p>', 'AssociationDescription$Name' => '<p>The name of the Systems Manager document.</p>', 'AssociationVersionInfo$Name' => '<p>The name specified when the association was created.</p>', 'CreateAssociationBatchRequestEntry$Name' => '<p>The name of the SSM document that contains the configuration information for the instance. You can specify Command or Automation documents.</p> <p>You can specify AWS-predefined documents, documents you created, or a document that is shared with you from another account.</p> <p>For SSM documents that are shared with you from other AWS accounts, you must specify the complete SSM document ARN, in the following format:</p> <p> <code>arn:aws:ssm:<i>region</i>:<i>account-id</i>:document/<i>document-name</i> </code> </p> <p>For example:</p> <p> <code>arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document</code> </p> <p>For AWS-predefined documents and SSM documents you created in your account, you only need to specify the document name. For example, <code>AWS-ApplyPatchBaseline</code> or <code>My-Document</code>.</p>', 'CreateAssociationRequest$Name' => '<p>The name of the SSM document that contains the configuration information for the instance. You can specify Command or Automation documents.</p> <p>You can specify AWS-predefined documents, documents you created, or a document that is shared with you from another account.</p> <p>For SSM documents that are shared with you from other AWS accounts, you must specify the complete SSM document ARN, in the following format:</p> <p> <code>arn:<i>partition</i>:ssm:<i>region</i>:<i>account-id</i>:document/<i>document-name</i> </code> </p> <p>For example:</p> <p> <code>arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document</code> </p> <p>For AWS-predefined documents and SSM documents you created in your account, you only need to specify the document name. For example, <code>AWS-ApplyPatchBaseline</code> or <code>My-Document</code>.</p>', 'DeleteAssociationRequest$Name' => '<p>The name of the Systems Manager document.</p>', 'DescribeAssociationRequest$Name' => '<p>The name of the Systems Manager document.</p>', 'DescribeDocumentRequest$Name' => '<p>The name of the Systems Manager document.</p>', 'DocumentDescription$Name' => '<p>The name of the Systems Manager document.</p>', 'DocumentIdentifier$Name' => '<p>The name of the Systems Manager document.</p>', 'DocumentRequires$Name' => '<p>The name of the required SSM document. The name can be an Amazon Resource Name (ARN).</p>', 'GetDocumentRequest$Name' => '<p>The name of the Systems Manager document.</p>', 'GetDocumentResult$Name' => '<p>The name of the Systems Manager document.</p>', 'InstanceAssociationStatusInfo$Name' => '<p>The name of the association.</p>', 'ListDocumentVersionsRequest$Name' => '<p>The name of the document. You can specify an Amazon Resource Name (ARN).</p>', 'SendCommandRequest$DocumentName' => '<p>Required. The name of the Systems Manager document to run. This can be a public document or a custom document.</p>', 'StartAutomationExecutionRequest$DocumentName' => '<p>The name of the Automation document to use for this execution.</p>', 'StartSessionRequest$DocumentName' => '<p>The name of the SSM document to define the parameters and plugin settings for the session. For example, <code>SSM-SessionManagerRunShell</code>. You can call the <a>GetDocument</a> API to verify the document exists before attempting to start a session. If no document name is provided, a shell to the instance is launched by default.</p>', 'UpdateAssociationRequest$Name' => '<p>The name of the SSM document that contains the configuration information for the instance. You can specify Command or Automation documents.</p> <p>You can specify AWS-predefined documents, documents you created, or a document that is shared with you from another account.</p> <p>For SSM documents that are shared with you from other AWS accounts, you must specify the complete SSM document ARN, in the following format:</p> <p> <code>arn:aws:ssm:<i>region</i>:<i>account-id</i>:document/<i>document-name</i> </code> </p> <p>For example:</p> <p> <code>arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document</code> </p> <p>For AWS-predefined documents and SSM documents you created in your account, you only need to specify the document name. For example, <code>AWS-ApplyPatchBaseline</code> or <code>My-Document</code>.</p>', 'UpdateAssociationStatusRequest$Name' => '<p>The name of the Systems Manager document.</p>', ], ], 'DocumentAlreadyExists' => [ 'base' => '<p>The specified document already exists.</p>', 'refs' => [], ], 'DocumentContent' => [ 'base' => NULL, 'refs' => [ 'CreateDocumentRequest$Content' => '<p>The content for the new SSM document in JSON or YAML format. We recommend storing the contents for your new document in an external JSON or YAML file and referencing the file in a command.</p> <p>For examples, see the following topics in the <i>AWS Systems Manager User Guide</i>.</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">Create an SSM document (AWS API)</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-cli.html">Create an SSM document (AWS CLI)</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/create-ssm-document-api.html">Create an SSM document (API)</a> </p> </li> </ul>', 'GetDocumentResult$Content' => '<p>The contents of the Systems Manager document.</p>', 'InstanceAssociation$Content' => '<p>The content of the association document for the instance(s).</p>', 'UpdateDocumentRequest$Content' => '<p>A valid JSON or YAML string.</p>', ], ], 'DocumentDefaultVersionDescription' => [ 'base' => '<p>A default version of a document.</p>', 'refs' => [ 'UpdateDocumentDefaultVersionResult$Description' => '<p>The description of a custom document that you want to set as the default version.</p>', ], ], 'DocumentDescription' => [ 'base' => '<p>Describes a Systems Manager document. </p>', 'refs' => [ 'CreateDocumentResult$DocumentDescription' => '<p>Information about the Systems Manager document.</p>', 'DescribeDocumentResult$Document' => '<p>Information about the Systems Manager document.</p>', 'UpdateDocumentResult$DocumentDescription' => '<p>A description of the document that was updated.</p>', ], ], 'DocumentFilter' => [ 'base' => '<p>This data type is deprecated. Instead, use <a>DocumentKeyValuesFilter</a>.</p>', 'refs' => [ 'DocumentFilterList$member' => NULL, ], ], 'DocumentFilterKey' => [ 'base' => NULL, 'refs' => [ 'DocumentFilter$key' => '<p>The name of the filter.</p>', ], ], 'DocumentFilterList' => [ 'base' => NULL, 'refs' => [ 'ListDocumentsRequest$DocumentFilterList' => '<p>This data type is deprecated. Instead, use <code>Filters</code>.</p>', ], ], 'DocumentFilterValue' => [ 'base' => NULL, 'refs' => [ 'DocumentFilter$value' => '<p>The value of the filter.</p>', ], ], 'DocumentFormat' => [ 'base' => NULL, 'refs' => [ 'CreateDocumentRequest$DocumentFormat' => '<p>Specify the document format for the request. The document format can be JSON, YAML, or TEXT. JSON is the default format.</p>', 'DocumentDescription$DocumentFormat' => '<p>The document format, either JSON or YAML.</p>', 'DocumentIdentifier$DocumentFormat' => '<p>The document format, either JSON or YAML.</p>', 'DocumentVersionInfo$DocumentFormat' => '<p>The document format, either JSON or YAML.</p>', 'GetDocumentRequest$DocumentFormat' => '<p>Returns the document in the specified format. The document format can be either JSON or YAML. JSON is the default format.</p>', 'GetDocumentResult$DocumentFormat' => '<p>The document format, either JSON or YAML.</p>', 'UpdateDocumentRequest$DocumentFormat' => '<p>Specify the document format for the new document version. Systems Manager supports JSON and YAML documents. JSON is the default format.</p>', ], ], 'DocumentHash' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$Hash' => '<p>The Sha256 or Sha1 hash created by the system when the document was created. </p> <note> <p>Sha1 hashes have been deprecated.</p> </note>', 'MaintenanceWindowRunCommandParameters$DocumentHash' => '<p>The SHA-256 or SHA-1 hash created by the system when the document was created. SHA-1 hashes have been deprecated.</p>', 'SendCommandRequest$DocumentHash' => '<p>The Sha256 or Sha1 hash created by the system when the document was created. </p> <note> <p>Sha1 hashes have been deprecated.</p> </note>', ], ], 'DocumentHashType' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$HashType' => '<p>The hash type of the document. Valid values include <code>Sha256</code> or <code>Sha1</code>.</p> <note> <p>Sha1 hashes have been deprecated.</p> </note>', 'MaintenanceWindowRunCommandParameters$DocumentHashType' => '<p>SHA-256 or SHA-1. SHA-1 hashes have been deprecated.</p>', 'SendCommandRequest$DocumentHashType' => '<p>Sha256 or Sha1.</p> <note> <p>Sha1 hashes have been deprecated.</p> </note>', ], ], 'DocumentIdentifier' => [ 'base' => '<p>Describes the name of a Systems Manager document.</p>', 'refs' => [ 'DocumentIdentifierList$member' => NULL, ], ], 'DocumentIdentifierList' => [ 'base' => NULL, 'refs' => [ 'ListDocumentsResult$DocumentIdentifiers' => '<p>The names of the Systems Manager documents.</p>', ], ], 'DocumentKeyValuesFilter' => [ 'base' => '<p>One or more filters. Use a filter to return a more specific list of documents.</p> <p>For keys, you can specify one or more tags that have been applied to a document. </p> <p>Other valid values include <code>Owner</code>, <code>Name</code>, <code>PlatformTypes</code>, <code>DocumentType</code>, and <code>TargetType</code>.</p> <p>Note that only one Owner can be specified in a request. For example: <code>Key=Owner,Values=Self</code>.</p> <p>If you use Name as a key, you can use a name prefix to return a list of documents. For example, in the AWS CLI, to return a list of all documents that begin with <code>Te</code>, run the following command:</p> <p> <code>aws ssm list-documents --filters Key=Name,Values=Te</code> </p> <p>If you specify more than two keys, only documents that are identified by all the tags are returned in the results. If you specify more than two values for a key, documents that are identified by any of the values are returned in the results.</p> <p>To specify a custom key and value pair, use the format <code>Key=tag:tagName,Values=valueName</code>.</p> <p>For example, if you created a Key called region and are using the AWS CLI to call the <code>list-documents</code> command: </p> <p> <code>aws ssm list-documents --filters Key=tag:region,Values=east,west Key=Owner,Values=Self</code> </p>', 'refs' => [ 'DocumentKeyValuesFilterList$member' => NULL, ], ], 'DocumentKeyValuesFilterKey' => [ 'base' => NULL, 'refs' => [ 'DocumentKeyValuesFilter$Key' => '<p>The name of the filter key.</p>', ], ], 'DocumentKeyValuesFilterList' => [ 'base' => NULL, 'refs' => [ 'ListDocumentsRequest$Filters' => '<p>One or more DocumentKeyValuesFilter objects. Use a filter to return a more specific list of results. For keys, you can specify one or more key-value pair tags that have been applied to a document. Other valid keys include <code>Owner</code>, <code>Name</code>, <code>PlatformTypes</code>, <code>DocumentType</code>, and <code>TargetType</code>. For example, to return documents you own use <code>Key=Owner,Values=Self</code>. To specify a custom key-value pair, use the format <code>Key=tag:tagName,Values=valueName</code>.</p>', ], ], 'DocumentKeyValuesFilterValue' => [ 'base' => NULL, 'refs' => [ 'DocumentKeyValuesFilterValues$member' => NULL, ], ], 'DocumentKeyValuesFilterValues' => [ 'base' => NULL, 'refs' => [ 'DocumentKeyValuesFilter$Values' => '<p>The value for the filter key.</p>', ], ], 'DocumentLimitExceeded' => [ 'base' => '<p>You can have at most 500 active Systems Manager documents.</p>', 'refs' => [], ], 'DocumentName' => [ 'base' => NULL, 'refs' => [ 'AutomationExecution$DocumentName' => '<p>The name of the Automation document used during the execution.</p>', 'AutomationExecutionMetadata$DocumentName' => '<p>The name of the Automation document used during execution.</p>', 'Command$DocumentName' => '<p>The name of the document requested for execution.</p>', 'CommandInvocation$DocumentName' => '<p>The document name that was requested for execution.</p>', 'CreateDocumentRequest$Name' => '<p>A name for the Systems Manager document.</p> <important> <p>You can\'t use the following strings as document name prefixes. These are reserved by AWS for use as document name prefixes:</p> <ul> <li> <p> <code>aws-</code> </p> </li> <li> <p> <code>amazon</code> </p> </li> <li> <p> <code>amzn</code> </p> </li> </ul> </important>', 'DeleteDocumentRequest$Name' => '<p>The name of the document.</p>', 'DescribeDocumentPermissionRequest$Name' => '<p>The name of the document for which you are the owner.</p>', 'DocumentDefaultVersionDescription$Name' => '<p>The name of the document.</p>', 'DocumentVersionInfo$Name' => '<p>The document name.</p>', 'GetCommandInvocationResult$DocumentName' => '<p>The name of the document that was run. For example, AWS-RunShellScript.</p>', 'ModifyDocumentPermissionRequest$Name' => '<p>The name of the document that you want to share.</p>', 'Session$DocumentName' => '<p>The name of the Session Manager SSM document used to define the parameters and plugin settings for the session. For example, <code>SSM-SessionManagerRunShell</code>.</p>', 'UpdateDocumentDefaultVersionRequest$Name' => '<p>The name of a custom document that you want to set as the default version.</p>', 'UpdateDocumentRequest$Name' => '<p>The name of the document that you want to update.</p>', ], ], 'DocumentOwner' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$Owner' => '<p>The AWS user account that created the document.</p>', 'DocumentIdentifier$Owner' => '<p>The AWS user account that created the document.</p>', ], ], 'DocumentParameter' => [ 'base' => '<p>Parameters specified in a System Manager document that run on the server when the command is run. </p>', 'refs' => [ 'DocumentParameterList$member' => NULL, ], ], 'DocumentParameterDefaultValue' => [ 'base' => NULL, 'refs' => [ 'DocumentParameter$DefaultValue' => '<p>If specified, the default values for the parameters. Parameters without a default value are required. Parameters with a default value are optional.</p>', ], ], 'DocumentParameterDescrption' => [ 'base' => NULL, 'refs' => [ 'DocumentParameter$Description' => '<p>A description of what the parameter does, how to use it, the default value, and whether or not the parameter is optional.</p>', ], ], 'DocumentParameterList' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$Parameters' => '<p>A description of the parameters for a document.</p>', ], ], 'DocumentParameterName' => [ 'base' => NULL, 'refs' => [ 'DocumentParameter$Name' => '<p>The name of the parameter.</p>', ], ], 'DocumentParameterType' => [ 'base' => NULL, 'refs' => [ 'DocumentParameter$Type' => '<p>The type of parameter. The type can be either String or StringList.</p>', ], ], 'DocumentPermissionLimit' => [ 'base' => '<p>The document cannot be shared with more AWS user accounts. You can share a document with a maximum of 20 accounts. You can publicly share up to five documents. If you need to increase this limit, contact AWS Support.</p>', 'refs' => [], ], 'DocumentPermissionType' => [ 'base' => NULL, 'refs' => [ 'DescribeDocumentPermissionRequest$PermissionType' => '<p>The permission type for the document. The permission type can be <i>Share</i>.</p>', 'ModifyDocumentPermissionRequest$PermissionType' => '<p>The permission type for the document. The permission type can be <i>Share</i>.</p>', ], ], 'DocumentRequires' => [ 'base' => '<p>An SSM document required by the current document.</p>', 'refs' => [ 'DocumentRequiresList$member' => NULL, ], ], 'DocumentRequiresList' => [ 'base' => NULL, 'refs' => [ 'CreateDocumentRequest$Requires' => '<p>A list of SSM documents required by a document. This parameter is used exclusively by AWS AppConfig. When a user creates an AppConfig configuration in an SSM document, the user must also specify a required document for validation purposes. In this case, an <code>ApplicationConfiguration</code> document requires an <code>ApplicationConfigurationSchema</code> document for validation purposes. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/appconfig.html">AWS AppConfig</a> in the <i>AWS Systems Manager User Guide</i>.</p>', 'DocumentDescription$Requires' => '<p>A list of SSM documents required by a document. For example, an <code>ApplicationConfiguration</code> document requires an <code>ApplicationConfigurationSchema</code> document.</p>', 'DocumentIdentifier$Requires' => '<p>A list of SSM documents required by a document. For example, an <code>ApplicationConfiguration</code> document requires an <code>ApplicationConfigurationSchema</code> document.</p>', 'GetDocumentResult$Requires' => '<p>A list of SSM documents required by a document. For example, an <code>ApplicationConfiguration</code> document requires an <code>ApplicationConfigurationSchema</code> document.</p>', ], ], 'DocumentSchemaVersion' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$SchemaVersion' => '<p>The schema version.</p>', 'DocumentIdentifier$SchemaVersion' => '<p>The schema version.</p>', ], ], 'DocumentSha1' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$Sha1' => '<p>The SHA1 hash of the document, which you can use for verification.</p>', ], ], 'DocumentStatus' => [ 'base' => '<p>The status of a document.</p>', 'refs' => [ 'DocumentDescription$Status' => '<p>The status of the Systems Manager document.</p>', 'DocumentVersionInfo$Status' => '<p>The status of the Systems Manager document, such as <code>Creating</code>, <code>Active</code>, <code>Failed</code>, and <code>Deleting</code>.</p>', 'GetDocumentResult$Status' => '<p>The status of the Systems Manager document, such as <code>Creating</code>, <code>Active</code>, <code>Updating</code>, <code>Failed</code>, and <code>Deleting</code>.</p>', ], ], 'DocumentStatusInformation' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$StatusInformation' => '<p>A message returned by AWS Systems Manager that explains the <code>Status</code> value. For example, a <code>Failed</code> status might be explained by the <code>StatusInformation</code> message, "The specified S3 bucket does not exist. Verify that the URL of the S3 bucket is correct."</p>', 'DocumentVersionInfo$StatusInformation' => '<p>A message returned by AWS Systems Manager that explains the <code>Status</code> value. For example, a <code>Failed</code> status might be explained by the <code>StatusInformation</code> message, "The specified S3 bucket does not exist. Verify that the URL of the S3 bucket is correct."</p>', 'GetDocumentResult$StatusInformation' => '<p>A message returned by AWS Systems Manager that explains the <code>Status</code> value. For example, a <code>Failed</code> status might be explained by the <code>StatusInformation</code> message, "The specified S3 bucket does not exist. Verify that the URL of the S3 bucket is correct."</p>', ], ], 'DocumentType' => [ 'base' => NULL, 'refs' => [ 'CreateDocumentRequest$DocumentType' => '<p>The type of document to create.</p>', 'DocumentDescription$DocumentType' => '<p>The type of document.</p>', 'DocumentIdentifier$DocumentType' => '<p>The document type.</p>', 'GetDocumentResult$DocumentType' => '<p>The document type.</p>', ], ], 'DocumentVersion' => [ 'base' => NULL, 'refs' => [ 'Association$DocumentVersion' => '<p>The version of the document used in the association.</p>', 'AssociationDescription$DocumentVersion' => '<p>The document version.</p>', 'AssociationVersionInfo$DocumentVersion' => '<p>The version of a Systems Manager document used when the association version was created.</p>', 'AutomationExecution$DocumentVersion' => '<p>The version of the document to use during execution.</p>', 'AutomationExecutionMetadata$DocumentVersion' => '<p>The document version used during the execution.</p>', 'Command$DocumentVersion' => '<p>The SSM document version.</p>', 'CommandInvocation$DocumentVersion' => '<p>The SSM document version.</p>', 'CreateAssociationBatchRequestEntry$DocumentVersion' => '<p>The document version.</p>', 'CreateAssociationRequest$DocumentVersion' => '<p>The document version you want to associate with the target(s). Can be a specific version or the default version.</p>', 'DeleteDocumentRequest$DocumentVersion' => '<p>The version of the document that you want to delete. If not provided, all versions of the document are deleted.</p>', 'DescribeDocumentRequest$DocumentVersion' => '<p>The document version for which you want information. Can be a specific version or the default version.</p>', 'DocumentDefaultVersionDescription$DefaultVersion' => '<p>The default version of the document.</p>', 'DocumentDescription$DocumentVersion' => '<p>The document version.</p>', 'DocumentDescription$LatestVersion' => '<p>The latest version of the document.</p>', 'DocumentDescription$DefaultVersion' => '<p>The default version.</p>', 'DocumentIdentifier$DocumentVersion' => '<p>The document version.</p>', 'DocumentRequires$Version' => '<p>The document version required by the current document.</p>', 'DocumentVersionInfo$DocumentVersion' => '<p>The document version.</p>', 'GetCommandInvocationResult$DocumentVersion' => '<p>The SSM document version used in the request.</p>', 'GetDocumentRequest$DocumentVersion' => '<p>The document version for which you want information.</p>', 'GetDocumentResult$DocumentVersion' => '<p>The document version.</p>', 'InstanceAssociationStatusInfo$DocumentVersion' => '<p>The association document versions.</p>', 'MaintenanceWindowAutomationParameters$DocumentVersion' => '<p>The version of an Automation document to use during task execution.</p>', 'MaintenanceWindowRunCommandParameters$DocumentVersion' => '<p>The SSM document version to use in the request. You can specify $DEFAULT, $LATEST, or a specific version number. If you run commands by using the AWS CLI, then you must escape the first two options by using a backslash. If you specify a version number, then you don\'t need to use the backslash. For example:</p> <p>--document-version "\\$DEFAULT"</p> <p>--document-version "\\$LATEST"</p> <p>--document-version "3"</p>', 'SendCommandRequest$DocumentVersion' => '<p>The SSM document version to use in the request. You can specify $DEFAULT, $LATEST, or a specific version number. If you run commands by using the AWS CLI, then you must escape the first two options by using a backslash. If you specify a version number, then you don\'t need to use the backslash. For example:</p> <p>--document-version "\\$DEFAULT"</p> <p>--document-version "\\$LATEST"</p> <p>--document-version "3"</p>', 'StartAutomationExecutionRequest$DocumentVersion' => '<p>The version of the Automation document to use for this execution.</p>', 'UpdateAssociationRequest$DocumentVersion' => '<p>The document version you want update for the association. </p>', 'UpdateDocumentRequest$DocumentVersion' => '<p>(Required) The latest version of the document that you want to update. The latest document version can be specified using the $LATEST variable or by the version number. Updating a previous version of a document is not supported.</p>', ], ], 'DocumentVersionInfo' => [ 'base' => '<p>Version information about the document.</p>', 'refs' => [ 'DocumentVersionList$member' => NULL, ], ], 'DocumentVersionLimitExceeded' => [ 'base' => '<p>The document has too many versions. Delete one or more document versions and try again.</p>', 'refs' => [], ], 'DocumentVersionList' => [ 'base' => NULL, 'refs' => [ 'ListDocumentVersionsResult$DocumentVersions' => '<p>The document versions.</p>', ], ], 'DocumentVersionName' => [ 'base' => NULL, 'refs' => [ 'CreateDocumentRequest$VersionName' => '<p>An optional field specifying the version of the artifact you are creating with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document, and cannot be changed.</p>', 'DeleteDocumentRequest$VersionName' => '<p>The version name of the document that you want to delete. If not provided, all versions of the document are deleted.</p>', 'DescribeDocumentRequest$VersionName' => '<p>An optional field specifying the version of the artifact associated with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document, and cannot be changed.</p>', 'DocumentDefaultVersionDescription$DefaultVersionName' => '<p>The default version of the artifact associated with the document.</p>', 'DocumentDescription$VersionName' => '<p>The version of the artifact associated with the document.</p>', 'DocumentIdentifier$VersionName' => '<p>An optional field specifying the version of the artifact associated with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document, and cannot be changed.</p>', 'DocumentVersionInfo$VersionName' => '<p>The version of the artifact associated with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document, and cannot be changed.</p>', 'GetDocumentRequest$VersionName' => '<p>An optional field specifying the version of the artifact associated with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document and can\'t be changed.</p>', 'GetDocumentResult$VersionName' => '<p>The version of the artifact associated with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document, and cannot be changed.</p>', 'UpdateDocumentRequest$VersionName' => '<p>An optional field specifying the version of the artifact you are updating with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document, and cannot be changed.</p>', ], ], 'DocumentVersionNumber' => [ 'base' => NULL, 'refs' => [ 'UpdateDocumentDefaultVersionRequest$DocumentVersion' => '<p>The version of a custom document that you want to set as the default version.</p>', ], ], 'DoesNotExistException' => [ 'base' => '<p>Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline, doesn\'t exist.</p> <p>For information about resource quotas in Systems Manager, see <a href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the <i>AWS General Reference</i>.</p>', 'refs' => [], ], 'DryRun' => [ 'base' => NULL, 'refs' => [ 'DeleteInventoryRequest$DryRun' => '<p>Use this option to view a summary of the deletion request without deleting any data or the data type. This option is useful when you only want to understand what will be deleted. Once you validate that the data to be deleted is what you intend to delete, you can run the same command without specifying the <code>DryRun</code> option.</p>', ], ], 'DuplicateDocumentContent' => [ 'base' => '<p>The content of the association document matches another document. Change the content of the document and try again.</p>', 'refs' => [], ], 'DuplicateDocumentVersionName' => [ 'base' => '<p>The version name has already been used in this document. Specify a different version name, and then try again.</p>', 'refs' => [], ], 'DuplicateInstanceId' => [ 'base' => '<p>You cannot specify an instance ID in more than one association.</p>', 'refs' => [], ], 'EffectiveInstanceAssociationMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeEffectiveInstanceAssociationsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'EffectivePatch' => [ 'base' => '<p>The EffectivePatch structure defines metadata about a patch along with the approval state of the patch in a particular patch baseline. The approval state includes information about whether the patch is currently approved, due to be approved by a rule, explicitly approved, or explicitly rejected and the date the patch was or will be approved.</p>', 'refs' => [ 'EffectivePatchList$member' => NULL, ], ], 'EffectivePatchList' => [ 'base' => NULL, 'refs' => [ 'DescribeEffectivePatchesForPatchBaselineResult$EffectivePatches' => '<p>An array of patches and patch status.</p>', ], ], 'ErrorCount' => [ 'base' => NULL, 'refs' => [ 'Command$ErrorCount' => '<p>The number of targets for which the status is Failed or Execution Timed Out.</p>', ], ], 'ExecutionMode' => [ 'base' => NULL, 'refs' => [ 'AutomationExecution$Mode' => '<p>The automation execution mode.</p>', 'AutomationExecutionMetadata$Mode' => '<p>The Automation execution mode.</p>', 'StartAutomationExecutionRequest$Mode' => '<p>The execution mode of the automation. Valid modes include the following: Auto and Interactive. The default mode is Auto.</p>', ], ], 'ExecutionRoleName' => [ 'base' => NULL, 'refs' => [ 'TargetLocation$ExecutionRoleName' => '<p>The Automation execution role used by the currently running Automation.</p>', ], ], 'ExpirationDate' => [ 'base' => NULL, 'refs' => [ 'Activation$ExpirationDate' => '<p>The date when this activation can no longer be used to register managed instances.</p>', 'CreateActivationRequest$ExpirationDate' => '<p>The date by which this activation request should expire. The default value is 24 hours.</p>', ], ], 'FailedCreateAssociation' => [ 'base' => '<p>Describes a failed association.</p>', 'refs' => [ 'FailedCreateAssociationList$member' => NULL, ], ], 'FailedCreateAssociationList' => [ 'base' => NULL, 'refs' => [ 'CreateAssociationBatchResult$Failed' => '<p>Information about the associations that failed.</p>', ], ], 'FailureDetails' => [ 'base' => '<p>Information about an Automation failure.</p>', 'refs' => [ 'StepExecution$FailureDetails' => '<p>Information about the Automation failure.</p>', ], ], 'Fault' => [ 'base' => NULL, 'refs' => [ 'FailedCreateAssociation$Fault' => '<p>The source of the failure.</p>', ], ], 'FeatureNotAvailableException' => [ 'base' => '<p>You attempted to register a LAMBDA or STEP_FUNCTIONS task in a region where the corresponding service is not available. </p>', 'refs' => [], ], 'GetAutomationExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAutomationExecutionResult' => [ 'base' => NULL, 'refs' => [], ], 'GetCalendarStateRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCalendarStateResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCommandInvocationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCommandInvocationResult' => [ 'base' => NULL, 'refs' => [], ], 'GetConnectionStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetConnectionStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDefaultPatchBaselineRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDefaultPatchBaselineResult' => [ 'base' => NULL, 'refs' => [], ], 'GetDeployablePatchSnapshotForInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDeployablePatchSnapshotForInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'GetDocumentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDocumentResult' => [ 'base' => NULL, 'refs' => [], ], 'GetInventoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInventoryResult' => [ 'base' => NULL, 'refs' => [], ], 'GetInventorySchemaMaxResults' => [ 'base' => NULL, 'refs' => [ 'GetInventorySchemaRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'GetInventorySchemaRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInventorySchemaResult' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowExecutionResult' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowExecutionTaskInvocationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowExecutionTaskInvocationResult' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowExecutionTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowExecutionTaskResult' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowResult' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMaintenanceWindowTaskResult' => [ 'base' => NULL, 'refs' => [], ], 'GetOpsItemRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetOpsItemResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetOpsSummaryRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetOpsSummaryResult' => [ 'base' => NULL, 'refs' => [], ], 'GetParameterHistoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetParameterHistoryResult' => [ 'base' => NULL, 'refs' => [], ], 'GetParameterRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetParameterResult' => [ 'base' => NULL, 'refs' => [], ], 'GetParametersByPathMaxResults' => [ 'base' => NULL, 'refs' => [ 'GetParametersByPathRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'GetParametersByPathRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetParametersByPathResult' => [ 'base' => NULL, 'refs' => [], ], 'GetParametersRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetParametersResult' => [ 'base' => NULL, 'refs' => [], ], 'GetPatchBaselineForPatchGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPatchBaselineForPatchGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'GetPatchBaselineRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPatchBaselineResult' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceSettingRequest' => [ 'base' => '<p>The request body of the GetServiceSetting API action.</p>', 'refs' => [], ], 'GetServiceSettingResult' => [ 'base' => '<p>The query result body of the GetServiceSetting API action.</p>', 'refs' => [], ], 'HierarchyLevelLimitExceededException' => [ 'base' => '<p>A hierarchy can have a maximum of 15 levels. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-parameter-name-constraints.html">Requirements and constraints for parameter names</a> in the <i>AWS Systems Manager User Guide</i>. </p>', 'refs' => [], ], 'HierarchyTypeMismatchException' => [ 'base' => '<p>Parameter Store does not support changing a parameter type in a hierarchy. For example, you can\'t change a parameter from a <code>String</code> type to a <code>SecureString</code> type. You must create a new, unique parameter.</p>', 'refs' => [], ], 'IPAddress' => [ 'base' => NULL, 'refs' => [ 'InstanceInformation$IPAddress' => '<p>The IP address of the managed instance.</p>', ], ], 'ISO8601String' => [ 'base' => NULL, 'refs' => [ 'GetCalendarStateRequest$AtTime' => '<p>(Optional) The specific time for which you want to get calendar state information, in <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> format. If you do not add <code>AtTime</code>, the current time is assumed.</p>', 'GetCalendarStateResponse$AtTime' => '<p>The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> string, that you specified in your command. If you did not specify a time, <code>GetCalendarState</code> uses the current time.</p>', 'GetCalendarStateResponse$NextTransitionTime' => '<p>The time, as an <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> string, that the calendar state will change. If the current calendar state is <code>OPEN</code>, <code>NextTransitionTime</code> indicates when the calendar state changes to <code>CLOSED</code>, and vice-versa.</p>', ], ], 'IamRole' => [ 'base' => NULL, 'refs' => [ 'Activation$IamRole' => '<p>The Amazon Identity and Access Management (IAM) role to assign to the managed instance.</p>', 'CreateActivationRequest$IamRole' => '<p>The Amazon Identity and Access Management (IAM) role that you want to assign to the managed instance. This IAM role must provide AssumeRole permissions for the Systems Manager service principal <code>ssm.amazonaws.com</code>. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-service-role.html">Create an IAM service role for a hybrid environment</a> in the <i>AWS Systems Manager User Guide</i>.</p>', 'InstanceInformation$IamRole' => '<p>The Amazon Identity and Access Management (IAM) role assigned to the on-premises Systems Manager managed instance. This call does not return the IAM role for EC2 instances. To retrieve the IAM role for an EC2 instance, use the Amazon EC2 <code>DescribeInstances</code> action. For information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html">DescribeInstances</a> in the <i>Amazon EC2 API Reference</i> or <a href="http://docs.aws.amazon.com/cli/latest/reference/ec2/describe-instances.html">describe-instances</a> in the <i>AWS CLI Command Reference</i>.</p>', 'UpdateManagedInstanceRoleRequest$IamRole' => '<p>The IAM role you want to assign or change.</p>', ], ], 'IdempotencyToken' => [ 'base' => NULL, 'refs' => [ 'StartAutomationExecutionRequest$ClientToken' => '<p>User-provided idempotency token. The token must be unique, is case insensitive, enforces the UUID format, and can\'t be reused.</p>', ], ], 'IdempotentParameterMismatch' => [ 'base' => '<p>Error returned when an idempotent operation is retried and the parameters don\'t match the original call to the API with the same idempotency token. </p>', 'refs' => [], ], 'IncompatiblePolicyException' => [ 'base' => '<p>There is a conflict in the policies specified for this parameter. You can\'t, for example, specify two Expiration policies for a parameter. Review your policies, and try again.</p>', 'refs' => [], ], 'InstallOverrideList' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$InstallOverrideList' => '<p>An https URL or an Amazon S3 path-style URL to a list of patches to be installed. This patch installation list, which you maintain in an S3 bucket in YAML format and specify in the SSM document <code>AWS-RunPatchBaseline</code>, overrides the patches specified by the default patch baseline.</p> <p>For more information about the <code>InstallOverrideList</code> parameter, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-about-aws-runpatchbaseline.html">About the SSM document AWS-RunPatchBaseline</a> in the <i>AWS Systems Manager User Guide</i>.</p>', ], ], 'InstanceAggregatedAssociationOverview' => [ 'base' => '<p>Status information about the aggregated associations.</p>', 'refs' => [ 'InstanceInformation$AssociationOverview' => '<p>Information about the association.</p>', ], ], 'InstanceAssociation' => [ 'base' => '<p>One or more association documents on the instance. </p>', 'refs' => [ 'InstanceAssociationList$member' => NULL, ], ], 'InstanceAssociationExecutionSummary' => [ 'base' => NULL, 'refs' => [ 'InstanceAssociationStatusInfo$ExecutionSummary' => '<p>Summary information about association execution.</p>', ], ], 'InstanceAssociationList' => [ 'base' => NULL, 'refs' => [ 'DescribeEffectiveInstanceAssociationsResult$Associations' => '<p>The associations for the requested instance.</p>', ], ], 'InstanceAssociationOutputLocation' => [ 'base' => '<p>An S3 bucket where you want to store the results of this request.</p>', 'refs' => [ 'AssociationDescription$OutputLocation' => '<p>An S3 bucket where you want to store the output details of the request.</p>', 'AssociationVersionInfo$OutputLocation' => '<p>The location in Amazon S3 specified for the association when the association version was created.</p>', 'CreateAssociationBatchRequestEntry$OutputLocation' => '<p>An S3 bucket where you want to store the results of this request.</p>', 'CreateAssociationRequest$OutputLocation' => '<p>An S3 bucket where you want to store the output details of the request.</p>', 'UpdateAssociationRequest$OutputLocation' => '<p>An S3 bucket where you want to store the results of this request.</p>', ], ], 'InstanceAssociationOutputUrl' => [ 'base' => '<p>The URL of S3 bucket where you want to store the results of this request.</p>', 'refs' => [ 'InstanceAssociationStatusInfo$OutputUrl' => '<p>A URL for an S3 bucket where you want to store the results of this request.</p>', ], ], 'InstanceAssociationStatusAggregatedCount' => [ 'base' => NULL, 'refs' => [ 'InstanceAggregatedAssociationOverview$InstanceAssociationStatusAggregatedCount' => '<p>The number of associations for the instance(s).</p>', ], ], 'InstanceAssociationStatusInfo' => [ 'base' => '<p>Status information about the instance association.</p>', 'refs' => [ 'InstanceAssociationStatusInfos$member' => NULL, ], ], 'InstanceAssociationStatusInfos' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceAssociationsStatusResult$InstanceAssociationStatusInfos' => '<p>Status information about the association.</p>', ], ], 'InstanceCount' => [ 'base' => NULL, 'refs' => [ 'AssociationStatusAggregatedCount$value' => NULL, 'InstanceAssociationStatusAggregatedCount$value' => NULL, ], ], 'InstanceId' => [ 'base' => NULL, 'refs' => [ 'Association$InstanceId' => '<p>The ID of the instance.</p>', 'AssociationDescription$InstanceId' => '<p>The ID of the instance.</p>', 'CommandInvocation$InstanceId' => '<p>The instance ID in which this invocation was requested.</p>', 'CreateAssociationBatchRequestEntry$InstanceId' => '<p>The ID of the instance. </p>', 'CreateAssociationRequest$InstanceId' => '<p>The instance ID.</p> <note> <p> <code>InstanceId</code> has been deprecated. To specify an instance ID for an association, use the <code>Targets</code> parameter. Requests that include the parameter <code>InstanceID</code> with SSM documents that use schema version 2.0 or later will fail. In addition, if you use the parameter <code>InstanceId</code>, you cannot use the parameters <code>AssociationName</code>, <code>DocumentVersion</code>, <code>MaxErrors</code>, <code>MaxConcurrency</code>, <code>OutputLocation</code>, or <code>ScheduleExpression</code>. To use these parameters, you must use the <code>Targets</code> parameter.</p> </note>', 'DeleteAssociationRequest$InstanceId' => '<p>The ID of the instance.</p>', 'DescribeAssociationRequest$InstanceId' => '<p>The instance ID.</p>', 'DescribeEffectiveInstanceAssociationsRequest$InstanceId' => '<p>The instance ID for which you want to view all associations.</p>', 'DescribeInstanceAssociationsStatusRequest$InstanceId' => '<p>The instance IDs for which you want association status information.</p>', 'DescribeInstancePatchesRequest$InstanceId' => '<p>The ID of the instance whose patch state information should be retrieved.</p>', 'GetCommandInvocationRequest$InstanceId' => '<p>(Required) The ID of the managed instance targeted by the command. A managed instance can be an EC2 instance or an instance in your hybrid environment that is configured for Systems Manager.</p>', 'GetCommandInvocationResult$InstanceId' => '<p>The ID of the managed instance targeted by the command. A managed instance can be an EC2 instance or an instance in your hybrid environment that is configured for Systems Manager.</p>', 'GetDeployablePatchSnapshotForInstanceRequest$InstanceId' => '<p>The ID of the instance for which the appropriate patch snapshot should be retrieved.</p>', 'GetDeployablePatchSnapshotForInstanceResult$InstanceId' => '<p>The ID of the instance.</p>', 'InstanceAssociation$InstanceId' => '<p>The instance ID.</p>', 'InstanceAssociationStatusInfo$InstanceId' => '<p>The instance ID where the association was created.</p>', 'InstanceIdList$member' => NULL, 'InstanceInformation$InstanceId' => '<p>The instance ID. </p>', 'InstancePatchState$InstanceId' => '<p>The ID of the managed instance the high-level patch compliance information was collected for.</p>', 'ListCommandInvocationsRequest$InstanceId' => '<p>(Optional) The command execution details for a specific instance ID.</p>', 'ListCommandsRequest$InstanceId' => '<p>(Optional) Lists commands issued against this instance ID.</p> <note> <p>You can\'t specify an instance ID in the same command that you specify <code>Status</code> = <code>Pending</code>. This is because the command has not reached the instance yet.</p> </note>', 'ListInventoryEntriesRequest$InstanceId' => '<p>The instance ID for which you want inventory information.</p>', 'ListInventoryEntriesResult$InstanceId' => '<p>The instance ID targeted by the request to query inventory information.</p>', 'PutInventoryRequest$InstanceId' => '<p>An instance ID where you want to add or update inventory items.</p>', 'UpdateAssociationStatusRequest$InstanceId' => '<p>The ID of the instance.</p>', ], ], 'InstanceIdList' => [ 'base' => NULL, 'refs' => [ 'CancelCommandRequest$InstanceIds' => '<p>(Optional) A list of instance IDs on which you want to cancel the command. If not provided, the command is canceled on every instance on which it was requested.</p>', 'Command$InstanceIds' => '<p>The instance IDs against which this command was requested.</p>', 'DescribeInstancePatchStatesRequest$InstanceIds' => '<p>The ID of the instance whose patch state information should be retrieved.</p>', 'SendCommandRequest$InstanceIds' => '<p>The IDs of the instances where the command should run. Specifying instance IDs is most useful when you are targeting a limited number of instances, though you can specify up to 50 IDs.</p> <p>To target a larger number of instances, or if you prefer not to list individual instance IDs, we recommend using the <code>Targets</code> option instead. Using <code>Targets</code>, which accepts tag key-value pairs to identify the instances to send commands to, you can a send command to tens, hundreds, or thousands of instances at once.</p> <p>For more information about how to use targets, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Using targets and rate controls to send commands to a fleet</a> in the <i>AWS Systems Manager User Guide</i>.</p>', ], ], 'InstanceInformation' => [ 'base' => '<p>Describes a filter for a specific list of instances. </p>', 'refs' => [ 'InstanceInformationList$member' => NULL, ], ], 'InstanceInformationFilter' => [ 'base' => '<p>Describes a filter for a specific list of instances. You can filter instances information by using tags. You specify tags by using a key-value mapping.</p> <p>Use this action instead of the <a>DescribeInstanceInformationRequest$InstanceInformationFilterList</a> method. The <code>InstanceInformationFilterList</code> method is a legacy method and does not support tags. </p>', 'refs' => [ 'InstanceInformationFilterList$member' => NULL, ], ], 'InstanceInformationFilterKey' => [ 'base' => NULL, 'refs' => [ 'InstanceInformationFilter$key' => '<p>The name of the filter. </p>', ], ], 'InstanceInformationFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceInformationRequest$InstanceInformationFilterList' => '<p>This is a legacy method. We recommend that you don\'t use this method. Instead, use the <code>Filters</code> data type. <code>Filters</code> enables you to return instance information by filtering based on tags applied to managed instances.</p> <note> <p>Attempting to use <code>InstanceInformationFilterList</code> and <code>Filters</code> leads to an exception error. </p> </note>', ], ], 'InstanceInformationFilterValue' => [ 'base' => NULL, 'refs' => [ 'InstanceInformationFilterValueSet$member' => NULL, ], ], 'InstanceInformationFilterValueSet' => [ 'base' => NULL, 'refs' => [ 'InstanceInformationFilter$valueSet' => '<p>The filter values.</p>', 'InstanceInformationStringFilter$Values' => '<p>The filter values.</p>', ], ], 'InstanceInformationList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceInformationResult$InstanceInformationList' => '<p>The instance information list.</p>', ], ], 'InstanceInformationStringFilter' => [ 'base' => '<p>The filters to describe or get information about your managed instances.</p>', 'refs' => [ 'InstanceInformationStringFilterList$member' => NULL, ], ], 'InstanceInformationStringFilterKey' => [ 'base' => NULL, 'refs' => [ 'InstanceInformationStringFilter$Key' => '<p>The filter key name to describe your instances. For example:</p> <p>"InstanceIds"|"AgentVersion"|"PingStatus"|"PlatformTypes"|"ActivationIds"|"IamRole"|"ResourceType"|"AssociationStatus"|"Tag Key"</p>', ], ], 'InstanceInformationStringFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceInformationRequest$Filters' => '<p>One or more filters. Use a filter to return a more specific list of instances. You can filter based on tags applied to EC2 instances. Use this <code>Filters</code> data type instead of <code>InstanceInformationFilterList</code>, which is deprecated.</p>', ], ], 'InstancePatchState' => [ 'base' => '<p>Defines the high-level patch compliance state for a managed instance, providing information about the number of installed, missing, not applicable, and failed patches along with metadata about the operation when this information was gathered for the instance.</p>', 'refs' => [ 'InstancePatchStateList$member' => NULL, 'InstancePatchStatesList$member' => NULL, ], ], 'InstancePatchStateFilter' => [ 'base' => '<p>Defines a filter used in DescribeInstancePatchStatesForPatchGroup used to scope down the information returned by the API.</p>', 'refs' => [ 'InstancePatchStateFilterList$member' => NULL, ], ], 'InstancePatchStateFilterKey' => [ 'base' => NULL, 'refs' => [ 'InstancePatchStateFilter$Key' => '<p>The key for the filter. Supported values are FailedCount, InstalledCount, InstalledOtherCount, MissingCount and NotApplicableCount.</p>', ], ], 'InstancePatchStateFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstancePatchStatesForPatchGroupRequest$Filters' => '<p>Each entry in the array is a structure containing:</p> <p>Key (string between 1 and 200 characters)</p> <p> Values (array containing a single string)</p> <p> Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")</p>', ], ], 'InstancePatchStateFilterValue' => [ 'base' => NULL, 'refs' => [ 'InstancePatchStateFilterValues$member' => NULL, ], ], 'InstancePatchStateFilterValues' => [ 'base' => NULL, 'refs' => [ 'InstancePatchStateFilter$Values' => '<p>The value for the filter, must be an integer greater than or equal to 0.</p>', ], ], 'InstancePatchStateList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstancePatchStatesResult$InstancePatchStates' => '<p>The high-level patch state for the requested instances.</p>', ], ], 'InstancePatchStateOperatorType' => [ 'base' => NULL, 'refs' => [ 'InstancePatchStateFilter$Type' => '<p>The type of comparison that should be performed for the value: Equal, NotEqual, LessThan or GreaterThan.</p>', ], ], 'InstancePatchStatesList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstancePatchStatesForPatchGroupResult$InstancePatchStates' => '<p>The high-level patch state for the requested instances. </p>', ], ], 'InstanceTagName' => [ 'base' => NULL, 'refs' => [ 'CommandInvocation$InstanceName' => '<p>The name of the invocation target. For EC2 instances this is the value for the aws:Name tag. For on-premises instances, this is the name of the instance.</p>', ], ], 'InstancesCount' => [ 'base' => NULL, 'refs' => [ 'DescribePatchGroupStateResult$InstancesWithInstalledPendingRebootPatches' => '<p>The number of instances with patches installed by Patch Manager that have not been rebooted after the patch installation. The status of these instances is NON_COMPLIANT.</p>', 'DescribePatchGroupStateResult$InstancesWithInstalledRejectedPatches' => '<p>The number of instances with patches installed that are specified in a RejectedPatches list. Patches with a status of <i>INSTALLED_REJECTED</i> were typically installed before they were added to a RejectedPatches list.</p> <note> <p>If ALLOW_AS_DEPENDENCY is the specified option for RejectedPatchesAction, the value of InstancesWithInstalledRejectedPatches will always be 0 (zero).</p> </note>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'DescribePatchGroupStateResult$Instances' => '<p>The number of instances in the patch group.</p>', 'DescribePatchGroupStateResult$InstancesWithInstalledPatches' => '<p>The number of instances with installed patches.</p>', 'DescribePatchGroupStateResult$InstancesWithInstalledOtherPatches' => '<p>The number of instances with patches installed that aren\'t defined in the patch baseline.</p>', 'DescribePatchGroupStateResult$InstancesWithMissingPatches' => '<p>The number of instances with missing patches from the patch baseline.</p>', 'DescribePatchGroupStateResult$InstancesWithFailedPatches' => '<p>The number of instances with patches from the patch baseline that failed to install.</p>', 'DescribePatchGroupStateResult$InstancesWithNotApplicablePatches' => '<p>The number of instances with patches that aren\'t applicable.</p>', 'DescribePatchGroupStateResult$InstancesWithUnreportedNotApplicablePatches' => '<p>The number of instances with <code>NotApplicable</code> patches beyond the supported limit, which are not reported by name to Systems Manager Inventory.</p>', 'OpsItemLimitExceededException$Limit' => NULL, 'ProgressCounters$TotalSteps' => '<p>The total number of steps run in all specified AWS Regions and accounts for the current Automation execution.</p>', 'ProgressCounters$SuccessSteps' => '<p>The total number of steps that successfully completed in all specified AWS Regions and accounts for the current Automation execution.</p>', 'ProgressCounters$FailedSteps' => '<p>The total number of steps that failed to run in all specified AWS Regions and accounts for the current Automation execution.</p>', 'ProgressCounters$CancelledSteps' => '<p>The total number of steps that the system cancelled in all specified AWS Regions and accounts for the current Automation execution.</p>', 'ProgressCounters$TimedOutSteps' => '<p>The total number of steps that timed out in all specified AWS Regions and accounts for the current Automation execution.</p>', 'StepExecution$MaxAttempts' => '<p>The maximum number of tries to run the action of the step. The default value is 1.</p>', ], ], 'InternalServerError' => [ 'base' => '<p>An error occurred on the server side.</p>', 'refs' => [], ], 'InvalidActivation' => [ 'base' => '<p>The activation is not valid. The activation might have been deleted, or the ActivationId and the ActivationCode do not match.</p>', 'refs' => [], ], 'InvalidActivationId' => [ 'base' => '<p>The activation ID is not valid. Verify the you entered the correct ActivationId or ActivationCode and try again.</p>', 'refs' => [], ], 'InvalidAggregatorException' => [ 'base' => '<p>The specified aggregator is not valid for inventory groups. Verify that the aggregator uses a valid inventory type such as <code>AWS:Application</code> or <code>AWS:InstanceInformation</code>.</p>', 'refs' => [], ], 'InvalidAllowedPatternException' => [ 'base' => '<p>The request does not meet the regular expression requirement.</p>', 'refs' => [], ], 'InvalidAssociation' => [ 'base' => '<p>The association is not valid or does not exist. </p>', 'refs' => [], ], 'InvalidAssociationVersion' => [ 'base' => '<p>The version you specified is not valid. Use ListAssociationVersions to view all versions of an association according to the association ID. Or, use the <code>$LATEST</code> parameter to view the latest version of the association.</p>', 'refs' => [], ], 'InvalidAutomationExecutionParametersException' => [ 'base' => '<p>The supplied parameters for invoking the specified Automation document are incorrect. For example, they may not match the set of parameters permitted for the specified Automation document.</p>', 'refs' => [], ], 'InvalidAutomationSignalException' => [ 'base' => '<p>The signal is not valid for the current Automation execution.</p>', 'refs' => [], ], 'InvalidAutomationStatusUpdateException' => [ 'base' => '<p>The specified update status operation is not valid.</p>', 'refs' => [], ], 'InvalidCommandId' => [ 'base' => NULL, 'refs' => [], ], 'InvalidDeleteInventoryParametersException' => [ 'base' => '<p>One or more of the parameters specified for the delete operation is not valid. Verify all parameters and try again.</p>', 'refs' => [], ], 'InvalidDeletionIdException' => [ 'base' => '<p>The ID specified for the delete operation does not exist or is not valid. Verify the ID and try again.</p>', 'refs' => [], ], 'InvalidDocument' => [ 'base' => '<p>The specified document does not exist.</p>', 'refs' => [], ], 'InvalidDocumentContent' => [ 'base' => '<p>The content for the document is not valid.</p>', 'refs' => [], ], 'InvalidDocumentOperation' => [ 'base' => '<p>You attempted to delete a document while it is still shared. You must stop sharing the document before you can delete it.</p>', 'refs' => [], ], 'InvalidDocumentSchemaVersion' => [ 'base' => '<p>The version of the document schema is not supported.</p>', 'refs' => [], ], 'InvalidDocumentType' => [ 'base' => '<p>The document type is not valid. Valid document types are described in the <code>DocumentType</code> property.</p>', 'refs' => [], ], 'InvalidDocumentVersion' => [ 'base' => '<p>The document version is not valid or does not exist.</p>', 'refs' => [], ], 'InvalidFilter' => [ 'base' => '<p>The filter name is not valid. Verify the you entered the correct name and try again.</p>', 'refs' => [], ], 'InvalidFilterKey' => [ 'base' => '<p>The specified key is not valid.</p>', 'refs' => [], ], 'InvalidFilterOption' => [ 'base' => '<p>The specified filter option is not valid. Valid options are Equals and BeginsWith. For Path filter, valid options are Recursive and OneLevel.</p>', 'refs' => [], ], 'InvalidFilterValue' => [ 'base' => '<p>The filter value is not valid. Verify the value and try again.</p>', 'refs' => [], ], 'InvalidInstanceId' => [ 'base' => '<p>The following problems can cause this exception:</p> <p>You do not have permission to access the instance.</p> <p>SSM Agent is not running. Verify that SSM Agent is running.</p> <p>SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.</p> <p>The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states are: Shutting-down and Terminated.</p>', 'refs' => [], ], 'InvalidInstanceInformationFilterValue' => [ 'base' => '<p>The specified filter value is not valid.</p>', 'refs' => [], ], 'InvalidInventoryGroupException' => [ 'base' => '<p>The specified inventory group is not valid.</p>', 'refs' => [], ], 'InvalidInventoryItemContextException' => [ 'base' => '<p>You specified invalid keys or values in the <code>Context</code> attribute for <code>InventoryItem</code>. Verify the keys and values, and try again.</p>', 'refs' => [], ], 'InvalidInventoryRequestException' => [ 'base' => '<p>The request is not valid.</p>', 'refs' => [], ], 'InvalidItemContentException' => [ 'base' => '<p>One or more content items is not valid.</p>', 'refs' => [], ], 'InvalidKeyId' => [ 'base' => '<p>The query key ID is not valid.</p>', 'refs' => [], ], 'InvalidNextToken' => [ 'base' => '<p>The specified token is not valid.</p>', 'refs' => [], ], 'InvalidNotificationConfig' => [ 'base' => '<p>One or more configuration items is not valid. Verify that a valid Amazon Resource Name (ARN) was provided for an Amazon SNS topic.</p>', 'refs' => [], ], 'InvalidOptionException' => [ 'base' => '<p>The delete inventory option specified is not valid. Verify the option and try again.</p>', 'refs' => [], ], 'InvalidOutputFolder' => [ 'base' => '<p>The S3 bucket does not exist.</p>', 'refs' => [], ], 'InvalidOutputLocation' => [ 'base' => '<p>The output location is not valid or does not exist.</p>', 'refs' => [], ], 'InvalidParameters' => [ 'base' => '<p>You must specify values for all required parameters in the Systems Manager document. You can only supply values to parameters defined in the Systems Manager document.</p>', 'refs' => [], ], 'InvalidPermissionType' => [ 'base' => '<p>The permission type is not supported. <i>Share</i> is the only supported permission type.</p>', 'refs' => [], ], 'InvalidPluginName' => [ 'base' => '<p>The plugin name is not valid.</p>', 'refs' => [], ], 'InvalidPolicyAttributeException' => [ 'base' => '<p>A policy attribute or its value is invalid. </p>', 'refs' => [], ], 'InvalidPolicyTypeException' => [ 'base' => '<p>The policy type is not supported. Parameter Store supports the following policy types: Expiration, ExpirationNotification, and NoChangeNotification.</p>', 'refs' => [], ], 'InvalidResourceId' => [ 'base' => '<p>The resource ID is not valid. Verify that you entered the correct ID and try again.</p>', 'refs' => [], ], 'InvalidResourceType' => [ 'base' => '<p>The resource type is not valid. For example, if you are attempting to tag an instance, the instance must be a registered, managed instance.</p>', 'refs' => [], ], 'InvalidResultAttributeException' => [ 'base' => '<p>The specified inventory item result attribute is not valid.</p>', 'refs' => [], ], 'InvalidRole' => [ 'base' => '<p>The role name can\'t contain invalid characters. Also verify that you specified an IAM role for notifications that includes the required trust policy. For information about configuring the IAM role for Run Command notifications, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/rc-sns-notifications.html">Configuring Amazon SNS Notifications for Run Command</a> in the <i>AWS Systems Manager User Guide</i>.</p>', 'refs' => [], ], 'InvalidSchedule' => [ 'base' => '<p>The schedule is invalid. Verify your cron or rate expression and try again.</p>', 'refs' => [], ], 'InvalidTarget' => [ 'base' => '<p>The target is not valid or does not exist. It might not be configured for Systems Manager or you might not have permission to perform the operation.</p>', 'refs' => [], ], 'InvalidTypeNameException' => [ 'base' => '<p>The parameter type name is not valid.</p>', 'refs' => [], ], 'InvalidUpdate' => [ 'base' => '<p>The update is not valid.</p>', 'refs' => [], ], 'InventoryAggregator' => [ 'base' => '<p>Specifies the inventory type and attribute for the aggregation execution.</p>', 'refs' => [ 'InventoryAggregatorList$member' => NULL, ], ], 'InventoryAggregatorExpression' => [ 'base' => NULL, 'refs' => [ 'InventoryAggregator$Expression' => '<p>The inventory type and attribute name for aggregation.</p>', ], ], 'InventoryAggregatorList' => [ 'base' => NULL, 'refs' => [ 'GetInventoryRequest$Aggregators' => '<p>Returns counts of inventory types based on one or more expressions. For example, if you aggregate by using an expression that uses the <code>AWS:InstanceInformation.PlatformType</code> type, you can see a count of how many Windows and Linux instances exist in your inventoried fleet.</p>', 'InventoryAggregator$Aggregators' => '<p>Nested aggregators to further refine aggregation for an inventory type.</p>', ], ], 'InventoryAttributeDataType' => [ 'base' => NULL, 'refs' => [ 'InventoryItemAttribute$DataType' => '<p>The data type of the inventory item attribute. </p>', ], ], 'InventoryDeletionId' => [ 'base' => NULL, 'refs' => [ 'DeleteInventoryResult$DeletionId' => '<p>Every <code>DeleteInventory</code> action is assigned a unique ID. This option returns a unique ID. You can use this ID to query the status of a delete operation. This option is useful for ensuring that a delete operation has completed before you begin other actions. </p>', 'DescribeInventoryDeletionsRequest$DeletionId' => '<p>Specify the delete inventory ID for which you want information. This ID was returned by the <code>DeleteInventory</code> action.</p>', 'InventoryDeletionStatusItem$DeletionId' => '<p>The deletion ID returned by the <code>DeleteInventory</code> action.</p>', ], ], 'InventoryDeletionLastStatusMessage' => [ 'base' => NULL, 'refs' => [ 'InventoryDeletionStatusItem$LastStatusMessage' => '<p>Information about the status.</p>', ], ], 'InventoryDeletionLastStatusUpdateTime' => [ 'base' => NULL, 'refs' => [ 'InventoryDeletionStatusItem$LastStatusUpdateTime' => '<p>The UTC timestamp of when the last status report.</p>', ], ], 'InventoryDeletionStartTime' => [ 'base' => NULL, 'refs' => [ 'InventoryDeletionStatusItem$DeletionStartTime' => '<p>The UTC timestamp when the delete operation started.</p>', ], ], 'InventoryDeletionStatus' => [ 'base' => NULL, 'refs' => [ 'InventoryDeletionStatusItem$LastStatus' => '<p>The status of the operation. Possible values are InProgress and Complete.</p>', ], ], 'InventoryDeletionStatusItem' => [ 'base' => '<p>Status information returned by the <code>DeleteInventory</code> action.</p>', 'refs' => [ 'InventoryDeletionsList$member' => NULL, ], ], 'InventoryDeletionSummary' => [ 'base' => '<p>Information about the delete operation.</p>', 'refs' => [ 'DeleteInventoryResult$DeletionSummary' => '<p>A summary of the delete operation. For more information about this summary, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-custom.html#sysman-inventory-delete-summary">Deleting custom inventory</a> in the <i>AWS Systems Manager User Guide</i>.</p>', 'InventoryDeletionStatusItem$DeletionSummary' => '<p>Information about the delete operation. For more information about this summary, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-custom.html#sysman-inventory-delete">Understanding the delete inventory summary</a> in the <i>AWS Systems Manager User Guide</i>.</p>', ], ], 'InventoryDeletionSummaryItem' => [ 'base' => '<p>Either a count, remaining count, or a version number in a delete inventory summary.</p>', 'refs' => [ 'InventoryDeletionSummaryItems$member' => NULL, ], ], 'InventoryDeletionSummaryItems' => [ 'base' => NULL, 'refs' => [ 'InventoryDeletionSummary$SummaryItems' => '<p>A list of counts and versions for deleted items.</p>', ], ], 'InventoryDeletionsList' => [ 'base' => NULL, 'refs' => [ 'DescribeInventoryDeletionsResult$InventoryDeletions' => '<p>A list of status items for deleted inventory.</p>', ], ], 'InventoryFilter' => [ 'base' => '<p>One or more filters. Use a filter to return a more specific list of results.</p>', 'refs' => [ 'InventoryFilterList$member' => NULL, ], ], 'InventoryFilterKey' => [ 'base' => NULL, 'refs' => [ 'InventoryFilter$Key' => '<p>The name of the filter key.</p>', ], ], 'InventoryFilterList' => [ 'base' => NULL, 'refs' => [ 'GetInventoryRequest$Filters' => '<p>One or more filters. Use a filter to return a more specific list of results.</p>', 'InventoryGroup$Filters' => '<p>Filters define the criteria for the group. The <code>matchingCount</code> field displays the number of resources that match the criteria. The <code>notMatchingCount</code> field displays the number of resources that don\'t match the criteria. </p>', 'ListInventoryEntriesRequest$Filters' => '<p>One or more filters. Use a filter to return a more specific list of results.</p>', ], ], 'InventoryFilterValue' => [ 'base' => NULL, 'refs' => [ 'InventoryFilterValueList$member' => NULL, ], ], 'InventoryFilterValueList' => [ 'base' => NULL, 'refs' => [ 'InventoryFilter$Values' => '<p>Inventory filter values. Example: inventory filter where instance IDs are specified as values Key=AWS:InstanceInformation.InstanceId,Values= i-a12b3c4d5e6g, i-1a2b3c4d5e6,Type=Equal </p>', ], ], 'InventoryGroup' => [ 'base' => '<p>A user-defined set of one or more filters on which to aggregate inventory data. Groups return a count of resources that match and don\'t match the specified criteria.</p>', 'refs' => [ 'InventoryGroupList$member' => NULL, ], ], 'InventoryGroupList' => [ 'base' => NULL, 'refs' => [ 'InventoryAggregator$Groups' => '<p>A user-defined set of one or more filters on which to aggregate inventory data. Groups return a count of resources that match and don\'t match the specified criteria.</p>', ], ], 'InventoryGroupName' => [ 'base' => NULL, 'refs' => [ 'InventoryGroup$Name' => '<p>The name of the group.</p>', ], ], 'InventoryItem' => [ 'base' => '<p>Information collected from managed instances based on your inventory policy document</p>', 'refs' => [ 'InventoryItemList$member' => NULL, ], ], 'InventoryItemAttribute' => [ 'base' => '<p>Attributes are the entries within the inventory item content. It contains name and value.</p>', 'refs' => [ 'InventoryItemAttributeList$member' => NULL, ], ], 'InventoryItemAttributeList' => [ 'base' => NULL, 'refs' => [ 'InventoryItemSchema$Attributes' => '<p>The schema attributes for inventory. This contains data type and attribute name.</p>', ], ], 'InventoryItemAttributeName' => [ 'base' => NULL, 'refs' => [ 'InventoryItemAttribute$Name' => '<p>Name of the inventory item attribute.</p>', ], ], 'InventoryItemCaptureTime' => [ 'base' => NULL, 'refs' => [ 'InventoryItem$CaptureTime' => '<p>The time the inventory information was collected.</p>', 'InventoryResultItem$CaptureTime' => '<p>The time inventory item data was captured.</p>', 'ListInventoryEntriesResult$CaptureTime' => '<p>The time that inventory information was collected for the instance(s).</p>', ], ], 'InventoryItemContentContext' => [ 'base' => NULL, 'refs' => [ 'InventoryItem$Context' => '<p>A map of associated properties for a specified inventory type. For example, with this attribute, you can specify the <code>ExecutionId</code>, <code>ExecutionType</code>, <code>ComplianceType</code> properties of the <code>AWS:ComplianceItem</code> type.</p>', ], ], 'InventoryItemContentHash' => [ 'base' => NULL, 'refs' => [ 'InventoryItem$ContentHash' => '<p>MD5 hash of the inventory item type contents. The content hash is used to determine whether to update inventory information. The PutInventory API does not update the inventory item type contents if the MD5 hash has not changed since last update. </p>', 'InventoryResultItem$ContentHash' => '<p>MD5 hash of the inventory item type contents. The content hash is used to determine whether to update inventory information. The PutInventory API does not update the inventory item type contents if the MD5 hash has not changed since last update. </p>', ], ], 'InventoryItemEntry' => [ 'base' => NULL, 'refs' => [ 'InventoryItemEntryList$member' => NULL, ], ], 'InventoryItemEntryList' => [ 'base' => NULL, 'refs' => [ 'InventoryItem$Content' => '<p>The inventory data of the inventory type.</p>', 'InventoryResultItem$Content' => '<p>Contains all the inventory data of the item type. Results include attribute names and values. </p>', 'ListInventoryEntriesResult$Entries' => '<p>A list of inventory items on the instance(s).</p>', ], ], 'InventoryItemList' => [ 'base' => NULL, 'refs' => [ 'PutInventoryRequest$Items' => '<p>The inventory items that you want to add or update on instances.</p>', ], ], 'InventoryItemSchema' => [ 'base' => '<p>The inventory item schema definition. Users can use this to compose inventory query filters.</p>', 'refs' => [ 'InventoryItemSchemaResultList$member' => NULL, ], ], 'InventoryItemSchemaResultList' => [ 'base' => NULL, 'refs' => [ 'GetInventorySchemaResult$Schemas' => '<p>Inventory schemas returned by the request.</p>', ], ], 'InventoryItemSchemaVersion' => [ 'base' => NULL, 'refs' => [ 'InventoryDeletionSummaryItem$Version' => '<p>The inventory type version.</p>', 'InventoryItem$SchemaVersion' => '<p>The schema version for the inventory item.</p>', 'InventoryItemSchema$Version' => '<p>The schema version for the inventory item.</p>', 'InventoryResultItem$SchemaVersion' => '<p>The schema version for the inventory result item/</p>', 'ListInventoryEntriesResult$SchemaVersion' => '<p>The inventory schema version used by the instance(s).</p>', ], ], 'InventoryItemTypeName' => [ 'base' => NULL, 'refs' => [ 'DeleteInventoryRequest$TypeName' => '<p>The name of the custom inventory type for which you want to delete either all previously collected data, or the inventory type itself. </p>', 'DeleteInventoryResult$TypeName' => '<p>The name of the inventory data type specified in the request.</p>', 'InvalidItemContentException$TypeName' => NULL, 'InventoryDeletionStatusItem$TypeName' => '<p>The name of the inventory data type.</p>', 'InventoryItem$TypeName' => '<p>The name of the inventory type. Default inventory item type names start with AWS. Custom inventory type names will start with Custom. Default inventory item types include the following: AWS:AWSComponent, AWS:Application, AWS:InstanceInformation, AWS:Network, and AWS:WindowsUpdate.</p>', 'InventoryItemSchema$TypeName' => '<p>The name of the inventory type. Default inventory item type names start with AWS. Custom inventory type names will start with Custom. Default inventory item types include the following: AWS:AWSComponent, AWS:Application, AWS:InstanceInformation, AWS:Network, and AWS:WindowsUpdate.</p>', 'InventoryResultItem$TypeName' => '<p>The name of the inventory result item type.</p>', 'ItemContentMismatchException$TypeName' => NULL, 'ItemSizeLimitExceededException$TypeName' => NULL, 'ListInventoryEntriesRequest$TypeName' => '<p>The type of inventory item for which you want information.</p>', 'ListInventoryEntriesResult$TypeName' => '<p>The type of inventory item returned by the request.</p>', 'ResultAttribute$TypeName' => '<p>Name of the inventory item type. Valid value: AWS:InstanceInformation. Default Value: AWS:InstanceInformation.</p>', 'UnsupportedInventoryItemContextException$TypeName' => NULL, ], ], 'InventoryItemTypeNameFilter' => [ 'base' => NULL, 'refs' => [ 'GetInventorySchemaRequest$TypeName' => '<p>The type of inventory item to return.</p>', ], ], 'InventoryQueryOperatorType' => [ 'base' => NULL, 'refs' => [ 'InventoryFilter$Type' => '<p>The type of filter.</p> <note> <p>The <code>Exists</code> filter must be used with aggregators. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-aggregate.html">Aggregating inventory data</a> in the <i>AWS Systems Manager User Guide</i>.</p> </note>', ], ], 'InventoryResultEntity' => [ 'base' => '<p>Inventory query results.</p>', 'refs' => [ 'InventoryResultEntityList$member' => NULL, ], ], 'InventoryResultEntityId' => [ 'base' => NULL, 'refs' => [ 'InventoryResultEntity$Id' => '<p>ID of the inventory result entity. For example, for managed instance inventory the result will be the managed instance ID. For EC2 instance inventory, the result will be the instance ID. </p>', ], ], 'InventoryResultEntityList' => [ 'base' => NULL, 'refs' => [ 'GetInventoryResult$Entities' => '<p>Collection of inventory entities such as a collection of instance inventory. </p>', ], ], 'InventoryResultItem' => [ 'base' => '<p>The inventory result item.</p>', 'refs' => [ 'InventoryResultItemMap$value' => NULL, ], ], 'InventoryResultItemKey' => [ 'base' => NULL, 'refs' => [ 'InventoryResultItemMap$key' => NULL, ], ], 'InventoryResultItemMap' => [ 'base' => NULL, 'refs' => [ 'InventoryResultEntity$Data' => '<p>The data section in the inventory result entity JSON.</p>', ], ], 'InventorySchemaDeleteOption' => [ 'base' => NULL, 'refs' => [ 'DeleteInventoryRequest$SchemaDeleteOption' => '<p>Use the <code>SchemaDeleteOption</code> to delete a custom inventory type (schema). If you don\'t choose this option, the system only deletes existing inventory data associated with the custom inventory type. Choose one of the following options:</p> <p>DisableSchema: If you choose this option, the system ignores all inventory data for the specified version, and any earlier versions. To enable this schema again, you must call the <code>PutInventory</code> action for a version greater than the disabled version.</p> <p>DeleteSchema: This option deletes the specified custom type from the Inventory service. You can recreate the schema later, if you want.</p>', ], ], 'InventoryTypeDisplayName' => [ 'base' => NULL, 'refs' => [ 'InventoryItemSchema$DisplayName' => '<p>The alias name of the inventory type. The alias name is used for display purposes.</p>', ], ], 'InvocationDoesNotExist' => [ 'base' => '<p>The command ID and instance ID you specified did not match any invocations. Verify the command ID and the instance ID and try again. </p>', 'refs' => [], ], 'InvocationTraceOutput' => [ 'base' => NULL, 'refs' => [ 'CommandInvocation$TraceOutput' => '<p> Gets the trace output sent by the agent. </p>', ], ], 'IsSubTypeSchema' => [ 'base' => NULL, 'refs' => [ 'GetInventorySchemaRequest$SubType' => '<p>Returns the sub-type schema for a specified inventory type.</p>', ], ], 'ItemContentMismatchException' => [ 'base' => '<p>The inventory item has invalid content. </p>', 'refs' => [], ], 'ItemSizeLimitExceededException' => [ 'base' => '<p>The inventory item size has exceeded the size limit.</p>', 'refs' => [], ], 'KeyList' => [ 'base' => NULL, 'refs' => [ 'RemoveTagsFromResourceRequest$TagKeys' => '<p>Tag keys that you want to remove from the specified resource.</p>', ], ], 'LabelParameterVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'LabelParameterVersionResult' => [ 'base' => NULL, 'refs' => [], ], 'LastResourceDataSyncMessage' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncItem$LastSyncStatusMessage' => '<p>The status message details reported by the last sync.</p>', ], ], 'LastResourceDataSyncStatus' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncItem$LastStatus' => '<p>The status reported by the last sync.</p>', ], ], 'LastResourceDataSyncTime' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncItem$LastSyncTime' => '<p>The last time the configuration attempted to sync (UTC).</p>', ], ], 'LastSuccessfulResourceDataSyncTime' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncItem$LastSuccessfulSyncTime' => '<p>The last time the sync operations returned a status of <code>SUCCESSFUL</code> (UTC).</p>', ], ], 'ListAssociationVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssociationVersionsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssociationsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListCommandInvocationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCommandInvocationsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListCommandsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCommandsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListComplianceItemsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListComplianceItemsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListComplianceSummariesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListComplianceSummariesResult' => [ 'base' => NULL, 'refs' => [], ], 'ListDocumentVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDocumentVersionsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListDocumentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDocumentsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListInventoryEntriesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInventoryEntriesResult' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceComplianceSummariesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceComplianceSummariesResult' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceDataSyncRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceDataSyncResult' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'LoggingInfo' => [ 'base' => '<p>Information about an S3 bucket to write instance-level logs to.</p> <note> <p> <code>LoggingInfo</code> has been deprecated. To specify an S3 bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> </note>', 'refs' => [ 'GetMaintenanceWindowTaskResult$LoggingInfo' => '<p>The location in Amazon S3 where the task results are logged.</p> <note> <p> <code>LoggingInfo</code> has been deprecated. To specify an S3 bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> </note>', 'MaintenanceWindowTask$LoggingInfo' => '<p>Information about an S3 bucket to write task-level logs to.</p> <note> <p> <code>LoggingInfo</code> has been deprecated. To specify an S3 bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> </note>', 'RegisterTaskWithMaintenanceWindowRequest$LoggingInfo' => '<p>A structure containing information about an S3 bucket to write instance-level logs to. </p> <note> <p> <code>LoggingInfo</code> has been deprecated. To specify an S3 bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> </note>', 'UpdateMaintenanceWindowTaskRequest$LoggingInfo' => '<p>The new logging location in Amazon S3 to specify.</p> <note> <p> <code>LoggingInfo</code> has been deprecated. To specify an S3 bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> </note>', 'UpdateMaintenanceWindowTaskResult$LoggingInfo' => '<p>The updated logging information in Amazon S3.</p> <note> <p> <code>LoggingInfo</code> has been deprecated. To specify an S3 bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> </note>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'StepExecution$TimeoutSeconds' => '<p>The timeout seconds of the step.</p>', ], ], 'MaintenanceWindowAllowUnassociatedTargets' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowRequest$AllowUnassociatedTargets' => '<p>Enables a maintenance window task to run on managed instances, even if you have not registered those instances as targets. If enabled, then you must specify the unregistered instances (by instance ID) when you register a task with the maintenance window.</p> <p>If you don\'t enable this option, then you must specify previously-registered targets when you register a task with the maintenance window.</p>', 'GetMaintenanceWindowResult$AllowUnassociatedTargets' => '<p>Whether targets must be registered with the maintenance window before tasks can be defined for those targets.</p>', 'UpdateMaintenanceWindowRequest$AllowUnassociatedTargets' => '<p>Whether targets must be registered with the maintenance window before tasks can be defined for those targets.</p>', 'UpdateMaintenanceWindowResult$AllowUnassociatedTargets' => '<p>Whether targets must be registered with the maintenance window before tasks can be defined for those targets.</p>', ], ], 'MaintenanceWindowAutomationParameters' => [ 'base' => '<p>The parameters for an AUTOMATION task type.</p>', 'refs' => [ 'MaintenanceWindowTaskInvocationParameters$Automation' => '<p>The parameters for an AUTOMATION task type.</p>', ], ], 'MaintenanceWindowCutoff' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowRequest$Cutoff' => '<p>The number of hours before the end of the maintenance window that Systems Manager stops scheduling new tasks for execution.</p>', 'GetMaintenanceWindowResult$Cutoff' => '<p>The number of hours before the end of the maintenance window that Systems Manager stops scheduling new tasks for execution.</p>', 'MaintenanceWindowIdentity$Cutoff' => '<p>The number of hours before the end of the maintenance window that Systems Manager stops scheduling new tasks for execution.</p>', 'UpdateMaintenanceWindowRequest$Cutoff' => '<p>The number of hours before the end of the maintenance window that Systems Manager stops scheduling new tasks for execution.</p>', 'UpdateMaintenanceWindowResult$Cutoff' => '<p>The number of hours before the end of the maintenance window that Systems Manager stops scheduling new tasks for execution.</p>', ], ], 'MaintenanceWindowDescription' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowRequest$Description' => '<p>An optional description for the maintenance window. We recommend specifying a description to help you organize your maintenance windows. </p>', 'GetMaintenanceWindowResult$Description' => '<p>The description of the maintenance window.</p>', 'GetMaintenanceWindowTaskResult$Description' => '<p>The retrieved task description.</p>', 'MaintenanceWindowIdentity$Description' => '<p>A description of the maintenance window.</p>', 'MaintenanceWindowTarget$Description' => '<p>A description for the target.</p>', 'MaintenanceWindowTask$Description' => '<p>A description of the task.</p>', 'RegisterTargetWithMaintenanceWindowRequest$Description' => '<p>An optional description for the target.</p>', 'RegisterTaskWithMaintenanceWindowRequest$Description' => '<p>An optional description for the task.</p>', 'UpdateMaintenanceWindowRequest$Description' => '<p>An optional description for the update request.</p>', 'UpdateMaintenanceWindowResult$Description' => '<p>An optional description of the update.</p>', 'UpdateMaintenanceWindowTargetRequest$Description' => '<p>An optional description for the update.</p>', 'UpdateMaintenanceWindowTargetResult$Description' => '<p>The updated description.</p>', 'UpdateMaintenanceWindowTaskRequest$Description' => '<p>The new task description to specify.</p>', 'UpdateMaintenanceWindowTaskResult$Description' => '<p>The updated task description.</p>', ], ], 'MaintenanceWindowDurationHours' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowRequest$Duration' => '<p>The duration of the maintenance window in hours.</p>', 'GetMaintenanceWindowResult$Duration' => '<p>The duration of the maintenance window in hours.</p>', 'MaintenanceWindowIdentity$Duration' => '<p>The duration of the maintenance window in hours.</p>', 'UpdateMaintenanceWindowRequest$Duration' => '<p>The duration of the maintenance window in hours.</p>', 'UpdateMaintenanceWindowResult$Duration' => '<p>The duration of the maintenance window in hours.</p>', ], ], 'MaintenanceWindowEnabled' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowResult$Enabled' => '<p>Indicates whether the maintenance window is enabled.</p>', 'MaintenanceWindowIdentity$Enabled' => '<p>Indicates whether the maintenance window is enabled.</p>', 'UpdateMaintenanceWindowRequest$Enabled' => '<p>Whether the maintenance window is enabled.</p>', 'UpdateMaintenanceWindowResult$Enabled' => '<p>Whether the maintenance window is enabled.</p>', ], ], 'MaintenanceWindowExecution' => [ 'base' => '<p>Describes the information about an execution of a maintenance window. </p>', 'refs' => [ 'MaintenanceWindowExecutionList$member' => NULL, ], ], 'MaintenanceWindowExecutionId' => [ 'base' => NULL, 'refs' => [ 'CancelMaintenanceWindowExecutionRequest$WindowExecutionId' => '<p>The ID of the maintenance window execution to stop.</p>', 'CancelMaintenanceWindowExecutionResult$WindowExecutionId' => '<p>The ID of the maintenance window execution that has been stopped.</p>', 'DescribeMaintenanceWindowExecutionTaskInvocationsRequest$WindowExecutionId' => '<p>The ID of the maintenance window execution the task is part of.</p>', 'DescribeMaintenanceWindowExecutionTasksRequest$WindowExecutionId' => '<p>The ID of the maintenance window execution whose task executions should be retrieved.</p>', 'GetMaintenanceWindowExecutionRequest$WindowExecutionId' => '<p>The ID of the maintenance window execution that includes the task.</p>', 'GetMaintenanceWindowExecutionResult$WindowExecutionId' => '<p>The ID of the maintenance window execution.</p>', 'GetMaintenanceWindowExecutionTaskInvocationRequest$WindowExecutionId' => '<p>The ID of the maintenance window execution for which the task is a part.</p>', 'GetMaintenanceWindowExecutionTaskInvocationResult$WindowExecutionId' => '<p>The maintenance window execution ID.</p>', 'GetMaintenanceWindowExecutionTaskRequest$WindowExecutionId' => '<p>The ID of the maintenance window execution that includes the task.</p>', 'GetMaintenanceWindowExecutionTaskResult$WindowExecutionId' => '<p>The ID of the maintenance window execution that includes the task.</p>', 'MaintenanceWindowExecution$WindowExecutionId' => '<p>The ID of the maintenance window execution.</p>', 'MaintenanceWindowExecutionTaskIdentity$WindowExecutionId' => '<p>The ID of the maintenance window execution that ran the task.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$WindowExecutionId' => '<p>The ID of the maintenance window execution that ran the task.</p>', ], ], 'MaintenanceWindowExecutionList' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowExecutionsResult$WindowExecutions' => '<p>Information about the maintenance window executions.</p>', ], ], 'MaintenanceWindowExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionResult$Status' => '<p>The status of the maintenance window execution.</p>', 'GetMaintenanceWindowExecutionTaskInvocationResult$Status' => '<p>The task status for an invocation.</p>', 'GetMaintenanceWindowExecutionTaskResult$Status' => '<p>The status of the task.</p>', 'MaintenanceWindowExecution$Status' => '<p>The status of the execution.</p>', 'MaintenanceWindowExecutionTaskIdentity$Status' => '<p>The status of the task execution.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$Status' => '<p>The status of the task invocation.</p>', ], ], 'MaintenanceWindowExecutionStatusDetails' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionResult$StatusDetails' => '<p>The details explaining the Status. Only available for certain status values.</p>', 'GetMaintenanceWindowExecutionTaskInvocationResult$StatusDetails' => '<p>The details explaining the status. Details are only available for certain status values.</p>', 'GetMaintenanceWindowExecutionTaskResult$StatusDetails' => '<p>The details explaining the Status. Only available for certain status values.</p>', 'MaintenanceWindowExecution$StatusDetails' => '<p>The details explaining the Status. Only available for certain status values.</p>', 'MaintenanceWindowExecutionTaskIdentity$StatusDetails' => '<p>The details explaining the status of the task execution. Only available for certain status values.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$StatusDetails' => '<p>The details explaining the status of the task invocation. Only available for certain Status values. </p>', ], ], 'MaintenanceWindowExecutionTaskExecutionId' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionTaskInvocationResult$ExecutionId' => '<p>The execution ID.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$ExecutionId' => '<p>The ID of the action performed in the service that actually handled the task invocation. If the task type is RUN_COMMAND, this value is the command ID.</p>', ], ], 'MaintenanceWindowExecutionTaskId' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowExecutionTaskInvocationsRequest$TaskId' => '<p>The ID of the specific task in the maintenance window task that should be retrieved.</p>', 'GetMaintenanceWindowExecutionTaskInvocationRequest$TaskId' => '<p>The ID of the specific task in the maintenance window task that should be retrieved. </p>', 'GetMaintenanceWindowExecutionTaskInvocationResult$TaskExecutionId' => '<p>The task execution ID.</p>', 'GetMaintenanceWindowExecutionTaskRequest$TaskId' => '<p>The ID of the specific task execution in the maintenance window task that should be retrieved.</p>', 'GetMaintenanceWindowExecutionTaskResult$TaskExecutionId' => '<p>The ID of the specific task execution in the maintenance window task that was retrieved.</p>', 'MaintenanceWindowExecutionTaskIdList$member' => NULL, 'MaintenanceWindowExecutionTaskIdentity$TaskExecutionId' => '<p>The ID of the specific task execution in the maintenance window execution.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$TaskExecutionId' => '<p>The ID of the specific task execution in the maintenance window execution.</p>', ], ], 'MaintenanceWindowExecutionTaskIdList' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionResult$TaskIds' => '<p>The ID of the task executions from the maintenance window execution.</p>', ], ], 'MaintenanceWindowExecutionTaskIdentity' => [ 'base' => '<p>Information about a task execution performed as part of a maintenance window execution.</p>', 'refs' => [ 'MaintenanceWindowExecutionTaskIdentityList$member' => NULL, ], ], 'MaintenanceWindowExecutionTaskIdentityList' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowExecutionTasksResult$WindowExecutionTaskIdentities' => '<p>Information about the task executions.</p>', ], ], 'MaintenanceWindowExecutionTaskInvocationId' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionTaskInvocationRequest$InvocationId' => '<p>The invocation ID to retrieve.</p>', 'GetMaintenanceWindowExecutionTaskInvocationResult$InvocationId' => '<p>The invocation ID.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$InvocationId' => '<p>The ID of the task invocation.</p>', ], ], 'MaintenanceWindowExecutionTaskInvocationIdentity' => [ 'base' => '<p>Describes the information about a task invocation for a particular target as part of a task execution performed as part of a maintenance window execution.</p>', 'refs' => [ 'MaintenanceWindowExecutionTaskInvocationIdentityList$member' => NULL, ], ], 'MaintenanceWindowExecutionTaskInvocationIdentityList' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowExecutionTaskInvocationsResult$WindowExecutionTaskInvocationIdentities' => '<p>Information about the task invocation results per invocation.</p>', ], ], 'MaintenanceWindowExecutionTaskInvocationParameters' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionTaskInvocationResult$Parameters' => '<p>The parameters used at the time that the task ran.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$Parameters' => '<p>The parameters that were provided for the invocation when it was run.</p>', ], ], 'MaintenanceWindowFilter' => [ 'base' => '<p>Filter used in the request. Supported filter keys are Name and Enabled.</p>', 'refs' => [ 'MaintenanceWindowFilterList$member' => NULL, ], ], 'MaintenanceWindowFilterKey' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowFilter$Key' => '<p>The name of the filter.</p>', ], ], 'MaintenanceWindowFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowExecutionTaskInvocationsRequest$Filters' => '<p>Optional filters used to scope down the returned task invocations. The supported filter key is STATUS with the corresponding values PENDING, IN_PROGRESS, SUCCESS, FAILED, TIMED_OUT, CANCELLING, and CANCELLED.</p>', 'DescribeMaintenanceWindowExecutionTasksRequest$Filters' => '<p>Optional filters used to scope down the returned tasks. The supported filter key is STATUS with the corresponding values PENDING, IN_PROGRESS, SUCCESS, FAILED, TIMED_OUT, CANCELLING, and CANCELLED. </p>', 'DescribeMaintenanceWindowExecutionsRequest$Filters' => '<p>Each entry in the array is a structure containing:</p> <p>Key (string, between 1 and 128 characters)</p> <p>Values (array of strings, each string is between 1 and 256 characters)</p> <p>The supported Keys are ExecutedBefore and ExecutedAfter with the value being a date/time string such as 2016-11-04T05:00:00Z.</p>', 'DescribeMaintenanceWindowTargetsRequest$Filters' => '<p>Optional filters that can be used to narrow down the scope of the returned window targets. The supported filter keys are Type, WindowTargetId and OwnerInformation.</p>', 'DescribeMaintenanceWindowTasksRequest$Filters' => '<p>Optional filters used to narrow down the scope of the returned tasks. The supported filter keys are WindowTaskId, TaskArn, Priority, and TaskType.</p>', 'DescribeMaintenanceWindowsRequest$Filters' => '<p>Optional filters used to narrow down the scope of the returned maintenance windows. Supported filter keys are <b>Name</b> and <b>Enabled</b>.</p>', ], ], 'MaintenanceWindowFilterValue' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowFilterValues$member' => NULL, ], ], 'MaintenanceWindowFilterValues' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowFilter$Values' => '<p>The filter values.</p>', ], ], 'MaintenanceWindowId' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowResult$WindowId' => '<p>The ID of the created maintenance window.</p>', 'DeleteMaintenanceWindowRequest$WindowId' => '<p>The ID of the maintenance window to delete.</p>', 'DeleteMaintenanceWindowResult$WindowId' => '<p>The ID of the deleted maintenance window.</p>', 'DeregisterTargetFromMaintenanceWindowRequest$WindowId' => '<p>The ID of the maintenance window the target should be removed from.</p>', 'DeregisterTargetFromMaintenanceWindowResult$WindowId' => '<p>The ID of the maintenance window the target was removed from.</p>', 'DeregisterTaskFromMaintenanceWindowRequest$WindowId' => '<p>The ID of the maintenance window the task should be removed from.</p>', 'DeregisterTaskFromMaintenanceWindowResult$WindowId' => '<p>The ID of the maintenance window the task was removed from.</p>', 'DescribeMaintenanceWindowExecutionsRequest$WindowId' => '<p>The ID of the maintenance window whose executions should be retrieved.</p>', 'DescribeMaintenanceWindowScheduleRequest$WindowId' => '<p>The ID of the maintenance window to retrieve information about.</p>', 'DescribeMaintenanceWindowTargetsRequest$WindowId' => '<p>The ID of the maintenance window whose targets should be retrieved.</p>', 'DescribeMaintenanceWindowTasksRequest$WindowId' => '<p>The ID of the maintenance window whose tasks should be retrieved.</p>', 'GetMaintenanceWindowRequest$WindowId' => '<p>The ID of the maintenance window for which you want to retrieve information.</p>', 'GetMaintenanceWindowResult$WindowId' => '<p>The ID of the created maintenance window.</p>', 'GetMaintenanceWindowTaskRequest$WindowId' => '<p>The maintenance window ID that includes the task to retrieve.</p>', 'GetMaintenanceWindowTaskResult$WindowId' => '<p>The retrieved maintenance window ID.</p>', 'MaintenanceWindowExecution$WindowId' => '<p>The ID of the maintenance window.</p>', 'MaintenanceWindowIdentity$WindowId' => '<p>The ID of the maintenance window.</p>', 'MaintenanceWindowIdentityForTarget$WindowId' => '<p>The ID of the maintenance window.</p>', 'MaintenanceWindowTarget$WindowId' => '<p>The ID of the maintenance window to register the target with.</p>', 'MaintenanceWindowTask$WindowId' => '<p>The ID of the maintenance window where the task is registered.</p>', 'RegisterTargetWithMaintenanceWindowRequest$WindowId' => '<p>The ID of the maintenance window the target should be registered with.</p>', 'RegisterTaskWithMaintenanceWindowRequest$WindowId' => '<p>The ID of the maintenance window the task should be added to.</p>', 'ScheduledWindowExecution$WindowId' => '<p>The ID of the maintenance window to be run.</p>', 'UpdateMaintenanceWindowRequest$WindowId' => '<p>The ID of the maintenance window to update.</p>', 'UpdateMaintenanceWindowResult$WindowId' => '<p>The ID of the created maintenance window.</p>', 'UpdateMaintenanceWindowTargetRequest$WindowId' => '<p>The maintenance window ID with which to modify the target.</p>', 'UpdateMaintenanceWindowTargetResult$WindowId' => '<p>The maintenance window ID specified in the update request.</p>', 'UpdateMaintenanceWindowTaskRequest$WindowId' => '<p>The maintenance window ID that contains the task to modify.</p>', 'UpdateMaintenanceWindowTaskResult$WindowId' => '<p>The ID of the maintenance window that was updated.</p>', ], ], 'MaintenanceWindowIdentity' => [ 'base' => '<p>Information about the maintenance window.</p>', 'refs' => [ 'MaintenanceWindowIdentityList$member' => NULL, ], ], 'MaintenanceWindowIdentityForTarget' => [ 'base' => '<p>The maintenance window to which the specified target belongs.</p>', 'refs' => [ 'MaintenanceWindowsForTargetList$member' => NULL, ], ], 'MaintenanceWindowIdentityList' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowsResult$WindowIdentities' => '<p>Information about the maintenance windows.</p>', ], ], 'MaintenanceWindowLambdaClientContext' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowLambdaParameters$ClientContext' => '<p>Pass client-specific information to the Lambda function that you are invoking. You can then process the client information in your Lambda function as you choose through the context variable.</p>', ], ], 'MaintenanceWindowLambdaParameters' => [ 'base' => '<p>The parameters for a LAMBDA task type.</p> <p>For information about specifying and updating task parameters, see <a>RegisterTaskWithMaintenanceWindow</a> and <a>UpdateMaintenanceWindowTask</a>.</p> <note> <p> <code>LoggingInfo</code> has been deprecated. To specify an S3 bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> <p>For Lambda tasks, Systems Manager ignores any values specified for TaskParameters and LoggingInfo.</p> </note>', 'refs' => [ 'MaintenanceWindowTaskInvocationParameters$Lambda' => '<p>The parameters for a LAMBDA task type.</p>', ], ], 'MaintenanceWindowLambdaPayload' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowLambdaParameters$Payload' => '<p>JSON to provide to your Lambda function as input.</p>', ], ], 'MaintenanceWindowLambdaQualifier' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowLambdaParameters$Qualifier' => '<p>(Optional) Specify a Lambda function version or alias name. If you specify a function version, the action uses the qualified function ARN to invoke a specific Lambda function. If you specify an alias name, the action uses the alias ARN to invoke the Lambda function version to which the alias points.</p>', ], ], 'MaintenanceWindowMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowExecutionTaskInvocationsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeMaintenanceWindowExecutionTasksRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeMaintenanceWindowExecutionsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeMaintenanceWindowTargetsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeMaintenanceWindowTasksRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeMaintenanceWindowsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'MaintenanceWindowName' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowRequest$Name' => '<p>The name of the maintenance window.</p>', 'GetMaintenanceWindowResult$Name' => '<p>The name of the maintenance window.</p>', 'GetMaintenanceWindowTaskResult$Name' => '<p>The retrieved task name.</p>', 'MaintenanceWindowIdentity$Name' => '<p>The name of the maintenance window.</p>', 'MaintenanceWindowIdentityForTarget$Name' => '<p>The name of the maintenance window.</p>', 'MaintenanceWindowTarget$Name' => '<p>The name for the maintenance window target.</p>', 'MaintenanceWindowTask$Name' => '<p>The task name.</p>', 'RegisterTargetWithMaintenanceWindowRequest$Name' => '<p>An optional name for the target.</p>', 'RegisterTaskWithMaintenanceWindowRequest$Name' => '<p>An optional name for the task.</p>', 'ScheduledWindowExecution$Name' => '<p>The name of the maintenance window to be run.</p>', 'UpdateMaintenanceWindowRequest$Name' => '<p>The name of the maintenance window.</p>', 'UpdateMaintenanceWindowResult$Name' => '<p>The name of the maintenance window.</p>', 'UpdateMaintenanceWindowTargetRequest$Name' => '<p>A name for the update.</p>', 'UpdateMaintenanceWindowTargetResult$Name' => '<p>The updated name.</p>', 'UpdateMaintenanceWindowTaskRequest$Name' => '<p>The new task name to specify.</p>', 'UpdateMaintenanceWindowTaskResult$Name' => '<p>The updated task name.</p>', ], ], 'MaintenanceWindowOffset' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowRequest$ScheduleOffset' => '<p>The number of days to wait after the date and time specified by a CRON expression before running the maintenance window.</p> <p>For example, the following cron expression schedules a maintenance window to run on the third Tuesday of every month at 11:30 PM.</p> <p> <code>cron(0 30 23 ? * TUE#3 *)</code> </p> <p>If the schedule offset is <code>2</code>, the maintenance window won\'t run until two days later.</p>', 'GetMaintenanceWindowResult$ScheduleOffset' => '<p>The number of days to wait to run a maintenance window after the scheduled CRON expression date and time.</p>', 'MaintenanceWindowIdentity$ScheduleOffset' => '<p>The number of days to wait to run a maintenance window after the scheduled CRON expression date and time.</p>', 'UpdateMaintenanceWindowRequest$ScheduleOffset' => '<p>The number of days to wait after the date and time specified by a CRON expression before running the maintenance window.</p> <p>For example, the following cron expression schedules a maintenance window to run the third Tuesday of every month at 11:30 PM.</p> <p> <code>cron(0 30 23 ? * TUE#3 *)</code> </p> <p>If the schedule offset is <code>2</code>, the maintenance window won\'t run until two days later.</p>', 'UpdateMaintenanceWindowResult$ScheduleOffset' => '<p>The number of days to wait to run a maintenance window after the scheduled CRON expression date and time.</p>', ], ], 'MaintenanceWindowResourceType' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowScheduleRequest$ResourceType' => '<p>The type of resource you want to retrieve information about. For example, "INSTANCE".</p>', 'DescribeMaintenanceWindowsForTargetRequest$ResourceType' => '<p>The type of resource you want to retrieve information about. For example, "INSTANCE".</p>', 'MaintenanceWindowTarget$ResourceType' => '<p>The type of target that is being registered with the maintenance window.</p>', 'RegisterTargetWithMaintenanceWindowRequest$ResourceType' => '<p>The type of target being registered with the maintenance window.</p>', ], ], 'MaintenanceWindowRunCommandParameters' => [ 'base' => '<p>The parameters for a RUN_COMMAND task type.</p> <p>For information about specifying and updating task parameters, see <a>RegisterTaskWithMaintenanceWindow</a> and <a>UpdateMaintenanceWindowTask</a>.</p> <note> <p> <code>LoggingInfo</code> has been deprecated. To specify an S3 bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> <p>For Run Command tasks, Systems Manager uses specified values for <code>TaskParameters</code> and <code>LoggingInfo</code> only if no values are specified for <code>TaskInvocationParameters</code>. </p> </note>', 'refs' => [ 'MaintenanceWindowTaskInvocationParameters$RunCommand' => '<p>The parameters for a RUN_COMMAND task type.</p>', ], ], 'MaintenanceWindowSchedule' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowRequest$Schedule' => '<p>The schedule of the maintenance window in the form of a cron or rate expression.</p>', 'GetMaintenanceWindowResult$Schedule' => '<p>The schedule of the maintenance window in the form of a cron or rate expression.</p>', 'MaintenanceWindowIdentity$Schedule' => '<p>The schedule of the maintenance window in the form of a cron or rate expression.</p>', 'UpdateMaintenanceWindowRequest$Schedule' => '<p>The schedule of the maintenance window in the form of a cron or rate expression.</p>', 'UpdateMaintenanceWindowResult$Schedule' => '<p>The schedule of the maintenance window in the form of a cron or rate expression.</p>', ], ], 'MaintenanceWindowSearchMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowScheduleRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeMaintenanceWindowsForTargetRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'MaintenanceWindowStepFunctionsInput' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowStepFunctionsParameters$Input' => '<p>The inputs for the STEP_FUNCTIONS task.</p>', ], ], 'MaintenanceWindowStepFunctionsName' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowStepFunctionsParameters$Name' => '<p>The name of the STEP_FUNCTIONS task.</p>', ], ], 'MaintenanceWindowStepFunctionsParameters' => [ 'base' => '<p>The parameters for a STEP_FUNCTIONS task.</p> <p>For information about specifying and updating task parameters, see <a>RegisterTaskWithMaintenanceWindow</a> and <a>UpdateMaintenanceWindowTask</a>.</p> <note> <p> <code>LoggingInfo</code> has been deprecated. To specify an S3 bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> <p>For Step Functions tasks, Systems Manager ignores any values specified for <code>TaskParameters</code> and <code>LoggingInfo</code>.</p> </note>', 'refs' => [ 'MaintenanceWindowTaskInvocationParameters$StepFunctions' => '<p>The parameters for a STEP_FUNCTIONS task type.</p>', ], ], 'MaintenanceWindowStringDateTime' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowRequest$StartDate' => '<p>The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become active. StartDate allows you to delay activation of the maintenance window until the specified future date.</p>', 'CreateMaintenanceWindowRequest$EndDate' => '<p>The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become inactive. EndDate allows you to set a date and time in the future when the maintenance window will no longer run.</p>', 'GetMaintenanceWindowResult$StartDate' => '<p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become active. The maintenance window will not run before this specified time.</p>', 'GetMaintenanceWindowResult$EndDate' => '<p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become inactive. The maintenance window will not run after this specified time.</p>', 'GetMaintenanceWindowResult$NextExecutionTime' => '<p>The next time the maintenance window will actually run, taking into account any specified times for the maintenance window to become active or inactive.</p>', 'MaintenanceWindowIdentity$EndDate' => '<p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become inactive.</p>', 'MaintenanceWindowIdentity$StartDate' => '<p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become active.</p>', 'MaintenanceWindowIdentity$NextExecutionTime' => '<p>The next time the maintenance window will actually run, taking into account any specified times for the maintenance window to become active or inactive.</p>', 'ScheduledWindowExecution$ExecutionTime' => '<p>The time, in ISO-8601 Extended format, that the maintenance window is scheduled to be run.</p>', 'UpdateMaintenanceWindowRequest$StartDate' => '<p>The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "etc/UTC", or "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.</p>', 'UpdateMaintenanceWindowRequest$EndDate' => '<p>The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become inactive. EndDate allows you to set a date and time in the future when the maintenance window will no longer run.</p>', 'UpdateMaintenanceWindowResult$StartDate' => '<p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become active. The maintenance window will not run before this specified time.</p>', 'UpdateMaintenanceWindowResult$EndDate' => '<p>The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become inactive. The maintenance window will not run after this specified time.</p>', ], ], 'MaintenanceWindowTarget' => [ 'base' => '<p>The target registered with the maintenance window.</p>', 'refs' => [ 'MaintenanceWindowTargetList$member' => NULL, ], ], 'MaintenanceWindowTargetId' => [ 'base' => NULL, 'refs' => [ 'DeregisterTargetFromMaintenanceWindowRequest$WindowTargetId' => '<p>The ID of the target definition to remove.</p>', 'DeregisterTargetFromMaintenanceWindowResult$WindowTargetId' => '<p>The ID of the removed target definition.</p>', 'MaintenanceWindowTarget$WindowTargetId' => '<p>The ID of the target.</p>', 'RegisterTargetWithMaintenanceWindowResult$WindowTargetId' => '<p>The ID of the target definition in this maintenance window.</p>', 'UpdateMaintenanceWindowTargetRequest$WindowTargetId' => '<p>The target ID to modify.</p>', 'UpdateMaintenanceWindowTargetResult$WindowTargetId' => '<p>The target ID specified in the update request.</p>', ], ], 'MaintenanceWindowTargetList' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowTargetsResult$Targets' => '<p>Information about the targets in the maintenance window.</p>', ], ], 'MaintenanceWindowTask' => [ 'base' => '<p>Information about a task defined for a maintenance window.</p>', 'refs' => [ 'MaintenanceWindowTaskList$member' => NULL, ], ], 'MaintenanceWindowTaskArn' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionTaskResult$TaskArn' => '<p>The ARN of the task that ran.</p>', 'GetMaintenanceWindowTaskResult$TaskArn' => '<p>The resource that the task used during execution. For RUN_COMMAND and AUTOMATION task types, the TaskArn is the Systems Manager Document name/ARN. For LAMBDA tasks, the value is the function name/ARN. For STEP_FUNCTIONS tasks, the value is the state machine ARN.</p>', 'MaintenanceWindowExecutionTaskIdentity$TaskArn' => '<p>The ARN of the task that ran.</p>', 'MaintenanceWindowTask$TaskArn' => '<p>The resource that the task uses during execution. For RUN_COMMAND and AUTOMATION task types, <code>TaskArn</code> is the Systems Manager document name or ARN. For LAMBDA tasks, it\'s the function name or ARN. For STEP_FUNCTIONS tasks, it\'s the state machine ARN.</p>', 'RegisterTaskWithMaintenanceWindowRequest$TaskArn' => '<p>The ARN of the task to run.</p>', 'UpdateMaintenanceWindowTaskRequest$TaskArn' => '<p>The task ARN to modify.</p>', 'UpdateMaintenanceWindowTaskResult$TaskArn' => '<p>The updated task ARN value.</p>', ], ], 'MaintenanceWindowTaskId' => [ 'base' => NULL, 'refs' => [ 'DeregisterTaskFromMaintenanceWindowRequest$WindowTaskId' => '<p>The ID of the task to remove from the maintenance window.</p>', 'DeregisterTaskFromMaintenanceWindowResult$WindowTaskId' => '<p>The ID of the task removed from the maintenance window.</p>', 'GetMaintenanceWindowTaskRequest$WindowTaskId' => '<p>The maintenance window task ID to retrieve.</p>', 'GetMaintenanceWindowTaskResult$WindowTaskId' => '<p>The retrieved maintenance window task ID.</p>', 'MaintenanceWindowTask$WindowTaskId' => '<p>The task ID.</p>', 'RegisterTaskWithMaintenanceWindowResult$WindowTaskId' => '<p>The ID of the task in the maintenance window.</p>', 'UpdateMaintenanceWindowTaskRequest$WindowTaskId' => '<p>The task ID to modify.</p>', 'UpdateMaintenanceWindowTaskResult$WindowTaskId' => '<p>The task ID of the maintenance window that was updated.</p>', ], ], 'MaintenanceWindowTaskInvocationParameters' => [ 'base' => '<p>The parameters for task execution.</p>', 'refs' => [ 'GetMaintenanceWindowTaskResult$TaskInvocationParameters' => '<p>The parameters to pass to the task when it runs.</p>', 'RegisterTaskWithMaintenanceWindowRequest$TaskInvocationParameters' => '<p>The parameters that the task should use during execution. Populate only the fields that match the task type. All other fields should be empty. </p>', 'UpdateMaintenanceWindowTaskRequest$TaskInvocationParameters' => '<p>The parameters that the task should use during execution. Populate only the fields that match the task type. All other fields should be empty.</p>', 'UpdateMaintenanceWindowTaskResult$TaskInvocationParameters' => '<p>The updated parameter values.</p>', ], ], 'MaintenanceWindowTaskList' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowTasksResult$Tasks' => '<p>Information about the tasks in the maintenance window.</p>', ], ], 'MaintenanceWindowTaskParameterName' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowTaskParameters$key' => NULL, ], ], 'MaintenanceWindowTaskParameterValue' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowTaskParameterValueList$member' => NULL, ], ], 'MaintenanceWindowTaskParameterValueExpression' => [ 'base' => '<p>Defines the values for a task parameter.</p>', 'refs' => [ 'MaintenanceWindowTaskParameters$value' => NULL, ], ], 'MaintenanceWindowTaskParameterValueList' => [ 'base' => NULL, 'refs' => [ 'MaintenanceWindowTaskParameterValueExpression$Values' => '<p>This field contains an array of 0 or more strings, each 1 to 255 characters in length.</p>', ], ], 'MaintenanceWindowTaskParameters' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowTaskResult$TaskParameters' => '<p>The parameters to pass to the task when it runs.</p> <note> <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> </note>', 'MaintenanceWindowTask$TaskParameters' => '<p>The parameters that should be passed to the task when it is run.</p> <note> <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> </note>', 'MaintenanceWindowTaskParametersList$member' => NULL, 'RegisterTaskWithMaintenanceWindowRequest$TaskParameters' => '<p>The parameters that should be passed to the task when it is run.</p> <note> <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> </note>', 'UpdateMaintenanceWindowTaskRequest$TaskParameters' => '<p>The parameters to modify.</p> <note> <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> </note> <p>The map has the following format:</p> <p>Key: string, between 1 and 255 characters</p> <p>Value: an array of strings, each string is between 1 and 255 characters</p>', 'UpdateMaintenanceWindowTaskResult$TaskParameters' => '<p>The updated parameter values.</p> <note> <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> </note>', ], ], 'MaintenanceWindowTaskParametersList' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionTaskResult$TaskParameters' => '<p>The parameters passed to the task when it was run.</p> <note> <p> <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.</p> </note> <p>The map has the following format:</p> <p>Key: string, between 1 and 255 characters</p> <p>Value: an array of strings, each string is between 1 and 255 characters</p>', ], ], 'MaintenanceWindowTaskPriority' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionTaskResult$Priority' => '<p>The priority of the task.</p>', 'GetMaintenanceWindowTaskResult$Priority' => '<p>The priority of the task when it runs. The lower the number, the higher the priority. Tasks that have the same priority are scheduled in parallel.</p>', 'MaintenanceWindowTask$Priority' => '<p>The priority of the task in the maintenance window. The lower the number, the higher the priority. Tasks that have the same priority are scheduled in parallel.</p>', 'RegisterTaskWithMaintenanceWindowRequest$Priority' => '<p>The priority of the task in the maintenance window, the lower the number the higher the priority. Tasks in a maintenance window are scheduled in priority order with tasks that have the same priority scheduled in parallel.</p>', 'UpdateMaintenanceWindowTaskRequest$Priority' => '<p>The new task priority to specify. The lower the number, the higher the priority. Tasks that have the same priority are scheduled in parallel.</p>', 'UpdateMaintenanceWindowTaskResult$Priority' => '<p>The updated priority value.</p>', ], ], 'MaintenanceWindowTaskTargetId' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionTaskInvocationResult$WindowTargetId' => '<p>The maintenance window target ID.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$WindowTargetId' => '<p>The ID of the target definition in this maintenance window the invocation was performed for.</p>', ], ], 'MaintenanceWindowTaskType' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionTaskInvocationResult$TaskType' => '<p>Retrieves the task type for a maintenance window. Task types include the following: LAMBDA, STEP_FUNCTIONS, AUTOMATION, RUN_COMMAND.</p>', 'GetMaintenanceWindowExecutionTaskResult$Type' => '<p>The type of task that was run.</p>', 'GetMaintenanceWindowTaskResult$TaskType' => '<p>The type of task to run.</p>', 'MaintenanceWindowExecutionTaskIdentity$TaskType' => '<p>The type of task that ran.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$TaskType' => '<p>The task type.</p>', 'MaintenanceWindowTask$Type' => '<p>The type of task. The type can be one of the following: RUN_COMMAND, AUTOMATION, LAMBDA, or STEP_FUNCTIONS.</p>', 'RegisterTaskWithMaintenanceWindowRequest$TaskType' => '<p>The type of task being registered.</p>', ], ], 'MaintenanceWindowTimezone' => [ 'base' => NULL, 'refs' => [ 'CreateMaintenanceWindowRequest$ScheduleTimezone' => '<p>The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "etc/UTC", or "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.</p>', 'GetMaintenanceWindowResult$ScheduleTimezone' => '<p>The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "etc/UTC", or "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.</p>', 'MaintenanceWindowIdentity$ScheduleTimezone' => '<p>The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format.</p>', 'UpdateMaintenanceWindowRequest$ScheduleTimezone' => '<p>The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "etc/UTC", or "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.</p>', 'UpdateMaintenanceWindowResult$ScheduleTimezone' => '<p>The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "etc/UTC", or "Asia/Seoul". For more information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.</p>', ], ], 'MaintenanceWindowsForTargetList' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowsForTargetResult$WindowIdentities' => '<p>Information about the maintenance window targets and tasks an instance is associated with.</p>', ], ], 'ManagedInstanceId' => [ 'base' => NULL, 'refs' => [ 'DeregisterManagedInstanceRequest$InstanceId' => '<p>The ID assigned to the managed instance when you registered it using the activation process. </p>', 'UpdateManagedInstanceRoleRequest$InstanceId' => '<p>The ID of the managed instance where you want to update the role.</p>', ], ], 'MaxConcurrency' => [ 'base' => NULL, 'refs' => [ 'AssociationDescription$MaxConcurrency' => '<p>The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all targets run the association at the same time.</p> <p>If a new instance starts and attempts to run an association while Systems Manager is running MaxConcurrency associations, the association is allowed to run. During the next association interval, the new instance will process its association within the limit specified for MaxConcurrency.</p>', 'AssociationVersionInfo$MaxConcurrency' => '<p>The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all targets run the association at the same time.</p> <p>If a new instance starts and attempts to run an association while Systems Manager is running MaxConcurrency associations, the association is allowed to run. During the next association interval, the new instance will process its association within the limit specified for MaxConcurrency.</p>', 'AutomationExecution$MaxConcurrency' => '<p>The MaxConcurrency value specified by the user when the execution started.</p>', 'AutomationExecutionMetadata$MaxConcurrency' => '<p>The MaxConcurrency value specified by the user when starting the Automation.</p>', 'Command$MaxConcurrency' => '<p>The maximum number of instances that are allowed to run the command at the same time. You can specify a number of instances, such as 10, or a percentage of instances, such as 10%. The default value is 50. For more information about how to use MaxConcurrency, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html">Running commands using Systems Manager Run Command</a> in the <i>AWS Systems Manager User Guide</i>.</p>', 'CreateAssociationBatchRequestEntry$MaxConcurrency' => '<p>The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all targets run the association at the same time.</p> <p>If a new instance starts and attempts to run an association while Systems Manager is running MaxConcurrency associations, the association is allowed to run. During the next association interval, the new instance will process its association within the limit specified for MaxConcurrency.</p>', 'CreateAssociationRequest$MaxConcurrency' => '<p>The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all targets run the association at the same time.</p> <p>If a new instance starts and attempts to run an association while Systems Manager is running MaxConcurrency associations, the association is allowed to run. During the next association interval, the new instance will process its association within the limit specified for MaxConcurrency.</p>', 'GetMaintenanceWindowExecutionTaskResult$MaxConcurrency' => '<p>The defined maximum number of task executions that could be run in parallel.</p>', 'GetMaintenanceWindowTaskResult$MaxConcurrency' => '<p>The maximum number of targets allowed to run this task in parallel.</p>', 'MaintenanceWindowTask$MaxConcurrency' => '<p>The maximum number of targets this task can be run for, in parallel.</p>', 'RegisterTaskWithMaintenanceWindowRequest$MaxConcurrency' => '<p>The maximum number of targets this task can be run for in parallel.</p>', 'SendCommandRequest$MaxConcurrency' => '<p>(Optional) The maximum number of instances that are allowed to run the command at the same time. You can specify a number such as 10 or a percentage such as 10%. The default value is 50. For more information about how to use MaxConcurrency, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html#send-commands-velocity">Using concurrency controls</a> in the <i>AWS Systems Manager User Guide</i>.</p>', 'StartAutomationExecutionRequest$MaxConcurrency' => '<p>The maximum number of targets allowed to run this task in parallel. You can specify a number, such as 10, or a percentage, such as 10%. The default value is 10.</p>', 'TargetLocation$TargetLocationMaxConcurrency' => '<p>The maximum number of AWS accounts and AWS regions allowed to run the Automation concurrently </p>', 'UpdateAssociationRequest$MaxConcurrency' => '<p>The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all targets run the association at the same time.</p> <p>If a new instance starts and attempts to run an association while Systems Manager is running MaxConcurrency associations, the association is allowed to run. During the next association interval, the new instance will process its association within the limit specified for MaxConcurrency.</p>', 'UpdateMaintenanceWindowTaskRequest$MaxConcurrency' => '<p>The new <code>MaxConcurrency</code> value you want to specify. <code>MaxConcurrency</code> is the number of targets that are allowed to run this task in parallel.</p>', 'UpdateMaintenanceWindowTaskResult$MaxConcurrency' => '<p>The updated MaxConcurrency value.</p>', ], ], 'MaxDocumentSizeExceeded' => [ 'base' => '<p>The size limit of a document is 64 KB.</p>', 'refs' => [], ], 'MaxErrors' => [ 'base' => NULL, 'refs' => [ 'AssociationDescription$MaxErrors' => '<p>The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth error is received. If you specify 0, then the system stops sending requests after the first error is returned. If you run an association on 50 instances and set MaxError to 10%, then the system stops sending the request when the sixth error is received.</p> <p>Executions that are already running an association when MaxErrors is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won\'t be more than max-errors failed executions, set MaxConcurrency to 1 so that executions proceed one at a time.</p>', 'AssociationVersionInfo$MaxErrors' => '<p>The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth error is received. If you specify 0, then the system stops sending requests after the first error is returned. If you run an association on 50 instances and set MaxError to 10%, then the system stops sending the request when the sixth error is received.</p> <p>Executions that are already running an association when MaxErrors is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won\'t be more than max-errors failed executions, set MaxConcurrency to 1 so that executions proceed one at a time.</p>', 'AutomationExecution$MaxErrors' => '<p>The MaxErrors value specified by the user when the execution started.</p>', 'AutomationExecutionMetadata$MaxErrors' => '<p>The MaxErrors value specified by the user when starting the Automation.</p>', 'Command$MaxErrors' => '<p>The maximum number of errors allowed before the system stops sending the command to additional targets. You can specify a number of errors, such as 10, or a percentage or errors, such as 10%. The default value is 0. For more information about how to use MaxErrors, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html">Running commands using Systems Manager Run Command</a> in the <i>AWS Systems Manager User Guide</i>.</p>', 'CreateAssociationBatchRequestEntry$MaxErrors' => '<p>The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth error is received. If you specify 0, then the system stops sending requests after the first error is returned. If you run an association on 50 instances and set MaxError to 10%, then the system stops sending the request when the sixth error is received.</p> <p>Executions that are already running an association when MaxErrors is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won\'t be more than max-errors failed executions, set MaxConcurrency to 1 so that executions proceed one at a time.</p>', 'CreateAssociationRequest$MaxErrors' => '<p>The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth error is received. If you specify 0, then the system stops sending requests after the first error is returned. If you run an association on 50 instances and set MaxError to 10%, then the system stops sending the request when the sixth error is received.</p> <p>Executions that are already running an association when MaxErrors is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won\'t be more than max-errors failed executions, set MaxConcurrency to 1 so that executions proceed one at a time.</p>', 'GetMaintenanceWindowExecutionTaskResult$MaxErrors' => '<p>The defined maximum number of task execution errors allowed before scheduling of the task execution would have been stopped.</p>', 'GetMaintenanceWindowTaskResult$MaxErrors' => '<p>The maximum number of errors allowed before the task stops being scheduled.</p>', 'MaintenanceWindowTask$MaxErrors' => '<p>The maximum number of errors allowed before this task stops being scheduled.</p>', 'RegisterTaskWithMaintenanceWindowRequest$MaxErrors' => '<p>The maximum number of errors allowed before this task stops being scheduled.</p>', 'SendCommandRequest$MaxErrors' => '<p>The maximum number of errors allowed without the command failing. When the command fails one more time beyond the value of MaxErrors, the systems stops sending the command to additional targets. You can specify a number like 10 or a percentage like 10%. The default value is 0. For more information about how to use MaxErrors, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html#send-commands-maxerrors">Using error controls</a> in the <i>AWS Systems Manager User Guide</i>.</p>', 'StartAutomationExecutionRequest$MaxErrors' => '<p>The number of errors that are allowed before the system stops running the automation on additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops running the automation when the fourth error is received. If you specify 0, then the system stops running the automation on additional targets after the first error result is returned. If you run an automation on 50 resources and set max-errors to 10%, then the system stops running the automation on additional targets when the sixth error is received.</p> <p>Executions that are already running an automation when max-errors is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won\'t be more than max-errors failed executions, set max-concurrency to 1 so the executions proceed one at a time.</p>', 'TargetLocation$TargetLocationMaxErrors' => '<p>The maximum number of errors allowed before the system stops queueing additional Automation executions for the currently running Automation. </p>', 'UpdateAssociationRequest$MaxErrors' => '<p>The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth error is received. If you specify 0, then the system stops sending requests after the first error is returned. If you run an association on 50 instances and set MaxError to 10%, then the system stops sending the request when the sixth error is received.</p> <p>Executions that are already running an association when MaxErrors is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won\'t be more than max-errors failed executions, set MaxConcurrency to 1 so that executions proceed one at a time.</p>', 'UpdateMaintenanceWindowTaskRequest$MaxErrors' => '<p>The new <code>MaxErrors</code> value to specify. <code>MaxErrors</code> is the maximum number of errors that are allowed before the task stops being scheduled.</p>', 'UpdateMaintenanceWindowTaskResult$MaxErrors' => '<p>The updated MaxErrors value.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeActivationsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeAssociationExecutionTargetsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeAssociationExecutionsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeAutomationExecutionsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeAutomationStepExecutionsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeInstanceAssociationsStatusRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeInventoryDeletionsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribeParametersRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'DescribePatchPropertiesRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'GetInventoryRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'GetOpsSummaryRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'GetParameterHistoryRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListAssociationVersionsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListAssociationsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListComplianceItemsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListComplianceSummariesRequest$MaxResults' => '<p>The maximum number of items to return for this call. Currently, you can specify null or 50. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListDocumentVersionsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListDocumentsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListInventoryEntriesRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListResourceComplianceSummariesRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', 'ListResourceDataSyncRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'MaxResultsEC2Compatible' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceInformationRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. </p>', ], ], 'ModifyDocumentPermissionRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDocumentPermissionResponse' => [ 'base' => NULL, 'refs' => [], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeActivationsRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'DescribeActivationsResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results. </p>', 'DescribeAssociationExecutionTargetsRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'DescribeAssociationExecutionTargetsResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'DescribeAssociationExecutionsRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'DescribeAssociationExecutionsResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'DescribeAutomationExecutionsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeAutomationExecutionsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeAutomationStepExecutionsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeAutomationStepExecutionsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeAvailablePatchesRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeAvailablePatchesResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeEffectiveInstanceAssociationsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeEffectiveInstanceAssociationsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeEffectivePatchesForPatchBaselineRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeEffectivePatchesForPatchBaselineResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeInstanceAssociationsStatusRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeInstanceAssociationsStatusResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeInstanceInformationRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeInstanceInformationResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty. </p>', 'DescribeInstancePatchStatesForPatchGroupRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeInstancePatchStatesForPatchGroupResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeInstancePatchStatesRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeInstancePatchStatesResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeInstancePatchesRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeInstancePatchesResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeInventoryDeletionsRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'DescribeInventoryDeletionsResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'DescribeMaintenanceWindowExecutionTaskInvocationsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeMaintenanceWindowExecutionTaskInvocationsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeMaintenanceWindowExecutionTasksRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeMaintenanceWindowExecutionTasksResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeMaintenanceWindowExecutionsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeMaintenanceWindowExecutionsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeMaintenanceWindowScheduleRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeMaintenanceWindowScheduleResult$NextToken' => '<p>The token for the next set of items to return. (You use this token in the next call.)</p>', 'DescribeMaintenanceWindowTargetsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeMaintenanceWindowTargetsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeMaintenanceWindowTasksRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeMaintenanceWindowTasksResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeMaintenanceWindowsForTargetRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeMaintenanceWindowsForTargetResult$NextToken' => '<p>The token for the next set of items to return. (You use this token in the next call.)</p>', 'DescribeMaintenanceWindowsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeMaintenanceWindowsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribeParametersRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeParametersResult$NextToken' => '<p>The token to use when requesting the next set of items.</p>', 'DescribePatchBaselinesRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribePatchBaselinesResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribePatchGroupsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribePatchGroupsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'DescribePatchPropertiesRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribePatchPropertiesResult$NextToken' => '<p>The token for the next set of items to return. (You use this token in the next call.)</p>', 'DescribeSessionsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'DescribeSessionsResponse$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'GetInventoryRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'GetInventoryResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'GetInventorySchemaRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'GetInventorySchemaResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'GetOpsSummaryRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'GetOpsSummaryResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'GetParameterHistoryRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'GetParameterHistoryResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'GetParametersByPathRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'GetParametersByPathResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'ListAssociationVersionsRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'ListAssociationVersionsResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'ListAssociationsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'ListAssociationsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'ListCommandInvocationsRequest$NextToken' => '<p>(Optional) The token for the next set of items to return. (You received this token from a previous call.)</p>', 'ListCommandInvocationsResult$NextToken' => '<p>(Optional) The token for the next set of items to return. (You received this token from a previous call.)</p>', 'ListCommandsRequest$NextToken' => '<p>(Optional) The token for the next set of items to return. (You received this token from a previous call.)</p>', 'ListCommandsResult$NextToken' => '<p>(Optional) The token for the next set of items to return. (You received this token from a previous call.)</p>', 'ListComplianceItemsRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'ListComplianceItemsResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'ListComplianceSummariesRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'ListComplianceSummariesResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'ListDocumentVersionsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'ListDocumentVersionsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'ListDocumentsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'ListDocumentsResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'ListInventoryEntriesRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a previous call.)</p>', 'ListInventoryEntriesResult$NextToken' => '<p>The token to use when requesting the next set of items. If there are no additional items to return, the string is empty.</p>', 'ListResourceComplianceSummariesRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'ListResourceComplianceSummariesResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'ListResourceDataSyncRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results. </p>', 'ListResourceDataSyncResult$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', ], ], 'NonCompliantSummary' => [ 'base' => '<p>A summary of resources that are not compliant. The summary is organized according to resource type.</p>', 'refs' => [ 'ComplianceSummaryItem$NonCompliantSummary' => '<p>A list of NON_COMPLIANT items for the specified compliance type.</p>', 'ResourceComplianceSummaryItem$NonCompliantSummary' => '<p>A list of items that aren\'t compliant for the resource.</p>', ], ], 'NormalStringMap' => [ 'base' => NULL, 'refs' => [ 'StepExecution$Inputs' => '<p>Fully-resolved values passed into the step before execution.</p>', ], ], 'NotificationArn' => [ 'base' => NULL, 'refs' => [ 'NotificationConfig$NotificationArn' => '<p>An Amazon Resource Name (ARN) for an Amazon Simple Notification Service (Amazon SNS) topic. Run Command pushes notifications about command status changes to this topic.</p>', ], ], 'NotificationConfig' => [ 'base' => '<p>Configurations for sending notifications.</p>', 'refs' => [ 'Command$NotificationConfig' => '<p>Configurations for sending notifications about command status changes. </p>', 'CommandInvocation$NotificationConfig' => '<p>Configurations for sending notifications about command status changes on a per instance basis.</p>', 'MaintenanceWindowRunCommandParameters$NotificationConfig' => '<p>Configurations for sending notifications about command status changes on a per-instance basis.</p>', 'SendCommandRequest$NotificationConfig' => '<p>Configurations for sending notifications.</p>', ], ], 'NotificationEvent' => [ 'base' => NULL, 'refs' => [ 'NotificationEventList$member' => NULL, ], ], 'NotificationEventList' => [ 'base' => NULL, 'refs' => [ 'NotificationConfig$NotificationEvents' => '<p>The different events for which you can receive notifications. These events include the following: All (events), InProgress, Success, TimedOut, Cancelled, Failed. To learn more about these events, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitoring-sns-notifications.html">Monitoring Systems Manager status changes using Amazon SNS notifications</a> in the <i>AWS Systems Manager User Guide</i>.</p>', ], ], 'NotificationType' => [ 'base' => NULL, 'refs' => [ 'NotificationConfig$NotificationType' => '<p>Command: Receive notification when the status of a command changes. Invocation: For commands sent to multiple instances, receive notification on a per-instance basis when the status of a command changes. </p>', ], ], 'OperatingSystem' => [ 'base' => NULL, 'refs' => [ 'CreatePatchBaselineRequest$OperatingSystem' => '<p>Defines the operating system the patch baseline applies to. The Default value is WINDOWS.</p>', 'DescribePatchPropertiesRequest$OperatingSystem' => '<p>The operating system type for which to list patches.</p>', 'GetDefaultPatchBaselineRequest$OperatingSystem' => '<p>Returns the default patch baseline for the specified operating system.</p>', 'GetDefaultPatchBaselineResult$OperatingSystem' => '<p>The operating system for the returned patch baseline. </p>', 'GetPatchBaselineForPatchGroupRequest$OperatingSystem' => '<p>Returns he operating system rule specified for patch groups using the patch baseline.</p>', 'GetPatchBaselineForPatchGroupResult$OperatingSystem' => '<p>The operating system rule specified for patch groups using the patch baseline.</p>', 'GetPatchBaselineResult$OperatingSystem' => '<p>Returns the operating system specified for the patch baseline.</p>', 'PatchBaselineIdentity$OperatingSystem' => '<p>Defines the operating system the patch baseline applies to. The Default value is WINDOWS. </p>', 'UpdatePatchBaselineResult$OperatingSystem' => '<p>The operating system rule used by the updated patch baseline.</p>', ], ], 'OpsAggregator' => [ 'base' => '<p>One or more aggregators for viewing counts of OpsItems using different dimensions such as <code>Source</code>, <code>CreatedTime</code>, or <code>Source and CreatedTime</code>, to name a few.</p>', 'refs' => [ 'OpsAggregatorList$member' => NULL, ], ], 'OpsAggregatorList' => [ 'base' => NULL, 'refs' => [ 'GetOpsSummaryRequest$Aggregators' => '<p>Optional aggregators that return counts of OpsItems based on one or more expressions.</p>', 'OpsAggregator$Aggregators' => '<p>A nested aggregator for viewing counts of OpsItems.</p>', ], ], 'OpsAggregatorType' => [ 'base' => NULL, 'refs' => [ 'OpsAggregator$AggregatorType' => '<p>Either a Range or Count aggregator for limiting an OpsItem summary.</p>', ], ], 'OpsAggregatorValue' => [ 'base' => NULL, 'refs' => [ 'OpsAggregatorValueMap$value' => NULL, ], ], 'OpsAggregatorValueKey' => [ 'base' => NULL, 'refs' => [ 'OpsAggregatorValueMap$key' => NULL, ], ], 'OpsAggregatorValueMap' => [ 'base' => NULL, 'refs' => [ 'OpsAggregator$Values' => '<p>The aggregator value.</p>', ], ], 'OpsDataAttributeName' => [ 'base' => NULL, 'refs' => [ 'OpsAggregator$AttributeName' => '<p>The name of an OpsItem attribute on which to limit the count of OpsItems.</p>', ], ], 'OpsDataTypeName' => [ 'base' => NULL, 'refs' => [ 'OpsAggregator$TypeName' => '<p>The data type name to use for viewing counts of OpsItems.</p>', 'OpsResultAttribute$TypeName' => '<p>Name of the data type. Valid value: AWS:OpsItem, AWS:EC2InstanceInformation, AWS:OpsItemTrendline, or AWS:ComplianceSummary.</p>', ], ], 'OpsEntity' => [ 'base' => '<p>The result of the query.</p>', 'refs' => [ 'OpsEntityList$member' => NULL, ], ], 'OpsEntityId' => [ 'base' => NULL, 'refs' => [ 'OpsEntity$Id' => '<p>The query ID.</p>', ], ], 'OpsEntityItem' => [ 'base' => '<p>The OpsItem summaries result item.</p>', 'refs' => [ 'OpsEntityItemMap$value' => NULL, ], ], 'OpsEntityItemCaptureTime' => [ 'base' => NULL, 'refs' => [ 'OpsEntityItem$CaptureTime' => '<p>The time OpsItem data was captured.</p>', ], ], 'OpsEntityItemEntry' => [ 'base' => NULL, 'refs' => [ 'OpsEntityItemEntryList$member' => NULL, ], ], 'OpsEntityItemEntryList' => [ 'base' => NULL, 'refs' => [ 'OpsEntityItem$Content' => '<p>The detailed data content for an OpsItem summaries result item.</p>', ], ], 'OpsEntityItemKey' => [ 'base' => NULL, 'refs' => [ 'OpsEntityItemMap$key' => NULL, ], ], 'OpsEntityItemMap' => [ 'base' => NULL, 'refs' => [ 'OpsEntity$Data' => '<p>The data returned by the query.</p>', ], ], 'OpsEntityList' => [ 'base' => NULL, 'refs' => [ 'GetOpsSummaryResult$Entities' => '<p>The list of aggregated and filtered OpsItems.</p>', ], ], 'OpsFilter' => [ 'base' => '<p>A filter for viewing OpsItem summaries.</p>', 'refs' => [ 'OpsFilterList$member' => NULL, ], ], 'OpsFilterKey' => [ 'base' => NULL, 'refs' => [ 'OpsFilter$Key' => '<p>The name of the filter.</p>', ], ], 'OpsFilterList' => [ 'base' => NULL, 'refs' => [ 'GetOpsSummaryRequest$Filters' => '<p>Optional filters used to scope down the returned OpsItems. </p>', 'OpsAggregator$Filters' => '<p>The aggregator filters.</p>', ], ], 'OpsFilterOperatorType' => [ 'base' => NULL, 'refs' => [ 'OpsFilter$Type' => '<p>The type of filter.</p>', ], ], 'OpsFilterValue' => [ 'base' => NULL, 'refs' => [ 'OpsFilterValueList$member' => NULL, ], ], 'OpsFilterValueList' => [ 'base' => NULL, 'refs' => [ 'OpsFilter$Values' => '<p>The filter value.</p>', ], ], 'OpsItem' => [ 'base' => '<p>Operations engineers and IT professionals use OpsCenter to view, investigate, and remediate operational issues impacting the performance and health of their AWS resources. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">AWS Systems Manager OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>. </p>', 'refs' => [ 'GetOpsItemResponse$OpsItem' => '<p>The OpsItem.</p>', ], ], 'OpsItemAlreadyExistsException' => [ 'base' => '<p>The OpsItem already exists.</p>', 'refs' => [], ], 'OpsItemCategory' => [ 'base' => NULL, 'refs' => [ 'CreateOpsItemRequest$Category' => '<p>Specify a category to assign to an OpsItem. </p>', 'OpsItem$Category' => '<p>An OpsItem category. Category options include: Availability, Cost, Performance, Recovery, Security.</p>', 'OpsItemSummary$Category' => '<p>A list of OpsItems by category.</p>', 'UpdateOpsItemRequest$Category' => '<p>Specify a new category for an OpsItem.</p>', ], ], 'OpsItemDataKey' => [ 'base' => NULL, 'refs' => [ 'OpsItemOperationalData$key' => NULL, ], ], 'OpsItemDataType' => [ 'base' => NULL, 'refs' => [ 'OpsItemDataValue$Type' => '<p>The type of key-value pair. Valid types include <code>SearchableString</code> and <code>String</code>.</p>', ], ], 'OpsItemDataValue' => [ 'base' => '<p>An object that defines the value of the key and its type in the OperationalData map.</p>', 'refs' => [ 'OpsItemOperationalData$value' => NULL, ], ], 'OpsItemDataValueString' => [ 'base' => NULL, 'refs' => [ 'OpsItemDataValue$Value' => '<p>The value of the OperationalData key.</p>', ], ], 'OpsItemDescription' => [ 'base' => NULL, 'refs' => [ 'CreateOpsItemRequest$Description' => '<p>Information about the OpsItem. </p>', 'OpsItem$Description' => '<p>The OpsItem description.</p>', 'UpdateOpsItemRequest$Description' => '<p>Update the information about the OpsItem. Provide enough information so that users reading this OpsItem for the first time understand the issue. </p>', ], ], 'OpsItemFilter' => [ 'base' => '<p>Describes an OpsItem filter.</p>', 'refs' => [ 'OpsItemFilters$member' => NULL, ], ], 'OpsItemFilterKey' => [ 'base' => NULL, 'refs' => [ 'OpsItemFilter$Key' => '<p>The name of the filter.</p>', ], ], 'OpsItemFilterOperator' => [ 'base' => NULL, 'refs' => [ 'OpsItemFilter$Operator' => '<p>The operator used by the filter call.</p>', ], ], 'OpsItemFilterValue' => [ 'base' => NULL, 'refs' => [ 'OpsItemFilterValues$member' => NULL, ], ], 'OpsItemFilterValues' => [ 'base' => NULL, 'refs' => [ 'OpsItemFilter$Values' => '<p>The filter value.</p>', ], ], 'OpsItemFilters' => [ 'base' => NULL, 'refs' => [ 'DescribeOpsItemsRequest$OpsItemFilters' => '<p>One or more filters to limit the response.</p> <ul> <li> <p>Key: CreatedTime</p> <p>Operations: GreaterThan, LessThan</p> </li> <li> <p>Key: LastModifiedBy</p> <p>Operations: Contains, Equals</p> </li> <li> <p>Key: LastModifiedTime</p> <p>Operations: GreaterThan, LessThan</p> </li> <li> <p>Key: Priority</p> <p>Operations: Equals</p> </li> <li> <p>Key: Source</p> <p>Operations: Contains, Equals</p> </li> <li> <p>Key: Status</p> <p>Operations: Equals</p> </li> <li> <p>Key: Title</p> <p>Operations: Contains</p> </li> <li> <p>Key: OperationalData*</p> <p>Operations: Equals</p> </li> <li> <p>Key: OperationalDataKey</p> <p>Operations: Equals</p> </li> <li> <p>Key: OperationalDataValue</p> <p>Operations: Equals, Contains</p> </li> <li> <p>Key: OpsItemId</p> <p>Operations: Equals</p> </li> <li> <p>Key: ResourceId</p> <p>Operations: Contains</p> </li> <li> <p>Key: AutomationId</p> <p>Operations: Equals</p> </li> </ul> <p>*If you filter the response by using the OperationalData operator, specify a key-value pair by using the following JSON format: {"key":"key_name","value":"a_value"}</p>', ], ], 'OpsItemId' => [ 'base' => NULL, 'refs' => [ 'GetOpsItemRequest$OpsItemId' => '<p>The ID of the OpsItem that you want to get.</p>', 'OpsItem$OpsItemId' => '<p>The ID of the OpsItem.</p>', 'OpsItemSummary$OpsItemId' => '<p>The ID of the OpsItem.</p>', 'UpdateOpsItemRequest$OpsItemId' => '<p>The ID of the OpsItem.</p>', ], ], 'OpsItemInvalidParameterException' => [ 'base' => '<p>A specified parameter argument isn\'t valid. Verify the available arguments and try again.</p>', 'refs' => [], ], 'OpsItemLimitExceededException' => [ 'base' => '<p>The request caused OpsItems to exceed one or more quotas. For information about OpsItem quotas, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits">What are the resource limits for OpsCenter?</a>.</p>', 'refs' => [], ], 'OpsItemMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeOpsItemsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'OpsItemNotFoundException' => [ 'base' => '<p>The specified OpsItem ID doesn\'t exist. Verify the ID and try again.</p>', 'refs' => [], ], 'OpsItemNotification' => [ 'base' => '<p>A notification about the OpsItem.</p>', 'refs' => [ 'OpsItemNotifications$member' => NULL, ], ], 'OpsItemNotifications' => [ 'base' => NULL, 'refs' => [ 'CreateOpsItemRequest$Notifications' => '<p>The Amazon Resource Name (ARN) of an SNS topic where notifications are sent when this OpsItem is edited or changed.</p>', 'OpsItem$Notifications' => '<p>The Amazon Resource Name (ARN) of an SNS topic where notifications are sent when this OpsItem is edited or changed.</p>', 'UpdateOpsItemRequest$Notifications' => '<p>The Amazon Resource Name (ARN) of an SNS topic where notifications are sent when this OpsItem is edited or changed.</p>', ], ], 'OpsItemOperationalData' => [ 'base' => NULL, 'refs' => [ 'CreateOpsItemRequest$OperationalData' => '<p>Operational data is custom data that provides useful reference details about the OpsItem. For example, you can specify log files, error strings, license keys, troubleshooting tips, or other relevant data. You enter operational data as key-value pairs. The key has a maximum length of 128 characters. The value has a maximum size of 20 KB.</p> <important> <p>Operational data keys <i>can\'t</i> begin with the following: amazon, aws, amzn, ssm, /amazon, /aws, /amzn, /ssm.</p> </important> <p>You can choose to make the data searchable by other users in the account or you can restrict search access. Searchable data means that all users with access to the OpsItem Overview page (as provided by the <a>DescribeOpsItems</a> API action) can view and search on the specified data. Operational data that is not searchable is only viewable by users who have access to the OpsItem (as provided by the <a>GetOpsItem</a> API action).</p> <p>Use the <code>/aws/resources</code> key in OperationalData to specify a related resource in the request. Use the <code>/aws/automations</code> key in OperationalData to associate an Automation runbook with the OpsItem. To view AWS CLI example commands that use these keys, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems">Creating OpsItems manually</a> in the <i>AWS Systems Manager User Guide</i>.</p>', 'OpsItem$OperationalData' => '<p>Operational data is custom data that provides useful reference details about the OpsItem. For example, you can specify log files, error strings, license keys, troubleshooting tips, or other relevant data. You enter operational data as key-value pairs. The key has a maximum length of 128 characters. The value has a maximum size of 20 KB.</p> <important> <p>Operational data keys <i>can\'t</i> begin with the following: amazon, aws, amzn, ssm, /amazon, /aws, /amzn, /ssm.</p> </important> <p>You can choose to make the data searchable by other users in the account or you can restrict search access. Searchable data means that all users with access to the OpsItem Overview page (as provided by the <a>DescribeOpsItems</a> API action) can view and search on the specified data. Operational data that is not searchable is only viewable by users who have access to the OpsItem (as provided by the <a>GetOpsItem</a> API action).</p> <p>Use the <code>/aws/resources</code> key in OperationalData to specify a related resource in the request. Use the <code>/aws/automations</code> key in OperationalData to associate an Automation runbook with the OpsItem. To view AWS CLI example commands that use these keys, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems">Creating OpsItems manually</a> in the <i>AWS Systems Manager User Guide</i>.</p>', 'OpsItemSummary$OperationalData' => '<p>Operational data is custom data that provides useful reference details about the OpsItem. </p>', 'UpdateOpsItemRequest$OperationalData' => '<p>Add new keys or edit existing key-value pairs of the OperationalData map in the OpsItem object.</p> <p>Operational data is custom data that provides useful reference details about the OpsItem. For example, you can specify log files, error strings, license keys, troubleshooting tips, or other relevant data. You enter operational data as key-value pairs. The key has a maximum length of 128 characters. The value has a maximum size of 20 KB.</p> <important> <p>Operational data keys <i>can\'t</i> begin with the following: amazon, aws, amzn, ssm, /amazon, /aws, /amzn, /ssm.</p> </important> <p>You can choose to make the data searchable by other users in the account or you can restrict search access. Searchable data means that all users with access to the OpsItem Overview page (as provided by the <a>DescribeOpsItems</a> API action) can view and search on the specified data. Operational data that is not searchable is only viewable by users who have access to the OpsItem (as provided by the <a>GetOpsItem</a> API action).</p> <p>Use the <code>/aws/resources</code> key in OperationalData to specify a related resource in the request. Use the <code>/aws/automations</code> key in OperationalData to associate an Automation runbook with the OpsItem. To view AWS CLI example commands that use these keys, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems">Creating OpsItems manually</a> in the <i>AWS Systems Manager User Guide</i>.</p>', ], ], 'OpsItemOpsDataKeysList' => [ 'base' => NULL, 'refs' => [ 'UpdateOpsItemRequest$OperationalDataToDelete' => '<p>Keys that you want to remove from the OperationalData map.</p>', ], ], 'OpsItemParameterNamesList' => [ 'base' => NULL, 'refs' => [ 'OpsItemInvalidParameterException$ParameterNames' => NULL, 'OpsItemLimitExceededException$ResourceTypes' => NULL, ], ], 'OpsItemPriority' => [ 'base' => NULL, 'refs' => [ 'CreateOpsItemRequest$Priority' => '<p>The importance of this OpsItem in relation to other OpsItems in the system.</p>', 'OpsItem$Priority' => '<p>The importance of this OpsItem in relation to other OpsItems in the system.</p>', 'OpsItemSummary$Priority' => '<p>The importance of this OpsItem in relation to other OpsItems in the system.</p>', 'UpdateOpsItemRequest$Priority' => '<p>The importance of this OpsItem in relation to other OpsItems in the system.</p>', ], ], 'OpsItemSeverity' => [ 'base' => NULL, 'refs' => [ 'CreateOpsItemRequest$Severity' => '<p>Specify a severity to assign to an OpsItem.</p>', 'OpsItem$Severity' => '<p>The severity of the OpsItem. Severity options range from 1 to 4.</p>', 'OpsItemSummary$Severity' => '<p>A list of OpsItems by severity.</p>', 'UpdateOpsItemRequest$Severity' => '<p>Specify a new severity for an OpsItem.</p>', ], ], 'OpsItemSource' => [ 'base' => NULL, 'refs' => [ 'CreateOpsItemRequest$Source' => '<p>The origin of the OpsItem, such as Amazon EC2 or Systems Manager.</p> <note> <p>The source name can\'t contain the following strings: aws, amazon, and amzn. </p> </note>', 'OpsItem$Source' => '<p>The origin of the OpsItem, such as Amazon EC2 or Systems Manager. The impacted resource is a subset of source.</p>', 'OpsItemSummary$Source' => '<p>The impacted AWS resource.</p>', ], ], 'OpsItemStatus' => [ 'base' => NULL, 'refs' => [ 'OpsItem$Status' => '<p>The OpsItem status. Status can be <code>Open</code>, <code>In Progress</code>, or <code>Resolved</code>. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-working-with-OpsItems-editing-details.html">Editing OpsItem details</a> in the <i>AWS Systems Manager User Guide</i>.</p>', 'OpsItemSummary$Status' => '<p>The OpsItem status. Status can be <code>Open</code>, <code>In Progress</code>, or <code>Resolved</code>.</p>', 'UpdateOpsItemRequest$Status' => '<p>The OpsItem status. Status can be <code>Open</code>, <code>In Progress</code>, or <code>Resolved</code>. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-working-with-OpsItems.html#OpsCenter-working-with-OpsItems-editing-details">Editing OpsItem details</a> in the <i>AWS Systems Manager User Guide</i>.</p>', ], ], 'OpsItemSummaries' => [ 'base' => NULL, 'refs' => [ 'DescribeOpsItemsResponse$OpsItemSummaries' => '<p>A list of OpsItems.</p>', ], ], 'OpsItemSummary' => [ 'base' => '<p>A count of OpsItems.</p>', 'refs' => [ 'OpsItemSummaries$member' => NULL, ], ], 'OpsItemTitle' => [ 'base' => NULL, 'refs' => [ 'CreateOpsItemRequest$Title' => '<p>A short heading that describes the nature of the OpsItem and the impacted resource.</p>', 'OpsItem$Title' => '<p>A short heading that describes the nature of the OpsItem and the impacted resource.</p>', 'OpsItemSummary$Title' => '<p>A short heading that describes the nature of the OpsItem and the impacted resource.</p>', 'UpdateOpsItemRequest$Title' => '<p>A short heading that describes the nature of the OpsItem and the impacted resource.</p>', ], ], 'OpsResultAttribute' => [ 'base' => '<p>The OpsItem data type to return.</p>', 'refs' => [ 'OpsResultAttributeList$member' => NULL, ], ], 'OpsResultAttributeList' => [ 'base' => NULL, 'refs' => [ 'GetOpsSummaryRequest$ResultAttributes' => '<p>The OpsItem data type to return.</p>', ], ], 'OutputSource' => [ 'base' => '<p>Information about the source where the association execution details are stored.</p>', 'refs' => [ 'AssociationExecutionTarget$OutputSource' => '<p>The location where the association details are saved.</p>', ], ], 'OutputSourceId' => [ 'base' => NULL, 'refs' => [ 'OutputSource$OutputSourceId' => '<p>The ID of the output source, for example the URL of an S3 bucket.</p>', ], ], 'OutputSourceType' => [ 'base' => NULL, 'refs' => [ 'OutputSource$OutputSourceType' => '<p>The type of source where the association execution details are stored, for example, Amazon S3.</p>', ], ], 'OwnerInformation' => [ 'base' => NULL, 'refs' => [ 'GetMaintenanceWindowExecutionTaskInvocationResult$OwnerInformation' => '<p>User-provided value to be included in any CloudWatch events raised while running tasks for these targets in this maintenance window. </p>', 'InstancePatchState$OwnerInformation' => '<p>Placeholder information. This field will always be empty in the current release of the service.</p>', 'MaintenanceWindowExecutionTaskInvocationIdentity$OwnerInformation' => '<p>User-provided value that was specified when the target was registered with the maintenance window. This was also included in any CloudWatch events raised during the task invocation.</p>', 'MaintenanceWindowTarget$OwnerInformation' => '<p>A user-provided value that will be included in any CloudWatch events that are raised while running tasks for these targets in this maintenance window.</p>', 'RegisterTargetWithMaintenanceWindowRequest$OwnerInformation' => '<p>User-provided value that will be included in any CloudWatch events raised while running tasks for these targets in this maintenance window.</p>', 'UpdateMaintenanceWindowTargetRequest$OwnerInformation' => '<p>User-provided value that will be included in any CloudWatch events raised while running tasks for these targets in this maintenance window.</p>', 'UpdateMaintenanceWindowTargetResult$OwnerInformation' => '<p>The updated owner.</p>', ], ], 'PSParameterName' => [ 'base' => NULL, 'refs' => [ 'DeleteParameterRequest$Name' => '<p>The name of the parameter to delete.</p>', 'GetParameterHistoryRequest$Name' => '<p>The name of a parameter you want to query.</p>', 'GetParameterRequest$Name' => '<p>The name of the parameter you want to query.</p>', 'GetParametersByPathRequest$Path' => '<p>The hierarchy for the parameter. Hierarchies start with a forward slash (/) and end with the parameter name. A parameter name hierarchy can have a maximum of 15 levels. Here is an example of a hierarchy: <code>/Finance/Prod/IAD/WinServ2016/license33</code> </p>', 'LabelParameterVersionRequest$Name' => '<p>The parameter name on which you want to attach one or more labels.</p>', 'Parameter$Name' => '<p>The name of the parameter.</p>', 'ParameterHistory$Name' => '<p>The name of the parameter.</p>', 'ParameterMetadata$Name' => '<p>The parameter name.</p>', 'ParameterNameList$member' => NULL, 'PutParameterRequest$Name' => '<p>The fully qualified name of the parameter that you want to add to the system. The fully qualified name includes the complete hierarchy of the parameter path and name. For parameters in a hierarchy, you must include a leading forward slash character (/) when you create or reference a parameter. For example: <code>/Dev/DBServer/MySQL/db-string13</code> </p> <p>Naming Constraints:</p> <ul> <li> <p>Parameter names are case sensitive.</p> </li> <li> <p>A parameter name must be unique within an AWS Region</p> </li> <li> <p>A parameter name can\'t be prefixed with "aws" or "ssm" (case-insensitive).</p> </li> <li> <p>Parameter names can include only the following symbols and letters: <code>a-zA-Z0-9_.-/</code> </p> </li> <li> <p>A parameter name can\'t include spaces.</p> </li> <li> <p>Parameter hierarchies are limited to a maximum depth of fifteen levels.</p> </li> </ul> <p>For additional information about valid values for parameter names, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-parameter-name-constraints.html">About requirements and constraints for parameter names</a> in the <i>AWS Systems Manager User Guide</i>.</p> <note> <p>The maximum length constraint listed below includes capacity for additional system attributes that are not part of the name. The maximum length for a parameter name, including the full length of the parameter ARN, is 1011 characters. For example, the length of the following parameter name is 65 characters, not 20 characters:</p> <p> <code>arn:aws:ssm:us-east-2:111122223333:parameter/ExampleParameterName</code> </p> </note>', ], ], 'PSParameterSelector' => [ 'base' => NULL, 'refs' => [ 'Parameter$Selector' => '<p>Either the version number or the label used to retrieve the parameter value. Specify selectors by using one of the following formats:</p> <p>parameter_name:version</p> <p>parameter_name:label</p>', ], ], 'PSParameterValue' => [ 'base' => NULL, 'refs' => [ 'Parameter$Value' => '<p>The parameter value.</p>', 'ParameterHistory$Value' => '<p>The parameter value.</p>', 'PutParameterRequest$Value' => '<p>The parameter value that you want to add to the system. Standard parameters have a value limit of 4 KB. Advanced parameters have a value limit of 8 KB.</p>', ], ], 'PSParameterVersion' => [ 'base' => NULL, 'refs' => [ 'LabelParameterVersionRequest$ParameterVersion' => '<p>The specific version of the parameter on which you want to attach one or more labels. If no version is specified, the system attaches the label to the latest version.</p>', 'LabelParameterVersionResult$ParameterVersion' => '<p>The version of the parameter that has been labeled.</p>', 'Parameter$Version' => '<p>The parameter version.</p>', 'ParameterHistory$Version' => '<p>The parameter version.</p>', 'ParameterMetadata$Version' => '<p>The parameter version.</p>', 'PutParameterResult$Version' => '<p>The new version number of a parameter. If you edit a parameter value, Parameter Store automatically creates a new version and assigns this new version a unique ID. You can reference a parameter version ID in API actions or in Systems Manager documents (SSM documents). By default, if you don\'t specify a specific version, the system returns the latest parameter value when a parameter is called.</p>', ], ], 'Parameter' => [ 'base' => '<p>An Systems Manager parameter in Parameter Store.</p>', 'refs' => [ 'GetParameterResult$Parameter' => '<p>Information about a parameter.</p>', 'ParameterList$member' => NULL, ], ], 'ParameterAlreadyExists' => [ 'base' => '<p>The parameter already exists. You can\'t create duplicate parameters.</p>', 'refs' => [], ], 'ParameterDataType' => [ 'base' => NULL, 'refs' => [ 'Parameter$DataType' => '<p>The data type of the parameter, such as <code>text</code> or <code>aws:ec2:image</code>. The default is <code>text</code>.</p>', 'ParameterHistory$DataType' => '<p>The data type of the parameter, such as <code>text</code> or <code>aws:ec2:image</code>. The default is <code>text</code>.</p>', 'ParameterMetadata$DataType' => '<p>The data type of the parameter, such as <code>text</code> or <code>aws:ec2:image</code>. The default is <code>text</code>.</p>', 'PutParameterRequest$DataType' => '<p>The data type for a <code>String</code> parameter. Supported data types include plain text and Amazon Machine Image IDs.</p> <p> <b>The following data type values are supported.</b> </p> <ul> <li> <p> <code>text</code> </p> </li> <li> <p> <code>aws:ec2:image</code> </p> </li> </ul> <p>When you create a <code>String</code> parameter and specify <code>aws:ec2:image</code>, Systems Manager validates the parameter value is in the required format, such as <code>ami-12345abcdeEXAMPLE</code>, and that the specified AMI is available in your AWS account. For more information, see <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-ec2-aliases.html">Native parameter support for Amazon Machine Image IDs</a> in the <i>AWS Systems Manager User Guide</i>.</p>', ], ], 'ParameterDescription' => [ 'base' => NULL, 'refs' => [ 'ParameterHistory$Description' => '<p>Information about the parameter.</p>', 'ParameterMetadata$Description' => '<p>Description of the parameter actions.</p>', 'PutParameterRequest$Description' => '<p>Information about the parameter that you want to add to the system. Optional but recommended.</p> <important> <p>Do not enter personally identifiable information in this field.</p> </important>', ], ], 'ParameterHistory' => [ 'base' => '<p>Information about parameter usage.</p>', 'refs' => [ 'ParameterHistoryList$member' => NULL, ], ], 'ParameterHistoryList' => [ 'base' => NULL, 'refs' => [ 'GetParameterHistoryResult$Parameters' => '<p>A list of parameters returned by the request.</p>', ], ], 'ParameterInlinePolicy' => [ 'base' => '<p>One or more policies assigned to a parameter.</p>', 'refs' => [ 'ParameterPolicyList$member' => NULL, ], ], 'ParameterKeyId' => [ 'base' => NULL, 'refs' => [ 'ParameterHistory$KeyId' => '<p>The ID of the query key used for this parameter.</p>', 'ParameterMetadata$KeyId' => '<p>The ID of the query key used for this parameter.</p>', 'PutParameterRequest$KeyId' => '<p>The KMS Key ID that you want to use to encrypt a parameter. Either the default AWS Key Management Service (AWS KMS) key automatically assigned to your AWS account or a custom key. Required for parameters that use the <code>SecureString</code> data type.</p> <p>If you don\'t specify a key ID, the system uses the default key associated with your AWS account.</p> <ul> <li> <p>To use your default AWS KMS key, choose the <code>SecureString</code> data type, and do <i>not</i> specify the <code>Key ID</code> when you create the parameter. The system automatically populates <code>Key ID</code> with your default KMS key.</p> </li> <li> <p>To use a custom KMS key, choose the <code>SecureString</code> data type with the <code>Key ID</code> parameter.</p> </li> </ul>', ], ], 'ParameterLabel' => [ 'base' => NULL, 'refs' => [ 'ParameterLabelList$member' => NULL, ], ], 'ParameterLabelList' => [ 'base' => NULL, 'refs' => [ 'LabelParameterVersionRequest$Labels' => '<p>One or more labels to attach to the specified parameter version.</p>', 'LabelParameterVersionResult$InvalidLabels' => '<p>The label does not meet the requirements. For information about parameter label requirements, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html">Labeling parameters</a> in the <i>AWS Systems Manager User Guide</i>.</p>', 'ParameterHistory$Labels' => '<p>Labels assigned to the parameter version.</p>', ], ], 'ParameterLimitExceeded' => [ 'base' => '<p>You have exceeded the number of parameters for this AWS account. Delete one or more parameters and try again.</p>', 'refs' => [], ], 'ParameterList' => [ 'base' => NULL, 'refs' => [ 'GetParametersByPathResult$Parameters' => '<p>A list of parameters found in the specified hierarchy.</p>', 'GetParametersResult$Parameters' => '<p>A list of details for a parameter.</p>', ], ], 'ParameterMaxVersionLimitExceeded' => [ 'base' => '<p>The parameter exceeded the maximum number of allowed versions.</p>', 'refs' => [], ], 'ParameterMetadata' => [ 'base' => '<p>Metadata includes information like the ARN of the last user and the date/time the parameter was last used.</p>', 'refs' => [ 'ParameterMetadataList$member' => NULL, ], ], 'ParameterMetadataList' => [ 'base' => NULL, 'refs' => [ 'DescribeParametersResult$Parameters' => '<p>Parameters returned by the request.</p>', ], ], 'ParameterName' => [ 'base' => NULL, 'refs' => [ 'Parameters$key' => NULL, ], ], 'ParameterNameList' => [ 'base' => NULL, 'refs' => [ 'DeleteParametersRequest$Names' => '<p>The names of the parameters to delete.</p>', 'DeleteParametersResult$DeletedParameters' => '<p>The names of the deleted parameters.</p>', 'DeleteParametersResult$InvalidParameters' => '<p>The names of parameters that weren\'t deleted because the parameters are not valid.</p>', 'GetParametersRequest$Names' => '<p>Names of the parameters for which you want to query information.</p>', 'GetParametersResult$InvalidParameters' => '<p>A list of parameters that are not formatted correctly or do not run during an execution.</p>', ], ], 'ParameterNotFound' => [ 'base' => '<p>The parameter could not be found. Verify the name and try again.</p>', 'refs' => [], ], 'ParameterPatternMismatchException' => [ 'base' => '<p>The parameter name is not valid.</p>', 'refs' => [], ], 'ParameterPolicies' => [ 'base' => NULL, 'refs' => [ 'PutParameterRequest$Policies' => '<p>One or more policies to apply to a parameter. This action takes a JSON array. Parameter Store supports the following policy types:</p> <p>Expiration: This policy deletes the parameter after it expires. When you create the policy, you specify the expiration date. You can update the expiration date and time by updating the policy. Updating the <i>parameter</i> does not affect the expiration date and time. When the expiration time is reached, Parameter Store deletes the parameter.</p> <p>ExpirationNotification: This policy triggers an event in Amazon CloudWatch Events that notifies you about the expiration. By using this policy, you can receive notification before or after the expiration time is reached, in units of days or hours.</p> <p>NoChangeNotification: This policy triggers a CloudWatch event if a parameter has not been modified for a specified period of time. This policy type is useful when, for example, a secret needs to be changed within a period of time, but it has not been changed.</p> <p>All existing policies are preserved until you send new policies or an empty policy. For more information about parameter policies, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-policies.html">Assigning parameter policies</a>. </p>', ], ], 'ParameterPolicyList' => [ 'base' => NULL, 'refs' => [ 'ParameterHistory$Policies' => '<p>Information about the policies assigned to a parameter.</p> <p> <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-policies.html">Assigning parameter policies</a> in the <i>AWS Systems Manager User Guide</i>.</p>', 'ParameterMetadata$Policies' => '<p>A list of policies associated with a parameter.</p>', ], ], 'ParameterStringFilter' => [ 'base' => '<p>One or more filters. Use a filter to return a more specific list of results.</p> <important> <p>The <code>ParameterStringFilter</code> object is used by the <a>DescribeParameters</a> and <a>GetParametersByPath</a> API actions. However, not all of the pattern values listed for <code>Key</code> can be used with both actions.</p> <p>For <code>DescribeActions</code>, all of the listed patterns are valid, with the exception of <code>Label</code>.</p> <p>For <code>GetParametersByPath</code>, the following patterns listed for <code>Key</code> are not valid: <code>Name</code>, <code>Path</code>, and <code>Tier</code>.</p> <p>For examples of CLI commands demonstrating valid parameter filter constructions, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-search.html">Searching for Systems Manager parameters</a> in the <i>AWS Systems Manager User Guide</i>.</p> </important>', 'refs' => [ 'ParameterStringFilterList$member' => NULL, ], ], 'ParameterStringFilterKey' => [ 'base' => NULL, 'refs' => [ 'ParameterStringFilter$Key' => '<p>The name of the filter.</p>', ], ], 'ParameterStringFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeParametersRequest$ParameterFilters' => '<p>Filters to limit the request results.</p>', 'GetParametersByPathRequest$ParameterFilters' => '<p>Filters to limit the request results.</p>', ], ], 'ParameterStringFilterValue' => [ 'base' => NULL, 'refs' => [ 'ParameterStringFilterValueList$member' => NULL, ], ], 'ParameterStringFilterValueList' => [ 'base' => NULL, 'refs' => [ 'ParameterStringFilter$Values' => '<p>The value you want to search for.</p>', ], ], 'ParameterStringQueryOption' => [ 'base' => NULL, 'refs' => [ 'ParameterStringFilter$Option' => '<p>For all filters used with <a>DescribeParameters</a>, valid options include <code>Equals</code> and <code>BeginsWith</code>. The <code>Name</code> filter additionally supports the <code>Contains</code> option. (Exception: For filters using the key <code>Path</code>, valid options include <code>Recursive</code> and <code>OneLevel</code>.)</p> <p>For filters used with <a>GetParametersByPath</a>, valid options include <code>Equals</code> and <code>BeginsWith</code>. (Exception: For filters using the key <code>Label</code>, the only valid option is <code>Equals</code>.)</p>', ], ], 'ParameterTier' => [ 'base' => NULL, 'refs' => [ 'ParameterHistory$Tier' => '<p>The parameter tier.</p>', 'ParameterMetadata$Tier' => '<p>The parameter tier.</p>', 'PutParameterRequest$Tier' => '<p>The parameter tier to assign to a parameter.</p> <p>Parameter Store offers a standard tier and an advanced tier for parameters. Standard parameters have a content size limit of 4 KB and can\'t be configured to use parameter policies. You can create a maximum of 10,000 standard parameters for each Region in an AWS account. Standard parameters are offered at no additional cost. </p> <p>Advanced parameters have a content size limit of 8 KB and can be configured to use parameter policies. You can create a maximum of 100,000 advanced parameters for each Region in an AWS account. Advanced parameters incur a charge. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-advanced-parameters.html">Standard and advanced parameter tiers</a> in the <i>AWS Systems Manager User Guide</i>.</p> <p>You can change a standard parameter to an advanced parameter any time. But you can\'t revert an advanced parameter to a standard parameter. Reverting an advanced parameter to a standard parameter would result in data loss because the system would truncate the size of the parameter from 8 KB to 4 KB. Reverting would also remove any policies attached to the parameter. Lastly, advanced parameters use a different form of encryption than standard parameters. </p> <p>If you no longer need an advanced parameter, or if you no longer want to incur charges for an advanced parameter, you must delete it and recreate it as a new standard parameter. </p> <p> <b>Using the Default Tier Configuration</b> </p> <p>In <code>PutParameter</code> requests, you can specify the tier to create the parameter in. Whenever you specify a tier in the request, Parameter Store creates or updates the parameter according to that request. However, if you do not specify a tier in a request, Parameter Store assigns the tier based on the current Parameter Store default tier configuration.</p> <p>The default tier when you begin using Parameter Store is the standard-parameter tier. If you use the advanced-parameter tier, you can specify one of the following as the default:</p> <ul> <li> <p> <b>Advanced</b>: With this option, Parameter Store evaluates all requests as advanced parameters. </p> </li> <li> <p> <b>Intelligent-Tiering</b>: With this option, Parameter Store evaluates each request to determine if the parameter is standard or advanced. </p> <p>If the request doesn\'t include any options that require an advanced parameter, the parameter is created in the standard-parameter tier. If one or more options requiring an advanced parameter are included in the request, Parameter Store create a parameter in the advanced-parameter tier.</p> <p>This approach helps control your parameter-related costs by always creating standard parameters unless an advanced parameter is necessary. </p> </li> </ul> <p>Options that require an advanced parameter include the following:</p> <ul> <li> <p>The content size of the parameter is more than 4 KB.</p> </li> <li> <p>The parameter uses a parameter policy.</p> </li> <li> <p>More than 10,000 parameters already exist in your AWS account in the current Region.</p> </li> </ul> <p>For more information about configuring the default tier option, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/ps-default-tier.html">Specifying a default parameter tier</a> in the <i>AWS Systems Manager User Guide</i>.</p>', 'PutParameterResult$Tier' => '<p>The tier assigned to the parameter.</p>', ], ], 'ParameterType' => [ 'base' => NULL, 'refs' => [ 'Parameter$Type' => '<p>The type of parameter. Valid values include the following: <code>String</code>, <code>StringList</code>, and <code>SecureString</code>.</p>', 'ParameterHistory$Type' => '<p>The type of parameter used.</p>', 'ParameterMetadata$Type' => '<p>The type of parameter. Valid parameter types include the following: <code>String</code>, <code>StringList</code>, and <code>SecureString</code>.</p>', 'PutParameterRequest$Type' => '<p>The type of parameter that you want to add to the system.</p> <note> <p> <code>SecureString</code> is not currently supported for AWS CloudFormation templates or in the China Regions.</p> </note> <p>Items in a <code>StringList</code> must be separated by a comma (,). You can\'t use other punctuation or special character to escape items in the list. If you have a parameter value that requires a comma, then use the <code>String</code> data type.</p> <important> <p>Specifying a parameter type is not required when updating a parameter. You must specify a parameter type when creating a parameter.</p> </important>', ], ], 'ParameterValue' => [ 'base' => NULL, 'refs' => [ 'ParameterValueList$member' => NULL, 'TargetParameterList$member' => NULL, ], ], 'ParameterValueList' => [ 'base' => NULL, 'refs' => [ 'Parameters$value' => NULL, ], ], 'ParameterVersionLabelLimitExceeded' => [ 'base' => '<p>A parameter version can have a maximum of ten labels.</p>', 'refs' => [], ], 'ParameterVersionNotFound' => [ 'base' => '<p>The specified parameter version was not found. Verify the parameter name and version, and try again.</p>', 'refs' => [], ], 'Parameters' => [ 'base' => NULL, 'refs' => [ 'AssociationDescription$Parameters' => '<p>A description of the parameters for a document. </p>', 'AssociationVersionInfo$Parameters' => '<p>Parameters specified when the association version was created.</p>', 'Command$Parameters' => '<p>The parameter values to be inserted in the document when running the command.</p>', 'CreateAssociationBatchRequestEntry$Parameters' => '<p>A description of the parameters for a document. </p>', 'CreateAssociationRequest$Parameters' => '<p>The parameters for the runtime configuration of the document.</p>', 'MaintenanceWindowRunCommandParameters$Parameters' => '<p>The parameters for the RUN_COMMAND task execution.</p>', 'SendCommandRequest$Parameters' => '<p>The required and optional parameters specified in the document being run.</p>', 'UpdateAssociationRequest$Parameters' => '<p>The parameters you want to update for the association. If you create a parameter using Parameter Store, you can reference the parameter using {{ssm:parameter-name}}</p>', ], ], 'ParametersFilter' => [ 'base' => '<p>This data type is deprecated. Instead, use <a>ParameterStringFilter</a>.</p>', 'refs' => [ 'ParametersFilterList$member' => NULL, ], ], 'ParametersFilterKey' => [ 'base' => NULL, 'refs' => [ 'ParametersFilter$Key' => '<p>The name of the filter.</p>', ], ], 'ParametersFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeParametersRequest$Filters' => '<p>This data type is deprecated. Instead, use <code>ParameterFilters</code>.</p>', ], ], 'ParametersFilterValue' => [ 'base' => NULL, 'refs' => [ 'ParametersFilterValueList$member' => NULL, ], ], 'ParametersFilterValueList' => [ 'base' => NULL, 'refs' => [ 'ParametersFilter$Values' => '<p>The filter values.</p>', ], ], 'Patch' => [ 'base' => '<p>Represents metadata about a patch.</p>', 'refs' => [ 'EffectivePatch$Patch' => '<p>Provides metadata for a patch, including information such as the KB ID, severity, classification and a URL for where more information can be obtained about the patch.</p>', 'PatchList$member' => NULL, ], ], 'PatchAction' => [ 'base' => NULL, 'refs' => [ 'CreatePatchBaselineRequest$RejectedPatchesAction' => '<p>The action for Patch Manager to take on patches included in the RejectedPackages list.</p> <ul> <li> <p> <b>ALLOW_AS_DEPENDENCY</b>: A package in the Rejected patches list is installed only if it is a dependency of another package. It is considered compliant with the patch baseline, and its status is reported as <i>InstalledOther</i>. This is the default action if no option is specified.</p> </li> <li> <p> <b>BLOCK</b>: Packages in the RejectedPatches list, and packages that include them as dependencies, are not installed under any circumstances. If a package was installed before it was added to the Rejected patches list, it is considered non-compliant with the patch baseline, and its status is reported as <i>InstalledRejected</i>.</p> </li> </ul>', 'GetPatchBaselineResult$RejectedPatchesAction' => '<p>The action specified to take on patches included in the RejectedPatches list. A patch can be allowed only if it is a dependency of another package, or blocked entirely along with packages that include it as a dependency.</p>', 'UpdatePatchBaselineRequest$RejectedPatchesAction' => '<p>The action for Patch Manager to take on patches included in the RejectedPackages list.</p> <ul> <li> <p> <b>ALLOW_AS_DEPENDENCY</b>: A package in the Rejected patches list is installed only if it is a dependency of another package. It is considered compliant with the patch baseline, and its status is reported as <i>InstalledOther</i>. This is the default action if no option is specified.</p> </li> <li> <p> <b>BLOCK</b>: Packages in the RejectedPatches list, and packages that include them as dependencies, are not installed under any circumstances. If a package was installed before it was added to the Rejected patches list, it is considered non-compliant with the patch baseline, and its status is reported as <i>InstalledRejected</i>.</p> </li> </ul>', 'UpdatePatchBaselineResult$RejectedPatchesAction' => '<p>The action specified to take on patches included in the RejectedPatches list. A patch can be allowed only if it is a dependency of another package, or blocked entirely along with packages that include it as a dependency.</p>', ], ], 'PatchBaselineIdentity' => [ 'base' => '<p>Defines the basic information about a patch baseline.</p>', 'refs' => [ 'PatchBaselineIdentityList$member' => NULL, 'PatchGroupPatchBaselineMapping$BaselineIdentity' => '<p>The patch baseline the patch group is registered with.</p>', ], ], 'PatchBaselineIdentityList' => [ 'base' => NULL, 'refs' => [ 'DescribePatchBaselinesResult$BaselineIdentities' => '<p>An array of PatchBaselineIdentity elements.</p>', ], ], 'PatchBaselineMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeAvailablePatchesRequest$MaxResults' => '<p>The maximum number of patches to return (per page).</p>', 'DescribeEffectivePatchesForPatchBaselineRequest$MaxResults' => '<p>The maximum number of patches to return (per page).</p>', 'DescribePatchBaselinesRequest$MaxResults' => '<p>The maximum number of patch baselines to return (per page).</p>', 'DescribePatchGroupsRequest$MaxResults' => '<p>The maximum number of patch groups to return (per page).</p>', ], ], 'PatchClassification' => [ 'base' => NULL, 'refs' => [ 'Patch$Classification' => '<p>The classification of the patch (for example, SecurityUpdates, Updates, CriticalUpdates).</p>', 'PatchComplianceData$Classification' => '<p>The classification of the patch (for example, SecurityUpdates, Updates, CriticalUpdates).</p>', ], ], 'PatchComplianceData' => [ 'base' => '<p>Information about the state of a patch on a particular instance as it relates to the patch baseline used to patch the instance.</p>', 'refs' => [ 'PatchComplianceDataList$member' => NULL, ], ], 'PatchComplianceDataList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstancePatchesResult$Patches' => '<p>Each entry in the array is a structure containing:</p> <p>Title (string)</p> <p>KBId (string)</p> <p>Classification (string)</p> <p>Severity (string)</p> <p>State (string, such as "INSTALLED" or "FAILED")</p> <p>InstalledTime (DateTime)</p> <p>InstalledBy (string)</p>', ], ], 'PatchComplianceDataState' => [ 'base' => NULL, 'refs' => [ 'PatchComplianceData$State' => '<p>The state of the patch on the instance, such as INSTALLED or FAILED.</p> <p>For descriptions of each patch state, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-compliance-about.html#sysman-compliance-monitor-patch">About patch compliance</a> in the <i>AWS Systems Manager User Guide</i>.</p>', ], ], 'PatchComplianceLevel' => [ 'base' => NULL, 'refs' => [ 'CreatePatchBaselineRequest$ApprovedPatchesComplianceLevel' => '<p>Defines the compliance level for approved patches. This means that if an approved patch is reported as missing, this is the severity of the compliance violation. The default value is UNSPECIFIED.</p>', 'GetPatchBaselineResult$ApprovedPatchesComplianceLevel' => '<p>Returns the specified compliance severity level for approved patches in the patch baseline.</p>', 'PatchRule$ComplianceLevel' => '<p>A compliance severity level for all approved patches in a patch baseline.</p>', 'PatchStatus$ComplianceLevel' => '<p>The compliance severity level for a patch.</p>', 'UpdatePatchBaselineRequest$ApprovedPatchesComplianceLevel' => '<p>Assigns a new compliance severity level to an existing patch baseline.</p>', 'UpdatePatchBaselineResult$ApprovedPatchesComplianceLevel' => '<p>The compliance severity level assigned to the patch baseline after the update completed.</p>', ], ], 'PatchComplianceMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeInstancePatchStatesForPatchGroupRequest$MaxResults' => '<p>The maximum number of patches to return (per page).</p>', 'DescribeInstancePatchStatesRequest$MaxResults' => '<p>The maximum number of instances to return (per page).</p>', 'DescribeInstancePatchesRequest$MaxResults' => '<p>The maximum number of patches to return (per page).</p>', ], ], 'PatchContentUrl' => [ 'base' => NULL, 'refs' => [ 'Patch$ContentUrl' => '<p>The URL where more information can be obtained about the patch.</p>', ], ], 'PatchDeploymentStatus' => [ 'base' => NULL, 'refs' => [ 'PatchStatus$DeploymentStatus' => '<p>The approval status of a patch (APPROVED, PENDING_APPROVAL, EXPLICIT_APPROVED, EXPLICIT_REJECTED).</p>', ], ], 'PatchDescription' => [ 'base' => NULL, 'refs' => [ 'Patch$Description' => '<p>The description of the patch.</p>', ], ], 'PatchFailedCount' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$FailedCount' => '<p>The number of patches from the patch baseline that were attempted to be installed during the last patching operation, but failed to install.</p>', ], ], 'PatchFilter' => [ 'base' => '<p> Defines which patches should be included in a patch baseline.</p> <p>A patch filter consists of a key and a set of values. The filter key is a patch property. For example, the available filter keys for WINDOWS are PATCH_SET, PRODUCT, PRODUCT_FAMILY, CLASSIFICATION, and MSRC_SEVERITY. The filter values define a matching criterion for the patch property indicated by the key. For example, if the filter key is PRODUCT and the filter values are ["Office 2013", "Office 2016"], then the filter accepts all patches where product name is either "Office 2013" or "Office 2016". The filter values can be exact values for the patch property given as a key, or a wildcard (*), which matches all values.</p> <p>You can view lists of valid values for the patch properties by running the <code>DescribePatchProperties</code> command. For information about which patch properties can be used with each major operating system, see <a>DescribePatchProperties</a>.</p>', 'refs' => [ 'PatchFilterList$member' => NULL, ], ], 'PatchFilterGroup' => [ 'base' => '<p>A set of patch filters, typically used for approval rules.</p>', 'refs' => [ 'CreatePatchBaselineRequest$GlobalFilters' => '<p>A set of global filters used to include patches in the baseline.</p>', 'GetPatchBaselineResult$GlobalFilters' => '<p>A set of global filters used to exclude patches from the baseline.</p>', 'PatchRule$PatchFilterGroup' => '<p>The patch filter group that defines the criteria for the rule.</p>', 'UpdatePatchBaselineRequest$GlobalFilters' => '<p>A set of global filters used to include patches in the baseline.</p>', 'UpdatePatchBaselineResult$GlobalFilters' => '<p>A set of global filters used to exclude patches from the baseline.</p>', ], ], 'PatchFilterKey' => [ 'base' => NULL, 'refs' => [ 'PatchFilter$Key' => '<p>The key for the filter.</p> <p>Run the <a>DescribePatchProperties</a> command to view lists of valid keys for each operating system type.</p>', ], ], 'PatchFilterList' => [ 'base' => NULL, 'refs' => [ 'PatchFilterGroup$PatchFilters' => '<p>The set of patch filters that make up the group.</p>', ], ], 'PatchFilterValue' => [ 'base' => NULL, 'refs' => [ 'PatchFilterValueList$member' => NULL, ], ], 'PatchFilterValueList' => [ 'base' => NULL, 'refs' => [ 'PatchFilter$Values' => '<p>The value for the filter key.</p> <p>Run the <a>DescribePatchProperties</a> command to view lists of valid values for each key based on operating system type.</p>', ], ], 'PatchGroup' => [ 'base' => NULL, 'refs' => [ 'DeregisterPatchBaselineForPatchGroupRequest$PatchGroup' => '<p>The name of the patch group that should be deregistered from the patch baseline.</p>', 'DeregisterPatchBaselineForPatchGroupResult$PatchGroup' => '<p>The name of the patch group deregistered from the patch baseline.</p>', 'DescribeInstancePatchStatesForPatchGroupRequest$PatchGroup' => '<p>The name of the patch group for which the patch state information should be retrieved.</p>', 'DescribePatchGroupStateRequest$PatchGroup' => '<p>The name of the patch group whose patch snapshot should be retrieved.</p>', 'GetPatchBaselineForPatchGroupRequest$PatchGroup' => '<p>The name of the patch group whose patch baseline should be retrieved.</p>', 'GetPatchBaselineForPatchGroupResult$PatchGroup' => '<p>The name of the patch group.</p>', 'InstancePatchState$PatchGroup' => '<p>The name of the patch group the managed instance belongs to.</p>', 'PatchGroupList$member' => NULL, 'PatchGroupPatchBaselineMapping$PatchGroup' => '<p>The name of the patch group registered with the patch baseline.</p>', 'RegisterPatchBaselineForPatchGroupRequest$PatchGroup' => '<p>The name of the patch group that should be registered with the patch baseline.</p>', 'RegisterPatchBaselineForPatchGroupResult$PatchGroup' => '<p>The name of the patch group registered with the patch baseline.</p>', ], ], 'PatchGroupList' => [ 'base' => NULL, 'refs' => [ 'GetPatchBaselineResult$PatchGroups' => '<p>Patch groups included in the patch baseline.</p>', ], ], 'PatchGroupPatchBaselineMapping' => [ 'base' => '<p>The mapping between a patch group and the patch baseline the patch group is registered with.</p>', 'refs' => [ 'PatchGroupPatchBaselineMappingList$member' => NULL, ], ], 'PatchGroupPatchBaselineMappingList' => [ 'base' => NULL, 'refs' => [ 'DescribePatchGroupsResult$Mappings' => '<p>Each entry in the array contains:</p> <p>PatchGroup: string (between 1 and 256 characters, Regex: ^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$)</p> <p>PatchBaselineIdentity: A PatchBaselineIdentity element. </p>', ], ], 'PatchId' => [ 'base' => NULL, 'refs' => [ 'Patch$Id' => '<p>The ID of the patch (this is different than the Microsoft Knowledge Base ID).</p>', 'PatchIdList$member' => NULL, ], ], 'PatchIdList' => [ 'base' => NULL, 'refs' => [ 'CreatePatchBaselineRequest$ApprovedPatches' => '<p>A list of explicitly approved patches for the baseline.</p> <p>For information about accepted formats for lists of approved patches and rejected patches, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About package name formats for approved and rejected patch lists</a> in the <i>AWS Systems Manager User Guide</i>.</p>', 'CreatePatchBaselineRequest$RejectedPatches' => '<p>A list of explicitly rejected patches for the baseline.</p> <p>For information about accepted formats for lists of approved patches and rejected patches, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About package name formats for approved and rejected patch lists</a> in the <i>AWS Systems Manager User Guide</i>.</p>', 'GetPatchBaselineResult$ApprovedPatches' => '<p>A list of explicitly approved patches for the baseline.</p>', 'GetPatchBaselineResult$RejectedPatches' => '<p>A list of explicitly rejected patches for the baseline.</p>', 'UpdatePatchBaselineRequest$ApprovedPatches' => '<p>A list of explicitly approved patches for the baseline.</p> <p>For information about accepted formats for lists of approved patches and rejected patches, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About package name formats for approved and rejected patch lists</a> in the <i>AWS Systems Manager User Guide</i>.</p>', 'UpdatePatchBaselineRequest$RejectedPatches' => '<p>A list of explicitly rejected patches for the baseline.</p> <p>For information about accepted formats for lists of approved patches and rejected patches, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html">About package name formats for approved and rejected patch lists</a> in the <i>AWS Systems Manager User Guide</i>.</p>', 'UpdatePatchBaselineResult$ApprovedPatches' => '<p>A list of explicitly approved patches for the baseline.</p>', 'UpdatePatchBaselineResult$RejectedPatches' => '<p>A list of explicitly rejected patches for the baseline.</p>', ], ], 'PatchInstalledCount' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$InstalledCount' => '<p>The number of patches from the patch baseline that are installed on the instance.</p>', ], ], 'PatchInstalledOtherCount' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$InstalledOtherCount' => '<p>The number of patches not specified in the patch baseline that are installed on the instance.</p>', ], ], 'PatchInstalledPendingRebootCount' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$InstalledPendingRebootCount' => '<p>The number of patches installed by Patch Manager since the last time the instance was rebooted.</p>', ], ], 'PatchInstalledRejectedCount' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$InstalledRejectedCount' => '<p>The number of instances with patches installed that are specified in a RejectedPatches list. Patches with a status of <i>InstalledRejected</i> were typically installed before they were added to a RejectedPatches list.</p> <note> <p>If ALLOW_AS_DEPENDENCY is the specified option for RejectedPatchesAction, the value of InstalledRejectedCount will always be 0 (zero).</p> </note>', ], ], 'PatchKbNumber' => [ 'base' => NULL, 'refs' => [ 'Patch$KbNumber' => '<p>The Microsoft Knowledge Base ID of the patch.</p>', 'PatchComplianceData$KBId' => '<p>The operating system-specific ID of the patch.</p>', ], ], 'PatchLanguage' => [ 'base' => NULL, 'refs' => [ 'Patch$Language' => '<p>The language of the patch if it\'s language-specific.</p>', ], ], 'PatchList' => [ 'base' => NULL, 'refs' => [ 'DescribeAvailablePatchesResult$Patches' => '<p>An array of patches. Each entry in the array is a patch structure.</p>', ], ], 'PatchMissingCount' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$MissingCount' => '<p>The number of patches from the patch baseline that are applicable for the instance but aren\'t currently installed.</p>', ], ], 'PatchMsrcNumber' => [ 'base' => NULL, 'refs' => [ 'Patch$MsrcNumber' => '<p>The ID of the MSRC bulletin the patch is related to.</p>', ], ], 'PatchMsrcSeverity' => [ 'base' => NULL, 'refs' => [ 'Patch$MsrcSeverity' => '<p>The severity of the patch (for example Critical, Important, Moderate).</p>', ], ], 'PatchNotApplicableCount' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$NotApplicableCount' => '<p>The number of patches from the patch baseline that aren\'t applicable for the instance and therefore aren\'t installed on the instance. This number may be truncated if the list of patch names is very large. The number of patches beyond this limit are reported in <code>UnreportedNotApplicableCount</code>.</p>', ], ], 'PatchOperationType' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$Operation' => '<p>The type of patching operation that was performed: SCAN (assess patch compliance state) or INSTALL (install missing patches).</p>', ], ], 'PatchOrchestratorFilter' => [ 'base' => '<p>Defines a filter used in Patch Manager APIs.</p>', 'refs' => [ 'PatchOrchestratorFilterList$member' => NULL, ], ], 'PatchOrchestratorFilterKey' => [ 'base' => NULL, 'refs' => [ 'PatchOrchestratorFilter$Key' => '<p>The key for the filter.</p>', ], ], 'PatchOrchestratorFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeAvailablePatchesRequest$Filters' => '<p>Filters used to scope down the returned patches.</p>', 'DescribeInstancePatchesRequest$Filters' => '<p>An array of structures. Each entry in the array is a structure containing a Key, Value combination. Valid values for Key are <code>Classification</code> | <code>KBId</code> | <code>Severity</code> | <code>State</code>.</p>', 'DescribeMaintenanceWindowScheduleRequest$Filters' => '<p>Filters used to limit the range of results. For example, you can limit maintenance window executions to only those scheduled before or after a certain date and time.</p>', 'DescribePatchBaselinesRequest$Filters' => '<p>Each element in the array is a structure containing: </p> <p>Key: (string, "NAME_PREFIX" or "OWNER")</p> <p>Value: (array of strings, exactly 1 entry, between 1 and 255 characters)</p>', 'DescribePatchGroupsRequest$Filters' => '<p>One or more filters. Use a filter to return a more specific list of results.</p> <p>For <code>DescribePatchGroups</code>,valid filter keys include the following:</p> <ul> <li> <p> <code>NAME_PREFIX</code>: The name of the patch group. Wildcards (*) are accepted.</p> </li> <li> <p> <code>OPERATING_SYSTEM</code>: The supported operating system type to return results for. For valid operating system values, see <a>GetDefaultPatchBaselineRequest$OperatingSystem</a> in <a>CreatePatchBaseline</a>.</p> <p>Examples:</p> <ul> <li> <p> <code>--filters Key=NAME_PREFIX,Values=MyPatchGroup*</code> </p> </li> <li> <p> <code>--filters Key=OPERATING_SYSTEM,Values=AMAZON_LINUX_2</code> </p> </li> </ul> </li> </ul>', ], ], 'PatchOrchestratorFilterValue' => [ 'base' => NULL, 'refs' => [ 'PatchOrchestratorFilterValues$member' => NULL, ], ], 'PatchOrchestratorFilterValues' => [ 'base' => NULL, 'refs' => [ 'PatchOrchestratorFilter$Values' => '<p>The value for the filter.</p>', ], ], 'PatchProduct' => [ 'base' => NULL, 'refs' => [ 'Patch$Product' => '<p>The specific product the patch is applicable for (for example, WindowsServer2016).</p>', ], ], 'PatchProductFamily' => [ 'base' => NULL, 'refs' => [ 'Patch$ProductFamily' => '<p>The product family the patch is applicable for (for example, Windows).</p>', ], ], 'PatchPropertiesList' => [ 'base' => NULL, 'refs' => [ 'DescribePatchPropertiesResult$Properties' => '<p>A list of the properties for patches matching the filter request parameters.</p>', ], ], 'PatchProperty' => [ 'base' => NULL, 'refs' => [ 'DescribePatchPropertiesRequest$Property' => '<p>The patch property for which you want to view patch details. </p>', ], ], 'PatchPropertyEntry' => [ 'base' => NULL, 'refs' => [ 'PatchPropertiesList$member' => NULL, ], ], 'PatchRule' => [ 'base' => '<p>Defines an approval rule for a patch baseline.</p>', 'refs' => [ 'PatchRuleList$member' => NULL, ], ], 'PatchRuleGroup' => [ 'base' => '<p>A set of rules defining the approval rules for a patch baseline.</p>', 'refs' => [ 'CreatePatchBaselineRequest$ApprovalRules' => '<p>A set of rules used to include patches in the baseline.</p>', 'GetPatchBaselineResult$ApprovalRules' => '<p>A set of rules used to include patches in the baseline.</p>', 'UpdatePatchBaselineRequest$ApprovalRules' => '<p>A set of rules used to include patches in the baseline.</p>', 'UpdatePatchBaselineResult$ApprovalRules' => '<p>A set of rules used to include patches in the baseline.</p>', ], ], 'PatchRuleList' => [ 'base' => NULL, 'refs' => [ 'PatchRuleGroup$PatchRules' => '<p>The rules that make up the rule group.</p>', ], ], 'PatchSet' => [ 'base' => NULL, 'refs' => [ 'DescribePatchPropertiesRequest$PatchSet' => '<p>Indicates whether to list patches for the Windows operating system or for Microsoft applications. Not applicable for Linux operating systems.</p>', ], ], 'PatchSeverity' => [ 'base' => NULL, 'refs' => [ 'PatchComplianceData$Severity' => '<p>The severity of the patch (for example, Critical, Important, Moderate).</p>', ], ], 'PatchSource' => [ 'base' => '<p>Information about the patches to use to update the instances, including target operating systems and source repository. Applies to Linux instances only.</p>', 'refs' => [ 'PatchSourceList$member' => NULL, ], ], 'PatchSourceConfiguration' => [ 'base' => NULL, 'refs' => [ 'PatchSource$Configuration' => '<p>The value of the yum repo configuration. For example:</p> <p> <code>[main]</code> </p> <p> <code>cachedir=/var/cache/yum/$basesearch$releasever</code> </p> <p> <code>keepcache=0</code> </p> <p> <code>debuglevel=2</code> </p>', ], ], 'PatchSourceList' => [ 'base' => NULL, 'refs' => [ 'CreatePatchBaselineRequest$Sources' => '<p>Information about the patches to use to update the instances, including target operating systems and source repositories. Applies to Linux instances only.</p>', 'GetPatchBaselineResult$Sources' => '<p>Information about the patches to use to update the instances, including target operating systems and source repositories. Applies to Linux instances only.</p>', 'UpdatePatchBaselineRequest$Sources' => '<p>Information about the patches to use to update the instances, including target operating systems and source repositories. Applies to Linux instances only.</p>', 'UpdatePatchBaselineResult$Sources' => '<p>Information about the patches to use to update the instances, including target operating systems and source repositories. Applies to Linux instances only.</p>', ], ], 'PatchSourceName' => [ 'base' => NULL, 'refs' => [ 'PatchSource$Name' => '<p>The name specified to identify the patch source.</p>', ], ], 'PatchSourceProduct' => [ 'base' => NULL, 'refs' => [ 'PatchSourceProductList$member' => NULL, ], ], 'PatchSourceProductList' => [ 'base' => NULL, 'refs' => [ 'PatchSource$Products' => '<p>The specific operating system versions a patch repository applies to, such as "Ubuntu16.04", "AmazonLinux2016.09", "RedhatEnterpriseLinux7.2" or "Suse12.7". For lists of supported product values, see <a>PatchFilter</a>.</p>', ], ], 'PatchStatus' => [ 'base' => '<p>Information about the approval status of a patch.</p>', 'refs' => [ 'EffectivePatch$PatchStatus' => '<p>The status of the patch in a patch baseline. This includes information about whether the patch is currently approved, due to be approved by a rule, explicitly approved, or explicitly rejected and the date the patch was or will be approved.</p>', ], ], 'PatchStringDateTime' => [ 'base' => NULL, 'refs' => [ 'PatchRule$ApproveUntilDate' => '<p>The cutoff date for auto approval of released patches. Any patches released on or before this date are installed automatically. Not supported on Ubuntu Server.</p> <p>Enter dates in the format <code>YYYY-MM-DD</code>. For example, <code>2020-12-31</code>.</p>', ], ], 'PatchTitle' => [ 'base' => NULL, 'refs' => [ 'Patch$Title' => '<p>The title of the patch.</p>', 'PatchComplianceData$Title' => '<p>The title of the patch.</p>', ], ], 'PatchUnreportedNotApplicableCount' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$UnreportedNotApplicableCount' => '<p>The number of patches beyond the supported limit of <code>NotApplicableCount</code> that are not reported by name to Systems Manager Inventory.</p>', ], ], 'PatchVendor' => [ 'base' => NULL, 'refs' => [ 'Patch$Vendor' => '<p>The name of the vendor providing the patch.</p>', ], ], 'PingStatus' => [ 'base' => NULL, 'refs' => [ 'InstanceInformation$PingStatus' => '<p>Connection status of SSM Agent. </p>', ], ], 'PlatformType' => [ 'base' => NULL, 'refs' => [ 'InstanceInformation$PlatformType' => '<p>The operating system platform type. </p>', 'PlatformTypeList$member' => NULL, ], ], 'PlatformTypeList' => [ 'base' => NULL, 'refs' => [ 'DocumentDescription$PlatformTypes' => '<p>The list of OS platforms compatible with this Systems Manager document. </p>', 'DocumentIdentifier$PlatformTypes' => '<p>The operating system platform. </p>', ], ], 'PoliciesLimitExceededException' => [ 'base' => '<p>You specified more than the maximum number of allowed policies for the parameter. The maximum is 10.</p>', 'refs' => [], ], 'Product' => [ 'base' => NULL, 'refs' => [ 'GetDeployablePatchSnapshotForInstanceResult$Product' => '<p>Returns the specific operating system (for example Windows Server 2012 or Amazon Linux 2015.09) on the instance for the specified patch snapshot.</p>', ], ], 'ProgressCounters' => [ 'base' => '<p>An aggregate of step execution statuses displayed in the AWS Console for a multi-Region and multi-account Automation execution.</p>', 'refs' => [ 'AutomationExecution$ProgressCounters' => '<p>An aggregate of step execution statuses displayed in the AWS Console for a multi-Region and multi-account Automation execution.</p>', ], ], 'PutComplianceItemsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutComplianceItemsResult' => [ 'base' => NULL, 'refs' => [], ], 'PutInventoryMessage' => [ 'base' => NULL, 'refs' => [ 'PutInventoryResult$Message' => '<p>Information about the request.</p>', ], ], 'PutInventoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutInventoryResult' => [ 'base' => NULL, 'refs' => [], ], 'PutParameterRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutParameterResult' => [ 'base' => NULL, 'refs' => [], ], 'RebootOption' => [ 'base' => NULL, 'refs' => [ 'InstancePatchState$RebootOption' => '<p>Indicates the reboot option specified in the patch baseline.</p> <note> <p>Reboot options apply to <code>Install</code> operations only. Reboots are not attempted for Patch Manager <code>Scan</code> operations.</p> </note> <ul> <li> <p> <b>RebootIfNeeded</b>: Patch Manager tries to reboot the instance if it installed any patches, or if any patches are detected with a status of <code>InstalledPendingReboot</code>.</p> </li> <li> <p> <b>NoReboot</b>: Patch Manager attempts to install missing packages without trying to reboot the system. Patches installed with this option are assigned a status of <code>InstalledPendingReboot</code>. These patches might not be in effect until a reboot is performed.</p> </li> </ul>', ], ], 'Region' => [ 'base' => NULL, 'refs' => [ 'Regions$member' => NULL, ], ], 'Regions' => [ 'base' => NULL, 'refs' => [ 'TargetLocation$Regions' => '<p>The AWS Regions targeted by the current Automation execution.</p>', ], ], 'RegisterDefaultPatchBaselineRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterDefaultPatchBaselineResult' => [ 'base' => NULL, 'refs' => [], ], 'RegisterPatchBaselineForPatchGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterPatchBaselineForPatchGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'RegisterTargetWithMaintenanceWindowRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterTargetWithMaintenanceWindowResult' => [ 'base' => NULL, 'refs' => [], ], 'RegisterTaskWithMaintenanceWindowRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterTaskWithMaintenanceWindowResult' => [ 'base' => NULL, 'refs' => [], ], 'RegistrationLimit' => [ 'base' => NULL, 'refs' => [ 'Activation$RegistrationLimit' => '<p>The maximum number of managed instances that can be registered using this activation.</p>', 'CreateActivationRequest$RegistrationLimit' => '<p>Specify the maximum number of managed instances you want to register. The default value is 1 instance.</p>', ], ], 'RegistrationsCount' => [ 'base' => NULL, 'refs' => [ 'Activation$RegistrationsCount' => '<p>The number of managed instances already registered with this activation.</p>', ], ], 'RelatedOpsItem' => [ 'base' => '<p>An OpsItems that shares something in common with the current OpsItem. For example, related OpsItems can include OpsItems with similar error messages, impacted resources, or statuses for the impacted resource.</p>', 'refs' => [ 'RelatedOpsItems$member' => NULL, ], ], 'RelatedOpsItems' => [ 'base' => NULL, 'refs' => [ 'CreateOpsItemRequest$RelatedOpsItems' => '<p>One or more OpsItems that share something in common with the current OpsItems. For example, related OpsItems can include OpsItems with similar error messages, impacted resources, or statuses for the impacted resource.</p>', 'OpsItem$RelatedOpsItems' => '<p>One or more OpsItems that share something in common with the current OpsItem. For example, related OpsItems can include OpsItems with similar error messages, impacted resources, or statuses for the impacted resource.</p>', 'UpdateOpsItemRequest$RelatedOpsItems' => '<p>One or more OpsItems that share something in common with the current OpsItems. For example, related OpsItems can include OpsItems with similar error messages, impacted resources, or statuses for the impacted resource.</p>', ], ], 'RemainingCount' => [ 'base' => NULL, 'refs' => [ 'InventoryDeletionSummary$RemainingCount' => '<p>Remaining number of items to delete.</p>', 'InventoryDeletionSummaryItem$RemainingCount' => '<p>The remaining number of items to delete.</p>', ], ], 'RemoveTagsFromResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'RemoveTagsFromResourceResult' => [ 'base' => NULL, 'refs' => [], ], 'ResetServiceSettingRequest' => [ 'base' => '<p>The request body of the ResetServiceSetting API action.</p>', 'refs' => [], ], 'ResetServiceSettingResult' => [ 'base' => '<p>The result body of the ResetServiceSetting API action.</p>', 'refs' => [], ], 'ResolvedTargets' => [ 'base' => '<p>Information about targets that resolved during the Automation execution.</p>', 'refs' => [ 'AutomationExecution$ResolvedTargets' => '<p>A list of resolved targets in the rate control execution.</p>', 'AutomationExecutionMetadata$ResolvedTargets' => '<p>A list of targets that resolved during the execution.</p>', ], ], 'ResourceComplianceSummaryItem' => [ 'base' => '<p>Compliance summary information for a specific resource. </p>', 'refs' => [ 'ResourceComplianceSummaryItemList$member' => NULL, ], ], 'ResourceComplianceSummaryItemList' => [ 'base' => NULL, 'refs' => [ 'ListResourceComplianceSummariesResult$ResourceComplianceSummaryItems' => '<p>A summary count for specified or targeted managed instances. Summary count includes information about compliant and non-compliant State Manager associations, patch status, or custom items according to the filter criteria that you specify. </p>', ], ], 'ResourceCount' => [ 'base' => NULL, 'refs' => [ 'InventoryDeletionSummaryItem$Count' => '<p>A count of the number of deleted items.</p>', ], ], 'ResourceCountByStatus' => [ 'base' => NULL, 'refs' => [ 'AssociationExecution$ResourceCountByStatus' => '<p>An aggregate status of the resources in the execution based on the status type.</p>', ], ], 'ResourceDataSyncAWSKMSKeyARN' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncS3Destination$AWSKMSKeyARN' => '<p>The ARN of an encryption key for a destination in Amazon S3. Must belong to the same Region as the destination S3 bucket.</p>', ], ], 'ResourceDataSyncAlreadyExistsException' => [ 'base' => '<p>A sync configuration with the same name already exists.</p>', 'refs' => [], ], 'ResourceDataSyncAwsOrganizationsSource' => [ 'base' => '<p>Information about the AwsOrganizationsSource resource data sync source. A sync source of this type can synchronize data from AWS Organizations or, if an AWS Organization is not present, from multiple AWS Regions.</p>', 'refs' => [ 'ResourceDataSyncSource$AwsOrganizationsSource' => '<p>Information about the AwsOrganizationsSource resource data sync source. A sync source of this type can synchronize data from AWS Organizations.</p>', 'ResourceDataSyncSourceWithState$AwsOrganizationsSource' => '<p>The field name in <code>SyncSource</code> for the <code>ResourceDataSyncAwsOrganizationsSource</code> type.</p>', ], ], 'ResourceDataSyncConflictException' => [ 'base' => '<p>Another <code>UpdateResourceDataSync</code> request is being processed. Wait a few minutes and try again.</p>', 'refs' => [], ], 'ResourceDataSyncCountExceededException' => [ 'base' => '<p>You have exceeded the allowed maximum sync configurations.</p>', 'refs' => [], ], 'ResourceDataSyncCreatedTime' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncItem$SyncCreatedTime' => '<p>The date and time the configuration was created (UTC).</p>', ], ], 'ResourceDataSyncDestinationDataSharing' => [ 'base' => '<p>Synchronize Systems Manager Inventory data from multiple AWS accounts defined in AWS Organizations to a centralized S3 bucket. Data is synchronized to individual key prefixes in the central bucket. Each key prefix represents a different AWS account ID.</p>', 'refs' => [ 'ResourceDataSyncS3Destination$DestinationDataSharing' => '<p>Enables destination data sharing. By default, this field is <code>null</code>.</p>', ], ], 'ResourceDataSyncDestinationDataSharingType' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncDestinationDataSharing$DestinationDataSharingType' => '<p>The sharing data type. Only <code>Organization</code> is supported.</p>', ], ], 'ResourceDataSyncIncludeFutureRegions' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncSource$IncludeFutureRegions' => '<p>Whether to automatically synchronize and aggregate data from new AWS Regions when those Regions come online.</p>', 'ResourceDataSyncSourceWithState$IncludeFutureRegions' => '<p>Whether to automatically synchronize and aggregate data from new AWS Regions when those Regions come online.</p>', ], ], 'ResourceDataSyncInvalidConfigurationException' => [ 'base' => '<p>The specified sync configuration is invalid.</p>', 'refs' => [], ], 'ResourceDataSyncItem' => [ 'base' => '<p>Information about a Resource Data Sync configuration, including its current status and last successful sync.</p>', 'refs' => [ 'ResourceDataSyncItemList$member' => NULL, ], ], 'ResourceDataSyncItemList' => [ 'base' => NULL, 'refs' => [ 'ListResourceDataSyncResult$ResourceDataSyncItems' => '<p>A list of your current Resource Data Sync configurations and their statuses.</p>', ], ], 'ResourceDataSyncLastModifiedTime' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncItem$SyncLastModifiedTime' => '<p>The date and time the resource data sync was changed. </p>', ], ], 'ResourceDataSyncName' => [ 'base' => NULL, 'refs' => [ 'CreateResourceDataSyncRequest$SyncName' => '<p>A name for the configuration.</p>', 'DeleteResourceDataSyncRequest$SyncName' => '<p>The name of the configuration to delete.</p>', 'GetOpsSummaryRequest$SyncName' => '<p>Specify the name of a resource data sync to get.</p>', 'ResourceDataSyncAlreadyExistsException$SyncName' => NULL, 'ResourceDataSyncItem$SyncName' => '<p>The name of the Resource Data Sync.</p>', 'ResourceDataSyncNotFoundException$SyncName' => NULL, 'UpdateResourceDataSyncRequest$SyncName' => '<p>The name of the resource data sync you want to update.</p>', ], ], 'ResourceDataSyncNotFoundException' => [ 'base' => '<p>The specified sync name was not found.</p>', 'refs' => [], ], 'ResourceDataSyncOrganizationSourceType' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncAwsOrganizationsSource$OrganizationSourceType' => '<p>If an AWS Organization is present, this is either <code>OrganizationalUnits</code> or <code>EntireOrganization</code>. For <code>OrganizationalUnits</code>, the data is aggregated from a set of organization units. For <code>EntireOrganization</code>, the data is aggregated from the entire AWS Organization. </p>', ], ], 'ResourceDataSyncOrganizationalUnit' => [ 'base' => '<p>The AWS Organizations organizational unit data source for the sync.</p>', 'refs' => [ 'ResourceDataSyncOrganizationalUnitList$member' => NULL, ], ], 'ResourceDataSyncOrganizationalUnitId' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncOrganizationalUnit$OrganizationalUnitId' => '<p>The AWS Organization unit ID data source for the sync.</p>', ], ], 'ResourceDataSyncOrganizationalUnitList' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncAwsOrganizationsSource$OrganizationalUnits' => '<p>The AWS Organizations organization units included in the sync.</p>', ], ], 'ResourceDataSyncS3BucketName' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncS3Destination$BucketName' => '<p>The name of the S3 bucket where the aggregated data is stored.</p>', ], ], 'ResourceDataSyncS3Destination' => [ 'base' => '<p>Information about the target S3 bucket for the Resource Data Sync.</p>', 'refs' => [ 'CreateResourceDataSyncRequest$S3Destination' => '<p>Amazon S3 configuration details for the sync. This parameter is required if the <code>SyncType</code> value is SyncToDestination.</p>', 'ResourceDataSyncItem$S3Destination' => '<p>Configuration information for the target S3 bucket.</p>', ], ], 'ResourceDataSyncS3Format' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncS3Destination$SyncFormat' => '<p>A supported sync format. The following format is currently supported: JsonSerDe</p>', ], ], 'ResourceDataSyncS3Prefix' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncS3Destination$Prefix' => '<p>An Amazon S3 prefix for the bucket.</p>', ], ], 'ResourceDataSyncS3Region' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncS3Destination$Region' => '<p>The AWS Region with the S3 bucket targeted by the Resource Data Sync.</p>', ], ], 'ResourceDataSyncSource' => [ 'base' => '<p>Information about the source of the data included in the resource data sync.</p>', 'refs' => [ 'CreateResourceDataSyncRequest$SyncSource' => '<p>Specify information about the data sources to synchronize. This parameter is required if the <code>SyncType</code> value is SyncFromSource.</p>', 'UpdateResourceDataSyncRequest$SyncSource' => '<p>Specify information about the data sources to synchronize.</p>', ], ], 'ResourceDataSyncSourceRegion' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncSourceRegionList$member' => NULL, ], ], 'ResourceDataSyncSourceRegionList' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncSource$SourceRegions' => '<p>The <code>SyncSource</code> AWS Regions included in the resource data sync.</p>', 'ResourceDataSyncSourceWithState$SourceRegions' => '<p>The <code>SyncSource</code> AWS Regions included in the resource data sync.</p>', ], ], 'ResourceDataSyncSourceType' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncSource$SourceType' => '<p>The type of data source for the resource data sync. <code>SourceType</code> is either <code>AwsOrganizations</code> (if an organization is present in AWS Organizations) or <code>singleAccountMultiRegions</code>.</p>', 'ResourceDataSyncSourceWithState$SourceType' => '<p>The type of data source for the resource data sync. <code>SourceType</code> is either <code>AwsOrganizations</code> (if an organization is present in AWS Organizations) or <code>singleAccountMultiRegions</code>.</p>', ], ], 'ResourceDataSyncSourceWithState' => [ 'base' => '<p>The data type name for including resource data sync state. There are four sync states:</p> <p> <code>OrganizationNotExists</code> (Your organization doesn\'t exist)</p> <p> <code>NoPermissions</code> (The system can\'t locate the service-linked role. This role is automatically created when a user creates a resource data sync in Explorer.)</p> <p> <code>InvalidOrganizationalUnit</code> (You specified or selected an invalid unit in the resource data sync configuration.)</p> <p> <code>TrustedAccessDisabled</code> (You disabled Systems Manager access in the organization in AWS Organizations.)</p>', 'refs' => [ 'ResourceDataSyncItem$SyncSource' => '<p>Information about the source where the data was synchronized. </p>', ], ], 'ResourceDataSyncState' => [ 'base' => NULL, 'refs' => [ 'ResourceDataSyncSourceWithState$State' => '<p>The data type name for including resource data sync state. There are four sync states:</p> <p> <code>OrganizationNotExists</code>: Your organization doesn\'t exist.</p> <p> <code>NoPermissions</code>: The system can\'t locate the service-linked role. This role is automatically created when a user creates a resource data sync in Explorer.</p> <p> <code>InvalidOrganizationalUnit</code>: You specified or selected an invalid unit in the resource data sync configuration.</p> <p> <code>TrustedAccessDisabled</code>: You disabled Systems Manager access in the organization in AWS Organizations.</p>', ], ], 'ResourceDataSyncType' => [ 'base' => NULL, 'refs' => [ 'CreateResourceDataSyncRequest$SyncType' => '<p>Specify <code>SyncToDestination</code> to create a resource data sync that synchronizes data to an S3 bucket for Inventory. If you specify <code>SyncToDestination</code>, you must provide a value for <code>S3Destination</code>. Specify <code>SyncFromSource</code> to synchronize data from a single account and multiple Regions, or multiple AWS accounts and Regions, as listed in AWS Organizations for Explorer. If you specify <code>SyncFromSource</code>, you must provide a value for <code>SyncSource</code>. The default value is <code>SyncToDestination</code>.</p>', 'DeleteResourceDataSyncRequest$SyncType' => '<p>Specify the type of resource data sync to delete.</p>', 'ListResourceDataSyncRequest$SyncType' => '<p>View a list of resource data syncs according to the sync type. Specify <code>SyncToDestination</code> to view resource data syncs that synchronize data to an Amazon S3 buckets. Specify <code>SyncFromSource</code> to view resource data syncs from AWS Organizations or from multiple AWS Regions. </p>', 'ResourceDataSyncItem$SyncType' => '<p>The type of resource data sync. If <code>SyncType</code> is <code>SyncToDestination</code>, then the resource data sync synchronizes data to an S3 bucket. If the <code>SyncType</code> is <code>SyncFromSource</code> then the resource data sync synchronizes data from AWS Organizations or from multiple AWS Regions.</p>', 'ResourceDataSyncNotFoundException$SyncType' => NULL, 'UpdateResourceDataSyncRequest$SyncType' => '<p>The type of resource data sync. The supported <code>SyncType</code> is SyncFromSource.</p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'AddTagsToResourceRequest$ResourceId' => '<p>The resource ID you want to tag.</p> <p>Use the ID of the resource. Here are some examples:</p> <p>ManagedInstance: mi-012345abcde</p> <p>MaintenanceWindow: mw-012345abcde</p> <p>PatchBaseline: pb-012345abcde</p> <p>For the Document and Parameter values, use the name of the resource.</p> <note> <p>The ManagedInstance type for this API action is only for on-premises managed instances. You must specify the name of the managed instance in the following format: mi-ID_number. For example, mi-1a2b3c4d5e6f.</p> </note>', 'ListTagsForResourceRequest$ResourceId' => '<p>The resource ID for which you want to see a list of tags.</p>', 'RemoveTagsFromResourceRequest$ResourceId' => '<p>The ID of the resource from which you want to remove tags. For example:</p> <p>ManagedInstance: mi-012345abcde</p> <p>MaintenanceWindow: mw-012345abcde</p> <p>PatchBaseline: pb-012345abcde</p> <p>For the Document and Parameter values, use the name of the resource.</p> <note> <p>The ManagedInstance type for this API action is only for on-premises managed instances. Specify the name of the managed instance in the following format: mi-ID_number. For example, mi-1a2b3c4d5e6f.</p> </note>', ], ], 'ResourceInUseException' => [ 'base' => '<p>Error returned if an attempt is made to delete a patch baseline that is registered for a patch group.</p>', 'refs' => [], ], 'ResourceLimitExceededException' => [ 'base' => '<p>Error returned when the caller has exceeded the default resource quotas. For example, too many maintenance windows or patch baselines have been created.</p> <p>For information about resource quotas in Systems Manager, see <a href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service quotas</a> in the <i>AWS General Reference</i>.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'InstanceInformation$ResourceType' => '<p>The type of instance. Instances are either EC2 instances or managed instances. </p>', ], ], 'ResourceTypeForTagging' => [ 'base' => NULL, 'refs' => [ 'AddTagsToResourceRequest$ResourceType' => '<p>Specifies the type of resource you are tagging.</p> <note> <p>The ManagedInstance type for this API action is for on-premises managed instances. You must specify the name of the managed instance in the following format: mi-ID_number. For example, mi-1a2b3c4d5e6f.</p> </note>', 'ListTagsForResourceRequest$ResourceType' => '<p>Returns a list of tags for a specific resource type.</p>', 'RemoveTagsFromResourceRequest$ResourceType' => '<p>The type of resource from which you want to remove a tag.</p> <note> <p>The ManagedInstance type for this API action is only for on-premises managed instances. Specify the name of the managed instance in the following format: mi-ID_number. For example, mi-1a2b3c4d5e6f.</p> </note>', ], ], 'ResponseCode' => [ 'base' => NULL, 'refs' => [ 'CommandPlugin$ResponseCode' => '<p>A numeric response code generated after running the plugin. </p>', 'GetCommandInvocationResult$ResponseCode' => '<p>The error level response code for the plugin script. If the response code is -1, then the command has not started running on the instance, or it was not received by the instance.</p>', ], ], 'ResultAttribute' => [ 'base' => '<p>The inventory item result attribute.</p>', 'refs' => [ 'ResultAttributeList$member' => NULL, ], ], 'ResultAttributeList' => [ 'base' => NULL, 'refs' => [ 'GetInventoryRequest$ResultAttributes' => '<p>The list of inventory item types to return.</p>', ], ], 'ResumeSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResumeSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'S3BucketName' => [ 'base' => NULL, 'refs' => [ 'Command$OutputS3BucketName' => '<p>The S3 bucket where the responses to the command executions should be stored. This was requested when issuing the command.</p>', 'CommandPlugin$OutputS3BucketName' => '<p>The S3 bucket where the responses to the command executions should be stored. This was requested when issuing the command. For example, in the following response:</p> <p> test_folder/ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix/i-1234567876543/awsrunShellScript </p> <p>test_folder is the name of the S3 bucket;</p> <p>ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix is the name of the S3 prefix;</p> <p>i-1234567876543 is the instance ID;</p> <p>awsrunShellScript is the name of the plugin.</p>', 'LoggingInfo$S3BucketName' => '<p>The name of an S3 bucket where execution logs are stored .</p>', 'MaintenanceWindowRunCommandParameters$OutputS3BucketName' => '<p>The name of the S3 bucket.</p>', 'S3OutputLocation$OutputS3BucketName' => '<p>The name of the S3 bucket.</p>', 'SendCommandRequest$OutputS3BucketName' => '<p>The name of the S3 bucket where command execution responses should be stored.</p>', ], ], 'S3KeyPrefix' => [ 'base' => NULL, 'refs' => [ 'Command$OutputS3KeyPrefix' => '<p>The S3 directory path inside the bucket where the responses to the command executions should be stored. This was requested when issuing the command.</p>', 'CommandPlugin$OutputS3KeyPrefix' => '<p>The S3 directory path inside the bucket where the responses to the command executions should be stored. This was requested when issuing the command. For example, in the following response:</p> <p> test_folder/ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix/i-1234567876543/awsrunShellScript </p> <p>test_folder is the name of the S3 bucket;</p> <p>ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix is the name of the S3 prefix;</p> <p>i-1234567876543 is the instance ID;</p> <p>awsrunShellScript is the name of the plugin.</p>', 'LoggingInfo$S3KeyPrefix' => '<p>(Optional) The S3 bucket subfolder. </p>', 'MaintenanceWindowRunCommandParameters$OutputS3KeyPrefix' => '<p>The S3 bucket subfolder.</p>', 'S3OutputLocation$OutputS3KeyPrefix' => '<p>The S3 bucket subfolder.</p>', 'SendCommandRequest$OutputS3KeyPrefix' => '<p>The directory structure within the S3 bucket where the responses should be stored.</p>', ], ], 'S3OutputLocation' => [ 'base' => '<p>An S3 bucket where you want to store the results of this request.</p>', 'refs' => [ 'InstanceAssociationOutputLocation$S3Location' => '<p>An S3 bucket where you want to store the results of this request.</p>', ], ], 'S3OutputUrl' => [ 'base' => '<p>A URL for the S3 bucket where you want to store the results of this request.</p>', 'refs' => [ 'InstanceAssociationOutputUrl$S3OutputUrl' => '<p>The URL of S3 bucket where you want to store the results of this request.</p>', ], ], 'S3Region' => [ 'base' => NULL, 'refs' => [ 'Command$OutputS3Region' => '<p>(Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager automatically determines the Region of the S3 bucket.</p>', 'CommandPlugin$OutputS3Region' => '<p>(Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager automatically determines the S3 bucket region.</p>', 'LoggingInfo$S3Region' => '<p>The Region where the S3 bucket is located.</p>', 'S3OutputLocation$OutputS3Region' => '<p>(Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager automatically determines the Region of the S3 bucket.</p>', 'SendCommandRequest$OutputS3Region' => '<p>(Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager automatically determines the Region of the S3 bucket.</p>', ], ], 'ScheduleExpression' => [ 'base' => NULL, 'refs' => [ 'Association$ScheduleExpression' => '<p>A cron expression that specifies a schedule when the association runs.</p>', 'AssociationDescription$ScheduleExpression' => '<p>A cron expression that specifies a schedule when the association runs.</p>', 'AssociationVersionInfo$ScheduleExpression' => '<p>The cron or rate schedule specified for the association when the association version was created.</p>', 'CreateAssociationBatchRequestEntry$ScheduleExpression' => '<p>A cron expression that specifies a schedule when the association runs.</p>', 'CreateAssociationRequest$ScheduleExpression' => '<p>A cron expression when the association will be applied to the target(s).</p>', 'UpdateAssociationRequest$ScheduleExpression' => '<p>The cron expression used to schedule the association that you want to update.</p>', ], ], 'ScheduledWindowExecution' => [ 'base' => '<p>Information about a scheduled execution for a maintenance window.</p>', 'refs' => [ 'ScheduledWindowExecutionList$member' => NULL, ], ], 'ScheduledWindowExecutionList' => [ 'base' => NULL, 'refs' => [ 'DescribeMaintenanceWindowScheduleResult$ScheduledWindowExecutions' => '<p>Information about maintenance window executions scheduled for the specified time range.</p>', ], ], 'SendAutomationSignalRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendAutomationSignalResult' => [ 'base' => NULL, 'refs' => [], ], 'SendCommandRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendCommandResult' => [ 'base' => NULL, 'refs' => [], ], 'ServiceRole' => [ 'base' => NULL, 'refs' => [ 'Command$ServiceRole' => '<p>The IAM service role that Run Command uses to act on your behalf when sending notifications about command status changes. </p>', 'CommandInvocation$ServiceRole' => '<p>The IAM service role that Run Command uses to act on your behalf when sending notifications about command status changes on a per instance basis.</p>', 'GetMaintenanceWindowExecutionTaskResult$ServiceRole' => '<p>The role that was assumed when running the task.</p>', 'GetMaintenanceWindowTaskResult$ServiceRoleArn' => '<p>The ARN of the IAM service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.</p>', 'MaintenanceWindowRunCommandParameters$ServiceRoleArn' => '<p>The ARN of the IAM service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.</p>', 'MaintenanceWindowTask$ServiceRoleArn' => '<p>The ARN of the IAM service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.</p>', 'RegisterTaskWithMaintenanceWindowRequest$ServiceRoleArn' => '<p>The ARN of the IAM service role for Systems Manager to assume when running a maintenance window task. If you do not specify a service role ARN, Systems Manager uses your account\'s service-linked role. If no service-linked role for Systems Manager exists in your account, it is created when you run <code>RegisterTaskWithMaintenanceWindow</code>.</p> <p>For more information, see the following topics in the in the <i>AWS Systems Manager User Guide</i>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/using-service-linked-roles.html#slr-permissions">Using service-linked roles for Systems Manager</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html#maintenance-window-tasks-service-role">Should I use a service-linked role or a custom service role to run maintenance window tasks? </a> </p> </li> </ul>', 'SendCommandRequest$ServiceRoleArn' => '<p>The ARN of the IAM service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for Run Command commands.</p>', 'UpdateMaintenanceWindowTaskRequest$ServiceRoleArn' => '<p>The ARN of the IAM service role for Systems Manager to assume when running a maintenance window task. If you do not specify a service role ARN, Systems Manager uses your account\'s service-linked role. If no service-linked role for Systems Manager exists in your account, it is created when you run <code>RegisterTaskWithMaintenanceWindow</code>.</p> <p>For more information, see the following topics in the in the <i>AWS Systems Manager User Guide</i>:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/using-service-linked-roles.html#slr-permissions">Using service-linked roles for Systems Manager</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html#maintenance-window-tasks-service-role">Should I use a service-linked role or a custom service role to run maintenance window tasks? </a> </p> </li> </ul>', 'UpdateMaintenanceWindowTaskResult$ServiceRoleArn' => '<p>The ARN of the IAM service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.</p>', ], ], 'ServiceSetting' => [ 'base' => '<p>The service setting data structure.</p> <p> <code>ServiceSetting</code> is an account-level setting for an AWS service. This setting defines how a user interacts with or uses a service or a feature of a service. For example, if an AWS service charges money to the account based on feature or service usage, then the AWS service team might create a default setting of "false". This means the user can\'t use this feature unless they change the setting to "true" and intentionally opt in for a paid feature.</p> <p>Services map a <code>SettingId</code> object to a setting value. AWS services teams define the default value for a <code>SettingId</code>. You can\'t create a new <code>SettingId</code>, but you can overwrite the default value if you have the <code>ssm:UpdateServiceSetting</code> permission for the setting. Use the <a>UpdateServiceSetting</a> API action to change the default setting. Or, use the <a>ResetServiceSetting</a> to change the value back to the original value defined by the AWS service team.</p>', 'refs' => [ 'GetServiceSettingResult$ServiceSetting' => '<p>The query result of the current service setting.</p>', 'ResetServiceSettingResult$ServiceSetting' => '<p>The current, effective service setting after calling the ResetServiceSetting API action.</p>', ], ], 'ServiceSettingId' => [ 'base' => NULL, 'refs' => [ 'GetServiceSettingRequest$SettingId' => '<p>The ID of the service setting to get. The setting ID can be <code>/ssm/parameter-store/default-parameter-tier</code>, <code>/ssm/parameter-store/high-throughput-enabled</code>, or <code>/ssm/managed-instance/activation-tier</code>.</p>', 'ResetServiceSettingRequest$SettingId' => '<p>The Amazon Resource Name (ARN) of the service setting to reset. The setting ID can be <code>/ssm/parameter-store/default-parameter-tier</code>, <code>/ssm/parameter-store/high-throughput-enabled</code>, or <code>/ssm/managed-instance/activation-tier</code>. For example, <code>arn:aws:ssm:us-east-1:111122223333:servicesetting/ssm/parameter-store/high-throughput-enabled</code>.</p>', 'ServiceSetting$SettingId' => '<p>The ID of the service setting.</p>', 'UpdateServiceSettingRequest$SettingId' => '<p>The Amazon Resource Name (ARN) of the service setting to reset. For example, <code>arn:aws:ssm:us-east-1:111122223333:servicesetting/ssm/parameter-store/high-throughput-enabled</code>. The setting ID can be one of the following.</p> <ul> <li> <p> <code>/ssm/parameter-store/default-parameter-tier</code> </p> </li> <li> <p> <code>/ssm/parameter-store/high-throughput-enabled</code> </p> </li> <li> <p> <code>/ssm/managed-instance/activation-tier</code> </p> </li> </ul>', ], ], 'ServiceSettingNotFound' => [ 'base' => '<p>The specified service setting was not found. Either the service name or the setting has not been provisioned by the AWS service team.</p>', 'refs' => [], ], 'ServiceSettingValue' => [ 'base' => NULL, 'refs' => [ 'ServiceSetting$SettingValue' => '<p>The value of the service setting.</p>', 'UpdateServiceSettingRequest$SettingValue' => '<p>The new value to specify for the service setting. For the <code>/ssm/parameter-store/default-parameter-tier</code> setting ID, the setting value can be one of the following.</p> <ul> <li> <p>Standard</p> </li> <li> <p>Advanced</p> </li> <li> <p>Intelligent-Tiering</p> </li> </ul> <p>For the <code>/ssm/parameter-store/high-throughput-enabled</code>, and <code>/ssm/managed-instance/activation-tier</code> setting IDs, the setting value can be true or false.</p>', ], ], 'Session' => [ 'base' => '<p>Information about a Session Manager connection to an instance.</p>', 'refs' => [ 'SessionList$member' => NULL, ], ], 'SessionDetails' => [ 'base' => NULL, 'refs' => [ 'Session$Details' => '<p>Reserved for future use.</p>', ], ], 'SessionFilter' => [ 'base' => '<p>Describes a filter for Session Manager information.</p>', 'refs' => [ 'SessionFilterList$member' => NULL, ], ], 'SessionFilterKey' => [ 'base' => NULL, 'refs' => [ 'SessionFilter$key' => '<p>The name of the filter.</p>', ], ], 'SessionFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeSessionsRequest$Filters' => '<p>One or more filters to limit the type of sessions returned by the request.</p>', ], ], 'SessionFilterValue' => [ 'base' => NULL, 'refs' => [ 'SessionFilter$value' => '<p>The filter value. Valid values for each filter key are as follows:</p> <ul> <li> <p>InvokedAfter: Specify a timestamp to limit your results. For example, specify 2018-08-29T00:00:00Z to see sessions that started August 29, 2018, and later.</p> </li> <li> <p>InvokedBefore: Specify a timestamp to limit your results. For example, specify 2018-08-29T00:00:00Z to see sessions that started before August 29, 2018.</p> </li> <li> <p>Target: Specify an instance to which session connections have been made.</p> </li> <li> <p>Owner: Specify an AWS user account to see a list of sessions started by that user.</p> </li> <li> <p>Status: Specify a valid session status to see a list of all sessions with that status. Status values you can specify include:</p> <ul> <li> <p>Connected</p> </li> <li> <p>Connecting</p> </li> <li> <p>Disconnected</p> </li> <li> <p>Terminated</p> </li> <li> <p>Terminating</p> </li> <li> <p>Failed</p> </li> </ul> </li> </ul>', ], ], 'SessionId' => [ 'base' => NULL, 'refs' => [ 'ResumeSessionRequest$SessionId' => '<p>The ID of the disconnected session to resume.</p>', 'ResumeSessionResponse$SessionId' => '<p>The ID of the session.</p>', 'Session$SessionId' => '<p>The ID of the session.</p>', 'StartSessionResponse$SessionId' => '<p>The ID of the session.</p>', 'TerminateSessionRequest$SessionId' => '<p>The ID of the session to terminate.</p>', 'TerminateSessionResponse$SessionId' => '<p>The ID of the session that has been terminated.</p>', ], ], 'SessionList' => [ 'base' => NULL, 'refs' => [ 'DescribeSessionsResponse$Sessions' => '<p>A list of sessions meeting the request parameters.</p>', ], ], 'SessionManagerCloudWatchOutputUrl' => [ 'base' => NULL, 'refs' => [ 'SessionManagerOutputUrl$CloudWatchOutputUrl' => '<p>Reserved for future use.</p>', ], ], 'SessionManagerOutputUrl' => [ 'base' => '<p>Reserved for future use.</p>', 'refs' => [ 'Session$OutputUrl' => '<p>Reserved for future use.</p>', ], ], 'SessionManagerParameterName' => [ 'base' => NULL, 'refs' => [ 'SessionManagerParameters$key' => NULL, ], ], 'SessionManagerParameterValue' => [ 'base' => NULL, 'refs' => [ 'SessionManagerParameterValueList$member' => NULL, ], ], 'SessionManagerParameterValueList' => [ 'base' => NULL, 'refs' => [ 'SessionManagerParameters$value' => NULL, ], ], 'SessionManagerParameters' => [ 'base' => NULL, 'refs' => [ 'StartSessionRequest$Parameters' => '<p>Reserved for future use.</p>', ], ], 'SessionManagerS3OutputUrl' => [ 'base' => NULL, 'refs' => [ 'SessionManagerOutputUrl$S3OutputUrl' => '<p>Reserved for future use.</p>', ], ], 'SessionMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeSessionsRequest$MaxResults' => '<p>The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'SessionOwner' => [ 'base' => NULL, 'refs' => [ 'Session$Owner' => '<p>The ID of the AWS user account that started the session.</p>', ], ], 'SessionState' => [ 'base' => NULL, 'refs' => [ 'DescribeSessionsRequest$State' => '<p>The session status to retrieve a list of sessions for. For example, "Active".</p>', ], ], 'SessionStatus' => [ 'base' => NULL, 'refs' => [ 'Session$Status' => '<p>The status of the session. For example, "Connected" or "Terminated".</p>', ], ], 'SessionTarget' => [ 'base' => NULL, 'refs' => [ 'GetConnectionStatusRequest$Target' => '<p>The ID of the instance.</p>', 'GetConnectionStatusResponse$Target' => '<p>The ID of the instance to check connection status. </p>', 'Session$Target' => '<p>The instance that the Session Manager session connected to.</p>', 'StartSessionRequest$Target' => '<p>The instance to connect to for the session.</p>', ], ], 'SeveritySummary' => [ 'base' => '<p>The number of managed instances found for each patch severity level defined in the request filter.</p>', 'refs' => [ 'CompliantSummary$SeveritySummary' => '<p>A summary of the compliance severity by compliance type.</p>', 'NonCompliantSummary$SeveritySummary' => '<p>A summary of the non-compliance severity by compliance type</p>', ], ], 'SharedDocumentVersion' => [ 'base' => '<p>The document version shared with other accounts. You can share <code>Latest</code>, <code>Default</code> or <code>All versions</code>.</p>', 'refs' => [ 'AccountSharingInfo$SharedDocumentVersion' => '<p>The version of the current document shared with the account.</p>', 'ModifyDocumentPermissionRequest$SharedDocumentVersion' => '<p>(Optional) The version of the document to share. If it\'s not specified, the system choose the <code>Default</code> version to share.</p>', ], ], 'SignalType' => [ 'base' => NULL, 'refs' => [ 'SendAutomationSignalRequest$SignalType' => '<p>The type of signal to send to an Automation execution. </p>', ], ], 'SnapshotDownloadUrl' => [ 'base' => NULL, 'refs' => [ 'GetDeployablePatchSnapshotForInstanceResult$SnapshotDownloadUrl' => '<p>A pre-signed Amazon S3 URL that can be used to download the patch snapshot.</p>', ], ], 'SnapshotId' => [ 'base' => NULL, 'refs' => [ 'GetDeployablePatchSnapshotForInstanceRequest$SnapshotId' => '<p>The user-defined snapshot ID.</p>', 'GetDeployablePatchSnapshotForInstanceResult$SnapshotId' => '<p>The user-defined snapshot ID.</p>', 'InstancePatchState$SnapshotId' => '<p>The ID of the patch baseline snapshot used during the patching operation when this compliance data was collected.</p>', ], ], 'StandardErrorContent' => [ 'base' => NULL, 'refs' => [ 'GetCommandInvocationResult$StandardErrorContent' => '<p>The first 8,000 characters written by the plugin to stderr. If the command has not finished running, then this string is empty.</p>', ], ], 'StandardOutputContent' => [ 'base' => NULL, 'refs' => [ 'GetCommandInvocationResult$StandardOutputContent' => '<p>The first 24,000 characters written by the plugin to stdout. If the command has not finished running, if ExecutionStatus is neither Succeeded nor Failed, then this string is empty.</p>', ], ], 'StartAssociationsOnceRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartAssociationsOnceResult' => [ 'base' => NULL, 'refs' => [], ], 'StartAutomationExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartAutomationExecutionResult' => [ 'base' => NULL, 'refs' => [], ], 'StartSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StatusAdditionalInfo' => [ 'base' => NULL, 'refs' => [ 'AssociationStatus$AdditionalInfo' => '<p>A user-defined string.</p>', ], ], 'StatusDetails' => [ 'base' => NULL, 'refs' => [ 'Command$StatusDetails' => '<p>A detailed status of the command execution. StatusDetails includes more information than Status because it includes states resulting from error and concurrency control parameters. StatusDetails can show different results than Status. For more information about these statuses, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding command statuses</a> in the <i>AWS Systems Manager User Guide</i>. StatusDetails can be one of the following values:</p> <ul> <li> <p>Pending: The command has not been sent to any instances.</p> </li> <li> <p>In Progress: The command has been sent to at least one instance but has not reached a final state on all instances.</p> </li> <li> <p>Success: The command successfully ran on all invocations. This is a terminal state.</p> </li> <li> <p>Delivery Timed Out: The value of MaxErrors or more command invocations shows a status of Delivery Timed Out. This is a terminal state.</p> </li> <li> <p>Execution Timed Out: The value of MaxErrors or more command invocations shows a status of Execution Timed Out. This is a terminal state.</p> </li> <li> <p>Failed: The value of MaxErrors or more command invocations shows a status of Failed. This is a terminal state.</p> </li> <li> <p>Incomplete: The command was attempted on all instances and one or more invocations does not have a value of Success but not enough invocations failed for the status to be Failed. This is a terminal state.</p> </li> <li> <p>Canceled: The command was terminated before it was completed. This is a terminal state.</p> </li> <li> <p>Rate Exceeded: The number of instances targeted by the command exceeded the account limit for pending invocations. The system has canceled the command before running it on any instance. This is a terminal state.</p> </li> </ul>', 'CommandInvocation$StatusDetails' => '<p>A detailed status of the command execution for each invocation (each instance targeted by the command). StatusDetails includes more information than Status because it includes states resulting from error and concurrency control parameters. StatusDetails can show different results than Status. For more information about these statuses, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding command statuses</a> in the <i>AWS Systems Manager User Guide</i>. StatusDetails can be one of the following values:</p> <ul> <li> <p>Pending: The command has not been sent to the instance.</p> </li> <li> <p>In Progress: The command has been sent to the instance but has not reached a terminal state.</p> </li> <li> <p>Success: The execution of the command or plugin was successfully completed. This is a terminal state.</p> </li> <li> <p>Delivery Timed Out: The command was not delivered to the instance before the delivery timeout expired. Delivery timeouts do not count against the parent command\'s MaxErrors limit, but they do contribute to whether the parent command status is Success or Incomplete. This is a terminal state.</p> </li> <li> <p>Execution Timed Out: Command execution started on the instance, but the execution was not complete before the execution timeout expired. Execution timeouts count against the MaxErrors limit of the parent command. This is a terminal state.</p> </li> <li> <p>Failed: The command was not successful on the instance. For a plugin, this indicates that the result code was not zero. For a command invocation, this indicates that the result code for one or more plugins was not zero. Invocation failures count against the MaxErrors limit of the parent command. This is a terminal state.</p> </li> <li> <p>Canceled: The command was terminated before it was completed. This is a terminal state.</p> </li> <li> <p>Undeliverable: The command can\'t be delivered to the instance. The instance might not exist or might not be responding. Undeliverable invocations don\'t count against the parent command\'s MaxErrors limit and don\'t contribute to whether the parent command status is Success or Incomplete. This is a terminal state.</p> </li> <li> <p>Terminated: The parent command exceeded its MaxErrors limit and subsequent command invocations were canceled by the system. This is a terminal state.</p> </li> </ul>', 'CommandPlugin$StatusDetails' => '<p>A detailed status of the plugin execution. StatusDetails includes more information than Status because it includes states resulting from error and concurrency control parameters. StatusDetails can show different results than Status. For more information about these statuses, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding command statuses</a> in the <i>AWS Systems Manager User Guide</i>. StatusDetails can be one of the following values:</p> <ul> <li> <p>Pending: The command has not been sent to the instance.</p> </li> <li> <p>In Progress: The command has been sent to the instance but has not reached a terminal state.</p> </li> <li> <p>Success: The execution of the command or plugin was successfully completed. This is a terminal state.</p> </li> <li> <p>Delivery Timed Out: The command was not delivered to the instance before the delivery timeout expired. Delivery timeouts do not count against the parent command\'s MaxErrors limit, but they do contribute to whether the parent command status is Success or Incomplete. This is a terminal state.</p> </li> <li> <p>Execution Timed Out: Command execution started on the instance, but the execution was not complete before the execution timeout expired. Execution timeouts count against the MaxErrors limit of the parent command. This is a terminal state.</p> </li> <li> <p>Failed: The command was not successful on the instance. For a plugin, this indicates that the result code was not zero. For a command invocation, this indicates that the result code for one or more plugins was not zero. Invocation failures count against the MaxErrors limit of the parent command. This is a terminal state.</p> </li> <li> <p>Canceled: The command was terminated before it was completed. This is a terminal state.</p> </li> <li> <p>Undeliverable: The command can\'t be delivered to the instance. The instance might not exist, or it might not be responding. Undeliverable invocations don\'t count against the parent command\'s MaxErrors limit, and they don\'t contribute to whether the parent command status is Success or Incomplete. This is a terminal state.</p> </li> <li> <p>Terminated: The parent command exceeded its MaxErrors limit and subsequent command invocations were canceled by the system. This is a terminal state.</p> </li> </ul>', 'GetCommandInvocationResult$StatusDetails' => '<p>A detailed status of the command execution for an invocation. StatusDetails includes more information than Status because it includes states resulting from error and concurrency control parameters. StatusDetails can show different results than Status. For more information about these statuses, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding command statuses</a> in the <i>AWS Systems Manager User Guide</i>. StatusDetails can be one of the following values:</p> <ul> <li> <p>Pending: The command has not been sent to the instance.</p> </li> <li> <p>In Progress: The command has been sent to the instance but has not reached a terminal state.</p> </li> <li> <p>Delayed: The system attempted to send the command to the target, but the target was not available. The instance might not be available because of network issues, because the instance was stopped, or for similar reasons. The system will try to send the command again.</p> </li> <li> <p>Success: The command or plugin ran successfully. This is a terminal state.</p> </li> <li> <p>Delivery Timed Out: The command was not delivered to the instance before the delivery timeout expired. Delivery timeouts do not count against the parent command\'s MaxErrors limit, but they do contribute to whether the parent command status is Success or Incomplete. This is a terminal state.</p> </li> <li> <p>Execution Timed Out: The command started to run on the instance, but the execution was not complete before the timeout expired. Execution timeouts count against the MaxErrors limit of the parent command. This is a terminal state.</p> </li> <li> <p>Failed: The command wasn\'t run successfully on the instance. For a plugin, this indicates that the result code was not zero. For a command invocation, this indicates that the result code for one or more plugins was not zero. Invocation failures count against the MaxErrors limit of the parent command. This is a terminal state.</p> </li> <li> <p>Canceled: The command was terminated before it was completed. This is a terminal state.</p> </li> <li> <p>Undeliverable: The command can\'t be delivered to the instance. The instance might not exist or might not be responding. Undeliverable invocations don\'t count against the parent command\'s MaxErrors limit and don\'t contribute to whether the parent command status is Success or Incomplete. This is a terminal state.</p> </li> <li> <p>Terminated: The parent command exceeded its MaxErrors limit and subsequent command invocations were canceled by the system. This is a terminal state.</p> </li> </ul>', ], ], 'StatusMessage' => [ 'base' => NULL, 'refs' => [ 'AssociationStatus$Message' => '<p>The reason for the status.</p>', ], ], 'StatusName' => [ 'base' => NULL, 'refs' => [ 'AssociationExecution$Status' => '<p>The status of the association execution.</p>', 'AssociationExecution$DetailedStatus' => '<p>Detailed status information about the execution.</p>', 'AssociationExecutionTarget$Status' => '<p>The association execution status.</p>', 'AssociationExecutionTarget$DetailedStatus' => '<p>Detailed information about the execution status.</p>', 'AssociationOverview$Status' => '<p>The status of the association. Status can be: Pending, Success, or Failed.</p>', 'AssociationOverview$DetailedStatus' => '<p>A detailed status of the association.</p>', 'AssociationStatusAggregatedCount$key' => NULL, 'InstanceAggregatedAssociationOverview$DetailedStatus' => '<p>Detailed status information about the aggregated associations.</p>', 'InstanceAssociationStatusAggregatedCount$key' => NULL, 'InstanceAssociationStatusInfo$Status' => '<p>Status information about the instance association.</p>', 'InstanceAssociationStatusInfo$DetailedStatus' => '<p>Detailed status information about the instance association.</p>', 'InstanceInformation$AssociationStatus' => '<p>The status of the association.</p>', ], ], 'StatusUnchanged' => [ 'base' => '<p>The updated status is the same as the current status.</p>', 'refs' => [], ], 'StepExecution' => [ 'base' => '<p>Detailed information about an the execution state of an Automation step.</p>', 'refs' => [ 'StepExecutionList$member' => NULL, ], ], 'StepExecutionFilter' => [ 'base' => '<p>A filter to limit the amount of step execution information returned by the call.</p>', 'refs' => [ 'StepExecutionFilterList$member' => NULL, ], ], 'StepExecutionFilterKey' => [ 'base' => NULL, 'refs' => [ 'StepExecutionFilter$Key' => '<p>One or more keys to limit the results. Valid filter keys include the following: StepName, Action, StepExecutionId, StepExecutionStatus, StartTimeBefore, StartTimeAfter.</p>', ], ], 'StepExecutionFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeAutomationStepExecutionsRequest$Filters' => '<p>One or more filters to limit the number of step executions returned by the request.</p>', ], ], 'StepExecutionFilterValue' => [ 'base' => NULL, 'refs' => [ 'StepExecutionFilterValueList$member' => NULL, ], ], 'StepExecutionFilterValueList' => [ 'base' => NULL, 'refs' => [ 'StepExecutionFilter$Values' => '<p>The values of the filter key.</p>', ], ], 'StepExecutionList' => [ 'base' => NULL, 'refs' => [ 'AutomationExecution$StepExecutions' => '<p>A list of details about the current state of all steps that comprise an execution. An Automation document contains a list of steps that are run in order.</p>', 'DescribeAutomationStepExecutionsResult$StepExecutions' => '<p>A list of details about the current state of all steps that make up an execution.</p>', ], ], 'StopAutomationExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopAutomationExecutionResult' => [ 'base' => NULL, 'refs' => [], ], 'StopType' => [ 'base' => NULL, 'refs' => [ 'StopAutomationExecutionRequest$Type' => '<p>The stop request type. Valid types include the following: Cancel and Complete. The default type is Cancel.</p>', ], ], 'StreamUrl' => [ 'base' => NULL, 'refs' => [ 'ResumeSessionResponse$StreamUrl' => '<p>A URL back to SSM Agent on the instance that the Session Manager client uses to send commands and receive output from the instance. Format: <code>wss://ssmmessages.<b>region</b>.amazonaws.com/v1/data-channel/<b>session-id</b>?stream=(input|output)</code>.</p> <p> <b>region</b> represents the Region identifier for an AWS Region supported by AWS Systems Manager, such as <code>us-east-2</code> for the US East (Ohio) Region. For a list of supported <b>region</b> values, see the <b>Region</b> column in <a href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#ssm_region">Systems Manager service endpoints</a> in the <i>AWS General Reference</i>.</p> <p> <b>session-id</b> represents the ID of a Session Manager session, such as <code>1a2b3c4dEXAMPLE</code>.</p>', 'StartSessionResponse$StreamUrl' => '<p>A URL back to SSM Agent on the instance that the Session Manager client uses to send commands and receive output from the instance. Format: <code>wss://ssmmessages.<b>region</b>.amazonaws.com/v1/data-channel/<b>session-id</b>?stream=(input|output)</code> </p> <p> <b>region</b> represents the Region identifier for an AWS Region supported by AWS Systems Manager, such as <code>us-east-2</code> for the US East (Ohio) Region. For a list of supported <b>region</b> values, see the <b>Region</b> column in <a href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#ssm_region">Systems Manager service endpoints</a> in the <i>AWS General Reference</i>.</p> <p> <b>session-id</b> represents the ID of a Session Manager session, such as <code>1a2b3c4dEXAMPLE</code>.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AlreadyExistsException$Message' => NULL, 'AssociationDoesNotExist$Message' => NULL, 'AssociationExecutionDoesNotExist$Message' => NULL, 'AssociationVersionLimitExceeded$Message' => NULL, 'AutomationDefinitionNotFoundException$Message' => NULL, 'AutomationDefinitionVersionNotFoundException$Message' => NULL, 'AutomationExecution$FailureMessage' => '<p>A message describing why an execution has failed, if the status is set to Failed.</p>', 'AutomationExecution$ExecutedBy' => '<p>The Amazon Resource Name (ARN) of the user who ran the automation.</p>', 'AutomationExecution$CurrentStepName' => '<p>The name of the step that is currently running.</p>', 'AutomationExecution$CurrentAction' => '<p>The action of the step that is currently running.</p>', 'AutomationExecution$Target' => '<p>The target of the execution.</p>', 'AutomationExecutionLimitExceededException$Message' => NULL, 'AutomationExecutionMetadata$ExecutedBy' => '<p>The IAM role ARN of the user who ran the Automation.</p>', 'AutomationExecutionMetadata$LogFile' => '<p>An S3 bucket where execution information is stored.</p>', 'AutomationExecutionMetadata$CurrentStepName' => '<p>The name of the step that is currently running.</p>', 'AutomationExecutionMetadata$CurrentAction' => '<p>The action of the step that is currently running.</p>', 'AutomationExecutionMetadata$FailureMessage' => '<p>The list of execution outputs as defined in the Automation document.</p>', 'AutomationExecutionMetadata$Target' => '<p>The list of execution outputs as defined in the Automation document.</p>', 'AutomationExecutionNotFoundException$Message' => NULL, 'AutomationStepNotFoundException$Message' => NULL, 'ComplianceTypeCountLimitExceededException$Message' => NULL, 'CreateOpsItemResponse$OpsItemId' => '<p>The ID of the OpsItem.</p>', 'CustomSchemaCountLimitExceededException$Message' => NULL, 'DescribeOpsItemsRequest$NextToken' => '<p>A token to start the list. Use this token to get the next set of results.</p>', 'DescribeOpsItemsResponse$NextToken' => '<p>The token for the next set of items to return. Use this token to get the next set of results.</p>', 'DocumentAlreadyExists$Message' => NULL, 'DocumentLimitExceeded$Message' => NULL, 'DocumentPermissionLimit$Message' => NULL, 'DocumentVersionLimitExceeded$Message' => NULL, 'DoesNotExistException$Message' => NULL, 'DuplicateDocumentContent$Message' => NULL, 'DuplicateDocumentVersionName$Message' => NULL, 'FailureDetails$FailureStage' => '<p>The stage of the Automation execution when the failure occurred. The stages include the following: InputValidation, PreVerification, Invocation, PostVerification.</p>', 'FailureDetails$FailureType' => '<p>The type of Automation failure. Failure types include the following: Action, Permission, Throttling, Verification, Internal.</p>', 'FeatureNotAvailableException$Message' => NULL, 'HierarchyLevelLimitExceededException$message' => '<p>A hierarchy can have a maximum of 15 levels. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-parameter-name-constraints.html">Requirements and constraints for parameter names</a> in the <i>AWS Systems Manager User Guide</i>. </p>', 'HierarchyTypeMismatchException$message' => '<p>Parameter Store does not support changing a parameter type in a hierarchy. For example, you can\'t change a parameter from a <code>String</code> type to a <code>SecureString</code> type. You must create a new, unique parameter.</p>', 'IdempotentParameterMismatch$Message' => NULL, 'IncompatiblePolicyException$message' => NULL, 'InstanceInformation$PlatformName' => '<p>The name of the operating system platform running on your instance. </p>', 'InstanceInformation$PlatformVersion' => '<p>The version of the OS platform running on your instance. </p>', 'InstanceInformation$Name' => '<p>The name assigned to an on-premises server or virtual machine (VM) when it is activated as a Systems Manager managed instance. The name is specified as the <code>DefaultInstanceName</code> property using the <a>CreateActivation</a> command. It is applied to the managed instance by specifying the Activation Code and Activation ID when you install SSM Agent on the instance, as explained in <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-install-managed-linux.html">Install SSM Agent for a hybrid environment (Linux)</a> and <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-install-managed-win.html">Install SSM Agent for a hybrid environment (Windows)</a>. To retrieve the Name tag of an EC2 instance, use the Amazon EC2 <code>DescribeInstances</code> action. For information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html">DescribeInstances</a> in the <i>Amazon EC2 API Reference</i> or <a href="http://docs.aws.amazon.com/cli/latest/reference/ec2/describe-instances.html">describe-instances</a> in the <i>AWS CLI Command Reference</i>.</p>', 'InternalServerError$Message' => NULL, 'InvalidActivation$Message' => NULL, 'InvalidActivationId$Message' => NULL, 'InvalidAggregatorException$Message' => NULL, 'InvalidAllowedPatternException$message' => '<p>The request does not meet the regular expression requirement.</p>', 'InvalidAssociation$Message' => NULL, 'InvalidAssociationVersion$Message' => NULL, 'InvalidAutomationExecutionParametersException$Message' => NULL, 'InvalidAutomationSignalException$Message' => NULL, 'InvalidAutomationStatusUpdateException$Message' => NULL, 'InvalidDeleteInventoryParametersException$Message' => NULL, 'InvalidDeletionIdException$Message' => NULL, 'InvalidDocument$Message' => '<p>The document does not exist or the document is not available to the user. This exception can be issued by CreateAssociation, CreateAssociationBatch, DeleteAssociation, DeleteDocument, DescribeAssociation, DescribeDocument, GetDocument, SendCommand, or UpdateAssociationStatus. </p>', 'InvalidDocumentContent$Message' => '<p>A description of the validation error.</p>', 'InvalidDocumentOperation$Message' => NULL, 'InvalidDocumentSchemaVersion$Message' => NULL, 'InvalidDocumentType$Message' => NULL, 'InvalidDocumentVersion$Message' => NULL, 'InvalidFilter$Message' => NULL, 'InvalidFilterOption$message' => '<p>The specified filter option is not valid. Valid options are Equals and BeginsWith. For Path filter, valid options are Recursive and OneLevel.</p>', 'InvalidFilterValue$Message' => NULL, 'InvalidInstanceId$Message' => NULL, 'InvalidInstanceInformationFilterValue$message' => NULL, 'InvalidInventoryGroupException$Message' => NULL, 'InvalidInventoryItemContextException$Message' => NULL, 'InvalidInventoryRequestException$Message' => NULL, 'InvalidItemContentException$Message' => NULL, 'InvalidKeyId$message' => NULL, 'InvalidNextToken$Message' => NULL, 'InvalidNotificationConfig$Message' => NULL, 'InvalidOptionException$Message' => NULL, 'InvalidParameters$Message' => NULL, 'InvalidPermissionType$Message' => NULL, 'InvalidPolicyAttributeException$message' => NULL, 'InvalidPolicyTypeException$message' => NULL, 'InvalidResultAttributeException$Message' => NULL, 'InvalidRole$Message' => NULL, 'InvalidSchedule$Message' => NULL, 'InvalidTarget$Message' => NULL, 'InvalidTypeNameException$Message' => NULL, 'InvalidUpdate$Message' => NULL, 'ItemContentMismatchException$Message' => NULL, 'ItemSizeLimitExceededException$Message' => NULL, 'MaxDocumentSizeExceeded$Message' => NULL, 'NormalStringMap$key' => NULL, 'NormalStringMap$value' => NULL, 'OpsItem$CreatedBy' => '<p>The ARN of the AWS account that created the OpsItem.</p>', 'OpsItem$LastModifiedBy' => '<p>The ARN of the AWS account that last updated the OpsItem.</p>', 'OpsItem$Version' => '<p>The version of this OpsItem. Each time the OpsItem is edited the version number increments by one.</p>', 'OpsItemAlreadyExistsException$Message' => NULL, 'OpsItemAlreadyExistsException$OpsItemId' => NULL, 'OpsItemInvalidParameterException$Message' => NULL, 'OpsItemLimitExceededException$LimitType' => NULL, 'OpsItemLimitExceededException$Message' => NULL, 'OpsItemNotFoundException$Message' => NULL, 'OpsItemNotification$Arn' => '<p>The Amazon Resource Name (ARN) of an SNS topic where notifications are sent when this OpsItem is edited or changed.</p>', 'OpsItemOpsDataKeysList$member' => NULL, 'OpsItemParameterNamesList$member' => NULL, 'OpsItemSummary$CreatedBy' => '<p>The Amazon Resource Name (ARN) of the IAM entity that created the OpsItem.</p>', 'OpsItemSummary$LastModifiedBy' => '<p>The Amazon Resource Name (ARN) of the IAM entity that created the OpsItem.</p>', 'Parameter$SourceResult' => '<p>Applies to parameters that reference information in other AWS services. SourceResult is the raw result or response from the source.</p>', 'Parameter$ARN' => '<p>The Amazon Resource Name (ARN) of the parameter.</p>', 'ParameterAlreadyExists$message' => NULL, 'ParameterHistory$LastModifiedUser' => '<p>Amazon Resource Name (ARN) of the AWS user who last changed the parameter.</p>', 'ParameterInlinePolicy$PolicyText' => '<p>The JSON text of the policy.</p>', 'ParameterInlinePolicy$PolicyType' => '<p>The type of policy. Parameter Store supports the following policy types: Expiration, ExpirationNotification, and NoChangeNotification. </p>', 'ParameterInlinePolicy$PolicyStatus' => '<p>The status of the policy. Policies report the following statuses: Pending (the policy has not been enforced or applied yet), Finished (the policy was applied), Failed (the policy was not applied), or InProgress (the policy is being applied now). </p>', 'ParameterLimitExceeded$message' => NULL, 'ParameterMaxVersionLimitExceeded$message' => NULL, 'ParameterMetadata$LastModifiedUser' => '<p>Amazon Resource Name (ARN) of the AWS user who last changed the parameter.</p>', 'ParameterNotFound$message' => NULL, 'ParameterPatternMismatchException$message' => '<p>The parameter name is not valid.</p>', 'ParameterVersionLabelLimitExceeded$message' => NULL, 'ParameterVersionNotFound$message' => NULL, 'PoliciesLimitExceededException$message' => NULL, 'RelatedOpsItem$OpsItemId' => '<p>The ID of an OpsItem related to the current OpsItem.</p>', 'ResourceDataSyncConflictException$Message' => NULL, 'ResourceDataSyncCountExceededException$Message' => NULL, 'ResourceDataSyncInvalidConfigurationException$Message' => NULL, 'ResourceDataSyncNotFoundException$Message' => NULL, 'ResourceInUseException$Message' => NULL, 'ResourceLimitExceededException$Message' => NULL, 'ServiceSetting$LastModifiedUser' => '<p>The ARN of the last modified user. This field is populated only if the setting value was overwritten.</p>', 'ServiceSetting$ARN' => '<p>The ARN of the service setting.</p>', 'ServiceSetting$Status' => '<p>The status of the service setting. The value can be Default, Customized or PendingUpdate.</p> <ul> <li> <p>Default: The current setting uses a default value provisioned by the AWS service team.</p> </li> <li> <p>Customized: The current setting use a custom value specified by the customer.</p> </li> <li> <p>PendingUpdate: The current setting uses a default or custom value, but a setting change request is pending approval.</p> </li> </ul>', 'ServiceSettingNotFound$Message' => NULL, 'StepExecution$StepName' => '<p>The name of this execution step.</p>', 'StepExecution$OnFailure' => '<p>The action to take if the step fails. The default value is Abort.</p>', 'StepExecution$ResponseCode' => '<p>The response code returned by the execution of the step.</p>', 'StepExecution$Response' => '<p>A message associated with the response code for an execution.</p>', 'StepExecution$FailureMessage' => '<p>If a step failed, this message explains why the execution failed.</p>', 'StepExecution$StepExecutionId' => '<p>The unique ID of a step execution.</p>', 'StepExecution$NextStep' => '<p>The next step after the step succeeds.</p>', 'StringList$member' => NULL, 'SubTypeCountLimitExceededException$Message' => NULL, 'TargetInUseException$Message' => NULL, 'TargetNotConnected$Message' => NULL, 'TooManyUpdates$Message' => NULL, 'TotalSizeLimitExceededException$Message' => NULL, 'UnsupportedCalendarException$Message' => NULL, 'UnsupportedFeatureRequiredException$Message' => NULL, 'UnsupportedInventoryItemContextException$Message' => NULL, 'UnsupportedInventorySchemaVersionException$Message' => NULL, 'UnsupportedOperatingSystem$Message' => NULL, 'UnsupportedParameterType$message' => NULL, 'UnsupportedPlatformType$Message' => NULL, ], ], 'StringDateTime' => [ 'base' => NULL, 'refs' => [ 'GetCommandInvocationResult$ExecutionStartDateTime' => '<p>The date and time the plugin started running. Date and time are written in ISO 8601 format. For example, June 7, 2017 is represented as 2017-06-7. The following sample AWS CLI command uses the <code>InvokedBefore</code> filter.</p> <p> <code>aws ssm list-commands --filters key=InvokedBefore,value=2017-06-07T00:00:00Z</code> </p> <p>If the plugin has not started to run, the string is empty.</p>', 'GetCommandInvocationResult$ExecutionElapsedTime' => '<p>Duration since ExecutionStartDateTime.</p>', 'GetCommandInvocationResult$ExecutionEndDateTime' => '<p>The date and time the plugin was finished running. Date and time are written in ISO 8601 format. For example, June 7, 2017 is represented as 2017-06-7. The following sample AWS CLI command uses the <code>InvokedAfter</code> filter.</p> <p> <code>aws ssm list-commands --filters key=InvokedAfter,value=2017-06-07T00:00:00Z</code> </p> <p>If the plugin has not started to run, the string is empty.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'DescribeActivationsFilter$FilterValues' => '<p>The filter values.</p>', ], ], 'SubTypeCountLimitExceededException' => [ 'base' => '<p>The sub-type count exceeded the limit for the inventory type.</p>', 'refs' => [], ], 'Tag' => [ 'base' => '<p>Metadata that you assign to your AWS resources. Tags enable you to categorize your resources in different ways, for example, by purpose, owner, or environment. In Systems Manager, you can apply tags to documents, managed instances, maintenance windows, Parameter Store parameters, and patch baselines.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'KeyList$member' => NULL, 'Tag$Key' => '<p>The name of the tag.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'Activation$Tags' => '<p>Tags assigned to the activation.</p>', 'AddTagsToResourceRequest$Tags' => '<p> One or more tags. The value parameter is required, but if you don\'t want the tag to have a value, specify the parameter with no value, and we set the value to an empty string. </p> <important> <p>Do not enter personally identifiable information in this field.</p> </important>', 'CreateActivationRequest$Tags' => '<p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag an activation to identify which servers or virtual machines (VMs) in your on-premises environment you intend to activate. In this case, you could specify the following key name/value pairs:</p> <ul> <li> <p> <code>Key=OS,Value=Windows</code> </p> </li> <li> <p> <code>Key=Environment,Value=Production</code> </p> </li> </ul> <important> <p>When you install SSM Agent on your on-premises servers and VMs, you specify an activation ID and code. When you specify the activation ID and code, tags assigned to the activation are automatically applied to the on-premises servers or VMs.</p> </important> <p>You can\'t add tags to or delete tags from an existing activation. You can tag your on-premises servers and VMs after they connect to Systems Manager for the first time and are assigned a managed instance ID. This means they are listed in the AWS Systems Manager console with an ID that is prefixed with "mi-". For information about how to add tags to your managed instances, see <a>AddTagsToResource</a>. For information about how to remove tags from your managed instances, see <a>RemoveTagsFromResource</a>.</p>', 'CreateDocumentRequest$Tags' => '<p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag an SSM document to identify the types of targets or the environment where it will run. In this case, you could specify the following key name/value pairs:</p> <ul> <li> <p> <code>Key=OS,Value=Windows</code> </p> </li> <li> <p> <code>Key=Environment,Value=Production</code> </p> </li> </ul> <note> <p>To add tags to an existing SSM document, use the <a>AddTagsToResource</a> action.</p> </note>', 'CreateMaintenanceWindowRequest$Tags' => '<p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag a maintenance window to identify the type of tasks it will run, the types of targets, and the environment it will run in. In this case, you could specify the following key name/value pairs:</p> <ul> <li> <p> <code>Key=TaskType,Value=AgentUpdate</code> </p> </li> <li> <p> <code>Key=OS,Value=Windows</code> </p> </li> <li> <p> <code>Key=Environment,Value=Production</code> </p> </li> </ul> <note> <p>To add tags to an existing maintenance window, use the <a>AddTagsToResource</a> action.</p> </note>', 'CreateOpsItemRequest$Tags' => '<p>Optional metadata that you assign to a resource. You can restrict access to OpsItems by using an inline IAM policy that specifies tags. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html#OpsCenter-getting-started-user-permissions">Getting started with OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.</p> <p>Tags use a key-value pair. For example:</p> <p> <code>Key=Department,Value=Finance</code> </p> <note> <p>To add tags to an existing OpsItem, use the <a>AddTagsToResource</a> action.</p> </note>', 'CreatePatchBaselineRequest$Tags' => '<p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag a patch baseline to identify the severity level of patches it specifies and the operating system family it applies to. In this case, you could specify the following key name/value pairs:</p> <ul> <li> <p> <code>Key=PatchSeverity,Value=Critical</code> </p> </li> <li> <p> <code>Key=OS,Value=Windows</code> </p> </li> </ul> <note> <p>To add tags to an existing patch baseline, use the <a>AddTagsToResource</a> action.</p> </note>', 'DocumentDescription$Tags' => '<p>The tags, or metadata, that have been applied to the document.</p>', 'DocumentIdentifier$Tags' => '<p>The tags, or metadata, that have been applied to the document.</p>', 'ListTagsForResourceResult$TagList' => '<p>A list of tags.</p>', 'PutParameterRequest$Tags' => '<p>Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag a Systems Manager parameter to identify the type of resource to which it applies, the environment, or the type of configuration data referenced by the parameter. In this case, you could specify the following key name/value pairs:</p> <ul> <li> <p> <code>Key=Resource,Value=S3bucket</code> </p> </li> <li> <p> <code>Key=OS,Value=Windows</code> </p> </li> <li> <p> <code>Key=ParameterType,Value=LicenseKey</code> </p> </li> </ul> <note> <p>To add tags to an existing Systems Manager parameter, use the <a>AddTagsToResource</a> action.</p> </note>', 'StartAutomationExecutionRequest$Tags' => '<p>Optional metadata that you assign to a resource. You can specify a maximum of five tags for an automation. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag an automation to identify an environment or operating system. In this case, you could specify the following key name/value pairs:</p> <ul> <li> <p> <code>Key=environment,Value=test</code> </p> </li> <li> <p> <code>Key=OS,Value=Windows</code> </p> </li> </ul> <note> <p>To add tags to an existing patch baseline, use the <a>AddTagsToResource</a> action.</p> </note>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value of the tag.</p>', ], ], 'Target' => [ 'base' => '<p>An array of search criteria that targets instances using a Key,Value combination that you specify. </p> <p>Supported formats include the following.</p> <ul> <li> <p> <code>Key=InstanceIds,Values=<i>instance-id-1</i>,<i>instance-id-2</i>,<i>instance-id-3</i> </code> </p> </li> <li> <p> <code>Key=tag:<i>my-tag-key</i>,Values=<i>my-tag-value-1</i>,<i>my-tag-value-2</i> </code> </p> </li> <li> <p> <code>Key=tag-key,Values=<i>my-tag-key-1</i>,<i>my-tag-key-2</i> </code> </p> </li> <li> <p> <b>Run Command and Maintenance window targets only</b>: <code>Key=resource-groups:Name,Values=<i>resource-group-name</i> </code> </p> </li> <li> <p> <b>Maintenance window targets only</b>: <code>Key=resource-groups:ResourceTypeFilters,Values=<i>resource-type-1</i>,<i>resource-type-2</i> </code> </p> </li> <li> <p> <b>Automation targets only</b>: <code>Key=ResourceGroup;Values=<i>resource-group-name</i> </code> </p> </li> </ul> <p>For example:</p> <ul> <li> <p> <code>Key=InstanceIds,Values=i-02573cafcfEXAMPLE,i-0471e04240EXAMPLE,i-07782c72faEXAMPLE</code> </p> </li> <li> <p> <code>Key=tag:CostCenter,Values=CostCenter1,CostCenter2,CostCenter3</code> </p> </li> <li> <p> <code>Key=tag-key,Values=Name,Instance-Type,CostCenter</code> </p> </li> <li> <p> <b>Run Command and Maintenance window targets only</b>: <code>Key=resource-groups:Name,Values=ProductionResourceGroup</code> </p> <p>This example demonstrates how to target all resources in the resource group <b>ProductionResourceGroup</b> in your maintenance window.</p> </li> <li> <p> <b>Maintenance window targets only</b>: <code>Key=resource-groups:ResourceTypeFilters,Values=<i>AWS::EC2::INSTANCE</i>,<i>AWS::EC2::VPC</i> </code> </p> <p>This example demonstrates how to target only EC2 instances and VPCs in your maintenance window.</p> </li> <li> <p> <b>Automation targets only</b>: <code>Key=ResourceGroup,Values=MyResourceGroup</code> </p> </li> <li> <p> <b>State Manager association targets only</b>: <code>Key=InstanceIds,Values=<i>*</i> </code> </p> <p>This example demonstrates how to target all managed instances in the AWS Region where the association was created.</p> </li> </ul> <p>For more information about how to send commands that target instances using <code>Key,Value</code> parameters, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html#send-commands-targeting">Targeting multiple instances</a> in the <i>AWS Systems Manager User Guide</i>.</p>', 'refs' => [ 'Targets$member' => NULL, ], ], 'TargetCount' => [ 'base' => NULL, 'refs' => [ 'Command$TargetCount' => '<p>The number of targets for the command.</p>', ], ], 'TargetInUseException' => [ 'base' => '<p>You specified the <code>Safe</code> option for the DeregisterTargetFromMaintenanceWindow operation, but the target is still referenced in a task.</p>', 'refs' => [], ], 'TargetKey' => [ 'base' => NULL, 'refs' => [ 'Target$Key' => '<p>User-defined criteria for sending commands that target instances that meet the criteria.</p>', ], ], 'TargetLocation' => [ 'base' => '<p>The combination of AWS Regions and accounts targeted by the current Automation execution.</p>', 'refs' => [ 'StepExecution$TargetLocation' => '<p>The combination of AWS Regions and accounts targeted by the current Automation execution.</p>', 'TargetLocations$member' => NULL, ], ], 'TargetLocations' => [ 'base' => NULL, 'refs' => [ 'AutomationExecution$TargetLocations' => '<p>The combination of AWS Regions and/or AWS accounts where you want to run the Automation.</p>', 'StartAutomationExecutionRequest$TargetLocations' => '<p>A location is a combination of AWS Regions and/or AWS accounts where you want to run the Automation. Use this action to start an Automation in multiple Regions and multiple accounts. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html">Running Automation workflows in multiple AWS Regions and accounts</a> in the <i>AWS Systems Manager User Guide</i>. </p>', ], ], 'TargetMap' => [ 'base' => NULL, 'refs' => [ 'TargetMaps$member' => NULL, ], ], 'TargetMapKey' => [ 'base' => NULL, 'refs' => [ 'TargetMap$key' => NULL, ], ], 'TargetMapValue' => [ 'base' => NULL, 'refs' => [ 'TargetMapValueList$member' => NULL, ], ], 'TargetMapValueList' => [ 'base' => NULL, 'refs' => [ 'TargetMap$value' => NULL, ], ], 'TargetMaps' => [ 'base' => NULL, 'refs' => [ 'AutomationExecution$TargetMaps' => '<p>The specified key-value mapping of document parameters to target resources.</p>', 'AutomationExecutionMetadata$TargetMaps' => '<p>The specified key-value mapping of document parameters to target resources.</p>', 'StartAutomationExecutionRequest$TargetMaps' => '<p>A key-value mapping of document parameters to target resources. Both Targets and TargetMaps cannot be specified together.</p>', ], ], 'TargetNotConnected' => [ 'base' => '<p>The specified target instance for the session is not fully configured for use with Session Manager. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-getting-started.html">Getting started with Session Manager</a> in the <i>AWS Systems Manager User Guide</i>.</p>', 'refs' => [], ], 'TargetParameterList' => [ 'base' => NULL, 'refs' => [ 'ResolvedTargets$ParameterValues' => '<p>A list of parameter values sent to targets that resolved during the Automation execution.</p>', ], ], 'TargetType' => [ 'base' => NULL, 'refs' => [ 'CreateDocumentRequest$TargetType' => '<p>Specify a target type to define the kinds of resources the document can run on. For example, to run a document on EC2 instances, specify the following value: /AWS::EC2::Instance. If you specify a value of \'/\' the document can run on all types of resources. If you don\'t specify a value, the document can\'t run on any resources. For a list of valid resource types, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">AWS resource and property types reference</a> in the <i>AWS CloudFormation User Guide</i>. </p>', 'DocumentDescription$TargetType' => '<p>The target type which defines the kinds of resources the document can run on. For example, /AWS::EC2::Instance. For a list of valid resource types, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">AWS resource and property types reference</a> in the <i>AWS CloudFormation User Guide</i>. </p>', 'DocumentIdentifier$TargetType' => '<p>The target type which defines the kinds of resources the document can run on. For example, /AWS::EC2::Instance. For a list of valid resource types, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">AWS resource and property types reference</a> in the <i>AWS CloudFormation User Guide</i>. </p>', 'UpdateDocumentRequest$TargetType' => '<p>Specify a new target type for the document.</p>', ], ], 'TargetValue' => [ 'base' => NULL, 'refs' => [ 'TargetValues$member' => NULL, ], ], 'TargetValues' => [ 'base' => NULL, 'refs' => [ 'Target$Values' => '<p>User-defined criteria that maps to <code>Key</code>. For example, if you specified <code>tag:ServerRole</code>, you could specify <code>value:WebServer</code> to run a command on instances that include EC2 tags of <code>ServerRole,WebServer</code>. </p>', ], ], 'Targets' => [ 'base' => NULL, 'refs' => [ 'Association$Targets' => '<p>The instances targeted by the request to create an association. </p>', 'AssociationDescription$Targets' => '<p>The instances targeted by the request. </p>', 'AssociationVersionInfo$Targets' => '<p>The targets specified for the association when the association version was created. </p>', 'AutomationExecution$Targets' => '<p>The specified targets.</p>', 'AutomationExecutionMetadata$Targets' => '<p>The targets defined by the user when starting the Automation.</p>', 'Command$Targets' => '<p>An array of search criteria that targets instances using a Key,Value combination that you specify. Targets is required if you don\'t provide one or more instance IDs in the call.</p>', 'CreateAssociationBatchRequestEntry$Targets' => '<p>The instances targeted by the request.</p>', 'CreateAssociationRequest$Targets' => '<p>The targets for the association. You can target instances by using tags, AWS Resource Groups, all instances in an AWS account, or individual instance IDs. For more information about choosing targets for an association, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-state-manager-targets-and-rate-controls.html">Using targets and rate controls with State Manager associations</a> in the <i>AWS Systems Manager User Guide</i>.</p>', 'DescribeMaintenanceWindowScheduleRequest$Targets' => '<p>The instance ID or key/value pair to retrieve information about.</p>', 'DescribeMaintenanceWindowsForTargetRequest$Targets' => '<p>The instance ID or key/value pair to retrieve information about.</p>', 'GetMaintenanceWindowTaskResult$Targets' => '<p>The targets where the task should run.</p>', 'MaintenanceWindowTarget$Targets' => '<p>The targets, either instances or tags.</p> <p>Specify instances using the following format:</p> <p> <code>Key=instanceids,Values=&lt;instanceid1&gt;,&lt;instanceid2&gt;</code> </p> <p>Tags are specified using the following format:</p> <p> <code>Key=&lt;tag name&gt;,Values=&lt;tag value&gt;</code>.</p>', 'MaintenanceWindowTask$Targets' => '<p>The targets (either instances or tags). Instances are specified using Key=instanceids,Values=&lt;instanceid1&gt;,&lt;instanceid2&gt;. Tags are specified using Key=&lt;tag name&gt;,Values=&lt;tag value&gt;.</p>', 'RegisterTargetWithMaintenanceWindowRequest$Targets' => '<p>The targets to register with the maintenance window. In other words, the instances to run commands on when the maintenance window runs.</p> <p>You can specify targets using instance IDs, resource group names, or tags that have been applied to instances.</p> <p> <b>Example 1</b>: Specify instance IDs</p> <p> <code>Key=InstanceIds,Values=<i>instance-id-1</i>,<i>instance-id-2</i>,<i>instance-id-3</i> </code> </p> <p> <b>Example 2</b>: Use tag key-pairs applied to instances</p> <p> <code>Key=tag:<i>my-tag-key</i>,Values=<i>my-tag-value-1</i>,<i>my-tag-value-2</i> </code> </p> <p> <b>Example 3</b>: Use tag-keys applied to instances</p> <p> <code>Key=tag-key,Values=<i>my-tag-key-1</i>,<i>my-tag-key-2</i> </code> </p> <p> <b>Example 4</b>: Use resource group names</p> <p> <code>Key=resource-groups:Name,Values=<i>resource-group-name</i> </code> </p> <p> <b>Example 5</b>: Use filters for resource group types</p> <p> <code>Key=resource-groups:ResourceTypeFilters,Values=<i>resource-type-1</i>,<i>resource-type-2</i> </code> </p> <note> <p>For <code>Key=resource-groups:ResourceTypeFilters</code>, specify resource types in the following format</p> <p> <code>Key=resource-groups:ResourceTypeFilters,Values=<i>AWS::EC2::INSTANCE</i>,<i>AWS::EC2::VPC</i> </code> </p> </note> <p>For more information about these examples formats, including the best use case for each one, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/mw-cli-tutorial-targets-examples.html">Examples: Register targets with a maintenance window</a> in the <i>AWS Systems Manager User Guide</i>.</p>', 'RegisterTaskWithMaintenanceWindowRequest$Targets' => '<p>The targets (either instances or maintenance window targets).</p> <p>Specify instances using the following format: </p> <p> <code>Key=InstanceIds,Values=&lt;instance-id-1&gt;,&lt;instance-id-2&gt;</code> </p> <p>Specify maintenance window targets using the following format:</p> <p> <code>Key=WindowTargetIds;,Values=&lt;window-target-id-1&gt;,&lt;window-target-id-2&gt;</code> </p>', 'SendCommandRequest$Targets' => '<p>An array of search criteria that targets instances using a <code>Key,Value</code> combination that you specify. Specifying targets is most useful when you want to send a command to a large number of instances at once. Using <code>Targets</code>, which accepts tag key-value pairs to identify instances, you can send a command to tens, hundreds, or thousands of instances at once.</p> <p>To send a command to a smaller number of instances, you can use the <code>InstanceIds</code> option instead.</p> <p>For more information about how to use targets, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending commands to a fleet</a> in the <i>AWS Systems Manager User Guide</i>.</p>', 'StartAutomationExecutionRequest$Targets' => '<p>A key-value mapping to target resources. Required if you specify TargetParameterName.</p>', 'StepExecution$Targets' => '<p>The targets for the step execution.</p>', 'UpdateAssociationRequest$Targets' => '<p>The targets of the association.</p>', 'UpdateMaintenanceWindowTargetRequest$Targets' => '<p>The targets to add or replace.</p>', 'UpdateMaintenanceWindowTargetResult$Targets' => '<p>The updated targets.</p>', 'UpdateMaintenanceWindowTaskRequest$Targets' => '<p>The targets (either instances or tags) to modify. Instances are specified using Key=instanceids,Values=instanceID_1,instanceID_2. Tags are specified using Key=tag_name,Values=tag_value. </p>', 'UpdateMaintenanceWindowTaskResult$Targets' => '<p>The updated target values.</p>', ], ], 'TerminateSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'TerminateSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'TimeoutSeconds' => [ 'base' => NULL, 'refs' => [ 'Command$TimeoutSeconds' => '<p>The <code>TimeoutSeconds</code> value specified for a command.</p>', 'MaintenanceWindowRunCommandParameters$TimeoutSeconds' => '<p>If this time is reached and the command has not already started running, it doesn\'t run.</p>', 'SendCommandRequest$TimeoutSeconds' => '<p>If this time is reached and the command has not already started running, it will not run.</p>', ], ], 'TokenValue' => [ 'base' => NULL, 'refs' => [ 'ResumeSessionResponse$TokenValue' => '<p>An encrypted token value containing session and caller information. Used to authenticate the connection to the instance.</p>', 'StartSessionResponse$TokenValue' => '<p>An encrypted token value containing session and caller information. Used to authenticate the connection to the instance.</p>', ], ], 'TooManyTagsError' => [ 'base' => '<p>The <code>Targets</code> parameter includes too many tags. Remove one or more tags and try the command again.</p>', 'refs' => [], ], 'TooManyUpdates' => [ 'base' => '<p>There are concurrent updates for a resource that supports one update at a time.</p>', 'refs' => [], ], 'TotalCount' => [ 'base' => NULL, 'refs' => [ 'InventoryDeletionSummary$TotalCount' => '<p>The total number of items to delete. This count does not change during the delete operation.</p>', ], ], 'TotalSizeLimitExceededException' => [ 'base' => '<p>The size of inventory data has exceeded the total size limit for the resource.</p>', 'refs' => [], ], 'UnsupportedCalendarException' => [ 'base' => '<p>The calendar entry contained in the specified Systems Manager document is not supported.</p>', 'refs' => [], ], 'UnsupportedFeatureRequiredException' => [ 'base' => '<p>Microsoft application patching is only available on EC2 instances and advanced instances. To patch Microsoft applications on on-premises servers and VMs, you must enable advanced instances. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances-advanced.html">Using the advanced-instances tier</a> in the <i>AWS Systems Manager User Guide</i>.</p>', 'refs' => [], ], 'UnsupportedInventoryItemContextException' => [ 'base' => '<p>The <code>Context</code> attribute that you specified for the <code>InventoryItem</code> is not allowed for this inventory type. You can only use the <code>Context</code> attribute with inventory types like <code>AWS:ComplianceItem</code>.</p>', 'refs' => [], ], 'UnsupportedInventorySchemaVersionException' => [ 'base' => '<p>Inventory item type schema version has to match supported versions in the service. Check output of GetInventorySchema to see the available schema version for each type.</p>', 'refs' => [], ], 'UnsupportedOperatingSystem' => [ 'base' => '<p>The operating systems you specified is not supported, or the operation is not supported for the operating system. Valid operating systems include: Windows, AmazonLinux, RedhatEnterpriseLinux, and Ubuntu.</p>', 'refs' => [], ], 'UnsupportedParameterType' => [ 'base' => '<p>The parameter type is not supported.</p>', 'refs' => [], ], 'UnsupportedPlatformType' => [ 'base' => '<p>The document does not support the platform type of the given instance ID(s). For example, you sent an document for a Windows instance to a Linux instance.</p>', 'refs' => [], ], 'UpdateAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAssociationResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAssociationStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAssociationStatusResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDocumentDefaultVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDocumentDefaultVersionResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDocumentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDocumentResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMaintenanceWindowRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMaintenanceWindowResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMaintenanceWindowTargetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMaintenanceWindowTargetResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMaintenanceWindowTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMaintenanceWindowTaskResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateManagedInstanceRoleRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateManagedInstanceRoleResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateOpsItemRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateOpsItemResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePatchBaselineRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePatchBaselineResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourceDataSyncRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourceDataSyncResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServiceSettingRequest' => [ 'base' => '<p>The request body of the UpdateServiceSetting API action.</p>', 'refs' => [], ], 'UpdateServiceSettingResult' => [ 'base' => '<p>The result body of the UpdateServiceSetting API action.</p>', 'refs' => [], ], 'Url' => [ 'base' => NULL, 'refs' => [ 'CommandInvocation$StandardOutputUrl' => '<p>The URL to the plugin\'s StdOut file in Amazon S3, if the S3 bucket was defined for the parent command. For an invocation, StandardOutputUrl is populated if there is just one plugin defined for the command, and the S3 bucket was defined for the command.</p>', 'CommandInvocation$StandardErrorUrl' => '<p>The URL to the plugin\'s StdErr file in Amazon S3, if the S3 bucket was defined for the parent command. For an invocation, StandardErrorUrl is populated if there is just one plugin defined for the command, and the S3 bucket was defined for the command.</p>', 'CommandPlugin$StandardOutputUrl' => '<p>The URL for the complete text written by the plugin to stdout in Amazon S3. If the S3 bucket for the command was not specified, then this string is empty.</p>', 'CommandPlugin$StandardErrorUrl' => '<p>The URL for the complete text written by the plugin to stderr. If execution is not yet complete, then this string is empty.</p>', 'GetCommandInvocationResult$StandardOutputUrl' => '<p>The URL for the complete text written by the plugin to stdout in Amazon S3. If an S3 bucket was not specified, then this string is empty.</p>', 'GetCommandInvocationResult$StandardErrorUrl' => '<p>The URL for the complete text written by the plugin to stderr. If the command has not finished running, then this string is empty.</p>', 'S3OutputUrl$OutputUrl' => '<p>A URL for an S3 bucket where you want to store the results of this request.</p>', ], ], 'ValidNextStep' => [ 'base' => NULL, 'refs' => [ 'ValidNextStepList$member' => NULL, ], ], 'ValidNextStepList' => [ 'base' => NULL, 'refs' => [ 'StepExecution$ValidNextSteps' => '<p>Strategies used when step fails, we support Continue and Abort. Abort will fail the automation when the step fails. Continue will ignore the failure of current step and allow automation to run the next step. With conditional branching, we add step:stepName to support the automation to go to another specific step.</p>', ], ], 'Version' => [ 'base' => NULL, 'refs' => [ 'InstanceInformation$AgentVersion' => '<p>The version of SSM Agent running on your Linux instance. </p>', ], ], ],];
