<?php
// This file was auto-generated from sdk-root/src/data/snowball/2016-06-30/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>AWS Snowball is a petabyte-scale data transport solution that uses secure devices to transfer large amounts of data between your on-premises data centers and Amazon Simple Storage Service (Amazon S3). The Snowball commands described here provide access to the same functionality that is available in the AWS Snowball Management Console, which enables you to create and manage jobs for Snowball. To transfer data locally with a Snowball device, you\'ll need to use the Snowball client or the Amazon S3 API adapter for Snowball. For more information, see the <a href="https://docs.aws.amazon.com/AWSImportExport/latest/ug/api-reference.html">User Guide</a>.</p>', 'operations' => [ 'CancelCluster' => '<p>Cancels a cluster job. You can only cancel a cluster job while it\'s in the <code>AwaitingQuorum</code> status. You\'ll have at least an hour after creating a cluster job to cancel it.</p>', 'CancelJob' => '<p>Cancels the specified job. You can only cancel a job before its <code>JobState</code> value changes to <code>PreparingAppliance</code>. Requesting the <code>ListJobs</code> or <code>DescribeJob</code> action returns a job\'s <code>JobState</code> as part of the response element data returned.</p>', 'CreateAddress' => '<p>Creates an address for a Snowball to be shipped to. In most regions, addresses are validated at the time of creation. The address you provide must be located within the serviceable area of your region. If the address is invalid or unsupported, then an exception is thrown.</p>', 'CreateCluster' => '<p>Creates an empty cluster. Each cluster supports five nodes. You use the <a>CreateJob</a> action separately to create the jobs for each of these nodes. The cluster does not ship until these five node jobs have been created.</p>', 'CreateJob' => '<p>Creates a job to import or export data between Amazon S3 and your on-premises data center. Your AWS account must have the right trust policies and permissions in place to create a job for Snowball. If you\'re creating a job for a node in a cluster, you only need to provide the <code>clusterId</code> value; the other job attributes are inherited from the cluster. </p>', 'DescribeAddress' => '<p>Takes an <code>AddressId</code> and returns specific details about that address in the form of an <code>Address</code> object.</p>', 'DescribeAddresses' => '<p>Returns a specified number of <code>ADDRESS</code> objects. Calling this API in one of the US regions will return addresses from the list of all addresses associated with this account in all US regions.</p>', 'DescribeCluster' => '<p>Returns information about a specific cluster including shipping information, cluster status, and other important metadata.</p>', 'DescribeJob' => '<p>Returns information about a specific job including shipping information, job status, and other important metadata. </p>', 'GetJobManifest' => '<p>Returns a link to an Amazon S3 presigned URL for the manifest file associated with the specified <code>JobId</code> value. You can access the manifest file for up to 60 minutes after this request has been made. To access the manifest file after 60 minutes have passed, you\'ll have to make another call to the <code>GetJobManifest</code> action.</p> <p>The manifest is an encrypted file that you can download after your job enters the <code>WithCustomer</code> status. The manifest is decrypted by using the <code>UnlockCode</code> code value, when you pass both values to the Snowball through the Snowball client when the client is started for the first time.</p> <p>As a best practice, we recommend that you don\'t save a copy of an <code>UnlockCode</code> value in the same location as the manifest file for that job. Saving these separately helps prevent unauthorized parties from gaining access to the Snowball associated with that job.</p> <p>The credentials of a given job, including its manifest file and unlock code, expire 90 days after the job is created.</p>', 'GetJobUnlockCode' => '<p>Returns the <code>UnlockCode</code> code value for the specified job. A particular <code>UnlockCode</code> value can be accessed for up to 90 days after the associated job has been created.</p> <p>The <code>UnlockCode</code> value is a 29-character code with 25 alphanumeric characters and 4 hyphens. This code is used to decrypt the manifest file when it is passed along with the manifest to the Snowball through the Snowball client when the client is started for the first time.</p> <p>As a best practice, we recommend that you don\'t save a copy of the <code>UnlockCode</code> in the same location as the manifest file for that job. Saving these separately helps prevent unauthorized parties from gaining access to the Snowball associated with that job.</p>', 'GetSnowballUsage' => '<p>Returns information about the Snowball service limit for your account, and also the number of Snowballs your account has in use.</p> <p>The default service limit for the number of Snowballs that you can have at one time is 1. If you want to increase your service limit, contact AWS Support.</p>', 'GetSoftwareUpdates' => '<p>Returns an Amazon S3 presigned URL for an update file associated with a specified <code>JobId</code>.</p>', 'ListClusterJobs' => '<p>Returns an array of <code>JobListEntry</code> objects of the specified length. Each <code>JobListEntry</code> object is for a job in the specified cluster and contains a job\'s state, a job\'s ID, and other information.</p>', 'ListClusters' => '<p>Returns an array of <code>ClusterListEntry</code> objects of the specified length. Each <code>ClusterListEntry</code> object contains a cluster\'s state, a cluster\'s ID, and other important status information.</p>', 'ListCompatibleImages' => '<p>This action returns a list of the different Amazon EC2 Amazon Machine Images (AMIs) that are owned by your AWS account that would be supported for use on a Snowball Edge device. Currently, supported AMIs are based on the CentOS 7 (x86_64) - with Updates HVM, Ubuntu Server 14.04 LTS (HVM), and Ubuntu 16.04 LTS - Xenial (HVM) images, available on the AWS Marketplace.</p>', 'ListJobs' => '<p>Returns an array of <code>JobListEntry</code> objects of the specified length. Each <code>JobListEntry</code> object contains a job\'s state, a job\'s ID, and a value that indicates whether the job is a job part, in the case of export jobs. Calling this API action in one of the US regions will return jobs from the list of all jobs associated with this account in all US regions.</p>', 'UpdateCluster' => '<p>While a cluster\'s <code>ClusterState</code> value is in the <code>AwaitingQuorum</code> state, you can update some of the information associated with a cluster. Once the cluster changes to a different job state, usually 60 minutes after the cluster being created, this action is no longer available.</p>', 'UpdateJob' => '<p>While a job\'s <code>JobState</code> value is <code>New</code>, you can update some of the information associated with a job. Once the job changes to a different job state, usually within 60 minutes of the job being created, this action is no longer available.</p>', ], 'shapes' => [ 'Address' => [ 'base' => '<p>The address that you want the Snowball or Snowballs associated with a specific job to be shipped to. Addresses are validated at the time of creation. The address you provide must be located within the serviceable area of your region. Although no individual elements of the <code>Address</code> are required, if the address is invalid or unsupported, then an exception is thrown.</p>', 'refs' => [ 'AddressList$member' => NULL, 'CreateAddressRequest$Address' => '<p>The address that you want the Snowball shipped to.</p>', 'DescribeAddressResult$Address' => '<p>The address that you want the Snowball or Snowballs associated with a specific job to be shipped to.</p>', ], ], 'AddressId' => [ 'base' => NULL, 'refs' => [ 'Address$AddressId' => '<p>The unique ID for an address.</p>', 'ClusterMetadata$AddressId' => '<p>The automatically generated ID for a specific address.</p>', 'ClusterMetadata$ForwardingAddressId' => '<p>The ID of the address that you want a cluster shipped to, after it will be shipped to its primary address. This field is not supported in most regions.</p>', 'CreateClusterRequest$AddressId' => '<p>The ID for the address that you want the cluster shipped to.</p>', 'CreateClusterRequest$ForwardingAddressId' => '<p>The forwarding address ID for a cluster. This field is not supported in most regions.</p>', 'CreateJobRequest$AddressId' => '<p>The ID for the address that you want the Snowball shipped to.</p>', 'CreateJobRequest$ForwardingAddressId' => '<p>The forwarding address ID for a job. This field is not supported in most regions.</p>', 'DescribeAddressRequest$AddressId' => '<p>The automatically generated ID for a specific address.</p>', 'JobMetadata$AddressId' => '<p>The ID for the address that you want the Snowball shipped to.</p>', 'JobMetadata$ForwardingAddressId' => '<p>The ID of the address that you want a job shipped to, after it will be shipped to its primary address. This field is not supported in most regions.</p>', 'UpdateClusterRequest$AddressId' => '<p>The ID of the updated <a>Address</a> object.</p>', 'UpdateClusterRequest$ForwardingAddressId' => '<p>The updated ID for the forwarding address for a cluster. This field is not supported in most regions.</p>', 'UpdateJobRequest$AddressId' => '<p>The ID of the updated <a>Address</a> object.</p>', 'UpdateJobRequest$ForwardingAddressId' => '<p>The updated ID for the forwarding address for a job. This field is not supported in most regions.</p>', ], ], 'AddressList' => [ 'base' => NULL, 'refs' => [ 'DescribeAddressesResult$Addresses' => '<p>The Snowball shipping addresses that were created for this account.</p>', ], ], 'AmiId' => [ 'base' => NULL, 'refs' => [ 'Ec2AmiResource$AmiId' => '<p>The ID of the AMI in Amazon EC2.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'Address$IsRestricted' => '<p>If the address you are creating is a primary address, then set this option to true. This field is not supported in most regions.</p>', 'JobListEntry$IsMaster' => '<p>A value that indicates that this job is a master job. A master job represents a successful request to create an export job. Master jobs aren\'t associated with any Snowballs. Instead, each master job will have at least one job part, and each job part is associated with a Snowball. It might take some time before the job parts associated with a particular master job are listed, because they are created after the master job is created.</p>', 'Notification$NotifyAll' => '<p>Any change in job state will trigger a notification for this job.</p>', 'WirelessConnection$IsWifiEnabled' => '<p>Enables the Wi-Fi adapter on an AWS Snowcone device.</p>', ], ], 'CancelClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'CancelJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelJobResult' => [ 'base' => NULL, 'refs' => [], ], 'ClusterId' => [ 'base' => NULL, 'refs' => [ 'CancelClusterRequest$ClusterId' => '<p>The 39-character ID for the cluster that you want to cancel, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>', 'CreateClusterResult$ClusterId' => '<p>The automatically generated ID for a cluster.</p>', 'CreateJobRequest$ClusterId' => '<p>The ID of a cluster. If you\'re creating a job for a node in a cluster, you need to provide only this <code>clusterId</code> value. The other job attributes are inherited from the cluster.</p>', 'DescribeClusterRequest$ClusterId' => '<p>The automatically generated ID for a cluster.</p>', 'ListClusterJobsRequest$ClusterId' => '<p>The 39-character ID for the cluster that you want to list, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>', 'UpdateClusterRequest$ClusterId' => '<p>The cluster ID of the cluster that you want to update, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>', ], ], 'ClusterLimitExceededException' => [ 'base' => '<p>Job creation failed. Currently, clusters support five nodes. If you have less than five nodes for your cluster and you have more nodes to create for this cluster, try again and create jobs until your cluster has exactly five notes.</p>', 'refs' => [], ], 'ClusterListEntry' => [ 'base' => '<p>Contains a cluster\'s state, a cluster\'s ID, and other important information.</p>', 'refs' => [ 'ClusterListEntryList$member' => NULL, ], ], 'ClusterListEntryList' => [ 'base' => NULL, 'refs' => [ 'ListClustersResult$ClusterListEntries' => '<p>Each <code>ClusterListEntry</code> object contains a cluster\'s state, a cluster\'s ID, and other important status information.</p>', ], ], 'ClusterMetadata' => [ 'base' => '<p>Contains metadata about a specific cluster.</p>', 'refs' => [ 'DescribeClusterResult$ClusterMetadata' => '<p>Information about a specific cluster, including shipping information, cluster status, and other important metadata.</p>', ], ], 'ClusterState' => [ 'base' => NULL, 'refs' => [ 'ClusterListEntry$ClusterState' => '<p>The current state of this cluster. For information about the state of a specific node, see <a>JobListEntry$JobState</a>.</p>', 'ClusterMetadata$ClusterState' => '<p>The current status of the cluster.</p>', ], ], 'CompatibleImage' => [ 'base' => '<p>A JSON-formatted object that describes a compatible Amazon Machine Image (AMI), including the ID and name for a Snowball Edge AMI. This AMI is compatible with the device\'s physical hardware requirements, and it should be able to be run in an SBE1 instance on the device.</p>', 'refs' => [ 'CompatibleImageList$member' => NULL, ], ], 'CompatibleImageList' => [ 'base' => NULL, 'refs' => [ 'ListCompatibleImagesResult$CompatibleImages' => '<p>A JSON-formatted object that describes a compatible AMI, including the ID and name for a Snowball Edge AMI.</p>', ], ], 'CreateAddressRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAddressResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateJobResult' => [ 'base' => NULL, 'refs' => [], ], 'DataTransfer' => [ 'base' => '<p>Defines the real-time status of a Snowball\'s data transfer while the device is at AWS. This data is only available while a job has a <code>JobState</code> value of <code>InProgress</code>, for both import and export jobs.</p>', 'refs' => [ 'JobMetadata$DataTransferProgress' => '<p>A value that defines the real-time status of a Snowball\'s data transfer while the device is at AWS. This data is only available while a job has a <code>JobState</code> value of <code>InProgress</code>, for both import and export jobs.</p>', ], ], 'DescribeAddressRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAddressResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAddressesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAddressesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobResult' => [ 'base' => NULL, 'refs' => [], ], 'DeviceConfiguration' => [ 'base' => '<p>The container for <code>SnowconeDeviceConfiguration</code>. </p>', 'refs' => [ 'CreateJobRequest$DeviceConfiguration' => '<p>Defines the device configuration for an AWS Snowcone job.</p>', 'JobMetadata$DeviceConfiguration' => NULL, ], ], 'Ec2AmiResource' => [ 'base' => '<p>A JSON-formatted object that contains the IDs for an Amazon Machine Image (AMI), including the Amazon EC2 AMI ID and the Snowball Edge AMI ID. Each AMI has these two IDs to simplify identifying the AMI in both the AWS Cloud and on the device.</p>', 'refs' => [ 'Ec2AmiResourceList$member' => NULL, ], ], 'Ec2AmiResourceList' => [ 'base' => NULL, 'refs' => [ 'JobResource$Ec2AmiResources' => '<p>The Amazon Machine Images (AMIs) associated with this job.</p>', ], ], 'Ec2RequestFailedException' => [ 'base' => '<p>Your IAM user lacks the necessary Amazon EC2 permissions to perform the attempted action.</p>', 'refs' => [], ], 'EventTriggerDefinition' => [ 'base' => '<p>The container for the <a>EventTriggerDefinition$EventResourceARN</a>.</p>', 'refs' => [ 'EventTriggerDefinitionList$member' => NULL, ], ], 'EventTriggerDefinitionList' => [ 'base' => NULL, 'refs' => [ 'LambdaResource$EventTriggers' => '<p>The array of ARNs for <a>S3Resource</a> objects to trigger the <a>LambdaResource</a> objects associated with this job.</p>', ], ], 'GSTIN' => [ 'base' => NULL, 'refs' => [ 'INDTaxDocuments$GSTIN' => '<p>The Goods and Services Tax (GST) documents required in AWS Regions in India.</p>', ], ], 'GetJobManifestRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetJobManifestResult' => [ 'base' => NULL, 'refs' => [], ], 'GetJobUnlockCodeRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetJobUnlockCodeResult' => [ 'base' => NULL, 'refs' => [], ], 'GetSnowballUsageRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSnowballUsageResult' => [ 'base' => NULL, 'refs' => [], ], 'GetSoftwareUpdatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSoftwareUpdatesResult' => [ 'base' => NULL, 'refs' => [], ], 'INDTaxDocuments' => [ 'base' => '<p>The tax documents required in AWS Regions in India.</p>', 'refs' => [ 'TaxDocuments$IND' => NULL, ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'GetSnowballUsageResult$SnowballLimit' => '<p>The service limit for number of Snowballs this account can have at once. The default service limit is 1 (one).</p>', 'GetSnowballUsageResult$SnowballsInUse' => '<p>The number of Snowballs that this account is currently using.</p>', ], ], 'InvalidAddressException' => [ 'base' => '<p>The address provided was invalid. Check the address with your region\'s carrier, and try again.</p>', 'refs' => [], ], 'InvalidInputCombinationException' => [ 'base' => '<p>Job or cluster creation failed. One or more inputs were invalid. Confirm that the <a>CreateClusterRequest$SnowballType</a> value supports your <a>CreateJobRequest$JobType</a>, and try again.</p>', 'refs' => [], ], 'InvalidJobStateException' => [ 'base' => '<p>The action can\'t be performed because the job\'s current state doesn\'t allow that action to be performed.</p>', 'refs' => [], ], 'InvalidNextTokenException' => [ 'base' => '<p>The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the operation without changing the <code>NextToken</code> string, and try again.</p>', 'refs' => [], ], 'InvalidResourceException' => [ 'base' => '<p>The specified resource can\'t be found. Check the information you provided in your last request, and try again.</p>', 'refs' => [], ], 'JobId' => [ 'base' => NULL, 'refs' => [ 'CancelJobRequest$JobId' => '<p>The 39-character job ID for the job that you want to cancel, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>', 'CreateJobResult$JobId' => '<p>The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>', 'DescribeJobRequest$JobId' => '<p>The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>', 'GetJobManifestRequest$JobId' => '<p>The ID for a job that you want to get the manifest file for, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>', 'GetJobUnlockCodeRequest$JobId' => '<p>The ID for the job that you want to get the <code>UnlockCode</code> value for, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>', 'GetSoftwareUpdatesRequest$JobId' => '<p>The ID for a job that you want to get the software update file for, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>', 'UpdateJobRequest$JobId' => '<p>The job ID of the job that you want to update, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>', ], ], 'JobListEntry' => [ 'base' => '<p>Each <code>JobListEntry</code> object contains a job\'s state, a job\'s ID, and a value that indicates whether the job is a job part, in the case of an export job.</p>', 'refs' => [ 'JobListEntryList$member' => NULL, ], ], 'JobListEntryList' => [ 'base' => NULL, 'refs' => [ 'ListClusterJobsResult$JobListEntries' => '<p>Each <code>JobListEntry</code> object contains a job\'s state, a job\'s ID, and a value that indicates whether the job is a job part, in the case of export jobs. </p>', 'ListJobsResult$JobListEntries' => '<p>Each <code>JobListEntry</code> object contains a job\'s state, a job\'s ID, and a value that indicates whether the job is a job part, in the case of export jobs. </p>', ], ], 'JobLogs' => [ 'base' => '<p>Contains job logs. Whenever Snowball is used to import data into or export data out of Amazon S3, you\'ll have the option of downloading a PDF job report. Job logs are returned as a part of the response syntax of the <code>DescribeJob</code> action in the <code>JobMetadata</code> data type. The job logs can be accessed for up to 60 minutes after this request has been made. To access any of the job logs after 60 minutes have passed, you\'ll have to make another call to the <code>DescribeJob</code> action.</p> <p>For import jobs, the PDF job report becomes available at the end of the import process. For export jobs, your job report typically becomes available while the Snowball for your job part is being delivered to you.</p> <p>The job report provides you insight into the state of your Amazon S3 data transfer. The report includes details about your job or job part for your records.</p> <p>For deeper visibility into the status of your transferred objects, you can look at the two associated logs: a success log and a failure log. The logs are saved in comma-separated value (CSV) format, and the name of each log includes the ID of the job or job part that the log describes.</p>', 'refs' => [ 'JobMetadata$JobLogInfo' => '<p>Links to Amazon S3 presigned URLs for the job report and logs. For import jobs, the PDF job report becomes available at the end of the import process. For export jobs, your job report typically becomes available while the Snowball for your job part is being delivered to you.</p>', ], ], 'JobMetadata' => [ 'base' => '<p>Contains information about a specific job including shipping information, job status, and other important metadata. This information is returned as a part of the response syntax of the <code>DescribeJob</code> action.</p>', 'refs' => [ 'DescribeJobResult$JobMetadata' => '<p>Information about a specific job, including shipping information, job status, and other important metadata.</p>', 'JobMetadataList$member' => NULL, ], ], 'JobMetadataList' => [ 'base' => NULL, 'refs' => [ 'DescribeJobResult$SubJobMetadata' => '<p>Information about a specific job part (in the case of an export job), including shipping information, job status, and other important metadata.</p>', ], ], 'JobResource' => [ 'base' => '<p>Contains an array of AWS resource objects. Each object represents an Amazon S3 bucket, an AWS Lambda function, or an Amazon Machine Image (AMI) based on Amazon EC2 that is associated with a particular job.</p>', 'refs' => [ 'ClusterMetadata$Resources' => '<p>The arrays of <a>JobResource</a> objects that can include updated <a>S3Resource</a> objects or <a>LambdaResource</a> objects.</p>', 'CreateClusterRequest$Resources' => '<p>The resources associated with the cluster job. These resources include Amazon S3 buckets and optional AWS Lambda functions written in the Python language. </p>', 'CreateJobRequest$Resources' => '<p>Defines the Amazon S3 buckets associated with this job.</p> <p>With <code>IMPORT</code> jobs, you specify the bucket or buckets that your transferred data will be imported into.</p> <p>With <code>EXPORT</code> jobs, you specify the bucket or buckets that your transferred data will be exported from. Optionally, you can also specify a <code>KeyRange</code> value. If you choose to export a range, you define the length of the range by providing either an inclusive <code>BeginMarker</code> value, an inclusive <code>EndMarker</code> value, or both. Ranges are UTF-8 binary sorted.</p>', 'JobMetadata$Resources' => '<p>An array of <code>S3Resource</code> objects. Each <code>S3Resource</code> object represents an Amazon S3 bucket that your transferred data will be exported from or imported into.</p>', 'UpdateClusterRequest$Resources' => '<p>The updated arrays of <a>JobResource</a> objects that can include updated <a>S3Resource</a> objects or <a>LambdaResource</a> objects.</p>', 'UpdateJobRequest$Resources' => '<p>The updated <code>JobResource</code> object, or the updated <a>JobResource</a> object. </p>', ], ], 'JobState' => [ 'base' => NULL, 'refs' => [ 'JobListEntry$JobState' => '<p>The current state of this job.</p>', 'JobMetadata$JobState' => '<p>The current status of the jobs.</p>', 'JobStateList$member' => NULL, ], ], 'JobStateList' => [ 'base' => NULL, 'refs' => [ 'Notification$JobStatesToNotify' => '<p>The list of job states that will trigger a notification for this job.</p>', ], ], 'JobType' => [ 'base' => NULL, 'refs' => [ 'ClusterMetadata$JobType' => '<p>The type of job for this cluster. Currently, the only job type supported for clusters is <code>LOCAL_USE</code>.</p>', 'CreateClusterRequest$JobType' => '<p>The type of job for this cluster. Currently, the only job type supported for clusters is <code>LOCAL_USE</code>.</p>', 'CreateJobRequest$JobType' => '<p>Defines the type of job that you\'re creating. </p>', 'JobListEntry$JobType' => '<p>The type of job.</p>', 'JobMetadata$JobType' => '<p>The type of job.</p>', ], ], 'KMSRequestFailedException' => [ 'base' => '<p>The provided AWS Key Management Service key lacks the permissions to perform the specified <a>CreateJob</a> or <a>UpdateJob</a> action.</p>', 'refs' => [], ], 'KeyRange' => [ 'base' => '<p>Contains a key range. For export jobs, a <code>S3Resource</code> object can have an optional <code>KeyRange</code> value. The length of the range is defined at job creation, and has either an inclusive <code>BeginMarker</code>, an inclusive <code>EndMarker</code>, or both. Ranges are UTF-8 binary sorted.</p>', 'refs' => [ 'S3Resource$KeyRange' => '<p>For export jobs, you can provide an optional <code>KeyRange</code> within a specific Amazon S3 bucket. The length of the range is defined at job creation, and has either an inclusive <code>BeginMarker</code>, an inclusive <code>EndMarker</code>, or both. Ranges are UTF-8 binary sorted.</p>', ], ], 'KmsKeyARN' => [ 'base' => NULL, 'refs' => [ 'ClusterMetadata$KmsKeyARN' => '<p>The <code>KmsKeyARN</code> Amazon Resource Name (ARN) associated with this cluster. This ARN was created using the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in AWS Key Management Service (AWS KMS).</p>', 'CreateClusterRequest$KmsKeyARN' => '<p>The <code>KmsKeyARN</code> value that you want to associate with this cluster. <code>KmsKeyARN</code> values are created by using the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in AWS Key Management Service (AWS KMS). </p>', 'CreateJobRequest$KmsKeyARN' => '<p>The <code>KmsKeyARN</code> that you want to associate with this job. <code>KmsKeyARN</code>s are created using the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> AWS Key Management Service (KMS) API action.</p>', 'JobMetadata$KmsKeyARN' => '<p>The Amazon Resource Name (ARN) for the AWS Key Management Service (AWS KMS) key associated with this job. This ARN was created using the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html">CreateKey</a> API action in AWS KMS.</p>', ], ], 'LambdaResource' => [ 'base' => '<p>Identifies </p>', 'refs' => [ 'LambdaResourceList$member' => NULL, ], ], 'LambdaResourceList' => [ 'base' => NULL, 'refs' => [ 'JobResource$LambdaResources' => '<p>The Python-language Lambda functions for this job.</p>', ], ], 'ListClusterJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListClusterJobsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListClustersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListClustersResult' => [ 'base' => NULL, 'refs' => [], ], 'ListCompatibleImagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCompatibleImagesResult' => [ 'base' => NULL, 'refs' => [], ], 'ListJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListJobsResult' => [ 'base' => NULL, 'refs' => [], ], 'ListLimit' => [ 'base' => NULL, 'refs' => [ 'DescribeAddressesRequest$MaxResults' => '<p>The number of <code>ADDRESS</code> objects to return.</p>', 'ListClusterJobsRequest$MaxResults' => '<p>The number of <code>JobListEntry</code> objects to return.</p>', 'ListClustersRequest$MaxResults' => '<p>The number of <code>ClusterListEntry</code> objects to return.</p>', 'ListCompatibleImagesRequest$MaxResults' => '<p>The maximum number of results for the list of compatible images. Currently, a Snowball Edge device can store 10 AMIs.</p>', 'ListJobsRequest$MaxResults' => '<p>The number of <code>JobListEntry</code> objects to return.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'DataTransfer$BytesTransferred' => '<p>The number of bytes transferred between a Snowball and Amazon S3.</p>', 'DataTransfer$ObjectsTransferred' => '<p>The number of objects transferred between a Snowball and Amazon S3.</p>', 'DataTransfer$TotalBytes' => '<p>The total bytes of data for a transfer between a Snowball and Amazon S3. This value is set to 0 (zero) until all the keys that will be transferred have been listed.</p>', 'DataTransfer$TotalObjects' => '<p>The total number of objects for a transfer between a Snowball and Amazon S3. This value is set to 0 (zero) until all the keys that will be transferred have been listed.</p>', ], ], 'Notification' => [ 'base' => '<p>The Amazon Simple Notification Service (Amazon SNS) notification settings associated with a specific job. The <code>Notification</code> object is returned as a part of the response syntax of the <code>DescribeJob</code> action in the <code>JobMetadata</code> data type.</p> <p>When the notification settings are defined during job creation, you can choose to notify based on a specific set of job states using the <code>JobStatesToNotify</code> array of strings, or you can specify that you want to have Amazon SNS notifications sent out for all job states with <code>NotifyAll</code> set to true.</p>', 'refs' => [ 'ClusterMetadata$Notification' => '<p>The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.</p>', 'CreateClusterRequest$Notification' => '<p>The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.</p>', 'CreateJobRequest$Notification' => '<p>Defines the Amazon Simple Notification Service (Amazon SNS) notification settings for this job.</p>', 'JobMetadata$Notification' => '<p>The Amazon Simple Notification Service (Amazon SNS) notification settings associated with a specific job. The <code>Notification</code> object is returned as a part of the response syntax of the <code>DescribeJob</code> action in the <code>JobMetadata</code> data type.</p>', 'UpdateClusterRequest$Notification' => '<p>The new or updated <a>Notification</a> object.</p>', 'UpdateJobRequest$Notification' => '<p>The new or updated <a>Notification</a> object.</p>', ], ], 'ResourceARN' => [ 'base' => NULL, 'refs' => [ 'EventTriggerDefinition$EventResourceARN' => '<p>The Amazon Resource Name (ARN) for any local Amazon S3 resource that is an AWS Lambda function\'s event trigger associated with this job.</p>', 'LambdaResource$LambdaArn' => '<p>An Amazon Resource Name (ARN) that represents an AWS Lambda function to be triggered by PUT object actions on the associated local Amazon S3 resource.</p>', 'S3Resource$BucketArn' => '<p>The Amazon Resource Name (ARN) of an Amazon S3 bucket.</p>', ], ], 'RoleARN' => [ 'base' => NULL, 'refs' => [ 'ClusterMetadata$RoleARN' => '<p>The role ARN associated with this cluster. This ARN was created using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in AWS Identity and Access Management (IAM).</p>', 'CreateClusterRequest$RoleARN' => '<p>The <code>RoleARN</code> that you want to associate with this cluster. <code>RoleArn</code> values are created by using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in AWS Identity and Access Management (IAM).</p>', 'CreateJobRequest$RoleARN' => '<p>The <code>RoleARN</code> that you want to associate with this job. <code>RoleArn</code>s are created using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> AWS Identity and Access Management (IAM) API action.</p>', 'JobMetadata$RoleARN' => '<p>The role ARN associated with this job. This ARN was created using the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in AWS Identity and Access Management (IAM).</p>', 'UpdateClusterRequest$RoleARN' => '<p>The new role Amazon Resource Name (ARN) that you want to associate with this cluster. To create a role ARN, use the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a> API action in AWS Identity and Access Management (IAM).</p>', 'UpdateJobRequest$RoleARN' => '<p>The new role Amazon Resource Name (ARN) that you want to associate with this job. To create a role ARN, use the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html">CreateRole</a>AWS Identity and Access Management (IAM) API action.</p>', ], ], 'S3Resource' => [ 'base' => '<p>Each <code>S3Resource</code> object represents an Amazon S3 bucket that your transferred data will be exported from or imported into. For export jobs, this object can have an optional <code>KeyRange</code> value. The length of the range is defined at job creation, and has either an inclusive <code>BeginMarker</code>, an inclusive <code>EndMarker</code>, or both. Ranges are UTF-8 binary sorted.</p>', 'refs' => [ 'S3ResourceList$member' => NULL, ], ], 'S3ResourceList' => [ 'base' => NULL, 'refs' => [ 'JobResource$S3Resources' => '<p>An array of <code>S3Resource</code> objects.</p>', ], ], 'Shipment' => [ 'base' => '<p>The <code>Status</code> and <code>TrackingNumber</code> information for an inbound or outbound shipment.</p>', 'refs' => [ 'ShippingDetails$InboundShipment' => '<p>The <code>Status</code> and <code>TrackingNumber</code> values for a Snowball being returned to AWS for a particular job.</p>', 'ShippingDetails$OutboundShipment' => '<p>The <code>Status</code> and <code>TrackingNumber</code> values for a Snowball being delivered to the address that you specified for a particular job.</p>', ], ], 'ShippingDetails' => [ 'base' => '<p>A job\'s shipping information, including inbound and outbound tracking numbers and shipping speed options.</p>', 'refs' => [ 'JobMetadata$ShippingDetails' => '<p>A job\'s shipping information, including inbound and outbound tracking numbers and shipping speed options.</p>', ], ], 'ShippingOption' => [ 'base' => NULL, 'refs' => [ 'ClusterMetadata$ShippingOption' => '<p>The shipping speed for each node in this cluster. This speed doesn\'t dictate how soon you\'ll get each Snowball Edge device, rather it represents how quickly each device moves to its destination while in transit. Regional shipping speeds are as follows:</p> <ul> <li> <p>In Australia, you have access to express shipping. Typically, devices shipped express are delivered in about a day.</p> </li> <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snowball Edges shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li> <li> <p>In India, Snowball Edges are delivered in one to seven days.</p> </li> <li> <p>In the US, you have access to one-day shipping and two-day shipping.</p> </li> </ul>', 'CreateClusterRequest$ShippingOption' => '<p>The shipping speed for each node in this cluster. This speed doesn\'t dictate how soon you\'ll get each Snowball Edge device, rather it represents how quickly each device moves to its destination while in transit. Regional shipping speeds are as follows: </p> <ul> <li> <p>In Australia, you have access to express shipping. Typically, Snowballs shipped express are delivered in about a day.</p> </li> <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snowballs shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li> <li> <p>In India, Snowballs are delivered in one to seven days.</p> </li> <li> <p>In the United States of America (US), you have access to one-day shipping and two-day shipping.</p> </li> </ul> <ul> <li> <p>In Australia, you have access to express shipping. Typically, devices shipped express are delivered in about a day.</p> </li> <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snowball Edges shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li> <li> <p>In India, Snowball Edges are delivered in one to seven days.</p> </li> <li> <p>In the US, you have access to one-day shipping and two-day shipping.</p> </li> </ul>', 'CreateJobRequest$ShippingOption' => '<p>The shipping speed for this job. This speed doesn\'t dictate how soon you\'ll get the Snowball, rather it represents how quickly the Snowball moves to its destination while in transit. Regional shipping speeds are as follows:</p> <ul> <li> <p>In Australia, you have access to express shipping. Typically, Snowballs shipped express are delivered in about a day.</p> </li> <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snowballs shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li> <li> <p>In India, Snowballs are delivered in one to seven days.</p> </li> <li> <p>In the US, you have access to one-day shipping and two-day shipping.</p> </li> </ul>', 'ShippingDetails$ShippingOption' => '<p>The shipping speed for a particular job. This speed doesn\'t dictate how soon you\'ll get the Snowball from the job\'s creation date. This speed represents how quickly it moves to its destination while in transit. Regional shipping speeds are as follows:</p> <ul> <li> <p>In Australia, you have access to express shipping. Typically, Snowballs shipped express are delivered in about a day.</p> </li> <li> <p>In the European Union (EU), you have access to express shipping. Typically, Snowballs shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.</p> </li> <li> <p>In India, Snowballs are delivered in one to seven days.</p> </li> <li> <p>In the United States of America (US), you have access to one-day shipping and two-day shipping.</p> </li> </ul>', 'UpdateClusterRequest$ShippingOption' => '<p>The updated shipping option value of this cluster\'s <a>ShippingDetails</a> object.</p>', 'UpdateJobRequest$ShippingOption' => '<p>The updated shipping option value of this job\'s <a>ShippingDetails</a> object.</p>', ], ], 'SnowballCapacity' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$SnowballCapacityPreference' => '<p>If your job is being created in one of the US regions, you have the option of specifying what size Snowball you\'d like for this job. In all other regions, Snowballs come with 80 TB in storage capacity.</p>', 'JobMetadata$SnowballCapacityPreference' => '<p>The Snowball capacity preference for this job, specified at job creation. In US regions, you can choose between 50 TB and 80 TB Snowballs. All other regions use 80 TB capacity Snowballs.</p>', 'UpdateJobRequest$SnowballCapacityPreference' => '<p>The updated <code>SnowballCapacityPreference</code> of this job\'s <a>JobMetadata</a> object. The 50 TB Snowballs are only available in the US regions.</p>', ], ], 'SnowballType' => [ 'base' => NULL, 'refs' => [ 'ClusterMetadata$SnowballType' => '<p>The type of AWS Snowball device to use for this cluster. </p> <note> <p>For cluster jobs, AWS Snowball currently supports only the <code>EDGE</code> device type.</p> </note>', 'CreateClusterRequest$SnowballType' => '<p>The type of AWS Snowball device to use for this cluster. </p> <note> <p>For cluster jobs, AWS Snowball currently supports only the <code>EDGE</code> device type.</p> </note>', 'CreateJobRequest$SnowballType' => '<p>The type of AWS Snowball device to use for this job. </p> <note> <p>For cluster jobs, AWS Snowball currently supports only the <code>EDGE</code> device type.</p> </note> <p>The type of AWS Snowball device to use for this job. Currently, the only supported device type for cluster jobs is <code>EDGE</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/snowball/latest/developer-guide/device-differences.html">Snowball Edge Device Options</a> in the Snowball Edge Developer Guide.</p>', 'JobListEntry$SnowballType' => '<p>The type of device used with this job.</p>', 'JobMetadata$SnowballType' => '<p>The type of device used with this job.</p>', ], ], 'SnowconeDeviceConfiguration' => [ 'base' => '<p>Specifies the device configuration for an AWS Snowcone job. </p>', 'refs' => [ 'DeviceConfiguration$SnowconeDeviceConfiguration' => '<p>Returns information about the device configuration for an AWS Snowcone job.</p>', ], ], 'SnsTopicARN' => [ 'base' => NULL, 'refs' => [ 'Notification$SnsTopicARN' => '<p>The new SNS <code>TopicArn</code> that you want to associate with this job. You can create Amazon Resource Names (ARNs) for topics by using the <a href="https://docs.aws.amazon.com/sns/latest/api/API_CreateTopic.html">CreateTopic</a> Amazon SNS API action.</p> <p>You can subscribe email addresses to an Amazon SNS topic through the AWS Management Console, or by using the <a href="https://docs.aws.amazon.com/sns/latest/api/API_Subscribe.html">Subscribe</a> AWS Simple Notification Service (SNS) API action.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'Address$Name' => '<p>The name of a person to receive a Snowball at an address.</p>', 'Address$Company' => '<p>The name of the company to receive a Snowball at an address.</p>', 'Address$Street1' => '<p>The first line in a street address that a Snowball is to be delivered to.</p>', 'Address$Street2' => '<p>The second line in a street address that a Snowball is to be delivered to.</p>', 'Address$Street3' => '<p>The third line in a street address that a Snowball is to be delivered to.</p>', 'Address$City' => '<p>The city in an address that a Snowball is to be delivered to.</p>', 'Address$StateOrProvince' => '<p>The state or province in an address that a Snowball is to be delivered to.</p>', 'Address$PrefectureOrDistrict' => '<p>This field is no longer used and the value is ignored.</p>', 'Address$Landmark' => '<p>This field is no longer used and the value is ignored.</p>', 'Address$Country' => '<p>The country in an address that a Snowball is to be delivered to.</p>', 'Address$PostalCode' => '<p>The postal code in an address that a Snowball is to be delivered to.</p>', 'Address$PhoneNumber' => '<p>The phone number associated with an address that a Snowball is to be delivered to.</p>', 'ClusterLimitExceededException$Message' => NULL, 'ClusterListEntry$ClusterId' => '<p>The 39-character ID for the cluster that you want to list, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>', 'ClusterListEntry$Description' => '<p>Defines an optional description of the cluster, for example <code>Environmental Data Cluster-01</code>.</p>', 'ClusterMetadata$ClusterId' => '<p>The automatically generated ID for a cluster.</p>', 'ClusterMetadata$Description' => '<p>The optional description of the cluster.</p>', 'CompatibleImage$AmiId' => '<p>The unique identifier for an individual Snowball Edge AMI.</p>', 'CompatibleImage$Name' => '<p>The optional name of a compatible image.</p>', 'CreateAddressResult$AddressId' => '<p>The automatically generated ID for a specific address. You\'ll use this ID when you create a job to specify which address you want the Snowball for that job shipped to.</p>', 'CreateClusterRequest$Description' => '<p>An optional description of this specific cluster, for example <code>Environmental Data Cluster-01</code>.</p>', 'CreateJobRequest$Description' => '<p>Defines an optional description of this specific job, for example <code>Important Photos 2016-08-11</code>.</p>', 'DescribeAddressesRequest$NextToken' => '<p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>ADDRESS</code> objects, you have the option of specifying a value for <code>NextToken</code> as the starting point for your list of returned addresses.</p>', 'DescribeAddressesResult$NextToken' => '<p>HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in your next <code>DescribeAddresses</code> call, your list of returned addresses will start from this point in the array.</p>', 'Ec2AmiResource$SnowballAmiId' => '<p>The ID of the AMI on the Snowball Edge device.</p>', 'Ec2RequestFailedException$Message' => NULL, 'GetJobManifestResult$ManifestURI' => '<p>The Amazon S3 presigned URL for the manifest file associated with the specified <code>JobId</code> value.</p>', 'GetJobUnlockCodeResult$UnlockCode' => '<p>The <code>UnlockCode</code> value for the specified job. The <code>UnlockCode</code> value can be accessed for up to 90 days after the job has been created.</p>', 'GetSoftwareUpdatesResult$UpdatesURI' => '<p>The Amazon S3 presigned URL for the update file associated with the specified <code>JobId</code> value. The software update will be available for 2 days after this request is made. To access an update after the 2 days have passed, you\'ll have to make another call to <code>GetSoftwareUpdates</code>.</p>', 'InvalidAddressException$Message' => NULL, 'InvalidInputCombinationException$Message' => NULL, 'InvalidJobStateException$Message' => NULL, 'InvalidNextTokenException$Message' => NULL, 'InvalidResourceException$Message' => NULL, 'InvalidResourceException$ResourceType' => '<p>The provided resource value is invalid.</p>', 'JobListEntry$JobId' => '<p>The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>', 'JobListEntry$Description' => '<p>The optional description of this specific job, for example <code>Important Photos 2016-08-11</code>.</p>', 'JobLogs$JobCompletionReportURI' => '<p>A link to an Amazon S3 presigned URL where the job completion report is located.</p>', 'JobLogs$JobSuccessLogURI' => '<p>A link to an Amazon S3 presigned URL where the job success log is located.</p>', 'JobLogs$JobFailureLogURI' => '<p>A link to an Amazon S3 presigned URL where the job failure log is located.</p>', 'JobMetadata$JobId' => '<p>The automatically generated ID for a job, for example <code>JID123e4567-e89b-12d3-a456-426655440000</code>.</p>', 'JobMetadata$Description' => '<p>The description of the job, provided at job creation.</p>', 'JobMetadata$ClusterId' => '<p>The 39-character ID for the cluster, for example <code>CID123e4567-e89b-12d3-a456-426655440000</code>.</p>', 'KMSRequestFailedException$Message' => NULL, 'KeyRange$BeginMarker' => '<p>The key that starts an optional key range for an export job. Ranges are inclusive and UTF-8 binary sorted.</p>', 'KeyRange$EndMarker' => '<p>The key that ends an optional key range for an export job. Ranges are inclusive and UTF-8 binary sorted.</p>', 'ListClusterJobsRequest$NextToken' => '<p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>JobListEntry</code> objects, you have the option of specifying <code>NextToken</code> as the starting point for your returned list.</p>', 'ListClusterJobsResult$NextToken' => '<p>HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in your next <code>ListClusterJobsResult</code> call, your list of returned jobs will start from this point in the array.</p>', 'ListClustersRequest$NextToken' => '<p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>ClusterListEntry</code> objects, you have the option of specifying <code>NextToken</code> as the starting point for your returned list.</p>', 'ListClustersResult$NextToken' => '<p>HTTP requests are stateless. If you use the automatically generated <code>NextToken</code> value in your next <code>ClusterListEntry</code> call, your list of returned clusters will start from this point in the array.</p>', 'ListCompatibleImagesRequest$NextToken' => '<p>HTTP requests are stateless. To identify what object comes "next" in the list of compatible images, you can specify a value for <code>NextToken</code> as the starting point for your list of returned images.</p>', 'ListCompatibleImagesResult$NextToken' => '<p>Because HTTP requests are stateless, this is the starting point for your next list of returned images.</p>', 'ListJobsRequest$NextToken' => '<p>HTTP requests are stateless. To identify what object comes "next" in the list of <code>JobListEntry</code> objects, you have the option of specifying <code>NextToken</code> as the starting point for your returned list.</p>', 'ListJobsResult$NextToken' => '<p>HTTP requests are stateless. If you use this automatically generated <code>NextToken</code> value in your next <code>ListJobs</code> call, your returned <code>JobListEntry</code> objects will start from this point in the array.</p>', 'Shipment$Status' => '<p>Status information for a shipment.</p>', 'Shipment$TrackingNumber' => '<p>The tracking number for this job. Using this tracking number with your region\'s carrier\'s website, you can track a Snowball as the carrier transports it.</p> <p>For India, the carrier is Amazon Logistics. For all other regions, UPS is the carrier.</p>', 'UnsupportedAddressException$Message' => NULL, 'UpdateClusterRequest$Description' => '<p>The updated description of this cluster.</p>', 'UpdateJobRequest$Description' => '<p>The updated description of this job\'s <a>JobMetadata</a> object.</p>', ], ], 'TaxDocuments' => [ 'base' => '<p>The tax documents required in your AWS Region.</p>', 'refs' => [ 'ClusterMetadata$TaxDocuments' => '<p>The tax documents required in your AWS Region.</p>', 'CreateClusterRequest$TaxDocuments' => '<p>The tax documents required in your AWS Region.</p>', 'CreateJobRequest$TaxDocuments' => '<p>The tax documents required in your AWS Region.</p>', 'JobMetadata$TaxDocuments' => '<p>The metadata associated with the tax documents required in your AWS Region.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ClusterListEntry$CreationDate' => '<p>The creation date for this cluster.</p>', 'ClusterMetadata$CreationDate' => '<p>The creation date for this cluster.</p>', 'JobListEntry$CreationDate' => '<p>The creation date for this job.</p>', 'JobMetadata$CreationDate' => '<p>The creation date for this job.</p>', ], ], 'UnsupportedAddressException' => [ 'base' => '<p>The address is either outside the serviceable area for your region, or an error occurred. Check the address with your region\'s carrier and try again. If the issue persists, contact AWS Support.</p>', 'refs' => [], ], 'UpdateClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'UpdateJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateJobResult' => [ 'base' => NULL, 'refs' => [], ], 'WirelessConnection' => [ 'base' => '<p>Configures the wireless connection on an AWS Snowcone device.</p>', 'refs' => [ 'SnowconeDeviceConfiguration$WirelessConnection' => '<p>Configures the wireless connection for the AWS Snowcone device.</p>', ], ], ],];
