<?php
// This file was auto-generated from sdk-root/src/data/sesv2/2019-09-27/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon SES API v2</fullname> <p>Welcome to the Amazon SES API v2 Reference. This guide provides information about the Amazon SES API v2, including supported operations, data types, parameters, and schemas.</p> <p> <a href="https://aws.amazon.com/pinpoint">Amazon SES</a> is an AWS service that you can use to send email messages to your customers.</p> <p>If you\'re new to Amazon SES API v2, you might find it helpful to also review the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/">Amazon Simple Email Service Developer Guide</a>. The <i>Amazon SES Developer Guide</i> provides information and code samples that demonstrate how to use Amazon SES API v2 features programmatically.</p> <p>The Amazon SES API v2 is available in several AWS Regions and it provides an endpoint for each of these Regions. For a list of all the Regions and endpoints where the API is currently available, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#ses_region">AWS Service Endpoints</a> in the <i>Amazon Web Services General Reference</i>. To learn more about AWS Regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html">Managing AWS Regions</a> in the <i>Amazon Web Services General Reference</i>.</p> <p>In each Region, AWS maintains multiple Availability Zones. These Availability Zones are physically isolated from each other, but are united by private, low-latency, high-throughput, and highly redundant network connections. These Availability Zones enable us to provide very high levels of availability and redundancy, while also minimizing latency. To learn more about the number of Availability Zones that are available in each Region, see <a href="http://aws.amazon.com/about-aws/global-infrastructure/">AWS Global Infrastructure</a>.</p>', 'operations' => [ 'CreateConfigurationSet' => '<p>Create a configuration set. <i>Configuration sets</i> are groups of rules that you can apply to the emails that you send. You apply a configuration set to an email by specifying the name of the configuration set when you call the Amazon SES API v2. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email. </p>', 'CreateConfigurationSetEventDestination' => '<p>Create an event destination. <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event destinations</i> are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.</p> <p>A single configuration set can include more than one event destination.</p>', 'CreateCustomVerificationEmailTemplate' => '<p>Creates a new custom verification email template.</p> <p>For more information about custom verification email templates, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html">Using Custom Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.</p> <p>You can execute this operation no more than once per second.</p>', 'CreateDedicatedIpPool' => '<p>Create a new pool of dedicated IP addresses. A pool can include one or more dedicated IP addresses that are associated with your AWS account. You can associate a pool with a configuration set. When you send an email that uses that configuration set, the message is sent from one of the addresses in the associated pool.</p>', 'CreateDeliverabilityTestReport' => '<p>Create a new predictive inbox placement test. Predictive inbox placement tests can help you predict how your messages will be handled by various email providers around the world. When you perform a predictive inbox placement test, you provide a sample message that contains the content that you plan to send to your customers. Amazon SES then sends that message to special email addresses spread across several major email providers. After about 24 hours, the test is complete, and you can use the <code>GetDeliverabilityTestReport</code> operation to view the results of the test.</p>', 'CreateEmailIdentity' => '<p>Starts the process of verifying an email identity. An <i>identity</i> is an email address or domain that you use when you send email. Before you can use an identity to send email, you first have to verify it. By verifying an identity, you demonstrate that you\'re the owner of the identity, and that you\'ve given Amazon SES API v2 permission to send email from the identity.</p> <p>When you verify an email address, Amazon SES sends an email to the address. Your email address is verified as soon as you follow the link in the verification email. </p> <p>When you verify a domain without specifying the <code>DkimSigningAttributes</code> object, this operation provides a set of DKIM tokens. You can convert these tokens into CNAME records, which you then add to the DNS configuration for your domain. Your domain is verified when Amazon SES detects these records in the DNS configuration for your domain. This verification method is known as <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p> <p>Alternatively, you can perform the verification process by providing your own public-private key pair. This verification method is known as Bring Your Own DKIM (BYODKIM). To use BYODKIM, your call to the <code>CreateEmailIdentity</code> operation has to include the <code>DkimSigningAttributes</code> object. When you specify this object, you provide a selector (a component of the DNS record name that identifies the public key that you want to use for DKIM authentication) and a private key.</p>', 'CreateEmailIdentityPolicy' => '<p>Creates the specified sending authorization policy for the given identity (an email address or a domain).</p> <note> <p>This API is for the identity owner only. If you have not verified the identity, this API will return an error.</p> </note> <p>Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p> <p>You can execute this operation no more than once per second.</p>', 'CreateEmailTemplate' => '<p>Creates an email template. Email templates enable you to send personalized email to one or more destinations in a single API operation. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES Developer Guide</a>.</p> <p>You can execute this operation no more than once per second.</p>', 'DeleteConfigurationSet' => '<p>Delete an existing configuration set.</p> <p> <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.</p>', 'DeleteConfigurationSetEventDestination' => '<p>Delete an event destination.</p> <p> <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event destinations</i> are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.</p>', 'DeleteCustomVerificationEmailTemplate' => '<p>Deletes an existing custom verification email template.</p> <p>For more information about custom verification email templates, see <a href="https://docs.aws.amazon.com/es/latest/DeveloperGuide/send-email-verify-address-custom.html">Using Custom Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.</p> <p>You can execute this operation no more than once per second.</p>', 'DeleteDedicatedIpPool' => '<p>Delete a dedicated IP pool.</p>', 'DeleteEmailIdentity' => '<p>Deletes an email identity. An identity can be either an email address or a domain name.</p>', 'DeleteEmailIdentityPolicy' => '<p>Deletes the specified sending authorization policy for the given identity (an email address or a domain). This API returns successfully even if a policy with the specified name does not exist.</p> <note> <p>This API is for the identity owner only. If you have not verified the identity, this API will return an error.</p> </note> <p>Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p> <p>You can execute this operation no more than once per second.</p>', 'DeleteEmailTemplate' => '<p>Deletes an email template.</p> <p>You can execute this operation no more than once per second.</p>', 'DeleteSuppressedDestination' => '<p>Removes an email address from the suppression list for your account.</p>', 'GetAccount' => '<p>Obtain information about the email-sending status and capabilities of your Amazon SES account in the current AWS Region.</p>', 'GetBlacklistReports' => '<p>Retrieve a list of the blacklists that your dedicated IP addresses appear on.</p>', 'GetConfigurationSet' => '<p>Get information about an existing configuration set, including the dedicated IP pool that it\'s associated with, whether or not it\'s enabled for sending email, and more.</p> <p> <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.</p>', 'GetConfigurationSetEventDestinations' => '<p>Retrieve a list of event destinations that are associated with a configuration set.</p> <p> <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event destinations</i> are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.</p>', 'GetCustomVerificationEmailTemplate' => '<p>Returns the custom email verification template for the template name you specify.</p> <p>For more information about custom verification email templates, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html">Using Custom Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.</p> <p>You can execute this operation no more than once per second.</p>', 'GetDedicatedIp' => '<p>Get information about a dedicated IP address, including the name of the dedicated IP pool that it\'s associated with, as well information about the automatic warm-up process for the address.</p>', 'GetDedicatedIps' => '<p>List the dedicated IP addresses that are associated with your AWS account.</p>', 'GetDeliverabilityDashboardOptions' => '<p>Retrieve information about the status of the Deliverability dashboard for your account. When the Deliverability dashboard is enabled, you gain access to reputation, deliverability, and other metrics for the domains that you use to send email. You also gain the ability to perform predictive inbox placement tests.</p> <p>When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees that you accrue by using Amazon SES and other AWS services. For more information about the features and cost of a Deliverability dashboard subscription, see <a href="http://aws.amazon.com/ses/pricing/">Amazon SES Pricing</a>.</p>', 'GetDeliverabilityTestReport' => '<p>Retrieve the results of a predictive inbox placement test.</p>', 'GetDomainDeliverabilityCampaign' => '<p>Retrieve all the deliverability data for a specific campaign. This data is available for a campaign only if the campaign sent email by using a domain that the Deliverability dashboard is enabled for.</p>', 'GetDomainStatisticsReport' => '<p>Retrieve inbox placement and engagement rates for the domains that you use to send email.</p>', 'GetEmailIdentity' => '<p>Provides information about a specific identity, including the identity\'s verification status, sending authorization policies, its DKIM authentication status, and its custom Mail-From settings.</p>', 'GetEmailIdentityPolicies' => '<p>Returns the requested sending authorization policies for the given identity (an email address or a domain). The policies are returned as a map of policy names to policy contents. You can retrieve a maximum of 20 policies at a time.</p> <note> <p>This API is for the identity owner only. If you have not verified the identity, this API will return an error.</p> </note> <p>Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p> <p>You can execute this operation no more than once per second.</p>', 'GetEmailTemplate' => '<p>Displays the template object (which includes the subject line, HTML part and text part) for the template you specify.</p> <p>You can execute this operation no more than once per second.</p>', 'GetSuppressedDestination' => '<p>Retrieves information about a specific email address that\'s on the suppression list for your account.</p>', 'ListConfigurationSets' => '<p>List all of the configuration sets associated with your account in the current region.</p> <p> <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.</p>', 'ListCustomVerificationEmailTemplates' => '<p>Lists the existing custom verification email templates for your account in the current AWS Region.</p> <p>For more information about custom verification email templates, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html">Using Custom Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.</p> <p>You can execute this operation no more than once per second.</p>', 'ListDedicatedIpPools' => '<p>List all of the dedicated IP pools that exist in your AWS account in the current Region.</p>', 'ListDeliverabilityTestReports' => '<p>Show a list of the predictive inbox placement tests that you\'ve performed, regardless of their statuses. For predictive inbox placement tests that are complete, you can use the <code>GetDeliverabilityTestReport</code> operation to view the results.</p>', 'ListDomainDeliverabilityCampaigns' => '<p>Retrieve deliverability data for all the campaigns that used a specific domain to send email during a specified time range. This data is available for a domain only if you enabled the Deliverability dashboard for the domain.</p>', 'ListEmailIdentities' => '<p>Returns a list of all of the email identities that are associated with your AWS account. An identity can be either an email address or a domain. This operation returns identities that are verified as well as those that aren\'t. This operation returns identities that are associated with Amazon SES and Amazon Pinpoint.</p>', 'ListEmailTemplates' => '<p>Lists the email templates present in your Amazon SES account in the current AWS Region.</p> <p>You can execute this operation no more than once per second.</p>', 'ListSuppressedDestinations' => '<p>Retrieves a list of email addresses that are on the suppression list for your account.</p>', 'ListTagsForResource' => '<p>Retrieve a list of the tags (keys and values) that are associated with a specified resource. A <i>tag</i> is a label that you optionally define and associate with a resource. Each tag consists of a required <i>tag key</i> and an optional associated <i>tag value</i>. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.</p>', 'PutAccountDedicatedIpWarmupAttributes' => '<p>Enable or disable the automatic warm-up feature for dedicated IP addresses.</p>', 'PutAccountDetails' => '<p>Update your Amazon SES account details.</p>', 'PutAccountSendingAttributes' => '<p>Enable or disable the ability of your account to send email.</p>', 'PutAccountSuppressionAttributes' => '<p>Change the settings for the account-level suppression list.</p>', 'PutConfigurationSetDeliveryOptions' => '<p>Associate a configuration set with a dedicated IP pool. You can use dedicated IP pools to create groups of dedicated IP addresses for sending specific types of email.</p>', 'PutConfigurationSetReputationOptions' => '<p>Enable or disable collection of reputation metrics for emails that you send using a particular configuration set in a specific AWS Region.</p>', 'PutConfigurationSetSendingOptions' => '<p>Enable or disable email sending for messages that use a particular configuration set in a specific AWS Region.</p>', 'PutConfigurationSetSuppressionOptions' => '<p>Specify the account suppression list preferences for a configuration set.</p>', 'PutConfigurationSetTrackingOptions' => '<p>Specify a custom domain to use for open and click tracking elements in email that you send.</p>', 'PutDedicatedIpInPool' => '<p>Move a dedicated IP address to an existing dedicated IP pool.</p> <note> <p>The dedicated IP address that you specify must already exist, and must be associated with your AWS account. </p> <p>The dedicated IP pool you specify must already exist. You can create a new pool by using the <code>CreateDedicatedIpPool</code> operation.</p> </note>', 'PutDedicatedIpWarmupAttributes' => '<p/>', 'PutDeliverabilityDashboardOption' => '<p>Enable or disable the Deliverability dashboard. When you enable the Deliverability dashboard, you gain access to reputation, deliverability, and other metrics for the domains that you use to send email. You also gain the ability to perform predictive inbox placement tests.</p> <p>When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees that you accrue by using Amazon SES and other AWS services. For more information about the features and cost of a Deliverability dashboard subscription, see <a href="http://aws.amazon.com/ses/pricing/">Amazon SES Pricing</a>.</p>', 'PutEmailIdentityDkimAttributes' => '<p>Used to enable or disable DKIM authentication for an email identity.</p>', 'PutEmailIdentityDkimSigningAttributes' => '<p>Used to configure or change the DKIM authentication settings for an email domain identity. You can use this operation to do any of the following:</p> <ul> <li> <p>Update the signing attributes for an identity that uses Bring Your Own DKIM (BYODKIM).</p> </li> <li> <p>Change from using no DKIM authentication to using Easy DKIM.</p> </li> <li> <p>Change from using no DKIM authentication to using BYODKIM.</p> </li> <li> <p>Change from using Easy DKIM to using BYODKIM.</p> </li> <li> <p>Change from using BYODKIM to using Easy DKIM.</p> </li> </ul>', 'PutEmailIdentityFeedbackAttributes' => '<p>Used to enable or disable feedback forwarding for an identity. This setting determines what happens when an identity is used to send an email that results in a bounce or complaint event.</p> <p>If the value is <code>true</code>, you receive email notifications when bounce or complaint events occur. These notifications are sent to the address that you specified in the <code>Return-Path</code> header of the original email.</p> <p>You\'re required to have a method of tracking bounces and complaints. If you haven\'t set up another mechanism for receiving bounce or complaint notifications (for example, by setting up an event destination), you receive an email notification when these events occur (even if this setting is disabled).</p>', 'PutEmailIdentityMailFromAttributes' => '<p>Used to enable or disable the custom Mail-From domain configuration for an email identity.</p>', 'PutSuppressedDestination' => '<p>Adds an email address to the suppression list for your account.</p>', 'SendBulkEmail' => '<p>Composes an email message to multiple destinations.</p>', 'SendCustomVerificationEmail' => '<p>Adds an email address to the list of identities for your Amazon SES account in the current AWS Region and attempts to verify it. As a result of executing this operation, a customized verification email is sent to the specified address.</p> <p>To use this operation, you must first create a custom verification email template. For more information about creating and using custom verification email templates, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html">Using Custom Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.</p> <p>You can execute this operation no more than once per second.</p>', 'SendEmail' => '<p>Sends an email message. You can use the Amazon SES API v2 to send two types of messages:</p> <ul> <li> <p> <b>Simple</b> – A standard email message. When you create this type of message, you specify the sender, the recipient, and the message body, and Amazon SES assembles the message for you.</p> </li> <li> <p> <b>Raw</b> – A raw, MIME-formatted email message. When you send this type of email, you have to specify all of the message headers, as well as the message body. You can use this message type to send messages that contain attachments. The message that you specify has to be a valid MIME message.</p> </li> <li> <p> <b>Templated</b> – A message that contains personalization tags. When you send this type of email, Amazon SES API v2 automatically replaces the tags with values that you specify.</p> </li> </ul>', 'TagResource' => '<p>Add one or more tags (keys and values) to a specified resource. A <i>tag</i> is a label that you optionally define and associate with a resource. Tags can help you categorize and manage resources in different ways, such as by purpose, owner, environment, or other criteria. A resource can have as many as 50 tags.</p> <p>Each tag consists of a required <i>tag key</i> and an associated <i>tag value</i>, both of which you define. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.</p>', 'TestRenderEmailTemplate' => '<p>Creates a preview of the MIME content of an email when provided with a template and a set of replacement data.</p> <p>You can execute this operation no more than once per second.</p>', 'UntagResource' => '<p>Remove one or more tags (keys and values) from a specified resource.</p>', 'UpdateConfigurationSetEventDestination' => '<p>Update the configuration of an event destination for a configuration set.</p> <p> <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event destinations</i> are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.</p>', 'UpdateCustomVerificationEmailTemplate' => '<p>Updates an existing custom verification email template.</p> <p>For more information about custom verification email templates, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html">Using Custom Verification Email Templates</a> in the <i>Amazon SES Developer Guide</i>.</p> <p>You can execute this operation no more than once per second.</p>', 'UpdateEmailIdentityPolicy' => '<p>Updates the specified sending authorization policy for the given identity (an email address or a domain). This API returns successfully even if a policy with the specified name does not exist.</p> <note> <p>This API is for the identity owner only. If you have not verified the identity, this API will return an error.</p> </note> <p>Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p> <p>You can execute this operation no more than once per second.</p>', 'UpdateEmailTemplate' => '<p>Updates an email template. Email templates enable you to send personalized email to one or more destinations in a single API operation. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES Developer Guide</a>.</p> <p>You can execute this operation no more than once per second.</p>', ], 'shapes' => [ 'AccountDetails' => [ 'base' => '<p>An object that contains information about your account details.</p>', 'refs' => [ 'GetAccountResponse$Details' => '<p>An object that defines your account details.</p>', ], ], 'AccountSuspendedException' => [ 'base' => '<p>The message can\'t be sent because the account\'s ability to send email has been permanently restricted.</p>', 'refs' => [], ], 'AdditionalContactEmailAddress' => [ 'base' => NULL, 'refs' => [ 'AdditionalContactEmailAddresses$member' => NULL, ], ], 'AdditionalContactEmailAddresses' => [ 'base' => NULL, 'refs' => [ 'AccountDetails$AdditionalContactEmailAddresses' => '<p>Additional email addresses where updates are sent about your account review process.</p>', 'PutAccountDetailsRequest$AdditionalContactEmailAddresses' => '<p>Additional email addresses that you would like to be notified regarding Amazon SES matters.</p>', ], ], 'AlreadyExistsException' => [ 'base' => '<p>The resource specified in your request already exists.</p>', 'refs' => [], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'KinesisFirehoseDestination$IamRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that the Amazon SES API v2 uses to send email events to the Amazon Kinesis Data Firehose stream.</p>', 'KinesisFirehoseDestination$DeliveryStreamArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Kinesis Data Firehose stream that the Amazon SES API v2 sends email events to.</p>', 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want to retrieve tag information for.</p>', 'PinpointDestination$ApplicationArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Pinpoint project that you want to send email events to.</p>', 'SendBulkEmailRequest$FromEmailAddressIdentityArn' => '<p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FromEmailAddress</code> parameter.</p> <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use sender@example.com, then you would specify the <code>FromEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FromEmailAddress</code> to be sender@example.com.</p> <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>', 'SendBulkEmailRequest$FeedbackForwardingEmailAddressIdentityArn' => '<p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FeedbackForwardingEmailAddress</code> parameter.</p> <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use feedback@example.com, then you would specify the <code>FeedbackForwardingEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FeedbackForwardingEmailAddress</code> to be feedback@example.com.</p> <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>', 'SendEmailRequest$FromEmailAddressIdentityArn' => '<p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FromEmailAddress</code> parameter.</p> <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use sender@example.com, then you would specify the <code>FromEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FromEmailAddress</code> to be sender@example.com.</p> <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p> <p>For Raw emails, the <code>FromEmailAddressIdentityArn</code> value overrides the X-SES-SOURCE-ARN and X-SES-FROM-ARN headers specified in raw email message content.</p>', 'SendEmailRequest$FeedbackForwardingEmailAddressIdentityArn' => '<p>This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the <code>FeedbackForwardingEmailAddress</code> parameter.</p> <p>For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use feedback@example.com, then you would specify the <code>FeedbackForwardingEmailAddressIdentityArn</code> to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the <code>FeedbackForwardingEmailAddress</code> to be feedback@example.com.</p> <p>For more information about sending authorization, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>', 'SnsDestination$TopicArn' => '<p>The Amazon Resource Name (ARN) of the Amazon SNS topic that you want to publish email events to. For more information about Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.</p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want to add one or more tags to.</p>', 'Template$TemplateArn' => '<p>The Amazon Resource Name (ARN) of the template.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want to remove one or more tags from.</p>', ], ], 'BadRequestException' => [ 'base' => '<p>The input you provided is invalid.</p>', 'refs' => [], ], 'BehaviorOnMxFailure' => [ 'base' => '<p>The action that you want to take if the required MX record can\'t be found when you send an email. When you set this value to <code>UseDefaultValue</code>, the mail is sent using <i>amazonses.com</i> as the MAIL FROM domain. When you set this value to <code>RejectMessage</code>, the Amazon SES API v2 returns a <code>MailFromDomainNotVerified</code> error, and doesn\'t attempt to deliver the email.</p> <p>These behaviors are taken when the custom MAIL FROM domain configuration is in the <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code> states.</p>', 'refs' => [ 'MailFromAttributes$BehaviorOnMxFailure' => '<p>The action that you want to take if the required MX record can\'t be found when you send an email. When you set this value to <code>UseDefaultValue</code>, the mail is sent using <i>amazonses.com</i> as the MAIL FROM domain. When you set this value to <code>RejectMessage</code>, the Amazon SES API v2 returns a <code>MailFromDomainNotVerified</code> error, and doesn\'t attempt to deliver the email.</p> <p>These behaviors are taken when the custom MAIL FROM domain configuration is in the <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code> states.</p>', 'PutEmailIdentityMailFromAttributesRequest$BehaviorOnMxFailure' => '<p>The action that you want to take if the required MX record isn\'t found when you send an email. When you set this value to <code>UseDefaultValue</code>, the mail is sent using <i>amazonses.com</i> as the MAIL FROM domain. When you set this value to <code>RejectMessage</code>, the Amazon SES API v2 returns a <code>MailFromDomainNotVerified</code> error, and doesn\'t attempt to deliver the email.</p> <p>These behaviors are taken when the custom MAIL FROM domain configuration is in the <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code> states.</p>', ], ], 'BlacklistEntries' => [ 'base' => NULL, 'refs' => [ 'BlacklistReport$value' => NULL, ], ], 'BlacklistEntry' => [ 'base' => '<p>An object that contains information about a blacklisting event that impacts one of the dedicated IP addresses that is associated with your account.</p>', 'refs' => [ 'BlacklistEntries$member' => NULL, ], ], 'BlacklistItemName' => [ 'base' => '<p>An IP address that you want to obtain blacklist information for.</p>', 'refs' => [ 'BlacklistItemNames$member' => NULL, 'BlacklistReport$key' => NULL, ], ], 'BlacklistItemNames' => [ 'base' => NULL, 'refs' => [ 'GetBlacklistReportsRequest$BlacklistItemNames' => '<p>A list of IP addresses that you want to retrieve blacklist information about. You can only specify the dedicated IP addresses that you use to send email using Amazon SES or Amazon Pinpoint.</p>', ], ], 'BlacklistReport' => [ 'base' => NULL, 'refs' => [ 'GetBlacklistReportsResponse$BlacklistReport' => '<p>An object that contains information about a blacklist that one of your dedicated IP addresses appears on.</p>', ], ], 'BlacklistingDescription' => [ 'base' => '<p>A description of the blacklisting event.</p>', 'refs' => [ 'BlacklistEntry$Description' => '<p>Additional information about the blacklisting event, as provided by the blacklist maintainer.</p>', ], ], 'Body' => [ 'base' => '<p>Represents the body of the email message.</p>', 'refs' => [ 'Message$Body' => '<p>The body of the message. You can specify an HTML version of the message, a text-only version of the message, or both.</p>', ], ], 'BulkEmailContent' => [ 'base' => '<p>An object that contains the body of the message. You can specify a template message.</p>', 'refs' => [ 'SendBulkEmailRequest$DefaultContent' => '<p>An object that contains the body of the message. You can specify a template message.</p>', ], ], 'BulkEmailEntry' => [ 'base' => NULL, 'refs' => [ 'BulkEmailEntryList$member' => NULL, ], ], 'BulkEmailEntryList' => [ 'base' => '<p>A list of <code>BulkEmailEntry</code> objects.</p>', 'refs' => [ 'SendBulkEmailRequest$BulkEmailEntries' => '<p>The list of bulk email entry objects.</p>', ], ], 'BulkEmailEntryResult' => [ 'base' => '<p>The result of the <code>SendBulkEmail</code> operation of each specified <code>BulkEmailEntry</code>.</p>', 'refs' => [ 'BulkEmailEntryResultList$member' => NULL, ], ], 'BulkEmailEntryResultList' => [ 'base' => '<p>A list of <code>BulkMailEntry</code> objects.</p>', 'refs' => [ 'SendBulkEmailResponse$BulkEmailEntryResults' => NULL, ], ], 'BulkEmailStatus' => [ 'base' => NULL, 'refs' => [ 'BulkEmailEntryResult$Status' => '<p>The status of a message sent using the <code>SendBulkTemplatedEmail</code> operation.</p> <p>Possible values for this parameter include:</p> <ul> <li> <p>SUCCESS: Amazon SES accepted the message, and will attempt to deliver it to the recipients.</p> </li> <li> <p>MESSAGE_REJECTED: The message was rejected because it contained a virus.</p> </li> <li> <p>MAIL_FROM_DOMAIN_NOT_VERIFIED: The sender\'s email address or domain was not verified.</p> </li> <li> <p>CONFIGURATION_SET_DOES_NOT_EXIST: The configuration set you specified does not exist.</p> </li> <li> <p>TEMPLATE_DOES_NOT_EXIST: The template you specified does not exist.</p> </li> <li> <p>ACCOUNT_SUSPENDED: Your account has been shut down because of issues related to your email sending practices.</p> </li> <li> <p>ACCOUNT_THROTTLED: The number of emails you can send has been reduced because your account has exceeded its allocated sending limit.</p> </li> <li> <p>ACCOUNT_DAILY_QUOTA_EXCEEDED: You have reached or exceeded the maximum number of emails you can send from your account in a 24-hour period.</p> </li> <li> <p>INVALID_SENDING_POOL_NAME: The configuration set you specified refers to an IP pool that does not exist.</p> </li> <li> <p>ACCOUNT_SENDING_PAUSED: Email sending for the Amazon SES account was disabled using the <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateAccountSendingEnabled.html">UpdateAccountSendingEnabled</a> operation.</p> </li> <li> <p>CONFIGURATION_SET_SENDING_PAUSED: Email sending for this configuration set was disabled using the <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateConfigurationSetSendingEnabled.html">UpdateConfigurationSetSendingEnabled</a> operation.</p> </li> <li> <p>INVALID_PARAMETER_VALUE: One or more of the parameters you specified when calling this operation was invalid. See the error message for additional information.</p> </li> <li> <p>TRANSIENT_FAILURE: Amazon SES was unable to process your request because of a temporary issue.</p> </li> <li> <p>FAILED: Amazon SES was unable to process your request. See the error message for additional information.</p> </li> </ul>', ], ], 'CampaignId' => [ 'base' => NULL, 'refs' => [ 'DomainDeliverabilityCampaign$CampaignId' => '<p>The unique identifier for the campaign. The Deliverability dashboard automatically generates and assigns this identifier to a campaign.</p>', 'GetDomainDeliverabilityCampaignRequest$CampaignId' => '<p>The unique identifier for the campaign. The Deliverability dashboard automatically generates and assigns this identifier to a campaign.</p>', ], ], 'CaseId' => [ 'base' => NULL, 'refs' => [ 'ReviewDetails$CaseId' => '<p>The associated support center case ID (if any).</p>', ], ], 'Charset' => [ 'base' => NULL, 'refs' => [ 'Content$Charset' => '<p>The character set for the content. Because of the constraints of the SMTP protocol, Amazon SES uses 7-bit ASCII by default. If the text includes characters outside of the ASCII range, you have to specify a character set. For example, you could specify <code>UTF-8</code>, <code>ISO-8859-1</code>, or <code>Shift_JIS</code>.</p>', ], ], 'CloudWatchDestination' => [ 'base' => '<p>An object that defines an Amazon CloudWatch destination for email events. You can use Amazon CloudWatch to monitor and gain insights on your email sending metrics.</p>', 'refs' => [ 'EventDestination$CloudWatchDestination' => '<p>An object that defines an Amazon CloudWatch destination for email events. You can use Amazon CloudWatch to monitor and gain insights on your email sending metrics.</p>', 'EventDestinationDefinition$CloudWatchDestination' => '<p>An object that defines an Amazon CloudWatch destination for email events. You can use Amazon CloudWatch to monitor and gain insights on your email sending metrics.</p>', ], ], 'CloudWatchDimensionConfiguration' => [ 'base' => '<p>An object that defines the dimension configuration to use when you send email events to Amazon CloudWatch.</p>', 'refs' => [ 'CloudWatchDimensionConfigurations$member' => NULL, ], ], 'CloudWatchDimensionConfigurations' => [ 'base' => NULL, 'refs' => [ 'CloudWatchDestination$DimensionConfigurations' => '<p>An array of objects that define the dimensions to use when you send email events to Amazon CloudWatch.</p>', ], ], 'ConcurrentModificationException' => [ 'base' => '<p>The resource is being modified by another operation or thread.</p>', 'refs' => [], ], 'ConfigurationSetName' => [ 'base' => '<p>The name of a configuration set.</p> <p> <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.</p>', 'refs' => [ 'ConfigurationSetNameList$member' => NULL, 'CreateConfigurationSetEventDestinationRequest$ConfigurationSetName' => '<p>The name of the configuration set that you want to add an event destination to.</p>', 'CreateConfigurationSetRequest$ConfigurationSetName' => '<p>The name of the configuration set.</p>', 'DeleteConfigurationSetEventDestinationRequest$ConfigurationSetName' => '<p>The name of the configuration set that contains the event destination that you want to delete.</p>', 'DeleteConfigurationSetRequest$ConfigurationSetName' => '<p>The name of the configuration set that you want to delete.</p>', 'GetConfigurationSetEventDestinationsRequest$ConfigurationSetName' => '<p>The name of the configuration set that contains the event destination.</p>', 'GetConfigurationSetRequest$ConfigurationSetName' => '<p>The name of the configuration set that you want to obtain more information about.</p>', 'GetConfigurationSetResponse$ConfigurationSetName' => '<p>The name of the configuration set.</p>', 'PutConfigurationSetDeliveryOptionsRequest$ConfigurationSetName' => '<p>The name of the configuration set that you want to associate with a dedicated IP pool.</p>', 'PutConfigurationSetReputationOptionsRequest$ConfigurationSetName' => '<p>The name of the configuration set that you want to enable or disable reputation metric tracking for.</p>', 'PutConfigurationSetSendingOptionsRequest$ConfigurationSetName' => '<p>The name of the configuration set that you want to enable or disable email sending for.</p>', 'PutConfigurationSetSuppressionOptionsRequest$ConfigurationSetName' => '<p>The name of the configuration set that you want to change the suppression list preferences for.</p>', 'PutConfigurationSetTrackingOptionsRequest$ConfigurationSetName' => '<p>The name of the configuration set that you want to add a custom tracking domain to.</p>', 'SendBulkEmailRequest$ConfigurationSetName' => '<p>The name of the configuration set that you want to use when sending the email.</p>', 'SendCustomVerificationEmailRequest$ConfigurationSetName' => '<p>Name of a configuration set to use when sending the verification email.</p>', 'SendEmailRequest$ConfigurationSetName' => '<p>The name of the configuration set that you want to use when sending the email.</p>', 'UpdateConfigurationSetEventDestinationRequest$ConfigurationSetName' => '<p>The name of the configuration set that contains the event destination that you want to modify.</p>', ], ], 'ConfigurationSetNameList' => [ 'base' => NULL, 'refs' => [ 'ListConfigurationSetsResponse$ConfigurationSets' => '<p>An array that contains all of the configuration sets in your Amazon SES account in the current AWS Region.</p>', ], ], 'ConflictException' => [ 'base' => '<p>If there is already an ongoing account details update under review.</p>', 'refs' => [], ], 'ContactLanguage' => [ 'base' => NULL, 'refs' => [ 'AccountDetails$ContactLanguage' => '<p>The language you would prefer for the case. The contact language can be one of <code>ENGLISH</code> or <code>JAPANESE</code>.</p>', 'PutAccountDetailsRequest$ContactLanguage' => '<p>The language you would prefer to be contacted with.</p>', ], ], 'Content' => [ 'base' => '<p>An object that represents the content of the email, and optionally a character set specification.</p>', 'refs' => [ 'Body$Text' => '<p>An object that represents the version of the message that is displayed in email clients that don\'t support HTML, or clients where the recipient has disabled HTML rendering.</p>', 'Body$Html' => '<p>An object that represents the version of the message that is displayed in email clients that support HTML. HTML messages can include formatted text, hyperlinks, images, and more. </p>', 'Message$Subject' => '<p>The subject line of the email. The subject line can only contain 7-bit ASCII characters. However, you can specify non-ASCII characters in the subject line by using encoded-word syntax, as described in <a href="https://tools.ietf.org/html/rfc2047">RFC 2047</a>.</p>', ], ], 'CreateConfigurationSetEventDestinationRequest' => [ 'base' => '<p>A request to add an event destination to a configuration set.</p>', 'refs' => [], ], 'CreateConfigurationSetEventDestinationResponse' => [ 'base' => '<p>An HTTP 200 response if the request succeeds, or an error message if the request fails.</p>', 'refs' => [], ], 'CreateConfigurationSetRequest' => [ 'base' => '<p>A request to create a configuration set.</p>', 'refs' => [], ], 'CreateConfigurationSetResponse' => [ 'base' => '<p>An HTTP 200 response if the request succeeds, or an error message if the request fails.</p>', 'refs' => [], ], 'CreateCustomVerificationEmailTemplateRequest' => [ 'base' => '<p>Represents a request to create a custom verification email template.</p>', 'refs' => [], ], 'CreateCustomVerificationEmailTemplateResponse' => [ 'base' => '<p>If the action is successful, the service sends back an HTTP 200 response with an empty HTTP body.</p>', 'refs' => [], ], 'CreateDedicatedIpPoolRequest' => [ 'base' => '<p>A request to create a new dedicated IP pool.</p>', 'refs' => [], ], 'CreateDedicatedIpPoolResponse' => [ 'base' => '<p>An HTTP 200 response if the request succeeds, or an error message if the request fails.</p>', 'refs' => [], ], 'CreateDeliverabilityTestReportRequest' => [ 'base' => '<p>A request to perform a predictive inbox placement test. Predictive inbox placement tests can help you predict how your messages will be handled by various email providers around the world. When you perform a predictive inbox placement test, you provide a sample message that contains the content that you plan to send to your customers. We send that message to special email addresses spread across several major email providers around the world. The test takes about 24 hours to complete. When the test is complete, you can use the <code>GetDeliverabilityTestReport</code> operation to view the results of the test.</p>', 'refs' => [], ], 'CreateDeliverabilityTestReportResponse' => [ 'base' => '<p>Information about the predictive inbox placement test that you created.</p>', 'refs' => [], ], 'CreateEmailIdentityPolicyRequest' => [ 'base' => '<p>Represents a request to create a sending authorization policy for an identity. Sending authorization is an Amazon SES feature that enables you to authorize other senders to use your identities. For information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-identity-owner-tasks-management.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'CreateEmailIdentityPolicyResponse' => [ 'base' => '<p>An HTTP 200 response if the request succeeds, or an error message if the request fails.</p>', 'refs' => [], ], 'CreateEmailIdentityRequest' => [ 'base' => '<p>A request to begin the verification process for an email identity (an email address or domain).</p>', 'refs' => [], ], 'CreateEmailIdentityResponse' => [ 'base' => '<p>If the email identity is a domain, this object contains information about the DKIM verification status for the domain.</p> <p>If the email identity is an email address, this object is empty. </p>', 'refs' => [], ], 'CreateEmailTemplateRequest' => [ 'base' => '<p>Represents a request to create an email template. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'CreateEmailTemplateResponse' => [ 'base' => '<p>If the action is successful, the service sends back an HTTP 200 response with an empty HTTP body.</p>', 'refs' => [], ], 'CustomRedirectDomain' => [ 'base' => '<p>The domain that you want to use for tracking open and click events.</p>', 'refs' => [ 'PutConfigurationSetTrackingOptionsRequest$CustomRedirectDomain' => '<p>The domain that you want to use to track open and click events.</p>', 'TrackingOptions$CustomRedirectDomain' => '<p>The domain that you want to use for tracking open and click events.</p>', ], ], 'CustomVerificationEmailTemplateMetadata' => [ 'base' => '<p>Contains information about a custom verification email template.</p>', 'refs' => [ 'CustomVerificationEmailTemplatesList$member' => NULL, ], ], 'CustomVerificationEmailTemplatesList' => [ 'base' => '<p>A list of the custom verification email templates that exist in your account.</p>', 'refs' => [ 'ListCustomVerificationEmailTemplatesResponse$CustomVerificationEmailTemplates' => '<p>A list of the custom verification email templates that exist in your account.</p>', ], ], 'DailyVolume' => [ 'base' => '<p>An object that contains information about the volume of email sent on each day of the analysis period.</p>', 'refs' => [ 'DailyVolumes$member' => NULL, ], ], 'DailyVolumes' => [ 'base' => NULL, 'refs' => [ 'GetDomainStatisticsReportResponse$DailyVolumes' => '<p>An object that contains deliverability metrics for the domain that you specified. This object contains data for each day, starting on the <code>StartDate</code> and ending on the <code>EndDate</code>.</p>', ], ], 'DedicatedIp' => [ 'base' => '<p>Contains information about a dedicated IP address that is associated with your Amazon SES account.</p> <p>To learn more about requesting dedicated IP addresses, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/dedicated-ip-case.html">Requesting and Relinquishing Dedicated IP Addresses</a> in the <i>Amazon SES Developer Guide</i>.</p>', 'refs' => [ 'DedicatedIpList$member' => NULL, 'GetDedicatedIpResponse$DedicatedIp' => '<p>An object that contains information about a dedicated IP address.</p>', ], ], 'DedicatedIpList' => [ 'base' => '<p>A list of dedicated IP addresses that are associated with your AWS account.</p>', 'refs' => [ 'GetDedicatedIpsResponse$DedicatedIps' => '<p>A list of dedicated IP addresses that are associated with your AWS account.</p>', ], ], 'DefaultDimensionValue' => [ 'base' => '<p>The default value of the dimension that is published to Amazon CloudWatch if you don\'t provide the value of the dimension when you send an email. This value has to meet the following criteria:</p> <ul> <li> <p>It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-).</p> </li> <li> <p>It can contain no more than 256 characters.</p> </li> </ul>', 'refs' => [ 'CloudWatchDimensionConfiguration$DefaultDimensionValue' => '<p>The default value of the dimension that is published to Amazon CloudWatch if you don\'t provide the value of the dimension when you send an email. This value has to meet the following criteria:</p> <ul> <li> <p>It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-).</p> </li> <li> <p>It can contain no more than 256 characters.</p> </li> </ul>', ], ], 'DeleteConfigurationSetEventDestinationRequest' => [ 'base' => '<p>A request to delete an event destination from a configuration set.</p>', 'refs' => [], ], 'DeleteConfigurationSetEventDestinationResponse' => [ 'base' => '<p>An HTTP 200 response if the request succeeds, or an error message if the request fails.</p>', 'refs' => [], ], 'DeleteConfigurationSetRequest' => [ 'base' => '<p>A request to delete a configuration set.</p>', 'refs' => [], ], 'DeleteConfigurationSetResponse' => [ 'base' => '<p>An HTTP 200 response if the request succeeds, or an error message if the request fails.</p>', 'refs' => [], ], 'DeleteCustomVerificationEmailTemplateRequest' => [ 'base' => '<p>Represents a request to delete an existing custom verification email template.</p>', 'refs' => [], ], 'DeleteCustomVerificationEmailTemplateResponse' => [ 'base' => '<p>If the action is successful, the service sends back an HTTP 200 response with an empty HTTP body.</p>', 'refs' => [], ], 'DeleteDedicatedIpPoolRequest' => [ 'base' => '<p>A request to delete a dedicated IP pool.</p>', 'refs' => [], ], 'DeleteDedicatedIpPoolResponse' => [ 'base' => '<p>An HTTP 200 response if the request succeeds, or an error message if the request fails.</p>', 'refs' => [], ], 'DeleteEmailIdentityPolicyRequest' => [ 'base' => '<p>Represents a request to delete a sending authorization policy for an identity. Sending authorization is an Amazon SES feature that enables you to authorize other senders to use your identities. For information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-identity-owner-tasks-management.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'DeleteEmailIdentityPolicyResponse' => [ 'base' => '<p>An HTTP 200 response if the request succeeds, or an error message if the request fails.</p>', 'refs' => [], ], 'DeleteEmailIdentityRequest' => [ 'base' => '<p>A request to delete an existing email identity. When you delete an identity, you lose the ability to send email from that identity. You can restore your ability to send email by completing the verification process for the identity again.</p>', 'refs' => [], ], 'DeleteEmailIdentityResponse' => [ 'base' => '<p>An HTTP 200 response if the request succeeds, or an error message if the request fails.</p>', 'refs' => [], ], 'DeleteEmailTemplateRequest' => [ 'base' => '<p>Represents a request to delete an email template. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'DeleteEmailTemplateResponse' => [ 'base' => '<p>If the action is successful, the service sends back an HTTP 200 response with an empty HTTP body.</p>', 'refs' => [], ], 'DeleteSuppressedDestinationRequest' => [ 'base' => '<p>A request to remove an email address from the suppression list for your account.</p>', 'refs' => [], ], 'DeleteSuppressedDestinationResponse' => [ 'base' => '<p>An HTTP 200 response if the request succeeds, or an error message if the request fails.</p>', 'refs' => [], ], 'DeliverabilityDashboardAccountStatus' => [ 'base' => '<p>The current status of your Deliverability dashboard subscription. If this value is <code>PENDING_EXPIRATION</code>, your subscription is scheduled to expire at the end of the current calendar month.</p>', 'refs' => [ 'GetDeliverabilityDashboardOptionsResponse$AccountStatus' => '<p>The current status of your Deliverability dashboard subscription. If this value is <code>PENDING_EXPIRATION</code>, your subscription is scheduled to expire at the end of the current calendar month.</p>', ], ], 'DeliverabilityTestReport' => [ 'base' => '<p>An object that contains metadata related to a predictive inbox placement test.</p>', 'refs' => [ 'DeliverabilityTestReports$member' => NULL, 'GetDeliverabilityTestReportResponse$DeliverabilityTestReport' => '<p>An object that contains the results of the predictive inbox placement test.</p>', ], ], 'DeliverabilityTestReports' => [ 'base' => NULL, 'refs' => [ 'ListDeliverabilityTestReportsResponse$DeliverabilityTestReports' => '<p>An object that contains a lists of predictive inbox placement tests that you\'ve performed.</p>', ], ], 'DeliverabilityTestStatus' => [ 'base' => '<p>The status of a predictive inbox placement test. If the status is <code>IN_PROGRESS</code>, then the predictive inbox placement test is currently running. Predictive inbox placement tests are usually complete within 24 hours of creating the test. If the status is <code>COMPLETE</code>, then the test is finished, and you can use the <code>GetDeliverabilityTestReport</code> operation to view the results of the test.</p>', 'refs' => [ 'CreateDeliverabilityTestReportResponse$DeliverabilityTestStatus' => '<p>The status of the predictive inbox placement test. If the status is <code>IN_PROGRESS</code>, then the predictive inbox placement test is currently running. Predictive inbox placement tests are usually complete within 24 hours of creating the test. If the status is <code>COMPLETE</code>, then the test is finished, and you can use the <code>GetDeliverabilityTestReport</code> to view the results of the test.</p>', 'DeliverabilityTestReport$DeliverabilityTestStatus' => '<p>The status of the predictive inbox placement test. If the status is <code>IN_PROGRESS</code>, then the predictive inbox placement test is currently running. Predictive inbox placement tests are usually complete within 24 hours of creating the test. If the status is <code>COMPLETE</code>, then the test is finished, and you can use the <code>GetDeliverabilityTestReport</code> to view the results of the test.</p>', ], ], 'DeliverabilityTestSubject' => [ 'base' => '<p>The subject line for an email that you submitted in a predictive inbox placement test.</p>', 'refs' => [ 'DeliverabilityTestReport$Subject' => '<p>The subject line for an email that you submitted in a predictive inbox placement test.</p>', ], ], 'DeliveryOptions' => [ 'base' => '<p>Used to associate a configuration set with a dedicated IP pool.</p>', 'refs' => [ 'CreateConfigurationSetRequest$DeliveryOptions' => '<p>An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.</p>', 'GetConfigurationSetResponse$DeliveryOptions' => '<p>An object that defines the dedicated IP pool that is used to send emails that you send using the configuration set.</p>', ], ], 'Destination' => [ 'base' => '<p>An object that describes the recipients for an email.</p>', 'refs' => [ 'BulkEmailEntry$Destination' => '<p>Represents the destination of the message, consisting of To:, CC:, and BCC: fields.</p> <note> <p>Amazon SES does not support the SMTPUTF8 extension, as described in <a href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the local part of a destination email address (the part of the email address that precedes the @ sign) may only contain <a href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII characters</a>. If the domain part of an address (the part after the @ sign) contains non-ASCII characters, they must be encoded using Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>.</p> </note>', 'SendEmailRequest$Destination' => '<p>An object that contains the recipients of the email message.</p>', ], ], 'DimensionName' => [ 'base' => '<p>The name of an Amazon CloudWatch dimension associated with an email sending metric. The name has to meet the following criteria:</p> <ul> <li> <p>It can only contain ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-).</p> </li> <li> <p>It can contain no more than 256 characters.</p> </li> </ul>', 'refs' => [ 'CloudWatchDimensionConfiguration$DimensionName' => '<p>The name of an Amazon CloudWatch dimension associated with an email sending metric. The name has to meet the following criteria:</p> <ul> <li> <p>It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-).</p> </li> <li> <p>It can contain no more than 256 characters.</p> </li> </ul>', ], ], 'DimensionValueSource' => [ 'base' => '<p>The location where the Amazon SES API v2 finds the value of a dimension to publish to Amazon CloudWatch. If you want to use the message tags that you specify using an <code>X-SES-MESSAGE-TAGS</code> header or a parameter to the <code>SendEmail</code> or <code>SendRawEmail</code> API, choose <code>messageTag</code>. If you want to use your own email headers, choose <code>emailHeader</code>. If you want to use link tags, choose <code>linkTags</code>.</p>', 'refs' => [ 'CloudWatchDimensionConfiguration$DimensionValueSource' => '<p>The location where the Amazon SES API v2 finds the value of a dimension to publish to Amazon CloudWatch. If you want to use the message tags that you specify using an <code>X-SES-MESSAGE-TAGS</code> header or a parameter to the <code>SendEmail</code> or <code>SendRawEmail</code> API, choose <code>messageTag</code>. If you want to use your own email headers, choose <code>emailHeader</code>. If you want to use link tags, choose <code>linkTags</code>.</p>', ], ], 'DkimAttributes' => [ 'base' => '<p>An object that contains information about the DKIM authentication status for an email identity.</p> <p>Amazon SES determines the authentication status by searching for specific records in the DNS configuration for the domain. If you used <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> to set up DKIM authentication, Amazon SES tries to find three unique CNAME records in the DNS configuration for your domain. If you provided a public key to perform DKIM authentication, Amazon SES tries to find a TXT record that uses the selector that you specified. The value of the TXT record must be a public key that\'s paired with the private key that you specified in the process of creating the identity</p>', 'refs' => [ 'CreateEmailIdentityResponse$DkimAttributes' => '<p>An object that contains information about the DKIM attributes for the identity.</p>', 'GetEmailIdentityResponse$DkimAttributes' => '<p>An object that contains information about the DKIM attributes for the identity.</p>', ], ], 'DkimSigningAttributes' => [ 'base' => '<p>An object that contains information about the tokens used for setting up Bring Your Own DKIM (BYODKIM).</p>', 'refs' => [ 'CreateEmailIdentityRequest$DkimSigningAttributes' => '<p>If your request includes this object, Amazon SES configures the identity to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, as opposed to the default method, <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p> <p>You can only specify this object if the email identity is a domain, as opposed to an address.</p>', 'PutEmailIdentityDkimSigningAttributesRequest$SigningAttributes' => '<p>An object that contains information about the private key and selector that you want to use to configure DKIM for the identity. This object is only required if you want to configure Bring Your Own DKIM (BYODKIM) for the identity.</p>', ], ], 'DkimSigningAttributesOrigin' => [ 'base' => NULL, 'refs' => [ 'DkimAttributes$SigningAttributesOrigin' => '<p>A string that indicates how DKIM was configured for the identity. There are two possible values:</p> <ul> <li> <p> <code>AWS_SES</code> – Indicates that DKIM was configured for the identity by using <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p> </li> <li> <p> <code>EXTERNAL</code> – Indicates that DKIM was configured for the identity by using Bring Your Own DKIM (BYODKIM).</p> </li> </ul>', 'PutEmailIdentityDkimSigningAttributesRequest$SigningAttributesOrigin' => '<p>The method that you want to use to configure DKIM for the identity. There are two possible values:</p> <ul> <li> <p> <code>AWS_SES</code> – Configure DKIM for the identity by using <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a>.</p> </li> <li> <p> <code>EXTERNAL</code> – Configure DKIM for the identity by using Bring Your Own DKIM (BYODKIM).</p> </li> </ul>', ], ], 'DkimStatus' => [ 'base' => '<p>The DKIM authentication status of the identity. The status can be one of the following:</p> <ul> <li> <p> <code>PENDING</code> – The verification process was initiated, but Amazon SES hasn\'t yet detected the DKIM records in the DNS configuration for the domain.</p> </li> <li> <p> <code>SUCCESS</code> – The verification process completed successfully.</p> </li> <li> <p> <code>FAILED</code> – The verification process failed. This typically occurs when Amazon SES fails to find the DKIM records in the DNS configuration of the domain.</p> </li> <li> <p> <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES from determining the DKIM authentication status of the domain.</p> </li> <li> <p> <code>NOT_STARTED</code> – The DKIM verification process hasn\'t been initiated for the domain.</p> </li> </ul>', 'refs' => [ 'DkimAttributes$Status' => '<p>Describes whether or not Amazon SES has successfully located the DKIM records in the DNS records for the domain. The status can be one of the following:</p> <ul> <li> <p> <code>PENDING</code> – The verification process was initiated, but Amazon SES hasn\'t yet detected the DKIM records in the DNS configuration for the domain.</p> </li> <li> <p> <code>SUCCESS</code> – The verification process completed successfully.</p> </li> <li> <p> <code>FAILED</code> – The verification process failed. This typically occurs when Amazon SES fails to find the DKIM records in the DNS configuration of the domain.</p> </li> <li> <p> <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES from determining the DKIM authentication status of the domain.</p> </li> <li> <p> <code>NOT_STARTED</code> – The DKIM verification process hasn\'t been initiated for the domain.</p> </li> </ul>', 'PutEmailIdentityDkimSigningAttributesResponse$DkimStatus' => '<p>The DKIM authentication status of the identity. Amazon SES determines the authentication status by searching for specific records in the DNS configuration for your domain. If you used <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> to set up DKIM authentication, Amazon SES tries to find three unique CNAME records in the DNS configuration for your domain.</p> <p>If you provided a public key to perform DKIM authentication, Amazon SES tries to find a TXT record that uses the selector that you specified. The value of the TXT record must be a public key that\'s paired with the private key that you specified in the process of creating the identity.</p> <p>The status can be one of the following:</p> <ul> <li> <p> <code>PENDING</code> – The verification process was initiated, but Amazon SES hasn\'t yet detected the DKIM records in the DNS configuration for the domain.</p> </li> <li> <p> <code>SUCCESS</code> – The verification process completed successfully.</p> </li> <li> <p> <code>FAILED</code> – The verification process failed. This typically occurs when Amazon SES fails to find the DKIM records in the DNS configuration of the domain.</p> </li> <li> <p> <code>TEMPORARY_FAILURE</code> – A temporary issue is preventing Amazon SES from determining the DKIM authentication status of the domain.</p> </li> <li> <p> <code>NOT_STARTED</code> – The DKIM verification process hasn\'t been initiated for the domain.</p> </li> </ul>', ], ], 'DnsToken' => [ 'base' => NULL, 'refs' => [ 'DnsTokenList$member' => NULL, ], ], 'DnsTokenList' => [ 'base' => NULL, 'refs' => [ 'DkimAttributes$Tokens' => '<p>If you used <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> to configure DKIM authentication for the domain, then this object contains a set of unique strings that you use to create a set of CNAME records that you add to the DNS configuration for your domain. When Amazon SES detects these records in the DNS configuration for your domain, the DKIM authentication process is complete.</p> <p>If you configured DKIM authentication for the domain by providing your own public-private key pair, then this object contains the selector for the public key.</p> <p>Regardless of the DKIM authentication method you use, Amazon SES searches for the appropriate records in the DNS configuration of the domain for up to 72 hours.</p>', 'PutEmailIdentityDkimSigningAttributesResponse$DkimTokens' => '<p>If you used <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html">Easy DKIM</a> to configure DKIM authentication for the domain, then this object contains a set of unique strings that you use to create a set of CNAME records that you add to the DNS configuration for your domain. When Amazon SES detects these records in the DNS configuration for your domain, the DKIM authentication process is complete.</p> <p>If you configured DKIM authentication for the domain by providing your own public-private key pair, then this object contains the selector that\'s associated with your public key.</p> <p>Regardless of the DKIM authentication method you use, Amazon SES searches for the appropriate records in the DNS configuration of the domain for up to 72 hours.</p>', ], ], 'Domain' => [ 'base' => NULL, 'refs' => [ 'DomainDeliverabilityTrackingOption$Domain' => '<p>A verified domain that’s associated with your AWS account and currently has an active Deliverability dashboard subscription.</p>', 'ListDomainDeliverabilityCampaignsRequest$SubscribedDomain' => '<p>The domain to obtain deliverability data for.</p>', ], ], 'DomainDeliverabilityCampaign' => [ 'base' => '<p>An object that contains the deliverability data for a specific campaign. This data is available for a campaign only if the campaign sent email by using a domain that the Deliverability dashboard is enabled for (<code>PutDeliverabilityDashboardOption</code> operation).</p>', 'refs' => [ 'DomainDeliverabilityCampaignList$member' => NULL, 'GetDomainDeliverabilityCampaignResponse$DomainDeliverabilityCampaign' => '<p>An object that contains the deliverability data for the campaign.</p>', ], ], 'DomainDeliverabilityCampaignList' => [ 'base' => '<p/>', 'refs' => [ 'ListDomainDeliverabilityCampaignsResponse$DomainDeliverabilityCampaigns' => '<p>An array of responses, one for each campaign that used the domain to send email during the specified time range.</p>', ], ], 'DomainDeliverabilityTrackingOption' => [ 'base' => '<p>An object that contains information about the Deliverability dashboard subscription for a verified domain that you use to send email and currently has an active Deliverability dashboard subscription. If a Deliverability dashboard subscription is active for a domain, you gain access to reputation, inbox placement, and other metrics for the domain.</p>', 'refs' => [ 'DomainDeliverabilityTrackingOptions$member' => NULL, ], ], 'DomainDeliverabilityTrackingOptions' => [ 'base' => '<p>An object that contains information about the Deliverability dashboard subscription for a verified domain that you use to send email and currently has an active Deliverability dashboard subscription. If a Deliverability dashboard subscription is active for a domain, you gain access to reputation, inbox placement, and other metrics for the domain.</p>', 'refs' => [ 'GetDeliverabilityDashboardOptionsResponse$ActiveSubscribedDomains' => '<p>An array of objects, one for each verified domain that you use to send email and currently has an active Deliverability dashboard subscription that isn’t scheduled to expire at the end of the current calendar month.</p>', 'GetDeliverabilityDashboardOptionsResponse$PendingExpirationSubscribedDomains' => '<p>An array of objects, one for each verified domain that you use to send email and currently has an active Deliverability dashboard subscription that\'s scheduled to expire at the end of the current calendar month.</p>', 'PutDeliverabilityDashboardOptionRequest$SubscribedDomains' => '<p>An array of objects, one for each verified domain that you use to send email and enabled the Deliverability dashboard for.</p>', ], ], 'DomainIspPlacement' => [ 'base' => '<p>An object that contains inbox placement data for email sent from one of your email domains to a specific email provider.</p>', 'refs' => [ 'DomainIspPlacements$member' => NULL, ], ], 'DomainIspPlacements' => [ 'base' => NULL, 'refs' => [ 'DailyVolume$DomainIspPlacements' => '<p>An object that contains inbox placement metrics for a specified day in the analysis period, broken out by the recipient\'s email provider.</p>', 'OverallVolume$DomainIspPlacements' => '<p>An object that contains inbox and junk mail placement metrics for individual email providers.</p>', ], ], 'EmailAddress' => [ 'base' => NULL, 'refs' => [ 'CreateCustomVerificationEmailTemplateRequest$FromEmailAddress' => '<p>The email address that the custom verification email is sent from.</p>', 'CreateDeliverabilityTestReportRequest$FromEmailAddress' => '<p>The email address that the predictive inbox placement test email was sent from.</p>', 'CustomVerificationEmailTemplateMetadata$FromEmailAddress' => '<p>The email address that the custom verification email is sent from.</p>', 'DeleteSuppressedDestinationRequest$EmailAddress' => '<p>The suppressed email destination to remove from the account suppression list.</p>', 'DeliverabilityTestReport$FromEmailAddress' => '<p>The sender address that you specified for the predictive inbox placement test.</p>', 'EmailAddressList$member' => NULL, 'GetCustomVerificationEmailTemplateResponse$FromEmailAddress' => '<p>The email address that the custom verification email is sent from.</p>', 'GetSuppressedDestinationRequest$EmailAddress' => '<p>The email address that\'s on the account suppression list.</p>', 'PutSuppressedDestinationRequest$EmailAddress' => '<p>The email address that should be added to the suppression list for your account.</p>', 'SendBulkEmailRequest$FromEmailAddress' => '<p>The email address that you want to use as the "From" address for the email. The address that you specify has to be verified.</p>', 'SendBulkEmailRequest$FeedbackForwardingEmailAddress' => '<p>The address that you want bounce and complaint notifications to be sent to.</p>', 'SendCustomVerificationEmailRequest$EmailAddress' => '<p>The email address to verify.</p>', 'SendEmailRequest$FromEmailAddress' => '<p>The email address that you want to use as the "From" address for the email. The address that you specify has to be verified. </p>', 'SendEmailRequest$FeedbackForwardingEmailAddress' => '<p>The address that you want bounce and complaint notifications to be sent to.</p>', 'SuppressedDestination$EmailAddress' => '<p>The email address that is on the suppression list for your account.</p>', 'SuppressedDestinationSummary$EmailAddress' => '<p>The email address that\'s on the suppression list for your account.</p>', 'UpdateCustomVerificationEmailTemplateRequest$FromEmailAddress' => '<p>The email address that the custom verification email is sent from.</p>', ], ], 'EmailAddressList' => [ 'base' => NULL, 'refs' => [ 'Destination$ToAddresses' => '<p>An array that contains the email addresses of the "To" recipients for the email.</p>', 'Destination$CcAddresses' => '<p>An array that contains the email addresses of the "CC" (carbon copy) recipients for the email.</p>', 'Destination$BccAddresses' => '<p>An array that contains the email addresses of the "BCC" (blind carbon copy) recipients for the email.</p>', 'SendBulkEmailRequest$ReplyToAddresses' => '<p>The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to address receives the reply.</p>', 'SendEmailRequest$ReplyToAddresses' => '<p>The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to address receives the reply.</p>', ], ], 'EmailContent' => [ 'base' => '<p>An object that defines the entire content of the email, including the message headers and the body content. You can create a simple email message, in which you specify the subject and the text and HTML versions of the message body. You can also create raw messages, in which you specify a complete MIME-formatted message. Raw messages can include attachments and custom headers.</p>', 'refs' => [ 'CreateDeliverabilityTestReportRequest$Content' => '<p>The HTML body of the message that you sent when you performed the predictive inbox placement test.</p>', 'SendEmailRequest$Content' => '<p>An object that contains the body of the message. You can send either a Simple message Raw message or a template Message.</p>', ], ], 'EmailTemplateContent' => [ 'base' => '<p>The content of the email, composed of a subject line, an HTML part, and a text-only part.</p>', 'refs' => [ 'CreateEmailTemplateRequest$TemplateContent' => '<p>The content of the email template, composed of a subject line, an HTML part, and a text-only part.</p>', 'GetEmailTemplateResponse$TemplateContent' => '<p>The content of the email template, composed of a subject line, an HTML part, and a text-only part.</p>', 'UpdateEmailTemplateRequest$TemplateContent' => '<p>The content of the email template, composed of a subject line, an HTML part, and a text-only part.</p>', ], ], 'EmailTemplateData' => [ 'base' => '<p>An object that defines the values to use for message variables in the template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the value to use for that variable.</p>', 'refs' => [ 'ReplacementTemplate$ReplacementTemplateData' => '<p>A list of replacement values to apply to the template. This parameter is a JSON object, typically consisting of key-value pairs in which the keys correspond to replacement tags in the email template.</p>', 'Template$TemplateData' => '<p>An object that defines the values to use for message variables in the template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the value to use for that variable.</p>', 'TestRenderEmailTemplateRequest$TemplateData' => '<p>A list of replacement values to apply to the template. This parameter is a JSON object, typically consisting of key-value pairs in which the keys correspond to replacement tags in the email template.</p>', ], ], 'EmailTemplateHtml' => [ 'base' => '<p>The HTML body of the email.</p>', 'refs' => [ 'EmailTemplateContent$Html' => '<p>The HTML body of the email.</p>', ], ], 'EmailTemplateMetadata' => [ 'base' => '<p>Contains information about an email template.</p>', 'refs' => [ 'EmailTemplateMetadataList$member' => NULL, ], ], 'EmailTemplateMetadataList' => [ 'base' => '<p>A list of the EmailTemplateMetadata object.</p>', 'refs' => [ 'ListEmailTemplatesResponse$TemplatesMetadata' => '<p>An array the contains the name and creation time stamp for each template in your Amazon SES account.</p>', ], ], 'EmailTemplateName' => [ 'base' => '<p>The name of the template. You will refer to this name when you send email using the <code>SendTemplatedEmail</code> or <code>SendBulkTemplatedEmail</code> operations.</p>', 'refs' => [ 'CreateCustomVerificationEmailTemplateRequest$TemplateName' => '<p>The name of the custom verification email template.</p>', 'CreateEmailTemplateRequest$TemplateName' => '<p>The name of the template you want to create.</p>', 'CustomVerificationEmailTemplateMetadata$TemplateName' => '<p>The name of the custom verification email template.</p>', 'DeleteCustomVerificationEmailTemplateRequest$TemplateName' => '<p>The name of the custom verification email template that you want to delete.</p>', 'DeleteEmailTemplateRequest$TemplateName' => '<p>The name of the template to be deleted.</p>', 'EmailTemplateMetadata$TemplateName' => '<p>The name of the template.</p>', 'GetCustomVerificationEmailTemplateRequest$TemplateName' => '<p>The name of the custom verification email template that you want to retrieve.</p>', 'GetCustomVerificationEmailTemplateResponse$TemplateName' => '<p>The name of the custom verification email template.</p>', 'GetEmailTemplateRequest$TemplateName' => '<p>The name of the template you want to retrieve.</p>', 'GetEmailTemplateResponse$TemplateName' => '<p>The name of the template you want to retrieve.</p>', 'SendCustomVerificationEmailRequest$TemplateName' => '<p>The name of the custom verification email template to use when sending the verification email.</p>', 'Template$TemplateName' => '<p>The name of the template. You will refer to this name when you send email using the <code>SendTemplatedEmail</code> or <code>SendBulkTemplatedEmail</code> operations. </p>', 'TestRenderEmailTemplateRequest$TemplateName' => '<p>The name of the template that you want to render.</p>', 'UpdateCustomVerificationEmailTemplateRequest$TemplateName' => '<p>The name of the custom verification email template that you want to update.</p>', 'UpdateEmailTemplateRequest$TemplateName' => '<p>The name of the template you want to update.</p>', ], ], 'EmailTemplateSubject' => [ 'base' => '<p>The subject line of the email.</p>', 'refs' => [ 'CreateCustomVerificationEmailTemplateRequest$TemplateSubject' => '<p>The subject line of the custom verification email.</p>', 'CustomVerificationEmailTemplateMetadata$TemplateSubject' => '<p>The subject line of the custom verification email.</p>', 'EmailTemplateContent$Subject' => '<p>The subject line of the email.</p>', 'GetCustomVerificationEmailTemplateResponse$TemplateSubject' => '<p>The subject line of the custom verification email.</p>', 'UpdateCustomVerificationEmailTemplateRequest$TemplateSubject' => '<p>The subject line of the custom verification email.</p>', ], ], 'EmailTemplateText' => [ 'base' => '<p>The email body that will be visible to recipients whose email clients do not display HTML.</p>', 'refs' => [ 'EmailTemplateContent$Text' => '<p>The email body that will be visible to recipients whose email clients do not display HTML.</p>', ], ], 'Enabled' => [ 'base' => NULL, 'refs' => [ 'CreateEmailIdentityResponse$VerifiedForSendingStatus' => '<p>Specifies whether or not the identity is verified. You can only send email from verified email addresses or domains. For more information about verifying identities, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-email-manage-verify.html">Amazon Pinpoint User Guide</a>.</p>', 'DkimAttributes$SigningEnabled' => '<p>If the value is <code>true</code>, then the messages that you send from the identity are signed using DKIM. If the value is <code>false</code>, then the messages that you send from the identity aren\'t DKIM-signed.</p>', 'EventDestination$Enabled' => '<p>If <code>true</code>, the event destination is enabled. When the event destination is enabled, the specified event types are sent to the destinations in this <code>EventDestinationDefinition</code>.</p> <p>If <code>false</code>, the event destination is disabled. When the event destination is disabled, events aren\'t sent to the specified destinations.</p>', 'EventDestinationDefinition$Enabled' => '<p>If <code>true</code>, the event destination is enabled. When the event destination is enabled, the specified event types are sent to the destinations in this <code>EventDestinationDefinition</code>.</p> <p>If <code>false</code>, the event destination is disabled. When the event destination is disabled, events aren\'t sent to the specified destinations.</p>', 'GetAccountResponse$DedicatedIpAutoWarmupEnabled' => '<p>Indicates whether or not the automatic warm-up feature is enabled for dedicated IP addresses that are associated with your account.</p>', 'GetAccountResponse$ProductionAccessEnabled' => '<p>Indicates whether or not your account has production access in the current AWS Region.</p> <p>If the value is <code>false</code>, then your account is in the <i>sandbox</i>. When your account is in the sandbox, you can only send email to verified identities. Additionally, the maximum number of emails you can send in a 24-hour period (your sending quota) is 200, and the maximum number of emails you can send per second (your maximum sending rate) is 1.</p> <p>If the value is <code>true</code>, then your account has production access. When your account has production access, you can send email to any address. The sending quota and maximum sending rate for your account vary based on your specific use case.</p>', 'GetAccountResponse$SendingEnabled' => '<p>Indicates whether or not email sending is enabled for your Amazon SES account in the current AWS Region.</p>', 'GetDeliverabilityDashboardOptionsResponse$DashboardEnabled' => '<p>Specifies whether the Deliverability dashboard is enabled. If this value is <code>true</code>, the dashboard is enabled.</p>', 'GetEmailIdentityResponse$FeedbackForwardingStatus' => '<p>The feedback forwarding configuration for the identity.</p> <p>If the value is <code>true</code>, you receive email notifications when bounce or complaint events occur. These notifications are sent to the address that you specified in the <code>Return-Path</code> header of the original email.</p> <p>You\'re required to have a method of tracking bounces and complaints. If you haven\'t set up another mechanism for receiving bounce or complaint notifications (for example, by setting up an event destination), you receive an email notification when these events occur (even if this setting is disabled).</p>', 'GetEmailIdentityResponse$VerifiedForSendingStatus' => '<p>Specifies whether or not the identity is verified. You can only send email from verified email addresses or domains. For more information about verifying identities, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-email-manage-verify.html">Amazon Pinpoint User Guide</a>.</p>', 'IdentityInfo$SendingEnabled' => '<p>Indicates whether or not you can send email from the identity.</p> <p>An <i>identity</i> is an email address or domain that you send email from. Before you can send email from an identity, you have to demostrate that you own the identity, and that you authorize Amazon SES to send email from that identity.</p>', 'InboxPlacementTrackingOption$Global' => '<p>Specifies whether inbox placement data is being tracked for the domain.</p>', 'PutAccountDedicatedIpWarmupAttributesRequest$AutoWarmupEnabled' => '<p>Enables or disables the automatic warm-up feature for dedicated IP addresses that are associated with your Amazon SES account in the current AWS Region. Set to <code>true</code> to enable the automatic warm-up feature, or set to <code>false</code> to disable it.</p>', 'PutAccountSendingAttributesRequest$SendingEnabled' => '<p>Enables or disables your account\'s ability to send email. Set to <code>true</code> to enable email sending, or set to <code>false</code> to disable email sending.</p> <note> <p>If AWS paused your account\'s ability to send email, you can\'t use this operation to resume your account\'s ability to send email.</p> </note>', 'PutConfigurationSetReputationOptionsRequest$ReputationMetricsEnabled' => '<p>If <code>true</code>, tracking of reputation metrics is enabled for the configuration set. If <code>false</code>, tracking of reputation metrics is disabled for the configuration set.</p>', 'PutConfigurationSetSendingOptionsRequest$SendingEnabled' => '<p>If <code>true</code>, email sending is enabled for the configuration set. If <code>false</code>, email sending is disabled for the configuration set.</p>', 'PutDeliverabilityDashboardOptionRequest$DashboardEnabled' => '<p>Specifies whether to enable the Deliverability dashboard. To enable the dashboard, set this value to <code>true</code>.</p>', 'PutEmailIdentityDkimAttributesRequest$SigningEnabled' => '<p>Sets the DKIM signing configuration for the identity.</p> <p>When you set this value <code>true</code>, then the messages that are sent from the identity are signed using DKIM. If you set this value to <code>false</code>, your messages are sent without DKIM signing.</p>', 'PutEmailIdentityFeedbackAttributesRequest$EmailForwardingEnabled' => '<p>Sets the feedback forwarding configuration for the identity.</p> <p>If the value is <code>true</code>, you receive email notifications when bounce or complaint events occur. These notifications are sent to the address that you specified in the <code>Return-Path</code> header of the original email.</p> <p>You\'re required to have a method of tracking bounces and complaints. If you haven\'t set up another mechanism for receiving bounce or complaint notifications (for example, by setting up an event destination), you receive an email notification when these events occur (even if this setting is disabled).</p>', 'ReputationOptions$ReputationMetricsEnabled' => '<p>If <code>true</code>, tracking of reputation metrics is enabled for the configuration set. If <code>false</code>, tracking of reputation metrics is disabled for the configuration set.</p>', 'SendingOptions$SendingEnabled' => '<p>If <code>true</code>, email sending is enabled for the configuration set. If <code>false</code>, email sending is disabled for the configuration set.</p>', ], ], 'EnabledWrapper' => [ 'base' => NULL, 'refs' => [ 'PutAccountDetailsRequest$ProductionAccessEnabled' => '<p>Indicates whether or not your account should have production access in the current AWS Region.</p> <p>If the value is <code>false</code>, then your account is in the <i>sandbox</i>. When your account is in the sandbox, you can only send email to verified identities. Additionally, the maximum number of emails you can send in a 24-hour period (your sending quota) is 200, and the maximum number of emails you can send per second (your maximum sending rate) is 1.</p> <p>If the value is <code>true</code>, then your account has production access. When your account has production access, you can send email to any address. The sending quota and maximum sending rate for your account vary based on your specific use case.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'BulkEmailEntryResult$Error' => '<p>A description of an error that prevented a message being sent using the <code>SendBulkTemplatedEmail</code> operation.</p>', ], ], 'Esp' => [ 'base' => NULL, 'refs' => [ 'Esps$member' => NULL, ], ], 'Esps' => [ 'base' => NULL, 'refs' => [ 'DomainDeliverabilityCampaign$Esps' => '<p>The major email providers who handled the email message.</p>', ], ], 'EventDestination' => [ 'base' => '<p>In the Amazon SES API v2, <i>events</i> include message sends, deliveries, opens, clicks, bounces, complaints and delivery delays. <i>Event destinations</i> are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.</p>', 'refs' => [ 'EventDestinations$member' => NULL, ], ], 'EventDestinationDefinition' => [ 'base' => '<p>An object that defines the event destination. Specifically, it defines which services receive events from emails sent using the configuration set that the event destination is associated with. Also defines the types of events that are sent to the event destination.</p>', 'refs' => [ 'CreateConfigurationSetEventDestinationRequest$EventDestination' => '<p>An object that defines the event destination.</p>', 'UpdateConfigurationSetEventDestinationRequest$EventDestination' => '<p>An object that defines the event destination.</p>', ], ], 'EventDestinationName' => [ 'base' => '<p>The name of an event destination.</p> <p> <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event destinations</i> are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.</p>', 'refs' => [ 'CreateConfigurationSetEventDestinationRequest$EventDestinationName' => '<p>A name that identifies the event destination within the configuration set.</p>', 'DeleteConfigurationSetEventDestinationRequest$EventDestinationName' => '<p>The name of the event destination that you want to delete.</p>', 'EventDestination$Name' => '<p>A name that identifies the event destination.</p>', 'UpdateConfigurationSetEventDestinationRequest$EventDestinationName' => '<p>The name of the event destination that you want to modify.</p>', ], ], 'EventDestinations' => [ 'base' => NULL, 'refs' => [ 'GetConfigurationSetEventDestinationsResponse$EventDestinations' => '<p>An array that includes all of the events destinations that have been configured for the configuration set.</p>', ], ], 'EventType' => [ 'base' => '<p>An email sending event type. For example, email sends, opens, and bounces are all email events.</p>', 'refs' => [ 'EventTypes$member' => NULL, ], ], 'EventTypes' => [ 'base' => NULL, 'refs' => [ 'EventDestination$MatchingEventTypes' => '<p>The types of events that Amazon SES sends to the specified event destinations.</p>', 'EventDestinationDefinition$MatchingEventTypes' => '<p>An array that specifies which events the Amazon SES API v2 should send to the destinations in this <code>EventDestinationDefinition</code>.</p>', ], ], 'FailureRedirectionURL' => [ 'base' => '<p>The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.</p>', 'refs' => [ 'CreateCustomVerificationEmailTemplateRequest$FailureRedirectionURL' => '<p>The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.</p>', 'CustomVerificationEmailTemplateMetadata$FailureRedirectionURL' => '<p>The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.</p>', 'GetCustomVerificationEmailTemplateResponse$FailureRedirectionURL' => '<p>The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.</p>', 'UpdateCustomVerificationEmailTemplateRequest$FailureRedirectionURL' => '<p>The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.</p>', ], ], 'FeedbackId' => [ 'base' => NULL, 'refs' => [ 'SuppressedDestinationAttributes$FeedbackId' => '<p>A unique identifier that\'s generated when an email address is added to the suppression list for your account.</p>', ], ], 'GeneralEnforcementStatus' => [ 'base' => NULL, 'refs' => [ 'GetAccountResponse$EnforcementStatus' => '<p>The reputation status of your Amazon SES account. The status can be one of the following:</p> <ul> <li> <p> <code>HEALTHY</code> – There are no reputation-related issues that currently impact your account.</p> </li> <li> <p> <code>PROBATION</code> – We\'ve identified potential issues with your Amazon SES account. We\'re placing your account under review while you work on correcting these issues.</p> </li> <li> <p> <code>SHUTDOWN</code> – Your account\'s ability to send email is currently paused because of an issue with the email sent from your account. When you correct the issue, you can contact us and request that your account\'s ability to send email is resumed.</p> </li> </ul>', ], ], 'GetAccountRequest' => [ 'base' => '<p>A request to obtain information about the email-sending capabilities of your Amazon SES account.</p>', 'refs' => [], ], 'GetAccountResponse' => [ 'base' => '<p>A list of details about the email-sending capabilities of your Amazon SES account in the current AWS Region.</p>', 'refs' => [], ], 'GetBlacklistReportsRequest' => [ 'base' => '<p>A request to retrieve a list of the blacklists that your dedicated IP addresses appear on.</p>', 'refs' => [], ], 'GetBlacklistReportsResponse' => [ 'base' => '<p>An object that contains information about blacklist events.</p>', 'refs' => [], ], 'GetConfigurationSetEventDestinationsRequest' => [ 'base' => '<p>A request to obtain information about the event destinations for a configuration set.</p>', 'refs' => [], ], 'GetConfigurationSetEventDestinationsResponse' => [ 'base' => '<p>Information about an event destination for a configuration set.</p>', 'refs' => [], ], 'GetConfigurationSetRequest' => [ 'base' => '<p>A request to obtain information about a configuration set.</p>', 'refs' => [], ], 'GetConfigurationSetResponse' => [ 'base' => '<p>Information about a configuration set.</p>', 'refs' => [], ], 'GetCustomVerificationEmailTemplateRequest' => [ 'base' => '<p>Represents a request to retrieve an existing custom verification email template.</p>', 'refs' => [], ], 'GetCustomVerificationEmailTemplateResponse' => [ 'base' => '<p>The following elements are returned by the service.</p>', 'refs' => [], ], 'GetDedicatedIpRequest' => [ 'base' => '<p>A request to obtain more information about a dedicated IP address.</p>', 'refs' => [], ], 'GetDedicatedIpResponse' => [ 'base' => '<p>Information about a dedicated IP address.</p>', 'refs' => [], ], 'GetDedicatedIpsRequest' => [ 'base' => '<p>A request to obtain more information about dedicated IP pools.</p>', 'refs' => [], ], 'GetDedicatedIpsResponse' => [ 'base' => '<p>Information about the dedicated IP addresses that are associated with your AWS account.</p>', 'refs' => [], ], 'GetDeliverabilityDashboardOptionsRequest' => [ 'base' => '<p>Retrieve information about the status of the Deliverability dashboard for your AWS account. When the Deliverability dashboard is enabled, you gain access to reputation, deliverability, and other metrics for your domains. You also gain the ability to perform predictive inbox placement tests.</p> <p>When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees that you accrue by using Amazon SES and other AWS services. For more information about the features and cost of a Deliverability dashboard subscription, see <a href="http://aws.amazon.com/pinpoint/pricing/">Amazon Pinpoint Pricing</a>.</p>', 'refs' => [], ], 'GetDeliverabilityDashboardOptionsResponse' => [ 'base' => '<p>An object that shows the status of the Deliverability dashboard.</p>', 'refs' => [], ], 'GetDeliverabilityTestReportRequest' => [ 'base' => '<p>A request to retrieve the results of a predictive inbox placement test.</p>', 'refs' => [], ], 'GetDeliverabilityTestReportResponse' => [ 'base' => '<p>The results of the predictive inbox placement test.</p>', 'refs' => [], ], 'GetDomainDeliverabilityCampaignRequest' => [ 'base' => '<p>Retrieve all the deliverability data for a specific campaign. This data is available for a campaign only if the campaign sent email by using a domain that the Deliverability dashboard is enabled for (<code>PutDeliverabilityDashboardOption</code> operation).</p>', 'refs' => [], ], 'GetDomainDeliverabilityCampaignResponse' => [ 'base' => '<p>An object that contains all the deliverability data for a specific campaign. This data is available for a campaign only if the campaign sent email by using a domain that the Deliverability dashboard is enabled for.</p>', 'refs' => [], ], 'GetDomainStatisticsReportRequest' => [ 'base' => '<p>A request to obtain deliverability metrics for a domain.</p>', 'refs' => [], ], 'GetDomainStatisticsReportResponse' => [ 'base' => '<p>An object that includes statistics that are related to the domain that you specified.</p>', 'refs' => [], ], 'GetEmailIdentityPoliciesRequest' => [ 'base' => '<p>A request to return the policies of an email identity.</p>', 'refs' => [], ], 'GetEmailIdentityPoliciesResponse' => [ 'base' => '<p>Identity policies associated with email identity.</p>', 'refs' => [], ], 'GetEmailIdentityRequest' => [ 'base' => '<p>A request to return details about an email identity.</p>', 'refs' => [], ], 'GetEmailIdentityResponse' => [ 'base' => '<p>Details about an email identity.</p>', 'refs' => [], ], 'GetEmailTemplateRequest' => [ 'base' => '<p>Represents a request to display the template object (which includes the subject line, HTML part and text part) for the template you specify.</p>', 'refs' => [], ], 'GetEmailTemplateResponse' => [ 'base' => '<p>The following element is returned by the service.</p>', 'refs' => [], ], 'GetSuppressedDestinationRequest' => [ 'base' => '<p>A request to retrieve information about an email address that\'s on the suppression list for your account.</p>', 'refs' => [], ], 'GetSuppressedDestinationResponse' => [ 'base' => '<p>Information about the suppressed email address.</p>', 'refs' => [], ], 'Identity' => [ 'base' => NULL, 'refs' => [ 'CreateEmailIdentityPolicyRequest$EmailIdentity' => '<p>The email identity for which you want to create a policy.</p>', 'CreateEmailIdentityRequest$EmailIdentity' => '<p>The email address or domain that you want to verify.</p>', 'DeleteEmailIdentityPolicyRequest$EmailIdentity' => '<p>The email identity for which you want to delete a policy.</p>', 'DeleteEmailIdentityRequest$EmailIdentity' => '<p>The identity (that is, the email address or domain) that you want to delete.</p>', 'DomainDeliverabilityCampaign$FromAddress' => '<p>The verified email address that the email message was sent from.</p>', 'GetDomainStatisticsReportRequest$Domain' => '<p>The domain that you want to obtain deliverability metrics for.</p>', 'GetEmailIdentityPoliciesRequest$EmailIdentity' => '<p>The email identity that you want to retrieve policies for.</p>', 'GetEmailIdentityRequest$EmailIdentity' => '<p>The email identity that you want to retrieve details for.</p>', 'IdentityInfo$IdentityName' => '<p>The address or domain of the identity.</p>', 'PutEmailIdentityDkimAttributesRequest$EmailIdentity' => '<p>The email identity that you want to change the DKIM settings for.</p>', 'PutEmailIdentityDkimSigningAttributesRequest$EmailIdentity' => '<p>The email identity that you want to configure DKIM for.</p>', 'PutEmailIdentityFeedbackAttributesRequest$EmailIdentity' => '<p>The email identity that you want to configure bounce and complaint feedback forwarding for.</p>', 'PutEmailIdentityMailFromAttributesRequest$EmailIdentity' => '<p>The verified email identity that you want to set up the custom MAIL FROM domain for.</p>', 'UpdateEmailIdentityPolicyRequest$EmailIdentity' => '<p>The email identity for which you want to update policy.</p>', ], ], 'IdentityInfo' => [ 'base' => '<p>Information about an email identity.</p>', 'refs' => [ 'IdentityInfoList$member' => NULL, ], ], 'IdentityInfoList' => [ 'base' => NULL, 'refs' => [ 'ListEmailIdentitiesResponse$EmailIdentities' => '<p>An array that includes all of the email identities associated with your AWS account.</p>', ], ], 'IdentityType' => [ 'base' => '<p>The email identity type. The identity type can be one of the following:</p> <ul> <li> <p> <code>EMAIL_ADDRESS</code> – The identity is an email address.</p> </li> <li> <p> <code>DOMAIN</code> – The identity is a domain.</p> </li> </ul>', 'refs' => [ 'CreateEmailIdentityResponse$IdentityType' => '<p>The email identity type.</p>', 'GetEmailIdentityResponse$IdentityType' => '<p>The email identity type.</p>', 'IdentityInfo$IdentityType' => '<p>The email identity type. The identity type can be one of the following:</p> <ul> <li> <p> <code>EMAIL_ADDRESS</code> – The identity is an email address.</p> </li> <li> <p> <code>DOMAIN</code> – The identity is a domain.</p> </li> <li> <p> <code>MANAGED_DOMAIN</code> – The identity is a domain that is managed by AWS.</p> </li> </ul>', ], ], 'ImageUrl' => [ 'base' => NULL, 'refs' => [ 'DomainDeliverabilityCampaign$ImageUrl' => '<p>The URL of an image that contains a snapshot of the email message that was sent.</p>', ], ], 'InboxPlacementTrackingOption' => [ 'base' => '<p>An object that contains information about the inbox placement data settings for a verified domain that’s associated with your AWS account. This data is available only if you enabled the Deliverability dashboard for the domain.</p>', 'refs' => [ 'DomainDeliverabilityTrackingOption$InboxPlacementTrackingOption' => '<p>An object that contains information about the inbox placement data settings for the domain.</p>', ], ], 'InvalidNextTokenException' => [ 'base' => '<p>The specified request includes an invalid or expired token.</p>', 'refs' => [], ], 'Ip' => [ 'base' => '<p>An IPv4 address.</p>', 'refs' => [ 'DedicatedIp$Ip' => '<p>An IPv4 address.</p>', 'GetDedicatedIpRequest$Ip' => '<p>The IP address that you want to obtain more information about. The value you specify has to be a dedicated IP address that\'s assocaited with your AWS account.</p>', 'IpList$member' => NULL, 'PutDedicatedIpInPoolRequest$Ip' => '<p>The IP address that you want to move to the dedicated IP pool. The value you specify has to be a dedicated IP address that\'s associated with your AWS account.</p>', 'PutDedicatedIpWarmupAttributesRequest$Ip' => '<p>The dedicated IP address that you want to update the warm-up attributes for.</p>', ], ], 'IpList' => [ 'base' => NULL, 'refs' => [ 'DomainDeliverabilityCampaign$SendingIps' => '<p>The IP addresses that were used to send the email message.</p>', ], ], 'IspName' => [ 'base' => '<p>The name of an email provider.</p>', 'refs' => [ 'DomainIspPlacement$IspName' => '<p>The name of the email provider that the inbox placement data applies to.</p>', 'IspNameList$member' => NULL, 'IspPlacement$IspName' => '<p>The name of the email provider that the inbox placement data applies to.</p>', ], ], 'IspNameList' => [ 'base' => NULL, 'refs' => [ 'InboxPlacementTrackingOption$TrackedIsps' => '<p>An array of strings, one for each major email provider that the inbox placement data applies to.</p>', ], ], 'IspPlacement' => [ 'base' => '<p>An object that describes how email sent during the predictive inbox placement test was handled by a certain email provider.</p>', 'refs' => [ 'IspPlacements$member' => NULL, ], ], 'IspPlacements' => [ 'base' => NULL, 'refs' => [ 'GetDeliverabilityTestReportResponse$IspPlacements' => '<p>An object that describes how the test email was handled by several email providers, including Gmail, Hotmail, Yahoo, AOL, and others.</p>', ], ], 'KinesisFirehoseDestination' => [ 'base' => '<p>An object that defines an Amazon Kinesis Data Firehose destination for email events. You can use Amazon Kinesis Data Firehose to stream data to other services, such as Amazon S3 and Amazon Redshift.</p>', 'refs' => [ 'EventDestination$KinesisFirehoseDestination' => '<p>An object that defines an Amazon Kinesis Data Firehose destination for email events. You can use Amazon Kinesis Data Firehose to stream data to other services, such as Amazon S3 and Amazon Redshift.</p>', 'EventDestinationDefinition$KinesisFirehoseDestination' => '<p>An object that defines an Amazon Kinesis Data Firehose destination for email events. You can use Amazon Kinesis Data Firehose to stream data to other services, such as Amazon S3 and Amazon Redshift.</p>', ], ], 'LastFreshStart' => [ 'base' => '<p>The date and time (in Unix time) when the reputation metrics were last given a fresh start. When your account is given a fresh start, your reputation metrics are calculated starting from the date of the fresh start.</p>', 'refs' => [ 'ReputationOptions$LastFreshStart' => '<p>The date and time (in Unix time) when the reputation metrics were last given a fresh start. When your account is given a fresh start, your reputation metrics are calculated starting from the date of the fresh start.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>There are too many instances of the specified resource type.</p>', 'refs' => [], ], 'ListConfigurationSetsRequest' => [ 'base' => '<p>A request to obtain a list of configuration sets for your Amazon SES account in the current AWS Region.</p>', 'refs' => [], ], 'ListConfigurationSetsResponse' => [ 'base' => '<p>A list of configuration sets in your Amazon SES account in the current AWS Region.</p>', 'refs' => [], ], 'ListCustomVerificationEmailTemplatesRequest' => [ 'base' => '<p>Represents a request to list the existing custom verification email templates for your account.</p>', 'refs' => [], ], 'ListCustomVerificationEmailTemplatesResponse' => [ 'base' => '<p>The following elements are returned by the service.</p>', 'refs' => [], ], 'ListDedicatedIpPoolsRequest' => [ 'base' => '<p>A request to obtain a list of dedicated IP pools.</p>', 'refs' => [], ], 'ListDedicatedIpPoolsResponse' => [ 'base' => '<p>A list of dedicated IP pools.</p>', 'refs' => [], ], 'ListDeliverabilityTestReportsRequest' => [ 'base' => '<p>A request to list all of the predictive inbox placement tests that you\'ve performed.</p>', 'refs' => [], ], 'ListDeliverabilityTestReportsResponse' => [ 'base' => '<p>A list of the predictive inbox placement test reports that are available for your account, regardless of whether or not those tests are complete.</p>', 'refs' => [], ], 'ListDomainDeliverabilityCampaignsRequest' => [ 'base' => '<p>Retrieve deliverability data for all the campaigns that used a specific domain to send email during a specified time range. This data is available for a domain only if you enabled the Deliverability dashboard.</p>', 'refs' => [], ], 'ListDomainDeliverabilityCampaignsResponse' => [ 'base' => '<p>An array of objects that provide deliverability data for all the campaigns that used a specific domain to send email during a specified time range. This data is available for a domain only if you enabled the Deliverability dashboard for the domain.</p>', 'refs' => [], ], 'ListEmailIdentitiesRequest' => [ 'base' => '<p>A request to list all of the email identities associated with your AWS account. This list includes identities that you\'ve already verified, identities that are unverified, and identities that were verified in the past, but are no longer verified.</p>', 'refs' => [], ], 'ListEmailIdentitiesResponse' => [ 'base' => '<p>A list of all of the identities that you\'ve attempted to verify, regardless of whether or not those identities were successfully verified.</p>', 'refs' => [], ], 'ListEmailTemplatesRequest' => [ 'base' => '<p>Represents a request to list the email templates present in your Amazon SES account in the current AWS Region. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'ListEmailTemplatesResponse' => [ 'base' => '<p>The following elements are returned by the service.</p>', 'refs' => [], ], 'ListOfDedicatedIpPools' => [ 'base' => '<p>A list of dedicated IP pools that are associated with your AWS account.</p>', 'refs' => [ 'ListDedicatedIpPoolsResponse$DedicatedIpPools' => '<p>A list of all of the dedicated IP pools that are associated with your AWS account in the current Region.</p>', ], ], 'ListSuppressedDestinationsRequest' => [ 'base' => '<p>A request to obtain a list of email destinations that are on the suppression list for your account.</p>', 'refs' => [], ], 'ListSuppressedDestinationsResponse' => [ 'base' => '<p>A list of suppressed email addresses.</p>', 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MailFromAttributes' => [ 'base' => '<p>A list of attributes that are associated with a MAIL FROM domain.</p>', 'refs' => [ 'GetEmailIdentityResponse$MailFromAttributes' => '<p>An object that contains information about the Mail-From attributes for the email identity.</p>', ], ], 'MailFromDomainName' => [ 'base' => '<p>The domain that you want to use as a MAIL FROM domain.</p>', 'refs' => [ 'MailFromAttributes$MailFromDomain' => '<p>The name of a domain that an email identity uses as a custom MAIL FROM domain.</p>', 'PutEmailIdentityMailFromAttributesRequest$MailFromDomain' => '<p> The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must meet the following criteria:</p> <ul> <li> <p>It has to be a subdomain of the verified identity.</p> </li> <li> <p>It can\'t be used to receive email.</p> </li> <li> <p>It can\'t be used in a "From" address if the MAIL FROM domain is a destination for feedback forwarding emails.</p> </li> </ul>', ], ], 'MailFromDomainNotVerifiedException' => [ 'base' => '<p>The message can\'t be sent because the sending domain isn\'t verified.</p>', 'refs' => [], ], 'MailFromDomainStatus' => [ 'base' => '<p>The status of the MAIL FROM domain. This status can have the following values:</p> <ul> <li> <p> <code>PENDING</code> – Amazon SES hasn\'t started searching for the MX record yet.</p> </li> <li> <p> <code>SUCCESS</code> – Amazon SES detected the required MX record for the MAIL FROM domain.</p> </li> <li> <p> <code>FAILED</code> – Amazon SES can\'t find the required MX record, or the record no longer exists.</p> </li> <li> <p> <code>TEMPORARY_FAILURE</code> – A temporary issue occurred, which prevented Amazon SES from determining the status of the MAIL FROM domain.</p> </li> </ul>', 'refs' => [ 'MailFromAttributes$MailFromDomainStatus' => '<p>The status of the MAIL FROM domain. This status can have the following values:</p> <ul> <li> <p> <code>PENDING</code> – Amazon SES hasn\'t started searching for the MX record yet.</p> </li> <li> <p> <code>SUCCESS</code> – Amazon SES detected the required MX record for the MAIL FROM domain.</p> </li> <li> <p> <code>FAILED</code> – Amazon SES can\'t find the required MX record, or the record no longer exists.</p> </li> <li> <p> <code>TEMPORARY_FAILURE</code> – A temporary issue occurred, which prevented Amazon SES from determining the status of the MAIL FROM domain.</p> </li> </ul>', ], ], 'MailType' => [ 'base' => NULL, 'refs' => [ 'AccountDetails$MailType' => '<p>The type of email your account is sending. The mail type can be one of the following:</p> <ul> <li> <p> <code>MARKETING</code> – Most of your sending traffic is to keep your customers informed of your latest offering.</p> </li> <li> <p> <code>TRANSACTIONAL</code> – Most of your sending traffic is to communicate during a transaction with a customer.</p> </li> </ul>', 'PutAccountDetailsRequest$MailType' => '<p>The type of email your account will send.</p>', ], ], 'Max24HourSend' => [ 'base' => NULL, 'refs' => [ 'SendQuota$Max24HourSend' => '<p>The maximum number of emails that you can send in the current AWS Region over a 24-hour period. This value is also called your <i>sending quota</i>.</p>', ], ], 'MaxItems' => [ 'base' => NULL, 'refs' => [ 'GetDedicatedIpsRequest$PageSize' => '<p>The number of results to show in a single call to <code>GetDedicatedIpsRequest</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>', 'ListConfigurationSetsRequest$PageSize' => '<p>The number of results to show in a single call to <code>ListConfigurationSets</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>', 'ListCustomVerificationEmailTemplatesRequest$PageSize' => '<p>The number of results to show in a single call to <code>ListCustomVerificationEmailTemplates</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p> <p>The value you specify has to be at least 1, and can be no more than 50.</p>', 'ListDedicatedIpPoolsRequest$PageSize' => '<p>The number of results to show in a single call to <code>ListDedicatedIpPools</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>', 'ListDeliverabilityTestReportsRequest$PageSize' => '<p>The number of results to show in a single call to <code>ListDeliverabilityTestReports</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p> <p>The value you specify has to be at least 0, and can be no more than 1000.</p>', 'ListDomainDeliverabilityCampaignsRequest$PageSize' => '<p>The maximum number of results to include in response to a single call to the <code>ListDomainDeliverabilityCampaigns</code> operation. If the number of results is larger than the number that you specify in this parameter, the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>', 'ListEmailIdentitiesRequest$PageSize' => '<p>The number of results to show in a single call to <code>ListEmailIdentities</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p> <p>The value you specify has to be at least 0, and can be no more than 1000.</p>', 'ListEmailTemplatesRequest$PageSize' => '<p>The number of results to show in a single call to <code>ListEmailTemplates</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p> <p>The value you specify has to be at least 1, and can be no more than 10.</p>', 'ListSuppressedDestinationsRequest$PageSize' => '<p>The number of results to show in a single call to <code>ListSuppressedDestinations</code>. If the number of results is larger than the number you specified in this parameter, then the response includes a <code>NextToken</code> element, which you can use to obtain additional results.</p>', ], ], 'MaxSendRate' => [ 'base' => NULL, 'refs' => [ 'SendQuota$MaxSendRate' => '<p>The maximum number of emails that you can send per second in the current AWS Region. This value is also called your <i>maximum sending rate</i> or your <i>maximum TPS (transactions per second) rate</i>.</p>', ], ], 'Message' => [ 'base' => '<p>Represents the email message that you\'re sending. The <code>Message</code> object consists of a subject line and a message body.</p>', 'refs' => [ 'EmailContent$Simple' => '<p>The simple email message. The message consists of a subject and a message body.</p>', ], ], 'MessageContent' => [ 'base' => '<p>The body of an email message.</p>', 'refs' => [ 'GetDeliverabilityTestReportResponse$Message' => '<p>An object that contains the message that you sent when you performed this predictive inbox placement test.</p>', ], ], 'MessageData' => [ 'base' => NULL, 'refs' => [ 'Content$Data' => '<p>The content of the message itself.</p>', ], ], 'MessageRejected' => [ 'base' => '<p>The message can\'t be sent because it contains invalid content.</p>', 'refs' => [], ], 'MessageTag' => [ 'base' => '<p>Contains the name and value of a tag that you apply to an email. You can use message tags when you publish email sending events. </p>', 'refs' => [ 'MessageTagList$member' => NULL, ], ], 'MessageTagList' => [ 'base' => '<p>A list of message tags.</p>', 'refs' => [ 'BulkEmailEntry$ReplacementTags' => '<p>A list of tags, in the form of name/value pairs, to apply to an email that you send using the <code>SendBulkTemplatedEmail</code> operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.</p>', 'SendBulkEmailRequest$DefaultEmailTags' => '<p>A list of tags, in the form of name/value pairs, to apply to an email that you send using the <code>SendEmail</code> operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events.</p>', 'SendEmailRequest$EmailTags' => '<p>A list of tags, in the form of name/value pairs, to apply to an email that you send using the <code>SendEmail</code> operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events. </p>', ], ], 'MessageTagName' => [ 'base' => '<p>The name of the message tag. The message tag name has to meet the following criteria:</p> <ul> <li> <p>It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-).</p> </li> <li> <p>It can contain no more than 256 characters.</p> </li> </ul>', 'refs' => [ 'MessageTag$Name' => '<p>The name of the message tag. The message tag name has to meet the following criteria:</p> <ul> <li> <p>It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-).</p> </li> <li> <p>It can contain no more than 256 characters.</p> </li> </ul>', ], ], 'MessageTagValue' => [ 'base' => '<p>The value of the message tag. The message tag value has to meet the following criteria:</p> <ul> <li> <p>It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-).</p> </li> <li> <p>It can contain no more than 256 characters.</p> </li> </ul>', 'refs' => [ 'MessageTag$Value' => '<p>The value of the message tag. The message tag value has to meet the following criteria:</p> <ul> <li> <p>It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores (_), or dashes (-).</p> </li> <li> <p>It can contain no more than 256 characters.</p> </li> </ul>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'GetDedicatedIpsRequest$NextToken' => '<p>A token returned from a previous call to <code>GetDedicatedIps</code> to indicate the position of the dedicated IP pool in the list of IP pools.</p>', 'GetDedicatedIpsResponse$NextToken' => '<p>A token that indicates that there are additional dedicated IP addresses to list. To view additional addresses, issue another request to <code>GetDedicatedIps</code>, passing this token in the <code>NextToken</code> parameter.</p>', 'ListConfigurationSetsRequest$NextToken' => '<p>A token returned from a previous call to <code>ListConfigurationSets</code> to indicate the position in the list of configuration sets.</p>', 'ListConfigurationSetsResponse$NextToken' => '<p>A token that indicates that there are additional configuration sets to list. To view additional configuration sets, issue another request to <code>ListConfigurationSets</code>, and pass this token in the <code>NextToken</code> parameter.</p>', 'ListCustomVerificationEmailTemplatesRequest$NextToken' => '<p>A token returned from a previous call to <code>ListCustomVerificationEmailTemplates</code> to indicate the position in the list of custom verification email templates.</p>', 'ListCustomVerificationEmailTemplatesResponse$NextToken' => '<p>A token indicating that there are additional custom verification email templates available to be listed. Pass this token to a subsequent call to <code>ListCustomVerificationEmailTemplates</code> to retrieve the next 50 custom verification email templates.</p>', 'ListDedicatedIpPoolsRequest$NextToken' => '<p>A token returned from a previous call to <code>ListDedicatedIpPools</code> to indicate the position in the list of dedicated IP pools.</p>', 'ListDedicatedIpPoolsResponse$NextToken' => '<p>A token that indicates that there are additional IP pools to list. To view additional IP pools, issue another request to <code>ListDedicatedIpPools</code>, passing this token in the <code>NextToken</code> parameter.</p>', 'ListDeliverabilityTestReportsRequest$NextToken' => '<p>A token returned from a previous call to <code>ListDeliverabilityTestReports</code> to indicate the position in the list of predictive inbox placement tests.</p>', 'ListDeliverabilityTestReportsResponse$NextToken' => '<p>A token that indicates that there are additional predictive inbox placement tests to list. To view additional predictive inbox placement tests, issue another request to <code>ListDeliverabilityTestReports</code>, and pass this token in the <code>NextToken</code> parameter.</p>', 'ListDomainDeliverabilityCampaignsRequest$NextToken' => '<p>A token that’s returned from a previous call to the <code>ListDomainDeliverabilityCampaigns</code> operation. This token indicates the position of a campaign in the list of campaigns.</p>', 'ListDomainDeliverabilityCampaignsResponse$NextToken' => '<p>A token that’s returned from a previous call to the <code>ListDomainDeliverabilityCampaigns</code> operation. This token indicates the position of the campaign in the list of campaigns.</p>', 'ListEmailIdentitiesRequest$NextToken' => '<p>A token returned from a previous call to <code>ListEmailIdentities</code> to indicate the position in the list of identities.</p>', 'ListEmailIdentitiesResponse$NextToken' => '<p>A token that indicates that there are additional configuration sets to list. To view additional configuration sets, issue another request to <code>ListEmailIdentities</code>, and pass this token in the <code>NextToken</code> parameter.</p>', 'ListEmailTemplatesRequest$NextToken' => '<p>A token returned from a previous call to <code>ListEmailTemplates</code> to indicate the position in the list of email templates.</p>', 'ListEmailTemplatesResponse$NextToken' => '<p>A token indicating that there are additional email templates available to be listed. Pass this token to a subsequent <code>ListEmailTemplates</code> call to retrieve the next 10 email templates.</p>', 'ListSuppressedDestinationsRequest$NextToken' => '<p>A token returned from a previous call to <code>ListSuppressedDestinations</code> to indicate the position in the list of suppressed email addresses.</p>', 'ListSuppressedDestinationsResponse$NextToken' => '<p>A token that indicates that there are additional email addresses on the suppression list for your account. To view additional suppressed addresses, issue another request to <code>ListSuppressedDestinations</code>, and pass this token in the <code>NextToken</code> parameter.</p>', ], ], 'NotFoundException' => [ 'base' => '<p>The resource you attempted to access doesn\'t exist.</p>', 'refs' => [], ], 'OutboundMessageId' => [ 'base' => NULL, 'refs' => [ 'BulkEmailEntryResult$MessageId' => '<p>The unique message identifier returned from the <code>SendBulkTemplatedEmail</code> operation.</p>', 'SendCustomVerificationEmailResponse$MessageId' => '<p>The unique message identifier returned from the <code>SendCustomVerificationEmail</code> operation.</p>', 'SendEmailResponse$MessageId' => '<p>A unique identifier for the message that is generated when the message is accepted.</p> <note> <p>It\'s possible for Amazon SES to accept a message without sending it. This can happen when the message that you\'re trying to send has an attachment contains a virus, or when you send a templated email that contains invalid personalization content, for example.</p> </note>', 'SuppressedDestinationAttributes$MessageId' => '<p>The unique identifier of the email message that caused the email address to be added to the suppression list for your account.</p>', ], ], 'OverallVolume' => [ 'base' => '<p>An object that contains information about email that was sent from the selected domain.</p>', 'refs' => [ 'GetDomainStatisticsReportResponse$OverallVolume' => '<p>An object that contains deliverability metrics for the domain that you specified. The data in this object is a summary of all of the data that was collected from the <code>StartDate</code> to the <code>EndDate</code>.</p>', ], ], 'Percentage' => [ 'base' => '<p>An object that contains information about inbox placement percentages.</p>', 'refs' => [ 'DomainDeliverabilityCampaign$ReadRate' => '<p>The percentage of email messages that were opened by recipients. Due to technical limitations, this value only includes recipients who opened the message by using an email client that supports images.</p>', 'DomainDeliverabilityCampaign$DeleteRate' => '<p>The percentage of email messages that were deleted by recipients, without being opened first. Due to technical limitations, this value only includes recipients who opened the message by using an email client that supports images.</p>', 'DomainDeliverabilityCampaign$ReadDeleteRate' => '<p>The percentage of email messages that were opened and then deleted by recipients. Due to technical limitations, this value only includes recipients who opened the message by using an email client that supports images.</p>', 'DomainIspPlacement$InboxPercentage' => '<p>The percentage of messages that were sent from the selected domain to the specified email provider that arrived in recipients\' inboxes.</p>', 'DomainIspPlacement$SpamPercentage' => '<p>The percentage of messages that were sent from the selected domain to the specified email provider that arrived in recipients\' spam or junk mail folders.</p>', 'OverallVolume$ReadRatePercent' => '<p>The percentage of emails that were sent from the domain that were read by their recipients.</p>', 'PlacementStatistics$InboxPercentage' => '<p>The percentage of emails that arrived in recipients\' inboxes during the predictive inbox placement test.</p>', 'PlacementStatistics$SpamPercentage' => '<p>The percentage of emails that arrived in recipients\' spam or junk mail folders during the predictive inbox placement test.</p>', 'PlacementStatistics$MissingPercentage' => '<p>The percentage of emails that didn\'t arrive in recipients\' inboxes at all during the predictive inbox placement test.</p>', 'PlacementStatistics$SpfPercentage' => '<p>The percentage of emails that were authenticated by using Sender Policy Framework (SPF) during the predictive inbox placement test.</p>', 'PlacementStatistics$DkimPercentage' => '<p>The percentage of emails that were authenticated by using DomainKeys Identified Mail (DKIM) during the predictive inbox placement test.</p>', ], ], 'Percentage100Wrapper' => [ 'base' => NULL, 'refs' => [ 'DedicatedIp$WarmupPercentage' => '<p>Indicates how complete the dedicated IP warm-up process is. When this value equals 1, the address has completed the warm-up process and is ready for use.</p>', 'PutDedicatedIpWarmupAttributesRequest$WarmupPercentage' => '<p>The warm-up percentage that you want to associate with the dedicated IP address.</p>', ], ], 'PinpointDestination' => [ 'base' => '<p>An object that defines an Amazon Pinpoint project destination for email events. You can send email event data to a Amazon Pinpoint project to view metrics using the Transactional Messaging dashboards that are built in to Amazon Pinpoint. For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/analytics-transactional-messages.html">Transactional Messaging Charts</a> in the <i>Amazon Pinpoint User Guide</i>.</p>', 'refs' => [ 'EventDestination$PinpointDestination' => '<p>An object that defines an Amazon Pinpoint project destination for email events. You can send email event data to a Amazon Pinpoint project to view metrics using the Transactional Messaging dashboards that are built in to Amazon Pinpoint. For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/analytics-transactional-messages.html">Transactional Messaging Charts</a> in the <i>Amazon Pinpoint User Guide</i>.</p>', 'EventDestinationDefinition$PinpointDestination' => '<p>An object that defines an Amazon Pinpoint project destination for email events. You can send email event data to a Amazon Pinpoint project to view metrics using the Transactional Messaging dashboards that are built in to Amazon Pinpoint. For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/analytics-transactional-messages.html">Transactional Messaging Charts</a> in the <i>Amazon Pinpoint User Guide</i>.</p>', ], ], 'PlacementStatistics' => [ 'base' => '<p>An object that contains inbox placement data for an email provider.</p>', 'refs' => [ 'GetDeliverabilityTestReportResponse$OverallPlacement' => '<p>An object that specifies how many test messages that were sent during the predictive inbox placement test were delivered to recipients\' inboxes, how many were sent to recipients\' spam folders, and how many weren\'t delivered.</p>', 'IspPlacement$PlacementStatistics' => '<p>An object that contains inbox placement metrics for a specific email provider.</p>', ], ], 'Policy' => [ 'base' => '<p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p> <p>For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [ 'CreateEmailIdentityPolicyRequest$Policy' => '<p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p> <p>For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer Guide</a>.</p>', 'PolicyMap$value' => NULL, 'UpdateEmailIdentityPolicyRequest$Policy' => '<p>The text of the policy in JSON format. The policy cannot exceed 4 KB.</p> <p> For information about the syntax of sending authorization policies, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES Developer Guide</a>.</p>', ], ], 'PolicyMap' => [ 'base' => '<p>An object that contains mapping between <code>PolicyName</code> and <code>Policy</code> text.</p>', 'refs' => [ 'GetEmailIdentityPoliciesResponse$Policies' => '<p>A map of policy names to policies.</p>', 'GetEmailIdentityResponse$Policies' => '<p>A map of policy names to policies.</p>', ], ], 'PolicyName' => [ 'base' => '<p>The name of the policy.</p> <p>The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.</p>', 'refs' => [ 'CreateEmailIdentityPolicyRequest$PolicyName' => '<p>The name of the policy.</p> <p>The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.</p>', 'DeleteEmailIdentityPolicyRequest$PolicyName' => '<p>The name of the policy.</p> <p>The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.</p>', 'PolicyMap$key' => NULL, 'UpdateEmailIdentityPolicyRequest$PolicyName' => '<p>The name of the policy.</p> <p>The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.</p>', ], ], 'PoolName' => [ 'base' => '<p>The name of a dedicated IP pool.</p>', 'refs' => [ 'CreateDedicatedIpPoolRequest$PoolName' => '<p>The name of the dedicated IP pool.</p>', 'DedicatedIp$PoolName' => '<p>The name of the dedicated IP pool that the IP address is associated with.</p>', 'DeleteDedicatedIpPoolRequest$PoolName' => '<p>The name of the dedicated IP pool that you want to delete.</p>', 'DeliveryOptions$SendingPoolName' => '<p>The name of the dedicated IP pool that you want to associate with the configuration set.</p>', 'GetDedicatedIpsRequest$PoolName' => '<p>The name of the IP pool that the dedicated IP address is associated with.</p>', 'ListOfDedicatedIpPools$member' => NULL, 'PutDedicatedIpInPoolRequest$DestinationPoolName' => '<p>The name of the IP pool that you want to add the dedicated IP address to. You have to specify an IP pool that already exists.</p>', ], ], 'PrivateKey' => [ 'base' => NULL, 'refs' => [ 'DkimSigningAttributes$DomainSigningPrivateKey' => '<p>A private key that\'s used to generate a DKIM signature.</p> <p>The private key must use 1024-bit RSA encryption, and must be encoded using base64 encoding.</p>', ], ], 'PutAccountDedicatedIpWarmupAttributesRequest' => [ 'base' => '<p>A request to enable or disable the automatic IP address warm-up feature.</p>', 'refs' => [], ], 'PutAccountDedicatedIpWarmupAttributesResponse' => [ 'base' => '<p>An HTTP 200 response if the request succeeds, or an error message if the request fails.</p>', 'refs' => [], ], 'PutAccountDetailsRequest' => [ 'base' => '<p>A request to submit new account details.</p>', 'refs' => [], ], 'PutAccountDetailsResponse' => [ 'base' => '<p>An HTTP 200 response if the request succeeds, or an error message if the request fails.</p>', 'refs' => [], ], 'PutAccountSendingAttributesRequest' => [ 'base' => '<p>A request to change the ability of your account to send email.</p>', 'refs' => [], ], 'PutAccountSendingAttributesResponse' => [ 'base' => '<p>An HTTP 200 response if the request succeeds, or an error message if the request fails.</p>', 'refs' => [], ], 'PutAccountSuppressionAttributesRequest' => [ 'base' => '<p>A request to change your account\'s suppression preferences.</p>', 'refs' => [], ], 'PutAccountSuppressionAttributesResponse' => [ 'base' => '<p>An HTTP 200 response if the request succeeds, or an error message if the request fails.</p>', 'refs' => [], ], 'PutConfigurationSetDeliveryOptionsRequest' => [ 'base' => '<p>A request to associate a configuration set with a dedicated IP pool.</p>', 'refs' => [], ], 'PutConfigurationSetDeliveryOptionsResponse' => [ 'base' => '<p>An HTTP 200 response if the request succeeds, or an error message if the request fails.</p>', 'refs' => [], ], 'PutConfigurationSetReputationOptionsRequest' => [ 'base' => '<p>A request to enable or disable tracking of reputation metrics for a configuration set.</p>', 'refs' => [], ], 'PutConfigurationSetReputationOptionsResponse' => [ 'base' => '<p>An HTTP 200 response if the request succeeds, or an error message if the request fails.</p>', 'refs' => [], ], 'PutConfigurationSetSendingOptionsRequest' => [ 'base' => '<p>A request to enable or disable the ability of Amazon SES to send emails that use a specific configuration set.</p>', 'refs' => [], ], 'PutConfigurationSetSendingOptionsResponse' => [ 'base' => '<p>An HTTP 200 response if the request succeeds, or an error message if the request fails.</p>', 'refs' => [], ], 'PutConfigurationSetSuppressionOptionsRequest' => [ 'base' => '<p>A request to change the account suppression list preferences for a specific configuration set.</p>', 'refs' => [], ], 'PutConfigurationSetSuppressionOptionsResponse' => [ 'base' => '<p>An HTTP 200 response if the request succeeds, or an error message if the request fails.</p>', 'refs' => [], ], 'PutConfigurationSetTrackingOptionsRequest' => [ 'base' => '<p>A request to add a custom domain for tracking open and click events to a configuration set.</p>', 'refs' => [], ], 'PutConfigurationSetTrackingOptionsResponse' => [ 'base' => '<p>An HTTP 200 response if the request succeeds, or an error message if the request fails.</p>', 'refs' => [], ], 'PutDedicatedIpInPoolRequest' => [ 'base' => '<p>A request to move a dedicated IP address to a dedicated IP pool.</p>', 'refs' => [], ], 'PutDedicatedIpInPoolResponse' => [ 'base' => '<p>An HTTP 200 response if the request succeeds, or an error message if the request fails.</p>', 'refs' => [], ], 'PutDedicatedIpWarmupAttributesRequest' => [ 'base' => '<p>A request to change the warm-up attributes for a dedicated IP address. This operation is useful when you want to resume the warm-up process for an existing IP address.</p>', 'refs' => [], ], 'PutDedicatedIpWarmupAttributesResponse' => [ 'base' => '<p>An HTTP 200 response if the request succeeds, or an error message if the request fails.</p>', 'refs' => [], ], 'PutDeliverabilityDashboardOptionRequest' => [ 'base' => '<p>Enable or disable the Deliverability dashboard. When you enable the Deliverability dashboard, you gain access to reputation, deliverability, and other metrics for the domains that you use to send email using Amazon SES API v2. You also gain the ability to perform predictive inbox placement tests.</p> <p>When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees that you accrue by using Amazon SES and other AWS services. For more information about the features and cost of a Deliverability dashboard subscription, see <a href="http://aws.amazon.com/pinpoint/pricing/">Amazon Pinpoint Pricing</a>.</p>', 'refs' => [], ], 'PutDeliverabilityDashboardOptionResponse' => [ 'base' => '<p>A response that indicates whether the Deliverability dashboard is enabled.</p>', 'refs' => [], ], 'PutEmailIdentityDkimAttributesRequest' => [ 'base' => '<p>A request to enable or disable DKIM signing of email that you send from an email identity.</p>', 'refs' => [], ], 'PutEmailIdentityDkimAttributesResponse' => [ 'base' => '<p>An HTTP 200 response if the request succeeds, or an error message if the request fails.</p>', 'refs' => [], ], 'PutEmailIdentityDkimSigningAttributesRequest' => [ 'base' => '<p>A request to change the DKIM attributes for an email identity.</p>', 'refs' => [], ], 'PutEmailIdentityDkimSigningAttributesResponse' => [ 'base' => '<p>If the action is successful, the service sends back an HTTP 200 response.</p> <p>The following data is returned in JSON format by the service.</p>', 'refs' => [], ], 'PutEmailIdentityFeedbackAttributesRequest' => [ 'base' => '<p>A request to set the attributes that control how bounce and complaint events are processed.</p>', 'refs' => [], ], 'PutEmailIdentityFeedbackAttributesResponse' => [ 'base' => '<p>An HTTP 200 response if the request succeeds, or an error message if the request fails.</p>', 'refs' => [], ], 'PutEmailIdentityMailFromAttributesRequest' => [ 'base' => '<p>A request to configure the custom MAIL FROM domain for a verified identity.</p>', 'refs' => [], ], 'PutEmailIdentityMailFromAttributesResponse' => [ 'base' => '<p>An HTTP 200 response if the request succeeds, or an error message if the request fails.</p>', 'refs' => [], ], 'PutSuppressedDestinationRequest' => [ 'base' => '<p>A request to add an email destination to the suppression list for your account.</p>', 'refs' => [], ], 'PutSuppressedDestinationResponse' => [ 'base' => '<p>An HTTP 200 response if the request succeeds, or an error message if the request fails.</p>', 'refs' => [], ], 'RawMessage' => [ 'base' => '<p>Represents the raw content of an email message.</p>', 'refs' => [ 'EmailContent$Raw' => '<p>The raw email message. The message has to meet the following criteria:</p> <ul> <li> <p>The message has to contain a header and a body, separated by one blank line.</p> </li> <li> <p>All of the required header fields must be present in the message.</p> </li> <li> <p>Each part of a multipart MIME message must be formatted properly.</p> </li> <li> <p>If you include attachments, they must be in a file format that the Amazon SES API v2 supports. </p> </li> <li> <p>The entire message must be Base64 encoded.</p> </li> <li> <p>If any of the MIME parts in your message contain content that is outside of the 7-bit ASCII character range, you should encode that content to ensure that recipients\' email clients render the message properly.</p> </li> <li> <p>The length of any single line of text in the message can\'t exceed 1,000 characters. This restriction is defined in <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.</p> </li> </ul>', ], ], 'RawMessageData' => [ 'base' => '<p>The raw email message. The message has to meet the following criteria:</p> <ul> <li> <p>The message has to contain a header and a body, separated by one blank line.</p> </li> <li> <p>All of the required header fields must be present in the message.</p> </li> <li> <p>Each part of a multipart MIME message must be formatted properly.</p> </li> <li> <p>Attachments must be in a file format that the Amazon SES API v2 supports. </p> </li> <li> <p>The entire message must be Base64 encoded.</p> </li> <li> <p>If any of the MIME parts in your message contain content that is outside of the 7-bit ASCII character range, you should encode that content to ensure that recipients\' email clients render the message properly.</p> </li> <li> <p>The length of any single line of text in the message can\'t exceed 1,000 characters. This restriction is defined in <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.</p> </li> </ul>', 'refs' => [ 'RawMessage$Data' => '<p>The raw email message. The message has to meet the following criteria:</p> <ul> <li> <p>The message has to contain a header and a body, separated by one blank line.</p> </li> <li> <p>All of the required header fields must be present in the message.</p> </li> <li> <p>Each part of a multipart MIME message must be formatted properly.</p> </li> <li> <p>Attachments must be in a file format that the Amazon SES supports.</p> </li> <li> <p>The entire message must be Base64 encoded.</p> </li> <li> <p>If any of the MIME parts in your message contain content that is outside of the 7-bit ASCII character range, you should encode that content to ensure that recipients\' email clients render the message properly.</p> </li> <li> <p>The length of any single line of text in the message can\'t exceed 1,000 characters. This restriction is defined in <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.</p> </li> </ul>', ], ], 'RblName' => [ 'base' => '<p>The name of a blacklist that an IP address was found on.</p>', 'refs' => [ 'BlacklistEntry$RblName' => '<p>The name of the blacklist that the IP address appears on.</p>', ], ], 'RenderedEmailTemplate' => [ 'base' => '<p>The complete MIME message rendered by applying the data in the TemplateData parameter to the template specified in the TemplateName parameter.</p>', 'refs' => [ 'TestRenderEmailTemplateResponse$RenderedTemplate' => '<p>The complete MIME message rendered by applying the data in the <code>TemplateData</code> parameter to the template specified in the TemplateName parameter.</p>', ], ], 'ReplacementEmailContent' => [ 'base' => '<p>The <code>ReplaceEmailContent</code> object to be used for a specific <code>BulkEmailEntry</code>. The <code>ReplacementTemplate</code> can be specified within this object.</p>', 'refs' => [ 'BulkEmailEntry$ReplacementEmailContent' => '<p>The <code>ReplacementEmailContent</code> associated with a <code>BulkEmailEntry</code>.</p>', ], ], 'ReplacementTemplate' => [ 'base' => '<p>An object which contains <code>ReplacementTemplateData</code> to be used for a specific <code>BulkEmailEntry</code>.</p>', 'refs' => [ 'ReplacementEmailContent$ReplacementTemplate' => '<p>The <code>ReplacementTemplate</code> associated with <code>ReplacementEmailContent</code>.</p>', ], ], 'ReportId' => [ 'base' => '<p>A unique string that identifies a Deliverability dashboard report.</p>', 'refs' => [ 'CreateDeliverabilityTestReportResponse$ReportId' => '<p>A unique string that identifies the predictive inbox placement test.</p>', 'DeliverabilityTestReport$ReportId' => '<p>A unique string that identifies the predictive inbox placement test.</p>', 'GetDeliverabilityTestReportRequest$ReportId' => '<p>A unique string that identifies the predictive inbox placement test.</p>', ], ], 'ReportName' => [ 'base' => '<p>A name that helps you identify a report generated by the Deliverability dashboard.</p>', 'refs' => [ 'CreateDeliverabilityTestReportRequest$ReportName' => '<p>A unique name that helps you to identify the predictive inbox placement test when you retrieve the results.</p>', 'DeliverabilityTestReport$ReportName' => '<p>A name that helps you identify a predictive inbox placement test report.</p>', ], ], 'ReputationOptions' => [ 'base' => '<p>Enable or disable collection of reputation metrics for emails that you send using this configuration set in the current AWS Region. </p>', 'refs' => [ 'CreateConfigurationSetRequest$ReputationOptions' => '<p>An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send that use the configuration set.</p>', 'GetConfigurationSetResponse$ReputationOptions' => '<p>An object that defines whether or not Amazon SES collects reputation metrics for the emails that you send that use the configuration set.</p>', ], ], 'ReviewDetails' => [ 'base' => '<p>An object that contains information about your account details review.</p>', 'refs' => [ 'AccountDetails$ReviewDetails' => '<p>Information about the review of the latest details you submitted.</p>', ], ], 'ReviewStatus' => [ 'base' => NULL, 'refs' => [ 'ReviewDetails$Status' => '<p>The status of the latest review of your account. The status can be one of the following:</p> <ul> <li> <p> <code>PENDING</code> – We have received your appeal and are in the process of reviewing it.</p> </li> <li> <p> <code>GRANTED</code> – Your appeal has been reviewed and your production access has been granted.</p> </li> <li> <p> <code>DENIED</code> – Your appeal has been reviewed and your production access has been denied.</p> </li> <li> <p> <code>FAILED</code> – An internal error occurred and we didn\'t receive your appeal. You can submit your appeal again.</p> </li> </ul>', ], ], 'Selector' => [ 'base' => NULL, 'refs' => [ 'DkimSigningAttributes$DomainSigningSelector' => '<p>A string that\'s used to identify a public key in the DNS configuration for a domain.</p>', ], ], 'SendBulkEmailRequest' => [ 'base' => '<p>Represents a request to send email messages to multiple destinations using Amazon SES. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'SendBulkEmailResponse' => [ 'base' => '<p>The following data is returned in JSON format by the service.</p>', 'refs' => [], ], 'SendCustomVerificationEmailRequest' => [ 'base' => '<p>Represents a request to send a custom verification email to a specified recipient.</p>', 'refs' => [], ], 'SendCustomVerificationEmailResponse' => [ 'base' => '<p>The following element is returned by the service.</p>', 'refs' => [], ], 'SendEmailRequest' => [ 'base' => '<p>Represents a request to send a single formatted email using Amazon SES. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-formatted.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'SendEmailResponse' => [ 'base' => '<p>A unique message ID that you receive when an email is accepted for sending.</p>', 'refs' => [], ], 'SendQuota' => [ 'base' => '<p>An object that contains information about the per-day and per-second sending limits for your Amazon SES account in the current AWS Region.</p>', 'refs' => [ 'GetAccountResponse$SendQuota' => '<p>An object that contains information about the per-day and per-second sending limits for your Amazon SES account in the current AWS Region.</p>', ], ], 'SendingOptions' => [ 'base' => '<p>Used to enable or disable email sending for messages that use this configuration set in the current AWS Region.</p>', 'refs' => [ 'CreateConfigurationSetRequest$SendingOptions' => '<p>An object that defines whether or not Amazon SES can send email that you send using the configuration set.</p>', 'GetConfigurationSetResponse$SendingOptions' => '<p>An object that defines whether or not Amazon SES can send email that you send using the configuration set.</p>', ], ], 'SendingPausedException' => [ 'base' => '<p>The message can\'t be sent because the account\'s ability to send email is currently paused.</p>', 'refs' => [], ], 'SendingPoolName' => [ 'base' => '<p>The name of the dedicated IP pool that you want to associate with the configuration set.</p>', 'refs' => [ 'PutConfigurationSetDeliveryOptionsRequest$SendingPoolName' => '<p>The name of the dedicated IP pool that you want to associate with the configuration set.</p>', ], ], 'SentLast24Hours' => [ 'base' => NULL, 'refs' => [ 'SendQuota$SentLast24Hours' => '<p>The number of emails sent from your Amazon SES account in the current AWS Region over the past 24 hours.</p>', ], ], 'SnsDestination' => [ 'base' => '<p>An object that defines an Amazon SNS destination for email events. You can use Amazon SNS to send notification when certain email events occur.</p>', 'refs' => [ 'EventDestination$SnsDestination' => '<p>An object that defines an Amazon SNS destination for email events. You can use Amazon SNS to send notification when certain email events occur.</p>', 'EventDestinationDefinition$SnsDestination' => '<p>An object that defines an Amazon SNS destination for email events. You can use Amazon SNS to send notification when certain email events occur.</p>', ], ], 'Subject' => [ 'base' => NULL, 'refs' => [ 'DomainDeliverabilityCampaign$Subject' => '<p>The subject line, or title, of the email message.</p>', ], ], 'SuccessRedirectionURL' => [ 'base' => '<p>The URL that the recipient of the verification email is sent to if his or her address is successfully verified.</p>', 'refs' => [ 'CreateCustomVerificationEmailTemplateRequest$SuccessRedirectionURL' => '<p>The URL that the recipient of the verification email is sent to if his or her address is successfully verified.</p>', 'CustomVerificationEmailTemplateMetadata$SuccessRedirectionURL' => '<p>The URL that the recipient of the verification email is sent to if his or her address is successfully verified.</p>', 'GetCustomVerificationEmailTemplateResponse$SuccessRedirectionURL' => '<p>The URL that the recipient of the verification email is sent to if his or her address is successfully verified.</p>', 'UpdateCustomVerificationEmailTemplateRequest$SuccessRedirectionURL' => '<p>The URL that the recipient of the verification email is sent to if his or her address is successfully verified.</p>', ], ], 'SuppressedDestination' => [ 'base' => '<p>An object that contains information about an email address that is on the suppression list for your account.</p>', 'refs' => [ 'GetSuppressedDestinationResponse$SuppressedDestination' => '<p>An object containing information about the suppressed email address.</p>', ], ], 'SuppressedDestinationAttributes' => [ 'base' => '<p>An object that contains additional attributes that are related an email address that is on the suppression list for your account.</p>', 'refs' => [ 'SuppressedDestination$Attributes' => '<p>An optional value that can contain additional information about the reasons that the address was added to the suppression list for your account.</p>', ], ], 'SuppressedDestinationSummaries' => [ 'base' => NULL, 'refs' => [ 'ListSuppressedDestinationsResponse$SuppressedDestinationSummaries' => '<p>A list of summaries, each containing a summary for a suppressed email destination.</p>', ], ], 'SuppressedDestinationSummary' => [ 'base' => '<p>A summary that describes the suppressed email address.</p>', 'refs' => [ 'SuppressedDestinationSummaries$member' => NULL, ], ], 'SuppressionAttributes' => [ 'base' => '<p>An object that contains information about the email address suppression preferences for your account in the current AWS Region.</p>', 'refs' => [ 'GetAccountResponse$SuppressionAttributes' => '<p>An object that contains information about the email address suppression preferences for your account in the current AWS Region.</p>', ], ], 'SuppressionListReason' => [ 'base' => '<p>The reason that the address was added to the suppression list for your account. The value can be one of the following:</p> <ul> <li> <p> <code>COMPLAINT</code> – Amazon SES added an email address to the suppression list for your account because a message sent to that address results in a complaint.</p> </li> <li> <p> <code>BOUNCE</code> – Amazon SES added an email address to the suppression list for your account because a message sent to that address results in a hard bounce.</p> </li> </ul>', 'refs' => [ 'PutSuppressedDestinationRequest$Reason' => '<p>The factors that should cause the email address to be added to the suppression list for your account.</p>', 'SuppressedDestination$Reason' => '<p>The reason that the address was added to the suppression list for your account.</p>', 'SuppressedDestinationSummary$Reason' => '<p>The reason that the address was added to the suppression list for your account.</p>', 'SuppressionListReasons$member' => NULL, ], ], 'SuppressionListReasons' => [ 'base' => NULL, 'refs' => [ 'ListSuppressedDestinationsRequest$Reasons' => '<p>The factors that caused the email address to be added to .</p>', 'PutAccountSuppressionAttributesRequest$SuppressedReasons' => '<p>A list that contains the reasons that email addresses will be automatically added to the suppression list for your account. This list can contain any or all of the following:</p> <ul> <li> <p> <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a complaint.</p> </li> <li> <p> <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a hard bounce.</p> </li> </ul>', 'PutConfigurationSetSuppressionOptionsRequest$SuppressedReasons' => '<p>A list that contains the reasons that email addresses are automatically added to the suppression list for your account. This list can contain any or all of the following:</p> <ul> <li> <p> <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a complaint.</p> </li> <li> <p> <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a hard bounce.</p> </li> </ul>', 'SuppressionAttributes$SuppressedReasons' => '<p>A list that contains the reasons that email addresses will be automatically added to the suppression list for your account. This list can contain any or all of the following:</p> <ul> <li> <p> <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a complaint.</p> </li> <li> <p> <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a hard bounce.</p> </li> </ul>', 'SuppressionOptions$SuppressedReasons' => '<p>A list that contains the reasons that email addresses are automatically added to the suppression list for your account. This list can contain any or all of the following:</p> <ul> <li> <p> <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a complaint.</p> </li> <li> <p> <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a hard bounce.</p> </li> </ul>', ], ], 'SuppressionOptions' => [ 'base' => '<p>An object that contains information about the suppression list preferences for your account.</p>', 'refs' => [ 'CreateConfigurationSetRequest$SuppressionOptions' => NULL, 'GetConfigurationSetResponse$SuppressionOptions' => '<p>An object that contains information about the suppression list preferences for your account.</p>', ], ], 'Tag' => [ 'base' => '<p>An object that defines the tags that are associated with a resource. A <i>tag</i> is a label that you optionally define and associate with a resource. Tags can help you categorize and manage resources in different ways, such as by purpose, owner, environment, or other criteria. A resource can have as many as 50 tags.</p> <p>Each tag consists of a required <i>tag key</i> and an associated <i>tag value</i>, both of which you define. A tag key is a general label that acts as a category for a more specific tag value. A tag value acts as a descriptor within a tag key. A tag key can contain as many as 128 characters. A tag value can contain as many as 256 characters. The characters can be Unicode letters, digits, white space, or one of the following symbols: _ . : / = + -. The following additional restrictions apply to tags:</p> <ul> <li> <p>Tag keys and values are case sensitive.</p> </li> <li> <p>For each associated resource, each tag key must be unique and it can have only one value.</p> </li> <li> <p>The <code>aws:</code> prefix is reserved for use by AWS; you can’t use it in any tag keys or values that you define. In addition, you can\'t edit or remove tag keys or values that use this prefix. Tags that use this prefix don’t count against the limit of 50 tags per resource.</p> </li> <li> <p>You can associate tags with public or shared resources, but the tags are available only for your AWS account, not any other accounts that share the resource. In addition, the tags are available only for resources that are located in the specified AWS Region for your AWS account.</p> </li> </ul>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>One part of a key-value pair that defines a tag. The maximum length of a tag key is 128 characters. The minimum length is 1 character.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The tags (tag keys) that you want to remove from the resource. When you specify a tag key, the action removes both that key and its associated tag value.</p> <p>To remove more than one tag from the resource, append the <code>TagKeys</code> parameter and argument for each additional tag to remove, separated by an ampersand. For example: <code>/v2/email/tags?ResourceArn=ResourceArn&amp;TagKeys=Key1&amp;TagKeys=Key2</code> </p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateConfigurationSetRequest$Tags' => '<p>An array of objects that define the tags (keys and values) that you want to associate with the configuration set.</p>', 'CreateDedicatedIpPoolRequest$Tags' => '<p>An object that defines the tags (keys and values) that you want to associate with the pool.</p>', 'CreateDeliverabilityTestReportRequest$Tags' => '<p>An array of objects that define the tags (keys and values) that you want to associate with the predictive inbox placement test.</p>', 'CreateEmailIdentityRequest$Tags' => '<p>An array of objects that define the tags (keys and values) that you want to associate with the email identity.</p>', 'GetConfigurationSetResponse$Tags' => '<p>An array of objects that define the tags (keys and values) that are associated with the configuration set.</p>', 'GetDeliverabilityTestReportResponse$Tags' => '<p>An array of objects that define the tags (keys and values) that are associated with the predictive inbox placement test.</p>', 'GetEmailIdentityResponse$Tags' => '<p>An array of objects that define the tags (keys and values) that are associated with the email identity.</p>', 'ListTagsForResourceResponse$Tags' => '<p>An array that lists all the tags that are associated with the resource. Each tag consists of a required tag key (<code>Key</code>) and an associated tag value (<code>Value</code>)</p>', 'TagResourceRequest$Tags' => '<p>A list of the tags that you want to add to the resource. A tag consists of a required tag key (<code>Key</code>) and an associated tag value (<code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The optional part of a key-value pair that defines a tag. The maximum length of a tag value is 256 characters. The minimum length is 0 characters. If you don\'t want a resource to have a specific tag value, don\'t specify a value for this parameter. If you don\'t specify a value, Amazon SES sets the value to an empty string.</p>', ], ], 'Template' => [ 'base' => '<p>An object that defines the email template to use for an email message, and the values to use for any message variables in that template. An <i>email template</i> is a type of message template that contains content that you want to define, save, and reuse in email messages that you send.</p>', 'refs' => [ 'BulkEmailContent$Template' => '<p>The template to use for the bulk email message.</p>', 'EmailContent$Template' => '<p>The template to use for the email message.</p>', ], ], 'TemplateContent' => [ 'base' => '<p>The content of the custom verification email template.</p>', 'refs' => [ 'CreateCustomVerificationEmailTemplateRequest$TemplateContent' => '<p>The content of the custom verification email. The total size of the email must be less than 10 MB. The message body may contain HTML, with some limitations. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES Developer Guide</i>.</p>', 'GetCustomVerificationEmailTemplateResponse$TemplateContent' => '<p>The content of the custom verification email.</p>', 'UpdateCustomVerificationEmailTemplateRequest$TemplateContent' => '<p>The content of the custom verification email. The total size of the email must be less than 10 MB. The message body may contain HTML, with some limitations. For more information, see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html#custom-verification-emails-faq">Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES Developer Guide</i>.</p>', ], ], 'TestRenderEmailTemplateRequest' => [ 'base' => '<p>&gt;Represents a request to create a preview of the MIME content of an email when provided with a template and a set of replacement data.</p>', 'refs' => [], ], 'TestRenderEmailTemplateResponse' => [ 'base' => '<p>The following element is returned by the service.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'BlacklistEntry$ListingTime' => '<p>The time when the blacklisting event occurred, shown in Unix time format.</p>', 'DailyVolume$StartDate' => '<p>The date that the DailyVolume metrics apply to, in Unix time.</p>', 'DeliverabilityTestReport$CreateDate' => '<p>The date and time when the predictive inbox placement test was created, in Unix time format.</p>', 'DomainDeliverabilityCampaign$FirstSeenDateTime' => '<p>The first time, in Unix time format, when the email message was delivered to any recipient\'s inbox. This value can help you determine how long it took for a campaign to deliver an email message.</p>', 'DomainDeliverabilityCampaign$LastSeenDateTime' => '<p>The last time, in Unix time format, when the email message was delivered to any recipient\'s inbox. This value can help you determine how long it took for a campaign to deliver an email message.</p>', 'DomainDeliverabilityTrackingOption$SubscriptionStartDate' => '<p>The date, in Unix time format, when you enabled the Deliverability dashboard for the domain.</p>', 'EmailTemplateMetadata$CreatedTimestamp' => '<p>The time and date the template was created.</p>', 'GetDeliverabilityDashboardOptionsResponse$SubscriptionExpiryDate' => '<p>The date, in Unix time format, when your current subscription to the Deliverability dashboard is scheduled to expire, if your subscription is scheduled to expire at the end of the current calendar month. This value is null if you have an active subscription that isn’t due to expire at the end of the month.</p>', 'GetDomainStatisticsReportRequest$StartDate' => '<p>The first day (in Unix time) that you want to obtain domain deliverability metrics for.</p>', 'GetDomainStatisticsReportRequest$EndDate' => '<p>The last day (in Unix time) that you want to obtain domain deliverability metrics for. The <code>EndDate</code> that you specify has to be less than or equal to 30 days after the <code>StartDate</code>.</p>', 'ListDomainDeliverabilityCampaignsRequest$StartDate' => '<p>The first day, in Unix time format, that you want to obtain deliverability data for.</p>', 'ListDomainDeliverabilityCampaignsRequest$EndDate' => '<p>The last day, in Unix time format, that you want to obtain deliverability data for. This value has to be less than or equal to 30 days after the value of the <code>StartDate</code> parameter.</p>', 'ListSuppressedDestinationsRequest$StartDate' => '<p>Used to filter the list of suppressed email destinations so that it only includes addresses that were added to the list after a specific date. The date that you specify should be in Unix time format.</p>', 'ListSuppressedDestinationsRequest$EndDate' => '<p>Used to filter the list of suppressed email destinations so that it only includes addresses that were added to the list before a specific date. The date that you specify should be in Unix time format.</p>', 'SuppressedDestination$LastUpdateTime' => '<p>The date and time when the suppressed destination was last updated, shown in Unix time format.</p>', 'SuppressedDestinationSummary$LastUpdateTime' => '<p>The date and time when the suppressed destination was last updated, shown in Unix time format.</p>', ], ], 'TlsPolicy' => [ 'base' => '<p>Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). If the value is <code>Require</code>, messages are only delivered if a TLS connection can be established. If the value is <code>Optional</code>, messages can be delivered in plain text if a TLS connection can\'t be established.</p>', 'refs' => [ 'DeliveryOptions$TlsPolicy' => '<p>Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). If the value is <code>Require</code>, messages are only delivered if a TLS connection can be established. If the value is <code>Optional</code>, messages can be delivered in plain text if a TLS connection can\'t be established.</p>', 'PutConfigurationSetDeliveryOptionsRequest$TlsPolicy' => '<p>Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). If the value is <code>Require</code>, messages are only delivered if a TLS connection can be established. If the value is <code>Optional</code>, messages can be delivered in plain text if a TLS connection can\'t be established.</p>', ], ], 'TooManyRequestsException' => [ 'base' => '<p>Too many requests have been made to the operation.</p>', 'refs' => [], ], 'TrackingOptions' => [ 'base' => '<p>An object that defines the tracking options for a configuration set. When you use the Amazon SES API v2 to send an email, it contains an invisible image that\'s used to track when recipients open your email. If your email contains links, those links are changed slightly in order to track when recipients click them.</p> <p>These images and links include references to a domain operated by AWS. You can optionally configure the Amazon SES to use a domain that you operate for these images and links.</p>', 'refs' => [ 'CreateConfigurationSetRequest$TrackingOptions' => '<p>An object that defines the open and click tracking options for emails that you send using the configuration set.</p>', 'GetConfigurationSetResponse$TrackingOptions' => '<p>An object that defines the open and click tracking options for emails that you send using the configuration set.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConfigurationSetEventDestinationRequest' => [ 'base' => '<p>A request to change the settings for an event destination for a configuration set.</p>', 'refs' => [], ], 'UpdateConfigurationSetEventDestinationResponse' => [ 'base' => '<p>An HTTP 200 response if the request succeeds, or an error message if the request fails.</p>', 'refs' => [], ], 'UpdateCustomVerificationEmailTemplateRequest' => [ 'base' => '<p>Represents a request to update an existing custom verification email template.</p>', 'refs' => [], ], 'UpdateCustomVerificationEmailTemplateResponse' => [ 'base' => '<p>If the action is successful, the service sends back an HTTP 200 response with an empty HTTP body.</p>', 'refs' => [], ], 'UpdateEmailIdentityPolicyRequest' => [ 'base' => '<p>Represents a request to update a sending authorization policy for an identity. Sending authorization is an Amazon SES feature that enables you to authorize other senders to use your identities. For information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-identity-owner-tasks-management.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'UpdateEmailIdentityPolicyResponse' => [ 'base' => '<p>An HTTP 200 response if the request succeeds, or an error message if the request fails.</p>', 'refs' => [], ], 'UpdateEmailTemplateRequest' => [ 'base' => '<p>Represents a request to update an email template. For more information, see the <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES Developer Guide</a>.</p>', 'refs' => [], ], 'UpdateEmailTemplateResponse' => [ 'base' => '<p>If the action is successful, the service sends back an HTTP 200 response with an empty HTTP body.</p>', 'refs' => [], ], 'UseCaseDescription' => [ 'base' => NULL, 'refs' => [ 'AccountDetails$UseCaseDescription' => '<p>A description of the types of email that you plan to send.</p>', 'PutAccountDetailsRequest$UseCaseDescription' => '<p>A description of the types of email that you plan to send.</p>', ], ], 'Volume' => [ 'base' => '<p>An object that contains information about inbox placement volume.</p>', 'refs' => [ 'DomainDeliverabilityCampaign$InboxCount' => '<p>The number of email messages that were delivered to recipients’ inboxes.</p>', 'DomainDeliverabilityCampaign$SpamCount' => '<p>The number of email messages that were delivered to recipients\' spam or junk mail folders.</p>', 'DomainDeliverabilityCampaign$ProjectedVolume' => '<p>The projected number of recipients that the email message was sent to.</p>', 'DomainIspPlacement$InboxRawCount' => '<p>The total number of messages that were sent from the selected domain to the specified email provider that arrived in recipients\' inboxes.</p>', 'DomainIspPlacement$SpamRawCount' => '<p>The total number of messages that were sent from the selected domain to the specified email provider that arrived in recipients\' spam or junk mail folders.</p>', 'VolumeStatistics$InboxRawCount' => '<p>The total number of emails that arrived in recipients\' inboxes.</p>', 'VolumeStatistics$SpamRawCount' => '<p>The total number of emails that arrived in recipients\' spam or junk mail folders.</p>', 'VolumeStatistics$ProjectedInbox' => '<p>An estimate of the percentage of emails sent from the current domain that will arrive in recipients\' inboxes.</p>', 'VolumeStatistics$ProjectedSpam' => '<p>An estimate of the percentage of emails sent from the current domain that will arrive in recipients\' spam or junk mail folders.</p>', ], ], 'VolumeStatistics' => [ 'base' => '<p>An object that contains information about the amount of email that was delivered to recipients.</p>', 'refs' => [ 'DailyVolume$VolumeStatistics' => '<p>An object that contains inbox placement metrics for a specific day in the analysis period.</p>', 'OverallVolume$VolumeStatistics' => '<p>An object that contains information about the numbers of messages that arrived in recipients\' inboxes and junk mail folders.</p>', ], ], 'WarmupStatus' => [ 'base' => '<p>The warmup status of a dedicated IP.</p>', 'refs' => [ 'DedicatedIp$WarmupStatus' => '<p>The warm-up status of a dedicated IP address. The status can have one of the following values:</p> <ul> <li> <p> <code>IN_PROGRESS</code> – The IP address isn\'t ready to use because the dedicated IP warm-up process is ongoing.</p> </li> <li> <p> <code>DONE</code> – The dedicated IP warm-up process is complete, and the IP address is ready to use.</p> </li> </ul>', ], ], 'WebsiteURL' => [ 'base' => NULL, 'refs' => [ 'AccountDetails$WebsiteURL' => '<p>The URL of your website. This information helps us better understand the type of content that you plan to send.</p>', 'PutAccountDetailsRequest$WebsiteURL' => '<p>The URL of your website. This information helps us better understand the type of content that you plan to send.</p>', ], ], ],];
