<?php
// This file was auto-generated from sdk-root/src/data/securityhub/2018-10-26/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Security Hub provides you with a comprehensive view of the security state of your AWS environment and resources. It also provides you with the readiness status of your environment based on controls from supported security standards. Security Hub collects security data from AWS accounts, services, and integrated third-party products and helps you analyze security trends in your environment to identify the highest priority security issues. For more information about Security Hub, see the <i> <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/what-is-securityhub.html">AWS Security Hub User Guide</a> </i>.</p> <p>When you use operations in the Security Hub API, the requests are executed only in the AWS Region that is currently active or in the specific AWS Region that you specify in your request. Any configuration or settings change that results from the operation is applied only to that Region. To make the same change in other Regions, execute the same command for each Region to apply the change to.</p> <p>For example, if your Region is set to <code>us-west-2</code>, when you use <code> <a>CreateMembers</a> </code> to add a member account to Security Hub, the association of the member account with the master account is created only in the <code>us-west-2</code> Region. Security Hub must be enabled for the member account in the same Region that the invitation was sent from.</p> <p>The following throttling limits apply to using Security Hub API operations.</p> <ul> <li> <p> <code> <a>GetFindings</a> </code> - <code>RateLimit</code> of 3 requests per second. <code>BurstLimit</code> of 6 requests per second.</p> </li> <li> <p> <code> <a>UpdateFindings</a> </code> - <code>RateLimit</code> of 1 request per second. <code>BurstLimit</code> of 5 requests per second.</p> </li> <li> <p>All other operations - <code>RateLimit</code> of 10 requests per second. <code>BurstLimit</code> of 30 requests per second.</p> </li> </ul>', 'operations' => [ 'AcceptInvitation' => '<p>Accepts the invitation to be a member account and be monitored by the Security Hub master account that the invitation was sent from.</p> <p>When the member account accepts the invitation, permission is granted to the master account to view findings generated in the member account.</p>', 'BatchDisableStandards' => '<p>Disables the standards specified by the provided <code>StandardsSubscriptionArns</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html">Security Standards</a> section of the <i>AWS Security Hub User Guide</i>.</p>', 'BatchEnableStandards' => '<p>Enables the standards specified by the provided <code>StandardsArn</code>. To obtain the ARN for a standard, use the <code> <a>DescribeStandards</a> </code> operation.</p> <p>For more information, see the <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html">Security Standards</a> section of the <i>AWS Security Hub User Guide</i>.</p>', 'BatchImportFindings' => '<p>Imports security findings generated from an integrated third-party product into Security Hub. This action is requested by the integrated product to import its findings into Security Hub.</p> <p>The maximum allowed size for a finding is 240 Kb. An error is returned for any finding larger than 240 Kb.</p> <p>After a finding is created, <code>BatchImportFindings</code> cannot be used to update the following finding fields and objects, which Security Hub customers use to manage their investigation workflow.</p> <ul> <li> <p> <code>Confidence</code> </p> </li> <li> <p> <code>Criticality</code> </p> </li> <li> <p> <code>Note</code> </p> </li> <li> <p> <code>RelatedFindings</code> </p> </li> <li> <p> <code>Severity</code> </p> </li> <li> <p> <code>Types</code> </p> </li> <li> <p> <code>UserDefinedFields</code> </p> </li> <li> <p> <code>VerificationState</code> </p> </li> <li> <p> <code>Workflow</code> </p> </li> </ul>', 'BatchUpdateFindings' => '<p>Used by Security Hub customers to update information about their investigation into a finding. Requested by master accounts or member accounts. Master accounts can update findings for their account and their member accounts. Member accounts can update findings for their account.</p> <p>Updates from <code>BatchUpdateFindings</code> do not affect the value of <code>UpdatedAt</code> for a finding.</p> <p>Master accounts can use <code>BatchUpdateFindings</code> to update the following finding fields and objects.</p> <ul> <li> <p> <code>Confidence</code> </p> </li> <li> <p> <code>Criticality</code> </p> </li> <li> <p> <code>Note</code> </p> </li> <li> <p> <code>RelatedFindings</code> </p> </li> <li> <p> <code>Severity</code> </p> </li> <li> <p> <code>Types</code> </p> </li> <li> <p> <code>UserDefinedFields</code> </p> </li> <li> <p> <code>VerificationState</code> </p> </li> <li> <p> <code>Workflow</code> </p> </li> </ul> <p>Member accounts can only use <code>BatchUpdateFindings</code> to update the Note object.</p>', 'CreateActionTarget' => '<p>Creates a custom action target in Security Hub.</p> <p>You can use custom actions on findings and insights in Security Hub to trigger target actions in Amazon CloudWatch Events.</p>', 'CreateInsight' => '<p>Creates a custom insight in Security Hub. An insight is a consolidation of findings that relate to a security issue that requires attention or remediation.</p> <p>To group the related findings in the insight, use the <code>GroupByAttribute</code>.</p>', 'CreateMembers' => '<p>Creates a member association in Security Hub between the specified accounts and the account used to make the request, which is the master account. To successfully create a member, you must use this action from an account that already has Security Hub enabled. To enable Security Hub, you can use the <code> <a>EnableSecurityHub</a> </code> operation.</p> <p>After you use <code>CreateMembers</code> to create member account associations in Security Hub, you must use the <code> <a>InviteMembers</a> </code> operation to invite the accounts to enable Security Hub and become member accounts in Security Hub.</p> <p>If the account owner accepts the invitation, the account becomes a member account in Security Hub. A permissions policy is added that permits the master account to view the findings generated in the member account. When Security Hub is enabled in the invited account, findings start to be sent to both the member and master accounts.</p> <p>To remove the association between the master and member accounts, use the <code> <a>DisassociateFromMasterAccount</a> </code> or <code> <a>DisassociateMembers</a> </code> operation.</p>', 'DeclineInvitations' => '<p>Declines invitations to become a member account.</p>', 'DeleteActionTarget' => '<p>Deletes a custom action target from Security Hub.</p> <p>Deleting a custom action target does not affect any findings or insights that were already sent to Amazon CloudWatch Events using the custom action.</p>', 'DeleteInsight' => '<p>Deletes the insight specified by the <code>InsightArn</code>.</p>', 'DeleteInvitations' => '<p>Deletes invitations received by the AWS account to become a member account.</p>', 'DeleteMembers' => '<p>Deletes the specified member accounts from Security Hub.</p>', 'DescribeActionTargets' => '<p>Returns a list of the custom action targets in Security Hub in your account.</p>', 'DescribeHub' => '<p>Returns details about the Hub resource in your account, including the <code>HubArn</code> and the time when you enabled Security Hub.</p>', 'DescribeProducts' => '<p>Returns information about the available products that you can subscribe to and integrate with Security Hub in order to consolidate findings.</p>', 'DescribeStandards' => '<p>Returns a list of the available standards in Security Hub.</p> <p>For each standard, the results include the standard ARN, the name, and a description. </p>', 'DescribeStandardsControls' => '<p>Returns a list of security standards controls.</p> <p>For each control, the results include information about whether it is currently enabled, the severity, and a link to remediation information.</p>', 'DisableImportFindingsForProduct' => '<p>Disables the integration of the specified product with Security Hub. After the integration is disabled, findings from that product are no longer sent to Security Hub.</p>', 'DisableSecurityHub' => '<p>Disables Security Hub in your account only in the current Region. To disable Security Hub in all Regions, you must submit one request per Region where you have enabled Security Hub.</p> <p>When you disable Security Hub for a master account, it doesn\'t disable Security Hub for any associated member accounts.</p> <p>When you disable Security Hub, your existing findings and insights and any Security Hub configuration settings are deleted after 90 days and cannot be recovered. Any standards that were enabled are disabled, and your master and member account associations are removed.</p> <p>If you want to save your existing findings, you must export them before you disable Security Hub.</p>', 'DisassociateFromMasterAccount' => '<p>Disassociates the current Security Hub member account from the associated master account.</p>', 'DisassociateMembers' => '<p>Disassociates the specified member accounts from the associated master account.</p>', 'EnableImportFindingsForProduct' => '<p>Enables the integration of a partner product with Security Hub. Integrated products send findings to Security Hub.</p> <p>When you enable a product integration, a permissions policy that grants permission for the product to send findings to Security Hub is applied.</p>', 'EnableSecurityHub' => '<p>Enables Security Hub for your account in the current Region or the Region you specify in the request.</p> <p>When you enable Security Hub, you grant to Security Hub the permissions necessary to gather findings from other services that are integrated with Security Hub.</p> <p>When you use the <code>EnableSecurityHub</code> operation to enable Security Hub, you also automatically enable the following standards.</p> <ul> <li> <p>CIS AWS Foundations</p> </li> <li> <p>AWS Foundational Security Best Practices</p> </li> </ul> <p>You do not enable the Payment Card Industry Data Security Standard (PCI DSS) standard. </p> <p>To not enable the automatically enabled standards, set <code>EnableDefaultStandards</code> to <code>false</code>.</p> <p>After you enable Security Hub, to enable a standard, use the <code> <a>BatchEnableStandards</a> </code> operation. To disable a standard, use the <code> <a>BatchDisableStandards</a> </code> operation.</p> <p>To learn more, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-settingup.html">Setting Up AWS Security Hub</a> in the <i>AWS Security Hub User Guide</i>.</p>', 'GetEnabledStandards' => '<p>Returns a list of the standards that are currently enabled.</p>', 'GetFindings' => '<p>Returns a list of findings that match the specified criteria.</p>', 'GetInsightResults' => '<p>Lists the results of the Security Hub insight specified by the insight ARN.</p>', 'GetInsights' => '<p>Lists and describes insights for the specified insight ARNs.</p>', 'GetInvitationsCount' => '<p>Returns the count of all Security Hub membership invitations that were sent to the current member account, not including the currently accepted invitation. </p>', 'GetMasterAccount' => '<p>Provides the details for the Security Hub master account for the current member account. </p>', 'GetMembers' => '<p>Returns the details for the Security Hub member accounts for the specified account IDs.</p>', 'InviteMembers' => '<p>Invites other AWS accounts to become member accounts for the Security Hub master account that the invitation is sent from.</p> <p>Before you can use this action to invite a member, you must first use the <code> <a>CreateMembers</a> </code> action to create the member account in Security Hub.</p> <p>When the account owner accepts the invitation to become a member account and enables Security Hub, the master account can view the findings generated from the member account.</p>', 'ListEnabledProductsForImport' => '<p>Lists all findings-generating solutions (products) that you are subscribed to receive findings from in Security Hub.</p>', 'ListInvitations' => '<p>Lists all Security Hub membership invitations that were sent to the current AWS account. </p>', 'ListMembers' => '<p>Lists details about all member accounts for the current Security Hub master account.</p>', 'ListTagsForResource' => '<p>Returns a list of tags associated with a resource.</p>', 'TagResource' => '<p>Adds one or more tags to a resource.</p>', 'UntagResource' => '<p>Removes one or more tags from a resource.</p>', 'UpdateActionTarget' => '<p>Updates the name and description of a custom action target in Security Hub.</p>', 'UpdateFindings' => '<p> <code>UpdateFindings</code> is deprecated. Instead of <code>UpdateFindings</code>, use <code>BatchUpdateFindings</code>.</p> <p>Updates the <code>Note</code> and <code>RecordState</code> of the Security Hub-aggregated findings that the filter attributes specify. Any member account that can view the finding also sees the update to the finding.</p>', 'UpdateInsight' => '<p>Updates the Security Hub insight identified by the specified insight ARN.</p>', 'UpdateSecurityHubConfiguration' => '<p>Updates configuration options for Security Hub.</p>', 'UpdateStandardsControl' => '<p>Used to control whether an individual security standard control is enabled or disabled.</p>', ], 'shapes' => [ 'AcceptInvitationRequest' => [ 'base' => NULL, 'refs' => [], ], 'AcceptInvitationResponse' => [ 'base' => NULL, 'refs' => [], ], 'AccessDeniedException' => [ 'base' => '<p>You don\'t have permission to perform the action specified in the request.</p>', 'refs' => [], ], 'AccountDetails' => [ 'base' => '<p>The details of an AWS account.</p>', 'refs' => [ 'AccountDetailsList$member' => NULL, ], ], 'AccountDetailsList' => [ 'base' => NULL, 'refs' => [ 'CreateMembersRequest$AccountDetails' => '<p>The list of accounts to associate with the Security Hub master account. For each account, the list includes the account ID and the email address.</p>', ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'AccountDetails$AccountId' => '<p>The ID of an AWS account.</p>', 'Invitation$AccountId' => '<p>The account ID of the Security Hub master account that the invitation was sent from.</p>', 'Member$AccountId' => '<p>The AWS account ID of the member account.</p>', 'Result$AccountId' => '<p>An AWS account ID of the account that was not processed.</p>', ], ], 'AccountIdList' => [ 'base' => NULL, 'refs' => [ 'DeclineInvitationsRequest$AccountIds' => '<p>The list of account IDs for the accounts from which to decline the invitations to Security Hub.</p>', 'DeleteInvitationsRequest$AccountIds' => '<p>The list of the account IDs that sent the invitations to delete.</p>', 'DeleteMembersRequest$AccountIds' => '<p>The list of account IDs for the member accounts to delete.</p>', 'DisassociateMembersRequest$AccountIds' => '<p>The account IDs of the member accounts to disassociate from the master account.</p>', 'GetMembersRequest$AccountIds' => '<p>The list of account IDs for the Security Hub member accounts to return the details for. </p>', 'InviteMembersRequest$AccountIds' => '<p>The list of account IDs of the AWS accounts to invite to Security Hub as members. </p>', ], ], 'ActionTarget' => [ 'base' => '<p>An <code>ActionTarget</code> object.</p>', 'refs' => [ 'ActionTargetList$member' => NULL, ], ], 'ActionTargetList' => [ 'base' => NULL, 'refs' => [ 'DescribeActionTargetsResponse$ActionTargets' => '<p>A list of <code>ActionTarget</code> objects. Each object includes the <code>ActionTargetArn</code>, <code>Description</code>, and <code>Name</code> of a custom action target available in Security Hub.</p>', ], ], 'ArnList' => [ 'base' => NULL, 'refs' => [ 'DescribeActionTargetsRequest$ActionTargetArns' => '<p>A list of custom action target ARNs for the custom action targets to retrieve.</p>', 'GetInsightsRequest$InsightArns' => '<p>The ARNs of the insights to describe. If you do not provide any insight ARNs, then <code>GetInsights</code> returns all of your custom insights. It does not return any managed insights.</p>', ], ], 'AvailabilityZone' => [ 'base' => '<p>Information about an Availability Zone.</p>', 'refs' => [ 'AvailabilityZones$member' => NULL, ], ], 'AvailabilityZones' => [ 'base' => NULL, 'refs' => [ 'AwsElbv2LoadBalancerDetails$AvailabilityZones' => '<p>The Availability Zones for the load balancer.</p>', ], ], 'AwsAutoScalingAutoScalingGroupDetails' => [ 'base' => '<p>Provides details about an auto scaling group.</p>', 'refs' => [ 'ResourceDetails$AwsAutoScalingAutoScalingGroup' => '<p>Details for an autoscaling group.</p>', ], ], 'AwsCloudFrontDistributionDetails' => [ 'base' => '<p>A distribution configuration.</p>', 'refs' => [ 'ResourceDetails$AwsCloudFrontDistribution' => '<p>Details about a CloudFront distribution.</p>', ], ], 'AwsCloudFrontDistributionLogging' => [ 'base' => '<p>A complex type that controls whether access logs are written for the distribution.</p>', 'refs' => [ 'AwsCloudFrontDistributionDetails$Logging' => '<p>A complex type that controls whether access logs are written for the distribution.</p>', ], ], 'AwsCloudFrontDistributionOriginItem' => [ 'base' => '<p>A complex type that describes the Amazon S3 bucket, HTTP server (for example, a web server), Amazon Elemental MediaStore, or other server from which CloudFront gets your files.</p>', 'refs' => [ 'AwsCloudFrontDistributionOriginItemList$member' => NULL, ], ], 'AwsCloudFrontDistributionOriginItemList' => [ 'base' => NULL, 'refs' => [ 'AwsCloudFrontDistributionOrigins$Items' => '<p>A complex type that contains origins or origin groups for this distribution.</p>', ], ], 'AwsCloudFrontDistributionOrigins' => [ 'base' => '<p>A complex type that contains information about origins and origin groups for this distribution.</p>', 'refs' => [ 'AwsCloudFrontDistributionDetails$Origins' => '<p>A complex type that contains information about origins for this distribution.</p>', ], ], 'AwsCodeBuildProjectDetails' => [ 'base' => '<p>Information about an AWS CodeBuild project.</p>', 'refs' => [ 'ResourceDetails$AwsCodeBuildProject' => '<p>Details for an AWS CodeBuild project.</p>', ], ], 'AwsCodeBuildProjectEnvironment' => [ 'base' => '<p>Information about the build environment for this build project.</p>', 'refs' => [ 'AwsCodeBuildProjectDetails$Environment' => '<p>Information about the build environment for this build project.</p>', ], ], 'AwsCodeBuildProjectEnvironmentRegistryCredential' => [ 'base' => '<p>The credentials for access to a private registry.</p>', 'refs' => [ 'AwsCodeBuildProjectEnvironment$RegistryCredential' => '<p>The credentials for access to a private registry.</p>', ], ], 'AwsCodeBuildProjectSource' => [ 'base' => '<p>Information about the build input source code for this build project.</p>', 'refs' => [ 'AwsCodeBuildProjectDetails$Source' => '<p>Information about the build input source code for this build project.</p>', ], ], 'AwsCodeBuildProjectVpcConfig' => [ 'base' => '<p>Information about the VPC configuration that AWS CodeBuild accesses.</p>', 'refs' => [ 'AwsCodeBuildProjectDetails$VpcConfig' => '<p>Information about the VPC configuration that AWS CodeBuild accesses.</p>', ], ], 'AwsEc2InstanceDetails' => [ 'base' => '<p>The details of an Amazon EC2 instance.</p>', 'refs' => [ 'ResourceDetails$AwsEc2Instance' => '<p>Details about an Amazon EC2 instance related to a finding.</p>', ], ], 'AwsEc2NetworkInterfaceAttachment' => [ 'base' => '<p>Information about the network interface attachment.</p>', 'refs' => [ 'AwsEc2NetworkInterfaceDetails$Attachment' => '<p>The network interface attachment.</p>', ], ], 'AwsEc2NetworkInterfaceDetails' => [ 'base' => '<p>Details about the network interface</p>', 'refs' => [ 'ResourceDetails$AwsEc2NetworkInterface' => '<p>Details for an Amazon EC2 network interface.</p>', ], ], 'AwsEc2NetworkInterfaceSecurityGroup' => [ 'base' => '<p>A security group associated with the network interface.</p>', 'refs' => [ 'AwsEc2NetworkInterfaceSecurityGroupList$member' => NULL, ], ], 'AwsEc2NetworkInterfaceSecurityGroupList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2NetworkInterfaceDetails$SecurityGroups' => '<p>Security groups for the network interface.</p>', ], ], 'AwsEc2SecurityGroupDetails' => [ 'base' => '<p>Details about an EC2 security group.</p>', 'refs' => [ 'ResourceDetails$AwsEc2SecurityGroup' => '<p>Details for an EC2 security group.</p>', ], ], 'AwsEc2SecurityGroupIpPermission' => [ 'base' => '<p>An IP permission for an EC2 security group.</p>', 'refs' => [ 'AwsEc2SecurityGroupIpPermissionList$member' => NULL, ], ], 'AwsEc2SecurityGroupIpPermissionList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2SecurityGroupDetails$IpPermissions' => '<p>The inbound rules associated with the security group.</p>', 'AwsEc2SecurityGroupDetails$IpPermissionsEgress' => '<p>[VPC only] The outbound rules associated with the security group.</p>', ], ], 'AwsEc2SecurityGroupIpRange' => [ 'base' => '<p>A range of IPv4 addresses.</p>', 'refs' => [ 'AwsEc2SecurityGroupIpRangeList$member' => NULL, ], ], 'AwsEc2SecurityGroupIpRangeList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2SecurityGroupIpPermission$IpRanges' => '<p>The IPv4 ranges.</p>', ], ], 'AwsEc2SecurityGroupIpv6Range' => [ 'base' => '<p>A range of IPv6 addresses.</p>', 'refs' => [ 'AwsEc2SecurityGroupIpv6RangeList$member' => NULL, ], ], 'AwsEc2SecurityGroupIpv6RangeList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2SecurityGroupIpPermission$Ipv6Ranges' => '<p>The IPv6 ranges.</p>', ], ], 'AwsEc2SecurityGroupPrefixListId' => [ 'base' => '<p>A prefix list ID.</p>', 'refs' => [ 'AwsEc2SecurityGroupPrefixListIdList$member' => NULL, ], ], 'AwsEc2SecurityGroupPrefixListIdList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2SecurityGroupIpPermission$PrefixListIds' => '<p>[VPC only] The prefix list IDs for an AWS service. With outbound rules, this is the AWS service to access through a VPC endpoint from instances associated with the security group.</p>', ], ], 'AwsEc2SecurityGroupUserIdGroupPair' => [ 'base' => '<p>A relationship between a security group and a user.</p>', 'refs' => [ 'AwsEc2SecurityGroupUserIdGroupPairList$member' => NULL, ], ], 'AwsEc2SecurityGroupUserIdGroupPairList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2SecurityGroupIpPermission$UserIdGroupPairs' => '<p>The security group and AWS account ID pairs.</p>', ], ], 'AwsEc2VolumeAttachment' => [ 'base' => '<p>An attachment to an AWS EC2 volume.</p>', 'refs' => [ 'AwsEc2VolumeAttachmentList$member' => NULL, ], ], 'AwsEc2VolumeAttachmentList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2VolumeDetails$Attachments' => '<p>The volume attachments.</p>', ], ], 'AwsEc2VolumeDetails' => [ 'base' => '<p>Details about an EC2 volume.</p>', 'refs' => [ 'ResourceDetails$AwsEc2Volume' => '<p>Details for an EC2 volume.</p>', ], ], 'AwsEc2VpcDetails' => [ 'base' => '<p>Details about an EC2 VPC.</p>', 'refs' => [ 'ResourceDetails$AwsEc2Vpc' => '<p>Details for an EC2 VPC.</p>', ], ], 'AwsElasticsearchDomainDetails' => [ 'base' => '<p>Information about an Elasticsearch domain.</p>', 'refs' => [ 'ResourceDetails$AwsElasticsearchDomain' => '<p>Details for an Elasticsearch domain.</p>', ], ], 'AwsElasticsearchDomainDomainEndpointOptions' => [ 'base' => '<p>Additional options for the domain endpoint, such as whether to require HTTPS for all traffic.</p>', 'refs' => [ 'AwsElasticsearchDomainDetails$DomainEndpointOptions' => '<p>Additional options for the domain endpoint.</p>', ], ], 'AwsElasticsearchDomainEncryptionAtRestOptions' => [ 'base' => '<p>Details about the configuration for encryption at rest.</p>', 'refs' => [ 'AwsElasticsearchDomainDetails$EncryptionAtRestOptions' => '<p>Details about the configuration for encryption at rest.</p>', ], ], 'AwsElasticsearchDomainNodeToNodeEncryptionOptions' => [ 'base' => '<p>Details about the configuration for node-to-node encryption.</p>', 'refs' => [ 'AwsElasticsearchDomainDetails$NodeToNodeEncryptionOptions' => '<p>Details about the configuration for node-to-node encryption.</p>', ], ], 'AwsElasticsearchDomainVPCOptions' => [ 'base' => '<p>Information that Amazon ES derives based on <code>VPCOptions</code> for the domain.</p>', 'refs' => [ 'AwsElasticsearchDomainDetails$VPCOptions' => '<p>Information that Amazon ES derives based on <code>VPCOptions</code> for the domain.</p>', ], ], 'AwsElbv2LoadBalancerDetails' => [ 'base' => '<p>Information about a load balancer.</p>', 'refs' => [ 'ResourceDetails$AwsElbv2LoadBalancer' => '<p>Details about a load balancer.</p>', ], ], 'AwsIamAccessKeyDetails' => [ 'base' => '<p>IAM access key details related to a finding.</p>', 'refs' => [ 'ResourceDetails$AwsIamAccessKey' => '<p>Details about an IAM access key related to a finding.</p>', ], ], 'AwsIamAccessKeyStatus' => [ 'base' => NULL, 'refs' => [ 'AwsIamAccessKeyDetails$Status' => '<p>The status of the IAM access key related to a finding.</p>', ], ], 'AwsIamRoleAssumeRolePolicyDocument' => [ 'base' => NULL, 'refs' => [ 'AwsIamRoleDetails$AssumeRolePolicyDocument' => '<p>The trust policy that grants permission to assume the role.</p>', ], ], 'AwsIamRoleDetails' => [ 'base' => '<p>Contains information about an IAM role, including all of the role\'s policies.</p>', 'refs' => [ 'ResourceDetails$AwsIamRole' => '<p>Details about an IAM role.</p>', ], ], 'AwsKmsKeyDetails' => [ 'base' => '<p>Contains metadata about a customer master key (CMK).</p>', 'refs' => [ 'ResourceDetails$AwsKmsKey' => '<p>Details about a KMS key.</p>', ], ], 'AwsLambdaFunctionCode' => [ 'base' => '<p>The code for the Lambda function. You can specify either an object in Amazon S3, or upload a deployment package directly.</p>', 'refs' => [ 'AwsLambdaFunctionDetails$Code' => '<p>An <code>AwsLambdaFunctionCode</code> object.</p>', ], ], 'AwsLambdaFunctionDeadLetterConfig' => [ 'base' => '<p>The dead-letter queue for failed asynchronous invocations.</p>', 'refs' => [ 'AwsLambdaFunctionDetails$DeadLetterConfig' => '<p>The function\'s dead letter queue.</p>', ], ], 'AwsLambdaFunctionDetails' => [ 'base' => '<p>Details about a function\'s configuration.</p>', 'refs' => [ 'ResourceDetails$AwsLambdaFunction' => '<p>Details about a Lambda function.</p>', ], ], 'AwsLambdaFunctionEnvironment' => [ 'base' => '<p>A function\'s environment variable settings.</p>', 'refs' => [ 'AwsLambdaFunctionDetails$Environment' => '<p>The function\'s environment variables.</p>', ], ], 'AwsLambdaFunctionEnvironmentError' => [ 'base' => '<p>Error messages for environment variables that couldn\'t be applied.</p>', 'refs' => [ 'AwsLambdaFunctionEnvironment$Error' => '<p>An <code>AwsLambdaFunctionEnvironmentError</code> object.</p>', ], ], 'AwsLambdaFunctionLayer' => [ 'base' => '<p>An AWS Lambda layer.</p>', 'refs' => [ 'AwsLambdaFunctionLayerList$member' => NULL, ], ], 'AwsLambdaFunctionLayerList' => [ 'base' => NULL, 'refs' => [ 'AwsLambdaFunctionDetails$Layers' => '<p>The function\'s layers.</p>', ], ], 'AwsLambdaFunctionTracingConfig' => [ 'base' => '<p>The function\'s AWS X-Ray tracing configuration.</p>', 'refs' => [ 'AwsLambdaFunctionDetails$TracingConfig' => '<p>The function\'s AWS X-Ray tracing configuration.</p>', ], ], 'AwsLambdaFunctionVpcConfig' => [ 'base' => '<p>The VPC security groups and subnets that are attached to a Lambda function. For more information, see VPC Settings.</p>', 'refs' => [ 'AwsLambdaFunctionDetails$VpcConfig' => '<p>The function\'s networking configuration.</p>', ], ], 'AwsLambdaLayerVersionDetails' => [ 'base' => '<p>Details about a Lambda layer version.</p>', 'refs' => [ 'ResourceDetails$AwsLambdaLayerVersion' => '<p>Details for a Lambda layer version.</p>', ], ], 'AwsLambdaLayerVersionNumber' => [ 'base' => NULL, 'refs' => [ 'AwsLambdaLayerVersionDetails$Version' => '<p>The version number.</p>', ], ], 'AwsRdsDbInstanceAssociatedRole' => [ 'base' => '<p>An AWS Identity and Access Management (IAM) role associated with the DB instance.</p>', 'refs' => [ 'AwsRdsDbInstanceAssociatedRoles$member' => NULL, ], ], 'AwsRdsDbInstanceAssociatedRoles' => [ 'base' => NULL, 'refs' => [ 'AwsRdsDbInstanceDetails$AssociatedRoles' => '<p>The AWS Identity and Access Management (IAM) roles associated with the DB instance.</p>', ], ], 'AwsRdsDbInstanceDetails' => [ 'base' => '<p>Contains the details of an Amazon RDS DB instance.</p>', 'refs' => [ 'ResourceDetails$AwsRdsDbInstance' => '<p>Details for an Amazon RDS database instance.</p>', ], ], 'AwsRdsDbInstanceEndpoint' => [ 'base' => '<p>Specifies the connection endpoint.</p>', 'refs' => [ 'AwsRdsDbInstanceDetails$Endpoint' => '<p>Specifies the connection endpoint.</p>', ], ], 'AwsRdsDbInstanceVpcSecurityGroup' => [ 'base' => '<p>A VPC security groups that the DB instance belongs to.</p>', 'refs' => [ 'AwsRdsDbInstanceVpcSecurityGroups$member' => NULL, ], ], 'AwsRdsDbInstanceVpcSecurityGroups' => [ 'base' => NULL, 'refs' => [ 'AwsRdsDbInstanceDetails$VpcSecurityGroups' => '<p>A list of VPC security groups that the DB instance belongs to.</p>', ], ], 'AwsS3BucketDetails' => [ 'base' => '<p>The details of an Amazon S3 bucket.</p>', 'refs' => [ 'ResourceDetails$AwsS3Bucket' => '<p>Details about an Amazon S3 bucket related to a finding.</p>', ], ], 'AwsS3BucketServerSideEncryptionByDefault' => [ 'base' => '<p>Specifies the default server-side encryption to apply to new objects in the bucket.</p>', 'refs' => [ 'AwsS3BucketServerSideEncryptionRule$ApplyServerSideEncryptionByDefault' => '<p>Specifies the default server-side encryption to apply to new objects in the bucket. If a <code>PUT</code> object request doesn\'t specify any server-side encryption, this default encryption is applied.</p>', ], ], 'AwsS3BucketServerSideEncryptionConfiguration' => [ 'base' => '<p>The encryption configuration for the S3 bucket.</p>', 'refs' => [ 'AwsS3BucketDetails$ServerSideEncryptionConfiguration' => '<p>The encryption rules that are applied to the S3 bucket.</p>', ], ], 'AwsS3BucketServerSideEncryptionRule' => [ 'base' => '<p>An encryption rule to apply to the S3 bucket.</p>', 'refs' => [ 'AwsS3BucketServerSideEncryptionRules$member' => NULL, ], ], 'AwsS3BucketServerSideEncryptionRules' => [ 'base' => NULL, 'refs' => [ 'AwsS3BucketServerSideEncryptionConfiguration$Rules' => '<p>The encryption rules that are applied to the S3 bucket.</p>', ], ], 'AwsS3ObjectDetails' => [ 'base' => '<p>Details about an Amazon S3 object.</p>', 'refs' => [ 'ResourceDetails$AwsS3Object' => '<p>Details about an Amazon S3 object related to a finding.</p>', ], ], 'AwsSecurityFinding' => [ 'base' => '<p>Provides consistent format for the contents of the Security Hub-aggregated findings. <code>AwsSecurityFinding</code> format enables you to share findings between AWS security services and third-party solutions, and security standards checks.</p> <note> <p>A finding is a potential security issue generated either by AWS services (Amazon GuardDuty, Amazon Inspector, and Amazon Macie) or by the integrated third-party solutions and standards checks.</p> </note>', 'refs' => [ 'AwsSecurityFindingList$member' => NULL, ], ], 'AwsSecurityFindingFilters' => [ 'base' => '<p>A collection of attributes that are applied to all active Security Hub-aggregated findings and that result in a subset of findings that are included in this insight.</p>', 'refs' => [ 'CreateInsightRequest$Filters' => '<p>One or more attributes used to filter the findings included in the insight. The insight only includes findings that match the criteria defined in the filters.</p>', 'GetFindingsRequest$Filters' => '<p>The finding attributes used to define a condition to filter the returned findings.</p> <p>Note that in the available filter fields, <code>WorkflowState</code> is deprecated. To search for a finding based on its workflow status, use <code>WorkflowStatus</code>.</p>', 'Insight$Filters' => '<p>One or more attributes used to filter the findings included in the insight. The insight only includes findings that match the criteria defined in the filters.</p>', 'UpdateFindingsRequest$Filters' => '<p>A collection of attributes that specify which findings you want to update.</p>', 'UpdateInsightRequest$Filters' => '<p>The updated filters that define this insight.</p>', ], ], 'AwsSecurityFindingIdentifier' => [ 'base' => '<p>Identifies a finding to update using <code>BatchUpdateFindings</code>.</p>', 'refs' => [ 'AwsSecurityFindingIdentifierList$member' => NULL, 'BatchUpdateFindingsUnprocessedFinding$FindingIdentifier' => '<p>The identifier of the finding that was not updated.</p>', ], ], 'AwsSecurityFindingIdentifierList' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateFindingsRequest$FindingIdentifiers' => '<p>The list of findings to update. <code>BatchUpdateFindings</code> can be used to update up to 100 findings at a time.</p> <p>For each finding, the list provides the finding identifier and the ARN of the finding provider.</p>', 'BatchUpdateFindingsResponse$ProcessedFindings' => '<p>The list of findings that were updated successfully.</p>', ], ], 'AwsSecurityFindingList' => [ 'base' => NULL, 'refs' => [ 'BatchImportFindingsRequest$Findings' => '<p>A list of findings to import. To successfully import a finding, it must follow the <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html">AWS Security Finding Format</a>. Maximum of 100 findings per request.</p>', 'GetFindingsResponse$Findings' => '<p>The findings that matched the filters specified in the request.</p>', ], ], 'AwsSnsTopicDetails' => [ 'base' => '<p>A wrapper type for the topic\'s Amazon Resource Name (ARN).</p>', 'refs' => [ 'ResourceDetails$AwsSnsTopic' => '<p>Details about an SNS topic.</p>', ], ], 'AwsSnsTopicSubscription' => [ 'base' => '<p>A wrapper type for the attributes of an Amazon SNS subscription.</p>', 'refs' => [ 'AwsSnsTopicSubscriptionList$member' => NULL, ], ], 'AwsSnsTopicSubscriptionList' => [ 'base' => NULL, 'refs' => [ 'AwsSnsTopicDetails$Subscription' => '<p>Subscription is an embedded property that describes the subscription endpoints of an Amazon SNS topic.</p>', ], ], 'AwsSqsQueueDetails' => [ 'base' => '<p>Data about a queue.</p>', 'refs' => [ 'ResourceDetails$AwsSqsQueue' => '<p>Details about an SQS queue.</p>', ], ], 'AwsWafWebAclDetails' => [ 'base' => '<p>Details about a WAF WebACL.</p>', 'refs' => [ 'ResourceDetails$AwsWafWebAcl' => '<p>Details for a WAF WebACL.</p>', ], ], 'AwsWafWebAclRule' => [ 'base' => '<p>Details for a rule in a WAF WebACL.</p>', 'refs' => [ 'AwsWafWebAclRuleList$member' => NULL, ], ], 'AwsWafWebAclRuleList' => [ 'base' => NULL, 'refs' => [ 'AwsWafWebAclDetails$Rules' => '<p>An array that contains the action for each rule in a WebACL, the priority of the rule, and the ID of the rule.</p>', ], ], 'BatchDisableStandardsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDisableStandardsResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchEnableStandardsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchEnableStandardsResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchImportFindingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchImportFindingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdateFindingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdateFindingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdateFindingsUnprocessedFinding' => [ 'base' => '<p>A finding from a <code>BatchUpdateFindings</code> request that Security Hub was unable to update.</p>', 'refs' => [ 'BatchUpdateFindingsUnprocessedFindingsList$member' => NULL, ], ], 'BatchUpdateFindingsUnprocessedFindingsList' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateFindingsResponse$UnprocessedFindings' => '<p>The list of findings that were not updated.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AwsCloudFrontDistributionLogging$Enabled' => '<p>With this field, you can enable or disable the selected distribution.</p>', 'AwsCloudFrontDistributionLogging$IncludeCookies' => '<p>Specifies whether you want CloudFront to include cookies in access logs.</p>', 'AwsCodeBuildProjectSource$InsecureSsl' => '<p>Whether to ignore SSL warnings while connecting to the project source code.</p>', 'AwsEc2NetworkInterfaceAttachment$DeleteOnTermination' => '<p>Indicates whether the network interface is deleted when the instance is terminated.</p>', 'AwsEc2NetworkInterfaceDetails$SourceDestCheck' => '<p>Indicates whether traffic to or from the instance is validated.</p>', 'AwsEc2VolumeAttachment$DeleteOnTermination' => '<p>Whether the EBS volume is deleted when the EC2 instance is terminated.</p>', 'AwsEc2VolumeDetails$Encrypted' => '<p>Whether the volume is encrypted.</p>', 'AwsElasticsearchDomainDomainEndpointOptions$EnforceHTTPS' => '<p>Whether to require that all traffic to the domain arrive over HTTPS.</p>', 'AwsElasticsearchDomainEncryptionAtRestOptions$Enabled' => '<p>Whether encryption at rest is enabled.</p>', 'AwsElasticsearchDomainNodeToNodeEncryptionOptions$Enabled' => '<p>Whether node-to-node encryption is enabled.</p>', 'AwsRdsDbInstanceDetails$DeletionProtection' => '<p>Indicates whether the DB instance has deletion protection enabled.</p> <p>When deletion protection is enabled, the database cannot be deleted.</p>', 'AwsRdsDbInstanceDetails$IAMDatabaseAuthenticationEnabled' => '<p>True if mapping of AWS Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.</p> <p>IAM database authentication can be enabled for the following database engines.</p> <ul> <li> <p>For MySQL 5.6, minor version 5.6.34 or higher</p> </li> <li> <p>For MySQL 5.7, minor version 5.7.16 or higher</p> </li> <li> <p>Aurora 5.6 or higher</p> </li> </ul>', 'AwsRdsDbInstanceDetails$PubliclyAccessible' => '<p>Specifies the accessibility options for the DB instance.</p> <p>A value of true specifies an Internet-facing instance with a publicly resolvable DNS name, which resolves to a public IP address.</p> <p>A value of false specifies an internal instance with a DNS name that resolves to a private IP address. </p>', 'AwsRdsDbInstanceDetails$StorageEncrypted' => '<p>Specifies whether the DB instance is encrypted.</p>', 'DescribeHubResponse$AutoEnableControls' => '<p>Whether to automatically enable new controls when they are added to standards that are enabled.</p> <p>If set to <code>true</code>, then new controls for enabled standards are enabled automatically. If set to <code>false</code>, then new controls are not enabled.</p>', 'EnableSecurityHubRequest$EnableDefaultStandards' => '<p>Whether to enable the security standards that Security Hub has designated as automatically enabled. If you do not provide a value for <code>EnableDefaultStandards</code>, it is set to <code>true</code>. To not enable the automatically enabled standards, set <code>EnableDefaultStandards</code> to <code>false</code>.</p>', 'ListMembersRequest$OnlyAssociated' => '<p>Specifies which member accounts to include in the response based on their relationship status with the master account. The default value is <code>TRUE</code>.</p> <p>If <code>OnlyAssociated</code> is set to <code>TRUE</code>, the response includes member accounts whose relationship status with the master is set to <code>ENABLED</code> or <code>DISABLED</code>.</p> <p>If <code>OnlyAssociated</code> is set to <code>FALSE</code>, the response includes all existing member accounts. </p>', 'Standard$EnabledByDefault' => '<p>Whether the standard is enabled by default. When Security Hub is enabled from the console, if a standard is enabled by default, the check box for that standard is selected by default.</p> <p>When Security Hub is enabled using the <code>EnableSecurityHub</code> API operation, the standard is enabled by default unless <code>EnableDefaultStandards</code> is set to <code>false</code>.</p>', 'UpdateSecurityHubConfigurationRequest$AutoEnableControls' => '<p>Whether to automatically enable new controls when they are added to standards that are enabled.</p> <p>By default, this is set to <code>true</code>, and new controls are enabled automatically. To not automatically enable new controls, set this to <code>false</code>. </p>', ], ], 'CategoryList' => [ 'base' => NULL, 'refs' => [ 'Product$Categories' => '<p>The categories assigned to the product.</p>', ], ], 'CidrBlockAssociation' => [ 'base' => '<p>An IPv4 CIDR block association.</p>', 'refs' => [ 'CidrBlockAssociationList$member' => NULL, ], ], 'CidrBlockAssociationList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2VpcDetails$CidrBlockAssociationSet' => '<p>Information about the IPv4 CIDR blocks associated with the VPC.</p>', ], ], 'Compliance' => [ 'base' => '<p>Contains finding details that are specific to control-based findings. Only returned for findings generated from controls.</p>', 'refs' => [ 'AwsSecurityFinding$Compliance' => '<p>This data type is exclusive to findings that are generated as the result of a check run against a specific rule in a supported security standard, such as CIS AWS Foundations. Contains security standard-related finding details.</p>', ], ], 'ComplianceStatus' => [ 'base' => NULL, 'refs' => [ 'Compliance$Status' => '<p>The result of a standards check.</p> <p>The valid values for <code>Status</code> are as follows.</p> <ul> <li> <ul> <li> <p> <code>PASSED</code> - Standards check passed for all evaluated resources.</p> </li> <li> <p> <code>WARNING</code> - Some information is missing or this check is not supported for your configuration.</p> </li> <li> <p> <code>FAILED</code> - Standards check failed for at least one evaluated resource.</p> </li> <li> <p> <code>NOT_AVAILABLE</code> - Check could not be performed due to a service outage, API error, or because the result of the AWS Config evaluation was <code>NOT_APPLICABLE</code>. If the AWS Config evaluation result was <code>NOT_APPLICABLE</code>, then after 3 days, Security Hub automatically archives the finding.</p> </li> </ul> </li> </ul>', ], ], 'ContainerDetails' => [ 'base' => '<p>Container details related to a finding.</p>', 'refs' => [ 'ResourceDetails$Container' => '<p>Details about a container resource related to a finding.</p>', ], ], 'ControlStatus' => [ 'base' => NULL, 'refs' => [ 'StandardsControl$ControlStatus' => '<p>The current status of the security standard control. Indicates whether the control is enabled or disabled. Security Hub does not check against disabled controls.</p>', 'UpdateStandardsControlRequest$ControlStatus' => '<p>The updated status of the security standard control.</p>', ], ], 'CreateActionTargetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateActionTargetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateInsightRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateInsightResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'Cvss' => [ 'base' => '<p>CVSS scores from the advisory related to the vulnerability.</p>', 'refs' => [ 'CvssList$member' => NULL, ], ], 'CvssList' => [ 'base' => NULL, 'refs' => [ 'Vulnerability$Cvss' => '<p>CVSS scores from the advisory related to the vulnerability.</p>', ], ], 'DateFilter' => [ 'base' => '<p>A date filter for querying findings.</p>', 'refs' => [ 'DateFilterList$member' => NULL, ], ], 'DateFilterList' => [ 'base' => NULL, 'refs' => [ 'AwsSecurityFindingFilters$FirstObservedAt' => '<p>An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the potential security issue that a finding captured.</p>', 'AwsSecurityFindingFilters$LastObservedAt' => '<p>An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed the potential security issue that a finding captured.</p>', 'AwsSecurityFindingFilters$CreatedAt' => '<p>An ISO8601-formatted timestamp that indicates when the security-findings provider captured the potential security issue that a finding captured.</p>', 'AwsSecurityFindingFilters$UpdatedAt' => '<p>An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the finding record. </p>', 'AwsSecurityFindingFilters$ProcessLaunchedAt' => '<p>The date/time that the process was launched.</p>', 'AwsSecurityFindingFilters$ProcessTerminatedAt' => '<p>The date/time that the process was terminated.</p>', 'AwsSecurityFindingFilters$ThreatIntelIndicatorLastObservedAt' => '<p>The date/time of the last observation of a threat intelligence indicator.</p>', 'AwsSecurityFindingFilters$ResourceAwsEc2InstanceLaunchedAt' => '<p>The date and time the instance was launched.</p>', 'AwsSecurityFindingFilters$ResourceAwsIamAccessKeyCreatedAt' => '<p>The creation date/time of the IAM access key related to a finding.</p>', 'AwsSecurityFindingFilters$ResourceContainerLaunchedAt' => '<p>The date/time that the container was started.</p>', 'AwsSecurityFindingFilters$NoteUpdatedAt' => '<p>The timestamp of when the note was updated.</p>', ], ], 'DateRange' => [ 'base' => '<p>A date range for the date filter.</p>', 'refs' => [ 'DateFilter$DateRange' => '<p>A date range for the date filter.</p>', ], ], 'DateRangeUnit' => [ 'base' => NULL, 'refs' => [ 'DateRange$Unit' => '<p>A date range unit for the date filter.</p>', ], ], 'DeclineInvitationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeclineInvitationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteActionTargetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteActionTargetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInsightRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInsightResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInvitationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInvitationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeActionTargetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeActionTargetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHubRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHubResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProductsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProductsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStandardsControlsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStandardsControlsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStandardsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStandardsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisableImportFindingsForProductRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableImportFindingsForProductResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisableSecurityHubRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableSecurityHubResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateFromMasterAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateFromMasterAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'AwsKmsKeyDetails$CreationDate' => '<p>The date and time when the CMK was created.</p>', 'Cvss$BaseScore' => '<p>The base CVSS score.</p>', 'NumberFilter$Gte' => '<p>The greater-than-equal condition to be applied to a single field when querying for findings. </p>', 'NumberFilter$Lte' => '<p>The less-than-equal condition to be applied to a single field when querying for findings. </p>', 'NumberFilter$Eq' => '<p>The equal-to condition to be applied to a single field when querying for findings.</p>', 'Severity$Product' => '<p>Deprecated. This attribute is being deprecated. Instead of providing <code>Product</code>, provide <code>Original</code>.</p> <p>The native severity as defined by the AWS service or integrated partner product that generated the finding.</p>', 'SeverityUpdate$Product' => '<p>The native severity as defined by the AWS service or integrated partner product that generated the finding.</p>', ], ], 'EnableImportFindingsForProductRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableImportFindingsForProductResponse' => [ 'base' => NULL, 'refs' => [], ], 'EnableSecurityHubRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableSecurityHubResponse' => [ 'base' => NULL, 'refs' => [], ], 'FieldMap' => [ 'base' => NULL, 'refs' => [ 'AwsElasticsearchDomainDetails$Endpoints' => '<p>The key-value pair that exists if the Amazon ES domain uses VPC endpoints.</p>', 'AwsLambdaFunctionEnvironment$Variables' => '<p>Environment variable key-value pairs.</p>', 'AwsSecurityFinding$ProductFields' => '<p>A data type where security-findings providers can include additional solution-specific details that aren\'t part of the defined <code>AwsSecurityFinding</code> format.</p>', 'AwsSecurityFinding$UserDefinedFields' => '<p>A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a finding. </p>', 'BatchUpdateFindingsRequest$UserDefinedFields' => '<p>A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a finding.</p>', 'Resource$Tags' => '<p>A list of AWS tags associated with a resource at the time the finding was processed.</p>', 'ResourceDetails$Other' => '<p>Details about a resource that are not available in a type-specific details object. Use the <code>Other</code> object in the following cases.</p> <ul> <li> <p>The type-specific object does not contain all of the fields that you want to populate. In this case, first use the type-specific object to populate those fields. Use the <code>Other</code> object to populate the fields that are missing from the type-specific object.</p> </li> <li> <p>The resource type does not have a corresponding object. This includes resources for which the type is <code>Other</code>. </p> </li> </ul>', ], ], 'GetEnabledStandardsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEnabledStandardsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFindingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFindingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetInsightResultsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInsightResultsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetInsightsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInsightsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetInvitationsCountRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInvitationsCountResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMasterAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMasterAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ImportFindingsError' => [ 'base' => '<p>The list of the findings that cannot be imported. For each finding, the list provides the error.</p>', 'refs' => [ 'ImportFindingsErrorList$member' => NULL, ], ], 'ImportFindingsErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchImportFindingsResponse$FailedFindings' => '<p>The list of findings that failed to import.</p>', ], ], 'Insight' => [ 'base' => '<p>Contains information about a Security Hub insight.</p>', 'refs' => [ 'InsightList$member' => NULL, ], ], 'InsightList' => [ 'base' => NULL, 'refs' => [ 'GetInsightsResponse$Insights' => '<p>The insights returned by the operation.</p>', ], ], 'InsightResultValue' => [ 'base' => '<p>The insight result values returned by the <code>GetInsightResults</code> operation.</p>', 'refs' => [ 'InsightResultValueList$member' => NULL, ], ], 'InsightResultValueList' => [ 'base' => NULL, 'refs' => [ 'InsightResults$ResultValues' => '<p>The list of insight result values returned by the <code>GetInsightResults</code> operation.</p>', ], ], 'InsightResults' => [ 'base' => '<p>The insight results returned by the <code>GetInsightResults</code> operation.</p>', 'refs' => [ 'GetInsightResultsResponse$InsightResults' => '<p>The insight results returned by the operation.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'AwsAutoScalingAutoScalingGroupDetails$HealthCheckGracePeriod' => '<p>The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before it checks the health status of an EC2 instance that has come into service.</p>', 'AwsCodeBuildProjectSource$GitCloneDepth' => '<p>Information about the Git clone depth for the build project.</p>', 'AwsEc2NetworkInterfaceAttachment$DeviceIndex' => '<p>The device index of the network interface attachment on the instance.</p>', 'AwsEc2SecurityGroupIpPermission$FromPort' => '<p>The start of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number.</p> <p>A value of -1 indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must specify all codes. </p>', 'AwsEc2SecurityGroupIpPermission$ToPort' => '<p>The end of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.</p> <p>A value of -1 indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must specify all codes.</p>', 'AwsEc2VolumeDetails$Size' => '<p>The size of the volume, in GiBs.</p>', 'AwsIamRoleDetails$MaxSessionDuration' => '<p>The maximum session duration (in seconds) that you want to set for the specified role.</p>', 'AwsLambdaFunctionDetails$MemorySize' => '<p>The memory that\'s allocated to the function.</p>', 'AwsLambdaFunctionDetails$Timeout' => '<p>The amount of time that Lambda allows a function to run before stopping it.</p>', 'AwsLambdaFunctionLayer$CodeSize' => '<p>The size of the layer archive in bytes.</p>', 'AwsRdsDbInstanceDetails$DbInstancePort' => '<p>Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can be a different port than the DB cluster port.</p>', 'AwsRdsDbInstanceEndpoint$Port' => '<p>Specifies the port that the database engine is listening on.</p>', 'AwsSecurityFinding$Confidence' => '<p>A finding\'s confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.</p> <p>Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.</p>', 'AwsSecurityFinding$Criticality' => '<p>The level of importance assigned to the resources associated with the finding.</p> <p>A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.</p>', 'AwsSqsQueueDetails$KmsDataKeyReusePeriodSeconds' => '<p>The length of time, in seconds, for which Amazon SQS can reuse a data key to encrypt or decrypt messages before calling AWS KMS again.</p>', 'AwsWafWebAclRule$Priority' => '<p>Specifies the order in which the rules in a WebACL are evaluated. Rules with a lower value for <code>Priority</code> are evaluated before rules with a higher value. The value must be a unique integer. If you add multiple rules to a WebACL, the values do not need to be consecutive.</p>', 'BatchImportFindingsResponse$FailedCount' => '<p>The number of findings that failed to import.</p>', 'BatchImportFindingsResponse$SuccessCount' => '<p>The number of findings that were successfully imported.</p>', 'DateRange$Value' => '<p>A date range value for the date filter.</p>', 'GetInvitationsCountResponse$InvitationsCount' => '<p>The number of all membership invitations sent to this Security Hub member account, not including the currently accepted invitation.</p>', 'InsightResultValue$Count' => '<p>The number of findings returned for each <code>GroupByAttributeValue</code>.</p>', 'Network$SourcePort' => '<p>The source port of network-related information about a finding.</p>', 'Network$DestinationPort' => '<p>The destination port of network-related information about a finding.</p>', 'PortRange$Begin' => '<p>The first port in the port range.</p>', 'PortRange$End' => '<p>The last port in the port range.</p>', 'ProcessDetails$Pid' => '<p>The process ID.</p>', 'ProcessDetails$ParentPid' => '<p>The parent process ID.</p>', 'Severity$Normalized' => '<p>Deprecated. The normalized severity of a finding. This attribute is being deprecated. Instead of providing <code>Normalized</code>, provide <code>Label</code>.</p> <p>If you provide <code>Label</code> and do not provide <code>Normalized</code>, then <code>Normalized</code> is set automatically as follows.</p> <ul> <li> <p> <code>INFORMATIONAL</code> - 0</p> </li> <li> <p> <code>LOW</code> - 1</p> </li> <li> <p> <code>MEDIUM</code> - 40</p> </li> <li> <p> <code>HIGH</code> - 70</p> </li> <li> <p> <code>CRITICAL</code> - 90</p> </li> </ul>', ], ], 'IntegrationType' => [ 'base' => NULL, 'refs' => [ 'IntegrationTypeList$member' => NULL, ], ], 'IntegrationTypeList' => [ 'base' => NULL, 'refs' => [ 'Product$IntegrationTypes' => '<p>The types of integration that the product supports. Available values are the following.</p> <ul> <li> <p> <code>SEND_FINDINGS_TO_SECURITY_HUB</code> - Indicates that the integration sends findings to Security Hub.</p> </li> <li> <p> <code>RECEIVE_FINDINGS_FROM_SECURITY_HUB</code> - Indicates that the integration receives findings from Security Hub.</p> </li> </ul>', ], ], 'InternalException' => [ 'base' => '<p>Internal server error.</p>', 'refs' => [], ], 'InvalidAccessException' => [ 'base' => '<p>AWS Security Hub isn\'t enabled for the account used to make this request.</p>', 'refs' => [], ], 'InvalidInputException' => [ 'base' => '<p>The request was rejected because you supplied an invalid or out-of-range value for an input parameter.</p>', 'refs' => [], ], 'Invitation' => [ 'base' => '<p>Details about an invitation.</p>', 'refs' => [ 'GetMasterAccountResponse$Master' => '<p>A list of details about the Security Hub master account for the current member account. </p>', 'InvitationList$member' => NULL, ], ], 'InvitationList' => [ 'base' => NULL, 'refs' => [ 'ListInvitationsResponse$Invitations' => '<p>The details of the invitations returned by the operation.</p>', ], ], 'InviteMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'InviteMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'IpFilter' => [ 'base' => '<p>The IP filter for querying findings.</p>', 'refs' => [ 'IpFilterList$member' => NULL, ], ], 'IpFilterList' => [ 'base' => NULL, 'refs' => [ 'AwsSecurityFindingFilters$NetworkSourceIpV4' => '<p>The source IPv4 address of network-related information about a finding.</p>', 'AwsSecurityFindingFilters$NetworkSourceIpV6' => '<p>The source IPv6 address of network-related information about a finding.</p>', 'AwsSecurityFindingFilters$NetworkDestinationIpV4' => '<p>The destination IPv4 address of network-related information about a finding.</p>', 'AwsSecurityFindingFilters$NetworkDestinationIpV6' => '<p>The destination IPv6 address of network-related information about a finding.</p>', 'AwsSecurityFindingFilters$ResourceAwsEc2InstanceIpV4Addresses' => '<p>The IPv4 addresses associated with the instance.</p>', 'AwsSecurityFindingFilters$ResourceAwsEc2InstanceIpV6Addresses' => '<p>The IPv6 addresses associated with the instance.</p>', ], ], 'Ipv6CidrBlockAssociation' => [ 'base' => '<p>An IPV6 CIDR block association.</p>', 'refs' => [ 'Ipv6CidrBlockAssociationList$member' => NULL, ], ], 'Ipv6CidrBlockAssociationList' => [ 'base' => NULL, 'refs' => [ 'AwsEc2VpcDetails$Ipv6CidrBlockAssociationSet' => '<p>Information about the IPv6 CIDR blocks associated with the VPC.</p>', ], ], 'KeywordFilter' => [ 'base' => '<p>A keyword filter for querying findings.</p>', 'refs' => [ 'KeywordFilterList$member' => NULL, ], ], 'KeywordFilterList' => [ 'base' => NULL, 'refs' => [ 'AwsSecurityFindingFilters$Keyword' => '<p>A keyword for a finding.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The request was rejected because it attempted to create resources beyond the current AWS account limits. The error code describes the limit exceeded.</p>', 'refs' => [], ], 'ListEnabledProductsForImportRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEnabledProductsForImportResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInvitationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInvitationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMembersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'LoadBalancerState' => [ 'base' => '<p>Information about the state of the load balancer.</p>', 'refs' => [ 'AwsElbv2LoadBalancerDetails$State' => '<p>The state of the load balancer.</p>', ], ], 'Malware' => [ 'base' => '<p>A list of malware related to a finding.</p>', 'refs' => [ 'MalwareList$member' => NULL, ], ], 'MalwareList' => [ 'base' => NULL, 'refs' => [ 'AwsSecurityFinding$Malware' => '<p>A list of malware related to a finding.</p>', ], ], 'MalwareState' => [ 'base' => NULL, 'refs' => [ 'Malware$State' => '<p>The state of the malware that was observed.</p>', ], ], 'MalwareType' => [ 'base' => NULL, 'refs' => [ 'Malware$Type' => '<p>The type of the malware that was observed.</p>', ], ], 'MapFilter' => [ 'base' => '<p>The map filter for querying findings.</p>', 'refs' => [ 'MapFilterList$member' => NULL, ], ], 'MapFilterComparison' => [ 'base' => NULL, 'refs' => [ 'MapFilter$Comparison' => '<p>The condition to apply to a key value when querying for findings with a map filter.</p>', ], ], 'MapFilterList' => [ 'base' => NULL, 'refs' => [ 'AwsSecurityFindingFilters$ProductFields' => '<p>A data type where security-findings providers can include additional solution-specific details that aren\'t part of the defined <code>AwsSecurityFinding</code> format.</p>', 'AwsSecurityFindingFilters$UserDefinedFields' => '<p>A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a finding. </p>', 'AwsSecurityFindingFilters$ResourceTags' => '<p>A list of AWS tags associated with a resource at the time the finding was processed.</p>', 'AwsSecurityFindingFilters$ResourceDetailsOther' => '<p>The details of a resource that doesn\'t have a specific subfield for the resource type defined.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeActionTargetsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'DescribeProductsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'DescribeStandardsControlsRequest$MaxResults' => '<p>The maximum number of security standard controls to return.</p>', 'DescribeStandardsRequest$MaxResults' => '<p>The maximum number of standards to return.</p>', 'GetEnabledStandardsRequest$MaxResults' => '<p>The maximum number of results to return in the response.</p>', 'GetFindingsRequest$MaxResults' => '<p>The maximum number of findings to return.</p>', 'GetInsightsRequest$MaxResults' => '<p>The maximum number of items to return in the response.</p>', 'ListEnabledProductsForImportRequest$MaxResults' => '<p>The maximum number of items to return in the response.</p>', 'ListInvitationsRequest$MaxResults' => '<p>The maximum number of items to return in the response. </p>', 'ListMembersRequest$MaxResults' => '<p>The maximum number of items to return in the response. </p>', ], ], 'Member' => [ 'base' => '<p>The details about a member account.</p>', 'refs' => [ 'MemberList$member' => NULL, ], ], 'MemberList' => [ 'base' => NULL, 'refs' => [ 'GetMembersResponse$Members' => '<p>The list of details about the Security Hub member accounts.</p>', 'ListMembersResponse$Members' => '<p>Member details returned by the operation.</p>', ], ], 'Network' => [ 'base' => '<p>The details of network-related information about a finding.</p>', 'refs' => [ 'AwsSecurityFinding$Network' => '<p>The details of network-related information about a finding.</p>', ], ], 'NetworkDirection' => [ 'base' => NULL, 'refs' => [ 'Network$Direction' => '<p>The direction of network traffic associated with a finding.</p>', ], ], 'NetworkHeader' => [ 'base' => '<p>Details about a network path component that occurs before or after the current component.</p>', 'refs' => [ 'NetworkPathComponent$Egress' => '<p>Information about the component that comes after the current component in the network path.</p>', 'NetworkPathComponent$Ingress' => '<p>Information about the component that comes before the current node in the network path.</p>', ], ], 'NetworkPathComponent' => [ 'base' => '<p>Information about a network path component.</p>', 'refs' => [ 'NetworkPathList$member' => NULL, ], ], 'NetworkPathComponentDetails' => [ 'base' => '<p>Information about the destination of the next component in the network path.</p>', 'refs' => [ 'NetworkHeader$Destination' => '<p>Information about the destination of the component.</p>', 'NetworkHeader$Source' => '<p>Information about the origin of the component.</p>', ], ], 'NetworkPathList' => [ 'base' => NULL, 'refs' => [ 'AwsSecurityFinding$NetworkPath' => '<p>Provides information about a network path that is relevant to a finding. Each entry under <code>NetworkPath</code> represents a component of that path.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeActionTargetsRequest$NextToken' => '<p>The token that is required for pagination. On your first call to the <code>DescribeActionTargets</code> operation, set the value of this parameter to <code>NULL</code>.</p> <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>', 'DescribeActionTargetsResponse$NextToken' => '<p>The pagination token to use to request the next page of results.</p>', 'DescribeProductsRequest$NextToken' => '<p>The token that is required for pagination. On your first call to the <code>DescribeProducts</code> operation, set the value of this parameter to <code>NULL</code>.</p> <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>', 'DescribeProductsResponse$NextToken' => '<p>The pagination token to use to request the next page of results.</p>', 'DescribeStandardsControlsRequest$NextToken' => '<p>The token that is required for pagination. On your first call to the <code>DescribeStandardsControls</code> operation, set the value of this parameter to <code>NULL</code>.</p> <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>', 'DescribeStandardsControlsResponse$NextToken' => '<p>The pagination token to use to request the next page of results.</p>', 'DescribeStandardsRequest$NextToken' => '<p>The token that is required for pagination. On your first call to the <code>DescribeStandards</code> operation, set the value of this parameter to <code>NULL</code>.</p> <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>', 'DescribeStandardsResponse$NextToken' => '<p>The pagination token to use to request the next page of results.</p>', 'GetEnabledStandardsRequest$NextToken' => '<p>The token that is required for pagination. On your first call to the <code>GetEnabledStandards</code> operation, set the value of this parameter to <code>NULL</code>.</p> <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>', 'GetEnabledStandardsResponse$NextToken' => '<p>The pagination token to use to request the next page of results.</p>', 'GetFindingsRequest$NextToken' => '<p>The token that is required for pagination. On your first call to the <code>GetFindings</code> operation, set the value of this parameter to <code>NULL</code>.</p> <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>', 'GetFindingsResponse$NextToken' => '<p>The pagination token to use to request the next page of results.</p>', 'GetInsightsRequest$NextToken' => '<p>The token that is required for pagination. On your first call to the <code>GetInsights</code> operation, set the value of this parameter to <code>NULL</code>.</p> <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>', 'GetInsightsResponse$NextToken' => '<p>The pagination token to use to request the next page of results.</p>', 'ListEnabledProductsForImportRequest$NextToken' => '<p>The token that is required for pagination. On your first call to the <code>ListEnabledProductsForImport</code> operation, set the value of this parameter to <code>NULL</code>.</p> <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>', 'ListEnabledProductsForImportResponse$NextToken' => '<p>The pagination token to use to request the next page of results.</p>', 'ListInvitationsRequest$NextToken' => '<p>The token that is required for pagination. On your first call to the <code>ListInvitations</code> operation, set the value of this parameter to <code>NULL</code>.</p> <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>', 'ListMembersRequest$NextToken' => '<p>The token that is required for pagination. On your first call to the <code>ListMembers</code> operation, set the value of this parameter to <code>NULL</code>.</p> <p>For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response.</p>', ], ], 'NonEmptyString' => [ 'base' => NULL, 'refs' => [ 'AcceptInvitationRequest$MasterId' => '<p>The account ID of the Security Hub master account that sent the invitation.</p>', 'AcceptInvitationRequest$InvitationId' => '<p>The ID of the invitation sent from the Security Hub master account.</p>', 'AccessDeniedException$Message' => NULL, 'AccessDeniedException$Code' => NULL, 'AccountDetails$Email' => '<p>The email of an AWS account.</p>', 'AccountIdList$member' => NULL, 'ActionTarget$ActionTargetArn' => '<p>The ARN for the target action.</p>', 'ActionTarget$Name' => '<p>The name of the action target.</p>', 'ActionTarget$Description' => '<p>The description of the target action.</p>', 'ArnList$member' => NULL, 'AvailabilityZone$ZoneName' => '<p>The name of the Availability Zone.</p>', 'AvailabilityZone$SubnetId' => '<p>The ID of the subnet. You can specify one subnet per Availability Zone.</p>', 'AwsAutoScalingAutoScalingGroupDetails$LaunchConfigurationName' => '<p>The name of the launch configuration.</p>', 'AwsAutoScalingAutoScalingGroupDetails$HealthCheckType' => '<p>The service to use for the health checks.</p>', 'AwsAutoScalingAutoScalingGroupDetails$CreatedTime' => '<p>The datetime when the auto scaling group was created.</p>', 'AwsCloudFrontDistributionDetails$DomainName' => '<p>The domain name corresponding to the distribution.</p>', 'AwsCloudFrontDistributionDetails$ETag' => '<p>The entity tag is a hash of the object.</p>', 'AwsCloudFrontDistributionDetails$LastModifiedTime' => '<p>The date and time that the distribution was last modified.</p>', 'AwsCloudFrontDistributionDetails$Status' => '<p>Indicates the current status of the distribution.</p>', 'AwsCloudFrontDistributionDetails$WebAclId' => '<p>A unique identifier that specifies the AWS WAF web ACL, if any, to associate with this distribution.</p>', 'AwsCloudFrontDistributionLogging$Bucket' => '<p>The Amazon S3 bucket to store the access logs in.</p>', 'AwsCloudFrontDistributionLogging$Prefix' => '<p>An optional string that you want CloudFront to use as a prefix to the access log filenames for this distribution.</p>', 'AwsCloudFrontDistributionOriginItem$DomainName' => '<p>Amazon S3 origins: The DNS name of the Amazon S3 bucket from which you want CloudFront to get objects for this origin.</p>', 'AwsCloudFrontDistributionOriginItem$Id' => '<p>A unique identifier for the origin or origin group.</p>', 'AwsCloudFrontDistributionOriginItem$OriginPath' => '<p>An optional element that causes CloudFront to request your content from a directory in your Amazon S3 bucket or your custom origin.</p>', 'AwsCodeBuildProjectDetails$EncryptionKey' => '<p>The AWS Key Management Service (AWS KMS) customer master key (CMK) used to encrypt the build output artifacts.</p> <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK alias (using the format alias/alias-name). </p>', 'AwsCodeBuildProjectDetails$Name' => '<p>The name of the build project.</p>', 'AwsCodeBuildProjectDetails$ServiceRole' => '<p>The ARN of the IAM role that enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account.</p>', 'AwsCodeBuildProjectEnvironment$Certificate' => '<p>The certificate to use with this build project.</p>', 'AwsCodeBuildProjectEnvironment$ImagePullCredentialsType' => '<p>The type of credentials AWS CodeBuild uses to pull images in your build.</p> <p>Valid values:</p> <ul> <li> <p> <code>CODEBUILD</code> specifies that AWS CodeBuild uses its own credentials. This requires that you modify your ECR repository policy to trust the AWS CodeBuild service principal.</p> </li> <li> <p> <code>SERVICE_ROLE</code> specifies that AWS CodeBuild uses your build project\'s service role.</p> </li> </ul> <p>When you use a cross-account or private registry image, you must use <code>SERVICE_ROLE</code> credentials. When you use an AWS CodeBuild curated image, you must use <code>CODEBUILD</code> credentials.</p>', 'AwsCodeBuildProjectEnvironment$Type' => '<p>The type of build environment to use for related builds.</p> <p>The environment type <code>ARM_CONTAINER</code> is available only in Regions US East (N. Virginia), US East (Ohio), US West (Oregon), Europe (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Sydney), and Europe (Frankfurt).</p> <p>The environment type <code>LINUX_CONTAINER</code> with compute type build.general1.2xlarge is available only in Regions US East (N. Virginia), US East (N. Virginia), US West (Oregon), Canada (Central), Europe (Ireland), Europe (London), Europe (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney), China (Beijing), and China (Ningxia).</p> <p>The environment type <code>LINUX_GPU_CONTAINER</code> is available only in Regions US East (N. Virginia), US East (N. Virginia), US West (Oregon), Canada (Central), Europe (Ireland), Europe (London), Europe (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney), China (Beijing), and China (Ningxia).</p> <p>Valid values: <code>WINDOWS_CONTAINER</code> | <code>LINUX_CONTAINER</code> | <code>LINUX_GPU_CONTAINER</code> | <code>ARM_CONTAINER</code> </p>', 'AwsCodeBuildProjectEnvironmentRegistryCredential$Credential' => '<p>The Amazon Resource Name (ARN) or name of credentials created using AWS Secrets Manager.</p> <note> <p>The credential can use the name of the credentials only if they exist in your current AWS Region. </p> </note>', 'AwsCodeBuildProjectEnvironmentRegistryCredential$CredentialProvider' => '<p>The service that created the credentials to access a private Docker registry.</p> <p>The valid value,<code> SECRETS_MANAGER</code>, is for AWS Secrets Manager.</p>', 'AwsCodeBuildProjectSource$Type' => '<p>The type of repository that contains the source code to be built. Valid values are:</p> <ul> <li> <p> <code>BITBUCKET</code> - The source code is in a Bitbucket repository.</p> </li> <li> <p> <code>CODECOMMIT</code> - The source code is in an AWS CodeCommit repository.</p> </li> <li> <p> <code>CODEPIPELINE</code> - The source code settings are specified in the source action of a pipeline in AWS CodePipeline.</p> </li> <li> <p> <code>GITHUB</code> - The source code is in a GitHub repository.</p> </li> <li> <p> <code>GITHUB_ENTERPRISE</code> - The source code is in a GitHub Enterprise repository.</p> </li> <li> <p> <code>NO_SOURCE</code> - The project does not have input source code.</p> </li> <li> <p> <code>S3</code> - The source code is in an S3 input bucket. </p> </li> </ul>', 'AwsCodeBuildProjectSource$Location' => '<p>Information about the location of the source code to be built.</p> <p>Valid values include:</p> <ul> <li> <p>For source code settings that are specified in the source action of a pipeline in AWS CodePipeline, location should not be specified. If it is specified, AWS CodePipeline ignores it. This is because AWS CodePipeline uses the settings in a pipeline\'s source action instead of this value.</p> </li> <li> <p>For source code in an AWS CodeCommit repository, the HTTPS clone URL to the repository that contains the source code and the build spec file (for example, <code>https://git-codecommit.region-ID.amazonaws.com/v1/repos/repo-name</code> ).</p> </li> <li> <p>For source code in an S3 input bucket, one of the following.</p> <ul> <li> <p>The path to the ZIP file that contains the source code (for example, <code>bucket-name/path/to/object-name.zip</code>).</p> </li> <li> <p> The path to the folder that contains the source code (for example, <code>bucket-name/path/to/source-code/folder/</code>).</p> </li> </ul> </li> <li> <p>For source code in a GitHub repository, the HTTPS clone URL to the repository that contains the source and the build spec file.</p> </li> <li> <p>For source code in a Bitbucket repository, the HTTPS clone URL to the repository that contains the source and the build spec file. </p> </li> </ul>', 'AwsCodeBuildProjectVpcConfig$VpcId' => '<p>The ID of the VPC.</p>', 'AwsEc2InstanceDetails$Type' => '<p>The instance type of the instance. </p>', 'AwsEc2InstanceDetails$ImageId' => '<p>The Amazon Machine Image (AMI) ID of the instance.</p>', 'AwsEc2InstanceDetails$KeyName' => '<p>The key name associated with the instance.</p>', 'AwsEc2InstanceDetails$IamInstanceProfileArn' => '<p>The IAM profile ARN of the instance.</p>', 'AwsEc2InstanceDetails$VpcId' => '<p>The identifier of the VPC that the instance was launched in.</p>', 'AwsEc2InstanceDetails$SubnetId' => '<p>The identifier of the subnet that the instance was launched in.</p>', 'AwsEc2InstanceDetails$LaunchedAt' => '<p>The date/time the instance was launched.</p>', 'AwsEc2NetworkInterfaceAttachment$AttachTime' => '<p>The timestamp indicating when the attachment initiated.</p>', 'AwsEc2NetworkInterfaceAttachment$AttachmentId' => '<p>The identifier of the network interface attachment</p>', 'AwsEc2NetworkInterfaceAttachment$InstanceId' => '<p>The ID of the instance.</p>', 'AwsEc2NetworkInterfaceAttachment$InstanceOwnerId' => '<p>The AWS account ID of the owner of the instance.</p>', 'AwsEc2NetworkInterfaceAttachment$Status' => '<p>The attachment state.</p> <p>Valid values: <code>attaching</code> | <code>attached</code> | <code>detaching</code> | <code>detached</code> </p>', 'AwsEc2NetworkInterfaceDetails$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'AwsEc2NetworkInterfaceSecurityGroup$GroupName' => '<p>The name of the security group.</p>', 'AwsEc2NetworkInterfaceSecurityGroup$GroupId' => '<p>The ID of the security group.</p>', 'AwsEc2SecurityGroupDetails$GroupName' => '<p>The name of the security group.</p>', 'AwsEc2SecurityGroupDetails$GroupId' => '<p>The ID of the security group.</p>', 'AwsEc2SecurityGroupDetails$OwnerId' => '<p>The AWS account ID of the owner of the security group.</p>', 'AwsEc2SecurityGroupDetails$VpcId' => '<p>[VPC only] The ID of the VPC for the security group.</p>', 'AwsEc2SecurityGroupIpPermission$IpProtocol' => '<p>The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or number.</p> <p>[VPC only] Use <code>-1</code> to specify all protocols.</p> <p>When authorizing security group rules, specifying -1 or a protocol number other than <code>tcp</code>, <code>udp</code>, <code>icmp</code>, or <code>icmpv6</code> allows traffic on all ports, regardless of any port range you specify.</p> <p>For <code>tcp</code>, <code>udp</code>, and <code>icmp</code>, you must specify a port range.</p> <p>For <code>icmpv6</code>, the port range is optional. If you omit the port range, traffic for all types and codes is allowed. </p>', 'AwsEc2SecurityGroupIpRange$CidrIp' => '<p>The IPv4 CIDR range. You can specify either a CIDR range or a source security group, but not both. To specify a single IPv4 address, use the /32 prefix length.</p>', 'AwsEc2SecurityGroupIpv6Range$CidrIpv6' => '<p>The IPv6 CIDR range. You can specify either a CIDR range or a source security group, but not both. To specify a single IPv6 address, use the /128 prefix length.</p>', 'AwsEc2SecurityGroupPrefixListId$PrefixListId' => '<p>The ID of the prefix.</p>', 'AwsEc2SecurityGroupUserIdGroupPair$GroupId' => '<p>The ID of the security group.</p>', 'AwsEc2SecurityGroupUserIdGroupPair$GroupName' => '<p>The name of the security group.</p>', 'AwsEc2SecurityGroupUserIdGroupPair$PeeringStatus' => '<p>The status of a VPC peering connection, if applicable.</p>', 'AwsEc2SecurityGroupUserIdGroupPair$UserId' => '<p>The ID of an AWS account.</p> <p>For a referenced security group in another VPC, the account ID of the referenced security group is returned in the response. If the referenced security group is deleted, this value is not returned.</p> <p>[EC2-Classic] Required when adding or removing rules that reference a security group in another AWS. </p>', 'AwsEc2SecurityGroupUserIdGroupPair$VpcId' => '<p>The ID of the VPC for the referenced security group, if applicable.</p>', 'AwsEc2SecurityGroupUserIdGroupPair$VpcPeeringConnectionId' => '<p>The ID of the VPC peering connection, if applicable.</p>', 'AwsEc2VolumeAttachment$AttachTime' => '<p>The datetime when the attachment initiated.</p>', 'AwsEc2VolumeAttachment$InstanceId' => '<p>The identifier of the EC2 instance.</p>', 'AwsEc2VolumeAttachment$Status' => '<p>The attachment state of the volume.</p>', 'AwsEc2VolumeDetails$CreateTime' => '<p>The datetime when the volume was created.</p>', 'AwsEc2VolumeDetails$SnapshotId' => '<p>The snapshot from which the volume was created.</p>', 'AwsEc2VolumeDetails$Status' => '<p>The volume state.</p>', 'AwsEc2VolumeDetails$KmsKeyId' => '<p>The ARN of the AWS Key Management Service (AWS KMS) customer master key (CMK) that was used to protect the volume encryption key for the volume.</p>', 'AwsEc2VpcDetails$DhcpOptionsId' => '<p>The identifier of the set of Dynamic Host Configuration Protocol (DHCP) options that are associated with the VPC. If the default options are associated with the VPC, then this is default.</p>', 'AwsEc2VpcDetails$State' => '<p>The current state of the VPC.</p>', 'AwsElasticsearchDomainDetails$AccessPolicies' => '<p>IAM policy document specifying the access policies for the new Amazon ES domain.</p>', 'AwsElasticsearchDomainDetails$DomainId' => '<p>Unique identifier for an Amazon ES domain.</p>', 'AwsElasticsearchDomainDetails$DomainName' => '<p>Name of an Amazon ES domain.</p> <p>Domain names are unique across all domains owned by the same account within an AWS Region.</p> <p>Domain names must start with a lowercase letter and must be between 3 and 28 characters.</p> <p>Valid characters are a-z (lowercase only), 0-9, and – (hyphen). </p>', 'AwsElasticsearchDomainDetails$Endpoint' => '<p>Domain-specific endpoint used to submit index, search, and data upload requests to an Amazon ES domain.</p> <p>The endpoint is a service URL. </p>', 'AwsElasticsearchDomainDetails$ElasticsearchVersion' => '<p>Elasticsearch version.</p>', 'AwsElasticsearchDomainDomainEndpointOptions$TLSSecurityPolicy' => '<p>The TLS security policy to apply to the HTTPS endpoint of the Elasticsearch domain.</p> <p>Valid values:</p> <ul> <li> <p> <code>Policy-Min-TLS-1-0-2019-07</code>, which supports TLSv1.0 and higher</p> </li> <li> <p> <code>Policy-Min-TLS-1-2-2019-07</code>, which only supports TLSv1.2</p> </li> </ul>', 'AwsElasticsearchDomainEncryptionAtRestOptions$KmsKeyId' => '<p>The KMS key ID. Takes the form 1a2a3a4-1a2a-3a4a-5a6a-1a2a3a4a5a6a.</p>', 'AwsElasticsearchDomainVPCOptions$VPCId' => '<p>ID for the VPC.</p>', 'AwsElbv2LoadBalancerDetails$CanonicalHostedZoneId' => '<p>The ID of the Amazon Route 53 hosted zone associated with the load balancer.</p>', 'AwsElbv2LoadBalancerDetails$CreatedTime' => '<p>The date and time the load balancer was created.</p>', 'AwsElbv2LoadBalancerDetails$DNSName' => '<p>The public DNS name of the load balancer.</p>', 'AwsElbv2LoadBalancerDetails$IpAddressType' => '<p>The type of IP addresses used by the subnets for your load balancer. The possible values are <code>ipv4</code> (for IPv4 addresses) and <code>dualstack</code> (for IPv4 and IPv6 addresses).</p>', 'AwsElbv2LoadBalancerDetails$Scheme' => '<p>The nodes of an Internet-facing load balancer have public IP addresses.</p>', 'AwsElbv2LoadBalancerDetails$Type' => '<p>The type of load balancer.</p>', 'AwsElbv2LoadBalancerDetails$VpcId' => '<p>The ID of the VPC for the load balancer.</p>', 'AwsIamAccessKeyDetails$UserName' => '<p>The user associated with the IAM access key related to a finding.</p> <p>The <code>UserName</code> parameter has been replaced with the <code>PrincipalName</code> parameter because access keys can also be assigned to principals that are not IAM users.</p>', 'AwsIamAccessKeyDetails$CreatedAt' => '<p>The creation date/time of the IAM access key related to a finding.</p>', 'AwsIamAccessKeyDetails$PrincipalId' => '<p>The ID of the principal associated with an access key.</p>', 'AwsIamAccessKeyDetails$PrincipalType' => '<p>The type of principal associated with an access key.</p>', 'AwsIamAccessKeyDetails$PrincipalName' => '<p>The name of the principal.</p>', 'AwsIamRoleDetails$CreateDate' => '<p>The date and time, in ISO 8601 date-time format, when the role was created.</p>', 'AwsIamRoleDetails$RoleId' => '<p>The stable and unique string identifying the role.</p>', 'AwsIamRoleDetails$RoleName' => '<p>The friendly name that identifies the role.</p>', 'AwsIamRoleDetails$Path' => '<p>The path to the role.</p>', 'AwsKmsKeyDetails$AWSAccountId' => '<p>The twelve-digit account ID of the AWS account that owns the CMK.</p>', 'AwsKmsKeyDetails$KeyId' => '<p>The globally unique identifier for the CMK.</p>', 'AwsKmsKeyDetails$KeyManager' => '<p>The manager of the CMK. CMKs in your AWS account are either customer managed or AWS managed.</p>', 'AwsKmsKeyDetails$KeyState' => '<p>The state of the CMK.</p>', 'AwsKmsKeyDetails$Origin' => '<p>The source of the CMK\'s key material.</p> <p>When this value is <code>AWS_KMS</code>, AWS KMS created the key material.</p> <p>When this value is <code>EXTERNAL</code>, the key material was imported from your existing key management infrastructure or the CMK lacks key material.</p> <p>When this value is <code>AWS_CLOUDHSM</code>, the key material was created in the AWS CloudHSM cluster associated with a custom key store.</p>', 'AwsLambdaFunctionCode$S3Bucket' => '<p>An Amazon S3 bucket in the same AWS Region as your function. The bucket can be in a different AWS account.</p>', 'AwsLambdaFunctionCode$S3Key' => '<p>The Amazon S3 key of the deployment package.</p>', 'AwsLambdaFunctionCode$S3ObjectVersion' => '<p>For versioned objects, the version of the deployment package object to use.</p>', 'AwsLambdaFunctionCode$ZipFile' => '<p>The base64-encoded contents of the deployment package. AWS SDK and AWS CLI clients handle the encoding for you.</p>', 'AwsLambdaFunctionDeadLetterConfig$TargetArn' => '<p>The Amazon Resource Name (ARN) of an Amazon SQS queue or Amazon SNS topic.</p>', 'AwsLambdaFunctionDetails$CodeSha256' => '<p>The SHA256 hash of the function\'s deployment package.</p>', 'AwsLambdaFunctionDetails$FunctionName' => '<p>The name of the function.</p>', 'AwsLambdaFunctionDetails$Handler' => '<p>The function that Lambda calls to begin executing your function.</p>', 'AwsLambdaFunctionDetails$KmsKeyArn' => '<p>The KMS key that\'s used to encrypt the function\'s environment variables. This key is only returned if you\'ve configured a customer managed CMK.</p>', 'AwsLambdaFunctionDetails$LastModified' => '<p>The date and time that the function was last updated, in ISO-8601 format (YYYY-MM-DDThh:mm:ss.sTZD).</p>', 'AwsLambdaFunctionDetails$MasterArn' => '<p>For Lambda@Edge functions, the ARN of the master function.</p>', 'AwsLambdaFunctionDetails$RevisionId' => '<p>The latest updated revision of the function or alias.</p>', 'AwsLambdaFunctionDetails$Role' => '<p>The function\'s execution role.</p>', 'AwsLambdaFunctionDetails$Runtime' => '<p>The runtime environment for the Lambda function.</p>', 'AwsLambdaFunctionDetails$Version' => '<p>The version of the Lambda function.</p>', 'AwsLambdaFunctionEnvironmentError$ErrorCode' => '<p>The error code.</p>', 'AwsLambdaFunctionEnvironmentError$Message' => '<p>The error message.</p>', 'AwsLambdaFunctionLayer$Arn' => '<p>The Amazon Resource Name (ARN) of the function layer.</p>', 'AwsLambdaFunctionTracingConfig$Mode' => '<p>The tracing mode.</p>', 'AwsLambdaFunctionVpcConfig$VpcId' => '<p>The ID of the VPC.</p>', 'AwsLambdaLayerVersionDetails$CreatedDate' => '<p>The date that the version was created, in ISO 8601 format. For example, 2018-11-27T15:10:45.123+0000. </p>', 'AwsRdsDbInstanceAssociatedRole$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that is associated with the DB instance.</p>', 'AwsRdsDbInstanceAssociatedRole$FeatureName' => '<p>The name of the feature associated with the IAM)role.</p>', 'AwsRdsDbInstanceAssociatedRole$Status' => '<p>Describes the state of the association between the IAM role and the DB instance. The <code>Status</code> property returns one of the following values:</p> <ul> <li> <p> <code>ACTIVE</code> - The IAM role ARN is associated with the DB instance and can be used to access other AWS services on your behalf.</p> </li> <li> <p> <code>PENDING</code> - The IAM role ARN is being associated with the DB instance.</p> </li> <li> <p> <code>INVALID</code> - The IAM role ARN is associated with the DB instance. But the DB instance is unable to assume the IAM role in order to access other AWS services on your behalf. </p> </li> </ul>', 'AwsRdsDbInstanceDetails$CACertificateIdentifier' => '<p>The identifier of the CA certificate for this DB instance.</p>', 'AwsRdsDbInstanceDetails$DBClusterIdentifier' => '<p>If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance is a member of.</p>', 'AwsRdsDbInstanceDetails$DBInstanceIdentifier' => '<p>Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB instance.</p>', 'AwsRdsDbInstanceDetails$DBInstanceClass' => '<p>Contains the name of the compute and memory capacity class of the DB instance.</p>', 'AwsRdsDbInstanceDetails$DbiResourceId' => '<p>The AWS Region-unique, immutable identifier for the DB instance. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB instance is accessed. </p>', 'AwsRdsDbInstanceDetails$DBName' => '<p>The meaning of this parameter differs according to the database engine you use.</p> <p> <b>MySQL, MariaDB, SQL Server, PostgreSQL</b> </p> <p>Contains the name of the initial database of this instance that was provided at create time, if one was specified when the DB instance was created. This same name is returned for the life of the DB instance.</p> <p> <b>Oracle</b> </p> <p>Contains the Oracle System ID (SID) of the created DB instance. Not shown when the returned parameters do not apply to an Oracle DB instance. </p>', 'AwsRdsDbInstanceDetails$Engine' => '<p>Provides the name of the database engine to use for this DB instance.</p>', 'AwsRdsDbInstanceDetails$EngineVersion' => '<p>Indicates the database engine version.</p>', 'AwsRdsDbInstanceDetails$InstanceCreateTime' => '<p>Provides the date and time the DB instance was created.</p>', 'AwsRdsDbInstanceDetails$KmsKeyId' => '<p>If <code>StorageEncrypted</code> is true, the AWS KMS key identifier for the encrypted DB instance.</p>', 'AwsRdsDbInstanceDetails$TdeCredentialArn' => '<p>The ARN from the key store with which the instance is associated for TDE encryption.</p>', 'AwsRdsDbInstanceEndpoint$Address' => '<p>Specifies the DNS address of the DB instance.</p>', 'AwsRdsDbInstanceEndpoint$HostedZoneId' => '<p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>', 'AwsRdsDbInstanceVpcSecurityGroup$VpcSecurityGroupId' => '<p>The name of the VPC security group.</p>', 'AwsRdsDbInstanceVpcSecurityGroup$Status' => '<p>The status of the VPC security group.</p>', 'AwsS3BucketDetails$OwnerId' => '<p>The canonical user ID of the owner of the S3 bucket.</p>', 'AwsS3BucketDetails$OwnerName' => '<p>The display name of the owner of the S3 bucket.</p>', 'AwsS3BucketDetails$CreatedAt' => '<p>The date and time when the S3 bucket was created.</p>', 'AwsS3BucketServerSideEncryptionByDefault$SSEAlgorithm' => '<p>Server-side encryption algorithm to use for the default encryption.</p>', 'AwsS3BucketServerSideEncryptionByDefault$KMSMasterKeyID' => '<p>AWS KMS customer master key (CMK) ID to use for the default encryption.</p>', 'AwsS3ObjectDetails$LastModified' => '<p>The date and time when the object was last modified.</p>', 'AwsS3ObjectDetails$ETag' => '<p>The opaque identifier assigned by a web server to a specific version of a resource found at a URL.</p>', 'AwsS3ObjectDetails$VersionId' => '<p>The version of the object.</p>', 'AwsS3ObjectDetails$ContentType' => '<p>A standard MIME type describing the format of the object data.</p>', 'AwsS3ObjectDetails$ServerSideEncryption' => '<p>If the object is stored using server-side encryption, the value of the server-side encryption algorithm used when storing this object in Amazon S3.</p>', 'AwsS3ObjectDetails$SSEKMSKeyId' => '<p>The identifier of the AWS Key Management Service (AWS KMS) symmetric customer managed customer master key (CMK) that was used for the object.</p>', 'AwsSecurityFinding$SchemaVersion' => '<p>The schema version that a finding is formatted for.</p>', 'AwsSecurityFinding$Id' => '<p>The security findings provider-specific identifier for a finding.</p>', 'AwsSecurityFinding$ProductArn' => '<p>The ARN generated by Security Hub that uniquely identifies a product that generates findings. This can be the ARN for a third-party product that is integrated with Security Hub, or the ARN for a custom integration.</p>', 'AwsSecurityFinding$GeneratorId' => '<p>The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In various security-findings providers\' solutions, this generator can be called a rule, a check, a detector, a plugin, etc. </p>', 'AwsSecurityFinding$AwsAccountId' => '<p>The AWS account ID that a finding is generated in.</p>', 'AwsSecurityFinding$FirstObservedAt' => '<p>An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the potential security issue that a finding captured.</p>', 'AwsSecurityFinding$LastObservedAt' => '<p>An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed the potential security issue that a finding captured.</p>', 'AwsSecurityFinding$CreatedAt' => '<p>An ISO8601-formatted timestamp that indicates when the security-findings provider created the potential security issue that a finding captured.</p>', 'AwsSecurityFinding$UpdatedAt' => '<p>An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the finding record. </p>', 'AwsSecurityFinding$Title' => '<p>A finding\'s title.</p> <note> <p>In this release, <code>Title</code> is a required property.</p> </note>', 'AwsSecurityFinding$Description' => '<p>A finding\'s description.</p> <note> <p>In this release, <code>Description</code> is a required property.</p> </note>', 'AwsSecurityFinding$SourceUrl' => '<p>A URL that links to a page about the current finding in the security-findings provider\'s solution.</p>', 'AwsSecurityFindingIdentifier$Id' => '<p>The identifier of the finding that was specified by the finding provider.</p>', 'AwsSecurityFindingIdentifier$ProductArn' => '<p>The ARN generated by Security Hub that uniquely identifies a product that generates findings. This can be the ARN for a third-party product that is integrated with Security Hub, or the ARN for a custom integration.</p>', 'AwsSnsTopicDetails$KmsMasterKeyId' => '<p>The ID of an AWS managed customer master key (CMK) for Amazon SNS or a custom CMK.</p>', 'AwsSnsTopicDetails$TopicName' => '<p>The name of the topic.</p>', 'AwsSnsTopicDetails$Owner' => '<p>The subscription\'s owner.</p>', 'AwsSnsTopicSubscription$Endpoint' => '<p>The subscription\'s endpoint (format depends on the protocol).</p>', 'AwsSnsTopicSubscription$Protocol' => '<p>The subscription\'s protocol.</p>', 'AwsSqsQueueDetails$KmsMasterKeyId' => '<p>The ID of an AWS managed customer master key (CMK) for Amazon SQS or a custom CMK.</p>', 'AwsSqsQueueDetails$QueueName' => '<p>The name of the new queue.</p>', 'AwsSqsQueueDetails$DeadLetterTargetArn' => '<p>The Amazon Resource Name (ARN) of the dead-letter queue to which Amazon SQS moves messages after the value of <code>maxReceiveCount</code> is exceeded. </p>', 'AwsWafWebAclDetails$Name' => '<p>A friendly name or description of the WebACL. You can\'t change the name of a WebACL after you create it.</p>', 'AwsWafWebAclDetails$DefaultAction' => '<p>The action to perform if none of the rules contained in the WebACL match.</p>', 'AwsWafWebAclDetails$WebAclId' => '<p>A unique identifier for a WebACL.</p>', 'AwsWafWebAclRule$RuleId' => '<p>The identifier for a rule.</p>', 'AwsWafWebAclRule$Type' => '<p>The rule type.</p> <p>Valid values: <code>REGULAR</code> | <code>RATE_BASED</code> | <code>GROUP</code> </p> <p>The default is <code>REGULAR</code>.</p>', 'BatchUpdateFindingsUnprocessedFinding$ErrorCode' => '<p>The code associated with the error.</p>', 'BatchUpdateFindingsUnprocessedFinding$ErrorMessage' => '<p>The message associated with the error.</p>', 'CategoryList$member' => NULL, 'CidrBlockAssociation$AssociationId' => '<p>The association ID for the IPv4 CIDR block.</p>', 'CidrBlockAssociation$CidrBlock' => '<p>The IPv4 CIDR block.</p>', 'CidrBlockAssociation$CidrBlockState' => '<p>Information about the state of the IPv4 CIDR block.</p>', 'ContainerDetails$Name' => '<p>The name of the container related to a finding.</p>', 'ContainerDetails$ImageId' => '<p>The identifier of the image related to a finding.</p>', 'ContainerDetails$ImageName' => '<p>The name of the image related to a finding.</p>', 'ContainerDetails$LaunchedAt' => '<p>The date and time when the container started.</p>', 'CreateActionTargetRequest$Name' => '<p>The name of the custom action target.</p>', 'CreateActionTargetRequest$Description' => '<p>The description for the custom action target.</p>', 'CreateActionTargetRequest$Id' => '<p>The ID for the custom action target.</p>', 'CreateActionTargetResponse$ActionTargetArn' => '<p>The ARN for the custom action target.</p>', 'CreateInsightRequest$Name' => '<p>The name of the custom insight to create.</p>', 'CreateInsightRequest$GroupByAttribute' => '<p>The attribute used to group the findings for the insight. The grouping attribute identifies the type of item that the insight applies to. For example, if an insight is grouped by resource identifier, then the insight produces a list of resource identifiers.</p>', 'CreateInsightResponse$InsightArn' => '<p>The ARN of the insight created.</p>', 'Cvss$Version' => '<p>The version of CVSS for the CVSS score.</p>', 'Cvss$BaseVector' => '<p>The base scoring vector for the CVSS score.</p>', 'DateFilter$Start' => '<p>A start date for the date filter.</p>', 'DateFilter$End' => '<p>An end date for the date filter.</p>', 'DeleteActionTargetRequest$ActionTargetArn' => '<p>The ARN of the custom action target to delete.</p>', 'DeleteActionTargetResponse$ActionTargetArn' => '<p>The ARN of the custom action target that was deleted.</p>', 'DeleteInsightRequest$InsightArn' => '<p>The ARN of the insight to delete.</p>', 'DeleteInsightResponse$InsightArn' => '<p>The ARN of the insight that was deleted.</p>', 'DescribeHubRequest$HubArn' => '<p>The ARN of the Hub resource to retrieve.</p>', 'DescribeHubResponse$HubArn' => '<p>The ARN of the Hub resource that was retrieved.</p>', 'DescribeHubResponse$SubscribedAt' => '<p>The date and time when Security Hub was enabled in the account.</p>', 'DescribeStandardsControlsRequest$StandardsSubscriptionArn' => '<p>The ARN of a resource that represents your subscription to a supported standard.</p>', 'DisableImportFindingsForProductRequest$ProductSubscriptionArn' => '<p>The ARN of the integrated product to disable the integration for.</p>', 'EnableImportFindingsForProductRequest$ProductArn' => '<p>The ARN of the product to enable the integration for.</p>', 'EnableImportFindingsForProductResponse$ProductSubscriptionArn' => '<p>The ARN of your subscription to the product to enable integrations for.</p>', 'FieldMap$key' => NULL, 'FieldMap$value' => NULL, 'GetInsightResultsRequest$InsightArn' => '<p>The ARN of the insight for which to return results.</p>', 'ImportFindingsError$Id' => '<p>The identifier of the finding that could not be updated.</p>', 'ImportFindingsError$ErrorCode' => '<p>The code of the error returned by the <code>BatchImportFindings</code> operation.</p>', 'ImportFindingsError$ErrorMessage' => '<p>The message of the error returned by the <code>BatchImportFindings</code> operation.</p>', 'Insight$InsightArn' => '<p>The ARN of a Security Hub insight.</p>', 'Insight$Name' => '<p>The name of a Security Hub insight.</p>', 'Insight$GroupByAttribute' => '<p>The grouping attribute for the insight\'s findings. Indicates how to group the matching findings, and identifies the type of item that the insight applies to. For example, if an insight is grouped by resource identifier, then the insight produces a list of resource identifiers.</p>', 'InsightResultValue$GroupByAttributeValue' => '<p>The value of the attribute that the findings are grouped by for the insight whose results are returned by the <code>GetInsightResults</code> operation.</p>', 'InsightResults$InsightArn' => '<p>The ARN of the insight whose results are returned by the <code>GetInsightResults</code> operation.</p>', 'InsightResults$GroupByAttribute' => '<p>The attribute that the findings are grouped by for the insight whose results are returned by the <code>GetInsightResults</code> operation.</p>', 'InternalException$Message' => NULL, 'InternalException$Code' => NULL, 'InvalidAccessException$Message' => NULL, 'InvalidAccessException$Code' => NULL, 'InvalidInputException$Message' => NULL, 'InvalidInputException$Code' => NULL, 'Invitation$InvitationId' => '<p>The ID of the invitation sent to the member account.</p>', 'Invitation$MemberStatus' => '<p>The current status of the association between the member and master accounts.</p>', 'IpFilter$Cidr' => '<p>A finding\'s CIDR value.</p>', 'Ipv6CidrBlockAssociation$AssociationId' => '<p>The association ID for the IPv6 CIDR block.</p>', 'Ipv6CidrBlockAssociation$Ipv6CidrBlock' => '<p>The IPv6 CIDR block.</p>', 'Ipv6CidrBlockAssociation$CidrBlockState' => '<p>Information about the state of the CIDR block.</p>', 'KeywordFilter$Value' => '<p>A value for the keyword.</p>', 'LimitExceededException$Message' => NULL, 'LimitExceededException$Code' => NULL, 'ListInvitationsResponse$NextToken' => '<p>The pagination token to use to request the next page of results.</p>', 'ListMembersResponse$NextToken' => '<p>The pagination token to use to request the next page of results.</p>', 'LoadBalancerState$Code' => '<p>The state code. The initial state of the load balancer is provisioning.</p> <p>After the load balancer is fully set up and ready to route traffic, its state is active.</p> <p>If the load balancer could not be set up, its state is failed. </p>', 'LoadBalancerState$Reason' => '<p>A description of the state.</p>', 'Malware$Name' => '<p>The name of the malware that was observed.</p>', 'Malware$Path' => '<p>The file system path of the malware that was observed.</p>', 'MapFilter$Key' => '<p>The key of the map filter.</p>', 'MapFilter$Value' => '<p>The value for the key in the map filter.</p>', 'Member$Email' => '<p>The email address of the member account.</p>', 'Member$MasterId' => '<p>The AWS account ID of the Security Hub master account associated with this member account.</p>', 'Member$MemberStatus' => '<p>The status of the relationship between the member account and its master account. </p>', 'Network$Protocol' => '<p>The protocol of network-related information about a finding.</p>', 'Network$SourceIpV4' => '<p>The source IPv4 address of network-related information about a finding.</p>', 'Network$SourceIpV6' => '<p>The source IPv6 address of network-related information about a finding.</p>', 'Network$SourceDomain' => '<p>The source domain of network-related information about a finding.</p>', 'Network$SourceMac' => '<p>The source media access control (MAC) address of network-related information about a finding.</p>', 'Network$DestinationIpV4' => '<p>The destination IPv4 address of network-related information about a finding.</p>', 'Network$DestinationIpV6' => '<p>The destination IPv6 address of network-related information about a finding.</p>', 'Network$DestinationDomain' => '<p>The destination domain of network-related information about a finding.</p>', 'NetworkHeader$Protocol' => '<p>The protocol used for the component.</p>', 'NetworkPathComponent$ComponentId' => '<p>The identifier of a component in the network path.</p>', 'NetworkPathComponent$ComponentType' => '<p>The type of component.</p>', 'NonEmptyStringList$member' => NULL, 'Note$Text' => '<p>The text of a note.</p>', 'Note$UpdatedBy' => '<p>The principal that created a note.</p>', 'Note$UpdatedAt' => '<p>The timestamp of when the note was updated.</p>', 'NoteUpdate$Text' => '<p>The updated note text.</p>', 'NoteUpdate$UpdatedBy' => '<p>The principal that updated the note.</p>', 'ProcessDetails$Name' => '<p>The name of the process.</p>', 'ProcessDetails$Path' => '<p>The path to the process executable.</p>', 'ProcessDetails$LaunchedAt' => '<p>The date/time that the process was launched.</p>', 'ProcessDetails$TerminatedAt' => '<p>The date and time when the process was terminated.</p>', 'Product$ProductArn' => '<p>The ARN assigned to the product.</p>', 'Product$ProductName' => '<p>The name of the product.</p>', 'Product$CompanyName' => '<p>The name of the company that provides the product.</p>', 'Product$Description' => '<p>A description of the product.</p>', 'Product$MarketplaceUrl' => '<p>The URL for the page that contains more information about the product.</p>', 'Product$ActivationUrl' => '<p>The URL used to activate the product.</p>', 'Product$ProductSubscriptionResourcePolicy' => '<p>The resource policy associated with the product.</p>', 'ProductSubscriptionArnList$member' => NULL, 'Recommendation$Text' => '<p>Describes the recommended steps to take to remediate an issue identified in a finding.</p>', 'Recommendation$Url' => '<p>A URL to a page or site that contains information about how to remediate a finding.</p>', 'RelatedFinding$ProductArn' => '<p>The ARN of the product that generated a related finding.</p>', 'RelatedFinding$Id' => '<p>The product-generated identifier for a related finding.</p>', 'RelatedRequirementsList$member' => NULL, 'Resource$Type' => '<p>The type of the resource that details are provided for. If possible, set <code>Type</code> to one of the supported resource types. For example, if the resource is an EC2 instance, then set <code>Type</code> to <code>AwsEc2Instance</code>.</p> <p>If the resource does not match any of the provided types, then set <code>Type</code> to <code>Other</code>. </p>', 'Resource$Id' => '<p>The canonical identifier for the given resource type.</p>', 'Resource$Region' => '<p>The canonical AWS external Region name where this resource is located.</p>', 'ResourceConflictException$Message' => NULL, 'ResourceConflictException$Code' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ResourceNotFoundException$Code' => NULL, 'Result$ProcessingResult' => '<p>The reason that the account was not processed.</p>', 'SecurityGroups$member' => NULL, 'Severity$Original' => '<p>The native severity from the finding product that generated the finding.</p>', 'SoftwarePackage$Name' => '<p>The name of the software package.</p>', 'SoftwarePackage$Version' => '<p>The version of the software package.</p>', 'SoftwarePackage$Epoch' => '<p>The epoch of the software package.</p>', 'SoftwarePackage$Release' => '<p>The release of the software package.</p>', 'SoftwarePackage$Architecture' => '<p>The architecture used for the software package.</p>', 'SortCriterion$Field' => '<p>The finding attribute used to sort findings.</p>', 'Standard$StandardsArn' => '<p>The ARN of a standard.</p>', 'Standard$Name' => '<p>The name of the standard.</p>', 'Standard$Description' => '<p>A description of the standard.</p>', 'StandardsControl$StandardsControlArn' => '<p>The ARN of the security standard control.</p>', 'StandardsControl$DisabledReason' => '<p>The reason provided for the most recent change in status for the control.</p>', 'StandardsControl$ControlId' => '<p>The identifier of the security standard control.</p>', 'StandardsControl$Title' => '<p>The title of the security standard control.</p>', 'StandardsControl$Description' => '<p>The longer description of the security standard control. Provides information about what the control is checking for.</p>', 'StandardsControl$RemediationUrl' => '<p>A link to remediation information for the control in the Security Hub user documentation.</p>', 'StandardsInputParameterMap$key' => NULL, 'StandardsInputParameterMap$value' => NULL, 'StandardsSubscription$StandardsSubscriptionArn' => '<p>The ARN of a resource that represents your subscription to a supported standard.</p>', 'StandardsSubscription$StandardsArn' => '<p>The ARN of a standard.</p>', 'StandardsSubscriptionArns$member' => NULL, 'StandardsSubscriptionRequest$StandardsArn' => '<p>The ARN of the standard that you want to enable. To view the list of available standards and their ARNs, use the <code> <a>DescribeStandards</a> </code> operation.</p>', 'StatusReason$ReasonCode' => '<p>A code that represents a reason for the control status. For the list of status reason codes and their meanings, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff">Standards-related information in the ASFF</a> in the <i>AWS Security Hub User Guide</i>. </p>', 'StatusReason$Description' => '<p>The corresponding description for the status reason code.</p>', 'StringFilter$Value' => '<p>The string filter value.</p>', 'StringList$member' => NULL, 'ThreatIntelIndicator$Value' => '<p>The value of a threat intelligence indicator.</p>', 'ThreatIntelIndicator$LastObservedAt' => '<p>The date and time when the most recent instance of a threat intelligence indicator was observed.</p>', 'ThreatIntelIndicator$Source' => '<p>The source of the threat intelligence indicator.</p>', 'ThreatIntelIndicator$SourceUrl' => '<p>The URL to the page or site where you can get more information about the threat intelligence indicator.</p>', 'TypeList$member' => NULL, 'UpdateActionTargetRequest$ActionTargetArn' => '<p>The ARN of the custom action target to update.</p>', 'UpdateActionTargetRequest$Name' => '<p>The updated name of the custom action target.</p>', 'UpdateActionTargetRequest$Description' => '<p>The updated description for the custom action target.</p>', 'UpdateInsightRequest$InsightArn' => '<p>The ARN of the insight that you want to update.</p>', 'UpdateInsightRequest$Name' => '<p>The updated name for the insight.</p>', 'UpdateInsightRequest$GroupByAttribute' => '<p>The updated <code>GroupBy</code> attribute that defines this insight.</p>', 'UpdateStandardsControlRequest$StandardsControlArn' => '<p>The ARN of the security standard control to enable or disable.</p>', 'UpdateStandardsControlRequest$DisabledReason' => '<p>A description of the reason why you are disabling a security standard control. If you are disabling a control, then this is required.</p>', 'Vulnerability$Id' => '<p>The identifier of the vulnerability.</p>', 'VulnerabilityVendor$Name' => '<p>The name of the vendor.</p>', 'VulnerabilityVendor$Url' => '<p>The URL of the vulnerability advisory.</p>', 'VulnerabilityVendor$VendorSeverity' => '<p>The severity that the vendor assigned to the vulnerability.</p>', 'VulnerabilityVendor$VendorCreatedAt' => '<p>The datetime when the vulnerability advisory was created.</p>', 'VulnerabilityVendor$VendorUpdatedAt' => '<p>The datetime when the vulnerability advisory was last updated.</p>', 'WafAction$Type' => '<p>Specifies how you want AWS WAF to respond to requests that match the settings in a rule.</p> <p>Valid settings include the following:</p> <ul> <li> <p> <code>ALLOW</code> - AWS WAF allows requests</p> </li> <li> <p> <code>BLOCK</code> - AWS WAF blocks requests</p> </li> <li> <p> <code>COUNT</code> - AWS WAF increments a counter of the requests that match all of the conditions in the rule. AWS WAF then continues to inspect the web request based on the remaining rules in the web ACL. You can\'t specify <code>COUNT</code> for the default action for a WebACL.</p> </li> </ul>', 'WafExcludedRule$RuleId' => '<p>The unique identifier for the rule to exclude from the rule group.</p>', 'WafOverrideAction$Type' => '<p> <code>COUNT</code> overrides the action specified by the individual rule within a <code>RuleGroup</code> .</p> <p>If set to <code>NONE</code>, the rule\'s action takes place.</p>', ], ], 'NonEmptyStringList' => [ 'base' => NULL, 'refs' => [ 'AwsCodeBuildProjectVpcConfig$Subnets' => '<p>A list of one or more subnet IDs in your Amazon VPC.</p>', 'AwsCodeBuildProjectVpcConfig$SecurityGroupIds' => '<p>A list of one or more security group IDs in your Amazon VPC.</p>', 'AwsElasticsearchDomainVPCOptions$AvailabilityZones' => '<p>The list of Availability Zones associated with the VPC subnets.</p>', 'AwsElasticsearchDomainVPCOptions$SecurityGroupIds' => '<p>The list of security group IDs associated with the VPC endpoints for the domain.</p>', 'AwsElasticsearchDomainVPCOptions$SubnetIds' => '<p>A list of subnet IDs associated with the VPC endpoints for the domain.</p>', 'AwsLambdaFunctionVpcConfig$SecurityGroupIds' => '<p>A list of VPC security groups IDs.</p>', 'AwsLambdaFunctionVpcConfig$SubnetIds' => '<p>A list of VPC subnet IDs.</p>', 'AwsLambdaLayerVersionDetails$CompatibleRuntimes' => '<p>The layer\'s compatible runtimes. Maximum number of five items.</p> <p>Valid values: <code>nodejs10.x</code> | <code>nodejs12.x</code> | <code>java8</code> | <code>java11</code> | <code>python2.7</code> | <code>python3.6</code> | <code>python3.7</code> | <code>python3.8</code> | <code>dotnetcore1.0</code> | <code>dotnetcore2.1</code> | <code>go1.x</code> | <code>ruby2.5</code> | <code>provided</code> </p>', ], ], 'Note' => [ 'base' => '<p>A user-defined note added to a finding.</p>', 'refs' => [ 'AwsSecurityFinding$Note' => '<p>A user-defined note added to a finding.</p>', ], ], 'NoteUpdate' => [ 'base' => '<p>The updated note.</p>', 'refs' => [ 'BatchUpdateFindingsRequest$Note' => NULL, 'UpdateFindingsRequest$Note' => '<p>The updated note for the finding.</p>', ], ], 'NumberFilter' => [ 'base' => '<p>A number filter for querying findings.</p>', 'refs' => [ 'NumberFilterList$member' => NULL, ], ], 'NumberFilterList' => [ 'base' => NULL, 'refs' => [ 'AwsSecurityFindingFilters$SeverityProduct' => '<p>The native severity as defined by the security-findings provider\'s solution that generated the finding.</p>', 'AwsSecurityFindingFilters$SeverityNormalized' => '<p>The normalized severity of a finding.</p>', 'AwsSecurityFindingFilters$Confidence' => '<p>A finding\'s confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.</p> <p>Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.</p>', 'AwsSecurityFindingFilters$Criticality' => '<p>The level of importance assigned to the resources associated with the finding.</p> <p>A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.</p>', 'AwsSecurityFindingFilters$NetworkSourcePort' => '<p>The source port of network-related information about a finding.</p>', 'AwsSecurityFindingFilters$NetworkDestinationPort' => '<p>The destination port of network-related information about a finding.</p>', 'AwsSecurityFindingFilters$ProcessPid' => '<p>The process ID.</p>', 'AwsSecurityFindingFilters$ProcessParentPid' => '<p>The parent process ID.</p>', ], ], 'Partition' => [ 'base' => NULL, 'refs' => [ 'Resource$Partition' => '<p>The canonical AWS partition name that the Region is assigned to.</p>', ], ], 'PortRange' => [ 'base' => '<p>A range of ports.</p>', 'refs' => [ 'Network$OpenPortRange' => '<p>The range of open ports that is present on the network.</p>', 'PortRangeList$member' => NULL, ], ], 'PortRangeList' => [ 'base' => NULL, 'refs' => [ 'NetworkPathComponentDetails$PortRanges' => '<p>A list of port ranges for the destination.</p>', ], ], 'ProcessDetails' => [ 'base' => '<p>The details of process-related information about a finding.</p>', 'refs' => [ 'AwsSecurityFinding$Process' => '<p>The details of process-related information about a finding.</p>', ], ], 'Product' => [ 'base' => '<p>Contains details about a product.</p>', 'refs' => [ 'ProductsList$member' => NULL, ], ], 'ProductSubscriptionArnList' => [ 'base' => NULL, 'refs' => [ 'ListEnabledProductsForImportResponse$ProductSubscriptions' => '<p>The list of ARNs for the resources that represent your subscriptions to products. </p>', ], ], 'ProductsList' => [ 'base' => NULL, 'refs' => [ 'DescribeProductsResponse$Products' => '<p>A list of products, including details for each product.</p>', ], ], 'RatioScale' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateFindingsRequest$Confidence' => '<p>The updated value for the finding confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.</p> <p>Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.</p>', 'BatchUpdateFindingsRequest$Criticality' => '<p>The updated value for the level of importance assigned to the resources associated with the findings.</p> <p>A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources. </p>', 'SeverityUpdate$Normalized' => '<p>The normalized severity for the finding. This attribute is to be deprecated in favor of <code>Label</code>.</p> <p>If you provide <code>Normalized</code> and do not provide <code>Label</code>, <code>Label</code> is set automatically as follows.</p> <ul> <li> <p>0 - <code>INFORMATIONAL</code> </p> </li> <li> <p>1–39 - <code>LOW</code> </p> </li> <li> <p>40–69 - <code>MEDIUM</code> </p> </li> <li> <p>70–89 - <code>HIGH</code> </p> </li> <li> <p>90–100 - <code>CRITICAL</code> </p> </li> </ul>', ], ], 'Recommendation' => [ 'base' => '<p>A recommendation on how to remediate the issue identified in a finding.</p>', 'refs' => [ 'Remediation$Recommendation' => '<p>A recommendation on the steps to take to remediate the issue identified by a finding.</p>', ], ], 'RecordState' => [ 'base' => NULL, 'refs' => [ 'AwsSecurityFinding$RecordState' => '<p>The record state of a finding.</p>', 'UpdateFindingsRequest$RecordState' => '<p>The updated record state for the finding.</p>', ], ], 'RelatedFinding' => [ 'base' => '<p>Details about a related finding.</p>', 'refs' => [ 'RelatedFindingList$member' => NULL, ], ], 'RelatedFindingList' => [ 'base' => NULL, 'refs' => [ 'AwsSecurityFinding$RelatedFindings' => '<p>A list of related findings.</p>', 'BatchUpdateFindingsRequest$RelatedFindings' => '<p>A list of findings that are related to the updated findings.</p>', ], ], 'RelatedRequirementsList' => [ 'base' => NULL, 'refs' => [ 'Compliance$RelatedRequirements' => '<p>For a control, the industry or regulatory framework requirements that are related to the control. The check for that control is aligned with these requirements.</p>', 'StandardsControl$RelatedRequirements' => '<p>The list of requirements that are related to this control.</p>', ], ], 'Remediation' => [ 'base' => '<p>Details about the remediation steps for a finding.</p>', 'refs' => [ 'AwsSecurityFinding$Remediation' => '<p>A data type that describes the remediation options for a finding.</p>', ], ], 'Resource' => [ 'base' => '<p>A resource related to a finding.</p>', 'refs' => [ 'ResourceList$member' => NULL, ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p>The ARN of the resource to retrieve tags for.</p>', 'TagResourceRequest$ResourceArn' => '<p>The ARN of the resource to apply the tags to.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The ARN of the resource to remove the tags from.</p>', ], ], 'ResourceConflictException' => [ 'base' => '<p>The resource specified in the request conflicts with an existing resource.</p>', 'refs' => [], ], 'ResourceDetails' => [ 'base' => '<p>Additional details about a resource related to a finding.</p> <p>To provide the details, use the object that corresponds to the resource type. For example, if the resource type is <code>AwsEc2Instance</code>, then you use the <code>AwsEc2Instance</code> object to provide the details.</p> <p>If the type-specific object does not contain all of the fields you want to populate, then you use the <code>Other</code> object to populate those additional fields.</p> <p>You also use the <code>Other</code> object to populate the details when the selected type does not have a corresponding object.</p>', 'refs' => [ 'Resource$Details' => '<p>Additional details about the resource related to a finding.</p>', ], ], 'ResourceList' => [ 'base' => NULL, 'refs' => [ 'AwsSecurityFinding$Resources' => '<p>A set of resource data types that describe the resources that the finding refers to.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The request was rejected because we can\'t find the specified resource.</p>', 'refs' => [], ], 'Result' => [ 'base' => '<p>Details about the account that was not processed.</p>', 'refs' => [ 'ResultList$member' => NULL, ], ], 'ResultList' => [ 'base' => NULL, 'refs' => [ 'CreateMembersResponse$UnprocessedAccounts' => '<p>The list of AWS accounts that were not processed. For each account, the list includes the account ID and the email address.</p>', 'DeclineInvitationsResponse$UnprocessedAccounts' => '<p>The list of AWS accounts that were not processed. For each account, the list includes the account ID and the email address.</p>', 'DeleteInvitationsResponse$UnprocessedAccounts' => '<p>The list of AWS accounts for which the invitations were not deleted. For each account, the list includes the account ID and the email address.</p>', 'DeleteMembersResponse$UnprocessedAccounts' => '<p>The list of AWS accounts that were not deleted. For each account, the list includes the account ID and the email address.</p>', 'GetMembersResponse$UnprocessedAccounts' => '<p>The list of AWS accounts that could not be processed. For each account, the list includes the account ID and the email address.</p>', 'InviteMembersResponse$UnprocessedAccounts' => '<p>The list of AWS accounts that could not be processed. For each account, the list includes the account ID and the email address.</p>', ], ], 'SecurityGroups' => [ 'base' => NULL, 'refs' => [ 'AwsElbv2LoadBalancerDetails$SecurityGroups' => '<p>The IDs of the security groups for the load balancer.</p>', ], ], 'Severity' => [ 'base' => '<p>The severity of the finding.</p> <p>The finding provider can provide the initial severity, but cannot update it after that. The severity can only be updated by a master account. It cannot be updated by a member account.</p> <p>The finding must have either <code>Label</code> or <code>Normalized</code> populated. If only one of these attributes is populated, then Security Hub automatically populates the other one. If neither attribute is populated, then the finding is invalid. <code>Label</code> is the preferred attribute.</p>', 'refs' => [ 'AwsSecurityFinding$Severity' => '<p>A finding\'s severity.</p>', ], ], 'SeverityLabel' => [ 'base' => NULL, 'refs' => [ 'Severity$Label' => '<p>The severity value of the finding. The allowed values are the following.</p> <ul> <li> <p> <code>INFORMATIONAL</code> - No issue was found.</p> </li> <li> <p> <code>LOW</code> - The issue does not require action on its own.</p> </li> <li> <p> <code>MEDIUM</code> - The issue must be addressed but not urgently.</p> </li> <li> <p> <code>HIGH</code> - The issue must be addressed as a priority.</p> </li> <li> <p> <code>CRITICAL</code> - The issue must be remediated immediately to avoid it escalating.</p> </li> </ul> <p>If you provide <code>Normalized</code> and do not provide <code>Label</code>, then <code>Label</code> is set automatically as follows. </p> <ul> <li> <p>0 - <code>INFORMATIONAL</code> </p> </li> <li> <p>1–39 - <code>LOW</code> </p> </li> <li> <p>40–69 - <code>MEDIUM</code> </p> </li> <li> <p>70–89 - <code>HIGH</code> </p> </li> <li> <p>90–100 - <code>CRITICAL</code> </p> </li> </ul>', 'SeverityUpdate$Label' => '<p>The severity value of the finding. The allowed values are the following.</p> <ul> <li> <p> <code>INFORMATIONAL</code> - No issue was found.</p> </li> <li> <p> <code>LOW</code> - The issue does not require action on its own.</p> </li> <li> <p> <code>MEDIUM</code> - The issue must be addressed but not urgently.</p> </li> <li> <p> <code>HIGH</code> - The issue must be addressed as a priority.</p> </li> <li> <p> <code>CRITICAL</code> - The issue must be remediated immediately to avoid it escalating.</p> </li> </ul>', ], ], 'SeverityRating' => [ 'base' => NULL, 'refs' => [ 'StandardsControl$SeverityRating' => '<p>The severity of findings generated from this security standard control.</p> <p>The finding severity is based on an assessment of how easy it would be to compromise AWS resources if the issue is detected.</p>', ], ], 'SeverityUpdate' => [ 'base' => '<p>Updates to the severity information for a finding.</p>', 'refs' => [ 'BatchUpdateFindingsRequest$Severity' => '<p>Used to update the finding severity.</p>', ], ], 'SoftwarePackage' => [ 'base' => '<p>Information about a software package.</p>', 'refs' => [ 'SoftwarePackageList$member' => NULL, ], ], 'SoftwarePackageList' => [ 'base' => NULL, 'refs' => [ 'Vulnerability$VulnerablePackages' => '<p>List of software packages that have the vulnerability.</p>', ], ], 'SortCriteria' => [ 'base' => NULL, 'refs' => [ 'GetFindingsRequest$SortCriteria' => '<p>The finding attributes used to sort the list of returned findings.</p>', ], ], 'SortCriterion' => [ 'base' => '<p>A collection of finding attributes used to sort findings.</p>', 'refs' => [ 'SortCriteria$member' => NULL, ], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'SortCriterion$SortOrder' => '<p>The order used to sort findings.</p>', ], ], 'Standard' => [ 'base' => '<p>Provides information about a specific standard.</p>', 'refs' => [ 'Standards$member' => NULL, ], ], 'Standards' => [ 'base' => NULL, 'refs' => [ 'DescribeStandardsResponse$Standards' => '<p>A list of available standards.</p>', ], ], 'StandardsControl' => [ 'base' => '<p>Details for an individual security standard control.</p>', 'refs' => [ 'StandardsControls$member' => NULL, ], ], 'StandardsControls' => [ 'base' => NULL, 'refs' => [ 'DescribeStandardsControlsResponse$Controls' => '<p>A list of security standards controls.</p>', ], ], 'StandardsInputParameterMap' => [ 'base' => NULL, 'refs' => [ 'StandardsSubscription$StandardsInput' => '<p>A key-value pair of input for the standard.</p>', 'StandardsSubscriptionRequest$StandardsInput' => '<p>A key-value pair of input for the standard.</p>', ], ], 'StandardsStatus' => [ 'base' => NULL, 'refs' => [ 'StandardsSubscription$StandardsStatus' => '<p>The status of the standards subscription.</p>', ], ], 'StandardsSubscription' => [ 'base' => '<p>A resource that represents your subscription to a supported standard.</p>', 'refs' => [ 'StandardsSubscriptions$member' => NULL, ], ], 'StandardsSubscriptionArns' => [ 'base' => NULL, 'refs' => [ 'BatchDisableStandardsRequest$StandardsSubscriptionArns' => '<p>The ARNs of the standards subscriptions to disable.</p>', 'GetEnabledStandardsRequest$StandardsSubscriptionArns' => '<p>The list of the standards subscription ARNs for the standards to retrieve.</p>', ], ], 'StandardsSubscriptionRequest' => [ 'base' => '<p>The standard that you want to enable.</p>', 'refs' => [ 'StandardsSubscriptionRequests$member' => NULL, ], ], 'StandardsSubscriptionRequests' => [ 'base' => NULL, 'refs' => [ 'BatchEnableStandardsRequest$StandardsSubscriptionRequests' => '<p>The list of standards checks to enable.</p>', ], ], 'StandardsSubscriptions' => [ 'base' => NULL, 'refs' => [ 'BatchDisableStandardsResponse$StandardsSubscriptions' => '<p>The details of the standards subscriptions that were disabled.</p>', 'BatchEnableStandardsResponse$StandardsSubscriptions' => '<p>The details of the standards subscriptions that were enabled.</p>', 'GetEnabledStandardsResponse$StandardsSubscriptions' => '<p>The list of <code>StandardsSubscriptions</code> objects that include information about the enabled standards.</p>', ], ], 'StatusReason' => [ 'base' => '<p>Provides additional context for the value of <code>Compliance.Status</code>.</p>', 'refs' => [ 'StatusReasonsList$member' => NULL, ], ], 'StatusReasonsList' => [ 'base' => NULL, 'refs' => [ 'Compliance$StatusReasons' => '<p>For findings generated from controls, a list of reasons behind the value of <code>Status</code>. For the list of status reason codes and their meanings, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff">Standards-related information in the ASFF</a> in the <i>AWS Security Hub User Guide</i>. </p>', ], ], 'StringFilter' => [ 'base' => '<p>A string filter for querying findings.</p>', 'refs' => [ 'StringFilterList$member' => NULL, ], ], 'StringFilterComparison' => [ 'base' => NULL, 'refs' => [ 'StringFilter$Comparison' => '<p>The condition to be applied to a string value when querying for findings. </p>', ], ], 'StringFilterList' => [ 'base' => NULL, 'refs' => [ 'AwsSecurityFindingFilters$ProductArn' => '<p>The ARN generated by Security Hub that uniquely identifies a third-party company (security findings provider) after this provider\'s product (solution that generates findings) is registered with Security Hub.</p>', 'AwsSecurityFindingFilters$AwsAccountId' => '<p>The AWS account ID that a finding is generated in.</p>', 'AwsSecurityFindingFilters$Id' => '<p>The security findings provider-specific identifier for a finding.</p>', 'AwsSecurityFindingFilters$GeneratorId' => '<p>The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In various security-findings providers\' solutions, this generator can be called a rule, a check, a detector, a plugin, etc.</p>', 'AwsSecurityFindingFilters$Type' => '<p>A finding type in the format of <code>namespace/category/classifier</code> that classifies a finding.</p>', 'AwsSecurityFindingFilters$SeverityLabel' => '<p>The label of a finding\'s severity.</p>', 'AwsSecurityFindingFilters$Title' => '<p>A finding\'s title.</p>', 'AwsSecurityFindingFilters$Description' => '<p>A finding\'s description.</p>', 'AwsSecurityFindingFilters$RecommendationText' => '<p>The recommendation of what to do about the issue described in a finding.</p>', 'AwsSecurityFindingFilters$SourceUrl' => '<p>A URL that links to a page about the current finding in the security-findings provider\'s solution.</p>', 'AwsSecurityFindingFilters$ProductName' => '<p>The name of the solution (product) that generates findings.</p>', 'AwsSecurityFindingFilters$CompanyName' => '<p>The name of the findings provider (company) that owns the solution (product) that generates findings.</p>', 'AwsSecurityFindingFilters$MalwareName' => '<p>The name of the malware that was observed.</p>', 'AwsSecurityFindingFilters$MalwareType' => '<p>The type of the malware that was observed.</p>', 'AwsSecurityFindingFilters$MalwarePath' => '<p>The filesystem path of the malware that was observed.</p>', 'AwsSecurityFindingFilters$MalwareState' => '<p>The state of the malware that was observed.</p>', 'AwsSecurityFindingFilters$NetworkDirection' => '<p>Indicates the direction of network traffic associated with a finding.</p>', 'AwsSecurityFindingFilters$NetworkProtocol' => '<p>The protocol of network-related information about a finding.</p>', 'AwsSecurityFindingFilters$NetworkSourceDomain' => '<p>The source domain of network-related information about a finding.</p>', 'AwsSecurityFindingFilters$NetworkSourceMac' => '<p>The source media access control (MAC) address of network-related information about a finding.</p>', 'AwsSecurityFindingFilters$NetworkDestinationDomain' => '<p>The destination domain of network-related information about a finding.</p>', 'AwsSecurityFindingFilters$ProcessName' => '<p>The name of the process.</p>', 'AwsSecurityFindingFilters$ProcessPath' => '<p>The path to the process executable.</p>', 'AwsSecurityFindingFilters$ThreatIntelIndicatorType' => '<p>The type of a threat intelligence indicator.</p>', 'AwsSecurityFindingFilters$ThreatIntelIndicatorValue' => '<p>The value of a threat intelligence indicator.</p>', 'AwsSecurityFindingFilters$ThreatIntelIndicatorCategory' => '<p>The category of a threat intelligence indicator.</p>', 'AwsSecurityFindingFilters$ThreatIntelIndicatorSource' => '<p>The source of the threat intelligence.</p>', 'AwsSecurityFindingFilters$ThreatIntelIndicatorSourceUrl' => '<p>The URL for more details from the source of the threat intelligence.</p>', 'AwsSecurityFindingFilters$ResourceType' => '<p>Specifies the type of the resource that details are provided for.</p>', 'AwsSecurityFindingFilters$ResourceId' => '<p>The canonical identifier for the given resource type.</p>', 'AwsSecurityFindingFilters$ResourcePartition' => '<p>The canonical AWS partition name that the Region is assigned to.</p>', 'AwsSecurityFindingFilters$ResourceRegion' => '<p>The canonical AWS external Region name where this resource is located.</p>', 'AwsSecurityFindingFilters$ResourceAwsEc2InstanceType' => '<p>The instance type of the instance.</p>', 'AwsSecurityFindingFilters$ResourceAwsEc2InstanceImageId' => '<p>The Amazon Machine Image (AMI) ID of the instance.</p>', 'AwsSecurityFindingFilters$ResourceAwsEc2InstanceKeyName' => '<p>The key name associated with the instance.</p>', 'AwsSecurityFindingFilters$ResourceAwsEc2InstanceIamInstanceProfileArn' => '<p>The IAM profile ARN of the instance.</p>', 'AwsSecurityFindingFilters$ResourceAwsEc2InstanceVpcId' => '<p>The identifier of the VPC that the instance was launched in.</p>', 'AwsSecurityFindingFilters$ResourceAwsEc2InstanceSubnetId' => '<p>The identifier of the subnet that the instance was launched in.</p>', 'AwsSecurityFindingFilters$ResourceAwsS3BucketOwnerId' => '<p>The canonical user ID of the owner of the S3 bucket.</p>', 'AwsSecurityFindingFilters$ResourceAwsS3BucketOwnerName' => '<p>The display name of the owner of the S3 bucket.</p>', 'AwsSecurityFindingFilters$ResourceAwsIamAccessKeyUserName' => '<p>The user associated with the IAM access key related to a finding.</p>', 'AwsSecurityFindingFilters$ResourceAwsIamAccessKeyStatus' => '<p>The status of the IAM access key related to a finding.</p>', 'AwsSecurityFindingFilters$ResourceContainerName' => '<p>The name of the container related to a finding.</p>', 'AwsSecurityFindingFilters$ResourceContainerImageId' => '<p>The identifier of the image related to a finding.</p>', 'AwsSecurityFindingFilters$ResourceContainerImageName' => '<p>The name of the image related to a finding.</p>', 'AwsSecurityFindingFilters$ComplianceStatus' => '<p>Exclusive to findings that are generated as the result of a check run against a specific rule in a supported standard, such as CIS AWS Foundations. Contains security standard-related finding details.</p>', 'AwsSecurityFindingFilters$VerificationState' => '<p>The veracity of a finding.</p>', 'AwsSecurityFindingFilters$WorkflowState' => '<p>The workflow state of a finding.</p> <p>Note that this field is deprecated. To search for a finding based on its workflow status, use <code>WorkflowStatus</code>.</p>', 'AwsSecurityFindingFilters$WorkflowStatus' => '<p>The status of the investigation into a finding. Allowed values are the following.</p> <ul> <li> <p> <code>NEW</code> - The initial state of a finding, before it is reviewed.</p> </li> <li> <p> <code>NOTIFIED</code> - Indicates that the resource owner has been notified about the security issue. Used when the initial reviewer is not the resource owner, and needs intervention from the resource owner.</p> </li> <li> <p> <code>SUPPRESSED</code> - The finding will not be reviewed again and will not be acted upon.</p> </li> <li> <p> <code>RESOLVED</code> - The finding was reviewed and remediated and is now considered resolved. </p> </li> </ul>', 'AwsSecurityFindingFilters$RecordState' => '<p>The updated record state for the finding.</p>', 'AwsSecurityFindingFilters$RelatedFindingsProductArn' => '<p>The ARN of the solution that generated a related finding.</p>', 'AwsSecurityFindingFilters$RelatedFindingsId' => '<p>The solution-generated identifier for a related finding.</p>', 'AwsSecurityFindingFilters$NoteText' => '<p>The text of a note.</p>', 'AwsSecurityFindingFilters$NoteUpdatedBy' => '<p>The principal that created a note.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'AwsAutoScalingAutoScalingGroupDetails$LoadBalancerNames' => '<p>The list of load balancers associated with the group.</p>', 'AwsEc2InstanceDetails$IpV4Addresses' => '<p>The IPv4 addresses associated with the instance.</p>', 'AwsEc2InstanceDetails$IpV6Addresses' => '<p>The IPv6 addresses associated with the instance.</p>', 'NetworkPathComponentDetails$Address' => '<p>The IP addresses of the destination.</p>', 'Vulnerability$RelatedVulnerabilities' => '<p>List of vulnerabilities that are related to this vulnerability.</p>', 'Vulnerability$ReferenceUrls' => '<p>A list of URLs that provide additional information about the vulnerability.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The tag keys associated with the tags to remove from the resource.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'EnableSecurityHubRequest$Tags' => '<p>The tags to add to the hub resource when you enable Security Hub.</p>', 'ListTagsForResourceResponse$Tags' => '<p>The tags associated with a resource.</p>', 'TagResourceRequest$Tags' => '<p>The tags to add to the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'ThreatIntelIndicator' => [ 'base' => '<p>Details about the threat intelligence related to a finding.</p>', 'refs' => [ 'ThreatIntelIndicatorList$member' => NULL, ], ], 'ThreatIntelIndicatorCategory' => [ 'base' => NULL, 'refs' => [ 'ThreatIntelIndicator$Category' => '<p>The category of a threat intelligence indicator.</p>', ], ], 'ThreatIntelIndicatorList' => [ 'base' => NULL, 'refs' => [ 'AwsSecurityFinding$ThreatIntelIndicators' => '<p>Threat intelligence details related to a finding.</p>', ], ], 'ThreatIntelIndicatorType' => [ 'base' => NULL, 'refs' => [ 'ThreatIntelIndicator$Type' => '<p>The type of threat intelligence indicator.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'Invitation$InvitedAt' => '<p>The timestamp of when the invitation was sent.</p>', 'Member$InvitedAt' => '<p>A timestamp for the date and time when the invitation was sent to the member account.</p>', 'Member$UpdatedAt' => '<p>The timestamp for the date and time when the member account was updated.</p>', 'StandardsControl$ControlStatusUpdatedAt' => '<p>The date and time that the status of the security standard control was most recently updated.</p>', ], ], 'TypeList' => [ 'base' => NULL, 'refs' => [ 'AwsSecurityFinding$Types' => '<p>One or more finding types in the format of <code>namespace/category/classifier</code> that classify a finding.</p> <p>Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors | Sensitive Data Identifications</p>', 'BatchUpdateFindingsRequest$Types' => '<p>One or more finding types in the format of namespace/category/classifier that classify a finding.</p> <p>Valid namespace values are as follows.</p> <ul> <li> <p>Software and Configuration Checks</p> </li> <li> <p>TTPs</p> </li> <li> <p>Effects</p> </li> <li> <p>Unusual Behaviors</p> </li> <li> <p>Sensitive Data Identifications </p> </li> </ul>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateActionTargetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateActionTargetResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFindingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFindingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateInsightRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateInsightResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSecurityHubConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSecurityHubConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStandardsControlRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStandardsControlResponse' => [ 'base' => NULL, 'refs' => [], ], 'VerificationState' => [ 'base' => NULL, 'refs' => [ 'AwsSecurityFinding$VerificationState' => '<p>Indicates the veracity of a finding. </p>', 'BatchUpdateFindingsRequest$VerificationState' => '<p>Indicates the veracity of a finding.</p> <p>The available values for <code>VerificationState</code> are as follows.</p> <ul> <li> <p> <code>UNKNOWN</code> – The default disposition of a security finding</p> </li> <li> <p> <code>TRUE_POSITIVE</code> – The security finding is confirmed</p> </li> <li> <p> <code>FALSE_POSITIVE</code> – The security finding was determined to be a false alarm</p> </li> <li> <p> <code>BENIGN_POSITIVE</code> – A special case of <code>TRUE_POSITIVE</code> where the finding doesn\'t pose any threat, is expected, or both</p> </li> </ul>', ], ], 'Vulnerability' => [ 'base' => '<p>A vulnerability associated with a finding.</p>', 'refs' => [ 'VulnerabilityList$member' => NULL, ], ], 'VulnerabilityList' => [ 'base' => NULL, 'refs' => [ 'AwsSecurityFinding$Vulnerabilities' => '<p>Provides a list of vulnerabilities associated with the findings.</p>', ], ], 'VulnerabilityVendor' => [ 'base' => '<p>A vendor that generates a vulnerability report.</p>', 'refs' => [ 'Vulnerability$Vendor' => '<p>Information about the vendor that generates the vulnerability report.</p>', ], ], 'WafAction' => [ 'base' => '<p>Details about the action that CloudFront or AWS WAF takes when a web request matches the conditions in the rule. </p>', 'refs' => [ 'AwsWafWebAclRule$Action' => '<p>Specifies the action that CloudFront or AWS WAF takes when a web request matches the conditions in the rule. </p>', ], ], 'WafExcludedRule' => [ 'base' => '<p>Details about a rule to exclude from a rule group.</p>', 'refs' => [ 'WafExcludedRuleList$member' => NULL, ], ], 'WafExcludedRuleList' => [ 'base' => NULL, 'refs' => [ 'AwsWafWebAclRule$ExcludedRules' => '<p>Rules to exclude from a rule group.</p>', ], ], 'WafOverrideAction' => [ 'base' => '<p>Details about an override action for a rule.</p>', 'refs' => [ 'AwsWafWebAclRule$OverrideAction' => '<p>Use the <code>OverrideAction</code> to test your RuleGroup.</p> <p>Any rule in a RuleGroup can potentially block a request. If you set the <code>OverrideAction</code> to <code>None</code>, the RuleGroup blocks a request if any individual rule in the RuleGroup matches the request and is configured to block that request.</p> <p>However, if you first want to test the RuleGroup, set the <code>OverrideAction</code> to <code>Count</code>. The RuleGroup then overrides any block action specified by individual rules contained within the group. Instead of blocking matching requests, those requests are counted.</p> <p> <code>ActivatedRule</code>|<code>OverrideAction</code> applies only when updating or adding a RuleGroup to a WebACL. In this case you do not use <code>ActivatedRule</code>|<code>Action</code>. For all other update requests, <code>ActivatedRule</code>|<code>Action</code> is used instead of <code>ActivatedRule</code>|<code>OverrideAction</code>. </p>', ], ], 'Workflow' => [ 'base' => '<p>Provides information about the status of the investigation into a finding.</p>', 'refs' => [ 'AwsSecurityFinding$Workflow' => '<p>Provides information about the status of the investigation into a finding.</p>', ], ], 'WorkflowState' => [ 'base' => NULL, 'refs' => [ 'AwsSecurityFinding$WorkflowState' => '<p>The workflow state of a finding. </p>', ], ], 'WorkflowStatus' => [ 'base' => NULL, 'refs' => [ 'Workflow$Status' => '<p>The status of the investigation into the finding. The allowed values are the following.</p> <ul> <li> <p> <code>NEW</code> - The initial state of a finding, before it is reviewed.</p> </li> <li> <p> <code>NOTIFIED</code> - Indicates that you notified the resource owner about the security issue. Used when the initial reviewer is not the resource owner, and needs intervention from the resource owner.</p> </li> <li> <p> <code>SUPPRESSED</code> - The finding will not be reviewed again and will not be acted upon.</p> </li> <li> <p> <code>RESOLVED</code> - The finding was reviewed and remediated and is now considered resolved. </p> </li> </ul>', 'WorkflowUpdate$Status' => '<p>The status of the investigation into the finding. The allowed values are the following.</p> <ul> <li> <p> <code>NEW</code> - The initial state of a finding, before it is reviewed.</p> </li> <li> <p> <code>NOTIFIED</code> - Indicates that you notified the resource owner about the security issue. Used when the initial reviewer is not the resource owner, and needs intervention from the resource owner.</p> </li> <li> <p> <code>RESOLVED</code> - The finding was reviewed and remediated and is now considered resolved.</p> </li> <li> <p> <code>SUPPRESSED</code> - The finding will not be reviewed again and will not be acted upon.</p> </li> </ul>', ], ], 'WorkflowUpdate' => [ 'base' => '<p>Used to update information about the investigation into the finding.</p>', 'refs' => [ 'BatchUpdateFindingsRequest$Workflow' => '<p>Used to update the workflow status of a finding.</p> <p>The workflow status indicates the progress of the investigation into the finding. </p>', ], ], ],];
