<?php
// This file was auto-generated from sdk-root/src/data/sagemaker/2017-07-24/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Provides APIs for creating and managing Amazon SageMaker resources. </p> <p>Other Resources:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/whatis.html#first-time-user">Amazon SageMaker Developer Guide</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/augmented-ai/2019-11-07/APIReference/Welcome.html">Amazon Augmented AI Runtime API Reference</a> </p> </li> </ul>', 'operations' => [ 'AddTags' => '<p>Adds or overwrites one or more tags for the specified Amazon SageMaker resource. You can add tags to notebook instances, training jobs, hyperparameter tuning jobs, batch transform jobs, models, labeling jobs, work teams, endpoint configurations, and endpoints.</p> <p>Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information about tags, see For more information, see <a href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">AWS Tagging Strategies</a>.</p> <note> <p>Tags that you add to a hyperparameter tuning job by calling this API are also added to any training jobs that the hyperparameter tuning job launches after you call this API, but not to training jobs that the hyperparameter tuning job launched before you called this API. To make sure that the tags associated with a hyperparameter tuning job are also added to all training jobs that the hyperparameter tuning job launches, add the tags when you first create the tuning job by specifying them in the <code>Tags</code> parameter of <a>CreateHyperParameterTuningJob</a> </p> </note>', 'AssociateTrialComponent' => '<p>Associates a trial component with a trial. A trial component can be associated with multiple trials. To disassociate a trial component from a trial, call the <a>DisassociateTrialComponent</a> API.</p>', 'CreateAlgorithm' => '<p>Create a machine learning algorithm that you can use in Amazon SageMaker and list in the AWS Marketplace.</p>', 'CreateApp' => '<p>Creates a running App for the specified UserProfile. Supported Apps are JupyterServer and KernelGateway. This operation is automatically invoked by Amazon SageMaker Studio upon access to the associated Domain, and when new kernel configurations are selected by the user. A user may have multiple Apps active simultaneously.</p>', 'CreateAutoMLJob' => '<p>Creates an AutoPilot job.</p> <p>After you run an AutoPilot job, you can find the best performing model by calling , and then deploy that model by following the steps described in <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ex1-deploy-model.html">Step 6.1: Deploy the Model to Amazon SageMaker Hosting Services</a>.</p> <p>For information about how to use AutoPilot, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html">Use AutoPilot to Automate Model Development</a>.</p>', 'CreateCodeRepository' => '<p>Creates a Git repository as a resource in your Amazon SageMaker account. You can associate the repository with notebook instances so that you can use Git source control for the notebooks you create. The Git repository is a resource in your Amazon SageMaker account, so it can be associated with more than one notebook instance, and it persists independently from the lifecycle of any notebook instances it is associated with.</p> <p>The repository can be hosted either in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any other Git repository.</p>', 'CreateCompilationJob' => '<p>Starts a model compilation job. After the model has been compiled, Amazon SageMaker saves the resulting model artifacts to an Amazon Simple Storage Service (Amazon S3) bucket that you specify. </p> <p>If you choose to host your model using Amazon SageMaker hosting services, you can use the resulting model artifacts as part of the model. You can also use the artifacts with AWS IoT Greengrass. In that case, deploy them as an ML resource.</p> <p>In the request body, you provide the following:</p> <ul> <li> <p>A name for the compilation job</p> </li> <li> <p> Information about the input model artifacts </p> </li> <li> <p>The output location for the compiled model and the device (target) that the model runs on </p> </li> <li> <p>The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker assumes to perform the model compilation job. </p> </li> </ul> <p>You can also provide a <code>Tag</code> to track the model compilation job\'s resource use and costs. The response body contains the <code>CompilationJobArn</code> for the compiled job.</p> <p>To stop a model compilation job, use <a>StopCompilationJob</a>. To get information about a particular model compilation job, use <a>DescribeCompilationJob</a>. To get information about multiple model compilation jobs, use <a>ListCompilationJobs</a>.</p>', 'CreateDomain' => '<p>Creates a <code>Domain</code> used by SageMaker Studio. A domain consists of an associated directory, a list of authorized users, and a variety of security, application, policy, and Amazon Virtual Private Cloud (VPC) configurations. An AWS account is limited to one domain per region. Users within a domain can share notebook files and other artifacts with each other.</p> <p>When a domain is created, an Amazon Elastic File System (EFS) volume is also created for use by all of the users within the domain. Each user receives a private home directory within the EFS for notebooks, Git repositories, and data files.</p> <p>All traffic between the domain and the EFS volume is communicated through the specified subnet IDs. All other traffic goes over the Internet through an Amazon SageMaker system VPC. The EFS traffic uses the NFS/TCP protocol over port 2049.</p> <important> <p>NFS traffic over TCP on port 2049 needs to be allowed in both inbound and outbound rules in order to launch a SageMaker Studio app successfully.</p> </important>', 'CreateEndpoint' => '<p>Creates an endpoint using the endpoint configuration specified in the request. Amazon SageMaker uses the endpoint to provision resources and deploy models. You create the endpoint configuration with the <a>CreateEndpointConfig</a> API. </p> <p> Use this API to deploy models using Amazon SageMaker hosting services. </p> <p>For an example that calls this method when deploying a model to Amazon SageMaker hosting services, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ex1-deploy-model.html#ex1-deploy-model-boto">Deploy the Model to Amazon SageMaker Hosting Services (AWS SDK for Python (Boto 3)).</a> </p> <note> <p> You must not delete an <code>EndpointConfig</code> that is in use by an endpoint that is live or while the <code>UpdateEndpoint</code> or <code>CreateEndpoint</code> operations are being performed on the endpoint. To update an endpoint, you must create a new <code>EndpointConfig</code>.</p> </note> <p>The endpoint name must be unique within an AWS Region in your AWS account. </p> <p>When it receives the request, Amazon SageMaker creates the endpoint, launches the resources (ML compute instances), and deploys the model(s) on them. </p> <note> <p>When you call <a>CreateEndpoint</a>, a load call is made to DynamoDB to verify that your endpoint configuration exists. When you read data from a DynamoDB table supporting <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html"> <code>Eventually Consistent Reads</code> </a>, the response might not reflect the results of a recently completed write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB, this causes a validation error. If you repeat your read request after a short time, the response should return the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers call <a>DescribeEndpointConfig</a> before calling <a>CreateEndpoint</a> to minimize the potential impact of a DynamoDB eventually consistent read.</p> </note> <p>When Amazon SageMaker receives the request, it sets the endpoint status to <code>Creating</code>. After it creates the endpoint, it sets the status to <code>InService</code>. Amazon SageMaker can then process incoming requests for inferences. To check the status of an endpoint, use the <a>DescribeEndpoint</a> API.</p> <p>If any of the models hosted at this endpoint get model data from an Amazon S3 location, Amazon SageMaker uses AWS Security Token Service to download model artifacts from the S3 path you provided. AWS STS is activated in your IAM user account by default. If you previously deactivated AWS STS for a region, you need to reactivate AWS STS for that region. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and Deactivating AWS STS in an AWS Region</a> in the <i>AWS Identity and Access Management User Guide</i>.</p>', 'CreateEndpointConfig' => '<p>Creates an endpoint configuration that Amazon SageMaker hosting services uses to deploy models. In the configuration, you identify one or more models, created using the <code>CreateModel</code> API, to deploy and the resources that you want Amazon SageMaker to provision. Then you call the <a>CreateEndpoint</a> API.</p> <note> <p> Use this API if you want to use Amazon SageMaker hosting services to deploy models into production. </p> </note> <p>In the request, you define a <code>ProductionVariant</code>, for each model that you want to deploy. Each <code>ProductionVariant</code> parameter also describes the resources that you want Amazon SageMaker to provision. This includes the number and type of ML compute instances to deploy. </p> <p>If you are hosting multiple models, you also assign a <code>VariantWeight</code> to specify how much traffic you want to allocate to each model. For example, suppose that you want to host two models, A and B, and you assign traffic weight 2 for model A and 1 for model B. Amazon SageMaker distributes two-thirds of the traffic to Model A, and one-third to model B. </p> <p>For an example that calls this method when deploying a model to Amazon SageMaker hosting services, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ex1-deploy-model.html#ex1-deploy-model-boto">Deploy the Model to Amazon SageMaker Hosting Services (AWS SDK for Python (Boto 3)).</a> </p> <note> <p>When you call <a>CreateEndpoint</a>, a load call is made to DynamoDB to verify that your endpoint configuration exists. When you read data from a DynamoDB table supporting <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html"> <code>Eventually Consistent Reads</code> </a>, the response might not reflect the results of a recently completed write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB, this causes a validation error. If you repeat your read request after a short time, the response should return the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers call <a>DescribeEndpointConfig</a> before calling <a>CreateEndpoint</a> to minimize the potential impact of a DynamoDB eventually consistent read.</p> </note>', 'CreateExperiment' => '<p>Creates an SageMaker <i>experiment</i>. An experiment is a collection of <i>trials</i> that are observed, compared and evaluated as a group. A trial is a set of steps, called <i>trial components</i>, that produce a machine learning model.</p> <p>The goal of an experiment is to determine the components that produce the best model. Multiple trials are performed, each one isolating and measuring the impact of a change to one or more inputs, while keeping the remaining inputs constant.</p> <p>When you use Amazon SageMaker Studio or the Amazon SageMaker Python SDK, all experiments, trials, and trial components are automatically tracked, logged, and indexed. When you use the AWS SDK for Python (Boto), you must use the logging APIs provided by the SDK.</p> <p>You can add tags to experiments, trials, trial components and then use the <a>Search</a> API to search for the tags.</p> <p>To add a description to an experiment, specify the optional <code>Description</code> parameter. To add a description later, or to change the description, call the <a>UpdateExperiment</a> API.</p> <p>To get a list of all your experiments, call the <a>ListExperiments</a> API. To view an experiment\'s properties, call the <a>DescribeExperiment</a> API. To get a list of all the trials associated with an experiment, call the <a>ListTrials</a> API. To create a trial call the <a>CreateTrial</a> API.</p>', 'CreateFlowDefinition' => '<p>Creates a flow definition.</p>', 'CreateHumanTaskUi' => '<p>Defines the settings you will use for the human review workflow user interface. Reviewers will see a three-panel interface with an instruction area, the item to review, and an input area.</p>', 'CreateHyperParameterTuningJob' => '<p>Starts a hyperparameter tuning job. A hyperparameter tuning job finds the best version of a model by running many training jobs on your dataset using the algorithm you choose and values for hyperparameters within ranges that you specify. It then chooses the hyperparameter values that result in a model that performs the best, as measured by an objective metric that you choose.</p>', 'CreateLabelingJob' => '<p>Creates a job that uses workers to label the data objects in your input dataset. You can use the labeled data to train machine learning models.</p> <p>You can select your workforce from one of three providers:</p> <ul> <li> <p>A private workforce that you create. It can include employees, contractors, and outside experts. Use a private workforce when want the data to stay within your organization or when a specific set of skills is required.</p> </li> <li> <p>One or more vendors that you select from the AWS Marketplace. Vendors provide expertise in specific areas. </p> </li> <li> <p>The Amazon Mechanical Turk workforce. This is the largest workforce, but it should only be used for public data or data that has been stripped of any personally identifiable information.</p> </li> </ul> <p>You can also use <i>automated data labeling</i> to reduce the number of data objects that need to be labeled by a human. Automated data labeling uses <i>active learning</i> to determine if a data object can be labeled by machine or if it needs to be sent to a human worker. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-automated-labeling.html">Using Automated Data Labeling</a>.</p> <p>The data objects to be labeled are contained in an Amazon S3 bucket. You create a <i>manifest file</i> that describes the location of each object. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data.html">Using Input and Output Data</a>.</p> <p>The output can be used as the manifest file for another labeling job or as training data for your machine learning models.</p>', 'CreateModel' => '<p>Creates a model in Amazon SageMaker. In the request, you name the model and describe a primary container. For the primary container, you specify the Docker image that contains inference code, artifacts (from prior training), and a custom environment map that the inference code uses when you deploy the model for predictions.</p> <p>Use this API to create a model if you want to use Amazon SageMaker hosting services or run a batch transform job.</p> <p>To host your model, you create an endpoint configuration with the <code>CreateEndpointConfig</code> API, and then create an endpoint with the <code>CreateEndpoint</code> API. Amazon SageMaker then deploys all of the containers that you defined for the model in the hosting environment. </p> <p>For an example that calls this method when deploying a model to Amazon SageMaker hosting services, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ex1-deploy-model.html#ex1-deploy-model-boto">Deploy the Model to Amazon SageMaker Hosting Services (AWS SDK for Python (Boto 3)).</a> </p> <p>To run a batch transform using your model, you start a job with the <code>CreateTransformJob</code> API. Amazon SageMaker uses your model and your dataset to get inferences which are then saved to a specified S3 location.</p> <p>In the <code>CreateModel</code> request, you must define a container with the <code>PrimaryContainer</code> parameter.</p> <p>In the request, you also provide an IAM role that Amazon SageMaker can assume to access model artifacts and docker image for deployment on ML compute hosting instances or for batch transform jobs. In addition, you also use the IAM role to manage permissions the inference code needs. For example, if the inference code access any other AWS resources, you grant necessary permissions via this role.</p>', 'CreateModelPackage' => '<p>Creates a model package that you can use to create Amazon SageMaker models or list on AWS Marketplace. Buyers can subscribe to model packages listed on AWS Marketplace to create models in Amazon SageMaker.</p> <p>To create a model package by specifying a Docker container that contains your inference code and the Amazon S3 location of your model artifacts, provide values for <code>InferenceSpecification</code>. To create a model from an algorithm resource that you created or subscribed to in AWS Marketplace, provide a value for <code>SourceAlgorithmSpecification</code>.</p>', 'CreateMonitoringSchedule' => '<p>Creates a schedule that regularly starts Amazon SageMaker Processing Jobs to monitor the data captured for an Amazon SageMaker Endoint.</p>', 'CreateNotebookInstance' => '<p>Creates an Amazon SageMaker notebook instance. A notebook instance is a machine learning (ML) compute instance running on a Jupyter notebook. </p> <p>In a <code>CreateNotebookInstance</code> request, specify the type of ML compute instance that you want to run. Amazon SageMaker launches the instance, installs common libraries that you can use to explore datasets for model training, and attaches an ML storage volume to the notebook instance. </p> <p>Amazon SageMaker also provides a set of example notebooks. Each notebook demonstrates how to use Amazon SageMaker with a specific algorithm or with a machine learning framework. </p> <p>After receiving the request, Amazon SageMaker does the following:</p> <ol> <li> <p>Creates a network interface in the Amazon SageMaker VPC.</p> </li> <li> <p>(Option) If you specified <code>SubnetId</code>, Amazon SageMaker creates a network interface in your own VPC, which is inferred from the subnet ID that you provide in the input. When creating this network interface, Amazon SageMaker attaches the security group that you specified in the request to the network interface that it creates in your VPC.</p> </li> <li> <p>Launches an EC2 instance of the type specified in the request in the Amazon SageMaker VPC. If you specified <code>SubnetId</code> of your VPC, Amazon SageMaker specifies both network interfaces when launching this instance. This enables inbound traffic from your own VPC to the notebook instance, assuming that the security groups allow it.</p> </li> </ol> <p>After creating the notebook instance, Amazon SageMaker returns its Amazon Resource Name (ARN). You can\'t change the name of a notebook instance after you create it.</p> <p>After Amazon SageMaker creates the notebook instance, you can connect to the Jupyter server and work in Jupyter notebooks. For example, you can write code to explore a dataset that you can use for model training, train a model, host models by creating Amazon SageMaker endpoints, and validate hosted models. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html">How It Works</a>. </p>', 'CreateNotebookInstanceLifecycleConfig' => '<p>Creates a lifecycle configuration that you can associate with a notebook instance. A <i>lifecycle configuration</i> is a collection of shell scripts that run when you create or start a notebook instance.</p> <p>Each lifecycle configuration script has a limit of 16384 characters.</p> <p>The value of the <code>$PATH</code> environment variable that is available to both scripts is <code>/sbin:bin:/usr/sbin:/usr/bin</code>.</p> <p>View CloudWatch Logs for notebook instance lifecycle configurations in log group <code>/aws/sagemaker/NotebookInstances</code> in log stream <code>[notebook-instance-name]/[LifecycleConfigHook]</code>.</p> <p>Lifecycle configuration scripts cannot run for longer than 5 minutes. If a script runs for longer than 5 minutes, it fails and the notebook instance is not created or started.</p> <p>For information about notebook instance lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a>.</p>', 'CreatePresignedDomainUrl' => '<p>Creates a URL for a specified UserProfile in a Domain. When accessed in a web browser, the user will be automatically signed in to Amazon SageMaker Studio, and granted access to all of the Apps and files associated with the Domain\'s Amazon Elastic File System (EFS) volume. This operation can only be called when the authentication mode equals IAM. </p>', 'CreatePresignedNotebookInstanceUrl' => '<p>Returns a URL that you can use to connect to the Jupyter server from a notebook instance. In the Amazon SageMaker console, when you choose <code>Open</code> next to a notebook instance, Amazon SageMaker opens a new tab showing the Jupyter server home page from the notebook instance. The console uses this API to get the URL and show the page.</p> <p> The IAM role or user used to call this API defines the permissions to access the notebook instance. Once the presigned URL is created, no additional permission is required to access this URL. IAM authorization policies for this API are also enforced for every HTTP request and WebSocket frame that attempts to connect to the notebook instance.</p> <p>You can restrict access to this API and to the URL that it returns to a list of IP addresses that you specify. Use the <code>NotIpAddress</code> condition operator and the <code>aws:SourceIP</code> condition context key to specify the list of IP addresses that you want to have access to the notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/security_iam_id-based-policy-examples.html#nbi-ip-filter">Limit Access to a Notebook Instance by IP Address</a>.</p> <note> <p>The URL that you get from a call to <a>CreatePresignedNotebookInstanceUrl</a> is valid only for 5 minutes. If you try to use the URL after the 5-minute limit expires, you are directed to the AWS console sign-in page.</p> </note>', 'CreateProcessingJob' => '<p>Creates a processing job.</p>', 'CreateTrainingJob' => '<p>Starts a model training job. After training completes, Amazon SageMaker saves the resulting model artifacts to an Amazon S3 location that you specify. </p> <p>If you choose to host your model using Amazon SageMaker hosting services, you can use the resulting model artifacts as part of the model. You can also use the artifacts in a machine learning service other than Amazon SageMaker, provided that you know how to use them for inferences. </p> <p>In the request body, you provide the following: </p> <ul> <li> <p> <code>AlgorithmSpecification</code> - Identifies the training algorithm to use. </p> </li> <li> <p> <code>HyperParameters</code> - Specify these algorithm-specific parameters to enable the estimation of model parameters during training. Hyperparameters can be tuned to optimize this learning process. For a list of hyperparameters for each training algorithm provided by Amazon SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. </p> </li> <li> <p> <code>InputDataConfig</code> - Describes the training dataset and the Amazon S3, EFS, or FSx location where it is stored.</p> </li> <li> <p> <code>OutputDataConfig</code> - Identifies the Amazon S3 bucket where you want Amazon SageMaker to save the results of model training. </p> <p/> </li> <li> <p> <code>ResourceConfig</code> - Identifies the resources, ML compute instances, and ML storage volumes to deploy for model training. In distributed training, you specify more than one instance. </p> </li> <li> <p> <code>EnableManagedSpotTraining</code> - Optimize the cost of training machine learning models by up to 80% by using Amazon EC2 Spot instances. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html">Managed Spot Training</a>. </p> </li> <li> <p> <code>RoleARN</code> - The Amazon Resource Number (ARN) that Amazon SageMaker assumes to perform tasks on your behalf during model training. You must grant this role the necessary permissions so that Amazon SageMaker can successfully complete model training. </p> </li> <li> <p> <code>StoppingCondition</code> - To help cap training costs, use <code>MaxRuntimeInSeconds</code> to set a time limit for training. Use <code>MaxWaitTimeInSeconds</code> to specify how long you are willing to wait for a managed spot training job to complete. </p> </li> </ul> <p> For more information about Amazon SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html">How It Works</a>. </p>', 'CreateTransformJob' => '<p>Starts a transform job. A transform job uses a trained model to get inferences on a dataset and saves these results to an Amazon S3 location that you specify.</p> <p>To perform batch transformations, you create a transform job and use the data that you have readily available.</p> <p>In the request body, you provide the following:</p> <ul> <li> <p> <code>TransformJobName</code> - Identifies the transform job. The name must be unique within an AWS Region in an AWS account.</p> </li> <li> <p> <code>ModelName</code> - Identifies the model to use. <code>ModelName</code> must be the name of an existing Amazon SageMaker model in the same AWS Region and AWS account. For information on creating a model, see <a>CreateModel</a>.</p> </li> <li> <p> <code>TransformInput</code> - Describes the dataset to be transformed and the Amazon S3 location where it is stored.</p> </li> <li> <p> <code>TransformOutput</code> - Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job.</p> </li> <li> <p> <code>TransformResources</code> - Identifies the ML compute instances for the transform job.</p> </li> </ul> <p>For more information about how batch transformation works, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html">Batch Transform</a>.</p>', 'CreateTrial' => '<p>Creates an Amazon SageMaker <i>trial</i>. A trial is a set of steps called <i>trial components</i> that produce a machine learning model. A trial is part of a single Amazon SageMaker <i>experiment</i>.</p> <p>When you use Amazon SageMaker Studio or the Amazon SageMaker Python SDK, all experiments, trials, and trial components are automatically tracked, logged, and indexed. When you use the AWS SDK for Python (Boto), you must use the logging APIs provided by the SDK.</p> <p>You can add tags to a trial and then use the <a>Search</a> API to search for the tags.</p> <p>To get a list of all your trials, call the <a>ListTrials</a> API. To view a trial\'s properties, call the <a>DescribeTrial</a> API. To create a trial component, call the <a>CreateTrialComponent</a> API.</p>', 'CreateTrialComponent' => '<p>Creates a <i>trial component</i>, which is a stage of a machine learning <i>trial</i>. A trial is composed of one or more trial components. A trial component can be used in multiple trials.</p> <p>Trial components include pre-processing jobs, training jobs, and batch transform jobs.</p> <p>When you use Amazon SageMaker Studio or the Amazon SageMaker Python SDK, all experiments, trials, and trial components are automatically tracked, logged, and indexed. When you use the AWS SDK for Python (Boto), you must use the logging APIs provided by the SDK.</p> <p>You can add tags to a trial component and then use the <a>Search</a> API to search for the tags.</p> <note> <p> <code>CreateTrialComponent</code> can only be invoked from within an Amazon SageMaker managed environment. This includes Amazon SageMaker training jobs, processing jobs, transform jobs, and Amazon SageMaker notebooks. A call to <code>CreateTrialComponent</code> from outside one of these environments results in an error.</p> </note>', 'CreateUserProfile' => '<p>Creates a user profile. A user profile represents a single user within a domain, and is the main way to reference a "person" for the purposes of sharing, reporting, and other user-oriented features. This entity is created when a user onboards to Amazon SageMaker Studio. If an administrator invites a person by email or imports them from SSO, a user profile is automatically created. A user profile is the primary holder of settings for an individual user and has a reference to the user\'s private Amazon Elastic File System (EFS) home directory. </p>', 'CreateWorkforce' => '<p>Use this operation to create a workforce. This operation will return an error if a workforce already exists in the AWS Region that you specify. You can only create one workforce in each AWS Region.</p> <p>If you want to create a new workforce in an AWS Region where the a workforce already exists, use the API operation to delete the existing workforce and then use this operation to create a new workforce.</p> <p>To create a private workforce using Amazon Cognito, you must specify a Cognito user pool in <code>CognitoConfig</code>. You can also create an Amazon Cognito workforce using the Amazon SageMaker console. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html"> Create a Private Workforce (Amazon Cognito)</a>.</p> <p>To create a private workforce using your own OIDC Identity Provider (IdP), specify your IdP configuration in <code>OidcConfig</code>. You must create a OIDC IdP workforce using this API operation. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private-oidc.html"> Create a Private Workforce (OIDC IdP)</a>.</p>', 'CreateWorkteam' => '<p>Creates a new work team for labeling your data. A work team is defined by one or more Amazon Cognito user pools. You must first create the user pools before you can create a work team.</p> <p>You cannot create more than 25 work teams in an account and region.</p>', 'DeleteAlgorithm' => '<p>Removes the specified algorithm from your account.</p>', 'DeleteApp' => '<p>Used to stop and delete an app.</p>', 'DeleteCodeRepository' => '<p>Deletes the specified Git repository from your account.</p>', 'DeleteDomain' => '<p>Used to delete a domain. If you onboarded with IAM mode, you will need to delete your domain to onboard again using SSO. Use with caution. All of the members of the domain will lose access to their EFS volume, including data, notebooks, and other artifacts. </p>', 'DeleteEndpoint' => '<p>Deletes an endpoint. Amazon SageMaker frees up all of the resources that were deployed when the endpoint was created. </p> <p>Amazon SageMaker retires any custom KMS key grants associated with the endpoint, meaning you don\'t need to use the <a href="http://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html">RevokeGrant</a> API call.</p>', 'DeleteEndpointConfig' => '<p>Deletes an endpoint configuration. The <code>DeleteEndpointConfig</code> API deletes only the specified configuration. It does not delete endpoints created using the configuration. </p> <p>You must not delete an <code>EndpointConfig</code> in use by an endpoint that is live or while the <code>UpdateEndpoint</code> or <code>CreateEndpoint</code> operations are being performed on the endpoint. If you delete the <code>EndpointConfig</code> of an endpoint that is active or being created or updated you may lose visibility into the instance type the endpoint is using. The endpoint must be deleted in order to stop incurring charges.</p>', 'DeleteExperiment' => '<p>Deletes an Amazon SageMaker experiment. All trials associated with the experiment must be deleted first. Use the <a>ListTrials</a> API to get a list of the trials associated with the experiment.</p>', 'DeleteFlowDefinition' => '<p>Deletes the specified flow definition.</p>', 'DeleteHumanTaskUi' => '<p>Use this operation to delete a human task user interface (worker task template).</p> <p> To see a list of human task user interfaces (work task templates) in your account, use . When you delete a worker task template, it no longer appears when you call <code>ListHumanTaskUis</code>.</p>', 'DeleteModel' => '<p>Deletes a model. The <code>DeleteModel</code> API deletes only the model entry that was created in Amazon SageMaker when you called the <a>CreateModel</a> API. It does not delete model artifacts, inference code, or the IAM role that you specified when creating the model. </p>', 'DeleteModelPackage' => '<p>Deletes a model package.</p> <p>A model package is used to create Amazon SageMaker models or list on AWS Marketplace. Buyers can subscribe to model packages listed on AWS Marketplace to create models in Amazon SageMaker.</p>', 'DeleteMonitoringSchedule' => '<p>Deletes a monitoring schedule. Also stops the schedule had not already been stopped. This does not delete the job execution history of the monitoring schedule. </p>', 'DeleteNotebookInstance' => '<p> Deletes an Amazon SageMaker notebook instance. Before you can delete a notebook instance, you must call the <code>StopNotebookInstance</code> API. </p> <important> <p>When you delete a notebook instance, you lose all of your data. Amazon SageMaker removes the ML compute instance, and deletes the ML storage volume and the network interface associated with the notebook instance. </p> </important>', 'DeleteNotebookInstanceLifecycleConfig' => '<p>Deletes a notebook instance lifecycle configuration.</p>', 'DeleteTags' => '<p>Deletes the specified tags from an Amazon SageMaker resource.</p> <p>To list a resource\'s tags, use the <code>ListTags</code> API. </p> <note> <p>When you call this API to delete tags from a hyperparameter tuning job, the deleted tags are not removed from training jobs that the hyperparameter tuning job launched before you called this API.</p> </note>', 'DeleteTrial' => '<p>Deletes the specified trial. All trial components that make up the trial must be deleted first. Use the <a>DescribeTrialComponent</a> API to get the list of trial components.</p>', 'DeleteTrialComponent' => '<p>Deletes the specified trial component. A trial component must be disassociated from all trials before the trial component can be deleted. To disassociate a trial component from a trial, call the <a>DisassociateTrialComponent</a> API.</p>', 'DeleteUserProfile' => '<p>Deletes a user profile. When a user profile is deleted, the user loses access to their EFS volume, including data, notebooks, and other artifacts.</p>', 'DeleteWorkforce' => '<p>Use this operation to delete a workforce.</p> <p>If you want to create a new workforce in an AWS Region where the a workforce already exists, use this operation to delete the existing workforce and then use to create a new workforce.</p>', 'DeleteWorkteam' => '<p>Deletes an existing work team. This operation can\'t be undone.</p>', 'DescribeAlgorithm' => '<p>Returns a description of the specified algorithm that is in your account.</p>', 'DescribeApp' => '<p>Describes the app.</p>', 'DescribeAutoMLJob' => '<p>Returns information about an Amazon SageMaker job.</p>', 'DescribeCodeRepository' => '<p>Gets details about the specified Git repository.</p>', 'DescribeCompilationJob' => '<p>Returns information about a model compilation job.</p> <p>To create a model compilation job, use <a>CreateCompilationJob</a>. To get information about multiple model compilation jobs, use <a>ListCompilationJobs</a>.</p>', 'DescribeDomain' => '<p>The description of the domain.</p>', 'DescribeEndpoint' => '<p>Returns the description of an endpoint.</p>', 'DescribeEndpointConfig' => '<p>Returns the description of an endpoint configuration created using the <code>CreateEndpointConfig</code> API.</p>', 'DescribeExperiment' => '<p>Provides a list of an experiment\'s properties.</p>', 'DescribeFlowDefinition' => '<p>Returns information about the specified flow definition.</p>', 'DescribeHumanTaskUi' => '<p>Returns information about the requested human task user interface (worker task template).</p>', 'DescribeHyperParameterTuningJob' => '<p>Gets a description of a hyperparameter tuning job.</p>', 'DescribeLabelingJob' => '<p>Gets information about a labeling job.</p>', 'DescribeModel' => '<p>Describes a model that you created using the <code>CreateModel</code> API.</p>', 'DescribeModelPackage' => '<p>Returns a description of the specified model package, which is used to create Amazon SageMaker models or list them on AWS Marketplace.</p> <p>To create models in Amazon SageMaker, buyers can subscribe to model packages listed on AWS Marketplace.</p>', 'DescribeMonitoringSchedule' => '<p>Describes the schedule for a monitoring job.</p>', 'DescribeNotebookInstance' => '<p>Returns information about a notebook instance.</p>', 'DescribeNotebookInstanceLifecycleConfig' => '<p>Returns a description of a notebook instance lifecycle configuration.</p> <p>For information about notebook instance lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a>.</p>', 'DescribeProcessingJob' => '<p>Returns a description of a processing job.</p>', 'DescribeSubscribedWorkteam' => '<p>Gets information about a work team provided by a vendor. It returns details about the subscription with a vendor in the AWS Marketplace.</p>', 'DescribeTrainingJob' => '<p>Returns information about a training job.</p>', 'DescribeTransformJob' => '<p>Returns information about a transform job.</p>', 'DescribeTrial' => '<p>Provides a list of a trial\'s properties.</p>', 'DescribeTrialComponent' => '<p>Provides a list of a trials component\'s properties.</p>', 'DescribeUserProfile' => '<p>Describes a user profile. For more information, see <code>CreateUserProfile</code>.</p>', 'DescribeWorkforce' => '<p>Lists private workforce information, including workforce name, Amazon Resource Name (ARN), and, if applicable, allowed IP address ranges (<a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>). Allowable IP address ranges are the IP addresses that workers can use to access tasks. </p> <important> <p>This operation applies only to private workforces.</p> </important>', 'DescribeWorkteam' => '<p>Gets information about a specific work team. You can see information such as the create date, the last updated date, membership information, and the work team\'s Amazon Resource Name (ARN).</p>', 'DisassociateTrialComponent' => '<p>Disassociates a trial component from a trial. This doesn\'t effect other trials the component is associated with. Before you can delete a component, you must disassociate the component from all trials it is associated with. To associate a trial component with a trial, call the <a>AssociateTrialComponent</a> API.</p> <p>To get a list of the trials a component is associated with, use the <a>Search</a> API. Specify <code>ExperimentTrialComponent</code> for the <code>Resource</code> parameter. The list appears in the response under <code>Results.TrialComponent.Parents</code>.</p>', 'GetSearchSuggestions' => '<p>An auto-complete API for the search functionality in the Amazon SageMaker console. It returns suggestions of possible matches for the property name to use in <code>Search</code> queries. Provides suggestions for <code>HyperParameters</code>, <code>Tags</code>, and <code>Metrics</code>.</p>', 'ListAlgorithms' => '<p>Lists the machine learning algorithms that have been created.</p>', 'ListApps' => '<p>Lists apps.</p>', 'ListAutoMLJobs' => '<p>Request a list of jobs.</p>', 'ListCandidatesForAutoMLJob' => '<p>List the Candidates created for the job.</p>', 'ListCodeRepositories' => '<p>Gets a list of the Git repositories in your account.</p>', 'ListCompilationJobs' => '<p>Lists model compilation jobs that satisfy various filters.</p> <p>To create a model compilation job, use <a>CreateCompilationJob</a>. To get information about a particular model compilation job you have created, use <a>DescribeCompilationJob</a>.</p>', 'ListDomains' => '<p>Lists the domains.</p>', 'ListEndpointConfigs' => '<p>Lists endpoint configurations.</p>', 'ListEndpoints' => '<p>Lists endpoints.</p>', 'ListExperiments' => '<p>Lists all the experiments in your account. The list can be filtered to show only experiments that were created in a specific time range. The list can be sorted by experiment name or creation time.</p>', 'ListFlowDefinitions' => '<p>Returns information about the flow definitions in your account.</p>', 'ListHumanTaskUis' => '<p>Returns information about the human task user interfaces in your account.</p>', 'ListHyperParameterTuningJobs' => '<p>Gets a list of <a>HyperParameterTuningJobSummary</a> objects that describe the hyperparameter tuning jobs launched in your account.</p>', 'ListLabelingJobs' => '<p>Gets a list of labeling jobs.</p>', 'ListLabelingJobsForWorkteam' => '<p>Gets a list of labeling jobs assigned to a specified work team.</p>', 'ListModelPackages' => '<p>Lists the model packages that have been created.</p>', 'ListModels' => '<p>Lists models created with the <a>CreateModel</a> API.</p>', 'ListMonitoringExecutions' => '<p>Returns list of all monitoring job executions.</p>', 'ListMonitoringSchedules' => '<p>Returns list of all monitoring schedules.</p>', 'ListNotebookInstanceLifecycleConfigs' => '<p>Lists notebook instance lifestyle configurations created with the <a>CreateNotebookInstanceLifecycleConfig</a> API.</p>', 'ListNotebookInstances' => '<p>Returns a list of the Amazon SageMaker notebook instances in the requester\'s account in an AWS Region. </p>', 'ListProcessingJobs' => '<p>Lists processing jobs that satisfy various filters.</p>', 'ListSubscribedWorkteams' => '<p>Gets a list of the work teams that you are subscribed to in the AWS Marketplace. The list may be empty if no work team satisfies the filter specified in the <code>NameContains</code> parameter.</p>', 'ListTags' => '<p>Returns the tags for the specified Amazon SageMaker resource.</p>', 'ListTrainingJobs' => '<p>Lists training jobs.</p>', 'ListTrainingJobsForHyperParameterTuningJob' => '<p>Gets a list of <a>TrainingJobSummary</a> objects that describe the training jobs that a hyperparameter tuning job launched.</p>', 'ListTransformJobs' => '<p>Lists transform jobs.</p>', 'ListTrialComponents' => '<p>Lists the trial components in your account. You can sort the list by trial component name or creation time. You can filter the list to show only components that were created in a specific time range. You can also filter on one of the following:</p> <ul> <li> <p> <code>ExperimentName</code> </p> </li> <li> <p> <code>SourceArn</code> </p> </li> <li> <p> <code>TrialName</code> </p> </li> </ul>', 'ListTrials' => '<p>Lists the trials in your account. Specify an experiment name to limit the list to the trials that are part of that experiment. Specify a trial component name to limit the list to the trials that associated with that trial component. The list can be filtered to show only trials that were created in a specific time range. The list can be sorted by trial name or creation time.</p>', 'ListUserProfiles' => '<p>Lists user profiles.</p>', 'ListWorkforces' => '<p>Use this operation to list all private and vendor workforces in an AWS Region. Note that you can only have one private workforce per AWS Region.</p>', 'ListWorkteams' => '<p>Gets a list of work teams that you have defined in a region. The list may be empty if no work team satisfies the filter specified in the <code>NameContains</code> parameter.</p>', 'RenderUiTemplate' => '<p>Renders the UI template so that you can preview the worker\'s experience. </p>', 'Search' => '<p>Finds Amazon SageMaker resources that match a search query. Matching resources are returned as a list of <code>SearchRecord</code> objects in the response. You can sort the search results by any resource property in a ascending or descending order.</p> <p>You can query against the following value types: numeric, text, Boolean, and timestamp.</p>', 'StartMonitoringSchedule' => '<p>Starts a previously stopped monitoring schedule.</p> <note> <p>New monitoring schedules are immediately started after creation.</p> </note>', 'StartNotebookInstance' => '<p>Launches an ML compute instance with the latest version of the libraries and attaches your ML storage volume. After configuring the notebook instance, Amazon SageMaker sets the notebook instance status to <code>InService</code>. A notebook instance\'s status must be <code>InService</code> before you can connect to your Jupyter notebook. </p>', 'StopAutoMLJob' => '<p>A method for forcing the termination of a running job.</p>', 'StopCompilationJob' => '<p>Stops a model compilation job.</p> <p> To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal. This gracefully shuts the job down. If the job hasn\'t stopped, it sends the SIGKILL signal.</p> <p>When it receives a <code>StopCompilationJob</code> request, Amazon SageMaker changes the <a>CompilationJobSummary$CompilationJobStatus</a> of the job to <code>Stopping</code>. After Amazon SageMaker stops the job, it sets the <a>CompilationJobSummary$CompilationJobStatus</a> to <code>Stopped</code>. </p>', 'StopHyperParameterTuningJob' => '<p>Stops a running hyperparameter tuning job and all running training jobs that the tuning job launched.</p> <p>All model artifacts output from the training jobs are stored in Amazon Simple Storage Service (Amazon S3). All data that the training jobs write to Amazon CloudWatch Logs are still available in CloudWatch. After the tuning job moves to the <code>Stopped</code> state, it releases all reserved resources for the tuning job.</p>', 'StopLabelingJob' => '<p>Stops a running labeling job. A job that is stopped cannot be restarted. Any results obtained before the job is stopped are placed in the Amazon S3 output bucket.</p>', 'StopMonitoringSchedule' => '<p>Stops a previously started monitoring schedule.</p>', 'StopNotebookInstance' => '<p>Terminates the ML compute instance. Before terminating the instance, Amazon SageMaker disconnects the ML storage volume from it. Amazon SageMaker preserves the ML storage volume. Amazon SageMaker stops charging you for the ML compute instance when you call <code>StopNotebookInstance</code>.</p> <p>To access data on the ML storage volume for a notebook instance that has been terminated, call the <code>StartNotebookInstance</code> API. <code>StartNotebookInstance</code> launches another ML compute instance, configures it, and attaches the preserved ML storage volume so you can continue your work. </p>', 'StopProcessingJob' => '<p>Stops a processing job.</p>', 'StopTrainingJob' => '<p>Stops a training job. To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job termination for 120 seconds. Algorithms might use this 120-second window to save the model artifacts, so the results of the training is not lost. </p> <p>When it receives a <code>StopTrainingJob</code> request, Amazon SageMaker changes the status of the job to <code>Stopping</code>. After Amazon SageMaker stops the job, it sets the status to <code>Stopped</code>.</p>', 'StopTransformJob' => '<p>Stops a transform job.</p> <p>When Amazon SageMaker receives a <code>StopTransformJob</code> request, the status of the job changes to <code>Stopping</code>. After Amazon SageMaker stops the job, the status is set to <code>Stopped</code>. When you stop a transform job before it is completed, Amazon SageMaker doesn\'t store the job\'s output in Amazon S3.</p>', 'UpdateCodeRepository' => '<p>Updates the specified Git repository with the specified values.</p>', 'UpdateDomain' => '<p>Updates the default settings for new user profiles in the domain.</p>', 'UpdateEndpoint' => '<p>Deploys the new <code>EndpointConfig</code> specified in the request, switches to using newly created endpoint, and then deletes resources provisioned for the endpoint using the previous <code>EndpointConfig</code> (there is no availability loss). </p> <p>When Amazon SageMaker receives the request, it sets the endpoint status to <code>Updating</code>. After updating the endpoint, it sets the status to <code>InService</code>. To check the status of an endpoint, use the <a>DescribeEndpoint</a> API. </p> <note> <p>You must not delete an <code>EndpointConfig</code> in use by an endpoint that is live or while the <code>UpdateEndpoint</code> or <code>CreateEndpoint</code> operations are being performed on the endpoint. To update an endpoint, you must create a new <code>EndpointConfig</code>.</p> <p>If you delete the <code>EndpointConfig</code> of an endpoint that is active or being created or updated you may lose visibility into the instance type the endpoint is using. The endpoint must be deleted in order to stop incurring charges.</p> </note>', 'UpdateEndpointWeightsAndCapacities' => '<p>Updates variant weight of one or more variants associated with an existing endpoint, or capacity of one variant associated with an existing endpoint. When it receives the request, Amazon SageMaker sets the endpoint status to <code>Updating</code>. After updating the endpoint, it sets the status to <code>InService</code>. To check the status of an endpoint, use the <a>DescribeEndpoint</a> API. </p>', 'UpdateExperiment' => '<p>Adds, updates, or removes the description of an experiment. Updates the display name of an experiment.</p>', 'UpdateMonitoringSchedule' => '<p>Updates a previously created schedule.</p>', 'UpdateNotebookInstance' => '<p>Updates a notebook instance. NotebookInstance updates include upgrading or downgrading the ML compute instance used for your notebook instance to accommodate changes in your workload requirements.</p>', 'UpdateNotebookInstanceLifecycleConfig' => '<p>Updates a notebook instance lifecycle configuration created with the <a>CreateNotebookInstanceLifecycleConfig</a> API.</p>', 'UpdateTrial' => '<p>Updates the display name of a trial.</p>', 'UpdateTrialComponent' => '<p>Updates one or more properties of a trial component.</p>', 'UpdateUserProfile' => '<p>Updates a user profile.</p>', 'UpdateWorkforce' => '<p>Restricts access to tasks assigned to workers in the specified workforce to those within specific ranges of IP addresses. You specify allowed IP addresses by creating a list of up to ten <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>.</p> <p>By default, a workforce isn\'t restricted to specific IP addresses. If you specify a range of IP addresses, workers who attempt to access tasks using any IP address outside the specified range are denied access and get a <code>Not Found</code> error message on the worker portal. After restricting access with this operation, you can see the allowed IP values for a private workforce with the operation.</p> <important> <p>This operation applies only to private workforces.</p> </important>', 'UpdateWorkteam' => '<p>Updates an existing work team with new member definitions or description.</p>', ], 'shapes' => [ 'Accept' => [ 'base' => NULL, 'refs' => [ 'TransformOutput$Accept' => '<p>The MIME type used to specify the output data. Amazon SageMaker uses the MIME type with each http call to transfer data from the transform job.</p>', ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'LabelingJobForWorkteamSummary$WorkRequesterAccountId' => '<p/>', ], ], 'AddTagsInput' => [ 'base' => NULL, 'refs' => [], ], 'AddTagsOutput' => [ 'base' => NULL, 'refs' => [], ], 'AdditionalCodeRepositoryNamesOrUrls' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceInput$AdditionalCodeRepositories' => '<p>An array of up to three Git repositories to associate with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>', 'DescribeNotebookInstanceOutput$AdditionalCodeRepositories' => '<p>An array of up to three Git repositories associated with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>', 'NotebookInstanceSummary$AdditionalCodeRepositories' => '<p>An array of up to three Git repositories associated with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>', 'UpdateNotebookInstanceInput$AdditionalCodeRepositories' => '<p>An array of up to three Git repositories to associate with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>', ], ], 'AlgorithmArn' => [ 'base' => NULL, 'refs' => [ 'AlgorithmSummary$AlgorithmArn' => '<p>The Amazon Resource Name (ARN) of the algorithm.</p>', 'CreateAlgorithmOutput$AlgorithmArn' => '<p>The Amazon Resource Name (ARN) of the new algorithm.</p>', 'DescribeAlgorithmOutput$AlgorithmArn' => '<p>The Amazon Resource Name (ARN) of the algorithm.</p>', ], ], 'AlgorithmImage' => [ 'base' => NULL, 'refs' => [ 'AlgorithmSpecification$TrainingImage' => '<p>The registry path of the Docker image that contains the training algorithm. For information about docker registry paths for built-in algorithms, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html">Algorithms Provided by Amazon SageMaker: Common Parameters</a>. Amazon SageMaker supports both <code>registry/repository[:tag]</code> and <code>registry/repository[@digest]</code> image path formats. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon SageMaker</a>.</p>', 'DebugRuleConfiguration$RuleEvaluatorImage' => '<p>The Amazon Elastic Container (ECR) Image for the managed rule evaluation.</p>', 'HyperParameterAlgorithmSpecification$TrainingImage' => '<p> The registry path of the Docker image that contains the training algorithm. For information about Docker registry paths for built-in algorithms, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html">Algorithms Provided by Amazon SageMaker: Common Parameters</a>. Amazon SageMaker supports both <code>registry/repository[:tag]</code> and <code>registry/repository[@digest]</code> image path formats. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon SageMaker</a>.</p>', ], ], 'AlgorithmSortBy' => [ 'base' => NULL, 'refs' => [ 'ListAlgorithmsInput$SortBy' => '<p>The parameter by which to sort the results. The default is <code>CreationTime</code>.</p>', ], ], 'AlgorithmSpecification' => [ 'base' => '<p>Specifies the training algorithm to use in a <a>CreateTrainingJob</a> request.</p> <p>For more information about algorithms provided by Amazon SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. For information about using your own algorithms, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon SageMaker</a>. </p>', 'refs' => [ 'CreateTrainingJobRequest$AlgorithmSpecification' => '<p>The registry path of the Docker image that contains the training algorithm and algorithm-specific metadata, including the input mode. For more information about algorithms provided by Amazon SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. For information about providing your own algorithms, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon SageMaker</a>. </p>', 'DescribeTrainingJobResponse$AlgorithmSpecification' => '<p>Information about the algorithm used for training, and algorithm metadata. </p>', 'TrainingJob$AlgorithmSpecification' => '<p>Information about the algorithm used for training, and algorithm metadata.</p>', ], ], 'AlgorithmStatus' => [ 'base' => NULL, 'refs' => [ 'AlgorithmSummary$AlgorithmStatus' => '<p>The overall status of the algorithm.</p>', 'DescribeAlgorithmOutput$AlgorithmStatus' => '<p>The current status of the algorithm.</p>', ], ], 'AlgorithmStatusDetails' => [ 'base' => '<p>Specifies the validation and image scan statuses of the algorithm.</p>', 'refs' => [ 'DescribeAlgorithmOutput$AlgorithmStatusDetails' => '<p>Details about the current status of the algorithm.</p>', ], ], 'AlgorithmStatusItem' => [ 'base' => '<p>Represents the overall status of an algorithm.</p>', 'refs' => [ 'AlgorithmStatusItemList$member' => NULL, ], ], 'AlgorithmStatusItemList' => [ 'base' => NULL, 'refs' => [ 'AlgorithmStatusDetails$ValidationStatuses' => '<p>The status of algorithm validation.</p>', 'AlgorithmStatusDetails$ImageScanStatuses' => '<p>The status of the scan of the algorithm\'s Docker image container.</p>', ], ], 'AlgorithmSummary' => [ 'base' => '<p>Provides summary information about an algorithm.</p>', 'refs' => [ 'AlgorithmSummaryList$member' => NULL, ], ], 'AlgorithmSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAlgorithmsOutput$AlgorithmSummaryList' => '<p>&gt;An array of <code>AlgorithmSummary</code> objects, each of which lists an algorithm.</p>', ], ], 'AlgorithmValidationProfile' => [ 'base' => '<p>Defines a training job and a batch transform job that Amazon SageMaker runs to validate your algorithm.</p> <p>The data provided in the validation profile is made available to your buyers on AWS Marketplace.</p>', 'refs' => [ 'AlgorithmValidationProfiles$member' => NULL, ], ], 'AlgorithmValidationProfiles' => [ 'base' => NULL, 'refs' => [ 'AlgorithmValidationSpecification$ValidationProfiles' => '<p>An array of <code>AlgorithmValidationProfile</code> objects, each of which specifies a training job and batch transform job that Amazon SageMaker runs to validate your algorithm.</p>', ], ], 'AlgorithmValidationSpecification' => [ 'base' => '<p>Specifies configurations for one or more training jobs that Amazon SageMaker runs to test the algorithm.</p>', 'refs' => [ 'CreateAlgorithmInput$ValidationSpecification' => '<p>Specifies configurations for one or more training jobs and that Amazon SageMaker runs to test the algorithm\'s training code and, optionally, one or more batch transform jobs that Amazon SageMaker runs to test the algorithm\'s inference code.</p>', 'DescribeAlgorithmOutput$ValidationSpecification' => '<p>Details about configurations for one or more training jobs that Amazon SageMaker runs to test the algorithm.</p>', ], ], 'AnnotationConsolidationConfig' => [ 'base' => '<p>Configures how labels are consolidated across human workers and processes output data. </p>', 'refs' => [ 'HumanTaskConfig$AnnotationConsolidationConfig' => '<p>Configures how labels are consolidated across human workers.</p>', ], ], 'AppArn' => [ 'base' => NULL, 'refs' => [ 'CreateAppResponse$AppArn' => '<p>The App\'s Amazon Resource Name (ARN).</p>', 'DescribeAppResponse$AppArn' => '<p>The app\'s Amazon Resource Name (ARN).</p>', ], ], 'AppDetails' => [ 'base' => '<p>The app\'s details.</p>', 'refs' => [ 'AppList$member' => NULL, ], ], 'AppInstanceType' => [ 'base' => NULL, 'refs' => [ 'ResourceSpec$InstanceType' => '<p>The instance type.</p>', ], ], 'AppList' => [ 'base' => NULL, 'refs' => [ 'ListAppsResponse$Apps' => '<p>The list of apps.</p>', ], ], 'AppName' => [ 'base' => NULL, 'refs' => [ 'AppDetails$AppName' => '<p>The name of the app.</p>', 'CreateAppRequest$AppName' => '<p>The name of the app.</p>', 'DeleteAppRequest$AppName' => '<p>The name of the app.</p>', 'DescribeAppRequest$AppName' => '<p>The name of the app.</p>', 'DescribeAppResponse$AppName' => '<p>The name of the app.</p>', ], ], 'AppSortKey' => [ 'base' => NULL, 'refs' => [ 'ListAppsRequest$SortBy' => '<p>The parameter by which to sort the results. The default is CreationTime.</p>', ], ], 'AppSpecification' => [ 'base' => '<p>Configuration to run a processing job in a specified container image.</p>', 'refs' => [ 'CreateProcessingJobRequest$AppSpecification' => '<p>Configures the processing job to run a specified Docker container image.</p>', 'DescribeProcessingJobResponse$AppSpecification' => '<p>Configures the processing job to run a specified container image.</p>', 'ProcessingJob$AppSpecification' => NULL, ], ], 'AppStatus' => [ 'base' => NULL, 'refs' => [ 'AppDetails$Status' => '<p>The status.</p>', 'DescribeAppResponse$Status' => '<p>The status.</p>', ], ], 'AppType' => [ 'base' => NULL, 'refs' => [ 'AppDetails$AppType' => '<p>The type of app.</p>', 'CreateAppRequest$AppType' => '<p>The type of app.</p>', 'DeleteAppRequest$AppType' => '<p>The type of app.</p>', 'DescribeAppRequest$AppType' => '<p>The type of app.</p>', 'DescribeAppResponse$AppType' => '<p>The type of app.</p>', ], ], 'ArnOrName' => [ 'base' => NULL, 'refs' => [ 'AlgorithmSpecification$AlgorithmName' => '<p>The name of the algorithm resource to use for the training job. This must be an algorithm resource that you created or subscribe to on AWS Marketplace. If you specify a value for this parameter, you can\'t specify a value for <code>TrainingImage</code>.</p>', 'ContainerDefinition$ModelPackageName' => '<p>The name or Amazon Resource Name (ARN) of the model package to use to create the model.</p>', 'DescribeAlgorithmInput$AlgorithmName' => '<p>The name of the algorithm to describe.</p>', 'DescribeModelPackageInput$ModelPackageName' => '<p>The name of the model package to describe.</p>', 'HyperParameterAlgorithmSpecification$AlgorithmName' => '<p>The name of the resource algorithm to use for the hyperparameter tuning job. If you specify a value for this parameter, do not specify a value for <code>TrainingImage</code>.</p>', 'SourceAlgorithm$AlgorithmName' => '<p>The name of an algorithm that was used to create the model package. The algorithm must be either an algorithm resource in your Amazon SageMaker account or an algorithm in AWS Marketplace that you are subscribed to.</p>', ], ], 'AssemblyType' => [ 'base' => NULL, 'refs' => [ 'TransformOutput$AssembleWith' => '<p>Defines how to assemble the results of the transform job as a single S3 object. Choose a format that is most convenient to you. To concatenate the results in binary format, specify <code>None</code>. To add a newline character at the end of every transformed record, specify <code>Line</code>.</p>', ], ], 'AssociateTrialComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateTrialComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'AttributeName' => [ 'base' => NULL, 'refs' => [ 'AttributeNames$member' => NULL, ], ], 'AttributeNames' => [ 'base' => NULL, 'refs' => [ 'S3DataSource$AttributeNames' => '<p>A list of one or more attribute names to use that are found in a specified augmented manifest file.</p>', ], ], 'AuthMode' => [ 'base' => NULL, 'refs' => [ 'CreateDomainRequest$AuthMode' => '<p>The mode of authentication that members use to access the domain.</p>', 'DescribeDomainResponse$AuthMode' => '<p>The domain\'s authentication mode.</p>', ], ], 'AutoMLCandidate' => [ 'base' => '<p>An AutoPilot job will return recommendations, or candidates. Each candidate has futher details about the steps involed, and the status.</p>', 'refs' => [ 'AutoMLCandidates$member' => NULL, 'DescribeAutoMLJobResponse$BestCandidate' => '<p>Returns the job\'s BestCandidate.</p>', ], ], 'AutoMLCandidateStep' => [ 'base' => '<p>Information about the steps for a Candidate, and what step it is working on.</p>', 'refs' => [ 'CandidateSteps$member' => NULL, ], ], 'AutoMLCandidates' => [ 'base' => NULL, 'refs' => [ 'ListCandidatesForAutoMLJobResponse$Candidates' => '<p>Summaries about the Candidates.</p>', ], ], 'AutoMLChannel' => [ 'base' => '<p>Similar to Channel. A channel is a named input source that training algorithms can consume. Refer to Channel for detailed descriptions.</p>', 'refs' => [ 'AutoMLInputDataConfig$member' => NULL, ], ], 'AutoMLContainerDefinition' => [ 'base' => '<p>A list of container definitions that describe the different containers that make up one AutoML candidate. Refer to ContainerDefinition for more details.</p>', 'refs' => [ 'AutoMLContainerDefinitions$member' => NULL, ], ], 'AutoMLContainerDefinitions' => [ 'base' => NULL, 'refs' => [ 'AutoMLCandidate$InferenceContainers' => '<p>The inference containers.</p>', ], ], 'AutoMLDataSource' => [ 'base' => '<p>The data source for the AutoPilot job.</p>', 'refs' => [ 'AutoMLChannel$DataSource' => '<p>The data source.</p>', ], ], 'AutoMLFailureReason' => [ 'base' => NULL, 'refs' => [ 'AutoMLCandidate$FailureReason' => '<p>The failure reason.</p>', 'AutoMLJobSummary$FailureReason' => '<p>The failure reason.</p>', 'DescribeAutoMLJobResponse$FailureReason' => '<p>Returns the job\'s FailureReason.</p>', ], ], 'AutoMLInputDataConfig' => [ 'base' => NULL, 'refs' => [ 'CreateAutoMLJobRequest$InputDataConfig' => '<p>Similar to InputDataConfig supported by Tuning. Format(s) supported: CSV. Minimum of 1000 rows.</p>', 'DescribeAutoMLJobResponse$InputDataConfig' => '<p>Returns the job\'s input data config.</p>', ], ], 'AutoMLJobArn' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobSummary$AutoMLJobArn' => '<p>The ARN of the job.</p>', 'CreateAutoMLJobResponse$AutoMLJobArn' => '<p>When a job is created, it is assigned a unique ARN.</p>', 'DescribeAutoMLJobResponse$AutoMLJobArn' => '<p>Returns the job\'s ARN.</p>', 'DescribeProcessingJobResponse$AutoMLJobArn' => '<p>The ARN of an AutoML job associated with this processing job.</p>', 'DescribeTrainingJobResponse$AutoMLJobArn' => '<p>The Amazon Resource Name (ARN) of an AutoML job.</p>', 'DescribeTransformJobResponse$AutoMLJobArn' => '<p>The Amazon Resource Name (ARN) of the AutoML transform job.</p>', 'ProcessingJob$AutoMLJobArn' => '<p>The Amazon Resource Name (ARN) of the AutoML job associated with this processing job.</p>', 'TrainingJob$AutoMLJobArn' => '<p>The Amazon Resource Name (ARN) of the job.</p>', 'TransformJob$AutoMLJobArn' => '<p>The Amazon Resource Name (ARN) of the AutoML job that created the transform job.</p>', ], ], 'AutoMLJobArtifacts' => [ 'base' => '<p>Artifacts that are generation during a job.</p>', 'refs' => [ 'DescribeAutoMLJobResponse$AutoMLJobArtifacts' => '<p>Returns information on the job\'s artifacts found in AutoMLJobArtifacts.</p>', ], ], 'AutoMLJobCompletionCriteria' => [ 'base' => '<p>How long a job is allowed to run, or how many candidates a job is allowed to generate.</p>', 'refs' => [ 'AutoMLJobConfig$CompletionCriteria' => '<p>How long a job is allowed to run, or how many candidates a job is allowed to generate.</p>', 'ResolvedAttributes$CompletionCriteria' => NULL, ], ], 'AutoMLJobConfig' => [ 'base' => '<p>A collection of settings used for a job.</p>', 'refs' => [ 'CreateAutoMLJobRequest$AutoMLJobConfig' => '<p>Contains CompletionCriteria and SecurityConfig.</p>', 'DescribeAutoMLJobResponse$AutoMLJobConfig' => '<p>Returns the job\'s config.</p>', ], ], 'AutoMLJobName' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobSummary$AutoMLJobName' => '<p>The name of the object you are requesting.</p>', 'CreateAutoMLJobRequest$AutoMLJobName' => '<p>Identifies an AutoPilot job. Must be unique to your account and is case-insensitive.</p>', 'DescribeAutoMLJobRequest$AutoMLJobName' => '<p>Request information about a job using that job\'s unique name.</p>', 'DescribeAutoMLJobResponse$AutoMLJobName' => '<p>Returns the name of a job.</p>', 'ListCandidatesForAutoMLJobRequest$AutoMLJobName' => '<p>List the Candidates created for the job by providing the job\'s name.</p>', 'StopAutoMLJobRequest$AutoMLJobName' => '<p>The name of the object you are requesting.</p>', ], ], 'AutoMLJobObjective' => [ 'base' => '<p>Applies a metric to minimize or maximize for the job\'s objective.</p>', 'refs' => [ 'CreateAutoMLJobRequest$AutoMLJobObjective' => '<p>Defines the job\'s objective. You provide a MetricName and AutoML will infer minimize or maximize. If this is not provided, the most commonly used ObjectiveMetric for problem type will be selected.</p>', 'DescribeAutoMLJobResponse$AutoMLJobObjective' => '<p>Returns the job\'s objective.</p>', 'ResolvedAttributes$AutoMLJobObjective' => NULL, ], ], 'AutoMLJobObjectiveType' => [ 'base' => NULL, 'refs' => [ 'FinalAutoMLJobObjectiveMetric$Type' => '<p>The metric type used.</p>', ], ], 'AutoMLJobSecondaryStatus' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobSummary$AutoMLJobSecondaryStatus' => '<p>The job\'s secondary status.</p>', 'DescribeAutoMLJobResponse$AutoMLJobSecondaryStatus' => '<p>Returns the job\'s AutoMLJobSecondaryStatus.</p>', ], ], 'AutoMLJobStatus' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobSummary$AutoMLJobStatus' => '<p>The job\'s status.</p>', 'DescribeAutoMLJobResponse$AutoMLJobStatus' => '<p>Returns the job\'s AutoMLJobStatus.</p>', 'ListAutoMLJobsRequest$StatusEquals' => '<p>Request a list of jobs, using a filter for status.</p>', ], ], 'AutoMLJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListAutoMLJobsResponse$AutoMLJobSummaries' => '<p>Returns a summary list of jobs.</p>', ], ], 'AutoMLJobSummary' => [ 'base' => '<p>Provides a summary about a job.</p>', 'refs' => [ 'AutoMLJobSummaries$member' => NULL, ], ], 'AutoMLMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAutoMLJobsRequest$MaxResults' => '<p>Request a list of jobs up to a specified limit.</p>', 'ListCandidatesForAutoMLJobRequest$MaxResults' => '<p>List the job\'s Candidates up to a specified limit.</p>', ], ], 'AutoMLMetricEnum' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobObjective$MetricName' => '<p>The name of the metric.</p>', 'FinalAutoMLJobObjectiveMetric$MetricName' => '<p>The name of the metric.</p>', ], ], 'AutoMLNameContains' => [ 'base' => NULL, 'refs' => [ 'ListAutoMLJobsRequest$NameContains' => '<p>Request a list of jobs, using a search filter for name.</p>', ], ], 'AutoMLOutputDataConfig' => [ 'base' => '<p>The output data configuration.</p>', 'refs' => [ 'CreateAutoMLJobRequest$OutputDataConfig' => '<p>Similar to OutputDataConfig supported by Tuning. Format(s) supported: CSV.</p>', 'DescribeAutoMLJobResponse$OutputDataConfig' => '<p>Returns the job\'s output data config.</p>', ], ], 'AutoMLS3DataSource' => [ 'base' => '<p>The Amazon S3 data source.</p>', 'refs' => [ 'AutoMLDataSource$S3DataSource' => '<p>The Amazon S3 location of the input data.</p> <note> <p>The input data must be in CSV format and contain at least 1000 rows.</p> </note>', ], ], 'AutoMLS3DataType' => [ 'base' => NULL, 'refs' => [ 'AutoMLS3DataSource$S3DataType' => '<p>The data type.</p>', ], ], 'AutoMLSecurityConfig' => [ 'base' => '<p>Security options.</p>', 'refs' => [ 'AutoMLJobConfig$SecurityConfig' => '<p>Security configuration for traffic encryption or Amazon VPC settings.</p>', ], ], 'AutoMLSortBy' => [ 'base' => NULL, 'refs' => [ 'ListAutoMLJobsRequest$SortBy' => '<p>The parameter by which to sort the results. The default is AutoMLJobName.</p>', ], ], 'AutoMLSortOrder' => [ 'base' => NULL, 'refs' => [ 'ListAutoMLJobsRequest$SortOrder' => '<p>The sort order for the results. The default is Descending.</p>', 'ListCandidatesForAutoMLJobRequest$SortOrder' => '<p>The sort order for the results. The default is Ascending.</p>', ], ], 'AwsManagedHumanLoopRequestSource' => [ 'base' => NULL, 'refs' => [ 'HumanLoopRequestSource$AwsManagedHumanLoopRequestSource' => '<p>Specifies whether Amazon Rekognition or Amazon Textract are used as the integration source. The default field settings and JSON parsing rules are different based on the integration source. Valid values:</p>', ], ], 'BatchStrategy' => [ 'base' => NULL, 'refs' => [ 'CreateTransformJobRequest$BatchStrategy' => '<p>Specifies the number of records to include in a mini-batch for an HTTP inference request. A <i>record</i> <i/> is a single unit of input data that inference can be made on. For example, a single line in a CSV file is a record. </p> <p>To enable the batch strategy, you must set the <code>SplitType</code> property to <code>Line</code>, <code>RecordIO</code>, or <code>TFRecord</code>.</p> <p>To use only one record when making an HTTP invocation request to a container, set <code>BatchStrategy</code> to <code>SingleRecord</code> and <code>SplitType</code> to <code>Line</code>.</p> <p>To fit as many records in a mini-batch as can fit within the <code>MaxPayloadInMB</code> limit, set <code>BatchStrategy</code> to <code>MultiRecord</code> and <code>SplitType</code> to <code>Line</code>.</p>', 'DescribeTransformJobResponse$BatchStrategy' => '<p>Specifies the number of records to include in a mini-batch for an HTTP inference request. A <i>record</i> <i/> is a single unit of input data that inference can be made on. For example, a single line in a CSV file is a record. </p> <p>To enable the batch strategy, you must set <code>SplitType</code> to <code>Line</code>, <code>RecordIO</code>, or <code>TFRecord</code>.</p>', 'TransformJob$BatchStrategy' => '<p>Specifies the number of records to include in a mini-batch for an HTTP inference request. A record is a single unit of input data that inference can be made on. For example, a single line in a CSV file is a record.</p>', 'TransformJobDefinition$BatchStrategy' => '<p>A string that determines the number of records included in a single mini-batch.</p> <p> <code>SingleRecord</code> means only one record is used per mini-batch. <code>MultiRecord</code> means a mini-batch is set to contain as many records that can fit within the <code>MaxPayloadInMB</code> limit.</p>', ], ], 'BillableTimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'DescribeTrainingJobResponse$BillableTimeInSeconds' => '<p>The billable time in seconds.</p> <p>You can calculate the savings from using managed spot training using the formula <code>(1 - BillableTimeInSeconds / TrainingTimeInSeconds) * 100</code>. For example, if <code>BillableTimeInSeconds</code> is 100 and <code>TrainingTimeInSeconds</code> is 500, the savings is 80%.</p>', 'TrainingJob$BillableTimeInSeconds' => '<p>The billable time in seconds.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AlgorithmSpecification$EnableSageMakerMetricsTimeSeries' => '<p>To generate and save time-series metrics during training, set to <code>true</code>. The default is <code>false</code> and time-series metrics aren\'t generated except in the following cases:</p> <ul> <li> <p>You use one of the Amazon SageMaker built-in algorithms</p> </li> <li> <p>You use one of the following <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/pre-built-containers-frameworks-deep-learning.html">Prebuilt Amazon SageMaker Docker Images</a>:</p> <ul> <li> <p>Tensorflow (version &gt;= 1.15)</p> </li> <li> <p>MXNet (version &gt;= 1.6)</p> </li> <li> <p>PyTorch (version &gt;= 1.3)</p> </li> </ul> </li> <li> <p>You specify at least one <a>MetricDefinition</a> </p> </li> </ul>', 'AutoMLSecurityConfig$EnableInterContainerTrafficEncryption' => '<p>Whether to use traffic encryption between the container layers.</p>', 'ChannelSpecification$IsRequired' => '<p>Indicates whether the channel is required by the algorithm.</p>', 'CreateModelInput$EnableNetworkIsolation' => '<p>Isolates the model container. No inbound or outbound network calls can be made to or from the model container.</p>', 'CreateTrainingJobRequest$EnableNetworkIsolation' => '<p>Isolates the training container. No inbound or outbound network calls can be made, except for calls between peers within a training cluster for distributed training. If you enable network isolation for training jobs that are configured to use a VPC, Amazon SageMaker downloads and uploads customer data and model artifacts through the specified VPC, but the training container does not have network access.</p>', 'CreateTrainingJobRequest$EnableInterContainerTrafficEncryption' => '<p>To encrypt all communications between ML compute instances in distributed training, choose <code>True</code>. Encryption provides greater security for distributed training, but training might take longer. How long it takes depends on the amount of communication between compute instances, especially if you use a deep learning algorithm in distributed training. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-encrypt.html">Protect Communications Between ML Compute Instances in a Distributed Training Job</a>.</p>', 'CreateTrainingJobRequest$EnableManagedSpotTraining' => '<p>To train models using managed spot training, choose <code>True</code>. Managed spot training provides a fully managed and scalable infrastructure for training machine learning models. this option is useful when training jobs can be interrupted and when there is flexibility when the training job is run. </p> <p>The complete and intermediate results of jobs are stored in an Amazon S3 bucket, and can be used as a starting point to train models incrementally. Amazon SageMaker provides metrics and logs in CloudWatch. They can be used to see when managed spot training jobs are running, interrupted, resumed, or completed. </p>', 'DescribeModelOutput$EnableNetworkIsolation' => '<p>If <code>True</code>, no inbound or outbound network calls can be made to or from the model container.</p>', 'DescribeTrainingJobResponse$EnableNetworkIsolation' => '<p>If you want to allow inbound or outbound network calls, except for calls between peers within a training cluster for distributed training, choose <code>True</code>. If you enable network isolation for training jobs that are configured to use a VPC, Amazon SageMaker downloads and uploads customer data and model artifacts through the specified VPC, but the training container does not have network access.</p>', 'DescribeTrainingJobResponse$EnableInterContainerTrafficEncryption' => '<p>To encrypt all communications between ML compute instances in distributed training, choose <code>True</code>. Encryption provides greater security for distributed training, but training might take longer. How long it takes depends on the amount of communication between compute instances, especially if you use a deep learning algorithms in distributed training.</p>', 'DescribeTrainingJobResponse$EnableManagedSpotTraining' => '<p>A Boolean indicating whether managed spot training is enabled (<code>True</code>) or not (<code>False</code>).</p>', 'HyperParameterSpecification$IsTunable' => '<p>Indicates whether this hyperparameter is tunable in a hyperparameter tuning job.</p>', 'HyperParameterSpecification$IsRequired' => '<p>Indicates whether this hyperparameter is required.</p>', 'HyperParameterTrainingJobDefinition$EnableNetworkIsolation' => '<p>Isolates the training container. No inbound or outbound network calls can be made, except for calls between peers within a training cluster for distributed training. If network isolation is used for training jobs that are configured to use a VPC, Amazon SageMaker downloads and uploads customer data and model artifacts through the specified VPC, but the training container does not have network access.</p>', 'HyperParameterTrainingJobDefinition$EnableInterContainerTrafficEncryption' => '<p>To encrypt all communications between ML compute instances in distributed training, choose <code>True</code>. Encryption provides greater security for distributed training, but training might take longer. How long it takes depends on the amount of communication between compute instances, especially if you use a deep learning algorithm in distributed training.</p>', 'HyperParameterTrainingJobDefinition$EnableManagedSpotTraining' => '<p>A Boolean indicating whether managed spot training is enabled (<code>True</code>) or not (<code>False</code>).</p>', 'NetworkConfig$EnableInterContainerTrafficEncryption' => '<p>Whether to encrypt all communications between distributed processing jobs. Choose <code>True</code> to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.</p>', 'NetworkConfig$EnableNetworkIsolation' => '<p>Whether to allow inbound and outbound network calls to and from the containers used for the processing job.</p>', 'TrainingJob$EnableNetworkIsolation' => '<p>If the <code>TrainingJob</code> was created with network isolation, the value is set to <code>true</code>. If network isolation is enabled, nodes can\'t communicate beyond the VPC they run in.</p>', 'TrainingJob$EnableInterContainerTrafficEncryption' => '<p>To encrypt all communications between ML compute instances in distributed training, choose <code>True</code>. Encryption provides greater security for distributed training, but training might take longer. How long it takes depends on the amount of communication between compute instances, especially if you use a deep learning algorithm in distributed training.</p>', 'TrainingJob$EnableManagedSpotTraining' => '<p>When true, enables managed spot training using Amazon EC2 Spot instances to run training jobs instead of on-demand instances. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html">Managed Spot Training</a>.</p>', 'TrainingSpecification$SupportsDistributedTraining' => '<p>Indicates whether the algorithm supports distributed training. If set to false, buyers can\'t request more than one instance during training.</p>', 'UpdateEndpointInput$RetainAllVariantProperties' => '<p>When updating endpoint resources, enables or disables the retention of variant properties, such as the instance count or the variant weight. To retain the variant properties of an endpoint when updating it, set <code>RetainAllVariantProperties</code> to <code>true</code>. To use the variant properties specified in a new <code>EndpointConfig</code> call when updating an endpoint, set <code>RetainAllVariantProperties</code> to <code>false</code>.</p>', ], ], 'BooleanOperator' => [ 'base' => NULL, 'refs' => [ 'SearchExpression$Operator' => '<p>A Boolean operator used to evaluate the search expression. If you want every conditional statement in all lists to be satisfied for the entire search expression to be true, specify <code>And</code>. If only a single conditional statement needs to be true for the entire search expression to be true, specify <code>Or</code>. The default value is <code>And</code>.</p>', ], ], 'Branch' => [ 'base' => NULL, 'refs' => [ 'GitConfig$Branch' => '<p>The default branch for the Git repository.</p>', ], ], 'CandidateDefinitionNotebookLocation' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobArtifacts$CandidateDefinitionNotebookLocation' => '<p>The URL to the notebook location.</p>', ], ], 'CandidateName' => [ 'base' => NULL, 'refs' => [ 'AutoMLCandidate$CandidateName' => '<p>The candidate name.</p>', 'ListCandidatesForAutoMLJobRequest$CandidateNameEquals' => '<p>List the Candidates for the job and filter by candidate name.</p>', ], ], 'CandidateSortBy' => [ 'base' => NULL, 'refs' => [ 'ListCandidatesForAutoMLJobRequest$SortBy' => '<p>The parameter by which to sort the results. The default is Descending.</p>', ], ], 'CandidateStatus' => [ 'base' => NULL, 'refs' => [ 'AutoMLCandidate$CandidateStatus' => '<p>The candidate\'s status.</p>', 'ListCandidatesForAutoMLJobRequest$StatusEquals' => '<p>List the Candidates for the job and filter by status.</p>', ], ], 'CandidateStepArn' => [ 'base' => NULL, 'refs' => [ 'AutoMLCandidateStep$CandidateStepArn' => '<p>The ARN for the Candidate\'s step.</p>', ], ], 'CandidateStepName' => [ 'base' => NULL, 'refs' => [ 'AutoMLCandidateStep$CandidateStepName' => '<p>The name for the Candidate\'s step.</p>', ], ], 'CandidateStepType' => [ 'base' => NULL, 'refs' => [ 'AutoMLCandidateStep$CandidateStepType' => '<p>Whether the Candidate is at the transform, training, or processing step.</p>', ], ], 'CandidateSteps' => [ 'base' => NULL, 'refs' => [ 'AutoMLCandidate$CandidateSteps' => '<p>The candidate\'s steps.</p>', ], ], 'CaptureContentTypeHeader' => [ 'base' => '<p/>', 'refs' => [ 'DataCaptureConfig$CaptureContentTypeHeader' => '<p/>', ], ], 'CaptureMode' => [ 'base' => NULL, 'refs' => [ 'CaptureOption$CaptureMode' => '<p/>', ], ], 'CaptureOption' => [ 'base' => '<p/>', 'refs' => [ 'CaptureOptionList$member' => NULL, ], ], 'CaptureOptionList' => [ 'base' => NULL, 'refs' => [ 'DataCaptureConfig$CaptureOptions' => '<p/>', ], ], 'CaptureStatus' => [ 'base' => NULL, 'refs' => [ 'DataCaptureConfigSummary$CaptureStatus' => '<p/>', ], ], 'CategoricalParameterRange' => [ 'base' => '<p>A list of categorical hyperparameters to tune.</p>', 'refs' => [ 'CategoricalParameterRanges$member' => NULL, ], ], 'CategoricalParameterRangeSpecification' => [ 'base' => '<p>Defines the possible values for a categorical hyperparameter.</p>', 'refs' => [ 'ParameterRange$CategoricalParameterRangeSpecification' => '<p>A <code>CategoricalParameterRangeSpecification</code> object that defines the possible values for a categorical hyperparameter.</p>', ], ], 'CategoricalParameterRanges' => [ 'base' => NULL, 'refs' => [ 'ParameterRanges$CategoricalParameterRanges' => '<p>The array of <a>CategoricalParameterRange</a> objects that specify ranges of categorical hyperparameters that a hyperparameter tuning job searches.</p>', ], ], 'Cents' => [ 'base' => NULL, 'refs' => [ 'USD$Cents' => '<p>The fractional portion, in cents, of the amount. </p>', ], ], 'CertifyForMarketplace' => [ 'base' => NULL, 'refs' => [ 'CreateAlgorithmInput$CertifyForMarketplace' => '<p>Whether to certify the algorithm so that it can be listed in AWS Marketplace.</p>', 'CreateModelPackageInput$CertifyForMarketplace' => '<p>Whether to certify the model package for listing on AWS Marketplace.</p>', 'DescribeAlgorithmOutput$CertifyForMarketplace' => '<p>Whether the algorithm is certified to be listed in AWS Marketplace.</p>', 'DescribeModelPackageOutput$CertifyForMarketplace' => '<p>Whether the model package is certified for listing on AWS Marketplace.</p>', ], ], 'Channel' => [ 'base' => '<p>A channel is a named input source that training algorithms can consume. </p>', 'refs' => [ 'InputDataConfig$member' => NULL, ], ], 'ChannelName' => [ 'base' => NULL, 'refs' => [ 'Channel$ChannelName' => '<p>The name of the channel. </p>', 'ChannelSpecification$Name' => '<p>The name of the channel.</p>', ], ], 'ChannelSpecification' => [ 'base' => '<p>Defines a named input source, called a channel, to be used by an algorithm.</p>', 'refs' => [ 'ChannelSpecifications$member' => NULL, ], ], 'ChannelSpecifications' => [ 'base' => NULL, 'refs' => [ 'TrainingSpecification$TrainingChannels' => '<p>A list of <code>ChannelSpecification</code> objects, which specify the input sources to be used by the algorithm.</p>', ], ], 'CheckpointConfig' => [ 'base' => '<p>Contains information about the output location for managed spot training checkpoint data. </p>', 'refs' => [ 'CreateTrainingJobRequest$CheckpointConfig' => '<p>Contains information about the output location for managed spot training checkpoint data.</p>', 'DescribeTrainingJobResponse$CheckpointConfig' => NULL, 'HyperParameterTrainingJobDefinition$CheckpointConfig' => NULL, 'TrainingJob$CheckpointConfig' => NULL, ], ], 'Cidr' => [ 'base' => NULL, 'refs' => [ 'Cidrs$member' => NULL, ], ], 'Cidrs' => [ 'base' => NULL, 'refs' => [ 'SourceIpConfig$Cidrs' => '<p>A list of one to ten <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Classless Inter-Domain Routing</a> (CIDR) values.</p> <p>Maximum: Ten CIDR values</p> <note> <p>The following Length Constraints apply to individual CIDR values in the CIDR value list.</p> </note>', ], ], 'ClientId' => [ 'base' => NULL, 'refs' => [ 'CognitoConfig$ClientId' => '<p>The client ID for your Amazon Cognito user pool.</p>', 'CognitoMemberDefinition$ClientId' => '<p>An identifier for an application client. You must create the app client ID using Amazon Cognito.</p>', 'OidcConfig$ClientId' => '<p>The OIDC IdP client ID used to configure your private workforce.</p>', 'OidcConfigForResponse$ClientId' => '<p>The OIDC IdP client ID used to configure your private workforce.</p>', ], ], 'ClientSecret' => [ 'base' => NULL, 'refs' => [ 'OidcConfig$ClientSecret' => '<p>The OIDC IdP client secret used to configure your private workforce.</p>', ], ], 'CodeRepositoryArn' => [ 'base' => NULL, 'refs' => [ 'CodeRepositorySummary$CodeRepositoryArn' => '<p>The Amazon Resource Name (ARN) of the Git repository.</p>', 'CreateCodeRepositoryOutput$CodeRepositoryArn' => '<p>The Amazon Resource Name (ARN) of the new repository.</p>', 'DescribeCodeRepositoryOutput$CodeRepositoryArn' => '<p>The Amazon Resource Name (ARN) of the Git repository.</p>', 'UpdateCodeRepositoryOutput$CodeRepositoryArn' => '<p>The ARN of the Git repository.</p>', ], ], 'CodeRepositoryContains' => [ 'base' => NULL, 'refs' => [ 'ListNotebookInstancesInput$DefaultCodeRepositoryContains' => '<p>A string in the name or URL of a Git repository associated with this notebook instance. This filter returns only notebook instances associated with a git repository with a name that contains the specified string.</p>', ], ], 'CodeRepositoryNameContains' => [ 'base' => NULL, 'refs' => [ 'ListCodeRepositoriesInput$NameContains' => '<p>A string in the Git repositories name. This filter returns only repositories whose name contains the specified string.</p>', ], ], 'CodeRepositoryNameOrUrl' => [ 'base' => NULL, 'refs' => [ 'AdditionalCodeRepositoryNamesOrUrls$member' => NULL, 'CreateNotebookInstanceInput$DefaultCodeRepository' => '<p>A Git repository to associate with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>', 'DescribeNotebookInstanceOutput$DefaultCodeRepository' => '<p>The Git repository associated with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>', 'ListNotebookInstancesInput$AdditionalCodeRepositoryEquals' => '<p>A filter that returns only notebook instances with associated with the specified git repository.</p>', 'NotebookInstanceSummary$DefaultCodeRepository' => '<p>The Git repository associated with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>', 'UpdateNotebookInstanceInput$DefaultCodeRepository' => '<p>The Git repository to associate with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>', ], ], 'CodeRepositorySortBy' => [ 'base' => NULL, 'refs' => [ 'ListCodeRepositoriesInput$SortBy' => '<p>The field to sort results by. The default is <code>Name</code>.</p>', ], ], 'CodeRepositorySortOrder' => [ 'base' => NULL, 'refs' => [ 'ListCodeRepositoriesInput$SortOrder' => '<p>The sort order for results. The default is <code>Ascending</code>.</p>', ], ], 'CodeRepositorySummary' => [ 'base' => '<p>Specifies summary information about a Git repository.</p>', 'refs' => [ 'CodeRepositorySummaryList$member' => NULL, ], ], 'CodeRepositorySummaryList' => [ 'base' => NULL, 'refs' => [ 'ListCodeRepositoriesOutput$CodeRepositorySummaryList' => '<p>Gets a list of summaries of the Git repositories. Each summary specifies the following values for the repository: </p> <ul> <li> <p>Name</p> </li> <li> <p>Amazon Resource Name (ARN)</p> </li> <li> <p>Creation time</p> </li> <li> <p>Last modified time</p> </li> <li> <p>Configuration information, including the URL location of the repository and the ARN of the AWS Secrets Manager secret that contains the credentials used to access the repository.</p> </li> </ul>', ], ], 'CognitoConfig' => [ 'base' => '<p>Use this parameter to configure your Amazon Cognito workforce. A single Cognito workforce is created using and corresponds to a single <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"> Amazon Cognito user pool</a>.</p>', 'refs' => [ 'CreateWorkforceRequest$CognitoConfig' => '<p>Use this parameter to configure an Amazon Cognito private workforce. A single Cognito workforce is created using and corresponds to a single <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"> Amazon Cognito user pool</a>.</p> <p>Do not use <code>OidcConfig</code> if you specify values for <code>CognitoConfig</code>.</p>', 'Workforce$CognitoConfig' => '<p>The configuration of an Amazon Cognito workforce. A single Cognito workforce is created using and corresponds to a single <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"> Amazon Cognito user pool</a>.</p>', ], ], 'CognitoMemberDefinition' => [ 'base' => '<p>Identifies a Amazon Cognito user group. A user group can be used in on or more work teams.</p>', 'refs' => [ 'MemberDefinition$CognitoMemberDefinition' => '<p>The Amazon Cognito user group that is part of the work team.</p>', ], ], 'CognitoUserGroup' => [ 'base' => NULL, 'refs' => [ 'CognitoMemberDefinition$UserGroup' => '<p>An identifier for a user group.</p>', ], ], 'CognitoUserPool' => [ 'base' => NULL, 'refs' => [ 'CognitoConfig$UserPool' => '<p>A <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"> user pool</a> is a user directory in Amazon Cognito. With a user pool, your users can sign in to your web or mobile app through Amazon Cognito. Your users can also sign in through social identity providers like Google, Facebook, Amazon, or Apple, and through SAML identity providers.</p>', 'CognitoMemberDefinition$UserPool' => '<p>An identifier for a user pool. The user pool must be in the same region as the service that you are calling.</p>', ], ], 'CollectionConfiguration' => [ 'base' => '<p>Configuration information for tensor collections.</p>', 'refs' => [ 'CollectionConfigurations$member' => NULL, ], ], 'CollectionConfigurations' => [ 'base' => NULL, 'refs' => [ 'DebugHookConfig$CollectionConfigurations' => '<p>Configuration information for tensor collections.</p>', ], ], 'CollectionName' => [ 'base' => NULL, 'refs' => [ 'CollectionConfiguration$CollectionName' => '<p>The name of the tensor collection. The name must be unique relative to other rule configuration names.</p>', ], ], 'CollectionParameters' => [ 'base' => NULL, 'refs' => [ 'CollectionConfiguration$CollectionParameters' => '<p>Parameter values for the tensor collection. The allowed parameters are <code>"name"</code>, <code>"include_regex"</code>, <code>"reduction_config"</code>, <code>"save_config"</code>, <code>"tensor_names"</code>, and <code>"save_histogram"</code>.</p>', ], ], 'CompilationJobArn' => [ 'base' => NULL, 'refs' => [ 'CompilationJobSummary$CompilationJobArn' => '<p>The Amazon Resource Name (ARN) of the model compilation job.</p>', 'CreateCompilationJobResponse$CompilationJobArn' => '<p>If the action is successful, the service sends back an HTTP 200 response. Amazon SageMaker returns the following data in JSON format:</p> <ul> <li> <p> <code>CompilationJobArn</code>: The Amazon Resource Name (ARN) of the compiled job.</p> </li> </ul>', 'DescribeCompilationJobResponse$CompilationJobArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker assumes to perform the model compilation job.</p>', ], ], 'CompilationJobStatus' => [ 'base' => NULL, 'refs' => [ 'CompilationJobSummary$CompilationJobStatus' => '<p>The status of the model compilation job.</p>', 'DescribeCompilationJobResponse$CompilationJobStatus' => '<p>The status of the model compilation job.</p>', 'ListCompilationJobsRequest$StatusEquals' => '<p>A filter that retrieves model compilation jobs with a specific <a>DescribeCompilationJobResponse$CompilationJobStatus</a> status.</p>', ], ], 'CompilationJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListCompilationJobsResponse$CompilationJobSummaries' => '<p>An array of <a>CompilationJobSummary</a> objects, each describing a model compilation job. </p>', ], ], 'CompilationJobSummary' => [ 'base' => '<p>A summary of a model compilation job.</p>', 'refs' => [ 'CompilationJobSummaries$member' => NULL, ], ], 'CompilerOptions' => [ 'base' => NULL, 'refs' => [ 'OutputConfig$CompilerOptions' => '<p>Specifies additional parameters for compiler options in JSON format. The compiler options are <code>TargetPlatform</code> specific. It is required for NVIDIA accelerators and highly recommended for CPU compliations. For any other cases, it is optional to specify <code>CompilerOptions.</code> </p> <ul> <li> <p> <code>CPU</code>: Compilation for CPU supports the following compiler options.</p> <ul> <li> <p> <code>mcpu</code>: CPU micro-architecture. For example, <code>{\'mcpu\': \'skylake-avx512\'}</code> </p> </li> <li> <p> <code>mattr</code>: CPU flags. For example, <code>{\'mattr\': [\'+neon\', \'+vfpv4\']}</code> </p> </li> </ul> </li> <li> <p> <code>ARM</code>: Details of ARM CPU compilations.</p> <ul> <li> <p> <code>NEON</code>: NEON is an implementation of the Advanced SIMD extension used in ARMv7 processors.</p> <p>For example, add <code>{\'mattr\': [\'+neon\']}</code> to the compiler options if compiling for ARM 32-bit platform with the NEON support.</p> </li> </ul> </li> <li> <p> <code>NVIDIA</code>: Compilation for NVIDIA GPU supports the following compiler options.</p> <ul> <li> <p> <code>gpu_code</code>: Specifies the targeted architecture.</p> </li> <li> <p> <code>trt-ver</code>: Specifies the TensorRT versions in x.y.z. format.</p> </li> <li> <p> <code>cuda-ver</code>: Specifies the CUDA version in x.y format.</p> </li> </ul> <p>For example, <code>{\'gpu-code\': \'sm_72\', \'trt-ver\': \'6.0.1\', \'cuda-ver\': \'10.1\'}</code> </p> </li> <li> <p> <code>ANDROID</code>: Compilation for the Android OS supports the following compiler options:</p> <ul> <li> <p> <code>ANDROID_PLATFORM</code>: Specifies the Android API levels. Available levels range from 21 to 29. For example, <code>{\'ANDROID_PLATFORM\': 28}</code>.</p> </li> <li> <p> <code>mattr</code>: Add <code>{\'mattr\': [\'+neon\']}</code> to compiler options if compiling for ARM 32-bit platform with NEON support.</p> </li> </ul> </li> </ul>', ], ], 'CompressionType' => [ 'base' => NULL, 'refs' => [ 'AutoMLChannel$CompressionType' => '<p>You can use Gzip or None. The default value is None.</p>', 'Channel$CompressionType' => '<p>If training data is compressed, the compression type. The default value is <code>None</code>. <code>CompressionType</code> is used only in Pipe input mode. In File mode, leave this field unset or set it to None.</p>', 'CompressionTypes$member' => NULL, 'TransformInput$CompressionType' => '<p>If your transform data is compressed, specify the compression type. Amazon SageMaker automatically decompresses the data for the transform job accordingly. The default value is <code>None</code>.</p>', ], ], 'CompressionTypes' => [ 'base' => NULL, 'refs' => [ 'ChannelSpecification$SupportedCompressionTypes' => '<p>The allowed compression types, if data compression is used.</p>', ], ], 'ConfigKey' => [ 'base' => NULL, 'refs' => [ 'CollectionParameters$key' => NULL, 'HookParameters$key' => NULL, 'RuleParameters$key' => NULL, ], ], 'ConfigValue' => [ 'base' => NULL, 'refs' => [ 'CollectionParameters$value' => NULL, 'HookParameters$value' => NULL, 'RuleParameters$value' => NULL, ], ], 'ConflictException' => [ 'base' => '<p>There was a conflict when you attempted to modify an experiment, trial, or trial component.</p>', 'refs' => [], ], 'ContainerArgument' => [ 'base' => NULL, 'refs' => [ 'ContainerArguments$member' => NULL, 'MonitoringContainerArguments$member' => NULL, ], ], 'ContainerArguments' => [ 'base' => NULL, 'refs' => [ 'AppSpecification$ContainerArguments' => '<p>The arguments for a container used to run a processing job.</p>', ], ], 'ContainerDefinition' => [ 'base' => '<p>Describes the container, as part of model definition.</p>', 'refs' => [ 'ContainerDefinitionList$member' => NULL, 'CreateModelInput$PrimaryContainer' => '<p>The location of the primary docker image containing inference code, associated artifacts, and custom environment map that the inference code uses when the model is deployed for predictions. </p>', 'DescribeModelOutput$PrimaryContainer' => '<p>The location of the primary inference code, associated artifacts, and custom environment map that the inference code uses when it is deployed in production. </p>', ], ], 'ContainerDefinitionList' => [ 'base' => NULL, 'refs' => [ 'CreateModelInput$Containers' => '<p>Specifies the containers in the inference pipeline.</p>', 'DescribeModelOutput$Containers' => '<p>The containers in the inference pipeline.</p>', ], ], 'ContainerEntrypoint' => [ 'base' => NULL, 'refs' => [ 'AppSpecification$ContainerEntrypoint' => '<p>The entrypoint for a container used to run a processing job.</p>', 'MonitoringAppSpecification$ContainerEntrypoint' => '<p>Specifies the entrypoint for a container used to run the monitoring job.</p>', ], ], 'ContainerEntrypointString' => [ 'base' => NULL, 'refs' => [ 'ContainerEntrypoint$member' => NULL, ], ], 'ContainerHostname' => [ 'base' => NULL, 'refs' => [ 'ContainerDefinition$ContainerHostname' => '<p>This parameter is ignored for models that contain only a <code>PrimaryContainer</code>.</p> <p>When a <code>ContainerDefinition</code> is part of an inference pipeline, the value of the parameter uniquely identifies the container for the purposes of logging and metrics. For information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/inference-pipeline-logs-metrics.html">Use Logs and Metrics to Monitor an Inference Pipeline</a>. If you don\'t specify a value for this parameter for a <code>ContainerDefinition</code> that is part of an inference pipeline, a unique name is automatically assigned based on the position of the <code>ContainerDefinition</code> in the pipeline. If you specify a value for the <code>ContainerHostName</code> for any <code>ContainerDefinition</code> that is part of an inference pipeline, you must specify a value for the <code>ContainerHostName</code> parameter of every <code>ContainerDefinition</code> in that pipeline.</p>', 'ModelPackageContainerDefinition$ContainerHostname' => '<p>The DNS host name for the Docker container.</p>', ], ], 'ContainerImage' => [ 'base' => NULL, 'refs' => [ 'AutoMLContainerDefinition$Image' => '<p>The ECR path of the container. Refer to ContainerDefinition for more details.</p>', 'ContainerDefinition$Image' => '<p>The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored. If you are using your own custom algorithm instead of an algorithm provided by Amazon SageMaker, the inference code must meet Amazon SageMaker requirements. Amazon SageMaker supports both <code>registry/repository[:tag]</code> and <code>registry/repository[@digest]</code> image path formats. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon SageMaker</a> </p>', 'DeployedImage$SpecifiedImage' => '<p>The image path you specified when you created the model.</p>', 'DeployedImage$ResolvedImage' => '<p>The specific digest path of the image hosted in this <code>ProductionVariant</code>.</p>', 'ModelPackageContainerDefinition$Image' => '<p>The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored.</p> <p>If you are using your own custom algorithm instead of an algorithm provided by Amazon SageMaker, the inference code must meet Amazon SageMaker requirements. Amazon SageMaker supports both <code>registry/repository[:tag]</code> and <code>registry/repository[@digest]</code> image path formats. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon SageMaker</a>.</p>', 'TrainingSpecification$TrainingImage' => '<p>The Amazon ECR registry path of the Docker image that contains the training algorithm.</p>', ], ], 'ContainerMode' => [ 'base' => NULL, 'refs' => [ 'ContainerDefinition$Mode' => '<p>Whether the container hosts a single model or multiple models.</p>', ], ], 'ContentClassifier' => [ 'base' => NULL, 'refs' => [ 'ContentClassifiers$member' => NULL, ], ], 'ContentClassifiers' => [ 'base' => NULL, 'refs' => [ 'LabelingJobDataAttributes$ContentClassifiers' => '<p>Declares that your content is free of personally identifiable information or adult content. Amazon SageMaker may restrict the Amazon Mechanical Turk workers that can view your task based on this information.</p>', ], ], 'ContentType' => [ 'base' => NULL, 'refs' => [ 'Channel$ContentType' => '<p>The MIME type of the data.</p>', 'ContentTypes$member' => NULL, 'TransformInput$ContentType' => '<p>The multipurpose internet mail extension (MIME) type of the data. Amazon SageMaker uses the MIME type with each http call to transfer data to the transform job.</p>', ], ], 'ContentTypes' => [ 'base' => NULL, 'refs' => [ 'ChannelSpecification$SupportedContentTypes' => '<p>The supported MIME types for the data.</p>', 'InferenceSpecification$SupportedContentTypes' => '<p>The supported MIME types for the input data.</p>', ], ], 'ContinuousParameterRange' => [ 'base' => '<p>A list of continuous hyperparameters to tune.</p>', 'refs' => [ 'ContinuousParameterRanges$member' => NULL, ], ], 'ContinuousParameterRangeSpecification' => [ 'base' => '<p>Defines the possible values for a continuous hyperparameter.</p>', 'refs' => [ 'ParameterRange$ContinuousParameterRangeSpecification' => '<p>A <code>ContinuousParameterRangeSpecification</code> object that defines the possible values for a continuous hyperparameter.</p>', ], ], 'ContinuousParameterRanges' => [ 'base' => NULL, 'refs' => [ 'ParameterRanges$ContinuousParameterRanges' => '<p>The array of <a>ContinuousParameterRange</a> objects that specify ranges of continuous hyperparameters that a hyperparameter tuning job searches.</p>', ], ], 'CreateAlgorithmInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateAlgorithmOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAutoMLJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAutoMLJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateCodeRepositoryInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateCodeRepositoryOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateCompilationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCompilationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateEndpointConfigInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateEndpointConfigOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateEndpointInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateEndpointOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateExperimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateExperimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFlowDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFlowDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateHumanTaskUiRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateHumanTaskUiResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateHyperParameterTuningJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateHyperParameterTuningJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateLabelingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLabelingJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelPackageInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelPackageOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateMonitoringScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMonitoringScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateNotebookInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateNotebookInstanceLifecycleConfigInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateNotebookInstanceLifecycleConfigOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateNotebookInstanceOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreatePresignedDomainUrlRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePresignedDomainUrlResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePresignedNotebookInstanceUrlInput' => [ 'base' => NULL, 'refs' => [], ], 'CreatePresignedNotebookInstanceUrlOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateProcessingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateProcessingJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrainingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrainingJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransformJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransformJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrialComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrialComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrialRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrialResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkforceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkforceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkteamRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkteamResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreationTime' => [ 'base' => NULL, 'refs' => [ 'AlgorithmSummary$CreationTime' => '<p>A timestamp that shows when the algorithm was created.</p>', 'AppDetails$CreationTime' => '<p>The creation time.</p>', 'CodeRepositorySummary$CreationTime' => '<p>The date and time that the Git repository was created.</p>', 'CompilationJobSummary$CreationTime' => '<p>The time when the model compilation job was created.</p>', 'DescribeAlgorithmOutput$CreationTime' => '<p>A timestamp specifying when the algorithm was created.</p>', 'DescribeAppResponse$CreationTime' => '<p>The creation time.</p>', 'DescribeCodeRepositoryOutput$CreationTime' => '<p>The date and time that the repository was created.</p>', 'DescribeCompilationJobResponse$CreationTime' => '<p>The time that the model compilation job was created.</p>', 'DescribeDomainResponse$CreationTime' => '<p>The creation time.</p>', 'DescribeModelPackageOutput$CreationTime' => '<p>A timestamp specifying when the model package was created.</p>', 'DescribeNotebookInstanceLifecycleConfigOutput$CreationTime' => '<p>A timestamp that tells when the lifecycle configuration was created.</p>', 'DescribeNotebookInstanceOutput$CreationTime' => '<p>A timestamp. Use this parameter to return the time when the notebook instance was created</p>', 'DescribeUserProfileResponse$CreationTime' => '<p>The creation time.</p>', 'DomainDetails$CreationTime' => '<p>The creation time.</p>', 'ListAlgorithmsInput$CreationTimeAfter' => '<p>A filter that returns only algorithms created after the specified time (timestamp).</p>', 'ListAlgorithmsInput$CreationTimeBefore' => '<p>A filter that returns only algorithms created before the specified time (timestamp).</p>', 'ListCodeRepositoriesInput$CreationTimeAfter' => '<p>A filter that returns only Git repositories that were created after the specified time.</p>', 'ListCodeRepositoriesInput$CreationTimeBefore' => '<p>A filter that returns only Git repositories that were created before the specified time.</p>', 'ListCompilationJobsRequest$CreationTimeAfter' => '<p>A filter that returns the model compilation jobs that were created after a specified time. </p>', 'ListCompilationJobsRequest$CreationTimeBefore' => '<p>A filter that returns the model compilation jobs that were created before a specified time.</p>', 'ListModelPackagesInput$CreationTimeAfter' => '<p>A filter that returns only model packages created after the specified time (timestamp).</p>', 'ListModelPackagesInput$CreationTimeBefore' => '<p>A filter that returns only model packages created before the specified time (timestamp).</p>', 'ListNotebookInstanceLifecycleConfigsInput$CreationTimeBefore' => '<p>A filter that returns only lifecycle configurations that were created before the specified time (timestamp).</p>', 'ListNotebookInstanceLifecycleConfigsInput$CreationTimeAfter' => '<p>A filter that returns only lifecycle configurations that were created after the specified time (timestamp).</p>', 'ListNotebookInstancesInput$CreationTimeBefore' => '<p>A filter that returns only notebook instances that were created before the specified time (timestamp). </p>', 'ListNotebookInstancesInput$CreationTimeAfter' => '<p>A filter that returns only notebook instances that were created after the specified time (timestamp).</p>', 'ModelPackageSummary$CreationTime' => '<p>A timestamp that shows when the model package was created.</p>', 'NotebookInstanceLifecycleConfigSummary$CreationTime' => '<p>A timestamp that tells when the lifecycle configuration was created.</p>', 'NotebookInstanceSummary$CreationTime' => '<p>A timestamp that shows when the notebook instance was created.</p>', 'UserProfileDetails$CreationTime' => '<p>The creation time.</p>', ], ], 'CsvContentType' => [ 'base' => NULL, 'refs' => [ 'CsvContentTypes$member' => NULL, ], ], 'CsvContentTypes' => [ 'base' => NULL, 'refs' => [ 'CaptureContentTypeHeader$CsvContentTypes' => '<p/>', ], ], 'DataCaptureConfig' => [ 'base' => '<p/>', 'refs' => [ 'CreateEndpointConfigInput$DataCaptureConfig' => NULL, 'DescribeEndpointConfigOutput$DataCaptureConfig' => NULL, ], ], 'DataCaptureConfigSummary' => [ 'base' => '<p/>', 'refs' => [ 'DescribeEndpointOutput$DataCaptureConfig' => NULL, ], ], 'DataExplorationNotebookLocation' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobArtifacts$DataExplorationNotebookLocation' => '<p>The URL to the notebook location.</p>', ], ], 'DataInputConfig' => [ 'base' => NULL, 'refs' => [ 'InputConfig$DataInputConfig' => '<p>Specifies the name and shape of the expected data inputs for your trained model with a JSON dictionary form. The data inputs are <a>InputConfig$Framework</a> specific. </p> <ul> <li> <p> <code>TensorFlow</code>: You must specify the name and shape (NHWC format) of the expected data inputs using a dictionary format for your trained model. The dictionary formats required for the console and CLI are different.</p> <ul> <li> <p>Examples for one input:</p> <ul> <li> <p>If using the console, <code>{"input":[1,1024,1024,3]}</code> </p> </li> <li> <p>If using the CLI, <code>{\\"input\\":[1,1024,1024,3]}</code> </p> </li> </ul> </li> <li> <p>Examples for two inputs:</p> <ul> <li> <p>If using the console, <code>{"data1": [1,28,28,1], "data2":[1,28,28,1]}</code> </p> </li> <li> <p>If using the CLI, <code>{\\"data1\\": [1,28,28,1], \\"data2\\":[1,28,28,1]}</code> </p> </li> </ul> </li> </ul> </li> <li> <p> <code>KERAS</code>: You must specify the name and shape (NCHW format) of expected data inputs using a dictionary format for your trained model. Note that while Keras model artifacts should be uploaded in NHWC (channel-last) format, <code>DataInputConfig</code> should be specified in NCHW (channel-first) format. The dictionary formats required for the console and CLI are different.</p> <ul> <li> <p>Examples for one input:</p> <ul> <li> <p>If using the console, <code>{"input_1":[1,3,224,224]}</code> </p> </li> <li> <p>If using the CLI, <code>{\\"input_1\\":[1,3,224,224]}</code> </p> </li> </ul> </li> <li> <p>Examples for two inputs:</p> <ul> <li> <p>If using the console, <code>{"input_1": [1,3,224,224], "input_2":[1,3,224,224]} </code> </p> </li> <li> <p>If using the CLI, <code>{\\"input_1\\": [1,3,224,224], \\"input_2\\":[1,3,224,224]}</code> </p> </li> </ul> </li> </ul> </li> <li> <p> <code>MXNET/ONNX</code>: You must specify the name and shape (NCHW format) of the expected data inputs in order using a dictionary format for your trained model. The dictionary formats required for the console and CLI are different.</p> <ul> <li> <p>Examples for one input:</p> <ul> <li> <p>If using the console, <code>{"data":[1,3,1024,1024]}</code> </p> </li> <li> <p>If using the CLI, <code>{\\"data\\":[1,3,1024,1024]}</code> </p> </li> </ul> </li> <li> <p>Examples for two inputs:</p> <ul> <li> <p>If using the console, <code>{"var1": [1,1,28,28], "var2":[1,1,28,28]} </code> </p> </li> <li> <p>If using the CLI, <code>{\\"var1\\": [1,1,28,28], \\"var2\\":[1,1,28,28]}</code> </p> </li> </ul> </li> </ul> </li> <li> <p> <code>PyTorch</code>: You can either specify the name and shape (NCHW format) of expected data inputs in order using a dictionary format for your trained model or you can specify the shape only using a list format. The dictionary formats required for the console and CLI are different. The list formats for the console and CLI are the same.</p> <ul> <li> <p>Examples for one input in dictionary format:</p> <ul> <li> <p>If using the console, <code>{"input0":[1,3,224,224]}</code> </p> </li> <li> <p>If using the CLI, <code>{\\"input0\\":[1,3,224,224]}</code> </p> </li> </ul> </li> <li> <p>Example for one input in list format: <code>[[1,3,224,224]]</code> </p> </li> <li> <p>Examples for two inputs in dictionary format:</p> <ul> <li> <p>If using the console, <code>{"input0":[1,3,224,224], "input1":[1,3,224,224]}</code> </p> </li> <li> <p>If using the CLI, <code>{\\"input0\\":[1,3,224,224], \\"input1\\":[1,3,224,224]} </code> </p> </li> </ul> </li> <li> <p>Example for two inputs in list format: <code>[[1,3,224,224], [1,3,224,224]]</code> </p> </li> </ul> </li> <li> <p> <code>XGBOOST</code>: input data name and shape are not needed.</p> </li> </ul>', ], ], 'DataProcessing' => [ 'base' => '<p>The data structure used to specify the data to be used for inference in a batch transform job and to associate the data that is relevant to the prediction results in the output. The input filter provided allows you to exclude input data that is not needed for inference in a batch transform job. The output filter provided allows you to include input data relevant to interpreting the predictions in the output from the job. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html">Associate Prediction Results with their Corresponding Input Records</a>.</p>', 'refs' => [ 'CreateTransformJobRequest$DataProcessing' => '<p>The data structure used to specify the data to be used for inference in a batch transform job and to associate the data that is relevant to the prediction results in the output. The input filter provided allows you to exclude input data that is not needed for inference in a batch transform job. The output filter provided allows you to include input data relevant to interpreting the predictions in the output from the job. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html">Associate Prediction Results with their Corresponding Input Records</a>.</p>', 'DescribeTransformJobResponse$DataProcessing' => NULL, 'TransformJob$DataProcessing' => NULL, ], ], 'DataSource' => [ 'base' => '<p>Describes the location of the channel data.</p>', 'refs' => [ 'Channel$DataSource' => '<p>The location of the channel data.</p>', ], ], 'DebugHookConfig' => [ 'base' => '<p>Configuration information for the debug hook parameters, collection configuration, and storage paths.</p>', 'refs' => [ 'CreateTrainingJobRequest$DebugHookConfig' => NULL, 'DescribeTrainingJobResponse$DebugHookConfig' => NULL, 'TrainingJob$DebugHookConfig' => NULL, ], ], 'DebugRuleConfiguration' => [ 'base' => '<p>Configuration information for debugging rules.</p>', 'refs' => [ 'DebugRuleConfigurations$member' => NULL, ], ], 'DebugRuleConfigurations' => [ 'base' => NULL, 'refs' => [ 'CreateTrainingJobRequest$DebugRuleConfigurations' => '<p>Configuration information for debugging rules.</p>', 'DescribeTrainingJobResponse$DebugRuleConfigurations' => '<p>Configuration information for debugging rules.</p>', 'TrainingJob$DebugRuleConfigurations' => '<p>Information about the debug rule configuration.</p>', ], ], 'DebugRuleEvaluationStatus' => [ 'base' => '<p>Information about the status of the rule evaluation.</p>', 'refs' => [ 'DebugRuleEvaluationStatuses$member' => NULL, ], ], 'DebugRuleEvaluationStatuses' => [ 'base' => NULL, 'refs' => [ 'DescribeTrainingJobResponse$DebugRuleEvaluationStatuses' => '<p>Status about the debug rule evaluation.</p>', 'TrainingJob$DebugRuleEvaluationStatuses' => '<p>Information about the evaluation status of the rules for the training job.</p>', ], ], 'DeleteAlgorithmInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCodeRepositoryInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEndpointConfigInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEndpointInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteExperimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteExperimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFlowDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFlowDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteHumanTaskUiRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteHumanTaskUiResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteModelInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteModelPackageInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMonitoringScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNotebookInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNotebookInstanceLifecycleConfigInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTagsInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTagsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrialComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrialComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrialRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrialResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkforceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkforceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkteamRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkteamResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeployedImage' => [ 'base' => '<p>Gets the Amazon EC2 Container Registry path of the docker image of the model that is hosted in this <a>ProductionVariant</a>.</p> <p>If you used the <code>registry/repository[:tag]</code> form to specify the image path of the primary container when you created the model hosted in this <code>ProductionVariant</code>, the path resolves to a path of the form <code>registry/repository[@digest]</code>. A digest is a hash value that identifies a specific version of an image. For information about Amazon ECR paths, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/docker-pull-ecr-image.html">Pulling an Image</a> in the <i>Amazon ECR User Guide</i>.</p>', 'refs' => [ 'DeployedImages$member' => NULL, ], ], 'DeployedImages' => [ 'base' => NULL, 'refs' => [ 'ProductionVariantSummary$DeployedImages' => '<p>An array of <code>DeployedImage</code> objects that specify the Amazon EC2 Container Registry paths of the inference images deployed on instances of this <code>ProductionVariant</code>.</p>', ], ], 'DescribeAlgorithmInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAlgorithmOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAutoMLJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAutoMLJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCodeRepositoryInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCodeRepositoryOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCompilationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCompilationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEndpointConfigInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEndpointConfigOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEndpointInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEndpointOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExperimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExperimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFlowDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFlowDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHumanTaskUiRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHumanTaskUiResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHyperParameterTuningJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHyperParameterTuningJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLabelingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLabelingJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelPackageInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelPackageOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMonitoringScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMonitoringScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNotebookInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNotebookInstanceLifecycleConfigInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNotebookInstanceLifecycleConfigOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNotebookInstanceOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProcessingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProcessingJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSubscribedWorkteamRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSubscribedWorkteamResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrainingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrainingJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransformJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransformJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrialComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrialComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrialRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrialResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkforceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkforceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkteamRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkteamResponse' => [ 'base' => NULL, 'refs' => [], ], 'DesiredWeightAndCapacity' => [ 'base' => '<p>Specifies weight and capacity values for a production variant.</p>', 'refs' => [ 'DesiredWeightAndCapacityList$member' => NULL, ], ], 'DesiredWeightAndCapacityList' => [ 'base' => NULL, 'refs' => [ 'UpdateEndpointWeightsAndCapacitiesInput$DesiredWeightsAndCapacities' => '<p>An object that provides new capacity and weight values for a variant.</p>', ], ], 'DestinationS3Uri' => [ 'base' => NULL, 'refs' => [ 'DataCaptureConfig$DestinationS3Uri' => '<p/>', 'DataCaptureConfigSummary$DestinationS3Uri' => '<p/>', ], ], 'DetailedAlgorithmStatus' => [ 'base' => NULL, 'refs' => [ 'AlgorithmStatusItem$Status' => '<p>The current status.</p>', ], ], 'DetailedModelPackageStatus' => [ 'base' => NULL, 'refs' => [ 'ModelPackageStatusItem$Status' => '<p>The current status.</p>', ], ], 'DirectInternetAccess' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceInput$DirectInternetAccess' => '<p>Sets whether Amazon SageMaker provides internet access to the notebook instance. If you set this to <code>Disabled</code> this notebook instance will be able to access resources only in your VPC, and will not be able to connect to Amazon SageMaker training and endpoint services unless your configure a NAT Gateway in your VPC.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access">Notebook Instances Are Internet-Enabled by Default</a>. You can set the value of this parameter to <code>Disabled</code> only if you set a value for the <code>SubnetId</code> parameter.</p>', 'DescribeNotebookInstanceOutput$DirectInternetAccess' => '<p>Describes whether Amazon SageMaker provides internet access to the notebook instance. If this value is set to <i>Disabled</i>, the notebook instance does not have internet access, and cannot connect to Amazon SageMaker training and endpoint services.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access">Notebook Instances Are Internet-Enabled by Default</a>.</p>', ], ], 'DirectoryPath' => [ 'base' => NULL, 'refs' => [ 'CheckpointConfig$LocalPath' => '<p>(Optional) The local directory where checkpoints are written. The default directory is <code>/opt/ml/checkpoints/</code>. </p>', 'DebugHookConfig$LocalPath' => '<p>Path to local storage location for tensors. Defaults to <code>/opt/ml/output/tensors/</code>.</p>', 'DebugRuleConfiguration$LocalPath' => '<p>Path to local storage location for output of rules. Defaults to <code>/opt/ml/processing/output/rule/</code>.</p>', 'FileSystemDataSource$DirectoryPath' => '<p>The full path to the directory to associate with the channel.</p>', 'TensorBoardOutputConfig$LocalPath' => '<p>Path to local storage location for tensorBoard output. Defaults to <code>/opt/ml/output/tensorboard</code>.</p>', ], ], 'DisassociateAdditionalCodeRepositories' => [ 'base' => NULL, 'refs' => [ 'UpdateNotebookInstanceInput$DisassociateAdditionalCodeRepositories' => '<p>A list of names or URLs of the default Git repositories to remove from this notebook instance. This operation is idempotent. If you specify a Git repository that is not associated with the notebook instance when you call this method, it does not throw an error.</p>', ], ], 'DisassociateDefaultCodeRepository' => [ 'base' => NULL, 'refs' => [ 'UpdateNotebookInstanceInput$DisassociateDefaultCodeRepository' => '<p>The name or URL of the default Git repository to remove from this notebook instance. This operation is idempotent. If you specify a Git repository that is not associated with the notebook instance when you call this method, it does not throw an error.</p>', ], ], 'DisassociateNotebookInstanceAcceleratorTypes' => [ 'base' => NULL, 'refs' => [ 'UpdateNotebookInstanceInput$DisassociateAcceleratorTypes' => '<p>A list of the Elastic Inference (EI) instance types to remove from this notebook instance. This operation is idempotent. If you specify an accelerator type that is not associated with the notebook instance when you call this method, it does not throw an error.</p>', ], ], 'DisassociateNotebookInstanceLifecycleConfig' => [ 'base' => NULL, 'refs' => [ 'UpdateNotebookInstanceInput$DisassociateLifecycleConfig' => '<p>Set to <code>true</code> to remove the notebook instance lifecycle configuration currently associated with the notebook instance. This operation is idempotent. If you specify a lifecycle configuration that is not associated with the notebook instance when you call this method, it does not throw an error.</p>', ], ], 'DisassociateTrialComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateTrialComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'Dollars' => [ 'base' => NULL, 'refs' => [ 'USD$Dollars' => '<p>The whole number of dollars in the amount.</p>', ], ], 'DomainArn' => [ 'base' => NULL, 'refs' => [ 'CreateDomainResponse$DomainArn' => '<p>The Amazon Resource Name (ARN) of the created domain.</p>', 'DescribeDomainResponse$DomainArn' => '<p>The domain\'s Amazon Resource Name (ARN).</p>', 'DomainDetails$DomainArn' => '<p>The domain\'s Amazon Resource Name (ARN).</p>', 'UpdateDomainResponse$DomainArn' => '<p>The Amazon Resource Name (ARN) of the domain.</p>', ], ], 'DomainDetails' => [ 'base' => '<p>The domain\'s details.</p>', 'refs' => [ 'DomainList$member' => NULL, ], ], 'DomainId' => [ 'base' => NULL, 'refs' => [ 'AppDetails$DomainId' => '<p>The domain ID.</p>', 'CreateAppRequest$DomainId' => '<p>The domain ID.</p>', 'CreatePresignedDomainUrlRequest$DomainId' => '<p>The domain ID.</p>', 'CreateUserProfileRequest$DomainId' => '<p>The ID of the associated Domain.</p>', 'DeleteAppRequest$DomainId' => '<p>The domain ID.</p>', 'DeleteDomainRequest$DomainId' => '<p>The domain ID.</p>', 'DeleteUserProfileRequest$DomainId' => '<p>The domain ID.</p>', 'DescribeAppRequest$DomainId' => '<p>The domain ID.</p>', 'DescribeAppResponse$DomainId' => '<p>The domain ID.</p>', 'DescribeDomainRequest$DomainId' => '<p>The domain ID.</p>', 'DescribeDomainResponse$DomainId' => '<p>The domain ID.</p>', 'DescribeUserProfileRequest$DomainId' => '<p>The domain ID.</p>', 'DescribeUserProfileResponse$DomainId' => '<p>The ID of the domain that contains the profile.</p>', 'DomainDetails$DomainId' => '<p>The domain ID.</p>', 'ListAppsRequest$DomainIdEquals' => '<p>A parameter to search for the domain ID.</p>', 'ListUserProfilesRequest$DomainIdEquals' => '<p>A parameter by which to filter the results.</p>', 'UpdateDomainRequest$DomainId' => '<p>The ID of the domain to be updated.</p>', 'UpdateUserProfileRequest$DomainId' => '<p>The domain ID.</p>', 'UserProfileDetails$DomainId' => '<p>The domain ID.</p>', ], ], 'DomainList' => [ 'base' => NULL, 'refs' => [ 'ListDomainsResponse$Domains' => '<p>The list of domains.</p>', ], ], 'DomainName' => [ 'base' => NULL, 'refs' => [ 'CreateDomainRequest$DomainName' => '<p>A name for the domain.</p>', 'DescribeDomainResponse$DomainName' => '<p>The domain name.</p>', 'DomainDetails$DomainName' => '<p>The domain name.</p>', ], ], 'DomainStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeDomainResponse$Status' => '<p>The status.</p>', 'DomainDetails$Status' => '<p>The status.</p>', ], ], 'DoubleParameterValue' => [ 'base' => NULL, 'refs' => [ 'TrialComponentParameterValue$NumberValue' => '<p>The numeric value of a numeric hyperparameter. If you specify a value for this parameter, you can\'t specify the <code>StringValue</code> parameter.</p>', ], ], 'EfsUid' => [ 'base' => NULL, 'refs' => [ 'DescribeUserProfileResponse$HomeEfsFileSystemUid' => '<p>The ID of the user\'s profile in the Amazon Elastic File System (EFS) volume.</p>', ], ], 'EnableCapture' => [ 'base' => NULL, 'refs' => [ 'DataCaptureConfig$EnableCapture' => '<p/>', 'DataCaptureConfigSummary$EnableCapture' => '<p/>', ], ], 'EndpointArn' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointOutput$EndpointArn' => '<p>The Amazon Resource Name (ARN) of the endpoint.</p>', 'DescribeEndpointOutput$EndpointArn' => '<p>The Amazon Resource Name (ARN) of the endpoint.</p>', 'EndpointSummary$EndpointArn' => '<p>The Amazon Resource Name (ARN) of the endpoint.</p>', 'UpdateEndpointOutput$EndpointArn' => '<p>The Amazon Resource Name (ARN) of the endpoint.</p>', 'UpdateEndpointWeightsAndCapacitiesOutput$EndpointArn' => '<p>The Amazon Resource Name (ARN) of the updated endpoint.</p>', ], ], 'EndpointConfigArn' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointConfigOutput$EndpointConfigArn' => '<p>The Amazon Resource Name (ARN) of the endpoint configuration. </p>', 'DescribeEndpointConfigOutput$EndpointConfigArn' => '<p>The Amazon Resource Name (ARN) of the endpoint configuration.</p>', 'EndpointConfigSummary$EndpointConfigArn' => '<p>The Amazon Resource Name (ARN) of the endpoint configuration.</p>', ], ], 'EndpointConfigName' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointConfigInput$EndpointConfigName' => '<p>The name of the endpoint configuration. You specify this name in a <a>CreateEndpoint</a> request. </p>', 'CreateEndpointInput$EndpointConfigName' => '<p>The name of an endpoint configuration. For more information, see <a>CreateEndpointConfig</a>. </p>', 'DeleteEndpointConfigInput$EndpointConfigName' => '<p>The name of the endpoint configuration that you want to delete.</p>', 'DescribeEndpointConfigInput$EndpointConfigName' => '<p>The name of the endpoint configuration.</p>', 'DescribeEndpointConfigOutput$EndpointConfigName' => '<p>Name of the Amazon SageMaker endpoint configuration.</p>', 'DescribeEndpointOutput$EndpointConfigName' => '<p>The name of the endpoint configuration associated with this endpoint.</p>', 'EndpointConfigSummary$EndpointConfigName' => '<p>The name of the endpoint configuration.</p>', 'UpdateEndpointInput$EndpointConfigName' => '<p>The name of the new endpoint configuration.</p>', ], ], 'EndpointConfigNameContains' => [ 'base' => NULL, 'refs' => [ 'ListEndpointConfigsInput$NameContains' => '<p>A string in the endpoint configuration name. This filter returns only endpoint configurations whose name contains the specified string. </p>', ], ], 'EndpointConfigSortKey' => [ 'base' => NULL, 'refs' => [ 'ListEndpointConfigsInput$SortBy' => '<p>The field to sort results by. The default is <code>CreationTime</code>.</p>', ], ], 'EndpointConfigSummary' => [ 'base' => '<p>Provides summary information for an endpoint configuration.</p>', 'refs' => [ 'EndpointConfigSummaryList$member' => NULL, ], ], 'EndpointConfigSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListEndpointConfigsOutput$EndpointConfigs' => '<p>An array of endpoint configurations.</p>', ], ], 'EndpointInput' => [ 'base' => '<p>Input object for the endpoint</p>', 'refs' => [ 'MonitoringInput$EndpointInput' => '<p>The endpoint for a monitoring job.</p>', ], ], 'EndpointName' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointInput$EndpointName' => '<p>The name of the endpoint. The name must be unique within an AWS Region in your AWS account.</p>', 'DeleteEndpointInput$EndpointName' => '<p>The name of the endpoint that you want to delete.</p>', 'DescribeEndpointInput$EndpointName' => '<p>The name of the endpoint.</p>', 'DescribeEndpointOutput$EndpointName' => '<p>Name of the endpoint.</p>', 'DescribeMonitoringScheduleResponse$EndpointName' => '<p> The name of the endpoint for the monitoring job.</p>', 'EndpointInput$EndpointName' => '<p>An endpoint in customer\'s account which has enabled <code>DataCaptureConfig</code> enabled.</p>', 'EndpointSummary$EndpointName' => '<p>The name of the endpoint.</p>', 'ListMonitoringExecutionsRequest$EndpointName' => '<p>Name of a specific endpoint to fetch jobs for.</p>', 'ListMonitoringSchedulesRequest$EndpointName' => '<p>Name of a specific endpoint to fetch schedules for.</p>', 'MonitoringExecutionSummary$EndpointName' => '<p>The name of teh endpoint used to run the monitoring job.</p>', 'MonitoringScheduleSummary$EndpointName' => '<p>The name of the endpoint using the monitoring schedule.</p>', 'UpdateEndpointInput$EndpointName' => '<p>The name of the endpoint whose configuration you want to update.</p>', 'UpdateEndpointWeightsAndCapacitiesInput$EndpointName' => '<p>The name of an existing Amazon SageMaker endpoint.</p>', ], ], 'EndpointNameContains' => [ 'base' => NULL, 'refs' => [ 'ListEndpointsInput$NameContains' => '<p>A string in endpoint names. This filter returns only endpoints whose name contains the specified string.</p>', ], ], 'EndpointSortKey' => [ 'base' => NULL, 'refs' => [ 'ListEndpointsInput$SortBy' => '<p>Sorts the list of results. The default is <code>CreationTime</code>.</p>', ], ], 'EndpointStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeEndpointOutput$EndpointStatus' => '<p>The status of the endpoint.</p> <ul> <li> <p> <code>OutOfService</code>: Endpoint is not available to take incoming requests.</p> </li> <li> <p> <code>Creating</code>: <a>CreateEndpoint</a> is executing.</p> </li> <li> <p> <code>Updating</code>: <a>UpdateEndpoint</a> or <a>UpdateEndpointWeightsAndCapacities</a> is executing.</p> </li> <li> <p> <code>SystemUpdating</code>: Endpoint is undergoing maintenance and cannot be updated or deleted or re-scaled until it has completed. This maintenance operation does not change any customer-specified values such as VPC config, KMS encryption, model, instance type, or instance count.</p> </li> <li> <p> <code>RollingBack</code>: Endpoint fails to scale up or down or change its variant weight and is in the process of rolling back to its previous configuration. Once the rollback completes, endpoint returns to an <code>InService</code> status. This transitional status only applies to an endpoint that has autoscaling enabled and is undergoing variant weight or capacity changes as part of an <a>UpdateEndpointWeightsAndCapacities</a> call or when the <a>UpdateEndpointWeightsAndCapacities</a> operation is called explicitly.</p> </li> <li> <p> <code>InService</code>: Endpoint is available to process incoming requests.</p> </li> <li> <p> <code>Deleting</code>: <a>DeleteEndpoint</a> is executing.</p> </li> <li> <p> <code>Failed</code>: Endpoint could not be created, updated, or re-scaled. Use <a>DescribeEndpointOutput$FailureReason</a> for information about the failure. <a>DeleteEndpoint</a> is the only operation that can be performed on a failed endpoint.</p> </li> </ul>', 'EndpointSummary$EndpointStatus' => '<p>The status of the endpoint.</p> <ul> <li> <p> <code>OutOfService</code>: Endpoint is not available to take incoming requests.</p> </li> <li> <p> <code>Creating</code>: <a>CreateEndpoint</a> is executing.</p> </li> <li> <p> <code>Updating</code>: <a>UpdateEndpoint</a> or <a>UpdateEndpointWeightsAndCapacities</a> is executing.</p> </li> <li> <p> <code>SystemUpdating</code>: Endpoint is undergoing maintenance and cannot be updated or deleted or re-scaled until it has completed. This maintenance operation does not change any customer-specified values such as VPC config, KMS encryption, model, instance type, or instance count.</p> </li> <li> <p> <code>RollingBack</code>: Endpoint fails to scale up or down or change its variant weight and is in the process of rolling back to its previous configuration. Once the rollback completes, endpoint returns to an <code>InService</code> status. This transitional status only applies to an endpoint that has autoscaling enabled and is undergoing variant weight or capacity changes as part of an <a>UpdateEndpointWeightsAndCapacities</a> call or when the <a>UpdateEndpointWeightsAndCapacities</a> operation is called explicitly.</p> </li> <li> <p> <code>InService</code>: Endpoint is available to process incoming requests.</p> </li> <li> <p> <code>Deleting</code>: <a>DeleteEndpoint</a> is executing.</p> </li> <li> <p> <code>Failed</code>: Endpoint could not be created, updated, or re-scaled. Use <a>DescribeEndpointOutput$FailureReason</a> for information about the failure. <a>DeleteEndpoint</a> is the only operation that can be performed on a failed endpoint.</p> </li> </ul> <p>To get a list of endpoints with a specified status, use the <a>ListEndpointsInput$StatusEquals</a> filter.</p>', 'ListEndpointsInput$StatusEquals' => '<p> A filter that returns only endpoints with the specified status.</p>', ], ], 'EndpointSummary' => [ 'base' => '<p>Provides summary information for an endpoint.</p>', 'refs' => [ 'EndpointSummaryList$member' => NULL, ], ], 'EndpointSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListEndpointsOutput$Endpoints' => '<p> An array or endpoint objects. </p>', ], ], 'EntityDescription' => [ 'base' => NULL, 'refs' => [ 'AlgorithmSummary$AlgorithmDescription' => '<p>A brief description of the algorithm.</p>', 'ChannelSpecification$Description' => '<p>A brief description of the channel.</p>', 'CreateAlgorithmInput$AlgorithmDescription' => '<p>A description of the algorithm.</p>', 'CreateModelPackageInput$ModelPackageDescription' => '<p>A description of the model package.</p>', 'DescribeAlgorithmOutput$AlgorithmDescription' => '<p>A brief summary about the algorithm.</p>', 'DescribeModelPackageOutput$ModelPackageDescription' => '<p>A brief summary of the model package.</p>', 'HyperParameterSpecification$Description' => '<p>A brief description of the hyperparameter.</p>', 'ModelPackageSummary$ModelPackageDescription' => '<p>A brief description of the model package.</p>', ], ], 'EntityName' => [ 'base' => NULL, 'refs' => [ 'AlgorithmStatusItem$Name' => '<p>The name of the algorithm for which the overall status is being reported.</p>', 'AlgorithmSummary$AlgorithmName' => '<p>The name of the algorithm that is described by the summary.</p>', 'AlgorithmValidationProfile$ProfileName' => '<p>The name of the profile for the algorithm. The name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).</p>', 'CodeRepositorySummary$CodeRepositoryName' => '<p>The name of the Git repository.</p>', 'CompilationJobSummary$CompilationJobName' => '<p>The name of the model compilation job that you want a summary for.</p>', 'CreateAlgorithmInput$AlgorithmName' => '<p>The name of the algorithm.</p>', 'CreateCodeRepositoryInput$CodeRepositoryName' => '<p>The name of the Git repository. The name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).</p>', 'CreateCompilationJobRequest$CompilationJobName' => '<p>A name for the model compilation job. The name must be unique within the AWS Region and within your AWS account. </p>', 'CreateModelPackageInput$ModelPackageName' => '<p>The name of the model package. The name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).</p>', 'DeleteAlgorithmInput$AlgorithmName' => '<p>The name of the algorithm to delete.</p>', 'DeleteCodeRepositoryInput$CodeRepositoryName' => '<p>The name of the Git repository to delete.</p>', 'DeleteModelPackageInput$ModelPackageName' => '<p>The name of the model package. The name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).</p>', 'DescribeAlgorithmOutput$AlgorithmName' => '<p>The name of the algorithm being described.</p>', 'DescribeCodeRepositoryInput$CodeRepositoryName' => '<p>The name of the Git repository to describe.</p>', 'DescribeCodeRepositoryOutput$CodeRepositoryName' => '<p>The name of the Git repository.</p>', 'DescribeCompilationJobRequest$CompilationJobName' => '<p>The name of the model compilation job that you want information about.</p>', 'DescribeCompilationJobResponse$CompilationJobName' => '<p>The name of the model compilation job.</p>', 'DescribeModelPackageOutput$ModelPackageName' => '<p>The name of the model package being described.</p>', 'ModelPackageStatusItem$Name' => '<p>The name of the model package for which the overall status is being reported.</p>', 'ModelPackageSummary$ModelPackageName' => '<p>The name of the model package.</p>', 'ModelPackageValidationProfile$ProfileName' => '<p>The name of the profile for the model package.</p>', 'StopCompilationJobRequest$CompilationJobName' => '<p>The name of the model compilation job to stop.</p>', 'UpdateCodeRepositoryInput$CodeRepositoryName' => '<p>The name of the Git repository to update.</p>', ], ], 'EnvironmentKey' => [ 'base' => NULL, 'refs' => [ 'EnvironmentMap$key' => NULL, ], ], 'EnvironmentMap' => [ 'base' => NULL, 'refs' => [ 'AutoMLContainerDefinition$Environment' => '<p>Environment variables to set in the container. Refer to ContainerDefinition for more details.</p>', 'ContainerDefinition$Environment' => '<p>The environment variables to set in the Docker container. Each key and value in the <code>Environment</code> string to string map can have length of up to 1024. We support up to 16 entries in the map. </p>', ], ], 'EnvironmentValue' => [ 'base' => NULL, 'refs' => [ 'EnvironmentMap$value' => NULL, ], ], 'ExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'ListMonitoringExecutionsRequest$StatusEquals' => '<p>A filter that retrieves only jobs with a specific status.</p>', 'MonitoringExecutionSummary$MonitoringExecutionStatus' => '<p>The status of the monitoring job.</p>', ], ], 'ExitMessage' => [ 'base' => NULL, 'refs' => [ 'DescribeProcessingJobResponse$ExitMessage' => '<p>An optional string, up to one KB in size, that contains metadata from the processing container when the processing job exits.</p>', 'ProcessingJob$ExitMessage' => '<p>A string, up to one KB in size, that contains metadata from the processing container when the processing job exits.</p>', 'ProcessingJobSummary$ExitMessage' => '<p>An optional string, up to one KB in size, that contains metadata from the processing container when the processing job exits.</p>', ], ], 'Experiment' => [ 'base' => '<p>The properties of an experiment as returned by the <a>Search</a> API.</p>', 'refs' => [ 'SearchRecord$Experiment' => '<p>The properties of an experiment.</p>', ], ], 'ExperimentArn' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentResponse$ExperimentArn' => '<p>The Amazon Resource Name (ARN) of the experiment.</p>', 'DeleteExperimentResponse$ExperimentArn' => '<p>The Amazon Resource Name (ARN) of the experiment that is being deleted.</p>', 'DescribeExperimentResponse$ExperimentArn' => '<p>The Amazon Resource Name (ARN) of the experiment.</p>', 'Experiment$ExperimentArn' => '<p>The Amazon Resource Name (ARN) of the experiment.</p>', 'ExperimentSummary$ExperimentArn' => '<p>The Amazon Resource Name (ARN) of the experiment.</p>', 'UpdateExperimentResponse$ExperimentArn' => '<p>The Amazon Resource Name (ARN) of the experiment.</p>', ], ], 'ExperimentConfig' => [ 'base' => '<p>Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:</p> <ul> <li> <p> <a>CreateProcessingJob</a> </p> </li> <li> <p> <a>CreateTrainingJob</a> </p> </li> <li> <p> <a>CreateTransformJob</a> </p> </li> </ul>', 'refs' => [ 'CreateProcessingJobRequest$ExperimentConfig' => NULL, 'CreateTrainingJobRequest$ExperimentConfig' => NULL, 'CreateTransformJobRequest$ExperimentConfig' => NULL, 'DescribeProcessingJobResponse$ExperimentConfig' => '<p>The configuration information used to create an experiment.</p>', 'DescribeTrainingJobResponse$ExperimentConfig' => NULL, 'DescribeTransformJobResponse$ExperimentConfig' => NULL, 'ProcessingJob$ExperimentConfig' => NULL, 'TrainingJob$ExperimentConfig' => NULL, 'TransformJob$ExperimentConfig' => NULL, ], ], 'ExperimentDescription' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentRequest$Description' => '<p>The description of the experiment.</p>', 'DescribeExperimentResponse$Description' => '<p>The description of the experiment.</p>', 'Experiment$Description' => '<p>The description of the experiment.</p>', 'UpdateExperimentRequest$Description' => '<p>The description of the experiment.</p>', ], ], 'ExperimentEntityName' => [ 'base' => NULL, 'refs' => [ 'AssociateTrialComponentRequest$TrialComponentName' => '<p>The name of the component to associated with the trial.</p>', 'AssociateTrialComponentRequest$TrialName' => '<p>The name of the trial to associate with.</p>', 'CreateExperimentRequest$ExperimentName' => '<p>The name of the experiment. The name must be unique in your AWS account and is not case-sensitive.</p>', 'CreateExperimentRequest$DisplayName' => '<p>The name of the experiment as displayed. The name doesn\'t need to be unique. If you don\'t specify <code>DisplayName</code>, the value in <code>ExperimentName</code> is displayed.</p>', 'CreateTrialComponentRequest$TrialComponentName' => '<p>The name of the component. The name must be unique in your AWS account and is not case-sensitive.</p>', 'CreateTrialComponentRequest$DisplayName' => '<p>The name of the component as displayed. The name doesn\'t need to be unique. If <code>DisplayName</code> isn\'t specified, <code>TrialComponentName</code> is displayed.</p>', 'CreateTrialRequest$TrialName' => '<p>The name of the trial. The name must be unique in your AWS account and is not case-sensitive.</p>', 'CreateTrialRequest$DisplayName' => '<p>The name of the trial as displayed. The name doesn\'t need to be unique. If <code>DisplayName</code> isn\'t specified, <code>TrialName</code> is displayed.</p>', 'CreateTrialRequest$ExperimentName' => '<p>The name of the experiment to associate the trial with.</p>', 'DeleteExperimentRequest$ExperimentName' => '<p>The name of the experiment to delete.</p>', 'DeleteTrialComponentRequest$TrialComponentName' => '<p>The name of the component to delete.</p>', 'DeleteTrialRequest$TrialName' => '<p>The name of the trial to delete.</p>', 'DescribeExperimentRequest$ExperimentName' => '<p>The name of the experiment to describe.</p>', 'DescribeExperimentResponse$ExperimentName' => '<p>The name of the experiment.</p>', 'DescribeExperimentResponse$DisplayName' => '<p>The name of the experiment as displayed. If <code>DisplayName</code> isn\'t specified, <code>ExperimentName</code> is displayed.</p>', 'DescribeTrialComponentRequest$TrialComponentName' => '<p>The name of the trial component to describe.</p>', 'DescribeTrialComponentResponse$TrialComponentName' => '<p>The name of the trial component.</p>', 'DescribeTrialComponentResponse$DisplayName' => '<p>The name of the component as displayed. If <code>DisplayName</code> isn\'t specified, <code>TrialComponentName</code> is displayed.</p>', 'DescribeTrialRequest$TrialName' => '<p>The name of the trial to describe.</p>', 'DescribeTrialResponse$TrialName' => '<p>The name of the trial.</p>', 'DescribeTrialResponse$DisplayName' => '<p>The name of the trial as displayed. If <code>DisplayName</code> isn\'t specified, <code>TrialName</code> is displayed.</p>', 'DescribeTrialResponse$ExperimentName' => '<p>The name of the experiment the trial is part of.</p>', 'DisassociateTrialComponentRequest$TrialComponentName' => '<p>The name of the component to disassociate from the trial.</p>', 'DisassociateTrialComponentRequest$TrialName' => '<p>The name of the trial to disassociate from.</p>', 'Experiment$ExperimentName' => '<p>The name of the experiment.</p>', 'Experiment$DisplayName' => '<p>The name of the experiment as displayed. If <code>DisplayName</code> isn\'t specified, <code>ExperimentName</code> is displayed.</p>', 'ExperimentConfig$ExperimentName' => '<p>The name of an existing experiment to associate the trial component with.</p>', 'ExperimentConfig$TrialName' => '<p>The name of an existing trial to associate the trial component with. If not specified, a new trial is created.</p>', 'ExperimentConfig$TrialComponentDisplayName' => '<p>The display name for the trial component. If this key isn\'t specified, the display name is the trial component name.</p>', 'ExperimentSummary$ExperimentName' => '<p>The name of the experiment.</p>', 'ExperimentSummary$DisplayName' => '<p>The name of the experiment as displayed. If <code>DisplayName</code> isn\'t specified, <code>ExperimentName</code> is displayed.</p>', 'ListTrialComponentsRequest$ExperimentName' => '<p>A filter that returns only components that are part of the specified experiment. If you specify <code>ExperimentName</code>, you can\'t filter by <code>SourceArn</code> or <code>TrialName</code>.</p>', 'ListTrialComponentsRequest$TrialName' => '<p>A filter that returns only components that are part of the specified trial. If you specify <code>TrialName</code>, you can\'t filter by <code>ExperimentName</code> or <code>SourceArn</code>.</p>', 'ListTrialsRequest$ExperimentName' => '<p>A filter that returns only trials that are part of the specified experiment.</p>', 'ListTrialsRequest$TrialComponentName' => '<p>A filter that returns only trials that are associated with the specified trial component.</p>', 'Parent$TrialName' => '<p>The name of the trial.</p>', 'Parent$ExperimentName' => '<p>The name of the experiment.</p>', 'Trial$TrialName' => '<p>The name of the trial.</p>', 'Trial$DisplayName' => '<p>The name of the trial as displayed. If <code>DisplayName</code> isn\'t specified, <code>TrialName</code> is displayed.</p>', 'Trial$ExperimentName' => '<p>The name of the experiment the trial is part of.</p>', 'TrialComponent$TrialComponentName' => '<p>The name of the trial component.</p>', 'TrialComponent$DisplayName' => '<p>The name of the component as displayed. If <code>DisplayName</code> isn\'t specified, <code>TrialComponentName</code> is displayed.</p>', 'TrialComponentSimpleSummary$TrialComponentName' => '<p>The name of the trial component.</p>', 'TrialComponentSummary$TrialComponentName' => '<p>The name of the trial component.</p>', 'TrialComponentSummary$DisplayName' => '<p>The name of the component as displayed. If <code>DisplayName</code> isn\'t specified, <code>TrialComponentName</code> is displayed.</p>', 'TrialSummary$TrialName' => '<p>The name of the trial.</p>', 'TrialSummary$DisplayName' => '<p>The name of the trial as displayed. If <code>DisplayName</code> isn\'t specified, <code>TrialName</code> is displayed.</p>', 'UpdateExperimentRequest$ExperimentName' => '<p>The name of the experiment to update.</p>', 'UpdateExperimentRequest$DisplayName' => '<p>The name of the experiment as displayed. The name doesn\'t need to be unique. If <code>DisplayName</code> isn\'t specified, <code>ExperimentName</code> is displayed.</p>', 'UpdateTrialComponentRequest$TrialComponentName' => '<p>The name of the component to update.</p>', 'UpdateTrialComponentRequest$DisplayName' => '<p>The name of the component as displayed. The name doesn\'t need to be unique. If <code>DisplayName</code> isn\'t specified, <code>TrialComponentName</code> is displayed.</p>', 'UpdateTrialRequest$TrialName' => '<p>The name of the trial to update.</p>', 'UpdateTrialRequest$DisplayName' => '<p>The name of the trial as displayed. The name doesn\'t need to be unique. If <code>DisplayName</code> isn\'t specified, <code>TrialName</code> is displayed.</p>', ], ], 'ExperimentSource' => [ 'base' => '<p>The source of the experiment.</p>', 'refs' => [ 'DescribeExperimentResponse$Source' => '<p>The ARN of the source and, optionally, the type.</p>', 'Experiment$Source' => NULL, 'ExperimentSummary$ExperimentSource' => NULL, ], ], 'ExperimentSourceArn' => [ 'base' => NULL, 'refs' => [ 'ExperimentSource$SourceArn' => '<p>The Amazon Resource Name (ARN) of the source.</p>', ], ], 'ExperimentSummaries' => [ 'base' => NULL, 'refs' => [ 'ListExperimentsResponse$ExperimentSummaries' => '<p>A list of the summaries of your experiments.</p>', ], ], 'ExperimentSummary' => [ 'base' => '<p>A summary of the properties of an experiment. To get the complete set of properties, call the <a>DescribeExperiment</a> API and provide the <code>ExperimentName</code>.</p>', 'refs' => [ 'ExperimentSummaries$member' => NULL, ], ], 'FailureReason' => [ 'base' => NULL, 'refs' => [ 'ConflictException$Message' => NULL, 'DescribeAppResponse$FailureReason' => '<p>The failure reason.</p>', 'DescribeCompilationJobResponse$FailureReason' => '<p>If a model compilation job failed, the reason it failed. </p>', 'DescribeDomainResponse$FailureReason' => '<p>The failure reason.</p>', 'DescribeEndpointOutput$FailureReason' => '<p>If the status of the endpoint is <code>Failed</code>, the reason why it failed. </p>', 'DescribeFlowDefinitionResponse$FailureReason' => '<p>The reason your flow definition failed.</p>', 'DescribeHyperParameterTuningJobResponse$FailureReason' => '<p>If the tuning job failed, the reason it failed.</p>', 'DescribeLabelingJobResponse$FailureReason' => '<p>If the job failed, the reason that it failed. </p>', 'DescribeMonitoringScheduleResponse$FailureReason' => '<p>A string, up to one KB in size, that contains the reason a monitoring job failed, if it failed.</p>', 'DescribeNotebookInstanceOutput$FailureReason' => '<p>If status is <code>Failed</code>, the reason it failed.</p>', 'DescribeProcessingJobResponse$FailureReason' => '<p>A string, up to one KB in size, that contains the reason a processing job failed, if it failed.</p>', 'DescribeTrainingJobResponse$FailureReason' => '<p>If the training job failed, the reason it failed. </p>', 'DescribeTransformJobResponse$FailureReason' => '<p>If the transform job failed, <code>FailureReason</code> describes why it failed. A transform job creates a log file, which includes error messages, and stores it as an Amazon S3 object. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/logging-cloudwatch.html">Log Amazon SageMaker Events with Amazon CloudWatch</a>.</p>', 'DescribeUserProfileResponse$FailureReason' => '<p>The failure reason.</p>', 'FlowDefinitionSummary$FailureReason' => '<p>The reason why the flow definition creation failed. A failure reason is returned only when the flow definition status is <code>Failed</code>.</p>', 'HyperParameterTrainingJobSummary$FailureReason' => '<p>The reason that the training job failed. </p>', 'LabelingJobSummary$FailureReason' => '<p>If the <code>LabelingJobStatus</code> field is <code>Failed</code>, this field contains a description of the error.</p>', 'MonitoringExecutionSummary$FailureReason' => '<p>Contains the reason a monitoring job failed, if it failed.</p>', 'ProcessingJob$FailureReason' => '<p>A string, up to one KB in size, that contains the reason a processing job failed, if it failed.</p>', 'ProcessingJobSummary$FailureReason' => '<p>A string, up to one KB in size, that contains the reason a processing job failed, if it failed.</p>', 'ResourceInUse$Message' => NULL, 'ResourceLimitExceeded$Message' => NULL, 'ResourceNotFound$Message' => NULL, 'TrainingJob$FailureReason' => '<p>If the training job failed, the reason it failed.</p>', 'TransformJob$FailureReason' => '<p>If the transform job failed, the reason it failed.</p>', 'TransformJobSummary$FailureReason' => '<p>If the transform job failed, the reason it failed.</p>', ], ], 'FileSystemAccessMode' => [ 'base' => NULL, 'refs' => [ 'FileSystemDataSource$FileSystemAccessMode' => '<p>The access mode of the mount of the directory associated with the channel. A directory can be mounted either in <code>ro</code> (read-only) or <code>rw</code> (read-write) mode.</p>', ], ], 'FileSystemDataSource' => [ 'base' => '<p>Specifies a file system data source for a channel.</p>', 'refs' => [ 'DataSource$FileSystemDataSource' => '<p>The file system that is associated with a channel.</p>', ], ], 'FileSystemId' => [ 'base' => NULL, 'refs' => [ 'FileSystemDataSource$FileSystemId' => '<p>The file system id.</p>', ], ], 'FileSystemType' => [ 'base' => NULL, 'refs' => [ 'FileSystemDataSource$FileSystemType' => '<p>The file system type. </p>', ], ], 'Filter' => [ 'base' => '<p>A conditional statement for a search expression that includes a resource property, a Boolean operator, and a value. Resources that match the statement are returned in the results from the <a>Search</a> API.</p> <p>If you specify a <code>Value</code>, but not an <code>Operator</code>, Amazon SageMaker uses the equals operator.</p> <p>In search, there are several property types:</p> <dl> <dt>Metrics</dt> <dd> <p>To define a metric filter, enter a value using the form <code>"Metrics.&lt;name&gt;"</code>, where <code>&lt;name&gt;</code> is a metric name. For example, the following filter searches for training jobs with an <code>"accuracy"</code> metric greater than <code>"0.9"</code>:</p> <p> <code>{</code> </p> <p> <code>"Name": "Metrics.accuracy",</code> </p> <p> <code>"Operator": "GreaterThan",</code> </p> <p> <code>"Value": "0.9"</code> </p> <p> <code>}</code> </p> </dd> <dt>HyperParameters</dt> <dd> <p>To define a hyperparameter filter, enter a value with the form <code>"HyperParameters.&lt;name&gt;"</code>. Decimal hyperparameter values are treated as a decimal in a comparison if the specified <code>Value</code> is also a decimal value. If the specified <code>Value</code> is an integer, the decimal hyperparameter values are treated as integers. For example, the following filter is satisfied by training jobs with a <code>"learning_rate"</code> hyperparameter that is less than <code>"0.5"</code>:</p> <p> <code> {</code> </p> <p> <code> "Name": "HyperParameters.learning_rate",</code> </p> <p> <code> "Operator": "LessThan",</code> </p> <p> <code> "Value": "0.5"</code> </p> <p> <code> }</code> </p> </dd> <dt>Tags</dt> <dd> <p>To define a tag filter, enter a value with the form <code>Tags.&lt;key&gt;</code>.</p> </dd> </dl>', 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'NestedFilters$Filters' => '<p>A list of filters. Each filter acts on a property. Filters must contain at least one <code>Filters</code> value. For example, a <code>NestedFilters</code> call might include a filter on the <code>PropertyName</code> parameter of the <code>InputDataConfig</code> property: <code>InputDataConfig.DataSource.S3DataSource.S3Uri</code>.</p>', 'SearchExpression$Filters' => '<p>A list of filter objects.</p>', ], ], 'FilterValue' => [ 'base' => NULL, 'refs' => [ 'Filter$Value' => '<p>A value used with <code>Name</code> and <code>Operator</code> to determine which resources satisfy the filter\'s condition. For numerical properties, <code>Value</code> must be an integer or floating-point decimal. For timestamp properties, <code>Value</code> must be an ISO 8601 date-time string of the following format: <code>YYYY-mm-dd\'T\'HH:MM:SS</code>.</p>', ], ], 'FinalAutoMLJobObjectiveMetric' => [ 'base' => '<p>The candidate result from a job.</p>', 'refs' => [ 'AutoMLCandidate$FinalAutoMLJobObjectiveMetric' => NULL, ], ], 'FinalHyperParameterTuningJobObjectiveMetric' => [ 'base' => '<p>Shows the final value for the objective metric for a training job that was launched by a hyperparameter tuning job. You define the objective metric in the <code>HyperParameterTuningJobObjective</code> parameter of <a>HyperParameterTuningJobConfig</a>.</p>', 'refs' => [ 'HyperParameterTrainingJobSummary$FinalHyperParameterTuningJobObjectiveMetric' => '<p>The <a>FinalHyperParameterTuningJobObjectiveMetric</a> object that specifies the value of the objective metric of the tuning job that launched this training job.</p>', ], ], 'FinalMetricDataList' => [ 'base' => NULL, 'refs' => [ 'DescribeTrainingJobResponse$FinalMetricDataList' => '<p>A collection of <code>MetricData</code> objects that specify the names, values, and dates and times that the training algorithm emitted to Amazon CloudWatch.</p>', 'TrainingJob$FinalMetricDataList' => '<p>A list of final metric values that are set when the training job completes. Used only if the training job was configured to use metrics.</p>', ], ], 'Float' => [ 'base' => NULL, 'refs' => [ 'MetricData$Value' => '<p>The value of the metric.</p>', ], ], 'FlowDefinitionArn' => [ 'base' => NULL, 'refs' => [ 'CreateFlowDefinitionResponse$FlowDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the flow definition you create.</p>', 'DescribeFlowDefinitionResponse$FlowDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the flow defintion.</p>', 'FlowDefinitionSummary$FlowDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the flow definition.</p>', ], ], 'FlowDefinitionName' => [ 'base' => NULL, 'refs' => [ 'CreateFlowDefinitionRequest$FlowDefinitionName' => '<p>The name of your flow definition.</p>', 'DeleteFlowDefinitionRequest$FlowDefinitionName' => '<p>The name of the flow definition you are deleting.</p>', 'DescribeFlowDefinitionRequest$FlowDefinitionName' => '<p>The name of the flow definition.</p>', 'DescribeFlowDefinitionResponse$FlowDefinitionName' => '<p>The Amazon Resource Name (ARN) of the flow definition.</p>', 'FlowDefinitionSummary$FlowDefinitionName' => '<p>The name of the flow definition.</p>', ], ], 'FlowDefinitionOutputConfig' => [ 'base' => '<p>Contains information about where human output will be stored.</p>', 'refs' => [ 'CreateFlowDefinitionRequest$OutputConfig' => '<p>An object containing information about where the human review results will be uploaded.</p>', 'DescribeFlowDefinitionResponse$OutputConfig' => '<p>An object containing information about the output file.</p>', ], ], 'FlowDefinitionStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeFlowDefinitionResponse$FlowDefinitionStatus' => '<p>The status of the flow definition. Valid values are listed below.</p>', 'FlowDefinitionSummary$FlowDefinitionStatus' => '<p>The status of the flow definition. Valid values:</p>', ], ], 'FlowDefinitionSummaries' => [ 'base' => NULL, 'refs' => [ 'ListFlowDefinitionsResponse$FlowDefinitionSummaries' => '<p>An array of objects describing the flow definitions.</p>', ], ], 'FlowDefinitionSummary' => [ 'base' => '<p>Contains summary information about the flow definition.</p>', 'refs' => [ 'FlowDefinitionSummaries$member' => NULL, ], ], 'FlowDefinitionTaskAvailabilityLifetimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'HumanLoopConfig$TaskAvailabilityLifetimeInSeconds' => '<p>The length of time that a task remains available for labeling by human workers.</p>', ], ], 'FlowDefinitionTaskCount' => [ 'base' => NULL, 'refs' => [ 'HumanLoopConfig$TaskCount' => '<p>The number of distinct workers who will perform the same task on each object. For example, if <code>TaskCount</code> is set to <code>3</code> for an image classification labeling job, three workers will classify each input image. Increasing <code>TaskCount</code> can improve label accuracy.</p>', ], ], 'FlowDefinitionTaskDescription' => [ 'base' => NULL, 'refs' => [ 'HumanLoopConfig$TaskDescription' => '<p>A description for the human worker task.</p>', ], ], 'FlowDefinitionTaskKeyword' => [ 'base' => NULL, 'refs' => [ 'FlowDefinitionTaskKeywords$member' => NULL, ], ], 'FlowDefinitionTaskKeywords' => [ 'base' => NULL, 'refs' => [ 'HumanLoopConfig$TaskKeywords' => '<p>Keywords used to describe the task so that workers can discover the task.</p>', ], ], 'FlowDefinitionTaskTimeLimitInSeconds' => [ 'base' => NULL, 'refs' => [ 'HumanLoopConfig$TaskTimeLimitInSeconds' => '<p>The amount of time that a worker has to complete a task.</p>', ], ], 'FlowDefinitionTaskTitle' => [ 'base' => NULL, 'refs' => [ 'HumanLoopConfig$TaskTitle' => '<p>A title for the human worker task.</p>', ], ], 'Framework' => [ 'base' => NULL, 'refs' => [ 'InputConfig$Framework' => '<p>Identifies the framework in which the model was trained. For example: TENSORFLOW.</p>', ], ], 'GenerateCandidateDefinitionsOnly' => [ 'base' => NULL, 'refs' => [ 'CreateAutoMLJobRequest$GenerateCandidateDefinitionsOnly' => '<p>This will generate possible candidates without training a model. A candidate is a combination of data preprocessors, algorithms, and algorithm parameter settings.</p>', 'DescribeAutoMLJobResponse$GenerateCandidateDefinitionsOnly' => '<p>Returns the job\'s output from GenerateCandidateDefinitionsOnly.</p>', ], ], 'GetSearchSuggestionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSearchSuggestionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GitConfig' => [ 'base' => '<p>Specifies configuration details for a Git repository in your AWS account.</p>', 'refs' => [ 'CodeRepositorySummary$GitConfig' => '<p>Configuration details for the Git repository, including the URL where it is located and the ARN of the AWS Secrets Manager secret that contains the credentials used to access the repository.</p>', 'CreateCodeRepositoryInput$GitConfig' => '<p>Specifies details about the repository, including the URL where the repository is located, the default branch, and credentials to use to access the repository.</p>', 'DescribeCodeRepositoryOutput$GitConfig' => '<p>Configuration details about the repository, including the URL where the repository is located, the default branch, and the Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the credentials used to access the repository.</p>', ], ], 'GitConfigForUpdate' => [ 'base' => '<p>Specifies configuration details for a Git repository when the repository is updated.</p>', 'refs' => [ 'UpdateCodeRepositoryInput$GitConfig' => '<p>The configuration of the git repository, including the URL and the Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the credentials used to access the repository. The secret must have a staging label of <code>AWSCURRENT</code> and must be in the following format:</p> <p> <code>{"username": <i>UserName</i>, "password": <i>Password</i>}</code> </p>', ], ], 'GitConfigUrl' => [ 'base' => NULL, 'refs' => [ 'GitConfig$RepositoryUrl' => '<p>The URL where the Git repository is located.</p>', ], ], 'Group' => [ 'base' => NULL, 'refs' => [ 'Groups$member' => NULL, ], ], 'Groups' => [ 'base' => NULL, 'refs' => [ 'OidcMemberDefinition$Groups' => '<p>A list of comma seperated strings that identifies user groups in your OIDC IdP. Each user group is made up of a group of private workers.</p>', ], ], 'HookParameters' => [ 'base' => NULL, 'refs' => [ 'DebugHookConfig$HookParameters' => '<p>Configuration information for the debug hook parameters.</p>', ], ], 'HumanLoopActivationConditions' => [ 'base' => NULL, 'refs' => [ 'HumanLoopActivationConditionsConfig$HumanLoopActivationConditions' => '<p>JSON expressing use-case specific conditions declaratively. If any condition is matched, atomic tasks are created against the configured work team. The set of conditions is different for Rekognition and Textract. For more information about how to structure the JSON, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-human-fallback-conditions-json-schema.html">JSON Schema for Human Loop Activation Conditions in Amazon Augmented AI</a> in the <i>Amazon SageMaker Developer Guide</i>.</p>', ], ], 'HumanLoopActivationConditionsConfig' => [ 'base' => '<p>Defines under what conditions SageMaker creates a human loop. Used within . See for the required format of activation conditions.</p>', 'refs' => [ 'HumanLoopActivationConfig$HumanLoopActivationConditionsConfig' => '<p>Container structure for defining under what conditions SageMaker creates a human loop.</p>', ], ], 'HumanLoopActivationConfig' => [ 'base' => '<p>Provides information about how and under what conditions SageMaker creates a human loop. If <code>HumanLoopActivationConfig</code> is not given, then all requests go to humans.</p>', 'refs' => [ 'CreateFlowDefinitionRequest$HumanLoopActivationConfig' => '<p>An object containing information about the events that trigger a human workflow.</p>', 'DescribeFlowDefinitionResponse$HumanLoopActivationConfig' => '<p>An object containing information about what triggers a human review workflow.</p>', ], ], 'HumanLoopConfig' => [ 'base' => '<p>Describes the work to be performed by human workers.</p>', 'refs' => [ 'CreateFlowDefinitionRequest$HumanLoopConfig' => '<p>An object containing information about the tasks the human reviewers will perform.</p>', 'DescribeFlowDefinitionResponse$HumanLoopConfig' => '<p>An object containing information about who works on the task, the workforce task price, and other task details.</p>', ], ], 'HumanLoopRequestSource' => [ 'base' => '<p>Container for configuring the source of human task requests.</p>', 'refs' => [ 'CreateFlowDefinitionRequest$HumanLoopRequestSource' => '<p>Container for configuring the source of human task requests. Use to specify if Amazon Rekognition or Amazon Textract is used as an integration source.</p>', 'DescribeFlowDefinitionResponse$HumanLoopRequestSource' => '<p>Container for configuring the source of human task requests. Used to specify if Amazon Rekognition or Amazon Textract is used as an integration source.</p>', ], ], 'HumanTaskConfig' => [ 'base' => '<p>Information required for human workers to complete a labeling task.</p>', 'refs' => [ 'CreateLabelingJobRequest$HumanTaskConfig' => '<p>Configures the labeling task and how it is presented to workers; including, but not limited to price, keywords, and batch size (task count).</p>', 'DescribeLabelingJobResponse$HumanTaskConfig' => '<p>Configuration information required for human workers to complete a labeling task.</p>', ], ], 'HumanTaskUiArn' => [ 'base' => NULL, 'refs' => [ 'CreateHumanTaskUiResponse$HumanTaskUiArn' => '<p>The Amazon Resource Name (ARN) of the human review workflow user interface you create.</p>', 'DescribeHumanTaskUiResponse$HumanTaskUiArn' => '<p>The Amazon Resource Name (ARN) of the human task user interface (worker task template).</p>', 'HumanLoopConfig$HumanTaskUiArn' => '<p>The Amazon Resource Name (ARN) of the human task user interface.</p>', 'HumanTaskUiSummary$HumanTaskUiArn' => '<p>The Amazon Resource Name (ARN) of the human task user interface.</p>', 'RenderUiTemplateRequest$HumanTaskUiArn' => '<p>The <code>HumanTaskUiArn</code> of the worker UI that you want to render. Do not provide a <code>HumanTaskUiArn</code> if you use the <code>UiTemplate</code> parameter.</p> <p>See a list of available Human Ui Amazon Resource Names (ARNs) in <a>UiConfig</a>.</p>', 'UiConfig$HumanTaskUiArn' => '<p>The ARN of the worker task template used to render the worker UI and tools for labeling job tasks.</p> <p>Use this parameter when you are creating a labeling job for 3D point cloud and video fram labeling jobs. Use your labeling job task type to select one of the following ARN\'s and use it with this parameter when you create a labeling job. Replace <code>aws-region</code> with the AWS region you are creating your labeling job in.</p> <p> <b>3D Point Cloud HumanTaskUiArns</b> </p> <p>Use this <code>HumanTaskUiArn</code> for 3D point cloud object detection and 3D point cloud object detection adjustment labeling jobs. </p> <ul> <li> <p> <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudObjectDetection</code> </p> </li> </ul> <p> Use this <code>HumanTaskUiArn</code> for 3D point cloud object tracking and 3D point cloud object tracking adjustment labeling jobs. </p> <ul> <li> <p> <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudObjectTracking</code> </p> </li> </ul> <p> Use this <code>HumanTaskUiArn</code> for 3D point cloud semantic segmentation and 3D point cloud semantic segmentation adjustment labeling jobs.</p> <ul> <li> <p> <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudSemanticSegmentation</code> </p> </li> </ul> <p> <b>Video Frame HumanTaskUiArns</b> </p> <p>Use this <code>HumanTaskUiArn</code> for video frame object detection and video frame object detection adjustment labeling jobs. </p> <ul> <li> <p> <code>arn:aws:sagemaker:region:394669845002:human-task-ui/VideoObjectDetection</code> </p> </li> </ul> <p> Use this <code>HumanTaskUiArn</code> for video frame object tracking and video frame object tracking adjustment labeling jobs. </p> <ul> <li> <p> <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/VideoObjectTracking</code> </p> </li> </ul>', ], ], 'HumanTaskUiName' => [ 'base' => NULL, 'refs' => [ 'CreateHumanTaskUiRequest$HumanTaskUiName' => '<p>The name of the user interface you are creating.</p>', 'DeleteHumanTaskUiRequest$HumanTaskUiName' => '<p>The name of the human task user interface (work task template) you want to delete.</p>', 'DescribeHumanTaskUiRequest$HumanTaskUiName' => '<p>The name of the human task user interface (worker task template) you want information about.</p>', 'DescribeHumanTaskUiResponse$HumanTaskUiName' => '<p>The name of the human task user interface (worker task template).</p>', 'HumanTaskUiSummary$HumanTaskUiName' => '<p>The name of the human task user interface.</p>', ], ], 'HumanTaskUiStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeHumanTaskUiResponse$HumanTaskUiStatus' => '<p>The status of the human task user interface (worker task template). Valid values are listed below.</p>', ], ], 'HumanTaskUiSummaries' => [ 'base' => NULL, 'refs' => [ 'ListHumanTaskUisResponse$HumanTaskUiSummaries' => '<p>An array of objects describing the human task user interfaces.</p>', ], ], 'HumanTaskUiSummary' => [ 'base' => '<p>Container for human task user interface information.</p>', 'refs' => [ 'HumanTaskUiSummaries$member' => NULL, ], ], 'HyperParameterAlgorithmSpecification' => [ 'base' => '<p>Specifies which training algorithm to use for training jobs that a hyperparameter tuning job launches and the metrics to monitor.</p>', 'refs' => [ 'HyperParameterTrainingJobDefinition$AlgorithmSpecification' => '<p>The <a>HyperParameterAlgorithmSpecification</a> object that specifies the resource algorithm to use for the training jobs that the tuning job launches.</p>', ], ], 'HyperParameterScalingType' => [ 'base' => NULL, 'refs' => [ 'ContinuousParameterRange$ScalingType' => '<p>The scale that hyperparameter tuning uses to search the hyperparameter range. For information about choosing a hyperparameter scale, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type">Hyperparameter Scaling</a>. One of the following values:</p> <dl> <dt>Auto</dt> <dd> <p>Amazon SageMaker hyperparameter tuning chooses the best scale for the hyperparameter.</p> </dd> <dt>Linear</dt> <dd> <p>Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.</p> </dd> <dt>Logarithmic</dt> <dd> <p>Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.</p> <p>Logarithmic scaling works only for ranges that have only values greater than 0.</p> </dd> <dt>ReverseLogarithmic</dt> <dd> <p>Hyperparameter tuning searches the values in the hyperparameter range by using a reverse logarithmic scale.</p> <p>Reverse logarithmic scaling works only for ranges that are entirely within the range 0&lt;=x&lt;1.0.</p> </dd> </dl>', 'IntegerParameterRange$ScalingType' => '<p>The scale that hyperparameter tuning uses to search the hyperparameter range. For information about choosing a hyperparameter scale, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type">Hyperparameter Scaling</a>. One of the following values:</p> <dl> <dt>Auto</dt> <dd> <p>Amazon SageMaker hyperparameter tuning chooses the best scale for the hyperparameter.</p> </dd> <dt>Linear</dt> <dd> <p>Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.</p> </dd> <dt>Logarithmic</dt> <dd> <p>Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.</p> <p>Logarithmic scaling works only for ranges that have only values greater than 0.</p> </dd> </dl>', ], ], 'HyperParameterSpecification' => [ 'base' => '<p>Defines a hyperparameter to be used by an algorithm.</p>', 'refs' => [ 'HyperParameterSpecifications$member' => NULL, ], ], 'HyperParameterSpecifications' => [ 'base' => NULL, 'refs' => [ 'TrainingSpecification$SupportedHyperParameters' => '<p>A list of the <code>HyperParameterSpecification</code> objects, that define the supported hyperparameters. This is required if the algorithm supports automatic model tuning.&gt;</p>', ], ], 'HyperParameterTrainingJobDefinition' => [ 'base' => '<p>Defines the training jobs launched by a hyperparameter tuning job.</p>', 'refs' => [ 'CreateHyperParameterTuningJobRequest$TrainingJobDefinition' => '<p>The <a>HyperParameterTrainingJobDefinition</a> object that describes the training jobs that this tuning job launches, including static hyperparameters, input data configuration, output data configuration, resource configuration, and stopping condition.</p>', 'DescribeHyperParameterTuningJobResponse$TrainingJobDefinition' => '<p>The <a>HyperParameterTrainingJobDefinition</a> object that specifies the definition of the training jobs that this tuning job launches.</p>', 'HyperParameterTrainingJobDefinitions$member' => NULL, ], ], 'HyperParameterTrainingJobDefinitionName' => [ 'base' => NULL, 'refs' => [ 'HyperParameterTrainingJobDefinition$DefinitionName' => '<p>The job definition name.</p>', 'HyperParameterTrainingJobSummary$TrainingJobDefinitionName' => '<p>The training job definition name.</p>', ], ], 'HyperParameterTrainingJobDefinitions' => [ 'base' => NULL, 'refs' => [ 'CreateHyperParameterTuningJobRequest$TrainingJobDefinitions' => '<p>A list of the <a>HyperParameterTrainingJobDefinition</a> objects launched for this tuning job.</p>', 'DescribeHyperParameterTuningJobResponse$TrainingJobDefinitions' => '<p>A list of the <a>HyperParameterTrainingJobDefinition</a> objects launched for this tuning job.</p>', ], ], 'HyperParameterTrainingJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListTrainingJobsForHyperParameterTuningJobResponse$TrainingJobSummaries' => '<p>A list of <a>TrainingJobSummary</a> objects that describe the training jobs that the <code>ListTrainingJobsForHyperParameterTuningJob</code> request returned.</p>', ], ], 'HyperParameterTrainingJobSummary' => [ 'base' => '<p>Specifies summary information about a training job.</p>', 'refs' => [ 'DescribeHyperParameterTuningJobResponse$BestTrainingJob' => '<p>A <a>TrainingJobSummary</a> object that describes the training job that completed with the best current <a>HyperParameterTuningJobObjective</a>.</p>', 'DescribeHyperParameterTuningJobResponse$OverallBestTrainingJob' => '<p>If the hyperparameter tuning job is an warm start tuning job with a <code>WarmStartType</code> of <code>IDENTICAL_DATA_AND_ALGORITHM</code>, this is the <a>TrainingJobSummary</a> for the training job with the best objective metric value of all training jobs launched by this tuning job and all parent jobs specified for the warm start tuning job.</p>', 'HyperParameterTrainingJobSummaries$member' => NULL, ], ], 'HyperParameterTuningJobArn' => [ 'base' => NULL, 'refs' => [ 'CreateHyperParameterTuningJobResponse$HyperParameterTuningJobArn' => '<p>The Amazon Resource Name (ARN) of the tuning job. Amazon SageMaker assigns an ARN to a hyperparameter tuning job when you create it.</p>', 'DescribeHyperParameterTuningJobResponse$HyperParameterTuningJobArn' => '<p>The Amazon Resource Name (ARN) of the tuning job.</p>', 'DescribeTrainingJobResponse$TuningJobArn' => '<p>The Amazon Resource Name (ARN) of the associated hyperparameter tuning job if the training job was launched by a hyperparameter tuning job.</p>', 'HyperParameterTuningJobSummary$HyperParameterTuningJobArn' => '<p>The Amazon Resource Name (ARN) of the tuning job.</p>', 'TrainingJob$TuningJobArn' => '<p>The Amazon Resource Name (ARN) of the associated hyperparameter tuning job if the training job was launched by a hyperparameter tuning job.</p>', ], ], 'HyperParameterTuningJobConfig' => [ 'base' => '<p>Configures a hyperparameter tuning job.</p>', 'refs' => [ 'CreateHyperParameterTuningJobRequest$HyperParameterTuningJobConfig' => '<p>The <a>HyperParameterTuningJobConfig</a> object that describes the tuning job, including the search strategy, the objective metric used to evaluate training jobs, ranges of parameters to search, and resource limits for the tuning job. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How Hyperparameter Tuning Works</a>.</p>', 'DescribeHyperParameterTuningJobResponse$HyperParameterTuningJobConfig' => '<p>The <a>HyperParameterTuningJobConfig</a> object that specifies the configuration of the tuning job.</p>', ], ], 'HyperParameterTuningJobName' => [ 'base' => NULL, 'refs' => [ 'CreateHyperParameterTuningJobRequest$HyperParameterTuningJobName' => '<p>The name of the tuning job. This name is the prefix for the names of all training jobs that this tuning job launches. The name must be unique within the same AWS account and AWS Region. The name must have { } to { } characters. Valid characters are a-z, A-Z, 0-9, and : + = @ _ % - (hyphen). The name is not case sensitive.</p>', 'DescribeHyperParameterTuningJobRequest$HyperParameterTuningJobName' => '<p>The name of the tuning job.</p>', 'DescribeHyperParameterTuningJobResponse$HyperParameterTuningJobName' => '<p>The name of the tuning job.</p>', 'HyperParameterTrainingJobSummary$TuningJobName' => '<p>The HyperParameter tuning job that launched the training job.</p>', 'HyperParameterTuningJobSummary$HyperParameterTuningJobName' => '<p>The name of the tuning job.</p>', 'ListTrainingJobsForHyperParameterTuningJobRequest$HyperParameterTuningJobName' => '<p>The name of the tuning job whose training jobs you want to list.</p>', 'ParentHyperParameterTuningJob$HyperParameterTuningJobName' => '<p>The name of the hyperparameter tuning job to be used as a starting point for a new hyperparameter tuning job.</p>', 'StopHyperParameterTuningJobRequest$HyperParameterTuningJobName' => '<p>The name of the tuning job to stop.</p>', ], ], 'HyperParameterTuningJobObjective' => [ 'base' => '<p>Defines the objective metric for a hyperparameter tuning job. Hyperparameter tuning uses the value of this metric to evaluate the training jobs it launches, and returns the training job that results in either the highest or lowest value for this metric, depending on the value you specify for the <code>Type</code> parameter.</p>', 'refs' => [ 'HyperParameterTrainingJobDefinition$TuningObjective' => NULL, 'HyperParameterTuningJobConfig$HyperParameterTuningJobObjective' => '<p>The <a>HyperParameterTuningJobObjective</a> object that specifies the objective metric for this tuning job.</p>', 'HyperParameterTuningJobObjectives$member' => NULL, ], ], 'HyperParameterTuningJobObjectiveType' => [ 'base' => NULL, 'refs' => [ 'FinalHyperParameterTuningJobObjectiveMetric$Type' => '<p>Whether to minimize or maximize the objective metric. Valid values are Minimize and Maximize.</p>', 'HyperParameterTuningJobObjective$Type' => '<p>Whether to minimize or maximize the objective metric.</p>', ], ], 'HyperParameterTuningJobObjectives' => [ 'base' => NULL, 'refs' => [ 'TrainingSpecification$SupportedTuningJobObjectiveMetrics' => '<p>A list of the metrics that the algorithm emits that can be used as the objective metric in a hyperparameter tuning job.</p>', ], ], 'HyperParameterTuningJobSortByOptions' => [ 'base' => NULL, 'refs' => [ 'ListHyperParameterTuningJobsRequest$SortBy' => '<p>The field to sort results by. The default is <code>Name</code>.</p>', ], ], 'HyperParameterTuningJobStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeHyperParameterTuningJobResponse$HyperParameterTuningJobStatus' => '<p>The status of the tuning job: InProgress, Completed, Failed, Stopping, or Stopped.</p>', 'HyperParameterTuningJobSummary$HyperParameterTuningJobStatus' => '<p>The status of the tuning job.</p>', 'ListHyperParameterTuningJobsRequest$StatusEquals' => '<p>A filter that returns only tuning jobs with the specified status.</p>', ], ], 'HyperParameterTuningJobStrategyType' => [ 'base' => '<p>The strategy hyperparameter tuning uses to find the best combination of hyperparameters for your model. Currently, the only supported value is <code>Bayesian</code>.</p>', 'refs' => [ 'HyperParameterTuningJobConfig$Strategy' => '<p>Specifies how hyperparameter tuning chooses the combinations of hyperparameter values to use for the training job it launches. To use the Bayesian search strategy, set this to <code>Bayesian</code>. To randomly search, set it to <code>Random</code>. For information about search strategies, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How Hyperparameter Tuning Works</a>.</p>', 'HyperParameterTuningJobSummary$Strategy' => '<p>Specifies the search strategy hyperparameter tuning uses to choose which hyperparameters to use for each iteration. Currently, the only valid value is Bayesian.</p>', ], ], 'HyperParameterTuningJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListHyperParameterTuningJobsResponse$HyperParameterTuningJobSummaries' => '<p>A list of <a>HyperParameterTuningJobSummary</a> objects that describe the tuning jobs that the <code>ListHyperParameterTuningJobs</code> request returned.</p>', ], ], 'HyperParameterTuningJobSummary' => [ 'base' => '<p>Provides summary information about a hyperparameter tuning job.</p>', 'refs' => [ 'HyperParameterTuningJobSummaries$member' => NULL, ], ], 'HyperParameterTuningJobWarmStartConfig' => [ 'base' => '<p>Specifies the configuration for a hyperparameter tuning job that uses one or more previous hyperparameter tuning jobs as a starting point. The results of previous tuning jobs are used to inform which combinations of hyperparameters to search over in the new tuning job.</p> <p>All training jobs launched by the new hyperparameter tuning job are evaluated by using the objective metric, and the training job that performs the best is compared to the best training jobs from the parent tuning jobs. From these, the training job that performs the best as measured by the objective metric is returned as the overall best training job.</p> <note> <p>All training jobs launched by parent hyperparameter tuning jobs and the new hyperparameter tuning jobs count against the limit of training jobs for the tuning job.</p> </note>', 'refs' => [ 'CreateHyperParameterTuningJobRequest$WarmStartConfig' => '<p>Specifies the configuration for starting the hyperparameter tuning job using one or more previous tuning jobs as a starting point. The results of previous tuning jobs are used to inform which combinations of hyperparameters to search over in the new tuning job.</p> <p>All training jobs launched by the new hyperparameter tuning job are evaluated by using the objective metric. If you specify <code>IDENTICAL_DATA_AND_ALGORITHM</code> as the <code>WarmStartType</code> value for the warm start configuration, the training job that performs the best in the new tuning job is compared to the best training jobs from the parent tuning jobs. From these, the training job that performs the best as measured by the objective metric is returned as the overall best training job.</p> <note> <p>All training jobs launched by parent hyperparameter tuning jobs and the new hyperparameter tuning jobs count against the limit of training jobs for the tuning job.</p> </note>', 'DescribeHyperParameterTuningJobResponse$WarmStartConfig' => '<p>The configuration for starting the hyperparameter parameter tuning job using one or more previous tuning jobs as a starting point. The results of previous tuning jobs are used to inform which combinations of hyperparameters to search over in the new tuning job.</p>', ], ], 'HyperParameterTuningJobWarmStartType' => [ 'base' => NULL, 'refs' => [ 'HyperParameterTuningJobWarmStartConfig$WarmStartType' => '<p>Specifies one of the following:</p> <dl> <dt>IDENTICAL_DATA_AND_ALGORITHM</dt> <dd> <p>The new hyperparameter tuning job uses the same input data and training image as the parent tuning jobs. You can change the hyperparameter ranges to search and the maximum number of training jobs that the hyperparameter tuning job launches. You cannot use a new version of the training algorithm, unless the changes in the new version do not affect the algorithm itself. For example, changes that improve logging or adding support for a different data format are allowed. You can also change hyperparameters from tunable to static, and from static to tunable, but the total number of static plus tunable hyperparameters must remain the same as it is in all parent jobs. The objective metric for the new tuning job must be the same as for all parent jobs.</p> </dd> <dt>TRANSFER_LEARNING</dt> <dd> <p>The new hyperparameter tuning job can include input data, hyperparameter ranges, maximum number of concurrent training jobs, and maximum number of training jobs that are different than those of its parent hyperparameter tuning jobs. The training image can also be a different version from the version used in the parent hyperparameter tuning job. You can also change hyperparameters from tunable to static, and from static to tunable, but the total number of static plus tunable hyperparameters must remain the same as it is in all parent jobs. The objective metric for the new tuning job must be the same as for all parent jobs.</p> </dd> </dl>', ], ], 'HyperParameters' => [ 'base' => NULL, 'refs' => [ 'CreateTrainingJobRequest$HyperParameters' => '<p>Algorithm-specific parameters that influence the quality of the model. You set hyperparameters before you start the learning process. For a list of hyperparameters for each training algorithm provided by Amazon SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. </p> <p>You can specify a maximum of 100 hyperparameters. Each hyperparameter is a key-value pair. Each key and value is limited to 256 characters, as specified by the <code>Length Constraint</code>. </p>', 'DescribeTrainingJobResponse$HyperParameters' => '<p>Algorithm-specific parameters. </p>', 'HyperParameterTrainingJobDefinition$StaticHyperParameters' => '<p>Specifies the values of hyperparameters that do not change for the tuning job.</p>', 'HyperParameterTrainingJobSummary$TunedHyperParameters' => '<p>A list of the hyperparameters for which you specified ranges to search.</p>', 'TrainingJob$HyperParameters' => '<p>Algorithm-specific parameters.</p>', 'TrainingJobDefinition$HyperParameters' => '<p>The hyperparameters used for the training job.</p>', ], ], 'ImageArn' => [ 'base' => NULL, 'refs' => [ 'ResourceSpec$SageMakerImageArn' => '<p>The Amazon Resource Name (ARN) of the SageMaker image created on the instance.</p>', ], ], 'ImageDigest' => [ 'base' => NULL, 'refs' => [ 'ModelPackageContainerDefinition$ImageDigest' => '<p>An MD5 hash of the training algorithm that identifies the Docker image used for training.</p>', 'TrainingSpecification$TrainingImageDigest' => '<p>An MD5 hash of the training algorithm that identifies the Docker image used for training.</p>', ], ], 'ImageUri' => [ 'base' => NULL, 'refs' => [ 'AppSpecification$ImageUri' => '<p>The container image to be run by the processing job.</p>', 'MonitoringAppSpecification$ImageUri' => '<p>The container image to be run by the monitoring job.</p>', ], ], 'InferenceSpecification' => [ 'base' => '<p>Defines how to perform inference generation after a training job is run.</p>', 'refs' => [ 'CreateAlgorithmInput$InferenceSpecification' => '<p>Specifies details about inference jobs that the algorithm runs, including the following:</p> <ul> <li> <p>The Amazon ECR paths of containers that contain the inference code and model artifacts.</p> </li> <li> <p>The instance types that the algorithm supports for transform jobs and real-time endpoints used for inference.</p> </li> <li> <p>The input and output content formats that the algorithm supports for inference.</p> </li> </ul>', 'CreateModelPackageInput$InferenceSpecification' => '<p>Specifies details about inference jobs that can be run with models based on this model package, including the following:</p> <ul> <li> <p>The Amazon ECR paths of containers that contain the inference code and model artifacts.</p> </li> <li> <p>The instance types that the model package supports for transform jobs and real-time endpoints used for inference.</p> </li> <li> <p>The input and output content formats that the model package supports for inference.</p> </li> </ul>', 'DescribeAlgorithmOutput$InferenceSpecification' => '<p>Details about inference jobs that the algorithm runs.</p>', 'DescribeModelPackageOutput$InferenceSpecification' => '<p>Details about inference jobs that can be run with models based on this model package.</p>', ], ], 'InputConfig' => [ 'base' => '<p>Contains information about the location of input model artifacts, the name and shape of the expected data inputs, and the framework in which the model was trained.</p>', 'refs' => [ 'CreateCompilationJobRequest$InputConfig' => '<p>Provides information about the location of input model artifacts, the name and shape of the expected data inputs, and the framework in which the model was trained.</p>', 'DescribeCompilationJobResponse$InputConfig' => '<p>Information about the location in Amazon S3 of the input model artifacts, the name and shape of the expected data inputs, and the framework in which the model was trained.</p>', ], ], 'InputDataConfig' => [ 'base' => NULL, 'refs' => [ 'CreateTrainingJobRequest$InputDataConfig' => '<p>An array of <code>Channel</code> objects. Each channel is a named input source. <code>InputDataConfig</code> describes the input data and its location. </p> <p>Algorithms can accept input data from one or more channels. For example, an algorithm might have two channels of input data, <code>training_data</code> and <code>validation_data</code>. The configuration for each channel provides the S3, EFS, or FSx location where the input data is stored. It also provides information about the stored data: the MIME type, compression method, and whether the data is wrapped in RecordIO format. </p> <p>Depending on the input mode that the algorithm supports, Amazon SageMaker either copies input data files from an S3 bucket to a local directory in the Docker container, or makes it available as input streams. For example, if you specify an EFS location, input data files will be made available as input streams. They do not need to be downloaded.</p>', 'DescribeTrainingJobResponse$InputDataConfig' => '<p>An array of <code>Channel</code> objects that describes each data input channel. </p>', 'HyperParameterTrainingJobDefinition$InputDataConfig' => '<p>An array of <a>Channel</a> objects that specify the input for the training jobs that the tuning job launches.</p>', 'TrainingJob$InputDataConfig' => '<p>An array of <code>Channel</code> objects that describes each data input channel.</p>', 'TrainingJobDefinition$InputDataConfig' => '<p>An array of <code>Channel</code> objects, each of which specifies an input source.</p>', ], ], 'InputModes' => [ 'base' => NULL, 'refs' => [ 'ChannelSpecification$SupportedInputModes' => '<p>The allowed input mode, either FILE or PIPE.</p> <p>In FILE mode, Amazon SageMaker copies the data from the input source onto the local Amazon Elastic Block Store (Amazon EBS) volumes before starting your training algorithm. This is the most commonly used input mode.</p> <p>In PIPE mode, Amazon SageMaker streams input data from the source directly to your algorithm without using the EBS volume.</p>', ], ], 'InstanceType' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceInput$InstanceType' => '<p>The type of ML compute instance to launch for the notebook instance.</p>', 'DescribeNotebookInstanceOutput$InstanceType' => '<p>The type of ML compute instance running on the notebook instance.</p>', 'NotebookInstanceSummary$InstanceType' => '<p>The type of ML compute instance that the notebook instance is running on.</p>', 'UpdateNotebookInstanceInput$InstanceType' => '<p>The Amazon ML compute instance type.</p>', ], ], 'IntegerParameterRange' => [ 'base' => '<p>For a hyperparameter of the integer type, specifies the range that a hyperparameter tuning job searches.</p>', 'refs' => [ 'IntegerParameterRanges$member' => NULL, ], ], 'IntegerParameterRangeSpecification' => [ 'base' => '<p>Defines the possible values for an integer hyperparameter.</p>', 'refs' => [ 'ParameterRange$IntegerParameterRangeSpecification' => '<p>A <code>IntegerParameterRangeSpecification</code> object that defines the possible values for an integer hyperparameter.</p>', ], ], 'IntegerParameterRanges' => [ 'base' => NULL, 'refs' => [ 'ParameterRanges$IntegerParameterRanges' => '<p>The array of <a>IntegerParameterRange</a> objects that specify ranges of integer hyperparameters that a hyperparameter tuning job searches.</p>', ], ], 'InvocationsMaxRetries' => [ 'base' => NULL, 'refs' => [ 'ModelClientConfig$InvocationsMaxRetries' => '<p>The maximum number of retries when invocation requests are failing.</p>', ], ], 'InvocationsTimeoutInSeconds' => [ 'base' => NULL, 'refs' => [ 'ModelClientConfig$InvocationsTimeoutInSeconds' => '<p>The timeout value in seconds for an invocation request.</p>', ], ], 'JobReferenceCode' => [ 'base' => NULL, 'refs' => [ 'DescribeLabelingJobResponse$JobReferenceCode' => '<p>A unique identifier for work done as part of a labeling job.</p>', 'LabelingJobForWorkteamSummary$JobReferenceCode' => '<p>A unique identifier for a labeling job. You can use this to refer to a specific labeling job.</p>', ], ], 'JobReferenceCodeContains' => [ 'base' => NULL, 'refs' => [ 'ListLabelingJobsForWorkteamRequest$JobReferenceCodeContains' => '<p>A filter the limits jobs to only the ones whose job reference code contains the specified string.</p>', ], ], 'JoinSource' => [ 'base' => NULL, 'refs' => [ 'DataProcessing$JoinSource' => '<p>Specifies the source of the data to join with the transformed data. The valid values are <code>None</code> and <code>Input</code>. The default value is <code>None</code>, which specifies not to join the input with the transformed data. If you want the batch transform job to join the original input data with the transformed data, set <code>JoinSource</code> to <code>Input</code>. </p> <p>For JSON or JSONLines objects, such as a JSON array, Amazon SageMaker adds the transformed data to the input JSON object in an attribute called <code>SageMakerOutput</code>. The joined result for JSON must be a key-value pair object. If the input is not a key-value pair object, Amazon SageMaker creates a new JSON file. In the new JSON file, and the input data is stored under the <code>SageMakerInput</code> key and the results are stored in <code>SageMakerOutput</code>.</p> <p>For CSV files, Amazon SageMaker combines the transformed data with the input data at the end of the input data and stores it in the output file. The joined data has the joined input data followed by the transformed data and the output is a CSV file. </p>', ], ], 'JsonContentType' => [ 'base' => NULL, 'refs' => [ 'JsonContentTypes$member' => NULL, ], ], 'JsonContentTypes' => [ 'base' => NULL, 'refs' => [ 'CaptureContentTypeHeader$JsonContentTypes' => '<p/>', ], ], 'JsonPath' => [ 'base' => NULL, 'refs' => [ 'DataProcessing$InputFilter' => '<p>A <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#data-processing-operators">JSONPath</a> expression used to select a portion of the input data to pass to the algorithm. Use the <code>InputFilter</code> parameter to exclude fields, such as an ID column, from the input. If you want Amazon SageMaker to pass the entire input dataset to the algorithm, accept the default value <code>$</code>.</p> <p>Examples: <code>"$"</code>, <code>"$[1:]"</code>, <code>"$.features"</code> </p>', 'DataProcessing$OutputFilter' => '<p>A <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#data-processing-operators">JSONPath</a> expression used to select a portion of the joined dataset to save in the output file for a batch transform job. If you want Amazon SageMaker to store the entire input dataset in the output file, leave the default value, <code>$</code>. If you specify indexes that aren\'t within the dimension size of the joined dataset, you get an error.</p> <p>Examples: <code>"$"</code>, <code>"$[0,5:]"</code>, <code>"$[\'id\',\'SageMakerOutput\']"</code> </p>', ], ], 'JupyterServerAppSettings' => [ 'base' => '<p>Jupyter server\'s app settings.</p>', 'refs' => [ 'UserSettings$JupyterServerAppSettings' => '<p>The Jupyter server\'s app settings.</p>', ], ], 'KernelGatewayAppSettings' => [ 'base' => '<p>The kernel gateway app settings.</p>', 'refs' => [ 'UserSettings$KernelGatewayAppSettings' => '<p>The kernel gateway app settings.</p>', ], ], 'KmsKeyId' => [ 'base' => NULL, 'refs' => [ 'AutoMLOutputDataConfig$KmsKeyId' => '<p>The AWS KMS encryption key ID.</p>', 'AutoMLSecurityConfig$VolumeKmsKeyId' => '<p>The key used to encrypt stored data.</p>', 'CreateDomainRequest$HomeEfsFileSystemKmsKeyId' => '<p>The AWS Key Management Service (KMS) encryption key ID. Encryption with a customer master key (CMK) is not supported.</p>', 'CreateEndpointConfigInput$KmsKeyId' => '<p>The Amazon Resource Name (ARN) of a AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.</p> <p>The KmsKeyId can be any of the following formats: </p> <ul> <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li> <li> <p>Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code> </p> </li> </ul> <p>The KMS key policy must grant permission to the IAM role that you specify in your <code>CreateEndpoint</code>, <code>UpdateEndpoint</code> requests. For more information, refer to the AWS Key Management Service section<a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html"> Using Key Policies in AWS KMS </a> </p> <note> <p>Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can\'t request a <code>KmsKeyId</code> when using an instance type with local storage. If any of the models that you specify in the <code>ProductionVariants</code> parameter use nitro-based instances with local storage, do not specify a value for the <code>KmsKeyId</code> parameter. If you specify a value for <code>KmsKeyId</code> when using any nitro-based instances with local storage, the call to <code>CreateEndpointConfig</code> fails.</p> <p>For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a>.</p> <p>For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store Volumes</a>.</p> </note>', 'CreateNotebookInstanceInput$KmsKeyId' => '<p>The Amazon Resource Name (ARN) of a AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to your notebook instance. The KMS key you provide must be enabled. For information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html">Enabling and Disabling Keys</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>', 'DataCaptureConfig$KmsKeyId' => '<p/>', 'DataCaptureConfigSummary$KmsKeyId' => '<p/>', 'DescribeDomainResponse$HomeEfsFileSystemKmsKeyId' => '<p>The AWS Key Management Service encryption key ID.</p>', 'DescribeEndpointConfigOutput$KmsKeyId' => '<p>AWS KMS key ID Amazon SageMaker uses to encrypt data when storing it on the ML storage volume attached to the instance.</p>', 'DescribeNotebookInstanceOutput$KmsKeyId' => '<p>The AWS KMS key ID Amazon SageMaker uses to encrypt data when storing it on the ML storage volume attached to the instance. </p>', 'FlowDefinitionOutputConfig$KmsKeyId' => '<p>The Amazon Key Management Service (KMS) key ID for server-side encryption.</p>', 'LabelingJobOutputConfig$KmsKeyId' => '<p>The AWS Key Management Service ID of the key used to encrypt the output data, if any.</p> <p>If you use a KMS key ID or an alias of your master key, the Amazon SageMaker execution role must include permissions to call <code>kms:Encrypt</code>. If you don\'t provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role\'s account. Amazon SageMaker uses server-side encryption with KMS-managed keys for <code>LabelingJobOutputConfig</code>. If you use a bucket policy with an <code>s3:PutObject</code> permission that only allows objects with server-side encryption, set the condition key of <code>s3:x-amz-server-side-encryption</code> to <code>"aws:kms"</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">KMS-Managed Encryption Keys</a> in the <i>Amazon Simple Storage Service Developer Guide.</i> </p> <p>The KMS key policy must grant permission to the IAM role that you specify in your <code>CreateLabelingJob</code> request. For more information, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Using Key Policies in AWS KMS</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>', 'LabelingJobResourceConfig$VolumeKmsKeyId' => '<p>The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the training job. The <code>VolumeKmsKeyId</code> can be any of the following formats:</p> <ul> <li> <p>// KMS Key ID</p> <p> <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>// Amazon Resource Name (ARN) of a KMS Key</p> <p> <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'MonitoringClusterConfig$VolumeKmsKeyId' => '<p>The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.</p>', 'MonitoringOutputConfig$KmsKeyId' => '<p>The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.</p>', 'OutputDataConfig$KmsKeyId' => '<p>The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption. The <code>KmsKeyId</code> can be any of the following formats: </p> <ul> <li> <p>// KMS Key ID</p> <p> <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>// Amazon Resource Name (ARN) of a KMS Key</p> <p> <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>// KMS Key Alias</p> <p> <code>"alias/ExampleAlias"</code> </p> </li> <li> <p>// Amazon Resource Name (ARN) of a KMS Key Alias</p> <p> <code>"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"</code> </p> </li> </ul> <p>If you use a KMS key ID or an alias of your master key, the Amazon SageMaker execution role must include permissions to call <code>kms:Encrypt</code>. If you don\'t provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role\'s account. Amazon SageMaker uses server-side encryption with KMS-managed keys for <code>OutputDataConfig</code>. If you use a bucket policy with an <code>s3:PutObject</code> permission that only allows objects with server-side encryption, set the condition key of <code>s3:x-amz-server-side-encryption</code> to <code>"aws:kms"</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">KMS-Managed Encryption Keys</a> in the <i>Amazon Simple Storage Service Developer Guide.</i> </p> <p>The KMS key policy must grant permission to the IAM role that you specify in your <code>CreateTrainingJob</code>, <code>CreateTransformJob</code>, or <code>CreateHyperParameterTuningJob</code> requests. For more information, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Using Key Policies in AWS KMS</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>', 'ProcessingClusterConfig$VolumeKmsKeyId' => '<p>The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the processing job. </p>', 'ProcessingOutputConfig$KmsKeyId' => '<p>The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the processing job output. <code>KmsKeyId</code> can be an ID of a KMS key, ARN of a KMS key, alias of a KMS key, or alias of a KMS key. The <code>KmsKeyId</code> is applied to all outputs.</p>', 'ResourceConfig$VolumeKmsKeyId' => '<p>The AWS KMS key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the training job.</p> <note> <p>Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can\'t request a <code>VolumeKmsKeyId</code> when using an instance type with local storage.</p> <p>For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a>.</p> <p>For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store Volumes</a>.</p> </note> <p>The <code>VolumeKmsKeyId</code> can be in any of the following formats:</p> <ul> <li> <p>// KMS Key ID</p> <p> <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>// Amazon Resource Name (ARN) of a KMS Key</p> <p> <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'SharingSettings$S3KmsKeyId' => '<p>When <code>NotebookOutputOption</code> is <code>Allowed</code>, the AWS Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.</p>', 'TransformOutput$KmsKeyId' => '<p>The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption. The <code>KmsKeyId</code> can be any of the following formats: </p> <ul> <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li> <li> <p>Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code> </p> </li> </ul> <p>If you don\'t provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role\'s account. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">KMS-Managed Encryption Keys</a> in the <i>Amazon Simple Storage Service Developer Guide.</i> </p> <p>The KMS key policy must grant permission to the IAM role that you specify in your <a>CreateModel</a> request. For more information, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Using Key Policies in AWS KMS</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>', 'TransformResources$VolumeKmsKeyId' => '<p>The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt model data on the storage volume attached to the ML compute instance(s) that run the batch transform job. The <code>VolumeKmsKeyId</code> can be any of the following formats:</p> <ul> <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li> <li> <p>Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code> </p> </li> </ul>', ], ], 'LabelAttributeName' => [ 'base' => NULL, 'refs' => [ 'CreateLabelingJobRequest$LabelAttributeName' => '<p>The attribute name to use for the label in the output manifest file. This is the key for the key/value pair formed with the label that a worker assigns to the object. The name can\'t end with "-metadata". If you are running a semantic segmentation labeling job, the attribute name must end with "-ref". If you are running any other kind of labeling job, the attribute name must not end with "-ref".</p>', 'DescribeLabelingJobResponse$LabelAttributeName' => '<p>The attribute used as the label in the output manifest file.</p>', ], ], 'LabelCounter' => [ 'base' => NULL, 'refs' => [ 'LabelCounters$TotalLabeled' => '<p>The total number of objects labeled.</p>', 'LabelCounters$HumanLabeled' => '<p>The total number of objects labeled by a human worker.</p>', 'LabelCounters$MachineLabeled' => '<p>The total number of objects labeled by automated data labeling.</p>', 'LabelCounters$FailedNonRetryableError' => '<p>The total number of objects that could not be labeled due to an error.</p>', 'LabelCounters$Unlabeled' => '<p>The total number of objects not yet labeled.</p>', 'LabelCountersForWorkteam$HumanLabeled' => '<p>The total number of data objects labeled by a human worker.</p>', 'LabelCountersForWorkteam$PendingHuman' => '<p>The total number of data objects that need to be labeled by a human worker.</p>', 'LabelCountersForWorkteam$Total' => '<p>The total number of tasks in the labeling job.</p>', ], ], 'LabelCounters' => [ 'base' => '<p>Provides a breakdown of the number of objects labeled.</p>', 'refs' => [ 'DescribeLabelingJobResponse$LabelCounters' => '<p>Provides a breakdown of the number of data objects labeled by humans, the number of objects labeled by machine, the number of objects than couldn\'t be labeled, and the total number of objects labeled. </p>', 'LabelingJobSummary$LabelCounters' => '<p>Counts showing the progress of the labeling job.</p>', ], ], 'LabelCountersForWorkteam' => [ 'base' => '<p>Provides counts for human-labeled tasks in the labeling job.</p>', 'refs' => [ 'LabelingJobForWorkteamSummary$LabelCounters' => '<p>Provides information about the progress of a labeling job.</p>', ], ], 'LabelingJobAlgorithmSpecificationArn' => [ 'base' => NULL, 'refs' => [ 'LabelingJobAlgorithmsConfig$LabelingJobAlgorithmSpecificationArn' => '<p>Specifies the Amazon Resource Name (ARN) of the algorithm used for auto-labeling. You must select one of the following ARNs:</p> <ul> <li> <p> <i>Image classification</i> </p> <p> <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/image-classification</code> </p> </li> <li> <p> <i>Text classification</i> </p> <p> <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/text-classification</code> </p> </li> <li> <p> <i>Object detection</i> </p> <p> <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/object-detection</code> </p> </li> <li> <p> <i>Semantic Segmentation</i> </p> <p> <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/semantic-segmentation</code> </p> </li> </ul>', ], ], 'LabelingJobAlgorithmsConfig' => [ 'base' => '<p>Provides configuration information for auto-labeling of your data objects. A <code>LabelingJobAlgorithmsConfig</code> object must be supplied in order to use auto-labeling.</p>', 'refs' => [ 'CreateLabelingJobRequest$LabelingJobAlgorithmsConfig' => '<p>Configures the information required to perform automated data labeling.</p>', 'DescribeLabelingJobResponse$LabelingJobAlgorithmsConfig' => '<p>Configuration information for automated data labeling.</p>', ], ], 'LabelingJobArn' => [ 'base' => NULL, 'refs' => [ 'CreateLabelingJobResponse$LabelingJobArn' => '<p>The Amazon Resource Name (ARN) of the labeling job. You use this ARN to identify the labeling job.</p>', 'DescribeLabelingJobResponse$LabelingJobArn' => '<p>The Amazon Resource Name (ARN) of the labeling job.</p>', 'DescribeTrainingJobResponse$LabelingJobArn' => '<p>The Amazon Resource Name (ARN) of the Amazon SageMaker Ground Truth labeling job that created the transform or training job.</p>', 'DescribeTransformJobResponse$LabelingJobArn' => '<p>The Amazon Resource Name (ARN) of the Amazon SageMaker Ground Truth labeling job that created the transform or training job.</p>', 'LabelingJobSummary$LabelingJobArn' => '<p>The Amazon Resource Name (ARN) assigned to the labeling job when it was created.</p>', 'TrainingJob$LabelingJobArn' => '<p>The Amazon Resource Name (ARN) of the labeling job.</p>', 'TransformJob$LabelingJobArn' => '<p>The Amazon Resource Name (ARN) of the labeling job that created the transform job.</p>', ], ], 'LabelingJobDataAttributes' => [ 'base' => '<p>Attributes of the data specified by the customer. Use these to describe the data to be labeled.</p>', 'refs' => [ 'LabelingJobInputConfig$DataAttributes' => '<p>Attributes of the data specified by the customer.</p>', ], ], 'LabelingJobDataSource' => [ 'base' => '<p>Provides information about the location of input data.</p>', 'refs' => [ 'LabelingJobInputConfig$DataSource' => '<p>The location of the input data.</p>', ], ], 'LabelingJobForWorkteamSummary' => [ 'base' => '<p>Provides summary information for a work team.</p>', 'refs' => [ 'LabelingJobForWorkteamSummaryList$member' => NULL, ], ], 'LabelingJobForWorkteamSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListLabelingJobsForWorkteamResponse$LabelingJobSummaryList' => '<p>An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.</p>', ], ], 'LabelingJobInputConfig' => [ 'base' => '<p>Input configuration information for a labeling job.</p>', 'refs' => [ 'CreateLabelingJobRequest$InputConfig' => '<p>Input data for the labeling job, such as the Amazon S3 location of the data objects and the location of the manifest file that describes the data objects.</p>', 'DescribeLabelingJobResponse$InputConfig' => '<p>Input configuration information for the labeling job, such as the Amazon S3 location of the data objects and the location of the manifest file that describes the data objects.</p>', 'LabelingJobSummary$InputConfig' => '<p>Input configuration for the labeling job.</p>', ], ], 'LabelingJobName' => [ 'base' => NULL, 'refs' => [ 'CreateLabelingJobRequest$LabelingJobName' => '<p>The name of the labeling job. This name is used to identify the job in a list of labeling jobs.</p>', 'DescribeLabelingJobRequest$LabelingJobName' => '<p>The name of the labeling job to return information for.</p>', 'DescribeLabelingJobResponse$LabelingJobName' => '<p>The name assigned to the labeling job when it was created.</p>', 'LabelingJobForWorkteamSummary$LabelingJobName' => '<p>The name of the labeling job that the work team is assigned to.</p>', 'LabelingJobSummary$LabelingJobName' => '<p>The name of the labeling job.</p>', 'StopLabelingJobRequest$LabelingJobName' => '<p>The name of the labeling job to stop.</p>', ], ], 'LabelingJobOutput' => [ 'base' => '<p>Specifies the location of the output produced by the labeling job. </p>', 'refs' => [ 'DescribeLabelingJobResponse$LabelingJobOutput' => '<p>The location of the output produced by the labeling job.</p>', 'LabelingJobSummary$LabelingJobOutput' => '<p>The location of the output produced by the labeling job.</p>', ], ], 'LabelingJobOutputConfig' => [ 'base' => '<p>Output configuration information for a labeling job.</p>', 'refs' => [ 'CreateLabelingJobRequest$OutputConfig' => '<p>The location of the output data and the AWS Key Management Service key ID for the key used to encrypt the output data, if any.</p>', 'DescribeLabelingJobResponse$OutputConfig' => '<p>The location of the job\'s output data and the AWS Key Management Service key ID for the key used to encrypt the output data, if any.</p>', ], ], 'LabelingJobResourceConfig' => [ 'base' => '<p>Provides configuration information for labeling jobs.</p>', 'refs' => [ 'LabelingJobAlgorithmsConfig$LabelingJobResourceConfig' => '<p>Provides configuration information for a labeling job.</p>', ], ], 'LabelingJobS3DataSource' => [ 'base' => '<p>The Amazon S3 location of the input data objects.</p>', 'refs' => [ 'LabelingJobDataSource$S3DataSource' => '<p>The Amazon S3 location of the input data objects.</p>', ], ], 'LabelingJobStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeLabelingJobResponse$LabelingJobStatus' => '<p>The processing status of the labeling job. </p>', 'LabelingJobSummary$LabelingJobStatus' => '<p>The current status of the labeling job. </p>', 'ListLabelingJobsRequest$StatusEquals' => '<p>A filter that retrieves only labeling jobs with a specific status.</p>', ], ], 'LabelingJobStoppingConditions' => [ 'base' => '<p>A set of conditions for stopping a labeling job. If any of the conditions are met, the job is automatically stopped. You can use these conditions to control the cost of data labeling.</p> <note> <p>Labeling jobs fail after 30 days with an appropriate client error message.</p> </note>', 'refs' => [ 'CreateLabelingJobRequest$StoppingConditions' => '<p>A set of conditions for stopping the labeling job. If any of the conditions are met, the job is automatically stopped. You can use these conditions to control the cost of data labeling.</p>', 'DescribeLabelingJobResponse$StoppingConditions' => '<p>A set of conditions for stopping a labeling job. If any of the conditions are met, the job is automatically stopped.</p>', ], ], 'LabelingJobSummary' => [ 'base' => '<p>Provides summary information about a labeling job.</p>', 'refs' => [ 'LabelingJobSummaryList$member' => NULL, ], ], 'LabelingJobSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListLabelingJobsResponse$LabelingJobSummaryList' => '<p>An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.</p>', ], ], 'LambdaFunctionArn' => [ 'base' => NULL, 'refs' => [ 'AnnotationConsolidationConfig$AnnotationConsolidationLambdaArn' => '<p>The Amazon Resource Name (ARN) of a Lambda function implements the logic for <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-annotation-consolidation.html">annotation consolidation</a> and to process output data.</p> <p>This parameter is required for all labeling jobs. For <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types</a>, use one of the following Amazon SageMaker Ground Truth Lambda function ARNs for <code>AnnotationConsolidationLambdaArn</code>. For custom labeling workflows, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step3.html#sms-custom-templates-step3-postlambda">Post-annotation Lambda</a>. </p> <p> <b>Bounding box</b> - Finds the most similar boxes from different workers based on the Jaccard index of the boxes.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-BoundingBox</code> </p> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-BoundingBox</code> </p> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-BoundingBox</code> </p> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-BoundingBox</code> </p> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-BoundingBox</code> </p> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-BoundingBox</code> </p> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-BoundingBox</code> </p> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-BoundingBox</code> </p> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-BoundingBox</code> </p> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-BoundingBox</code> </p> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-BoundingBox</code> </p> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-BoundingBox</code> </p> </li> </ul> <p> <b>Image classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of an image based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-ImageMultiClass</code> </p> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-ImageMultiClass</code> </p> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-ImageMultiClass</code> </p> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-ImageMultiClass</code> </p> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-ImageMultiClass</code> </p> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-ImageMultiClass</code> </p> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-ImageMultiClass</code> </p> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-ImageMultiClass</code> </p> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-ImageMultiClass</code> </p> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-ImageMultiClass</code> </p> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-ImageMultiClass</code> </p> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-ImageMultiClass</code> </p> </li> </ul> <p> <b>Multi-label image classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true classes of an image based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-ImageMultiClassMultiLabel</code> </p> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-ImageMultiClassMultiLabel</code> </p> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-ImageMultiClassMultiLabel</code> </p> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-ImageMultiClassMultiLabel</code> </p> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-ImageMultiClassMultiLabel</code> </p> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-ImageMultiClassMultiLabel</code> </p> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-ImageMultiClassMultiLabel</code> </p> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-ImageMultiClassMultiLabel</code> </p> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-ImageMultiClassMultiLabel</code> </p> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-ImageMultiClassMultiLabel</code> </p> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-ImageMultiClassMultiLabel</code> </p> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> </ul> <p> <b>Semantic segmentation</b> - Treats each pixel in an image as a multi-class classification and treats pixel annotations from workers as "votes" for the correct label.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-SemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-SemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-SemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-SemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-SemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-SemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-SemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-SemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-SemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-SemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-SemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-SemanticSegmentation</code> </p> </li> </ul> <p> <b>Text classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of text based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-TextMultiClass</code> </p> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-TextMultiClass</code> </p> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-TextMultiClass</code> </p> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-TextMultiClass</code> </p> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-TextMultiClass</code> </p> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-TextMultiClass</code> </p> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-TextMultiClass</code> </p> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-TextMultiClass</code> </p> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-TextMultiClass</code> </p> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-TextMultiClass</code> </p> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-TextMultiClass</code> </p> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-TextMultiClass</code> </p> </li> </ul> <p> <b>Multi-label text classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true classes of text based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-TextMultiClassMultiLabel</code> </p> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-TextMultiClassMultiLabel</code> </p> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-TextMultiClassMultiLabel</code> </p> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-TextMultiClassMultiLabel</code> </p> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-TextMultiClassMultiLabel</code> </p> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-TextMultiClassMultiLabel</code> </p> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-TextMultiClassMultiLabel</code> </p> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-TextMultiClassMultiLabel</code> </p> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-TextMultiClassMultiLabel</code> </p> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-TextMultiClassMultiLabel</code> </p> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-TextMultiClassMultiLabel</code> </p> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-TextMultiClassMultiLabel</code> </p> </li> </ul> <p> <b>Named entity recognition</b> - Groups similar selections and calculates aggregate boundaries, resolving to most-assigned label.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-NamedEntityRecognition</code> </p> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-NamedEntityRecognition</code> </p> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-NamedEntityRecognition</code> </p> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-NamedEntityRecognition</code> </p> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-NamedEntityRecognition</code> </p> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-NamedEntityRecognition</code> </p> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-NamedEntityRecognition</code> </p> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-NamedEntityRecognition</code> </p> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-NamedEntityRecognition</code> </p> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-NamedEntityRecognition</code> </p> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-NamedEntityRecognition</code> </p> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-NamedEntityRecognition</code> </p> </li> </ul> <p> <b>Named entity recognition</b> - Groups similar selections and calculates aggregate boundaries, resolving to most-assigned label.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-NamedEntityRecognition</code> </p> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-NamedEntityRecognition</code> </p> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-NamedEntityRecognition</code> </p> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-NamedEntityRecognition</code> </p> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-NamedEntityRecognition</code> </p> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-NamedEntityRecognition</code> </p> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-NamedEntityRecognition</code> </p> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-NamedEntityRecognition</code> </p> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-NamedEntityRecognition</code> </p> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-NamedEntityRecognition</code> </p> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-NamedEntityRecognition</code> </p> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-NamedEntityRecognition</code> </p> </li> </ul> <p> <b>Video Classification</b> - Use this task type when you need workers to classify videos using predefined labels that you specify. Workers are shown videos and are asked to choose one label for each video.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-VideoMultiClass</code> </p> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-VideoMultiClass</code> </p> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-VideoMultiClass</code> </p> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-VideoMultiClass</code> </p> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VideoMultiClass</code> </p> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VideoMultiClass</code> </p> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-VideoMultiClass</code> </p> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-VideoMultiClass</code> </p> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VideoMultiClass</code> </p> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-VideoMultiClass</code> </p> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VideoMultiClass</code> </p> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-VideoMultiClass</code> </p> </li> </ul> <p> <b>Video Frame Object Detection</b> - Use this task type to have workers identify and locate objects in a sequence of video frames (images extracted from a video) using bounding boxes. For example, you can use this task to ask workers to identify and localize various objects in a series of video frames, such as cars, bikes, and pedestrians.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-VideoObjectDetection</code> </p> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-VideoObjectDetection</code> </p> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-VideoObjectDetection</code> </p> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-VideoObjectDetection</code> </p> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VideoObjectDetection</code> </p> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VideoObjectDetection</code> </p> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-VideoObjectDetection</code> </p> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-VideoObjectDetection</code> </p> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VideoObjectDetection</code> </p> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-VideoObjectDetection</code> </p> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VideoObjectDetection</code> </p> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-VideoObjectDetection</code> </p> </li> </ul> <p> <b>Video Frame Object Tracking</b> - Use this task type to have workers track the movement of objects in a sequence of video frames (images extracted from a video) using bounding boxes. For example, you can use this task to ask workers to track the movement of objects, such as cars, bikes, and pedestrians. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-VideoObjectTracking</code> </p> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-VideoObjectTracking</code> </p> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-VideoObjectTracking</code> </p> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-VideoObjectTracking</code> </p> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VideoObjectTracking</code> </p> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VideoObjectTracking</code> </p> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-VideoObjectTracking</code> </p> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-VideoObjectTracking</code> </p> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VideoObjectTracking</code> </p> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-VideoObjectTracking</code> </p> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VideoObjectTracking</code> </p> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-VideoObjectTracking</code> </p> </li> </ul> <p> <b>3D point cloud object detection</b> - Use this task type when you want workers to classify objects in a 3D point cloud by drawing 3D cuboids around objects. For example, you can use this task type to ask workers to identify different types of objects in a point cloud, such as cars, bikes, and pedestrians.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudObjectDetection</code> </p> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudObjectDetection</code> </p> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudObjectDetection</code> </p> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudObjectDetection</code> </p> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudObjectDetection</code> </p> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudObjectDetection</code> </p> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudObjectDetection</code> </p> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudObjectDetection</code> </p> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudObjectDetection</code> </p> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudObjectDetection</code> </p> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudObjectDetection</code> </p> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudObjectDetection</code> </p> </li> </ul> <p> <b>3D point cloud object tracking</b> - Use this task type when you want workers to draw 3D cuboids around objects that appear in a sequence of 3D point cloud frames. For example, you can use this task type to ask workers to track the movement of vehicles across multiple point cloud frames. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudObjectTracking</code> </p> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudObjectTracking</code> </p> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudObjectTracking</code> </p> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudObjectTracking</code> </p> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudObjectTracking</code> </p> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudObjectTracking</code> </p> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudObjectTracking</code> </p> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudObjectTracking</code> </p> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudObjectTracking</code> </p> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudObjectTracking</code> </p> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudObjectTracking</code> </p> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudObjectTracking</code> </p> </li> </ul> <p> <b>3D point cloud semantic segmentation</b> - Use this task type when you want workers to create a point-level semantic segmentation masks by painting objects in a 3D point cloud using different colors where each color is assigned to one of the classes you specify.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> </ul> <p> <b>Use the following ARNs for Label Verification and Adjustment Jobs</b> </p> <p>Use label verification and adjustment jobs to review and adjust labels. To learn more, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html">Verify and Adjust Labels </a>.</p> <p> <b>Semantic segmentation adjustment</b> - Treats each pixel in an image as a multi-class classification and treats pixel adjusted annotations from workers as "votes" for the correct label.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> </ul> <p> <b>Semantic segmentation verification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of verification judgment for semantic segmentation labels based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-VerificationSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-VerificationSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-VerificationSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-VerificationSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VerificationSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VerificationSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-VerificationSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-VerificationSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VerificationSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-VerificationSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VerificationSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-VerificationSemanticSegmentation</code> </p> </li> </ul> <p> <b>Bounding box verification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of verification judgement for bounding box labels based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-VerificationBoundingBox</code> </p> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-VerificationBoundingBox</code> </p> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-VerificationBoundingBox</code> </p> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-VerificationBoundingBox</code> </p> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VerificationBoundingBox</code> </p> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VerificationBoundingBox</code> </p> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-VerificationBoundingBox</code> </p> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-VerificationBoundingBox</code> </p> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VerificationBoundingBox</code> </p> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-VerificationBoundingBox</code> </p> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VerificationBoundingBox</code> </p> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-VerificationBoundingBox</code> </p> </li> </ul> <p> <b>Bounding box adjustment</b> - Finds the most similar boxes from different workers based on the Jaccard index of the adjusted annotations.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentBoundingBox</code> </p> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentBoundingBox</code> </p> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentBoundingBox</code> </p> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentBoundingBox</code> </p> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentBoundingBox</code> </p> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentBoundingBox</code> </p> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentBoundingBox</code> </p> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentBoundingBox</code> </p> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentBoundingBox</code> </p> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentBoundingBox</code> </p> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentBoundingBox</code> </p> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentBoundingBox</code> </p> </li> </ul> <p> <b>Video Frame Object Detection Adjustment</b> - Use this task type when you want workers to adjust bounding boxes that workers have added to video frames to classify and localize objects in a sequence of video frames.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentVideoObjectDetection</code> </p> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentVideoObjectDetection</code> </p> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentVideoObjectDetection</code> </p> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentVideoObjectDetection</code> </p> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentVideoObjectDetection</code> </p> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentVideoObjectDetection</code> </p> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentVideoObjectDetection</code> </p> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentVideoObjectDetection</code> </p> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentVideoObjectDetection</code> </p> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentVideoObjectDetection</code> </p> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentVideoObjectDetection</code> </p> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> </ul> <p> <b>Video Frame Object Tracking Adjustment</b> - Use this task type when you want workers to adjust bounding boxes that workers have added to video frames to track object movement across a sequence of video frames.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentVideoObjectTracking</code> </p> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentVideoObjectTracking</code> </p> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentVideoObjectTracking</code> </p> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentVideoObjectTracking</code> </p> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentVideoObjectTracking</code> </p> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentVideoObjectTracking</code> </p> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentVideoObjectTracking</code> </p> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentVideoObjectTracking</code> </p> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentVideoObjectTracking</code> </p> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentVideoObjectTracking</code> </p> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentVideoObjectTracking</code> </p> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> </ul> <p> <b>3D point cloud object detection adjustment</b> - Use this task type when you want workers to adjust 3D cuboids around objects in a 3D point cloud. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> </ul> <p> <b>3D point cloud object tracking adjustment</b> - Use this task type when you want workers to adjust 3D cuboids around objects that appear in a sequence of 3D point cloud frames.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> </ul> <p> <b>3D point cloud semantic segmentation adjustment</b> - Use this task type when you want workers to adjust a point-level semantic segmentation masks using a paint tool.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> </ul>', 'HumanTaskConfig$PreHumanTaskLambdaArn' => '<p>The Amazon Resource Name (ARN) of a Lambda function that is run before a data object is sent to a human worker. Use this function to provide input to a custom labeling job.</p> <p>For <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types</a>, use one of the following Amazon SageMaker Ground Truth Lambda function ARNs for <code>PreHumanTaskLambdaArn</code>. For custom labeling workflows, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step3.html#sms-custom-templates-step3-prelambda">Pre-annotation Lambda</a>. </p> <p> <b>Bounding box</b> - Finds the most similar boxes from different workers based on the Jaccard index of the boxes.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-BoundingBox</code> </p> </li> </ul> <p> <b>Image classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of an image based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-ImageMultiClass</code> </p> </li> </ul> <p> <b>Multi-label image classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true classes of an image based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> </ul> <p> <b>Semantic segmentation</b> - Treats each pixel in an image as a multi-class classification and treats pixel annotations from workers as "votes" for the correct label.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-SemanticSegmentation</code> </p> </li> </ul> <p> <b>Text classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of text based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-TextMultiClass</code> </p> </li> </ul> <p> <b>Multi-label text classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true classes of text based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-TextMultiClassMultiLabel</code> </p> </li> </ul> <p> <b>Named entity recognition</b> - Groups similar selections and calculates aggregate boundaries, resolving to most-assigned label.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-NamedEntityRecognition</code> </p> </li> </ul> <p> <b>Video Classification</b> - Use this task type when you need workers to classify videos using predefined labels that you specify. Workers are shown videos and are asked to choose one label for each video.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoMultiClass</code> </p> </li> </ul> <p> <b>Video Frame Object Detection</b> - Use this task type to have workers identify and locate objects in a sequence of video frames (images extracted from a video) using bounding boxes. For example, you can use this task to ask workers to identify and localize various objects in a series of video frames, such as cars, bikes, and pedestrians.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoObjectDetection</code> </p> </li> </ul> <p> <b>Video Frame Object Tracking</b> - Use this task type to have workers track the movement of objects in a sequence of video frames (images extracted from a video) using bounding boxes. For example, you can use this task to ask workers to track the movement of objects, such as cars, bikes, and pedestrians. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoObjectTracking</code> </p> </li> </ul> <p> <b>3D Point Cloud Modalities</b> </p> <p>Use the following pre-annotation lambdas for 3D point cloud labeling modality tasks. See <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud-task-types.html">3D Point Cloud Task types </a> to learn more. </p> <p> <b>3D Point Cloud Object Detection</b> - Use this task type when you want workers to classify objects in a 3D point cloud by drawing 3D cuboids around objects. For example, you can use this task type to ask workers to identify different types of objects in a point cloud, such as cars, bikes, and pedestrians.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudObjectDetection</code> </p> </li> </ul> <p> <b>3D Point Cloud Object Tracking</b> - Use this task type when you want workers to draw 3D cuboids around objects that appear in a sequence of 3D point cloud frames. For example, you can use this task type to ask workers to track the movement of vehicles across multiple point cloud frames. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudObjectTracking</code> </p> </li> </ul> <p> <b>3D Point Cloud Semantic Segmentation</b> - Use this task type when you want workers to create a point-level semantic segmentation masks by painting objects in a 3D point cloud using different colors where each color is assigned to one of the classes you specify.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> </ul> <p> <b>Use the following ARNs for Label Verification and Adjustment Jobs</b> </p> <p>Use label verification and adjustment jobs to review and adjust labels. To learn more, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html">Verify and Adjust Labels </a>.</p> <p> <b>Bounding box verification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of verification judgement for bounding box labels based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> </ul> <p> <b>Bounding box adjustment</b> - Finds the most similar boxes from different workers based on the Jaccard index of the adjusted annotations.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentBoundingBox</code> </p> </li> </ul> <p> <b>Semantic segmentation verification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of verification judgment for semantic segmentation labels based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VerificationSemanticSegmentation</code> </p> </li> </ul> <p> <b>Semantic segmentation adjustment</b> - Treats each pixel in an image as a multi-class classification and treats pixel adjusted annotations from workers as "votes" for the correct label.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> </ul> <p> <b>Video Frame Object Detection Adjustment</b> - Use this task type when you want workers to adjust bounding boxes that workers have added to video frames to classify and localize objects in a sequence of video frames.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> </ul> <p> <b>Video Frame Object Tracking Adjustment</b> - Use this task type when you want workers to adjust bounding boxes that workers have added to video frames to track object movement across a sequence of video frames.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> </ul> <p> <b>3D point cloud object detection adjustment</b> - Adjust 3D cuboids in a point cloud frame. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> </ul> <p> <b>3D point cloud object tracking adjustment</b> - Adjust 3D cuboids across a sequence of point cloud frames. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> </ul> <p> <b>3D point cloud semantic segmentation adjustment</b> - Adjust semantic segmentation masks in a 3D point cloud. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> </ul>', 'LabelingJobSummary$PreHumanTaskLambdaArn' => '<p>The Amazon Resource Name (ARN) of a Lambda function. The function is run before each data object is sent to a worker.</p>', 'LabelingJobSummary$AnnotationConsolidationLambdaArn' => '<p>The Amazon Resource Name (ARN) of the Lambda function used to consolidate the annotations from individual workers into a label for a data object. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-annotation-consolidation.html">Annotation Consolidation</a>.</p>', ], ], 'LastModifiedTime' => [ 'base' => NULL, 'refs' => [ 'CodeRepositorySummary$LastModifiedTime' => '<p>The date and time that the Git repository was last modified.</p>', 'CompilationJobSummary$LastModifiedTime' => '<p>The time when the model compilation job was last modified.</p>', 'DescribeCodeRepositoryOutput$LastModifiedTime' => '<p>The date and time that the repository was last changed.</p>', 'DescribeCompilationJobResponse$LastModifiedTime' => '<p>The time that the status of the model compilation job was last modified.</p>', 'DescribeDomainResponse$LastModifiedTime' => '<p>The last modified time.</p>', 'DescribeNotebookInstanceLifecycleConfigOutput$LastModifiedTime' => '<p>A timestamp that tells when the lifecycle configuration was last modified.</p>', 'DescribeNotebookInstanceOutput$LastModifiedTime' => '<p>A timestamp. Use this parameter to retrieve the time when the notebook instance was last modified. </p>', 'DescribeUserProfileResponse$LastModifiedTime' => '<p>The last modified time.</p>', 'DomainDetails$LastModifiedTime' => '<p>The last modified time.</p>', 'ListCompilationJobsRequest$LastModifiedTimeAfter' => '<p>A filter that returns the model compilation jobs that were modified after a specified time.</p>', 'ListCompilationJobsRequest$LastModifiedTimeBefore' => '<p>A filter that returns the model compilation jobs that were modified before a specified time.</p>', 'ListNotebookInstanceLifecycleConfigsInput$LastModifiedTimeBefore' => '<p>A filter that returns only lifecycle configurations that were modified before the specified time (timestamp).</p>', 'ListNotebookInstanceLifecycleConfigsInput$LastModifiedTimeAfter' => '<p>A filter that returns only lifecycle configurations that were modified after the specified time (timestamp).</p>', 'ListNotebookInstancesInput$LastModifiedTimeBefore' => '<p>A filter that returns only notebook instances that were modified before the specified time (timestamp).</p>', 'ListNotebookInstancesInput$LastModifiedTimeAfter' => '<p>A filter that returns only notebook instances that were modified after the specified time (timestamp).</p>', 'NotebookInstanceLifecycleConfigSummary$LastModifiedTime' => '<p>A timestamp that tells when the lifecycle configuration was last modified.</p>', 'NotebookInstanceSummary$LastModifiedTime' => '<p>A timestamp that shows when the notebook instance was last modified.</p>', 'UserProfileDetails$LastModifiedTime' => '<p>The last modified time.</p>', ], ], 'ListAlgorithmsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListAlgorithmsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListAppsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAutoMLJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAutoMLJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCandidatesForAutoMLJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCandidatesForAutoMLJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCodeRepositoriesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListCodeRepositoriesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListCompilationJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCompilationJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCompilationJobsSortBy' => [ 'base' => NULL, 'refs' => [ 'ListCompilationJobsRequest$SortBy' => '<p>The field by which to sort results. The default is <code>CreationTime</code>.</p>', ], ], 'ListDomainsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDomainsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEndpointConfigsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListEndpointConfigsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListEndpointsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListEndpointsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListExperimentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListExperimentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFlowDefinitionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFlowDefinitionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListHumanTaskUisRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListHumanTaskUisResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListHyperParameterTuningJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListHyperParameterTuningJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLabelingJobsForWorkteamRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLabelingJobsForWorkteamResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLabelingJobsForWorkteamSortByOptions' => [ 'base' => NULL, 'refs' => [ 'ListLabelingJobsForWorkteamRequest$SortBy' => '<p>The field to sort results by. The default is <code>CreationTime</code>.</p>', ], ], 'ListLabelingJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLabelingJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListModelPackagesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListModelPackagesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListModelsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListModelsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListMonitoringExecutionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMonitoringExecutionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMonitoringSchedulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMonitoringSchedulesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListNotebookInstanceLifecycleConfigsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListNotebookInstanceLifecycleConfigsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListNotebookInstancesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListNotebookInstancesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListProcessingJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListProcessingJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSubscribedWorkteamsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSubscribedWorkteamsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListTagsInput$MaxResults' => '<p>Maximum number of tags to return.</p>', ], ], 'ListTagsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTrainingJobsForHyperParameterTuningJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTrainingJobsForHyperParameterTuningJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTrainingJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTrainingJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTransformJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTransformJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTrialComponentKey256' => [ 'base' => NULL, 'refs' => [ 'UpdateTrialComponentRequest$ParametersToRemove' => '<p>The hyperparameters to remove from the component.</p>', 'UpdateTrialComponentRequest$InputArtifactsToRemove' => '<p>The input artifacts to remove from the component.</p>', 'UpdateTrialComponentRequest$OutputArtifactsToRemove' => '<p>The output artifacts to remove from the component.</p>', ], ], 'ListTrialComponentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTrialComponentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTrialsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTrialsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUserProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUserProfilesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkforcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkforcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkforcesSortByOptions' => [ 'base' => NULL, 'refs' => [ 'ListWorkforcesRequest$SortBy' => '<p>Sort workforces using the workforce name or creation date.</p>', ], ], 'ListWorkteamsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkteamsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkteamsSortByOptions' => [ 'base' => NULL, 'refs' => [ 'ListWorkteamsRequest$SortBy' => '<p>The field to sort results by. The default is <code>CreationTime</code>.</p>', ], ], 'MaxAutoMLJobRuntimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobCompletionCriteria$MaxAutoMLJobRuntimeInSeconds' => '<p>The maximum time, in seconds, an AutoML job is allowed to wait for a trial to complete. It must be equal to or greater than MaxRuntimePerTrainingJobInSeconds.</p>', ], ], 'MaxCandidates' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobCompletionCriteria$MaxCandidates' => '<p>The maximum number of times a training job is allowed to run.</p>', ], ], 'MaxConcurrentTaskCount' => [ 'base' => NULL, 'refs' => [ 'HumanTaskConfig$MaxConcurrentTaskCount' => '<p>Defines the maximum number of data objects that can be labeled by human workers at the same time. Also referred to as batch size. Each object may have more than one worker at one time. The default value is 1000 objects.</p>', ], ], 'MaxConcurrentTransforms' => [ 'base' => NULL, 'refs' => [ 'CreateTransformJobRequest$MaxConcurrentTransforms' => '<p>The maximum number of parallel requests that can be sent to each instance in a transform job. If <code>MaxConcurrentTransforms</code> is set to <code>0</code> or left unset, Amazon SageMaker checks the optional execution-parameters to determine the settings for your chosen algorithm. If the execution-parameters endpoint is not enabled, the default value is <code>1</code>. For more information on execution-parameters, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-batch-code.html#your-algorithms-batch-code-how-containe-serves-requests">How Containers Serve Requests</a>. For built-in algorithms, you don\'t need to set a value for <code>MaxConcurrentTransforms</code>.</p>', 'DescribeTransformJobResponse$MaxConcurrentTransforms' => '<p>The maximum number of parallel requests on each instance node that can be launched in a transform job. The default value is 1.</p>', 'TransformJob$MaxConcurrentTransforms' => '<p>The maximum number of parallel requests that can be sent to each instance in a transform job. If <code>MaxConcurrentTransforms</code> is set to 0 or left unset, SageMaker checks the optional execution-parameters to determine the settings for your chosen algorithm. If the execution-parameters endpoint is not enabled, the default value is 1. For built-in algorithms, you don\'t need to set a value for <code>MaxConcurrentTransforms</code>.</p>', 'TransformJobDefinition$MaxConcurrentTransforms' => '<p>The maximum number of parallel requests that can be sent to each instance in a transform job. The default value is 1.</p>', ], ], 'MaxHumanLabeledObjectCount' => [ 'base' => NULL, 'refs' => [ 'LabelingJobStoppingConditions$MaxHumanLabeledObjectCount' => '<p>The maximum number of objects that can be labeled by human workers.</p>', ], ], 'MaxNumberOfTrainingJobs' => [ 'base' => NULL, 'refs' => [ 'ResourceLimits$MaxNumberOfTrainingJobs' => '<p>The maximum number of training jobs that a hyperparameter tuning job can launch.</p>', ], ], 'MaxParallelTrainingJobs' => [ 'base' => NULL, 'refs' => [ 'ResourceLimits$MaxParallelTrainingJobs' => '<p>The maximum number of concurrent training jobs that a hyperparameter tuning job can launch.</p>', ], ], 'MaxPayloadInMB' => [ 'base' => NULL, 'refs' => [ 'CreateTransformJobRequest$MaxPayloadInMB' => '<p>The maximum allowed size of the payload, in MB. A <i>payload</i> is the data portion of a record (without metadata). The value in <code>MaxPayloadInMB</code> must be greater than, or equal to, the size of a single record. To estimate the size of a record in MB, divide the size of your dataset by the number of records. To ensure that the records fit within the maximum payload size, we recommend using a slightly larger value. The default value is <code>6</code> MB. </p> <p>For cases where the payload might be arbitrarily large and is transmitted using HTTP chunked encoding, set the value to <code>0</code>. This feature works only in supported algorithms. Currently, Amazon SageMaker built-in algorithms do not support HTTP chunked encoding.</p>', 'DescribeTransformJobResponse$MaxPayloadInMB' => '<p>The maximum payload size, in MB, used in the transform job.</p>', 'TransformJob$MaxPayloadInMB' => '<p>The maximum allowed size of the payload, in MB. A payload is the data portion of a record (without metadata). The value in <code>MaxPayloadInMB</code> must be greater than, or equal to, the size of a single record. To estimate the size of a record in MB, divide the size of your dataset by the number of records. To ensure that the records fit within the maximum payload size, we recommend using a slightly larger value. The default value is 6 MB. For cases where the payload might be arbitrarily large and is transmitted using HTTP chunked encoding, set the value to 0. This feature works only in supported algorithms. Currently, SageMaker built-in algorithms do not support HTTP chunked encoding.</p>', 'TransformJobDefinition$MaxPayloadInMB' => '<p>The maximum payload size allowed, in MB. A payload is the data portion of a record (without metadata).</p>', ], ], 'MaxPercentageOfInputDatasetLabeled' => [ 'base' => NULL, 'refs' => [ 'LabelingJobStoppingConditions$MaxPercentageOfInputDatasetLabeled' => '<p>The maximum number of input data objects that should be labeled.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAlgorithmsInput$MaxResults' => '<p>The maximum number of algorithms to return in the response.</p>', 'ListAppsRequest$MaxResults' => '<p>Returns a list up to a specified limit.</p>', 'ListCodeRepositoriesInput$MaxResults' => '<p>The maximum number of Git repositories to return in the response.</p>', 'ListCompilationJobsRequest$MaxResults' => '<p>The maximum number of model compilation jobs to return in the response.</p>', 'ListDomainsRequest$MaxResults' => '<p>Returns a list up to a specified limit.</p>', 'ListEndpointConfigsInput$MaxResults' => '<p>The maximum number of training jobs to return in the response.</p>', 'ListEndpointsInput$MaxResults' => '<p>The maximum number of endpoints to return in the response.</p>', 'ListExperimentsRequest$MaxResults' => '<p>The maximum number of experiments to return in the response. The default value is 10.</p>', 'ListFlowDefinitionsRequest$MaxResults' => '<p>The total number of items to return. If the total number of available items is more than the value specified in <code>MaxResults</code>, then a <code>NextToken</code> will be provided in the output that you can use to resume pagination.</p>', 'ListHumanTaskUisRequest$MaxResults' => '<p>The total number of items to return. If the total number of available items is more than the value specified in <code>MaxResults</code>, then a <code>NextToken</code> will be provided in the output that you can use to resume pagination.</p>', 'ListHyperParameterTuningJobsRequest$MaxResults' => '<p>The maximum number of tuning jobs to return. The default value is 10.</p>', 'ListLabelingJobsForWorkteamRequest$MaxResults' => '<p>The maximum number of labeling jobs to return in each page of the response.</p>', 'ListLabelingJobsRequest$MaxResults' => '<p>The maximum number of labeling jobs to return in each page of the response.</p>', 'ListModelPackagesInput$MaxResults' => '<p>The maximum number of model packages to return in the response.</p>', 'ListModelsInput$MaxResults' => '<p>The maximum number of models to return in the response.</p>', 'ListMonitoringExecutionsRequest$MaxResults' => '<p>The maximum number of jobs to return in the response. The default value is 10.</p>', 'ListMonitoringSchedulesRequest$MaxResults' => '<p>The maximum number of jobs to return in the response. The default value is 10.</p>', 'ListNotebookInstanceLifecycleConfigsInput$MaxResults' => '<p>The maximum number of lifecycle configurations to return in the response.</p>', 'ListNotebookInstancesInput$MaxResults' => '<p>The maximum number of notebook instances to return.</p>', 'ListProcessingJobsRequest$MaxResults' => '<p>The maximum number of processing jobs to return in the response.</p>', 'ListSubscribedWorkteamsRequest$MaxResults' => '<p>The maximum number of work teams to return in each page of the response.</p>', 'ListTrainingJobsForHyperParameterTuningJobRequest$MaxResults' => '<p>The maximum number of training jobs to return. The default value is 10.</p>', 'ListTrainingJobsRequest$MaxResults' => '<p>The maximum number of training jobs to return in the response.</p>', 'ListTransformJobsRequest$MaxResults' => '<p>The maximum number of transform jobs to return in the response. The default value is <code>10</code>.</p>', 'ListTrialComponentsRequest$MaxResults' => '<p>The maximum number of components to return in the response. The default value is 10.</p>', 'ListTrialsRequest$MaxResults' => '<p>The maximum number of trials to return in the response. The default value is 10.</p>', 'ListUserProfilesRequest$MaxResults' => '<p>Returns a list up to a specified limit.</p>', 'ListWorkforcesRequest$MaxResults' => '<p>The maximum number of workforces returned in the response.</p>', 'ListWorkteamsRequest$MaxResults' => '<p>The maximum number of work teams to return in each page of the response.</p>', 'SearchRequest$MaxResults' => '<p>The maximum number of results to return.</p>', ], ], 'MaxRuntimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'StoppingCondition$MaxRuntimeInSeconds' => '<p>The maximum length of time, in seconds, that the training or compilation job can run. If job does not complete during this time, Amazon SageMaker ends the job. If value is not specified, default value is 1 day. The maximum value is 28 days.</p>', ], ], 'MaxRuntimePerTrainingJobInSeconds' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobCompletionCriteria$MaxRuntimePerTrainingJobInSeconds' => '<p>The maximum time, in seconds, a job is allowed to run.</p>', ], ], 'MaxWaitTimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'StoppingCondition$MaxWaitTimeInSeconds' => '<p>The maximum length of time, in seconds, how long you are willing to wait for a managed spot training job to complete. It is the amount of time spent waiting for Spot capacity plus the amount of time the training job runs. It must be equal to or greater than <code>MaxRuntimeInSeconds</code>. </p>', ], ], 'MediaType' => [ 'base' => NULL, 'refs' => [ 'TrialComponentArtifact$MediaType' => '<p>The media type of the artifact, which indicates the type of data in the artifact file. The media type consists of a <i>type</i> and a <i>subtype</i> concatenated with a slash (/) character, for example, text/csv, image/jpeg, and s3/uri. The type specifies the category of the media. The subtype specifies the kind of data.</p>', ], ], 'MemberDefinition' => [ 'base' => '<p>Defines the Amazon Cognito user group that is part of a work team.</p>', 'refs' => [ 'MemberDefinitions$member' => NULL, ], ], 'MemberDefinitions' => [ 'base' => NULL, 'refs' => [ 'CreateWorkteamRequest$MemberDefinitions' => '<p>A list of <code>MemberDefinition</code> objects that contains objects that identify the Amazon Cognito user pool that makes up the work team. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">Amazon Cognito User Pools</a>.</p> <p>All of the <code>CognitoMemberDefinition</code> objects that make up the member definition must have the same <code>ClientId</code> and <code>UserPool</code> values.</p>', 'UpdateWorkteamRequest$MemberDefinitions' => '<p>A list of <code>MemberDefinition</code> objects that contain the updated work team members.</p>', 'Workteam$MemberDefinitions' => '<p>The Amazon Cognito user groups that make up the work team.</p>', ], ], 'MetricData' => [ 'base' => '<p>The name, value, and date and time of a metric that was emitted to Amazon CloudWatch.</p>', 'refs' => [ 'FinalMetricDataList$member' => NULL, ], ], 'MetricDefinition' => [ 'base' => '<p>Specifies a metric that the training algorithm writes to <code>stderr</code> or <code>stdout</code> . Amazon SageMakerhyperparameter tuning captures all defined metrics. You specify one metric that a hyperparameter tuning job uses as its objective metric to choose the best training job.</p>', 'refs' => [ 'MetricDefinitionList$member' => NULL, ], ], 'MetricDefinitionList' => [ 'base' => NULL, 'refs' => [ 'AlgorithmSpecification$MetricDefinitions' => '<p>A list of metric definition objects. Each object specifies the metric name and regular expressions used to parse algorithm logs. Amazon SageMaker publishes each metric to Amazon CloudWatch.</p>', 'HyperParameterAlgorithmSpecification$MetricDefinitions' => '<p>An array of <a>MetricDefinition</a> objects that specify the metrics that the algorithm emits.</p>', 'TrainingSpecification$MetricDefinitions' => '<p>A list of <code>MetricDefinition</code> objects, which are used for parsing metrics generated by the algorithm.</p>', ], ], 'MetricName' => [ 'base' => NULL, 'refs' => [ 'FinalHyperParameterTuningJobObjectiveMetric$MetricName' => '<p>The name of the objective metric.</p>', 'HyperParameterTuningJobObjective$MetricName' => '<p>The name of the metric to use for the objective metric.</p>', 'MetricData$MetricName' => '<p>The name of the metric.</p>', 'MetricDefinition$Name' => '<p>The name of the metric.</p>', 'TrialComponentMetricSummary$MetricName' => '<p>The name of the metric.</p>', ], ], 'MetricRegex' => [ 'base' => NULL, 'refs' => [ 'MetricDefinition$Regex' => '<p>A regular expression that searches the output of a training job and gets the value of the metric. For more information about using regular expressions to define metrics, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics.html">Defining Objective Metrics</a>.</p>', ], ], 'MetricValue' => [ 'base' => NULL, 'refs' => [ 'FinalAutoMLJobObjectiveMetric$Value' => '<p>The value of the metric.</p>', 'FinalHyperParameterTuningJobObjectiveMetric$Value' => '<p>The value of the objective metric.</p>', ], ], 'ModelArn' => [ 'base' => NULL, 'refs' => [ 'CreateModelOutput$ModelArn' => '<p>The ARN of the model created in Amazon SageMaker.</p>', 'DescribeModelOutput$ModelArn' => '<p>The Amazon Resource Name (ARN) of the model.</p>', 'LabelingJobAlgorithmsConfig$InitialActiveLearningModelArn' => '<p>At the end of an auto-label job Amazon SageMaker Ground Truth sends the Amazon Resource Nam (ARN) of the final model used for auto-labeling. You can use this model as the starting point for subsequent similar jobs by providing the ARN of the model here. </p>', 'LabelingJobOutput$FinalActiveLearningModelArn' => '<p>The Amazon Resource Name (ARN) for the most recent Amazon SageMaker model trained as part of automated data labeling. </p>', 'ModelSummary$ModelArn' => '<p>The Amazon Resource Name (ARN) of the model.</p>', ], ], 'ModelArtifacts' => [ 'base' => '<p>Provides information about the location that is configured for storing model artifacts. </p> <p>Model artifacts are the output that results from training a model, and typically consist of trained parameters, a model defintion that desribes how to compute inferences, and other metadata.</p>', 'refs' => [ 'DescribeCompilationJobResponse$ModelArtifacts' => '<p>Information about the location in Amazon S3 that has been configured for storing the model artifacts used in the compilation job.</p>', 'DescribeTrainingJobResponse$ModelArtifacts' => '<p>Information about the Amazon S3 location that is configured for storing model artifacts. </p>', 'TrainingJob$ModelArtifacts' => '<p>Information about the Amazon S3 location that is configured for storing model artifacts.</p>', ], ], 'ModelClientConfig' => [ 'base' => '<p>Configures the timeout and maximum number of retries for processing a transform job invocation.</p>', 'refs' => [ 'CreateTransformJobRequest$ModelClientConfig' => '<p>Configures the timeout and maximum number of retries for processing a transform job invocation.</p>', 'DescribeTransformJobResponse$ModelClientConfig' => '<p>The timeout and maximum number of retries for processing a transform job invocation.</p>', 'TransformJob$ModelClientConfig' => NULL, ], ], 'ModelName' => [ 'base' => NULL, 'refs' => [ 'CreateModelInput$ModelName' => '<p>The name of the new model.</p>', 'CreateTransformJobRequest$ModelName' => '<p>The name of the model that you want to use for the transform job. <code>ModelName</code> must be the name of an existing Amazon SageMaker model within an AWS Region in an AWS account.</p>', 'DeleteModelInput$ModelName' => '<p>The name of the model to delete.</p>', 'DescribeModelInput$ModelName' => '<p>The name of the model.</p>', 'DescribeModelOutput$ModelName' => '<p>Name of the Amazon SageMaker model.</p>', 'DescribeTransformJobResponse$ModelName' => '<p>The name of the model used in the transform job.</p>', 'ModelSummary$ModelName' => '<p>The name of the model that you want a summary for.</p>', 'ProductionVariant$ModelName' => '<p>The name of the model that you want to host. This is the name that you specified when creating the model.</p>', 'TransformJob$ModelName' => '<p>The name of the model associated with the transform job.</p>', ], ], 'ModelNameContains' => [ 'base' => NULL, 'refs' => [ 'ListModelsInput$NameContains' => '<p>A string in the training job name. This filter returns only models in the training job whose name contains the specified string.</p>', ], ], 'ModelPackageArn' => [ 'base' => NULL, 'refs' => [ 'CreateModelPackageOutput$ModelPackageArn' => '<p>The Amazon Resource Name (ARN) of the new model package.</p>', 'DescribeModelPackageOutput$ModelPackageArn' => '<p>The Amazon Resource Name (ARN) of the model package.</p>', 'ModelPackageSummary$ModelPackageArn' => '<p>The Amazon Resource Name (ARN) of the model package.</p>', ], ], 'ModelPackageContainerDefinition' => [ 'base' => '<p>Describes the Docker container for the model package.</p>', 'refs' => [ 'ModelPackageContainerDefinitionList$member' => NULL, ], ], 'ModelPackageContainerDefinitionList' => [ 'base' => NULL, 'refs' => [ 'InferenceSpecification$Containers' => '<p>The Amazon ECR registry path of the Docker image that contains the inference code.</p>', ], ], 'ModelPackageSortBy' => [ 'base' => NULL, 'refs' => [ 'ListModelPackagesInput$SortBy' => '<p>The parameter by which to sort the results. The default is <code>CreationTime</code>.</p>', ], ], 'ModelPackageStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeModelPackageOutput$ModelPackageStatus' => '<p>The current status of the model package.</p>', 'ModelPackageSummary$ModelPackageStatus' => '<p>The overall status of the model package.</p>', ], ], 'ModelPackageStatusDetails' => [ 'base' => '<p>Specifies the validation and image scan statuses of the model package.</p>', 'refs' => [ 'DescribeModelPackageOutput$ModelPackageStatusDetails' => '<p>Details about the current status of the model package.</p>', ], ], 'ModelPackageStatusItem' => [ 'base' => '<p>Represents the overall status of a model package.</p>', 'refs' => [ 'ModelPackageStatusItemList$member' => NULL, ], ], 'ModelPackageStatusItemList' => [ 'base' => NULL, 'refs' => [ 'ModelPackageStatusDetails$ValidationStatuses' => '<p>The validation status of the model package.</p>', 'ModelPackageStatusDetails$ImageScanStatuses' => '<p>The status of the scan of the Docker image container for the model package.</p>', ], ], 'ModelPackageSummary' => [ 'base' => '<p>Provides summary information about a model package.</p>', 'refs' => [ 'ModelPackageSummaryList$member' => NULL, ], ], 'ModelPackageSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListModelPackagesOutput$ModelPackageSummaryList' => '<p>An array of <code>ModelPackageSummary</code> objects, each of which lists a model package.</p>', ], ], 'ModelPackageValidationProfile' => [ 'base' => '<p>Contains data, such as the inputs and targeted instance types that are used in the process of validating the model package.</p> <p>The data provided in the validation profile is made available to your buyers on AWS Marketplace.</p>', 'refs' => [ 'ModelPackageValidationProfiles$member' => NULL, ], ], 'ModelPackageValidationProfiles' => [ 'base' => NULL, 'refs' => [ 'ModelPackageValidationSpecification$ValidationProfiles' => '<p>An array of <code>ModelPackageValidationProfile</code> objects, each of which specifies a batch transform job that Amazon SageMaker runs to validate your model package.</p>', ], ], 'ModelPackageValidationSpecification' => [ 'base' => '<p>Specifies batch transform jobs that Amazon SageMaker runs to validate your model package.</p>', 'refs' => [ 'CreateModelPackageInput$ValidationSpecification' => '<p>Specifies configurations for one or more transform jobs that Amazon SageMaker runs to test the model package.</p>', 'DescribeModelPackageOutput$ValidationSpecification' => '<p>Configurations for one or more transform jobs that Amazon SageMaker runs to test the model package.</p>', ], ], 'ModelSortKey' => [ 'base' => NULL, 'refs' => [ 'ListModelsInput$SortBy' => '<p>Sorts the list of results. The default is <code>CreationTime</code>.</p>', ], ], 'ModelSummary' => [ 'base' => '<p>Provides summary information about a model.</p>', 'refs' => [ 'ModelSummaryList$member' => NULL, ], ], 'ModelSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListModelsOutput$Models' => '<p>An array of <code>ModelSummary</code> objects, each of which lists a model.</p>', ], ], 'MonitoringAppSpecification' => [ 'base' => '<p>Container image configuration object for the monitoring job.</p>', 'refs' => [ 'MonitoringJobDefinition$MonitoringAppSpecification' => '<p>Configures the monitoring job to run a specified Docker container image.</p>', ], ], 'MonitoringBaselineConfig' => [ 'base' => '<p>Configuration for monitoring constraints and monitoring statistics. These baseline resources are compared against the results of the current job from the series of jobs scheduled to collect data periodically.</p>', 'refs' => [ 'MonitoringJobDefinition$BaselineConfig' => '<p>Baseline configuration used to validate that the data conforms to the specified constraints and statistics</p>', ], ], 'MonitoringClusterConfig' => [ 'base' => '<p>Configuration for the cluster used to run model monitoring jobs.</p>', 'refs' => [ 'MonitoringResources$ClusterConfig' => '<p>The configuration for the cluster resources used to run the processing job.</p>', ], ], 'MonitoringConstraintsResource' => [ 'base' => '<p>The constraints resource for a monitoring job.</p>', 'refs' => [ 'MonitoringBaselineConfig$ConstraintsResource' => '<p>The baseline constraint file in Amazon S3 that the current monitoring job should validated against.</p>', ], ], 'MonitoringContainerArguments' => [ 'base' => NULL, 'refs' => [ 'MonitoringAppSpecification$ContainerArguments' => '<p>An array of arguments for the container used to run the monitoring job.</p>', ], ], 'MonitoringEnvironmentMap' => [ 'base' => NULL, 'refs' => [ 'MonitoringJobDefinition$Environment' => '<p>Sets the environment variables in the Docker container.</p>', ], ], 'MonitoringExecutionSortKey' => [ 'base' => NULL, 'refs' => [ 'ListMonitoringExecutionsRequest$SortBy' => '<p>Whether to sort results by <code>Status</code>, <code>CreationTime</code>, <code>ScheduledTime</code> field. The default is <code>CreationTime</code>.</p>', ], ], 'MonitoringExecutionSummary' => [ 'base' => '<p>Summary of information about the last monitoring job to run.</p>', 'refs' => [ 'DescribeMonitoringScheduleResponse$LastMonitoringExecutionSummary' => '<p>Describes metadata on the last execution to run, if there was one.</p>', 'MonitoringExecutionSummaryList$member' => NULL, ], ], 'MonitoringExecutionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListMonitoringExecutionsResponse$MonitoringExecutionSummaries' => '<p>A JSON array in which each element is a summary for a monitoring execution.</p>', ], ], 'MonitoringInput' => [ 'base' => '<p>The inputs for a monitoring job.</p>', 'refs' => [ 'MonitoringInputs$member' => NULL, ], ], 'MonitoringInputs' => [ 'base' => NULL, 'refs' => [ 'MonitoringJobDefinition$MonitoringInputs' => '<p>The array of inputs for the monitoring job. Currently we support monitoring an Amazon SageMaker Endpoint.</p>', ], ], 'MonitoringJobDefinition' => [ 'base' => '<p>Defines the monitoring job.</p>', 'refs' => [ 'MonitoringScheduleConfig$MonitoringJobDefinition' => '<p>Defines the monitoring job.</p>', ], ], 'MonitoringMaxRuntimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'MonitoringStoppingCondition$MaxRuntimeInSeconds' => '<p>The maximum runtime allowed in seconds.</p>', ], ], 'MonitoringOutput' => [ 'base' => '<p>The output object for a monitoring job.</p>', 'refs' => [ 'MonitoringOutputs$member' => NULL, ], ], 'MonitoringOutputConfig' => [ 'base' => '<p>The output configuration for monitoring jobs.</p>', 'refs' => [ 'MonitoringJobDefinition$MonitoringOutputConfig' => '<p>The array of outputs from the monitoring job to be uploaded to Amazon Simple Storage Service (Amazon S3).</p>', ], ], 'MonitoringOutputs' => [ 'base' => NULL, 'refs' => [ 'MonitoringOutputConfig$MonitoringOutputs' => '<p>Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.</p>', ], ], 'MonitoringResources' => [ 'base' => '<p>Identifies the resources to deploy for a monitoring job.</p>', 'refs' => [ 'MonitoringJobDefinition$MonitoringResources' => '<p>Identifies the resources, ML compute instances, and ML storage volumes to deploy for a monitoring job. In distributed processing, you specify more than one instance.</p>', ], ], 'MonitoringS3Output' => [ 'base' => '<p>Information about where and how you want to store the results of a monitoring job.</p>', 'refs' => [ 'MonitoringOutput$S3Output' => '<p>The Amazon S3 storage location where the results of a monitoring job are saved.</p>', ], ], 'MonitoringS3Uri' => [ 'base' => NULL, 'refs' => [ 'MonitoringS3Output$S3Uri' => '<p>A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.</p>', ], ], 'MonitoringScheduleArn' => [ 'base' => NULL, 'refs' => [ 'CreateMonitoringScheduleResponse$MonitoringScheduleArn' => '<p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>', 'DescribeMonitoringScheduleResponse$MonitoringScheduleArn' => '<p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>', 'DescribeProcessingJobResponse$MonitoringScheduleArn' => '<p>The ARN of a monitoring schedule for an endpoint associated with this processing job.</p>', 'MonitoringScheduleSummary$MonitoringScheduleArn' => '<p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>', 'ProcessingJob$MonitoringScheduleArn' => '<p>The ARN of a monitoring schedule for an endpoint associated with this processing job.</p>', 'UpdateMonitoringScheduleResponse$MonitoringScheduleArn' => '<p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>', ], ], 'MonitoringScheduleConfig' => [ 'base' => '<p>Configures the monitoring schedule and defines the monitoring job.</p>', 'refs' => [ 'CreateMonitoringScheduleRequest$MonitoringScheduleConfig' => '<p>The configuration object that specifies the monitoring schedule and defines the monitoring job.</p>', 'DescribeMonitoringScheduleResponse$MonitoringScheduleConfig' => '<p>The configuration object that specifies the monitoring schedule and defines the monitoring job.</p>', 'UpdateMonitoringScheduleRequest$MonitoringScheduleConfig' => '<p>The configuration object that specifies the monitoring schedule and defines the monitoring job.</p>', ], ], 'MonitoringScheduleName' => [ 'base' => NULL, 'refs' => [ 'CreateMonitoringScheduleRequest$MonitoringScheduleName' => '<p>The name of the monitoring schedule. The name must be unique within an AWS Region within an AWS account.</p>', 'DeleteMonitoringScheduleRequest$MonitoringScheduleName' => '<p>The name of the monitoring schedule to delete.</p>', 'DescribeMonitoringScheduleRequest$MonitoringScheduleName' => '<p>Name of a previously created monitoring schedule.</p>', 'DescribeMonitoringScheduleResponse$MonitoringScheduleName' => '<p>Name of the monitoring schedule.</p>', 'ListMonitoringExecutionsRequest$MonitoringScheduleName' => '<p>Name of a specific schedule to fetch jobs for.</p>', 'MonitoringExecutionSummary$MonitoringScheduleName' => '<p>The name of the monitoring schedule.</p>', 'MonitoringScheduleSummary$MonitoringScheduleName' => '<p>The name of the monitoring schedule.</p>', 'StartMonitoringScheduleRequest$MonitoringScheduleName' => '<p>The name of the schedule to start.</p>', 'StopMonitoringScheduleRequest$MonitoringScheduleName' => '<p>The name of the schedule to stop.</p>', 'UpdateMonitoringScheduleRequest$MonitoringScheduleName' => '<p>The name of the monitoring schedule. The name must be unique within an AWS Region within an AWS account.</p>', ], ], 'MonitoringScheduleSortKey' => [ 'base' => NULL, 'refs' => [ 'ListMonitoringSchedulesRequest$SortBy' => '<p>Whether to sort results by <code>Status</code>, <code>CreationTime</code>, <code>ScheduledTime</code> field. The default is <code>CreationTime</code>.</p>', ], ], 'MonitoringScheduleSummary' => [ 'base' => '<p>Summarizes the monitoring schedule.</p>', 'refs' => [ 'MonitoringScheduleSummaryList$member' => NULL, ], ], 'MonitoringScheduleSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListMonitoringSchedulesResponse$MonitoringScheduleSummaries' => '<p>A JSON array in which each element is a summary for a monitoring schedule.</p>', ], ], 'MonitoringStatisticsResource' => [ 'base' => '<p>The statistics resource for a monitoring job.</p>', 'refs' => [ 'MonitoringBaselineConfig$StatisticsResource' => '<p>The baseline statistics file in Amazon S3 that the current monitoring job should be validated against.</p>', ], ], 'MonitoringStoppingCondition' => [ 'base' => '<p>A time limit for how long the monitoring job is allowed to run before stopping.</p>', 'refs' => [ 'MonitoringJobDefinition$StoppingCondition' => '<p>Specifies a time limit for how long the monitoring job is allowed to run.</p>', ], ], 'NameContains' => [ 'base' => NULL, 'refs' => [ 'ListAlgorithmsInput$NameContains' => '<p>A string in the algorithm name. This filter returns only algorithms whose name contains the specified string.</p>', 'ListCompilationJobsRequest$NameContains' => '<p>A filter that returns the model compilation jobs whose name contains a specified string.</p>', 'ListHyperParameterTuningJobsRequest$NameContains' => '<p>A string in the tuning job name. This filter returns only tuning jobs whose name contains the specified string.</p>', 'ListLabelingJobsRequest$NameContains' => '<p>A string in the labeling job name. This filter returns only labeling jobs whose name contains the specified string.</p>', 'ListModelPackagesInput$NameContains' => '<p>A string in the model package name. This filter returns only model packages whose name contains the specified string.</p>', 'ListMonitoringSchedulesRequest$NameContains' => '<p>Filter for monitoring schedules whose name contains a specified string.</p>', 'ListTrainingJobsRequest$NameContains' => '<p>A string in the training job name. This filter returns only training jobs whose name contains the specified string.</p>', 'ListTransformJobsRequest$NameContains' => '<p>A string in the transform job name. This filter returns only transform jobs whose name contains the specified string.</p>', ], ], 'NestedFilters' => [ 'base' => '<p>A list of nested <a>Filter</a> objects. A resource must satisfy the conditions of all filters to be included in the results returned from the <a>Search</a> API.</p> <p>For example, to filter on a training job\'s <code>InputDataConfig</code> property with a specific channel name and <code>S3Uri</code> prefix, define the following filters:</p> <ul> <li> <p> <code>\'{Name:"InputDataConfig.ChannelName", "Operator":"Equals", "Value":"train"}\',</code> </p> </li> <li> <p> <code>\'{Name:"InputDataConfig.DataSource.S3DataSource.S3Uri", "Operator":"Contains", "Value":"mybucket/catdata"}\'</code> </p> </li> </ul>', 'refs' => [ 'NestedFiltersList$member' => NULL, ], ], 'NestedFiltersList' => [ 'base' => NULL, 'refs' => [ 'SearchExpression$NestedFilters' => '<p>A list of nested filter objects.</p>', ], ], 'NetworkConfig' => [ 'base' => '<p>Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.</p>', 'refs' => [ 'CreateProcessingJobRequest$NetworkConfig' => '<p>Networking options for a processing job.</p>', 'DescribeProcessingJobResponse$NetworkConfig' => '<p>Networking options for a processing job.</p>', 'MonitoringJobDefinition$NetworkConfig' => '<p>Specifies networking options for an monitoring job.</p>', 'ProcessingJob$NetworkConfig' => NULL, ], ], 'NetworkInterfaceId' => [ 'base' => NULL, 'refs' => [ 'DescribeNotebookInstanceOutput$NetworkInterfaceId' => '<p>The network interface IDs that Amazon SageMaker created at the time of creating the instance. </p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListAlgorithmsInput$NextToken' => '<p>If the response to a previous <code>ListAlgorithms</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of algorithms, use the token in the next request.</p>', 'ListAlgorithmsOutput$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of algorithms, use it in the subsequent request.</p>', 'ListAppsRequest$NextToken' => '<p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>', 'ListAppsResponse$NextToken' => '<p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>', 'ListAutoMLJobsRequest$NextToken' => '<p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>', 'ListAutoMLJobsResponse$NextToken' => '<p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>', 'ListCandidatesForAutoMLJobRequest$NextToken' => '<p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>', 'ListCandidatesForAutoMLJobResponse$NextToken' => '<p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>', 'ListCodeRepositoriesInput$NextToken' => '<p>If the result of a <code>ListCodeRepositoriesOutput</code> request was truncated, the response includes a <code>NextToken</code>. To get the next set of Git repositories, use the token in the next request.</p>', 'ListCodeRepositoriesOutput$NextToken' => '<p>If the result of a <code>ListCodeRepositoriesOutput</code> request was truncated, the response includes a <code>NextToken</code>. To get the next set of Git repositories, use the token in the next request.</p>', 'ListCompilationJobsRequest$NextToken' => '<p>If the result of the previous <code>ListCompilationJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of model compilation jobs, use the token in the next request.</p>', 'ListCompilationJobsResponse$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this <code>NextToken</code>. To retrieve the next set of model compilation jobs, use this token in the next request.</p>', 'ListDomainsRequest$NextToken' => '<p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>', 'ListDomainsResponse$NextToken' => '<p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>', 'ListExperimentsRequest$NextToken' => '<p>If the previous call to <code>ListExperiments</code> didn\'t return the full set of experiments, the call returns a token for getting the next set of experiments.</p>', 'ListExperimentsResponse$NextToken' => '<p>A token for getting the next set of experiments, if there are any.</p>', 'ListFlowDefinitionsRequest$NextToken' => '<p>A token to resume pagination.</p>', 'ListFlowDefinitionsResponse$NextToken' => '<p>A token to resume pagination.</p>', 'ListHumanTaskUisRequest$NextToken' => '<p>A token to resume pagination.</p>', 'ListHumanTaskUisResponse$NextToken' => '<p>A token to resume pagination.</p>', 'ListHyperParameterTuningJobsRequest$NextToken' => '<p>If the result of the previous <code>ListHyperParameterTuningJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of tuning jobs, use the token in the next request.</p>', 'ListHyperParameterTuningJobsResponse$NextToken' => '<p>If the result of this <code>ListHyperParameterTuningJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of tuning jobs, use the token in the next request.</p>', 'ListLabelingJobsForWorkteamRequest$NextToken' => '<p>If the result of the previous <code>ListLabelingJobsForWorkteam</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of labeling jobs, use the token in the next request.</p>', 'ListLabelingJobsForWorkteamResponse$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of labeling jobs, use it in the subsequent request.</p>', 'ListLabelingJobsRequest$NextToken' => '<p>If the result of the previous <code>ListLabelingJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of labeling jobs, use the token in the next request.</p>', 'ListLabelingJobsResponse$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of labeling jobs, use it in the subsequent request.</p>', 'ListModelPackagesInput$NextToken' => '<p>If the response to a previous <code>ListModelPackages</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of model packages, use the token in the next request.</p>', 'ListModelPackagesOutput$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of model packages, use it in the subsequent request.</p>', 'ListMonitoringExecutionsRequest$NextToken' => '<p>The token returned if the response is truncated. To retrieve the next set of job executions, use it in the next request.</p>', 'ListMonitoringExecutionsResponse$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it in the subsequent reques</p>', 'ListMonitoringSchedulesRequest$NextToken' => '<p>The token returned if the response is truncated. To retrieve the next set of job executions, use it in the next request.</p>', 'ListMonitoringSchedulesResponse$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it in the subsequent reques</p>', 'ListNotebookInstanceLifecycleConfigsInput$NextToken' => '<p>If the result of a <code>ListNotebookInstanceLifecycleConfigs</code> request was truncated, the response includes a <code>NextToken</code>. To get the next set of lifecycle configurations, use the token in the next request.</p>', 'ListNotebookInstanceLifecycleConfigsOutput$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To get the next set of lifecycle configurations, use it in the next request. </p>', 'ListNotebookInstancesInput$NextToken' => '<p> If the previous call to the <code>ListNotebookInstances</code> is truncated, the response includes a <code>NextToken</code>. You can use this token in your subsequent <code>ListNotebookInstances</code> request to fetch the next set of notebook instances. </p> <note> <p>You might specify a filter or a sort order in your request. When response is truncated, you must use the same values for the filer and sort order in the next request. </p> </note>', 'ListNotebookInstancesOutput$NextToken' => '<p>If the response to the previous <code>ListNotebookInstances</code> request was truncated, Amazon SageMaker returns this token. To retrieve the next set of notebook instances, use the token in the next request.</p>', 'ListProcessingJobsRequest$NextToken' => '<p>If the result of the previous <code>ListProcessingJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of processing jobs, use the token in the next request.</p>', 'ListProcessingJobsResponse$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of processing jobs, use it in the subsequent request.</p>', 'ListSubscribedWorkteamsRequest$NextToken' => '<p>If the result of the previous <code>ListSubscribedWorkteams</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of labeling jobs, use the token in the next request.</p>', 'ListSubscribedWorkteamsResponse$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of work teams, use it in the subsequent request.</p>', 'ListTagsInput$NextToken' => '<p> If the response to the previous <code>ListTags</code> request is truncated, Amazon SageMaker returns this token. To retrieve the next set of tags, use it in the subsequent request. </p>', 'ListTagsOutput$NextToken' => '<p> If response is truncated, Amazon SageMaker includes a token in the response. You can use this token in your subsequent request to fetch next set of tokens. </p>', 'ListTrainingJobsForHyperParameterTuningJobRequest$NextToken' => '<p>If the result of the previous <code>ListTrainingJobsForHyperParameterTuningJob</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of training jobs, use the token in the next request.</p>', 'ListTrainingJobsForHyperParameterTuningJobResponse$NextToken' => '<p>If the result of this <code>ListTrainingJobsForHyperParameterTuningJob</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of training jobs, use the token in the next request.</p>', 'ListTrainingJobsRequest$NextToken' => '<p>If the result of the previous <code>ListTrainingJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of training jobs, use the token in the next request. </p>', 'ListTrainingJobsResponse$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of training jobs, use it in the subsequent request.</p>', 'ListTransformJobsRequest$NextToken' => '<p>If the result of the previous <code>ListTransformJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of transform jobs, use the token in the next request.</p>', 'ListTransformJobsResponse$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of transform jobs, use it in the next request.</p>', 'ListTrialComponentsRequest$NextToken' => '<p>If the previous call to <code>ListTrialComponents</code> didn\'t return the full set of components, the call returns a token for getting the next set of components.</p>', 'ListTrialComponentsResponse$NextToken' => '<p>A token for getting the next set of components, if there are any.</p>', 'ListTrialsRequest$NextToken' => '<p>If the previous call to <code>ListTrials</code> didn\'t return the full set of trials, the call returns a token for getting the next set of trials.</p>', 'ListTrialsResponse$NextToken' => '<p>A token for getting the next set of trials, if there are any.</p>', 'ListUserProfilesRequest$NextToken' => '<p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>', 'ListUserProfilesResponse$NextToken' => '<p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>', 'ListWorkforcesRequest$NextToken' => '<p>A token to resume pagination.</p>', 'ListWorkforcesResponse$NextToken' => '<p>A token to resume pagination.</p>', 'ListWorkteamsRequest$NextToken' => '<p>If the result of the previous <code>ListWorkteams</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of labeling jobs, use the token in the next request.</p>', 'ListWorkteamsResponse$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of work teams, use it in the subsequent request.</p>', 'SearchRequest$NextToken' => '<p>If more than <code>MaxResults</code> resources match the specified <code>SearchExpression</code>, the response includes a <code>NextToken</code>. The <code>NextToken</code> can be passed to the next <code>SearchRequest</code> to continue retrieving results.</p>', 'SearchResponse$NextToken' => '<p>If the result of the previous <code>Search</code> request was truncated, the response includes a NextToken. To retrieve the next set of results, use the token in the next request.</p>', ], ], 'NotebookInstanceAcceleratorType' => [ 'base' => NULL, 'refs' => [ 'NotebookInstanceAcceleratorTypes$member' => NULL, ], ], 'NotebookInstanceAcceleratorTypes' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceInput$AcceleratorTypes' => '<p>A list of Elastic Inference (EI) instance types to associate with this notebook instance. Currently, only one instance type can be associated with a notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.</p>', 'DescribeNotebookInstanceOutput$AcceleratorTypes' => '<p>A list of the Elastic Inference (EI) instance types associated with this notebook instance. Currently only one EI instance type can be associated with a notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.</p>', 'UpdateNotebookInstanceInput$AcceleratorTypes' => '<p>A list of the Elastic Inference (EI) instance types to associate with this notebook instance. Currently only one EI instance type can be associated with a notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.</p>', ], ], 'NotebookInstanceArn' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceOutput$NotebookInstanceArn' => '<p>The Amazon Resource Name (ARN) of the notebook instance. </p>', 'DescribeNotebookInstanceOutput$NotebookInstanceArn' => '<p>The Amazon Resource Name (ARN) of the notebook instance.</p>', 'NotebookInstanceSummary$NotebookInstanceArn' => '<p>The Amazon Resource Name (ARN) of the notebook instance.</p>', ], ], 'NotebookInstanceLifecycleConfigArn' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceLifecycleConfigOutput$NotebookInstanceLifecycleConfigArn' => '<p>The Amazon Resource Name (ARN) of the lifecycle configuration.</p>', 'DescribeNotebookInstanceLifecycleConfigOutput$NotebookInstanceLifecycleConfigArn' => '<p>The Amazon Resource Name (ARN) of the lifecycle configuration.</p>', 'NotebookInstanceLifecycleConfigSummary$NotebookInstanceLifecycleConfigArn' => '<p>The Amazon Resource Name (ARN) of the lifecycle configuration.</p>', ], ], 'NotebookInstanceLifecycleConfigContent' => [ 'base' => NULL, 'refs' => [ 'NotebookInstanceLifecycleHook$Content' => '<p>A base64-encoded string that contains a shell script for a notebook instance lifecycle configuration.</p>', ], ], 'NotebookInstanceLifecycleConfigList' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceLifecycleConfigInput$OnCreate' => '<p>A shell script that runs only once, when you create a notebook instance. The shell script must be a base64-encoded string.</p>', 'CreateNotebookInstanceLifecycleConfigInput$OnStart' => '<p>A shell script that runs every time you start a notebook instance, including when you create the notebook instance. The shell script must be a base64-encoded string.</p>', 'DescribeNotebookInstanceLifecycleConfigOutput$OnCreate' => '<p>The shell script that runs only once, when you create a notebook instance.</p>', 'DescribeNotebookInstanceLifecycleConfigOutput$OnStart' => '<p>The shell script that runs every time you start a notebook instance, including when you create the notebook instance.</p>', 'UpdateNotebookInstanceLifecycleConfigInput$OnCreate' => '<p>The shell script that runs only once, when you create a notebook instance. The shell script must be a base64-encoded string.</p>', 'UpdateNotebookInstanceLifecycleConfigInput$OnStart' => '<p>The shell script that runs every time you start a notebook instance, including when you create the notebook instance. The shell script must be a base64-encoded string.</p>', ], ], 'NotebookInstanceLifecycleConfigName' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceInput$LifecycleConfigName' => '<p>The name of a lifecycle configuration to associate with the notebook instance. For information about lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a>.</p>', 'CreateNotebookInstanceLifecycleConfigInput$NotebookInstanceLifecycleConfigName' => '<p>The name of the lifecycle configuration.</p>', 'DeleteNotebookInstanceLifecycleConfigInput$NotebookInstanceLifecycleConfigName' => '<p>The name of the lifecycle configuration to delete.</p>', 'DescribeNotebookInstanceLifecycleConfigInput$NotebookInstanceLifecycleConfigName' => '<p>The name of the lifecycle configuration to describe.</p>', 'DescribeNotebookInstanceLifecycleConfigOutput$NotebookInstanceLifecycleConfigName' => '<p>The name of the lifecycle configuration.</p>', 'DescribeNotebookInstanceOutput$NotebookInstanceLifecycleConfigName' => '<p>Returns the name of a notebook instance lifecycle configuration.</p> <p>For information about notebook instance lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a> </p>', 'ListNotebookInstancesInput$NotebookInstanceLifecycleConfigNameContains' => '<p>A string in the name of a notebook instances lifecycle configuration associated with this notebook instance. This filter returns only notebook instances associated with a lifecycle configuration with a name that contains the specified string.</p>', 'NotebookInstanceLifecycleConfigSummary$NotebookInstanceLifecycleConfigName' => '<p>The name of the lifecycle configuration.</p>', 'NotebookInstanceSummary$NotebookInstanceLifecycleConfigName' => '<p>The name of a notebook instance lifecycle configuration associated with this notebook instance.</p> <p>For information about notebook instance lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a>.</p>', 'UpdateNotebookInstanceInput$LifecycleConfigName' => '<p>The name of a lifecycle configuration to associate with the notebook instance. For information about lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a>.</p>', 'UpdateNotebookInstanceLifecycleConfigInput$NotebookInstanceLifecycleConfigName' => '<p>The name of the lifecycle configuration.</p>', ], ], 'NotebookInstanceLifecycleConfigNameContains' => [ 'base' => NULL, 'refs' => [ 'ListNotebookInstanceLifecycleConfigsInput$NameContains' => '<p>A string in the lifecycle configuration name. This filter returns only lifecycle configurations whose name contains the specified string.</p>', ], ], 'NotebookInstanceLifecycleConfigSortKey' => [ 'base' => NULL, 'refs' => [ 'ListNotebookInstanceLifecycleConfigsInput$SortBy' => '<p>Sorts the list of results. The default is <code>CreationTime</code>.</p>', ], ], 'NotebookInstanceLifecycleConfigSortOrder' => [ 'base' => NULL, 'refs' => [ 'ListNotebookInstanceLifecycleConfigsInput$SortOrder' => '<p>The sort order for results.</p>', ], ], 'NotebookInstanceLifecycleConfigSummary' => [ 'base' => '<p>Provides a summary of a notebook instance lifecycle configuration.</p>', 'refs' => [ 'NotebookInstanceLifecycleConfigSummaryList$member' => NULL, ], ], 'NotebookInstanceLifecycleConfigSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListNotebookInstanceLifecycleConfigsOutput$NotebookInstanceLifecycleConfigs' => '<p>An array of <code>NotebookInstanceLifecycleConfiguration</code> objects, each listing a lifecycle configuration.</p>', ], ], 'NotebookInstanceLifecycleHook' => [ 'base' => '<p>Contains the notebook instance lifecycle configuration script.</p> <p>Each lifecycle configuration script has a limit of 16384 characters.</p> <p>The value of the <code>$PATH</code> environment variable that is available to both scripts is <code>/sbin:bin:/usr/sbin:/usr/bin</code>.</p> <p>View CloudWatch Logs for notebook instance lifecycle configurations in log group <code>/aws/sagemaker/NotebookInstances</code> in log stream <code>[notebook-instance-name]/[LifecycleConfigHook]</code>.</p> <p>Lifecycle configuration scripts cannot run for longer than 5 minutes. If a script runs for longer than 5 minutes, it fails and the notebook instance is not created or started.</p> <p>For information about notebook instance lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a>.</p>', 'refs' => [ 'NotebookInstanceLifecycleConfigList$member' => NULL, ], ], 'NotebookInstanceName' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceInput$NotebookInstanceName' => '<p>The name of the new notebook instance.</p>', 'CreatePresignedNotebookInstanceUrlInput$NotebookInstanceName' => '<p>The name of the notebook instance.</p>', 'DeleteNotebookInstanceInput$NotebookInstanceName' => '<p>The name of the Amazon SageMaker notebook instance to delete.</p>', 'DescribeNotebookInstanceInput$NotebookInstanceName' => '<p>The name of the notebook instance that you want information about.</p>', 'DescribeNotebookInstanceOutput$NotebookInstanceName' => '<p>The name of the Amazon SageMaker notebook instance. </p>', 'NotebookInstanceSummary$NotebookInstanceName' => '<p>The name of the notebook instance that you want a summary for.</p>', 'StartNotebookInstanceInput$NotebookInstanceName' => '<p>The name of the notebook instance to start.</p>', 'StopNotebookInstanceInput$NotebookInstanceName' => '<p>The name of the notebook instance to terminate.</p>', 'UpdateNotebookInstanceInput$NotebookInstanceName' => '<p>The name of the notebook instance to update.</p>', ], ], 'NotebookInstanceNameContains' => [ 'base' => NULL, 'refs' => [ 'ListNotebookInstancesInput$NameContains' => '<p>A string in the notebook instances\' name. This filter returns only notebook instances whose name contains the specified string.</p>', ], ], 'NotebookInstanceSortKey' => [ 'base' => NULL, 'refs' => [ 'ListNotebookInstancesInput$SortBy' => '<p>The field to sort results by. The default is <code>Name</code>.</p>', ], ], 'NotebookInstanceSortOrder' => [ 'base' => NULL, 'refs' => [ 'ListNotebookInstancesInput$SortOrder' => '<p>The sort order for results. </p>', ], ], 'NotebookInstanceStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeNotebookInstanceOutput$NotebookInstanceStatus' => '<p>The status of the notebook instance.</p>', 'ListNotebookInstancesInput$StatusEquals' => '<p>A filter that returns only notebook instances with the specified status.</p>', 'NotebookInstanceSummary$NotebookInstanceStatus' => '<p>The status of the notebook instance.</p>', ], ], 'NotebookInstanceSummary' => [ 'base' => '<p>Provides summary information for an Amazon SageMaker notebook instance.</p>', 'refs' => [ 'NotebookInstanceSummaryList$member' => NULL, ], ], 'NotebookInstanceSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListNotebookInstancesOutput$NotebookInstances' => '<p>An array of <code>NotebookInstanceSummary</code> objects, one for each notebook instance.</p>', ], ], 'NotebookInstanceUrl' => [ 'base' => NULL, 'refs' => [ 'CreatePresignedNotebookInstanceUrlOutput$AuthorizedUrl' => '<p>A JSON object that contains the URL string. </p>', 'DescribeNotebookInstanceOutput$Url' => '<p>The URL that you use to connect to the Jupyter notebook that is running in your notebook instance. </p>', 'NotebookInstanceSummary$Url' => '<p>The URL that you use to connect to the Jupyter instance running in your notebook instance. </p>', ], ], 'NotebookInstanceVolumeSizeInGB' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceInput$VolumeSizeInGB' => '<p>The size, in GB, of the ML storage volume to attach to the notebook instance. The default value is 5 GB.</p>', 'DescribeNotebookInstanceOutput$VolumeSizeInGB' => '<p>The size, in GB, of the ML storage volume attached to the notebook instance.</p>', 'UpdateNotebookInstanceInput$VolumeSizeInGB' => '<p>The size, in GB, of the ML storage volume to attach to the notebook instance. The default value is 5 GB. ML storage volumes are encrypted, so Amazon SageMaker can\'t determine the amount of available free space on the volume. Because of this, you can increase the volume size when you update a notebook instance, but you can\'t decrease the volume size. If you want to decrease the size of the ML storage volume in use, create a new notebook instance with the desired size.</p>', ], ], 'NotebookOutputOption' => [ 'base' => NULL, 'refs' => [ 'SharingSettings$NotebookOutputOption' => '<p>Whether to include the notebook cell output when sharing the notebook. The default is <code>Disabled</code>.</p>', ], ], 'NotificationConfiguration' => [ 'base' => '<p>Configures SNS notifications of available or expiring work items for work teams.</p>', 'refs' => [ 'CreateWorkteamRequest$NotificationConfiguration' => '<p>Configures notification of workers regarding available or expiring work items.</p>', 'UpdateWorkteamRequest$NotificationConfiguration' => '<p>Configures SNS topic notifications for available or expiring work items</p>', 'Workteam$NotificationConfiguration' => '<p>Configures SNS notifications of available or expiring work items for work teams.</p>', ], ], 'NotificationTopicArn' => [ 'base' => NULL, 'refs' => [ 'NotificationConfiguration$NotificationTopicArn' => '<p>The ARN for the SNS topic to which notifications should be published.</p>', ], ], 'NumberOfHumanWorkersPerDataObject' => [ 'base' => NULL, 'refs' => [ 'HumanTaskConfig$NumberOfHumanWorkersPerDataObject' => '<p>The number of human workers that will label an object. </p>', 'LabelingJobForWorkteamSummary$NumberOfHumanWorkersPerDataObject' => '<p>The configured number of workers per data object.</p>', ], ], 'ObjectiveStatus' => [ 'base' => NULL, 'refs' => [ 'AutoMLCandidate$ObjectiveStatus' => '<p>The objective status.</p>', 'HyperParameterTrainingJobSummary$ObjectiveStatus' => '<p>The status of the objective metric for the training job:</p> <ul> <li> <p>Succeeded: The final objective metric for the training job was evaluated by the hyperparameter tuning job and used in the hyperparameter tuning process.</p> </li> </ul> <ul> <li> <p>Pending: The training job is in progress and evaluation of its final objective metric is pending.</p> </li> </ul> <ul> <li> <p>Failed: The final objective metric for the training job was not evaluated, and was not used in the hyperparameter tuning process. This typically occurs when the training job failed or did not emit an objective metric.</p> </li> </ul>', ], ], 'ObjectiveStatusCounter' => [ 'base' => NULL, 'refs' => [ 'ObjectiveStatusCounters$Succeeded' => '<p>The number of training jobs whose final objective metric was evaluated by the hyperparameter tuning job and used in the hyperparameter tuning process.</p>', 'ObjectiveStatusCounters$Pending' => '<p>The number of training jobs that are in progress and pending evaluation of their final objective metric.</p>', 'ObjectiveStatusCounters$Failed' => '<p>The number of training jobs whose final objective metric was not evaluated and used in the hyperparameter tuning process. This typically occurs when the training job failed or did not emit an objective metric.</p>', ], ], 'ObjectiveStatusCounters' => [ 'base' => '<p>Specifies the number of training jobs that this hyperparameter tuning job launched, categorized by the status of their objective metric. The objective metric status shows whether the final objective metric for the training job has been evaluated by the tuning job and used in the hyperparameter tuning process.</p>', 'refs' => [ 'DescribeHyperParameterTuningJobResponse$ObjectiveStatusCounters' => '<p>The <a>ObjectiveStatusCounters</a> object that specifies the number of training jobs, categorized by the status of their final objective metric, that this tuning job launched.</p>', 'HyperParameterTuningJobSummary$ObjectiveStatusCounters' => '<p>The <a>ObjectiveStatusCounters</a> object that specifies the numbers of training jobs, categorized by objective metric status, that this tuning job launched.</p>', ], ], 'OidcConfig' => [ 'base' => '<p>Use this parameter to configure your OIDC Identity Provider (IdP).</p>', 'refs' => [ 'CreateWorkforceRequest$OidcConfig' => '<p>Use this parameter to configure a private workforce using your own OIDC Identity Provider. Do not use <code>CognitoConfig</code> if you specify values for <code>OidcConfig</code>.</p>', 'UpdateWorkforceRequest$OidcConfig' => '<p>Use this parameter to update your OIDC Identity Provider (IdP) configuration for a workforce made using your own IdP.</p>', ], ], 'OidcConfigForResponse' => [ 'base' => '<p>Your Amazon Cognito workforce configuration.</p>', 'refs' => [ 'Workforce$OidcConfig' => '<p>The configuration of an OIDC Identity Provider (IdP) private workforce.</p>', ], ], 'OidcEndpoint' => [ 'base' => NULL, 'refs' => [ 'OidcConfig$Issuer' => '<p>The OIDC IdP issuer used to configure your private workforce.</p>', 'OidcConfig$AuthorizationEndpoint' => '<p>The OIDC IdP authorization endpoint used to configure your private workforce.</p>', 'OidcConfig$TokenEndpoint' => '<p>The OIDC IdP token endpoint used to configure your private workforce.</p>', 'OidcConfig$UserInfoEndpoint' => '<p>The OIDC IdP user information endpoint used to configure your private workforce.</p>', 'OidcConfig$LogoutEndpoint' => '<p>The OIDC IdP logout endpoint used to configure your private workforce.</p>', 'OidcConfig$JwksUri' => '<p>The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.</p>', 'OidcConfigForResponse$Issuer' => '<p>The OIDC IdP issuer used to configure your private workforce.</p>', 'OidcConfigForResponse$AuthorizationEndpoint' => '<p>The OIDC IdP authorization endpoint used to configure your private workforce.</p>', 'OidcConfigForResponse$TokenEndpoint' => '<p>The OIDC IdP token endpoint used to configure your private workforce.</p>', 'OidcConfigForResponse$UserInfoEndpoint' => '<p>The OIDC IdP user information endpoint used to configure your private workforce.</p>', 'OidcConfigForResponse$LogoutEndpoint' => '<p>The OIDC IdP logout endpoint used to configure your private workforce.</p>', 'OidcConfigForResponse$JwksUri' => '<p>The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.</p>', ], ], 'OidcMemberDefinition' => [ 'base' => '<p>A list user groups that exist in your OIDC Identity Provider (IdP). One to ten groups can be used to create a single private work team. When you add a user group to the list of <code>Groups</code>, you can add that user group to one or more private work teams. If you add a user group to a private work team, all workers in that user group are added to the work team.</p>', 'refs' => [ 'MemberDefinition$OidcMemberDefinition' => '<p>A list user groups that exist in your OIDC Identity Provider (IdP). One to ten groups can be used to create a single private work team. When you add a user group to the list of <code>Groups</code>, you can add that user group to one or more private work teams. If you add a user group to a private work team, all workers in that user group are added to the work team.</p>', ], ], 'Operator' => [ 'base' => NULL, 'refs' => [ 'Filter$Operator' => '<p>A Boolean binary operator that is used to evaluate the filter. The operator field contains one of the following values:</p> <dl> <dt>Equals</dt> <dd> <p>The value of <code>Name</code> equals <code>Value</code>.</p> </dd> <dt>NotEquals</dt> <dd> <p>The value of <code>Name</code> doesn\'t equal <code>Value</code>.</p> </dd> <dt>Exists</dt> <dd> <p>The <code>Name</code> property exists.</p> </dd> <dt>NotExists</dt> <dd> <p>The <code>Name</code> property does not exist.</p> </dd> <dt>GreaterThan</dt> <dd> <p>The value of <code>Name</code> is greater than <code>Value</code>. Not supported for text properties.</p> </dd> <dt>GreaterThanOrEqualTo</dt> <dd> <p>The value of <code>Name</code> is greater than or equal to <code>Value</code>. Not supported for text properties.</p> </dd> <dt>LessThan</dt> <dd> <p>The value of <code>Name</code> is less than <code>Value</code>. Not supported for text properties.</p> </dd> <dt>LessThanOrEqualTo</dt> <dd> <p>The value of <code>Name</code> is less than or equal to <code>Value</code>. Not supported for text properties.</p> </dd> <dt>In</dt> <dd> <p>The value of <code>Name</code> is one of the comma delimited strings in <code>Value</code>. Only supported for text properties.</p> </dd> <dt>Contains</dt> <dd> <p>The value of <code>Name</code> contains the string <code>Value</code>. Only supported for text properties.</p> <p>A <code>SearchExpression</code> can include the <code>Contains</code> operator multiple times when the value of <code>Name</code> is one of the following:</p> <ul> <li> <p> <code>Experiment.DisplayName</code> </p> </li> <li> <p> <code>Experiment.ExperimentName</code> </p> </li> <li> <p> <code>Experiment.Tags</code> </p> </li> <li> <p> <code>Trial.DisplayName</code> </p> </li> <li> <p> <code>Trial.TrialName</code> </p> </li> <li> <p> <code>Trial.Tags</code> </p> </li> <li> <p> <code>TrialComponent.DisplayName</code> </p> </li> <li> <p> <code>TrialComponent.TrialComponentName</code> </p> </li> <li> <p> <code>TrialComponent.Tags</code> </p> </li> <li> <p> <code>TrialComponent.InputArtifacts</code> </p> </li> <li> <p> <code>TrialComponent.OutputArtifacts</code> </p> </li> </ul> <p>A <code>SearchExpression</code> can include only one <code>Contains</code> operator for all other values of <code>Name</code>. In these cases, if you include multiple <code>Contains</code> operators in the <code>SearchExpression</code>, the result is the following error message: "<code>\'CONTAINS\' operator usage limit of 1 exceeded.</code>"</p> </dd> </dl>', ], ], 'OptionalDouble' => [ 'base' => NULL, 'refs' => [ 'TrialComponentMetricSummary$Max' => '<p>The maximum value of the metric.</p>', 'TrialComponentMetricSummary$Min' => '<p>The minimum value of the metric.</p>', 'TrialComponentMetricSummary$Last' => '<p>The most recent value of the metric.</p>', 'TrialComponentMetricSummary$Avg' => '<p>The average value of the metric.</p>', 'TrialComponentMetricSummary$StdDev' => '<p>The standard deviation of the metric.</p>', ], ], 'OptionalInteger' => [ 'base' => NULL, 'refs' => [ 'TrialComponentMetricSummary$Count' => '<p>The number of samples used to generate the metric.</p>', ], ], 'OptionalVolumeSizeInGB' => [ 'base' => NULL, 'refs' => [ 'DebugRuleConfiguration$VolumeSizeInGB' => '<p>The size, in GB, of the ML storage volume attached to the processing instance.</p>', ], ], 'OrderKey' => [ 'base' => NULL, 'refs' => [ 'ListEndpointConfigsInput$SortOrder' => '<p>The sort order for results. The default is <code>Descending</code>.</p>', 'ListEndpointsInput$SortOrder' => '<p>The sort order for results. The default is <code>Descending</code>.</p>', 'ListModelsInput$SortOrder' => '<p>The sort order for results. The default is <code>Descending</code>.</p>', ], ], 'OutputConfig' => [ 'base' => '<p>Contains information about the output location for the compiled model and the target device that the model runs on. <code>TargetDevice</code> and <code>TargetPlatform</code> are mutually exclusive, so you need to choose one between the two to specify your target device or platform. If you cannot find your device you want to use from the <code>TargetDevice</code> list, use <code>TargetPlatform</code> to describe the platform of your edge device and <code>CompilerOptions</code> if there are specific settings that are required or recommended to use for particular TargetPlatform.</p>', 'refs' => [ 'CreateCompilationJobRequest$OutputConfig' => '<p>Provides information about the output location for the compiled model and the target device the model runs on.</p>', 'DescribeCompilationJobResponse$OutputConfig' => '<p>Information about the output location for the compiled model and the target device that the model runs on.</p>', ], ], 'OutputDataConfig' => [ 'base' => '<p>Provides information about how to store model training results (model artifacts).</p>', 'refs' => [ 'CreateTrainingJobRequest$OutputDataConfig' => '<p>Specifies the path to the S3 location where you want to store model artifacts. Amazon SageMaker creates subfolders for the artifacts. </p>', 'DescribeTrainingJobResponse$OutputDataConfig' => '<p>The S3 path where model artifacts that you configured when creating the job are stored. Amazon SageMaker creates subfolders for model artifacts. </p>', 'HyperParameterTrainingJobDefinition$OutputDataConfig' => '<p>Specifies the path to the Amazon S3 bucket where you store model artifacts from the training jobs that the tuning job launches.</p>', 'TrainingJob$OutputDataConfig' => '<p>The S3 path where model artifacts that you configured when creating the job are stored. Amazon SageMaker creates subfolders for model artifacts.</p>', 'TrainingJobDefinition$OutputDataConfig' => '<p>the path to the S3 bucket where you want to store model artifacts. Amazon SageMaker creates subfolders for the artifacts.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListEndpointConfigsInput$NextToken' => '<p>If the result of the previous <code>ListEndpointConfig</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of endpoint configurations, use the token in the next request. </p>', 'ListEndpointConfigsOutput$NextToken' => '<p> If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of endpoint configurations, use it in the subsequent request </p>', 'ListEndpointsInput$NextToken' => '<p>If the result of a <code>ListEndpoints</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of endpoints, use the token in the next request.</p>', 'ListEndpointsOutput$NextToken' => '<p> If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of training jobs, use it in the subsequent request. </p>', 'ListModelsInput$NextToken' => '<p>If the response to a previous <code>ListModels</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of models, use the token in the next request.</p>', 'ListModelsOutput$NextToken' => '<p> If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of models, use it in the subsequent request. </p>', ], ], 'ParameterKey' => [ 'base' => NULL, 'refs' => [ 'CategoricalParameterRange$Name' => '<p>The name of the categorical hyperparameter to tune.</p>', 'ContinuousParameterRange$Name' => '<p>The name of the continuous hyperparameter to tune.</p>', 'HyperParameters$key' => NULL, 'IntegerParameterRange$Name' => '<p>The name of the hyperparameter to search.</p>', ], ], 'ParameterName' => [ 'base' => NULL, 'refs' => [ 'HyperParameterSpecification$Name' => '<p>The name of this hyperparameter. The name must be unique.</p>', ], ], 'ParameterRange' => [ 'base' => '<p>Defines the possible values for categorical, continuous, and integer hyperparameters to be used by an algorithm.</p>', 'refs' => [ 'HyperParameterSpecification$Range' => '<p>The allowed range for this hyperparameter.</p>', ], ], 'ParameterRanges' => [ 'base' => '<p>Specifies ranges of integer, continuous, and categorical hyperparameters that a hyperparameter tuning job searches. The hyperparameter tuning job launches training jobs with hyperparameter values within these ranges to find the combination of values that result in the training job with the best performance as measured by the objective metric of the hyperparameter tuning job.</p> <note> <p>You can specify a maximum of 20 hyperparameters that a hyperparameter tuning job can search over. Every possible value of a categorical parameter range counts against this limit.</p> </note>', 'refs' => [ 'HyperParameterTrainingJobDefinition$HyperParameterRanges' => NULL, 'HyperParameterTuningJobConfig$ParameterRanges' => '<p>The <a>ParameterRanges</a> object that specifies the ranges of hyperparameters that this tuning job searches.</p>', ], ], 'ParameterType' => [ 'base' => NULL, 'refs' => [ 'HyperParameterSpecification$Type' => '<p>The type of this hyperparameter. The valid types are <code>Integer</code>, <code>Continuous</code>, <code>Categorical</code>, and <code>FreeText</code>.</p>', ], ], 'ParameterValue' => [ 'base' => NULL, 'refs' => [ 'ContinuousParameterRange$MinValue' => '<p>The minimum value for the hyperparameter. The tuning job uses floating-point values between this value and <code>MaxValue</code>for tuning.</p>', 'ContinuousParameterRange$MaxValue' => '<p>The maximum value for the hyperparameter. The tuning job uses floating-point values between <code>MinValue</code> value and this value for tuning.</p>', 'ContinuousParameterRangeSpecification$MinValue' => '<p>The minimum floating-point value allowed.</p>', 'ContinuousParameterRangeSpecification$MaxValue' => '<p>The maximum floating-point value allowed.</p>', 'HyperParameterSpecification$DefaultValue' => '<p>The default value for this hyperparameter. If a default value is specified, a hyperparameter cannot be required.</p>', 'HyperParameters$value' => NULL, 'IntegerParameterRange$MinValue' => '<p>The minimum value of the hyperparameter to search.</p>', 'IntegerParameterRange$MaxValue' => '<p>The maximum value of the hyperparameter to search.</p>', 'IntegerParameterRangeSpecification$MinValue' => '<p>The minimum integer value allowed.</p>', 'IntegerParameterRangeSpecification$MaxValue' => '<p>The maximum integer value allowed.</p>', 'ParameterValues$member' => NULL, ], ], 'ParameterValues' => [ 'base' => NULL, 'refs' => [ 'CategoricalParameterRange$Values' => '<p>A list of the categories for the hyperparameter.</p>', 'CategoricalParameterRangeSpecification$Values' => '<p>The allowed categories for the hyperparameter.</p>', ], ], 'Parent' => [ 'base' => '<p>The trial that a trial component is associated with and the experiment the trial is part of. A component might not be associated with a trial. A component can be associated with multiple trials.</p>', 'refs' => [ 'Parents$member' => NULL, ], ], 'ParentHyperParameterTuningJob' => [ 'base' => '<p>A previously completed or stopped hyperparameter tuning job to be used as a starting point for a new hyperparameter tuning job.</p>', 'refs' => [ 'ParentHyperParameterTuningJobs$member' => NULL, ], ], 'ParentHyperParameterTuningJobs' => [ 'base' => NULL, 'refs' => [ 'HyperParameterTuningJobWarmStartConfig$ParentHyperParameterTuningJobs' => '<p>An array of hyperparameter tuning jobs that are used as the starting point for the new hyperparameter tuning job. For more information about warm starting a hyperparameter tuning job, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-warm-start.html">Using a Previous Hyperparameter Tuning Job as a Starting Point</a>.</p> <p>Hyperparameter tuning jobs created before October 1, 2018 cannot be used as parent jobs for warm start tuning jobs.</p>', ], ], 'Parents' => [ 'base' => NULL, 'refs' => [ 'TrialComponent$Parents' => '<p>An array of the parents of the component. A parent is a trial the component is associated with and the experiment the trial is part of. A component might not have any parents.</p>', ], ], 'PresignedDomainUrl' => [ 'base' => NULL, 'refs' => [ 'CreatePresignedDomainUrlResponse$AuthorizedUrl' => '<p>The presigned URL.</p>', ], ], 'ProblemType' => [ 'base' => NULL, 'refs' => [ 'CreateAutoMLJobRequest$ProblemType' => '<p>Defines the kind of preprocessing and algorithms intended for the candidates. Options include: BinaryClassification, MulticlassClassification, and Regression.</p>', 'DescribeAutoMLJobResponse$ProblemType' => '<p>Returns the job\'s problem type.</p>', 'ResolvedAttributes$ProblemType' => '<p>The problem type.</p>', ], ], 'ProcessingClusterConfig' => [ 'base' => '<p>Configuration for the cluster used to run a processing job.</p>', 'refs' => [ 'ProcessingResources$ClusterConfig' => '<p>The configuration for the resources in a cluster used to run the processing job.</p>', ], ], 'ProcessingEnvironmentKey' => [ 'base' => NULL, 'refs' => [ 'MonitoringEnvironmentMap$key' => NULL, 'ProcessingEnvironmentMap$key' => NULL, ], ], 'ProcessingEnvironmentMap' => [ 'base' => NULL, 'refs' => [ 'CreateProcessingJobRequest$Environment' => '<p>Sets the environment variables in the Docker container.</p>', 'DescribeProcessingJobResponse$Environment' => '<p>The environment variables set in the Docker container.</p>', 'ProcessingJob$Environment' => '<p>Sets the environment variables in the Docker container.</p>', ], ], 'ProcessingEnvironmentValue' => [ 'base' => NULL, 'refs' => [ 'MonitoringEnvironmentMap$value' => NULL, 'ProcessingEnvironmentMap$value' => NULL, ], ], 'ProcessingInput' => [ 'base' => '<p>The inputs for a processing job.</p>', 'refs' => [ 'ProcessingInputs$member' => NULL, ], ], 'ProcessingInputs' => [ 'base' => NULL, 'refs' => [ 'CreateProcessingJobRequest$ProcessingInputs' => '<p>For each input, data is downloaded from S3 into the processing container before the processing job begins running if "S3InputMode" is set to <code>File</code>.</p>', 'DescribeProcessingJobResponse$ProcessingInputs' => '<p>The inputs for a processing job.</p>', 'ProcessingJob$ProcessingInputs' => '<p>For each input, data is downloaded from S3 into the processing container before the processing job begins running if "S3InputMode" is set to <code>File</code>.</p>', ], ], 'ProcessingInstanceCount' => [ 'base' => NULL, 'refs' => [ 'MonitoringClusterConfig$InstanceCount' => '<p>The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.</p>', 'ProcessingClusterConfig$InstanceCount' => '<p>The number of ML compute instances to use in the processing job. For distributed processing jobs, specify a value greater than 1. The default value is 1.</p>', ], ], 'ProcessingInstanceType' => [ 'base' => NULL, 'refs' => [ 'DebugRuleConfiguration$InstanceType' => '<p>The instance type to deploy for a training job.</p>', 'MonitoringClusterConfig$InstanceType' => '<p>The ML compute instance type for the processing job.</p>', 'ProcessingClusterConfig$InstanceType' => '<p>The ML compute instance type for the processing job.</p>', ], ], 'ProcessingJob' => [ 'base' => '<p>An Amazon SageMaker processing job that is used to analyze data and evaluate models. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/processing-job.html">Process Data and Evaluate Models</a>.</p>', 'refs' => [ 'TrialComponentSourceDetail$ProcessingJob' => '<p>Information about a processing job that\'s the source of a trial component.</p>', ], ], 'ProcessingJobArn' => [ 'base' => NULL, 'refs' => [ 'CreateProcessingJobResponse$ProcessingJobArn' => '<p>The Amazon Resource Name (ARN) of the processing job.</p>', 'DebugRuleEvaluationStatus$RuleEvaluationJobArn' => '<p>The Amazon Resource Name (ARN) of the rule evaluation job.</p>', 'DescribeProcessingJobResponse$ProcessingJobArn' => '<p>The Amazon Resource Name (ARN) of the processing job.</p>', 'MonitoringExecutionSummary$ProcessingJobArn' => '<p>The Amazon Resource Name (ARN) of the monitoring job.</p>', 'ProcessingJob$ProcessingJobArn' => '<p>The ARN of the processing job.</p>', 'ProcessingJobSummary$ProcessingJobArn' => '<p>The Amazon Resource Name (ARN) of the processing job..</p>', ], ], 'ProcessingJobName' => [ 'base' => NULL, 'refs' => [ 'CreateProcessingJobRequest$ProcessingJobName' => '<p> The name of the processing job. The name must be unique within an AWS Region in the AWS account.</p>', 'DescribeProcessingJobRequest$ProcessingJobName' => '<p>The name of the processing job. The name must be unique within an AWS Region in the AWS account.</p>', 'DescribeProcessingJobResponse$ProcessingJobName' => '<p>The name of the processing job. The name must be unique within an AWS Region in the AWS account.</p>', 'ProcessingJob$ProcessingJobName' => '<p>The name of the processing job.</p>', 'ProcessingJobSummary$ProcessingJobName' => '<p>The name of the processing job.</p>', 'StopProcessingJobRequest$ProcessingJobName' => '<p>The name of the processing job to stop.</p>', ], ], 'ProcessingJobStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeProcessingJobResponse$ProcessingJobStatus' => '<p>Provides the status of a processing job.</p>', 'ListProcessingJobsRequest$StatusEquals' => '<p>A filter that retrieves only processing jobs with a specific status.</p>', 'ProcessingJob$ProcessingJobStatus' => '<p>The status of the processing job.</p>', 'ProcessingJobSummary$ProcessingJobStatus' => '<p>The status of the processing job.</p>', ], ], 'ProcessingJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListProcessingJobsResponse$ProcessingJobSummaries' => '<p>An array of <code>ProcessingJobSummary</code> objects, each listing a processing job.</p>', ], ], 'ProcessingJobSummary' => [ 'base' => '<p>Summary of information about a processing job.</p>', 'refs' => [ 'ProcessingJobSummaries$member' => NULL, ], ], 'ProcessingLocalPath' => [ 'base' => NULL, 'refs' => [ 'EndpointInput$LocalPath' => '<p>Path to the filesystem where the endpoint data is available to the container.</p>', 'MonitoringS3Output$LocalPath' => '<p>The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data.</p>', 'ProcessingS3Input$LocalPath' => '<p>The local path to the Amazon S3 bucket where you want Amazon SageMaker to download the inputs to run a processing job. <code>LocalPath</code> is an absolute path to the input data.</p>', 'ProcessingS3Output$LocalPath' => '<p>The local path to the Amazon S3 bucket where you want Amazon SageMaker to save the results of an processing job. <code>LocalPath</code> is an absolute path to the input data.</p>', ], ], 'ProcessingMaxRuntimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'ProcessingStoppingCondition$MaxRuntimeInSeconds' => '<p>Specifies the maximum runtime in seconds.</p>', ], ], 'ProcessingOutput' => [ 'base' => '<p>Describes the results of a processing job.</p>', 'refs' => [ 'ProcessingOutputs$member' => NULL, ], ], 'ProcessingOutputConfig' => [ 'base' => '<p>The output configuration for the processing job.</p>', 'refs' => [ 'CreateProcessingJobRequest$ProcessingOutputConfig' => '<p>Output configuration for the processing job.</p>', 'DescribeProcessingJobResponse$ProcessingOutputConfig' => '<p>Output configuration for the processing job.</p>', 'ProcessingJob$ProcessingOutputConfig' => NULL, ], ], 'ProcessingOutputs' => [ 'base' => NULL, 'refs' => [ 'ProcessingOutputConfig$Outputs' => '<p>Output configuration information for a processing job.</p>', ], ], 'ProcessingResources' => [ 'base' => '<p>Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In distributed training, you specify more than one instance.</p>', 'refs' => [ 'CreateProcessingJobRequest$ProcessingResources' => '<p>Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In distributed training, you specify more than one instance.</p>', 'DescribeProcessingJobResponse$ProcessingResources' => '<p>Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In distributed training, you specify more than one instance.</p>', 'ProcessingJob$ProcessingResources' => NULL, ], ], 'ProcessingS3CompressionType' => [ 'base' => NULL, 'refs' => [ 'ProcessingS3Input$S3CompressionType' => '<p>Whether to use <code>Gzip</code> compression for Amazon S3 storage.</p>', ], ], 'ProcessingS3DataDistributionType' => [ 'base' => NULL, 'refs' => [ 'EndpointInput$S3DataDistributionType' => '<p>Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defauts to <code>FullyReplicated</code> </p>', 'ProcessingS3Input$S3DataDistributionType' => '<p>Whether the data stored in Amazon S3 is <code>FullyReplicated</code> or <code>ShardedByS3Key</code>.</p>', ], ], 'ProcessingS3DataType' => [ 'base' => NULL, 'refs' => [ 'ProcessingS3Input$S3DataType' => '<p>Whether you use an <code>S3Prefix</code> or a <code>ManifestFile</code> for the data type. If you choose <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix. Amazon SageMaker uses all objects with the specified key name prefix for the processing job. If you choose <code>ManifestFile</code>, <code>S3Uri</code> identifies an object that is a manifest file containing a list of object keys that you want Amazon SageMaker to use for the processing job.</p>', ], ], 'ProcessingS3Input' => [ 'base' => '<p>Information about where and how you want to obtain the inputs for an processing job.</p>', 'refs' => [ 'ProcessingInput$S3Input' => '<p>The S3 inputs for the processing job. </p>', ], ], 'ProcessingS3InputMode' => [ 'base' => NULL, 'refs' => [ 'EndpointInput$S3InputMode' => '<p>Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for transfering data for the monitoring job. <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode is useful for small files that fit in memory. Defaults to <code>File</code>.</p>', 'ProcessingS3Input$S3InputMode' => '<p>Whether to use <code>File</code> or <code>Pipe</code> input mode. In <code>File</code> mode, Amazon SageMaker copies the data from the input source onto the local Amazon Elastic Block Store (Amazon EBS) volumes before starting your training algorithm. This is the most commonly used input mode. In <code>Pipe</code> mode, Amazon SageMaker streams input data from the source directly to your algorithm without using the EBS volume.</p>', ], ], 'ProcessingS3Output' => [ 'base' => '<p>Information about where and how you want to store the results of an processing job.</p>', 'refs' => [ 'ProcessingOutput$S3Output' => '<p>Configuration for processing job outputs in Amazon S3.</p>', ], ], 'ProcessingS3UploadMode' => [ 'base' => NULL, 'refs' => [ 'MonitoringS3Output$S3UploadMode' => '<p>Whether to upload the results of the monitoring job continuously or after the job completes.</p>', 'ProcessingS3Output$S3UploadMode' => '<p>Whether to upload the results of the processing job continuously or after the job completes.</p>', ], ], 'ProcessingStoppingCondition' => [ 'base' => '<p>Specifies a time limit for how long the processing job is allowed to run.</p>', 'refs' => [ 'CreateProcessingJobRequest$StoppingCondition' => '<p>The time limit for how long the processing job is allowed to run.</p>', 'DescribeProcessingJobResponse$StoppingCondition' => '<p>The time limit for how long the processing job is allowed to run.</p>', 'ProcessingJob$StoppingCondition' => NULL, ], ], 'ProcessingVolumeSizeInGB' => [ 'base' => NULL, 'refs' => [ 'MonitoringClusterConfig$VolumeSizeInGB' => '<p>The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.</p>', 'ProcessingClusterConfig$VolumeSizeInGB' => '<p>The size of the ML storage volume in gigabytes that you want to provision. You must specify sufficient ML storage for your scenario.</p>', ], ], 'ProductId' => [ 'base' => NULL, 'refs' => [ 'DescribeAlgorithmOutput$ProductId' => '<p>The product identifier of the algorithm.</p>', 'ModelPackageContainerDefinition$ProductId' => '<p>The AWS Marketplace product ID of the model package.</p>', ], ], 'ProductListings' => [ 'base' => NULL, 'refs' => [ 'Workteam$ProductListingIds' => '<p>The Amazon Marketplace identifier for a vendor\'s work team.</p>', ], ], 'ProductionVariant' => [ 'base' => '<p>Identifies a model that you want to host and the resources to deploy for hosting it. If you are deploying multiple models, tell Amazon SageMaker how to distribute traffic among the models by specifying variant weights. </p>', 'refs' => [ 'ProductionVariantList$member' => NULL, ], ], 'ProductionVariantAcceleratorType' => [ 'base' => NULL, 'refs' => [ 'ProductionVariant$AcceleratorType' => '<p>The size of the Elastic Inference (EI) instance to use for the production variant. EI instances provide on-demand GPU computing for inference. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.</p>', ], ], 'ProductionVariantInstanceType' => [ 'base' => NULL, 'refs' => [ 'ProductionVariant$InstanceType' => '<p>The ML compute instance type.</p>', 'RealtimeInferenceInstanceTypes$member' => NULL, ], ], 'ProductionVariantList' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointConfigInput$ProductionVariants' => '<p>An list of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint.</p>', 'DescribeEndpointConfigOutput$ProductionVariants' => '<p>An array of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint.</p>', ], ], 'ProductionVariantSummary' => [ 'base' => '<p>Describes weight and capacities for a production variant associated with an endpoint. If you sent a request to the <code>UpdateEndpointWeightsAndCapacities</code> API and the endpoint status is <code>Updating</code>, you get different desired and current values. </p>', 'refs' => [ 'ProductionVariantSummaryList$member' => NULL, ], ], 'ProductionVariantSummaryList' => [ 'base' => NULL, 'refs' => [ 'DescribeEndpointOutput$ProductionVariants' => '<p> An array of <a>ProductionVariantSummary</a> objects, one for each model hosted behind this endpoint. </p>', ], ], 'PropertyNameHint' => [ 'base' => NULL, 'refs' => [ 'PropertyNameQuery$PropertyNameHint' => '<p>Text that begins a property\'s name.</p>', ], ], 'PropertyNameQuery' => [ 'base' => '<p>Part of the <code>SuggestionQuery</code> type. Specifies a hint for retrieving property names that begin with the specified text.</p>', 'refs' => [ 'SuggestionQuery$PropertyNameQuery' => '<p>Defines a property name hint. Only property names that begin with the specified hint are included in the response.</p>', ], ], 'PropertyNameSuggestion' => [ 'base' => '<p>A property name returned from a <code>GetSearchSuggestions</code> call that specifies a value in the <code>PropertyNameQuery</code> field.</p>', 'refs' => [ 'PropertyNameSuggestionList$member' => NULL, ], ], 'PropertyNameSuggestionList' => [ 'base' => NULL, 'refs' => [ 'GetSearchSuggestionsResponse$PropertyNameSuggestions' => '<p>A list of property names for a <code>Resource</code> that match a <code>SuggestionQuery</code>.</p>', ], ], 'PublicWorkforceTaskPrice' => [ 'base' => '<p>Defines the amount of money paid to an Amazon Mechanical Turk worker for each task performed. </p> <p>Use one of the following prices for bounding box tasks. Prices are in US dollars and should be based on the complexity of the task; the longer it takes in your initial testing, the more you should offer.</p> <ul> <li> <p>0.036</p> </li> <li> <p>0.048</p> </li> <li> <p>0.060</p> </li> <li> <p>0.072</p> </li> <li> <p>0.120</p> </li> <li> <p>0.240</p> </li> <li> <p>0.360</p> </li> <li> <p>0.480</p> </li> <li> <p>0.600</p> </li> <li> <p>0.720</p> </li> <li> <p>0.840</p> </li> <li> <p>0.960</p> </li> <li> <p>1.080</p> </li> <li> <p>1.200</p> </li> </ul> <p>Use one of the following prices for image classification, text classification, and custom tasks. Prices are in US dollars.</p> <ul> <li> <p>0.012</p> </li> <li> <p>0.024</p> </li> <li> <p>0.036</p> </li> <li> <p>0.048</p> </li> <li> <p>0.060</p> </li> <li> <p>0.072</p> </li> <li> <p>0.120</p> </li> <li> <p>0.240</p> </li> <li> <p>0.360</p> </li> <li> <p>0.480</p> </li> <li> <p>0.600</p> </li> <li> <p>0.720</p> </li> <li> <p>0.840</p> </li> <li> <p>0.960</p> </li> <li> <p>1.080</p> </li> <li> <p>1.200</p> </li> </ul> <p>Use one of the following prices for semantic segmentation tasks. Prices are in US dollars.</p> <ul> <li> <p>0.840</p> </li> <li> <p>0.960</p> </li> <li> <p>1.080</p> </li> <li> <p>1.200</p> </li> </ul> <p>Use one of the following prices for Textract AnalyzeDocument Important Form Key Amazon Augmented AI review tasks. Prices are in US dollars.</p> <ul> <li> <p>2.400 </p> </li> <li> <p>2.280 </p> </li> <li> <p>2.160 </p> </li> <li> <p>2.040 </p> </li> <li> <p>1.920 </p> </li> <li> <p>1.800 </p> </li> <li> <p>1.680 </p> </li> <li> <p>1.560 </p> </li> <li> <p>1.440 </p> </li> <li> <p>1.320 </p> </li> <li> <p>1.200 </p> </li> <li> <p>1.080 </p> </li> <li> <p>0.960 </p> </li> <li> <p>0.840 </p> </li> <li> <p>0.720 </p> </li> <li> <p>0.600 </p> </li> <li> <p>0.480 </p> </li> <li> <p>0.360 </p> </li> <li> <p>0.240 </p> </li> <li> <p>0.120 </p> </li> <li> <p>0.072 </p> </li> <li> <p>0.060 </p> </li> <li> <p>0.048 </p> </li> <li> <p>0.036 </p> </li> <li> <p>0.024 </p> </li> <li> <p>0.012 </p> </li> </ul> <p>Use one of the following prices for Rekognition DetectModerationLabels Amazon Augmented AI review tasks. Prices are in US dollars.</p> <ul> <li> <p>1.200 </p> </li> <li> <p>1.080 </p> </li> <li> <p>0.960 </p> </li> <li> <p>0.840 </p> </li> <li> <p>0.720 </p> </li> <li> <p>0.600 </p> </li> <li> <p>0.480 </p> </li> <li> <p>0.360 </p> </li> <li> <p>0.240 </p> </li> <li> <p>0.120 </p> </li> <li> <p>0.072 </p> </li> <li> <p>0.060 </p> </li> <li> <p>0.048 </p> </li> <li> <p>0.036 </p> </li> <li> <p>0.024 </p> </li> <li> <p>0.012 </p> </li> </ul> <p>Use one of the following prices for Amazon Augmented AI custom human review tasks. Prices are in US dollars.</p> <ul> <li> <p>1.200 </p> </li> <li> <p>1.080 </p> </li> <li> <p>0.960 </p> </li> <li> <p>0.840 </p> </li> <li> <p>0.720 </p> </li> <li> <p>0.600 </p> </li> <li> <p>0.480 </p> </li> <li> <p>0.360 </p> </li> <li> <p>0.240 </p> </li> <li> <p>0.120 </p> </li> <li> <p>0.072 </p> </li> <li> <p>0.060 </p> </li> <li> <p>0.048 </p> </li> <li> <p>0.036 </p> </li> <li> <p>0.024 </p> </li> <li> <p>0.012 </p> </li> </ul>', 'refs' => [ 'HumanLoopConfig$PublicWorkforceTaskPrice' => NULL, 'HumanTaskConfig$PublicWorkforceTaskPrice' => '<p>The price that you pay for each task performed by an Amazon Mechanical Turk worker.</p>', ], ], 'RealtimeInferenceInstanceTypes' => [ 'base' => NULL, 'refs' => [ 'InferenceSpecification$SupportedRealtimeInferenceInstanceTypes' => '<p>A list of the instance types that are used to generate inferences in real-time.</p>', ], ], 'RecordWrapper' => [ 'base' => NULL, 'refs' => [ 'Channel$RecordWrapperType' => '<p/> <p>Specify RecordIO as the value when input data is in raw format but the training algorithm requires the RecordIO format. In this case, Amazon SageMaker wraps each individual S3 object in a RecordIO record. If the input data is already in RecordIO format, you don\'t need to set this attribute. For more information, see <a href="https://mxnet.apache.org/api/architecture/note_data_loading#data-format">Create a Dataset Using RecordIO</a>. </p> <p>In File mode, leave this field unset or set it to None.</p>', ], ], 'RenderUiTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'RenderUiTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'RenderableTask' => [ 'base' => '<p>Contains input values for a task.</p>', 'refs' => [ 'RenderUiTemplateRequest$Task' => '<p>A <code>RenderableTask</code> object containing a representative task to render.</p>', ], ], 'RenderingError' => [ 'base' => '<p>A description of an error that occurred while rendering the template.</p>', 'refs' => [ 'RenderingErrorList$member' => NULL, ], ], 'RenderingErrorList' => [ 'base' => NULL, 'refs' => [ 'RenderUiTemplateResponse$Errors' => '<p>A list of one or more <code>RenderingError</code> objects if any were encountered while rendering the template. If there were no errors, the list is empty.</p>', ], ], 'ResolvedAttributes' => [ 'base' => '<p>The resolved attributes.</p>', 'refs' => [ 'DescribeAutoMLJobResponse$ResolvedAttributes' => '<p>This contains ProblemType, AutoMLJobObjective and CompletionCriteria. They\'re auto-inferred values, if not provided by you. If you do provide them, then they\'ll be the same as provided.</p>', ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'AddTagsInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want to tag.</p>', 'DeleteTagsInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource whose tags you want to delete.</p>', 'ListTagsInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource whose tags you want to retrieve.</p>', ], ], 'ResourceConfig' => [ 'base' => '<p>Describes the resources, including ML compute instances and ML storage volumes, to use for model training. </p>', 'refs' => [ 'CreateTrainingJobRequest$ResourceConfig' => '<p>The resources, including the ML compute instances and ML storage volumes, to use for model training. </p> <p>ML storage volumes store model artifacts and incremental states. Training algorithms might also use ML storage volumes for scratch space. If you want Amazon SageMaker to use the ML storage volume to store the training data, choose <code>File</code> as the <code>TrainingInputMode</code> in the algorithm specification. For distributed training algorithms, specify an instance count greater than 1.</p>', 'DescribeTrainingJobResponse$ResourceConfig' => '<p>Resources, including ML compute instances and ML storage volumes, that are configured for model training. </p>', 'HyperParameterTrainingJobDefinition$ResourceConfig' => '<p>The resources, including the compute instances and storage volumes, to use for the training jobs that the tuning job launches.</p> <p>Storage volumes store model artifacts and incremental states. Training algorithms might also use storage volumes for scratch space. If you want Amazon SageMaker to use the storage volume to store the training data, choose <code>File</code> as the <code>TrainingInputMode</code> in the algorithm specification. For distributed training algorithms, specify an instance count greater than 1.</p>', 'TrainingJob$ResourceConfig' => '<p>Resources, including ML compute instances and ML storage volumes, that are configured for model training.</p>', 'TrainingJobDefinition$ResourceConfig' => '<p>The resources, including the ML compute instances and ML storage volumes, to use for model training.</p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'DescribeDomainResponse$HomeEfsFileSystemId' => '<p>The ID of the Amazon Elastic File System (EFS) managed by this Domain.</p>', ], ], 'ResourceInUse' => [ 'base' => '<p>Resource being accessed is in use.</p>', 'refs' => [], ], 'ResourceLimitExceeded' => [ 'base' => '<p> You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs created. </p>', 'refs' => [], ], 'ResourceLimits' => [ 'base' => '<p>Specifies the maximum number of training jobs and parallel training jobs that a hyperparameter tuning job can launch.</p>', 'refs' => [ 'HyperParameterTuningJobConfig$ResourceLimits' => '<p>The <a>ResourceLimits</a> object that specifies the maximum number of training jobs and parallel training jobs for this tuning job.</p>', 'HyperParameterTuningJobSummary$ResourceLimits' => '<p>The <a>ResourceLimits</a> object that specifies the maximum number of training jobs and parallel training jobs allowed for this tuning job.</p>', ], ], 'ResourceNotFound' => [ 'base' => '<p>Resource being access is not found.</p>', 'refs' => [], ], 'ResourcePropertyName' => [ 'base' => NULL, 'refs' => [ 'Filter$Name' => '<p>A resource property name. For example, <code>TrainingJobName</code>. For valid property names, see <a>SearchRecord</a>. You must specify a valid property for the resource.</p>', 'NestedFilters$NestedPropertyName' => '<p>The name of the property to use in the nested filters. The value must match a listed property name, such as <code>InputDataConfig</code>.</p>', 'PropertyNameSuggestion$PropertyName' => '<p>A suggested property name based on what you entered in the search textbox in the Amazon SageMaker console.</p>', 'SearchRequest$SortBy' => '<p>The name of the resource property used to sort the <code>SearchResults</code>. The default is <code>LastModifiedTime</code>.</p>', ], ], 'ResourceSpec' => [ 'base' => '<p>The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. The ARN is stored as metadata in SageMaker Studio notebooks.</p>', 'refs' => [ 'CreateAppRequest$ResourceSpec' => '<p>The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.</p>', 'DescribeAppResponse$ResourceSpec' => '<p>The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.</p>', 'JupyterServerAppSettings$DefaultResourceSpec' => '<p>The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.</p>', 'KernelGatewayAppSettings$DefaultResourceSpec' => '<p>The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.</p>', 'TensorBoardAppSettings$DefaultResourceSpec' => '<p>The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.</p>', ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'GetSearchSuggestionsRequest$Resource' => '<p>The name of the Amazon SageMaker resource to search for.</p>', 'SearchRequest$Resource' => '<p>The name of the Amazon SageMaker resource to search for.</p>', ], ], 'ResponseMIMEType' => [ 'base' => NULL, 'refs' => [ 'ResponseMIMETypes$member' => NULL, ], ], 'ResponseMIMETypes' => [ 'base' => NULL, 'refs' => [ 'InferenceSpecification$SupportedResponseMIMETypes' => '<p>The supported MIME types for the output data.</p>', ], ], 'RetentionPolicy' => [ 'base' => '<p>The retention policy for data stored on an Amazon Elastic File System (EFS) volume.</p>', 'refs' => [ 'DeleteDomainRequest$RetentionPolicy' => '<p>The retention policy for this domain, which specifies whether resources will be retained after the Domain is deleted. By default, all resources are retained (not automatically deleted). </p>', ], ], 'RetentionType' => [ 'base' => NULL, 'refs' => [ 'RetentionPolicy$HomeEfsFileSystem' => '<p>The default is <code>Retain</code>, which specifies to keep the data stored on the EFS volume.</p> <p>Specify <code>Delete</code> to delete the data stored on the EFS volume.</p>', ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'AlgorithmValidationSpecification$ValidationRole' => '<p>The IAM roles that Amazon SageMaker uses to run the training jobs.</p>', 'CreateAutoMLJobRequest$RoleArn' => '<p>The ARN of the role that will be used to access the data.</p>', 'CreateCompilationJobRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf. </p> <p>During model compilation, Amazon SageMaker needs your permission to:</p> <ul> <li> <p>Read input data from an S3 bucket</p> </li> <li> <p>Write model artifacts to an S3 bucket</p> </li> <li> <p>Write logs to Amazon CloudWatch Logs</p> </li> <li> <p>Publish metrics to Amazon CloudWatch</p> </li> </ul> <p>You grant permissions for all of these tasks to an IAM role. To pass this role to Amazon SageMaker, the caller of this API must have the <code>iam:PassRole</code> permission. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles.</a> </p>', 'CreateFlowDefinitionRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of the role needed to call other services on your behalf. For example, <code>arn:aws:iam::1234567890:role/service-role/AmazonSageMaker-ExecutionRole-20180111T151298</code>.</p>', 'CreateLabelingJobRequest$RoleArn' => '<p>The Amazon Resource Number (ARN) that Amazon SageMaker assumes to perform tasks on your behalf during data labeling. You must grant this role the necessary permissions so that Amazon SageMaker can successfully complete data labeling.</p>', 'CreateModelInput$ExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker can assume to access model artifacts and docker image for deployment on ML compute instances or for batch transform jobs. Deploying on ML compute instances is part of model hosting. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles</a>. </p> <note> <p>To be able to pass this role to Amazon SageMaker, the caller of this API must have the <code>iam:PassRole</code> permission.</p> </note>', 'CreateNotebookInstanceInput$RoleArn' => '<p> When you send any requests to AWS resources from the notebook instance, Amazon SageMaker assumes this role to perform tasks on your behalf. You must grant this role necessary permissions so Amazon SageMaker can perform these tasks. The policy must allow the Amazon SageMaker service principal (sagemaker.amazonaws.com) permissions to assume this role. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles</a>. </p> <note> <p>To be able to pass this role to Amazon SageMaker, the caller of this API must have the <code>iam:PassRole</code> permission.</p> </note>', 'CreateProcessingJobRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>', 'CreateTrainingJobRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf. </p> <p>During model training, Amazon SageMaker needs your permission to read input data from an S3 bucket, download a Docker image that contains training code, write model artifacts to an S3 bucket, write logs to Amazon CloudWatch Logs, and publish metrics to Amazon CloudWatch. You grant permissions for all of these tasks to an IAM role. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles</a>. </p> <note> <p>To be able to pass this role to Amazon SageMaker, the caller of this API must have the <code>iam:PassRole</code> permission.</p> </note>', 'DescribeAutoMLJobResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that has read permission to the input data location and write permission to the output data location in Amazon S3.</p>', 'DescribeCompilationJobResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) of the model compilation job.</p>', 'DescribeFlowDefinitionResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) execution role for the flow definition.</p>', 'DescribeLabelingJobResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) that Amazon SageMaker assumes to perform tasks on your behalf during data labeling.</p>', 'DescribeModelOutput$ExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that you specified for the model.</p>', 'DescribeNotebookInstanceOutput$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role associated with the instance. </p>', 'DescribeProcessingJobResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>', 'DescribeTrainingJobResponse$RoleArn' => '<p>The AWS Identity and Access Management (IAM) role configured for the training job. </p>', 'HyperParameterTrainingJobDefinition$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role associated with the training jobs that the tuning job launches.</p>', 'ModelPackageValidationSpecification$ValidationRole' => '<p>The IAM roles to be used for the validation of the model package.</p>', 'MonitoringJobDefinition$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>', 'ProcessingJob$RoleArn' => '<p>The ARN of the role used to create the processing job.</p>', 'RenderUiTemplateRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) that has access to the S3 objects that are used by the template.</p>', 'TrainingJob$RoleArn' => '<p>The AWS Identity and Access Management (IAM) role configured for the training job.</p>', 'UpdateNotebookInstanceInput$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker can assume to access the notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles</a>. </p> <note> <p>To be able to pass this role to Amazon SageMaker, the caller of this API must have the <code>iam:PassRole</code> permission.</p> </note>', 'UserSettings$ExecutionRole' => '<p>The execution role for the user.</p>', ], ], 'RootAccess' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceInput$RootAccess' => '<p>Whether root access is enabled or disabled for users of the notebook instance. The default value is <code>Enabled</code>.</p> <note> <p>Lifecycle configurations need root access to be able to set up a notebook instance. Because of this, lifecycle configurations associated with a notebook instance always run with root access even if you disable root access for users.</p> </note>', 'DescribeNotebookInstanceOutput$RootAccess' => '<p>Whether root access is enabled or disabled for users of the notebook instance.</p> <note> <p>Lifecycle configurations need root access to be able to set up a notebook instance. Because of this, lifecycle configurations associated with a notebook instance always run with root access even if you disable root access for users.</p> </note>', 'UpdateNotebookInstanceInput$RootAccess' => '<p>Whether root access is enabled or disabled for users of the notebook instance. The default value is <code>Enabled</code>.</p> <note> <p>If you set this to <code>Disabled</code>, users don\'t have root access on the notebook instance, but lifecycle configuration scripts still run with root permissions.</p> </note>', ], ], 'RuleConfigurationName' => [ 'base' => NULL, 'refs' => [ 'DebugRuleConfiguration$RuleConfigurationName' => '<p>The name of the rule configuration. It must be unique relative to other rule configuration names.</p>', 'DebugRuleEvaluationStatus$RuleConfigurationName' => '<p>The name of the rule configuration</p>', ], ], 'RuleEvaluationStatus' => [ 'base' => NULL, 'refs' => [ 'DebugRuleEvaluationStatus$RuleEvaluationStatus' => '<p>Status of the rule evaluation.</p>', ], ], 'RuleParameters' => [ 'base' => NULL, 'refs' => [ 'DebugRuleConfiguration$RuleParameters' => '<p> Runtime configuration for rule container.</p>', ], ], 'S3DataDistribution' => [ 'base' => NULL, 'refs' => [ 'S3DataSource$S3DataDistributionType' => '<p>If you want Amazon SageMaker to replicate the entire dataset on each ML compute instance that is launched for model training, specify <code>FullyReplicated</code>. </p> <p>If you want Amazon SageMaker to replicate a subset of data on each ML compute instance that is launched for model training, specify <code>ShardedByS3Key</code>. If there are <i>n</i> ML compute instances launched for a training job, each instance gets approximately 1/<i>n</i> of the number of S3 objects. In this case, model training on each machine uses only the subset of training data. </p> <p>Don\'t choose more ML compute instances for training than available S3 objects. If you do, some nodes won\'t get any data and you will pay for nodes that aren\'t getting any training data. This applies in both File and Pipe modes. Keep this in mind when developing algorithms. </p> <p>In distributed training, where you use multiple ML compute EC2 instances, you might choose <code>ShardedByS3Key</code>. If the algorithm requires copying training data to the ML storage volume (when <code>TrainingInputMode</code> is set to <code>File</code>), this copies 1/<i>n</i> of the number of objects. </p>', ], ], 'S3DataSource' => [ 'base' => '<p>Describes the S3 data source.</p>', 'refs' => [ 'DataSource$S3DataSource' => '<p>The S3 location of the data source that is associated with a channel.</p>', ], ], 'S3DataType' => [ 'base' => NULL, 'refs' => [ 'S3DataSource$S3DataType' => '<p>If you choose <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix. Amazon SageMaker uses all objects that match the specified key name prefix for model training. </p> <p>If you choose <code>ManifestFile</code>, <code>S3Uri</code> identifies an object that is a manifest file containing a list of object keys that you want Amazon SageMaker to use for model training. </p> <p>If you choose <code>AugmentedManifestFile</code>, S3Uri identifies an object that is an augmented manifest file in JSON lines format. This file contains the data you want to use for model training. <code>AugmentedManifestFile</code> can only be used if the Channel\'s input mode is <code>Pipe</code>.</p>', 'TransformS3DataSource$S3DataType' => '<p>If you choose <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix. Amazon SageMaker uses all objects with the specified key name prefix for batch transform. </p> <p>If you choose <code>ManifestFile</code>, <code>S3Uri</code> identifies an object that is a manifest file containing a list of object keys that you want Amazon SageMaker to use for batch transform. </p> <p>The following values are compatible: <code>ManifestFile</code>, <code>S3Prefix</code> </p> <p>The following value is not compatible: <code>AugmentedManifestFile</code> </p>', ], ], 'S3Uri' => [ 'base' => NULL, 'refs' => [ 'AutoMLOutputDataConfig$S3OutputPath' => '<p>The Amazon S3 output path. Must be 128 characters or less.</p>', 'AutoMLS3DataSource$S3Uri' => '<p>The URL to the Amazon S3 data source.</p>', 'CheckpointConfig$S3Uri' => '<p>Identifies the S3 path where you want Amazon SageMaker to store checkpoints. For example, <code>s3://bucket-name/key-name-prefix</code>.</p>', 'CreateLabelingJobRequest$LabelCategoryConfigS3Uri' => '<p>The S3 URL of the file that defines the categories used to label the data objects.</p> <p>For 3D point cloud task types, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud-label-category-config.html">Create a Labeling Category Configuration File for 3D Point Cloud Labeling Jobs</a>. </p> <p>For all other <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates.html">custom tasks</a>, your label category configuration file must be a JSON file in the following format. Identify the labels you want to use by replacing <code>label_1</code>, <code>label_2</code>,<code>...</code>,<code>label_n</code> with your label categories.</p> <p> <code>{</code> </p> <p> <code> "document-version": "2018-11-28"</code> </p> <p> <code> "labels": [</code> </p> <p> <code> {</code> </p> <p> <code> "label": "<i>label_1</i>"</code> </p> <p> <code> },</code> </p> <p> <code> {</code> </p> <p> <code> "label": "<i>label_2</i>"</code> </p> <p> <code> },</code> </p> <p> <code> ...</code> </p> <p> <code> {</code> </p> <p> <code> "label": "<i>label_n</i>"</code> </p> <p> <code> }</code> </p> <p> <code> ]</code> </p> <p> <code>}</code> </p>', 'DebugHookConfig$S3OutputPath' => '<p>Path to Amazon S3 storage location for tensors.</p>', 'DebugRuleConfiguration$S3OutputPath' => '<p>Path to Amazon S3 storage location for rules.</p>', 'DescribeLabelingJobResponse$LabelCategoryConfigS3Uri' => '<p>The S3 location of the JSON file that defines the categories used to label data objects. Please note the following label-category limits:</p> <ul> <li> <p>Semantic segmentation labeling jobs using automated labeling: 20 labels</p> </li> <li> <p>Box bounding labeling jobs (all): 10 labels</p> </li> </ul> <p>The file is a JSON structure in the following format:</p> <p> <code>{</code> </p> <p> <code> "document-version": "2018-11-28"</code> </p> <p> <code> "labels": [</code> </p> <p> <code> {</code> </p> <p> <code> "label": "<i>label 1</i>"</code> </p> <p> <code> },</code> </p> <p> <code> {</code> </p> <p> <code> "label": "<i>label 2</i>"</code> </p> <p> <code> },</code> </p> <p> <code> ...</code> </p> <p> <code> {</code> </p> <p> <code> "label": "<i>label n</i>"</code> </p> <p> <code> }</code> </p> <p> <code> ]</code> </p> <p> <code>}</code> </p>', 'FlowDefinitionOutputConfig$S3OutputPath' => '<p>The Amazon S3 path where the object containing human output will be made available.</p>', 'InputConfig$S3Uri' => '<p>The S3 path where the model artifacts, which result from model training, are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix).</p>', 'LabelingJobOutput$OutputDatasetS3Uri' => '<p>The Amazon S3 bucket location of the manifest file for labeled data. </p>', 'LabelingJobOutputConfig$S3OutputPath' => '<p>The Amazon S3 location to write output data.</p>', 'LabelingJobS3DataSource$ManifestS3Uri' => '<p>The Amazon S3 location of the manifest file that describes the input data objects.</p>', 'ModelArtifacts$S3ModelArtifacts' => '<p>The path of the S3 object that contains the model artifacts. For example, <code>s3://bucket-name/keynameprefix/model.tar.gz</code>.</p>', 'MonitoringAppSpecification$RecordPreprocessorSourceUri' => '<p>An Amazon S3 URI to a script that is called per row prior to running analysis. It can base64 decode the payload and convert it into a flatted json so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers.</p>', 'MonitoringAppSpecification$PostAnalyticsProcessorSourceUri' => '<p>An Amazon S3 URI to a script that is called after analysis has been performed. Applicable only for the built-in (first party) containers.</p>', 'MonitoringConstraintsResource$S3Uri' => '<p>The Amazon S3 URI for the constraints resource.</p>', 'MonitoringStatisticsResource$S3Uri' => '<p>The Amazon S3 URI for the statistics resource.</p>', 'OutputConfig$S3OutputLocation' => '<p>Identifies the S3 bucket where you want Amazon SageMaker to store the model artifacts. For example, <code>s3://bucket-name/key-name-prefix</code>.</p>', 'OutputDataConfig$S3OutputPath' => '<p>Identifies the S3 path where you want Amazon SageMaker to store the model artifacts. For example, <code>s3://bucket-name/key-name-prefix</code>. </p>', 'ProcessingS3Input$S3Uri' => '<p>The URI for the Amazon S3 storage where you want Amazon SageMaker to download the artifacts needed to run a processing job.</p>', 'ProcessingS3Output$S3Uri' => '<p>A URI that identifies the Amazon S3 bucket where you want Amazon SageMaker to save the results of a processing job.</p>', 'S3DataSource$S3Uri' => '<p>Depending on the value specified for the <code>S3DataType</code>, identifies either a key name prefix or a manifest. For example: </p> <ul> <li> <p> A key name prefix might look like this: <code>s3://bucketname/exampleprefix</code> </p> </li> <li> <p> A manifest might look like this: <code>s3://bucketname/example.manifest</code> </p> <p> A manifest is an S3 object which is a JSON file consisting of an array of elements. The first element is a prefix which is followed by one or more suffixes. SageMaker appends the suffix elements to the prefix to get a full set of <code>S3Uri</code>. Note that the prefix must be a valid non-empty <code>S3Uri</code> that precludes users from specifying a manifest whose individual <code>S3Uri</code> is sourced from different S3 buckets.</p> <p> The following code example shows a valid manifest format: </p> <p> <code>[ {"prefix": "s3://customer_bucket/some/prefix/"},</code> </p> <p> <code> "relative/path/to/custdata-1",</code> </p> <p> <code> "relative/path/custdata-2",</code> </p> <p> <code> ...</code> </p> <p> <code> "relative/path/custdata-N"</code> </p> <p> <code>]</code> </p> <p> This JSON is equivalent to the following <code>S3Uri</code> list:</p> <p> <code>s3://customer_bucket/some/prefix/relative/path/to/custdata-1</code> </p> <p> <code>s3://customer_bucket/some/prefix/relative/path/custdata-2</code> </p> <p> <code>...</code> </p> <p> <code>s3://customer_bucket/some/prefix/relative/path/custdata-N</code> </p> <p>The complete set of <code>S3Uri</code> in this manifest is the input data for the channel for this data source. The object that each <code>S3Uri</code> points to must be readable by the IAM role that Amazon SageMaker uses to perform tasks on your behalf. </p> </li> </ul>', 'SharingSettings$S3OutputPath' => '<p>When <code>NotebookOutputOption</code> is <code>Allowed</code>, the Amazon S3 bucket used to save the notebook cell output. If <code>S3OutputPath</code> isn\'t specified, a default bucket is used.</p>', 'TensorBoardOutputConfig$S3OutputPath' => '<p>Path to Amazon S3 storage location for TensorBoard output.</p>', 'TransformOutput$S3OutputPath' => '<p>The Amazon S3 path where you want Amazon SageMaker to store the results of the transform job. For example, <code>s3://bucket-name/key-name-prefix</code>.</p> <p>For every S3 object used as input for the transform job, batch transform stores the transformed data with an .<code>out</code> suffix in a corresponding subfolder in the location in the output prefix. For example, for the input data stored at <code>s3://bucket-name/input-name-prefix/dataset01/data.csv</code>, batch transform stores the transformed data at <code>s3://bucket-name/output-name-prefix/input-name-prefix/data.csv.out</code>. Batch transform doesn\'t upload partially processed objects. For an input S3 object that contains multiple records, it creates an .<code>out</code> file only if the transform job succeeds on the entire file. When the input contains multiple S3 objects, the batch transform job processes the listed S3 objects and uploads only the output for successfully processed objects. If any object fails in the transform job batch transform marks the job as failed to prompt investigation.</p>', 'TransformS3DataSource$S3Uri' => '<p>Depending on the value specified for the <code>S3DataType</code>, identifies either a key name prefix or a manifest. For example:</p> <ul> <li> <p> A key name prefix might look like this: <code>s3://bucketname/exampleprefix</code>. </p> </li> <li> <p> A manifest might look like this: <code>s3://bucketname/example.manifest</code> </p> <p> The manifest is an S3 object which is a JSON file with the following format: </p> <p> <code>[ {"prefix": "s3://customer_bucket/some/prefix/"},</code> </p> <p> <code>"relative/path/to/custdata-1",</code> </p> <p> <code>"relative/path/custdata-2",</code> </p> <p> <code>...</code> </p> <p> <code>"relative/path/custdata-N"</code> </p> <p> <code>]</code> </p> <p> The preceding JSON matches the following <code>S3Uris</code>: </p> <p> <code>s3://customer_bucket/some/prefix/relative/path/to/custdata-1</code> </p> <p> <code>s3://customer_bucket/some/prefix/relative/path/custdata-2</code> </p> <p> <code>...</code> </p> <p> <code>s3://customer_bucket/some/prefix/relative/path/custdata-N</code> </p> <p> The complete set of <code>S3Uris</code> in this manifest constitutes the input data for the channel for this datasource. The object that each <code>S3Uris</code> points to must be readable by the IAM role that Amazon SageMaker uses to perform tasks on your behalf.</p> </li> </ul>', 'UiConfig$UiTemplateS3Uri' => '<p>The Amazon S3 bucket location of the UI template, or worker task template. This is the template used to render the worker UI and tools for labeling job tasks. For more information about the contents of a UI template, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step2.html"> Creating Your Custom Labeling Task Template</a>.</p>', ], ], 'SamplingPercentage' => [ 'base' => NULL, 'refs' => [ 'DataCaptureConfig$InitialSamplingPercentage' => '<p/>', 'DataCaptureConfigSummary$CurrentSamplingPercentage' => '<p/>', ], ], 'ScheduleConfig' => [ 'base' => '<p>Configuration details about the monitoring schedule.</p>', 'refs' => [ 'MonitoringScheduleConfig$ScheduleConfig' => '<p>Configures the monitoring schedule.</p>', ], ], 'ScheduleExpression' => [ 'base' => NULL, 'refs' => [ 'ScheduleConfig$ScheduleExpression' => '<p>A cron expression that describes details about the monitoring schedule.</p> <p>Currently the only supported cron expressions are:</p> <ul> <li> <p>If you want to set the job to start every hour, please use the following:</p> <p> <code>Hourly: cron(0 * ? * * *)</code> </p> </li> <li> <p>If you want to start the job daily:</p> <p> <code>cron(0 [00-23] ? * * *)</code> </p> </li> </ul> <p>For example, the following are valid cron expressions:</p> <ul> <li> <p>Daily at noon UTC: <code>cron(0 12 ? * * *)</code> </p> </li> <li> <p>Daily at midnight UTC: <code>cron(0 0 ? * * *)</code> </p> </li> </ul> <p>To support running every 6, 12 hours, the following are also supported:</p> <p> <code>cron(0 [00-23]/[01-24] ? * * *)</code> </p> <p>For example, the following are valid cron expressions:</p> <ul> <li> <p>Every 12 hours, starting at 5pm UTC: <code>cron(0 17/12 ? * * *)</code> </p> </li> <li> <p>Every two hours starting at midnight: <code>cron(0 0/2 ? * * *)</code> </p> </li> </ul> <note> <ul> <li> <p>Even though the cron expression is set to start at 5PM UTC, note that there could be a delay of 0-20 minutes from the actual requested time to run the execution. </p> </li> <li> <p>We recommend that if you would like a daily schedule, you do not provide this parameter. Amazon SageMaker will pick a time for running every day.</p> </li> </ul> </note>', ], ], 'ScheduleStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeMonitoringScheduleResponse$MonitoringScheduleStatus' => '<p>The status of an monitoring job.</p>', 'ListMonitoringSchedulesRequest$StatusEquals' => '<p>A filter that returns only monitoring schedules modified before a specified time.</p>', 'MonitoringScheduleSummary$MonitoringScheduleStatus' => '<p>The status of the monitoring schedule.</p>', ], ], 'SearchExpression' => [ 'base' => '<p>A multi-expression that searches for the specified resource or resources in a search. All resource objects that satisfy the expression\'s condition are included in the search results. You must specify at least one subexpression, filter, or nested filter. A <code>SearchExpression</code> can contain up to twenty elements.</p> <p>A <code>SearchExpression</code> contains the following components:</p> <ul> <li> <p>A list of <code>Filter</code> objects. Each filter defines a simple Boolean expression comprised of a resource property name, Boolean operator, and value.</p> </li> <li> <p>A list of <code>NestedFilter</code> objects. Each nested filter defines a list of Boolean expressions using a list of resource properties. A nested filter is satisfied if a single object in the list satisfies all Boolean expressions.</p> </li> <li> <p>A list of <code>SearchExpression</code> objects. A search expression object can be nested in a list of search expression objects.</p> </li> <li> <p>A Boolean operator: <code>And</code> or <code>Or</code>.</p> </li> </ul>', 'refs' => [ 'SearchExpressionList$member' => NULL, 'SearchRequest$SearchExpression' => '<p>A Boolean conditional statement. Resources must satisfy this condition to be included in search results. You must provide at least one subexpression, filter, or nested filter. The maximum number of recursive <code>SubExpressions</code>, <code>NestedFilters</code>, and <code>Filters</code> that can be included in a <code>SearchExpression</code> object is 50.</p>', ], ], 'SearchExpressionList' => [ 'base' => NULL, 'refs' => [ 'SearchExpression$SubExpressions' => '<p>A list of search expression objects.</p>', ], ], 'SearchRecord' => [ 'base' => '<p>A single resource returned as part of the <a>Search</a> API response.</p>', 'refs' => [ 'SearchResultsList$member' => NULL, ], ], 'SearchRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchResultsList' => [ 'base' => NULL, 'refs' => [ 'SearchResponse$Results' => '<p>A list of <code>SearchRecord</code> objects.</p>', ], ], 'SearchSortOrder' => [ 'base' => NULL, 'refs' => [ 'SearchRequest$SortOrder' => '<p>How <code>SearchResults</code> are ordered. Valid values are <code>Ascending</code> or <code>Descending</code>. The default is <code>Descending</code>.</p>', ], ], 'SecondaryStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeTrainingJobResponse$SecondaryStatus' => '<p> Provides detailed information about the state of the training job. For detailed information on the secondary status of the training job, see <code>StatusMessage</code> under <a>SecondaryStatusTransition</a>.</p> <p>Amazon SageMaker provides primary statuses and secondary statuses that apply to each of them:</p> <dl> <dt>InProgress</dt> <dd> <ul> <li> <p> <code>Starting</code> - Starting the training job.</p> </li> <li> <p> <code>Downloading</code> - An optional stage for algorithms that support <code>File</code> training input mode. It indicates that data is being downloaded to the ML storage volumes.</p> </li> <li> <p> <code>Training</code> - Training is in progress.</p> </li> <li> <p> <code>Interrupted</code> - The job stopped because the managed spot training instances were interrupted. </p> </li> <li> <p> <code>Uploading</code> - Training is complete and the model artifacts are being uploaded to the S3 location.</p> </li> </ul> </dd> <dt>Completed</dt> <dd> <ul> <li> <p> <code>Completed</code> - The training job has completed.</p> </li> </ul> </dd> <dt>Failed</dt> <dd> <ul> <li> <p> <code>Failed</code> - The training job has failed. The reason for the failure is returned in the <code>FailureReason</code> field of <code>DescribeTrainingJobResponse</code>.</p> </li> </ul> </dd> <dt>Stopped</dt> <dd> <ul> <li> <p> <code>MaxRuntimeExceeded</code> - The job stopped because it exceeded the maximum allowed runtime.</p> </li> <li> <p> <code>MaxWaitTmeExceeded</code> - The job stopped because it exceeded the maximum allowed wait time.</p> </li> <li> <p> <code>Stopped</code> - The training job has stopped.</p> </li> </ul> </dd> <dt>Stopping</dt> <dd> <ul> <li> <p> <code>Stopping</code> - Stopping the training job.</p> </li> </ul> </dd> </dl> <important> <p>Valid values for <code>SecondaryStatus</code> are subject to change. </p> </important> <p>We no longer support the following secondary statuses:</p> <ul> <li> <p> <code>LaunchingMLInstances</code> </p> </li> <li> <p> <code>PreparingTrainingStack</code> </p> </li> <li> <p> <code>DownloadingTrainingImage</code> </p> </li> </ul>', 'SecondaryStatusTransition$Status' => '<p>Contains a secondary status information from a training job.</p> <p>Status might be one of the following secondary statuses:</p> <dl> <dt>InProgress</dt> <dd> <ul> <li> <p> <code>Starting</code> - Starting the training job.</p> </li> <li> <p> <code>Downloading</code> - An optional stage for algorithms that support <code>File</code> training input mode. It indicates that data is being downloaded to the ML storage volumes.</p> </li> <li> <p> <code>Training</code> - Training is in progress.</p> </li> <li> <p> <code>Uploading</code> - Training is complete and the model artifacts are being uploaded to the S3 location.</p> </li> </ul> </dd> <dt>Completed</dt> <dd> <ul> <li> <p> <code>Completed</code> - The training job has completed.</p> </li> </ul> </dd> <dt>Failed</dt> <dd> <ul> <li> <p> <code>Failed</code> - The training job has failed. The reason for the failure is returned in the <code>FailureReason</code> field of <code>DescribeTrainingJobResponse</code>.</p> </li> </ul> </dd> <dt>Stopped</dt> <dd> <ul> <li> <p> <code>MaxRuntimeExceeded</code> - The job stopped because it exceeded the maximum allowed runtime.</p> </li> <li> <p> <code>Stopped</code> - The training job has stopped.</p> </li> </ul> </dd> <dt>Stopping</dt> <dd> <ul> <li> <p> <code>Stopping</code> - Stopping the training job.</p> </li> </ul> </dd> </dl> <p>We no longer support the following secondary statuses:</p> <ul> <li> <p> <code>LaunchingMLInstances</code> </p> </li> <li> <p> <code>PreparingTrainingStack</code> </p> </li> <li> <p> <code>DownloadingTrainingImage</code> </p> </li> </ul>', 'TrainingJob$SecondaryStatus' => '<p> Provides detailed information about the state of the training job. For detailed information about the secondary status of the training job, see <code>StatusMessage</code> under <a>SecondaryStatusTransition</a>.</p> <p>Amazon SageMaker provides primary statuses and secondary statuses that apply to each of them:</p> <dl> <dt>InProgress</dt> <dd> <ul> <li> <p> <code>Starting</code> - Starting the training job.</p> </li> <li> <p> <code>Downloading</code> - An optional stage for algorithms that support <code>File</code> training input mode. It indicates that data is being downloaded to the ML storage volumes.</p> </li> <li> <p> <code>Training</code> - Training is in progress.</p> </li> <li> <p> <code>Uploading</code> - Training is complete and the model artifacts are being uploaded to the S3 location.</p> </li> </ul> </dd> <dt>Completed</dt> <dd> <ul> <li> <p> <code>Completed</code> - The training job has completed.</p> </li> </ul> </dd> <dt>Failed</dt> <dd> <ul> <li> <p> <code>Failed</code> - The training job has failed. The reason for the failure is returned in the <code>FailureReason</code> field of <code>DescribeTrainingJobResponse</code>.</p> </li> </ul> </dd> <dt>Stopped</dt> <dd> <ul> <li> <p> <code>MaxRuntimeExceeded</code> - The job stopped because it exceeded the maximum allowed runtime.</p> </li> <li> <p> <code>Stopped</code> - The training job has stopped.</p> </li> </ul> </dd> <dt>Stopping</dt> <dd> <ul> <li> <p> <code>Stopping</code> - Stopping the training job.</p> </li> </ul> </dd> </dl> <important> <p>Valid values for <code>SecondaryStatus</code> are subject to change. </p> </important> <p>We no longer support the following secondary statuses:</p> <ul> <li> <p> <code>LaunchingMLInstances</code> </p> </li> <li> <p> <code>PreparingTrainingStack</code> </p> </li> <li> <p> <code>DownloadingTrainingImage</code> </p> </li> </ul>', ], ], 'SecondaryStatusTransition' => [ 'base' => '<p>An array element of <a>DescribeTrainingJobResponse$SecondaryStatusTransitions</a>. It provides additional details about a status that the training job has transitioned through. A training job can be in one of several states, for example, starting, downloading, training, or uploading. Within each state, there are a number of intermediate states. For example, within the starting state, Amazon SageMaker could be starting the training job or launching the ML instances. These transitional states are referred to as the job\'s secondary status. </p> <p/>', 'refs' => [ 'SecondaryStatusTransitions$member' => NULL, ], ], 'SecondaryStatusTransitions' => [ 'base' => NULL, 'refs' => [ 'DescribeTrainingJobResponse$SecondaryStatusTransitions' => '<p>A history of all of the secondary statuses that the training job has transitioned through.</p>', 'TrainingJob$SecondaryStatusTransitions' => '<p>A history of all of the secondary statuses that the training job has transitioned through.</p>', ], ], 'SecretArn' => [ 'base' => NULL, 'refs' => [ 'GitConfig$SecretArn' => '<p>The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the credentials used to access the git repository. The secret must have a staging label of <code>AWSCURRENT</code> and must be in the following format:</p> <p> <code>{"username": <i>UserName</i>, "password": <i>Password</i>}</code> </p>', 'GitConfigForUpdate$SecretArn' => '<p>The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the credentials used to access the git repository. The secret must have a staging label of <code>AWSCURRENT</code> and must be in the following format:</p> <p> <code>{"username": <i>UserName</i>, "password": <i>Password</i>}</code> </p>', ], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'SecurityGroupIds$member' => NULL, 'VpcSecurityGroupIds$member' => NULL, ], ], 'SecurityGroupIds' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceInput$SecurityGroupIds' => '<p>The VPC security group IDs, in the form sg-xxxxxxxx. The security groups must be for the same VPC as specified in the subnet. </p>', 'DescribeNotebookInstanceOutput$SecurityGroups' => '<p>The IDs of the VPC security groups.</p>', 'UserSettings$SecurityGroups' => '<p>The security groups.</p>', ], ], 'Seed' => [ 'base' => NULL, 'refs' => [ 'ShuffleConfig$Seed' => '<p>Determines the shuffling order in <code>ShuffleConfig</code> value.</p>', ], ], 'SessionExpirationDurationInSeconds' => [ 'base' => NULL, 'refs' => [ 'CreatePresignedDomainUrlRequest$SessionExpirationDurationInSeconds' => '<p>The session expiration duration in seconds.</p>', 'CreatePresignedNotebookInstanceUrlInput$SessionExpirationDurationInSeconds' => '<p>The duration of the session, in seconds. The default is 12 hours.</p>', ], ], 'SharingSettings' => [ 'base' => '<p>Specifies options when sharing an Amazon SageMaker Studio notebook. These settings are specified as part of <code>DefaultUserSettings</code> when the <a>CreateDomain</a> API is called, and as part of <code>UserSettings</code> when the <a>CreateUserProfile</a> API is called.</p>', 'refs' => [ 'UserSettings$SharingSettings' => '<p>The sharing settings.</p>', ], ], 'ShuffleConfig' => [ 'base' => '<p>A configuration for a shuffle option for input data in a channel. If you use <code>S3Prefix</code> for <code>S3DataType</code>, the results of the S3 key prefix matches are shuffled. If you use <code>ManifestFile</code>, the order of the S3 object references in the <code>ManifestFile</code> is shuffled. If you use <code>AugmentedManifestFile</code>, the order of the JSON lines in the <code>AugmentedManifestFile</code> is shuffled. The shuffling order is determined using the <code>Seed</code> value.</p> <p>For Pipe input mode, when <code>ShuffleConfig</code> is specified shuffling is done at the start of every epoch. With large datasets, this ensures that the order of the training data is different for each epoch, and it helps reduce bias and possible overfitting. In a multi-node training job when <code>ShuffleConfig</code> is combined with <code>S3DataDistributionType</code> of <code>ShardedByS3Key</code>, the data is shuffled across nodes so that the content sent to a particular node on the first epoch might be sent to a different node on the second epoch.</p>', 'refs' => [ 'Channel$ShuffleConfig' => '<p>A configuration for a shuffle option for input data in a channel. If you use <code>S3Prefix</code> for <code>S3DataType</code>, this shuffles the results of the S3 key prefix matches. If you use <code>ManifestFile</code>, the order of the S3 object references in the <code>ManifestFile</code> is shuffled. If you use <code>AugmentedManifestFile</code>, the order of the JSON lines in the <code>AugmentedManifestFile</code> is shuffled. The shuffling order is determined using the <code>Seed</code> value.</p> <p>For Pipe input mode, shuffling is done at the start of every epoch. With large datasets this ensures that the order of the training data is different for each epoch, it helps reduce bias and possible overfitting. In a multi-node training job when ShuffleConfig is combined with <code>S3DataDistributionType</code> of <code>ShardedByS3Key</code>, the data is shuffled across nodes so that the content sent to a particular node on the first epoch might be sent to a different node on the second epoch.</p>', ], ], 'SingleSignOnUserIdentifier' => [ 'base' => NULL, 'refs' => [ 'CreateUserProfileRequest$SingleSignOnUserIdentifier' => '<p>A specifier for the type of value specified in SingleSignOnUserValue. Currently, the only supported value is "UserName". If the Domain\'s AuthMode is SSO, this field is required. If the Domain\'s AuthMode is not SSO, this field cannot be specified. </p>', 'DescribeUserProfileResponse$SingleSignOnUserIdentifier' => '<p>The SSO user identifier.</p>', ], ], 'SortBy' => [ 'base' => NULL, 'refs' => [ 'ListLabelingJobsRequest$SortBy' => '<p>The field to sort results by. The default is <code>CreationTime</code>.</p>', 'ListProcessingJobsRequest$SortBy' => '<p>The field to sort results by. The default is <code>CreationTime</code>.</p>', 'ListTrainingJobsRequest$SortBy' => '<p>The field to sort results by. The default is <code>CreationTime</code>.</p>', 'ListTransformJobsRequest$SortBy' => '<p>The field to sort results by. The default is <code>CreationTime</code>.</p>', ], ], 'SortExperimentsBy' => [ 'base' => NULL, 'refs' => [ 'ListExperimentsRequest$SortBy' => '<p>The property used to sort results. The default value is <code>CreationTime</code>.</p>', ], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'ListAlgorithmsInput$SortOrder' => '<p>The sort order for the results. The default is <code>Ascending</code>.</p>', 'ListAppsRequest$SortOrder' => '<p>The sort order for the results. The default is Ascending.</p>', 'ListCompilationJobsRequest$SortOrder' => '<p>The sort order for results. The default is <code>Ascending</code>.</p>', 'ListExperimentsRequest$SortOrder' => '<p>The sort order. The default value is <code>Descending</code>.</p>', 'ListFlowDefinitionsRequest$SortOrder' => '<p>An optional value that specifies whether you want the results sorted in <code>Ascending</code> or <code>Descending</code> order.</p>', 'ListHumanTaskUisRequest$SortOrder' => '<p>An optional value that specifies whether you want the results sorted in <code>Ascending</code> or <code>Descending</code> order.</p>', 'ListHyperParameterTuningJobsRequest$SortOrder' => '<p>The sort order for results. The default is <code>Ascending</code>.</p>', 'ListLabelingJobsForWorkteamRequest$SortOrder' => '<p>The sort order for results. The default is <code>Ascending</code>.</p>', 'ListLabelingJobsRequest$SortOrder' => '<p>The sort order for results. The default is <code>Ascending</code>.</p>', 'ListModelPackagesInput$SortOrder' => '<p>The sort order for the results. The default is <code>Ascending</code>.</p>', 'ListMonitoringExecutionsRequest$SortOrder' => '<p>Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is <code>Descending</code>.</p>', 'ListMonitoringSchedulesRequest$SortOrder' => '<p>Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is <code>Descending</code>.</p>', 'ListProcessingJobsRequest$SortOrder' => '<p>The sort order for results. The default is <code>Ascending</code>.</p>', 'ListTrainingJobsForHyperParameterTuningJobRequest$SortOrder' => '<p>The sort order for results. The default is <code>Ascending</code>.</p>', 'ListTrainingJobsRequest$SortOrder' => '<p>The sort order for results. The default is <code>Ascending</code>.</p>', 'ListTransformJobsRequest$SortOrder' => '<p>The sort order for results. The default is <code>Descending</code>.</p>', 'ListTrialComponentsRequest$SortOrder' => '<p>The sort order. The default value is <code>Descending</code>.</p>', 'ListTrialsRequest$SortOrder' => '<p>The sort order. The default value is <code>Descending</code>.</p>', 'ListUserProfilesRequest$SortOrder' => '<p>The sort order for the results. The default is Ascending.</p>', 'ListWorkforcesRequest$SortOrder' => '<p>Sort workforces in ascending or descending order.</p>', 'ListWorkteamsRequest$SortOrder' => '<p>The sort order for results. The default is <code>Ascending</code>.</p>', ], ], 'SortTrialComponentsBy' => [ 'base' => NULL, 'refs' => [ 'ListTrialComponentsRequest$SortBy' => '<p>The property used to sort results. The default value is <code>CreationTime</code>.</p>', ], ], 'SortTrialsBy' => [ 'base' => NULL, 'refs' => [ 'ListTrialsRequest$SortBy' => '<p>The property used to sort results. The default value is <code>CreationTime</code>.</p>', ], ], 'SourceAlgorithm' => [ 'base' => '<p>Specifies an algorithm that was used to create the model package. The algorithm must be either an algorithm resource in your Amazon SageMaker account or an algorithm in AWS Marketplace that you are subscribed to.</p>', 'refs' => [ 'SourceAlgorithmList$member' => NULL, ], ], 'SourceAlgorithmList' => [ 'base' => NULL, 'refs' => [ 'SourceAlgorithmSpecification$SourceAlgorithms' => '<p>A list of the algorithms that were used to create a model package.</p>', ], ], 'SourceAlgorithmSpecification' => [ 'base' => '<p>A list of algorithms that were used to create a model package.</p>', 'refs' => [ 'CreateModelPackageInput$SourceAlgorithmSpecification' => '<p>Details about the algorithm that was used to create the model package.</p>', 'DescribeModelPackageOutput$SourceAlgorithmSpecification' => '<p>Details about the algorithm that was used to create the model package.</p>', ], ], 'SourceIpConfig' => [ 'base' => '<p>A list of IP address ranges (<a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>). Used to create an allow list of IP addresses for a private workforce. For more information, see .</p>', 'refs' => [ 'CreateWorkforceRequest$SourceIpConfig' => NULL, 'UpdateWorkforceRequest$SourceIpConfig' => '<p>A list of one to ten worker IP address ranges (<a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>) that can be used to access tasks assigned to this workforce.</p> <p>Maximum: Ten CIDR values</p>', 'Workforce$SourceIpConfig' => '<p>A list of one to ten IP address ranges (<a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>) to be added to the workforce allow list.</p>', ], ], 'SourceType' => [ 'base' => NULL, 'refs' => [ 'ExperimentSource$SourceType' => '<p>The source type.</p>', 'TrialComponentSource$SourceType' => '<p>The source job type.</p>', 'TrialSource$SourceType' => '<p>The source job type.</p>', ], ], 'SplitType' => [ 'base' => NULL, 'refs' => [ 'TransformInput$SplitType' => '<p>The method to use to split the transform job\'s data files into smaller batches. Splitting is necessary when the total size of each object is too large to fit in a single request. You can also use data splitting to improve performance by processing multiple concurrent mini-batches. The default value for <code>SplitType</code> is <code>None</code>, which indicates that input data files are not split, and request payloads contain the entire contents of an input object. Set the value of this parameter to <code>Line</code> to split records on a newline character boundary. <code>SplitType</code> also supports a number of record-oriented binary data formats.</p> <p>When splitting is enabled, the size of a mini-batch depends on the values of the <code>BatchStrategy</code> and <code>MaxPayloadInMB</code> parameters. When the value of <code>BatchStrategy</code> is <code>MultiRecord</code>, Amazon SageMaker sends the maximum number of records in each request, up to the <code>MaxPayloadInMB</code> limit. If the value of <code>BatchStrategy</code> is <code>SingleRecord</code>, Amazon SageMaker sends individual records in each request.</p> <note> <p>Some data formats represent a record as a binary payload wrapped with extra padding bytes. When splitting is applied to a binary data format, padding is removed if the value of <code>BatchStrategy</code> is set to <code>SingleRecord</code>. Padding is not removed if the value of <code>BatchStrategy</code> is set to <code>MultiRecord</code>.</p> <p>For more information about <code>RecordIO</code>, see <a href="https://mxnet.apache.org/api/faq/recordio">Create a Dataset Using RecordIO</a> in the MXNet documentation. For more information about <code>TFRecord</code>, see <a href="https://www.tensorflow.org/guide/datasets#consuming_tfrecord_data">Consuming TFRecord data</a> in the TensorFlow documentation.</p> </note>', ], ], 'StartMonitoringScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartNotebookInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'StatusDetails' => [ 'base' => NULL, 'refs' => [ 'DebugRuleEvaluationStatus$StatusDetails' => '<p>Details from the rule evaluation.</p>', ], ], 'StatusMessage' => [ 'base' => NULL, 'refs' => [ 'SecondaryStatusTransition$StatusMessage' => '<p>A detailed description of the progress within a secondary status. </p> <p>Amazon SageMaker provides secondary statuses and status messages that apply to each of them:</p> <dl> <dt>Starting</dt> <dd> <ul> <li> <p>Starting the training job.</p> </li> <li> <p>Launching requested ML instances.</p> </li> <li> <p>Insufficient capacity error from EC2 while launching instances, retrying!</p> </li> <li> <p>Launched instance was unhealthy, replacing it!</p> </li> <li> <p>Preparing the instances for training.</p> </li> </ul> </dd> <dt>Training</dt> <dd> <ul> <li> <p>Downloading the training image.</p> </li> <li> <p>Training image download completed. Training in progress.</p> </li> </ul> </dd> </dl> <important> <p>Status messages are subject to change. Therefore, we recommend not including them in code that programmatically initiates actions. For examples, don\'t use status messages in if statements.</p> </important> <p>To have an overview of your training job\'s progress, view <code>TrainingJobStatus</code> and <code>SecondaryStatus</code> in <a>DescribeTrainingJob</a>, and <code>StatusMessage</code> together. For example, at the start of a training job, you might see the following:</p> <ul> <li> <p> <code>TrainingJobStatus</code> - InProgress</p> </li> <li> <p> <code>SecondaryStatus</code> - Training</p> </li> <li> <p> <code>StatusMessage</code> - Downloading the training image</p> </li> </ul>', ], ], 'StopAutoMLJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopCompilationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopHyperParameterTuningJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopLabelingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopMonitoringScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopNotebookInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'StopProcessingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopTrainingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopTransformJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StoppingCondition' => [ 'base' => '<p>Specifies a limit to how long a model training or compilation job can run. It also specifies how long you are willing to wait for a managed spot training job to complete. When the job reaches the time limit, Amazon SageMaker ends the training or compilation job. Use this API to cap model training costs.</p> <p>To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost. </p> <p>The training algorithms provided by Amazon SageMaker automatically save the intermediate results of a model training job when possible. This attempt to save artifacts is only a best effort case as model might not be in a state from which it can be saved. For example, if training has just started, the model might not be ready to save. When saved, this intermediate data is a valid model artifact. You can use it to create a model with <code>CreateModel</code>.</p> <note> <p>The Neural Topic Model (NTM) currently does not support saving intermediate model artifacts. When training NTMs, make sure that the maximum runtime is sufficient for the training job to complete.</p> </note>', 'refs' => [ 'CreateCompilationJobRequest$StoppingCondition' => '<p>Specifies a limit to how long a model compilation job can run. When the job reaches the time limit, Amazon SageMaker ends the compilation job. Use this API to cap model training costs.</p>', 'CreateTrainingJobRequest$StoppingCondition' => '<p>Specifies a limit to how long a model training job can run. When the job reaches the time limit, Amazon SageMaker ends the training job. Use this API to cap model training costs.</p> <p>To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost. </p>', 'DescribeCompilationJobResponse$StoppingCondition' => '<p>Specifies a limit to how long a model compilation job can run. When the job reaches the time limit, Amazon SageMaker ends the compilation job. Use this API to cap model training costs.</p>', 'DescribeTrainingJobResponse$StoppingCondition' => '<p>Specifies a limit to how long a model training job can run. It also specifies the maximum time to wait for a spot instance. When the job reaches the time limit, Amazon SageMaker ends the training job. Use this API to cap model training costs.</p> <p>To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost. </p>', 'HyperParameterTrainingJobDefinition$StoppingCondition' => '<p>Specifies a limit to how long a model hyperparameter training job can run. It also specifies how long you are willing to wait for a managed spot training job to complete. When the job reaches the a limit, Amazon SageMaker ends the training job. Use this API to cap model training costs.</p>', 'TrainingJob$StoppingCondition' => '<p>Specifies a limit to how long a model training job can run. When the job reaches the time limit, Amazon SageMaker ends the training job. Use this API to cap model training costs.</p> <p>To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost. </p>', 'TrainingJobDefinition$StoppingCondition' => '<p>Specifies a limit to how long a model training job can run. When the job reaches the time limit, Amazon SageMaker ends the training job. Use this API to cap model training costs.</p> <p>To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AlgorithmStatusItem$FailureReason' => '<p>if the overall status is <code>Failed</code>, the reason for the failure.</p>', 'ListProcessingJobsRequest$NameContains' => '<p>A string in the processing job name. This filter returns only processing jobs whose name contains the specified string.</p>', 'ModelPackageStatusItem$FailureReason' => '<p>if the overall status is <code>Failed</code>, the reason for the failure.</p>', 'ProcessingInput$InputName' => '<p>The name of the inputs for the processing job.</p>', 'ProcessingOutput$OutputName' => '<p>The name for the processing job output.</p>', 'ProductListings$member' => NULL, 'RenderUiTemplateResponse$RenderedContent' => '<p>A Liquid template that renders the HTML for the worker UI.</p>', 'RenderingError$Code' => '<p>A unique identifier for a specific class of errors.</p>', 'RenderingError$Message' => '<p>A human-readable message describing the error.</p>', 'SubscribedWorkteam$SellerName' => '<p>The name of the vendor in the Amazon Marketplace.</p>', 'SubscribedWorkteam$ListingId' => '<p>Marketplace product listing ID.</p>', 'UserContext$UserProfileArn' => '<p>The Amazon Resource Name (ARN) of the user\'s profile.</p>', 'UserContext$UserProfileName' => '<p>The name of the user\'s profile.</p>', 'UserContext$DomainId' => '<p>The domain associated with the user.</p>', 'Workforce$SubDomain' => '<p>The subdomain for your OIDC Identity Provider.</p>', 'Workteam$SubDomain' => '<p>The URI of the labeling job\'s user interface. Workers open this URI to start labeling your data objects.</p>', ], ], 'String1024' => [ 'base' => NULL, 'refs' => [ 'CreateDomainResponse$Url' => '<p>The URL to the created domain.</p>', 'DescribeDomainResponse$Url' => '<p>The domain\'s URL.</p>', 'DomainDetails$Url' => '<p>The domain\'s URL.</p>', ], ], 'String200' => [ 'base' => NULL, 'refs' => [ 'CreateWorkteamRequest$Description' => '<p>A description of the work team.</p>', 'SubscribedWorkteam$MarketplaceTitle' => '<p>The title of the service provided by the vendor in the Amazon Marketplace.</p>', 'SubscribedWorkteam$MarketplaceDescription' => '<p>The description of the vendor from the Amazon Marketplace.</p>', 'UpdateWorkteamRequest$Description' => '<p>An updated description for the work team.</p>', 'Workteam$Description' => '<p>A description of the work team.</p>', ], ], 'String256' => [ 'base' => NULL, 'refs' => [ 'CreateUserProfileRequest$SingleSignOnUserValue' => '<p>The username of the associated AWS Single Sign-On User for this UserProfile. If the Domain\'s AuthMode is SSO, this field is required, and must match a valid username of a user in your directory. If the Domain\'s AuthMode is not SSO, this field cannot be specified. </p>', 'DescribeDomainResponse$SingleSignOnManagedApplicationInstanceId' => '<p>The SSO managed application instance ID.</p>', 'DescribeUserProfileResponse$SingleSignOnUserValue' => '<p>The SSO user value.</p>', 'ListTrialComponentsRequest$SourceArn' => '<p>A filter that returns only components that have the specified source Amazon Resource Name (ARN). If you specify <code>SourceArn</code>, you can\'t filter by <code>ExperimentName</code> or <code>TrialName</code>.</p>', ], ], 'StringParameterValue' => [ 'base' => NULL, 'refs' => [ 'TrialComponentParameterValue$StringValue' => '<p>The string value of a categorical hyperparameter. If you specify a value for this parameter, you can\'t specify the <code>NumberValue</code> parameter.</p>', ], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceInput$SubnetId' => '<p>The ID of the subnet in a VPC to which you would like to have a connectivity from your ML compute instance. </p>', 'DescribeNotebookInstanceOutput$SubnetId' => '<p>The ID of the VPC subnet.</p>', 'Subnets$member' => NULL, ], ], 'Subnets' => [ 'base' => NULL, 'refs' => [ 'CreateDomainRequest$SubnetIds' => '<p>The VPC subnets to use for communication with the EFS volume.</p>', 'DescribeDomainResponse$SubnetIds' => '<p>Security setting to limit to a set of subnets.</p>', 'VpcConfig$Subnets' => '<p>The ID of the subnets in the VPC to which you want to connect your training job or model. For information about the availability of specific instance types, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html">Supported Instance Types and Availability Zones</a>.</p>', ], ], 'SubscribedWorkteam' => [ 'base' => '<p>Describes a work team of a vendor that does the a labelling job.</p>', 'refs' => [ 'DescribeSubscribedWorkteamResponse$SubscribedWorkteam' => '<p>A <code>Workteam</code> instance that contains information about the work team.</p>', 'SubscribedWorkteams$member' => NULL, ], ], 'SubscribedWorkteams' => [ 'base' => NULL, 'refs' => [ 'ListSubscribedWorkteamsResponse$SubscribedWorkteams' => '<p>An array of <code>Workteam</code> objects, each describing a work team.</p>', ], ], 'Success' => [ 'base' => NULL, 'refs' => [ 'DeleteWorkteamResponse$Success' => '<p>Returns <code>true</code> if the work team was successfully deleted; otherwise, returns <code>false</code>.</p>', ], ], 'SuggestionQuery' => [ 'base' => '<p>Specified in the <a>GetSearchSuggestions</a> request. Limits the property names that are included in the response.</p>', 'refs' => [ 'GetSearchSuggestionsRequest$SuggestionQuery' => '<p>Limits the property names that are included in the response.</p>', ], ], 'Tag' => [ 'base' => '<p>Describes a tag. </p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The tag key.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'DeleteTagsInput$TagKeys' => '<p>An array or one or more tag keys to delete.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'AddTagsInput$Tags' => '<p>An array of <code>Tag</code> objects. Each tag is a key-value pair. Only the <code>key</code> parameter is required. If you don\'t specify a value, Amazon SageMaker sets the value to an empty string. </p>', 'AddTagsOutput$Tags' => '<p>A list of tags associated with the Amazon SageMaker resource.</p>', 'CreateAppRequest$Tags' => '<p>Each tag consists of a key and an optional value. Tag keys must be unique per resource.</p>', 'CreateAutoMLJobRequest$Tags' => '<p>Each tag consists of a key and an optional value. Tag keys must be unique per resource.</p>', 'CreateDomainRequest$Tags' => '<p>Tags to associated with the Domain. Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the <a>Search</a> API.</p>', 'CreateEndpointConfigInput$Tags' => '<p>A list of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> in the <i> AWS Billing and Cost Management User Guide</i>. </p>', 'CreateEndpointInput$Tags' => '<p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a>in the <i>AWS Billing and Cost Management User Guide</i>. </p>', 'CreateExperimentRequest$Tags' => '<p>A list of tags to associate with the experiment. You can use <a>Search</a> API to search on the tags.</p>', 'CreateFlowDefinitionRequest$Tags' => '<p>An array of key-value pairs that contain metadata to help you categorize and organize a flow definition. Each tag consists of a key and a value, both of which you define.</p>', 'CreateHumanTaskUiRequest$Tags' => '<p>An array of key-value pairs that contain metadata to help you categorize and organize a human review workflow user interface. Each tag consists of a key and a value, both of which you define.</p>', 'CreateHyperParameterTuningJobRequest$Tags' => '<p>An array of key-value pairs. You can use tags to categorize your AWS resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">AWS Tagging Strategies</a>.</p> <p>Tags that you specify for the tuning job are also added to all training jobs that the tuning job launches.</p>', 'CreateLabelingJobRequest$Tags' => '<p>An array of key/value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.</p>', 'CreateModelInput$Tags' => '<p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>. </p>', 'CreateMonitoringScheduleRequest$Tags' => '<p>(Optional) An array of key-value pairs. For more information, see <a href=" https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.</p>', 'CreateNotebookInstanceInput$Tags' => '<p>A list of tags to associate with the notebook instance. You can add tags later by using the <code>CreateTags</code> API.</p>', 'CreateProcessingJobRequest$Tags' => '<p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.</p>', 'CreateTrainingJobRequest$Tags' => '<p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>. </p>', 'CreateTransformJobRequest$Tags' => '<p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.</p>', 'CreateTrialComponentRequest$Tags' => '<p>A list of tags to associate with the component. You can use <a>Search</a> API to search on the tags.</p>', 'CreateTrialRequest$Tags' => '<p>A list of tags to associate with the trial. You can use <a>Search</a> API to search on the tags.</p>', 'CreateUserProfileRequest$Tags' => '<p>Each tag consists of a key and an optional value. Tag keys must be unique per resource.</p>', 'CreateWorkforceRequest$Tags' => '<p>An array of key-value pairs that contain metadata to help you categorize and organize our workforce. Each tag consists of a key and a value, both of which you define.</p>', 'CreateWorkteamRequest$Tags' => '<p>An array of key-value pairs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Resource Tag</a> and <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> in the <i> AWS Billing and Cost Management User Guide</i>.</p>', 'DescribeLabelingJobResponse$Tags' => '<p>An array of key/value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.</p>', 'Experiment$Tags' => '<p>The list of tags that are associated with the experiment. You can use <a>Search</a> API to search on the tags.</p>', 'ListTagsOutput$Tags' => '<p>An array of <code>Tag</code> objects, each with a tag key and a value.</p>', 'ProcessingJob$Tags' => '<p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.</p>', 'TrainingJob$Tags' => '<p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.</p>', 'TransformJob$Tags' => '<p>A list of tags associated with the transform job.</p>', 'Trial$Tags' => '<p>The list of tags that are associated with the trial. You can use <a>Search</a> API to search on the tags.</p>', 'TrialComponent$Tags' => '<p>The list of tags that are associated with the component. You can use <a>Search</a> API to search on the tags.</p>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The tag value.</p>', ], ], 'TargetAttributeName' => [ 'base' => NULL, 'refs' => [ 'AutoMLChannel$TargetAttributeName' => '<p>The name of the target variable in supervised learning, a.k.a. \'y\'.</p>', ], ], 'TargetDevice' => [ 'base' => NULL, 'refs' => [ 'CompilationJobSummary$CompilationTargetDevice' => '<p>The type of device that the model will run on after the compilation job has completed.</p>', 'OutputConfig$TargetDevice' => '<p>Identifies the target device or the machine learning instance that you want to run your model on after the compilation has completed. Alternatively, you can specify OS, architecture, and accelerator using <a>TargetPlatform</a> fields. It can be used instead of <code>TargetPlatform</code>.</p>', ], ], 'TargetObjectiveMetricValue' => [ 'base' => NULL, 'refs' => [ 'TuningJobCompletionCriteria$TargetObjectiveMetricValue' => '<p>The objective metric\'s value.</p>', ], ], 'TargetPlatform' => [ 'base' => '<p>Contains information about a target platform that you want your model to run on, such as OS, architecture, and accelerators. It is an alternative of <code>TargetDevice</code>.</p>', 'refs' => [ 'OutputConfig$TargetPlatform' => '<p>Contains information about a target platform that you want your model to run on, such as OS, architecture, and accelerators. It is an alternative of <code>TargetDevice</code>.</p> <p>The following examples show how to configure the <code>TargetPlatform</code> and <code>CompilerOptions</code> JSON strings for popular target platforms: </p> <ul> <li> <p>Raspberry Pi 3 Model B+</p> <p> <code>"TargetPlatform": {"Os": "LINUX", "Arch": "ARM_EABIHF"},</code> </p> <p> <code> "CompilerOptions": {\'mattr\': [\'+neon\']}</code> </p> </li> <li> <p>Jetson TX2</p> <p> <code>"TargetPlatform": {"Os": "LINUX", "Arch": "ARM64", "Accelerator": "NVIDIA"},</code> </p> <p> <code> "CompilerOptions": {\'gpu-code\': \'sm_62\', \'trt-ver\': \'6.0.1\', \'cuda-ver\': \'10.0\'}</code> </p> </li> <li> <p>EC2 m5.2xlarge instance OS</p> <p> <code>"TargetPlatform": {"Os": "LINUX", "Arch": "X86_64", "Accelerator": "NVIDIA"},</code> </p> <p> <code> "CompilerOptions": {\'mcpu\': \'skylake-avx512\'}</code> </p> </li> <li> <p>RK3399</p> <p> <code>"TargetPlatform": {"Os": "LINUX", "Arch": "ARM64", "Accelerator": "MALI"}</code> </p> </li> <li> <p>ARMv7 phone (CPU)</p> <p> <code>"TargetPlatform": {"Os": "ANDROID", "Arch": "ARM_EABI"},</code> </p> <p> <code> "CompilerOptions": {\'ANDROID_PLATFORM\': 25, \'mattr\': [\'+neon\']}</code> </p> </li> <li> <p>ARMv8 phone (CPU)</p> <p> <code>"TargetPlatform": {"Os": "ANDROID", "Arch": "ARM64"},</code> </p> <p> <code> "CompilerOptions": {\'ANDROID_PLATFORM\': 29}</code> </p> </li> </ul>', ], ], 'TargetPlatformAccelerator' => [ 'base' => NULL, 'refs' => [ 'CompilationJobSummary$CompilationTargetPlatformAccelerator' => '<p>The type of accelerator that the model will run on after the compilation job has completed.</p>', 'TargetPlatform$Accelerator' => '<p>Specifies a target platform accelerator (optional).</p> <ul> <li> <p> <code>NVIDIA</code>: Nvidia graphics processing unit. It also requires <code>gpu-code</code>, <code>trt-ver</code>, <code>cuda-ver</code> compiler options</p> </li> <li> <p> <code>MALI</code>: ARM Mali graphics processor</p> </li> <li> <p> <code>INTEL_GRAPHICS</code>: Integrated Intel graphics</p> </li> </ul>', ], ], 'TargetPlatformArch' => [ 'base' => NULL, 'refs' => [ 'CompilationJobSummary$CompilationTargetPlatformArch' => '<p>The type of architecture that the model will run on after the compilation job has completed.</p>', 'TargetPlatform$Arch' => '<p>Specifies a target platform architecture.</p> <ul> <li> <p> <code>X86_64</code>: 64-bit version of the x86 instruction set.</p> </li> <li> <p> <code>X86</code>: 32-bit version of the x86 instruction set.</p> </li> <li> <p> <code>ARM64</code>: ARMv8 64-bit CPU.</p> </li> <li> <p> <code>ARM_EABIHF</code>: ARMv7 32-bit, Hard Float.</p> </li> <li> <p> <code>ARM_EABI</code>: ARMv7 32-bit, Soft Float. Used by Android 32-bit ARM platform.</p> </li> </ul>', ], ], 'TargetPlatformOs' => [ 'base' => NULL, 'refs' => [ 'CompilationJobSummary$CompilationTargetPlatformOs' => '<p>The type of OS that the model will run on after the compilation job has completed.</p>', 'TargetPlatform$Os' => '<p>Specifies a target platform OS.</p> <ul> <li> <p> <code>LINUX</code>: Linux-based operating systems.</p> </li> <li> <p> <code>ANDROID</code>: Android operating systems. Android API level can be specified using the <code>ANDROID_PLATFORM</code> compiler option. For example, <code>"CompilerOptions": {\'ANDROID_PLATFORM\': 28}</code> </p> </li> </ul>', ], ], 'TaskAvailabilityLifetimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'HumanTaskConfig$TaskAvailabilityLifetimeInSeconds' => '<p>The length of time that a task remains available for labeling by human workers. <b>If you choose the Amazon Mechanical Turk workforce, the maximum is 12 hours (43200)</b>. The default value is 864000 seconds (10 days). For private and vendor workforces, the maximum is as listed.</p>', ], ], 'TaskCount' => [ 'base' => NULL, 'refs' => [ 'DesiredWeightAndCapacity$DesiredInstanceCount' => '<p>The variant\'s capacity.</p>', 'ProductionVariant$InitialInstanceCount' => '<p>Number of instances to launch initially.</p>', 'ProductionVariantSummary$CurrentInstanceCount' => '<p>The number of instances associated with the variant.</p>', 'ProductionVariantSummary$DesiredInstanceCount' => '<p>The number of instances requested in the <code>UpdateEndpointWeightsAndCapacities</code> request. </p>', ], ], 'TaskDescription' => [ 'base' => NULL, 'refs' => [ 'HumanTaskConfig$TaskDescription' => '<p>A description of the task for your human workers.</p>', ], ], 'TaskInput' => [ 'base' => NULL, 'refs' => [ 'RenderableTask$Input' => '<p>A JSON object that contains values for the variables defined in the template. It is made available to the template under the substitution variable <code>task.input</code>. For example, if you define a variable <code>task.input.text</code> in your template, you can supply the variable in the JSON object as <code>"text": "sample text"</code>.</p>', ], ], 'TaskKeyword' => [ 'base' => NULL, 'refs' => [ 'TaskKeywords$member' => NULL, ], ], 'TaskKeywords' => [ 'base' => NULL, 'refs' => [ 'HumanTaskConfig$TaskKeywords' => '<p>Keywords used to describe the task so that workers on Amazon Mechanical Turk can discover the task.</p>', ], ], 'TaskTimeLimitInSeconds' => [ 'base' => NULL, 'refs' => [ 'HumanTaskConfig$TaskTimeLimitInSeconds' => '<p>The amount of time that a worker has to complete a task.</p>', ], ], 'TaskTitle' => [ 'base' => NULL, 'refs' => [ 'HumanTaskConfig$TaskTitle' => '<p>A title for the task for your human workers.</p>', ], ], 'TemplateContent' => [ 'base' => NULL, 'refs' => [ 'UiTemplate$Content' => '<p>The content of the Liquid template for the worker user interface.</p>', ], ], 'TemplateContentSha256' => [ 'base' => NULL, 'refs' => [ 'UiTemplateInfo$ContentSha256' => '<p>The SHA-256 digest of the contents of the template.</p>', ], ], 'TemplateUrl' => [ 'base' => NULL, 'refs' => [ 'UiTemplateInfo$Url' => '<p>The URL for the user interface template.</p>', ], ], 'TensorBoardAppSettings' => [ 'base' => '<p>The TensorBoard app settings.</p>', 'refs' => [ 'UserSettings$TensorBoardAppSettings' => '<p>The TensorBoard app settings.</p>', ], ], 'TensorBoardOutputConfig' => [ 'base' => '<p>Configuration of storage locations for TensorBoard output.</p>', 'refs' => [ 'CreateTrainingJobRequest$TensorBoardOutputConfig' => NULL, 'DescribeTrainingJobResponse$TensorBoardOutputConfig' => NULL, 'TrainingJob$TensorBoardOutputConfig' => NULL, ], ], 'TenthFractionsOfACent' => [ 'base' => NULL, 'refs' => [ 'USD$TenthFractionsOfACent' => '<p>Fractions of a cent, in tenths.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AutoMLCandidate$CreationTime' => '<p>The creation time.</p>', 'AutoMLCandidate$EndTime' => '<p>The end time.</p>', 'AutoMLCandidate$LastModifiedTime' => '<p>The last modified time.</p>', 'AutoMLJobSummary$CreationTime' => '<p>When the job was created.</p>', 'AutoMLJobSummary$EndTime' => '<p>The end time.</p>', 'AutoMLJobSummary$LastModifiedTime' => '<p>When the job was last modified.</p>', 'CompilationJobSummary$CompilationStartTime' => '<p>The time when the model compilation job started.</p>', 'CompilationJobSummary$CompilationEndTime' => '<p>The time when the model compilation job completed.</p>', 'CreateTrialComponentRequest$StartTime' => '<p>When the component started.</p>', 'CreateTrialComponentRequest$EndTime' => '<p>When the component ended.</p>', 'DebugRuleEvaluationStatus$LastModifiedTime' => '<p>Timestamp when the rule evaluation status was last modified.</p>', 'DeployedImage$ResolutionTime' => '<p>The date and time when the image path for the model resolved to the <code>ResolvedImage</code> </p>', 'DescribeAppResponse$LastHealthCheckTimestamp' => '<p>The timestamp of the last health check.</p>', 'DescribeAppResponse$LastUserActivityTimestamp' => '<p>The timestamp of the last user\'s activity.</p>', 'DescribeAutoMLJobResponse$CreationTime' => '<p>Returns the job\'s creation time.</p>', 'DescribeAutoMLJobResponse$EndTime' => '<p>Returns the job\'s end time.</p>', 'DescribeAutoMLJobResponse$LastModifiedTime' => '<p>Returns the job\'s last modified time.</p>', 'DescribeCompilationJobResponse$CompilationStartTime' => '<p>The time when the model compilation job started the <code>CompilationJob</code> instances. </p> <p>You are billed for the time between this timestamp and the timestamp in the <a>DescribeCompilationJobResponse$CompilationEndTime</a> field. In Amazon CloudWatch Logs, the start time might be later than this time. That\'s because it takes time to download the compilation job, which depends on the size of the compilation job container. </p>', 'DescribeCompilationJobResponse$CompilationEndTime' => '<p>The time when the model compilation job on a compilation job instance ended. For a successful or stopped job, this is when the job\'s model artifacts have finished uploading. For a failed job, this is when Amazon SageMaker detected that the job failed. </p>', 'DescribeEndpointConfigOutput$CreationTime' => '<p>A timestamp that shows when the endpoint configuration was created.</p>', 'DescribeEndpointOutput$CreationTime' => '<p>A timestamp that shows when the endpoint was created.</p>', 'DescribeEndpointOutput$LastModifiedTime' => '<p>A timestamp that shows when the endpoint was last modified.</p>', 'DescribeExperimentResponse$CreationTime' => '<p>When the experiment was created.</p>', 'DescribeExperimentResponse$LastModifiedTime' => '<p>When the experiment was last modified.</p>', 'DescribeFlowDefinitionResponse$CreationTime' => '<p>The timestamp when the flow definition was created.</p>', 'DescribeHumanTaskUiResponse$CreationTime' => '<p>The timestamp when the human task user interface was created.</p>', 'DescribeHyperParameterTuningJobResponse$CreationTime' => '<p>The date and time that the tuning job started.</p>', 'DescribeHyperParameterTuningJobResponse$HyperParameterTuningEndTime' => '<p>The date and time that the tuning job ended.</p>', 'DescribeHyperParameterTuningJobResponse$LastModifiedTime' => '<p>The date and time that the status of the tuning job was modified. </p>', 'DescribeLabelingJobResponse$CreationTime' => '<p>The date and time that the labeling job was created.</p>', 'DescribeLabelingJobResponse$LastModifiedTime' => '<p>The date and time that the labeling job was last updated.</p>', 'DescribeModelOutput$CreationTime' => '<p>A timestamp that shows when the model was created.</p>', 'DescribeMonitoringScheduleResponse$CreationTime' => '<p>The time at which the monitoring job was created.</p>', 'DescribeMonitoringScheduleResponse$LastModifiedTime' => '<p>The time at which the monitoring job was last modified.</p>', 'DescribeProcessingJobResponse$ProcessingEndTime' => '<p>The time at which the processing job completed.</p>', 'DescribeProcessingJobResponse$ProcessingStartTime' => '<p>The time at which the processing job started.</p>', 'DescribeProcessingJobResponse$LastModifiedTime' => '<p>The time at which the processing job was last modified.</p>', 'DescribeProcessingJobResponse$CreationTime' => '<p>The time at which the processing job was created.</p>', 'DescribeTrainingJobResponse$CreationTime' => '<p>A timestamp that indicates when the training job was created.</p>', 'DescribeTrainingJobResponse$TrainingStartTime' => '<p>Indicates the time when the training job starts on training instances. You are billed for the time interval between this time and the value of <code>TrainingEndTime</code>. The start time in CloudWatch Logs might be later than this time. The difference is due to the time it takes to download the training data and to the size of the training container.</p>', 'DescribeTrainingJobResponse$TrainingEndTime' => '<p>Indicates the time when the training job ends on training instances. You are billed for the time interval between the value of <code>TrainingStartTime</code> and this time. For successful jobs and stopped jobs, this is the time after model artifacts are uploaded. For failed jobs, this is the time when Amazon SageMaker detects a job failure.</p>', 'DescribeTrainingJobResponse$LastModifiedTime' => '<p>A timestamp that indicates when the status of the training job was last modified.</p>', 'DescribeTransformJobResponse$CreationTime' => '<p>A timestamp that shows when the transform Job was created.</p>', 'DescribeTransformJobResponse$TransformStartTime' => '<p>Indicates when the transform job starts on ML instances. You are billed for the time interval between this time and the value of <code>TransformEndTime</code>.</p>', 'DescribeTransformJobResponse$TransformEndTime' => '<p>Indicates when the transform job has been completed, or has stopped or failed. You are billed for the time interval between this time and the value of <code>TransformStartTime</code>.</p>', 'DescribeTrialComponentResponse$StartTime' => '<p>When the component started.</p>', 'DescribeTrialComponentResponse$EndTime' => '<p>When the component ended.</p>', 'DescribeTrialComponentResponse$CreationTime' => '<p>When the component was created.</p>', 'DescribeTrialComponentResponse$LastModifiedTime' => '<p>When the component was last modified.</p>', 'DescribeTrialResponse$CreationTime' => '<p>When the trial was created.</p>', 'DescribeTrialResponse$LastModifiedTime' => '<p>When the trial was last modified.</p>', 'EndpointConfigSummary$CreationTime' => '<p>A timestamp that shows when the endpoint configuration was created.</p>', 'EndpointSummary$CreationTime' => '<p>A timestamp that shows when the endpoint was created.</p>', 'EndpointSummary$LastModifiedTime' => '<p>A timestamp that shows when the endpoint was last modified.</p>', 'Experiment$CreationTime' => '<p>When the experiment was created.</p>', 'Experiment$LastModifiedTime' => '<p>When the experiment was last modified.</p>', 'ExperimentSummary$CreationTime' => '<p>When the experiment was created.</p>', 'ExperimentSummary$LastModifiedTime' => '<p>When the experiment was last modified.</p>', 'FlowDefinitionSummary$CreationTime' => '<p>The timestamp when SageMaker created the flow definition.</p>', 'HumanTaskUiSummary$CreationTime' => '<p>A timestamp when SageMaker created the human task user interface.</p>', 'HyperParameterTrainingJobSummary$CreationTime' => '<p>The date and time that the training job was created.</p>', 'HyperParameterTrainingJobSummary$TrainingStartTime' => '<p>The date and time that the training job started.</p>', 'HyperParameterTrainingJobSummary$TrainingEndTime' => '<p>Specifies the time when the training job ends on training instances. You are billed for the time interval between the value of <code>TrainingStartTime</code> and this time. For successful jobs and stopped jobs, this is the time after model artifacts are uploaded. For failed jobs, this is the time when Amazon SageMaker detects a job failure.</p>', 'HyperParameterTuningJobSummary$CreationTime' => '<p>The date and time that the tuning job was created.</p>', 'HyperParameterTuningJobSummary$HyperParameterTuningEndTime' => '<p>The date and time that the tuning job ended.</p>', 'HyperParameterTuningJobSummary$LastModifiedTime' => '<p>The date and time that the tuning job was modified.</p>', 'LabelingJobForWorkteamSummary$CreationTime' => '<p>The date and time that the labeling job was created.</p>', 'LabelingJobSummary$CreationTime' => '<p>The date and time that the job was created (timestamp).</p>', 'LabelingJobSummary$LastModifiedTime' => '<p>The date and time that the job was last modified (timestamp).</p>', 'ListAutoMLJobsRequest$CreationTimeAfter' => '<p>Request a list of jobs, using a filter for time.</p>', 'ListAutoMLJobsRequest$CreationTimeBefore' => '<p>Request a list of jobs, using a filter for time.</p>', 'ListAutoMLJobsRequest$LastModifiedTimeAfter' => '<p>Request a list of jobs, using a filter for time.</p>', 'ListAutoMLJobsRequest$LastModifiedTimeBefore' => '<p>Request a list of jobs, using a filter for time.</p>', 'ListCodeRepositoriesInput$LastModifiedTimeAfter' => '<p>A filter that returns only Git repositories that were last modified after the specified time.</p>', 'ListCodeRepositoriesInput$LastModifiedTimeBefore' => '<p>A filter that returns only Git repositories that were last modified before the specified time.</p>', 'ListEndpointConfigsInput$CreationTimeBefore' => '<p>A filter that returns only endpoint configurations created before the specified time (timestamp).</p>', 'ListEndpointConfigsInput$CreationTimeAfter' => '<p>A filter that returns only endpoint configurations with a creation time greater than or equal to the specified time (timestamp).</p>', 'ListEndpointsInput$CreationTimeBefore' => '<p>A filter that returns only endpoints that were created before the specified time (timestamp).</p>', 'ListEndpointsInput$CreationTimeAfter' => '<p>A filter that returns only endpoints with a creation time greater than or equal to the specified time (timestamp).</p>', 'ListEndpointsInput$LastModifiedTimeBefore' => '<p> A filter that returns only endpoints that were modified before the specified timestamp. </p>', 'ListEndpointsInput$LastModifiedTimeAfter' => '<p> A filter that returns only endpoints that were modified after the specified timestamp. </p>', 'ListExperimentsRequest$CreatedAfter' => '<p>A filter that returns only experiments created after the specified time.</p>', 'ListExperimentsRequest$CreatedBefore' => '<p>A filter that returns only experiments created before the specified time.</p>', 'ListFlowDefinitionsRequest$CreationTimeAfter' => '<p>A filter that returns only flow definitions with a creation time greater than or equal to the specified timestamp.</p>', 'ListFlowDefinitionsRequest$CreationTimeBefore' => '<p>A filter that returns only flow definitions that were created before the specified timestamp.</p>', 'ListHumanTaskUisRequest$CreationTimeAfter' => '<p>A filter that returns only human task user interfaces with a creation time greater than or equal to the specified timestamp.</p>', 'ListHumanTaskUisRequest$CreationTimeBefore' => '<p>A filter that returns only human task user interfaces that were created before the specified timestamp.</p>', 'ListHyperParameterTuningJobsRequest$CreationTimeAfter' => '<p>A filter that returns only tuning jobs that were created after the specified time.</p>', 'ListHyperParameterTuningJobsRequest$CreationTimeBefore' => '<p>A filter that returns only tuning jobs that were created before the specified time.</p>', 'ListHyperParameterTuningJobsRequest$LastModifiedTimeAfter' => '<p>A filter that returns only tuning jobs that were modified after the specified time.</p>', 'ListHyperParameterTuningJobsRequest$LastModifiedTimeBefore' => '<p>A filter that returns only tuning jobs that were modified before the specified time.</p>', 'ListLabelingJobsForWorkteamRequest$CreationTimeAfter' => '<p>A filter that returns only labeling jobs created after the specified time (timestamp).</p>', 'ListLabelingJobsForWorkteamRequest$CreationTimeBefore' => '<p>A filter that returns only labeling jobs created before the specified time (timestamp).</p>', 'ListLabelingJobsRequest$CreationTimeAfter' => '<p>A filter that returns only labeling jobs created after the specified time (timestamp).</p>', 'ListLabelingJobsRequest$CreationTimeBefore' => '<p>A filter that returns only labeling jobs created before the specified time (timestamp).</p>', 'ListLabelingJobsRequest$LastModifiedTimeAfter' => '<p>A filter that returns only labeling jobs modified after the specified time (timestamp).</p>', 'ListLabelingJobsRequest$LastModifiedTimeBefore' => '<p>A filter that returns only labeling jobs modified before the specified time (timestamp).</p>', 'ListModelsInput$CreationTimeBefore' => '<p>A filter that returns only models created before the specified time (timestamp).</p>', 'ListModelsInput$CreationTimeAfter' => '<p>A filter that returns only models with a creation time greater than or equal to the specified time (timestamp).</p>', 'ListMonitoringExecutionsRequest$ScheduledTimeBefore' => '<p>Filter for jobs scheduled before a specified time.</p>', 'ListMonitoringExecutionsRequest$ScheduledTimeAfter' => '<p>Filter for jobs scheduled after a specified time.</p>', 'ListMonitoringExecutionsRequest$CreationTimeBefore' => '<p>A filter that returns only jobs created before a specified time.</p>', 'ListMonitoringExecutionsRequest$CreationTimeAfter' => '<p>A filter that returns only jobs created after a specified time.</p>', 'ListMonitoringExecutionsRequest$LastModifiedTimeBefore' => '<p>A filter that returns only jobs modified after a specified time.</p>', 'ListMonitoringExecutionsRequest$LastModifiedTimeAfter' => '<p>A filter that returns only jobs modified before a specified time.</p>', 'ListMonitoringSchedulesRequest$CreationTimeBefore' => '<p>A filter that returns only monitoring schedules created before a specified time.</p>', 'ListMonitoringSchedulesRequest$CreationTimeAfter' => '<p>A filter that returns only monitoring schedules created after a specified time.</p>', 'ListMonitoringSchedulesRequest$LastModifiedTimeBefore' => '<p>A filter that returns only monitoring schedules modified before a specified time.</p>', 'ListMonitoringSchedulesRequest$LastModifiedTimeAfter' => '<p>A filter that returns only monitoring schedules modified after a specified time.</p>', 'ListProcessingJobsRequest$CreationTimeAfter' => '<p>A filter that returns only processing jobs created after the specified time.</p>', 'ListProcessingJobsRequest$CreationTimeBefore' => '<p>A filter that returns only processing jobs created after the specified time.</p>', 'ListProcessingJobsRequest$LastModifiedTimeAfter' => '<p>A filter that returns only processing jobs modified after the specified time.</p>', 'ListProcessingJobsRequest$LastModifiedTimeBefore' => '<p>A filter that returns only processing jobs modified before the specified time.</p>', 'ListTrainingJobsRequest$CreationTimeAfter' => '<p>A filter that returns only training jobs created after the specified time (timestamp).</p>', 'ListTrainingJobsRequest$CreationTimeBefore' => '<p>A filter that returns only training jobs created before the specified time (timestamp).</p>', 'ListTrainingJobsRequest$LastModifiedTimeAfter' => '<p>A filter that returns only training jobs modified after the specified time (timestamp).</p>', 'ListTrainingJobsRequest$LastModifiedTimeBefore' => '<p>A filter that returns only training jobs modified before the specified time (timestamp).</p>', 'ListTransformJobsRequest$CreationTimeAfter' => '<p>A filter that returns only transform jobs created after the specified time.</p>', 'ListTransformJobsRequest$CreationTimeBefore' => '<p>A filter that returns only transform jobs created before the specified time.</p>', 'ListTransformJobsRequest$LastModifiedTimeAfter' => '<p>A filter that returns only transform jobs modified after the specified time.</p>', 'ListTransformJobsRequest$LastModifiedTimeBefore' => '<p>A filter that returns only transform jobs modified before the specified time.</p>', 'ListTrialComponentsRequest$CreatedAfter' => '<p>A filter that returns only components created after the specified time.</p>', 'ListTrialComponentsRequest$CreatedBefore' => '<p>A filter that returns only components created before the specified time.</p>', 'ListTrialsRequest$CreatedAfter' => '<p>A filter that returns only trials created after the specified time.</p>', 'ListTrialsRequest$CreatedBefore' => '<p>A filter that returns only trials created before the specified time.</p>', 'MetricData$Timestamp' => '<p>The date and time that the algorithm emitted the metric.</p>', 'ModelSummary$CreationTime' => '<p>A timestamp that indicates when the model was created.</p>', 'MonitoringExecutionSummary$ScheduledTime' => '<p>The time the monitoring job was scheduled.</p>', 'MonitoringExecutionSummary$CreationTime' => '<p>The time at which the monitoring job was created.</p>', 'MonitoringExecutionSummary$LastModifiedTime' => '<p>A timestamp that indicates the last time the monitoring job was modified.</p>', 'MonitoringScheduleSummary$CreationTime' => '<p>The creation time of the monitoring schedule.</p>', 'MonitoringScheduleSummary$LastModifiedTime' => '<p>The last time the monitoring schedule was modified.</p>', 'ProcessingJob$ProcessingEndTime' => '<p>The time that the processing job ended.</p>', 'ProcessingJob$ProcessingStartTime' => '<p>The time that the processing job started.</p>', 'ProcessingJob$LastModifiedTime' => '<p>The time the processing job was last modified.</p>', 'ProcessingJob$CreationTime' => '<p>The time the processing job was created.</p>', 'ProcessingJobSummary$CreationTime' => '<p>The time at which the processing job was created.</p>', 'ProcessingJobSummary$ProcessingEndTime' => '<p>The time at which the processing job completed.</p>', 'ProcessingJobSummary$LastModifiedTime' => '<p>A timestamp that indicates the last time the processing job was modified.</p>', 'SecondaryStatusTransition$StartTime' => '<p>A timestamp that shows when the training job transitioned to the current secondary status state.</p>', 'SecondaryStatusTransition$EndTime' => '<p>A timestamp that shows when the training job transitioned out of this secondary status state into another secondary status state or when the training job has ended.</p>', 'TrainingJob$CreationTime' => '<p>A timestamp that indicates when the training job was created.</p>', 'TrainingJob$TrainingStartTime' => '<p>Indicates the time when the training job starts on training instances. You are billed for the time interval between this time and the value of <code>TrainingEndTime</code>. The start time in CloudWatch Logs might be later than this time. The difference is due to the time it takes to download the training data and to the size of the training container.</p>', 'TrainingJob$TrainingEndTime' => '<p>Indicates the time when the training job ends on training instances. You are billed for the time interval between the value of <code>TrainingStartTime</code> and this time. For successful jobs and stopped jobs, this is the time after model artifacts are uploaded. For failed jobs, this is the time when Amazon SageMaker detects a job failure.</p>', 'TrainingJob$LastModifiedTime' => '<p>A timestamp that indicates when the status of the training job was last modified.</p>', 'TrainingJobSummary$CreationTime' => '<p>A timestamp that shows when the training job was created.</p>', 'TrainingJobSummary$TrainingEndTime' => '<p>A timestamp that shows when the training job ended. This field is set only if the training job has one of the terminal statuses (<code>Completed</code>, <code>Failed</code>, or <code>Stopped</code>). </p>', 'TrainingJobSummary$LastModifiedTime' => '<p> Timestamp when the training job was last modified. </p>', 'TransformJob$CreationTime' => '<p>A timestamp that shows when the transform Job was created.</p>', 'TransformJob$TransformStartTime' => '<p>Indicates when the transform job starts on ML instances. You are billed for the time interval between this time and the value of <code>TransformEndTime</code>.</p>', 'TransformJob$TransformEndTime' => '<p>Indicates when the transform job has been completed, or has stopped or failed. You are billed for the time interval between this time and the value of <code>TransformStartTime</code>.</p>', 'TransformJobSummary$CreationTime' => '<p>A timestamp that shows when the transform Job was created.</p>', 'TransformJobSummary$TransformEndTime' => '<p>Indicates when the transform job ends on compute instances. For successful jobs and stopped jobs, this is the exact time recorded after the results are uploaded. For failed jobs, this is when Amazon SageMaker detected that the job failed.</p>', 'TransformJobSummary$LastModifiedTime' => '<p>Indicates when the transform job was last modified.</p>', 'Trial$CreationTime' => '<p>When the trial was created.</p>', 'Trial$LastModifiedTime' => '<p>Who last modified the trial.</p>', 'TrialComponent$StartTime' => '<p>When the component started.</p>', 'TrialComponent$EndTime' => '<p>When the component ended.</p>', 'TrialComponent$CreationTime' => '<p>When the component was created.</p>', 'TrialComponent$LastModifiedTime' => '<p>When the component was last modified.</p>', 'TrialComponentMetricSummary$TimeStamp' => '<p>When the metric was last updated.</p>', 'TrialComponentSimpleSummary$CreationTime' => '<p>When the component was created.</p>', 'TrialComponentSummary$StartTime' => '<p>When the component started.</p>', 'TrialComponentSummary$EndTime' => '<p>When the component ended.</p>', 'TrialComponentSummary$CreationTime' => '<p>When the component was created.</p>', 'TrialComponentSummary$LastModifiedTime' => '<p>When the component was last modified.</p>', 'TrialSummary$CreationTime' => '<p>When the trial was created.</p>', 'TrialSummary$LastModifiedTime' => '<p>When the trial was last modified.</p>', 'UpdateTrialComponentRequest$StartTime' => '<p>When the component started.</p>', 'UpdateTrialComponentRequest$EndTime' => '<p>When the component ended.</p>', 'Workforce$LastUpdatedDate' => '<p>The most recent date that was used to successfully add one or more IP address ranges (<a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>) to a private workforce\'s allow list.</p>', 'Workforce$CreateDate' => '<p>The date that the workforce is created.</p>', 'Workteam$CreateDate' => '<p>The date and time that the work team was created (timestamp).</p>', 'Workteam$LastUpdatedDate' => '<p>The date and time that the work team was last updated (timestamp).</p>', ], ], 'TrainingInputMode' => [ 'base' => NULL, 'refs' => [ 'AlgorithmSpecification$TrainingInputMode' => '<p>The input mode that the algorithm supports. For the input modes that Amazon SageMaker algorithms support, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. If an algorithm supports the <code>File</code> input mode, Amazon SageMaker downloads the training data from S3 to the provisioned ML storage Volume, and mounts the directory to docker volume for training container. If an algorithm supports the <code>Pipe</code> input mode, Amazon SageMaker streams data directly from S3 to the container. </p> <p> In File mode, make sure you provision ML storage volume with sufficient capacity to accommodate the data download from S3. In addition to the training data, the ML storage volume also stores the output model. The algorithm container use ML storage volume to also store intermediate information, if any. </p> <p> For distributed algorithms using File mode, training data is distributed uniformly, and your training duration is predictable if the input data objects size is approximately same. Amazon SageMaker does not split the files any further for model training. If the object sizes are skewed, training won\'t be optimal as the data distribution is also skewed where one host in a training cluster is overloaded, thus becoming bottleneck in training. </p>', 'Channel$InputMode' => '<p>(Optional) The input mode to use for the data channel in a training job. If you don\'t set a value for <code>InputMode</code>, Amazon SageMaker uses the value set for <code>TrainingInputMode</code>. Use this parameter to override the <code>TrainingInputMode</code> setting in a <a>AlgorithmSpecification</a> request when you have a channel that needs a different input mode from the training job\'s general setting. To download the data from Amazon Simple Storage Service (Amazon S3) to the provisioned ML storage volume, and mount the directory to a Docker volume, use <code>File</code> input mode. To stream data directly from Amazon S3 to the container, choose <code>Pipe</code> input mode.</p> <p>To use a model for incremental training, choose <code>File</code> input model.</p>', 'HyperParameterAlgorithmSpecification$TrainingInputMode' => '<p>The input mode that the algorithm supports: File or Pipe. In File input mode, Amazon SageMaker downloads the training data from Amazon S3 to the storage volume that is attached to the training instance and mounts the directory to the Docker volume for the training container. In Pipe input mode, Amazon SageMaker streams data directly from Amazon S3 to the container. </p> <p>If you specify File mode, make sure that you provision the storage volume that is attached to the training instance with enough capacity to accommodate the training data downloaded from Amazon S3, the model artifacts, and intermediate information.</p> <p/> <p>For more information about input modes, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. </p>', 'InputModes$member' => NULL, 'TrainingJobDefinition$TrainingInputMode' => '<p>The input mode used by the algorithm for the training job. For the input modes that Amazon SageMaker algorithms support, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>.</p> <p>If an algorithm supports the <code>File</code> input mode, Amazon SageMaker downloads the training data from S3 to the provisioned ML storage Volume, and mounts the directory to docker volume for training container. If an algorithm supports the <code>Pipe</code> input mode, Amazon SageMaker streams data directly from S3 to the container.</p>', ], ], 'TrainingInstanceCount' => [ 'base' => NULL, 'refs' => [ 'ResourceConfig$InstanceCount' => '<p>The number of ML compute instances to use. For distributed training, provide a value greater than 1. </p>', ], ], 'TrainingInstanceType' => [ 'base' => NULL, 'refs' => [ 'ResourceConfig$InstanceType' => '<p>The ML compute instance type. </p>', 'TrainingInstanceTypes$member' => NULL, ], ], 'TrainingInstanceTypes' => [ 'base' => NULL, 'refs' => [ 'TrainingSpecification$SupportedTrainingInstanceTypes' => '<p>A list of the instance types that this algorithm can use for training.</p>', ], ], 'TrainingJob' => [ 'base' => '<p>Contains information about a training job.</p>', 'refs' => [ 'SearchRecord$TrainingJob' => '<p>The properties of a training job.</p>', 'TrialComponentSourceDetail$TrainingJob' => '<p>Information about a training job that\'s the source of a trial component.</p>', ], ], 'TrainingJobArn' => [ 'base' => NULL, 'refs' => [ 'CreateTrainingJobResponse$TrainingJobArn' => '<p>The Amazon Resource Name (ARN) of the training job.</p>', 'DescribeProcessingJobResponse$TrainingJobArn' => '<p>The ARN of a training job associated with this processing job.</p>', 'DescribeTrainingJobResponse$TrainingJobArn' => '<p>The Amazon Resource Name (ARN) of the training job.</p>', 'HyperParameterTrainingJobSummary$TrainingJobArn' => '<p>The Amazon Resource Name (ARN) of the training job.</p>', 'ProcessingJob$TrainingJobArn' => '<p>The ARN of the training job associated with this processing job.</p>', 'TrainingJob$TrainingJobArn' => '<p>The Amazon Resource Name (ARN) of the training job.</p>', 'TrainingJobSummary$TrainingJobArn' => '<p>The Amazon Resource Name (ARN) of the training job.</p>', ], ], 'TrainingJobDefinition' => [ 'base' => '<p>Defines the input needed to run a training job using the algorithm.</p>', 'refs' => [ 'AlgorithmValidationProfile$TrainingJobDefinition' => '<p>The <code>TrainingJobDefinition</code> object that describes the training job that Amazon SageMaker runs to validate your algorithm.</p>', ], ], 'TrainingJobEarlyStoppingType' => [ 'base' => NULL, 'refs' => [ 'HyperParameterTuningJobConfig$TrainingJobEarlyStoppingType' => '<p>Specifies whether to use early stopping for training jobs launched by the hyperparameter tuning job. This can be one of the following values (the default value is <code>OFF</code>):</p> <dl> <dt>OFF</dt> <dd> <p>Training jobs launched by the hyperparameter tuning job do not use early stopping.</p> </dd> <dt>AUTO</dt> <dd> <p>Amazon SageMaker stops training jobs launched by the hyperparameter tuning job when they are unlikely to perform better than previously completed training jobs. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-early-stopping.html">Stop Training Jobs Early</a>.</p> </dd> </dl>', ], ], 'TrainingJobName' => [ 'base' => NULL, 'refs' => [ 'CreateTrainingJobRequest$TrainingJobName' => '<p>The name of the training job. The name must be unique within an AWS Region in an AWS account. </p>', 'DescribeTrainingJobRequest$TrainingJobName' => '<p>The name of the training job.</p>', 'DescribeTrainingJobResponse$TrainingJobName' => '<p> Name of the model training job. </p>', 'HyperParameterTrainingJobSummary$TrainingJobName' => '<p>The name of the training job.</p>', 'StopTrainingJobRequest$TrainingJobName' => '<p>The name of the training job to stop.</p>', 'TrainingJob$TrainingJobName' => '<p>The name of the training job.</p>', 'TrainingJobSummary$TrainingJobName' => '<p>The name of the training job that you want a summary for.</p>', ], ], 'TrainingJobSortByOptions' => [ 'base' => NULL, 'refs' => [ 'ListTrainingJobsForHyperParameterTuningJobRequest$SortBy' => '<p>The field to sort results by. The default is <code>Name</code>.</p> <p>If the value of this field is <code>FinalObjectiveMetricValue</code>, any training jobs that did not return an objective metric are not listed.</p>', ], ], 'TrainingJobStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeTrainingJobResponse$TrainingJobStatus' => '<p>The status of the training job.</p> <p>Amazon SageMaker provides the following training job statuses:</p> <ul> <li> <p> <code>InProgress</code> - The training is in progress.</p> </li> <li> <p> <code>Completed</code> - The training job has completed.</p> </li> <li> <p> <code>Failed</code> - The training job has failed. To see the reason for the failure, see the <code>FailureReason</code> field in the response to a <code>DescribeTrainingJobResponse</code> call.</p> </li> <li> <p> <code>Stopping</code> - The training job is stopping.</p> </li> <li> <p> <code>Stopped</code> - The training job has stopped.</p> </li> </ul> <p>For more detailed information, see <code>SecondaryStatus</code>. </p>', 'HyperParameterTrainingJobSummary$TrainingJobStatus' => '<p>The status of the training job.</p>', 'ListTrainingJobsForHyperParameterTuningJobRequest$StatusEquals' => '<p>A filter that returns only training jobs with the specified status.</p>', 'ListTrainingJobsRequest$StatusEquals' => '<p>A filter that retrieves only training jobs with a specific status.</p>', 'TrainingJob$TrainingJobStatus' => '<p>The status of the training job.</p> <p>Training job statuses are:</p> <ul> <li> <p> <code>InProgress</code> - The training is in progress.</p> </li> <li> <p> <code>Completed</code> - The training job has completed.</p> </li> <li> <p> <code>Failed</code> - The training job has failed. To see the reason for the failure, see the <code>FailureReason</code> field in the response to a <code>DescribeTrainingJobResponse</code> call.</p> </li> <li> <p> <code>Stopping</code> - The training job is stopping.</p> </li> <li> <p> <code>Stopped</code> - The training job has stopped.</p> </li> </ul> <p>For more detailed information, see <code>SecondaryStatus</code>. </p>', 'TrainingJobSummary$TrainingJobStatus' => '<p>The status of the training job.</p>', ], ], 'TrainingJobStatusCounter' => [ 'base' => NULL, 'refs' => [ 'TrainingJobStatusCounters$Completed' => '<p>The number of completed training jobs launched by the hyperparameter tuning job.</p>', 'TrainingJobStatusCounters$InProgress' => '<p>The number of in-progress training jobs launched by a hyperparameter tuning job.</p>', 'TrainingJobStatusCounters$RetryableError' => '<p>The number of training jobs that failed, but can be retried. A failed training job can be retried only if it failed because an internal service error occurred.</p>', 'TrainingJobStatusCounters$NonRetryableError' => '<p>The number of training jobs that failed and can\'t be retried. A failed training job can\'t be retried if it failed because a client error occurred.</p>', 'TrainingJobStatusCounters$Stopped' => '<p>The number of training jobs launched by a hyperparameter tuning job that were manually stopped.</p>', ], ], 'TrainingJobStatusCounters' => [ 'base' => '<p>The numbers of training jobs launched by a hyperparameter tuning job, categorized by status.</p>', 'refs' => [ 'DescribeHyperParameterTuningJobResponse$TrainingJobStatusCounters' => '<p>The <a>TrainingJobStatusCounters</a> object that specifies the number of training jobs, categorized by status, that this tuning job launched.</p>', 'HyperParameterTuningJobSummary$TrainingJobStatusCounters' => '<p>The <a>TrainingJobStatusCounters</a> object that specifies the numbers of training jobs, categorized by status, that this tuning job launched.</p>', ], ], 'TrainingJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListTrainingJobsResponse$TrainingJobSummaries' => '<p>An array of <code>TrainingJobSummary</code> objects, each listing a training job.</p>', ], ], 'TrainingJobSummary' => [ 'base' => '<p>Provides summary information about a training job.</p>', 'refs' => [ 'TrainingJobSummaries$member' => NULL, ], ], 'TrainingSpecification' => [ 'base' => '<p>Defines how the algorithm is used for a training job.</p>', 'refs' => [ 'CreateAlgorithmInput$TrainingSpecification' => '<p>Specifies details about training jobs run by this algorithm, including the following:</p> <ul> <li> <p>The Amazon ECR path of the container and the version digest of the algorithm.</p> </li> <li> <p>The hyperparameters that the algorithm supports.</p> </li> <li> <p>The instance types that the algorithm supports for training.</p> </li> <li> <p>Whether the algorithm supports distributed training.</p> </li> <li> <p>The metrics that the algorithm emits to Amazon CloudWatch.</p> </li> <li> <p>Which metrics that the algorithm emits can be used as the objective metric for hyperparameter tuning jobs.</p> </li> <li> <p>The input channels that the algorithm supports for training data. For example, an algorithm might support <code>train</code>, <code>validation</code>, and <code>test</code> channels.</p> </li> </ul>', 'DescribeAlgorithmOutput$TrainingSpecification' => '<p>Details about training jobs run by this algorithm.</p>', ], ], 'TrainingTimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'DescribeTrainingJobResponse$TrainingTimeInSeconds' => '<p>The training time in seconds.</p>', 'TrainingJob$TrainingTimeInSeconds' => '<p>The training time in seconds.</p>', ], ], 'TransformDataSource' => [ 'base' => '<p>Describes the location of the channel data.</p>', 'refs' => [ 'TransformInput$DataSource' => '<p>Describes the location of the channel data, which is, the S3 location of the input data that the model can consume.</p>', ], ], 'TransformEnvironmentKey' => [ 'base' => NULL, 'refs' => [ 'TransformEnvironmentMap$key' => NULL, ], ], 'TransformEnvironmentMap' => [ 'base' => NULL, 'refs' => [ 'CreateTransformJobRequest$Environment' => '<p>The environment variables to set in the Docker container. We support up to 16 key and values entries in the map.</p>', 'DescribeTransformJobResponse$Environment' => '<p>The environment variables to set in the Docker container. We support up to 16 key and values entries in the map.</p>', 'TransformJob$Environment' => '<p>The environment variables to set in the Docker container. We support up to 16 key and values entries in the map.</p>', 'TransformJobDefinition$Environment' => '<p>The environment variables to set in the Docker container. We support up to 16 key and values entries in the map.</p>', ], ], 'TransformEnvironmentValue' => [ 'base' => NULL, 'refs' => [ 'TransformEnvironmentMap$value' => NULL, ], ], 'TransformInput' => [ 'base' => '<p>Describes the input source of a transform job and the way the transform job consumes it.</p>', 'refs' => [ 'CreateTransformJobRequest$TransformInput' => '<p>Describes the input source and the way the transform job consumes it.</p>', 'DescribeTransformJobResponse$TransformInput' => '<p>Describes the dataset to be transformed and the Amazon S3 location where it is stored.</p>', 'TransformJob$TransformInput' => NULL, 'TransformJobDefinition$TransformInput' => '<p>A description of the input source and the way the transform job consumes it.</p>', ], ], 'TransformInstanceCount' => [ 'base' => NULL, 'refs' => [ 'TransformResources$InstanceCount' => '<p>The number of ML compute instances to use in the transform job. For distributed transform jobs, specify a value greater than 1. The default value is <code>1</code>.</p>', ], ], 'TransformInstanceType' => [ 'base' => NULL, 'refs' => [ 'TransformInstanceTypes$member' => NULL, 'TransformResources$InstanceType' => '<p>The ML compute instance type for the transform job. If you are using built-in algorithms to transform moderately sized datasets, we recommend using ml.m4.xlarge or <code>ml.m5.large</code> instance types.</p>', ], ], 'TransformInstanceTypes' => [ 'base' => NULL, 'refs' => [ 'InferenceSpecification$SupportedTransformInstanceTypes' => '<p>A list of the instance types on which a transformation job can be run or on which an endpoint can be deployed.</p>', ], ], 'TransformJob' => [ 'base' => '<p>A batch transform job. For information about SageMaker batch transform, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html">Use Batch Transform</a>.</p>', 'refs' => [ 'TrialComponentSourceDetail$TransformJob' => '<p>Information about a transform job that\'s the source of the trial component.</p>', ], ], 'TransformJobArn' => [ 'base' => NULL, 'refs' => [ 'CreateTransformJobResponse$TransformJobArn' => '<p>The Amazon Resource Name (ARN) of the transform job.</p>', 'DescribeTransformJobResponse$TransformJobArn' => '<p>The Amazon Resource Name (ARN) of the transform job.</p>', 'TransformJob$TransformJobArn' => '<p>The Amazon Resource Name (ARN) of the transform job.</p>', 'TransformJobSummary$TransformJobArn' => '<p>The Amazon Resource Name (ARN) of the transform job.</p>', ], ], 'TransformJobDefinition' => [ 'base' => '<p>Defines the input needed to run a transform job using the inference specification specified in the algorithm.</p>', 'refs' => [ 'AlgorithmValidationProfile$TransformJobDefinition' => '<p>The <code>TransformJobDefinition</code> object that describes the transform job that Amazon SageMaker runs to validate your algorithm.</p>', 'ModelPackageValidationProfile$TransformJobDefinition' => '<p>The <code>TransformJobDefinition</code> object that describes the transform job used for the validation of the model package.</p>', ], ], 'TransformJobName' => [ 'base' => NULL, 'refs' => [ 'CreateTransformJobRequest$TransformJobName' => '<p>The name of the transform job. The name must be unique within an AWS Region in an AWS account. </p>', 'DescribeTransformJobRequest$TransformJobName' => '<p>The name of the transform job that you want to view details of.</p>', 'DescribeTransformJobResponse$TransformJobName' => '<p>The name of the transform job.</p>', 'StopTransformJobRequest$TransformJobName' => '<p>The name of the transform job to stop.</p>', 'TransformJob$TransformJobName' => '<p>The name of the transform job.</p>', 'TransformJobSummary$TransformJobName' => '<p>The name of the transform job.</p>', ], ], 'TransformJobStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeTransformJobResponse$TransformJobStatus' => '<p>The status of the transform job. If the transform job failed, the reason is returned in the <code>FailureReason</code> field.</p>', 'ListTransformJobsRequest$StatusEquals' => '<p>A filter that retrieves only transform jobs with a specific status.</p>', 'TransformJob$TransformJobStatus' => '<p>The status of the transform job.</p> <p>Transform job statuses are:</p> <ul> <li> <p> <code>InProgress</code> - The job is in progress.</p> </li> <li> <p> <code>Completed</code> - The job has completed.</p> </li> <li> <p> <code>Failed</code> - The transform job has failed. To see the reason for the failure, see the <code>FailureReason</code> field in the response to a <code>DescribeTransformJob</code> call.</p> </li> <li> <p> <code>Stopping</code> - The transform job is stopping.</p> </li> <li> <p> <code>Stopped</code> - The transform job has stopped.</p> </li> </ul>', 'TransformJobSummary$TransformJobStatus' => '<p>The status of the transform job.</p>', ], ], 'TransformJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListTransformJobsResponse$TransformJobSummaries' => '<p>An array of <code>TransformJobSummary</code> objects.</p>', ], ], 'TransformJobSummary' => [ 'base' => '<p>Provides a summary of a transform job. Multiple <code>TransformJobSummary</code> objects are returned as a list after in response to a <a>ListTransformJobs</a> call.</p>', 'refs' => [ 'TransformJobSummaries$member' => NULL, ], ], 'TransformOutput' => [ 'base' => '<p>Describes the results of a transform job.</p>', 'refs' => [ 'CreateTransformJobRequest$TransformOutput' => '<p>Describes the results of the transform job.</p>', 'DescribeTransformJobResponse$TransformOutput' => '<p>Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job.</p>', 'TransformJob$TransformOutput' => NULL, 'TransformJobDefinition$TransformOutput' => '<p>Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job.</p>', ], ], 'TransformResources' => [ 'base' => '<p>Describes the resources, including ML instance types and ML instance count, to use for transform job.</p>', 'refs' => [ 'CreateTransformJobRequest$TransformResources' => '<p>Describes the resources, including ML instance types and ML instance count, to use for the transform job.</p>', 'DescribeTransformJobResponse$TransformResources' => '<p>Describes the resources, including ML instance types and ML instance count, to use for the transform job.</p>', 'TransformJob$TransformResources' => NULL, 'TransformJobDefinition$TransformResources' => '<p>Identifies the ML compute instances for the transform job.</p>', ], ], 'TransformS3DataSource' => [ 'base' => '<p>Describes the S3 data source.</p>', 'refs' => [ 'TransformDataSource$S3DataSource' => '<p>The S3 location of the data source that is associated with a channel.</p>', ], ], 'Trial' => [ 'base' => '<p>The properties of a trial as returned by the <a>Search</a> API.</p>', 'refs' => [ 'SearchRecord$Trial' => '<p>The properties of a trial.</p>', ], ], 'TrialArn' => [ 'base' => NULL, 'refs' => [ 'AssociateTrialComponentResponse$TrialArn' => '<p>The Amazon Resource Name (ARN) of the trial.</p>', 'CreateTrialResponse$TrialArn' => '<p>The Amazon Resource Name (ARN) of the trial.</p>', 'DeleteTrialResponse$TrialArn' => '<p>The Amazon Resource Name (ARN) of the trial that is being deleted.</p>', 'DescribeTrialResponse$TrialArn' => '<p>The Amazon Resource Name (ARN) of the trial.</p>', 'DisassociateTrialComponentResponse$TrialArn' => '<p>The Amazon Resource Name (ARN) of the trial.</p>', 'Trial$TrialArn' => '<p>The Amazon Resource Name (ARN) of the trial.</p>', 'TrialSummary$TrialArn' => '<p>The Amazon Resource Name (ARN) of the trial.</p>', 'UpdateTrialResponse$TrialArn' => '<p>The Amazon Resource Name (ARN) of the trial.</p>', ], ], 'TrialComponent' => [ 'base' => '<p>The properties of a trial component as returned by the <a>Search</a> API.</p>', 'refs' => [ 'SearchRecord$TrialComponent' => '<p>The properties of a trial component.</p>', ], ], 'TrialComponentArn' => [ 'base' => NULL, 'refs' => [ 'AssociateTrialComponentResponse$TrialComponentArn' => '<p>The ARN of the trial component.</p>', 'CreateTrialComponentResponse$TrialComponentArn' => '<p>The Amazon Resource Name (ARN) of the trial component.</p>', 'DeleteTrialComponentResponse$TrialComponentArn' => '<p>The Amazon Resource Name (ARN) of the component is being deleted.</p>', 'DescribeTrialComponentResponse$TrialComponentArn' => '<p>The Amazon Resource Name (ARN) of the trial component.</p>', 'DisassociateTrialComponentResponse$TrialComponentArn' => '<p>The ARN of the trial component.</p>', 'TrialComponent$TrialComponentArn' => '<p>The Amazon Resource Name (ARN) of the trial component.</p>', 'TrialComponentSimpleSummary$TrialComponentArn' => '<p>The Amazon Resource Name (ARN) of the trial component.</p>', 'TrialComponentSummary$TrialComponentArn' => '<p>The ARN of the trial component.</p>', 'UpdateTrialComponentResponse$TrialComponentArn' => '<p>The Amazon Resource Name (ARN) of the trial component.</p>', ], ], 'TrialComponentArtifact' => [ 'base' => '<p>Represents an input or output artifact of a trial component. You specify <code>TrialComponentArtifact</code> as part of the <code>InputArtifacts</code> and <code>OutputArtifacts</code> parameters in the <a>CreateTrialComponent</a> request.</p> <p>Examples of input artifacts are datasets, algorithms, hyperparameters, source code, and instance types. Examples of output artifacts are metrics, snapshots, logs, and images.</p>', 'refs' => [ 'TrialComponentArtifacts$value' => NULL, ], ], 'TrialComponentArtifactValue' => [ 'base' => NULL, 'refs' => [ 'TrialComponentArtifact$Value' => '<p>The location of the artifact.</p>', ], ], 'TrialComponentArtifacts' => [ 'base' => NULL, 'refs' => [ 'CreateTrialComponentRequest$InputArtifacts' => '<p>The input artifacts for the component. Examples of input artifacts are datasets, algorithms, hyperparameters, source code, and instance types.</p>', 'CreateTrialComponentRequest$OutputArtifacts' => '<p>The output artifacts for the component. Examples of output artifacts are metrics, snapshots, logs, and images.</p>', 'DescribeTrialComponentResponse$InputArtifacts' => '<p>The input artifacts of the component.</p>', 'DescribeTrialComponentResponse$OutputArtifacts' => '<p>The output artifacts of the component.</p>', 'TrialComponent$InputArtifacts' => '<p>The input artifacts of the component.</p>', 'TrialComponent$OutputArtifacts' => '<p>The output artifacts of the component.</p>', 'UpdateTrialComponentRequest$InputArtifacts' => '<p>Replaces all of the component\'s input artifacts with the specified artifacts.</p>', 'UpdateTrialComponentRequest$OutputArtifacts' => '<p>Replaces all of the component\'s output artifacts with the specified artifacts.</p>', ], ], 'TrialComponentKey256' => [ 'base' => NULL, 'refs' => [ 'ListTrialComponentKey256$member' => NULL, 'TrialComponentParameters$key' => NULL, ], ], 'TrialComponentKey64' => [ 'base' => NULL, 'refs' => [ 'TrialComponentArtifacts$key' => NULL, ], ], 'TrialComponentMetricSummaries' => [ 'base' => NULL, 'refs' => [ 'DescribeTrialComponentResponse$Metrics' => '<p>The metrics for the component.</p>', 'TrialComponent$Metrics' => '<p>The metrics for the component.</p>', ], ], 'TrialComponentMetricSummary' => [ 'base' => '<p>A summary of the metrics of a trial component.</p>', 'refs' => [ 'TrialComponentMetricSummaries$member' => NULL, ], ], 'TrialComponentParameterValue' => [ 'base' => '<p>The value of a hyperparameter. Only one of <code>NumberValue</code> or <code>StringValue</code> can be specified.</p> <p>This object is specified in the <a>CreateTrialComponent</a> request.</p>', 'refs' => [ 'TrialComponentParameters$value' => NULL, ], ], 'TrialComponentParameters' => [ 'base' => NULL, 'refs' => [ 'CreateTrialComponentRequest$Parameters' => '<p>The hyperparameters for the component.</p>', 'DescribeTrialComponentResponse$Parameters' => '<p>The hyperparameters of the component.</p>', 'TrialComponent$Parameters' => '<p>The hyperparameters of the component.</p>', 'UpdateTrialComponentRequest$Parameters' => '<p>Replaces all of the component\'s hyperparameters with the specified hyperparameters.</p>', ], ], 'TrialComponentPrimaryStatus' => [ 'base' => NULL, 'refs' => [ 'TrialComponentStatus$PrimaryStatus' => '<p>The status of the trial component.</p>', ], ], 'TrialComponentSimpleSummaries' => [ 'base' => NULL, 'refs' => [ 'Trial$TrialComponentSummaries' => '<p>A list of the components associated with the trial. For each component, a summary of the component\'s properties is included.</p>', ], ], 'TrialComponentSimpleSummary' => [ 'base' => '<p>A short summary of a trial component.</p>', 'refs' => [ 'TrialComponentSimpleSummaries$member' => NULL, ], ], 'TrialComponentSource' => [ 'base' => '<p>The Amazon Resource Name (ARN) and job type of the source of a trial component.</p>', 'refs' => [ 'DescribeTrialComponentResponse$Source' => '<p>The Amazon Resource Name (ARN) of the source and, optionally, the job type.</p>', 'TrialComponent$Source' => '<p>The Amazon Resource Name (ARN) and job type of the source of the component.</p>', 'TrialComponentSimpleSummary$TrialComponentSource' => NULL, 'TrialComponentSummary$TrialComponentSource' => NULL, ], ], 'TrialComponentSourceArn' => [ 'base' => NULL, 'refs' => [ 'TrialComponentMetricSummary$SourceArn' => '<p>The Amazon Resource Name (ARN) of the source.</p>', 'TrialComponentSource$SourceArn' => '<p>The source ARN.</p>', 'TrialComponentSourceDetail$SourceArn' => '<p>The Amazon Resource Name (ARN) of the source.</p>', ], ], 'TrialComponentSourceDetail' => [ 'base' => '<p>Detailed information about the source of a trial component. Either <code>ProcessingJob</code> or <code>TrainingJob</code> is returned.</p>', 'refs' => [ 'TrialComponent$SourceDetail' => '<p>Details of the source of the component.</p>', ], ], 'TrialComponentStatus' => [ 'base' => '<p>The status of the trial component.</p>', 'refs' => [ 'CreateTrialComponentRequest$Status' => '<p>The status of the component. States include:</p> <ul> <li> <p>InProgress</p> </li> <li> <p>Completed</p> </li> <li> <p>Failed</p> </li> </ul>', 'DescribeTrialComponentResponse$Status' => '<p>The status of the component. States include:</p> <ul> <li> <p>InProgress</p> </li> <li> <p>Completed</p> </li> <li> <p>Failed</p> </li> </ul>', 'TrialComponent$Status' => NULL, 'TrialComponentSummary$Status' => '<p>The status of the component. States include:</p> <ul> <li> <p>InProgress</p> </li> <li> <p>Completed</p> </li> <li> <p>Failed</p> </li> </ul>', 'UpdateTrialComponentRequest$Status' => '<p>The new status of the component.</p>', ], ], 'TrialComponentStatusMessage' => [ 'base' => NULL, 'refs' => [ 'TrialComponentStatus$Message' => '<p>If the component failed, a message describing why.</p>', ], ], 'TrialComponentSummaries' => [ 'base' => NULL, 'refs' => [ 'ListTrialComponentsResponse$TrialComponentSummaries' => '<p>A list of the summaries of your trial components.</p>', ], ], 'TrialComponentSummary' => [ 'base' => '<p>A summary of the properties of a trial component. To get all the properties, call the <a>DescribeTrialComponent</a> API and provide the <code>TrialComponentName</code>.</p>', 'refs' => [ 'TrialComponentSummaries$member' => NULL, ], ], 'TrialSource' => [ 'base' => '<p>The source of the trial.</p>', 'refs' => [ 'DescribeTrialResponse$Source' => '<p>The Amazon Resource Name (ARN) of the source and, optionally, the job type.</p>', 'Trial$Source' => NULL, 'TrialSummary$TrialSource' => NULL, ], ], 'TrialSourceArn' => [ 'base' => NULL, 'refs' => [ 'TrialSource$SourceArn' => '<p>The Amazon Resource Name (ARN) of the source.</p>', ], ], 'TrialSummaries' => [ 'base' => NULL, 'refs' => [ 'ListTrialsResponse$TrialSummaries' => '<p>A list of the summaries of your trials.</p>', ], ], 'TrialSummary' => [ 'base' => '<p>A summary of the properties of a trial. To get the complete set of properties, call the <a>DescribeTrial</a> API and provide the <code>TrialName</code>.</p>', 'refs' => [ 'TrialSummaries$member' => NULL, ], ], 'TuningJobCompletionCriteria' => [ 'base' => '<p>The job completion criteria.</p>', 'refs' => [ 'HyperParameterTuningJobConfig$TuningJobCompletionCriteria' => '<p>The tuning job\'s completion criteria.</p>', ], ], 'USD' => [ 'base' => '<p>Represents an amount of money in United States dollars/</p>', 'refs' => [ 'PublicWorkforceTaskPrice$AmountInUsd' => '<p>Defines the amount of money paid to an Amazon Mechanical Turk worker in United States dollars.</p>', ], ], 'UiConfig' => [ 'base' => '<p>Provided configuration information for the worker UI for a labeling job. </p>', 'refs' => [ 'HumanTaskConfig$UiConfig' => '<p>Information about the user interface that workers use to complete the labeling task.</p>', ], ], 'UiTemplate' => [ 'base' => '<p>The Liquid template for the worker user interface.</p>', 'refs' => [ 'CreateHumanTaskUiRequest$UiTemplate' => NULL, 'RenderUiTemplateRequest$UiTemplate' => '<p>A <code>Template</code> object containing the worker UI template to render.</p>', ], ], 'UiTemplateInfo' => [ 'base' => '<p>Container for user interface template information.</p>', 'refs' => [ 'DescribeHumanTaskUiResponse$UiTemplate' => NULL, ], ], 'UpdateCodeRepositoryInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCodeRepositoryOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEndpointInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEndpointOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEndpointWeightsAndCapacitiesInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEndpointWeightsAndCapacitiesOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateExperimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateExperimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMonitoringScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMonitoringScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNotebookInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNotebookInstanceLifecycleConfigInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNotebookInstanceLifecycleConfigOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNotebookInstanceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTrialComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTrialComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTrialRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTrialResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkforceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkforceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkteamRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkteamResponse' => [ 'base' => NULL, 'refs' => [], ], 'Url' => [ 'base' => NULL, 'refs' => [ 'AutoMLContainerDefinition$ModelDataUrl' => '<p>The location of the model artifacts. Refer to ContainerDefinition for more details.</p>', 'ContainerDefinition$ModelDataUrl' => '<p>The S3 path where the model artifacts, which result from model training, are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix). The S3 path is required for Amazon SageMaker built-in algorithms, but not if you use your own algorithms. For more information on built-in algorithms, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html">Common Parameters</a>. </p> <p>If you provide a value for this parameter, Amazon SageMaker uses AWS Security Token Service to download model artifacts from the S3 path you provide. AWS STS is activated in your IAM user account by default. If you previously deactivated AWS STS for a region, you need to reactivate AWS STS for that region. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and Deactivating AWS STS in an AWS Region</a> in the <i>AWS Identity and Access Management User Guide</i>.</p> <important> <p>If you use a built-in algorithm to create a model, Amazon SageMaker requires that you provide a S3 path to the model artifacts in <code>ModelDataUrl</code>.</p> </important>', 'ModelPackageContainerDefinition$ModelDataUrl' => '<p>The Amazon S3 path where the model artifacts, which result from model training, are stored. This path must point to a single <code>gzip</code> compressed tar archive (<code>.tar.gz</code> suffix).</p>', 'SourceAlgorithm$ModelDataUrl' => '<p>The Amazon S3 path where the model artifacts, which result from model training, are stored. This path must point to a single <code>gzip</code> compressed tar archive (<code>.tar.gz</code> suffix).</p>', ], ], 'UserContext' => [ 'base' => '<p>Information about the user who created or modified an experiment, trial, or trial component.</p>', 'refs' => [ 'DescribeExperimentResponse$CreatedBy' => '<p>Who created the experiment.</p>', 'DescribeExperimentResponse$LastModifiedBy' => '<p>Who last modified the experiment.</p>', 'DescribeTrialComponentResponse$CreatedBy' => '<p>Who created the component.</p>', 'DescribeTrialComponentResponse$LastModifiedBy' => '<p>Who last modified the component.</p>', 'DescribeTrialResponse$CreatedBy' => '<p>Who created the trial.</p>', 'DescribeTrialResponse$LastModifiedBy' => '<p>Who last modified the trial.</p>', 'Experiment$CreatedBy' => NULL, 'Experiment$LastModifiedBy' => NULL, 'Trial$CreatedBy' => NULL, 'Trial$LastModifiedBy' => NULL, 'TrialComponent$CreatedBy' => NULL, 'TrialComponent$LastModifiedBy' => NULL, 'TrialComponentSimpleSummary$CreatedBy' => NULL, 'TrialComponentSummary$CreatedBy' => '<p>Who created the component.</p>', 'TrialComponentSummary$LastModifiedBy' => '<p>Who last modified the component.</p>', ], ], 'UserProfileArn' => [ 'base' => NULL, 'refs' => [ 'CreateUserProfileResponse$UserProfileArn' => '<p>The user profile Amazon Resource Name (ARN).</p>', 'DescribeUserProfileResponse$UserProfileArn' => '<p>The user profile Amazon Resource Name (ARN).</p>', 'UpdateUserProfileResponse$UserProfileArn' => '<p>The user profile Amazon Resource Name (ARN).</p>', ], ], 'UserProfileDetails' => [ 'base' => '<p>The user profile details.</p>', 'refs' => [ 'UserProfileList$member' => NULL, ], ], 'UserProfileList' => [ 'base' => NULL, 'refs' => [ 'ListUserProfilesResponse$UserProfiles' => '<p>The list of user profiles.</p>', ], ], 'UserProfileName' => [ 'base' => NULL, 'refs' => [ 'AppDetails$UserProfileName' => '<p>The user profile name.</p>', 'CreateAppRequest$UserProfileName' => '<p>The user profile name.</p>', 'CreatePresignedDomainUrlRequest$UserProfileName' => '<p>The name of the UserProfile to sign-in as.</p>', 'CreateUserProfileRequest$UserProfileName' => '<p>A name for the UserProfile.</p>', 'DeleteAppRequest$UserProfileName' => '<p>The user profile name.</p>', 'DeleteUserProfileRequest$UserProfileName' => '<p>The user profile name.</p>', 'DescribeAppRequest$UserProfileName' => '<p>The user profile name.</p>', 'DescribeAppResponse$UserProfileName' => '<p>The user profile name.</p>', 'DescribeUserProfileRequest$UserProfileName' => '<p>The user profile name.</p>', 'DescribeUserProfileResponse$UserProfileName' => '<p>The user profile name.</p>', 'ListAppsRequest$UserProfileNameEquals' => '<p>A parameter to search by user profile name.</p>', 'ListUserProfilesRequest$UserProfileNameContains' => '<p>A parameter by which to filter the results.</p>', 'UpdateUserProfileRequest$UserProfileName' => '<p>The user profile name.</p>', 'UserProfileDetails$UserProfileName' => '<p>The user profile name.</p>', ], ], 'UserProfileSortKey' => [ 'base' => NULL, 'refs' => [ 'ListUserProfilesRequest$SortBy' => '<p>The parameter by which to sort the results. The default is CreationTime.</p>', ], ], 'UserProfileStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeUserProfileResponse$Status' => '<p>The status.</p>', 'UserProfileDetails$Status' => '<p>The status.</p>', ], ], 'UserSettings' => [ 'base' => '<p>A collection of settings.</p>', 'refs' => [ 'CreateDomainRequest$DefaultUserSettings' => '<p>The default user settings.</p>', 'CreateUserProfileRequest$UserSettings' => '<p>A collection of settings.</p>', 'DescribeDomainResponse$DefaultUserSettings' => '<p>Settings which are applied to all UserProfile in this domain, if settings are not explicitly specified in a given UserProfile. </p>', 'DescribeUserProfileResponse$UserSettings' => '<p>A collection of settings.</p>', 'UpdateDomainRequest$DefaultUserSettings' => '<p>A collection of settings.</p>', 'UpdateUserProfileRequest$UserSettings' => '<p>A collection of settings.</p>', ], ], 'VariantName' => [ 'base' => NULL, 'refs' => [ 'DesiredWeightAndCapacity$VariantName' => '<p>The name of the variant to update.</p>', 'ProductionVariant$VariantName' => '<p>The name of the production variant.</p>', 'ProductionVariantSummary$VariantName' => '<p>The name of the variant.</p>', ], ], 'VariantProperty' => [ 'base' => '<p>Specifies a production variant property type for an Endpoint.</p> <p>If you are updating an endpoint with the <a>UpdateEndpointInput$RetainAllVariantProperties</a> option set to <code>true</code>, the <code>VariantProperty</code> objects listed in <a>UpdateEndpointInput$ExcludeRetainedVariantProperties</a> override the existing variant properties of the endpoint.</p>', 'refs' => [ 'VariantPropertyList$member' => NULL, ], ], 'VariantPropertyList' => [ 'base' => NULL, 'refs' => [ 'UpdateEndpointInput$ExcludeRetainedVariantProperties' => '<p>When you are updating endpoint resources with <a>UpdateEndpointInput$RetainAllVariantProperties</a>, whose value is set to <code>true</code>, <code>ExcludeRetainedVariantProperties</code> specifies the list of type <a>VariantProperty</a> to override with the values provided by <code>EndpointConfig</code>. If you don\'t specify a value for <code>ExcludeAllVariantProperties</code>, no variant properties are overridden. </p>', ], ], 'VariantPropertyType' => [ 'base' => NULL, 'refs' => [ 'VariantProperty$VariantPropertyType' => '<p>The type of variant property. The supported values are:</p> <ul> <li> <p> <code>DesiredInstanceCount</code>: Overrides the existing variant instance counts using the <a>ProductionVariant$InitialInstanceCount</a> values in the <a>CreateEndpointConfigInput$ProductionVariants</a>.</p> </li> <li> <p> <code>DesiredWeight</code>: Overrides the existing variant weights using the <a>ProductionVariant$InitialVariantWeight</a> values in the <a>CreateEndpointConfigInput$ProductionVariants</a>.</p> </li> <li> <p> <code>DataCaptureConfig</code>: (Not currently supported.)</p> </li> </ul>', ], ], 'VariantWeight' => [ 'base' => NULL, 'refs' => [ 'DesiredWeightAndCapacity$DesiredWeight' => '<p>The variant\'s weight.</p>', 'ProductionVariant$InitialVariantWeight' => '<p>Determines initial traffic distribution among all of the models that you specify in the endpoint configuration. The traffic to a production variant is determined by the ratio of the <code>VariantWeight</code> to the sum of all <code>VariantWeight</code> values across all ProductionVariants. If unspecified, it defaults to 1.0. </p>', 'ProductionVariantSummary$CurrentWeight' => '<p>The weight associated with the variant.</p>', 'ProductionVariantSummary$DesiredWeight' => '<p>The requested weight, as specified in the <code>UpdateEndpointWeightsAndCapacities</code> request. </p>', ], ], 'VolumeSizeInGB' => [ 'base' => NULL, 'refs' => [ 'ResourceConfig$VolumeSizeInGB' => '<p>The size of the ML storage volume that you want to provision. </p> <p>ML storage volumes store model artifacts and incremental states. Training algorithms might also use the ML storage volume for scratch space. If you want to store the training data in the ML storage volume, choose <code>File</code> as the <code>TrainingInputMode</code> in the algorithm specification. </p> <p>You must specify sufficient ML storage for your scenario. </p> <note> <p> Amazon SageMaker supports only the General Purpose SSD (gp2) ML storage volume type. </p> </note> <note> <p>Certain Nitro-based instances include local storage with a fixed total size, dependent on the instance type. When using these instances for training, Amazon SageMaker mounts the local instance storage instead of Amazon EBS gp2 storage. You can\'t request a <code>VolumeSizeInGB</code> greater than the total size of the local instance storage.</p> <p>For a list of instance types that support local instance storage, including the total size per instance type, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a>.</p> </note>', ], ], 'VpcConfig' => [ 'base' => '<p>Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html">Protect Endpoints by Using an Amazon Virtual Private Cloud</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an Amazon Virtual Private Cloud</a>. </p>', 'refs' => [ 'AutoMLSecurityConfig$VpcConfig' => '<p>VPC configuration.</p>', 'CreateModelInput$VpcConfig' => '<p>A <a>VpcConfig</a> object that specifies the VPC that you want your model to connect to. Control access to and from your model container by configuring the VPC. <code>VpcConfig</code> is used in hosting services and in batch transform. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html">Protect Endpoints by Using an Amazon Virtual Private Cloud</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-vpc.html">Protect Data in Batch Transform Jobs by Using an Amazon Virtual Private Cloud</a>.</p>', 'CreateTrainingJobRequest$VpcConfig' => '<p>A <a>VpcConfig</a> object that specifies the VPC that you want your training job to connect to. Control access to and from your training container by configuring the VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an Amazon Virtual Private Cloud</a>.</p>', 'DescribeModelOutput$VpcConfig' => '<p>A <a>VpcConfig</a> object that specifies the VPC that this model has access to. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html">Protect Endpoints by Using an Amazon Virtual Private Cloud</a> </p>', 'DescribeTrainingJobResponse$VpcConfig' => '<p>A <a>VpcConfig</a> object that specifies the VPC that this training job has access to. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an Amazon Virtual Private Cloud</a>.</p>', 'HyperParameterTrainingJobDefinition$VpcConfig' => '<p>The <a>VpcConfig</a> object that specifies the VPC that you want the training jobs that this hyperparameter tuning job launches to connect to. Control access to and from your training container by configuring the VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an Amazon Virtual Private Cloud</a>.</p>', 'NetworkConfig$VpcConfig' => NULL, 'TrainingJob$VpcConfig' => '<p>A <a>VpcConfig</a> object that specifies the VPC that this training job has access to. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an Amazon Virtual Private Cloud</a>.</p>', ], ], 'VpcId' => [ 'base' => NULL, 'refs' => [ 'CreateDomainRequest$VpcId' => '<p>The ID of the Amazon Virtual Private Cloud (VPC) to use for communication with the EFS volume.</p>', 'DescribeDomainResponse$VpcId' => '<p>The ID of the Amazon Virtual Private Cloud.</p>', ], ], 'VpcSecurityGroupIds' => [ 'base' => NULL, 'refs' => [ 'VpcConfig$SecurityGroupIds' => '<p>The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the <code>Subnets</code> field.</p>', ], ], 'Workforce' => [ 'base' => '<p>A single private workforce, which is automatically created when you create your first private work team. You can create one private work force in each AWS Region. By default, any workforce-related API operation used in a specific region will apply to the workforce created in that region. To learn how to create a private workforce, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html">Create a Private Workforce</a>.</p>', 'refs' => [ 'DescribeWorkforceResponse$Workforce' => '<p>A single private workforce, which is automatically created when you create your first private work team. You can create one private work force in each AWS Region. By default, any workforce-related API operation used in a specific region will apply to the workforce created in that region. To learn how to create a private workforce, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html">Create a Private Workforce</a>.</p>', 'UpdateWorkforceResponse$Workforce' => '<p>A single private workforce, which is automatically created when you create your first private work team. You can create one private work force in each AWS Region. By default, any workforce-related API operation used in a specific region will apply to the workforce created in that region. To learn how to create a private workforce, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html">Create a Private Workforce</a>.</p>', 'Workforces$member' => NULL, ], ], 'WorkforceArn' => [ 'base' => NULL, 'refs' => [ 'CreateWorkforceResponse$WorkforceArn' => '<p>The Amazon Resource Name (ARN) of the workforce.</p>', 'Workforce$WorkforceArn' => '<p>The Amazon Resource Name (ARN) of the private workforce.</p>', 'Workteam$WorkforceArn' => '<p>The Amazon Resource Name (ARN) of the workforce.</p>', ], ], 'WorkforceName' => [ 'base' => NULL, 'refs' => [ 'CreateWorkforceRequest$WorkforceName' => '<p>The name of the private workforce.</p>', 'CreateWorkteamRequest$WorkforceName' => '<p>The name of the workforce.</p>', 'DeleteWorkforceRequest$WorkforceName' => '<p>The name of the workforce.</p>', 'DescribeWorkforceRequest$WorkforceName' => '<p>The name of the private workforce whose access you want to restrict. <code>WorkforceName</code> is automatically set to <code>default</code> when a workforce is created and cannot be modified. </p>', 'ListWorkforcesRequest$NameContains' => '<p>A filter you can use to search for workforces using part of the workforce name.</p>', 'UpdateWorkforceRequest$WorkforceName' => '<p>The name of the private workforce whose access you want to restrict. <code>WorkforceName</code> is automatically set to <code>default</code> when a workforce is created and cannot be modified. </p>', 'Workforce$WorkforceName' => '<p>The name of the private workforce.</p>', ], ], 'Workforces' => [ 'base' => NULL, 'refs' => [ 'ListWorkforcesResponse$Workforces' => '<p>A list containing information about your workforce.</p>', ], ], 'Workteam' => [ 'base' => '<p>Provides details about a labeling work team.</p>', 'refs' => [ 'DescribeWorkteamResponse$Workteam' => '<p>A <code>Workteam</code> instance that contains information about the work team. </p>', 'UpdateWorkteamResponse$Workteam' => '<p>A <code>Workteam</code> object that describes the updated work team.</p>', 'Workteams$member' => NULL, ], ], 'WorkteamArn' => [ 'base' => NULL, 'refs' => [ 'CreateWorkteamResponse$WorkteamArn' => '<p>The Amazon Resource Name (ARN) of the work team. You can use this ARN to identify the work team.</p>', 'DescribeSubscribedWorkteamRequest$WorkteamArn' => '<p>The Amazon Resource Name (ARN) of the subscribed work team to describe.</p>', 'HumanLoopConfig$WorkteamArn' => '<p>Amazon Resource Name (ARN) of a team of workers.</p>', 'HumanTaskConfig$WorkteamArn' => '<p>The Amazon Resource Name (ARN) of the work team assigned to complete the tasks.</p>', 'LabelingJobSummary$WorkteamArn' => '<p>The Amazon Resource Name (ARN) of the work team assigned to the job.</p>', 'ListLabelingJobsForWorkteamRequest$WorkteamArn' => '<p>The Amazon Resource Name (ARN) of the work team for which you want to see labeling jobs for.</p>', 'SubscribedWorkteam$WorkteamArn' => '<p>The Amazon Resource Name (ARN) of the vendor that you have subscribed.</p>', 'Workteam$WorkteamArn' => '<p>The Amazon Resource Name (ARN) that identifies the work team.</p>', ], ], 'WorkteamName' => [ 'base' => NULL, 'refs' => [ 'CreateWorkteamRequest$WorkteamName' => '<p>The name of the work team. Use this name to identify the work team.</p>', 'DeleteWorkteamRequest$WorkteamName' => '<p>The name of the work team to delete.</p>', 'DescribeWorkteamRequest$WorkteamName' => '<p>The name of the work team to return a description of.</p>', 'ListSubscribedWorkteamsRequest$NameContains' => '<p>A string in the work team name. This filter returns only work teams whose name contains the specified string.</p>', 'ListWorkteamsRequest$NameContains' => '<p>A string in the work team\'s name. This filter returns only work teams whose name contains the specified string.</p>', 'UpdateWorkteamRequest$WorkteamName' => '<p>The name of the work team to update.</p>', 'Workteam$WorkteamName' => '<p>The name of the work team.</p>', ], ], 'Workteams' => [ 'base' => NULL, 'refs' => [ 'ListWorkteamsResponse$Workteams' => '<p>An array of <code>Workteam</code> objects, each describing a work team.</p>', ], ], ],];
