<?php
// This file was auto-generated from sdk-root/src/data/robomaker/2018-06-29/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>This section provides documentation for the AWS RoboMaker API operations.</p>', 'operations' => [ 'BatchDescribeSimulationJob' => '<p>Describes one or more simulation jobs.</p>', 'CancelDeploymentJob' => '<p>Cancels the specified deployment job.</p>', 'CancelSimulationJob' => '<p>Cancels the specified simulation job.</p>', 'CancelSimulationJobBatch' => '<p>Cancels a simulation job batch. When you cancel a simulation job batch, you are also cancelling all of the active simulation jobs created as part of the batch. </p>', 'CreateDeploymentJob' => '<p>Deploys a specific version of a robot application to robots in a fleet.</p> <p>The robot application must have a numbered <code>applicationVersion</code> for consistency reasons. To create a new version, use <code>CreateRobotApplicationVersion</code> or see <a href="https://docs.aws.amazon.com/robomaker/latest/dg/create-robot-application-version.html">Creating a Robot Application Version</a>. </p> <note> <p>After 90 days, deployment jobs expire and will be deleted. They will no longer be accessible. </p> </note>', 'CreateFleet' => '<p>Creates a fleet, a logical group of robots running the same robot application.</p>', 'CreateRobot' => '<p>Creates a robot.</p>', 'CreateRobotApplication' => '<p>Creates a robot application. </p>', 'CreateRobotApplicationVersion' => '<p>Creates a version of a robot application.</p>', 'CreateSimulationApplication' => '<p>Creates a simulation application.</p>', 'CreateSimulationApplicationVersion' => '<p>Creates a simulation application with a specific revision id.</p>', 'CreateSimulationJob' => '<p>Creates a simulation job.</p> <note> <p>After 90 days, simulation jobs expire and will be deleted. They will no longer be accessible. </p> </note>', 'DeleteFleet' => '<p>Deletes a fleet.</p>', 'DeleteRobot' => '<p>Deletes a robot.</p>', 'DeleteRobotApplication' => '<p>Deletes a robot application.</p>', 'DeleteSimulationApplication' => '<p>Deletes a simulation application.</p>', 'DeregisterRobot' => '<p>Deregisters a robot.</p>', 'DescribeDeploymentJob' => '<p>Describes a deployment job.</p>', 'DescribeFleet' => '<p>Describes a fleet.</p>', 'DescribeRobot' => '<p>Describes a robot.</p>', 'DescribeRobotApplication' => '<p>Describes a robot application.</p>', 'DescribeSimulationApplication' => '<p>Describes a simulation application.</p>', 'DescribeSimulationJob' => '<p>Describes a simulation job.</p>', 'DescribeSimulationJobBatch' => '<p>Describes a simulation job batch.</p>', 'ListDeploymentJobs' => '<p>Returns a list of deployment jobs for a fleet. You can optionally provide filters to retrieve specific deployment jobs. </p>', 'ListFleets' => '<p>Returns a list of fleets. You can optionally provide filters to retrieve specific fleets. </p>', 'ListRobotApplications' => '<p>Returns a list of robot application. You can optionally provide filters to retrieve specific robot applications.</p>', 'ListRobots' => '<p>Returns a list of robots. You can optionally provide filters to retrieve specific robots.</p>', 'ListSimulationApplications' => '<p>Returns a list of simulation applications. You can optionally provide filters to retrieve specific simulation applications. </p>', 'ListSimulationJobBatches' => '<p>Returns a list simulation job batches. You can optionally provide filters to retrieve specific simulation batch jobs. </p>', 'ListSimulationJobs' => '<p>Returns a list of simulation jobs. You can optionally provide filters to retrieve specific simulation jobs. </p>', 'ListTagsForResource' => '<p>Lists all tags on a AWS RoboMaker resource.</p>', 'RegisterRobot' => '<p>Registers a robot with a fleet.</p>', 'RestartSimulationJob' => '<p>Restarts a running simulation job.</p>', 'StartSimulationJobBatch' => '<p>Starts a new simulation job batch. The batch is defined using one or more <code>SimulationJobRequest</code> objects. </p>', 'SyncDeploymentJob' => '<p>Syncrhonizes robots in a fleet to the latest deployment. This is helpful if robots were added after a deployment.</p>', 'TagResource' => '<p>Adds or edits tags for a AWS RoboMaker resource.</p> <p>Each tag consists of a tag key and a tag value. Tag keys and tag values are both required, but tag values can be empty strings. </p> <p>For information about the rules that apply to tag keys and tag values, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html">User-Defined Tag Restrictions</a> in the <i>AWS Billing and Cost Management User Guide</i>. </p>', 'UntagResource' => '<p>Removes the specified tags from the specified AWS RoboMaker resource.</p> <p>To remove a tag, specify the tag key. To change the tag value of an existing tag key, use <a href="https://docs.aws.amazon.com/robomaker/latest/dg/API_TagResource.html"> <code>TagResource</code> </a>. </p>', 'UpdateRobotApplication' => '<p>Updates a robot application.</p>', 'UpdateSimulationApplication' => '<p>Updates a simulation application.</p>', ], 'shapes' => [ 'Architecture' => [ 'base' => NULL, 'refs' => [ 'CreateRobotRequest$architecture' => '<p>The target architecture of the robot.</p>', 'CreateRobotResponse$architecture' => '<p>The target architecture of the robot.</p>', 'DescribeRobotResponse$architecture' => '<p>The target architecture of the robot application.</p>', 'Robot$architecture' => '<p>The architecture of the robot.</p>', 'Source$architecture' => '<p>The taget processor architecture for the application.</p>', 'SourceConfig$architecture' => '<p>The target processor architecture for the application.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'Arns$member' => NULL, 'CancelDeploymentJobRequest$job' => '<p>The deployment job ARN to cancel.</p>', 'CancelSimulationJobBatchRequest$batch' => '<p>The id of the batch to cancel.</p>', 'CancelSimulationJobRequest$job' => '<p>The simulation job ARN to cancel.</p>', 'CreateDeploymentJobRequest$fleet' => '<p>The Amazon Resource Name (ARN) of the fleet to deploy.</p>', 'CreateDeploymentJobResponse$arn' => '<p>The Amazon Resource Name (ARN) of the deployment job.</p>', 'CreateDeploymentJobResponse$fleet' => '<p>The target fleet for the deployment job.</p>', 'CreateFleetResponse$arn' => '<p>The Amazon Resource Name (ARN) of the fleet.</p>', 'CreateRobotApplicationResponse$arn' => '<p>The Amazon Resource Name (ARN) of the robot application.</p>', 'CreateRobotApplicationVersionRequest$application' => '<p>The application information for the robot application.</p>', 'CreateRobotApplicationVersionResponse$arn' => '<p>The Amazon Resource Name (ARN) of the robot application.</p>', 'CreateRobotResponse$arn' => '<p>The Amazon Resource Name (ARN) of the robot.</p>', 'CreateSimulationApplicationResponse$arn' => '<p>The Amazon Resource Name (ARN) of the simulation application.</p>', 'CreateSimulationApplicationVersionRequest$application' => '<p>The application information for the simulation application.</p>', 'CreateSimulationApplicationVersionResponse$arn' => '<p>The Amazon Resource Name (ARN) of the simulation application.</p>', 'CreateSimulationJobResponse$arn' => '<p>The Amazon Resource Name (ARN) of the simulation job.</p>', 'DeleteFleetRequest$fleet' => '<p>The Amazon Resource Name (ARN) of the fleet.</p>', 'DeleteRobotApplicationRequest$application' => '<p>The Amazon Resource Name (ARN) of the the robot application.</p>', 'DeleteRobotRequest$robot' => '<p>The Amazon Resource Name (ARN) of the robot.</p>', 'DeleteSimulationApplicationRequest$application' => '<p>The application information for the simulation application to delete.</p>', 'DeploymentApplicationConfig$application' => '<p>The Amazon Resource Name (ARN) of the robot application.</p>', 'DeploymentJob$arn' => '<p>The Amazon Resource Name (ARN) of the deployment job.</p>', 'DeploymentJob$fleet' => '<p>The Amazon Resource Name (ARN) of the fleet.</p>', 'DeregisterRobotRequest$fleet' => '<p>The Amazon Resource Name (ARN) of the fleet.</p>', 'DeregisterRobotRequest$robot' => '<p>The Amazon Resource Name (ARN) of the robot.</p>', 'DeregisterRobotResponse$fleet' => '<p>The Amazon Resource Name (ARN) of the fleet.</p>', 'DeregisterRobotResponse$robot' => '<p>The Amazon Resource Name (ARN) of the robot.</p>', 'DescribeDeploymentJobRequest$job' => '<p>The Amazon Resource Name (ARN) of the deployment job.</p>', 'DescribeDeploymentJobResponse$arn' => '<p>The Amazon Resource Name (ARN) of the deployment job.</p>', 'DescribeDeploymentJobResponse$fleet' => '<p>The Amazon Resource Name (ARN) of the fleet.</p>', 'DescribeFleetRequest$fleet' => '<p>The Amazon Resource Name (ARN) of the fleet.</p>', 'DescribeFleetResponse$arn' => '<p>The Amazon Resource Name (ARN) of the fleet.</p>', 'DescribeFleetResponse$lastDeploymentJob' => '<p>The Amazon Resource Name (ARN) of the last deployment job.</p>', 'DescribeRobotApplicationRequest$application' => '<p>The Amazon Resource Name (ARN) of the robot application.</p>', 'DescribeRobotApplicationResponse$arn' => '<p>The Amazon Resource Name (ARN) of the robot application.</p>', 'DescribeRobotRequest$robot' => '<p>The Amazon Resource Name (ARN) of the robot to be described.</p>', 'DescribeRobotResponse$arn' => '<p>The Amazon Resource Name (ARN) of the robot.</p>', 'DescribeRobotResponse$fleetArn' => '<p>The Amazon Resource Name (ARN) of the fleet.</p>', 'DescribeRobotResponse$lastDeploymentJob' => '<p>The Amazon Resource Name (ARN) of the last deployment job.</p>', 'DescribeSimulationApplicationRequest$application' => '<p>The application information for the simulation application.</p>', 'DescribeSimulationApplicationResponse$arn' => '<p>The Amazon Resource Name (ARN) of the robot simulation application.</p>', 'DescribeSimulationJobBatchRequest$batch' => '<p>The id of the batch to describe.</p>', 'DescribeSimulationJobBatchResponse$arn' => '<p>The Amazon Resource Name (ARN) of the batch.</p>', 'DescribeSimulationJobRequest$job' => '<p>The Amazon Resource Name (ARN) of the simulation job to be described.</p>', 'DescribeSimulationJobResponse$arn' => '<p>The Amazon Resource Name (ARN) of the simulation job.</p>', 'Fleet$arn' => '<p>The Amazon Resource Name (ARN) of the fleet.</p>', 'Fleet$lastDeploymentJob' => '<p>The Amazon Resource Name (ARN) of the last deployment job.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The AWS RoboMaker Amazon Resource Name (ARN) with tags to be listed.</p>', 'RegisterRobotRequest$fleet' => '<p>The Amazon Resource Name (ARN) of the fleet.</p>', 'RegisterRobotRequest$robot' => '<p>The Amazon Resource Name (ARN) of the robot.</p>', 'RegisterRobotResponse$fleet' => '<p>The Amazon Resource Name (ARN) of the fleet that the robot will join.</p>', 'RegisterRobotResponse$robot' => '<p>Information about the robot registration.</p>', 'RestartSimulationJobRequest$job' => '<p>The Amazon Resource Name (ARN) of the simulation job.</p>', 'Robot$arn' => '<p>The Amazon Resource Name (ARN) of the robot.</p>', 'Robot$fleetArn' => '<p>The Amazon Resource Name (ARN) of the fleet.</p>', 'Robot$lastDeploymentJob' => '<p>The Amazon Resource Name (ARN) of the last deployment job.</p>', 'RobotApplicationConfig$application' => '<p>The application information for the robot application.</p>', 'RobotApplicationSummary$arn' => '<p>The Amazon Resource Name (ARN) of the robot.</p>', 'RobotDeployment$arn' => '<p>The robot deployment Amazon Resource Name (ARN).</p>', 'SimulationApplicationConfig$application' => '<p>The application information for the simulation application.</p>', 'SimulationApplicationSummary$arn' => '<p>The Amazon Resource Name (ARN) of the simulation application.</p>', 'SimulationJob$arn' => '<p>The Amazon Resource Name (ARN) of the simulation job.</p>', 'SimulationJobBatchSummary$arn' => '<p>The Amazon Resource Name (ARN) of the batch.</p>', 'SimulationJobSummary$arn' => '<p>The Amazon Resource Name (ARN) of the simulation job.</p>', 'StartSimulationJobBatchResponse$arn' => '<p>The Amazon Resource Name (arn) of the batch.</p>', 'SyncDeploymentJobRequest$fleet' => '<p>The target fleet for the synchronization.</p>', 'SyncDeploymentJobResponse$arn' => '<p>The Amazon Resource Name (ARN) of the synchronization request.</p>', 'SyncDeploymentJobResponse$fleet' => '<p>The Amazon Resource Name (ARN) of the fleet.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the AWS RoboMaker resource you are tagging.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the AWS RoboMaker resource you are removing tags.</p>', 'UpdateRobotApplicationRequest$application' => '<p>The application information for the robot application.</p>', 'UpdateRobotApplicationResponse$arn' => '<p>The Amazon Resource Name (ARN) of the updated robot application.</p>', 'UpdateSimulationApplicationRequest$application' => '<p>The application information for the simulation application.</p>', 'UpdateSimulationApplicationResponse$arn' => '<p>The Amazon Resource Name (ARN) of the updated simulation application.</p>', ], ], 'Arns' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeSimulationJobRequest$jobs' => '<p>A list of Amazon Resource Names (ARNs) of simulation jobs to describe.</p>', 'BatchDescribeSimulationJobResponse$unprocessedJobs' => '<p>A list of unprocessed simulation job Amazon Resource Names (ARNs).</p>', ], ], 'BatchDescribeSimulationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDescribeSimulationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchPolicy' => [ 'base' => '<p>Information about the batch policy.</p>', 'refs' => [ 'DescribeSimulationJobBatchResponse$batchPolicy' => '<p>The batch policy.</p>', 'StartSimulationJobBatchRequest$batchPolicy' => '<p>The batch policy.</p>', 'StartSimulationJobBatchResponse$batchPolicy' => '<p>The batch policy.</p>', ], ], 'BatchTimeoutInSeconds' => [ 'base' => NULL, 'refs' => [ 'BatchPolicy$timeoutInSeconds' => '<p>The amount of time, in seconds, to wait for the batch to complete. </p> <p>If a batch times out, and there are pending requests that were failing due to an internal failure (like <code>InternalServiceError</code>), they will be moved to the failed list and the batch status will be <code>Failed</code>. If the pending requests were failing for any other reason, the failed pending requests will be moved to the failed list and the batch status will be <code>TimedOut</code>. </p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'LaunchConfig$streamUI' => '<p>Boolean indicating whether a streaming session will be configured for the application. If <code>True</code>, AWS RoboMaker will configure a connection so you can interact with your application as it is running in the simulation. You must configure and luanch the component. It must have a graphical user interface. </p>', 'PortMapping$enableOnPublicIp' => '<p>A Boolean indicating whether to enable this port mapping on public IP.</p>', 'VPCConfig$assignPublicIp' => '<p>A boolean indicating whether to assign a public IP address.</p>', 'VPCConfigResponse$assignPublicIp' => '<p>A boolean indicating if a public IP was assigned.</p>', ], ], 'BoxedBoolean' => [ 'base' => NULL, 'refs' => [ 'LoggingConfig$recordAllRosTopics' => '<p>A boolean indicating whether to record all ROS topics.</p>', 'SimulationJobRequest$useDefaultApplications' => '<p>Boolean indicating whether to use default simulation tool applications.</p>', ], ], 'CancelDeploymentJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelDeploymentJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CancelSimulationJobBatchRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelSimulationJobBatchResponse' => [ 'base' => NULL, 'refs' => [], ], 'CancelSimulationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelSimulationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'ClientRequestToken' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentJobRequest$clientRequestToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'CreateSimulationJobRequest$clientRequestToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'CreateSimulationJobResponse$clientRequestToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'DescribeSimulationJobBatchResponse$clientRequestToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'DescribeSimulationJobResponse$clientRequestToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'SimulationJob$clientRequestToken' => '<p>A unique identifier for this <code>SimulationJob</code> request.</p>', 'StartSimulationJobBatchRequest$clientRequestToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'StartSimulationJobBatchResponse$clientRequestToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'SyncDeploymentJobRequest$clientRequestToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', ], ], 'Command' => [ 'base' => NULL, 'refs' => [ 'DeploymentLaunchConfig$packageName' => '<p>The package name.</p>', 'DeploymentLaunchConfig$launchFile' => '<p>The launch file name.</p>', 'LaunchConfig$packageName' => '<p>The package name.</p>', 'LaunchConfig$launchFile' => '<p>The launch file name.</p>', ], ], 'Compute' => [ 'base' => '<p>Compute information for the simulation job.</p>', 'refs' => [ 'CreateSimulationJobRequest$compute' => '<p>Compute information for the simulation job.</p>', 'SimulationJobRequest$compute' => '<p>Compute information for the simulation job</p>', ], ], 'ComputeResponse' => [ 'base' => '<p>Compute information for the simulation job</p>', 'refs' => [ 'CreateSimulationJobResponse$compute' => '<p>Compute information for the simulation job.</p>', 'DescribeSimulationJobResponse$compute' => '<p>Compute information for the simulation job.</p>', 'SimulationJob$compute' => '<p>Compute information for the simulation job</p>', ], ], 'ConcurrentDeploymentException' => [ 'base' => '<p>The failure percentage threshold percentage was met.</p>', 'refs' => [], ], 'CreateDeploymentJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDeploymentJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFleetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRobotApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRobotApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRobotApplicationVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRobotApplicationVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRobotRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRobotResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSimulationApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSimulationApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSimulationApplicationVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSimulationApplicationVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSimulationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSimulationJobRequests' => [ 'base' => NULL, 'refs' => [ 'DescribeSimulationJobBatchResponse$pendingRequests' => '<p>A list of pending simulation job requests. These requests have not yet been created into simulation jobs.</p>', 'StartSimulationJobBatchRequest$createSimulationJobRequests' => '<p>A list of simulation job requests to create in the batch.</p>', 'StartSimulationJobBatchResponse$pendingRequests' => '<p>A list of pending simulation job requests. These requests have not yet been created into simulation jobs.</p>', ], ], 'CreateSimulationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatedAt' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentJobResponse$createdAt' => '<p>The time, in milliseconds since the epoch, when the fleet was created.</p>', 'CreateFleetResponse$createdAt' => '<p>The time, in milliseconds since the epoch, when the fleet was created.</p>', 'CreateRobotResponse$createdAt' => '<p>The time, in milliseconds since the epoch, when the robot was created.</p>', 'DeploymentJob$createdAt' => '<p>The time, in milliseconds since the epoch, when the deployment job was created.</p>', 'DescribeDeploymentJobResponse$createdAt' => '<p>The time, in milliseconds since the epoch, when the deployment job was created.</p>', 'DescribeFleetResponse$createdAt' => '<p>The time, in milliseconds since the epoch, when the fleet was created.</p>', 'DescribeFleetResponse$lastDeploymentTime' => '<p>The time of the last deployment.</p>', 'DescribeRobotResponse$createdAt' => '<p>The time, in milliseconds since the epoch, when the robot was created.</p>', 'DescribeRobotResponse$lastDeploymentTime' => '<p>The time of the last deployment job.</p>', 'DescribeSimulationJobBatchResponse$createdAt' => '<p>The time, in milliseconds since the epoch, when the simulation job batch was created.</p>', 'Fleet$createdAt' => '<p>The time, in milliseconds since the epoch, when the fleet was created.</p>', 'Fleet$lastDeploymentTime' => '<p>The time of the last deployment.</p>', 'Robot$createdAt' => '<p>The time, in milliseconds since the epoch, when the robot was created.</p>', 'Robot$lastDeploymentTime' => '<p>The time of the last deployment.</p>', 'RobotDeployment$deploymentStartTime' => '<p>The time, in milliseconds since the epoch, when the deployment was started.</p>', 'RobotDeployment$deploymentFinishTime' => '<p>The time, in milliseconds since the epoch, when the deployment finished.</p>', 'SimulationJobBatchSummary$createdAt' => '<p>The time, in milliseconds since the epoch, when the simulation job batch was created.</p>', 'StartSimulationJobBatchResponse$createdAt' => '<p>The time, in milliseconds since the epoch, when the simulation job batch was created.</p>', 'SyncDeploymentJobResponse$createdAt' => '<p>The time, in milliseconds since the epoch, when the fleet was created.</p>', ], ], 'DataSource' => [ 'base' => '<p>Information about a data source.</p>', 'refs' => [ 'DataSources$member' => NULL, ], ], 'DataSourceConfig' => [ 'base' => '<p>Information about a data source.</p>', 'refs' => [ 'DataSourceConfigs$member' => NULL, ], ], 'DataSourceConfigs' => [ 'base' => NULL, 'refs' => [ 'CreateSimulationJobRequest$dataSources' => '<p>Specify data sources to mount read-only files from S3 into your simulation. These files are available under <code>/opt/robomaker/datasources/data_source_name</code>. </p> <note> <p>There is a limit of 100 files and a combined size of 25GB for all <code>DataSourceConfig</code> objects. </p> </note>', 'SimulationJobRequest$dataSources' => '<p>Specify data sources to mount read-only files from S3 into your simulation. These files are available under <code>/opt/robomaker/datasources/data_source_name</code>. </p> <note> <p>There is a limit of 100 files and a combined size of 25GB for all <code>DataSourceConfig</code> objects. </p> </note>', ], ], 'DataSourceNames' => [ 'base' => NULL, 'refs' => [ 'SimulationJobSummary$dataSourceNames' => '<p>The names of the data sources.</p>', ], ], 'DataSources' => [ 'base' => NULL, 'refs' => [ 'CreateSimulationJobResponse$dataSources' => '<p>The data sources for the simulation job.</p>', 'DescribeSimulationJobResponse$dataSources' => '<p>The data sources for the simulation job.</p>', 'SimulationJob$dataSources' => '<p>The data sources for the simulation job.</p>', ], ], 'DeleteFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFleetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRobotApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRobotApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRobotRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRobotResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSimulationApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSimulationApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeploymentApplicationConfig' => [ 'base' => '<p>Information about a deployment application configuration.</p>', 'refs' => [ 'DeploymentApplicationConfigs$member' => NULL, ], ], 'DeploymentApplicationConfigs' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentJobRequest$deploymentApplicationConfigs' => '<p>The deployment application configuration.</p>', 'CreateDeploymentJobResponse$deploymentApplicationConfigs' => '<p>The deployment application configuration.</p>', 'DeploymentJob$deploymentApplicationConfigs' => '<p>The deployment application configuration.</p>', 'DescribeDeploymentJobResponse$deploymentApplicationConfigs' => '<p>The deployment application configuration.</p>', 'SyncDeploymentJobResponse$deploymentApplicationConfigs' => '<p>Information about the deployment application configurations.</p>', ], ], 'DeploymentConfig' => [ 'base' => '<p>Information about a deployment configuration.</p>', 'refs' => [ 'CreateDeploymentJobRequest$deploymentConfig' => '<p>The requested deployment configuration.</p>', 'CreateDeploymentJobResponse$deploymentConfig' => '<p>The deployment configuration.</p>', 'DeploymentJob$deploymentConfig' => '<p>The deployment configuration.</p>', 'DescribeDeploymentJobResponse$deploymentConfig' => '<p>The deployment configuration.</p>', 'SyncDeploymentJobResponse$deploymentConfig' => '<p>Information about the deployment configuration.</p>', ], ], 'DeploymentJob' => [ 'base' => '<p>Information about a deployment job.</p>', 'refs' => [ 'DeploymentJobs$member' => NULL, ], ], 'DeploymentJobErrorCode' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentJobResponse$failureCode' => '<p>The failure code of the simulation job if it failed:</p> <dl> <dt>BadPermissionError</dt> <dd> <p>AWS Greengrass requires a service-level role permission to access other services. The role must include the <a href="https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSGreengrassResourceAccessRolePolicy$jsonEditor"> <code>AWSGreengrassResourceAccessRolePolicy</code> managed policy</a>. </p> </dd> <dt>ExtractingBundleFailure</dt> <dd> <p>The robot application could not be extracted from the bundle.</p> </dd> <dt>FailureThresholdBreached</dt> <dd> <p>The percentage of robots that could not be updated exceeded the percentage set for the deployment.</p> </dd> <dt>GreengrassDeploymentFailed</dt> <dd> <p>The robot application could not be deployed to the robot.</p> </dd> <dt>GreengrassGroupVersionDoesNotExist</dt> <dd> <p>The AWS Greengrass group or version associated with a robot is missing.</p> </dd> <dt>InternalServerError</dt> <dd> <p>An internal error has occurred. Retry your request, but if the problem persists, contact us with details.</p> </dd> <dt>MissingRobotApplicationArchitecture</dt> <dd> <p>The robot application does not have a source that matches the architecture of the robot.</p> </dd> <dt>MissingRobotDeploymentResource</dt> <dd> <p>One or more of the resources specified for the robot application are missing. For example, does the robot application have the correct launch package and launch file?</p> </dd> <dt>PostLaunchFileFailure</dt> <dd> <p>The post-launch script failed.</p> </dd> <dt>PreLaunchFileFailure</dt> <dd> <p>The pre-launch script failed.</p> </dd> <dt>ResourceNotFound</dt> <dd> <p>One or more deployment resources are missing. For example, do robot application source bundles still exist? </p> </dd> <dt>RobotDeploymentNoResponse</dt> <dd> <p>There is no response from the robot. It might not be powered on or connected to the internet.</p> </dd> </dl>', 'DeploymentJob$failureCode' => '<p>The deployment job failure code.</p>', 'DescribeDeploymentJobResponse$failureCode' => '<p>The deployment job failure code.</p>', 'RobotDeployment$failureCode' => '<p>The robot deployment failure code.</p>', 'SyncDeploymentJobResponse$failureCode' => '<p>The failure code if the job fails:</p> <dl> <dt>InternalServiceError</dt> <dd> <p>Internal service error.</p> </dd> <dt>RobotApplicationCrash</dt> <dd> <p>Robot application exited abnormally.</p> </dd> <dt>SimulationApplicationCrash</dt> <dd> <p> Simulation application exited abnormally.</p> </dd> <dt>BadPermissionsRobotApplication</dt> <dd> <p>Robot application bundle could not be downloaded.</p> </dd> <dt>BadPermissionsSimulationApplication</dt> <dd> <p>Simulation application bundle could not be downloaded.</p> </dd> <dt>BadPermissionsS3Output</dt> <dd> <p>Unable to publish outputs to customer-provided S3 bucket.</p> </dd> <dt>BadPermissionsCloudwatchLogs</dt> <dd> <p>Unable to publish logs to customer-provided CloudWatch Logs resource.</p> </dd> <dt>SubnetIpLimitExceeded</dt> <dd> <p>Subnet IP limit exceeded.</p> </dd> <dt>ENILimitExceeded</dt> <dd> <p>ENI limit exceeded.</p> </dd> <dt>BadPermissionsUserCredentials</dt> <dd> <p>Unable to use the Role provided.</p> </dd> <dt>InvalidBundleRobotApplication</dt> <dd> <p>Robot bundle cannot be extracted (invalid format, bundling error, or other issue).</p> </dd> <dt>InvalidBundleSimulationApplication</dt> <dd> <p>Simulation bundle cannot be extracted (invalid format, bundling error, or other issue).</p> </dd> <dt>RobotApplicationVersionMismatchedEtag</dt> <dd> <p>Etag for RobotApplication does not match value during version creation.</p> </dd> <dt>SimulationApplicationVersionMismatchedEtag</dt> <dd> <p>Etag for SimulationApplication does not match value during version creation.</p> </dd> </dl>', ], ], 'DeploymentJobs' => [ 'base' => NULL, 'refs' => [ 'ListDeploymentJobsResponse$deploymentJobs' => '<p>A list of deployment jobs that meet the criteria of the request.</p>', ], ], 'DeploymentLaunchConfig' => [ 'base' => '<p>Configuration information for a deployment launch.</p>', 'refs' => [ 'DeploymentApplicationConfig$launchConfig' => '<p>The launch configuration.</p>', ], ], 'DeploymentStatus' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentJobResponse$status' => '<p>The status of the deployment job.</p>', 'DeploymentJob$status' => '<p>The status of the deployment job.</p>', 'DescribeDeploymentJobResponse$status' => '<p>The status of the deployment job.</p>', 'DescribeFleetResponse$lastDeploymentStatus' => '<p>The status of the last deployment.</p>', 'Fleet$lastDeploymentStatus' => '<p>The status of the last fleet deployment.</p>', 'SyncDeploymentJobResponse$status' => '<p>The status of the synchronization job.</p>', ], ], 'DeploymentTimeout' => [ 'base' => NULL, 'refs' => [ 'DeploymentConfig$robotDeploymentTimeoutInSeconds' => '<p>The amount of time, in seconds, to wait for deployment to a single robot to complete. Choose a time between 1 minute and 7 days. The default is 5 hours.</p>', ], ], 'DeploymentVersion' => [ 'base' => NULL, 'refs' => [ 'DeploymentApplicationConfig$applicationVersion' => '<p>The version of the application.</p>', ], ], 'DeregisterRobotRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterRobotResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDeploymentJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDeploymentJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFleetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRobotApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRobotApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRobotRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRobotResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSimulationApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSimulationApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSimulationJobBatchRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSimulationJobBatchResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSimulationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSimulationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'EnvironmentVariableKey' => [ 'base' => NULL, 'refs' => [ 'EnvironmentVariableMap$key' => NULL, ], ], 'EnvironmentVariableMap' => [ 'base' => NULL, 'refs' => [ 'DeploymentLaunchConfig$environmentVariables' => '<p>An array of key/value pairs specifying environment variables for the robot application</p>', 'LaunchConfig$environmentVariables' => '<p>The environment variables for the application launch.</p>', ], ], 'EnvironmentVariableValue' => [ 'base' => NULL, 'refs' => [ 'EnvironmentVariableMap$value' => NULL, ], ], 'FailedAt' => [ 'base' => NULL, 'refs' => [ 'FailedCreateSimulationJobRequest$failedAt' => '<p>The time, in milliseconds since the epoch, when the simulation job batch failed.</p>', ], ], 'FailedCreateSimulationJobRequest' => [ 'base' => '<p>Information about a failed create simulation job request.</p>', 'refs' => [ 'FailedCreateSimulationJobRequests$member' => NULL, ], ], 'FailedCreateSimulationJobRequests' => [ 'base' => NULL, 'refs' => [ 'DescribeSimulationJobBatchResponse$failedRequests' => '<p>A list of failed create simulation job requests. The request failed to be created into a simulation job. Failed requests do not have a simulation job ID. </p>', 'StartSimulationJobBatchResponse$failedRequests' => '<p>A list of failed simulation job requests. The request failed to be created into a simulation job. Failed requests do not have a simulation job ID. </p>', ], ], 'FailureBehavior' => [ 'base' => NULL, 'refs' => [ 'CreateSimulationJobRequest$failureBehavior' => '<p>The failure behavior the simulation job.</p> <dl> <dt>Continue</dt> <dd> <p>Restart the simulation job in the same host instance.</p> </dd> <dt>Fail</dt> <dd> <p>Stop the simulation job and terminate the instance.</p> </dd> </dl>', 'CreateSimulationJobResponse$failureBehavior' => '<p>the failure behavior for the simulation job.</p>', 'DescribeSimulationJobResponse$failureBehavior' => '<p>The failure behavior for the simulation job.</p>', 'SimulationJob$failureBehavior' => '<p>The failure behavior the simulation job.</p> <dl> <dt>Continue</dt> <dd> <p>Restart the simulation job in the same host instance.</p> </dd> <dt>Fail</dt> <dd> <p>Stop the simulation job and terminate the instance.</p> </dd> </dl>', 'SimulationJobRequest$failureBehavior' => '<p>The failure behavior the simulation job.</p> <dl> <dt>Continue</dt> <dd> <p>Restart the simulation job in the same host instance.</p> </dd> <dt>Fail</dt> <dd> <p>Stop the simulation job and terminate the instance.</p> </dd> </dl>', ], ], 'Filter' => [ 'base' => '<p>Information about a filter.</p>', 'refs' => [ 'Filters$member' => NULL, ], ], 'FilterValues' => [ 'base' => NULL, 'refs' => [ 'Filter$values' => '<p>A list of values.</p>', ], ], 'Filters' => [ 'base' => NULL, 'refs' => [ 'ListDeploymentJobsRequest$filters' => '<p>Optional filters to limit results.</p> <p>The filter names <code>status</code> and <code>fleetName</code> are supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters, but they must be for the same named item. For example, if you are looking for items with the status <code>InProgress</code> or the status <code>Pending</code>.</p>', 'ListFleetsRequest$filters' => '<p>Optional filters to limit results.</p> <p>The filter name <code>name</code> is supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters.</p>', 'ListRobotApplicationsRequest$filters' => '<p>Optional filters to limit results.</p> <p>The filter name <code>name</code> is supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters.</p>', 'ListRobotsRequest$filters' => '<p>Optional filters to limit results.</p> <p>The filter names <code>status</code> and <code>fleetName</code> are supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters, but they must be for the same named item. For example, if you are looking for items with the status <code>Registered</code> or the status <code>Available</code>.</p>', 'ListSimulationApplicationsRequest$filters' => '<p>Optional list of filters to limit results.</p> <p>The filter name <code>name</code> is supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters.</p>', 'ListSimulationJobBatchesRequest$filters' => '<p>Optional filters to limit results.</p>', 'ListSimulationJobsRequest$filters' => '<p>Optional filters to limit results.</p> <p>The filter names <code>status</code> and <code>simulationApplicationName</code> and <code>robotApplicationName</code> are supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters, but they must be for the same named item. For example, if you are looking for items with the status <code>Preparing</code> or the status <code>Running</code>.</p>', ], ], 'Fleet' => [ 'base' => '<p>Information about a fleet.</p>', 'refs' => [ 'Fleets$member' => NULL, ], ], 'Fleets' => [ 'base' => NULL, 'refs' => [ 'ListFleetsResponse$fleetDetails' => '<p>A list of fleet details meeting the request criteria.</p>', ], ], 'GenericInteger' => [ 'base' => NULL, 'refs' => [ 'ProgressDetail$estimatedTimeRemainingSeconds' => '<p>Estimated amount of time in seconds remaining in the step. This currently only applies to the <code>Downloading/Extracting</code> step of the deployment. It is empty for other steps.</p>', ], ], 'GenericString' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentJobResponse$failureReason' => '<p>The failure reason of the deployment job if it failed.</p>', 'DeploymentJob$failureReason' => '<p>A short description of the reason why the deployment job failed.</p>', 'DescribeDeploymentJobResponse$failureReason' => '<p>A short description of the reason why the deployment job failed.</p>', 'DescribeSimulationJobBatchResponse$failureReason' => '<p>The reason the simulation job batch failed.</p>', 'DescribeSimulationJobResponse$failureReason' => '<p>Details about why the simulation job failed. For more information about troubleshooting, see <a href="https://docs.aws.amazon.com/robomaker/latest/dg/troubleshooting.html">Troubleshooting</a>.</p>', 'FailedCreateSimulationJobRequest$failureReason' => '<p>The failure reason of the simulation job request.</p>', 'NetworkInterface$networkInterfaceId' => '<p>The ID of the network interface.</p>', 'NetworkInterface$privateIpAddress' => '<p>The IPv4 address of the network interface within the subnet.</p>', 'NetworkInterface$publicIpAddress' => '<p>The IPv4 public address of the network interface.</p>', 'ProgressDetail$targetResource' => '<p>The Amazon Resource Name (ARN) of the deployment job.</p>', 'RobotDeployment$failureReason' => '<p>A short description of the reason why the robot deployment failed.</p>', 'SimulationJob$failureReason' => '<p>The reason why the simulation job failed.</p>', 'StartSimulationJobBatchResponse$failureReason' => '<p>The reason the simulation job batch failed.</p>', 'SyncDeploymentJobResponse$failureReason' => '<p>The failure reason if the job fails.</p>', 'VPCConfigResponse$vpcId' => '<p>The VPC ID associated with your simulation job.</p>', ], ], 'IamRole' => [ 'base' => NULL, 'refs' => [ 'CreateSimulationJobRequest$iamRole' => '<p>The IAM role name that allows the simulation instance to call the AWS APIs that are specified in its associated policies on your behalf. This is how credentials are passed in to your simulation job. </p>', 'CreateSimulationJobResponse$iamRole' => '<p>The IAM role that allows the simulation job to call the AWS APIs that are specified in its associated policies on your behalf.</p>', 'DescribeSimulationJobResponse$iamRole' => '<p>The IAM role that allows the simulation instance to call the AWS APIs that are specified in its associated policies on your behalf.</p>', 'SimulationJob$iamRole' => '<p>The IAM role that allows the simulation instance to call the AWS APIs that are specified in its associated policies on your behalf. This is how credentials are passed in to your simulation job. </p>', 'SimulationJobRequest$iamRole' => '<p>The IAM role name that allows the simulation instance to call the AWS APIs that are specified in its associated policies on your behalf. This is how credentials are passed in to your simulation job. </p>', ], ], 'Id' => [ 'base' => NULL, 'refs' => [ 'CreateRobotRequest$greengrassGroupId' => '<p>The Greengrass group id.</p>', 'CreateRobotResponse$greengrassGroupId' => '<p>The Amazon Resource Name (ARN) of the Greengrass group associated with the robot.</p>', 'DescribeRobotResponse$greengrassGroupId' => '<p>The Greengrass group id.</p>', 'Robot$greenGrassGroupId' => '<p>The Greengrass group associated with the robot.</p>', ], ], 'IdempotentParameterMismatchException' => [ 'base' => '<p>The request uses the same client token as a previous, but non-identical request. Do not reuse a client token with different requests, unless the requests are identical. </p>', 'refs' => [], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'SimulationJobBatchSummary$failedRequestCount' => '<p>The number of failed simulation job requests.</p>', 'SimulationJobBatchSummary$pendingRequestCount' => '<p>The number of pending simulation job requests.</p>', 'SimulationJobBatchSummary$createdRequestCount' => '<p>The number of created simulation job requests.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>AWS RoboMaker experienced a service issue. Try your call again.</p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => '<p>A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message provides an explanation of the error value.</p>', 'refs' => [], ], 'JobDuration' => [ 'base' => NULL, 'refs' => [ 'CreateSimulationJobRequest$maxJobDurationInSeconds' => '<p>The maximum simulation job duration in seconds (up to 14 days or 1,209,600 seconds. When <code>maxJobDurationInSeconds</code> is reached, the simulation job will status will transition to <code>Completed</code>.</p>', 'CreateSimulationJobResponse$maxJobDurationInSeconds' => '<p>The maximum simulation job duration in seconds. </p>', 'DescribeSimulationJobResponse$maxJobDurationInSeconds' => '<p>The maximum job duration in seconds. The value must be 8 days (691,200 seconds) or less.</p>', 'SimulationJob$maxJobDurationInSeconds' => '<p>The maximum simulation job duration in seconds. The value must be 8 days (691,200 seconds) or less.</p>', 'SimulationJobRequest$maxJobDurationInSeconds' => '<p>The maximum simulation job duration in seconds. The value must be 8 days (691,200 seconds) or less.</p>', ], ], 'LastStartedAt' => [ 'base' => NULL, 'refs' => [ 'CreateSimulationJobResponse$lastStartedAt' => '<p>The time, in milliseconds since the epoch, when the simulation job was last started.</p>', 'DescribeSimulationJobResponse$lastStartedAt' => '<p>The time, in milliseconds since the epoch, when the simulation job was last started.</p>', 'SimulationJob$lastStartedAt' => '<p>The time, in milliseconds since the epoch, when the simulation job was last started.</p>', ], ], 'LastUpdatedAt' => [ 'base' => NULL, 'refs' => [ 'CreateRobotApplicationResponse$lastUpdatedAt' => '<p>The time, in milliseconds since the epoch, when the robot application was last updated.</p>', 'CreateRobotApplicationVersionResponse$lastUpdatedAt' => '<p>The time, in milliseconds since the epoch, when the robot application was last updated.</p>', 'CreateSimulationApplicationResponse$lastUpdatedAt' => '<p>The time, in milliseconds since the epoch, when the simulation application was last updated.</p>', 'CreateSimulationApplicationVersionResponse$lastUpdatedAt' => '<p>The time, in milliseconds since the epoch, when the simulation application was last updated.</p>', 'CreateSimulationJobResponse$lastUpdatedAt' => '<p>The time, in milliseconds since the epoch, when the simulation job was last updated.</p>', 'DescribeRobotApplicationResponse$lastUpdatedAt' => '<p>The time, in milliseconds since the epoch, when the robot application was last updated.</p>', 'DescribeSimulationApplicationResponse$lastUpdatedAt' => '<p>The time, in milliseconds since the epoch, when the simulation application was last updated.</p>', 'DescribeSimulationJobBatchResponse$lastUpdatedAt' => '<p>The time, in milliseconds since the epoch, when the simulation job batch was last updated.</p>', 'DescribeSimulationJobResponse$lastUpdatedAt' => '<p>The time, in milliseconds since the epoch, when the simulation job was last updated.</p>', 'RobotApplicationSummary$lastUpdatedAt' => '<p>The time, in milliseconds since the epoch, when the robot application was last updated.</p>', 'SimulationApplicationSummary$lastUpdatedAt' => '<p>The time, in milliseconds since the epoch, when the simulation application was last updated.</p>', 'SimulationJob$lastUpdatedAt' => '<p>The time, in milliseconds since the epoch, when the simulation job was last updated.</p>', 'SimulationJobBatchSummary$lastUpdatedAt' => '<p>The time, in milliseconds since the epoch, when the simulation job batch was last updated.</p>', 'SimulationJobSummary$lastUpdatedAt' => '<p>The time, in milliseconds since the epoch, when the simulation job was last updated.</p>', 'UpdateRobotApplicationResponse$lastUpdatedAt' => '<p>The time, in milliseconds since the epoch, when the robot application was last updated.</p>', 'UpdateSimulationApplicationResponse$lastUpdatedAt' => '<p>The time, in milliseconds since the epoch, when the simulation application was last updated.</p>', ], ], 'LaunchConfig' => [ 'base' => '<p>Information about a launch configuration.</p>', 'refs' => [ 'RobotApplicationConfig$launchConfig' => '<p>The launch configuration for the robot application.</p>', 'SimulationApplicationConfig$launchConfig' => '<p>The launch configuration for the simulation application.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests exceeds the maximum number allowed. </p>', 'refs' => [], ], 'ListDeploymentJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDeploymentJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFleetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFleetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRobotApplicationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRobotApplicationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRobotsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRobotsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSimulationApplicationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSimulationApplicationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSimulationJobBatchesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSimulationJobBatchesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSimulationJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSimulationJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'LoggingConfig' => [ 'base' => '<p>The logging configuration.</p>', 'refs' => [ 'CreateSimulationJobRequest$loggingConfig' => '<p>The logging configuration.</p>', 'CreateSimulationJobResponse$loggingConfig' => '<p>The logging configuration.</p>', 'DescribeSimulationJobResponse$loggingConfig' => '<p>The logging configuration.</p>', 'SimulationJob$loggingConfig' => '<p>The logging configuration.</p>', 'SimulationJobRequest$loggingConfig' => NULL, ], ], 'MaxConcurrency' => [ 'base' => NULL, 'refs' => [ 'BatchPolicy$maxConcurrency' => '<p>The number of active simulation jobs create as part of the batch that can be in an active state at the same time. </p> <p>Active states include: <code>Pending</code>,<code>Preparing</code>, <code>Running</code>, <code>Restarting</code>, <code>RunningFailed</code> and <code>Terminating</code>. All other states are terminal states. </p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListDeploymentJobsRequest$maxResults' => '<p>When this parameter is used, <code>ListDeploymentJobs</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListDeploymentJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 200. If this parameter is not used, then <code>ListDeploymentJobs</code> returns up to 200 results and a <code>nextToken</code> value if applicable. </p>', 'ListFleetsRequest$maxResults' => '<p>When this parameter is used, <code>ListFleets</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListFleets</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 200. If this parameter is not used, then <code>ListFleets</code> returns up to 200 results and a <code>nextToken</code> value if applicable. </p>', 'ListRobotApplicationsRequest$maxResults' => '<p>When this parameter is used, <code>ListRobotApplications</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListRobotApplications</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListRobotApplications</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>', 'ListRobotsRequest$maxResults' => '<p>When this parameter is used, <code>ListRobots</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListRobots</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 200. If this parameter is not used, then <code>ListRobots</code> returns up to 200 results and a <code>nextToken</code> value if applicable. </p>', 'ListSimulationApplicationsRequest$maxResults' => '<p>When this parameter is used, <code>ListSimulationApplications</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListSimulationApplications</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListSimulationApplications</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>', 'ListSimulationJobBatchesRequest$maxResults' => '<p>When this parameter is used, <code>ListSimulationJobBatches</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListSimulationJobBatches</code> request with the returned <code>nextToken</code> value. </p>', 'ListSimulationJobsRequest$maxResults' => '<p>When this parameter is used, <code>ListSimulationJobs</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListSimulationJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then <code>ListSimulationJobs</code> returns up to 1000 results and a <code>nextToken</code> value if applicable. </p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'CreateFleetRequest$name' => '<p>The name of the fleet.</p>', 'CreateFleetResponse$name' => '<p>The name of the fleet.</p>', 'CreateRobotApplicationRequest$name' => '<p>The name of the robot application.</p>', 'CreateRobotApplicationResponse$name' => '<p>The name of the robot application.</p>', 'CreateRobotApplicationVersionResponse$name' => '<p>The name of the robot application.</p>', 'CreateRobotRequest$name' => '<p>The name for the robot.</p>', 'CreateRobotResponse$name' => '<p>The name of the robot.</p>', 'CreateSimulationApplicationRequest$name' => '<p>The name of the simulation application.</p>', 'CreateSimulationApplicationResponse$name' => '<p>The name of the simulation application.</p>', 'CreateSimulationApplicationVersionResponse$name' => '<p>The name of the simulation application.</p>', 'DataSource$name' => '<p>The name of the data source.</p>', 'DataSourceConfig$name' => '<p>The name of the data source.</p>', 'DataSourceNames$member' => NULL, 'DescribeFleetResponse$name' => '<p>The name of the fleet.</p>', 'DescribeRobotApplicationResponse$name' => '<p>The name of the robot application.</p>', 'DescribeRobotResponse$name' => '<p>The name of the robot.</p>', 'DescribeSimulationApplicationResponse$name' => '<p>The name of the simulation application.</p>', 'DescribeSimulationJobResponse$name' => '<p>The name of the simulation job.</p>', 'Filter$name' => '<p>The name of the filter.</p>', 'FilterValues$member' => NULL, 'Fleet$name' => '<p>The name of the fleet.</p>', 'Robot$name' => '<p>The name of the robot.</p>', 'RobotApplicationNames$member' => NULL, 'RobotApplicationSummary$name' => '<p>The name of the robot application.</p>', 'SimulationApplicationNames$member' => NULL, 'SimulationApplicationSummary$name' => '<p>The name of the simulation application.</p>', 'SimulationJob$name' => '<p>The name of the simulation job.</p>', 'SimulationJobSummary$name' => '<p>The name of the simulation job.</p>', 'UpdateRobotApplicationResponse$name' => '<p>The name of the robot application.</p>', 'UpdateSimulationApplicationResponse$name' => '<p>The name of the simulation application.</p>', ], ], 'NetworkInterface' => [ 'base' => '<p>Describes a network interface.</p>', 'refs' => [ 'DescribeSimulationJobResponse$networkInterface' => '<p>The network interface information for the simulation job.</p>', 'SimulationJob$networkInterface' => '<p>Information about a network interface.</p>', ], ], 'NonEmptyString' => [ 'base' => NULL, 'refs' => [ 'SecurityGroups$member' => NULL, 'Subnets$member' => NULL, ], ], 'NonSystemPort' => [ 'base' => NULL, 'refs' => [ 'PortMapping$applicationPort' => '<p>The port number on the application.</p>', ], ], 'OutputLocation' => [ 'base' => '<p>The output location.</p>', 'refs' => [ 'CreateSimulationJobRequest$outputLocation' => '<p>Location for output files generated by the simulation job.</p>', 'CreateSimulationJobResponse$outputLocation' => '<p>Simulation job output files location.</p>', 'DescribeSimulationJobResponse$outputLocation' => '<p>Location for output files generated by the simulation job.</p>', 'SimulationJob$outputLocation' => '<p>Location for output files generated by the simulation job.</p>', 'SimulationJobRequest$outputLocation' => NULL, ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListDeploymentJobsRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>ListDeploymentJobs</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. </p>', 'ListDeploymentJobsResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListDeploymentJobs</code> request. When the results of a <code>ListDeploymentJobs</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return. </p>', 'ListFleetsRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>ListFleets</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. </p> <note> <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListFleetsResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListDeploymentJobs</code> request. When the results of a <code>ListFleets</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return. </p>', 'ListRobotApplicationsRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>ListRobotApplications</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. </p>', 'ListRobotApplicationsResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListRobotApplications</code> request. When the results of a <code>ListRobotApplications</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return. </p>', 'ListRobotsRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>ListRobots</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. </p>', 'ListRobotsResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListRobots</code> request. When the results of a <code>ListRobot</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return. </p>', 'ListSimulationApplicationsRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>ListSimulationApplications</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. </p>', 'ListSimulationApplicationsResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListSimulationApplications</code> request. When the results of a <code>ListRobot</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return. </p>', 'ListSimulationJobBatchesRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>ListSimulationJobBatches</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. </p>', 'ListSimulationJobBatchesResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListSimulationJobBatches</code> request. When the results of a <code>ListSimulationJobBatches</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return. </p>', 'ListSimulationJobsRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>ListSimulationJobs</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. </p> <note> <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListSimulationJobsResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListSimulationJobs</code> request. When the results of a <code>ListRobot</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return. </p>', ], ], 'Path' => [ 'base' => NULL, 'refs' => [ 'DeploymentLaunchConfig$preLaunchFile' => '<p>The deployment pre-launch file. This file will be executed prior to the launch file.</p>', 'DeploymentLaunchConfig$postLaunchFile' => '<p>The deployment post-launch file. This file will be executed after the launch file.</p>', ], ], 'PercentDone' => [ 'base' => NULL, 'refs' => [ 'ProgressDetail$percentDone' => '<p>Precentage of the step that is done. This currently only applies to the <code>Downloading/Extracting</code> step of the deployment. It is empty for other steps.</p>', ], ], 'Percentage' => [ 'base' => NULL, 'refs' => [ 'DeploymentConfig$concurrentDeploymentPercentage' => '<p>The percentage of robots receiving the deployment at the same time.</p>', 'DeploymentConfig$failureThresholdPercentage' => '<p>The percentage of deployments that need to fail before stopping deployment.</p>', ], ], 'Port' => [ 'base' => NULL, 'refs' => [ 'PortMapping$jobPort' => '<p>The port number on the simulation job instance to use as a remote connection point. </p>', ], ], 'PortForwardingConfig' => [ 'base' => '<p>Configuration information for port forwarding.</p>', 'refs' => [ 'LaunchConfig$portForwardingConfig' => '<p>The port forwarding configuration.</p>', ], ], 'PortMapping' => [ 'base' => '<p>An object representing a port mapping.</p>', 'refs' => [ 'PortMappingList$member' => NULL, ], ], 'PortMappingList' => [ 'base' => NULL, 'refs' => [ 'PortForwardingConfig$portMappings' => '<p>The port mappings for the configuration.</p>', ], ], 'ProgressDetail' => [ 'base' => '<p>Information about the progress of a deployment job.</p>', 'refs' => [ 'RobotDeployment$progressDetail' => '<p>Information about how the deployment is progressing.</p>', ], ], 'RegisterRobotRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterRobotResponse' => [ 'base' => NULL, 'refs' => [], ], 'RenderingEngine' => [ 'base' => '<p>Information about a rendering engine.</p>', 'refs' => [ 'CreateSimulationApplicationRequest$renderingEngine' => '<p>The rendering engine for the simulation application.</p>', 'CreateSimulationApplicationResponse$renderingEngine' => '<p>The rendering engine for the simulation application.</p>', 'CreateSimulationApplicationVersionResponse$renderingEngine' => '<p>The rendering engine for the simulation application.</p>', 'DescribeSimulationApplicationResponse$renderingEngine' => '<p>The rendering engine for the simulation application.</p>', 'UpdateSimulationApplicationRequest$renderingEngine' => '<p>The rendering engine for the simulation application.</p>', 'UpdateSimulationApplicationResponse$renderingEngine' => '<p>The rendering engine for the simulation application.</p>', ], ], 'RenderingEngineType' => [ 'base' => NULL, 'refs' => [ 'RenderingEngine$name' => '<p>The name of the rendering engine.</p>', ], ], 'RenderingEngineVersionType' => [ 'base' => NULL, 'refs' => [ 'RenderingEngine$version' => '<p>The version of the rendering engine.</p>', ], ], 'ResourceAlreadyExistsException' => [ 'base' => '<p>The specified resource already exists.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource does not exist.</p>', 'refs' => [], ], 'RestartSimulationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'RestartSimulationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'RevisionId' => [ 'base' => NULL, 'refs' => [ 'CreateRobotApplicationResponse$revisionId' => '<p>The revision id of the robot application.</p>', 'CreateRobotApplicationVersionRequest$currentRevisionId' => '<p>The current revision id for the robot application. If you provide a value and it matches the latest revision ID, a new version will be created.</p>', 'CreateRobotApplicationVersionResponse$revisionId' => '<p>The revision id of the robot application.</p>', 'CreateSimulationApplicationResponse$revisionId' => '<p>The revision id of the simulation application.</p>', 'CreateSimulationApplicationVersionRequest$currentRevisionId' => '<p>The current revision id for the simulation application. If you provide a value and it matches the latest revision ID, a new version will be created.</p>', 'CreateSimulationApplicationVersionResponse$revisionId' => '<p>The revision ID of the simulation application.</p>', 'DescribeRobotApplicationResponse$revisionId' => '<p>The revision id of the robot application.</p>', 'DescribeSimulationApplicationResponse$revisionId' => '<p>The revision id of the simulation application.</p>', 'UpdateRobotApplicationRequest$currentRevisionId' => '<p>The revision id for the robot application.</p>', 'UpdateRobotApplicationResponse$revisionId' => '<p>The revision id of the robot application.</p>', 'UpdateSimulationApplicationRequest$currentRevisionId' => '<p>The revision id for the robot application.</p>', 'UpdateSimulationApplicationResponse$revisionId' => '<p>The revision id of the simulation application.</p>', ], ], 'Robot' => [ 'base' => '<p>Information about a robot.</p>', 'refs' => [ 'Robots$member' => NULL, ], ], 'RobotApplicationConfig' => [ 'base' => '<p>Application configuration information for a robot.</p>', 'refs' => [ 'RobotApplicationConfigs$member' => NULL, ], ], 'RobotApplicationConfigs' => [ 'base' => NULL, 'refs' => [ 'CreateSimulationJobRequest$robotApplications' => '<p>The robot application to use in the simulation job.</p>', 'CreateSimulationJobResponse$robotApplications' => '<p>The robot application used by the simulation job.</p>', 'DescribeSimulationJobResponse$robotApplications' => '<p>A list of robot applications.</p>', 'SimulationJob$robotApplications' => '<p>A list of robot applications.</p>', 'SimulationJobRequest$robotApplications' => '<p>The robot applications to use in the simulation job.</p>', ], ], 'RobotApplicationNames' => [ 'base' => NULL, 'refs' => [ 'SimulationJobSummary$robotApplicationNames' => '<p>A list of simulation job robot application names.</p>', ], ], 'RobotApplicationSummaries' => [ 'base' => NULL, 'refs' => [ 'ListRobotApplicationsResponse$robotApplicationSummaries' => '<p>A list of robot application summaries that meet the criteria of the request.</p>', ], ], 'RobotApplicationSummary' => [ 'base' => '<p>Summary information for a robot application.</p>', 'refs' => [ 'RobotApplicationSummaries$member' => NULL, ], ], 'RobotDeployment' => [ 'base' => '<p>Information about a robot deployment.</p>', 'refs' => [ 'RobotDeploymentSummary$member' => NULL, ], ], 'RobotDeploymentStep' => [ 'base' => NULL, 'refs' => [ 'ProgressDetail$currentProgress' => '<p>The current progress status.</p> <dl> <dt>Validating</dt> <dd> <p>Validating the deployment.</p> </dd> <dt>DownloadingExtracting</dt> <dd> <p>Downloading and extracting the bundle on the robot.</p> </dd> <dt>ExecutingPreLaunch</dt> <dd> <p>Executing pre-launch script(s) if provided.</p> </dd> <dt>Launching</dt> <dd> <p>Launching the robot application.</p> </dd> <dt>ExecutingPostLaunch</dt> <dd> <p>Executing post-launch script(s) if provided.</p> </dd> <dt>Finished</dt> <dd> <p>Deployment is complete.</p> </dd> </dl>', ], ], 'RobotDeploymentSummary' => [ 'base' => NULL, 'refs' => [ 'DescribeDeploymentJobResponse$robotDeploymentSummary' => '<p>A list of robot deployment summaries.</p>', ], ], 'RobotSoftwareSuite' => [ 'base' => '<p>Information about a robot software suite (ROS distribution).</p>', 'refs' => [ 'CreateRobotApplicationRequest$robotSoftwareSuite' => '<p>The robot software suite (ROS distribuition) used by the robot application.</p>', 'CreateRobotApplicationResponse$robotSoftwareSuite' => '<p>The robot software suite (ROS distribution) used by the robot application.</p>', 'CreateRobotApplicationVersionResponse$robotSoftwareSuite' => '<p>The robot software suite (ROS distribution) used by the robot application.</p>', 'CreateSimulationApplicationRequest$robotSoftwareSuite' => '<p>The robot software suite (ROS distribution) used by the simulation application.</p>', 'CreateSimulationApplicationResponse$robotSoftwareSuite' => '<p>Information about the robot software suite (ROS distribution).</p>', 'CreateSimulationApplicationVersionResponse$robotSoftwareSuite' => '<p>Information about the robot software suite (ROS distribution).</p>', 'DescribeRobotApplicationResponse$robotSoftwareSuite' => '<p>The robot software suite (ROS distribution) used by the robot application.</p>', 'DescribeSimulationApplicationResponse$robotSoftwareSuite' => '<p>Information about the robot software suite (ROS distribution).</p>', 'RobotApplicationSummary$robotSoftwareSuite' => '<p>Information about a robot software suite (ROS distribution).</p>', 'SimulationApplicationSummary$robotSoftwareSuite' => '<p>Information about a robot software suite (ROS distribution).</p>', 'UpdateRobotApplicationRequest$robotSoftwareSuite' => '<p>The robot software suite (ROS distribution) used by the robot application.</p>', 'UpdateRobotApplicationResponse$robotSoftwareSuite' => '<p>The robot software suite (ROS distribution) used by the robot application.</p>', 'UpdateSimulationApplicationRequest$robotSoftwareSuite' => '<p>Information about the robot software suite (ROS distribution).</p>', 'UpdateSimulationApplicationResponse$robotSoftwareSuite' => '<p>Information about the robot software suite (ROS distribution).</p>', ], ], 'RobotSoftwareSuiteType' => [ 'base' => NULL, 'refs' => [ 'RobotSoftwareSuite$name' => '<p>The name of the robot software suite (ROS distribution).</p>', ], ], 'RobotSoftwareSuiteVersionType' => [ 'base' => NULL, 'refs' => [ 'RobotSoftwareSuite$version' => '<p>The version of the robot software suite (ROS distribution).</p>', ], ], 'RobotStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeRobotResponse$status' => '<p>The status of the fleet.</p>', 'Robot$status' => '<p>The status of the robot.</p>', 'RobotDeployment$status' => '<p>The status of the robot deployment.</p>', ], ], 'Robots' => [ 'base' => NULL, 'refs' => [ 'DescribeFleetResponse$robots' => '<p>A list of robots.</p>', 'ListRobotsResponse$robots' => '<p>A list of robots that meet the criteria of the request.</p>', ], ], 'S3Bucket' => [ 'base' => NULL, 'refs' => [ 'DataSource$s3Bucket' => '<p>The S3 bucket where the data files are located.</p>', 'DataSourceConfig$s3Bucket' => '<p>The S3 bucket where the data files are located.</p>', 'OutputLocation$s3Bucket' => '<p>The S3 bucket for output.</p>', 'S3Object$bucket' => '<p>The bucket containing the object.</p>', 'Source$s3Bucket' => '<p>The s3 bucket name.</p>', 'SourceConfig$s3Bucket' => '<p>The Amazon S3 bucket name.</p>', ], ], 'S3Etag' => [ 'base' => NULL, 'refs' => [ 'S3KeyOutput$etag' => '<p>The etag for the object.</p>', 'S3Object$etag' => '<p>The etag of the object.</p>', 'Source$etag' => '<p>A hash of the object specified by <code>s3Bucket</code> and <code>s3Key</code>.</p>', ], ], 'S3Key' => [ 'base' => NULL, 'refs' => [ 'OutputLocation$s3Prefix' => '<p>The S3 folder in the <code>s3Bucket</code> where output files will be placed.</p>', 'S3KeyOutput$s3Key' => '<p>The S3 key.</p>', 'S3Keys$member' => NULL, 'S3Object$key' => '<p>The key of the object.</p>', 'Source$s3Key' => '<p>The s3 object key.</p>', 'SourceConfig$s3Key' => '<p>The s3 object key.</p>', ], ], 'S3KeyOutput' => [ 'base' => '<p>Information about S3 keys.</p>', 'refs' => [ 'S3KeyOutputs$member' => NULL, ], ], 'S3KeyOutputs' => [ 'base' => NULL, 'refs' => [ 'DataSource$s3Keys' => '<p>The list of S3 keys identifying the data source files.</p>', ], ], 'S3Keys' => [ 'base' => NULL, 'refs' => [ 'DataSourceConfig$s3Keys' => '<p>The list of S3 keys identifying the data source files.</p>', ], ], 'S3Object' => [ 'base' => '<p>Information about an S3 object.</p>', 'refs' => [ 'DeploymentConfig$downloadConditionFile' => '<p>The download condition file.</p>', ], ], 'SecurityGroups' => [ 'base' => NULL, 'refs' => [ 'VPCConfig$securityGroups' => '<p>A list of one or more security groups IDs in your VPC.</p>', 'VPCConfigResponse$securityGroups' => '<p>A list of security group IDs associated with the simulation job.</p>', ], ], 'ServiceUnavailableException' => [ 'base' => '<p>The request has failed due to a temporary failure of the server.</p>', 'refs' => [], ], 'SimulationApplicationConfig' => [ 'base' => '<p>Information about a simulation application configuration.</p>', 'refs' => [ 'SimulationApplicationConfigs$member' => NULL, ], ], 'SimulationApplicationConfigs' => [ 'base' => NULL, 'refs' => [ 'CreateSimulationJobRequest$simulationApplications' => '<p>The simulation application to use in the simulation job.</p>', 'CreateSimulationJobResponse$simulationApplications' => '<p>The simulation application used by the simulation job.</p>', 'DescribeSimulationJobResponse$simulationApplications' => '<p>A list of simulation applications.</p>', 'SimulationJob$simulationApplications' => '<p>A list of simulation applications.</p>', 'SimulationJobRequest$simulationApplications' => '<p>The simulation applications to use in the simulation job.</p>', ], ], 'SimulationApplicationNames' => [ 'base' => NULL, 'refs' => [ 'SimulationJobSummary$simulationApplicationNames' => '<p>A list of simulation job simulation application names.</p>', ], ], 'SimulationApplicationSummaries' => [ 'base' => NULL, 'refs' => [ 'ListSimulationApplicationsResponse$simulationApplicationSummaries' => '<p>A list of simulation application summaries that meet the criteria of the request.</p>', ], ], 'SimulationApplicationSummary' => [ 'base' => '<p>Summary information for a simulation application.</p>', 'refs' => [ 'SimulationApplicationSummaries$member' => NULL, ], ], 'SimulationJob' => [ 'base' => '<p>Information about a simulation job.</p>', 'refs' => [ 'SimulationJobs$member' => NULL, ], ], 'SimulationJobBatchErrorCode' => [ 'base' => NULL, 'refs' => [ 'DescribeSimulationJobBatchResponse$failureCode' => '<p>The failure code of the simulation job batch.</p>', 'StartSimulationJobBatchResponse$failureCode' => '<p>The failure code if the simulation job batch failed.</p>', ], ], 'SimulationJobBatchStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeSimulationJobBatchResponse$status' => '<p>The status of the batch.</p> <dl> <dt>Pending</dt> <dd> <p>The simulation job batch request is pending.</p> </dd> <dt>InProgress</dt> <dd> <p>The simulation job batch is in progress. </p> </dd> <dt>Failed</dt> <dd> <p>The simulation job batch failed. One or more simulation job requests could not be completed due to an internal failure (like <code>InternalServiceError</code>). See <code>failureCode</code> and <code>failureReason</code> for more information.</p> </dd> <dt>Completed</dt> <dd> <p>The simulation batch job completed. A batch is complete when (1) there are no pending simulation job requests in the batch and none of the failed simulation job requests are due to <code>InternalServiceError</code> and (2) when all created simulation jobs have reached a terminal state (for example, <code>Completed</code> or <code>Failed</code>). </p> </dd> <dt>Canceled</dt> <dd> <p>The simulation batch job was cancelled.</p> </dd> <dt>Canceling</dt> <dd> <p>The simulation batch job is being cancelled.</p> </dd> <dt>Completing</dt> <dd> <p>The simulation batch job is completing.</p> </dd> <dt>TimingOut</dt> <dd> <p>The simulation job batch is timing out.</p> <p>If a batch timing out, and there are pending requests that were failing due to an internal failure (like <code>InternalServiceError</code>), the batch status will be <code>Failed</code>. If there are no such failing request, the batch status will be <code>TimedOut</code>. </p> </dd> <dt>TimedOut</dt> <dd> <p>The simulation batch job timed out.</p> </dd> </dl>', 'SimulationJobBatchSummary$status' => '<p>The status of the simulation job batch.</p> <dl> <dt>Pending</dt> <dd> <p>The simulation job batch request is pending.</p> </dd> <dt>InProgress</dt> <dd> <p>The simulation job batch is in progress. </p> </dd> <dt>Failed</dt> <dd> <p>The simulation job batch failed. One or more simulation job requests could not be completed due to an internal failure (like <code>InternalServiceError</code>). See <code>failureCode</code> and <code>failureReason</code> for more information.</p> </dd> <dt>Completed</dt> <dd> <p>The simulation batch job completed. A batch is complete when (1) there are no pending simulation job requests in the batch and none of the failed simulation job requests are due to <code>InternalServiceError</code> and (2) when all created simulation jobs have reached a terminal state (for example, <code>Completed</code> or <code>Failed</code>). </p> </dd> <dt>Canceled</dt> <dd> <p>The simulation batch job was cancelled.</p> </dd> <dt>Canceling</dt> <dd> <p>The simulation batch job is being cancelled.</p> </dd> <dt>Completing</dt> <dd> <p>The simulation batch job is completing.</p> </dd> <dt>TimingOut</dt> <dd> <p>The simulation job batch is timing out.</p> <p>If a batch timing out, and there are pending requests that were failing due to an internal failure (like <code>InternalServiceError</code>), the batch status will be <code>Failed</code>. If there are no such failing request, the batch status will be <code>TimedOut</code>. </p> </dd> <dt>TimedOut</dt> <dd> <p>The simulation batch job timed out.</p> </dd> </dl>', 'StartSimulationJobBatchResponse$status' => '<p>The status of the simulation job batch.</p> <dl> <dt>Pending</dt> <dd> <p>The simulation job batch request is pending.</p> </dd> <dt>InProgress</dt> <dd> <p>The simulation job batch is in progress. </p> </dd> <dt>Failed</dt> <dd> <p>The simulation job batch failed. One or more simulation job requests could not be completed due to an internal failure (like <code>InternalServiceError</code>). See <code>failureCode</code> and <code>failureReason</code> for more information.</p> </dd> <dt>Completed</dt> <dd> <p>The simulation batch job completed. A batch is complete when (1) there are no pending simulation job requests in the batch and none of the failed simulation job requests are due to <code>InternalServiceError</code> and (2) when all created simulation jobs have reached a terminal state (for example, <code>Completed</code> or <code>Failed</code>). </p> </dd> <dt>Canceled</dt> <dd> <p>The simulation batch job was cancelled.</p> </dd> <dt>Canceling</dt> <dd> <p>The simulation batch job is being cancelled.</p> </dd> <dt>Completing</dt> <dd> <p>The simulation batch job is completing.</p> </dd> <dt>TimingOut</dt> <dd> <p>The simulation job batch is timing out.</p> <p>If a batch timing out, and there are pending requests that were failing due to an internal failure (like <code>InternalServiceError</code>), the batch status will be <code>Failed</code>. If there are no such failing request, the batch status will be <code>TimedOut</code>. </p> </dd> <dt>TimedOut</dt> <dd> <p>The simulation batch job timed out.</p> </dd> </dl>', ], ], 'SimulationJobBatchSummaries' => [ 'base' => NULL, 'refs' => [ 'ListSimulationJobBatchesResponse$simulationJobBatchSummaries' => '<p>A list of simulation job batch summaries.</p>', ], ], 'SimulationJobBatchSummary' => [ 'base' => '<p>Information about a simulation job batch.</p>', 'refs' => [ 'SimulationJobBatchSummaries$member' => NULL, ], ], 'SimulationJobErrorCode' => [ 'base' => NULL, 'refs' => [ 'CreateSimulationJobResponse$failureCode' => '<p>The failure code of the simulation job if it failed:</p> <dl> <dt>InternalServiceError</dt> <dd> <p>Internal service error.</p> </dd> <dt>RobotApplicationCrash</dt> <dd> <p>Robot application exited abnormally.</p> </dd> <dt>SimulationApplicationCrash</dt> <dd> <p> Simulation application exited abnormally.</p> </dd> <dt>BadPermissionsRobotApplication</dt> <dd> <p>Robot application bundle could not be downloaded.</p> </dd> <dt>BadPermissionsSimulationApplication</dt> <dd> <p>Simulation application bundle could not be downloaded.</p> </dd> <dt>BadPermissionsS3Output</dt> <dd> <p>Unable to publish outputs to customer-provided S3 bucket.</p> </dd> <dt>BadPermissionsCloudwatchLogs</dt> <dd> <p>Unable to publish logs to customer-provided CloudWatch Logs resource.</p> </dd> <dt>SubnetIpLimitExceeded</dt> <dd> <p>Subnet IP limit exceeded.</p> </dd> <dt>ENILimitExceeded</dt> <dd> <p>ENI limit exceeded.</p> </dd> <dt>BadPermissionsUserCredentials</dt> <dd> <p>Unable to use the Role provided.</p> </dd> <dt>InvalidBundleRobotApplication</dt> <dd> <p>Robot bundle cannot be extracted (invalid format, bundling error, or other issue).</p> </dd> <dt>InvalidBundleSimulationApplication</dt> <dd> <p>Simulation bundle cannot be extracted (invalid format, bundling error, or other issue).</p> </dd> <dt>RobotApplicationVersionMismatchedEtag</dt> <dd> <p>Etag for RobotApplication does not match value during version creation.</p> </dd> <dt>SimulationApplicationVersionMismatchedEtag</dt> <dd> <p>Etag for SimulationApplication does not match value during version creation.</p> </dd> </dl>', 'DescribeSimulationJobResponse$failureCode' => '<p>The failure code of the simulation job if it failed:</p> <dl> <dt>InternalServiceError</dt> <dd> <p>Internal service error.</p> </dd> <dt>RobotApplicationCrash</dt> <dd> <p>Robot application exited abnormally.</p> </dd> <dt>SimulationApplicationCrash</dt> <dd> <p> Simulation application exited abnormally.</p> </dd> <dt>BadPermissionsRobotApplication</dt> <dd> <p>Robot application bundle could not be downloaded.</p> </dd> <dt>BadPermissionsSimulationApplication</dt> <dd> <p>Simulation application bundle could not be downloaded.</p> </dd> <dt>BadPermissionsS3Output</dt> <dd> <p>Unable to publish outputs to customer-provided S3 bucket.</p> </dd> <dt>BadPermissionsCloudwatchLogs</dt> <dd> <p>Unable to publish logs to customer-provided CloudWatch Logs resource.</p> </dd> <dt>SubnetIpLimitExceeded</dt> <dd> <p>Subnet IP limit exceeded.</p> </dd> <dt>ENILimitExceeded</dt> <dd> <p>ENI limit exceeded.</p> </dd> <dt>BadPermissionsUserCredentials</dt> <dd> <p>Unable to use the Role provided.</p> </dd> <dt>InvalidBundleRobotApplication</dt> <dd> <p>Robot bundle cannot be extracted (invalid format, bundling error, or other issue).</p> </dd> <dt>InvalidBundleSimulationApplication</dt> <dd> <p>Simulation bundle cannot be extracted (invalid format, bundling error, or other issue).</p> </dd> <dt>RobotApplicationVersionMismatchedEtag</dt> <dd> <p>Etag for RobotApplication does not match value during version creation.</p> </dd> <dt>SimulationApplicationVersionMismatchedEtag</dt> <dd> <p>Etag for SimulationApplication does not match value during version creation.</p> </dd> </dl>', 'FailedCreateSimulationJobRequest$failureCode' => '<p>The failure code.</p>', 'SimulationJob$failureCode' => '<p>The failure code of the simulation job if it failed.</p>', ], ], 'SimulationJobRequest' => [ 'base' => '<p>Information about a simulation job request.</p>', 'refs' => [ 'CreateSimulationJobRequests$member' => NULL, 'FailedCreateSimulationJobRequest$request' => '<p>The simulation job request.</p>', ], ], 'SimulationJobStatus' => [ 'base' => NULL, 'refs' => [ 'CreateSimulationJobResponse$status' => '<p>The status of the simulation job.</p>', 'DescribeSimulationJobResponse$status' => '<p>The status of the simulation job.</p>', 'SimulationJob$status' => '<p>Status of the simulation job.</p>', 'SimulationJobSummary$status' => '<p>The status of the simulation job.</p>', ], ], 'SimulationJobSummaries' => [ 'base' => NULL, 'refs' => [ 'DescribeSimulationJobBatchResponse$createdRequests' => '<p>A list of created simulation job summaries.</p>', 'ListSimulationJobsResponse$simulationJobSummaries' => '<p>A list of simulation job summaries that meet the criteria of the request.</p>', 'StartSimulationJobBatchResponse$createdRequests' => '<p>A list of created simulation job request summaries.</p>', ], ], 'SimulationJobSummary' => [ 'base' => '<p>Summary information for a simulation job.</p>', 'refs' => [ 'SimulationJobSummaries$member' => NULL, ], ], 'SimulationJobs' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeSimulationJobResponse$jobs' => '<p>A list of simulation jobs.</p>', ], ], 'SimulationSoftwareSuite' => [ 'base' => '<p>Information about a simulation software suite.</p>', 'refs' => [ 'CreateSimulationApplicationRequest$simulationSoftwareSuite' => '<p>The simulation software suite used by the simulation application.</p>', 'CreateSimulationApplicationResponse$simulationSoftwareSuite' => '<p>The simulation software suite used by the simulation application.</p>', 'CreateSimulationApplicationVersionResponse$simulationSoftwareSuite' => '<p>The simulation software suite used by the simulation application.</p>', 'DescribeSimulationApplicationResponse$simulationSoftwareSuite' => '<p>The simulation software suite used by the simulation application.</p>', 'SimulationApplicationSummary$simulationSoftwareSuite' => '<p>Information about a simulation software suite.</p>', 'UpdateSimulationApplicationRequest$simulationSoftwareSuite' => '<p>The simulation software suite used by the simulation application.</p>', 'UpdateSimulationApplicationResponse$simulationSoftwareSuite' => '<p>The simulation software suite used by the simulation application.</p>', ], ], 'SimulationSoftwareSuiteType' => [ 'base' => NULL, 'refs' => [ 'SimulationSoftwareSuite$name' => '<p>The name of the simulation software suite.</p>', ], ], 'SimulationSoftwareSuiteVersionType' => [ 'base' => NULL, 'refs' => [ 'SimulationSoftwareSuite$version' => '<p>The version of the simulation software suite.</p>', ], ], 'SimulationTimeMillis' => [ 'base' => NULL, 'refs' => [ 'CreateSimulationJobResponse$simulationTimeMillis' => '<p>The simulation job execution duration in milliseconds.</p>', 'DescribeSimulationJobResponse$simulationTimeMillis' => '<p>The simulation job execution duration in milliseconds.</p>', 'SimulationJob$simulationTimeMillis' => '<p>The simulation job execution duration in milliseconds.</p>', ], ], 'SimulationUnit' => [ 'base' => NULL, 'refs' => [ 'Compute$simulationUnitLimit' => '<p>The simulation unit limit. Your simulation is allocated CPU and memory proportional to the supplied simulation unit limit. A simulation unit is 1 vcpu and 2GB of memory. You are only billed for the SU utilization you consume up to the maximim value provided. </p>', 'ComputeResponse$simulationUnitLimit' => '<p>The simulation unit limit. Your simulation is allocated CPU and memory proportional to the supplied simulation unit limit. A simulation unit is 1 vcpu and 2GB of memory. You are only billed for the SU utilization you consume up to the maximim value provided. </p>', ], ], 'Source' => [ 'base' => '<p>Information about a source.</p>', 'refs' => [ 'Sources$member' => NULL, ], ], 'SourceConfig' => [ 'base' => '<p>Information about a source configuration.</p>', 'refs' => [ 'SourceConfigs$member' => NULL, ], ], 'SourceConfigs' => [ 'base' => NULL, 'refs' => [ 'CreateRobotApplicationRequest$sources' => '<p>The sources of the robot application.</p>', 'CreateSimulationApplicationRequest$sources' => '<p>The sources of the simulation application.</p>', 'UpdateRobotApplicationRequest$sources' => '<p>The sources of the robot application.</p>', 'UpdateSimulationApplicationRequest$sources' => '<p>The sources of the simulation application.</p>', ], ], 'Sources' => [ 'base' => NULL, 'refs' => [ 'CreateRobotApplicationResponse$sources' => '<p>The sources of the robot application.</p>', 'CreateRobotApplicationVersionResponse$sources' => '<p>The sources of the robot application.</p>', 'CreateSimulationApplicationResponse$sources' => '<p>The sources of the simulation application.</p>', 'CreateSimulationApplicationVersionResponse$sources' => '<p>The sources of the simulation application.</p>', 'DescribeRobotApplicationResponse$sources' => '<p>The sources of the robot application.</p>', 'DescribeSimulationApplicationResponse$sources' => '<p>The sources of the simulation application.</p>', 'UpdateRobotApplicationResponse$sources' => '<p>The sources of the robot application.</p>', 'UpdateSimulationApplicationResponse$sources' => '<p>The sources of the simulation application.</p>', ], ], 'StartSimulationJobBatchRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartSimulationJobBatchResponse' => [ 'base' => NULL, 'refs' => [], ], 'Subnets' => [ 'base' => NULL, 'refs' => [ 'VPCConfig$subnets' => '<p>A list of one or more subnet IDs in your VPC.</p>', 'VPCConfigResponse$subnets' => '<p>A list of subnet IDs associated with the simulation job.</p>', ], ], 'SyncDeploymentJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'SyncDeploymentJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>A map that contains tag keys and tag values that will be unattached from the resource.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentJobRequest$tags' => '<p>A map that contains tag keys and tag values that are attached to the deployment job.</p>', 'CreateDeploymentJobResponse$tags' => '<p>The list of all tags added to the deployment job.</p>', 'CreateFleetRequest$tags' => '<p>A map that contains tag keys and tag values that are attached to the fleet.</p>', 'CreateFleetResponse$tags' => '<p>The list of all tags added to the fleet.</p>', 'CreateRobotApplicationRequest$tags' => '<p>A map that contains tag keys and tag values that are attached to the robot application.</p>', 'CreateRobotApplicationResponse$tags' => '<p>The list of all tags added to the robot application.</p>', 'CreateRobotRequest$tags' => '<p>A map that contains tag keys and tag values that are attached to the robot.</p>', 'CreateRobotResponse$tags' => '<p>The list of all tags added to the robot.</p>', 'CreateSimulationApplicationRequest$tags' => '<p>A map that contains tag keys and tag values that are attached to the simulation application.</p>', 'CreateSimulationApplicationResponse$tags' => '<p>The list of all tags added to the simulation application.</p>', 'CreateSimulationJobRequest$tags' => '<p>A map that contains tag keys and tag values that are attached to the simulation job.</p>', 'CreateSimulationJobResponse$tags' => '<p>The list of all tags added to the simulation job.</p>', 'DescribeDeploymentJobResponse$tags' => '<p>The list of all tags added to the specified deployment job.</p>', 'DescribeFleetResponse$tags' => '<p>The list of all tags added to the specified fleet.</p>', 'DescribeRobotApplicationResponse$tags' => '<p>The list of all tags added to the specified robot application.</p>', 'DescribeRobotResponse$tags' => '<p>The list of all tags added to the specified robot.</p>', 'DescribeSimulationApplicationResponse$tags' => '<p>The list of all tags added to the specified simulation application.</p>', 'DescribeSimulationJobBatchResponse$tags' => '<p>A map that contains tag keys and tag values that are attached to the simulation job batch.</p>', 'DescribeSimulationJobResponse$tags' => '<p>The list of all tags added to the specified simulation job.</p>', 'ListTagsForResourceResponse$tags' => '<p>The list of all tags added to the specified resource.</p>', 'SimulationJob$tags' => '<p>A map that contains tag keys and tag values that are attached to the simulation job.</p>', 'SimulationJobRequest$tags' => '<p>A map that contains tag keys and tag values that are attached to the simulation job request.</p>', 'StartSimulationJobBatchRequest$tags' => '<p>A map that contains tag keys and tag values that are attached to the deployment job batch.</p>', 'StartSimulationJobBatchResponse$tags' => '<p>A map that contains tag keys and tag values that are attached to the deployment job batch.</p>', 'TagResourceRequest$tags' => '<p>A map that contains tag keys and tag values that are attached to the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>AWS RoboMaker is temporarily unable to process the request. Try your call again.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRobotApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRobotApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSimulationApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSimulationApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'VPCConfig' => [ 'base' => '<p>If your simulation job accesses resources in a VPC, you provide this parameter identifying the list of security group IDs and subnet IDs. These must belong to the same VPC. You must provide at least one security group and two subnet IDs.</p>', 'refs' => [ 'CreateSimulationJobRequest$vpcConfig' => '<p>If your simulation job accesses resources in a VPC, you provide this parameter identifying the list of security group IDs and subnet IDs. These must belong to the same VPC. You must provide at least one security group and one subnet ID. </p>', 'SimulationJobRequest$vpcConfig' => NULL, ], ], 'VPCConfigResponse' => [ 'base' => '<p>VPC configuration associated with your simulation job.</p>', 'refs' => [ 'CreateSimulationJobResponse$vpcConfig' => '<p>Information about the vpc configuration.</p>', 'DescribeSimulationJobResponse$vpcConfig' => '<p>The VPC configuration.</p>', 'SimulationJob$vpcConfig' => '<p>VPC configuration information.</p>', ], ], 'Version' => [ 'base' => NULL, 'refs' => [ 'CreateRobotApplicationResponse$version' => '<p>The version of the robot application.</p>', 'CreateRobotApplicationVersionResponse$version' => '<p>The version of the robot application.</p>', 'CreateSimulationApplicationResponse$version' => '<p>The version of the simulation application.</p>', 'CreateSimulationApplicationVersionResponse$version' => '<p>The version of the simulation application.</p>', 'DeleteRobotApplicationRequest$applicationVersion' => '<p>The version of the robot application to delete.</p>', 'DeleteSimulationApplicationRequest$applicationVersion' => '<p>The version of the simulation application to delete.</p>', 'DescribeRobotApplicationRequest$applicationVersion' => '<p>The version of the robot application to describe.</p>', 'DescribeRobotApplicationResponse$version' => '<p>The version of the robot application.</p>', 'DescribeSimulationApplicationRequest$applicationVersion' => '<p>The version of the simulation application to describe.</p>', 'DescribeSimulationApplicationResponse$version' => '<p>The version of the simulation application.</p>', 'RobotApplicationConfig$applicationVersion' => '<p>The version of the robot application.</p>', 'RobotApplicationSummary$version' => '<p>The version of the robot application.</p>', 'SimulationApplicationConfig$applicationVersion' => '<p>The version of the simulation application.</p>', 'SimulationApplicationSummary$version' => '<p>The version of the simulation application.</p>', 'UpdateRobotApplicationResponse$version' => '<p>The version of the robot application.</p>', 'UpdateSimulationApplicationResponse$version' => '<p>The version of the robot application.</p>', ], ], 'VersionQualifier' => [ 'base' => NULL, 'refs' => [ 'ListRobotApplicationsRequest$versionQualifier' => '<p>The version qualifier of the robot application.</p>', 'ListSimulationApplicationsRequest$versionQualifier' => '<p>The version qualifier of the simulation application.</p>', ], ], 'errorMessage' => [ 'base' => NULL, 'refs' => [ 'ConcurrentDeploymentException$message' => NULL, 'IdempotentParameterMismatchException$message' => NULL, 'InternalServerException$message' => NULL, 'InvalidParameterException$message' => NULL, 'LimitExceededException$message' => NULL, 'ResourceAlreadyExistsException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServiceUnavailableException$message' => NULL, 'ThrottlingException$message' => NULL, ], ], ],];
