<?php
// This file was auto-generated from sdk-root/src/data/resource-groups/2017-11-27/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>AWS Resource Groups</fullname> <p>AWS Resource Groups lets you organize AWS resources such as Amazon EC2 instances, Amazon Relational Database Service databases, and Amazon S3 buckets into groups using criteria that you define as tags. A resource group is a collection of resources that match the resource types specified in a query, and share one or more tags or portions of tags. You can create a group of resources based on their roles in your cloud infrastructure, lifecycle stages, regions, application layers, or virtually any criteria. Resource groups enable you to automate management tasks, such as those in AWS Systems Manager Automation documents, on tag-related resources in AWS Systems Manager. Groups of tagged resources also let you quickly view a custom console in AWS Systems Manager that shows AWS Config compliance and other monitoring data about member resources.</p> <p>To create a resource group, build a resource query, and specify tags that identify the criteria that members of the group have in common. Tags are key-value pairs.</p> <p>For more information about Resource Groups, see the <a href="https://docs.aws.amazon.com/ARG/latest/userguide/welcome.html">AWS Resource Groups User Guide</a>.</p> <p>AWS Resource Groups uses a REST-compliant API that you can use to perform the following types of operations.</p> <ul> <li> <p>Create, Read, Update, and Delete (CRUD) operations on resource groups and resource query entities</p> </li> <li> <p>Applying, editing, and removing tags from resource groups</p> </li> <li> <p>Resolving resource group member ARNs so they can be returned as search results</p> </li> <li> <p>Getting data about resources that are members of a group</p> </li> <li> <p>Searching AWS resources based on a resource query</p> </li> </ul>', 'operations' => [ 'CreateGroup' => '<p>Creates a resource group with the specified name and description. You can optionally include a resource query, or a service configuration.</p>', 'DeleteGroup' => '<p>Deletes the specified resource group. Deleting a resource group does not delete any resources that are members of the group; it only deletes the group structure.</p>', 'GetGroup' => '<p>Returns information about a specified resource group.</p>', 'GetGroupConfiguration' => '<p>Returns the service configuration associated with the specified resource group. AWS Resource Groups supports configurations for the following resource group types:</p> <ul> <li> <p> <code>AWS::EC2::CapacityReservationPool</code> - Amazon EC2 capacity reservation pools. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/capacity-reservations-using.html#create-cr-group">Working with capacity reservation groups</a> in the <i>EC2 Users Guide</i>.</p> </li> </ul>', 'GetGroupQuery' => '<p>Retrieves the resource query associated with the specified resource group.</p>', 'GetTags' => '<p>Returns a list of tags that are associated with a resource group, specified by an ARN.</p>', 'GroupResources' => '<p>Adds the specified resources to the specified group.</p>', 'ListGroupResources' => '<p>Returns a list of ARNs of the resources that are members of a specified resource group.</p>', 'ListGroups' => '<p>Returns a list of existing resource groups in your account.</p>', 'SearchResources' => '<p>Returns a list of AWS resource identifiers that matches tne specified query. The query uses the same format as a resource query in a CreateGroup or UpdateGroupQuery operation.</p>', 'Tag' => '<p>Adds tags to a resource group with the specified ARN. Existing tags on a resource group are not changed if they are not specified in the request parameters.</p> <important> <p>Do not store personally identifiable information (PII) or other confidential or sensitive information in tags. We use tags to provide you with billing and administration services. Tags are not intended to be used for private or sensitive data.</p> </important>', 'UngroupResources' => '<p>Removes the specified resources from the specified group.</p>', 'Untag' => '<p>Deletes tags from a specified resource group.</p>', 'UpdateGroup' => '<p>Updates the description for an existing group. You cannot update the name of a resource group.</p>', 'UpdateGroupQuery' => '<p>Updates the resource query of a group.</p>', ], 'shapes' => [ 'BadRequestException' => [ 'base' => '<p>The request includes one or more parameters that violate validation rules.</p>', 'refs' => [], ], 'CreateGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CreateGroupInput$Description' => '<p>The description of the resource group. Descriptions can consist of letters, numbers, hyphens, underscores, periods, and spaces.</p>', 'Group$Description' => '<p>The description of the resource group.</p>', 'UpdateGroupInput$Description' => '<p>The new description that you want to update the resource group with. Descriptions can contain letters, numbers, hyphens, underscores, periods, and spaces.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'FailedResource$ErrorCode' => '<p>The error code associated with the failure.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'BadRequestException$Message' => NULL, 'FailedResource$ErrorMessage' => '<p>The error message text associated with the failure.</p>', 'ForbiddenException$Message' => NULL, 'InternalServerErrorException$Message' => NULL, 'MethodNotAllowedException$Message' => NULL, 'NotFoundException$Message' => NULL, 'TooManyRequestsException$Message' => NULL, 'UnauthorizedException$Message' => NULL, ], ], 'FailedResource' => [ 'base' => '<p>A resource that failed to be added to or removed from a group.</p>', 'refs' => [ 'FailedResourceList$member' => NULL, ], ], 'FailedResourceList' => [ 'base' => NULL, 'refs' => [ 'GroupResourcesOutput$Failed' => '<p>The ARNs of the resources that failed to be added to the group by this operation.</p>', 'UngroupResourcesOutput$Failed' => '<p>The resources that failed to be removed from the group.</p>', ], ], 'ForbiddenException' => [ 'base' => '<p>The caller isn\'t authorized to make the request. Check permissions.</p>', 'refs' => [], ], 'GetGroupConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'GetGroupConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'GetGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetGroupQueryInput' => [ 'base' => NULL, 'refs' => [], ], 'GetGroupQueryOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetTagsInput' => [ 'base' => NULL, 'refs' => [], ], 'GetTagsOutput' => [ 'base' => NULL, 'refs' => [], ], 'Group' => [ 'base' => '<p>A resource group that contains AWS resources. You can assign resources to the group by associating either of the following elements with the group:</p> <ul> <li> <p> <a>ResourceQuery</a> - Use a resource query to specify a set of tag keys and values. All resources in the same AWS Region and AWS account that have those keys with the same values are included in the group. You can add a resource query when you create the group.</p> </li> <li> <p> <a>GroupConfiguration</a> - Use a service configuration to associate the group with an AWS service. The configuration specifies which resource types can be included in the group.</p> </li> </ul>', 'refs' => [ 'CreateGroupOutput$Group' => '<p>The description of the resource group.</p>', 'DeleteGroupOutput$Group' => '<p>A full description of the deleted resource group.</p>', 'GetGroupOutput$Group' => '<p>A full description of the resource group.</p>', 'GroupList$member' => NULL, 'UpdateGroupOutput$Group' => '<p>The update description of the resource group.</p>', ], ], 'GroupArn' => [ 'base' => NULL, 'refs' => [ 'GetTagsInput$Arn' => '<p>The ARN of the resource group whose tags you want to retrieve.</p>', 'GetTagsOutput$Arn' => '<p>The ARN of the tagged resource group.</p>', 'Group$GroupArn' => '<p>The ARN of the resource group.</p>', 'GroupIdentifier$GroupArn' => '<p>The ARN of the resource group.</p>', 'TagInput$Arn' => '<p>The ARN of the resource group to which to add tags.</p>', 'TagOutput$Arn' => '<p>The ARN of the tagged resource.</p>', 'UntagInput$Arn' => '<p>The ARN of the resource group from which to remove tags. The command removed both the specified keys and any values associated with those keys.</p>', 'UntagOutput$Arn' => '<p>The ARN of the resource group from which tags have been removed.</p>', ], ], 'GroupConfiguration' => [ 'base' => '<p>A service configuration associated with a resource group. The configuration options are determined by the AWS service that defines the <code>Type</code>, and specifies which resources can be included in the group. You can add a service configuration when you create the group.</p>', 'refs' => [ 'CreateGroupOutput$GroupConfiguration' => '<p>The service configuration associated with the resource group. AWS Resource Groups supports adding service configurations for the following resource group types:</p> <ul> <li> <p> <code>AWS::EC2::CapacityReservationPool</code> - Amazon EC2 capacity reservation pools. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/capacity-reservations-using.html#create-cr-group">Working with capacity reservation groups</a> in the <i>EC2 Users Guide</i>.</p> </li> </ul>', 'GetGroupConfigurationOutput$GroupConfiguration' => '<p>The configuration associated with the specified group.</p>', ], ], 'GroupConfigurationFailureReason' => [ 'base' => NULL, 'refs' => [ 'GroupConfiguration$FailureReason' => '<p>If present, the reason why a request to update the group configuration failed.</p>', ], ], 'GroupConfigurationItem' => [ 'base' => '<p>An item in a group configuration. A group configuration can have one or more items.</p>', 'refs' => [ 'GroupConfigurationList$member' => NULL, ], ], 'GroupConfigurationList' => [ 'base' => NULL, 'refs' => [ 'CreateGroupInput$Configuration' => '<p>A configuration associates the resource group with an AWS service and specifies how the service can interact with the resources in the group. A configuration is an array of <a>GroupConfigurationItem</a> elements.</p> <note> <p>You can specify either a <code>Configuration</code> or a <code>ResourceQuery</code> in a group, but not both.</p> </note>', 'GroupConfiguration$Configuration' => '<p>The configuration currently associated with the group and in effect.</p>', 'GroupConfiguration$ProposedConfiguration' => '<p>If present, the new configuration that is in the process of being applied to the group.</p>', ], ], 'GroupConfigurationParameter' => [ 'base' => '<p>A parameter for a group configuration item.</p>', 'refs' => [ 'GroupParameterList$member' => NULL, ], ], 'GroupConfigurationParameterName' => [ 'base' => NULL, 'refs' => [ 'GroupConfigurationParameter$Name' => '<p>The name of the group configuration parameter.</p> <p>You can specify the following string values:</p> <ul> <li> <p>For configuration item type <code>AWS::ResourceGroups::Generic</code>:</p> <ul> <li> <p> <code>allowed-resource-types</code> </p> <p>Specifies the types of resources that you can add to this group by using the <a>GroupResources</a> operation.</p> </li> </ul> </li> <li> <p>For configuration item type <code>AWS::EC2::CapacityReservationPool</code>:</p> <ul> <li> <p>None - This configuration item type doesn\'t support any parameters.</p> </li> </ul> <p>For more information about EC2 capacity reservation groups, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/capacity-reservations-using.html#create-cr-group">Working with capacity reservation groups</a> in the <i>EC2 Users Guide</i>.</p> </li> </ul>', ], ], 'GroupConfigurationParameterValue' => [ 'base' => NULL, 'refs' => [ 'GroupConfigurationParameterValueList$member' => NULL, ], ], 'GroupConfigurationParameterValueList' => [ 'base' => NULL, 'refs' => [ 'GroupConfigurationParameter$Values' => '<p>The values of for this parameter.</p> <p>You can specify the following string value:</p> <ul> <li> <p>For item type <code>allowed-resource-types</code>: the only supported parameter value is <code>AWS::EC2::CapacityReservation</code>.</p> </li> </ul>', ], ], 'GroupConfigurationStatus' => [ 'base' => NULL, 'refs' => [ 'GroupConfiguration$Status' => '<p>The current status of an attempt to update the group configuration.</p>', ], ], 'GroupConfigurationType' => [ 'base' => NULL, 'refs' => [ 'GroupConfigurationItem$Type' => '<p>Specifies the type of group configuration item. Each item must have a unique value for <code>type</code>.</p> <p>You can specify the following string values:</p> <ul> <li> <p> <code>AWS::EC2::CapacityReservationPool</code> </p> <p>For more information about EC2 capacity reservation groups, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/capacity-reservations-using.html#create-cr-group">Working with capacity reservation groups</a> in the <i>EC2 Users Guide</i>.</p> </li> <li> <p> <code>AWS::ResourceGroups::Generic</code> - Supports parameters that configure the behavior of resource groups of any type.</p> </li> </ul>', ], ], 'GroupFilter' => [ 'base' => '<p>A filter collection that you can use to restrict the results from a <code>List</code> operation to only those you want to include.</p>', 'refs' => [ 'GroupFilterList$member' => NULL, ], ], 'GroupFilterList' => [ 'base' => NULL, 'refs' => [ 'ListGroupsInput$Filters' => '<p>Filters, formatted as <a>GroupFilter</a> objects, that you want to apply to a <code>ListGroups</code> operation.</p> <ul> <li> <p> <code>resource-type</code> - Filter the results to include only those of the specified resource types. Specify up to five resource types in the format <code>AWS::<i>ServiceCode</i>::<i>ResourceType</i> </code>. For example, <code>AWS::EC2::Instance</code>, or <code>AWS::S3::Bucket</code>.</p> </li> <li> <p> <code>configuration-type</code> - Filter the results to include only those groups that have the specified configuration types attached. The current supported values are:</p> <ul> <li> <p>AWS:EC2::CapacityReservationPool</p> </li> </ul> </li> </ul>', ], ], 'GroupFilterName' => [ 'base' => NULL, 'refs' => [ 'GroupFilter$Name' => '<p>The name of the filter. Filter names are case-sensitive.</p>', ], ], 'GroupFilterValue' => [ 'base' => NULL, 'refs' => [ 'GroupFilterValues$member' => NULL, ], ], 'GroupFilterValues' => [ 'base' => NULL, 'refs' => [ 'GroupFilter$Values' => '<p>One or more filter values. Allowed filter values vary by group filter name, and are case-sensitive.</p>', ], ], 'GroupIdentifier' => [ 'base' => '<p>The unique identifiers for a resource group.</p>', 'refs' => [ 'GroupIdentifierList$member' => NULL, ], ], 'GroupIdentifierList' => [ 'base' => NULL, 'refs' => [ 'ListGroupsOutput$GroupIdentifiers' => '<p>A list of <a>GroupIdentifier</a> objects. Each identifier is an object that contains both the <code>Name</code> and the <code>GroupArn</code>.</p>', ], ], 'GroupList' => [ 'base' => NULL, 'refs' => [ 'ListGroupsOutput$Groups' => '<p>This output element is deprecated and shouldn\'t be used. Refer to <code>GroupIdentifiers</code> instead.</p>', ], ], 'GroupName' => [ 'base' => NULL, 'refs' => [ 'CreateGroupInput$Name' => '<p>The name of the group, which is the identifier of the group in other operations. You can\'t change the name of a resource group after you create it. A resource group name can consist of letters, numbers, hyphens, periods, and underscores. The name cannot start with <code>AWS</code> or <code>aws</code>; these are reserved. A resource group name must be unique within each AWS Region in your AWS account.</p>', 'DeleteGroupInput$GroupName' => '<p>Don\'t use this parameter. Use <code>Group</code> instead.</p>', 'GetGroupInput$GroupName' => '<p>Don\'t use this parameter. Use <code>Group</code> instead.</p>', 'GetGroupQueryInput$GroupName' => '<p>Don\'t use this parameter. Use <code>Group</code> instead.</p>', 'Group$Name' => '<p>The name of the resource group.</p>', 'GroupIdentifier$GroupName' => '<p>The name of the resource group.</p>', 'GroupQuery$GroupName' => '<p>The name of the resource group that is associated with the specified resource query.</p>', 'ListGroupResourcesInput$GroupName' => '<p>Don\'t use this parameter. Use <code>Group</code> instead.</p>', 'UpdateGroupInput$GroupName' => '<p>Don\'t use this parameter. Use <code>Group</code> instead.</p>', 'UpdateGroupQueryInput$GroupName' => '<p>Don\'t use this parameter. Use <code>Group</code> instead.</p>', ], ], 'GroupParameterList' => [ 'base' => NULL, 'refs' => [ 'GroupConfigurationItem$Parameters' => '<p>A collection of parameters for this group configuration item.</p>', ], ], 'GroupQuery' => [ 'base' => '<p>A mapping of a query attached to a resource group that determines the AWS resources that are members of the group.</p>', 'refs' => [ 'GetGroupQueryOutput$GroupQuery' => '<p>The resource query associated with the specified group.</p>', 'UpdateGroupQueryOutput$GroupQuery' => '<p>The updated resource query associated with the resource group after the update.</p>', ], ], 'GroupResourcesInput' => [ 'base' => NULL, 'refs' => [], ], 'GroupResourcesOutput' => [ 'base' => NULL, 'refs' => [], ], 'GroupString' => [ 'base' => NULL, 'refs' => [ 'DeleteGroupInput$Group' => '<p>The name or the ARN of the resource group to delete.</p>', 'GetGroupConfigurationInput$Group' => '<p>The name or the ARN of the resource group.</p>', 'GetGroupInput$Group' => '<p>The name or the ARN of the resource group to retrieve.</p>', 'GetGroupQueryInput$Group' => '<p>The name or the ARN of the resource group to query.</p>', 'GroupResourcesInput$Group' => '<p>The name or the ARN of the resource group to add resources to.</p>', 'ListGroupResourcesInput$Group' => '<p>The name or the ARN of the resource group</p>', 'UngroupResourcesInput$Group' => '<p>The name or the ARN of the resource group from which to remove the resources.</p>', 'UpdateGroupInput$Group' => '<p>The name or the ARN of the resource group to modify.</p>', 'UpdateGroupQueryInput$Group' => '<p>The name or the ARN of the resource group to query.</p>', ], ], 'InternalServerErrorException' => [ 'base' => '<p>An internal error occurred while processing the request. Try again later.</p>', 'refs' => [], ], 'ListGroupResourcesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupResourcesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupsOutput' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListGroupResourcesInput$MaxResults' => '<p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListGroupsInput$MaxResults' => '<p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'SearchResourcesInput$MaxResults' => '<p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', ], ], 'MethodNotAllowedException' => [ 'base' => '<p>The request uses an HTTP method that isn\'t allowed for the specified resource.</p>', 'refs' => [], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListGroupResourcesInput$NextToken' => '<p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value provided by a previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListGroupResourcesOutput$NextToken' => '<p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListGroupsInput$NextToken' => '<p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value provided by a previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListGroupsOutput$NextToken' => '<p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'SearchResourcesInput$NextToken' => '<p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value provided by a previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'SearchResourcesOutput$NextToken' => '<p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', ], ], 'NotFoundException' => [ 'base' => '<p>One or more of the specified resources don\'t exist.</p>', 'refs' => [], ], 'Query' => [ 'base' => NULL, 'refs' => [ 'ResourceQuery$Query' => '<p>The query that defines a group or a search.</p>', ], ], 'QueryError' => [ 'base' => '<p>A two-part error structure that can occur in <code>ListGroupResources</code> or <code>SearchResources</code> operations on CloudFormation stack-based queries. The error occurs if the CloudFormation stack on which the query is based either does not exist, or has a status that renders the stack inactive. A <code>QueryError</code> occurrence does not necessarily mean that AWS Resource Groups could not complete the operation, but the resulting group might have no member resources.</p>', 'refs' => [ 'QueryErrorList$member' => NULL, ], ], 'QueryErrorCode' => [ 'base' => NULL, 'refs' => [ 'QueryError$ErrorCode' => '<p>Possible values are <code>CLOUDFORMATION_STACK_INACTIVE</code> and <code>CLOUDFORMATION_STACK_NOT_EXISTING</code>.</p>', ], ], 'QueryErrorList' => [ 'base' => NULL, 'refs' => [ 'ListGroupResourcesOutput$QueryErrors' => '<p>A list of <code>QueryError</code> objects. Each error is an object that contains <code>ErrorCode</code> and <code>Message</code> structures. Possible values for <code>ErrorCode</code> are <code>CLOUDFORMATION_STACK_INACTIVE</code> and <code>CLOUDFORMATION_STACK_NOT_EXISTING</code>.</p>', 'SearchResourcesOutput$QueryErrors' => '<p>A list of <code>QueryError</code> objects. Each error is an object that contains <code>ErrorCode</code> and <code>Message</code> structures. Possible values for <code>ErrorCode</code> are <code>CLOUDFORMATION_STACK_INACTIVE</code> and <code>CLOUDFORMATION_STACK_NOT_EXISTING</code>.</p>', ], ], 'QueryErrorMessage' => [ 'base' => NULL, 'refs' => [ 'QueryError$Message' => '<p>A message that explains the <code>ErrorCode</code> value. Messages might state that the specified CloudFormation stack does not exist (or no longer exists). For <code>CLOUDFORMATION_STACK_INACTIVE</code>, the message typically states that the CloudFormation stack has a status that is not (or no longer) active, such as <code>CREATE_FAILED</code>.</p>', ], ], 'QueryType' => [ 'base' => NULL, 'refs' => [ 'ResourceQuery$Type' => '<p>The type of the query. You can use the following values:</p> <ul> <li> <p> <i> <code>CLOUDFORMATION_STACK_1_0:</code> </i> A JSON syntax that lets you specify a CloudFormation stack ARN.</p> </li> <li> <p> <i> <code>TAG_FILTERS_1_0:</code> </i> A JSON syntax that lets you specify a collection of simple tag filters for resource types and tags, as supported by the AWS Tagging API <a href="https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetResources.html#resourcegrouptagging-GetResources-request-ResourceTypeFilters"> <code>ResourceTypeFilters</code> parameter of the <code>tagging:GetResources</code> </a> operation. If you specify more than one tag key, only resources that match all tag keys, and at least one value of each specified tag key, are returned in your query. If you specify more than one value for a tag key, a resource matches the filter if it has a tag key value that matches <i>any</i> of the specified values.</p> <p>For example, consider the following sample query for resources that have two tags, <code>Stage</code> and <code>Version</code>, with two values each:</p> <p> <code>[{"Key":"Stage","Values":["Test","Deploy"]},{"Key":"Version","Values":["1","2"]}]</code> </p> <p>The results of this query could include the following.</p> <ul> <li> <p>An EC2 instance that has the following two tags: <code>{"Key":"Stage","Value":"Deploy"}</code>, and <code>{"Key":"Version","Value":"2"}</code> </p> </li> <li> <p>An S3 bucket that has the following two tags: <code>{"Key":"Stage","Value":"Test"}</code>, and <code>{"Key":"Version","Value":"1"}</code> </p> </li> </ul> <p>The query would not include the following items in the results, however. </p> <ul> <li> <p>An EC2 instance that has only the following tag: <code>{"Key":"Stage","Value":"Deploy"}</code>.</p> <p>The instance does not have <b>all</b> of the tag keys specified in the filter, so it is excluded from the results.</p> </li> <li> <p>An RDS database that has the following two tags: <code>{"Key":"Stage","Value":"Archived"}</code>, and <code>{"Key":"Version","Value":"4"}</code> </p> <p>The database has all of the tag keys, but none of those keys has an associated value that matches at least one of the specified values in the filter.</p> </li> </ul> </li> </ul>', ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'FailedResource$ResourceArn' => '<p>The ARN of the resource that failed to be added or removed.</p>', 'ResourceArnList$member' => NULL, 'ResourceIdentifier$ResourceArn' => '<p>The ARN of a resource.</p>', ], ], 'ResourceArnList' => [ 'base' => NULL, 'refs' => [ 'GroupResourcesInput$ResourceArns' => '<p>The list of ARNs for resources to be added to the group. </p>', 'GroupResourcesOutput$Succeeded' => '<p>The ARNs of the resources that were successfully added to the group by this operation.</p>', 'UngroupResourcesInput$ResourceArns' => '<p>The ARNs of the resources to be removed from the group.</p>', 'UngroupResourcesOutput$Succeeded' => '<p>The ARNs of the resources that were successfully removed from the group.</p>', ], ], 'ResourceFilter' => [ 'base' => '<p>A filter name and value pair that is used to obtain more specific results from a list of resources.</p>', 'refs' => [ 'ResourceFilterList$member' => NULL, ], ], 'ResourceFilterList' => [ 'base' => NULL, 'refs' => [ 'ListGroupResourcesInput$Filters' => '<p>Filters, formatted as <a>ResourceFilter</a> objects, that you want to apply to a <code>ListGroupResources</code> operation. Filters the results to include only those of the specified resource types.</p> <ul> <li> <p> <code>resource-type</code> - Filter resources by their type. Specify up to five resource types in the format <code>AWS::ServiceCode::ResourceType</code>. For example, <code>AWS::EC2::Instance</code>, or <code>AWS::S3::Bucket</code>. </p> </li> </ul> <p>When you specify a <code>resource-type</code> filter for <code>ListGroupResources</code>, AWS Resource Groups validates your filter resource types against the types that are defined in the query associated with the group. For example, if a group contains only S3 buckets because its query specifies only that resource type, but your <code>resource-type</code> filter includes EC2 instances, AWS Resource Groups does not filter for EC2 instances. In this case, a <code>ListGroupResources</code> request returns a <code>BadRequestException</code> error with a message similar to the following:</p> <p> <code>The resource types specified as filters in the request are not valid.</code> </p> <p>The error includes a list of resource types that failed the validation because they are not part of the query associated with the group. This validation doesn\'t occur when the group query specifies <code>AWS::AllSupported</code>, because a group based on such a query can contain any of the allowed resource types for the query type (tag-based or AWS CloudFormation stack-based queries).</p>', ], ], 'ResourceFilterName' => [ 'base' => NULL, 'refs' => [ 'ResourceFilter$Name' => '<p>The name of the filter. Filter names are case-sensitive.</p>', ], ], 'ResourceFilterValue' => [ 'base' => NULL, 'refs' => [ 'ResourceFilterValues$member' => NULL, ], ], 'ResourceFilterValues' => [ 'base' => NULL, 'refs' => [ 'ResourceFilter$Values' => '<p>One or more filter values. Allowed filter values vary by resource filter name, and are case-sensitive.</p>', ], ], 'ResourceIdentifier' => [ 'base' => '<p>The ARN of a resource, and its resource type.</p>', 'refs' => [ 'ResourceIdentifierList$member' => NULL, ], ], 'ResourceIdentifierList' => [ 'base' => NULL, 'refs' => [ 'ListGroupResourcesOutput$ResourceIdentifiers' => '<p>The ARNs and resource types of resources that are members of the group that you specified.</p>', 'SearchResourcesOutput$ResourceIdentifiers' => '<p>The ARNs and resource types of resources that are members of the group that you specified.</p>', ], ], 'ResourceQuery' => [ 'base' => '<p>The query that is used to define a resource group or a search for resources.</p>', 'refs' => [ 'CreateGroupInput$ResourceQuery' => '<p>The resource query that determines which AWS resources are members of this group.</p> <note> <p>You can specify either a <code>ResourceQuery</code> or a <code>Configuration</code>, but not both.</p> </note>', 'CreateGroupOutput$ResourceQuery' => '<p>The resource query associated with the group.</p>', 'GroupQuery$ResourceQuery' => '<p>The resource query that determines which AWS resources are members of the associated resource group.</p>', 'SearchResourcesInput$ResourceQuery' => '<p>The search query, using the same formats that are supported for resource group definition. For more information, see <a>CreateGroup</a>.</p>', 'UpdateGroupQueryInput$ResourceQuery' => '<p>The resource query to determine which AWS resources are members of this resource group.</p>', ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ResourceIdentifier$ResourceType' => '<p>The resource type of a resource, such as <code>AWS::EC2::Instance</code>.</p>', ], ], 'SearchResourcesInput' => [ 'base' => NULL, 'refs' => [], ], 'SearchResourcesOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagInput' => [ 'base' => NULL, 'refs' => [], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'Tags$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagInput$Keys' => '<p>The keys of the tags to be removed.</p>', 'UntagOutput$Keys' => '<p>The keys of the tags that were removed.</p>', ], ], 'TagOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tags$value' => NULL, ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'CreateGroupInput$Tags' => '<p>The tags to add to the group. A tag is key-value pair string.</p>', 'CreateGroupOutput$Tags' => '<p>The tags associated with the group.</p>', 'GetTagsOutput$Tags' => '<p>The tags associated with the specified resource group.</p>', 'TagInput$Tags' => '<p>The tags to add to the specified resource group. A tag is a string-to-string map of key-value pairs.</p>', 'TagOutput$Tags' => '<p>The tags that have been added to the specified resource group.</p>', ], ], 'TooManyRequestsException' => [ 'base' => '<p>You\'ve exceeded throttling limits by making too many requests in a period of time.</p>', 'refs' => [], ], 'UnauthorizedException' => [ 'base' => '<p>The request was rejected because it doesn\'t have valid credentials for the target resource.</p>', 'refs' => [], ], 'UngroupResourcesInput' => [ 'base' => NULL, 'refs' => [], ], 'UngroupResourcesOutput' => [ 'base' => NULL, 'refs' => [], ], 'UntagInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGroupQueryInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGroupQueryOutput' => [ 'base' => NULL, 'refs' => [], ], ],];
