<?php
// This file was auto-generated from sdk-root/src/data/rekognition/2016-06-27/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>This is the Amazon Rekognition API reference.</p>', 'operations' => [ 'CompareFaces' => '<p>Compares a face in the <i>source</i> input image with each of the 100 largest faces detected in the <i>target</i> input image. </p> <note> <p> If the source image contains multiple faces, the service detects the largest face and compares it with each face detected in the target image. </p> </note> <p>You pass the input and target images either as base64-encoded image bytes or as references to images in an Amazon S3 bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes isn\'t supported. The image must be formatted as a PNG or JPEG file. </p> <p>In response, the operation returns an array of face matches ordered by similarity score in descending order. For each face match, the response provides a bounding box of the face, facial landmarks, pose details (pitch, role, and yaw), quality (brightness and sharpness), and confidence value (indicating the level of confidence that the bounding box contains a face). The response also provides a similarity score, which indicates how closely the faces match. </p> <note> <p>By default, only faces with a similarity score of greater than or equal to 80% are returned in the response. You can change this value by specifying the <code>SimilarityThreshold</code> parameter.</p> </note> <p> <code>CompareFaces</code> also returns an array of faces that don\'t match the source image. For each face, it returns a bounding box, confidence value, landmarks, pose details, and quality. The response also returns information about the face in the source image, including the bounding box of the face and confidence value.</p> <p>The <code>QualityFilter</code> input parameter allows you to filter out detected faces that don’t meet a required quality bar. The quality bar is based on a variety of common use cases. Use <code>QualityFilter</code> to set the quality bar by specifying <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>. If you do not want to filter detected faces, specify <code>NONE</code>. The default value is <code>NONE</code>. </p> <note> <p>To use quality filtering, you need a collection associated with version 3 of the face model or higher. To get the version of the face model associated with a collection, call <a>DescribeCollection</a>. </p> </note> <p>If the image doesn\'t contain Exif metadata, <code>CompareFaces</code> returns orientation information for the source and target images. Use these values to display the images with the correct image orientation.</p> <p>If no faces are detected in the source or target images, <code>CompareFaces</code> returns an <code>InvalidParameterException</code> error. </p> <note> <p> This is a stateless API operation. That is, data returned by this operation doesn\'t persist.</p> </note> <p>For an example, see Comparing Faces in Images in the Amazon Rekognition Developer Guide.</p> <p>This operation requires permissions to perform the <code>rekognition:CompareFaces</code> action.</p>', 'CreateCollection' => '<p>Creates a collection in an AWS Region. You can add faces to the collection using the <a>IndexFaces</a> operation. </p> <p>For example, you might create collections, one for each of your application users. A user can then index faces using the <code>IndexFaces</code> operation and persist results in a specific collection. Then, a user can search the collection for faces in the user-specific container. </p> <p>When you create a collection, it is associated with the latest version of the face model version.</p> <note> <p>Collection names are case-sensitive.</p> </note> <p>This operation requires permissions to perform the <code>rekognition:CreateCollection</code> action.</p>', 'CreateProject' => '<p>Creates a new Amazon Rekognition Custom Labels project. A project is a logical grouping of resources (images, Labels, models) and operations (training, evaluation and detection). </p> <p>This operation requires permissions to perform the <code>rekognition:CreateProject</code> action.</p>', 'CreateProjectVersion' => '<p>Creates a new version of a model and begins training. Models are managed as part of an Amazon Rekognition Custom Labels project. You can specify one training dataset and one testing dataset. The response from <code>CreateProjectVersion</code> is an Amazon Resource Name (ARN) for the version of the model. </p> <p>Training takes a while to complete. You can get the current status by calling <a>DescribeProjectVersions</a>.</p> <p>Once training has successfully completed, call <a>DescribeProjectVersions</a> to get the training results and evaluate the model. </p> <p>After evaluating the model, you start the model by calling <a>StartProjectVersion</a>.</p> <p>This operation requires permissions to perform the <code>rekognition:CreateProjectVersion</code> action.</p>', 'CreateStreamProcessor' => '<p>Creates an Amazon Rekognition stream processor that you can use to detect and recognize faces in a streaming video.</p> <p>Amazon Rekognition Video is a consumer of live video from Amazon Kinesis Video Streams. Amazon Rekognition Video sends analysis results to Amazon Kinesis Data Streams.</p> <p>You provide as input a Kinesis video stream (<code>Input</code>) and a Kinesis data stream (<code>Output</code>) stream. You also specify the face recognition criteria in <code>Settings</code>. For example, the collection containing faces that you want to recognize. Use <code>Name</code> to assign an identifier for the stream processor. You use <code>Name</code> to manage the stream processor. For example, you can start processing the source video by calling <a>StartStreamProcessor</a> with the <code>Name</code> field. </p> <p>After you have finished analyzing a streaming video, use <a>StopStreamProcessor</a> to stop processing. You can delete the stream processor by calling <a>DeleteStreamProcessor</a>.</p>', 'DeleteCollection' => '<p>Deletes the specified collection. Note that this operation removes all faces in the collection. For an example, see <a>delete-collection-procedure</a>.</p> <p>This operation requires permissions to perform the <code>rekognition:DeleteCollection</code> action.</p>', 'DeleteFaces' => '<p>Deletes faces from a collection. You specify a collection ID and an array of face IDs to remove from the collection.</p> <p>This operation requires permissions to perform the <code>rekognition:DeleteFaces</code> action.</p>', 'DeleteProject' => '<p>Deletes an Amazon Rekognition Custom Labels project. To delete a project you must first delete all models associated with the project. To delete a model, see <a>DeleteProjectVersion</a>.</p> <p>This operation requires permissions to perform the <code>rekognition:DeleteProject</code> action. </p>', 'DeleteProjectVersion' => '<p>Deletes an Amazon Rekognition Custom Labels model. </p> <p>You can\'t delete a model if it is running or if it is training. To check the status of a model, use the <code>Status</code> field returned from <a>DescribeProjectVersions</a>. To stop a running model call <a>StopProjectVersion</a>. If the model is training, wait until it finishes.</p> <p>This operation requires permissions to perform the <code>rekognition:DeleteProjectVersion</code> action. </p>', 'DeleteStreamProcessor' => '<p>Deletes the stream processor identified by <code>Name</code>. You assign the value for <code>Name</code> when you create the stream processor with <a>CreateStreamProcessor</a>. You might not be able to use the same name for a stream processor for a few seconds after calling <code>DeleteStreamProcessor</code>.</p>', 'DescribeCollection' => '<p>Describes the specified collection. You can use <code>DescribeCollection</code> to get information, such as the number of faces indexed into a collection and the version of the model used by the collection for face detection.</p> <p>For more information, see Describing a Collection in the Amazon Rekognition Developer Guide.</p>', 'DescribeProjectVersions' => '<p>Lists and describes the models in an Amazon Rekognition Custom Labels project. You can specify up to 10 model versions in <code>ProjectVersionArns</code>. If you don\'t specify a value, descriptions for all models are returned.</p> <p>This operation requires permissions to perform the <code>rekognition:DescribeProjectVersions</code> action.</p>', 'DescribeProjects' => '<p>Lists and gets information about your Amazon Rekognition Custom Labels projects.</p> <p>This operation requires permissions to perform the <code>rekognition:DescribeProjects</code> action.</p>', 'DescribeStreamProcessor' => '<p>Provides information about a stream processor created by <a>CreateStreamProcessor</a>. You can get information about the input and output streams, the input parameters for the face recognition being performed, and the current status of the stream processor.</p>', 'DetectCustomLabels' => '<p>Detects custom labels in a supplied image by using an Amazon Rekognition Custom Labels model. </p> <p>You specify which version of a model version to use by using the <code>ProjectVersionArn</code> input parameter. </p> <p>You pass the input image as base64-encoded image bytes or as a reference to an image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. The image must be either a PNG or JPEG formatted file. </p> <p> For each object that the model version detects on an image, the API returns a (<code>CustomLabel</code>) object in an array (<code>CustomLabels</code>). Each <code>CustomLabel</code> object provides the label name (<code>Name</code>), the level of confidence that the image contains the object (<code>Confidence</code>), and object location information, if it exists, for the label on the image (<code>Geometry</code>). </p> <p>During training model calculates a threshold value that determines if a prediction for a label is true. By default, <code>DetectCustomLabels</code> doesn\'t return labels whose confidence value is below the model\'s calculated threshold value. To filter labels that are returned, specify a value for <code>MinConfidence</code> that is higher than the model\'s calculated threshold. You can get the model\'s calculated threshold from the model\'s training results shown in the Amazon Rekognition Custom Labels console. To get all labels, regardless of confidence, specify a <code>MinConfidence</code> value of 0. </p> <p>You can also add the <code>MaxResults</code> parameter to limit the number of labels returned. </p> <p>This is a stateless API operation. That is, the operation does not persist any data.</p> <p>This operation requires permissions to perform the <code>rekognition:DetectCustomLabels</code> action. </p>', 'DetectFaces' => '<p>Detects faces within an image that is provided as input.</p> <p> <code>DetectFaces</code> detects the 100 largest faces in the image. For each face detected, the operation returns face details. These details include a bounding box of the face, a confidence value (that the bounding box contains a face), and a fixed set of attributes such as facial landmarks (for example, coordinates of eye and mouth), presence of beard, sunglasses, and so on. </p> <p>The face-detection algorithm is most effective on frontal faces. For non-frontal or obscured faces, the algorithm might not detect the faces or might detect faces with lower confidence. </p> <p>You pass the input image either as base64-encoded image bytes or as a reference to an image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. The image must be either a PNG or JPEG formatted file. </p> <note> <p>This is a stateless API operation. That is, the operation does not persist any data.</p> </note> <p>This operation requires permissions to perform the <code>rekognition:DetectFaces</code> action. </p>', 'DetectLabels' => '<p>Detects instances of real-world entities within an image (JPEG or PNG) provided as input. This includes objects like flower, tree, and table; events like wedding, graduation, and birthday party; and concepts like landscape, evening, and nature. </p> <p>For an example, see Analyzing Images Stored in an Amazon S3 Bucket in the Amazon Rekognition Developer Guide.</p> <note> <p> <code>DetectLabels</code> does not support the detection of activities. However, activity detection is supported for label detection in videos. For more information, see StartLabelDetection in the Amazon Rekognition Developer Guide.</p> </note> <p>You pass the input image as base64-encoded image bytes or as a reference to an image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. The image must be either a PNG or JPEG formatted file. </p> <p> For each object, scene, and concept the API returns one or more labels. Each label provides the object name, and the level of confidence that the image contains the object. For example, suppose the input image has a lighthouse, the sea, and a rock. The response includes all three labels, one for each object. </p> <p> <code>{Name: lighthouse, Confidence: 98.4629}</code> </p> <p> <code>{Name: rock,Confidence: 79.2097}</code> </p> <p> <code> {Name: sea,Confidence: 75.061}</code> </p> <p>In the preceding example, the operation returns one label for each of the three objects. The operation can also return multiple labels for the same object in the image. For example, if the input image shows a flower (for example, a tulip), the operation might return the following three labels. </p> <p> <code>{Name: flower,Confidence: 99.0562}</code> </p> <p> <code>{Name: plant,Confidence: 99.0562}</code> </p> <p> <code>{Name: tulip,Confidence: 99.0562}</code> </p> <p>In this example, the detection algorithm more precisely identifies the flower as a tulip.</p> <p>In response, the API returns an array of labels. In addition, the response also includes the orientation correction. Optionally, you can specify <code>MinConfidence</code> to control the confidence threshold for the labels returned. The default is 55%. You can also add the <code>MaxLabels</code> parameter to limit the number of labels returned. </p> <note> <p>If the object detected is a person, the operation doesn\'t provide the same facial details that the <a>DetectFaces</a> operation provides.</p> </note> <p> <code>DetectLabels</code> returns bounding boxes for instances of common object labels in an array of <a>Instance</a> objects. An <code>Instance</code> object contains a <a>BoundingBox</a> object, for the location of the label on the image. It also includes the confidence by which the bounding box was detected.</p> <p> <code>DetectLabels</code> also returns a hierarchical taxonomy of detected labels. For example, a detected car might be assigned the label <i>car</i>. The label <i>car</i> has two parent labels: <i>Vehicle</i> (its parent) and <i>Transportation</i> (its grandparent). The response returns the entire list of ancestors for a label. Each ancestor is a unique label in the response. In the previous example, <i>Car</i>, <i>Vehicle</i>, and <i>Transportation</i> are returned as unique labels in the response. </p> <p>This is a stateless API operation. That is, the operation does not persist any data.</p> <p>This operation requires permissions to perform the <code>rekognition:DetectLabels</code> action. </p>', 'DetectModerationLabels' => '<p>Detects unsafe content in a specified JPEG or PNG format image. Use <code>DetectModerationLabels</code> to moderate images depending on your requirements. For example, you might want to filter images that contain nudity, but not images containing suggestive content.</p> <p>To filter images, use the labels returned by <code>DetectModerationLabels</code> to determine which types of content are appropriate.</p> <p>For information about moderation labels, see Detecting Unsafe Content in the Amazon Rekognition Developer Guide.</p> <p>You pass the input image either as base64-encoded image bytes or as a reference to an image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. The image must be either a PNG or JPEG formatted file. </p>', 'DetectText' => '<p>Detects text in the input image and converts it into machine-readable text.</p> <p>Pass the input image as base64-encoded image bytes or as a reference to an image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon Rekognition operations, you must pass it as a reference to an image in an Amazon S3 bucket. For the AWS CLI, passing image bytes is not supported. The image must be either a .png or .jpeg formatted file. </p> <p>The <code>DetectText</code> operation returns text in an array of <a>TextDetection</a> elements, <code>TextDetections</code>. Each <code>TextDetection</code> element provides information about a single word or line of text that was detected in the image. </p> <p>A word is one or more ISO basic latin script characters that are not separated by spaces. <code>DetectText</code> can detect up to 50 words in an image.</p> <p>A line is a string of equally spaced words. A line isn\'t necessarily a complete sentence. For example, a driver\'s license number is detected as a line. A line ends when there is no aligned text after it. Also, a line ends when there is a large gap between words, relative to the length of the words. This means, depending on the gap between words, Amazon Rekognition may detect multiple lines in text aligned in the same direction. Periods don\'t represent the end of a line. If a sentence spans multiple lines, the <code>DetectText</code> operation returns multiple lines.</p> <p>To determine whether a <code>TextDetection</code> element is a line of text or a word, use the <code>TextDetection</code> object <code>Type</code> field. </p> <p>To be detected, text must be within +/- 90 degrees orientation of the horizontal axis.</p> <p>For more information, see DetectText in the Amazon Rekognition Developer Guide.</p>', 'GetCelebrityInfo' => '<p>Gets the name and additional information about a celebrity based on his or her Amazon Rekognition ID. The additional information is returned as an array of URLs. If there is no additional information about the celebrity, this list is empty.</p> <p>For more information, see Recognizing Celebrities in an Image in the Amazon Rekognition Developer Guide.</p> <p>This operation requires permissions to perform the <code>rekognition:GetCelebrityInfo</code> action. </p>', 'GetCelebrityRecognition' => '<p>Gets the celebrity recognition results for a Amazon Rekognition Video analysis started by <a>StartCelebrityRecognition</a>.</p> <p>Celebrity recognition in a video is an asynchronous operation. Analysis is started by a call to <a>StartCelebrityRecognition</a> which returns a job identifier (<code>JobId</code>). When the celebrity recognition operation finishes, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic registered in the initial call to <code>StartCelebrityRecognition</code>. To get the results of the celebrity recognition analysis, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <code>GetCelebrityDetection</code> and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartCelebrityDetection</code>. </p> <p>For more information, see Working With Stored Videos in the Amazon Rekognition Developer Guide.</p> <p> <code>GetCelebrityRecognition</code> returns detected celebrities and the time(s) they are detected in an array (<code>Celebrities</code>) of <a>CelebrityRecognition</a> objects. Each <code>CelebrityRecognition</code> contains information about the celebrity in a <a>CelebrityDetail</a> object and the time, <code>Timestamp</code>, the celebrity was detected. </p> <note> <p> <code>GetCelebrityRecognition</code> only returns the default facial attributes (<code>BoundingBox</code>, <code>Confidence</code>, <code>Landmarks</code>, <code>Pose</code>, and <code>Quality</code>). The other facial attributes listed in the <code>Face</code> object of the following response syntax are not returned. For more information, see FaceDetail in the Amazon Rekognition Developer Guide. </p> </note> <p>By default, the <code>Celebrities</code> array is sorted by time (milliseconds from the start of the video). You can also sort the array by celebrity by specifying the value <code>ID</code> in the <code>SortBy</code> input parameter.</p> <p>The <code>CelebrityDetail</code> object includes the celebrity identifer and additional information urls. If you don\'t store the additional information urls, you can get them later by calling <a>GetCelebrityInfo</a> with the celebrity identifer.</p> <p>No information is returned for faces not recognized as celebrities.</p> <p>Use MaxResults parameter to limit the number of labels returned. If there are more results than specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination token for getting the next set of results. To get the next page of results, call <code>GetCelebrityDetection</code> and populate the <code>NextToken</code> request parameter with the token value returned from the previous call to <code>GetCelebrityRecognition</code>.</p>', 'GetContentModeration' => '<p>Gets the unsafe content analysis results for a Amazon Rekognition Video analysis started by <a>StartContentModeration</a>.</p> <p>Unsafe content analysis of a video is an asynchronous operation. You start analysis by calling <a>StartContentModeration</a> which returns a job identifier (<code>JobId</code>). When analysis finishes, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic registered in the initial call to <code>StartContentModeration</code>. To get the results of the unsafe content analysis, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <code>GetContentModeration</code> and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartContentModeration</code>. </p> <p>For more information, see Working with Stored Videos in the Amazon Rekognition Devlopers Guide.</p> <p> <code>GetContentModeration</code> returns detected unsafe content labels, and the time they are detected, in an array, <code>ModerationLabels</code>, of <a>ContentModerationDetection</a> objects. </p> <p>By default, the moderated labels are returned sorted by time, in milliseconds from the start of the video. You can also sort them by moderated label by specifying <code>NAME</code> for the <code>SortBy</code> input parameter. </p> <p>Since video analysis can return a large number of results, use the <code>MaxResults</code> parameter to limit the number of labels returned in a single call to <code>GetContentModeration</code>. If there are more results than specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination token for getting the next set of results. To get the next page of results, call <code>GetContentModeration</code> and populate the <code>NextToken</code> request parameter with the value of <code>NextToken</code> returned from the previous call to <code>GetContentModeration</code>.</p> <p>For more information, see Detecting Unsafe Content in the Amazon Rekognition Developer Guide.</p>', 'GetFaceDetection' => '<p>Gets face detection results for a Amazon Rekognition Video analysis started by <a>StartFaceDetection</a>.</p> <p>Face detection with Amazon Rekognition Video is an asynchronous operation. You start face detection by calling <a>StartFaceDetection</a> which returns a job identifier (<code>JobId</code>). When the face detection operation finishes, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic registered in the initial call to <code>StartFaceDetection</code>. To get the results of the face detection operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <a>GetFaceDetection</a> and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartFaceDetection</code>.</p> <p> <code>GetFaceDetection</code> returns an array of detected faces (<code>Faces</code>) sorted by the time the faces were detected. </p> <p>Use MaxResults parameter to limit the number of labels returned. If there are more results than specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination token for getting the next set of results. To get the next page of results, call <code>GetFaceDetection</code> and populate the <code>NextToken</code> request parameter with the token value returned from the previous call to <code>GetFaceDetection</code>.</p>', 'GetFaceSearch' => '<p>Gets the face search results for Amazon Rekognition Video face search started by <a>StartFaceSearch</a>. The search returns faces in a collection that match the faces of persons detected in a video. It also includes the time(s) that faces are matched in the video.</p> <p>Face search in a video is an asynchronous operation. You start face search by calling to <a>StartFaceSearch</a> which returns a job identifier (<code>JobId</code>). When the search operation finishes, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic registered in the initial call to <code>StartFaceSearch</code>. To get the search results, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <code>GetFaceSearch</code> and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartFaceSearch</code>.</p> <p>For more information, see Searching Faces in a Collection in the Amazon Rekognition Developer Guide.</p> <p>The search results are retured in an array, <code>Persons</code>, of <a>PersonMatch</a> objects. Each<code>PersonMatch</code> element contains details about the matching faces in the input collection, person information (facial attributes, bounding boxes, and person identifer) for the matched person, and the time the person was matched in the video.</p> <note> <p> <code>GetFaceSearch</code> only returns the default facial attributes (<code>BoundingBox</code>, <code>Confidence</code>, <code>Landmarks</code>, <code>Pose</code>, and <code>Quality</code>). The other facial attributes listed in the <code>Face</code> object of the following response syntax are not returned. For more information, see FaceDetail in the Amazon Rekognition Developer Guide. </p> </note> <p>By default, the <code>Persons</code> array is sorted by the time, in milliseconds from the start of the video, persons are matched. You can also sort by persons by specifying <code>INDEX</code> for the <code>SORTBY</code> input parameter.</p>', 'GetLabelDetection' => '<p>Gets the label detection results of a Amazon Rekognition Video analysis started by <a>StartLabelDetection</a>. </p> <p>The label detection operation is started by a call to <a>StartLabelDetection</a> which returns a job identifier (<code>JobId</code>). When the label detection operation finishes, Amazon Rekognition publishes a completion status to the Amazon Simple Notification Service topic registered in the initial call to <code>StartlabelDetection</code>. To get the results of the label detection operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <a>GetLabelDetection</a> and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartLabelDetection</code>.</p> <p> <code>GetLabelDetection</code> returns an array of detected labels (<code>Labels</code>) sorted by the time the labels were detected. You can also sort by the label name by specifying <code>NAME</code> for the <code>SortBy</code> input parameter.</p> <p>The labels returned include the label name, the percentage confidence in the accuracy of the detected label, and the time the label was detected in the video.</p> <p>The returned labels also include bounding box information for common objects, a hierarchical taxonomy of detected labels, and the version of the label model used for detection.</p> <p>Use MaxResults parameter to limit the number of labels returned. If there are more results than specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination token for getting the next set of results. To get the next page of results, call <code>GetlabelDetection</code> and populate the <code>NextToken</code> request parameter with the token value returned from the previous call to <code>GetLabelDetection</code>.</p>', 'GetPersonTracking' => '<p>Gets the path tracking results of a Amazon Rekognition Video analysis started by <a>StartPersonTracking</a>.</p> <p>The person path tracking operation is started by a call to <code>StartPersonTracking</code> which returns a job identifier (<code>JobId</code>). When the operation finishes, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic registered in the initial call to <code>StartPersonTracking</code>.</p> <p>To get the results of the person path tracking operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <a>GetPersonTracking</a> and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartPersonTracking</code>.</p> <p> <code>GetPersonTracking</code> returns an array, <code>Persons</code>, of tracked persons and the time(s) their paths were tracked in the video. </p> <note> <p> <code>GetPersonTracking</code> only returns the default facial attributes (<code>BoundingBox</code>, <code>Confidence</code>, <code>Landmarks</code>, <code>Pose</code>, and <code>Quality</code>). The other facial attributes listed in the <code>Face</code> object of the following response syntax are not returned. </p> <p>For more information, see FaceDetail in the Amazon Rekognition Developer Guide.</p> </note> <p>By default, the array is sorted by the time(s) a person\'s path is tracked in the video. You can sort by tracked persons by specifying <code>INDEX</code> for the <code>SortBy</code> input parameter.</p> <p>Use the <code>MaxResults</code> parameter to limit the number of items returned. If there are more results than specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination token for getting the next set of results. To get the next page of results, call <code>GetPersonTracking</code> and populate the <code>NextToken</code> request parameter with the token value returned from the previous call to <code>GetPersonTracking</code>.</p>', 'GetSegmentDetection' => '<p>Gets the segment detection results of a Amazon Rekognition Video analysis started by <a>StartSegmentDetection</a>.</p> <p>Segment detection with Amazon Rekognition Video is an asynchronous operation. You start segment detection by calling <a>StartSegmentDetection</a> which returns a job identifier (<code>JobId</code>). When the segment detection operation finishes, Amazon Rekognition publishes a completion status to the Amazon Simple Notification Service topic registered in the initial call to <code>StartSegmentDetection</code>. To get the results of the segment detection operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. if so, call <code>GetSegmentDetection</code> and pass the job identifier (<code>JobId</code>) from the initial call of <code>StartSegmentDetection</code>.</p> <p> <code>GetSegmentDetection</code> returns detected segments in an array (<code>Segments</code>) of <a>SegmentDetection</a> objects. <code>Segments</code> is sorted by the segment types specified in the <code>SegmentTypes</code> input parameter of <code>StartSegmentDetection</code>. Each element of the array includes the detected segment, the precentage confidence in the acuracy of the detected segment, the type of the segment, and the frame in which the segment was detected.</p> <p>Use <code>SelectedSegmentTypes</code> to find out the type of segment detection requested in the call to <code>StartSegmentDetection</code>.</p> <p>Use the <code>MaxResults</code> parameter to limit the number of segment detections returned. If there are more results than specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination token for getting the next set of results. To get the next page of results, call <code>GetSegmentDetection</code> and populate the <code>NextToken</code> request parameter with the token value returned from the previous call to <code>GetSegmentDetection</code>.</p> <p>For more information, see Detecting Video Segments in Stored Video in the Amazon Rekognition Developer Guide.</p>', 'GetTextDetection' => '<p>Gets the text detection results of a Amazon Rekognition Video analysis started by <a>StartTextDetection</a>.</p> <p>Text detection with Amazon Rekognition Video is an asynchronous operation. You start text detection by calling <a>StartTextDetection</a> which returns a job identifier (<code>JobId</code>) When the text detection operation finishes, Amazon Rekognition publishes a completion status to the Amazon Simple Notification Service topic registered in the initial call to <code>StartTextDetection</code>. To get the results of the text detection operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. if so, call <code>GetTextDetection</code> and pass the job identifier (<code>JobId</code>) from the initial call of <code>StartLabelDetection</code>.</p> <p> <code>GetTextDetection</code> returns an array of detected text (<code>TextDetections</code>) sorted by the time the text was detected, up to 50 words per frame of video.</p> <p>Each element of the array includes the detected text, the precentage confidence in the acuracy of the detected text, the time the text was detected, bounding box information for where the text was located, and unique identifiers for words and their lines.</p> <p>Use MaxResults parameter to limit the number of text detections returned. If there are more results than specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination token for getting the next set of results. To get the next page of results, call <code>GetTextDetection</code> and populate the <code>NextToken</code> request parameter with the token value returned from the previous call to <code>GetTextDetection</code>.</p>', 'IndexFaces' => '<p>Detects faces in the input image and adds them to the specified collection. </p> <p>Amazon Rekognition doesn\'t save the actual faces that are detected. Instead, the underlying detection algorithm first detects the faces in the input image. For each face, the algorithm extracts facial features into a feature vector, and stores it in the backend database. Amazon Rekognition uses feature vectors when it performs face match and search operations using the <a>SearchFaces</a> and <a>SearchFacesByImage</a> operations.</p> <p>For more information, see Adding Faces to a Collection in the Amazon Rekognition Developer Guide.</p> <p>To get the number of faces in a collection, call <a>DescribeCollection</a>. </p> <p>If you\'re using version 1.0 of the face detection model, <code>IndexFaces</code> indexes the 15 largest faces in the input image. Later versions of the face detection model index the 100 largest faces in the input image. </p> <p>If you\'re using version 4 or later of the face model, image orientation information is not returned in the <code>OrientationCorrection</code> field. </p> <p>To determine which version of the model you\'re using, call <a>DescribeCollection</a> and supply the collection ID. You can also get the model version from the value of <code>FaceModelVersion</code> in the response from <code>IndexFaces</code> </p> <p>For more information, see Model Versioning in the Amazon Rekognition Developer Guide.</p> <p>If you provide the optional <code>ExternalImageId</code> for the input image you provided, Amazon Rekognition associates this ID with all faces that it detects. When you call the <a>ListFaces</a> operation, the response returns the external ID. You can use this external image ID to create a client-side index to associate the faces with each image. You can then use the index to find all faces in an image.</p> <p>You can specify the maximum number of faces to index with the <code>MaxFaces</code> input parameter. This is useful when you want to index the largest faces in an image and don\'t want to index smaller faces, such as those belonging to people standing in the background.</p> <p>The <code>QualityFilter</code> input parameter allows you to filter out detected faces that don’t meet a required quality bar. The quality bar is based on a variety of common use cases. By default, <code>IndexFaces</code> chooses the quality bar that\'s used to filter faces. You can also explicitly choose the quality bar. Use <code>QualityFilter</code>, to set the quality bar by specifying <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>. If you do not want to filter detected faces, specify <code>NONE</code>. </p> <note> <p>To use quality filtering, you need a collection associated with version 3 of the face model or higher. To get the version of the face model associated with a collection, call <a>DescribeCollection</a>. </p> </note> <p>Information about faces detected in an image, but not indexed, is returned in an array of <a>UnindexedFace</a> objects, <code>UnindexedFaces</code>. Faces aren\'t indexed for reasons such as:</p> <ul> <li> <p>The number of faces detected exceeds the value of the <code>MaxFaces</code> request parameter.</p> </li> <li> <p>The face is too small compared to the image dimensions.</p> </li> <li> <p>The face is too blurry.</p> </li> <li> <p>The image is too dark.</p> </li> <li> <p>The face has an extreme pose.</p> </li> <li> <p>The face doesn’t have enough detail to be suitable for face search.</p> </li> </ul> <p>In response, the <code>IndexFaces</code> operation returns an array of metadata for all detected faces, <code>FaceRecords</code>. This includes: </p> <ul> <li> <p>The bounding box, <code>BoundingBox</code>, of the detected face. </p> </li> <li> <p>A confidence value, <code>Confidence</code>, which indicates the confidence that the bounding box contains a face.</p> </li> <li> <p>A face ID, <code>FaceId</code>, assigned by the service for each face that\'s detected and stored.</p> </li> <li> <p>An image ID, <code>ImageId</code>, assigned by the service for the input image.</p> </li> </ul> <p>If you request all facial attributes (by using the <code>detectionAttributes</code> parameter), Amazon Rekognition returns detailed facial attributes, such as facial landmarks (for example, location of eye and mouth) and other facial attributes. If you provide the same image, specify the same collection, and use the same external ID in the <code>IndexFaces</code> operation, Amazon Rekognition doesn\'t save duplicate face metadata.</p> <p/> <p>The input image is passed either as base64-encoded image bytes, or as a reference to an image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes isn\'t supported. The image must be formatted as a PNG or JPEG file. </p> <p>This operation requires permissions to perform the <code>rekognition:IndexFaces</code> action.</p>', 'ListCollections' => '<p>Returns list of collection IDs in your account. If the result is truncated, the response also provides a <code>NextToken</code> that you can use in the subsequent request to fetch the next set of collection IDs.</p> <p>For an example, see Listing Collections in the Amazon Rekognition Developer Guide.</p> <p>This operation requires permissions to perform the <code>rekognition:ListCollections</code> action.</p>', 'ListFaces' => '<p>Returns metadata for faces in the specified collection. This metadata includes information such as the bounding box coordinates, the confidence (that the bounding box contains a face), and face ID. For an example, see Listing Faces in a Collection in the Amazon Rekognition Developer Guide.</p> <p>This operation requires permissions to perform the <code>rekognition:ListFaces</code> action.</p>', 'ListStreamProcessors' => '<p>Gets a list of stream processors that you have created with <a>CreateStreamProcessor</a>. </p>', 'RecognizeCelebrities' => '<p>Returns an array of celebrities recognized in the input image. For more information, see Recognizing Celebrities in the Amazon Rekognition Developer Guide. </p> <p> <code>RecognizeCelebrities</code> returns the 100 largest faces in the image. It lists recognized celebrities in the <code>CelebrityFaces</code> array and unrecognized faces in the <code>UnrecognizedFaces</code> array. <code>RecognizeCelebrities</code> doesn\'t return celebrities whose faces aren\'t among the largest 100 faces in the image.</p> <p>For each celebrity recognized, <code>RecognizeCelebrities</code> returns a <code>Celebrity</code> object. The <code>Celebrity</code> object contains the celebrity name, ID, URL links to additional information, match confidence, and a <code>ComparedFace</code> object that you can use to locate the celebrity\'s face on the image.</p> <p>Amazon Rekognition doesn\'t retain information about which images a celebrity has been recognized in. Your application must store this information and use the <code>Celebrity</code> ID property as a unique identifier for the celebrity. If you don\'t store the celebrity name or additional information URLs returned by <code>RecognizeCelebrities</code>, you will need the ID to identify the celebrity in a call to the <a>GetCelebrityInfo</a> operation.</p> <p>You pass the input image either as base64-encoded image bytes or as a reference to an image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. The image must be either a PNG or JPEG formatted file. </p> <p>For an example, see Recognizing Celebrities in an Image in the Amazon Rekognition Developer Guide.</p> <p>This operation requires permissions to perform the <code>rekognition:RecognizeCelebrities</code> operation.</p>', 'SearchFaces' => '<p>For a given input face ID, searches for matching faces in the collection the face belongs to. You get a face ID when you add a face to the collection using the <a>IndexFaces</a> operation. The operation compares the features of the input face with faces in the specified collection. </p> <note> <p>You can also search faces without indexing faces by using the <code>SearchFacesByImage</code> operation.</p> </note> <p> The operation response returns an array of faces that match, ordered by similarity score with the highest similarity first. More specifically, it is an array of metadata for each face match that is found. Along with the metadata, the response also includes a <code>confidence</code> value for each face match, indicating the confidence that the specific face matches the input face. </p> <p>For an example, see Searching for a Face Using Its Face ID in the Amazon Rekognition Developer Guide.</p> <p>This operation requires permissions to perform the <code>rekognition:SearchFaces</code> action.</p>', 'SearchFacesByImage' => '<p>For a given input image, first detects the largest face in the image, and then searches the specified collection for matching faces. The operation compares the features of the input face with faces in the specified collection. </p> <note> <p>To search for all faces in an input image, you might first call the <a>IndexFaces</a> operation, and then use the face IDs returned in subsequent calls to the <a>SearchFaces</a> operation. </p> <p> You can also call the <code>DetectFaces</code> operation and use the bounding boxes in the response to make face crops, which then you can pass in to the <code>SearchFacesByImage</code> operation. </p> </note> <p>You pass the input image either as base64-encoded image bytes or as a reference to an image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. The image must be either a PNG or JPEG formatted file. </p> <p> The response returns an array of faces that match, ordered by similarity score with the highest similarity first. More specifically, it is an array of metadata for each face match found. Along with the metadata, the response also includes a <code>similarity</code> indicating how similar the face is to the input face. In the response, the operation also returns the bounding box (and a confidence level that the bounding box contains a face) of the face that Amazon Rekognition used for the input image. </p> <p>For an example, Searching for a Face Using an Image in the Amazon Rekognition Developer Guide.</p> <p>The <code>QualityFilter</code> input parameter allows you to filter out detected faces that don’t meet a required quality bar. The quality bar is based on a variety of common use cases. Use <code>QualityFilter</code> to set the quality bar for filtering by specifying <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>. If you do not want to filter detected faces, specify <code>NONE</code>. The default value is <code>NONE</code>.</p> <note> <p>To use quality filtering, you need a collection associated with version 3 of the face model or higher. To get the version of the face model associated with a collection, call <a>DescribeCollection</a>. </p> </note> <p>This operation requires permissions to perform the <code>rekognition:SearchFacesByImage</code> action.</p>', 'StartCelebrityRecognition' => '<p>Starts asynchronous recognition of celebrities in a stored video.</p> <p>Amazon Rekognition Video can detect celebrities in a video must be stored in an Amazon S3 bucket. Use <a>Video</a> to specify the bucket name and the filename of the video. <code>StartCelebrityRecognition</code> returns a job identifier (<code>JobId</code>) which you use to get the results of the analysis. When celebrity recognition analysis is finished, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic that you specify in <code>NotificationChannel</code>. To get the results of the celebrity recognition analysis, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <a>GetCelebrityRecognition</a> and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartCelebrityRecognition</code>. </p> <p>For more information, see Recognizing Celebrities in the Amazon Rekognition Developer Guide.</p>', 'StartContentModeration' => '<p> Starts asynchronous detection of unsafe content in a stored video.</p> <p>Amazon Rekognition Video can moderate content in a video stored in an Amazon S3 bucket. Use <a>Video</a> to specify the bucket name and the filename of the video. <code>StartContentModeration</code> returns a job identifier (<code>JobId</code>) which you use to get the results of the analysis. When unsafe content analysis is finished, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic that you specify in <code>NotificationChannel</code>.</p> <p>To get the results of the unsafe content analysis, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <a>GetContentModeration</a> and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartContentModeration</code>. </p> <p>For more information, see Detecting Unsafe Content in the Amazon Rekognition Developer Guide.</p>', 'StartFaceDetection' => '<p>Starts asynchronous detection of faces in a stored video.</p> <p>Amazon Rekognition Video can detect faces in a video stored in an Amazon S3 bucket. Use <a>Video</a> to specify the bucket name and the filename of the video. <code>StartFaceDetection</code> returns a job identifier (<code>JobId</code>) that you use to get the results of the operation. When face detection is finished, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic that you specify in <code>NotificationChannel</code>. To get the results of the face detection operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <a>GetFaceDetection</a> and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartFaceDetection</code>.</p> <p>For more information, see Detecting Faces in a Stored Video in the Amazon Rekognition Developer Guide.</p>', 'StartFaceSearch' => '<p>Starts the asynchronous search for faces in a collection that match the faces of persons detected in a stored video.</p> <p>The video must be stored in an Amazon S3 bucket. Use <a>Video</a> to specify the bucket name and the filename of the video. <code>StartFaceSearch</code> returns a job identifier (<code>JobId</code>) which you use to get the search results once the search has completed. When searching is finished, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic that you specify in <code>NotificationChannel</code>. To get the search results, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <a>GetFaceSearch</a> and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartFaceSearch</code>. For more information, see <a>procedure-person-search-videos</a>.</p>', 'StartLabelDetection' => '<p>Starts asynchronous detection of labels in a stored video.</p> <p>Amazon Rekognition Video can detect labels in a video. Labels are instances of real-world entities. This includes objects like flower, tree, and table; events like wedding, graduation, and birthday party; concepts like landscape, evening, and nature; and activities like a person getting out of a car or a person skiing.</p> <p>The video must be stored in an Amazon S3 bucket. Use <a>Video</a> to specify the bucket name and the filename of the video. <code>StartLabelDetection</code> returns a job identifier (<code>JobId</code>) which you use to get the results of the operation. When label detection is finished, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic that you specify in <code>NotificationChannel</code>.</p> <p>To get the results of the label detection operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <a>GetLabelDetection</a> and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartLabelDetection</code>.</p> <p/>', 'StartPersonTracking' => '<p>Starts the asynchronous tracking of a person\'s path in a stored video.</p> <p>Amazon Rekognition Video can track the path of people in a video stored in an Amazon S3 bucket. Use <a>Video</a> to specify the bucket name and the filename of the video. <code>StartPersonTracking</code> returns a job identifier (<code>JobId</code>) which you use to get the results of the operation. When label detection is finished, Amazon Rekognition publishes a completion status to the Amazon Simple Notification Service topic that you specify in <code>NotificationChannel</code>. </p> <p>To get the results of the person detection operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <a>GetPersonTracking</a> and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartPersonTracking</code>.</p>', 'StartProjectVersion' => '<p>Starts the running of the version of a model. Starting a model takes a while to complete. To check the current state of the model, use <a>DescribeProjectVersions</a>.</p> <p>Once the model is running, you can detect custom labels in new images by calling <a>DetectCustomLabels</a>.</p> <note> <p>You are charged for the amount of time that the model is running. To stop a running model, call <a>StopProjectVersion</a>.</p> </note> <p>This operation requires permissions to perform the <code>rekognition:StartProjectVersion</code> action.</p>', 'StartSegmentDetection' => '<p>Starts asynchronous detection of segment detection in a stored video.</p> <p>Amazon Rekognition Video can detect segments in a video stored in an Amazon S3 bucket. Use <a>Video</a> to specify the bucket name and the filename of the video. <code>StartSegmentDetection</code> returns a job identifier (<code>JobId</code>) which you use to get the results of the operation. When segment detection is finished, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic that you specify in <code>NotificationChannel</code>.</p> <p>You can use the <code>Filters</code> (<a>StartSegmentDetectionFilters</a>) input parameter to specify the minimum detection confidence returned in the response. Within <code>Filters</code>, use <code>ShotFilter</code> (<a>StartShotDetectionFilter</a>) to filter detected shots. Use <code>TechnicalCueFilter</code> (<a>StartTechnicalCueDetectionFilter</a>) to filter technical cues. </p> <p>To get the results of the segment detection operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. if so, call <a>GetSegmentDetection</a> and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartSegmentDetection</code>. </p> <p>For more information, see Detecting Video Segments in Stored Video in the Amazon Rekognition Developer Guide.</p>', 'StartStreamProcessor' => '<p>Starts processing a stream processor. You create a stream processor by calling <a>CreateStreamProcessor</a>. To tell <code>StartStreamProcessor</code> which stream processor to start, use the value of the <code>Name</code> field specified in the call to <code>CreateStreamProcessor</code>.</p>', 'StartTextDetection' => '<p>Starts asynchronous detection of text in a stored video.</p> <p>Amazon Rekognition Video can detect text in a video stored in an Amazon S3 bucket. Use <a>Video</a> to specify the bucket name and the filename of the video. <code>StartTextDetection</code> returns a job identifier (<code>JobId</code>) which you use to get the results of the operation. When text detection is finished, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic that you specify in <code>NotificationChannel</code>.</p> <p>To get the results of the text detection operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. if so, call <a>GetTextDetection</a> and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartTextDetection</code>. </p>', 'StopProjectVersion' => '<p>Stops a running model. The operation might take a while to complete. To check the current status, call <a>DescribeProjectVersions</a>. </p>', 'StopStreamProcessor' => '<p>Stops a running stream processor that was created by <a>CreateStreamProcessor</a>.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You are not authorized to perform the action.</p>', 'refs' => [], ], 'AgeRange' => [ 'base' => '<p>Structure containing the estimated age range, in years, for a face.</p> <p>Amazon Rekognition estimates an age range for faces detected in the input image. Estimated age ranges can overlap. A face of a 5-year-old might have an estimated range of 4-6, while the face of a 6-year-old might have an estimated range of 4-8.</p>', 'refs' => [ 'FaceDetail$AgeRange' => '<p>The estimated age range, in years, for the face. Low represents the lowest estimated age and High represents the highest estimated age.</p>', ], ], 'Asset' => [ 'base' => '<p>Assets are the images that you use to train and evaluate a model version. Assets are referenced by Sagemaker GroundTruth manifest files. </p>', 'refs' => [ 'Assets$member' => NULL, ], ], 'Assets' => [ 'base' => NULL, 'refs' => [ 'TestingData$Assets' => '<p>The assets used for testing.</p>', 'TrainingData$Assets' => '<p>A Sagemaker GroundTruth manifest file that contains the training images (assets).</p>', ], ], 'Attribute' => [ 'base' => NULL, 'refs' => [ 'Attributes$member' => NULL, ], ], 'Attributes' => [ 'base' => NULL, 'refs' => [ 'DetectFacesRequest$Attributes' => '<p>An array of facial attributes you want to be returned. This can be the default list of attributes or all attributes. If you don\'t specify a value for <code>Attributes</code> or if you specify <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code>, and <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned, but the operation takes longer to complete.</p> <p>If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine which attributes to return (in this case, all attributes). </p>', 'IndexFacesRequest$DetectionAttributes' => '<p>An array of facial attributes that you want to be returned. This can be the default list of attributes or all attributes. If you don\'t specify a value for <code>Attributes</code> or if you specify <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code>, and <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned, but the operation takes longer to complete.</p> <p>If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine which attributes to return (in this case, all attributes). </p>', ], ], 'AudioMetadata' => [ 'base' => '<p>Metadata information about an audio stream. An array of <code>AudioMetadata</code> objects for the audio streams found in a stored video is returned by <a>GetSegmentDetection</a>. </p>', 'refs' => [ 'AudioMetadataList$member' => NULL, ], ], 'AudioMetadataList' => [ 'base' => NULL, 'refs' => [ 'GetSegmentDetectionResponse$AudioMetadata' => '<p>An array of objects. There can be multiple audio streams. Each <code>AudioMetadata</code> object contains metadata for a single audio stream. Audio information in an <code>AudioMetadata</code> objects includes the audio codec, the number of audio channels, the duration of the audio stream, and the sample rate. Audio metadata is returned in each page of information returned by <code>GetSegmentDetection</code>.</p>', ], ], 'Beard' => [ 'base' => '<p>Indicates whether or not the face has a beard, and the confidence level in the determination.</p>', 'refs' => [ 'FaceDetail$Beard' => '<p>Indicates whether or not the face has a beard, and the confidence level in the determination.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'Beard$Value' => '<p>Boolean value that indicates whether the face has beard or not.</p>', 'EyeOpen$Value' => '<p>Boolean value that indicates whether the eyes on the face are open.</p>', 'Eyeglasses$Value' => '<p>Boolean value that indicates whether the face is wearing eye glasses or not.</p>', 'MouthOpen$Value' => '<p>Boolean value that indicates whether the mouth on the face is open or not.</p>', 'Mustache$Value' => '<p>Boolean value that indicates whether the face has mustache or not.</p>', 'Smile$Value' => '<p>Boolean value that indicates whether the face is smiling or not.</p>', 'Sunglasses$Value' => '<p>Boolean value that indicates whether the face is wearing sunglasses or not.</p>', 'TestingData$AutoCreate' => '<p>If specified, Amazon Rekognition Custom Labels creates a testing dataset with an 80/20 split of the training dataset.</p>', ], ], 'BoundingBox' => [ 'base' => '<p>Identifies the bounding box around the label, face, or text. The <code>left</code> (x-coordinate) and <code>top</code> (y-coordinate) are coordinates representing the top and left sides of the bounding box. Note that the upper-left corner of the image is the origin (0,0). </p> <p>The <code>top</code> and <code>left</code> values returned are ratios of the overall image size. For example, if the input image is 700x200 pixels, and the top-left coordinate of the bounding box is 350x50 pixels, the API returns a <code>left</code> value of 0.5 (350/700) and a <code>top</code> value of 0.25 (50/200).</p> <p>The <code>width</code> and <code>height</code> values represent the dimensions of the bounding box as a ratio of the overall image dimension. For example, if the input image is 700x200 pixels, and the bounding box width is 70 pixels, the width returned is 0.1. </p> <note> <p> The bounding box coordinates can have negative values. For example, if Amazon Rekognition is able to detect a face that is at the image edge and is only partially visible, the service can return coordinates that are outside the image bounds and, depending on the image edge, you might get negative values or values greater than 1 for the <code>left</code> or <code>top</code> values. </p> </note>', 'refs' => [ 'CelebrityDetail$BoundingBox' => '<p>Bounding box around the body of a celebrity.</p>', 'ComparedFace$BoundingBox' => '<p>Bounding box of the face.</p>', 'ComparedSourceImageFace$BoundingBox' => '<p>Bounding box of the face.</p>', 'Face$BoundingBox' => '<p>Bounding box of the face.</p>', 'FaceDetail$BoundingBox' => '<p>Bounding box of the face. Default attribute.</p>', 'Geometry$BoundingBox' => '<p>An axis-aligned coarse representation of the detected item\'s location on the image.</p>', 'Instance$BoundingBox' => '<p>The position of the label instance on the image.</p>', 'PersonDetail$BoundingBox' => '<p>Bounding box around the detected person.</p>', 'RegionOfInterest$BoundingBox' => '<p>The box representing a region of interest on screen.</p>', 'SearchFacesByImageResponse$SearchedFaceBoundingBox' => '<p>The bounding box around the face in the input image that Amazon Rekognition used for the search.</p>', ], ], 'BoundingBoxHeight' => [ 'base' => NULL, 'refs' => [ 'DetectionFilter$MinBoundingBoxHeight' => '<p>Sets the minimum height of the word bounding box. Words with bounding box heights lesser than this value will be excluded from the result. Value is relative to the video frame height.</p>', ], ], 'BoundingBoxWidth' => [ 'base' => NULL, 'refs' => [ 'DetectionFilter$MinBoundingBoxWidth' => '<p>Sets the minimum width of the word bounding box. Words with bounding boxes widths lesser than this value will be excluded from the result. Value is relative to the video frame width.</p>', ], ], 'Celebrity' => [ 'base' => '<p>Provides information about a celebrity recognized by the <a>RecognizeCelebrities</a> operation.</p>', 'refs' => [ 'CelebrityList$member' => NULL, ], ], 'CelebrityDetail' => [ 'base' => '<p>Information about a recognized celebrity.</p>', 'refs' => [ 'CelebrityRecognition$Celebrity' => '<p>Information about a recognized celebrity.</p>', ], ], 'CelebrityList' => [ 'base' => NULL, 'refs' => [ 'RecognizeCelebritiesResponse$CelebrityFaces' => '<p>Details about each celebrity found in the image. Amazon Rekognition can detect a maximum of 15 celebrities in an image.</p>', ], ], 'CelebrityRecognition' => [ 'base' => '<p>Information about a detected celebrity and the time the celebrity was detected in a stored video. For more information, see GetCelebrityRecognition in the Amazon Rekognition Developer Guide.</p>', 'refs' => [ 'CelebrityRecognitions$member' => NULL, ], ], 'CelebrityRecognitionSortBy' => [ 'base' => NULL, 'refs' => [ 'GetCelebrityRecognitionRequest$SortBy' => '<p>Sort to use for celebrities returned in <code>Celebrities</code> field. Specify <code>ID</code> to sort by the celebrity identifier, specify <code>TIMESTAMP</code> to sort by the time the celebrity was recognized.</p>', ], ], 'CelebrityRecognitions' => [ 'base' => NULL, 'refs' => [ 'GetCelebrityRecognitionResponse$Celebrities' => '<p>Array of celebrities recognized in the video.</p>', ], ], 'ClientRequestToken' => [ 'base' => NULL, 'refs' => [ 'StartCelebrityRecognitionRequest$ClientRequestToken' => '<p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartCelebrityRecognition</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>', 'StartContentModerationRequest$ClientRequestToken' => '<p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartContentModeration</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>', 'StartFaceDetectionRequest$ClientRequestToken' => '<p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartFaceDetection</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>', 'StartFaceSearchRequest$ClientRequestToken' => '<p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartFaceSearch</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>', 'StartLabelDetectionRequest$ClientRequestToken' => '<p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartLabelDetection</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>', 'StartPersonTrackingRequest$ClientRequestToken' => '<p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartPersonTracking</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>', 'StartSegmentDetectionRequest$ClientRequestToken' => '<p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartSegmentDetection</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>', 'StartTextDetectionRequest$ClientRequestToken' => '<p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartTextDetection</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidentaly started more than once.</p>', ], ], 'CollectionId' => [ 'base' => NULL, 'refs' => [ 'CollectionIdList$member' => NULL, 'CreateCollectionRequest$CollectionId' => '<p>ID for the collection that you are creating.</p>', 'DeleteCollectionRequest$CollectionId' => '<p>ID of the collection to delete.</p>', 'DeleteFacesRequest$CollectionId' => '<p>Collection from which to remove the specific faces.</p>', 'DescribeCollectionRequest$CollectionId' => '<p>The ID of the collection to describe.</p>', 'FaceSearchSettings$CollectionId' => '<p>The ID of a collection that contains faces that you want to search for.</p>', 'IndexFacesRequest$CollectionId' => '<p>The ID of an existing collection to which you want to add the faces that are detected in the input images.</p>', 'ListFacesRequest$CollectionId' => '<p>ID of the collection from which to list the faces.</p>', 'SearchFacesByImageRequest$CollectionId' => '<p>ID of the collection to search.</p>', 'SearchFacesRequest$CollectionId' => '<p>ID of the collection the face belongs to.</p>', 'StartFaceSearchRequest$CollectionId' => '<p>ID of the collection that contains the faces you want to search for.</p>', ], ], 'CollectionIdList' => [ 'base' => NULL, 'refs' => [ 'ListCollectionsResponse$CollectionIds' => '<p>An array of collection IDs.</p>', ], ], 'CompareFacesMatch' => [ 'base' => '<p>Provides information about a face in a target image that matches the source image face analyzed by <code>CompareFaces</code>. The <code>Face</code> property contains the bounding box of the face in the target image. The <code>Similarity</code> property is the confidence that the source image face matches the face in the bounding box.</p>', 'refs' => [ 'CompareFacesMatchList$member' => NULL, ], ], 'CompareFacesMatchList' => [ 'base' => NULL, 'refs' => [ 'CompareFacesResponse$FaceMatches' => '<p>An array of faces in the target image that match the source image face. Each <code>CompareFacesMatch</code> object provides the bounding box, the confidence level that the bounding box contains a face, and the similarity score for the face in the bounding box and the face in the source image.</p>', ], ], 'CompareFacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'CompareFacesResponse' => [ 'base' => NULL, 'refs' => [], ], 'CompareFacesUnmatchList' => [ 'base' => NULL, 'refs' => [ 'CompareFacesResponse$UnmatchedFaces' => '<p>An array of faces in the target image that did not match the source image face.</p>', ], ], 'ComparedFace' => [ 'base' => '<p>Provides face metadata for target image faces that are analyzed by <code>CompareFaces</code> and <code>RecognizeCelebrities</code>.</p>', 'refs' => [ 'Celebrity$Face' => '<p>Provides information about the celebrity\'s face, such as its location on the image.</p>', 'CompareFacesMatch$Face' => '<p>Provides face metadata (bounding box and confidence that the bounding box actually contains a face).</p>', 'CompareFacesUnmatchList$member' => NULL, 'ComparedFaceList$member' => NULL, ], ], 'ComparedFaceList' => [ 'base' => NULL, 'refs' => [ 'RecognizeCelebritiesResponse$UnrecognizedFaces' => '<p>Details about each unrecognized face in the image.</p>', ], ], 'ComparedSourceImageFace' => [ 'base' => '<p>Type that describes the face Amazon Rekognition chose to compare with the faces in the target. This contains a bounding box for the selected face and confidence level that the bounding box contains a face. Note that Amazon Rekognition selects the largest face in the source image for this comparison. </p>', 'refs' => [ 'CompareFacesResponse$SourceImageFace' => '<p>The face in the source image that was used for comparison.</p>', ], ], 'ContentClassifier' => [ 'base' => NULL, 'refs' => [ 'ContentClassifiers$member' => NULL, ], ], 'ContentClassifiers' => [ 'base' => NULL, 'refs' => [ 'HumanLoopDataAttributes$ContentClassifiers' => '<p>Sets whether the input image is free of personally identifiable information.</p>', ], ], 'ContentModerationDetection' => [ 'base' => '<p>Information about an unsafe content label detection in a stored video.</p>', 'refs' => [ 'ContentModerationDetections$member' => NULL, ], ], 'ContentModerationDetections' => [ 'base' => NULL, 'refs' => [ 'GetContentModerationResponse$ModerationLabels' => '<p>The detected unsafe content labels and the time(s) they were detected.</p>', ], ], 'ContentModerationSortBy' => [ 'base' => NULL, 'refs' => [ 'GetContentModerationRequest$SortBy' => '<p>Sort to use for elements in the <code>ModerationLabelDetections</code> array. Use <code>TIMESTAMP</code> to sort array elements by the time labels are detected. Use <code>NAME</code> to alphabetically group elements for a label together. Within each label group, the array element are sorted by detection confidence. The default sort is by <code>TIMESTAMP</code>.</p>', ], ], 'CreateCollectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCollectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateProjectRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateProjectResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateProjectVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateProjectVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateStreamProcessorRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateStreamProcessorResponse' => [ 'base' => NULL, 'refs' => [], ], 'CustomLabel' => [ 'base' => '<p>A custom label detected in an image by a call to <a>DetectCustomLabels</a>.</p>', 'refs' => [ 'CustomLabels$member' => NULL, ], ], 'CustomLabels' => [ 'base' => NULL, 'refs' => [ 'DetectCustomLabelsResponse$CustomLabels' => '<p>An array of custom labels detected in the input image.</p>', ], ], 'DateTime' => [ 'base' => NULL, 'refs' => [ 'DescribeCollectionResponse$CreationTimestamp' => '<p>The number of milliseconds since the Unix epoch time until the creation of the collection. The Unix epoch time is 00:00:00 Coordinated Universal Time (UTC), Thursday, 1 January 1970.</p>', 'DescribeStreamProcessorResponse$CreationTimestamp' => '<p>Date and time the stream processor was created</p>', 'DescribeStreamProcessorResponse$LastUpdateTimestamp' => '<p>The time, in Unix format, the stream processor was last updated. For example, when the stream processor moves from a running state to a failed state, or when the user starts or stops the stream processor.</p>', 'ProjectDescription$CreationTimestamp' => '<p>The Unix timestamp for the date and time that the project was created.</p>', 'ProjectVersionDescription$CreationTimestamp' => '<p>The Unix datetime for the date and time that training started.</p>', 'ProjectVersionDescription$TrainingEndTimestamp' => '<p>The Unix date and time that training of the model ended.</p>', ], ], 'Degree' => [ 'base' => NULL, 'refs' => [ 'Pose$Roll' => '<p>Value representing the face rotation on the roll axis.</p>', 'Pose$Yaw' => '<p>Value representing the face rotation on the yaw axis.</p>', 'Pose$Pitch' => '<p>Value representing the face rotation on the pitch axis.</p>', ], ], 'DeleteCollectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCollectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFacesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProjectRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProjectResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProjectVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProjectVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStreamProcessorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStreamProcessorResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCollectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCollectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProjectVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProjectVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProjectsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProjectsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStreamProcessorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStreamProcessorResponse' => [ 'base' => NULL, 'refs' => [], ], 'DetectCustomLabelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetectCustomLabelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DetectFacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetectFacesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DetectLabelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetectLabelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DetectModerationLabelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetectModerationLabelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DetectTextFilters' => [ 'base' => '<p>A set of optional parameters that you can use to set the criteria that the text must meet to be included in your response. <code>WordFilter</code> looks at a word’s height, width, and minimum confidence. <code>RegionOfInterest</code> lets you set a specific region of the image to look for text in. </p>', 'refs' => [ 'DetectTextRequest$Filters' => '<p>Optional parameters that let you set the criteria that the text must meet to be included in your response.</p>', ], ], 'DetectTextRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetectTextResponse' => [ 'base' => NULL, 'refs' => [], ], 'DetectionFilter' => [ 'base' => '<p>A set of parameters that allow you to filter out certain results from your returned results.</p>', 'refs' => [ 'DetectTextFilters$WordFilter' => NULL, 'StartTextDetectionFilters$WordFilter' => '<p>Filters focusing on qualities of the text, such as confidence or size.</p>', ], ], 'Emotion' => [ 'base' => '<p>The emotions that appear to be expressed on the face, and the confidence level in the determination. The API is only making a determination of the physical appearance of a person\'s face. It is not a determination of the person’s internal emotional state and should not be used in such a way. For example, a person pretending to have a sad face might not be sad emotionally.</p>', 'refs' => [ 'Emotions$member' => NULL, ], ], 'EmotionName' => [ 'base' => NULL, 'refs' => [ 'Emotion$Type' => '<p>Type of emotion detected.</p>', ], ], 'Emotions' => [ 'base' => NULL, 'refs' => [ 'FaceDetail$Emotions' => '<p>The emotions that appear to be expressed on the face, and the confidence level in the determination. The API is only making a determination of the physical appearance of a person\'s face. It is not a determination of the person’s internal emotional state and should not be used in such a way. For example, a person pretending to have a sad face might not be sad emotionally.</p>', ], ], 'EvaluationResult' => [ 'base' => '<p>The evaluation results for the training of a model.</p>', 'refs' => [ 'ProjectVersionDescription$EvaluationResult' => '<p>The training results. <code>EvaluationResult</code> is only returned if training is successful.</p>', ], ], 'ExtendedPaginationToken' => [ 'base' => NULL, 'refs' => [ 'DescribeProjectVersionsRequest$NextToken' => '<p>If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>', 'DescribeProjectVersionsResponse$NextToken' => '<p>If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>', 'DescribeProjectsRequest$NextToken' => '<p>If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>', 'DescribeProjectsResponse$NextToken' => '<p>If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>', ], ], 'ExternalImageId' => [ 'base' => NULL, 'refs' => [ 'Face$ExternalImageId' => '<p>Identifier that you assign to all the faces in the input image.</p>', 'IndexFacesRequest$ExternalImageId' => '<p>The ID you want to assign to all the faces detected in the image.</p>', ], ], 'EyeOpen' => [ 'base' => '<p>Indicates whether or not the eyes on the face are open, and the confidence level in the determination.</p>', 'refs' => [ 'FaceDetail$EyesOpen' => '<p>Indicates whether or not the eyes on the face are open, and the confidence level in the determination.</p>', ], ], 'Eyeglasses' => [ 'base' => '<p>Indicates whether or not the face is wearing eye glasses, and the confidence level in the determination.</p>', 'refs' => [ 'FaceDetail$Eyeglasses' => '<p>Indicates whether or not the face is wearing eye glasses, and the confidence level in the determination.</p>', ], ], 'Face' => [ 'base' => '<p>Describes the face properties such as the bounding box, face ID, image ID of the input image, and external image ID that you assigned. </p>', 'refs' => [ 'FaceList$member' => NULL, 'FaceMatch$Face' => '<p>Describes the face properties such as the bounding box, face ID, image ID of the source image, and external image ID that you assigned.</p>', 'FaceRecord$Face' => '<p>Describes the face properties such as the bounding box, face ID, image ID of the input image, and external image ID that you assigned. </p>', ], ], 'FaceAttributes' => [ 'base' => NULL, 'refs' => [ 'StartFaceDetectionRequest$FaceAttributes' => '<p>The face attributes you want returned.</p> <p> <code>DEFAULT</code> - The following subset of facial attributes are returned: BoundingBox, Confidence, Pose, Quality and Landmarks. </p> <p> <code>ALL</code> - All facial attributes are returned.</p>', ], ], 'FaceDetail' => [ 'base' => '<p>Structure containing attributes of the face that the algorithm detected.</p> <p>A <code>FaceDetail</code> object contains either the default facial attributes or all facial attributes. The default attributes are <code>BoundingBox</code>, <code>Confidence</code>, <code>Landmarks</code>, <code>Pose</code>, and <code>Quality</code>.</p> <p> <a>GetFaceDetection</a> is the only Amazon Rekognition Video stored video operation that can return a <code>FaceDetail</code> object with all attributes. To specify which attributes to return, use the <code>FaceAttributes</code> input parameter for <a>StartFaceDetection</a>. The following Amazon Rekognition Video operations return only the default attributes. The corresponding Start operations don\'t have a <code>FaceAttributes</code> input parameter.</p> <ul> <li> <p>GetCelebrityRecognition</p> </li> <li> <p>GetPersonTracking</p> </li> <li> <p>GetFaceSearch</p> </li> </ul> <p>The Amazon Rekognition Image <a>DetectFaces</a> and <a>IndexFaces</a> operations can return all facial attributes. To specify which attributes to return, use the <code>Attributes</code> input parameter for <code>DetectFaces</code>. For <code>IndexFaces</code>, use the <code>DetectAttributes</code> input parameter.</p>', 'refs' => [ 'CelebrityDetail$Face' => '<p>Face details for the recognized celebrity.</p>', 'FaceDetailList$member' => NULL, 'FaceDetection$Face' => '<p>The face properties for the detected face.</p>', 'FaceRecord$FaceDetail' => '<p>Structure containing attributes of the face that the algorithm detected.</p>', 'PersonDetail$Face' => '<p>Face details for the detected person.</p>', 'UnindexedFace$FaceDetail' => '<p>The structure that contains attributes of a face that <code>IndexFaces</code>detected, but didn\'t index. </p>', ], ], 'FaceDetailList' => [ 'base' => NULL, 'refs' => [ 'DetectFacesResponse$FaceDetails' => '<p>Details of each face found in the image. </p>', ], ], 'FaceDetection' => [ 'base' => '<p>Information about a face detected in a video analysis request and the time the face was detected in the video. </p>', 'refs' => [ 'FaceDetections$member' => NULL, ], ], 'FaceDetections' => [ 'base' => NULL, 'refs' => [ 'GetFaceDetectionResponse$Faces' => '<p>An array of faces detected in the video. Each element contains a detected face\'s details and the time, in milliseconds from the start of the video, the face was detected. </p>', ], ], 'FaceId' => [ 'base' => NULL, 'refs' => [ 'Face$FaceId' => '<p>Unique identifier that Amazon Rekognition assigns to the face.</p>', 'FaceIdList$member' => NULL, 'SearchFacesRequest$FaceId' => '<p>ID of a face to find matches for in the collection.</p>', 'SearchFacesResponse$SearchedFaceId' => '<p>ID of the face that was searched for matches in a collection.</p>', ], ], 'FaceIdList' => [ 'base' => NULL, 'refs' => [ 'DeleteFacesRequest$FaceIds' => '<p>An array of face IDs to delete.</p>', 'DeleteFacesResponse$DeletedFaces' => '<p>An array of strings (face IDs) of the faces that were deleted.</p>', ], ], 'FaceList' => [ 'base' => NULL, 'refs' => [ 'ListFacesResponse$Faces' => '<p>An array of <code>Face</code> objects. </p>', ], ], 'FaceMatch' => [ 'base' => '<p>Provides face metadata. In addition, it also provides the confidence in the match of this face with the input face.</p>', 'refs' => [ 'FaceMatchList$member' => NULL, ], ], 'FaceMatchList' => [ 'base' => NULL, 'refs' => [ 'PersonMatch$FaceMatches' => '<p>Information about the faces in the input collection that match the face of a person in the video.</p>', 'SearchFacesByImageResponse$FaceMatches' => '<p>An array of faces that match the input face, along with the confidence in the match.</p>', 'SearchFacesResponse$FaceMatches' => '<p>An array of faces that matched the input face, along with the confidence in the match.</p>', ], ], 'FaceModelVersionList' => [ 'base' => NULL, 'refs' => [ 'ListCollectionsResponse$FaceModelVersions' => '<p>Version numbers of the face detection models associated with the collections in the array <code>CollectionIds</code>. For example, the value of <code>FaceModelVersions[2]</code> is the version number for the face detection model used by the collection in <code>CollectionId[2]</code>.</p>', ], ], 'FaceRecord' => [ 'base' => '<p>Object containing both the face metadata (stored in the backend database), and facial attributes that are detected but aren\'t stored in the database.</p>', 'refs' => [ 'FaceRecordList$member' => NULL, ], ], 'FaceRecordList' => [ 'base' => NULL, 'refs' => [ 'IndexFacesResponse$FaceRecords' => '<p>An array of faces detected and added to the collection. For more information, see Searching Faces in a Collection in the Amazon Rekognition Developer Guide. </p>', ], ], 'FaceSearchSettings' => [ 'base' => '<p>Input face recognition parameters for an Amazon Rekognition stream processor. <code>FaceRecognitionSettings</code> is a request parameter for <a>CreateStreamProcessor</a>.</p>', 'refs' => [ 'StreamProcessorSettings$FaceSearch' => '<p>Face search settings to use on a streaming video. </p>', ], ], 'FaceSearchSortBy' => [ 'base' => NULL, 'refs' => [ 'GetFaceSearchRequest$SortBy' => '<p>Sort to use for grouping faces in the response. Use <code>TIMESTAMP</code> to group faces by the time that they are recognized. Use <code>INDEX</code> to sort by recognized faces. </p>', ], ], 'Float' => [ 'base' => NULL, 'refs' => [ 'BoundingBox$Width' => '<p>Width of the bounding box as a ratio of the overall image width.</p>', 'BoundingBox$Height' => '<p>Height of the bounding box as a ratio of the overall image height.</p>', 'BoundingBox$Left' => '<p>Left coordinate of the bounding box as a ratio of overall image width.</p>', 'BoundingBox$Top' => '<p>Top coordinate of the bounding box as a ratio of overall image height.</p>', 'EvaluationResult$F1Score' => '<p>The F1 score for the evaluation of all labels. The F1 score metric evaluates the overall precision and recall performance of the model as a single value. A higher value indicates better precision and recall performance. A lower score indicates that precision, recall, or both are performing poorly. </p>', 'ImageQuality$Brightness' => '<p>Value representing brightness of the face. The service returns a value between 0 and 100 (inclusive). A higher value indicates a brighter face image.</p>', 'ImageQuality$Sharpness' => '<p>Value representing sharpness of the face. The service returns a value between 0 and 100 (inclusive). A higher value indicates a sharper face image.</p>', 'Landmark$X' => '<p>The x-coordinate from the top left of the landmark expressed as the ratio of the width of the image. For example, if the image is 700 x 200 and the x-coordinate of the landmark is at 350 pixels, this value is 0.5. </p>', 'Landmark$Y' => '<p>The y-coordinate from the top left of the landmark expressed as the ratio of the height of the image. For example, if the image is 700 x 200 and the y-coordinate of the landmark is at 100 pixels, this value is 0.5.</p>', 'Point$X' => '<p>The value of the X coordinate for a point on a <code>Polygon</code>.</p>', 'Point$Y' => '<p>The value of the Y coordinate for a point on a <code>Polygon</code>.</p>', 'VideoMetadata$FrameRate' => '<p>Number of frames per second in the video.</p>', ], ], 'FlowDefinitionArn' => [ 'base' => NULL, 'refs' => [ 'HumanLoopConfig$FlowDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the flow definition. You can create a flow definition by using the Amazon Sagemaker <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateFlowDefinition.html">CreateFlowDefinition</a> Operation. </p>', ], ], 'Gender' => [ 'base' => '<p>The predicted gender of a detected face. </p> <p>Amazon Rekognition makes gender binary (male/female) predictions based on the physical appearance of a face in a particular image. This kind of prediction is not designed to categorize a person’s gender identity, and you shouldn\'t use Amazon Rekognition to make such a determination. For example, a male actor wearing a long-haired wig and earrings for a role might be predicted as female.</p> <p>Using Amazon Rekognition to make gender binary predictions is best suited for use cases where aggregate gender distribution statistics need to be analyzed without identifying specific users. For example, the percentage of female users compared to male users on a social media platform. </p> <p>We don\'t recommend using gender binary predictions to make decisions that impact&#x2028; an individual\'s rights, privacy, or access to services.</p>', 'refs' => [ 'FaceDetail$Gender' => '<p>The predicted gender of a detected face. </p>', ], ], 'GenderType' => [ 'base' => NULL, 'refs' => [ 'Gender$Value' => '<p>The predicted gender of the face.</p>', ], ], 'Geometry' => [ 'base' => '<p>Information about where an object (<a>DetectCustomLabels</a>) or text (<a>DetectText</a>) is located on an image.</p>', 'refs' => [ 'CustomLabel$Geometry' => '<p>The location of the detected object on the image that corresponds to the custom label. Includes an axis aligned coarse bounding box surrounding the object and a finer grain polygon for more accurate spatial information.</p>', 'TextDetection$Geometry' => '<p>The location of the detected text on the image. Includes an axis aligned coarse bounding box surrounding the text and a finer grain polygon for more accurate spatial information.</p>', ], ], 'GetCelebrityInfoRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCelebrityInfoResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCelebrityRecognitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCelebrityRecognitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetContentModerationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetContentModerationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFaceDetectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFaceDetectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFaceSearchRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFaceSearchResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLabelDetectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLabelDetectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPersonTrackingRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPersonTrackingResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSegmentDetectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSegmentDetectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTextDetectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTextDetectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GroundTruthManifest' => [ 'base' => '<p>The S3 bucket that contains the Ground Truth manifest file.</p>', 'refs' => [ 'Asset$GroundTruthManifest' => NULL, ], ], 'HumanLoopActivationConditionsEvaluationResults' => [ 'base' => NULL, 'refs' => [ 'HumanLoopActivationOutput$HumanLoopActivationConditionsEvaluationResults' => '<p>Shows the result of condition evaluations, including those conditions which activated a human review.</p>', ], ], 'HumanLoopActivationOutput' => [ 'base' => '<p>Shows the results of the human in the loop evaluation. If there is no HumanLoopArn, the input did not trigger human review.</p>', 'refs' => [ 'DetectModerationLabelsResponse$HumanLoopActivationOutput' => '<p>Shows the results of the human in the loop evaluation.</p>', ], ], 'HumanLoopActivationReason' => [ 'base' => NULL, 'refs' => [ 'HumanLoopActivationReasons$member' => NULL, ], ], 'HumanLoopActivationReasons' => [ 'base' => NULL, 'refs' => [ 'HumanLoopActivationOutput$HumanLoopActivationReasons' => '<p>Shows if and why human review was needed.</p>', ], ], 'HumanLoopArn' => [ 'base' => NULL, 'refs' => [ 'HumanLoopActivationOutput$HumanLoopArn' => '<p>The Amazon Resource Name (ARN) of the HumanLoop created.</p>', ], ], 'HumanLoopConfig' => [ 'base' => '<p>Sets up the flow definition the image will be sent to if one of the conditions is met. You can also set certain attributes of the image before review.</p>', 'refs' => [ 'DetectModerationLabelsRequest$HumanLoopConfig' => '<p>Sets up the configuration for human evaluation, including the FlowDefinition the image will be sent to.</p>', ], ], 'HumanLoopDataAttributes' => [ 'base' => '<p>Allows you to set attributes of the image. Currently, you can declare an image as free of personally identifiable information.</p>', 'refs' => [ 'HumanLoopConfig$DataAttributes' => '<p>Sets attributes of the input data.</p>', ], ], 'HumanLoopName' => [ 'base' => NULL, 'refs' => [ 'HumanLoopConfig$HumanLoopName' => '<p>The name of the human review used for this image. This should be kept unique within a region.</p>', ], ], 'HumanLoopQuotaExceededException' => [ 'base' => '<p>The number of in-progress human reviews you have has exceeded the number allowed.</p>', 'refs' => [], ], 'IdempotentParameterMismatchException' => [ 'base' => '<p>A <code>ClientRequestToken</code> input parameter was reused with an operation, but at least one of the other input parameters is different from the previous call to the operation.</p>', 'refs' => [], ], 'Image' => [ 'base' => '<p>Provides the input image either as bytes or an S3 object.</p> <p>You pass image bytes to an Amazon Rekognition API operation by using the <code>Bytes</code> property. For example, you would use the <code>Bytes</code> property to pass an image loaded from a local file system. Image bytes passed by using the <code>Bytes</code> property must be base64-encoded. Your code may not need to encode image bytes if you are using an AWS SDK to call Amazon Rekognition API operations. </p> <p>For more information, see Analyzing an Image Loaded from a Local File System in the Amazon Rekognition Developer Guide.</p> <p> You pass images stored in an S3 bucket to an Amazon Rekognition API operation by using the <code>S3Object</code> property. Images stored in an S3 bucket do not need to be base64-encoded.</p> <p>The region for the S3 bucket containing the S3 object must match the region you use for Amazon Rekognition operations.</p> <p>If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes using the Bytes property is not supported. You must first upload the image to an Amazon S3 bucket and then call the operation using the S3Object property.</p> <p>For Amazon Rekognition to process an S3 object, the user must have permission to access the S3 object. For more information, see Resource Based Policies in the Amazon Rekognition Developer Guide. </p>', 'refs' => [ 'CompareFacesRequest$SourceImage' => '<p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported. </p> <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>', 'CompareFacesRequest$TargetImage' => '<p>The target image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported. </p> <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>', 'DetectCustomLabelsRequest$Image' => NULL, 'DetectFacesRequest$Image' => '<p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported. </p> <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>', 'DetectLabelsRequest$Image' => '<p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. Images stored in an S3 Bucket do not need to be base64-encoded.</p> <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>', 'DetectModerationLabelsRequest$Image' => '<p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported. </p> <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>', 'DetectTextRequest$Image' => '<p>The input image as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI to call Amazon Rekognition operations, you can\'t pass image bytes. </p> <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>', 'IndexFacesRequest$Image' => '<p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes isn\'t supported. </p> <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>', 'RecognizeCelebritiesRequest$Image' => '<p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported. </p> <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>', 'SearchFacesByImageRequest$Image' => '<p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported. </p> <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>', ], ], 'ImageBlob' => [ 'base' => NULL, 'refs' => [ 'Image$Bytes' => '<p>Blob of image bytes up to 5 MBs.</p>', ], ], 'ImageId' => [ 'base' => NULL, 'refs' => [ 'Face$ImageId' => '<p>Unique identifier that Amazon Rekognition assigns to the input image.</p>', ], ], 'ImageQuality' => [ 'base' => '<p>Identifies face image brightness and sharpness. </p>', 'refs' => [ 'ComparedFace$Quality' => '<p>Identifies face image brightness and sharpness. </p>', 'FaceDetail$Quality' => '<p>Identifies image brightness and sharpness. Default attribute.</p>', ], ], 'ImageTooLargeException' => [ 'base' => '<p>The input image size exceeds the allowed limit. For more information, see Limits in Amazon Rekognition in the Amazon Rekognition Developer Guide. </p>', 'refs' => [], ], 'IndexFacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'IndexFacesResponse' => [ 'base' => NULL, 'refs' => [], ], 'InferenceUnits' => [ 'base' => NULL, 'refs' => [ 'ProjectVersionDescription$MinInferenceUnits' => '<p>The minimum number of inference units used by the model. For more information, see <a>StartProjectVersion</a>.</p>', 'StartProjectVersionRequest$MinInferenceUnits' => '<p>The minimum number of inference units to use. A single inference unit represents 1 hour of processing and can support up to 5 Transaction Pers Second (TPS). Use a higher number to increase the TPS throughput of your model. You are charged for the number of inference units that you use. </p>', ], ], 'Instance' => [ 'base' => '<p>An instance of a label returned by Amazon Rekognition Image (<a>DetectLabels</a>) or by Amazon Rekognition Video (<a>GetLabelDetection</a>).</p>', 'refs' => [ 'Instances$member' => NULL, ], ], 'Instances' => [ 'base' => NULL, 'refs' => [ 'Label$Instances' => '<p>If <code>Label</code> represents an object, <code>Instances</code> contains the bounding boxes for each instance of the detected object. Bounding boxes are returned for common object labels such as people, cars, furniture, apparel or pets.</p>', ], ], 'InternalServerError' => [ 'base' => '<p>Amazon Rekognition experienced a service issue. Try your call again.</p>', 'refs' => [], ], 'InvalidImageFormatException' => [ 'base' => '<p>The provided image format is not supported. </p>', 'refs' => [], ], 'InvalidPaginationTokenException' => [ 'base' => '<p>Pagination token in the request is not valid.</p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => '<p>Input parameter violated a constraint. Validate your parameter before calling the API operation again.</p>', 'refs' => [], ], 'InvalidS3ObjectException' => [ 'base' => '<p>Amazon Rekognition is unable to access the S3 object specified in the request.</p>', 'refs' => [], ], 'JobId' => [ 'base' => NULL, 'refs' => [ 'GetCelebrityRecognitionRequest$JobId' => '<p>Job identifier for the required celebrity recognition analysis. You can get the job identifer from a call to <code>StartCelebrityRecognition</code>.</p>', 'GetContentModerationRequest$JobId' => '<p>The identifier for the unsafe content job. Use <code>JobId</code> to identify the job in a subsequent call to <code>GetContentModeration</code>.</p>', 'GetFaceDetectionRequest$JobId' => '<p>Unique identifier for the face detection job. The <code>JobId</code> is returned from <code>StartFaceDetection</code>.</p>', 'GetFaceSearchRequest$JobId' => '<p>The job identifer for the search request. You get the job identifier from an initial call to <code>StartFaceSearch</code>.</p>', 'GetLabelDetectionRequest$JobId' => '<p>Job identifier for the label detection operation for which you want results returned. You get the job identifer from an initial call to <code>StartlabelDetection</code>.</p>', 'GetPersonTrackingRequest$JobId' => '<p>The identifier for a job that tracks persons in a video. You get the <code>JobId</code> from a call to <code>StartPersonTracking</code>. </p>', 'GetSegmentDetectionRequest$JobId' => '<p>Job identifier for the text detection operation for which you want results returned. You get the job identifer from an initial call to <code>StartSegmentDetection</code>.</p>', 'GetTextDetectionRequest$JobId' => '<p>Job identifier for the text detection operation for which you want results returned. You get the job identifer from an initial call to <code>StartTextDetection</code>.</p>', 'StartCelebrityRecognitionResponse$JobId' => '<p>The identifier for the celebrity recognition analysis job. Use <code>JobId</code> to identify the job in a subsequent call to <code>GetCelebrityRecognition</code>.</p>', 'StartContentModerationResponse$JobId' => '<p>The identifier for the unsafe content analysis job. Use <code>JobId</code> to identify the job in a subsequent call to <code>GetContentModeration</code>.</p>', 'StartFaceDetectionResponse$JobId' => '<p>The identifier for the face detection job. Use <code>JobId</code> to identify the job in a subsequent call to <code>GetFaceDetection</code>.</p>', 'StartFaceSearchResponse$JobId' => '<p>The identifier for the search job. Use <code>JobId</code> to identify the job in a subsequent call to <code>GetFaceSearch</code>. </p>', 'StartLabelDetectionResponse$JobId' => '<p>The identifier for the label detection job. Use <code>JobId</code> to identify the job in a subsequent call to <code>GetLabelDetection</code>. </p>', 'StartPersonTrackingResponse$JobId' => '<p>The identifier for the person detection job. Use <code>JobId</code> to identify the job in a subsequent call to <code>GetPersonTracking</code>.</p>', 'StartSegmentDetectionResponse$JobId' => '<p>Unique identifier for the segment detection job. The <code>JobId</code> is returned from <code>StartSegmentDetection</code>. </p>', 'StartTextDetectionResponse$JobId' => '<p>Identifier for the text detection job. Use <code>JobId</code> to identify the job in a subsequent call to <code>GetTextDetection</code>.</p>', ], ], 'JobTag' => [ 'base' => NULL, 'refs' => [ 'StartCelebrityRecognitionRequest$JobTag' => '<p>An identifier you specify that\'s returned in the completion notification that\'s published to your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>', 'StartContentModerationRequest$JobTag' => '<p>An identifier you specify that\'s returned in the completion notification that\'s published to your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>', 'StartFaceDetectionRequest$JobTag' => '<p>An identifier you specify that\'s returned in the completion notification that\'s published to your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>', 'StartFaceSearchRequest$JobTag' => '<p>An identifier you specify that\'s returned in the completion notification that\'s published to your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>', 'StartLabelDetectionRequest$JobTag' => '<p>An identifier you specify that\'s returned in the completion notification that\'s published to your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>', 'StartPersonTrackingRequest$JobTag' => '<p>An identifier you specify that\'s returned in the completion notification that\'s published to your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>', 'StartSegmentDetectionRequest$JobTag' => '<p>An identifier you specify that\'s returned in the completion notification that\'s published to your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>', 'StartTextDetectionRequest$JobTag' => '<p>An identifier returned in the completion status published by your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>', ], ], 'KinesisDataArn' => [ 'base' => NULL, 'refs' => [ 'KinesisDataStream$Arn' => '<p>ARN of the output Amazon Kinesis Data Streams stream.</p>', ], ], 'KinesisDataStream' => [ 'base' => '<p>The Kinesis data stream Amazon Rekognition to which the analysis results of a Amazon Rekognition stream processor are streamed. For more information, see CreateStreamProcessor in the Amazon Rekognition Developer Guide.</p>', 'refs' => [ 'StreamProcessorOutput$KinesisDataStream' => '<p>The Amazon Kinesis Data Streams stream to which the Amazon Rekognition stream processor streams the analysis results.</p>', ], ], 'KinesisVideoArn' => [ 'base' => NULL, 'refs' => [ 'KinesisVideoStream$Arn' => '<p>ARN of the Kinesis video stream stream that streams the source video.</p>', ], ], 'KinesisVideoStream' => [ 'base' => '<p>Kinesis video stream stream that provides the source streaming video for a Amazon Rekognition Video stream processor. For more information, see CreateStreamProcessor in the Amazon Rekognition Developer Guide.</p>', 'refs' => [ 'StreamProcessorInput$KinesisVideoStream' => '<p>The Kinesis video stream input stream for the source streaming video.</p>', ], ], 'Label' => [ 'base' => '<p>Structure containing details about the detected label, including the name, detected instances, parent labels, and level of confidence.</p> <p> </p>', 'refs' => [ 'LabelDetection$Label' => '<p>Details about the detected label.</p>', 'Labels$member' => NULL, ], ], 'LabelDetection' => [ 'base' => '<p>Information about a label detected in a video analysis request and the time the label was detected in the video. </p>', 'refs' => [ 'LabelDetections$member' => NULL, ], ], 'LabelDetectionSortBy' => [ 'base' => NULL, 'refs' => [ 'GetLabelDetectionRequest$SortBy' => '<p>Sort to use for elements in the <code>Labels</code> array. Use <code>TIMESTAMP</code> to sort array elements by the time labels are detected. Use <code>NAME</code> to alphabetically group elements for a label together. Within each label group, the array element are sorted by detection confidence. The default sort is by <code>TIMESTAMP</code>.</p>', ], ], 'LabelDetections' => [ 'base' => NULL, 'refs' => [ 'GetLabelDetectionResponse$Labels' => '<p>An array of labels detected in the video. Each element contains the detected label and the time, in milliseconds from the start of the video, that the label was detected. </p>', ], ], 'Labels' => [ 'base' => NULL, 'refs' => [ 'DetectLabelsResponse$Labels' => '<p>An array of labels for the real-world objects detected. </p>', ], ], 'Landmark' => [ 'base' => '<p>Indicates the location of the landmark on the face.</p>', 'refs' => [ 'Landmarks$member' => NULL, ], ], 'LandmarkType' => [ 'base' => NULL, 'refs' => [ 'Landmark$Type' => '<p>Type of landmark.</p>', ], ], 'Landmarks' => [ 'base' => NULL, 'refs' => [ 'ComparedFace$Landmarks' => '<p>An array of facial landmarks.</p>', 'FaceDetail$Landmarks' => '<p>Indicates the location of landmarks on the face. Default attribute.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>An Amazon Rekognition service limit was exceeded. For example, if you start too many Amazon Rekognition Video jobs concurrently, calls to start operations (<code>StartLabelDetection</code>, for example) will raise a <code>LimitExceededException</code> exception (HTTP status code: 400) until the number of concurrently running jobs is below the Amazon Rekognition service limit. </p>', 'refs' => [], ], 'ListCollectionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCollectionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFacesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamProcessorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamProcessorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxFaces' => [ 'base' => NULL, 'refs' => [ 'SearchFacesByImageRequest$MaxFaces' => '<p>Maximum number of faces to return. The operation returns the maximum number of faces with the highest confidence in the match.</p>', 'SearchFacesRequest$MaxFaces' => '<p>Maximum number of faces to return. The operation returns the maximum number of faces with the highest confidence in the match.</p>', ], ], 'MaxFacesToIndex' => [ 'base' => NULL, 'refs' => [ 'IndexFacesRequest$MaxFaces' => '<p>The maximum number of faces to index. The value of <code>MaxFaces</code> must be greater than or equal to 1. <code>IndexFaces</code> returns no more than 100 detected faces in an image, even if you specify a larger value for <code>MaxFaces</code>.</p> <p>If <code>IndexFaces</code> detects more faces than the value of <code>MaxFaces</code>, the faces with the lowest quality are filtered out first. If there are still more faces than the value of <code>MaxFaces</code>, the faces with the smallest bounding boxes are filtered out (up to the number that\'s needed to satisfy the value of <code>MaxFaces</code>). Information about the unindexed faces is available in the <code>UnindexedFaces</code> array. </p> <p>The faces that are returned by <code>IndexFaces</code> are sorted by the largest face bounding box size to the smallest size, in descending order.</p> <p> <code>MaxFaces</code> can be used with a collection associated with any version of the face model.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'GetCelebrityRecognitionRequest$MaxResults' => '<p>Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.</p>', 'GetContentModerationRequest$MaxResults' => '<p>Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.</p>', 'GetFaceDetectionRequest$MaxResults' => '<p>Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.</p>', 'GetFaceSearchRequest$MaxResults' => '<p>Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.</p>', 'GetLabelDetectionRequest$MaxResults' => '<p>Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.</p>', 'GetPersonTrackingRequest$MaxResults' => '<p>Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.</p>', 'GetSegmentDetectionRequest$MaxResults' => '<p>Maximum number of results to return per paginated call. The largest value you can specify is 1000.</p>', 'GetTextDetectionRequest$MaxResults' => '<p>Maximum number of results to return per paginated call. The largest value you can specify is 1000.</p>', 'ListStreamProcessorsRequest$MaxResults' => '<p>Maximum number of stream processors you want Amazon Rekognition Video to return in the response. The default is 1000. </p>', ], ], 'ModerationLabel' => [ 'base' => '<p>Provides information about a single type of unsafe content found in an image or video. Each type of moderated content has a label within a hierarchical taxonomy. For more information, see Detecting Unsafe Content in the Amazon Rekognition Developer Guide.</p>', 'refs' => [ 'ContentModerationDetection$ModerationLabel' => '<p>The unsafe content label detected by in the stored video.</p>', 'ModerationLabels$member' => NULL, ], ], 'ModerationLabels' => [ 'base' => NULL, 'refs' => [ 'DetectModerationLabelsResponse$ModerationLabels' => '<p>Array of detected Moderation labels and the time, in milliseconds from the start of the video, they were detected.</p>', ], ], 'MouthOpen' => [ 'base' => '<p>Indicates whether or not the mouth on the face is open, and the confidence level in the determination.</p>', 'refs' => [ 'FaceDetail$MouthOpen' => '<p>Indicates whether or not the mouth on the face is open, and the confidence level in the determination.</p>', ], ], 'Mustache' => [ 'base' => '<p>Indicates whether or not the face has a mustache, and the confidence level in the determination.</p>', 'refs' => [ 'FaceDetail$Mustache' => '<p>Indicates whether or not the face has a mustache, and the confidence level in the determination.</p>', ], ], 'NotificationChannel' => [ 'base' => '<p>The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the completion status of a video analysis operation. For more information, see <a>api-video</a>.</p>', 'refs' => [ 'StartCelebrityRecognitionRequest$NotificationChannel' => '<p>The Amazon SNS topic ARN that you want Amazon Rekognition Video to publish the completion status of the celebrity recognition analysis to.</p>', 'StartContentModerationRequest$NotificationChannel' => '<p>The Amazon SNS topic ARN that you want Amazon Rekognition Video to publish the completion status of the unsafe content analysis to.</p>', 'StartFaceDetectionRequest$NotificationChannel' => '<p>The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion status of the face detection operation.</p>', 'StartFaceSearchRequest$NotificationChannel' => '<p>The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion status of the search. </p>', 'StartLabelDetectionRequest$NotificationChannel' => '<p>The Amazon SNS topic ARN you want Amazon Rekognition Video to publish the completion status of the label detection operation to. </p>', 'StartPersonTrackingRequest$NotificationChannel' => '<p>The Amazon SNS topic ARN you want Amazon Rekognition Video to publish the completion status of the people detection operation to.</p>', 'StartSegmentDetectionRequest$NotificationChannel' => '<p>The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion status of the segment detection operation.</p>', 'StartTextDetectionRequest$NotificationChannel' => NULL, ], ], 'OrientationCorrection' => [ 'base' => NULL, 'refs' => [ 'CompareFacesResponse$SourceImageOrientationCorrection' => '<p>The value of <code>SourceImageOrientationCorrection</code> is always null.</p> <p>If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that includes the image\'s orientation. Amazon Rekognition uses this orientation information to perform image correction. The bounding box coordinates are translated to represent object locations after the orientation information in the Exif metadata is used to correct the image orientation. Images in .png format don\'t contain Exif metadata.</p> <p>Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without orientation information in the image Exif metadata. The bounding box coordinates aren\'t translated and represent the object locations before the image is rotated. </p>', 'CompareFacesResponse$TargetImageOrientationCorrection' => '<p>The value of <code>TargetImageOrientationCorrection</code> is always null.</p> <p>If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that includes the image\'s orientation. Amazon Rekognition uses this orientation information to perform image correction. The bounding box coordinates are translated to represent object locations after the orientation information in the Exif metadata is used to correct the image orientation. Images in .png format don\'t contain Exif metadata.</p> <p>Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without orientation information in the image Exif metadata. The bounding box coordinates aren\'t translated and represent the object locations before the image is rotated. </p>', 'DetectFacesResponse$OrientationCorrection' => '<p>The value of <code>OrientationCorrection</code> is always null.</p> <p>If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that includes the image\'s orientation. Amazon Rekognition uses this orientation information to perform image correction. The bounding box coordinates are translated to represent object locations after the orientation information in the Exif metadata is used to correct the image orientation. Images in .png format don\'t contain Exif metadata.</p> <p>Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without orientation information in the image Exif metadata. The bounding box coordinates aren\'t translated and represent the object locations before the image is rotated. </p>', 'DetectLabelsResponse$OrientationCorrection' => '<p>The value of <code>OrientationCorrection</code> is always null.</p> <p>If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that includes the image\'s orientation. Amazon Rekognition uses this orientation information to perform image correction. The bounding box coordinates are translated to represent object locations after the orientation information in the Exif metadata is used to correct the image orientation. Images in .png format don\'t contain Exif metadata.</p> <p>Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without orientation information in the image Exif metadata. The bounding box coordinates aren\'t translated and represent the object locations before the image is rotated. </p>', 'IndexFacesResponse$OrientationCorrection' => '<p>If your collection is associated with a face detection model that\'s later than version 3.0, the value of <code>OrientationCorrection</code> is always null and no orientation information is returned.</p> <p>If your collection is associated with a face detection model that\'s version 3.0 or earlier, the following applies:</p> <ul> <li> <p>If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that includes the image\'s orientation. Amazon Rekognition uses this orientation information to perform image correction - the bounding box coordinates are translated to represent object locations after the orientation information in the Exif metadata is used to correct the image orientation. Images in .png format don\'t contain Exif metadata. The value of <code>OrientationCorrection</code> is null.</p> </li> <li> <p>If the image doesn\'t contain orientation information in its Exif metadata, Amazon Rekognition returns an estimated orientation (ROTATE_0, ROTATE_90, ROTATE_180, ROTATE_270). Amazon Rekognition doesn’t perform image correction for images. The bounding box coordinates aren\'t translated and represent the object locations before the image is rotated.</p> </li> </ul> <p>Bounding box information is returned in the <code>FaceRecords</code> array. You can get the version of the face detection model by calling <a>DescribeCollection</a>. </p>', 'RecognizeCelebritiesResponse$OrientationCorrection' => '<p>The orientation of the input image (counterclockwise direction). If your application displays the image, you can use this value to correct the orientation. The bounding box coordinates returned in <code>CelebrityFaces</code> and <code>UnrecognizedFaces</code> represent face locations before the image orientation is corrected. </p> <note> <p>If the input image is in .jpeg format, it might contain exchangeable image (Exif) metadata that includes the image\'s orientation. If so, and the Exif metadata for the input image populates the orientation field, the value of <code>OrientationCorrection</code> is null. The <code>CelebrityFaces</code> and <code>UnrecognizedFaces</code> bounding box coordinates represent face locations after Exif metadata is used to correct the image orientation. Images in .png format don\'t contain Exif metadata. </p> </note>', ], ], 'OutputConfig' => [ 'base' => '<p>The S3 bucket and folder location where training output is placed.</p>', 'refs' => [ 'CreateProjectVersionRequest$OutputConfig' => '<p>The Amazon S3 location to store the results of training.</p>', 'ProjectVersionDescription$OutputConfig' => '<p>The location where training results are saved.</p>', ], ], 'PageSize' => [ 'base' => NULL, 'refs' => [ 'ListCollectionsRequest$MaxResults' => '<p>Maximum number of collection IDs to return. </p>', 'ListFacesRequest$MaxResults' => '<p>Maximum number of faces to return.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'GetCelebrityRecognitionRequest$NextToken' => '<p>If the previous response was incomplete (because there is more recognized celebrities to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of celebrities. </p>', 'GetCelebrityRecognitionResponse$NextToken' => '<p>If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent request to retrieve the next set of celebrities.</p>', 'GetContentModerationRequest$NextToken' => '<p>If the previous response was incomplete (because there is more data to retrieve), Amazon Rekognition returns a pagination token in the response. You can use this pagination token to retrieve the next set of unsafe content labels.</p>', 'GetContentModerationResponse$NextToken' => '<p>If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent request to retrieve the next set of unsafe content labels. </p>', 'GetFaceDetectionRequest$NextToken' => '<p>If the previous response was incomplete (because there are more faces to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of faces.</p>', 'GetFaceDetectionResponse$NextToken' => '<p>If the response is truncated, Amazon Rekognition returns this token that you can use in the subsequent request to retrieve the next set of faces. </p>', 'GetFaceSearchRequest$NextToken' => '<p>If the previous response was incomplete (because there is more search results to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of search results. </p>', 'GetFaceSearchResponse$NextToken' => '<p>If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent request to retrieve the next set of search results. </p>', 'GetLabelDetectionRequest$NextToken' => '<p>If the previous response was incomplete (because there are more labels to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of labels. </p>', 'GetLabelDetectionResponse$NextToken' => '<p>If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent request to retrieve the next set of labels.</p>', 'GetPersonTrackingRequest$NextToken' => '<p>If the previous response was incomplete (because there are more persons to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of persons. </p>', 'GetPersonTrackingResponse$NextToken' => '<p>If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent request to retrieve the next set of persons. </p>', 'GetSegmentDetectionRequest$NextToken' => '<p>If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent request to retrieve the next set of text.</p>', 'GetSegmentDetectionResponse$NextToken' => '<p>If the previous response was incomplete (because there are more labels to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of text.</p>', 'GetTextDetectionRequest$NextToken' => '<p>If the previous response was incomplete (because there are more labels to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of text.</p>', 'GetTextDetectionResponse$NextToken' => '<p>If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent request to retrieve the next set of text.</p>', 'ListCollectionsRequest$NextToken' => '<p>Pagination token from the previous response.</p>', 'ListCollectionsResponse$NextToken' => '<p>If the result is truncated, the response provides a <code>NextToken</code> that you can use in the subsequent request to fetch the next set of collection IDs.</p>', 'ListFacesRequest$NextToken' => '<p>If the previous response was incomplete (because there is more data to retrieve), Amazon Rekognition returns a pagination token in the response. You can use this pagination token to retrieve the next set of faces.</p>', 'ListStreamProcessorsRequest$NextToken' => '<p>If the previous response was incomplete (because there are more stream processors to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of stream processors. </p>', 'ListStreamProcessorsResponse$NextToken' => '<p>If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent request to retrieve the next set of stream processors. </p>', ], ], 'Parent' => [ 'base' => '<p>A parent label for a label. A label can have 0, 1, or more parents. </p>', 'refs' => [ 'Parents$member' => NULL, ], ], 'Parents' => [ 'base' => NULL, 'refs' => [ 'Label$Parents' => '<p>The parent labels for a label. The response includes all ancestor labels.</p>', ], ], 'Percent' => [ 'base' => NULL, 'refs' => [ 'Beard$Confidence' => '<p>Level of confidence in the determination.</p>', 'Celebrity$MatchConfidence' => '<p>The confidence, in percentage, that Amazon Rekognition has that the recognized face is the celebrity.</p>', 'CelebrityDetail$Confidence' => '<p>The confidence, in percentage, that Amazon Rekognition has that the recognized face is the celebrity. </p>', 'CompareFacesMatch$Similarity' => '<p>Level of confidence that the faces match.</p>', 'CompareFacesRequest$SimilarityThreshold' => '<p>The minimum level of confidence in the face matches that a match must meet to be included in the <code>FaceMatches</code> array.</p>', 'ComparedFace$Confidence' => '<p>Level of confidence that what the bounding box contains is a face.</p>', 'ComparedSourceImageFace$Confidence' => '<p>Confidence level that the selected bounding box contains a face.</p>', 'CustomLabel$Confidence' => '<p>The confidence that the model has in the detection of the custom label. The range is 0-100. A higher value indicates a higher confidence.</p>', 'DetectCustomLabelsRequest$MinConfidence' => '<p>Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn\'t return any labels with a confidence lower than this specified value. If you specify a value of 0, all labels are return, regardless of the default thresholds that the model version applies.</p>', 'DetectLabelsRequest$MinConfidence' => '<p>Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn\'t return any labels with confidence lower than this specified value.</p> <p>If <code>MinConfidence</code> is not specified, the operation returns labels with a confidence values greater than or equal to 55 percent.</p>', 'DetectModerationLabelsRequest$MinConfidence' => '<p>Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn\'t return any labels with a confidence level lower than this specified value.</p> <p>If you don\'t specify <code>MinConfidence</code>, the operation returns labels with confidence values greater than or equal to 50 percent.</p>', 'DetectionFilter$MinConfidence' => '<p>Sets confidence of word detection. Words with detection confidence below this will be excluded from the result. Values should be between 0.5 and 1 as Text in Video will not return any result below 0.5.</p>', 'Emotion$Confidence' => '<p>Level of confidence in the determination.</p>', 'EyeOpen$Confidence' => '<p>Level of confidence in the determination.</p>', 'Eyeglasses$Confidence' => '<p>Level of confidence in the determination.</p>', 'Face$Confidence' => '<p>Confidence level that the bounding box contains a face (and not a different object such as a tree).</p>', 'FaceDetail$Confidence' => '<p>Confidence level that the bounding box contains a face (and not a different object such as a tree). Default attribute.</p>', 'FaceMatch$Similarity' => '<p>Confidence in the match of this face with the input face.</p>', 'FaceSearchSettings$FaceMatchThreshold' => '<p>Minimum face match confidence score that must be met to return a result for a recognized face. Default is 80. 0 is the lowest confidence. 100 is the highest confidence.</p>', 'Gender$Confidence' => '<p>Level of confidence in the prediction.</p>', 'Instance$Confidence' => '<p>The confidence that Amazon Rekognition has in the accuracy of the bounding box.</p>', 'Label$Confidence' => '<p>Level of confidence.</p>', 'ModerationLabel$Confidence' => '<p>Specifies the confidence that Amazon Rekognition has that the label has been correctly identified.</p> <p>If you don\'t specify the <code>MinConfidence</code> parameter in the call to <code>DetectModerationLabels</code>, the operation returns labels with a confidence value greater than or equal to 50 percent.</p>', 'MouthOpen$Confidence' => '<p>Level of confidence in the determination.</p>', 'Mustache$Confidence' => '<p>Level of confidence in the determination.</p>', 'SearchFacesByImageRequest$FaceMatchThreshold' => '<p>(Optional) Specifies the minimum confidence in the face match to return. For example, don\'t return any matches where confidence in matches is less than 70%. The default value is 80%.</p>', 'SearchFacesByImageResponse$SearchedFaceConfidence' => '<p>The level of confidence that the <code>searchedFaceBoundingBox</code>, contains a face.</p>', 'SearchFacesRequest$FaceMatchThreshold' => '<p>Optional value specifying the minimum confidence in the face match to return. For example, don\'t return any matches where confidence in matches is less than 70%. The default value is 80%. </p>', 'Smile$Confidence' => '<p>Level of confidence in the determination.</p>', 'StartContentModerationRequest$MinConfidence' => '<p>Specifies the minimum confidence that Amazon Rekognition must have in order to return a moderated content label. Confidence represents how certain Amazon Rekognition is that the moderated content is correctly identified. 0 is the lowest confidence. 100 is the highest confidence. Amazon Rekognition doesn\'t return any moderated content labels with a confidence level lower than this specified value. If you don\'t specify <code>MinConfidence</code>, <code>GetContentModeration</code> returns labels with confidence values greater than or equal to 50 percent.</p>', 'StartFaceSearchRequest$FaceMatchThreshold' => '<p>The minimum confidence in the person match to return. For example, don\'t return any matches where confidence in matches is less than 70%. The default value is 80%.</p>', 'StartLabelDetectionRequest$MinConfidence' => '<p>Specifies the minimum confidence that Amazon Rekognition Video must have in order to return a detected label. Confidence represents how certain Amazon Rekognition is that a label is correctly identified.0 is the lowest confidence. 100 is the highest confidence. Amazon Rekognition Video doesn\'t return any labels with a confidence level lower than this specified value.</p> <p>If you don\'t specify <code>MinConfidence</code>, the operation returns labels with confidence values greater than or equal to 50 percent.</p>', 'Sunglasses$Confidence' => '<p>Level of confidence in the determination.</p>', 'TextDetection$Confidence' => '<p>The confidence that Amazon Rekognition has in the accuracy of the detected text and the accuracy of the geometry points around the detected text.</p>', ], ], 'PersonDetail' => [ 'base' => '<p>Details about a person detected in a video analysis request.</p>', 'refs' => [ 'PersonDetection$Person' => '<p>Details about a person whose path was tracked in a video.</p>', 'PersonMatch$Person' => '<p>Information about the matched person.</p>', ], ], 'PersonDetection' => [ 'base' => '<p>Details and path tracking information for a single time a person\'s path is tracked in a video. Amazon Rekognition operations that track people\'s paths return an array of <code>PersonDetection</code> objects with elements for each time a person\'s path is tracked in a video. </p> <p>For more information, see GetPersonTracking in the Amazon Rekognition Developer Guide. </p>', 'refs' => [ 'PersonDetections$member' => NULL, ], ], 'PersonDetections' => [ 'base' => NULL, 'refs' => [ 'GetPersonTrackingResponse$Persons' => '<p>An array of the persons detected in the video and the time(s) their path was tracked throughout the video. An array element will exist for each time a person\'s path is tracked. </p>', ], ], 'PersonIndex' => [ 'base' => NULL, 'refs' => [ 'PersonDetail$Index' => '<p>Identifier for the person detected person within a video. Use to keep track of the person throughout the video. The identifier is not stored by Amazon Rekognition.</p>', ], ], 'PersonMatch' => [ 'base' => '<p>Information about a person whose face matches a face(s) in an Amazon Rekognition collection. Includes information about the faces in the Amazon Rekognition collection (<a>FaceMatch</a>), information about the person (<a>PersonDetail</a>), and the time stamp for when the person was detected in a video. An array of <code>PersonMatch</code> objects is returned by <a>GetFaceSearch</a>. </p>', 'refs' => [ 'PersonMatches$member' => NULL, ], ], 'PersonMatches' => [ 'base' => NULL, 'refs' => [ 'GetFaceSearchResponse$Persons' => '<p>An array of persons, <a>PersonMatch</a>, in the video whose face(s) match the face(s) in an Amazon Rekognition collection. It also includes time information for when persons are matched in the video. You specify the input collection in an initial call to <code>StartFaceSearch</code>. Each <code>Persons</code> element includes a time the person was matched, face match details (<code>FaceMatches</code>) for matching faces in the collection, and person information (<code>Person</code>) for the matched person. </p>', ], ], 'PersonTrackingSortBy' => [ 'base' => NULL, 'refs' => [ 'GetPersonTrackingRequest$SortBy' => '<p>Sort to use for elements in the <code>Persons</code> array. Use <code>TIMESTAMP</code> to sort array elements by the time persons are detected. Use <code>INDEX</code> to sort by the tracked persons. If you sort by <code>INDEX</code>, the array elements for each person are sorted by detection confidence. The default sort is by <code>TIMESTAMP</code>.</p>', ], ], 'Point' => [ 'base' => '<p>The X and Y coordinates of a point on an image. The X and Y values returned are ratios of the overall image size. For example, if the input image is 700x200 and the operation returns X=0.5 and Y=0.25, then the point is at the (350,50) pixel coordinate on the image.</p> <p>An array of <code>Point</code> objects, <code>Polygon</code>, is returned by <a>DetectText</a> and by <a>DetectCustomLabels</a>. <code>Polygon</code> represents a fine-grained polygon around a detected item. For more information, see Geometry in the Amazon Rekognition Developer Guide. </p>', 'refs' => [ 'Polygon$member' => NULL, ], ], 'Polygon' => [ 'base' => NULL, 'refs' => [ 'Geometry$Polygon' => '<p>Within the bounding box, a fine-grained polygon around the detected item.</p>', ], ], 'Pose' => [ 'base' => '<p>Indicates the pose of the face as determined by its pitch, roll, and yaw.</p>', 'refs' => [ 'ComparedFace$Pose' => '<p>Indicates the pose of the face as determined by its pitch, roll, and yaw.</p>', 'FaceDetail$Pose' => '<p>Indicates the pose of the face as determined by its pitch, roll, and yaw. Default attribute.</p>', ], ], 'ProjectArn' => [ 'base' => NULL, 'refs' => [ 'CreateProjectResponse$ProjectArn' => '<p>The Amazon Resource Name (ARN) of the new project. You can use the ARN to configure IAM access to the project. </p>', 'CreateProjectVersionRequest$ProjectArn' => '<p>The ARN of the Amazon Rekognition Custom Labels project that manages the model that you want to train.</p>', 'DeleteProjectRequest$ProjectArn' => '<p>The Amazon Resource Name (ARN) of the project that you want to delete.</p>', 'DescribeProjectVersionsRequest$ProjectArn' => '<p>The Amazon Resource Name (ARN) of the project that contains the models you want to describe.</p>', 'ProjectDescription$ProjectArn' => '<p>The Amazon Resource Name (ARN) of the project.</p>', ], ], 'ProjectDescription' => [ 'base' => '<p>A description of a Amazon Rekognition Custom Labels project.</p>', 'refs' => [ 'ProjectDescriptions$member' => NULL, ], ], 'ProjectDescriptions' => [ 'base' => NULL, 'refs' => [ 'DescribeProjectsResponse$ProjectDescriptions' => '<p>A list of project descriptions. The list is sorted by the date and time the projects are created.</p>', ], ], 'ProjectName' => [ 'base' => NULL, 'refs' => [ 'CreateProjectRequest$ProjectName' => '<p>The name of the project to create.</p>', ], ], 'ProjectStatus' => [ 'base' => NULL, 'refs' => [ 'DeleteProjectResponse$Status' => '<p>The current status of the delete project operation.</p>', 'ProjectDescription$Status' => '<p>The current status of the project.</p>', ], ], 'ProjectVersionArn' => [ 'base' => NULL, 'refs' => [ 'CreateProjectVersionResponse$ProjectVersionArn' => '<p>The ARN of the model version that was created. Use <code>DescribeProjectVersion</code> to get the current status of the training operation.</p>', 'DeleteProjectVersionRequest$ProjectVersionArn' => '<p>The Amazon Resource Name (ARN) of the model version that you want to delete.</p>', 'DetectCustomLabelsRequest$ProjectVersionArn' => '<p>The ARN of the model version that you want to use.</p>', 'ProjectVersionDescription$ProjectVersionArn' => '<p>The Amazon Resource Name (ARN) of the model version. </p>', 'StartProjectVersionRequest$ProjectVersionArn' => '<p>The Amazon Resource Name(ARN) of the model version that you want to start.</p>', 'StopProjectVersionRequest$ProjectVersionArn' => '<p>The Amazon Resource Name (ARN) of the model version that you want to delete.</p> <p>This operation requires permissions to perform the <code>rekognition:StopProjectVersion</code> action.</p>', ], ], 'ProjectVersionDescription' => [ 'base' => '<p>The description of a version of a model.</p>', 'refs' => [ 'ProjectVersionDescriptions$member' => NULL, ], ], 'ProjectVersionDescriptions' => [ 'base' => NULL, 'refs' => [ 'DescribeProjectVersionsResponse$ProjectVersionDescriptions' => '<p>A list of model descriptions. The list is sorted by the creation date and time of the model versions, latest to earliest.</p>', ], ], 'ProjectVersionStatus' => [ 'base' => NULL, 'refs' => [ 'DeleteProjectVersionResponse$Status' => '<p>The status of the deletion operation.</p>', 'ProjectVersionDescription$Status' => '<p>The current status of the model version.</p>', 'StartProjectVersionResponse$Status' => '<p>The current running status of the model. </p>', 'StopProjectVersionResponse$Status' => '<p>The current status of the stop operation. </p>', ], ], 'ProjectVersionsPageSize' => [ 'base' => NULL, 'refs' => [ 'DescribeProjectVersionsRequest$MaxResults' => '<p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100. </p>', ], ], 'ProjectsPageSize' => [ 'base' => NULL, 'refs' => [ 'DescribeProjectsRequest$MaxResults' => '<p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100. </p>', ], ], 'ProvisionedThroughputExceededException' => [ 'base' => '<p>The number of requests exceeded your throughput limit. If you want to increase this limit, contact Amazon Rekognition.</p>', 'refs' => [], ], 'QualityFilter' => [ 'base' => NULL, 'refs' => [ 'CompareFacesRequest$QualityFilter' => '<p>A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren\'t compared. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If you specify <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that don’t meet the chosen quality bar. The quality bar is based on a variety of common use cases. Low-quality detections can occur for a number of reasons. Some examples are an object that\'s misidentified as a face, a face that\'s too blurry, or a face with a pose that\'s too extreme to use. If you specify <code>NONE</code>, no filtering is performed. The default value is <code>NONE</code>. </p> <p>To use quality filtering, the collection you are using must be associated with version 3 of the face model or higher.</p>', 'IndexFacesRequest$QualityFilter' => '<p>A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren\'t indexed. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If you specify <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that don’t meet the chosen quality bar. The default value is <code>AUTO</code>. The quality bar is based on a variety of common use cases. Low-quality detections can occur for a number of reasons. Some examples are an object that\'s misidentified as a face, a face that\'s too blurry, or a face with a pose that\'s too extreme to use. If you specify <code>NONE</code>, no filtering is performed. </p> <p>To use quality filtering, the collection you are using must be associated with version 3 of the face model or higher.</p>', 'SearchFacesByImageRequest$QualityFilter' => '<p>A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren\'t searched for in the collection. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If you specify <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that don’t meet the chosen quality bar. The quality bar is based on a variety of common use cases. Low-quality detections can occur for a number of reasons. Some examples are an object that\'s misidentified as a face, a face that\'s too blurry, or a face with a pose that\'s too extreme to use. If you specify <code>NONE</code>, no filtering is performed. The default value is <code>NONE</code>. </p> <p>To use quality filtering, the collection you are using must be associated with version 3 of the face model or higher.</p>', ], ], 'Reason' => [ 'base' => NULL, 'refs' => [ 'Reasons$member' => NULL, ], ], 'Reasons' => [ 'base' => NULL, 'refs' => [ 'UnindexedFace$Reasons' => '<p>An array of reasons that specify why a face wasn\'t indexed. </p> <ul> <li> <p>EXTREME_POSE - The face is at a pose that can\'t be detected. For example, the head is turned too far away from the camera.</p> </li> <li> <p>EXCEEDS_MAX_FACES - The number of faces detected is already higher than that specified by the <code>MaxFaces</code> input parameter for <code>IndexFaces</code>.</p> </li> <li> <p>LOW_BRIGHTNESS - The image is too dark.</p> </li> <li> <p>LOW_SHARPNESS - The image is too blurry.</p> </li> <li> <p>LOW_CONFIDENCE - The face was detected with a low confidence.</p> </li> <li> <p>SMALL_BOUNDING_BOX - The bounding box around the face is too small.</p> </li> </ul>', ], ], 'RecognizeCelebritiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'RecognizeCelebritiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'RegionOfInterest' => [ 'base' => '<p>Specifies a location within the frame that Rekognition checks for text. Uses a <code>BoundingBox</code> object to set a region of the screen.</p> <p>A word is included in the region if the word is more than half in that region. If there is more than one region, the word will be compared with all regions of the screen. Any word more than half in a region is kept in the results.</p>', 'refs' => [ 'RegionsOfInterest$member' => NULL, ], ], 'RegionsOfInterest' => [ 'base' => NULL, 'refs' => [ 'DetectTextFilters$RegionsOfInterest' => '<p> A Filter focusing on a certain area of the image. Uses a <code>BoundingBox</code> object to set the region of the image.</p>', 'StartTextDetectionFilters$RegionsOfInterest' => '<p>Filter focusing on a certain area of the frame. Uses a <code>BoundingBox</code> object to set the region of the screen.</p>', ], ], 'RekognitionUniqueId' => [ 'base' => NULL, 'refs' => [ 'Celebrity$Id' => '<p>A unique identifier for the celebrity. </p>', 'CelebrityDetail$Id' => '<p>The unique identifier for the celebrity. </p>', 'GetCelebrityInfoRequest$Id' => '<p>The ID for the celebrity. You get the celebrity ID from a call to the <a>RecognizeCelebrities</a> operation, which recognizes celebrities in an image. </p>', ], ], 'ResourceAlreadyExistsException' => [ 'base' => '<p>A collection with the specified ID already exists.</p>', 'refs' => [], ], 'ResourceInUseException' => [ 'base' => '<p>The specified resource is already being used.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The collection specified in the request cannot be found.</p>', 'refs' => [], ], 'ResourceNotReadyException' => [ 'base' => '<p>The requested resource isn\'t ready. For example, this exception occurs when you call <code>DetectCustomLabels</code> with a model version that isn\'t deployed. </p>', 'refs' => [], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateStreamProcessorRequest$RoleArn' => '<p>ARN of the IAM role that allows access to the stream processor.</p>', 'DescribeStreamProcessorResponse$RoleArn' => '<p>ARN of the IAM role that allows access to the stream processor.</p>', 'NotificationChannel$RoleArn' => '<p>The ARN of an IAM role that gives Amazon Rekognition publishing permissions to the Amazon SNS topic. </p>', ], ], 'S3Bucket' => [ 'base' => NULL, 'refs' => [ 'OutputConfig$S3Bucket' => '<p>The S3 bucket where training output is placed.</p>', 'S3Object$Bucket' => '<p>Name of the S3 bucket.</p>', ], ], 'S3KeyPrefix' => [ 'base' => NULL, 'refs' => [ 'OutputConfig$S3KeyPrefix' => '<p>The prefix applied to the training output files. </p>', ], ], 'S3Object' => [ 'base' => '<p>Provides the S3 bucket name and object name.</p> <p>The region for the S3 bucket containing the S3 object must match the region you use for Amazon Rekognition operations.</p> <p>For Amazon Rekognition to process an S3 object, the user must have permission to access the S3 object. For more information, see Resource-Based Policies in the Amazon Rekognition Developer Guide. </p>', 'refs' => [ 'GroundTruthManifest$S3Object' => NULL, 'Image$S3Object' => '<p>Identifies an S3 object as the image source.</p>', 'Summary$S3Object' => NULL, 'Video$S3Object' => '<p>The Amazon S3 bucket name and file name for the video.</p>', ], ], 'S3ObjectName' => [ 'base' => NULL, 'refs' => [ 'S3Object$Name' => '<p>S3 object key name.</p>', ], ], 'S3ObjectVersion' => [ 'base' => NULL, 'refs' => [ 'S3Object$Version' => '<p>If the bucket is versioning enabled, you can specify the object version. </p>', ], ], 'SNSTopicArn' => [ 'base' => NULL, 'refs' => [ 'NotificationChannel$SNSTopicArn' => '<p>The Amazon SNS topic to which Amazon Rekognition to posts the completion status.</p>', ], ], 'SearchFacesByImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchFacesByImageResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchFacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchFacesResponse' => [ 'base' => NULL, 'refs' => [], ], 'SegmentConfidence' => [ 'base' => NULL, 'refs' => [ 'ShotSegment$Confidence' => '<p>The confidence that Amazon Rekognition Video has in the accuracy of the detected segment.</p>', 'StartShotDetectionFilter$MinSegmentConfidence' => '<p>Specifies the minimum confidence that Amazon Rekognition Video must have in order to return a detected segment. Confidence represents how certain Amazon Rekognition is that a segment is correctly identified. 0 is the lowest confidence. 100 is the highest confidence. Amazon Rekognition Video doesn\'t return any segments with a confidence level lower than this specified value.</p> <p>If you don\'t specify <code>MinSegmentConfidence</code>, the <code>GetSegmentDetection</code> returns segments with confidence values greater than or equal to 50 percent.</p>', 'StartTechnicalCueDetectionFilter$MinSegmentConfidence' => '<p>Specifies the minimum confidence that Amazon Rekognition Video must have in order to return a detected segment. Confidence represents how certain Amazon Rekognition is that a segment is correctly identified. 0 is the lowest confidence. 100 is the highest confidence. Amazon Rekognition Video doesn\'t return any segments with a confidence level lower than this specified value.</p> <p>If you don\'t specify <code>MinSegmentConfidence</code>, <code>GetSegmentDetection</code> returns segments with confidence values greater than or equal to 50 percent.</p>', 'TechnicalCueSegment$Confidence' => '<p>The confidence that Amazon Rekognition Video has in the accuracy of the detected segment.</p>', ], ], 'SegmentDetection' => [ 'base' => '<p>A technical cue or shot detection segment detected in a video. An array of <code>SegmentDetection</code> objects containing all segments detected in a stored video is returned by <a>GetSegmentDetection</a>. </p>', 'refs' => [ 'SegmentDetections$member' => NULL, ], ], 'SegmentDetections' => [ 'base' => NULL, 'refs' => [ 'GetSegmentDetectionResponse$Segments' => '<p>An array of segments detected in a video.</p>', ], ], 'SegmentType' => [ 'base' => NULL, 'refs' => [ 'SegmentDetection$Type' => '<p>The type of the segment. Valid values are <code>TECHNICAL_CUE</code> and <code>SHOT</code>.</p>', 'SegmentTypeInfo$Type' => '<p>The type of a segment (technical cue or shot detection).</p>', 'SegmentTypes$member' => NULL, ], ], 'SegmentTypeInfo' => [ 'base' => '<p>Information about the type of a segment requested in a call to <a>StartSegmentDetection</a>. An array of <code>SegmentTypeInfo</code> objects is returned by the response from <a>GetSegmentDetection</a>.</p>', 'refs' => [ 'SegmentTypesInfo$member' => NULL, ], ], 'SegmentTypes' => [ 'base' => NULL, 'refs' => [ 'StartSegmentDetectionRequest$SegmentTypes' => '<p>An array of segment types to detect in the video. Valid values are TECHNICAL_CUE and SHOT.</p>', ], ], 'SegmentTypesInfo' => [ 'base' => NULL, 'refs' => [ 'GetSegmentDetectionResponse$SelectedSegmentTypes' => '<p>An array containing the segment types requested in the call to <code>StartSegmentDetection</code>. </p>', ], ], 'ShotSegment' => [ 'base' => '<p>Information about a shot detection segment detected in a video. For more information, see <a>SegmentDetection</a>.</p>', 'refs' => [ 'SegmentDetection$ShotSegment' => '<p>If the segment is a shot detection, contains information about the shot detection.</p>', ], ], 'Smile' => [ 'base' => '<p>Indicates whether or not the face is smiling, and the confidence level in the determination.</p>', 'refs' => [ 'FaceDetail$Smile' => '<p>Indicates whether or not the face is smiling, and the confidence level in the determination.</p>', ], ], 'StartCelebrityRecognitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartCelebrityRecognitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartContentModerationRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartContentModerationResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartFaceDetectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartFaceDetectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartFaceSearchRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartFaceSearchResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartLabelDetectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartLabelDetectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartPersonTrackingRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartPersonTrackingResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartProjectVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartProjectVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartSegmentDetectionFilters' => [ 'base' => '<p>Filters applied to the technical cue or shot detection segments. For more information, see <a>StartSegmentDetection</a>. </p>', 'refs' => [ 'StartSegmentDetectionRequest$Filters' => '<p>Filters for technical cue or shot detection.</p>', ], ], 'StartSegmentDetectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartSegmentDetectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartShotDetectionFilter' => [ 'base' => '<p>Filters for the shot detection segments returned by <code>GetSegmentDetection</code>. For more information, see <a>StartSegmentDetectionFilters</a>.</p>', 'refs' => [ 'StartSegmentDetectionFilters$ShotFilter' => '<p>Filters that are specific to shot detections.</p>', ], ], 'StartStreamProcessorRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartStreamProcessorResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartTechnicalCueDetectionFilter' => [ 'base' => '<p>Filters for the technical segments returned by <a>GetSegmentDetection</a>. For more information, see <a>StartSegmentDetectionFilters</a>.</p>', 'refs' => [ 'StartSegmentDetectionFilters$TechnicalCueFilter' => '<p>Filters that are specific to technical cues.</p>', ], ], 'StartTextDetectionFilters' => [ 'base' => '<p>Set of optional parameters that let you set the criteria text must meet to be included in your response. <code>WordFilter</code> looks at a word\'s height, width and minimum confidence. <code>RegionOfInterest</code> lets you set a specific region of the screen to look for text in.</p>', 'refs' => [ 'StartTextDetectionRequest$Filters' => '<p>Optional parameters that let you set criteria the text must meet to be included in your response.</p>', ], ], 'StartTextDetectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartTextDetectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StatusMessage' => [ 'base' => NULL, 'refs' => [ 'GetCelebrityRecognitionResponse$StatusMessage' => '<p>If the job fails, <code>StatusMessage</code> provides a descriptive error message.</p>', 'GetContentModerationResponse$StatusMessage' => '<p>If the job fails, <code>StatusMessage</code> provides a descriptive error message.</p>', 'GetFaceDetectionResponse$StatusMessage' => '<p>If the job fails, <code>StatusMessage</code> provides a descriptive error message.</p>', 'GetFaceSearchResponse$StatusMessage' => '<p>If the job fails, <code>StatusMessage</code> provides a descriptive error message.</p>', 'GetLabelDetectionResponse$StatusMessage' => '<p>If the job fails, <code>StatusMessage</code> provides a descriptive error message.</p>', 'GetPersonTrackingResponse$StatusMessage' => '<p>If the job fails, <code>StatusMessage</code> provides a descriptive error message.</p>', 'GetSegmentDetectionResponse$StatusMessage' => '<p>If the job fails, <code>StatusMessage</code> provides a descriptive error message.</p>', 'GetTextDetectionResponse$StatusMessage' => '<p>If the job fails, <code>StatusMessage</code> provides a descriptive error message.</p>', 'ProjectVersionDescription$StatusMessage' => '<p>A descriptive message for an error or warning that occurred.</p>', ], ], 'StopProjectVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopProjectVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopStreamProcessorRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopStreamProcessorResponse' => [ 'base' => NULL, 'refs' => [], ], 'StreamProcessor' => [ 'base' => '<p>An object that recognizes faces in a streaming video. An Amazon Rekognition stream processor is created by a call to <a>CreateStreamProcessor</a>. The request parameters for <code>CreateStreamProcessor</code> describe the Kinesis video stream source for the streaming video, face recognition parameters, and where to stream the analysis resullts. </p>', 'refs' => [ 'StreamProcessorList$member' => NULL, ], ], 'StreamProcessorArn' => [ 'base' => NULL, 'refs' => [ 'CreateStreamProcessorResponse$StreamProcessorArn' => '<p>ARN for the newly create stream processor.</p>', 'DescribeStreamProcessorResponse$StreamProcessorArn' => '<p>ARN of the stream processor.</p>', ], ], 'StreamProcessorInput' => [ 'base' => '<p>Information about the source streaming video. </p>', 'refs' => [ 'CreateStreamProcessorRequest$Input' => '<p>Kinesis video stream stream that provides the source streaming video. If you are using the AWS CLI, the parameter name is <code>StreamProcessorInput</code>.</p>', 'DescribeStreamProcessorResponse$Input' => '<p>Kinesis video stream that provides the source streaming video.</p>', ], ], 'StreamProcessorList' => [ 'base' => NULL, 'refs' => [ 'ListStreamProcessorsResponse$StreamProcessors' => '<p>List of stream processors that you have created.</p>', ], ], 'StreamProcessorName' => [ 'base' => NULL, 'refs' => [ 'CreateStreamProcessorRequest$Name' => '<p>An identifier you assign to the stream processor. You can use <code>Name</code> to manage the stream processor. For example, you can get the current status of the stream processor by calling <a>DescribeStreamProcessor</a>. <code>Name</code> is idempotent. </p>', 'DeleteStreamProcessorRequest$Name' => '<p>The name of the stream processor you want to delete.</p>', 'DescribeStreamProcessorRequest$Name' => '<p>Name of the stream processor for which you want information.</p>', 'DescribeStreamProcessorResponse$Name' => '<p>Name of the stream processor. </p>', 'StartStreamProcessorRequest$Name' => '<p>The name of the stream processor to start processing.</p>', 'StopStreamProcessorRequest$Name' => '<p>The name of a stream processor created by <a>CreateStreamProcessor</a>.</p>', 'StreamProcessor$Name' => '<p>Name of the Amazon Rekognition stream processor. </p>', ], ], 'StreamProcessorOutput' => [ 'base' => '<p>Information about the Amazon Kinesis Data Streams stream to which a Amazon Rekognition Video stream processor streams the results of a video analysis. For more information, see CreateStreamProcessor in the Amazon Rekognition Developer Guide.</p>', 'refs' => [ 'CreateStreamProcessorRequest$Output' => '<p>Kinesis data stream stream to which Amazon Rekognition Video puts the analysis results. If you are using the AWS CLI, the parameter name is <code>StreamProcessorOutput</code>.</p>', 'DescribeStreamProcessorResponse$Output' => '<p>Kinesis data stream to which Amazon Rekognition Video puts the analysis results.</p>', ], ], 'StreamProcessorSettings' => [ 'base' => '<p>Input parameters used to recognize faces in a streaming video analyzed by a Amazon Rekognition stream processor.</p>', 'refs' => [ 'CreateStreamProcessorRequest$Settings' => '<p>Face recognition input parameters to be used by the stream processor. Includes the collection to use for face recognition and the face attributes to detect.</p>', 'DescribeStreamProcessorResponse$Settings' => '<p>Face recognition input parameters that are being used by the stream processor. Includes the collection to use for face recognition and the face attributes to detect.</p>', ], ], 'StreamProcessorStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeStreamProcessorResponse$Status' => '<p>Current status of the stream processor.</p>', 'StreamProcessor$Status' => '<p>Current status of the Amazon Rekognition stream processor.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AudioMetadata$Codec' => '<p>The audio codec used to encode or decode the audio stream. </p>', 'Celebrity$Name' => '<p>The name of the celebrity.</p>', 'CelebrityDetail$Name' => '<p>The name of the celebrity.</p>', 'CreateCollectionResponse$CollectionArn' => '<p>Amazon Resource Name (ARN) of the collection. You can use this to manage permissions on your resources. </p>', 'CreateCollectionResponse$FaceModelVersion' => '<p>Version number of the face detection model associated with the collection you are creating.</p>', 'CustomLabel$Name' => '<p>The name of the custom label.</p>', 'DescribeCollectionResponse$FaceModelVersion' => '<p>The version of the face model that\'s used by the collection for face detection.</p> <p>For more information, see Model Versioning in the Amazon Rekognition Developer Guide.</p>', 'DescribeCollectionResponse$CollectionARN' => '<p>The Amazon Resource Name (ARN) of the collection.</p>', 'DescribeStreamProcessorResponse$StatusMessage' => '<p>Detailed status message about the stream processor.</p>', 'DetectLabelsResponse$LabelModelVersion' => '<p>Version number of the label detection model that was used to detect labels.</p>', 'DetectModerationLabelsResponse$ModerationModelVersion' => '<p>Version number of the moderation detection model that was used to detect unsafe content.</p>', 'DetectTextResponse$TextModelVersion' => '<p>The model version used to detect text.</p>', 'FaceModelVersionList$member' => NULL, 'GetCelebrityInfoResponse$Name' => '<p>The name of the celebrity.</p>', 'GetContentModerationResponse$ModerationModelVersion' => '<p>Version number of the moderation detection model that was used to detect unsafe content.</p>', 'GetLabelDetectionResponse$LabelModelVersion' => '<p>Version number of the label detection model that was used to detect labels.</p>', 'GetTextDetectionResponse$TextModelVersion' => '<p>Version number of the text detection model that was used to detect text.</p>', 'HumanLoopQuotaExceededException$ResourceType' => '<p>The resource type.</p>', 'HumanLoopQuotaExceededException$QuotaCode' => '<p>The quota code.</p>', 'HumanLoopQuotaExceededException$ServiceCode' => '<p>The service code.</p>', 'IndexFacesResponse$FaceModelVersion' => '<p>The version number of the face detection model that\'s associated with the input collection (<code>CollectionId</code>).</p>', 'Label$Name' => '<p>The name (label) of the object or scene.</p>', 'ListFacesResponse$NextToken' => '<p>If the response is truncated, Amazon Rekognition returns this token that you can use in the subsequent request to retrieve the next set of faces.</p>', 'ListFacesResponse$FaceModelVersion' => '<p>Version number of the face detection model associated with the input collection (<code>CollectionId</code>).</p>', 'ModerationLabel$Name' => '<p>The label name for the type of unsafe content detected in the image.</p>', 'ModerationLabel$ParentName' => '<p>The name for the parent label. Labels at the top level of the hierarchy have the parent label <code>""</code>.</p>', 'Parent$Name' => '<p>The name of the parent label.</p>', 'SearchFacesByImageResponse$FaceModelVersion' => '<p>Version number of the face detection model associated with the input collection (<code>CollectionId</code>).</p>', 'SearchFacesResponse$FaceModelVersion' => '<p>Version number of the face detection model associated with the input collection (<code>CollectionId</code>).</p>', 'SegmentTypeInfo$ModelVersion' => '<p>The version of the model used to detect segments.</p>', 'TextDetection$DetectedText' => '<p>The word or line of text recognized by Amazon Rekognition. </p>', 'VideoMetadata$Codec' => '<p>Type of compression used in the analyzed video. </p>', 'VideoMetadata$Format' => '<p>Format of the analyzed video. Possible values are MP4, MOV and AVI. </p>', ], ], 'Summary' => [ 'base' => '<p>The S3 bucket that contains the training summary. The training summary includes aggregated evaluation metrics for the entire testing dataset and metrics for each individual label. </p> <p>You get the training summary S3 bucket location by calling <a>DescribeProjectVersions</a>. </p>', 'refs' => [ 'EvaluationResult$Summary' => '<p>The S3 bucket that contains the training summary.</p>', ], ], 'Sunglasses' => [ 'base' => '<p>Indicates whether or not the face is wearing sunglasses, and the confidence level in the determination.</p>', 'refs' => [ 'FaceDetail$Sunglasses' => '<p>Indicates whether or not the face is wearing sunglasses, and the confidence level in the determination.</p>', ], ], 'TechnicalCueSegment' => [ 'base' => '<p>Information about a technical cue segment. For more information, see <a>SegmentDetection</a>.</p>', 'refs' => [ 'SegmentDetection$TechnicalCueSegment' => '<p>If the segment is a technical cue, contains information about the technical cue.</p>', ], ], 'TechnicalCueType' => [ 'base' => NULL, 'refs' => [ 'TechnicalCueSegment$Type' => '<p>The type of the technical cue.</p>', ], ], 'TestingData' => [ 'base' => '<p>The dataset used for testing. Optionally, if <code>AutoCreate</code> is set, Amazon Rekognition Custom Labels creates a testing dataset using an 80/20 split of the training dataset.</p>', 'refs' => [ 'CreateProjectVersionRequest$TestingData' => '<p>The dataset to use for testing.</p>', 'TestingDataResult$Input' => '<p>The testing dataset that was supplied for training.</p>', 'TestingDataResult$Output' => '<p>The subset of the dataset that was actually tested. Some images (assets) might not be tested due to file formatting and other issues. </p>', ], ], 'TestingDataResult' => [ 'base' => '<p>A Sagemaker Groundtruth format manifest file representing the dataset used for testing.</p>', 'refs' => [ 'ProjectVersionDescription$TestingDataResult' => '<p>The manifest file that represents the testing results.</p>', ], ], 'TextDetection' => [ 'base' => '<p>Information about a word or line of text detected by <a>DetectText</a>.</p> <p>The <code>DetectedText</code> field contains the text that Amazon Rekognition detected in the image. </p> <p>Every word and line has an identifier (<code>Id</code>). Each word belongs to a line and has a parent identifier (<code>ParentId</code>) that identifies the line of text in which the word appears. The word <code>Id</code> is also an index for the word within a line of words. </p> <p>For more information, see Detecting Text in the Amazon Rekognition Developer Guide.</p>', 'refs' => [ 'TextDetectionList$member' => NULL, 'TextDetectionResult$TextDetection' => '<p>Details about text detected in a video.</p>', ], ], 'TextDetectionList' => [ 'base' => NULL, 'refs' => [ 'DetectTextResponse$TextDetections' => '<p>An array of text that was detected in the input image.</p>', ], ], 'TextDetectionResult' => [ 'base' => '<p>Information about text detected in a video. Incudes the detected text, the time in milliseconds from the start of the video that the text was detected, and where it was detected on the screen.</p>', 'refs' => [ 'TextDetectionResults$member' => NULL, ], ], 'TextDetectionResults' => [ 'base' => NULL, 'refs' => [ 'GetTextDetectionResponse$TextDetections' => '<p>An array of text detected in the video. Each element contains the detected text, the time in milliseconds from the start of the video that the text was detected, and where it was detected on the screen.</p>', ], ], 'TextTypes' => [ 'base' => NULL, 'refs' => [ 'TextDetection$Type' => '<p>The type of text that was detected.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>Amazon Rekognition is temporarily unable to process the request. Try your call again.</p>', 'refs' => [], ], 'Timecode' => [ 'base' => NULL, 'refs' => [ 'SegmentDetection$StartTimecodeSMPTE' => '<p>The frame-accurate SMPTE timecode, from the start of a video, for the start of a detected segment. <code>StartTimecode</code> is in <i>HH:MM:SS:fr</i> format (and <i>;fr</i> for drop frame-rates). </p>', 'SegmentDetection$EndTimecodeSMPTE' => '<p>The frame-accurate SMPTE timecode, from the start of a video, for the end of a detected segment. <code>EndTimecode</code> is in <i>HH:MM:SS:fr</i> format (and <i>;fr</i> for drop frame-rates).</p>', 'SegmentDetection$DurationSMPTE' => '<p>The duration of the timecode for the detected segment in SMPTE format.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'CelebrityRecognition$Timestamp' => '<p>The time, in milliseconds from the start of the video, that the celebrity was recognized.</p>', 'ContentModerationDetection$Timestamp' => '<p>Time, in milliseconds from the beginning of the video, that the unsafe content label was detected.</p>', 'FaceDetection$Timestamp' => '<p>Time, in milliseconds from the start of the video, that the face was detected.</p>', 'LabelDetection$Timestamp' => '<p>Time, in milliseconds from the start of the video, that the label was detected.</p>', 'PersonDetection$Timestamp' => '<p>The time, in milliseconds from the start of the video, that the person\'s path was tracked.</p>', 'PersonMatch$Timestamp' => '<p>The time, in milliseconds from the beginning of the video, that the person was matched in the video.</p>', 'SegmentDetection$StartTimestampMillis' => '<p>The start time of the detected segment in milliseconds from the start of the video.</p>', 'SegmentDetection$EndTimestampMillis' => '<p>The end time of the detected segment, in milliseconds, from the start of the video.</p>', 'TextDetectionResult$Timestamp' => '<p>The time, in milliseconds from the start of the video, that the text was detected.</p>', ], ], 'TrainingData' => [ 'base' => '<p>The dataset used for training.</p>', 'refs' => [ 'CreateProjectVersionRequest$TrainingData' => '<p>The dataset to use for training. </p>', 'TrainingDataResult$Input' => '<p>The training assets that you supplied for training.</p>', 'TrainingDataResult$Output' => '<p>The images (assets) that were actually trained by Amazon Rekognition Custom Labels. </p>', ], ], 'TrainingDataResult' => [ 'base' => '<p>A Sagemaker Groundtruth format manifest file that represents the dataset used for training.</p>', 'refs' => [ 'ProjectVersionDescription$TrainingDataResult' => '<p>The manifest file that represents the training results.</p>', ], ], 'UInteger' => [ 'base' => NULL, 'refs' => [ 'AgeRange$Low' => '<p>The lowest estimated age.</p>', 'AgeRange$High' => '<p>The highest estimated age.</p>', 'CreateCollectionResponse$StatusCode' => '<p>HTTP status code indicating the result of the operation.</p>', 'DeleteCollectionResponse$StatusCode' => '<p>HTTP status code that indicates the result of the operation.</p>', 'DetectCustomLabelsRequest$MaxResults' => '<p>Maximum number of results you want the service to return in the response. The service returns the specified number of highest confidence labels ranked from highest confidence to lowest.</p>', 'DetectLabelsRequest$MaxLabels' => '<p>Maximum number of labels you want the service to return in the response. The service returns the specified number of highest confidence labels. </p>', 'TextDetection$Id' => '<p>The identifier for the detected text. The identifier is only unique for a single call to <code>DetectText</code>. </p>', 'TextDetection$ParentId' => '<p>The Parent identifier for the detected text identified by the value of <code>ID</code>. If the type of detected text is <code>LINE</code>, the value of <code>ParentId</code> is <code>Null</code>. </p>', ], ], 'ULong' => [ 'base' => NULL, 'refs' => [ 'AudioMetadata$DurationMillis' => '<p>The duration of the audio stream in milliseconds.</p>', 'AudioMetadata$SampleRate' => '<p>The sample rate for the audio stream.</p>', 'AudioMetadata$NumberOfChannels' => '<p>The number of audio channels in the segement.</p>', 'DescribeCollectionResponse$FaceCount' => '<p>The number of faces that are indexed into the collection. To index faces into a collection, use <a>IndexFaces</a>.</p>', 'ProjectVersionDescription$BillableTrainingTimeInSeconds' => '<p>The duration, in seconds, that the model version has been billed for training. This value is only returned if the model version has been successfully trained.</p>', 'SegmentDetection$DurationMillis' => '<p>The duration of the detected segment in milliseconds. </p>', 'ShotSegment$Index' => '<p>An Identifier for a shot detection segment detected in a video </p>', 'VideoMetadata$DurationMillis' => '<p>Length of the video in milliseconds.</p>', 'VideoMetadata$FrameHeight' => '<p>Vertical pixel dimension of the video.</p>', 'VideoMetadata$FrameWidth' => '<p>Horizontal pixel dimension of the video.</p>', ], ], 'UnindexedFace' => [ 'base' => '<p>A face that <a>IndexFaces</a> detected, but didn\'t index. Use the <code>Reasons</code> response attribute to determine why a face wasn\'t indexed.</p>', 'refs' => [ 'UnindexedFaces$member' => NULL, ], ], 'UnindexedFaces' => [ 'base' => NULL, 'refs' => [ 'IndexFacesResponse$UnindexedFaces' => '<p>An array of faces that were detected in the image but weren\'t indexed. They weren\'t indexed because the quality filter identified them as low quality, or the <code>MaxFaces</code> request parameter filtered them out. To use the quality filter, you specify the <code>QualityFilter</code> request parameter.</p>', ], ], 'Url' => [ 'base' => NULL, 'refs' => [ 'Urls$member' => NULL, ], ], 'Urls' => [ 'base' => NULL, 'refs' => [ 'Celebrity$Urls' => '<p>An array of URLs pointing to additional information about the celebrity. If there is no additional information about the celebrity, this list is empty.</p>', 'CelebrityDetail$Urls' => '<p>An array of URLs pointing to additional celebrity information. </p>', 'GetCelebrityInfoResponse$Urls' => '<p>An array of URLs pointing to additional celebrity information. </p>', ], ], 'VersionName' => [ 'base' => NULL, 'refs' => [ 'CreateProjectVersionRequest$VersionName' => '<p>A name for the version of the model. This value must be unique.</p>', 'VersionNames$member' => NULL, ], ], 'VersionNames' => [ 'base' => NULL, 'refs' => [ 'DescribeProjectVersionsRequest$VersionNames' => '<p>A list of model version names that you want to describe. You can add up to 10 model version names to the list. If you don\'t specify a value, all model descriptions are returned. A version name is part of a model (ProjectVersion) ARN. For example, <code>my-model.2020-01-21T09.10.15</code> is the version name in the following ARN. <code>arn:aws:rekognition:us-east-1:123456789012:project/getting-started/version/<i>my-model.2020-01-21T09.10.15</i>/1234567890123</code>.</p>', ], ], 'Video' => [ 'base' => '<p>Video file stored in an Amazon S3 bucket. Amazon Rekognition video start operations such as <a>StartLabelDetection</a> use <code>Video</code> to specify a video for analysis. The supported file formats are .mp4, .mov and .avi.</p>', 'refs' => [ 'StartCelebrityRecognitionRequest$Video' => '<p>The video in which you want to recognize celebrities. The video must be stored in an Amazon S3 bucket.</p>', 'StartContentModerationRequest$Video' => '<p>The video in which you want to detect unsafe content. The video must be stored in an Amazon S3 bucket.</p>', 'StartFaceDetectionRequest$Video' => '<p>The video in which you want to detect faces. The video must be stored in an Amazon S3 bucket.</p>', 'StartFaceSearchRequest$Video' => '<p>The video you want to search. The video must be stored in an Amazon S3 bucket. </p>', 'StartLabelDetectionRequest$Video' => '<p>The video in which you want to detect labels. The video must be stored in an Amazon S3 bucket.</p>', 'StartPersonTrackingRequest$Video' => '<p>The video in which you want to detect people. The video must be stored in an Amazon S3 bucket.</p>', 'StartSegmentDetectionRequest$Video' => NULL, 'StartTextDetectionRequest$Video' => NULL, ], ], 'VideoJobStatus' => [ 'base' => NULL, 'refs' => [ 'GetCelebrityRecognitionResponse$JobStatus' => '<p>The current status of the celebrity recognition job.</p>', 'GetContentModerationResponse$JobStatus' => '<p>The current status of the unsafe content analysis job.</p>', 'GetFaceDetectionResponse$JobStatus' => '<p>The current status of the face detection job.</p>', 'GetFaceSearchResponse$JobStatus' => '<p>The current status of the face search job.</p>', 'GetLabelDetectionResponse$JobStatus' => '<p>The current status of the label detection job.</p>', 'GetPersonTrackingResponse$JobStatus' => '<p>The current status of the person tracking job.</p>', 'GetSegmentDetectionResponse$JobStatus' => '<p>Current status of the segment detection job.</p>', 'GetTextDetectionResponse$JobStatus' => '<p>Current status of the text detection job.</p>', ], ], 'VideoMetadata' => [ 'base' => '<p>Information about a video that Amazon Rekognition analyzed. <code>Videometadata</code> is returned in every page of paginated responses from a Amazon Rekognition video operation.</p>', 'refs' => [ 'GetCelebrityRecognitionResponse$VideoMetadata' => '<p>Information about a video that Amazon Rekognition Video analyzed. <code>Videometadata</code> is returned in every page of paginated responses from a Amazon Rekognition Video operation.</p>', 'GetContentModerationResponse$VideoMetadata' => '<p>Information about a video that Amazon Rekognition analyzed. <code>Videometadata</code> is returned in every page of paginated responses from <code>GetContentModeration</code>. </p>', 'GetFaceDetectionResponse$VideoMetadata' => '<p>Information about a video that Amazon Rekognition Video analyzed. <code>Videometadata</code> is returned in every page of paginated responses from a Amazon Rekognition video operation.</p>', 'GetFaceSearchResponse$VideoMetadata' => '<p>Information about a video that Amazon Rekognition analyzed. <code>Videometadata</code> is returned in every page of paginated responses from a Amazon Rekognition Video operation. </p>', 'GetLabelDetectionResponse$VideoMetadata' => '<p>Information about a video that Amazon Rekognition Video analyzed. <code>Videometadata</code> is returned in every page of paginated responses from a Amazon Rekognition video operation.</p>', 'GetPersonTrackingResponse$VideoMetadata' => '<p>Information about a video that Amazon Rekognition Video analyzed. <code>Videometadata</code> is returned in every page of paginated responses from a Amazon Rekognition Video operation.</p>', 'GetTextDetectionResponse$VideoMetadata' => NULL, 'VideoMetadataList$member' => NULL, ], ], 'VideoMetadataList' => [ 'base' => NULL, 'refs' => [ 'GetSegmentDetectionResponse$VideoMetadata' => '<p>Currently, Amazon Rekognition Video returns a single object in the <code>VideoMetadata</code> array. The object contains information about the video stream in the input file that Amazon Rekognition Video chose to analyze. The <code>VideoMetadata</code> object includes the video codec, video format and other information. Video metadata is returned in each page of information returned by <code>GetSegmentDetection</code>.</p>', ], ], 'VideoTooLargeException' => [ 'base' => '<p>The file size or duration of the supplied media is too large. The maximum file size is 10GB. The maximum duration is 6 hours. </p>', 'refs' => [], ], ],];
