<?php
// This file was auto-generated from sdk-root/src/data/quicksight/2018-04-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon QuickSight API Reference</fullname> <p>Amazon QuickSight is a fully managed, serverless business intelligence service for the AWS Cloud that makes it easy to extend data and insights to every user in your organization. This API reference contains documentation for a programming interface that you can use to manage Amazon QuickSight. </p>', 'operations' => [ 'CancelIngestion' => '<p>Cancels an ongoing ingestion of data into SPICE.</p>', 'CreateAccountCustomization' => '<p>Creates a customization for the Amazon QuickSight subscription associated with your AWS account.</p>', 'CreateDashboard' => '<p>Creates a dashboard from a template. To first create a template, see the <a>CreateTemplate</a> API operation.</p> <p>A dashboard is an entity in QuickSight that identifies QuickSight reports, created from analyses. You can share QuickSight dashboards. With the right permissions, you can create scheduled email reports from them. The <code>CreateDashboard</code>, <code>DescribeDashboard</code>, and <code>ListDashboardsByUser</code> API operations act on the dashboard entity. If you have the correct permissions, you can create a dashboard from a template that exists in a different AWS account.</p>', 'CreateDataSet' => '<p>Creates a dataset.</p>', 'CreateDataSource' => '<p>Creates a data source.</p>', 'CreateGroup' => '<p>Creates an Amazon QuickSight group.</p> <p>The permissions resource is <code>arn:aws:quicksight:us-east-1:<i>&lt;relevant-aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>.</p> <p>The response is a group object.</p>', 'CreateGroupMembership' => '<p>Adds an Amazon QuickSight user to an Amazon QuickSight group. </p>', 'CreateIAMPolicyAssignment' => '<p>Creates an assignment with one specified IAM policy, identified by its Amazon Resource Name (ARN). This policy will be assigned to specified groups or users of Amazon QuickSight. The users and groups need to be in the same namespace. </p>', 'CreateIngestion' => '<p>Creates and starts a new SPICE ingestion on a dataset</p> <p>Any ingestions operating on tagged datasets inherit the same tags automatically for use in access control. For an example, see <a href="https://aws.amazon.com/premiumsupport/knowledge-center/iam-ec2-resource-tags/">How do I create an IAM policy to control access to Amazon EC2 resources using tags?</a> in the AWS Knowledge Center. Tags are visible on the tagged dataset, but not on the ingestion resource.</p>', 'CreateNamespace' => '<p>(Enterprise edition only) Creates a new namespace for you to use with Amazon QuickSight.</p> <p>A namespace allows you to isolate the QuickSight users and groups that are registered for that namespace. Users that access the namespace can share assets only with other users or groups in the same namespace. They can\'t see users and groups in other namespaces. You can create a namespace after your AWS account is subscribed to QuickSight. The namespace must be unique within the AWS account. By default, there is a limit of 100 namespaces per AWS account. To increase your limit, create a ticket with AWS Support. </p>', 'CreateTemplate' => '<p>Creates a template from an existing QuickSight analysis or template. You can use the resulting template to create a dashboard.</p> <p>A <i>template</i> is an entity in QuickSight that encapsulates the metadata required to create an analysis and that you can use to create s dashboard. A template adds a layer of abstraction by using placeholders to replace the dataset associated with the analysis. You can use templates to create dashboards by replacing dataset placeholders with datasets that follow the same schema that was used to create the source analysis and template.</p>', 'CreateTemplateAlias' => '<p>Creates a template alias for a template.</p>', 'CreateTheme' => '<p>Creates a theme.</p> <p>A <i>theme</i> is set of configuration options for color and layout. Themes apply to analyses and dashboards. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html">Using Themes in Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.</p>', 'CreateThemeAlias' => '<p>Creates a theme alias for a theme.</p>', 'DeleteAccountCustomization' => '<p>Deletes customizations for the QuickSight subscription on your AWS account.</p>', 'DeleteDashboard' => '<p>Deletes a dashboard.</p>', 'DeleteDataSet' => '<p>Deletes a dataset.</p>', 'DeleteDataSource' => '<p>Deletes the data source permanently. This action breaks all the datasets that reference the deleted data source.</p>', 'DeleteGroup' => '<p>Removes a user group from Amazon QuickSight. </p>', 'DeleteGroupMembership' => '<p>Removes a user from a group so that the user is no longer a member of the group.</p>', 'DeleteIAMPolicyAssignment' => '<p>Deletes an existing IAM policy assignment.</p>', 'DeleteNamespace' => '<p>Deletes a namespace and the users and groups that are associated with the namespace. This is an asynchronous process. Assets including dashboards, analyses, datasets and data sources are not deleted. To delete these assets, you use the APIs for the relevant asset. </p>', 'DeleteTemplate' => '<p>Deletes a template.</p>', 'DeleteTemplateAlias' => '<p>Deletes the item that the specified template alias points to. If you provide a specific alias, you delete the version of the template that the alias points to.</p>', 'DeleteTheme' => '<p>Deletes a theme.</p>', 'DeleteThemeAlias' => '<p>Deletes the version of the theme that the specified theme alias points to. If you provide a specific alias, you delete the version of the theme that the alias points to.</p>', 'DeleteUser' => '<p>Deletes the Amazon QuickSight user that is associated with the identity of the AWS Identity and Access Management (IAM) user or role that\'s making the call. The IAM user isn\'t deleted as a result of this call. </p>', 'DeleteUserByPrincipalId' => '<p>Deletes a user identified by its principal ID. </p>', 'DescribeAccountCustomization' => '<p>Describes the customizations associated with your AWS account.</p>', 'DescribeAccountSettings' => '<p>Describes the settings that were used when your QuickSight subscription was first created in this AWS Account.</p>', 'DescribeDashboard' => '<p>Provides a summary for a dashboard.</p>', 'DescribeDashboardPermissions' => '<p>Describes read and write permissions for a dashboard.</p>', 'DescribeDataSet' => '<p>Describes a dataset. </p>', 'DescribeDataSetPermissions' => '<p>Describes the permissions on a dataset.</p> <p>The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/data-set-id</code>.</p>', 'DescribeDataSource' => '<p>Describes a data source.</p>', 'DescribeDataSourcePermissions' => '<p>Describes the resource permissions for a data source.</p>', 'DescribeGroup' => '<p>Returns an Amazon QuickSight group\'s description and Amazon Resource Name (ARN). </p>', 'DescribeIAMPolicyAssignment' => '<p>Describes an existing IAM policy assignment, as specified by the assignment name.</p>', 'DescribeIngestion' => '<p>Describes a SPICE ingestion.</p>', 'DescribeNamespace' => '<p>Describes the current namespace.</p>', 'DescribeTemplate' => '<p>Describes a template\'s metadata.</p>', 'DescribeTemplateAlias' => '<p>Describes the template alias for a template.</p>', 'DescribeTemplatePermissions' => '<p>Describes read and write permissions on a template.</p>', 'DescribeTheme' => '<p>Describes a theme.</p>', 'DescribeThemeAlias' => '<p>Describes the alias for a theme.</p>', 'DescribeThemePermissions' => '<p>Describes the read and write permissions for a theme.</p>', 'DescribeUser' => '<p>Returns information about a user, given the user name. </p>', 'GetDashboardEmbedUrl' => '<p>Generates a URL and authorization code that you can embed in your web server code. Before you use this command, make sure that you have configured the dashboards and permissions. </p> <p>Currently, you can use <code>GetDashboardEmbedURL</code> only from the server, not from the user\'s browser. The following rules apply to the combination of URL and authorization code:</p> <ul> <li> <p>They must be used together.</p> </li> <li> <p>They can be used one time only.</p> </li> <li> <p>They are valid for 5 minutes after you run this command.</p> </li> <li> <p>The resulting user session is valid for 10 hours.</p> </li> </ul> <p> For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedding-dashboards.html">Embedding Amazon QuickSight Dashboards</a> in the <i>Amazon QuickSight User Guide</i> or <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/qs-dev-embedded-dashboards.html">Embedding Amazon QuickSight Dashboards</a> in the <i>Amazon QuickSight API Reference</i>.</p>', 'GetSessionEmbedUrl' => '<p>Generates a session URL and authorization code that you can embed in your web server code. </p>', 'ListDashboardVersions' => '<p>Lists all the versions of the dashboards in the QuickSight subscription.</p>', 'ListDashboards' => '<p>Lists dashboards in an AWS account.</p>', 'ListDataSets' => '<p>Lists all of the datasets belonging to the current AWS account in an AWS Region.</p> <p>The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/*</code>.</p>', 'ListDataSources' => '<p>Lists data sources in current AWS Region that belong to this AWS account.</p>', 'ListGroupMemberships' => '<p>Lists member users in a group.</p>', 'ListGroups' => '<p>Lists all user groups in Amazon QuickSight. </p>', 'ListIAMPolicyAssignments' => '<p>Lists IAM policy assignments in the current Amazon QuickSight account.</p>', 'ListIAMPolicyAssignmentsForUser' => '<p>Lists all the IAM policy assignments, including the Amazon Resource Names (ARNs) for the IAM policies assigned to the specified user and group or groups that the user belongs to.</p>', 'ListIngestions' => '<p>Lists the history of SPICE ingestions for a dataset.</p>', 'ListNamespaces' => '<p>Lists the namespaces for the specified AWS account.</p>', 'ListTagsForResource' => '<p>Lists the tags assigned to a resource.</p>', 'ListTemplateAliases' => '<p>Lists all the aliases of a template.</p>', 'ListTemplateVersions' => '<p>Lists all the versions of the templates in the current Amazon QuickSight account.</p>', 'ListTemplates' => '<p>Lists all the templates in the current Amazon QuickSight account.</p>', 'ListThemeAliases' => '<p>Lists all the aliases of a theme.</p>', 'ListThemeVersions' => '<p>Lists all the versions of the themes in the current AWS account.</p>', 'ListThemes' => '<p>Lists all the themes in the current AWS account.</p>', 'ListUserGroups' => '<p>Lists the Amazon QuickSight groups that an Amazon QuickSight user is a member of.</p>', 'ListUsers' => '<p>Returns a list of all of the Amazon QuickSight users belonging to this account. </p>', 'RegisterUser' => '<p>Creates an Amazon QuickSight user, whose identity is associated with the AWS Identity and Access Management (IAM) identity or role specified in the request. </p>', 'SearchDashboards' => '<p>Searchs for dashboards that belong to a user. </p>', 'TagResource' => '<p>Assigns one or more tags (key-value pairs) to the specified QuickSight resource. </p> <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only resources with certain tag values. You can use the <code>TagResource</code> operation with a resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.</p> <p>You can associate as many as 50 tags with a resource. QuickSight supports tagging on data set, data source, dashboard, and template. </p> <p>Tagging for QuickSight works in a similar way to tagging for other AWS services, except for the following:</p> <ul> <li> <p>You can\'t use tags to track AWS costs for QuickSight. This restriction is because QuickSight costs are based on users and SPICE capacity, which aren\'t taggable resources.</p> </li> <li> <p>QuickSight doesn\'t currently support the Tag Editor for AWS Resource Groups.</p> </li> </ul>', 'UntagResource' => '<p>Removes a tag or tags from a resource.</p>', 'UpdateAccountCustomization' => '<p>Updates customizations associated with the QuickSight subscription on your AWS account.</p>', 'UpdateAccountSettings' => '<p>Updates the settings for the Amazon QuickSight subscription in your AWS Account.</p>', 'UpdateDashboard' => '<p>Updates a dashboard in an AWS account.</p>', 'UpdateDashboardPermissions' => '<p>Updates read and write permissions on a dashboard.</p>', 'UpdateDashboardPublishedVersion' => '<p>Updates the published version of a dashboard.</p>', 'UpdateDataSet' => '<p>Updates a dataset.</p>', 'UpdateDataSetPermissions' => '<p>Updates the permissions on a dataset.</p> <p>The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/data-set-id</code>.</p>', 'UpdateDataSource' => '<p>Updates a data source.</p>', 'UpdateDataSourcePermissions' => '<p>Updates the permissions to a data source.</p>', 'UpdateGroup' => '<p>Changes a group description. </p>', 'UpdateIAMPolicyAssignment' => '<p>Updates an existing IAM policy assignment. This operation updates only the optional parameter or parameters that are specified in the request.</p>', 'UpdateTemplate' => '<p>Updates a template from an existing Amazon QuickSight analysis or another template.</p>', 'UpdateTemplateAlias' => '<p>Updates the template alias of a template.</p>', 'UpdateTemplatePermissions' => '<p>Updates the resource permissions for a template.</p>', 'UpdateTheme' => '<p>Updates a theme.</p>', 'UpdateThemeAlias' => '<p>Updates an alias of a theme.</p>', 'UpdateThemePermissions' => '<p>Updates the resource permissions for a theme. Permissions apply to the action to grant or revoke permissions on, for example <code>"quicksight:DescribeTheme"</code>.</p> <p>Theme permissions apply in groupings. Valid groupings include the following for the three levels of permissions, which are user, owner, or no permissions: </p> <ul> <li> <p>User</p> <ul> <li> <p> <code>"quicksight:DescribeTheme"</code> </p> </li> <li> <p> <code>"quicksight:DescribeThemeAlias"</code> </p> </li> <li> <p> <code>"quicksight:ListThemeAliases"</code> </p> </li> <li> <p> <code>"quicksight:ListThemeVersions"</code> </p> </li> </ul> </li> <li> <p>Owner</p> <ul> <li> <p> <code>"quicksight:DescribeTheme"</code> </p> </li> <li> <p> <code>"quicksight:DescribeThemeAlias"</code> </p> </li> <li> <p> <code>"quicksight:ListThemeAliases"</code> </p> </li> <li> <p> <code>"quicksight:ListThemeVersions"</code> </p> </li> <li> <p> <code>"quicksight:DeleteTheme"</code> </p> </li> <li> <p> <code>"quicksight:UpdateTheme"</code> </p> </li> <li> <p> <code>"quicksight:CreateThemeAlias"</code> </p> </li> <li> <p> <code>"quicksight:DeleteThemeAlias"</code> </p> </li> <li> <p> <code>"quicksight:UpdateThemeAlias"</code> </p> </li> <li> <p> <code>"quicksight:UpdateThemePermissions"</code> </p> </li> <li> <p> <code>"quicksight:DescribeThemePermissions"</code> </p> </li> </ul> </li> <li> <p>To specify no permissions, omit the permissions list.</p> </li> </ul>', 'UpdateUser' => '<p>Updates an Amazon QuickSight user.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You don\'t have access to this item. The provided credentials couldn\'t be validated. You might not be authorized to carry out the request. Make sure that your account is authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and that you are using the correct access keys.</p>', 'refs' => [], ], 'AccountCustomization' => [ 'base' => '<p>The customizations associated with your AWS account for QuickSight.</p>', 'refs' => [ 'CreateAccountCustomizationRequest$AccountCustomization' => '<p>The customizations you\'re adding to the QuickSight subscription for the AWS account. For example, you could add a default theme by setting <code>AccountCustomization</code> to the midnight theme (<code>DefaultTheme="arn:aws:quicksight::aws:theme/MIDNIGHT"</code>) or to a custom theme (<code>DefaultTheme="arn:aws:quicksight:us-west-2:111122223333:theme/bdb844d0-0fe9-4d9d-b520-0fe602d93639"</code>).</p>', 'CreateAccountCustomizationResponse$AccountCustomization' => '<p>The customizations you\'re adding to the QuickSight subscription for the AWS account.</p>', 'DescribeAccountCustomizationResponse$AccountCustomization' => '<p>The customizations associated with QuickSight.</p>', 'UpdateAccountCustomizationRequest$AccountCustomization' => '<p>The customizations you want to update in QuickSight.</p>', 'UpdateAccountCustomizationResponse$AccountCustomization' => '<p>The customizations associated with your QuickSight subscription.</p>', ], ], 'AccountSettings' => [ 'base' => '<p>The QuickSight settings associated with your AWS account.</p>', 'refs' => [ 'DescribeAccountSettingsResponse$AccountSettings' => '<p>The settings associated with the QuickSight subscription associated with this AWS account. This information includes the edition of Amazon QuickSight that you subscribed to (Standard or Enterprise) and the notification email for the QuickSight subscription. The QuickSight console, the QuickSight subscription is sometimes referred to as a QuickSight "account" even though it is technically not an account, but a subscription in your AWS account.</p>', ], ], 'ActionList' => [ 'base' => NULL, 'refs' => [ 'ResourcePermission$Actions' => '<p>The action to grant or revoke permissions on, for example <code>"quicksight:DescribeDashboard"</code>.</p>', ], ], 'ActiveIAMPolicyAssignment' => [ 'base' => '<p>The active AWS Identity and Access Management (IAM) policy assignment.</p>', 'refs' => [ 'ActiveIAMPolicyAssignmentList$member' => NULL, ], ], 'ActiveIAMPolicyAssignmentList' => [ 'base' => NULL, 'refs' => [ 'ListIAMPolicyAssignmentsForUserResponse$ActiveAssignments' => '<p>The active assignments for this user.</p>', ], ], 'AdHocFilteringOption' => [ 'base' => '<p>Ad hoc (one-time) filtering option.</p>', 'refs' => [ 'DashboardPublishOptions$AdHocFilteringOption' => '<p>Ad hoc (one-time) filtering option.</p>', ], ], 'AliasName' => [ 'base' => NULL, 'refs' => [ 'CreateTemplateAliasRequest$AliasName' => '<p>The name that you want to give to the template alias that you\'re creating. Don\'t start the alias name with the <code>$</code> character. Alias names that start with <code>$</code> are reserved by QuickSight. </p>', 'CreateThemeAliasRequest$AliasName' => '<p>The name that you want to give to the theme alias that you are creating. The alias name can\'t begin with a <code>$</code>. Alias names that start with <code>$</code> are reserved by Amazon QuickSight. </p>', 'DeleteTemplateAliasRequest$AliasName' => '<p>The name for the template alias. To delete a specific alias, you delete the version that the alias points to. You can specify the alias name, or specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. </p>', 'DeleteTemplateAliasResponse$AliasName' => '<p>The name for the template alias.</p>', 'DeleteThemeAliasRequest$AliasName' => '<p>The unique name for the theme alias to delete.</p>', 'DeleteThemeAliasResponse$AliasName' => '<p>The name for the theme alias.</p>', 'DescribeDashboardRequest$AliasName' => '<p>The alias name.</p>', 'DescribeTemplateAliasRequest$AliasName' => '<p>The name of the template alias that you want to describe. If you name a specific alias, you describe the version that the alias points to. You can specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn\'t apply to templates.</p>', 'DescribeTemplateRequest$AliasName' => '<p>The alias of the template that you want to describe. If you name a specific alias, you describe the version that the alias points to. You can specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn\'t apply to templates.</p>', 'DescribeThemeAliasRequest$AliasName' => '<p>The name of the theme alias that you want to describe.</p>', 'DescribeThemeRequest$AliasName' => '<p>The alias of the theme that you want to describe. If you name a specific alias, you describe the version that the alias points to. You can specify the latest version of the theme by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn\'t apply to themes.</p>', 'TemplateAlias$AliasName' => '<p>The display name of the template alias.</p>', 'ThemeAlias$AliasName' => '<p>The display name of the theme alias.</p>', 'UpdateTemplateAliasRequest$AliasName' => '<p>The alias of the template that you want to update. If you name a specific alias, you update the version that the alias points to. You can specify the latest version of the template by providing the keyword <code>$LATEST</code> in the <code>AliasName</code> parameter. The keyword <code>$PUBLISHED</code> doesn\'t apply to templates.</p>', 'UpdateThemeAliasRequest$AliasName' => '<p>The name of the theme alias that you want to update.</p>', ], ], 'AmazonElasticsearchParameters' => [ 'base' => '<p>Amazon Elasticsearch Service parameters.</p>', 'refs' => [ 'DataSourceParameters$AmazonElasticsearchParameters' => '<p>Amazon Elasticsearch Service parameters.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'AccountCustomization$DefaultTheme' => '<p>The default theme for this QuickSight subscription.</p>', 'ActiveIAMPolicyAssignment$PolicyArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'CancelIngestionResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the data ingestion.</p>', 'CreateDashboardRequest$ThemeArn' => '<p>The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If you add a value for this field, it overrides the value that is used in the source entity. The theme ARN must exist in the same AWS account where you create the dashboard.</p>', 'CreateDashboardResponse$Arn' => '<p>The ARN of the dashboard.</p>', 'CreateDashboardResponse$VersionArn' => '<p>The ARN of the dashboard, including the version number of the first version that is created.</p>', 'CreateDataSetResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'CreateDataSetResponse$IngestionArn' => '<p>The ARN for the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>', 'CreateDataSourceResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the data source.</p>', 'CreateIAMPolicyAssignmentRequest$PolicyArn' => '<p>The ARN for the IAM policy to apply to the QuickSight users and groups specified in this assignment.</p>', 'CreateIAMPolicyAssignmentResponse$PolicyArn' => '<p>The ARN for the IAM policy that is applied to the QuickSight users and groups specified in this assignment.</p>', 'CreateIngestionResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the data ingestion.</p>', 'CreateNamespaceResponse$Arn' => '<p>The ARN of the QuickSight namespace you created. </p>', 'CreateTemplateResponse$Arn' => '<p>The ARN for the template.</p>', 'CreateTemplateResponse$VersionArn' => '<p>The ARN for the template, including the version information of the first version.</p>', 'CreateThemeResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the theme.</p>', 'CreateThemeResponse$VersionArn' => '<p>The Amazon Resource Name (ARN) for the new theme.</p>', 'CustomSql$DataSourceArn' => '<p>The Amazon Resource Name (ARN) of the data source.</p>', 'Dashboard$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'DashboardSourceTemplate$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'DashboardSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'DashboardVersion$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'DashboardVersion$SourceEntityArn' => '<p>Source entity ARN.</p>', 'DashboardVersionSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'DashboardVersionSummary$SourceEntityArn' => '<p>Source entity ARN.</p>', 'DataSet$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'DataSetArnsList$member' => NULL, 'DataSetReference$DataSetArn' => '<p>Dataset Amazon Resource Name (ARN).</p>', 'DataSetSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'DataSource$Arn' => '<p>The Amazon Resource Name (ARN) of the data source.</p>', 'DeleteDashboardResponse$Arn' => '<p>The Secure Socket Layer (SSL) properties that apply for the resource.</p>', 'DeleteDataSetResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'DeleteDataSourceResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the data source that you deleted.</p>', 'DeleteTemplateAliasResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the template you want to delete.</p>', 'DeleteTemplateResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'DeleteThemeAliasResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the theme resource using the deleted alias.</p>', 'DeleteThemeResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'DescribeDashboardPermissionsResponse$DashboardArn' => '<p>The Amazon Resource Name (ARN) of the dashboard.</p>', 'DescribeDataSetPermissionsResponse$DataSetArn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'DescribeDataSourcePermissionsResponse$DataSourceArn' => '<p>The Amazon Resource Name (ARN) of the data source.</p>', 'DescribeTemplatePermissionsResponse$TemplateArn' => '<p>The Amazon Resource Name (ARN) of the template.</p>', 'DescribeThemePermissionsResponse$ThemeArn' => '<p>The Amazon Resource Name (ARN) of the theme.</p>', 'GetDashboardEmbedUrlRequest$UserArn' => '<p>The Amazon QuickSight user\'s Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity type. You can use this for any Amazon QuickSight users in your account (readers, authors, or admins) authenticated as one of the following:</p> <ul> <li> <p>Active Directory (AD) users or group members</p> </li> <li> <p>Invited nonfederated users</p> </li> <li> <p>IAM users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML, OpenID Connect, or IAM federation.</p> </li> </ul>', 'GetSessionEmbedUrlRequest$UserArn' => '<p>The Amazon QuickSight user\'s Amazon Resource Name (ARN), for use with <code>QUICKSIGHT</code> identity type. You can use this for any Amazon QuickSight users in your account (readers, authors, or admins) authenticated as one of the following:</p> <ul> <li> <p>Active Directory (AD) users or group members</p> </li> <li> <p>Invited nonfederated users</p> </li> <li> <p>IAM users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML, OpenID Connect, or IAM federation.</p> </li> </ul>', 'Group$Arn' => '<p>The Amazon Resource Name (ARN) for the group.</p>', 'GroupMember$Arn' => '<p>The Amazon Resource Name (ARN) for the group member (user).</p>', 'IAMPolicyAssignment$PolicyArn' => '<p>The Amazon Resource Name (ARN) for the IAM policy.</p>', 'Ingestion$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want a list of tags for.</p>', 'NamespaceInfoV2$Arn' => '<p>The namespace ARN.</p>', 'RelationalTable$DataSourceArn' => '<p>The Amazon Resource Name (ARN) for the data source.</p>', 'RowLevelPermissionDataSet$Arn' => '<p>The Amazon Resource Name (ARN) of the permission dataset.</p>', 'S3Source$DataSourceArn' => '<p>The amazon Resource Name (ARN) for the data source.</p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want to tag.</p>', 'Template$Arn' => '<p>The Amazon Resource Name (ARN) of the template.</p>', 'TemplateAlias$Arn' => '<p>The Amazon Resource Name (ARN) of the template alias.</p>', 'TemplateSourceAnalysis$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'TemplateSourceTemplate$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'TemplateSummary$Arn' => '<p>A summary of a template.</p>', 'TemplateVersion$SourceEntityArn' => '<p>The Amazon Resource Name (ARN) of the analysis or template which was used to create this template.</p>', 'TemplateVersionSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the template version.</p>', 'Theme$Arn' => '<p>The Amazon Resource Name (ARN) of the theme.</p>', 'ThemeAlias$Arn' => '<p>The Amazon Resource Name (ARN) of the theme alias.</p>', 'ThemeSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'ThemeVersion$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'ThemeVersionSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the theme version.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want to untag.</p>', 'UpdateDashboardPermissionsResponse$DashboardArn' => '<p>The Amazon Resource Name (ARN) of the dashboard.</p>', 'UpdateDashboardPublishedVersionResponse$DashboardArn' => '<p>The Amazon Resource Name (ARN) of the dashboard.</p>', 'UpdateDashboardRequest$ThemeArn' => '<p>The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If you add a value for this field, it overrides the value that was originally associated with the entity. The theme ARN must exist in the same AWS account where you create the dashboard.</p>', 'UpdateDashboardResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'UpdateDashboardResponse$VersionArn' => '<p>The ARN of the dashboard, including the version number.</p>', 'UpdateDataSetPermissionsResponse$DataSetArn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'UpdateDataSetResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'UpdateDataSetResponse$IngestionArn' => '<p>The ARN for the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>', 'UpdateDataSourcePermissionsResponse$DataSourceArn' => '<p>The Amazon Resource Name (ARN) of the data source.</p>', 'UpdateDataSourceResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the data source.</p>', 'UpdateIAMPolicyAssignmentRequest$PolicyArn' => '<p>The ARN for the IAM policy to apply to the QuickSight users and groups specified in this assignment.</p>', 'UpdateIAMPolicyAssignmentResponse$PolicyArn' => '<p>The ARN for the IAM policy applied to the QuickSight users and groups specified in this assignment.</p>', 'UpdateTemplatePermissionsResponse$TemplateArn' => '<p>The Amazon Resource Name (ARN) of the template.</p>', 'UpdateTemplateResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the template.</p>', 'UpdateTemplateResponse$VersionArn' => '<p>The ARN for the template, including the version information of the first version.</p>', 'UpdateThemePermissionsResponse$ThemeArn' => '<p>The Amazon Resource Name (ARN) of the theme.</p>', 'UpdateThemeResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the theme.</p>', 'UpdateThemeResponse$VersionArn' => '<p>The Amazon Resource Name (ARN) for the new version of the theme.</p>', 'User$Arn' => '<p>The Amazon Resource Name (ARN) for the user.</p>', 'VpcConnectionProperties$VpcConnectionArn' => '<p>The Amazon Resource Name (ARN) for the VPC connection.</p>', ], ], 'AssignmentStatus' => [ 'base' => NULL, 'refs' => [ 'CreateIAMPolicyAssignmentRequest$AssignmentStatus' => '<p>The status of the assignment. Possible values are as follows:</p> <ul> <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li> <li> <p> <code>DISABLED</code> - This assignment isn\'t used when creating the data source.</p> </li> <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn\'t used when creating the data source.</p> </li> </ul>', 'CreateIAMPolicyAssignmentResponse$AssignmentStatus' => '<p>The status of the assignment. Possible values are as follows:</p> <ul> <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li> <li> <p> <code>DISABLED</code> - This assignment isn\'t used when creating the data source.</p> </li> <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn\'t used when creating the data source.</p> </li> </ul>', 'IAMPolicyAssignment$AssignmentStatus' => '<p>Assignment status.</p>', 'IAMPolicyAssignmentSummary$AssignmentStatus' => '<p>Assignment status.</p>', 'ListIAMPolicyAssignmentsRequest$AssignmentStatus' => '<p>The status of the assignments.</p>', 'UpdateIAMPolicyAssignmentRequest$AssignmentStatus' => '<p>The status of the assignment. Possible values are as follows:</p> <ul> <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li> <li> <p> <code>DISABLED</code> - This assignment isn\'t used when creating the data source.</p> </li> <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn\'t used when creating the data source.</p> </li> </ul>', 'UpdateIAMPolicyAssignmentResponse$AssignmentStatus' => '<p>The status of the assignment. Possible values are as follows:</p> <ul> <li> <p> <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.</p> </li> <li> <p> <code>DISABLED</code> - This assignment isn\'t used when creating the data source.</p> </li> <li> <p> <code>DRAFT</code> - This assignment is an unfinished draft and isn\'t used when creating the data source.</p> </li> </ul>', ], ], 'AthenaParameters' => [ 'base' => '<p>Amazon Athena parameters.</p>', 'refs' => [ 'DataSourceParameters$AthenaParameters' => '<p>Amazon Athena parameters.</p>', ], ], 'AuroraParameters' => [ 'base' => '<p>Amazon Aurora parameters.</p>', 'refs' => [ 'DataSourceParameters$AuroraParameters' => '<p>Amazon Aurora MySQL parameters.</p>', ], ], 'AuroraPostgreSqlParameters' => [ 'base' => '<p>Amazon Aurora with PostgreSQL compatibility parameters.</p>', 'refs' => [ 'DataSourceParameters$AuroraPostgreSqlParameters' => '<p>Aurora PostgreSQL parameters.</p>', ], ], 'AwsAccountId' => [ 'base' => NULL, 'refs' => [ 'CancelIngestionRequest$AwsAccountId' => '<p>The AWS account ID.</p>', 'CreateAccountCustomizationRequest$AwsAccountId' => '<p>The ID for the AWS account that you want to customize QuickSight for.</p>', 'CreateAccountCustomizationResponse$AwsAccountId' => '<p>The ID for the AWS account that you want to customize QuickSight for.</p>', 'CreateDashboardRequest$AwsAccountId' => '<p>The ID of the AWS account where you want to create the dashboard.</p>', 'CreateDataSetRequest$AwsAccountId' => '<p>The AWS account ID.</p>', 'CreateDataSourceRequest$AwsAccountId' => '<p>The AWS account ID.</p>', 'CreateGroupMembershipRequest$AwsAccountId' => '<p>The ID for the AWS account that the group is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.</p>', 'CreateGroupRequest$AwsAccountId' => '<p>The ID for the AWS account that the group is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.</p>', 'CreateIAMPolicyAssignmentRequest$AwsAccountId' => '<p>The ID of the AWS account where you want to assign an IAM policy to QuickSight users or groups.</p>', 'CreateIngestionRequest$AwsAccountId' => '<p>The AWS account ID.</p>', 'CreateNamespaceRequest$AwsAccountId' => '<p>The ID for the AWS account that you want to create the QuickSight namespace in.</p>', 'CreateTemplateAliasRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the template that you creating an alias for.</p>', 'CreateTemplateRequest$AwsAccountId' => '<p>The ID for the AWS account that the group is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.</p>', 'CreateThemeAliasRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the theme for the new theme alias.</p>', 'CreateThemeRequest$AwsAccountId' => '<p>The ID of the AWS account where you want to store the new theme. </p>', 'DeleteAccountCustomizationRequest$AwsAccountId' => '<p>The ID for the AWS account that you want to delete QuickSight customizations from.</p>', 'DeleteDashboardRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the dashboard that you\'re deleting.</p>', 'DeleteDataSetRequest$AwsAccountId' => '<p>The AWS account ID.</p>', 'DeleteDataSourceRequest$AwsAccountId' => '<p>The AWS account ID.</p>', 'DeleteGroupMembershipRequest$AwsAccountId' => '<p>The ID for the AWS account that the group is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.</p>', 'DeleteGroupRequest$AwsAccountId' => '<p>The ID for the AWS account that the group is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.</p>', 'DeleteIAMPolicyAssignmentRequest$AwsAccountId' => '<p>The AWS account ID where you want to delete the IAM policy assignment.</p>', 'DeleteNamespaceRequest$AwsAccountId' => '<p>The ID for the AWS account that you want to delete the QuickSight namespace from.</p>', 'DeleteTemplateAliasRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the item to delete.</p>', 'DeleteTemplateRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the template that you\'re deleting.</p>', 'DeleteThemeAliasRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the theme alias to delete.</p>', 'DeleteThemeRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the theme that you\'re deleting.</p>', 'DeleteUserByPrincipalIdRequest$AwsAccountId' => '<p>The ID for the AWS account that the user is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.</p>', 'DeleteUserRequest$AwsAccountId' => '<p>The ID for the AWS account that the user is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.</p>', 'DescribeAccountCustomizationRequest$AwsAccountId' => '<p>The ID for the AWS account that you want to describe QuickSight customizations for.</p>', 'DescribeAccountCustomizationResponse$AwsAccountId' => '<p>The ID for the AWS account that you want to describe QuickSight customizations for.</p>', 'DescribeAccountSettingsRequest$AwsAccountId' => '<p>The ID for the AWS account that contains the QuickSight namespaces that you want to list.</p>', 'DescribeDashboardPermissionsRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the dashboard that you\'re describing permissions for.</p>', 'DescribeDashboardRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the dashboard that you\'re describing.</p>', 'DescribeDataSetPermissionsRequest$AwsAccountId' => '<p>The AWS account ID.</p>', 'DescribeDataSetRequest$AwsAccountId' => '<p>The AWS account ID.</p>', 'DescribeDataSourcePermissionsRequest$AwsAccountId' => '<p>The AWS account ID.</p>', 'DescribeDataSourceRequest$AwsAccountId' => '<p>The AWS account ID.</p>', 'DescribeGroupRequest$AwsAccountId' => '<p>The ID for the AWS account that the group is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.</p>', 'DescribeIAMPolicyAssignmentRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the assignment that you want to describe.</p>', 'DescribeIngestionRequest$AwsAccountId' => '<p>The AWS account ID.</p>', 'DescribeNamespaceRequest$AwsAccountId' => '<p>The ID for the AWS account that contains the QuickSight namespace that you want to describe.</p>', 'DescribeTemplateAliasRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the template alias that you\'re describing.</p>', 'DescribeTemplatePermissionsRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the template that you\'re describing.</p>', 'DescribeTemplateRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the template that you\'re describing.</p>', 'DescribeThemeAliasRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the theme alias that you\'re describing.</p>', 'DescribeThemePermissionsRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the theme that you\'re describing.</p>', 'DescribeUserRequest$AwsAccountId' => '<p>The ID for the AWS account that the user is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.</p>', 'GetDashboardEmbedUrlRequest$AwsAccountId' => '<p>The ID for the AWS account that contains the dashboard that you\'re embedding.</p>', 'GetSessionEmbedUrlRequest$AwsAccountId' => '<p>The ID for the AWS account that contains the QuickSight session that you\'re embedding.</p>', 'IAMPolicyAssignment$AwsAccountId' => '<p>The AWS account ID.</p>', 'ListDashboardVersionsRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the dashboard that you\'re listing versions for.</p>', 'ListDashboardsRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the dashboards that you\'re listing.</p>', 'ListDataSetsRequest$AwsAccountId' => '<p>The AWS account ID.</p>', 'ListDataSourcesRequest$AwsAccountId' => '<p>The AWS account ID.</p>', 'ListGroupMembershipsRequest$AwsAccountId' => '<p>The ID for the AWS account that the group is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.</p>', 'ListGroupsRequest$AwsAccountId' => '<p>The ID for the AWS account that the group is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.</p>', 'ListIAMPolicyAssignmentsForUserRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the assignments.</p>', 'ListIAMPolicyAssignmentsRequest$AwsAccountId' => '<p>The ID of the AWS account that contains these IAM policy assignments.</p>', 'ListIngestionsRequest$AwsAccountId' => '<p>The AWS account ID.</p>', 'ListNamespacesRequest$AwsAccountId' => '<p>The ID for the AWS account that contains the QuickSight namespaces that you want to list.</p>', 'ListTemplateAliasesRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the template aliases that you\'re listing.</p>', 'ListTemplateVersionsRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the templates that you\'re listing.</p>', 'ListTemplatesRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the templates that you\'re listing.</p>', 'ListThemeAliasesRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the theme aliases that you\'re listing.</p>', 'ListThemeVersionsRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the themes that you\'re listing.</p>', 'ListThemesRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the themes that you\'re listing.</p>', 'ListUserGroupsRequest$AwsAccountId' => '<p>The AWS account ID that the user is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.</p>', 'ListUsersRequest$AwsAccountId' => '<p>The ID for the AWS account that the user is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.</p>', 'RegisterUserRequest$AwsAccountId' => '<p>The ID for the AWS account that the user is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.</p>', 'SearchDashboardsRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the user whose dashboards you\'re searching for. </p>', 'UpdateAccountCustomizationRequest$AwsAccountId' => '<p>The ID for the AWS account that you want to update QuickSight customizations for.</p>', 'UpdateAccountCustomizationResponse$AwsAccountId' => '<p>The ID for the AWS account that you want to update QuickSight customizations for.</p>', 'UpdateAccountSettingsRequest$AwsAccountId' => '<p>The ID for the AWS account that contains the QuickSight namespaces that you want to list.</p>', 'UpdateDashboardPermissionsRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the dashboard whose permissions you\'re updating.</p>', 'UpdateDashboardPublishedVersionRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the dashboard that you\'re updating.</p>', 'UpdateDashboardRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the dashboard that you\'re updating.</p>', 'UpdateDataSetPermissionsRequest$AwsAccountId' => '<p>The AWS account ID.</p>', 'UpdateDataSetRequest$AwsAccountId' => '<p>The AWS account ID.</p>', 'UpdateDataSourcePermissionsRequest$AwsAccountId' => '<p>The AWS account ID.</p>', 'UpdateDataSourceRequest$AwsAccountId' => '<p>The AWS account ID.</p>', 'UpdateGroupRequest$AwsAccountId' => '<p>The ID for the AWS account that the group is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.</p>', 'UpdateIAMPolicyAssignmentRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the IAM policy assignment.</p>', 'UpdateTemplateAliasRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the template alias that you\'re updating.</p>', 'UpdateTemplatePermissionsRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the template.</p>', 'UpdateTemplateRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the template that you\'re updating.</p>', 'UpdateThemeAliasRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the theme alias that you\'re updating.</p>', 'UpdateThemePermissionsRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the theme.</p>', 'UpdateThemeRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the theme that you\'re updating.</p>', 'UpdateUserRequest$AwsAccountId' => '<p>The ID for the AWS account that the user is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.</p>', ], ], 'AwsAndAccountId' => [ 'base' => NULL, 'refs' => [ 'DescribeThemeRequest$AwsAccountId' => '<p>The ID of the AWS account that contains the theme that you\'re describing.</p>', ], ], 'AwsIotAnalyticsParameters' => [ 'base' => '<p>AWS IoT Analytics parameters.</p>', 'refs' => [ 'DataSourceParameters$AwsIotAnalyticsParameters' => '<p>AWS IoT Analytics parameters.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'SslProperties$DisableSsl' => '<p>A Boolean option to control whether SSL should be disabled.</p>', 'UpdateUserRequest$UnapplyCustomPermissions' => '<p>A flag that you use to indicate that you want to remove all custom permissions from this user. Using this parameter resets the user to the state it was in before a custom permissions profile was applied. This parameter defaults to NULL and it doesn\'t accept any other value.</p>', 'UploadSettings$ContainsHeader' => '<p>Whether the file has a header row, or the files each have a header row.</p>', 'User$Active' => '<p>The active status of user. When you create an Amazon QuickSight user that’s not an IAM user or an Active Directory user, that user is inactive until they sign in and provide a password.</p>', ], ], 'BorderStyle' => [ 'base' => '<p>The display options for tile borders for visuals.</p>', 'refs' => [ 'TileStyle$Border' => '<p>The border around a tile.</p>', ], ], 'CalculatedColumn' => [ 'base' => '<p>A calculated column for a dataset.</p>', 'refs' => [ 'CalculatedColumnList$member' => NULL, ], ], 'CalculatedColumnList' => [ 'base' => NULL, 'refs' => [ 'CreateColumnsOperation$Columns' => '<p>Calculated columns to create.</p>', ], ], 'CancelIngestionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelIngestionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CastColumnTypeOperation' => [ 'base' => '<p>A transform operation that casts a column to a different type.</p>', 'refs' => [ 'TransformOperation$CastColumnTypeOperation' => '<p>A transform operation that casts a column to a different type.</p>', ], ], 'Catalog' => [ 'base' => NULL, 'refs' => [ 'PrestoParameters$Catalog' => '<p>Catalog.</p>', ], ], 'ClusterId' => [ 'base' => NULL, 'refs' => [ 'RedshiftParameters$ClusterId' => '<p>Cluster ID. This field can be blank if the <code>Host</code> and <code>Port</code> are provided.</p>', ], ], 'ColorList' => [ 'base' => NULL, 'refs' => [ 'DataColorPalette$Colors' => '<p>The hexadecimal codes for the colors.</p>', 'DataColorPalette$MinMaxGradient' => '<p>The minimum and maximum hexadecimal codes that describe a color gradient. </p>', ], ], 'ColumnDataType' => [ 'base' => NULL, 'refs' => [ 'CastColumnTypeOperation$NewColumnType' => '<p>New column data type.</p>', 'OutputColumn$Type' => '<p>Type.</p>', ], ], 'ColumnGroup' => [ 'base' => '<p>Groupings of columns that work together in certain Amazon QuickSight features. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.</p>', 'refs' => [ 'ColumnGroupList$member' => NULL, ], ], 'ColumnGroupColumnSchema' => [ 'base' => '<p>A structure describing the name, data type, and geographic role of the columns.</p>', 'refs' => [ 'ColumnGroupColumnSchemaList$member' => NULL, ], ], 'ColumnGroupColumnSchemaList' => [ 'base' => NULL, 'refs' => [ 'ColumnGroupSchema$ColumnGroupColumnSchemaList' => '<p>A structure containing the list of schemas for column group columns.</p>', ], ], 'ColumnGroupList' => [ 'base' => NULL, 'refs' => [ 'CreateDataSetRequest$ColumnGroups' => '<p>Groupings of columns that work together in certain QuickSight features. Currently, only geospatial hierarchy is supported.</p>', 'DataSet$ColumnGroups' => '<p>Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported.</p>', 'UpdateDataSetRequest$ColumnGroups' => '<p>Groupings of columns that work together in certain QuickSight features. Currently, only geospatial hierarchy is supported.</p>', ], ], 'ColumnGroupName' => [ 'base' => NULL, 'refs' => [ 'GeoSpatialColumnGroup$Name' => '<p>A display name for the hierarchy.</p>', ], ], 'ColumnGroupSchema' => [ 'base' => '<p>The column group schema.</p>', 'refs' => [ 'ColumnGroupSchemaList$member' => NULL, ], ], 'ColumnGroupSchemaList' => [ 'base' => NULL, 'refs' => [ 'DataSetConfiguration$ColumnGroupSchemaList' => '<p>A structure containing the list of column group schemas.</p>', ], ], 'ColumnId' => [ 'base' => NULL, 'refs' => [ 'CalculatedColumn$ColumnId' => '<p>A unique ID to identify a calculated column. During a dataset update, if the column ID of a calculated column matches that of an existing calculated column, Amazon QuickSight preserves the existing calculated column.</p>', ], ], 'ColumnList' => [ 'base' => NULL, 'refs' => [ 'GeoSpatialColumnGroup$Columns' => '<p>Columns in this hierarchy.</p>', ], ], 'ColumnName' => [ 'base' => NULL, 'refs' => [ 'CalculatedColumn$ColumnName' => '<p>Column name.</p>', 'CastColumnTypeOperation$ColumnName' => '<p>Column name.</p>', 'ColumnList$member' => NULL, 'InputColumn$Name' => '<p>The name of this column in the underlying data source.</p>', 'OutputColumn$Name' => '<p>A display name for the dataset.</p>', 'RenameColumnOperation$ColumnName' => '<p>The name of the column to be renamed.</p>', 'RenameColumnOperation$NewColumnName' => '<p>The new name for the column.</p>', 'TagColumnOperation$ColumnName' => '<p>The column that this operation acts on.</p>', ], ], 'ColumnSchema' => [ 'base' => '<p>The column schema.</p>', 'refs' => [ 'ColumnSchemaList$member' => NULL, ], ], 'ColumnSchemaList' => [ 'base' => NULL, 'refs' => [ 'DataSetSchema$ColumnSchemaList' => '<p>A structure containing the list of column schemas.</p>', ], ], 'ColumnTag' => [ 'base' => '<p>A tag for a column in a <a>TagColumnOperation</a> structure. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.</p>', 'refs' => [ 'ColumnTagList$member' => NULL, ], ], 'ColumnTagList' => [ 'base' => NULL, 'refs' => [ 'TagColumnOperation$Tags' => '<p>The dataset column tag, currently only used for geospatial type tagging. .</p> <note> <p>This is not tags for the AWS tagging feature. .</p> </note>', ], ], 'ConcurrentUpdatingException' => [ 'base' => '<p>A resource is already in a state that indicates an action is happening that must complete before a new update can be applied.</p>', 'refs' => [], ], 'ConflictException' => [ 'base' => '<p>Updating or deleting a resource can cause an inconsistent state.</p>', 'refs' => [], ], 'CopySourceArn' => [ 'base' => NULL, 'refs' => [ 'DataSourceCredentials$CopySourceArn' => '<p>The Amazon Resource Name (ARN) of a data source that has the credential pair that you want to use. When <code>CopySourceArn</code> is not null, the credential pair from the data source in the ARN is used as the credentials for the <code>DataSourceCredentials</code> structure.</p>', ], ], 'CreateAccountCustomizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccountCustomizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateColumnsOperation' => [ 'base' => '<p>A transform operation that creates calculated columns. Columns created in one such operation form a lexical closure.</p>', 'refs' => [ 'TransformOperation$CreateColumnsOperation' => '<p>An operation that creates calculated columns. Columns created in one such operation form a lexical closure.</p>', ], ], 'CreateDashboardRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDashboardResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateGroupMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateGroupMembershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateGroupRequest' => [ 'base' => '<p>The request object for this operation. </p>', 'refs' => [], ], 'CreateGroupResponse' => [ 'base' => '<p>The response object for this operation.</p>', 'refs' => [], ], 'CreateIAMPolicyAssignmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIAMPolicyAssignmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateIngestionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIngestionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateNamespaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateNamespaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTemplateAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTemplateAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateThemeAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateThemeAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateThemeRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateThemeResponse' => [ 'base' => NULL, 'refs' => [], ], 'CredentialPair' => [ 'base' => '<p>The combination of user name and password that are used as credentials.</p>', 'refs' => [ 'DataSourceCredentials$CredentialPair' => '<p>Credential pair. For more information, see <a>CredentialPair</a>.</p>', ], ], 'CustomSql' => [ 'base' => '<p>A physical table type built from the results of the custom SQL query.</p>', 'refs' => [ 'PhysicalTable$CustomSql' => '<p>A physical table type built from the results of the custom SQL query.</p>', ], ], 'CustomSqlName' => [ 'base' => NULL, 'refs' => [ 'CustomSql$Name' => '<p>A display name for the SQL query result.</p>', ], ], 'Dashboard' => [ 'base' => '<p>Dashboard.</p>', 'refs' => [ 'DescribeDashboardResponse$Dashboard' => '<p>Information about the dashboard.</p>', ], ], 'DashboardBehavior' => [ 'base' => NULL, 'refs' => [ 'AdHocFilteringOption$AvailabilityStatus' => '<p>Availability status.</p>', 'ExportToCSVOption$AvailabilityStatus' => '<p>Availability status.</p>', ], ], 'DashboardError' => [ 'base' => '<p>Dashboard error.</p>', 'refs' => [ 'DashboardErrorList$member' => NULL, ], ], 'DashboardErrorList' => [ 'base' => NULL, 'refs' => [ 'DashboardVersion$Errors' => '<p>Errors.</p>', ], ], 'DashboardErrorType' => [ 'base' => NULL, 'refs' => [ 'DashboardError$Type' => '<p>Type.</p>', ], ], 'DashboardFilterAttribute' => [ 'base' => NULL, 'refs' => [ 'DashboardSearchFilter$Name' => '<p>The name of the value that you want to use as a filter, for example, <code>"Name": "QUICKSIGHT_USER"</code>. </p>', ], ], 'DashboardName' => [ 'base' => NULL, 'refs' => [ 'CreateDashboardRequest$Name' => '<p>The display name of the dashboard.</p>', 'Dashboard$Name' => '<p>A display name for the dashboard.</p>', 'DashboardSummary$Name' => '<p>A display name for the dashboard.</p>', 'UpdateDashboardRequest$Name' => '<p>The display name of the dashboard.</p>', ], ], 'DashboardPublishOptions' => [ 'base' => '<p>Dashboard publish options.</p>', 'refs' => [ 'CreateDashboardRequest$DashboardPublishOptions' => '<p>Options for publishing the dashboard when you create it:</p> <ul> <li> <p> <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is <code>ENABLED</code> by default. </p> </li> <li> <p> <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .csv format isn\'t enabled when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default. </p> </li> <li> <p> <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by default. </p> </li> </ul>', 'UpdateDashboardRequest$DashboardPublishOptions' => '<p>Options for publishing the dashboard when you create it:</p> <ul> <li> <p> <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is <code>ENABLED</code> by default. </p> </li> <li> <p> <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .csv format isn\'t enabled when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default. </p> </li> <li> <p> <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by default. </p> </li> </ul>', ], ], 'DashboardSearchFilter' => [ 'base' => '<p>A filter that you apply when searching for dashboards. </p>', 'refs' => [ 'DashboardSearchFilterList$member' => NULL, ], ], 'DashboardSearchFilterList' => [ 'base' => NULL, 'refs' => [ 'SearchDashboardsRequest$Filters' => '<p>The filters to apply to the search. Currently, you can search only by user name, for example, <code>"Filters": [ { "Name": "QUICKSIGHT_USER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1" } ]</code> </p>', ], ], 'DashboardSourceEntity' => [ 'base' => '<p>Dashboard source entity.</p>', 'refs' => [ 'CreateDashboardRequest$SourceEntity' => '<p>The entity that you are using as a source when you create the dashboard. In <code>SourceEntity</code>, you specify the type of object you\'re using as source. You can only create a dashboard from a template, so you use a <code>SourceTemplate</code> entity. If you need to create a dashboard from an analysis, first convert the analysis to a template by using the <a>CreateTemplate</a> API operation. For <code>SourceTemplate</code>, specify the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code>ARN can contain any AWS Account and any QuickSight-supported AWS Region. </p> <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p>', 'UpdateDashboardRequest$SourceEntity' => '<p>The entity that you are using as a source when you update the dashboard. In <code>SourceEntity</code>, you specify the type of object you\'re using as source. You can only update a dashboard from a template, so you use a <code>SourceTemplate</code> entity. If you need to update a dashboard from an analysis, first convert the analysis to a template by using the <a>CreateTemplate</a> API operation. For <code>SourceTemplate</code>, specify the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code> ARN can contain any AWS Account and any QuickSight-supported AWS Region. </p> <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p>', ], ], 'DashboardSourceTemplate' => [ 'base' => '<p>Dashboard source template.</p>', 'refs' => [ 'DashboardSourceEntity$SourceTemplate' => '<p>Source template.</p>', ], ], 'DashboardSummary' => [ 'base' => '<p>Dashboard summary.</p>', 'refs' => [ 'DashboardSummaryList$member' => NULL, ], ], 'DashboardSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListDashboardsResponse$DashboardSummaryList' => '<p>A structure that contains all of the dashboards in your AWS account. This structure provides basic information about the dashboards.</p>', 'SearchDashboardsResponse$DashboardSummaryList' => '<p>The list of dashboards owned by the user specified in <code>Filters</code> in your request.</p>', ], ], 'DashboardUIState' => [ 'base' => NULL, 'refs' => [ 'SheetControlsOption$VisibilityState' => '<p>Visibility state.</p>', ], ], 'DashboardVersion' => [ 'base' => '<p>Dashboard version.</p>', 'refs' => [ 'Dashboard$Version' => '<p>Version.</p>', ], ], 'DashboardVersionSummary' => [ 'base' => '<p>Dashboard version summary.</p>', 'refs' => [ 'DashboardVersionSummaryList$member' => NULL, ], ], 'DashboardVersionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListDashboardVersionsResponse$DashboardVersionSummaryList' => '<p>A structure that contains information about each version of the dashboard.</p>', ], ], 'DataColorPalette' => [ 'base' => '<p>The theme colors that are used for data colors in charts. The colors description is a hexidecimal color code that consists of six alphanumerical characters, prefixed with <code>#</code>, for example #37BFF5. </p>', 'refs' => [ 'ThemeConfiguration$DataColorPalette' => '<p>Color properties that apply to chart data colors.</p>', ], ], 'DataSet' => [ 'base' => '<p>Dataset.</p>', 'refs' => [ 'DescribeDataSetResponse$DataSet' => '<p>Information on the dataset.</p>', ], ], 'DataSetArnsList' => [ 'base' => NULL, 'refs' => [ 'DashboardVersion$DataSetArns' => '<p>The Amazon Resource Numbers (ARNs) for the datasets that are associated with a version of the dashboard.</p>', ], ], 'DataSetConfiguration' => [ 'base' => '<p>Dataset configuration.</p>', 'refs' => [ 'DataSetConfigurationList$member' => NULL, ], ], 'DataSetConfigurationList' => [ 'base' => NULL, 'refs' => [ 'TemplateVersion$DataSetConfigurations' => '<p>Schema of the dataset identified by the placeholder. The idea is that any dashboard created from the template should be bound to new datasets matching the same schema described through this API. .</p>', ], ], 'DataSetImportMode' => [ 'base' => NULL, 'refs' => [ 'CreateDataSetRequest$ImportMode' => '<p>Indicates whether you want to import the data into SPICE.</p>', 'DataSet$ImportMode' => '<p>Indicates whether you want to import the data into SPICE.</p>', 'DataSetSummary$ImportMode' => '<p>Indicates whether you want to import the data into SPICE.</p>', 'UpdateDataSetRequest$ImportMode' => '<p>Indicates whether you want to import the data into SPICE.</p>', ], ], 'DataSetName' => [ 'base' => NULL, 'refs' => [ 'AwsIotAnalyticsParameters$DataSetName' => '<p>Dataset name.</p>', ], ], 'DataSetReference' => [ 'base' => '<p>Dataset reference.</p>', 'refs' => [ 'DataSetReferenceList$member' => NULL, ], ], 'DataSetReferenceList' => [ 'base' => NULL, 'refs' => [ 'DashboardSourceTemplate$DataSetReferences' => '<p>Dataset references.</p>', 'TemplateSourceAnalysis$DataSetReferences' => '<p>A structure containing information about the dataset references used as placeholders in the template.</p>', ], ], 'DataSetSchema' => [ 'base' => '<p>Dataset schema.</p>', 'refs' => [ 'DataSetConfiguration$DataSetSchema' => '<p>Dataset schema.</p>', ], ], 'DataSetSummary' => [ 'base' => '<p>Dataset summary.</p>', 'refs' => [ 'DataSetSummaryList$member' => NULL, ], ], 'DataSetSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListDataSetsResponse$DataSetSummaries' => '<p>The list of dataset summaries.</p>', ], ], 'DataSource' => [ 'base' => '<p>The structure of a data source.</p>', 'refs' => [ 'DataSourceList$member' => NULL, 'DescribeDataSourceResponse$DataSource' => '<p>The information on the data source.</p>', ], ], 'DataSourceCredentials' => [ 'base' => '<p>Data source credentials. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.</p>', 'refs' => [ 'CreateDataSourceRequest$Credentials' => '<p>The credentials QuickSight that uses to connect to your underlying source. Currently, only credentials based on user name and password are supported.</p>', 'UpdateDataSourceRequest$Credentials' => '<p>The credentials that QuickSight that uses to connect to your underlying source. Currently, only credentials based on user name and password are supported.</p>', ], ], 'DataSourceErrorInfo' => [ 'base' => '<p>Error information for the data source creation or update.</p>', 'refs' => [ 'DataSource$ErrorInfo' => '<p>Error information from the last update or the creation of the data source.</p>', ], ], 'DataSourceErrorInfoType' => [ 'base' => NULL, 'refs' => [ 'DataSourceErrorInfo$Type' => '<p>Error type.</p>', ], ], 'DataSourceList' => [ 'base' => NULL, 'refs' => [ 'ListDataSourcesResponse$DataSources' => '<p>A list of data sources.</p>', ], ], 'DataSourceParameters' => [ 'base' => '<p>The parameters that Amazon QuickSight uses to connect to your underlying data source. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.</p>', 'refs' => [ 'CreateDataSourceRequest$DataSourceParameters' => '<p>The parameters that QuickSight uses to connect to your underlying source.</p>', 'DataSource$DataSourceParameters' => '<p>The parameters that Amazon QuickSight uses to connect to your underlying source. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.</p>', 'DataSourceParametersList$member' => NULL, 'UpdateDataSourceRequest$DataSourceParameters' => '<p>The parameters that QuickSight uses to connect to your underlying source.</p>', ], ], 'DataSourceParametersList' => [ 'base' => NULL, 'refs' => [ 'CredentialPair$AlternateDataSourceParameters' => '<p>A set of alternate data source parameters that you want to share for these credentials. The credentials are applied in tandem with the data source parameters when you copy a data source by using a create or update request. The API compares the <code>DataSourceParameters</code> structure that\'s in the request with the structures in the <code>AlternateDataSourceParameters</code> allowlist. If the structures are an exact match, the request is allowed to use the new data source with the existing credentials. If the <code>AlternateDataSourceParameters</code> list is null, the <code>DataSourceParameters</code> originally used with these <code>Credentials</code> is automatically allowed.</p>', 'DataSource$AlternateDataSourceParameters' => '<p>A set of alternate data source parameters that you want to share for the credentials stored with this data source. The credentials are applied in tandem with the data source parameters when you copy a data source by using a create or update request. The API compares the <code>DataSourceParameters</code> structure that\'s in the request with the structures in the <code>AlternateDataSourceParameters</code> allowlist. If the structures are an exact match, the request is allowed to use the credentials from this existing data source. If the <code>AlternateDataSourceParameters</code> list is null, the <code>Credentials</code> originally used with this <code>DataSourceParameters</code> are automatically allowed.</p>', ], ], 'DataSourceType' => [ 'base' => NULL, 'refs' => [ 'CreateDataSourceRequest$Type' => '<p>The type of the data source. Currently, the supported types for this operation are: <code>ATHENA, AURORA, AURORA_POSTGRESQL, MARIADB, MYSQL, POSTGRESQL, PRESTO, REDSHIFT, S3, SNOWFLAKE, SPARK, SQLSERVER, TERADATA</code>. Use <code>ListDataSources</code> to return a list of all data sources.</p>', 'DataSource$Type' => '<p>The type of the data source. This type indicates which database engine the data source connects to.</p>', ], ], 'Database' => [ 'base' => NULL, 'refs' => [ 'AuroraParameters$Database' => '<p>Database.</p>', 'AuroraPostgreSqlParameters$Database' => '<p>Database.</p>', 'MariaDbParameters$Database' => '<p>Database.</p>', 'MySqlParameters$Database' => '<p>Database.</p>', 'PostgreSqlParameters$Database' => '<p>Database.</p>', 'RdsParameters$Database' => '<p>Database.</p>', 'RedshiftParameters$Database' => '<p>Database.</p>', 'SnowflakeParameters$Database' => '<p>Database.</p>', 'SqlServerParameters$Database' => '<p>Database.</p>', 'TeradataParameters$Database' => '<p>Database.</p>', ], ], 'DateTimeParameter' => [ 'base' => '<p>Date time parameter.</p>', 'refs' => [ 'DateTimeParameterList$member' => NULL, ], ], 'DateTimeParameterList' => [ 'base' => NULL, 'refs' => [ 'Parameters$DateTimeParameters' => '<p>DateTime parameters.</p>', ], ], 'DecimalParameter' => [ 'base' => '<p>Decimal parameter.</p>', 'refs' => [ 'DecimalParameterList$member' => NULL, ], ], 'DecimalParameterList' => [ 'base' => NULL, 'refs' => [ 'Parameters$DecimalParameters' => '<p>Decimal parameters.</p>', ], ], 'DeleteAccountCustomizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccountCustomizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDashboardRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDashboardResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGroupMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGroupMembershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIAMPolicyAssignmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIAMPolicyAssignmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNamespaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNamespaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTemplateAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTemplateAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteThemeAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteThemeAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteThemeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteThemeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserByPrincipalIdRequest' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteUserByPrincipalIdResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'Delimiter' => [ 'base' => NULL, 'refs' => [ 'UploadSettings$Delimiter' => '<p>The delimiter between values in the file.</p>', ], ], 'DescribeAccountCustomizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountCustomizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDashboardPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDashboardPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDashboardRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDashboardResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSetPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSetPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSourcePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSourcePermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIAMPolicyAssignmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIAMPolicyAssignmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIngestionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIngestionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNamespaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNamespaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTemplateAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTemplateAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTemplatePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTemplatePermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeThemeAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeThemeAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeThemePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeThemePermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeThemeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeThemeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'Domain' => [ 'base' => NULL, 'refs' => [ 'AmazonElasticsearchParameters$Domain' => '<p>The Amazon Elasticsearch Service domain.</p>', ], ], 'DomainNotWhitelistedException' => [ 'base' => '<p>The domain specified isn\'t on the allow list. All domains for embedded dashboards must be added to the approved list by an Amazon QuickSight admin.</p>', 'refs' => [], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'DoubleList$member' => NULL, ], ], 'DoubleList' => [ 'base' => NULL, 'refs' => [ 'DecimalParameter$Values' => '<p>Values.</p>', ], ], 'Edition' => [ 'base' => NULL, 'refs' => [ 'AccountSettings$Edition' => '<p>The edition of QuickSight that you\'re currently subscribed to.</p>', ], ], 'EmbeddingUrl' => [ 'base' => NULL, 'refs' => [ 'GetDashboardEmbedUrlResponse$EmbedUrl' => '<p>A single-use URL that you can put into your server-side webpage to embed your dashboard. This URL is valid for 5 minutes. The API provides the URL with an <code>auth_code</code> value that enables one (and only one) sign-on to a user session that is valid for 10 hours. </p>', 'GetSessionEmbedUrlResponse$EmbedUrl' => '<p>A single-use URL that you can put into your server-side web page to embed your QuickSight session. This URL is valid for 5 minutes. The API provides the URL with an <code>auth_code</code> value that enables one (and only one) sign-on to a user session that is valid for 10 hours. </p>', ], ], 'EntryPoint' => [ 'base' => NULL, 'refs' => [ 'GetSessionEmbedUrlRequest$EntryPoint' => '<p>The entry point for the embedded session.</p>', ], ], 'ErrorInfo' => [ 'base' => '<p>Error information for the SPICE ingestion of a dataset.</p>', 'refs' => [ 'Ingestion$ErrorInfo' => '<p>Error information for this ingestion.</p>', ], ], 'ExceptionResourceType' => [ 'base' => NULL, 'refs' => [ 'LimitExceededException$ResourceType' => '<p>Limit exceeded.</p>', 'ResourceExistsException$ResourceType' => '<p>The resource type for this request.</p>', 'ResourceNotFoundException$ResourceType' => '<p>The resource type for this request.</p>', 'ResourceUnavailableException$ResourceType' => '<p>The resource type for this request.</p>', ], ], 'ExportToCSVOption' => [ 'base' => '<p>Export to .csv option.</p>', 'refs' => [ 'DashboardPublishOptions$ExportToCSVOption' => '<p>Export to .csv option.</p>', ], ], 'Expression' => [ 'base' => NULL, 'refs' => [ 'CalculatedColumn$Expression' => '<p>An expression that defines the calculated column.</p>', 'FilterOperation$ConditionExpression' => '<p>An expression that must evaluate to a Boolean value. Rows for which the expression evaluates to true are kept in the dataset.</p>', ], ], 'FileFormat' => [ 'base' => NULL, 'refs' => [ 'UploadSettings$Format' => '<p>File format.</p>', ], ], 'FilterOperation' => [ 'base' => '<p>A transform operation that filters rows based on a condition.</p>', 'refs' => [ 'TransformOperation$FilterOperation' => '<p>An operation that filters rows based on some condition.</p>', ], ], 'FilterOperator' => [ 'base' => NULL, 'refs' => [ 'DashboardSearchFilter$Operator' => '<p>The comparison operator that you want to use as a filter, for example, <code>"Operator": "StringEquals"</code>.</p>', ], ], 'GeoSpatialColumnGroup' => [ 'base' => '<p>Geospatial column group that denotes a hierarchy.</p>', 'refs' => [ 'ColumnGroup$GeoSpatialColumnGroup' => '<p>Geospatial column group that denotes a hierarchy.</p>', ], ], 'GeoSpatialCountryCode' => [ 'base' => NULL, 'refs' => [ 'GeoSpatialColumnGroup$CountryCode' => '<p>Country code.</p>', ], ], 'GeoSpatialDataRole' => [ 'base' => NULL, 'refs' => [ 'ColumnTag$ColumnGeographicRole' => '<p>A geospatial role for a column.</p>', ], ], 'GetDashboardEmbedUrlRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDashboardEmbedUrlResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSessionEmbedUrlRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSessionEmbedUrlResponse' => [ 'base' => NULL, 'refs' => [], ], 'Group' => [ 'base' => '<p>A <i>group</i> in Amazon QuickSight consists of a set of users. You can use groups to make it easier to manage access and security. Currently, an Amazon QuickSight subscription can\'t contain more than 500 Amazon QuickSight groups.</p>', 'refs' => [ 'CreateGroupResponse$Group' => '<p>The name of the group.</p>', 'DescribeGroupResponse$Group' => '<p>The name of the group.</p>', 'GroupList$member' => NULL, 'UpdateGroupResponse$Group' => '<p>The name of the group.</p>', ], ], 'GroupDescription' => [ 'base' => NULL, 'refs' => [ 'CreateGroupRequest$Description' => '<p>A description for the group that you want to create.</p>', 'Group$Description' => '<p>The group description.</p>', 'UpdateGroupRequest$Description' => '<p>The description for the group that you want to update.</p>', ], ], 'GroupList' => [ 'base' => NULL, 'refs' => [ 'ListGroupsResponse$GroupList' => '<p>The list of the groups.</p>', 'ListUserGroupsResponse$GroupList' => '<p>The list of groups the user is a member of.</p>', ], ], 'GroupMember' => [ 'base' => '<p>A member of an Amazon QuickSight group. Currently, group members must be users. Groups can\'t be members of another group. .</p>', 'refs' => [ 'CreateGroupMembershipResponse$GroupMember' => '<p>The group member.</p>', 'GroupMemberList$member' => NULL, ], ], 'GroupMemberList' => [ 'base' => NULL, 'refs' => [ 'ListGroupMembershipsResponse$GroupMemberList' => '<p>The list of the members of the group.</p>', ], ], 'GroupMemberName' => [ 'base' => NULL, 'refs' => [ 'CreateGroupMembershipRequest$MemberName' => '<p>The name of the user that you want to add to the group membership.</p>', 'DeleteGroupMembershipRequest$MemberName' => '<p>The name of the user that you want to delete from the group membership.</p>', 'GroupMember$MemberName' => '<p>The name of the group member (user).</p>', ], ], 'GroupName' => [ 'base' => NULL, 'refs' => [ 'CreateGroupMembershipRequest$GroupName' => '<p>The name of the group that you want to add the user to.</p>', 'CreateGroupRequest$GroupName' => '<p>A name for the group that you want to create.</p>', 'DeleteGroupMembershipRequest$GroupName' => '<p>The name of the group that you want to delete the user from.</p>', 'DeleteGroupRequest$GroupName' => '<p>The name of the group that you want to delete.</p>', 'DescribeGroupRequest$GroupName' => '<p>The name of the group that you want to describe.</p>', 'Group$GroupName' => '<p>The name of the group.</p>', 'ListGroupMembershipsRequest$GroupName' => '<p>The name of the group that you want to see a membership list of.</p>', 'UpdateGroupRequest$GroupName' => '<p>The name of the group that you want to update.</p>', ], ], 'GutterStyle' => [ 'base' => '<p>The display options for gutter spacing between tiles on a sheet.</p>', 'refs' => [ 'TileLayoutStyle$Gutter' => '<p>The gutter settings that apply between tiles. </p>', ], ], 'HexColor' => [ 'base' => NULL, 'refs' => [ 'ColorList$member' => NULL, 'DataColorPalette$EmptyFillColor' => '<p>The hexadecimal code of a color that applies to charts where a lack of data is highlighted.</p>', 'UIColorPalette$PrimaryForeground' => '<p>The color of text and other foreground elements that appear over the primary background regions, such as grid lines, borders, table banding, icons, and so on.</p>', 'UIColorPalette$PrimaryBackground' => '<p>The background color that applies to visuals and other high emphasis UI.</p>', 'UIColorPalette$SecondaryForeground' => '<p>The foreground color that applies to any sheet title, sheet control text, or UI that appears over the secondary background.</p>', 'UIColorPalette$SecondaryBackground' => '<p>The background color that applies to the sheet background and sheet controls.</p>', 'UIColorPalette$Accent' => '<p>This color is that applies to selected states and buttons.</p>', 'UIColorPalette$AccentForeground' => '<p>The foreground color that applies to any text or other elements that appear over the accent color.</p>', 'UIColorPalette$Danger' => '<p>The color that applies to error messages.</p>', 'UIColorPalette$DangerForeground' => '<p>The foreground color that applies to any text or other elements that appear over the error color.</p>', 'UIColorPalette$Warning' => '<p>This color that applies to warning and informational messages.</p>', 'UIColorPalette$WarningForeground' => '<p>The foreground color that applies to any text or other elements that appear over the warning color.</p>', 'UIColorPalette$Success' => '<p>The color that applies to success messages, for example the check mark for a successful download.</p>', 'UIColorPalette$SuccessForeground' => '<p>The foreground color that applies to any text or other elements that appear over the success color.</p>', 'UIColorPalette$Dimension' => '<p>The color that applies to the names of fields that are identified as dimensions.</p>', 'UIColorPalette$DimensionForeground' => '<p>The foreground color that applies to any text or other elements that appear over the dimension color.</p>', 'UIColorPalette$Measure' => '<p>The color that applies to the names of fields that are identified as measures.</p>', 'UIColorPalette$MeasureForeground' => '<p>The foreground color that applies to any text or other elements that appear over the measure color.</p>', ], ], 'Host' => [ 'base' => NULL, 'refs' => [ 'AuroraParameters$Host' => '<p>Host.</p>', 'AuroraPostgreSqlParameters$Host' => '<p>Host.</p>', 'MariaDbParameters$Host' => '<p>Host.</p>', 'MySqlParameters$Host' => '<p>Host.</p>', 'PostgreSqlParameters$Host' => '<p>Host.</p>', 'PrestoParameters$Host' => '<p>Host.</p>', 'RedshiftParameters$Host' => '<p>Host. This field can be blank if <code>ClusterId</code> is provided.</p>', 'SnowflakeParameters$Host' => '<p>Host.</p>', 'SparkParameters$Host' => '<p>Host.</p>', 'SqlServerParameters$Host' => '<p>Host.</p>', 'TeradataParameters$Host' => '<p>Host.</p>', ], ], 'IAMPolicyAssignment' => [ 'base' => '<p>An AWS Identity and Access Management (IAM) policy assignment.</p>', 'refs' => [ 'DescribeIAMPolicyAssignmentResponse$IAMPolicyAssignment' => '<p>Information describing the IAM policy assignment.</p>', ], ], 'IAMPolicyAssignmentName' => [ 'base' => NULL, 'refs' => [ 'ActiveIAMPolicyAssignment$AssignmentName' => '<p>A name for the IAM policy assignment.</p>', 'CreateIAMPolicyAssignmentRequest$AssignmentName' => '<p>The name of the assignment. It must be unique within an AWS account.</p>', 'CreateIAMPolicyAssignmentResponse$AssignmentName' => '<p>The name of the assignment. This name must be unique within the AWS account.</p>', 'DeleteIAMPolicyAssignmentRequest$AssignmentName' => '<p>The name of the assignment. </p>', 'DeleteIAMPolicyAssignmentResponse$AssignmentName' => '<p>The name of the assignment. </p>', 'DescribeIAMPolicyAssignmentRequest$AssignmentName' => '<p>The name of the assignment. </p>', 'IAMPolicyAssignment$AssignmentName' => '<p>Assignment name.</p>', 'IAMPolicyAssignmentSummary$AssignmentName' => '<p>Assignment name.</p>', 'UpdateIAMPolicyAssignmentRequest$AssignmentName' => '<p>The name of the assignment. This name must be unique within an AWS account.</p>', 'UpdateIAMPolicyAssignmentResponse$AssignmentName' => '<p>The name of the assignment. </p>', ], ], 'IAMPolicyAssignmentSummary' => [ 'base' => '<p>IAM policy assignment summary.</p>', 'refs' => [ 'IAMPolicyAssignmentSummaryList$member' => NULL, ], ], 'IAMPolicyAssignmentSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListIAMPolicyAssignmentsResponse$IAMPolicyAssignments' => '<p>Information describing the IAM policy assignments.</p>', ], ], 'IdentityMap' => [ 'base' => NULL, 'refs' => [ 'CreateIAMPolicyAssignmentRequest$Identities' => '<p>The QuickSight users, groups, or both that you want to assign the policy to.</p>', 'CreateIAMPolicyAssignmentResponse$Identities' => '<p>The QuickSight users, groups, or both that the IAM policy is assigned to.</p>', 'IAMPolicyAssignment$Identities' => '<p>Identities.</p>', 'UpdateIAMPolicyAssignmentRequest$Identities' => '<p>The QuickSight users, groups, or both that you want to assign the policy to.</p>', 'UpdateIAMPolicyAssignmentResponse$Identities' => '<p>The QuickSight users, groups, or both that the IAM policy is assigned to.</p>', ], ], 'IdentityName' => [ 'base' => NULL, 'refs' => [ 'IdentityNameList$member' => NULL, ], ], 'IdentityNameList' => [ 'base' => NULL, 'refs' => [ 'IdentityMap$value' => NULL, ], ], 'IdentityStore' => [ 'base' => NULL, 'refs' => [ 'CreateNamespaceRequest$IdentityStore' => '<p>Specifies the type of your user identity directory. Currently, this supports users with an identity type of <code>QUICKSIGHT</code>.</p>', 'CreateNamespaceResponse$IdentityStore' => '<p>Specifies the type of your user identity directory. Currently, this supports users with an identity type of <code>QUICKSIGHT</code>.</p>', 'NamespaceInfoV2$IdentityStore' => '<p>The identity store used for the namespace.</p>', ], ], 'IdentityType' => [ 'base' => NULL, 'refs' => [ 'GetDashboardEmbedUrlRequest$IdentityType' => '<p>The authentication method that the user uses to sign in.</p>', 'RegisterUserRequest$IdentityType' => '<p>Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts two values:</p> <ul> <li> <p> <code>IAM</code>: A user whose identity maps to an existing IAM user or role. </p> </li> <li> <p> <code>QUICKSIGHT</code>: A user whose identity is owned and managed internally by Amazon QuickSight. </p> </li> </ul>', 'User$IdentityType' => '<p>The type of identity authentication used by the user.</p>', ], ], 'IdentityTypeNotSupportedException' => [ 'base' => '<p>The identity type specified isn\'t supported. Supported identity types include <code>IAM</code> and <code>QUICKSIGHT</code>.</p>', 'refs' => [], ], 'Ingestion' => [ 'base' => '<p>Information about the SPICE ingestion for a dataset.</p>', 'refs' => [ 'DescribeIngestionResponse$Ingestion' => '<p>Information about the ingestion.</p>', 'Ingestions$member' => NULL, ], ], 'IngestionErrorType' => [ 'base' => NULL, 'refs' => [ 'ErrorInfo$Type' => '<p>Error type.</p>', ], ], 'IngestionId' => [ 'base' => NULL, 'refs' => [ 'CancelIngestionRequest$IngestionId' => '<p>An ID for the ingestion.</p>', 'CancelIngestionResponse$IngestionId' => '<p>An ID for the ingestion.</p>', 'CreateIngestionRequest$IngestionId' => '<p>An ID for the ingestion.</p>', 'CreateIngestionResponse$IngestionId' => '<p>An ID for the ingestion.</p>', 'DescribeIngestionRequest$IngestionId' => '<p>An ID for the ingestion.</p>', 'Ingestion$IngestionId' => '<p>Ingestion ID.</p>', ], ], 'IngestionMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListIngestionsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', ], ], 'IngestionRequestSource' => [ 'base' => NULL, 'refs' => [ 'Ingestion$RequestSource' => '<p>Event source for this ingestion.</p>', ], ], 'IngestionRequestType' => [ 'base' => NULL, 'refs' => [ 'Ingestion$RequestType' => '<p>Type of this ingestion.</p>', ], ], 'IngestionStatus' => [ 'base' => NULL, 'refs' => [ 'CreateIngestionResponse$IngestionStatus' => '<p>The ingestion status.</p>', 'Ingestion$IngestionStatus' => '<p>Ingestion status.</p>', ], ], 'Ingestions' => [ 'base' => NULL, 'refs' => [ 'ListIngestionsResponse$Ingestions' => '<p>A list of the ingestions.</p>', ], ], 'InputColumn' => [ 'base' => '<p>Metadata for a column that is used as the input of a transform operation.</p>', 'refs' => [ 'InputColumnList$member' => NULL, ], ], 'InputColumnDataType' => [ 'base' => NULL, 'refs' => [ 'InputColumn$Type' => '<p>The data type of the column.</p>', ], ], 'InputColumnList' => [ 'base' => NULL, 'refs' => [ 'CustomSql$Columns' => '<p>The column schema from the SQL query result set.</p>', 'RelationalTable$InputColumns' => '<p>The column schema of the table.</p>', 'S3Source$InputColumns' => '<p>A physical table type for as S3 data source.</p>', ], ], 'InstanceId' => [ 'base' => NULL, 'refs' => [ 'RdsParameters$InstanceId' => '<p>Instance ID.</p>', ], ], 'IntegerParameter' => [ 'base' => '<p>Integer parameter.</p>', 'refs' => [ 'IntegerParameterList$member' => NULL, ], ], 'IntegerParameterList' => [ 'base' => NULL, 'refs' => [ 'Parameters$IntegerParameters' => '<p>Integer parameters.</p>', ], ], 'InternalFailureException' => [ 'base' => '<p>An internal failure occurred.</p>', 'refs' => [], ], 'InvalidNextTokenException' => [ 'base' => '<p>The <code>NextToken</code> value isn\'t valid.</p>', 'refs' => [], ], 'InvalidParameterValueException' => [ 'base' => '<p>One or more parameters has a value that isn\'t valid.</p>', 'refs' => [], ], 'JiraParameters' => [ 'base' => '<p>Jira parameters.</p>', 'refs' => [ 'DataSourceParameters$JiraParameters' => '<p>Jira parameters.</p>', ], ], 'JoinInstruction' => [ 'base' => '<p>Join instruction.</p>', 'refs' => [ 'LogicalTableSource$JoinInstruction' => '<p>Specifies the result of a join of two logical tables.</p>', ], ], 'JoinType' => [ 'base' => NULL, 'refs' => [ 'JoinInstruction$Type' => '<p>Type.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>A limit is exceeded.</p>', 'refs' => [], ], 'ListDashboardVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDashboardVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDashboardsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDashboardsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupMembershipsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupMembershipsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIAMPolicyAssignmentsForUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIAMPolicyAssignmentsForUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIAMPolicyAssignmentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIAMPolicyAssignmentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIngestionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIngestionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListNamespacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListNamespacesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplateAliasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplateAliasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplateVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplateVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListThemeAliasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListThemeAliasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListThemeVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListThemeVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListThemesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListThemesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUserGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUserGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogicalTable' => [ 'base' => '<p>A <i>logical table</i> is a unit that joins and that data transformations operate on. A logical table has a source, which can be either a physical table or result of a join. When a logical table points to a physical table, the logical table acts as a mutable copy of that physical table through transform operations.</p>', 'refs' => [ 'LogicalTableMap$value' => NULL, ], ], 'LogicalTableAlias' => [ 'base' => NULL, 'refs' => [ 'LogicalTable$Alias' => '<p>A display name for the logical table.</p>', ], ], 'LogicalTableId' => [ 'base' => NULL, 'refs' => [ 'JoinInstruction$LeftOperand' => '<p>Left operand.</p>', 'JoinInstruction$RightOperand' => '<p>Right operand.</p>', 'LogicalTableMap$key' => NULL, ], ], 'LogicalTableMap' => [ 'base' => NULL, 'refs' => [ 'CreateDataSetRequest$LogicalTableMap' => '<p>Configures the combination and transformation of the data from the physical tables.</p>', 'DataSet$LogicalTableMap' => '<p>Configures the combination and transformation of the data from the physical tables.</p>', 'UpdateDataSetRequest$LogicalTableMap' => '<p>Configures the combination and transformation of the data from the physical tables.</p>', ], ], 'LogicalTableSource' => [ 'base' => '<p>Information about the source of a logical table. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.</p>', 'refs' => [ 'LogicalTable$Source' => '<p>Source of this logical table.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'DataSet$ConsumedSpiceCapacityInBytes' => '<p>The amount of SPICE capacity used by this dataset. This is 0 if the dataset isn\'t imported into SPICE.</p>', 'LongList$member' => NULL, ], ], 'LongList' => [ 'base' => NULL, 'refs' => [ 'IntegerParameter$Values' => '<p>Values.</p>', ], ], 'ManifestFileLocation' => [ 'base' => '<p>Amazon S3 manifest file location.</p>', 'refs' => [ 'S3Parameters$ManifestFileLocation' => '<p>Location of the Amazon S3 manifest file. This is NULL if the manifest file was uploaded in the console.</p>', ], ], 'MarginStyle' => [ 'base' => '<p>The display options for margins around the outside edge of sheets.</p>', 'refs' => [ 'TileLayoutStyle$Margin' => '<p>The margin settings that apply around the outside edge of sheets.</p>', ], ], 'MariaDbParameters' => [ 'base' => '<p>MariaDB parameters.</p>', 'refs' => [ 'DataSourceParameters$MariaDbParameters' => '<p>MariaDB parameters.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListDashboardVersionsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListDashboardsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListDataSetsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListDataSourcesRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListGroupMembershipsRequest$MaxResults' => '<p>The maximum number of results to return from this request.</p>', 'ListGroupsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'ListIAMPolicyAssignmentsForUserRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListIAMPolicyAssignmentsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListNamespacesRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'ListTemplateAliasesRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListTemplateVersionsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListTemplatesRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListThemeAliasesRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListThemeVersionsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListThemesRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListUserGroupsRequest$MaxResults' => '<p>The maximum number of results to return from this request.</p>', 'ListUsersRequest$MaxResults' => '<p>The maximum number of results to return from this request.</p>', 'SearchDashboardsRequest$MaxResults' => '<p>The maximum number of results to be returned per request.</p>', ], ], 'MySqlParameters' => [ 'base' => '<p>MySQL parameters.</p>', 'refs' => [ 'DataSourceParameters$MySqlParameters' => '<p>MySQL parameters.</p>', ], ], 'Namespace' => [ 'base' => NULL, 'refs' => [ 'AccountSettings$DefaultNamespace' => '<p>The default QuickSight namespace for your AWS account.</p>', 'CreateAccountCustomizationRequest$Namespace' => '<p>The namespace associated with the customization that you\'re creating.</p>', 'CreateAccountCustomizationResponse$Namespace' => '<p>The namespace associated with the customization you\'re creating. </p>', 'CreateGroupMembershipRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'CreateGroupRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'CreateIAMPolicyAssignmentRequest$Namespace' => '<p>The namespace that contains the assignment.</p>', 'CreateNamespaceRequest$Namespace' => '<p>The name that you want to use to describe the new namespace.</p>', 'CreateNamespaceResponse$Name' => '<p>The name of the new namespace that you created.</p>', 'DeleteAccountCustomizationRequest$Namespace' => '<p>The namespace associated with the customization that you\'re deleting.</p>', 'DeleteGroupMembershipRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'DeleteGroupRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'DeleteIAMPolicyAssignmentRequest$Namespace' => '<p>The namespace that contains the assignment.</p>', 'DeleteNamespaceRequest$Namespace' => '<p>The namespace that you want to delete.</p>', 'DeleteUserByPrincipalIdRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'DeleteUserRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'DescribeAccountCustomizationRequest$Namespace' => '<p>The namespace associated with the customization that you\'re describing.</p>', 'DescribeAccountCustomizationResponse$Namespace' => '<p>The namespace associated with the customization that you\'re describing.</p>', 'DescribeGroupRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'DescribeIAMPolicyAssignmentRequest$Namespace' => '<p>The namespace that contains the assignment.</p>', 'DescribeNamespaceRequest$Namespace' => '<p>The namespace that you want to describe.</p>', 'DescribeUserRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'ListGroupMembershipsRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'ListGroupsRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'ListIAMPolicyAssignmentsForUserRequest$Namespace' => '<p>The namespace of the assignment.</p>', 'ListIAMPolicyAssignmentsRequest$Namespace' => '<p>The namespace for the assignments.</p>', 'ListUserGroupsRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'ListUsersRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'NamespaceInfoV2$Name' => '<p>The name of the error.</p>', 'RegisterUserRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'RowLevelPermissionDataSet$Namespace' => '<p>The namespace associated with the row-level permissions dataset.</p>', 'UpdateAccountCustomizationRequest$Namespace' => '<p>The namespace associated with the customization that you\'re updating.</p>', 'UpdateAccountCustomizationResponse$Namespace' => '<p>The namespace associated with the customization that you\'re updating.</p>', 'UpdateAccountSettingsRequest$DefaultNamespace' => '<p>The default namespace for this AWS Account. Currently, the default is <code>default</code>. IAM users who register for the first time with QuickSight provide an email that becomes associated with the default namespace.</p>', 'UpdateGroupRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', 'UpdateIAMPolicyAssignmentRequest$Namespace' => '<p>The namespace of the assignment.</p>', 'UpdateUserRequest$Namespace' => '<p>The namespace. Currently, you should set this to <code>default</code>.</p>', ], ], 'NamespaceError' => [ 'base' => '<p>Errors that occur during namespace creation.</p>', 'refs' => [ 'NamespaceInfoV2$NamespaceError' => '<p>An error that occured when the namespace was created.</p>', ], ], 'NamespaceErrorType' => [ 'base' => NULL, 'refs' => [ 'NamespaceError$Type' => '<p>The error type.</p>', ], ], 'NamespaceInfoV2' => [ 'base' => '<p>The error type.</p>', 'refs' => [ 'DescribeNamespaceResponse$Namespace' => '<p>The information about the namespace that you\'re describing. The response includes the namespace ARN, name, AWS Region, creation status, and identity store. <code>DescribeNamespace</code> also works for namespaces that are in the process of being created. For incomplete namespaces, this API lists the namespace error types and messages associated with the creation process.</p>', 'Namespaces$member' => NULL, ], ], 'NamespaceStatus' => [ 'base' => NULL, 'refs' => [ 'CreateNamespaceResponse$CreationStatus' => '<p>The status of the creation of the namespace. This is an asynchronous process. A status of <code>CREATED</code> means that your namespace is ready to use. If an error occurs, it indicates if the process is <code>retryable</code> or <code>non-retryable</code>. In the case of a non-retryable error, refer to the error message for follow-up actions.</p>', 'NamespaceInfoV2$CreationStatus' => '<p>The creation status of a namespace that is not yet completely created.</p>', ], ], 'Namespaces' => [ 'base' => NULL, 'refs' => [ 'ListNamespacesResponse$Namespaces' => '<p>The information about the namespaces in this AWS account. The response includes the namespace ARN, name, AWS Region, notification email address, creation status, and identity store.</p>', ], ], 'NonEmptyString' => [ 'base' => NULL, 'refs' => [ 'DashboardError$Message' => '<p>Message.</p>', 'DataSetReference$DataSetPlaceholder' => '<p>Dataset placeholder.</p>', 'DateTimeParameter$Name' => '<p>A display name for the dataset.</p>', 'DecimalParameter$Name' => '<p>A display name for the dataset.</p>', 'IntegerParameter$Name' => '<p>A display name for the dataset.</p>', 'StringParameter$Name' => '<p>A display name for the dataset.</p>', 'TemplateError$Message' => '<p>Description of the error type.</p>', 'ThemeError$Message' => '<p>The error message.</p>', ], ], 'OnClause' => [ 'base' => NULL, 'refs' => [ 'JoinInstruction$OnClause' => '<p>On Clause.</p>', ], ], 'OptionalPort' => [ 'base' => NULL, 'refs' => [ 'RedshiftParameters$Port' => '<p>Port. This field can be blank if the <code>ClusterId</code> is provided.</p>', ], ], 'OutputColumn' => [ 'base' => '<p>Output column.</p>', 'refs' => [ 'OutputColumnList$member' => NULL, ], ], 'OutputColumnList' => [ 'base' => NULL, 'refs' => [ 'DataSet$OutputColumns' => '<p>The list of columns after all transforms. These columns are available in templates, analyses, and dashboards.</p>', ], ], 'Parameters' => [ 'base' => '<p>Parameters.</p>', 'refs' => [ 'CreateDashboardRequest$Parameters' => '<p>The parameters for the creation of the dashboard, which you want to use to override the default settings. A dashboard can have any type of parameters, and some parameters might accept multiple values. </p>', 'UpdateDashboardRequest$Parameters' => '<p>A structure that contains the parameters of the dashboard. These are parameter overrides for a dashboard. A dashboard can have any type of parameters, and some parameters might accept multiple values.</p>', ], ], 'Password' => [ 'base' => NULL, 'refs' => [ 'CredentialPair$Password' => '<p>Password.</p>', ], ], 'PhysicalTable' => [ 'base' => '<p>A view of a data source that contains information about the shape of the data in the underlying source. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.</p>', 'refs' => [ 'PhysicalTableMap$value' => NULL, ], ], 'PhysicalTableId' => [ 'base' => NULL, 'refs' => [ 'LogicalTableSource$PhysicalTableId' => '<p>Physical table ID.</p>', 'PhysicalTableMap$key' => NULL, ], ], 'PhysicalTableMap' => [ 'base' => NULL, 'refs' => [ 'CreateDataSetRequest$PhysicalTableMap' => '<p>Declares the physical tables that are available in the underlying data sources.</p>', 'DataSet$PhysicalTableMap' => '<p>Declares the physical tables that are available in the underlying data sources.</p>', 'UpdateDataSetRequest$PhysicalTableMap' => '<p>Declares the physical tables that are available in the underlying data sources.</p>', ], ], 'Port' => [ 'base' => NULL, 'refs' => [ 'AuroraParameters$Port' => '<p>Port.</p>', 'AuroraPostgreSqlParameters$Port' => '<p>Port.</p>', 'MariaDbParameters$Port' => '<p>Port.</p>', 'MySqlParameters$Port' => '<p>Port.</p>', 'PostgreSqlParameters$Port' => '<p>Port.</p>', 'PrestoParameters$Port' => '<p>Port.</p>', 'SparkParameters$Port' => '<p>Port.</p>', 'SqlServerParameters$Port' => '<p>Port.</p>', 'TeradataParameters$Port' => '<p>Port.</p>', ], ], 'PositiveInteger' => [ 'base' => NULL, 'refs' => [ 'TwitterParameters$MaxRows' => '<p>Maximum number of rows to query Twitter.</p>', 'UploadSettings$StartFromRow' => '<p>A row number to start reading data from.</p>', ], ], 'PostgreSqlParameters' => [ 'base' => '<p>PostgreSQL parameters.</p>', 'refs' => [ 'DataSourceParameters$PostgreSqlParameters' => '<p>PostgreSQL parameters.</p>', ], ], 'PreconditionNotMetException' => [ 'base' => '<p>One or more preconditions aren\'t met.</p>', 'refs' => [], ], 'PrestoParameters' => [ 'base' => '<p>Presto parameters.</p>', 'refs' => [ 'DataSourceParameters$PrestoParameters' => '<p>Presto parameters.</p>', ], ], 'Principal' => [ 'base' => NULL, 'refs' => [ 'ResourcePermission$Principal' => '<p>The Amazon Resource Name (ARN) of the principal. This can be one of the following:</p> <ul> <li> <p>The ARN of an Amazon QuickSight user, group, or namespace. (This is most common.)</p> </li> <li> <p>The ARN of an AWS account root: This is an IAM ARN rather than a QuickSight ARN. Use this option only to share resources (templates) across AWS accounts. (This is less common.) </p> </li> </ul>', ], ], 'ProjectOperation' => [ 'base' => '<p>A transform operation that projects columns. Operations that come after a projection can only refer to projected columns.</p>', 'refs' => [ 'TransformOperation$ProjectOperation' => '<p>An operation that projects columns. Operations that come after a projection can only refer to projected columns.</p>', ], ], 'ProjectedColumnList' => [ 'base' => NULL, 'refs' => [ 'ProjectOperation$ProjectedColumns' => '<p>Projected columns.</p>', ], ], 'Query' => [ 'base' => NULL, 'refs' => [ 'TwitterParameters$Query' => '<p>Twitter query string.</p>', ], ], 'QueueInfo' => [ 'base' => '<p>Information about a queued dataset SPICE ingestion.</p>', 'refs' => [ 'Ingestion$QueueInfo' => NULL, ], ], 'QuickSightUserNotFoundException' => [ 'base' => '<p>The user with the provided name isn\'t found. This error can happen in any operation that requires finding a user based on a provided user name, such as <code>DeleteUser</code>, <code>DescribeUser</code>, and so on.</p>', 'refs' => [], ], 'RdsParameters' => [ 'base' => '<p>Amazon RDS parameters.</p>', 'refs' => [ 'DataSourceParameters$RdsParameters' => '<p>Amazon RDS parameters.</p>', ], ], 'RedshiftParameters' => [ 'base' => '<p>Amazon Redshift parameters. The <code>ClusterId</code> field can be blank if <code>Host</code> and <code>Port</code> are both set. The <code>Host</code> and <code>Port</code> fields can be blank if the <code>ClusterId</code> field is set.</p>', 'refs' => [ 'DataSourceParameters$RedshiftParameters' => '<p>Amazon Redshift parameters.</p>', ], ], 'RegisterUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'RelationalTable' => [ 'base' => '<p>A physical table type for relational data sources.</p>', 'refs' => [ 'PhysicalTable$RelationalTable' => '<p>A physical table type for relational data sources.</p>', ], ], 'RelationalTableName' => [ 'base' => NULL, 'refs' => [ 'RelationalTable$Name' => '<p>The name of the relational table.</p>', ], ], 'RelationalTableSchema' => [ 'base' => NULL, 'refs' => [ 'RelationalTable$Schema' => '<p>The schema name. This name applies to certain relational database engines.</p>', ], ], 'RenameColumnOperation' => [ 'base' => '<p>A transform operation that renames a column.</p>', 'refs' => [ 'TransformOperation$RenameColumnOperation' => '<p>An operation that renames a column.</p>', ], ], 'ResourceExistsException' => [ 'base' => '<p>The resource specified already exists. </p>', 'refs' => [], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'CreateDataSetRequest$DataSetId' => '<p>An ID for the dataset that you want to create. This ID is unique per AWS Region for each AWS account.</p>', 'CreateDataSetResponse$DataSetId' => '<p>The ID for the dataset that you want to create. This ID is unique per AWS Region for each AWS account.</p>', 'CreateDataSetResponse$IngestionId' => '<p>The ID of the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>', 'CreateDataSourceRequest$DataSourceId' => '<p>An ID for the data source. This ID is unique per AWS Region for each AWS account. </p>', 'CreateDataSourceResponse$DataSourceId' => '<p>The ID of the data source. This ID is unique per AWS Region for each AWS account.</p>', 'DataSet$DataSetId' => '<p>The ID of the dataset.</p>', 'DataSetSummary$DataSetId' => '<p>The ID of the dataset.</p>', 'DataSource$DataSourceId' => '<p>The ID of the data source. This ID is unique per AWS Region for each AWS account.</p>', 'DeleteDataSetRequest$DataSetId' => '<p>The ID for the dataset that you want to create. This ID is unique per AWS Region for each AWS account.</p>', 'DeleteDataSetResponse$DataSetId' => '<p>The ID for the dataset that you want to create. This ID is unique per AWS Region for each AWS account.</p>', 'DeleteDataSourceRequest$DataSourceId' => '<p>The ID of the data source. This ID is unique per AWS Region for each AWS account.</p>', 'DeleteDataSourceResponse$DataSourceId' => '<p>The ID of the data source. This ID is unique per AWS Region for each AWS account.</p>', 'DescribeDataSetPermissionsRequest$DataSetId' => '<p>The ID for the dataset that you want to create. This ID is unique per AWS Region for each AWS account.</p>', 'DescribeDataSetPermissionsResponse$DataSetId' => '<p>The ID for the dataset that you want to create. This ID is unique per AWS Region for each AWS account.</p>', 'DescribeDataSetRequest$DataSetId' => '<p>The ID for the dataset that you want to create. This ID is unique per AWS Region for each AWS account.</p>', 'DescribeDataSourcePermissionsRequest$DataSourceId' => '<p>The ID of the data source. This ID is unique per AWS Region for each AWS account.</p>', 'DescribeDataSourcePermissionsResponse$DataSourceId' => '<p>The ID of the data source. This ID is unique per AWS Region for each AWS account.</p>', 'DescribeDataSourceRequest$DataSourceId' => '<p>The ID of the data source. This ID is unique per AWS Region for each AWS account.</p>', 'UpdateDataSetPermissionsRequest$DataSetId' => '<p>The ID for the dataset whose permissions you want to update. This ID is unique per AWS Region for each AWS account.</p>', 'UpdateDataSetPermissionsResponse$DataSetId' => '<p>The ID for the dataset whose permissions you want to update. This ID is unique per AWS Region for each AWS account.</p>', 'UpdateDataSetRequest$DataSetId' => '<p>The ID for the dataset that you want to update. This ID is unique per AWS Region for each AWS account.</p>', 'UpdateDataSetResponse$DataSetId' => '<p>The ID for the dataset that you want to create. This ID is unique per AWS Region for each AWS account.</p>', 'UpdateDataSetResponse$IngestionId' => '<p>The ID of the ingestion, which is triggered as a result of dataset creation if the import mode is SPICE.</p>', 'UpdateDataSourcePermissionsRequest$DataSourceId' => '<p>The ID of the data source. This ID is unique per AWS Region for each AWS account. </p>', 'UpdateDataSourcePermissionsResponse$DataSourceId' => '<p>The ID of the data source. This ID is unique per AWS Region for each AWS account.</p>', 'UpdateDataSourceRequest$DataSourceId' => '<p>The ID of the data source. This ID is unique per AWS Region for each AWS account. </p>', 'UpdateDataSourceResponse$DataSourceId' => '<p>The ID of the data source. This ID is unique per AWS Region for each AWS account.</p>', ], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'CreateDataSetRequest$Name' => '<p>The display name for the dataset.</p>', 'CreateDataSourceRequest$Name' => '<p>A display name for the data source.</p>', 'DataSet$Name' => '<p>A display name for the dataset.</p>', 'DataSetSummary$Name' => '<p>A display name for the dataset.</p>', 'DataSource$Name' => '<p>A display name for the data source.</p>', 'UpdateDataSetRequest$Name' => '<p>The display name for the dataset.</p>', 'UpdateDataSourceRequest$Name' => '<p>A display name for the data source.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>One or more resources can\'t be found.</p>', 'refs' => [], ], 'ResourcePermission' => [ 'base' => '<p>Permission for the resource.</p>', 'refs' => [ 'ResourcePermissionList$member' => NULL, 'UpdateResourcePermissionList$member' => NULL, ], ], 'ResourcePermissionList' => [ 'base' => NULL, 'refs' => [ 'CreateDashboardRequest$Permissions' => '<p>A structure that contains the permissions of the dashboard. You can use this structure for granting permissions with principal and action information.</p>', 'CreateDataSetRequest$Permissions' => '<p>A list of resource permissions on the dataset.</p>', 'CreateDataSourceRequest$Permissions' => '<p>A list of resource permissions on the data source.</p>', 'CreateTemplateRequest$Permissions' => '<p>A list of resource permissions to be set on the template. </p>', 'CreateThemeRequest$Permissions' => '<p>A valid grouping of resource permissions to apply to the new theme. </p>', 'DescribeDashboardPermissionsResponse$Permissions' => '<p>A structure that contains the permissions for the dashboard.</p>', 'DescribeDataSetPermissionsResponse$Permissions' => '<p>A list of resource permissions on the dataset.</p>', 'DescribeDataSourcePermissionsResponse$Permissions' => '<p>A list of resource permissions on the data source.</p>', 'DescribeTemplatePermissionsResponse$Permissions' => '<p>A list of resource permissions to be set on the template. </p>', 'DescribeThemePermissionsResponse$Permissions' => '<p>A list of resource permissions set on the theme. </p>', 'UpdateDashboardPermissionsResponse$Permissions' => '<p>Information about the permissions on the dashboard.</p>', 'UpdateDataSetPermissionsRequest$GrantPermissions' => '<p>The resource permissions that you want to grant to the dataset.</p>', 'UpdateDataSetPermissionsRequest$RevokePermissions' => '<p>The resource permissions that you want to revoke from the dataset.</p>', 'UpdateDataSourcePermissionsRequest$GrantPermissions' => '<p>A list of resource permissions that you want to grant on the data source.</p>', 'UpdateDataSourcePermissionsRequest$RevokePermissions' => '<p>A list of resource permissions that you want to revoke on the data source.</p>', 'UpdateTemplatePermissionsResponse$Permissions' => '<p>A list of resource permissions to be set on the template.</p>', 'UpdateThemePermissionsResponse$Permissions' => '<p>The resulting list of resource permissions for the theme.</p>', ], ], 'ResourceStatus' => [ 'base' => NULL, 'refs' => [ 'CreateDashboardResponse$CreationStatus' => '<p>The status of the dashboard creation request.</p>', 'CreateDataSourceResponse$CreationStatus' => '<p>The status of creating the data source.</p>', 'CreateTemplateResponse$CreationStatus' => '<p>The template creation status.</p>', 'CreateThemeResponse$CreationStatus' => '<p>The theme creation status.</p>', 'DashboardVersion$Status' => '<p>The HTTP status of the request.</p>', 'DashboardVersionSummary$Status' => '<p>The HTTP status of the request.</p>', 'DataSource$Status' => '<p>The HTTP status of the request.</p>', 'TemplateVersion$Status' => '<p>The HTTP status of the request.</p>', 'TemplateVersionSummary$Status' => '<p>The status of the template version.</p>', 'ThemeVersion$Status' => '<p>The status of the theme version.</p>', 'ThemeVersionSummary$Status' => '<p>The status of the theme version.</p>', 'UpdateDashboardResponse$CreationStatus' => '<p>The creation status of the request.</p>', 'UpdateDataSourceResponse$UpdateStatus' => '<p>The update status of the data source\'s last update.</p>', 'UpdateTemplateResponse$CreationStatus' => '<p>The creation status of the template.</p>', 'UpdateThemeResponse$CreationStatus' => '<p>The creation status of the theme.</p>', ], ], 'ResourceUnavailableException' => [ 'base' => '<p>This resource is currently unavailable.</p>', 'refs' => [], ], 'RestrictiveResourceId' => [ 'base' => NULL, 'refs' => [ 'CreateDashboardRequest$DashboardId' => '<p>The ID for the dashboard, also added to the IAM policy.</p>', 'CreateDashboardResponse$DashboardId' => '<p>The ID for the dashboard.</p>', 'CreateTemplateAliasRequest$TemplateId' => '<p>An ID for the template.</p>', 'CreateTemplateRequest$TemplateId' => '<p>An ID for the template that you want to create. This template is unique per AWS Region in each AWS account.</p>', 'CreateTemplateResponse$TemplateId' => '<p>The ID of the template.</p>', 'CreateThemeAliasRequest$ThemeId' => '<p>An ID for the theme alias.</p>', 'CreateThemeRequest$ThemeId' => '<p>An ID for the theme that you want to create. The theme ID is unique per AWS Region in each AWS account.</p>', 'CreateThemeRequest$BaseThemeId' => '<p>The ID of the theme that a custom theme will inherit from. All themes inherit from one of the starting themes defined by Amazon QuickSight. For a list of the starting themes, use <code>ListThemes</code> or choose <b>Themes</b> from within a QuickSight analysis. </p>', 'CreateThemeResponse$ThemeId' => '<p>The ID of the theme.</p>', 'Dashboard$DashboardId' => '<p>Dashboard ID.</p>', 'DashboardSummary$DashboardId' => '<p>Dashboard ID.</p>', 'DeleteDashboardRequest$DashboardId' => '<p>The ID for the dashboard.</p>', 'DeleteDashboardResponse$DashboardId' => '<p>The ID of the dashboard.</p>', 'DeleteTemplateAliasRequest$TemplateId' => '<p>The ID for the template that the specified alias is for.</p>', 'DeleteTemplateAliasResponse$TemplateId' => '<p>An ID for the template associated with the deletion.</p>', 'DeleteTemplateRequest$TemplateId' => '<p>An ID for the template you want to delete.</p>', 'DeleteTemplateResponse$TemplateId' => '<p>An ID for the template.</p>', 'DeleteThemeAliasRequest$ThemeId' => '<p>The ID for the theme that the specified alias is for.</p>', 'DeleteThemeAliasResponse$ThemeId' => '<p>An ID for the theme associated with the deletion.</p>', 'DeleteThemeRequest$ThemeId' => '<p>An ID for the theme that you want to delete.</p>', 'DeleteThemeResponse$ThemeId' => '<p>An ID for the theme.</p>', 'DescribeDashboardPermissionsRequest$DashboardId' => '<p>The ID for the dashboard, also added to the IAM policy.</p>', 'DescribeDashboardPermissionsResponse$DashboardId' => '<p>The ID for the dashboard.</p>', 'DescribeDashboardRequest$DashboardId' => '<p>The ID for the dashboard.</p>', 'DescribeTemplateAliasRequest$TemplateId' => '<p>The ID for the template.</p>', 'DescribeTemplatePermissionsRequest$TemplateId' => '<p>The ID for the template.</p>', 'DescribeTemplatePermissionsResponse$TemplateId' => '<p>The ID for the template.</p>', 'DescribeTemplateRequest$TemplateId' => '<p>The ID for the template.</p>', 'DescribeThemeAliasRequest$ThemeId' => '<p>The ID for the theme.</p>', 'DescribeThemePermissionsRequest$ThemeId' => '<p>The ID for the theme that you want to describe permissions for.</p>', 'DescribeThemePermissionsResponse$ThemeId' => '<p>The ID for the theme.</p>', 'DescribeThemeRequest$ThemeId' => '<p>The ID for the theme.</p>', 'GetDashboardEmbedUrlRequest$DashboardId' => '<p>The ID for the dashboard, also added to the IAM policy.</p>', 'ListDashboardVersionsRequest$DashboardId' => '<p>The ID for the dashboard.</p>', 'ListTemplateAliasesRequest$TemplateId' => '<p>The ID for the template.</p>', 'ListTemplateVersionsRequest$TemplateId' => '<p>The ID for the template.</p>', 'ListThemeAliasesRequest$ThemeId' => '<p>The ID for the theme.</p>', 'ListThemeVersionsRequest$ThemeId' => '<p>The ID for the theme.</p>', 'Template$TemplateId' => '<p>The ID for the template. This is unique per AWS Region for each AWS account.</p>', 'TemplateSummary$TemplateId' => '<p>The ID of the template. This ID is unique per AWS Region for each AWS account.</p>', 'Theme$ThemeId' => '<p>The identifier that the user gives to the theme.</p>', 'ThemeSummary$ThemeId' => '<p>The ID of the theme. This ID is unique per AWS Region for each AWS account.</p>', 'ThemeVersion$BaseThemeId' => '<p>The Amazon QuickSight-defined ID of the theme that a custom theme inherits from. All themes initially inherit from a default QuickSight theme.</p>', 'UpdateDashboardPermissionsRequest$DashboardId' => '<p>The ID for the dashboard.</p>', 'UpdateDashboardPermissionsResponse$DashboardId' => '<p>The ID for the dashboard.</p>', 'UpdateDashboardPublishedVersionRequest$DashboardId' => '<p>The ID for the dashboard.</p>', 'UpdateDashboardPublishedVersionResponse$DashboardId' => '<p>The ID for the dashboard.</p>', 'UpdateDashboardRequest$DashboardId' => '<p>The ID for the dashboard.</p>', 'UpdateDashboardResponse$DashboardId' => '<p>The ID for the dashboard.</p>', 'UpdateTemplateAliasRequest$TemplateId' => '<p>The ID for the template.</p>', 'UpdateTemplatePermissionsRequest$TemplateId' => '<p>The ID for the template.</p>', 'UpdateTemplatePermissionsResponse$TemplateId' => '<p>The ID for the template.</p>', 'UpdateTemplateRequest$TemplateId' => '<p>The ID for the template.</p>', 'UpdateTemplateResponse$TemplateId' => '<p>The ID for the template.</p>', 'UpdateThemeAliasRequest$ThemeId' => '<p>The ID for the theme.</p>', 'UpdateThemePermissionsRequest$ThemeId' => '<p>The ID for the theme.</p>', 'UpdateThemePermissionsResponse$ThemeId' => '<p>The ID for the theme.</p>', 'UpdateThemeRequest$ThemeId' => '<p>The ID for the theme.</p>', 'UpdateThemeRequest$BaseThemeId' => '<p>The theme ID, defined by Amazon QuickSight, that a custom theme inherits from. All themes initially inherit from a default QuickSight theme.</p>', 'UpdateThemeResponse$ThemeId' => '<p>The ID for the theme.</p>', ], ], 'RoleName' => [ 'base' => NULL, 'refs' => [ 'RegisterUserRequest$CustomPermissionsName' => '<p>(Enterprise edition only) The name of the custom permissions profile that you want to assign to this user. Currently, custom permissions profile names are assigned to permissions profiles in the QuickSight console. You use this API to assign the named set of permissions to a QuickSight user. </p> <p>Customizing permissions in the QuickSight UI allows you to control a user\'s access to the following operations:</p> <ul> <li> <p/> </li> <li> <p/> </li> <li> <p/> </li> <li> <p/> </li> </ul> <p>QuickSight custom permissions are applied through IAM policies. Therefore, they override the permissions typically granted by assigning QuickSight users to one of the default security cohorts (admin, author, reader) in QuickSight.</p> <p>This feature is available only to QuickSight Enterprise edition subscriptions that use SAML 2.0-Based Federation for Single Sign-On (SSO).</p>', 'UpdateUserRequest$CustomPermissionsName' => '<p>The name of the custom permissions profile that you want to assign to this user. Currently, custom permissions profile names are assigned to permissions profiles in the QuickSight console. You use this API to assign the named set of permissions to a QuickSight user. </p>', 'User$CustomPermissionsName' => '<p>The custom permissions profile associated with this user.</p>', ], ], 'RoleSessionName' => [ 'base' => NULL, 'refs' => [ 'RegisterUserRequest$SessionName' => '<p>You need to use this parameter only when you register one or more users using an assumed IAM role. You don\'t need to provide the session name for other scenarios, for example when you are registering an IAM user or an Amazon QuickSight user. You can register multiple users using the same IAM role if each user has a different session name. For more information on assuming IAM roles, see <a href="https://awscli.amazonaws.com/v2/documentation/api/latest/reference/sts/assume-role.html"> <code>assume-role</code> </a> in the <i>AWS CLI Reference.</i> </p>', ], ], 'RowInfo' => [ 'base' => '<p>Information about rows for a data set SPICE ingestion.</p>', 'refs' => [ 'Ingestion$RowInfo' => NULL, ], ], 'RowLevelPermissionDataSet' => [ 'base' => '<p>The row-level security configuration for the dataset.</p>', 'refs' => [ 'CreateDataSetRequest$RowLevelPermissionDataSet' => '<p>The row-level security configuration for the data that you want to create.</p>', 'DataSet$RowLevelPermissionDataSet' => '<p>The row-level security configuration for the dataset.</p>', 'DataSetSummary$RowLevelPermissionDataSet' => '<p>The row-level security configuration for the dataset.</p>', 'UpdateDataSetRequest$RowLevelPermissionDataSet' => '<p>The row-level security configuration for the data you want to create.</p>', ], ], 'RowLevelPermissionPolicy' => [ 'base' => NULL, 'refs' => [ 'RowLevelPermissionDataSet$PermissionPolicy' => '<p>Permission policy.</p>', ], ], 'S3Bucket' => [ 'base' => NULL, 'refs' => [ 'ManifestFileLocation$Bucket' => '<p>Amazon S3 bucket.</p>', ], ], 'S3Key' => [ 'base' => NULL, 'refs' => [ 'ManifestFileLocation$Key' => '<p>Amazon S3 key that identifies an object.</p>', ], ], 'S3Parameters' => [ 'base' => '<p>S3 parameters.</p>', 'refs' => [ 'DataSourceParameters$S3Parameters' => '<p>S3 parameters.</p>', ], ], 'S3Source' => [ 'base' => '<p>A physical table type for as S3 data source.</p>', 'refs' => [ 'PhysicalTable$S3Source' => '<p>A physical table type for as S3 data source.</p>', ], ], 'SearchDashboardsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchDashboardsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ServiceNowParameters' => [ 'base' => '<p>ServiceNow parameters.</p>', 'refs' => [ 'DataSourceParameters$ServiceNowParameters' => '<p>ServiceNow parameters.</p>', ], ], 'SessionLifetimeInMinutes' => [ 'base' => NULL, 'refs' => [ 'GetDashboardEmbedUrlRequest$SessionLifetimeInMinutes' => '<p>How many minutes the session is valid. The session lifetime must be 15-600 minutes.</p>', 'GetSessionEmbedUrlRequest$SessionLifetimeInMinutes' => '<p>How many minutes the session is valid. The session lifetime must be 15-600 minutes.</p>', ], ], 'SessionLifetimeInMinutesInvalidException' => [ 'base' => '<p>The number of minutes specified for the lifetime of a session isn\'t valid. The session lifetime must be 15-600 minutes.</p>', 'refs' => [], ], 'SheetControlsOption' => [ 'base' => '<p>Sheet controls option.</p>', 'refs' => [ 'DashboardPublishOptions$SheetControlsOption' => '<p>Sheet controls option.</p>', ], ], 'SheetStyle' => [ 'base' => '<p>The theme display options for sheets. </p>', 'refs' => [ 'ThemeConfiguration$Sheet' => '<p>Display options related to sheets.</p>', ], ], 'SiteBaseUrl' => [ 'base' => NULL, 'refs' => [ 'JiraParameters$SiteBaseUrl' => '<p>The base URL of the Jira site.</p>', 'ServiceNowParameters$SiteBaseUrl' => '<p>URL of the base site.</p>', ], ], 'SnowflakeParameters' => [ 'base' => '<p>Snowflake parameters.</p>', 'refs' => [ 'DataSourceParameters$SnowflakeParameters' => '<p>Snowflake parameters.</p>', ], ], 'SparkParameters' => [ 'base' => '<p>Spark parameters.</p>', 'refs' => [ 'DataSourceParameters$SparkParameters' => '<p>Spark parameters.</p>', ], ], 'SqlQuery' => [ 'base' => NULL, 'refs' => [ 'CustomSql$SqlQuery' => '<p>The SQL query.</p>', ], ], 'SqlServerParameters' => [ 'base' => '<p>SQL Server parameters.</p>', 'refs' => [ 'DataSourceParameters$SqlServerParameters' => '<p>SQL Server parameters.</p>', ], ], 'SslProperties' => [ 'base' => '<p>Secure Socket Layer (SSL) properties that apply when QuickSight connects to your underlying data source.</p>', 'refs' => [ 'CreateDataSourceRequest$SslProperties' => '<p>Secure Socket Layer (SSL) properties that apply when QuickSight connects to your underlying source.</p>', 'DataSource$SslProperties' => '<p>Secure Socket Layer (SSL) properties that apply when QuickSight connects to your underlying source.</p>', 'UpdateDataSourceRequest$SslProperties' => '<p>Secure Socket Layer (SSL) properties that apply when QuickSight connects to your underlying source.</p>', ], ], 'StatusCode' => [ 'base' => NULL, 'refs' => [ 'CancelIngestionResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateAccountCustomizationResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateDashboardResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateDataSetResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateDataSourceResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateGroupMembershipResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateGroupResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateIAMPolicyAssignmentResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateIngestionResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateNamespaceResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateTemplateAliasResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateTemplateResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateThemeAliasResponse$Status' => '<p>The HTTP status of the request.</p>', 'CreateThemeResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteAccountCustomizationResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteDashboardResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteDataSetResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteDataSourceResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteGroupMembershipResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteGroupResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteIAMPolicyAssignmentResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteNamespaceResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteTemplateAliasResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteTemplateResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteThemeAliasResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteThemeResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteUserByPrincipalIdResponse$Status' => '<p>The HTTP status of the request.</p>', 'DeleteUserResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeAccountCustomizationResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeAccountSettingsResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeDashboardPermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeDashboardResponse$Status' => '<p>The HTTP status of this request.</p>', 'DescribeDataSetPermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeDataSetResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeDataSourcePermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeDataSourceResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeGroupResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeIAMPolicyAssignmentResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeIngestionResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeNamespaceResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeTemplateAliasResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeTemplatePermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeTemplateResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeThemeAliasResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeThemePermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeThemeResponse$Status' => '<p>The HTTP status of the request.</p>', 'DescribeUserResponse$Status' => '<p>The HTTP status of the request.</p>', 'GetDashboardEmbedUrlResponse$Status' => '<p>The HTTP status of the request.</p>', 'GetSessionEmbedUrlResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListDashboardVersionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListDashboardsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListDataSetsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListDataSourcesResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListGroupMembershipsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListGroupsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListIAMPolicyAssignmentsForUserResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListIAMPolicyAssignmentsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListIngestionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListNamespacesResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListTagsForResourceResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListTemplateAliasesResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListTemplateVersionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListTemplatesResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListThemeAliasesResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListThemeVersionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListThemesResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListUserGroupsResponse$Status' => '<p>The HTTP status of the request.</p>', 'ListUsersResponse$Status' => '<p>The HTTP status of the request.</p>', 'RegisterUserResponse$Status' => '<p>The HTTP status of the request.</p>', 'SearchDashboardsResponse$Status' => '<p>The HTTP status of the request.</p>', 'TagResourceResponse$Status' => '<p>The HTTP status of the request.</p>', 'UntagResourceResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateAccountCustomizationResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateAccountSettingsResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateDashboardPermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateDashboardPublishedVersionResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateDashboardResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateDataSetPermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateDataSetResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateDataSourcePermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateDataSourceResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateGroupResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateIAMPolicyAssignmentResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateTemplateAliasResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateTemplatePermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateTemplateResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateThemeAliasResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateThemePermissionsResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateThemeResponse$Status' => '<p>The HTTP status of the request.</p>', 'UpdateUserResponse$Status' => '<p>The HTTP status of the request.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'AccessDeniedException$RequestId' => '<p>The AWS request ID for this request.</p>', 'AccountSettings$AccountName' => '<p>The name associated with the QuickSight subscription in your AWS account.</p>', 'AccountSettings$NotificationEmail' => '<p>The main notification email for your QuickSight subscription.</p>', 'ActionList$member' => NULL, 'ColumnGroupColumnSchema$Name' => '<p>The name of the column group\'s column schema.</p>', 'ColumnGroupSchema$Name' => '<p>The name of the column group schema.</p>', 'ColumnSchema$Name' => '<p>The name of the column schema.</p>', 'ColumnSchema$DataType' => '<p>The data type of the column schema.</p>', 'ColumnSchema$GeographicRole' => '<p>The geographic role of the column schema.</p>', 'ConcurrentUpdatingException$Message' => NULL, 'ConcurrentUpdatingException$RequestId' => NULL, 'ConflictException$Message' => NULL, 'ConflictException$RequestId' => '<p>The AWS request ID for this request.</p>', 'CreateAccountCustomizationResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'CreateDashboardResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'CreateDataSetResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'CreateDataSourceResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'CreateGroupMembershipResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'CreateGroupResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'CreateIAMPolicyAssignmentResponse$AssignmentId' => '<p>The ID for the assignment.</p>', 'CreateIAMPolicyAssignmentResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'CreateNamespaceResponse$CapacityRegion' => '<p>The AWS Region that you want to use for the free SPICE capacity for the new namespace. This is set to the region that you run CreateNamespace in. </p>', 'CreateNamespaceResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'CreateTemplateAliasResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'CreateTemplateResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'CreateThemeAliasResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'CreateThemeResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DashboardSearchFilter$Value' => '<p>The value of the named item, in this case <code>QUICKSIGHT_USER</code>, that you want to use as a filter, for example, <code>"Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1"</code>. </p>', 'DataSetConfiguration$Placeholder' => '<p>Placeholder.</p>', 'DataSourceErrorInfo$Message' => '<p>Error message.</p>', 'DeleteAccountCustomizationResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DeleteDashboardResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DeleteDataSetResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DeleteDataSourceResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DeleteGroupMembershipResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DeleteGroupResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DeleteIAMPolicyAssignmentResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DeleteNamespaceResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DeleteTemplateAliasResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DeleteTemplateResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DeleteThemeAliasResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DeleteThemeResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DeleteUserByPrincipalIdRequest$PrincipalId' => '<p>The principal ID of the user.</p>', 'DeleteUserByPrincipalIdResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DeleteUserResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DescribeAccountCustomizationResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DescribeAccountSettingsResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DescribeDashboardPermissionsResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DescribeDashboardResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DescribeDataSetPermissionsResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DescribeDataSetResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DescribeDataSourcePermissionsResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DescribeDataSourceResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DescribeGroupResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DescribeIAMPolicyAssignmentResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DescribeNamespaceResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DescribeTemplateAliasResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DescribeTemplatePermissionsResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DescribeTemplateResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DescribeThemeAliasResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DescribeThemePermissionsResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DescribeThemeResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DescribeUserResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DomainNotWhitelistedException$Message' => NULL, 'DomainNotWhitelistedException$RequestId' => '<p>The AWS request ID for this request.</p>', 'GetDashboardEmbedUrlResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'GetSessionEmbedUrlResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'Group$PrincipalId' => '<p>The principal ID of the group.</p>', 'IAMPolicyAssignment$AssignmentId' => '<p>Assignment ID.</p>', 'IdentityMap$key' => NULL, 'IdentityTypeNotSupportedException$Message' => NULL, 'IdentityTypeNotSupportedException$RequestId' => '<p>The AWS request ID for this request.</p>', 'InternalFailureException$Message' => NULL, 'InternalFailureException$RequestId' => '<p>The AWS request ID for this request.</p>', 'InvalidNextTokenException$Message' => NULL, 'InvalidNextTokenException$RequestId' => '<p>The AWS request ID for this request.</p>', 'InvalidParameterValueException$Message' => NULL, 'InvalidParameterValueException$RequestId' => '<p>The AWS request ID for this request.</p>', 'LimitExceededException$Message' => NULL, 'LimitExceededException$RequestId' => '<p>The AWS request ID for this request.</p>', 'ListDashboardVersionsRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListDashboardVersionsResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListDashboardVersionsResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'ListDashboardsRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListDashboardsResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListDashboardsResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'ListDataSetsRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListDataSetsResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListDataSetsResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'ListDataSourcesRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListDataSourcesResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListDataSourcesResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'ListGroupMembershipsRequest$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListGroupMembershipsResponse$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListGroupMembershipsResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'ListGroupsRequest$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListGroupsResponse$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListGroupsResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'ListIAMPolicyAssignmentsForUserRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListIAMPolicyAssignmentsForUserResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'ListIAMPolicyAssignmentsForUserResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListIAMPolicyAssignmentsRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListIAMPolicyAssignmentsResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListIAMPolicyAssignmentsResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'ListNamespacesRequest$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListNamespacesResponse$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListNamespacesResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'ListTagsForResourceResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'ListTemplateAliasesRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListTemplateAliasesResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'ListTemplateAliasesResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListTemplateVersionsRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListTemplateVersionsResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListTemplateVersionsResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'ListTemplatesRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListTemplatesResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListTemplatesResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'ListThemeAliasesRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListThemeAliasesResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'ListThemeAliasesResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListThemeVersionsRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListThemeVersionsResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListThemeVersionsResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'ListThemesRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListThemesResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListThemesResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'ListUserGroupsRequest$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListUserGroupsResponse$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListUserGroupsResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'ListUsersRequest$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListUsersResponse$NextToken' => '<p>A pagination token that can be used in a subsequent request.</p>', 'ListUsersResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'NamespaceError$Message' => '<p>The message for the error.</p>', 'NamespaceInfoV2$CapacityRegion' => '<p>The namespace AWS Region.</p>', 'PreconditionNotMetException$Message' => NULL, 'PreconditionNotMetException$RequestId' => '<p>The AWS request ID for this request.</p>', 'ProjectedColumnList$member' => NULL, 'QuickSightUserNotFoundException$Message' => NULL, 'QuickSightUserNotFoundException$RequestId' => '<p>The AWS request ID for this request.</p>', 'RegisterUserRequest$Email' => '<p>The email address of the user that you want to register.</p>', 'RegisterUserRequest$IamArn' => '<p>The ARN of the IAM user or role that you are registering with Amazon QuickSight. </p>', 'RegisterUserResponse$UserInvitationUrl' => '<p>The URL the user visits to complete registration and provide a password. This is returned only for users with an identity type of <code>QUICKSIGHT</code>.</p>', 'RegisterUserResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'ResourceExistsException$Message' => NULL, 'ResourceExistsException$RequestId' => '<p>The AWS request ID for this request.</p>', 'ResourceNotFoundException$Message' => NULL, 'ResourceNotFoundException$RequestId' => '<p>The AWS request ID for this request.</p>', 'ResourceUnavailableException$Message' => NULL, 'ResourceUnavailableException$RequestId' => '<p>The AWS request ID for this request.</p>', 'SearchDashboardsRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'SearchDashboardsResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'SearchDashboardsResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'SessionLifetimeInMinutesInvalidException$Message' => NULL, 'SessionLifetimeInMinutesInvalidException$RequestId' => '<p>The AWS request ID for this request.</p>', 'StringList$member' => NULL, 'TagResourceResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'ThrottlingException$Message' => NULL, 'ThrottlingException$RequestId' => '<p>The AWS request ID for this request.</p>', 'UnsupportedUserEditionException$Message' => NULL, 'UnsupportedUserEditionException$RequestId' => '<p>The AWS request ID for this request.</p>', 'UntagResourceResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'UpdateAccountCustomizationResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'UpdateAccountSettingsRequest$NotificationEmail' => '<p>Email address used to send notifications regarding administration of QuickSight.</p>', 'UpdateAccountSettingsResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'UpdateDashboardPermissionsResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'UpdateDashboardPublishedVersionResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'UpdateDashboardResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'UpdateDataSetPermissionsResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'UpdateDataSetResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'UpdateDataSourcePermissionsResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'UpdateDataSourceResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'UpdateGroupResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'UpdateIAMPolicyAssignmentResponse$AssignmentId' => '<p>The ID of the assignment.</p>', 'UpdateIAMPolicyAssignmentResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'UpdateTemplateAliasResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'UpdateTemplatePermissionsResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'UpdateTemplateResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'UpdateThemeAliasResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'UpdateThemePermissionsResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'UpdateThemeResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'UpdateUserRequest$Email' => '<p>The email address of the user that you want to update.</p>', 'UpdateUserResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'User$Email' => '<p>The user\'s email address.</p>', 'User$PrincipalId' => '<p>The principal ID of the user.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'StringParameter$Values' => '<p>Values.</p>', ], ], 'StringParameter' => [ 'base' => '<p>String parameter.</p>', 'refs' => [ 'StringParameterList$member' => NULL, ], ], 'StringParameterList' => [ 'base' => NULL, 'refs' => [ 'Parameters$StringParameters' => '<p>String parameters.</p>', ], ], 'Tag' => [ 'base' => '<p>The key or keys of the key-value pairs for the resource tag or tags assigned to the resource.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagColumnOperation' => [ 'base' => '<p>A transform operation that tags a column with additional information.</p>', 'refs' => [ 'TransformOperation$TagColumnOperation' => '<p>An operation that tags a column with additional information.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>Tag key.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The keys of the key-value pairs for the resource tag or tags assigned to the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateDashboardRequest$Tags' => '<p>Contains a map of the key-value pairs for the resource tag or tags assigned to the dashboard.</p>', 'CreateDataSetRequest$Tags' => '<p>Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.</p>', 'CreateDataSourceRequest$Tags' => '<p>Contains a map of the key-value pairs for the resource tag or tags assigned to the data source.</p>', 'CreateNamespaceRequest$Tags' => '<p>The tags that you want to associate with the namespace that you\'re creating.</p>', 'CreateTemplateRequest$Tags' => '<p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>', 'CreateThemeRequest$Tags' => '<p>A map of the key-value pairs for the resource tag or tags that you want to add to the resource.</p>', 'ListTagsForResourceResponse$Tags' => '<p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>', 'TagResourceRequest$Tags' => '<p>Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>Tag value.</p>', ], ], 'Template' => [ 'base' => '<p>A template object. A <i>template</i> is an entity in QuickSight that encapsulates the metadata required to create an analysis and that you can use to create a dashboard. A template adds a layer of abstraction by using placeholders to replace the dataset associated with the analysis. You can use templates to create dashboards by replacing dataset placeholders with datasets that follow the same schema that was used to create the source analysis and template.</p> <p>You can share templates across AWS accounts by allowing users in other AWS accounts to create a template or a dashboard from an existing template.</p>', 'refs' => [ 'DescribeTemplateResponse$Template' => '<p>The template structure for the object you want to describe.</p>', ], ], 'TemplateAlias' => [ 'base' => '<p>The template alias.</p>', 'refs' => [ 'CreateTemplateAliasResponse$TemplateAlias' => '<p>Information about the template alias.</p>', 'DescribeTemplateAliasResponse$TemplateAlias' => '<p>Information about the template alias.</p>', 'TemplateAliasList$member' => NULL, 'UpdateTemplateAliasResponse$TemplateAlias' => '<p>The template alias.</p>', ], ], 'TemplateAliasList' => [ 'base' => NULL, 'refs' => [ 'ListTemplateAliasesResponse$TemplateAliasList' => '<p>A structure containing the list of the template\'s aliases.</p>', ], ], 'TemplateError' => [ 'base' => '<p>List of errors that occurred when the template version creation failed.</p>', 'refs' => [ 'TemplateErrorList$member' => NULL, ], ], 'TemplateErrorList' => [ 'base' => NULL, 'refs' => [ 'TemplateVersion$Errors' => '<p>Errors associated with the template.</p>', ], ], 'TemplateErrorType' => [ 'base' => NULL, 'refs' => [ 'TemplateError$Type' => '<p>Type of error.</p>', ], ], 'TemplateName' => [ 'base' => NULL, 'refs' => [ 'CreateTemplateRequest$Name' => '<p>A display name for the template.</p>', 'Template$Name' => '<p>The display name of the template.</p>', 'TemplateSummary$Name' => '<p>A display name for the template.</p>', 'UpdateTemplateRequest$Name' => '<p>The name for the template.</p>', ], ], 'TemplateSourceAnalysis' => [ 'base' => '<p>The source analysis of the template.</p>', 'refs' => [ 'TemplateSourceEntity$SourceAnalysis' => '<p>The source analysis, if it is based on an analysis.</p>', ], ], 'TemplateSourceEntity' => [ 'base' => '<p>The source entity of the template.</p>', 'refs' => [ 'CreateTemplateRequest$SourceEntity' => '<p>The entity that you are using as a source when you create the template. In <code>SourceEntity</code>, you specify the type of object you\'re using as source: <code>SourceTemplate</code> for a template or <code>SourceAnalysis</code> for an analysis. Both of these require an Amazon Resource Name (ARN). For <code>SourceTemplate</code>, specify the ARN of the source template. For <code>SourceAnalysis</code>, specify the ARN of the source analysis. The <code>SourceTemplate</code> ARN can contain any AWS Account and any QuickSight-supported AWS Region. </p> <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p>', 'UpdateTemplateRequest$SourceEntity' => '<p>The entity that you are using as a source when you update the template. In <code>SourceEntity</code>, you specify the type of object you\'re using as source: <code>SourceTemplate</code> for a template or <code>SourceAnalysis</code> for an analysis. Both of these require an Amazon Resource Name (ARN). For <code>SourceTemplate</code>, specify the ARN of the source template. For <code>SourceAnalysis</code>, specify the ARN of the source analysis. The <code>SourceTemplate</code> ARN can contain any AWS Account and any QuickSight-supported AWS Region. </p> <p>Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder. </p>', ], ], 'TemplateSourceTemplate' => [ 'base' => '<p>The source template of the template.</p>', 'refs' => [ 'TemplateSourceEntity$SourceTemplate' => '<p>The source template, if it is based on an template.</p>', ], ], 'TemplateSummary' => [ 'base' => '<p>The template summary.</p>', 'refs' => [ 'TemplateSummaryList$member' => NULL, ], ], 'TemplateSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListTemplatesResponse$TemplateSummaryList' => '<p>A structure containing information about the templates in the list.</p>', ], ], 'TemplateVersion' => [ 'base' => '<p>A version of a template.</p>', 'refs' => [ 'Template$Version' => '<p>A structure describing the versions of the template.</p>', ], ], 'TemplateVersionSummary' => [ 'base' => '<p>The template version.</p>', 'refs' => [ 'TemplateVersionSummaryList$member' => NULL, ], ], 'TemplateVersionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListTemplateVersionsResponse$TemplateVersionSummaryList' => '<p>A structure containing a list of all the versions of the specified template.</p>', ], ], 'TeradataParameters' => [ 'base' => '<p>Teradata parameters.</p>', 'refs' => [ 'DataSourceParameters$TeradataParameters' => '<p>Teradata parameters.</p>', ], ], 'TextQualifier' => [ 'base' => NULL, 'refs' => [ 'UploadSettings$TextQualifier' => '<p>Text qualifier.</p>', ], ], 'Theme' => [ 'base' => '<p/>', 'refs' => [ 'DescribeThemeResponse$Theme' => '<p>The information about the theme that you are describing.</p>', ], ], 'ThemeAlias' => [ 'base' => '<p>An alias for a theme.</p>', 'refs' => [ 'CreateThemeAliasResponse$ThemeAlias' => '<p>Information about the theme alias.</p>', 'DescribeThemeAliasResponse$ThemeAlias' => '<p>Information about the theme alias.</p>', 'ThemeAliasList$member' => NULL, 'UpdateThemeAliasResponse$ThemeAlias' => '<p>Information about the theme alias.</p>', ], ], 'ThemeAliasList' => [ 'base' => NULL, 'refs' => [ 'ListThemeAliasesResponse$ThemeAliasList' => '<p>A structure containing the list of the theme\'s aliases.</p>', ], ], 'ThemeConfiguration' => [ 'base' => '<p>The theme configuration. This configuration contains all of the display properties for a theme.</p>', 'refs' => [ 'CreateThemeRequest$Configuration' => '<p>The theme configuration, which contains the theme display properties.</p>', 'ThemeVersion$Configuration' => '<p>The theme configuration, which contains all the theme display properties.</p>', 'UpdateThemeRequest$Configuration' => '<p>The theme configuration, which contains the theme display properties.</p>', ], ], 'ThemeError' => [ 'base' => '<p>Theme error.</p>', 'refs' => [ 'ThemeErrorList$member' => NULL, ], ], 'ThemeErrorList' => [ 'base' => NULL, 'refs' => [ 'ThemeVersion$Errors' => '<p>Errors associated with the theme.</p>', ], ], 'ThemeErrorType' => [ 'base' => NULL, 'refs' => [ 'ThemeError$Type' => '<p>The type of error.</p>', ], ], 'ThemeName' => [ 'base' => NULL, 'refs' => [ 'CreateThemeRequest$Name' => '<p>A display name for the theme.</p>', 'Theme$Name' => '<p>The name that the user gives to the theme.</p>', 'ThemeSummary$Name' => '<p>the display name for the theme.</p>', 'UpdateThemeRequest$Name' => '<p>The name for the theme.</p>', ], ], 'ThemeSummary' => [ 'base' => '<p>The theme summary.</p>', 'refs' => [ 'ThemeSummaryList$member' => NULL, ], ], 'ThemeSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListThemesResponse$ThemeSummaryList' => '<p>Information about the themes in the list.</p>', ], ], 'ThemeType' => [ 'base' => NULL, 'refs' => [ 'ListThemesRequest$Type' => '<p>The type of themes that you want to list. Valid options include the following:</p> <ul> <li> <p> <code>ALL (default)</code>- Display all existing themes.</p> </li> <li> <p> <code>CUSTOM</code> - Display only the themes created by people using Amazon QuickSight.</p> </li> <li> <p> <code>QUICKSIGHT</code> - Display only the starting themes defined by QuickSight.</p> </li> </ul>', 'Theme$Type' => '<p>The type of theme, based on how it was created. Valid values include: <code>QUICKSIGHT</code> and <code>CUSTOM</code>.</p>', ], ], 'ThemeVersion' => [ 'base' => '<p>A version of a theme.</p>', 'refs' => [ 'Theme$Version' => NULL, ], ], 'ThemeVersionSummary' => [ 'base' => '<p>The theme version.</p>', 'refs' => [ 'ThemeVersionSummaryList$member' => NULL, ], ], 'ThemeVersionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListThemeVersionsResponse$ThemeVersionSummaryList' => '<p>A structure containing a list of all the versions of the specified theme.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>Access is throttled.</p>', 'refs' => [], ], 'TileLayoutStyle' => [ 'base' => '<p>The display options for the layout of tiles on a sheet.</p>', 'refs' => [ 'SheetStyle$TileLayout' => '<p>The layout options for tiles.</p>', ], ], 'TileStyle' => [ 'base' => '<p>Display options related to tiles on a sheet.</p>', 'refs' => [ 'SheetStyle$Tile' => '<p>The display options for tiles.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'Dashboard$CreatedTime' => '<p>The time that this dataset was created.</p>', 'Dashboard$LastPublishedTime' => '<p>The last time that this dataset was published.</p>', 'Dashboard$LastUpdatedTime' => '<p>The last time that this dataset was updated.</p>', 'DashboardSummary$CreatedTime' => '<p>The time that this dashboard was created.</p>', 'DashboardSummary$LastUpdatedTime' => '<p>The last time that this dashboard was updated.</p>', 'DashboardSummary$LastPublishedTime' => '<p>The last time that this dashboard was published.</p>', 'DashboardVersion$CreatedTime' => '<p>The time that this dashboard version was created.</p>', 'DashboardVersionSummary$CreatedTime' => '<p>The time that this dashboard version was created.</p>', 'DataSet$CreatedTime' => '<p>The time that this dataset was created.</p>', 'DataSet$LastUpdatedTime' => '<p>The last time that this dataset was updated.</p>', 'DataSetSummary$CreatedTime' => '<p>The time that this dataset was created.</p>', 'DataSetSummary$LastUpdatedTime' => '<p>The last time that this dataset was updated.</p>', 'DataSource$CreatedTime' => '<p>The time that this data source was created.</p>', 'DataSource$LastUpdatedTime' => '<p>The last time that this data source was updated.</p>', 'Template$LastUpdatedTime' => '<p>Time when this was last updated.</p>', 'Template$CreatedTime' => '<p>Time when this was created.</p>', 'TemplateSummary$CreatedTime' => '<p>The last time that this template was created.</p>', 'TemplateSummary$LastUpdatedTime' => '<p>The last time that this template was updated.</p>', 'TemplateVersion$CreatedTime' => '<p>The time that this template version was created.</p>', 'TemplateVersionSummary$CreatedTime' => '<p>The time that this template version was created.</p>', 'Theme$CreatedTime' => '<p>The date and time that the theme was created.</p>', 'Theme$LastUpdatedTime' => '<p>The date and time that the theme was last updated.</p>', 'ThemeSummary$CreatedTime' => '<p>The date and time that this theme was created.</p>', 'ThemeSummary$LastUpdatedTime' => '<p>The last date and time that this theme was updated.</p>', 'ThemeVersion$CreatedTime' => '<p>The date and time that this theme version was created.</p>', 'ThemeVersionSummary$CreatedTime' => '<p>The date and time that this theme version was created.</p>', 'TimestampList$member' => NULL, ], ], 'TimestampList' => [ 'base' => NULL, 'refs' => [ 'DateTimeParameter$Values' => '<p>Values.</p>', ], ], 'TransformOperation' => [ 'base' => '<p>A data transformation on a logical table. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.</p>', 'refs' => [ 'TransformOperationList$member' => NULL, ], ], 'TransformOperationList' => [ 'base' => NULL, 'refs' => [ 'LogicalTable$DataTransforms' => '<p>Transform operations that act on this logical table.</p>', ], ], 'TwitterParameters' => [ 'base' => '<p>Twitter parameters.</p>', 'refs' => [ 'DataSourceParameters$TwitterParameters' => '<p>Twitter parameters.</p>', ], ], 'TypeCastFormat' => [ 'base' => NULL, 'refs' => [ 'CastColumnTypeOperation$Format' => '<p>When casting a column from string to datetime type, you can supply a string in a format supported by Amazon QuickSight to denote the source data format.</p>', ], ], 'UIColorPalette' => [ 'base' => '<p>The theme colors that apply to UI and to charts, excluding data colors. The colors description is a hexidecimal color code that consists of six alphanumerical characters, prefixed with <code>#</code>, for example #37BFF5. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html">Using Themes in Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide.</i> </p>', 'refs' => [ 'ThemeConfiguration$UIColorPalette' => '<p>Color properties that apply to the UI and to charts, excluding the colors that apply to data. </p>', ], ], 'UnsupportedUserEditionException' => [ 'base' => '<p>This error indicates that you are calling an operation on an Amazon QuickSight subscription where the edition doesn\'t include support for that operation. Amazon QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is available in every edition.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccountCustomizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccountCustomizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccountSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccountSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDashboardPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDashboardPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDashboardPublishedVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDashboardPublishedVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDashboardRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDashboardResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSetPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSetPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSourcePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSourcePermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIAMPolicyAssignmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIAMPolicyAssignmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourcePermissionList' => [ 'base' => NULL, 'refs' => [ 'UpdateDashboardPermissionsRequest$GrantPermissions' => '<p>The permissions that you want to grant on this resource.</p>', 'UpdateDashboardPermissionsRequest$RevokePermissions' => '<p>The permissions that you want to revoke from this resource.</p>', 'UpdateTemplatePermissionsRequest$GrantPermissions' => '<p>A list of resource permissions to be granted on the template. </p>', 'UpdateTemplatePermissionsRequest$RevokePermissions' => '<p>A list of resource permissions to be revoked from the template. </p>', 'UpdateThemePermissionsRequest$GrantPermissions' => '<p>A list of resource permissions to be granted for the theme.</p>', 'UpdateThemePermissionsRequest$RevokePermissions' => '<p>A list of resource permissions to be revoked from the theme.</p>', ], ], 'UpdateTemplateAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTemplateAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTemplatePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTemplatePermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateThemeAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateThemeAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateThemePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateThemePermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateThemeRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateThemeResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'UploadSettings' => [ 'base' => '<p>Information about the format for a source file or files.</p>', 'refs' => [ 'S3Source$UploadSettings' => '<p>Information about the format for the S3 source file or files.</p>', ], ], 'User' => [ 'base' => '<p>A registered user of Amazon QuickSight. Currently, an Amazon QuickSight subscription can\'t contain more than 20 million users.</p>', 'refs' => [ 'DescribeUserResponse$User' => '<p>The user name.</p>', 'RegisterUserResponse$User' => '<p>The user name.</p>', 'UpdateUserResponse$User' => '<p>The Amazon QuickSight user.</p>', 'UserList$member' => NULL, ], ], 'UserList' => [ 'base' => NULL, 'refs' => [ 'ListUsersResponse$UserList' => '<p>The list of users.</p>', ], ], 'UserName' => [ 'base' => NULL, 'refs' => [ 'DeleteUserRequest$UserName' => '<p>The name of the user that you want to delete.</p>', 'DescribeUserRequest$UserName' => '<p>The name of the user that you want to describe.</p>', 'ListIAMPolicyAssignmentsForUserRequest$UserName' => '<p>The name of the user.</p>', 'ListUserGroupsRequest$UserName' => '<p>The Amazon QuickSight user name that you want to list group memberships for.</p>', 'RegisterUserRequest$UserName' => '<p>The Amazon QuickSight user name that you want to create for the user you are registering.</p>', 'UpdateUserRequest$UserName' => '<p>The Amazon QuickSight user name that you want to update.</p>', 'User$UserName' => '<p>The user\'s user name.</p>', ], ], 'UserRole' => [ 'base' => NULL, 'refs' => [ 'RegisterUserRequest$UserRole' => '<p>The Amazon QuickSight role for the user. The user role can be one of the following:</p> <ul> <li> <p> <code>READER</code>: A user who has read-only access to dashboards.</p> </li> <li> <p> <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.</p> </li> <li> <p> <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.</p> </li> <li> <p> <code>RESTRICTED_READER</code>: This role isn\'t currently available for use.</p> </li> <li> <p> <code>RESTRICTED_AUTHOR</code>: This role isn\'t currently available for use.</p> </li> </ul>', 'UpdateUserRequest$Role' => '<p>The Amazon QuickSight role of the user. The user role can be one of the following:</p> <ul> <li> <p> <code>READER</code>: A user who has read-only access to dashboards.</p> </li> <li> <p> <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.</p> </li> <li> <p> <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.</p> </li> </ul>', 'User$Role' => '<p>The Amazon QuickSight role for the user. The user role can be one of the following:.</p> <ul> <li> <p> <code>READER</code>: A user who has read-only access to dashboards.</p> </li> <li> <p> <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.</p> </li> <li> <p> <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.</p> </li> <li> <p> <code>RESTRICTED_READER</code>: This role isn\'t currently available for use.</p> </li> <li> <p> <code>RESTRICTED_AUTHOR</code>: This role isn\'t currently available for use.</p> </li> </ul>', ], ], 'Username' => [ 'base' => NULL, 'refs' => [ 'CredentialPair$Username' => '<p>User name.</p>', ], ], 'VersionDescription' => [ 'base' => NULL, 'refs' => [ 'CreateDashboardRequest$VersionDescription' => '<p>A description for the first version of the dashboard being created.</p>', 'CreateTemplateRequest$VersionDescription' => '<p>A description of the current template version being created. This API operation creates the first version of the template. Every time <code>UpdateTemplate</code> is called, a new version is created. Each version of the template maintains a description of the version in the <code>VersionDescription</code> field.</p>', 'CreateThemeRequest$VersionDescription' => '<p>A description of the first version of the theme that you\'re creating. Every time <code>UpdateTheme</code> is called, a new version is created. Each version of the theme has a description of the version in the <code>VersionDescription</code> field.</p>', 'DashboardVersion$Description' => '<p>Description.</p>', 'DashboardVersionSummary$Description' => '<p>Description.</p>', 'TemplateVersion$Description' => '<p>The description of the template.</p>', 'TemplateVersionSummary$Description' => '<p>The description of the template version.</p>', 'ThemeVersion$Description' => '<p>The description of the theme.</p>', 'ThemeVersionSummary$Description' => '<p>The description of the theme version.</p>', 'UpdateDashboardRequest$VersionDescription' => '<p>A description for the first version of the dashboard being created.</p>', 'UpdateTemplateRequest$VersionDescription' => '<p>A description of the current template version that is being updated. Every time you call <code>UpdateTemplate</code>, you create a new version of the template. Each version of the template maintains a description of the version in the <code>VersionDescription</code> field.</p>', 'UpdateThemeRequest$VersionDescription' => '<p>A description of the theme version that you\'re updating Every time that you call <code>UpdateTheme</code>, you create a new version of the theme. Each version of the theme maintains a description of the version in <code>VersionDescription</code>.</p>', ], ], 'VersionNumber' => [ 'base' => NULL, 'refs' => [ 'CreateTemplateAliasRequest$TemplateVersionNumber' => '<p>The version number of the template.</p>', 'CreateThemeAliasRequest$ThemeVersionNumber' => '<p>The version number of the theme.</p>', 'DashboardSummary$PublishedVersionNumber' => '<p>Published version number.</p>', 'DashboardVersion$VersionNumber' => '<p>Version number.</p>', 'DashboardVersionSummary$VersionNumber' => '<p>Version number.</p>', 'DeleteDashboardRequest$VersionNumber' => '<p>The version number of the dashboard. If the version number property is provided, only the specified version of the dashboard is deleted.</p>', 'DeleteTemplateRequest$VersionNumber' => '<p>Specifies the version of the template that you want to delete. If you don\'t provide a version number, <code>DeleteTemplate</code> deletes all versions of the template. </p>', 'DeleteThemeRequest$VersionNumber' => '<p>The version of the theme that you want to delete. </p> <p> <b>Note:</b> If you don\'t provide a version number, you\'re using this call to <code>DeleteTheme</code> to delete all versions of the theme.</p>', 'DescribeDashboardRequest$VersionNumber' => '<p>The version number for the dashboard. If a version number isn\'t passed, the latest published dashboard version is described. </p>', 'DescribeTemplateRequest$VersionNumber' => '<p>(Optional) The number for the version to describe. If a <code>VersionNumber</code> parameter value isn\'t provided, the latest version of the template is described.</p>', 'DescribeThemeRequest$VersionNumber' => '<p>The version number for the version to describe. If a <code>VersionNumber</code> parameter value isn\'t provided, the latest version of the theme is described.</p>', 'TemplateAlias$TemplateVersionNumber' => '<p>The version number of the template alias.</p>', 'TemplateSummary$LatestVersionNumber' => '<p>A structure containing a list of version numbers for the template summary.</p>', 'TemplateVersion$VersionNumber' => '<p>The version number of the template.</p>', 'TemplateVersionSummary$VersionNumber' => '<p>The version number of the template version.</p>', 'ThemeAlias$ThemeVersionNumber' => '<p>The version number of the theme alias.</p>', 'ThemeSummary$LatestVersionNumber' => '<p>The latest version number for the theme. </p>', 'ThemeVersion$VersionNumber' => '<p>The version number of the theme.</p>', 'ThemeVersionSummary$VersionNumber' => '<p>The version number of the theme version.</p>', 'UpdateDashboardPublishedVersionRequest$VersionNumber' => '<p>The version number of the dashboard.</p>', 'UpdateTemplateAliasRequest$TemplateVersionNumber' => '<p>The version number of the template.</p>', 'UpdateThemeAliasRequest$ThemeVersionNumber' => '<p>The version number of the theme that the alias should reference.</p>', ], ], 'VpcConnectionProperties' => [ 'base' => '<p>VPC connection properties.</p>', 'refs' => [ 'CreateDataSourceRequest$VpcConnectionProperties' => '<p>Use this parameter only when you want QuickSight to use a VPC connection when connecting to your underlying source.</p>', 'DataSource$VpcConnectionProperties' => '<p>The VPC connection information. You need to use this parameter only when you want QuickSight to use a VPC connection when connecting to your underlying source.</p>', 'UpdateDataSourceRequest$VpcConnectionProperties' => '<p>Use this parameter only when you want QuickSight to use a VPC connection when connecting to your underlying source.</p>', ], ], 'Warehouse' => [ 'base' => NULL, 'refs' => [ 'SnowflakeParameters$Warehouse' => '<p>Warehouse.</p>', ], ], 'WorkGroup' => [ 'base' => NULL, 'refs' => [ 'AthenaParameters$WorkGroup' => '<p>The workgroup that Amazon Athena uses.</p>', ], ], 'boolean' => [ 'base' => NULL, 'refs' => [ 'BorderStyle$Show' => '<p>The option to enable display of borders for visuals.</p>', 'DescribeAccountCustomizationRequest$Resolved' => '<p>The status of the creation of the customization. This is an asynchronous process. A status of <code>CREATED</code> means that your customization is ready to use.</p>', 'GetDashboardEmbedUrlRequest$UndoRedoDisabled' => '<p>Remove the undo/redo button on the embedded dashboard. The default is FALSE, which enables the undo/redo button.</p>', 'GetDashboardEmbedUrlRequest$ResetDisabled' => '<p>Remove the reset button on the embedded dashboard. The default is FALSE, which enables the reset button.</p>', 'GutterStyle$Show' => '<p>This Boolean value controls whether to display a gutter space between sheet tiles. </p>', 'MarginStyle$Show' => '<p>This Boolean value controls whether to display sheet margins.</p>', ], ], 'long' => [ 'base' => NULL, 'refs' => [ 'Ingestion$IngestionTimeInSeconds' => '<p>The time that this ingestion took, measured in seconds.</p>', 'Ingestion$IngestionSizeInBytes' => '<p>The size of the data ingested, in bytes.</p>', 'RowInfo$RowsIngested' => '<p>The number of rows that were ingested.</p>', 'RowInfo$RowsDropped' => '<p>The number of rows that were not ingested.</p>', ], ], 'string' => [ 'base' => NULL, 'refs' => [ 'CancelIngestionRequest$DataSetId' => '<p>The ID of the dataset used in the ingestion.</p>', 'CancelIngestionResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'CreateIngestionRequest$DataSetId' => '<p>The ID of the dataset used in the ingestion.</p>', 'CreateIngestionResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'DescribeIngestionRequest$DataSetId' => '<p>The ID of the dataset used in the ingestion.</p>', 'DescribeIngestionResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'ErrorInfo$Message' => '<p>Error message.</p>', 'ListIngestionsRequest$DataSetId' => '<p>The ID of the dataset used in the ingestion.</p>', 'ListIngestionsRequest$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListIngestionsResponse$NextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListIngestionsResponse$RequestId' => '<p>The AWS request ID for this operation.</p>', 'QueueInfo$WaitingOnIngestion' => '<p>The ID of the queued ingestion.</p>', 'QueueInfo$QueuedIngestion' => '<p>The ID of the ongoing ingestion. The queued ingestion is waiting for the ongoing ingestion to complete.</p>', ], ], 'timestamp' => [ 'base' => NULL, 'refs' => [ 'Ingestion$CreatedTime' => '<p>The time that this ingestion started.</p>', ], ], ],];
