<?php
// This file was auto-generated from sdk-root/src/data/personalize-events/2018-03-22/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Personalize can consume real-time user event data, such as <i>stream</i> or <i>click</i> data, and use it for model training either alone or combined with historical data. For more information see <a>recording-events</a>.</p>', 'operations' => [ 'PutEvents' => '<p>Records user interaction event data. For more information see <a>event-record-api</a>.</p>', ], 'shapes' => [ 'Date' => [ 'base' => NULL, 'refs' => [ 'Event$sentAt' => '<p>The timestamp (in Unix time) on the client side when the event occurred.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'InvalidInputException$message' => NULL, ], ], 'Event' => [ 'base' => '<p>Represents user interaction event information sent using the <code>PutEvents</code> API.</p>', 'refs' => [ 'EventList$member' => NULL, ], ], 'EventList' => [ 'base' => NULL, 'refs' => [ 'PutEventsRequest$eventList' => '<p>A list of event data from the session.</p>', ], ], 'EventPropertiesJSON' => [ 'base' => NULL, 'refs' => [ 'Event$properties' => '<p>A string map of event-specific data that you might choose to record. For example, if a user rates a movie on your site, other than movie ID (<code>itemId</code>) and rating (<code>eventValue</code>) , you might also send the number of movie ratings made by the user.</p> <p>Each item in the map consists of a key-value pair. For example,</p> <p> <code>{"numberOfRatings": "12"}</code> </p> <p>The keys use camel case names that match the fields in the Interactions schema. In the above example, the <code>numberOfRatings</code> would match the \'NUMBER_OF_RATINGS\' field defined in the Interactions schema.</p>', ], ], 'FloatType' => [ 'base' => NULL, 'refs' => [ 'Event$eventValue' => '<p>The event value that corresponds to the <code>EVENT_VALUE</code> field of the Interactions schema.</p>', ], ], 'Impression' => [ 'base' => NULL, 'refs' => [ 'Event$impression' => '<p>A list of item IDs that represents the sequence of items you have shown the user. For example, <code>["itemId1", "itemId2", "itemId3"]</code>.</p>', ], ], 'InvalidInputException' => [ 'base' => '<p>Provide a valid value for the field or parameter.</p>', 'refs' => [], ], 'ItemId' => [ 'base' => NULL, 'refs' => [ 'Event$itemId' => '<p>The item ID key that corresponds to the <code>ITEM_ID</code> field of the Interactions schema.</p>', 'Impression$member' => NULL, ], ], 'PutEventsRequest' => [ 'base' => NULL, 'refs' => [], ], 'RecommendationId' => [ 'base' => NULL, 'refs' => [ 'Event$recommendationId' => '<p>The ID of the recommendation.</p>', ], ], 'StringType' => [ 'base' => NULL, 'refs' => [ 'Event$eventId' => '<p>An ID associated with the event. If an event ID is not provided, Amazon Personalize generates a unique ID for the event. An event ID is not used as an input to the model. Amazon Personalize uses the event ID to distinquish unique events. Any subsequent events after the first with the same event ID are not used in model training.</p>', 'Event$eventType' => '<p>The type of event. This property corresponds to the <code>EVENT_TYPE</code> field of the Interactions schema.</p>', 'PutEventsRequest$trackingId' => '<p>The tracking ID for the event. The ID is generated by a call to the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html">CreateEventTracker</a> API.</p>', 'PutEventsRequest$sessionId' => '<p>The session ID associated with the user\'s visit. Your application generates the sessionId when a user first visits your website or uses your application. Amazon Personalize uses the sessionId to associate events with the user before they log in. For more information see <a>event-record-api</a>.</p>', ], ], 'UserId' => [ 'base' => NULL, 'refs' => [ 'PutEventsRequest$userId' => '<p>The user associated with the event.</p>', ], ], ],];
