<?php
// This file was auto-generated from sdk-root/src/data/monitoring/2010-08-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon CloudWatch monitors your Amazon Web Services (AWS) resources and the applications you run on AWS in real time. You can use CloudWatch to collect and track metrics, which are the variables you want to measure for your resources and applications.</p> <p>CloudWatch alarms send notifications or automatically change the resources you are monitoring based on rules that you define. For example, you can monitor the CPU usage and disk reads and writes of your Amazon EC2 instances. Then, use this data to determine whether you should launch additional instances to handle increased load. You can also use this data to stop under-used instances to save money.</p> <p>In addition to monitoring the built-in metrics that come with AWS, you can monitor your own custom metrics. With CloudWatch, you gain system-wide visibility into resource utilization, application performance, and operational health.</p>', 'operations' => [ 'DeleteAlarms' => '<p>Deletes the specified alarms. You can delete up to 100 alarms in one operation. However, this total can include no more than one composite alarm. For example, you could delete 99 metric alarms and one composite alarms with one operation, but you can\'t delete two composite alarms with one operation.</p> <p> In the event of an error, no alarms are deleted.</p> <note> <p>It is possible to create a loop or cycle of composite alarms, where composite alarm A depends on composite alarm B, and composite alarm B also depends on composite alarm A. In this scenario, you can\'t delete any composite alarm that is part of the cycle because there is always still a composite alarm that depends on that alarm that you want to delete.</p> <p>To get out of such a situation, you must break the cycle by changing the rule of one of the composite alarms in the cycle to remove a dependency that creates the cycle. The simplest change to make to break a cycle is to change the <code>AlarmRule</code> of one of the alarms to <code>False</code>. </p> <p>Additionally, the evaluation of composite alarms stops if CloudWatch detects a cycle in the evaluation path. </p> </note>', 'DeleteAnomalyDetector' => '<p>Deletes the specified anomaly detection model from your account.</p>', 'DeleteDashboards' => '<p>Deletes all dashboards that you specify. You can specify up to 100 dashboards to delete. If there is an error during this call, no dashboards are deleted.</p>', 'DeleteInsightRules' => '<p>Permanently deletes the specified Contributor Insights rules.</p> <p>If you create a rule, delete it, and then re-create it with the same name, historical data from the first time the rule was created might not be available.</p>', 'DescribeAlarmHistory' => '<p>Retrieves the history for the specified alarm. You can filter the results by date range or item type. If an alarm name is not specified, the histories for either all metric alarms or all composite alarms are returned.</p> <p>CloudWatch retains the history of an alarm even if you delete the alarm.</p>', 'DescribeAlarms' => '<p>Retrieves the specified alarms. You can filter the results by specifying a a prefix for the alarm name, the alarm state, or a prefix for any action.</p>', 'DescribeAlarmsForMetric' => '<p>Retrieves the alarms for the specified metric. To filter the results, specify a statistic, period, or unit.</p>', 'DescribeAnomalyDetectors' => '<p>Lists the anomaly detection models that you have created in your account. You can list all models in your account or filter the results to only the models that are related to a certain namespace, metric name, or metric dimension.</p>', 'DescribeInsightRules' => '<p>Returns a list of all the Contributor Insights rules in your account. All rules in your account are returned with a single operation.</p> <p>For more information about Contributor Insights, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights.html">Using Contributor Insights to Analyze High-Cardinality Data</a>.</p>', 'DisableAlarmActions' => '<p>Disables the actions for the specified alarms. When an alarm\'s actions are disabled, the alarm actions do not execute when the alarm state changes.</p>', 'DisableInsightRules' => '<p>Disables the specified Contributor Insights rules. When rules are disabled, they do not analyze log groups and do not incur costs.</p>', 'EnableAlarmActions' => '<p>Enables the actions for the specified alarms.</p>', 'EnableInsightRules' => '<p>Enables the specified Contributor Insights rules. When rules are enabled, they immediately begin analyzing log data.</p>', 'GetDashboard' => '<p>Displays the details of the dashboard that you specify.</p> <p>To copy an existing dashboard, use <code>GetDashboard</code>, and then use the data returned within <code>DashboardBody</code> as the template for the new dashboard when you call <code>PutDashboard</code> to create the copy.</p>', 'GetInsightRuleReport' => '<p>This operation returns the time series data collected by a Contributor Insights rule. The data includes the identity and number of contributors to the log group.</p> <p>You can also optionally return one or more statistics about each data point in the time series. These statistics can include the following:</p> <ul> <li> <p> <code>UniqueContributors</code> -- the number of unique contributors for each data point.</p> </li> <li> <p> <code>MaxContributorValue</code> -- the value of the top contributor for each data point. The identity of the contributor might change for each data point in the graph.</p> <p>If this rule aggregates by COUNT, the top contributor for each data point is the contributor with the most occurrences in that period. If the rule aggregates by SUM, the top contributor is the contributor with the highest sum in the log field specified by the rule\'s <code>Value</code>, during that period.</p> </li> <li> <p> <code>SampleCount</code> -- the number of data points matched by the rule.</p> </li> <li> <p> <code>Sum</code> -- the sum of the values from all contributors during the time period represented by that data point.</p> </li> <li> <p> <code>Minimum</code> -- the minimum value from a single observation during the time period represented by that data point.</p> </li> <li> <p> <code>Maximum</code> -- the maximum value from a single observation during the time period represented by that data point.</p> </li> <li> <p> <code>Average</code> -- the average value from all contributors during the time period represented by that data point.</p> </li> </ul>', 'GetMetricData' => '<p>You can use the <code>GetMetricData</code> API to retrieve as many as 500 different metrics in a single request, with a total of as many as 100,800 data points. You can also optionally perform math expressions on the values of the returned statistics, to create new time series that represent new insights into your data. For example, using Lambda metrics, you could divide the Errors metric by the Invocations metric to get an error rate time series. For more information about metric math expressions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax">Metric Math Syntax and Functions</a> in the <i>Amazon CloudWatch User Guide</i>.</p> <p>Calls to the <code>GetMetricData</code> API have a different pricing structure than calls to <code>GetMetricStatistics</code>. For more information about pricing, see <a href="https://aws.amazon.com/cloudwatch/pricing/">Amazon CloudWatch Pricing</a>.</p> <p>Amazon CloudWatch retains metric data as follows:</p> <ul> <li> <p>Data points with a period of less than 60 seconds are available for 3 hours. These data points are high-resolution metrics and are available only for custom metrics that have been defined with a <code>StorageResolution</code> of 1.</p> </li> <li> <p>Data points with a period of 60 seconds (1-minute) are available for 15 days.</p> </li> <li> <p>Data points with a period of 300 seconds (5-minute) are available for 63 days.</p> </li> <li> <p>Data points with a period of 3600 seconds (1 hour) are available for 455 days (15 months).</p> </li> </ul> <p>Data points that are initially published with a shorter period are aggregated together for long-term storage. For example, if you collect data using a period of 1 minute, the data remains available for 15 days with 1-minute resolution. After 15 days, this data is still available, but is aggregated and retrievable only with a resolution of 5 minutes. After 63 days, the data is further aggregated and is available with a resolution of 1 hour.</p> <p>If you omit <code>Unit</code> in your request, all data that was collected with any unit is returned, along with the corresponding units that were specified when the data was reported to CloudWatch. If you specify a unit, the operation returns only data that was collected with that unit specified. If you specify a unit that does not match the data collected, the results of the operation are null. CloudWatch does not perform unit conversions.</p>', 'GetMetricStatistics' => '<p>Gets statistics for the specified metric.</p> <p>The maximum number of data points returned from a single call is 1,440. If you request more than 1,440 data points, CloudWatch returns an error. To reduce the number of data points, you can narrow the specified time range and make multiple requests across adjacent time ranges, or you can increase the specified period. Data points are not returned in chronological order.</p> <p>CloudWatch aggregates data points based on the length of the period that you specify. For example, if you request statistics with a one-hour period, CloudWatch aggregates all data points with time stamps that fall within each one-hour period. Therefore, the number of values aggregated by CloudWatch is larger than the number of data points returned.</p> <p>CloudWatch needs raw data points to calculate percentile statistics. If you publish data using a statistic set instead, you can only retrieve percentile statistics for this data if one of the following conditions is true:</p> <ul> <li> <p>The SampleCount value of the statistic set is 1.</p> </li> <li> <p>The Min and the Max values of the statistic set are equal.</p> </li> </ul> <p>Percentile statistics are not available for metrics when any of the metric values are negative numbers.</p> <p>Amazon CloudWatch retains metric data as follows:</p> <ul> <li> <p>Data points with a period of less than 60 seconds are available for 3 hours. These data points are high-resolution metrics and are available only for custom metrics that have been defined with a <code>StorageResolution</code> of 1.</p> </li> <li> <p>Data points with a period of 60 seconds (1-minute) are available for 15 days.</p> </li> <li> <p>Data points with a period of 300 seconds (5-minute) are available for 63 days.</p> </li> <li> <p>Data points with a period of 3600 seconds (1 hour) are available for 455 days (15 months).</p> </li> </ul> <p>Data points that are initially published with a shorter period are aggregated together for long-term storage. For example, if you collect data using a period of 1 minute, the data remains available for 15 days with 1-minute resolution. After 15 days, this data is still available, but is aggregated and retrievable only with a resolution of 5 minutes. After 63 days, the data is further aggregated and is available with a resolution of 1 hour.</p> <p>CloudWatch started retaining 5-minute and 1-hour metric data as of July 9, 2016.</p> <p>For information about metrics and dimensions supported by AWS services, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CW_Support_For_AWS.html">Amazon CloudWatch Metrics and Dimensions Reference</a> in the <i>Amazon CloudWatch User Guide</i>.</p>', 'GetMetricWidgetImage' => '<p>You can use the <code>GetMetricWidgetImage</code> API to retrieve a snapshot graph of one or more Amazon CloudWatch metrics as a bitmap image. You can then embed this image into your services and products, such as wiki pages, reports, and documents. You could also retrieve images regularly, such as every minute, and create your own custom live dashboard.</p> <p>The graph you retrieve can include all CloudWatch metric graph features, including metric math and horizontal and vertical annotations.</p> <p>There is a limit of 20 transactions per second for this API. Each <code>GetMetricWidgetImage</code> action has the following limits:</p> <ul> <li> <p>As many as 100 metrics in the graph.</p> </li> <li> <p>Up to 100 KB uncompressed payload.</p> </li> </ul>', 'ListDashboards' => '<p>Returns a list of the dashboards for your account. If you include <code>DashboardNamePrefix</code>, only those dashboards with names starting with the prefix are listed. Otherwise, all dashboards in your account are listed. </p> <p> <code>ListDashboards</code> returns up to 1000 results on one page. If there are more than 1000 dashboards, you can call <code>ListDashboards</code> again and include the value you received for <code>NextToken</code> in the first call, to receive the next 1000 results.</p>', 'ListMetrics' => '<p>List the specified metrics. You can use the returned metrics with <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricData.html">GetMetricData</a> or <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricStatistics.html">GetMetricStatistics</a> to obtain statistical data.</p> <p>Up to 500 results are returned for any one call. To retrieve additional results, use the returned token with subsequent calls.</p> <p>After you create a metric, allow up to 15 minutes before the metric appears. You can see statistics about the metric sooner by using <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricData.html">GetMetricData</a> or <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricStatistics.html">GetMetricStatistics</a>.</p> <p> <code>ListMetrics</code> doesn\'t return information about metrics if those metrics haven\'t reported data in the past two weeks. To retrieve those metrics, use <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricData.html">GetMetricData</a> or <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricStatistics.html">GetMetricStatistics</a>.</p>', 'ListTagsForResource' => '<p>Displays the tags associated with a CloudWatch resource. Currently, alarms and Contributor Insights rules support tagging.</p>', 'PutAnomalyDetector' => '<p>Creates an anomaly detection model for a CloudWatch metric. You can use the model to display a band of expected normal values when the metric is graphed.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Anomaly_Detection.html">CloudWatch Anomaly Detection</a>.</p>', 'PutCompositeAlarm' => '<p>Creates or updates a <i>composite alarm</i>. When you create a composite alarm, you specify a rule expression for the alarm that takes into account the alarm states of other alarms that you have created. The composite alarm goes into ALARM state only if all conditions of the rule are met.</p> <p>The alarms specified in a composite alarm\'s rule expression can include metric alarms and other composite alarms.</p> <p>Using composite alarms can reduce alarm noise. You can create multiple metric alarms, and also create a composite alarm and set up alerts only for the composite alarm. For example, you could create a composite alarm that goes into ALARM state only when more than one of the underlying metric alarms are in ALARM state.</p> <p>Currently, the only alarm actions that can be taken by composite alarms are notifying SNS topics.</p> <note> <p>It is possible to create a loop or cycle of composite alarms, where composite alarm A depends on composite alarm B, and composite alarm B also depends on composite alarm A. In this scenario, you can\'t delete any composite alarm that is part of the cycle because there is always still a composite alarm that depends on that alarm that you want to delete.</p> <p>To get out of such a situation, you must break the cycle by changing the rule of one of the composite alarms in the cycle to remove a dependency that creates the cycle. The simplest change to make to break a cycle is to change the <code>AlarmRule</code> of one of the alarms to <code>False</code>. </p> <p>Additionally, the evaluation of composite alarms stops if CloudWatch detects a cycle in the evaluation path. </p> </note> <p>When this operation creates an alarm, the alarm state is immediately set to <code>INSUFFICIENT_DATA</code>. The alarm is then evaluated and its state is set appropriately. Any actions associated with the new state are then executed. For a composite alarm, this initial time after creation is the only time that the alarm can be in <code>INSUFFICIENT_DATA</code> state.</p> <p>When you update an existing alarm, its state is left unchanged, but the update completely overwrites the previous configuration of the alarm.</p>', 'PutDashboard' => '<p>Creates a dashboard if it does not already exist, or updates an existing dashboard. If you update a dashboard, the entire contents are replaced with what you specify here.</p> <p>All dashboards in your account are global, not region-specific.</p> <p>A simple way to create a dashboard using <code>PutDashboard</code> is to copy an existing dashboard. To copy an existing dashboard using the console, you can load the dashboard and then use the View/edit source command in the Actions menu to display the JSON block for that dashboard. Another way to copy a dashboard is to use <code>GetDashboard</code>, and then use the data returned within <code>DashboardBody</code> as the template for the new dashboard when you call <code>PutDashboard</code>.</p> <p>When you create a dashboard with <code>PutDashboard</code>, a good practice is to add a text widget at the top of the dashboard with a message that the dashboard was created by script and should not be changed in the console. This message could also point console users to the location of the <code>DashboardBody</code> script or the CloudFormation template used to create the dashboard.</p>', 'PutInsightRule' => '<p>Creates a Contributor Insights rule. Rules evaluate log events in a CloudWatch Logs log group, enabling you to find contributor data for the log events in that log group. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights.html">Using Contributor Insights to Analyze High-Cardinality Data</a>.</p> <p>If you create a rule, delete it, and then re-create it with the same name, historical data from the first time the rule was created might not be available.</p>', 'PutMetricAlarm' => '<p>Creates or updates an alarm and associates it with the specified metric, metric math expression, or anomaly detection model.</p> <p>Alarms based on anomaly detection models cannot have Auto Scaling actions.</p> <p>When this operation creates an alarm, the alarm state is immediately set to <code>INSUFFICIENT_DATA</code>. The alarm is then evaluated and its state is set appropriately. Any actions associated with the new state are then executed.</p> <p>When you update an existing alarm, its state is left unchanged, but the update completely overwrites the previous configuration of the alarm.</p> <p>If you are an IAM user, you must have Amazon EC2 permissions for some alarm operations:</p> <ul> <li> <p> <code>iam:CreateServiceLinkedRole</code> for all alarms with EC2 actions</p> </li> <li> <p> <code>ec2:DescribeInstanceStatus</code> and <code>ec2:DescribeInstances</code> for all alarms on EC2 instance status metrics</p> </li> <li> <p> <code>ec2:StopInstances</code> for alarms with stop actions</p> </li> <li> <p> <code>ec2:TerminateInstances</code> for alarms with terminate actions</p> </li> <li> <p>No specific permissions are needed for alarms with recover actions</p> </li> </ul> <p>If you have read/write permissions for Amazon CloudWatch but not for Amazon EC2, you can still create an alarm, but the stop or terminate actions are not performed. However, if you are later granted the required permissions, the alarm actions that you created earlier are performed.</p> <p>If you are using an IAM role (for example, an EC2 instance profile), you cannot stop or terminate the instance using alarm actions. However, you can still see the alarm state and perform any other actions such as Amazon SNS notifications or Auto Scaling policies.</p> <p>If you are using temporary security credentials granted using AWS STS, you cannot stop or terminate an EC2 instance using alarm actions.</p> <p>The first time you create an alarm in the AWS Management Console, the CLI, or by using the PutMetricAlarm API, CloudWatch creates the necessary service-linked role for you. The service-linked role is called <code>AWSServiceRoleForCloudWatchEvents</code>. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role">AWS service-linked role</a>.</p>', 'PutMetricData' => '<p>Publishes metric data points to Amazon CloudWatch. CloudWatch associates the data points with the specified metric. If the specified metric does not exist, CloudWatch creates the metric. When CloudWatch creates a metric, it can take up to fifteen minutes for the metric to appear in calls to <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html">ListMetrics</a>.</p> <p>You can publish either individual data points in the <code>Value</code> field, or arrays of values and the number of times each value occurred during the period by using the <code>Values</code> and <code>Counts</code> fields in the <code>MetricDatum</code> structure. Using the <code>Values</code> and <code>Counts</code> method enables you to publish up to 150 values per metric with one <code>PutMetricData</code> request, and supports retrieving percentile statistics on this data.</p> <p>Each <code>PutMetricData</code> request is limited to 40 KB in size for HTTP POST requests. You can send a payload compressed by gzip. Each request is also limited to no more than 20 different metrics.</p> <p>Although the <code>Value</code> parameter accepts numbers of type <code>Double</code>, CloudWatch rejects values that are either too small or too large. Values must be in the range of -2^360 to 2^360. In addition, special values (for example, NaN, +Infinity, -Infinity) are not supported.</p> <p>You can use up to 10 dimensions per metric to further clarify what data the metric collects. Each dimension consists of a Name and Value pair. For more information about specifying dimensions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html">Publishing Metrics</a> in the <i>Amazon CloudWatch User Guide</i>.</p> <p>Data points with time stamps from 24 hours ago or longer can take at least 48 hours to become available for <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricData.html">GetMetricData</a> or <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricStatistics.html">GetMetricStatistics</a> from the time they are submitted. Data points with time stamps between 3 and 24 hours ago can take as much as 2 hours to become available for for <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricData.html">GetMetricData</a> or <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricStatistics.html">GetMetricStatistics</a>.</p> <p>CloudWatch needs raw data points to calculate percentile statistics. If you publish data using a statistic set instead, you can only retrieve percentile statistics for this data if one of the following conditions is true:</p> <ul> <li> <p>The <code>SampleCount</code> value of the statistic set is 1 and <code>Min</code>, <code>Max</code>, and <code>Sum</code> are all equal.</p> </li> <li> <p>The <code>Min</code> and <code>Max</code> are equal, and <code>Sum</code> is equal to <code>Min</code> multiplied by <code>SampleCount</code>.</p> </li> </ul>', 'SetAlarmState' => '<p>Temporarily sets the state of an alarm for testing purposes. When the updated state differs from the previous value, the action configured for the appropriate state is invoked. For example, if your alarm is configured to send an Amazon SNS message when an alarm is triggered, temporarily changing the alarm state to <code>ALARM</code> sends an SNS message.</p> <p>Metric alarms returns to their actual state quickly, often within seconds. Because the metric alarm state change happens quickly, it is typically only visible in the alarm\'s <b>History</b> tab in the Amazon CloudWatch console or through <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeAlarmHistory.html">DescribeAlarmHistory</a>.</p> <p>If you use <code>SetAlarmState</code> on a composite alarm, the composite alarm is not guaranteed to return to its actual state. It returns to its actual state only once any of its children alarms change state. It is also reevaluated if you update its configuration.</p> <p>If an alarm triggers EC2 Auto Scaling policies or application Auto Scaling policies, you must include information in the <code>StateReasonData</code> parameter to enable the policy to take the correct action.</p>', 'TagResource' => '<p>Assigns one or more tags (key-value pairs) to the specified CloudWatch resource. Currently, the only CloudWatch resources that can be tagged are alarms and Contributor Insights rules.</p> <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p> <p>Tags don\'t have any semantic meaning to AWS and are interpreted strictly as strings of characters.</p> <p>You can use the <code>TagResource</code> action with an alarm that already has tags. If you specify a new tag key for the alarm, this tag is appended to the list of tags associated with the alarm. If you specify a tag key that is already associated with the alarm, the new tag value that you specify replaces the previous value for that tag.</p> <p>You can associate as many as 50 tags with a CloudWatch resource.</p>', 'UntagResource' => '<p>Removes one or more tags from the specified resource.</p>', ], 'shapes' => [ 'ActionPrefix' => [ 'base' => NULL, 'refs' => [ 'DescribeAlarmsInput$ActionPrefix' => '<p>Use this parameter to filter the results of the operation to only those alarms that use a certain alarm action. For example, you could specify the ARN of an SNS topic to find all alarms that send notifications to that topic.</p>', ], ], 'ActionsEnabled' => [ 'base' => NULL, 'refs' => [ 'CompositeAlarm$ActionsEnabled' => '<p>Indicates whether actions should be executed during any changes to the alarm state.</p>', 'MetricAlarm$ActionsEnabled' => '<p>Indicates whether actions should be executed during any changes to the alarm state.</p>', 'PutCompositeAlarmInput$ActionsEnabled' => '<p>Indicates whether actions should be executed during any changes to the alarm state of the composite alarm. The default is <code>TRUE</code>.</p>', 'PutMetricAlarmInput$ActionsEnabled' => '<p>Indicates whether actions should be executed during any changes to the alarm state. The default is <code>TRUE</code>.</p>', ], ], 'AlarmArn' => [ 'base' => NULL, 'refs' => [ 'CompositeAlarm$AlarmArn' => '<p>The Amazon Resource Name (ARN) of the alarm.</p>', 'MetricAlarm$AlarmArn' => '<p>The Amazon Resource Name (ARN) of the alarm.</p>', ], ], 'AlarmDescription' => [ 'base' => NULL, 'refs' => [ 'CompositeAlarm$AlarmDescription' => '<p>The description of the alarm.</p>', 'MetricAlarm$AlarmDescription' => '<p>The description of the alarm.</p>', 'PutCompositeAlarmInput$AlarmDescription' => '<p>The description for the composite alarm.</p>', 'PutMetricAlarmInput$AlarmDescription' => '<p>The description for the alarm.</p>', ], ], 'AlarmHistoryItem' => [ 'base' => '<p>Represents the history of a specific alarm.</p>', 'refs' => [ 'AlarmHistoryItems$member' => NULL, ], ], 'AlarmHistoryItems' => [ 'base' => NULL, 'refs' => [ 'DescribeAlarmHistoryOutput$AlarmHistoryItems' => '<p>The alarm histories, in JSON format.</p>', ], ], 'AlarmName' => [ 'base' => NULL, 'refs' => [ 'AlarmHistoryItem$AlarmName' => '<p>The descriptive name for the alarm.</p>', 'AlarmNames$member' => NULL, 'CompositeAlarm$AlarmName' => '<p>The name of the alarm.</p>', 'DescribeAlarmHistoryInput$AlarmName' => '<p>The name of the alarm.</p>', 'DescribeAlarmsInput$ChildrenOfAlarmName' => '<p>If you use this parameter and specify the name of a composite alarm, the operation returns information about the "children" alarms of the alarm you specify. These are the metric alarms and composite alarms referenced in the <code>AlarmRule</code> field of the composite alarm that you specify in <code>ChildrenOfAlarmName</code>. Information about the composite alarm that you name in <code>ChildrenOfAlarmName</code> is not returned.</p> <p>If you specify <code>ChildrenOfAlarmName</code>, you cannot specify any other parameters in the request except for <code>MaxRecords</code> and <code>NextToken</code>. If you do so, you receive a validation error.</p> <note> <p>Only the <code>Alarm Name</code>, <code>ARN</code>, <code>StateValue</code> (OK/ALARM/INSUFFICIENT_DATA), and <code>StateUpdatedTimestamp</code> information are returned by this operation when you use this parameter. To get complete information about these alarms, perform another <code>DescribeAlarms</code> operation and specify the parent alarm names in the <code>AlarmNames</code> parameter.</p> </note>', 'DescribeAlarmsInput$ParentsOfAlarmName' => '<p>If you use this parameter and specify the name of a metric or composite alarm, the operation returns information about the "parent" alarms of the alarm you specify. These are the composite alarms that have <code>AlarmRule</code> parameters that reference the alarm named in <code>ParentsOfAlarmName</code>. Information about the alarm that you specify in <code>ParentsOfAlarmName</code> is not returned.</p> <p>If you specify <code>ParentsOfAlarmName</code>, you cannot specify any other parameters in the request except for <code>MaxRecords</code> and <code>NextToken</code>. If you do so, you receive a validation error.</p> <note> <p>Only the Alarm Name and ARN are returned by this operation when you use this parameter. To get complete information about these alarms, perform another <code>DescribeAlarms</code> operation and specify the parent alarm names in the <code>AlarmNames</code> parameter.</p> </note>', 'MetricAlarm$AlarmName' => '<p>The name of the alarm.</p>', 'PutCompositeAlarmInput$AlarmName' => '<p>The name for the composite alarm. This name must be unique within the Region.</p>', 'PutMetricAlarmInput$AlarmName' => '<p>The name for the alarm. This name must be unique within the Region.</p>', 'SetAlarmStateInput$AlarmName' => '<p>The name of the alarm.</p>', ], ], 'AlarmNamePrefix' => [ 'base' => NULL, 'refs' => [ 'DescribeAlarmsInput$AlarmNamePrefix' => '<p>An alarm name prefix. If you specify this parameter, you receive information about all alarms that have names that start with this prefix.</p> <p>If this parameter is specified, you cannot specify <code>AlarmNames</code>.</p>', ], ], 'AlarmNames' => [ 'base' => NULL, 'refs' => [ 'DeleteAlarmsInput$AlarmNames' => '<p>The alarms to be deleted.</p>', 'DescribeAlarmsInput$AlarmNames' => '<p>The names of the alarms to retrieve information about.</p>', 'DisableAlarmActionsInput$AlarmNames' => '<p>The names of the alarms.</p>', 'EnableAlarmActionsInput$AlarmNames' => '<p>The names of the alarms.</p>', ], ], 'AlarmRule' => [ 'base' => NULL, 'refs' => [ 'CompositeAlarm$AlarmRule' => '<p>The rule that this alarm uses to evaluate its alarm state.</p>', 'PutCompositeAlarmInput$AlarmRule' => '<p>An expression that specifies which other alarms are to be evaluated to determine this composite alarm\'s state. For each alarm that you reference, you designate a function that specifies whether that alarm needs to be in ALARM state, OK state, or INSUFFICIENT_DATA state. You can use operators (AND, OR and NOT) to combine multiple functions in a single expression. You can use parenthesis to logically group the functions in your expression.</p> <p>You can use either alarm names or ARNs to reference the other alarms that are to be evaluated.</p> <p>Functions can include the following:</p> <ul> <li> <p> <code>ALARM("<i>alarm-name</i> or <i>alarm-ARN</i>")</code> is TRUE if the named alarm is in ALARM state.</p> </li> <li> <p> <code>OK("<i>alarm-name</i> or <i>alarm-ARN</i>")</code> is TRUE if the named alarm is in OK state.</p> </li> <li> <p> <code>INSUFFICIENT_DATA("<i>alarm-name</i> or <i>alarm-ARN</i>")</code> is TRUE if the named alarm is in INSUFFICIENT_DATA state.</p> </li> <li> <p> <code>TRUE</code> always evaluates to TRUE.</p> </li> <li> <p> <code>FALSE</code> always evaluates to FALSE.</p> </li> </ul> <p>TRUE and FALSE are useful for testing a complex <code>AlarmRule</code> structure, and for testing your alarm actions.</p> <p>Alarm names specified in <code>AlarmRule</code> can be surrounded with double-quotes ("), but do not have to be.</p> <p>The following are some examples of <code>AlarmRule</code>:</p> <ul> <li> <p> <code>ALARM(CPUUtilizationTooHigh) AND ALARM(DiskReadOpsTooHigh)</code> specifies that the composite alarm goes into ALARM state only if both CPUUtilizationTooHigh and DiskReadOpsTooHigh alarms are in ALARM state.</p> </li> <li> <p> <code>ALARM(CPUUtilizationTooHigh) AND NOT ALARM(DeploymentInProgress)</code> specifies that the alarm goes to ALARM state if CPUUtilizationTooHigh is in ALARM state and DeploymentInProgress is not in ALARM state. This example reduces alarm noise during a known deployment window.</p> </li> <li> <p> <code>(ALARM(CPUUtilizationTooHigh) OR ALARM(DiskReadOpsTooHigh)) AND OK(NetworkOutTooHigh)</code> goes into ALARM state if CPUUtilizationTooHigh OR DiskReadOpsTooHigh is in ALARM state, and if NetworkOutTooHigh is in OK state. This provides another example of using a composite alarm to prevent noise. This rule ensures that you are not notified with an alarm action on high CPU or disk usage if a known network problem is also occurring.</p> </li> </ul> <p>The <code>AlarmRule</code> can specify as many as 100 "children" alarms. The <code>AlarmRule</code> expression can have as many as 500 elements. Elements are child alarms, TRUE or FALSE statements, and parentheses.</p>', ], ], 'AlarmType' => [ 'base' => NULL, 'refs' => [ 'AlarmHistoryItem$AlarmType' => '<p>The type of alarm, either metric alarm or composite alarm.</p>', 'AlarmTypes$member' => NULL, ], ], 'AlarmTypes' => [ 'base' => NULL, 'refs' => [ 'DescribeAlarmHistoryInput$AlarmTypes' => '<p>Use this parameter to specify whether you want the operation to return metric alarms or composite alarms. If you omit this parameter, only metric alarms are returned.</p>', 'DescribeAlarmsInput$AlarmTypes' => '<p>Use this parameter to specify whether you want the operation to return metric alarms or composite alarms. If you omit this parameter, only metric alarms are returned.</p>', ], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceInput$ResourceARN' => '<p>The ARN of the CloudWatch resource that you want to view tags for.</p> <p>The ARN format of an alarm is <code>arn:aws:cloudwatch:<i>Region</i>:<i>account-id</i>:alarm:<i>alarm-name</i> </code> </p> <p>The ARN format of a Contributor Insights rule is <code>arn:aws:cloudwatch:<i>Region</i>:<i>account-id</i>:insight-rule:<i>insight-rule-name</i> </code> </p> <p>For more information about ARN format, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncloudwatch.html#amazoncloudwatch-resources-for-iam-policies"> Resource Types Defined by Amazon CloudWatch</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'TagResourceInput$ResourceARN' => '<p>The ARN of the CloudWatch resource that you\'re adding tags to.</p> <p>The ARN format of an alarm is <code>arn:aws:cloudwatch:<i>Region</i>:<i>account-id</i>:alarm:<i>alarm-name</i> </code> </p> <p>The ARN format of a Contributor Insights rule is <code>arn:aws:cloudwatch:<i>Region</i>:<i>account-id</i>:insight-rule:<i>insight-rule-name</i> </code> </p> <p>For more information about ARN format, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncloudwatch.html#amazoncloudwatch-resources-for-iam-policies"> Resource Types Defined by Amazon CloudWatch</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'UntagResourceInput$ResourceARN' => '<p>The ARN of the CloudWatch resource that you\'re removing tags from.</p> <p>The ARN format of an alarm is <code>arn:aws:cloudwatch:<i>Region</i>:<i>account-id</i>:alarm:<i>alarm-name</i> </code> </p> <p>The ARN format of a Contributor Insights rule is <code>arn:aws:cloudwatch:<i>Region</i>:<i>account-id</i>:insight-rule:<i>insight-rule-name</i> </code> </p> <p>For more information about ARN format, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncloudwatch.html#amazoncloudwatch-resources-for-iam-policies"> Resource Types Defined by Amazon CloudWatch</a> in the <i>Amazon Web Services General Reference</i>.</p>', ], ], 'AnomalyDetector' => [ 'base' => '<p>An anomaly detection model associated with a particular CloudWatch metric and statistic. You can use the model to display a band of expected normal values when the metric is graphed.</p>', 'refs' => [ 'AnomalyDetectors$member' => NULL, ], ], 'AnomalyDetectorConfiguration' => [ 'base' => '<p>The configuration specifies details about how the anomaly detection model is to be trained, including time ranges to exclude from use for training the model and the time zone to use for the metric.</p>', 'refs' => [ 'AnomalyDetector$Configuration' => '<p>The configuration specifies details about how the anomaly detection model is to be trained, including time ranges to exclude from use for training the model, and the time zone to use for the metric.</p>', 'PutAnomalyDetectorInput$Configuration' => '<p>The configuration specifies details about how the anomaly detection model is to be trained, including time ranges to exclude when training and updating the model. You can specify as many as 10 time ranges.</p> <p>The configuration can also include the time zone to use for the metric.</p> <p>You can in</p>', ], ], 'AnomalyDetectorExcludedTimeRanges' => [ 'base' => NULL, 'refs' => [ 'AnomalyDetectorConfiguration$ExcludedTimeRanges' => '<p>An array of time ranges to exclude from use when the anomaly detection model is trained. Use this to make sure that events that could cause unusual values for the metric, such as deployments, aren\'t used when CloudWatch creates the model.</p>', ], ], 'AnomalyDetectorMetricStat' => [ 'base' => NULL, 'refs' => [ 'AnomalyDetector$Stat' => '<p>The statistic associated with the anomaly detection model.</p>', 'DeleteAnomalyDetectorInput$Stat' => '<p>The statistic associated with the anomaly detection model to delete.</p>', 'PutAnomalyDetectorInput$Stat' => '<p>The statistic to use for the metric and the anomaly detection model.</p>', ], ], 'AnomalyDetectorMetricTimezone' => [ 'base' => NULL, 'refs' => [ 'AnomalyDetectorConfiguration$MetricTimezone' => '<p>The time zone to use for the metric. This is useful to enable the model to automatically account for daylight savings time changes if the metric is sensitive to such time changes.</p> <p>To specify a time zone, use the name of the time zone as specified in the standard tz database. For more information, see <a href="https://en.wikipedia.org/wiki/Tz_database">tz database</a>.</p>', ], ], 'AnomalyDetectorStateValue' => [ 'base' => NULL, 'refs' => [ 'AnomalyDetector$StateValue' => '<p>The current status of the anomaly detector\'s training. The possible values are <code>TRAINED | PENDING_TRAINING | TRAINED_INSUFFICIENT_DATA</code> </p>', ], ], 'AnomalyDetectors' => [ 'base' => NULL, 'refs' => [ 'DescribeAnomalyDetectorsOutput$AnomalyDetectors' => '<p>The list of anomaly detection models returned by the operation.</p>', ], ], 'AwsQueryErrorMessage' => [ 'base' => NULL, 'refs' => [ 'InvalidParameterCombinationException$message' => '<p/>', 'InvalidParameterValueException$message' => '<p/>', 'MissingRequiredParameterException$message' => '<p/>', ], ], 'BatchFailures' => [ 'base' => NULL, 'refs' => [ 'DeleteInsightRulesOutput$Failures' => '<p>An array listing the rules that could not be deleted. You cannot delete built-in rules.</p>', 'DisableInsightRulesOutput$Failures' => '<p>An array listing the rules that could not be disabled. You cannot disable built-in rules.</p>', 'EnableInsightRulesOutput$Failures' => '<p>An array listing the rules that could not be enabled. You cannot disable or enable built-in rules.</p>', ], ], 'ComparisonOperator' => [ 'base' => NULL, 'refs' => [ 'MetricAlarm$ComparisonOperator' => '<p>The arithmetic operation to use when comparing the specified statistic and threshold. The specified statistic value is used as the first operand.</p>', 'PutMetricAlarmInput$ComparisonOperator' => '<p> The arithmetic operation to use when comparing the specified statistic and threshold. The specified statistic value is used as the first operand.</p> <p>The values <code>LessThanLowerOrGreaterThanUpperThreshold</code>, <code>LessThanLowerThreshold</code>, and <code>GreaterThanUpperThreshold</code> are used only for alarms based on anomaly detection models.</p>', ], ], 'CompositeAlarm' => [ 'base' => '<p>The details about a composite alarm.</p>', 'refs' => [ 'CompositeAlarms$member' => NULL, ], ], 'CompositeAlarms' => [ 'base' => NULL, 'refs' => [ 'DescribeAlarmsOutput$CompositeAlarms' => '<p>The information about any composite alarms returned by the operation.</p>', ], ], 'ConcurrentModificationException' => [ 'base' => '<p>More than one process tried to modify a resource at the same time.</p>', 'refs' => [], ], 'Counts' => [ 'base' => NULL, 'refs' => [ 'MetricDatum$Counts' => '<p>Array of numbers that is used along with the <code>Values</code> array. Each number in the <code>Count</code> array is the number of times the corresponding value in the <code>Values</code> array occurred during the period. </p> <p>If you omit the <code>Counts</code> array, the default of 1 is used as the value for each count. If you include a <code>Counts</code> array, it must include the same amount of values as the <code>Values</code> array.</p>', ], ], 'DashboardArn' => [ 'base' => NULL, 'refs' => [ 'DashboardEntry$DashboardArn' => '<p>The Amazon Resource Name (ARN) of the dashboard.</p>', 'GetDashboardOutput$DashboardArn' => '<p>The Amazon Resource Name (ARN) of the dashboard.</p>', ], ], 'DashboardBody' => [ 'base' => NULL, 'refs' => [ 'GetDashboardOutput$DashboardBody' => '<p>The detailed information about the dashboard, including what widgets are included and their location on the dashboard. For more information about the <code>DashboardBody</code> syntax, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/CloudWatch-Dashboard-Body-Structure.html">Dashboard Body Structure and Syntax</a>. </p>', 'PutDashboardInput$DashboardBody' => '<p>The detailed information about the dashboard in JSON format, including the widgets to include and their location on the dashboard. This parameter is required.</p> <p>For more information about the syntax, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/CloudWatch-Dashboard-Body-Structure.html">Dashboard Body Structure and Syntax</a>.</p>', ], ], 'DashboardEntries' => [ 'base' => NULL, 'refs' => [ 'ListDashboardsOutput$DashboardEntries' => '<p>The list of matching dashboards.</p>', ], ], 'DashboardEntry' => [ 'base' => '<p>Represents a specific dashboard.</p>', 'refs' => [ 'DashboardEntries$member' => NULL, ], ], 'DashboardErrorMessage' => [ 'base' => NULL, 'refs' => [ 'DashboardInvalidInputError$message' => NULL, 'DashboardNotFoundError$message' => NULL, ], ], 'DashboardInvalidInputError' => [ 'base' => '<p>Some part of the dashboard data is invalid.</p>', 'refs' => [], ], 'DashboardName' => [ 'base' => NULL, 'refs' => [ 'DashboardEntry$DashboardName' => '<p>The name of the dashboard.</p>', 'DashboardNames$member' => NULL, 'GetDashboardInput$DashboardName' => '<p>The name of the dashboard to be described.</p>', 'GetDashboardOutput$DashboardName' => '<p>The name of the dashboard.</p>', 'PutDashboardInput$DashboardName' => '<p>The name of the dashboard. If a dashboard with this name already exists, this call modifies that dashboard, replacing its current contents. Otherwise, a new dashboard is created. The maximum length is 255, and valid characters are A-Z, a-z, 0-9, "-", and "_". This parameter is required.</p>', ], ], 'DashboardNamePrefix' => [ 'base' => NULL, 'refs' => [ 'ListDashboardsInput$DashboardNamePrefix' => '<p>If you specify this parameter, only the dashboards with names starting with the specified string are listed. The maximum length is 255, and valid characters are A-Z, a-z, 0-9, ".", "-", and "_". </p>', ], ], 'DashboardNames' => [ 'base' => NULL, 'refs' => [ 'DeleteDashboardsInput$DashboardNames' => '<p>The dashboards to be deleted. This parameter is required.</p>', ], ], 'DashboardNotFoundError' => [ 'base' => '<p>The specified dashboard does not exist.</p>', 'refs' => [], ], 'DashboardValidationMessage' => [ 'base' => '<p>An error or warning for the operation.</p>', 'refs' => [ 'DashboardValidationMessages$member' => NULL, ], ], 'DashboardValidationMessages' => [ 'base' => NULL, 'refs' => [ 'DashboardInvalidInputError$dashboardValidationMessages' => NULL, 'PutDashboardOutput$DashboardValidationMessages' => '<p>If the input for <code>PutDashboard</code> was correct and the dashboard was successfully created or modified, this result is empty.</p> <p>If this result includes only warning messages, then the input was valid enough for the dashboard to be created or modified, but some elements of the dashboard might not render.</p> <p>If this result includes error messages, the input was not valid and the operation failed.</p>', ], ], 'DataPath' => [ 'base' => NULL, 'refs' => [ 'DashboardValidationMessage$DataPath' => '<p>The data path related to the message.</p>', ], ], 'Datapoint' => [ 'base' => '<p>Encapsulates the statistical data that CloudWatch computes from metric data.</p>', 'refs' => [ 'Datapoints$member' => NULL, ], ], 'DatapointValue' => [ 'base' => NULL, 'refs' => [ 'Counts$member' => NULL, 'Datapoint$SampleCount' => '<p>The number of metric values that contributed to the aggregate value of this data point.</p>', 'Datapoint$Average' => '<p>The average of the metric values that correspond to the data point.</p>', 'Datapoint$Sum' => '<p>The sum of the metric values for the data point.</p>', 'Datapoint$Minimum' => '<p>The minimum metric value for the data point.</p>', 'Datapoint$Maximum' => '<p>The maximum metric value for the data point.</p>', 'DatapointValueMap$value' => NULL, 'DatapointValues$member' => NULL, 'MetricDatum$Value' => '<p>The value for the metric.</p> <p>Although the parameter accepts numbers of type Double, CloudWatch rejects values that are either too small or too large. Values must be in the range of -2^360 to 2^360. In addition, special values (for example, NaN, +Infinity, -Infinity) are not supported.</p>', 'StatisticSet$SampleCount' => '<p>The number of samples used for the statistic set.</p>', 'StatisticSet$Sum' => '<p>The sum of values for the sample set.</p>', 'StatisticSet$Minimum' => '<p>The minimum value of the sample set.</p>', 'StatisticSet$Maximum' => '<p>The maximum value of the sample set.</p>', 'Values$member' => NULL, ], ], 'DatapointValueMap' => [ 'base' => NULL, 'refs' => [ 'Datapoint$ExtendedStatistics' => '<p>The percentile statistic for the data point.</p>', ], ], 'DatapointValues' => [ 'base' => NULL, 'refs' => [ 'MetricDataResult$Values' => '<p>The data points for the metric corresponding to <code>Timestamps</code>. The number of values always matches the number of timestamps and the timestamp for Values[x] is Timestamps[x].</p>', ], ], 'Datapoints' => [ 'base' => NULL, 'refs' => [ 'GetMetricStatisticsOutput$Datapoints' => '<p>The data points for the specified metric.</p>', ], ], 'DatapointsToAlarm' => [ 'base' => NULL, 'refs' => [ 'MetricAlarm$DatapointsToAlarm' => '<p>The number of data points that must be breaching to trigger the alarm.</p>', 'PutMetricAlarmInput$DatapointsToAlarm' => '<p>The number of data points that must be breaching to trigger the alarm. This is used only if you are setting an "M out of N" alarm. In that case, this value is the M. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarm-evaluation">Evaluating an Alarm</a> in the <i>Amazon CloudWatch User Guide</i>.</p>', ], ], 'DeleteAlarmsInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAnomalyDetectorInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAnomalyDetectorOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDashboardsInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDashboardsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInsightRulesInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInsightRulesOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAlarmHistoryInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAlarmHistoryOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAlarmsForMetricInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAlarmsForMetricOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAlarmsInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAlarmsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAnomalyDetectorsInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAnomalyDetectorsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInsightRulesInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInsightRulesOutput' => [ 'base' => NULL, 'refs' => [], ], 'Dimension' => [ 'base' => '<p>A dimension is a name/value pair that is part of the identity of a metric. You can assign up to 10 dimensions to a metric. Because dimensions are part of the unique identifier for a metric, whenever you add a unique name/value pair to one of your metrics, you are creating a new variation of that metric. </p>', 'refs' => [ 'Dimensions$member' => NULL, ], ], 'DimensionFilter' => [ 'base' => '<p>Represents filters for a dimension.</p>', 'refs' => [ 'DimensionFilters$member' => NULL, ], ], 'DimensionFilters' => [ 'base' => NULL, 'refs' => [ 'ListMetricsInput$Dimensions' => '<p>The dimensions to filter against.</p>', ], ], 'DimensionName' => [ 'base' => NULL, 'refs' => [ 'Dimension$Name' => '<p>The name of the dimension. Dimension names cannot contain blank spaces or non-ASCII characters.</p>', 'DimensionFilter$Name' => '<p>The dimension name to be matched.</p>', ], ], 'DimensionValue' => [ 'base' => NULL, 'refs' => [ 'Dimension$Value' => '<p>The value of the dimension.</p>', 'DimensionFilter$Value' => '<p>The value of the dimension to be matched.</p>', ], ], 'Dimensions' => [ 'base' => NULL, 'refs' => [ 'AnomalyDetector$Dimensions' => '<p>The metric dimensions associated with the anomaly detection model.</p>', 'DeleteAnomalyDetectorInput$Dimensions' => '<p>The metric dimensions associated with the anomaly detection model to delete.</p>', 'DescribeAlarmsForMetricInput$Dimensions' => '<p>The dimensions associated with the metric. If the metric has any associated dimensions, you must specify them in order for the call to succeed.</p>', 'DescribeAnomalyDetectorsInput$Dimensions' => '<p>Limits the results to only the anomaly detection models that are associated with the specified metric dimensions. If there are multiple metrics that have these dimensions and have anomaly detection models associated, they\'re all returned.</p>', 'GetMetricStatisticsInput$Dimensions' => '<p>The dimensions. If the metric contains multiple dimensions, you must include a value for each dimension. CloudWatch treats each unique combination of dimensions as a separate metric. If a specific combination of dimensions was not published, you can\'t retrieve statistics for it. You must specify the same dimensions that were used when the metrics were created. For an example, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#dimension-combinations">Dimension Combinations</a> in the <i>Amazon CloudWatch User Guide</i>. For more information about specifying dimensions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html">Publishing Metrics</a> in the <i>Amazon CloudWatch User Guide</i>.</p>', 'Metric$Dimensions' => '<p>The dimensions for the metric.</p>', 'MetricAlarm$Dimensions' => '<p>The dimensions for the metric associated with the alarm.</p>', 'MetricDatum$Dimensions' => '<p>The dimensions associated with the metric.</p>', 'PutAnomalyDetectorInput$Dimensions' => '<p>The metric dimensions to create the anomaly detection model for.</p>', 'PutMetricAlarmInput$Dimensions' => '<p>The dimensions for the metric specified in <code>MetricName</code>.</p>', ], ], 'DisableAlarmActionsInput' => [ 'base' => NULL, 'refs' => [], ], 'DisableInsightRulesInput' => [ 'base' => NULL, 'refs' => [], ], 'DisableInsightRulesOutput' => [ 'base' => NULL, 'refs' => [], ], 'EnableAlarmActionsInput' => [ 'base' => NULL, 'refs' => [], ], 'EnableInsightRulesInput' => [ 'base' => NULL, 'refs' => [], ], 'EnableInsightRulesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'InvalidFormatFault$message' => '<p/>', 'InvalidNextToken$message' => '<p/>', 'LimitExceededFault$message' => '<p/>', 'ResourceNotFound$message' => '<p/>', ], ], 'EvaluateLowSampleCountPercentile' => [ 'base' => NULL, 'refs' => [ 'MetricAlarm$EvaluateLowSampleCountPercentile' => '<p>Used only for alarms based on percentiles. If <code>ignore</code>, the alarm state does not change during periods with too few data points to be statistically significant. If <code>evaluate</code> or this parameter is not used, the alarm is always evaluated and possibly changes state no matter how many data points are available.</p>', 'PutMetricAlarmInput$EvaluateLowSampleCountPercentile' => '<p> Used only for alarms based on percentiles. If you specify <code>ignore</code>, the alarm state does not change during periods with too few data points to be statistically significant. If you specify <code>evaluate</code> or omit this parameter, the alarm is always evaluated and possibly changes state no matter how many data points are available. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#percentiles-with-low-samples">Percentile-Based CloudWatch Alarms and Low Data Samples</a>.</p> <p>Valid Values: <code>evaluate | ignore</code> </p>', ], ], 'EvaluationPeriods' => [ 'base' => NULL, 'refs' => [ 'MetricAlarm$EvaluationPeriods' => '<p>The number of periods over which data is compared to the specified threshold.</p>', 'PutMetricAlarmInput$EvaluationPeriods' => '<p>The number of periods over which data is compared to the specified threshold. If you are setting an alarm that requires that a number of consecutive data points be breaching to trigger the alarm, this value specifies that number. If you are setting an "M out of N" alarm, this value is the N.</p> <p>An alarm\'s total current evaluation period can be no longer than one day, so this number multiplied by <code>Period</code> cannot be more than 86,400 seconds.</p>', ], ], 'ExceptionType' => [ 'base' => NULL, 'refs' => [ 'PartialFailure$ExceptionType' => '<p>The type of error.</p>', ], ], 'ExtendedStatistic' => [ 'base' => NULL, 'refs' => [ 'DatapointValueMap$key' => NULL, 'DescribeAlarmsForMetricInput$ExtendedStatistic' => '<p>The percentile statistic for the metric. Specify a value between p0.0 and p100.</p>', 'ExtendedStatistics$member' => NULL, 'MetricAlarm$ExtendedStatistic' => '<p>The percentile statistic for the metric associated with the alarm. Specify a value between p0.0 and p100.</p>', 'PutMetricAlarmInput$ExtendedStatistic' => '<p>The percentile statistic for the metric specified in <code>MetricName</code>. Specify a value between p0.0 and p100. When you call <code>PutMetricAlarm</code> and specify a <code>MetricName</code>, you must specify either <code>Statistic</code> or <code>ExtendedStatistic,</code> but not both.</p>', ], ], 'ExtendedStatistics' => [ 'base' => NULL, 'refs' => [ 'GetMetricStatisticsInput$ExtendedStatistics' => '<p>The percentile statistics. Specify values between p0.0 and p100. When calling <code>GetMetricStatistics</code>, you must specify either <code>Statistics</code> or <code>ExtendedStatistics</code>, but not both. Percentile statistics are not available for metrics when any of the metric values are negative numbers.</p>', ], ], 'FailureCode' => [ 'base' => NULL, 'refs' => [ 'PartialFailure$FailureCode' => '<p>The code of the error.</p>', ], ], 'FailureDescription' => [ 'base' => NULL, 'refs' => [ 'PartialFailure$FailureDescription' => '<p>A description of the error.</p>', ], ], 'FailureResource' => [ 'base' => NULL, 'refs' => [ 'PartialFailure$FailureResource' => '<p>The specified rule that could not be deleted.</p>', ], ], 'FaultDescription' => [ 'base' => NULL, 'refs' => [ 'InternalServiceFault$Message' => '<p/>', ], ], 'GetDashboardInput' => [ 'base' => NULL, 'refs' => [], ], 'GetDashboardOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetInsightRuleReportInput' => [ 'base' => NULL, 'refs' => [], ], 'GetInsightRuleReportOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetMetricDataInput' => [ 'base' => NULL, 'refs' => [], ], 'GetMetricDataMaxDatapoints' => [ 'base' => NULL, 'refs' => [ 'GetMetricDataInput$MaxDatapoints' => '<p>The maximum number of data points the request should return before paginating. If you omit this, the default of 100,800 is used.</p>', ], ], 'GetMetricDataOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetMetricStatisticsInput' => [ 'base' => NULL, 'refs' => [], ], 'GetMetricStatisticsOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetMetricWidgetImageInput' => [ 'base' => NULL, 'refs' => [], ], 'GetMetricWidgetImageOutput' => [ 'base' => NULL, 'refs' => [], ], 'HistoryData' => [ 'base' => NULL, 'refs' => [ 'AlarmHistoryItem$HistoryData' => '<p>Data about the alarm, in JSON format.</p>', ], ], 'HistoryItemType' => [ 'base' => NULL, 'refs' => [ 'AlarmHistoryItem$HistoryItemType' => '<p>The type of alarm history item.</p>', 'DescribeAlarmHistoryInput$HistoryItemType' => '<p>The type of alarm histories to retrieve.</p>', ], ], 'HistorySummary' => [ 'base' => NULL, 'refs' => [ 'AlarmHistoryItem$HistorySummary' => '<p>A summary of the alarm history, in text format.</p>', ], ], 'InsightRule' => [ 'base' => '<p>This structure contains the definition for a Contributor Insights rule.</p>', 'refs' => [ 'InsightRules$member' => NULL, ], ], 'InsightRuleAggregationStatistic' => [ 'base' => NULL, 'refs' => [ 'GetInsightRuleReportOutput$AggregationStatistic' => '<p>Specifies whether this rule aggregates contributor data by COUNT or SUM.</p>', ], ], 'InsightRuleContributor' => [ 'base' => '<p>One of the unique contributors found by a Contributor Insights rule. If the rule contains multiple keys, then a unique contributor is a unique combination of values from all the keys in the rule.</p> <p>If the rule contains a single key, then each unique contributor is each unique value for this key.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetInsightRuleReport.html">GetInsightRuleReport</a>.</p>', 'refs' => [ 'InsightRuleContributors$member' => NULL, ], ], 'InsightRuleContributorDatapoint' => [ 'base' => '<p>One data point related to one contributor.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetInsightRuleReport.html">GetInsightRuleReport</a> and <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_InsightRuleContributor.html">InsightRuleContributor</a>.</p>', 'refs' => [ 'InsightRuleContributorDatapoints$member' => NULL, ], ], 'InsightRuleContributorDatapoints' => [ 'base' => NULL, 'refs' => [ 'InsightRuleContributor$Datapoints' => '<p>An array of the data points where this contributor is present. Only the data points when this contributor appeared are included in the array.</p>', ], ], 'InsightRuleContributorKey' => [ 'base' => NULL, 'refs' => [ 'InsightRuleContributorKeys$member' => NULL, ], ], 'InsightRuleContributorKeyLabel' => [ 'base' => NULL, 'refs' => [ 'InsightRuleContributorKeyLabels$member' => NULL, ], ], 'InsightRuleContributorKeyLabels' => [ 'base' => NULL, 'refs' => [ 'GetInsightRuleReportOutput$KeyLabels' => '<p>An array of the strings used as the keys for this rule. The keys are the dimensions used to classify contributors. If the rule contains more than one key, then each unique combination of values for the keys is counted as a unique contributor.</p>', ], ], 'InsightRuleContributorKeys' => [ 'base' => NULL, 'refs' => [ 'InsightRuleContributor$Keys' => '<p>One of the log entry field keywords that is used to define contributors for this rule.</p>', ], ], 'InsightRuleContributors' => [ 'base' => NULL, 'refs' => [ 'GetInsightRuleReportOutput$Contributors' => '<p>An array of the unique contributors found by this rule in this time period. If the rule contains multiple keys, each combination of values for the keys counts as a unique contributor.</p>', ], ], 'InsightRuleDefinition' => [ 'base' => NULL, 'refs' => [ 'InsightRule$Definition' => '<p>The definition of the rule, as a JSON object. The definition contains the keywords used to define contributors, the value to aggregate on if this rule returns a sum instead of a count, and the filters. For details on the valid syntax, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html">Contributor Insights Rule Syntax</a>.</p>', 'PutInsightRuleInput$RuleDefinition' => '<p>The definition of the rule, as a JSON object. For details on the valid syntax, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html">Contributor Insights Rule Syntax</a>.</p>', ], ], 'InsightRuleMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeInsightRulesInput$MaxResults' => '<p>This parameter is not currently used. Reserved for future use. If it is used in the future, the maximum value might be different.</p>', ], ], 'InsightRuleMetricDatapoint' => [ 'base' => '<p>One data point from the metric time series returned in a Contributor Insights rule report.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetInsightRuleReport.html">GetInsightRuleReport</a>.</p>', 'refs' => [ 'InsightRuleMetricDatapoints$member' => NULL, ], ], 'InsightRuleMetricDatapoints' => [ 'base' => NULL, 'refs' => [ 'GetInsightRuleReportOutput$MetricDatapoints' => '<p>A time series of metric data points that matches the time period in the rule request.</p>', ], ], 'InsightRuleMetricList' => [ 'base' => NULL, 'refs' => [ 'GetInsightRuleReportInput$Metrics' => '<p>Specifies which metrics to use for aggregation of contributor values for the report. You can specify one or more of the following metrics:</p> <ul> <li> <p> <code>UniqueContributors</code> -- the number of unique contributors for each data point.</p> </li> <li> <p> <code>MaxContributorValue</code> -- the value of the top contributor for each data point. The identity of the contributor might change for each data point in the graph.</p> <p>If this rule aggregates by COUNT, the top contributor for each data point is the contributor with the most occurrences in that period. If the rule aggregates by SUM, the top contributor is the contributor with the highest sum in the log field specified by the rule\'s <code>Value</code>, during that period.</p> </li> <li> <p> <code>SampleCount</code> -- the number of data points matched by the rule.</p> </li> <li> <p> <code>Sum</code> -- the sum of the values from all contributors during the time period represented by that data point.</p> </li> <li> <p> <code>Minimum</code> -- the minimum value from a single observation during the time period represented by that data point.</p> </li> <li> <p> <code>Maximum</code> -- the maximum value from a single observation during the time period represented by that data point.</p> </li> <li> <p> <code>Average</code> -- the average value from all contributors during the time period represented by that data point.</p> </li> </ul>', ], ], 'InsightRuleMetricName' => [ 'base' => NULL, 'refs' => [ 'InsightRuleMetricList$member' => NULL, ], ], 'InsightRuleName' => [ 'base' => NULL, 'refs' => [ 'GetInsightRuleReportInput$RuleName' => '<p>The name of the rule that you want to see data from.</p>', 'InsightRule$Name' => '<p>The name of the rule.</p>', 'InsightRuleNames$member' => NULL, 'PutInsightRuleInput$RuleName' => '<p>A unique name for the rule.</p>', ], ], 'InsightRuleNames' => [ 'base' => NULL, 'refs' => [ 'DeleteInsightRulesInput$RuleNames' => '<p>An array of the rule names to delete. If you need to find out the names of your rules, use <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeInsightRules.html">DescribeInsightRules</a>.</p>', 'DisableInsightRulesInput$RuleNames' => '<p>An array of the rule names to disable. If you need to find out the names of your rules, use <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeInsightRules.html">DescribeInsightRules</a>.</p>', 'EnableInsightRulesInput$RuleNames' => '<p>An array of the rule names to enable. If you need to find out the names of your rules, use <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_DescribeInsightRules.html">DescribeInsightRules</a>.</p>', ], ], 'InsightRuleOrderBy' => [ 'base' => NULL, 'refs' => [ 'GetInsightRuleReportInput$OrderBy' => '<p>Determines what statistic to use to rank the contributors. Valid values are SUM and MAXIMUM.</p>', ], ], 'InsightRuleSchema' => [ 'base' => NULL, 'refs' => [ 'InsightRule$Schema' => '<p>For rules that you create, this is always <code>{"Name": "CloudWatchLogRule", "Version": 1}</code>. For built-in rules, this is <code>{"Name": "ServiceLogRule", "Version": 1}</code> </p>', ], ], 'InsightRuleState' => [ 'base' => NULL, 'refs' => [ 'InsightRule$State' => '<p>Indicates whether the rule is enabled or disabled.</p>', 'PutInsightRuleInput$RuleState' => '<p>The state of the rule. Valid values are ENABLED and DISABLED.</p>', ], ], 'InsightRuleUnboundDouble' => [ 'base' => NULL, 'refs' => [ 'GetInsightRuleReportOutput$AggregateValue' => '<p>The sum of the values from all individual contributors that match the rule.</p>', 'InsightRuleContributor$ApproximateAggregateValue' => '<p>An approximation of the aggregate value that comes from this contributor.</p>', 'InsightRuleContributorDatapoint$ApproximateValue' => '<p>The approximate value that this contributor added during this timestamp.</p>', 'InsightRuleMetricDatapoint$UniqueContributors' => '<p>The number of unique contributors who published data during this timestamp.</p> <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>', 'InsightRuleMetricDatapoint$MaxContributorValue' => '<p>The maximum value provided by one contributor during this timestamp. Each timestamp is evaluated separately, so the identity of the max contributor could be different for each timestamp.</p> <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>', 'InsightRuleMetricDatapoint$SampleCount' => '<p>The number of occurrences that matched the rule during this data point.</p> <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>', 'InsightRuleMetricDatapoint$Average' => '<p>The average value from all contributors during the time period represented by that data point.</p> <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>', 'InsightRuleMetricDatapoint$Sum' => '<p>The sum of the values from all contributors during the time period represented by that data point.</p> <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>', 'InsightRuleMetricDatapoint$Minimum' => '<p>The minimum value from a single contributor during the time period represented by that data point.</p> <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>', 'InsightRuleMetricDatapoint$Maximum' => '<p>The maximum value from a single occurence from a single contributor during the time period represented by that data point.</p> <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>', ], ], 'InsightRuleUnboundInteger' => [ 'base' => NULL, 'refs' => [ 'GetInsightRuleReportInput$MaxContributorCount' => '<p>The maximum number of contributors to include in the report. The range is 1 to 100. If you omit this, the default of 10 is used.</p>', ], ], 'InsightRuleUnboundLong' => [ 'base' => NULL, 'refs' => [ 'GetInsightRuleReportOutput$ApproximateUniqueCount' => '<p>An approximate count of the unique contributors found by this rule in this time period.</p>', ], ], 'InsightRules' => [ 'base' => NULL, 'refs' => [ 'DescribeInsightRulesOutput$InsightRules' => '<p>The rules returned by the operation.</p>', ], ], 'InternalServiceFault' => [ 'base' => '<p>Request processing has failed due to some unknown error, exception, or failure.</p>', 'refs' => [], ], 'InvalidFormatFault' => [ 'base' => '<p>Data was not syntactically valid JSON.</p>', 'refs' => [], ], 'InvalidNextToken' => [ 'base' => '<p>The next token specified is invalid.</p>', 'refs' => [], ], 'InvalidParameterCombinationException' => [ 'base' => '<p>Parameters were used together that cannot be used together.</p>', 'refs' => [], ], 'InvalidParameterValueException' => [ 'base' => '<p>The value of an input parameter is bad or out-of-range.</p>', 'refs' => [], ], 'LastModified' => [ 'base' => NULL, 'refs' => [ 'DashboardEntry$LastModified' => '<p>The time stamp of when the dashboard was last modified, either by an API call or through the console. This number is expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The operation exceeded one or more limits.</p>', 'refs' => [], ], 'LimitExceededFault' => [ 'base' => '<p>The quota for alarms for this customer has already been reached.</p>', 'refs' => [], ], 'ListDashboardsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListDashboardsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListMetricsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListMetricsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'MaxRecords' => [ 'base' => NULL, 'refs' => [ 'DescribeAlarmHistoryInput$MaxRecords' => '<p>The maximum number of alarm history records to retrieve.</p>', 'DescribeAlarmsInput$MaxRecords' => '<p>The maximum number of alarm descriptions to retrieve.</p>', ], ], 'MaxReturnedResultsCount' => [ 'base' => NULL, 'refs' => [ 'DescribeAnomalyDetectorsInput$MaxResults' => '<p>The maximum number of results to return in one operation. The maximum value that you can specify is 100.</p> <p>To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. </p>', ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'DashboardValidationMessage$Message' => '<p>A message describing the error or warning.</p>', ], ], 'MessageData' => [ 'base' => '<p>A message returned by the <code>GetMetricData</code>API, including a code and a description.</p>', 'refs' => [ 'MetricDataResultMessages$member' => NULL, ], ], 'MessageDataCode' => [ 'base' => NULL, 'refs' => [ 'MessageData$Code' => '<p>The error code or status code associated with the message.</p>', ], ], 'MessageDataValue' => [ 'base' => NULL, 'refs' => [ 'MessageData$Value' => '<p>The message text.</p>', ], ], 'Metric' => [ 'base' => '<p>Represents a specific metric.</p>', 'refs' => [ 'MetricStat$Metric' => '<p>The metric to return, including the metric name, namespace, and dimensions.</p>', 'Metrics$member' => NULL, ], ], 'MetricAlarm' => [ 'base' => '<p>The details about a metric alarm.</p>', 'refs' => [ 'MetricAlarms$member' => NULL, ], ], 'MetricAlarms' => [ 'base' => NULL, 'refs' => [ 'DescribeAlarmsForMetricOutput$MetricAlarms' => '<p>The information for each alarm with the specified metric.</p>', 'DescribeAlarmsOutput$MetricAlarms' => '<p>The information about any metric alarms returned by the operation.</p>', ], ], 'MetricData' => [ 'base' => NULL, 'refs' => [ 'PutMetricDataInput$MetricData' => '<p>The data for the metric. The array can include no more than 20 metrics per call.</p>', ], ], 'MetricDataQueries' => [ 'base' => NULL, 'refs' => [ 'GetMetricDataInput$MetricDataQueries' => '<p>The metric queries to be returned. A single <code>GetMetricData</code> call can include as many as 500 <code>MetricDataQuery</code> structures. Each of these structures can specify either a metric to retrieve, or a math expression to perform on retrieved data. </p>', 'MetricAlarm$Metrics' => '<p>An array of MetricDataQuery structures, used in an alarm based on a metric math expression. Each structure either retrieves a metric or performs a math expression. One item in the Metrics array is the math expression that the alarm watches. This expression by designated by having <code>ReturnValue</code> set to true.</p>', 'PutMetricAlarmInput$Metrics' => '<p>An array of <code>MetricDataQuery</code> structures that enable you to create an alarm based on the result of a metric math expression. For each <code>PutMetricAlarm</code> operation, you must specify either <code>MetricName</code> or a <code>Metrics</code> array.</p> <p>Each item in the <code>Metrics</code> array either retrieves a metric or performs a math expression.</p> <p>One item in the <code>Metrics</code> array is the expression that the alarm watches. You designate this expression by setting <code>ReturnValue</code> to true for this object in the array. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDataQuery.html">MetricDataQuery</a>.</p> <p>If you use the <code>Metrics</code> parameter, you cannot include the <code>MetricName</code>, <code>Dimensions</code>, <code>Period</code>, <code>Namespace</code>, <code>Statistic</code>, or <code>ExtendedStatistic</code> parameters of <code>PutMetricAlarm</code> in the same operation. Instead, you retrieve the metrics you are using in your math expression as part of the <code>Metrics</code> array.</p>', ], ], 'MetricDataQuery' => [ 'base' => '<p>This structure is used in both <code>GetMetricData</code> and <code>PutMetricAlarm</code>. The supported use of this structure is different for those two operations.</p> <p>When used in <code>GetMetricData</code>, it indicates the metric data to return, and whether this call is just retrieving a batch set of data for one metric, or is performing a math expression on metric data. A single <code>GetMetricData</code> call can include up to 500 <code>MetricDataQuery</code> structures.</p> <p>When used in <code>PutMetricAlarm</code>, it enables you to create an alarm based on a metric math expression. Each <code>MetricDataQuery</code> in the array specifies either a metric to retrieve, or a math expression to be performed on retrieved metrics. A single <code>PutMetricAlarm</code> call can include up to 20 <code>MetricDataQuery</code> structures in the array. The 20 structures can include as many as 10 structures that contain a <code>MetricStat</code> parameter to retrieve a metric, and as many as 10 structures that contain the <code>Expression</code> parameter to perform a math expression. Of those <code>Expression</code> structures, one must have <code>True</code> as the value for <code>ReturnData</code>. The result of this expression is the value the alarm watches.</p> <p>Any expression used in a <code>PutMetricAlarm</code> operation must return a single time series. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax">Metric Math Syntax and Functions</a> in the <i>Amazon CloudWatch User Guide</i>.</p> <p>Some of the parameters of this structure also have different uses whether you are using this structure in a <code>GetMetricData</code> operation or a <code>PutMetricAlarm</code> operation. These differences are explained in the following parameter list.</p>', 'refs' => [ 'MetricDataQueries$member' => NULL, ], ], 'MetricDataResult' => [ 'base' => '<p>A <code>GetMetricData</code> call returns an array of <code>MetricDataResult</code> structures. Each of these structures includes the data points for that metric, along with the timestamps of those data points and other identifying information.</p>', 'refs' => [ 'MetricDataResults$member' => NULL, ], ], 'MetricDataResultMessages' => [ 'base' => NULL, 'refs' => [ 'GetMetricDataOutput$Messages' => '<p>Contains a message about this <code>GetMetricData</code> operation, if the operation results in such a message. An example of a message that might be returned is <code>Maximum number of allowed metrics exceeded</code>. If there is a message, as much of the operation as possible is still executed.</p> <p>A message appears here only if it is related to the global <code>GetMetricData</code> operation. Any message about a specific metric returned by the operation appears in the <code>MetricDataResult</code> object returned for that metric.</p>', 'MetricDataResult$Messages' => '<p>A list of messages with additional information about the data returned.</p>', ], ], 'MetricDataResults' => [ 'base' => NULL, 'refs' => [ 'GetMetricDataOutput$MetricDataResults' => '<p>The metrics that are returned, including the metric name, namespace, and dimensions.</p>', ], ], 'MetricDatum' => [ 'base' => '<p>Encapsulates the information sent to either create a metric or add new values to be aggregated into an existing metric.</p>', 'refs' => [ 'MetricData$member' => NULL, ], ], 'MetricExpression' => [ 'base' => NULL, 'refs' => [ 'MetricDataQuery$Expression' => '<p>The math expression to be performed on the returned data, if this object is performing a math expression. This expression can use the <code>Id</code> of the other metrics to refer to those metrics, and can also use the <code>Id</code> of other expressions to use the result of those expressions. For more information about metric math expressions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax">Metric Math Syntax and Functions</a> in the <i>Amazon CloudWatch User Guide</i>.</p> <p>Within each MetricDataQuery object, you must specify either <code>Expression</code> or <code>MetricStat</code> but not both.</p>', ], ], 'MetricId' => [ 'base' => NULL, 'refs' => [ 'MetricAlarm$ThresholdMetricId' => '<p>In an alarm based on an anomaly detection model, this is the ID of the <code>ANOMALY_DETECTION_BAND</code> function used as the threshold for the alarm.</p>', 'MetricDataQuery$Id' => '<p>A short name used to tie this object to the results in the response. This name must be unique within a single call to <code>GetMetricData</code>. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscore. The first character must be a lowercase letter.</p>', 'MetricDataResult$Id' => '<p>The short name you specified to represent this metric.</p>', 'PutMetricAlarmInput$ThresholdMetricId' => '<p>If this is an alarm based on an anomaly detection model, make this value match the ID of the <code>ANOMALY_DETECTION_BAND</code> function.</p> <p>For an example of how to use this parameter, see the <b>Anomaly Detection Model Alarm</b> example on this page.</p> <p>If your alarm uses this parameter, it cannot have Auto Scaling actions.</p>', ], ], 'MetricLabel' => [ 'base' => NULL, 'refs' => [ 'GetMetricStatisticsOutput$Label' => '<p>A label for the specified metric.</p>', 'MetricDataQuery$Label' => '<p>A human-readable label for this metric or expression. This is especially useful if this is an expression, so that you know what the value represents. If the metric or expression is shown in a CloudWatch dashboard widget, the label is shown. If Label is omitted, CloudWatch generates a default.</p>', 'MetricDataResult$Label' => '<p>The human-readable label associated with the data.</p>', ], ], 'MetricName' => [ 'base' => NULL, 'refs' => [ 'AnomalyDetector$MetricName' => '<p>The name of the metric associated with the anomaly detection model.</p>', 'DeleteAnomalyDetectorInput$MetricName' => '<p>The metric name associated with the anomaly detection model to delete.</p>', 'DescribeAlarmsForMetricInput$MetricName' => '<p>The name of the metric.</p>', 'DescribeAnomalyDetectorsInput$MetricName' => '<p>Limits the results to only the anomaly detection models that are associated with the specified metric name. If there are multiple metrics with this name in different namespaces that have anomaly detection models, they\'re all returned.</p>', 'GetMetricStatisticsInput$MetricName' => '<p>The name of the metric, with or without spaces.</p>', 'ListMetricsInput$MetricName' => '<p>The name of the metric to filter against.</p>', 'Metric$MetricName' => '<p>The name of the metric. This is a required field.</p>', 'MetricAlarm$MetricName' => '<p>The name of the metric associated with the alarm, if this is an alarm based on a single metric.</p>', 'MetricDatum$MetricName' => '<p>The name of the metric.</p>', 'PutAnomalyDetectorInput$MetricName' => '<p>The name of the metric to create the anomaly detection model for.</p>', 'PutMetricAlarmInput$MetricName' => '<p>The name for the metric associated with the alarm. For each <code>PutMetricAlarm</code> operation, you must specify either <code>MetricName</code> or a <code>Metrics</code> array.</p> <p>If you are creating an alarm based on a math expression, you cannot specify this parameter, or any of the <code>Dimensions</code>, <code>Period</code>, <code>Namespace</code>, <code>Statistic</code>, or <code>ExtendedStatistic</code> parameters. Instead, you specify all this information in the <code>Metrics</code> array.</p>', ], ], 'MetricStat' => [ 'base' => '<p>This structure defines the metric to be returned, along with the statistics, period, and units.</p>', 'refs' => [ 'MetricDataQuery$MetricStat' => '<p>The metric to be returned, along with statistics, period, and units. Use this parameter only if this object is retrieving a metric and not performing a math expression on returned data.</p> <p>Within one MetricDataQuery object, you must specify either <code>Expression</code> or <code>MetricStat</code> but not both.</p>', ], ], 'MetricWidget' => [ 'base' => NULL, 'refs' => [ 'GetMetricWidgetImageInput$MetricWidget' => '<p>A JSON string that defines the bitmap graph to be retrieved. The string includes the metrics to include in the graph, statistics, annotations, title, axis limits, and so on. You can include only one <code>MetricWidget</code> parameter in each <code>GetMetricWidgetImage</code> call.</p> <p>For more information about the syntax of <code>MetricWidget</code> see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/CloudWatch-Metric-Widget-Structure.html">GetMetricWidgetImage: Metric Widget Structure and Syntax</a>.</p> <p>If any metric on the graph could not load all the requested data points, an orange triangle with an exclamation point appears next to the graph legend.</p>', ], ], 'MetricWidgetImage' => [ 'base' => NULL, 'refs' => [ 'GetMetricWidgetImageOutput$MetricWidgetImage' => '<p>The image of the graph, in the output format specified. The output is base64-encoded.</p>', ], ], 'Metrics' => [ 'base' => NULL, 'refs' => [ 'ListMetricsOutput$Metrics' => '<p>The metrics that match your request. </p>', ], ], 'MissingRequiredParameterException' => [ 'base' => '<p>An input parameter that is required is missing.</p>', 'refs' => [], ], 'Namespace' => [ 'base' => NULL, 'refs' => [ 'AnomalyDetector$Namespace' => '<p>The namespace of the metric associated with the anomaly detection model.</p>', 'DeleteAnomalyDetectorInput$Namespace' => '<p>The namespace associated with the anomaly detection model to delete.</p>', 'DescribeAlarmsForMetricInput$Namespace' => '<p>The namespace of the metric.</p>', 'DescribeAnomalyDetectorsInput$Namespace' => '<p>Limits the results to only the anomaly detection models that are associated with the specified namespace.</p>', 'GetMetricStatisticsInput$Namespace' => '<p>The namespace of the metric, with or without spaces.</p>', 'ListMetricsInput$Namespace' => '<p>The namespace to filter against.</p>', 'Metric$Namespace' => '<p>The namespace of the metric.</p>', 'MetricAlarm$Namespace' => '<p>The namespace of the metric associated with the alarm.</p>', 'PutAnomalyDetectorInput$Namespace' => '<p>The namespace of the metric to create the anomaly detection model for.</p>', 'PutMetricAlarmInput$Namespace' => '<p>The namespace for the metric associated specified in <code>MetricName</code>.</p>', 'PutMetricDataInput$Namespace' => '<p>The namespace for the metric data.</p> <p>To avoid conflicts with AWS service namespaces, you should not specify a namespace that begins with <code>AWS/</code> </p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeAlarmHistoryInput$NextToken' => '<p>The token returned by a previous call to indicate that there is more data available.</p>', 'DescribeAlarmHistoryOutput$NextToken' => '<p>The token that marks the start of the next batch of returned results.</p>', 'DescribeAlarmsInput$NextToken' => '<p>The token returned by a previous call to indicate that there is more data available.</p>', 'DescribeAlarmsOutput$NextToken' => '<p>The token that marks the start of the next batch of returned results.</p>', 'DescribeAnomalyDetectorsInput$NextToken' => '<p>Use the token returned by the previous operation to request the next page of results.</p>', 'DescribeAnomalyDetectorsOutput$NextToken' => '<p>A token that you can use in a subsequent operation to retrieve the next set of results.</p>', 'DescribeInsightRulesInput$NextToken' => '<p>Reserved for future use.</p>', 'DescribeInsightRulesOutput$NextToken' => '<p>Reserved for future use.</p>', 'GetMetricDataInput$NextToken' => '<p>Include this value, if it was returned by the previous call, to get the next set of data points.</p>', 'GetMetricDataOutput$NextToken' => '<p>A token that marks the next batch of returned results.</p>', 'ListDashboardsInput$NextToken' => '<p>The token returned by a previous call to indicate that there is more data available.</p>', 'ListDashboardsOutput$NextToken' => '<p>The token that marks the start of the next batch of returned results.</p>', 'ListMetricsInput$NextToken' => '<p>The token returned by a previous call to indicate that there is more data available.</p>', 'ListMetricsOutput$NextToken' => '<p>The token that marks the start of the next batch of returned results. </p>', ], ], 'OutputFormat' => [ 'base' => NULL, 'refs' => [ 'GetMetricWidgetImageInput$OutputFormat' => '<p>The format of the resulting image. Only PNG images are supported.</p> <p>The default is <code>png</code>. If you specify <code>png</code>, the API returns an HTTP response with the content-type set to <code>text/xml</code>. The image data is in a <code>MetricWidgetImage</code> field. For example:</p> <p> <code> &lt;GetMetricWidgetImageResponse xmlns=&lt;URLstring&gt;&gt;</code> </p> <p> <code> &lt;GetMetricWidgetImageResult&gt;</code> </p> <p> <code> &lt;MetricWidgetImage&gt;</code> </p> <p> <code> iVBORw0KGgoAAAANSUhEUgAAAlgAAAGQEAYAAAAip...</code> </p> <p> <code> &lt;/MetricWidgetImage&gt;</code> </p> <p> <code> &lt;/GetMetricWidgetImageResult&gt;</code> </p> <p> <code> &lt;ResponseMetadata&gt;</code> </p> <p> <code> &lt;RequestId&gt;6f0d4192-4d42-11e8-82c1-f539a07e0e3b&lt;/RequestId&gt;</code> </p> <p> <code> &lt;/ResponseMetadata&gt;</code> </p> <p> <code>&lt;/GetMetricWidgetImageResponse&gt;</code> </p> <p>The <code>image/png</code> setting is intended only for custom HTTP requests. For most use cases, and all actions using an AWS SDK, you should use <code>png</code>. If you specify <code>image/png</code>, the HTTP response has a content-type set to <code>image/png</code>, and the body of the response is a PNG image. </p>', ], ], 'PartialFailure' => [ 'base' => '<p>This array is empty if the API operation was successful for all the rules specified in the request. If the operation could not process one of the rules, the following data is returned for each of those rules.</p>', 'refs' => [ 'BatchFailures$member' => NULL, ], ], 'Period' => [ 'base' => NULL, 'refs' => [ 'DescribeAlarmsForMetricInput$Period' => '<p>The period, in seconds, over which the statistic is applied.</p>', 'GetInsightRuleReportInput$Period' => '<p>The period, in seconds, to use for the statistics in the <code>InsightRuleMetricDatapoint</code> results.</p>', 'GetMetricStatisticsInput$Period' => '<p>The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics stored by a <code>PutMetricData</code> call that includes a <code>StorageResolution</code> of 1 second.</p> <p>If the <code>StartTime</code> parameter specifies a time stamp that is greater than 3 hours ago, you must specify the period as follows or no data points in that time range is returned:</p> <ul> <li> <p>Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds (1 minute).</p> </li> <li> <p>Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5 minutes).</p> </li> <li> <p>Start time greater than 63 days ago - Use a multiple of 3600 seconds (1 hour).</p> </li> </ul>', 'MetricAlarm$Period' => '<p>The period, in seconds, over which the statistic is applied.</p>', 'MetricDataQuery$Period' => '<p>The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics stored by a <code>PutMetricData</code> operation that includes a <code>StorageResolution of 1 second</code>.</p>', 'MetricStat$Period' => '<p>The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics stored by a <code>PutMetricData</code> call that includes a <code>StorageResolution</code> of 1 second.</p> <p>If the <code>StartTime</code> parameter specifies a time stamp that is greater than 3 hours ago, you must specify the period as follows or no data points in that time range is returned:</p> <ul> <li> <p>Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds (1 minute).</p> </li> <li> <p>Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5 minutes).</p> </li> <li> <p>Start time greater than 63 days ago - Use a multiple of 3600 seconds (1 hour).</p> </li> </ul>', 'PutMetricAlarmInput$Period' => '<p>The length, in seconds, used each time the metric specified in <code>MetricName</code> is evaluated. Valid values are 10, 30, and any multiple of 60.</p> <p> <code>Period</code> is required for alarms based on static thresholds. If you are creating an alarm based on a metric math expression, you specify the period for each metric within the objects in the <code>Metrics</code> array.</p> <p>Be sure to specify 10 or 30 only for metrics that are stored by a <code>PutMetricData</code> call with a <code>StorageResolution</code> of 1. If you specify a period of 10 or 30 for a metric that does not have sub-minute resolution, the alarm still attempts to gather data at the period rate that you specify. In this case, it does not receive data for the attempts that do not correspond to a one-minute data resolution, and the alarm might often lapse into INSUFFICENT_DATA status. Specifying 10 or 30 also sets this alarm as a high-resolution alarm, which has a higher charge than other alarms. For more information about pricing, see <a href="https://aws.amazon.com/cloudwatch/pricing/">Amazon CloudWatch Pricing</a>.</p> <p>An alarm\'s total current evaluation period can be no longer than one day, so <code>Period</code> multiplied by <code>EvaluationPeriods</code> cannot be more than 86,400 seconds.</p>', ], ], 'PutAnomalyDetectorInput' => [ 'base' => NULL, 'refs' => [], ], 'PutAnomalyDetectorOutput' => [ 'base' => NULL, 'refs' => [], ], 'PutCompositeAlarmInput' => [ 'base' => NULL, 'refs' => [], ], 'PutDashboardInput' => [ 'base' => NULL, 'refs' => [], ], 'PutDashboardOutput' => [ 'base' => NULL, 'refs' => [], ], 'PutInsightRuleInput' => [ 'base' => NULL, 'refs' => [], ], 'PutInsightRuleOutput' => [ 'base' => NULL, 'refs' => [], ], 'PutMetricAlarmInput' => [ 'base' => NULL, 'refs' => [], ], 'PutMetricDataInput' => [ 'base' => NULL, 'refs' => [], ], 'Range' => [ 'base' => '<p>Specifies one range of days or times to exclude from use for training an anomaly detection model.</p>', 'refs' => [ 'AnomalyDetectorExcludedTimeRanges$member' => NULL, ], ], 'RecentlyActive' => [ 'base' => NULL, 'refs' => [ 'ListMetricsInput$RecentlyActive' => '<p>To filter the results to show only metrics that have had data points published in the past three hours, specify this parameter with a value of <code>PT3H</code>. This is the only valid value for this parameter.</p> <p>The results that are returned are an approximation of the value you specify. There is a low probability that the returned results include metrics with last published data as much as 40 minutes more than the specified time interval.</p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'ResourceNotFoundException$ResourceId' => NULL, ], ], 'ResourceList' => [ 'base' => NULL, 'refs' => [ 'CompositeAlarm$AlarmActions' => '<p>The actions to execute when this alarm transitions to the ALARM state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>', 'CompositeAlarm$InsufficientDataActions' => '<p>The actions to execute when this alarm transitions to the INSUFFICIENT_DATA state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>', 'CompositeAlarm$OKActions' => '<p>The actions to execute when this alarm transitions to the OK state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>', 'MetricAlarm$OKActions' => '<p>The actions to execute when this alarm transitions to the <code>OK</code> state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>', 'MetricAlarm$AlarmActions' => '<p>The actions to execute when this alarm transitions to the <code>ALARM</code> state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>', 'MetricAlarm$InsufficientDataActions' => '<p>The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>', 'PutCompositeAlarmInput$AlarmActions' => '<p>The actions to execute when this alarm transitions to the <code>ALARM</code> state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p> <p>Valid Values: <code>arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> </code> </p>', 'PutCompositeAlarmInput$InsufficientDataActions' => '<p>The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p> <p>Valid Values: <code>arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> </code> </p>', 'PutCompositeAlarmInput$OKActions' => '<p>The actions to execute when this alarm transitions to an <code>OK</code> state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p> <p>Valid Values: <code>arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> </code> </p>', 'PutMetricAlarmInput$OKActions' => '<p>The actions to execute when this alarm transitions to an <code>OK</code> state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p> <p>Valid Values: <code>arn:aws:automate:<i>region</i>:ec2:stop</code> | <code>arn:aws:automate:<i>region</i>:ec2:terminate</code> | <code>arn:aws:automate:<i>region</i>:ec2:recover</code> | <code>arn:aws:automate:<i>region</i>:ec2:reboot</code> | <code>arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> </code> | <code>arn:aws:autoscaling:<i>region</i>:<i>account-id</i>:scalingPolicy:<i>policy-id</i>:autoScalingGroupName/<i>group-friendly-name</i>:policyName/<i>policy-friendly-name</i> </code> </p> <p>Valid Values (for use with IAM roles): <code>arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Stop/1.0</code> | <code>arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Terminate/1.0</code> | <code>arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Reboot/1.0</code> </p>', 'PutMetricAlarmInput$AlarmActions' => '<p>The actions to execute when this alarm transitions to the <code>ALARM</code> state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p> <p>Valid Values: <code>arn:aws:automate:<i>region</i>:ec2:stop</code> | <code>arn:aws:automate:<i>region</i>:ec2:terminate</code> | <code>arn:aws:automate:<i>region</i>:ec2:recover</code> | <code>arn:aws:automate:<i>region</i>:ec2:reboot</code> | <code>arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> </code> | <code>arn:aws:autoscaling:<i>region</i>:<i>account-id</i>:scalingPolicy:<i>policy-id</i>:autoScalingGroupName/<i>group-friendly-name</i>:policyName/<i>policy-friendly-name</i> </code> </p> <p>Valid Values (for use with IAM roles): <code>arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Stop/1.0</code> | <code>arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Terminate/1.0</code> | <code>arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Reboot/1.0</code> </p>', 'PutMetricAlarmInput$InsufficientDataActions' => '<p>The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p> <p>Valid Values: <code>arn:aws:automate:<i>region</i>:ec2:stop</code> | <code>arn:aws:automate:<i>region</i>:ec2:terminate</code> | <code>arn:aws:automate:<i>region</i>:ec2:recover</code> | <code>arn:aws:automate:<i>region</i>:ec2:reboot</code> | <code>arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> </code> | <code>arn:aws:autoscaling:<i>region</i>:<i>account-id</i>:scalingPolicy:<i>policy-id</i>:autoScalingGroupName/<i>group-friendly-name</i>:policyName/<i>policy-friendly-name</i> </code> </p> <p>Valid Values (for use with IAM roles): <code>&gt;arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Stop/1.0</code> | <code>arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Terminate/1.0</code> | <code>arn:aws:swf:<i>region</i>:<i>account-id</i>:action/actions/AWS_EC2.InstanceId.Reboot/1.0</code> </p>', ], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'ResourceList$member' => NULL, ], ], 'ResourceNotFound' => [ 'base' => '<p>The named resource does not exist.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The named resource does not exist.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ResourceNotFoundException$ResourceType' => NULL, ], ], 'ReturnData' => [ 'base' => NULL, 'refs' => [ 'MetricDataQuery$ReturnData' => '<p>When used in <code>GetMetricData</code>, this option indicates whether to return the timestamps and raw data values of this metric. If you are performing this call just to do math expressions and do not also need the raw data returned, you can specify <code>False</code>. If you omit this, the default of <code>True</code> is used.</p> <p>When used in <code>PutMetricAlarm</code>, specify <code>True</code> for the one expression result to use as the alarm. For all other metrics and expressions in the same <code>PutMetricAlarm</code> operation, specify <code>ReturnData</code> as False.</p>', ], ], 'ScanBy' => [ 'base' => NULL, 'refs' => [ 'DescribeAlarmHistoryInput$ScanBy' => '<p>Specified whether to return the newest or oldest alarm history first. Specify <code>TimestampDescending</code> to have the newest event history returned first, and specify <code>TimestampAscending</code> to have the oldest history returned first.</p>', 'GetMetricDataInput$ScanBy' => '<p>The order in which data points should be returned. <code>TimestampDescending</code> returns the newest data first and paginates when the <code>MaxDatapoints</code> limit is reached. <code>TimestampAscending</code> returns the oldest data first and paginates when the <code>MaxDatapoints</code> limit is reached.</p>', ], ], 'SetAlarmStateInput' => [ 'base' => NULL, 'refs' => [], ], 'Size' => [ 'base' => NULL, 'refs' => [ 'DashboardEntry$Size' => '<p>The size of the dashboard, in bytes.</p>', ], ], 'StandardUnit' => [ 'base' => NULL, 'refs' => [ 'Datapoint$Unit' => '<p>The standard unit for the data point.</p>', 'DescribeAlarmsForMetricInput$Unit' => '<p>The unit for the metric.</p>', 'GetMetricStatisticsInput$Unit' => '<p>The unit for a given metric. If you omit <code>Unit</code>, all data that was collected with any unit is returned, along with the corresponding units that were specified when the data was reported to CloudWatch. If you specify a unit, the operation returns only data that was collected with that unit specified. If you specify a unit that does not match the data collected, the results of the operation are null. CloudWatch does not perform unit conversions.</p>', 'MetricAlarm$Unit' => '<p>The unit of the metric associated with the alarm.</p>', 'MetricDatum$Unit' => '<p>When you are using a <code>Put</code> operation, this defines what unit you want to use when storing the metric.</p> <p>In a <code>Get</code> operation, this displays the unit that is used for the metric.</p>', 'MetricStat$Unit' => '<p>When you are using a <code>Put</code> operation, this defines what unit you want to use when storing the metric.</p> <p>In a <code>Get</code> operation, if you omit <code>Unit</code> then all data that was collected with any unit is returned, along with the corresponding units that were specified when the data was reported to CloudWatch. If you specify a unit, the operation returns only data that was collected with that unit specified. If you specify a unit that does not match the data collected, the results of the operation are null. CloudWatch does not perform unit conversions.</p>', 'PutMetricAlarmInput$Unit' => '<p>The unit of measure for the statistic. For example, the units for the Amazon EC2 NetworkIn metric are Bytes because NetworkIn tracks the number of bytes that an instance receives on all network interfaces. You can also specify a unit when you create a custom metric. Units help provide conceptual meaning to your data. Metric data points that specify a unit of measure, such as Percent, are aggregated separately.</p> <p>If you don\'t specify <code>Unit</code>, CloudWatch retrieves all unit types that have been published for the metric and attempts to evaluate the alarm. Usually, metrics are published with only one unit, so the alarm works as intended.</p> <p>However, if the metric is published with multiple types of units and you don\'t specify a unit, the alarm\'s behavior is not defined and it behaves predictably.</p> <p>We recommend omitting <code>Unit</code> so that you don\'t inadvertently specify an incorrect unit that is not published for this metric. Doing so causes the alarm to be stuck in the <code>INSUFFICIENT DATA</code> state.</p>', ], ], 'Stat' => [ 'base' => NULL, 'refs' => [ 'MetricStat$Stat' => '<p>The statistic to return. It can include any CloudWatch statistic or extended statistic.</p>', ], ], 'StateReason' => [ 'base' => NULL, 'refs' => [ 'CompositeAlarm$StateReason' => '<p>An explanation for the alarm state, in text format.</p>', 'MetricAlarm$StateReason' => '<p>An explanation for the alarm state, in text format.</p>', 'SetAlarmStateInput$StateReason' => '<p>The reason that this alarm is set to this specific state, in text format.</p>', ], ], 'StateReasonData' => [ 'base' => NULL, 'refs' => [ 'CompositeAlarm$StateReasonData' => '<p>An explanation for the alarm state, in JSON format.</p>', 'MetricAlarm$StateReasonData' => '<p>An explanation for the alarm state, in JSON format.</p>', 'SetAlarmStateInput$StateReasonData' => '<p>The reason that this alarm is set to this specific state, in JSON format.</p> <p>For SNS or EC2 alarm actions, this is just informational. But for EC2 Auto Scaling or application Auto Scaling alarm actions, the Auto Scaling policy uses the information in this field to take the correct action.</p>', ], ], 'StateValue' => [ 'base' => NULL, 'refs' => [ 'CompositeAlarm$StateValue' => '<p>The state value for the alarm.</p>', 'DescribeAlarmsInput$StateValue' => '<p>Specify this parameter to receive information only about alarms that are currently in the state that you specify.</p>', 'MetricAlarm$StateValue' => '<p>The state value for the alarm.</p>', 'SetAlarmStateInput$StateValue' => '<p>The value of the state.</p>', ], ], 'Statistic' => [ 'base' => NULL, 'refs' => [ 'DescribeAlarmsForMetricInput$Statistic' => '<p>The statistic for the metric, other than percentiles. For percentile statistics, use <code>ExtendedStatistics</code>.</p>', 'MetricAlarm$Statistic' => '<p>The statistic for the metric associated with the alarm, other than percentile. For percentile statistics, use <code>ExtendedStatistic</code>.</p>', 'PutMetricAlarmInput$Statistic' => '<p>The statistic for the metric specified in <code>MetricName</code>, other than percentile. For percentile statistics, use <code>ExtendedStatistic</code>. When you call <code>PutMetricAlarm</code> and specify a <code>MetricName</code>, you must specify either <code>Statistic</code> or <code>ExtendedStatistic,</code> but not both.</p>', 'Statistics$member' => NULL, ], ], 'StatisticSet' => [ 'base' => '<p>Represents a set of statistics that describes a specific metric. </p>', 'refs' => [ 'MetricDatum$StatisticValues' => '<p>The statistical values for the metric.</p>', ], ], 'Statistics' => [ 'base' => NULL, 'refs' => [ 'GetMetricStatisticsInput$Statistics' => '<p>The metric statistics, other than percentile. For percentile statistics, use <code>ExtendedStatistics</code>. When calling <code>GetMetricStatistics</code>, you must specify either <code>Statistics</code> or <code>ExtendedStatistics</code>, but not both.</p>', ], ], 'StatusCode' => [ 'base' => NULL, 'refs' => [ 'MetricDataResult$StatusCode' => '<p>The status of the returned data. <code>Complete</code> indicates that all data points in the requested time range were returned. <code>PartialData</code> means that an incomplete set of data points were returned. You can use the <code>NextToken</code> value that was returned and repeat your request to get more data points. <code>NextToken</code> is not returned if you are performing a math expression. <code>InternalError</code> indicates that an error occurred. Retry your request using <code>NextToken</code>, if present.</p>', ], ], 'StorageResolution' => [ 'base' => NULL, 'refs' => [ 'MetricDatum$StorageResolution' => '<p>Valid values are 1 and 60. Setting this to 1 specifies this metric as a high-resolution metric, so that CloudWatch stores the metric with sub-minute resolution down to one second. Setting this to 60 specifies this metric as a regular-resolution metric, which CloudWatch stores at 1-minute resolution. Currently, high resolution is available only for custom metrics. For more information about high-resolution metrics, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html#high-resolution-metrics">High-Resolution Metrics</a> in the <i>Amazon CloudWatch User Guide</i>. </p> <p>This field is optional, if you do not specify it the default of 60 is used.</p>', ], ], 'Tag' => [ 'base' => '<p>A key-value pair associated with a CloudWatch resource.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>A string that you can use to assign a value. The combination of tag keys and values can help you organize and categorize your resources.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$TagKeys' => '<p>The list of tag keys to remove from the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceOutput$Tags' => '<p>The list of tag keys and values associated with the resource you specified.</p>', 'PutCompositeAlarmInput$Tags' => '<p>A list of key-value pairs to associate with the composite alarm. You can associate as many as 50 tags with an alarm.</p> <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only resources with certain tag values.</p>', 'PutInsightRuleInput$Tags' => '<p>A list of key-value pairs to associate with the Contributor Insights rule. You can associate as many as 50 tags with a rule.</p> <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only the resources that have certain tag values.</p> <p>To be able to associate tags with a rule, you must have the <code>cloudwatch:TagResource</code> permission in addition to the <code>cloudwatch:PutInsightRule</code> permission.</p> <p>If you are using this operation to update an existing Contributor Insights rule, any tags you specify in this parameter are ignored. To change the tags of an existing rule, use <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_TagResource.html">TagResource</a>.</p>', 'PutMetricAlarmInput$Tags' => '<p>A list of key-value pairs to associate with the alarm. You can associate as many as 50 tags with an alarm.</p> <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p>', 'TagResourceInput$Tags' => '<p>The list of key-value pairs to associate with the alarm.</p>', ], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value for the specified tag key.</p>', ], ], 'Threshold' => [ 'base' => NULL, 'refs' => [ 'MetricAlarm$Threshold' => '<p>The value to compare with the specified statistic.</p>', 'PutMetricAlarmInput$Threshold' => '<p>The value against which the specified statistic is compared.</p> <p>This parameter is required for alarms based on static thresholds, but should not be used for alarms based on anomaly detection models.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AlarmHistoryItem$Timestamp' => '<p>The time stamp for the alarm history item.</p>', 'CompositeAlarm$AlarmConfigurationUpdatedTimestamp' => '<p>The time stamp of the last update to the alarm configuration.</p>', 'CompositeAlarm$StateUpdatedTimestamp' => '<p>The time stamp of the last update to the alarm state.</p>', 'Datapoint$Timestamp' => '<p>The time stamp used for the data point.</p>', 'DescribeAlarmHistoryInput$StartDate' => '<p>The starting date to retrieve alarm history.</p>', 'DescribeAlarmHistoryInput$EndDate' => '<p>The ending date to retrieve alarm history.</p>', 'GetInsightRuleReportInput$StartTime' => '<p>The start time of the data to use in the report. When used in a raw HTTP Query API, it is formatted as <code>yyyy-MM-dd\'T\'HH:mm:ss</code>. For example, <code>2019-07-01T23:59:59</code>.</p>', 'GetInsightRuleReportInput$EndTime' => '<p>The end time of the data to use in the report. When used in a raw HTTP Query API, it is formatted as <code>yyyy-MM-dd\'T\'HH:mm:ss</code>. For example, <code>2019-07-01T23:59:59</code>.</p>', 'GetMetricDataInput$StartTime' => '<p>The time stamp indicating the earliest data to be returned.</p> <p>The value specified is inclusive; results include data points with the specified time stamp. </p> <p>CloudWatch rounds the specified time stamp as follows:</p> <ul> <li> <p>Start time less than 15 days ago - Round down to the nearest whole minute. For example, 12:32:34 is rounded down to 12:32:00.</p> </li> <li> <p>Start time between 15 and 63 days ago - Round down to the nearest 5-minute clock interval. For example, 12:32:34 is rounded down to 12:30:00.</p> </li> <li> <p>Start time greater than 63 days ago - Round down to the nearest 1-hour clock interval. For example, 12:32:34 is rounded down to 12:00:00.</p> </li> </ul> <p>If you set <code>Period</code> to 5, 10, or 30, the start time of your request is rounded down to the nearest time that corresponds to even 5-, 10-, or 30-second divisions of a minute. For example, if you make a query at (HH:mm:ss) 01:05:23 for the previous 10-second period, the start time of your request is rounded down and you receive data from 01:05:10 to 01:05:20. If you make a query at 15:07:17 for the previous 5 minutes of data, using a period of 5 seconds, you receive data timestamped between 15:02:15 and 15:07:15. </p> <p>For better performance, specify <code>StartTime</code> and <code>EndTime</code> values that align with the value of the metric\'s <code>Period</code> and sync up with the beginning and end of an hour. For example, if the <code>Period</code> of a metric is 5 minutes, specifying 12:05 or 12:30 as <code>StartTime</code> can get a faster response from CloudWatch than setting 12:07 or 12:29 as the <code>StartTime</code>.</p>', 'GetMetricDataInput$EndTime' => '<p>The time stamp indicating the latest data to be returned.</p> <p>The value specified is exclusive; results include data points up to the specified time stamp.</p> <p>For better performance, specify <code>StartTime</code> and <code>EndTime</code> values that align with the value of the metric\'s <code>Period</code> and sync up with the beginning and end of an hour. For example, if the <code>Period</code> of a metric is 5 minutes, specifying 12:05 or 12:30 as <code>EndTime</code> can get a faster response from CloudWatch than setting 12:07 or 12:29 as the <code>EndTime</code>.</p>', 'GetMetricStatisticsInput$StartTime' => '<p>The time stamp that determines the first data point to return. Start times are evaluated relative to the time that CloudWatch receives the request.</p> <p>The value specified is inclusive; results include data points with the specified time stamp. In a raw HTTP query, the time stamp must be in ISO 8601 UTC format (for example, 2016-10-03T23:00:00Z).</p> <p>CloudWatch rounds the specified time stamp as follows:</p> <ul> <li> <p>Start time less than 15 days ago - Round down to the nearest whole minute. For example, 12:32:34 is rounded down to 12:32:00.</p> </li> <li> <p>Start time between 15 and 63 days ago - Round down to the nearest 5-minute clock interval. For example, 12:32:34 is rounded down to 12:30:00.</p> </li> <li> <p>Start time greater than 63 days ago - Round down to the nearest 1-hour clock interval. For example, 12:32:34 is rounded down to 12:00:00.</p> </li> </ul> <p>If you set <code>Period</code> to 5, 10, or 30, the start time of your request is rounded down to the nearest time that corresponds to even 5-, 10-, or 30-second divisions of a minute. For example, if you make a query at (HH:mm:ss) 01:05:23 for the previous 10-second period, the start time of your request is rounded down and you receive data from 01:05:10 to 01:05:20. If you make a query at 15:07:17 for the previous 5 minutes of data, using a period of 5 seconds, you receive data timestamped between 15:02:15 and 15:07:15. </p>', 'GetMetricStatisticsInput$EndTime' => '<p>The time stamp that determines the last data point to return.</p> <p>The value specified is exclusive; results include data points up to the specified time stamp. In a raw HTTP query, the time stamp must be in ISO 8601 UTC format (for example, 2016-10-10T23:00:00Z).</p>', 'InsightRuleContributorDatapoint$Timestamp' => '<p>The timestamp of the data point.</p>', 'InsightRuleMetricDatapoint$Timestamp' => '<p>The timestamp of the data point.</p>', 'MetricAlarm$AlarmConfigurationUpdatedTimestamp' => '<p>The time stamp of the last update to the alarm configuration.</p>', 'MetricAlarm$StateUpdatedTimestamp' => '<p>The time stamp of the last update to the alarm state.</p>', 'MetricDatum$Timestamp' => '<p>The time the metric data was received, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.</p>', 'Range$StartTime' => '<p>The start time of the range to exclude. The format is <code>yyyy-MM-dd\'T\'HH:mm:ss</code>. For example, <code>2019-07-01T23:59:59</code>.</p>', 'Range$EndTime' => '<p>The end time of the range to exclude. The format is <code>yyyy-MM-dd\'T\'HH:mm:ss</code>. For example, <code>2019-07-01T23:59:59</code>.</p>', 'Timestamps$member' => NULL, ], ], 'Timestamps' => [ 'base' => NULL, 'refs' => [ 'MetricDataResult$Timestamps' => '<p>The timestamps for the data points, formatted in Unix timestamp format. The number of timestamps always matches the number of values and the value for Timestamps[x] is Values[x].</p>', ], ], 'TreatMissingData' => [ 'base' => NULL, 'refs' => [ 'MetricAlarm$TreatMissingData' => '<p>Sets how this alarm is to handle missing data points. If this parameter is omitted, the default behavior of <code>missing</code> is used.</p>', 'PutMetricAlarmInput$TreatMissingData' => '<p> Sets how this alarm is to handle missing data points. If <code>TreatMissingData</code> is omitted, the default behavior of <code>missing</code> is used. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarms-and-missing-data">Configuring How CloudWatch Alarms Treats Missing Data</a>.</p> <p>Valid Values: <code>breaching | notBreaching | ignore | missing</code> </p>', ], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'Values' => [ 'base' => NULL, 'refs' => [ 'MetricDatum$Values' => '<p>Array of numbers representing the values for the metric during the period. Each unique value is listed just once in this array, and the corresponding number in the <code>Counts</code> array specifies the number of times that value occurred during the period. You can include up to 150 unique values in each <code>PutMetricData</code> action that specifies a <code>Values</code> array.</p> <p>Although the <code>Values</code> array accepts numbers of type <code>Double</code>, CloudWatch rejects values that are either too small or too large. Values must be in the range of -2^360 to 2^360. In addition, special values (for example, NaN, +Infinity, -Infinity) are not supported.</p>', ], ], ],];
