<?php
// This file was auto-generated from sdk-root/src/data/mediaconvert/2017-08-29/docs-2.json
return [ 'version' => '2.0', 'service' => 'AWS Elemental MediaConvert', 'operations' => [ 'AssociateCertificate' => 'Associates an AWS Certificate Manager (ACM) Amazon Resource Name (ARN) with AWS Elemental MediaConvert.', 'CancelJob' => 'Permanently cancel a job. Once you have canceled a job, you can\'t start it again.', 'CreateJob' => 'Create a new transcoding job. For information about jobs and job settings, see the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html', 'CreateJobTemplate' => 'Create a new job template. For information about job templates see the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html', 'CreatePreset' => 'Create a new preset. For information about job templates see the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html', 'CreateQueue' => 'Create a new transcoding queue. For information about queues, see Working With Queues in the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html', 'DeleteJobTemplate' => 'Permanently delete a job template you have created.', 'DeletePreset' => 'Permanently delete a preset you have created.', 'DeleteQueue' => 'Permanently delete a queue you have created.', 'DescribeEndpoints' => 'Send an request with an empty body to the regional API endpoint to get your account API endpoint.', 'DisassociateCertificate' => 'Removes an association between the Amazon Resource Name (ARN) of an AWS Certificate Manager (ACM) certificate and an AWS Elemental MediaConvert resource.', 'GetJob' => 'Retrieve the JSON for a specific completed transcoding job.', 'GetJobTemplate' => 'Retrieve the JSON for a specific job template.', 'GetPreset' => 'Retrieve the JSON for a specific preset.', 'GetQueue' => 'Retrieve the JSON for a specific queue.', 'ListJobTemplates' => 'Retrieve a JSON array of up to twenty of your job templates. This will return the templates themselves, not just a list of them. To retrieve the next twenty templates, use the nextToken string returned with the array', 'ListJobs' => 'Retrieve a JSON array of up to twenty of your most recently created jobs. This array includes in-process, completed, and errored jobs. This will return the jobs themselves, not just a list of the jobs. To retrieve the twenty next most recent jobs, use the nextToken string returned with the array.', 'ListPresets' => 'Retrieve a JSON array of up to twenty of your presets. This will return the presets themselves, not just a list of them. To retrieve the next twenty presets, use the nextToken string returned with the array.', 'ListQueues' => 'Retrieve a JSON array of up to twenty of your queues. This will return the queues themselves, not just a list of them. To retrieve the next twenty queues, use the nextToken string returned with the array.', 'ListTagsForResource' => 'Retrieve the tags for a MediaConvert resource.', 'TagResource' => 'Add tags to a MediaConvert queue, preset, or job template. For information about tagging, see the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/tagging-resources.html', 'UntagResource' => 'Remove tags from a MediaConvert queue, preset, or job template. For information about tagging, see the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/tagging-resources.html', 'UpdateJobTemplate' => 'Modify one of your existing job templates.', 'UpdatePreset' => 'Modify one of your existing presets.', 'UpdateQueue' => 'Modify one of your existing queues.', ], 'shapes' => [ 'AacAudioDescriptionBroadcasterMix' => [ 'base' => 'Choose BROADCASTER_MIXED_AD when the input contains pre-mixed main audio + audio description (AD) as a stereo pair. The value for AudioType will be set to 3, which signals to downstream systems that this stream contains "broadcaster mixed AD". Note that the input received by the encoder must contain pre-mixed audio; the encoder does not perform the mixing. When you choose BROADCASTER_MIXED_AD, the encoder ignores any values you provide in AudioType and FollowInputAudioType. Choose NORMAL when the input does not contain pre-mixed audio + audio description (AD). In this case, the encoder will use any values you provide for AudioType and FollowInputAudioType.', 'refs' => [ 'AacSettings$AudioDescriptionBroadcasterMix' => 'Choose BROADCASTER_MIXED_AD when the input contains pre-mixed main audio + audio description (AD) as a stereo pair. The value for AudioType will be set to 3, which signals to downstream systems that this stream contains "broadcaster mixed AD". Note that the input received by the encoder must contain pre-mixed audio; the encoder does not perform the mixing. When you choose BROADCASTER_MIXED_AD, the encoder ignores any values you provide in AudioType and FollowInputAudioType. Choose NORMAL when the input does not contain pre-mixed audio + audio description (AD). In this case, the encoder will use any values you provide for AudioType and FollowInputAudioType.', ], ], 'AacCodecProfile' => [ 'base' => 'AAC Profile.', 'refs' => [ 'AacSettings$CodecProfile' => 'AAC Profile.', ], ], 'AacCodingMode' => [ 'base' => 'Mono (Audio Description), Mono, Stereo, or 5.1 channel layout. Valid values depend on rate control mode and profile. "1.0 - Audio Description (Receiver Mix)" setting receives a stereo description plus control track and emits a mono AAC encode of the description track, with control data emitted in the PES header as per ETSI TS 101 154 Annex E.', 'refs' => [ 'AacSettings$CodingMode' => 'Mono (Audio Description), Mono, Stereo, or 5.1 channel layout. Valid values depend on rate control mode and profile. "1.0 - Audio Description (Receiver Mix)" setting receives a stereo description plus control track and emits a mono AAC encode of the description track, with control data emitted in the PES header as per ETSI TS 101 154 Annex E.', ], ], 'AacRateControlMode' => [ 'base' => 'Rate Control Mode.', 'refs' => [ 'AacSettings$RateControlMode' => 'Rate Control Mode.', ], ], 'AacRawFormat' => [ 'base' => 'Enables LATM/LOAS AAC output. Note that if you use LATM/LOAS AAC in an output, you must choose "No container" for the output container.', 'refs' => [ 'AacSettings$RawFormat' => 'Enables LATM/LOAS AAC output. Note that if you use LATM/LOAS AAC in an output, you must choose "No container" for the output container.', ], ], 'AacSettings' => [ 'base' => 'Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AAC. The service accepts one of two mutually exclusive groups of AAC settings--VBR and CBR. To select one of these modes, set the value of Bitrate control mode (rateControlMode) to "VBR" or "CBR". In VBR mode, you control the audio quality with the setting VBR quality (vbrQuality). In CBR mode, you use the setting Bitrate (bitrate). Defaults and valid values depend on the rate control mode.', 'refs' => [ 'AudioCodecSettings$AacSettings' => 'Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AAC. The service accepts one of two mutually exclusive groups of AAC settings--VBR and CBR. To select one of these modes, set the value of Bitrate control mode (rateControlMode) to "VBR" or "CBR". In VBR mode, you control the audio quality with the setting VBR quality (vbrQuality). In CBR mode, you use the setting Bitrate (bitrate). Defaults and valid values depend on the rate control mode.', ], ], 'AacSpecification' => [ 'base' => 'Use MPEG-2 AAC instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.', 'refs' => [ 'AacSettings$Specification' => 'Use MPEG-2 AAC instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.', ], ], 'AacVbrQuality' => [ 'base' => 'VBR Quality Level - Only used if rate_control_mode is VBR.', 'refs' => [ 'AacSettings$VbrQuality' => 'VBR Quality Level - Only used if rate_control_mode is VBR.', ], ], 'Ac3BitstreamMode' => [ 'base' => 'Specify the bitstream mode for the AC-3 stream that the encoder emits. For more information about the AC3 bitstream mode, see ATSC A/52-2012 (Annex E).', 'refs' => [ 'Ac3Settings$BitstreamMode' => 'Specify the bitstream mode for the AC-3 stream that the encoder emits. For more information about the AC3 bitstream mode, see ATSC A/52-2012 (Annex E).', ], ], 'Ac3CodingMode' => [ 'base' => 'Dolby Digital coding mode. Determines number of channels.', 'refs' => [ 'Ac3Settings$CodingMode' => 'Dolby Digital coding mode. Determines number of channels.', ], ], 'Ac3DynamicRangeCompressionProfile' => [ 'base' => 'If set to FILM_STANDARD, adds dynamic range compression signaling to the output bitstream as defined in the Dolby Digital specification.', 'refs' => [ 'Ac3Settings$DynamicRangeCompressionProfile' => 'If set to FILM_STANDARD, adds dynamic range compression signaling to the output bitstream as defined in the Dolby Digital specification.', ], ], 'Ac3LfeFilter' => [ 'base' => 'Applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with 3_2_LFE coding mode.', 'refs' => [ 'Ac3Settings$LfeFilter' => 'Applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with 3_2_LFE coding mode.', ], ], 'Ac3MetadataControl' => [ 'base' => 'When set to FOLLOW_INPUT, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that supplied this audio data. If audio was not supplied from one of these streams, then the static metadata settings will be used.', 'refs' => [ 'Ac3Settings$MetadataControl' => 'When set to FOLLOW_INPUT, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that supplied this audio data. If audio was not supplied from one of these streams, then the static metadata settings will be used.', ], ], 'Ac3Settings' => [ 'base' => 'Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AC3.', 'refs' => [ 'AudioCodecSettings$Ac3Settings' => 'Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AC3.', ], ], 'AccelerationMode' => [ 'base' => 'Specify whether the service runs your job with accelerated transcoding. Choose DISABLED if you don\'t want accelerated transcoding. Choose ENABLED if you want your job to run with accelerated transcoding and to fail if your input files or your job settings aren\'t compatible with accelerated transcoding. Choose PREFERRED if you want your job to run with accelerated transcoding if the job is compatible with the feature and to run at standard speed if it\'s not.', 'refs' => [ 'AccelerationSettings$Mode' => 'Specify the conditions when the service will run your job with accelerated transcoding.', ], ], 'AccelerationSettings' => [ 'base' => 'Accelerated transcoding can significantly speed up jobs with long, visually complex content.', 'refs' => [ 'CreateJobRequest$AccelerationSettings' => 'Optional. Accelerated transcoding can significantly speed up jobs with long, visually complex content. Outputs that use this feature incur pro-tier pricing. For information about feature limitations, see the AWS Elemental MediaConvert User Guide.', 'CreateJobTemplateRequest$AccelerationSettings' => 'Accelerated transcoding can significantly speed up jobs with long, visually complex content. Outputs that use this feature incur pro-tier pricing. For information about feature limitations, see the AWS Elemental MediaConvert User Guide.', 'Job$AccelerationSettings' => 'Accelerated transcoding can significantly speed up jobs with long, visually complex content.', 'JobTemplate$AccelerationSettings' => 'Accelerated transcoding can significantly speed up jobs with long, visually complex content.', 'UpdateJobTemplateRequest$AccelerationSettings' => 'Accelerated transcoding can significantly speed up jobs with long, visually complex content. Outputs that use this feature incur pro-tier pricing. For information about feature limitations, see the AWS Elemental MediaConvert User Guide.', ], ], 'AccelerationStatus' => [ 'base' => 'Describes whether the current job is running with accelerated transcoding. For jobs that have Acceleration (AccelerationMode) set to DISABLED, AccelerationStatus is always NOT_APPLICABLE. For jobs that have Acceleration (AccelerationMode) set to ENABLED or PREFERRED, AccelerationStatus is one of the other states. AccelerationStatus is IN_PROGRESS initially, while the service determines whether the input files and job settings are compatible with accelerated transcoding. If they are, AcclerationStatus is ACCELERATED. If your input files and job settings aren\'t compatible with accelerated transcoding, the service either fails your job or runs it without accelerated transcoding, depending on how you set Acceleration (AccelerationMode). When the service runs your job without accelerated transcoding, AccelerationStatus is NOT_ACCELERATED.', 'refs' => [ 'Job$AccelerationStatus' => 'Describes whether the current job is running with accelerated transcoding. For jobs that have Acceleration (AccelerationMode) set to DISABLED, AccelerationStatus is always NOT_APPLICABLE. For jobs that have Acceleration (AccelerationMode) set to ENABLED or PREFERRED, AccelerationStatus is one of the other states. AccelerationStatus is IN_PROGRESS initially, while the service determines whether the input files and job settings are compatible with accelerated transcoding. If they are, AcclerationStatus is ACCELERATED. If your input files and job settings aren\'t compatible with accelerated transcoding, the service either fails your job or runs it without accelerated transcoding, depending on how you set Acceleration (AccelerationMode). When the service runs your job without accelerated transcoding, AccelerationStatus is NOT_ACCELERATED.', ], ], 'AfdSignaling' => [ 'base' => 'This setting only applies to H.264, H.265, and MPEG2 outputs. Use Insert AFD signaling (AfdSignaling) to specify whether the service includes AFD values in the output video data and what those values are. * Choose None to remove all AFD values from this output. * Choose Fixed to ignore input AFD values and instead encode the value specified in the job. * Choose Auto to calculate output AFD values based on the input AFD scaler data.', 'refs' => [ 'VideoDescription$AfdSignaling' => 'This setting only applies to H.264, H.265, and MPEG2 outputs. Use Insert AFD signaling (AfdSignaling) to specify whether the service includes AFD values in the output video data and what those values are. * Choose None to remove all AFD values from this output. * Choose Fixed to ignore input AFD values and instead encode the value specified in the job. * Choose Auto to calculate output AFD values based on the input AFD scaler data.', ], ], 'AiffSettings' => [ 'base' => 'Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AIFF.', 'refs' => [ 'AudioCodecSettings$AiffSettings' => 'Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AIFF.', ], ], 'AlphaBehavior' => [ 'base' => 'Ignore this setting unless this input is a QuickTime animation with an alpha channel. Use this setting to create separate Key and Fill outputs. In each output, specify which part of the input MediaConvert uses. Leave this setting at the default value DISCARD to delete the alpha channel and preserve the video. Set it to REMAP_TO_LUMA to delete the video and map the alpha channel to the luma channel of your outputs.', 'refs' => [ 'VideoSelector$AlphaBehavior' => 'Ignore this setting unless this input is a QuickTime animation with an alpha channel. Use this setting to create separate Key and Fill outputs. In each output, specify which part of the input MediaConvert uses. Leave this setting at the default value DISCARD to delete the alpha channel and preserve the video. Set it to REMAP_TO_LUMA to delete the video and map the alpha channel to the luma channel of your outputs.', ], ], 'AncillaryConvert608To708' => [ 'base' => 'Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you choose Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608 data through using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data into 708.', 'refs' => [ 'AncillarySourceSettings$Convert608To708' => 'Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you choose Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608 data through using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data into 708.', ], ], 'AncillarySourceSettings' => [ 'base' => 'Settings for ancillary captions source.', 'refs' => [ 'CaptionSourceSettings$AncillarySourceSettings' => 'Settings for ancillary captions source.', ], ], 'AncillaryTerminateCaptions' => [ 'base' => 'By default, the service terminates any unterminated captions at the end of each input. If you want the caption to continue onto your next input, disable this setting.', 'refs' => [ 'AncillarySourceSettings$TerminateCaptions' => 'By default, the service terminates any unterminated captions at the end of each input. If you want the caption to continue onto your next input, disable this setting.', ], ], 'AntiAlias' => [ 'base' => 'The anti-alias filter is automatically applied to all outputs. The service no longer accepts the value DISABLED for AntiAlias. If you specify that in your job, the service will ignore the setting.', 'refs' => [ 'VideoDescription$AntiAlias' => 'The anti-alias filter is automatically applied to all outputs. The service no longer accepts the value DISABLED for AntiAlias. If you specify that in your job, the service will ignore the setting.', ], ], 'AssociateCertificateRequest' => [ 'base' => 'Associates the Amazon Resource Name (ARN) of an AWS Certificate Manager (ACM) certificate with an AWS Elemental MediaConvert resource.', 'refs' => [], ], 'AssociateCertificateResponse' => [ 'base' => 'Successful association of Certificate Manager Amazon Resource Name (ARN) with Mediaconvert returns an OK message.', 'refs' => [], ], 'AudioCodec' => [ 'base' => 'Type of Audio codec.', 'refs' => [ 'AudioCodecSettings$Codec' => 'Type of Audio codec.', ], ], 'AudioCodecSettings' => [ 'base' => 'Audio codec settings (CodecSettings) under (AudioDescriptions) contains the group of settings related to audio encoding. The settings in this group vary depending on the value that you choose for Audio codec (Codec). For each codec enum that you choose, define the corresponding settings object. The following lists the codec enum, settings object pairs. * AAC, AacSettings * MP2, Mp2Settings * MP3, Mp3Settings * WAV, WavSettings * AIFF, AiffSettings * AC3, Ac3Settings * EAC3, Eac3Settings * EAC3_ATMOS, Eac3AtmosSettings * VORBIS, VorbisSettings * OPUS, OpusSettings', 'refs' => [ 'AudioDescription$CodecSettings' => 'Audio codec settings (CodecSettings) under (AudioDescriptions) contains the group of settings related to audio encoding. The settings in this group vary depending on the value that you choose for Audio codec (Codec). For each codec enum that you choose, define the corresponding settings object. The following lists the codec enum, settings object pairs. * AAC, AacSettings * MP2, Mp2Settings * MP3, Mp3Settings * WAV, WavSettings * AIFF, AiffSettings * AC3, Ac3Settings * EAC3, Eac3Settings * EAC3_ATMOS, Eac3AtmosSettings * VORBIS, VorbisSettings * OPUS, OpusSettings', ], ], 'AudioDefaultSelection' => [ 'base' => 'Enable this setting on one audio selector to set it as the default for the job. The service uses this default for outputs where it can\'t find the specified input audio. If you don\'t set a default, those outputs have no audio.', 'refs' => [ 'AudioSelector$DefaultSelection' => 'Enable this setting on one audio selector to set it as the default for the job. The service uses this default for outputs where it can\'t find the specified input audio. If you don\'t set a default, those outputs have no audio.', ], ], 'AudioDescription' => [ 'base' => 'Description of audio output', 'refs' => [ '__listOfAudioDescription$member' => NULL, ], ], 'AudioLanguageCodeControl' => [ 'base' => 'Specify which source for language code takes precedence for this audio track. When you choose Follow input (FOLLOW_INPUT), the service uses the language code from the input track if it\'s present. If there\'s no languge code on the input track, the service uses the code that you specify in the setting Language code (languageCode or customLanguageCode). When you choose Use configured (USE_CONFIGURED), the service uses the language code that you specify.', 'refs' => [ 'AudioDescription$LanguageCodeControl' => 'Specify which source for language code takes precedence for this audio track. When you choose Follow input (FOLLOW_INPUT), the service uses the language code from the input track if it\'s present. If there\'s no languge code on the input track, the service uses the code that you specify in the setting Language code (languageCode or customLanguageCode). When you choose Use configured (USE_CONFIGURED), the service uses the language code that you specify.', ], ], 'AudioNormalizationAlgorithm' => [ 'base' => 'Choose one of the following audio normalization algorithms: ITU-R BS.1770-1: Ungated loudness. A measurement of ungated average loudness for an entire piece of content, suitable for measurement of short-form content under ATSC recommendation A/85. Supports up to 5.1 audio channels. ITU-R BS.1770-2: Gated loudness. A measurement of gated average loudness compliant with the requirements of EBU-R128. Supports up to 5.1 audio channels. ITU-R BS.1770-3: Modified peak. The same loudness measurement algorithm as 1770-2, with an updated true peak measurement. ITU-R BS.1770-4: Higher channel count. Allows for more audio channels than the other algorithms, including configurations such as 7.1.', 'refs' => [ 'AudioNormalizationSettings$Algorithm' => 'Choose one of the following audio normalization algorithms: ITU-R BS.1770-1: Ungated loudness. A measurement of ungated average loudness for an entire piece of content, suitable for measurement of short-form content under ATSC recommendation A/85. Supports up to 5.1 audio channels. ITU-R BS.1770-2: Gated loudness. A measurement of gated average loudness compliant with the requirements of EBU-R128. Supports up to 5.1 audio channels. ITU-R BS.1770-3: Modified peak. The same loudness measurement algorithm as 1770-2, with an updated true peak measurement. ITU-R BS.1770-4: Higher channel count. Allows for more audio channels than the other algorithms, including configurations such as 7.1.', ], ], 'AudioNormalizationAlgorithmControl' => [ 'base' => 'When enabled the output audio is corrected using the chosen algorithm. If disabled, the audio will be measured but not adjusted.', 'refs' => [ 'AudioNormalizationSettings$AlgorithmControl' => 'When enabled the output audio is corrected using the chosen algorithm. If disabled, the audio will be measured but not adjusted.', ], ], 'AudioNormalizationLoudnessLogging' => [ 'base' => 'If set to LOG, log each output\'s audio track loudness to a CSV file.', 'refs' => [ 'AudioNormalizationSettings$LoudnessLogging' => 'If set to LOG, log each output\'s audio track loudness to a CSV file.', ], ], 'AudioNormalizationPeakCalculation' => [ 'base' => 'If set to TRUE_PEAK, calculate and log the TruePeak for each output\'s audio track loudness.', 'refs' => [ 'AudioNormalizationSettings$PeakCalculation' => 'If set to TRUE_PEAK, calculate and log the TruePeak for each output\'s audio track loudness.', ], ], 'AudioNormalizationSettings' => [ 'base' => 'Advanced audio normalization settings. Ignore these settings unless you need to comply with a loudness standard.', 'refs' => [ 'AudioDescription$AudioNormalizationSettings' => 'Advanced audio normalization settings. Ignore these settings unless you need to comply with a loudness standard.', ], ], 'AudioSelector' => [ 'base' => 'Selector for Audio', 'refs' => [ '__mapOfAudioSelector$member' => NULL, ], ], 'AudioSelectorGroup' => [ 'base' => 'Group of Audio Selectors', 'refs' => [ '__mapOfAudioSelectorGroup$member' => NULL, ], ], 'AudioSelectorType' => [ 'base' => 'Specifies the type of the audio selector.', 'refs' => [ 'AudioSelector$SelectorType' => 'Specifies the type of the audio selector.', ], ], 'AudioTypeControl' => [ 'base' => 'When set to FOLLOW_INPUT, if the input contains an ISO 639 audio_type, then that value is passed through to the output. If the input contains no ISO 639 audio_type, the value in Audio Type is included in the output. Otherwise the value in Audio Type is included in the output. Note that this field and audioType are both ignored if audioDescriptionBroadcasterMix is set to BROADCASTER_MIXED_AD.', 'refs' => [ 'AudioDescription$AudioTypeControl' => 'When set to FOLLOW_INPUT, if the input contains an ISO 639 audio_type, then that value is passed through to the output. If the input contains no ISO 639 audio_type, the value in Audio Type is included in the output. Otherwise the value in Audio Type is included in the output. Note that this field and audioType are both ignored if audioDescriptionBroadcasterMix is set to BROADCASTER_MIXED_AD.', ], ], 'Av1AdaptiveQuantization' => [ 'base' => 'Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.', 'refs' => [ 'Av1Settings$AdaptiveQuantization' => 'Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.', ], ], 'Av1FramerateControl' => [ 'base' => 'If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.', 'refs' => [ 'Av1Settings$FramerateControl' => 'If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.', ], ], 'Av1FramerateConversionAlgorithm' => [ 'base' => 'Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use duplicate drop conversion.', 'refs' => [ 'Av1Settings$FramerateConversionAlgorithm' => 'Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use duplicate drop conversion.', ], ], 'Av1QvbrSettings' => [ 'base' => 'Settings for quality-defined variable bitrate encoding with the AV1 codec. Required when you set Rate control mode to QVBR. Not valid when you set Rate control mode to a value other than QVBR, or when you don\'t define Rate control mode.', 'refs' => [ 'Av1Settings$QvbrSettings' => 'Settings for quality-defined variable bitrate encoding with the AV1 codec. Required when you set Rate control mode to QVBR. Not valid when you set Rate control mode to a value other than QVBR, or when you don\'t define Rate control mode.', ], ], 'Av1RateControlMode' => [ 'base' => '\'With AV1 outputs, for rate control mode, MediaConvert supports only quality-defined variable bitrate (QVBR). You can\'\'t use CBR or VBR.\'', 'refs' => [ 'Av1Settings$RateControlMode' => '\'With AV1 outputs, for rate control mode, MediaConvert supports only quality-defined variable bitrate (QVBR). You can\'\'t use CBR or VBR.\'', ], ], 'Av1Settings' => [ 'base' => 'Required when you set Codec, under VideoDescription>CodecSettings to the value AV1.', 'refs' => [ 'VideoCodecSettings$Av1Settings' => 'Required when you set Codec, under VideoDescription>CodecSettings to the value AV1.', ], ], 'Av1SpatialAdaptiveQuantization' => [ 'base' => 'Adjust quantization within each frame based on spatial variation of content complexity.', 'refs' => [ 'Av1Settings$SpatialAdaptiveQuantization' => 'Adjust quantization within each frame based on spatial variation of content complexity.', ], ], 'AvailBlanking' => [ 'base' => 'Settings for Avail Blanking', 'refs' => [ 'JobSettings$AvailBlanking' => 'Settings for ad avail blanking. Video can be blanked or overlaid with an image, and audio muted during SCTE-35 triggered ad avails.', 'JobTemplateSettings$AvailBlanking' => 'Settings for ad avail blanking. Video can be blanked or overlaid with an image, and audio muted during SCTE-35 triggered ad avails.', ], ], 'BadRequestException' => [ 'base' => NULL, 'refs' => [], ], 'BillingTagsSource' => [ 'base' => 'The tag type that AWS Billing and Cost Management will use to sort your AWS Elemental MediaConvert costs on any billing report that you set up.', 'refs' => [ 'CreateJobRequest$BillingTagsSource' => 'Optional. Choose a tag type that AWS Billing and Cost Management will use to sort your AWS Elemental MediaConvert costs on any billing report that you set up. Any transcoding outputs that don\'t have an associated tag will appear in your billing report unsorted. If you don\'t choose a valid value for this field, your job outputs will appear on the billing report unsorted.', 'Job$BillingTagsSource' => 'The tag type that AWS Billing and Cost Management will use to sort your AWS Elemental MediaConvert costs on any billing report that you set up.', ], ], 'BurninDestinationSettings' => [ 'base' => 'Burn-In Destination Settings.', 'refs' => [ 'CaptionDestinationSettings$BurninDestinationSettings' => 'Burn-In Destination Settings.', ], ], 'BurninSubtitleAlignment' => [ 'base' => 'If no explicit x_position or y_position is provided, setting alignment to centered will place the captions at the bottom center of the output. Similarly, setting a left alignment will align captions to the bottom left of the output. If x and y positions are given in conjunction with the alignment parameter, the font will be justified (either left or centered) relative to those coordinates. This option is not valid for source captions that are STL, 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.', 'refs' => [ 'BurninDestinationSettings$Alignment' => 'If no explicit x_position or y_position is provided, setting alignment to centered will place the captions at the bottom center of the output. Similarly, setting a left alignment will align captions to the bottom left of the output. If x and y positions are given in conjunction with the alignment parameter, the font will be justified (either left or centered) relative to those coordinates. This option is not valid for source captions that are STL, 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.', ], ], 'BurninSubtitleBackgroundColor' => [ 'base' => 'Specifies the color of the rectangle behind the captions.All burn-in and DVB-Sub font settings must match.', 'refs' => [ 'BurninDestinationSettings$BackgroundColor' => 'Specifies the color of the rectangle behind the captions.All burn-in and DVB-Sub font settings must match.', ], ], 'BurninSubtitleFontColor' => [ 'base' => 'Specifies the color of the burned-in captions. This option is not valid for source captions that are STL, 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.', 'refs' => [ 'BurninDestinationSettings$FontColor' => 'Specifies the color of the burned-in captions. This option is not valid for source captions that are STL, 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.', ], ], 'BurninSubtitleOutlineColor' => [ 'base' => 'Specifies font outline color. This option is not valid for source captions that are either 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.', 'refs' => [ 'BurninDestinationSettings$OutlineColor' => 'Specifies font outline color. This option is not valid for source captions that are either 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.', ], ], 'BurninSubtitleShadowColor' => [ 'base' => 'Specifies the color of the shadow cast by the captions.All burn-in and DVB-Sub font settings must match.', 'refs' => [ 'BurninDestinationSettings$ShadowColor' => 'Specifies the color of the shadow cast by the captions.All burn-in and DVB-Sub font settings must match.', ], ], 'BurninSubtitleTeletextSpacing' => [ 'base' => 'Only applies to jobs with input captions in Teletext or STL formats. Specify whether the spacing between letters in your captions is set by the captions grid or varies depending on letter width. Choose fixed grid to conform to the spacing specified in the captions file more accurately. Choose proportional to make the text easier to read if the captions are closed caption.', 'refs' => [ 'BurninDestinationSettings$TeletextSpacing' => 'Only applies to jobs with input captions in Teletext or STL formats. Specify whether the spacing between letters in your captions is set by the captions grid or varies depending on letter width. Choose fixed grid to conform to the spacing specified in the captions file more accurately. Choose proportional to make the text easier to read if the captions are closed caption.', ], ], 'CancelJobRequest' => [ 'base' => 'Cancel a job by sending a request with the job ID', 'refs' => [], ], 'CancelJobResponse' => [ 'base' => 'A cancel job request will receive a response with an empty body.', 'refs' => [], ], 'CaptionDescription' => [ 'base' => 'Description of Caption output', 'refs' => [ '__listOfCaptionDescription$member' => NULL, ], ], 'CaptionDescriptionPreset' => [ 'base' => 'Caption Description for preset', 'refs' => [ '__listOfCaptionDescriptionPreset$member' => NULL, ], ], 'CaptionDestinationSettings' => [ 'base' => 'Specific settings required by destination type. Note that burnin_destination_settings are not available if the source of the caption data is Embedded or Teletext.', 'refs' => [ 'CaptionDescription$DestinationSettings' => 'Specific settings required by destination type. Note that burnin_destination_settings are not available if the source of the caption data is Embedded or Teletext.', 'CaptionDescriptionPreset$DestinationSettings' => 'Specific settings required by destination type. Note that burnin_destination_settings are not available if the source of the caption data is Embedded or Teletext.', ], ], 'CaptionDestinationType' => [ 'base' => 'Specify the format for this set of captions on this output. The default format is embedded without SCTE-20. Other options are embedded with SCTE-20, burn-in, DVB-sub, IMSC, SCC, SRT, teletext, TTML, and web-VTT. If you are using SCTE-20, choose SCTE-20 plus embedded (SCTE20_PLUS_EMBEDDED) to create an output that complies with the SCTE-43 spec. To create a non-compliant output where the embedded captions come first, choose Embedded plus SCTE-20 (EMBEDDED_PLUS_SCTE20).', 'refs' => [ 'CaptionDestinationSettings$DestinationType' => 'Specify the format for this set of captions on this output. The default format is embedded without SCTE-20. Other options are embedded with SCTE-20, burn-in, DVB-sub, IMSC, SCC, SRT, teletext, TTML, and web-VTT. If you are using SCTE-20, choose SCTE-20 plus embedded (SCTE20_PLUS_EMBEDDED) to create an output that complies with the SCTE-43 spec. To create a non-compliant output where the embedded captions come first, choose Embedded plus SCTE-20 (EMBEDDED_PLUS_SCTE20).', ], ], 'CaptionSelector' => [ 'base' => 'Set up captions in your outputs by first selecting them from your input here.', 'refs' => [ '__mapOfCaptionSelector$member' => NULL, ], ], 'CaptionSourceFramerate' => [ 'base' => 'Ignore this setting unless your input captions format is SCC. To have the service compensate for differing frame rates between your input captions and input video, specify the frame rate of the captions file. Specify this value as a fraction, using the settings Framerate numerator (framerateNumerator) and Framerate denominator (framerateDenominator). For example, you might specify 24 / 1 for 24 fps, 25 / 1 for 25 fps, 24000 / 1001 for 23.976 fps, or 30000 / 1001 for 29.97 fps.', 'refs' => [ 'FileSourceSettings$Framerate' => 'Ignore this setting unless your input captions format is SCC. To have the service compensate for differing frame rates between your input captions and input video, specify the frame rate of the captions file. Specify this value as a fraction, using the settings Framerate numerator (framerateNumerator) and Framerate denominator (framerateDenominator). For example, you might specify 24 / 1 for 24 fps, 25 / 1 for 25 fps, 24000 / 1001 for 23.976 fps, or 30000 / 1001 for 29.97 fps.', ], ], 'CaptionSourceSettings' => [ 'base' => 'If your input captions are SCC, TTML, STL, SMI, SRT, or IMSC in an xml file, specify the URI of the input captions source file. If your input captions are IMSC in an IMF package, use TrackSourceSettings instead of FileSoureSettings.', 'refs' => [ 'CaptionSelector$SourceSettings' => 'If your input captions are SCC, TTML, STL, SMI, SRT, or IMSC in an xml file, specify the URI of the input captions source file. If your input captions are IMSC in an IMF package, use TrackSourceSettings instead of FileSoureSettings.', ], ], 'CaptionSourceType' => [ 'base' => 'Use Source (SourceType) to identify the format of your input captions. The service cannot auto-detect caption format.', 'refs' => [ 'CaptionSourceSettings$SourceType' => 'Use Source (SourceType) to identify the format of your input captions. The service cannot auto-detect caption format.', ], ], 'ChannelMapping' => [ 'base' => 'Channel mapping (ChannelMapping) contains the group of fields that hold the remixing value for each channel. Units are in dB. Acceptable values are within the range from -60 (mute) through 6. A setting of 0 passes the input channel unchanged to the output channel (no attenuation or amplification).', 'refs' => [ 'RemixSettings$ChannelMapping' => 'Channel mapping (ChannelMapping) contains the group of fields that hold the remixing value for each channel. Units are in dB. Acceptable values are within the range from -60 (mute) through 6. A setting of 0 passes the input channel unchanged to the output channel (no attenuation or amplification).', ], ], 'CmafAdditionalManifest' => [ 'base' => 'Specify the details for each pair of HLS and DASH additional manifests that you want the service to generate for this CMAF output group. Each pair of manifests can reference a different subset of outputs in the group.', 'refs' => [ '__listOfCmafAdditionalManifest$member' => NULL, ], ], 'CmafClientCache' => [ 'base' => 'When set to ENABLED, sets #EXT-X-ALLOW-CACHE:no tag, which prevents client from saving media segments for later replay.', 'refs' => [ 'CmafGroupSettings$ClientCache' => 'When set to ENABLED, sets #EXT-X-ALLOW-CACHE:no tag, which prevents client from saving media segments for later replay.', ], ], 'CmafCodecSpecification' => [ 'base' => 'Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.', 'refs' => [ 'CmafGroupSettings$CodecSpecification' => 'Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.', ], ], 'CmafEncryptionSettings' => [ 'base' => 'Settings for CMAF encryption', 'refs' => [ 'CmafGroupSettings$Encryption' => 'DRM settings.', ], ], 'CmafEncryptionType' => [ 'base' => 'Specify the encryption scheme that you want the service to use when encrypting your CMAF segments. Choose AES-CBC subsample (SAMPLE-AES) or AES_CTR (AES-CTR).', 'refs' => [ 'CmafEncryptionSettings$EncryptionMethod' => 'Specify the encryption scheme that you want the service to use when encrypting your CMAF segments. Choose AES-CBC subsample (SAMPLE-AES) or AES_CTR (AES-CTR).', ], ], 'CmafGroupSettings' => [ 'base' => 'Required when you set (Type) under (OutputGroups)>(OutputGroupSettings) to CMAF_GROUP_SETTINGS. Each output in a CMAF Output Group may only contain a single video, audio, or caption output.', 'refs' => [ 'OutputGroupSettings$CmafGroupSettings' => 'Required when you set (Type) under (OutputGroups)>(OutputGroupSettings) to CMAF_GROUP_SETTINGS. Each output in a CMAF Output Group may only contain a single video, audio, or caption output.', ], ], 'CmafInitializationVectorInManifest' => [ 'base' => 'When you use DRM with CMAF outputs, choose whether the service writes the 128-bit encryption initialization vector in the HLS and DASH manifests.', 'refs' => [ 'CmafEncryptionSettings$InitializationVectorInManifest' => 'When you use DRM with CMAF outputs, choose whether the service writes the 128-bit encryption initialization vector in the HLS and DASH manifests.', ], ], 'CmafKeyProviderType' => [ 'base' => 'Specify whether your DRM encryption key is static or from a key provider that follows the SPEKE standard. For more information about SPEKE, see https://docs.aws.amazon.com/speke/latest/documentation/what-is-speke.html.', 'refs' => [ 'CmafEncryptionSettings$Type' => 'Specify whether your DRM encryption key is static or from a key provider that follows the SPEKE standard. For more information about SPEKE, see https://docs.aws.amazon.com/speke/latest/documentation/what-is-speke.html.', ], ], 'CmafManifestCompression' => [ 'base' => 'When set to GZIP, compresses HLS playlist.', 'refs' => [ 'CmafGroupSettings$ManifestCompression' => 'When set to GZIP, compresses HLS playlist.', ], ], 'CmafManifestDurationFormat' => [ 'base' => 'Indicates whether the output manifest should use floating point values for segment duration.', 'refs' => [ 'CmafGroupSettings$ManifestDurationFormat' => 'Indicates whether the output manifest should use floating point values for segment duration.', ], ], 'CmafMpdProfile' => [ 'base' => 'Specify whether your DASH profile is on-demand or main. When you choose Main profile (MAIN_PROFILE), the service signals urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand (ON_DEMAND_PROFILE), the service signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose On-demand, you must also set the output group setting Segment control (SegmentControl) to Single file (SINGLE_FILE).', 'refs' => [ 'CmafGroupSettings$MpdProfile' => 'Specify whether your DASH profile is on-demand or main. When you choose Main profile (MAIN_PROFILE), the service signals urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand (ON_DEMAND_PROFILE), the service signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose On-demand, you must also set the output group setting Segment control (SegmentControl) to Single file (SINGLE_FILE).', ], ], 'CmafSegmentControl' => [ 'base' => 'When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the Fragment Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.', 'refs' => [ 'CmafGroupSettings$SegmentControl' => 'When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the Fragment Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.', ], ], 'CmafStreamInfResolution' => [ 'base' => 'Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.', 'refs' => [ 'CmafGroupSettings$StreamInfResolution' => 'Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.', ], ], 'CmafWriteDASHManifest' => [ 'base' => 'When set to ENABLED, a DASH MPD manifest will be generated for this output.', 'refs' => [ 'CmafGroupSettings$WriteDashManifest' => 'When set to ENABLED, a DASH MPD manifest will be generated for this output.', ], ], 'CmafWriteHLSManifest' => [ 'base' => 'When set to ENABLED, an Apple HLS manifest will be generated for this output.', 'refs' => [ 'CmafGroupSettings$WriteHlsManifest' => 'When set to ENABLED, an Apple HLS manifest will be generated for this output.', ], ], 'CmafWriteSegmentTimelineInRepresentation' => [ 'base' => 'When you enable Precise segment duration in DASH manifests (writeSegmentTimelineInRepresentation), your DASH manifest shows precise segment durations. The segment duration information appears inside the SegmentTimeline element, inside SegmentTemplate at the Representation level. When this feature isn\'t enabled, the segment durations in your DASH manifest are approximate. The segment duration information appears in the duration attribute of the SegmentTemplate element.', 'refs' => [ 'CmafGroupSettings$WriteSegmentTimelineInRepresentation' => 'When you enable Precise segment duration in DASH manifests (writeSegmentTimelineInRepresentation), your DASH manifest shows precise segment durations. The segment duration information appears inside the SegmentTimeline element, inside SegmentTemplate at the Representation level. When this feature isn\'t enabled, the segment durations in your DASH manifest are approximate. The segment duration information appears in the duration attribute of the SegmentTemplate element.', ], ], 'CmfcScte35Esam' => [ 'base' => 'Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers in this output at the insertion points that you specify in an ESAM XML document. Provide the document in the setting SCC XML (sccXml).', 'refs' => [ 'CmfcSettings$Scte35Esam' => 'Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers in this output at the insertion points that you specify in an ESAM XML document. Provide the document in the setting SCC XML (sccXml).', ], ], 'CmfcScte35Source' => [ 'base' => 'Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output. Choose None (NONE) if you don\'t want those SCTE-35 markers in this output.', 'refs' => [ 'CmfcSettings$Scte35Source' => 'Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output. Choose None (NONE) if you don\'t want those SCTE-35 markers in this output.', ], ], 'CmfcSettings' => [ 'base' => 'Settings for MP4 segments in CMAF', 'refs' => [ 'ContainerSettings$CmfcSettings' => 'Settings for MP4 segments in CMAF', ], ], 'ColorCorrector' => [ 'base' => 'Settings for color correction.', 'refs' => [ 'VideoPreprocessor$ColorCorrector' => 'Enable the Color corrector (ColorCorrector) feature if necessary. Enable or disable this feature for each output individually. This setting is disabled by default.', ], ], 'ColorMetadata' => [ 'base' => 'Choose Insert (INSERT) for this setting to include color metadata in this output. Choose Ignore (IGNORE) to exclude color metadata from this output. If you don\'t specify a value, the service sets this to Insert by default.', 'refs' => [ 'VideoDescription$ColorMetadata' => 'Choose Insert (INSERT) for this setting to include color metadata in this output. Choose Ignore (IGNORE) to exclude color metadata from this output. If you don\'t specify a value, the service sets this to Insert by default.', ], ], 'ColorSpace' => [ 'base' => 'If your input video has accurate color space metadata, or if you don\'t know about color space, leave this set to the default value Follow (FOLLOW). The service will automatically detect your input color space. If your input video has metadata indicating the wrong color space, specify the accurate color space here. If your input video is HDR 10 and the SMPTE ST 2086 Mastering Display Color Volume static metadata isn\'t present in your video stream, or if that metadata is present but not accurate, choose Force HDR 10 (FORCE_HDR10) here and specify correct values in the input HDR 10 metadata (Hdr10Metadata) settings. For more information about MediaConvert HDR jobs, see https://docs.aws.amazon.com/console/mediaconvert/hdr.', 'refs' => [ 'VideoSelector$ColorSpace' => 'If your input video has accurate color space metadata, or if you don\'t know about color space, leave this set to the default value Follow (FOLLOW). The service will automatically detect your input color space. If your input video has metadata indicating the wrong color space, specify the accurate color space here. If your input video is HDR 10 and the SMPTE ST 2086 Mastering Display Color Volume static metadata isn\'t present in your video stream, or if that metadata is present but not accurate, choose Force HDR 10 (FORCE_HDR10) here and specify correct values in the input HDR 10 metadata (Hdr10Metadata) settings. For more information about MediaConvert HDR jobs, see https://docs.aws.amazon.com/console/mediaconvert/hdr.', ], ], 'ColorSpaceConversion' => [ 'base' => 'Specify the color space you want for this output. The service supports conversion between HDR formats, between SDR formats, from SDR to HDR, and from HDR to SDR. SDR to HDR conversion doesn\'t upgrade the dynamic range. The converted video has an HDR format, but visually appears the same as an unconverted output. HDR to SDR conversion uses Elemental tone mapping technology to approximate the outcome of manually regrading from HDR to SDR.', 'refs' => [ 'ColorCorrector$ColorSpaceConversion' => 'Specify the color space you want for this output. The service supports conversion between HDR formats, between SDR formats, from SDR to HDR, and from HDR to SDR. SDR to HDR conversion doesn\'t upgrade the dynamic range. The converted video has an HDR format, but visually appears the same as an unconverted output. HDR to SDR conversion uses Elemental tone mapping technology to approximate the outcome of manually regrading from HDR to SDR.', ], ], 'ColorSpaceUsage' => [ 'base' => 'There are two sources for color metadata, the input file and the job input settings Color space (ColorSpace) and HDR master display information settings(Hdr10Metadata). The Color space usage setting determines which takes precedence. Choose Force (FORCE) to use color metadata from the input job settings. If you don\'t specify values for those settings, the service defaults to using metadata from your input. FALLBACK - Choose Fallback (FALLBACK) to use color metadata from the source when it is present. If there\'s no color metadata in your input file, the service defaults to using values you specify in the input settings.', 'refs' => [ 'VideoSelector$ColorSpaceUsage' => 'There are two sources for color metadata, the input file and the job input settings Color space (ColorSpace) and HDR master display information settings(Hdr10Metadata). The Color space usage setting determines which takes precedence. Choose Force (FORCE) to use color metadata from the input job settings. If you don\'t specify values for those settings, the service defaults to using metadata from your input. FALLBACK - Choose Fallback (FALLBACK) to use color metadata from the source when it is present. If there\'s no color metadata in your input file, the service defaults to using values you specify in the input settings.', ], ], 'Commitment' => [ 'base' => 'The length of the term of your reserved queue pricing plan commitment.', 'refs' => [ 'ReservationPlan$Commitment' => 'The length of the term of your reserved queue pricing plan commitment.', 'ReservationPlanSettings$Commitment' => 'The length of the term of your reserved queue pricing plan commitment.', ], ], 'ConflictException' => [ 'base' => NULL, 'refs' => [], ], 'ContainerSettings' => [ 'base' => 'Container specific settings.', 'refs' => [ 'Output$ContainerSettings' => 'Container specific settings.', 'PresetSettings$ContainerSettings' => 'Container specific settings.', ], ], 'ContainerType' => [ 'base' => 'Container for this output. Some containers require a container settings object. If not specified, the default object will be created.', 'refs' => [ 'ContainerSettings$Container' => 'Container for this output. Some containers require a container settings object. If not specified, the default object will be created.', ], ], 'CreateJobRequest' => [ 'base' => 'Send your create job request with your job settings and IAM role. Optionally, include user metadata and the ARN for the queue.', 'refs' => [], ], 'CreateJobResponse' => [ 'base' => 'Successful create job requests will return the job JSON.', 'refs' => [], ], 'CreateJobTemplateRequest' => [ 'base' => 'Send your create job template request with the name of the template and the JSON for the template. The template JSON should include everything in a valid job, except for input location and filename, IAM role, and user metadata.', 'refs' => [], ], 'CreateJobTemplateResponse' => [ 'base' => 'Successful create job template requests will return the template JSON.', 'refs' => [], ], 'CreatePresetRequest' => [ 'base' => 'Send your create preset request with the name of the preset and the JSON for the output settings specified by the preset.', 'refs' => [], ], 'CreatePresetResponse' => [ 'base' => 'Successful create preset requests will return the preset JSON.', 'refs' => [], ], 'CreateQueueRequest' => [ 'base' => 'Create an on-demand queue by sending a CreateQueue request with the name of the queue. Create a reserved queue by sending a CreateQueue request with the pricing plan set to RESERVED and with values specified for the settings under reservationPlanSettings. When you create a reserved queue, you enter into a 12-month commitment to purchase the RTS that you specify. You can\'t cancel this commitment.', 'refs' => [], ], 'CreateQueueResponse' => [ 'base' => 'Successful create queue requests return the name of the queue that you just created and information about it.', 'refs' => [], ], 'DashAdditionalManifest' => [ 'base' => 'Specify the details for each additional DASH manifest that you want the service to generate for this output group. Each manifest can reference a different subset of outputs in the group.', 'refs' => [ '__listOfDashAdditionalManifest$member' => NULL, ], ], 'DashIsoEncryptionSettings' => [ 'base' => 'Specifies DRM settings for DASH outputs.', 'refs' => [ 'DashIsoGroupSettings$Encryption' => 'DRM settings.', ], ], 'DashIsoGroupSettings' => [ 'base' => 'Required when you set (Type) under (OutputGroups)>(OutputGroupSettings) to DASH_ISO_GROUP_SETTINGS.', 'refs' => [ 'OutputGroupSettings$DashIsoGroupSettings' => 'Required when you set (Type) under (OutputGroups)>(OutputGroupSettings) to DASH_ISO_GROUP_SETTINGS.', ], ], 'DashIsoHbbtvCompliance' => [ 'base' => 'Supports HbbTV specification as indicated', 'refs' => [ 'DashIsoGroupSettings$HbbtvCompliance' => 'Supports HbbTV specification as indicated', ], ], 'DashIsoMpdProfile' => [ 'base' => 'Specify whether your DASH profile is on-demand or main. When you choose Main profile (MAIN_PROFILE), the service signals urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand (ON_DEMAND_PROFILE), the service signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose On-demand, you must also set the output group setting Segment control (SegmentControl) to Single file (SINGLE_FILE).', 'refs' => [ 'DashIsoGroupSettings$MpdProfile' => 'Specify whether your DASH profile is on-demand or main. When you choose Main profile (MAIN_PROFILE), the service signals urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand (ON_DEMAND_PROFILE), the service signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose On-demand, you must also set the output group setting Segment control (SegmentControl) to Single file (SINGLE_FILE).', ], ], 'DashIsoPlaybackDeviceCompatibility' => [ 'base' => 'This setting can improve the compatibility of your output with video players on obsolete devices. It applies only to DASH H.264 outputs with DRM encryption. Choose Unencrypted SEI (UNENCRYPTED_SEI) only to correct problems with playback on older devices. Otherwise, keep the default setting CENC v1 (CENC_V1). If you choose Unencrypted SEI, for that output, the service will exclude the access unit delimiter and will leave the SEI NAL units unencrypted.', 'refs' => [ 'DashIsoEncryptionSettings$PlaybackDeviceCompatibility' => 'This setting can improve the compatibility of your output with video players on obsolete devices. It applies only to DASH H.264 outputs with DRM encryption. Choose Unencrypted SEI (UNENCRYPTED_SEI) only to correct problems with playback on older devices. Otherwise, keep the default setting CENC v1 (CENC_V1). If you choose Unencrypted SEI, for that output, the service will exclude the access unit delimiter and will leave the SEI NAL units unencrypted.', ], ], 'DashIsoSegmentControl' => [ 'base' => 'When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the Fragment Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.', 'refs' => [ 'DashIsoGroupSettings$SegmentControl' => 'When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the Fragment Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.', ], ], 'DashIsoWriteSegmentTimelineInRepresentation' => [ 'base' => 'When you enable Precise segment duration in manifests (writeSegmentTimelineInRepresentation), your DASH manifest shows precise segment durations. The segment duration information appears inside the SegmentTimeline element, inside SegmentTemplate at the Representation level. When this feature isn\'t enabled, the segment durations in your DASH manifest are approximate. The segment duration information appears in the duration attribute of the SegmentTemplate element.', 'refs' => [ 'DashIsoGroupSettings$WriteSegmentTimelineInRepresentation' => 'If you get an HTTP error in the 400 range when you play back your DASH output, enable this setting and run your transcoding job again. When you enable this setting, the service writes precise segment durations in the DASH manifest. The segment duration information appears inside the SegmentTimeline element, inside SegmentTemplate at the Representation level. When you don\'t enable this setting, the service writes approximate segment durations in your DASH manifest.', ], ], 'DecryptionMode' => [ 'base' => 'Specify the encryption mode that you used to encrypt your input files.', 'refs' => [ 'InputDecryptionSettings$DecryptionMode' => 'Specify the encryption mode that you used to encrypt your input files.', ], ], 'DeinterlaceAlgorithm' => [ 'base' => 'Only applies when you set Deinterlacer (DeinterlaceMode) to Deinterlace (DEINTERLACE) or Adaptive (ADAPTIVE). Motion adaptive interpolate (INTERPOLATE) produces sharper pictures, while blend (BLEND) produces smoother motion. Use (INTERPOLATE_TICKER) OR (BLEND_TICKER) if your source file includes a ticker, such as a scrolling headline at the bottom of the frame.', 'refs' => [ 'Deinterlacer$Algorithm' => 'Only applies when you set Deinterlacer (DeinterlaceMode) to Deinterlace (DEINTERLACE) or Adaptive (ADAPTIVE). Motion adaptive interpolate (INTERPOLATE) produces sharper pictures, while blend (BLEND) produces smoother motion. Use (INTERPOLATE_TICKER) OR (BLEND_TICKER) if your source file includes a ticker, such as a scrolling headline at the bottom of the frame.', ], ], 'Deinterlacer' => [ 'base' => 'Settings for deinterlacer', 'refs' => [ 'VideoPreprocessor$Deinterlacer' => 'Use Deinterlacer (Deinterlacer) to produce smoother motion and a clearer picture.', ], ], 'DeinterlacerControl' => [ 'base' => '- When set to NORMAL (default), the deinterlacer does not convert frames that are tagged in metadata as progressive. It will only convert those that are tagged as some other type. - When set to FORCE_ALL_FRAMES, the deinterlacer converts every frame to progressive - even those that are already tagged as progressive. Turn Force mode on only if there is a good chance that the metadata has tagged frames as progressive when they are not progressive. Do not turn on otherwise; processing frames that are already progressive into progressive will probably result in lower quality video.', 'refs' => [ 'Deinterlacer$Control' => '- When set to NORMAL (default), the deinterlacer does not convert frames that are tagged in metadata as progressive. It will only convert those that are tagged as some other type. - When set to FORCE_ALL_FRAMES, the deinterlacer converts every frame to progressive - even those that are already tagged as progressive. Turn Force mode on only if there is a good chance that the metadata has tagged frames as progressive when they are not progressive. Do not turn on otherwise; processing frames that are already progressive into progressive will probably result in lower quality video.', ], ], 'DeinterlacerMode' => [ 'base' => 'Use Deinterlacer (DeinterlaceMode) to choose how the service will do deinterlacing. Default is Deinterlace. - Deinterlace converts interlaced to progressive. - Inverse telecine converts Hard Telecine 29.97i to progressive 23.976p. - Adaptive auto-detects and converts to progressive.', 'refs' => [ 'Deinterlacer$Mode' => 'Use Deinterlacer (DeinterlaceMode) to choose how the service will do deinterlacing. Default is Deinterlace. - Deinterlace converts interlaced to progressive. - Inverse telecine converts Hard Telecine 29.97i to progressive 23.976p. - Adaptive auto-detects and converts to progressive.', ], ], 'DeleteJobTemplateRequest' => [ 'base' => 'Delete a job template by sending a request with the job template name', 'refs' => [], ], 'DeleteJobTemplateResponse' => [ 'base' => 'Delete job template requests will return an OK message or error message with an empty body.', 'refs' => [], ], 'DeletePresetRequest' => [ 'base' => 'Delete a preset by sending a request with the preset name', 'refs' => [], ], 'DeletePresetResponse' => [ 'base' => 'Delete preset requests will return an OK message or error message with an empty body.', 'refs' => [], ], 'DeleteQueueRequest' => [ 'base' => 'Delete a queue by sending a request with the queue name. You can\'t delete a queue with an active pricing plan or one that has unprocessed jobs in it.', 'refs' => [], ], 'DeleteQueueResponse' => [ 'base' => 'Delete queue requests return an OK message or error message with an empty body.', 'refs' => [], ], 'DescribeEndpointsMode' => [ 'base' => 'Optional field, defaults to DEFAULT. Specify DEFAULT for this operation to return your endpoints if any exist, or to create an endpoint for you and return it if one doesn\'t already exist. Specify GET_ONLY to return your endpoints if any exist, or an empty list if none exist.', 'refs' => [ 'DescribeEndpointsRequest$Mode' => 'Optional field, defaults to DEFAULT. Specify DEFAULT for this operation to return your endpoints if any exist, or to create an endpoint for you and return it if one doesn\'t already exist. Specify GET_ONLY to return your endpoints if any exist, or an empty list if none exist.', ], ], 'DescribeEndpointsRequest' => [ 'base' => 'Send an request with an empty body to the regional API endpoint to get your account API endpoint.', 'refs' => [], ], 'DescribeEndpointsResponse' => [ 'base' => 'Successful describe endpoints requests will return your account API endpoint.', 'refs' => [], ], 'DestinationSettings' => [ 'base' => 'Settings associated with the destination. Will vary based on the type of destination', 'refs' => [ 'CmafGroupSettings$DestinationSettings' => 'Settings associated with the destination. Will vary based on the type of destination', 'DashIsoGroupSettings$DestinationSettings' => 'Settings associated with the destination. Will vary based on the type of destination', 'FileGroupSettings$DestinationSettings' => 'Settings associated with the destination. Will vary based on the type of destination', 'HlsGroupSettings$DestinationSettings' => 'Settings associated with the destination. Will vary based on the type of destination', 'MsSmoothGroupSettings$DestinationSettings' => 'Settings associated with the destination. Will vary based on the type of destination', ], ], 'DisassociateCertificateRequest' => [ 'base' => 'Removes an association between the Amazon Resource Name (ARN) of an AWS Certificate Manager (ACM) certificate and an AWS Elemental MediaConvert resource.', 'refs' => [], ], 'DisassociateCertificateResponse' => [ 'base' => 'Successful disassociation of Certificate Manager Amazon Resource Name (ARN) with Mediaconvert returns an OK message.', 'refs' => [], ], 'DolbyVision' => [ 'base' => 'Settings for Dolby Vision', 'refs' => [ 'VideoPreprocessor$DolbyVision' => 'Enable Dolby Vision feature to produce Dolby Vision compatible video output.', ], ], 'DolbyVisionLevel6Metadata' => [ 'base' => 'Use these settings when you set DolbyVisionLevel6Mode to SPECIFY to override the MaxCLL and MaxFALL values in your input with new values.', 'refs' => [ 'DolbyVision$L6Metadata' => 'Use these settings when you set DolbyVisionLevel6Mode to SPECIFY to override the MaxCLL and MaxFALL values in your input with new values.', ], ], 'DolbyVisionLevel6Mode' => [ 'base' => 'Use Dolby Vision Mode to choose how the service will handle Dolby Vision MaxCLL and MaxFALL properies.', 'refs' => [ 'DolbyVision$L6Mode' => 'Use Dolby Vision Mode to choose how the service will handle Dolby Vision MaxCLL and MaxFALL properies.', ], ], 'DolbyVisionProfile' => [ 'base' => 'In the current MediaConvert implementation, the Dolby Vision profile is always 5 (PROFILE_5). Therefore, all of your inputs must contain Dolby Vision frame interleaved data.', 'refs' => [ 'DolbyVision$Profile' => 'In the current MediaConvert implementation, the Dolby Vision profile is always 5 (PROFILE_5). Therefore, all of your inputs must contain Dolby Vision frame interleaved data.', ], ], 'DropFrameTimecode' => [ 'base' => 'Applies only to 29.97 fps outputs. When this feature is enabled, the service will use drop-frame timecode on outputs. If it is not possible to use drop-frame timecode, the system will fall back to non-drop-frame. This setting is enabled by default when Timecode insertion (TimecodeInsertion) is enabled.', 'refs' => [ 'VideoDescription$DropFrameTimecode' => 'Applies only to 29.97 fps outputs. When this feature is enabled, the service will use drop-frame timecode on outputs. If it is not possible to use drop-frame timecode, the system will fall back to non-drop-frame. This setting is enabled by default when Timecode insertion (TimecodeInsertion) is enabled.', ], ], 'DvbNitSettings' => [ 'base' => 'Inserts DVB Network Information Table (NIT) at the specified table repetition interval.', 'refs' => [ 'M2tsSettings$DvbNitSettings' => 'Inserts DVB Network Information Table (NIT) at the specified table repetition interval.', ], ], 'DvbSdtSettings' => [ 'base' => 'Inserts DVB Service Description Table (NIT) at the specified table repetition interval.', 'refs' => [ 'M2tsSettings$DvbSdtSettings' => 'Inserts DVB Service Description Table (NIT) at the specified table repetition interval.', ], ], 'DvbSubDestinationSettings' => [ 'base' => 'DVB-Sub Destination Settings', 'refs' => [ 'CaptionDestinationSettings$DvbSubDestinationSettings' => 'DVB-Sub Destination Settings', ], ], 'DvbSubSourceSettings' => [ 'base' => 'DVB Sub Source Settings', 'refs' => [ 'CaptionSourceSettings$DvbSubSourceSettings' => 'DVB Sub Source Settings', ], ], 'DvbSubtitleAlignment' => [ 'base' => 'If no explicit x_position or y_position is provided, setting alignment to centered will place the captions at the bottom center of the output. Similarly, setting a left alignment will align captions to the bottom left of the output. If x and y positions are given in conjunction with the alignment parameter, the font will be justified (either left or centered) relative to those coordinates. This option is not valid for source captions that are STL, 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.', 'refs' => [ 'DvbSubDestinationSettings$Alignment' => 'If no explicit x_position or y_position is provided, setting alignment to centered will place the captions at the bottom center of the output. Similarly, setting a left alignment will align captions to the bottom left of the output. If x and y positions are given in conjunction with the alignment parameter, the font will be justified (either left or centered) relative to those coordinates. This option is not valid for source captions that are STL, 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.', ], ], 'DvbSubtitleBackgroundColor' => [ 'base' => 'Specifies the color of the rectangle behind the captions.All burn-in and DVB-Sub font settings must match.', 'refs' => [ 'DvbSubDestinationSettings$BackgroundColor' => 'Specifies the color of the rectangle behind the captions.All burn-in and DVB-Sub font settings must match.', ], ], 'DvbSubtitleFontColor' => [ 'base' => 'Specifies the color of the burned-in captions. This option is not valid for source captions that are STL, 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.', 'refs' => [ 'DvbSubDestinationSettings$FontColor' => 'Specifies the color of the burned-in captions. This option is not valid for source captions that are STL, 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.', ], ], 'DvbSubtitleOutlineColor' => [ 'base' => 'Specifies font outline color. This option is not valid for source captions that are either 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.', 'refs' => [ 'DvbSubDestinationSettings$OutlineColor' => 'Specifies font outline color. This option is not valid for source captions that are either 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.', ], ], 'DvbSubtitleShadowColor' => [ 'base' => 'Specifies the color of the shadow cast by the captions.All burn-in and DVB-Sub font settings must match.', 'refs' => [ 'DvbSubDestinationSettings$ShadowColor' => 'Specifies the color of the shadow cast by the captions.All burn-in and DVB-Sub font settings must match.', ], ], 'DvbSubtitleTeletextSpacing' => [ 'base' => 'Only applies to jobs with input captions in Teletext or STL formats. Specify whether the spacing between letters in your captions is set by the captions grid or varies depending on letter width. Choose fixed grid to conform to the spacing specified in the captions file more accurately. Choose proportional to make the text easier to read if the captions are closed caption.', 'refs' => [ 'DvbSubDestinationSettings$TeletextSpacing' => 'Only applies to jobs with input captions in Teletext or STL formats. Specify whether the spacing between letters in your captions is set by the captions grid or varies depending on letter width. Choose fixed grid to conform to the spacing specified in the captions file more accurately. Choose proportional to make the text easier to read if the captions are closed caption.', ], ], 'DvbSubtitlingType' => [ 'base' => 'Specify whether your DVB subtitles are standard or for hearing impaired. Choose hearing impaired if your subtitles include audio descriptions and dialogue. Choose standard if your subtitles include only dialogue.', 'refs' => [ 'DvbSubDestinationSettings$SubtitlingType' => 'Specify whether your DVB subtitles are standard or for hearing impaired. Choose hearing impaired if your subtitles include audio descriptions and dialogue. Choose standard if your subtitles include only dialogue.', ], ], 'DvbTdtSettings' => [ 'base' => 'Inserts DVB Time and Date Table (TDT) at the specified table repetition interval.', 'refs' => [ 'M2tsSettings$DvbTdtSettings' => 'Inserts DVB Time and Date Table (TDT) at the specified table repetition interval.', ], ], 'Eac3AtmosBitstreamMode' => [ 'base' => 'Specify the bitstream mode for the E-AC-3 stream that the encoder emits. For more information about the EAC3 bitstream mode, see ATSC A/52-2012 (Annex E).', 'refs' => [ 'Eac3AtmosSettings$BitstreamMode' => 'Specify the bitstream mode for the E-AC-3 stream that the encoder emits. For more information about the EAC3 bitstream mode, see ATSC A/52-2012 (Annex E).', ], ], 'Eac3AtmosCodingMode' => [ 'base' => 'The coding mode for Dolby Digital Plus JOC (Atmos) is always 9.1.6 (CODING_MODE_9_1_6).', 'refs' => [ 'Eac3AtmosSettings$CodingMode' => 'The coding mode for Dolby Digital Plus JOC (Atmos) is always 9.1.6 (CODING_MODE_9_1_6).', ], ], 'Eac3AtmosDialogueIntelligence' => [ 'base' => 'Enable Dolby Dialogue Intelligence to adjust loudness based on dialogue analysis.', 'refs' => [ 'Eac3AtmosSettings$DialogueIntelligence' => 'Enable Dolby Dialogue Intelligence to adjust loudness based on dialogue analysis.', ], ], 'Eac3AtmosDynamicRangeCompressionLine' => [ 'base' => 'Specify the absolute peak level for a signal with dynamic range compression.', 'refs' => [ 'Eac3AtmosSettings$DynamicRangeCompressionLine' => 'Specify the absolute peak level for a signal with dynamic range compression.', ], ], 'Eac3AtmosDynamicRangeCompressionRf' => [ 'base' => 'Specify how the service limits the audio dynamic range when compressing the audio.', 'refs' => [ 'Eac3AtmosSettings$DynamicRangeCompressionRf' => 'Specify how the service limits the audio dynamic range when compressing the audio.', ], ], 'Eac3AtmosMeteringMode' => [ 'base' => 'Choose how the service meters the loudness of your audio.', 'refs' => [ 'Eac3AtmosSettings$MeteringMode' => 'Choose how the service meters the loudness of your audio.', ], ], 'Eac3AtmosSettings' => [ 'base' => 'Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value EAC3_ATMOS.', 'refs' => [ 'AudioCodecSettings$Eac3AtmosSettings' => 'Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value EAC3_ATMOS.', ], ], 'Eac3AtmosStereoDownmix' => [ 'base' => 'Choose how the service does stereo downmixing.', 'refs' => [ 'Eac3AtmosSettings$StereoDownmix' => 'Choose how the service does stereo downmixing.', ], ], 'Eac3AtmosSurroundExMode' => [ 'base' => 'Specify whether your input audio has an additional center rear surround channel matrix encoded into your left and right surround channels.', 'refs' => [ 'Eac3AtmosSettings$SurroundExMode' => 'Specify whether your input audio has an additional center rear surround channel matrix encoded into your left and right surround channels.', ], ], 'Eac3AttenuationControl' => [ 'base' => 'If set to ATTENUATE_3_DB, applies a 3 dB attenuation to the surround channels. Only used for 3/2 coding mode.', 'refs' => [ 'Eac3Settings$AttenuationControl' => 'If set to ATTENUATE_3_DB, applies a 3 dB attenuation to the surround channels. Only used for 3/2 coding mode.', ], ], 'Eac3BitstreamMode' => [ 'base' => 'Specify the bitstream mode for the E-AC-3 stream that the encoder emits. For more information about the EAC3 bitstream mode, see ATSC A/52-2012 (Annex E).', 'refs' => [ 'Eac3Settings$BitstreamMode' => 'Specify the bitstream mode for the E-AC-3 stream that the encoder emits. For more information about the EAC3 bitstream mode, see ATSC A/52-2012 (Annex E).', ], ], 'Eac3CodingMode' => [ 'base' => 'Dolby Digital Plus coding mode. Determines number of channels.', 'refs' => [ 'Eac3Settings$CodingMode' => 'Dolby Digital Plus coding mode. Determines number of channels.', ], ], 'Eac3DcFilter' => [ 'base' => 'Activates a DC highpass filter for all input channels.', 'refs' => [ 'Eac3Settings$DcFilter' => 'Activates a DC highpass filter for all input channels.', ], ], 'Eac3DynamicRangeCompressionLine' => [ 'base' => 'Specify the absolute peak level for a signal with dynamic range compression.', 'refs' => [ 'Eac3Settings$DynamicRangeCompressionLine' => 'Specify the absolute peak level for a signal with dynamic range compression.', ], ], 'Eac3DynamicRangeCompressionRf' => [ 'base' => 'Specify how the service limits the audio dynamic range when compressing the audio.', 'refs' => [ 'Eac3Settings$DynamicRangeCompressionRf' => 'Specify how the service limits the audio dynamic range when compressing the audio.', ], ], 'Eac3LfeControl' => [ 'base' => 'When encoding 3/2 audio, controls whether the LFE channel is enabled', 'refs' => [ 'Eac3Settings$LfeControl' => 'When encoding 3/2 audio, controls whether the LFE channel is enabled', ], ], 'Eac3LfeFilter' => [ 'base' => 'Applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with 3_2_LFE coding mode.', 'refs' => [ 'Eac3Settings$LfeFilter' => 'Applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with 3_2_LFE coding mode.', ], ], 'Eac3MetadataControl' => [ 'base' => 'When set to FOLLOW_INPUT, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that supplied this audio data. If audio was not supplied from one of these streams, then the static metadata settings will be used.', 'refs' => [ 'Eac3Settings$MetadataControl' => 'When set to FOLLOW_INPUT, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that supplied this audio data. If audio was not supplied from one of these streams, then the static metadata settings will be used.', ], ], 'Eac3PassthroughControl' => [ 'base' => 'When set to WHEN_POSSIBLE, input DD+ audio will be passed through if it is present on the input. this detection is dynamic over the life of the transcode. Inputs that alternate between DD+ and non-DD+ content will have a consistent DD+ output as the system alternates between passthrough and encoding.', 'refs' => [ 'Eac3Settings$PassthroughControl' => 'When set to WHEN_POSSIBLE, input DD+ audio will be passed through if it is present on the input. this detection is dynamic over the life of the transcode. Inputs that alternate between DD+ and non-DD+ content will have a consistent DD+ output as the system alternates between passthrough and encoding.', ], ], 'Eac3PhaseControl' => [ 'base' => 'Controls the amount of phase-shift applied to the surround channels. Only used for 3/2 coding mode.', 'refs' => [ 'Eac3Settings$PhaseControl' => 'Controls the amount of phase-shift applied to the surround channels. Only used for 3/2 coding mode.', ], ], 'Eac3Settings' => [ 'base' => 'Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value EAC3.', 'refs' => [ 'AudioCodecSettings$Eac3Settings' => 'Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value EAC3.', ], ], 'Eac3StereoDownmix' => [ 'base' => 'Choose how the service does stereo downmixing. This setting only applies if you keep the default value of 3/2 - L, R, C, Ls, Rs (CODING_MODE_3_2) for the setting Coding mode (Eac3CodingMode). If you choose a different value for Coding mode, the service ignores Stereo downmix (Eac3StereoDownmix).', 'refs' => [ 'Eac3Settings$StereoDownmix' => 'Choose how the service does stereo downmixing. This setting only applies if you keep the default value of 3/2 - L, R, C, Ls, Rs (CODING_MODE_3_2) for the setting Coding mode (Eac3CodingMode). If you choose a different value for Coding mode, the service ignores Stereo downmix (Eac3StereoDownmix).', ], ], 'Eac3SurroundExMode' => [ 'base' => 'When encoding 3/2 audio, sets whether an extra center back surround channel is matrix encoded into the left and right surround channels.', 'refs' => [ 'Eac3Settings$SurroundExMode' => 'When encoding 3/2 audio, sets whether an extra center back surround channel is matrix encoded into the left and right surround channels.', ], ], 'Eac3SurroundMode' => [ 'base' => 'When encoding 2/0 audio, sets whether Dolby Surround is matrix encoded into the two channels.', 'refs' => [ 'Eac3Settings$SurroundMode' => 'When encoding 2/0 audio, sets whether Dolby Surround is matrix encoded into the two channels.', ], ], 'EmbeddedConvert608To708' => [ 'base' => 'Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you choose Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608 data through using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data into 708.', 'refs' => [ 'EmbeddedSourceSettings$Convert608To708' => 'Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you choose Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608 data through using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data into 708.', ], ], 'EmbeddedDestinationSettings' => [ 'base' => 'Settings specific to embedded/ancillary caption outputs, including 608/708 Channel destination number.', 'refs' => [ 'CaptionDestinationSettings$EmbeddedDestinationSettings' => 'Settings specific to embedded/ancillary caption outputs, including 608/708 Channel destination number.', ], ], 'EmbeddedSourceSettings' => [ 'base' => 'Settings for embedded captions Source', 'refs' => [ 'CaptionSourceSettings$EmbeddedSourceSettings' => 'Settings for embedded captions Source', ], ], 'EmbeddedTerminateCaptions' => [ 'base' => 'By default, the service terminates any unterminated captions at the end of each input. If you want the caption to continue onto your next input, disable this setting.', 'refs' => [ 'EmbeddedSourceSettings$TerminateCaptions' => 'By default, the service terminates any unterminated captions at the end of each input. If you want the caption to continue onto your next input, disable this setting.', ], ], 'Endpoint' => [ 'base' => 'Describes an account-specific API endpoint.', 'refs' => [ '__listOfEndpoint$member' => NULL, ], ], 'EsamManifestConfirmConditionNotification' => [ 'base' => 'ESAM ManifestConfirmConditionNotification defined by OC-SP-ESAM-API-I03-131025.', 'refs' => [ 'EsamSettings$ManifestConfirmConditionNotification' => 'Specifies an ESAM ManifestConfirmConditionNotification XML as per OC-SP-ESAM-API-I03-131025. The transcoder uses the manifest conditioning instructions that you provide in the setting MCC XML (mccXml).', ], ], 'EsamSettings' => [ 'base' => 'Settings for Event Signaling And Messaging (ESAM). If you don\'t do ad insertion, you can ignore these settings.', 'refs' => [ 'JobSettings$Esam' => 'Settings for Event Signaling And Messaging (ESAM).', 'JobTemplateSettings$Esam' => 'Settings for Event Signaling And Messaging (ESAM).', ], ], 'EsamSignalProcessingNotification' => [ 'base' => 'ESAM SignalProcessingNotification data defined by OC-SP-ESAM-API-I03-131025.', 'refs' => [ 'EsamSettings$SignalProcessingNotification' => 'Specifies an ESAM SignalProcessingNotification XML as per OC-SP-ESAM-API-I03-131025. The transcoder uses the signal processing instructions that you provide in the setting SCC XML (sccXml).', ], ], 'ExceptionBody' => [ 'base' => NULL, 'refs' => [], ], 'F4vMoovPlacement' => [ 'base' => 'If set to PROGRESSIVE_DOWNLOAD, the MOOV atom is relocated to the beginning of the archive as required for progressive downloading. Otherwise it is placed normally at the end.', 'refs' => [ 'F4vSettings$MoovPlacement' => 'If set to PROGRESSIVE_DOWNLOAD, the MOOV atom is relocated to the beginning of the archive as required for progressive downloading. Otherwise it is placed normally at the end.', ], ], 'F4vSettings' => [ 'base' => 'Settings for F4v container', 'refs' => [ 'ContainerSettings$F4vSettings' => 'Settings for F4v container', ], ], 'FileGroupSettings' => [ 'base' => 'Required when you set (Type) under (OutputGroups)>(OutputGroupSettings) to FILE_GROUP_SETTINGS.', 'refs' => [ 'OutputGroupSettings$FileGroupSettings' => 'Required when you set (Type) under (OutputGroups)>(OutputGroupSettings) to FILE_GROUP_SETTINGS.', ], ], 'FileSourceConvert608To708' => [ 'base' => 'Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you choose Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608 data through using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data into 708.', 'refs' => [ 'FileSourceSettings$Convert608To708' => 'Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you choose Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608 data through using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data into 708.', ], ], 'FileSourceSettings' => [ 'base' => 'If your input captions are SCC, SMI, SRT, STL, TTML, or IMSC 1.1 in an xml file, specify the URI of the input caption source file. If your caption source is IMSC in an IMF package, use TrackSourceSettings instead of FileSoureSettings.', 'refs' => [ 'CaptionSourceSettings$FileSourceSettings' => 'If your input captions are SCC, SMI, SRT, STL, TTML, or IMSC 1.1 in an xml file, specify the URI of the input caption source file. If your caption source is IMSC in an IMF package, use TrackSourceSettings instead of FileSoureSettings.', ], ], 'FontScript' => [ 'base' => 'Provide the font script, using an ISO 15924 script code, if the LanguageCode is not sufficient for determining the script type. Where LanguageCode or CustomLanguageCode is sufficient, use "AUTOMATIC" or leave unset.', 'refs' => [ 'BurninDestinationSettings$FontScript' => 'Provide the font script, using an ISO 15924 script code, if the LanguageCode is not sufficient for determining the script type. Where LanguageCode or CustomLanguageCode is sufficient, use "AUTOMATIC" or leave unset. This is used to help determine the appropriate font for rendering burn-in captions.', 'DvbSubDestinationSettings$FontScript' => 'Provide the font script, using an ISO 15924 script code, if the LanguageCode is not sufficient for determining the script type. Where LanguageCode or CustomLanguageCode is sufficient, use "AUTOMATIC" or leave unset. This is used to help determine the appropriate font for rendering DVB-Sub captions.', ], ], 'ForbiddenException' => [ 'base' => NULL, 'refs' => [], ], 'FrameCaptureSettings' => [ 'base' => 'Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value FRAME_CAPTURE.', 'refs' => [ 'VideoCodecSettings$FrameCaptureSettings' => 'Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value FRAME_CAPTURE.', ], ], 'GetJobRequest' => [ 'base' => 'Query a job by sending a request with the job ID.', 'refs' => [], ], 'GetJobResponse' => [ 'base' => 'Successful get job requests will return an OK message and the job JSON.', 'refs' => [], ], 'GetJobTemplateRequest' => [ 'base' => 'Query a job template by sending a request with the job template name.', 'refs' => [], ], 'GetJobTemplateResponse' => [ 'base' => 'Successful get job template requests will return an OK message and the job template JSON.', 'refs' => [], ], 'GetPresetRequest' => [ 'base' => 'Query a preset by sending a request with the preset name.', 'refs' => [], ], 'GetPresetResponse' => [ 'base' => 'Successful get preset requests will return an OK message and the preset JSON.', 'refs' => [], ], 'GetQueueRequest' => [ 'base' => 'Get information about a queue by sending a request with the queue name.', 'refs' => [], ], 'GetQueueResponse' => [ 'base' => 'Successful get queue requests return an OK message and information about the queue in JSON.', 'refs' => [], ], 'H264AdaptiveQuantization' => [ 'base' => 'Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.', 'refs' => [ 'H264Settings$AdaptiveQuantization' => 'Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.', ], ], 'H264CodecLevel' => [ 'base' => 'Specify an H.264 level that is consistent with your output video settings. If you aren\'t sure what level to specify, choose Auto (AUTO).', 'refs' => [ 'H264Settings$CodecLevel' => 'Specify an H.264 level that is consistent with your output video settings. If you aren\'t sure what level to specify, choose Auto (AUTO).', ], ], 'H264CodecProfile' => [ 'base' => 'H.264 Profile. High 4:2:2 and 10-bit profiles are only available with the AVC-I License.', 'refs' => [ 'H264Settings$CodecProfile' => 'H.264 Profile. High 4:2:2 and 10-bit profiles are only available with the AVC-I License.', ], ], 'H264DynamicSubGop' => [ 'base' => 'Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).', 'refs' => [ 'H264Settings$DynamicSubGop' => 'Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).', ], ], 'H264EntropyEncoding' => [ 'base' => 'Entropy encoding mode. Use CABAC (must be in Main or High profile) or CAVLC.', 'refs' => [ 'H264Settings$EntropyEncoding' => 'Entropy encoding mode. Use CABAC (must be in Main or High profile) or CAVLC.', ], ], 'H264FieldEncoding' => [ 'base' => 'Choosing FORCE_FIELD disables PAFF encoding for interlaced outputs.', 'refs' => [ 'H264Settings$FieldEncoding' => 'Choosing FORCE_FIELD disables PAFF encoding for interlaced outputs.', ], ], 'H264FlickerAdaptiveQuantization' => [ 'base' => 'Adjust quantization within each frame to reduce flicker or \'pop\' on I-frames.', 'refs' => [ 'H264Settings$FlickerAdaptiveQuantization' => 'Adjust quantization within each frame to reduce flicker or \'pop\' on I-frames.', ], ], 'H264FramerateControl' => [ 'base' => 'If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.', 'refs' => [ 'H264Settings$FramerateControl' => 'If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.', ], ], 'H264FramerateConversionAlgorithm' => [ 'base' => 'Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use duplicate drop conversion.', 'refs' => [ 'H264Settings$FramerateConversionAlgorithm' => 'Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use duplicate drop conversion.', ], ], 'H264GopBReference' => [ 'base' => 'If enable, use reference B frames for GOP structures that have B frames > 1.', 'refs' => [ 'H264Settings$GopBReference' => 'If enable, use reference B frames for GOP structures that have B frames > 1.', ], ], 'H264GopSizeUnits' => [ 'base' => 'Indicates if the GOP Size in H264 is specified in frames or seconds. If seconds the system will convert the GOP Size into a frame count at run time.', 'refs' => [ 'H264Settings$GopSizeUnits' => 'Indicates if the GOP Size in H264 is specified in frames or seconds. If seconds the system will convert the GOP Size into a frame count at run time.', ], ], 'H264InterlaceMode' => [ 'base' => 'Use Interlace mode (InterlaceMode) to choose the scan line type for the output. * Top Field First (TOP_FIELD) and Bottom Field First (BOTTOM_FIELD) produce interlaced output with the entire output having the same field polarity (top or bottom first). * Follow, Default Top (FOLLOW_TOP_FIELD) and Follow, Default Bottom (FOLLOW_BOTTOM_FIELD) use the same field polarity as the source. Therefore, behavior depends on the input scan type, as follows. - If the source is interlaced, the output will be interlaced with the same polarity as the source (it will follow the source). The output could therefore be a mix of "top field first" and "bottom field first". - If the source is progressive, the output will be interlaced with "top field first" or "bottom field first" polarity, depending on which of the Follow options you chose.', 'refs' => [ 'H264Settings$InterlaceMode' => 'Use Interlace mode (InterlaceMode) to choose the scan line type for the output. * Top Field First (TOP_FIELD) and Bottom Field First (BOTTOM_FIELD) produce interlaced output with the entire output having the same field polarity (top or bottom first). * Follow, Default Top (FOLLOW_TOP_FIELD) and Follow, Default Bottom (FOLLOW_BOTTOM_FIELD) use the same field polarity as the source. Therefore, behavior depends on the input scan type, as follows. - If the source is interlaced, the output will be interlaced with the same polarity as the source (it will follow the source). The output could therefore be a mix of "top field first" and "bottom field first". - If the source is progressive, the output will be interlaced with "top field first" or "bottom field first" polarity, depending on which of the Follow options you chose.', ], ], 'H264ParControl' => [ 'base' => 'Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.', 'refs' => [ 'H264Settings$ParControl' => 'Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.', ], ], 'H264QualityTuningLevel' => [ 'base' => 'Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.', 'refs' => [ 'H264Settings$QualityTuningLevel' => 'Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.', ], ], 'H264QvbrSettings' => [ 'base' => 'Settings for quality-defined variable bitrate encoding with the H.264 codec. Required when you set Rate control mode to QVBR. Not valid when you set Rate control mode to a value other than QVBR, or when you don\'t define Rate control mode.', 'refs' => [ 'H264Settings$QvbrSettings' => 'Settings for quality-defined variable bitrate encoding with the H.264 codec. Required when you set Rate control mode to QVBR. Not valid when you set Rate control mode to a value other than QVBR, or when you don\'t define Rate control mode.', ], ], 'H264RateControlMode' => [ 'base' => 'Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or quality-defined variable bitrate (QVBR).', 'refs' => [ 'H264Settings$RateControlMode' => 'Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or quality-defined variable bitrate (QVBR).', ], ], 'H264RepeatPps' => [ 'base' => 'Places a PPS header on each encoded picture, even if repeated.', 'refs' => [ 'H264Settings$RepeatPps' => 'Places a PPS header on each encoded picture, even if repeated.', ], ], 'H264SceneChangeDetect' => [ 'base' => 'Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves video quality and is enabled by default. If this output uses QVBR, choose Transition detection (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.', 'refs' => [ 'H264Settings$SceneChangeDetect' => 'Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves video quality and is enabled by default. If this output uses QVBR, choose Transition detection (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.', ], ], 'H264Settings' => [ 'base' => 'Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value H_264.', 'refs' => [ 'VideoCodecSettings$H264Settings' => 'Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value H_264.', ], ], 'H264SlowPal' => [ 'base' => 'Enables Slow PAL rate conversion. 23.976fps and 24fps input is relabeled as 25fps, and audio is sped up correspondingly.', 'refs' => [ 'H264Settings$SlowPal' => 'Enables Slow PAL rate conversion. 23.976fps and 24fps input is relabeled as 25fps, and audio is sped up correspondingly.', ], ], 'H264SpatialAdaptiveQuantization' => [ 'base' => 'Adjust quantization within each frame based on spatial variation of content complexity.', 'refs' => [ 'H264Settings$SpatialAdaptiveQuantization' => 'Adjust quantization within each frame based on spatial variation of content complexity.', ], ], 'H264Syntax' => [ 'base' => 'Produces a bitstream compliant with SMPTE RP-2027.', 'refs' => [ 'H264Settings$Syntax' => 'Produces a bitstream compliant with SMPTE RP-2027.', ], ], 'H264Telecine' => [ 'base' => 'This field applies only if the Streams > Advanced > Framerate (framerate) field is set to 29.970. This field works with the Streams > Advanced > Preprocessors > Deinterlacer field (deinterlace_mode) and the Streams > Advanced > Interlaced Mode field (interlace_mode) to identify the scan type for the output: Progressive, Interlaced, Hard Telecine or Soft Telecine. - Hard: produces 29.97i output from 23.976 input. - Soft: produces 23.976; the player converts this output to 29.97i.', 'refs' => [ 'H264Settings$Telecine' => 'This field applies only if the Streams > Advanced > Framerate (framerate) field is set to 29.970. This field works with the Streams > Advanced > Preprocessors > Deinterlacer field (deinterlace_mode) and the Streams > Advanced > Interlaced Mode field (interlace_mode) to identify the scan type for the output: Progressive, Interlaced, Hard Telecine or Soft Telecine. - Hard: produces 29.97i output from 23.976 input. - Soft: produces 23.976; the player converts this output to 29.97i.', ], ], 'H264TemporalAdaptiveQuantization' => [ 'base' => 'Adjust quantization within each frame based on temporal variation of content complexity.', 'refs' => [ 'H264Settings$TemporalAdaptiveQuantization' => 'Adjust quantization within each frame based on temporal variation of content complexity.', ], ], 'H264UnregisteredSeiTimecode' => [ 'base' => 'Inserts timecode for each frame as 4 bytes of an unregistered SEI message.', 'refs' => [ 'H264Settings$UnregisteredSeiTimecode' => 'Inserts timecode for each frame as 4 bytes of an unregistered SEI message.', ], ], 'H265AdaptiveQuantization' => [ 'base' => 'Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.', 'refs' => [ 'H265Settings$AdaptiveQuantization' => 'Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.', ], ], 'H265AlternateTransferFunctionSei' => [ 'base' => 'Enables Alternate Transfer Function SEI message for outputs using Hybrid Log Gamma (HLG) Electro-Optical Transfer Function (EOTF).', 'refs' => [ 'H265Settings$AlternateTransferFunctionSei' => 'Enables Alternate Transfer Function SEI message for outputs using Hybrid Log Gamma (HLG) Electro-Optical Transfer Function (EOTF).', ], ], 'H265CodecLevel' => [ 'base' => 'H.265 Level.', 'refs' => [ 'H265Settings$CodecLevel' => 'H.265 Level.', ], ], 'H265CodecProfile' => [ 'base' => 'Represents the Profile and Tier, per the HEVC (H.265) specification. Selections are grouped as [Profile] / [Tier], so "Main/High" represents Main Profile with High Tier. 4:2:2 profiles are only available with the HEVC 4:2:2 License.', 'refs' => [ 'H265Settings$CodecProfile' => 'Represents the Profile and Tier, per the HEVC (H.265) specification. Selections are grouped as [Profile] / [Tier], so "Main/High" represents Main Profile with High Tier. 4:2:2 profiles are only available with the HEVC 4:2:2 License.', ], ], 'H265DynamicSubGop' => [ 'base' => 'Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).', 'refs' => [ 'H265Settings$DynamicSubGop' => 'Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).', ], ], 'H265FlickerAdaptiveQuantization' => [ 'base' => 'Adjust quantization within each frame to reduce flicker or \'pop\' on I-frames.', 'refs' => [ 'H265Settings$FlickerAdaptiveQuantization' => 'Adjust quantization within each frame to reduce flicker or \'pop\' on I-frames.', ], ], 'H265FramerateControl' => [ 'base' => 'If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.', 'refs' => [ 'H265Settings$FramerateControl' => 'If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.', ], ], 'H265FramerateConversionAlgorithm' => [ 'base' => 'Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use duplicate drop conversion.', 'refs' => [ 'H265Settings$FramerateConversionAlgorithm' => 'Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use duplicate drop conversion.', ], ], 'H265GopBReference' => [ 'base' => 'If enable, use reference B frames for GOP structures that have B frames > 1.', 'refs' => [ 'H265Settings$GopBReference' => 'If enable, use reference B frames for GOP structures that have B frames > 1.', ], ], 'H265GopSizeUnits' => [ 'base' => 'Indicates if the GOP Size in H265 is specified in frames or seconds. If seconds the system will convert the GOP Size into a frame count at run time.', 'refs' => [ 'H265Settings$GopSizeUnits' => 'Indicates if the GOP Size in H265 is specified in frames or seconds. If seconds the system will convert the GOP Size into a frame count at run time.', ], ], 'H265InterlaceMode' => [ 'base' => 'Choose the scan line type for the output. Choose Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Choose Top Field First (TOP_FIELD) or Bottom Field First (BOTTOM_FIELD) to create an output that\'s interlaced with the same field polarity throughout. Choose Follow, Default Top (FOLLOW_TOP_FIELD) or Follow, Default Bottom (FOLLOW_BOTTOM_FIELD) to create an interlaced output with the same field polarity as the source. If the source is interlaced, the output will be interlaced with the same polarity as the source (it will follow the source). The output could therefore be a mix of "top field first" and "bottom field first". If the source is progressive, your output will be interlaced with "top field first" or "bottom field first" polarity, depending on which of the Follow options you chose. If you don\'t choose a value, the service will default to Progressive (PROGRESSIVE).', 'refs' => [ 'H265Settings$InterlaceMode' => 'Choose the scan line type for the output. Choose Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Choose Top Field First (TOP_FIELD) or Bottom Field First (BOTTOM_FIELD) to create an output that\'s interlaced with the same field polarity throughout. Choose Follow, Default Top (FOLLOW_TOP_FIELD) or Follow, Default Bottom (FOLLOW_BOTTOM_FIELD) to create an interlaced output with the same field polarity as the source. If the source is interlaced, the output will be interlaced with the same polarity as the source (it will follow the source). The output could therefore be a mix of "top field first" and "bottom field first". If the source is progressive, your output will be interlaced with "top field first" or "bottom field first" polarity, depending on which of the Follow options you chose. If you don\'t choose a value, the service will default to Progressive (PROGRESSIVE).', ], ], 'H265ParControl' => [ 'base' => 'Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.', 'refs' => [ 'H265Settings$ParControl' => 'Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.', ], ], 'H265QualityTuningLevel' => [ 'base' => 'Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.', 'refs' => [ 'H265Settings$QualityTuningLevel' => 'Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.', ], ], 'H265QvbrSettings' => [ 'base' => 'Settings for quality-defined variable bitrate encoding with the H.265 codec. Required when you set Rate control mode to QVBR. Not valid when you set Rate control mode to a value other than QVBR, or when you don\'t define Rate control mode.', 'refs' => [ 'H265Settings$QvbrSettings' => 'Settings for quality-defined variable bitrate encoding with the H.265 codec. Required when you set Rate control mode to QVBR. Not valid when you set Rate control mode to a value other than QVBR, or when you don\'t define Rate control mode.', ], ], 'H265RateControlMode' => [ 'base' => 'Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or quality-defined variable bitrate (QVBR).', 'refs' => [ 'H265Settings$RateControlMode' => 'Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or quality-defined variable bitrate (QVBR).', ], ], 'H265SampleAdaptiveOffsetFilterMode' => [ 'base' => 'Specify Sample Adaptive Offset (SAO) filter strength. Adaptive mode dynamically selects best strength based on content', 'refs' => [ 'H265Settings$SampleAdaptiveOffsetFilterMode' => 'Specify Sample Adaptive Offset (SAO) filter strength. Adaptive mode dynamically selects best strength based on content', ], ], 'H265SceneChangeDetect' => [ 'base' => 'Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves video quality and is enabled by default. If this output uses QVBR, choose Transition detection (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.', 'refs' => [ 'H265Settings$SceneChangeDetect' => 'Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves video quality and is enabled by default. If this output uses QVBR, choose Transition detection (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.', ], ], 'H265Settings' => [ 'base' => 'Settings for H265 codec', 'refs' => [ 'VideoCodecSettings$H265Settings' => 'Settings for H265 codec', ], ], 'H265SlowPal' => [ 'base' => 'Enables Slow PAL rate conversion. 23.976fps and 24fps input is relabeled as 25fps, and audio is sped up correspondingly.', 'refs' => [ 'H265Settings$SlowPal' => 'Enables Slow PAL rate conversion. 23.976fps and 24fps input is relabeled as 25fps, and audio is sped up correspondingly.', ], ], 'H265SpatialAdaptiveQuantization' => [ 'base' => 'Adjust quantization within each frame based on spatial variation of content complexity.', 'refs' => [ 'H265Settings$SpatialAdaptiveQuantization' => 'Adjust quantization within each frame based on spatial variation of content complexity.', ], ], 'H265Telecine' => [ 'base' => 'This field applies only if the Streams > Advanced > Framerate (framerate) field is set to 29.970. This field works with the Streams > Advanced > Preprocessors > Deinterlacer field (deinterlace_mode) and the Streams > Advanced > Interlaced Mode field (interlace_mode) to identify the scan type for the output: Progressive, Interlaced, Hard Telecine or Soft Telecine. - Hard: produces 29.97i output from 23.976 input. - Soft: produces 23.976; the player converts this output to 29.97i.', 'refs' => [ 'H265Settings$Telecine' => 'This field applies only if the Streams > Advanced > Framerate (framerate) field is set to 29.970. This field works with the Streams > Advanced > Preprocessors > Deinterlacer field (deinterlace_mode) and the Streams > Advanced > Interlaced Mode field (interlace_mode) to identify the scan type for the output: Progressive, Interlaced, Hard Telecine or Soft Telecine. - Hard: produces 29.97i output from 23.976 input. - Soft: produces 23.976; the player converts this output to 29.97i.', ], ], 'H265TemporalAdaptiveQuantization' => [ 'base' => 'Adjust quantization within each frame based on temporal variation of content complexity.', 'refs' => [ 'H265Settings$TemporalAdaptiveQuantization' => 'Adjust quantization within each frame based on temporal variation of content complexity.', ], ], 'H265TemporalIds' => [ 'base' => 'Enables temporal layer identifiers in the encoded bitstream. Up to 3 layers are supported depending on GOP structure: I- and P-frames form one layer, reference B-frames can form a second layer and non-reference b-frames can form a third layer. Decoders can optionally decode only the lower temporal layers to generate a lower frame rate output. For example, given a bitstream with temporal IDs and with b-frames = 1 (i.e. IbPbPb display order), a decoder could decode all the frames for full frame rate output or only the I and P frames (lowest temporal layer) for a half frame rate output.', 'refs' => [ 'H265Settings$TemporalIds' => 'Enables temporal layer identifiers in the encoded bitstream. Up to 3 layers are supported depending on GOP structure: I- and P-frames form one layer, reference B-frames can form a second layer and non-reference b-frames can form a third layer. Decoders can optionally decode only the lower temporal layers to generate a lower frame rate output. For example, given a bitstream with temporal IDs and with b-frames = 1 (i.e. IbPbPb display order), a decoder could decode all the frames for full frame rate output or only the I and P frames (lowest temporal layer) for a half frame rate output.', ], ], 'H265Tiles' => [ 'base' => 'Enable use of tiles, allowing horizontal as well as vertical subdivision of the encoded pictures.', 'refs' => [ 'H265Settings$Tiles' => 'Enable use of tiles, allowing horizontal as well as vertical subdivision of the encoded pictures.', ], ], 'H265UnregisteredSeiTimecode' => [ 'base' => 'Inserts timecode for each frame as 4 bytes of an unregistered SEI message.', 'refs' => [ 'H265Settings$UnregisteredSeiTimecode' => 'Inserts timecode for each frame as 4 bytes of an unregistered SEI message.', ], ], 'H265WriteMp4PackagingType' => [ 'base' => 'If the location of parameter set NAL units doesn\'t matter in your workflow, ignore this setting. Use this setting only with CMAF or DASH outputs, or with standalone file outputs in an MPEG-4 container (MP4 outputs). Choose HVC1 to mark your output as HVC1. This makes your output compliant with the following specification: ISO IECJTC1 SC29 N13798 Text ISO/IEC FDIS 14496-15 3rd Edition. For these outputs, the service stores parameter set NAL units in the sample headers but not in the samples directly. For MP4 outputs, when you choose HVC1, your output video might not work properly with some downstream systems and video players. The service defaults to marking your output as HEV1. For these outputs, the service writes parameter set NAL units directly into the samples.', 'refs' => [ 'H265Settings$WriteMp4PackagingType' => 'If the location of parameter set NAL units doesn\'t matter in your workflow, ignore this setting. Use this setting only with CMAF or DASH outputs, or with standalone file outputs in an MPEG-4 container (MP4 outputs). Choose HVC1 to mark your output as HVC1. This makes your output compliant with the following specification: ISO IECJTC1 SC29 N13798 Text ISO/IEC FDIS 14496-15 3rd Edition. For these outputs, the service stores parameter set NAL units in the sample headers but not in the samples directly. For MP4 outputs, when you choose HVC1, your output video might not work properly with some downstream systems and video players. The service defaults to marking your output as HEV1. For these outputs, the service writes parameter set NAL units directly into the samples.', ], ], 'Hdr10Metadata' => [ 'base' => 'Use these settings to specify static color calibration metadata, as defined by SMPTE ST 2086. These values don\'t affect the pixel values that are encoded in the video stream. They are intended to help the downstream video player display content in a way that reflects the intentions of the the content creator.', 'refs' => [ 'ColorCorrector$Hdr10Metadata' => 'Use these settings when you convert to the HDR 10 color space. Specify the SMPTE ST 2086 Mastering Display Color Volume static metadata that you want signaled in the output. These values don\'t affect the pixel values that are encoded in the video stream. They are intended to help the downstream video player display content in a way that reflects the intentions of the the content creator. When you set Color space conversion (ColorSpaceConversion) to HDR 10 (FORCE_HDR10), these settings are required. You must set values for Max frame average light level (maxFrameAverageLightLevel) and Max content light level (maxContentLightLevel); these settings don\'t have a default value. The default values for the other HDR 10 metadata settings are defined by the P3D65 color space. For more information about MediaConvert HDR jobs, see https://docs.aws.amazon.com/console/mediaconvert/hdr.', 'VideoSelector$Hdr10Metadata' => 'Use these settings to provide HDR 10 metadata that is missing or inaccurate in your input video. Appropriate values vary depending on the input video and must be provided by a color grader. The color grader generates these values during the HDR 10 mastering process. The valid range for each of these settings is 0 to 50,000. Each increment represents 0.00002 in CIE1931 color coordinate. Related settings - When you specify these values, you must also set Color space (ColorSpace) to HDR 10 (HDR10). To specify whether the the values you specify here take precedence over the values in the metadata of your input file, set Color space usage (ColorSpaceUsage). To specify whether color metadata is included in an output, set Color metadata (ColorMetadata). For more information about MediaConvert HDR jobs, see https://docs.aws.amazon.com/console/mediaconvert/hdr.', ], ], 'HlsAdMarkers' => [ 'base' => NULL, 'refs' => [ '__listOfHlsAdMarkers$member' => NULL, ], ], 'HlsAdditionalManifest' => [ 'base' => 'Specify the details for each additional HLS manifest that you want the service to generate for this output group. Each manifest can reference a different subset of outputs in the group.', 'refs' => [ '__listOfHlsAdditionalManifest$member' => NULL, ], ], 'HlsAudioOnlyContainer' => [ 'base' => 'Use this setting only in audio-only outputs. Choose MPEG-2 Transport Stream (M2TS) to create a file in an MPEG2-TS container. Keep the default value Automatic (AUTOMATIC) to create a raw audio-only file with no container. Regardless of the value that you specify here, if this output has video, the service will place outputs into an MPEG2-TS container.', 'refs' => [ 'HlsSettings$AudioOnlyContainer' => 'Use this setting only in audio-only outputs. Choose MPEG-2 Transport Stream (M2TS) to create a file in an MPEG2-TS container. Keep the default value Automatic (AUTOMATIC) to create an audio-only file in a raw container. Regardless of the value that you specify here, if this output has video, the service will place the output into an MPEG2-TS container.', ], ], 'HlsAudioTrackType' => [ 'base' => 'Four types of audio-only tracks are supported: Audio-Only Variant Stream The client can play back this audio-only stream instead of video in low-bandwidth scenarios. Represented as an EXT-X-STREAM-INF in the HLS manifest. Alternate Audio, Auto Select, Default Alternate rendition that the client should try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES, AUTOSELECT=YES Alternate Audio, Auto Select, Not Default Alternate rendition that the client may try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YES Alternate Audio, not Auto Select Alternate rendition that the client will not try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=NO', 'refs' => [ 'HlsSettings$AudioTrackType' => 'Four types of audio-only tracks are supported: Audio-Only Variant Stream The client can play back this audio-only stream instead of video in low-bandwidth scenarios. Represented as an EXT-X-STREAM-INF in the HLS manifest. Alternate Audio, Auto Select, Default Alternate rendition that the client should try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES, AUTOSELECT=YES Alternate Audio, Auto Select, Not Default Alternate rendition that the client may try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YES Alternate Audio, not Auto Select Alternate rendition that the client will not try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=NO', ], ], 'HlsCaptionLanguageMapping' => [ 'base' => 'Caption Language Mapping', 'refs' => [ '__listOfHlsCaptionLanguageMapping$member' => NULL, ], ], 'HlsCaptionLanguageSetting' => [ 'base' => 'Applies only to 608 Embedded output captions. Insert: Include CLOSED-CAPTIONS lines in the manifest. Specify at least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for each Language Code you specify. Make sure to specify the languages in the order in which they appear in the original source (if the source is embedded format) or the order of the caption selectors (if the source is other than embedded). Otherwise, languages in the manifest will not match up properly with the output captions. None: Include CLOSED-CAPTIONS=NONE line in the manifest. Omit: Omit any CLOSED-CAPTIONS line from the manifest.', 'refs' => [ 'HlsGroupSettings$CaptionLanguageSetting' => 'Applies only to 608 Embedded output captions. Insert: Include CLOSED-CAPTIONS lines in the manifest. Specify at least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for each Language Code you specify. Make sure to specify the languages in the order in which they appear in the original source (if the source is embedded format) or the order of the caption selectors (if the source is other than embedded). Otherwise, languages in the manifest will not match up properly with the output captions. None: Include CLOSED-CAPTIONS=NONE line in the manifest. Omit: Omit any CLOSED-CAPTIONS line from the manifest.', ], ], 'HlsClientCache' => [ 'base' => 'When set to ENABLED, sets #EXT-X-ALLOW-CACHE:no tag, which prevents client from saving media segments for later replay.', 'refs' => [ 'HlsGroupSettings$ClientCache' => 'When set to ENABLED, sets #EXT-X-ALLOW-CACHE:no tag, which prevents client from saving media segments for later replay.', ], ], 'HlsCodecSpecification' => [ 'base' => 'Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.', 'refs' => [ 'HlsGroupSettings$CodecSpecification' => 'Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.', ], ], 'HlsDirectoryStructure' => [ 'base' => 'Indicates whether segments should be placed in subdirectories.', 'refs' => [ 'HlsGroupSettings$DirectoryStructure' => 'Indicates whether segments should be placed in subdirectories.', ], ], 'HlsEncryptionSettings' => [ 'base' => 'Settings for HLS encryption', 'refs' => [ 'HlsGroupSettings$Encryption' => 'DRM settings.', ], ], 'HlsEncryptionType' => [ 'base' => 'Encrypts the segments with the given encryption scheme. Leave blank to disable. Selecting \'Disabled\' in the web interface also disables encryption.', 'refs' => [ 'HlsEncryptionSettings$EncryptionMethod' => 'Encrypts the segments with the given encryption scheme. Leave blank to disable. Selecting \'Disabled\' in the web interface also disables encryption.', ], ], 'HlsGroupSettings' => [ 'base' => 'Required when you set (Type) under (OutputGroups)>(OutputGroupSettings) to HLS_GROUP_SETTINGS.', 'refs' => [ 'OutputGroupSettings$HlsGroupSettings' => 'Required when you set (Type) under (OutputGroups)>(OutputGroupSettings) to HLS_GROUP_SETTINGS.', ], ], 'HlsIFrameOnlyManifest' => [ 'base' => 'When set to INCLUDE, writes I-Frame Only Manifest in addition to the HLS manifest', 'refs' => [ 'HlsSettings$IFrameOnlyManifest' => 'When set to INCLUDE, writes I-Frame Only Manifest in addition to the HLS manifest', ], ], 'HlsInitializationVectorInManifest' => [ 'base' => 'The Initialization Vector is a 128-bit number used in conjunction with the key for encrypting blocks. If set to INCLUDE, Initialization Vector is listed in the manifest. Otherwise Initialization Vector is not in the manifest.', 'refs' => [ 'HlsEncryptionSettings$InitializationVectorInManifest' => 'The Initialization Vector is a 128-bit number used in conjunction with the key for encrypting blocks. If set to INCLUDE, Initialization Vector is listed in the manifest. Otherwise Initialization Vector is not in the manifest.', ], ], 'HlsKeyProviderType' => [ 'base' => 'Specify whether your DRM encryption key is static or from a key provider that follows the SPEKE standard. For more information about SPEKE, see https://docs.aws.amazon.com/speke/latest/documentation/what-is-speke.html.', 'refs' => [ 'HlsEncryptionSettings$Type' => 'Specify whether your DRM encryption key is static or from a key provider that follows the SPEKE standard. For more information about SPEKE, see https://docs.aws.amazon.com/speke/latest/documentation/what-is-speke.html.', ], ], 'HlsManifestCompression' => [ 'base' => 'When set to GZIP, compresses HLS playlist.', 'refs' => [ 'HlsGroupSettings$ManifestCompression' => 'When set to GZIP, compresses HLS playlist.', ], ], 'HlsManifestDurationFormat' => [ 'base' => 'Indicates whether the output manifest should use floating point values for segment duration.', 'refs' => [ 'HlsGroupSettings$ManifestDurationFormat' => 'Indicates whether the output manifest should use floating point values for segment duration.', ], ], 'HlsOfflineEncrypted' => [ 'base' => 'Enable this setting to insert the EXT-X-SESSION-KEY element into the master playlist. This allows for offline Apple HLS FairPlay content protection.', 'refs' => [ 'HlsEncryptionSettings$OfflineEncrypted' => 'Enable this setting to insert the EXT-X-SESSION-KEY element into the master playlist. This allows for offline Apple HLS FairPlay content protection.', ], ], 'HlsOutputSelection' => [ 'base' => 'Indicates whether the .m3u8 manifest file should be generated for this HLS output group.', 'refs' => [ 'HlsGroupSettings$OutputSelection' => 'Indicates whether the .m3u8 manifest file should be generated for this HLS output group.', ], ], 'HlsProgramDateTime' => [ 'base' => 'Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as follows: either the program date and time are initialized using the input timecode source, or the time is initialized using the input timecode source and the date is initialized using the timestamp_offset.', 'refs' => [ 'HlsGroupSettings$ProgramDateTime' => 'Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as follows: either the program date and time are initialized using the input timecode source, or the time is initialized using the input timecode source and the date is initialized using the timestamp_offset.', ], ], 'HlsSegmentControl' => [ 'base' => 'When set to SINGLE_FILE, emits program as a single media resource (.ts) file, uses #EXT-X-BYTERANGE tags to index segment for playback.', 'refs' => [ 'HlsGroupSettings$SegmentControl' => 'When set to SINGLE_FILE, emits program as a single media resource (.ts) file, uses #EXT-X-BYTERANGE tags to index segment for playback.', ], ], 'HlsSettings' => [ 'base' => 'Settings for HLS output groups', 'refs' => [ 'OutputSettings$HlsSettings' => 'Settings for HLS output groups', ], ], 'HlsStreamInfResolution' => [ 'base' => 'Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.', 'refs' => [ 'HlsGroupSettings$StreamInfResolution' => 'Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.', ], ], 'HlsTimedMetadataId3Frame' => [ 'base' => 'Indicates ID3 frame that has the timecode.', 'refs' => [ 'HlsGroupSettings$TimedMetadataId3Frame' => 'Indicates ID3 frame that has the timecode.', ], ], 'HopDestination' => [ 'base' => 'Optional. Configuration for a destination queue to which the job can hop once a customer-defined minimum wait time has passed.', 'refs' => [ '__listOfHopDestination$member' => NULL, ], ], 'Id3Insertion' => [ 'base' => 'To insert ID3 tags in your output, specify two values. Use ID3 tag (Id3) to specify the base 64 encoded string and use Timecode (TimeCode) to specify the time when the tag should be inserted. To insert multiple ID3 tags in your output, create multiple instances of ID3 insertion (Id3Insertion).', 'refs' => [ '__listOfId3Insertion$member' => NULL, ], ], 'ImageInserter' => [ 'base' => 'Enable the image inserter feature to include a graphic overlay on your video. Enable or disable this feature for each input or output individually. This setting is disabled by default.', 'refs' => [ 'Input$ImageInserter' => 'Enable the image inserter feature to include a graphic overlay on your video. Enable or disable this feature for each input individually. This setting is disabled by default.', 'InputTemplate$ImageInserter' => 'Enable the image inserter feature to include a graphic overlay on your video. Enable or disable this feature for each input individually. This setting is disabled by default.', 'VideoPreprocessor$ImageInserter' => 'Enable the Image inserter (ImageInserter) feature to include a graphic overlay on your video. Enable or disable this feature for each output individually. This setting is disabled by default.', ], ], 'ImscDestinationSettings' => [ 'base' => 'Settings specific to IMSC caption outputs.', 'refs' => [ 'CaptionDestinationSettings$ImscDestinationSettings' => 'Settings specific to IMSC caption outputs.', ], ], 'ImscStylePassthrough' => [ 'base' => 'Keep this setting enabled to have MediaConvert use the font style and position information from the captions source in the output. This option is available only when your input captions are IMSC, SMPTE-TT, or TTML. Disable this setting for simplified output captions.', 'refs' => [ 'ImscDestinationSettings$StylePassthrough' => 'Keep this setting enabled to have MediaConvert use the font style and position information from the captions source in the output. This option is available only when your input captions are IMSC, SMPTE-TT, or TTML. Disable this setting for simplified output captions.', ], ], 'Input' => [ 'base' => 'Specifies media input', 'refs' => [ '__listOfInput$member' => NULL, ], ], 'InputClipping' => [ 'base' => 'To transcode only portions of your input (clips), include one Input clipping (one instance of InputClipping in the JSON job file) for each input clip. All input clips you specify will be included in every output of the job.', 'refs' => [ '__listOfInputClipping$member' => NULL, ], ], 'InputDeblockFilter' => [ 'base' => 'Enable Deblock (InputDeblockFilter) to produce smoother motion in the output. Default is disabled. Only manually controllable for MPEG2 and uncompressed video inputs.', 'refs' => [ 'Input$DeblockFilter' => 'Enable Deblock (InputDeblockFilter) to produce smoother motion in the output. Default is disabled. Only manually controllable for MPEG2 and uncompressed video inputs.', 'InputTemplate$DeblockFilter' => 'Enable Deblock (InputDeblockFilter) to produce smoother motion in the output. Default is disabled. Only manually controllable for MPEG2 and uncompressed video inputs.', ], ], 'InputDecryptionSettings' => [ 'base' => 'Settings for decrypting any input files that you encrypt before you upload them to Amazon S3. MediaConvert can decrypt files only when you use AWS Key Management Service (KMS) to encrypt the data key that you use to encrypt your content.', 'refs' => [ 'Input$DecryptionSettings' => 'Settings for decrypting any input files that you encrypt before you upload them to Amazon S3. MediaConvert can decrypt files only when you use AWS Key Management Service (KMS) to encrypt the data key that you use to encrypt your content.', ], ], 'InputDenoiseFilter' => [ 'base' => 'Enable Denoise (InputDenoiseFilter) to filter noise from the input. Default is disabled. Only applicable to MPEG2, H.264, H.265, and uncompressed video inputs.', 'refs' => [ 'Input$DenoiseFilter' => 'Enable Denoise (InputDenoiseFilter) to filter noise from the input. Default is disabled. Only applicable to MPEG2, H.264, H.265, and uncompressed video inputs.', 'InputTemplate$DenoiseFilter' => 'Enable Denoise (InputDenoiseFilter) to filter noise from the input. Default is disabled. Only applicable to MPEG2, H.264, H.265, and uncompressed video inputs.', ], ], 'InputFilterEnable' => [ 'base' => 'Use Filter enable (InputFilterEnable) to specify how the transcoding service applies the denoise and deblock filters. You must also enable the filters separately, with Denoise (InputDenoiseFilter) and Deblock (InputDeblockFilter). * Auto - The transcoding service determines whether to apply filtering, depending on input type and quality. * Disable - The input is not filtered. This is true even if you use the API to enable them in (InputDeblockFilter) and (InputDeblockFilter). * Force - The in put is filtered regardless of input type.', 'refs' => [ 'Input$FilterEnable' => 'Use Filter enable (InputFilterEnable) to specify how the transcoding service applies the denoise and deblock filters. You must also enable the filters separately, with Denoise (InputDenoiseFilter) and Deblock (InputDeblockFilter). * Auto - The transcoding service determines whether to apply filtering, depending on input type and quality. * Disable - The input is not filtered. This is true even if you use the API to enable them in (InputDeblockFilter) and (InputDeblockFilter). * Force - The in put is filtered regardless of input type.', 'InputTemplate$FilterEnable' => 'Use Filter enable (InputFilterEnable) to specify how the transcoding service applies the denoise and deblock filters. You must also enable the filters separately, with Denoise (InputDenoiseFilter) and Deblock (InputDeblockFilter). * Auto - The transcoding service determines whether to apply filtering, depending on input type and quality. * Disable - The input is not filtered. This is true even if you use the API to enable them in (InputDeblockFilter) and (InputDeblockFilter). * Force - The in put is filtered regardless of input type.', ], ], 'InputPsiControl' => [ 'base' => 'Set PSI control (InputPsiControl) for transport stream inputs to specify which data the demux process to scans. * Ignore PSI - Scan all PIDs for audio and video. * Use PSI - Scan only PSI data.', 'refs' => [ 'Input$PsiControl' => 'Set PSI control (InputPsiControl) for transport stream inputs to specify which data the demux process to scans. * Ignore PSI - Scan all PIDs for audio and video. * Use PSI - Scan only PSI data.', 'InputTemplate$PsiControl' => 'Set PSI control (InputPsiControl) for transport stream inputs to specify which data the demux process to scans. * Ignore PSI - Scan all PIDs for audio and video. * Use PSI - Scan only PSI data.', ], ], 'InputRotate' => [ 'base' => 'Use Rotate (InputRotate) to specify how the service rotates your video. You can choose automatic rotation or specify a rotation. You can specify a clockwise rotation of 0, 90, 180, or 270 degrees. If your input video container is .mov or .mp4 and your input has rotation metadata, you can choose Automatic to have the service rotate your video according to the rotation specified in the metadata. The rotation must be within one degree of 90, 180, or 270 degrees. If the rotation metadata specifies any other rotation, the service will default to no rotation. By default, the service does no rotation, even if your input video has rotation metadata. The service doesn\'t pass through rotation metadata.', 'refs' => [ 'VideoSelector$Rotate' => 'Use Rotate (InputRotate) to specify how the service rotates your video. You can choose automatic rotation or specify a rotation. You can specify a clockwise rotation of 0, 90, 180, or 270 degrees. If your input video container is .mov or .mp4 and your input has rotation metadata, you can choose Automatic to have the service rotate your video according to the rotation specified in the metadata. The rotation must be within one degree of 90, 180, or 270 degrees. If the rotation metadata specifies any other rotation, the service will default to no rotation. By default, the service does no rotation, even if your input video has rotation metadata. The service doesn\'t pass through rotation metadata.', ], ], 'InputTemplate' => [ 'base' => 'Specified video input in a template.', 'refs' => [ '__listOfInputTemplate$member' => NULL, ], ], 'InputTimecodeSource' => [ 'base' => 'Use this Timecode source setting, located under the input settings (InputTimecodeSource), to specify how the service counts input video frames. This input frame count affects only the behavior of features that apply to a single input at a time, such as input clipping and synchronizing some captions formats. Choose Embedded (EMBEDDED) to use the timecodes in your input video. Choose Start at zero (ZEROBASED) to start the first frame at zero. Choose Specified start (SPECIFIEDSTART) to start the first frame at the timecode that you specify in the setting Start timecode (timecodeStart). If you don\'t specify a value for Timecode source, the service will use Embedded by default. For more information about timecodes, see https://docs.aws.amazon.com/console/mediaconvert/timecode.', 'refs' => [ 'Input$TimecodeSource' => 'Use this Timecode source setting, located under the input settings (InputTimecodeSource), to specify how the service counts input video frames. This input frame count affects only the behavior of features that apply to a single input at a time, such as input clipping and synchronizing some captions formats. Choose Embedded (EMBEDDED) to use the timecodes in your input video. Choose Start at zero (ZEROBASED) to start the first frame at zero. Choose Specified start (SPECIFIEDSTART) to start the first frame at the timecode that you specify in the setting Start timecode (timecodeStart). If you don\'t specify a value for Timecode source, the service will use Embedded by default. For more information about timecodes, see https://docs.aws.amazon.com/console/mediaconvert/timecode.', 'InputTemplate$TimecodeSource' => 'Use this Timecode source setting, located under the input settings (InputTimecodeSource), to specify how the service counts input video frames. This input frame count affects only the behavior of features that apply to a single input at a time, such as input clipping and synchronizing some captions formats. Choose Embedded (EMBEDDED) to use the timecodes in your input video. Choose Start at zero (ZEROBASED) to start the first frame at zero. Choose Specified start (SPECIFIEDSTART) to start the first frame at the timecode that you specify in the setting Start timecode (timecodeStart). If you don\'t specify a value for Timecode source, the service will use Embedded by default. For more information about timecodes, see https://docs.aws.amazon.com/console/mediaconvert/timecode.', ], ], 'InsertableImage' => [ 'base' => 'Settings that specify how your still graphic overlay appears.', 'refs' => [ '__listOfInsertableImage$member' => NULL, ], ], 'InternalServerErrorException' => [ 'base' => NULL, 'refs' => [], ], 'Job' => [ 'base' => 'Each job converts an input file into an output file or files. For more information, see the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html', 'refs' => [ 'CreateJobResponse$Job' => 'Each job converts an input file into an output file or files. For more information, see the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html', 'GetJobResponse$Job' => 'Each job converts an input file into an output file or files. For more information, see the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html', '__listOfJob$member' => NULL, ], ], 'JobMessages' => [ 'base' => 'Provides messages from the service about jobs that you have already successfully submitted.', 'refs' => [ 'Job$Messages' => 'Provides messages from the service about jobs that you have already successfully submitted.', ], ], 'JobPhase' => [ 'base' => 'A job\'s phase can be PROBING, TRANSCODING OR UPLOADING', 'refs' => [ 'Job$CurrentPhase' => 'A job\'s phase can be PROBING, TRANSCODING OR UPLOADING', ], ], 'JobSettings' => [ 'base' => 'JobSettings contains all the transcode settings for a job.', 'refs' => [ 'CreateJobRequest$Settings' => 'JobSettings contains all the transcode settings for a job.', 'Job$Settings' => 'JobSettings contains all the transcode settings for a job.', ], ], 'JobStatus' => [ 'base' => 'A job\'s status can be SUBMITTED, PROGRESSING, COMPLETE, CANCELED, or ERROR.', 'refs' => [ 'Job$Status' => 'A job\'s status can be SUBMITTED, PROGRESSING, COMPLETE, CANCELED, or ERROR.', 'ListJobsRequest$Status' => 'Optional. A job\'s status can be SUBMITTED, PROGRESSING, COMPLETE, CANCELED, or ERROR.', ], ], 'JobTemplate' => [ 'base' => 'A job template is a pre-made set of encoding instructions that you can use to quickly create a job.', 'refs' => [ 'CreateJobTemplateResponse$JobTemplate' => 'A job template is a pre-made set of encoding instructions that you can use to quickly create a job.', 'GetJobTemplateResponse$JobTemplate' => 'A job template is a pre-made set of encoding instructions that you can use to quickly create a job.', 'UpdateJobTemplateResponse$JobTemplate' => 'A job template is a pre-made set of encoding instructions that you can use to quickly create a job.', '__listOfJobTemplate$member' => NULL, ], ], 'JobTemplateListBy' => [ 'base' => 'Optional. When you request a list of job templates, you can choose to list them alphabetically by NAME or chronologically by CREATION_DATE. If you don\'t specify, the service will list them by name.', 'refs' => [ 'ListJobTemplatesRequest$ListBy' => 'Optional. When you request a list of job templates, you can choose to list them alphabetically by NAME or chronologically by CREATION_DATE. If you don\'t specify, the service will list them by name.', ], ], 'JobTemplateSettings' => [ 'base' => 'JobTemplateSettings contains all the transcode settings saved in the template that will be applied to jobs created from it.', 'refs' => [ 'CreateJobTemplateRequest$Settings' => 'JobTemplateSettings contains all the transcode settings saved in the template that will be applied to jobs created from it.', 'JobTemplate$Settings' => 'JobTemplateSettings contains all the transcode settings saved in the template that will be applied to jobs created from it.', 'UpdateJobTemplateRequest$Settings' => 'JobTemplateSettings contains all the transcode settings saved in the template that will be applied to jobs created from it.', ], ], 'LanguageCode' => [ 'base' => 'Specify the language, using the ISO 639-2 three-letter code listed at https://www.loc.gov/standards/iso639-2/php/code_list.php.', 'refs' => [ 'AudioDescription$LanguageCode' => 'Indicates the language of the audio output track. The ISO 639 language specified in the \'Language Code\' drop down will be used when \'Follow Input Language Code\' is not selected or when \'Follow Input Language Code\' is selected but there is no ISO 639 language code specified by the input.', 'AudioSelector$LanguageCode' => 'Selects a specific language code from within an audio source.', 'CaptionDescription$LanguageCode' => 'Specify the language of this captions output track. For most captions output formats, the encoder puts this language information in the output captions metadata. If your output captions format is DVB-Sub or Burn in, the encoder uses this language information to choose the font language for rendering the captions text.', 'CaptionDescriptionPreset$LanguageCode' => 'Specify the language of this captions output track. For most captions output formats, the encoder puts this language information in the output captions metadata. If your output captions format is DVB-Sub or Burn in, the encoder uses this language information to choose the font language for rendering the captions text.', 'CaptionSelector$LanguageCode' => 'The specific language to extract from source. If input is SCTE-27, complete this field and/or PID to select the caption language to extract. If input is DVB-Sub and output is Burn-in or SMPTE-TT, complete this field and/or PID to select the caption language to extract. If input is DVB-Sub that is being passed through, omit this field (and PID field); there is no way to extract a specific language with pass-through captions.', 'HlsCaptionLanguageMapping$LanguageCode' => 'Specify the language, using the ISO 639-2 three-letter code listed at https://www.loc.gov/standards/iso639-2/php/code_list.php.', ], ], 'ListJobTemplatesRequest' => [ 'base' => 'You can send list job templates requests with an empty body. Optionally, you can filter the response by category by specifying it in your request body. You can also optionally specify the maximum number, up to twenty, of job templates to be returned.', 'refs' => [], ], 'ListJobTemplatesResponse' => [ 'base' => 'Successful list job templates requests return a JSON array of job templates. If you don\'t specify how they are ordered, you will receive them in alphabetical order by name.', 'refs' => [], ], 'ListJobsRequest' => [ 'base' => 'You can send list jobs requests with an empty body. Optionally, you can filter the response by queue and/or job status by specifying them in your request body. You can also optionally specify the maximum number, up to twenty, of jobs to be returned.', 'refs' => [], ], 'ListJobsResponse' => [ 'base' => 'Successful list jobs requests return a JSON array of jobs. If you don\'t specify how they are ordered, you will receive the most recently created first.', 'refs' => [], ], 'ListPresetsRequest' => [ 'base' => 'You can send list presets requests with an empty body. Optionally, you can filter the response by category by specifying it in your request body. You can also optionally specify the maximum number, up to twenty, of queues to be returned.', 'refs' => [], ], 'ListPresetsResponse' => [ 'base' => 'Successful list presets requests return a JSON array of presets. If you don\'t specify how they are ordered, you will receive them alphabetically by name.', 'refs' => [], ], 'ListQueuesRequest' => [ 'base' => 'You can send list queues requests with an empty body. You can optionally specify the maximum number, up to twenty, of queues to be returned.', 'refs' => [], ], 'ListQueuesResponse' => [ 'base' => 'Successful list queues requests return a JSON array of queues. If you don\'t specify how they are ordered, you will receive them alphabetically by name.', 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => 'List the tags for your AWS Elemental MediaConvert resource by sending a request with the Amazon Resource Name (ARN) of the resource. To get the ARN, send a GET request with the resource name.', 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => 'A successful request to list the tags for a resource returns a JSON map of tags.', 'refs' => [], ], 'M2tsAudioBufferModel' => [ 'base' => 'Selects between the DVB and ATSC buffer models for Dolby Digital audio.', 'refs' => [ 'M2tsSettings$AudioBufferModel' => 'Selects between the DVB and ATSC buffer models for Dolby Digital audio.', ], ], 'M2tsBufferModel' => [ 'base' => 'Controls what buffer model to use for accurate interleaving. If set to MULTIPLEX, use multiplex buffer model. If set to NONE, this can lead to lower latency, but low-memory devices may not be able to play back the stream without interruptions.', 'refs' => [ 'M2tsSettings$BufferModel' => 'Controls what buffer model to use for accurate interleaving. If set to MULTIPLEX, use multiplex buffer model. If set to NONE, this can lead to lower latency, but low-memory devices may not be able to play back the stream without interruptions.', ], ], 'M2tsEbpAudioInterval' => [ 'base' => 'When set to VIDEO_AND_FIXED_INTERVALS, audio EBP markers will be added to partitions 3 and 4. The interval between these additional markers will be fixed, and will be slightly shorter than the video EBP marker interval. When set to VIDEO_INTERVAL, these additional markers will not be inserted. Only applicable when EBP segmentation markers are is selected (segmentationMarkers is EBP or EBP_LEGACY).', 'refs' => [ 'M2tsSettings$EbpAudioInterval' => 'When set to VIDEO_AND_FIXED_INTERVALS, audio EBP markers will be added to partitions 3 and 4. The interval between these additional markers will be fixed, and will be slightly shorter than the video EBP marker interval. When set to VIDEO_INTERVAL, these additional markers will not be inserted. Only applicable when EBP segmentation markers are is selected (segmentationMarkers is EBP or EBP_LEGACY).', ], ], 'M2tsEbpPlacement' => [ 'base' => 'Selects which PIDs to place EBP markers on. They can either be placed only on the video PID, or on both the video PID and all audio PIDs. Only applicable when EBP segmentation markers are is selected (segmentationMarkers is EBP or EBP_LEGACY).', 'refs' => [ 'M2tsSettings$EbpPlacement' => 'Selects which PIDs to place EBP markers on. They can either be placed only on the video PID, or on both the video PID and all audio PIDs. Only applicable when EBP segmentation markers are is selected (segmentationMarkers is EBP or EBP_LEGACY).', ], ], 'M2tsEsRateInPes' => [ 'base' => 'Controls whether to include the ES Rate field in the PES header.', 'refs' => [ 'M2tsSettings$EsRateInPes' => 'Controls whether to include the ES Rate field in the PES header.', ], ], 'M2tsForceTsVideoEbpOrder' => [ 'base' => 'Keep the default value (DEFAULT) unless you know that your audio EBP markers are incorrectly appearing before your video EBP markers. To correct this problem, set this value to Force (FORCE).', 'refs' => [ 'M2tsSettings$ForceTsVideoEbpOrder' => 'Keep the default value (DEFAULT) unless you know that your audio EBP markers are incorrectly appearing before your video EBP markers. To correct this problem, set this value to Force (FORCE).', ], ], 'M2tsNielsenId3' => [ 'base' => 'If INSERT, Nielsen inaudible tones for media tracking will be detected in the input audio and an equivalent ID3 tag will be inserted in the output.', 'refs' => [ 'M2tsSettings$NielsenId3' => 'If INSERT, Nielsen inaudible tones for media tracking will be detected in the input audio and an equivalent ID3 tag will be inserted in the output.', ], ], 'M2tsPcrControl' => [ 'base' => 'When set to PCR_EVERY_PES_PACKET, a Program Clock Reference value is inserted for every Packetized Elementary Stream (PES) header. This is effective only when the PCR PID is the same as the video or audio elementary stream.', 'refs' => [ 'M2tsSettings$PcrControl' => 'When set to PCR_EVERY_PES_PACKET, a Program Clock Reference value is inserted for every Packetized Elementary Stream (PES) header. This is effective only when the PCR PID is the same as the video or audio elementary stream.', ], ], 'M2tsRateMode' => [ 'base' => 'When set to CBR, inserts null packets into transport stream to fill specified bitrate. When set to VBR, the bitrate setting acts as the maximum bitrate, but the output will not be padded up to that bitrate.', 'refs' => [ 'M2tsSettings$RateMode' => 'When set to CBR, inserts null packets into transport stream to fill specified bitrate. When set to VBR, the bitrate setting acts as the maximum bitrate, but the output will not be padded up to that bitrate.', ], ], 'M2tsScte35Esam' => [ 'base' => 'Settings for SCTE-35 signals from ESAM. Include this in your job settings to put SCTE-35 markers in your HLS and transport stream outputs at the insertion points that you specify in an ESAM XML document. Provide the document in the setting SCC XML (sccXml).', 'refs' => [ 'M2tsSettings$Scte35Esam' => 'Include this in your job settings to put SCTE-35 markers in your HLS and transport stream outputs at the insertion points that you specify in an ESAM XML document. Provide the document in the setting SCC XML (sccXml).', ], ], 'M2tsScte35Source' => [ 'base' => 'For SCTE-35 markers from your input-- Choose Passthrough (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output. Choose None (NONE) if you don\'t want SCTE-35 markers in this output. For SCTE-35 markers from an ESAM XML document-- Choose None (NONE). Also provide the ESAM XML as a string in the setting Signal processing notification XML (sccXml). Also enable ESAM SCTE-35 (include the property scte35Esam).', 'refs' => [ 'M2tsSettings$Scte35Source' => 'For SCTE-35 markers from your input-- Choose Passthrough (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output. Choose None (NONE) if you don\'t want SCTE-35 markers in this output. For SCTE-35 markers from an ESAM XML document-- Choose None (NONE). Also provide the ESAM XML as a string in the setting Signal processing notification XML (sccXml). Also enable ESAM SCTE-35 (include the property scte35Esam).', ], ], 'M2tsSegmentationMarkers' => [ 'base' => 'Inserts segmentation markers at each segmentation_time period. rai_segstart sets the Random Access Indicator bit in the adaptation field. rai_adapt sets the RAI bit and adds the current timecode in the private data bytes. psi_segstart inserts PAT and PMT tables at the start of segments. ebp adds Encoder Boundary Point information to the adaptation field as per OpenCable specification OC-SP-EBP-I01-130118. ebp_legacy adds Encoder Boundary Point information to the adaptation field using a legacy proprietary format.', 'refs' => [ 'M2tsSettings$SegmentationMarkers' => 'Inserts segmentation markers at each segmentation_time period. rai_segstart sets the Random Access Indicator bit in the adaptation field. rai_adapt sets the RAI bit and adds the current timecode in the private data bytes. psi_segstart inserts PAT and PMT tables at the start of segments. ebp adds Encoder Boundary Point information to the adaptation field as per OpenCable specification OC-SP-EBP-I01-130118. ebp_legacy adds Encoder Boundary Point information to the adaptation field using a legacy proprietary format.', ], ], 'M2tsSegmentationStyle' => [ 'base' => 'The segmentation style parameter controls how segmentation markers are inserted into the transport stream. With avails, it is possible that segments may be truncated, which can influence where future segmentation markers are inserted. When a segmentation style of "reset_cadence" is selected and a segment is truncated due to an avail, we will reset the segmentation cadence. This means the subsequent segment will have a duration of of $segmentation_time seconds. When a segmentation style of "maintain_cadence" is selected and a segment is truncated due to an avail, we will not reset the segmentation cadence. This means the subsequent segment will likely be truncated as well. However, all segments after that will have a duration of $segmentation_time seconds. Note that EBP lookahead is a slight exception to this rule.', 'refs' => [ 'M2tsSettings$SegmentationStyle' => 'The segmentation style parameter controls how segmentation markers are inserted into the transport stream. With avails, it is possible that segments may be truncated, which can influence where future segmentation markers are inserted. When a segmentation style of "reset_cadence" is selected and a segment is truncated due to an avail, we will reset the segmentation cadence. This means the subsequent segment will have a duration of of $segmentation_time seconds. When a segmentation style of "maintain_cadence" is selected and a segment is truncated due to an avail, we will not reset the segmentation cadence. This means the subsequent segment will likely be truncated as well. However, all segments after that will have a duration of $segmentation_time seconds. Note that EBP lookahead is a slight exception to this rule.', ], ], 'M2tsSettings' => [ 'base' => 'MPEG-2 TS container settings. These apply to outputs in a File output group when the output\'s container (ContainerType) is MPEG-2 Transport Stream (M2TS). In these assets, data is organized by the program map table (PMT). Each transport stream program contains subsets of data, including audio, video, and metadata. Each of these subsets of data has a numerical label called a packet identifier (PID). Each transport stream program corresponds to one MediaConvert output. The PMT lists the types of data in a program along with their PID. Downstream systems and players use the program map table to look up the PID for each type of data it accesses and then uses the PIDs to locate specific data within the asset.', 'refs' => [ 'ContainerSettings$M2tsSettings' => 'MPEG-2 TS container settings. These apply to outputs in a File output group when the output\'s container (ContainerType) is MPEG-2 Transport Stream (M2TS). In these assets, data is organized by the program map table (PMT). Each transport stream program contains subsets of data, including audio, video, and metadata. Each of these subsets of data has a numerical label called a packet identifier (PID). Each transport stream program corresponds to one MediaConvert output. The PMT lists the types of data in a program along with their PID. Downstream systems and players use the program map table to look up the PID for each type of data it accesses and then uses the PIDs to locate specific data within the asset.', ], ], 'M3u8NielsenId3' => [ 'base' => 'If INSERT, Nielsen inaudible tones for media tracking will be detected in the input audio and an equivalent ID3 tag will be inserted in the output.', 'refs' => [ 'M3u8Settings$NielsenId3' => 'If INSERT, Nielsen inaudible tones for media tracking will be detected in the input audio and an equivalent ID3 tag will be inserted in the output.', ], ], 'M3u8PcrControl' => [ 'base' => 'When set to PCR_EVERY_PES_PACKET a Program Clock Reference value is inserted for every Packetized Elementary Stream (PES) header. This parameter is effective only when the PCR PID is the same as the video or audio elementary stream.', 'refs' => [ 'M3u8Settings$PcrControl' => 'When set to PCR_EVERY_PES_PACKET a Program Clock Reference value is inserted for every Packetized Elementary Stream (PES) header. This parameter is effective only when the PCR PID is the same as the video or audio elementary stream.', ], ], 'M3u8Scte35Source' => [ 'base' => 'For SCTE-35 markers from your input-- Choose Passthrough (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output. Choose None (NONE) if you don\'t want SCTE-35 markers in this output. For SCTE-35 markers from an ESAM XML document-- Choose None (NONE) if you don\'t want manifest conditioning. Choose Passthrough (PASSTHROUGH) and choose Ad markers (adMarkers) if you do want manifest conditioning. In both cases, also provide the ESAM XML as a string in the setting Signal processing notification XML (sccXml).', 'refs' => [ 'M3u8Settings$Scte35Source' => 'For SCTE-35 markers from your input-- Choose Passthrough (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output. Choose None (NONE) if you don\'t want SCTE-35 markers in this output. For SCTE-35 markers from an ESAM XML document-- Choose None (NONE) if you don\'t want manifest conditioning. Choose Passthrough (PASSTHROUGH) and choose Ad markers (adMarkers) if you do want manifest conditioning. In both cases, also provide the ESAM XML as a string in the setting Signal processing notification XML (sccXml).', ], ], 'M3u8Settings' => [ 'base' => 'Settings for TS segments in HLS', 'refs' => [ 'ContainerSettings$M3u8Settings' => 'Settings for TS segments in HLS', ], ], 'MotionImageInserter' => [ 'base' => 'Overlay motion graphics on top of your video at the time that you specify.', 'refs' => [ 'JobSettings$MotionImageInserter' => 'Overlay motion graphics on top of your video. The motion graphics that you specify here appear on all outputs in all output groups.', 'JobTemplateSettings$MotionImageInserter' => 'Overlay motion graphics on top of your video. The motion graphics that you specify here appear on all outputs in all output groups.', ], ], 'MotionImageInsertionFramerate' => [ 'base' => 'For motion overlays that don\'t have a built-in frame rate, specify the frame rate of the overlay in frames per second, as a fraction. For example, specify 24 fps as 24/1. The overlay frame rate doesn\'t need to match the frame rate of the underlying video.', 'refs' => [ 'MotionImageInserter$Framerate' => 'If your motion graphic asset is a .mov file, keep this setting unspecified. If your motion graphic asset is a series of .png files, specify the frame rate of the overlay in frames per second, as a fraction. For example, specify 24 fps as 24/1. Make sure that the number of images in your series matches the frame rate and your intended overlay duration. For example, if you want a 30-second overlay at 30 fps, you should have 900 .png images. This overlay frame rate doesn\'t need to match the frame rate of the underlying video.', ], ], 'MotionImageInsertionMode' => [ 'base' => 'Choose the type of motion graphic asset that you are providing for your overlay. You can choose either a .mov file or a series of .png files.', 'refs' => [ 'MotionImageInserter$InsertionMode' => 'Choose the type of motion graphic asset that you are providing for your overlay. You can choose either a .mov file or a series of .png files.', ], ], 'MotionImageInsertionOffset' => [ 'base' => 'Specify the offset between the upper-left corner of the video frame and the top left corner of the overlay.', 'refs' => [ 'MotionImageInserter$Offset' => 'Use Offset to specify the placement of your motion graphic overlay on the video frame. Specify in pixels, from the upper-left corner of the frame. If you don\'t specify an offset, the service scales your overlay to the full size of the frame. Otherwise, the service inserts the overlay at its native resolution and scales the size up or down with any video scaling.', ], ], 'MotionImagePlayback' => [ 'base' => 'Specify whether your motion graphic overlay repeats on a loop or plays only once.', 'refs' => [ 'MotionImageInserter$Playback' => 'Specify whether your motion graphic overlay repeats on a loop or plays only once.', ], ], 'MovClapAtom' => [ 'base' => 'When enabled, include \'clap\' atom if appropriate for the video output settings.', 'refs' => [ 'MovSettings$ClapAtom' => 'When enabled, include \'clap\' atom if appropriate for the video output settings.', ], ], 'MovCslgAtom' => [ 'base' => 'When enabled, file composition times will start at zero, composition times in the \'ctts\' (composition time to sample) box for B-frames will be negative, and a \'cslg\' (composition shift least greatest) box will be included per 14496-1 amendment 1. This improves compatibility with Apple players and tools.', 'refs' => [ 'MovSettings$CslgAtom' => 'When enabled, file composition times will start at zero, composition times in the \'ctts\' (composition time to sample) box for B-frames will be negative, and a \'cslg\' (composition shift least greatest) box will be included per 14496-1 amendment 1. This improves compatibility with Apple players and tools.', ], ], 'MovMpeg2FourCCControl' => [ 'base' => 'When set to XDCAM, writes MPEG2 video streams into the QuickTime file using XDCAM fourcc codes. This increases compatibility with Apple editors and players, but may decrease compatibility with other players. Only applicable when the video codec is MPEG2.', 'refs' => [ 'MovSettings$Mpeg2FourCCControl' => 'When set to XDCAM, writes MPEG2 video streams into the QuickTime file using XDCAM fourcc codes. This increases compatibility with Apple editors and players, but may decrease compatibility with other players. Only applicable when the video codec is MPEG2.', ], ], 'MovPaddingControl' => [ 'base' => 'If set to OMNEON, inserts Omneon-compatible padding', 'refs' => [ 'MovSettings$PaddingControl' => 'If set to OMNEON, inserts Omneon-compatible padding', ], ], 'MovReference' => [ 'base' => 'Always keep the default value (SELF_CONTAINED) for this setting.', 'refs' => [ 'MovSettings$Reference' => 'Always keep the default value (SELF_CONTAINED) for this setting.', ], ], 'MovSettings' => [ 'base' => 'Settings for MOV Container.', 'refs' => [ 'ContainerSettings$MovSettings' => 'Settings for MOV Container.', ], ], 'Mp2Settings' => [ 'base' => 'Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value MP2.', 'refs' => [ 'AudioCodecSettings$Mp2Settings' => 'Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value MP2.', ], ], 'Mp3RateControlMode' => [ 'base' => 'Specify whether the service encodes this MP3 audio output with a constant bitrate (CBR) or a variable bitrate (VBR).', 'refs' => [ 'Mp3Settings$RateControlMode' => 'Specify whether the service encodes this MP3 audio output with a constant bitrate (CBR) or a variable bitrate (VBR).', ], ], 'Mp3Settings' => [ 'base' => 'Required when you set Codec, under AudioDescriptions>CodecSettings, to the value MP3.', 'refs' => [ 'AudioCodecSettings$Mp3Settings' => 'Required when you set Codec, under AudioDescriptions>CodecSettings, to the value MP3.', ], ], 'Mp4CslgAtom' => [ 'base' => 'When enabled, file composition times will start at zero, composition times in the \'ctts\' (composition time to sample) box for B-frames will be negative, and a \'cslg\' (composition shift least greatest) box will be included per 14496-1 amendment 1. This improves compatibility with Apple players and tools.', 'refs' => [ 'Mp4Settings$CslgAtom' => 'When enabled, file composition times will start at zero, composition times in the \'ctts\' (composition time to sample) box for B-frames will be negative, and a \'cslg\' (composition shift least greatest) box will be included per 14496-1 amendment 1. This improves compatibility with Apple players and tools.', ], ], 'Mp4FreeSpaceBox' => [ 'base' => 'Inserts a free-space box immediately after the moov box.', 'refs' => [ 'Mp4Settings$FreeSpaceBox' => 'Inserts a free-space box immediately after the moov box.', ], ], 'Mp4MoovPlacement' => [ 'base' => 'If set to PROGRESSIVE_DOWNLOAD, the MOOV atom is relocated to the beginning of the archive as required for progressive downloading. Otherwise it is placed normally at the end.', 'refs' => [ 'Mp4Settings$MoovPlacement' => 'If set to PROGRESSIVE_DOWNLOAD, the MOOV atom is relocated to the beginning of the archive as required for progressive downloading. Otherwise it is placed normally at the end.', ], ], 'Mp4Settings' => [ 'base' => 'Settings for MP4 container. You can create audio-only AAC outputs with this container.', 'refs' => [ 'ContainerSettings$Mp4Settings' => 'Settings for MP4 container. You can create audio-only AAC outputs with this container.', ], ], 'MpdCaptionContainerType' => [ 'base' => 'Use this setting only in DASH output groups that include sidecar TTML or IMSC captions. You specify sidecar captions in a separate output from your audio and video. Choose Raw (RAW) for captions in a single XML file in a raw container. Choose Fragmented MPEG-4 (FRAGMENTED_MP4) for captions in XML format contained within fragmented MP4 files. This set of fragmented MP4 files is separate from your video and audio fragmented MP4 files.', 'refs' => [ 'MpdSettings$CaptionContainerType' => 'Use this setting only in DASH output groups that include sidecar TTML or IMSC captions. You specify sidecar captions in a separate output from your audio and video. Choose Raw (RAW) for captions in a single XML file in a raw container. Choose Fragmented MPEG-4 (FRAGMENTED_MP4) for captions in XML format contained within fragmented MP4 files. This set of fragmented MP4 files is separate from your video and audio fragmented MP4 files.', ], ], 'MpdScte35Esam' => [ 'base' => 'Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers in this output at the insertion points that you specify in an ESAM XML document. Provide the document in the setting SCC XML (sccXml).', 'refs' => [ 'MpdSettings$Scte35Esam' => 'Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers in this output at the insertion points that you specify in an ESAM XML document. Provide the document in the setting SCC XML (sccXml).', ], ], 'MpdScte35Source' => [ 'base' => 'Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output. Choose None (NONE) if you don\'t want those SCTE-35 markers in this output.', 'refs' => [ 'MpdSettings$Scte35Source' => 'Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output. Choose None (NONE) if you don\'t want those SCTE-35 markers in this output.', ], ], 'MpdSettings' => [ 'base' => 'Settings for MP4 segments in DASH', 'refs' => [ 'ContainerSettings$MpdSettings' => 'Settings for MP4 segments in DASH', ], ], 'Mpeg2AdaptiveQuantization' => [ 'base' => 'Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.', 'refs' => [ 'Mpeg2Settings$AdaptiveQuantization' => 'Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.', ], ], 'Mpeg2CodecLevel' => [ 'base' => 'Use Level (Mpeg2CodecLevel) to set the MPEG-2 level for the video output.', 'refs' => [ 'Mpeg2Settings$CodecLevel' => 'Use Level (Mpeg2CodecLevel) to set the MPEG-2 level for the video output.', ], ], 'Mpeg2CodecProfile' => [ 'base' => 'Use Profile (Mpeg2CodecProfile) to set the MPEG-2 profile for the video output.', 'refs' => [ 'Mpeg2Settings$CodecProfile' => 'Use Profile (Mpeg2CodecProfile) to set the MPEG-2 profile for the video output.', ], ], 'Mpeg2DynamicSubGop' => [ 'base' => 'Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).', 'refs' => [ 'Mpeg2Settings$DynamicSubGop' => 'Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).', ], ], 'Mpeg2FramerateControl' => [ 'base' => 'If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.', 'refs' => [ 'Mpeg2Settings$FramerateControl' => 'If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.', ], ], 'Mpeg2FramerateConversionAlgorithm' => [ 'base' => 'Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use duplicate drop conversion.', 'refs' => [ 'Mpeg2Settings$FramerateConversionAlgorithm' => 'Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use duplicate drop conversion.', ], ], 'Mpeg2GopSizeUnits' => [ 'base' => 'Indicates if the GOP Size in MPEG2 is specified in frames or seconds. If seconds the system will convert the GOP Size into a frame count at run time.', 'refs' => [ 'Mpeg2Settings$GopSizeUnits' => 'Indicates if the GOP Size in MPEG2 is specified in frames or seconds. If seconds the system will convert the GOP Size into a frame count at run time.', ], ], 'Mpeg2InterlaceMode' => [ 'base' => 'Use Interlace mode (InterlaceMode) to choose the scan line type for the output. * Top Field First (TOP_FIELD) and Bottom Field First (BOTTOM_FIELD) produce interlaced output with the entire output having the same field polarity (top or bottom first). * Follow, Default Top (FOLLOW_TOP_FIELD) and Follow, Default Bottom (FOLLOW_BOTTOM_FIELD) use the same field polarity as the source. Therefore, behavior depends on the input scan type. - If the source is interlaced, the output will be interlaced with the same polarity as the source (it will follow the source). The output could therefore be a mix of "top field first" and "bottom field first". - If the source is progressive, the output will be interlaced with "top field first" or "bottom field first" polarity, depending on which of the Follow options you chose.', 'refs' => [ 'Mpeg2Settings$InterlaceMode' => 'Use Interlace mode (InterlaceMode) to choose the scan line type for the output. * Top Field First (TOP_FIELD) and Bottom Field First (BOTTOM_FIELD) produce interlaced output with the entire output having the same field polarity (top or bottom first). * Follow, Default Top (FOLLOW_TOP_FIELD) and Follow, Default Bottom (FOLLOW_BOTTOM_FIELD) use the same field polarity as the source. Therefore, behavior depends on the input scan type. - If the source is interlaced, the output will be interlaced with the same polarity as the source (it will follow the source). The output could therefore be a mix of "top field first" and "bottom field first". - If the source is progressive, the output will be interlaced with "top field first" or "bottom field first" polarity, depending on which of the Follow options you chose.', ], ], 'Mpeg2IntraDcPrecision' => [ 'base' => 'Use Intra DC precision (Mpeg2IntraDcPrecision) to set quantization precision for intra-block DC coefficients. If you choose the value auto, the service will automatically select the precision based on the per-frame compression ratio.', 'refs' => [ 'Mpeg2Settings$IntraDcPrecision' => 'Use Intra DC precision (Mpeg2IntraDcPrecision) to set quantization precision for intra-block DC coefficients. If you choose the value auto, the service will automatically select the precision based on the per-frame compression ratio.', ], ], 'Mpeg2ParControl' => [ 'base' => 'Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.', 'refs' => [ 'Mpeg2Settings$ParControl' => 'Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.', ], ], 'Mpeg2QualityTuningLevel' => [ 'base' => 'Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.', 'refs' => [ 'Mpeg2Settings$QualityTuningLevel' => 'Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.', ], ], 'Mpeg2RateControlMode' => [ 'base' => 'Use Rate control mode (Mpeg2RateControlMode) to specifiy whether the bitrate is variable (vbr) or constant (cbr).', 'refs' => [ 'Mpeg2Settings$RateControlMode' => 'Use Rate control mode (Mpeg2RateControlMode) to specifiy whether the bitrate is variable (vbr) or constant (cbr).', ], ], 'Mpeg2SceneChangeDetect' => [ 'base' => 'Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves video quality and is enabled by default.', 'refs' => [ 'Mpeg2Settings$SceneChangeDetect' => 'Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves video quality and is enabled by default.', ], ], 'Mpeg2Settings' => [ 'base' => 'Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value MPEG2.', 'refs' => [ 'VideoCodecSettings$Mpeg2Settings' => 'Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value MPEG2.', ], ], 'Mpeg2SlowPal' => [ 'base' => 'Enables Slow PAL rate conversion. 23.976fps and 24fps input is relabeled as 25fps, and audio is sped up correspondingly.', 'refs' => [ 'Mpeg2Settings$SlowPal' => 'Enables Slow PAL rate conversion. 23.976fps and 24fps input is relabeled as 25fps, and audio is sped up correspondingly.', ], ], 'Mpeg2SpatialAdaptiveQuantization' => [ 'base' => 'Adjust quantization within each frame based on spatial variation of content complexity.', 'refs' => [ 'Mpeg2Settings$SpatialAdaptiveQuantization' => 'Adjust quantization within each frame based on spatial variation of content complexity.', ], ], 'Mpeg2Syntax' => [ 'base' => 'Produces a Type D-10 compatible bitstream (SMPTE 356M-2001).', 'refs' => [ 'Mpeg2Settings$Syntax' => 'Produces a Type D-10 compatible bitstream (SMPTE 356M-2001).', ], ], 'Mpeg2Telecine' => [ 'base' => 'Only use Telecine (Mpeg2Telecine) when you set Framerate (Framerate) to 29.970. Set Telecine (Mpeg2Telecine) to Hard (hard) to produce a 29.97i output from a 23.976 input. Set it to Soft (soft) to produce 23.976 output and leave converstion to the player.', 'refs' => [ 'Mpeg2Settings$Telecine' => 'Only use Telecine (Mpeg2Telecine) when you set Framerate (Framerate) to 29.970. Set Telecine (Mpeg2Telecine) to Hard (hard) to produce a 29.97i output from a 23.976 input. Set it to Soft (soft) to produce 23.976 output and leave converstion to the player.', ], ], 'Mpeg2TemporalAdaptiveQuantization' => [ 'base' => 'Adjust quantization within each frame based on temporal variation of content complexity.', 'refs' => [ 'Mpeg2Settings$TemporalAdaptiveQuantization' => 'Adjust quantization within each frame based on temporal variation of content complexity.', ], ], 'MsSmoothAdditionalManifest' => [ 'base' => 'Specify the details for each additional Microsoft Smooth Streaming manifest that you want the service to generate for this output group. Each manifest can reference a different subset of outputs in the group.', 'refs' => [ '__listOfMsSmoothAdditionalManifest$member' => NULL, ], ], 'MsSmoothAudioDeduplication' => [ 'base' => 'COMBINE_DUPLICATE_STREAMS combines identical audio encoding settings across a Microsoft Smooth output group into a single audio stream.', 'refs' => [ 'MsSmoothGroupSettings$AudioDeduplication' => 'COMBINE_DUPLICATE_STREAMS combines identical audio encoding settings across a Microsoft Smooth output group into a single audio stream.', ], ], 'MsSmoothEncryptionSettings' => [ 'base' => 'If you are using DRM, set DRM System (MsSmoothEncryptionSettings) to specify the value SpekeKeyProvider.', 'refs' => [ 'MsSmoothGroupSettings$Encryption' => 'If you are using DRM, set DRM System (MsSmoothEncryptionSettings) to specify the value SpekeKeyProvider.', ], ], 'MsSmoothGroupSettings' => [ 'base' => 'Required when you set (Type) under (OutputGroups)>(OutputGroupSettings) to MS_SMOOTH_GROUP_SETTINGS.', 'refs' => [ 'OutputGroupSettings$MsSmoothGroupSettings' => 'Required when you set (Type) under (OutputGroups)>(OutputGroupSettings) to MS_SMOOTH_GROUP_SETTINGS.', ], ], 'MsSmoothManifestEncoding' => [ 'base' => 'Use Manifest encoding (MsSmoothManifestEncoding) to specify the encoding format for the server and client manifest. Valid options are utf8 and utf16.', 'refs' => [ 'MsSmoothGroupSettings$ManifestEncoding' => 'Use Manifest encoding (MsSmoothManifestEncoding) to specify the encoding format for the server and client manifest. Valid options are utf8 and utf16.', ], ], 'MxfAfdSignaling' => [ 'base' => 'Optional. When you have AFD signaling set up in your output video stream, use this setting to choose whether to also include it in the MXF wrapper. Choose Don\'t copy (NO_COPY) to exclude AFD signaling from the MXF wrapper. Choose Copy from video stream (COPY_FROM_VIDEO) to copy the AFD values from the video stream for this output to the MXF wrapper. Regardless of which option you choose, the AFD values remain in the video stream. Related settings: To set up your output to include or exclude AFD values, see AfdSignaling, under VideoDescription. On the console, find AFD signaling under the output\'s video encoding settings.', 'refs' => [ 'MxfSettings$AfdSignaling' => 'Optional. When you have AFD signaling set up in your output video stream, use this setting to choose whether to also include it in the MXF wrapper. Choose Don\'t copy (NO_COPY) to exclude AFD signaling from the MXF wrapper. Choose Copy from video stream (COPY_FROM_VIDEO) to copy the AFD values from the video stream for this output to the MXF wrapper. Regardless of which option you choose, the AFD values remain in the video stream. Related settings: To set up your output to include or exclude AFD values, see AfdSignaling, under VideoDescription. On the console, find AFD signaling under the output\'s video encoding settings.', ], ], 'MxfSettings' => [ 'base' => 'MXF settings', 'refs' => [ 'ContainerSettings$MxfSettings' => 'MXF settings', ], ], 'NexGuardFileMarkerSettings' => [ 'base' => 'For forensic video watermarking, MediaConvert supports Nagra NexGuard File Marker watermarking. MediaConvert supports both PreRelease Content (NGPR/G2) and OTT Streaming workflows.', 'refs' => [ 'PartnerWatermarking$NexguardFileMarkerSettings' => 'For forensic video watermarking, MediaConvert supports Nagra NexGuard File Marker watermarking. MediaConvert supports both PreRelease Content (NGPR/G2) and OTT Streaming workflows.', ], ], 'NielsenConfiguration' => [ 'base' => 'Settings for your Nielsen configuration. If you don\'t do Nielsen measurement and analytics, ignore these settings. When you enable Nielsen configuration (nielsenConfiguration), MediaConvert enables PCM to ID3 tagging for all outputs in the job. To enable Nielsen configuration programmatically, include an instance of nielsenConfiguration in your JSON job specification. Even if you don\'t include any children of nielsenConfiguration, you still enable the setting.', 'refs' => [ 'JobSettings$NielsenConfiguration' => 'Settings for your Nielsen configuration. If you don\'t do Nielsen measurement and analytics, ignore these settings. When you enable Nielsen configuration (nielsenConfiguration), MediaConvert enables PCM to ID3 tagging for all outputs in the job. To enable Nielsen configuration programmatically, include an instance of nielsenConfiguration in your JSON job specification. Even if you don\'t include any children of nielsenConfiguration, you still enable the setting.', 'JobTemplateSettings$NielsenConfiguration' => 'Settings for your Nielsen configuration. If you don\'t do Nielsen measurement and analytics, ignore these settings. When you enable Nielsen configuration (nielsenConfiguration), MediaConvert enables PCM to ID3 tagging for all outputs in the job. To enable Nielsen configuration programmatically, include an instance of nielsenConfiguration in your JSON job specification. Even if you don\'t include any children of nielsenConfiguration, you still enable the setting.', ], ], 'NoiseFilterPostTemporalSharpening' => [ 'base' => 'Optional. When you set Noise reducer (noiseReducer) to Temporal (TEMPORAL), you can optionally use this setting to apply additional sharpening. The default behavior, Auto (AUTO) allows the transcoder to determine whether to apply filtering, depending on input type and quality.', 'refs' => [ 'NoiseReducerTemporalFilterSettings$PostTemporalSharpening' => 'Optional. When you set Noise reducer (noiseReducer) to Temporal (TEMPORAL), you can optionally use this setting to apply additional sharpening. The default behavior, Auto (AUTO) allows the transcoder to determine whether to apply filtering, depending on input type and quality.', ], ], 'NoiseReducer' => [ 'base' => 'Enable the Noise reducer (NoiseReducer) feature to remove noise from your video output if necessary. Enable or disable this feature for each output individually. This setting is disabled by default. When you enable Noise reducer (NoiseReducer), you must also select a value for Noise reducer filter (NoiseReducerFilter).', 'refs' => [ 'VideoPreprocessor$NoiseReducer' => 'Enable the Noise reducer (NoiseReducer) feature to remove noise from your video output if necessary. Enable or disable this feature for each output individually. This setting is disabled by default.', ], ], 'NoiseReducerFilter' => [ 'base' => 'Use Noise reducer filter (NoiseReducerFilter) to select one of the following spatial image filtering functions. To use this setting, you must also enable Noise reducer (NoiseReducer). * Bilateral preserves edges while reducing noise. * Mean (softest), Gaussian, Lanczos, and Sharpen (sharpest) do convolution filtering. * Conserve does min/max noise reduction. * Spatial does frequency-domain filtering based on JND principles. * Temporal optimizes video quality for complex motion.', 'refs' => [ 'NoiseReducer$Filter' => 'Use Noise reducer filter (NoiseReducerFilter) to select one of the following spatial image filtering functions. To use this setting, you must also enable Noise reducer (NoiseReducer). * Bilateral preserves edges while reducing noise. * Mean (softest), Gaussian, Lanczos, and Sharpen (sharpest) do convolution filtering. * Conserve does min/max noise reduction. * Spatial does frequency-domain filtering based on JND principles. * Temporal optimizes video quality for complex motion.', ], ], 'NoiseReducerFilterSettings' => [ 'base' => 'Settings for a noise reducer filter', 'refs' => [ 'NoiseReducer$FilterSettings' => 'Settings for a noise reducer filter', ], ], 'NoiseReducerSpatialFilterSettings' => [ 'base' => 'Noise reducer filter settings for spatial filter.', 'refs' => [ 'NoiseReducer$SpatialFilterSettings' => 'Noise reducer filter settings for spatial filter.', ], ], 'NoiseReducerTemporalFilterSettings' => [ 'base' => 'Noise reducer filter settings for temporal filter.', 'refs' => [ 'NoiseReducer$TemporalFilterSettings' => 'Noise reducer filter settings for temporal filter.', ], ], 'NotFoundException' => [ 'base' => NULL, 'refs' => [], ], 'OpusSettings' => [ 'base' => 'Required when you set Codec, under AudioDescriptions>CodecSettings, to the value OPUS.', 'refs' => [ 'AudioCodecSettings$OpusSettings' => 'Required when you set Codec, under AudioDescriptions>CodecSettings, to the value OPUS.', ], ], 'Order' => [ 'base' => 'Optional. When you request lists of resources, you can specify whether they are sorted in ASCENDING or DESCENDING order. Default varies by resource.', 'refs' => [ 'ListJobTemplatesRequest$Order' => 'Optional. When you request lists of resources, you can specify whether they are sorted in ASCENDING or DESCENDING order. Default varies by resource.', 'ListJobsRequest$Order' => 'Optional. When you request lists of resources, you can specify whether they are sorted in ASCENDING or DESCENDING order. Default varies by resource.', 'ListPresetsRequest$Order' => 'Optional. When you request lists of resources, you can specify whether they are sorted in ASCENDING or DESCENDING order. Default varies by resource.', 'ListQueuesRequest$Order' => 'Optional. When you request lists of resources, you can specify whether they are sorted in ASCENDING or DESCENDING order. Default varies by resource.', ], ], 'Output' => [ 'base' => 'An output object describes the settings for a single output file or stream in an output group.', 'refs' => [ '__listOfOutput$member' => NULL, ], ], 'OutputChannelMapping' => [ 'base' => 'OutputChannel mapping settings.', 'refs' => [ '__listOfOutputChannelMapping$member' => NULL, ], ], 'OutputDetail' => [ 'base' => 'Details regarding output', 'refs' => [ '__listOfOutputDetail$member' => NULL, ], ], 'OutputGroup' => [ 'base' => 'Group of outputs', 'refs' => [ '__listOfOutputGroup$member' => NULL, ], ], 'OutputGroupDetail' => [ 'base' => 'Contains details about the output groups specified in the job settings.', 'refs' => [ '__listOfOutputGroupDetail$member' => NULL, ], ], 'OutputGroupSettings' => [ 'base' => 'Output Group settings, including type', 'refs' => [ 'OutputGroup$OutputGroupSettings' => 'Output Group settings, including type', ], ], 'OutputGroupType' => [ 'base' => 'Type of output group (File group, Apple HLS, DASH ISO, Microsoft Smooth Streaming, CMAF)', 'refs' => [ 'OutputGroupSettings$Type' => 'Type of output group (File group, Apple HLS, DASH ISO, Microsoft Smooth Streaming, CMAF)', ], ], 'OutputSdt' => [ 'base' => 'Selects method of inserting SDT information into output stream. "Follow input SDT" copies SDT information from input stream to output stream. "Follow input SDT if present" copies SDT information from input stream to output stream if SDT information is present in the input, otherwise it will fall back on the user-defined values. Enter "SDT Manually" means user will enter the SDT information. "No SDT" means output stream will not contain SDT information.', 'refs' => [ 'DvbSdtSettings$OutputSdt' => 'Selects method of inserting SDT information into output stream. "Follow input SDT" copies SDT information from input stream to output stream. "Follow input SDT if present" copies SDT information from input stream to output stream if SDT information is present in the input, otherwise it will fall back on the user-defined values. Enter "SDT Manually" means user will enter the SDT information. "No SDT" means output stream will not contain SDT information.', ], ], 'OutputSettings' => [ 'base' => 'Specific settings for this type of output.', 'refs' => [ 'Output$OutputSettings' => 'Specific settings for this type of output.', ], ], 'PartnerWatermarking' => [ 'base' => 'If you work with a third party video watermarking partner, use the group of settings that correspond with your watermarking partner to include watermarks in your output.', 'refs' => [ 'VideoPreprocessor$PartnerWatermarking' => 'If you work with a third party video watermarking partner, use the group of settings that correspond with your watermarking partner to include watermarks in your output.', ], ], 'Preset' => [ 'base' => 'A preset is a collection of preconfigured media conversion settings that you want MediaConvert to apply to the output during the conversion process.', 'refs' => [ 'CreatePresetResponse$Preset' => 'A preset is a collection of preconfigured media conversion settings that you want MediaConvert to apply to the output during the conversion process.', 'GetPresetResponse$Preset' => 'A preset is a collection of preconfigured media conversion settings that you want MediaConvert to apply to the output during the conversion process.', 'UpdatePresetResponse$Preset' => 'A preset is a collection of preconfigured media conversion settings that you want MediaConvert to apply to the output during the conversion process.', '__listOfPreset$member' => NULL, ], ], 'PresetListBy' => [ 'base' => 'Optional. When you request a list of presets, you can choose to list them alphabetically by NAME or chronologically by CREATION_DATE. If you don\'t specify, the service will list them by name.', 'refs' => [ 'ListPresetsRequest$ListBy' => 'Optional. When you request a list of presets, you can choose to list them alphabetically by NAME or chronologically by CREATION_DATE. If you don\'t specify, the service will list them by name.', ], ], 'PresetSettings' => [ 'base' => 'Settings for preset', 'refs' => [ 'CreatePresetRequest$Settings' => 'Settings for preset', 'Preset$Settings' => 'Settings for preset', 'UpdatePresetRequest$Settings' => 'Settings for preset', ], ], 'PricingPlan' => [ 'base' => 'Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per minute, billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the entire queue, regardless of how much or how little you use it. Reserved pricing requires a 12-month commitment.', 'refs' => [ 'CreateQueueRequest$PricingPlan' => 'Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per minute, billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the entire queue, regardless of how much or how little you use it. Reserved pricing requires a 12-month commitment. When you use the API to create a queue, the default is on-demand.', 'Queue$PricingPlan' => 'Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per minute, billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the entire queue, regardless of how much or how little you use it. Reserved pricing requires a 12-month commitment.', ], ], 'ProresCodecProfile' => [ 'base' => 'Use Profile (ProResCodecProfile) to specifiy the type of Apple ProRes codec to use for this output.', 'refs' => [ 'ProresSettings$CodecProfile' => 'Use Profile (ProResCodecProfile) to specifiy the type of Apple ProRes codec to use for this output.', ], ], 'ProresFramerateControl' => [ 'base' => 'If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.', 'refs' => [ 'ProresSettings$FramerateControl' => 'If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.', ], ], 'ProresFramerateConversionAlgorithm' => [ 'base' => 'Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use duplicate drop conversion.', 'refs' => [ 'ProresSettings$FramerateConversionAlgorithm' => 'Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use duplicate drop conversion.', ], ], 'ProresInterlaceMode' => [ 'base' => 'Use Interlace mode (InterlaceMode) to choose the scan line type for the output. * Top Field First (TOP_FIELD) and Bottom Field First (BOTTOM_FIELD) produce interlaced output with the entire output having the same field polarity (top or bottom first). * Follow, Default Top (FOLLOW_TOP_FIELD) and Follow, Default Bottom (FOLLOW_BOTTOM_FIELD) use the same field polarity as the source. Therefore, behavior depends on the input scan type. - If the source is interlaced, the output will be interlaced with the same polarity as the source (it will follow the source). The output could therefore be a mix of "top field first" and "bottom field first". - If the source is progressive, the output will be interlaced with "top field first" or "bottom field first" polarity, depending on which of the Follow options you chose.', 'refs' => [ 'ProresSettings$InterlaceMode' => 'Use Interlace mode (InterlaceMode) to choose the scan line type for the output. * Top Field First (TOP_FIELD) and Bottom Field First (BOTTOM_FIELD) produce interlaced output with the entire output having the same field polarity (top or bottom first). * Follow, Default Top (FOLLOW_TOP_FIELD) and Follow, Default Bottom (FOLLOW_BOTTOM_FIELD) use the same field polarity as the source. Therefore, behavior depends on the input scan type. - If the source is interlaced, the output will be interlaced with the same polarity as the source (it will follow the source). The output could therefore be a mix of "top field first" and "bottom field first". - If the source is progressive, the output will be interlaced with "top field first" or "bottom field first" polarity, depending on which of the Follow options you chose.', ], ], 'ProresParControl' => [ 'base' => 'Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.', 'refs' => [ 'ProresSettings$ParControl' => 'Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.', ], ], 'ProresSettings' => [ 'base' => 'Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value PRORES.', 'refs' => [ 'VideoCodecSettings$ProresSettings' => 'Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value PRORES.', ], ], 'ProresSlowPal' => [ 'base' => 'Enables Slow PAL rate conversion. 23.976fps and 24fps input is relabeled as 25fps, and audio is sped up correspondingly.', 'refs' => [ 'ProresSettings$SlowPal' => 'Enables Slow PAL rate conversion. 23.976fps and 24fps input is relabeled as 25fps, and audio is sped up correspondingly.', ], ], 'ProresTelecine' => [ 'base' => 'Only use Telecine (ProresTelecine) when you set Framerate (Framerate) to 29.970. Set Telecine (ProresTelecine) to Hard (hard) to produce a 29.97i output from a 23.976 input. Set it to Soft (soft) to produce 23.976 output and leave converstion to the player.', 'refs' => [ 'ProresSettings$Telecine' => 'Only use Telecine (ProresTelecine) when you set Framerate (Framerate) to 29.970. Set Telecine (ProresTelecine) to Hard (hard) to produce a 29.97i output from a 23.976 input. Set it to Soft (soft) to produce 23.976 output and leave converstion to the player.', ], ], 'Queue' => [ 'base' => 'You can use queues to manage the resources that are available to your AWS account for running multiple transcoding jobs at the same time. If you don\'t specify a queue, the service sends all jobs through the default queue. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html.', 'refs' => [ 'CreateQueueResponse$Queue' => 'You can use queues to manage the resources that are available to your AWS account for running multiple transcoding jobs at the same time. If you don\'t specify a queue, the service sends all jobs through the default queue. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html.', 'GetQueueResponse$Queue' => 'You can use queues to manage the resources that are available to your AWS account for running multiple transcoding jobs at the same time. If you don\'t specify a queue, the service sends all jobs through the default queue. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html.', 'UpdateQueueResponse$Queue' => 'You can use queues to manage the resources that are available to your AWS account for running multiple transcoding jobs at the same time. If you don\'t specify a queue, the service sends all jobs through the default queue. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html.', '__listOfQueue$member' => NULL, ], ], 'QueueListBy' => [ 'base' => 'Optional. When you request a list of queues, you can choose to list them alphabetically by NAME or chronologically by CREATION_DATE. If you don\'t specify, the service will list them by creation date.', 'refs' => [ 'ListQueuesRequest$ListBy' => 'Optional. When you request a list of queues, you can choose to list them alphabetically by NAME or chronologically by CREATION_DATE. If you don\'t specify, the service will list them by creation date.', ], ], 'QueueStatus' => [ 'base' => 'Queues can be ACTIVE or PAUSED. If you pause a queue, jobs in that queue won\'t begin. Jobs that are running when you pause a queue continue to run until they finish or result in an error.', 'refs' => [ 'CreateQueueRequest$Status' => 'Initial state of the queue. If you create a paused queue, then jobs in that queue won\'t begin.', 'Queue$Status' => 'Queues can be ACTIVE or PAUSED. If you pause a queue, the service won\'t begin processing jobs in that queue. Jobs that are running when you pause the queue continue to run until they finish or result in an error.', 'UpdateQueueRequest$Status' => 'Pause or activate a queue by changing its status between ACTIVE and PAUSED. If you pause a queue, jobs in that queue won\'t begin. Jobs that are running when you pause the queue continue to run until they finish or result in an error.', ], ], 'QueueTransition' => [ 'base' => 'Description of the source and destination queues between which the job has moved, along with the timestamp of the move', 'refs' => [ '__listOfQueueTransition$member' => NULL, ], ], 'Rectangle' => [ 'base' => 'Use Rectangle to identify a specific area of the video frame.', 'refs' => [ 'Input$Crop' => 'Use Cropping selection (crop) to specify the video area that the service will include in the output video frame. If you specify a value here, it will override any value that you specify in the output setting Cropping selection (crop).', 'Input$Position' => 'Use Selection placement (position) to define the video area in your output frame. The area outside of the rectangle that you specify here is black. If you specify a value here, it will override any value that you specify in the output setting Selection placement (position). If you specify a value here, this will override any AFD values in your input, even if you set Respond to AFD (RespondToAfd) to Respond (RESPOND). If you specify a value here, this will ignore anything that you specify for the setting Scaling Behavior (scalingBehavior).', 'InputTemplate$Crop' => 'Use Cropping selection (crop) to specify the video area that the service will include in the output video frame. If you specify a value here, it will override any value that you specify in the output setting Cropping selection (crop).', 'InputTemplate$Position' => 'Use Selection placement (position) to define the video area in your output frame. The area outside of the rectangle that you specify here is black. If you specify a value here, it will override any value that you specify in the output setting Selection placement (position). If you specify a value here, this will override any AFD values in your input, even if you set Respond to AFD (RespondToAfd) to Respond (RESPOND). If you specify a value here, this will ignore anything that you specify for the setting Scaling Behavior (scalingBehavior).', 'VideoDescription$Crop' => 'Use Cropping selection (crop) to specify the video area that the service will include in the output video frame.', 'VideoDescription$Position' => 'Use Selection placement (position) to define the video area in your output frame. The area outside of the rectangle that you specify here is black.', ], ], 'RemixSettings' => [ 'base' => 'Use Manual audio remixing (RemixSettings) to adjust audio levels for each audio channel in each output of your job. With audio remixing, you can output more or fewer audio channels than your input audio source provides.', 'refs' => [ 'AudioDescription$RemixSettings' => 'Advanced audio remixing settings.', 'AudioSelector$RemixSettings' => 'Use these settings to reorder the audio channels of one input to match those of another input. This allows you to combine the two files into a single output, one after the other.', ], ], 'RenewalType' => [ 'base' => 'Specifies whether the term of your reserved queue pricing plan is automatically extended (AUTO_RENEW) or expires (EXPIRE) at the end of the term.', 'refs' => [ 'ReservationPlan$RenewalType' => 'Specifies whether the term of your reserved queue pricing plan is automatically extended (AUTO_RENEW) or expires (EXPIRE) at the end of the term.', 'ReservationPlanSettings$RenewalType' => 'Specifies whether the term of your reserved queue pricing plan is automatically extended (AUTO_RENEW) or expires (EXPIRE) at the end of the term. When your term is auto renewed, you extend your commitment by 12 months from the auto renew date. You can cancel this commitment.', ], ], 'ReservationPlan' => [ 'base' => 'Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable to on-demand queues.', 'refs' => [ 'Queue$ReservationPlan' => 'Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable to on-demand queues.', ], ], 'ReservationPlanSettings' => [ 'base' => 'Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable to on-demand queues.', 'refs' => [ 'CreateQueueRequest$ReservationPlanSettings' => 'Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable to on-demand queues.', 'UpdateQueueRequest$ReservationPlanSettings' => 'The new details of your pricing plan for your reserved queue. When you set up a new pricing plan to replace an expired one, you enter into another 12-month commitment. When you add capacity to your queue by increasing the number of RTS, you extend the term of your commitment to 12 months from when you add capacity. After you make these commitments, you can\'t cancel them.', ], ], 'ReservationPlanStatus' => [ 'base' => 'Specifies whether the pricing plan for your reserved queue is ACTIVE or EXPIRED.', 'refs' => [ 'ReservationPlan$Status' => 'Specifies whether the pricing plan for your reserved queue is ACTIVE or EXPIRED.', ], ], 'ResourceTags' => [ 'base' => 'The Amazon Resource Name (ARN) and tags for an AWS Elemental MediaConvert resource.', 'refs' => [ 'ListTagsForResourceResponse$ResourceTags' => 'The Amazon Resource Name (ARN) and tags for an AWS Elemental MediaConvert resource.', ], ], 'RespondToAfd' => [ 'base' => 'Use Respond to AFD (RespondToAfd) to specify how the service changes the video itself in response to AFD values in the input. * Choose Respond to clip the input video frame according to the AFD value, input display aspect ratio, and output display aspect ratio. * Choose Passthrough to include the input AFD values. Do not choose this when AfdSignaling is set to (NONE). A preferred implementation of this workflow is to set RespondToAfd to (NONE) and set AfdSignaling to (AUTO). * Choose None to remove all input AFD values from this output.', 'refs' => [ 'VideoDescription$RespondToAfd' => 'Use Respond to AFD (RespondToAfd) to specify how the service changes the video itself in response to AFD values in the input. * Choose Respond to clip the input video frame according to the AFD value, input display aspect ratio, and output display aspect ratio. * Choose Passthrough to include the input AFD values. Do not choose this when AfdSignaling is set to (NONE). A preferred implementation of this workflow is to set RespondToAfd to (NONE) and set AfdSignaling to (AUTO). * Choose None to remove all input AFD values from this output.', ], ], 'S3DestinationAccessControl' => [ 'base' => 'Optional. Have MediaConvert automatically apply Amazon S3 access control for the outputs in this output group. When you don\'t use this setting, S3 automatically applies the default access control list PRIVATE.', 'refs' => [ 'S3DestinationSettings$AccessControl' => 'Optional. Have MediaConvert automatically apply Amazon S3 access control for the outputs in this output group. When you don\'t use this setting, S3 automatically applies the default access control list PRIVATE.', ], ], 'S3DestinationSettings' => [ 'base' => 'Settings associated with S3 destination', 'refs' => [ 'DestinationSettings$S3Settings' => 'Settings associated with S3 destination', ], ], 'S3EncryptionSettings' => [ 'base' => 'Settings for how your job outputs are encrypted as they are uploaded to Amazon S3.', 'refs' => [ 'S3DestinationSettings$Encryption' => 'Settings for how your job outputs are encrypted as they are uploaded to Amazon S3.', ], ], 'S3ObjectCannedAcl' => [ 'base' => 'Choose an Amazon S3 canned ACL for MediaConvert to apply to this output.', 'refs' => [ 'S3DestinationAccessControl$CannedAcl' => 'Choose an Amazon S3 canned ACL for MediaConvert to apply to this output.', ], ], 'S3ServerSideEncryptionType' => [ 'base' => 'Specify how you want your data keys managed. AWS uses data keys to encrypt your content. AWS also encrypts the data keys themselves, using a customer master key (CMK), and then stores the encrypted data keys alongside your encrypted content. Use this setting to specify which AWS service manages the CMK. For simplest set up, choose Amazon S3 (SERVER_SIDE_ENCRYPTION_S3). If you want your master key to be managed by AWS Key Management Service (KMS), choose AWS KMS (SERVER_SIDE_ENCRYPTION_KMS). By default, when you choose AWS KMS, KMS uses the AWS managed customer master key (CMK) associated with Amazon S3 to encrypt your data keys. You can optionally choose to specify a different, customer managed CMK. Do so by specifying the Amazon Resource Name (ARN) of the key for the setting KMS ARN (kmsKeyArn).', 'refs' => [ 'S3EncryptionSettings$EncryptionType' => 'Specify how you want your data keys managed. AWS uses data keys to encrypt your content. AWS also encrypts the data keys themselves, using a customer master key (CMK), and then stores the encrypted data keys alongside your encrypted content. Use this setting to specify which AWS service manages the CMK. For simplest set up, choose Amazon S3 (SERVER_SIDE_ENCRYPTION_S3). If you want your master key to be managed by AWS Key Management Service (KMS), choose AWS KMS (SERVER_SIDE_ENCRYPTION_KMS). By default, when you choose AWS KMS, KMS uses the AWS managed customer master key (CMK) associated with Amazon S3 to encrypt your data keys. You can optionally choose to specify a different, customer managed CMK. Do so by specifying the Amazon Resource Name (ARN) of the key for the setting KMS ARN (kmsKeyArn).', ], ], 'ScalingBehavior' => [ 'base' => 'Specify how the service handles outputs that have a different aspect ratio from the input aspect ratio. Choose Stretch to output (STRETCH_TO_OUTPUT) to have the service stretch your video image to fit. Keep the setting Default (DEFAULT) to have the service letterbox your video instead. This setting overrides any value that you specify for the setting Selection placement (position) in this output.', 'refs' => [ 'VideoDescription$ScalingBehavior' => 'Specify how the service handles outputs that have a different aspect ratio from the input aspect ratio. Choose Stretch to output (STRETCH_TO_OUTPUT) to have the service stretch your video image to fit. Keep the setting Default (DEFAULT) to have the service letterbox your video instead. This setting overrides any value that you specify for the setting Selection placement (position) in this output.', ], ], 'SccDestinationFramerate' => [ 'base' => 'Set Framerate (SccDestinationFramerate) to make sure that the captions and the video are synchronized in the output. Specify a frame rate that matches the frame rate of the associated video. If the video frame rate is 29.97, choose 29.97 dropframe (FRAMERATE_29_97_DROPFRAME) only if the video has video_insertion=true and drop_frame_timecode=true; otherwise, choose 29.97 non-dropframe (FRAMERATE_29_97_NON_DROPFRAME).', 'refs' => [ 'SccDestinationSettings$Framerate' => 'Set Framerate (SccDestinationFramerate) to make sure that the captions and the video are synchronized in the output. Specify a frame rate that matches the frame rate of the associated video. If the video frame rate is 29.97, choose 29.97 dropframe (FRAMERATE_29_97_DROPFRAME) only if the video has video_insertion=true and drop_frame_timecode=true; otherwise, choose 29.97 non-dropframe (FRAMERATE_29_97_NON_DROPFRAME).', ], ], 'SccDestinationSettings' => [ 'base' => 'Settings for SCC caption output.', 'refs' => [ 'CaptionDestinationSettings$SccDestinationSettings' => 'Settings for SCC caption output.', ], ], 'SimulateReservedQueue' => [ 'base' => 'Enable this setting when you run a test job to estimate how many reserved transcoding slots (RTS) you need. When this is enabled, MediaConvert runs your job from an on-demand queue with similar performance to what you will see with one RTS in a reserved queue. This setting is disabled by default.', 'refs' => [ 'CreateJobRequest$SimulateReservedQueue' => 'Optional. Enable this setting when you run a test job to estimate how many reserved transcoding slots (RTS) you need. When this is enabled, MediaConvert runs your job from an on-demand queue with similar performance to what you will see with one RTS in a reserved queue. This setting is disabled by default.', 'Job$SimulateReservedQueue' => 'Enable this setting when you run a test job to estimate how many reserved transcoding slots (RTS) you need. When this is enabled, MediaConvert runs your job from an on-demand queue with similar performance to what you will see with one RTS in a reserved queue. This setting is disabled by default.', ], ], 'SpekeKeyProvider' => [ 'base' => 'If your output group type is HLS, DASH, or Microsoft Smooth, use these settings when doing DRM encryption with a SPEKE-compliant key provider. If your output group type is CMAF, use the SpekeKeyProviderCmaf settings instead.', 'refs' => [ 'DashIsoEncryptionSettings$SpekeKeyProvider' => 'If your output group type is HLS, DASH, or Microsoft Smooth, use these settings when doing DRM encryption with a SPEKE-compliant key provider. If your output group type is CMAF, use the SpekeKeyProviderCmaf settings instead.', 'HlsEncryptionSettings$SpekeKeyProvider' => 'If your output group type is HLS, DASH, or Microsoft Smooth, use these settings when doing DRM encryption with a SPEKE-compliant key provider. If your output group type is CMAF, use the SpekeKeyProviderCmaf settings instead.', 'MsSmoothEncryptionSettings$SpekeKeyProvider' => 'If your output group type is HLS, DASH, or Microsoft Smooth, use these settings when doing DRM encryption with a SPEKE-compliant key provider. If your output group type is CMAF, use the SpekeKeyProviderCmaf settings instead.', ], ], 'SpekeKeyProviderCmaf' => [ 'base' => 'If your output group type is CMAF, use these settings when doing DRM encryption with a SPEKE-compliant key provider. If your output group type is HLS, DASH, or Microsoft Smooth, use the SpekeKeyProvider settings instead.', 'refs' => [ 'CmafEncryptionSettings$SpekeKeyProvider' => 'If your output group type is CMAF, use these settings when doing DRM encryption with a SPEKE-compliant key provider. If your output group type is HLS, DASH, or Microsoft Smooth, use the SpekeKeyProvider settings instead.', ], ], 'StaticKeyProvider' => [ 'base' => 'Use these settings to set up encryption with a static key provider.', 'refs' => [ 'CmafEncryptionSettings$StaticKeyProvider' => 'Use these settings to set up encryption with a static key provider.', 'HlsEncryptionSettings$StaticKeyProvider' => 'Use these settings to set up encryption with a static key provider.', ], ], 'StatusUpdateInterval' => [ 'base' => 'Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins processing your job to the time it completes the transcode or encounters an error.', 'refs' => [ 'CreateJobRequest$StatusUpdateInterval' => 'Optional. Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins processing your job to the time it completes the transcode or encounters an error.', 'CreateJobTemplateRequest$StatusUpdateInterval' => 'Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins processing your job to the time it completes the transcode or encounters an error.', 'Job$StatusUpdateInterval' => 'Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins processing your job to the time it completes the transcode or encounters an error.', 'JobTemplate$StatusUpdateInterval' => 'Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins processing your job to the time it completes the transcode or encounters an error.', 'UpdateJobTemplateRequest$StatusUpdateInterval' => 'Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins processing your job to the time it completes the transcode or encounters an error.', ], ], 'TagResourceRequest' => [ 'base' => 'To add tags to a queue, preset, or job template, send a request with the Amazon Resource Name (ARN) of the resource and the tags that you want to add.', 'refs' => [], ], 'TagResourceResponse' => [ 'base' => 'A successful request to add tags to a resource returns an OK message.', 'refs' => [], ], 'TeletextDestinationSettings' => [ 'base' => 'Settings for Teletext caption output', 'refs' => [ 'CaptionDestinationSettings$TeletextDestinationSettings' => 'Settings for Teletext caption output', ], ], 'TeletextPageType' => [ 'base' => 'A page type as defined in the standard ETSI EN 300 468, Table 94', 'refs' => [ '__listOfTeletextPageType$member' => NULL, ], ], 'TeletextSourceSettings' => [ 'base' => 'Settings specific to Teletext caption sources, including Page number.', 'refs' => [ 'CaptionSourceSettings$TeletextSourceSettings' => 'Settings specific to Teletext caption sources, including Page number.', ], ], 'TimecodeBurnin' => [ 'base' => 'Timecode burn-in (TimecodeBurnIn)--Burns the output timecode and specified prefix into the output.', 'refs' => [ 'VideoPreprocessor$TimecodeBurnin' => 'Timecode burn-in (TimecodeBurnIn)--Burns the output timecode and specified prefix into the output.', ], ], 'TimecodeBurninPosition' => [ 'base' => 'Use Position (Position) under under Timecode burn-in (TimecodeBurnIn) to specify the location the burned-in timecode on output video.', 'refs' => [ 'TimecodeBurnin$Position' => 'Use Position (Position) under under Timecode burn-in (TimecodeBurnIn) to specify the location the burned-in timecode on output video.', ], ], 'TimecodeConfig' => [ 'base' => 'These settings control how the service handles timecodes throughout the job. These settings don\'t affect input clipping.', 'refs' => [ 'JobSettings$TimecodeConfig' => 'Contains settings used to acquire and adjust timecode information from inputs.', 'JobTemplateSettings$TimecodeConfig' => 'Contains settings used to acquire and adjust timecode information from inputs.', ], ], 'TimecodeSource' => [ 'base' => 'Use Source (TimecodeSource) to set how timecodes are handled within this job. To make sure that your video, audio, captions, and markers are synchronized and that time-based features, such as image inserter, work correctly, choose the Timecode source option that matches your assets. All timecodes are in a 24-hour format with frame number (HH:MM:SS:FF). * Embedded (EMBEDDED) - Use the timecode that is in the input video. If no embedded timecode is in the source, the service will use Start at 0 (ZEROBASED) instead. * Start at 0 (ZEROBASED) - Set the timecode of the initial frame to 00:00:00:00. * Specified Start (SPECIFIEDSTART) - Set the timecode of the initial frame to a value other than zero. You use Start timecode (Start) to provide this value.', 'refs' => [ 'TimecodeConfig$Source' => 'Use Source (TimecodeSource) to set how timecodes are handled within this job. To make sure that your video, audio, captions, and markers are synchronized and that time-based features, such as image inserter, work correctly, choose the Timecode source option that matches your assets. All timecodes are in a 24-hour format with frame number (HH:MM:SS:FF). * Embedded (EMBEDDED) - Use the timecode that is in the input video. If no embedded timecode is in the source, the service will use Start at 0 (ZEROBASED) instead. * Start at 0 (ZEROBASED) - Set the timecode of the initial frame to 00:00:00:00. * Specified Start (SPECIFIEDSTART) - Set the timecode of the initial frame to a value other than zero. You use Start timecode (Start) to provide this value.', ], ], 'TimedMetadata' => [ 'base' => 'Applies only to HLS outputs. Use this setting to specify whether the service inserts the ID3 timed metadata from the input in this output.', 'refs' => [ 'M3u8Settings$TimedMetadata' => 'Applies only to HLS outputs. Use this setting to specify whether the service inserts the ID3 timed metadata from the input in this output.', ], ], 'TimedMetadataInsertion' => [ 'base' => 'Enable Timed metadata insertion (TimedMetadataInsertion) to include ID3 tags in your job. To include timed metadata, you must enable it here, enable it in each output container, and specify tags and timecodes in ID3 insertion (Id3Insertion) objects.', 'refs' => [ 'JobSettings$TimedMetadataInsertion' => 'Enable Timed metadata insertion (TimedMetadataInsertion) to include ID3 tags in your job. To include timed metadata, you must enable it here, enable it in each output container, and specify tags and timecodes in ID3 insertion (Id3Insertion) objects.', 'JobTemplateSettings$TimedMetadataInsertion' => 'Enable Timed metadata insertion (TimedMetadataInsertion) to include ID3 tags in your job. To include timed metadata, you must enable it here, enable it in each output container, and specify tags and timecodes in ID3 insertion (Id3Insertion) objects.', ], ], 'Timing' => [ 'base' => 'Information about when jobs are submitted, started, and finished is specified in Unix epoch format in seconds.', 'refs' => [ 'Job$Timing' => 'Information about when jobs are submitted, started, and finished is specified in Unix epoch format in seconds.', ], ], 'TooManyRequestsException' => [ 'base' => NULL, 'refs' => [], ], 'TrackSourceSettings' => [ 'base' => 'Settings specific to caption sources that are specified by track number. Currently, this is only IMSC captions in an IMF package. If your caption source is IMSC 1.1 in a separate xml file, use FileSourceSettings instead of TrackSourceSettings.', 'refs' => [ 'CaptionSourceSettings$TrackSourceSettings' => 'Settings specific to caption sources that are specified by track number. Currently, this is only IMSC captions in an IMF package. If your caption source is IMSC 1.1 in a separate xml file, use FileSourceSettings instead of TrackSourceSettings.', ], ], 'TtmlDestinationSettings' => [ 'base' => 'Settings specific to TTML caption outputs, including Pass style information (TtmlStylePassthrough).', 'refs' => [ 'CaptionDestinationSettings$TtmlDestinationSettings' => 'Settings specific to TTML caption outputs, including Pass style information (TtmlStylePassthrough).', ], ], 'TtmlStylePassthrough' => [ 'base' => 'Pass through style and position information from a TTML-like input source (TTML, SMPTE-TT) to the TTML output.', 'refs' => [ 'TtmlDestinationSettings$StylePassthrough' => 'Pass through style and position information from a TTML-like input source (TTML, SMPTE-TT) to the TTML output.', ], ], 'Type' => [ 'base' => NULL, 'refs' => [ 'JobTemplate$Type' => 'A job template can be of two types: system or custom. System or built-in job templates can\'t be modified or deleted by the user.', 'Preset$Type' => 'A preset can be of two types: system or custom. System or built-in preset can\'t be modified or deleted by the user.', 'Queue$Type' => 'Specifies whether this on-demand queue is system or custom. System queues are built in. You can\'t modify or delete system queues. You can create and modify custom queues.', ], ], 'UntagResourceRequest' => [ 'base' => 'To remove tags from a resource, send a request with the Amazon Resource Name (ARN) of the resource and the keys of the tags that you want to remove.', 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => 'A successful request to remove tags from a resource returns an OK message.', 'refs' => [], ], 'UpdateJobTemplateRequest' => [ 'base' => 'Modify a job template by sending a request with the job template name and any of the following that you wish to change: description, category, and queue.', 'refs' => [], ], 'UpdateJobTemplateResponse' => [ 'base' => 'Successful update job template requests will return the new job template JSON.', 'refs' => [], ], 'UpdatePresetRequest' => [ 'base' => 'Modify a preset by sending a request with the preset name and any of the following that you wish to change: description, category, and transcoding settings.', 'refs' => [], ], 'UpdatePresetResponse' => [ 'base' => 'Successful update preset requests will return the new preset JSON.', 'refs' => [], ], 'UpdateQueueRequest' => [ 'base' => 'Modify a queue by sending a request with the queue name and any changes to the queue.', 'refs' => [], ], 'UpdateQueueResponse' => [ 'base' => 'Successful update queue requests return the new queue information in JSON format.', 'refs' => [], ], 'VideoCodec' => [ 'base' => 'Type of video codec', 'refs' => [ 'VideoCodecSettings$Codec' => 'Specifies the video codec. This must be equal to one of the enum values defined by the object VideoCodec.', ], ], 'VideoCodecSettings' => [ 'base' => 'Video codec settings, (CodecSettings) under (VideoDescription), contains the group of settings related to video encoding. The settings in this group vary depending on the value that you choose for Video codec (Codec). For each codec enum that you choose, define the corresponding settings object. The following lists the codec enum, settings object pairs. * FRAME_CAPTURE, FrameCaptureSettings * AV1, Av1Settings * H_264, H264Settings * H_265, H265Settings * MPEG2, Mpeg2Settings * PRORES, ProresSettings * VP8, Vp8Settings * VP9, Vp9Settings', 'refs' => [ 'VideoDescription$CodecSettings' => 'Video codec settings, (CodecSettings) under (VideoDescription), contains the group of settings related to video encoding. The settings in this group vary depending on the value that you choose for Video codec (Codec). For each codec enum that you choose, define the corresponding settings object. The following lists the codec enum, settings object pairs. * FRAME_CAPTURE, FrameCaptureSettings * AV1, Av1Settings * H_264, H264Settings * H_265, H265Settings * MPEG2, Mpeg2Settings * PRORES, ProresSettings * VP8, Vp8Settings * VP9, Vp9Settings', ], ], 'VideoDescription' => [ 'base' => 'Settings for video outputs', 'refs' => [ 'Output$VideoDescription' => '(VideoDescription) contains a group of video encoding settings. The specific video settings depend on the video codec that you choose when you specify a value for Video codec (codec). Include one instance of (VideoDescription) per output.', 'PresetSettings$VideoDescription' => '(VideoDescription) contains a group of video encoding settings. The specific video settings depend on the video codec that you choose when you specify a value for Video codec (codec). Include one instance of (VideoDescription) per output.', ], ], 'VideoDetail' => [ 'base' => 'Contains details about the output\'s video stream', 'refs' => [ 'OutputDetail$VideoDetails' => 'Contains details about the output\'s video stream', ], ], 'VideoPreprocessor' => [ 'base' => 'Find additional transcoding features under Preprocessors (VideoPreprocessors). Enable the features at each output individually. These features are disabled by default.', 'refs' => [ 'VideoDescription$VideoPreprocessors' => 'Find additional transcoding features under Preprocessors (VideoPreprocessors). Enable the features at each output individually. These features are disabled by default.', ], ], 'VideoSelector' => [ 'base' => 'Selector for video.', 'refs' => [ 'Input$VideoSelector' => 'Selector for video.', 'InputTemplate$VideoSelector' => 'Selector for video.', ], ], 'VideoTimecodeInsertion' => [ 'base' => 'Applies only to H.264, H.265, MPEG2, and ProRes outputs. Only enable Timecode insertion when the input frame rate is identical to the output frame rate. To include timecodes in this output, set Timecode insertion (VideoTimecodeInsertion) to PIC_TIMING_SEI. To leave them out, set it to DISABLED. Default is DISABLED. When the service inserts timecodes in an output, by default, it uses any embedded timecodes from the input. If none are present, the service will set the timecode for the first output frame to zero. To change this default behavior, adjust the settings under Timecode configuration (TimecodeConfig). In the console, these settings are located under Job > Job settings > Timecode configuration. Note - Timecode source under input settings (InputTimecodeSource) does not affect the timecodes that are inserted in the output. Source under Job settings > Timecode configuration (TimecodeSource) does.', 'refs' => [ 'VideoDescription$TimecodeInsertion' => 'Applies only to H.264, H.265, MPEG2, and ProRes outputs. Only enable Timecode insertion when the input frame rate is identical to the output frame rate. To include timecodes in this output, set Timecode insertion (VideoTimecodeInsertion) to PIC_TIMING_SEI. To leave them out, set it to DISABLED. Default is DISABLED. When the service inserts timecodes in an output, by default, it uses any embedded timecodes from the input. If none are present, the service will set the timecode for the first output frame to zero. To change this default behavior, adjust the settings under Timecode configuration (TimecodeConfig). In the console, these settings are located under Job > Job settings > Timecode configuration. Note - Timecode source under input settings (InputTimecodeSource) does not affect the timecodes that are inserted in the output. Source under Job settings > Timecode configuration (TimecodeSource) does.', ], ], 'VorbisSettings' => [ 'base' => 'Required when you set Codec, under AudioDescriptions>CodecSettings, to the value Vorbis.', 'refs' => [ 'AudioCodecSettings$VorbisSettings' => 'Required when you set Codec, under AudioDescriptions>CodecSettings, to the value Vorbis.', ], ], 'Vp8FramerateControl' => [ 'base' => 'If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.', 'refs' => [ 'Vp8Settings$FramerateControl' => 'If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.', ], ], 'Vp8FramerateConversionAlgorithm' => [ 'base' => 'Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use Drop duplicate (DUPLICATE_DROP) conversion. When you choose Interpolate (INTERPOLATE) instead, the conversion produces smoother motion.', 'refs' => [ 'Vp8Settings$FramerateConversionAlgorithm' => 'Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use Drop duplicate (DUPLICATE_DROP) conversion. When you choose Interpolate (INTERPOLATE) instead, the conversion produces smoother motion.', ], ], 'Vp8ParControl' => [ 'base' => 'Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.', 'refs' => [ 'Vp8Settings$ParControl' => 'Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.', ], ], 'Vp8QualityTuningLevel' => [ 'base' => 'Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, multi-pass encoding.', 'refs' => [ 'Vp8Settings$QualityTuningLevel' => 'Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, multi-pass encoding.', ], ], 'Vp8RateControlMode' => [ 'base' => 'With the VP8 codec, you can use only the variable bitrate (VBR) rate control mode.', 'refs' => [ 'Vp8Settings$RateControlMode' => 'With the VP8 codec, you can use only the variable bitrate (VBR) rate control mode.', ], ], 'Vp8Settings' => [ 'base' => 'Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP8.', 'refs' => [ 'VideoCodecSettings$Vp8Settings' => 'Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP8.', ], ], 'Vp9FramerateControl' => [ 'base' => 'If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.', 'refs' => [ 'Vp9Settings$FramerateControl' => 'If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.', ], ], 'Vp9FramerateConversionAlgorithm' => [ 'base' => 'Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use Drop duplicate (DUPLICATE_DROP) conversion. When you choose Interpolate (INTERPOLATE) instead, the conversion produces smoother motion.', 'refs' => [ 'Vp9Settings$FramerateConversionAlgorithm' => 'Optional. Specify how the transcoder performs framerate conversion. The default behavior is to use Drop duplicate (DUPLICATE_DROP) conversion. When you choose Interpolate (INTERPOLATE) instead, the conversion produces smoother motion.', ], ], 'Vp9ParControl' => [ 'base' => 'Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.', 'refs' => [ 'Vp9Settings$ParControl' => 'Optional. Specify how the service determines the pixel aspect ratio for this output. The default behavior is to use the same pixel aspect ratio as your input video.', ], ], 'Vp9QualityTuningLevel' => [ 'base' => 'Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, multi-pass encoding.', 'refs' => [ 'Vp9Settings$QualityTuningLevel' => 'Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, multi-pass encoding.', ], ], 'Vp9RateControlMode' => [ 'base' => 'With the VP9 codec, you can use only the variable bitrate (VBR) rate control mode.', 'refs' => [ 'Vp9Settings$RateControlMode' => 'With the VP9 codec, you can use only the variable bitrate (VBR) rate control mode.', ], ], 'Vp9Settings' => [ 'base' => 'Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP9.', 'refs' => [ 'VideoCodecSettings$Vp9Settings' => 'Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP9.', ], ], 'WatermarkingStrength' => [ 'base' => 'Optional. Ignore this setting unless Nagra support directs you to specify a value. When you don\'t specify a value here, the Nagra NexGuard library uses its default value.', 'refs' => [ 'NexGuardFileMarkerSettings$Strength' => 'Optional. Ignore this setting unless Nagra support directs you to specify a value. When you don\'t specify a value here, the Nagra NexGuard library uses its default value.', ], ], 'WavFormat' => [ 'base' => 'The service defaults to using RIFF for WAV outputs. If your output audio is likely to exceed 4 GB in file size, or if you otherwise need the extended support of the RF64 format, set your output WAV file format to RF64.', 'refs' => [ 'WavSettings$Format' => 'The service defaults to using RIFF for WAV outputs. If your output audio is likely to exceed 4 GB in file size, or if you otherwise need the extended support of the RF64 format, set your output WAV file format to RF64.', ], ], 'WavSettings' => [ 'base' => 'Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value WAV.', 'refs' => [ 'AudioCodecSettings$WavSettings' => 'Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value WAV.', ], ], '__doubleMin0' => [ 'base' => NULL, 'refs' => [ 'Av1Settings$GopSize' => 'Specify the GOP length (keyframe interval) in frames. With AV1, MediaConvert doesn\'t support GOP length in seconds. This value must be greater than zero and preferably equal to 1 + ((numberBFrames + 1) * x), where x is an integer value.', 'H264Settings$GopSize' => 'GOP Length (keyframe interval) in frames or seconds. Must be greater than zero.', 'H265Settings$GopSize' => 'GOP Length (keyframe interval) in frames or seconds. Must be greater than zero.', 'M2tsSettings$FragmentTime' => 'The length, in seconds, of each fragment. Only used with EBP markers.', 'M2tsSettings$NullPacketBitrate' => 'Value in bits per second of extra null packets to insert into the transport stream. This can be used if a downstream encryption system requires periodic null packets.', 'M2tsSettings$SegmentationTime' => 'Specify the length, in seconds, of each segment. Required unless markers is set to _none_.', 'Mpeg2Settings$GopSize' => 'GOP Length (keyframe interval) in frames or seconds. Must be greater than zero.', 'Vp8Settings$GopSize' => 'GOP Length (keyframe interval) in frames. Must be greater than zero.', 'Vp9Settings$GopSize' => 'GOP Length (keyframe interval) in frames. Must be greater than zero.', ], ], '__doubleMin0Max1' => [ 'base' => NULL, 'refs' => [ 'Av1QvbrSettings$QvbrQualityLevelFineTune' => 'Optional. Specify a value here to set the QVBR quality to a level that is between whole numbers. For example, if you want your QVBR quality level to be 7.33, set qvbrQualityLevel to 7 and set qvbrQualityLevelFineTune to .33. MediaConvert rounds your QVBR quality level to the nearest third of a whole number. For example, if you set qvbrQualityLevel to 7 and you set qvbrQualityLevelFineTune to .25, your actual QVBR quality level is 7.33.', 'H264QvbrSettings$QvbrQualityLevelFineTune' => 'Optional. Specify a value here to set the QVBR quality to a level that is between whole numbers. For example, if you want your QVBR quality level to be 7.33, set qvbrQualityLevel to 7 and set qvbrQualityLevelFineTune to .33. MediaConvert rounds your QVBR quality level to the nearest third of a whole number. For example, if you set qvbrQualityLevel to 7 and you set qvbrQualityLevelFineTune to .25, your actual QVBR quality level is 7.33.', 'H265QvbrSettings$QvbrQualityLevelFineTune' => 'Optional. Specify a value here to set the QVBR quality to a level that is between whole numbers. For example, if you want your QVBR quality level to be 7.33, set qvbrQualityLevel to 7 and set qvbrQualityLevelFineTune to .33. MediaConvert rounds your QVBR quality level to the nearest third of a whole number. For example, if you set qvbrQualityLevel to 7 and you set qvbrQualityLevelFineTune to .25, your actual QVBR quality level is 7.33.', ], ], '__doubleMin0Max2147483647' => [ 'base' => NULL, 'refs' => [ 'CmafGroupSettings$MinFinalSegmentLength' => 'Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices play back the end of your video asset. If you know that player devices are hanging on the final segment of your video because the length of your final segment is too short, use this setting to specify a minimum final segment length, in seconds. Choose a value that is greater than or equal to 1 and less than your segment length. When you specify a value for this setting, the encoder will combine any final segment that is shorter than the length that you specify with the previous segment. For example, your segment length is 3 seconds and your final segment is .5 seconds without a minimum final segment length; when you set the minimum final segment length to 1, your final segment is 3.5 seconds.', 'HlsGroupSettings$MinFinalSegmentLength' => 'Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices play back the end of your video asset. If you know that player devices are hanging on the final segment of your video because the length of your final segment is too short, use this setting to specify a minimum final segment length, in seconds. Choose a value that is greater than or equal to 1 and less than your segment length. When you specify a value for this setting, the encoder will combine any final segment that is shorter than the length that you specify with the previous segment. For example, your segment length is 3 seconds and your final segment is .5 seconds without a minimum final segment length; when you set the minimum final segment length to 1, your final segment is 3.5 seconds.', ], ], '__doubleMinNegative59Max0' => [ 'base' => NULL, 'refs' => [ 'AudioNormalizationSettings$TargetLkfs' => 'When you use Audio normalization (AudioNormalizationSettings), optionally use this setting to specify a target loudness. If you don\'t specify a value here, the encoder chooses a value for you, based on the algorithm that you choose for Algorithm (algorithm). If you choose algorithm 1770-1, the encoder will choose -24 LKFS; otherwise, the encoder will choose -23 LKFS.', ], ], '__doubleMinNegative60Max3' => [ 'base' => NULL, 'refs' => [ 'Eac3Settings$LoRoCenterMixLevel' => 'Specify a value for the following Dolby Digital Plus setting: Left only/Right only center mix (Lo/Ro center). MediaConvert uses this value for downmixing. How the service uses this value depends on the value that you choose for Stereo downmix (Eac3StereoDownmix). Valid values: 3.0, 1.5, 0.0, -1.5, -3.0, -4.5, -6.0, and -60. The value -60 mutes the channel. This setting applies only if you keep the default value of 3/2 - L, R, C, Ls, Rs (CODING_MODE_3_2) for the setting Coding mode (Eac3CodingMode). If you choose a different value for Coding mode, the service ignores Left only/Right only center (loRoCenterMixLevel).', 'Eac3Settings$LtRtCenterMixLevel' => 'Specify a value for the following Dolby Digital Plus setting: Left total/Right total center mix (Lt/Rt center). MediaConvert uses this value for downmixing. How the service uses this value depends on the value that you choose for Stereo downmix (Eac3StereoDownmix). Valid values: 3.0, 1.5, 0.0, -1.5, -3.0, -4.5, -6.0, and -60. The value -60 mutes the channel. This setting applies only if you keep the default value of 3/2 - L, R, C, Ls, Rs (CODING_MODE_3_2) for the setting Coding mode (Eac3CodingMode). If you choose a different value for Coding mode, the service ignores Left total/Right total center (ltRtCenterMixLevel).', ], ], '__doubleMinNegative60MaxNegative1' => [ 'base' => NULL, 'refs' => [ 'Eac3AtmosSettings$LoRoSurroundMixLevel' => 'Specify a value for the following Dolby Atmos setting: Left only/Right only (Lo/Ro surround). MediaConvert uses this value for downmixing. How the service uses this value depends on the value that you choose for Stereo downmix (Eac3AtmosStereoDownmix). Valid values: -1.5, -3.0, -4.5, -6.0, and -60. The value -60 mutes the channel.', 'Eac3AtmosSettings$LtRtSurroundMixLevel' => 'Specify a value for the following Dolby Atmos setting: Left total/Right total surround mix (Lt/Rt surround). MediaConvert uses this value for downmixing. How the service uses this value depends on the value that you choose for Stereo downmix (Eac3AtmosStereoDownmix). Valid values: -1.5, -3.0, -4.5, -6.0, and -60. The value -60 mutes the channel.', 'Eac3Settings$LoRoSurroundMixLevel' => 'Specify a value for the following Dolby Digital Plus setting: Left only/Right only (Lo/Ro surround). MediaConvert uses this value for downmixing. How the service uses this value depends on the value that you choose for Stereo downmix (Eac3StereoDownmix). Valid values: -1.5, -3.0, -4.5, -6.0, and -60. The value -60 mutes the channel. This setting applies only if you keep the default value of 3/2 - L, R, C, Ls, Rs (CODING_MODE_3_2) for the setting Coding mode (Eac3CodingMode). If you choose a different value for Coding mode, the service ignores Left only/Right only surround (loRoSurroundMixLevel).', 'Eac3Settings$LtRtSurroundMixLevel' => 'Specify a value for the following Dolby Digital Plus setting: Left total/Right total surround mix (Lt/Rt surround). MediaConvert uses this value for downmixing. How the service uses this value depends on the value that you choose for Stereo downmix (Eac3StereoDownmix). Valid values: -1.5, -3.0, -4.5, -6.0, and -60. The value -60 mutes the channel. This setting applies only if you keep the default value of 3/2 - L, R, C, Ls, Rs (CODING_MODE_3_2) for the setting Coding mode (Eac3CodingMode). If you choose a different value for Coding mode, the service ignores Left total/Right total surround (ltRtSurroundMixLevel).', ], ], '__doubleMinNegative6Max3' => [ 'base' => NULL, 'refs' => [ 'Eac3AtmosSettings$LoRoCenterMixLevel' => 'Specify a value for the following Dolby Atmos setting: Left only/Right only center mix(Lo/Ro center). MediaConvert uses this value for downmixing. How the service uses thisvalue depends on the value that you choose for Stereo downmix (Eac3AtmosStereoDownmix).Valid values: 3.0, 1.5, 0.0, -1.5, -3.0, -4.5, and -6.0.', 'Eac3AtmosSettings$LtRtCenterMixLevel' => 'Specify a value for the following Dolby Atmos setting: Left total/Right total center mix (Lt/Rt center). MediaConvert uses this value for downmixing. How the service uses this value depends on the value that you choose for Stereo downmix (Eac3AtmosStereoDownmix). Valid values: 3.0, 1.5, 0.0, -1.5, -3.0, -4.5, and -6.0.', ], ], '__integer' => [ 'base' => NULL, 'refs' => [ 'DescribeEndpointsRequest$MaxResults' => 'Optional. Max number of endpoints, up to twenty, that will be returned at one time.', 'HopDestination$WaitMinutes' => 'Required for setting up a job to use queue hopping. Minimum wait time in minutes until the job can hop to the destination queue. Valid range is 1 to 1440 minutes, inclusive.', 'Job$ErrorCode' => 'Error code for the job', 'Job$JobPercentComplete' => 'An estimate of how far your job has progressed. This estimate is shown as a percentage of the total time from when your job leaves its queue to when your output files appear in your output Amazon S3 bucket. AWS Elemental MediaConvert provides jobPercentComplete in CloudWatch STATUS_UPDATE events and in the response to GetJob and ListJobs requests. The jobPercentComplete estimate is reliable for the following input containers: Quicktime, Transport Stream, MP4, and MXF. For some jobs, the service can\'t provide information about job progress. In those cases, jobPercentComplete returns a null value.', 'Job$RetryCount' => 'The number of times that the service automatically attempted to process your job after encountering an error.', 'OutputDetail$DurationInMs' => 'Duration in milliseconds', 'ReservationPlan$ReservedSlots' => 'Specifies the number of reserved transcode slots (RTS) for this queue. The number of RTS determines how many jobs the queue can process in parallel; each RTS can process one job at a time. When you increase this number, you extend your existing commitment with a new 12-month commitment for a larger number of RTS. The new commitment begins when you purchase the additional capacity. You can\'t decrease the number of RTS in your reserved queue.', 'ReservationPlanSettings$ReservedSlots' => 'Specifies the number of reserved transcode slots (RTS) for this queue. The number of RTS determines how many jobs the queue can process in parallel; each RTS can process one job at a time. You can\'t decrease the number of RTS in your reserved queue. You can increase the number of RTS by extending your existing commitment with a new 12-month commitment for the larger number. The new commitment begins when you purchase the additional capacity. You can\'t cancel your commitment or revert to your original commitment after you increase the capacity.', 'VideoDetail$HeightInPx' => 'Height in pixels for the output', 'VideoDetail$WidthInPx' => 'Width in pixels for the output', 'Queue$ProgressingJobsCount' => 'The estimated number of jobs with a PROGRESSING status.', 'Queue$SubmittedJobsCount' => 'The estimated number of jobs with a SUBMITTED status.', ], ], '__integerMin0Max0' => [ 'base' => NULL, 'refs' => [ 'NielsenConfiguration$BreakoutCode' => 'Nielsen has discontinued the use of breakout code functionality. If you must include this property, set the value to zero.', ], ], '__integerMin0Max1' => [ 'base' => NULL, 'refs' => [ 'Mp4Settings$CttsVersion' => 'Ignore this setting unless compliance to the CTTS box version specification matters in your workflow. Specify a value of 1 to set your CTTS box version to 1 and make your output compliant with the specification. When you specify a value of 1, you must also set CSLG atom (cslgAtom) to the value INCLUDE. Keep the default value 0 to set your CTTS box version to 0. This can provide backward compatibility for some players and packagers.', ], ], '__integerMin0Max10' => [ 'base' => NULL, 'refs' => [ 'BurninDestinationSettings$OutlineSize' => 'Specifies font outline size in pixels. This option is not valid for source captions that are either 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.', 'DvbSubDestinationSettings$OutlineSize' => 'Specifies font outline size in pixels. This option is not valid for source captions that are either 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.', ], ], '__integerMin0Max100' => [ 'base' => NULL, 'refs' => [ 'H264Settings$HrdBufferInitialFillPercentage' => 'Percentage of the buffer that should initially be filled (HRD buffer model).', 'H265Settings$HrdBufferInitialFillPercentage' => 'Percentage of the buffer that should initially be filled (HRD buffer model).', 'InsertableImage$Opacity' => 'Use Opacity (Opacity) to specify how much of the underlying video shows through the inserted image. 0 is transparent and 100 is fully opaque. Default is 50.', 'Mpeg2Settings$HrdBufferInitialFillPercentage' => 'Percentage of the buffer that should initially be filled (HRD buffer model).', 'VideoDescription$Sharpness' => 'Use Sharpness (Sharpness) setting to specify the strength of anti-aliasing. This setting changes the width of the anti-alias filter kernel used for scaling. Sharpness only applies if your output resolution is different from your input resolution. 0 is the softest setting, 100 the sharpest, and 50 recommended for most content.', ], ], '__integerMin0Max1000' => [ 'base' => NULL, 'refs' => [ 'M2tsSettings$PatInterval' => 'The number of milliseconds between instances of this table in the output transport stream.', 'M2tsSettings$PmtInterval' => 'Specify the number of milliseconds between instances of the program map table (PMT) in the output transport stream.', 'M3u8Settings$PatInterval' => 'The number of milliseconds between instances of this table in the output transport stream.', 'M3u8Settings$PmtInterval' => 'The number of milliseconds between instances of this table in the output transport stream.', ], ], '__integerMin0Max10000' => [ 'base' => NULL, 'refs' => [ 'M2tsSettings$MinEbpInterval' => 'When set, enforces that Encoder Boundary Points do not come within the specified time interval of each other by looking ahead at input video. If another EBP is going to come in within the specified time interval, the current EBP is not emitted, and the segment is "stretched" to the next marker. The lookahead value does not add latency to the system. The Live Event must be configured elsewhere to create sufficient latency to make the lookahead accurate.', ], ], '__integerMin0Max1152000000' => [ 'base' => NULL, 'refs' => [ 'H264Settings$HrdBufferSize' => 'Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.', ], ], '__integerMin0Max128' => [ 'base' => NULL, 'refs' => [ 'H264Settings$Softness' => 'Softness. Selects quantizer matrix, larger values reduce high-frequency content in the encoded image.', 'Mpeg2Settings$Softness' => 'Softness. Selects quantizer matrix, larger values reduce high-frequency content in the encoded image.', ], ], '__integerMin0Max1466400000' => [ 'base' => NULL, 'refs' => [ 'H265Settings$HrdBufferSize' => 'Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.', ], ], '__integerMin0Max15' => [ 'base' => NULL, 'refs' => [ 'VideoDescription$FixedAfd' => 'Applies only if you set AFD Signaling(AfdSignaling) to Fixed (FIXED). Use Fixed (FixedAfd) to specify a four-bit AFD value which the service will write on all frames of this video output.', ], ], '__integerMin0Max16' => [ 'base' => NULL, 'refs' => [ 'NoiseReducerSpatialFilterSettings$Strength' => 'Relative strength of noise reducing filter. Higher values produce stronger filtering.', 'NoiseReducerTemporalFilterSettings$Strength' => 'Specify the strength of the noise reducing filter on this output. Higher values produce stronger filtering. We recommend the following value ranges, depending on the result that you want: * 0-2 for complexity reduction with minimal sharpness loss * 2-8 for complexity reduction with image preservation * 8-16 for a high level of complexity reduction', ], ], '__integerMin0Max2147483647' => [ 'base' => NULL, 'refs' => [ 'BurninDestinationSettings$XPosition' => 'Specifies the horizontal position of the caption relative to the left side of the output in pixels. A value of 10 would result in the captions starting 10 pixels from the left of the output. If no explicit x_position is provided, the horizontal caption position will be determined by the alignment parameter. This option is not valid for source captions that are STL, 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.', 'BurninDestinationSettings$YPosition' => 'Specifies the vertical position of the caption relative to the top of the output in pixels. A value of 10 would result in the captions starting 10 pixels from the top of the output. If no explicit y_position is provided, the caption will be positioned towards the bottom of the output. This option is not valid for source captions that are STL, 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.', 'CmafGroupSettings$MinBufferTime' => 'Minimum time of initially buffered media that is needed to ensure smooth playout.', 'DashIsoGroupSettings$MinBufferTime' => 'Minimum time of initially buffered media that is needed to ensure smooth playout.', 'DvbSubDestinationSettings$XPosition' => 'Specifies the horizontal position of the caption relative to the left side of the output in pixels. A value of 10 would result in the captions starting 10 pixels from the left of the output. If no explicit x_position is provided, the horizontal caption position will be determined by the alignment parameter. This option is not valid for source captions that are STL, 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.', 'DvbSubDestinationSettings$YPosition' => 'Specifies the vertical position of the caption relative to the top of the output in pixels. A value of 10 would result in the captions starting 10 pixels from the top of the output. If no explicit y_position is provided, the caption will be positioned towards the bottom of the output. This option is not valid for source captions that are STL, 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.', 'H264Settings$GopClosedCadence' => 'Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.', 'H265Settings$GopClosedCadence' => 'Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.', 'Hdr10Metadata$MaxLuminance' => 'Nominal maximum mastering display luminance in units of of 0.0001 candelas per square meter.', 'Hdr10Metadata$MinLuminance' => 'Nominal minimum mastering display luminance in units of of 0.0001 candelas per square meter', 'HlsGroupSettings$MinSegmentLength' => 'When set, Minimum Segment Size is enforced by looking ahead and back within the specified range for a nearby avail and extending the segment size if needed.', 'InsertableImage$Duration' => 'Specify the time, in milliseconds, for the image to remain on the output video. This duration includes fade-in time but not fade-out time.', 'InsertableImage$FadeIn' => 'Specify the length of time, in milliseconds, between the Start time that you specify for the image insertion and the time that the image appears at full opacity. Full opacity is the level that you specify for the opacity setting. If you don\'t specify a value for Fade-in, the image will appear abruptly at the overlay start time.', 'InsertableImage$FadeOut' => 'Specify the length of time, in milliseconds, between the end of the time that you have specified for the image overlay Duration and when the overlaid image has faded to total transparency. If you don\'t specify a value for Fade-out, the image will disappear abruptly at the end of the inserted image duration.', 'InsertableImage$Height' => 'Specify the height of the inserted image in pixels. If you specify a value that\'s larger than the video resolution height, the service will crop your overlaid image to fit. To use the native height of the image, keep this setting blank.', 'InsertableImage$ImageX' => 'Specify the distance, in pixels, between the inserted image and the left edge of the video frame. Required for any image overlay that you specify.', 'InsertableImage$ImageY' => 'Specify the distance, in pixels, between the overlaid image and the top edge of the video frame. Required for any image overlay that you specify.', 'InsertableImage$Width' => 'Specify the width of the inserted image in pixels. If you specify a value that\'s larger than the video resolution width, the service will crop your overlaid image to fit. To use the native width of the image, keep this setting blank.', 'M2tsSettings$AudioFramesPerPes' => 'The number of audio frames to insert for each PES packet.', 'M2tsSettings$Bitrate' => 'Specify the output bitrate of the transport stream in bits per second. Setting to 0 lets the muxer automatically determine the appropriate bitrate. Other common values are 3750000, 7500000, and 15000000.', 'M3u8Settings$AudioFramesPerPes' => 'The number of audio frames to insert for each PES packet.', 'MotionImageInsertionOffset$ImageX' => 'Set the distance, in pixels, between the overlay and the left edge of the video frame.', 'MotionImageInsertionOffset$ImageY' => 'Set the distance, in pixels, between the overlay and the top edge of the video frame.', 'Mpeg2Settings$GopClosedCadence' => 'Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.', 'Rectangle$X' => 'The distance, in pixels, between the rectangle and the left edge of the video frame. Specify only even numbers.', 'Rectangle$Y' => 'The distance, in pixels, between the rectangle and the top edge of the video frame. Specify only even numbers.', ], ], '__integerMin0Max255' => [ 'base' => NULL, 'refs' => [ 'AudioDescription$AudioType' => 'Applies only if Follow Input Audio Type is unchecked (false). A number between 0 and 255. The following are defined in ISO-IEC 13818-1: 0 = Undefined, 1 = Clean Effects, 2 = Hearing Impaired, 3 = Visually Impaired Commentary, 4-255 = Reserved.', 'BurninDestinationSettings$BackgroundOpacity' => 'Specifies the opacity of the background rectangle. 255 is opaque; 0 is transparent. Leaving this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.', 'BurninDestinationSettings$FontOpacity' => 'Specifies the opacity of the burned-in captions. 255 is opaque; 0 is transparent.All burn-in and DVB-Sub font settings must match.', 'BurninDestinationSettings$ShadowOpacity' => 'Specifies the opacity of the shadow. 255 is opaque; 0 is transparent. Leaving this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.', 'DvbSubDestinationSettings$BackgroundOpacity' => 'Specifies the opacity of the background rectangle. 255 is opaque; 0 is transparent. Leaving this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.', 'DvbSubDestinationSettings$FontOpacity' => 'Specifies the opacity of the burned-in captions. 255 is opaque; 0 is transparent.All burn-in and DVB-Sub font settings must match.', 'DvbSubDestinationSettings$ShadowOpacity' => 'Specifies the opacity of the shadow. 255 is opaque; 0 is transparent. Leaving this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.', ], ], '__integerMin0Max3' => [ 'base' => NULL, 'refs' => [ 'NoiseReducerFilterSettings$Strength' => 'Relative strength of noise reducing filter. Higher values produce stronger filtering.', 'NoiseReducerSpatialFilterSettings$PostFilterSharpenStrength' => 'Specify strength of post noise reduction sharpening filter, with 0 disabling the filter and 3 enabling it at maximum strength.', ], ], '__integerMin0Max30' => [ 'base' => NULL, 'refs' => [ 'H264Settings$MinIInterval' => 'Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence resumes for the next GOP. This setting is only used when Scene Change Detect is enabled. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1', 'H265Settings$MinIInterval' => 'Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence resumes for the next GOP. This setting is only used when Scene Change Detect is enabled. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1', 'Mpeg2Settings$MinIInterval' => 'Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence resumes for the next GOP. This setting is only used when Scene Change Detect is enabled. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1', ], ], '__integerMin0Max30000' => [ 'base' => NULL, 'refs' => [ 'EsamSettings$ResponseSignalPreroll' => 'Specifies the stream distance, in milliseconds, between the SCTE 35 messages that the transcoder places and the splice points that they refer to. If the time between the start of the asset and the SCTE-35 message is less than this value, then the transcoder places the SCTE-35 marker at the beginning of the stream.', ], ], '__integerMin0Max3600' => [ 'base' => NULL, 'refs' => [ 'HlsGroupSettings$ProgramDateTimePeriod' => 'Period of insertion of EXT-X-PROGRAM-DATE-TIME entry, in seconds.', ], ], '__integerMin0Max4' => [ 'base' => NULL, 'refs' => [ 'NoiseReducerTemporalFilterSettings$AggressiveMode' => 'Use Aggressive mode for content that has complex motion. Higher values produce stronger temporal filtering. This filters highly complex scenes more aggressively and creates better VQ for low bitrate outputs.', ], ], '__integerMin0Max4194303' => [ 'base' => NULL, 'refs' => [ 'NexGuardFileMarkerSettings$Payload' => 'Specify the payload ID that you want associated with this output. Valid values vary depending on your Nagra NexGuard forensic watermarking workflow. Required when you include Nagra NexGuard File Marker watermarking (NexGuardWatermarkingSettings) in your job. For PreRelease Content (NGPR/G2), specify an integer from 1 through 4,194,303. You must generate a unique ID for each asset you watermark, and keep a record of which ID you have assigned to each asset. Neither Nagra nor MediaConvert keep track of the relationship between output files and your IDs. For OTT Streaming, create two adaptive bitrate (ABR) stacks for each asset. Do this by setting up two output groups. For one output group, set the value of Payload ID (payload) to 0 in every output. For the other output group, set Payload ID (payload) to 1 in every output.', ], ], '__integerMin0Max47185920' => [ 'base' => NULL, 'refs' => [ 'Mpeg2Settings$HrdBufferSize' => 'Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.', 'Vp8Settings$HrdBufferSize' => 'Optional. Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.', 'Vp9Settings$HrdBufferSize' => 'Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.', ], ], '__integerMin0Max500' => [ 'base' => NULL, 'refs' => [ 'M2tsSettings$MaxPcrInterval' => 'Specify the maximum time, in milliseconds, between Program Clock References (PCRs) inserted into the transport stream.', ], ], '__integerMin0Max50000' => [ 'base' => NULL, 'refs' => [ 'Hdr10Metadata$BluePrimaryX' => 'HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.', 'Hdr10Metadata$BluePrimaryY' => 'HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.', 'Hdr10Metadata$GreenPrimaryX' => 'HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.', 'Hdr10Metadata$GreenPrimaryY' => 'HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.', 'Hdr10Metadata$RedPrimaryX' => 'HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.', 'Hdr10Metadata$RedPrimaryY' => 'HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.', 'Hdr10Metadata$WhitePointX' => 'HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.', 'Hdr10Metadata$WhitePointY' => 'HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.', ], ], '__integerMin0Max65535' => [ 'base' => NULL, 'refs' => [ 'DolbyVisionLevel6Metadata$MaxCll' => 'Maximum Content Light Level. Static HDR metadata that corresponds to the brightest pixel in the entire stream. Measured in nits.', 'DolbyVisionLevel6Metadata$MaxFall' => 'Maximum Frame-Average Light Level. Static HDR metadata that corresponds to the highest frame-average brightness in the entire stream. Measured in nits.', 'DvbNitSettings$NetworkId' => 'The numeric value placed in the Network Information Table (NIT).', 'Hdr10Metadata$MaxContentLightLevel' => 'Maximum light level among all samples in the coded video sequence, in units of candelas per square meter. This setting doesn\'t have a default value; you must specify a value that is suitable for the content.', 'Hdr10Metadata$MaxFrameAverageLightLevel' => 'Maximum average light level of any frame in the coded video sequence, in units of candelas per square meter. This setting doesn\'t have a default value; you must specify a value that is suitable for the content.', 'M2tsSettings$ProgramNumber' => 'Use Program number (programNumber) to specify the program number used in the program map table (PMT) for this output. Default is 1. Program numbers and program map tables are parts of MPEG-2 transport stream containers, used for organizing data.', 'M2tsSettings$TransportStreamId' => 'Specify the ID for the transport stream itself in the program map table for this output. Transport stream IDs and program map tables are parts of MPEG-2 transport stream containers, used for organizing data.', 'M3u8Settings$ProgramNumber' => 'The value of the program number field in the Program Map Table.', 'M3u8Settings$TransportStreamId' => 'The value of the transport stream ID field in the Program Map Table.', ], ], '__integerMin0Max7' => [ 'base' => NULL, 'refs' => [ 'H264Settings$NumberBFramesBetweenReferenceFrames' => 'Number of B-frames between reference frames.', 'H265Settings$NumberBFramesBetweenReferenceFrames' => 'Number of B-frames between reference frames.', 'Mpeg2Settings$NumberBFramesBetweenReferenceFrames' => 'Number of B-frames between reference frames.', ], ], '__integerMin0Max8' => [ 'base' => NULL, 'refs' => [ 'AudioSelector$ProgramSelection' => 'Use this setting for input streams that contain Dolby E, to have the service extract specific program data from the track. To select multiple programs, create multiple selectors with the same Track and different Program numbers. In the console, this setting is visible when you set Selector type to Track. Choose the program number from the dropdown list. If you are sending a JSON file, provide the program ID, which is part of the audio metadata. If your input file has incorrect metadata, you can choose All channels instead of a program number to have the service ignore the program IDs and include all the programs in the track.', ], ], '__integerMin0Max9' => [ 'base' => NULL, 'refs' => [ 'Mp3Settings$VbrQuality' => 'Required when you set Bitrate control mode (rateControlMode) to VBR. Specify the audio quality of this MP3 output from 0 (highest quality) to 9 (lowest quality).', ], ], '__integerMin0Max96' => [ 'base' => NULL, 'refs' => [ 'BurninDestinationSettings$FontSize' => 'A positive integer indicates the exact font size in points. Set to 0 for automatic font size selection. All burn-in and DVB-Sub font settings must match.', 'DvbSubDestinationSettings$FontSize' => 'A positive integer indicates the exact font size in points. Set to 0 for automatic font size selection. All burn-in and DVB-Sub font settings must match.', ], ], '__integerMin0Max99' => [ 'base' => NULL, 'refs' => [ 'InsertableImage$Layer' => 'Specify how overlapping inserted images appear. Images with higher values for Layer appear on top of images with lower values for Layer.', ], ], '__integerMin1000Max1152000000' => [ 'base' => NULL, 'refs' => [ 'Av1Settings$MaxBitrate' => 'Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when Rate control mode is QVBR.', 'H264QvbrSettings$MaxAverageBitrate' => 'Use this setting only when Rate control mode is QVBR and Quality tuning level is Multi-pass HQ. For Max average bitrate values suited to the complexity of your input video, the service limits the average bitrate of the video part of this output to the value that you choose. That is, the total size of the video element is less than or equal to the value you set multiplied by the number of seconds of encoded output.', 'H264Settings$Bitrate' => 'Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates must be unique when rounded down to the nearest multiple of 1000.', 'H264Settings$MaxBitrate' => 'Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when Rate control mode is QVBR.', 'Vp8Settings$Bitrate' => 'Target bitrate in bits/second. For example, enter five megabits per second as 5000000.', 'Vp8Settings$MaxBitrate' => 'Ignore this setting unless you set qualityTuningLevel to MULTI_PASS. Optional. Specify the maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. The default behavior uses twice the target bitrate as the maximum bitrate.', ], ], '__integerMin1000Max1466400000' => [ 'base' => NULL, 'refs' => [ 'H265QvbrSettings$MaxAverageBitrate' => 'Use this setting only when Rate control mode is QVBR and Quality tuning level is Multi-pass HQ. For Max average bitrate values suited to the complexity of your input video, the service limits the average bitrate of the video part of this output to the value that you choose. That is, the total size of the video element is less than or equal to the value you set multiplied by the number of seconds of encoded output.', 'H265Settings$Bitrate' => 'Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates must be unique when rounded down to the nearest multiple of 1000.', 'H265Settings$MaxBitrate' => 'Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when Rate control mode is QVBR.', ], ], '__integerMin1000Max288000000' => [ 'base' => NULL, 'refs' => [ 'Mpeg2Settings$Bitrate' => 'Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates must be unique when rounded down to the nearest multiple of 1000.', ], ], '__integerMin1000Max30000' => [ 'base' => NULL, 'refs' => [ 'DvbTdtSettings$TdtInterval' => 'The number of milliseconds between instances of this table in the output transport stream.', ], ], '__integerMin1000Max300000000' => [ 'base' => NULL, 'refs' => [ 'Mpeg2Settings$MaxBitrate' => 'Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000.', ], ], '__integerMin1000Max480000000' => [ 'base' => NULL, 'refs' => [ 'Vp9Settings$Bitrate' => 'Target bitrate in bits/second. For example, enter five megabits per second as 5000000.', 'Vp9Settings$MaxBitrate' => 'Ignore this setting unless you set qualityTuningLevel to MULTI_PASS. Optional. Specify the maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. The default behavior uses twice the target bitrate as the maximum bitrate.', ], ], '__integerMin10Max48' => [ 'base' => NULL, 'refs' => [ 'TimecodeBurnin$FontSize' => 'Use Font Size (FontSize) to set the font size of any burned-in timecode. Valid values are 10, 16, 32, 48.', ], ], '__integerMin16000Max320000' => [ 'base' => NULL, 'refs' => [ 'Mp3Settings$Bitrate' => 'Specify the average bitrate in bits per second.', ], ], '__integerMin16000Max48000' => [ 'base' => NULL, 'refs' => [ 'OpusSettings$SampleRate' => 'Optional. Sample rate in hz. Valid values are 16000, 24000, and 48000. The default value is 48000.', ], ], '__integerMin16Max24' => [ 'base' => NULL, 'refs' => [ 'AiffSettings$BitDepth' => 'Specify Bit depth (BitDepth), in bits per sample, to choose the encoding quality for this audio track.', 'WavSettings$BitDepth' => 'Specify Bit depth (BitDepth), in bits per sample, to choose the encoding quality for this audio track.', ], ], '__integerMin1Max1' => [ 'base' => NULL, 'refs' => [ 'EmbeddedSourceSettings$Source608TrackNumber' => 'Specifies the video track index used for extracting captions. The system only supports one input video track, so this should always be set to \'1\'.', ], ], '__integerMin1Max10' => [ 'base' => NULL, 'refs' => [ 'Av1QvbrSettings$QvbrQualityLevel' => 'Required when you use QVBR rate control mode. That is, when you specify qvbrSettings within av1Settings. Specify the general target quality level for this output, from 1 to 10. Use higher numbers for greater quality. Level 10 results in nearly lossless compression. The quality level for most broadcast-quality transcodes is between 6 and 9. Optionally, to specify a value between whole numbers, also provide a value for the setting qvbrQualityLevelFineTune. For example, if you want your QVBR quality level to be 7.33, set qvbrQualityLevel to 7 and set qvbrQualityLevelFineTune to .33.', 'H264QvbrSettings$QvbrQualityLevel' => 'Required when you use QVBR rate control mode. That is, when you specify qvbrSettings within h264Settings. Specify the general target quality level for this output, from 1 to 10. Use higher numbers for greater quality. Level 10 results in nearly lossless compression. The quality level for most broadcast-quality transcodes is between 6 and 9. Optionally, to specify a value between whole numbers, also provide a value for the setting qvbrQualityLevelFineTune. For example, if you want your QVBR quality level to be 7.33, set qvbrQualityLevel to 7 and set qvbrQualityLevelFineTune to .33.', 'H265QvbrSettings$QvbrQualityLevel' => 'Required when you use QVBR rate control mode. That is, when you specify qvbrSettings within h265Settings. Specify the general target quality level for this output, from 1 to 10. Use higher numbers for greater quality. Level 10 results in nearly lossless compression. The quality level for most broadcast-quality transcodes is between 6 and 9. Optionally, to specify a value between whole numbers, also provide a value for the setting qvbrQualityLevelFineTune. For example, if you want your QVBR quality level to be 7.33, set qvbrQualityLevel to 7 and set qvbrQualityLevelFineTune to .33.', ], ], '__integerMin1Max100' => [ 'base' => NULL, 'refs' => [ 'ColorCorrector$Brightness' => 'Brightness level.', 'ColorCorrector$Contrast' => 'Contrast level.', 'ColorCorrector$Saturation' => 'Saturation level.', 'Eac3AtmosSettings$SpeechThreshold' => 'Specify the percentage of audio content that must be speech before the encoder uses the measured speech loudness as the overall program loudness.', 'FrameCaptureSettings$Quality' => 'JPEG Quality - a higher value equals higher quality.', ], ], '__integerMin1Max10000000' => [ 'base' => NULL, 'refs' => [ 'FrameCaptureSettings$MaxCaptures' => 'Maximum number of captures (encoded jpg output files).', ], ], '__integerMin1Max1001' => [ 'base' => NULL, 'refs' => [ 'CaptionSourceFramerate$FramerateDenominator' => 'Specify the denominator of the fraction that represents the frame rate for the setting Caption source frame rate (CaptionSourceFramerate). Use this setting along with the setting Framerate numerator (framerateNumerator).', 'Mpeg2Settings$FramerateDenominator' => 'Frame rate denominator.', ], ], '__integerMin1Max17895697' => [ 'base' => NULL, 'refs' => [ 'MotionImageInsertionFramerate$FramerateDenominator' => 'The bottom of the fraction that expresses your overlay frame rate. For example, if your frame rate is 24 fps, set this value to 1.', ], ], '__integerMin1Max2' => [ 'base' => NULL, 'refs' => [ 'Mp2Settings$Channels' => 'Set Channels to specify the number of channels in this output audio track. Choosing Mono in the console will give you 1 output channel; choosing Stereo will give you 2. In the API, valid values are 1 and 2.', 'Mp3Settings$Channels' => 'Specify the number of channels in this output audio track. Choosing Mono on the console gives you 1 output channel; choosing Stereo gives you 2. In the API, valid values are 1 and 2.', 'OpusSettings$Channels' => 'Specify the number of channels in this output audio track. Choosing Mono on the console gives you 1 output channel; choosing Stereo gives you 2. In the API, valid values are 1 and 2.', 'VorbisSettings$Channels' => 'Optional. Specify the number of channels in this output audio track. Choosing Mono on the console gives you 1 output channel; choosing Stereo gives you 2. In the API, valid values are 1 and 2. The default value is 2.', ], ], '__integerMin1Max20' => [ 'base' => NULL, 'refs' => [ 'ListJobTemplatesRequest$MaxResults' => 'Optional. Number of job templates, up to twenty, that will be returned at one time.', 'ListJobsRequest$MaxResults' => 'Optional. Number of jobs, up to twenty, that will be returned at one time.', 'ListPresetsRequest$MaxResults' => 'Optional. Number of presets, up to twenty, that will be returned at one time', 'ListQueuesRequest$MaxResults' => 'Optional. Number of queues, up to twenty, that will be returned at one time.', ], ], '__integerMin1Max2147483640' => [ 'base' => NULL, 'refs' => [ 'MotionImageInsertionFramerate$FramerateNumerator' => 'The top of the fraction that expresses your overlay frame rate. For example, if your frame rate is 24 fps, set this value to 24.', ], ], '__integerMin1Max2147483647' => [ 'base' => NULL, 'refs' => [ 'Av1Settings$FramerateDenominator' => 'When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.', 'Av1Settings$FramerateNumerator' => 'When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.', 'CmafGroupSettings$FragmentLength' => 'Length of fragments to generate (in seconds). Fragment length must be compatible with GOP size and Framerate. Note that fragments will end on the next keyframe after this number of seconds, so actual fragment length may be longer. When Emit Single File is checked, the fragmentation is internal to a single output file and it does not cause the creation of many output files as in other output types.', 'CmafGroupSettings$SegmentLength' => 'Use this setting to specify the length, in seconds, of each individual CMAF segment. This value applies to the whole package; that is, to every output in the output group. Note that segments end on the first keyframe after this number of seconds, so the actual segment length might be slightly longer. If you set Segment control (CmafSegmentControl) to single file, the service puts the content of each output in a single file that has metadata that marks these segments. If you set it to segmented files, the service creates multiple files for each output, each with the content of one segment.', 'DashIsoGroupSettings$FragmentLength' => 'Length of fragments to generate (in seconds). Fragment length must be compatible with GOP size and Framerate. Note that fragments will end on the next keyframe after this number of seconds, so actual fragment length may be longer. When Emit Single File is checked, the fragmentation is internal to a single output file and it does not cause the creation of many output files as in other output types.', 'DashIsoGroupSettings$SegmentLength' => 'Length of mpd segments to create (in seconds). Note that segments will end on the next keyframe after this number of seconds, so actual segment length may be longer. When Emit Single File is checked, the segmentation is internal to a single output file and it does not cause the creation of many output files as in other output types.', 'DvbSubSourceSettings$Pid' => 'When using DVB-Sub with Burn-In or SMPTE-TT, use this PID for the source content. Unused for DVB-Sub passthrough. All DVB-Sub content is passed through, regardless of selectors.', 'FrameCaptureSettings$FramerateDenominator' => 'Frame capture will encode the first frame of the output stream, then one frame every framerateDenominator/framerateNumerator seconds. For example, settings of framerateNumerator = 1 and framerateDenominator = 3 (a rate of 1/3 frame per second) will capture the first frame, then 1 frame every 3s. Files will be named as filename.n.jpg where n is the 0-based sequence number of each Capture.', 'FrameCaptureSettings$FramerateNumerator' => 'Frame capture will encode the first frame of the output stream, then one frame every framerateDenominator/framerateNumerator seconds. For example, settings of framerateNumerator = 1 and framerateDenominator = 3 (a rate of 1/3 frame per second) will capture the first frame, then 1 frame every 3s. Files will be named as filename.NNNNNNN.jpg where N is the 0-based frame sequence number zero padded to 7 decimal places.', 'H264Settings$FramerateDenominator' => 'When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.', 'H264Settings$FramerateNumerator' => 'Frame rate numerator - frame rate is a fraction, e.g. 24000 / 1001 = 23.976 fps.', 'H264Settings$ParDenominator' => 'Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.', 'H264Settings$ParNumerator' => 'Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.', 'H265Settings$FramerateDenominator' => 'Frame rate denominator.', 'H265Settings$FramerateNumerator' => 'Frame rate numerator - frame rate is a fraction, e.g. 24000 / 1001 = 23.976 fps.', 'H265Settings$ParDenominator' => 'Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.', 'H265Settings$ParNumerator' => 'Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.', 'HlsGroupSettings$SegmentLength' => 'Length of MPEG-2 Transport Stream segments to create (in seconds). Note that segments will end on the next keyframe after this number of seconds, so actual segment length may be longer.', 'HlsGroupSettings$SegmentsPerSubdirectory' => 'Number of segments to write to a subdirectory before starting a new one. directoryStructure must be SINGLE_DIRECTORY for this setting to have an effect.', 'Input$ProgramNumber' => 'Use Program (programNumber) to select a specific program from within a multi-program transport stream. Note that Quad 4K is not currently supported. Default is the first program within the transport stream. If the program you specify doesn\'t exist, the transcoding service will use this default.', 'InputTemplate$ProgramNumber' => 'Use Program (programNumber) to select a specific program from within a multi-program transport stream. Note that Quad 4K is not currently supported. Default is the first program within the transport stream. If the program you specify doesn\'t exist, the transcoding service will use this default.', 'Mpeg2Settings$ParDenominator' => 'Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.', 'Mpeg2Settings$ParNumerator' => 'Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.', 'MsSmoothGroupSettings$FragmentLength' => 'Use Fragment length (FragmentLength) to specify the mp4 fragment sizes in seconds. Fragment length must be compatible with GOP size and frame rate.', 'ProresSettings$FramerateDenominator' => 'Frame rate denominator.', 'ProresSettings$FramerateNumerator' => 'When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator.', 'ProresSettings$ParDenominator' => 'Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.', 'ProresSettings$ParNumerator' => 'Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.', 'TrackSourceSettings$TrackNumber' => 'Use this setting to select a single captions track from a source. Track numbers correspond to the order in the captions source file. For IMF sources, track numbering is based on the order that the captions appear in the CPL. For example, use 1 to select the captions asset that is listed first in the CPL. To include more than one captions track in your job outputs, create multiple input captions selectors. Specify one track per selector.', 'VideoSelector$Pid' => 'Use PID (Pid) to select specific video data from an input file. Specify this value as an integer; the system automatically converts it to the hexidecimal value. For example, 257 selects PID 0x101. A PID, or packet identifier, is an identifier for a set of data in an MPEG-2 transport stream container.', 'Vp8Settings$FramerateDenominator' => 'When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.', 'Vp8Settings$FramerateNumerator' => 'When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.', 'Vp8Settings$ParDenominator' => 'Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.', 'Vp8Settings$ParNumerator' => 'Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.', 'Vp9Settings$FramerateDenominator' => 'When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.', 'Vp9Settings$FramerateNumerator' => 'When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.', 'Vp9Settings$ParDenominator' => 'Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.', 'Vp9Settings$ParNumerator' => 'Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.', '__listOf__integerMin1Max2147483647$member' => NULL, ], ], '__integerMin1Max31' => [ 'base' => NULL, 'refs' => [ 'Ac3Settings$Dialnorm' => 'Sets the dialnorm for the output. If blank and input audio is Dolby Digital, dialnorm will be passed through.', 'Eac3Settings$Dialnorm' => 'Sets the dialnorm for the output. If blank and input audio is Dolby Digital Plus, dialnorm will be passed through.', ], ], '__integerMin1Max32' => [ 'base' => NULL, 'refs' => [ 'Av1Settings$Slices' => 'Specify the number of slices per picture. This value must be 1, 2, 4, 8, 16, or 32. For progressive pictures, this value must be less than or equal to the number of macroblock rows. For interlaced pictures, this value must be less than or equal to half the number of macroblock rows.', 'H264Settings$Slices' => 'Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.', 'H265Settings$Slices' => 'Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.', ], ], '__integerMin1Max4' => [ 'base' => NULL, 'refs' => [ 'AncillarySourceSettings$SourceAncillaryChannelNumber' => 'Specifies the 608 channel number in the ancillary data track from which to extract captions. Unused for passthrough.', 'EmbeddedDestinationSettings$Destination608ChannelNumber' => 'Ignore this setting unless your input captions are SCC format and your output captions are embedded in the video stream. Specify a CC number for each captions channel in this output. If you have two channels, choose CC numbers that aren\'t in the same field. For example, choose 1 and 3. For more information, see https://docs.aws.amazon.com/console/mediaconvert/dual-scc-to-embedded.', 'EmbeddedSourceSettings$Source608ChannelNumber' => 'Specifies the 608/708 channel number within the video track from which to extract captions. Unused for passthrough.', ], ], '__integerMin1Max6' => [ 'base' => NULL, 'refs' => [ 'EmbeddedDestinationSettings$Destination708ServiceNumber' => 'Ignore this setting unless your input captions are SCC format and you want both 608 and 708 captions embedded in your output stream. Optionally, specify the 708 service number for each output captions channel. Choose a different number for each channel. To use this setting, also set Force 608 to 708 upconvert (Convert608To708) to Upconvert (UPCONVERT) in your input captions selector settings. If you choose to upconvert but don\'t specify a 708 service number, MediaConvert uses the number that you specify for CC channel number (destination608ChannelNumber) for the 708 service number. For more information, see https://docs.aws.amazon.com/console/mediaconvert/dual-scc-to-embedded.', 'H264Settings$NumberReferenceFrames' => 'Number of reference frames to use. The encoder may use more than requested if using B-frames and/or interlaced encoding.', 'H265Settings$NumberReferenceFrames' => 'Number of reference frames to use. The encoder may use more than requested if using B-frames and/or interlaced encoding.', ], ], '__integerMin1Max60000' => [ 'base' => NULL, 'refs' => [ 'CaptionSourceFramerate$FramerateNumerator' => 'Specify the numerator of the fraction that represents the frame rate for the setting Caption source frame rate (CaptionSourceFramerate). Use this setting along with the setting Framerate denominator (framerateDenominator).', ], ], '__integerMin1Max64' => [ 'base' => NULL, 'refs' => [ 'AiffSettings$Channels' => 'Specify the number of channels in this output audio track. Valid values are 1 and even numbers up to 64. For example, 1, 2, 4, 6, and so on, up to 64.', 'RemixSettings$ChannelsIn' => 'Specify the number of audio channels from your input that you want to use in your output. With remixing, you might combine or split the data in these channels, so the number of channels in your final output might be different.', 'RemixSettings$ChannelsOut' => 'Specify the number of channels in this output after remixing. Valid values: 1, 2, 4, 6, 8... 64. (1 and even numbers to 64.)', 'WavSettings$Channels' => 'Specify the number of channels in this output audio track. Valid values are 1 and even numbers up to 64. For example, 1, 2, 4, 6, and so on, up to 64.', ], ], '__integerMin22050Max48000' => [ 'base' => NULL, 'refs' => [ 'Mp3Settings$SampleRate' => 'Sample rate in hz.', 'VorbisSettings$SampleRate' => 'Optional. Specify the audio sample rate in Hz. Valid values are 22050, 32000, 44100, and 48000. The default value is 48000.', ], ], '__integerMin24Max60000' => [ 'base' => NULL, 'refs' => [ 'Mpeg2Settings$FramerateNumerator' => 'Frame rate numerator - frame rate is a fraction, e.g. 24000 / 1001 = 23.976 fps.', ], ], '__integerMin25Max10000' => [ 'base' => NULL, 'refs' => [ 'DvbNitSettings$NitInterval' => 'The number of milliseconds between instances of this table in the output transport stream.', ], ], '__integerMin25Max2000' => [ 'base' => NULL, 'refs' => [ 'DvbSdtSettings$SdtInterval' => 'The number of milliseconds between instances of this table in the output transport stream.', ], ], '__integerMin2Max2147483647' => [ 'base' => NULL, 'refs' => [ 'Rectangle$Height' => 'Height of rectangle in pixels. Specify only even numbers.', 'Rectangle$Width' => 'Width of rectangle in pixels. Specify only even numbers.', ], ], '__integerMin32000Max192000' => [ 'base' => NULL, 'refs' => [ 'OpusSettings$Bitrate' => 'Optional. Specify the average bitrate in bits per second. Valid values are multiples of 8000, from 32000 through 192000. The default value is 96000, which we recommend for quality and bandwidth.', ], ], '__integerMin32000Max384000' => [ 'base' => NULL, 'refs' => [ 'Mp2Settings$Bitrate' => 'Specify the average bitrate in bits per second.', ], ], '__integerMin32000Max48000' => [ 'base' => NULL, 'refs' => [ 'Mp2Settings$SampleRate' => 'Sample rate in hz.', ], ], '__integerMin32Max8182' => [ 'base' => NULL, 'refs' => [ 'M2tsScte35Esam$Scte35EsamPid' => 'Packet Identifier (PID) of the SCTE-35 stream in the transport stream generated by ESAM.', 'M2tsSettings$DvbTeletextPid' => 'Specify the packet identifier (PID) for DVB teletext data you include in this output. Default is 499.', 'M2tsSettings$PcrPid' => 'Specify the packet identifier (PID) for the program clock reference (PCR) in this output. If you do not specify a value, the service will use the value for Video PID (VideoPid).', 'M2tsSettings$PmtPid' => 'Specify the packet identifier (PID) for the program map table (PMT) itself. Default is 480.', 'M2tsSettings$PrivateMetadataPid' => 'Specify the packet identifier (PID) of the private metadata stream. Default is 503.', 'M2tsSettings$Scte35Pid' => 'Specify the packet identifier (PID) of the SCTE-35 stream in the transport stream.', 'M2tsSettings$TimedMetadataPid' => 'Specify the packet identifier (PID) for timed metadata in this output. Default is 502.', 'M2tsSettings$VideoPid' => 'Specify the packet identifier (PID) of the elementary video stream in the transport stream.', 'M3u8Settings$PcrPid' => 'Packet Identifier (PID) of the Program Clock Reference (PCR) in the transport stream. When no value is given, the encoder will assign the same value as the Video PID.', 'M3u8Settings$PmtPid' => 'Packet Identifier (PID) for the Program Map Table (PMT) in the transport stream.', 'M3u8Settings$PrivateMetadataPid' => 'Packet Identifier (PID) of the private metadata stream in the transport stream.', 'M3u8Settings$Scte35Pid' => 'Packet Identifier (PID) of the SCTE-35 stream in the transport stream.', 'M3u8Settings$TimedMetadataPid' => 'Packet Identifier (PID) of the timed metadata stream in the transport stream.', 'M3u8Settings$VideoPid' => 'Packet Identifier (PID) of the elementary video stream in the transport stream.', '__listOf__integerMin32Max8182$member' => NULL, ], ], '__integerMin32Max8192' => [ 'base' => NULL, 'refs' => [ 'VideoDescription$Height' => 'Use the Height (Height) setting to define the video resolution height for this output. Specify in pixels. If you don\'t provide a value here, the service will use the input height.', 'VideoDescription$Width' => 'Use Width (Width) to define the video resolution width, in pixels, for this output. If you don\'t provide a value here, the service will use the input width.', ], ], '__integerMin384000Max768000' => [ 'base' => NULL, 'refs' => [ 'Eac3AtmosSettings$Bitrate' => 'Specify the average bitrate in bits per second.Valid values: 384k, 448k, 640k, 768k', ], ], '__integerMin48000Max48000' => [ 'base' => NULL, 'refs' => [ 'Ac3Settings$SampleRate' => 'This value is always 48000. It represents the sample rate in Hz.', 'Eac3AtmosSettings$SampleRate' => 'This value is always 48000. It represents the sample rate in Hz.', 'Eac3Settings$SampleRate' => 'This value is always 48000. It represents the sample rate in Hz.', ], ], '__integerMin6000Max1024000' => [ 'base' => NULL, 'refs' => [ 'AacSettings$Bitrate' => 'Specify the average bitrate in bits per second. The set of valid values for this setting is: 6000, 8000, 10000, 12000, 14000, 16000, 20000, 24000, 28000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 288000, 320000, 384000, 448000, 512000, 576000, 640000, 768000, 896000, 1024000. The value you set is also constrained by the values that you choose for Profile (codecProfile), Bitrate control mode (codingMode), and Sample rate (sampleRate). Default values depend on Bitrate control mode and Profile.', ], ], '__integerMin64000Max640000' => [ 'base' => NULL, 'refs' => [ 'Ac3Settings$Bitrate' => 'Specify the average bitrate in bits per second. Valid bitrates depend on the coding mode.', 'Eac3Settings$Bitrate' => 'Specify the average bitrate in bits per second. Valid bitrates depend on the coding mode.', ], ], '__integerMin7Max15' => [ 'base' => NULL, 'refs' => [ 'Av1Settings$NumberBFramesBetweenReferenceFrames' => 'Specify the number of B-frames. With AV1, MediaConvert supports only 7 or 15.', ], ], '__integerMin8000Max192000' => [ 'base' => NULL, 'refs' => [ 'AiffSettings$SampleRate' => 'Sample rate in hz.', 'WavSettings$SampleRate' => 'Sample rate in Hz.', ], ], '__integerMin8000Max96000' => [ 'base' => NULL, 'refs' => [ 'AacSettings$SampleRate' => 'Sample rate in Hz. Valid values depend on rate control mode and profile.', ], ], '__integerMin96Max600' => [ 'base' => NULL, 'refs' => [ 'BurninDestinationSettings$FontResolution' => 'Font resolution in DPI (dots per inch); default is 96 dpi.All burn-in and DVB-Sub font settings must match.', 'DvbSubDestinationSettings$FontResolution' => 'Font resolution in DPI (dots per inch); default is 96 dpi.All burn-in and DVB-Sub font settings must match.', ], ], '__integerMinNegative1000Max1000' => [ 'base' => NULL, 'refs' => [ 'JobSettings$AdAvailOffset' => 'When specified, this offset (in milliseconds) is added to the input Ad Avail PTS time.', 'JobTemplateSettings$AdAvailOffset' => 'When specified, this offset (in milliseconds) is added to the input Ad Avail PTS time.', ], ], '__integerMinNegative180Max180' => [ 'base' => NULL, 'refs' => [ 'ColorCorrector$Hue' => 'Hue in degrees.', ], ], '__integerMinNegative1Max10' => [ 'base' => NULL, 'refs' => [ 'VorbisSettings$VbrQuality' => 'Optional. Specify the variable audio quality of this Vorbis output from -1 (lowest quality, ~45 kbit/s) to 10 (highest quality, ~500 kbit/s). The default value is 4 (~128 kbit/s). Values 5 and 6 are approximately 160 and 192 kbit/s, respectively.', ], ], '__integerMinNegative1Max3' => [ 'base' => NULL, 'refs' => [ 'NoiseReducerTemporalFilterSettings$Speed' => 'The speed of the filter (higher number is faster). Low setting reduces bit rate at the cost of transcode time, high setting improves transcode time at the cost of bit rate.', ], ], '__integerMinNegative2147483648Max2147483647' => [ 'base' => NULL, 'refs' => [ 'AudioSelector$Offset' => 'Specifies a time delta in milliseconds to offset the audio from the input video.', 'BurninDestinationSettings$ShadowXOffset' => 'Specifies the horizontal offset of the shadow relative to the captions in pixels. A value of -2 would result in a shadow offset 2 pixels to the left. All burn-in and DVB-Sub font settings must match.', 'BurninDestinationSettings$ShadowYOffset' => 'Specifies the vertical offset of the shadow relative to the captions in pixels. A value of -2 would result in a shadow offset 2 pixels above the text. All burn-in and DVB-Sub font settings must match.', 'DvbSubDestinationSettings$ShadowXOffset' => 'Specifies the horizontal offset of the shadow relative to the captions in pixels. A value of -2 would result in a shadow offset 2 pixels to the left. All burn-in and DVB-Sub font settings must match.', 'DvbSubDestinationSettings$ShadowYOffset' => 'Specifies the vertical offset of the shadow relative to the captions in pixels. A value of -2 would result in a shadow offset 2 pixels above the text. All burn-in and DVB-Sub font settings must match.', 'FileSourceSettings$TimeDelta' => 'Specifies a time delta in seconds to offset the captions from the source file.', 'HlsCaptionLanguageMapping$CaptionChannel' => 'Caption channel.', 'HlsGroupSettings$TimedMetadataId3Period' => 'Timed Metadata interval in seconds.', 'HlsGroupSettings$TimestampDeltaMilliseconds' => 'Provides an extra millisecond delta offset to fine tune the timestamps.', 'VideoSelector$ProgramNumber' => 'Selects a specific program from within a multi-program transport stream. Note that Quad 4K is not currently supported.', ], ], '__integerMinNegative2Max3' => [ 'base' => NULL, 'refs' => [ 'NoiseReducerSpatialFilterSettings$Speed' => 'The speed of the filter, from -2 (lower speed) to 3 (higher speed), with 0 being the nominal value.', ], ], '__integerMinNegative50Max50' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$Priority' => 'Optional. Specify the relative priority for this job. In any given queue, the service begins processing the job with the highest value first. When more than one job has the same priority, the service begins processing the job that you submitted first. If you don\'t specify a priority, the service uses the default value 0.', 'CreateJobTemplateRequest$Priority' => 'Specify the relative priority for this job. In any given queue, the service begins processing the job with the highest value first. When more than one job has the same priority, the service begins processing the job that you submitted first. If you don\'t specify a priority, the service uses the default value 0.', 'HopDestination$Priority' => 'Optional. When you set up a job to use queue hopping, you can specify a different relative priority for the job in the destination queue. If you don\'t specify, the relative priority will remain the same as in the previous queue.', 'Job$Priority' => 'Relative priority on the job.', 'JobTemplate$Priority' => 'Relative priority on the job.', 'UpdateJobTemplateRequest$Priority' => 'Specify the relative priority for this job. In any given queue, the service begins processing the job with the highest value first. When more than one job has the same priority, the service begins processing the job that you submitted first. If you don\'t specify a priority, the service uses the default value 0.', ], ], '__integerMinNegative5Max5' => [ 'base' => NULL, 'refs' => [ 'Input$FilterStrength' => 'Use Filter strength (FilterStrength) to adjust the magnitude the input filter settings (Deblock and Denoise). The range is -5 to 5. Default is 0.', 'InputTemplate$FilterStrength' => 'Use Filter strength (FilterStrength) to adjust the magnitude the input filter settings (Deblock and Denoise). The range is -5 to 5. Default is 0.', ], ], '__integerMinNegative60Max6' => [ 'base' => NULL, 'refs' => [ '__listOf__integerMinNegative60Max6$member' => NULL, ], ], '__integerMinNegative70Max0' => [ 'base' => NULL, 'refs' => [ 'AudioNormalizationSettings$CorrectionGateLevel' => 'Content measuring above this level will be corrected to the target level. Content measuring below this level will not be corrected.', ], ], '__listOfAudioDescription' => [ 'base' => NULL, 'refs' => [ 'Output$AudioDescriptions' => '(AudioDescriptions) contains groups of audio encoding settings organized by audio codec. Include one instance of (AudioDescriptions) per output. (AudioDescriptions) can contain multiple groups of encoding settings.', 'PresetSettings$AudioDescriptions' => '(AudioDescriptions) contains groups of audio encoding settings organized by audio codec. Include one instance of (AudioDescriptions) per output. (AudioDescriptions) can contain multiple groups of encoding settings.', ], ], '__listOfCaptionDescription' => [ 'base' => NULL, 'refs' => [ 'Output$CaptionDescriptions' => '(CaptionDescriptions) contains groups of captions settings. For each output that has captions, include one instance of (CaptionDescriptions). (CaptionDescriptions) can contain multiple groups of captions settings.', ], ], '__listOfCaptionDescriptionPreset' => [ 'base' => NULL, 'refs' => [ 'PresetSettings$CaptionDescriptions' => 'Caption settings for this preset. There can be multiple caption settings in a single output.', ], ], '__listOfCmafAdditionalManifest' => [ 'base' => NULL, 'refs' => [ 'CmafGroupSettings$AdditionalManifests' => 'By default, the service creates one top-level .m3u8 HLS manifest and one top -level .mpd DASH manifest for each CMAF output group in your job. These default manifests reference every output in the output group. To create additional top-level manifests that reference a subset of the outputs in the output group, specify a list of them here. For each additional manifest that you specify, the service creates one HLS manifest and one DASH manifest.', ], ], '__listOfDashAdditionalManifest' => [ 'base' => NULL, 'refs' => [ 'DashIsoGroupSettings$AdditionalManifests' => 'By default, the service creates one .mpd DASH manifest for each DASH ISO output group in your job. This default manifest references every output in the output group. To create additional DASH manifests that reference a subset of the outputs in the output group, specify a list of them here.', ], ], '__listOfEndpoint' => [ 'base' => NULL, 'refs' => [ 'DescribeEndpointsResponse$Endpoints' => 'List of endpoints', ], ], '__listOfHlsAdMarkers' => [ 'base' => NULL, 'refs' => [ 'HlsGroupSettings$AdMarkers' => 'Choose one or more ad marker types to decorate your Apple HLS manifest. This setting does not determine whether SCTE-35 markers appear in the outputs themselves.', ], ], '__listOfHlsAdditionalManifest' => [ 'base' => NULL, 'refs' => [ 'HlsGroupSettings$AdditionalManifests' => 'By default, the service creates one top-level .m3u8 HLS manifest for each HLS output group in your job. This default manifest references every output in the output group. To create additional top-level manifests that reference a subset of the outputs in the output group, specify a list of them here.', ], ], '__listOfHlsCaptionLanguageMapping' => [ 'base' => NULL, 'refs' => [ 'HlsGroupSettings$CaptionLanguageMappings' => 'Language to be used on Caption outputs', ], ], '__listOfHopDestination' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$HopDestinations' => 'Optional. Use queue hopping to avoid overly long waits in the backlog of the queue that you submit your job to. Specify an alternate queue and the maximum time that your job will wait in the initial queue before hopping. For more information about this feature, see the AWS Elemental MediaConvert User Guide.', 'CreateJobTemplateRequest$HopDestinations' => 'Optional. Use queue hopping to avoid overly long waits in the backlog of the queue that you submit your job to. Specify an alternate queue and the maximum time that your job will wait in the initial queue before hopping. For more information about this feature, see the AWS Elemental MediaConvert User Guide.', 'Job$HopDestinations' => 'Optional list of hop destinations.', 'JobTemplate$HopDestinations' => 'Optional list of hop destinations.', 'UpdateJobTemplateRequest$HopDestinations' => 'Optional list of hop destinations.', ], ], '__listOfId3Insertion' => [ 'base' => NULL, 'refs' => [ 'TimedMetadataInsertion$Id3Insertions' => 'Id3Insertions contains the array of Id3Insertion instances.', ], ], '__listOfInput' => [ 'base' => NULL, 'refs' => [ 'JobSettings$Inputs' => 'Use Inputs (inputs) to define source file used in the transcode job. There can be multiple inputs add in a job. These inputs will be concantenated together to create the output.', ], ], '__listOfInputClipping' => [ 'base' => NULL, 'refs' => [ 'Input$InputClippings' => '(InputClippings) contains sets of start and end times that together specify a portion of the input to be used in the outputs. If you provide only a start time, the clip will be the entire input from that point to the end. If you provide only an end time, it will be the entire input up to that point. When you specify more than one input clip, the transcoding service creates the job outputs by stringing the clips together in the order you specify them.', 'InputTemplate$InputClippings' => '(InputClippings) contains sets of start and end times that together specify a portion of the input to be used in the outputs. If you provide only a start time, the clip will be the entire input from that point to the end. If you provide only an end time, it will be the entire input up to that point. When you specify more than one input clip, the transcoding service creates the job outputs by stringing the clips together in the order you specify them.', ], ], '__listOfInputTemplate' => [ 'base' => NULL, 'refs' => [ 'JobTemplateSettings$Inputs' => 'Use Inputs (inputs) to define the source file used in the transcode job. There can only be one input in a job template. Using the API, you can include multiple inputs when referencing a job template.', ], ], '__listOfInsertableImage' => [ 'base' => NULL, 'refs' => [ 'ImageInserter$InsertableImages' => 'Specify the images that you want to overlay on your video. The images must be PNG or TGA files.', ], ], '__listOfJob' => [ 'base' => NULL, 'refs' => [ 'ListJobsResponse$Jobs' => 'List of jobs', ], ], '__listOfJobTemplate' => [ 'base' => NULL, 'refs' => [ 'ListJobTemplatesResponse$JobTemplates' => 'List of Job templates.', ], ], '__listOfMsSmoothAdditionalManifest' => [ 'base' => NULL, 'refs' => [ 'MsSmoothGroupSettings$AdditionalManifests' => 'By default, the service creates one .ism Microsoft Smooth Streaming manifest for each Microsoft Smooth Streaming output group in your job. This default manifest references every output in the output group. To create additional manifests that reference a subset of the outputs in the output group, specify a list of them here.', ], ], '__listOfOutput' => [ 'base' => NULL, 'refs' => [ 'OutputGroup$Outputs' => 'This object holds groups of encoding settings, one group of settings per output.', ], ], '__listOfOutputChannelMapping' => [ 'base' => NULL, 'refs' => [ 'ChannelMapping$OutputChannels' => 'List of output channels', ], ], '__listOfOutputDetail' => [ 'base' => NULL, 'refs' => [ 'OutputGroupDetail$OutputDetails' => 'Details about the output', ], ], '__listOfOutputGroup' => [ 'base' => NULL, 'refs' => [ 'JobSettings$OutputGroups' => '(OutputGroups) contains one group of settings for each set of outputs that share a common package type. All unpackaged files (MPEG-4, MPEG-2 TS, Quicktime, MXF, and no container) are grouped in a single output group as well. Required in (OutputGroups) is a group of settings that apply to the whole group. This required object depends on the value you set for (Type) under (OutputGroups)>(OutputGroupSettings). Type, settings object pairs are as follows. * FILE_GROUP_SETTINGS, FileGroupSettings * HLS_GROUP_SETTINGS, HlsGroupSettings * DASH_ISO_GROUP_SETTINGS, DashIsoGroupSettings * MS_SMOOTH_GROUP_SETTINGS, MsSmoothGroupSettings * CMAF_GROUP_SETTINGS, CmafGroupSettings', 'JobTemplateSettings$OutputGroups' => '(OutputGroups) contains one group of settings for each set of outputs that share a common package type. All unpackaged files (MPEG-4, MPEG-2 TS, Quicktime, MXF, and no container) are grouped in a single output group as well. Required in (OutputGroups) is a group of settings that apply to the whole group. This required object depends on the value you set for (Type) under (OutputGroups)>(OutputGroupSettings). Type, settings object pairs are as follows. * FILE_GROUP_SETTINGS, FileGroupSettings * HLS_GROUP_SETTINGS, HlsGroupSettings * DASH_ISO_GROUP_SETTINGS, DashIsoGroupSettings * MS_SMOOTH_GROUP_SETTINGS, MsSmoothGroupSettings * CMAF_GROUP_SETTINGS, CmafGroupSettings', ], ], '__listOfOutputGroupDetail' => [ 'base' => NULL, 'refs' => [ 'Job$OutputGroupDetails' => 'List of output group details', ], ], '__listOfPreset' => [ 'base' => NULL, 'refs' => [ 'ListPresetsResponse$Presets' => 'List of presets', ], ], '__listOfQueue' => [ 'base' => NULL, 'refs' => [ 'ListQueuesResponse$Queues' => 'List of queues.', ], ], '__listOfQueueTransition' => [ 'base' => NULL, 'refs' => [ 'Job$QueueTransitions' => 'The job\'s queue hopping history.', ], ], '__listOfTeletextPageType' => [ 'base' => NULL, 'refs' => [ 'TeletextDestinationSettings$PageTypes' => 'Specify the page types for this Teletext page. If you don\'t specify a value here, the service sets the page type to the default value Subtitle (PAGE_TYPE_SUBTITLE). If you pass through the entire set of Teletext data, don\'t use this field. When you pass through a set of Teletext pages, your output has the same page types as your input.', ], ], '__listOf__integerMin1Max2147483647' => [ 'base' => NULL, 'refs' => [ 'AudioSelector$Pids' => 'Selects a specific PID from within an audio source (e.g. 257 selects PID 0x101).', 'AudioSelector$Tracks' => 'Identify a track from the input audio to include in this selector by entering the track index number. To include several tracks in a single audio selector, specify multiple tracks as follows. Using the console, enter a comma-separated list. For examle, type "1,2,3" to include tracks 1 through 3. Specifying directly in your JSON job file, provide the track numbers in an array. For example, "tracks": [1,2,3].', ], ], '__listOf__integerMin32Max8182' => [ 'base' => NULL, 'refs' => [ 'M2tsSettings$AudioPids' => 'Specify the packet identifiers (PIDs) for any elementary audio streams you include in this output. Specify multiple PIDs as a JSON array. Default is the range 482-492.', 'M2tsSettings$DvbSubPids' => 'Specify the packet identifiers (PIDs) for DVB subtitle data included in this output. Specify multiple PIDs as a JSON array. Default is the range 460-479.', 'M3u8Settings$AudioPids' => 'Packet Identifier (PID) of the elementary audio stream(s) in the transport stream. Multiple values are accepted, and can be entered in ranges and/or by comma separation.', ], ], '__listOf__integerMinNegative60Max6' => [ 'base' => NULL, 'refs' => [ 'OutputChannelMapping$InputChannels' => 'List of input channels', ], ], '__listOf__string' => [ 'base' => NULL, 'refs' => [ 'JobMessages$Info' => 'List of messages that are informational only and don\'t indicate a problem with your job.', 'JobMessages$Warning' => 'List of messages that warn about conditions that might cause your job not to run or to fail.', 'UntagResourceRequest$TagKeys' => 'The keys of the tags that you want to remove from the resource.', ], ], '__listOf__stringMin1' => [ 'base' => NULL, 'refs' => [ 'AudioSelectorGroup$AudioSelectorNames' => 'Name of an Audio Selector within the same input to include in the group. Audio selector names are standardized, based on their order within the input (e.g., "Audio Selector 1"). The audio selector name parameter can be repeated to add any number of audio selectors to the group.', 'CmafAdditionalManifest$SelectedOutputs' => 'Specify the outputs that you want this additional top-level manifest to reference.', 'DashAdditionalManifest$SelectedOutputs' => 'Specify the outputs that you want this additional top-level manifest to reference.', 'HlsAdditionalManifest$SelectedOutputs' => 'Specify the outputs that you want this additional top-level manifest to reference.', 'MsSmoothAdditionalManifest$SelectedOutputs' => 'Specify the outputs that you want this additional top-level manifest to reference.', ], ], '__listOf__stringMin36Max36Pattern09aFAF809aFAF409aFAF409aFAF409aFAF12' => [ 'base' => NULL, 'refs' => [ 'SpekeKeyProviderCmaf$DashSignaledSystemIds' => 'Specify the DRM system IDs that you want signaled in the DASH manifest that MediaConvert creates as part of this CMAF package. The DASH manifest can currently signal up to three system IDs. For more information, see https://dashif.org/identifiers/content_protection/.', 'SpekeKeyProviderCmaf$HlsSignaledSystemIds' => 'Specify the DRM system ID that you want signaled in the HLS manifest that MediaConvert creates as part of this CMAF package. The HLS manifest can currently signal only one system ID. For more information, see https://dashif.org/identifiers/content_protection/.', ], ], '__listOf__stringPattern09aFAF809aFAF409aFAF409aFAF409aFAF12' => [ 'base' => NULL, 'refs' => [ 'SpekeKeyProvider$SystemIds' => 'Relates to SPEKE implementation. DRM system identifiers. DASH output groups support a max of two system ids. Other group types support one system id. See https://dashif.org/identifiers/content_protection/ for more details.', ], ], '__listOf__stringPatternS3ASSETMAPXml' => [ 'base' => NULL, 'refs' => [ 'Input$SupplementalImps' => 'Provide a list of any necessary supplemental IMPs. You need supplemental IMPs if the CPL that you\'re using for your input is in an incomplete IMP. Specify either the supplemental IMP directories with a trailing slash or the ASSETMAP.xml files. For example ["s3://bucket/ov/", "s3://bucket/vf2/ASSETMAP.xml"]. You don\'t need to specify the IMP that contains your input CPL, because the service automatically detects it.', ], ], '__mapOfAudioSelector' => [ 'base' => NULL, 'refs' => [ 'Input$AudioSelectors' => 'Use Audio selectors (AudioSelectors) to specify a track or set of tracks from the input that you will use in your outputs. You can use multiple Audio selectors per input.', 'InputTemplate$AudioSelectors' => 'Use Audio selectors (AudioSelectors) to specify a track or set of tracks from the input that you will use in your outputs. You can use multiple Audio selectors per input.', ], ], '__mapOfAudioSelectorGroup' => [ 'base' => NULL, 'refs' => [ 'Input$AudioSelectorGroups' => 'Specifies set of audio selectors within an input to combine. An input may have multiple audio selector groups. See "Audio Selector Group":#inputs-audio_selector_group for more information.', 'InputTemplate$AudioSelectorGroups' => 'Specifies set of audio selectors within an input to combine. An input may have multiple audio selector groups. See "Audio Selector Group":#inputs-audio_selector_group for more information.', ], ], '__mapOfCaptionSelector' => [ 'base' => NULL, 'refs' => [ 'Input$CaptionSelectors' => 'Use captions selectors to specify the captions data from your input that you use in your outputs. You can use up to 20 captions selectors per input.', 'InputTemplate$CaptionSelectors' => 'Use captions selectors to specify the captions data from your input that you use in your outputs. You can use up to 20 captions selectors per input.', ], ], '__mapOf__string' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$Tags' => 'Optional. The tags that you want to add to the resource. You can tag resources with a key-value pair or with only a key.', 'CreateJobRequest$UserMetadata' => 'Optional. User-defined metadata that you want to associate with an MediaConvert job. You specify metadata in key/value pairs.', 'CreateJobTemplateRequest$Tags' => 'The tags that you want to add to the resource. You can tag resources with a key-value pair or with only a key.', 'CreatePresetRequest$Tags' => 'The tags that you want to add to the resource. You can tag resources with a key-value pair or with only a key.', 'CreateQueueRequest$Tags' => 'The tags that you want to add to the resource. You can tag resources with a key-value pair or with only a key.', 'Job$UserMetadata' => 'User-defined metadata that you want to associate with an MediaConvert job. You specify metadata in key/value pairs.', 'ResourceTags$Tags' => 'The tags for the resource.', 'TagResourceRequest$Tags' => 'The tags that you want to add to the resource. You can tag resources with a key-value pair or with only a key.', ], ], '__string' => [ 'base' => NULL, 'refs' => [ 'AssociateCertificateRequest$Arn' => 'The ARN of the ACM certificate that you want to associate with your MediaConvert resource.', 'AudioDescription$AudioSourceName' => 'Specifies which audio data to use from each input. In the simplest case, specify an "Audio Selector":#inputs-audio_selector by name based on its order within each input. For example if you specify "Audio Selector 3", then the third audio selector will be used from each input. If an input does not have an "Audio Selector 3", then the audio selector marked as "default" in that input will be used. If there is no audio selector marked as "default", silence will be inserted for the duration of that input. Alternatively, an "Audio Selector Group":#inputs-audio_selector_group name may be specified, with similar default/silence behavior. If no audio_source_name is specified, then "Audio Selector 1" will be chosen automatically.', 'CancelJobRequest$Id' => 'The Job ID of the job to be cancelled.', 'CaptionDescription$LanguageDescription' => 'Specify a label for this set of output captions. For example, "English", "Director commentary", or "track_2". For streaming outputs, MediaConvert passes this information into destination manifests for display on the end-viewer\'s player device. For outputs in other output groups, the service ignores this setting.', 'CaptionDescriptionPreset$LanguageDescription' => 'Specify a label for this set of output captions. For example, "English", "Director commentary", or "track_2". For streaming outputs, MediaConvert passes this information into destination manifests for display on the end-viewer\'s player device. For outputs in other output groups, the service ignores this setting.', 'CmafGroupSettings$BaseUrl' => 'A partial URI prefix that will be put in the manifest file at the top level BaseURL element. Can be used if streams are delivered from a different URL than the manifest file.', 'CreateJobRequest$ClientRequestToken' => 'Optional. Idempotency token for CreateJob operation.', 'CreateJobRequest$JobTemplate' => 'Optional. When you create a job, you can either specify a job template or specify the transcoding settings individually.', 'CreateJobRequest$Queue' => 'Optional. When you create a job, you can specify a queue to send it to. If you don\'t specify, the job will go to the default queue. For more about queues, see the User Guide topic at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html.', 'CreateJobRequest$Role' => 'Required. The IAM role you use for creating this job. For details about permissions, see the User Guide topic at the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html.', 'CreateJobTemplateRequest$Category' => 'Optional. A category for the job template you are creating', 'CreateJobTemplateRequest$Description' => 'Optional. A description of the job template you are creating.', 'CreateJobTemplateRequest$Name' => 'The name of the job template you are creating.', 'CreateJobTemplateRequest$Queue' => 'Optional. The queue that jobs created from this template are assigned to. If you don\'t specify this, jobs will go to the default queue.', 'CreatePresetRequest$Category' => 'Optional. A category for the preset you are creating.', 'CreatePresetRequest$Description' => 'Optional. A description of the preset you are creating.', 'CreatePresetRequest$Name' => 'The name of the preset you are creating.', 'CreateQueueRequest$Description' => 'Optional. A description of the queue that you are creating.', 'CreateQueueRequest$Name' => 'The name of the queue that you are creating.', 'DashIsoGroupSettings$BaseUrl' => 'A partial URI prefix that will be put in the manifest (.mpd) file at the top level BaseURL element. Can be used if streams are delivered from a different URL than the manifest file.', 'DeleteJobTemplateRequest$Name' => 'The name of the job template to be deleted.', 'DeletePresetRequest$Name' => 'The name of the preset to be deleted.', 'DeleteQueueRequest$Name' => 'The name of the queue that you want to delete.', 'DescribeEndpointsRequest$NextToken' => 'Use this string, provided with the response to a previous request, to request the next batch of endpoints.', 'DescribeEndpointsResponse$NextToken' => 'Use this string to request the next batch of endpoints.', 'DisassociateCertificateRequest$Arn' => 'The ARN of the ACM certificate that you want to disassociate from your MediaConvert resource.', 'Endpoint$Url' => 'URL of endpoint', 'ExceptionBody$Message' => NULL, 'GetJobRequest$Id' => 'the job ID of the job.', 'GetJobTemplateRequest$Name' => 'The name of the job template.', 'GetPresetRequest$Name' => 'The name of the preset.', 'GetQueueRequest$Name' => 'The name of the queue that you want information about.', 'HlsCaptionLanguageMapping$LanguageDescription' => 'Caption language description.', 'HlsGroupSettings$BaseUrl' => 'A partial URI prefix that will be prepended to each output in the media .m3u8 file. Can be used if base manifest is delivered from a different URL than the main .m3u8 file.', 'HlsSettings$AudioGroupId' => 'Specifies the group to which the audio Rendition belongs.', 'HlsSettings$AudioRenditionSets' => 'List all the audio groups that are used with the video output stream. Input all the audio GROUP-IDs that are associated to the video, separate by \',\'.', 'HlsSettings$SegmentModifier' => 'Use this setting to add an identifying string to the filename of each segment. The service adds this string between the name modifier and segment index number. You can use format identifiers in the string. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/using-variables-in-your-job-settings.html', 'HopDestination$Queue' => 'Optional unless the job is submitted on the default queue. When you set up a job to use queue hopping, you can specify a destination queue. This queue cannot be the original queue to which the job is submitted. If the original queue isn\'t the default queue and you don\'t specify the destination queue, the job will move to the default queue.', 'Job$Arn' => 'An identifier for this resource that is unique within all of AWS.', 'Job$ErrorMessage' => 'Error message of Job', 'Job$Id' => 'A portion of the job\'s ARN, unique within your AWS Elemental MediaConvert resources', 'Job$JobTemplate' => 'The job template that the job is created from, if it is created from a job template.', 'Job$Queue' => 'When you create a job, you can specify a queue to send it to. If you don\'t specify, the job will go to the default queue. For more about queues, see the User Guide topic at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html', 'Job$Role' => 'The IAM role you use for creating this job. For details about permissions, see the User Guide topic at the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html', 'JobTemplate$Arn' => 'An identifier for this resource that is unique within all of AWS.', 'JobTemplate$Category' => 'An optional category you create to organize your job templates.', 'JobTemplate$Description' => 'An optional description you create for each job template.', 'JobTemplate$Name' => 'A name you create for each job template. Each name must be unique within your account.', 'JobTemplate$Queue' => 'Optional. The queue that jobs created from this template are assigned to. If you don\'t specify this, jobs will go to the default queue.', 'ListJobTemplatesRequest$Category' => 'Optionally, specify a job template category to limit responses to only job templates from that category.', 'ListJobTemplatesRequest$NextToken' => 'Use this string, provided with the response to a previous request, to request the next batch of job templates.', 'ListJobTemplatesResponse$NextToken' => 'Use this string to request the next batch of job templates.', 'ListJobsRequest$NextToken' => 'Optional. Use this string, provided with the response to a previous request, to request the next batch of jobs.', 'ListJobsRequest$Queue' => 'Optional. Provide a queue name to get back only jobs from that queue.', 'ListJobsResponse$NextToken' => 'Use this string to request the next batch of jobs.', 'ListPresetsRequest$Category' => 'Optionally, specify a preset category to limit responses to only presets from that category.', 'ListPresetsRequest$NextToken' => 'Use this string, provided with the response to a previous request, to request the next batch of presets.', 'ListPresetsResponse$NextToken' => 'Use this string to request the next batch of presets.', 'ListQueuesRequest$NextToken' => 'Use this string, provided with the response to a previous request, to request the next batch of queues.', 'ListQueuesResponse$NextToken' => 'Use this string to request the next batch of queues.', 'ListTagsForResourceRequest$Arn' => 'The Amazon Resource Name (ARN) of the resource that you want to list tags for. To get the ARN, send a GET request with the resource name.', 'Mp4Settings$Mp4MajorBrand' => 'Overrides the "Major Brand" field in the output file. Usually not necessary to specify.', 'NielsenConfiguration$DistributorId' => 'Use Distributor ID (DistributorID) to specify the distributor ID that is assigned to your organization by Neilsen.', 'Output$Extension' => 'Use Extension (Extension) to specify the file extension for outputs in File output groups. If you do not specify a value, the service will use default extensions by container type as follows * MPEG-2 transport stream, m2ts * Quicktime, mov * MXF container, mxf * MPEG-4 container, mp4 * WebM container, webm * No Container, the service will use codec extensions (e.g. AAC, H265, H265, AC3)', 'OutputGroup$CustomName' => 'Use Custom Group Name (CustomName) to specify a name for the output group. This value is displayed on the console and can make your job settings JSON more human-readable. It does not affect your outputs. Use up to twelve characters that are either letters, numbers, spaces, or underscores.', 'OutputGroup$Name' => 'Name of the output group', 'Preset$Arn' => 'An identifier for this resource that is unique within all of AWS.', 'Preset$Category' => 'An optional category you create to organize your presets.', 'Preset$Description' => 'An optional description you create for each preset.', 'Preset$Name' => 'A name you create for each preset. Each name must be unique within your account.', 'Queue$Arn' => 'An identifier for this resource that is unique within all of AWS.', 'Queue$Description' => 'An optional description that you create for each queue.', 'Queue$Name' => 'A name that you create for each queue. Each name must be unique within your account.', 'QueueTransition$DestinationQueue' => 'The queue that the job was on after the transition.', 'QueueTransition$SourceQueue' => 'The queue that the job was on before the transition.', 'ResourceTags$Arn' => 'The Amazon Resource Name (ARN) of the resource.', 'SpekeKeyProvider$ResourceId' => 'Specify the resource ID that your SPEKE-compliant key provider uses to identify this content.', 'StaticKeyProvider$Url' => 'Relates to DRM implementation. The location of the license server used for protecting content.', 'TagResourceRequest$Arn' => 'The Amazon Resource Name (ARN) of the resource that you want to tag. To get the ARN, send a GET request with the resource name.', 'UntagResourceRequest$Arn' => 'The Amazon Resource Name (ARN) of the resource that you want to remove tags from. To get the ARN, send a GET request with the resource name.', 'UpdateJobTemplateRequest$Category' => 'The new category for the job template, if you are changing it.', 'UpdateJobTemplateRequest$Description' => 'The new description for the job template, if you are changing it.', 'UpdateJobTemplateRequest$Name' => 'The name of the job template you are modifying', 'UpdateJobTemplateRequest$Queue' => 'The new queue for the job template, if you are changing it.', 'UpdatePresetRequest$Category' => 'The new category for the preset, if you are changing it.', 'UpdatePresetRequest$Description' => 'The new description for the preset, if you are changing it.', 'UpdatePresetRequest$Name' => 'The name of the preset you are modifying.', 'UpdateQueueRequest$Description' => 'The new description for the queue, if you are changing it.', 'UpdateQueueRequest$Name' => 'The name of the queue that you are modifying.', '__listOf__string$member' => NULL, '__mapOf__string$member' => NULL, ], ], '__stringMin0' => [ 'base' => NULL, 'refs' => [ 'Output$Preset' => 'Use Preset (Preset) to specifiy a preset for your transcoding settings. Provide the system or custom preset name. You can specify either Preset (Preset) or Container settings (ContainerSettings), but not both.', ], ], '__stringMin1' => [ 'base' => NULL, 'refs' => [ 'CaptionDescription$CaptionSelectorName' => 'Specifies which "Caption Selector":#inputs-caption_selector to use from each input when generating captions. The name should be of the format "Caption Selector <N>", which denotes that the Nth Caption Selector will be used from each input.', 'CmafAdditionalManifest$ManifestNameModifier' => 'Specify a name modifier that the service adds to the name of this manifest to make it different from the file names of the other main manifests in the output group. For example, say that the default main manifest for your HLS group is film-name.m3u8. If you enter "-no-premium" for this setting, then the file name the service generates for this top-level manifest is film-name-no-premium.m3u8. For HLS output groups, specify a manifestNameModifier that is different from the nameModifier of the output. The service uses the output name modifier to create unique names for the individual variant manifests.', 'DashAdditionalManifest$ManifestNameModifier' => 'Specify a name modifier that the service adds to the name of this manifest to make it different from the file names of the other main manifests in the output group. For example, say that the default main manifest for your DASH group is film-name.mpd. If you enter "-no-premium" for this setting, then the file name the service generates for this top-level manifest is film-name-no-premium.mpd.', 'HlsAdditionalManifest$ManifestNameModifier' => 'Specify a name modifier that the service adds to the name of this manifest to make it different from the file names of the other main manifests in the output group. For example, say that the default main manifest for your HLS group is film-name.m3u8. If you enter "-no-premium" for this setting, then the file name the service generates for this top-level manifest is film-name-no-premium.m3u8. For HLS output groups, specify a manifestNameModifier that is different from the nameModifier of the output. The service uses the output name modifier to create unique names for the individual variant manifests.', 'MsSmoothAdditionalManifest$ManifestNameModifier' => 'Specify a name modifier that the service adds to the name of this manifest to make it different from the file names of the other main manifests in the output group. For example, say that the default main manifest for your Microsoft Smooth group is film-name.ismv. If you enter "-no-premium" for this setting, then the file name the service generates for this top-level manifest is film-name-no-premium.ismv.', 'Output$NameModifier' => 'Use Name modifier (NameModifier) to have the service add a string to the end of each output filename. You specify the base filename as part of your destination URI. When you create multiple outputs in the same output group, Name modifier (NameModifier) is required. Name modifier also accepts format identifiers. For DASH ISO outputs, if you use the format identifiers $Number$ or $Time$ in one output, you must use them in the same way in all outputs of the output group.', '__listOf__stringMin1$member' => NULL, ], ], '__stringMin11Max11Pattern01D20305D205D' => [ 'base' => NULL, 'refs' => [ 'Input$TimecodeStart' => 'Specify the timecode that you want the service to use for this input\'s initial frame. To use this setting, you must set the Timecode source setting, located under the input settings (InputTimecodeSource), to Specified start (SPECIFIEDSTART). For more information about timecodes, see https://docs.aws.amazon.com/console/mediaconvert/timecode.', 'InputTemplate$TimecodeStart' => 'Specify the timecode that you want the service to use for this input\'s initial frame. To use this setting, you must set the Timecode source setting, located under the input settings (InputTimecodeSource), to Specified start (SPECIFIEDSTART). For more information about timecodes, see https://docs.aws.amazon.com/console/mediaconvert/timecode.', 'MotionImageInserter$StartTime' => 'Specify when the motion overlay begins. Use timecode format (HH:MM:SS:FF or HH:MM:SS;FF). Make sure that the timecode you provide here takes into account how you have set up your timecode configuration under both job settings and input settings. The simplest way to do that is to set both to start at 0. If you need to set up your job to follow timecodes embedded in your source that don\'t start at zero, make sure that you specify a start time that is after the first embedded timecode. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/setting-up-timecode.html Find job-wide and input timecode configuration settings in your JSON job settings specification at settings>timecodeConfig>source and settings>inputs>timecodeSource.', ], ], '__stringMin14Max1285PatternS3Mov09PngHttpsMov09Png' => [ 'base' => NULL, 'refs' => [ 'MotionImageInserter$Input' => 'Specify the .mov file or series of .png files that you want to overlay on your video. For .png files, provide the file name of the first file in the series. Make sure that the names of the .png files end with sequential numbers that specify the order that they are played in. For example, overlay_000.png, overlay_001.png, overlay_002.png, and so on. The sequence must start at zero, and each image file name must have the same number of digits. Pad your initial file names with enough zeros to complete the sequence. For example, if the first image is overlay_0.png, there can be only 10 images in the sequence, with the last image being overlay_9.png. But if the first image is overlay_00.png, there can be 100 images in the sequence.', ], ], '__stringMin14PatternS3BmpBMPPngPNGHttpsBmpBMPPngPNG' => [ 'base' => NULL, 'refs' => [ 'AvailBlanking$AvailBlankingImage' => 'Blanking image to be used. Leave empty for solid black. Only bmp and png images are supported.', ], ], '__stringMin14PatternS3BmpBMPPngPNGTgaTGAHttpsBmpBMPPngPNGTgaTGA' => [ 'base' => NULL, 'refs' => [ 'InsertableImage$ImageInserterInput' => 'Specify the HTTP, HTTPS, or Amazon S3 location of the image that you want to overlay on the video. Use a PNG or TGA file.', ], ], '__stringMin14PatternS3SccSCCTtmlTTMLDfxpDFXPStlSTLSrtSRTXmlXMLSmiSMIHttpsSccSCCTtmlTTMLDfxpDFXPStlSTLSrtSRTXmlXMLSmiSMI' => [ 'base' => NULL, 'refs' => [ 'FileSourceSettings$SourceFile' => 'External caption file used for loading captions. Accepted file extensions are \'scc\', \'ttml\', \'dfxp\', \'stl\', \'srt\', \'xml\', and \'smi\'.', ], ], '__stringMin16Max24PatternAZaZ0922AZaZ0916' => [ 'base' => NULL, 'refs' => [ 'InputDecryptionSettings$InitializationVector' => 'Specify the initialization vector that you used when you encrypted your content before uploading it to Amazon S3. You can use a 16-byte initialization vector with any encryption mode. Or, you can use a 12-byte initialization vector with GCM or CTR. MediaConvert accepts only initialization vectors that are base64-encoded.', ], ], '__stringMin1Max100000' => [ 'base' => NULL, 'refs' => [ 'NexGuardFileMarkerSettings$License' => 'Use the base64 license string that Nagra provides you. Enter it directly in your JSON job specification or in the console. Required when you include Nagra NexGuard File Marker watermarking (NexGuardWatermarkingSettings) in your job.', ], ], '__stringMin1Max256' => [ 'base' => NULL, 'refs' => [ 'DvbNitSettings$NetworkName' => 'The network name text placed in the network_name_descriptor inside the Network Information Table. Maximum length is 256 characters.', 'DvbSdtSettings$ServiceName' => 'The service name placed in the service_descriptor in the Service Description Table. Maximum length is 256 characters.', 'DvbSdtSettings$ServiceProviderName' => 'The service provider name placed in the service_descriptor in the Service Description Table. Maximum length is 256 characters.', 'NexGuardFileMarkerSettings$Preset' => 'Enter one of the watermarking preset strings that Nagra provides you. Required when you include Nagra NexGuard File Marker watermarking (NexGuardWatermarkingSettings) in your job.', ], ], '__stringMin24Max512PatternAZaZ0902' => [ 'base' => NULL, 'refs' => [ 'InputDecryptionSettings$EncryptedDecryptionKey' => 'Warning! Don\'t provide your encryption key in plaintext. Your job settings could be intercepted, making your encrypted content vulnerable. Specify the encrypted version of the data key that you used to encrypt your content. The data key must be encrypted by AWS Key Management Service (KMS). The key can be 128, 192, or 256 bits.', ], ], '__stringMin32Max32Pattern09aFAF32' => [ 'base' => NULL, 'refs' => [ 'CmafEncryptionSettings$ConstantInitializationVector' => 'This is a 128-bit, 16-byte hex value represented by a 32-character text string. If this parameter is not set then the Initialization Vector will follow the segment number by default.', 'HlsEncryptionSettings$ConstantInitializationVector' => 'This is a 128-bit, 16-byte hex value represented by a 32-character text string. If this parameter is not set then the Initialization Vector will follow the segment number by default.', ], ], '__stringMin36Max36Pattern09aFAF809aFAF409aFAF409aFAF409aFAF12' => [ 'base' => NULL, 'refs' => [ '__listOf__stringMin36Max36Pattern09aFAF809aFAF409aFAF409aFAF409aFAF12$member' => NULL, ], ], '__stringMin3Max3Pattern1809aFAF09aEAE' => [ 'base' => NULL, 'refs' => [ 'TeletextDestinationSettings$PageNumber' => 'Set pageNumber to the Teletext page number for the destination captions for this output. This value must be a three-digit hexadecimal string; strings ending in -FF are invalid. If you are passing through the entire set of Teletext data, do not use this field.', 'TeletextSourceSettings$PageNumber' => 'Use Page Number (PageNumber) to specify the three-digit hexadecimal page number that will be used for Teletext captions. Do not use this setting if you are passing through teletext from the input source to output.', ], ], '__stringMin3Max3PatternAZaZ3' => [ 'base' => NULL, 'refs' => [ 'AudioSelector$CustomLanguageCode' => 'Selects a specific language code from within an audio source, using the ISO 639-2 or ISO 639-3 three-letter language code', 'CaptionSelector$CustomLanguageCode' => 'The specific language to extract from source, using the ISO 639-2 or ISO 639-3 three-letter language code. If input is SCTE-27, complete this field and/or PID to select the caption language to extract. If input is DVB-Sub and output is Burn-in or SMPTE-TT, complete this field and/or PID to select the caption language to extract. If input is DVB-Sub that is being passed through, omit this field (and PID field); there is no way to extract a specific language with pass-through captions.', 'HlsCaptionLanguageMapping$CustomLanguageCode' => 'Specify the language for this captions channel, using the ISO 639-2 or ISO 639-3 three-letter language code', ], ], '__stringMin9Max19PatternAZ26EastWestCentralNorthSouthEastWest1912' => [ 'base' => NULL, 'refs' => [ 'InputDecryptionSettings$KmsKeyRegion' => 'Specify the AWS Region for AWS Key Management Service (KMS) that you used to encrypt your data key, if that Region is different from the one you are using for AWS Elemental MediaConvert.', ], ], '__stringPattern' => [ 'base' => NULL, 'refs' => [ 'TimecodeBurnin$Prefix' => 'Use Prefix (Prefix) to place ASCII characters before any burned-in timecode. For example, a prefix of "EZ-" will result in the timecode "EZ-00:00:00:00". Provide either the characters themselves or the ASCII code equivalents. The supported range of characters is 0x20 through 0x7e. This includes letters, numbers, and all special characters represented on a standard English keyboard.', ], ], '__stringPattern010920405090509092' => [ 'base' => NULL, 'refs' => [ 'Id3Insertion$Timecode' => 'Provide a Timecode (TimeCode) in HH:MM:SS:FF or HH:MM:SS;FF format.', 'InputClipping$EndTimecode' => 'Set End timecode (EndTimecode) to the end of the portion of the input you are clipping. The frame corresponding to the End timecode value is included in the clip. Start timecode or End timecode may be left blank, but not both. Use the format HH:MM:SS:FF or HH:MM:SS;FF, where HH is the hour, MM is the minute, SS is the second, and FF is the frame number. When choosing this value, take into account your setting for timecode source under input settings (InputTimecodeSource). For example, if you have embedded timecodes that start at 01:00:00:00 and you want your clip to end six minutes into the video, use 01:06:00:00.', 'InputClipping$StartTimecode' => 'Set Start timecode (StartTimecode) to the beginning of the portion of the input you are clipping. The frame corresponding to the Start timecode value is included in the clip. Start timecode or End timecode may be left blank, but not both. Use the format HH:MM:SS:FF or HH:MM:SS;FF, where HH is the hour, MM is the minute, SS is the second, and FF is the frame number. When choosing this value, take into account your setting for Input timecode source. For example, if you have embedded timecodes that start at 01:00:00:00 and you want your clip to begin five minutes into the video, use 01:05:00:00.', 'TimecodeConfig$Anchor' => 'If you use an editing platform that relies on an anchor timecode, use Anchor Timecode (Anchor) to specify a timecode that will match the input video frame to the output video frame. Use 24-hour format with frame number, (HH:MM:SS:FF) or (HH:MM:SS;FF). This setting ignores frame rate conversion. System behavior for Anchor Timecode varies depending on your setting for Source (TimecodeSource). * If Source (TimecodeSource) is set to Specified Start (SPECIFIEDSTART), the first input frame is the specified value in Start Timecode (Start). Anchor Timecode (Anchor) and Start Timecode (Start) are used calculate output timecode. * If Source (TimecodeSource) is set to Start at 0 (ZEROBASED) the first frame is 00:00:00:00. * If Source (TimecodeSource) is set to Embedded (EMBEDDED), the first frame is the timecode value on the first input frame of the input.', 'TimecodeConfig$Start' => 'Only use when you set Source (TimecodeSource) to Specified start (SPECIFIEDSTART). Use Start timecode (Start) to specify the timecode for the initial frame. Use 24-hour format with frame number, (HH:MM:SS:FF) or (HH:MM:SS;FF).', ], ], '__stringPattern01D20305D205D' => [ 'base' => NULL, 'refs' => [ 'InsertableImage$StartTime' => 'Specify the timecode of the frame that you want the overlay to first appear on. This must be in timecode (HH:MM:SS:FF or HH:MM:SS;FF) format. Remember to take into account your timecode source settings.', ], ], '__stringPattern0940191020191209301' => [ 'base' => NULL, 'refs' => [ 'TimecodeConfig$TimestampOffset' => 'Only applies to outputs that support program-date-time stamp. Use Timestamp offset (TimestampOffset) to overwrite the timecode date without affecting the time and frame number. Provide the new date as a string in the format "yyyy-mm-dd". To use Time stamp offset, you must also enable Insert program-date-time (InsertProgramDateTime) in the output settings. For example, if the date part of your timecodes is 2002-1-25 and you want to change it to one year later, set Timestamp offset (TimestampOffset) to 2003-1-25.', ], ], '__stringPattern09aFAF809aFAF409aFAF409aFAF409aFAF12' => [ 'base' => NULL, 'refs' => [ '__listOf__stringPattern09aFAF809aFAF409aFAF409aFAF409aFAF12$member' => NULL, ], ], '__stringPatternAZaZ0902' => [ 'base' => NULL, 'refs' => [ 'Id3Insertion$Id3' => 'Use ID3 tag (Id3) to provide a tag value in base64-encode format.', ], ], '__stringPatternAZaZ0932' => [ 'base' => NULL, 'refs' => [ 'StaticKeyProvider$StaticKeyValue' => 'Relates to DRM implementation. Use a 32-character hexidecimal string to specify Key Value (StaticKeyValue).', ], ], '__stringPatternAZaZ23AZaZ' => [ 'base' => NULL, 'refs' => [ 'AudioDescription$CustomLanguageCode' => 'Specify the language for this audio output track. The service puts this language code into your output audio track when you set Language code control (AudioLanguageCodeControl) to Use configured (USE_CONFIGURED). The service also uses your specified custom language code when you set Language code control (AudioLanguageCodeControl) to Follow input (FOLLOW_INPUT), but your input file doesn\'t specify a language code. For all outputs, you can use an ISO 639-2 or ISO 639-3 code. For streaming outputs, you can also use any other code in the full RFC-5646 specification. Streaming outputs are those that are in one of the following output groups: CMAF, DASH ISO, Apple HLS, or Microsoft Smooth Streaming.', 'CaptionDescription$CustomLanguageCode' => 'Specify the language for this captions output track. For most captions output formats, the encoder puts this language information in the output captions metadata. If your output captions format is DVB-Sub or Burn in, the encoder uses this language information when automatically selecting the font script for rendering the captions text. For all outputs, you can use an ISO 639-2 or ISO 639-3 code. For streaming outputs, you can also use any other code in the full RFC-5646 specification. Streaming outputs are those that are in one of the following output groups: CMAF, DASH ISO, Apple HLS, or Microsoft Smooth Streaming.', 'CaptionDescriptionPreset$CustomLanguageCode' => 'Specify the language for this captions output track. For most captions output formats, the encoder puts this language information in the output captions metadata. If your output captions format is DVB-Sub or Burn in, the encoder uses this language information when automatically selecting the font script for rendering the captions text. For all outputs, you can use an ISO 639-2 or ISO 639-3 code. For streaming outputs, you can also use any other code in the full RFC-5646 specification. Streaming outputs are those that are in one of the following output groups: CMAF, DASH ISO, Apple HLS, or Microsoft Smooth Streaming.', ], ], '__stringPatternArnAwsUsGovAcm' => [ 'base' => NULL, 'refs' => [ 'SpekeKeyProvider$CertificateArn' => 'If you want your key provider to encrypt the content keys that it provides to MediaConvert, set up a certificate with a master key using AWS Certificate Manager. Specify the certificate\'s Amazon Resource Name (ARN) here.', 'SpekeKeyProviderCmaf$CertificateArn' => 'If you want your key provider to encrypt the content keys that it provides to MediaConvert, set up a certificate with a master key using AWS Certificate Manager. Specify the certificate\'s Amazon Resource Name (ARN) here.', ], ], '__stringPatternArnAwsUsGovCnKmsAZ26EastWestCentralNorthSouthEastWest1912D12KeyAFAF098AFAF094AFAF094AFAF094AFAF0912' => [ 'base' => NULL, 'refs' => [ 'S3EncryptionSettings$KmsKeyArn' => 'Optionally, specify the customer master key (CMK) that you want to use to encrypt the data key that AWS uses to encrypt your output content. Enter the Amazon Resource Name (ARN) of the CMK. To use this setting, you must also set Server-side encryption (S3ServerSideEncryptionType) to AWS KMS (SERVER_SIDE_ENCRYPTION_KMS). If you set Server-side encryption to AWS KMS but don\'t specify a CMK here, AWS uses the AWS managed CMK associated with Amazon S3.', ], ], '__stringPatternDD' => [ 'base' => NULL, 'refs' => [ 'StaticKeyProvider$KeyFormatVersions' => 'Relates to DRM implementation. Either a single positive integer version value or a slash delimited list of version values (1/2/3).', ], ], '__stringPatternHttps' => [ 'base' => NULL, 'refs' => [ 'SpekeKeyProvider$Url' => 'Specify the URL to the key server that your SPEKE-compliant DRM key provider uses to provide keys for encrypting your content.', 'SpekeKeyProviderCmaf$Url' => 'Specify the URL to the key server that your SPEKE-compliant DRM key provider uses to provide keys for encrypting your content.', ], ], '__stringPatternIdentityAZaZ26AZaZ09163' => [ 'base' => NULL, 'refs' => [ 'StaticKeyProvider$KeyFormat' => 'Relates to DRM implementation. Sets the value of the KEYFORMAT attribute. Must be \'identity\' or a reverse DNS string. May be omitted to indicate an implicit value of \'identity\'.', ], ], '__stringPatternS3' => [ 'base' => NULL, 'refs' => [ 'CmafGroupSettings$Destination' => 'Use Destination (Destination) to specify the S3 output location and the output filename base. Destination accepts format identifiers. If you do not specify the base filename in the URI, the service will use the filename of the input file. If your job has multiple inputs, the service uses the filename of the first input file.', 'DashIsoGroupSettings$Destination' => 'Use Destination (Destination) to specify the S3 output location and the output filename base. Destination accepts format identifiers. If you do not specify the base filename in the URI, the service will use the filename of the input file. If your job has multiple inputs, the service uses the filename of the first input file.', 'FileGroupSettings$Destination' => 'Use Destination (Destination) to specify the S3 output location and the output filename base. Destination accepts format identifiers. If you do not specify the base filename in the URI, the service will use the filename of the input file. If your job has multiple inputs, the service uses the filename of the first input file.', 'HlsGroupSettings$Destination' => 'Use Destination (Destination) to specify the S3 output location and the output filename base. Destination accepts format identifiers. If you do not specify the base filename in the URI, the service will use the filename of the input file. If your job has multiple inputs, the service uses the filename of the first input file.', 'MsSmoothGroupSettings$Destination' => 'Use Destination (Destination) to specify the S3 output location and the output filename base. Destination accepts format identifiers. If you do not specify the base filename in the URI, the service will use the filename of the input file. If your job has multiple inputs, the service uses the filename of the first input file.', ], ], '__stringPatternS3ASSETMAPXml' => [ 'base' => NULL, 'refs' => [ '__listOf__stringPatternS3ASSETMAPXml$member' => NULL, ], ], '__stringPatternS3MM2VVMMPPEEGGMMPP3AAVVIIMMPP4FFLLVVMMPPTTMMPPGGMM4VVTTRRPPFF4VVMM2TTSSTTSS264HH264MMKKVVMMOOVVMMTTSSMM2TTWWMMVVAASSFFVVOOBB3GGPP3GGPPPPMMXXFFDDIIVVXXXXVVIIDDRRAAWWDDVVGGXXFFMM1VV3GG2VVMMFFMM3UU8WWEEBBMMLLCCHHGGXXFFMMPPEEGG2MMXXFFMMPPEEGG2MMXXFFHHDDWWAAVVYY4MMXXMMLLHttpsMM2VVMMPPEEGGMMPP3AAVVIIMMPP4FFLLVVMMPPTTMMPPGGMM4VVTTRRPPFF4VVMM2TTSSTTSS264HH264MMKKVVMMOOVVMMTTSSMM2TTWWMMVVAASSFFVVOOBB3GGPP3GGPPPPMMXXFFDDIIVVXXXXVVIIDDRRAAWWDDVVGGXXFFMM1VV3GG2VVMMFFMM3UU8WWEEBBMMLLCCHHGGXXFFMMPPEEGG2MMXXFFMMPPEEGG2MMXXFFHHDDWWAAVVYY4MMXXMMLL' => [ 'base' => NULL, 'refs' => [ 'Input$FileInput' => 'Specify the source file for your transcoding job. You can use multiple inputs in a single job. The service concatenates these inputs, in the order that you specify them in the job, to create the outputs. If your input format is IMF, specify your input by providing the path to your CPL. For example, "s3://bucket/vf/cpl.xml". If the CPL is in an incomplete IMP, make sure to use *Supplemental IMPs* (SupplementalImps) to specify any supplemental IMPs that contain assets referenced by the CPL.', ], ], '__stringPatternS3WWEEBBMMMM2VVMMPPEEGGMMPP3AAVVIIMMPP4FFLLVVMMPPTTMMPPGGMM4VVTTRRPPFF4VVMM2TTSSTTSS264HH264MMKKVVMMOOVVMMTTSSMM2TTWWMMVVAASSFFVVOOBB3GGPP3GGPPPPMMXXFFDDIIVVXXXXVVIIDDRRAAWWDDVVGGXXFFMM1VV3GG2VVMMFFMM3UU8LLCCHHGGXXFFMMPPEEGG2MMXXFFMMPPEEGG2MMXXFFHHDDWWAAVVYY4MMAAAACCAAIIFFFFMMPP2AACC3EECC3DDTTSSEEHttpsMM2VVMMPPEEGGMMPP3AAVVIIMMPP4FFLLVVMMPPTTMMPPGGMM4VVTTRRPPFF4VVMM2TTSSTTSS264HH264MMKKVVMMOOVVMMTTSSMM2TTWWMMVVAASSFFVVOOBB3GGPP3GGPPPPMMXXFFDDIIVVXXXXVVIIDDRRAAWWDDVVGGXXFFMM1VV3GG2VVMMFFMM3UU8LLCCHHGGXXFFMMPPEEGG2MMXXFFMMPPEEGG2MMXXFFHHDDWWAAVVYY4MMAAAACCAAIIFFFFMMPP2AACC3EECC3DDTTSSEE' => [ 'base' => NULL, 'refs' => [ 'AudioSelector$ExternalAudioFileInput' => 'Specifies audio data from an external file source.', ], ], '__stringPatternSNManifestConfirmConditionNotificationNS' => [ 'base' => NULL, 'refs' => [ 'EsamManifestConfirmConditionNotification$MccXml' => 'Provide your ESAM ManifestConfirmConditionNotification XML document inside your JSON job settings. Form the XML document as per OC-SP-ESAM-API-I03-131025. The transcoder will use the Manifest Conditioning instructions in the message that you supply.', ], ], '__stringPatternSNSignalProcessingNotificationNS' => [ 'base' => NULL, 'refs' => [ 'EsamSignalProcessingNotification$SccXml' => 'Provide your ESAM SignalProcessingNotification XML document inside your JSON job settings. Form the XML document as per OC-SP-ESAM-API-I03-131025. The transcoder will use the signal processing instructions in the message that you supply. Provide your ESAM SignalProcessingNotification XML document inside your JSON job settings. For your MPEG2-TS file outputs, if you want the service to place SCTE-35 markers at the insertion points you specify in the XML document, you must also enable SCTE-35 ESAM (scte35Esam). Note that you can either specify an ESAM XML document or enable SCTE-35 passthrough. You can\'t do both.', ], ], '__stringPatternW' => [ 'base' => NULL, 'refs' => [ 'SpekeKeyProviderCmaf$ResourceId' => 'Specify the resource ID that your SPEKE-compliant key provider uses to identify this content.', ], ], '__stringPatternWS' => [ 'base' => NULL, 'refs' => [ 'AudioDescription$StreamName' => 'Specify a label for this output audio stream. For example, "English", "Director commentary", or "track_2". For streaming outputs, MediaConvert passes this information into destination manifests for display on the end-viewer\'s player device. For outputs in other output groups, the service ignores this setting.', ], ], '__timestampUnix' => [ 'base' => NULL, 'refs' => [ 'Job$CreatedAt' => 'The time, in Unix epoch format in seconds, when the job got created.', 'JobTemplate$CreatedAt' => 'The timestamp in epoch seconds for Job template creation.', 'JobTemplate$LastUpdated' => 'The timestamp in epoch seconds when the Job template was last updated.', 'Preset$CreatedAt' => 'The timestamp in epoch seconds for preset creation.', 'Preset$LastUpdated' => 'The timestamp in epoch seconds when the preset was last updated.', 'Queue$CreatedAt' => 'The timestamp in epoch seconds for when you created the queue.', 'Queue$LastUpdated' => 'The timestamp in epoch seconds for when you most recently updated the queue.', 'QueueTransition$Timestamp' => 'The time, in Unix epoch format, that the job moved from the source queue to the destination queue.', 'ReservationPlan$ExpiresAt' => 'The timestamp in epoch seconds for when the current pricing plan term for this reserved queue expires.', 'ReservationPlan$PurchasedAt' => 'The timestamp in epoch seconds for when you set up the current pricing plan for this reserved queue.', 'Timing$FinishTime' => 'The time, in Unix epoch format, that the transcoding job finished', 'Timing$StartTime' => 'The time, in Unix epoch format, that transcoding for the job began.', 'Timing$SubmitTime' => 'The time, in Unix epoch format, that you submitted the job.', ], ], ],];
