<?php
// This file was auto-generated from sdk-root/src/data/machinelearning/2014-12-12/docs-2.json
return [ 'version' => '2.0', 'operations' => [ 'AddTags' => '<p>Adds one or more tags to an object, up to a limit of 10. Each tag consists of a key and an optional value. If you add a tag using a key that is already associated with the ML object, <code>AddTags</code> updates the tag\'s value.</p>', 'CreateBatchPrediction' => '<p>Generates predictions for a group of observations. The observations to process exist in one or more data files referenced by a <code>DataSource</code>. This operation creates a new <code>BatchPrediction</code>, and uses an <code>MLModel</code> and the data files referenced by the <code>DataSource</code> as information sources. </p> <p><code>CreateBatchPrediction</code> is an asynchronous operation. In response to <code>CreateBatchPrediction</code>, Amazon Machine Learning (Amazon ML) immediately returns and sets the <code>BatchPrediction</code> status to <code>PENDING</code>. After the <code>BatchPrediction</code> completes, Amazon ML sets the status to <code>COMPLETED</code>. </p> <p>You can poll for status updates by using the <a>GetBatchPrediction</a> operation and checking the <code>Status</code> parameter of the result. After the <code>COMPLETED</code> status appears, the results are available in the location specified by the <code>OutputUri</code> parameter.</p>', 'CreateDataSourceFromRDS' => '<p>Creates a <code>DataSource</code> object from an <a href="http://aws.amazon.com/rds/"> Amazon Relational Database Service</a> (Amazon RDS). A <code>DataSource</code> references data that can be used to perform <code>CreateMLModel</code>, <code>CreateEvaluation</code>, or <code>CreateBatchPrediction</code> operations.</p> <p><code>CreateDataSourceFromRDS</code> is an asynchronous operation. In response to <code>CreateDataSourceFromRDS</code>, Amazon Machine Learning (Amazon ML) immediately returns and sets the <code>DataSource</code> status to <code>PENDING</code>. After the <code>DataSource</code> is created and ready for use, Amazon ML sets the <code>Status</code> parameter to <code>COMPLETED</code>. <code>DataSource</code> in the <code>COMPLETED</code> or <code>PENDING</code> state can be used only to perform <code>&gt;CreateMLModel</code>&gt;, <code>CreateEvaluation</code>, or <code>CreateBatchPrediction</code> operations. </p> <p> If Amazon ML cannot accept the input source, it sets the <code>Status</code> parameter to <code>FAILED</code> and includes an error message in the <code>Message</code> attribute of the <code>GetDataSource</code> operation response. </p>', 'CreateDataSourceFromRedshift' => '<p>Creates a <code>DataSource</code> from a database hosted on an Amazon Redshift cluster. A <code>DataSource</code> references data that can be used to perform either <code>CreateMLModel</code>, <code>CreateEvaluation</code>, or <code>CreateBatchPrediction</code> operations.</p> <p><code>CreateDataSourceFromRedshift</code> is an asynchronous operation. In response to <code>CreateDataSourceFromRedshift</code>, Amazon Machine Learning (Amazon ML) immediately returns and sets the <code>DataSource</code> status to <code>PENDING</code>. After the <code>DataSource</code> is created and ready for use, Amazon ML sets the <code>Status</code> parameter to <code>COMPLETED</code>. <code>DataSource</code> in <code>COMPLETED</code> or <code>PENDING</code> states can be used to perform only <code>CreateMLModel</code>, <code>CreateEvaluation</code>, or <code>CreateBatchPrediction</code> operations. </p> <p> If Amazon ML can\'t accept the input source, it sets the <code>Status</code> parameter to <code>FAILED</code> and includes an error message in the <code>Message</code> attribute of the <code>GetDataSource</code> operation response. </p> <p>The observations should be contained in the database hosted on an Amazon Redshift cluster and should be specified by a <code>SelectSqlQuery</code> query. Amazon ML executes an <code>Unload</code> command in Amazon Redshift to transfer the result set of the <code>SelectSqlQuery</code> query to <code>S3StagingLocation</code>.</p> <p>After the <code>DataSource</code> has been created, it\'s ready for use in evaluations and batch predictions. If you plan to use the <code>DataSource</code> to train an <code>MLModel</code>, the <code>DataSource</code> also requires a recipe. A recipe describes how each input variable will be used in training an <code>MLModel</code>. Will the variable be included or excluded from training? Will the variable be manipulated; for example, will it be combined with another variable or will it be split apart into word combinations? The recipe provides answers to these questions.</p> <?oxy_insert_start author="laurama" timestamp="20160406T153842-0700"><p>You can\'t change an existing datasource, but you can copy and modify the settings from an existing Amazon Redshift datasource to create a new datasource. To do so, call <code>GetDataSource</code> for an existing datasource and copy the values to a <code>CreateDataSource</code> call. Change the settings that you want to change and make sure that all required fields have the appropriate values.</p> <?oxy_insert_end>', 'CreateDataSourceFromS3' => '<p>Creates a <code>DataSource</code> object. A <code>DataSource</code> references data that can be used to perform <code>CreateMLModel</code>, <code>CreateEvaluation</code>, or <code>CreateBatchPrediction</code> operations.</p> <p><code>CreateDataSourceFromS3</code> is an asynchronous operation. In response to <code>CreateDataSourceFromS3</code>, Amazon Machine Learning (Amazon ML) immediately returns and sets the <code>DataSource</code> status to <code>PENDING</code>. After the <code>DataSource</code> has been created and is ready for use, Amazon ML sets the <code>Status</code> parameter to <code>COMPLETED</code>. <code>DataSource</code> in the <code>COMPLETED</code> or <code>PENDING</code> state can be used to perform only <code>CreateMLModel</code>, <code>CreateEvaluation</code> or <code>CreateBatchPrediction</code> operations. </p> <p> If Amazon ML can\'t accept the input source, it sets the <code>Status</code> parameter to <code>FAILED</code> and includes an error message in the <code>Message</code> attribute of the <code>GetDataSource</code> operation response. </p> <p>The observation data used in a <code>DataSource</code> should be ready to use; that is, it should have a consistent structure, and missing data values should be kept to a minimum. The observation data must reside in one or more .csv files in an Amazon Simple Storage Service (Amazon S3) location, along with a schema that describes the data items by name and type. The same schema must be used for all of the data files referenced by the <code>DataSource</code>. </p> <p>After the <code>DataSource</code> has been created, it\'s ready to use in evaluations and batch predictions. If you plan to use the <code>DataSource</code> to train an <code>MLModel</code>, the <code>DataSource</code> also needs a recipe. A recipe describes how each input variable will be used in training an <code>MLModel</code>. Will the variable be included or excluded from training? Will the variable be manipulated; for example, will it be combined with another variable or will it be split apart into word combinations? The recipe provides answers to these questions.</p>', 'CreateEvaluation' => '<p>Creates a new <code>Evaluation</code> of an <code>MLModel</code>. An <code>MLModel</code> is evaluated on a set of observations associated to a <code>DataSource</code>. Like a <code>DataSource</code> for an <code>MLModel</code>, the <code>DataSource</code> for an <code>Evaluation</code> contains values for the <code>Target Variable</code>. The <code>Evaluation</code> compares the predicted result for each observation to the actual outcome and provides a summary so that you know how effective the <code>MLModel</code> functions on the test data. Evaluation generates a relevant performance metric, such as BinaryAUC, RegressionRMSE or MulticlassAvgFScore based on the corresponding <code>MLModelType</code>: <code>BINARY</code>, <code>REGRESSION</code> or <code>MULTICLASS</code>. </p> <p><code>CreateEvaluation</code> is an asynchronous operation. In response to <code>CreateEvaluation</code>, Amazon Machine Learning (Amazon ML) immediately returns and sets the evaluation status to <code>PENDING</code>. After the <code>Evaluation</code> is created and ready for use, Amazon ML sets the status to <code>COMPLETED</code>. </p> <p>You can use the <code>GetEvaluation</code> operation to check progress of the evaluation during the creation operation.</p>', 'CreateMLModel' => '<p>Creates a new <code>MLModel</code> using the <code>DataSource</code> and the recipe as information sources. </p> <p>An <code>MLModel</code> is nearly immutable. Users can update only the <code>MLModelName</code> and the <code>ScoreThreshold</code> in an <code>MLModel</code> without creating a new <code>MLModel</code>. </p> <p><code>CreateMLModel</code> is an asynchronous operation. In response to <code>CreateMLModel</code>, Amazon Machine Learning (Amazon ML) immediately returns and sets the <code>MLModel</code> status to <code>PENDING</code>. After the <code>MLModel</code> has been created and ready is for use, Amazon ML sets the status to <code>COMPLETED</code>. </p> <p>You can use the <code>GetMLModel</code> operation to check the progress of the <code>MLModel</code> during the creation operation.</p> <p> <code>CreateMLModel</code> requires a <code>DataSource</code> with computed statistics, which can be created by setting <code>ComputeStatistics</code> to <code>true</code> in <code>CreateDataSourceFromRDS</code>, <code>CreateDataSourceFromS3</code>, or <code>CreateDataSourceFromRedshift</code> operations. </p>', 'CreateRealtimeEndpoint' => '<p>Creates a real-time endpoint for the <code>MLModel</code>. The endpoint contains the URI of the <code>MLModel</code>; that is, the location to send real-time prediction requests for the specified <code>MLModel</code>.</p>', 'DeleteBatchPrediction' => '<p>Assigns the DELETED status to a <code>BatchPrediction</code>, rendering it unusable.</p> <p>After using the <code>DeleteBatchPrediction</code> operation, you can use the <a>GetBatchPrediction</a> operation to verify that the status of the <code>BatchPrediction</code> changed to DELETED.</p> <p><b>Caution:</b> The result of the <code>DeleteBatchPrediction</code> operation is irreversible.</p>', 'DeleteDataSource' => '<p>Assigns the DELETED status to a <code>DataSource</code>, rendering it unusable.</p> <p>After using the <code>DeleteDataSource</code> operation, you can use the <a>GetDataSource</a> operation to verify that the status of the <code>DataSource</code> changed to DELETED.</p> <p><b>Caution:</b> The results of the <code>DeleteDataSource</code> operation are irreversible.</p>', 'DeleteEvaluation' => '<p>Assigns the <code>DELETED</code> status to an <code>Evaluation</code>, rendering it unusable.</p> <p>After invoking the <code>DeleteEvaluation</code> operation, you can use the <code>GetEvaluation</code> operation to verify that the status of the <code>Evaluation</code> changed to <code>DELETED</code>.</p> <caution><title>Caution</title> <p>The results of the <code>DeleteEvaluation</code> operation are irreversible.</p></caution>', 'DeleteMLModel' => '<p>Assigns the <code>DELETED</code> status to an <code>MLModel</code>, rendering it unusable.</p> <p>After using the <code>DeleteMLModel</code> operation, you can use the <code>GetMLModel</code> operation to verify that the status of the <code>MLModel</code> changed to DELETED.</p> <p><b>Caution:</b> The result of the <code>DeleteMLModel</code> operation is irreversible.</p>', 'DeleteRealtimeEndpoint' => '<p>Deletes a real time endpoint of an <code>MLModel</code>.</p>', 'DeleteTags' => '<p>Deletes the specified tags associated with an ML object. After this operation is complete, you can\'t recover deleted tags.</p> <p>If you specify a tag that doesn\'t exist, Amazon ML ignores it.</p>', 'DescribeBatchPredictions' => '<p>Returns a list of <code>BatchPrediction</code> operations that match the search criteria in the request.</p>', 'DescribeDataSources' => '<p>Returns a list of <code>DataSource</code> that match the search criteria in the request.</p>', 'DescribeEvaluations' => '<p>Returns a list of <code>DescribeEvaluations</code> that match the search criteria in the request.</p>', 'DescribeMLModels' => '<p>Returns a list of <code>MLModel</code> that match the search criteria in the request.</p>', 'DescribeTags' => '<p>Describes one or more of the tags for your Amazon ML object.</p>', 'GetBatchPrediction' => '<p>Returns a <code>BatchPrediction</code> that includes detailed metadata, status, and data file information for a <code>Batch Prediction</code> request.</p>', 'GetDataSource' => '<p>Returns a <code>DataSource</code> that includes metadata and data file information, as well as the current status of the <code>DataSource</code>.</p> <p><code>GetDataSource</code> provides results in normal or verbose format. The verbose format adds the schema description and the list of files pointed to by the DataSource to the normal format.</p>', 'GetEvaluation' => '<p>Returns an <code>Evaluation</code> that includes metadata as well as the current status of the <code>Evaluation</code>.</p>', 'GetMLModel' => '<p>Returns an <code>MLModel</code> that includes detailed metadata, data source information, and the current status of the <code>MLModel</code>.</p> <p><code>GetMLModel</code> provides results in normal or verbose format. </p>', 'Predict' => '<p>Generates a prediction for the observation using the specified <code>ML Model</code>.</p> <note><title>Note</title> <p>Not all response parameters will be populated. Whether a response parameter is populated depends on the type of model requested.</p></note>', 'UpdateBatchPrediction' => '<p>Updates the <code>BatchPredictionName</code> of a <code>BatchPrediction</code>.</p> <p>You can use the <code>GetBatchPrediction</code> operation to view the contents of the updated data element.</p>', 'UpdateDataSource' => '<p>Updates the <code>DataSourceName</code> of a <code>DataSource</code>.</p> <p>You can use the <code>GetDataSource</code> operation to view the contents of the updated data element.</p>', 'UpdateEvaluation' => '<p>Updates the <code>EvaluationName</code> of an <code>Evaluation</code>.</p> <p>You can use the <code>GetEvaluation</code> operation to view the contents of the updated data element.</p>', 'UpdateMLModel' => '<p>Updates the <code>MLModelName</code> and the <code>ScoreThreshold</code> of an <code>MLModel</code>.</p> <p>You can use the <code>GetMLModel</code> operation to view the contents of the updated data element.</p>', ], 'service' => 'Definition of the public APIs exposed by Amazon Machine Learning', 'shapes' => [ 'AddTagsInput' => [ 'base' => NULL, 'refs' => [], ], 'AddTagsOutput' => [ 'base' => '<p>Amazon ML returns the following elements. </p>', 'refs' => [], ], 'Algorithm' => [ 'base' => '<p>The function used to train an <code>MLModel</code>. Training choices supported by Amazon ML include the following:</p> <ul> <li> <code>SGD</code> - Stochastic Gradient Descent.</li> <li> <code>RandomForest</code> - Random forest of decision trees.</li> </ul>', 'refs' => [ 'MLModel$Algorithm' => '<p>The algorithm used to train the <code>MLModel</code>. The following algorithm is supported:</p> <ul> <li> <code>SGD</code> -- Stochastic gradient descent. The goal of <code>SGD</code> is to minimize the gradient of the loss function. </li> </ul>', ], ], 'AwsUserArn' => [ 'base' => '<p>An Amazon Web Service (AWS) user account identifier. The account identifier can be an AWS root account or an AWS Identity and Access Management (IAM) user.</p>', 'refs' => [ 'BatchPrediction$CreatedByIamUser' => '<p>The AWS user account that invoked the <code>BatchPrediction</code>. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.</p>', 'DataSource$CreatedByIamUser' => '<p>The AWS user account from which the <code>DataSource</code> was created. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.</p>', 'Evaluation$CreatedByIamUser' => '<p>The AWS user account that invoked the evaluation. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.</p>', 'GetBatchPredictionOutput$CreatedByIamUser' => '<p>The AWS user account that invoked the <code>BatchPrediction</code>. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.</p>', 'GetDataSourceOutput$CreatedByIamUser' => '<p>The AWS user account from which the <code>DataSource</code> was created. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.</p>', 'GetEvaluationOutput$CreatedByIamUser' => '<p>The AWS user account that invoked the evaluation. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.</p>', 'GetMLModelOutput$CreatedByIamUser' => '<p>The AWS user account from which the <code>MLModel</code> was created. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.</p>', 'MLModel$CreatedByIamUser' => '<p>The AWS user account from which the <code>MLModel</code> was created. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.</p>', ], ], 'BatchPrediction' => [ 'base' => '<p> Represents the output of a <code>GetBatchPrediction</code> operation.</p> <p> The content consists of the detailed metadata, the status, and the data file information of a <code>Batch Prediction</code>.</p>', 'refs' => [ 'BatchPredictions$member' => NULL, ], ], 'BatchPredictionFilterVariable' => [ 'base' => '<p>A list of the variables to use in searching or filtering <code>BatchPrediction</code>.</p> <ul> <li> <code>CreatedAt</code> - Sets the search criteria to <code>BatchPrediction</code> creation date.</li> <li> <code>Status</code> - Sets the search criteria to <code>BatchPrediction</code> status.</li> <li> <code>Name</code> - Sets the search criteria to the contents of <code>BatchPrediction</code><b> </b> <code>Name</code>.</li> <li> <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>BatchPrediction</code> creation.</li> <li> <code>MLModelId</code> - Sets the search criteria to the <code>MLModel</code> used in the <code>BatchPrediction</code>.</li> <li> <code>DataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used in the <code>BatchPrediction</code>.</li> <li> <code>DataURI</code> - Sets the search criteria to the data file(s) used in the <code>BatchPrediction</code>. The URL can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.</li> </ul>', 'refs' => [ 'DescribeBatchPredictionsInput$FilterVariable' => '<p>Use one of the following variables to filter a list of <code>BatchPrediction</code>:</p> <ul> <li> <code>CreatedAt</code> - Sets the search criteria to the <code>BatchPrediction</code> creation date.</li> <li> <code>Status</code> - Sets the search criteria to the <code>BatchPrediction</code> status.</li> <li> <code>Name</code> - Sets the search criteria to the contents of the <code>BatchPrediction</code><b> </b> <code>Name</code>.</li> <li> <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>BatchPrediction</code> creation.</li> <li> <code>MLModelId</code> - Sets the search criteria to the <code>MLModel</code> used in the <code>BatchPrediction</code>.</li> <li> <code>DataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used in the <code>BatchPrediction</code>.</li> <li> <code>DataURI</code> - Sets the search criteria to the data file(s) used in the <code>BatchPrediction</code>. The URL can identify either a file or an Amazon Simple Storage Solution (Amazon S3) bucket or directory.</li> </ul>', ], ], 'BatchPredictions' => [ 'base' => NULL, 'refs' => [ 'DescribeBatchPredictionsOutput$Results' => '<p>A list of <code>BatchPrediction</code> objects that meet the search criteria. </p>', ], ], 'ComparatorValue' => [ 'base' => '<p>The value specified in a filtering condition. The <code>ComparatorValue</code> becomes the reference value when matching or evaluating data values in filtering and searching functions.</p>', 'refs' => [ 'DescribeBatchPredictionsInput$EQ' => '<p>The equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>', 'DescribeBatchPredictionsInput$GT' => '<p>The greater than operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>', 'DescribeBatchPredictionsInput$LT' => '<p>The less than operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>', 'DescribeBatchPredictionsInput$GE' => '<p>The greater than or equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>. </p>', 'DescribeBatchPredictionsInput$LE' => '<p>The less than or equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>', 'DescribeBatchPredictionsInput$NE' => '<p>The not equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>', 'DescribeBatchPredictionsInput$Prefix' => '<p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p> <p>For example, a <code>Batch Prediction</code> operation could have the <code>Name</code> <code>2014-09-09-HolidayGiftMailer</code>. To search for this <code>BatchPrediction</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the <code>Prefix</code>: </p> <ul> <li><p>2014-09</p></li> <li><p>2014-09-09</p></li> <li><p>2014-09-09-Holiday</p></li> </ul>', 'DescribeDataSourcesInput$EQ' => '<p>The equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>', 'DescribeDataSourcesInput$GT' => '<p>The greater than operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>', 'DescribeDataSourcesInput$LT' => '<p>The less than operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>', 'DescribeDataSourcesInput$GE' => '<p>The greater than or equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>. </p>', 'DescribeDataSourcesInput$LE' => '<p>The less than or equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>', 'DescribeDataSourcesInput$NE' => '<p>The not equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>', 'DescribeDataSourcesInput$Prefix' => '<p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p> <p>For example, a <code>DataSource</code> could have the <code>Name</code> <code>2014-09-09-HolidayGiftMailer</code>. To search for this <code>DataSource</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the <code>Prefix</code>: </p> <ul> <li><p>2014-09</p></li> <li><p>2014-09-09</p></li> <li><p>2014-09-09-Holiday</p></li> </ul>', 'DescribeEvaluationsInput$EQ' => '<p>The equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>', 'DescribeEvaluationsInput$GT' => '<p>The greater than operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>', 'DescribeEvaluationsInput$LT' => '<p>The less than operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>', 'DescribeEvaluationsInput$GE' => '<p>The greater than or equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>. </p>', 'DescribeEvaluationsInput$LE' => '<p>The less than or equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>', 'DescribeEvaluationsInput$NE' => '<p>The not equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>', 'DescribeEvaluationsInput$Prefix' => '<p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p> <p>For example, an <code>Evaluation</code> could have the <code>Name</code> <code>2014-09-09-HolidayGiftMailer</code>. To search for this <code>Evaluation</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the <code>Prefix</code>: </p> <ul> <li><p>2014-09</p></li> <li><p>2014-09-09</p></li> <li><p>2014-09-09-Holiday</p></li> </ul>', 'DescribeMLModelsInput$EQ' => '<p>The equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>', 'DescribeMLModelsInput$GT' => '<p>The greater than operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>', 'DescribeMLModelsInput$LT' => '<p>The less than operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>', 'DescribeMLModelsInput$GE' => '<p>The greater than or equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>. </p>', 'DescribeMLModelsInput$LE' => '<p>The less than or equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>', 'DescribeMLModelsInput$NE' => '<p>The not equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>', 'DescribeMLModelsInput$Prefix' => '<p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p> <p>For example, an <code>MLModel</code> could have the <code>Name</code> <code>2014-09-09-HolidayGiftMailer</code>. To search for this <code>MLModel</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the <code>Prefix</code>: </p> <ul> <li><p>2014-09</p></li> <li><p>2014-09-09</p></li> <li><p>2014-09-09-Holiday</p></li> </ul>', ], ], 'ComputeStatistics' => [ 'base' => NULL, 'refs' => [ 'CreateDataSourceFromRDSInput$ComputeStatistics' => '<p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training. This parameter must be set to <code>true</code> if the <code></code>DataSource<code></code> needs to be used for <code>MLModel</code> training. </p>', 'CreateDataSourceFromRedshiftInput$ComputeStatistics' => '<p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training. This parameter must be set to <code>true</code> if the <code>DataSource</code> needs to be used for <code>MLModel</code> training.</p>', 'CreateDataSourceFromS3Input$ComputeStatistics' => '<p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training. This parameter must be set to <code>true</code> if the <code></code>DataSource<code></code> needs to be used for <code>MLModel</code> training.</p>', 'DataSource$ComputeStatistics' => '<p> The parameter is <code>true</code> if statistics need to be generated from the observation data. </p>', 'GetDataSourceOutput$ComputeStatistics' => '<p> The parameter is <code>true</code> if statistics need to be generated from the observation data. </p>', ], ], 'CreateBatchPredictionInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateBatchPredictionOutput' => [ 'base' => '<p> Represents the output of a <code>CreateBatchPrediction</code> operation, and is an acknowledgement that Amazon ML received the request.</p> <p>The <code>CreateBatchPrediction</code> operation is asynchronous. You can poll for status updates by using the <code>&gt;GetBatchPrediction</code> operation and checking the <code>Status</code> parameter of the result. </p>', 'refs' => [], ], 'CreateDataSourceFromRDSInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataSourceFromRDSOutput' => [ 'base' => '<p> Represents the output of a <code>CreateDataSourceFromRDS</code> operation, and is an acknowledgement that Amazon ML received the request.</p> <p>The <code>CreateDataSourceFromRDS</code>&gt; operation is asynchronous. You can poll for updates by using the <code>GetBatchPrediction</code> operation and checking the <code>Status</code> parameter. You can inspect the <code>Message</code> when <code>Status</code> shows up as <code>FAILED</code>. You can also check the progress of the copy operation by going to the <code>DataPipeline</code> console and looking up the pipeline using the <code>pipelineId </code> from the describe call.</p>', 'refs' => [], ], 'CreateDataSourceFromRedshiftInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataSourceFromRedshiftOutput' => [ 'base' => '<p> Represents the output of a <code>CreateDataSourceFromRedshift</code> operation, and is an acknowledgement that Amazon ML received the request.</p> <p>The <code>CreateDataSourceFromRedshift</code> operation is asynchronous. You can poll for updates by using the <code>GetBatchPrediction</code> operation and checking the <code>Status</code> parameter. </p>', 'refs' => [], ], 'CreateDataSourceFromS3Input' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataSourceFromS3Output' => [ 'base' => '<p> Represents the output of a <code>CreateDataSourceFromS3</code> operation, and is an acknowledgement that Amazon ML received the request.</p> <p>The <code>CreateDataSourceFromS3</code> operation is asynchronous. You can poll for updates by using the <code>GetBatchPrediction</code> operation and checking the <code>Status</code> parameter. </p>', 'refs' => [], ], 'CreateEvaluationInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateEvaluationOutput' => [ 'base' => '<p> Represents the output of a <code>CreateEvaluation</code> operation, and is an acknowledgement that Amazon ML received the request.</p> <p><code>CreateEvaluation</code> operation is asynchronous. You can poll for status updates by using the <code>GetEvcaluation</code> operation and checking the <code>Status</code> parameter. </p>', 'refs' => [], ], 'CreateMLModelInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateMLModelOutput' => [ 'base' => '<p> Represents the output of a <code>CreateMLModel</code> operation, and is an acknowledgement that Amazon ML received the request.</p> <p>The <code>CreateMLModel</code> operation is asynchronous. You can poll for status updates by using the <code>GetMLModel</code> operation and checking the <code>Status</code> parameter. </p>', 'refs' => [], ], 'CreateRealtimeEndpointInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateRealtimeEndpointOutput' => [ 'base' => '<p>Represents the output of an <code>CreateRealtimeEndpoint</code> operation.</p> <p>The result contains the <code>MLModelId</code> and the endpoint information for the <code>MLModel</code>.</p> <note> <p>The endpoint information includes the URI of the <code>MLModel</code>; that is, the location to send online prediction requests for the specified <code>MLModel</code>.</p> </note>', 'refs' => [], ], 'DataRearrangement' => [ 'base' => NULL, 'refs' => [ 'DataSource$DataRearrangement' => '<p>A JSON string that represents the splitting and rearrangement requirement used when this <code>DataSource</code> was created.</p>', 'GetDataSourceOutput$DataRearrangement' => '<p>A JSON string that represents the splitting and rearrangement requirement used when this <code>DataSource</code> was created.</p>', 'RDSDataSpec$DataRearrangement' => '<p>A JSON string that represents the splitting and rearrangement processing to be applied to a <code>DataSource</code>. If the <code>DataRearrangement</code> parameter is not provided, all of the input data is used to create the <code>Datasource</code>.</p> <p>There are multiple parameters that control what data is used to create a datasource:</p> <ul> <li><p><b><code>percentBegin</code></b></p> <p>Use <code>percentBegin</code> to indicate the beginning of the range of the data used to create the Datasource. If you do not include <code>percentBegin</code> and <code>percentEnd</code>, Amazon ML includes all of the data when creating the datasource.</p></li> <li><p><b><code>percentEnd</code></b></p> <p>Use <code>percentEnd</code> to indicate the end of the range of the data used to create the Datasource. If you do not include <code>percentBegin</code> and <code>percentEnd</code>, Amazon ML includes all of the data when creating the datasource.</p></li> <li><p><b><code>complement</code></b></p> <p>The <code>complement</code> parameter instructs Amazon ML to use the data that is not included in the range of <code>percentBegin</code> to <code>percentEnd</code> to create a datasource. The <code>complement</code> parameter is useful if you need to create complementary datasources for training and evaluation. To create a complementary datasource, use the same values for <code>percentBegin</code> and <code>percentEnd</code>, along with the <code>complement</code> parameter.</p> <p>For example, the following two datasources do not share any data, and can be used to train and evaluate a model. The first datasource has 25 percent of the data, and the second one has 75 percent of the data.</p> <p>Datasource for evaluation: <code>{"splitting":{"percentBegin":0, "percentEnd":25}}</code></p> <p>Datasource for training: <code>{"splitting":{"percentBegin":0, "percentEnd":25, "complement":"true"}}</code></p> </li> <li><p><b><code>strategy</code></b></p> <p>To change how Amazon ML splits the data for a datasource, use the <code>strategy</code> parameter.</p> <p>The default value for the <code>strategy</code> parameter is <code>sequential</code>, meaning that Amazon ML takes all of the data records between the <code>percentBegin</code> and <code>percentEnd</code> parameters for the datasource, in the order that the records appear in the input data.</p> <p>The following two <code>DataRearrangement</code> lines are examples of sequentially ordered training and evaluation datasources:</p> <p>Datasource for evaluation: <code>{"splitting":{"percentBegin":70, "percentEnd":100, "strategy":"sequential"}}</code></p> <p>Datasource for training: <code>{"splitting":{"percentBegin":70, "percentEnd":100, "strategy":"sequential", "complement":"true"}}</code></p> <p>To randomly split the input data into the proportions indicated by the percentBegin and percentEnd parameters, set the <code>strategy</code> parameter to <code>random</code> and provide a string that is used as the seed value for the random data splitting (for example, you can use the S3 path to your data as the random seed string). If you choose the random split strategy, Amazon ML assigns each row of data a pseudo-random number between 0 and 100, and then selects the rows that have an assigned number between <code>percentBegin</code> and <code>percentEnd</code>. Pseudo-random numbers are assigned using both the input seed string value and the byte offset as a seed, so changing the data results in a different split. Any existing ordering is preserved. The random splitting strategy ensures that variables in the training and evaluation data are distributed similarly. It is useful in the cases where the input data may have an implicit sort order, which would otherwise result in training and evaluation datasources containing non-similar data records.</p> <p>The following two <code>DataRearrangement</code> lines are examples of non-sequentially ordered training and evaluation datasources:</p> <p>Datasource for evaluation: <code>{"splitting":{"percentBegin":70, "percentEnd":100, "strategy":"random", "randomSeed"="s3://my_s3_path/bucket/file.csv"}}</code></p> <p>Datasource for training: <code>{"splitting":{"percentBegin":70, "percentEnd":100, "strategy":"random", "randomSeed"="s3://my_s3_path/bucket/file.csv", "complement":"true"}}</code></p> </li> </ul>', 'RedshiftDataSpec$DataRearrangement' => '<p>A JSON string that represents the splitting and rearrangement processing to be applied to a <code>DataSource</code>. If the <code>DataRearrangement</code> parameter is not provided, all of the input data is used to create the <code>Datasource</code>.</p> <p>There are multiple parameters that control what data is used to create a datasource:</p> <ul> <li><p><b><code>percentBegin</code></b></p> <p>Use <code>percentBegin</code> to indicate the beginning of the range of the data used to create the Datasource. If you do not include <code>percentBegin</code> and <code>percentEnd</code>, Amazon ML includes all of the data when creating the datasource.</p></li> <li><p><b><code>percentEnd</code></b></p> <p>Use <code>percentEnd</code> to indicate the end of the range of the data used to create the Datasource. If you do not include <code>percentBegin</code> and <code>percentEnd</code>, Amazon ML includes all of the data when creating the datasource.</p></li> <li><p><b><code>complement</code></b></p> <p>The <code>complement</code> parameter instructs Amazon ML to use the data that is not included in the range of <code>percentBegin</code> to <code>percentEnd</code> to create a datasource. The <code>complement</code> parameter is useful if you need to create complementary datasources for training and evaluation. To create a complementary datasource, use the same values for <code>percentBegin</code> and <code>percentEnd</code>, along with the <code>complement</code> parameter.</p> <p>For example, the following two datasources do not share any data, and can be used to train and evaluate a model. The first datasource has 25 percent of the data, and the second one has 75 percent of the data.</p> <p>Datasource for evaluation: <code>{"splitting":{"percentBegin":0, "percentEnd":25}}</code></p> <p>Datasource for training: <code>{"splitting":{"percentBegin":0, "percentEnd":25, "complement":"true"}}</code></p> </li> <li><p><b><code>strategy</code></b></p> <p>To change how Amazon ML splits the data for a datasource, use the <code>strategy</code> parameter.</p> <p>The default value for the <code>strategy</code> parameter is <code>sequential</code>, meaning that Amazon ML takes all of the data records between the <code>percentBegin</code> and <code>percentEnd</code> parameters for the datasource, in the order that the records appear in the input data.</p> <p>The following two <code>DataRearrangement</code> lines are examples of sequentially ordered training and evaluation datasources:</p> <p>Datasource for evaluation: <code>{"splitting":{"percentBegin":70, "percentEnd":100, "strategy":"sequential"}}</code></p> <p>Datasource for training: <code>{"splitting":{"percentBegin":70, "percentEnd":100, "strategy":"sequential", "complement":"true"}}</code></p> <p>To randomly split the input data into the proportions indicated by the percentBegin and percentEnd parameters, set the <code>strategy</code> parameter to <code>random</code> and provide a string that is used as the seed value for the random data splitting (for example, you can use the S3 path to your data as the random seed string). If you choose the random split strategy, Amazon ML assigns each row of data a pseudo-random number between 0 and 100, and then selects the rows that have an assigned number between <code>percentBegin</code> and <code>percentEnd</code>. Pseudo-random numbers are assigned using both the input seed string value and the byte offset as a seed, so changing the data results in a different split. Any existing ordering is preserved. The random splitting strategy ensures that variables in the training and evaluation data are distributed similarly. It is useful in the cases where the input data may have an implicit sort order, which would otherwise result in training and evaluation datasources containing non-similar data records.</p> <p>The following two <code>DataRearrangement</code> lines are examples of non-sequentially ordered training and evaluation datasources:</p> <p>Datasource for evaluation: <code>{"splitting":{"percentBegin":70, "percentEnd":100, "strategy":"random", "randomSeed"="s3://my_s3_path/bucket/file.csv"}}</code></p> <p>Datasource for training: <code>{"splitting":{"percentBegin":70, "percentEnd":100, "strategy":"random", "randomSeed"="s3://my_s3_path/bucket/file.csv", "complement":"true"}}</code></p> </li> </ul>', 'S3DataSpec$DataRearrangement' => '<p>A JSON string that represents the splitting and rearrangement processing to be applied to a <code>DataSource</code>. If the <code>DataRearrangement</code> parameter is not provided, all of the input data is used to create the <code>Datasource</code>.</p> <p>There are multiple parameters that control what data is used to create a datasource:</p> <ul> <li><p><b><code>percentBegin</code></b></p> <p>Use <code>percentBegin</code> to indicate the beginning of the range of the data used to create the Datasource. If you do not include <code>percentBegin</code> and <code>percentEnd</code>, Amazon ML includes all of the data when creating the datasource.</p></li> <li><p><b><code>percentEnd</code></b></p> <p>Use <code>percentEnd</code> to indicate the end of the range of the data used to create the Datasource. If you do not include <code>percentBegin</code> and <code>percentEnd</code>, Amazon ML includes all of the data when creating the datasource.</p></li> <li><p><b><code>complement</code></b></p> <p>The <code>complement</code> parameter instructs Amazon ML to use the data that is not included in the range of <code>percentBegin</code> to <code>percentEnd</code> to create a datasource. The <code>complement</code> parameter is useful if you need to create complementary datasources for training and evaluation. To create a complementary datasource, use the same values for <code>percentBegin</code> and <code>percentEnd</code>, along with the <code>complement</code> parameter.</p> <p>For example, the following two datasources do not share any data, and can be used to train and evaluate a model. The first datasource has 25 percent of the data, and the second one has 75 percent of the data.</p> <p>Datasource for evaluation: <code>{"splitting":{"percentBegin":0, "percentEnd":25}}</code></p> <p>Datasource for training: <code>{"splitting":{"percentBegin":0, "percentEnd":25, "complement":"true"}}</code></p> </li> <li><p><b><code>strategy</code></b></p> <p>To change how Amazon ML splits the data for a datasource, use the <code>strategy</code> parameter.</p> <p>The default value for the <code>strategy</code> parameter is <code>sequential</code>, meaning that Amazon ML takes all of the data records between the <code>percentBegin</code> and <code>percentEnd</code> parameters for the datasource, in the order that the records appear in the input data.</p> <p>The following two <code>DataRearrangement</code> lines are examples of sequentially ordered training and evaluation datasources:</p> <p>Datasource for evaluation: <code>{"splitting":{"percentBegin":70, "percentEnd":100, "strategy":"sequential"}}</code></p> <p>Datasource for training: <code>{"splitting":{"percentBegin":70, "percentEnd":100, "strategy":"sequential", "complement":"true"}}</code></p> <p>To randomly split the input data into the proportions indicated by the percentBegin and percentEnd parameters, set the <code>strategy</code> parameter to <code>random</code> and provide a string that is used as the seed value for the random data splitting (for example, you can use the S3 path to your data as the random seed string). If you choose the random split strategy, Amazon ML assigns each row of data a pseudo-random number between 0 and 100, and then selects the rows that have an assigned number between <code>percentBegin</code> and <code>percentEnd</code>. Pseudo-random numbers are assigned using both the input seed string value and the byte offset as a seed, so changing the data results in a different split. Any existing ordering is preserved. The random splitting strategy ensures that variables in the training and evaluation data are distributed similarly. It is useful in the cases where the input data may have an implicit sort order, which would otherwise result in training and evaluation datasources containing non-similar data records.</p> <p>The following two <code>DataRearrangement</code> lines are examples of non-sequentially ordered training and evaluation datasources:</p> <p>Datasource for evaluation: <code>{"splitting":{"percentBegin":70, "percentEnd":100, "strategy":"random", "randomSeed"="s3://my_s3_path/bucket/file.csv"}}</code></p> <p>Datasource for training: <code>{"splitting":{"percentBegin":70, "percentEnd":100, "strategy":"random", "randomSeed"="s3://my_s3_path/bucket/file.csv", "complement":"true"}}</code></p> </li> </ul>', ], ], 'DataSchema' => [ 'base' => '<p>The schema of a <code>DataSource</code>. The <code>DataSchema</code> defines the structure of the observation data in the data file(s) referenced in the <code>DataSource</code>. The DataSource schema is expressed in JSON format.</p> <p><code>DataSchema</code> is not required if you specify a <code>DataSchemaUri</code></p> <p>{ "version": "1.0", "recordAnnotationFieldName": "F1", "recordWeightFieldName": "F2", "targetFieldName": "F3", "dataFormat": "CSV", "dataFileContainsHeader": true, "variables": [ { "fieldName": "F1", "fieldType": "TEXT" }, { "fieldName": "F2", "fieldType": "NUMERIC" }, { "fieldName": "F3", "fieldType": "CATEGORICAL" }, { "fieldName": "F4", "fieldType": "NUMERIC" }, { "fieldName": "F5", "fieldType": "CATEGORICAL" }, { "fieldName": "F6", "fieldType": "TEXT" }, { "fieldName": "F7", "fieldType": "WEIGHTED_INT_SEQUENCE" }, { "fieldName": "F8", "fieldType": "WEIGHTED_STRING_SEQUENCE" } ], "excludedVariableNames": [ "F6" ] } </p>', 'refs' => [ 'GetDataSourceOutput$DataSourceSchema' => '<p>The schema used by all of the data files of this <code>DataSource</code>.</p> <note><title>Note</title> <p>This parameter is provided as part of the verbose format.</p></note>', 'GetMLModelOutput$Schema' => '<p>The schema used by all of the data files referenced by the <code>DataSource</code>.</p> <note><title>Note</title> <p>This parameter is provided as part of the verbose format.</p></note>', 'RDSDataSpec$DataSchema' => '<p>A JSON string that represents the schema for an Amazon RDS <code>DataSource</code>. The <code>DataSchema</code> defines the structure of the observation data in the data file(s) referenced in the <code>DataSource</code>.</p> <p>A <code>DataSchema</code> is not required if you specify a <code>DataSchemaUri</code></p> <p>Define your <code>DataSchema</code> as a series of key-value pairs. <code>attributes</code> and <code>excludedVariableNames</code> have an array of key-value pairs for their value. Use the following format to define your <code>DataSchema</code>.</p> <p>{ "version": "1.0",</p> <p> "recordAnnotationFieldName": "F1",</p> <p> "recordWeightFieldName": "F2",</p> <p> "targetFieldName": "F3",</p> <p> "dataFormat": "CSV",</p> <p> "dataFileContainsHeader": true,</p> <p> "attributes": [</p> <p> { "fieldName": "F1", "fieldType": "TEXT" }, { "fieldName": "F2", "fieldType": "NUMERIC" }, { "fieldName": "F3", "fieldType": "CATEGORICAL" }, { "fieldName": "F4", "fieldType": "NUMERIC" }, { "fieldName": "F5", "fieldType": "CATEGORICAL" }, { "fieldName": "F6", "fieldType": "TEXT" }, { "fieldName": "F7", "fieldType": "WEIGHTED_INT_SEQUENCE" }, { "fieldName": "F8", "fieldType": "WEIGHTED_STRING_SEQUENCE" } ],</p> <p> "excludedVariableNames": [ "F6" ] } </p> <?oxy_insert_end>', 'RedshiftDataSpec$DataSchema' => '<p>A JSON string that represents the schema for an Amazon Redshift <code>DataSource</code>. The <code>DataSchema</code> defines the structure of the observation data in the data file(s) referenced in the <code>DataSource</code>.</p> <p>A <code>DataSchema</code> is not required if you specify a <code>DataSchemaUri</code>.</p> <p>Define your <code>DataSchema</code> as a series of key-value pairs. <code>attributes</code> and <code>excludedVariableNames</code> have an array of key-value pairs for their value. Use the following format to define your <code>DataSchema</code>.</p> <p>{ "version": "1.0",</p> <p> "recordAnnotationFieldName": "F1",</p> <p> "recordWeightFieldName": "F2",</p> <p> "targetFieldName": "F3",</p> <p> "dataFormat": "CSV",</p> <p> "dataFileContainsHeader": true,</p> <p> "attributes": [</p> <p> { "fieldName": "F1", "fieldType": "TEXT" }, { "fieldName": "F2", "fieldType": "NUMERIC" }, { "fieldName": "F3", "fieldType": "CATEGORICAL" }, { "fieldName": "F4", "fieldType": "NUMERIC" }, { "fieldName": "F5", "fieldType": "CATEGORICAL" }, { "fieldName": "F6", "fieldType": "TEXT" }, { "fieldName": "F7", "fieldType": "WEIGHTED_INT_SEQUENCE" }, { "fieldName": "F8", "fieldType": "WEIGHTED_STRING_SEQUENCE" } ],</p> <p> "excludedVariableNames": [ "F6" ] } </p>', 'S3DataSpec$DataSchema' => '<p> A JSON string that represents the schema for an Amazon S3 <code>DataSource</code>. The <code>DataSchema</code> defines the structure of the observation data in the data file(s) referenced in the <code>DataSource</code>.</p> <p>You must provide either the <code>DataSchema</code> or the <code>DataSchemaLocationS3</code>.</p> <p>Define your <code>DataSchema</code> as a series of key-value pairs. <code>attributes</code> and <code>excludedVariableNames</code> have an array of key-value pairs for their value. Use the following format to define your <code>DataSchema</code>.</p> <p>{ "version": "1.0",</p> <p> "recordAnnotationFieldName": "F1",</p> <p> "recordWeightFieldName": "F2",</p> <p> "targetFieldName": "F3",</p> <p> "dataFormat": "CSV",</p> <p> "dataFileContainsHeader": true,</p> <p> "attributes": [</p> <p> { "fieldName": "F1", "fieldType": "TEXT" }, { "fieldName": "F2", "fieldType": "NUMERIC" }, { "fieldName": "F3", "fieldType": "CATEGORICAL" }, { "fieldName": "F4", "fieldType": "NUMERIC" }, { "fieldName": "F5", "fieldType": "CATEGORICAL" }, { "fieldName": "F6", "fieldType": "TEXT" }, { "fieldName": "F7", "fieldType": "WEIGHTED_INT_SEQUENCE" }, { "fieldName": "F8", "fieldType": "WEIGHTED_STRING_SEQUENCE" } ],</p> <p> "excludedVariableNames": [ "F6" ] } </p> <?oxy_insert_end>', ], ], 'DataSource' => [ 'base' => '<p> Represents the output of the <code>GetDataSource</code> operation. </p> <p> The content consists of the detailed metadata and data file information and the current status of the <code>DataSource</code>. </p>', 'refs' => [ 'DataSources$member' => NULL, ], ], 'DataSourceFilterVariable' => [ 'base' => '<p>A list of the variables to use in searching or filtering <code>DataSource</code>.</p> <ul> <li> <code>CreatedAt</code> - Sets the search criteria to <code>DataSource</code> creation date.</li> <li> <code>Status</code> - Sets the search criteria to <code>DataSource</code> status.</li> <li> <code>Name</code> - Sets the search criteria to the contents of <code>DataSource</code> <b> </b> <code>Name</code>.</li> <li> <code>DataUri</code> - Sets the search criteria to the URI of data files used to create the <code>DataSource</code>. The URI can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.</li> <li> <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>DataSource</code> creation.</li> </ul> <note><title>Note</title> <p>The variable names should match the variable names in the <code>DataSource</code>.</p> </note>', 'refs' => [ 'DescribeDataSourcesInput$FilterVariable' => '<p>Use one of the following variables to filter a list of <code>DataSource</code>:</p> <ul> <li> <code>CreatedAt</code> - Sets the search criteria to <code>DataSource</code> creation dates.</li> <li> <code>Status</code> - Sets the search criteria to <code>DataSource</code> statuses.</li> <li> <code>Name</code> - Sets the search criteria to the contents of <code>DataSource</code> <b> </b> <code>Name</code>.</li> <li> <code>DataUri</code> - Sets the search criteria to the URI of data files used to create the <code>DataSource</code>. The URI can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.</li> <li> <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>DataSource</code> creation.</li> </ul>', ], ], 'DataSources' => [ 'base' => NULL, 'refs' => [ 'DescribeDataSourcesOutput$Results' => '<p>A list of <code>DataSource</code> that meet the search criteria. </p>', ], ], 'DeleteBatchPredictionInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBatchPredictionOutput' => [ 'base' => '<p> Represents the output of a <code>DeleteBatchPrediction</code> operation.</p> <p>You can use the <code>GetBatchPrediction</code> operation and check the value of the <code>Status</code> parameter to see whether a <code>BatchPrediction</code> is marked as <code>DELETED</code>.</p>', 'refs' => [], ], 'DeleteDataSourceInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataSourceOutput' => [ 'base' => '<p> Represents the output of a <code>DeleteDataSource</code> operation.</p>', 'refs' => [], ], 'DeleteEvaluationInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEvaluationOutput' => [ 'base' => '<p> Represents the output of a <code>DeleteEvaluation</code> operation. The output indicates that Amazon Machine Learning (Amazon ML) received the request.</p> <p>You can use the <code>GetEvaluation</code> operation and check the value of the <code>Status</code> parameter to see whether an <code>Evaluation</code> is marked as <code>DELETED</code>.</p>', 'refs' => [], ], 'DeleteMLModelInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMLModelOutput' => [ 'base' => '<p>Represents the output of a <code>DeleteMLModel</code> operation.</p> <p>You can use the <code>GetMLModel</code> operation and check the value of the <code>Status</code> parameter to see whether an <code>MLModel</code> is marked as <code>DELETED</code>.</p>', 'refs' => [], ], 'DeleteRealtimeEndpointInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRealtimeEndpointOutput' => [ 'base' => '<p>Represents the output of an <code>DeleteRealtimeEndpoint</code> operation.</p> <p>The result contains the <code>MLModelId</code> and the endpoint information for the <code>MLModel</code>. </p>', 'refs' => [], ], 'DeleteTagsInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTagsOutput' => [ 'base' => '<p>Amazon ML returns the following elements. </p>', 'refs' => [], ], 'DescribeBatchPredictionsInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBatchPredictionsOutput' => [ 'base' => '<p>Represents the output of a <code>DescribeBatchPredictions</code> operation. The content is essentially a list of <code>BatchPrediction</code>s.</p>', 'refs' => [], ], 'DescribeDataSourcesInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataSourcesOutput' => [ 'base' => '<p>Represents the query results from a <a>DescribeDataSources</a> operation. The content is essentially a list of <code>DataSource</code>.</p>', 'refs' => [], ], 'DescribeEvaluationsInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEvaluationsOutput' => [ 'base' => '<p>Represents the query results from a <code>DescribeEvaluations</code> operation. The content is essentially a list of <code>Evaluation</code>.</p>', 'refs' => [], ], 'DescribeMLModelsInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMLModelsOutput' => [ 'base' => '<p>Represents the output of a <code>DescribeMLModels</code> operation. The content is essentially a list of <code>MLModel</code>.</p>', 'refs' => [], ], 'DescribeTagsInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTagsOutput' => [ 'base' => '<p>Amazon ML returns the following elements. </p>', 'refs' => [], ], 'DetailsAttributes' => [ 'base' => 'Contains the key values of <code>DetailsMap</code>: <code>PredictiveModelType</code> - Indicates the type of the <code>MLModel</code>. <code>Algorithm</code> - Indicates the algorithm that was used for the <code>MLModel</code>.', 'refs' => [ 'DetailsMap$key' => NULL, ], ], 'DetailsMap' => [ 'base' => 'Provides any additional details regarding the prediction.', 'refs' => [ 'Prediction$details' => NULL, ], ], 'DetailsValue' => [ 'base' => NULL, 'refs' => [ 'DetailsMap$value' => NULL, ], ], 'EDPPipelineId' => [ 'base' => NULL, 'refs' => [ 'RDSMetadata$DataPipelineId' => '<p>The ID of the Data Pipeline instance that is used to carry to copy data from Amazon RDS to Amazon S3. You can use the ID to find details about the instance in the Data Pipeline console.</p>', ], ], 'EDPResourceRole' => [ 'base' => NULL, 'refs' => [ 'RDSDataSpec$ResourceRole' => '<p>The role (DataPipelineDefaultResourceRole) assumed by an Amazon Elastic Compute Cloud (Amazon EC2) instance to carry out the copy operation from Amazon RDS to an Amazon S3 task. For more information, see <a href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for data pipelines.</p>', 'RDSMetadata$ResourceRole' => '<p>The role (DataPipelineDefaultResourceRole) assumed by an Amazon EC2 instance to carry out the copy task from Amazon RDS to Amazon S3. For more information, see <a href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for data pipelines.</p>', ], ], 'EDPSecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'EDPSecurityGroupIds$member' => NULL, ], ], 'EDPSecurityGroupIds' => [ 'base' => NULL, 'refs' => [ 'RDSDataSpec$SecurityGroupIds' => '<p>The security group IDs to be used to access a VPC-based RDS DB instance. Ensure that there are appropriate ingress rules set up to allow access to the RDS DB instance. This attribute is used by Data Pipeline to carry out the copy operation from Amazon RDS to an Amazon S3 task.</p>', ], ], 'EDPServiceRole' => [ 'base' => NULL, 'refs' => [ 'RDSDataSpec$ServiceRole' => '<p>The role (DataPipelineDefaultRole) assumed by AWS Data Pipeline service to monitor the progress of the copy task from Amazon RDS to Amazon S3. For more information, see <a href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for data pipelines.</p>', 'RDSMetadata$ServiceRole' => '<p>The role (DataPipelineDefaultRole) assumed by the Data Pipeline service to monitor the progress of the copy task from Amazon RDS to Amazon S3. For more information, see <a href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for data pipelines.</p>', ], ], 'EDPSubnetId' => [ 'base' => NULL, 'refs' => [ 'RDSDataSpec$SubnetId' => '<p>The subnet ID to be used to access a VPC-based RDS DB instance. This attribute is used by Data Pipeline to carry out the copy task from Amazon RDS to Amazon S3.</p>', ], ], 'EntityId' => [ 'base' => NULL, 'refs' => [ 'AddTagsInput$ResourceId' => '<p>The ID of the ML object to tag. For example, <code>exampleModelId</code>.</p>', 'AddTagsOutput$ResourceId' => '<p>The ID of the ML object that was tagged.</p>', 'BatchPrediction$BatchPredictionId' => '<p>The ID assigned to the <code>BatchPrediction</code> at creation. This value should be identical to the value of the <code>BatchPredictionID</code> in the request. </p>', 'BatchPrediction$MLModelId' => '<p>The ID of the <code>MLModel</code> that generated predictions for the <code>BatchPrediction</code> request.</p>', 'BatchPrediction$BatchPredictionDataSourceId' => '<p>The ID of the <code>DataSource</code> that points to the group of observations to predict.</p>', 'CreateBatchPredictionInput$BatchPredictionId' => '<p>A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>.</p>', 'CreateBatchPredictionInput$MLModelId' => '<p>The ID of the <code>MLModel</code> that will generate predictions for the group of observations. </p>', 'CreateBatchPredictionInput$BatchPredictionDataSourceId' => '<p>The ID of the <code>DataSource</code> that points to the group of observations to predict.</p>', 'CreateBatchPredictionOutput$BatchPredictionId' => '<p>A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>. This value is identical to the value of the <code>BatchPredictionId</code> in the request.</p>', 'CreateDataSourceFromRDSInput$DataSourceId' => '<p>A user-supplied ID that uniquely identifies the <code>DataSource</code>. Typically, an Amazon Resource Number (ARN) becomes the ID for a <code>DataSource</code>.</p>', 'CreateDataSourceFromRDSOutput$DataSourceId' => '<p>A user-supplied ID that uniquely identifies the datasource. This value should be identical to the value of the <code>DataSourceID</code> in the request. </p>', 'CreateDataSourceFromRedshiftInput$DataSourceId' => '<p>A user-supplied ID that uniquely identifies the <code>DataSource</code>.</p>', 'CreateDataSourceFromRedshiftOutput$DataSourceId' => '<p>A user-supplied ID that uniquely identifies the datasource. This value should be identical to the value of the <code>DataSourceID</code> in the request. </p>', 'CreateDataSourceFromS3Input$DataSourceId' => '<p>A user-supplied identifier that uniquely identifies the <code>DataSource</code>. </p>', 'CreateDataSourceFromS3Output$DataSourceId' => '<p>A user-supplied ID that uniquely identifies the <code>DataSource</code>. This value should be identical to the value of the <code>DataSourceID</code> in the request. </p>', 'CreateEvaluationInput$EvaluationId' => '<p>A user-supplied ID that uniquely identifies the <code>Evaluation</code>.</p>', 'CreateEvaluationInput$MLModelId' => '<p>The ID of the <code>MLModel</code> to evaluate.</p> <p>The schema used in creating the <code>MLModel</code> must match the schema of the <code>DataSource</code> used in the <code>Evaluation</code>.</p>', 'CreateEvaluationInput$EvaluationDataSourceId' => '<p>The ID of the <code>DataSource</code> for the evaluation. The schema of the <code>DataSource</code> must match the schema used to create the <code>MLModel</code>.</p>', 'CreateEvaluationOutput$EvaluationId' => '<p>The user-supplied ID that uniquely identifies the <code>Evaluation</code>. This value should be identical to the value of the <code>EvaluationId</code> in the request.</p>', 'CreateMLModelInput$MLModelId' => '<p>A user-supplied ID that uniquely identifies the <code>MLModel</code>.</p>', 'CreateMLModelInput$TrainingDataSourceId' => '<p>The <code>DataSource</code> that points to the training data.</p>', 'CreateMLModelOutput$MLModelId' => '<p>A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the value of the <code>MLModelId</code> in the request. </p>', 'CreateRealtimeEndpointInput$MLModelId' => '<p>The ID assigned to the <code>MLModel</code> during creation.</p>', 'CreateRealtimeEndpointOutput$MLModelId' => '<p>A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the value of the <code>MLModelId</code> in the request.</p>', 'DataSource$DataSourceId' => '<p>The ID that is assigned to the <code>DataSource</code> during creation.</p>', 'DeleteBatchPredictionInput$BatchPredictionId' => '<p>A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>.</p>', 'DeleteBatchPredictionOutput$BatchPredictionId' => '<p>A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>. This value should be identical to the value of the <code>BatchPredictionID</code> in the request.</p>', 'DeleteDataSourceInput$DataSourceId' => '<p>A user-supplied ID that uniquely identifies the <code>DataSource</code>.</p>', 'DeleteDataSourceOutput$DataSourceId' => '<p>A user-supplied ID that uniquely identifies the <code>DataSource</code>. This value should be identical to the value of the <code>DataSourceID</code> in the request.</p>', 'DeleteEvaluationInput$EvaluationId' => '<p>A user-supplied ID that uniquely identifies the <code>Evaluation</code> to delete.</p>', 'DeleteEvaluationOutput$EvaluationId' => '<p>A user-supplied ID that uniquely identifies the <code>Evaluation</code>. This value should be identical to the value of the <code>EvaluationId</code> in the request.</p>', 'DeleteMLModelInput$MLModelId' => '<p>A user-supplied ID that uniquely identifies the <code>MLModel</code>.</p>', 'DeleteMLModelOutput$MLModelId' => '<p>A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the value of the <code>MLModelID</code> in the request.</p>', 'DeleteRealtimeEndpointInput$MLModelId' => '<p>The ID assigned to the <code>MLModel</code> during creation.</p>', 'DeleteRealtimeEndpointOutput$MLModelId' => '<p>A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the value of the <code>MLModelId</code> in the request.</p>', 'DeleteTagsInput$ResourceId' => '<p>The ID of the tagged ML object. For example, <code>exampleModelId</code>.</p>', 'DeleteTagsOutput$ResourceId' => '<p>The ID of the ML object from which tags were deleted.</p>', 'DescribeTagsInput$ResourceId' => '<p>The ID of the ML object. For example, <code>exampleModelId</code>. </p>', 'DescribeTagsOutput$ResourceId' => '<p>The ID of the tagged ML object.</p>', 'Evaluation$EvaluationId' => '<p>The ID that is assigned to the <code>Evaluation</code> at creation.</p>', 'Evaluation$MLModelId' => '<p>The ID of the <code>MLModel</code> that is the focus of the evaluation.</p>', 'Evaluation$EvaluationDataSourceId' => '<p>The ID of the <code>DataSource</code> that is used to evaluate the <code>MLModel</code>.</p>', 'GetBatchPredictionInput$BatchPredictionId' => '<p>An ID assigned to the <code>BatchPrediction</code> at creation.</p>', 'GetBatchPredictionOutput$BatchPredictionId' => '<p>An ID assigned to the <code>BatchPrediction</code> at creation. This value should be identical to the value of the <code>BatchPredictionID</code> in the request.</p>', 'GetBatchPredictionOutput$MLModelId' => '<p>The ID of the <code>MLModel</code> that generated predictions for the <code>BatchPrediction</code> request.</p>', 'GetBatchPredictionOutput$BatchPredictionDataSourceId' => '<p>The ID of the <code>DataSource</code> that was used to create the <code>BatchPrediction</code>. </p>', 'GetDataSourceInput$DataSourceId' => '<p>The ID assigned to the <code>DataSource</code> at creation.</p>', 'GetDataSourceOutput$DataSourceId' => '<p>The ID assigned to the <code>DataSource</code> at creation. This value should be identical to the value of the <code>DataSourceId</code> in the request.</p>', 'GetEvaluationInput$EvaluationId' => '<p>The ID of the <code>Evaluation</code> to retrieve. The evaluation of each <code>MLModel</code> is recorded and cataloged. The ID provides the means to access the information. </p>', 'GetEvaluationOutput$EvaluationId' => '<p>The evaluation ID which is same as the <code>EvaluationId</code> in the request.</p>', 'GetEvaluationOutput$MLModelId' => '<p>The ID of the <code>MLModel</code> that was the focus of the evaluation.</p>', 'GetEvaluationOutput$EvaluationDataSourceId' => '<p>The <code>DataSource</code> used for this evaluation.</p>', 'GetMLModelInput$MLModelId' => '<p>The ID assigned to the <code>MLModel</code> at creation.</p>', 'GetMLModelOutput$MLModelId' => '<p>The MLModel ID<?oxy_insert_start author="annbech" timestamp="20160328T151251-0700">,<?oxy_insert_end> which is same as the <code>MLModelId</code> in the request.</p>', 'GetMLModelOutput$TrainingDataSourceId' => '<p>The ID of the training <code>DataSource</code>.</p>', 'MLModel$MLModelId' => '<p>The ID assigned to the <code>MLModel</code> at creation.</p>', 'MLModel$TrainingDataSourceId' => '<p>The ID of the training <code>DataSource</code>. The <code>CreateMLModel</code> operation uses the <code>TrainingDataSourceId</code>.</p>', 'PredictInput$MLModelId' => '<p>A unique identifier of the <code>MLModel</code>.</p>', 'UpdateBatchPredictionInput$BatchPredictionId' => '<p>The ID assigned to the <code>BatchPrediction</code> during creation.</p>', 'UpdateBatchPredictionOutput$BatchPredictionId' => '<p>The ID assigned to the <code>BatchPrediction</code> during creation. This value should be identical to the value of the <code>BatchPredictionId</code> in the request.</p>', 'UpdateDataSourceInput$DataSourceId' => '<p>The ID assigned to the <code>DataSource</code> during creation.</p>', 'UpdateDataSourceOutput$DataSourceId' => '<p>The ID assigned to the <code>DataSource</code> during creation. This value should be identical to the value of the <code>DataSourceID</code> in the request.</p>', 'UpdateEvaluationInput$EvaluationId' => '<p>The ID assigned to the <code>Evaluation</code> during creation.</p>', 'UpdateEvaluationOutput$EvaluationId' => '<p>The ID assigned to the <code>Evaluation</code> during creation. This value should be identical to the value of the <code>Evaluation</code> in the request.</p>', 'UpdateMLModelInput$MLModelId' => '<p>The ID assigned to the <code>MLModel</code> during creation.</p>', 'UpdateMLModelOutput$MLModelId' => '<p>The ID assigned to the <code>MLModel</code> during creation. This value should be identical to the value of the <code>MLModelID</code> in the request.</p>', ], ], 'EntityName' => [ 'base' => '<p>A user-supplied name or description of the Amazon ML resource.</p>', 'refs' => [ 'BatchPrediction$Name' => '<p>A user-supplied name or description of the <code>BatchPrediction</code>.</p>', 'CreateBatchPredictionInput$BatchPredictionName' => '<p>A user-supplied name or description of the <code>BatchPrediction</code>. <code>BatchPredictionName</code> can only use the UTF-8 character set.</p>', 'CreateDataSourceFromRDSInput$DataSourceName' => '<p>A user-supplied name or description of the <code>DataSource</code>.</p>', 'CreateDataSourceFromRedshiftInput$DataSourceName' => '<p>A user-supplied name or description of the <code>DataSource</code>. </p>', 'CreateDataSourceFromS3Input$DataSourceName' => '<p>A user-supplied name or description of the <code>DataSource</code>. </p>', 'CreateEvaluationInput$EvaluationName' => '<p>A user-supplied name or description of the <code>Evaluation</code>.</p>', 'CreateMLModelInput$MLModelName' => '<p>A user-supplied name or description of the <code>MLModel</code>.</p>', 'DataSource$Name' => '<p>A user-supplied name or description of the <code>DataSource</code>.</p>', 'Evaluation$Name' => '<p>A user-supplied name or description of the <code>Evaluation</code>. </p>', 'GetBatchPredictionOutput$Name' => '<p>A user-supplied name or description of the <code>BatchPrediction</code>.</p>', 'GetDataSourceOutput$Name' => '<p>A user-supplied name or description of the <code>DataSource</code>.</p>', 'GetEvaluationOutput$Name' => '<p>A user-supplied name or description of the <code>Evaluation</code>. </p>', 'UpdateBatchPredictionInput$BatchPredictionName' => '<p>A new user-supplied name or description of the <code>BatchPrediction</code>.</p>', 'UpdateDataSourceInput$DataSourceName' => '<p>A new user-supplied name or description of the <code>DataSource</code> that will replace the current description. </p>', 'UpdateEvaluationInput$EvaluationName' => '<p>A new user-supplied name or description of the <code>Evaluation</code> that will replace the current content. </p>', 'UpdateMLModelInput$MLModelName' => '<p>A user-supplied name or description of the <code>MLModel</code>.</p>', ], ], 'EntityStatus' => [ 'base' => '<p>Object status with the following possible values:</p> <ul> <li><code>PENDING</code></li> <li><code>INPROGRESS</code></li> <li><code>FAILED</code></li> <li><code>COMPLETED</code></li> <li><code>DELETED</code></li> </ul>', 'refs' => [ 'BatchPrediction$Status' => '<p>The status of the <code>BatchPrediction</code>. This element can have one of the following values:</p> <ul> <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to generate predictions for a batch of observations.</li> <li> <code>INPROGRESS</code> - The process is underway.</li> <li> <code>FAILED</code> - The request to perform a batch prediction did not run to completion. It is not usable.</li> <li> <code>COMPLETED</code> - The batch prediction process completed successfully.</li> <li> <code>DELETED</code> - The <code>BatchPrediction</code> is marked as deleted. It is not usable.</li> </ul>', 'DataSource$Status' => '<p>The current status of the <code>DataSource</code>. This element can have one of the following values: </p> <ul> <li>PENDING - Amazon Machine Learning (Amazon ML) submitted a request to create a <code>DataSource</code>.</li> <li>INPROGRESS - The creation process is underway.</li> <li>FAILED - The request to create a <code>DataSource</code> did not run to completion. It is not usable.</li> <li>COMPLETED - The creation process completed successfully.</li> <li>DELETED - The <code>DataSource</code> is marked as deleted. It is not usable.</li> </ul>', 'Evaluation$Status' => '<p>The status of the evaluation. This element can have one of the following values:</p> <ul> <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to evaluate an <code>MLModel</code>.</li> <li> <code>INPROGRESS</code> - The evaluation is underway.</li> <li> <code>FAILED</code> - The request to evaluate an <code>MLModel</code> did not run to completion. It is not usable.</li> <li> <code>COMPLETED</code> - The evaluation process completed successfully.</li> <li> <code>DELETED</code> - The <code>Evaluation</code> is marked as deleted. It is not usable.</li> </ul>', 'GetBatchPredictionOutput$Status' => '<p>The status of the <code>BatchPrediction</code>, which can be one of the following values:</p> <ul> <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to generate batch predictions.</li> <li> <code>INPROGRESS</code> - The batch predictions are in progress.</li> <li> <code>FAILED</code> - The request to perform a batch prediction did not run to completion. It is not usable.</li> <li> <code>COMPLETED</code> - The batch prediction process completed successfully.</li> <li> <code>DELETED</code> - The <code>BatchPrediction</code> is marked as deleted. It is not usable.</li> </ul>', 'GetDataSourceOutput$Status' => '<p>The current status of the <code>DataSource</code>. This element can have one of the following values:</p> <ul> <li> <code>PENDING</code> - Amazon ML submitted a request to create a <code>DataSource</code>.</li> <li> <code>INPROGRESS</code> - The creation process is underway.</li> <li> <code>FAILED</code> - The request to create a <code>DataSource</code> did not run to completion. It is not usable.</li> <li> <code>COMPLETED</code> - The creation process completed successfully.</li> <li> <code>DELETED</code> - The <code>DataSource</code> is marked as deleted. It is not usable.</li> </ul>', 'GetEvaluationOutput$Status' => '<p>The status of the evaluation. This element can have one of the following values:</p> <ul> <li> <code>PENDING</code> - Amazon Machine Language (Amazon ML) submitted a request to evaluate an <code>MLModel</code>.</li> <li> <code>INPROGRESS</code> - The evaluation is underway.</li> <li> <code>FAILED</code> - The request to evaluate an <code>MLModel</code> did not run to completion. It is not usable.</li> <li> <code>COMPLETED</code> - The evaluation process completed successfully.</li> <li> <code>DELETED</code> - The <code>Evaluation</code> is marked as deleted. It is not usable.</li> </ul>', 'GetMLModelOutput$Status' => '<p>The current status of the <code>MLModel</code>. This element can have one of the following values:</p> <ul> <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to describe a <code>MLModel</code>.</li> <li> <code>INPROGRESS</code> - The request is processing.</li> <li> <code>FAILED</code> - The request did not run to completion. The ML model isn\'t usable.</li> <li> <code>COMPLETED</code> - The request completed successfully.</li> <li> <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn\'t usable.</li> </ul>', 'MLModel$Status' => '<p>The current status of an <code>MLModel</code>. This element can have one of the following values: </p> <ul> <li> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to create an <code>MLModel</code>.</li> <li> <code>INPROGRESS</code> - The creation process is underway.</li> <li> <code>FAILED</code> - The request to create an <code>MLModel</code> didn\'t run to completion. The model isn\'t usable.</li> <li> <code>COMPLETED</code> - The creation process completed successfully.</li> <li> <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn\'t usable.</li> </ul>', ], ], 'EpochTime' => [ 'base' => '<p>A timestamp represented in epoch time.</p>', 'refs' => [ 'BatchPrediction$CreatedAt' => '<p>The time that the <code>BatchPrediction</code> was created. The time is expressed in epoch time.</p>', 'BatchPrediction$LastUpdatedAt' => '<p>The time of the most recent edit to the <code>BatchPrediction</code>. The time is expressed in epoch time.</p>', 'BatchPrediction$FinishedAt' => NULL, 'BatchPrediction$StartedAt' => NULL, 'DataSource$CreatedAt' => '<p>The time that the <code>DataSource</code> was created. The time is expressed in epoch time.</p>', 'DataSource$LastUpdatedAt' => '<p>The time of the most recent edit to the <code>BatchPrediction</code>. The time is expressed in epoch time.</p>', 'DataSource$FinishedAt' => NULL, 'DataSource$StartedAt' => NULL, 'Evaluation$CreatedAt' => '<p>The time that the <code>Evaluation</code> was created. The time is expressed in epoch time.</p>', 'Evaluation$LastUpdatedAt' => '<p>The time of the most recent edit to the <code>Evaluation</code>. The time is expressed in epoch time.</p>', 'Evaluation$FinishedAt' => NULL, 'Evaluation$StartedAt' => NULL, 'GetBatchPredictionOutput$CreatedAt' => '<p>The time when the <code>BatchPrediction</code> was created. The time is expressed in epoch time.</p>', 'GetBatchPredictionOutput$LastUpdatedAt' => '<p>The time of the most recent edit to <code>BatchPrediction</code>. The time is expressed in epoch time.</p>', 'GetBatchPredictionOutput$FinishedAt' => '<p>The epoch time when Amazon Machine Learning marked the <code>BatchPrediction</code> as <code>COMPLETED</code> or <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>BatchPrediction</code> is in the <code>COMPLETED</code> or <code>FAILED</code> state.</p>', 'GetBatchPredictionOutput$StartedAt' => '<p>The epoch time when Amazon Machine Learning marked the <code>BatchPrediction</code> as <code>INPROGRESS</code>. <code>StartedAt</code> isn\'t available if the <code>BatchPrediction</code> is in the <code>PENDING</code> state.</p>', 'GetDataSourceOutput$CreatedAt' => '<p>The time that the <code>DataSource</code> was created. The time is expressed in epoch time.</p>', 'GetDataSourceOutput$LastUpdatedAt' => '<p>The time of the most recent edit to the <code>DataSource</code>. The time is expressed in epoch time.</p>', 'GetDataSourceOutput$FinishedAt' => '<p>The epoch time when Amazon Machine Learning marked the <code>DataSource</code> as <code>COMPLETED</code> or <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>DataSource</code> is in the <code>COMPLETED</code> or <code>FAILED</code> state.</p>', 'GetDataSourceOutput$StartedAt' => '<p>The epoch time when Amazon Machine Learning marked the <code>DataSource</code> as <code>INPROGRESS</code>. <code>StartedAt</code> isn\'t available if the <code>DataSource</code> is in the <code>PENDING</code> state.</p>', 'GetEvaluationOutput$CreatedAt' => '<p>The time that the <code>Evaluation</code> was created. The time is expressed in epoch time.</p>', 'GetEvaluationOutput$LastUpdatedAt' => '<p>The time of the most recent edit to the <code>Evaluation</code>. The time is expressed in epoch time.</p>', 'GetEvaluationOutput$FinishedAt' => '<p>The epoch time when Amazon Machine Learning marked the <code>Evaluation</code> as <code>COMPLETED</code> or <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>Evaluation</code> is in the <code>COMPLETED</code> or <code>FAILED</code> state.</p>', 'GetEvaluationOutput$StartedAt' => '<p>The epoch time when Amazon Machine Learning marked the <code>Evaluation</code> as <code>INPROGRESS</code>. <code>StartedAt</code> isn\'t available if the <code>Evaluation</code> is in the <code>PENDING</code> state.</p>', 'GetMLModelOutput$CreatedAt' => '<p>The time that the <code>MLModel</code> was created. The time is expressed in epoch time.</p>', 'GetMLModelOutput$LastUpdatedAt' => '<p>The time of the most recent edit to the <code>MLModel</code>. The time is expressed in epoch time.</p>', 'GetMLModelOutput$ScoreThresholdLastUpdatedAt' => '<p>The time of the most recent edit to the <code>ScoreThreshold</code>. The time is expressed in epoch time.</p>', 'GetMLModelOutput$FinishedAt' => '<p>The epoch time when Amazon Machine Learning marked the <code>MLModel</code> as <code>COMPLETED</code> or <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>MLModel</code> is in the <code>COMPLETED</code> or <code>FAILED</code> state.</p>', 'GetMLModelOutput$StartedAt' => '<p>The epoch time when Amazon Machine Learning marked the <code>MLModel</code> as <code>INPROGRESS</code>. <code>StartedAt</code> isn\'t available if the <code>MLModel</code> is in the <code>PENDING</code> state.</p>', 'MLModel$CreatedAt' => '<p>The time that the <code>MLModel</code> was created. The time is expressed in epoch time.</p>', 'MLModel$LastUpdatedAt' => '<p>The time of the most recent edit to the <code>MLModel</code>. The time is expressed in epoch time.</p>', 'MLModel$ScoreThresholdLastUpdatedAt' => '<p>The time of the most recent edit to the <code>ScoreThreshold</code>. The time is expressed in epoch time.</p>', 'MLModel$FinishedAt' => NULL, 'MLModel$StartedAt' => NULL, 'RealtimeEndpointInfo$CreatedAt' => '<p>The time that the request to create the real-time endpoint for the <code>MLModel</code> was received. The time is expressed in epoch time.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'IdempotentParameterMismatchException$code' => NULL, 'InternalServerException$code' => NULL, 'InvalidInputException$code' => NULL, 'LimitExceededException$code' => NULL, 'ResourceNotFoundException$code' => NULL, ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'IdempotentParameterMismatchException$message' => NULL, 'InternalServerException$message' => NULL, 'InvalidInputException$message' => NULL, 'InvalidTagException$message' => NULL, 'LimitExceededException$message' => NULL, 'PredictorNotMountedException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'TagLimitExceededException$message' => NULL, ], ], 'Evaluation' => [ 'base' => '<p> Represents the output of <code>GetEvaluation</code> operation. </p> <p>The content consists of the detailed metadata and data file information and the current status of the <code>Evaluation</code>.</p>', 'refs' => [ 'Evaluations$member' => NULL, ], ], 'EvaluationFilterVariable' => [ 'base' => '<p>A list of the variables to use in searching or filtering <code>Evaluation</code>.</p> <ul> <li> <code>CreatedAt</code> - Sets the search criteria to <code>Evaluation</code> creation date.</li> <li> <code>Status</code> - Sets the search criteria to <code>Evaluation</code> status.</li> <li> <code>Name</code> - Sets the search criteria to the contents of <code>Evaluation</code> <b> </b> <code>Name</code>.</li> <li> <code>IAMUser</code> - Sets the search criteria to the user account that invoked an evaluation.</li> <li> <code>MLModelId</code> - Sets the search criteria to the <code>Predictor</code> that was evaluated.</li> <li> <code>DataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used in evaluation.</li> <li> <code>DataUri</code> - Sets the search criteria to the data file(s) used in evaluation. The URL can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.</li> </ul>', 'refs' => [ 'DescribeEvaluationsInput$FilterVariable' => '<p>Use one of the following variable to filter a list of <code>Evaluation</code> objects:</p> <ul> <li> <code>CreatedAt</code> - Sets the search criteria to the <code>Evaluation</code> creation date.</li> <li> <code>Status</code> - Sets the search criteria to the <code>Evaluation</code> status.</li> <li> <code>Name</code> - Sets the search criteria to the contents of <code>Evaluation</code> <b> </b> <code>Name</code>.</li> <li> <code>IAMUser</code> - Sets the search criteria to the user account that invoked an <code>Evaluation</code>.</li> <li> <code>MLModelId</code> - Sets the search criteria to the <code>MLModel</code> that was evaluated.</li> <li> <code>DataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used in <code>Evaluation</code>.</li> <li> <code>DataUri</code> - Sets the search criteria to the data file(s) used in <code>Evaluation</code>. The URL can identify either a file or an Amazon Simple Storage Solution (Amazon S3) bucket or directory.</li> </ul>', ], ], 'Evaluations' => [ 'base' => NULL, 'refs' => [ 'DescribeEvaluationsOutput$Results' => '<p>A list of <code>Evaluation</code> that meet the search criteria. </p>', ], ], 'GetBatchPredictionInput' => [ 'base' => NULL, 'refs' => [], ], 'GetBatchPredictionOutput' => [ 'base' => '<p>Represents the output of a <code>GetBatchPrediction</code> operation and describes a <code>BatchPrediction</code>.</p>', 'refs' => [], ], 'GetDataSourceInput' => [ 'base' => NULL, 'refs' => [], ], 'GetDataSourceOutput' => [ 'base' => '<p>Represents the output of a <code>GetDataSource</code> operation and describes a <code>DataSource</code>.</p>', 'refs' => [], ], 'GetEvaluationInput' => [ 'base' => NULL, 'refs' => [], ], 'GetEvaluationOutput' => [ 'base' => '<p>Represents the output of a <code>GetEvaluation</code> operation and describes an <code>Evaluation</code>.</p>', 'refs' => [], ], 'GetMLModelInput' => [ 'base' => NULL, 'refs' => [], ], 'GetMLModelOutput' => [ 'base' => '<p>Represents the output of a <code>GetMLModel</code> operation, and provides detailed information about a <code>MLModel</code>.</p>', 'refs' => [], ], 'IdempotentParameterMismatchException' => [ 'base' => '<p>A second request to use or change an object was not allowed. This can result from retrying a request using a parameter that was not present in the original request.</p>', 'refs' => [], ], 'IntegerType' => [ 'base' => '<p>Integer type that is a 32-bit signed number.</p>', 'refs' => [ 'RealtimeEndpointInfo$PeakRequestsPerSecond' => '<p> The maximum processing rate for the real-time endpoint for <code>MLModel</code>, measured in incoming requests per second.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>An error on the server occurred when trying to process a request.</p>', 'refs' => [], ], 'InvalidInputException' => [ 'base' => '<p>An error on the client occurred. Typically, the cause is an invalid input value.</p>', 'refs' => [], ], 'InvalidTagException' => [ 'base' => NULL, 'refs' => [], ], 'Label' => [ 'base' => NULL, 'refs' => [ 'Prediction$predictedLabel' => '<p>The prediction label for either a <code>BINARY</code> or <code>MULTICLASS</code> <code>MLModel</code>.</p>', 'ScoreValuePerLabelMap$key' => NULL, ], ], 'LimitExceededException' => [ 'base' => '<p>The subscriber exceeded the maximum number of operations. This exception can occur when listing objects such as <code>DataSource</code>.</p>', 'refs' => [], ], 'LongType' => [ 'base' => '<p>Long integer type that is a 64-bit signed number.</p>', 'refs' => [ 'BatchPrediction$ComputeTime' => NULL, 'BatchPrediction$TotalRecordCount' => NULL, 'BatchPrediction$InvalidRecordCount' => NULL, 'DataSource$DataSizeInBytes' => '<p>The total number of observations contained in the data files that the <code>DataSource</code> references.</p>', 'DataSource$NumberOfFiles' => '<p>The number of data files referenced by the <code>DataSource</code>.</p>', 'DataSource$ComputeTime' => NULL, 'Evaluation$ComputeTime' => NULL, 'GetBatchPredictionOutput$ComputeTime' => '<p>The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the <code>BatchPrediction</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only available if the <code>BatchPrediction</code> is in the <code>COMPLETED</code> state.</p>', 'GetBatchPredictionOutput$TotalRecordCount' => '<p>The number of total records that Amazon Machine Learning saw while processing the <code>BatchPrediction</code>.</p>', 'GetBatchPredictionOutput$InvalidRecordCount' => '<p>The number of invalid records that Amazon Machine Learning saw while processing the <code>BatchPrediction</code>.</p>', 'GetDataSourceOutput$DataSizeInBytes' => '<p>The total size of observations in the data files.</p>', 'GetDataSourceOutput$NumberOfFiles' => '<p>The number of data files referenced by the <code>DataSource</code>.</p>', 'GetDataSourceOutput$ComputeTime' => '<p>The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the <code>DataSource</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only available if the <code>DataSource</code> is in the <code>COMPLETED</code> state and the <code>ComputeStatistics</code> is set to true.</p>', 'GetEvaluationOutput$ComputeTime' => '<p>The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the <code>Evaluation</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only available if the <code>Evaluation</code> is in the <code>COMPLETED</code> state.</p>', 'GetMLModelOutput$SizeInBytes' => NULL, 'GetMLModelOutput$ComputeTime' => '<p>The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the <code>MLModel</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only available if the <code>MLModel</code> is in the <code>COMPLETED</code> state.</p>', 'MLModel$SizeInBytes' => NULL, 'MLModel$ComputeTime' => NULL, ], ], 'MLModel' => [ 'base' => '<p> Represents the output of a <code>GetMLModel</code> operation. </p> <p>The content consists of the detailed metadata and the current status of the <code>MLModel</code>.</p>', 'refs' => [ 'MLModels$member' => NULL, ], ], 'MLModelFilterVariable' => [ 'base' => NULL, 'refs' => [ 'DescribeMLModelsInput$FilterVariable' => '<p>Use one of the following variables to filter a list of <code>MLModel</code>:</p> <ul> <li> <code>CreatedAt</code> - Sets the search criteria to <code>MLModel</code> creation date.</li> <li> <code>Status</code> - Sets the search criteria to <code>MLModel</code> status.</li> <li> <code>Name</code> - Sets the search criteria to the contents of <code>MLModel</code><b> </b> <code>Name</code>.</li> <li> <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>MLModel</code> creation.</li> <li> <code>TrainingDataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used to train one or more <code>MLModel</code>.</li> <li> <code>RealtimeEndpointStatus</code> - Sets the search criteria to the <code>MLModel</code> real-time endpoint status.</li> <li> <code>MLModelType</code> - Sets the search criteria to <code>MLModel</code> type: binary, regression, or multi-class.</li> <li> <code>Algorithm</code> - Sets the search criteria to the algorithm that the <code>MLModel</code> uses.</li> <li> <code>TrainingDataURI</code> - Sets the search criteria to the data file(s) used in training a <code>MLModel</code>. The URL can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.</li> </ul>', ], ], 'MLModelName' => [ 'base' => NULL, 'refs' => [ 'GetMLModelOutput$Name' => '<p>A user-supplied name or description of the <code>MLModel</code>.</p>', 'MLModel$Name' => '<p>A user-supplied name or description of the <code>MLModel</code>.</p>', ], ], 'MLModelType' => [ 'base' => NULL, 'refs' => [ 'CreateMLModelInput$MLModelType' => '<p>The category of supervised learning that this <code>MLModel</code> will address. Choose from the following types:</p> <ul> <li>Choose <code>REGRESSION</code> if the <code>MLModel</code> will be used to predict a numeric value.</li> <li>Choose <code>BINARY</code> if the <code>MLModel</code> result has two possible values.</li> <li>Choose <code>MULTICLASS</code> if the <code>MLModel</code> result has a limited number of values. </li> </ul> <p> For more information, see the <a href="http://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>.</p>', 'GetMLModelOutput$MLModelType' => '<p>Identifies the <code>MLModel</code> category. The following are the available types: </p> <ul> <li>REGRESSION -- Produces a numeric result. For example, "What price should a house be listed at?"</li> <li>BINARY -- Produces one of two possible results. For example, "Is this an e-commerce website?"</li> <li>MULTICLASS -- Produces one of several possible results. For example, "Is this a HIGH, LOW or MEDIUM risk trade?"</li> </ul>', 'MLModel$MLModelType' => '<p>Identifies the <code>MLModel</code> category. The following are the available types:</p> <ul> <li> <code>REGRESSION</code> - Produces a numeric result. For example, "What price should a house be listed at?"</li> <li> <code>BINARY</code> - Produces one of two possible results. For example, "Is this a child-friendly web site?".</li> <li> <code>MULTICLASS</code> - Produces one of several possible results. For example, "Is this a HIGH-, LOW-, or MEDIUM<?oxy_delete author="annbech" timestamp="20160328T175050-0700" content=" "><?oxy_insert_start author="annbech" timestamp="20160328T175050-0700">-<?oxy_insert_end>risk trade?".</li> </ul>', ], ], 'MLModels' => [ 'base' => NULL, 'refs' => [ 'DescribeMLModelsOutput$Results' => '<p>A list of <code>MLModel</code> that meet the search criteria.</p>', ], ], 'Message' => [ 'base' => '<p> Description of the most recent details about an object.</p>', 'refs' => [ 'BatchPrediction$Message' => '<p>A description of the most recent details about processing the batch prediction request.</p>', 'DataSource$Message' => '<p>A description of the most recent details about creating the <code>DataSource</code>.</p>', 'Evaluation$Message' => '<p>A description of the most recent details about evaluating the <code>MLModel</code>.</p>', 'GetBatchPredictionOutput$Message' => '<p>A description of the most recent details about processing the batch prediction request.</p>', 'GetDataSourceOutput$Message' => '<p>The user-supplied description of the most recent details about creating the <code>DataSource</code>.</p>', 'GetEvaluationOutput$Message' => '<p>A description of the most recent details about evaluating the <code>MLModel</code>.</p>', 'GetMLModelOutput$Message' => '<p>A description of the most recent details about accessing the <code>MLModel</code>.</p>', 'MLModel$Message' => '<p>A description of the most recent details about accessing the <code>MLModel</code>.</p>', ], ], 'PageLimit' => [ 'base' => NULL, 'refs' => [ 'DescribeBatchPredictionsInput$Limit' => '<p>The number of pages of information to include in the result. The range of acceptable values is <code>1</code> through <code>100</code>. The default value is <code>100</code>.</p>', 'DescribeDataSourcesInput$Limit' => '<p> The maximum number of <code>DataSource</code> to include in the result.</p>', 'DescribeEvaluationsInput$Limit' => '<p> The maximum number of <code>Evaluation</code> to include in the result.</p>', 'DescribeMLModelsInput$Limit' => '<p>The number of pages of information to include in the result. The range of acceptable values is <code>1</code> through <code>100</code>. The default value is <code>100</code>.</p>', ], ], 'PerformanceMetrics' => [ 'base' => '<p>Measurements of how well the <code>MLModel</code> performed on known observations. One of the following metrics is returned, based on the type of the <code>MLModel</code>: </p> <ul> <li> <p>BinaryAUC: The binary <code>MLModel</code> uses the Area Under the Curve (AUC) technique to measure performance. </p> </li> <li> <p>RegressionRMSE: The regression <code>MLModel</code> uses the Root Mean Square Error (RMSE) technique to measure performance. RMSE measures the difference between predicted and actual values for a single variable.</p> </li> <li> <p>MulticlassAvgFScore: The multiclass <code>MLModel</code> uses the F1 score technique to measure performance. </p> </li> </ul> <p> For more information about performance metrics, please see the <a href="http://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>. </p>', 'refs' => [ 'Evaluation$PerformanceMetrics' => '<p>Measurements of how well the <code>MLModel</code> performed, using observations referenced by the <code>DataSource</code>. One of the following metrics is returned, based on the type of the <code>MLModel</code>: </p> <ul> <li> <p>BinaryAUC: A binary <code>MLModel</code> uses the Area Under the Curve (AUC) technique to measure performance. </p> </li> <li> <p>RegressionRMSE: A regression <code>MLModel</code> uses the Root Mean Square Error (RMSE) technique to measure performance. RMSE measures the difference between predicted and actual values for a single variable.</p> </li> <li> <p>MulticlassAvgFScore: A multiclass <code>MLModel</code> uses the F1 score technique to measure performance. </p> </li> </ul> <p> For more information about performance metrics, please see the <a href="http://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>. </p>', 'GetEvaluationOutput$PerformanceMetrics' => '<p>Measurements of how well the <code>MLModel</code> performed using observations referenced by the <code>DataSource</code>. One of the following metric is returned based on the type of the <code>MLModel</code>: </p> <ul> <li> <p>BinaryAUC: A binary <code>MLModel</code> uses the Area Under the Curve (AUC) technique to measure performance. </p> </li> <li> <p>RegressionRMSE: A regression <code>MLModel</code> uses the Root Mean Square Error (RMSE) technique to measure performance. RMSE measures the difference between predicted and actual values for a single variable.</p> </li> <li> <p>MulticlassAvgFScore: A multiclass <code>MLModel</code> uses the F1 score technique to measure performance. </p> </li> </ul> <p> For more information about performance metrics, please see the <a href="http://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>. </p>', ], ], 'PerformanceMetricsProperties' => [ 'base' => NULL, 'refs' => [ 'PerformanceMetrics$Properties' => NULL, ], ], 'PerformanceMetricsPropertyKey' => [ 'base' => NULL, 'refs' => [ 'PerformanceMetricsProperties$key' => NULL, ], ], 'PerformanceMetricsPropertyValue' => [ 'base' => NULL, 'refs' => [ 'PerformanceMetricsProperties$value' => NULL, ], ], 'PredictInput' => [ 'base' => NULL, 'refs' => [], ], 'PredictOutput' => [ 'base' => NULL, 'refs' => [], ], 'Prediction' => [ 'base' => '<p>The output from a <code>Predict</code> operation: </p> <ul> <li> <p> <code>Details</code> - Contains the following attributes: <code>DetailsAttributes.PREDICTIVE_MODEL_TYPE - REGRESSION | BINARY | MULTICLASS</code> <code>DetailsAttributes.ALGORITHM - SGD</code> </p> </li> <li> <p> <code>PredictedLabel</code> - Present for either a <code>BINARY</code> or <code>MULTICLASS</code> <code>MLModel</code> request. </p> </li> <li> <p> <code>PredictedScores</code> - Contains the raw classification score corresponding to each label. </p> </li> <li> <p> <code>PredictedValue</code> - Present for a <code>REGRESSION</code> <code>MLModel</code> request. </p> </li> </ul>', 'refs' => [ 'PredictOutput$Prediction' => NULL, ], ], 'PredictorNotMountedException' => [ 'base' => '<p>The exception is thrown when a predict request is made to an unmounted <code>MLModel</code>.</p>', 'refs' => [], ], 'PresignedS3Url' => [ 'base' => NULL, 'refs' => [ 'GetBatchPredictionOutput$LogUri' => '<p>A link to the file that contains logs of the <code>CreateBatchPrediction</code> operation.</p>', 'GetDataSourceOutput$LogUri' => '<p>A link to the file containing logs of <code>CreateDataSourceFrom*</code> operations.</p>', 'GetEvaluationOutput$LogUri' => '<p>A link to the file that contains logs of the <code>CreateEvaluation</code> operation.</p>', 'GetMLModelOutput$LogUri' => '<p>A link to the file that contains logs of the <code>CreateMLModel</code> operation.</p>', ], ], 'RDSDataSpec' => [ 'base' => '<p>The data specification of an Amazon Relational Database Service (Amazon RDS) <code>DataSource</code>.</p>', 'refs' => [ 'CreateDataSourceFromRDSInput$RDSData' => '<p>The data specification of an Amazon RDS <code>DataSource</code>:</p> <ul> <li><p>DatabaseInformation - <ul> <li> <code>DatabaseName</code> - The name of the Amazon RDS database.</li> <li> <code>InstanceIdentifier </code> - A unique identifier for the Amazon RDS database instance.</li> </ul> </p></li> <li><p>DatabaseCredentials - AWS Identity and Access Management (IAM) credentials that are used to connect to the Amazon RDS database.</p></li> <li><p>ResourceRole - A role (DataPipelineDefaultResourceRole) assumed by an EC2 instance to carry out the copy task from Amazon RDS to Amazon Simple Storage Service (Amazon S3). For more information, see <a href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for data pipelines.</p></li> <li><p>ServiceRole - A role (DataPipelineDefaultRole) assumed by the AWS Data Pipeline service to monitor the progress of the copy task from Amazon RDS to Amazon S3. For more information, see <a href="http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for data pipelines.</p></li> <li><p>SecurityInfo - The security information to use to access an RDS DB instance. You need to set up appropriate ingress rules for the security entity IDs provided to allow access to the Amazon RDS instance. Specify a [<code>SubnetId</code>, <code>SecurityGroupIds</code>] pair for a VPC-based RDS DB instance.</p></li> <li><p>SelectSqlQuery - A query that is used to retrieve the observation data for the <code>Datasource</code>.</p></li> <li><p>S3StagingLocation - The Amazon S3 location for staging Amazon RDS data. The data retrieved from Amazon RDS using <code>SelectSqlQuery</code> is stored in this location.</p></li> <li><p>DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.</p></li> <li><p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p></li> <li> <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>Datasource</code>. </p> <br> <p> Sample - <code> "{\\"splitting\\":{\\"percentBegin\\":10,\\"percentEnd\\":60}}"</code> </p> </li> </ul>', ], ], 'RDSDatabase' => [ 'base' => '<p>The database details of an Amazon RDS database.</p>', 'refs' => [ 'RDSDataSpec$DatabaseInformation' => '<p>Describes the <code>DatabaseName</code> and <code>InstanceIdentifier</code> of an Amazon RDS database.</p>', 'RDSMetadata$Database' => '<p>The database details required to connect to an Amazon RDS.</p>', ], ], 'RDSDatabaseCredentials' => [ 'base' => '<p>The database credentials to connect to a database on an RDS DB instance.</p>', 'refs' => [ 'RDSDataSpec$DatabaseCredentials' => '<p>The AWS Identity and Access Management (IAM) credentials that are used connect to the Amazon RDS database.</p>', ], ], 'RDSDatabaseName' => [ 'base' => '<p>The name of a database hosted on an RDS DB instance.</p>', 'refs' => [ 'RDSDatabase$DatabaseName' => NULL, ], ], 'RDSDatabasePassword' => [ 'base' => '<p>The password to be used by Amazon ML to connect to a database on an RDS DB instance. The password should have sufficient permissions to execute the <code>RDSSelectQuery</code> query.</p>', 'refs' => [ 'RDSDatabaseCredentials$Password' => NULL, ], ], 'RDSDatabaseUsername' => [ 'base' => '<p>The username to be used by Amazon ML to connect to database on an Amazon RDS instance. The username should have sufficient permissions to execute an <code>RDSSelectSqlQuery</code> query.</p>', 'refs' => [ 'RDSDatabaseCredentials$Username' => NULL, 'RDSMetadata$DatabaseUserName' => NULL, ], ], 'RDSInstanceIdentifier' => [ 'base' => 'Identifier of RDS DB Instances.', 'refs' => [ 'RDSDatabase$InstanceIdentifier' => '<p>The ID of an RDS DB instance.</p>', ], ], 'RDSMetadata' => [ 'base' => '<p>The datasource details that are specific to Amazon RDS.</p>', 'refs' => [ 'DataSource$RDSMetadata' => NULL, 'GetDataSourceOutput$RDSMetadata' => NULL, ], ], 'RDSSelectSqlQuery' => [ 'base' => '<p>The SQL query to be executed against the Amazon RDS database. The SQL query should be valid for the Amazon RDS type being used. </p>', 'refs' => [ 'RDSDataSpec$SelectSqlQuery' => '<p>The query that is used to retrieve the observation data for the <code>DataSource</code>.</p>', 'RDSMetadata$SelectSqlQuery' => '<p>The SQL query that is supplied during <a>CreateDataSourceFromRDS</a>. Returns only if <code>Verbose</code> is true in <code>GetDataSourceInput</code>. </p>', ], ], 'RealtimeEndpointInfo' => [ 'base' => '<p> Describes the real-time endpoint information for an <code>MLModel</code>.</p>', 'refs' => [ 'CreateRealtimeEndpointOutput$RealtimeEndpointInfo' => '<p>The endpoint information of the <code>MLModel</code> </p>', 'DeleteRealtimeEndpointOutput$RealtimeEndpointInfo' => '<p>The endpoint information of the <code>MLModel</code> </p>', 'GetMLModelOutput$EndpointInfo' => '<p>The current endpoint of the <code>MLModel</code></p>', 'MLModel$EndpointInfo' => '<p>The current endpoint of the <code>MLModel</code>.</p>', ], ], 'RealtimeEndpointStatus' => [ 'base' => NULL, 'refs' => [ 'RealtimeEndpointInfo$EndpointStatus' => '<p> The current status of the real-time endpoint for the <code>MLModel</code>. This element can have one of the following values: </p> <ul> <li> <code>NONE</code> - Endpoint does not exist or was previously deleted.</li> <li> <code>READY</code> - Endpoint is ready to be used for real-time predictions.</li> <li> <code>UPDATING</code> - Updating/creating the endpoint. </li> </ul>', ], ], 'Recipe' => [ 'base' => NULL, 'refs' => [ 'CreateMLModelInput$Recipe' => '<p>The data recipe for creating the <code>MLModel</code>. You must specify either the recipe or its URI. If you don\'t specify a recipe or its URI, Amazon ML creates a default.</p>', 'GetMLModelOutput$Recipe' => '<p>The recipe to use when training the <code>MLModel</code>. The <code>Recipe</code> provides detailed information about the observation data to use during training, and manipulations to perform on the observation data during training.</p> <note><title>Note</title> <p>This parameter is provided as part of the verbose format.</p></note>', ], ], 'Record' => [ 'base' => '<p>A map of variable name-value pairs that represent an observation.</p>', 'refs' => [ 'PredictInput$Record' => NULL, ], ], 'RedshiftClusterIdentifier' => [ 'base' => '<p>The ID of an Amazon Redshift cluster.</p>', 'refs' => [ 'RedshiftDatabase$ClusterIdentifier' => NULL, ], ], 'RedshiftDataSpec' => [ 'base' => '<p>Describes the data specification of an Amazon Redshift <code>DataSource</code>.</p>', 'refs' => [ 'CreateDataSourceFromRedshiftInput$DataSpec' => '<p>The data specification of an Amazon Redshift <code>DataSource</code>:</p> <ul> <li><p>DatabaseInformation - <ul> <li> <code>DatabaseName</code> - The name of the Amazon Redshift database. </li> <li> <code> ClusterIdentifier</code> - The unique ID for the Amazon Redshift cluster.</li> </ul></p></li> <li><p>DatabaseCredentials - The AWS Identity and Access Management (IAM) credentials that are used to connect to the Amazon Redshift database.</p></li> <li><p>SelectSqlQuery - The query that is used to retrieve the observation data for the <code>Datasource</code>.</p></li> <li><p>S3StagingLocation - The Amazon Simple Storage Service (Amazon S3) location for staging Amazon Redshift data. The data retrieved from Amazon Redshift using the <code>SelectSqlQuery</code> query is stored in this location.</p></li> <li><p>DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.</p></li> <li><p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p></li> <li> <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>DataSource</code>.</p> <p> Sample - <code> "{\\"splitting\\":{\\"percentBegin\\":10,\\"percentEnd\\":60}}"</code> </p> </li> </ul>', ], ], 'RedshiftDatabase' => [ 'base' => '<p>Describes the database details required to connect to an Amazon Redshift database.</p>', 'refs' => [ 'RedshiftDataSpec$DatabaseInformation' => '<p>Describes the <code>DatabaseName</code> and <code>ClusterIdentifier</code> for an Amazon Redshift <code>DataSource</code>.</p>', 'RedshiftMetadata$RedshiftDatabase' => NULL, ], ], 'RedshiftDatabaseCredentials' => [ 'base' => '<p> Describes the database credentials for connecting to a database on an Amazon Redshift cluster.</p>', 'refs' => [ 'RedshiftDataSpec$DatabaseCredentials' => '<p>Describes AWS Identity and Access Management (IAM) credentials that are used connect to the Amazon Redshift database.</p>', ], ], 'RedshiftDatabaseName' => [ 'base' => '<p>The name of a database hosted on an Amazon Redshift cluster.</p>', 'refs' => [ 'RedshiftDatabase$DatabaseName' => NULL, ], ], 'RedshiftDatabasePassword' => [ 'base' => '<p>A password to be used by Amazon ML to connect to a database on an Amazon Redshift cluster. The password should have sufficient permissions to execute a <code>RedshiftSelectSqlQuery</code> query. The password should be valid for an Amazon Redshift <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html">USER</a>.</p>', 'refs' => [ 'RedshiftDatabaseCredentials$Password' => NULL, ], ], 'RedshiftDatabaseUsername' => [ 'base' => '<p>A username to be used by Amazon Machine Learning (Amazon ML)to connect to a database on an Amazon Redshift cluster. The username should have sufficient permissions to execute the <code>RedshiftSelectSqlQuery</code> query. The username should be valid for an Amazon Redshift <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html">USER</a>.</p>', 'refs' => [ 'RedshiftDatabaseCredentials$Username' => NULL, 'RedshiftMetadata$DatabaseUserName' => NULL, ], ], 'RedshiftMetadata' => [ 'base' => '<p>Describes the <code>DataSource</code> details specific to Amazon Redshift.</p>', 'refs' => [ 'DataSource$RedshiftMetadata' => NULL, 'GetDataSourceOutput$RedshiftMetadata' => NULL, ], ], 'RedshiftSelectSqlQuery' => [ 'base' => '<p> Describes the SQL query to execute on the Amazon Redshift database. The SQL query should be valid for an Amazon Redshift <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_SELECT_synopsis.html">SELECT</a>. </p>', 'refs' => [ 'RedshiftDataSpec$SelectSqlQuery' => '<p>Describes the SQL Query to execute on an Amazon Redshift database for an Amazon Redshift <code>DataSource</code>.</p>', 'RedshiftMetadata$SelectSqlQuery' => '<p> The SQL query that is specified during <a>CreateDataSourceFromRedshift</a>. Returns only if <code>Verbose</code> is true in GetDataSourceInput. </p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>A specified resource cannot be located.</p>', 'refs' => [], ], 'RoleARN' => [ 'base' => '<p>The Amazon Resource Name (ARN) of an <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html#roles-about-termsandconcepts">AWS IAM Role</a>, such as the following: arn:aws:iam::account:role/rolename. </p>', 'refs' => [ 'CreateDataSourceFromRDSInput$RoleARN' => '<p>The role that Amazon ML assumes on behalf of the user to create and activate a data pipeline in the user\'s account and copy data using the <code>SelectSqlQuery</code> query from Amazon RDS to Amazon S3.</p> <p> </p>', 'CreateDataSourceFromRedshiftInput$RoleARN' => '<p>A fully specified role Amazon Resource Name (ARN). Amazon ML assumes the role on behalf of the user to create the following: </p> <p> <ul> <li><p>A security group to allow Amazon ML to execute the <code>SelectSqlQuery</code> query on an Amazon Redshift cluster</p></li> <li><p>An Amazon S3 bucket policy to grant Amazon ML read/write permissions on the <code>S3StagingLocation</code></p></li> </ul> </p>', 'DataSource$RoleARN' => NULL, 'GetDataSourceOutput$RoleARN' => NULL, ], ], 'S3DataSpec' => [ 'base' => '<p> Describes the data specification of a <code>DataSource</code>.</p>', 'refs' => [ 'CreateDataSourceFromS3Input$DataSpec' => '<p>The data specification of a <code>DataSource</code>:</p> <ul> <li><p>DataLocationS3 - The Amazon S3 location of the observation data.</p></li> <li><p>DataSchemaLocationS3 - The Amazon S3 location of the <code>DataSchema</code>.</p></li> <li><p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p></li> <li> <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>Datasource</code>. </p> <p> Sample - <code> "{\\"splitting\\":{\\"percentBegin\\":10,\\"percentEnd\\":60}}"</code> </p> </li> </ul>', ], ], 'S3Url' => [ 'base' => '<p>A reference to a file or bucket on Amazon Simple Storage Service (Amazon S3).</p>', 'refs' => [ 'BatchPrediction$InputDataLocationS3' => '<p>The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).</p>', 'BatchPrediction$OutputUri' => '<p>The location of an Amazon S3 bucket or directory to receive the operation results. The following substrings are not allowed in the <code>s3 key</code> portion of the <code>outputURI</code> field: \':\', \'//\', \'/./\', \'/../\'.</p>', 'CreateBatchPredictionInput$OutputUri' => '<p>The location of an Amazon Simple Storage Service (Amazon S3) bucket or directory to store the batch prediction results. The following substrings are not allowed in the <code>s3 key</code> portion of the <code>outputURI</code> field: \':\', \'//\', \'/./\', \'/../\'.</p> <p>Amazon ML needs permissions to store and retrieve the logs on your behalf. For information about how to set permissions, see the <a href="http://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>.</p>', 'CreateMLModelInput$RecipeUri' => '<p>The Amazon Simple Storage Service (Amazon S3) location and file name that contains the <code>MLModel</code> recipe. You must specify either the recipe or its URI. If you don\'t specify a recipe or its URI, Amazon ML creates a default.</p>', 'DataSource$DataLocationS3' => '<p>The location and name of the data in Amazon Simple Storage Service (Amazon S3) that is used by a <code>DataSource</code>.</p>', 'Evaluation$InputDataLocationS3' => '<p>The location and name of the data in Amazon Simple Storage Server (Amazon S3) that is used in the evaluation.</p>', 'GetBatchPredictionOutput$InputDataLocationS3' => '<p>The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).</p>', 'GetBatchPredictionOutput$OutputUri' => '<p>The location of an Amazon S3 bucket or directory to receive the operation results.</p>', 'GetDataSourceOutput$DataLocationS3' => '<p>The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).</p>', 'GetEvaluationOutput$InputDataLocationS3' => '<p>The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).</p>', 'GetMLModelOutput$InputDataLocationS3' => '<p>The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).</p>', 'MLModel$InputDataLocationS3' => '<p>The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).</p>', 'RDSDataSpec$S3StagingLocation' => '<p>The Amazon S3 location for staging Amazon RDS data. The data retrieved from Amazon RDS using <code>SelectSqlQuery</code> is stored in this location.</p>', 'RDSDataSpec$DataSchemaUri' => '<p>The Amazon S3 location of the <code>DataSchema</code>. </p>', 'RedshiftDataSpec$S3StagingLocation' => '<p>Describes an Amazon S3 location to store the result set of the <code>SelectSqlQuery</code> query.</p>', 'RedshiftDataSpec$DataSchemaUri' => '<p>Describes the schema location for an Amazon Redshift <code>DataSource</code>.</p>', 'S3DataSpec$DataLocationS3' => '<p>The location of the data file(s) used by a <code>DataSource</code>. The URI specifies a data file or an Amazon Simple Storage Service (Amazon S3) directory or bucket containing data files.</p>', 'S3DataSpec$DataSchemaLocationS3' => '<p>Describes the schema location in Amazon S3. You must provide either the <code>DataSchema</code> or the <code>DataSchemaLocationS3</code>.</p>', ], ], 'ScoreThreshold' => [ 'base' => NULL, 'refs' => [ 'GetMLModelOutput$ScoreThreshold' => '<p>The scoring threshold is used in binary classification <code>MLModel</code><?oxy_insert_start author="laurama" timestamp="20160329T114851-0700"> <?oxy_insert_end>models. It marks the boundary between a positive prediction and a negative prediction.</p> <p>Output values greater than or equal to the threshold receive a positive result from the MLModel, such as <code>true</code>. Output values less than the threshold receive a negative response from the MLModel, such as <code>false</code>.</p>', 'MLModel$ScoreThreshold' => NULL, 'UpdateMLModelInput$ScoreThreshold' => '<p>The <code>ScoreThreshold</code> used in binary classification <code>MLModel</code> that marks the boundary between a positive prediction and a negative prediction.</p> <p>Output values greater than or equal to the <code>ScoreThreshold</code> receive a positive result from the <code>MLModel</code>, such as <code>true</code>. Output values less than the <code>ScoreThreshold</code> receive a negative response from the <code>MLModel</code>, such as <code>false</code>.</p>', ], ], 'ScoreValue' => [ 'base' => NULL, 'refs' => [ 'ScoreValuePerLabelMap$value' => NULL, ], ], 'ScoreValuePerLabelMap' => [ 'base' => 'Provides the raw classification score corresponding to each label.', 'refs' => [ 'Prediction$predictedScores' => NULL, ], ], 'SortOrder' => [ 'base' => '<p>The sort order specified in a listing condition. Possible values include the following:</p> <ul> <li> <code>asc</code> - Present the information in ascending order (from A-Z).</li> <li> <code>dsc</code> - Present the information in descending order (from Z-A).</li> </ul>', 'refs' => [ 'DescribeBatchPredictionsInput$SortOrder' => '<p>A two-value parameter that determines the sequence of the resulting list of <code>MLModel</code>s.</p> <ul> <li> <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</li> <li> <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</li> </ul> <p>Results are sorted by <code>FilterVariable</code>.</p>', 'DescribeDataSourcesInput$SortOrder' => '<p>A two-value parameter that determines the sequence of the resulting list of <code>DataSource</code>.</p> <ul> <li> <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</li> <li> <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</li> </ul> <p>Results are sorted by <code>FilterVariable</code>.</p>', 'DescribeEvaluationsInput$SortOrder' => '<p>A two-value parameter that determines the sequence of the resulting list of <code>Evaluation</code>.</p> <ul> <li> <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</li> <li> <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</li> </ul> <p>Results are sorted by <code>FilterVariable</code>.</p>', 'DescribeMLModelsInput$SortOrder' => '<p>A two-value parameter that determines the sequence of the resulting list of <code>MLModel</code>.</p> <ul> <li> <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</li> <li> <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</li> </ul> <p>Results are sorted by <code>FilterVariable</code>.</p>', ], ], 'StringType' => [ 'base' => '<p>String type.</p>', 'refs' => [ 'DescribeBatchPredictionsInput$NextToken' => '<p>An ID of the page in the paginated results.</p>', 'DescribeBatchPredictionsOutput$NextToken' => '<p>The ID of the next page in the paginated results that indicates at least one more page follows.</p>', 'DescribeDataSourcesInput$NextToken' => '<p>The ID of the page in the paginated results.</p>', 'DescribeDataSourcesOutput$NextToken' => '<p>An ID of the next page in the paginated results that indicates at least one more page follows.</p>', 'DescribeEvaluationsInput$NextToken' => '<p>The ID of the page in the paginated results.</p>', 'DescribeEvaluationsOutput$NextToken' => '<p>The ID of the next page in the paginated results that indicates at least one more page follows.</p>', 'DescribeMLModelsInput$NextToken' => '<p>The ID of the page in the paginated results.</p>', 'DescribeMLModelsOutput$NextToken' => '<p>The ID of the next page in the paginated results that indicates at least one more page follows.</p>', 'TrainingParameters$key' => NULL, 'TrainingParameters$value' => NULL, ], ], 'Tag' => [ 'base' => '<p>A custom key-value pair associated with an ML object, such as an ML model.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>A unique identifier for the tag. Valid characters include Unicode letters, digits, white space, _, ., /, =, +, -, %, and @.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'DeleteTagsInput$TagKeys' => '<p>One or more tags to delete.</p>', ], ], 'TagLimitExceededException' => [ 'base' => NULL, 'refs' => [], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'AddTagsInput$Tags' => '<p>The key-value pairs to use to create tags. If you specify a key without specifying a value, Amazon ML creates a tag with the specified key and a value of null.</p>', 'DescribeTagsOutput$Tags' => '<p>A list of tags associated with the ML object.</p>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>An optional string, typically used to describe or define the tag. Valid characters include Unicode letters, digits, white space, _, ., /, =, +, -, %, and @.</p>', ], ], 'TaggableResourceType' => [ 'base' => NULL, 'refs' => [ 'AddTagsInput$ResourceType' => '<p>The type of the ML object to tag. </p>', 'AddTagsOutput$ResourceType' => '<p>The type of the ML object that was tagged.</p>', 'DeleteTagsInput$ResourceType' => '<p>The type of the tagged ML object.</p>', 'DeleteTagsOutput$ResourceType' => '<p>The type of the ML object from which tags were deleted.</p>', 'DescribeTagsInput$ResourceType' => '<p>The type of the ML object.</p>', 'DescribeTagsOutput$ResourceType' => '<p>The type of the tagged ML object.</p>', ], ], 'TrainingParameters' => [ 'base' => NULL, 'refs' => [ 'CreateMLModelInput$Parameters' => '<p>A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of key-value pairs.</p> <p>The following is the current set of training parameters: </p> <ul> <li> <p><code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input data, the size of the model might affect its performance.</p> <p> The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default value is <code>33554432</code>.</p> </li> <li><p><code>sgd.maxPasses</code> - The number of times that the training process traverses the observations to build the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to <code>10000</code>. The default value is <code>10</code>.</p></li> <li> <p><code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling the data improves a model\'s ability to find the optimal solution for a variety of data types. The valid values are <code>auto</code> and <code>none</code>. The default value is <code>none</code>. We <?oxy_insert_start author="laurama" timestamp="20160329T131121-0700">strongly recommend that you shuffle your data.<?oxy_insert_end></p> </li> <li> <p><code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls overfitting the data by penalizing large coefficients. This tends to drive coefficients to zero, resulting in a sparse feature set. If you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.</p> <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use L1 normalization. This parameter can\'t be used when <code>L2</code> is specified. Use this parameter sparingly.</p> </li> <li> <p><code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls overfitting the data by penalizing large coefficients. This tends to drive coefficients to small, nonzero values. If you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.</p> <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use L2 normalization. This parameter can\'t be used when <code>L1</code> is specified. Use this parameter sparingly.</p> </li> </ul>', 'GetMLModelOutput$TrainingParameters' => '<p>A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of key-value pairs.</p> <p>The following is the current set of training parameters: </p> <ul> <li> <p><code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input data, the size of the model might affect its performance.</p> <p> The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default value is <code>33554432</code>.</p> </li> <li><p><code>sgd.maxPasses</code> - The number of times that the training process traverses the observations to build the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to <code>10000</code>. The default value is <code>10</code>.</p></li> <li><p><code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling data improves a model\'s ability to find the optimal solution for a variety of data types. The valid values are <code>auto</code> and <code>none</code>. The default value is <code>none</code>. We strongly recommend that you shuffle your data.</p></li> <li> <p><code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls overfitting the data by penalizing large coefficients. This tends to drive coefficients to zero, resulting in a sparse feature set. If you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.</p> <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use L1 normalization. This parameter can\'t be used when <code>L2</code> is specified. Use this parameter sparingly.</p> </li> <li> <p><code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls overfitting the data by penalizing large coefficients. This tends to drive coefficients to small, nonzero values. If you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.</p> <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use L2 normalization. This parameter can\'t be used when <code>L1</code> is specified. Use this parameter sparingly.</p> </li> </ul>', 'MLModel$TrainingParameters' => '<p>A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of key-value pairs.</p> <p>The following is the current set of training parameters: </p> <ul> <li> <p><code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input data, the size of the model might affect its performance.</p> <p> The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default value is <code>33554432</code>.</p> </li> <li><p><code>sgd.maxPasses</code> - The number of times that the training process traverses the observations to build the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to <code>10000</code>. The default value is <code>10</code>.</p></li> <li><p><code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling the data improves a model\'s ability to find the optimal solution for a variety of data types. The valid values are <code>auto</code> and <code>none</code>. The default value is <code>none</code>.</p></li> <li> <p><code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm, which controls overfitting the data by penalizing large coefficients. This parameter tends to drive coefficients to zero, resulting in sparse feature set. If you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.</p> <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use L1 normalization. This parameter can\'t be used when <code>L2</code> is specified. Use this parameter sparingly.</p> </li> <li> <p><code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm, which controls overfitting the data by penalizing large coefficients. This tends to drive coefficients to small, nonzero values. If you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.</p> <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use L2 normalization. This parameter can\'t be used when <code>L1</code> is specified. Use this parameter sparingly.</p> </li> </ul>', ], ], 'UpdateBatchPredictionInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBatchPredictionOutput' => [ 'base' => '<p>Represents the output of an <code>UpdateBatchPrediction</code> operation.</p> <p>You can see the updated content by using the <code>GetBatchPrediction</code> operation.</p>', 'refs' => [], ], 'UpdateDataSourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataSourceOutput' => [ 'base' => '<p>Represents the output of an <code>UpdateDataSource</code> operation.</p> <p>You can see the updated content by using the <code>GetBatchPrediction</code> operation.</p>', 'refs' => [], ], 'UpdateEvaluationInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEvaluationOutput' => [ 'base' => '<p>Represents the output of an <code>UpdateEvaluation</code> operation.</p> <p>You can see the updated content by using the <code>GetEvaluation</code> operation.</p>', 'refs' => [], ], 'UpdateMLModelInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMLModelOutput' => [ 'base' => '<p>Represents the output of an <code>UpdateMLModel</code> operation.</p> <p>You can see the updated content by using the <code>GetMLModel</code> operation.</p>', 'refs' => [], ], 'VariableName' => [ 'base' => '<p>The name of a variable. Currently it\'s used to specify the name of the target value, label, weight, and tags.</p>', 'refs' => [ 'Record$key' => NULL, ], ], 'VariableValue' => [ 'base' => '<p>The value of a variable. Currently it\'s used to specify values of the target value, weights, and tag variables and for filtering variable values.</p>', 'refs' => [ 'Record$value' => NULL, ], ], 'Verbose' => [ 'base' => '<p>Specifies whether a describe operation should return exhaustive or abbreviated information.</p>', 'refs' => [ 'GetDataSourceInput$Verbose' => '<p>Specifies whether the <code>GetDataSource</code> operation should return <code>DataSourceSchema</code>.</p> <p>If true, <code>DataSourceSchema</code> is returned.</p> <p>If false, <code>DataSourceSchema</code> is not returned.</p>', 'GetMLModelInput$Verbose' => '<p>Specifies whether the <code>GetMLModel</code> operation should return <code>Recipe</code>.</p> <p>If true, <code>Recipe</code> is returned.</p> <p>If false, <code>Recipe</code> is not returned.</p>', ], ], 'VipURL' => [ 'base' => NULL, 'refs' => [ 'PredictInput$PredictEndpoint' => NULL, 'RealtimeEndpointInfo$EndpointUrl' => '<p>The URI that specifies where to send real-time prediction requests for the <code>MLModel</code>.</p> <note><title>Note</title> <p>The application must wait until the real-time endpoint is ready before using this URI.</p> </note>', ], ], 'floatLabel' => [ 'base' => NULL, 'refs' => [ 'Prediction$predictedValue' => 'The prediction value for <code>REGRESSION</code> <code>MLModel</code>.', ], ], ],];
