<?php
// This file was auto-generated from sdk-root/src/data/ivs/2020-07-14/docs-2.json
return [ 'version' => '2.0', 'service' => '<p> <b>Introduction</b> </p> <p>The Amazon Interactive Video Service (IVS) API is REST compatible, using a standard HTTP API and an <a href="http://aws.amazon.com/sns">AWS SNS</a> event stream for responses. JSON is used for both requests and responses, including errors.</p> <p>The API is an AWS regional service, currently in these regions: us-west-2, us-east-1, and eu-west-1.</p> <p> <i> <b>All API request parameters and URLs are case sensitive. </b> </i> </p> <p>For a summary of notable documentation changes in each release, see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/doc-history.html"> Document History</a>.</p> <p> <b>Service Endpoints</b> </p> <p>The following are the Amazon IVS service endpoints (all HTTPS): </p> <p>Region name: US West (Oregon)</p> <ul> <li> <p>Region: <code>us-west-2</code> </p> </li> <li> <p>Endpoint: <code>ivs.us-west-2.amazonaws.com</code> </p> </li> </ul> <p>Region name: US East (Virginia)</p> <ul> <li> <p>Region: <code>us-east-1</code> </p> </li> <li> <p>Endpoint: <code>ivs.us-east-1.amazonaws.com</code> </p> </li> </ul> <p>Region name: EU West (Dublin)</p> <ul> <li> <p>Region: <code>eu-west-1</code> </p> </li> <li> <p>Endpoint: <code>ivs.eu-west-1.amazonaws.com</code> </p> </li> </ul> <p> <b>Allowed Header Values</b> </p> <ul> <li> <p> <code> <b>Accept:</b> </code> application/json</p> </li> <li> <p> <code> <b>Accept-Encoding:</b> </code> gzip, deflate</p> </li> <li> <p> <code> <b>Content-Type:</b> </code>application/json</p> </li> </ul> <p> <b>Resources</b> </p> <p>The following resources contain information about your IVS live stream (see <a href="https://docs.aws.amazon.com/ivs/latest/userguide/GSIVS.html"> Getting Started with Amazon IVS</a>):</p> <ul> <li> <p>Channel — Stores configuration data related to your live stream. You first create a channel and then use the channel’s stream key to start your live stream. See the <a>Channel</a> endpoints for more information. </p> </li> <li> <p>Stream key — An identifier assigned by Amazon IVS when you create a channel, which is then used to authorize streaming. See the <a>StreamKey</a> endpoints for more information. <i> <b>Treat the stream key like a secret, since it allows anyone to stream to the channel.</b> </i> </p> </li> </ul> <p> <b>Tagging</b> </p> <p>A <i>tag</i> is a metadata label that you assign to an AWS resource. A tag comprises a <i>key</i> and a <i>value</i>, both set by you. For example, you might set a tag as <code>topic:nature</code> to label a particular video category. See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for more information, including restrictions that apply to tags.</p> <p>Tags can help you identify and organize your AWS resources. For example, you can use the same tag for different resources to indicate that they are related. You can also use tags to manage access (see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html"> Access Tags</a>). </p> <p>The Amazon IVS API has these tag-related endpoints: <a>TagResource</a>, <a>UntagResource</a>, and <a>ListTagsForResource</a>. The following resources support tagging: Channels and Stream Keys.</p> <p> <b>API Endpoints</b> </p> <p> <a>Channel</a>:</p> <ul> <li> <p> <a>CreateChannel</a> — Creates a new channel and an associated stream key to start streaming.</p> </li> <li> <p> <a>GetChannel</a> — Gets the channel configuration for the specified channel ARN (Amazon Resource Name).</p> </li> <li> <p> <a>BatchGetChannel</a> — Performs <a>GetChannel</a> on multiple ARNs simultaneously.</p> </li> <li> <p> <a>ListChannels</a> — Gets summary information about all channels in your account, in the AWS region where the API request is processed. This list can be filtered to match a specified string.</p> </li> <li> <p> <a>UpdateChannel</a> — Updates a channel\'s configuration. This does not affect an ongoing stream of this channel. You must stop and restart the stream for the changes to take effect.</p> </li> <li> <p> <a>DeleteChannel</a> — Deletes the specified channel.</p> </li> </ul> <p> <a>StreamKey</a>:</p> <ul> <li> <p> <a>CreateStreamKey</a> — Creates a stream key, used to initiate a stream, for the specified channel ARN.</p> </li> <li> <p> <a>GetStreamKey</a> — Gets stream key information for the specified ARN.</p> </li> <li> <p> <a>BatchGetStreamKey</a> — Performs <a>GetStreamKey</a> on multiple ARNs simultaneously.</p> </li> <li> <p> <a>ListStreamKeys</a> — Gets summary information about stream keys for the specified channel.</p> </li> <li> <p> <a>DeleteStreamKey</a> — Deletes the stream key for the specified ARN, so it can no longer be used to stream.</p> </li> </ul> <p> <a>Stream</a>:</p> <ul> <li> <p> <a>GetStream</a> — Gets information about the active (live) stream on a specified channel.</p> </li> <li> <p> <a>ListStreams</a> — Gets summary information about live streams in your account, in the AWS region where the API request is processed.</p> </li> <li> <p> <a>StopStream</a> — Disconnects the incoming RTMPS stream for the specified channel. Can be used in conjunction with <a>DeleteStreamKey</a> to prevent further streaming to a channel.</p> </li> <li> <p> <a>PutMetadata</a> — Inserts metadata into an RTMPS stream for the specified channel. A maximum of 5 requests per second per channel is allowed, each with a maximum 1KB payload.</p> </li> </ul> <p> <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> AWS Tags</a>:</p> <ul> <li> <p> <a>TagResource</a> — Adds or updates tags for the AWS resource with the specified ARN.</p> </li> <li> <p> <a>UntagResource</a> — Removes tags from the resource with the specified ARN.</p> </li> <li> <p> <a>ListTagsForResource</a> — Gets information about AWS tags for the specified ARN.</p> </li> </ul>', 'operations' => [ 'BatchGetChannel' => '<p>Performs <a>GetChannel</a> on multiple ARNs simultaneously.</p>', 'BatchGetStreamKey' => '<p>Performs <a>GetStreamKey</a> on multiple ARNs simultaneously.</p>', 'CreateChannel' => '<p>Creates a new channel and an associated stream key to start streaming.</p>', 'CreateStreamKey' => '<p>Creates a stream key, used to initiate a stream, for the specified channel ARN.</p> <p>Note that <a>CreateChannel</a> creates a stream key. If you subsequently use CreateStreamKey on the same channel, it will fail because a stream key already exists and there is a limit of 1 stream key per channel. To reset the stream key on a channel, use <a>DeleteStreamKey</a> and then CreateStreamKey.</p>', 'DeleteChannel' => '<p>Deletes the specified channel and its associated stream keys.</p>', 'DeleteStreamKey' => '<p>Deletes the stream key for the specified ARN, so it can no longer be used to stream.</p>', 'GetChannel' => '<p>Gets the channel configuration for the specified channel ARN. See also <a>BatchGetChannel</a>.</p>', 'GetStream' => '<p>Gets information about the active (live) stream on a specified channel.</p>', 'GetStreamKey' => '<p>Gets stream-key information for a specified ARN.</p>', 'ListChannels' => '<p>Gets summary information about all channels in your account, in the AWS region where the API request is processed. This list can be filtered to match a specified string.</p>', 'ListStreamKeys' => '<p>Gets summary information about stream keys for the specified channel.</p>', 'ListStreams' => '<p>Gets summary information about live streams in your account, in the AWS region where the API request is processed.</p>', 'ListTagsForResource' => '<p>Gets information about AWS tags for the specified ARN.</p>', 'PutMetadata' => '<p>Inserts metadata into an RTMPS stream for the specified channel. A maximum of 5 requests per second per channel is allowed, each with a maximum 1KB payload.</p>', 'StopStream' => '<p>Disconnects the incoming RTMPS stream for the specified channel. Can be used in conjunction with <a>DeleteStreamKey</a> to prevent further streaming to a channel.</p> <note> <p>Many streaming client-software libraries automatically reconnect a dropped RTMPS session, so to stop the stream permanently, you may want to first revoke the <code>streamKey</code> attached to the channel.</p> </note>', 'TagResource' => '<p>Adds or updates tags for the AWS resource with the specified ARN.</p>', 'UntagResource' => '<p>Removes tags from the resource with the specified ARN.</p>', 'UpdateChannel' => '<p>Updates a channel\'s configuration. This does not affect an ongoing stream of this channel. You must stop and restart the stream for the changes to take effect.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => NULL, 'refs' => [], ], 'BatchError' => [ 'base' => '<p>Error related to a specific channel, specified by its ARN.</p>', 'refs' => [ 'BatchErrors$member' => NULL, ], ], 'BatchErrors' => [ 'base' => NULL, 'refs' => [ 'BatchGetChannelResponse$errors' => '<p>Each error object is related to a specific ARN in the request.</p>', 'BatchGetStreamKeyResponse$errors' => NULL, ], ], 'BatchGetChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetStreamKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetStreamKeyResponse' => [ 'base' => NULL, 'refs' => [], ], 'Channel' => [ 'base' => '<p>Object specifying a channel.</p>', 'refs' => [ 'Channels$member' => NULL, 'CreateChannelResponse$channel' => NULL, 'GetChannelResponse$channel' => NULL, 'UpdateChannelResponse$channel' => NULL, ], ], 'ChannelArn' => [ 'base' => NULL, 'refs' => [ 'Channel$arn' => '<p>Channel ARN.</p>', 'ChannelArnList$member' => NULL, 'ChannelSummary$arn' => '<p>Channel ARN.</p>', 'CreateStreamKeyRequest$channelArn' => '<p>ARN of the channel for which to create the stream key.</p>', 'DeleteChannelRequest$arn' => '<p>ARN of the channel to be deleted.</p>', 'GetChannelRequest$arn' => '<p>ARN of the channel for which the configuration is to be retrieved.</p>', 'GetStreamRequest$channelArn' => '<p>Channel ARN for stream to be accessed.</p>', 'ListStreamKeysRequest$channelArn' => '<p>Channel ARN used to filter the list.</p>', 'PutMetadataRequest$channelArn' => '<p>ARN of the channel into which metadata is inserted. This channel must have an active stream.</p>', 'StopStreamRequest$channelArn' => '<p>ARN of the channel for which the stream is to be stopped.</p>', 'Stream$channelArn' => '<p>Channel ARN for the stream.</p>', 'StreamKey$channelArn' => '<p>Channel ARN for the stream.</p>', 'StreamKeySummary$channelArn' => '<p>Channel ARN for the stream.</p>', 'StreamSummary$channelArn' => '<p>Channel ARN for the stream.</p>', 'UpdateChannelRequest$arn' => '<p>ARN of the channel to be updated.</p>', ], ], 'ChannelArnList' => [ 'base' => NULL, 'refs' => [ 'BatchGetChannelRequest$arns' => '<p>Array of ARNs, one per channel.</p>', ], ], 'ChannelLatencyMode' => [ 'base' => NULL, 'refs' => [ 'Channel$latencyMode' => '<p>Channel latency mode. Default: <code>LOW</code>.</p>', 'ChannelSummary$latencyMode' => '<p>Channel latency mode. Default: <code>LOW</code>.</p>', 'CreateChannelRequest$latencyMode' => '<p>Channel latency mode. Default: <code>LOW</code>.</p>', 'UpdateChannelRequest$latencyMode' => '<p>Channel latency mode. Default: <code>LOW</code>.</p>', ], ], 'ChannelList' => [ 'base' => NULL, 'refs' => [ 'ListChannelsResponse$channels' => '<p>List of the matching channels.</p>', ], ], 'ChannelName' => [ 'base' => NULL, 'refs' => [ 'Channel$name' => '<p>Channel name.</p>', 'ChannelSummary$name' => '<p>Channel name.</p>', 'CreateChannelRequest$name' => '<p>Channel name.</p>', 'ListChannelsRequest$filterByName' => '<p>Filters the channel list to match the specified name.</p>', 'UpdateChannelRequest$name' => '<p>Channel name.</p>', ], ], 'ChannelNotBroadcasting' => [ 'base' => NULL, 'refs' => [], ], 'ChannelSummary' => [ 'base' => '<p>Summary information about a channel.</p>', 'refs' => [ 'ChannelList$member' => NULL, ], ], 'ChannelType' => [ 'base' => NULL, 'refs' => [ 'Channel$type' => '<p>Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately.</i> Valid values:</p> <ul> <li> <p> <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give viewers the best experience for their devices and network conditions. Vertical resolution can be up to 1080 and bitrate can be up to 8.5 Mbps.</p> </li> <li> <p> <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is limited to the original input. Vertical resolution can be up to 480 and bitrate can be up to 1.5 Mbps.</p> </li> </ul> <p>Default: <code>STANDARD</code>.</p>', 'CreateChannelRequest$type' => '<p>Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately.</i> Valid values:</p> <ul> <li> <p> <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give viewers the best experience for their devices and network conditions. Vertical resolution can be up to 1080 and bitrate can be up to 8.5 Mbps.</p> </li> <li> <p> <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is limited to the original input. Vertical resolution can be up to 480 and bitrate can be up to 1.5 Mbps.</p> </li> </ul> <p>Default: <code>STANDARD</code>.</p>', 'UpdateChannelRequest$type' => '<p>Channel type, which determines the allowable resolution and bitrate. <i>If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately.</i> Valid values:</p> <ul> <li> <p> <code>STANDARD</code>: Multiple qualities are generated from the original input, to automatically give viewers the best experience for their devices and network conditions. Vertical resolution can be up to 1080 and bitrate can be up to 8.5 Mbps.</p> </li> <li> <p> <code>BASIC</code>: Amazon IVS delivers the original input to viewers. The viewer’s video-quality choice is limited to the original input. Vertical resolution can be up to 480 and bitrate can be up to 1.5 Mbps.</p> </li> </ul> <p>Default: <code>STANDARD</code>.</p>', ], ], 'Channels' => [ 'base' => NULL, 'refs' => [ 'BatchGetChannelResponse$channels' => NULL, ], ], 'ConflictException' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateStreamKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateStreamKeyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStreamKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetStreamKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStreamKeyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetStreamRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStreamResponse' => [ 'base' => NULL, 'refs' => [], ], 'IngestEndpoint' => [ 'base' => NULL, 'refs' => [ 'Channel$ingestEndpoint' => '<p>Channel ingest endpoint, part of the definition of an ingest server, used when you set up streaming software.</p>', ], ], 'InternalServerException' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamKeysRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamKeysResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxChannelResults' => [ 'base' => NULL, 'refs' => [ 'ListChannelsRequest$maxResults' => '<p>Maximum number of channels to return.</p>', ], ], 'MaxStreamKeyResults' => [ 'base' => NULL, 'refs' => [ 'ListStreamKeysRequest$maxResults' => '<p>Maximum number of streamKeys to return.</p>', ], ], 'MaxStreamResults' => [ 'base' => NULL, 'refs' => [ 'ListStreamsRequest$maxResults' => '<p>Maximum number of streams to return.</p>', ], ], 'MaxTagResults' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$maxResults' => '<p>Maximum number of tags to return.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListChannelsRequest$nextToken' => '<p>The first channel to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>', 'ListChannelsResponse$nextToken' => '<p>If there are more channels than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>', 'ListStreamKeysRequest$nextToken' => '<p>The first stream key to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>', 'ListStreamKeysResponse$nextToken' => '<p>If there are more stream keys than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>', 'ListStreamsRequest$nextToken' => '<p>The first stream to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>', 'ListStreamsResponse$nextToken' => '<p>If there are more streams than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>', ], ], 'PendingVerification' => [ 'base' => NULL, 'refs' => [], ], 'PlaybackURL' => [ 'base' => NULL, 'refs' => [ 'Channel$playbackUrl' => '<p>Channel playback URL.</p>', 'Stream$playbackUrl' => '<p>URL of the video master manifest, required by the video player to play the HLS stream.</p>', ], ], 'PutMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'BatchError$arn' => '<p>Channel ARN.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The ARN of the resource to be retrieved.</p>', 'TagResourceRequest$resourceArn' => '<p>ARN of the resource for which tags are to be added or updated.</p>', 'UntagResourceRequest$resourceArn' => '<p>ARN of the resource for which tags are to be removed.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => NULL, 'refs' => [], ], 'ServiceQuotaExceededException' => [ 'base' => NULL, 'refs' => [], ], 'StopStreamRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopStreamResponse' => [ 'base' => NULL, 'refs' => [], ], 'Stream' => [ 'base' => '<p>Specifies a live video stream that has been ingested and distributed.</p>', 'refs' => [ 'GetStreamResponse$stream' => NULL, ], ], 'StreamHealth' => [ 'base' => NULL, 'refs' => [ 'Stream$health' => '<p>The stream’s health.</p>', 'StreamSummary$health' => '<p>The stream’s health.</p>', ], ], 'StreamKey' => [ 'base' => '<p>Object specifying a stream key.</p>', 'refs' => [ 'CreateChannelResponse$streamKey' => NULL, 'CreateStreamKeyResponse$streamKey' => '<p>Stream key used to authenticate an RTMPS stream for ingestion.</p>', 'GetStreamKeyResponse$streamKey' => NULL, 'StreamKeys$member' => NULL, ], ], 'StreamKeyArn' => [ 'base' => NULL, 'refs' => [ 'DeleteStreamKeyRequest$arn' => '<p>ARN of the stream key to be deleted.</p>', 'GetStreamKeyRequest$arn' => '<p>ARN for the stream key to be retrieved.</p>', 'StreamKey$arn' => '<p>Stream-key ARN.</p>', 'StreamKeyArnList$member' => NULL, 'StreamKeySummary$arn' => '<p>Stream-key ARN.</p>', ], ], 'StreamKeyArnList' => [ 'base' => NULL, 'refs' => [ 'BatchGetStreamKeyRequest$arns' => '<p>Array of ARNs, one per channel.</p>', ], ], 'StreamKeyList' => [ 'base' => NULL, 'refs' => [ 'ListStreamKeysResponse$streamKeys' => '<p>List of stream keys.</p>', ], ], 'StreamKeySummary' => [ 'base' => '<p>Summary information about a stream key.</p>', 'refs' => [ 'StreamKeyList$member' => NULL, ], ], 'StreamKeyValue' => [ 'base' => NULL, 'refs' => [ 'StreamKey$value' => '<p>Stream-key value.</p>', ], ], 'StreamKeys' => [ 'base' => NULL, 'refs' => [ 'BatchGetStreamKeyResponse$streamKeys' => NULL, ], ], 'StreamList' => [ 'base' => NULL, 'refs' => [ 'ListStreamsResponse$streams' => '<p>List of streams.</p>', ], ], 'StreamMetadata' => [ 'base' => NULL, 'refs' => [ 'PutMetadataRequest$metadata' => '<p>Metadata to insert into the stream. Maximum: 1 KB per request.</p>', ], ], 'StreamStartTime' => [ 'base' => NULL, 'refs' => [ 'Stream$startTime' => '<p>ISO-8601 formatted timestamp of the stream’s start.</p>', 'StreamSummary$startTime' => '<p>ISO-8601 formatted timestamp of the stream’s start.</p>', ], ], 'StreamState' => [ 'base' => NULL, 'refs' => [ 'Stream$state' => '<p>The stream’s state.</p>', 'StreamSummary$state' => '<p>The stream’s state.</p>', ], ], 'StreamSummary' => [ 'base' => '<p>Summary information about a stream.</p>', 'refs' => [ 'StreamList$member' => NULL, ], ], 'StreamUnavailable' => [ 'base' => NULL, 'refs' => [], ], 'StreamViewerCount' => [ 'base' => NULL, 'refs' => [ 'Stream$viewerCount' => '<p>Number of current viewers of the stream.</p>', 'StreamSummary$viewerCount' => '<p>Number of current viewers of the stream.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$nextToken' => '<p>The first tag to retrieve. This is used for pagination; see the <code>nextToken</code> response field.</p>', 'ListTagsForResourceResponse$nextToken' => '<p>If there are more tags than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next set.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'Tags$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>Array of tags to be removed.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tags$value' => NULL, ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'Channel$tags' => '<p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>', 'ChannelSummary$tags' => '<p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code>.</p>', 'CreateChannelRequest$tags' => '<p>See <a>Channel$tags</a>.</p>', 'CreateStreamKeyRequest$tags' => '<p>See <a>Channel$tags</a>.</p>', 'ListTagsForResourceResponse$tags' => NULL, 'StreamKey$tags' => '<p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code> </p>', 'StreamKeySummary$tags' => '<p>Array of 1-50 maps, each of the form <code>string:string (key:value)</code> </p>', 'TagResourceRequest$tags' => '<p>Array of tags to be added or updated.</p>', ], ], 'ThrottlingException' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => NULL, 'refs' => [], ], 'errorCode' => [ 'base' => NULL, 'refs' => [ 'BatchError$code' => '<p>Error code.</p>', ], ], 'errorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$exceptionMessage' => '<p>User does not have sufficient access to perform this action.</p>', 'BatchError$message' => '<p>Error message, determined by the application.</p>', 'ChannelNotBroadcasting$exceptionMessage' => '<p>The stream is offline for the given channel ARN.</p>', 'ConflictException$exceptionMessage' => '<p>Updating or deleting a resource can cause an inconsistent state.</p>', 'InternalServerException$exceptionMessage' => '<p>Unexpected error during processing of request.</p>', 'PendingVerification$exceptionMessage' => '<p> Your account is pending verification. </p>', 'ResourceNotFoundException$exceptionMessage' => '<p>Request references a resource which does not exist.</p>', 'ServiceQuotaExceededException$exceptionMessage' => '<p>Request would cause a service quota to be exceeded.</p>', 'StreamUnavailable$exceptionMessage' => '<p>The stream is temporarily unavailable.</p>', 'ThrottlingException$exceptionMessage' => '<p>Request was denied due to request throttling.</p>', 'ValidationException$exceptionMessage' => '<p>The input fails to satisfy the constraints specified by an AWS service.</p>', ], ], ],];
