<?php
// This file was auto-generated from sdk-root/src/data/iotevents-data/2018-10-23/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>AWS IoT Events monitors your equipment or device fleets for failures or changes in operation, and triggers actions when such events occur. AWS IoT Events Data API commands enable you to send inputs to detectors, list detectors, and view or update a detector\'s status.</p>', 'operations' => [ 'BatchPutMessage' => '<p>Sends a set of messages to the AWS IoT Events system. Each message payload is transformed into the input you specify (<code>"inputName"</code>) and ingested into any detectors that monitor that input. If multiple messages are sent, the order in which the messages are processed isn\'t guaranteed. To guarantee ordering, you must send messages one at a time and wait for a successful response.</p>', 'BatchUpdateDetector' => '<p>Updates the state, variable values, and timer settings of one or more detectors (instances) of a specified detector model.</p>', 'DescribeDetector' => '<p>Returns information about the specified detector (instance).</p>', 'ListDetectors' => '<p>Lists detectors (the instances of a detector model).</p>', ], 'shapes' => [ 'BatchPutMessageErrorEntries' => [ 'base' => NULL, 'refs' => [ 'BatchPutMessageResponse$BatchPutMessageErrorEntries' => '<p>A list of any errors encountered when sending the messages.</p>', ], ], 'BatchPutMessageErrorEntry' => [ 'base' => '<p>Contains information about the errors encountered.</p>', 'refs' => [ 'BatchPutMessageErrorEntries$member' => NULL, ], ], 'BatchPutMessageRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchPutMessageResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdateDetectorErrorEntries' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateDetectorResponse$batchUpdateDetectorErrorEntries' => '<p>A list of those detector updates that resulted in errors. (If an error is listed here, the specific update did not occur.)</p>', ], ], 'BatchUpdateDetectorErrorEntry' => [ 'base' => '<p>Information about the error that occured when attempting to update a detector.</p>', 'refs' => [ 'BatchUpdateDetectorErrorEntries$member' => NULL, ], ], 'BatchUpdateDetectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdateDetectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDetectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDetectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'Detector' => [ 'base' => '<p>Information about the detector (instance).</p>', 'refs' => [ 'DescribeDetectorResponse$detector' => '<p>Information about the detector (instance).</p>', ], ], 'DetectorModelName' => [ 'base' => NULL, 'refs' => [ 'DescribeDetectorRequest$detectorModelName' => '<p>The name of the detector model whose detectors (instances) you want information about.</p>', 'Detector$detectorModelName' => '<p>The name of the detector model that created this detector (instance).</p>', 'DetectorSummary$detectorModelName' => '<p>The name of the detector model that created this detector (instance).</p>', 'ListDetectorsRequest$detectorModelName' => '<p>The name of the detector model whose detectors (instances) are listed.</p>', 'UpdateDetectorRequest$detectorModelName' => '<p>The name of the detector model that created the detectors (instances).</p>', ], ], 'DetectorModelVersion' => [ 'base' => NULL, 'refs' => [ 'Detector$detectorModelVersion' => '<p>The version of the detector model that created this detector (instance).</p>', 'DetectorSummary$detectorModelVersion' => '<p>The version of the detector model that created this detector (instance).</p>', ], ], 'DetectorState' => [ 'base' => '<p>Information about the current state of the detector instance.</p>', 'refs' => [ 'Detector$state' => '<p>The current state of the detector (instance).</p>', ], ], 'DetectorStateDefinition' => [ 'base' => '<p>The new state, variable values, and timer settings of the detector (instance).</p>', 'refs' => [ 'UpdateDetectorRequest$state' => '<p>The new state, variable values, and timer settings of the detector (instance).</p>', ], ], 'DetectorStateSummary' => [ 'base' => '<p>Information about the detector state.</p>', 'refs' => [ 'DetectorSummary$state' => '<p>The current state of the detector (instance).</p>', ], ], 'DetectorSummaries' => [ 'base' => NULL, 'refs' => [ 'ListDetectorsResponse$detectorSummaries' => '<p>A list of summary information about the detectors (instances).</p>', ], ], 'DetectorSummary' => [ 'base' => '<p>Information about the detector (instance).</p>', 'refs' => [ 'DetectorSummaries$member' => NULL, ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'BatchPutMessageErrorEntry$errorCode' => '<p>The code associated with the error.</p>', 'BatchUpdateDetectorErrorEntry$errorCode' => '<p>The code of the error.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'BatchPutMessageErrorEntry$errorMessage' => '<p>More information about the error.</p>', 'BatchUpdateDetectorErrorEntry$errorMessage' => '<p>A message describing the error.</p>', ], ], 'InputName' => [ 'base' => NULL, 'refs' => [ 'Message$inputName' => '<p>The name of the input into which the message payload is transformed.</p>', ], ], 'InternalFailureException' => [ 'base' => '<p>An internal failure occured.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>The request was invalid.</p>', 'refs' => [], ], 'KeyValue' => [ 'base' => NULL, 'refs' => [ 'DescribeDetectorRequest$keyValue' => '<p>A filter used to limit results to detectors (instances) created because of the given key ID.</p>', 'Detector$keyValue' => '<p>The value of the key (identifying the device or system) that caused the creation of this detector (instance).</p>', 'DetectorSummary$keyValue' => '<p>The value of the key (identifying the device or system) that caused the creation of this detector (instance).</p>', 'UpdateDetectorRequest$keyValue' => '<p>The value of the input key attribute (identifying the device or system) that caused the creation of this detector (instance).</p>', ], ], 'ListDetectorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDetectorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListDetectorsRequest$maxResults' => '<p>The maximum number of results to return at one time.</p>', ], ], 'Message' => [ 'base' => '<p>Information about a message.</p>', 'refs' => [ 'Messages$member' => NULL, ], ], 'MessageId' => [ 'base' => NULL, 'refs' => [ 'BatchPutMessageErrorEntry$messageId' => '<p>The ID of the message that caused the error. (See the value corresponding to the <code>"messageId"</code> key in the <code>"message"</code> object.)</p>', 'BatchUpdateDetectorErrorEntry$messageId' => '<p>The <code>"messageId"</code> of the update request that caused the error. (The value of the <code>"messageId"</code> in the update request <code>"Detector"</code> object.)</p>', 'Message$messageId' => '<p>The ID to assign to the message. Within each batch sent, each <code>"messageId"</code> must be unique.</p>', 'UpdateDetectorRequest$messageId' => '<p>The ID to assign to the detector update <code>"message"</code>. Each <code>"messageId"</code> must be unique within each batch sent.</p>', ], ], 'Messages' => [ 'base' => NULL, 'refs' => [ 'BatchPutMessageRequest$messages' => '<p>The list of messages to send. Each message has the following format: <code>\'{ "messageId": "string", "inputName": "string", "payload": "string"}\'</code> </p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListDetectorsRequest$nextToken' => '<p>The token for the next set of results.</p>', 'ListDetectorsResponse$nextToken' => '<p>A token to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>', ], ], 'Payload' => [ 'base' => NULL, 'refs' => [ 'Message$payload' => '<p>The payload of the message. This can be a JSON string or a Base-64-encoded string representing binary data (in which case you must decode it).</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource was not found.</p>', 'refs' => [], ], 'Seconds' => [ 'base' => NULL, 'refs' => [ 'TimerDefinition$seconds' => '<p>The new setting of the timer (the number of seconds before the timer elapses).</p>', ], ], 'ServiceUnavailableException' => [ 'base' => '<p>The service is currently unavailable.</p>', 'refs' => [], ], 'StateName' => [ 'base' => NULL, 'refs' => [ 'DetectorState$stateName' => '<p>The name of the state.</p>', 'DetectorStateDefinition$stateName' => '<p>The name of the new state of the detector (instance).</p>', 'DetectorStateSummary$stateName' => '<p>The name of the state.</p>', 'ListDetectorsRequest$stateName' => '<p>A filter that limits results to those detectors (instances) in the given state.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request could not be completed due to throttling.</p>', 'refs' => [], ], 'Timer' => [ 'base' => '<p>The current state of a timer.</p>', 'refs' => [ 'Timers$member' => NULL, ], ], 'TimerDefinition' => [ 'base' => '<p>The new setting of a timer.</p>', 'refs' => [ 'TimerDefinitions$member' => NULL, ], ], 'TimerDefinitions' => [ 'base' => NULL, 'refs' => [ 'DetectorStateDefinition$timers' => '<p>The new values of the detector\'s timers. Any timer whose value isn\'t specified is cleared, and its timeout event won\'t occur.</p>', ], ], 'TimerName' => [ 'base' => NULL, 'refs' => [ 'Timer$name' => '<p>The name of the timer.</p>', 'TimerDefinition$name' => '<p>The name of the timer.</p>', ], ], 'Timers' => [ 'base' => NULL, 'refs' => [ 'DetectorState$timers' => '<p>The current state of the detector\'s timers.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'Detector$creationTime' => '<p>The time the detector (instance) was created.</p>', 'Detector$lastUpdateTime' => '<p>The time the detector (instance) was last updated.</p>', 'DetectorSummary$creationTime' => '<p>The time the detector (instance) was created.</p>', 'DetectorSummary$lastUpdateTime' => '<p>The time the detector (instance) was last updated.</p>', 'Timer$timestamp' => '<p>The number of seconds which have elapsed on the timer.</p>', ], ], 'UpdateDetectorRequest' => [ 'base' => '<p>Information used to update the detector (instance).</p>', 'refs' => [ 'UpdateDetectorRequests$member' => NULL, ], ], 'UpdateDetectorRequests' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateDetectorRequest$detectors' => '<p>The list of detectors (instances) to update, along with the values to update.</p>', ], ], 'Variable' => [ 'base' => '<p>The current state of the variable.</p>', 'refs' => [ 'Variables$member' => NULL, ], ], 'VariableDefinition' => [ 'base' => '<p>The new value of the variable.</p>', 'refs' => [ 'VariableDefinitions$member' => NULL, ], ], 'VariableDefinitions' => [ 'base' => NULL, 'refs' => [ 'DetectorStateDefinition$variables' => '<p>The new values of the detector\'s variables. Any variable whose value isn\'t specified is cleared.</p>', ], ], 'VariableName' => [ 'base' => NULL, 'refs' => [ 'Variable$name' => '<p>The name of the variable.</p>', 'VariableDefinition$name' => '<p>The name of the variable.</p>', ], ], 'VariableValue' => [ 'base' => NULL, 'refs' => [ 'Variable$value' => '<p>The current value of the variable.</p>', 'VariableDefinition$value' => '<p>The new value of the variable.</p>', ], ], 'Variables' => [ 'base' => NULL, 'refs' => [ 'DetectorState$variables' => '<p>The current values of the detector\'s variables.</p>', ], ], 'errorMessage' => [ 'base' => NULL, 'refs' => [ 'InternalFailureException$message' => '<p>The message for the exception.</p>', 'InvalidRequestException$message' => '<p>The message for the exception.</p>', 'ResourceNotFoundException$message' => '<p>The message for the exception.</p>', 'ServiceUnavailableException$message' => '<p>The message for the exception.</p>', 'ThrottlingException$message' => '<p>The message for the exception.</p>', ], ], ],];
