<?php
// This file was auto-generated from sdk-root/src/data/iotanalytics/2017-11-27/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>AWS IoT Analytics allows you to collect large amounts of device data, process messages, and store them. You can then query the data and run sophisticated analytics on it. AWS IoT Analytics enables advanced data exploration through integration with Jupyter Notebooks and data visualization through integration with Amazon QuickSight.</p> <p>Traditional analytics and business intelligence tools are designed to process structured data. IoT data often comes from devices that record noisy processes (such as temperature, motion, or sound). As a result the data from these devices can have significant gaps, corrupted messages, and false readings that must be cleaned up before analysis can occur. Also, IoT data is often only meaningful in the context of other data from external sources. </p> <p>AWS IoT Analytics automates the steps required to analyze data from IoT devices. AWS IoT Analytics filters, transforms, and enriches IoT data before storing it in a time-series data store for analysis. You can set up the service to collect only the data you need from your devices, apply mathematical transforms to process the data, and enrich the data with device-specific metadata such as device type and location before storing it. Then, you can analyze your data by running queries using the built-in SQL query engine, or perform more complex analytics and machine learning inference. AWS IoT Analytics includes pre-built models for common IoT use cases so you can answer questions like which devices are about to fail or which customers are at risk of abandoning their wearable devices.</p>', 'operations' => [ 'BatchPutMessage' => '<p>Sends messages to a channel.</p>', 'CancelPipelineReprocessing' => '<p>Cancels the reprocessing of data through the pipeline.</p>', 'CreateChannel' => '<p>Creates a channel. A channel collects data from an MQTT topic and archives the raw, unprocessed messages before publishing the data to a pipeline.</p>', 'CreateDataset' => '<p>Creates a data set. A data set stores data retrieved from a data store by applying a "queryAction" (a SQL query) or a "containerAction" (executing a containerized application). This operation creates the skeleton of a data set. The data set can be populated manually by calling "CreateDatasetContent" or automatically according to a "trigger" you specify.</p>', 'CreateDatasetContent' => '<p>Creates the content of a data set by applying a "queryAction" (a SQL query) or a "containerAction" (executing a containerized application).</p>', 'CreateDatastore' => '<p>Creates a data store, which is a repository for messages.</p>', 'CreatePipeline' => '<p>Creates a pipeline. A pipeline consumes messages from a channel and allows you to process the messages before storing them in a data store. You must specify both a <code>channel</code> and a <code>datastore</code> activity and, optionally, as many as 23 additional activities in the <code>pipelineActivities</code> array.</p>', 'DeleteChannel' => '<p>Deletes the specified channel.</p>', 'DeleteDataset' => '<p>Deletes the specified data set.</p> <p>You do not have to delete the content of the data set before you perform this operation.</p>', 'DeleteDatasetContent' => '<p>Deletes the content of the specified data set.</p>', 'DeleteDatastore' => '<p>Deletes the specified data store.</p>', 'DeletePipeline' => '<p>Deletes the specified pipeline.</p>', 'DescribeChannel' => '<p>Retrieves information about a channel.</p>', 'DescribeDataset' => '<p>Retrieves information about a data set.</p>', 'DescribeDatastore' => '<p>Retrieves information about a data store.</p>', 'DescribeLoggingOptions' => '<p>Retrieves the current settings of the AWS IoT Analytics logging options.</p>', 'DescribePipeline' => '<p>Retrieves information about a pipeline.</p>', 'GetDatasetContent' => '<p>Retrieves the contents of a data set as pre-signed URIs.</p>', 'ListChannels' => '<p>Retrieves a list of channels.</p>', 'ListDatasetContents' => '<p>Lists information about data set contents that have been created.</p>', 'ListDatasets' => '<p>Retrieves information about data sets.</p>', 'ListDatastores' => '<p>Retrieves a list of data stores.</p>', 'ListPipelines' => '<p>Retrieves a list of pipelines.</p>', 'ListTagsForResource' => '<p>Lists the tags (metadata) which you have assigned to the resource.</p>', 'PutLoggingOptions' => '<p>Sets or updates the AWS IoT Analytics logging options.</p> <p>Note that if you update the value of any <code>loggingOptions</code> field, it takes up to one minute for the change to take effect. Also, if you change the policy attached to the role you specified in the roleArn field (for example, to correct an invalid policy) it takes up to 5 minutes for that change to take effect. </p>', 'RunPipelineActivity' => '<p>Simulates the results of running a pipeline activity on a message payload.</p>', 'SampleChannelData' => '<p>Retrieves a sample of messages from the specified channel ingested during the specified timeframe. Up to 10 messages can be retrieved.</p>', 'StartPipelineReprocessing' => '<p>Starts the reprocessing of raw message data through the pipeline.</p>', 'TagResource' => '<p>Adds to or modifies the tags of the given resource. Tags are metadata which can be used to manage a resource.</p>', 'UntagResource' => '<p>Removes the given tags (metadata) from the resource.</p>', 'UpdateChannel' => '<p>Updates the settings of a channel.</p>', 'UpdateDataset' => '<p>Updates the settings of a data set.</p>', 'UpdateDatastore' => '<p>Updates the settings of a data store.</p>', 'UpdatePipeline' => '<p>Updates the settings of a pipeline. You must specify both a <code>channel</code> and a <code>datastore</code> activity and, optionally, as many as 23 additional activities in the <code>pipelineActivities</code> array.</p>', ], 'shapes' => [ 'ActivityBatchSize' => [ 'base' => NULL, 'refs' => [ 'LambdaActivity$batchSize' => '<p>The number of messages passed to the Lambda function for processing.</p> <p>The AWS Lambda function must be able to process all of these messages within five minutes, which is the maximum timeout duration for Lambda functions.</p>', ], ], 'ActivityName' => [ 'base' => NULL, 'refs' => [ 'AddAttributesActivity$name' => '<p>The name of the \'addAttributes\' activity.</p>', 'AddAttributesActivity$next' => '<p>The next activity in the pipeline.</p>', 'ChannelActivity$name' => '<p>The name of the \'channel\' activity.</p>', 'ChannelActivity$next' => '<p>The next activity in the pipeline.</p>', 'DatastoreActivity$name' => '<p>The name of the \'datastore\' activity.</p>', 'DeviceRegistryEnrichActivity$name' => '<p>The name of the \'deviceRegistryEnrich\' activity.</p>', 'DeviceRegistryEnrichActivity$next' => '<p>The next activity in the pipeline.</p>', 'DeviceShadowEnrichActivity$name' => '<p>The name of the \'deviceShadowEnrich\' activity.</p>', 'DeviceShadowEnrichActivity$next' => '<p>The next activity in the pipeline.</p>', 'FilterActivity$name' => '<p>The name of the \'filter\' activity.</p>', 'FilterActivity$next' => '<p>The next activity in the pipeline.</p>', 'LambdaActivity$name' => '<p>The name of the \'lambda\' activity.</p>', 'LambdaActivity$next' => '<p>The next activity in the pipeline.</p>', 'MathActivity$name' => '<p>The name of the \'math\' activity.</p>', 'MathActivity$next' => '<p>The next activity in the pipeline.</p>', 'RemoveAttributesActivity$name' => '<p>The name of the \'removeAttributes\' activity.</p>', 'RemoveAttributesActivity$next' => '<p>The next activity in the pipeline.</p>', 'SelectAttributesActivity$name' => '<p>The name of the \'selectAttributes\' activity.</p>', 'SelectAttributesActivity$next' => '<p>The next activity in the pipeline.</p>', ], ], 'AddAttributesActivity' => [ 'base' => '<p>An activity that adds other attributes based on existing attributes in the message.</p>', 'refs' => [ 'PipelineActivity$addAttributes' => '<p>Adds other attributes based on existing attributes in the message.</p>', ], ], 'AttributeName' => [ 'base' => NULL, 'refs' => [ 'AttributeNameMapping$key' => NULL, 'AttributeNameMapping$value' => NULL, 'AttributeNames$member' => NULL, 'DeviceRegistryEnrichActivity$attribute' => '<p>The name of the attribute that is added to the message.</p>', 'DeviceRegistryEnrichActivity$thingName' => '<p>The name of the IoT device whose registry information is added to the message.</p>', 'DeviceShadowEnrichActivity$attribute' => '<p>The name of the attribute that is added to the message.</p>', 'DeviceShadowEnrichActivity$thingName' => '<p>The name of the IoT device whose shadow information is added to the message.</p>', 'MathActivity$attribute' => '<p>The name of the attribute that contains the result of the math operation.</p>', ], ], 'AttributeNameMapping' => [ 'base' => NULL, 'refs' => [ 'AddAttributesActivity$attributes' => '<p>A list of 1-50 "AttributeNameMapping" objects that map an existing attribute to a new attribute.</p> <note> <p>The existing attributes remain in the message, so if you want to remove the originals, use "RemoveAttributeActivity".</p> </note>', ], ], 'AttributeNames' => [ 'base' => NULL, 'refs' => [ 'RemoveAttributesActivity$attributes' => '<p>A list of 1-50 attributes to remove from the message.</p>', 'SelectAttributesActivity$attributes' => '<p>A list of the attributes to select from the message.</p>', ], ], 'BatchPutMessageErrorEntries' => [ 'base' => NULL, 'refs' => [ 'BatchPutMessageResponse$batchPutMessageErrorEntries' => '<p>A list of any errors encountered when sending the messages to the channel.</p>', ], ], 'BatchPutMessageErrorEntry' => [ 'base' => '<p>Contains informations about errors.</p>', 'refs' => [ 'BatchPutMessageErrorEntries$member' => NULL, ], ], 'BatchPutMessageRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchPutMessageResponse' => [ 'base' => NULL, 'refs' => [], ], 'BucketKeyExpression' => [ 'base' => NULL, 'refs' => [ 'S3DestinationConfiguration$key' => '<p>The key of the data set contents object. Each object in an Amazon S3 bucket has a key that is its unique identifier within the bucket (each object in a bucket has exactly one key). To produce a unique key, you can use "!{iotanalytics:scheduledTime}" to insert the time of the scheduled SQL query run, or "!{iotanalytics:versioned} to insert a unique hash identifying the data set, for example: "/DataSet/!{iotanalytics:scheduledTime}/!{iotanalytics:versioned}.csv".</p>', ], ], 'BucketName' => [ 'base' => NULL, 'refs' => [ 'CustomerManagedChannelS3Storage$bucket' => '<p>The name of the Amazon S3 bucket in which channel data is stored.</p>', 'CustomerManagedChannelS3StorageSummary$bucket' => '<p>The name of the Amazon S3 bucket in which channel data is stored.</p>', 'CustomerManagedDatastoreS3Storage$bucket' => '<p>The name of the Amazon S3 bucket in which data store data is stored.</p>', 'CustomerManagedDatastoreS3StorageSummary$bucket' => '<p>The name of the Amazon S3 bucket in which data store data is stored.</p>', 'S3DestinationConfiguration$bucket' => '<p>The name of the Amazon S3 bucket to which data set contents are delivered.</p>', ], ], 'CancelPipelineReprocessingRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelPipelineReprocessingResponse' => [ 'base' => NULL, 'refs' => [], ], 'Channel' => [ 'base' => '<p>A collection of data from an MQTT topic. Channels archive the raw, unprocessed messages before publishing the data to a pipeline.</p>', 'refs' => [ 'DescribeChannelResponse$channel' => '<p>An object that contains information about the channel.</p>', ], ], 'ChannelActivity' => [ 'base' => '<p>The activity that determines the source of the messages to be processed.</p>', 'refs' => [ 'PipelineActivity$channel' => '<p>Determines the source of the messages to be processed.</p>', ], ], 'ChannelArn' => [ 'base' => NULL, 'refs' => [ 'Channel$arn' => '<p>The ARN of the channel.</p>', 'CreateChannelResponse$channelArn' => '<p>The ARN of the channel.</p>', ], ], 'ChannelName' => [ 'base' => NULL, 'refs' => [ 'BatchPutMessageRequest$channelName' => '<p>The name of the channel where the messages are sent.</p>', 'Channel$name' => '<p>The name of the channel.</p>', 'ChannelActivity$channelName' => '<p>The name of the channel from which the messages are processed.</p>', 'ChannelSummary$channelName' => '<p>The name of the channel.</p>', 'CreateChannelRequest$channelName' => '<p>The name of the channel.</p>', 'CreateChannelResponse$channelName' => '<p>The name of the channel.</p>', 'DeleteChannelRequest$channelName' => '<p>The name of the channel to delete.</p>', 'DescribeChannelRequest$channelName' => '<p>The name of the channel whose information is retrieved.</p>', 'SampleChannelDataRequest$channelName' => '<p>The name of the channel whose message samples are retrieved.</p>', 'UpdateChannelRequest$channelName' => '<p>The name of the channel to be updated.</p>', ], ], 'ChannelStatistics' => [ 'base' => '<p>Statistics information about the channel.</p>', 'refs' => [ 'DescribeChannelResponse$statistics' => '<p>Statistics about the channel. Included if the \'includeStatistics\' parameter is set to true in the request.</p>', ], ], 'ChannelStatus' => [ 'base' => NULL, 'refs' => [ 'Channel$status' => '<p>The status of the channel.</p>', 'ChannelSummary$status' => '<p>The status of the channel.</p>', ], ], 'ChannelStorage' => [ 'base' => '<p>Where channel data is stored. You may choose one of "serviceManagedS3" or "customerManagedS3" storage. If not specified, the default is "serviceManagedS3". This cannot be changed after creation of the channel.</p>', 'refs' => [ 'Channel$storage' => '<p>Where channel data is stored. You may choose one of "serviceManagedS3" or "customerManagedS3" storage. If not specified, the default is "serviceManagedS3". This cannot be changed after creation of the channel.</p>', 'CreateChannelRequest$channelStorage' => '<p>Where channel data is stored. You may choose one of "serviceManagedS3" or "customerManagedS3" storage. If not specified, the default is "serviceManagedS3". This cannot be changed after creation of the channel.</p>', 'UpdateChannelRequest$channelStorage' => '<p>Where channel data is stored. You may choose one of "serviceManagedS3" or "customerManagedS3" storage. If not specified, the default is "serviceManagedS3". This cannot be changed after creation of the channel.</p>', ], ], 'ChannelStorageSummary' => [ 'base' => '<p>Where channel data is stored.</p>', 'refs' => [ 'ChannelSummary$channelStorage' => '<p>Where channel data is stored.</p>', ], ], 'ChannelSummaries' => [ 'base' => NULL, 'refs' => [ 'ListChannelsResponse$channelSummaries' => '<p>A list of "ChannelSummary" objects.</p>', ], ], 'ChannelSummary' => [ 'base' => '<p>A summary of information about a channel.</p>', 'refs' => [ 'ChannelSummaries$member' => NULL, ], ], 'ComputeType' => [ 'base' => NULL, 'refs' => [ 'ResourceConfiguration$computeType' => '<p>The type of the compute resource used to execute the "containerAction". Possible values are: ACU_1 (vCPU=4, memory=16GiB) or ACU_2 (vCPU=8, memory=32GiB).</p>', ], ], 'ContainerDatasetAction' => [ 'base' => '<p>Information needed to run the "containerAction" to produce data set contents.</p>', 'refs' => [ 'DatasetAction$containerAction' => '<p>Information which allows the system to run a containerized application in order to create the data set contents. The application must be in a Docker container along with any needed support libraries.</p>', ], ], 'CreateChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatasetContentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatasetContentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatasetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatasetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatastoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatastoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePipelineRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePipelineResponse' => [ 'base' => NULL, 'refs' => [], ], 'CustomerManagedChannelS3Storage' => [ 'base' => '<p>Use this to store channel data in an S3 bucket that you manage. If customer managed storage is selected, the "retentionPeriod" parameter is ignored. The choice of service-managed or customer-managed S3 storage cannot be changed after creation of the channel.</p>', 'refs' => [ 'ChannelStorage$customerManagedS3' => '<p>Use this to store channel data in an S3 bucket that you manage. If customer managed storage is selected, the "retentionPeriod" parameter is ignored. The choice of service-managed or customer-managed S3 storage cannot be changed after creation of the channel.</p>', ], ], 'CustomerManagedChannelS3StorageSummary' => [ 'base' => '<p>Used to store channel data in an S3 bucket that you manage.</p>', 'refs' => [ 'ChannelStorageSummary$customerManagedS3' => '<p>Used to store channel data in an S3 bucket that you manage.</p>', ], ], 'CustomerManagedDatastoreS3Storage' => [ 'base' => '<p>Use this to store data store data in an S3 bucket that you manage. When customer managed storage is selected, the "retentionPeriod" parameter is ignored. The choice of service-managed or customer-managed S3 storage cannot be changed after creation of the data store.</p>', 'refs' => [ 'DatastoreStorage$customerManagedS3' => '<p>Use this to store data store data in an S3 bucket that you manage. When customer managed storage is selected, the "retentionPeriod" parameter is ignored. The choice of service-managed or customer-managed S3 storage cannot be changed after creation of the data store.</p>', ], ], 'CustomerManagedDatastoreS3StorageSummary' => [ 'base' => '<p>Used to store data store data in an S3 bucket that you manage.</p>', 'refs' => [ 'DatastoreStorageSummary$customerManagedS3' => '<p>Used to store data store data in an S3 bucket that you manage.</p>', ], ], 'Dataset' => [ 'base' => '<p>Information about a data set.</p>', 'refs' => [ 'DescribeDatasetResponse$dataset' => '<p>An object that contains information about the data set.</p>', ], ], 'DatasetAction' => [ 'base' => '<p>A "DatasetAction" object that specifies how data set contents are automatically created.</p>', 'refs' => [ 'DatasetActions$member' => NULL, ], ], 'DatasetActionName' => [ 'base' => NULL, 'refs' => [ 'DatasetAction$actionName' => '<p>The name of the data set action by which data set contents are automatically created.</p>', 'DatasetActionSummary$actionName' => '<p>The name of the action which automatically creates the data set\'s contents.</p>', ], ], 'DatasetActionSummaries' => [ 'base' => NULL, 'refs' => [ 'DatasetSummary$actions' => '<p>A list of "DataActionSummary" objects.</p>', ], ], 'DatasetActionSummary' => [ 'base' => '<p>Information about the action which automatically creates the data set\'s contents.</p>', 'refs' => [ 'DatasetActionSummaries$member' => NULL, ], ], 'DatasetActionType' => [ 'base' => NULL, 'refs' => [ 'DatasetActionSummary$actionType' => '<p>The type of action by which the data set\'s contents are automatically created.</p>', ], ], 'DatasetActions' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetRequest$actions' => '<p>A list of actions that create the data set contents.</p>', 'Dataset$actions' => '<p>The "DatasetAction" objects that automatically create the data set contents.</p>', 'UpdateDatasetRequest$actions' => '<p>A list of "DatasetAction" objects.</p>', ], ], 'DatasetArn' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetResponse$datasetArn' => '<p>The ARN of the data set.</p>', 'Dataset$arn' => '<p>The ARN of the data set.</p>', ], ], 'DatasetContentDeliveryDestination' => [ 'base' => '<p>The destination to which data set contents are delivered.</p>', 'refs' => [ 'DatasetContentDeliveryRule$destination' => '<p>The destination to which data set contents are delivered.</p>', ], ], 'DatasetContentDeliveryRule' => [ 'base' => '<p>When data set contents are created they are delivered to destination specified here.</p>', 'refs' => [ 'DatasetContentDeliveryRules$member' => NULL, ], ], 'DatasetContentDeliveryRules' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetRequest$contentDeliveryRules' => '<p>When data set contents are created they are delivered to destinations specified here.</p>', 'Dataset$contentDeliveryRules' => '<p>When data set contents are created they are delivered to destinations specified here.</p>', 'UpdateDatasetRequest$contentDeliveryRules' => '<p>When data set contents are created they are delivered to destinations specified here.</p>', ], ], 'DatasetContentState' => [ 'base' => NULL, 'refs' => [ 'DatasetContentStatus$state' => '<p>The state of the data set contents. Can be one of "READY", "CREATING", "SUCCEEDED" or "FAILED".</p>', ], ], 'DatasetContentStatus' => [ 'base' => '<p>The state of the data set contents and the reason they are in this state.</p>', 'refs' => [ 'DatasetContentSummary$status' => '<p>The status of the data set contents.</p>', 'GetDatasetContentResponse$status' => '<p>The status of the data set content.</p>', ], ], 'DatasetContentSummaries' => [ 'base' => NULL, 'refs' => [ 'ListDatasetContentsResponse$datasetContentSummaries' => '<p>Summary information about data set contents that have been created.</p>', ], ], 'DatasetContentSummary' => [ 'base' => '<p>Summary information about data set contents.</p>', 'refs' => [ 'DatasetContentSummaries$member' => NULL, ], ], 'DatasetContentVersion' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetContentResponse$versionId' => '<p>The version ID of the data set contents which are being created.</p>', 'DatasetContentSummary$version' => '<p>The version of the data set contents.</p>', 'DeleteDatasetContentRequest$versionId' => '<p>The version of the data set whose content is deleted. You can also use the strings "$LATEST" or "$LATEST_SUCCEEDED" to delete the latest or latest successfully completed data set. If not specified, "$LATEST_SUCCEEDED" is the default.</p>', 'GetDatasetContentRequest$versionId' => '<p>The version of the data set whose contents are retrieved. You can also use the strings "$LATEST" or "$LATEST_SUCCEEDED" to retrieve the contents of the latest or latest successfully completed data set. If not specified, "$LATEST_SUCCEEDED" is the default.</p>', ], ], 'DatasetContentVersionValue' => [ 'base' => '<p>The data set whose latest contents are used as input to the notebook or application.</p>', 'refs' => [ 'Variable$datasetContentVersionValue' => '<p>The value of the variable as a structure that specifies a data set content version.</p>', ], ], 'DatasetEntries' => [ 'base' => NULL, 'refs' => [ 'GetDatasetContentResponse$entries' => '<p>A list of "DatasetEntry" objects.</p>', ], ], 'DatasetEntry' => [ 'base' => '<p>The reference to a data set entry.</p>', 'refs' => [ 'DatasetEntries$member' => NULL, ], ], 'DatasetName' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetContentRequest$datasetName' => '<p>The name of the data set.</p>', 'CreateDatasetRequest$datasetName' => '<p>The name of the data set.</p>', 'CreateDatasetResponse$datasetName' => '<p>The name of the data set.</p>', 'Dataset$name' => '<p>The name of the data set.</p>', 'DatasetContentVersionValue$datasetName' => '<p>The name of the data set whose latest contents are used as input to the notebook or application.</p>', 'DatasetSummary$datasetName' => '<p>The name of the data set.</p>', 'DeleteDatasetContentRequest$datasetName' => '<p>The name of the data set whose content is deleted.</p>', 'DeleteDatasetRequest$datasetName' => '<p>The name of the data set to delete.</p>', 'DescribeDatasetRequest$datasetName' => '<p>The name of the data set whose information is retrieved.</p>', 'GetDatasetContentRequest$datasetName' => '<p>The name of the data set whose contents are retrieved.</p>', 'ListDatasetContentsRequest$datasetName' => '<p>The name of the data set whose contents information you want to list.</p>', 'TriggeringDataset$name' => '<p>The name of the data set whose content generation triggers the new data set content generation.</p>', 'UpdateDatasetRequest$datasetName' => '<p>The name of the data set to update.</p>', ], ], 'DatasetStatus' => [ 'base' => NULL, 'refs' => [ 'Dataset$status' => '<p>The status of the data set.</p>', 'DatasetSummary$status' => '<p>The status of the data set.</p>', ], ], 'DatasetSummaries' => [ 'base' => NULL, 'refs' => [ 'ListDatasetsResponse$datasetSummaries' => '<p>A list of "DatasetSummary" objects.</p>', ], ], 'DatasetSummary' => [ 'base' => '<p>A summary of information about a data set.</p>', 'refs' => [ 'DatasetSummaries$member' => NULL, ], ], 'DatasetTrigger' => [ 'base' => '<p>The "DatasetTrigger" that specifies when the data set is automatically updated.</p>', 'refs' => [ 'DatasetTriggers$member' => NULL, ], ], 'DatasetTriggers' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetRequest$triggers' => '<p>A list of triggers. A trigger causes data set contents to be populated at a specified time interval or when another data set\'s contents are created. The list of triggers can be empty or contain up to five <b>DataSetTrigger</b> objects.</p>', 'Dataset$triggers' => '<p>The "DatasetTrigger" objects that specify when the data set is automatically updated.</p>', 'DatasetSummary$triggers' => '<p>A list of triggers. A trigger causes data set content to be populated at a specified time interval or when another data set is populated. The list of triggers can be empty or contain up to five DataSetTrigger objects</p>', 'UpdateDatasetRequest$triggers' => '<p>A list of "DatasetTrigger" objects. The list can be empty or can contain up to five <b>DataSetTrigger</b> objects.</p>', ], ], 'Datastore' => [ 'base' => '<p>Information about a data store.</p>', 'refs' => [ 'DescribeDatastoreResponse$datastore' => '<p>Information about the data store.</p>', ], ], 'DatastoreActivity' => [ 'base' => '<p>The \'datastore\' activity that specifies where to store the processed data.</p>', 'refs' => [ 'PipelineActivity$datastore' => '<p>Specifies where to store the processed message data.</p>', ], ], 'DatastoreArn' => [ 'base' => NULL, 'refs' => [ 'CreateDatastoreResponse$datastoreArn' => '<p>The ARN of the data store.</p>', 'Datastore$arn' => '<p>The ARN of the data store.</p>', ], ], 'DatastoreName' => [ 'base' => NULL, 'refs' => [ 'CreateDatastoreRequest$datastoreName' => '<p>The name of the data store.</p>', 'CreateDatastoreResponse$datastoreName' => '<p>The name of the data store.</p>', 'Datastore$name' => '<p>The name of the data store.</p>', 'DatastoreActivity$datastoreName' => '<p>The name of the data store where processed messages are stored.</p>', 'DatastoreSummary$datastoreName' => '<p>The name of the data store.</p>', 'DeleteDatastoreRequest$datastoreName' => '<p>The name of the data store to delete.</p>', 'DescribeDatastoreRequest$datastoreName' => '<p>The name of the data store</p>', 'UpdateDatastoreRequest$datastoreName' => '<p>The name of the data store to be updated.</p>', ], ], 'DatastoreStatistics' => [ 'base' => '<p>Statistical information about the data store.</p>', 'refs' => [ 'DescribeDatastoreResponse$statistics' => '<p>Additional statistical information about the data store. Included if the \'includeStatistics\' parameter is set to true in the request.</p>', ], ], 'DatastoreStatus' => [ 'base' => NULL, 'refs' => [ 'Datastore$status' => '<p>The status of a data store:</p> <dl> <dt>CREATING</dt> <dd> <p>The data store is being created.</p> </dd> <dt>ACTIVE</dt> <dd> <p>The data store has been created and can be used.</p> </dd> <dt>DELETING</dt> <dd> <p>The data store is being deleted.</p> </dd> </dl>', 'DatastoreSummary$status' => '<p>The status of the data store.</p>', ], ], 'DatastoreStorage' => [ 'base' => '<p>Where data store data is stored. You may choose one of "serviceManagedS3" or "customerManagedS3" storage. If not specified, the default is "serviceManagedS3". This cannot be changed after the data store is created.</p>', 'refs' => [ 'CreateDatastoreRequest$datastoreStorage' => '<p>Where data store data is stored. You may choose one of "serviceManagedS3" or "customerManagedS3" storage. If not specified, the default is "serviceManagedS3". This cannot be changed after the data store is created.</p>', 'Datastore$storage' => '<p>Where data store data is stored. You may choose one of "serviceManagedS3" or "customerManagedS3" storage. If not specified, the default is "serviceManagedS3". This cannot be changed after the data store is created.</p>', 'UpdateDatastoreRequest$datastoreStorage' => '<p>Where data store data is stored. You may choose one of "serviceManagedS3" or "customerManagedS3" storage. If not specified, the default is "serviceManagedS3". This cannot be changed after the data store is created.</p>', ], ], 'DatastoreStorageSummary' => [ 'base' => '<p>Where data store data is stored.</p>', 'refs' => [ 'DatastoreSummary$datastoreStorage' => '<p>Where data store data is stored.</p>', ], ], 'DatastoreSummaries' => [ 'base' => NULL, 'refs' => [ 'ListDatastoresResponse$datastoreSummaries' => '<p>A list of "DatastoreSummary" objects.</p>', ], ], 'DatastoreSummary' => [ 'base' => '<p>A summary of information about a data store.</p>', 'refs' => [ 'DatastoreSummaries$member' => NULL, ], ], 'DeleteChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDatasetContentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDatasetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDatastoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePipelineRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeltaTime' => [ 'base' => '<p>Used to limit data to that which has arrived since the last execution of the action.</p>', 'refs' => [ 'QueryFilter$deltaTime' => '<p>Used to limit data to that which has arrived since the last execution of the action.</p>', ], ], 'DescribeChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatasetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatasetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatastoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatastoreResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLoggingOptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLoggingOptionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePipelineRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePipelineResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeviceRegistryEnrichActivity' => [ 'base' => '<p>An activity that adds data from the AWS IoT device registry to your message.</p>', 'refs' => [ 'PipelineActivity$deviceRegistryEnrich' => '<p>Adds data from the AWS IoT device registry to your message.</p>', ], ], 'DeviceShadowEnrichActivity' => [ 'base' => '<p>An activity that adds information from the AWS IoT Device Shadows service to a message.</p>', 'refs' => [ 'PipelineActivity$deviceShadowEnrich' => '<p>Adds information from the AWS IoT Device Shadows service to a message.</p>', ], ], 'DoubleValue' => [ 'base' => NULL, 'refs' => [ 'Variable$doubleValue' => '<p>The value of the variable as a double (numeric).</p>', ], ], 'EndTime' => [ 'base' => NULL, 'refs' => [ 'SampleChannelDataRequest$endTime' => '<p>The end of the time window from which sample messages are retrieved.</p>', 'StartPipelineReprocessingRequest$endTime' => '<p>The end time (exclusive) of raw message data that is reprocessed.</p>', ], ], 'EntryName' => [ 'base' => NULL, 'refs' => [ 'DatasetContentDeliveryRule$entryName' => '<p>The name of the data set content delivery rules entry.</p>', 'DatasetEntry$entryName' => '<p>The name of the data set item.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'BatchPutMessageErrorEntry$errorCode' => '<p>The code associated with the error.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'BatchPutMessageErrorEntry$errorMessage' => '<p>The message associated with the error.</p>', ], ], 'EstimatedResourceSize' => [ 'base' => '<p>The estimated size of the resource.</p>', 'refs' => [ 'ChannelStatistics$size' => '<p>The estimated size of the channel.</p>', 'DatastoreStatistics$size' => '<p>The estimated size of the data store.</p>', ], ], 'FilterActivity' => [ 'base' => '<p>An activity that filters a message based on its attributes.</p>', 'refs' => [ 'PipelineActivity$filter' => '<p>Filters a message based on its attributes.</p>', ], ], 'FilterExpression' => [ 'base' => NULL, 'refs' => [ 'FilterActivity$filter' => '<p>An expression that looks like a SQL WHERE clause that must return a Boolean value.</p>', ], ], 'GetDatasetContentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDatasetContentResponse' => [ 'base' => NULL, 'refs' => [], ], 'GlueConfiguration' => [ 'base' => '<p>Configuration information for coordination with the AWS Glue ETL (extract, transform and load) service.</p>', 'refs' => [ 'S3DestinationConfiguration$glueConfiguration' => '<p>Configuration information for coordination with the AWS Glue ETL (extract, transform and load) service.</p>', ], ], 'GlueDatabaseName' => [ 'base' => NULL, 'refs' => [ 'GlueConfiguration$databaseName' => '<p>The name of the database in your AWS Glue Data Catalog in which the table is located. (An AWS Glue Data Catalog database contains Glue Data tables.)</p>', ], ], 'GlueTableName' => [ 'base' => NULL, 'refs' => [ 'GlueConfiguration$tableName' => '<p>The name of the table in your AWS Glue Data Catalog which is used to perform the ETL (extract, transform and load) operations. (An AWS Glue Data Catalog table contains partitioned data and descriptions of data sources and targets.)</p>', ], ], 'Image' => [ 'base' => NULL, 'refs' => [ 'ContainerDatasetAction$image' => '<p>The ARN of the Docker container stored in your account. The Docker container contains an application and needed support libraries and is used to generate data set contents.</p>', ], ], 'IncludeStatisticsFlag' => [ 'base' => NULL, 'refs' => [ 'DescribeChannelRequest$includeStatistics' => '<p>If true, additional statistical information about the channel is included in the response. This feature cannot be used with a channel whose S3 storage is customer-managed.</p>', 'DescribeDatastoreRequest$includeStatistics' => '<p>If true, additional statistical information about the data store is included in the response. This feature cannot be used with a data store whose S3 storage is customer-managed.</p>', ], ], 'InternalFailureException' => [ 'base' => '<p>There was an internal failure.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>The request was not valid.</p>', 'refs' => [], ], 'IotEventsDestinationConfiguration' => [ 'base' => '<p>Configuration information for delivery of data set contents to AWS IoT Events.</p>', 'refs' => [ 'DatasetContentDeliveryDestination$iotEventsDestinationConfiguration' => '<p>Configuration information for delivery of data set contents to AWS IoT Events.</p>', ], ], 'IotEventsInputName' => [ 'base' => NULL, 'refs' => [ 'IotEventsDestinationConfiguration$inputName' => '<p>The name of the AWS IoT Events input to which data set contents are delivered.</p>', ], ], 'LambdaActivity' => [ 'base' => '<p>An activity that runs a Lambda function to modify the message.</p>', 'refs' => [ 'PipelineActivity$lambda' => '<p>Runs a Lambda function to modify the message.</p>', ], ], 'LambdaName' => [ 'base' => NULL, 'refs' => [ 'LambdaActivity$lambdaName' => '<p>The name of the Lambda function that is run on the message.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The command caused an internal limit to be exceeded.</p>', 'refs' => [], ], 'ListChannelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDatasetContentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDatasetContentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDatasetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDatasetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDatastoresRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDatastoresResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPipelinesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPipelinesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogResult' => [ 'base' => NULL, 'refs' => [ 'RunPipelineActivityResponse$logResult' => '<p>In case the pipeline activity fails, the log message that is generated.</p>', ], ], 'LoggingEnabled' => [ 'base' => NULL, 'refs' => [ 'LoggingOptions$enabled' => '<p>If true, logging is enabled for AWS IoT Analytics.</p>', ], ], 'LoggingLevel' => [ 'base' => NULL, 'refs' => [ 'LoggingOptions$level' => '<p>The logging level. Currently, only "ERROR" is supported.</p>', ], ], 'LoggingOptions' => [ 'base' => '<p>Information about logging options.</p>', 'refs' => [ 'DescribeLoggingOptionsResponse$loggingOptions' => '<p>The current settings of the AWS IoT Analytics logging options.</p>', 'PutLoggingOptionsRequest$loggingOptions' => '<p>The new values of the AWS IoT Analytics logging options.</p>', ], ], 'MathActivity' => [ 'base' => '<p>An activity that computes an arithmetic expression using the message\'s attributes.</p>', 'refs' => [ 'PipelineActivity$math' => '<p>Computes an arithmetic expression using the message\'s attributes and adds it to the message.</p>', ], ], 'MathExpression' => [ 'base' => NULL, 'refs' => [ 'MathActivity$math' => '<p>An expression that uses one or more existing attributes and must return an integer value.</p>', ], ], 'MaxMessages' => [ 'base' => NULL, 'refs' => [ 'SampleChannelDataRequest$maxMessages' => '<p>The number of sample messages to be retrieved. The limit is 10, the default is also 10.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListChannelsRequest$maxResults' => '<p>The maximum number of results to return in this request.</p> <p>The default value is 100.</p>', 'ListDatasetContentsRequest$maxResults' => '<p>The maximum number of results to return in this request.</p>', 'ListDatasetsRequest$maxResults' => '<p>The maximum number of results to return in this request.</p> <p>The default value is 100.</p>', 'ListDatastoresRequest$maxResults' => '<p>The maximum number of results to return in this request.</p> <p>The default value is 100.</p>', 'ListPipelinesRequest$maxResults' => '<p>The maximum number of results to return in this request.</p> <p>The default value is 100.</p>', ], ], 'MaxVersions' => [ 'base' => NULL, 'refs' => [ 'VersioningConfiguration$maxVersions' => '<p>How many versions of data set contents will be kept. The "unlimited" parameter must be false.</p>', ], ], 'Message' => [ 'base' => '<p>Information about a message.</p>', 'refs' => [ 'Messages$member' => NULL, ], ], 'MessageId' => [ 'base' => NULL, 'refs' => [ 'BatchPutMessageErrorEntry$messageId' => '<p>The ID of the message that caused the error. (See the value corresponding to the "messageId" key in the message object.)</p>', 'Message$messageId' => '<p>The ID you wish to assign to the message. Each "messageId" must be unique within each batch sent.</p>', ], ], 'MessagePayload' => [ 'base' => NULL, 'refs' => [ 'Message$payload' => '<p>The payload of the message. This may be a JSON string or a Base64-encoded string representing binary data (in which case you must decode it by means of a pipeline activity).</p>', 'MessagePayloads$member' => NULL, ], ], 'MessagePayloads' => [ 'base' => NULL, 'refs' => [ 'RunPipelineActivityRequest$payloads' => '<p>The sample message payloads on which the pipeline activity is run.</p>', 'RunPipelineActivityResponse$payloads' => '<p>The enriched or transformed sample message payloads as base64-encoded strings. (The results of running the pipeline activity on each input sample message payload, encoded in base64.)</p>', 'SampleChannelDataResponse$payloads' => '<p>The list of message samples. Each sample message is returned as a base64-encoded string.</p>', ], ], 'Messages' => [ 'base' => NULL, 'refs' => [ 'BatchPutMessageRequest$messages' => '<p>The list of messages to be sent. Each message has format: \'{ "messageId": "string", "payload": "string"}\'.</p> <p>Note that the field names of message payloads (data) that you send to AWS IoT Analytics:</p> <ul> <li> <p>Must contain only alphanumeric characters and undescores (_); no other special characters are allowed.</p> </li> <li> <p>Must begin with an alphabetic character or single underscore (_).</p> </li> <li> <p>Cannot contain hyphens (-).</p> </li> <li> <p>In regular expression terms: "^[A-Za-z_]([A-Za-z0-9]*|[A-Za-z0-9][A-Za-z0-9_]*)$". </p> </li> <li> <p>Cannot be greater than 255 characters.</p> </li> <li> <p>Are case-insensitive. (Fields named "foo" and "FOO" in the same payload are considered duplicates.)</p> </li> </ul> <p>For example, {"temp_01": 29} or {"_temp_01": 29} are valid, but {"temp-01": 29}, {"01_temp": 29} or {"__temp_01": 29} are invalid in message payloads. </p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListChannelsRequest$nextToken' => '<p>The token for the next set of results.</p>', 'ListChannelsResponse$nextToken' => '<p>The token to retrieve the next set of results, or <code>null</code> if there are no more results.</p>', 'ListDatasetContentsRequest$nextToken' => '<p>The token for the next set of results.</p>', 'ListDatasetContentsResponse$nextToken' => '<p>The token to retrieve the next set of results, or <code>null</code> if there are no more results.</p>', 'ListDatasetsRequest$nextToken' => '<p>The token for the next set of results.</p>', 'ListDatasetsResponse$nextToken' => '<p>The token to retrieve the next set of results, or <code>null</code> if there are no more results.</p>', 'ListDatastoresRequest$nextToken' => '<p>The token for the next set of results.</p>', 'ListDatastoresResponse$nextToken' => '<p>The token to retrieve the next set of results, or <code>null</code> if there are no more results.</p>', 'ListPipelinesRequest$nextToken' => '<p>The token for the next set of results.</p>', 'ListPipelinesResponse$nextToken' => '<p>The token to retrieve the next set of results, or <code>null</code> if there are no more results.</p>', ], ], 'OffsetSeconds' => [ 'base' => NULL, 'refs' => [ 'DeltaTime$offsetSeconds' => '<p>The number of seconds of estimated "in flight" lag time of message data. When you create data set contents using message data from a specified time frame, some message data may still be "in flight" when processing begins, and so will not arrive in time to be processed. Use this field to make allowances for the "in flight" time of your message data, so that data not processed from a previous time frame will be included with the next time frame. Without this, missed message data would be excluded from processing during the next time frame as well, because its timestamp places it within the previous time frame.</p>', ], ], 'OutputFileName' => [ 'base' => NULL, 'refs' => [ 'OutputFileUriValue$fileName' => '<p>The URI of the location where data set contents are stored, usually the URI of a file in an S3 bucket.</p>', ], ], 'OutputFileUriValue' => [ 'base' => '<p>The value of the variable as a structure that specifies an output file URI.</p>', 'refs' => [ 'Variable$outputFileUriValue' => '<p>The value of the variable as a structure that specifies an output file URI.</p>', ], ], 'Pipeline' => [ 'base' => '<p>Contains information about a pipeline.</p>', 'refs' => [ 'DescribePipelineResponse$pipeline' => '<p>A "Pipeline" object that contains information about the pipeline.</p>', ], ], 'PipelineActivities' => [ 'base' => NULL, 'refs' => [ 'CreatePipelineRequest$pipelineActivities' => '<p>A list of "PipelineActivity" objects. Activities perform transformations on your messages, such as removing, renaming or adding message attributes; filtering messages based on attribute values; invoking your Lambda functions on messages for advanced processing; or performing mathematical transformations to normalize device data.</p> <p>The list can be 2-25 <b>PipelineActivity</b> objects and must contain both a <code>channel</code> and a <code>datastore</code> activity. Each entry in the list must contain only one activity, for example:</p> <p> <code>pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ... ]</code> </p>', 'Pipeline$activities' => '<p>The activities that perform transformations on the messages.</p>', 'UpdatePipelineRequest$pipelineActivities' => '<p>A list of "PipelineActivity" objects. Activities perform transformations on your messages, such as removing, renaming or adding message attributes; filtering messages based on attribute values; invoking your Lambda functions on messages for advanced processing; or performing mathematical transformations to normalize device data.</p> <p>The list can be 2-25 <b>PipelineActivity</b> objects and must contain both a <code>channel</code> and a <code>datastore</code> activity. Each entry in the list must contain only one activity, for example:</p> <p> <code>pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ... ]</code> </p>', ], ], 'PipelineActivity' => [ 'base' => '<p>An activity that performs a transformation on a message.</p>', 'refs' => [ 'PipelineActivities$member' => NULL, 'RunPipelineActivityRequest$pipelineActivity' => '<p>The pipeline activity that is run. This must not be a \'channel\' activity or a \'datastore\' activity because these activities are used in a pipeline only to load the original message and to store the (possibly) transformed message. If a \'lambda\' activity is specified, only short-running Lambda functions (those with a timeout of less than 30 seconds or less) can be used.</p>', ], ], 'PipelineArn' => [ 'base' => NULL, 'refs' => [ 'CreatePipelineResponse$pipelineArn' => '<p>The ARN of the pipeline.</p>', 'Pipeline$arn' => '<p>The ARN of the pipeline.</p>', ], ], 'PipelineName' => [ 'base' => NULL, 'refs' => [ 'CancelPipelineReprocessingRequest$pipelineName' => '<p>The name of pipeline for which data reprocessing is canceled.</p>', 'CreatePipelineRequest$pipelineName' => '<p>The name of the pipeline.</p>', 'CreatePipelineResponse$pipelineName' => '<p>The name of the pipeline.</p>', 'DeletePipelineRequest$pipelineName' => '<p>The name of the pipeline to delete.</p>', 'DescribePipelineRequest$pipelineName' => '<p>The name of the pipeline whose information is retrieved.</p>', 'Pipeline$name' => '<p>The name of the pipeline.</p>', 'PipelineSummary$pipelineName' => '<p>The name of the pipeline.</p>', 'StartPipelineReprocessingRequest$pipelineName' => '<p>The name of the pipeline on which to start reprocessing.</p>', 'UpdatePipelineRequest$pipelineName' => '<p>The name of the pipeline to update.</p>', ], ], 'PipelineSummaries' => [ 'base' => NULL, 'refs' => [ 'ListPipelinesResponse$pipelineSummaries' => '<p>A list of "PipelineSummary" objects.</p>', ], ], 'PipelineSummary' => [ 'base' => '<p>A summary of information about a pipeline.</p>', 'refs' => [ 'PipelineSummaries$member' => NULL, ], ], 'PresignedURI' => [ 'base' => NULL, 'refs' => [ 'DatasetEntry$dataURI' => '<p>The pre-signed URI of the data set item.</p>', ], ], 'PutLoggingOptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'QueryFilter' => [ 'base' => '<p>Information which is used to filter message data, to segregate it according to the time frame in which it arrives.</p>', 'refs' => [ 'QueryFilters$member' => NULL, ], ], 'QueryFilters' => [ 'base' => NULL, 'refs' => [ 'SqlQueryDatasetAction$filters' => '<p>Pre-filters applied to message data.</p>', ], ], 'Reason' => [ 'base' => NULL, 'refs' => [ 'DatasetContentStatus$reason' => '<p>The reason the data set contents are in this state.</p>', ], ], 'RemoveAttributesActivity' => [ 'base' => '<p>An activity that removes attributes from a message.</p>', 'refs' => [ 'PipelineActivity$removeAttributes' => '<p>Removes attributes from a message.</p>', ], ], 'ReprocessingId' => [ 'base' => NULL, 'refs' => [ 'CancelPipelineReprocessingRequest$reprocessingId' => '<p>The ID of the reprocessing task (returned by "StartPipelineReprocessing").</p>', 'ReprocessingSummary$id' => '<p>The \'reprocessingId\' returned by "StartPipelineReprocessing".</p>', 'StartPipelineReprocessingResponse$reprocessingId' => '<p>The ID of the pipeline reprocessing activity that was started.</p>', ], ], 'ReprocessingStatus' => [ 'base' => NULL, 'refs' => [ 'ReprocessingSummary$status' => '<p>The status of the pipeline reprocessing.</p>', ], ], 'ReprocessingSummaries' => [ 'base' => NULL, 'refs' => [ 'Pipeline$reprocessingSummaries' => '<p>A summary of information about the pipeline reprocessing.</p>', 'PipelineSummary$reprocessingSummaries' => '<p>A summary of information about the pipeline reprocessing.</p>', ], ], 'ReprocessingSummary' => [ 'base' => '<p>Information about pipeline reprocessing.</p>', 'refs' => [ 'ReprocessingSummaries$member' => NULL, ], ], 'ResourceAlreadyExistsException' => [ 'base' => '<p>A resource with the same name already exists.</p>', 'refs' => [], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p>The ARN of the resource whose tags you want to list.</p>', 'TagResourceRequest$resourceArn' => '<p>The ARN of the resource whose tags you want to modify.</p>', 'UntagResourceRequest$resourceArn' => '<p>The ARN of the resource whose tags you want to remove.</p>', ], ], 'ResourceConfiguration' => [ 'base' => '<p>The configuration of the resource used to execute the "containerAction".</p>', 'refs' => [ 'ContainerDatasetAction$resourceConfiguration' => '<p>Configuration of the resource which executes the "containerAction".</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>A resource with the specified name could not be found.</p>', 'refs' => [], ], 'RetentionPeriod' => [ 'base' => '<p>How long, in days, message data is kept.</p>', 'refs' => [ 'Channel$retentionPeriod' => '<p>How long, in days, message data is kept for the channel.</p>', 'CreateChannelRequest$retentionPeriod' => '<p>How long, in days, message data is kept for the channel. When "customerManagedS3" storage is selected, this parameter is ignored.</p>', 'CreateChannelResponse$retentionPeriod' => '<p>How long, in days, message data is kept for the channel.</p>', 'CreateDatasetRequest$retentionPeriod' => '<p>[Optional] How long, in days, versions of data set contents are kept for the data set. If not specified or set to null, versions of data set contents are retained for at most 90 days. The number of versions of data set contents retained is determined by the <code>versioningConfiguration</code> parameter. (For more information, see https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions)</p>', 'CreateDatasetResponse$retentionPeriod' => '<p>How long, in days, data set contents are kept for the data set.</p>', 'CreateDatastoreRequest$retentionPeriod' => '<p>How long, in days, message data is kept for the data store. When "customerManagedS3" storage is selected, this parameter is ignored.</p>', 'CreateDatastoreResponse$retentionPeriod' => '<p>How long, in days, message data is kept for the data store.</p>', 'Dataset$retentionPeriod' => '<p>[Optional] How long, in days, message data is kept for the data set.</p>', 'Datastore$retentionPeriod' => '<p>How long, in days, message data is kept for the data store. When "customerManagedS3" storage is selected, this parameter is ignored.</p>', 'UpdateChannelRequest$retentionPeriod' => '<p>How long, in days, message data is kept for the channel. The retention period cannot be updated if the channel\'s S3 storage is customer-managed.</p>', 'UpdateDatasetRequest$retentionPeriod' => '<p>How long, in days, data set contents are kept for the data set.</p>', 'UpdateDatastoreRequest$retentionPeriod' => '<p>How long, in days, message data is kept for the data store. The retention period cannot be updated if the data store\'s S3 storage is customer-managed.</p>', ], ], 'RetentionPeriodInDays' => [ 'base' => NULL, 'refs' => [ 'RetentionPeriod$numberOfDays' => '<p>The number of days that message data is kept. The "unlimited" parameter must be false.</p>', ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'ContainerDatasetAction$executionRoleArn' => '<p>The ARN of the role which gives permission to the system to access needed resources in order to run the "containerAction". This includes, at minimum, permission to retrieve the data set contents which are the input to the containerized application.</p>', 'CustomerManagedChannelS3Storage$roleArn' => '<p>The ARN of the role which grants AWS IoT Analytics permission to interact with your Amazon S3 resources.</p>', 'CustomerManagedChannelS3StorageSummary$roleArn' => '<p>The ARN of the role which grants AWS IoT Analytics permission to interact with your Amazon S3 resources.</p>', 'CustomerManagedDatastoreS3Storage$roleArn' => '<p>The ARN of the role which grants AWS IoT Analytics permission to interact with your Amazon S3 resources.</p>', 'CustomerManagedDatastoreS3StorageSummary$roleArn' => '<p>The ARN of the role which grants AWS IoT Analytics permission to interact with your Amazon S3 resources.</p>', 'DeviceRegistryEnrichActivity$roleArn' => '<p>The ARN of the role that allows access to the device\'s registry information.</p>', 'DeviceShadowEnrichActivity$roleArn' => '<p>The ARN of the role that allows access to the device\'s shadow.</p>', 'IotEventsDestinationConfiguration$roleArn' => '<p>The ARN of the role which grants AWS IoT Analytics permission to deliver data set contents to an AWS IoT Events input.</p>', 'LoggingOptions$roleArn' => '<p>The ARN of the role that grants permission to AWS IoT Analytics to perform logging.</p>', 'S3DestinationConfiguration$roleArn' => '<p>The ARN of the role which grants AWS IoT Analytics permission to interact with your Amazon S3 and AWS Glue resources.</p>', ], ], 'RunPipelineActivityRequest' => [ 'base' => NULL, 'refs' => [], ], 'RunPipelineActivityResponse' => [ 'base' => NULL, 'refs' => [], ], 'S3DestinationConfiguration' => [ 'base' => '<p>Configuration information for delivery of data set contents to Amazon S3.</p>', 'refs' => [ 'DatasetContentDeliveryDestination$s3DestinationConfiguration' => '<p>Configuration information for delivery of data set contents to Amazon S3.</p>', ], ], 'S3KeyPrefix' => [ 'base' => NULL, 'refs' => [ 'CustomerManagedChannelS3Storage$keyPrefix' => '<p>[Optional] The prefix used to create the keys of the channel data objects. Each object in an Amazon S3 bucket has a key that is its unique identifier within the bucket (each object in a bucket has exactly one key). The prefix must end with a \'/\'.</p>', 'CustomerManagedChannelS3StorageSummary$keyPrefix' => '<p>[Optional] The prefix used to create the keys of the channel data objects. Each object in an Amazon S3 bucket has a key that is its unique identifier within the bucket (each object in a bucket has exactly one key). The prefix must end with a \'/\'.</p>', 'CustomerManagedDatastoreS3Storage$keyPrefix' => '<p>[Optional] The prefix used to create the keys of the data store data objects. Each object in an Amazon S3 bucket has a key that is its unique identifier within the bucket (each object in a bucket has exactly one key). The prefix must end with a \'/\'.</p>', 'CustomerManagedDatastoreS3StorageSummary$keyPrefix' => '<p>[Optional] The prefix used to create the keys of the data store data objects. Each object in an Amazon S3 bucket has a key that is its unique identifier within the bucket (each object in a bucket has exactly one key). The prefix must end with a \'/\'.</p>', ], ], 'SampleChannelDataRequest' => [ 'base' => NULL, 'refs' => [], ], 'SampleChannelDataResponse' => [ 'base' => NULL, 'refs' => [], ], 'Schedule' => [ 'base' => '<p>The schedule for when to trigger an update.</p>', 'refs' => [ 'DatasetTrigger$schedule' => '<p>The "Schedule" when the trigger is initiated.</p>', ], ], 'ScheduleExpression' => [ 'base' => NULL, 'refs' => [ 'Schedule$expression' => '<p>The expression that defines when to trigger an update. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html"> Schedule Expressions for Rules</a> in the Amazon CloudWatch Events User Guide.</p>', ], ], 'SelectAttributesActivity' => [ 'base' => '<p>Creates a new message using only the specified attributes from the original message.</p>', 'refs' => [ 'PipelineActivity$selectAttributes' => '<p>Creates a new message using only the specified attributes from the original message. </p>', ], ], 'ServiceManagedChannelS3Storage' => [ 'base' => '<p>Use this to store channel data in an S3 bucket managed by the AWS IoT Analytics service. The choice of service-managed or customer-managed S3 storage cannot be changed after creation of the channel.</p>', 'refs' => [ 'ChannelStorage$serviceManagedS3' => '<p>Use this to store channel data in an S3 bucket managed by the AWS IoT Analytics service. The choice of service-managed or customer-managed S3 storage cannot be changed after creation of the channel.</p>', ], ], 'ServiceManagedChannelS3StorageSummary' => [ 'base' => '<p>Used to store channel data in an S3 bucket managed by the AWS IoT Analytics service.</p>', 'refs' => [ 'ChannelStorageSummary$serviceManagedS3' => '<p>Used to store channel data in an S3 bucket managed by the AWS IoT Analytics service.</p>', ], ], 'ServiceManagedDatastoreS3Storage' => [ 'base' => '<p>Use this to store data store data in an S3 bucket managed by the AWS IoT Analytics service. The choice of service-managed or customer-managed S3 storage cannot be changed after creation of the data store.</p>', 'refs' => [ 'DatastoreStorage$serviceManagedS3' => '<p>Use this to store data store data in an S3 bucket managed by the AWS IoT Analytics service. The choice of service-managed or customer-managed S3 storage cannot be changed after creation of the data store.</p>', ], ], 'ServiceManagedDatastoreS3StorageSummary' => [ 'base' => '<p>Used to store data store data in an S3 bucket managed by the AWS IoT Analytics service.</p>', 'refs' => [ 'DatastoreStorageSummary$serviceManagedS3' => '<p>Used to store data store data in an S3 bucket managed by the AWS IoT Analytics service.</p>', ], ], 'ServiceUnavailableException' => [ 'base' => '<p>The service is temporarily unavailable.</p>', 'refs' => [], ], 'SizeInBytes' => [ 'base' => NULL, 'refs' => [ 'EstimatedResourceSize$estimatedSizeInBytes' => '<p>The estimated size of the resource in bytes.</p>', ], ], 'SqlQuery' => [ 'base' => NULL, 'refs' => [ 'SqlQueryDatasetAction$sqlQuery' => '<p>A SQL query string.</p>', ], ], 'SqlQueryDatasetAction' => [ 'base' => '<p>The SQL query to modify the message.</p>', 'refs' => [ 'DatasetAction$queryAction' => '<p>An "SqlQueryDatasetAction" object that uses an SQL query to automatically create data set contents.</p>', ], ], 'StartPipelineReprocessingRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartPipelineReprocessingResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartTime' => [ 'base' => NULL, 'refs' => [ 'SampleChannelDataRequest$startTime' => '<p>The start of the time window from which sample messages are retrieved.</p>', 'StartPipelineReprocessingRequest$startTime' => '<p>The start time (inclusive) of raw message data that is reprocessed.</p>', ], ], 'StringValue' => [ 'base' => NULL, 'refs' => [ 'Variable$stringValue' => '<p>The value of the variable as a string.</p>', ], ], 'Tag' => [ 'base' => '<p>A set of key/value pairs which are used to manage the resource.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$key' => '<p>The tag\'s key.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The keys of those tags which you want to remove.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateChannelRequest$tags' => '<p>Metadata which can be used to manage the channel.</p>', 'CreateDatasetRequest$tags' => '<p>Metadata which can be used to manage the data set.</p>', 'CreateDatastoreRequest$tags' => '<p>Metadata which can be used to manage the data store.</p>', 'CreatePipelineRequest$tags' => '<p>Metadata which can be used to manage the pipeline.</p>', 'ListTagsForResourceResponse$tags' => '<p>The tags (metadata) which you have assigned to the resource.</p>', 'TagResourceRequest$tags' => '<p>The new or modified tags for the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$value' => '<p>The tag\'s value.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'TimeExpression' => [ 'base' => NULL, 'refs' => [ 'DeltaTime$timeExpression' => '<p>An expression by which the time of the message data may be determined. This may be the name of a timestamp field, or a SQL expression which is used to derive the time the message data was generated.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'Channel$creationTime' => '<p>When the channel was created.</p>', 'Channel$lastUpdateTime' => '<p>When the channel was last updated.</p>', 'ChannelSummary$creationTime' => '<p>When the channel was created.</p>', 'ChannelSummary$lastUpdateTime' => '<p>The last time the channel was updated.</p>', 'Dataset$creationTime' => '<p>When the data set was created.</p>', 'Dataset$lastUpdateTime' => '<p>The last time the data set was updated.</p>', 'DatasetContentSummary$creationTime' => '<p>The actual time the creation of the data set contents was started.</p>', 'DatasetContentSummary$scheduleTime' => '<p>The time the creation of the data set contents was scheduled to start.</p>', 'DatasetContentSummary$completionTime' => '<p>The time the dataset content status was updated to SUCCEEDED or FAILED.</p>', 'DatasetSummary$creationTime' => '<p>The time the data set was created.</p>', 'DatasetSummary$lastUpdateTime' => '<p>The last time the data set was updated.</p>', 'Datastore$creationTime' => '<p>When the data store was created.</p>', 'Datastore$lastUpdateTime' => '<p>The last time the data store was updated.</p>', 'DatastoreSummary$creationTime' => '<p>When the data store was created.</p>', 'DatastoreSummary$lastUpdateTime' => '<p>The last time the data store was updated.</p>', 'EstimatedResourceSize$estimatedOn' => '<p>The time when the estimate of the size of the resource was made.</p>', 'GetDatasetContentResponse$timestamp' => '<p>The time when the request was made.</p>', 'ListDatasetContentsRequest$scheduledOnOrAfter' => '<p>A filter to limit results to those data set contents whose creation is scheduled on or after the given time. See the field <code>triggers.schedule</code> in the CreateDataset request. (timestamp)</p>', 'ListDatasetContentsRequest$scheduledBefore' => '<p>A filter to limit results to those data set contents whose creation is scheduled before the given time. See the field <code>triggers.schedule</code> in the CreateDataset request. (timestamp)</p>', 'Pipeline$creationTime' => '<p>When the pipeline was created.</p>', 'Pipeline$lastUpdateTime' => '<p>The last time the pipeline was updated.</p>', 'PipelineSummary$creationTime' => '<p>When the pipeline was created.</p>', 'PipelineSummary$lastUpdateTime' => '<p>When the pipeline was last updated.</p>', 'ReprocessingSummary$creationTime' => '<p>The time the pipeline reprocessing was created.</p>', ], ], 'TriggeringDataset' => [ 'base' => '<p>Information about the data set whose content generation triggers the new data set content generation.</p>', 'refs' => [ 'DatasetTrigger$dataset' => '<p>The data set whose content creation triggers the creation of this data set\'s contents.</p>', ], ], 'UnlimitedRetentionPeriod' => [ 'base' => NULL, 'refs' => [ 'RetentionPeriod$unlimited' => '<p>If true, message data is kept indefinitely.</p>', ], ], 'UnlimitedVersioning' => [ 'base' => NULL, 'refs' => [ 'VersioningConfiguration$unlimited' => '<p>If true, unlimited versions of data set contents will be kept.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDatasetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDatastoreRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePipelineRequest' => [ 'base' => NULL, 'refs' => [], ], 'Variable' => [ 'base' => '<p>An instance of a variable to be passed to the "containerAction" execution. Each variable must have a name and a value given by one of "stringValue", "datasetContentVersionValue", or "outputFileUriValue".</p>', 'refs' => [ 'Variables$member' => NULL, ], ], 'VariableName' => [ 'base' => NULL, 'refs' => [ 'Variable$name' => '<p>The name of the variable.</p>', ], ], 'Variables' => [ 'base' => NULL, 'refs' => [ 'ContainerDatasetAction$variables' => '<p>The values of variables used within the context of the execution of the containerized application (basically, parameters passed to the application). Each variable must have a name and a value given by one of "stringValue", "datasetContentVersionValue", or "outputFileUriValue".</p>', ], ], 'VersioningConfiguration' => [ 'base' => '<p>Information about the versioning of data set contents.</p>', 'refs' => [ 'CreateDatasetRequest$versioningConfiguration' => '<p>[Optional] How many versions of data set contents are kept. If not specified or set to null, only the latest version plus the latest succeeded version (if they are different) are kept for the time period specified by the "retentionPeriod" parameter. (For more information, see https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions)</p>', 'Dataset$versioningConfiguration' => '<p>[Optional] How many versions of data set contents are kept. If not specified or set to null, only the latest version plus the latest succeeded version (if they are different) are kept for the time period specified by the "retentionPeriod" parameter. (For more information, see https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions)</p>', 'UpdateDatasetRequest$versioningConfiguration' => '<p>[Optional] How many versions of data set contents are kept. If not specified or set to null, only the latest version plus the latest succeeded version (if they are different) are kept for the time period specified by the "retentionPeriod" parameter. (For more information, see https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions)</p>', ], ], 'VolumeSizeInGB' => [ 'base' => NULL, 'refs' => [ 'ResourceConfiguration$volumeSizeInGB' => '<p>The size (in GB) of the persistent storage available to the resource instance used to execute the "containerAction" (min: 1, max: 50).</p>', ], ], 'errorMessage' => [ 'base' => NULL, 'refs' => [ 'InternalFailureException$message' => NULL, 'InvalidRequestException$message' => NULL, 'LimitExceededException$message' => NULL, 'ResourceAlreadyExistsException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServiceUnavailableException$message' => NULL, 'ThrottlingException$message' => NULL, ], ], 'resourceArn' => [ 'base' => NULL, 'refs' => [ 'ResourceAlreadyExistsException$resourceArn' => '<p>The ARN of the resource.</p>', ], ], 'resourceId' => [ 'base' => NULL, 'refs' => [ 'ResourceAlreadyExistsException$resourceId' => '<p>The ID of the resource.</p>', ], ], ],];
