<?php
// This file was auto-generated from sdk-root/src/data/iot/2015-05-28/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>AWS IoT</fullname> <p>AWS IoT provides secure, bi-directional communication between Internet-connected devices (such as sensors, actuators, embedded devices, or smart appliances) and the AWS cloud. You can discover your custom IoT-Data endpoint to communicate with, configure rules for data processing and integration with other services, organize resources associated with each device (Registry), configure logging, and create and manage policies and credentials to authenticate devices.</p> <p>The service endpoints that expose this API are listed in <a href="https://docs.aws.amazon.com/general/latest/gr/iot-core.html">AWS IoT Core Endpoints and Quotas</a>. You must use the endpoint for the region that has the resources you want to access.</p> <p>The service name used by <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">AWS Signature Version 4</a> to sign the request is: <i>execute-api</i>.</p> <p>For more information about how AWS IoT works, see the <a href="https://docs.aws.amazon.com/iot/latest/developerguide/aws-iot-how-it-works.html">Developer Guide</a>.</p> <p>For information about how to use the credentials provider for AWS IoT, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/authorizing-direct-aws.html">Authorizing Direct Calls to AWS Services</a>.</p>', 'operations' => [ 'AcceptCertificateTransfer' => '<p>Accepts a pending certificate transfer. The default state of the certificate is INACTIVE.</p> <p>To check for pending certificate transfers, call <a>ListCertificates</a> to enumerate your certificates.</p>', 'AddThingToBillingGroup' => '<p>Adds a thing to a billing group.</p>', 'AddThingToThingGroup' => '<p>Adds a thing to a thing group.</p>', 'AssociateTargetsWithJob' => '<p>Associates a group with a continuous job. The following criteria must be met: </p> <ul> <li> <p>The job must have been created with the <code>targetSelection</code> field set to "CONTINUOUS".</p> </li> <li> <p>The job status must currently be "IN_PROGRESS".</p> </li> <li> <p>The total number of targets associated with a job must not exceed 100.</p> </li> </ul>', 'AttachPolicy' => '<p>Attaches a policy to the specified target.</p>', 'AttachPrincipalPolicy' => '<p>Attaches the specified policy to the specified principal (certificate or other credential).</p> <p> <b>Note:</b> This API is deprecated. Please use <a>AttachPolicy</a> instead.</p>', 'AttachSecurityProfile' => '<p>Associates a Device Defender security profile with a thing group or this account. Each thing group or account can have up to five security profiles associated with it.</p>', 'AttachThingPrincipal' => '<p>Attaches the specified principal to the specified thing. A principal can be X.509 certificates, IAM users, groups, and roles, Amazon Cognito identities or federated identities.</p>', 'CancelAuditMitigationActionsTask' => '<p>Cancels a mitigation action task that is in progress. If the task is not in progress, an InvalidRequestException occurs.</p>', 'CancelAuditTask' => '<p>Cancels an audit that is in progress. The audit can be either scheduled or on-demand. If the audit is not in progress, an "InvalidRequestException" occurs.</p>', 'CancelCertificateTransfer' => '<p>Cancels a pending transfer for the specified certificate.</p> <p> <b>Note</b> Only the transfer source account can use this operation to cancel a transfer. (Transfer destinations can use <a>RejectCertificateTransfer</a> instead.) After transfer, AWS IoT returns the certificate to the source account in the INACTIVE state. After the destination account has accepted the transfer, the transfer cannot be cancelled.</p> <p>After a certificate transfer is cancelled, the status of the certificate changes from PENDING_TRANSFER to INACTIVE.</p>', 'CancelJob' => '<p>Cancels a job.</p>', 'CancelJobExecution' => '<p>Cancels the execution of a job for a given thing.</p>', 'ClearDefaultAuthorizer' => '<p>Clears the default authorizer.</p>', 'ConfirmTopicRuleDestination' => '<p>Confirms a topic rule destination. When you create a rule requiring a destination, AWS IoT sends a confirmation message to the endpoint or base address you specify. The message includes a token which you pass back when calling <code>ConfirmTopicRuleDestination</code> to confirm that you own or have access to the endpoint.</p>', 'CreateAuthorizer' => '<p>Creates an authorizer.</p>', 'CreateBillingGroup' => '<p>Creates a billing group.</p>', 'CreateCertificateFromCsr' => '<p>Creates an X.509 certificate using the specified certificate signing request.</p> <p> <b>Note:</b> The CSR must include a public key that is either an RSA key with a length of at least 2048 bits or an ECC key from NIST P-256 or NIST P-384 curves. </p> <p> <b>Note:</b> Reusing the same certificate signing request (CSR) results in a distinct certificate.</p> <p>You can create multiple certificates in a batch by creating a directory, copying multiple .csr files into that directory, and then specifying that directory on the command line. The following commands show how to create a batch of certificates given a batch of CSRs.</p> <p>Assuming a set of CSRs are located inside of the directory my-csr-directory:</p> <p>On Linux and OS X, the command is:</p> <p>$ ls my-csr-directory/ | xargs -I {} aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/{}</p> <p>This command lists all of the CSRs in my-csr-directory and pipes each CSR file name to the aws iot create-certificate-from-csr AWS CLI command to create a certificate for the corresponding CSR.</p> <p>The aws iot create-certificate-from-csr part of the command can also be run in parallel to speed up the certificate creation process:</p> <p>$ ls my-csr-directory/ | xargs -P 10 -I {} aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/{}</p> <p>On Windows PowerShell, the command to create certificates for all CSRs in my-csr-directory is:</p> <p>&gt; ls -Name my-csr-directory | %{aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/$_}</p> <p>On a Windows command prompt, the command to create certificates for all CSRs in my-csr-directory is:</p> <p>&gt; forfiles /p my-csr-directory /c "cmd /c aws iot create-certificate-from-csr --certificate-signing-request file://@path"</p>', 'CreateDimension' => '<p>Create a dimension that you can use to limit the scope of a metric used in a security profile for AWS IoT Device Defender. For example, using a <code>TOPIC_FILTER</code> dimension, you can narrow down the scope of the metric only to MQTT topics whose name match the pattern specified in the dimension.</p>', 'CreateDomainConfiguration' => '<p>Creates a domain configuration.</p> <note> <p>The domain configuration feature is in public preview and is subject to change.</p> </note>', 'CreateDynamicThingGroup' => '<p>Creates a dynamic thing group.</p>', 'CreateJob' => '<p>Creates a job.</p>', 'CreateKeysAndCertificate' => '<p>Creates a 2048-bit RSA key pair and issues an X.509 certificate using the issued public key. You can also call <code>CreateKeysAndCertificate</code> over MQTT from a device, for more information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html#provision-mqtt-api">Provisioning MQTT API</a>.</p> <p> <b>Note</b> This is the only time AWS IoT issues the private key for this certificate, so it is important to keep it in a secure location.</p>', 'CreateMitigationAction' => '<p>Defines an action that can be applied to audit findings by using StartAuditMitigationActionsTask. Each mitigation action can apply only one type of change.</p>', 'CreateOTAUpdate' => '<p>Creates an AWS IoT OTAUpdate on a target group of things or groups.</p>', 'CreatePolicy' => '<p>Creates an AWS IoT policy.</p> <p>The created policy is the default version for the policy. This operation creates a policy version with a version identifier of <b>1</b> and sets <b>1</b> as the policy\'s default version.</p>', 'CreatePolicyVersion' => '<p>Creates a new version of the specified AWS IoT policy. To update a policy, create a new policy version. A managed policy can have up to five versions. If the policy has five versions, you must use <a>DeletePolicyVersion</a> to delete an existing version before you create a new one.</p> <p>Optionally, you can set the new version as the policy\'s default version. The default version is the operative version (that is, the version that is in effect for the certificates to which the policy is attached).</p>', 'CreateProvisioningClaim' => '<p>Creates a provisioning claim.</p>', 'CreateProvisioningTemplate' => '<p>Creates a fleet provisioning template.</p>', 'CreateProvisioningTemplateVersion' => '<p>Creates a new version of a fleet provisioning template.</p>', 'CreateRoleAlias' => '<p>Creates a role alias.</p>', 'CreateScheduledAudit' => '<p>Creates a scheduled audit that is run at a specified time interval.</p>', 'CreateSecurityProfile' => '<p>Creates a Device Defender security profile.</p>', 'CreateStream' => '<p>Creates a stream for delivering one or more large files in chunks over MQTT. A stream transports data bytes in chunks or blocks packaged as MQTT messages from a source like S3. You can have one or more files associated with a stream.</p>', 'CreateThing' => '<p>Creates a thing record in the registry. If this call is made multiple times using the same thing name and configuration, the call will succeed. If this call is made with the same thing name but different configuration a <code>ResourceAlreadyExistsException</code> is thrown.</p> <note> <p>This is a control plane operation. See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html">Authorization</a> for information about authorizing control plane actions.</p> </note>', 'CreateThingGroup' => '<p>Create a thing group.</p> <note> <p>This is a control plane operation. See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html">Authorization</a> for information about authorizing control plane actions.</p> </note>', 'CreateThingType' => '<p>Creates a new thing type.</p>', 'CreateTopicRule' => '<p>Creates a rule. Creating rules is an administrator-level action. Any user who has permission to create rules will be able to access data processed by the rule.</p>', 'CreateTopicRuleDestination' => '<p>Creates a topic rule destination. The destination must be confirmed prior to use.</p>', 'DeleteAccountAuditConfiguration' => '<p>Restores the default settings for Device Defender audits for this account. Any configuration data you entered is deleted and all audit checks are reset to disabled. </p>', 'DeleteAuthorizer' => '<p>Deletes an authorizer.</p>', 'DeleteBillingGroup' => '<p>Deletes the billing group.</p>', 'DeleteCACertificate' => '<p>Deletes a registered CA certificate.</p>', 'DeleteCertificate' => '<p>Deletes the specified certificate.</p> <p>A certificate cannot be deleted if it has a policy or IoT thing attached to it or if its status is set to ACTIVE. To delete a certificate, first use the <a>DetachPrincipalPolicy</a> API to detach all policies. Next, use the <a>UpdateCertificate</a> API to set the certificate to the INACTIVE status.</p>', 'DeleteDimension' => '<p>Removes the specified dimension from your AWS account.</p>', 'DeleteDomainConfiguration' => '<p>Deletes the specified domain configuration.</p> <note> <p>The domain configuration feature is in public preview and is subject to change.</p> </note>', 'DeleteDynamicThingGroup' => '<p>Deletes a dynamic thing group.</p>', 'DeleteJob' => '<p>Deletes a job and its related job executions.</p> <p>Deleting a job may take time, depending on the number of job executions created for the job and various other factors. While the job is being deleted, the status of the job will be shown as "DELETION_IN_PROGRESS". Attempting to delete or cancel a job whose status is already "DELETION_IN_PROGRESS" will result in an error.</p> <p>Only 10 jobs may have status "DELETION_IN_PROGRESS" at the same time, or a LimitExceededException will occur.</p>', 'DeleteJobExecution' => '<p>Deletes a job execution.</p>', 'DeleteMitigationAction' => '<p>Deletes a defined mitigation action from your AWS account.</p>', 'DeleteOTAUpdate' => '<p>Delete an OTA update.</p>', 'DeletePolicy' => '<p>Deletes the specified policy.</p> <p>A policy cannot be deleted if it has non-default versions or it is attached to any certificate.</p> <p>To delete a policy, use the DeletePolicyVersion API to delete all non-default versions of the policy; use the DetachPrincipalPolicy API to detach the policy from any certificate; and then use the DeletePolicy API to delete the policy.</p> <p>When a policy is deleted using DeletePolicy, its default version is deleted with it.</p>', 'DeletePolicyVersion' => '<p>Deletes the specified version of the specified policy. You cannot delete the default version of a policy using this API. To delete the default version of a policy, use <a>DeletePolicy</a>. To find out which version of a policy is marked as the default version, use ListPolicyVersions.</p>', 'DeleteProvisioningTemplate' => '<p>Deletes a fleet provisioning template.</p>', 'DeleteProvisioningTemplateVersion' => '<p>Deletes a fleet provisioning template version.</p>', 'DeleteRegistrationCode' => '<p>Deletes a CA certificate registration code.</p>', 'DeleteRoleAlias' => '<p>Deletes a role alias</p>', 'DeleteScheduledAudit' => '<p>Deletes a scheduled audit.</p>', 'DeleteSecurityProfile' => '<p>Deletes a Device Defender security profile.</p>', 'DeleteStream' => '<p>Deletes a stream.</p>', 'DeleteThing' => '<p>Deletes the specified thing. Returns successfully with no error if the deletion is successful or you specify a thing that doesn\'t exist.</p>', 'DeleteThingGroup' => '<p>Deletes a thing group.</p>', 'DeleteThingType' => '<p>Deletes the specified thing type. You cannot delete a thing type if it has things associated with it. To delete a thing type, first mark it as deprecated by calling <a>DeprecateThingType</a>, then remove any associated things by calling <a>UpdateThing</a> to change the thing type on any associated thing, and finally use <a>DeleteThingType</a> to delete the thing type.</p>', 'DeleteTopicRule' => '<p>Deletes the rule.</p>', 'DeleteTopicRuleDestination' => '<p>Deletes a topic rule destination.</p>', 'DeleteV2LoggingLevel' => '<p>Deletes a logging level.</p>', 'DeprecateThingType' => '<p>Deprecates a thing type. You can not associate new things with deprecated thing type.</p>', 'DescribeAccountAuditConfiguration' => '<p>Gets information about the Device Defender audit settings for this account. Settings include how audit notifications are sent and which audit checks are enabled or disabled.</p>', 'DescribeAuditFinding' => '<p>Gets information about a single audit finding. Properties include the reason for noncompliance, the severity of the issue, and when the audit that returned the finding was started.</p>', 'DescribeAuditMitigationActionsTask' => '<p>Gets information about an audit mitigation task that is used to apply mitigation actions to a set of audit findings. Properties include the actions being applied, the audit checks to which they\'re being applied, the task status, and aggregated task statistics.</p>', 'DescribeAuditTask' => '<p>Gets information about a Device Defender audit.</p>', 'DescribeAuthorizer' => '<p>Describes an authorizer.</p>', 'DescribeBillingGroup' => '<p>Returns information about a billing group.</p>', 'DescribeCACertificate' => '<p>Describes a registered CA certificate.</p>', 'DescribeCertificate' => '<p>Gets information about the specified certificate.</p>', 'DescribeDefaultAuthorizer' => '<p>Describes the default authorizer.</p>', 'DescribeDimension' => '<p>Provides details about a dimension that is defined in your AWS account.</p>', 'DescribeDomainConfiguration' => '<p>Gets summary information about a domain configuration.</p> <note> <p>The domain configuration feature is in public preview and is subject to change.</p> </note>', 'DescribeEndpoint' => '<p>Returns a unique endpoint specific to the AWS account making the call.</p>', 'DescribeEventConfigurations' => '<p>Describes event configurations.</p>', 'DescribeIndex' => '<p>Describes a search index.</p>', 'DescribeJob' => '<p>Describes a job.</p>', 'DescribeJobExecution' => '<p>Describes a job execution.</p>', 'DescribeMitigationAction' => '<p>Gets information about a mitigation action.</p>', 'DescribeProvisioningTemplate' => '<p>Returns information about a fleet provisioning template.</p>', 'DescribeProvisioningTemplateVersion' => '<p>Returns information about a fleet provisioning template version.</p>', 'DescribeRoleAlias' => '<p>Describes a role alias.</p>', 'DescribeScheduledAudit' => '<p>Gets information about a scheduled audit.</p>', 'DescribeSecurityProfile' => '<p>Gets information about a Device Defender security profile.</p>', 'DescribeStream' => '<p>Gets information about a stream.</p>', 'DescribeThing' => '<p>Gets information about the specified thing.</p>', 'DescribeThingGroup' => '<p>Describe a thing group.</p>', 'DescribeThingRegistrationTask' => '<p>Describes a bulk thing provisioning task.</p>', 'DescribeThingType' => '<p>Gets information about the specified thing type.</p>', 'DetachPolicy' => '<p>Detaches a policy from the specified target.</p>', 'DetachPrincipalPolicy' => '<p>Removes the specified policy from the specified certificate.</p> <p> <b>Note:</b> This API is deprecated. Please use <a>DetachPolicy</a> instead.</p>', 'DetachSecurityProfile' => '<p>Disassociates a Device Defender security profile from a thing group or from this account.</p>', 'DetachThingPrincipal' => '<p>Detaches the specified principal from the specified thing. A principal can be X.509 certificates, IAM users, groups, and roles, Amazon Cognito identities or federated identities.</p> <note> <p>This call is asynchronous. It might take several seconds for the detachment to propagate.</p> </note>', 'DisableTopicRule' => '<p>Disables the rule.</p>', 'EnableTopicRule' => '<p>Enables the rule.</p>', 'GetCardinality' => '<p>Returns the approximate count of unique values that match the query.</p>', 'GetEffectivePolicies' => '<p>Gets a list of the policies that have an effect on the authorization behavior of the specified device when it connects to the AWS IoT device gateway.</p>', 'GetIndexingConfiguration' => '<p>Gets the indexing configuration.</p>', 'GetJobDocument' => '<p>Gets a job document.</p>', 'GetLoggingOptions' => '<p>Gets the logging options.</p> <p>NOTE: use of this command is not recommended. Use <code>GetV2LoggingOptions</code> instead.</p>', 'GetOTAUpdate' => '<p>Gets an OTA update.</p>', 'GetPercentiles' => '<p>Groups the aggregated values that match the query into percentile groupings. The default percentile groupings are: 1,5,25,50,75,95,99, although you can specify your own when you call <code>GetPercentiles</code>. This function returns a value for each percentile group specified (or the default percentile groupings). The percentile group "1" contains the aggregated field value that occurs in approximately one percent of the values that match the query. The percentile group "5" contains the aggregated field value that occurs in approximately five percent of the values that match the query, and so on. The result is an approximation, the more values that match the query, the more accurate the percentile values.</p>', 'GetPolicy' => '<p>Gets information about the specified policy with the policy document of the default version.</p>', 'GetPolicyVersion' => '<p>Gets information about the specified policy version.</p>', 'GetRegistrationCode' => '<p>Gets a registration code used to register a CA certificate with AWS IoT.</p>', 'GetStatistics' => '<p>Returns the count, average, sum, minimum, maximum, sum of squares, variance, and standard deviation for the specified aggregated field. If the aggregation field is of type <code>String</code>, only the count statistic is returned.</p>', 'GetTopicRule' => '<p>Gets information about the rule.</p>', 'GetTopicRuleDestination' => '<p>Gets information about a topic rule destination.</p>', 'GetV2LoggingOptions' => '<p>Gets the fine grained logging options.</p>', 'ListActiveViolations' => '<p>Lists the active violations for a given Device Defender security profile.</p>', 'ListAttachedPolicies' => '<p>Lists the policies attached to the specified thing group.</p>', 'ListAuditFindings' => '<p>Lists the findings (results) of a Device Defender audit or of the audits performed during a specified time period. (Findings are retained for 180 days.)</p>', 'ListAuditMitigationActionsExecutions' => '<p>Gets the status of audit mitigation action tasks that were executed.</p>', 'ListAuditMitigationActionsTasks' => '<p>Gets a list of audit mitigation action tasks that match the specified filters.</p>', 'ListAuditTasks' => '<p>Lists the Device Defender audits that have been performed during a given time period.</p>', 'ListAuthorizers' => '<p>Lists the authorizers registered in your account.</p>', 'ListBillingGroups' => '<p>Lists the billing groups you have created.</p>', 'ListCACertificates' => '<p>Lists the CA certificates registered for your AWS account.</p> <p>The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional results.</p>', 'ListCertificates' => '<p>Lists the certificates registered in your AWS account.</p> <p>The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional results.</p>', 'ListCertificatesByCA' => '<p>List the device certificates signed by the specified CA certificate.</p>', 'ListDimensions' => '<p>List the set of dimensions that are defined for your AWS account.</p>', 'ListDomainConfigurations' => '<p>Gets a list of domain configurations for the user. This list is sorted alphabetically by domain configuration name.</p> <note> <p>The domain configuration feature is in public preview and is subject to change.</p> </note>', 'ListIndices' => '<p>Lists the search indices.</p>', 'ListJobExecutionsForJob' => '<p>Lists the job executions for a job.</p>', 'ListJobExecutionsForThing' => '<p>Lists the job executions for the specified thing.</p>', 'ListJobs' => '<p>Lists jobs.</p>', 'ListMitigationActions' => '<p>Gets a list of all mitigation actions that match the specified filter criteria.</p>', 'ListOTAUpdates' => '<p>Lists OTA updates.</p>', 'ListOutgoingCertificates' => '<p>Lists certificates that are being transferred but not yet accepted.</p>', 'ListPolicies' => '<p>Lists your policies.</p>', 'ListPolicyPrincipals' => '<p>Lists the principals associated with the specified policy.</p> <p> <b>Note:</b> This API is deprecated. Please use <a>ListTargetsForPolicy</a> instead.</p>', 'ListPolicyVersions' => '<p>Lists the versions of the specified policy and identifies the default version.</p>', 'ListPrincipalPolicies' => '<p>Lists the policies attached to the specified principal. If you use an Cognito identity, the ID must be in <a href="https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/API_GetCredentialsForIdentity.html#API_GetCredentialsForIdentity_RequestSyntax">AmazonCognito Identity format</a>.</p> <p> <b>Note:</b> This API is deprecated. Please use <a>ListAttachedPolicies</a> instead.</p>', 'ListPrincipalThings' => '<p>Lists the things associated with the specified principal. A principal can be X.509 certificates, IAM users, groups, and roles, Amazon Cognito identities or federated identities. </p>', 'ListProvisioningTemplateVersions' => '<p>A list of fleet provisioning template versions.</p>', 'ListProvisioningTemplates' => '<p>Lists the fleet provisioning templates in your AWS account.</p>', 'ListRoleAliases' => '<p>Lists the role aliases registered in your account.</p>', 'ListScheduledAudits' => '<p>Lists all of your scheduled audits.</p>', 'ListSecurityProfiles' => '<p>Lists the Device Defender security profiles you have created. You can use filters to list only those security profiles associated with a thing group or only those associated with your account.</p>', 'ListSecurityProfilesForTarget' => '<p>Lists the Device Defender security profiles attached to a target (thing group).</p>', 'ListStreams' => '<p>Lists all of the streams in your AWS account.</p>', 'ListTagsForResource' => '<p>Lists the tags (metadata) you have assigned to the resource.</p>', 'ListTargetsForPolicy' => '<p>List targets for the specified policy.</p>', 'ListTargetsForSecurityProfile' => '<p>Lists the targets (thing groups) associated with a given Device Defender security profile.</p>', 'ListThingGroups' => '<p>List the thing groups in your account.</p>', 'ListThingGroupsForThing' => '<p>List the thing groups to which the specified thing belongs.</p>', 'ListThingPrincipals' => '<p>Lists the principals associated with the specified thing. A principal can be X.509 certificates, IAM users, groups, and roles, Amazon Cognito identities or federated identities.</p>', 'ListThingRegistrationTaskReports' => '<p>Information about the thing registration tasks.</p>', 'ListThingRegistrationTasks' => '<p>List bulk thing provisioning tasks.</p>', 'ListThingTypes' => '<p>Lists the existing thing types.</p>', 'ListThings' => '<p>Lists your things. Use the <b>attributeName</b> and <b>attributeValue</b> parameters to filter your things. For example, calling <code>ListThings</code> with attributeName=Color and attributeValue=Red retrieves all things in the registry that contain an attribute <b>Color</b> with the value <b>Red</b>. </p>', 'ListThingsInBillingGroup' => '<p>Lists the things you have added to the given billing group.</p>', 'ListThingsInThingGroup' => '<p>Lists the things in the specified group.</p>', 'ListTopicRuleDestinations' => '<p>Lists all the topic rule destinations in your AWS account.</p>', 'ListTopicRules' => '<p>Lists the rules for the specific topic.</p>', 'ListV2LoggingLevels' => '<p>Lists logging levels.</p>', 'ListViolationEvents' => '<p>Lists the Device Defender security profile violations discovered during the given time period. You can use filters to limit the results to those alerts issued for a particular security profile, behavior, or thing (device).</p>', 'RegisterCACertificate' => '<p>Registers a CA certificate with AWS IoT. This CA certificate can then be used to sign device certificates, which can be then registered with AWS IoT. You can register up to 10 CA certificates per AWS account that have the same subject field. This enables you to have up to 10 certificate authorities sign your device certificates. If you have more than one CA certificate registered, make sure you pass the CA certificate when you register your device certificates with the RegisterCertificate API.</p>', 'RegisterCertificate' => '<p>Registers a device certificate with AWS IoT. If you have more than one CA certificate that has the same subject field, you must specify the CA certificate that was used to sign the device certificate being registered.</p>', 'RegisterCertificateWithoutCA' => '<p>Register a certificate that does not have a certificate authority (CA).</p>', 'RegisterThing' => '<p>Provisions a thing in the device registry. RegisterThing calls other AWS IoT control plane APIs. These calls might exceed your account level <a href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_iot"> AWS IoT Throttling Limits</a> and cause throttle errors. Please contact <a href="https://console.aws.amazon.com/support/home">AWS Customer Support</a> to raise your throttling limits if necessary.</p>', 'RejectCertificateTransfer' => '<p>Rejects a pending certificate transfer. After AWS IoT rejects a certificate transfer, the certificate status changes from <b>PENDING_TRANSFER</b> to <b>INACTIVE</b>.</p> <p>To check for pending certificate transfers, call <a>ListCertificates</a> to enumerate your certificates.</p> <p>This operation can only be called by the transfer destination. After it is called, the certificate will be returned to the source\'s account in the INACTIVE state.</p>', 'RemoveThingFromBillingGroup' => '<p>Removes the given thing from the billing group.</p>', 'RemoveThingFromThingGroup' => '<p>Remove the specified thing from the specified group.</p> <p>You must specify either a <code>thingGroupArn</code> or a <code>thingGroupName</code> to identify the thing group and either a <code>thingArn</code> or a <code>thingName</code> to identify the thing to remove from the thing group. </p>', 'ReplaceTopicRule' => '<p>Replaces the rule. You must specify all parameters for the new rule. Creating rules is an administrator-level action. Any user who has permission to create rules will be able to access data processed by the rule.</p>', 'SearchIndex' => '<p>The query search index.</p>', 'SetDefaultAuthorizer' => '<p>Sets the default authorizer. This will be used if a websocket connection is made without specifying an authorizer.</p>', 'SetDefaultPolicyVersion' => '<p>Sets the specified version of the specified policy as the policy\'s default (operative) version. This action affects all certificates to which the policy is attached. To list the principals the policy is attached to, use the ListPrincipalPolicy API.</p>', 'SetLoggingOptions' => '<p>Sets the logging options.</p> <p>NOTE: use of this command is not recommended. Use <code>SetV2LoggingOptions</code> instead.</p>', 'SetV2LoggingLevel' => '<p>Sets the logging level.</p>', 'SetV2LoggingOptions' => '<p>Sets the logging options for the V2 logging service.</p>', 'StartAuditMitigationActionsTask' => '<p>Starts a task that applies a set of mitigation actions to the specified target.</p>', 'StartOnDemandAuditTask' => '<p>Starts an on-demand Device Defender audit.</p>', 'StartThingRegistrationTask' => '<p>Creates a bulk thing provisioning task.</p>', 'StopThingRegistrationTask' => '<p>Cancels a bulk thing provisioning task.</p>', 'TagResource' => '<p>Adds to or modifies the tags of the given resource. Tags are metadata which can be used to manage a resource.</p>', 'TestAuthorization' => '<p>Tests if a specified principal is authorized to perform an AWS IoT action on a specified resource. Use this to test and debug the authorization behavior of devices that connect to the AWS IoT device gateway.</p>', 'TestInvokeAuthorizer' => '<p>Tests a custom authorization behavior by invoking a specified custom authorizer. Use this to test and debug the custom authorization behavior of devices that connect to the AWS IoT device gateway.</p>', 'TransferCertificate' => '<p>Transfers the specified certificate to the specified AWS account.</p> <p>You can cancel the transfer until it is acknowledged by the recipient.</p> <p>No notification is sent to the transfer destination\'s account. It is up to the caller to notify the transfer target.</p> <p>The certificate being transferred must not be in the ACTIVE state. You can use the UpdateCertificate API to deactivate it.</p> <p>The certificate must not have any policies attached to it. You can use the DetachPrincipalPolicy API to detach them.</p>', 'UntagResource' => '<p>Removes the given tags (metadata) from the resource.</p>', 'UpdateAccountAuditConfiguration' => '<p>Configures or reconfigures the Device Defender audit settings for this account. Settings include how audit notifications are sent and which audit checks are enabled or disabled.</p>', 'UpdateAuthorizer' => '<p>Updates an authorizer.</p>', 'UpdateBillingGroup' => '<p>Updates information about the billing group.</p>', 'UpdateCACertificate' => '<p>Updates a registered CA certificate.</p>', 'UpdateCertificate' => '<p>Updates the status of the specified certificate. This operation is idempotent.</p> <p>Moving a certificate from the ACTIVE state (including REVOKED) will not disconnect currently connected devices, but these devices will be unable to reconnect.</p> <p>The ACTIVE state is required to authenticate devices connecting to AWS IoT using a certificate.</p>', 'UpdateDimension' => '<p>Updates the definition for a dimension. You cannot change the type of a dimension after it is created (you can delete it and re-create it).</p>', 'UpdateDomainConfiguration' => '<p>Updates values stored in the domain configuration. Domain configurations for default endpoints can\'t be updated.</p> <note> <p>The domain configuration feature is in public preview and is subject to change.</p> </note>', 'UpdateDynamicThingGroup' => '<p>Updates a dynamic thing group.</p>', 'UpdateEventConfigurations' => '<p>Updates the event configurations.</p>', 'UpdateIndexingConfiguration' => '<p>Updates the search configuration.</p>', 'UpdateJob' => '<p>Updates supported fields of the specified job.</p>', 'UpdateMitigationAction' => '<p>Updates the definition for the specified mitigation action.</p>', 'UpdateProvisioningTemplate' => '<p>Updates a fleet provisioning template.</p>', 'UpdateRoleAlias' => '<p>Updates a role alias.</p>', 'UpdateScheduledAudit' => '<p>Updates a scheduled audit, including which checks are performed and how often the audit takes place.</p>', 'UpdateSecurityProfile' => '<p>Updates a Device Defender security profile.</p>', 'UpdateStream' => '<p>Updates an existing stream. The stream version will be incremented by one.</p>', 'UpdateThing' => '<p>Updates the data for a thing.</p>', 'UpdateThingGroup' => '<p>Update a thing group.</p>', 'UpdateThingGroupsForThing' => '<p>Updates the groups to which the thing belongs.</p>', 'UpdateTopicRuleDestination' => '<p>Updates a topic rule destination. You use this to change the status, endpoint URL, or confirmation URL of the destination.</p>', 'ValidateSecurityProfileBehaviors' => '<p>Validates a Device Defender security profile behaviors specification.</p>', ], 'shapes' => [ 'AbortAction' => [ 'base' => NULL, 'refs' => [ 'AbortCriteria$action' => '<p>The type of job action to take to initiate the job abort.</p>', ], ], 'AbortConfig' => [ 'base' => '<p>The criteria that determine when and how a job abort takes place.</p>', 'refs' => [ 'CreateJobRequest$abortConfig' => '<p>Allows you to create criteria to abort a job.</p>', 'Job$abortConfig' => '<p>Configuration for criteria to abort the job.</p>', 'UpdateJobRequest$abortConfig' => '<p>Allows you to create criteria to abort a job.</p>', ], ], 'AbortCriteria' => [ 'base' => '<p>The criteria that determine when and how a job abort takes place.</p>', 'refs' => [ 'AbortCriteriaList$member' => NULL, ], ], 'AbortCriteriaList' => [ 'base' => NULL, 'refs' => [ 'AbortConfig$criteriaList' => '<p>The list of criteria that determine when and how to abort the job.</p>', ], ], 'AbortThresholdPercentage' => [ 'base' => NULL, 'refs' => [ 'AbortCriteria$thresholdPercentage' => '<p>The minimum percentage of job execution failures that must occur to initiate the job abort.</p> <p>AWS IoT supports up to two digits after the decimal (for example, 10.9 and 10.99, but not 10.999).</p>', ], ], 'AcceptCertificateTransferRequest' => [ 'base' => '<p>The input for the AcceptCertificateTransfer operation.</p>', 'refs' => [], ], 'AcmCertificateArn' => [ 'base' => NULL, 'refs' => [ 'CreateDomainConfigurationRequest$validationCertificateArn' => '<p>The certificate used to validate the server certificate and prove domain name ownership. This certificate must be signed by a public certificate authority. This value is not required for AWS-managed domains.</p>', 'ServerCertificateArns$member' => NULL, 'ServerCertificateSummary$serverCertificateArn' => '<p>The ARN of the server certificate.</p>', ], ], 'Action' => [ 'base' => '<p>Describes the actions associated with a rule.</p>', 'refs' => [ 'ActionList$member' => NULL, 'TopicRule$errorAction' => '<p>The action to perform when an error occurs.</p>', 'TopicRulePayload$errorAction' => '<p>The action to take when an error occurs.</p>', ], ], 'ActionList' => [ 'base' => NULL, 'refs' => [ 'TopicRule$actions' => '<p>The actions associated with the rule.</p>', 'TopicRulePayload$actions' => '<p>The actions associated with the rule.</p>', ], ], 'ActionType' => [ 'base' => NULL, 'refs' => [ 'AuthInfo$actionType' => '<p>The type of action for which the principal is being authorized.</p>', ], ], 'ActiveViolation' => [ 'base' => '<p>Information about an active Device Defender security profile behavior violation.</p>', 'refs' => [ 'ActiveViolations$member' => NULL, ], ], 'ActiveViolations' => [ 'base' => NULL, 'refs' => [ 'ListActiveViolationsResponse$activeViolations' => '<p>The list of active violations.</p>', ], ], 'AddThingToBillingGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'AddThingToBillingGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'AddThingToThingGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'AddThingToThingGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'AddThingsToThingGroupParams' => [ 'base' => '<p>Parameters used when defining a mitigation action that move a set of things to a thing group.</p>', 'refs' => [ 'MitigationActionParams$addThingsToThingGroupParams' => '<p>Parameters to define a mitigation action that moves devices associated with a certificate to one or more specified thing groups, typically for quarantine.</p>', ], ], 'AdditionalMetricsToRetainList' => [ 'base' => NULL, 'refs' => [ 'CreateSecurityProfileRequest$additionalMetricsToRetain' => '<p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile\'s <code>behaviors</code>, but it is also retained for any metric specified here.</p> <p> <b>Note:</b> This API field is deprecated. Please use <a>CreateSecurityProfileRequest$additionalMetricsToRetainV2</a> instead.</p>', 'DescribeSecurityProfileResponse$additionalMetricsToRetain' => '<p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile\'s <code>behaviors</code>, but it is also retained for any metric specified here.</p> <p> <b>Note:</b> This API field is deprecated. Please use <a>DescribeSecurityProfileResponse$additionalMetricsToRetainV2</a> instead.</p>', 'UpdateSecurityProfileRequest$additionalMetricsToRetain' => '<p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile\'s <code>behaviors</code>, but it is also retained for any metric specified here.</p> <p> <b>Note:</b> This API field is deprecated. Please use <a>UpdateSecurityProfileRequest$additionalMetricsToRetainV2</a> instead.</p>', 'UpdateSecurityProfileResponse$additionalMetricsToRetain' => '<p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the security profile\'s <code>behaviors</code>, but it is also retained for any metric specified here.</p> <p> <b>Note:</b> This API field is deprecated. Please use <a>UpdateSecurityProfileResponse$additionalMetricsToRetainV2</a> instead.</p>', ], ], 'AdditionalMetricsToRetainV2List' => [ 'base' => NULL, 'refs' => [ 'CreateSecurityProfileRequest$additionalMetricsToRetainV2' => '<p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile\'s <code>behaviors</code>, but it is also retained for any metric specified here.</p>', 'DescribeSecurityProfileResponse$additionalMetricsToRetainV2' => '<p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile\'s behaviors, but it is also retained for any metric specified here.</p>', 'UpdateSecurityProfileRequest$additionalMetricsToRetainV2' => '<p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile\'s behaviors, but it is also retained for any metric specified here.</p>', 'UpdateSecurityProfileResponse$additionalMetricsToRetainV2' => '<p>A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile\'s behaviors, but it is also retained for any metric specified here.</p>', ], ], 'AdditionalParameterMap' => [ 'base' => NULL, 'refs' => [ 'CreateOTAUpdateRequest$additionalParameters' => '<p>A list of additional OTA update parameters which are name-value pairs.</p>', 'OTAUpdateInfo$additionalParameters' => '<p>A collection of name/value pairs</p>', ], ], 'AggregationField' => [ 'base' => NULL, 'refs' => [ 'GetCardinalityRequest$aggregationField' => '<p>The field to aggregate.</p>', 'GetPercentilesRequest$aggregationField' => '<p>The field to aggregate.</p>', 'GetStatisticsRequest$aggregationField' => '<p>The aggregation field name.</p>', ], ], 'AlarmName' => [ 'base' => NULL, 'refs' => [ 'CloudwatchAlarmAction$alarmName' => '<p>The CloudWatch alarm name.</p>', ], ], 'AlertTarget' => [ 'base' => '<p>A structure containing the alert target ARN and the role ARN.</p>', 'refs' => [ 'AlertTargets$value' => NULL, ], ], 'AlertTargetArn' => [ 'base' => NULL, 'refs' => [ 'AlertTarget$alertTargetArn' => '<p>The ARN of the notification target to which alerts are sent.</p>', ], ], 'AlertTargetType' => [ 'base' => '<p>The type of alert target: one of "SNS".</p>', 'refs' => [ 'AlertTargets$key' => NULL, ], ], 'AlertTargets' => [ 'base' => NULL, 'refs' => [ 'CreateSecurityProfileRequest$alertTargets' => '<p>Specifies the destinations to which alerts are sent. (Alerts are always sent to the console.) Alerts are generated when a device (thing) violates a behavior.</p>', 'DescribeSecurityProfileResponse$alertTargets' => '<p>Where the alerts are sent. (Alerts are always sent to the console.)</p>', 'UpdateSecurityProfileRequest$alertTargets' => '<p>Where the alerts are sent. (Alerts are always sent to the console.)</p>', 'UpdateSecurityProfileResponse$alertTargets' => '<p>Where the alerts are sent. (Alerts are always sent to the console.)</p>', ], ], 'AllowAuthorizerOverride' => [ 'base' => NULL, 'refs' => [ 'AuthorizerConfig$allowAuthorizerOverride' => '<p>A Boolean that specifies whether the domain configuration\'s authorization service can be overridden.</p>', ], ], 'AllowAutoRegistration' => [ 'base' => NULL, 'refs' => [ 'RegisterCACertificateRequest$allowAutoRegistration' => '<p>Allows this CA certificate to be used for auto registration of device certificates.</p>', ], ], 'Allowed' => [ 'base' => '<p>Contains information that allowed the authorization.</p>', 'refs' => [ 'AuthResult$allowed' => '<p>The policies and statements that allowed the specified action.</p>', ], ], 'ApproximateSecondsBeforeTimedOut' => [ 'base' => NULL, 'refs' => [ 'JobExecution$approximateSecondsBeforeTimedOut' => '<p>The estimated number of seconds that remain before the job execution status will be changed to <code>TIMED_OUT</code>. The timeout interval can be anywhere between 1 minute and 7 days (1 to 10080 minutes). The actual job execution timeout can occur up to 60 seconds later than the estimated duration. This value will not be included if the job execution has reached a terminal status.</p>', ], ], 'AscendingOrder' => [ 'base' => NULL, 'refs' => [ 'ListAuthorizersRequest$ascendingOrder' => '<p>Return the list of authorizers in ascending alphabetical order.</p>', 'ListCACertificatesRequest$ascendingOrder' => '<p>Determines the order of the results.</p>', 'ListCertificatesByCARequest$ascendingOrder' => '<p>Specifies the order for results. If True, the results are returned in ascending order, based on the creation date.</p>', 'ListCertificatesRequest$ascendingOrder' => '<p>Specifies the order for results. If True, the results are returned in ascending order, based on the creation date.</p>', 'ListOutgoingCertificatesRequest$ascendingOrder' => '<p>Specifies the order for results. If True, the results are returned in ascending order, based on the creation date.</p>', 'ListPoliciesRequest$ascendingOrder' => '<p>Specifies the order for results. If true, the results are returned in ascending creation order.</p>', 'ListPolicyPrincipalsRequest$ascendingOrder' => '<p>Specifies the order for results. If true, the results are returned in ascending creation order.</p>', 'ListPrincipalPoliciesRequest$ascendingOrder' => '<p>Specifies the order for results. If true, results are returned in ascending creation order.</p>', 'ListRoleAliasesRequest$ascendingOrder' => '<p>Return the list of role aliases in ascending alphabetical order.</p>', 'ListStreamsRequest$ascendingOrder' => '<p>Set to true to return the list of streams in ascending order.</p>', ], ], 'AssetId' => [ 'base' => NULL, 'refs' => [ 'PutAssetPropertyValueEntry$assetId' => '<p>The ID of the AWS IoT SiteWise asset. You must specify either a <code>propertyAlias</code> or both an <code>aliasId</code> and a <code>propertyId</code>. Accepts substitution templates.</p>', ], ], 'AssetPropertyAlias' => [ 'base' => NULL, 'refs' => [ 'PutAssetPropertyValueEntry$propertyAlias' => '<p>The name of the property alias associated with your asset property. You must specify either a <code>propertyAlias</code> or both an <code>aliasId</code> and a <code>propertyId</code>. Accepts substitution templates.</p>', ], ], 'AssetPropertyBooleanValue' => [ 'base' => NULL, 'refs' => [ 'AssetPropertyVariant$booleanValue' => '<p>Optional. A string that contains the boolean value (<code>true</code> or <code>false</code>) of the value entry. Accepts substitution templates.</p>', ], ], 'AssetPropertyDoubleValue' => [ 'base' => NULL, 'refs' => [ 'AssetPropertyVariant$doubleValue' => '<p>Optional. A string that contains the double value of the value entry. Accepts substitution templates.</p>', ], ], 'AssetPropertyEntryId' => [ 'base' => NULL, 'refs' => [ 'PutAssetPropertyValueEntry$entryId' => '<p>Optional. A unique identifier for this entry that you can define to better track which message caused an error in case of failure. Accepts substitution templates. Defaults to a new UUID.</p>', ], ], 'AssetPropertyId' => [ 'base' => NULL, 'refs' => [ 'PutAssetPropertyValueEntry$propertyId' => '<p>The ID of the asset\'s property. You must specify either a <code>propertyAlias</code> or both an <code>aliasId</code> and a <code>propertyId</code>. Accepts substitution templates.</p>', ], ], 'AssetPropertyIntegerValue' => [ 'base' => NULL, 'refs' => [ 'AssetPropertyVariant$integerValue' => '<p>Optional. A string that contains the integer value of the value entry. Accepts substitution templates.</p>', ], ], 'AssetPropertyOffsetInNanos' => [ 'base' => NULL, 'refs' => [ 'AssetPropertyTimestamp$offsetInNanos' => '<p>Optional. A string that contains the nanosecond time offset. Accepts substitution templates.</p>', ], ], 'AssetPropertyQuality' => [ 'base' => NULL, 'refs' => [ 'AssetPropertyValue$quality' => '<p>Optional. A string that describes the quality of the value. Accepts substitution templates. Must be <code>GOOD</code>, <code>BAD</code>, or <code>UNCERTAIN</code>.</p>', ], ], 'AssetPropertyStringValue' => [ 'base' => NULL, 'refs' => [ 'AssetPropertyVariant$stringValue' => '<p>Optional. The string value of the value entry. Accepts substitution templates.</p>', ], ], 'AssetPropertyTimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'AssetPropertyTimestamp$timeInSeconds' => '<p>A string that contains the time in seconds since epoch. Accepts substitution templates.</p>', ], ], 'AssetPropertyTimestamp' => [ 'base' => '<p>An asset property timestamp entry containing the following information.</p>', 'refs' => [ 'AssetPropertyValue$timestamp' => '<p>The asset property value timestamp.</p>', ], ], 'AssetPropertyValue' => [ 'base' => '<p>An asset property value entry containing the following information.</p>', 'refs' => [ 'AssetPropertyValueList$member' => NULL, ], ], 'AssetPropertyValueList' => [ 'base' => NULL, 'refs' => [ 'PutAssetPropertyValueEntry$propertyValues' => '<p>A list of property values to insert that each contain timestamp, quality, and value (TQV) information.</p>', ], ], 'AssetPropertyVariant' => [ 'base' => '<p>Contains an asset property value (of a single type).</p>', 'refs' => [ 'AssetPropertyValue$value' => '<p>The value of the asset property.</p>', ], ], 'AssociateTargetsWithJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateTargetsWithJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'AttachPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'AttachPrincipalPolicyRequest' => [ 'base' => '<p>The input for the AttachPrincipalPolicy operation.</p>', 'refs' => [], ], 'AttachSecurityProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'AttachSecurityProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'AttachThingPrincipalRequest' => [ 'base' => '<p>The input for the AttachThingPrincipal operation.</p>', 'refs' => [], ], 'AttachThingPrincipalResponse' => [ 'base' => '<p>The output from the AttachThingPrincipal operation.</p>', 'refs' => [], ], 'AttributeKey' => [ 'base' => NULL, 'refs' => [ 'AdditionalParameterMap$key' => NULL, 'AttributesMap$key' => NULL, ], ], 'AttributeName' => [ 'base' => NULL, 'refs' => [ 'Attributes$key' => NULL, 'ListThingsRequest$attributeName' => '<p>The attribute name used to search for things.</p>', 'SearchableAttributes$member' => NULL, ], ], 'AttributePayload' => [ 'base' => '<p>The attribute payload.</p>', 'refs' => [ 'CreateThingRequest$attributePayload' => '<p>The attribute payload, which consists of up to three name/value pairs in a JSON document. For example:</p> <p> <code>{\\"attributes\\":{\\"string1\\":\\"string2\\"}}</code> </p>', 'ThingGroupProperties$attributePayload' => '<p>The thing group attributes in JSON format.</p>', 'UpdateThingRequest$attributePayload' => '<p>A list of thing attributes, a JSON string containing name-value pairs. For example:</p> <p> <code>{\\"attributes\\":{\\"name1\\":\\"value2\\"}}</code> </p> <p>This data is used to add new attributes or update existing attributes.</p>', ], ], 'AttributeValue' => [ 'base' => NULL, 'refs' => [ 'Attributes$value' => NULL, 'ListThingsRequest$attributeValue' => '<p>The attribute value used to search for things.</p>', ], ], 'Attributes' => [ 'base' => NULL, 'refs' => [ 'AttributePayload$attributes' => '<p>A JSON string containing up to three key-value pair in JSON format. For example:</p> <p> <code>{\\"attributes\\":{\\"string1\\":\\"string2\\"}}</code> </p>', 'DescribeThingResponse$attributes' => '<p>The thing attributes.</p>', 'ThingAttribute$attributes' => '<p>A list of thing attributes which are name-value pairs.</p>', 'ThingDocument$attributes' => '<p>The attributes.</p>', 'ThingGroupDocument$attributes' => '<p>The thing group attributes.</p>', ], ], 'AttributesMap' => [ 'base' => NULL, 'refs' => [ 'OTAUpdateFile$attributes' => '<p>A list of name/attribute pairs.</p>', ], ], 'AuditCheckConfiguration' => [ 'base' => '<p>Which audit checks are enabled and disabled for this account.</p>', 'refs' => [ 'AuditCheckConfigurations$value' => NULL, ], ], 'AuditCheckConfigurations' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountAuditConfigurationResponse$auditCheckConfigurations' => '<p>Which audit checks are enabled and disabled for this account.</p>', 'UpdateAccountAuditConfigurationRequest$auditCheckConfigurations' => '<p>Specifies which audit checks are enabled and disabled for this account. Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are currently enabled.</p> <p>Some data collection might start immediately when certain checks are enabled. When a check is disabled, any data collected so far in relation to the check is deleted.</p> <p>You cannot disable a check if it is used by any scheduled audit. You must first delete the check from the scheduled audit or delete the scheduled audit itself.</p> <p>On the first call to <code>UpdateAccountAuditConfiguration</code>, this parameter is required and must specify at least one enabled check.</p>', ], ], 'AuditCheckDetails' => [ 'base' => '<p>Information about the audit check.</p>', 'refs' => [ 'AuditDetails$value' => NULL, ], ], 'AuditCheckName' => [ 'base' => '<p>An audit check name. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>', 'refs' => [ 'AuditCheckConfigurations$key' => NULL, 'AuditCheckToActionsMapping$key' => NULL, 'AuditCheckToReasonCodeFilter$key' => NULL, 'AuditDetails$key' => NULL, 'AuditFinding$checkName' => '<p>The audit check that generated this result.</p>', 'AuditMitigationActionsTaskStatistics$key' => NULL, 'ListAuditFindingsRequest$checkName' => '<p>A filter to limit results to the findings for the specified audit check.</p>', 'TargetAuditCheckNames$member' => NULL, ], ], 'AuditCheckRunStatus' => [ 'base' => NULL, 'refs' => [ 'AuditCheckDetails$checkRunStatus' => '<p>The completion status of this check. One of "IN_PROGRESS", "WAITING_FOR_DATA_COLLECTION", "CANCELED", "COMPLETED_COMPLIANT", "COMPLETED_NON_COMPLIANT", or "FAILED".</p>', ], ], 'AuditCheckToActionsMapping' => [ 'base' => NULL, 'refs' => [ 'DescribeAuditMitigationActionsTaskResponse$auditCheckToActionsMapping' => '<p>Specifies the mitigation actions that should be applied to specific audit checks.</p>', 'StartAuditMitigationActionsTaskRequest$auditCheckToActionsMapping' => '<p>For an audit check, specifies which mitigation actions to apply. Those actions must be defined in your AWS account.</p>', ], ], 'AuditCheckToReasonCodeFilter' => [ 'base' => NULL, 'refs' => [ 'AuditMitigationActionsTaskTarget$auditCheckToReasonCodeFilter' => '<p>Specifies a filter in the form of an audit check and set of reason codes that identify the findings from the audit to which the audit mitigation actions task apply.</p>', ], ], 'AuditDetails' => [ 'base' => NULL, 'refs' => [ 'DescribeAuditTaskResponse$auditDetails' => '<p>Detailed information about each check performed during this audit.</p>', ], ], 'AuditFinding' => [ 'base' => '<p>The findings (results) of the audit.</p>', 'refs' => [ 'AuditFindings$member' => NULL, 'DescribeAuditFindingResponse$finding' => NULL, ], ], 'AuditFindingSeverity' => [ 'base' => NULL, 'refs' => [ 'AuditFinding$severity' => '<p>The severity of the result (finding).</p>', ], ], 'AuditFindings' => [ 'base' => NULL, 'refs' => [ 'ListAuditFindingsResponse$findings' => '<p>The findings (results) of the audit.</p>', ], ], 'AuditFrequency' => [ 'base' => NULL, 'refs' => [ 'CreateScheduledAuditRequest$frequency' => '<p>How often the scheduled audit takes place. Can be one of "DAILY", "WEEKLY", "BIWEEKLY" or "MONTHLY". The start time of each audit is determined by the system.</p>', 'DescribeScheduledAuditResponse$frequency' => '<p>How often the scheduled audit takes place. One of "DAILY", "WEEKLY", "BIWEEKLY", or "MONTHLY". The start time of each audit is determined by the system.</p>', 'ScheduledAuditMetadata$frequency' => '<p>How often the scheduled audit occurs.</p>', 'UpdateScheduledAuditRequest$frequency' => '<p>How often the scheduled audit takes place. Can be one of "DAILY", "WEEKLY", "BIWEEKLY", or "MONTHLY". The start time of each audit is determined by the system.</p>', ], ], 'AuditMitigationActionExecutionMetadata' => [ 'base' => '<p>Returned by ListAuditMitigationActionsTask, this object contains information that describes a mitigation action that has been started.</p>', 'refs' => [ 'AuditMitigationActionExecutionMetadataList$member' => NULL, ], ], 'AuditMitigationActionExecutionMetadataList' => [ 'base' => NULL, 'refs' => [ 'ListAuditMitigationActionsExecutionsResponse$actionsExecutions' => '<p>A set of task execution results based on the input parameters. Details include the mitigation action applied, start time, and task status.</p>', ], ], 'AuditMitigationActionsExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'AuditMitigationActionExecutionMetadata$status' => '<p>The current status of the task being executed.</p>', 'ListAuditMitigationActionsExecutionsRequest$actionStatus' => '<p>Specify this filter to limit results to those with a specific status.</p>', ], ], 'AuditMitigationActionsTaskId' => [ 'base' => NULL, 'refs' => [ 'AuditMitigationActionExecutionMetadata$taskId' => '<p>The unique identifier for the task that applies the mitigation action.</p>', 'AuditMitigationActionsTaskMetadata$taskId' => '<p>The unique identifier for the task.</p>', 'CancelAuditMitigationActionsTaskRequest$taskId' => '<p>The unique identifier for the task that you want to cancel. </p>', 'DescribeAuditMitigationActionsTaskRequest$taskId' => '<p>The unique identifier for the audit mitigation task.</p>', 'ListAuditMitigationActionsExecutionsRequest$taskId' => '<p>Specify this filter to limit results to actions for a specific audit mitigation actions task.</p>', 'StartAuditMitigationActionsTaskRequest$taskId' => '<p>A unique identifier for the task. You can use this identifier to check the status of the task or to cancel it.</p>', 'StartAuditMitigationActionsTaskResponse$taskId' => '<p>The unique identifier for the audit mitigation task. This matches the <code>taskId</code> that you specified in the request.</p>', ], ], 'AuditMitigationActionsTaskMetadata' => [ 'base' => '<p>Information about an audit mitigation actions task that is returned by <code>ListAuditMitigationActionsTasks</code>.</p>', 'refs' => [ 'AuditMitigationActionsTaskMetadataList$member' => NULL, ], ], 'AuditMitigationActionsTaskMetadataList' => [ 'base' => NULL, 'refs' => [ 'ListAuditMitigationActionsTasksResponse$tasks' => '<p>The collection of audit mitigation tasks that matched the filter criteria.</p>', ], ], 'AuditMitigationActionsTaskStatistics' => [ 'base' => NULL, 'refs' => [ 'DescribeAuditMitigationActionsTaskResponse$taskStatistics' => '<p>Aggregate counts of the results when the mitigation tasks were applied to the findings for this audit mitigation actions task.</p>', ], ], 'AuditMitigationActionsTaskStatus' => [ 'base' => NULL, 'refs' => [ 'AuditMitigationActionsTaskMetadata$taskStatus' => '<p>The current state of the audit mitigation actions task.</p>', 'DescribeAuditMitigationActionsTaskResponse$taskStatus' => '<p>The current status of the task.</p>', 'ListAuditMitigationActionsTasksRequest$taskStatus' => '<p>Specify this filter to limit results to tasks that are in a specific state.</p>', ], ], 'AuditMitigationActionsTaskTarget' => [ 'base' => '<p>Used in MitigationActionParams, this information identifies the target findings to which the mitigation actions are applied. Only one entry appears.</p>', 'refs' => [ 'DescribeAuditMitigationActionsTaskResponse$target' => '<p>Identifies the findings to which the mitigation actions are applied. This can be by audit checks, by audit task, or a set of findings.</p>', 'StartAuditMitigationActionsTaskRequest$target' => '<p>Specifies the audit findings to which the mitigation actions are applied. You can apply them to a type of audit check, to all findings from an audit, or to a speecific set of findings.</p>', ], ], 'AuditNotificationTarget' => [ 'base' => '<p>Information about the targets to which audit notifications are sent.</p>', 'refs' => [ 'AuditNotificationTargetConfigurations$value' => NULL, ], ], 'AuditNotificationTargetConfigurations' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountAuditConfigurationResponse$auditNotificationTargetConfigurations' => '<p>Information about the targets to which audit notifications are sent for this account.</p>', 'UpdateAccountAuditConfigurationRequest$auditNotificationTargetConfigurations' => '<p>Information about the targets to which audit notifications are sent.</p>', ], ], 'AuditNotificationType' => [ 'base' => NULL, 'refs' => [ 'AuditNotificationTargetConfigurations$key' => NULL, ], ], 'AuditTaskId' => [ 'base' => NULL, 'refs' => [ 'AuditFinding$taskId' => '<p>The ID of the audit that generated this result (finding).</p>', 'AuditMitigationActionsTaskTarget$auditTaskId' => '<p>If the task will apply a mitigation action to findings from a specific audit, this value uniquely identifies the audit.</p>', 'AuditTaskMetadata$taskId' => '<p>The ID of this audit.</p>', 'CancelAuditTaskRequest$taskId' => '<p>The ID of the audit you want to cancel. You can only cancel an audit that is "IN_PROGRESS".</p>', 'DescribeAuditTaskRequest$taskId' => '<p>The ID of the audit whose information you want to get.</p>', 'ListAuditFindingsRequest$taskId' => '<p>A filter to limit results to the audit with the specified ID. You must specify either the taskId or the startTime and endTime, but not both.</p>', 'ListAuditMitigationActionsTasksRequest$auditTaskId' => '<p>Specify this filter to limit results to tasks that were applied to results for a specific audit.</p>', 'StartOnDemandAuditTaskResponse$taskId' => '<p>The ID of the on-demand audit you started.</p>', ], ], 'AuditTaskMetadata' => [ 'base' => '<p>The audits that were performed.</p>', 'refs' => [ 'AuditTaskMetadataList$member' => NULL, ], ], 'AuditTaskMetadataList' => [ 'base' => NULL, 'refs' => [ 'ListAuditTasksResponse$tasks' => '<p>The audits that were performed during the specified time period.</p>', ], ], 'AuditTaskStatus' => [ 'base' => NULL, 'refs' => [ 'AuditTaskMetadata$taskStatus' => '<p>The status of this audit. One of "IN_PROGRESS", "COMPLETED", "FAILED", or "CANCELED".</p>', 'DescribeAuditTaskResponse$taskStatus' => '<p>The status of the audit: one of "IN_PROGRESS", "COMPLETED", "FAILED", or "CANCELED".</p>', 'ListAuditTasksRequest$taskStatus' => '<p>A filter to limit the output to audits with the specified completion status: can be one of "IN_PROGRESS", "COMPLETED", "FAILED", or "CANCELED".</p>', ], ], 'AuditTaskType' => [ 'base' => NULL, 'refs' => [ 'AuditTaskMetadata$taskType' => '<p>The type of this audit. One of "ON_DEMAND_AUDIT_TASK" or "SCHEDULED_AUDIT_TASK".</p>', 'DescribeAuditTaskResponse$taskType' => '<p>The type of audit: "ON_DEMAND_AUDIT_TASK" or "SCHEDULED_AUDIT_TASK".</p>', 'ListAuditTasksRequest$taskType' => '<p>A filter to limit the output to the specified type of audit: can be one of "ON_DEMAND_AUDIT_TASK" or "SCHEDULED__AUDIT_TASK".</p>', ], ], 'AuthDecision' => [ 'base' => NULL, 'refs' => [ 'AuthResult$authDecision' => '<p>The final authorization decision of this scenario. Multiple statements are taken into account when determining the authorization decision. An explicit deny statement can override multiple allow statements.</p>', ], ], 'AuthInfo' => [ 'base' => '<p>A collection of authorization information.</p>', 'refs' => [ 'AuthInfos$member' => NULL, 'AuthResult$authInfo' => '<p>Authorization information.</p>', ], ], 'AuthInfos' => [ 'base' => NULL, 'refs' => [ 'TestAuthorizationRequest$authInfos' => '<p>A list of authorization info objects. Simulating authorization will create a response for each <code>authInfo</code> object in the list.</p>', ], ], 'AuthResult' => [ 'base' => '<p>The authorizer result.</p>', 'refs' => [ 'AuthResults$member' => NULL, ], ], 'AuthResults' => [ 'base' => NULL, 'refs' => [ 'TestAuthorizationResponse$authResults' => '<p>The authentication results.</p>', ], ], 'AuthorizerArn' => [ 'base' => NULL, 'refs' => [ 'AuthorizerDescription$authorizerArn' => '<p>The authorizer ARN.</p>', 'AuthorizerSummary$authorizerArn' => '<p>The authorizer ARN.</p>', 'CreateAuthorizerResponse$authorizerArn' => '<p>The authorizer ARN.</p>', 'SetDefaultAuthorizerResponse$authorizerArn' => '<p>The authorizer ARN.</p>', 'UpdateAuthorizerResponse$authorizerArn' => '<p>The authorizer ARN.</p>', ], ], 'AuthorizerConfig' => [ 'base' => '<p>An object that specifies the authorization service for a domain.</p>', 'refs' => [ 'CreateDomainConfigurationRequest$authorizerConfig' => '<p>An object that specifies the authorization service for a domain.</p>', 'DescribeDomainConfigurationResponse$authorizerConfig' => '<p>An object that specifies the authorization service for a domain.</p>', 'UpdateDomainConfigurationRequest$authorizerConfig' => '<p>An object that specifies the authorization service for a domain.</p>', ], ], 'AuthorizerDescription' => [ 'base' => '<p>The authorizer description.</p>', 'refs' => [ 'DescribeAuthorizerResponse$authorizerDescription' => '<p>The authorizer description.</p>', 'DescribeDefaultAuthorizerResponse$authorizerDescription' => '<p>The default authorizer\'s description.</p>', ], ], 'AuthorizerFunctionArn' => [ 'base' => NULL, 'refs' => [ 'AuthorizerDescription$authorizerFunctionArn' => '<p>The authorizer\'s Lambda function ARN.</p>', 'CreateAuthorizerRequest$authorizerFunctionArn' => '<p>The ARN of the authorizer\'s Lambda function.</p>', 'UpdateAuthorizerRequest$authorizerFunctionArn' => '<p>The ARN of the authorizer\'s Lambda function.</p>', ], ], 'AuthorizerName' => [ 'base' => NULL, 'refs' => [ 'AuthorizerConfig$defaultAuthorizerName' => '<p>The name of the authorization service for a domain configuration.</p>', 'AuthorizerDescription$authorizerName' => '<p>The authorizer name.</p>', 'AuthorizerSummary$authorizerName' => '<p>The authorizer name.</p>', 'CreateAuthorizerRequest$authorizerName' => '<p>The authorizer name.</p>', 'CreateAuthorizerResponse$authorizerName' => '<p>The authorizer\'s name.</p>', 'DeleteAuthorizerRequest$authorizerName' => '<p>The name of the authorizer to delete.</p>', 'DescribeAuthorizerRequest$authorizerName' => '<p>The name of the authorizer to describe.</p>', 'SetDefaultAuthorizerRequest$authorizerName' => '<p>The authorizer name.</p>', 'SetDefaultAuthorizerResponse$authorizerName' => '<p>The authorizer name.</p>', 'TestInvokeAuthorizerRequest$authorizerName' => '<p>The custom authorizer name.</p>', 'UpdateAuthorizerRequest$authorizerName' => '<p>The authorizer name.</p>', 'UpdateAuthorizerResponse$authorizerName' => '<p>The authorizer name.</p>', ], ], 'AuthorizerStatus' => [ 'base' => NULL, 'refs' => [ 'AuthorizerDescription$status' => '<p>The status of the authorizer.</p>', 'CreateAuthorizerRequest$status' => '<p>The status of the create authorizer request.</p>', 'ListAuthorizersRequest$status' => '<p>The status of the list authorizers request.</p>', 'UpdateAuthorizerRequest$status' => '<p>The status of the update authorizer request.</p>', ], ], 'AuthorizerSummary' => [ 'base' => '<p>The authorizer summary.</p>', 'refs' => [ 'Authorizers$member' => NULL, ], ], 'Authorizers' => [ 'base' => NULL, 'refs' => [ 'ListAuthorizersResponse$authorizers' => '<p>The authorizers.</p>', ], ], 'AutoRegistrationStatus' => [ 'base' => NULL, 'refs' => [ 'CACertificateDescription$autoRegistrationStatus' => '<p>Whether the CA certificate configured for auto registration of device certificates. Valid values are "ENABLE" and "DISABLE"</p>', 'UpdateCACertificateRequest$newAutoRegistrationStatus' => '<p>The new value for the auto registration status. Valid values are: "ENABLE" or "DISABLE".</p>', ], ], 'Average' => [ 'base' => NULL, 'refs' => [ 'Statistics$average' => '<p>The average of the aggregated field values.</p>', ], ], 'AwsAccountId' => [ 'base' => NULL, 'refs' => [ 'CACertificateDescription$ownedBy' => '<p>The owner of the CA certificate.</p>', 'CertificateDescription$ownedBy' => '<p>The ID of the AWS account that owns the certificate.</p>', 'CertificateDescription$previousOwnedBy' => '<p>The ID of the AWS account of the previous owner of the certificate.</p>', 'OutgoingCertificate$transferredTo' => '<p>The AWS account to which the transfer was made.</p>', 'ResourceIdentifier$account' => '<p>The account with which the resource is associated.</p>', 'RoleAliasDescription$owner' => '<p>The role alias owner.</p>', 'TransferCertificateRequest$targetAwsAccount' => '<p>The AWS account.</p>', ], ], 'AwsArn' => [ 'base' => NULL, 'refs' => [ 'CloudwatchAlarmAction$roleArn' => '<p>The IAM role that allows access to the CloudWatch alarm.</p>', 'CloudwatchLogsAction$roleArn' => '<p>The IAM role that allows access to the CloudWatch log.</p>', 'CloudwatchMetricAction$roleArn' => '<p>The IAM role that allows access to the CloudWatch metric.</p>', 'DeleteTopicRuleDestinationRequest$arn' => '<p>The ARN of the topic rule destination to delete.</p>', 'DynamoDBAction$roleArn' => '<p>The ARN of the IAM role that grants access to the DynamoDB table.</p>', 'DynamoDBv2Action$roleArn' => '<p>The ARN of the IAM role that grants access to the DynamoDB table.</p>', 'ElasticsearchAction$roleArn' => '<p>The IAM role ARN that has access to Elasticsearch.</p>', 'FirehoseAction$roleArn' => '<p>The IAM role that grants access to the Amazon Kinesis Firehose stream.</p>', 'GetLoggingOptionsResponse$roleArn' => '<p>The ARN of the IAM role that grants access.</p>', 'GetTopicRuleDestinationRequest$arn' => '<p>The ARN of the topic rule destination.</p>', 'GetV2LoggingOptionsResponse$roleArn' => '<p>The IAM role ARN AWS IoT uses to write to your CloudWatch logs.</p>', 'IotAnalyticsAction$channelArn' => '<p>(deprecated) The ARN of the IoT Analytics channel to which message data will be sent.</p>', 'IotAnalyticsAction$roleArn' => '<p>The ARN of the role which has a policy that grants IoT Analytics permission to send message data via IoT Analytics (iotanalytics:BatchPutMessage).</p>', 'IotEventsAction$roleArn' => '<p>The ARN of the role that grants AWS IoT permission to send an input to an AWS IoT Events detector. ("Action":"iotevents:BatchPutMessage").</p>', 'IotSiteWiseAction$roleArn' => '<p>The ARN of the role that grants AWS IoT permission to send an asset property value to AWS IoTSiteWise. (<code>"Action": "iotsitewise:BatchPutAssetPropertyValue"</code>). The trust policy can restrict access to specific asset hierarchy paths.</p>', 'KinesisAction$roleArn' => '<p>The ARN of the IAM role that grants access to the Amazon Kinesis stream.</p>', 'LoggingOptionsPayload$roleArn' => '<p>The ARN of the IAM role that grants access.</p>', 'RepublishAction$roleArn' => '<p>The ARN of the IAM role that grants access.</p>', 'S3Action$roleArn' => '<p>The ARN of the IAM role that grants access.</p>', 'SetV2LoggingOptionsRequest$roleArn' => '<p>The ARN of the role that allows IoT to write to Cloudwatch logs.</p>', 'SigV4Authorization$roleArn' => '<p>The ARN of the signing role.</p>', 'SnsAction$targetArn' => '<p>The ARN of the SNS topic.</p>', 'SnsAction$roleArn' => '<p>The ARN of the IAM role that grants access.</p>', 'SqsAction$roleArn' => '<p>The ARN of the IAM role that grants access.</p>', 'StepFunctionsAction$roleArn' => '<p>The ARN of the role that grants IoT permission to start execution of a state machine ("Action":"states:StartExecution").</p>', 'TopicRuleDestination$arn' => '<p>The topic rule destination URL.</p>', 'TopicRuleDestinationSummary$arn' => '<p>The topic rule destination ARN.</p>', 'UpdateTopicRuleDestinationRequest$arn' => '<p>The ARN of the topic rule destination.</p>', ], ], 'AwsIotJobArn' => [ 'base' => NULL, 'refs' => [ 'CreateOTAUpdateResponse$awsIotJobArn' => '<p>The AWS IoT job ARN associated with the OTA update.</p>', 'OTAUpdateInfo$awsIotJobArn' => '<p>The AWS IoT job ARN associated with the OTA update.</p>', ], ], 'AwsIotJobId' => [ 'base' => NULL, 'refs' => [ 'CreateOTAUpdateResponse$awsIotJobId' => '<p>The AWS IoT job ID associated with the OTA update.</p>', 'OTAUpdateInfo$awsIotJobId' => '<p>The AWS IoT job ID associated with the OTA update.</p>', ], ], 'AwsIotSqlVersion' => [ 'base' => NULL, 'refs' => [ 'TopicRule$awsIotSqlVersion' => '<p>The version of the SQL rules engine to use when evaluating the rule.</p>', 'TopicRulePayload$awsIotSqlVersion' => '<p>The version of the SQL rules engine to use when evaluating the rule.</p>', ], ], 'AwsJobAbortConfig' => [ 'base' => '<p>The criteria that determine when and how a job abort takes place.</p>', 'refs' => [ 'CreateOTAUpdateRequest$awsJobAbortConfig' => '<p>The criteria that determine when and how a job abort takes place.</p>', ], ], 'AwsJobAbortCriteria' => [ 'base' => '<p>The criteria that determine when and how a job abort takes place.</p>', 'refs' => [ 'AwsJobAbortCriteriaList$member' => NULL, ], ], 'AwsJobAbortCriteriaAbortAction' => [ 'base' => NULL, 'refs' => [ 'AwsJobAbortCriteria$action' => '<p>The type of job action to take to initiate the job abort.</p>', ], ], 'AwsJobAbortCriteriaAbortThresholdPercentage' => [ 'base' => NULL, 'refs' => [ 'AwsJobAbortCriteria$thresholdPercentage' => '<p>The minimum percentage of job execution failures that must occur to initiate the job abort.</p> <p>AWS IoT supports up to two digits after the decimal (for example, 10.9 and 10.99, but not 10.999).</p>', ], ], 'AwsJobAbortCriteriaFailureType' => [ 'base' => NULL, 'refs' => [ 'AwsJobAbortCriteria$failureType' => '<p>The type of job execution failures that can initiate a job abort.</p>', ], ], 'AwsJobAbortCriteriaList' => [ 'base' => NULL, 'refs' => [ 'AwsJobAbortConfig$abortCriteriaList' => '<p>The list of criteria that determine when and how to abort the job.</p>', ], ], 'AwsJobAbortCriteriaMinimumNumberOfExecutedThings' => [ 'base' => NULL, 'refs' => [ 'AwsJobAbortCriteria$minNumberOfExecutedThings' => '<p>The minimum number of things which must receive job execution notifications before the job can be aborted.</p>', ], ], 'AwsJobExecutionsRolloutConfig' => [ 'base' => '<p>Configuration for the rollout of OTA updates.</p>', 'refs' => [ 'CreateOTAUpdateRequest$awsJobExecutionsRolloutConfig' => '<p>Configuration for the rollout of OTA updates.</p>', 'OTAUpdateInfo$awsJobExecutionsRolloutConfig' => '<p>Configuration for the rollout of OTA updates.</p>', ], ], 'AwsJobExponentialRolloutRate' => [ 'base' => '<p>The rate of increase for a job rollout. This parameter allows you to define an exponential rate increase for a job rollout.</p>', 'refs' => [ 'AwsJobExecutionsRolloutConfig$exponentialRate' => '<p>The rate of increase for a job rollout. This parameter allows you to define an exponential rate increase for a job rollout.</p>', ], ], 'AwsJobPresignedUrlConfig' => [ 'base' => '<p>Configuration information for pre-signed URLs. Valid when <code>protocols</code> contains HTTP.</p>', 'refs' => [ 'CreateOTAUpdateRequest$awsJobPresignedUrlConfig' => '<p>Configuration information for pre-signed URLs.</p>', 'OTAUpdateInfo$awsJobPresignedUrlConfig' => '<p>Configuration information for pre-signed URLs. Valid when <code>protocols</code> contains HTTP.</p>', ], ], 'AwsJobRateIncreaseCriteria' => [ 'base' => '<p>The criteria to initiate the increase in rate of rollout for a job.</p>', 'refs' => [ 'AwsJobExponentialRolloutRate$rateIncreaseCriteria' => '<p>The criteria to initiate the increase in rate of rollout for a job.</p> <p>AWS IoT supports up to one digit after the decimal (for example, 1.5, but not 1.55).</p>', ], ], 'AwsJobRateIncreaseCriteriaNumberOfThings' => [ 'base' => NULL, 'refs' => [ 'AwsJobRateIncreaseCriteria$numberOfNotifiedThings' => '<p>When this number of things have been notified, it will initiate an increase in the rollout rate.</p>', 'AwsJobRateIncreaseCriteria$numberOfSucceededThings' => '<p>When this number of things have succeeded in their job execution, it will initiate an increase in the rollout rate.</p>', ], ], 'AwsJobRolloutIncrementFactor' => [ 'base' => NULL, 'refs' => [ 'AwsJobExponentialRolloutRate$incrementFactor' => '<p>The rate of increase for a job rollout. The number of things notified is multiplied by this factor.</p>', ], ], 'AwsJobRolloutRatePerMinute' => [ 'base' => NULL, 'refs' => [ 'AwsJobExponentialRolloutRate$baseRatePerMinute' => '<p>The minimum number of things that will be notified of a pending job, per minute, at the start of the job rollout. This is the initial rate of the rollout.</p>', ], ], 'AwsJobTimeoutConfig' => [ 'base' => '<p>Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.</p>', 'refs' => [ 'CreateOTAUpdateRequest$awsJobTimeoutConfig' => '<p>Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.</p>', ], ], 'AwsJobTimeoutInProgressTimeoutInMinutes' => [ 'base' => NULL, 'refs' => [ 'AwsJobTimeoutConfig$inProgressTimeoutInMinutes' => '<p>Specifies the amount of time, in minutes, this device has to finish execution of this job. The timeout interval can be anywhere between 1 minute and 7 days (1 to 10080 minutes). The in progress timer can\'t be updated and will apply to all job executions for the job. Whenever a job execution remains in the IN_PROGRESS status for longer than this interval, the job execution will fail and switch to the terminal <code>TIMED_OUT</code> status.</p>', ], ], 'Behavior' => [ 'base' => '<p>A Device Defender security profile behavior.</p>', 'refs' => [ 'ActiveViolation$behavior' => '<p>The behavior which is being violated.</p>', 'Behaviors$member' => NULL, 'ViolationEvent$behavior' => '<p>The behavior which was violated.</p>', ], ], 'BehaviorCriteria' => [ 'base' => '<p>The criteria by which the behavior is determined to be normal.</p>', 'refs' => [ 'Behavior$criteria' => '<p>The criteria that determine if a device is behaving normally in regard to the <code>metric</code>.</p>', ], ], 'BehaviorMetric' => [ 'base' => NULL, 'refs' => [ 'AdditionalMetricsToRetainList$member' => NULL, 'Behavior$metric' => '<p>What is measured by the behavior.</p>', 'MetricToRetain$metric' => '<p>What is measured by the behavior.</p>', ], ], 'BehaviorName' => [ 'base' => NULL, 'refs' => [ 'Behavior$name' => '<p>The name you have given to the behavior.</p>', ], ], 'Behaviors' => [ 'base' => NULL, 'refs' => [ 'CreateSecurityProfileRequest$behaviors' => '<p>Specifies the behaviors that, when violated by a device (thing), cause an alert.</p>', 'DescribeSecurityProfileResponse$behaviors' => '<p>Specifies the behaviors that, when violated by a device (thing), cause an alert.</p>', 'UpdateSecurityProfileRequest$behaviors' => '<p>Specifies the behaviors that, when violated by a device (thing), cause an alert.</p>', 'UpdateSecurityProfileResponse$behaviors' => '<p>Specifies the behaviors that, when violated by a device (thing), cause an alert.</p>', 'ValidateSecurityProfileBehaviorsRequest$behaviors' => '<p>Specifies the behaviors that, when violated by a device (thing), cause an alert.</p>', ], ], 'BillingGroupArn' => [ 'base' => NULL, 'refs' => [ 'AddThingToBillingGroupRequest$billingGroupArn' => '<p>The ARN of the billing group.</p>', 'CreateBillingGroupResponse$billingGroupArn' => '<p>The ARN of the billing group.</p>', 'DescribeBillingGroupResponse$billingGroupArn' => '<p>The ARN of the billing group.</p>', 'RemoveThingFromBillingGroupRequest$billingGroupArn' => '<p>The ARN of the billing group.</p>', ], ], 'BillingGroupDescription' => [ 'base' => NULL, 'refs' => [ 'BillingGroupProperties$billingGroupDescription' => '<p>The description of the billing group.</p>', ], ], 'BillingGroupId' => [ 'base' => NULL, 'refs' => [ 'CreateBillingGroupResponse$billingGroupId' => '<p>The ID of the billing group.</p>', 'DescribeBillingGroupResponse$billingGroupId' => '<p>The ID of the billing group.</p>', ], ], 'BillingGroupMetadata' => [ 'base' => '<p>Additional information about the billing group.</p>', 'refs' => [ 'DescribeBillingGroupResponse$billingGroupMetadata' => '<p>Additional information about the billing group.</p>', ], ], 'BillingGroupName' => [ 'base' => NULL, 'refs' => [ 'AddThingToBillingGroupRequest$billingGroupName' => '<p>The name of the billing group.</p>', 'CreateBillingGroupRequest$billingGroupName' => '<p>The name you wish to give to the billing group.</p>', 'CreateBillingGroupResponse$billingGroupName' => '<p>The name you gave to the billing group.</p>', 'CreateThingRequest$billingGroupName' => '<p>The name of the billing group the thing will be added to.</p>', 'DeleteBillingGroupRequest$billingGroupName' => '<p>The name of the billing group.</p>', 'DescribeBillingGroupRequest$billingGroupName' => '<p>The name of the billing group.</p>', 'DescribeBillingGroupResponse$billingGroupName' => '<p>The name of the billing group.</p>', 'DescribeThingResponse$billingGroupName' => '<p>The name of the billing group the thing belongs to.</p>', 'ListBillingGroupsRequest$namePrefixFilter' => '<p>Limit the results to billing groups whose names have the given prefix.</p>', 'ListThingsInBillingGroupRequest$billingGroupName' => '<p>The name of the billing group.</p>', 'RemoveThingFromBillingGroupRequest$billingGroupName' => '<p>The name of the billing group.</p>', 'UpdateBillingGroupRequest$billingGroupName' => '<p>The name of the billing group.</p>', ], ], 'BillingGroupNameAndArnList' => [ 'base' => NULL, 'refs' => [ 'ListBillingGroupsResponse$billingGroups' => '<p>The list of billing groups.</p>', ], ], 'BillingGroupProperties' => [ 'base' => '<p>The properties of a billing group.</p>', 'refs' => [ 'CreateBillingGroupRequest$billingGroupProperties' => '<p>The properties of the billing group.</p>', 'DescribeBillingGroupResponse$billingGroupProperties' => '<p>The properties of the billing group.</p>', 'UpdateBillingGroupRequest$billingGroupProperties' => '<p>The properties of the billing group.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'ThingConnectivity$connected' => '<p>True if the thing is connected to the AWS IoT service; false if it is not connected.</p>', 'ThingTypeMetadata$deprecated' => '<p>Whether the thing type is deprecated. If <b>true</b>, no new things could be associated with this type.</p>', ], ], 'BooleanKey' => [ 'base' => NULL, 'refs' => [ 'AuthorizerDescription$signingDisabled' => '<p>Specifies whether AWS IoT validates the token signature in an authorization request.</p>', 'CreateAuthorizerRequest$signingDisabled' => '<p>Specifies whether AWS IoT validates the token signature in an authorization request.</p>', ], ], 'BucketName' => [ 'base' => NULL, 'refs' => [ 'S3Action$bucketName' => '<p>The Amazon S3 bucket.</p>', ], ], 'CACertificate' => [ 'base' => '<p>A CA certificate.</p>', 'refs' => [ 'CACertificates$member' => NULL, ], ], 'CACertificateDescription' => [ 'base' => '<p>Describes a CA certificate.</p>', 'refs' => [ 'DescribeCACertificateResponse$certificateDescription' => '<p>The CA certificate description.</p>', ], ], 'CACertificateStatus' => [ 'base' => NULL, 'refs' => [ 'CACertificate$status' => '<p>The status of the CA certificate.</p> <p>The status value REGISTER_INACTIVE is deprecated and should not be used.</p>', 'CACertificateDescription$status' => '<p>The status of a CA certificate.</p>', 'UpdateCACertificateRequest$newStatus' => '<p>The updated status of the CA certificate.</p> <p> <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.</p>', ], ], 'CACertificateUpdateAction' => [ 'base' => NULL, 'refs' => [ 'UpdateCACertificateParams$action' => '<p>The action that you want to apply to the CA cerrtificate. The only supported value is <code>DEACTIVATE</code>.</p>', ], ], 'CACertificates' => [ 'base' => NULL, 'refs' => [ 'ListCACertificatesResponse$certificates' => '<p>The CA certificates registered in your AWS account.</p>', ], ], 'CancelAuditMitigationActionsTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelAuditMitigationActionsTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'CancelAuditTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelAuditTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'CancelCertificateTransferRequest' => [ 'base' => '<p>The input for the CancelCertificateTransfer operation.</p>', 'refs' => [], ], 'CancelJobExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CanceledChecksCount' => [ 'base' => NULL, 'refs' => [ 'TaskStatistics$canceledChecks' => '<p>The number of checks that did not run because the audit was canceled.</p>', ], ], 'CanceledFindingsCount' => [ 'base' => NULL, 'refs' => [ 'TaskStatisticsForAuditCheck$canceledFindingsCount' => '<p>The number of findings to which the mitigation action task was canceled when applied.</p>', ], ], 'CanceledThings' => [ 'base' => NULL, 'refs' => [ 'JobProcessDetails$numberOfCanceledThings' => '<p>The number of things that cancelled the job.</p>', ], ], 'CannedAccessControlList' => [ 'base' => NULL, 'refs' => [ 'S3Action$cannedAcl' => '<p>The Amazon S3 canned ACL that controls access to the object identified by the object key. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3 canned ACLs</a>.</p>', ], ], 'Certificate' => [ 'base' => '<p>Information about a certificate.</p>', 'refs' => [ 'Certificates$member' => NULL, ], ], 'CertificateArn' => [ 'base' => NULL, 'refs' => [ 'CACertificate$certificateArn' => '<p>The ARN of the CA certificate.</p>', 'CACertificateDescription$certificateArn' => '<p>The CA certificate ARN.</p>', 'Certificate$certificateArn' => '<p>The ARN of the certificate.</p>', 'CertificateDescription$certificateArn' => '<p>The ARN of the certificate.</p>', 'CreateCertificateFromCsrResponse$certificateArn' => '<p>The Amazon Resource Name (ARN) of the certificate. You can use the ARN as a principal for policy operations.</p>', 'CreateKeysAndCertificateResponse$certificateArn' => '<p>The ARN of the certificate.</p>', 'OutgoingCertificate$certificateArn' => '<p>The certificate ARN.</p>', 'RegisterCACertificateResponse$certificateArn' => '<p>The CA certificate ARN.</p>', 'RegisterCertificateResponse$certificateArn' => '<p>The certificate ARN.</p>', 'RegisterCertificateWithoutCAResponse$certificateArn' => '<p>The Amazon Resource Name (ARN) of the registered certificate.</p>', 'SigningProfileParameter$certificateArn' => '<p>Certificate ARN.</p>', 'TransferCertificateResponse$transferredCertificateArn' => '<p>The ARN of the certificate.</p>', ], ], 'CertificateConflictException' => [ 'base' => '<p>Unable to verify the CA certificate used to sign the device certificate you are attempting to register. This is happens when you have registered more than one CA certificate that has the same subject field and public key.</p>', 'refs' => [], ], 'CertificateDescription' => [ 'base' => '<p>Describes a certificate.</p>', 'refs' => [ 'DescribeCertificateResponse$certificateDescription' => '<p>The description of the certificate.</p>', ], ], 'CertificateId' => [ 'base' => NULL, 'refs' => [ 'AcceptCertificateTransferRequest$certificateId' => '<p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>', 'CACertificate$certificateId' => '<p>The ID of the CA certificate.</p>', 'CACertificateDescription$certificateId' => '<p>The CA certificate ID.</p>', 'CancelCertificateTransferRequest$certificateId' => '<p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>', 'Certificate$certificateId' => '<p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>', 'CertificateDescription$certificateId' => '<p>The ID of the certificate.</p>', 'CertificateDescription$caCertificateId' => '<p>The certificate ID of the CA certificate used to sign this certificate.</p>', 'CreateCertificateFromCsrResponse$certificateId' => '<p>The ID of the certificate. Certificate management operations only take a certificateId.</p>', 'CreateKeysAndCertificateResponse$certificateId' => '<p>The ID of the certificate. AWS IoT issues a default subject name for the certificate (for example, AWS IoT Certificate).</p>', 'CreateProvisioningClaimResponse$certificateId' => '<p>The ID of the certificate.</p>', 'DeleteCACertificateRequest$certificateId' => '<p>The ID of the certificate to delete. (The last part of the certificate ARN contains the certificate ID.)</p>', 'DeleteCertificateRequest$certificateId' => '<p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>', 'DescribeCACertificateRequest$certificateId' => '<p>The CA certificate identifier.</p>', 'DescribeCertificateRequest$certificateId' => '<p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>', 'ListCertificatesByCARequest$caCertificateId' => '<p>The ID of the CA certificate. This operation will list all registered device certificate that were signed by this CA certificate.</p>', 'OutgoingCertificate$certificateId' => '<p>The certificate ID.</p>', 'RegisterCACertificateResponse$certificateId' => '<p>The CA certificate identifier.</p>', 'RegisterCertificateResponse$certificateId' => '<p>The certificate identifier.</p>', 'RegisterCertificateWithoutCAResponse$certificateId' => '<p>The ID of the registered certificate. (The last part of the certificate ARN contains the certificate ID.</p>', 'RejectCertificateTransferRequest$certificateId' => '<p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>', 'ResourceIdentifier$deviceCertificateId' => '<p>The ID of the certificate attached to the resource.</p>', 'ResourceIdentifier$caCertificateId' => '<p>The ID of the CA certificate used to authorize the certificate.</p>', 'TransferCertificateRequest$certificateId' => '<p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>', 'UpdateCACertificateRequest$certificateId' => '<p>The CA certificate identifier.</p>', 'UpdateCertificateRequest$certificateId' => '<p>The ID of the certificate. (The last part of the certificate ARN contains the certificate ID.)</p>', ], ], 'CertificateMode' => [ 'base' => NULL, 'refs' => [ 'Certificate$certificateMode' => '<p>The mode of the certificate.</p>', 'CertificateDescription$certificateMode' => '<p>The mode of the certificate.</p>', ], ], 'CertificateName' => [ 'base' => NULL, 'refs' => [ 'CodeSigningCertificateChain$certificateName' => '<p>The name of the certificate.</p>', ], ], 'CertificatePathOnDevice' => [ 'base' => NULL, 'refs' => [ 'SigningProfileParameter$certificatePathOnDevice' => '<p>The location of the code-signing certificate on your device.</p>', ], ], 'CertificatePem' => [ 'base' => '<p>The PEM of a certificate.</p>', 'refs' => [ 'CACertificateDescription$certificatePem' => '<p>The CA certificate data, in PEM format.</p>', 'CertificateDescription$certificatePem' => '<p>The certificate data, in PEM format.</p>', 'CreateCertificateFromCsrResponse$certificatePem' => '<p>The certificate data, in PEM format.</p>', 'CreateKeysAndCertificateResponse$certificatePem' => '<p>The certificate data, in PEM format.</p>', 'CreateProvisioningClaimResponse$certificatePem' => '<p>The provisioning claim certificate.</p>', 'RegisterCACertificateRequest$caCertificate' => '<p>The CA certificate.</p>', 'RegisterCACertificateRequest$verificationCertificate' => '<p>The private key verification certificate.</p>', 'RegisterCertificateRequest$certificatePem' => '<p>The certificate data, in PEM format.</p>', 'RegisterCertificateRequest$caCertificatePem' => '<p>The CA certificate used to sign the device certificate being registered.</p>', 'RegisterCertificateWithoutCARequest$certificatePem' => '<p>The certificate data, in PEM format.</p>', 'RegisterThingResponse$certificatePem' => '<p>The certificate data, in PEM format.</p>', ], ], 'CertificateSigningRequest' => [ 'base' => NULL, 'refs' => [ 'CreateCertificateFromCsrRequest$certificateSigningRequest' => '<p>The certificate signing request (CSR).</p>', ], ], 'CertificateStateException' => [ 'base' => '<p>The certificate operation is not allowed.</p>', 'refs' => [], ], 'CertificateStatus' => [ 'base' => NULL, 'refs' => [ 'Certificate$status' => '<p>The status of the certificate.</p> <p>The status value REGISTER_INACTIVE is deprecated and should not be used.</p>', 'CertificateDescription$status' => '<p>The status of the certificate.</p>', 'RegisterCertificateRequest$status' => '<p>The status of the register certificate request.</p>', 'RegisterCertificateWithoutCARequest$status' => '<p>The status of the register certificate request.</p>', 'UpdateCertificateRequest$newStatus' => '<p>The new status.</p> <p> <b>Note:</b> Setting the status to PENDING_TRANSFER or PENDING_ACTIVATION will result in an exception being thrown. PENDING_TRANSFER and PENDING_ACTIVATION are statuses used internally by AWS IoT. They are not intended for developer use.</p> <p> <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.</p>', ], ], 'CertificateValidationException' => [ 'base' => '<p>The certificate is invalid.</p>', 'refs' => [], ], 'CertificateValidity' => [ 'base' => '<p>When the certificate is valid.</p>', 'refs' => [ 'CACertificateDescription$validity' => '<p>When the CA certificate is valid.</p>', 'CertificateDescription$validity' => '<p>When the certificate is valid.</p>', ], ], 'Certificates' => [ 'base' => NULL, 'refs' => [ 'ListCertificatesByCAResponse$certificates' => '<p>The device certificates signed by the specified CA certificate.</p>', 'ListCertificatesResponse$certificates' => '<p>The descriptions of the certificates.</p>', ], ], 'ChannelName' => [ 'base' => NULL, 'refs' => [ 'IotAnalyticsAction$channelName' => '<p>The name of the IoT Analytics channel to which message data will be sent.</p>', ], ], 'CheckCompliant' => [ 'base' => NULL, 'refs' => [ 'AuditCheckDetails$checkCompliant' => '<p>True if the check is complete and found all resources compliant.</p>', ], ], 'Cidr' => [ 'base' => NULL, 'refs' => [ 'Cidrs$member' => NULL, ], ], 'Cidrs' => [ 'base' => NULL, 'refs' => [ 'MetricValue$cidrs' => '<p>If the <code>comparisonOperator</code> calls for a set of CIDRs, use this to specify that set to be compared with the <code>metric</code>.</p>', ], ], 'ClearDefaultAuthorizerRequest' => [ 'base' => NULL, 'refs' => [], ], 'ClearDefaultAuthorizerResponse' => [ 'base' => NULL, 'refs' => [], ], 'ClientId' => [ 'base' => NULL, 'refs' => [ 'DescribeThingResponse$defaultClientId' => '<p>The default MQTT client ID. For a typical device, the thing name is also used as the default MQTT client ID. Although we don’t require a mapping between a thing\'s registry name and its use of MQTT client IDs, certificates, or shadow state, we recommend that you choose a thing name and use it as the MQTT client ID for the registry and the Device Shadow service.</p> <p>This lets you better organize your AWS IoT fleet without removing the flexibility of the underlying device certificate model or shadows.</p>', 'ResourceIdentifier$clientId' => '<p>The client ID.</p>', 'TestAuthorizationRequest$clientId' => '<p>The MQTT client ID.</p>', ], ], 'ClientRequestToken' => [ 'base' => NULL, 'refs' => [ 'CreateDimensionRequest$clientRequestToken' => '<p>Each dimension must have a unique client request token. If you try to create a new dimension with the same token as a dimension that already exists, an exception occurs. If you omit this value, AWS SDKs will automatically generate a unique client request.</p>', 'StartAuditMitigationActionsTaskRequest$clientRequestToken' => '<p>Each audit mitigation task must have a unique client request token. If you try to start a new task with the same token as a task that already exists, an exception occurs. If you omit this value, a unique client request token is generated automatically.</p>', ], ], 'CloudwatchAlarmAction' => [ 'base' => '<p>Describes an action that updates a CloudWatch alarm.</p>', 'refs' => [ 'Action$cloudwatchAlarm' => '<p>Change the state of a CloudWatch alarm.</p>', ], ], 'CloudwatchLogsAction' => [ 'base' => '<p>Describes an action that sends data to CloudWatch Logs.</p>', 'refs' => [ 'Action$cloudwatchLogs' => '<p>Send data to CloudWatch Logs.</p>', ], ], 'CloudwatchMetricAction' => [ 'base' => '<p>Describes an action that captures a CloudWatch metric.</p>', 'refs' => [ 'Action$cloudwatchMetric' => '<p>Capture a CloudWatch metric.</p>', ], ], 'Code' => [ 'base' => NULL, 'refs' => [ 'ErrorInfo$code' => '<p>The error code.</p>', ], ], 'CodeSigning' => [ 'base' => '<p>Describes the method to use when code signing a file.</p>', 'refs' => [ 'OTAUpdateFile$codeSigning' => '<p>The code signing method of the file.</p>', ], ], 'CodeSigningCertificateChain' => [ 'base' => '<p>Describes the certificate chain being used when code signing a file.</p>', 'refs' => [ 'CustomCodeSigning$certificateChain' => '<p>The certificate chain.</p>', ], ], 'CodeSigningSignature' => [ 'base' => '<p>Describes the signature for a file.</p>', 'refs' => [ 'CustomCodeSigning$signature' => '<p>The signature for the file.</p>', ], ], 'CognitoIdentityPoolId' => [ 'base' => NULL, 'refs' => [ 'GetEffectivePoliciesRequest$cognitoIdentityPoolId' => '<p>The Cognito identity pool ID.</p>', 'ResourceIdentifier$cognitoIdentityPoolId' => '<p>The ID of the Amazon Cognito identity pool.</p>', 'TestAuthorizationRequest$cognitoIdentityPoolId' => '<p>The Cognito identity pool ID.</p>', ], ], 'Comment' => [ 'base' => NULL, 'refs' => [ 'AssociateTargetsWithJobRequest$comment' => '<p>An optional comment string describing why the job was associated with the targets.</p>', 'CancelJobRequest$comment' => '<p>An optional comment string describing why the job was canceled.</p>', 'Job$comment' => '<p>If the job was updated, describes the reason for the update.</p>', ], ], 'ComparisonOperator' => [ 'base' => NULL, 'refs' => [ 'BehaviorCriteria$comparisonOperator' => '<p>The operator that relates the thing measured (<code>metric</code>) to the criteria (containing a <code>value</code> or <code>statisticalThreshold</code>).</p>', ], ], 'CompliantChecksCount' => [ 'base' => NULL, 'refs' => [ 'TaskStatistics$compliantChecks' => '<p>The number of checks that found compliant resources.</p>', ], ], 'Configuration' => [ 'base' => '<p>Configuration.</p>', 'refs' => [ 'EventConfigurations$value' => NULL, ], ], 'ConfirmTopicRuleDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'ConfirmTopicRuleDestinationResponse' => [ 'base' => NULL, 'refs' => [], ], 'ConfirmationToken' => [ 'base' => NULL, 'refs' => [ 'ConfirmTopicRuleDestinationRequest$confirmationToken' => '<p>The token used to confirm ownership or access to the topic rule confirmation URL.</p>', ], ], 'ConflictingResourceUpdateException' => [ 'base' => '<p>A conflicting resource update exception. This exception is thrown when two pending updates cause a conflict.</p>', 'refs' => [], ], 'ConnectivityTimestamp' => [ 'base' => NULL, 'refs' => [ 'ThingConnectivity$timestamp' => '<p>The epoch time (in milliseconds) when the thing last connected or disconnected. If the thing has been disconnected for more than a few weeks, the time value might be missing.</p>', ], ], 'ConsecutiveDatapointsToAlarm' => [ 'base' => NULL, 'refs' => [ 'BehaviorCriteria$consecutiveDatapointsToAlarm' => '<p>If a device is in violation of the behavior for the specified number of consecutive datapoints, an alarm occurs. If not specified, the default is 1.</p>', ], ], 'ConsecutiveDatapointsToClear' => [ 'base' => NULL, 'refs' => [ 'BehaviorCriteria$consecutiveDatapointsToClear' => '<p>If an alarm has occurred and the offending device is no longer in violation of the behavior for the specified number of consecutive datapoints, the alarm is cleared. If not specified, the default is 1.</p>', ], ], 'Count' => [ 'base' => NULL, 'refs' => [ 'DescribeThingRegistrationTaskResponse$successCount' => '<p>The number of things successfully provisioned.</p>', 'DescribeThingRegistrationTaskResponse$failureCount' => '<p>The number of things that failed to be provisioned.</p>', 'GetCardinalityResponse$cardinality' => '<p>The approximate count of unique values that match the query.</p>', 'Statistics$count' => '<p>The count of things that match the query.</p>', ], ], 'CreateAuthorizerRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAuthorizerResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateBillingGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateBillingGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateCertificateFromCsrRequest' => [ 'base' => '<p>The input for the CreateCertificateFromCsr operation.</p>', 'refs' => [], ], 'CreateCertificateFromCsrResponse' => [ 'base' => '<p>The output from the CreateCertificateFromCsr operation.</p>', 'refs' => [], ], 'CreateDimensionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDimensionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDomainConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDomainConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDynamicThingGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDynamicThingGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateKeysAndCertificateRequest' => [ 'base' => '<p>The input for the CreateKeysAndCertificate operation.</p>', 'refs' => [], ], 'CreateKeysAndCertificateResponse' => [ 'base' => '<p>The output of the CreateKeysAndCertificate operation.</p>', 'refs' => [], ], 'CreateMitigationActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMitigationActionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateOTAUpdateRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateOTAUpdateResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePolicyRequest' => [ 'base' => '<p>The input for the CreatePolicy operation.</p>', 'refs' => [], ], 'CreatePolicyResponse' => [ 'base' => '<p>The output from the CreatePolicy operation.</p>', 'refs' => [], ], 'CreatePolicyVersionRequest' => [ 'base' => '<p>The input for the CreatePolicyVersion operation.</p>', 'refs' => [], ], 'CreatePolicyVersionResponse' => [ 'base' => '<p>The output of the CreatePolicyVersion operation.</p>', 'refs' => [], ], 'CreateProvisioningClaimRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateProvisioningClaimResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateProvisioningTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateProvisioningTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateProvisioningTemplateVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateProvisioningTemplateVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRoleAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRoleAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateScheduledAuditRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateScheduledAuditResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSecurityProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSecurityProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateStreamRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateStreamResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateThingGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateThingGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateThingRequest' => [ 'base' => '<p>The input for the CreateThing operation.</p>', 'refs' => [], ], 'CreateThingResponse' => [ 'base' => '<p>The output of the CreateThing operation.</p>', 'refs' => [], ], 'CreateThingTypeRequest' => [ 'base' => '<p>The input for the CreateThingType operation.</p>', 'refs' => [], ], 'CreateThingTypeResponse' => [ 'base' => '<p>The output of the CreateThingType operation.</p>', 'refs' => [], ], 'CreateTopicRuleDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTopicRuleDestinationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTopicRuleRequest' => [ 'base' => '<p>The input for the CreateTopicRule operation.</p>', 'refs' => [], ], 'CreatedAtDate' => [ 'base' => NULL, 'refs' => [ 'TopicRule$createdAt' => '<p>The date and time the rule was created.</p>', 'TopicRuleListItem$createdAt' => '<p>The date and time the rule was created.</p>', ], ], 'CreationDate' => [ 'base' => NULL, 'refs' => [ 'BillingGroupMetadata$creationDate' => '<p>The date the billing group was created.</p>', 'DescribeEventConfigurationsResponse$creationDate' => '<p>The creation date of the event configuration.</p>', 'DescribeThingRegistrationTaskResponse$creationDate' => '<p>The task creation date.</p>', 'ThingGroupMetadata$creationDate' => '<p>The UNIX timestamp of when the thing group was created.</p>', 'ThingTypeMetadata$creationDate' => '<p>The date and time when the thing type was created.</p>', ], ], 'CredentialDurationSeconds' => [ 'base' => NULL, 'refs' => [ 'CreateRoleAliasRequest$credentialDurationSeconds' => '<p>How long (in seconds) the credentials will be valid.</p>', 'RoleAliasDescription$credentialDurationSeconds' => '<p>The number of seconds for which the credential is valid.</p>', 'UpdateRoleAliasRequest$credentialDurationSeconds' => '<p>The number of seconds the credential will be valid.</p>', ], ], 'CustomCodeSigning' => [ 'base' => '<p>Describes a custom method used to code sign a file.</p>', 'refs' => [ 'CodeSigning$customCodeSigning' => '<p>A custom method for code signing a file.</p>', ], ], 'CustomerVersion' => [ 'base' => NULL, 'refs' => [ 'CACertificateDescription$customerVersion' => '<p>The customer version of the CA certificate.</p>', 'CertificateDescription$customerVersion' => '<p>The customer version of the certificate.</p>', ], ], 'DateType' => [ 'base' => NULL, 'refs' => [ 'AuthorizerDescription$creationDate' => '<p>The UNIX timestamp of when the authorizer was created.</p>', 'AuthorizerDescription$lastModifiedDate' => '<p>The UNIX timestamp of when the authorizer was last updated.</p>', 'CACertificate$creationDate' => '<p>The date the CA certificate was created.</p>', 'CACertificateDescription$creationDate' => '<p>The date the CA certificate was created.</p>', 'CACertificateDescription$lastModifiedDate' => '<p>The date the CA certificate was last modified.</p>', 'Certificate$creationDate' => '<p>The date and time the certificate was created.</p>', 'CertificateDescription$creationDate' => '<p>The date and time the certificate was created.</p>', 'CertificateDescription$lastModifiedDate' => '<p>The date and time the certificate was last modified.</p>', 'CertificateValidity$notBefore' => '<p>The certificate is not valid before this date.</p>', 'CertificateValidity$notAfter' => '<p>The certificate is not valid after this date.</p>', 'CreateProvisioningClaimResponse$expiration' => '<p>The provisioning claim expiration time.</p>', 'DescribeProvisioningTemplateResponse$creationDate' => '<p>The date when the fleet provisioning template was created.</p>', 'DescribeProvisioningTemplateResponse$lastModifiedDate' => '<p>The date when the fleet provisioning template was last modified.</p>', 'DescribeProvisioningTemplateVersionResponse$creationDate' => '<p>The date when the fleet provisioning template version was created.</p>', 'GetPolicyResponse$creationDate' => '<p>The date the policy was created.</p>', 'GetPolicyResponse$lastModifiedDate' => '<p>The date the policy was last modified.</p>', 'GetPolicyVersionResponse$creationDate' => '<p>The date the policy was created.</p>', 'GetPolicyVersionResponse$lastModifiedDate' => '<p>The date the policy was last modified.</p>', 'Job$createdAt' => '<p>The time, in seconds since the epoch, when the job was created.</p>', 'Job$lastUpdatedAt' => '<p>The time, in seconds since the epoch, when the job was last updated.</p>', 'Job$completedAt' => '<p>The time, in seconds since the epoch, when the job was completed.</p>', 'JobExecution$queuedAt' => '<p>The time, in seconds since the epoch, when the job execution was queued.</p>', 'JobExecution$startedAt' => '<p>The time, in seconds since the epoch, when the job execution started.</p>', 'JobExecution$lastUpdatedAt' => '<p>The time, in seconds since the epoch, when the job execution was last updated.</p>', 'JobExecutionSummary$queuedAt' => '<p>The time, in seconds since the epoch, when the job execution was queued.</p>', 'JobExecutionSummary$startedAt' => '<p>The time, in seconds since the epoch, when the job execution started.</p>', 'JobExecutionSummary$lastUpdatedAt' => '<p>The time, in seconds since the epoch, when the job execution was last updated.</p>', 'JobSummary$createdAt' => '<p>The time, in seconds since the epoch, when the job was created.</p>', 'JobSummary$lastUpdatedAt' => '<p>The time, in seconds since the epoch, when the job was last updated.</p>', 'JobSummary$completedAt' => '<p>The time, in seconds since the epoch, when the job completed.</p>', 'OTAUpdateInfo$creationDate' => '<p>The date when the OTA update was created.</p>', 'OTAUpdateInfo$lastModifiedDate' => '<p>The date when the OTA update was last updated.</p>', 'OTAUpdateSummary$creationDate' => '<p>The date when the OTA update was created.</p>', 'OutgoingCertificate$transferDate' => '<p>The date the transfer was initiated.</p>', 'OutgoingCertificate$creationDate' => '<p>The certificate creation date.</p>', 'PolicyVersion$createDate' => '<p>The date and time the policy was created.</p>', 'ProvisioningTemplateSummary$creationDate' => '<p>The date when the fleet provisioning template summary was created.</p>', 'ProvisioningTemplateSummary$lastModifiedDate' => '<p>The date when the fleet provisioning template summary was last modified.</p>', 'ProvisioningTemplateVersionSummary$creationDate' => '<p>The date when the fleet provisioning template version was created</p>', 'RoleAliasDescription$creationDate' => '<p>The UNIX timestamp of when the role alias was created.</p>', 'RoleAliasDescription$lastModifiedDate' => '<p>The UNIX timestamp of when the role alias was last modified.</p>', 'StreamInfo$createdAt' => '<p>The date when the stream was created.</p>', 'StreamInfo$lastUpdatedAt' => '<p>The date when the stream was last updated.</p>', 'TransferData$transferDate' => '<p>The date the transfer took place.</p>', 'TransferData$acceptDate' => '<p>The date the transfer was accepted.</p>', 'TransferData$rejectDate' => '<p>The date the transfer was rejected.</p>', ], ], 'DayOfMonth' => [ 'base' => NULL, 'refs' => [ 'CreateScheduledAuditRequest$dayOfMonth' => '<p>The day of the month on which the scheduled audit takes place. Can be "1" through "31" or "LAST". This field is required if the "frequency" parameter is set to "MONTHLY". If days 29-31 are specified, and the month does not have that many days, the audit takes place on the "LAST" day of the month.</p>', 'DescribeScheduledAuditResponse$dayOfMonth' => '<p>The day of the month on which the scheduled audit takes place. Will be "1" through "31" or "LAST". If days 29-31 are specified, and the month does not have that many days, the audit takes place on the "LAST" day of the month.</p>', 'ScheduledAuditMetadata$dayOfMonth' => '<p>The day of the month on which the scheduled audit is run (if the <code>frequency</code> is "MONTHLY"). If days 29-31 are specified, and the month does not have that many days, the audit takes place on the "LAST" day of the month.</p>', 'UpdateScheduledAuditRequest$dayOfMonth' => '<p>The day of the month on which the scheduled audit takes place. Can be "1" through "31" or "LAST". This field is required if the "frequency" parameter is set to "MONTHLY". If days 29-31 are specified, and the month does not have that many days, the audit takes place on the "LAST" day of the month.</p>', ], ], 'DayOfWeek' => [ 'base' => NULL, 'refs' => [ 'CreateScheduledAuditRequest$dayOfWeek' => '<p>The day of the week on which the scheduled audit takes place. Can be one of "SUN", "MON", "TUE", "WED", "THU", "FRI", or "SAT". This field is required if the "frequency" parameter is set to "WEEKLY" or "BIWEEKLY".</p>', 'DescribeScheduledAuditResponse$dayOfWeek' => '<p>The day of the week on which the scheduled audit takes place. One of "SUN", "MON", "TUE", "WED", "THU", "FRI", or "SAT".</p>', 'ScheduledAuditMetadata$dayOfWeek' => '<p>The day of the week on which the scheduled audit is run (if the <code>frequency</code> is "WEEKLY" or "BIWEEKLY").</p>', 'UpdateScheduledAuditRequest$dayOfWeek' => '<p>The day of the week on which the scheduled audit takes place. Can be one of "SUN", "MON", "TUE", "WED", "THU", "FRI", or "SAT". This field is required if the "frequency" parameter is set to "WEEKLY" or "BIWEEKLY".</p>', ], ], 'DeleteAccountAuditConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccountAuditConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAdditionalMetricsToRetain' => [ 'base' => NULL, 'refs' => [ 'UpdateSecurityProfileRequest$deleteAdditionalMetricsToRetain' => '<p>If true, delete all <code>additionalMetricsToRetain</code> defined for this security profile. If any <code>additionalMetricsToRetain</code> are defined in the current invocation, an exception occurs.</p>', ], ], 'DeleteAlertTargets' => [ 'base' => NULL, 'refs' => [ 'UpdateSecurityProfileRequest$deleteAlertTargets' => '<p>If true, delete all <code>alertTargets</code> defined for this security profile. If any <code>alertTargets</code> are defined in the current invocation, an exception occurs.</p>', ], ], 'DeleteAuthorizerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAuthorizerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBehaviors' => [ 'base' => NULL, 'refs' => [ 'UpdateSecurityProfileRequest$deleteBehaviors' => '<p>If true, delete all <code>behaviors</code> defined for this security profile. If any <code>behaviors</code> are defined in the current invocation, an exception occurs.</p>', ], ], 'DeleteBillingGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteBillingGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCACertificateRequest' => [ 'base' => '<p>Input for the DeleteCACertificate operation.</p>', 'refs' => [], ], 'DeleteCACertificateResponse' => [ 'base' => '<p>The output for the DeleteCACertificate operation.</p>', 'refs' => [], ], 'DeleteCertificateRequest' => [ 'base' => '<p>The input for the DeleteCertificate operation.</p>', 'refs' => [], ], 'DeleteConflictException' => [ 'base' => '<p>You can\'t delete the resource because it is attached to one or more resources.</p>', 'refs' => [], ], 'DeleteDimensionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDimensionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDomainConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDomainConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDynamicThingGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDynamicThingGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteJobExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMitigationActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMitigationActionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteOTAUpdateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteOTAUpdateResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeletePolicyRequest' => [ 'base' => '<p>The input for the DeletePolicy operation.</p>', 'refs' => [], ], 'DeletePolicyVersionRequest' => [ 'base' => '<p>The input for the DeletePolicyVersion operation.</p>', 'refs' => [], ], 'DeleteProvisioningTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProvisioningTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProvisioningTemplateVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProvisioningTemplateVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRegistrationCodeRequest' => [ 'base' => '<p>The input for the DeleteRegistrationCode operation.</p>', 'refs' => [], ], 'DeleteRegistrationCodeResponse' => [ 'base' => '<p>The output for the DeleteRegistrationCode operation.</p>', 'refs' => [], ], 'DeleteRoleAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRoleAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteScheduledAuditRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteScheduledAuditResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteScheduledAudits' => [ 'base' => NULL, 'refs' => [ 'DeleteAccountAuditConfigurationRequest$deleteScheduledAudits' => '<p>If true, all scheduled audits are deleted.</p>', ], ], 'DeleteSecurityProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSecurityProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStream' => [ 'base' => NULL, 'refs' => [ 'DeleteOTAUpdateRequest$deleteStream' => '<p>Specifies if the stream associated with an OTA update should be deleted when the OTA update is deleted.</p>', ], ], 'DeleteStreamRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStreamResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteThingGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteThingGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteThingRequest' => [ 'base' => '<p>The input for the DeleteThing operation.</p>', 'refs' => [], ], 'DeleteThingResponse' => [ 'base' => '<p>The output of the DeleteThing operation.</p>', 'refs' => [], ], 'DeleteThingTypeRequest' => [ 'base' => '<p>The input for the DeleteThingType operation.</p>', 'refs' => [], ], 'DeleteThingTypeResponse' => [ 'base' => '<p>The output for the DeleteThingType operation.</p>', 'refs' => [], ], 'DeleteTopicRuleDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTopicRuleDestinationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTopicRuleRequest' => [ 'base' => '<p>The input for the DeleteTopicRule operation.</p>', 'refs' => [], ], 'DeleteV2LoggingLevelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeliveryStreamName' => [ 'base' => NULL, 'refs' => [ 'FirehoseAction$deliveryStreamName' => '<p>The delivery stream name.</p>', ], ], 'Denied' => [ 'base' => '<p>Contains information that denied the authorization.</p>', 'refs' => [ 'AuthResult$denied' => '<p>The policies and statements that denied the specified action.</p>', ], ], 'DeprecateThingTypeRequest' => [ 'base' => '<p>The input for the DeprecateThingType operation.</p>', 'refs' => [], ], 'DeprecateThingTypeResponse' => [ 'base' => '<p>The output for the DeprecateThingType operation.</p>', 'refs' => [], ], 'DeprecationDate' => [ 'base' => NULL, 'refs' => [ 'ThingTypeMetadata$deprecationDate' => '<p>The date and time when the thing type was deprecated.</p>', ], ], 'DescribeAccountAuditConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountAuditConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAuditFindingRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAuditFindingResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAuditMitigationActionsTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAuditMitigationActionsTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAuditTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAuditTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAuthorizerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAuthorizerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBillingGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBillingGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCACertificateRequest' => [ 'base' => '<p>The input for the DescribeCACertificate operation.</p>', 'refs' => [], ], 'DescribeCACertificateResponse' => [ 'base' => '<p>The output from the DescribeCACertificate operation.</p>', 'refs' => [], ], 'DescribeCertificateRequest' => [ 'base' => '<p>The input for the DescribeCertificate operation.</p>', 'refs' => [], ], 'DescribeCertificateResponse' => [ 'base' => '<p>The output of the DescribeCertificate operation.</p>', 'refs' => [], ], 'DescribeDefaultAuthorizerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDefaultAuthorizerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDimensionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDimensionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDomainConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDomainConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEndpointRequest' => [ 'base' => '<p>The input for the DescribeEndpoint operation.</p>', 'refs' => [], ], 'DescribeEndpointResponse' => [ 'base' => '<p>The output from the DescribeEndpoint operation.</p>', 'refs' => [], ], 'DescribeEventConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEventConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIndexRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIndexResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobExecutionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMitigationActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMitigationActionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProvisioningTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProvisioningTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProvisioningTemplateVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProvisioningTemplateVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRoleAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRoleAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeScheduledAuditRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeScheduledAuditResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSecurityProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSecurityProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStreamRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStreamResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeThingGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeThingGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeThingRegistrationTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeThingRegistrationTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeThingRequest' => [ 'base' => '<p>The input for the DescribeThing operation.</p>', 'refs' => [], ], 'DescribeThingResponse' => [ 'base' => '<p>The output from the DescribeThing operation.</p>', 'refs' => [], ], 'DescribeThingTypeRequest' => [ 'base' => '<p>The input for the DescribeThingType operation.</p>', 'refs' => [], ], 'DescribeThingTypeResponse' => [ 'base' => '<p>The output for the DescribeThingType operation.</p>', 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'TopicRule$description' => '<p>The description of the rule.</p>', 'TopicRulePayload$description' => '<p>The description of the rule.</p>', ], ], 'Destination' => [ 'base' => '<p>Describes the location of the updated firmware.</p>', 'refs' => [ 'StartSigningJobParameter$destination' => '<p>The location to write the code-signed file.</p>', ], ], 'DetachPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetachPrincipalPolicyRequest' => [ 'base' => '<p>The input for the DetachPrincipalPolicy operation.</p>', 'refs' => [], ], 'DetachSecurityProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetachSecurityProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'DetachThingPrincipalRequest' => [ 'base' => '<p>The input for the DetachThingPrincipal operation.</p>', 'refs' => [], ], 'DetachThingPrincipalResponse' => [ 'base' => '<p>The output from the DetachThingPrincipal operation.</p>', 'refs' => [], ], 'DetailsKey' => [ 'base' => NULL, 'refs' => [ 'DetailsMap$key' => NULL, ], ], 'DetailsMap' => [ 'base' => NULL, 'refs' => [ 'CancelJobExecutionRequest$statusDetails' => '<p>A collection of name/value pairs that describe the status of the job execution. If not specified, the statusDetails are unchanged. You can specify at most 10 name/value pairs.</p>', 'JobExecutionStatusDetails$detailsMap' => '<p>The job execution status.</p>', ], ], 'DetailsValue' => [ 'base' => NULL, 'refs' => [ 'DetailsMap$value' => NULL, ], ], 'DeviceCertificateUpdateAction' => [ 'base' => NULL, 'refs' => [ 'UpdateDeviceCertificateParams$action' => '<p>The action that you want to apply to the device cerrtificate. The only supported value is <code>DEACTIVATE</code>.</p>', ], ], 'DeviceDefenderThingName' => [ 'base' => NULL, 'refs' => [ 'ActiveViolation$thingName' => '<p>The name of the thing responsible for the active violation.</p>', 'ListActiveViolationsRequest$thingName' => '<p>The name of the thing whose active violations are listed.</p>', 'ListViolationEventsRequest$thingName' => '<p>A filter to limit results to those alerts caused by the specified thing.</p>', 'ViolationEvent$thingName' => '<p>The name of the thing responsible for the violation event.</p>', ], ], 'DimensionArn' => [ 'base' => NULL, 'refs' => [ 'CreateDimensionResponse$arn' => '<p>The ARN (Amazon resource name) of the created dimension.</p>', 'DescribeDimensionResponse$arn' => '<p>The ARN (Amazon resource name) for the dimension.</p>', 'UpdateDimensionResponse$arn' => '<p>The ARN (Amazon resource name) of the created dimension.</p>', ], ], 'DimensionName' => [ 'base' => NULL, 'refs' => [ 'CreateDimensionRequest$name' => '<p>A unique identifier for the dimension. Choose something that describes the type and value to make it easy to remember what it does.</p>', 'CreateDimensionResponse$name' => '<p>A unique identifier for the dimension.</p>', 'DeleteDimensionRequest$name' => '<p>The unique identifier for the dimension that you want to delete.</p>', 'DescribeDimensionRequest$name' => '<p>The unique identifier for the dimension.</p>', 'DescribeDimensionResponse$name' => '<p>The unique identifier for the dimension.</p>', 'DimensionNames$member' => NULL, 'ListSecurityProfilesRequest$dimensionName' => '<p>A filter to limit results to the security profiles that use the defined dimension.</p>', 'MetricDimension$dimensionName' => '<p>A unique identifier for the dimension.</p>', 'UpdateDimensionRequest$name' => '<p>A unique identifier for the dimension. Choose something that describes the type and value to make it easy to remember what it does.</p>', 'UpdateDimensionResponse$name' => '<p>A unique identifier for the dimension.</p>', ], ], 'DimensionNames' => [ 'base' => NULL, 'refs' => [ 'ListDimensionsResponse$dimensionNames' => '<p>A list of the names of the defined dimensions. Use <code>DescribeDimension</code> to get details for a dimension.</p>', ], ], 'DimensionStringValue' => [ 'base' => NULL, 'refs' => [ 'DimensionStringValues$member' => NULL, ], ], 'DimensionStringValues' => [ 'base' => NULL, 'refs' => [ 'CreateDimensionRequest$stringValues' => '<p>Specifies the value or list of values for the dimension. For <code>TOPIC_FILTER</code> dimensions, this is a pattern used to match the MQTT topic (for example, "admin/#").</p>', 'DescribeDimensionResponse$stringValues' => '<p>The value or list of values used to scope the dimension. For example, for topic filters, this is the pattern used to match the MQTT topic name.</p>', 'UpdateDimensionRequest$stringValues' => '<p>Specifies the value or list of values for the dimension. For <code>TOPIC_FILTER</code> dimensions, this is a pattern used to match the MQTT topic (for example, "admin/#").</p>', 'UpdateDimensionResponse$stringValues' => '<p>The value or list of values used to scope the dimension. For example, for topic filters, this is the pattern used to match the MQTT topic name.</p>', ], ], 'DimensionType' => [ 'base' => NULL, 'refs' => [ 'CreateDimensionRequest$type' => '<p>Specifies the type of dimension. Supported types: <code>TOPIC_FILTER.</code> </p>', 'DescribeDimensionResponse$type' => '<p>The type of the dimension.</p>', 'UpdateDimensionResponse$type' => '<p>The type of the dimension.</p>', ], ], 'DimensionValueOperator' => [ 'base' => NULL, 'refs' => [ 'MetricDimension$operator' => '<p>Defines how the <code>dimensionValues</code> of a dimension are interpreted. For example, for dimension type TOPIC_FILTER, the <code>IN</code> operator, a message will be counted only if its topic matches one of the topic filters. With <code>NOT_IN</code> operator, a message will be counted only if it doesn\'t match any of the topic filters. The operator is optional: if it\'s not provided (is <code>null</code>), it will be interpreted as <code>IN</code>.</p>', ], ], 'DisableAllLogs' => [ 'base' => NULL, 'refs' => [ 'GetV2LoggingOptionsResponse$disableAllLogs' => '<p>Disables all logs.</p>', 'SetV2LoggingOptionsRequest$disableAllLogs' => '<p>If true all logs are disabled. The default is false.</p>', ], ], 'DisableTopicRuleRequest' => [ 'base' => '<p>The input for the DisableTopicRuleRequest operation.</p>', 'refs' => [], ], 'DomainConfigurationArn' => [ 'base' => NULL, 'refs' => [ 'CreateDomainConfigurationResponse$domainConfigurationArn' => '<p>The ARN of the domain configuration.</p>', 'DescribeDomainConfigurationResponse$domainConfigurationArn' => '<p>The ARN of the domain configuration.</p>', 'DomainConfigurationSummary$domainConfigurationArn' => '<p>The ARN of the domain configuration.</p>', 'UpdateDomainConfigurationResponse$domainConfigurationArn' => '<p>The ARN of the domain configuration that was updated.</p>', ], ], 'DomainConfigurationName' => [ 'base' => NULL, 'refs' => [ 'CreateDomainConfigurationRequest$domainConfigurationName' => '<p>The name of the domain configuration. This value must be unique to a region.</p>', 'CreateDomainConfigurationResponse$domainConfigurationName' => '<p>The name of the domain configuration.</p>', 'DeleteDomainConfigurationRequest$domainConfigurationName' => '<p>The name of the domain configuration to be deleted.</p>', ], ], 'DomainConfigurationStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeDomainConfigurationResponse$domainConfigurationStatus' => '<p>A Boolean value that specifies the current state of the domain configuration.</p>', 'UpdateDomainConfigurationRequest$domainConfigurationStatus' => '<p>The status to which the domain configuration should be updated.</p>', ], ], 'DomainConfigurationSummary' => [ 'base' => '<p>The summary of a domain configuration. A domain configuration specifies custom IoT-specific information about a domain. A domain configuration can be associated with an AWS-managed domain (for example, dbc123defghijk.iot.us-west-2.amazonaws.com), a customer managed domain, or a default endpoint.</p> <ul> <li> <p>Data</p> </li> <li> <p>Jobs</p> </li> <li> <p>CredentialProvider</p> </li> </ul> <note> <p>The domain configuration feature is in public preview and is subject to change.</p> </note>', 'refs' => [ 'DomainConfigurations$member' => NULL, ], ], 'DomainConfigurations' => [ 'base' => NULL, 'refs' => [ 'ListDomainConfigurationsResponse$domainConfigurations' => '<p>A list of objects that contain summary information about the user\'s domain configurations.</p>', ], ], 'DomainName' => [ 'base' => NULL, 'refs' => [ 'CreateDomainConfigurationRequest$domainName' => '<p>The name of the domain.</p>', 'DescribeDomainConfigurationResponse$domainName' => '<p>The name of the domain.</p>', ], ], 'DomainType' => [ 'base' => NULL, 'refs' => [ 'DescribeDomainConfigurationResponse$domainType' => '<p>The type of the domain.</p>', ], ], 'DurationSeconds' => [ 'base' => NULL, 'refs' => [ 'BehaviorCriteria$durationSeconds' => '<p>Use this to specify the time duration over which the behavior is evaluated, for those criteria which have a time dimension (for example, <code>NUM_MESSAGES_SENT</code>). For a <code>statisticalThreshhold</code> metric comparison, measurements from all devices are accumulated over this time duration before being used to calculate percentiles, and later, measurements from an individual device are also accumulated over this time duration before being given a percentile rank.</p>', ], ], 'DynamicGroupStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeThingGroupResponse$status' => '<p>The dynamic thing group status.</p>', ], ], 'DynamoDBAction' => [ 'base' => '<p>Describes an action to write to a DynamoDB table.</p> <p>The <code>tableName</code>, <code>hashKeyField</code>, and <code>rangeKeyField</code> values must match the values used when you created the table.</p> <p>The <code>hashKeyValue</code> and <code>rangeKeyvalue</code> fields use a substitution template syntax. These templates provide data at runtime. The syntax is as follows: ${<i>sql-expression</i>}.</p> <p>You can specify any valid expression in a WHERE or SELECT clause, including JSON properties, comparisons, calculations, and functions. For example, the following field uses the third level of the topic:</p> <p> <code>"hashKeyValue": "${topic(3)}"</code> </p> <p>The following field uses the timestamp:</p> <p> <code>"rangeKeyValue": "${timestamp()}"</code> </p>', 'refs' => [ 'Action$dynamoDB' => '<p>Write to a DynamoDB table.</p>', ], ], 'DynamoDBv2Action' => [ 'base' => '<p>Describes an action to write to a DynamoDB table.</p> <p>This DynamoDB action writes each attribute in the message payload into it\'s own column in the DynamoDB table.</p>', 'refs' => [ 'Action$dynamoDBv2' => '<p>Write to a DynamoDB table. This is a new version of the DynamoDB action. It allows you to write each attribute in an MQTT message payload into a separate DynamoDB column.</p>', ], ], 'DynamoKeyType' => [ 'base' => NULL, 'refs' => [ 'DynamoDBAction$hashKeyType' => '<p>The hash key type. Valid values are "STRING" or "NUMBER"</p>', 'DynamoDBAction$rangeKeyType' => '<p>The range key type. Valid values are "STRING" or "NUMBER"</p>', ], ], 'DynamoOperation' => [ 'base' => NULL, 'refs' => [ 'DynamoDBAction$operation' => '<p>The type of operation to be performed. This follows the substitution template, so it can be <code>${operation}</code>, but the substitution must result in one of the following: <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>.</p>', ], ], 'EffectivePolicies' => [ 'base' => NULL, 'refs' => [ 'GetEffectivePoliciesResponse$effectivePolicies' => '<p>The effective policies.</p>', ], ], 'EffectivePolicy' => [ 'base' => '<p>The policy that has the effect on the authorization results.</p>', 'refs' => [ 'EffectivePolicies$member' => NULL, ], ], 'ElasticsearchAction' => [ 'base' => '<p>Describes an action that writes data to an Amazon Elasticsearch Service domain.</p>', 'refs' => [ 'Action$elasticsearch' => '<p>Write data to an Amazon Elasticsearch Service domain.</p>', ], ], 'ElasticsearchEndpoint' => [ 'base' => NULL, 'refs' => [ 'ElasticsearchAction$endpoint' => '<p>The endpoint of your Elasticsearch domain.</p>', ], ], 'ElasticsearchId' => [ 'base' => NULL, 'refs' => [ 'ElasticsearchAction$id' => '<p>The unique identifier for the document you are storing.</p>', ], ], 'ElasticsearchIndex' => [ 'base' => NULL, 'refs' => [ 'ElasticsearchAction$index' => '<p>The Elasticsearch index where you want to store your data.</p>', ], ], 'ElasticsearchType' => [ 'base' => NULL, 'refs' => [ 'ElasticsearchAction$type' => '<p>The type of document you are storing.</p>', ], ], 'EnableIoTLoggingParams' => [ 'base' => '<p>Parameters used when defining a mitigation action that enable AWS IoT logging.</p>', 'refs' => [ 'MitigationActionParams$enableIoTLoggingParams' => '<p>Parameters to define a mitigation action that enables AWS IoT logging at a specified level of detail.</p>', ], ], 'EnableTopicRuleRequest' => [ 'base' => '<p>The input for the EnableTopicRuleRequest operation.</p>', 'refs' => [], ], 'Enabled' => [ 'base' => NULL, 'refs' => [ 'AuditCheckConfiguration$enabled' => '<p>True if this audit check is enabled for this account.</p>', 'AuditNotificationTarget$enabled' => '<p>True if notifications to the target are enabled.</p>', 'Configuration$Enabled' => '<p>True to enable the configuration.</p>', 'CreateProvisioningTemplateRequest$enabled' => '<p>True to enable the fleet provisioning template, otherwise false.</p>', 'DescribeProvisioningTemplateResponse$enabled' => '<p>True if the fleet provisioning template is enabled, otherwise false.</p>', 'ProvisioningTemplateSummary$enabled' => '<p>True if the fleet provision template is enabled, otherwise false.</p>', 'UpdateProvisioningTemplateRequest$enabled' => '<p>True to enable the fleet provisioning template, otherwise false.</p>', ], ], 'EndpointAddress' => [ 'base' => NULL, 'refs' => [ 'DescribeEndpointResponse$endpointAddress' => '<p>The endpoint. The format of the endpoint is as follows: <i>identifier</i>.iot.<i>region</i>.amazonaws.com.</p>', ], ], 'EndpointType' => [ 'base' => NULL, 'refs' => [ 'DescribeEndpointRequest$endpointType' => '<p>The endpoint type. Valid endpoint types include:</p> <ul> <li> <p> <code>iot:Data</code> - Returns a VeriSign signed data endpoint.</p> </li> </ul> <ul> <li> <p> <code>iot:Data-ATS</code> - Returns an ATS signed data endpoint.</p> </li> </ul> <ul> <li> <p> <code>iot:CredentialProvider</code> - Returns an AWS IoT credentials provider API endpoint.</p> </li> </ul> <ul> <li> <p> <code>iot:Jobs</code> - Returns an AWS IoT device management Jobs API endpoint.</p> </li> </ul> <p>We strongly recommend that customers use the newer <code>iot:Data-ATS</code> endpoint type to avoid issues related to the widespread distrust of Symantec certificate authorities.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'AuditCheckDetails$errorCode' => '<p>The code of any error encountered when this check is performed during this audit. One of "INSUFFICIENT_PERMISSIONS" or "AUDIT_CHECK_DISABLED".</p>', 'AuditMitigationActionExecutionMetadata$errorCode' => '<p>If an error occurred, the code that indicates which type of error occurred.</p>', ], ], 'ErrorInfo' => [ 'base' => '<p>Error information.</p>', 'refs' => [ 'OTAUpdateInfo$errorInfo' => '<p>Error information associated with the OTA update.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AuditCheckDetails$message' => '<p>The message associated with any error encountered when this check is performed during this audit.</p>', 'AuditMitigationActionExecutionMetadata$message' => '<p>If an error occurred, a message that describes the error.</p>', 'DescribeThingRegistrationTaskResponse$message' => '<p>The message.</p>', 'ValidationError$errorMessage' => '<p>The description of an error found in the behaviors.</p>', ], ], 'EvaluationStatistic' => [ 'base' => NULL, 'refs' => [ 'StatisticalThreshold$statistic' => '<p>The percentile which resolves to a threshold value by which compliance with a behavior is determined. Metrics are collected over the specified period (<code>durationSeconds</code>) from all reporting devices in your account and statistical ranks are calculated. Then, the measurements from a device are collected over the same period. If the accumulated measurements from the device fall above or below (<code>comparisonOperator</code>) the value associated with the percentile specified, then the device is considered to be in compliance with the behavior, otherwise a violation occurs.</p>', ], ], 'EventConfigurations' => [ 'base' => NULL, 'refs' => [ 'DescribeEventConfigurationsResponse$eventConfigurations' => '<p>The event configurations.</p>', 'UpdateEventConfigurationsRequest$eventConfigurations' => '<p>The new event configuration values.</p>', ], ], 'EventType' => [ 'base' => NULL, 'refs' => [ 'EventConfigurations$key' => NULL, ], ], 'ExecutionNamePrefix' => [ 'base' => NULL, 'refs' => [ 'StepFunctionsAction$executionNamePrefix' => '<p>(Optional) A name will be given to the state machine execution consisting of this prefix followed by a UUID. Step Functions automatically creates a unique name for each state machine execution if one is not provided.</p>', ], ], 'ExecutionNumber' => [ 'base' => NULL, 'refs' => [ 'DeleteJobExecutionRequest$executionNumber' => '<p>The ID of the job execution to be deleted. The <code>executionNumber</code> refers to the execution of a particular job on a particular device.</p> <p>Note that once a job execution is deleted, the <code>executionNumber</code> may be reused by IoT, so be sure you get and use the correct value here.</p>', 'DescribeJobExecutionRequest$executionNumber' => '<p>A string (consisting of the digits "0" through "9" which is used to specify a particular job execution on a particular device.</p>', 'JobExecution$executionNumber' => '<p>A string (consisting of the digits "0" through "9") which identifies this particular job execution on this particular device. It can be used in commands which return or update job execution information. </p>', 'JobExecutionSummary$executionNumber' => '<p>A string (consisting of the digits "0" through "9") which identifies this particular job execution on this particular device. It can be used later in commands which return or update job execution information.</p>', ], ], 'ExpectedVersion' => [ 'base' => NULL, 'refs' => [ 'CancelJobExecutionRequest$expectedVersion' => '<p>(Optional) The expected current version of the job execution. Each time you update the job execution, its version is incremented. If the version of the job execution stored in Jobs does not match, the update is rejected with a VersionMismatch error, and an ErrorResponse that contains the current job execution status data is returned. (This makes it unnecessary to perform a separate DescribeJobExecution request in order to obtain the job execution status data.)</p>', ], ], 'ExpiresInSec' => [ 'base' => NULL, 'refs' => [ 'PresignedUrlConfig$expiresInSec' => '<p>How long (in seconds) pre-signed URLs are valid. Valid values are 60 - 3600, the default value is 3600 seconds. Pre-signed URLs are generated when Jobs receives an MQTT request for the job document.</p>', ], ], 'ExpiresInSeconds' => [ 'base' => NULL, 'refs' => [ 'AwsJobPresignedUrlConfig$expiresInSec' => '<p>How long (in seconds) pre-signed URLs are valid. Valid values are 60 - 3600, the default value is 1800 seconds. Pre-signed URLs are generated when a request for the job document is received.</p>', ], ], 'ExplicitDeny' => [ 'base' => '<p>Information that explicitly denies authorization.</p>', 'refs' => [ 'Denied$explicitDeny' => '<p>Information that explicitly denies the authorization. </p>', ], ], 'ExponentialRolloutRate' => [ 'base' => '<p>Allows you to create an exponential rate of rollout for a job.</p>', 'refs' => [ 'JobExecutionsRolloutConfig$exponentialRate' => '<p>The rate of increase for a job rollout. This parameter allows you to define an exponential rate for a job rollout.</p>', ], ], 'FailedChecksCount' => [ 'base' => NULL, 'refs' => [ 'TaskStatistics$failedChecks' => '<p>The number of checks.</p>', ], ], 'FailedFindingsCount' => [ 'base' => NULL, 'refs' => [ 'TaskStatisticsForAuditCheck$failedFindingsCount' => '<p>The number of findings for which at least one of the actions failed when applied.</p>', ], ], 'FailedThings' => [ 'base' => NULL, 'refs' => [ 'JobProcessDetails$numberOfFailedThings' => '<p>The number of things that failed executing the job.</p>', ], ], 'Field' => [ 'base' => '<p>Describes the name and data type at a field.</p>', 'refs' => [ 'Fields$member' => NULL, ], ], 'FieldName' => [ 'base' => NULL, 'refs' => [ 'Field$name' => '<p>The name of the field.</p>', ], ], 'FieldType' => [ 'base' => NULL, 'refs' => [ 'Field$type' => '<p>The datatype of the field.</p>', ], ], 'Fields' => [ 'base' => NULL, 'refs' => [ 'ThingGroupIndexingConfiguration$managedFields' => '<p>Contains fields that are indexed and whose types are already known by the Fleet Indexing service.</p>', 'ThingGroupIndexingConfiguration$customFields' => '<p>A list of thing group fields to index. This list cannot contain any managed fields. Use the GetIndexingConfiguration API to get a list of managed fields.</p> <p>Contains custom field names and their data type.</p>', 'ThingIndexingConfiguration$managedFields' => '<p>Contains fields that are indexed and whose types are already known by the Fleet Indexing service.</p>', 'ThingIndexingConfiguration$customFields' => '<p>Contains custom field names and their data type.</p>', ], ], 'FileId' => [ 'base' => NULL, 'refs' => [ 'Stream$fileId' => '<p>The ID of a file associated with a stream.</p>', 'StreamFile$fileId' => '<p>The file ID.</p>', ], ], 'FileLocation' => [ 'base' => '<p>The location of the OTA update.</p>', 'refs' => [ 'OTAUpdateFile$fileLocation' => '<p>The location of the updated firmware.</p>', ], ], 'FileName' => [ 'base' => NULL, 'refs' => [ 'OTAUpdateFile$fileName' => '<p>The name of the file.</p>', ], ], 'FindingId' => [ 'base' => NULL, 'refs' => [ 'AuditFinding$findingId' => '<p>A unique identifier for this set of audit findings. This identifier is used to apply mitigation tasks to one or more sets of findings.</p>', 'AuditMitigationActionExecutionMetadata$findingId' => '<p>The unique identifier for the findings to which the task and associated mitigation action are applied.</p>', 'DescribeAuditFindingRequest$findingId' => '<p>A unique identifier for a single audit finding. You can use this identifier to apply mitigation actions to the finding.</p>', 'FindingIds$member' => NULL, 'ListAuditMitigationActionsExecutionsRequest$findingId' => '<p>Specify this filter to limit results to those that were applied to a specific audit finding.</p>', 'ListAuditMitigationActionsTasksRequest$findingId' => '<p>Specify this filter to limit results to tasks that were applied to a specific audit finding.</p>', ], ], 'FindingIds' => [ 'base' => NULL, 'refs' => [ 'AuditMitigationActionsTaskTarget$findingIds' => '<p>If the task will apply a mitigation action to one or more listed findings, this value uniquely identifies those findings.</p>', ], ], 'FirehoseAction' => [ 'base' => '<p>Describes an action that writes data to an Amazon Kinesis Firehose stream.</p>', 'refs' => [ 'Action$firehose' => '<p>Write to an Amazon Kinesis Firehose stream.</p>', ], ], 'FirehoseSeparator' => [ 'base' => NULL, 'refs' => [ 'FirehoseAction$separator' => '<p>A character separator that will be used to separate records written to the Firehose stream. Valid values are: \'\\n\' (newline), \'\\t\' (tab), \'\\r\\n\' (Windows newline), \',\' (comma).</p>', ], ], 'Flag' => [ 'base' => NULL, 'refs' => [ 'AttributePayload$merge' => '<p>Specifies whether the list of attributes provided in the <code>AttributePayload</code> is merged with the attributes stored in the registry, instead of overwriting them.</p> <p>To remove an attribute, call <code>UpdateThing</code> with an empty attribute value.</p> <note> <p>The <code>merge</code> attribute is only valid when calling <code>UpdateThing</code> or <code>UpdateThingGroup</code>.</p> </note>', ], ], 'ForceDelete' => [ 'base' => NULL, 'refs' => [ 'DeleteCertificateRequest$forceDelete' => '<p>Forces the deletion of a certificate if it is inactive and is not attached to an IoT thing.</p>', ], ], 'ForceDeleteAWSJob' => [ 'base' => NULL, 'refs' => [ 'DeleteOTAUpdateRequest$forceDeleteAWSJob' => '<p>Specifies if the AWS Job associated with the OTA update should be deleted when the OTA update is deleted.</p>', ], ], 'ForceFlag' => [ 'base' => NULL, 'refs' => [ 'CancelJobExecutionRequest$force' => '<p>(Optional) If <code>true</code> the job execution will be canceled if it has status IN_PROGRESS or QUEUED, otherwise the job execution will be canceled only if it has status QUEUED. If you attempt to cancel a job execution that is IN_PROGRESS, and you do not set <code>force</code> to <code>true</code>, then an <code>InvalidStateTransitionException</code> will be thrown. The default is <code>false</code>.</p> <p>Canceling a job execution which is "IN_PROGRESS", will cause the device to be unable to update the job execution status. Use caution and ensure that the device is able to recover to a valid state.</p>', 'CancelJobRequest$force' => '<p>(Optional) If <code>true</code> job executions with status "IN_PROGRESS" and "QUEUED" are canceled, otherwise only job executions with status "QUEUED" are canceled. The default is <code>false</code>.</p> <p>Canceling a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to update the job execution status. Use caution and ensure that each device executing a job which is canceled is able to recover to a valid state.</p>', 'DeleteJobExecutionRequest$force' => '<p>(Optional) When true, you can delete a job execution which is "IN_PROGRESS". Otherwise, you can only delete a job execution which is in a terminal state ("SUCCEEDED", "FAILED", "REJECTED", "REMOVED" or "CANCELED") or an exception will occur. The default is false.</p> <note> <p>Deleting a job execution which is "IN_PROGRESS", will cause the device to be unable to access job information or update the job execution status. Use caution and ensure that the device is able to recover to a valid state.</p> </note>', 'DeleteJobRequest$force' => '<p>(Optional) When true, you can delete a job which is "IN_PROGRESS". Otherwise, you can only delete a job which is in a terminal state ("COMPLETED" or "CANCELED") or an exception will occur. The default is false.</p> <note> <p>Deleting a job which is "IN_PROGRESS", will cause a device which is executing the job to be unable to access job information or update the job execution status. Use caution and ensure that each device executing a job which is deleted is able to recover to a valid state.</p> </note>', ], ], 'Forced' => [ 'base' => NULL, 'refs' => [ 'Job$forceCanceled' => '<p>Will be <code>true</code> if the job was canceled with the optional <code>force</code> parameter set to <code>true</code>.</p>', 'JobExecution$forceCanceled' => '<p>Will be <code>true</code> if the job execution was canceled with the optional <code>force</code> parameter set to <code>true</code>.</p>', ], ], 'FunctionArn' => [ 'base' => NULL, 'refs' => [ 'LambdaAction$functionArn' => '<p>The ARN of the Lambda function.</p>', ], ], 'GenerationId' => [ 'base' => NULL, 'refs' => [ 'CACertificateDescription$generationId' => '<p>The generation ID of the CA certificate.</p>', 'CertificateDescription$generationId' => '<p>The generation ID of the certificate.</p>', 'GetPolicyResponse$generationId' => '<p>The generation ID of the policy.</p>', 'GetPolicyVersionResponse$generationId' => '<p>The generation ID of the policy version.</p>', ], ], 'GetCardinalityRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCardinalityResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEffectivePoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEffectivePoliciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetIndexingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetIndexingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetJobDocumentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetJobDocumentResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLoggingOptionsRequest' => [ 'base' => '<p>The input for the GetLoggingOptions operation.</p>', 'refs' => [], ], 'GetLoggingOptionsResponse' => [ 'base' => '<p>The output from the GetLoggingOptions operation.</p>', 'refs' => [], ], 'GetOTAUpdateRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetOTAUpdateResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPercentilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPercentilesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPolicyRequest' => [ 'base' => '<p>The input for the GetPolicy operation.</p>', 'refs' => [], ], 'GetPolicyResponse' => [ 'base' => '<p>The output from the GetPolicy operation.</p>', 'refs' => [], ], 'GetPolicyVersionRequest' => [ 'base' => '<p>The input for the GetPolicyVersion operation.</p>', 'refs' => [], ], 'GetPolicyVersionResponse' => [ 'base' => '<p>The output from the GetPolicyVersion operation.</p>', 'refs' => [], ], 'GetRegistrationCodeRequest' => [ 'base' => '<p>The input to the GetRegistrationCode operation.</p>', 'refs' => [], ], 'GetRegistrationCodeResponse' => [ 'base' => '<p>The output from the GetRegistrationCode operation.</p>', 'refs' => [], ], 'GetStatisticsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetStatisticsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTopicRuleDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTopicRuleDestinationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTopicRuleRequest' => [ 'base' => '<p>The input for the GetTopicRule operation.</p>', 'refs' => [], ], 'GetTopicRuleResponse' => [ 'base' => '<p>The output from the GetTopicRule operation.</p>', 'refs' => [], ], 'GetV2LoggingOptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetV2LoggingOptionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GroupNameAndArn' => [ 'base' => '<p>The name and ARN of a group.</p>', 'refs' => [ 'BillingGroupNameAndArnList$member' => NULL, 'ThingGroupNameAndArnList$member' => NULL, ], ], 'HashAlgorithm' => [ 'base' => NULL, 'refs' => [ 'CustomCodeSigning$hashAlgorithm' => '<p>The hash algorithm used to code sign the file.</p>', ], ], 'HashKeyField' => [ 'base' => NULL, 'refs' => [ 'DynamoDBAction$hashKeyField' => '<p>The hash key name.</p>', ], ], 'HashKeyValue' => [ 'base' => NULL, 'refs' => [ 'DynamoDBAction$hashKeyValue' => '<p>The hash key value.</p>', ], ], 'HeaderKey' => [ 'base' => NULL, 'refs' => [ 'HttpActionHeader$key' => '<p>The HTTP header key.</p>', ], ], 'HeaderList' => [ 'base' => NULL, 'refs' => [ 'HttpAction$headers' => '<p>The HTTP headers to send with the message data.</p>', ], ], 'HeaderValue' => [ 'base' => NULL, 'refs' => [ 'HttpActionHeader$value' => '<p>The HTTP header value. Substitution templates are supported.</p>', ], ], 'HttpAction' => [ 'base' => '<p>Send data to an HTTPS endpoint.</p>', 'refs' => [ 'Action$http' => '<p>Send data to an HTTPS endpoint.</p>', ], ], 'HttpActionHeader' => [ 'base' => '<p>The HTTP action header.</p>', 'refs' => [ 'HeaderList$member' => NULL, ], ], 'HttpAuthorization' => [ 'base' => '<p>The authorization method used to send messages.</p>', 'refs' => [ 'HttpAction$auth' => '<p>The authentication method to use when sending data to an HTTPS endpoint.</p>', ], ], 'HttpContext' => [ 'base' => '<p>Specifies the HTTP context to use for the test authorizer request.</p>', 'refs' => [ 'TestInvokeAuthorizerRequest$httpContext' => '<p>Specifies a test HTTP authorization request.</p>', ], ], 'HttpHeaderName' => [ 'base' => NULL, 'refs' => [ 'HttpHeaders$key' => NULL, ], ], 'HttpHeaderValue' => [ 'base' => NULL, 'refs' => [ 'HttpHeaders$value' => NULL, ], ], 'HttpHeaders' => [ 'base' => NULL, 'refs' => [ 'HttpContext$headers' => '<p>The header keys and values in an HTTP authorization request.</p>', ], ], 'HttpQueryString' => [ 'base' => NULL, 'refs' => [ 'HttpContext$queryString' => '<p>The query string keys and values in an HTTP authorization request.</p>', ], ], 'HttpUrlDestinationConfiguration' => [ 'base' => '<p>HTTP URL destination configuration used by the topic rule\'s HTTP action.</p>', 'refs' => [ 'TopicRuleDestinationConfiguration$httpUrlConfiguration' => '<p>Configuration of the HTTP URL.</p>', ], ], 'HttpUrlDestinationProperties' => [ 'base' => '<p>HTTP URL destination properties.</p>', 'refs' => [ 'TopicRuleDestination$httpUrlProperties' => '<p>Properties of the HTTP URL.</p>', ], ], 'HttpUrlDestinationSummary' => [ 'base' => '<p>Information about an HTTP URL destination.</p>', 'refs' => [ 'TopicRuleDestinationSummary$httpUrlSummary' => '<p>Information about the HTTP URL.</p>', ], ], 'ImplicitDeny' => [ 'base' => '<p>Information that implicitly denies authorization. When policy doesn\'t explicitly deny or allow an action on a resource it is considered an implicit deny.</p>', 'refs' => [ 'Denied$implicitDeny' => '<p>Information that implicitly denies the authorization. When a policy doesn\'t explicitly deny or allow an action on a resource it is considered an implicit deny.</p>', ], ], 'InProgressChecksCount' => [ 'base' => NULL, 'refs' => [ 'TaskStatistics$inProgressChecks' => '<p>The number of checks in progress.</p>', ], ], 'InProgressThings' => [ 'base' => NULL, 'refs' => [ 'JobProcessDetails$numberOfInProgressThings' => '<p>The number of things currently executing the job.</p>', ], ], 'InProgressTimeoutInMinutes' => [ 'base' => NULL, 'refs' => [ 'TimeoutConfig$inProgressTimeoutInMinutes' => '<p>Specifies the amount of time, in minutes, this device has to finish execution of this job. The timeout interval can be anywhere between 1 minute and 7 days (1 to 10080 minutes). The in progress timer can\'t be updated and will apply to all job executions for the job. Whenever a job execution remains in the IN_PROGRESS status for longer than this interval, the job execution will fail and switch to the terminal <code>TIMED_OUT</code> status.</p>', ], ], 'IncrementFactor' => [ 'base' => NULL, 'refs' => [ 'ExponentialRolloutRate$incrementFactor' => '<p>The exponential factor to increase the rate of rollout for a job.</p>', ], ], 'IndexName' => [ 'base' => NULL, 'refs' => [ 'CreateDynamicThingGroupRequest$indexName' => '<p>The dynamic thing group index name.</p> <note> <p>Currently one index is supported: "AWS_Things".</p> </note>', 'CreateDynamicThingGroupResponse$indexName' => '<p>The dynamic thing group index name.</p>', 'DescribeIndexRequest$indexName' => '<p>The index name.</p>', 'DescribeIndexResponse$indexName' => '<p>The index name.</p>', 'DescribeThingGroupResponse$indexName' => '<p>The dynamic thing group index name.</p>', 'GetCardinalityRequest$indexName' => '<p>The name of the index to search.</p>', 'GetPercentilesRequest$indexName' => '<p>The name of the index to search.</p>', 'GetStatisticsRequest$indexName' => '<p>The name of the index to search. The default value is <code>AWS_Things</code>.</p>', 'IndexNamesList$member' => NULL, 'SearchIndexRequest$indexName' => '<p>The search index name.</p>', 'UpdateDynamicThingGroupRequest$indexName' => '<p>The dynamic thing group index to update.</p> <note> <p>Currently one index is supported: \'AWS_Things\'.</p> </note>', ], ], 'IndexNamesList' => [ 'base' => NULL, 'refs' => [ 'ListIndicesResponse$indexNames' => '<p>The index names.</p>', ], ], 'IndexNotReadyException' => [ 'base' => '<p>The index is not ready.</p>', 'refs' => [], ], 'IndexSchema' => [ 'base' => NULL, 'refs' => [ 'DescribeIndexResponse$schema' => '<p>Contains a value that specifies the type of indexing performed. Valid values are:</p> <ul> <li> <p>REGISTRY – Your thing index contains only registry data.</p> </li> <li> <p>REGISTRY_AND_SHADOW - Your thing index contains registry data and shadow data.</p> </li> <li> <p>REGISTRY_AND_CONNECTIVITY_STATUS - Your thing index contains registry data and thing connectivity status data.</p> </li> <li> <p>REGISTRY_AND_SHADOW_AND_CONNECTIVITY_STATUS - Your thing index contains registry data, shadow data, and thing connectivity status data.</p> </li> </ul>', ], ], 'IndexStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeIndexResponse$indexStatus' => '<p>The index status.</p>', ], ], 'InlineDocument' => [ 'base' => NULL, 'refs' => [ 'CodeSigningCertificateChain$inlineDocument' => '<p>A base64 encoded binary representation of the code signing certificate chain.</p>', ], ], 'InputName' => [ 'base' => NULL, 'refs' => [ 'IotEventsAction$inputName' => '<p>The name of the AWS IoT Events input.</p>', ], ], 'InternalException' => [ 'base' => '<p>An unexpected error has occurred.</p>', 'refs' => [], ], 'InternalFailureException' => [ 'base' => '<p>An unexpected error has occurred.</p>', 'refs' => [], ], 'InvalidAggregationException' => [ 'base' => '<p>The aggregation is invalid.</p>', 'refs' => [], ], 'InvalidQueryException' => [ 'base' => '<p>The query is invalid.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>The request is not valid.</p>', 'refs' => [], ], 'InvalidResponseException' => [ 'base' => '<p>The response is invalid.</p>', 'refs' => [], ], 'InvalidStateTransitionException' => [ 'base' => '<p>An attempt was made to change to an invalid state, for example by deleting a job or a job execution which is "IN_PROGRESS" without setting the <code>force</code> parameter.</p>', 'refs' => [], ], 'IotAnalyticsAction' => [ 'base' => '<p>Sends message data to an AWS IoT Analytics channel.</p>', 'refs' => [ 'Action$iotAnalytics' => '<p>Sends message data to an AWS IoT Analytics channel.</p>', ], ], 'IotEventsAction' => [ 'base' => '<p>Sends an input to an AWS IoT Events detector.</p>', 'refs' => [ 'Action$iotEvents' => '<p>Sends an input to an AWS IoT Events detector.</p>', ], ], 'IotSiteWiseAction' => [ 'base' => '<p>Describes an action to send data from an MQTT message that triggered the rule to AWS IoT SiteWise asset properties.</p>', 'refs' => [ 'Action$iotSiteWise' => '<p>Sends data from the MQTT message that triggered the rule to AWS IoT SiteWise asset properties.</p>', ], ], 'IsAuthenticated' => [ 'base' => NULL, 'refs' => [ 'TestInvokeAuthorizerResponse$isAuthenticated' => '<p>True if the token is authenticated, otherwise false.</p>', ], ], 'IsDefaultVersion' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyVersionResponse$isDefaultVersion' => '<p>Specifies whether the policy version is the default.</p>', 'CreateProvisioningTemplateVersionResponse$isDefaultVersion' => '<p>True if the fleet provisioning template version is the default version, otherwise false.</p>', 'DescribeProvisioningTemplateVersionResponse$isDefaultVersion' => '<p>True if the fleet provisioning template version is the default version.</p>', 'GetPolicyVersionResponse$isDefaultVersion' => '<p>Specifies whether the policy version is the default.</p>', 'PolicyVersion$isDefaultVersion' => '<p>Specifies whether the policy version is the default.</p>', 'ProvisioningTemplateVersionSummary$isDefaultVersion' => '<p>True if the fleet provisioning template version is the default version, otherwise false.</p>', ], ], 'IsDisabled' => [ 'base' => NULL, 'refs' => [ 'ListTopicRulesRequest$ruleDisabled' => '<p>Specifies whether the rule is disabled.</p>', 'TopicRule$ruleDisabled' => '<p>Specifies whether the rule is disabled.</p>', 'TopicRuleListItem$ruleDisabled' => '<p>Specifies whether the rule is disabled.</p>', 'TopicRulePayload$ruleDisabled' => '<p>Specifies whether the rule is disabled.</p>', ], ], 'Job' => [ 'base' => '<p>The <code>Job</code> object contains details about a job.</p>', 'refs' => [ 'DescribeJobResponse$job' => '<p>Information about the job.</p>', ], ], 'JobArn' => [ 'base' => NULL, 'refs' => [ 'AssociateTargetsWithJobResponse$jobArn' => '<p>An ARN identifying the job.</p>', 'CancelJobResponse$jobArn' => '<p>The job ARN.</p>', 'CreateJobResponse$jobArn' => '<p>The job ARN.</p>', 'Job$jobArn' => '<p>An ARN identifying the job with format "arn:aws:iot:region:account:job/jobId".</p>', 'JobSummary$jobArn' => '<p>The job ARN.</p>', ], ], 'JobDescription' => [ 'base' => NULL, 'refs' => [ 'AssociateTargetsWithJobResponse$description' => '<p>A short text description of the job.</p>', 'CancelJobResponse$description' => '<p>A short text description of the job.</p>', 'CreateJobRequest$description' => '<p>A short text description of the job.</p>', 'CreateJobResponse$description' => '<p>The job description.</p>', 'Job$description' => '<p>A short text description of the job.</p>', 'UpdateJobRequest$description' => '<p>A short text description of the job.</p>', ], ], 'JobDocument' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$document' => '<p>The job document.</p> <note> <p>If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.</p> <p>The placeholder link is of the following form:</p> <p> <code>${aws:iot:s3-presigned-url:https://s3.amazonaws.com/<i>bucket</i>/<i>key</i>}</code> </p> <p>where <i>bucket</i> is your bucket name and <i>key</i> is the object in the bucket to which you are linking.</p> </note>', 'GetJobDocumentResponse$document' => '<p>The job document content.</p>', ], ], 'JobDocumentSource' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$documentSource' => '<p>An S3 link to the job document.</p>', 'DescribeJobResponse$documentSource' => '<p>An S3 link to the job document.</p>', ], ], 'JobExecution' => [ 'base' => '<p>The job execution object represents the execution of a job on a particular device.</p>', 'refs' => [ 'DescribeJobExecutionResponse$execution' => '<p>Information about the job execution.</p>', ], ], 'JobExecutionFailureType' => [ 'base' => NULL, 'refs' => [ 'AbortCriteria$failureType' => '<p>The type of job execution failures that can initiate a job abort.</p>', ], ], 'JobExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'JobExecution$status' => '<p>The status of the job execution (IN_PROGRESS, QUEUED, FAILED, SUCCEEDED, TIMED_OUT, CANCELED, or REJECTED).</p>', 'JobExecutionSummary$status' => '<p>The status of the job execution.</p>', 'ListJobExecutionsForJobRequest$status' => '<p>The status of the job.</p>', 'ListJobExecutionsForThingRequest$status' => '<p>An optional filter that lets you search for jobs that have the specified status.</p>', ], ], 'JobExecutionStatusDetails' => [ 'base' => '<p>Details of the job execution status.</p>', 'refs' => [ 'JobExecution$statusDetails' => '<p>A collection of name/value pairs that describe the status of the job execution.</p>', ], ], 'JobExecutionSummary' => [ 'base' => '<p>The job execution summary.</p>', 'refs' => [ 'JobExecutionSummaryForJob$jobExecutionSummary' => '<p>Contains a subset of information about a job execution.</p>', 'JobExecutionSummaryForThing$jobExecutionSummary' => '<p>Contains a subset of information about a job execution.</p>', ], ], 'JobExecutionSummaryForJob' => [ 'base' => '<p>Contains a summary of information about job executions for a specific job.</p>', 'refs' => [ 'JobExecutionSummaryForJobList$member' => NULL, ], ], 'JobExecutionSummaryForJobList' => [ 'base' => NULL, 'refs' => [ 'ListJobExecutionsForJobResponse$executionSummaries' => '<p>A list of job execution summaries.</p>', ], ], 'JobExecutionSummaryForThing' => [ 'base' => '<p>The job execution summary for a thing.</p>', 'refs' => [ 'JobExecutionSummaryForThingList$member' => NULL, ], ], 'JobExecutionSummaryForThingList' => [ 'base' => NULL, 'refs' => [ 'ListJobExecutionsForThingResponse$executionSummaries' => '<p>A list of job execution summaries.</p>', ], ], 'JobExecutionsRolloutConfig' => [ 'base' => '<p>Allows you to create a staged rollout of a job.</p>', 'refs' => [ 'CreateJobRequest$jobExecutionsRolloutConfig' => '<p>Allows you to create a staged rollout of the job.</p>', 'Job$jobExecutionsRolloutConfig' => '<p>Allows you to create a staged rollout of a job.</p>', 'UpdateJobRequest$jobExecutionsRolloutConfig' => '<p>Allows you to create a staged rollout of the job.</p>', ], ], 'JobId' => [ 'base' => NULL, 'refs' => [ 'AssociateTargetsWithJobRequest$jobId' => '<p>The unique identifier you assigned to this job when it was created.</p>', 'AssociateTargetsWithJobResponse$jobId' => '<p>The unique identifier you assigned to this job when it was created.</p>', 'CancelJobExecutionRequest$jobId' => '<p>The ID of the job to be canceled.</p>', 'CancelJobRequest$jobId' => '<p>The unique identifier you assigned to this job when it was created.</p>', 'CancelJobResponse$jobId' => '<p>The unique identifier you assigned to this job when it was created.</p>', 'CreateJobRequest$jobId' => '<p>A job identifier which must be unique for your AWS account. We recommend using a UUID. Alpha-numeric characters, "-" and "_" are valid for use here.</p>', 'CreateJobResponse$jobId' => '<p>The unique identifier you assigned to this job.</p>', 'DeleteJobExecutionRequest$jobId' => '<p>The ID of the job whose execution on a particular device will be deleted.</p>', 'DeleteJobRequest$jobId' => '<p>The ID of the job to be deleted.</p> <p>After a job deletion is completed, you may reuse this jobId when you create a new job. However, this is not recommended, and you must ensure that your devices are not using the jobId to refer to the deleted job.</p>', 'DescribeJobExecutionRequest$jobId' => '<p>The unique identifier you assigned to this job when it was created.</p>', 'DescribeJobRequest$jobId' => '<p>The unique identifier you assigned to this job when it was created.</p>', 'GetJobDocumentRequest$jobId' => '<p>The unique identifier you assigned to this job when it was created.</p>', 'Job$jobId' => '<p>The unique identifier you assigned to this job when it was created.</p>', 'JobExecution$jobId' => '<p>The unique identifier you assigned to the job when it was created.</p>', 'JobExecutionSummaryForThing$jobId' => '<p>The unique identifier you assigned to this job when it was created.</p>', 'JobSummary$jobId' => '<p>The unique identifier you assigned to this job when it was created.</p>', 'ListJobExecutionsForJobRequest$jobId' => '<p>The unique identifier you assigned to this job when it was created.</p>', 'UpdateJobRequest$jobId' => '<p>The ID of the job to be updated.</p>', ], ], 'JobProcessDetails' => [ 'base' => '<p>The job process details.</p>', 'refs' => [ 'Job$jobProcessDetails' => '<p>Details about the job process.</p>', ], ], 'JobStatus' => [ 'base' => NULL, 'refs' => [ 'Job$status' => '<p>The status of the job, one of <code>IN_PROGRESS</code>, <code>CANCELED</code>, <code>DELETION_IN_PROGRESS</code> or <code>COMPLETED</code>. </p>', 'JobSummary$status' => '<p>The job summary status.</p>', 'ListJobsRequest$status' => '<p>An optional filter that lets you search for jobs that have the specified status.</p>', ], ], 'JobSummary' => [ 'base' => '<p>The job summary.</p>', 'refs' => [ 'JobSummaryList$member' => NULL, ], ], 'JobSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListJobsResponse$jobs' => '<p>A list of jobs.</p>', ], ], 'JobTargets' => [ 'base' => NULL, 'refs' => [ 'AssociateTargetsWithJobRequest$targets' => '<p>A list of thing group ARNs that define the targets of the job.</p>', 'CreateJobRequest$targets' => '<p>A list of things and thing groups to which the job should be sent.</p>', 'Job$targets' => '<p>A list of IoT things and thing groups to which the job should be sent.</p>', ], ], 'JsonDocument' => [ 'base' => NULL, 'refs' => [ 'ThingDocument$shadow' => '<p>The shadow.</p>', ], ], 'Key' => [ 'base' => NULL, 'refs' => [ 'S3Action$key' => '<p>The object key.</p>', ], ], 'KeyName' => [ 'base' => NULL, 'refs' => [ 'PublicKeyMap$key' => NULL, ], ], 'KeyPair' => [ 'base' => '<p>Describes a key pair.</p>', 'refs' => [ 'CreateKeysAndCertificateResponse$keyPair' => '<p>The generated key pair.</p>', 'CreateProvisioningClaimResponse$keyPair' => '<p>The provisioning claim key pair.</p>', ], ], 'KeyValue' => [ 'base' => NULL, 'refs' => [ 'PublicKeyMap$value' => NULL, ], ], 'KinesisAction' => [ 'base' => '<p>Describes an action to write data to an Amazon Kinesis stream.</p>', 'refs' => [ 'Action$kinesis' => '<p>Write data to an Amazon Kinesis stream.</p>', ], ], 'LambdaAction' => [ 'base' => '<p>Describes an action to invoke a Lambda function.</p>', 'refs' => [ 'Action$lambda' => '<p>Invoke a Lambda function.</p>', ], ], 'LaserMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListJobExecutionsForJobRequest$maxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListJobExecutionsForThingRequest$maxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListJobsRequest$maxResults' => '<p>The maximum number of results to return per request.</p>', ], ], 'LastModifiedDate' => [ 'base' => NULL, 'refs' => [ 'DescribeEventConfigurationsResponse$lastModifiedDate' => '<p>The date the event configurations were last modified.</p>', 'DescribeThingRegistrationTaskResponse$lastModifiedDate' => '<p>The date when the task was last modified.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>A limit has been exceeded.</p>', 'refs' => [], ], 'ListActiveViolationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListActiveViolationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAttachedPoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAttachedPoliciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAuditFindingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAuditFindingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAuditMitigationActionsExecutionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAuditMitigationActionsExecutionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAuditMitigationActionsTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAuditMitigationActionsTasksResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAuditTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAuditTasksResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAuthorizersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAuthorizersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListBillingGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBillingGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCACertificatesRequest' => [ 'base' => '<p>Input for the ListCACertificates operation.</p>', 'refs' => [], ], 'ListCACertificatesResponse' => [ 'base' => '<p>The output from the ListCACertificates operation.</p>', 'refs' => [], ], 'ListCertificatesByCARequest' => [ 'base' => '<p>The input to the ListCertificatesByCA operation.</p>', 'refs' => [], ], 'ListCertificatesByCAResponse' => [ 'base' => '<p>The output of the ListCertificatesByCA operation.</p>', 'refs' => [], ], 'ListCertificatesRequest' => [ 'base' => '<p>The input for the ListCertificates operation.</p>', 'refs' => [], ], 'ListCertificatesResponse' => [ 'base' => '<p>The output of the ListCertificates operation.</p>', 'refs' => [], ], 'ListDimensionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDimensionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDomainConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDomainConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIndicesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIndicesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListJobExecutionsForJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListJobExecutionsForJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListJobExecutionsForThingRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListJobExecutionsForThingResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMitigationActionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMitigationActionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListOTAUpdatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListOTAUpdatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListOutgoingCertificatesRequest' => [ 'base' => '<p>The input to the ListOutgoingCertificates operation.</p>', 'refs' => [], ], 'ListOutgoingCertificatesResponse' => [ 'base' => '<p>The output from the ListOutgoingCertificates operation.</p>', 'refs' => [], ], 'ListPoliciesRequest' => [ 'base' => '<p>The input for the ListPolicies operation.</p>', 'refs' => [], ], 'ListPoliciesResponse' => [ 'base' => '<p>The output from the ListPolicies operation.</p>', 'refs' => [], ], 'ListPolicyPrincipalsRequest' => [ 'base' => '<p>The input for the ListPolicyPrincipals operation.</p>', 'refs' => [], ], 'ListPolicyPrincipalsResponse' => [ 'base' => '<p>The output from the ListPolicyPrincipals operation.</p>', 'refs' => [], ], 'ListPolicyVersionsRequest' => [ 'base' => '<p>The input for the ListPolicyVersions operation.</p>', 'refs' => [], ], 'ListPolicyVersionsResponse' => [ 'base' => '<p>The output from the ListPolicyVersions operation.</p>', 'refs' => [], ], 'ListPrincipalPoliciesRequest' => [ 'base' => '<p>The input for the ListPrincipalPolicies operation.</p>', 'refs' => [], ], 'ListPrincipalPoliciesResponse' => [ 'base' => '<p>The output from the ListPrincipalPolicies operation.</p>', 'refs' => [], ], 'ListPrincipalThingsRequest' => [ 'base' => '<p>The input for the ListPrincipalThings operation.</p>', 'refs' => [], ], 'ListPrincipalThingsResponse' => [ 'base' => '<p>The output from the ListPrincipalThings operation.</p>', 'refs' => [], ], 'ListProvisioningTemplateVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListProvisioningTemplateVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListProvisioningTemplatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListProvisioningTemplatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRoleAliasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRoleAliasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListScheduledAuditsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListScheduledAuditsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityProfilesForTargetRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityProfilesForTargetResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityProfilesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTargetsForPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTargetsForPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTargetsForSecurityProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTargetsForSecurityProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListThingGroupsForThingRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListThingGroupsForThingResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListThingGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListThingGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListThingPrincipalsRequest' => [ 'base' => '<p>The input for the ListThingPrincipal operation.</p>', 'refs' => [], ], 'ListThingPrincipalsResponse' => [ 'base' => '<p>The output from the ListThingPrincipals operation.</p>', 'refs' => [], ], 'ListThingRegistrationTaskReportsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListThingRegistrationTaskReportsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListThingRegistrationTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListThingRegistrationTasksResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListThingTypesRequest' => [ 'base' => '<p>The input for the ListThingTypes operation.</p>', 'refs' => [], ], 'ListThingTypesResponse' => [ 'base' => '<p>The output for the ListThingTypes operation.</p>', 'refs' => [], ], 'ListThingsInBillingGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListThingsInBillingGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListThingsInThingGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListThingsInThingGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListThingsRequest' => [ 'base' => '<p>The input for the ListThings operation.</p>', 'refs' => [], ], 'ListThingsResponse' => [ 'base' => '<p>The output from the ListThings operation.</p>', 'refs' => [], ], 'ListTopicRuleDestinationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTopicRuleDestinationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTopicRulesRequest' => [ 'base' => '<p>The input for the ListTopicRules operation.</p>', 'refs' => [], ], 'ListTopicRulesResponse' => [ 'base' => '<p>The output from the ListTopicRules operation.</p>', 'refs' => [], ], 'ListV2LoggingLevelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListV2LoggingLevelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListViolationEventsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListViolationEventsResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogGroupName' => [ 'base' => NULL, 'refs' => [ 'CloudwatchLogsAction$logGroupName' => '<p>The CloudWatch log group to which the action sends data.</p>', ], ], 'LogLevel' => [ 'base' => NULL, 'refs' => [ 'EnableIoTLoggingParams$logLevel' => '<p>Specifies the types of information to be logged.</p>', 'GetLoggingOptionsResponse$logLevel' => '<p>The logging level.</p>', 'GetV2LoggingOptionsResponse$defaultLogLevel' => '<p>The default log level.</p>', 'LogTargetConfiguration$logLevel' => '<p>The logging level.</p>', 'LoggingOptionsPayload$logLevel' => '<p>The log level.</p>', 'SetV2LoggingLevelRequest$logLevel' => '<p>The log level.</p>', 'SetV2LoggingOptionsRequest$defaultLogLevel' => '<p>The default logging level.</p>', ], ], 'LogTarget' => [ 'base' => '<p>A log target.</p>', 'refs' => [ 'LogTargetConfiguration$logTarget' => '<p>A log target</p>', 'SetV2LoggingLevelRequest$logTarget' => '<p>The log target.</p>', ], ], 'LogTargetConfiguration' => [ 'base' => '<p>The target configuration.</p>', 'refs' => [ 'LogTargetConfigurations$member' => NULL, ], ], 'LogTargetConfigurations' => [ 'base' => NULL, 'refs' => [ 'ListV2LoggingLevelsResponse$logTargetConfigurations' => '<p>The logging configuration for a target.</p>', ], ], 'LogTargetName' => [ 'base' => NULL, 'refs' => [ 'DeleteV2LoggingLevelRequest$targetName' => '<p>The name of the resource for which you are configuring logging.</p>', 'LogTarget$targetName' => '<p>The target name.</p>', ], ], 'LogTargetType' => [ 'base' => NULL, 'refs' => [ 'DeleteV2LoggingLevelRequest$targetType' => '<p>The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.</p>', 'ListV2LoggingLevelsRequest$targetType' => '<p>The type of resource for which you are configuring logging. Must be <code>THING_Group</code>.</p>', 'LogTarget$targetType' => '<p>The target type.</p>', ], ], 'LoggingOptionsPayload' => [ 'base' => '<p>Describes the logging options payload.</p>', 'refs' => [ 'SetLoggingOptionsRequest$loggingOptionsPayload' => '<p>The logging options payload.</p>', ], ], 'MalformedPolicyException' => [ 'base' => '<p>The policy documentation is not valid.</p>', 'refs' => [], ], 'Marker' => [ 'base' => NULL, 'refs' => [ 'ListAttachedPoliciesRequest$marker' => '<p>The token to retrieve the next set of results.</p>', 'ListAttachedPoliciesResponse$nextMarker' => '<p>The token to retrieve the next set of results, or ``null`` if there are no more results.</p>', 'ListAuthorizersRequest$marker' => '<p>A marker used to get the next set of results.</p>', 'ListAuthorizersResponse$nextMarker' => '<p>A marker used to get the next set of results.</p>', 'ListCACertificatesRequest$marker' => '<p>The marker for the next set of results.</p>', 'ListCACertificatesResponse$nextMarker' => '<p>The current position within the list of CA certificates.</p>', 'ListCertificatesByCARequest$marker' => '<p>The marker for the next set of results.</p>', 'ListCertificatesByCAResponse$nextMarker' => '<p>The marker for the next set of results, or null if there are no additional results.</p>', 'ListCertificatesRequest$marker' => '<p>The marker for the next set of results.</p>', 'ListCertificatesResponse$nextMarker' => '<p>The marker for the next set of results, or null if there are no additional results.</p>', 'ListDomainConfigurationsRequest$marker' => '<p>The marker for the next set of results.</p>', 'ListDomainConfigurationsResponse$nextMarker' => '<p>The marker for the next set of results.</p>', 'ListOutgoingCertificatesRequest$marker' => '<p>The marker for the next set of results.</p>', 'ListOutgoingCertificatesResponse$nextMarker' => '<p>The marker for the next set of results.</p>', 'ListPoliciesRequest$marker' => '<p>The marker for the next set of results.</p>', 'ListPoliciesResponse$nextMarker' => '<p>The marker for the next set of results, or null if there are no additional results.</p>', 'ListPolicyPrincipalsRequest$marker' => '<p>The marker for the next set of results.</p>', 'ListPolicyPrincipalsResponse$nextMarker' => '<p>The marker for the next set of results, or null if there are no additional results.</p>', 'ListPrincipalPoliciesRequest$marker' => '<p>The marker for the next set of results.</p>', 'ListPrincipalPoliciesResponse$nextMarker' => '<p>The marker for the next set of results, or null if there are no additional results.</p>', 'ListRoleAliasesRequest$marker' => '<p>A marker used to get the next set of results.</p>', 'ListRoleAliasesResponse$nextMarker' => '<p>A marker used to get the next set of results.</p>', 'ListTargetsForPolicyRequest$marker' => '<p>A marker used to get the next set of results.</p>', 'ListTargetsForPolicyResponse$nextMarker' => '<p>A marker used to get the next set of results.</p>', ], ], 'MaxJobExecutionsPerMin' => [ 'base' => NULL, 'refs' => [ 'JobExecutionsRolloutConfig$maximumPerMinute' => '<p>The maximum number of things that will be notified of a pending job, per minute. This parameter allows you to create a staged rollout.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListActiveViolationsRequest$maxResults' => '<p>The maximum number of results to return at one time.</p>', 'ListAuditFindingsRequest$maxResults' => '<p>The maximum number of results to return at one time. The default is 25.</p>', 'ListAuditMitigationActionsExecutionsRequest$maxResults' => '<p>The maximum number of results to return at one time. The default is 25.</p>', 'ListAuditMitigationActionsTasksRequest$maxResults' => '<p>The maximum number of results to return at one time. The default is 25.</p>', 'ListAuditTasksRequest$maxResults' => '<p>The maximum number of results to return at one time. The default is 25.</p>', 'ListDimensionsRequest$maxResults' => '<p>The maximum number of results to retrieve at one time.</p>', 'ListMitigationActionsRequest$maxResults' => '<p>The maximum number of results to return at one time. The default is 25.</p>', 'ListOTAUpdatesRequest$maxResults' => '<p>The maximum number of results to return at one time.</p>', 'ListProvisioningTemplateVersionsRequest$maxResults' => '<p>The maximum number of results to return at one time.</p>', 'ListProvisioningTemplatesRequest$maxResults' => '<p>The maximum number of results to return at one time.</p>', 'ListScheduledAuditsRequest$maxResults' => '<p>The maximum number of results to return at one time. The default is 25.</p>', 'ListSecurityProfilesForTargetRequest$maxResults' => '<p>The maximum number of results to return at one time.</p>', 'ListSecurityProfilesRequest$maxResults' => '<p>The maximum number of results to return at one time.</p>', 'ListStreamsRequest$maxResults' => '<p>The maximum number of results to return at a time.</p>', 'ListTargetsForSecurityProfileRequest$maxResults' => '<p>The maximum number of results to return at one time.</p>', 'ListViolationEventsRequest$maxResults' => '<p>The maximum number of results to return at one time.</p>', ], ], 'Maximum' => [ 'base' => NULL, 'refs' => [ 'Statistics$maximum' => '<p>The maximum aggregated field value.</p>', ], ], 'MaximumPerMinute' => [ 'base' => NULL, 'refs' => [ 'AwsJobExecutionsRolloutConfig$maximumPerMinute' => '<p>The maximum number of OTA update job executions started per minute.</p>', ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'OutgoingCertificate$transferMessage' => '<p>The transfer message.</p>', 'RejectCertificateTransferRequest$rejectReason' => '<p>The reason the certificate transfer was rejected.</p>', 'TransferCertificateRequest$transferMessage' => '<p>The transfer message.</p>', 'TransferData$transferMessage' => '<p>The transfer message.</p>', 'TransferData$rejectReason' => '<p>The reason why the transfer was rejected.</p>', ], ], 'MessageFormat' => [ 'base' => NULL, 'refs' => [ 'SnsAction$messageFormat' => '<p>(Optional) The message format of the message to publish. Accepted values are "JSON" and "RAW". The default value of the attribute is "RAW". SNS uses this setting to determine if the payload should be parsed and relevant platform-specific bits of the payload should be extracted. To read more about SNS message formats, see <a href="https://docs.aws.amazon.com/sns/latest/dg/json-formats.html">https://docs.aws.amazon.com/sns/latest/dg/json-formats.html</a> refer to their official documentation.</p>', ], ], 'MessageId' => [ 'base' => NULL, 'refs' => [ 'IotEventsAction$messageId' => '<p>[Optional] Use this to ensure that only one input (message) with a given messageId will be processed by an AWS IoT Events detector.</p>', ], ], 'MetricDimension' => [ 'base' => '<p>The dimension of a metric.</p>', 'refs' => [ 'Behavior$metricDimension' => '<p>The dimension for a metric in your behavior. For example, using a <code>TOPIC_FILTER</code> dimension, you can narrow down the scope of the metric only to MQTT topics whose name match the pattern specified in the dimension.</p>', 'MetricToRetain$metricDimension' => '<p>The dimension of a metric.</p>', ], ], 'MetricToRetain' => [ 'base' => '<p>The metric you want to retain. Dimensions are optional.</p>', 'refs' => [ 'AdditionalMetricsToRetainV2List$member' => NULL, ], ], 'MetricValue' => [ 'base' => '<p>The value to be compared with the <code>metric</code>.</p>', 'refs' => [ 'ActiveViolation$lastViolationValue' => '<p>The value of the metric (the measurement) which caused the most recent violation.</p>', 'BehaviorCriteria$value' => '<p>The value to be compared with the <code>metric</code>.</p>', 'ViolationEvent$metricValue' => '<p>The value of the metric (the measurement).</p>', ], ], 'Minimum' => [ 'base' => NULL, 'refs' => [ 'Statistics$minimum' => '<p>The minimum aggregated field value.</p>', ], ], 'MinimumNumberOfExecutedThings' => [ 'base' => NULL, 'refs' => [ 'AbortCriteria$minNumberOfExecutedThings' => '<p>The minimum number of things which must receive job execution notifications before the job can be aborted.</p>', ], ], 'MissingContextValue' => [ 'base' => NULL, 'refs' => [ 'MissingContextValues$member' => NULL, ], ], 'MissingContextValues' => [ 'base' => NULL, 'refs' => [ 'AuthResult$missingContextValues' => '<p>Contains any missing context values found while evaluating policy.</p>', ], ], 'MitigationAction' => [ 'base' => '<p>Describes which changes should be applied as part of a mitigation action.</p>', 'refs' => [ 'MitigationActionList$member' => NULL, ], ], 'MitigationActionArn' => [ 'base' => NULL, 'refs' => [ 'CreateMitigationActionResponse$actionArn' => '<p>The ARN for the new mitigation action.</p>', 'DescribeMitigationActionResponse$actionArn' => '<p>The ARN that identifies this migration action.</p>', 'MitigationActionIdentifier$actionArn' => '<p>The IAM role ARN used to apply this mitigation action.</p>', 'UpdateMitigationActionResponse$actionArn' => '<p>The ARN for the new mitigation action.</p>', ], ], 'MitigationActionId' => [ 'base' => NULL, 'refs' => [ 'AuditMitigationActionExecutionMetadata$actionId' => '<p>The unique identifier for the mitigation action being applied by the task.</p>', 'CreateMitigationActionResponse$actionId' => '<p>A unique identifier for the new mitigation action.</p>', 'DescribeMitigationActionResponse$actionId' => '<p>A unique identifier for this action.</p>', 'MitigationAction$id' => '<p>A unique identifier for the mitigation action.</p>', 'UpdateMitigationActionResponse$actionId' => '<p>A unique identifier for the mitigation action.</p>', ], ], 'MitigationActionIdentifier' => [ 'base' => '<p>Information that identifies a mitigation action. This information is returned by ListMitigationActions.</p>', 'refs' => [ 'MitigationActionIdentifierList$member' => NULL, ], ], 'MitigationActionIdentifierList' => [ 'base' => NULL, 'refs' => [ 'ListMitigationActionsResponse$actionIdentifiers' => '<p>A set of actions that matched the specified filter criteria.</p>', ], ], 'MitigationActionList' => [ 'base' => NULL, 'refs' => [ 'DescribeAuditMitigationActionsTaskResponse$actionsDefinition' => '<p>Specifies the mitigation actions and their parameters that are applied as part of this task.</p>', ], ], 'MitigationActionName' => [ 'base' => NULL, 'refs' => [ 'AuditMitigationActionExecutionMetadata$actionName' => '<p>The friendly name of the mitigation action being applied by the task.</p>', 'CreateMitigationActionRequest$actionName' => '<p>A friendly name for the action. Choose a friendly name that accurately describes the action (for example, <code>EnableLoggingAction</code>).</p>', 'DeleteMitigationActionRequest$actionName' => '<p>The name of the mitigation action that you want to delete.</p>', 'DescribeMitigationActionRequest$actionName' => '<p>The friendly name that uniquely identifies the mitigation action.</p>', 'DescribeMitigationActionResponse$actionName' => '<p>The friendly name that uniquely identifies the mitigation action.</p>', 'MitigationAction$name' => '<p>A user-friendly name for the mitigation action.</p>', 'MitigationActionIdentifier$actionName' => '<p>The friendly name of the mitigation action.</p>', 'MitigationActionNameList$member' => NULL, 'UpdateMitigationActionRequest$actionName' => '<p>The friendly name for the mitigation action. You can\'t change the name by using <code>UpdateMitigationAction</code>. Instead, you must delete and re-create the mitigation action with the new name.</p>', ], ], 'MitigationActionNameList' => [ 'base' => NULL, 'refs' => [ 'AuditCheckToActionsMapping$value' => NULL, ], ], 'MitigationActionParams' => [ 'base' => '<p>The set of parameters for this mitigation action. You can specify only one type of parameter (in other words, you can apply only one action for each defined mitigation action).</p>', 'refs' => [ 'CreateMitigationActionRequest$actionParams' => '<p>Defines the type of action and the parameters for that action.</p>', 'DescribeMitigationActionResponse$actionParams' => '<p>Parameters that control how the mitigation action is applied, specific to the type of mitigation action.</p>', 'MitigationAction$actionParams' => '<p>The set of parameters for this mitigation action. The parameters vary, depending on the kind of action you apply.</p>', 'UpdateMitigationActionRequest$actionParams' => '<p>Defines the type of action and the parameters for that action.</p>', ], ], 'MitigationActionType' => [ 'base' => NULL, 'refs' => [ 'DescribeMitigationActionResponse$actionType' => '<p>The type of mitigation action.</p>', 'ListMitigationActionsRequest$actionType' => '<p>Specify a value to limit the result to mitigation actions with a specific action type.</p>', ], ], 'MqttClientId' => [ 'base' => NULL, 'refs' => [ 'MqttContext$clientId' => '<p>The value of the <code>clientId</code> key in an MQTT authorization request.</p>', ], ], 'MqttContext' => [ 'base' => '<p>Specifies the MQTT context to use for the test authorizer request</p>', 'refs' => [ 'TestInvokeAuthorizerRequest$mqttContext' => '<p>Specifies a test MQTT authorization request.</p>', ], ], 'MqttPassword' => [ 'base' => NULL, 'refs' => [ 'MqttContext$password' => '<p>The value of the <code>password</code> key in an MQTT authorization request.</p>', ], ], 'MqttUsername' => [ 'base' => NULL, 'refs' => [ 'MqttContext$username' => '<p>The value of the <code>username</code> key in an MQTT authorization request.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListActiveViolationsRequest$nextToken' => '<p>The token for the next set of results.</p>', 'ListActiveViolationsResponse$nextToken' => '<p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>', 'ListAuditFindingsRequest$nextToken' => '<p>The token for the next set of results.</p>', 'ListAuditFindingsResponse$nextToken' => '<p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>', 'ListAuditMitigationActionsExecutionsRequest$nextToken' => '<p>The token for the next set of results.</p>', 'ListAuditMitigationActionsExecutionsResponse$nextToken' => '<p>The token for the next set of results.</p>', 'ListAuditMitigationActionsTasksRequest$nextToken' => '<p>The token for the next set of results.</p>', 'ListAuditMitigationActionsTasksResponse$nextToken' => '<p>The token for the next set of results.</p>', 'ListAuditTasksRequest$nextToken' => '<p>The token for the next set of results.</p>', 'ListAuditTasksResponse$nextToken' => '<p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>', 'ListBillingGroupsRequest$nextToken' => '<p>The token to retrieve the next set of results.</p>', 'ListBillingGroupsResponse$nextToken' => '<p>The token used to get the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListDimensionsRequest$nextToken' => '<p>The token for the next set of results.</p>', 'ListDimensionsResponse$nextToken' => '<p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>', 'ListIndicesRequest$nextToken' => '<p>The token used to get the next set of results, or <code>null</code> if there are no additional results.</p>', 'ListIndicesResponse$nextToken' => '<p>The token used to get the next set of results, or <code>null</code> if there are no additional results.</p>', 'ListJobExecutionsForJobRequest$nextToken' => '<p>The token to retrieve the next set of results.</p>', 'ListJobExecutionsForJobResponse$nextToken' => '<p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListJobExecutionsForThingRequest$nextToken' => '<p>The token to retrieve the next set of results.</p>', 'ListJobExecutionsForThingResponse$nextToken' => '<p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListJobsRequest$nextToken' => '<p>The token to retrieve the next set of results.</p>', 'ListJobsResponse$nextToken' => '<p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListMitigationActionsRequest$nextToken' => '<p>The token for the next set of results.</p>', 'ListMitigationActionsResponse$nextToken' => '<p>The token for the next set of results.</p>', 'ListOTAUpdatesRequest$nextToken' => '<p>A token used to retrieve the next set of results.</p>', 'ListOTAUpdatesResponse$nextToken' => '<p>A token to use to get the next set of results.</p>', 'ListPrincipalThingsRequest$nextToken' => '<p>The token to retrieve the next set of results.</p>', 'ListPrincipalThingsResponse$nextToken' => '<p>The token used to get the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListProvisioningTemplateVersionsRequest$nextToken' => '<p>A token to retrieve the next set of results.</p>', 'ListProvisioningTemplateVersionsResponse$nextToken' => '<p>A token to retrieve the next set of results.</p>', 'ListProvisioningTemplatesRequest$nextToken' => '<p>A token to retrieve the next set of results.</p>', 'ListProvisioningTemplatesResponse$nextToken' => '<p>A token to retrieve the next set of results.</p>', 'ListScheduledAuditsRequest$nextToken' => '<p>The token for the next set of results.</p>', 'ListScheduledAuditsResponse$nextToken' => '<p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>', 'ListSecurityProfilesForTargetRequest$nextToken' => '<p>The token for the next set of results.</p>', 'ListSecurityProfilesForTargetResponse$nextToken' => '<p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>', 'ListSecurityProfilesRequest$nextToken' => '<p>The token for the next set of results.</p>', 'ListSecurityProfilesResponse$nextToken' => '<p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>', 'ListStreamsRequest$nextToken' => '<p>A token used to get the next set of results.</p>', 'ListStreamsResponse$nextToken' => '<p>A token used to get the next set of results.</p>', 'ListTagsForResourceRequest$nextToken' => '<p>The token to retrieve the next set of results.</p>', 'ListTagsForResourceResponse$nextToken' => '<p>The token used to get the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListTargetsForSecurityProfileRequest$nextToken' => '<p>The token for the next set of results.</p>', 'ListTargetsForSecurityProfileResponse$nextToken' => '<p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>', 'ListThingGroupsForThingRequest$nextToken' => '<p>The token to retrieve the next set of results.</p>', 'ListThingGroupsForThingResponse$nextToken' => '<p>The token used to get the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListThingGroupsRequest$nextToken' => '<p>The token to retrieve the next set of results.</p>', 'ListThingGroupsResponse$nextToken' => '<p>The token used to get the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListThingRegistrationTaskReportsRequest$nextToken' => '<p>The token to retrieve the next set of results.</p>', 'ListThingRegistrationTaskReportsResponse$nextToken' => '<p>The token used to get the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListThingRegistrationTasksRequest$nextToken' => '<p>The token to retrieve the next set of results.</p>', 'ListThingRegistrationTasksResponse$nextToken' => '<p>The token used to get the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListThingTypesRequest$nextToken' => '<p>The token to retrieve the next set of results.</p>', 'ListThingTypesResponse$nextToken' => '<p>The token for the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListThingsInBillingGroupRequest$nextToken' => '<p>The token to retrieve the next set of results.</p>', 'ListThingsInBillingGroupResponse$nextToken' => '<p>The token used to get the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListThingsInThingGroupRequest$nextToken' => '<p>The token to retrieve the next set of results.</p>', 'ListThingsInThingGroupResponse$nextToken' => '<p>The token used to get the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListThingsRequest$nextToken' => '<p>The token to retrieve the next set of results.</p>', 'ListThingsResponse$nextToken' => '<p>The token used to get the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListTopicRuleDestinationsRequest$nextToken' => '<p>The token to retrieve the next set of results.</p>', 'ListTopicRuleDestinationsResponse$nextToken' => '<p>The token to retrieve the next set of results.</p>', 'ListTopicRulesRequest$nextToken' => '<p>A token used to retrieve the next value.</p>', 'ListTopicRulesResponse$nextToken' => '<p>A token used to retrieve the next value.</p>', 'ListV2LoggingLevelsRequest$nextToken' => '<p>The token used to get the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListV2LoggingLevelsResponse$nextToken' => '<p>The token used to get the next set of results, or <b>null</b> if there are no additional results.</p>', 'ListViolationEventsRequest$nextToken' => '<p>The token for the next set of results.</p>', 'ListViolationEventsResponse$nextToken' => '<p>A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional results.</p>', 'SearchIndexRequest$nextToken' => '<p>The token used to get the next set of results, or <code>null</code> if there are no additional results.</p>', 'SearchIndexResponse$nextToken' => '<p>The token used to get the next set of results, or <code>null</code> if there are no additional results.</p>', ], ], 'NonCompliantChecksCount' => [ 'base' => NULL, 'refs' => [ 'TaskStatistics$nonCompliantChecks' => '<p>The number of checks that found noncompliant resources.</p>', ], ], 'NonCompliantResource' => [ 'base' => '<p>Information about the resource that was noncompliant with the audit check.</p>', 'refs' => [ 'AuditFinding$nonCompliantResource' => '<p>The resource that was found to be noncompliant with the audit check.</p>', ], ], 'NonCompliantResourcesCount' => [ 'base' => NULL, 'refs' => [ 'AuditCheckDetails$nonCompliantResourcesCount' => '<p>The number of resources that were found noncompliant during the check.</p>', ], ], 'NotConfiguredException' => [ 'base' => '<p>The resource is not configured.</p>', 'refs' => [], ], 'NumberOfThings' => [ 'base' => NULL, 'refs' => [ 'RateIncreaseCriteria$numberOfNotifiedThings' => '<p>The threshold for number of notified things that will initiate the increase in rate of rollout.</p>', 'RateIncreaseCriteria$numberOfSucceededThings' => '<p>The threshold for number of succeeded things that will initiate the increase in rate of rollout.</p>', ], ], 'OTAUpdateArn' => [ 'base' => NULL, 'refs' => [ 'CreateOTAUpdateResponse$otaUpdateArn' => '<p>The OTA update ARN.</p>', 'OTAUpdateInfo$otaUpdateArn' => '<p>The OTA update ARN.</p>', 'OTAUpdateSummary$otaUpdateArn' => '<p>The OTA update ARN.</p>', ], ], 'OTAUpdateDescription' => [ 'base' => NULL, 'refs' => [ 'CreateOTAUpdateRequest$description' => '<p>The description of the OTA update.</p>', 'OTAUpdateInfo$description' => '<p>A description of the OTA update.</p>', ], ], 'OTAUpdateErrorMessage' => [ 'base' => NULL, 'refs' => [ 'ErrorInfo$message' => '<p>The error message.</p>', ], ], 'OTAUpdateFile' => [ 'base' => '<p>Describes a file to be associated with an OTA update.</p>', 'refs' => [ 'OTAUpdateFiles$member' => NULL, ], ], 'OTAUpdateFileVersion' => [ 'base' => NULL, 'refs' => [ 'OTAUpdateFile$fileVersion' => '<p>The file version.</p>', ], ], 'OTAUpdateFiles' => [ 'base' => NULL, 'refs' => [ 'CreateOTAUpdateRequest$files' => '<p>The files to be streamed by the OTA update.</p>', 'OTAUpdateInfo$otaUpdateFiles' => '<p>A list of files associated with the OTA update.</p>', ], ], 'OTAUpdateId' => [ 'base' => NULL, 'refs' => [ 'CreateOTAUpdateRequest$otaUpdateId' => '<p>The ID of the OTA update to be created.</p>', 'CreateOTAUpdateResponse$otaUpdateId' => '<p>The OTA update ID.</p>', 'DeleteOTAUpdateRequest$otaUpdateId' => '<p>The ID of the OTA update to delete.</p>', 'GetOTAUpdateRequest$otaUpdateId' => '<p>The OTA update ID.</p>', 'OTAUpdateInfo$otaUpdateId' => '<p>The OTA update ID.</p>', 'OTAUpdateSummary$otaUpdateId' => '<p>The OTA update ID.</p>', ], ], 'OTAUpdateInfo' => [ 'base' => '<p>Information about an OTA update.</p>', 'refs' => [ 'GetOTAUpdateResponse$otaUpdateInfo' => '<p>The OTA update info.</p>', ], ], 'OTAUpdateStatus' => [ 'base' => NULL, 'refs' => [ 'CreateOTAUpdateResponse$otaUpdateStatus' => '<p>The OTA update status.</p>', 'ListOTAUpdatesRequest$otaUpdateStatus' => '<p>The OTA update job status.</p>', 'OTAUpdateInfo$otaUpdateStatus' => '<p>The status of the OTA update.</p>', ], ], 'OTAUpdateSummary' => [ 'base' => '<p>An OTA update summary.</p>', 'refs' => [ 'OTAUpdatesSummary$member' => NULL, ], ], 'OTAUpdatesSummary' => [ 'base' => NULL, 'refs' => [ 'ListOTAUpdatesResponse$otaUpdates' => '<p>A list of OTA update jobs.</p>', ], ], 'OptionalVersion' => [ 'base' => NULL, 'refs' => [ 'DeleteBillingGroupRequest$expectedVersion' => '<p>The expected version of the billing group. If the version of the billing group does not match the expected version specified in the request, the <code>DeleteBillingGroup</code> request is rejected with a <code>VersionConflictException</code>.</p>', 'DeleteDynamicThingGroupRequest$expectedVersion' => '<p>The expected version of the dynamic thing group to delete.</p>', 'DeleteSecurityProfileRequest$expectedVersion' => '<p>The expected version of the security profile. A new version is generated whenever the security profile is updated. If you specify a value that is different from the actual version, a <code>VersionConflictException</code> is thrown.</p>', 'DeleteThingGroupRequest$expectedVersion' => '<p>The expected version of the thing group to delete.</p>', 'DeleteThingRequest$expectedVersion' => '<p>The expected version of the thing record in the registry. If the version of the record in the registry does not match the expected version specified in the request, the <code>DeleteThing</code> request is rejected with a <code>VersionConflictException</code>.</p>', 'UpdateBillingGroupRequest$expectedVersion' => '<p>The expected version of the billing group. If the version of the billing group does not match the expected version specified in the request, the <code>UpdateBillingGroup</code> request is rejected with a <code>VersionConflictException</code>.</p>', 'UpdateDynamicThingGroupRequest$expectedVersion' => '<p>The expected version of the dynamic thing group to update.</p>', 'UpdateSecurityProfileRequest$expectedVersion' => '<p>The expected version of the security profile. A new version is generated whenever the security profile is updated. If you specify a value that is different from the actual version, a <code>VersionConflictException</code> is thrown.</p>', 'UpdateThingGroupRequest$expectedVersion' => '<p>The expected version of the thing group. If this does not match the version of the thing group being updated, the update will fail.</p>', 'UpdateThingRequest$expectedVersion' => '<p>The expected version of the thing record in the registry. If the version of the record in the registry does not match the expected version specified in the request, the <code>UpdateThing</code> request is rejected with a <code>VersionConflictException</code>.</p>', ], ], 'OutgoingCertificate' => [ 'base' => '<p>A certificate that has been transferred but not yet accepted.</p>', 'refs' => [ 'OutgoingCertificates$member' => NULL, ], ], 'OutgoingCertificates' => [ 'base' => NULL, 'refs' => [ 'ListOutgoingCertificatesResponse$outgoingCertificates' => '<p>The certificates that are being transferred but not yet accepted.</p>', ], ], 'OverrideDynamicGroups' => [ 'base' => NULL, 'refs' => [ 'AddThingToThingGroupRequest$overrideDynamicGroups' => '<p>Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing belongs to 10 thing groups, and one or more of those groups are dynamic thing groups, adding a thing to a static group removes the thing from the last dynamic group.</p>', 'AddThingsToThingGroupParams$overrideDynamicGroups' => '<p>Specifies if this mitigation action can move the things that triggered the mitigation action even if they are part of one or more dynamic things groups.</p>', 'UpdateThingGroupsForThingRequest$overrideDynamicGroups' => '<p>Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing belongs to 10 thing groups, and one or more of those groups are dynamic thing groups, adding a thing to a static group removes the thing from the last dynamic group.</p>', ], ], 'PageSize' => [ 'base' => NULL, 'refs' => [ 'ListAttachedPoliciesRequest$pageSize' => '<p>The maximum number of results to be returned per request.</p>', 'ListAuthorizersRequest$pageSize' => '<p>The maximum number of results to return at one time.</p>', 'ListCACertificatesRequest$pageSize' => '<p>The result page size.</p>', 'ListCertificatesByCARequest$pageSize' => '<p>The result page size.</p>', 'ListCertificatesRequest$pageSize' => '<p>The result page size.</p>', 'ListDomainConfigurationsRequest$pageSize' => '<p>The result page size.</p>', 'ListOutgoingCertificatesRequest$pageSize' => '<p>The result page size.</p>', 'ListPoliciesRequest$pageSize' => '<p>The result page size.</p>', 'ListPolicyPrincipalsRequest$pageSize' => '<p>The result page size.</p>', 'ListPrincipalPoliciesRequest$pageSize' => '<p>The result page size.</p>', 'ListRoleAliasesRequest$pageSize' => '<p>The maximum number of results to return at one time.</p>', 'ListTargetsForPolicyRequest$pageSize' => '<p>The maximum number of results to return at one time.</p>', ], ], 'Parameter' => [ 'base' => NULL, 'refs' => [ 'Parameters$key' => NULL, ], ], 'Parameters' => [ 'base' => NULL, 'refs' => [ 'RegisterThingRequest$parameters' => '<p>The parameters for provisioning a thing. See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-template.html">Provisioning Templates</a> for more information.</p>', ], ], 'PartitionKey' => [ 'base' => NULL, 'refs' => [ 'KinesisAction$partitionKey' => '<p>The partition key.</p>', ], ], 'PayloadField' => [ 'base' => NULL, 'refs' => [ 'DynamoDBAction$payloadField' => '<p>The action payload. This name can be customized.</p>', ], ], 'PayloadVersion' => [ 'base' => NULL, 'refs' => [ 'ProvisioningHook$payloadVersion' => '<p>The payload that was sent to the target function.</p> <p> <i>Note:</i> Only Lambda functions are currently supported.</p>', ], ], 'Percent' => [ 'base' => NULL, 'refs' => [ 'PercentList$member' => NULL, 'PercentPair$percent' => '<p>The percentile.</p>', ], ], 'PercentList' => [ 'base' => NULL, 'refs' => [ 'GetPercentilesRequest$percents' => '<p>The percentile groups returned.</p>', ], ], 'PercentPair' => [ 'base' => '<p>Describes the percentile and percentile value.</p>', 'refs' => [ 'Percentiles$member' => NULL, ], ], 'PercentValue' => [ 'base' => NULL, 'refs' => [ 'PercentPair$value' => '<p>The value of the percentile.</p>', ], ], 'Percentage' => [ 'base' => NULL, 'refs' => [ 'DescribeThingRegistrationTaskResponse$percentageProgress' => '<p>The progress of the bulk provisioning task expressed as a percentage.</p>', ], ], 'Percentiles' => [ 'base' => NULL, 'refs' => [ 'GetPercentilesResponse$percentiles' => '<p>The percentile values of the aggregated fields.</p>', ], ], 'Platform' => [ 'base' => NULL, 'refs' => [ 'SigningProfileParameter$platform' => '<p>The hardware platform of your device.</p>', ], ], 'Policies' => [ 'base' => NULL, 'refs' => [ 'Allowed$policies' => '<p>A list of policies that allowed the authentication.</p>', 'ExplicitDeny$policies' => '<p>The policies that denied the authorization.</p>', 'ImplicitDeny$policies' => '<p>Policies that don\'t contain a matching allow or deny statement for the specified action on the specified resource. </p>', 'ListAttachedPoliciesResponse$policies' => '<p>The policies.</p>', 'ListPoliciesResponse$policies' => '<p>The descriptions of the policies.</p>', 'ListPrincipalPoliciesResponse$policies' => '<p>The policies.</p>', ], ], 'Policy' => [ 'base' => '<p>Describes an AWS IoT policy.</p>', 'refs' => [ 'Policies$member' => NULL, ], ], 'PolicyArn' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyResponse$policyArn' => '<p>The policy ARN.</p>', 'CreatePolicyVersionResponse$policyArn' => '<p>The policy ARN.</p>', 'EffectivePolicy$policyArn' => '<p>The policy ARN.</p>', 'GetPolicyResponse$policyArn' => '<p>The policy ARN.</p>', 'GetPolicyVersionResponse$policyArn' => '<p>The policy ARN.</p>', 'Policy$policyArn' => '<p>The policy ARN.</p>', ], ], 'PolicyDocument' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyRequest$policyDocument' => '<p>The JSON document that describes the policy. <b>policyDocument</b> must have a minimum length of 1, with a maximum length of 2048, excluding whitespace.</p>', 'CreatePolicyResponse$policyDocument' => '<p>The JSON document that describes the policy.</p>', 'CreatePolicyVersionRequest$policyDocument' => '<p>The JSON document that describes the policy. Minimum length of 1. Maximum length of 2048, excluding whitespace.</p>', 'CreatePolicyVersionResponse$policyDocument' => '<p>The JSON document that describes the policy.</p>', 'EffectivePolicy$policyDocument' => '<p>The IAM policy document.</p>', 'GetPolicyResponse$policyDocument' => '<p>The JSON document that describes the policy.</p>', 'GetPolicyVersionResponse$policyDocument' => '<p>The JSON document that describes the policy.</p>', 'PolicyDocuments$member' => NULL, ], ], 'PolicyDocuments' => [ 'base' => NULL, 'refs' => [ 'TestInvokeAuthorizerResponse$policyDocuments' => '<p>IAM policy documents.</p>', ], ], 'PolicyName' => [ 'base' => NULL, 'refs' => [ 'AttachPolicyRequest$policyName' => '<p>The name of the policy to attach.</p>', 'AttachPrincipalPolicyRequest$policyName' => '<p>The policy name.</p>', 'CreatePolicyRequest$policyName' => '<p>The policy name.</p>', 'CreatePolicyResponse$policyName' => '<p>The policy name.</p>', 'CreatePolicyVersionRequest$policyName' => '<p>The policy name.</p>', 'DeletePolicyRequest$policyName' => '<p>The name of the policy to delete.</p>', 'DeletePolicyVersionRequest$policyName' => '<p>The name of the policy.</p>', 'DetachPolicyRequest$policyName' => '<p>The policy to detach.</p>', 'DetachPrincipalPolicyRequest$policyName' => '<p>The name of the policy to detach.</p>', 'EffectivePolicy$policyName' => '<p>The policy name.</p>', 'GetPolicyRequest$policyName' => '<p>The name of the policy.</p>', 'GetPolicyResponse$policyName' => '<p>The policy name.</p>', 'GetPolicyVersionRequest$policyName' => '<p>The name of the policy.</p>', 'GetPolicyVersionResponse$policyName' => '<p>The policy name.</p>', 'ListPolicyPrincipalsRequest$policyName' => '<p>The policy name.</p>', 'ListPolicyVersionsRequest$policyName' => '<p>The policy name.</p>', 'ListTargetsForPolicyRequest$policyName' => '<p>The policy name.</p>', 'Policy$policyName' => '<p>The policy name.</p>', 'PolicyNames$member' => NULL, 'PolicyVersionIdentifier$policyName' => '<p>The name of the policy.</p>', 'SetDefaultPolicyVersionRequest$policyName' => '<p>The policy name.</p>', ], ], 'PolicyNames' => [ 'base' => NULL, 'refs' => [ 'TestAuthorizationRequest$policyNamesToAdd' => '<p>When testing custom authorization, the policies specified here are treated as if they are attached to the principal being authorized.</p>', 'TestAuthorizationRequest$policyNamesToSkip' => '<p>When testing custom authorization, the policies specified here are treated as if they are not attached to the principal being authorized.</p>', ], ], 'PolicyTarget' => [ 'base' => NULL, 'refs' => [ 'AttachPolicyRequest$target' => '<p>The <a href="https://docs.aws.amazon.com/iot/latest/developerguide/security-iam.html">identity</a> to which the policy is attached.</p>', 'DetachPolicyRequest$target' => '<p>The target from which the policy will be detached.</p>', 'ListAttachedPoliciesRequest$target' => '<p>The group or principal for which the policies will be listed.</p>', 'PolicyTargets$member' => NULL, ], ], 'PolicyTargets' => [ 'base' => NULL, 'refs' => [ 'ListTargetsForPolicyResponse$targets' => '<p>The policy targets.</p>', ], ], 'PolicyTemplateName' => [ 'base' => NULL, 'refs' => [ 'ReplaceDefaultPolicyVersionParams$templateName' => '<p>The name of the template to be applied. The only supported value is <code>BLANK_POLICY</code>.</p>', ], ], 'PolicyVersion' => [ 'base' => '<p>Describes a policy version.</p>', 'refs' => [ 'PolicyVersions$member' => NULL, ], ], 'PolicyVersionId' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyResponse$policyVersionId' => '<p>The policy version ID.</p>', 'CreatePolicyVersionResponse$policyVersionId' => '<p>The policy version ID.</p>', 'DeletePolicyVersionRequest$policyVersionId' => '<p>The policy version ID.</p>', 'GetPolicyResponse$defaultVersionId' => '<p>The default policy version ID.</p>', 'GetPolicyVersionRequest$policyVersionId' => '<p>The policy version ID.</p>', 'GetPolicyVersionResponse$policyVersionId' => '<p>The policy version ID.</p>', 'PolicyVersion$versionId' => '<p>The policy version ID.</p>', 'PolicyVersionIdentifier$policyVersionId' => '<p>The ID of the version of the policy associated with the resource.</p>', 'SetDefaultPolicyVersionRequest$policyVersionId' => '<p>The policy version ID.</p>', ], ], 'PolicyVersionIdentifier' => [ 'base' => '<p>Information about the version of the policy associated with the resource.</p>', 'refs' => [ 'ResourceIdentifier$policyVersionIdentifier' => '<p>The version of the policy associated with the resource.</p>', ], ], 'PolicyVersions' => [ 'base' => NULL, 'refs' => [ 'ListPolicyVersionsResponse$policyVersions' => '<p>The policy versions.</p>', ], ], 'Port' => [ 'base' => NULL, 'refs' => [ 'Ports$member' => NULL, ], ], 'Ports' => [ 'base' => NULL, 'refs' => [ 'MetricValue$ports' => '<p>If the <code>comparisonOperator</code> calls for a set of ports, use this to specify that set to be compared with the <code>metric</code>.</p>', ], ], 'Prefix' => [ 'base' => NULL, 'refs' => [ 'S3Destination$prefix' => '<p>The S3 prefix.</p>', ], ], 'PresignedUrlConfig' => [ 'base' => '<p>Configuration for pre-signed S3 URLs.</p>', 'refs' => [ 'CreateJobRequest$presignedUrlConfig' => '<p>Configuration information for pre-signed S3 URLs.</p>', 'Job$presignedUrlConfig' => '<p>Configuration for pre-signed S3 URLs.</p>', 'UpdateJobRequest$presignedUrlConfig' => '<p>Configuration information for pre-signed S3 URLs.</p>', ], ], 'Principal' => [ 'base' => NULL, 'refs' => [ 'AttachPrincipalPolicyRequest$principal' => '<p>The principal, which can be a certificate ARN (as returned from the CreateCertificate operation) or an Amazon Cognito ID.</p>', 'AttachThingPrincipalRequest$principal' => '<p>The principal, which can be a certificate ARN (as returned from the CreateCertificate operation) or an Amazon Cognito ID.</p>', 'DetachPrincipalPolicyRequest$principal' => '<p>The principal.</p> <p>If the principal is a certificate, specify the certificate ARN. If the principal is an Amazon Cognito identity, specify the identity ID.</p>', 'DetachThingPrincipalRequest$principal' => '<p>If the principal is a certificate, this value must be ARN of the certificate. If the principal is an Amazon Cognito identity, this value must be the ID of the Amazon Cognito identity.</p>', 'GetEffectivePoliciesRequest$principal' => '<p>The principal.</p>', 'ListPrincipalPoliciesRequest$principal' => '<p>The principal.</p>', 'ListPrincipalThingsRequest$principal' => '<p>The principal.</p>', 'TestAuthorizationRequest$principal' => '<p>The principal.</p>', ], ], 'PrincipalArn' => [ 'base' => NULL, 'refs' => [ 'Principals$member' => NULL, ], ], 'PrincipalId' => [ 'base' => NULL, 'refs' => [ 'TestInvokeAuthorizerResponse$principalId' => '<p>The principal ID.</p>', ], ], 'Principals' => [ 'base' => NULL, 'refs' => [ 'ListPolicyPrincipalsResponse$principals' => '<p>The descriptions of the principals.</p>', 'ListThingPrincipalsResponse$principals' => '<p>The principals associated with the thing.</p>', ], ], 'PrivateKey' => [ 'base' => NULL, 'refs' => [ 'KeyPair$PrivateKey' => '<p>The private key.</p>', ], ], 'ProcessingTargetName' => [ 'base' => NULL, 'refs' => [ 'ProcessingTargetNameList$member' => NULL, ], ], 'ProcessingTargetNameList' => [ 'base' => NULL, 'refs' => [ 'JobProcessDetails$processingTargets' => '<p>The target devices to which the job execution is being rolled out. This value will be null after the job execution has finished rolling out to all the target devices.</p>', ], ], 'Protocol' => [ 'base' => NULL, 'refs' => [ 'Protocols$member' => NULL, ], ], 'Protocols' => [ 'base' => NULL, 'refs' => [ 'CreateOTAUpdateRequest$protocols' => '<p>The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When both HTTP and MQTT are specified, the target device can choose the protocol.</p>', 'OTAUpdateInfo$protocols' => '<p>The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When both HTTP and MQTT are specified, the target device can choose the protocol.</p>', ], ], 'ProvisioningHook' => [ 'base' => '<p>Structure that contains <code>payloadVersion</code> and <code>targetArn</code>.</p>', 'refs' => [ 'CreateProvisioningTemplateRequest$preProvisioningHook' => '<p>Creates a pre-provisioning hook template.</p>', 'DescribeProvisioningTemplateResponse$preProvisioningHook' => '<p>Gets information about a pre-provisioned hook.</p>', 'UpdateProvisioningTemplateRequest$preProvisioningHook' => '<p>Updates the pre-provisioning hook template.</p>', ], ], 'ProvisioningTemplateListing' => [ 'base' => NULL, 'refs' => [ 'ListProvisioningTemplatesResponse$templates' => '<p>A list of fleet provisioning templates</p>', ], ], 'ProvisioningTemplateSummary' => [ 'base' => '<p>A summary of information about a fleet provisioning template.</p>', 'refs' => [ 'ProvisioningTemplateListing$member' => NULL, ], ], 'ProvisioningTemplateVersionListing' => [ 'base' => NULL, 'refs' => [ 'ListProvisioningTemplateVersionsResponse$versions' => '<p>The list of fleet provisioning template versions.</p>', ], ], 'ProvisioningTemplateVersionSummary' => [ 'base' => '<p>A summary of information about a fleet provision template version.</p>', 'refs' => [ 'ProvisioningTemplateVersionListing$member' => NULL, ], ], 'PublicKey' => [ 'base' => NULL, 'refs' => [ 'KeyPair$PublicKey' => '<p>The public key.</p>', ], ], 'PublicKeyMap' => [ 'base' => NULL, 'refs' => [ 'AuthorizerDescription$tokenSigningPublicKeys' => '<p>The public keys used to validate the token signature returned by your custom authentication service.</p>', 'CreateAuthorizerRequest$tokenSigningPublicKeys' => '<p>The public keys used to verify the digital signature returned by your custom authentication service.</p>', 'UpdateAuthorizerRequest$tokenSigningPublicKeys' => '<p>The public keys used to verify the token signature.</p>', ], ], 'PublishFindingToSnsParams' => [ 'base' => '<p>Parameters to define a mitigation action that publishes findings to Amazon SNS. You can implement your own custom actions in response to the Amazon SNS messages.</p>', 'refs' => [ 'MitigationActionParams$publishFindingToSnsParams' => '<p>Parameters to define a mitigation action that publishes findings to Amazon SNS. You can implement your own custom actions in response to the Amazon SNS messages.</p>', ], ], 'PutAssetPropertyValueEntry' => [ 'base' => '<p>An asset property value entry containing the following information.</p>', 'refs' => [ 'PutAssetPropertyValueEntryList$member' => NULL, ], ], 'PutAssetPropertyValueEntryList' => [ 'base' => NULL, 'refs' => [ 'IotSiteWiseAction$putAssetPropertyValueEntries' => '<p>A list of asset property value entries.</p>', ], ], 'PutItemInput' => [ 'base' => '<p>The input for the DynamoActionVS action that specifies the DynamoDB table to which the message data will be written.</p>', 'refs' => [ 'DynamoDBv2Action$putItem' => '<p>Specifies the DynamoDB table to which the message data will be written. For example:</p> <p> <code>{ "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName": "my-table" } } }</code> </p> <p>Each attribute in the message payload will be written to a separate column in the DynamoDB database.</p>', ], ], 'Qos' => [ 'base' => NULL, 'refs' => [ 'RepublishAction$qos' => '<p>The Quality of Service (QoS) level to use when republishing messages. The default value is 0.</p>', ], ], 'QueryMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListIndicesRequest$maxResults' => '<p>The maximum number of results to return at one time.</p>', 'SearchIndexRequest$maxResults' => '<p>The maximum number of results to return at one time.</p>', ], ], 'QueryString' => [ 'base' => NULL, 'refs' => [ 'CreateDynamicThingGroupRequest$queryString' => '<p>The dynamic thing group search query string.</p> <p>See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/query-syntax.html">Query Syntax</a> for information about query string syntax.</p>', 'CreateDynamicThingGroupResponse$queryString' => '<p>The dynamic thing group search query string.</p>', 'DescribeThingGroupResponse$queryString' => '<p>The dynamic thing group search query string.</p>', 'GetCardinalityRequest$queryString' => '<p>The search query.</p>', 'GetPercentilesRequest$queryString' => '<p>The query string.</p>', 'GetStatisticsRequest$queryString' => '<p>The query used to search. You can specify "*" for the query string to get the count of all indexed things in your AWS account.</p>', 'SearchIndexRequest$queryString' => '<p>The search query string.</p>', 'UpdateDynamicThingGroupRequest$queryString' => '<p>The dynamic thing group search query string to update.</p>', ], ], 'QueryVersion' => [ 'base' => NULL, 'refs' => [ 'CreateDynamicThingGroupRequest$queryVersion' => '<p>The dynamic thing group query version.</p> <note> <p>Currently one query version is supported: "2017-09-30". If not specified, the query version defaults to this value.</p> </note>', 'CreateDynamicThingGroupResponse$queryVersion' => '<p>The dynamic thing group query version.</p>', 'DescribeThingGroupResponse$queryVersion' => '<p>The dynamic thing group query version.</p>', 'GetCardinalityRequest$queryVersion' => '<p>The query version.</p>', 'GetPercentilesRequest$queryVersion' => '<p>The query version.</p>', 'GetStatisticsRequest$queryVersion' => '<p>The version of the query used to search.</p>', 'SearchIndexRequest$queryVersion' => '<p>The query version.</p>', 'UpdateDynamicThingGroupRequest$queryVersion' => '<p>The dynamic thing group query version to update.</p> <note> <p>Currently one query version is supported: "2017-09-30". If not specified, the query version defaults to this value.</p> </note>', ], ], 'QueueUrl' => [ 'base' => NULL, 'refs' => [ 'SqsAction$queueUrl' => '<p>The URL of the Amazon SQS queue.</p>', ], ], 'QueuedThings' => [ 'base' => NULL, 'refs' => [ 'JobProcessDetails$numberOfQueuedThings' => '<p>The number of things that are awaiting execution of the job.</p>', ], ], 'RangeKeyField' => [ 'base' => NULL, 'refs' => [ 'DynamoDBAction$rangeKeyField' => '<p>The range key name.</p>', ], ], 'RangeKeyValue' => [ 'base' => NULL, 'refs' => [ 'DynamoDBAction$rangeKeyValue' => '<p>The range key value.</p>', ], ], 'RateIncreaseCriteria' => [ 'base' => '<p>Allows you to define a criteria to initiate the increase in rate of rollout for a job.</p>', 'refs' => [ 'ExponentialRolloutRate$rateIncreaseCriteria' => '<p>The criteria to initiate the increase in rate of rollout for a job.</p> <p>AWS IoT supports up to one digit after the decimal (for example, 1.5, but not 1.55).</p>', ], ], 'ReasonCode' => [ 'base' => NULL, 'refs' => [ 'CancelJobRequest$reasonCode' => '<p>(Optional)A reason code string that explains why the job was canceled.</p>', 'Job$reasonCode' => '<p>If the job was updated, provides the reason code for the update.</p>', ], ], 'ReasonForNonCompliance' => [ 'base' => NULL, 'refs' => [ 'AuditFinding$reasonForNonCompliance' => '<p>The reason the resource was noncompliant.</p>', ], ], 'ReasonForNonComplianceCode' => [ 'base' => NULL, 'refs' => [ 'AuditFinding$reasonForNonComplianceCode' => '<p>A code that indicates the reason that the resource was noncompliant.</p>', 'ReasonForNonComplianceCodes$member' => NULL, ], ], 'ReasonForNonComplianceCodes' => [ 'base' => NULL, 'refs' => [ 'AuditCheckToReasonCodeFilter$value' => NULL, ], ], 'Recursive' => [ 'base' => NULL, 'refs' => [ 'ListAttachedPoliciesRequest$recursive' => '<p>When true, recursively list attached policies.</p>', 'ListSecurityProfilesForTargetRequest$recursive' => '<p>If true, return child groups too.</p>', 'ListThingsInThingGroupRequest$recursive' => '<p>When true, list things in this thing group and in all child groups as well.</p>', ], ], 'RecursiveWithoutDefault' => [ 'base' => NULL, 'refs' => [ 'ListThingGroupsRequest$recursive' => '<p>If true, return child groups as well.</p>', ], ], 'RegisterCACertificateRequest' => [ 'base' => '<p>The input to the RegisterCACertificate operation.</p>', 'refs' => [], ], 'RegisterCACertificateResponse' => [ 'base' => '<p>The output from the RegisterCACertificateResponse operation.</p>', 'refs' => [], ], 'RegisterCertificateRequest' => [ 'base' => '<p>The input to the RegisterCertificate operation.</p>', 'refs' => [], ], 'RegisterCertificateResponse' => [ 'base' => '<p>The output from the RegisterCertificate operation.</p>', 'refs' => [], ], 'RegisterCertificateWithoutCARequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterCertificateWithoutCAResponse' => [ 'base' => NULL, 'refs' => [], ], 'RegisterThingRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterThingResponse' => [ 'base' => NULL, 'refs' => [], ], 'RegistrationCode' => [ 'base' => NULL, 'refs' => [ 'GetRegistrationCodeResponse$registrationCode' => '<p>The CA certificate registration code.</p>', ], ], 'RegistrationCodeValidationException' => [ 'base' => '<p>The registration code is invalid.</p>', 'refs' => [], ], 'RegistrationConfig' => [ 'base' => '<p>The registration configuration.</p>', 'refs' => [ 'DescribeCACertificateResponse$registrationConfig' => '<p>Information about the registration configuration.</p>', 'RegisterCACertificateRequest$registrationConfig' => '<p>Information about the registration configuration.</p>', 'UpdateCACertificateRequest$registrationConfig' => '<p>Information about the registration configuration.</p>', ], ], 'RegistryMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListBillingGroupsRequest$maxResults' => '<p>The maximum number of results to return per request.</p>', 'ListPrincipalThingsRequest$maxResults' => '<p>The maximum number of results to return in this operation.</p>', 'ListThingGroupsForThingRequest$maxResults' => '<p>The maximum number of results to return at one time.</p>', 'ListThingGroupsRequest$maxResults' => '<p>The maximum number of results to return at one time.</p>', 'ListThingRegistrationTaskReportsRequest$maxResults' => '<p>The maximum number of results to return per request.</p>', 'ListThingRegistrationTasksRequest$maxResults' => '<p>The maximum number of results to return at one time.</p>', 'ListThingTypesRequest$maxResults' => '<p>The maximum number of results to return in this operation.</p>', 'ListThingsInBillingGroupRequest$maxResults' => '<p>The maximum number of results to return per request.</p>', 'ListThingsInThingGroupRequest$maxResults' => '<p>The maximum number of results to return at one time.</p>', 'ListThingsRequest$maxResults' => '<p>The maximum number of results to return in this operation.</p>', ], ], 'RegistryS3BucketName' => [ 'base' => NULL, 'refs' => [ 'DescribeThingRegistrationTaskResponse$inputFileBucket' => '<p>The S3 bucket that contains the input file.</p>', 'StartThingRegistrationTaskRequest$inputFileBucket' => '<p>The S3 bucket that contains the input file.</p>', ], ], 'RegistryS3KeyName' => [ 'base' => NULL, 'refs' => [ 'DescribeThingRegistrationTaskResponse$inputFileKey' => '<p>The input file key.</p>', 'StartThingRegistrationTaskRequest$inputFileKey' => '<p>The name of input file within the S3 bucket. This file contains a newline delimited JSON file. Each line contains the parameter values to provision one device (thing).</p>', ], ], 'RejectCertificateTransferRequest' => [ 'base' => '<p>The input for the RejectCertificateTransfer operation.</p>', 'refs' => [], ], 'RejectedThings' => [ 'base' => NULL, 'refs' => [ 'JobProcessDetails$numberOfRejectedThings' => '<p>The number of things that rejected the job.</p>', ], ], 'RelatedResource' => [ 'base' => '<p>Information about a related resource.</p>', 'refs' => [ 'RelatedResources$member' => NULL, ], ], 'RelatedResources' => [ 'base' => NULL, 'refs' => [ 'AuditFinding$relatedResources' => '<p>The list of related resources.</p>', ], ], 'RemoveAuthorizerConfig' => [ 'base' => NULL, 'refs' => [ 'UpdateDomainConfigurationRequest$removeAuthorizerConfig' => '<p>Removes the authorization configuration from a domain.</p>', ], ], 'RemoveAutoRegistration' => [ 'base' => NULL, 'refs' => [ 'UpdateCACertificateRequest$removeAutoRegistration' => '<p>If true, removes auto registration.</p>', ], ], 'RemoveHook' => [ 'base' => NULL, 'refs' => [ 'UpdateProvisioningTemplateRequest$removePreProvisioningHook' => '<p>Removes pre-provisioning hook template.</p>', ], ], 'RemoveThingFromBillingGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'RemoveThingFromBillingGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'RemoveThingFromThingGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'RemoveThingFromThingGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'RemoveThingType' => [ 'base' => NULL, 'refs' => [ 'UpdateThingRequest$removeThingType' => '<p>Remove a thing type association. If <b>true</b>, the association is removed.</p>', ], ], 'RemovedThings' => [ 'base' => NULL, 'refs' => [ 'JobProcessDetails$numberOfRemovedThings' => '<p>The number of things that are no longer scheduled to execute the job because they have been deleted or have been removed from the group that was a target of the job.</p>', ], ], 'ReplaceDefaultPolicyVersionParams' => [ 'base' => '<p>Parameters to define a mitigation action that adds a blank policy to restrict permissions.</p>', 'refs' => [ 'MitigationActionParams$replaceDefaultPolicyVersionParams' => '<p>Parameters to define a mitigation action that adds a blank policy to restrict permissions.</p>', ], ], 'ReplaceTopicRuleRequest' => [ 'base' => '<p>The input for the ReplaceTopicRule operation.</p>', 'refs' => [], ], 'ReportType' => [ 'base' => NULL, 'refs' => [ 'ListThingRegistrationTaskReportsRequest$reportType' => '<p>The type of task report.</p>', 'ListThingRegistrationTaskReportsResponse$reportType' => '<p>The type of task report.</p>', ], ], 'RepublishAction' => [ 'base' => '<p>Describes an action to republish to another topic.</p>', 'refs' => [ 'Action$republish' => '<p>Publish to another MQTT topic.</p>', ], ], 'ReservedDomainConfigurationName' => [ 'base' => NULL, 'refs' => [ 'DescribeDomainConfigurationRequest$domainConfigurationName' => '<p>The name of the domain configuration.</p>', 'DescribeDomainConfigurationResponse$domainConfigurationName' => '<p>The name of the domain configuration.</p>', 'DomainConfigurationSummary$domainConfigurationName' => '<p>The name of the domain configuration. This value must be unique to a region.</p>', 'UpdateDomainConfigurationRequest$domainConfigurationName' => '<p>The name of the domain configuration to be updated.</p>', 'UpdateDomainConfigurationResponse$domainConfigurationName' => '<p>The name of the domain configuration that was updated.</p>', ], ], 'Resource' => [ 'base' => NULL, 'refs' => [ 'Resources$member' => NULL, ], ], 'ResourceAlreadyExistsException' => [ 'base' => '<p>The resource already exists.</p>', 'refs' => [], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p>The ARN of the resource.</p>', 'ResourceArns$value' => NULL, 'TagResourceRequest$resourceArn' => '<p>The ARN of the resource.</p>', 'UntagResourceRequest$resourceArn' => '<p>The ARN of the resource.</p>', ], ], 'ResourceArns' => [ 'base' => NULL, 'refs' => [ 'RegisterThingResponse$resourceArns' => '<p>ARNs for the generated resources.</p>', ], ], 'ResourceIdentifier' => [ 'base' => '<p>Information that identifies the noncompliant resource.</p>', 'refs' => [ 'ListAuditFindingsRequest$resourceIdentifier' => '<p>Information identifying the noncompliant resource.</p>', 'NonCompliantResource$resourceIdentifier' => '<p>Information that identifies the noncompliant resource.</p>', 'RelatedResource$resourceIdentifier' => '<p>Information that identifies the resource.</p>', ], ], 'ResourceLogicalId' => [ 'base' => NULL, 'refs' => [ 'ResourceArns$key' => NULL, ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource does not exist.</p>', 'refs' => [], ], 'ResourceRegistrationFailureException' => [ 'base' => '<p>The resource registration failed.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'NonCompliantResource$resourceType' => '<p>The type of the noncompliant resource.</p>', 'RelatedResource$resourceType' => '<p>The type of resource.</p>', ], ], 'Resources' => [ 'base' => NULL, 'refs' => [ 'AuthInfo$resources' => '<p>The resources for which the principal is being authorized to perform the specified action.</p>', ], ], 'RoleAlias' => [ 'base' => NULL, 'refs' => [ 'CreateRoleAliasRequest$roleAlias' => '<p>The role alias that points to a role ARN. This allows you to change the role without having to update the device.</p>', 'CreateRoleAliasResponse$roleAlias' => '<p>The role alias.</p>', 'DeleteRoleAliasRequest$roleAlias' => '<p>The role alias to delete.</p>', 'DescribeRoleAliasRequest$roleAlias' => '<p>The role alias to describe.</p>', 'RoleAliasDescription$roleAlias' => '<p>The role alias.</p>', 'RoleAliases$member' => NULL, 'UpdateRoleAliasRequest$roleAlias' => '<p>The role alias to update.</p>', 'UpdateRoleAliasResponse$roleAlias' => '<p>The role alias.</p>', ], ], 'RoleAliasArn' => [ 'base' => NULL, 'refs' => [ 'CreateRoleAliasResponse$roleAliasArn' => '<p>The role alias ARN.</p>', 'ResourceIdentifier$roleAliasArn' => '<p>The ARN of the role alias that has overly permissive actions.</p>', 'RoleAliasDescription$roleAliasArn' => '<p>The ARN of the role alias.</p>', 'UpdateRoleAliasResponse$roleAliasArn' => '<p>The role alias ARN.</p>', ], ], 'RoleAliasDescription' => [ 'base' => '<p>Role alias description.</p>', 'refs' => [ 'DescribeRoleAliasResponse$roleAliasDescription' => '<p>The role alias description.</p>', ], ], 'RoleAliases' => [ 'base' => NULL, 'refs' => [ 'ListRoleAliasesResponse$roleAliases' => '<p>The role aliases.</p>', ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'AlertTarget$roleArn' => '<p>The ARN of the role that grants permission to send alerts to the notification target.</p>', 'AuditNotificationTarget$roleArn' => '<p>The ARN of the role that grants permission to send notifications to the target.</p>', 'CreateMitigationActionRequest$roleArn' => '<p>The ARN of the IAM role that is used to apply the mitigation action.</p>', 'CreateOTAUpdateRequest$roleArn' => '<p>The IAM role that grants AWS IoT access to the Amazon S3, AWS IoT jobs and AWS Code Signing resources to create an OTA update job.</p>', 'CreateProvisioningTemplateRequest$provisioningRoleArn' => '<p>The role ARN for the role associated with the fleet provisioning template. This IoT role grants permission to provision a device.</p>', 'CreateRoleAliasRequest$roleArn' => '<p>The role ARN.</p>', 'CreateStreamRequest$roleArn' => '<p>An IAM role that allows the IoT service principal assumes to access your S3 files.</p>', 'DescribeAccountAuditConfigurationResponse$roleArn' => '<p>The ARN of the role that grants permission to AWS IoT to access information about your devices, policies, certificates, and other items as required when performing an audit.</p> <p>On the first call to <code>UpdateAccountAuditConfiguration</code>, this parameter is required.</p>', 'DescribeMitigationActionResponse$roleArn' => '<p>The ARN of the IAM role used to apply this action.</p>', 'DescribeProvisioningTemplateResponse$provisioningRoleArn' => '<p>The ARN of the role associated with the provisioning template. This IoT role grants permission to provision a device.</p>', 'DescribeThingRegistrationTaskResponse$roleArn' => '<p>The role ARN that grants access to the input file bucket.</p>', 'EnableIoTLoggingParams$roleArnForLogging' => '<p>The ARN of the IAM role used for logging.</p>', 'MitigationAction$roleArn' => '<p>The IAM role ARN used to apply this mitigation action.</p>', 'PresignedUrlConfig$roleArn' => '<p>The ARN of an IAM role that grants grants permission to download files from the S3 bucket where the job data/updates are stored. The role must also grant permission for IoT to download the files.</p>', 'RegistrationConfig$roleArn' => '<p>The ARN of the role.</p>', 'ResourceIdentifier$iamRoleArn' => '<p>The ARN of the IAM role that has overly permissive actions.</p>', 'RoleAliasDescription$roleArn' => '<p>The role ARN.</p>', 'StartThingRegistrationTaskRequest$roleArn' => '<p>The IAM role ARN that grants permission the input file.</p>', 'StreamInfo$roleArn' => '<p>An IAM role AWS IoT assumes to access your S3 files.</p>', 'UpdateAccountAuditConfigurationRequest$roleArn' => '<p>The ARN of the role that grants permission to AWS IoT to access information about your devices, policies, certificates and other items as required when performing an audit.</p>', 'UpdateMitigationActionRequest$roleArn' => '<p>The ARN of the IAM role that is used to apply the mitigation action.</p>', 'UpdateProvisioningTemplateRequest$provisioningRoleArn' => '<p>The ARN of the role associated with the provisioning template. This IoT role grants permission to provision a device.</p>', 'UpdateRoleAliasRequest$roleArn' => '<p>The role ARN.</p>', 'UpdateStreamRequest$roleArn' => '<p>An IAM role that allows the IoT service principal assumes to access your S3 files.</p>', ], ], 'RolloutRatePerMinute' => [ 'base' => NULL, 'refs' => [ 'ExponentialRolloutRate$baseRatePerMinute' => '<p>The minimum number of things that will be notified of a pending job, per minute at the start of job rollout. This parameter allows you to define the initial rate of rollout.</p>', ], ], 'RuleArn' => [ 'base' => NULL, 'refs' => [ 'GetTopicRuleResponse$ruleArn' => '<p>The rule ARN.</p>', 'TopicRuleListItem$ruleArn' => '<p>The rule ARN.</p>', ], ], 'RuleName' => [ 'base' => NULL, 'refs' => [ 'CreateTopicRuleRequest$ruleName' => '<p>The name of the rule.</p>', 'DeleteTopicRuleRequest$ruleName' => '<p>The name of the rule.</p>', 'DisableTopicRuleRequest$ruleName' => '<p>The name of the rule to disable.</p>', 'EnableTopicRuleRequest$ruleName' => '<p>The name of the topic rule to enable.</p>', 'GetTopicRuleRequest$ruleName' => '<p>The name of the rule.</p>', 'ReplaceTopicRuleRequest$ruleName' => '<p>The name of the rule.</p>', 'TopicRule$ruleName' => '<p>The name of the rule.</p>', 'TopicRuleListItem$ruleName' => '<p>The name of the rule.</p>', ], ], 'S3Action' => [ 'base' => '<p>Describes an action to write data to an Amazon S3 bucket.</p>', 'refs' => [ 'Action$s3' => '<p>Write to an Amazon S3 bucket.</p>', ], ], 'S3Bucket' => [ 'base' => NULL, 'refs' => [ 'S3Destination$bucket' => '<p>The S3 bucket that contains the updated firmware.</p>', 'S3Location$bucket' => '<p>The S3 bucket.</p>', ], ], 'S3Destination' => [ 'base' => '<p>Describes the location of updated firmware in S3.</p>', 'refs' => [ 'Destination$s3Destination' => '<p>Describes the location in S3 of the updated firmware.</p>', ], ], 'S3FileUrl' => [ 'base' => NULL, 'refs' => [ 'S3FileUrlList$member' => NULL, ], ], 'S3FileUrlList' => [ 'base' => NULL, 'refs' => [ 'ListThingRegistrationTaskReportsResponse$resourceLinks' => '<p>Links to the task resources.</p>', ], ], 'S3Key' => [ 'base' => NULL, 'refs' => [ 'S3Location$key' => '<p>The S3 key.</p>', ], ], 'S3Location' => [ 'base' => '<p>The S3 location.</p>', 'refs' => [ 'FileLocation$s3Location' => '<p>The location of the updated firmware in S3.</p>', 'StreamFile$s3Location' => '<p>The location of the file in S3.</p>', ], ], 'S3Version' => [ 'base' => NULL, 'refs' => [ 'S3Location$version' => '<p>The S3 bucket version.</p>', ], ], 'SQL' => [ 'base' => NULL, 'refs' => [ 'TopicRule$sql' => '<p>The SQL statement used to query the topic. When using a SQL query with multiple lines, be sure to escape the newline characters.</p>', 'TopicRulePayload$sql' => '<p>The SQL statement used to query the topic. For more information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-rules.html#aws-iot-sql-reference">AWS IoT SQL Reference</a> in the <i>AWS IoT Developer Guide</i>.</p>', ], ], 'SalesforceAction' => [ 'base' => '<p>Describes an action to write a message to a Salesforce IoT Cloud Input Stream.</p>', 'refs' => [ 'Action$salesforce' => '<p>Send a message to a Salesforce IoT Cloud Input Stream.</p>', ], ], 'SalesforceEndpoint' => [ 'base' => NULL, 'refs' => [ 'SalesforceAction$url' => '<p>The URL exposed by the Salesforce IoT Cloud Input Stream. The URL is available from the Salesforce IoT Cloud platform after creation of the Input Stream.</p>', ], ], 'SalesforceToken' => [ 'base' => NULL, 'refs' => [ 'SalesforceAction$token' => '<p>The token used to authenticate access to the Salesforce IoT Cloud Input Stream. The token is available from the Salesforce IoT Cloud platform after creation of the Input Stream.</p>', ], ], 'ScheduledAuditArn' => [ 'base' => NULL, 'refs' => [ 'CreateScheduledAuditResponse$scheduledAuditArn' => '<p>The ARN of the scheduled audit.</p>', 'DescribeScheduledAuditResponse$scheduledAuditArn' => '<p>The ARN of the scheduled audit.</p>', 'ScheduledAuditMetadata$scheduledAuditArn' => '<p>The ARN of the scheduled audit.</p>', 'UpdateScheduledAuditResponse$scheduledAuditArn' => '<p>The ARN of the scheduled audit.</p>', ], ], 'ScheduledAuditMetadata' => [ 'base' => '<p>Information about the scheduled audit.</p>', 'refs' => [ 'ScheduledAuditMetadataList$member' => NULL, ], ], 'ScheduledAuditMetadataList' => [ 'base' => NULL, 'refs' => [ 'ListScheduledAuditsResponse$scheduledAudits' => '<p>The list of scheduled audits.</p>', ], ], 'ScheduledAuditName' => [ 'base' => NULL, 'refs' => [ 'CreateScheduledAuditRequest$scheduledAuditName' => '<p>The name you want to give to the scheduled audit. (Max. 128 chars)</p>', 'DeleteScheduledAuditRequest$scheduledAuditName' => '<p>The name of the scheduled audit you want to delete.</p>', 'DescribeAuditTaskResponse$scheduledAuditName' => '<p>The name of the scheduled audit (only if the audit was a scheduled audit).</p>', 'DescribeScheduledAuditRequest$scheduledAuditName' => '<p>The name of the scheduled audit whose information you want to get.</p>', 'DescribeScheduledAuditResponse$scheduledAuditName' => '<p>The name of the scheduled audit.</p>', 'ScheduledAuditMetadata$scheduledAuditName' => '<p>The name of the scheduled audit.</p>', 'UpdateScheduledAuditRequest$scheduledAuditName' => '<p>The name of the scheduled audit. (Max. 128 chars)</p>', ], ], 'SearchIndexRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchIndexResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchableAttributes' => [ 'base' => NULL, 'refs' => [ 'ThingTypeProperties$searchableAttributes' => '<p>A list of searchable thing attribute names.</p>', ], ], 'Seconds' => [ 'base' => NULL, 'refs' => [ 'TestInvokeAuthorizerResponse$refreshAfterInSeconds' => '<p>The number of seconds after which the temporary credentials are refreshed.</p>', 'TestInvokeAuthorizerResponse$disconnectAfterInSeconds' => '<p>The number of seconds after which the connection is terminated.</p>', ], ], 'SecurityProfileArn' => [ 'base' => NULL, 'refs' => [ 'CreateSecurityProfileResponse$securityProfileArn' => '<p>The ARN of the security profile.</p>', 'DescribeSecurityProfileResponse$securityProfileArn' => '<p>The ARN of the security profile.</p>', 'SecurityProfileIdentifier$arn' => '<p>The ARN of the security profile.</p>', 'UpdateSecurityProfileResponse$securityProfileArn' => '<p>The ARN of the security profile that was updated.</p>', ], ], 'SecurityProfileDescription' => [ 'base' => NULL, 'refs' => [ 'CreateSecurityProfileRequest$securityProfileDescription' => '<p>A description of the security profile.</p>', 'DescribeSecurityProfileResponse$securityProfileDescription' => '<p>A description of the security profile (associated with the security profile when it was created or updated).</p>', 'UpdateSecurityProfileRequest$securityProfileDescription' => '<p>A description of the security profile.</p>', 'UpdateSecurityProfileResponse$securityProfileDescription' => '<p>The description of the security profile.</p>', ], ], 'SecurityProfileIdentifier' => [ 'base' => '<p>Identifying information for a Device Defender security profile.</p>', 'refs' => [ 'SecurityProfileIdentifiers$member' => NULL, 'SecurityProfileTargetMapping$securityProfileIdentifier' => '<p>Information that identifies the security profile.</p>', ], ], 'SecurityProfileIdentifiers' => [ 'base' => NULL, 'refs' => [ 'ListSecurityProfilesResponse$securityProfileIdentifiers' => '<p>A list of security profile identifiers (names and ARNs).</p>', ], ], 'SecurityProfileName' => [ 'base' => NULL, 'refs' => [ 'ActiveViolation$securityProfileName' => '<p>The security profile whose behavior is in violation.</p>', 'AttachSecurityProfileRequest$securityProfileName' => '<p>The security profile that is attached.</p>', 'CreateSecurityProfileRequest$securityProfileName' => '<p>The name you are giving to the security profile.</p>', 'CreateSecurityProfileResponse$securityProfileName' => '<p>The name you gave to the security profile.</p>', 'DeleteSecurityProfileRequest$securityProfileName' => '<p>The name of the security profile to be deleted.</p>', 'DescribeSecurityProfileRequest$securityProfileName' => '<p>The name of the security profile whose information you want to get.</p>', 'DescribeSecurityProfileResponse$securityProfileName' => '<p>The name of the security profile.</p>', 'DetachSecurityProfileRequest$securityProfileName' => '<p>The security profile that is detached.</p>', 'ListActiveViolationsRequest$securityProfileName' => '<p>The name of the Device Defender security profile for which violations are listed.</p>', 'ListTargetsForSecurityProfileRequest$securityProfileName' => '<p>The security profile.</p>', 'ListViolationEventsRequest$securityProfileName' => '<p>A filter to limit results to those alerts generated by the specified security profile.</p>', 'SecurityProfileIdentifier$name' => '<p>The name you have given to the security profile.</p>', 'UpdateSecurityProfileRequest$securityProfileName' => '<p>The name of the security profile you want to update.</p>', 'UpdateSecurityProfileResponse$securityProfileName' => '<p>The name of the security profile that was updated.</p>', 'ViolationEvent$securityProfileName' => '<p>The name of the security profile whose behavior was violated.</p>', ], ], 'SecurityProfileTarget' => [ 'base' => '<p>A target to which an alert is sent when a security profile behavior is violated.</p>', 'refs' => [ 'SecurityProfileTargetMapping$target' => '<p>Information about the target (thing group) associated with the security profile.</p>', 'SecurityProfileTargets$member' => NULL, ], ], 'SecurityProfileTargetArn' => [ 'base' => NULL, 'refs' => [ 'AttachSecurityProfileRequest$securityProfileTargetArn' => '<p>The ARN of the target (thing group) to which the security profile is attached.</p>', 'DetachSecurityProfileRequest$securityProfileTargetArn' => '<p>The ARN of the thing group from which the security profile is detached.</p>', 'ListSecurityProfilesForTargetRequest$securityProfileTargetArn' => '<p>The ARN of the target (thing group) whose attached security profiles you want to get.</p>', 'SecurityProfileTarget$arn' => '<p>The ARN of the security profile.</p>', ], ], 'SecurityProfileTargetMapping' => [ 'base' => '<p>Information about a security profile and the target associated with it.</p>', 'refs' => [ 'SecurityProfileTargetMappings$member' => NULL, ], ], 'SecurityProfileTargetMappings' => [ 'base' => NULL, 'refs' => [ 'ListSecurityProfilesForTargetResponse$securityProfileTargetMappings' => '<p>A list of security profiles and their associated targets.</p>', ], ], 'SecurityProfileTargets' => [ 'base' => NULL, 'refs' => [ 'ListTargetsForSecurityProfileResponse$securityProfileTargets' => '<p>The thing groups to which the security profile is attached.</p>', ], ], 'ServerCertificateArns' => [ 'base' => NULL, 'refs' => [ 'CreateDomainConfigurationRequest$serverCertificateArns' => '<p>The ARNs of the certificates that AWS IoT passes to the device during the TLS handshake. Currently you can specify only one certificate ARN. This value is not required for AWS-managed domains.</p>', ], ], 'ServerCertificateStatus' => [ 'base' => NULL, 'refs' => [ 'ServerCertificateSummary$serverCertificateStatus' => '<p>The status of the server certificate.</p>', ], ], 'ServerCertificateStatusDetail' => [ 'base' => NULL, 'refs' => [ 'ServerCertificateSummary$serverCertificateStatusDetail' => '<p>Details that explain the status of the server certificate.</p>', ], ], 'ServerCertificateSummary' => [ 'base' => '<p>An object that contains information about a server certificate.</p>', 'refs' => [ 'ServerCertificates$member' => NULL, ], ], 'ServerCertificates' => [ 'base' => NULL, 'refs' => [ 'DescribeDomainConfigurationResponse$serverCertificates' => '<p>A list containing summary information about the server certificate included in the domain configuration.</p>', ], ], 'ServerName' => [ 'base' => NULL, 'refs' => [ 'TlsContext$serverName' => '<p>The value of the <code>serverName</code> key in a TLS authorization request.</p>', ], ], 'ServiceName' => [ 'base' => NULL, 'refs' => [ 'SigV4Authorization$serviceName' => '<p>The service name to use while signing with Sig V4.</p>', ], ], 'ServiceType' => [ 'base' => NULL, 'refs' => [ 'CreateDomainConfigurationRequest$serviceType' => '<p>The type of service delivered by the endpoint.</p> <note> <p>AWS IoT Core currently supports only the <code>DATA</code> service type.</p> </note>', 'DescribeDomainConfigurationResponse$serviceType' => '<p>The type of service delivered by the endpoint.</p>', 'DomainConfigurationSummary$serviceType' => '<p>The type of service delivered by the endpoint.</p>', 'ListDomainConfigurationsRequest$serviceType' => '<p>The type of service delivered by the endpoint.</p>', ], ], 'ServiceUnavailableException' => [ 'base' => '<p>The service is temporarily unavailable.</p>', 'refs' => [], ], 'SetAsActive' => [ 'base' => NULL, 'refs' => [ 'AcceptCertificateTransferRequest$setAsActive' => '<p>Specifies whether the certificate is active.</p>', 'CreateCertificateFromCsrRequest$setAsActive' => '<p>Specifies whether the certificate is active.</p>', 'CreateKeysAndCertificateRequest$setAsActive' => '<p>Specifies whether the certificate is active.</p>', 'RegisterCACertificateRequest$setAsActive' => '<p>A boolean value that specifies if the CA certificate is set to active.</p>', ], ], 'SetAsActiveFlag' => [ 'base' => NULL, 'refs' => [ 'RegisterCertificateRequest$setAsActive' => '<p>A boolean value that specifies if the certificate is set to active.</p>', ], ], 'SetAsDefault' => [ 'base' => NULL, 'refs' => [ 'CreatePolicyVersionRequest$setAsDefault' => '<p>Specifies whether the policy version is set as the default. When this parameter is true, the new policy version becomes the operative version (that is, the version that is in effect for the certificates to which the policy is attached).</p>', 'CreateProvisioningTemplateVersionRequest$setAsDefault' => '<p>Sets a fleet provision template version as the default version.</p>', ], ], 'SetDefaultAuthorizerRequest' => [ 'base' => NULL, 'refs' => [], ], 'SetDefaultAuthorizerResponse' => [ 'base' => NULL, 'refs' => [], ], 'SetDefaultPolicyVersionRequest' => [ 'base' => '<p>The input for the SetDefaultPolicyVersion operation.</p>', 'refs' => [], ], 'SetLoggingOptionsRequest' => [ 'base' => '<p>The input for the SetLoggingOptions operation.</p>', 'refs' => [], ], 'SetV2LoggingLevelRequest' => [ 'base' => NULL, 'refs' => [], ], 'SetV2LoggingOptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SigV4Authorization' => [ 'base' => '<p>Use Sig V4 authorization.</p>', 'refs' => [ 'HttpAuthorization$sigv4' => '<p>Use Sig V4 authorization. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process</a>.</p>', ], ], 'Signature' => [ 'base' => NULL, 'refs' => [ 'CodeSigningSignature$inlineDocument' => '<p>A base64 encoded binary representation of the code signing signature.</p>', ], ], 'SignatureAlgorithm' => [ 'base' => NULL, 'refs' => [ 'CustomCodeSigning$signatureAlgorithm' => '<p>The signature algorithm used to code sign the file.</p>', ], ], 'SigningJobId' => [ 'base' => NULL, 'refs' => [ 'CodeSigning$awsSignerJobId' => '<p>The ID of the AWSSignerJob which was created to sign the file.</p>', ], ], 'SigningProfileName' => [ 'base' => NULL, 'refs' => [ 'StartSigningJobParameter$signingProfileName' => '<p>The code-signing profile name.</p>', ], ], 'SigningProfileParameter' => [ 'base' => '<p>Describes the code-signing profile.</p>', 'refs' => [ 'StartSigningJobParameter$signingProfileParameter' => '<p>Describes the code-signing profile.</p>', ], ], 'SigningRegion' => [ 'base' => NULL, 'refs' => [ 'SigV4Authorization$signingRegion' => '<p>The signing region.</p>', ], ], 'SkippedFindingsCount' => [ 'base' => NULL, 'refs' => [ 'TaskStatisticsForAuditCheck$skippedFindingsCount' => '<p>The number of findings skipped because of filter conditions provided in the parameters to the command.</p>', ], ], 'SkyfallMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListV2LoggingLevelsRequest$maxResults' => '<p>The maximum number of results to return at one time.</p>', ], ], 'SnsAction' => [ 'base' => '<p>Describes an action to publish to an Amazon SNS topic.</p>', 'refs' => [ 'Action$sns' => '<p>Publish to an Amazon SNS topic.</p>', ], ], 'SnsTopicArn' => [ 'base' => NULL, 'refs' => [ 'PublishFindingToSnsParams$topicArn' => '<p>The ARN of the topic to which you want to publish the findings.</p>', ], ], 'SqlParseException' => [ 'base' => '<p>The Rule-SQL expression can\'t be parsed correctly.</p>', 'refs' => [], ], 'SqsAction' => [ 'base' => '<p>Describes an action to publish data to an Amazon SQS queue.</p>', 'refs' => [ 'Action$sqs' => '<p>Publish to an Amazon SQS queue.</p>', ], ], 'StartAuditMitigationActionsTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartAuditMitigationActionsTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartOnDemandAuditTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartOnDemandAuditTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartSigningJobParameter' => [ 'base' => '<p>Information required to start a signing job.</p>', 'refs' => [ 'CodeSigning$startSigningJobParameter' => '<p>Describes the code-signing job.</p>', ], ], 'StartThingRegistrationTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartThingRegistrationTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'StateMachineName' => [ 'base' => NULL, 'refs' => [ 'StepFunctionsAction$stateMachineName' => '<p>The name of the Step Functions state machine whose execution will be started.</p>', ], ], 'StateReason' => [ 'base' => NULL, 'refs' => [ 'CloudwatchAlarmAction$stateReason' => '<p>The reason for the alarm change.</p>', ], ], 'StateValue' => [ 'base' => NULL, 'refs' => [ 'CloudwatchAlarmAction$stateValue' => '<p>The value of the alarm state. Acceptable values are: OK, ALARM, INSUFFICIENT_DATA.</p>', ], ], 'StatisticalThreshold' => [ 'base' => '<p>A statistical ranking (percentile) which indicates a threshold value by which a behavior is determined to be in compliance or in violation of the behavior.</p>', 'refs' => [ 'BehaviorCriteria$statisticalThreshold' => '<p>A statistical ranking (percentile) which indicates a threshold value by which a behavior is determined to be in compliance or in violation of the behavior.</p>', ], ], 'Statistics' => [ 'base' => '<p>A map of key-value pairs for all supported statistics. Currently, only count is supported.</p>', 'refs' => [ 'GetStatisticsResponse$statistics' => '<p>The statistics returned by the Fleet Indexing service based on the query and aggregation field.</p>', ], ], 'Status' => [ 'base' => NULL, 'refs' => [ 'DescribeThingRegistrationTaskResponse$status' => '<p>The status of the bulk thing provisioning task.</p>', 'ListThingRegistrationTasksRequest$status' => '<p>The status of the bulk thing provisioning task.</p>', ], ], 'StdDeviation' => [ 'base' => NULL, 'refs' => [ 'Statistics$stdDeviation' => '<p>The standard deviation of the aggregated field values.</p>', ], ], 'StepFunctionsAction' => [ 'base' => '<p>Starts execution of a Step Functions state machine.</p>', 'refs' => [ 'Action$stepFunctions' => '<p>Starts execution of a Step Functions state machine.</p>', ], ], 'StopThingRegistrationTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopThingRegistrationTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'Stream' => [ 'base' => '<p>Describes a group of files that can be streamed.</p>', 'refs' => [ 'FileLocation$stream' => '<p>The stream that contains the OTA update.</p>', ], ], 'StreamArn' => [ 'base' => NULL, 'refs' => [ 'CreateStreamResponse$streamArn' => '<p>The stream ARN.</p>', 'StreamInfo$streamArn' => '<p>The stream ARN.</p>', 'StreamSummary$streamArn' => '<p>The stream ARN.</p>', 'UpdateStreamResponse$streamArn' => '<p>The stream ARN.</p>', ], ], 'StreamDescription' => [ 'base' => NULL, 'refs' => [ 'CreateStreamRequest$description' => '<p>A description of the stream.</p>', 'CreateStreamResponse$description' => '<p>A description of the stream.</p>', 'StreamInfo$description' => '<p>The description of the stream.</p>', 'StreamSummary$description' => '<p>A description of the stream.</p>', 'UpdateStreamRequest$description' => '<p>The description of the stream.</p>', 'UpdateStreamResponse$description' => '<p>A description of the stream.</p>', ], ], 'StreamFile' => [ 'base' => '<p>Represents a file to stream.</p>', 'refs' => [ 'StreamFiles$member' => NULL, ], ], 'StreamFiles' => [ 'base' => NULL, 'refs' => [ 'CreateStreamRequest$files' => '<p>The files to stream.</p>', 'StreamInfo$files' => '<p>The files to stream.</p>', 'UpdateStreamRequest$files' => '<p>The files associated with the stream.</p>', ], ], 'StreamId' => [ 'base' => NULL, 'refs' => [ 'CreateStreamRequest$streamId' => '<p>The stream ID.</p>', 'CreateStreamResponse$streamId' => '<p>The stream ID.</p>', 'DeleteStreamRequest$streamId' => '<p>The stream ID.</p>', 'DescribeStreamRequest$streamId' => '<p>The stream ID.</p>', 'Stream$streamId' => '<p>The stream ID.</p>', 'StreamInfo$streamId' => '<p>The stream ID.</p>', 'StreamSummary$streamId' => '<p>The stream ID.</p>', 'UpdateStreamRequest$streamId' => '<p>The stream ID.</p>', 'UpdateStreamResponse$streamId' => '<p>The stream ID.</p>', ], ], 'StreamInfo' => [ 'base' => '<p>Information about a stream.</p>', 'refs' => [ 'DescribeStreamResponse$streamInfo' => '<p>Information about the stream.</p>', ], ], 'StreamName' => [ 'base' => NULL, 'refs' => [ 'KinesisAction$streamName' => '<p>The name of the Amazon Kinesis stream.</p>', ], ], 'StreamSummary' => [ 'base' => '<p>A summary of a stream.</p>', 'refs' => [ 'StreamsSummary$member' => NULL, ], ], 'StreamVersion' => [ 'base' => NULL, 'refs' => [ 'CreateStreamResponse$streamVersion' => '<p>The version of the stream.</p>', 'StreamInfo$streamVersion' => '<p>The stream version.</p>', 'StreamSummary$streamVersion' => '<p>The stream version.</p>', 'UpdateStreamResponse$streamVersion' => '<p>The stream version.</p>', ], ], 'StreamsSummary' => [ 'base' => NULL, 'refs' => [ 'ListStreamsResponse$streams' => '<p>A list of streams.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'CloudwatchMetricAction$metricNamespace' => '<p>The CloudWatch metric namespace name.</p>', 'CloudwatchMetricAction$metricName' => '<p>The CloudWatch metric name.</p>', 'CloudwatchMetricAction$metricValue' => '<p>The CloudWatch metric value.</p>', 'CloudwatchMetricAction$metricUnit' => '<p>The <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Unit">metric unit</a> supported by CloudWatch.</p>', 'CloudwatchMetricAction$metricTimestamp' => '<p>An optional <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#about_timestamp">Unix timestamp</a>.</p>', 'CreateTopicRuleRequest$tags' => '<p>Metadata which can be used to manage the topic rule.</p> <note> <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p> <p>For the CLI command-line parameter use format: --tags "key1=value1&amp;key2=value2..."</p> <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p> </note>', 'StringMap$key' => NULL, 'StringMap$value' => NULL, 'TopicRuleDestination$statusReason' => '<p>Additional details or reason why the topic rule destination is in the current status.</p>', 'TopicRuleDestinationSummary$statusReason' => '<p>The reason the topic rule destination is in the current status.</p>', ], ], 'StringMap' => [ 'base' => NULL, 'refs' => [ 'NonCompliantResource$additionalInfo' => '<p>Other information about the noncompliant resource.</p>', 'RelatedResource$additionalInfo' => '<p>Other information about the resource.</p>', ], ], 'SucceededFindingsCount' => [ 'base' => NULL, 'refs' => [ 'TaskStatisticsForAuditCheck$succeededFindingsCount' => '<p>The number of findings for which all mitigation actions succeeded when applied.</p>', ], ], 'SucceededThings' => [ 'base' => NULL, 'refs' => [ 'JobProcessDetails$numberOfSucceededThings' => '<p>The number of things which successfully completed the job.</p>', ], ], 'Sum' => [ 'base' => NULL, 'refs' => [ 'Statistics$sum' => '<p>The sum of the aggregated field values.</p>', ], ], 'SumOfSquares' => [ 'base' => NULL, 'refs' => [ 'Statistics$sumOfSquares' => '<p>The sum of the squares of the aggregated field values.</p>', ], ], 'TableName' => [ 'base' => NULL, 'refs' => [ 'DynamoDBAction$tableName' => '<p>The name of the DynamoDB table.</p>', 'PutItemInput$tableName' => '<p>The table where the message data will be written.</p>', ], ], 'Tag' => [ 'base' => '<p>A set of key/value pairs that are used to manage the resource.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The tag\'s key.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>A list of the keys of the tags to be removed from the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateAuthorizerRequest$tags' => '<p>Metadata which can be used to manage the custom authorizer.</p> <note> <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p> <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p> <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p> </note>', 'CreateBillingGroupRequest$tags' => '<p>Metadata which can be used to manage the billing group.</p>', 'CreateDimensionRequest$tags' => '<p>Metadata that can be used to manage the dimension.</p>', 'CreateDomainConfigurationRequest$tags' => '<p>Metadata which can be used to manage the domain configuration.</p> <note> <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p> <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p> <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p> </note>', 'CreateDynamicThingGroupRequest$tags' => '<p>Metadata which can be used to manage the dynamic thing group.</p>', 'CreateJobRequest$tags' => '<p>Metadata which can be used to manage the job.</p>', 'CreateMitigationActionRequest$tags' => '<p>Metadata that can be used to manage the mitigation action.</p>', 'CreateOTAUpdateRequest$tags' => '<p>Metadata which can be used to manage updates.</p>', 'CreatePolicyRequest$tags' => '<p>Metadata which can be used to manage the policy.</p> <note> <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p> <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p> <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p> </note>', 'CreateProvisioningTemplateRequest$tags' => '<p>Metadata which can be used to manage the fleet provisioning template.</p> <note> <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p> <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p> <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p> </note>', 'CreateRoleAliasRequest$tags' => '<p>Metadata which can be used to manage the role alias.</p> <note> <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p> <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p> <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p> </note>', 'CreateScheduledAuditRequest$tags' => '<p>Metadata that can be used to manage the scheduled audit.</p>', 'CreateSecurityProfileRequest$tags' => '<p>Metadata that can be used to manage the security profile.</p>', 'CreateStreamRequest$tags' => '<p>Metadata which can be used to manage streams.</p>', 'CreateThingGroupRequest$tags' => '<p>Metadata which can be used to manage the thing group.</p>', 'CreateThingTypeRequest$tags' => '<p>Metadata which can be used to manage the thing type.</p>', 'ListTagsForResourceResponse$tags' => '<p>The list of tags assigned to the resource.</p>', 'RegisterCACertificateRequest$tags' => '<p>Metadata which can be used to manage the CA certificate.</p> <note> <p>For URI Request parameters use format: ...key1=value1&amp;key2=value2...</p> <p>For the CLI command-line parameter use format: &amp;&amp;tags "key1=value1&amp;key2=value2..."</p> <p>For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."</p> </note>', 'TagResourceRequest$tags' => '<p>The new or modified tags for the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The tag\'s value.</p>', ], ], 'Target' => [ 'base' => NULL, 'refs' => [ 'Targets$member' => NULL, ], ], 'TargetArn' => [ 'base' => NULL, 'refs' => [ 'AuditNotificationTarget$targetArn' => '<p>The ARN of the target (SNS topic) to which audit notifications are sent.</p>', 'JobTargets$member' => NULL, 'ProvisioningHook$targetArn' => '<p>The ARN of the target function.</p> <p> <i>Note:</i> Only Lambda functions are currently supported.</p>', ], ], 'TargetAuditCheckNames' => [ 'base' => NULL, 'refs' => [ 'CreateScheduledAuditRequest$targetCheckNames' => '<p>Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>', 'DescribeScheduledAuditResponse$targetCheckNames' => '<p>Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>', 'StartOnDemandAuditTaskRequest$targetCheckNames' => '<p>Which checks are performed during the audit. The checks you specify must be enabled for your account or an exception occurs. Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.</p>', 'UpdateScheduledAuditRequest$targetCheckNames' => '<p>Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use <code>DescribeAccountAuditConfiguration</code> to see the list of all checks, including those that are enabled or use <code>UpdateAccountAuditConfiguration</code> to select which checks are enabled.)</p>', ], ], 'TargetSelection' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$targetSelection' => '<p>Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing when a change is detected in a target. For example, a job will run on a thing when the thing is added to a target group, even after the job was completed by all things originally in the group.</p>', 'CreateOTAUpdateRequest$targetSelection' => '<p>Specifies whether the update will continue to run (CONTINUOUS), or will be complete after all the things specified as targets have completed the update (SNAPSHOT). If continuous, the update may also be run on a thing when a change is detected in a target. For example, an update will run on a thing when the thing is added to a target group, even after the update was completed by all things originally in the group. Valid values: CONTINUOUS | SNAPSHOT.</p>', 'Job$targetSelection' => '<p>Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing when a change is detected in a target. For example, a job will run on a device when the thing representing the device is added to a target group, even after the job was completed by all things originally in the group. </p>', 'JobSummary$targetSelection' => '<p>Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing when a change is detected in a target. For example, a job will run on a thing when the thing is added to a target group, even after the job was completed by all things originally in the group.</p>', 'ListJobsRequest$targetSelection' => '<p>Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing when a change is detected in a target. For example, a job will run on a thing when the thing is added to a target group, even after the job was completed by all things originally in the group. </p>', 'OTAUpdateInfo$targetSelection' => '<p>Specifies whether the OTA update will continue to run (CONTINUOUS), or will be complete after all those things specified as targets have completed the OTA update (SNAPSHOT). If continuous, the OTA update may also be run on a thing when a change is detected in a target. For example, an OTA update will run on a thing when the thing is added to a target group, even after the OTA update was completed by all things originally in the group. </p>', ], ], 'Targets' => [ 'base' => NULL, 'refs' => [ 'CreateOTAUpdateRequest$targets' => '<p>The devices targeted to receive OTA updates.</p>', 'OTAUpdateInfo$targets' => '<p>The targets of the OTA update.</p>', ], ], 'TaskAlreadyExistsException' => [ 'base' => '<p>This exception occurs if you attempt to start a task with the same task-id as an existing task but with a different clientRequestToken.</p>', 'refs' => [], ], 'TaskId' => [ 'base' => NULL, 'refs' => [ 'DescribeThingRegistrationTaskRequest$taskId' => '<p>The task ID.</p>', 'DescribeThingRegistrationTaskResponse$taskId' => '<p>The task ID.</p>', 'ListThingRegistrationTaskReportsRequest$taskId' => '<p>The id of the task.</p>', 'StartThingRegistrationTaskResponse$taskId' => '<p>The bulk thing provisioning task ID.</p>', 'StopThingRegistrationTaskRequest$taskId' => '<p>The bulk thing provisioning task ID.</p>', 'TaskIdList$member' => NULL, ], ], 'TaskIdList' => [ 'base' => NULL, 'refs' => [ 'ListThingRegistrationTasksResponse$taskIds' => '<p>A list of bulk thing provisioning task IDs.</p>', ], ], 'TaskStatistics' => [ 'base' => '<p>Statistics for the checks performed during the audit.</p>', 'refs' => [ 'DescribeAuditTaskResponse$taskStatistics' => '<p>Statistical information about the audit.</p>', ], ], 'TaskStatisticsForAuditCheck' => [ 'base' => '<p>Provides summary counts of how many tasks for findings are in a particular state. This information is included in the response from DescribeAuditMitigationActionsTask.</p>', 'refs' => [ 'AuditMitigationActionsTaskStatistics$value' => NULL, ], ], 'TemplateArn' => [ 'base' => NULL, 'refs' => [ 'CreateProvisioningTemplateResponse$templateArn' => '<p>The ARN that identifies the provisioning template.</p>', 'CreateProvisioningTemplateVersionResponse$templateArn' => '<p>The ARN that identifies the provisioning template.</p>', 'DescribeProvisioningTemplateResponse$templateArn' => '<p>The ARN of the fleet provisioning template.</p>', 'ProvisioningTemplateSummary$templateArn' => '<p>The ARN of the fleet provisioning template.</p>', ], ], 'TemplateBody' => [ 'base' => NULL, 'refs' => [ 'CreateProvisioningTemplateRequest$templateBody' => '<p>The JSON formatted contents of the fleet provisioning template.</p>', 'CreateProvisioningTemplateVersionRequest$templateBody' => '<p>The JSON formatted contents of the fleet provisioning template.</p>', 'DescribeProvisioningTemplateResponse$templateBody' => '<p>The JSON formatted contents of the fleet provisioning template.</p>', 'DescribeProvisioningTemplateVersionResponse$templateBody' => '<p>The JSON formatted contents of the fleet provisioning template version.</p>', 'DescribeThingRegistrationTaskResponse$templateBody' => '<p>The task\'s template.</p>', 'RegisterThingRequest$templateBody' => '<p>The provisioning template. See <a href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-w-cert.html">Provisioning Devices That Have Device Certificates</a> for more information.</p>', 'RegistrationConfig$templateBody' => '<p>The template body.</p>', 'StartThingRegistrationTaskRequest$templateBody' => '<p>The provisioning template.</p>', ], ], 'TemplateDescription' => [ 'base' => NULL, 'refs' => [ 'CreateProvisioningTemplateRequest$description' => '<p>The description of the fleet provisioning template.</p>', 'DescribeProvisioningTemplateResponse$description' => '<p>The description of the fleet provisioning template.</p>', 'ProvisioningTemplateSummary$description' => '<p>The description of the fleet provisioning template.</p>', 'UpdateProvisioningTemplateRequest$description' => '<p>The description of the fleet provisioning template.</p>', ], ], 'TemplateName' => [ 'base' => NULL, 'refs' => [ 'CreateProvisioningClaimRequest$templateName' => '<p>The name of the provisioning template to use.</p>', 'CreateProvisioningTemplateRequest$templateName' => '<p>The name of the fleet provisioning template.</p>', 'CreateProvisioningTemplateResponse$templateName' => '<p>The name of the fleet provisioning template.</p>', 'CreateProvisioningTemplateVersionRequest$templateName' => '<p>The name of the fleet provisioning template.</p>', 'CreateProvisioningTemplateVersionResponse$templateName' => '<p>The name of the fleet provisioning template.</p>', 'DeleteProvisioningTemplateRequest$templateName' => '<p>The name of the fleet provision template to delete.</p>', 'DeleteProvisioningTemplateVersionRequest$templateName' => '<p>The name of the fleet provisioning template version to delete.</p>', 'DescribeProvisioningTemplateRequest$templateName' => '<p>The name of the fleet provisioning template.</p>', 'DescribeProvisioningTemplateResponse$templateName' => '<p>The name of the fleet provisioning template.</p>', 'DescribeProvisioningTemplateVersionRequest$templateName' => '<p>The template name.</p>', 'ListProvisioningTemplateVersionsRequest$templateName' => '<p>The name of the fleet provisioning template.</p>', 'ProvisioningTemplateSummary$templateName' => '<p>The name of the fleet provisioning template.</p>', 'UpdateProvisioningTemplateRequest$templateName' => '<p>The name of the fleet provisioning template.</p>', ], ], 'TemplateVersionId' => [ 'base' => NULL, 'refs' => [ 'CreateProvisioningTemplateResponse$defaultVersionId' => '<p>The default version of the fleet provisioning template.</p>', 'CreateProvisioningTemplateVersionResponse$versionId' => '<p>The version of the fleet provisioning template.</p>', 'DeleteProvisioningTemplateVersionRequest$versionId' => '<p>The fleet provisioning template version ID to delete.</p>', 'DescribeProvisioningTemplateResponse$defaultVersionId' => '<p>The default fleet template version ID.</p>', 'DescribeProvisioningTemplateVersionRequest$versionId' => '<p>The fleet provisioning template version ID.</p>', 'DescribeProvisioningTemplateVersionResponse$versionId' => '<p>The fleet provisioning template version ID.</p>', 'ProvisioningTemplateVersionSummary$versionId' => '<p>The ID of the fleet privisioning template version.</p>', 'UpdateProvisioningTemplateRequest$defaultVersionId' => '<p>The ID of the default provisioning template version.</p>', ], ], 'TestAuthorizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'TestAuthorizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'TestInvokeAuthorizerRequest' => [ 'base' => NULL, 'refs' => [], ], 'TestInvokeAuthorizerResponse' => [ 'base' => NULL, 'refs' => [], ], 'ThingArn' => [ 'base' => NULL, 'refs' => [ 'AddThingToBillingGroupRequest$thingArn' => '<p>The ARN of the thing to be added to the billing group.</p>', 'AddThingToThingGroupRequest$thingArn' => '<p>The ARN of the thing to add to a group.</p>', 'CreateThingResponse$thingArn' => '<p>The ARN of the new thing.</p>', 'DescribeThingResponse$thingArn' => '<p>The ARN of the thing to describe.</p>', 'JobExecution$thingArn' => '<p>The ARN of the thing on which the job execution is running.</p>', 'JobExecutionSummaryForJob$thingArn' => '<p>The ARN of the thing on which the job execution is running.</p>', 'RemoveThingFromBillingGroupRequest$thingArn' => '<p>The ARN of the thing to be removed from the billing group.</p>', 'RemoveThingFromThingGroupRequest$thingArn' => '<p>The ARN of the thing to remove from the group.</p>', 'ThingAttribute$thingArn' => '<p>The thing ARN.</p>', ], ], 'ThingAttribute' => [ 'base' => '<p>The properties of the thing, including thing name, thing type name, and a list of thing attributes.</p>', 'refs' => [ 'ThingAttributeList$member' => NULL, ], ], 'ThingAttributeList' => [ 'base' => NULL, 'refs' => [ 'ListThingsResponse$things' => '<p>The things.</p>', ], ], 'ThingConnectivity' => [ 'base' => '<p>The connectivity status of the thing.</p>', 'refs' => [ 'ThingDocument$connectivity' => '<p>Indicates whether the thing is connected to the AWS IoT service.</p>', ], ], 'ThingConnectivityIndexingMode' => [ 'base' => NULL, 'refs' => [ 'ThingIndexingConfiguration$thingConnectivityIndexingMode' => '<p>Thing connectivity indexing mode. Valid values are: </p> <ul> <li> <p>STATUS – Your thing index contains connectivity status. To enable thing connectivity indexing, thingIndexMode must not be set to OFF.</p> </li> <li> <p>OFF - Thing connectivity status indexing is disabled.</p> </li> </ul>', ], ], 'ThingDocument' => [ 'base' => '<p>The thing search index document.</p>', 'refs' => [ 'ThingDocumentList$member' => NULL, ], ], 'ThingDocumentList' => [ 'base' => NULL, 'refs' => [ 'SearchIndexResponse$things' => '<p>The things that match the search query.</p>', ], ], 'ThingGroupArn' => [ 'base' => NULL, 'refs' => [ 'AddThingToThingGroupRequest$thingGroupArn' => '<p>The ARN of the group to which you are adding a thing.</p>', 'CreateDynamicThingGroupResponse$thingGroupArn' => '<p>The dynamic thing group ARN.</p>', 'CreateThingGroupResponse$thingGroupArn' => '<p>The thing group ARN.</p>', 'DescribeThingGroupResponse$thingGroupArn' => '<p>The thing group ARN.</p>', 'GroupNameAndArn$groupArn' => '<p>The group ARN.</p>', 'RemoveThingFromThingGroupRequest$thingGroupArn' => '<p>The group ARN.</p>', ], ], 'ThingGroupDescription' => [ 'base' => NULL, 'refs' => [ 'ThingGroupDocument$thingGroupDescription' => '<p>The thing group description.</p>', 'ThingGroupProperties$thingGroupDescription' => '<p>The thing group description.</p>', ], ], 'ThingGroupDocument' => [ 'base' => '<p>The thing group search index document.</p>', 'refs' => [ 'ThingGroupDocumentList$member' => NULL, ], ], 'ThingGroupDocumentList' => [ 'base' => NULL, 'refs' => [ 'SearchIndexResponse$thingGroups' => '<p>The thing groups that match the search query.</p>', ], ], 'ThingGroupId' => [ 'base' => NULL, 'refs' => [ 'CreateDynamicThingGroupResponse$thingGroupId' => '<p>The dynamic thing group ID.</p>', 'CreateThingGroupResponse$thingGroupId' => '<p>The thing group ID.</p>', 'DescribeThingGroupResponse$thingGroupId' => '<p>The thing group ID.</p>', 'JobSummary$thingGroupId' => '<p>The ID of the thing group.</p>', 'ListJobsRequest$thingGroupId' => '<p>A filter that limits the returned jobs to those for the specified group.</p>', 'ThingGroupDocument$thingGroupId' => '<p>The thing group ID.</p>', ], ], 'ThingGroupIndexingConfiguration' => [ 'base' => '<p>Thing group indexing configuration.</p>', 'refs' => [ 'GetIndexingConfigurationResponse$thingGroupIndexingConfiguration' => '<p>The index configuration.</p>', 'UpdateIndexingConfigurationRequest$thingGroupIndexingConfiguration' => '<p>Thing group indexing configuration.</p>', ], ], 'ThingGroupIndexingMode' => [ 'base' => NULL, 'refs' => [ 'ThingGroupIndexingConfiguration$thingGroupIndexingMode' => '<p>Thing group indexing mode.</p>', ], ], 'ThingGroupList' => [ 'base' => NULL, 'refs' => [ 'UpdateThingGroupsForThingRequest$thingGroupsToAdd' => '<p>The groups to which the thing will be added.</p>', 'UpdateThingGroupsForThingRequest$thingGroupsToRemove' => '<p>The groups from which the thing will be removed.</p>', ], ], 'ThingGroupMetadata' => [ 'base' => '<p>Thing group metadata.</p>', 'refs' => [ 'DescribeThingGroupResponse$thingGroupMetadata' => '<p>Thing group metadata.</p>', ], ], 'ThingGroupName' => [ 'base' => NULL, 'refs' => [ 'AddThingToThingGroupRequest$thingGroupName' => '<p>The name of the group to which you are adding a thing.</p>', 'CreateDynamicThingGroupRequest$thingGroupName' => '<p>The dynamic thing group name to create.</p>', 'CreateDynamicThingGroupResponse$thingGroupName' => '<p>The dynamic thing group name.</p>', 'CreateThingGroupRequest$thingGroupName' => '<p>The thing group name to create.</p>', 'CreateThingGroupRequest$parentGroupName' => '<p>The name of the parent thing group.</p>', 'CreateThingGroupResponse$thingGroupName' => '<p>The thing group name.</p>', 'DeleteDynamicThingGroupRequest$thingGroupName' => '<p>The name of the dynamic thing group to delete.</p>', 'DeleteThingGroupRequest$thingGroupName' => '<p>The name of the thing group to delete.</p>', 'DescribeThingGroupRequest$thingGroupName' => '<p>The name of the thing group.</p>', 'DescribeThingGroupResponse$thingGroupName' => '<p>The name of the thing group.</p>', 'GroupNameAndArn$groupName' => '<p>The group name.</p>', 'ListJobsRequest$thingGroupName' => '<p>A filter that limits the returned jobs to those for the specified group.</p>', 'ListThingGroupsRequest$parentGroup' => '<p>A filter that limits the results to those with the specified parent group.</p>', 'ListThingGroupsRequest$namePrefixFilter' => '<p>A filter that limits the results to those with the specified name prefix.</p>', 'ListThingsInThingGroupRequest$thingGroupName' => '<p>The thing group name.</p>', 'RemoveThingFromThingGroupRequest$thingGroupName' => '<p>The group name.</p>', 'ThingGroupDocument$thingGroupName' => '<p>The thing group name.</p>', 'ThingGroupList$member' => NULL, 'ThingGroupMetadata$parentGroupName' => '<p>The parent thing group name.</p>', 'ThingGroupNameList$member' => NULL, 'ThingGroupNames$member' => NULL, 'UpdateDynamicThingGroupRequest$thingGroupName' => '<p>The name of the dynamic thing group to update.</p>', 'UpdateThingGroupRequest$thingGroupName' => '<p>The thing group to update.</p>', ], ], 'ThingGroupNameAndArnList' => [ 'base' => NULL, 'refs' => [ 'ListThingGroupsForThingResponse$thingGroups' => '<p>The thing groups.</p>', 'ListThingGroupsResponse$thingGroups' => '<p>The thing groups.</p>', 'ThingGroupMetadata$rootToParentThingGroups' => '<p>The root parent thing group.</p>', ], ], 'ThingGroupNameList' => [ 'base' => NULL, 'refs' => [ 'ThingDocument$thingGroupNames' => '<p>Thing group names.</p>', 'ThingGroupDocument$parentGroupNames' => '<p>Parent group names.</p>', ], ], 'ThingGroupNames' => [ 'base' => NULL, 'refs' => [ 'AddThingsToThingGroupParams$thingGroupNames' => '<p>The list of groups to which you want to add the things that triggered the mitigation action. You can add a thing to a maximum of 10 groups, but you cannot add a thing to more than one group in the same hierarchy.</p>', ], ], 'ThingGroupProperties' => [ 'base' => '<p>Thing group properties.</p>', 'refs' => [ 'CreateDynamicThingGroupRequest$thingGroupProperties' => '<p>The dynamic thing group properties.</p>', 'CreateThingGroupRequest$thingGroupProperties' => '<p>The thing group properties.</p>', 'DescribeThingGroupResponse$thingGroupProperties' => '<p>The thing group properties.</p>', 'UpdateDynamicThingGroupRequest$thingGroupProperties' => '<p>The dynamic thing group properties to update.</p>', 'UpdateThingGroupRequest$thingGroupProperties' => '<p>The thing group properties.</p>', ], ], 'ThingId' => [ 'base' => NULL, 'refs' => [ 'CreateThingResponse$thingId' => '<p>The thing ID.</p>', 'DescribeThingResponse$thingId' => '<p>The ID of the thing to describe.</p>', 'ThingDocument$thingId' => '<p>The thing ID.</p>', ], ], 'ThingIndexingConfiguration' => [ 'base' => '<p>The thing indexing configuration. For more information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/managing-index.html">Managing Thing Indexing</a>.</p>', 'refs' => [ 'GetIndexingConfigurationResponse$thingIndexingConfiguration' => '<p>Thing indexing configuration.</p>', 'UpdateIndexingConfigurationRequest$thingIndexingConfiguration' => '<p>Thing indexing configuration.</p>', ], ], 'ThingIndexingMode' => [ 'base' => NULL, 'refs' => [ 'ThingIndexingConfiguration$thingIndexingMode' => '<p>Thing indexing mode. Valid values are:</p> <ul> <li> <p>REGISTRY – Your thing index contains registry data only.</p> </li> <li> <p>REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.</p> </li> <li> <p>OFF - Thing indexing is disabled.</p> </li> </ul>', ], ], 'ThingName' => [ 'base' => NULL, 'refs' => [ 'AddThingToBillingGroupRequest$thingName' => '<p>The name of the thing to be added to the billing group.</p>', 'AddThingToThingGroupRequest$thingName' => '<p>The name of the thing to add to a group.</p>', 'AttachThingPrincipalRequest$thingName' => '<p>The name of the thing.</p>', 'CancelJobExecutionRequest$thingName' => '<p>The name of the thing whose execution of the job will be canceled.</p>', 'CreateThingRequest$thingName' => '<p>The name of the thing to create.</p> <p>You can\'t change a thing\'s name after you create it. To change a thing\'s name, you must create a new thing, give it the new name, and then delete the old thing.</p>', 'CreateThingResponse$thingName' => '<p>The name of the new thing.</p>', 'DeleteJobExecutionRequest$thingName' => '<p>The name of the thing whose job execution will be deleted.</p>', 'DeleteThingRequest$thingName' => '<p>The name of the thing to delete.</p>', 'DescribeJobExecutionRequest$thingName' => '<p>The name of the thing on which the job execution is running.</p>', 'DescribeThingRequest$thingName' => '<p>The name of the thing.</p>', 'DescribeThingResponse$thingName' => '<p>The name of the thing.</p>', 'DetachThingPrincipalRequest$thingName' => '<p>The name of the thing.</p>', 'GetEffectivePoliciesRequest$thingName' => '<p>The thing name.</p>', 'ListJobExecutionsForThingRequest$thingName' => '<p>The thing name.</p>', 'ListThingGroupsForThingRequest$thingName' => '<p>The thing name.</p>', 'ListThingPrincipalsRequest$thingName' => '<p>The name of the thing.</p>', 'RemoveThingFromBillingGroupRequest$thingName' => '<p>The name of the thing to be removed from the billing group.</p>', 'RemoveThingFromThingGroupRequest$thingName' => '<p>The name of the thing to remove from the group.</p>', 'ThingAttribute$thingName' => '<p>The name of the thing.</p>', 'ThingDocument$thingName' => '<p>The thing name.</p>', 'ThingNameList$member' => NULL, 'UpdateThingGroupsForThingRequest$thingName' => '<p>The thing whose group memberships will be updated.</p>', 'UpdateThingRequest$thingName' => '<p>The name of the thing to update.</p> <p>You can\'t change a thing\'s name. To change a thing\'s name, you must create a new thing, give it the new name, and then delete the old thing.</p>', ], ], 'ThingNameList' => [ 'base' => NULL, 'refs' => [ 'ListPrincipalThingsResponse$things' => '<p>The things.</p>', 'ListThingsInBillingGroupResponse$things' => '<p>A list of things in the billing group.</p>', 'ListThingsInThingGroupResponse$things' => '<p>The things in the specified thing group.</p>', ], ], 'ThingTypeArn' => [ 'base' => NULL, 'refs' => [ 'CreateThingTypeResponse$thingTypeArn' => '<p>The Amazon Resource Name (ARN) of the thing type.</p>', 'DescribeThingTypeResponse$thingTypeArn' => '<p>The thing type ARN.</p>', 'ThingTypeDefinition$thingTypeArn' => '<p>The thing type ARN.</p>', ], ], 'ThingTypeDefinition' => [ 'base' => '<p>The definition of the thing type, including thing type name and description.</p>', 'refs' => [ 'ThingTypeList$member' => NULL, ], ], 'ThingTypeDescription' => [ 'base' => NULL, 'refs' => [ 'ThingTypeProperties$thingTypeDescription' => '<p>The description of the thing type.</p>', ], ], 'ThingTypeId' => [ 'base' => NULL, 'refs' => [ 'CreateThingTypeResponse$thingTypeId' => '<p>The thing type ID.</p>', 'DescribeThingTypeResponse$thingTypeId' => '<p>The thing type ID.</p>', ], ], 'ThingTypeList' => [ 'base' => NULL, 'refs' => [ 'ListThingTypesResponse$thingTypes' => '<p>The thing types.</p>', ], ], 'ThingTypeMetadata' => [ 'base' => '<p>The ThingTypeMetadata contains additional information about the thing type including: creation date and time, a value indicating whether the thing type is deprecated, and a date and time when time was deprecated.</p>', 'refs' => [ 'DescribeThingTypeResponse$thingTypeMetadata' => '<p>The ThingTypeMetadata contains additional information about the thing type including: creation date and time, a value indicating whether the thing type is deprecated, and a date and time when it was deprecated.</p>', 'ThingTypeDefinition$thingTypeMetadata' => '<p>The ThingTypeMetadata contains additional information about the thing type including: creation date and time, a value indicating whether the thing type is deprecated, and a date and time when it was deprecated.</p>', ], ], 'ThingTypeName' => [ 'base' => NULL, 'refs' => [ 'CreateThingRequest$thingTypeName' => '<p>The name of the thing type associated with the new thing.</p>', 'CreateThingTypeRequest$thingTypeName' => '<p>The name of the thing type.</p>', 'CreateThingTypeResponse$thingTypeName' => '<p>The name of the thing type.</p>', 'DeleteThingTypeRequest$thingTypeName' => '<p>The name of the thing type.</p>', 'DeprecateThingTypeRequest$thingTypeName' => '<p>The name of the thing type to deprecate.</p>', 'DescribeThingResponse$thingTypeName' => '<p>The thing type name.</p>', 'DescribeThingTypeRequest$thingTypeName' => '<p>The name of the thing type.</p>', 'DescribeThingTypeResponse$thingTypeName' => '<p>The name of the thing type.</p>', 'ListThingTypesRequest$thingTypeName' => '<p>The name of the thing type.</p>', 'ListThingsRequest$thingTypeName' => '<p>The name of the thing type used to search for things.</p>', 'ThingAttribute$thingTypeName' => '<p>The name of the thing type, if the thing has been associated with a type.</p>', 'ThingDocument$thingTypeName' => '<p>The thing type name.</p>', 'ThingTypeDefinition$thingTypeName' => '<p>The name of the thing type.</p>', 'UpdateThingRequest$thingTypeName' => '<p>The name of the thing type.</p>', ], ], 'ThingTypeProperties' => [ 'base' => '<p>The ThingTypeProperties contains information about the thing type including: a thing type description, and a list of searchable thing attribute names.</p>', 'refs' => [ 'CreateThingTypeRequest$thingTypeProperties' => '<p>The ThingTypeProperties for the thing type to create. It contains information about the new thing type including a description, and a list of searchable thing attribute names.</p>', 'DescribeThingTypeResponse$thingTypeProperties' => '<p>The ThingTypeProperties contains information about the thing type including description, and a list of searchable thing attribute names.</p>', 'ThingTypeDefinition$thingTypeProperties' => '<p>The ThingTypeProperties for the thing type.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The rate exceeds the limit.</p>', 'refs' => [], ], 'TimedOutThings' => [ 'base' => NULL, 'refs' => [ 'JobProcessDetails$numberOfTimedOutThings' => '<p>The number of things whose job execution status is <code>TIMED_OUT</code>.</p>', ], ], 'TimeoutConfig' => [ 'base' => '<p>Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.</p>', 'refs' => [ 'CreateJobRequest$timeoutConfig' => '<p>Specifies the amount of time each device has to finish its execution of the job. The timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the time expires, it will be automatically set to <code>TIMED_OUT</code>.</p>', 'Job$timeoutConfig' => '<p>Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.</p>', 'UpdateJobRequest$timeoutConfig' => '<p>Specifies the amount of time each device has to finish its execution of the job. The timer is started when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state before the time expires, it will be automatically set to <code>TIMED_OUT</code>. </p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ActiveViolation$lastViolationTime' => '<p>The time the most recent violation occurred.</p>', 'ActiveViolation$violationStartTime' => '<p>The time the violation started.</p>', 'AuditFinding$taskStartTime' => '<p>The time the audit started.</p>', 'AuditFinding$findingTime' => '<p>The time the result (finding) was discovered.</p>', 'AuditMitigationActionExecutionMetadata$startTime' => '<p>The date and time when the task was started.</p>', 'AuditMitigationActionExecutionMetadata$endTime' => '<p>The date and time when the task was completed or canceled. Blank if the task is still running.</p>', 'AuditMitigationActionsTaskMetadata$startTime' => '<p>The time at which the audit mitigation actions task was started.</p>', 'DescribeAuditMitigationActionsTaskResponse$startTime' => '<p>The date and time when the task was started.</p>', 'DescribeAuditMitigationActionsTaskResponse$endTime' => '<p>The date and time when the task was completed or canceled.</p>', 'DescribeAuditTaskResponse$taskStartTime' => '<p>The time the audit started.</p>', 'DescribeDimensionResponse$creationDate' => '<p>The date the dimension was created.</p>', 'DescribeDimensionResponse$lastModifiedDate' => '<p>The date the dimension was last modified.</p>', 'DescribeMitigationActionResponse$creationDate' => '<p>The date and time when the mitigation action was added to your AWS account.</p>', 'DescribeMitigationActionResponse$lastModifiedDate' => '<p>The date and time when the mitigation action was last changed.</p>', 'DescribeSecurityProfileResponse$creationDate' => '<p>The time the security profile was created.</p>', 'DescribeSecurityProfileResponse$lastModifiedDate' => '<p>The time the security profile was last modified.</p>', 'ListAuditFindingsRequest$startTime' => '<p>A filter to limit results to those found after the specified time. You must specify either the startTime and endTime or the taskId, but not both.</p>', 'ListAuditFindingsRequest$endTime' => '<p>A filter to limit results to those found before the specified time. You must specify either the startTime and endTime or the taskId, but not both.</p>', 'ListAuditMitigationActionsTasksRequest$startTime' => '<p>Specify this filter to limit results to tasks that began on or after a specific date and time.</p>', 'ListAuditMitigationActionsTasksRequest$endTime' => '<p>Specify this filter to limit results to tasks that were completed or canceled on or before a specific date and time.</p>', 'ListAuditTasksRequest$startTime' => '<p>The beginning of the time period. Audit information is retained for a limited time (180 days). Requesting a start time prior to what is retained results in an "InvalidRequestException".</p>', 'ListAuditTasksRequest$endTime' => '<p>The end of the time period.</p>', 'ListViolationEventsRequest$startTime' => '<p>The start time for the alerts to be listed.</p>', 'ListViolationEventsRequest$endTime' => '<p>The end time for the alerts to be listed.</p>', 'MitigationActionIdentifier$creationDate' => '<p>The date when this mitigation action was created.</p>', 'UpdateDimensionResponse$creationDate' => '<p>The date and time, in milliseconds since epoch, when the dimension was initially created.</p>', 'UpdateDimensionResponse$lastModifiedDate' => '<p>The date and time, in milliseconds since epoch, when the dimension was most recently updated.</p>', 'UpdateSecurityProfileResponse$creationDate' => '<p>The time the security profile was created.</p>', 'UpdateSecurityProfileResponse$lastModifiedDate' => '<p>The time the security profile was last modified.</p>', 'ViolationEvent$violationEventTime' => '<p>The time the violation event occurred.</p>', ], ], 'TlsContext' => [ 'base' => '<p>Specifies the TLS context to use for the test authorizer request.</p>', 'refs' => [ 'TestInvokeAuthorizerRequest$tlsContext' => '<p>Specifies a test TLS authorization request.</p>', ], ], 'Token' => [ 'base' => NULL, 'refs' => [ 'TestInvokeAuthorizerRequest$token' => '<p>The token returned by your custom authentication service.</p>', ], ], 'TokenKeyName' => [ 'base' => NULL, 'refs' => [ 'AuthorizerDescription$tokenKeyName' => '<p>The key used to extract the token from the HTTP headers.</p>', 'CreateAuthorizerRequest$tokenKeyName' => '<p>The name of the token key used to extract the token from the HTTP headers.</p>', 'UpdateAuthorizerRequest$tokenKeyName' => '<p>The key used to extract the token from the HTTP headers. </p>', ], ], 'TokenSignature' => [ 'base' => NULL, 'refs' => [ 'TestInvokeAuthorizerRequest$tokenSignature' => '<p>The signature made with the token and your custom authentication service\'s private key. This value must be Base-64-encoded.</p>', ], ], 'Topic' => [ 'base' => NULL, 'refs' => [ 'ListTopicRulesRequest$topic' => '<p>The topic.</p>', ], ], 'TopicPattern' => [ 'base' => NULL, 'refs' => [ 'RepublishAction$topic' => '<p>The name of the MQTT topic.</p>', 'TopicRuleListItem$topicPattern' => '<p>The pattern for the topic names that apply.</p>', ], ], 'TopicRule' => [ 'base' => '<p>Describes a rule.</p>', 'refs' => [ 'GetTopicRuleResponse$rule' => '<p>The rule.</p>', ], ], 'TopicRuleDestination' => [ 'base' => '<p>A topic rule destination.</p>', 'refs' => [ 'CreateTopicRuleDestinationResponse$topicRuleDestination' => '<p>The topic rule destination.</p>', 'GetTopicRuleDestinationResponse$topicRuleDestination' => '<p>The topic rule destination.</p>', ], ], 'TopicRuleDestinationConfiguration' => [ 'base' => '<p>Configuration of the topic rule destination.</p>', 'refs' => [ 'CreateTopicRuleDestinationRequest$destinationConfiguration' => '<p>The topic rule destination configuration.</p>', ], ], 'TopicRuleDestinationMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListTopicRuleDestinationsRequest$maxResults' => '<p>The maximum number of results to return at one time.</p>', ], ], 'TopicRuleDestinationStatus' => [ 'base' => NULL, 'refs' => [ 'TopicRuleDestination$status' => '<p>The status of the topic rule destination. Valid values are:</p> <dl> <dt>IN_PROGRESS</dt> <dd> <p>A topic rule destination was created but has not been confirmed. You can set <code>status</code> to <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation endpoint.</p> </dd> <dt>ENABLED</dt> <dd> <p>Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code> to <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.</p> </dd> <dt>DISABLED</dt> <dd> <p>Confirmation was completed, and traffic to this destination is not allowed. You can set <code>status</code> to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.</p> </dd> <dt>ERROR</dt> <dd> <p>Confirmation could not be completed, for example if the confirmation timed out. You can call <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation endpoint.</p> </dd> </dl>', 'TopicRuleDestinationSummary$status' => '<p>The status of the topic rule destination. Valid values are:</p> <dl> <dt>IN_PROGRESS</dt> <dd> <p>A topic rule destination was created but has not been confirmed. You can set <code>status</code> to <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation endpoint.</p> </dd> <dt>ENABLED</dt> <dd> <p>Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code> to <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.</p> </dd> <dt>DISABLED</dt> <dd> <p>Confirmation was completed, and traffic to this destination is not allowed. You can set <code>status</code> to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.</p> </dd> <dt>ERROR</dt> <dd> <p>Confirmation could not be completed, for example if the confirmation timed out. You can call <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation endpoint.</p> </dd> </dl>', 'UpdateTopicRuleDestinationRequest$status' => '<p>The status of the topic rule destination. Valid values are:</p> <dl> <dt>IN_PROGRESS</dt> <dd> <p>A topic rule destination was created but has not been confirmed. You can set <code>status</code> to <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation endpoint.</p> </dd> <dt>ENABLED</dt> <dd> <p>Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code> to <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.</p> </dd> <dt>DISABLED</dt> <dd> <p>Confirmation was completed, and traffic to this destination is not allowed. You can set <code>status</code> to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.</p> </dd> <dt>ERROR</dt> <dd> <p>Confirmation could not be completed, for example if the confirmation timed out. You can call <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation endpoint.</p> </dd> </dl>', ], ], 'TopicRuleDestinationSummaries' => [ 'base' => NULL, 'refs' => [ 'ListTopicRuleDestinationsResponse$destinationSummaries' => '<p>Information about a topic rule destination.</p>', ], ], 'TopicRuleDestinationSummary' => [ 'base' => '<p>Information about the topic rule destination.</p>', 'refs' => [ 'TopicRuleDestinationSummaries$member' => NULL, ], ], 'TopicRuleList' => [ 'base' => NULL, 'refs' => [ 'ListTopicRulesResponse$rules' => '<p>The rules.</p>', ], ], 'TopicRuleListItem' => [ 'base' => '<p>Describes a rule.</p>', 'refs' => [ 'TopicRuleList$member' => NULL, ], ], 'TopicRuleMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListTopicRulesRequest$maxResults' => '<p>The maximum number of results to return.</p>', ], ], 'TopicRulePayload' => [ 'base' => '<p>Describes a rule.</p>', 'refs' => [ 'CreateTopicRuleRequest$topicRulePayload' => '<p>The rule payload.</p>', 'ReplaceTopicRuleRequest$topicRulePayload' => '<p>The rule payload.</p>', ], ], 'TotalChecksCount' => [ 'base' => NULL, 'refs' => [ 'TaskStatistics$totalChecks' => '<p>The number of checks in this audit.</p>', ], ], 'TotalFindingsCount' => [ 'base' => NULL, 'refs' => [ 'TaskStatisticsForAuditCheck$totalFindingsCount' => '<p>The total number of findings to which a task is being applied.</p>', ], ], 'TotalResourcesCount' => [ 'base' => NULL, 'refs' => [ 'AuditCheckDetails$totalResourcesCount' => '<p>The number of resources on which the check was performed.</p>', ], ], 'TransferAlreadyCompletedException' => [ 'base' => '<p>You can\'t revert the certificate transfer because the transfer is already complete.</p>', 'refs' => [], ], 'TransferCertificateRequest' => [ 'base' => '<p>The input for the TransferCertificate operation.</p>', 'refs' => [], ], 'TransferCertificateResponse' => [ 'base' => '<p>The output from the TransferCertificate operation.</p>', 'refs' => [], ], 'TransferConflictException' => [ 'base' => '<p>You can\'t transfer the certificate because authorization policies are still attached.</p>', 'refs' => [], ], 'TransferData' => [ 'base' => '<p>Data used to transfer a certificate to an AWS account.</p>', 'refs' => [ 'CertificateDescription$transferData' => '<p>The transfer data.</p>', ], ], 'UnauthorizedException' => [ 'base' => '<p>You are not authorized to perform this operation.</p>', 'refs' => [], ], 'UndoDeprecate' => [ 'base' => NULL, 'refs' => [ 'DeprecateThingTypeRequest$undoDeprecate' => '<p>Whether to undeprecate a deprecated thing type. If <b>true</b>, the thing type will not be deprecated anymore and you can associate it with things.</p>', ], ], 'UnsignedLong' => [ 'base' => NULL, 'refs' => [ 'MetricValue$count' => '<p>If the <code>comparisonOperator</code> calls for a numeric value, use this to specify that numeric value to be compared with the <code>metric</code>.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccountAuditConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccountAuditConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAuthorizerRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAuthorizerResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBillingGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBillingGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCACertificateParams' => [ 'base' => '<p>Parameters to define a mitigation action that changes the state of the CA certificate to inactive.</p>', 'refs' => [ 'MitigationActionParams$updateCACertificateParams' => '<p>Parameters to define a mitigation action that changes the state of the CA certificate to inactive.</p>', ], ], 'UpdateCACertificateRequest' => [ 'base' => '<p>The input to the UpdateCACertificate operation.</p>', 'refs' => [], ], 'UpdateCertificateRequest' => [ 'base' => '<p>The input for the UpdateCertificate operation.</p>', 'refs' => [], ], 'UpdateDeviceCertificateParams' => [ 'base' => '<p>Parameters to define a mitigation action that changes the state of the device certificate to inactive.</p>', 'refs' => [ 'MitigationActionParams$updateDeviceCertificateParams' => '<p>Parameters to define a mitigation action that changes the state of the device certificate to inactive.</p>', ], ], 'UpdateDimensionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDimensionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDomainConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDomainConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDynamicThingGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDynamicThingGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEventConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEventConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIndexingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIndexingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMitigationActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMitigationActionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProvisioningTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProvisioningTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRoleAliasRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRoleAliasResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateScheduledAuditRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateScheduledAuditResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSecurityProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSecurityProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStreamRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStreamResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateThingGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateThingGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateThingGroupsForThingRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateThingGroupsForThingResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateThingRequest' => [ 'base' => '<p>The input for the UpdateThing operation.</p>', 'refs' => [], ], 'UpdateThingResponse' => [ 'base' => '<p>The output from the UpdateThing operation.</p>', 'refs' => [], ], 'UpdateTopicRuleDestinationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTopicRuleDestinationResponse' => [ 'base' => NULL, 'refs' => [], ], 'Url' => [ 'base' => NULL, 'refs' => [ 'HttpAction$url' => '<p>The endpoint URL. If substitution templates are used in the URL, you must also specify a <code>confirmationUrl</code>. If this is a new destination, a new <code>TopicRuleDestination</code> is created if possible.</p>', 'HttpAction$confirmationUrl' => '<p>The URL to which AWS IoT sends a confirmation message. The value of the confirmation URL must be a prefix of the endpoint URL. If you do not specify a confirmation URL AWS IoT uses the endpoint URL as the confirmation URL. If you use substitution templates in the confirmationUrl, you must create and enable topic rule destinations that match each possible value of the substitution template before traffic is allowed to your endpoint URL.</p>', 'HttpUrlDestinationConfiguration$confirmationUrl' => '<p>The URL AWS IoT uses to confirm ownership of or access to the topic rule destination URL.</p>', 'HttpUrlDestinationProperties$confirmationUrl' => '<p>The URL used to confirm the HTTP topic rule destination URL.</p>', 'HttpUrlDestinationSummary$confirmationUrl' => '<p>The URL used to confirm ownership of or access to the HTTP topic rule destination URL.</p>', ], ], 'UseBase64' => [ 'base' => NULL, 'refs' => [ 'SqsAction$useBase64' => '<p>Specifies whether to use Base64 encoding.</p>', ], ], 'Valid' => [ 'base' => NULL, 'refs' => [ 'ValidateSecurityProfileBehaviorsResponse$valid' => '<p>True if the behaviors were valid.</p>', ], ], 'ValidateSecurityProfileBehaviorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ValidateSecurityProfileBehaviorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationError' => [ 'base' => '<p>Information about an error found in a behavior specification.</p>', 'refs' => [ 'ValidationErrors$member' => NULL, ], ], 'ValidationErrors' => [ 'base' => NULL, 'refs' => [ 'ValidateSecurityProfileBehaviorsResponse$validationErrors' => '<p>The list of any errors found in the behaviors.</p>', ], ], 'Value' => [ 'base' => NULL, 'refs' => [ 'AdditionalParameterMap$value' => NULL, 'AttributesMap$value' => NULL, 'Parameters$value' => NULL, ], ], 'Variance' => [ 'base' => NULL, 'refs' => [ 'Statistics$variance' => '<p>The variance of the aggregated field values.</p>', ], ], 'Version' => [ 'base' => NULL, 'refs' => [ 'DescribeBillingGroupResponse$version' => '<p>The version of the billing group.</p>', 'DescribeSecurityProfileResponse$version' => '<p>The version of the security profile. A new version is generated whenever the security profile is updated.</p>', 'DescribeThingGroupResponse$version' => '<p>The version of the thing group.</p>', 'DescribeThingResponse$version' => '<p>The current version of the thing record in the registry.</p> <note> <p>To avoid unintentional changes to the information in the registry, you can pass the version information in the <code>expectedVersion</code> parameter of the <code>UpdateThing</code> and <code>DeleteThing</code> calls.</p> </note>', 'ThingAttribute$version' => '<p>The version of the thing record in the registry.</p>', 'UpdateBillingGroupResponse$version' => '<p>The latest version of the billing group.</p>', 'UpdateDynamicThingGroupResponse$version' => '<p>The dynamic thing group version.</p>', 'UpdateSecurityProfileResponse$version' => '<p>The updated version of the security profile.</p>', 'UpdateThingGroupResponse$version' => '<p>The version of the updated thing group.</p>', ], ], 'VersionConflictException' => [ 'base' => '<p>An exception thrown when the version of an entity specified with the <code>expectedVersion</code> parameter does not match the latest version in the system.</p>', 'refs' => [], ], 'VersionNumber' => [ 'base' => NULL, 'refs' => [ 'JobExecution$versionNumber' => '<p>The version of the job execution. Job execution versions are incremented each time they are updated by a device.</p>', ], ], 'VersionsLimitExceededException' => [ 'base' => '<p>The number of policy versions exceeds the limit.</p>', 'refs' => [], ], 'ViolationEvent' => [ 'base' => '<p>Information about a Device Defender security profile behavior violation.</p>', 'refs' => [ 'ViolationEvents$member' => NULL, ], ], 'ViolationEventType' => [ 'base' => NULL, 'refs' => [ 'ViolationEvent$violationEventType' => '<p>The type of violation event.</p>', ], ], 'ViolationEvents' => [ 'base' => NULL, 'refs' => [ 'ListViolationEventsResponse$violationEvents' => '<p>The security profile violation alerts issued for this account during the given time period, potentially filtered by security profile, behavior violated, or thing (device) violating.</p>', ], ], 'ViolationId' => [ 'base' => NULL, 'refs' => [ 'ActiveViolation$violationId' => '<p>The ID of the active violation.</p>', 'ViolationEvent$violationId' => '<p>The ID of the violation event.</p>', ], ], 'WaitingForDataCollectionChecksCount' => [ 'base' => NULL, 'refs' => [ 'TaskStatistics$waitingForDataCollectionChecks' => '<p>The number of checks waiting for data collection.</p>', ], ], 'errorMessage' => [ 'base' => NULL, 'refs' => [ 'CertificateConflictException$message' => '<p>The message for the exception.</p>', 'CertificateStateException$message' => '<p>The message for the exception.</p>', 'CertificateValidationException$message' => '<p>Additional information about the exception.</p>', 'ConflictingResourceUpdateException$message' => '<p>The message for the exception.</p>', 'DeleteConflictException$message' => '<p>The message for the exception.</p>', 'IndexNotReadyException$message' => '<p>The message for the exception.</p>', 'InternalException$message' => '<p>The message for the exception.</p>', 'InternalFailureException$message' => '<p>The message for the exception.</p>', 'InvalidAggregationException$message' => NULL, 'InvalidQueryException$message' => '<p>The message for the exception.</p>', 'InvalidRequestException$message' => '<p>The message for the exception.</p>', 'InvalidResponseException$message' => '<p>The message for the exception.</p>', 'InvalidStateTransitionException$message' => '<p>The message for the exception.</p>', 'LimitExceededException$message' => '<p>The message for the exception.</p>', 'MalformedPolicyException$message' => '<p>The message for the exception.</p>', 'NotConfiguredException$message' => '<p>The message for the exception.</p>', 'RegistrationCodeValidationException$message' => '<p>Additional information about the exception.</p>', 'ResourceAlreadyExistsException$message' => '<p>The message for the exception.</p>', 'ResourceNotFoundException$message' => '<p>The message for the exception.</p>', 'ResourceRegistrationFailureException$message' => '<p>The message for the exception.</p>', 'ServiceUnavailableException$message' => '<p>The message for the exception.</p>', 'SqlParseException$message' => '<p>The message for the exception.</p>', 'TaskAlreadyExistsException$message' => NULL, 'ThrottlingException$message' => '<p>The message for the exception.</p>', 'TransferAlreadyCompletedException$message' => '<p>The message for the exception.</p>', 'TransferConflictException$message' => '<p>The message for the exception.</p>', 'UnauthorizedException$message' => '<p>The message for the exception.</p>', 'VersionConflictException$message' => '<p>The message for the exception.</p>', 'VersionsLimitExceededException$message' => '<p>The message for the exception.</p>', ], ], 'resourceArn' => [ 'base' => NULL, 'refs' => [ 'ResourceAlreadyExistsException$resourceArn' => '<p>The ARN of the resource that caused the exception.</p>', ], ], 'resourceId' => [ 'base' => NULL, 'refs' => [ 'ResourceAlreadyExistsException$resourceId' => '<p>The ID of the resource that caused the exception.</p>', ], ], ],];
