<?php
// This file was auto-generated from sdk-root/src/data/glue/2017-03-31/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>AWS Glue</fullname> <p>Defines the public endpoint for the AWS Glue service.</p>', 'operations' => [ 'BatchCreatePartition' => '<p>Creates one or more partitions in a batch operation.</p>', 'BatchDeleteConnection' => '<p>Deletes a list of connection definitions from the Data Catalog.</p>', 'BatchDeletePartition' => '<p>Deletes one or more partitions in a batch operation.</p>', 'BatchDeleteTable' => '<p>Deletes multiple tables at once.</p> <note> <p>After completing this operation, you no longer have access to the table versions and partitions that belong to the deleted table. AWS Glue deletes these "orphaned" resources asynchronously in a timely manner, at the discretion of the service.</p> <p>To ensure the immediate deletion of all related resources, before calling <code>BatchDeleteTable</code>, use <code>DeleteTableVersion</code> or <code>BatchDeleteTableVersion</code>, and <code>DeletePartition</code> or <code>BatchDeletePartition</code>, to delete any resources that belong to the table.</p> </note>', 'BatchDeleteTableVersion' => '<p>Deletes a specified batch of versions of a table.</p>', 'BatchGetCrawlers' => '<p>Returns a list of resource metadata for a given list of crawler names. After calling the <code>ListCrawlers</code> operation, you can call this operation to access the data to which you have been granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.</p>', 'BatchGetDevEndpoints' => '<p>Returns a list of resource metadata for a given list of development endpoint names. After calling the <code>ListDevEndpoints</code> operation, you can call this operation to access the data to which you have been granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.</p>', 'BatchGetJobs' => '<p>Returns a list of resource metadata for a given list of job names. After calling the <code>ListJobs</code> operation, you can call this operation to access the data to which you have been granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags. </p>', 'BatchGetPartition' => '<p>Retrieves partitions in a batch request.</p>', 'BatchGetTriggers' => '<p>Returns a list of resource metadata for a given list of trigger names. After calling the <code>ListTriggers</code> operation, you can call this operation to access the data to which you have been granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.</p>', 'BatchGetWorkflows' => '<p>Returns a list of resource metadata for a given list of workflow names. After calling the <code>ListWorkflows</code> operation, you can call this operation to access the data to which you have been granted permissions. This operation supports all IAM permissions, including permission conditions that uses tags.</p>', 'BatchStopJobRun' => '<p>Stops one or more job runs for a specified job definition.</p>', 'CancelMLTaskRun' => '<p>Cancels (stops) a task run. Machine learning task runs are asynchronous tasks that AWS Glue runs on your behalf as part of various machine learning workflows. You can cancel a machine learning task run at any time by calling <code>CancelMLTaskRun</code> with a task run\'s parent transform\'s <code>TransformID</code> and the task run\'s <code>TaskRunId</code>. </p>', 'CreateClassifier' => '<p>Creates a classifier in the user\'s account. This can be a <code>GrokClassifier</code>, an <code>XMLClassifier</code>, a <code>JsonClassifier</code>, or a <code>CsvClassifier</code>, depending on which field of the request is present.</p>', 'CreateConnection' => '<p>Creates a connection definition in the Data Catalog.</p>', 'CreateCrawler' => '<p>Creates a new crawler with specified targets, role, configuration, and optional schedule. At least one crawl target must be specified, in the <code>s3Targets</code> field, the <code>jdbcTargets</code> field, or the <code>DynamoDBTargets</code> field.</p>', 'CreateDatabase' => '<p>Creates a new database in a Data Catalog.</p>', 'CreateDevEndpoint' => '<p>Creates a new development endpoint.</p>', 'CreateJob' => '<p>Creates a new job definition.</p>', 'CreateMLTransform' => '<p>Creates an AWS Glue machine learning transform. This operation creates the transform and all the necessary parameters to train it.</p> <p>Call this operation as the first step in the process of using a machine learning transform (such as the <code>FindMatches</code> transform) for deduplicating data. You can provide an optional <code>Description</code>, in addition to the parameters that you want to use for your algorithm.</p> <p>You must also specify certain parameters for the tasks that AWS Glue runs on your behalf as part of learning from your data and creating a high-quality machine learning transform. These parameters include <code>Role</code>, and optionally, <code>AllocatedCapacity</code>, <code>Timeout</code>, and <code>MaxRetries</code>. For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html">Jobs</a>.</p>', 'CreatePartition' => '<p>Creates a new partition.</p>', 'CreateScript' => '<p>Transforms a directed acyclic graph (DAG) into code.</p>', 'CreateSecurityConfiguration' => '<p>Creates a new security configuration. A security configuration is a set of security properties that can be used by AWS Glue. You can use a security configuration to encrypt data at rest. For information about using security configurations in AWS Glue, see <a href="https://docs.aws.amazon.com/glue/latest/dg/encryption-security-configuration.html">Encrypting Data Written by Crawlers, Jobs, and Development Endpoints</a>.</p>', 'CreateTable' => '<p>Creates a new table definition in the Data Catalog.</p>', 'CreateTrigger' => '<p>Creates a new trigger.</p>', 'CreateUserDefinedFunction' => '<p>Creates a new function definition in the Data Catalog.</p>', 'CreateWorkflow' => '<p>Creates a new workflow.</p>', 'DeleteClassifier' => '<p>Removes a classifier from the Data Catalog.</p>', 'DeleteColumnStatisticsForPartition' => '<p>Delete the partition column statistics of a column.</p>', 'DeleteColumnStatisticsForTable' => '<p>Retrieves table statistics of columns.</p>', 'DeleteConnection' => '<p>Deletes a connection from the Data Catalog.</p>', 'DeleteCrawler' => '<p>Removes a specified crawler from the AWS Glue Data Catalog, unless the crawler state is <code>RUNNING</code>.</p>', 'DeleteDatabase' => '<p>Removes a specified database from a Data Catalog.</p> <note> <p>After completing this operation, you no longer have access to the tables (and all table versions and partitions that might belong to the tables) and the user-defined functions in the deleted database. AWS Glue deletes these "orphaned" resources asynchronously in a timely manner, at the discretion of the service.</p> <p>To ensure the immediate deletion of all related resources, before calling <code>DeleteDatabase</code>, use <code>DeleteTableVersion</code> or <code>BatchDeleteTableVersion</code>, <code>DeletePartition</code> or <code>BatchDeletePartition</code>, <code>DeleteUserDefinedFunction</code>, and <code>DeleteTable</code> or <code>BatchDeleteTable</code>, to delete any resources that belong to the database.</p> </note>', 'DeleteDevEndpoint' => '<p>Deletes a specified development endpoint.</p>', 'DeleteJob' => '<p>Deletes a specified job definition. If the job definition is not found, no exception is thrown.</p>', 'DeleteMLTransform' => '<p>Deletes an AWS Glue machine learning transform. Machine learning transforms are a special type of transform that use machine learning to learn the details of the transformation to be performed by learning from examples provided by humans. These transformations are then saved by AWS Glue. If you no longer need a transform, you can delete it by calling <code>DeleteMLTransforms</code>. However, any AWS Glue jobs that still reference the deleted transform will no longer succeed.</p>', 'DeletePartition' => '<p>Deletes a specified partition.</p>', 'DeleteResourcePolicy' => '<p>Deletes a specified policy.</p>', 'DeleteSecurityConfiguration' => '<p>Deletes a specified security configuration.</p>', 'DeleteTable' => '<p>Removes a table definition from the Data Catalog.</p> <note> <p>After completing this operation, you no longer have access to the table versions and partitions that belong to the deleted table. AWS Glue deletes these "orphaned" resources asynchronously in a timely manner, at the discretion of the service.</p> <p>To ensure the immediate deletion of all related resources, before calling <code>DeleteTable</code>, use <code>DeleteTableVersion</code> or <code>BatchDeleteTableVersion</code>, and <code>DeletePartition</code> or <code>BatchDeletePartition</code>, to delete any resources that belong to the table.</p> </note>', 'DeleteTableVersion' => '<p>Deletes a specified version of a table.</p>', 'DeleteTrigger' => '<p>Deletes a specified trigger. If the trigger is not found, no exception is thrown.</p>', 'DeleteUserDefinedFunction' => '<p>Deletes an existing function definition from the Data Catalog.</p>', 'DeleteWorkflow' => '<p>Deletes a workflow.</p>', 'GetCatalogImportStatus' => '<p>Retrieves the status of a migration operation.</p>', 'GetClassifier' => '<p>Retrieve a classifier by name.</p>', 'GetClassifiers' => '<p>Lists all classifier objects in the Data Catalog.</p>', 'GetColumnStatisticsForPartition' => '<p>Retrieves partition statistics of columns.</p>', 'GetColumnStatisticsForTable' => '<p>Retrieves table statistics of columns.</p>', 'GetConnection' => '<p>Retrieves a connection definition from the Data Catalog.</p>', 'GetConnections' => '<p>Retrieves a list of connection definitions from the Data Catalog.</p>', 'GetCrawler' => '<p>Retrieves metadata for a specified crawler.</p>', 'GetCrawlerMetrics' => '<p>Retrieves metrics about specified crawlers.</p>', 'GetCrawlers' => '<p>Retrieves metadata for all crawlers defined in the customer account.</p>', 'GetDataCatalogEncryptionSettings' => '<p>Retrieves the security configuration for a specified catalog.</p>', 'GetDatabase' => '<p>Retrieves the definition of a specified database.</p>', 'GetDatabases' => '<p>Retrieves all databases defined in a given Data Catalog.</p>', 'GetDataflowGraph' => '<p>Transforms a Python script into a directed acyclic graph (DAG). </p>', 'GetDevEndpoint' => '<p>Retrieves information about a specified development endpoint.</p> <note> <p>When you create a development endpoint in a virtual private cloud (VPC), AWS Glue returns only a private IP address, and the public IP address field is not populated. When you create a non-VPC development endpoint, AWS Glue returns only a public IP address.</p> </note>', 'GetDevEndpoints' => '<p>Retrieves all the development endpoints in this AWS account.</p> <note> <p>When you create a development endpoint in a virtual private cloud (VPC), AWS Glue returns only a private IP address and the public IP address field is not populated. When you create a non-VPC development endpoint, AWS Glue returns only a public IP address.</p> </note>', 'GetJob' => '<p>Retrieves an existing job definition.</p>', 'GetJobBookmark' => '<p>Returns information on a job bookmark entry.</p>', 'GetJobRun' => '<p>Retrieves the metadata for a given job run.</p>', 'GetJobRuns' => '<p>Retrieves metadata for all runs of a given job definition.</p>', 'GetJobs' => '<p>Retrieves all current job definitions.</p>', 'GetMLTaskRun' => '<p>Gets details for a specific task run on a machine learning transform. Machine learning task runs are asynchronous tasks that AWS Glue runs on your behalf as part of various machine learning workflows. You can check the stats of any task run by calling <code>GetMLTaskRun</code> with the <code>TaskRunID</code> and its parent transform\'s <code>TransformID</code>.</p>', 'GetMLTaskRuns' => '<p>Gets a list of runs for a machine learning transform. Machine learning task runs are asynchronous tasks that AWS Glue runs on your behalf as part of various machine learning workflows. You can get a sortable, filterable list of machine learning task runs by calling <code>GetMLTaskRuns</code> with their parent transform\'s <code>TransformID</code> and other optional parameters as documented in this section.</p> <p>This operation returns a list of historic runs and must be paginated.</p>', 'GetMLTransform' => '<p>Gets an AWS Glue machine learning transform artifact and all its corresponding metadata. Machine learning transforms are a special type of transform that use machine learning to learn the details of the transformation to be performed by learning from examples provided by humans. These transformations are then saved by AWS Glue. You can retrieve their metadata by calling <code>GetMLTransform</code>.</p>', 'GetMLTransforms' => '<p>Gets a sortable, filterable list of existing AWS Glue machine learning transforms. Machine learning transforms are a special type of transform that use machine learning to learn the details of the transformation to be performed by learning from examples provided by humans. These transformations are then saved by AWS Glue, and you can retrieve their metadata by calling <code>GetMLTransforms</code>.</p>', 'GetMapping' => '<p>Creates mappings.</p>', 'GetPartition' => '<p>Retrieves information about a specified partition.</p>', 'GetPartitions' => '<p>Retrieves information about the partitions in a table.</p>', 'GetPlan' => '<p>Gets code to perform a specified mapping.</p>', 'GetResourcePolicies' => '<p>Retrieves the security configurations for the resource policies set on individual resources, and also the account-level policy.</p> <p>This operation also returns the Data Catalog resource policy. However, if you enabled metadata encryption in Data Catalog settings, and you do not have permission on the AWS KMS key, the operation can\'t return the Data Catalog resource policy.</p>', 'GetResourcePolicy' => '<p>Retrieves a specified resource policy.</p>', 'GetSecurityConfiguration' => '<p>Retrieves a specified security configuration.</p>', 'GetSecurityConfigurations' => '<p>Retrieves a list of all security configurations.</p>', 'GetTable' => '<p>Retrieves the <code>Table</code> definition in a Data Catalog for a specified table.</p>', 'GetTableVersion' => '<p>Retrieves a specified version of a table.</p>', 'GetTableVersions' => '<p>Retrieves a list of strings that identify available versions of a specified table.</p>', 'GetTables' => '<p>Retrieves the definitions of some or all of the tables in a given <code>Database</code>.</p>', 'GetTags' => '<p>Retrieves a list of tags associated with a resource.</p>', 'GetTrigger' => '<p>Retrieves the definition of a trigger.</p>', 'GetTriggers' => '<p>Gets all the triggers associated with a job.</p>', 'GetUserDefinedFunction' => '<p>Retrieves a specified function definition from the Data Catalog.</p>', 'GetUserDefinedFunctions' => '<p>Retrieves multiple function definitions from the Data Catalog.</p>', 'GetWorkflow' => '<p>Retrieves resource metadata for a workflow.</p>', 'GetWorkflowRun' => '<p>Retrieves the metadata for a given workflow run. </p>', 'GetWorkflowRunProperties' => '<p>Retrieves the workflow run properties which were set during the run.</p>', 'GetWorkflowRuns' => '<p>Retrieves metadata for all runs of a given workflow.</p>', 'ImportCatalogToGlue' => '<p>Imports an existing Amazon Athena Data Catalog to AWS Glue</p>', 'ListCrawlers' => '<p>Retrieves the names of all crawler resources in this AWS account, or the resources with the specified tag. This operation allows you to see which resources are available in your account, and their names.</p> <p>This operation takes the optional <code>Tags</code> field, which you can use as a filter on the response so that tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag are retrieved.</p>', 'ListDevEndpoints' => '<p>Retrieves the names of all <code>DevEndpoint</code> resources in this AWS account, or the resources with the specified tag. This operation allows you to see which resources are available in your account, and their names.</p> <p>This operation takes the optional <code>Tags</code> field, which you can use as a filter on the response so that tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag are retrieved.</p>', 'ListJobs' => '<p>Retrieves the names of all job resources in this AWS account, or the resources with the specified tag. This operation allows you to see which resources are available in your account, and their names.</p> <p>This operation takes the optional <code>Tags</code> field, which you can use as a filter on the response so that tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag are retrieved.</p>', 'ListMLTransforms' => '<p> Retrieves a sortable, filterable list of existing AWS Glue machine learning transforms in this AWS account, or the resources with the specified tag. This operation takes the optional <code>Tags</code> field, which you can use as a filter of the responses so that tagged resources can be retrieved as a group. If you choose to use tag filtering, only resources with the tags are retrieved. </p>', 'ListTriggers' => '<p>Retrieves the names of all trigger resources in this AWS account, or the resources with the specified tag. This operation allows you to see which resources are available in your account, and their names.</p> <p>This operation takes the optional <code>Tags</code> field, which you can use as a filter on the response so that tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag are retrieved.</p>', 'ListWorkflows' => '<p>Lists names of workflows created in the account.</p>', 'PutDataCatalogEncryptionSettings' => '<p>Sets the security configuration for a specified catalog. After the configuration has been set, the specified encryption is applied to every catalog write thereafter.</p>', 'PutResourcePolicy' => '<p>Sets the Data Catalog resource policy for access control.</p>', 'PutWorkflowRunProperties' => '<p>Puts the specified workflow run properties for the given workflow run. If a property already exists for the specified run, then it overrides the value otherwise adds the property to existing properties.</p>', 'ResetJobBookmark' => '<p>Resets a bookmark entry.</p>', 'ResumeWorkflowRun' => '<p>Restarts any completed nodes in a workflow run and resumes the run execution.</p>', 'SearchTables' => '<p>Searches a set of tables based on properties in the table metadata as well as on the parent database. You can search against text or filter conditions. </p> <p>You can only get tables that you have access to based on the security policies defined in Lake Formation. You need at least a read-only access to the table for it to be returned. If you do not have access to all the columns in the table, these columns will not be searched against when returning the list of tables back to you. If you have access to the columns but not the data in the columns, those columns and the associated metadata for those columns will be included in the search. </p>', 'StartCrawler' => '<p>Starts a crawl using the specified crawler, regardless of what is scheduled. If the crawler is already running, returns a <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-exceptions.html#aws-glue-api-exceptions-CrawlerRunningException">CrawlerRunningException</a>.</p>', 'StartCrawlerSchedule' => '<p>Changes the schedule state of the specified crawler to <code>SCHEDULED</code>, unless the crawler is already running or the schedule state is already <code>SCHEDULED</code>.</p>', 'StartExportLabelsTaskRun' => '<p>Begins an asynchronous task to export all labeled data for a particular transform. This task is the only label-related API call that is not part of the typical active learning workflow. You typically use <code>StartExportLabelsTaskRun</code> when you want to work with all of your existing labels at the same time, such as when you want to remove or change labels that were previously submitted as truth. This API operation accepts the <code>TransformId</code> whose labels you want to export and an Amazon Simple Storage Service (Amazon S3) path to export the labels to. The operation returns a <code>TaskRunId</code>. You can check on the status of your task run by calling the <code>GetMLTaskRun</code> API.</p>', 'StartImportLabelsTaskRun' => '<p>Enables you to provide additional labels (examples of truth) to be used to teach the machine learning transform and improve its quality. This API operation is generally used as part of the active learning workflow that starts with the <code>StartMLLabelingSetGenerationTaskRun</code> call and that ultimately results in improving the quality of your machine learning transform. </p> <p>After the <code>StartMLLabelingSetGenerationTaskRun</code> finishes, AWS Glue machine learning will have generated a series of questions for humans to answer. (Answering these questions is often called \'labeling\' in the machine learning workflows). In the case of the <code>FindMatches</code> transform, these questions are of the form, “What is the correct way to group these rows together into groups composed entirely of matching records?” After the labeling process is finished, users upload their answers/labels with a call to <code>StartImportLabelsTaskRun</code>. After <code>StartImportLabelsTaskRun</code> finishes, all future runs of the machine learning transform use the new and improved labels and perform a higher-quality transformation.</p> <p>By default, <code>StartMLLabelingSetGenerationTaskRun</code> continually learns from and combines all labels that you upload unless you set <code>Replace</code> to true. If you set <code>Replace</code> to true, <code>StartImportLabelsTaskRun</code> deletes and forgets all previously uploaded labels and learns only from the exact set that you upload. Replacing labels can be helpful if you realize that you previously uploaded incorrect labels, and you believe that they are having a negative effect on your transform quality.</p> <p>You can check on the status of your task run by calling the <code>GetMLTaskRun</code> operation. </p>', 'StartJobRun' => '<p>Starts a job run using a job definition.</p>', 'StartMLEvaluationTaskRun' => '<p>Starts a task to estimate the quality of the transform. </p> <p>When you provide label sets as examples of truth, AWS Glue machine learning uses some of those examples to learn from them. The rest of the labels are used as a test to estimate quality.</p> <p>Returns a unique identifier for the run. You can call <code>GetMLTaskRun</code> to get more information about the stats of the <code>EvaluationTaskRun</code>.</p>', 'StartMLLabelingSetGenerationTaskRun' => '<p>Starts the active learning workflow for your machine learning transform to improve the transform\'s quality by generating label sets and adding labels.</p> <p>When the <code>StartMLLabelingSetGenerationTaskRun</code> finishes, AWS Glue will have generated a "labeling set" or a set of questions for humans to answer.</p> <p>In the case of the <code>FindMatches</code> transform, these questions are of the form, “What is the correct way to group these rows together into groups composed entirely of matching records?” </p> <p>After the labeling process is finished, you can upload your labels with a call to <code>StartImportLabelsTaskRun</code>. After <code>StartImportLabelsTaskRun</code> finishes, all future runs of the machine learning transform will use the new and improved labels and perform a higher-quality transformation.</p>', 'StartTrigger' => '<p>Starts an existing trigger. See <a href="https://docs.aws.amazon.com/glue/latest/dg/trigger-job.html">Triggering Jobs</a> for information about how different types of trigger are started.</p>', 'StartWorkflowRun' => '<p>Starts a new run of the specified workflow.</p>', 'StopCrawler' => '<p>If the specified crawler is running, stops the crawl.</p>', 'StopCrawlerSchedule' => '<p>Sets the schedule state of the specified crawler to <code>NOT_SCHEDULED</code>, but does not stop the crawler if it is already running.</p>', 'StopTrigger' => '<p>Stops a specified trigger.</p>', 'StopWorkflowRun' => '<p>Stops the execution of the specified workflow run.</p>', 'TagResource' => '<p>Adds tags to a resource. A tag is a label you can assign to an AWS resource. In AWS Glue, you can tag only certain resources. For information about what resources you can tag, see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">AWS Tags in AWS Glue</a>.</p>', 'UntagResource' => '<p>Removes tags from a resource.</p>', 'UpdateClassifier' => '<p>Modifies an existing classifier (a <code>GrokClassifier</code>, an <code>XMLClassifier</code>, a <code>JsonClassifier</code>, or a <code>CsvClassifier</code>, depending on which field is present).</p>', 'UpdateColumnStatisticsForPartition' => '<p>Creates or updates partition statistics of columns.</p>', 'UpdateColumnStatisticsForTable' => '<p>Creates or updates table statistics of columns.</p>', 'UpdateConnection' => '<p>Updates a connection definition in the Data Catalog.</p>', 'UpdateCrawler' => '<p>Updates a crawler. If a crawler is running, you must stop it using <code>StopCrawler</code> before updating it.</p>', 'UpdateCrawlerSchedule' => '<p>Updates the schedule of a crawler using a <code>cron</code> expression. </p>', 'UpdateDatabase' => '<p>Updates an existing database definition in a Data Catalog.</p>', 'UpdateDevEndpoint' => '<p>Updates a specified development endpoint.</p>', 'UpdateJob' => '<p>Updates an existing job definition.</p>', 'UpdateMLTransform' => '<p>Updates an existing machine learning transform. Call this operation to tune the algorithm parameters to achieve better results.</p> <p>After calling this operation, you can call the <code>StartMLEvaluationTaskRun</code> operation to assess how well your new parameters achieved your goals (such as improving the quality of your machine learning transform, or making it more cost-effective).</p>', 'UpdatePartition' => '<p>Updates a partition.</p>', 'UpdateTable' => '<p>Updates a metadata table in the Data Catalog.</p>', 'UpdateTrigger' => '<p>Updates a trigger definition.</p>', 'UpdateUserDefinedFunction' => '<p>Updates an existing function definition in the Data Catalog.</p>', 'UpdateWorkflow' => '<p>Updates an existing workflow.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>Access to a resource was denied.</p>', 'refs' => [], ], 'Action' => [ 'base' => '<p>Defines an action to be initiated by a trigger.</p>', 'refs' => [ 'ActionList$member' => NULL, ], ], 'ActionList' => [ 'base' => NULL, 'refs' => [ 'CreateTriggerRequest$Actions' => '<p>The actions initiated by this trigger when it fires.</p>', 'Trigger$Actions' => '<p>The actions initiated by this trigger.</p>', 'TriggerUpdate$Actions' => '<p>The actions initiated by this trigger.</p>', ], ], 'AlreadyExistsException' => [ 'base' => '<p>A resource to be created or added already exists.</p>', 'refs' => [], ], 'AttemptCount' => [ 'base' => NULL, 'refs' => [ 'JobRun$Attempt' => '<p>The number of the attempt to run this job.</p>', ], ], 'BatchCreatePartitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchCreatePartitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteConnectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeletePartitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeletePartitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeletePartitionValueList' => [ 'base' => NULL, 'refs' => [ 'BatchDeletePartitionRequest$PartitionsToDelete' => '<p>A list of <code>PartitionInput</code> structures that define the partitions to be deleted.</p>', ], ], 'BatchDeleteTableNameList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteTableRequest$TablesToDelete' => '<p>A list of the table to delete.</p>', ], ], 'BatchDeleteTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteTableResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteTableVersionList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteTableVersionRequest$VersionIds' => '<p>A list of the IDs of versions to be deleted. A <code>VersionId</code> is a string representation of an integer. Each version is incremented by 1.</p>', ], ], 'BatchDeleteTableVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteTableVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetCrawlersRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetCrawlersResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetDevEndpointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetDevEndpointsResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetPartitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetPartitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetPartitionValueList' => [ 'base' => NULL, 'refs' => [ 'BatchGetPartitionRequest$PartitionsToGet' => '<p>A list of partition values identifying the partitions to retrieve.</p>', 'BatchGetPartitionResponse$UnprocessedKeys' => '<p>A list of the partition values in the request for which partitions were not returned.</p>', ], ], 'BatchGetTriggersRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetTriggersResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetWorkflowsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetWorkflowsResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchStopJobRunError' => [ 'base' => '<p>Records an error that occurred when attempting to stop a specified job run.</p>', 'refs' => [ 'BatchStopJobRunErrorList$member' => NULL, ], ], 'BatchStopJobRunErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchStopJobRunResponse$Errors' => '<p>A list of the errors that were encountered in trying to stop <code>JobRuns</code>, including the <code>JobRunId</code> for which each error was encountered and details about the error.</p>', ], ], 'BatchStopJobRunJobRunIdList' => [ 'base' => NULL, 'refs' => [ 'BatchStopJobRunRequest$JobRunIds' => '<p>A list of the <code>JobRunIds</code> that should be stopped for that job definition.</p>', ], ], 'BatchStopJobRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchStopJobRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchStopJobRunSuccessfulSubmission' => [ 'base' => '<p>Records a successful request to stop a specified <code>JobRun</code>.</p>', 'refs' => [ 'BatchStopJobRunSuccessfulSubmissionList$member' => NULL, ], ], 'BatchStopJobRunSuccessfulSubmissionList' => [ 'base' => NULL, 'refs' => [ 'BatchStopJobRunResponse$SuccessfulSubmissions' => '<p>A list of the JobRuns that were successfully submitted for stopping.</p>', ], ], 'BinaryColumnStatisticsData' => [ 'base' => '<p>Defines a binary column statistics data.</p>', 'refs' => [ 'ColumnStatisticsData$BinaryColumnStatisticsData' => '<p>Binary Column Statistics Data.</p>', ], ], 'Blob' => [ 'base' => NULL, 'refs' => [ 'DecimalNumber$UnscaledValue' => '<p>The unscaled numeric value.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CatalogImportStatus$ImportCompleted' => '<p> <code>True</code> if the migration has completed, or <code>False</code> otherwise.</p>', 'CodeGenNodeArg$Param' => '<p>True if the value is used as a parameter.</p>', 'ConnectionPasswordEncryption$ReturnConnectionPasswordEncrypted' => '<p>When the <code>ReturnConnectionPasswordEncrypted</code> flag is set to "true", passwords remain encrypted in the responses of <code>GetConnection</code> and <code>GetConnections</code>. This encryption takes effect independently from catalog encryption. </p>', 'CrawlerMetrics$StillEstimating' => '<p>True if the crawler is still estimating how long it will take to complete this run.</p>', 'GetConnectionRequest$HidePassword' => '<p>Allows you to retrieve the connection metadata without returning the password. For instance, the AWS Glue console uses this flag to retrieve the connection, and does not display the password. Set this parameter when the caller might not have permission to use the AWS KMS key to decrypt the password, but it does have permission to access the rest of the connection properties.</p>', 'GetConnectionsRequest$HidePassword' => '<p>Allows you to retrieve the connection metadata without returning the password. For instance, the AWS Glue console uses this flag to retrieve the connection, and does not display the password. Set this parameter when the caller might not have permission to use the AWS KMS key to decrypt the password, but it does have permission to access the rest of the connection properties.</p>', 'StorageDescriptor$Compressed' => '<p> <code>True</code> if the data in the table is compressed, or <code>False</code> if not.</p>', 'StorageDescriptor$StoredAsSubDirectories' => '<p> <code>True</code> if the table data is stored in subdirectories, or <code>False</code> if not.</p>', 'Table$IsRegisteredWithLakeFormation' => '<p>Indicates whether the table has been registered with AWS Lake Formation.</p>', ], ], 'BooleanColumnStatisticsData' => [ 'base' => '<p>Defines a boolean column statistics.</p>', 'refs' => [ 'ColumnStatisticsData$BooleanColumnStatisticsData' => '<p>Boolean Column Statistics Data.</p>', ], ], 'BooleanNullable' => [ 'base' => NULL, 'refs' => [ 'UpdateTableRequest$SkipArchive' => '<p>By default, <code>UpdateTable</code> always creates an archived version of the table before updating it. However, if <code>skipArchive</code> is set to true, <code>UpdateTable</code> does not create the archived version.</p>', ], ], 'BooleanValue' => [ 'base' => NULL, 'refs' => [ 'CreateTriggerRequest$StartOnCreation' => '<p>Set to <code>true</code> to start <code>SCHEDULED</code> and <code>CONDITIONAL</code> triggers when created. True is not supported for <code>ON_DEMAND</code> triggers.</p>', 'GetJobRunRequest$PredecessorsIncluded' => '<p>True if a list of predecessor runs should be returned.</p>', 'UpdateDevEndpointRequest$UpdateEtlLibraries' => '<p> <code>True</code> if the list of custom libraries to be loaded in the development endpoint needs to be updated, or <code>False</code> if otherwise.</p>', ], ], 'BoundedPartitionValueList' => [ 'base' => NULL, 'refs' => [ 'UpdatePartitionRequest$PartitionValueList' => '<p>List of partition key values that define the partition to update.</p>', ], ], 'CancelMLTaskRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelMLTaskRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'CatalogEncryptionMode' => [ 'base' => NULL, 'refs' => [ 'EncryptionAtRest$CatalogEncryptionMode' => '<p>The encryption-at-rest mode for encrypting Data Catalog data.</p>', ], ], 'CatalogEntries' => [ 'base' => NULL, 'refs' => [ 'GetMappingRequest$Sinks' => '<p>A list of target tables.</p>', 'GetPlanRequest$Sinks' => '<p>The target tables.</p>', ], ], 'CatalogEntry' => [ 'base' => '<p>Specifies a table definition in the AWS Glue Data Catalog.</p>', 'refs' => [ 'CatalogEntries$member' => NULL, 'GetMappingRequest$Source' => '<p>Specifies the source table.</p>', 'GetPlanRequest$Source' => '<p>The source table.</p>', ], ], 'CatalogIdString' => [ 'base' => NULL, 'refs' => [ 'BatchCreatePartitionRequest$CatalogId' => '<p>The ID of the catalog in which the partition is to be created. Currently, this should be the AWS account ID.</p>', 'BatchDeleteConnectionRequest$CatalogId' => '<p>The ID of the Data Catalog in which the connections reside. If none is provided, the AWS account ID is used by default.</p>', 'BatchDeletePartitionRequest$CatalogId' => '<p>The ID of the Data Catalog where the partition to be deleted resides. If none is provided, the AWS account ID is used by default.</p>', 'BatchDeleteTableRequest$CatalogId' => '<p>The ID of the Data Catalog where the table resides. If none is provided, the AWS account ID is used by default.</p>', 'BatchDeleteTableVersionRequest$CatalogId' => '<p>The ID of the Data Catalog where the tables reside. If none is provided, the AWS account ID is used by default.</p>', 'BatchGetPartitionRequest$CatalogId' => '<p>The ID of the Data Catalog where the partitions in question reside. If none is supplied, the AWS account ID is used by default.</p>', 'CreateConnectionRequest$CatalogId' => '<p>The ID of the Data Catalog in which to create the connection. If none is provided, the AWS account ID is used by default.</p>', 'CreateDatabaseRequest$CatalogId' => '<p>The ID of the Data Catalog in which to create the database. If none is provided, the AWS account ID is used by default.</p>', 'CreatePartitionRequest$CatalogId' => '<p>The AWS account ID of the catalog in which the partition is to be created.</p>', 'CreateTableRequest$CatalogId' => '<p>The ID of the Data Catalog in which to create the <code>Table</code>. If none is supplied, the AWS account ID is used by default.</p>', 'CreateUserDefinedFunctionRequest$CatalogId' => '<p>The ID of the Data Catalog in which to create the function. If none is provided, the AWS account ID is used by default.</p>', 'Database$CatalogId' => '<p>The ID of the Data Catalog in which the database resides.</p>', 'DatabaseIdentifier$CatalogId' => '<p>The ID of the Data Catalog in which the database resides.</p>', 'DeleteColumnStatisticsForPartitionRequest$CatalogId' => '<p>The ID of the Data Catalog where the partitions in question reside. If none is supplied, the AWS account ID is used by default.</p>', 'DeleteColumnStatisticsForTableRequest$CatalogId' => '<p>The ID of the Data Catalog where the partitions in question reside. If none is supplied, the AWS account ID is used by default.</p>', 'DeleteConnectionRequest$CatalogId' => '<p>The ID of the Data Catalog in which the connection resides. If none is provided, the AWS account ID is used by default.</p>', 'DeleteDatabaseRequest$CatalogId' => '<p>The ID of the Data Catalog in which the database resides. If none is provided, the AWS account ID is used by default.</p>', 'DeletePartitionRequest$CatalogId' => '<p>The ID of the Data Catalog where the partition to be deleted resides. If none is provided, the AWS account ID is used by default.</p>', 'DeleteTableRequest$CatalogId' => '<p>The ID of the Data Catalog where the table resides. If none is provided, the AWS account ID is used by default.</p>', 'DeleteTableVersionRequest$CatalogId' => '<p>The ID of the Data Catalog where the tables reside. If none is provided, the AWS account ID is used by default.</p>', 'DeleteUserDefinedFunctionRequest$CatalogId' => '<p>The ID of the Data Catalog where the function to be deleted is located. If none is supplied, the AWS account ID is used by default.</p>', 'GetCatalogImportStatusRequest$CatalogId' => '<p>The ID of the catalog to migrate. Currently, this should be the AWS account ID.</p>', 'GetColumnStatisticsForPartitionRequest$CatalogId' => '<p>The ID of the Data Catalog where the partitions in question reside. If none is supplied, the AWS account ID is used by default.</p>', 'GetColumnStatisticsForTableRequest$CatalogId' => '<p>The ID of the Data Catalog where the partitions in question reside. If none is supplied, the AWS account ID is used by default.</p>', 'GetConnectionRequest$CatalogId' => '<p>The ID of the Data Catalog in which the connection resides. If none is provided, the AWS account ID is used by default.</p>', 'GetConnectionsRequest$CatalogId' => '<p>The ID of the Data Catalog in which the connections reside. If none is provided, the AWS account ID is used by default.</p>', 'GetDataCatalogEncryptionSettingsRequest$CatalogId' => '<p>The ID of the Data Catalog to retrieve the security configuration for. If none is provided, the AWS account ID is used by default.</p>', 'GetDatabaseRequest$CatalogId' => '<p>The ID of the Data Catalog in which the database resides. If none is provided, the AWS account ID is used by default.</p>', 'GetDatabasesRequest$CatalogId' => '<p>The ID of the Data Catalog from which to retrieve <code>Databases</code>. If none is provided, the AWS account ID is used by default.</p>', 'GetPartitionRequest$CatalogId' => '<p>The ID of the Data Catalog where the partition in question resides. If none is provided, the AWS account ID is used by default.</p>', 'GetPartitionsRequest$CatalogId' => '<p>The ID of the Data Catalog where the partitions in question reside. If none is provided, the AWS account ID is used by default.</p>', 'GetTableRequest$CatalogId' => '<p>The ID of the Data Catalog where the table resides. If none is provided, the AWS account ID is used by default.</p>', 'GetTableVersionRequest$CatalogId' => '<p>The ID of the Data Catalog where the tables reside. If none is provided, the AWS account ID is used by default.</p>', 'GetTableVersionsRequest$CatalogId' => '<p>The ID of the Data Catalog where the tables reside. If none is provided, the AWS account ID is used by default.</p>', 'GetTablesRequest$CatalogId' => '<p>The ID of the Data Catalog where the tables reside. If none is provided, the AWS account ID is used by default.</p>', 'GetUserDefinedFunctionRequest$CatalogId' => '<p>The ID of the Data Catalog where the function to be retrieved is located. If none is provided, the AWS account ID is used by default.</p>', 'GetUserDefinedFunctionsRequest$CatalogId' => '<p>The ID of the Data Catalog where the functions to be retrieved are located. If none is provided, the AWS account ID is used by default.</p>', 'ImportCatalogToGlueRequest$CatalogId' => '<p>The ID of the catalog to import. Currently, this should be the AWS account ID.</p>', 'Partition$CatalogId' => '<p>The ID of the Data Catalog in which the partition resides.</p>', 'PutDataCatalogEncryptionSettingsRequest$CatalogId' => '<p>The ID of the Data Catalog to set the security configuration for. If none is provided, the AWS account ID is used by default.</p>', 'SearchTablesRequest$CatalogId' => '<p>A unique identifier, consisting of <code> <i>account_id</i> </code>.</p>', 'Table$CatalogId' => '<p>The ID of the Data Catalog in which the table resides.</p>', 'TableIdentifier$CatalogId' => '<p>The ID of the Data Catalog in which the table resides.</p>', 'UpdateColumnStatisticsForPartitionRequest$CatalogId' => '<p>The ID of the Data Catalog where the partitions in question reside. If none is supplied, the AWS account ID is used by default.</p>', 'UpdateColumnStatisticsForTableRequest$CatalogId' => '<p>The ID of the Data Catalog where the partitions in question reside. If none is supplied, the AWS account ID is used by default.</p>', 'UpdateConnectionRequest$CatalogId' => '<p>The ID of the Data Catalog in which the connection resides. If none is provided, the AWS account ID is used by default.</p>', 'UpdateDatabaseRequest$CatalogId' => '<p>The ID of the Data Catalog in which the metadata database resides. If none is provided, the AWS account ID is used by default.</p>', 'UpdatePartitionRequest$CatalogId' => '<p>The ID of the Data Catalog where the partition to be updated resides. If none is provided, the AWS account ID is used by default.</p>', 'UpdateTableRequest$CatalogId' => '<p>The ID of the Data Catalog where the table resides. If none is provided, the AWS account ID is used by default.</p>', 'UpdateUserDefinedFunctionRequest$CatalogId' => '<p>The ID of the Data Catalog where the function to be updated is located. If none is provided, the AWS account ID is used by default.</p>', 'UserDefinedFunction$CatalogId' => '<p>The ID of the Data Catalog in which the function resides.</p>', ], ], 'CatalogImportStatus' => [ 'base' => '<p>A structure containing migration status information.</p>', 'refs' => [ 'GetCatalogImportStatusResponse$ImportStatus' => '<p>The status of the specified catalog migration.</p>', ], ], 'CatalogTablesList' => [ 'base' => NULL, 'refs' => [ 'CatalogTarget$Tables' => '<p>A list of the tables to be synchronized.</p>', ], ], 'CatalogTarget' => [ 'base' => '<p>Specifies an AWS Glue Data Catalog target.</p>', 'refs' => [ 'CatalogTargetList$member' => NULL, ], ], 'CatalogTargetList' => [ 'base' => NULL, 'refs' => [ 'CrawlerTargets$CatalogTargets' => '<p>Specifies AWS Glue Data Catalog targets.</p>', ], ], 'Classification' => [ 'base' => NULL, 'refs' => [ 'CreateGrokClassifierRequest$Classification' => '<p>An identifier of the data format that the classifier matches, such as Twitter, JSON, Omniture logs, Amazon CloudWatch Logs, and so on.</p>', 'CreateXMLClassifierRequest$Classification' => '<p>An identifier of the data format that the classifier matches.</p>', 'GrokClassifier$Classification' => '<p>An identifier of the data format that the classifier matches, such as Twitter, JSON, Omniture logs, and so on.</p>', 'UpdateGrokClassifierRequest$Classification' => '<p>An identifier of the data format that the classifier matches, such as Twitter, JSON, Omniture logs, Amazon CloudWatch Logs, and so on.</p>', 'UpdateXMLClassifierRequest$Classification' => '<p>An identifier of the data format that the classifier matches.</p>', 'XMLClassifier$Classification' => '<p>An identifier of the data format that the classifier matches.</p>', ], ], 'Classifier' => [ 'base' => '<p>Classifiers are triggered during a crawl task. A classifier checks whether a given file is in a format it can handle. If it is, the classifier creates a schema in the form of a <code>StructType</code> object that matches that data format.</p> <p>You can use the standard classifiers that AWS Glue provides, or you can write your own classifiers to best categorize your data sources and specify the appropriate schemas to use for them. A classifier can be a <code>grok</code> classifier, an <code>XML</code> classifier, a <code>JSON</code> classifier, or a custom <code>CSV</code> classifier, as specified in one of the fields in the <code>Classifier</code> object.</p>', 'refs' => [ 'ClassifierList$member' => NULL, 'GetClassifierResponse$Classifier' => '<p>The requested classifier.</p>', ], ], 'ClassifierList' => [ 'base' => NULL, 'refs' => [ 'GetClassifiersResponse$Classifiers' => '<p>The requested list of classifier objects.</p>', ], ], 'ClassifierNameList' => [ 'base' => NULL, 'refs' => [ 'Crawler$Classifiers' => '<p>A list of UTF-8 strings that specify the custom classifiers that are associated with the crawler.</p>', 'CreateCrawlerRequest$Classifiers' => '<p>A list of custom classifiers that the user has registered. By default, all built-in classifiers are included in a crawl, but these custom classifiers always override the default classifiers for a given classification.</p>', 'UpdateCrawlerRequest$Classifiers' => '<p>A list of custom classifiers that the user has registered. By default, all built-in classifiers are included in a crawl, but these custom classifiers always override the default classifiers for a given classification.</p>', ], ], 'CloudWatchEncryption' => [ 'base' => '<p>Specifies how Amazon CloudWatch data should be encrypted.</p>', 'refs' => [ 'EncryptionConfiguration$CloudWatchEncryption' => '<p>The encryption configuration for Amazon CloudWatch.</p>', ], ], 'CloudWatchEncryptionMode' => [ 'base' => NULL, 'refs' => [ 'CloudWatchEncryption$CloudWatchEncryptionMode' => '<p>The encryption mode to use for CloudWatch data.</p>', ], ], 'CodeGenArgName' => [ 'base' => NULL, 'refs' => [ 'CodeGenEdge$TargetParameter' => '<p>The target of the edge.</p>', 'CodeGenNodeArg$Name' => '<p>The name of the argument or property.</p>', ], ], 'CodeGenArgValue' => [ 'base' => NULL, 'refs' => [ 'CodeGenNodeArg$Value' => '<p>The value of the argument or property.</p>', ], ], 'CodeGenEdge' => [ 'base' => '<p>Represents a directional edge in a directed acyclic graph (DAG).</p>', 'refs' => [ 'DagEdges$member' => NULL, ], ], 'CodeGenIdentifier' => [ 'base' => NULL, 'refs' => [ 'CodeGenEdge$Source' => '<p>The ID of the node at which the edge starts.</p>', 'CodeGenEdge$Target' => '<p>The ID of the node at which the edge ends.</p>', 'CodeGenNode$Id' => '<p>A node identifier that is unique within the node\'s graph.</p>', ], ], 'CodeGenNode' => [ 'base' => '<p>Represents a node in a directed acyclic graph (DAG)</p>', 'refs' => [ 'DagNodes$member' => NULL, ], ], 'CodeGenNodeArg' => [ 'base' => '<p>An argument or property of a node.</p>', 'refs' => [ 'CodeGenNodeArgs$member' => NULL, ], ], 'CodeGenNodeArgs' => [ 'base' => NULL, 'refs' => [ 'CodeGenNode$Args' => '<p>Properties of the node, in the form of name-value pairs.</p>', 'Location$Jdbc' => '<p>A JDBC location.</p>', 'Location$S3' => '<p>An Amazon Simple Storage Service (Amazon S3) location.</p>', 'Location$DynamoDB' => '<p>An Amazon DynamoDB table location.</p>', ], ], 'CodeGenNodeType' => [ 'base' => NULL, 'refs' => [ 'CodeGenNode$NodeType' => '<p>The type of node that this is.</p>', ], ], 'Column' => [ 'base' => '<p>A column in a <code>Table</code>.</p>', 'refs' => [ 'ColumnList$member' => NULL, ], ], 'ColumnError' => [ 'base' => '<p>Defines a column containing error.</p>', 'refs' => [ 'ColumnErrors$member' => NULL, ], ], 'ColumnErrors' => [ 'base' => NULL, 'refs' => [ 'GetColumnStatisticsForPartitionResponse$Errors' => '<p>Error occurred during retrieving column statistics data.</p>', 'GetColumnStatisticsForTableResponse$Errors' => '<p>List of ColumnStatistics that failed to be retrieved.</p>', ], ], 'ColumnList' => [ 'base' => NULL, 'refs' => [ 'StorageDescriptor$Columns' => '<p>A list of the <code>Columns</code> in the table.</p>', 'Table$PartitionKeys' => '<p>A list of columns by which the table is partitioned. Only primitive types are supported as partition keys.</p> <p>When you create a table used by Amazon Athena, and you do not specify any <code>partitionKeys</code>, you must at least set the value of <code>partitionKeys</code> to an empty list. For example:</p> <p> <code>"PartitionKeys": []</code> </p>', 'TableInput$PartitionKeys' => '<p>A list of columns by which the table is partitioned. Only primitive types are supported as partition keys.</p> <p>When you create a table used by Amazon Athena, and you do not specify any <code>partitionKeys</code>, you must at least set the value of <code>partitionKeys</code> to an empty list. For example:</p> <p> <code>"PartitionKeys": []</code> </p>', ], ], 'ColumnNameString' => [ 'base' => NULL, 'refs' => [ 'FindMatchesParameters$PrimaryKeyColumnName' => '<p>The name of a column that uniquely identifies rows in the source table. Used to help identify matching records.</p>', 'SchemaColumn$Name' => '<p>The name of the column.</p>', ], ], 'ColumnStatistics' => [ 'base' => '<p>Defines a column statistics.</p>', 'refs' => [ 'ColumnStatisticsError$ColumnStatistics' => '<p>The ColumnStatistics of the column.</p>', 'ColumnStatisticsList$member' => NULL, 'UpdateColumnStatisticsList$member' => NULL, ], ], 'ColumnStatisticsData' => [ 'base' => '<p>Defines a column statistics data.</p>', 'refs' => [ 'ColumnStatistics$StatisticsData' => '<p>The statistics of the column.</p>', ], ], 'ColumnStatisticsError' => [ 'base' => '<p>Defines a column containing error.</p>', 'refs' => [ 'ColumnStatisticsErrors$member' => NULL, ], ], 'ColumnStatisticsErrors' => [ 'base' => NULL, 'refs' => [ 'UpdateColumnStatisticsForPartitionResponse$Errors' => '<p>Error occurred during updating column statistics data.</p>', 'UpdateColumnStatisticsForTableResponse$Errors' => '<p>List of ColumnStatisticsErrors.</p>', ], ], 'ColumnStatisticsList' => [ 'base' => NULL, 'refs' => [ 'GetColumnStatisticsForPartitionResponse$ColumnStatisticsList' => '<p>List of ColumnStatistics that failed to be retrieved.</p>', 'GetColumnStatisticsForTableResponse$ColumnStatisticsList' => '<p>List of ColumnStatistics that failed to be retrieved.</p>', ], ], 'ColumnStatisticsType' => [ 'base' => NULL, 'refs' => [ 'ColumnStatisticsData$Type' => '<p>The name of the column.</p>', ], ], 'ColumnTypeString' => [ 'base' => NULL, 'refs' => [ 'Column$Type' => '<p>The data type of the <code>Column</code>.</p>', 'SchemaColumn$DataType' => '<p>The type of data in the column.</p>', ], ], 'ColumnValueStringList' => [ 'base' => NULL, 'refs' => [ 'SkewedInfo$SkewedColumnValues' => '<p>A list of values that appear so frequently as to be considered skewed.</p>', ], ], 'ColumnValuesString' => [ 'base' => NULL, 'refs' => [ 'ColumnValueStringList$member' => NULL, 'LocationMap$key' => NULL, 'LocationMap$value' => NULL, ], ], 'CommentString' => [ 'base' => NULL, 'refs' => [ 'Column$Comment' => '<p>A free-form text comment.</p>', ], ], 'Comparator' => [ 'base' => NULL, 'refs' => [ 'PropertyPredicate$Comparator' => '<p>The comparator used to compare this property to others.</p>', ], ], 'ConcurrentModificationException' => [ 'base' => '<p>Two processes are trying to modify a resource simultaneously.</p>', 'refs' => [], ], 'ConcurrentRunsExceededException' => [ 'base' => '<p>Too many jobs are being run concurrently.</p>', 'refs' => [], ], 'Condition' => [ 'base' => '<p>Defines a condition under which a trigger fires.</p>', 'refs' => [ 'ConditionList$member' => NULL, ], ], 'ConditionCheckFailureException' => [ 'base' => '<p>A specified condition was not satisfied.</p>', 'refs' => [], ], 'ConditionList' => [ 'base' => NULL, 'refs' => [ 'Predicate$Conditions' => '<p>A list of the conditions that determine when the trigger will fire.</p>', ], ], 'ConfusionMatrix' => [ 'base' => '<p>The confusion matrix shows you what your transform is predicting accurately and what types of errors it is making.</p> <p>For more information, see <a href="https://en.wikipedia.org/wiki/Confusion_matrix">Confusion matrix</a> in Wikipedia.</p>', 'refs' => [ 'FindMatchesMetrics$ConfusionMatrix' => '<p>The confusion matrix shows you what your transform is predicting accurately and what types of errors it is making.</p> <p>For more information, see <a href="https://en.wikipedia.org/wiki/Confusion_matrix">Confusion matrix</a> in Wikipedia.</p>', ], ], 'Connection' => [ 'base' => '<p>Defines a connection to a data source.</p>', 'refs' => [ 'ConnectionList$member' => NULL, 'GetConnectionResponse$Connection' => '<p>The requested connection definition.</p>', ], ], 'ConnectionInput' => [ 'base' => '<p>A structure that is used to specify a connection to create or update.</p>', 'refs' => [ 'CreateConnectionRequest$ConnectionInput' => '<p>A <code>ConnectionInput</code> object defining the connection to create.</p>', 'UpdateConnectionRequest$ConnectionInput' => '<p>A <code>ConnectionInput</code> object that redefines the connection in question.</p>', ], ], 'ConnectionList' => [ 'base' => NULL, 'refs' => [ 'GetConnectionsResponse$ConnectionList' => '<p>A list of requested connection definitions.</p>', ], ], 'ConnectionName' => [ 'base' => NULL, 'refs' => [ 'JdbcTarget$ConnectionName' => '<p>The name of the connection to use to connect to the JDBC target.</p>', 'S3Target$ConnectionName' => '<p>The name of a connection which allows a job or crawler to access data in Amazon S3 within an Amazon Virtual Private Cloud environment (Amazon VPC).</p>', ], ], 'ConnectionPasswordEncryption' => [ 'base' => '<p>The data structure used by the Data Catalog to encrypt the password as part of <code>CreateConnection</code> or <code>UpdateConnection</code> and store it in the <code>ENCRYPTED_PASSWORD</code> field in the connection properties. You can enable catalog encryption or only password encryption.</p> <p>When a <code>CreationConnection</code> request arrives containing a password, the Data Catalog first encrypts the password using your AWS KMS key. It then encrypts the whole connection object again if catalog encryption is also enabled.</p> <p>This encryption requires that you set AWS KMS key permissions to enable or restrict access on the password key according to your security requirements. For example, you might want only administrators to have decrypt permission on the password key.</p>', 'refs' => [ 'DataCatalogEncryptionSettings$ConnectionPasswordEncryption' => '<p>When connection password protection is enabled, the Data Catalog uses a customer-provided key to encrypt the password as part of <code>CreateConnection</code> or <code>UpdateConnection</code> and store it in the <code>ENCRYPTED_PASSWORD</code> field in the connection properties. You can enable catalog encryption or only password encryption.</p>', ], ], 'ConnectionProperties' => [ 'base' => NULL, 'refs' => [ 'Connection$ConnectionProperties' => '<p>These key-value pairs define parameters for the connection:</p> <ul> <li> <p> <code>HOST</code> - The host URI: either the fully qualified domain name (FQDN) or the IPv4 address of the database host.</p> </li> <li> <p> <code>PORT</code> - The port number, between 1024 and 65535, of the port on which the database host is listening for database connections.</p> </li> <li> <p> <code>USER_NAME</code> - The name under which to log in to the database. The value string for <code>USER_NAME</code> is "<code>USERNAME</code>".</p> </li> <li> <p> <code>PASSWORD</code> - A password, if one is used, for the user name.</p> </li> <li> <p> <code>ENCRYPTED_PASSWORD</code> - When you enable connection password protection by setting <code>ConnectionPasswordEncryption</code> in the Data Catalog encryption settings, this field stores the encrypted password.</p> </li> <li> <p> <code>JDBC_DRIVER_JAR_URI</code> - The Amazon Simple Storage Service (Amazon S3) path of the JAR file that contains the JDBC driver to use.</p> </li> <li> <p> <code>JDBC_DRIVER_CLASS_NAME</code> - The class name of the JDBC driver to use.</p> </li> <li> <p> <code>JDBC_ENGINE</code> - The name of the JDBC engine to use.</p> </li> <li> <p> <code>JDBC_ENGINE_VERSION</code> - The version of the JDBC engine to use.</p> </li> <li> <p> <code>CONFIG_FILES</code> - (Reserved for future use.)</p> </li> <li> <p> <code>INSTANCE_ID</code> - The instance ID to use.</p> </li> <li> <p> <code>JDBC_CONNECTION_URL</code> - The URL for connecting to a JDBC data source.</p> </li> <li> <p> <code>JDBC_ENFORCE_SSL</code> - A Boolean string (true, false) specifying whether Secure Sockets Layer (SSL) with hostname matching is enforced for the JDBC connection on the client. The default is false.</p> </li> <li> <p> <code>CUSTOM_JDBC_CERT</code> - An Amazon S3 location specifying the customer\'s root certificate. AWS Glue uses this root certificate to validate the customer’s certificate when connecting to the customer database. AWS Glue only handles X.509 certificates. The certificate provided must be DER-encoded and supplied in Base64 encoding PEM format.</p> </li> <li> <p> <code>SKIP_CUSTOM_JDBC_CERT_VALIDATION</code> - By default, this is <code>false</code>. AWS Glue validates the Signature algorithm and Subject Public Key Algorithm for the customer certificate. The only permitted algorithms for the Signature algorithm are SHA256withRSA, SHA384withRSA or SHA512withRSA. For the Subject Public Key Algorithm, the key length must be at least 2048. You can set the value of this property to <code>true</code> to skip AWS Glue’s validation of the customer certificate.</p> </li> <li> <p> <code>CUSTOM_JDBC_CERT_STRING</code> - A custom JDBC certificate string which is used for domain match or distinguished name match to prevent a man-in-the-middle attack. In Oracle database, this is used as the <code>SSL_SERVER_CERT_DN</code>; in Microsoft SQL Server, this is used as the <code>hostNameInCertificate</code>.</p> </li> <li> <p> <code>CONNECTION_URL</code> - The URL for connecting to a general (non-JDBC) data source.</p> </li> <li> <p> <code>KAFKA_BOOTSTRAP_SERVERS</code> - A comma-separated list of host and port pairs that are the addresses of the Apache Kafka brokers in a Kafka cluster to which a Kafka client will connect to and bootstrap itself.</p> </li> <li> <p> <code>KAFKA_SSL_ENABLED</code> - Whether to enable or disable SSL on an Apache Kafka connection. Default value is "true".</p> </li> <li> <p> <code>KAFKA_CUSTOM_CERT</code> - The Amazon S3 URL for the private CA cert file (.pem format). The default is an empty string.</p> </li> <li> <p> <code>KAFKA_SKIP_CUSTOM_CERT_VALIDATION</code> - Whether to skip the validation of the CA cert file or not. AWS Glue validates for three algorithms: SHA256withRSA, SHA384withRSA and SHA512withRSA. Default value is "false".</p> </li> </ul>', 'ConnectionInput$ConnectionProperties' => '<p>These key-value pairs define parameters for the connection.</p>', ], ], 'ConnectionPropertyKey' => [ 'base' => NULL, 'refs' => [ 'ConnectionProperties$key' => NULL, ], ], 'ConnectionType' => [ 'base' => NULL, 'refs' => [ 'Connection$ConnectionType' => '<p>The type of the connection. Currently, SFTP is not supported.</p>', 'ConnectionInput$ConnectionType' => '<p>The type of the connection. Currently, these types are supported:</p> <ul> <li> <p> <code>JDBC</code> - Designates a connection to a database through Java Database Connectivity (JDBC).</p> </li> <li> <p> <code>KAFKA</code> - Designates a connection to an Apache Kafka streaming platform.</p> </li> <li> <p> <code>MONGODB</code> - Designates a connection to a MongoDB document database.</p> </li> <li> <p> <code>NETWORK</code> - Designates a network connection to a data source within an Amazon Virtual Private Cloud environment (Amazon VPC).</p> </li> </ul> <p>SFTP is not supported.</p>', 'GetConnectionsFilter$ConnectionType' => '<p>The type of connections to return. Currently, SFTP is not supported.</p>', ], ], 'ConnectionsList' => [ 'base' => '<p>Specifies the connections used by a job.</p>', 'refs' => [ 'CreateJobRequest$Connections' => '<p>The connections used for this job.</p>', 'Job$Connections' => '<p>The connections used for this job.</p>', 'JobUpdate$Connections' => '<p>The connections used for this job.</p>', ], ], 'Crawl' => [ 'base' => '<p>The details of a crawl in the workflow.</p>', 'refs' => [ 'CrawlList$member' => NULL, ], ], 'CrawlList' => [ 'base' => NULL, 'refs' => [ 'CrawlerNodeDetails$Crawls' => '<p>A list of crawls represented by the crawl node.</p>', ], ], 'CrawlState' => [ 'base' => NULL, 'refs' => [ 'Condition$CrawlState' => '<p>The state of the crawler to which this condition applies.</p>', 'Crawl$State' => '<p>The state of the crawler.</p>', ], ], 'Crawler' => [ 'base' => '<p>Specifies a crawler program that examines a data source and uses classifiers to try to determine its schema. If successful, the crawler records metadata concerning the data source in the AWS Glue Data Catalog.</p>', 'refs' => [ 'CrawlerList$member' => NULL, 'GetCrawlerResponse$Crawler' => '<p>The metadata for the specified crawler.</p>', ], ], 'CrawlerConfiguration' => [ 'base' => NULL, 'refs' => [ 'Crawler$Configuration' => '<p>Crawler configuration information. This versioned JSON string allows users to specify aspects of a crawler\'s behavior. For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html">Configuring a Crawler</a>.</p>', 'CreateCrawlerRequest$Configuration' => '<p>Crawler configuration information. This versioned JSON string allows users to specify aspects of a crawler\'s behavior. For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html">Configuring a Crawler</a>.</p>', 'UpdateCrawlerRequest$Configuration' => '<p>Crawler configuration information. This versioned JSON string allows users to specify aspects of a crawler\'s behavior. For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html">Configuring a Crawler</a>.</p>', ], ], 'CrawlerList' => [ 'base' => NULL, 'refs' => [ 'BatchGetCrawlersResponse$Crawlers' => '<p>A list of crawler definitions.</p>', 'GetCrawlersResponse$Crawlers' => '<p>A list of crawler metadata.</p>', ], ], 'CrawlerMetrics' => [ 'base' => '<p>Metrics for a specified crawler.</p>', 'refs' => [ 'CrawlerMetricsList$member' => NULL, ], ], 'CrawlerMetricsList' => [ 'base' => NULL, 'refs' => [ 'GetCrawlerMetricsResponse$CrawlerMetricsList' => '<p>A list of metrics for the specified crawler.</p>', ], ], 'CrawlerNameList' => [ 'base' => NULL, 'refs' => [ 'BatchGetCrawlersRequest$CrawlerNames' => '<p>A list of crawler names, which might be the names returned from the <code>ListCrawlers</code> operation.</p>', 'BatchGetCrawlersResponse$CrawlersNotFound' => '<p>A list of names of crawlers that were not found.</p>', 'GetCrawlerMetricsRequest$CrawlerNameList' => '<p>A list of the names of crawlers about which to retrieve metrics.</p>', 'ListCrawlersResponse$CrawlerNames' => '<p>The names of all crawlers in the account, or the crawlers with the specified tags.</p>', ], ], 'CrawlerNodeDetails' => [ 'base' => '<p>The details of a Crawler node present in the workflow.</p>', 'refs' => [ 'Node$CrawlerDetails' => '<p>Details of the crawler when the node represents a crawler.</p>', ], ], 'CrawlerNotRunningException' => [ 'base' => '<p>The specified crawler is not running.</p>', 'refs' => [], ], 'CrawlerRunningException' => [ 'base' => '<p>The operation cannot be performed because the crawler is already running.</p>', 'refs' => [], ], 'CrawlerSecurityConfiguration' => [ 'base' => NULL, 'refs' => [ 'Crawler$CrawlerSecurityConfiguration' => '<p>The name of the <code>SecurityConfiguration</code> structure to be used by this crawler.</p>', 'CreateCrawlerRequest$CrawlerSecurityConfiguration' => '<p>The name of the <code>SecurityConfiguration</code> structure to be used by this crawler.</p>', 'UpdateCrawlerRequest$CrawlerSecurityConfiguration' => '<p>The name of the <code>SecurityConfiguration</code> structure to be used by this crawler.</p>', ], ], 'CrawlerState' => [ 'base' => NULL, 'refs' => [ 'Crawler$State' => '<p>Indicates whether the crawler is running, or whether a run is pending.</p>', ], ], 'CrawlerStoppingException' => [ 'base' => '<p>The specified crawler is stopping.</p>', 'refs' => [], ], 'CrawlerTargets' => [ 'base' => '<p>Specifies data stores to crawl.</p>', 'refs' => [ 'Crawler$Targets' => '<p>A collection of targets to crawl.</p>', 'CreateCrawlerRequest$Targets' => '<p>A list of collection of targets to crawl.</p>', 'UpdateCrawlerRequest$Targets' => '<p>A list of targets to crawl.</p>', ], ], 'CreateClassifierRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateClassifierResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateConnectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateCrawlerRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCrawlerResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateCsvClassifierRequest' => [ 'base' => '<p>Specifies a custom CSV classifier for <code>CreateClassifier</code> to create.</p>', 'refs' => [ 'CreateClassifierRequest$CsvClassifier' => '<p>A <code>CsvClassifier</code> object specifying the classifier to create.</p>', ], ], 'CreateDatabaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatabaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDevEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDevEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateGrokClassifierRequest' => [ 'base' => '<p>Specifies a <code>grok</code> classifier for <code>CreateClassifier</code> to create.</p>', 'refs' => [ 'CreateClassifierRequest$GrokClassifier' => '<p>A <code>GrokClassifier</code> object specifying the classifier to create.</p>', ], ], 'CreateJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateJsonClassifierRequest' => [ 'base' => '<p>Specifies a JSON classifier for <code>CreateClassifier</code> to create.</p>', 'refs' => [ 'CreateClassifierRequest$JsonClassifier' => '<p>A <code>JsonClassifier</code> object specifying the classifier to create.</p>', ], ], 'CreateMLTransformRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMLTransformResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePartitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePartitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateScriptRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateScriptResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSecurityConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSecurityConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTableResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTriggerRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTriggerResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserDefinedFunctionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserDefinedFunctionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkflowRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkflowResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateXMLClassifierRequest' => [ 'base' => '<p>Specifies an XML classifier for <code>CreateClassifier</code> to create.</p>', 'refs' => [ 'CreateClassifierRequest$XMLClassifier' => '<p>An <code>XMLClassifier</code> object specifying the classifier to create.</p>', ], ], 'CronExpression' => [ 'base' => NULL, 'refs' => [ 'CreateCrawlerRequest$Schedule' => '<p>A <code>cron</code> expression used to specify the schedule (see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules for Jobs and Crawlers</a>. For example, to run something every day at 12:15 UTC, you would specify: <code>cron(15 12 * * ? *)</code>.</p>', 'Schedule$ScheduleExpression' => '<p>A <code>cron</code> expression used to specify the schedule (see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules for Jobs and Crawlers</a>. For example, to run something every day at 12:15 UTC, you would specify: <code>cron(15 12 * * ? *)</code>.</p>', 'UpdateCrawlerRequest$Schedule' => '<p>A <code>cron</code> expression used to specify the schedule (see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules for Jobs and Crawlers</a>. For example, to run something every day at 12:15 UTC, you would specify: <code>cron(15 12 * * ? *)</code>.</p>', 'UpdateCrawlerScheduleRequest$Schedule' => '<p>The updated <code>cron</code> expression used to specify the schedule (see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules for Jobs and Crawlers</a>. For example, to run something every day at 12:15 UTC, you would specify: <code>cron(15 12 * * ? *)</code>.</p>', ], ], 'CsvClassifier' => [ 'base' => '<p>A classifier for custom <code>CSV</code> content.</p>', 'refs' => [ 'Classifier$CsvClassifier' => '<p>A classifier for comma-separated values (CSV).</p>', ], ], 'CsvColumnDelimiter' => [ 'base' => NULL, 'refs' => [ 'CreateCsvClassifierRequest$Delimiter' => '<p>A custom symbol to denote what separates each column entry in the row.</p>', 'CsvClassifier$Delimiter' => '<p>A custom symbol to denote what separates each column entry in the row.</p>', 'UpdateCsvClassifierRequest$Delimiter' => '<p>A custom symbol to denote what separates each column entry in the row.</p>', ], ], 'CsvHeader' => [ 'base' => NULL, 'refs' => [ 'CreateCsvClassifierRequest$Header' => '<p>A list of strings representing column names.</p>', 'CsvClassifier$Header' => '<p>A list of strings representing column names.</p>', 'UpdateCsvClassifierRequest$Header' => '<p>A list of strings representing column names.</p>', ], ], 'CsvHeaderOption' => [ 'base' => NULL, 'refs' => [ 'CreateCsvClassifierRequest$ContainsHeader' => '<p>Indicates whether the CSV file contains a header.</p>', 'CsvClassifier$ContainsHeader' => '<p>Indicates whether the CSV file contains a header.</p>', 'UpdateCsvClassifierRequest$ContainsHeader' => '<p>Indicates whether the CSV file contains a header.</p>', ], ], 'CsvQuoteSymbol' => [ 'base' => NULL, 'refs' => [ 'CreateCsvClassifierRequest$QuoteSymbol' => '<p>A custom symbol to denote what combines content into a single column value. Must be different from the column delimiter.</p>', 'CsvClassifier$QuoteSymbol' => '<p>A custom symbol to denote what combines content into a single column value. It must be different from the column delimiter.</p>', 'UpdateCsvClassifierRequest$QuoteSymbol' => '<p>A custom symbol to denote what combines content into a single column value. It must be different from the column delimiter.</p>', ], ], 'CustomPatterns' => [ 'base' => NULL, 'refs' => [ 'CreateGrokClassifierRequest$CustomPatterns' => '<p>Optional custom grok patterns used by this classifier.</p>', 'GrokClassifier$CustomPatterns' => '<p>Optional custom grok patterns defined by this classifier. For more information, see custom patterns in <a href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html">Writing Custom Classifiers</a>.</p>', 'UpdateGrokClassifierRequest$CustomPatterns' => '<p>Optional custom grok patterns used by this classifier.</p>', ], ], 'DagEdges' => [ 'base' => NULL, 'refs' => [ 'CreateScriptRequest$DagEdges' => '<p>A list of the edges in the DAG.</p>', 'GetDataflowGraphResponse$DagEdges' => '<p>A list of the edges in the resulting DAG.</p>', ], ], 'DagNodes' => [ 'base' => NULL, 'refs' => [ 'CreateScriptRequest$DagNodes' => '<p>A list of the nodes in the DAG.</p>', 'GetDataflowGraphResponse$DagNodes' => '<p>A list of the nodes in the resulting DAG.</p>', ], ], 'DataCatalogEncryptionSettings' => [ 'base' => '<p>Contains configuration information for maintaining Data Catalog security.</p>', 'refs' => [ 'GetDataCatalogEncryptionSettingsResponse$DataCatalogEncryptionSettings' => '<p>The requested security configuration.</p>', 'PutDataCatalogEncryptionSettingsRequest$DataCatalogEncryptionSettings' => '<p>The security configuration to set.</p>', ], ], 'DataLakePrincipal' => [ 'base' => '<p>The AWS Lake Formation principal.</p>', 'refs' => [ 'PrincipalPermissions$Principal' => '<p>The principal who is granted permissions.</p>', ], ], 'DataLakePrincipalString' => [ 'base' => NULL, 'refs' => [ 'DataLakePrincipal$DataLakePrincipalIdentifier' => '<p>An identifier for the AWS Lake Formation principal.</p>', ], ], 'Database' => [ 'base' => '<p>The <code>Database</code> object represents a logical grouping of tables that might reside in a Hive metastore or an RDBMS.</p>', 'refs' => [ 'DatabaseList$member' => NULL, 'GetDatabaseResponse$Database' => '<p>The definition of the specified database in the Data Catalog.</p>', ], ], 'DatabaseIdentifier' => [ 'base' => '<p>A structure that describes a target database for resource linking.</p>', 'refs' => [ 'Database$TargetDatabase' => '<p>A <code>DatabaseIdentifier</code> structure that describes a target database for resource linking.</p>', 'DatabaseInput$TargetDatabase' => '<p>A <code>DatabaseIdentifier</code> structure that describes a target database for resource linking.</p>', ], ], 'DatabaseInput' => [ 'base' => '<p>The structure used to create or update a database.</p>', 'refs' => [ 'CreateDatabaseRequest$DatabaseInput' => '<p>The metadata for the database.</p>', 'UpdateDatabaseRequest$DatabaseInput' => '<p>A <code>DatabaseInput</code> object specifying the new definition of the metadata database in the catalog.</p>', ], ], 'DatabaseList' => [ 'base' => NULL, 'refs' => [ 'GetDatabasesResponse$DatabaseList' => '<p>A list of <code>Database</code> objects from the specified catalog.</p>', ], ], 'DatabaseName' => [ 'base' => NULL, 'refs' => [ 'Crawler$DatabaseName' => '<p>The name of the database in which the crawler\'s output is stored.</p>', 'CreateCrawlerRequest$DatabaseName' => '<p>The AWS Glue database where results are written, such as: <code>arn:aws:daylight:us-east-1::database/sometable/*</code>.</p>', 'UpdateCrawlerRequest$DatabaseName' => '<p>The AWS Glue database where results are stored, such as: <code>arn:aws:daylight:us-east-1::database/sometable/*</code>.</p>', ], ], 'DateColumnStatisticsData' => [ 'base' => '<p>Defines a date column statistics data.</p>', 'refs' => [ 'ColumnStatisticsData$DateColumnStatisticsData' => '<p>Date Column Statistics Data.</p>', ], ], 'DecimalColumnStatisticsData' => [ 'base' => '<p>Defines a decimal column statistics data.</p>', 'refs' => [ 'ColumnStatisticsData$DecimalColumnStatisticsData' => '<p>Decimal Column Statistics Data.</p>', ], ], 'DecimalNumber' => [ 'base' => '<p>Contains a numeric value in decimal format.</p>', 'refs' => [ 'DecimalColumnStatisticsData$MinimumValue' => '<p>Minimum value of the column.</p>', 'DecimalColumnStatisticsData$MaximumValue' => '<p>Maximum value of the column.</p>', ], ], 'DeleteBehavior' => [ 'base' => NULL, 'refs' => [ 'SchemaChangePolicy$DeleteBehavior' => '<p>The deletion behavior when the crawler finds a deleted object.</p>', ], ], 'DeleteClassifierRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteClassifierResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteColumnStatisticsForPartitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteColumnStatisticsForPartitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteColumnStatisticsForTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteColumnStatisticsForTableResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConnectionNameList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteConnectionRequest$ConnectionNameList' => '<p>A list of names of the connections to delete.</p>', ], ], 'DeleteConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConnectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCrawlerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCrawlerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDatabaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDatabaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDevEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDevEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMLTransformRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMLTransformResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeletePartitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePartitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSecurityConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSecurityConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTableResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTableVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTableVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTriggerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTriggerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserDefinedFunctionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserDefinedFunctionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkflowRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkflowResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescriptionString' => [ 'base' => NULL, 'refs' => [ 'Connection$Description' => '<p>The description of the connection.</p>', 'ConnectionInput$Description' => '<p>The description of the connection.</p>', 'Crawl$ErrorMessage' => '<p>The error message associated with the crawl.</p>', 'Crawler$Description' => '<p>A description of the crawler.</p>', 'CreateCrawlerRequest$Description' => '<p>A description of the new crawler.</p>', 'CreateJobRequest$Description' => '<p>Description of the job being defined.</p>', 'CreateMLTransformRequest$Description' => '<p>A description of the machine learning transform that is being defined. The default is an empty string.</p>', 'CreateTriggerRequest$Description' => '<p>A description of the new trigger.</p>', 'Database$Description' => '<p>A description of the database.</p>', 'DatabaseInput$Description' => '<p>A description of the database.</p>', 'ErrorDetail$ErrorMessage' => '<p>A message describing the error.</p>', 'GetMLTransformResponse$Description' => '<p>A description of the transform.</p>', 'Job$Description' => '<p>A description of the job.</p>', 'JobUpdate$Description' => '<p>Description of the job being defined.</p>', 'LastCrawlInfo$ErrorMessage' => '<p>If an error occurred, the error information about the last crawl.</p>', 'MLTransform$Description' => '<p>A user-defined, long-form description text for the machine learning transform. Descriptions are not guaranteed to be unique and can be changed at any time.</p>', 'Table$Description' => '<p>A description of the table.</p>', 'TableInput$Description' => '<p>A description of the table.</p>', 'Trigger$Description' => '<p>A description of this trigger.</p>', 'TriggerUpdate$Description' => '<p>A description of this trigger.</p>', 'UpdateMLTransformRequest$Description' => '<p>A description of the transform. The default is an empty string.</p>', ], ], 'DescriptionStringRemovable' => [ 'base' => NULL, 'refs' => [ 'UpdateCrawlerRequest$Description' => '<p>A description of the new crawler.</p>', ], ], 'DevEndpoint' => [ 'base' => '<p>A development endpoint where a developer can remotely debug extract, transform, and load (ETL) scripts.</p>', 'refs' => [ 'DevEndpointList$member' => NULL, 'GetDevEndpointResponse$DevEndpoint' => '<p>A <code>DevEndpoint</code> definition.</p>', ], ], 'DevEndpointCustomLibraries' => [ 'base' => '<p>Custom libraries to be loaded into a development endpoint.</p>', 'refs' => [ 'UpdateDevEndpointRequest$CustomLibraries' => '<p>Custom Python or Java libraries to be loaded in the <code>DevEndpoint</code>.</p>', ], ], 'DevEndpointList' => [ 'base' => NULL, 'refs' => [ 'BatchGetDevEndpointsResponse$DevEndpoints' => '<p>A list of <code>DevEndpoint</code> definitions.</p>', 'GetDevEndpointsResponse$DevEndpoints' => '<p>A list of <code>DevEndpoint</code> definitions.</p>', ], ], 'DevEndpointNameList' => [ 'base' => NULL, 'refs' => [ 'ListDevEndpointsResponse$DevEndpointNames' => '<p>The names of all the <code>DevEndpoint</code>s in the account, or the <code>DevEndpoint</code>s with the specified tags.</p>', ], ], 'DevEndpointNames' => [ 'base' => NULL, 'refs' => [ 'BatchGetDevEndpointsRequest$DevEndpointNames' => '<p>The list of <code>DevEndpoint</code> names, which might be the names returned from the <code>ListDevEndpoint</code> operation.</p>', 'BatchGetDevEndpointsResponse$DevEndpointsNotFound' => '<p>A list of <code>DevEndpoints</code> not found.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'DoubleColumnStatisticsData$MinimumValue' => '<p>Minimum value of the column.</p>', 'DoubleColumnStatisticsData$MaximumValue' => '<p>Maximum value of the column.</p>', ], ], 'DoubleColumnStatisticsData' => [ 'base' => '<p>Defines a double column statistics data.</p>', 'refs' => [ 'ColumnStatisticsData$DoubleColumnStatisticsData' => '<p>Double Column Statistics Data.</p>', ], ], 'DynamoDBTarget' => [ 'base' => '<p>Specifies an Amazon DynamoDB table to crawl.</p>', 'refs' => [ 'DynamoDBTargetList$member' => NULL, ], ], 'DynamoDBTargetList' => [ 'base' => NULL, 'refs' => [ 'CrawlerTargets$DynamoDBTargets' => '<p>Specifies Amazon DynamoDB targets.</p>', ], ], 'Edge' => [ 'base' => '<p>An edge represents a directed connection between two AWS Glue components that are part of the workflow the edge belongs to.</p>', 'refs' => [ 'EdgeList$member' => NULL, ], ], 'EdgeList' => [ 'base' => NULL, 'refs' => [ 'WorkflowGraph$Edges' => '<p>A list of all the directed connections between the nodes belonging to the workflow.</p>', ], ], 'EnableHybridValues' => [ 'base' => NULL, 'refs' => [ 'PutResourcePolicyRequest$EnableHybrid' => '<p>Allows you to specify if you want to use both resource-level and account/catalog-level resource policies. A resource-level policy is a policy attached to an individual resource such as a database or a table.</p> <p>The default value of <code>NO</code> indicates that resource-level policies cannot co-exist with an account-level policy. A value of <code>YES</code> means the use of both resource-level and account/catalog-level resource policies is allowed.</p>', ], ], 'EncryptionAtRest' => [ 'base' => '<p>Specifies the encryption-at-rest configuration for the Data Catalog.</p>', 'refs' => [ 'DataCatalogEncryptionSettings$EncryptionAtRest' => '<p>Specifies the encryption-at-rest configuration for the Data Catalog.</p>', ], ], 'EncryptionConfiguration' => [ 'base' => '<p>Specifies an encryption configuration.</p>', 'refs' => [ 'CreateSecurityConfigurationRequest$EncryptionConfiguration' => '<p>The encryption configuration for the new security configuration.</p>', 'SecurityConfiguration$EncryptionConfiguration' => '<p>The encryption configuration associated with this security configuration.</p>', ], ], 'EntityNotFoundException' => [ 'base' => '<p>A specified entity does not exist</p>', 'refs' => [], ], 'ErrorByName' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteConnectionResponse$Errors' => '<p>A map of the names of connections that were not successfully deleted to error details.</p>', ], ], 'ErrorDetail' => [ 'base' => '<p>Contains details about an error.</p>', 'refs' => [ 'BatchStopJobRunError$ErrorDetail' => '<p>Specifies details about the error that was encountered.</p>', 'ColumnError$Error' => '<p>The error message occurred during operation.</p>', 'ColumnStatisticsError$Error' => '<p>The error message occurred during operation.</p>', 'ErrorByName$value' => NULL, 'PartitionError$ErrorDetail' => '<p>The details about the partition error.</p>', 'TableError$ErrorDetail' => '<p>The details about the error.</p>', 'TableVersionError$ErrorDetail' => '<p>The details about the error.</p>', ], ], 'ErrorString' => [ 'base' => NULL, 'refs' => [ 'JobRun$ErrorMessage' => '<p>An error message associated with this job run.</p>', ], ], 'EvaluationMetrics' => [ 'base' => '<p>Evaluation metrics provide an estimate of the quality of your machine learning transform.</p>', 'refs' => [ 'GetMLTransformResponse$EvaluationMetrics' => '<p>The latest evaluation metrics.</p>', 'MLTransform$EvaluationMetrics' => '<p>An <code>EvaluationMetrics</code> object. Evaluation metrics provide an estimate of the quality of your machine learning transform.</p>', ], ], 'ExecutionProperty' => [ 'base' => '<p>An execution property of a job.</p>', 'refs' => [ 'CreateJobRequest$ExecutionProperty' => '<p>An <code>ExecutionProperty</code> specifying the maximum number of concurrent runs allowed for this job.</p>', 'Job$ExecutionProperty' => '<p>An <code>ExecutionProperty</code> specifying the maximum number of concurrent runs allowed for this job.</p>', 'JobUpdate$ExecutionProperty' => '<p>An <code>ExecutionProperty</code> specifying the maximum number of concurrent runs allowed for this job.</p>', ], ], 'ExecutionTime' => [ 'base' => NULL, 'refs' => [ 'GetMLTaskRunResponse$ExecutionTime' => '<p>The amount of time (in seconds) that the task run consumed resources.</p>', 'JobRun$ExecutionTime' => '<p>The amount of time (in seconds) that the job run consumed resources.</p>', 'TaskRun$ExecutionTime' => '<p>The amount of time (in seconds) that the task run consumed resources.</p>', ], ], 'ExistCondition' => [ 'base' => NULL, 'refs' => [ 'PutResourcePolicyRequest$PolicyExistsCondition' => '<p>A value of <code>MUST_EXIST</code> is used to update a policy. A value of <code>NOT_EXIST</code> is used to create a new policy. If a value of <code>NONE</code> or a null value is used, the call will not depend on the existence of a policy.</p>', ], ], 'ExportLabelsTaskRunProperties' => [ 'base' => '<p>Specifies configuration properties for an exporting labels task run.</p>', 'refs' => [ 'TaskRunProperties$ExportLabelsTaskRunProperties' => '<p>The configuration properties for an exporting labels task run.</p>', ], ], 'FieldType' => [ 'base' => NULL, 'refs' => [ 'MappingEntry$SourceType' => '<p>The source type.</p>', 'MappingEntry$TargetType' => '<p>The target type.</p>', ], ], 'FilterString' => [ 'base' => NULL, 'refs' => [ 'GetTablesRequest$Expression' => '<p>A regular expression pattern. If present, only those tables whose names match the pattern are returned.</p>', ], ], 'FindMatchesMetrics' => [ 'base' => '<p>The evaluation metrics for the find matches algorithm. The quality of your machine learning transform is measured by getting your transform to predict some matches and comparing the results to known matches from the same dataset. The quality metrics are based on a subset of your data, so they are not precise.</p>', 'refs' => [ 'EvaluationMetrics$FindMatchesMetrics' => '<p>The evaluation metrics for the find matches algorithm.</p>', ], ], 'FindMatchesParameters' => [ 'base' => '<p>The parameters to configure the find matches transform.</p>', 'refs' => [ 'TransformParameters$FindMatchesParameters' => '<p>The parameters for the find matches algorithm.</p>', ], ], 'FindMatchesTaskRunProperties' => [ 'base' => '<p>Specifies configuration properties for a Find Matches task run.</p>', 'refs' => [ 'TaskRunProperties$FindMatchesTaskRunProperties' => '<p>The configuration properties for a find matches task run.</p>', ], ], 'FormatString' => [ 'base' => NULL, 'refs' => [ 'StorageDescriptor$InputFormat' => '<p>The input format: <code>SequenceFileInputFormat</code> (binary), or <code>TextInputFormat</code>, or a custom format.</p>', 'StorageDescriptor$OutputFormat' => '<p>The output format: <code>SequenceFileOutputFormat</code> (binary), or <code>IgnoreKeyTextOutputFormat</code>, or a custom format.</p>', ], ], 'GenericBoundedDouble' => [ 'base' => NULL, 'refs' => [ 'FindMatchesMetrics$AreaUnderPRCurve' => '<p>The area under the precision/recall curve (AUPRC) is a single number measuring the overall quality of the transform, that is independent of the choice made for precision vs. recall. Higher values indicate that you have a more attractive precision vs. recall tradeoff.</p> <p>For more information, see <a href="https://en.wikipedia.org/wiki/Precision_and_recall">Precision and recall</a> in Wikipedia.</p>', 'FindMatchesMetrics$Precision' => '<p>The precision metric indicates when often your transform is correct when it predicts a match. Specifically, it measures how well the transform finds true positives from the total true positives possible.</p> <p>For more information, see <a href="https://en.wikipedia.org/wiki/Precision_and_recall">Precision and recall</a> in Wikipedia.</p>', 'FindMatchesMetrics$Recall' => '<p>The recall metric indicates that for an actual match, how often your transform predicts the match. Specifically, it measures how well the transform finds true positives from the total records in the source data.</p> <p>For more information, see <a href="https://en.wikipedia.org/wiki/Precision_and_recall">Precision and recall</a> in Wikipedia.</p>', 'FindMatchesMetrics$F1' => '<p>The maximum F1 metric indicates the transform\'s accuracy between 0 and 1, where 1 is the best accuracy.</p> <p>For more information, see <a href="https://en.wikipedia.org/wiki/F1_score">F1 score</a> in Wikipedia.</p>', 'FindMatchesParameters$PrecisionRecallTradeoff' => '<p>The value selected when tuning your transform for a balance between precision and recall. A value of 0.5 means no preference; a value of 1.0 means a bias purely for precision, and a value of 0.0 means a bias for recall. Because this is a tradeoff, choosing values close to 1.0 means very low recall, and choosing values close to 0.0 results in very low precision.</p> <p>The precision metric indicates how often your model is correct when it predicts a match. </p> <p>The recall metric indicates that for an actual match, how often your model predicts the match.</p>', 'FindMatchesParameters$AccuracyCostTradeoff' => '<p>The value that is selected when tuning your transform for a balance between accuracy and cost. A value of 0.5 means that the system balances accuracy and cost concerns. A value of 1.0 means a bias purely for accuracy, which typically results in a higher cost, sometimes substantially higher. A value of 0.0 means a bias purely for cost, which results in a less accurate <code>FindMatches</code> transform, sometimes with unacceptable accuracy.</p> <p>Accuracy measures how well the transform finds true positives and true negatives. Increasing accuracy requires more machine resources and cost. But it also results in increased recall. </p> <p>Cost measures how many compute resources, and thus money, are consumed to run the transform.</p>', ], ], 'GenericMap' => [ 'base' => NULL, 'refs' => [ 'Action$Arguments' => '<p>The job arguments used when this trigger fires. For this job run, they replace the default arguments set in the job definition itself.</p> <p>You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes.</p> <p>For information about how to specify and consume your own Job arguments, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling AWS Glue APIs in Python</a> topic in the developer guide.</p> <p>For information about the key-value pairs that AWS Glue consumes to set up your job, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special Parameters Used by AWS Glue</a> topic in the developer guide.</p>', 'CreateJobRequest$DefaultArguments' => '<p>The default arguments for this job.</p> <p>You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes.</p> <p>For information about how to specify and consume your own Job arguments, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling AWS Glue APIs in Python</a> topic in the developer guide.</p> <p>For information about the key-value pairs that AWS Glue consumes to set up your job, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special Parameters Used by AWS Glue</a> topic in the developer guide.</p>', 'CreateJobRequest$NonOverridableArguments' => '<p>Non-overridable arguments for this job, specified as name-value pairs.</p>', 'Job$DefaultArguments' => '<p>The default arguments for this job, specified as name-value pairs.</p> <p>You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes.</p> <p>For information about how to specify and consume your own Job arguments, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling AWS Glue APIs in Python</a> topic in the developer guide.</p> <p>For information about the key-value pairs that AWS Glue consumes to set up your job, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special Parameters Used by AWS Glue</a> topic in the developer guide.</p>', 'Job$NonOverridableArguments' => '<p>Non-overridable arguments for this job, specified as name-value pairs.</p>', 'JobRun$Arguments' => '<p>The job arguments associated with this run. For this job run, they replace the default arguments set in the job definition itself.</p> <p>You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes.</p> <p>For information about how to specify and consume your own job arguments, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling AWS Glue APIs in Python</a> topic in the developer guide.</p> <p>For information about the key-value pairs that AWS Glue consumes to set up your job, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special Parameters Used by AWS Glue</a> topic in the developer guide.</p>', 'JobUpdate$DefaultArguments' => '<p>The default arguments for this job.</p> <p>You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes.</p> <p>For information about how to specify and consume your own Job arguments, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling AWS Glue APIs in Python</a> topic in the developer guide.</p> <p>For information about the key-value pairs that AWS Glue consumes to set up your job, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special Parameters Used by AWS Glue</a> topic in the developer guide.</p>', 'JobUpdate$NonOverridableArguments' => '<p>Non-overridable arguments for this job, specified as name-value pairs.</p>', 'StartJobRunRequest$Arguments' => '<p>The job arguments specifically for this run. For this job run, they replace the default arguments set in the job definition itself.</p> <p>You can specify arguments here that your own job-execution script consumes, as well as arguments that AWS Glue itself consumes.</p> <p>For information about how to specify and consume your own Job arguments, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html">Calling AWS Glue APIs in Python</a> topic in the developer guide.</p> <p>For information about the key-value pairs that AWS Glue consumes to set up your job, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">Special Parameters Used by AWS Glue</a> topic in the developer guide.</p>', ], ], 'GenericString' => [ 'base' => NULL, 'refs' => [ 'CreateDevEndpointRequest$EndpointName' => '<p>The name to be assigned to the new <code>DevEndpoint</code>.</p>', 'CreateDevEndpointRequest$SubnetId' => '<p>The subnet ID for the new <code>DevEndpoint</code> to use.</p>', 'CreateDevEndpointRequest$PublicKey' => '<p>The public key to be used by this <code>DevEndpoint</code> for authentication. This attribute is provided for backward compatibility because the recommended attribute to use is public keys.</p>', 'CreateDevEndpointRequest$ExtraPythonLibsS3Path' => '<p>The paths to one or more Python libraries in an Amazon S3 bucket that should be loaded in your <code>DevEndpoint</code>. Multiple values must be complete paths separated by a comma.</p> <note> <p>You can only use pure Python libraries with a <code>DevEndpoint</code>. Libraries that rely on C extensions, such as the <a href="http://pandas.pydata.org/">pandas</a> Python data analysis library, are not yet supported.</p> </note>', 'CreateDevEndpointRequest$ExtraJarsS3Path' => '<p>The path to one or more Java <code>.jar</code> files in an S3 bucket that should be loaded in your <code>DevEndpoint</code>.</p>', 'CreateDevEndpointResponse$EndpointName' => '<p>The name assigned to the new <code>DevEndpoint</code>.</p>', 'CreateDevEndpointResponse$Status' => '<p>The current status of the new <code>DevEndpoint</code>.</p>', 'CreateDevEndpointResponse$SubnetId' => '<p>The subnet ID assigned to the new <code>DevEndpoint</code>.</p>', 'CreateDevEndpointResponse$YarnEndpointAddress' => '<p>The address of the YARN endpoint used by this <code>DevEndpoint</code>.</p>', 'CreateDevEndpointResponse$AvailabilityZone' => '<p>The AWS Availability Zone where this <code>DevEndpoint</code> is located.</p>', 'CreateDevEndpointResponse$VpcId' => '<p>The ID of the virtual private cloud (VPC) used by this <code>DevEndpoint</code>.</p>', 'CreateDevEndpointResponse$ExtraPythonLibsS3Path' => '<p>The paths to one or more Python libraries in an S3 bucket that will be loaded in your <code>DevEndpoint</code>.</p>', 'CreateDevEndpointResponse$ExtraJarsS3Path' => '<p>Path to one or more Java <code>.jar</code> files in an S3 bucket that will be loaded in your <code>DevEndpoint</code>.</p>', 'CreateDevEndpointResponse$FailureReason' => '<p>The reason for a current failure in this <code>DevEndpoint</code>.</p>', 'CreateTriggerRequest$Schedule' => '<p>A <code>cron</code> expression used to specify the schedule (see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules for Jobs and Crawlers</a>. For example, to run something every day at 12:15 UTC, you would specify: <code>cron(15 12 * * ? *)</code>.</p> <p>This field is required when the trigger type is SCHEDULED.</p>', 'CreateWorkflowRequest$Description' => '<p>A description of the workflow.</p>', 'DeleteDevEndpointRequest$EndpointName' => '<p>The name of the <code>DevEndpoint</code>.</p>', 'DevEndpoint$EndpointName' => '<p>The name of the <code>DevEndpoint</code>.</p>', 'DevEndpoint$SubnetId' => '<p>The subnet ID for this <code>DevEndpoint</code>.</p>', 'DevEndpoint$YarnEndpointAddress' => '<p>The YARN endpoint address used by this <code>DevEndpoint</code>.</p>', 'DevEndpoint$PrivateAddress' => '<p>A private IP address to access the <code>DevEndpoint</code> within a VPC if the <code>DevEndpoint</code> is created within one. The <code>PrivateAddress</code> field is present only when you create the <code>DevEndpoint</code> within your VPC.</p>', 'DevEndpoint$PublicAddress' => '<p>The public IP address used by this <code>DevEndpoint</code>. The <code>PublicAddress</code> field is present only when you create a non-virtual private cloud (VPC) <code>DevEndpoint</code>.</p>', 'DevEndpoint$Status' => '<p>The current status of this <code>DevEndpoint</code>.</p>', 'DevEndpoint$AvailabilityZone' => '<p>The AWS Availability Zone where this <code>DevEndpoint</code> is located.</p>', 'DevEndpoint$VpcId' => '<p>The ID of the virtual private cloud (VPC) used by this <code>DevEndpoint</code>.</p>', 'DevEndpoint$ExtraPythonLibsS3Path' => '<p>The paths to one or more Python libraries in an Amazon S3 bucket that should be loaded in your <code>DevEndpoint</code>. Multiple values must be complete paths separated by a comma.</p> <note> <p>You can only use pure Python libraries with a <code>DevEndpoint</code>. Libraries that rely on C extensions, such as the <a href="http://pandas.pydata.org/">pandas</a> Python data analysis library, are not currently supported.</p> </note>', 'DevEndpoint$ExtraJarsS3Path' => '<p>The path to one or more Java <code>.jar</code> files in an S3 bucket that should be loaded in your <code>DevEndpoint</code>.</p> <note> <p>You can only use pure Java/Scala libraries with a <code>DevEndpoint</code>.</p> </note>', 'DevEndpoint$FailureReason' => '<p>The reason for a current failure in this <code>DevEndpoint</code>.</p>', 'DevEndpoint$LastUpdateStatus' => '<p>The status of the last update.</p>', 'DevEndpoint$PublicKey' => '<p>The public key to be used by this <code>DevEndpoint</code> for authentication. This attribute is provided for backward compatibility because the recommended attribute to use is public keys.</p>', 'DevEndpointCustomLibraries$ExtraPythonLibsS3Path' => '<p>The paths to one or more Python libraries in an Amazon Simple Storage Service (Amazon S3) bucket that should be loaded in your <code>DevEndpoint</code>. Multiple values must be complete paths separated by a comma.</p> <note> <p>You can only use pure Python libraries with a <code>DevEndpoint</code>. Libraries that rely on C extensions, such as the <a href="http://pandas.pydata.org/">pandas</a> Python data analysis library, are not currently supported.</p> </note>', 'DevEndpointCustomLibraries$ExtraJarsS3Path' => '<p>The path to one or more Java <code>.jar</code> files in an S3 bucket that should be loaded in your <code>DevEndpoint</code>.</p> <note> <p>You can only use pure Java/Scala libraries with a <code>DevEndpoint</code>.</p> </note>', 'DevEndpointNames$member' => NULL, 'GenericMap$key' => NULL, 'GenericMap$value' => NULL, 'GetDevEndpointRequest$EndpointName' => '<p>Name of the <code>DevEndpoint</code> to retrieve information for.</p>', 'GetDevEndpointsRequest$NextToken' => '<p>A continuation token, if this is a continuation call.</p>', 'GetDevEndpointsResponse$NextToken' => '<p>A continuation token, if not all <code>DevEndpoint</code> definitions have yet been returned.</p>', 'GetJobRunsRequest$NextToken' => '<p>A continuation token, if this is a continuation call.</p>', 'GetJobRunsResponse$NextToken' => '<p>A continuation token, if not all requested job runs have been returned.</p>', 'GetJobsRequest$NextToken' => '<p>A continuation token, if this is a continuation call.</p>', 'GetJobsResponse$NextToken' => '<p>A continuation token, if not all job definitions have yet been returned.</p>', 'GetMLTaskRunResponse$LogGroupName' => '<p>The names of the log groups that are associated with the task run.</p>', 'GetMLTaskRunResponse$ErrorString' => '<p>The error strings that are associated with the task run.</p>', 'GetSecurityConfigurationsRequest$NextToken' => '<p>A continuation token, if this is a continuation call.</p>', 'GetSecurityConfigurationsResponse$NextToken' => '<p>A continuation token, if there are more security configurations to return.</p>', 'GetTriggersRequest$NextToken' => '<p>A continuation token, if this is a continuation call.</p>', 'GetTriggersResponse$NextToken' => '<p>A continuation token, if not all the requested triggers have yet been returned.</p>', 'GetWorkflowRunsRequest$NextToken' => '<p>The maximum size of the response.</p>', 'GetWorkflowRunsResponse$NextToken' => '<p>A continuation token, if not all requested workflow runs have been returned.</p>', 'JobCommand$Name' => '<p>The name of the job command. For an Apache Spark ETL job, this must be <code>glueetl</code>. For a Python shell job, it must be <code>pythonshell</code>. For an Apache Spark streaming ETL job, this must be <code>gluestreaming</code>.</p>', 'JobRun$LogGroupName' => '<p>The name of the log group for secure logging that can be server-side encrypted in Amazon CloudWatch using AWS KMS. This name can be <code>/aws-glue/jobs/</code>, in which case the default encryption is <code>NONE</code>. If you add a role name and <code>SecurityConfiguration</code> name (in other words, <code>/aws-glue/jobs-yourRoleName-yourSecurityConfigurationName/</code>), then that security configuration is used to encrypt the log group.</p>', 'ListDevEndpointsRequest$NextToken' => '<p>A continuation token, if this is a continuation request.</p>', 'ListDevEndpointsResponse$NextToken' => '<p>A continuation token, if the returned list does not contain the last metric available.</p>', 'ListJobsRequest$NextToken' => '<p>A continuation token, if this is a continuation request.</p>', 'ListJobsResponse$NextToken' => '<p>A continuation token, if the returned list does not contain the last metric available.</p>', 'ListTriggersRequest$NextToken' => '<p>A continuation token, if this is a continuation request.</p>', 'ListTriggersResponse$NextToken' => '<p>A continuation token, if the returned list does not contain the last metric available.</p>', 'ListWorkflowsRequest$NextToken' => '<p>A continuation token, if this is a continuation request.</p>', 'ListWorkflowsResponse$NextToken' => '<p>A continuation token, if not all workflow names have been returned.</p>', 'MapValue$key' => NULL, 'MapValue$value' => NULL, 'OrchestrationStringList$member' => NULL, 'PublicKeysList$member' => NULL, 'StringList$member' => NULL, 'TaskRun$LogGroupName' => '<p>The names of the log group for secure logging, associated with this task run.</p>', 'TaskRun$ErrorString' => '<p>The list of error strings associated with this task run.</p>', 'Trigger$Schedule' => '<p>A <code>cron</code> expression used to specify the schedule (see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules for Jobs and Crawlers</a>. For example, to run something every day at 12:15 UTC, you would specify: <code>cron(15 12 * * ? *)</code>.</p>', 'TriggerUpdate$Schedule' => '<p>A <code>cron</code> expression used to specify the schedule (see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules for Jobs and Crawlers</a>. For example, to run something every day at 12:15 UTC, you would specify: <code>cron(15 12 * * ? *)</code>.</p>', 'UpdateDevEndpointRequest$EndpointName' => '<p>The name of the <code>DevEndpoint</code> to be updated.</p>', 'UpdateDevEndpointRequest$PublicKey' => '<p>The public key for the <code>DevEndpoint</code> to use.</p>', 'UpdateWorkflowRequest$Description' => '<p>The description of the workflow.</p>', 'Workflow$Description' => '<p>A description of the workflow.</p>', 'WorkflowRunProperties$value' => NULL, ], ], 'GetCatalogImportStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCatalogImportStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetClassifierRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetClassifierResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetClassifiersRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetClassifiersResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetColumnNamesList' => [ 'base' => NULL, 'refs' => [ 'GetColumnStatisticsForPartitionRequest$ColumnNames' => '<p>A list of the column names.</p>', 'GetColumnStatisticsForTableRequest$ColumnNames' => '<p>A list of the column names.</p>', ], ], 'GetColumnStatisticsForPartitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetColumnStatisticsForPartitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetColumnStatisticsForTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetColumnStatisticsForTableResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetConnectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetConnectionsFilter' => [ 'base' => '<p>Filters the connection definitions that are returned by the <code>GetConnections</code> API operation.</p>', 'refs' => [ 'GetConnectionsRequest$Filter' => '<p>A filter that controls which connections are returned.</p>', ], ], 'GetConnectionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetConnectionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCrawlerMetricsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCrawlerMetricsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCrawlerRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCrawlerResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCrawlersRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCrawlersResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDataCatalogEncryptionSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDataCatalogEncryptionSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDatabaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDatabaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDatabasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDatabasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDataflowGraphRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDataflowGraphResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDevEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDevEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDevEndpointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDevEndpointsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetJobBookmarkRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetJobBookmarkResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetJobRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetJobRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetJobRunsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetJobRunsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMLTaskRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMLTaskRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMLTaskRunsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMLTaskRunsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMLTransformRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMLTransformResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMLTransformsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMLTransformsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMappingRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMappingResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPartitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPartitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPartitionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPartitionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPlanRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPlanResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResourcePoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResourcePoliciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResourcePoliciesResponseList' => [ 'base' => NULL, 'refs' => [ 'GetResourcePoliciesResponse$GetResourcePoliciesResponseList' => '<p>A list of the individual resource policies and the account-level resource policy.</p>', ], ], 'GetResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSecurityConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSecurityConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSecurityConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSecurityConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTableResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTableVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTableVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTableVersionsList' => [ 'base' => NULL, 'refs' => [ 'GetTableVersionsResponse$TableVersions' => '<p>A list of strings identifying available versions of the specified table.</p>', ], ], 'GetTableVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTableVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTablesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTablesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTagsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTriggerRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTriggerResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTriggersRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTriggersResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetUserDefinedFunctionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetUserDefinedFunctionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetUserDefinedFunctionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetUserDefinedFunctionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkflowRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkflowResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkflowRunPropertiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkflowRunPropertiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkflowRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkflowRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkflowRunsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkflowRunsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GlueEncryptionException' => [ 'base' => '<p>An encryption operation failed.</p>', 'refs' => [], ], 'GluePolicy' => [ 'base' => '<p>A structure for returning a resource policy.</p>', 'refs' => [ 'GetResourcePoliciesResponseList$member' => NULL, ], ], 'GlueResourceArn' => [ 'base' => NULL, 'refs' => [ 'DeleteResourcePolicyRequest$ResourceArn' => '<p>The ARN of the AWS Glue resource for the resource policy to be deleted.</p>', 'GetResourcePolicyRequest$ResourceArn' => '<p>The ARN of the AWS Glue resource for the resource policy to be retrieved. For more information about AWS Glue resource ARNs, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html#aws-glue-api-regex-aws-glue-arn-id">AWS Glue ARN string pattern</a> </p>', 'GetTagsRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource for which to retrieve tags.</p>', 'PutResourcePolicyRequest$ResourceArn' => '<p>The ARN of the AWS Glue resource for the resource policy to be set. For more information about AWS Glue resource ARNs, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html#aws-glue-api-regex-aws-glue-arn-id">AWS Glue ARN string pattern</a> </p>', 'TagResourceRequest$ResourceArn' => '<p>The ARN of the AWS Glue resource to which to add the tags. For more information about AWS Glue resource ARNs, see the <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html#aws-glue-api-regex-aws-glue-arn-id">AWS Glue ARN string pattern</a>.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource from which to remove the tags.</p>', ], ], 'GlueTable' => [ 'base' => '<p>The database and table in the AWS Glue Data Catalog that is used for input or output data.</p>', 'refs' => [ 'GlueTables$member' => NULL, ], ], 'GlueTables' => [ 'base' => NULL, 'refs' => [ 'CreateMLTransformRequest$InputRecordTables' => '<p>A list of AWS Glue table definitions used by the transform.</p>', 'GetMLTransformResponse$InputRecordTables' => '<p>A list of AWS Glue table definitions used by the transform.</p>', 'MLTransform$InputRecordTables' => '<p>A list of AWS Glue table definitions used by the transform.</p>', ], ], 'GlueVersionString' => [ 'base' => NULL, 'refs' => [ 'CreateDevEndpointRequest$GlueVersion' => '<p>Glue version determines the versions of Apache Spark and Python that AWS Glue supports. The Python version indicates the version supported for running your ETL scripts on development endpoints. </p> <p>For more information about the available AWS Glue versions and corresponding Spark and Python versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.</p> <p>Development endpoints that are created without specifying a Glue version default to Glue 0.9.</p> <p>You can specify a version of Python support for development endpoints by using the <code>Arguments</code> parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are provided, the version defaults to Python 2.</p>', 'CreateDevEndpointResponse$GlueVersion' => '<p>Glue version determines the versions of Apache Spark and Python that AWS Glue supports. The Python version indicates the version supported for running your ETL scripts on development endpoints. </p>', 'CreateJobRequest$GlueVersion' => '<p>Glue version determines the versions of Apache Spark and Python that AWS Glue supports. The Python version indicates the version supported for jobs of type Spark. </p> <p>For more information about the available AWS Glue versions and corresponding Spark and Python versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.</p> <p>Jobs that are created without specifying a Glue version default to Glue 0.9.</p>', 'CreateMLTransformRequest$GlueVersion' => '<p>This value determines which version of AWS Glue this machine learning transform is compatible with. Glue 1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9. For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">AWS Glue Versions</a> in the developer guide.</p>', 'DevEndpoint$GlueVersion' => '<p>Glue version determines the versions of Apache Spark and Python that AWS Glue supports. The Python version indicates the version supported for running your ETL scripts on development endpoints. </p> <p>For more information about the available AWS Glue versions and corresponding Spark and Python versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.</p> <p>Development endpoints that are created without specifying a Glue version default to Glue 0.9.</p> <p>You can specify a version of Python support for development endpoints by using the <code>Arguments</code> parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are provided, the version defaults to Python 2.</p>', 'GetMLTransformResponse$GlueVersion' => '<p>This value determines which version of AWS Glue this machine learning transform is compatible with. Glue 1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9. For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">AWS Glue Versions</a> in the developer guide.</p>', 'Job$GlueVersion' => '<p>Glue version determines the versions of Apache Spark and Python that AWS Glue supports. The Python version indicates the version supported for jobs of type Spark. </p> <p>For more information about the available AWS Glue versions and corresponding Spark and Python versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.</p> <p>Jobs that are created without specifying a Glue version default to Glue 0.9.</p>', 'JobRun$GlueVersion' => '<p>Glue version determines the versions of Apache Spark and Python that AWS Glue supports. The Python version indicates the version supported for jobs of type Spark. </p> <p>For more information about the available AWS Glue versions and corresponding Spark and Python versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.</p> <p>Jobs that are created without specifying a Glue version default to Glue 0.9.</p>', 'JobUpdate$GlueVersion' => '<p>Glue version determines the versions of Apache Spark and Python that AWS Glue supports. The Python version indicates the version supported for jobs of type Spark. </p> <p>For more information about the available AWS Glue versions and corresponding Spark and Python versions, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">Glue version</a> in the developer guide.</p>', 'MLTransform$GlueVersion' => '<p>This value determines which version of AWS Glue this machine learning transform is compatible with. Glue 1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9. For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">AWS Glue Versions</a> in the developer guide.</p>', 'TransformFilterCriteria$GlueVersion' => '<p>This value determines which version of AWS Glue this machine learning transform is compatible with. Glue 1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9. For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">AWS Glue Versions</a> in the developer guide.</p>', 'UpdateMLTransformRequest$GlueVersion' => '<p>This value determines which version of AWS Glue this machine learning transform is compatible with. Glue 1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9. For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">AWS Glue Versions</a> in the developer guide.</p>', ], ], 'GrokClassifier' => [ 'base' => '<p>A classifier that uses <code>grok</code> patterns.</p>', 'refs' => [ 'Classifier$GrokClassifier' => '<p>A classifier that uses <code>grok</code>.</p>', ], ], 'GrokPattern' => [ 'base' => NULL, 'refs' => [ 'CreateGrokClassifierRequest$GrokPattern' => '<p>The grok pattern used by this classifier.</p>', 'GrokClassifier$GrokPattern' => '<p>The grok pattern applied to a data store by this classifier. For more information, see built-in patterns in <a href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html">Writing Custom Classifiers</a>.</p>', 'UpdateGrokClassifierRequest$GrokPattern' => '<p>The grok pattern used by this classifier.</p>', ], ], 'HashString' => [ 'base' => NULL, 'refs' => [ 'CancelMLTaskRunRequest$TransformId' => '<p>The unique identifier of the machine learning transform.</p>', 'CancelMLTaskRunRequest$TaskRunId' => '<p>A unique identifier for the task run.</p>', 'CancelMLTaskRunResponse$TransformId' => '<p>The unique identifier of the machine learning transform.</p>', 'CancelMLTaskRunResponse$TaskRunId' => '<p>The unique identifier for the task run.</p>', 'CreateMLTransformResponse$TransformId' => '<p>A unique identifier that is generated for the transform.</p>', 'DeleteMLTransformRequest$TransformId' => '<p>The unique identifier of the transform to delete.</p>', 'DeleteMLTransformResponse$TransformId' => '<p>The unique identifier of the transform that was deleted.</p>', 'DeleteResourcePolicyRequest$PolicyHashCondition' => '<p>The hash value returned when this policy was set.</p>', 'FindMatchesTaskRunProperties$JobId' => '<p>The job ID for the Find Matches task run.</p>', 'FindMatchesTaskRunProperties$JobRunId' => '<p>The job run ID for the Find Matches task run.</p>', 'GetMLTaskRunRequest$TransformId' => '<p>The unique identifier of the machine learning transform.</p>', 'GetMLTaskRunRequest$TaskRunId' => '<p>The unique identifier of the task run.</p>', 'GetMLTaskRunResponse$TransformId' => '<p>The unique identifier of the task run.</p>', 'GetMLTaskRunResponse$TaskRunId' => '<p>The unique run identifier associated with this run.</p>', 'GetMLTaskRunsRequest$TransformId' => '<p>The unique identifier of the machine learning transform.</p>', 'GetMLTransformRequest$TransformId' => '<p>The unique identifier of the transform, generated at the time that the transform was created.</p>', 'GetMLTransformResponse$TransformId' => '<p>The unique identifier of the transform, generated at the time that the transform was created.</p>', 'GetResourcePolicyResponse$PolicyHash' => '<p>Contains the hash value associated with this policy.</p>', 'GluePolicy$PolicyHash' => '<p>Contains the hash value associated with this policy.</p>', 'MLTransform$TransformId' => '<p>The unique transform ID that is generated for the machine learning transform. The ID is guaranteed to be unique and does not change.</p>', 'PutResourcePolicyRequest$PolicyHashCondition' => '<p>The hash value returned when the previous policy was set using <code>PutResourcePolicy</code>. Its purpose is to prevent concurrent modifications of a policy. Do not use this parameter if no previous policy has been set.</p>', 'PutResourcePolicyResponse$PolicyHash' => '<p>A hash of the policy that has just been set. This must be included in a subsequent call that overwrites or updates this policy.</p>', 'StartExportLabelsTaskRunRequest$TransformId' => '<p>The unique identifier of the machine learning transform.</p>', 'StartExportLabelsTaskRunResponse$TaskRunId' => '<p>The unique identifier for the task run.</p>', 'StartImportLabelsTaskRunRequest$TransformId' => '<p>The unique identifier of the machine learning transform.</p>', 'StartImportLabelsTaskRunResponse$TaskRunId' => '<p>The unique identifier for the task run.</p>', 'StartMLEvaluationTaskRunRequest$TransformId' => '<p>The unique identifier of the machine learning transform.</p>', 'StartMLEvaluationTaskRunResponse$TaskRunId' => '<p>The unique identifier associated with this run.</p>', 'StartMLLabelingSetGenerationTaskRunRequest$TransformId' => '<p>The unique identifier of the machine learning transform.</p>', 'StartMLLabelingSetGenerationTaskRunResponse$TaskRunId' => '<p>The unique run identifier that is associated with this task run.</p>', 'TaskRun$TransformId' => '<p>The unique identifier for the transform.</p>', 'TaskRun$TaskRunId' => '<p>The unique identifier for this task run.</p>', 'TransformIdList$member' => NULL, 'UpdateMLTransformRequest$TransformId' => '<p>A unique identifier that was generated when the transform was created.</p>', 'UpdateMLTransformResponse$TransformId' => '<p>The unique identifier for the transform that was updated.</p>', ], ], 'IdString' => [ 'base' => NULL, 'refs' => [ 'BatchStopJobRunError$JobRunId' => '<p>The <code>JobRunId</code> of the job run in question.</p>', 'BatchStopJobRunJobRunIdList$member' => NULL, 'BatchStopJobRunSuccessfulSubmission$JobRunId' => '<p>The <code>JobRunId</code> of the job run that was stopped.</p>', 'GetJobRunRequest$RunId' => '<p>The ID of the job run.</p>', 'GetWorkflowRunPropertiesRequest$RunId' => '<p>The ID of the workflow run whose run properties should be returned.</p>', 'GetWorkflowRunRequest$RunId' => '<p>The ID of the workflow run.</p>', 'JobRun$Id' => '<p>The ID of this job run.</p>', 'JobRun$PreviousRunId' => '<p>The ID of the previous run of this job. For example, the <code>JobRunId</code> specified in the <code>StartJobRun</code> action.</p>', 'Predecessor$RunId' => '<p>The job-run ID of the predecessor job run.</p>', 'PutWorkflowRunPropertiesRequest$RunId' => '<p>The ID of the workflow run for which the run properties should be updated.</p>', 'ResumeWorkflowRunRequest$RunId' => '<p>The ID of the workflow run to resume.</p>', 'ResumeWorkflowRunResponse$RunId' => '<p>The new ID assigned to the resumed workflow run. Each resume of a workflow run will have a new run ID.</p>', 'StartJobRunRequest$JobRunId' => '<p>The ID of a previous <code>JobRun</code> to retry.</p>', 'StartJobRunResponse$JobRunId' => '<p>The ID assigned to this job run.</p>', 'StartWorkflowRunResponse$RunId' => '<p>An Id for the new run.</p>', 'StopWorkflowRunRequest$RunId' => '<p>The ID of the workflow run to stop.</p>', 'Trigger$Id' => '<p>Reserved for future use.</p>', 'WorkflowRun$WorkflowRunId' => '<p>The ID of this workflow run.</p>', 'WorkflowRun$PreviousRunId' => '<p>The ID of the previous workflow run.</p>', 'WorkflowRunProperties$key' => NULL, ], ], 'IdempotentParameterMismatchException' => [ 'base' => '<p>The same unique identifier was associated with two different records.</p>', 'refs' => [], ], 'IllegalWorkflowStateException' => [ 'base' => '<p>The workflow is in an invalid state to perform a requested operation.</p>', 'refs' => [], ], 'ImportCatalogToGlueRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportCatalogToGlueResponse' => [ 'base' => NULL, 'refs' => [], ], 'ImportLabelsTaskRunProperties' => [ 'base' => '<p>Specifies configuration properties for an importing labels task run.</p>', 'refs' => [ 'TaskRunProperties$ImportLabelsTaskRunProperties' => '<p>The configuration properties for an importing labels task run.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'CodeGenNode$LineNumber' => '<p>The line number of the node.</p>', 'DecimalNumber$Scale' => '<p>The scale that determines where the decimal point falls in the unscaled value.</p>', 'StorageDescriptor$NumberOfBuckets' => '<p>Must be specified if the table contains any dimension columns.</p>', ], ], 'IntegerFlag' => [ 'base' => NULL, 'refs' => [ 'Order$SortOrder' => '<p>Indicates that the column is sorted in ascending order (<code>== 1</code>), or in descending order (<code>==0</code>).</p>', ], ], 'IntegerValue' => [ 'base' => NULL, 'refs' => [ 'CreateDevEndpointRequest$NumberOfNodes' => '<p>The number of AWS Glue Data Processing Units (DPUs) to allocate to this <code>DevEndpoint</code>.</p>', 'CreateDevEndpointResponse$ZeppelinRemoteSparkInterpreterPort' => '<p>The Apache Zeppelin port for the remote Apache Spark interpreter.</p>', 'CreateDevEndpointResponse$NumberOfNodes' => '<p>The number of AWS Glue Data Processing Units (DPUs) allocated to this DevEndpoint.</p>', 'CreateJobRequest$AllocatedCapacity' => '<p>This parameter is deprecated. Use <code>MaxCapacity</code> instead.</p> <p>The number of AWS Glue data processing units (DPUs) to allocate to this Job. You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a href="https://aws.amazon.com/glue/pricing/">AWS Glue pricing page</a>.</p>', 'DevEndpoint$ZeppelinRemoteSparkInterpreterPort' => '<p>The Apache Zeppelin port for the remote Apache Spark interpreter.</p>', 'DevEndpoint$NumberOfNodes' => '<p>The number of AWS Glue Data Processing Units (DPUs) allocated to this <code>DevEndpoint</code>.</p>', 'Job$AllocatedCapacity' => '<p>This field is deprecated. Use <code>MaxCapacity</code> instead.</p> <p>The number of AWS Glue data processing units (DPUs) allocated to runs of this job. You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a href="https://aws.amazon.com/glue/pricing/">AWS Glue pricing page</a>.</p> <p/>', 'JobBookmarkEntry$Version' => '<p>The version of the job.</p>', 'JobBookmarkEntry$Run' => '<p>The run ID number.</p>', 'JobBookmarkEntry$Attempt' => '<p>The attempt ID number.</p>', 'JobRun$AllocatedCapacity' => '<p>This field is deprecated. Use <code>MaxCapacity</code> instead.</p> <p>The number of AWS Glue data processing units (DPUs) allocated to this JobRun. From 2 to 100 DPUs can be allocated; the default is 10. A DPU is a relative measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a href="https://aws.amazon.com/glue/pricing/">AWS Glue pricing page</a>.</p>', 'JobUpdate$AllocatedCapacity' => '<p>This field is deprecated. Use <code>MaxCapacity</code> instead.</p> <p>The number of AWS Glue data processing units (DPUs) to allocate to this job. You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a href="https://aws.amazon.com/glue/pricing/">AWS Glue pricing page</a>.</p>', 'StartJobRunRequest$AllocatedCapacity' => '<p>This field is deprecated. Use <code>MaxCapacity</code> instead.</p> <p>The number of AWS Glue data processing units (DPUs) to allocate to this JobRun. From 2 to 100 DPUs can be allocated; the default is 10. A DPU is a relative measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a href="https://docs.aws.amazon.com/https:/aws.amazon.com/glue/pricing/">AWS Glue pricing page</a>.</p>', 'WorkflowRunStatistics$TotalActions' => '<p>Total number of Actions in the workflow run.</p>', 'WorkflowRunStatistics$TimeoutActions' => '<p>Total number of Actions that timed out.</p>', 'WorkflowRunStatistics$FailedActions' => '<p>Total number of Actions that have failed.</p>', 'WorkflowRunStatistics$StoppedActions' => '<p>Total number of Actions that have stopped.</p>', 'WorkflowRunStatistics$SucceededActions' => '<p>Total number of Actions that have succeeded.</p>', 'WorkflowRunStatistics$RunningActions' => '<p>Total number Actions in running state.</p>', ], ], 'InternalServiceException' => [ 'base' => '<p>An internal service error occurred.</p>', 'refs' => [], ], 'InvalidInputException' => [ 'base' => '<p>The input provided was not valid.</p>', 'refs' => [], ], 'JdbcTarget' => [ 'base' => '<p>Specifies a JDBC data store to crawl.</p>', 'refs' => [ 'JdbcTargetList$member' => NULL, ], ], 'JdbcTargetList' => [ 'base' => NULL, 'refs' => [ 'CrawlerTargets$JdbcTargets' => '<p>Specifies JDBC targets.</p>', ], ], 'Job' => [ 'base' => '<p>Specifies a job definition.</p>', 'refs' => [ 'GetJobResponse$Job' => '<p>The requested job definition.</p>', 'JobList$member' => NULL, ], ], 'JobBookmarkEntry' => [ 'base' => '<p>Defines a point that a job can resume processing.</p>', 'refs' => [ 'GetJobBookmarkResponse$JobBookmarkEntry' => '<p>A structure that defines a point that a job can resume processing.</p>', 'ResetJobBookmarkResponse$JobBookmarkEntry' => '<p>The reset bookmark entry.</p>', ], ], 'JobBookmarksEncryption' => [ 'base' => '<p>Specifies how job bookmark data should be encrypted.</p>', 'refs' => [ 'EncryptionConfiguration$JobBookmarksEncryption' => '<p>The encryption configuration for job bookmarks.</p>', ], ], 'JobBookmarksEncryptionMode' => [ 'base' => NULL, 'refs' => [ 'JobBookmarksEncryption$JobBookmarksEncryptionMode' => '<p>The encryption mode to use for job bookmarks data.</p>', ], ], 'JobCommand' => [ 'base' => '<p>Specifies code executed when a job is run.</p>', 'refs' => [ 'CreateJobRequest$Command' => '<p>The <code>JobCommand</code> that executes this job.</p>', 'Job$Command' => '<p>The <code>JobCommand</code> that executes this job.</p>', 'JobUpdate$Command' => '<p>The <code>JobCommand</code> that executes this job (required).</p>', ], ], 'JobList' => [ 'base' => NULL, 'refs' => [ 'BatchGetJobsResponse$Jobs' => '<p>A list of job definitions.</p>', 'GetJobsResponse$Jobs' => '<p>A list of job definitions.</p>', ], ], 'JobName' => [ 'base' => NULL, 'refs' => [ 'GetJobBookmarkRequest$JobName' => '<p>The name of the job in question.</p>', 'JobBookmarkEntry$JobName' => '<p>The name of the job in question.</p>', 'ResetJobBookmarkRequest$JobName' => '<p>The name of the job in question.</p>', ], ], 'JobNameList' => [ 'base' => NULL, 'refs' => [ 'BatchGetJobsRequest$JobNames' => '<p>A list of job names, which might be the names returned from the <code>ListJobs</code> operation.</p>', 'BatchGetJobsResponse$JobsNotFound' => '<p>A list of names of jobs not found.</p>', 'ListJobsResponse$JobNames' => '<p>The names of all jobs in the account, or the jobs with the specified tags.</p>', ], ], 'JobNodeDetails' => [ 'base' => '<p>The details of a Job node present in the workflow.</p>', 'refs' => [ 'Node$JobDetails' => '<p>Details of the Job when the node represents a Job.</p>', ], ], 'JobRun' => [ 'base' => '<p>Contains information about a job run.</p>', 'refs' => [ 'GetJobRunResponse$JobRun' => '<p>The requested job-run metadata.</p>', 'JobRunList$member' => NULL, ], ], 'JobRunList' => [ 'base' => NULL, 'refs' => [ 'GetJobRunsResponse$JobRuns' => '<p>A list of job-run metadata objects.</p>', 'JobNodeDetails$JobRuns' => '<p>The information for the job runs represented by the job node.</p>', ], ], 'JobRunState' => [ 'base' => NULL, 'refs' => [ 'Condition$State' => '<p>The condition state. Currently, the values supported are <code>SUCCEEDED</code>, <code>STOPPED</code>, <code>TIMEOUT</code>, and <code>FAILED</code>.</p>', 'JobRun$JobRunState' => '<p>The current state of the job run.</p>', ], ], 'JobUpdate' => [ 'base' => '<p>Specifies information used to update an existing job definition. The previous job definition is completely overwritten by this information.</p>', 'refs' => [ 'UpdateJobRequest$JobUpdate' => '<p>Specifies the values with which to update the job definition.</p>', ], ], 'JsonClassifier' => [ 'base' => '<p>A classifier for <code>JSON</code> content.</p>', 'refs' => [ 'Classifier$JsonClassifier' => '<p>A classifier for JSON content.</p>', ], ], 'JsonPath' => [ 'base' => NULL, 'refs' => [ 'CreateJsonClassifierRequest$JsonPath' => '<p>A <code>JsonPath</code> string defining the JSON data for the classifier to classify. AWS Glue supports a subset of JsonPath, as described in <a href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json">Writing JsonPath Custom Classifiers</a>.</p>', 'JsonClassifier$JsonPath' => '<p>A <code>JsonPath</code> string defining the JSON data for the classifier to classify. AWS Glue supports a subset of JsonPath, as described in <a href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json">Writing JsonPath Custom Classifiers</a>.</p>', 'UpdateJsonClassifierRequest$JsonPath' => '<p>A <code>JsonPath</code> string defining the JSON data for the classifier to classify. AWS Glue supports a subset of JsonPath, as described in <a href="https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json">Writing JsonPath Custom Classifiers</a>.</p>', ], ], 'JsonValue' => [ 'base' => NULL, 'refs' => [ 'JobBookmarkEntry$JobBookmark' => '<p>The bookmark itself.</p>', ], ], 'KeyString' => [ 'base' => NULL, 'refs' => [ 'ParametersMap$key' => NULL, ], ], 'KmsKeyArn' => [ 'base' => NULL, 'refs' => [ 'CloudWatchEncryption$KmsKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.</p>', 'JobBookmarksEncryption$KmsKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.</p>', 'S3Encryption$KmsKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key to be used to encrypt the data.</p>', ], ], 'LabelCount' => [ 'base' => NULL, 'refs' => [ 'GetMLTransformResponse$LabelCount' => '<p>The number of labels available for this transform.</p>', 'MLTransform$LabelCount' => '<p>A count identifier for the labeling files generated by AWS Glue for this transform. As you create a better transform, you can iteratively download, label, and upload the labeling file.</p>', ], ], 'LabelingSetGenerationTaskRunProperties' => [ 'base' => '<p>Specifies configuration properties for a labeling set generation task run.</p>', 'refs' => [ 'TaskRunProperties$LabelingSetGenerationTaskRunProperties' => '<p>The configuration properties for a labeling set generation task run.</p>', ], ], 'Language' => [ 'base' => NULL, 'refs' => [ 'CreateScriptRequest$Language' => '<p>The programming language of the resulting code from the DAG.</p>', 'GetPlanRequest$Language' => '<p>The programming language of the code to perform the mapping.</p>', ], ], 'LastCrawlInfo' => [ 'base' => '<p>Status and error information about the most recent crawl.</p>', 'refs' => [ 'Crawler$LastCrawl' => '<p>The status of the last crawl, and potentially error information if an error occurred.</p>', ], ], 'LastCrawlStatus' => [ 'base' => NULL, 'refs' => [ 'LastCrawlInfo$Status' => '<p>Status of the last crawl.</p>', ], ], 'ListCrawlersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCrawlersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDevEndpointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDevEndpointsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMLTransformsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMLTransformsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTriggersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTriggersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkflowsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkflowsResponse' => [ 'base' => NULL, 'refs' => [], ], 'Location' => [ 'base' => '<p>The location of resources.</p>', 'refs' => [ 'GetMappingRequest$Location' => '<p>Parameters for the mapping.</p>', 'GetPlanRequest$Location' => '<p>The parameters for the mapping.</p>', ], ], 'LocationMap' => [ 'base' => NULL, 'refs' => [ 'SkewedInfo$SkewedColumnValueLocationMaps' => '<p>A mapping of skewed values to the columns that contain them.</p>', ], ], 'LocationString' => [ 'base' => NULL, 'refs' => [ 'StorageDescriptor$Location' => '<p>The physical location of the table. By default, this takes the form of the warehouse location, followed by the database location in the warehouse, followed by the table name.</p>', ], ], 'LogGroup' => [ 'base' => NULL, 'refs' => [ 'Crawl$LogGroup' => '<p>The log group associated with the crawl.</p>', 'LastCrawlInfo$LogGroup' => '<p>The log group for the last crawl.</p>', ], ], 'LogStream' => [ 'base' => NULL, 'refs' => [ 'Crawl$LogStream' => '<p>The log stream associated with the crawl.</p>', 'LastCrawlInfo$LogStream' => '<p>The log stream for the last crawl.</p>', ], ], 'Logical' => [ 'base' => NULL, 'refs' => [ 'Predicate$Logical' => '<p>An optional field if only one condition is listed. If multiple conditions are listed, then this field is required.</p>', ], ], 'LogicalOperator' => [ 'base' => NULL, 'refs' => [ 'Condition$LogicalOperator' => '<p>A logical operator.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'LongColumnStatisticsData$MinimumValue' => '<p>Minimum value of the column.</p>', 'LongColumnStatisticsData$MaximumValue' => '<p>Maximum value of the column.</p>', ], ], 'LongColumnStatisticsData' => [ 'base' => '<p>Defines a long column statistics data.</p>', 'refs' => [ 'ColumnStatisticsData$LongColumnStatisticsData' => '<p>Long Column Statistics Data.</p>', ], ], 'MLTransform' => [ 'base' => '<p>A structure for a machine learning transform.</p>', 'refs' => [ 'TransformList$member' => NULL, ], ], 'MLTransformNotReadyException' => [ 'base' => '<p>The machine learning transform is not ready to run.</p>', 'refs' => [], ], 'MapValue' => [ 'base' => NULL, 'refs' => [ 'CreateDevEndpointRequest$Arguments' => '<p>A map of arguments used to configure the <code>DevEndpoint</code>.</p>', 'CreateDevEndpointResponse$Arguments' => '<p>The map of arguments used to configure this <code>DevEndpoint</code>.</p> <p>Valid arguments are:</p> <ul> <li> <p> <code>"--enable-glue-datacatalog": ""</code> </p> </li> <li> <p> <code>"GLUE_PYTHON_VERSION": "3"</code> </p> </li> <li> <p> <code>"GLUE_PYTHON_VERSION": "2"</code> </p> </li> </ul> <p>You can specify a version of Python support for development endpoints by using the <code>Arguments</code> parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are provided, the version defaults to Python 2.</p>', 'DevEndpoint$Arguments' => '<p>A map of arguments used to configure the <code>DevEndpoint</code>.</p> <p>Valid arguments are:</p> <ul> <li> <p> <code>"--enable-glue-datacatalog": ""</code> </p> </li> <li> <p> <code>"GLUE_PYTHON_VERSION": "3"</code> </p> </li> <li> <p> <code>"GLUE_PYTHON_VERSION": "2"</code> </p> </li> </ul> <p>You can specify a version of Python support for development endpoints by using the <code>Arguments</code> parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are provided, the version defaults to Python 2.</p>', 'UpdateDevEndpointRequest$AddArguments' => '<p>The map of arguments to add the map of arguments used to configure the <code>DevEndpoint</code>.</p> <p>Valid arguments are:</p> <ul> <li> <p> <code>"--enable-glue-datacatalog": ""</code> </p> </li> <li> <p> <code>"GLUE_PYTHON_VERSION": "3"</code> </p> </li> <li> <p> <code>"GLUE_PYTHON_VERSION": "2"</code> </p> </li> </ul> <p>You can specify a version of Python support for development endpoints by using the <code>Arguments</code> parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are provided, the version defaults to Python 2.</p>', ], ], 'MappingEntry' => [ 'base' => '<p>Defines a mapping.</p>', 'refs' => [ 'MappingList$member' => NULL, ], ], 'MappingList' => [ 'base' => NULL, 'refs' => [ 'GetMappingResponse$Mapping' => '<p>A list of mappings to the specified targets.</p>', 'GetPlanRequest$Mapping' => '<p>The list of mappings from a source table to target tables.</p>', ], ], 'MatchCriteria' => [ 'base' => NULL, 'refs' => [ 'Connection$MatchCriteria' => '<p>A list of criteria that can be used in selecting this connection.</p>', 'ConnectionInput$MatchCriteria' => '<p>A list of criteria that can be used in selecting this connection.</p>', 'GetConnectionsFilter$MatchCriteria' => '<p>A criteria string that must match the criteria recorded in the connection definition for that connection definition to be returned.</p>', ], ], 'MaxConcurrentRuns' => [ 'base' => NULL, 'refs' => [ 'ExecutionProperty$MaxConcurrentRuns' => '<p>The maximum number of concurrent runs allowed for the job. The default is 1. An error is returned when this threshold is reached. The maximum value you can specify is controlled by a service limit.</p>', ], ], 'MaxRetries' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$MaxRetries' => '<p>The maximum number of times to retry this job if it fails.</p>', 'Job$MaxRetries' => '<p>The maximum number of times to retry this job after a JobRun fails.</p>', 'JobUpdate$MaxRetries' => '<p>The maximum number of times to retry this job if it fails.</p>', ], ], 'MessagePrefix' => [ 'base' => NULL, 'refs' => [ 'LastCrawlInfo$MessagePrefix' => '<p>The prefix for a message about this crawl.</p>', ], ], 'MessageString' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => '<p>A message describing the problem.</p>', 'AlreadyExistsException$Message' => '<p>A message describing the problem.</p>', 'ConcurrentModificationException$Message' => '<p>A message describing the problem.</p>', 'ConcurrentRunsExceededException$Message' => '<p>A message describing the problem.</p>', 'ConditionCheckFailureException$Message' => '<p>A message describing the problem.</p>', 'CrawlerNotRunningException$Message' => '<p>A message describing the problem.</p>', 'CrawlerRunningException$Message' => '<p>A message describing the problem.</p>', 'CrawlerStoppingException$Message' => '<p>A message describing the problem.</p>', 'EntityNotFoundException$Message' => '<p>A message describing the problem.</p>', 'GlueEncryptionException$Message' => '<p>A message describing the problem.</p>', 'IdempotentParameterMismatchException$Message' => '<p>A message describing the problem.</p>', 'IllegalWorkflowStateException$Message' => '<p>A message describing the problem.</p>', 'InternalServiceException$Message' => '<p>A message describing the problem.</p>', 'InvalidInputException$Message' => '<p>A message describing the problem.</p>', 'MLTransformNotReadyException$Message' => '<p>A message describing the problem.</p>', 'NoScheduleException$Message' => '<p>A message describing the problem.</p>', 'OperationTimeoutException$Message' => '<p>A message describing the problem.</p>', 'ResourceNumberLimitExceededException$Message' => '<p>A message describing the problem.</p>', 'SchedulerNotRunningException$Message' => '<p>A message describing the problem.</p>', 'SchedulerRunningException$Message' => '<p>A message describing the problem.</p>', 'SchedulerTransitioningException$Message' => '<p>A message describing the problem.</p>', 'ValidationException$Message' => '<p>A message describing the problem.</p>', 'VersionMismatchException$Message' => '<p>A message describing the problem.</p>', ], ], 'MillisecondsCount' => [ 'base' => NULL, 'refs' => [ 'Crawler$CrawlElapsedTime' => '<p>If the crawler is running, contains the total time elapsed since the last crawl began.</p>', ], ], 'NameString' => [ 'base' => NULL, 'refs' => [ 'Action$JobName' => '<p>The name of a job to be executed.</p>', 'Action$SecurityConfiguration' => '<p>The name of the <code>SecurityConfiguration</code> structure to be used with this action.</p>', 'Action$CrawlerName' => '<p>The name of the crawler to be used with this action.</p>', 'BatchCreatePartitionRequest$DatabaseName' => '<p>The name of the metadata database in which the partition is to be created.</p>', 'BatchCreatePartitionRequest$TableName' => '<p>The name of the metadata table in which the partition is to be created.</p>', 'BatchDeletePartitionRequest$DatabaseName' => '<p>The name of the catalog database in which the table in question resides.</p>', 'BatchDeletePartitionRequest$TableName' => '<p>The name of the table that contains the partitions to be deleted.</p>', 'BatchDeleteTableNameList$member' => NULL, 'BatchDeleteTableRequest$DatabaseName' => '<p>The name of the catalog database in which the tables to delete reside. For Hive compatibility, this name is entirely lowercase.</p>', 'BatchDeleteTableVersionRequest$DatabaseName' => '<p>The database in the catalog in which the table resides. For Hive compatibility, this name is entirely lowercase.</p>', 'BatchDeleteTableVersionRequest$TableName' => '<p>The name of the table. For Hive compatibility, this name is entirely lowercase.</p>', 'BatchGetPartitionRequest$DatabaseName' => '<p>The name of the catalog database where the partitions reside.</p>', 'BatchGetPartitionRequest$TableName' => '<p>The name of the partitions\' table.</p>', 'BatchStopJobRunError$JobName' => '<p>The name of the job definition that is used in the job run in question.</p>', 'BatchStopJobRunRequest$JobName' => '<p>The name of the job definition for which to stop job runs.</p>', 'BatchStopJobRunSuccessfulSubmission$JobName' => '<p>The name of the job definition used in the job run that was stopped.</p>', 'CatalogEntry$DatabaseName' => '<p>The database in which the table metadata resides.</p>', 'CatalogEntry$TableName' => '<p>The name of the table in question.</p>', 'CatalogImportStatus$ImportedBy' => '<p>The name of the person who initiated the migration.</p>', 'CatalogTablesList$member' => NULL, 'CatalogTarget$DatabaseName' => '<p>The name of the database to be synchronized.</p>', 'ClassifierNameList$member' => NULL, 'Column$Name' => '<p>The name of the <code>Column</code>.</p>', 'ColumnError$ColumnName' => '<p>The name of the column.</p>', 'ColumnStatistics$ColumnName' => '<p>The name of the column.</p>', 'Condition$JobName' => '<p>The name of the job whose <code>JobRuns</code> this condition applies to, and on which this trigger waits.</p>', 'Condition$CrawlerName' => '<p>The name of the crawler to which this condition applies.</p>', 'Connection$Name' => '<p>The name of the connection definition.</p>', 'Connection$LastUpdatedBy' => '<p>The user, group, or role that last updated this connection definition.</p>', 'ConnectionInput$Name' => '<p>The name of the connection.</p>', 'ConnectionPasswordEncryption$AwsKmsKeyId' => '<p>An AWS KMS key that is used to encrypt the connection password. </p> <p>If connection password protection is enabled, the caller of <code>CreateConnection</code> and <code>UpdateConnection</code> needs at least <code>kms:Encrypt</code> permission on the specified AWS KMS key, to encrypt passwords before storing them in the Data Catalog. </p> <p>You can set the decrypt permission to enable or restrict access on the password key according to your security requirements.</p>', 'Crawler$Name' => '<p>The name of the crawler.</p>', 'CrawlerMetrics$CrawlerName' => '<p>The name of the crawler.</p>', 'CrawlerNameList$member' => NULL, 'CreateCrawlerRequest$Name' => '<p>Name of the new crawler.</p>', 'CreateCsvClassifierRequest$Name' => '<p>The name of the classifier.</p>', 'CreateDevEndpointRequest$SecurityConfiguration' => '<p>The name of the <code>SecurityConfiguration</code> structure to be used with this <code>DevEndpoint</code>.</p>', 'CreateDevEndpointResponse$SecurityConfiguration' => '<p>The name of the <code>SecurityConfiguration</code> structure being used with this <code>DevEndpoint</code>.</p>', 'CreateGrokClassifierRequest$Name' => '<p>The name of the new classifier.</p>', 'CreateJobRequest$Name' => '<p>The name you assign to this job definition. It must be unique in your account.</p>', 'CreateJobRequest$SecurityConfiguration' => '<p>The name of the <code>SecurityConfiguration</code> structure to be used with this job.</p>', 'CreateJobResponse$Name' => '<p>The unique name that was provided for this job definition.</p>', 'CreateJsonClassifierRequest$Name' => '<p>The name of the classifier.</p>', 'CreateMLTransformRequest$Name' => '<p>The unique name that you give the transform when you create it.</p>', 'CreatePartitionRequest$DatabaseName' => '<p>The name of the metadata database in which the partition is to be created.</p>', 'CreatePartitionRequest$TableName' => '<p>The name of the metadata table in which the partition is to be created.</p>', 'CreateSecurityConfigurationRequest$Name' => '<p>The name for the new security configuration.</p>', 'CreateSecurityConfigurationResponse$Name' => '<p>The name assigned to the new security configuration.</p>', 'CreateTableRequest$DatabaseName' => '<p>The catalog database in which to create the new table. For Hive compatibility, this name is entirely lowercase.</p>', 'CreateTriggerRequest$Name' => '<p>The name of the trigger.</p>', 'CreateTriggerRequest$WorkflowName' => '<p>The name of the workflow associated with the trigger.</p>', 'CreateTriggerResponse$Name' => '<p>The name of the trigger.</p>', 'CreateUserDefinedFunctionRequest$DatabaseName' => '<p>The name of the catalog database in which to create the function.</p>', 'CreateWorkflowRequest$Name' => '<p>The name to be assigned to the workflow. It should be unique within your account.</p>', 'CreateWorkflowResponse$Name' => '<p>The name of the workflow which was provided as part of the request.</p>', 'CreateXMLClassifierRequest$Name' => '<p>The name of the classifier.</p>', 'CsvClassifier$Name' => '<p>The name of the classifier.</p>', 'CsvHeader$member' => NULL, 'Database$Name' => '<p>The name of the database. For Hive compatibility, this is folded to lowercase when it is stored.</p>', 'DatabaseIdentifier$DatabaseName' => '<p>The name of the catalog database.</p>', 'DatabaseInput$Name' => '<p>The name of the database. For Hive compatibility, this is folded to lowercase when it is stored.</p>', 'DeleteClassifierRequest$Name' => '<p>Name of the classifier to remove.</p>', 'DeleteColumnStatisticsForPartitionRequest$DatabaseName' => '<p>The name of the catalog database where the partitions reside.</p>', 'DeleteColumnStatisticsForPartitionRequest$TableName' => '<p>The name of the partitions\' table.</p>', 'DeleteColumnStatisticsForPartitionRequest$ColumnName' => '<p>Name of the column.</p>', 'DeleteColumnStatisticsForTableRequest$DatabaseName' => '<p>The name of the catalog database where the partitions reside.</p>', 'DeleteColumnStatisticsForTableRequest$TableName' => '<p>The name of the partitions\' table.</p>', 'DeleteColumnStatisticsForTableRequest$ColumnName' => '<p>The name of the column.</p>', 'DeleteConnectionNameList$member' => NULL, 'DeleteConnectionRequest$ConnectionName' => '<p>The name of the connection to delete.</p>', 'DeleteCrawlerRequest$Name' => '<p>The name of the crawler to remove.</p>', 'DeleteDatabaseRequest$Name' => '<p>The name of the database to delete. For Hive compatibility, this must be all lowercase.</p>', 'DeleteJobRequest$JobName' => '<p>The name of the job definition to delete.</p>', 'DeleteJobResponse$JobName' => '<p>The name of the job definition that was deleted.</p>', 'DeletePartitionRequest$DatabaseName' => '<p>The name of the catalog database in which the table in question resides.</p>', 'DeletePartitionRequest$TableName' => '<p>The name of the table that contains the partition to be deleted.</p>', 'DeleteSecurityConfigurationRequest$Name' => '<p>The name of the security configuration to delete.</p>', 'DeleteTableRequest$DatabaseName' => '<p>The name of the catalog database in which the table resides. For Hive compatibility, this name is entirely lowercase.</p>', 'DeleteTableRequest$Name' => '<p>The name of the table to be deleted. For Hive compatibility, this name is entirely lowercase.</p>', 'DeleteTableVersionRequest$DatabaseName' => '<p>The database in the catalog in which the table resides. For Hive compatibility, this name is entirely lowercase.</p>', 'DeleteTableVersionRequest$TableName' => '<p>The name of the table. For Hive compatibility, this name is entirely lowercase.</p>', 'DeleteTriggerRequest$Name' => '<p>The name of the trigger to delete.</p>', 'DeleteTriggerResponse$Name' => '<p>The name of the trigger that was deleted.</p>', 'DeleteUserDefinedFunctionRequest$DatabaseName' => '<p>The name of the catalog database where the function is located.</p>', 'DeleteUserDefinedFunctionRequest$FunctionName' => '<p>The name of the function definition to be deleted.</p>', 'DeleteWorkflowRequest$Name' => '<p>Name of the workflow to be deleted.</p>', 'DeleteWorkflowResponse$Name' => '<p>Name of the workflow specified in input.</p>', 'DevEndpoint$SecurityConfiguration' => '<p>The name of the <code>SecurityConfiguration</code> structure to be used with this <code>DevEndpoint</code>.</p>', 'DevEndpointNameList$member' => NULL, 'Edge$SourceId' => '<p>The unique of the node within the workflow where the edge starts.</p>', 'Edge$DestinationId' => '<p>The unique of the node within the workflow where the edge ends.</p>', 'EncryptionAtRest$SseAwsKmsKeyId' => '<p>The ID of the AWS KMS key to use for encryption at rest.</p>', 'ErrorByName$key' => NULL, 'ErrorDetail$ErrorCode' => '<p>The code associated with this error.</p>', 'FindMatchesTaskRunProperties$JobName' => '<p>The name assigned to the job for the Find Matches task run.</p>', 'GetClassifierRequest$Name' => '<p>Name of the classifier to retrieve.</p>', 'GetColumnNamesList$member' => NULL, 'GetColumnStatisticsForPartitionRequest$DatabaseName' => '<p>The name of the catalog database where the partitions reside.</p>', 'GetColumnStatisticsForPartitionRequest$TableName' => '<p>The name of the partitions\' table.</p>', 'GetColumnStatisticsForTableRequest$DatabaseName' => '<p>The name of the catalog database where the partitions reside.</p>', 'GetColumnStatisticsForTableRequest$TableName' => '<p>The name of the partitions\' table.</p>', 'GetConnectionRequest$Name' => '<p>The name of the connection definition to retrieve.</p>', 'GetCrawlerRequest$Name' => '<p>The name of the crawler to retrieve metadata for.</p>', 'GetDatabaseRequest$Name' => '<p>The name of the database to retrieve. For Hive compatibility, this should be all lowercase.</p>', 'GetJobRequest$JobName' => '<p>The name of the job definition to retrieve.</p>', 'GetJobRunRequest$JobName' => '<p>Name of the job definition being run.</p>', 'GetJobRunsRequest$JobName' => '<p>The name of the job definition for which to retrieve all job runs.</p>', 'GetMLTransformResponse$Name' => '<p>The unique name given to the transform when it was created.</p>', 'GetPartitionRequest$DatabaseName' => '<p>The name of the catalog database where the partition resides.</p>', 'GetPartitionRequest$TableName' => '<p>The name of the partition\'s table.</p>', 'GetPartitionsRequest$DatabaseName' => '<p>The name of the catalog database where the partitions reside.</p>', 'GetPartitionsRequest$TableName' => '<p>The name of the partitions\' table.</p>', 'GetSecurityConfigurationRequest$Name' => '<p>The name of the security configuration to retrieve.</p>', 'GetTableRequest$DatabaseName' => '<p>The name of the database in the catalog in which the table resides. For Hive compatibility, this name is entirely lowercase.</p>', 'GetTableRequest$Name' => '<p>The name of the table for which to retrieve the definition. For Hive compatibility, this name is entirely lowercase.</p>', 'GetTableVersionRequest$DatabaseName' => '<p>The database in the catalog in which the table resides. For Hive compatibility, this name is entirely lowercase.</p>', 'GetTableVersionRequest$TableName' => '<p>The name of the table. For Hive compatibility, this name is entirely lowercase.</p>', 'GetTableVersionsRequest$DatabaseName' => '<p>The database in the catalog in which the table resides. For Hive compatibility, this name is entirely lowercase.</p>', 'GetTableVersionsRequest$TableName' => '<p>The name of the table. For Hive compatibility, this name is entirely lowercase.</p>', 'GetTablesRequest$DatabaseName' => '<p>The database in the catalog whose tables to list. For Hive compatibility, this name is entirely lowercase.</p>', 'GetTriggerRequest$Name' => '<p>The name of the trigger to retrieve.</p>', 'GetTriggersRequest$DependentJobName' => '<p>The name of the job to retrieve triggers for. The trigger that can start this job is returned, and if there is no such trigger, all triggers are returned.</p>', 'GetUserDefinedFunctionRequest$DatabaseName' => '<p>The name of the catalog database where the function is located.</p>', 'GetUserDefinedFunctionRequest$FunctionName' => '<p>The name of the function.</p>', 'GetUserDefinedFunctionsRequest$DatabaseName' => '<p>The name of the catalog database where the functions are located. If none is provided, functions from all the databases across the catalog will be returned.</p>', 'GetUserDefinedFunctionsRequest$Pattern' => '<p>An optional function-name pattern string that filters the function definitions returned.</p>', 'GetWorkflowRequest$Name' => '<p>The name of the workflow to retrieve.</p>', 'GetWorkflowRunPropertiesRequest$Name' => '<p>Name of the workflow which was run.</p>', 'GetWorkflowRunRequest$Name' => '<p>Name of the workflow being run.</p>', 'GetWorkflowRunsRequest$Name' => '<p>Name of the workflow whose metadata of runs should be returned.</p>', 'GlueTable$DatabaseName' => '<p>A database name in the AWS Glue Data Catalog.</p>', 'GlueTable$TableName' => '<p>A table name in the AWS Glue Data Catalog.</p>', 'GlueTable$CatalogId' => '<p>A unique identifier for the AWS Glue Data Catalog.</p>', 'GlueTable$ConnectionName' => '<p>The name of the connection to the AWS Glue Data Catalog.</p>', 'GrokClassifier$Name' => '<p>The name of the classifier.</p>', 'Job$Name' => '<p>The name you assign to this job definition.</p>', 'Job$SecurityConfiguration' => '<p>The name of the <code>SecurityConfiguration</code> structure to be used with this job.</p>', 'JobNameList$member' => NULL, 'JobRun$TriggerName' => '<p>The name of the trigger that started this job run.</p>', 'JobRun$JobName' => '<p>The name of the job definition being used in this run.</p>', 'JobRun$SecurityConfiguration' => '<p>The name of the <code>SecurityConfiguration</code> structure to be used with this job run.</p>', 'JobUpdate$SecurityConfiguration' => '<p>The name of the <code>SecurityConfiguration</code> structure to be used with this job.</p>', 'JsonClassifier$Name' => '<p>The name of the classifier.</p>', 'ListTriggersRequest$DependentJobName' => '<p> The name of the job for which to retrieve triggers. The trigger that can start this job is returned. If there is no such trigger, all triggers are returned.</p>', 'MLTransform$Name' => '<p>A user-defined name for the machine learning transform. Names are not guaranteed unique and can be changed at any time.</p>', 'MatchCriteria$member' => NULL, 'NameStringList$member' => NULL, 'Node$Name' => '<p>The name of the AWS Glue component represented by the node.</p>', 'Node$UniqueId' => '<p>The unique Id assigned to the node within the workflow.</p>', 'NodeIdList$member' => NULL, 'Order$Column' => '<p>The name of the column.</p>', 'Partition$DatabaseName' => '<p>The name of the catalog database in which to create the partition.</p>', 'Partition$TableName' => '<p>The name of the database table in which to create the partition.</p>', 'PhysicalConnectionRequirements$SubnetId' => '<p>The subnet ID used by the connection.</p>', 'PhysicalConnectionRequirements$AvailabilityZone' => '<p>The connection\'s Availability Zone. This field is redundant because the specified subnet implies the Availability Zone to be used. Currently the field must be populated, but it will be deprecated in the future.</p>', 'Predecessor$JobName' => '<p>The name of the job definition used by the predecessor job run.</p>', 'PutWorkflowRunPropertiesRequest$Name' => '<p>Name of the workflow which was run.</p>', 'ResumeWorkflowRunRequest$Name' => '<p>The name of the workflow to resume.</p>', 'SecurityConfiguration$Name' => '<p>The name of the security configuration.</p>', 'SecurityGroupIdList$member' => NULL, 'SerDeInfo$Name' => '<p>Name of the SerDe.</p>', 'SerDeInfo$SerializationLibrary' => '<p>Usually the class that implements the SerDe. An example is <code>org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe</code>.</p>', 'StartCrawlerRequest$Name' => '<p>Name of the crawler to start.</p>', 'StartCrawlerScheduleRequest$CrawlerName' => '<p>Name of the crawler to schedule.</p>', 'StartJobRunRequest$JobName' => '<p>The name of the job definition to use.</p>', 'StartJobRunRequest$SecurityConfiguration' => '<p>The name of the <code>SecurityConfiguration</code> structure to be used with this job run.</p>', 'StartTriggerRequest$Name' => '<p>The name of the trigger to start.</p>', 'StartTriggerResponse$Name' => '<p>The name of the trigger that was started.</p>', 'StartWorkflowRunRequest$Name' => '<p>The name of the workflow to start.</p>', 'StopCrawlerRequest$Name' => '<p>Name of the crawler to stop.</p>', 'StopCrawlerScheduleRequest$CrawlerName' => '<p>Name of the crawler whose schedule state to set.</p>', 'StopTriggerRequest$Name' => '<p>The name of the trigger to stop.</p>', 'StopTriggerResponse$Name' => '<p>The name of the trigger that was stopped.</p>', 'StopWorkflowRunRequest$Name' => '<p>The name of the workflow to stop.</p>', 'Table$Name' => '<p>The table name. For Hive compatibility, this must be entirely lowercase.</p>', 'Table$DatabaseName' => '<p>The name of the database where the table metadata resides. For Hive compatibility, this must be all lowercase.</p>', 'Table$Owner' => '<p>The owner of the table.</p>', 'Table$CreatedBy' => '<p>The person or entity who created the table.</p>', 'TableError$TableName' => '<p>The name of the table. For Hive compatibility, this must be entirely lowercase.</p>', 'TableIdentifier$DatabaseName' => '<p>The name of the catalog database that contains the target table.</p>', 'TableIdentifier$Name' => '<p>The name of the target table.</p>', 'TableInput$Name' => '<p>The table name. For Hive compatibility, this is folded to lowercase when it is stored.</p>', 'TableInput$Owner' => '<p>The table owner.</p>', 'TableVersionError$TableName' => '<p>The name of the table in question.</p>', 'TransformFilterCriteria$Name' => '<p>A unique transform name that is used to filter the machine learning transforms.</p>', 'Trigger$Name' => '<p>The name of the trigger.</p>', 'Trigger$WorkflowName' => '<p>The name of the workflow associated with the trigger.</p>', 'TriggerNameList$member' => NULL, 'TriggerUpdate$Name' => '<p>Reserved for future use.</p>', 'UpdateColumnStatisticsForPartitionRequest$DatabaseName' => '<p>The name of the catalog database where the partitions reside.</p>', 'UpdateColumnStatisticsForPartitionRequest$TableName' => '<p>The name of the partitions\' table.</p>', 'UpdateColumnStatisticsForTableRequest$DatabaseName' => '<p>The name of the catalog database where the partitions reside.</p>', 'UpdateColumnStatisticsForTableRequest$TableName' => '<p>The name of the partitions\' table.</p>', 'UpdateConnectionRequest$Name' => '<p>The name of the connection definition to update.</p>', 'UpdateCrawlerRequest$Name' => '<p>Name of the new crawler.</p>', 'UpdateCrawlerScheduleRequest$CrawlerName' => '<p>The name of the crawler whose schedule to update.</p>', 'UpdateCsvClassifierRequest$Name' => '<p>The name of the classifier.</p>', 'UpdateDatabaseRequest$Name' => '<p>The name of the database to update in the catalog. For Hive compatibility, this is folded to lowercase.</p>', 'UpdateGrokClassifierRequest$Name' => '<p>The name of the <code>GrokClassifier</code>.</p>', 'UpdateJobRequest$JobName' => '<p>The name of the job definition to update.</p>', 'UpdateJobResponse$JobName' => '<p>Returns the name of the updated job definition.</p>', 'UpdateJsonClassifierRequest$Name' => '<p>The name of the classifier.</p>', 'UpdateMLTransformRequest$Name' => '<p>The unique name that you gave the transform when you created it.</p>', 'UpdatePartitionRequest$DatabaseName' => '<p>The name of the catalog database in which the table in question resides.</p>', 'UpdatePartitionRequest$TableName' => '<p>The name of the table in which the partition to be updated is located.</p>', 'UpdateTableRequest$DatabaseName' => '<p>The name of the catalog database in which the table resides. For Hive compatibility, this name is entirely lowercase.</p>', 'UpdateTriggerRequest$Name' => '<p>The name of the trigger to update.</p>', 'UpdateUserDefinedFunctionRequest$DatabaseName' => '<p>The name of the catalog database where the function to be updated is located.</p>', 'UpdateUserDefinedFunctionRequest$FunctionName' => '<p>The name of the function.</p>', 'UpdateWorkflowRequest$Name' => '<p>Name of the workflow to be updated.</p>', 'UpdateWorkflowResponse$Name' => '<p>The name of the workflow which was specified in input.</p>', 'UpdateXMLClassifierRequest$Name' => '<p>The name of the classifier.</p>', 'UserDefinedFunction$FunctionName' => '<p>The name of the function.</p>', 'UserDefinedFunction$DatabaseName' => '<p>The name of the catalog database that contains the function.</p>', 'UserDefinedFunction$ClassName' => '<p>The Java class that contains the function code.</p>', 'UserDefinedFunction$OwnerName' => '<p>The owner of the function.</p>', 'UserDefinedFunctionInput$FunctionName' => '<p>The name of the function.</p>', 'UserDefinedFunctionInput$ClassName' => '<p>The Java class that contains the function code.</p>', 'UserDefinedFunctionInput$OwnerName' => '<p>The owner of the function.</p>', 'Workflow$Name' => '<p>The name of the workflow representing the flow.</p>', 'WorkflowNames$member' => NULL, 'WorkflowRun$Name' => '<p>Name of the workflow that was executed.</p>', 'XMLClassifier$Name' => '<p>The name of the classifier.</p>', ], ], 'NameStringList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteConnectionResponse$Succeeded' => '<p>A list of names of the connection definitions that were successfully deleted.</p>', 'SkewedInfo$SkewedColumnNames' => '<p>A list of names of columns that contain skewed values.</p>', 'StorageDescriptor$BucketColumns' => '<p>A list of reducer grouping columns, clustering columns, and bucketing columns in the table.</p>', ], ], 'NoScheduleException' => [ 'base' => '<p>There is no applicable schedule.</p>', 'refs' => [], ], 'Node' => [ 'base' => '<p>A node represents an AWS Glue component such as a trigger, or job, etc., that is part of a workflow.</p>', 'refs' => [ 'NodeList$member' => NULL, ], ], 'NodeIdList' => [ 'base' => NULL, 'refs' => [ 'ResumeWorkflowRunRequest$NodeIds' => '<p>A list of the node IDs for the nodes you want to restart. The nodes that are to be restarted must have an execution attempt in the original run.</p>', 'ResumeWorkflowRunResponse$NodeIds' => '<p>A list of the node IDs for the nodes that were actually restarted.</p>', ], ], 'NodeList' => [ 'base' => NULL, 'refs' => [ 'WorkflowGraph$Nodes' => '<p>A list of the the AWS Glue components belong to the workflow represented as nodes.</p>', ], ], 'NodeType' => [ 'base' => NULL, 'refs' => [ 'Node$Type' => '<p>The type of AWS Glue component represented by the node.</p>', ], ], 'NonNegativeDouble' => [ 'base' => NULL, 'refs' => [ 'BinaryColumnStatisticsData$AverageLength' => '<p>Average length of the column.</p>', 'CrawlerMetrics$TimeLeftSeconds' => '<p>The estimated time left to complete a running crawl.</p>', 'CrawlerMetrics$LastRuntimeSeconds' => '<p>The duration of the crawler\'s most recent run, in seconds.</p>', 'CrawlerMetrics$MedianRuntimeSeconds' => '<p>The median duration of this crawler\'s runs, in seconds.</p>', 'StringColumnStatisticsData$AverageLength' => '<p>Average value of the column.</p>', ], ], 'NonNegativeInteger' => [ 'base' => NULL, 'refs' => [ 'CrawlerMetrics$TablesCreated' => '<p>The number of tables created by this crawler.</p>', 'CrawlerMetrics$TablesUpdated' => '<p>The number of tables updated by this crawler.</p>', 'CrawlerMetrics$TablesDeleted' => '<p>The number of tables deleted by this crawler.</p>', 'Segment$SegmentNumber' => '<p>The zero-based index number of the segment. For example, if the total number of segments is 4, <code>SegmentNumber</code> values range from 0 through 3.</p>', 'Table$Retention' => '<p>The retention time for this table.</p>', 'TableInput$Retention' => '<p>The retention time for this table.</p>', ], ], 'NonNegativeLong' => [ 'base' => NULL, 'refs' => [ 'BinaryColumnStatisticsData$MaximumLength' => '<p>Maximum length of the column.</p>', 'BinaryColumnStatisticsData$NumberOfNulls' => '<p>Number of nulls.</p>', 'BooleanColumnStatisticsData$NumberOfTrues' => '<p>Number of true value.</p>', 'BooleanColumnStatisticsData$NumberOfFalses' => '<p>Number of false value.</p>', 'BooleanColumnStatisticsData$NumberOfNulls' => '<p>Number of nulls.</p>', 'DateColumnStatisticsData$NumberOfNulls' => '<p>Number of nulls.</p>', 'DateColumnStatisticsData$NumberOfDistinctValues' => '<p>Number of distinct values.</p>', 'DecimalColumnStatisticsData$NumberOfNulls' => '<p>Number of nulls.</p>', 'DecimalColumnStatisticsData$NumberOfDistinctValues' => '<p>Number of distinct values.</p>', 'DoubleColumnStatisticsData$NumberOfNulls' => '<p>Number of nulls.</p>', 'DoubleColumnStatisticsData$NumberOfDistinctValues' => '<p>Number of distinct values.</p>', 'LongColumnStatisticsData$NumberOfNulls' => '<p>Number of nulls.</p>', 'LongColumnStatisticsData$NumberOfDistinctValues' => '<p>Number of distinct values.</p>', 'StringColumnStatisticsData$MaximumLength' => '<p>Maximum value of the column.</p>', 'StringColumnStatisticsData$NumberOfNulls' => '<p>Number of nulls.</p>', 'StringColumnStatisticsData$NumberOfDistinctValues' => '<p>Number of distinct values.</p>', ], ], 'NotificationProperty' => [ 'base' => '<p>Specifies configuration properties of a notification.</p>', 'refs' => [ 'Action$NotificationProperty' => '<p>Specifies configuration properties of a job run notification.</p>', 'CreateJobRequest$NotificationProperty' => '<p>Specifies configuration properties of a job notification.</p>', 'Job$NotificationProperty' => '<p>Specifies configuration properties of a job notification.</p>', 'JobRun$NotificationProperty' => '<p>Specifies configuration properties of a job run notification.</p>', 'JobUpdate$NotificationProperty' => '<p>Specifies the configuration properties of a job notification.</p>', 'StartJobRunRequest$NotificationProperty' => '<p>Specifies configuration properties of a job run notification.</p>', ], ], 'NotifyDelayAfter' => [ 'base' => NULL, 'refs' => [ 'NotificationProperty$NotifyDelayAfter' => '<p>After a job run starts, the number of minutes to wait before sending a job run delay notification.</p>', ], ], 'NullableBoolean' => [ 'base' => NULL, 'refs' => [ 'BatchGetWorkflowsRequest$IncludeGraph' => '<p>Specifies whether to include a graph when returning the workflow resource metadata.</p>', 'CreateCsvClassifierRequest$DisableValueTrimming' => '<p>Specifies not to trim values before identifying the type of column values. The default value is true.</p>', 'CreateCsvClassifierRequest$AllowSingleColumn' => '<p>Enables the processing of files that contain only one column.</p>', 'CsvClassifier$DisableValueTrimming' => '<p>Specifies not to trim values before identifying the type of column values. The default value is <code>true</code>.</p>', 'CsvClassifier$AllowSingleColumn' => '<p>Enables the processing of files that contain only one column.</p>', 'DynamoDBTarget$scanAll' => '<p>Indicates whether to scan all the records, or to sample rows from the table. Scanning all the records can take a long time when the table is not a high throughput table.</p> <p>A value of <code>true</code> means to scan all records, while a value of <code>false</code> means to sample the records. If no value is specified, the value defaults to <code>true</code>.</p>', 'FindMatchesParameters$EnforceProvidedLabels' => '<p>The value to switch on or off to force the output to match the provided labels from users. If the value is <code>True</code>, the <code>find matches</code> transform forces the output to match the provided labels. The results override the normal conflation results. If the value is <code>False</code>, the <code>find matches</code> transform does not ensure all the labels provided are respected, and the results rely on the trained model.</p> <p>Note that setting this value to true may increase the conflation execution time.</p>', 'GetWorkflowRequest$IncludeGraph' => '<p>Specifies whether to include a graph when returning the workflow resource metadata.</p>', 'GetWorkflowRunRequest$IncludeGraph' => '<p>Specifies whether to include the workflow graph in response or not.</p>', 'GetWorkflowRunsRequest$IncludeGraph' => '<p>Specifies whether to include the workflow graph in response or not.</p>', 'UpdateCsvClassifierRequest$DisableValueTrimming' => '<p>Specifies not to trim values before identifying the type of column values. The default value is true.</p>', 'UpdateCsvClassifierRequest$AllowSingleColumn' => '<p>Enables the processing of files that contain only one column.</p>', ], ], 'NullableDouble' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$MaxCapacity' => '<p>The number of AWS Glue data processing units (DPUs) that can be allocated when this job runs. A DPU is a relative measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a href="https://aws.amazon.com/glue/pricing/">AWS Glue pricing page</a>.</p> <p>Do not set <code>Max Capacity</code> if using <code>WorkerType</code> and <code>NumberOfWorkers</code>.</p> <p>The value that can be allocated for <code>MaxCapacity</code> depends on whether you are running a Python shell job or an Apache Spark ETL job:</p> <ul> <li> <p>When you specify a Python shell job (<code>JobCommand.Name</code>="pythonshell"), you can allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.</p> </li> <li> <p>When you specify an Apache Spark ETL job (<code>JobCommand.Name</code>="glueetl") or Apache Spark streaming ETL job (<code>JobCommand.Name</code>="gluestreaming"), you can allocate from 2 to 100 DPUs. The default is 10 DPUs. This job type cannot have a fractional DPU allocation.</p> </li> </ul>', 'CreateMLTransformRequest$MaxCapacity' => '<p>The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform. You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a href="https://aws.amazon.com/glue/pricing/">AWS Glue pricing page</a>. </p> <p> <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and <code>WorkerType</code>.</p> <ul> <li> <p>If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be set.</p> </li> <li> <p>If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be set.</p> </li> <li> <p>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</p> </li> <li> <p> <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.</p> </li> </ul> <p>When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the <code>MaxCapacity</code> field is set automatically and becomes read-only.</p> <p>When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the <code>MaxCapacity</code> field is set automatically and becomes read-only.</p>', 'DynamoDBTarget$scanRate' => '<p>The percentage of the configured read capacity units to use by the AWS Glue crawler. Read capacity units is a term defined by DynamoDB, and is a numeric value that acts as rate limiter for the number of reads that can be performed on that table per second.</p> <p>The valid values are null or a value between 0.1 to 1.5. A null value is used when user does not provide a value, and defaults to 0.5 of the configured Read Capacity Unit (for provisioned tables), or 0.25 of the max configured Read Capacity Unit (for tables using on-demand mode).</p>', 'GetMLTransformResponse$MaxCapacity' => '<p>The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform. You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a href="https://aws.amazon.com/glue/pricing/">AWS Glue pricing page</a>. </p> <p>When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the <code>MaxCapacity</code> field is set automatically and becomes read-only.</p>', 'Job$MaxCapacity' => '<p>The number of AWS Glue data processing units (DPUs) that can be allocated when this job runs. A DPU is a relative measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a href="https://aws.amazon.com/glue/pricing/">AWS Glue pricing page</a>.</p> <p>Do not set <code>Max Capacity</code> if using <code>WorkerType</code> and <code>NumberOfWorkers</code>.</p> <p>The value that can be allocated for <code>MaxCapacity</code> depends on whether you are running a Python shell job, an Apache Spark ETL job, or an Apache Spark streaming ETL job:</p> <ul> <li> <p>When you specify a Python shell job (<code>JobCommand.Name</code>="pythonshell"), you can allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.</p> </li> <li> <p>When you specify an Apache Spark ETL job (<code>JobCommand.Name</code>="glueetl") or Apache Spark streaming ETL job (<code>JobCommand.Name</code>="gluestreaming"), you can allocate from 2 to 100 DPUs. The default is 10 DPUs. This job type cannot have a fractional DPU allocation.</p> </li> </ul>', 'JobRun$MaxCapacity' => '<p>The number of AWS Glue data processing units (DPUs) that can be allocated when this job runs. A DPU is a relative measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a href="https://docs.aws.amazon.com/https:/aws.amazon.com/glue/pricing/">AWS Glue pricing page</a>.</p> <p>Do not set <code>Max Capacity</code> if using <code>WorkerType</code> and <code>NumberOfWorkers</code>.</p> <p>The value that can be allocated for <code>MaxCapacity</code> depends on whether you are running a Python shell job or an Apache Spark ETL job:</p> <ul> <li> <p>When you specify a Python shell job (<code>JobCommand.Name</code>="pythonshell"), you can allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.</p> </li> <li> <p>When you specify an Apache Spark ETL job (<code>JobCommand.Name</code>="glueetl"), you can allocate from 2 to 100 DPUs. The default is 10 DPUs. This job type cannot have a fractional DPU allocation.</p> </li> </ul>', 'JobUpdate$MaxCapacity' => '<p>The number of AWS Glue data processing units (DPUs) that can be allocated when this job runs. A DPU is a relative measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a href="https://aws.amazon.com/glue/pricing/">AWS Glue pricing page</a>.</p> <p>Do not set <code>Max Capacity</code> if using <code>WorkerType</code> and <code>NumberOfWorkers</code>.</p> <p>The value that can be allocated for <code>MaxCapacity</code> depends on whether you are running a Python shell job or an Apache Spark ETL job:</p> <ul> <li> <p>When you specify a Python shell job (<code>JobCommand.Name</code>="pythonshell"), you can allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.</p> </li> <li> <p>When you specify an Apache Spark ETL job (<code>JobCommand.Name</code>="glueetl") or Apache Spark streaming ETL job (<code>JobCommand.Name</code>="gluestreaming"), you can allocate from 2 to 100 DPUs. The default is 10 DPUs. This job type cannot have a fractional DPU allocation.</p> </li> </ul>', 'MLTransform$MaxCapacity' => '<p>The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform. You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a href="http://aws.amazon.com/glue/pricing/">AWS Glue pricing page</a>. </p> <p> <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and <code>WorkerType</code>.</p> <ul> <li> <p>If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be set.</p> </li> <li> <p>If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be set.</p> </li> <li> <p>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</p> </li> <li> <p> <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.</p> </li> </ul> <p>When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the <code>MaxCapacity</code> field is set automatically and becomes read-only.</p>', 'StartJobRunRequest$MaxCapacity' => '<p>The number of AWS Glue data processing units (DPUs) that can be allocated when this job runs. A DPU is a relative measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a href="https://docs.aws.amazon.com/https:/aws.amazon.com/glue/pricing/">AWS Glue pricing page</a>.</p> <p>Do not set <code>Max Capacity</code> if using <code>WorkerType</code> and <code>NumberOfWorkers</code>.</p> <p>The value that can be allocated for <code>MaxCapacity</code> depends on whether you are running a Python shell job, or an Apache Spark ETL job:</p> <ul> <li> <p>When you specify a Python shell job (<code>JobCommand.Name</code>="pythonshell"), you can allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.</p> </li> <li> <p>When you specify an Apache Spark ETL job (<code>JobCommand.Name</code>="glueetl"), you can allocate from 2 to 100 DPUs. The default is 10 DPUs. This job type cannot have a fractional DPU allocation.</p> </li> </ul>', 'UpdateMLTransformRequest$MaxCapacity' => '<p>The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform. You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a href="https://aws.amazon.com/glue/pricing/">AWS Glue pricing page</a>. </p> <p>When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the <code>MaxCapacity</code> field is set automatically and becomes read-only.</p>', ], ], 'NullableInteger' => [ 'base' => NULL, 'refs' => [ 'CreateDevEndpointRequest$NumberOfWorkers' => '<p>The number of workers of a defined <code>workerType</code> that are allocated to the development endpoint.</p> <p>The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>. </p>', 'CreateDevEndpointResponse$NumberOfWorkers' => '<p>The number of workers of a defined <code>workerType</code> that are allocated to the development endpoint.</p>', 'CreateJobRequest$NumberOfWorkers' => '<p>The number of workers of a defined <code>workerType</code> that are allocated when a job runs.</p> <p>The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>. </p>', 'CreateMLTransformRequest$NumberOfWorkers' => '<p>The number of workers of a defined <code>workerType</code> that are allocated when this task runs.</p> <p>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</p>', 'CreateMLTransformRequest$MaxRetries' => '<p>The maximum number of times to retry a task for this transform after a task run fails.</p>', 'DevEndpoint$NumberOfWorkers' => '<p>The number of workers of a defined <code>workerType</code> that are allocated to the development endpoint.</p> <p>The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>. </p>', 'GetMLTransformResponse$NumberOfWorkers' => '<p>The number of workers of a defined <code>workerType</code> that are allocated when this task runs.</p>', 'GetMLTransformResponse$MaxRetries' => '<p>The maximum number of times to retry a task for this transform after a task run fails.</p>', 'Job$NumberOfWorkers' => '<p>The number of workers of a defined <code>workerType</code> that are allocated when a job runs.</p> <p>The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>. </p>', 'JobRun$NumberOfWorkers' => '<p>The number of workers of a defined <code>workerType</code> that are allocated when a job runs.</p> <p>The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>. </p>', 'JobUpdate$NumberOfWorkers' => '<p>The number of workers of a defined <code>workerType</code> that are allocated when a job runs.</p> <p>The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>. </p>', 'MLTransform$NumberOfWorkers' => '<p>The number of workers of a defined <code>workerType</code> that are allocated when a task of the transform runs.</p> <p>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</p>', 'MLTransform$MaxRetries' => '<p>The maximum number of times to retry after an <code>MLTaskRun</code> of the machine learning transform fails.</p>', 'StartJobRunRequest$NumberOfWorkers' => '<p>The number of workers of a defined <code>workerType</code> that are allocated when a job runs.</p> <p>The maximum number of workers you can define are 299 for <code>G.1X</code>, and 149 for <code>G.2X</code>. </p>', 'UpdateMLTransformRequest$NumberOfWorkers' => '<p>The number of workers of a defined <code>workerType</code> that are allocated when this task runs.</p>', 'UpdateMLTransformRequest$MaxRetries' => '<p>The maximum number of times to retry a task for this transform after a task run fails.</p>', ], ], 'OperationTimeoutException' => [ 'base' => '<p>The operation timed out.</p>', 'refs' => [], ], 'OrchestrationStringList' => [ 'base' => NULL, 'refs' => [ 'ConnectionsList$Connections' => '<p>A list of connections used by the job.</p>', ], ], 'Order' => [ 'base' => '<p>Specifies the sort order of a sorted column.</p>', 'refs' => [ 'OrderList$member' => NULL, ], ], 'OrderList' => [ 'base' => NULL, 'refs' => [ 'StorageDescriptor$SortColumns' => '<p>A list specifying the sort order of each bucket in the table.</p>', ], ], 'PageSize' => [ 'base' => NULL, 'refs' => [ 'GetClassifiersRequest$MaxResults' => '<p>The size of the list to return (optional).</p>', 'GetConnectionsRequest$MaxResults' => '<p>The maximum number of connections to return in one response.</p>', 'GetCrawlerMetricsRequest$MaxResults' => '<p>The maximum size of a list to return.</p>', 'GetCrawlersRequest$MaxResults' => '<p>The number of crawlers to return on each call.</p>', 'GetDatabasesRequest$MaxResults' => '<p>The maximum number of databases to return in one response.</p>', 'GetDevEndpointsRequest$MaxResults' => '<p>The maximum size of information to return.</p>', 'GetJobRunsRequest$MaxResults' => '<p>The maximum size of the response.</p>', 'GetJobsRequest$MaxResults' => '<p>The maximum size of the response.</p>', 'GetMLTaskRunsRequest$MaxResults' => '<p>The maximum number of results to return. </p>', 'GetMLTransformsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'GetPartitionsRequest$MaxResults' => '<p>The maximum number of partitions to return in a single response.</p>', 'GetResourcePoliciesRequest$MaxResults' => '<p>The maximum size of a list to return.</p>', 'GetSecurityConfigurationsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'GetTableVersionsRequest$MaxResults' => '<p>The maximum number of table versions to return in one response.</p>', 'GetTablesRequest$MaxResults' => '<p>The maximum number of tables to return in a single response.</p>', 'GetTriggersRequest$MaxResults' => '<p>The maximum size of the response.</p>', 'GetUserDefinedFunctionsRequest$MaxResults' => '<p>The maximum number of functions to return in one response.</p>', 'GetWorkflowRunsRequest$MaxResults' => '<p>The maximum number of workflow runs to be included in the response.</p>', 'ListCrawlersRequest$MaxResults' => '<p>The maximum size of a list to return.</p>', 'ListDevEndpointsRequest$MaxResults' => '<p>The maximum size of a list to return.</p>', 'ListJobsRequest$MaxResults' => '<p>The maximum size of a list to return.</p>', 'ListMLTransformsRequest$MaxResults' => '<p>The maximum size of a list to return.</p>', 'ListTriggersRequest$MaxResults' => '<p>The maximum size of a list to return.</p>', 'ListWorkflowsRequest$MaxResults' => '<p>The maximum size of a list to return.</p>', 'SearchTablesRequest$MaxResults' => '<p>The maximum number of tables to return in a single response.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'GetMLTaskRunsRequest$NextToken' => '<p>A token for pagination of the results. The default is empty.</p>', 'GetMLTaskRunsResponse$NextToken' => '<p>A pagination token, if more results are available.</p>', 'GetMLTransformsRequest$NextToken' => '<p>A paginated token to offset the results.</p>', 'GetMLTransformsResponse$NextToken' => '<p>A pagination token, if more results are available.</p>', 'ListMLTransformsRequest$NextToken' => '<p>A continuation token, if this is a continuation request.</p>', 'ListMLTransformsResponse$NextToken' => '<p>A continuation token, if the returned list does not contain the last metric available.</p>', ], ], 'ParametersMap' => [ 'base' => NULL, 'refs' => [ 'Column$Parameters' => '<p>These key-value pairs define properties associated with the column.</p>', 'Database$Parameters' => '<p>These key-value pairs define parameters and properties of the database.</p>', 'DatabaseInput$Parameters' => '<p>These key-value pairs define parameters and properties of the database.</p> <p>These key-value pairs define parameters and properties of the database.</p>', 'Partition$Parameters' => '<p>These key-value pairs define partition parameters.</p>', 'PartitionInput$Parameters' => '<p>These key-value pairs define partition parameters.</p>', 'SerDeInfo$Parameters' => '<p>These key-value pairs define initialization parameters for the SerDe.</p>', 'StorageDescriptor$Parameters' => '<p>The user-supplied properties in key-value form.</p>', 'Table$Parameters' => '<p>These key-value pairs define properties associated with the table.</p>', 'TableInput$Parameters' => '<p>These key-value pairs define properties associated with the table.</p>', ], ], 'ParametersMapValue' => [ 'base' => NULL, 'refs' => [ 'ParametersMap$value' => NULL, ], ], 'Partition' => [ 'base' => '<p>Represents a slice of table data.</p>', 'refs' => [ 'GetPartitionResponse$Partition' => '<p>The requested information, in the form of a <code>Partition</code> object.</p>', 'PartitionList$member' => NULL, ], ], 'PartitionError' => [ 'base' => '<p>Contains information about a partition error.</p>', 'refs' => [ 'PartitionErrors$member' => NULL, ], ], 'PartitionErrors' => [ 'base' => NULL, 'refs' => [ 'BatchCreatePartitionResponse$Errors' => '<p>The errors encountered when trying to create the requested partitions.</p>', 'BatchDeletePartitionResponse$Errors' => '<p>The errors encountered when trying to delete the requested partitions.</p>', ], ], 'PartitionInput' => [ 'base' => '<p>The structure used to create and update a partition.</p>', 'refs' => [ 'CreatePartitionRequest$PartitionInput' => '<p>A <code>PartitionInput</code> structure defining the partition to be created.</p>', 'PartitionInputList$member' => NULL, 'UpdatePartitionRequest$PartitionInput' => '<p>The new partition object to update the partition to.</p> <p>The <code>Values</code> property can\'t be changed. If you want to change the partition key values for a partition, delete and recreate the partition.</p>', ], ], 'PartitionInputList' => [ 'base' => NULL, 'refs' => [ 'BatchCreatePartitionRequest$PartitionInputList' => '<p>A list of <code>PartitionInput</code> structures that define the partitions to be created.</p>', ], ], 'PartitionList' => [ 'base' => NULL, 'refs' => [ 'BatchGetPartitionResponse$Partitions' => '<p>A list of the requested partitions.</p>', 'GetPartitionsResponse$Partitions' => '<p>A list of requested partitions.</p>', ], ], 'PartitionValueList' => [ 'base' => '<p>Contains a list of values defining partitions.</p>', 'refs' => [ 'BatchDeletePartitionValueList$member' => NULL, 'BatchGetPartitionValueList$member' => NULL, ], ], 'Path' => [ 'base' => NULL, 'refs' => [ 'DynamoDBTarget$Path' => '<p>The name of the DynamoDB table to crawl.</p>', 'JdbcTarget$Path' => '<p>The path of the JDBC target.</p>', 'PathList$member' => NULL, 'S3Target$Path' => '<p>The path to the Amazon S3 target.</p>', ], ], 'PathList' => [ 'base' => NULL, 'refs' => [ 'JdbcTarget$Exclusions' => '<p>A list of glob patterns used to exclude from the crawl. For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Catalog Tables with a Crawler</a>.</p>', 'S3Target$Exclusions' => '<p>A list of glob patterns used to exclude from the crawl. For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-crawler.html">Catalog Tables with a Crawler</a>.</p>', ], ], 'Permission' => [ 'base' => NULL, 'refs' => [ 'PermissionList$member' => NULL, ], ], 'PermissionList' => [ 'base' => NULL, 'refs' => [ 'PrincipalPermissions$Permissions' => '<p>The permissions that are granted to the principal.</p>', ], ], 'PhysicalConnectionRequirements' => [ 'base' => '<p>Specifies the physical requirements for a connection.</p>', 'refs' => [ 'Connection$PhysicalConnectionRequirements' => '<p>A map of physical connection requirements, such as virtual private cloud (VPC) and <code>SecurityGroup</code>, that are needed to make this connection successfully.</p>', 'ConnectionInput$PhysicalConnectionRequirements' => '<p>A map of physical connection requirements, such as virtual private cloud (VPC) and <code>SecurityGroup</code>, that are needed to successfully make this connection.</p>', ], ], 'PolicyJsonString' => [ 'base' => NULL, 'refs' => [ 'GetResourcePolicyResponse$PolicyInJson' => '<p>Contains the requested policy document, in JSON format.</p>', 'GluePolicy$PolicyInJson' => '<p>Contains the requested policy document, in JSON format.</p>', 'PutResourcePolicyRequest$PolicyInJson' => '<p>Contains the policy document to set, in JSON format.</p>', ], ], 'Predecessor' => [ 'base' => '<p>A job run that was used in the predicate of a conditional trigger that triggered this job run.</p>', 'refs' => [ 'PredecessorList$member' => NULL, ], ], 'PredecessorList' => [ 'base' => NULL, 'refs' => [ 'JobRun$PredecessorRuns' => '<p>A list of predecessors to this job run.</p>', ], ], 'Predicate' => [ 'base' => '<p>Defines the predicate of the trigger, which determines when it fires.</p>', 'refs' => [ 'CreateTriggerRequest$Predicate' => '<p>A predicate to specify when the new trigger should fire.</p> <p>This field is required when the trigger type is <code>CONDITIONAL</code>.</p>', 'Trigger$Predicate' => '<p>The predicate of this trigger, which defines when it will fire.</p>', 'TriggerUpdate$Predicate' => '<p>The predicate of this trigger, which defines when it will fire.</p>', ], ], 'PredicateString' => [ 'base' => NULL, 'refs' => [ 'GetPartitionsRequest$Expression' => '<p>An expression that filters the partitions to be returned.</p> <p>The expression uses SQL syntax similar to the SQL <code>WHERE</code> filter clause. The SQL statement parser <a href="http://jsqlparser.sourceforge.net/home.php">JSQLParser</a> parses the expression. </p> <p> <i>Operators</i>: The following are the operators that you can use in the <code>Expression</code> API call:</p> <dl> <dt>=</dt> <dd> <p>Checks whether the values of the two operands are equal; if yes, then the condition becomes true.</p> <p>Example: Assume \'variable a\' holds 10 and \'variable b\' holds 20. </p> <p>(a = b) is not true.</p> </dd> <dt>&lt; &gt;</dt> <dd> <p>Checks whether the values of two operands are equal; if the values are not equal, then the condition becomes true.</p> <p>Example: (a &lt; &gt; b) is true.</p> </dd> <dt>&gt;</dt> <dd> <p>Checks whether the value of the left operand is greater than the value of the right operand; if yes, then the condition becomes true.</p> <p>Example: (a &gt; b) is not true.</p> </dd> <dt>&lt;</dt> <dd> <p>Checks whether the value of the left operand is less than the value of the right operand; if yes, then the condition becomes true.</p> <p>Example: (a &lt; b) is true.</p> </dd> <dt>&gt;=</dt> <dd> <p>Checks whether the value of the left operand is greater than or equal to the value of the right operand; if yes, then the condition becomes true.</p> <p>Example: (a &gt;= b) is not true.</p> </dd> <dt>&lt;=</dt> <dd> <p>Checks whether the value of the left operand is less than or equal to the value of the right operand; if yes, then the condition becomes true.</p> <p>Example: (a &lt;= b) is true.</p> </dd> <dt>AND, OR, IN, BETWEEN, LIKE, NOT, IS NULL</dt> <dd> <p>Logical operators.</p> </dd> </dl> <p> <i>Supported Partition Key Types</i>: The following are the supported partition keys.</p> <ul> <li> <p> <code>string</code> </p> </li> <li> <p> <code>date</code> </p> </li> <li> <p> <code>timestamp</code> </p> </li> <li> <p> <code>int</code> </p> </li> <li> <p> <code>bigint</code> </p> </li> <li> <p> <code>long</code> </p> </li> <li> <p> <code>tinyint</code> </p> </li> <li> <p> <code>smallint</code> </p> </li> <li> <p> <code>decimal</code> </p> </li> </ul> <p>If an invalid type is encountered, an exception is thrown. </p> <p>The following list shows the valid operators on each type. When you define a crawler, the <code>partitionKey</code> type is created as a <code>STRING</code>, to be compatible with the catalog partitions. </p> <p> <i>Sample API Call</i>: </p>', ], ], 'PrincipalPermissions' => [ 'base' => '<p>Permissions granted to a principal.</p>', 'refs' => [ 'PrincipalPermissionsList$member' => NULL, ], ], 'PrincipalPermissionsList' => [ 'base' => NULL, 'refs' => [ 'Database$CreateTableDefaultPermissions' => '<p>Creates a set of default permissions on the table for principals. </p>', 'DatabaseInput$CreateTableDefaultPermissions' => '<p>Creates a set of default permissions on the table for principals. </p>', ], ], 'PrincipalType' => [ 'base' => NULL, 'refs' => [ 'UserDefinedFunction$OwnerType' => '<p>The owner type.</p>', 'UserDefinedFunctionInput$OwnerType' => '<p>The owner type.</p>', ], ], 'PropertyPredicate' => [ 'base' => '<p>Defines a property predicate.</p>', 'refs' => [ 'SearchPropertyPredicates$member' => NULL, ], ], 'PublicKeysList' => [ 'base' => NULL, 'refs' => [ 'CreateDevEndpointRequest$PublicKeys' => '<p>A list of public keys to be used by the development endpoints for authentication. The use of this attribute is preferred over a single public key because the public keys allow you to have a different private key per client.</p> <note> <p>If you previously created an endpoint with a public key, you must remove that key to be able to set a list of public keys. Call the <code>UpdateDevEndpoint</code> API with the public key content in the <code>deletePublicKeys</code> attribute, and the list of new keys in the <code>addPublicKeys</code> attribute.</p> </note>', 'DevEndpoint$PublicKeys' => '<p>A list of public keys to be used by the <code>DevEndpoints</code> for authentication. Using this attribute is preferred over a single public key because the public keys allow you to have a different private key per client.</p> <note> <p>If you previously created an endpoint with a public key, you must remove that key to be able to set a list of public keys. Call the <code>UpdateDevEndpoint</code> API operation with the public key content in the <code>deletePublicKeys</code> attribute, and the list of new keys in the <code>addPublicKeys</code> attribute.</p> </note>', 'UpdateDevEndpointRequest$AddPublicKeys' => '<p>The list of public keys for the <code>DevEndpoint</code> to use.</p>', 'UpdateDevEndpointRequest$DeletePublicKeys' => '<p>The list of public keys to be deleted from the <code>DevEndpoint</code>.</p>', ], ], 'PutDataCatalogEncryptionSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutDataCatalogEncryptionSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutWorkflowRunPropertiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutWorkflowRunPropertiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'PythonScript' => [ 'base' => NULL, 'refs' => [ 'CreateScriptResponse$PythonScript' => '<p>The Python script generated from the DAG.</p>', 'GetDataflowGraphRequest$PythonScript' => '<p>The Python script to transform.</p>', 'GetPlanResponse$PythonScript' => '<p>A Python script to perform the mapping.</p>', ], ], 'PythonVersionString' => [ 'base' => NULL, 'refs' => [ 'JobCommand$PythonVersion' => '<p>The Python version being used to execute a Python shell job. Allowed values are 2 or 3.</p>', ], ], 'RecordsCount' => [ 'base' => NULL, 'refs' => [ 'ConfusionMatrix$NumTruePositives' => '<p>The number of matches in the data that the transform correctly found, in the confusion matrix for your transform.</p>', 'ConfusionMatrix$NumFalsePositives' => '<p>The number of nonmatches in the data that the transform incorrectly classified as a match, in the confusion matrix for your transform.</p>', 'ConfusionMatrix$NumTrueNegatives' => '<p>The number of nonmatches in the data that the transform correctly rejected, in the confusion matrix for your transform.</p>', 'ConfusionMatrix$NumFalseNegatives' => '<p>The number of matches in the data that the transform didn\'t find, in the confusion matrix for your transform.</p>', ], ], 'ReplaceBoolean' => [ 'base' => NULL, 'refs' => [ 'ImportLabelsTaskRunProperties$Replace' => '<p>Indicates whether to overwrite your existing labels.</p>', 'StartImportLabelsTaskRunRequest$ReplaceAllLabels' => '<p>Indicates whether to overwrite your existing labels.</p>', ], ], 'ResetJobBookmarkRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResetJobBookmarkResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResourceNumberLimitExceededException' => [ 'base' => '<p>A resource numerical limit was exceeded.</p>', 'refs' => [], ], 'ResourceShareType' => [ 'base' => NULL, 'refs' => [ 'GetDatabasesRequest$ResourceShareType' => '<p>Allows you to specify that you want to list the databases shared with your account. The allowable values are <code>FOREIGN</code> or <code>ALL</code>. </p> <ul> <li> <p>If set to <code>FOREIGN</code>, will list the databases shared with your account. </p> </li> <li> <p>If set to <code>ALL</code>, will list the databases shared with your account, as well as the databases in yor local account. </p> </li> </ul>', 'SearchTablesRequest$ResourceShareType' => '<p>Allows you to specify that you want to search the tables shared with your account. The allowable values are <code>FOREIGN</code> or <code>ALL</code>. </p> <ul> <li> <p>If set to <code>FOREIGN</code>, will search the tables shared with your account. </p> </li> <li> <p>If set to <code>ALL</code>, will search the tables shared with your account, as well as the tables in yor local account. </p> </li> </ul>', ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ResourceUri$ResourceType' => '<p>The type of the resource.</p>', ], ], 'ResourceUri' => [ 'base' => '<p>The URIs for function resources.</p>', 'refs' => [ 'ResourceUriList$member' => NULL, ], ], 'ResourceUriList' => [ 'base' => NULL, 'refs' => [ 'UserDefinedFunction$ResourceUris' => '<p>The resource URIs for the function.</p>', 'UserDefinedFunctionInput$ResourceUris' => '<p>The resource URIs for the function.</p>', ], ], 'ResumeWorkflowRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResumeWorkflowRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'Role' => [ 'base' => NULL, 'refs' => [ 'Crawler$Role' => '<p>The Amazon Resource Name (ARN) of an IAM role that\'s used to access customer resources, such as Amazon Simple Storage Service (Amazon S3) data.</p>', 'CreateCrawlerRequest$Role' => '<p>The IAM role or Amazon Resource Name (ARN) of an IAM role used by the new crawler to access customer resources.</p>', 'UpdateCrawlerRequest$Role' => '<p>The IAM role or Amazon Resource Name (ARN) of an IAM role that is used by the new crawler to access customer resources.</p>', ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateDevEndpointRequest$RoleArn' => '<p>The IAM role for the <code>DevEndpoint</code>.</p>', 'CreateDevEndpointResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) of the role assigned to the new <code>DevEndpoint</code>.</p>', 'DevEndpoint$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role used in this <code>DevEndpoint</code>.</p>', ], ], 'RoleString' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$Role' => '<p>The name or Amazon Resource Name (ARN) of the IAM role associated with this job.</p>', 'CreateMLTransformRequest$Role' => '<p>The name or Amazon Resource Name (ARN) of the IAM role with the required permissions. The required permissions include both AWS Glue service role permissions to AWS Glue resources, and Amazon S3 permissions required by the transform. </p> <ul> <li> <p>This role needs AWS Glue service role permissions to allow access to resources in AWS Glue. See <a href="https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html">Attach a Policy to IAM Users That Access AWS Glue</a>.</p> </li> <li> <p>This role needs permission to your Amazon Simple Storage Service (Amazon S3) sources, targets, temporary directory, scripts, and any libraries used by the task run for this transform.</p> </li> </ul>', 'GetMLTransformResponse$Role' => '<p>The name or Amazon Resource Name (ARN) of the IAM role with the required permissions.</p>', 'Job$Role' => '<p>The name or Amazon Resource Name (ARN) of the IAM role associated with this job.</p>', 'JobUpdate$Role' => '<p>The name or Amazon Resource Name (ARN) of the IAM role associated with this job (required).</p>', 'MLTransform$Role' => '<p>The name or Amazon Resource Name (ARN) of the IAM role with the required permissions. The required permissions include both AWS Glue service role permissions to AWS Glue resources, and Amazon S3 permissions required by the transform. </p> <ul> <li> <p>This role needs AWS Glue service role permissions to allow access to resources in AWS Glue. See <a href="https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html">Attach a Policy to IAM Users That Access AWS Glue</a>.</p> </li> <li> <p>This role needs permission to your Amazon Simple Storage Service (Amazon S3) sources, targets, temporary directory, scripts, and any libraries used by the task run for this transform.</p> </li> </ul>', 'UpdateMLTransformRequest$Role' => '<p>The name or Amazon Resource Name (ARN) of the IAM role with the required permissions.</p>', ], ], 'RowTag' => [ 'base' => NULL, 'refs' => [ 'CreateXMLClassifierRequest$RowTag' => '<p>The XML tag designating the element that contains each record in an XML document being parsed. This can\'t identify a self-closing element (closed by <code>/&gt;</code>). An empty row element that contains only attributes can be parsed as long as it ends with a closing tag (for example, <code>&lt;row item_a="A" item_b="B"&gt;&lt;/row&gt;</code> is okay, but <code>&lt;row item_a="A" item_b="B" /&gt;</code> is not).</p>', 'UpdateXMLClassifierRequest$RowTag' => '<p>The XML tag designating the element that contains each record in an XML document being parsed. This cannot identify a self-closing element (closed by <code>/&gt;</code>). An empty row element that contains only attributes can be parsed as long as it ends with a closing tag (for example, <code>&lt;row item_a="A" item_b="B"&gt;&lt;/row&gt;</code> is okay, but <code>&lt;row item_a="A" item_b="B" /&gt;</code> is not).</p>', 'XMLClassifier$RowTag' => '<p>The XML tag designating the element that contains each record in an XML document being parsed. This can\'t identify a self-closing element (closed by <code>/&gt;</code>). An empty row element that contains only attributes can be parsed as long as it ends with a closing tag (for example, <code>&lt;row item_a="A" item_b="B"&gt;&lt;/row&gt;</code> is okay, but <code>&lt;row item_a="A" item_b="B" /&gt;</code> is not).</p>', ], ], 'RunId' => [ 'base' => NULL, 'refs' => [ 'GetJobBookmarkRequest$RunId' => '<p>The unique run identifier associated with this job run.</p>', 'JobBookmarkEntry$PreviousRunId' => '<p>The unique run identifier associated with the previous job run.</p>', 'JobBookmarkEntry$RunId' => '<p>The run ID number.</p>', 'ResetJobBookmarkRequest$RunId' => '<p>The unique run identifier associated with this job run.</p>', ], ], 'S3Encryption' => [ 'base' => '<p>Specifies how Amazon Simple Storage Service (Amazon S3) data should be encrypted.</p>', 'refs' => [ 'S3EncryptionList$member' => NULL, ], ], 'S3EncryptionList' => [ 'base' => NULL, 'refs' => [ 'EncryptionConfiguration$S3Encryption' => '<p>The encryption configuration for Amazon Simple Storage Service (Amazon S3) data.</p>', ], ], 'S3EncryptionMode' => [ 'base' => NULL, 'refs' => [ 'S3Encryption$S3EncryptionMode' => '<p>The encryption mode to use for Amazon S3 data.</p>', ], ], 'S3Target' => [ 'base' => '<p>Specifies a data store in Amazon Simple Storage Service (Amazon S3).</p>', 'refs' => [ 'S3TargetList$member' => NULL, ], ], 'S3TargetList' => [ 'base' => NULL, 'refs' => [ 'CrawlerTargets$S3Targets' => '<p>Specifies Amazon Simple Storage Service (Amazon S3) targets.</p>', ], ], 'ScalaCode' => [ 'base' => NULL, 'refs' => [ 'CreateScriptResponse$ScalaCode' => '<p>The Scala code generated from the DAG.</p>', 'GetPlanResponse$ScalaCode' => '<p>The Scala code to perform the mapping.</p>', ], ], 'Schedule' => [ 'base' => '<p>A scheduling object using a <code>cron</code> statement to schedule an event.</p>', 'refs' => [ 'Crawler$Schedule' => '<p>For scheduled crawlers, the schedule when the crawler runs.</p>', ], ], 'ScheduleState' => [ 'base' => NULL, 'refs' => [ 'Schedule$State' => '<p>The state of the schedule.</p>', ], ], 'SchedulerNotRunningException' => [ 'base' => '<p>The specified scheduler is not running.</p>', 'refs' => [], ], 'SchedulerRunningException' => [ 'base' => '<p>The specified scheduler is already running.</p>', 'refs' => [], ], 'SchedulerTransitioningException' => [ 'base' => '<p>The specified scheduler is transitioning.</p>', 'refs' => [], ], 'SchemaChangePolicy' => [ 'base' => '<p>A policy that specifies update and deletion behaviors for the crawler.</p>', 'refs' => [ 'Crawler$SchemaChangePolicy' => '<p>The policy that specifies update and delete behaviors for the crawler.</p>', 'CreateCrawlerRequest$SchemaChangePolicy' => '<p>The policy for the crawler\'s update and deletion behavior.</p>', 'UpdateCrawlerRequest$SchemaChangePolicy' => '<p>The policy for the crawler\'s update and deletion behavior.</p>', ], ], 'SchemaColumn' => [ 'base' => '<p>A key-value pair representing a column and data type that this transform can run against. The <code>Schema</code> parameter of the <code>MLTransform</code> may contain up to 100 of these structures.</p>', 'refs' => [ 'TransformSchema$member' => NULL, ], ], 'SchemaPathString' => [ 'base' => NULL, 'refs' => [ 'MappingEntry$SourcePath' => '<p>The source path.</p>', 'MappingEntry$TargetPath' => '<p>The target path.</p>', ], ], 'ScriptLocationString' => [ 'base' => NULL, 'refs' => [ 'JobCommand$ScriptLocation' => '<p>Specifies the Amazon Simple Storage Service (Amazon S3) path to a script that executes a job.</p>', ], ], 'SearchPropertyPredicates' => [ 'base' => NULL, 'refs' => [ 'SearchTablesRequest$Filters' => '<p>A list of key-value pairs, and a comparator used to filter the search results. Returns all entities matching the predicate.</p> <p>The <code>Comparator</code> member of the <code>PropertyPredicate</code> struct is used only for time fields, and can be omitted for other field types. Also, when comparing string values, such as when <code>Key=Name</code>, a fuzzy match algorithm is used. The <code>Key</code> field (for example, the value of the <code>Name</code> field) is split on certain punctuation characters, for example, -, :, #, etc. into tokens. Then each token is exact-match compared with the <code>Value</code> member of <code>PropertyPredicate</code>. For example, if <code>Key=Name</code> and <code>Value=link</code>, tables named <code>customer-link</code> and <code>xx-link-yy</code> are returned, but <code>xxlinkyy</code> is not returned.</p>', ], ], 'SearchTablesRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchTablesResponse' => [ 'base' => NULL, 'refs' => [], ], 'SecurityConfiguration' => [ 'base' => '<p>Specifies a security configuration.</p>', 'refs' => [ 'GetSecurityConfigurationResponse$SecurityConfiguration' => '<p>The requested security configuration.</p>', 'SecurityConfigurationList$member' => NULL, ], ], 'SecurityConfigurationList' => [ 'base' => NULL, 'refs' => [ 'GetSecurityConfigurationsResponse$SecurityConfigurations' => '<p>A list of security configurations.</p>', ], ], 'SecurityGroupIdList' => [ 'base' => NULL, 'refs' => [ 'PhysicalConnectionRequirements$SecurityGroupIdList' => '<p>The security group ID list used by the connection.</p>', ], ], 'Segment' => [ 'base' => '<p>Defines a non-overlapping region of a table\'s partitions, allowing multiple requests to be executed in parallel.</p>', 'refs' => [ 'GetPartitionsRequest$Segment' => '<p>The segment of the table\'s partitions to scan in this request.</p>', ], ], 'SerDeInfo' => [ 'base' => '<p>Information about a serialization/deserialization program (SerDe) that serves as an extractor and loader.</p>', 'refs' => [ 'StorageDescriptor$SerdeInfo' => '<p>The serialization/deserialization (SerDe) information.</p>', ], ], 'SkewedInfo' => [ 'base' => '<p>Specifies skewed values in a table. Skewed values are those that occur with very high frequency.</p>', 'refs' => [ 'StorageDescriptor$SkewedInfo' => '<p>The information about values that appear frequently in a column (skewed values).</p>', ], ], 'Sort' => [ 'base' => NULL, 'refs' => [ 'SortCriterion$Sort' => '<p>An ascending or descending sort.</p>', ], ], 'SortCriteria' => [ 'base' => NULL, 'refs' => [ 'SearchTablesRequest$SortCriteria' => '<p>A list of criteria for sorting the results by a field name, in an ascending or descending order.</p>', ], ], 'SortCriterion' => [ 'base' => '<p>Specifies a field to sort by and a sort order.</p>', 'refs' => [ 'SortCriteria$member' => NULL, ], ], 'SortDirectionType' => [ 'base' => NULL, 'refs' => [ 'TaskRunSortCriteria$SortDirection' => '<p>The sort direction to be used to sort the list of task runs for the machine learning transform.</p>', 'TransformSortCriteria$SortDirection' => '<p>The sort direction to be used in the sorting criteria that are associated with the machine learning transform.</p>', ], ], 'StartCrawlerRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartCrawlerResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartCrawlerScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartCrawlerScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartExportLabelsTaskRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartExportLabelsTaskRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartImportLabelsTaskRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartImportLabelsTaskRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartJobRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartJobRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartMLEvaluationTaskRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartMLEvaluationTaskRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartMLLabelingSetGenerationTaskRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartMLLabelingSetGenerationTaskRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartTriggerRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartTriggerResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartWorkflowRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartWorkflowRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopCrawlerRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopCrawlerResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopCrawlerScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopCrawlerScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopTriggerRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopTriggerResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopWorkflowRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopWorkflowRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'StorageDescriptor' => [ 'base' => '<p>Describes the physical storage of table data.</p>', 'refs' => [ 'Partition$StorageDescriptor' => '<p>Provides information about the physical location where the partition is stored.</p>', 'PartitionInput$StorageDescriptor' => '<p>Provides information about the physical location where the partition is stored.</p>', 'Table$StorageDescriptor' => '<p>A storage descriptor containing information about the physical storage of this table.</p>', 'TableInput$StorageDescriptor' => '<p>A storage descriptor containing information about the physical storage of this table.</p>', ], ], 'StringColumnStatisticsData' => [ 'base' => '<p>Defines a string column statistics data.</p>', 'refs' => [ 'ColumnStatisticsData$StringColumnStatisticsData' => '<p>String Column Statistics Data.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'CreateDevEndpointRequest$SecurityGroupIds' => '<p>Security group IDs for the security groups to be used by the new <code>DevEndpoint</code>.</p>', 'CreateDevEndpointResponse$SecurityGroupIds' => '<p>The security groups assigned to the new <code>DevEndpoint</code>.</p>', 'DevEndpoint$SecurityGroupIds' => '<p>A list of security group identifiers used in this <code>DevEndpoint</code>.</p>', 'UpdateDevEndpointRequest$DeleteArguments' => '<p>The list of argument keys to be deleted from the map of arguments used to configure the <code>DevEndpoint</code>.</p>', ], ], 'Table' => [ 'base' => '<p>Represents a collection of related data organized in columns and rows.</p>', 'refs' => [ 'GetTableResponse$Table' => '<p>The <code>Table</code> object that defines the specified table.</p>', 'TableList$member' => NULL, 'TableVersion$Table' => '<p>The table in question.</p>', ], ], 'TableError' => [ 'base' => '<p>An error record for table operations.</p>', 'refs' => [ 'TableErrors$member' => NULL, ], ], 'TableErrors' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteTableResponse$Errors' => '<p>A list of errors encountered in attempting to delete the specified tables.</p>', ], ], 'TableIdentifier' => [ 'base' => '<p>A structure that describes a target table for resource linking.</p>', 'refs' => [ 'Table$TargetTable' => '<p>A <code>TableIdentifier</code> structure that describes a target table for resource linking.</p>', 'TableInput$TargetTable' => '<p>A <code>TableIdentifier</code> structure that describes a target table for resource linking.</p>', ], ], 'TableInput' => [ 'base' => '<p>A structure used to define a table.</p>', 'refs' => [ 'CreateTableRequest$TableInput' => '<p>The <code>TableInput</code> object that defines the metadata table to create in the catalog.</p>', 'UpdateTableRequest$TableInput' => '<p>An updated <code>TableInput</code> object to define the metadata table in the catalog.</p>', ], ], 'TableList' => [ 'base' => NULL, 'refs' => [ 'GetTablesResponse$TableList' => '<p>A list of the requested <code>Table</code> objects.</p>', 'SearchTablesResponse$TableList' => '<p>A list of the requested <code>Table</code> objects. The <code>SearchTables</code> response returns only the tables that you have access to.</p>', ], ], 'TableName' => [ 'base' => NULL, 'refs' => [ 'MappingEntry$SourceTable' => '<p>The name of the source table.</p>', 'MappingEntry$TargetTable' => '<p>The target table.</p>', ], ], 'TablePrefix' => [ 'base' => NULL, 'refs' => [ 'Crawler$TablePrefix' => '<p>The prefix added to the names of tables that are created.</p>', 'CreateCrawlerRequest$TablePrefix' => '<p>The table prefix used for catalog tables that are created.</p>', 'UpdateCrawlerRequest$TablePrefix' => '<p>The table prefix used for catalog tables that are created.</p>', ], ], 'TableTypeString' => [ 'base' => NULL, 'refs' => [ 'Table$TableType' => '<p>The type of this table (<code>EXTERNAL_TABLE</code>, <code>VIRTUAL_VIEW</code>, etc.).</p>', 'TableInput$TableType' => '<p>The type of this table (<code>EXTERNAL_TABLE</code>, <code>VIRTUAL_VIEW</code>, etc.).</p>', ], ], 'TableVersion' => [ 'base' => '<p>Specifies a version of a table.</p>', 'refs' => [ 'GetTableVersionResponse$TableVersion' => '<p>The requested table version.</p>', 'GetTableVersionsList$member' => NULL, ], ], 'TableVersionError' => [ 'base' => '<p>An error record for table-version operations.</p>', 'refs' => [ 'TableVersionErrors$member' => NULL, ], ], 'TableVersionErrors' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteTableVersionResponse$Errors' => '<p>A list of errors encountered while trying to delete the specified table versions.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeysList$member' => NULL, 'TagsMap$key' => NULL, ], ], 'TagKeysList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagsToRemove' => '<p>Tags to remove from this resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagsMap$value' => NULL, ], ], 'TagsMap' => [ 'base' => NULL, 'refs' => [ 'CreateCrawlerRequest$Tags' => '<p>The tags to use with this crawler request. You may use tags to limit access to the crawler. For more information about tags in AWS Glue, see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">AWS Tags in AWS Glue</a> in the developer guide.</p>', 'CreateDevEndpointRequest$Tags' => '<p>The tags to use with this DevEndpoint. You may use tags to limit access to the DevEndpoint. For more information about tags in AWS Glue, see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">AWS Tags in AWS Glue</a> in the developer guide.</p>', 'CreateJobRequest$Tags' => '<p>The tags to use with this job. You may use tags to limit access to the job. For more information about tags in AWS Glue, see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">AWS Tags in AWS Glue</a> in the developer guide.</p>', 'CreateMLTransformRequest$Tags' => '<p>The tags to use with this machine learning transform. You may use tags to limit access to the machine learning transform. For more information about tags in AWS Glue, see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">AWS Tags in AWS Glue</a> in the developer guide.</p>', 'CreateTriggerRequest$Tags' => '<p>The tags to use with this trigger. You may use tags to limit access to the trigger. For more information about tags in AWS Glue, see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">AWS Tags in AWS Glue</a> in the developer guide. </p>', 'CreateWorkflowRequest$Tags' => '<p>The tags to be used with this workflow.</p>', 'GetTagsResponse$Tags' => '<p>The requested tags.</p>', 'ListCrawlersRequest$Tags' => '<p>Specifies to return only these tagged resources.</p>', 'ListDevEndpointsRequest$Tags' => '<p>Specifies to return only these tagged resources.</p>', 'ListJobsRequest$Tags' => '<p>Specifies to return only these tagged resources.</p>', 'ListMLTransformsRequest$Tags' => '<p>Specifies to return only these tagged resources.</p>', 'ListTriggersRequest$Tags' => '<p>Specifies to return only these tagged resources.</p>', 'TagResourceRequest$TagsToAdd' => '<p>Tags to add to this resource.</p>', ], ], 'TaskRun' => [ 'base' => '<p>The sampling parameters that are associated with the machine learning transform.</p>', 'refs' => [ 'TaskRunList$member' => NULL, ], ], 'TaskRunFilterCriteria' => [ 'base' => '<p>The criteria that are used to filter the task runs for the machine learning transform.</p>', 'refs' => [ 'GetMLTaskRunsRequest$Filter' => '<p>The filter criteria, in the <code>TaskRunFilterCriteria</code> structure, for the task run.</p>', ], ], 'TaskRunList' => [ 'base' => NULL, 'refs' => [ 'GetMLTaskRunsResponse$TaskRuns' => '<p>A list of task runs that are associated with the transform.</p>', ], ], 'TaskRunProperties' => [ 'base' => '<p>The configuration properties for the task run.</p>', 'refs' => [ 'GetMLTaskRunResponse$Properties' => '<p>The list of properties that are associated with the task run.</p>', 'TaskRun$Properties' => '<p>Specifies configuration properties associated with this task run.</p>', ], ], 'TaskRunSortColumnType' => [ 'base' => NULL, 'refs' => [ 'TaskRunSortCriteria$Column' => '<p>The column to be used to sort the list of task runs for the machine learning transform.</p>', ], ], 'TaskRunSortCriteria' => [ 'base' => '<p>The sorting criteria that are used to sort the list of task runs for the machine learning transform.</p>', 'refs' => [ 'GetMLTaskRunsRequest$Sort' => '<p>The sorting criteria, in the <code>TaskRunSortCriteria</code> structure, for the task run.</p>', ], ], 'TaskStatusType' => [ 'base' => NULL, 'refs' => [ 'CancelMLTaskRunResponse$Status' => '<p>The status for this run.</p>', 'GetMLTaskRunResponse$Status' => '<p>The status for this task run.</p>', 'TaskRun$Status' => '<p>The current status of the requested task run.</p>', 'TaskRunFilterCriteria$Status' => '<p>The current status of the task run.</p>', ], ], 'TaskType' => [ 'base' => NULL, 'refs' => [ 'TaskRunFilterCriteria$TaskRunType' => '<p>The type of task run.</p>', 'TaskRunProperties$TaskType' => '<p>The type of task run.</p>', ], ], 'Timeout' => [ 'base' => NULL, 'refs' => [ 'Action$Timeout' => '<p>The <code>JobRun</code> timeout in minutes. This is the maximum time that a job run can consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours). This overrides the timeout value set in the parent job.</p>', 'CreateJobRequest$Timeout' => '<p>The job timeout in minutes. This is the maximum time that a job run can consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).</p>', 'CreateMLTransformRequest$Timeout' => '<p>The timeout of the task run for this transform in minutes. This is the maximum time that a task run for this transform can consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).</p>', 'GetMLTransformResponse$Timeout' => '<p>The timeout for a task run for this transform in minutes. This is the maximum time that a task run for this transform can consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).</p>', 'Job$Timeout' => '<p>The job timeout in minutes. This is the maximum time that a job run can consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).</p>', 'JobRun$Timeout' => '<p>The <code>JobRun</code> timeout in minutes. This is the maximum time that a job run can consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours). This overrides the timeout value set in the parent job.</p>', 'JobUpdate$Timeout' => '<p>The job timeout in minutes. This is the maximum time that a job run can consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).</p>', 'MLTransform$Timeout' => '<p>The timeout in minutes of the machine learning transform.</p>', 'StartJobRunRequest$Timeout' => '<p>The <code>JobRun</code> timeout in minutes. This is the maximum time that a job run can consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours). This overrides the timeout value set in the parent job.</p>', 'UpdateMLTransformRequest$Timeout' => '<p>The timeout for a task run for this transform in minutes. This is the maximum time that a task run for this transform can consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'CatalogImportStatus$ImportTime' => '<p>The time that the migration was started.</p>', 'ColumnStatistics$AnalyzedTime' => '<p>The analyzed time of the column statistics.</p>', 'Connection$CreationTime' => '<p>The time that this connection definition was created.</p>', 'Connection$LastUpdatedTime' => '<p>The last time that this connection definition was updated.</p>', 'Crawler$CreationTime' => '<p>The time that the crawler was created.</p>', 'Crawler$LastUpdated' => '<p>The time that the crawler was last updated.</p>', 'CsvClassifier$CreationTime' => '<p>The time that this classifier was registered.</p>', 'CsvClassifier$LastUpdated' => '<p>The time that this classifier was last updated.</p>', 'Database$CreateTime' => '<p>The time at which the metadata database was created in the catalog.</p>', 'DateColumnStatisticsData$MinimumValue' => '<p>Minimum value of the column.</p>', 'DateColumnStatisticsData$MaximumValue' => '<p>Maximum value of the column.</p>', 'GetMLTaskRunResponse$StartedOn' => '<p>The date and time when this task run started.</p>', 'GetMLTaskRunResponse$LastModifiedOn' => '<p>The date and time when this task run was last modified.</p>', 'GetMLTaskRunResponse$CompletedOn' => '<p>The date and time when this task run was completed.</p>', 'GetMLTransformResponse$CreatedOn' => '<p>The date and time when the transform was created.</p>', 'GetMLTransformResponse$LastModifiedOn' => '<p>The date and time when the transform was last modified.</p>', 'GetResourcePolicyResponse$CreateTime' => '<p>The date and time at which the policy was created.</p>', 'GetResourcePolicyResponse$UpdateTime' => '<p>The date and time at which the policy was last updated.</p>', 'GluePolicy$CreateTime' => '<p>The date and time at which the policy was created.</p>', 'GluePolicy$UpdateTime' => '<p>The date and time at which the policy was last updated.</p>', 'GrokClassifier$CreationTime' => '<p>The time that this classifier was registered.</p>', 'GrokClassifier$LastUpdated' => '<p>The time that this classifier was last updated.</p>', 'JsonClassifier$CreationTime' => '<p>The time that this classifier was registered.</p>', 'JsonClassifier$LastUpdated' => '<p>The time that this classifier was last updated.</p>', 'LastCrawlInfo$StartTime' => '<p>The time at which the crawl started.</p>', 'MLTransform$CreatedOn' => '<p>A timestamp. The time and date that this machine learning transform was created.</p>', 'MLTransform$LastModifiedOn' => '<p>A timestamp. The last point in time when this machine learning transform was modified.</p>', 'Partition$CreationTime' => '<p>The time at which the partition was created.</p>', 'Partition$LastAccessTime' => '<p>The last time at which the partition was accessed.</p>', 'Partition$LastAnalyzedTime' => '<p>The last time at which column statistics were computed for this partition.</p>', 'PartitionInput$LastAccessTime' => '<p>The last time at which the partition was accessed.</p>', 'PartitionInput$LastAnalyzedTime' => '<p>The last time at which column statistics were computed for this partition.</p>', 'Table$CreateTime' => '<p>The time when the table definition was created in the Data Catalog.</p>', 'Table$UpdateTime' => '<p>The last time that the table was updated.</p>', 'Table$LastAccessTime' => '<p>The last time that the table was accessed. This is usually taken from HDFS, and might not be reliable.</p>', 'Table$LastAnalyzedTime' => '<p>The last time that column statistics were computed for this table.</p>', 'TableInput$LastAccessTime' => '<p>The last time that the table was accessed.</p>', 'TableInput$LastAnalyzedTime' => '<p>The last time that column statistics were computed for this table.</p>', 'TaskRun$StartedOn' => '<p>The date and time that this task run started.</p>', 'TaskRun$LastModifiedOn' => '<p>The last point in time that the requested task run was updated.</p>', 'TaskRun$CompletedOn' => '<p>The last point in time that the requested task run was completed.</p>', 'TaskRunFilterCriteria$StartedBefore' => '<p>Filter on task runs started before this date.</p>', 'TaskRunFilterCriteria$StartedAfter' => '<p>Filter on task runs started after this date.</p>', 'TransformFilterCriteria$CreatedBefore' => '<p>The time and date before which the transforms were created.</p>', 'TransformFilterCriteria$CreatedAfter' => '<p>The time and date after which the transforms were created.</p>', 'TransformFilterCriteria$LastModifiedBefore' => '<p>Filter on transforms last modified before this date.</p>', 'TransformFilterCriteria$LastModifiedAfter' => '<p>Filter on transforms last modified after this date.</p>', 'UserDefinedFunction$CreateTime' => '<p>The time at which the function was created.</p>', 'XMLClassifier$CreationTime' => '<p>The time that this classifier was registered.</p>', 'XMLClassifier$LastUpdated' => '<p>The time that this classifier was last updated.</p>', ], ], 'TimestampValue' => [ 'base' => NULL, 'refs' => [ 'Crawl$StartedOn' => '<p>The date and time on which the crawl started.</p>', 'Crawl$CompletedOn' => '<p>The date and time on which the crawl completed.</p>', 'CreateDevEndpointResponse$CreatedTimestamp' => '<p>The point in time at which this <code>DevEndpoint</code> was created.</p>', 'CreateSecurityConfigurationResponse$CreatedTimestamp' => '<p>The time at which the new security configuration was created.</p>', 'DevEndpoint$CreatedTimestamp' => '<p>The point in time at which this DevEndpoint was created.</p>', 'DevEndpoint$LastModifiedTimestamp' => '<p>The point in time at which this <code>DevEndpoint</code> was last modified.</p>', 'Job$CreatedOn' => '<p>The time and date that this job definition was created.</p>', 'Job$LastModifiedOn' => '<p>The last point in time when this job definition was modified.</p>', 'JobRun$StartedOn' => '<p>The date and time at which this job run was started.</p>', 'JobRun$LastModifiedOn' => '<p>The last time that this job run was modified.</p>', 'JobRun$CompletedOn' => '<p>The date and time that this job run completed.</p>', 'SecurityConfiguration$CreatedTimeStamp' => '<p>The time at which this security configuration was created.</p>', 'Workflow$CreatedOn' => '<p>The date and time when the workflow was created.</p>', 'Workflow$LastModifiedOn' => '<p>The date and time when the workflow was last modified.</p>', 'WorkflowRun$StartedOn' => '<p>The date and time when the workflow run was started.</p>', 'WorkflowRun$CompletedOn' => '<p>The date and time when the workflow run completed.</p>', ], ], 'Token' => [ 'base' => NULL, 'refs' => [ 'GetClassifiersRequest$NextToken' => '<p>An optional continuation token.</p>', 'GetClassifiersResponse$NextToken' => '<p>A continuation token.</p>', 'GetConnectionsRequest$NextToken' => '<p>A continuation token, if this is a continuation call.</p>', 'GetConnectionsResponse$NextToken' => '<p>A continuation token, if the list of connections returned does not include the last of the filtered connections.</p>', 'GetCrawlerMetricsRequest$NextToken' => '<p>A continuation token, if this is a continuation call.</p>', 'GetCrawlerMetricsResponse$NextToken' => '<p>A continuation token, if the returned list does not contain the last metric available.</p>', 'GetCrawlersRequest$NextToken' => '<p>A continuation token, if this is a continuation request.</p>', 'GetCrawlersResponse$NextToken' => '<p>A continuation token, if the returned list has not reached the end of those defined in this customer account.</p>', 'GetDatabasesRequest$NextToken' => '<p>A continuation token, if this is a continuation call.</p>', 'GetDatabasesResponse$NextToken' => '<p>A continuation token for paginating the returned list of tokens, returned if the current segment of the list is not the last.</p>', 'GetPartitionsRequest$NextToken' => '<p>A continuation token, if this is not the first call to retrieve these partitions.</p>', 'GetPartitionsResponse$NextToken' => '<p>A continuation token, if the returned list of partitions does not include the last one.</p>', 'GetResourcePoliciesRequest$NextToken' => '<p>A continuation token, if this is a continuation request.</p>', 'GetResourcePoliciesResponse$NextToken' => '<p>A continuation token, if the returned list does not contain the last resource policy available.</p>', 'GetTableVersionsRequest$NextToken' => '<p>A continuation token, if this is not the first call.</p>', 'GetTableVersionsResponse$NextToken' => '<p>A continuation token, if the list of available versions does not include the last one.</p>', 'GetTablesRequest$NextToken' => '<p>A continuation token, included if this is a continuation call.</p>', 'GetTablesResponse$NextToken' => '<p>A continuation token, present if the current list segment is not the last.</p>', 'GetUserDefinedFunctionsRequest$NextToken' => '<p>A continuation token, if this is a continuation call.</p>', 'GetUserDefinedFunctionsResponse$NextToken' => '<p>A continuation token, if the list of functions returned does not include the last requested function.</p>', 'ListCrawlersRequest$NextToken' => '<p>A continuation token, if this is a continuation request.</p>', 'ListCrawlersResponse$NextToken' => '<p>A continuation token, if the returned list does not contain the last metric available.</p>', 'SearchTablesRequest$NextToken' => '<p>A continuation token, included if this is a continuation call.</p>', 'SearchTablesResponse$NextToken' => '<p>A continuation token, present if the current list segment is not the last.</p>', ], ], 'TotalSegmentsInteger' => [ 'base' => NULL, 'refs' => [ 'Segment$TotalSegments' => '<p>The total number of segments.</p>', ], ], 'TransformFilterCriteria' => [ 'base' => '<p>The criteria used to filter the machine learning transforms.</p>', 'refs' => [ 'GetMLTransformsRequest$Filter' => '<p>The filter transformation criteria.</p>', 'ListMLTransformsRequest$Filter' => '<p>A <code>TransformFilterCriteria</code> used to filter the machine learning transforms.</p>', ], ], 'TransformIdList' => [ 'base' => NULL, 'refs' => [ 'ListMLTransformsResponse$TransformIds' => '<p>The identifiers of all the machine learning transforms in the account, or the machine learning transforms with the specified tags.</p>', ], ], 'TransformList' => [ 'base' => NULL, 'refs' => [ 'GetMLTransformsResponse$Transforms' => '<p>A list of machine learning transforms.</p>', ], ], 'TransformParameters' => [ 'base' => '<p>The algorithm-specific parameters that are associated with the machine learning transform.</p>', 'refs' => [ 'CreateMLTransformRequest$Parameters' => '<p>The algorithmic parameters that are specific to the transform type used. Conditionally dependent on the transform type.</p>', 'GetMLTransformResponse$Parameters' => '<p>The configuration parameters that are specific to the algorithm used.</p>', 'MLTransform$Parameters' => '<p>A <code>TransformParameters</code> object. You can use parameters to tune (customize) the behavior of the machine learning transform by specifying what data it learns from and your preference on various tradeoffs (such as precious vs. recall, or accuracy vs. cost).</p>', 'UpdateMLTransformRequest$Parameters' => '<p>The configuration parameters that are specific to the transform type (algorithm) used. Conditionally dependent on the transform type.</p>', ], ], 'TransformSchema' => [ 'base' => NULL, 'refs' => [ 'GetMLTransformResponse$Schema' => '<p>The <code>Map&lt;Column, Type&gt;</code> object that represents the schema that this transform accepts. Has an upper bound of 100 columns.</p>', 'MLTransform$Schema' => '<p>A map of key-value pairs representing the columns and data types that this transform can run against. Has an upper bound of 100 columns.</p>', 'TransformFilterCriteria$Schema' => '<p>Filters on datasets with a specific schema. The <code>Map&lt;Column, Type&gt;</code> object is an array of key-value pairs representing the schema this transform accepts, where <code>Column</code> is the name of a column, and <code>Type</code> is the type of the data such as an integer or string. Has an upper bound of 100 columns.</p>', ], ], 'TransformSortColumnType' => [ 'base' => NULL, 'refs' => [ 'TransformSortCriteria$Column' => '<p>The column to be used in the sorting criteria that are associated with the machine learning transform.</p>', ], ], 'TransformSortCriteria' => [ 'base' => '<p>The sorting criteria that are associated with the machine learning transform.</p>', 'refs' => [ 'GetMLTransformsRequest$Sort' => '<p>The sorting criteria.</p>', 'ListMLTransformsRequest$Sort' => '<p>A <code>TransformSortCriteria</code> used to sort the machine learning transforms.</p>', ], ], 'TransformStatusType' => [ 'base' => NULL, 'refs' => [ 'GetMLTransformResponse$Status' => '<p>The last known status of the transform (to indicate whether it can be used or not). One of "NOT_READY", "READY", or "DELETING".</p>', 'MLTransform$Status' => '<p>The current status of the machine learning transform.</p>', 'TransformFilterCriteria$Status' => '<p>Filters the list of machine learning transforms by the last known status of the transforms (to indicate whether a transform can be used or not). One of "NOT_READY", "READY", or "DELETING".</p>', ], ], 'TransformType' => [ 'base' => NULL, 'refs' => [ 'EvaluationMetrics$TransformType' => '<p>The type of machine learning transform.</p>', 'TransformFilterCriteria$TransformType' => '<p>The type of machine learning transform that is used to filter the machine learning transforms.</p>', 'TransformParameters$TransformType' => '<p>The type of machine learning transform.</p> <p>For information about the types of machine learning transforms, see <a href="http://docs.aws.amazon.com/glue/latest/dg/add-job-machine-learning-transform.html">Creating Machine Learning Transforms</a>.</p>', ], ], 'Trigger' => [ 'base' => '<p>Information about a specific trigger.</p>', 'refs' => [ 'GetTriggerResponse$Trigger' => '<p>The requested trigger definition.</p>', 'TriggerList$member' => NULL, 'TriggerNodeDetails$Trigger' => '<p>The information of the trigger represented by the trigger node.</p>', 'UpdateTriggerResponse$Trigger' => '<p>The resulting trigger definition.</p>', ], ], 'TriggerList' => [ 'base' => NULL, 'refs' => [ 'BatchGetTriggersResponse$Triggers' => '<p>A list of trigger definitions.</p>', 'GetTriggersResponse$Triggers' => '<p>A list of triggers for the specified job.</p>', ], ], 'TriggerNameList' => [ 'base' => NULL, 'refs' => [ 'BatchGetTriggersRequest$TriggerNames' => '<p>A list of trigger names, which may be the names returned from the <code>ListTriggers</code> operation.</p>', 'BatchGetTriggersResponse$TriggersNotFound' => '<p>A list of names of triggers not found.</p>', 'ListTriggersResponse$TriggerNames' => '<p>The names of all triggers in the account, or the triggers with the specified tags.</p>', ], ], 'TriggerNodeDetails' => [ 'base' => '<p>The details of a Trigger node present in the workflow.</p>', 'refs' => [ 'Node$TriggerDetails' => '<p>Details of the Trigger when the node represents a Trigger.</p>', ], ], 'TriggerState' => [ 'base' => NULL, 'refs' => [ 'Trigger$State' => '<p>The current state of the trigger.</p>', ], ], 'TriggerType' => [ 'base' => NULL, 'refs' => [ 'CreateTriggerRequest$Type' => '<p>The type of the new trigger.</p>', 'Trigger$Type' => '<p>The type of trigger that this is.</p>', ], ], 'TriggerUpdate' => [ 'base' => '<p>A structure used to provide information used to update a trigger. This object updates the previous trigger definition by overwriting it completely.</p>', 'refs' => [ 'UpdateTriggerRequest$TriggerUpdate' => '<p>The new values with which to update the trigger.</p>', ], ], 'TypeString' => [ 'base' => NULL, 'refs' => [ 'ColumnStatistics$ColumnType' => '<p>The type of the column.</p>', ], ], 'URI' => [ 'base' => NULL, 'refs' => [ 'Database$LocationUri' => '<p>The location of the database (for example, an HDFS path).</p>', 'DatabaseInput$LocationUri' => '<p>The location of the database (for example, an HDFS path). </p>', 'ResourceUri$Uri' => '<p>The URI for accessing the resource.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateBehavior' => [ 'base' => NULL, 'refs' => [ 'SchemaChangePolicy$UpdateBehavior' => '<p>The update behavior when the crawler finds a changed schema.</p>', ], ], 'UpdateClassifierRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateClassifierResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateColumnStatisticsForPartitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateColumnStatisticsForPartitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateColumnStatisticsForTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateColumnStatisticsForTableResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateColumnStatisticsList' => [ 'base' => NULL, 'refs' => [ 'UpdateColumnStatisticsForPartitionRequest$ColumnStatisticsList' => '<p>A list of the column statistics.</p>', 'UpdateColumnStatisticsForTableRequest$ColumnStatisticsList' => '<p>A list of the column statistics.</p>', ], ], 'UpdateConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateConnectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCrawlerRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCrawlerResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCrawlerScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCrawlerScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCsvClassifierRequest' => [ 'base' => '<p>Specifies a custom CSV classifier to be updated.</p>', 'refs' => [ 'UpdateClassifierRequest$CsvClassifier' => '<p>A <code>CsvClassifier</code> object with updated fields.</p>', ], ], 'UpdateDatabaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDatabaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDevEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDevEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGrokClassifierRequest' => [ 'base' => '<p>Specifies a grok classifier to update when passed to <code>UpdateClassifier</code>.</p>', 'refs' => [ 'UpdateClassifierRequest$GrokClassifier' => '<p>A <code>GrokClassifier</code> object with updated fields.</p>', ], ], 'UpdateJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateJsonClassifierRequest' => [ 'base' => '<p>Specifies a JSON classifier to be updated.</p>', 'refs' => [ 'UpdateClassifierRequest$JsonClassifier' => '<p>A <code>JsonClassifier</code> object with updated fields.</p>', ], ], 'UpdateMLTransformRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMLTransformResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePartitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePartitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTableResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTriggerRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTriggerResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserDefinedFunctionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserDefinedFunctionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkflowRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkflowResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateXMLClassifierRequest' => [ 'base' => '<p>Specifies an XML classifier to be updated.</p>', 'refs' => [ 'UpdateClassifierRequest$XMLClassifier' => '<p>An <code>XMLClassifier</code> object with updated fields.</p>', ], ], 'UriString' => [ 'base' => NULL, 'refs' => [ 'CreateJobRequest$LogUri' => '<p>This field is reserved for future use.</p>', 'ExportLabelsTaskRunProperties$OutputS3Path' => '<p>The Amazon Simple Storage Service (Amazon S3) path where you will export the labels.</p>', 'ImportLabelsTaskRunProperties$InputS3Path' => '<p>The Amazon Simple Storage Service (Amazon S3) path from where you will import the labels.</p>', 'Job$LogUri' => '<p>This field is reserved for future use.</p>', 'JobUpdate$LogUri' => '<p>This field is reserved for future use.</p>', 'LabelingSetGenerationTaskRunProperties$OutputS3Path' => '<p>The Amazon Simple Storage Service (Amazon S3) path where you will generate the labeling set.</p>', 'StartExportLabelsTaskRunRequest$OutputS3Path' => '<p>The Amazon S3 path where you export the labels.</p>', 'StartImportLabelsTaskRunRequest$InputS3Path' => '<p>The Amazon Simple Storage Service (Amazon S3) path from where you import the labels.</p>', 'StartMLLabelingSetGenerationTaskRunRequest$OutputS3Path' => '<p>The Amazon Simple Storage Service (Amazon S3) path where you generate the labeling set.</p>', ], ], 'UserDefinedFunction' => [ 'base' => '<p>Represents the equivalent of a Hive user-defined function (<code>UDF</code>) definition.</p>', 'refs' => [ 'GetUserDefinedFunctionResponse$UserDefinedFunction' => '<p>The requested function definition.</p>', 'UserDefinedFunctionList$member' => NULL, ], ], 'UserDefinedFunctionInput' => [ 'base' => '<p>A structure used to create or update a user-defined function.</p>', 'refs' => [ 'CreateUserDefinedFunctionRequest$FunctionInput' => '<p>A <code>FunctionInput</code> object that defines the function to create in the Data Catalog.</p>', 'UpdateUserDefinedFunctionRequest$FunctionInput' => '<p>A <code>FunctionInput</code> object that redefines the function in the Data Catalog.</p>', ], ], 'UserDefinedFunctionList' => [ 'base' => NULL, 'refs' => [ 'GetUserDefinedFunctionsResponse$UserDefinedFunctions' => '<p>A list of requested function definitions.</p>', ], ], 'ValidationException' => [ 'base' => '<p>A value could not be validated.</p>', 'refs' => [], ], 'ValueString' => [ 'base' => NULL, 'refs' => [ 'BoundedPartitionValueList$member' => NULL, 'ConnectionProperties$value' => NULL, 'PropertyPredicate$Key' => '<p>The key of the property.</p>', 'PropertyPredicate$Value' => '<p>The value of the property.</p>', 'SearchTablesRequest$SearchText' => '<p>A string used for a text search.</p> <p>Specifying a value in quotes filters based on an exact match to the value.</p>', 'SortCriterion$FieldName' => '<p>The name of the field on which to sort.</p>', 'ValueStringList$member' => NULL, ], ], 'ValueStringList' => [ 'base' => NULL, 'refs' => [ 'DeleteColumnStatisticsForPartitionRequest$PartitionValues' => '<p>A list of partition values identifying the partition.</p>', 'DeletePartitionRequest$PartitionValues' => '<p>The values that define the partition.</p>', 'GetColumnStatisticsForPartitionRequest$PartitionValues' => '<p>A list of partition values identifying the partition.</p>', 'GetPartitionRequest$PartitionValues' => '<p>The values that define the partition.</p>', 'Partition$Values' => '<p>The values of the partition.</p>', 'PartitionError$PartitionValues' => '<p>The values that define the partition.</p>', 'PartitionInput$Values' => '<p>The values of the partition. Although this parameter is not required by the SDK, you must specify this parameter for a valid input.</p> <p>The values for the keys for the new partition must be passed as an array of String objects that must be ordered in the same order as the partition keys appearing in the Amazon S3 prefix. Otherwise AWS Glue will add the values to the wrong keys.</p>', 'PartitionValueList$Values' => '<p>The list of values.</p>', 'UpdateColumnStatisticsForPartitionRequest$PartitionValues' => '<p>A list of partition values identifying the partition.</p>', ], ], 'VersionId' => [ 'base' => NULL, 'refs' => [ 'Crawler$Version' => '<p>The version of the crawler.</p>', 'CsvClassifier$Version' => '<p>The version of this classifier.</p>', 'GrokClassifier$Version' => '<p>The version of this classifier.</p>', 'JsonClassifier$Version' => '<p>The version of this classifier.</p>', 'XMLClassifier$Version' => '<p>The version of this classifier.</p>', ], ], 'VersionMismatchException' => [ 'base' => '<p>There was a version conflict.</p>', 'refs' => [], ], 'VersionString' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteTableVersionList$member' => NULL, 'DeleteTableVersionRequest$VersionId' => '<p>The ID of the table version to be deleted. A <code>VersionID</code> is a string representation of an integer. Each version is incremented by 1.</p>', 'GetTableVersionRequest$VersionId' => '<p>The ID value of the table version to be retrieved. A <code>VersionID</code> is a string representation of an integer. Each version is incremented by 1. </p>', 'TableVersion$VersionId' => '<p>The ID value that identifies this table version. A <code>VersionId</code> is a string representation of an integer. Each version is incremented by 1.</p>', 'TableVersionError$VersionId' => '<p>The ID value of the version in question. A <code>VersionID</code> is a string representation of an integer. Each version is incremented by 1.</p>', ], ], 'ViewTextString' => [ 'base' => NULL, 'refs' => [ 'Table$ViewOriginalText' => '<p>If the table is a view, the original text of the view; otherwise <code>null</code>.</p>', 'Table$ViewExpandedText' => '<p>If the table is a view, the expanded text of the view; otherwise <code>null</code>.</p>', 'TableInput$ViewOriginalText' => '<p>If the table is a view, the original text of the view; otherwise <code>null</code>.</p>', 'TableInput$ViewExpandedText' => '<p>If the table is a view, the expanded text of the view; otherwise <code>null</code>.</p>', ], ], 'WorkerType' => [ 'base' => NULL, 'refs' => [ 'CreateDevEndpointRequest$WorkerType' => '<p>The type of predefined worker that is allocated to the development endpoint. Accepts a value of Standard, G.1X, or G.2X.</p> <ul> <li> <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p> </li> <li> <p>For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p> </li> <li> <p>For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p> </li> </ul> <p>Known issue: when a development endpoint is created with the <code>G.2X</code> <code>WorkerType</code> configuration, the Spark drivers for the development endpoint will run on 4 vCPU, 16 GB of memory, and a 64 GB disk. </p>', 'CreateDevEndpointResponse$WorkerType' => '<p>The type of predefined worker that is allocated to the development endpoint. May be a value of Standard, G.1X, or G.2X.</p>', 'CreateJobRequest$WorkerType' => '<p>The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, or G.2X.</p> <ul> <li> <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p> </li> <li> <p>For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p> </li> <li> <p>For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p> </li> </ul>', 'CreateMLTransformRequest$WorkerType' => '<p>The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X, or G.2X.</p> <ul> <li> <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p> </li> <li> <p>For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1 executor per worker.</p> </li> <li> <p>For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.</p> </li> </ul> <p> <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and <code>WorkerType</code>.</p> <ul> <li> <p>If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be set.</p> </li> <li> <p>If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be set.</p> </li> <li> <p>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</p> </li> <li> <p> <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.</p> </li> </ul>', 'DevEndpoint$WorkerType' => '<p>The type of predefined worker that is allocated to the development endpoint. Accepts a value of Standard, G.1X, or G.2X.</p> <ul> <li> <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p> </li> <li> <p>For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p> </li> <li> <p>For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p> </li> </ul> <p>Known issue: when a development endpoint is created with the <code>G.2X</code> <code>WorkerType</code> configuration, the Spark drivers for the development endpoint will run on 4 vCPU, 16 GB of memory, and a 64 GB disk. </p>', 'GetMLTransformResponse$WorkerType' => '<p>The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X, or G.2X.</p> <ul> <li> <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p> </li> <li> <p>For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1 executor per worker.</p> </li> <li> <p>For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.</p> </li> </ul>', 'Job$WorkerType' => '<p>The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, or G.2X.</p> <ul> <li> <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p> </li> <li> <p>For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p> </li> <li> <p>For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p> </li> </ul>', 'JobRun$WorkerType' => '<p>The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, or G.2X.</p> <ul> <li> <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p> </li> <li> <p>For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1 executor per worker.</p> </li> <li> <p>For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.</p> </li> </ul>', 'JobUpdate$WorkerType' => '<p>The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, or G.2X.</p> <ul> <li> <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p> </li> <li> <p>For the <code>G.1X</code> worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p> </li> <li> <p>For the <code>G.2X</code> worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. We recommend this worker type for memory-intensive jobs.</p> </li> </ul>', 'MLTransform$WorkerType' => '<p>The type of predefined worker that is allocated when a task of this transform runs. Accepts a value of Standard, G.1X, or G.2X.</p> <ul> <li> <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p> </li> <li> <p>For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1 executor per worker.</p> </li> <li> <p>For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.</p> </li> </ul> <p> <code>MaxCapacity</code> is a mutually exclusive option with <code>NumberOfWorkers</code> and <code>WorkerType</code>.</p> <ul> <li> <p>If either <code>NumberOfWorkers</code> or <code>WorkerType</code> is set, then <code>MaxCapacity</code> cannot be set.</p> </li> <li> <p>If <code>MaxCapacity</code> is set then neither <code>NumberOfWorkers</code> or <code>WorkerType</code> can be set.</p> </li> <li> <p>If <code>WorkerType</code> is set, then <code>NumberOfWorkers</code> is required (and vice versa).</p> </li> <li> <p> <code>MaxCapacity</code> and <code>NumberOfWorkers</code> must both be at least 1.</p> </li> </ul>', 'StartJobRunRequest$WorkerType' => '<p>The type of predefined worker that is allocated when a job runs. Accepts a value of Standard, G.1X, or G.2X.</p> <ul> <li> <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p> </li> <li> <p>For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1 executor per worker.</p> </li> <li> <p>For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.</p> </li> </ul>', 'UpdateMLTransformRequest$WorkerType' => '<p>The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X, or G.2X.</p> <ul> <li> <p>For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.</p> </li> <li> <p>For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1 executor per worker.</p> </li> <li> <p>For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.</p> </li> </ul>', ], ], 'Workflow' => [ 'base' => '<p>A workflow represents a flow in which AWS Glue components should be executed to complete a logical task.</p>', 'refs' => [ 'GetWorkflowResponse$Workflow' => '<p>The resource metadata for the workflow.</p>', 'Workflows$member' => NULL, ], ], 'WorkflowGraph' => [ 'base' => '<p>A workflow graph represents the complete workflow containing all the AWS Glue components present in the workflow and all the directed connections between them.</p>', 'refs' => [ 'Workflow$Graph' => '<p>The graph representing all the AWS Glue components that belong to the workflow as nodes and directed connections between them as edges.</p>', 'WorkflowRun$Graph' => '<p>The graph representing all the AWS Glue components that belong to the workflow as nodes and directed connections between them as edges.</p>', ], ], 'WorkflowNames' => [ 'base' => NULL, 'refs' => [ 'BatchGetWorkflowsRequest$Names' => '<p>A list of workflow names, which may be the names returned from the <code>ListWorkflows</code> operation.</p>', 'BatchGetWorkflowsResponse$MissingWorkflows' => '<p>A list of names of workflows not found.</p>', 'ListWorkflowsResponse$Workflows' => '<p>List of names of workflows in the account.</p>', ], ], 'WorkflowRun' => [ 'base' => '<p>A workflow run is an execution of a workflow providing all the runtime information.</p>', 'refs' => [ 'GetWorkflowRunResponse$Run' => '<p>The requested workflow run metadata.</p>', 'Workflow$LastRun' => '<p>The information about the last execution of the workflow.</p>', 'WorkflowRuns$member' => NULL, ], ], 'WorkflowRunProperties' => [ 'base' => NULL, 'refs' => [ 'CreateWorkflowRequest$DefaultRunProperties' => '<p>A collection of properties to be used as part of each execution of the workflow.</p>', 'GetWorkflowRunPropertiesResponse$RunProperties' => '<p>The workflow run properties which were set during the specified run.</p>', 'PutWorkflowRunPropertiesRequest$RunProperties' => '<p>The properties to put for the specified run.</p>', 'UpdateWorkflowRequest$DefaultRunProperties' => '<p>A collection of properties to be used as part of each execution of the workflow.</p>', 'Workflow$DefaultRunProperties' => '<p>A collection of properties to be used as part of each execution of the workflow.</p>', 'WorkflowRun$WorkflowRunProperties' => '<p>The workflow run properties which were set during the run.</p>', ], ], 'WorkflowRunStatistics' => [ 'base' => '<p>Workflow run statistics provides statistics about the workflow run.</p>', 'refs' => [ 'WorkflowRun$Statistics' => '<p>The statistics of the run.</p>', ], ], 'WorkflowRunStatus' => [ 'base' => NULL, 'refs' => [ 'WorkflowRun$Status' => '<p>The status of the workflow run.</p>', ], ], 'WorkflowRuns' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowRunsResponse$Runs' => '<p>A list of workflow run metadata objects.</p>', ], ], 'Workflows' => [ 'base' => NULL, 'refs' => [ 'BatchGetWorkflowsResponse$Workflows' => '<p>A list of workflow resource metadata.</p>', ], ], 'XMLClassifier' => [ 'base' => '<p>A classifier for <code>XML</code> content.</p>', 'refs' => [ 'Classifier$XMLClassifier' => '<p>A classifier for XML content.</p>', ], ], ],];
