<?php
// This file was auto-generated from sdk-root/src/data/forecast/2018-06-26/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Provides APIs for creating and managing Amazon Forecast resources.</p>', 'operations' => [ 'CreateDataset' => '<p>Creates an Amazon Forecast dataset. The information about the dataset that you provide helps Forecast understand how to consume the data for model training. This includes the following:</p> <ul> <li> <p> <i> <code>DataFrequency</code> </i> - How frequently your historical time-series data is collected.</p> </li> <li> <p> <i> <code>Domain</code> </i> and <i> <code>DatasetType</code> </i> - Each dataset has an associated dataset domain and a type within the domain. Amazon Forecast provides a list of predefined domains and types within each domain. For each unique dataset domain and type within the domain, Amazon Forecast requires your data to include a minimum set of predefined fields.</p> </li> <li> <p> <i> <code>Schema</code> </i> - A schema specifies the fields in the dataset, including the field name and data type.</p> </li> </ul> <p>After creating a dataset, you import your training data into it and add the dataset to a dataset group. You use the dataset group to create a predictor. For more information, see <a>howitworks-datasets-groups</a>.</p> <p>To get a list of all your datasets, use the <a>ListDatasets</a> operation.</p> <p>For example Forecast datasets, see the <a href="https://github.com/aws-samples/amazon-forecast-samples">Amazon Forecast Sample GitHub repository</a>.</p> <note> <p>The <code>Status</code> of a dataset must be <code>ACTIVE</code> before you can import training data. Use the <a>DescribeDataset</a> operation to get the status.</p> </note>', 'CreateDatasetGroup' => '<p>Creates a dataset group, which holds a collection of related datasets. You can add datasets to the dataset group when you create the dataset group, or later by using the <a>UpdateDatasetGroup</a> operation.</p> <p>After creating a dataset group and adding datasets, you use the dataset group when you create a predictor. For more information, see <a>howitworks-datasets-groups</a>.</p> <p>To get a list of all your datasets groups, use the <a>ListDatasetGroups</a> operation.</p> <note> <p>The <code>Status</code> of a dataset group must be <code>ACTIVE</code> before you can create use the dataset group to create a predictor. To get the status, use the <a>DescribeDatasetGroup</a> operation.</p> </note>', 'CreateDatasetImportJob' => '<p>Imports your training data to an Amazon Forecast dataset. You provide the location of your training data in an Amazon Simple Storage Service (Amazon S3) bucket and the Amazon Resource Name (ARN) of the dataset that you want to import the data to.</p> <p>You must specify a <a>DataSource</a> object that includes an AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access the data, as Amazon Forecast makes a copy of your data and processes it in an internal AWS system. For more information, see <a>aws-forecast-iam-roles</a>.</p> <p>The training data must be in CSV format. The delimiter must be a comma (,).</p> <p>You can specify the path to a specific CSV file, the S3 bucket, or to a folder in the S3 bucket. For the latter two cases, Amazon Forecast imports all files up to the limit of 10,000 files.</p> <p>Because dataset imports are not aggregated, your most recent dataset import is the one that is used when training a predictor or generating a forecast. Make sure that your most recent dataset import contains all of the data you want to model off of, and not just the new data collected since the previous import.</p> <p>To get a list of all your dataset import jobs, filtered by specified criteria, use the <a>ListDatasetImportJobs</a> operation.</p>', 'CreateForecast' => '<p>Creates a forecast for each item in the <code>TARGET_TIME_SERIES</code> dataset that was used to train the predictor. This is known as inference. To retrieve the forecast for a single item at low latency, use the operation. To export the complete forecast into your Amazon Simple Storage Service (Amazon S3) bucket, use the <a>CreateForecastExportJob</a> operation.</p> <p>The range of the forecast is determined by the <code>ForecastHorizon</code> value, which you specify in the <a>CreatePredictor</a> request. When you query a forecast, you can request a specific date range within the forecast.</p> <p>To get a list of all your forecasts, use the <a>ListForecasts</a> operation.</p> <note> <p>The forecasts generated by Amazon Forecast are in the same time zone as the dataset that was used to create the predictor.</p> </note> <p>For more information, see <a>howitworks-forecast</a>.</p> <note> <p>The <code>Status</code> of the forecast must be <code>ACTIVE</code> before you can query or export the forecast. Use the <a>DescribeForecast</a> operation to get the status.</p> </note>', 'CreateForecastExportJob' => '<p>Exports a forecast created by the <a>CreateForecast</a> operation to your Amazon Simple Storage Service (Amazon S3) bucket. The forecast file name will match the following conventions:</p> <p>&lt;ForecastExportJobName&gt;_&lt;ExportTimestamp&gt;_&lt;PartNumber&gt;</p> <p>where the &lt;ExportTimestamp&gt; component is in Java SimpleDateFormat (yyyy-MM-ddTHH-mm-ssZ).</p> <p>You must specify a <a>DataDestination</a> object that includes an AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access the Amazon S3 bucket. For more information, see <a>aws-forecast-iam-roles</a>.</p> <p>For more information, see <a>howitworks-forecast</a>.</p> <p>To get a list of all your forecast export jobs, use the <a>ListForecastExportJobs</a> operation.</p> <note> <p>The <code>Status</code> of the forecast export job must be <code>ACTIVE</code> before you can access the forecast in your Amazon S3 bucket. To get the status, use the <a>DescribeForecastExportJob</a> operation.</p> </note>', 'CreatePredictor' => '<p>Creates an Amazon Forecast predictor.</p> <p>In the request, you provide a dataset group and either specify an algorithm or let Amazon Forecast choose the algorithm for you using AutoML. If you specify an algorithm, you also can override algorithm-specific hyperparameters.</p> <p>Amazon Forecast uses the chosen algorithm to train a model using the latest version of the datasets in the specified dataset group. The result is called a predictor. You then generate a forecast using the <a>CreateForecast</a> operation.</p> <p>After training a model, the <code>CreatePredictor</code> operation also evaluates it. To see the evaluation metrics, use the <a>GetAccuracyMetrics</a> operation. Always review the evaluation metrics before deciding to use the predictor to generate a forecast.</p> <p>Optionally, you can specify a featurization configuration to fill and aggregate the data fields in the <code>TARGET_TIME_SERIES</code> dataset to improve model training. For more information, see <a>FeaturizationConfig</a>.</p> <p>For RELATED_TIME_SERIES datasets, <code>CreatePredictor</code> verifies that the <code>DataFrequency</code> specified when the dataset was created matches the <code>ForecastFrequency</code>. TARGET_TIME_SERIES datasets don\'t have this restriction. Amazon Forecast also verifies the delimiter and timestamp format. For more information, see <a>howitworks-datasets-groups</a>.</p> <p> <b>AutoML</b> </p> <p>If you want Amazon Forecast to evaluate each algorithm and choose the one that minimizes the <code>objective function</code>, set <code>PerformAutoML</code> to <code>true</code>. The <code>objective function</code> is defined as the mean of the weighted p10, p50, and p90 quantile losses. For more information, see <a>EvaluationResult</a>.</p> <p>When AutoML is enabled, the following properties are disallowed:</p> <ul> <li> <p> <code>AlgorithmArn</code> </p> </li> <li> <p> <code>HPOConfig</code> </p> </li> <li> <p> <code>PerformHPO</code> </p> </li> <li> <p> <code>TrainingParameters</code> </p> </li> </ul> <p>To get a list of all of your predictors, use the <a>ListPredictors</a> operation.</p> <note> <p>Before you can use the predictor to create a forecast, the <code>Status</code> of the predictor must be <code>ACTIVE</code>, signifying that training has completed. To get the status, use the <a>DescribePredictor</a> operation.</p> </note>', 'DeleteDataset' => '<p>Deletes an Amazon Forecast dataset that was created using the <a>CreateDataset</a> operation. You can only delete datasets that have a status of <code>ACTIVE</code> or <code>CREATE_FAILED</code>. To get the status use the <a>DescribeDataset</a> operation.</p> <note> <p>Forecast does not automatically update any dataset groups that contain the deleted dataset. In order to update the dataset group, use the operation, omitting the deleted dataset\'s ARN.</p> </note>', 'DeleteDatasetGroup' => '<p>Deletes a dataset group created using the <a>CreateDatasetGroup</a> operation. You can only delete dataset groups that have a status of <code>ACTIVE</code>, <code>CREATE_FAILED</code>, or <code>UPDATE_FAILED</code>. To get the status, use the <a>DescribeDatasetGroup</a> operation.</p> <p>This operation deletes only the dataset group, not the datasets in the group.</p>', 'DeleteDatasetImportJob' => '<p>Deletes a dataset import job created using the <a>CreateDatasetImportJob</a> operation. You can delete only dataset import jobs that have a status of <code>ACTIVE</code> or <code>CREATE_FAILED</code>. To get the status, use the <a>DescribeDatasetImportJob</a> operation.</p>', 'DeleteForecast' => '<p>Deletes a forecast created using the <a>CreateForecast</a> operation. You can delete only forecasts that have a status of <code>ACTIVE</code> or <code>CREATE_FAILED</code>. To get the status, use the <a>DescribeForecast</a> operation.</p> <p>You can\'t delete a forecast while it is being exported. After a forecast is deleted, you can no longer query the forecast.</p>', 'DeleteForecastExportJob' => '<p>Deletes a forecast export job created using the <a>CreateForecastExportJob</a> operation. You can delete only export jobs that have a status of <code>ACTIVE</code> or <code>CREATE_FAILED</code>. To get the status, use the <a>DescribeForecastExportJob</a> operation.</p>', 'DeletePredictor' => '<p>Deletes a predictor created using the <a>CreatePredictor</a> operation. You can delete only predictor that have a status of <code>ACTIVE</code> or <code>CREATE_FAILED</code>. To get the status, use the <a>DescribePredictor</a> operation.</p>', 'DescribeDataset' => '<p>Describes an Amazon Forecast dataset created using the <a>CreateDataset</a> operation.</p> <p>In addition to listing the parameters specified in the <code>CreateDataset</code> request, this operation includes the following dataset properties:</p> <ul> <li> <p> <code>CreationTime</code> </p> </li> <li> <p> <code>LastModificationTime</code> </p> </li> <li> <p> <code>Status</code> </p> </li> </ul>', 'DescribeDatasetGroup' => '<p>Describes a dataset group created using the <a>CreateDatasetGroup</a> operation.</p> <p>In addition to listing the parameters provided in the <code>CreateDatasetGroup</code> request, this operation includes the following properties:</p> <ul> <li> <p> <code>DatasetArns</code> - The datasets belonging to the group.</p> </li> <li> <p> <code>CreationTime</code> </p> </li> <li> <p> <code>LastModificationTime</code> </p> </li> <li> <p> <code>Status</code> </p> </li> </ul>', 'DescribeDatasetImportJob' => '<p>Describes a dataset import job created using the <a>CreateDatasetImportJob</a> operation.</p> <p>In addition to listing the parameters provided in the <code>CreateDatasetImportJob</code> request, this operation includes the following properties:</p> <ul> <li> <p> <code>CreationTime</code> </p> </li> <li> <p> <code>LastModificationTime</code> </p> </li> <li> <p> <code>DataSize</code> </p> </li> <li> <p> <code>FieldStatistics</code> </p> </li> <li> <p> <code>Status</code> </p> </li> <li> <p> <code>Message</code> - If an error occurred, information about the error.</p> </li> </ul>', 'DescribeForecast' => '<p>Describes a forecast created using the <a>CreateForecast</a> operation.</p> <p>In addition to listing the properties provided in the <code>CreateForecast</code> request, this operation lists the following properties:</p> <ul> <li> <p> <code>DatasetGroupArn</code> - The dataset group that provided the training data.</p> </li> <li> <p> <code>CreationTime</code> </p> </li> <li> <p> <code>LastModificationTime</code> </p> </li> <li> <p> <code>Status</code> </p> </li> <li> <p> <code>Message</code> - If an error occurred, information about the error.</p> </li> </ul>', 'DescribeForecastExportJob' => '<p>Describes a forecast export job created using the <a>CreateForecastExportJob</a> operation.</p> <p>In addition to listing the properties provided by the user in the <code>CreateForecastExportJob</code> request, this operation lists the following properties:</p> <ul> <li> <p> <code>CreationTime</code> </p> </li> <li> <p> <code>LastModificationTime</code> </p> </li> <li> <p> <code>Status</code> </p> </li> <li> <p> <code>Message</code> - If an error occurred, information about the error.</p> </li> </ul>', 'DescribePredictor' => '<p>Describes a predictor created using the <a>CreatePredictor</a> operation.</p> <p>In addition to listing the properties provided in the <code>CreatePredictor</code> request, this operation lists the following properties:</p> <ul> <li> <p> <code>DatasetImportJobArns</code> - The dataset import jobs used to import training data.</p> </li> <li> <p> <code>AutoMLAlgorithmArns</code> - If AutoML is performed, the algorithms that were evaluated.</p> </li> <li> <p> <code>CreationTime</code> </p> </li> <li> <p> <code>LastModificationTime</code> </p> </li> <li> <p> <code>Status</code> </p> </li> <li> <p> <code>Message</code> - If an error occurred, information about the error.</p> </li> </ul>', 'GetAccuracyMetrics' => '<p>Provides metrics on the accuracy of the models that were trained by the <a>CreatePredictor</a> operation. Use metrics to see how well the model performed and to decide whether to use the predictor to generate a forecast. For more information, see <a>metrics</a>.</p> <p>This operation generates metrics for each backtest window that was evaluated. The number of backtest windows (<code>NumberOfBacktestWindows</code>) is specified using the <a>EvaluationParameters</a> object, which is optionally included in the <code>CreatePredictor</code> request. If <code>NumberOfBacktestWindows</code> isn\'t specified, the number defaults to one.</p> <p>The parameters of the <code>filling</code> method determine which items contribute to the metrics. If you want all items to contribute, specify <code>zero</code>. If you want only those items that have complete data in the range being evaluated to contribute, specify <code>nan</code>. For more information, see <a>FeaturizationMethod</a>.</p> <note> <p>Before you can get accuracy metrics, the <code>Status</code> of the predictor must be <code>ACTIVE</code>, signifying that training has completed. To get the status, use the <a>DescribePredictor</a> operation.</p> </note>', 'ListDatasetGroups' => '<p>Returns a list of dataset groups created using the <a>CreateDatasetGroup</a> operation. For each dataset group, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). You can retrieve the complete set of properties by using the dataset group ARN with the <a>DescribeDatasetGroup</a> operation.</p>', 'ListDatasetImportJobs' => '<p>Returns a list of dataset import jobs created using the <a>CreateDatasetImportJob</a> operation. For each import job, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). You can retrieve the complete set of properties by using the ARN with the <a>DescribeDatasetImportJob</a> operation. You can filter the list by providing an array of <a>Filter</a> objects.</p>', 'ListDatasets' => '<p>Returns a list of datasets created using the <a>CreateDataset</a> operation. For each dataset, a summary of its properties, including its Amazon Resource Name (ARN), is returned. To retrieve the complete set of properties, use the ARN with the <a>DescribeDataset</a> operation.</p>', 'ListForecastExportJobs' => '<p>Returns a list of forecast export jobs created using the <a>CreateForecastExportJob</a> operation. For each forecast export job, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). To retrieve the complete set of properties, use the ARN with the <a>DescribeForecastExportJob</a> operation. You can filter the list using an array of <a>Filter</a> objects.</p>', 'ListForecasts' => '<p>Returns a list of forecasts created using the <a>CreateForecast</a> operation. For each forecast, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). To retrieve the complete set of properties, specify the ARN with the <a>DescribeForecast</a> operation. You can filter the list using an array of <a>Filter</a> objects.</p>', 'ListPredictors' => '<p>Returns a list of predictors created using the <a>CreatePredictor</a> operation. For each predictor, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). You can retrieve the complete set of properties by using the ARN with the <a>DescribePredictor</a> operation. You can filter the list using an array of <a>Filter</a> objects.</p>', 'ListTagsForResource' => '<p>Lists the tags for an Amazon Forecast resource.</p>', 'TagResource' => '<p>Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are also deleted.</p>', 'UntagResource' => '<p>Deletes the specified tags from a resource.</p>', 'UpdateDatasetGroup' => '<p>Replaces the datasets in a dataset group with the specified datasets.</p> <note> <p>The <code>Status</code> of the dataset group must be <code>ACTIVE</code> before you can use the dataset group to create a predictor. Use the <a>DescribeDatasetGroup</a> operation to get the status.</p> </note>', ], 'shapes' => [ 'Arn' => [ 'base' => NULL, 'refs' => [ 'ArnList$member' => NULL, 'CreateDatasetGroupResponse$DatasetGroupArn' => '<p>The Amazon Resource Name (ARN) of the dataset group.</p>', 'CreateDatasetImportJobRequest$DatasetArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Forecast dataset that you want to import data to.</p>', 'CreateDatasetImportJobResponse$DatasetImportJobArn' => '<p>The Amazon Resource Name (ARN) of the dataset import job.</p>', 'CreateDatasetResponse$DatasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'CreateForecastExportJobRequest$ForecastArn' => '<p>The Amazon Resource Name (ARN) of the forecast that you want to export.</p>', 'CreateForecastExportJobResponse$ForecastExportJobArn' => '<p>The Amazon Resource Name (ARN) of the export job.</p>', 'CreateForecastRequest$PredictorArn' => '<p>The Amazon Resource Name (ARN) of the predictor to use to generate the forecast.</p>', 'CreateForecastResponse$ForecastArn' => '<p>The Amazon Resource Name (ARN) of the forecast.</p>', 'CreatePredictorRequest$AlgorithmArn' => '<p>The Amazon Resource Name (ARN) of the algorithm to use for model training. Required if <code>PerformAutoML</code> is not set to <code>true</code>.</p> <p class="title"> <b>Supported algorithms:</b> </p> <ul> <li> <p> <code>arn:aws:forecast:::algorithm/ARIMA</code> </p> </li> <li> <p> <code>arn:aws:forecast:::algorithm/Deep_AR_Plus</code> </p> <p>Supports hyperparameter optimization (HPO)</p> </li> <li> <p> <code>arn:aws:forecast:::algorithm/ETS</code> </p> </li> <li> <p> <code>arn:aws:forecast:::algorithm/NPTS</code> </p> </li> <li> <p> <code>arn:aws:forecast:::algorithm/Prophet</code> </p> </li> </ul>', 'CreatePredictorResponse$PredictorArn' => '<p>The Amazon Resource Name (ARN) of the predictor.</p>', 'DatasetGroupSummary$DatasetGroupArn' => '<p>The Amazon Resource Name (ARN) of the dataset group.</p>', 'DatasetImportJobSummary$DatasetImportJobArn' => '<p>The Amazon Resource Name (ARN) of the dataset import job.</p>', 'DatasetSummary$DatasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'DeleteDatasetGroupRequest$DatasetGroupArn' => '<p>The Amazon Resource Name (ARN) of the dataset group to delete.</p>', 'DeleteDatasetImportJobRequest$DatasetImportJobArn' => '<p>The Amazon Resource Name (ARN) of the dataset import job to delete.</p>', 'DeleteDatasetRequest$DatasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset to delete.</p>', 'DeleteForecastExportJobRequest$ForecastExportJobArn' => '<p>The Amazon Resource Name (ARN) of the forecast export job to delete.</p>', 'DeleteForecastRequest$ForecastArn' => '<p>The Amazon Resource Name (ARN) of the forecast to delete.</p>', 'DeletePredictorRequest$PredictorArn' => '<p>The Amazon Resource Name (ARN) of the predictor to delete.</p>', 'DescribeDatasetGroupRequest$DatasetGroupArn' => '<p>The Amazon Resource Name (ARN) of the dataset group.</p>', 'DescribeDatasetGroupResponse$DatasetGroupArn' => '<p>The ARN of the dataset group.</p>', 'DescribeDatasetImportJobRequest$DatasetImportJobArn' => '<p>The Amazon Resource Name (ARN) of the dataset import job.</p>', 'DescribeDatasetImportJobResponse$DatasetImportJobArn' => '<p>The ARN of the dataset import job.</p>', 'DescribeDatasetImportJobResponse$DatasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset that the training data was imported to.</p>', 'DescribeDatasetRequest$DatasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'DescribeDatasetResponse$DatasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'DescribeForecastExportJobRequest$ForecastExportJobArn' => '<p>The Amazon Resource Name (ARN) of the forecast export job.</p>', 'DescribeForecastExportJobResponse$ForecastExportJobArn' => '<p>The ARN of the forecast export job.</p>', 'DescribeForecastExportJobResponse$ForecastArn' => '<p>The Amazon Resource Name (ARN) of the exported forecast.</p>', 'DescribeForecastRequest$ForecastArn' => '<p>The Amazon Resource Name (ARN) of the forecast.</p>', 'DescribeForecastResponse$ForecastArn' => '<p>The forecast ARN as specified in the request.</p>', 'DescribeForecastResponse$PredictorArn' => '<p>The ARN of the predictor used to generate the forecast.</p>', 'DescribeForecastResponse$DatasetGroupArn' => '<p>The ARN of the dataset group that provided the data used to train the predictor.</p>', 'DescribePredictorRequest$PredictorArn' => '<p>The Amazon Resource Name (ARN) of the predictor that you want information about.</p>', 'DescribePredictorResponse$AlgorithmArn' => '<p>The Amazon Resource Name (ARN) of the algorithm used for model training.</p>', 'EncryptionConfig$RoleArn' => '<p>The ARN of the IAM role that Amazon Forecast can assume to access the AWS KMS key.</p> <p>Passing a role across AWS accounts is not allowed. If you pass a role that isn\'t in your account, you get an <code>InvalidInputException</code> error.</p>', 'EvaluationResult$AlgorithmArn' => '<p>The Amazon Resource Name (ARN) of the algorithm that was evaluated.</p>', 'Filter$Value' => '<p>The value to match.</p>', 'ForecastExportJobSummary$ForecastExportJobArn' => '<p>The Amazon Resource Name (ARN) of the forecast export job.</p>', 'ForecastSummary$ForecastArn' => '<p>The ARN of the forecast.</p>', 'GetAccuracyMetricsRequest$PredictorArn' => '<p>The Amazon Resource Name (ARN) of the predictor to get metrics for.</p>', 'InputDataConfig$DatasetGroupArn' => '<p>The Amazon Resource Name (ARN) of the dataset group.</p>', 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are Forecast dataset groups, datasets, dataset import jobs, predictors, forecasts, and forecast export jobs.</p>', 'PredictorExecution$AlgorithmArn' => '<p>The ARN of the algorithm used to test the predictor.</p>', 'PredictorSummary$PredictorArn' => '<p>The ARN of the predictor.</p>', 'PredictorSummary$DatasetGroupArn' => '<p>The Amazon Resource Name (ARN) of the dataset group that contains the data used to train the predictor.</p>', 'S3Config$RoleArn' => '<p>The ARN of the AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access the Amazon S3 bucket or files. If you provide a value for the <code>KMSKeyArn</code> key, the role must allow access to the key.</p> <p>Passing a role across AWS accounts is not allowed. If you pass a role that isn\'t in your account, you get an <code>InvalidInputException</code> error.</p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are Forecast dataset groups, datasets, dataset import jobs, predictors, forecasts, and forecast export jobs.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are Forecast dataset groups, datasets, dataset import jobs, predictors, forecasts, and forecast exports.</p>', 'UpdateDatasetGroupRequest$DatasetGroupArn' => '<p>The ARN of the dataset group.</p>', ], ], 'ArnList' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetGroupRequest$DatasetArns' => '<p>An array of Amazon Resource Names (ARNs) of the datasets that you want to include in the dataset group.</p>', 'DescribeDatasetGroupResponse$DatasetArns' => '<p>An array of Amazon Resource Names (ARNs) of the datasets contained in the dataset group.</p>', 'DescribePredictorResponse$DatasetImportJobArns' => '<p>An array of the ARNs of the dataset import jobs used to import training data for the predictor.</p>', 'DescribePredictorResponse$AutoMLAlgorithmArns' => '<p>When <code>PerformAutoML</code> is specified, the ARN of the chosen algorithm.</p>', 'UpdateDatasetGroupRequest$DatasetArns' => '<p>An array of the Amazon Resource Names (ARNs) of the datasets to add to the dataset group.</p>', ], ], 'AttributeType' => [ 'base' => NULL, 'refs' => [ 'SchemaAttribute$AttributeType' => '<p>The data type of the field.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CreatePredictorRequest$PerformAutoML' => '<p>Whether to perform AutoML. When Amazon Forecast performs AutoML, it evaluates the algorithms it provides and chooses the best algorithm and configuration for your training dataset.</p> <p>The default value is <code>false</code>. In this case, you are required to specify an algorithm.</p> <p>Set <code>PerformAutoML</code> to <code>true</code> to have Amazon Forecast perform AutoML. This is a good option if you aren\'t sure which algorithm is suitable for your training data. In this case, <code>PerformHPO</code> must be false.</p>', 'CreatePredictorRequest$PerformHPO' => '<p>Whether to perform hyperparameter optimization (HPO). HPO finds optimal hyperparameter values for your training data. The process of performing HPO is known as running a hyperparameter tuning job.</p> <p>The default value is <code>false</code>. In this case, Amazon Forecast uses default hyperparameter values from the chosen algorithm.</p> <p>To override the default values, set <code>PerformHPO</code> to <code>true</code> and, optionally, supply the <a>HyperParameterTuningJobConfig</a> object. The tuning job specifies a metric to optimize, which hyperparameters participate in tuning, and the valid range for each tunable hyperparameter. In this case, you are required to specify an algorithm and <code>PerformAutoML</code> must be false.</p> <p>The following algorithm supports HPO:</p> <ul> <li> <p>DeepAR+</p> </li> </ul>', 'DescribePredictorResponse$PerformAutoML' => '<p>Whether the predictor is set to perform AutoML.</p>', 'DescribePredictorResponse$PerformHPO' => '<p>Whether the predictor is set to perform hyperparameter optimization (HPO).</p>', ], ], 'CategoricalParameterRange' => [ 'base' => '<p>Specifies a categorical hyperparameter and it\'s range of tunable values. This object is part of the <a>ParameterRanges</a> object.</p>', 'refs' => [ 'CategoricalParameterRanges$member' => NULL, ], ], 'CategoricalParameterRanges' => [ 'base' => NULL, 'refs' => [ 'ParameterRanges$CategoricalParameterRanges' => '<p>Specifies the tunable range for each categorical hyperparameter.</p>', ], ], 'ContinuousParameterRange' => [ 'base' => '<p>Specifies a continuous hyperparameter and it\'s range of tunable values. This object is part of the <a>ParameterRanges</a> object.</p>', 'refs' => [ 'ContinuousParameterRanges$member' => NULL, ], ], 'ContinuousParameterRanges' => [ 'base' => NULL, 'refs' => [ 'ParameterRanges$ContinuousParameterRanges' => '<p>Specifies the tunable range for each continuous hyperparameter.</p>', ], ], 'CreateDatasetGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatasetGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatasetImportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatasetImportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatasetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatasetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateForecastExportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateForecastExportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateForecastRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateForecastResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePredictorRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePredictorResponse' => [ 'base' => NULL, 'refs' => [], ], 'DataDestination' => [ 'base' => '<p>The destination for an exported forecast, an AWS Identity and Access Management (IAM) role that allows Amazon Forecast to access the location and, optionally, an AWS Key Management Service (KMS) key. This object is submitted in the <a>CreateForecastExportJob</a> request.</p>', 'refs' => [ 'CreateForecastExportJobRequest$Destination' => '<p>The location where you want to save the forecast and an AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access the location. The forecast must be exported to an Amazon S3 bucket.</p> <p>If encryption is used, <code>Destination</code> must include an AWS Key Management Service (KMS) key. The IAM role must allow Amazon Forecast permission to access the key.</p>', 'DescribeForecastExportJobResponse$Destination' => '<p>The path to the Amazon Simple Storage Service (Amazon S3) bucket where the forecast is exported.</p>', 'ForecastExportJobSummary$Destination' => '<p>The path to the Amazon Simple Storage Service (Amazon S3) bucket where the forecast is exported.</p>', ], ], 'DataSource' => [ 'base' => '<p>The source of your training data, an AWS Identity and Access Management (IAM) role that allows Amazon Forecast to access the data and, optionally, an AWS Key Management Service (KMS) key. This object is submitted in the <a>CreateDatasetImportJob</a> request.</p>', 'refs' => [ 'CreateDatasetImportJobRequest$DataSource' => '<p>The location of the training data to import and an AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access the data. The training data must be stored in an Amazon S3 bucket.</p> <p>If encryption is used, <code>DataSource</code> must include an AWS Key Management Service (KMS) key and the IAM role must allow Amazon Forecast permission to access the key. The KMS key and IAM role must match those specified in the <code>EncryptionConfig</code> parameter of the <a>CreateDataset</a> operation.</p>', 'DatasetImportJobSummary$DataSource' => '<p>The location of the training data to import and an AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access the data. The training data must be stored in an Amazon S3 bucket.</p> <p>If encryption is used, <code>DataSource</code> includes an AWS Key Management Service (KMS) key.</p>', 'DescribeDatasetImportJobResponse$DataSource' => '<p>The location of the training data to import and an AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access the data.</p> <p>If encryption is used, <code>DataSource</code> includes an AWS Key Management Service (KMS) key.</p>', ], ], 'DatasetGroupSummary' => [ 'base' => '<p>Provides a summary of the dataset group properties used in the <a>ListDatasetGroups</a> operation. To get the complete set of properties, call the <a>DescribeDatasetGroup</a> operation, and provide the <code>DatasetGroupArn</code>.</p>', 'refs' => [ 'DatasetGroups$member' => NULL, ], ], 'DatasetGroups' => [ 'base' => NULL, 'refs' => [ 'ListDatasetGroupsResponse$DatasetGroups' => '<p>An array of objects that summarize each dataset group\'s properties.</p>', ], ], 'DatasetImportJobSummary' => [ 'base' => '<p>Provides a summary of the dataset import job properties used in the <a>ListDatasetImportJobs</a> operation. To get the complete set of properties, call the <a>DescribeDatasetImportJob</a> operation, and provide the <code>DatasetImportJobArn</code>.</p>', 'refs' => [ 'DatasetImportJobs$member' => NULL, ], ], 'DatasetImportJobs' => [ 'base' => NULL, 'refs' => [ 'ListDatasetImportJobsResponse$DatasetImportJobs' => '<p>An array of objects that summarize each dataset import job\'s properties.</p>', ], ], 'DatasetSummary' => [ 'base' => '<p>Provides a summary of the dataset properties used in the <a>ListDatasets</a> operation. To get the complete set of properties, call the <a>DescribeDataset</a> operation, and provide the <code>DatasetArn</code>.</p>', 'refs' => [ 'Datasets$member' => NULL, ], ], 'DatasetType' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetRequest$DatasetType' => '<p>The dataset type. Valid values depend on the chosen <code>Domain</code>.</p>', 'DatasetSummary$DatasetType' => '<p>The dataset type.</p>', 'DescribeDatasetResponse$DatasetType' => '<p>The dataset type.</p>', ], ], 'Datasets' => [ 'base' => NULL, 'refs' => [ 'ListDatasetsResponse$Datasets' => '<p>An array of objects that summarize each dataset\'s properties.</p>', ], ], 'DeleteDatasetGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDatasetImportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDatasetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteForecastExportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteForecastRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePredictorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatasetGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatasetGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatasetImportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatasetImportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatasetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatasetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeForecastExportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeForecastExportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeForecastRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeForecastResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePredictorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePredictorResponse' => [ 'base' => NULL, 'refs' => [], ], 'Domain' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetGroupRequest$Domain' => '<p>The domain associated with the dataset group. When you add a dataset to a dataset group, this value and the value specified for the <code>Domain</code> parameter of the <a>CreateDataset</a> operation must match.</p> <p>The <code>Domain</code> and <code>DatasetType</code> that you choose determine the fields that must be present in training data that you import to a dataset. For example, if you choose the <code>RETAIL</code> domain and <code>TARGET_TIME_SERIES</code> as the <code>DatasetType</code>, Amazon Forecast requires that <code>item_id</code>, <code>timestamp</code>, and <code>demand</code> fields are present in your data. For more information, see <a>howitworks-datasets-groups</a>.</p>', 'CreateDatasetRequest$Domain' => '<p>The domain associated with the dataset. When you add a dataset to a dataset group, this value and the value specified for the <code>Domain</code> parameter of the <a>CreateDatasetGroup</a> operation must match.</p> <p>The <code>Domain</code> and <code>DatasetType</code> that you choose determine the fields that must be present in the training data that you import to the dataset. For example, if you choose the <code>RETAIL</code> domain and <code>TARGET_TIME_SERIES</code> as the <code>DatasetType</code>, Amazon Forecast requires <code>item_id</code>, <code>timestamp</code>, and <code>demand</code> fields to be present in your data. For more information, see <a>howitworks-datasets-groups</a>.</p>', 'DatasetSummary$Domain' => '<p>The domain associated with the dataset.</p>', 'DescribeDatasetGroupResponse$Domain' => '<p>The domain associated with the dataset group.</p>', 'DescribeDatasetResponse$Domain' => '<p>The domain associated with the dataset.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'ContinuousParameterRange$MaxValue' => '<p>The maximum tunable value of the hyperparameter.</p>', 'ContinuousParameterRange$MinValue' => '<p>The minimum tunable value of the hyperparameter.</p>', 'DescribeDatasetImportJobResponse$DataSize' => '<p>The size of the dataset in gigabytes (GB) after the import job has finished.</p>', 'Metrics$RMSE' => '<p>The root mean square error (RMSE).</p>', 'Statistics$Avg' => '<p>For a numeric field, the average value in the field.</p>', 'Statistics$Stddev' => '<p>For a numeric field, the standard deviation.</p>', 'WeightedQuantileLoss$Quantile' => '<p>The quantile. Quantiles divide a probability distribution into regions of equal probability. For example, if the distribution was divided into 5 regions of equal probability, the quantiles would be 0.2, 0.4, 0.6, and 0.8.</p>', 'WeightedQuantileLoss$LossValue' => '<p>The difference between the predicted value and the actual value over the quantile, weighted (normalized) by dividing by the sum over all quantiles.</p>', ], ], 'EncryptionConfig' => [ 'base' => '<p>An AWS Key Management Service (KMS) key and an AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access the key. You can specify this optional object in the <a>CreateDataset</a> and <a>CreatePredictor</a> requests.</p>', 'refs' => [ 'CreateDatasetRequest$EncryptionConfig' => '<p>An AWS Key Management Service (KMS) key and the AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access the key.</p>', 'CreatePredictorRequest$EncryptionConfig' => '<p>An AWS Key Management Service (KMS) key and the AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access the key.</p>', 'DescribeDatasetResponse$EncryptionConfig' => '<p>The AWS Key Management Service (KMS) key and the AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access the key.</p>', 'DescribePredictorResponse$EncryptionConfig' => '<p>An AWS Key Management Service (KMS) key and the AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access the key.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'DatasetImportJobSummary$Message' => '<p>If an error occurred, an informational message about the error.</p>', 'DescribeForecastResponse$Message' => '<p>If an error occurred, an informational message about the error.</p>', 'ForecastExportJobSummary$Message' => '<p>If an error occurred, an informational message about the error.</p>', 'ForecastSummary$Message' => '<p>If an error occurred, an informational message about the error.</p>', 'InvalidInputException$Message' => NULL, 'InvalidNextTokenException$Message' => NULL, 'LimitExceededException$Message' => NULL, 'PredictorSummary$Message' => '<p>If an error occurred, an informational message about the error.</p>', 'ResourceAlreadyExistsException$Message' => NULL, 'ResourceInUseException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'TestWindowSummary$Message' => '<p>If the test failed, the reason why it failed.</p>', ], ], 'EvaluationParameters' => [ 'base' => '<p>Parameters that define how to split a dataset into training data and testing data, and the number of iterations to perform. These parameters are specified in the predefined algorithms but you can override them in the <a>CreatePredictor</a> request.</p>', 'refs' => [ 'CreatePredictorRequest$EvaluationParameters' => '<p>Used to override the default evaluation parameters of the specified algorithm. Amazon Forecast evaluates a predictor by splitting a dataset into training data and testing data. The evaluation parameters define how to perform the split and the number of iterations.</p>', 'DescribePredictorResponse$EvaluationParameters' => '<p>Used to override the default evaluation parameters of the specified algorithm. Amazon Forecast evaluates a predictor by splitting a dataset into training data and testing data. The evaluation parameters define how to perform the split and the number of iterations.</p>', ], ], 'EvaluationResult' => [ 'base' => '<p>The results of evaluating an algorithm. Returned as part of the <a>GetAccuracyMetrics</a> response.</p>', 'refs' => [ 'PredictorEvaluationResults$member' => NULL, ], ], 'EvaluationType' => [ 'base' => NULL, 'refs' => [ 'WindowSummary$EvaluationType' => '<p>The type of evaluation.</p> <ul> <li> <p> <code>SUMMARY</code> - The average metrics across all windows.</p> </li> <li> <p> <code>COMPUTED</code> - The metrics for the specified window.</p> </li> </ul>', ], ], 'Featurization' => [ 'base' => '<p>Provides featurization (transformation) information for a dataset field. This object is part of the <a>FeaturizationConfig</a> object.</p> <p>For example:</p> <p> <code>{</code> </p> <p> <code>"AttributeName": "demand",</code> </p> <p> <code>FeaturizationPipeline [ {</code> </p> <p> <code>"FeaturizationMethodName": "filling",</code> </p> <p> <code>"FeaturizationMethodParameters": {"aggregation": "avg", "backfill": "nan"}</code> </p> <p> <code>} ]</code> </p> <p> <code>}</code> </p>', 'refs' => [ 'Featurizations$member' => NULL, ], ], 'FeaturizationConfig' => [ 'base' => '<p>In a <a>CreatePredictor</a> operation, the specified algorithm trains a model using the specified dataset group. You can optionally tell the operation to modify data fields prior to training a model. These modifications are referred to as <i>featurization</i>.</p> <p>You define featurization using the <code>FeaturizationConfig</code> object. You specify an array of transformations, one for each field that you want to featurize. You then include the <code>FeaturizationConfig</code> object in your <code>CreatePredictor</code> request. Amazon Forecast applies the featurization to the <code>TARGET_TIME_SERIES</code> and <code>RELATED_TIME_SERIES</code> datasets before model training.</p> <p>You can create multiple featurization configurations. For example, you might call the <code>CreatePredictor</code> operation twice by specifying different featurization configurations.</p>', 'refs' => [ 'CreatePredictorRequest$FeaturizationConfig' => '<p>The featurization configuration.</p>', 'DescribePredictorResponse$FeaturizationConfig' => '<p>The featurization configuration.</p>', ], ], 'FeaturizationMethod' => [ 'base' => '<p>Provides information about the method that featurizes (transforms) a dataset field. The method is part of the <code>FeaturizationPipeline</code> of the <a>Featurization</a> object. </p> <p>The following is an example of how you specify a <code>FeaturizationMethod</code> object.</p> <p> <code>{</code> </p> <p> <code>"FeaturizationMethodName": "filling",</code> </p> <p> <code>"FeaturizationMethodParameters": {"aggregation": "sum", "middlefill": "zero", "backfill": "zero"}</code> </p> <p> <code>}</code> </p>', 'refs' => [ 'FeaturizationPipeline$member' => NULL, ], ], 'FeaturizationMethodName' => [ 'base' => NULL, 'refs' => [ 'FeaturizationMethod$FeaturizationMethodName' => '<p>The name of the method. The "filling" method is the only supported method.</p>', ], ], 'FeaturizationMethodParameters' => [ 'base' => NULL, 'refs' => [ 'FeaturizationMethod$FeaturizationMethodParameters' => '<p>The method parameters (key-value pairs), which are a map of override parameters. Specify these parameters to override the default values. Related Time Series attributes do not accept aggregation parameters.</p> <p>The following list shows the parameters and their valid values for the "filling" featurization method for a <b>Target Time Series</b> dataset. Bold signifies the default value.</p> <ul> <li> <p> <code>aggregation</code>: <b>sum</b>, <code>avg</code>, <code>first</code>, <code>min</code>, <code>max</code> </p> </li> <li> <p> <code>frontfill</code>: <b>none</b> </p> </li> <li> <p> <code>middlefill</code>: <b>zero</b>, <code>nan</code> (not a number), <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li> <li> <p> <code>backfill</code>: <b>zero</b>, <code>nan</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li> </ul> <p>The following list shows the parameters and their valid values for a <b>Related Time Series</b> featurization method (there are no defaults):</p> <ul> <li> <p> <code>middlefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li> <li> <p> <code>backfill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li> <li> <p> <code>futurefill</code>: <code>zero</code>, <code>value</code>, <code>median</code>, <code>mean</code>, <code>min</code>, <code>max</code> </p> </li> </ul>', ], ], 'FeaturizationPipeline' => [ 'base' => NULL, 'refs' => [ 'Featurization$FeaturizationPipeline' => '<p>An array of one <code>FeaturizationMethod</code> object that specifies the feature transformation method.</p>', ], ], 'Featurizations' => [ 'base' => NULL, 'refs' => [ 'FeaturizationConfig$Featurizations' => '<p>An array of featurization (transformation) information for the fields of a dataset.</p>', ], ], 'FieldStatistics' => [ 'base' => NULL, 'refs' => [ 'DescribeDatasetImportJobResponse$FieldStatistics' => '<p>Statistical information about each field in the input data.</p>', ], ], 'Filter' => [ 'base' => '<p>Describes a filter for choosing a subset of objects. Each filter consists of a condition and a match statement. The condition is either <code>IS</code> or <code>IS_NOT</code>, which specifies whether to include or exclude the objects that match the statement, respectively. The match statement consists of a key and a value.</p>', 'refs' => [ 'Filters$member' => NULL, ], ], 'FilterConditionString' => [ 'base' => NULL, 'refs' => [ 'Filter$Condition' => '<p>The condition to apply. To include the objects that match the statement, specify <code>IS</code>. To exclude matching objects, specify <code>IS_NOT</code>.</p>', ], ], 'Filters' => [ 'base' => NULL, 'refs' => [ 'ListDatasetImportJobsRequest$Filters' => '<p>An array of filters. For each filter, you provide a condition and a match statement. The condition is either <code>IS</code> or <code>IS_NOT</code>, which specifies whether to include or exclude the datasets that match the statement from the list, respectively. The match statement consists of a key and a value.</p> <p> <b>Filter properties</b> </p> <ul> <li> <p> <code>Condition</code> - The condition to apply. Valid values are <code>IS</code> and <code>IS_NOT</code>. To include the datasets that match the statement, specify <code>IS</code>. To exclude matching datasets, specify <code>IS_NOT</code>.</p> </li> <li> <p> <code>Key</code> - The name of the parameter to filter on. Valid values are <code>DatasetArn</code> and <code>Status</code>.</p> </li> <li> <p> <code>Value</code> - The value to match.</p> </li> </ul> <p>For example, to list all dataset import jobs whose status is ACTIVE, you specify the following filter:</p> <p> <code>"Filters": [ { "Condition": "IS", "Key": "Status", "Value": "ACTIVE" } ]</code> </p>', 'ListForecastExportJobsRequest$Filters' => '<p>An array of filters. For each filter, you provide a condition and a match statement. The condition is either <code>IS</code> or <code>IS_NOT</code>, which specifies whether to include or exclude the forecast export jobs that match the statement from the list, respectively. The match statement consists of a key and a value.</p> <p> <b>Filter properties</b> </p> <ul> <li> <p> <code>Condition</code> - The condition to apply. Valid values are <code>IS</code> and <code>IS_NOT</code>. To include the forecast export jobs that match the statement, specify <code>IS</code>. To exclude matching forecast export jobs, specify <code>IS_NOT</code>.</p> </li> <li> <p> <code>Key</code> - The name of the parameter to filter on. Valid values are <code>ForecastArn</code> and <code>Status</code>.</p> </li> <li> <p> <code>Value</code> - The value to match.</p> </li> </ul> <p>For example, to list all jobs that export a forecast named <i>electricityforecast</i>, specify the following filter:</p> <p> <code>"Filters": [ { "Condition": "IS", "Key": "ForecastArn", "Value": "arn:aws:forecast:us-west-2:&lt;acct-id&gt;:forecast/electricityforecast" } ]</code> </p>', 'ListForecastsRequest$Filters' => '<p>An array of filters. For each filter, you provide a condition and a match statement. The condition is either <code>IS</code> or <code>IS_NOT</code>, which specifies whether to include or exclude the forecasts that match the statement from the list, respectively. The match statement consists of a key and a value.</p> <p> <b>Filter properties</b> </p> <ul> <li> <p> <code>Condition</code> - The condition to apply. Valid values are <code>IS</code> and <code>IS_NOT</code>. To include the forecasts that match the statement, specify <code>IS</code>. To exclude matching forecasts, specify <code>IS_NOT</code>.</p> </li> <li> <p> <code>Key</code> - The name of the parameter to filter on. Valid values are <code>DatasetGroupArn</code>, <code>PredictorArn</code>, and <code>Status</code>.</p> </li> <li> <p> <code>Value</code> - The value to match.</p> </li> </ul> <p>For example, to list all forecasts whose status is not ACTIVE, you would specify:</p> <p> <code>"Filters": [ { "Condition": "IS_NOT", "Key": "Status", "Value": "ACTIVE" } ]</code> </p>', 'ListPredictorsRequest$Filters' => '<p>An array of filters. For each filter, you provide a condition and a match statement. The condition is either <code>IS</code> or <code>IS_NOT</code>, which specifies whether to include or exclude the predictors that match the statement from the list, respectively. The match statement consists of a key and a value.</p> <p> <b>Filter properties</b> </p> <ul> <li> <p> <code>Condition</code> - The condition to apply. Valid values are <code>IS</code> and <code>IS_NOT</code>. To include the predictors that match the statement, specify <code>IS</code>. To exclude matching predictors, specify <code>IS_NOT</code>.</p> </li> <li> <p> <code>Key</code> - The name of the parameter to filter on. Valid values are <code>DatasetGroupArn</code> and <code>Status</code>.</p> </li> <li> <p> <code>Value</code> - The value to match.</p> </li> </ul> <p>For example, to list all predictors whose status is ACTIVE, you would specify:</p> <p> <code>"Filters": [ { "Condition": "IS", "Key": "Status", "Value": "ACTIVE" } ]</code> </p>', ], ], 'ForecastDimensions' => [ 'base' => NULL, 'refs' => [ 'FeaturizationConfig$ForecastDimensions' => '<p>An array of dimension (field) names that specify how to group the generated forecast.</p> <p>For example, suppose that you are generating a forecast for item sales across all of your stores, and your dataset contains a <code>store_id</code> field. If you want the sales forecast for each item by store, you would specify <code>store_id</code> as the dimension.</p> <p>All forecast dimensions specified in the <code>TARGET_TIME_SERIES</code> dataset don\'t need to be specified in the <code>CreatePredictor</code> request. All forecast dimensions specified in the <code>RELATED_TIME_SERIES</code> dataset must be specified in the <code>CreatePredictor</code> request.</p>', ], ], 'ForecastExportJobSummary' => [ 'base' => '<p>Provides a summary of the forecast export job properties used in the <a>ListForecastExportJobs</a> operation. To get the complete set of properties, call the <a>DescribeForecastExportJob</a> operation, and provide the listed <code>ForecastExportJobArn</code>.</p>', 'refs' => [ 'ForecastExportJobs$member' => NULL, ], ], 'ForecastExportJobs' => [ 'base' => NULL, 'refs' => [ 'ListForecastExportJobsResponse$ForecastExportJobs' => '<p>An array of objects that summarize each export job\'s properties.</p>', ], ], 'ForecastSummary' => [ 'base' => '<p>Provides a summary of the forecast properties used in the <a>ListForecasts</a> operation. To get the complete set of properties, call the <a>DescribeForecast</a> operation, and provide the <code>ForecastArn</code> that is listed in the summary.</p>', 'refs' => [ 'Forecasts$member' => NULL, ], ], 'ForecastType' => [ 'base' => NULL, 'refs' => [ 'ForecastTypes$member' => NULL, ], ], 'ForecastTypes' => [ 'base' => NULL, 'refs' => [ 'CreateForecastRequest$ForecastTypes' => '<p>The quantiles at which probabilistic forecasts are generated. <b>You can currently specify up to 5 quantiles per forecast</b>. Accepted values include <code>0.01 to 0.99</code> (increments of .01 only) and <code>mean</code>. The mean forecast is different from the median (0.50) when the distribution is not symmetric (for example, Beta and Negative Binomial). The default value is <code>["0.1", "0.5", "0.9"]</code>.</p>', 'DescribeForecastResponse$ForecastTypes' => '<p>The quantiles at which probabilistic forecasts were generated.</p>', ], ], 'Forecasts' => [ 'base' => NULL, 'refs' => [ 'ListForecastsResponse$Forecasts' => '<p>An array of objects that summarize each forecast\'s properties.</p>', ], ], 'Frequency' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetRequest$DataFrequency' => '<p>The frequency of data collection. This parameter is required for RELATED_TIME_SERIES datasets.</p> <p>Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes), 15min (15 minutes), 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example, "D" indicates every day and "15min" indicates every 15 minutes.</p>', 'DescribeDatasetResponse$DataFrequency' => '<p>The frequency of data collection.</p> <p>Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes), 15min (15 minutes), 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example, "M" indicates every month and "30min" indicates every 30 minutes.</p>', 'FeaturizationConfig$ForecastFrequency' => '<p>The frequency of predictions in a forecast.</p> <p>Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min (30 minutes), 15min (15 minutes), 10min (10 minutes), 5min (5 minutes), and 1min (1 minute). For example, "Y" indicates every year and "5min" indicates every five minutes.</p> <p>The frequency must be greater than or equal to the TARGET_TIME_SERIES dataset frequency.</p> <p>When a RELATED_TIME_SERIES dataset is provided, the frequency must be equal to the RELATED_TIME_SERIES dataset frequency.</p>', ], ], 'GetAccuracyMetricsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccuracyMetricsResponse' => [ 'base' => NULL, 'refs' => [], ], 'HyperParameterTuningJobConfig' => [ 'base' => '<p>Configuration information for a hyperparameter tuning job. You specify this object in the <a>CreatePredictor</a> request.</p> <p>A <i>hyperparameter</i> is a parameter that governs the model training process. You set hyperparameters before training starts, unlike model parameters, which are determined during training. The values of the hyperparameters effect which values are chosen for the model parameters.</p> <p>In a <i>hyperparameter tuning job</i>, Amazon Forecast chooses the set of hyperparameter values that optimize a specified metric. Forecast accomplishes this by running many training jobs over a range of hyperparameter values. The optimum set of values depends on the algorithm, the training data, and the specified metric objective.</p>', 'refs' => [ 'CreatePredictorRequest$HPOConfig' => '<p>Provides hyperparameter override values for the algorithm. If you don\'t provide this parameter, Amazon Forecast uses default values. The individual algorithms specify which hyperparameters support hyperparameter optimization (HPO). For more information, see <a>aws-forecast-choosing-recipes</a>.</p> <p>If you included the <code>HPOConfig</code> object, you must set <code>PerformHPO</code> to true.</p>', 'DescribePredictorResponse$HPOConfig' => '<p>The hyperparameter override values for the algorithm.</p>', ], ], 'InputDataConfig' => [ 'base' => '<p>The data used to train a predictor. The data includes a dataset group and any supplementary features. You specify this object in the <a>CreatePredictor</a> request.</p>', 'refs' => [ 'CreatePredictorRequest$InputDataConfig' => '<p>Describes the dataset group that contains the data to use to train the predictor.</p>', 'DescribePredictorResponse$InputDataConfig' => '<p>Describes the dataset group that contains the data to use to train the predictor.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'CreatePredictorRequest$ForecastHorizon' => '<p>Specifies the number of time-steps that the model is trained to predict. The forecast horizon is also called the prediction length.</p> <p>For example, if you configure a dataset for daily data collection (using the <code>DataFrequency</code> parameter of the <a>CreateDataset</a> operation) and set the forecast horizon to 10, the model returns predictions for 10 days.</p> <p>The maximum forecast horizon is the lesser of 500 time-steps or 1/3 of the TARGET_TIME_SERIES dataset length.</p>', 'DescribePredictorResponse$ForecastHorizon' => '<p>The number of time-steps of the forecast. The forecast horizon is also called the prediction length.</p>', 'EvaluationParameters$NumberOfBacktestWindows' => '<p>The number of times to split the input data. The default is 1. Valid values are 1 through 5.</p>', 'EvaluationParameters$BackTestWindowOffset' => '<p>The point from the end of the dataset where you want to split the data for model training and testing (evaluation). Specify the value as the number of data points. The default is the value of the forecast horizon. <code>BackTestWindowOffset</code> can be used to mimic a past virtual forecast start date. This value must be greater than or equal to the forecast horizon and less than half of the TARGET_TIME_SERIES dataset length.</p> <p> <code>ForecastHorizon</code> &lt;= <code>BackTestWindowOffset</code> &lt; 1/2 * TARGET_TIME_SERIES dataset length</p>', 'IntegerParameterRange$MaxValue' => '<p>The maximum tunable value of the hyperparameter.</p>', 'IntegerParameterRange$MinValue' => '<p>The minimum tunable value of the hyperparameter.</p>', 'Statistics$Count' => '<p>The number of values in the field.</p>', 'Statistics$CountDistinct' => '<p>The number of distinct values in the field.</p>', 'Statistics$CountNull' => '<p>The number of null values in the field.</p>', 'Statistics$CountNan' => '<p>The number of NAN (not a number) values in the field.</p>', 'WindowSummary$ItemCount' => '<p>The number of data points within the window.</p>', ], ], 'IntegerParameterRange' => [ 'base' => '<p>Specifies an integer hyperparameter and it\'s range of tunable values. This object is part of the <a>ParameterRanges</a> object.</p>', 'refs' => [ 'IntegerParameterRanges$member' => NULL, ], ], 'IntegerParameterRanges' => [ 'base' => NULL, 'refs' => [ 'ParameterRanges$IntegerParameterRanges' => '<p>Specifies the tunable range for each integer hyperparameter.</p>', ], ], 'InvalidInputException' => [ 'base' => '<p>We can\'t process the request because it includes an invalid value or a value that exceeds the valid range.</p>', 'refs' => [], ], 'InvalidNextTokenException' => [ 'base' => '<p>The token is not valid. Tokens expire after 24 hours.</p>', 'refs' => [], ], 'KMSKeyArn' => [ 'base' => NULL, 'refs' => [ 'EncryptionConfig$KMSKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key.</p>', 'S3Config$KMSKeyArn' => '<p>The Amazon Resource Name (ARN) of an AWS Key Management Service (KMS) key.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The limit on the number of resources per account has been exceeded.</p>', 'refs' => [], ], 'ListDatasetGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDatasetGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDatasetImportJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDatasetImportJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDatasetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDatasetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListForecastExportJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListForecastExportJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListForecastsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListForecastsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPredictorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPredictorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListDatasetGroupsRequest$MaxResults' => '<p>The number of items to return in the response.</p>', 'ListDatasetImportJobsRequest$MaxResults' => '<p>The number of items to return in the response.</p>', 'ListDatasetsRequest$MaxResults' => '<p>The number of items to return in the response.</p>', 'ListForecastExportJobsRequest$MaxResults' => '<p>The number of items to return in the response.</p>', 'ListForecastsRequest$MaxResults' => '<p>The number of items to return in the response.</p>', 'ListPredictorsRequest$MaxResults' => '<p>The number of items to return in the response.</p>', ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'DescribeDatasetImportJobResponse$Message' => '<p>If an error occurred, an informational message about the error.</p>', 'DescribeForecastExportJobResponse$Message' => '<p>If an error occurred, an informational message about the error.</p>', 'DescribePredictorResponse$Message' => '<p>If an error occurred, an informational message about the error.</p>', ], ], 'Metrics' => [ 'base' => '<p>Provides metrics that are used to evaluate the performance of a predictor. This object is part of the <a>WindowSummary</a> object.</p>', 'refs' => [ 'WindowSummary$Metrics' => '<p>Provides metrics used to evaluate the performance of a predictor.</p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'CategoricalParameterRange$Name' => '<p>The name of the categorical hyperparameter to tune.</p>', 'ContinuousParameterRange$Name' => '<p>The name of the hyperparameter to tune.</p>', 'CreateDatasetGroupRequest$DatasetGroupName' => '<p>A name for the dataset group.</p>', 'CreateDatasetImportJobRequest$DatasetImportJobName' => '<p>The name for the dataset import job. We recommend including the current timestamp in the name, for example, <code>20190721DatasetImport</code>. This can help you avoid getting a <code>ResourceAlreadyExistsException</code> exception.</p>', 'CreateDatasetRequest$DatasetName' => '<p>A name for the dataset.</p>', 'CreateForecastExportJobRequest$ForecastExportJobName' => '<p>The name for the forecast export job.</p>', 'CreateForecastRequest$ForecastName' => '<p>A name for the forecast.</p>', 'CreatePredictorRequest$PredictorName' => '<p>A name for the predictor.</p>', 'DatasetGroupSummary$DatasetGroupName' => '<p>The name of the dataset group.</p>', 'DatasetImportJobSummary$DatasetImportJobName' => '<p>The name of the dataset import job.</p>', 'DatasetSummary$DatasetName' => '<p>The name of the dataset.</p>', 'DescribeDatasetGroupResponse$DatasetGroupName' => '<p>The name of the dataset group.</p>', 'DescribeDatasetImportJobResponse$DatasetImportJobName' => '<p>The name of the dataset import job.</p>', 'DescribeDatasetResponse$DatasetName' => '<p>The name of the dataset.</p>', 'DescribeForecastExportJobResponse$ForecastExportJobName' => '<p>The name of the forecast export job.</p>', 'DescribeForecastResponse$ForecastName' => '<p>The name of the forecast.</p>', 'DescribePredictorResponse$PredictorArn' => '<p>The ARN of the predictor.</p>', 'DescribePredictorResponse$PredictorName' => '<p>The name of the predictor.</p>', 'Featurization$AttributeName' => '<p>The name of the schema attribute that specifies the data field to be featurized. Amazon Forecast supports the target field of the <code>TARGET_TIME_SERIES</code> and the <code>RELATED_TIME_SERIES</code> datasets. For example, for the <code>RETAIL</code> domain, the target is <code>demand</code>, and for the <code>CUSTOM</code> domain, the target is <code>target_value</code>. For more information, see <a>howitworks-missing-values</a>.</p>', 'ForecastDimensions$member' => NULL, 'ForecastExportJobSummary$ForecastExportJobName' => '<p>The name of the forecast export job.</p>', 'ForecastSummary$ForecastName' => '<p>The name of the forecast.</p>', 'IntegerParameterRange$Name' => '<p>The name of the hyperparameter to tune.</p>', 'PredictorSummary$PredictorName' => '<p>The name of the predictor.</p>', 'SchemaAttribute$AttributeName' => '<p>The name of the dataset field.</p>', 'SupplementaryFeature$Name' => '<p>The name of the feature. This must be "holiday".</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListDatasetGroupsRequest$NextToken' => '<p>If the result of the previous request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.</p>', 'ListDatasetGroupsResponse$NextToken' => '<p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results, use the token in the next request.</p>', 'ListDatasetImportJobsRequest$NextToken' => '<p>If the result of the previous request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.</p>', 'ListDatasetImportJobsResponse$NextToken' => '<p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results, use the token in the next request.</p>', 'ListDatasetsRequest$NextToken' => '<p>If the result of the previous request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.</p>', 'ListDatasetsResponse$NextToken' => '<p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results, use the token in the next request.</p>', 'ListForecastExportJobsRequest$NextToken' => '<p>If the result of the previous request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.</p>', 'ListForecastExportJobsResponse$NextToken' => '<p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results, use the token in the next request.</p>', 'ListForecastsRequest$NextToken' => '<p>If the result of the previous request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.</p>', 'ListForecastsResponse$NextToken' => '<p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results, use the token in the next request.</p>', 'ListPredictorsRequest$NextToken' => '<p>If the result of the previous request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.</p>', 'ListPredictorsResponse$NextToken' => '<p>If the response is truncated, Amazon Forecast returns this token. To retrieve the next set of results, use the token in the next request.</p>', ], ], 'ParameterKey' => [ 'base' => NULL, 'refs' => [ 'FeaturizationMethodParameters$key' => NULL, 'TrainingParameters$key' => NULL, ], ], 'ParameterRanges' => [ 'base' => '<p>Specifies the categorical, continuous, and integer hyperparameters, and their ranges of tunable values. The range of tunable values determines which values that a hyperparameter tuning job can choose for the specified hyperparameter. This object is part of the <a>HyperParameterTuningJobConfig</a> object.</p>', 'refs' => [ 'HyperParameterTuningJobConfig$ParameterRanges' => '<p>Specifies the ranges of valid values for the hyperparameters.</p>', ], ], 'ParameterValue' => [ 'base' => NULL, 'refs' => [ 'FeaturizationMethodParameters$value' => NULL, 'TrainingParameters$value' => NULL, ], ], 'PredictorEvaluationResults' => [ 'base' => NULL, 'refs' => [ 'GetAccuracyMetricsResponse$PredictorEvaluationResults' => '<p>An array of results from evaluating the predictor.</p>', ], ], 'PredictorExecution' => [ 'base' => '<p>The algorithm used to perform a backtest and the status of those tests.</p>', 'refs' => [ 'PredictorExecutions$member' => NULL, ], ], 'PredictorExecutionDetails' => [ 'base' => '<p>Contains details on the backtests performed to evaluate the accuracy of the predictor. The tests are returned in descending order of accuracy, with the most accurate backtest appearing first. You specify the number of backtests to perform when you call the operation.</p>', 'refs' => [ 'DescribePredictorResponse$PredictorExecutionDetails' => '<p>Details on the the status and results of the backtests performed to evaluate the accuracy of the predictor. You specify the number of backtests to perform when you call the operation.</p>', ], ], 'PredictorExecutions' => [ 'base' => NULL, 'refs' => [ 'PredictorExecutionDetails$PredictorExecutions' => '<p>An array of the backtests performed to evaluate the accuracy of the predictor against a particular algorithm. The <code>NumberOfBacktestWindows</code> from the object determines the number of windows in the array.</p>', ], ], 'PredictorSummary' => [ 'base' => '<p>Provides a summary of the predictor properties that are used in the <a>ListPredictors</a> operation. To get the complete set of properties, call the <a>DescribePredictor</a> operation, and provide the listed <code>PredictorArn</code>.</p>', 'refs' => [ 'Predictors$member' => NULL, ], ], 'Predictors' => [ 'base' => NULL, 'refs' => [ 'ListPredictorsResponse$Predictors' => '<p>An array of objects that summarize each predictor\'s properties.</p>', ], ], 'ResourceAlreadyExistsException' => [ 'base' => '<p>There is already a resource with this name. Try again with a different name.</p>', 'refs' => [], ], 'ResourceInUseException' => [ 'base' => '<p>The specified resource is in use.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>We can\'t find a resource with that Amazon Resource Name (ARN). Check the ARN and try again.</p>', 'refs' => [], ], 'S3Config' => [ 'base' => '<p>The path to the file(s) in an Amazon Simple Storage Service (Amazon S3) bucket, and an AWS Identity and Access Management (IAM) role that Amazon Forecast can assume to access the file(s). Optionally, includes an AWS Key Management Service (KMS) key. This object is part of the <a>DataSource</a> object that is submitted in the <a>CreateDatasetImportJob</a> request, and part of the <a>DataDestination</a> object that is submitted in the <a>CreateForecastExportJob</a> request.</p>', 'refs' => [ 'DataDestination$S3Config' => '<p>The path to an Amazon Simple Storage Service (Amazon S3) bucket along with the credentials to access the bucket.</p>', 'DataSource$S3Config' => '<p>The path to the training data stored in an Amazon Simple Storage Service (Amazon S3) bucket along with the credentials to access the data.</p>', ], ], 'S3Path' => [ 'base' => NULL, 'refs' => [ 'S3Config$Path' => '<p>The path to an Amazon Simple Storage Service (Amazon S3) bucket or file(s) in an Amazon S3 bucket.</p>', ], ], 'ScalingType' => [ 'base' => NULL, 'refs' => [ 'ContinuousParameterRange$ScalingType' => '<p>The scale that hyperparameter tuning uses to search the hyperparameter range. Valid values:</p> <dl> <dt>Auto</dt> <dd> <p>Amazon Forecast hyperparameter tuning chooses the best scale for the hyperparameter.</p> </dd> <dt>Linear</dt> <dd> <p>Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.</p> </dd> <dt>Logarithmic</dt> <dd> <p>Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.</p> <p>Logarithmic scaling works only for ranges that have values greater than 0.</p> </dd> <dt>ReverseLogarithmic</dt> <dd> <p>hyperparameter tuning searches the values in the hyperparameter range by using a reverse logarithmic scale.</p> <p>Reverse logarithmic scaling works only for ranges that are entirely within the range 0 &lt;= x &lt; 1.0.</p> </dd> </dl> <p>For information about choosing a hyperparameter scale, see <a href="http://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type">Hyperparameter Scaling</a>. One of the following values:</p>', 'IntegerParameterRange$ScalingType' => '<p>The scale that hyperparameter tuning uses to search the hyperparameter range. Valid values:</p> <dl> <dt>Auto</dt> <dd> <p>Amazon Forecast hyperparameter tuning chooses the best scale for the hyperparameter.</p> </dd> <dt>Linear</dt> <dd> <p>Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.</p> </dd> <dt>Logarithmic</dt> <dd> <p>Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.</p> <p>Logarithmic scaling works only for ranges that have values greater than 0.</p> </dd> <dt>ReverseLogarithmic</dt> <dd> <p>Not supported for <code>IntegerParameterRange</code>.</p> <p>Reverse logarithmic scaling works only for ranges that are entirely within the range 0 &lt;= x &lt; 1.0.</p> </dd> </dl> <p>For information about choosing a hyperparameter scale, see <a href="http://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type">Hyperparameter Scaling</a>. One of the following values:</p>', ], ], 'Schema' => [ 'base' => '<p>Defines the fields of a dataset. You specify this object in the <a>CreateDataset</a> request.</p>', 'refs' => [ 'CreateDatasetRequest$Schema' => '<p>The schema for the dataset. The schema attributes and their order must match the fields in your data. The dataset <code>Domain</code> and <code>DatasetType</code> that you choose determine the minimum required fields in your training data. For information about the required fields for a specific dataset domain and type, see <a>howitworks-domains-ds-types</a>.</p>', 'DescribeDatasetResponse$Schema' => '<p>An array of <code>SchemaAttribute</code> objects that specify the dataset fields. Each <code>SchemaAttribute</code> specifies the name and data type of a field.</p>', ], ], 'SchemaAttribute' => [ 'base' => '<p>An attribute of a schema, which defines a dataset field. A schema attribute is required for every field in a dataset. The <a>Schema</a> object contains an array of <code>SchemaAttribute</code> objects.</p>', 'refs' => [ 'SchemaAttributes$member' => NULL, ], ], 'SchemaAttributes' => [ 'base' => NULL, 'refs' => [ 'Schema$Attributes' => '<p>An array of attributes specifying the name and type of each field in a dataset.</p>', ], ], 'Statistics' => [ 'base' => '<p>Provides statistics for each data field imported into to an Amazon Forecast dataset with the <a>CreateDatasetImportJob</a> operation.</p>', 'refs' => [ 'FieldStatistics$value' => NULL, ], ], 'Status' => [ 'base' => NULL, 'refs' => [ 'DatasetImportJobSummary$Status' => '<p>The status of the dataset import job. The status is reflected in the status of the dataset. For example, when the import job status is <code>CREATE_IN_PROGRESS</code>, the status of the dataset is <code>UPDATE_IN_PROGRESS</code>. States include:</p> <ul> <li> <p> <code>ACTIVE</code> </p> </li> <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li> <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li> </ul>', 'DescribeDatasetGroupResponse$Status' => '<p>The status of the dataset group. States include:</p> <ul> <li> <p> <code>ACTIVE</code> </p> </li> <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li> <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li> <li> <p> <code>UPDATE_PENDING</code>, <code>UPDATE_IN_PROGRESS</code>, <code>UPDATE_FAILED</code> </p> </li> </ul> <p>The <code>UPDATE</code> states apply when you call the <a>UpdateDatasetGroup</a> operation.</p> <note> <p>The <code>Status</code> of the dataset group must be <code>ACTIVE</code> before you can use the dataset group to create a predictor.</p> </note>', 'DescribeDatasetImportJobResponse$Status' => '<p>The status of the dataset import job. The status is reflected in the status of the dataset. For example, when the import job status is <code>CREATE_IN_PROGRESS</code>, the status of the dataset is <code>UPDATE_IN_PROGRESS</code>. States include:</p> <ul> <li> <p> <code>ACTIVE</code> </p> </li> <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li> <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li> </ul>', 'DescribeDatasetResponse$Status' => '<p>The status of the dataset. States include:</p> <ul> <li> <p> <code>ACTIVE</code> </p> </li> <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li> <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li> <li> <p> <code>UPDATE_PENDING</code>, <code>UPDATE_IN_PROGRESS</code>, <code>UPDATE_FAILED</code> </p> </li> </ul> <p>The <code>UPDATE</code> states apply while data is imported to the dataset from a call to the <a>CreateDatasetImportJob</a> operation and reflect the status of the dataset import job. For example, when the import job status is <code>CREATE_IN_PROGRESS</code>, the status of the dataset is <code>UPDATE_IN_PROGRESS</code>.</p> <note> <p>The <code>Status</code> of the dataset must be <code>ACTIVE</code> before you can import training data.</p> </note>', 'DescribeForecastExportJobResponse$Status' => '<p>The status of the forecast export job. States include:</p> <ul> <li> <p> <code>ACTIVE</code> </p> </li> <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li> <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li> </ul> <note> <p>The <code>Status</code> of the forecast export job must be <code>ACTIVE</code> before you can access the forecast in your S3 bucket.</p> </note>', 'DescribePredictorResponse$Status' => '<p>The status of the predictor. States include:</p> <ul> <li> <p> <code>ACTIVE</code> </p> </li> <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li> <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li> <li> <p> <code>UPDATE_PENDING</code>, <code>UPDATE_IN_PROGRESS</code>, <code>UPDATE_FAILED</code> </p> </li> </ul> <note> <p>The <code>Status</code> of the predictor must be <code>ACTIVE</code> before you can use the predictor to create a forecast.</p> </note>', 'ForecastExportJobSummary$Status' => '<p>The status of the forecast export job. States include:</p> <ul> <li> <p> <code>ACTIVE</code> </p> </li> <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li> <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li> </ul> <note> <p>The <code>Status</code> of the forecast export job must be <code>ACTIVE</code> before you can access the forecast in your S3 bucket.</p> </note>', 'ForecastSummary$Status' => '<p>The status of the forecast. States include:</p> <ul> <li> <p> <code>ACTIVE</code> </p> </li> <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li> <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li> </ul> <note> <p>The <code>Status</code> of the forecast must be <code>ACTIVE</code> before you can query or export the forecast.</p> </note>', 'PredictorSummary$Status' => '<p>The status of the predictor. States include:</p> <ul> <li> <p> <code>ACTIVE</code> </p> </li> <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li> <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li> <li> <p> <code>UPDATE_PENDING</code>, <code>UPDATE_IN_PROGRESS</code>, <code>UPDATE_FAILED</code> </p> </li> </ul> <note> <p>The <code>Status</code> of the predictor must be <code>ACTIVE</code> before you can use the predictor to create a forecast.</p> </note>', 'TestWindowSummary$Status' => '<p>The status of the test. Possible status values are:</p> <ul> <li> <p> <code>ACTIVE</code> </p> </li> <li> <p> <code>CREATE_IN_PROGRESS</code> </p> </li> <li> <p> <code>CREATE_FAILED</code> </p> </li> </ul>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'DescribeForecastResponse$Status' => '<p>The status of the forecast. States include:</p> <ul> <li> <p> <code>ACTIVE</code> </p> </li> <li> <p> <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li> <li> <p> <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code> </p> </li> </ul> <note> <p>The <code>Status</code> of the forecast must be <code>ACTIVE</code> before you can query or export the forecast.</p> </note>', 'FieldStatistics$key' => NULL, 'Filter$Key' => '<p>The name of the parameter to filter on.</p>', 'ForecastSummary$PredictorArn' => '<p>The ARN of the predictor used to generate the forecast.</p>', 'ForecastSummary$DatasetGroupArn' => '<p>The Amazon Resource Name (ARN) of the dataset group that provided the data used to train the predictor.</p>', 'Statistics$Min' => '<p>For a numeric field, the minimum value in the field.</p>', 'Statistics$Max' => '<p>For a numeric field, the maximum value in the field.</p>', ], ], 'SupplementaryFeature' => [ 'base' => '<p>Describes a supplementary feature of a dataset group. This object is part of the <a>InputDataConfig</a> object.</p> <p>The only supported feature is a holiday calendar. If you use the calendar, all data in the datasets should belong to the same country as the calendar. For the holiday calendar data, see the <a href="http://jollyday.sourceforge.net/data.html">Jollyday</a> web site.</p> <p>India and Korea\'s holidays are not included in the Jollyday library, but both are supported by Amazon Forecast. Their holidays are:</p> <p> <b>"IN" - INDIA</b> </p> <ul> <li> <p> <code>JANUARY 26 - REPUBLIC DAY</code> </p> </li> <li> <p> <code>AUGUST 15 - INDEPENDENCE DAY</code> </p> </li> <li> <p> <code>OCTOBER 2 GANDHI\'S BIRTHDAY</code> </p> </li> </ul> <p> <b>"KR" - KOREA</b> </p> <ul> <li> <p> <code>JANUARY 1 - NEW YEAR</code> </p> </li> <li> <p> <code>MARCH 1 - INDEPENDENCE MOVEMENT DAY</code> </p> </li> <li> <p> <code>MAY 5 - CHILDREN\'S DAY</code> </p> </li> <li> <p> <code>JUNE 6 - MEMORIAL DAY</code> </p> </li> <li> <p> <code>AUGUST 15 - LIBERATION DAY</code> </p> </li> <li> <p> <code>OCTOBER 3 - NATIONAL FOUNDATION DAY</code> </p> </li> <li> <p> <code>OCTOBER 9 - HANGEUL DAY</code> </p> </li> <li> <p> <code>DECEMBER 25 - CHRISTMAS DAY</code> </p> </li> </ul>', 'refs' => [ 'SupplementaryFeatures$member' => NULL, ], ], 'SupplementaryFeatures' => [ 'base' => NULL, 'refs' => [ 'InputDataConfig$SupplementaryFeatures' => '<p>An array of supplementary features. The only supported feature is a holiday calendar.</p>', ], ], 'Tag' => [ 'base' => '<p>The optional metadata that you apply to a resource to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p> <p>The following basic restrictions apply to tags:</p> <ul> <li> <p>Maximum number of tags per resource - 50.</p> </li> <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li> <li> <p>Maximum key length - 128 Unicode characters in UTF-8.</p> </li> <li> <p>Maximum value length - 256 Unicode characters in UTF-8.</p> </li> <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li> <li> <p>Tag keys and values are case sensitive.</p> </li> <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.</p> </li> </ul>', 'refs' => [ 'Tags$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>One part of a key-value pair that makes up a tag. A <code>key</code> is a general label that acts like a category for more specific tag values.</p>', 'TagKeys$member' => NULL, ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The keys of the tags to be removed.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The optional part of a key-value pair that makes up a tag. A <code>value</code> acts as a descriptor within a tag category (key).</p>', ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetGroupRequest$Tags' => '<p>The optional metadata that you apply to the dataset group to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p> <p>The following basic restrictions apply to tags:</p> <ul> <li> <p>Maximum number of tags per resource - 50.</p> </li> <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li> <li> <p>Maximum key length - 128 Unicode characters in UTF-8.</p> </li> <li> <p>Maximum value length - 256 Unicode characters in UTF-8.</p> </li> <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li> <li> <p>Tag keys and values are case sensitive.</p> </li> <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.</p> </li> </ul>', 'CreateDatasetImportJobRequest$Tags' => '<p>The optional metadata that you apply to the dataset import job to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p> <p>The following basic restrictions apply to tags:</p> <ul> <li> <p>Maximum number of tags per resource - 50.</p> </li> <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li> <li> <p>Maximum key length - 128 Unicode characters in UTF-8.</p> </li> <li> <p>Maximum value length - 256 Unicode characters in UTF-8.</p> </li> <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li> <li> <p>Tag keys and values are case sensitive.</p> </li> <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.</p> </li> </ul>', 'CreateDatasetRequest$Tags' => '<p>The optional metadata that you apply to the dataset to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p> <p>The following basic restrictions apply to tags:</p> <ul> <li> <p>Maximum number of tags per resource - 50.</p> </li> <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li> <li> <p>Maximum key length - 128 Unicode characters in UTF-8.</p> </li> <li> <p>Maximum value length - 256 Unicode characters in UTF-8.</p> </li> <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li> <li> <p>Tag keys and values are case sensitive.</p> </li> <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.</p> </li> </ul>', 'CreateForecastExportJobRequest$Tags' => '<p>The optional metadata that you apply to the forecast export job to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p> <p>The following basic restrictions apply to tags:</p> <ul> <li> <p>Maximum number of tags per resource - 50.</p> </li> <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li> <li> <p>Maximum key length - 128 Unicode characters in UTF-8.</p> </li> <li> <p>Maximum value length - 256 Unicode characters in UTF-8.</p> </li> <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li> <li> <p>Tag keys and values are case sensitive.</p> </li> <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.</p> </li> </ul>', 'CreateForecastRequest$Tags' => '<p>The optional metadata that you apply to the forecast to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p> <p>The following basic restrictions apply to tags:</p> <ul> <li> <p>Maximum number of tags per resource - 50.</p> </li> <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li> <li> <p>Maximum key length - 128 Unicode characters in UTF-8.</p> </li> <li> <p>Maximum value length - 256 Unicode characters in UTF-8.</p> </li> <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li> <li> <p>Tag keys and values are case sensitive.</p> </li> <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.</p> </li> </ul>', 'CreatePredictorRequest$Tags' => '<p>The optional metadata that you apply to the predictor to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.</p> <p>The following basic restrictions apply to tags:</p> <ul> <li> <p>Maximum number of tags per resource - 50.</p> </li> <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li> <li> <p>Maximum key length - 128 Unicode characters in UTF-8.</p> </li> <li> <p>Maximum value length - 256 Unicode characters in UTF-8.</p> </li> <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li> <li> <p>Tag keys and values are case sensitive.</p> </li> <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.</p> </li> </ul>', 'ListTagsForResourceResponse$Tags' => '<p>The tags for the resource.</p>', 'TagResourceRequest$Tags' => '<p>The tags to add to the resource. A tag is an array of key-value pairs.</p> <p>The following basic restrictions apply to tags:</p> <ul> <li> <p>Maximum number of tags per resource - 50.</p> </li> <li> <p>For each resource, each tag key must be unique, and each tag key can have only one value.</p> </li> <li> <p>Maximum key length - 128 Unicode characters in UTF-8.</p> </li> <li> <p>Maximum value length - 256 Unicode characters in UTF-8.</p> </li> <li> <p>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.</p> </li> <li> <p>Tag keys and values are case sensitive.</p> </li> <li> <p>Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.</p> </li> </ul>', ], ], 'TestWindowDetails' => [ 'base' => NULL, 'refs' => [ 'PredictorExecution$TestWindows' => '<p>An array of test windows used to evaluate the algorithm. The <code>NumberOfBacktestWindows</code> from the object determines the number of windows in the array.</p>', ], ], 'TestWindowSummary' => [ 'base' => '<p>The status, start time, and end time of a backtest, as well as a failure reason if applicable.</p>', 'refs' => [ 'TestWindowDetails$member' => NULL, ], ], 'TestWindows' => [ 'base' => NULL, 'refs' => [ 'EvaluationResult$TestWindows' => '<p>The array of test windows used for evaluating the algorithm. The <code>NumberOfBacktestWindows</code> from the <a>EvaluationParameters</a> object determines the number of windows in the array.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'DatasetGroupSummary$CreationTime' => '<p>When the dataset group was created.</p>', 'DatasetGroupSummary$LastModificationTime' => '<p>When the dataset group was created or last updated from a call to the <a>UpdateDatasetGroup</a> operation. While the dataset group is being updated, <code>LastModificationTime</code> is the current time of the <code>ListDatasetGroups</code> call.</p>', 'DatasetImportJobSummary$CreationTime' => '<p>When the dataset import job was created.</p>', 'DatasetImportJobSummary$LastModificationTime' => '<p>The last time that the dataset was modified. The time depends on the status of the job, as follows:</p> <ul> <li> <p> <code>CREATE_PENDING</code> - The same time as <code>CreationTime</code>.</p> </li> <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li> <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li> </ul>', 'DatasetSummary$CreationTime' => '<p>When the dataset was created.</p>', 'DatasetSummary$LastModificationTime' => '<p>When you create a dataset, <code>LastModificationTime</code> is the same as <code>CreationTime</code>. While data is being imported to the dataset, <code>LastModificationTime</code> is the current time of the <code>ListDatasets</code> call. After a <a>CreateDatasetImportJob</a> operation has finished, <code>LastModificationTime</code> is when the import job completed or failed.</p>', 'DescribeDatasetGroupResponse$CreationTime' => '<p>When the dataset group was created.</p>', 'DescribeDatasetGroupResponse$LastModificationTime' => '<p>When the dataset group was created or last updated from a call to the <a>UpdateDatasetGroup</a> operation. While the dataset group is being updated, <code>LastModificationTime</code> is the current time of the <code>DescribeDatasetGroup</code> call.</p>', 'DescribeDatasetImportJobResponse$CreationTime' => '<p>When the dataset import job was created.</p>', 'DescribeDatasetImportJobResponse$LastModificationTime' => '<p>The last time that the dataset was modified. The time depends on the status of the job, as follows:</p> <ul> <li> <p> <code>CREATE_PENDING</code> - The same time as <code>CreationTime</code>.</p> </li> <li> <p> <code>CREATE_IN_PROGRESS</code> - The current timestamp.</p> </li> <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.</p> </li> </ul>', 'DescribeDatasetResponse$CreationTime' => '<p>When the dataset was created.</p>', 'DescribeDatasetResponse$LastModificationTime' => '<p>When you create a dataset, <code>LastModificationTime</code> is the same as <code>CreationTime</code>. While data is being imported to the dataset, <code>LastModificationTime</code> is the current time of the <code>DescribeDataset</code> call. After a <a>CreateDatasetImportJob</a> operation has finished, <code>LastModificationTime</code> is when the import job completed or failed.</p>', 'DescribeForecastExportJobResponse$CreationTime' => '<p>When the forecast export job was created.</p>', 'DescribeForecastExportJobResponse$LastModificationTime' => '<p>When the last successful export job finished.</p>', 'DescribeForecastResponse$CreationTime' => '<p>When the forecast creation task was created.</p>', 'DescribeForecastResponse$LastModificationTime' => '<p>Initially, the same as <code>CreationTime</code> (status is <code>CREATE_PENDING</code>). Updated when inference (creating the forecast) starts (status changed to <code>CREATE_IN_PROGRESS</code>), and when inference is complete (status changed to <code>ACTIVE</code>) or fails (status changed to <code>CREATE_FAILED</code>).</p>', 'DescribePredictorResponse$CreationTime' => '<p>When the model training task was created.</p>', 'DescribePredictorResponse$LastModificationTime' => '<p>Initially, the same as <code>CreationTime</code> (when the status is <code>CREATE_PENDING</code>). This value is updated when training starts (when the status changes to <code>CREATE_IN_PROGRESS</code>), and when training has completed (when the status changes to <code>ACTIVE</code>) or fails (when the status changes to <code>CREATE_FAILED</code>).</p>', 'ForecastExportJobSummary$CreationTime' => '<p>When the forecast export job was created.</p>', 'ForecastExportJobSummary$LastModificationTime' => '<p>When the last successful export job finished.</p>', 'ForecastSummary$CreationTime' => '<p>When the forecast creation task was created.</p>', 'ForecastSummary$LastModificationTime' => '<p>Initially, the same as <code>CreationTime</code> (status is <code>CREATE_PENDING</code>). Updated when inference (creating the forecast) starts (status changed to <code>CREATE_IN_PROGRESS</code>), and when inference is complete (status changed to <code>ACTIVE</code>) or fails (status changed to <code>CREATE_FAILED</code>).</p>', 'PredictorSummary$CreationTime' => '<p>When the model training task was created.</p>', 'PredictorSummary$LastModificationTime' => '<p>Initially, the same as <code>CreationTime</code> (status is <code>CREATE_PENDING</code>). Updated when training starts (status changed to <code>CREATE_IN_PROGRESS</code>), and when training is complete (status changed to <code>ACTIVE</code>) or fails (status changed to <code>CREATE_FAILED</code>).</p>', 'TestWindowSummary$TestWindowStart' => '<p>The time at which the test began.</p>', 'TestWindowSummary$TestWindowEnd' => '<p>The time at which the test ended.</p>', 'WindowSummary$TestWindowStart' => '<p>The timestamp that defines the start of the window.</p>', 'WindowSummary$TestWindowEnd' => '<p>The timestamp that defines the end of the window.</p>', ], ], 'TimestampFormat' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetImportJobRequest$TimestampFormat' => '<p>The format of timestamps in the dataset. The format that you specify depends on the <code>DataFrequency</code> specified when the dataset was created. The following formats are supported</p> <ul> <li> <p>"yyyy-MM-dd"</p> <p>For the following data frequencies: Y, M, W, and D</p> </li> <li> <p>"yyyy-MM-dd HH:mm:ss"</p> <p>For the following data frequencies: H, 30min, 15min, and 1min; and optionally, for: Y, M, W, and D</p> </li> </ul> <p>If the format isn\'t specified, Amazon Forecast expects the format to be "yyyy-MM-dd HH:mm:ss".</p>', 'DescribeDatasetImportJobResponse$TimestampFormat' => '<p>The format of timestamps in the dataset. The format that you specify depends on the <code>DataFrequency</code> specified when the dataset was created. The following formats are supported</p> <ul> <li> <p>"yyyy-MM-dd"</p> <p>For the following data frequencies: Y, M, W, and D</p> </li> <li> <p>"yyyy-MM-dd HH:mm:ss"</p> <p>For the following data frequencies: H, 30min, 15min, and 1min; and optionally, for: Y, M, W, and D</p> </li> </ul>', ], ], 'TrainingParameters' => [ 'base' => NULL, 'refs' => [ 'CreatePredictorRequest$TrainingParameters' => '<p>The hyperparameters to override for model training. The hyperparameters that you can override are listed in the individual algorithms. For the list of supported algorithms, see <a>aws-forecast-choosing-recipes</a>.</p>', 'DescribePredictorResponse$TrainingParameters' => '<p>The default training parameters or overrides selected during model training. If using the AutoML algorithm or if HPO is turned on while using the DeepAR+ algorithms, the optimized values for the chosen hyperparameters are returned. For more information, see <a>aws-forecast-choosing-recipes</a>.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDatasetGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDatasetGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'Value' => [ 'base' => NULL, 'refs' => [ 'SupplementaryFeature$Value' => '<p>One of the following 2 letter country codes:</p> <ul> <li> <p>"AR" - ARGENTINA</p> </li> <li> <p>"AT" - AUSTRIA</p> </li> <li> <p>"AU" - AUSTRALIA</p> </li> <li> <p>"BE" - BELGIUM</p> </li> <li> <p>"BR" - BRAZIL</p> </li> <li> <p>"CA" - CANADA</p> </li> <li> <p>"CN" - CHINA</p> </li> <li> <p>"CZ" - CZECH REPUBLIC</p> </li> <li> <p>"DK" - DENMARK</p> </li> <li> <p>"EC" - ECUADOR</p> </li> <li> <p>"FI" - FINLAND</p> </li> <li> <p>"FR" - FRANCE</p> </li> <li> <p>"DE" - GERMANY</p> </li> <li> <p>"HU" - HUNGARY</p> </li> <li> <p>"IE" - IRELAND</p> </li> <li> <p>"IN" - INDIA</p> </li> <li> <p>"IT" - ITALY</p> </li> <li> <p>"JP" - JAPAN</p> </li> <li> <p>"KR" - KOREA</p> </li> <li> <p>"LU" - LUXEMBOURG</p> </li> <li> <p>"MX" - MEXICO</p> </li> <li> <p>"NL" - NETHERLANDS</p> </li> <li> <p>"NO" - NORWAY</p> </li> <li> <p>"PL" - POLAND</p> </li> <li> <p>"PT" - PORTUGAL</p> </li> <li> <p>"RU" - RUSSIA</p> </li> <li> <p>"ZA" - SOUTH AFRICA</p> </li> <li> <p>"ES" - SPAIN</p> </li> <li> <p>"SE" - SWEDEN</p> </li> <li> <p>"CH" - SWITZERLAND</p> </li> <li> <p>"US" - UNITED STATES</p> </li> <li> <p>"UK" - UNITED KINGDOM</p> </li> </ul>', 'Values$member' => NULL, ], ], 'Values' => [ 'base' => NULL, 'refs' => [ 'CategoricalParameterRange$Values' => '<p>A list of the tunable categories for the hyperparameter.</p>', ], ], 'WeightedQuantileLoss' => [ 'base' => '<p>The weighted loss value for a quantile. This object is part of the <a>Metrics</a> object.</p>', 'refs' => [ 'WeightedQuantileLosses$member' => NULL, ], ], 'WeightedQuantileLosses' => [ 'base' => NULL, 'refs' => [ 'Metrics$WeightedQuantileLosses' => '<p>An array of weighted quantile losses. Quantiles divide a probability distribution into regions of equal probability. The distribution in this case is the loss function.</p>', ], ], 'WindowSummary' => [ 'base' => '<p>The metrics for a time range within the evaluation portion of a dataset. This object is part of the <a>EvaluationResult</a> object.</p> <p>The <code>TestWindowStart</code> and <code>TestWindowEnd</code> parameters are determined by the <code>BackTestWindowOffset</code> parameter of the <a>EvaluationParameters</a> object.</p>', 'refs' => [ 'TestWindows$member' => NULL, ], ], ],];
