<?php
// This file was auto-generated from sdk-root/src/data/firehose/2015-08-04/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon Kinesis Data Firehose API Reference</fullname> <p>Amazon Kinesis Data Firehose is a fully managed service that delivers real-time streaming data to destinations such as Amazon Simple Storage Service (Amazon S3), Amazon Elasticsearch Service (Amazon ES), Amazon Redshift, and Splunk.</p>', 'operations' => [ 'CreateDeliveryStream' => '<p>Creates a Kinesis Data Firehose delivery stream.</p> <p>By default, you can create up to 50 delivery streams per AWS Region.</p> <p>This is an asynchronous operation that immediately returns. The initial status of the delivery stream is <code>CREATING</code>. After the delivery stream is created, its status is <code>ACTIVE</code> and it now accepts data. If the delivery stream creation fails, the status transitions to <code>CREATING_FAILED</code>. Attempts to send data to a delivery stream that is not in the <code>ACTIVE</code> state cause an exception. To check the state of a delivery stream, use <a>DescribeDeliveryStream</a>.</p> <p>If the status of a delivery stream is <code>CREATING_FAILED</code>, this status doesn\'t change, and you can\'t invoke <code>CreateDeliveryStream</code> again on it. However, you can invoke the <a>DeleteDeliveryStream</a> operation to delete it.</p> <p>A Kinesis Data Firehose delivery stream can be configured to receive records directly from providers using <a>PutRecord</a> or <a>PutRecordBatch</a>, or it can be configured to use an existing Kinesis stream as its source. To specify a Kinesis data stream as input, set the <code>DeliveryStreamType</code> parameter to <code>KinesisStreamAsSource</code>, and provide the Kinesis stream Amazon Resource Name (ARN) and role ARN in the <code>KinesisStreamSourceConfiguration</code> parameter.</p> <p>To create a delivery stream with server-side encryption (SSE) enabled, include <a>DeliveryStreamEncryptionConfigurationInput</a> in your request. This is optional. You can also invoke <a>StartDeliveryStreamEncryption</a> to turn on SSE for an existing delivery stream that doesn\'t have SSE enabled.</p> <p>A delivery stream is configured with a single destination: Amazon S3, Amazon ES, Amazon Redshift, or Splunk. You must specify only one of the following destination configuration parameters: <code>ExtendedS3DestinationConfiguration</code>, <code>S3DestinationConfiguration</code>, <code>ElasticsearchDestinationConfiguration</code>, <code>RedshiftDestinationConfiguration</code>, or <code>SplunkDestinationConfiguration</code>.</p> <p>When you specify <code>S3DestinationConfiguration</code>, you can also provide the following optional values: BufferingHints, <code>EncryptionConfiguration</code>, and <code>CompressionFormat</code>. By default, if no <code>BufferingHints</code> value is provided, Kinesis Data Firehose buffers data up to 5 MB or for 5 minutes, whichever condition is satisfied first. <code>BufferingHints</code> is a hint, so there are some cases where the service cannot adhere to these conditions strictly. For example, record boundaries might be such that the size is a little over or under the configured buffering size. By default, no encryption is performed. We strongly recommend that you enable encryption to ensure secure data storage in Amazon S3.</p> <p>A few notes about Amazon Redshift as a destination:</p> <ul> <li> <p>An Amazon Redshift destination requires an S3 bucket as intermediate location. Kinesis Data Firehose first delivers data to Amazon S3 and then uses <code>COPY</code> syntax to load data into an Amazon Redshift table. This is specified in the <code>RedshiftDestinationConfiguration.S3Configuration</code> parameter.</p> </li> <li> <p>The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified in <code>RedshiftDestinationConfiguration.S3Configuration</code> because the Amazon Redshift <code>COPY</code> operation that reads from the S3 bucket doesn\'t support these compression formats.</p> </li> <li> <p>We strongly recommend that you use the user name and password you provide exclusively with Kinesis Data Firehose, and that the permissions for the account are restricted for Amazon Redshift <code>INSERT</code> permissions.</p> </li> </ul> <p>Kinesis Data Firehose assumes the IAM role that is configured as part of the destination. The role should allow the Kinesis Data Firehose principal to assume the role, and the role should have permissions that allow the service to deliver the data. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Grant Kinesis Data Firehose Access to an Amazon S3 Destination</a> in the <i>Amazon Kinesis Data Firehose Developer Guide</i>.</p>', 'DeleteDeliveryStream' => '<p>Deletes a delivery stream and its data.</p> <p>To check the state of a delivery stream, use <a>DescribeDeliveryStream</a>. You can delete a delivery stream only if it is in one of the following states: <code>ACTIVE</code>, <code>DELETING</code>, <code>CREATING_FAILED</code>, or <code>DELETING_FAILED</code>. You can\'t delete a delivery stream that is in the <code>CREATING</code> state. While the deletion request is in process, the delivery stream is in the <code>DELETING</code> state.</p> <p>While the delivery stream is in the <code>DELETING</code> state, the service might continue to accept records, but it doesn\'t make any guarantees with respect to delivering the data. Therefore, as a best practice, first stop any applications that are sending records before you delete a delivery stream.</p>', 'DescribeDeliveryStream' => '<p>Describes the specified delivery stream and its status. For example, after your delivery stream is created, call <code>DescribeDeliveryStream</code> to see whether the delivery stream is <code>ACTIVE</code> and therefore ready for data to be sent to it. </p> <p>If the status of a delivery stream is <code>CREATING_FAILED</code>, this status doesn\'t change, and you can\'t invoke <a>CreateDeliveryStream</a> again on it. However, you can invoke the <a>DeleteDeliveryStream</a> operation to delete it. If the status is <code>DELETING_FAILED</code>, you can force deletion by invoking <a>DeleteDeliveryStream</a> again but with <a>DeleteDeliveryStreamInput$AllowForceDelete</a> set to true.</p>', 'ListDeliveryStreams' => '<p>Lists your delivery streams in alphabetical order of their names.</p> <p>The number of delivery streams might be too large to return using a single call to <code>ListDeliveryStreams</code>. You can limit the number of delivery streams returned, using the <code>Limit</code> parameter. To determine whether there are more delivery streams to list, check the value of <code>HasMoreDeliveryStreams</code> in the output. If there are more delivery streams to list, you can request them by calling this operation again and setting the <code>ExclusiveStartDeliveryStreamName</code> parameter to the name of the last delivery stream returned in the last call.</p>', 'ListTagsForDeliveryStream' => '<p>Lists the tags for the specified delivery stream. This operation has a limit of five transactions per second per account. </p>', 'PutRecord' => '<p>Writes a single data record into an Amazon Kinesis Data Firehose delivery stream. To write multiple data records into a delivery stream, use <a>PutRecordBatch</a>. Applications using these operations are referred to as producers.</p> <p>By default, each delivery stream can take in up to 2,000 transactions per second, 5,000 records per second, or 5 MB per second. If you use <a>PutRecord</a> and <a>PutRecordBatch</a>, the limits are an aggregate across these two operations for each delivery stream. For more information about limits and how to request an increase, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/limits.html">Amazon Kinesis Data Firehose Limits</a>. </p> <p>You must specify the name of the delivery stream and the data record when using <a>PutRecord</a>. The data record consists of a data blob that can be up to 1,000 KB in size, and any kind of data. For example, it can be a segment from a log file, geographic location data, website clickstream data, and so on.</p> <p>Kinesis Data Firehose buffers records before delivering them to the destination. To disambiguate the data blobs at the destination, a common solution is to use delimiters in the data, such as a newline (<code>\\n</code>) or some other character unique within the data. This allows the consumer application to parse individual data items when reading the data from the destination.</p> <p>The <code>PutRecord</code> operation returns a <code>RecordId</code>, which is a unique string assigned to each record. Producer applications can use this ID for purposes such as auditability and investigation.</p> <p>If the <code>PutRecord</code> operation throws a <code>ServiceUnavailableException</code>, back off and retry. If the exception persists, it is possible that the throughput limits have been exceeded for the delivery stream. </p> <p>Data records sent to Kinesis Data Firehose are stored for 24 hours from the time they are added to a delivery stream as it tries to send the records to the destination. If the destination is unreachable for more than 24 hours, the data is no longer available.</p> <important> <p>Don\'t concatenate two or more base64 strings to form the data fields of your records. Instead, concatenate the raw data, then perform base64 encoding.</p> </important>', 'PutRecordBatch' => '<p>Writes multiple data records into a delivery stream in a single call, which can achieve higher throughput per producer than when writing single records. To write single data records into a delivery stream, use <a>PutRecord</a>. Applications using these operations are referred to as producers.</p> <p>For information about service quota, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/limits.html">Amazon Kinesis Data Firehose Quota</a>.</p> <p>Each <a>PutRecordBatch</a> request supports up to 500 records. Each record in the request can be as large as 1,000 KB (before 64-bit encoding), up to a limit of 4 MB for the entire request. These limits cannot be changed.</p> <p>You must specify the name of the delivery stream and the data record when using <a>PutRecord</a>. The data record consists of a data blob that can be up to 1,000 KB in size, and any kind of data. For example, it could be a segment from a log file, geographic location data, website clickstream data, and so on.</p> <p>Kinesis Data Firehose buffers records before delivering them to the destination. To disambiguate the data blobs at the destination, a common solution is to use delimiters in the data, such as a newline (<code>\\n</code>) or some other character unique within the data. This allows the consumer application to parse individual data items when reading the data from the destination.</p> <p>The <a>PutRecordBatch</a> response includes a count of failed records, <code>FailedPutCount</code>, and an array of responses, <code>RequestResponses</code>. Even if the <a>PutRecordBatch</a> call succeeds, the value of <code>FailedPutCount</code> may be greater than 0, indicating that there are records for which the operation didn\'t succeed. Each entry in the <code>RequestResponses</code> array provides additional information about the processed record. It directly correlates with a record in the request array using the same ordering, from the top to the bottom. The response array always includes the same number of records as the request array. <code>RequestResponses</code> includes both successfully and unsuccessfully processed records. Kinesis Data Firehose tries to process all records in each <a>PutRecordBatch</a> request. A single record failure does not stop the processing of subsequent records. </p> <p>A successfully processed record includes a <code>RecordId</code> value, which is unique for the record. An unsuccessfully processed record includes <code>ErrorCode</code> and <code>ErrorMessage</code> values. <code>ErrorCode</code> reflects the type of error, and is one of the following values: <code>ServiceUnavailableException</code> or <code>InternalFailure</code>. <code>ErrorMessage</code> provides more detailed information about the error.</p> <p>If there is an internal server error or a timeout, the write might have completed or it might have failed. If <code>FailedPutCount</code> is greater than 0, retry the request, resending only those records that might have failed processing. This minimizes the possible duplicate records and also reduces the total bytes sent (and corresponding charges). We recommend that you handle any duplicates at the destination.</p> <p>If <a>PutRecordBatch</a> throws <code>ServiceUnavailableException</code>, back off and retry. If the exception persists, it is possible that the throughput limits have been exceeded for the delivery stream.</p> <p>Data records sent to Kinesis Data Firehose are stored for 24 hours from the time they are added to a delivery stream as it attempts to send the records to the destination. If the destination is unreachable for more than 24 hours, the data is no longer available.</p> <important> <p>Don\'t concatenate two or more base64 strings to form the data fields of your records. Instead, concatenate the raw data, then perform base64 encoding.</p> </important>', 'StartDeliveryStreamEncryption' => '<p>Enables server-side encryption (SSE) for the delivery stream. </p> <p>This operation is asynchronous. It returns immediately. When you invoke it, Kinesis Data Firehose first sets the encryption status of the stream to <code>ENABLING</code>, and then to <code>ENABLED</code>. The encryption status of a delivery stream is the <code>Status</code> property in <a>DeliveryStreamEncryptionConfiguration</a>. If the operation fails, the encryption status changes to <code>ENABLING_FAILED</code>. You can continue to read and write data to your delivery stream while the encryption status is <code>ENABLING</code>, but the data is not encrypted. It can take up to 5 seconds after the encryption status changes to <code>ENABLED</code> before all records written to the delivery stream are encrypted. To find out whether a record or a batch of records was encrypted, check the response elements <a>PutRecordOutput$Encrypted</a> and <a>PutRecordBatchOutput$Encrypted</a>, respectively.</p> <p>To check the encryption status of a delivery stream, use <a>DescribeDeliveryStream</a>.</p> <p>Even if encryption is currently enabled for a delivery stream, you can still invoke this operation on it to change the ARN of the CMK or both its type and ARN. If you invoke this method to change the CMK, and the old CMK is of type <code>CUSTOMER_MANAGED_CMK</code>, Kinesis Data Firehose schedules the grant it had on the old CMK for retirement. If the new CMK is of type <code>CUSTOMER_MANAGED_CMK</code>, Kinesis Data Firehose creates a grant that enables it to use the new CMK to encrypt and decrypt data and to manage the grant.</p> <p>If a delivery stream already has encryption enabled and then you invoke this operation to change the ARN of the CMK or both its type and ARN and you get <code>ENABLING_FAILED</code>, this only means that the attempt to change the CMK failed. In this case, encryption remains enabled with the old CMK.</p> <p>If the encryption status of your delivery stream is <code>ENABLING_FAILED</code>, you can invoke this operation again with a valid CMK. The CMK must be enabled and the key policy mustn\'t explicitly deny the permission for Kinesis Data Firehose to invoke KMS encrypt and decrypt operations.</p> <p>You can enable SSE for a delivery stream only if it\'s a delivery stream that uses <code>DirectPut</code> as its source. </p> <p>The <code>StartDeliveryStreamEncryption</code> and <code>StopDeliveryStreamEncryption</code> operations have a combined limit of 25 calls per delivery stream per 24 hours. For example, you reach the limit if you call <code>StartDeliveryStreamEncryption</code> 13 times and <code>StopDeliveryStreamEncryption</code> 12 times for the same delivery stream in a 24-hour period.</p>', 'StopDeliveryStreamEncryption' => '<p>Disables server-side encryption (SSE) for the delivery stream. </p> <p>This operation is asynchronous. It returns immediately. When you invoke it, Kinesis Data Firehose first sets the encryption status of the stream to <code>DISABLING</code>, and then to <code>DISABLED</code>. You can continue to read and write data to your stream while its status is <code>DISABLING</code>. It can take up to 5 seconds after the encryption status changes to <code>DISABLED</code> before all records written to the delivery stream are no longer subject to encryption. To find out whether a record or a batch of records was encrypted, check the response elements <a>PutRecordOutput$Encrypted</a> and <a>PutRecordBatchOutput$Encrypted</a>, respectively.</p> <p>To check the encryption state of a delivery stream, use <a>DescribeDeliveryStream</a>. </p> <p>If SSE is enabled using a customer managed CMK and then you invoke <code>StopDeliveryStreamEncryption</code>, Kinesis Data Firehose schedules the related KMS grant for retirement and then retires it after it ensures that it is finished delivering records to the destination.</p> <p>The <code>StartDeliveryStreamEncryption</code> and <code>StopDeliveryStreamEncryption</code> operations have a combined limit of 25 calls per delivery stream per 24 hours. For example, you reach the limit if you call <code>StartDeliveryStreamEncryption</code> 13 times and <code>StopDeliveryStreamEncryption</code> 12 times for the same delivery stream in a 24-hour period.</p>', 'TagDeliveryStream' => '<p>Adds or updates tags for the specified delivery stream. A tag is a key-value pair that you can define and assign to AWS resources. If you specify a tag that already exists, the tag value is replaced with the value that you specify in the request. Tags are metadata. For example, you can add friendly names and descriptions or other types of information that can help you distinguish the delivery stream. For more information about tags, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>. </p> <p>Each delivery stream can have up to 50 tags. </p> <p>This operation has a limit of five transactions per second per account. </p>', 'UntagDeliveryStream' => '<p>Removes tags from the specified delivery stream. Removed tags are deleted, and you can\'t recover them after this operation successfully completes.</p> <p>If you specify a tag that doesn\'t exist, the operation ignores it.</p> <p>This operation has a limit of five transactions per second per account. </p>', 'UpdateDestination' => '<p>Updates the specified destination of the specified delivery stream.</p> <p>Use this operation to change the destination type (for example, to replace the Amazon S3 destination with Amazon Redshift) or change the parameters associated with a destination (for example, to change the bucket name of the Amazon S3 destination). The update might not occur immediately. The target delivery stream remains active while the configurations are updated, so data writes to the delivery stream can continue during this process. The updated configurations are usually effective within a few minutes.</p> <p>Switching between Amazon ES and other services is not supported. For an Amazon ES destination, you can only update to another Amazon ES destination.</p> <p>If the destination type is the same, Kinesis Data Firehose merges the configuration parameters specified with the destination configuration that already exists on the delivery stream. If any of the parameters are not specified in the call, the existing values are retained. For example, in the Amazon S3 destination, if <a>EncryptionConfiguration</a> is not specified, then the existing <code>EncryptionConfiguration</code> is maintained on the destination.</p> <p>If the destination type is not the same, for example, changing the destination from Amazon S3 to Amazon Redshift, Kinesis Data Firehose does not merge any parameters. In this case, all parameters must be specified.</p> <p>Kinesis Data Firehose uses <code>CurrentDeliveryStreamVersionId</code> to avoid race conditions and conflicting merges. This is a required field, and the service updates the configuration only if the existing configuration has a version ID that matches. After the update is applied successfully, the version ID is updated, and can be retrieved using <a>DescribeDeliveryStream</a>. Use the new version ID to set <code>CurrentDeliveryStreamVersionId</code> in the next call.</p>', ], 'shapes' => [ 'AWSKMSKeyARN' => [ 'base' => NULL, 'refs' => [ 'DeliveryStreamEncryptionConfiguration$KeyARN' => '<p>If <code>KeyType</code> is <code>CUSTOMER_MANAGED_CMK</code>, this field contains the ARN of the customer managed CMK. If <code>KeyType</code> is <code>AWS_OWNED_CMK</code>, <code>DeliveryStreamEncryptionConfiguration</code> doesn\'t contain a value for <code>KeyARN</code>.</p>', 'DeliveryStreamEncryptionConfigurationInput$KeyARN' => '<p>If you set <code>KeyType</code> to <code>CUSTOMER_MANAGED_CMK</code>, you must specify the Amazon Resource Name (ARN) of the CMK. If you set <code>KeyType</code> to <code>AWS_OWNED_CMK</code>, Kinesis Data Firehose uses a service-account CMK.</p>', 'KMSEncryptionConfig$AWSKMSKeyARN' => '<p>The Amazon Resource Name (ARN) of the encryption key. Must belong to the same AWS Region as the destination Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.</p>', ], ], 'BlockSizeBytes' => [ 'base' => NULL, 'refs' => [ 'OrcSerDe$BlockSizeBytes' => '<p>The Hadoop Distributed File System (HDFS) block size. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the minimum is 64 MiB. Kinesis Data Firehose uses this value for padding calculations.</p>', 'ParquetSerDe$BlockSizeBytes' => '<p>The Hadoop Distributed File System (HDFS) block size. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the minimum is 64 MiB. Kinesis Data Firehose uses this value for padding calculations.</p>', ], ], 'BooleanObject' => [ 'base' => NULL, 'refs' => [ 'CloudWatchLoggingOptions$Enabled' => '<p>Enables or disables CloudWatch logging.</p>', 'DataFormatConversionConfiguration$Enabled' => '<p>Defaults to <code>true</code>. Set it to <code>false</code> if you want to disable format conversion while preserving the configuration details.</p>', 'DeleteDeliveryStreamInput$AllowForceDelete' => '<p>Set this to true if you want to delete the delivery stream even if Kinesis Data Firehose is unable to retire the grant for the CMK. Kinesis Data Firehose might be unable to retire the grant due to a customer error, such as when the CMK or the grant are in an invalid state. If you force deletion, you can then use the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html">RevokeGrant</a> operation to revoke the grant you gave to Kinesis Data Firehose. If a failure to retire the grant happens due to an AWS KMS issue, Kinesis Data Firehose keeps retrying the delete operation.</p> <p>The default value is false.</p>', 'DeliveryStreamDescription$HasMoreDestinations' => '<p>Indicates whether there are more destinations available to list.</p>', 'ListDeliveryStreamsOutput$HasMoreDeliveryStreams' => '<p>Indicates whether there are more delivery streams available to list.</p>', 'ListTagsForDeliveryStreamOutput$HasMoreTags' => '<p>If this is <code>true</code> in the response, more tags are available. To list the remaining tags, set <code>ExclusiveStartTagKey</code> to the key of the last tag returned and call <code>ListTagsForDeliveryStream</code> again.</p>', 'OpenXJsonSerDe$ConvertDotsInJsonKeysToUnderscores' => '<p>When set to <code>true</code>, specifies that the names of the keys include dots and that you want Kinesis Data Firehose to replace them with underscores. This is useful because Apache Hive does not allow dots in column names. For example, if the JSON contains a key whose name is "a.b", you can define the column name to be "a_b" when using this option.</p> <p>The default is <code>false</code>.</p>', 'OpenXJsonSerDe$CaseInsensitive' => '<p>When set to <code>true</code>, which is the default, Kinesis Data Firehose converts JSON keys to lowercase before deserializing them.</p>', 'OrcSerDe$EnablePadding' => '<p>Set this to <code>true</code> to indicate that you want stripes to be padded to the HDFS block boundaries. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is <code>false</code>.</p>', 'ParquetSerDe$EnableDictionaryCompression' => '<p>Indicates whether to enable dictionary compression.</p>', 'ProcessingConfiguration$Enabled' => '<p>Enables or disables data processing.</p>', 'PutRecordBatchOutput$Encrypted' => '<p>Indicates whether server-side encryption (SSE) was enabled during this operation.</p>', 'PutRecordOutput$Encrypted' => '<p>Indicates whether server-side encryption (SSE) was enabled during this operation.</p>', ], ], 'BucketARN' => [ 'base' => NULL, 'refs' => [ 'ExtendedS3DestinationConfiguration$BucketARN' => '<p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.</p>', 'ExtendedS3DestinationDescription$BucketARN' => '<p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.</p>', 'ExtendedS3DestinationUpdate$BucketARN' => '<p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.</p>', 'S3DestinationConfiguration$BucketARN' => '<p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.</p>', 'S3DestinationDescription$BucketARN' => '<p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.</p>', 'S3DestinationUpdate$BucketARN' => '<p>The ARN of the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.</p>', ], ], 'BufferingHints' => [ 'base' => '<p>Describes hints for the buffering to perform before delivering data to the destination. These options are treated as hints, and therefore Kinesis Data Firehose might choose to use different values when it is optimal. The <code>SizeInMBs</code> and <code>IntervalInSeconds</code> parameters are optional. However, if specify a value for one of them, you must also provide a value for the other.</p>', 'refs' => [ 'ExtendedS3DestinationConfiguration$BufferingHints' => '<p>The buffering option.</p>', 'ExtendedS3DestinationDescription$BufferingHints' => '<p>The buffering option.</p>', 'ExtendedS3DestinationUpdate$BufferingHints' => '<p>The buffering option.</p>', 'S3DestinationConfiguration$BufferingHints' => '<p>The buffering option. If no value is specified, <code>BufferingHints</code> object default values are used.</p>', 'S3DestinationDescription$BufferingHints' => '<p>The buffering option. If no value is specified, <code>BufferingHints</code> object default values are used.</p>', 'S3DestinationUpdate$BufferingHints' => '<p>The buffering option. If no value is specified, <code>BufferingHints</code> object default values are used.</p>', ], ], 'CloudWatchLoggingOptions' => [ 'base' => '<p>Describes the Amazon CloudWatch logging options for your delivery stream.</p>', 'refs' => [ 'ElasticsearchDestinationConfiguration$CloudWatchLoggingOptions' => '<p>The Amazon CloudWatch logging options for your delivery stream.</p>', 'ElasticsearchDestinationDescription$CloudWatchLoggingOptions' => '<p>The Amazon CloudWatch logging options.</p>', 'ElasticsearchDestinationUpdate$CloudWatchLoggingOptions' => '<p>The CloudWatch logging options for your delivery stream.</p>', 'ExtendedS3DestinationConfiguration$CloudWatchLoggingOptions' => '<p>The Amazon CloudWatch logging options for your delivery stream.</p>', 'ExtendedS3DestinationDescription$CloudWatchLoggingOptions' => '<p>The Amazon CloudWatch logging options for your delivery stream.</p>', 'ExtendedS3DestinationUpdate$CloudWatchLoggingOptions' => '<p>The Amazon CloudWatch logging options for your delivery stream.</p>', 'HttpEndpointDestinationConfiguration$CloudWatchLoggingOptions' => NULL, 'HttpEndpointDestinationDescription$CloudWatchLoggingOptions' => NULL, 'HttpEndpointDestinationUpdate$CloudWatchLoggingOptions' => NULL, 'RedshiftDestinationConfiguration$CloudWatchLoggingOptions' => '<p>The CloudWatch logging options for your delivery stream.</p>', 'RedshiftDestinationDescription$CloudWatchLoggingOptions' => '<p>The Amazon CloudWatch logging options for your delivery stream.</p>', 'RedshiftDestinationUpdate$CloudWatchLoggingOptions' => '<p>The Amazon CloudWatch logging options for your delivery stream.</p>', 'S3DestinationConfiguration$CloudWatchLoggingOptions' => '<p>The CloudWatch logging options for your delivery stream.</p>', 'S3DestinationDescription$CloudWatchLoggingOptions' => '<p>The Amazon CloudWatch logging options for your delivery stream.</p>', 'S3DestinationUpdate$CloudWatchLoggingOptions' => '<p>The CloudWatch logging options for your delivery stream.</p>', 'SplunkDestinationConfiguration$CloudWatchLoggingOptions' => '<p>The Amazon CloudWatch logging options for your delivery stream.</p>', 'SplunkDestinationDescription$CloudWatchLoggingOptions' => '<p>The Amazon CloudWatch logging options for your delivery stream.</p>', 'SplunkDestinationUpdate$CloudWatchLoggingOptions' => '<p>The Amazon CloudWatch logging options for your delivery stream.</p>', ], ], 'ClusterJDBCURL' => [ 'base' => NULL, 'refs' => [ 'RedshiftDestinationConfiguration$ClusterJDBCURL' => '<p>The database connection string.</p>', 'RedshiftDestinationDescription$ClusterJDBCURL' => '<p>The database connection string.</p>', 'RedshiftDestinationUpdate$ClusterJDBCURL' => '<p>The database connection string.</p>', ], ], 'ColumnToJsonKeyMappings' => [ 'base' => NULL, 'refs' => [ 'OpenXJsonSerDe$ColumnToJsonKeyMappings' => '<p>Maps column names to JSON keys that aren\'t identical to the column names. This is useful when the JSON contains keys that are Hive keywords. For example, <code>timestamp</code> is a Hive keyword. If you have a JSON key named <code>timestamp</code>, set this parameter to <code>{"ts": "timestamp"}</code> to map this key to a column named <code>ts</code>.</p>', ], ], 'CompressionFormat' => [ 'base' => NULL, 'refs' => [ 'ExtendedS3DestinationConfiguration$CompressionFormat' => '<p>The compression format. If no value is specified, the default is UNCOMPRESSED.</p>', 'ExtendedS3DestinationDescription$CompressionFormat' => '<p>The compression format. If no value is specified, the default is <code>UNCOMPRESSED</code>.</p>', 'ExtendedS3DestinationUpdate$CompressionFormat' => '<p>The compression format. If no value is specified, the default is <code>UNCOMPRESSED</code>. </p>', 'S3DestinationConfiguration$CompressionFormat' => '<p>The compression format. If no value is specified, the default is <code>UNCOMPRESSED</code>.</p> <p>The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified for Amazon Redshift destinations because they are not supported by the Amazon Redshift <code>COPY</code> operation that reads from the S3 bucket.</p>', 'S3DestinationDescription$CompressionFormat' => '<p>The compression format. If no value is specified, the default is <code>UNCOMPRESSED</code>.</p>', 'S3DestinationUpdate$CompressionFormat' => '<p>The compression format. If no value is specified, the default is <code>UNCOMPRESSED</code>.</p> <p>The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified for Amazon Redshift destinations because they are not supported by the Amazon Redshift <code>COPY</code> operation that reads from the S3 bucket.</p>', ], ], 'ConcurrentModificationException' => [ 'base' => '<p>Another modification has already happened. Fetch <code>VersionId</code> again and use it to update the destination.</p>', 'refs' => [], ], 'ContentEncoding' => [ 'base' => NULL, 'refs' => [ 'HttpEndpointRequestConfiguration$ContentEncoding' => '<p>Kinesis Data Firehose uses the content encoding to compress the body of a request before sending the request to the destination. For more information, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Encoding">Content-Encoding</a> in MDN Web Docs, the official Mozilla documentation.</p>', ], ], 'CopyCommand' => [ 'base' => '<p>Describes a <code>COPY</code> command for Amazon Redshift.</p>', 'refs' => [ 'RedshiftDestinationConfiguration$CopyCommand' => '<p>The <code>COPY</code> command.</p>', 'RedshiftDestinationDescription$CopyCommand' => '<p>The <code>COPY</code> command.</p>', 'RedshiftDestinationUpdate$CopyCommand' => '<p>The <code>COPY</code> command.</p>', ], ], 'CopyOptions' => [ 'base' => NULL, 'refs' => [ 'CopyCommand$CopyOptions' => '<p>Optional parameters to use with the Amazon Redshift <code>COPY</code> command. For more information, see the "Optional Parameters" section of <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html">Amazon Redshift COPY command</a>. Some possible examples that would apply to Kinesis Data Firehose are as follows:</p> <p> <code>delimiter \'\\t\' lzop;</code> - fields are delimited with "\\t" (TAB character) and compressed using lzop.</p> <p> <code>delimiter \'|\'</code> - fields are delimited with "|" (this is the default delimiter).</p> <p> <code>delimiter \'|\' escape</code> - the delimiter should be escaped.</p> <p> <code>fixedwidth \'venueid:3,venuename:25,venuecity:12,venuestate:2,venueseats:6\'</code> - fields are fixed width in the source, with each width specified after every column in the table.</p> <p> <code>JSON \'s3://mybucket/jsonpaths.txt\'</code> - data is in JSON format, and the path specified is the format of the data.</p> <p>For more examples, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY_command_examples.html">Amazon Redshift COPY command examples</a>.</p>', ], ], 'CreateDeliveryStreamInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateDeliveryStreamOutput' => [ 'base' => NULL, 'refs' => [], ], 'Data' => [ 'base' => NULL, 'refs' => [ 'Record$Data' => '<p>The data blob, which is base64-encoded when the blob is serialized. The maximum size of the data blob, before base64-encoding, is 1,000 KiB.</p>', ], ], 'DataFormatConversionConfiguration' => [ 'base' => '<p>Specifies that you want Kinesis Data Firehose to convert data from the JSON format to the Parquet or ORC format before writing it to Amazon S3. Kinesis Data Firehose uses the serializer and deserializer that you specify, in addition to the column information from the AWS Glue table, to deserialize your input data from JSON and then serialize it to the Parquet or ORC format. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/record-format-conversion.html">Kinesis Data Firehose Record Format Conversion</a>.</p>', 'refs' => [ 'ExtendedS3DestinationConfiguration$DataFormatConversionConfiguration' => '<p>The serializer, deserializer, and schema for converting data from the JSON format to the Parquet or ORC format before writing it to Amazon S3.</p>', 'ExtendedS3DestinationDescription$DataFormatConversionConfiguration' => '<p>The serializer, deserializer, and schema for converting data from the JSON format to the Parquet or ORC format before writing it to Amazon S3.</p>', 'ExtendedS3DestinationUpdate$DataFormatConversionConfiguration' => '<p>The serializer, deserializer, and schema for converting data from the JSON format to the Parquet or ORC format before writing it to Amazon S3.</p>', ], ], 'DataTableColumns' => [ 'base' => NULL, 'refs' => [ 'CopyCommand$DataTableColumns' => '<p>A comma-separated list of column names.</p>', ], ], 'DataTableName' => [ 'base' => NULL, 'refs' => [ 'CopyCommand$DataTableName' => '<p>The name of the target table. The table must already exist in the database.</p>', ], ], 'DeleteDeliveryStreamInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDeliveryStreamOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeliveryStartTimestamp' => [ 'base' => NULL, 'refs' => [ 'KinesisStreamSourceDescription$DeliveryStartTimestamp' => '<p>Kinesis Data Firehose starts retrieving records from the Kinesis data stream starting with this timestamp.</p>', ], ], 'DeliveryStreamARN' => [ 'base' => NULL, 'refs' => [ 'CreateDeliveryStreamOutput$DeliveryStreamARN' => '<p>The ARN of the delivery stream.</p>', 'DeliveryStreamDescription$DeliveryStreamARN' => '<p>The Amazon Resource Name (ARN) of the delivery stream. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.</p>', ], ], 'DeliveryStreamDescription' => [ 'base' => '<p>Contains information about a delivery stream.</p>', 'refs' => [ 'DescribeDeliveryStreamOutput$DeliveryStreamDescription' => '<p>Information about the delivery stream.</p>', ], ], 'DeliveryStreamEncryptionConfiguration' => [ 'base' => '<p>Contains information about the server-side encryption (SSE) status for the delivery stream, the type customer master key (CMK) in use, if any, and the ARN of the CMK. You can get <code>DeliveryStreamEncryptionConfiguration</code> by invoking the <a>DescribeDeliveryStream</a> operation. </p>', 'refs' => [ 'DeliveryStreamDescription$DeliveryStreamEncryptionConfiguration' => '<p>Indicates the server-side encryption (SSE) status for the delivery stream.</p>', ], ], 'DeliveryStreamEncryptionConfigurationInput' => [ 'base' => '<p>Specifies the type and Amazon Resource Name (ARN) of the CMK to use for Server-Side Encryption (SSE). </p>', 'refs' => [ 'CreateDeliveryStreamInput$DeliveryStreamEncryptionConfigurationInput' => '<p>Used to specify the type and Amazon Resource Name (ARN) of the KMS key needed for Server-Side Encryption (SSE).</p>', 'StartDeliveryStreamEncryptionInput$DeliveryStreamEncryptionConfigurationInput' => '<p>Used to specify the type and Amazon Resource Name (ARN) of the KMS key needed for Server-Side Encryption (SSE).</p>', ], ], 'DeliveryStreamEncryptionStatus' => [ 'base' => NULL, 'refs' => [ 'DeliveryStreamEncryptionConfiguration$Status' => '<p>This is the server-side encryption (SSE) status for the delivery stream. For a full description of the different values of this status, see <a>StartDeliveryStreamEncryption</a> and <a>StopDeliveryStreamEncryption</a>. If this status is <code>ENABLING_FAILED</code> or <code>DISABLING_FAILED</code>, it is the status of the most recent attempt to enable or disable SSE, respectively.</p>', ], ], 'DeliveryStreamFailureType' => [ 'base' => NULL, 'refs' => [ 'FailureDescription$Type' => '<p>The type of error that caused the failure.</p>', ], ], 'DeliveryStreamName' => [ 'base' => NULL, 'refs' => [ 'CreateDeliveryStreamInput$DeliveryStreamName' => '<p>The name of the delivery stream. This name must be unique per AWS account in the same AWS Region. If the delivery streams are in different accounts or different Regions, you can have multiple delivery streams with the same name.</p>', 'DeleteDeliveryStreamInput$DeliveryStreamName' => '<p>The name of the delivery stream.</p>', 'DeliveryStreamDescription$DeliveryStreamName' => '<p>The name of the delivery stream.</p>', 'DeliveryStreamNameList$member' => NULL, 'DescribeDeliveryStreamInput$DeliveryStreamName' => '<p>The name of the delivery stream.</p>', 'ListDeliveryStreamsInput$ExclusiveStartDeliveryStreamName' => '<p>The list of delivery streams returned by this call to <code>ListDeliveryStreams</code> will start with the delivery stream whose name comes alphabetically immediately after the name you specify in <code>ExclusiveStartDeliveryStreamName</code>.</p>', 'ListTagsForDeliveryStreamInput$DeliveryStreamName' => '<p>The name of the delivery stream whose tags you want to list.</p>', 'PutRecordBatchInput$DeliveryStreamName' => '<p>The name of the delivery stream.</p>', 'PutRecordInput$DeliveryStreamName' => '<p>The name of the delivery stream.</p>', 'StartDeliveryStreamEncryptionInput$DeliveryStreamName' => '<p>The name of the delivery stream for which you want to enable server-side encryption (SSE).</p>', 'StopDeliveryStreamEncryptionInput$DeliveryStreamName' => '<p>The name of the delivery stream for which you want to disable server-side encryption (SSE).</p>', 'TagDeliveryStreamInput$DeliveryStreamName' => '<p>The name of the delivery stream to which you want to add the tags.</p>', 'UntagDeliveryStreamInput$DeliveryStreamName' => '<p>The name of the delivery stream.</p>', 'UpdateDestinationInput$DeliveryStreamName' => '<p>The name of the delivery stream.</p>', ], ], 'DeliveryStreamNameList' => [ 'base' => NULL, 'refs' => [ 'ListDeliveryStreamsOutput$DeliveryStreamNames' => '<p>The names of the delivery streams.</p>', ], ], 'DeliveryStreamStatus' => [ 'base' => NULL, 'refs' => [ 'DeliveryStreamDescription$DeliveryStreamStatus' => '<p>The status of the delivery stream. If the status of a delivery stream is <code>CREATING_FAILED</code>, this status doesn\'t change, and you can\'t invoke <code>CreateDeliveryStream</code> again on it. However, you can invoke the <a>DeleteDeliveryStream</a> operation to delete it.</p>', ], ], 'DeliveryStreamType' => [ 'base' => NULL, 'refs' => [ 'CreateDeliveryStreamInput$DeliveryStreamType' => '<p>The delivery stream type. This parameter can be one of the following values:</p> <ul> <li> <p> <code>DirectPut</code>: Provider applications access the delivery stream directly.</p> </li> <li> <p> <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data stream as a source.</p> </li> </ul>', 'DeliveryStreamDescription$DeliveryStreamType' => '<p>The delivery stream type. This can be one of the following values:</p> <ul> <li> <p> <code>DirectPut</code>: Provider applications access the delivery stream directly.</p> </li> <li> <p> <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data stream as a source.</p> </li> </ul>', 'ListDeliveryStreamsInput$DeliveryStreamType' => '<p>The delivery stream type. This can be one of the following values:</p> <ul> <li> <p> <code>DirectPut</code>: Provider applications access the delivery stream directly.</p> </li> <li> <p> <code>KinesisStreamAsSource</code>: The delivery stream uses a Kinesis data stream as a source.</p> </li> </ul> <p>This parameter is optional. If this parameter is omitted, delivery streams of all types are returned.</p>', ], ], 'DeliveryStreamVersionId' => [ 'base' => NULL, 'refs' => [ 'DeliveryStreamDescription$VersionId' => '<p>Each time the destination is updated for a delivery stream, the version ID is changed, and the current version ID is required when updating the destination. This is so that the service knows it is applying the changes to the correct version of the delivery stream.</p>', 'UpdateDestinationInput$CurrentDeliveryStreamVersionId' => '<p>Obtain this value from the <code>VersionId</code> result of <a>DeliveryStreamDescription</a>. This value is required, and helps the service perform conditional operations. For example, if there is an interleaving update and this value is null, then the update destination fails. After the update is successful, the <code>VersionId</code> value is updated. The service then performs a merge of the old configuration with the new configuration.</p>', ], ], 'DescribeDeliveryStreamInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDeliveryStreamInputLimit' => [ 'base' => NULL, 'refs' => [ 'DescribeDeliveryStreamInput$Limit' => '<p>The limit on the number of destinations to return. You can have one destination per delivery stream.</p>', ], ], 'DescribeDeliveryStreamOutput' => [ 'base' => NULL, 'refs' => [], ], 'Deserializer' => [ 'base' => '<p>The deserializer you want Kinesis Data Firehose to use for converting the input data from JSON. Kinesis Data Firehose then serializes the data to its final format using the <a>Serializer</a>. Kinesis Data Firehose supports two types of deserializers: the <a href="https://cwiki.apache.org/confluence/display/Hive/LanguageManual+DDL#LanguageManualDDL-JSON">Apache Hive JSON SerDe</a> and the <a href="https://github.com/rcongiu/Hive-JSON-Serde">OpenX JSON SerDe</a>.</p>', 'refs' => [ 'InputFormatConfiguration$Deserializer' => '<p>Specifies which deserializer to use. You can choose either the Apache Hive JSON SerDe or the OpenX JSON SerDe. If both are non-null, the server rejects the request.</p>', ], ], 'DestinationDescription' => [ 'base' => '<p>Describes the destination for a delivery stream.</p>', 'refs' => [ 'DestinationDescriptionList$member' => NULL, ], ], 'DestinationDescriptionList' => [ 'base' => NULL, 'refs' => [ 'DeliveryStreamDescription$Destinations' => '<p>The destinations.</p>', ], ], 'DestinationId' => [ 'base' => NULL, 'refs' => [ 'DescribeDeliveryStreamInput$ExclusiveStartDestinationId' => '<p>The ID of the destination to start returning the destination information. Kinesis Data Firehose supports one destination per delivery stream.</p>', 'DestinationDescription$DestinationId' => '<p>The ID of the destination.</p>', 'UpdateDestinationInput$DestinationId' => '<p>The ID of the destination.</p>', ], ], 'ElasticsearchBufferingHints' => [ 'base' => '<p>Describes the buffering to perform before delivering data to the Amazon ES destination.</p>', 'refs' => [ 'ElasticsearchDestinationConfiguration$BufferingHints' => '<p>The buffering options. If no value is specified, the default values for <code>ElasticsearchBufferingHints</code> are used.</p>', 'ElasticsearchDestinationDescription$BufferingHints' => '<p>The buffering options.</p>', 'ElasticsearchDestinationUpdate$BufferingHints' => '<p>The buffering options. If no value is specified, <code>ElasticsearchBufferingHints</code> object default values are used. </p>', ], ], 'ElasticsearchBufferingIntervalInSeconds' => [ 'base' => NULL, 'refs' => [ 'ElasticsearchBufferingHints$IntervalInSeconds' => '<p>Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination. The default value is 300 (5 minutes).</p>', ], ], 'ElasticsearchBufferingSizeInMBs' => [ 'base' => NULL, 'refs' => [ 'ElasticsearchBufferingHints$SizeInMBs' => '<p>Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The default value is 5.</p> <p>We recommend setting this parameter to a value greater than the amount of data you typically ingest into the delivery stream in 10 seconds. For example, if you typically ingest data at 1 MB/sec, the value should be 10 MB or higher.</p>', ], ], 'ElasticsearchClusterEndpoint' => [ 'base' => NULL, 'refs' => [ 'ElasticsearchDestinationConfiguration$ClusterEndpoint' => '<p>The endpoint to use when communicating with the cluster. Specify either this <code>ClusterEndpoint</code> or the <code>DomainARN</code> field.</p>', 'ElasticsearchDestinationDescription$ClusterEndpoint' => '<p>The endpoint to use when communicating with the cluster. Kinesis Data Firehose uses either this <code>ClusterEndpoint</code> or the <code>DomainARN</code> field to send data to Amazon ES.</p>', 'ElasticsearchDestinationUpdate$ClusterEndpoint' => '<p>The endpoint to use when communicating with the cluster. Specify either this <code>ClusterEndpoint</code> or the <code>DomainARN</code> field.</p>', ], ], 'ElasticsearchDestinationConfiguration' => [ 'base' => '<p>Describes the configuration of a destination in Amazon ES.</p>', 'refs' => [ 'CreateDeliveryStreamInput$ElasticsearchDestinationConfiguration' => '<p>The destination in Amazon ES. You can specify only one destination.</p>', ], ], 'ElasticsearchDestinationDescription' => [ 'base' => '<p>The destination description in Amazon ES.</p>', 'refs' => [ 'DestinationDescription$ElasticsearchDestinationDescription' => '<p>The destination in Amazon ES.</p>', ], ], 'ElasticsearchDestinationUpdate' => [ 'base' => '<p>Describes an update for a destination in Amazon ES.</p>', 'refs' => [ 'UpdateDestinationInput$ElasticsearchDestinationUpdate' => '<p>Describes an update for a destination in Amazon ES.</p>', ], ], 'ElasticsearchDomainARN' => [ 'base' => NULL, 'refs' => [ 'ElasticsearchDestinationConfiguration$DomainARN' => '<p>The ARN of the Amazon ES domain. The IAM role must have permissions for <code>DescribeElasticsearchDomain</code>, <code>DescribeElasticsearchDomains</code>, and <code>DescribeElasticsearchDomainConfig</code> after assuming the role specified in <b>RoleARN</b>. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.</p> <p>Specify either <code>ClusterEndpoint</code> or <code>DomainARN</code>.</p>', 'ElasticsearchDestinationDescription$DomainARN' => '<p>The ARN of the Amazon ES domain. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.</p> <p>Kinesis Data Firehose uses either <code>ClusterEndpoint</code> or <code>DomainARN</code> to send data to Amazon ES.</p>', 'ElasticsearchDestinationUpdate$DomainARN' => '<p>The ARN of the Amazon ES domain. The IAM role must have permissions for <code>DescribeElasticsearchDomain</code>, <code>DescribeElasticsearchDomains</code>, and <code>DescribeElasticsearchDomainConfig</code> after assuming the IAM role specified in <code>RoleARN</code>. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.</p> <p>Specify either <code>ClusterEndpoint</code> or <code>DomainARN</code>.</p>', ], ], 'ElasticsearchIndexName' => [ 'base' => NULL, 'refs' => [ 'ElasticsearchDestinationConfiguration$IndexName' => '<p>The Elasticsearch index name.</p>', 'ElasticsearchDestinationDescription$IndexName' => '<p>The Elasticsearch index name.</p>', 'ElasticsearchDestinationUpdate$IndexName' => '<p>The Elasticsearch index name.</p>', ], ], 'ElasticsearchIndexRotationPeriod' => [ 'base' => NULL, 'refs' => [ 'ElasticsearchDestinationConfiguration$IndexRotationPeriod' => '<p>The Elasticsearch index rotation period. Index rotation appends a timestamp to the <code>IndexName</code> to facilitate the expiration of old data. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation for the Amazon ES Destination</a>. The default value is <code>OneDay</code>.</p>', 'ElasticsearchDestinationDescription$IndexRotationPeriod' => '<p>The Elasticsearch index rotation period</p>', 'ElasticsearchDestinationUpdate$IndexRotationPeriod' => '<p>The Elasticsearch index rotation period. Index rotation appends a timestamp to <code>IndexName</code> to facilitate the expiration of old data. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation for the Amazon ES Destination</a>. Default value is <code>OneDay</code>.</p>', ], ], 'ElasticsearchRetryDurationInSeconds' => [ 'base' => NULL, 'refs' => [ 'ElasticsearchRetryOptions$DurationInSeconds' => '<p>After an initial failure to deliver to Amazon ES, the total amount of time during which Kinesis Data Firehose retries delivery (including the first attempt). After this time has elapsed, the failed documents are written to Amazon S3. Default value is 300 seconds (5 minutes). A value of 0 (zero) results in no retries.</p>', ], ], 'ElasticsearchRetryOptions' => [ 'base' => '<p>Configures retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon ES.</p>', 'refs' => [ 'ElasticsearchDestinationConfiguration$RetryOptions' => '<p>The retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon ES. The default value is 300 (5 minutes).</p>', 'ElasticsearchDestinationDescription$RetryOptions' => '<p>The Amazon ES retry options.</p>', 'ElasticsearchDestinationUpdate$RetryOptions' => '<p>The retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon ES. The default value is 300 (5 minutes).</p>', ], ], 'ElasticsearchS3BackupMode' => [ 'base' => NULL, 'refs' => [ 'ElasticsearchDestinationConfiguration$S3BackupMode' => '<p>Defines how documents should be delivered to Amazon S3. When it is set to <code>FailedDocumentsOnly</code>, Kinesis Data Firehose writes any documents that could not be indexed to the configured Amazon S3 destination, with <code>elasticsearch-failed/</code> appended to the key prefix. When set to <code>AllDocuments</code>, Kinesis Data Firehose delivers all incoming records to Amazon S3, and also writes failed documents with <code>elasticsearch-failed/</code> appended to the prefix. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-s3-backup">Amazon S3 Backup for the Amazon ES Destination</a>. Default value is <code>FailedDocumentsOnly</code>.</p> <p>You can\'t change this backup mode after you create the delivery stream. </p>', 'ElasticsearchDestinationDescription$S3BackupMode' => '<p>The Amazon S3 backup mode.</p>', ], ], 'ElasticsearchTypeName' => [ 'base' => NULL, 'refs' => [ 'ElasticsearchDestinationConfiguration$TypeName' => '<p>The Elasticsearch type name. For Elasticsearch 6.x, there can be only one type per index. If you try to specify a new type for an existing index that already has another type, Kinesis Data Firehose returns an error during run time.</p> <p>For Elasticsearch 7.x, don\'t specify a <code>TypeName</code>.</p>', 'ElasticsearchDestinationDescription$TypeName' => '<p>The Elasticsearch type name. This applies to Elasticsearch 6.x and lower versions. For Elasticsearch 7.x, there\'s no value for <code>TypeName</code>.</p>', 'ElasticsearchDestinationUpdate$TypeName' => '<p>The Elasticsearch type name. For Elasticsearch 6.x, there can be only one type per index. If you try to specify a new type for an existing index that already has another type, Kinesis Data Firehose returns an error during runtime.</p> <p>If you upgrade Elasticsearch from 6.x to 7.x and don’t update your delivery stream, Kinesis Data Firehose still delivers data to Elasticsearch with the old index name and type name. If you want to update your delivery stream with a new index name, provide an empty string for <code>TypeName</code>. </p>', ], ], 'EncryptionConfiguration' => [ 'base' => '<p>Describes the encryption for a destination in Amazon S3.</p>', 'refs' => [ 'ExtendedS3DestinationConfiguration$EncryptionConfiguration' => '<p>The encryption configuration. If no value is specified, the default is no encryption.</p>', 'ExtendedS3DestinationDescription$EncryptionConfiguration' => '<p>The encryption configuration. If no value is specified, the default is no encryption.</p>', 'ExtendedS3DestinationUpdate$EncryptionConfiguration' => '<p>The encryption configuration. If no value is specified, the default is no encryption.</p>', 'S3DestinationConfiguration$EncryptionConfiguration' => '<p>The encryption configuration. If no value is specified, the default is no encryption.</p>', 'S3DestinationDescription$EncryptionConfiguration' => '<p>The encryption configuration. If no value is specified, the default is no encryption.</p>', 'S3DestinationUpdate$EncryptionConfiguration' => '<p>The encryption configuration. If no value is specified, the default is no encryption.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'InvalidKMSResourceException$code' => NULL, 'PutRecordBatchResponseEntry$ErrorCode' => '<p>The error code for an individual record result.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'ConcurrentModificationException$message' => '<p>A message that provides information about the error.</p>', 'InvalidArgumentException$message' => '<p>A message that provides information about the error.</p>', 'InvalidKMSResourceException$message' => NULL, 'LimitExceededException$message' => '<p>A message that provides information about the error.</p>', 'PutRecordBatchResponseEntry$ErrorMessage' => '<p>The error message for an individual record result.</p>', 'ResourceInUseException$message' => '<p>A message that provides information about the error.</p>', 'ResourceNotFoundException$message' => '<p>A message that provides information about the error.</p>', 'ServiceUnavailableException$message' => '<p>A message that provides information about the error.</p>', ], ], 'ErrorOutputPrefix' => [ 'base' => NULL, 'refs' => [ 'ExtendedS3DestinationConfiguration$ErrorOutputPrefix' => '<p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3. This prefix appears immediately following the bucket name. For information about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3 Objects</a>.</p>', 'ExtendedS3DestinationDescription$ErrorOutputPrefix' => '<p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3. This prefix appears immediately following the bucket name. For information about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3 Objects</a>.</p>', 'ExtendedS3DestinationUpdate$ErrorOutputPrefix' => '<p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3. This prefix appears immediately following the bucket name. For information about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3 Objects</a>.</p>', 'S3DestinationConfiguration$ErrorOutputPrefix' => '<p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3. This prefix appears immediately following the bucket name. For information about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3 Objects</a>.</p>', 'S3DestinationDescription$ErrorOutputPrefix' => '<p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3. This prefix appears immediately following the bucket name. For information about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3 Objects</a>.</p>', 'S3DestinationUpdate$ErrorOutputPrefix' => '<p>A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3. This prefix appears immediately following the bucket name. For information about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3 Objects</a>.</p>', ], ], 'ExtendedS3DestinationConfiguration' => [ 'base' => '<p>Describes the configuration of a destination in Amazon S3.</p>', 'refs' => [ 'CreateDeliveryStreamInput$ExtendedS3DestinationConfiguration' => '<p>The destination in Amazon S3. You can specify only one destination.</p>', ], ], 'ExtendedS3DestinationDescription' => [ 'base' => '<p>Describes a destination in Amazon S3.</p>', 'refs' => [ 'DestinationDescription$ExtendedS3DestinationDescription' => '<p>The destination in Amazon S3.</p>', ], ], 'ExtendedS3DestinationUpdate' => [ 'base' => '<p>Describes an update for a destination in Amazon S3.</p>', 'refs' => [ 'UpdateDestinationInput$ExtendedS3DestinationUpdate' => '<p>Describes an update for a destination in Amazon S3.</p>', ], ], 'FailureDescription' => [ 'base' => '<p>Provides details in case one of the following operations fails due to an error related to KMS: <a>CreateDeliveryStream</a>, <a>DeleteDeliveryStream</a>, <a>StartDeliveryStreamEncryption</a>, <a>StopDeliveryStreamEncryption</a>.</p>', 'refs' => [ 'DeliveryStreamDescription$FailureDescription' => '<p>Provides details in case one of the following operations fails due to an error related to KMS: <a>CreateDeliveryStream</a>, <a>DeleteDeliveryStream</a>, <a>StartDeliveryStreamEncryption</a>, <a>StopDeliveryStreamEncryption</a>.</p>', 'DeliveryStreamEncryptionConfiguration$FailureDescription' => '<p>Provides details in case one of the following operations fails due to an error related to KMS: <a>CreateDeliveryStream</a>, <a>DeleteDeliveryStream</a>, <a>StartDeliveryStreamEncryption</a>, <a>StopDeliveryStreamEncryption</a>.</p>', ], ], 'HECAcknowledgmentTimeoutInSeconds' => [ 'base' => NULL, 'refs' => [ 'SplunkDestinationConfiguration$HECAcknowledgmentTimeoutInSeconds' => '<p>The amount of time that Kinesis Data Firehose waits to receive an acknowledgment from Splunk after it sends it data. At the end of the timeout period, Kinesis Data Firehose either tries to send the data again or considers it an error, based on your retry settings.</p>', 'SplunkDestinationDescription$HECAcknowledgmentTimeoutInSeconds' => '<p>The amount of time that Kinesis Data Firehose waits to receive an acknowledgment from Splunk after it sends it data. At the end of the timeout period, Kinesis Data Firehose either tries to send the data again or considers it an error, based on your retry settings.</p>', 'SplunkDestinationUpdate$HECAcknowledgmentTimeoutInSeconds' => '<p>The amount of time that Kinesis Data Firehose waits to receive an acknowledgment from Splunk after it sends data. At the end of the timeout period, Kinesis Data Firehose either tries to send the data again or considers it an error, based on your retry settings.</p>', ], ], 'HECEndpoint' => [ 'base' => NULL, 'refs' => [ 'SplunkDestinationConfiguration$HECEndpoint' => '<p>The HTTP Event Collector (HEC) endpoint to which Kinesis Data Firehose sends your data.</p>', 'SplunkDestinationDescription$HECEndpoint' => '<p>The HTTP Event Collector (HEC) endpoint to which Kinesis Data Firehose sends your data.</p>', 'SplunkDestinationUpdate$HECEndpoint' => '<p>The HTTP Event Collector (HEC) endpoint to which Kinesis Data Firehose sends your data.</p>', ], ], 'HECEndpointType' => [ 'base' => NULL, 'refs' => [ 'SplunkDestinationConfiguration$HECEndpointType' => '<p>This type can be either "Raw" or "Event."</p>', 'SplunkDestinationDescription$HECEndpointType' => '<p>This type can be either "Raw" or "Event."</p>', 'SplunkDestinationUpdate$HECEndpointType' => '<p>This type can be either "Raw" or "Event."</p>', ], ], 'HECToken' => [ 'base' => NULL, 'refs' => [ 'SplunkDestinationConfiguration$HECToken' => '<p>This is a GUID that you obtain from your Splunk cluster when you create a new HEC endpoint.</p>', 'SplunkDestinationDescription$HECToken' => '<p>A GUID you obtain from your Splunk cluster when you create a new HEC endpoint.</p>', 'SplunkDestinationUpdate$HECToken' => '<p>A GUID that you obtain from your Splunk cluster when you create a new HEC endpoint.</p>', ], ], 'HiveJsonSerDe' => [ 'base' => '<p>The native Hive / HCatalog JsonSerDe. Used by Kinesis Data Firehose for deserializing data, which means converting it from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can choose, depending on which one offers the functionality you need. The other option is the OpenX SerDe.</p>', 'refs' => [ 'Deserializer$HiveJsonSerDe' => '<p>The native Hive / HCatalog JsonSerDe. Used by Kinesis Data Firehose for deserializing data, which means converting it from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can choose, depending on which one offers the functionality you need. The other option is the OpenX SerDe.</p>', ], ], 'HttpEndpointAccessKey' => [ 'base' => NULL, 'refs' => [ 'HttpEndpointConfiguration$AccessKey' => '<p>The access key required for Kinesis Firehose to authenticate with the HTTP endpoint selected as the destination.</p>', ], ], 'HttpEndpointAttributeName' => [ 'base' => NULL, 'refs' => [ 'HttpEndpointCommonAttribute$AttributeName' => '<p>The name of the HTTP endpoint common attribute.</p>', ], ], 'HttpEndpointAttributeValue' => [ 'base' => NULL, 'refs' => [ 'HttpEndpointCommonAttribute$AttributeValue' => '<p>The value of the HTTP endpoint common attribute.</p>', ], ], 'HttpEndpointBufferingHints' => [ 'base' => '<p>Describes the buffering options that can be applied before data is delivered to the HTTP endpoint destination. Kinesis Data Firehose treats these options as hints, and it might choose to use more optimal values. The <code>SizeInMBs</code> and <code>IntervalInSeconds</code> parameters are optional. However, if specify a value for one of them, you must also provide a value for the other. </p>', 'refs' => [ 'HttpEndpointDestinationConfiguration$BufferingHints' => '<p>The buffering options that can be used before data is delivered to the specified destination. Kinesis Data Firehose treats these options as hints, and it might choose to use more optimal values. The <code>SizeInMBs</code> and <code>IntervalInSeconds</code> parameters are optional. However, if you specify a value for one of them, you must also provide a value for the other. </p>', 'HttpEndpointDestinationDescription$BufferingHints' => '<p>Describes buffering options that can be applied to the data before it is delivered to the HTTPS endpoint destination. Kinesis Data Firehose teats these options as hints, and it might choose to use more optimal values. The <code>SizeInMBs</code> and <code>IntervalInSeconds</code> parameters are optional. However, if specify a value for one of them, you must also provide a value for the other. </p>', 'HttpEndpointDestinationUpdate$BufferingHints' => '<p>Describes buffering options that can be applied to the data before it is delivered to the HTTPS endpoint destination. Kinesis Data Firehose teats these options as hints, and it might choose to use more optimal values. The <code>SizeInMBs</code> and <code>IntervalInSeconds</code> parameters are optional. However, if specify a value for one of them, you must also provide a value for the other. </p>', ], ], 'HttpEndpointBufferingIntervalInSeconds' => [ 'base' => NULL, 'refs' => [ 'HttpEndpointBufferingHints$IntervalInSeconds' => '<p>Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination. The default value is 300 (5 minutes). </p>', ], ], 'HttpEndpointBufferingSizeInMBs' => [ 'base' => NULL, 'refs' => [ 'HttpEndpointBufferingHints$SizeInMBs' => '<p>Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The default value is 5. </p> <p>We recommend setting this parameter to a value greater than the amount of data you typically ingest into the delivery stream in 10 seconds. For example, if you typically ingest data at 1 MB/sec, the value should be 10 MB or higher. </p>', ], ], 'HttpEndpointCommonAttribute' => [ 'base' => '<p>Describes the metadata that\'s delivered to the specified HTTP endpoint destination.</p>', 'refs' => [ 'HttpEndpointCommonAttributesList$member' => NULL, ], ], 'HttpEndpointCommonAttributesList' => [ 'base' => NULL, 'refs' => [ 'HttpEndpointRequestConfiguration$CommonAttributes' => '<p>Describes the metadata sent to the HTTP endpoint destination.</p>', ], ], 'HttpEndpointConfiguration' => [ 'base' => '<p>Describes the configuration of the HTTP endpoint to which Kinesis Firehose delivers data.</p>', 'refs' => [ 'HttpEndpointDestinationConfiguration$EndpointConfiguration' => '<p>The configuration of the HTTP endpoint selected as the destination.</p>', 'HttpEndpointDestinationUpdate$EndpointConfiguration' => '<p>Describes the configuration of the HTTP endpoint destination.</p>', ], ], 'HttpEndpointDescription' => [ 'base' => '<p>Describes the HTTP endpoint selected as the destination. </p>', 'refs' => [ 'HttpEndpointDestinationDescription$EndpointConfiguration' => '<p>The configuration of the specified HTTP endpoint destination.</p>', ], ], 'HttpEndpointDestinationConfiguration' => [ 'base' => '<p>Describes the configuration of the HTTP endpoint destination.</p>', 'refs' => [ 'CreateDeliveryStreamInput$HttpEndpointDestinationConfiguration' => '<p>Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination. You can specify only one destination.</p>', ], ], 'HttpEndpointDestinationDescription' => [ 'base' => '<p>Describes the HTTP endpoint destination.</p>', 'refs' => [ 'DestinationDescription$HttpEndpointDestinationDescription' => '<p>Describes the specified HTTP endpoint destination.</p>', ], ], 'HttpEndpointDestinationUpdate' => [ 'base' => '<p>Updates the specified HTTP endpoint destination.</p>', 'refs' => [ 'UpdateDestinationInput$HttpEndpointDestinationUpdate' => '<p>Describes an update to the specified HTTP endpoint destination.</p>', ], ], 'HttpEndpointName' => [ 'base' => NULL, 'refs' => [ 'HttpEndpointConfiguration$Name' => '<p>The name of the HTTP endpoint selected as the destination.</p>', 'HttpEndpointDescription$Name' => '<p>The name of the HTTP endpoint selected as the destination.</p>', ], ], 'HttpEndpointRequestConfiguration' => [ 'base' => '<p>The configuration of the HTTP endpoint request.</p>', 'refs' => [ 'HttpEndpointDestinationConfiguration$RequestConfiguration' => '<p>The configuration of the requeste sent to the HTTP endpoint specified as the destination.</p>', 'HttpEndpointDestinationDescription$RequestConfiguration' => '<p>The configuration of request sent to the HTTP endpoint specified as the destination.</p>', 'HttpEndpointDestinationUpdate$RequestConfiguration' => '<p>The configuration of the request sent to the HTTP endpoint specified as the destination.</p>', ], ], 'HttpEndpointRetryDurationInSeconds' => [ 'base' => NULL, 'refs' => [ 'HttpEndpointRetryOptions$DurationInSeconds' => '<p>The total amount of time that Kinesis Data Firehose spends on retries. This duration starts after the initial attempt to send data to the custom destination via HTTPS endpoint fails. It doesn\'t include the periods during which Kinesis Data Firehose waits for acknowledgment from the specified destination after each attempt. </p>', ], ], 'HttpEndpointRetryOptions' => [ 'base' => '<p>Describes the retry behavior in case Kinesis Data Firehose is unable to deliver data to the specified HTTP endpoint destination, or if it doesn\'t receive a valid acknowledgment of receipt from the specified HTTP endpoint destination.</p>', 'refs' => [ 'HttpEndpointDestinationConfiguration$RetryOptions' => '<p>Describes the retry behavior in case Kinesis Data Firehose is unable to deliver data to the specified HTTP endpoint destination, or if it doesn\'t receive a valid acknowledgment of receipt from the specified HTTP endpoint destination.</p>', 'HttpEndpointDestinationDescription$RetryOptions' => '<p>Describes the retry behavior in case Kinesis Data Firehose is unable to deliver data to the specified HTTP endpoint destination, or if it doesn\'t receive a valid acknowledgment of receipt from the specified HTTP endpoint destination.</p>', 'HttpEndpointDestinationUpdate$RetryOptions' => '<p>Describes the retry behavior in case Kinesis Data Firehose is unable to deliver data to the specified HTTP endpoint destination, or if it doesn\'t receive a valid acknowledgment of receipt from the specified HTTP endpoint destination.</p>', ], ], 'HttpEndpointS3BackupMode' => [ 'base' => NULL, 'refs' => [ 'HttpEndpointDestinationConfiguration$S3BackupMode' => '<p>Describes the S3 bucket backup options for the data that Kinesis Data Firehose delivers to the HTTP endpoint destination. You can back up all documents (<code>AllData</code>) or only the documents that Kinesis Data Firehose could not deliver to the specified HTTP endpoint destination (<code>FailedDataOnly</code>).</p>', 'HttpEndpointDestinationDescription$S3BackupMode' => '<p>Describes the S3 bucket backup options for the data that Kinesis Firehose delivers to the HTTP endpoint destination. You can back up all documents (<code>AllData</code>) or only the documents that Kinesis Data Firehose could not deliver to the specified HTTP endpoint destination (<code>FailedDataOnly</code>).</p>', 'HttpEndpointDestinationUpdate$S3BackupMode' => '<p>Describes the S3 bucket backup options for the data that Kinesis Firehose delivers to the HTTP endpoint destination. You can back up all documents (<code>AllData</code>) or only the documents that Kinesis Data Firehose could not deliver to the specified HTTP endpoint destination (<code>FailedDataOnly</code>).</p>', ], ], 'HttpEndpointUrl' => [ 'base' => NULL, 'refs' => [ 'HttpEndpointConfiguration$Url' => '<p>The URL of the HTTP endpoint selected as the destination.</p>', 'HttpEndpointDescription$Url' => '<p>The URL of the HTTP endpoint selected as the destination.</p>', ], ], 'InputFormatConfiguration' => [ 'base' => '<p>Specifies the deserializer you want to use to convert the format of the input data. This parameter is required if <code>Enabled</code> is set to true.</p>', 'refs' => [ 'DataFormatConversionConfiguration$InputFormatConfiguration' => '<p>Specifies the deserializer that you want Kinesis Data Firehose to use to convert the format of your data from JSON. This parameter is required if <code>Enabled</code> is set to true.</p>', ], ], 'IntervalInSeconds' => [ 'base' => NULL, 'refs' => [ 'BufferingHints$IntervalInSeconds' => '<p>Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination. The default value is 300. This parameter is optional but if you specify a value for it, you must also specify a value for <code>SizeInMBs</code>, and vice versa.</p>', ], ], 'InvalidArgumentException' => [ 'base' => '<p>The specified input parameter has a value that is not valid.</p>', 'refs' => [], ], 'InvalidKMSResourceException' => [ 'base' => '<p>Kinesis Data Firehose throws this exception when an attempt to put records or to start or stop delivery stream encryption fails. This happens when the KMS service throws one of the following exception types: <code>AccessDeniedException</code>, <code>InvalidStateException</code>, <code>DisabledException</code>, or <code>NotFoundException</code>.</p>', 'refs' => [], ], 'KMSEncryptionConfig' => [ 'base' => '<p>Describes an encryption key for a destination in Amazon S3.</p>', 'refs' => [ 'EncryptionConfiguration$KMSEncryptionConfig' => '<p>The encryption key.</p>', ], ], 'KeyType' => [ 'base' => NULL, 'refs' => [ 'DeliveryStreamEncryptionConfiguration$KeyType' => '<p>Indicates the type of customer master key (CMK) that is used for encryption. The default setting is <code>AWS_OWNED_CMK</code>. For more information about CMKs, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master Keys (CMKs)</a>.</p>', 'DeliveryStreamEncryptionConfigurationInput$KeyType' => '<p>Indicates the type of customer master key (CMK) to use for encryption. The default setting is <code>AWS_OWNED_CMK</code>. For more information about CMKs, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master Keys (CMKs)</a>. When you invoke <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a> with <code>KeyType</code> set to CUSTOMER_MANAGED_CMK, Kinesis Data Firehose invokes the Amazon KMS operation <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html">CreateGrant</a> to create a grant that allows the Kinesis Data Firehose service to use the customer managed CMK to perform encryption and decryption. Kinesis Data Firehose manages that grant. </p> <p>When you invoke <a>StartDeliveryStreamEncryption</a> to change the CMK for a delivery stream that is encrypted with a customer managed CMK, Kinesis Data Firehose schedules the grant it had on the old CMK for retirement.</p> <p>You can use a CMK of type CUSTOMER_MANAGED_CMK to encrypt up to 500 delivery streams. If a <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a> operation exceeds this limit, Kinesis Data Firehose throws a <code>LimitExceededException</code>. </p> <important> <p>To encrypt your delivery stream, use symmetric CMKs. Kinesis Data Firehose doesn\'t support asymmetric CMKs. For information about symmetric and asymmetric CMKs, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html">About Symmetric and Asymmetric CMKs</a> in the AWS Key Management Service developer guide.</p> </important>', ], ], 'KinesisStreamARN' => [ 'base' => NULL, 'refs' => [ 'KinesisStreamSourceConfiguration$KinesisStreamARN' => '<p>The ARN of the source Kinesis data stream. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams">Amazon Kinesis Data Streams ARN Format</a>.</p>', 'KinesisStreamSourceDescription$KinesisStreamARN' => '<p>The Amazon Resource Name (ARN) of the source Kinesis data stream. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams">Amazon Kinesis Data Streams ARN Format</a>.</p>', ], ], 'KinesisStreamSourceConfiguration' => [ 'base' => '<p>The stream and role Amazon Resource Names (ARNs) for a Kinesis data stream used as the source for a delivery stream.</p>', 'refs' => [ 'CreateDeliveryStreamInput$KinesisStreamSourceConfiguration' => '<p>When a Kinesis data stream is used as the source for the delivery stream, a <a>KinesisStreamSourceConfiguration</a> containing the Kinesis data stream Amazon Resource Name (ARN) and the role ARN for the source stream.</p>', ], ], 'KinesisStreamSourceDescription' => [ 'base' => '<p>Details about a Kinesis data stream used as the source for a Kinesis Data Firehose delivery stream.</p>', 'refs' => [ 'SourceDescription$KinesisStreamSourceDescription' => '<p>The <a>KinesisStreamSourceDescription</a> value for the source Kinesis data stream.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>You have already reached the limit for a requested resource.</p>', 'refs' => [], ], 'ListDeliveryStreamsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListDeliveryStreamsInputLimit' => [ 'base' => NULL, 'refs' => [ 'ListDeliveryStreamsInput$Limit' => '<p>The maximum number of delivery streams to list. The default value is 10.</p>', ], ], 'ListDeliveryStreamsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListOfNonEmptyStrings' => [ 'base' => NULL, 'refs' => [ 'HiveJsonSerDe$TimestampFormats' => '<p>Indicates how you want Kinesis Data Firehose to parse the date and timestamps that may be present in your input data JSON. To specify these format strings, follow the pattern syntax of JodaTime\'s DateTimeFormat format strings. For more information, see <a href="https://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html">Class DateTimeFormat</a>. You can also use the special value <code>millis</code> to parse timestamps in epoch milliseconds. If you don\'t specify a format, Kinesis Data Firehose uses <code>java.sql.Timestamp::valueOf</code> by default.</p>', ], ], 'ListOfNonEmptyStringsWithoutWhitespace' => [ 'base' => NULL, 'refs' => [ 'OrcSerDe$BloomFilterColumns' => '<p>The column names for which you want Kinesis Data Firehose to create bloom filters. The default is <code>null</code>.</p>', ], ], 'ListTagsForDeliveryStreamInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForDeliveryStreamInputLimit' => [ 'base' => NULL, 'refs' => [ 'ListTagsForDeliveryStreamInput$Limit' => '<p>The number of tags to return. If this number is less than the total number of tags associated with the delivery stream, <code>HasMoreTags</code> is set to <code>true</code> in the response. To list additional tags, set <code>ExclusiveStartTagKey</code> to the last key in the response. </p>', ], ], 'ListTagsForDeliveryStreamOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForDeliveryStreamOutputTagList' => [ 'base' => NULL, 'refs' => [ 'ListTagsForDeliveryStreamOutput$Tags' => '<p>A list of tags associated with <code>DeliveryStreamName</code>, starting with the first tag after <code>ExclusiveStartTagKey</code> and up to the specified <code>Limit</code>.</p>', ], ], 'LogGroupName' => [ 'base' => NULL, 'refs' => [ 'CloudWatchLoggingOptions$LogGroupName' => '<p>The CloudWatch group name for logging. This value is required if CloudWatch logging is enabled.</p>', ], ], 'LogStreamName' => [ 'base' => NULL, 'refs' => [ 'CloudWatchLoggingOptions$LogStreamName' => '<p>The CloudWatch log stream name for logging. This value is required if CloudWatch logging is enabled.</p>', ], ], 'NoEncryptionConfig' => [ 'base' => NULL, 'refs' => [ 'EncryptionConfiguration$NoEncryptionConfig' => '<p>Specifically override existing encryption information to ensure that no encryption is used.</p>', ], ], 'NonEmptyString' => [ 'base' => NULL, 'refs' => [ 'ColumnToJsonKeyMappings$value' => NULL, 'FailureDescription$Details' => '<p>A message providing details about the error that caused the failure.</p>', 'ListOfNonEmptyStrings$member' => NULL, ], ], 'NonEmptyStringWithoutWhitespace' => [ 'base' => NULL, 'refs' => [ 'ColumnToJsonKeyMappings$key' => NULL, 'ListOfNonEmptyStringsWithoutWhitespace$member' => NULL, 'SchemaConfiguration$RoleARN' => '<p>The role that Kinesis Data Firehose can use to access AWS Glue. This role must be in the same account you use for Kinesis Data Firehose. Cross-account roles aren\'t allowed.</p>', 'SchemaConfiguration$CatalogId' => '<p>The ID of the AWS Glue Data Catalog. If you don\'t supply this, the AWS account ID is used by default.</p>', 'SchemaConfiguration$DatabaseName' => '<p>Specifies the name of the AWS Glue database that contains the schema for the output data.</p>', 'SchemaConfiguration$TableName' => '<p>Specifies the AWS Glue table that contains the column information that constitutes your data schema.</p>', 'SchemaConfiguration$Region' => '<p>If you don\'t specify an AWS Region, the default is the current Region.</p>', 'SchemaConfiguration$VersionId' => '<p>Specifies the table version for the output data schema. If you don\'t specify this version ID, or if you set it to <code>LATEST</code>, Kinesis Data Firehose uses the most recent version. This means that any updates to the table are automatically picked up.</p>', 'SecurityGroupIdList$member' => NULL, 'SubnetIdList$member' => NULL, 'VpcConfigurationDescription$VpcId' => '<p>The ID of the Amazon ES destination\'s VPC.</p>', ], ], 'NonNegativeIntegerObject' => [ 'base' => NULL, 'refs' => [ 'ParquetSerDe$MaxPaddingBytes' => '<p>The maximum amount of padding to apply. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 0.</p>', 'PutRecordBatchOutput$FailedPutCount' => '<p>The number of records that might have failed processing. This number might be greater than 0 even if the <a>PutRecordBatch</a> call succeeds. Check <code>FailedPutCount</code> to determine whether there are records that you need to resend.</p>', ], ], 'OpenXJsonSerDe' => [ 'base' => '<p>The OpenX SerDe. Used by Kinesis Data Firehose for deserializing data, which means converting it from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can choose, depending on which one offers the functionality you need. The other option is the native Hive / HCatalog JsonSerDe.</p>', 'refs' => [ 'Deserializer$OpenXJsonSerDe' => '<p>The OpenX SerDe. Used by Kinesis Data Firehose for deserializing data, which means converting it from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can choose, depending on which one offers the functionality you need. The other option is the native Hive / HCatalog JsonSerDe.</p>', ], ], 'OrcCompression' => [ 'base' => NULL, 'refs' => [ 'OrcSerDe$Compression' => '<p>The compression code to use over data blocks. The default is <code>SNAPPY</code>.</p>', ], ], 'OrcFormatVersion' => [ 'base' => NULL, 'refs' => [ 'OrcSerDe$FormatVersion' => '<p>The version of the file to write. The possible values are <code>V0_11</code> and <code>V0_12</code>. The default is <code>V0_12</code>.</p>', ], ], 'OrcRowIndexStride' => [ 'base' => NULL, 'refs' => [ 'OrcSerDe$RowIndexStride' => '<p>The number of rows between index entries. The default is 10,000 and the minimum is 1,000.</p>', ], ], 'OrcSerDe' => [ 'base' => '<p>A serializer to use for converting data to the ORC format before storing it in Amazon S3. For more information, see <a href="https://orc.apache.org/docs/">Apache ORC</a>.</p>', 'refs' => [ 'Serializer$OrcSerDe' => '<p>A serializer to use for converting data to the ORC format before storing it in Amazon S3. For more information, see <a href="https://orc.apache.org/docs/">Apache ORC</a>.</p>', ], ], 'OrcStripeSizeBytes' => [ 'base' => NULL, 'refs' => [ 'OrcSerDe$StripeSizeBytes' => '<p>The number of bytes in each stripe. The default is 64 MiB and the minimum is 8 MiB.</p>', ], ], 'OutputFormatConfiguration' => [ 'base' => '<p>Specifies the serializer that you want Kinesis Data Firehose to use to convert the format of your data before it writes it to Amazon S3. This parameter is required if <code>Enabled</code> is set to true.</p>', 'refs' => [ 'DataFormatConversionConfiguration$OutputFormatConfiguration' => '<p>Specifies the serializer that you want Kinesis Data Firehose to use to convert the format of your data to the Parquet or ORC format. This parameter is required if <code>Enabled</code> is set to true.</p>', ], ], 'ParquetCompression' => [ 'base' => NULL, 'refs' => [ 'ParquetSerDe$Compression' => '<p>The compression code to use over data blocks. The possible values are <code>UNCOMPRESSED</code>, <code>SNAPPY</code>, and <code>GZIP</code>, with the default being <code>SNAPPY</code>. Use <code>SNAPPY</code> for higher decompression speed. Use <code>GZIP</code> if the compression ratio is more important than speed.</p>', ], ], 'ParquetPageSizeBytes' => [ 'base' => NULL, 'refs' => [ 'ParquetSerDe$PageSizeBytes' => '<p>The Parquet page size. Column chunks are divided into pages. A page is conceptually an indivisible unit (in terms of compression and encoding). The minimum value is 64 KiB and the default is 1 MiB.</p>', ], ], 'ParquetSerDe' => [ 'base' => '<p>A serializer to use for converting data to the Parquet format before storing it in Amazon S3. For more information, see <a href="https://parquet.apache.org/documentation/latest/">Apache Parquet</a>.</p>', 'refs' => [ 'Serializer$ParquetSerDe' => '<p>A serializer to use for converting data to the Parquet format before storing it in Amazon S3. For more information, see <a href="https://parquet.apache.org/documentation/latest/">Apache Parquet</a>.</p>', ], ], 'ParquetWriterVersion' => [ 'base' => NULL, 'refs' => [ 'ParquetSerDe$WriterVersion' => '<p>Indicates the version of row format to output. The possible values are <code>V1</code> and <code>V2</code>. The default is <code>V1</code>.</p>', ], ], 'Password' => [ 'base' => NULL, 'refs' => [ 'RedshiftDestinationConfiguration$Password' => '<p>The user password.</p>', 'RedshiftDestinationUpdate$Password' => '<p>The user password.</p>', ], ], 'Prefix' => [ 'base' => NULL, 'refs' => [ 'ExtendedS3DestinationConfiguration$Prefix' => '<p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3 files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3 Objects</a>.</p>', 'ExtendedS3DestinationDescription$Prefix' => '<p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3 files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3 Objects</a>.</p>', 'ExtendedS3DestinationUpdate$Prefix' => '<p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3 files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3 Objects</a>.</p>', 'S3DestinationConfiguration$Prefix' => '<p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3 files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3 Objects</a>.</p>', 'S3DestinationDescription$Prefix' => '<p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3 files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3 Objects</a>.</p>', 'S3DestinationUpdate$Prefix' => '<p>The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered Amazon S3 files. You can also specify a custom prefix, as described in <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3 Objects</a>.</p>', ], ], 'ProcessingConfiguration' => [ 'base' => '<p>Describes a data processing configuration.</p>', 'refs' => [ 'ElasticsearchDestinationConfiguration$ProcessingConfiguration' => '<p>The data processing configuration.</p>', 'ElasticsearchDestinationDescription$ProcessingConfiguration' => '<p>The data processing configuration.</p>', 'ElasticsearchDestinationUpdate$ProcessingConfiguration' => '<p>The data processing configuration.</p>', 'ExtendedS3DestinationConfiguration$ProcessingConfiguration' => '<p>The data processing configuration.</p>', 'ExtendedS3DestinationDescription$ProcessingConfiguration' => '<p>The data processing configuration.</p>', 'ExtendedS3DestinationUpdate$ProcessingConfiguration' => '<p>The data processing configuration.</p>', 'HttpEndpointDestinationConfiguration$ProcessingConfiguration' => NULL, 'HttpEndpointDestinationDescription$ProcessingConfiguration' => NULL, 'HttpEndpointDestinationUpdate$ProcessingConfiguration' => NULL, 'RedshiftDestinationConfiguration$ProcessingConfiguration' => '<p>The data processing configuration.</p>', 'RedshiftDestinationDescription$ProcessingConfiguration' => '<p>The data processing configuration.</p>', 'RedshiftDestinationUpdate$ProcessingConfiguration' => '<p>The data processing configuration.</p>', 'SplunkDestinationConfiguration$ProcessingConfiguration' => '<p>The data processing configuration.</p>', 'SplunkDestinationDescription$ProcessingConfiguration' => '<p>The data processing configuration.</p>', 'SplunkDestinationUpdate$ProcessingConfiguration' => '<p>The data processing configuration.</p>', ], ], 'Processor' => [ 'base' => '<p>Describes a data processor.</p>', 'refs' => [ 'ProcessorList$member' => NULL, ], ], 'ProcessorList' => [ 'base' => NULL, 'refs' => [ 'ProcessingConfiguration$Processors' => '<p>The data processors.</p>', ], ], 'ProcessorParameter' => [ 'base' => '<p>Describes the processor parameter.</p>', 'refs' => [ 'ProcessorParameterList$member' => NULL, ], ], 'ProcessorParameterList' => [ 'base' => NULL, 'refs' => [ 'Processor$Parameters' => '<p>The processor parameters.</p>', ], ], 'ProcessorParameterName' => [ 'base' => NULL, 'refs' => [ 'ProcessorParameter$ParameterName' => '<p>The name of the parameter.</p>', ], ], 'ProcessorParameterValue' => [ 'base' => NULL, 'refs' => [ 'ProcessorParameter$ParameterValue' => '<p>The parameter value.</p>', ], ], 'ProcessorType' => [ 'base' => NULL, 'refs' => [ 'Processor$Type' => '<p>The type of processor.</p>', ], ], 'Proportion' => [ 'base' => NULL, 'refs' => [ 'OrcSerDe$PaddingTolerance' => '<p>A number between 0 and 1 that defines the tolerance for block padding as a decimal fraction of stripe size. The default value is 0.05, which means 5 percent of stripe size.</p> <p>For the default values of 64 MiB ORC stripes and 256 MiB HDFS blocks, the default block padding tolerance of 5 percent reserves a maximum of 3.2 MiB for padding within the 256 MiB block. In such a case, if the available size within the block is more than 3.2 MiB, a new, smaller stripe is inserted to fit within that space. This ensures that no stripe crosses block boundaries and causes remote reads within a node-local task.</p> <p>Kinesis Data Firehose ignores this parameter when <a>OrcSerDe$EnablePadding</a> is <code>false</code>.</p>', 'OrcSerDe$BloomFilterFalsePositiveProbability' => '<p>The Bloom filter false positive probability (FPP). The lower the FPP, the bigger the Bloom filter. The default value is 0.05, the minimum is 0, and the maximum is 1.</p>', 'OrcSerDe$DictionaryKeyThreshold' => '<p>Represents the fraction of the total number of non-null rows. To turn off dictionary encoding, set this fraction to a number that is less than the number of distinct keys in a dictionary. To always use dictionary encoding, set this threshold to 1.</p>', ], ], 'PutRecordBatchInput' => [ 'base' => NULL, 'refs' => [], ], 'PutRecordBatchOutput' => [ 'base' => NULL, 'refs' => [], ], 'PutRecordBatchRequestEntryList' => [ 'base' => NULL, 'refs' => [ 'PutRecordBatchInput$Records' => '<p>One or more records.</p>', ], ], 'PutRecordBatchResponseEntry' => [ 'base' => '<p>Contains the result for an individual record from a <a>PutRecordBatch</a> request. If the record is successfully added to your delivery stream, it receives a record ID. If the record fails to be added to your delivery stream, the result includes an error code and an error message.</p>', 'refs' => [ 'PutRecordBatchResponseEntryList$member' => NULL, ], ], 'PutRecordBatchResponseEntryList' => [ 'base' => NULL, 'refs' => [ 'PutRecordBatchOutput$RequestResponses' => '<p>The results array. For each record, the index of the response element is the same as the index used in the request array.</p>', ], ], 'PutRecordInput' => [ 'base' => NULL, 'refs' => [], ], 'PutRecordOutput' => [ 'base' => NULL, 'refs' => [], ], 'PutResponseRecordId' => [ 'base' => NULL, 'refs' => [ 'PutRecordBatchResponseEntry$RecordId' => '<p>The ID of the record.</p>', 'PutRecordOutput$RecordId' => '<p>The ID of the record.</p>', ], ], 'Record' => [ 'base' => '<p>The unit of data in a delivery stream.</p>', 'refs' => [ 'PutRecordBatchRequestEntryList$member' => NULL, 'PutRecordInput$Record' => '<p>The record.</p>', ], ], 'RedshiftDestinationConfiguration' => [ 'base' => '<p>Describes the configuration of a destination in Amazon Redshift.</p>', 'refs' => [ 'CreateDeliveryStreamInput$RedshiftDestinationConfiguration' => '<p>The destination in Amazon Redshift. You can specify only one destination.</p>', ], ], 'RedshiftDestinationDescription' => [ 'base' => '<p>Describes a destination in Amazon Redshift.</p>', 'refs' => [ 'DestinationDescription$RedshiftDestinationDescription' => '<p>The destination in Amazon Redshift.</p>', ], ], 'RedshiftDestinationUpdate' => [ 'base' => '<p>Describes an update for a destination in Amazon Redshift.</p>', 'refs' => [ 'UpdateDestinationInput$RedshiftDestinationUpdate' => '<p>Describes an update for a destination in Amazon Redshift.</p>', ], ], 'RedshiftRetryDurationInSeconds' => [ 'base' => NULL, 'refs' => [ 'RedshiftRetryOptions$DurationInSeconds' => '<p>The length of time during which Kinesis Data Firehose retries delivery after a failure, starting from the initial request and including the first attempt. The default value is 3600 seconds (60 minutes). Kinesis Data Firehose does not retry if the value of <code>DurationInSeconds</code> is 0 (zero) or if the first delivery attempt takes longer than the current value.</p>', ], ], 'RedshiftRetryOptions' => [ 'base' => '<p>Configures retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon Redshift.</p>', 'refs' => [ 'RedshiftDestinationConfiguration$RetryOptions' => '<p>The retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon Redshift. Default value is 3600 (60 minutes).</p>', 'RedshiftDestinationDescription$RetryOptions' => '<p>The retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon Redshift. Default value is 3600 (60 minutes).</p>', 'RedshiftDestinationUpdate$RetryOptions' => '<p>The retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon Redshift. Default value is 3600 (60 minutes).</p>', ], ], 'RedshiftS3BackupMode' => [ 'base' => NULL, 'refs' => [ 'RedshiftDestinationConfiguration$S3BackupMode' => '<p>The Amazon S3 backup mode. After you create a delivery stream, you can update it to enable Amazon S3 backup if it is disabled. If backup is enabled, you can\'t update the delivery stream to disable it. </p>', 'RedshiftDestinationDescription$S3BackupMode' => '<p>The Amazon S3 backup mode.</p>', 'RedshiftDestinationUpdate$S3BackupMode' => '<p>You can update a delivery stream to enable Amazon S3 backup if it is disabled. If backup is enabled, you can\'t update the delivery stream to disable it. </p>', ], ], 'ResourceInUseException' => [ 'base' => '<p>The resource is already in use and not available for this operation.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource could not be found.</p>', 'refs' => [], ], 'RoleARN' => [ 'base' => NULL, 'refs' => [ 'ElasticsearchDestinationConfiguration$RoleARN' => '<p>The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose for calling the Amazon ES Configuration API and for indexing documents. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Grant Kinesis Data Firehose Access to an Amazon S3 Destination</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.</p>', 'ElasticsearchDestinationDescription$RoleARN' => '<p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.</p>', 'ElasticsearchDestinationUpdate$RoleARN' => '<p>The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose for calling the Amazon ES Configuration API and for indexing documents. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Grant Kinesis Data Firehose Access to an Amazon S3 Destination</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.</p>', 'ExtendedS3DestinationConfiguration$RoleARN' => '<p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.</p>', 'ExtendedS3DestinationDescription$RoleARN' => '<p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.</p>', 'ExtendedS3DestinationUpdate$RoleARN' => '<p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.</p>', 'HttpEndpointDestinationConfiguration$RoleARN' => '<p>Kinesis Data Firehose uses this IAM role for all the permissions that the delivery stream needs.</p>', 'HttpEndpointDestinationDescription$RoleARN' => '<p>Kinesis Data Firehose uses this IAM role for all the permissions that the delivery stream needs.</p>', 'HttpEndpointDestinationUpdate$RoleARN' => '<p>Kinesis Data Firehose uses this IAM role for all the permissions that the delivery stream needs.</p>', 'KinesisStreamSourceConfiguration$RoleARN' => '<p>The ARN of the role that provides access to the source Kinesis data stream. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">AWS Identity and Access Management (IAM) ARN Format</a>.</p>', 'KinesisStreamSourceDescription$RoleARN' => '<p>The ARN of the role used by the source Kinesis data stream. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">AWS Identity and Access Management (IAM) ARN Format</a>.</p>', 'RedshiftDestinationConfiguration$RoleARN' => '<p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.</p>', 'RedshiftDestinationDescription$RoleARN' => '<p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.</p>', 'RedshiftDestinationUpdate$RoleARN' => '<p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.</p>', 'S3DestinationConfiguration$RoleARN' => '<p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.</p>', 'S3DestinationDescription$RoleARN' => '<p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.</p>', 'S3DestinationUpdate$RoleARN' => '<p>The Amazon Resource Name (ARN) of the AWS credentials. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.</p>', 'VpcConfiguration$RoleARN' => '<p>The ARN of the IAM role that you want the delivery stream to use to create endpoints in the destination VPC. You can use your existing Kinesis Data Firehose delivery role or you can specify a new role. In either case, make sure that the role trusts the Kinesis Data Firehose service principal and that it grants the following permissions:</p> <ul> <li> <p> <code>ec2:DescribeVpcs</code> </p> </li> <li> <p> <code>ec2:DescribeVpcAttribute</code> </p> </li> <li> <p> <code>ec2:DescribeSubnets</code> </p> </li> <li> <p> <code>ec2:DescribeSecurityGroups</code> </p> </li> <li> <p> <code>ec2:DescribeNetworkInterfaces</code> </p> </li> <li> <p> <code>ec2:CreateNetworkInterface</code> </p> </li> <li> <p> <code>ec2:CreateNetworkInterfacePermission</code> </p> </li> <li> <p> <code>ec2:DeleteNetworkInterface</code> </p> </li> </ul> <p>If you revoke these permissions after you create the delivery stream, Kinesis Data Firehose can\'t scale out by creating more ENIs when necessary. You might therefore see a degradation in performance.</p>', 'VpcConfigurationDescription$RoleARN' => '<p>The ARN of the IAM role that the delivery stream uses to create endpoints in the destination VPC. You can use your existing Kinesis Data Firehose delivery role or you can specify a new role. In either case, make sure that the role trusts the Kinesis Data Firehose service principal and that it grants the following permissions:</p> <ul> <li> <p> <code>ec2:DescribeVpcs</code> </p> </li> <li> <p> <code>ec2:DescribeVpcAttribute</code> </p> </li> <li> <p> <code>ec2:DescribeSubnets</code> </p> </li> <li> <p> <code>ec2:DescribeSecurityGroups</code> </p> </li> <li> <p> <code>ec2:DescribeNetworkInterfaces</code> </p> </li> <li> <p> <code>ec2:CreateNetworkInterface</code> </p> </li> <li> <p> <code>ec2:CreateNetworkInterfacePermission</code> </p> </li> <li> <p> <code>ec2:DeleteNetworkInterface</code> </p> </li> </ul> <p>If you revoke these permissions after you create the delivery stream, Kinesis Data Firehose can\'t scale out by creating more ENIs when necessary. You might therefore see a degradation in performance.</p>', ], ], 'S3BackupMode' => [ 'base' => NULL, 'refs' => [ 'ExtendedS3DestinationConfiguration$S3BackupMode' => '<p>The Amazon S3 backup mode. After you create a delivery stream, you can update it to enable Amazon S3 backup if it is disabled. If backup is enabled, you can\'t update the delivery stream to disable it. </p>', 'ExtendedS3DestinationDescription$S3BackupMode' => '<p>The Amazon S3 backup mode.</p>', 'ExtendedS3DestinationUpdate$S3BackupMode' => '<p>You can update a delivery stream to enable Amazon S3 backup if it is disabled. If backup is enabled, you can\'t update the delivery stream to disable it. </p>', ], ], 'S3DestinationConfiguration' => [ 'base' => '<p>Describes the configuration of a destination in Amazon S3.</p>', 'refs' => [ 'CreateDeliveryStreamInput$S3DestinationConfiguration' => '<p>[Deprecated] The destination in Amazon S3. You can specify only one destination.</p>', 'ElasticsearchDestinationConfiguration$S3Configuration' => '<p>The configuration for the backup Amazon S3 location.</p>', 'ExtendedS3DestinationConfiguration$S3BackupConfiguration' => '<p>The configuration for backup in Amazon S3.</p>', 'HttpEndpointDestinationConfiguration$S3Configuration' => NULL, 'RedshiftDestinationConfiguration$S3Configuration' => '<p>The configuration for the intermediate Amazon S3 location from which Amazon Redshift obtains data. Restrictions are described in the topic for <a>CreateDeliveryStream</a>.</p> <p>The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified in <code>RedshiftDestinationConfiguration.S3Configuration</code> because the Amazon Redshift <code>COPY</code> operation that reads from the S3 bucket doesn\'t support these compression formats.</p>', 'RedshiftDestinationConfiguration$S3BackupConfiguration' => '<p>The configuration for backup in Amazon S3.</p>', 'SplunkDestinationConfiguration$S3Configuration' => '<p>The configuration for the backup Amazon S3 location.</p>', ], ], 'S3DestinationDescription' => [ 'base' => '<p>Describes a destination in Amazon S3.</p>', 'refs' => [ 'DestinationDescription$S3DestinationDescription' => '<p>[Deprecated] The destination in Amazon S3.</p>', 'ElasticsearchDestinationDescription$S3DestinationDescription' => '<p>The Amazon S3 destination.</p>', 'ExtendedS3DestinationDescription$S3BackupDescription' => '<p>The configuration for backup in Amazon S3.</p>', 'HttpEndpointDestinationDescription$S3DestinationDescription' => NULL, 'RedshiftDestinationDescription$S3DestinationDescription' => '<p>The Amazon S3 destination.</p>', 'RedshiftDestinationDescription$S3BackupDescription' => '<p>The configuration for backup in Amazon S3.</p>', 'SplunkDestinationDescription$S3DestinationDescription' => '<p>The Amazon S3 destination.&gt;</p>', ], ], 'S3DestinationUpdate' => [ 'base' => '<p>Describes an update for a destination in Amazon S3.</p>', 'refs' => [ 'ElasticsearchDestinationUpdate$S3Update' => '<p>The Amazon S3 destination.</p>', 'ExtendedS3DestinationUpdate$S3BackupUpdate' => '<p>The Amazon S3 destination for backup.</p>', 'HttpEndpointDestinationUpdate$S3Update' => NULL, 'RedshiftDestinationUpdate$S3Update' => '<p>The Amazon S3 destination.</p> <p>The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified in <code>RedshiftDestinationUpdate.S3Update</code> because the Amazon Redshift <code>COPY</code> operation that reads from the S3 bucket doesn\'t support these compression formats.</p>', 'RedshiftDestinationUpdate$S3BackupUpdate' => '<p>The Amazon S3 destination for backup.</p>', 'SplunkDestinationUpdate$S3Update' => '<p>Your update to the configuration of the backup Amazon S3 location.</p>', 'UpdateDestinationInput$S3DestinationUpdate' => '<p>[Deprecated] Describes an update for a destination in Amazon S3.</p>', ], ], 'SchemaConfiguration' => [ 'base' => '<p>Specifies the schema to which you want Kinesis Data Firehose to configure your data before it writes it to Amazon S3. This parameter is required if <code>Enabled</code> is set to true.</p>', 'refs' => [ 'DataFormatConversionConfiguration$SchemaConfiguration' => '<p>Specifies the AWS Glue Data Catalog table that contains the column information. This parameter is required if <code>Enabled</code> is set to true.</p>', ], ], 'SecurityGroupIdList' => [ 'base' => NULL, 'refs' => [ 'VpcConfiguration$SecurityGroupIds' => '<p>The IDs of the security groups that you want Kinesis Data Firehose to use when it creates ENIs in the VPC of the Amazon ES destination. You can use the same security group that the Amazon ES domain uses or different ones. If you specify different security groups here, ensure that they allow outbound HTTPS traffic to the Amazon ES domain\'s security group. Also ensure that the Amazon ES domain\'s security group allows HTTPS traffic from the security groups specified here. If you use the same security group for both your delivery stream and the Amazon ES domain, make sure the security group inbound rule allows HTTPS traffic. For more information about security group rules, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#SecurityGroupRules">Security group rules</a> in the Amazon VPC documentation.</p>', 'VpcConfigurationDescription$SecurityGroupIds' => '<p>The IDs of the security groups that Kinesis Data Firehose uses when it creates ENIs in the VPC of the Amazon ES destination. You can use the same security group that the Amazon ES domain uses or different ones. If you specify different security groups, ensure that they allow outbound HTTPS traffic to the Amazon ES domain\'s security group. Also ensure that the Amazon ES domain\'s security group allows HTTPS traffic from the security groups specified here. If you use the same security group for both your delivery stream and the Amazon ES domain, make sure the security group inbound rule allows HTTPS traffic. For more information about security group rules, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#SecurityGroupRules">Security group rules</a> in the Amazon VPC documentation.</p>', ], ], 'Serializer' => [ 'base' => '<p>The serializer that you want Kinesis Data Firehose to use to convert data to the target format before writing it to Amazon S3. Kinesis Data Firehose supports two types of serializers: the <a href="https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/orc/OrcSerde.html">ORC SerDe</a> and the <a href="https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/parquet/serde/ParquetHiveSerDe.html">Parquet SerDe</a>.</p>', 'refs' => [ 'OutputFormatConfiguration$Serializer' => '<p>Specifies which serializer to use. You can choose either the ORC SerDe or the Parquet SerDe. If both are non-null, the server rejects the request.</p>', ], ], 'ServiceUnavailableException' => [ 'base' => '<p>The service is unavailable. Back off and retry the operation. If you continue to see the exception, throughput limits for the delivery stream may have been exceeded. For more information about limits and how to request an increase, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/limits.html">Amazon Kinesis Data Firehose Limits</a>.</p>', 'refs' => [], ], 'SizeInMBs' => [ 'base' => NULL, 'refs' => [ 'BufferingHints$SizeInMBs' => '<p>Buffer incoming data to the specified size, in MiBs, before delivering it to the destination. The default value is 5. This parameter is optional but if you specify a value for it, you must also specify a value for <code>IntervalInSeconds</code>, and vice versa.</p> <p>We recommend setting this parameter to a value greater than the amount of data you typically ingest into the delivery stream in 10 seconds. For example, if you typically ingest data at 1 MiB/sec, the value should be 10 MiB or higher.</p>', ], ], 'SourceDescription' => [ 'base' => '<p>Details about a Kinesis data stream used as the source for a Kinesis Data Firehose delivery stream.</p>', 'refs' => [ 'DeliveryStreamDescription$Source' => '<p>If the <code>DeliveryStreamType</code> parameter is <code>KinesisStreamAsSource</code>, a <a>SourceDescription</a> object describing the source Kinesis data stream.</p>', ], ], 'SplunkDestinationConfiguration' => [ 'base' => '<p>Describes the configuration of a destination in Splunk.</p>', 'refs' => [ 'CreateDeliveryStreamInput$SplunkDestinationConfiguration' => '<p>The destination in Splunk. You can specify only one destination.</p>', ], ], 'SplunkDestinationDescription' => [ 'base' => '<p>Describes a destination in Splunk.</p>', 'refs' => [ 'DestinationDescription$SplunkDestinationDescription' => '<p>The destination in Splunk.</p>', ], ], 'SplunkDestinationUpdate' => [ 'base' => '<p>Describes an update for a destination in Splunk.</p>', 'refs' => [ 'UpdateDestinationInput$SplunkDestinationUpdate' => '<p>Describes an update for a destination in Splunk.</p>', ], ], 'SplunkRetryDurationInSeconds' => [ 'base' => NULL, 'refs' => [ 'SplunkRetryOptions$DurationInSeconds' => '<p>The total amount of time that Kinesis Data Firehose spends on retries. This duration starts after the initial attempt to send data to Splunk fails. It doesn\'t include the periods during which Kinesis Data Firehose waits for acknowledgment from Splunk after each attempt.</p>', ], ], 'SplunkRetryOptions' => [ 'base' => '<p>Configures retry behavior in case Kinesis Data Firehose is unable to deliver documents to Splunk, or if it doesn\'t receive an acknowledgment from Splunk.</p>', 'refs' => [ 'SplunkDestinationConfiguration$RetryOptions' => '<p>The retry behavior in case Kinesis Data Firehose is unable to deliver data to Splunk, or if it doesn\'t receive an acknowledgment of receipt from Splunk.</p>', 'SplunkDestinationDescription$RetryOptions' => '<p>The retry behavior in case Kinesis Data Firehose is unable to deliver data to Splunk or if it doesn\'t receive an acknowledgment of receipt from Splunk.</p>', 'SplunkDestinationUpdate$RetryOptions' => '<p>The retry behavior in case Kinesis Data Firehose is unable to deliver data to Splunk or if it doesn\'t receive an acknowledgment of receipt from Splunk.</p>', ], ], 'SplunkS3BackupMode' => [ 'base' => NULL, 'refs' => [ 'SplunkDestinationConfiguration$S3BackupMode' => '<p>Defines how documents should be delivered to Amazon S3. When set to <code>FailedEventsOnly</code>, Kinesis Data Firehose writes any data that could not be indexed to the configured Amazon S3 destination. When set to <code>AllEvents</code>, Kinesis Data Firehose delivers all incoming records to Amazon S3, and also writes failed documents to Amazon S3. The default value is <code>FailedEventsOnly</code>.</p> <p>You can update this backup mode from <code>FailedEventsOnly</code> to <code>AllEvents</code>. You can\'t update it from <code>AllEvents</code> to <code>FailedEventsOnly</code>.</p>', 'SplunkDestinationDescription$S3BackupMode' => '<p>Defines how documents should be delivered to Amazon S3. When set to <code>FailedDocumentsOnly</code>, Kinesis Data Firehose writes any data that could not be indexed to the configured Amazon S3 destination. When set to <code>AllDocuments</code>, Kinesis Data Firehose delivers all incoming records to Amazon S3, and also writes failed documents to Amazon S3. Default value is <code>FailedDocumentsOnly</code>. </p>', 'SplunkDestinationUpdate$S3BackupMode' => '<p>Specifies how you want Kinesis Data Firehose to back up documents to Amazon S3. When set to <code>FailedDocumentsOnly</code>, Kinesis Data Firehose writes any data that could not be indexed to the configured Amazon S3 destination. When set to <code>AllEvents</code>, Kinesis Data Firehose delivers all incoming records to Amazon S3, and also writes failed documents to Amazon S3. The default value is <code>FailedEventsOnly</code>.</p> <p>You can update this backup mode from <code>FailedEventsOnly</code> to <code>AllEvents</code>. You can\'t update it from <code>AllEvents</code> to <code>FailedEventsOnly</code>.</p>', ], ], 'StartDeliveryStreamEncryptionInput' => [ 'base' => NULL, 'refs' => [], ], 'StartDeliveryStreamEncryptionOutput' => [ 'base' => NULL, 'refs' => [], ], 'StopDeliveryStreamEncryptionInput' => [ 'base' => NULL, 'refs' => [], ], 'StopDeliveryStreamEncryptionOutput' => [ 'base' => NULL, 'refs' => [], ], 'SubnetIdList' => [ 'base' => NULL, 'refs' => [ 'VpcConfiguration$SubnetIds' => '<p>The IDs of the subnets that you want Kinesis Data Firehose to use to create ENIs in the VPC of the Amazon ES destination. Make sure that the routing tables and inbound and outbound rules allow traffic to flow from the subnets whose IDs are specified here to the subnets that have the destination Amazon ES endpoints. Kinesis Data Firehose creates at least one ENI in each of the subnets that are specified here. Do not delete or modify these ENIs.</p> <p>The number of ENIs that Kinesis Data Firehose creates in the subnets specified here scales up and down automatically based on throughput. To enable Kinesis Data Firehose to scale up the number of ENIs to match throughput, ensure that you have sufficient quota. To help you calculate the quota you need, assume that Kinesis Data Firehose can create up to three ENIs for this delivery stream for each of the subnets specified here. For more information about ENI quota, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-enis">Network Interfaces </a> in the Amazon VPC Quotas topic.</p>', 'VpcConfigurationDescription$SubnetIds' => '<p>The IDs of the subnets that Kinesis Data Firehose uses to create ENIs in the VPC of the Amazon ES destination. Make sure that the routing tables and inbound and outbound rules allow traffic to flow from the subnets whose IDs are specified here to the subnets that have the destination Amazon ES endpoints. Kinesis Data Firehose creates at least one ENI in each of the subnets that are specified here. Do not delete or modify these ENIs.</p> <p>The number of ENIs that Kinesis Data Firehose creates in the subnets specified here scales up and down automatically based on throughput. To enable Kinesis Data Firehose to scale up the number of ENIs to match throughput, ensure that you have sufficient quota. To help you calculate the quota you need, assume that Kinesis Data Firehose can create up to three ENIs for this delivery stream for each of the subnets specified here. For more information about ENI quota, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-enis">Network Interfaces </a> in the Amazon VPC Quotas topic.</p>', ], ], 'Tag' => [ 'base' => '<p>Metadata that you can assign to a delivery stream, consisting of a key-value pair.</p>', 'refs' => [ 'ListTagsForDeliveryStreamOutputTagList$member' => NULL, 'TagDeliveryStreamInputTagList$member' => NULL, ], ], 'TagDeliveryStreamInput' => [ 'base' => NULL, 'refs' => [], ], 'TagDeliveryStreamInputTagList' => [ 'base' => NULL, 'refs' => [ 'CreateDeliveryStreamInput$Tags' => '<p>A set of tags to assign to the delivery stream. A tag is a key-value pair that you can define and assign to AWS resources. Tags are metadata. For example, you can add friendly names and descriptions or other types of information that can help you distinguish the delivery stream. For more information about tags, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the AWS Billing and Cost Management User Guide.</p> <p>You can specify up to 50 tags when creating a delivery stream.</p>', 'TagDeliveryStreamInput$Tags' => '<p>A set of key-value pairs to use to create the tags.</p>', ], ], 'TagDeliveryStreamOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'ListTagsForDeliveryStreamInput$ExclusiveStartTagKey' => '<p>The key to use as the starting point for the list of tags. If you set this parameter, <code>ListTagsForDeliveryStream</code> gets all tags that occur after <code>ExclusiveStartTagKey</code>.</p>', 'Tag$Key' => '<p>A unique identifier for the tag. Maximum length: 128 characters. Valid characters: Unicode letters, digits, white space, _ . / = + - % @</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagDeliveryStreamInput$TagKeys' => '<p>A list of tag keys. Each corresponding tag is removed from the delivery stream.</p>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>An optional string, which you can use to describe or define the tag. Maximum length: 256 characters. Valid characters: Unicode letters, digits, white space, _ . / = + - % @</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'DeliveryStreamDescription$CreateTimestamp' => '<p>The date and time that the delivery stream was created.</p>', 'DeliveryStreamDescription$LastUpdateTimestamp' => '<p>The date and time that the delivery stream was last updated.</p>', ], ], 'UntagDeliveryStreamInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagDeliveryStreamOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDestinationInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDestinationOutput' => [ 'base' => NULL, 'refs' => [], ], 'Username' => [ 'base' => NULL, 'refs' => [ 'RedshiftDestinationConfiguration$Username' => '<p>The name of the user.</p>', 'RedshiftDestinationDescription$Username' => '<p>The name of the user.</p>', 'RedshiftDestinationUpdate$Username' => '<p>The name of the user.</p>', ], ], 'VpcConfiguration' => [ 'base' => '<p>The details of the VPC of the Amazon ES destination.</p>', 'refs' => [ 'ElasticsearchDestinationConfiguration$VpcConfiguration' => '<p>The details of the VPC of the Amazon ES destination.</p>', ], ], 'VpcConfigurationDescription' => [ 'base' => '<p>The details of the VPC of the Amazon ES destination.</p>', 'refs' => [ 'ElasticsearchDestinationDescription$VpcConfigurationDescription' => '<p>The details of the VPC of the Amazon ES destination.</p>', ], ], ],];
