<?php
// This file was auto-generated from sdk-root/src/data/eks/2017-11-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Elastic Kubernetes Service (Amazon EKS) is a managed service that makes it easy for you to run Kubernetes on AWS without needing to stand up or maintain your own Kubernetes control plane. Kubernetes is an open-source system for automating the deployment, scaling, and management of containerized applications. </p> <p>Amazon EKS runs up-to-date versions of the open-source Kubernetes software, so you can use all the existing plugins and tooling from the Kubernetes community. Applications running on Amazon EKS are fully compatible with applications running on any standard Kubernetes environment, whether running in on-premises data centers or public clouds. This means that you can easily migrate any standard Kubernetes application to Amazon EKS without any code modification required.</p>', 'operations' => [ 'CreateCluster' => '<p>Creates an Amazon EKS control plane. </p> <p>The Amazon EKS control plane consists of control plane instances that run the Kubernetes software, such as <code>etcd</code> and the API server. The control plane runs in an account managed by AWS, and the Kubernetes API is exposed via the Amazon EKS API server endpoint. Each Amazon EKS cluster control plane is single-tenant and unique and runs on its own set of Amazon EC2 instances.</p> <p>The cluster control plane is provisioned across multiple Availability Zones and fronted by an Elastic Load Balancing Network Load Balancer. Amazon EKS also provisions elastic network interfaces in your VPC subnets to provide connectivity from the control plane instances to the worker nodes (for example, to support <code>kubectl exec</code>, <code>logs</code>, and <code>proxy</code> data flows).</p> <p>Amazon EKS worker nodes run in your AWS account and connect to your cluster\'s control plane via the Kubernetes API server endpoint and a certificate file that is created for your cluster.</p> <p>You can use the <code>endpointPublicAccess</code> and <code>endpointPrivateAccess</code> parameters to enable or disable public and private access to your cluster\'s Kubernetes API server endpoint. By default, public access is enabled, and private access is disabled. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS Cluster Endpoint Access Control</a> in the <i> <i>Amazon EKS User Guide</i> </i>. </p> <p>You can use the <code>logging</code> parameter to enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default, cluster control plane logs aren\'t exported to CloudWatch Logs. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS Cluster Control Plane Logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p> <note> <p>CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">Amazon CloudWatch Pricing</a>.</p> </note> <p>Cluster creation typically takes between 10 and 15 minutes. After you create an Amazon EKS cluster, you must configure your Kubernetes tooling to communicate with the API server and launch worker nodes into your cluster. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/managing-auth.html">Managing Cluster Authentication</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-workers.html">Launching Amazon EKS Worker Nodes</a> in the <i>Amazon EKS User Guide</i>.</p>', 'CreateFargateProfile' => '<p>Creates an AWS Fargate profile for your Amazon EKS cluster. You must have at least one Fargate profile in a cluster to be able to run pods on Fargate.</p> <p>The Fargate profile allows an administrator to declare which pods run on Fargate and specify which pods run on which Fargate profile. This declaration is done through the profile’s selectors. Each profile can have up to five selectors that contain a namespace and labels. A namespace is required for every selector. The label field consists of multiple optional key-value pairs. Pods that match the selectors are scheduled on Fargate. If a to-be-scheduled pod matches any of the selectors in the Fargate profile, then that pod is run on Fargate.</p> <p>When you create a Fargate profile, you must specify a pod execution role to use with the pods that are scheduled with the profile. This role is added to the cluster\'s Kubernetes <a href="https://kubernetes.io/docs/admin/authorization/rbac/">Role Based Access Control</a> (RBAC) for authorization so that the <code>kubelet</code> that is running on the Fargate infrastructure can register with your Amazon EKS cluster so that it can appear in your cluster as a node. The pod execution role also provides IAM permissions to the Fargate infrastructure to allow read access to Amazon ECR image repositories. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html">Pod Execution Role</a> in the <i>Amazon EKS User Guide</i>.</p> <p>Fargate profiles are immutable. However, you can create a new updated profile to replace an existing profile and then delete the original after the updated profile has finished creating.</p> <p>If any Fargate profiles in a cluster are in the <code>DELETING</code> status, you must wait for that Fargate profile to finish deleting before you can create any other profiles in that cluster.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/fargate-profile.html">AWS Fargate Profile</a> in the <i>Amazon EKS User Guide</i>.</p>', 'CreateNodegroup' => '<p>Creates a managed worker node group for an Amazon EKS cluster. You can only create a node group for your cluster that is equal to the current Kubernetes version for the cluster. All node groups are created with the latest AMI release version for the respective minor Kubernetes version of the cluster.</p> <p>An Amazon EKS managed node group is an Amazon EC2 Auto Scaling group and associated Amazon EC2 instances that are managed by AWS for an Amazon EKS cluster. Each node group uses a version of the Amazon EKS-optimized Amazon Linux 2 AMI. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html">Managed Node Groups</a> in the <i>Amazon EKS User Guide</i>. </p>', 'DeleteCluster' => '<p>Deletes the Amazon EKS cluster control plane.</p> <p>If you have active services in your cluster that are associated with a load balancer, you must delete those services before deleting the cluster so that the load balancers are deleted properly. Otherwise, you can have orphaned resources in your VPC that prevent you from being able to delete the VPC. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/delete-cluster.html">Deleting a Cluster</a> in the <i>Amazon EKS User Guide</i>.</p> <p>If you have managed node groups or Fargate profiles attached to the cluster, you must delete them first. For more information, see <a>DeleteNodegroup</a> and <a>DeleteFargateProfile</a>.</p>', 'DeleteFargateProfile' => '<p>Deletes an AWS Fargate profile.</p> <p>When you delete a Fargate profile, any pods running on Fargate that were created with the profile are deleted. If those pods match another Fargate profile, then they are scheduled on Fargate with that profile. If they no longer match any Fargate profiles, then they are not scheduled on Fargate and they may remain in a pending state.</p> <p>Only one Fargate profile in a cluster can be in the <code>DELETING</code> status at a time. You must wait for a Fargate profile to finish deleting before you can delete any other profiles in that cluster.</p>', 'DeleteNodegroup' => '<p>Deletes an Amazon EKS node group for a cluster.</p>', 'DescribeCluster' => '<p>Returns descriptive information about an Amazon EKS cluster.</p> <p>The API server endpoint and certificate authority data returned by this operation are required for <code>kubelet</code> and <code>kubectl</code> to communicate with your Kubernetes API server. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/create-kubeconfig.html">Create a kubeconfig for Amazon EKS</a>.</p> <note> <p>The API server endpoint and certificate authority data aren\'t available until the cluster reaches the <code>ACTIVE</code> state.</p> </note>', 'DescribeFargateProfile' => '<p>Returns descriptive information about an AWS Fargate profile.</p>', 'DescribeNodegroup' => '<p>Returns descriptive information about an Amazon EKS node group.</p>', 'DescribeUpdate' => '<p>Returns descriptive information about an update against your Amazon EKS cluster or associated managed node group.</p> <p>When the status of the update is <code>Succeeded</code>, the update is complete. If an update fails, the status is <code>Failed</code>, and an error detail explains the reason for the failure.</p>', 'ListClusters' => '<p>Lists the Amazon EKS clusters in your AWS account in the specified Region.</p>', 'ListFargateProfiles' => '<p>Lists the AWS Fargate profiles associated with the specified cluster in your AWS account in the specified Region.</p>', 'ListNodegroups' => '<p>Lists the Amazon EKS managed node groups associated with the specified cluster in your AWS account in the specified Region. Self-managed node groups are not listed.</p>', 'ListTagsForResource' => '<p>List the tags for an Amazon EKS resource.</p>', 'ListUpdates' => '<p>Lists the updates associated with an Amazon EKS cluster or managed node group in your AWS account, in the specified Region.</p>', 'TagResource' => '<p>Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are deleted as well. Tags that you create for Amazon EKS resources do not propagate to any other resources associated with the cluster. For example, if you tag a cluster with this operation, that tag does not automatically propagate to the subnets and worker nodes associated with the cluster.</p>', 'UntagResource' => '<p>Deletes specified tags from a resource.</p>', 'UpdateClusterConfig' => '<p>Updates an Amazon EKS cluster configuration. Your cluster continues to function during the update. The response output includes an update ID that you can use to track the status of your cluster update with the <a>DescribeUpdate</a> API operation.</p> <p>You can use this API operation to enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default, cluster control plane logs aren\'t exported to CloudWatch Logs. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS Cluster Control Plane Logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p> <note> <p>CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">Amazon CloudWatch Pricing</a>.</p> </note> <p>You can also use this API operation to enable or disable public and private access to your cluster\'s Kubernetes API server endpoint. By default, public access is enabled, and private access is disabled. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS Cluster Endpoint Access Control</a> in the <i> <i>Amazon EKS User Guide</i> </i>. </p> <important> <p>At this time, you can not update the subnets or security group IDs for an existing cluster.</p> </important> <p>Cluster updates are asynchronous, and they should finish within a few minutes. During an update, the cluster status moves to <code>UPDATING</code> (this status transition is eventually consistent). When the update is complete (either <code>Failed</code> or <code>Successful</code>), the cluster status moves to <code>Active</code>.</p>', 'UpdateClusterVersion' => '<p>Updates an Amazon EKS cluster to the specified Kubernetes version. Your cluster continues to function during the update. The response output includes an update ID that you can use to track the status of your cluster update with the <a>DescribeUpdate</a> API operation.</p> <p>Cluster updates are asynchronous, and they should finish within a few minutes. During an update, the cluster status moves to <code>UPDATING</code> (this status transition is eventually consistent). When the update is complete (either <code>Failed</code> or <code>Successful</code>), the cluster status moves to <code>Active</code>.</p> <p>If your cluster has managed node groups attached to it, all of your node groups’ Kubernetes versions must match the cluster’s Kubernetes version in order to update the cluster to a new Kubernetes version.</p>', 'UpdateNodegroupConfig' => '<p>Updates an Amazon EKS managed node group configuration. Your node group continues to function during the update. The response output includes an update ID that you can use to track the status of your node group update with the <a>DescribeUpdate</a> API operation. Currently you can update the Kubernetes labels for a node group or the scaling configuration.</p>', 'UpdateNodegroupVersion' => '<p>Updates the Kubernetes version or AMI version of an Amazon EKS managed node group.</p> <p>You can update to the latest available AMI version of a node group\'s current Kubernetes version by not specifying a Kubernetes version in the request. You can update to the latest AMI version of your cluster\'s current Kubernetes version by specifying your cluster\'s Kubernetes version in the request. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon EKS-Optimized Linux AMI Versions</a> in the <i>Amazon EKS User Guide</i>.</p> <p>You cannot roll back a node group to an earlier Kubernetes version or AMI version.</p> <p>When a node in a managed node group is terminated due to a scaling action or update, the pods in that node are drained first. Amazon EKS attempts to drain the nodes gracefully and will fail if it is unable to do so. You can <code>force</code> the update if Amazon EKS is unable to drain the nodes as a result of a pod disruption budget issue.</p>', ], 'shapes' => [ 'AMITypes' => [ 'base' => NULL, 'refs' => [ 'CreateNodegroupRequest$amiType' => '<p>The AMI type for your node group. GPU instance types should use the <code>AL2_x86_64_GPU</code> AMI type, which uses the Amazon EKS-optimized Linux AMI with GPU support. Non-GPU instances should use the <code>AL2_x86_64</code> AMI type, which uses the Amazon EKS-optimized Linux AMI.</p>', 'Nodegroup$amiType' => '<p>The AMI type associated with your node group. GPU instance types should use the <code>AL2_x86_64_GPU</code> AMI type, which uses the Amazon EKS-optimized Linux AMI with GPU support. Non-GPU instances should use the <code>AL2_x86_64</code> AMI type, which uses the Amazon EKS-optimized Linux AMI.</p>', ], ], 'AutoScalingGroup' => [ 'base' => '<p>An Auto Scaling group that is associated with an Amazon EKS managed node group.</p>', 'refs' => [ 'AutoScalingGroupList$member' => NULL, ], ], 'AutoScalingGroupList' => [ 'base' => NULL, 'refs' => [ 'NodegroupResources$autoScalingGroups' => '<p>The Auto Scaling groups associated with the node group.</p>', ], ], 'BadRequestException' => [ 'base' => '<p>This exception is thrown if the request contains a semantic error. The precise meaning will depend on the API, and will be documented in the error message.</p>', 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'UpdateNodegroupVersionRequest$force' => '<p>Force the update if the existing node group\'s pods are unable to be drained due to a pod disruption budget issue. If an update fails because pods could not be drained, you can force the update after it fails to terminate the old node whether or not any pods are running on the node.</p>', 'VpcConfigResponse$endpointPublicAccess' => '<p>This parameter indicates whether the Amazon EKS public API server endpoint is enabled. If the Amazon EKS public API server endpoint is disabled, your cluster\'s Kubernetes API server can only receive requests that originate from within the cluster VPC.</p>', 'VpcConfigResponse$endpointPrivateAccess' => '<p>This parameter indicates whether the Amazon EKS private API server endpoint is enabled. If the Amazon EKS private API server endpoint is enabled, Kubernetes API requests that originate from within your cluster\'s VPC use the private VPC endpoint instead of traversing the internet. If this value is disabled and you have worker nodes or AWS Fargate pods in the cluster, then ensure that <code>publicAccessCidrs</code> includes the necessary CIDR blocks for communication with the worker nodes or Fargate pods. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS Cluster Endpoint Access Control</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p>', ], ], 'BoxedBoolean' => [ 'base' => NULL, 'refs' => [ 'LogSetup$enabled' => '<p>If a log type is enabled, that log type exports its control plane logs to CloudWatch Logs. If a log type isn\'t enabled, that log type doesn\'t export its control plane logs. Each individual log type can be enabled or disabled independently.</p>', 'VpcConfigRequest$endpointPublicAccess' => '<p>Set this value to <code>false</code> to disable public access to your cluster\'s Kubernetes API server endpoint. If you disable public access, your cluster\'s Kubernetes API server can only receive requests from within the cluster VPC. The default value for this parameter is <code>true</code>, which enables public access for your Kubernetes API server. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS Cluster Endpoint Access Control</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p>', 'VpcConfigRequest$endpointPrivateAccess' => '<p>Set this value to <code>true</code> to enable private access for your cluster\'s Kubernetes API server endpoint. If you enable private access, Kubernetes API requests from within your cluster\'s VPC use the private VPC endpoint. The default value for this parameter is <code>false</code>, which disables private access for your Kubernetes API server. If you disable private access and you have worker nodes or AWS Fargate pods in the cluster, then ensure that <code>publicAccessCidrs</code> includes the necessary CIDR blocks for communication with the worker nodes or Fargate pods. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS Cluster Endpoint Access Control</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p>', ], ], 'BoxedInteger' => [ 'base' => NULL, 'refs' => [ 'CreateNodegroupRequest$diskSize' => '<p>The root device disk size (in GiB) for your node group instances. The default disk size is 20 GiB.</p>', 'Nodegroup$diskSize' => '<p>The root device disk size (in GiB) for your node group instances. The default disk size is 20 GiB.</p>', ], ], 'Capacity' => [ 'base' => NULL, 'refs' => [ 'NodegroupScalingConfig$minSize' => '<p>The minimum number of worker nodes that the managed node group can scale in to. This number must be greater than zero.</p>', 'NodegroupScalingConfig$maxSize' => '<p>The maximum number of worker nodes that the managed node group can scale out to. Managed node groups can support up to 100 nodes by default.</p>', 'NodegroupScalingConfig$desiredSize' => '<p>The current number of worker nodes that the managed node group should maintain.</p>', ], ], 'Certificate' => [ 'base' => '<p>An object representing the <code>certificate-authority-data</code> for your cluster.</p>', 'refs' => [ 'Cluster$certificateAuthority' => '<p>The <code>certificate-authority-data</code> for your cluster.</p>', ], ], 'ClientException' => [ 'base' => '<p>These errors are usually caused by a client action. Actions can include using an action or resource on behalf of a user that doesn\'t have permissions to use the action or resource or specifying an identifier that is not valid.</p>', 'refs' => [], ], 'Cluster' => [ 'base' => '<p>An object representing an Amazon EKS cluster.</p>', 'refs' => [ 'CreateClusterResponse$cluster' => '<p>The full description of your new cluster.</p>', 'DeleteClusterResponse$cluster' => '<p>The full description of the cluster to delete.</p>', 'DescribeClusterResponse$cluster' => '<p>The full description of your specified cluster.</p>', ], ], 'ClusterName' => [ 'base' => NULL, 'refs' => [ 'CreateClusterRequest$name' => '<p>The unique name to give to your cluster.</p>', ], ], 'ClusterStatus' => [ 'base' => NULL, 'refs' => [ 'Cluster$status' => '<p>The current status of the cluster.</p>', ], ], 'CreateClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateClusterResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFargateProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFargateProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateNodegroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateNodegroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteClusterResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFargateProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFargateProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNodegroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNodegroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClusterResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFargateProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFargateProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNodegroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNodegroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUpdateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUpdateResponse' => [ 'base' => NULL, 'refs' => [], ], 'EncryptionConfig' => [ 'base' => '<p>The encryption configuration for the cluster.</p>', 'refs' => [ 'EncryptionConfigList$member' => NULL, ], ], 'EncryptionConfigList' => [ 'base' => NULL, 'refs' => [ 'Cluster$encryptionConfig' => '<p>The encryption configuration for the cluster.</p>', 'CreateClusterRequest$encryptionConfig' => '<p>The encryption configuration for the cluster.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'ErrorDetail$errorCode' => '<p>A brief description of the error. </p> <ul> <li> <p> <b>SubnetNotFound</b>: We couldn\'t find one of the subnets associated with the cluster.</p> </li> <li> <p> <b>SecurityGroupNotFound</b>: We couldn\'t find one of the security groups associated with the cluster.</p> </li> <li> <p> <b>EniLimitReached</b>: You have reached the elastic network interface limit for your account.</p> </li> <li> <p> <b>IpNotAvailable</b>: A subnet associated with the cluster doesn\'t have any free IP addresses.</p> </li> <li> <p> <b>AccessDenied</b>: You don\'t have permissions to perform the specified operation.</p> </li> <li> <p> <b>OperationNotPermitted</b>: The service role associated with the cluster doesn\'t have the required access permissions for Amazon EKS.</p> </li> <li> <p> <b>VpcIdNotFound</b>: We couldn\'t find the VPC associated with the cluster.</p> </li> </ul>', ], ], 'ErrorDetail' => [ 'base' => '<p>An object representing an error when an asynchronous operation fails.</p>', 'refs' => [ 'ErrorDetails$member' => NULL, ], ], 'ErrorDetails' => [ 'base' => NULL, 'refs' => [ 'Update$errors' => '<p>Any errors associated with a <code>Failed</code> update.</p>', ], ], 'FargateProfile' => [ 'base' => '<p>An object representing an AWS Fargate profile.</p>', 'refs' => [ 'CreateFargateProfileResponse$fargateProfile' => '<p>The full description of your new Fargate profile.</p>', 'DeleteFargateProfileResponse$fargateProfile' => '<p>The deleted Fargate profile.</p>', 'DescribeFargateProfileResponse$fargateProfile' => '<p>The full description of your Fargate profile.</p>', ], ], 'FargateProfileLabel' => [ 'base' => NULL, 'refs' => [ 'FargateProfileSelector$labels' => '<p>The Kubernetes labels that the selector should match. A pod must contain all of the labels that are specified in the selector for it to be considered a match.</p>', ], ], 'FargateProfileSelector' => [ 'base' => '<p>An object representing an AWS Fargate profile selector.</p>', 'refs' => [ 'FargateProfileSelectors$member' => NULL, ], ], 'FargateProfileSelectors' => [ 'base' => NULL, 'refs' => [ 'CreateFargateProfileRequest$selectors' => '<p>The selectors to match for pods to use this Fargate profile. Each selector must have an associated namespace. Optionally, you can also specify labels for a namespace. You may specify up to five selectors in a Fargate profile.</p>', 'FargateProfile$selectors' => '<p>The selectors to match for pods to use this Fargate profile.</p>', ], ], 'FargateProfileStatus' => [ 'base' => NULL, 'refs' => [ 'FargateProfile$status' => '<p>The current status of the Fargate profile.</p>', ], ], 'FargateProfilesRequestMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListFargateProfilesRequest$maxResults' => '<p>The maximum number of Fargate profile results returned by <code>ListFargateProfiles</code> in paginated output. When you use this parameter, <code>ListFargateProfiles</code> returns only <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListFargateProfiles</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don\'t use this parameter, <code>ListFargateProfiles</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>', ], ], 'Identity' => [ 'base' => '<p>An object representing an identity provider for authentication credentials.</p>', 'refs' => [ 'Cluster$identity' => '<p>The identity provider information for the cluster.</p>', ], ], 'InvalidParameterException' => [ 'base' => '<p>The specified parameter is invalid. Review the available parameters for the API request.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>The request is invalid given the state of the cluster. Check the state of the cluster and the associated operations.</p>', 'refs' => [], ], 'Issue' => [ 'base' => '<p>An object representing an issue with an Amazon EKS resource.</p>', 'refs' => [ 'IssueList$member' => NULL, ], ], 'IssueList' => [ 'base' => NULL, 'refs' => [ 'NodegroupHealth$issues' => '<p>Any issues that are associated with the node group. </p>', ], ], 'ListClustersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListClustersRequestMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListClustersRequest$maxResults' => '<p>The maximum number of cluster results returned by <code>ListClusters</code> in paginated output. When you use this parameter, <code>ListClusters</code> returns only <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListClusters</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don\'t use this parameter, <code>ListClusters</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>', ], ], 'ListClustersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFargateProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFargateProfilesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListNodegroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListNodegroupsRequestMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListNodegroupsRequest$maxResults' => '<p>The maximum number of node group results returned by <code>ListNodegroups</code> in paginated output. When you use this parameter, <code>ListNodegroups</code> returns only <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListNodegroups</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don\'t use this parameter, <code>ListNodegroups</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>', ], ], 'ListNodegroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUpdatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUpdatesRequestMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListUpdatesRequest$maxResults' => '<p>The maximum number of update results returned by <code>ListUpdates</code> in paginated output. When you use this parameter, <code>ListUpdates</code> returns only <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListUpdates</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don\'t use this parameter, <code>ListUpdates</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>', ], ], 'ListUpdatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogSetup' => [ 'base' => '<p>An object representing the enabled or disabled Kubernetes control plane logs for your cluster.</p>', 'refs' => [ 'LogSetups$member' => NULL, ], ], 'LogSetups' => [ 'base' => NULL, 'refs' => [ 'Logging$clusterLogging' => '<p>The cluster control plane logging configuration for your cluster.</p>', ], ], 'LogType' => [ 'base' => NULL, 'refs' => [ 'LogTypes$member' => NULL, ], ], 'LogTypes' => [ 'base' => NULL, 'refs' => [ 'LogSetup$types' => '<p>The available cluster control plane log types.</p>', ], ], 'Logging' => [ 'base' => '<p>An object representing the logging configuration for resources in your cluster.</p>', 'refs' => [ 'Cluster$logging' => '<p>The logging configuration for your cluster.</p>', 'CreateClusterRequest$logging' => '<p>Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default, cluster control plane logs aren\'t exported to CloudWatch Logs. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS Cluster Control Plane Logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p> <note> <p>CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">Amazon CloudWatch Pricing</a>.</p> </note>', 'UpdateClusterConfigRequest$logging' => '<p>Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default, cluster control plane logs aren\'t exported to CloudWatch Logs. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html">Amazon EKS Cluster Control Plane Logs</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p> <note> <p>CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see <a href="http://aws.amazon.com/cloudwatch/pricing/">Amazon CloudWatch Pricing</a>.</p> </note>', ], ], 'Nodegroup' => [ 'base' => '<p>An object representing an Amazon EKS managed node group.</p>', 'refs' => [ 'CreateNodegroupResponse$nodegroup' => '<p>The full description of your new node group.</p>', 'DeleteNodegroupResponse$nodegroup' => '<p>The full description of your deleted node group.</p>', 'DescribeNodegroupResponse$nodegroup' => '<p>The full description of your node group.</p>', ], ], 'NodegroupHealth' => [ 'base' => '<p>An object representing the health status of the node group.</p>', 'refs' => [ 'Nodegroup$health' => '<p>The health status of the node group. If there are issues with your node group\'s health, they are listed here.</p>', ], ], 'NodegroupIssueCode' => [ 'base' => NULL, 'refs' => [ 'Issue$code' => '<p>A brief description of the error.</p> <ul> <li> <p> <b>AutoScalingGroupNotFound</b>: We couldn\'t find the Auto Scaling group associated with the managed node group. You may be able to recreate an Auto Scaling group with the same settings to recover.</p> </li> <li> <p> <b>Ec2SecurityGroupNotFound</b>: We couldn\'t find the cluster security group for the cluster. You must recreate your cluster.</p> </li> <li> <p> <b>Ec2SecurityGroupDeletionFailure</b>: We could not delete the remote access security group for your managed node group. Remove any dependencies from the security group.</p> </li> <li> <p> <b>Ec2LaunchTemplateNotFound</b>: We couldn\'t find the Amazon EC2 launch template for your managed node group. You may be able to recreate a launch template with the same settings to recover.</p> </li> <li> <p> <b>Ec2LaunchTemplateVersionMismatch</b>: The Amazon EC2 launch template version for your managed node group does not match the version that Amazon EKS created. You may be able to revert to the version that Amazon EKS created to recover.</p> </li> <li> <p> <b>IamInstanceProfileNotFound</b>: We couldn\'t find the IAM instance profile for your managed node group. You may be able to recreate an instance profile with the same settings to recover.</p> </li> <li> <p> <b>IamNodeRoleNotFound</b>: We couldn\'t find the IAM role for your managed node group. You may be able to recreate an IAM role with the same settings to recover.</p> </li> <li> <p> <b>AsgInstanceLaunchFailures</b>: Your Auto Scaling group is experiencing failures while attempting to launch instances.</p> </li> <li> <p> <b>NodeCreationFailure</b>: Your launched instances are unable to register with your Amazon EKS cluster. Common causes of this failure are insufficient <a href="https://docs.aws.amazon.com/eks/latest/userguide/worker_node_IAM_role.html">worker node IAM role</a> permissions or lack of outbound internet access for the nodes. </p> </li> <li> <p> <b>InstanceLimitExceeded</b>: Your AWS account is unable to launch any more instances of the specified instance type. You may be able to request an Amazon EC2 instance limit increase to recover.</p> </li> <li> <p> <b>InsufficientFreeAddresses</b>: One or more of the subnets associated with your managed node group does not have enough available IP addresses for new nodes.</p> </li> <li> <p> <b>AccessDenied</b>: Amazon EKS or one or more of your managed nodes is unable to communicate with your cluster API server.</p> </li> <li> <p> <b>InternalFailure</b>: These errors are usually caused by an Amazon EKS server-side issue.</p> </li> </ul>', ], ], 'NodegroupResources' => [ 'base' => '<p>An object representing the resources associated with the node group, such as Auto Scaling groups and security groups for remote access.</p>', 'refs' => [ 'Nodegroup$resources' => '<p>The resources associated with the node group, such as Auto Scaling groups and security groups for remote access.</p>', ], ], 'NodegroupScalingConfig' => [ 'base' => '<p>An object representing the scaling configuration details for the Auto Scaling group that is associated with your node group.</p>', 'refs' => [ 'CreateNodegroupRequest$scalingConfig' => '<p>The scaling configuration details for the Auto Scaling group that is created for your node group.</p>', 'Nodegroup$scalingConfig' => '<p>The scaling configuration details for the Auto Scaling group that is associated with your node group.</p>', 'UpdateNodegroupConfigRequest$scalingConfig' => '<p>The scaling configuration details for the Auto Scaling group after the update.</p>', ], ], 'NodegroupStatus' => [ 'base' => NULL, 'refs' => [ 'Nodegroup$status' => '<p>The current status of the managed node group.</p>', ], ], 'NotFoundException' => [ 'base' => '<p>A service resource associated with the request could not be found. Clients should not retry such requests.</p>', 'refs' => [], ], 'OIDC' => [ 'base' => '<p>An object representing the <a href="https://openid.net/connect/">OpenID Connect</a> identity provider information for the cluster.</p>', 'refs' => [ 'Identity$oidc' => '<p>The <a href="https://openid.net/connect/">OpenID Connect</a> identity provider information for the cluster.</p>', ], ], 'Provider' => [ 'base' => '<p>Identifies the AWS Key Management Service (AWS KMS) customer master key (CMK) used to encrypt the secrets.</p>', 'refs' => [ 'EncryptionConfig$provider' => '<p>AWS Key Management Service (AWS KMS) customer master key (CMK). Either the ARN or the alias can be used.</p>', ], ], 'RemoteAccessConfig' => [ 'base' => '<p>An object representing the remote access configuration for the managed node group.</p>', 'refs' => [ 'CreateNodegroupRequest$remoteAccess' => '<p>The remote access (SSH) configuration to use with your node group.</p>', 'Nodegroup$remoteAccess' => '<p>The remote access (SSH) configuration that is associated with the node group.</p>', ], ], 'ResourceInUseException' => [ 'base' => '<p>The specified resource is in use.</p>', 'refs' => [], ], 'ResourceLimitExceededException' => [ 'base' => '<p>You have encountered a service limit on the specified resource.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource could not be found. You can view your available clusters with <a>ListClusters</a>. You can view your available managed node groups with <a>ListNodegroups</a>. Amazon EKS clusters and node groups are Region-specific.</p>', 'refs' => [], ], 'ServerException' => [ 'base' => '<p>These errors are usually caused by a server-side issue.</p>', 'refs' => [], ], 'ServiceUnavailableException' => [ 'base' => '<p>The service is unavailable. Back off and retry the operation.</p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroup$name' => '<p>The name of the Auto Scaling group associated with an Amazon EKS managed node group.</p>', 'BadRequestException$message' => NULL, 'Certificate$data' => '<p>The Base64-encoded certificate data required to communicate with your cluster. Add this to the <code>certificate-authority-data</code> section of the <code>kubeconfig</code> file for your cluster.</p>', 'ClientException$clusterName' => '<p>The Amazon EKS cluster associated with the exception.</p>', 'ClientException$nodegroupName' => '<p>The Amazon EKS managed node group associated with the exception.</p>', 'ClientException$message' => NULL, 'Cluster$name' => '<p>The name of the cluster.</p>', 'Cluster$arn' => '<p>The Amazon Resource Name (ARN) of the cluster.</p>', 'Cluster$version' => '<p>The Kubernetes server version for the cluster.</p>', 'Cluster$endpoint' => '<p>The endpoint for your Kubernetes API server.</p>', 'Cluster$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf.</p>', 'Cluster$clientRequestToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'Cluster$platformVersion' => '<p>The platform version of your Amazon EKS cluster. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/platform-versions.html">Platform Versions</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p>', 'CreateClusterRequest$version' => '<p>The desired Kubernetes version for your cluster. If you don\'t specify a value here, the latest version available in Amazon EKS is used.</p>', 'CreateClusterRequest$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that provides permissions for Amazon EKS to make calls to other AWS API operations on your behalf. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/service_IAM_role.html">Amazon EKS Service IAM Role</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p>', 'CreateClusterRequest$clientRequestToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'CreateFargateProfileRequest$fargateProfileName' => '<p>The name of the Fargate profile.</p>', 'CreateFargateProfileRequest$clusterName' => '<p>The name of the Amazon EKS cluster to apply the Fargate profile to.</p>', 'CreateFargateProfileRequest$podExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the pod execution role to use for pods that match the selectors in the Fargate profile. The pod execution role allows Fargate infrastructure to register with your cluster as a node, and it provides read access to Amazon ECR image repositories. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html">Pod Execution Role</a> in the <i>Amazon EKS User Guide</i>.</p>', 'CreateFargateProfileRequest$clientRequestToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'CreateNodegroupRequest$clusterName' => '<p>The name of the cluster to create the node group in.</p>', 'CreateNodegroupRequest$nodegroupName' => '<p>The unique name to give your node group.</p>', 'CreateNodegroupRequest$nodeRole' => '<p>The Amazon Resource Name (ARN) of the IAM role to associate with your node group. The Amazon EKS worker node <code>kubelet</code> daemon makes calls to AWS APIs on your behalf. Worker nodes receive permissions for these API calls through an IAM instance profile and associated policies. Before you can launch worker nodes and register them into a cluster, you must create an IAM role for those worker nodes to use when they are launched. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/worker_node_IAM_role.html">Amazon EKS Worker Node IAM Role</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p>', 'CreateNodegroupRequest$clientRequestToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'CreateNodegroupRequest$version' => '<p>The Kubernetes version to use for your managed nodes. By default, the Kubernetes version of the cluster is used, and this is the only accepted specified value.</p>', 'CreateNodegroupRequest$releaseVersion' => '<p>The AMI version of the Amazon EKS-optimized AMI to use with your node group. By default, the latest available AMI version for the node group\'s current Kubernetes version is used. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon EKS-Optimized Linux AMI Versions</a> in the <i>Amazon EKS User Guide</i>.</p>', 'DeleteClusterRequest$name' => '<p>The name of the cluster to delete.</p>', 'DeleteFargateProfileRequest$clusterName' => '<p>The name of the Amazon EKS cluster associated with the Fargate profile to delete.</p>', 'DeleteFargateProfileRequest$fargateProfileName' => '<p>The name of the Fargate profile to delete.</p>', 'DeleteNodegroupRequest$clusterName' => '<p>The name of the Amazon EKS cluster that is associated with your node group.</p>', 'DeleteNodegroupRequest$nodegroupName' => '<p>The name of the node group to delete.</p>', 'DescribeClusterRequest$name' => '<p>The name of the cluster to describe.</p>', 'DescribeFargateProfileRequest$clusterName' => '<p>The name of the Amazon EKS cluster associated with the Fargate profile.</p>', 'DescribeFargateProfileRequest$fargateProfileName' => '<p>The name of the Fargate profile to describe.</p>', 'DescribeNodegroupRequest$clusterName' => '<p>The name of the Amazon EKS cluster associated with the node group.</p>', 'DescribeNodegroupRequest$nodegroupName' => '<p>The name of the node group to describe.</p>', 'DescribeUpdateRequest$name' => '<p>The name of the Amazon EKS cluster associated with the update.</p>', 'DescribeUpdateRequest$updateId' => '<p>The ID of the update to describe.</p>', 'DescribeUpdateRequest$nodegroupName' => '<p>The name of the Amazon EKS node group associated with the update.</p>', 'ErrorDetail$errorMessage' => '<p>A more complete description of the error.</p>', 'FargateProfile$fargateProfileName' => '<p>The name of the Fargate profile.</p>', 'FargateProfile$fargateProfileArn' => '<p>The full Amazon Resource Name (ARN) of the Fargate profile.</p>', 'FargateProfile$clusterName' => '<p>The name of the Amazon EKS cluster that the Fargate profile belongs to.</p>', 'FargateProfile$podExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the pod execution role to use for pods that match the selectors in the Fargate profile. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html">Pod Execution Role</a> in the <i>Amazon EKS User Guide</i>.</p>', 'FargateProfileLabel$key' => NULL, 'FargateProfileLabel$value' => NULL, 'FargateProfileSelector$namespace' => '<p>The Kubernetes namespace that the selector should match.</p>', 'InvalidParameterException$clusterName' => '<p>The Amazon EKS cluster associated with the exception.</p>', 'InvalidParameterException$nodegroupName' => '<p>The Amazon EKS managed node group associated with the exception.</p>', 'InvalidParameterException$fargateProfileName' => '<p>The Fargate profile associated with the exception.</p>', 'InvalidParameterException$message' => NULL, 'InvalidRequestException$clusterName' => '<p>The Amazon EKS cluster associated with the exception.</p>', 'InvalidRequestException$nodegroupName' => '<p>The Amazon EKS managed node group associated with the exception.</p>', 'InvalidRequestException$message' => NULL, 'Issue$message' => '<p>The error message associated with the issue.</p>', 'ListClustersRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>ListClusters</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p> <note> <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListClustersResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListClusters</code> request. When the results of a <code>ListClusters</code> request exceed <code>maxResults</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'ListFargateProfilesRequest$clusterName' => '<p>The name of the Amazon EKS cluster that you would like to listFargate profiles in.</p>', 'ListFargateProfilesRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>ListFargateProfiles</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>', 'ListFargateProfilesResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListFargateProfiles</code> request. When the results of a <code>ListFargateProfiles</code> request exceed <code>maxResults</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'ListNodegroupsRequest$clusterName' => '<p>The name of the Amazon EKS cluster that you would like to list node groups in.</p>', 'ListNodegroupsRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>ListNodegroups</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>', 'ListNodegroupsResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListNodegroups</code> request. When the results of a <code>ListNodegroups</code> request exceed <code>maxResults</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) that identifies the resource for which to list the tags. Currently, the supported resources are Amazon EKS clusters and managed node groups.</p>', 'ListUpdatesRequest$name' => '<p>The name of the Amazon EKS cluster to list updates for.</p>', 'ListUpdatesRequest$nodegroupName' => '<p>The name of the Amazon EKS managed node group to list updates for.</p>', 'ListUpdatesRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>ListUpdates</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>', 'ListUpdatesResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListUpdates</code> request. When the results of a <code>ListUpdates</code> request exceed <code>maxResults</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'Nodegroup$nodegroupName' => '<p>The name associated with an Amazon EKS managed node group.</p>', 'Nodegroup$nodegroupArn' => '<p>The Amazon Resource Name (ARN) associated with the managed node group.</p>', 'Nodegroup$clusterName' => '<p>The name of the cluster that the managed node group resides in.</p>', 'Nodegroup$version' => '<p>The Kubernetes version of the managed node group.</p>', 'Nodegroup$releaseVersion' => '<p>The AMI version of the managed node group. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon EKS-Optimized Linux AMI Versions </a> in the <i>Amazon EKS User Guide</i>.</p>', 'Nodegroup$nodeRole' => '<p>The IAM role associated with your node group. The Amazon EKS worker node <code>kubelet</code> daemon makes calls to AWS APIs on your behalf. Worker nodes receive permissions for these API calls through an IAM instance profile and associated policies. Before you can launch worker nodes and register them into a cluster, you must create an IAM role for those worker nodes to use when they are launched. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/worker_node_IAM_role.html">Amazon EKS Worker Node IAM Role</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p>', 'NodegroupResources$remoteAccessSecurityGroup' => '<p>The remote access security group associated with the node group. This security group controls SSH access to the worker nodes.</p>', 'NotFoundException$message' => NULL, 'OIDC$issuer' => '<p>The issuer URL for the OpenID Connect identity provider.</p>', 'Provider$keyArn' => '<p>Amazon Resource Name (ARN) or alias of the customer master key (CMK). The CMK must be symmetric, created in the same region as the cluster, and if the CMK was created in a different account, the user must have access to the CMK. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-modifying-external-accounts.html">Allowing Users in Other Accounts to Use a CMK</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>', 'RemoteAccessConfig$ec2SshKey' => '<p>The Amazon EC2 SSH key that provides access for SSH communication with the worker nodes in the managed node group. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 Key Pairs</a> in the <i>Amazon Elastic Compute Cloud User Guide for Linux Instances</i>.</p>', 'ResourceInUseException$clusterName' => '<p>The Amazon EKS cluster associated with the exception.</p>', 'ResourceInUseException$nodegroupName' => '<p>The Amazon EKS managed node group associated with the exception.</p>', 'ResourceInUseException$message' => NULL, 'ResourceLimitExceededException$clusterName' => '<p>The Amazon EKS cluster associated with the exception.</p>', 'ResourceLimitExceededException$nodegroupName' => '<p>The Amazon EKS managed node group associated with the exception.</p>', 'ResourceLimitExceededException$message' => NULL, 'ResourceNotFoundException$clusterName' => '<p>The Amazon EKS cluster associated with the exception.</p>', 'ResourceNotFoundException$nodegroupName' => '<p>The Amazon EKS managed node group associated with the exception.</p>', 'ResourceNotFoundException$fargateProfileName' => '<p>The Fargate profile associated with the exception.</p>', 'ResourceNotFoundException$message' => NULL, 'ServerException$clusterName' => '<p>The Amazon EKS cluster associated with the exception.</p>', 'ServerException$nodegroupName' => '<p>The Amazon EKS managed node group associated with the exception.</p>', 'ServerException$message' => NULL, 'ServiceUnavailableException$message' => NULL, 'StringList$member' => NULL, 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to which to add tags. Currently, the supported resources are Amazon EKS clusters and managed node groups.</p>', 'UnsupportedAvailabilityZoneException$message' => NULL, 'UnsupportedAvailabilityZoneException$clusterName' => '<p>The Amazon EKS cluster associated with the exception.</p>', 'UnsupportedAvailabilityZoneException$nodegroupName' => '<p>The Amazon EKS managed node group associated with the exception.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource from which to delete tags. Currently, the supported resources are Amazon EKS clusters and managed node groups.</p>', 'Update$id' => '<p>A UUID that is used to track the update.</p>', 'UpdateClusterConfigRequest$name' => '<p>The name of the Amazon EKS cluster to update.</p>', 'UpdateClusterConfigRequest$clientRequestToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'UpdateClusterVersionRequest$name' => '<p>The name of the Amazon EKS cluster to update.</p>', 'UpdateClusterVersionRequest$version' => '<p>The desired Kubernetes version following a successful update.</p>', 'UpdateClusterVersionRequest$clientRequestToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'UpdateNodegroupConfigRequest$clusterName' => '<p>The name of the Amazon EKS cluster that the managed node group resides in.</p>', 'UpdateNodegroupConfigRequest$nodegroupName' => '<p>The name of the managed node group to update.</p>', 'UpdateNodegroupConfigRequest$clientRequestToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'UpdateNodegroupVersionRequest$clusterName' => '<p>The name of the Amazon EKS cluster that is associated with the managed node group to update.</p>', 'UpdateNodegroupVersionRequest$nodegroupName' => '<p>The name of the managed node group to update.</p>', 'UpdateNodegroupVersionRequest$version' => '<p>The Kubernetes version to update to. If no version is specified, then the Kubernetes version of the node group does not change. You can specify the Kubernetes version of the cluster to update the node group to the latest AMI version of the cluster\'s Kubernetes version.</p>', 'UpdateNodegroupVersionRequest$releaseVersion' => '<p>The AMI version of the Amazon EKS-optimized AMI to use for the update. By default, the latest available AMI version for the node group\'s Kubernetes version is used. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html">Amazon EKS-Optimized Linux AMI Versions </a> in the <i>Amazon EKS User Guide</i>.</p>', 'UpdateNodegroupVersionRequest$clientRequestToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'UpdateParam$value' => '<p>The value of the keys submitted as part of an update request.</p>', 'VpcConfigResponse$clusterSecurityGroupId' => '<p>The cluster security group that was created by Amazon EKS for the cluster. Managed node groups use this security group for control-plane-to-data-plane communication.</p>', 'VpcConfigResponse$vpcId' => '<p>The VPC associated with your cluster.</p>', 'labelsKeyList$member' => NULL, ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'CreateFargateProfileRequest$subnets' => '<p>The IDs of subnets to launch your pods into. At this time, pods running on Fargate are not assigned public IP addresses, so only private subnets (with no direct route to an Internet Gateway) are accepted for this parameter.</p>', 'CreateNodegroupRequest$subnets' => '<p>The subnets to use for the Auto Scaling group that is created for your node group. These subnets must have the tag key <code>kubernetes.io/cluster/CLUSTER_NAME</code> with a value of <code>shared</code>, where <code>CLUSTER_NAME</code> is replaced with the name of your cluster.</p>', 'CreateNodegroupRequest$instanceTypes' => '<p>The instance type to use for your node group. Currently, you can specify a single instance type for a node group. The default value for this parameter is <code>t3.medium</code>. If you choose a GPU instance type, be sure to specify the <code>AL2_x86_64_GPU</code> with the <code>amiType</code> parameter.</p>', 'EncryptionConfig$resources' => '<p>Specifies the resources to be encrypted. The only supported value is "secrets".</p>', 'ErrorDetail$resourceIds' => '<p>An optional field that contains the resource IDs associated with the error.</p>', 'FargateProfile$subnets' => '<p>The IDs of subnets to launch pods into.</p>', 'Issue$resourceIds' => '<p>The AWS resources that are afflicted by this issue.</p>', 'ListClustersResponse$clusters' => '<p>A list of all of the clusters for your account in the specified Region.</p>', 'ListFargateProfilesResponse$fargateProfileNames' => '<p>A list of all of the Fargate profiles associated with the specified cluster.</p>', 'ListNodegroupsResponse$nodegroups' => '<p>A list of all of the node groups associated with the specified cluster.</p>', 'ListUpdatesResponse$updateIds' => '<p>A list of all the updates for the specified cluster and Region.</p>', 'Nodegroup$instanceTypes' => '<p>The instance types associated with your node group.</p>', 'Nodegroup$subnets' => '<p>The subnets allowed for the Auto Scaling group that is associated with your node group. These subnets must have the following tag: <code>kubernetes.io/cluster/CLUSTER_NAME</code>, where <code>CLUSTER_NAME</code> is replaced with the name of your cluster.</p>', 'RemoteAccessConfig$sourceSecurityGroups' => '<p>The security groups that are allowed SSH access (port 22) to the worker nodes. If you specify an Amazon EC2 SSH key but do not specify a source security group when you create a managed node group, then port 22 on the worker nodes is opened to the internet (0.0.0.0/0). For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html">Security Groups for Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'UnsupportedAvailabilityZoneException$validZones' => '<p>The supported Availability Zones for your account. Choose subnets in these Availability Zones for your cluster.</p>', 'VpcConfigRequest$subnetIds' => '<p>Specify subnets for your Amazon EKS worker nodes. Amazon EKS creates cross-account elastic network interfaces in these subnets to allow communication between your worker nodes and the Kubernetes control plane.</p>', 'VpcConfigRequest$securityGroupIds' => '<p>Specify one or more security groups for the cross-account elastic network interfaces that Amazon EKS creates to use to allow communication between your worker nodes and the Kubernetes control plane. If you don\'t specify a security group, the default security group for your VPC is used.</p>', 'VpcConfigRequest$publicAccessCidrs' => '<p>The CIDR blocks that are allowed access to your cluster\'s public Kubernetes API server endpoint. Communication to the endpoint from addresses outside of the CIDR blocks that you specify is denied. The default value is <code>0.0.0.0/0</code>. If you\'ve disabled private endpoint access and you have worker nodes or AWS Fargate pods in the cluster, then ensure that you specify the necessary CIDR blocks. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS Cluster Endpoint Access Control</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p>', 'VpcConfigResponse$subnetIds' => '<p>The subnets associated with your cluster.</p>', 'VpcConfigResponse$securityGroupIds' => '<p>The security groups associated with the cross-account elastic network interfaces that are used to allow communication between your worker nodes and the Kubernetes control plane.</p>', 'VpcConfigResponse$publicAccessCidrs' => '<p>The CIDR blocks that are allowed access to your cluster\'s public Kubernetes API server endpoint. Communication to the endpoint from addresses outside of the listed CIDR blocks is denied. The default value is <code>0.0.0.0/0</code>. If you\'ve disabled private endpoint access and you have worker nodes or AWS Fargate pods in the cluster, then ensure that the necessary CIDR blocks are listed. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">Amazon EKS Cluster Endpoint Access Control</a> in the <i> <i>Amazon EKS User Guide</i> </i>.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The keys of the tags to be removed.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'Cluster$tags' => '<p>The metadata that you apply to the cluster to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Cluster tags do not propagate to any other resources associated with the cluster. </p>', 'CreateClusterRequest$tags' => '<p>The metadata to apply to the cluster to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define.</p>', 'CreateFargateProfileRequest$tags' => '<p>The metadata to apply to the Fargate profile to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Fargate profile tags do not propagate to any other resources associated with the Fargate profile, such as the pods that are scheduled with it.</p>', 'CreateNodegroupRequest$tags' => '<p>The metadata to apply to the node group to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Node group tags do not propagate to any other resources associated with the node group, such as the Amazon EC2 instances or subnets.</p>', 'FargateProfile$tags' => '<p>The metadata applied to the Fargate profile to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Fargate profile tags do not propagate to any other resources associated with the Fargate profile, such as the pods that are scheduled with it.</p>', 'ListTagsForResourceResponse$tags' => '<p>The tags for the resource.</p>', 'Nodegroup$tags' => '<p>The metadata applied to the node group to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Node group tags do not propagate to any other resources associated with the node group, such as the Amazon EC2 instances or subnets. </p>', 'TagResourceRequest$tags' => '<p>The tags to add to the resource. A tag is an array of key-value pairs.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'Cluster$createdAt' => '<p>The Unix epoch timestamp in seconds for when the cluster was created.</p>', 'FargateProfile$createdAt' => '<p>The Unix epoch timestamp in seconds for when the Fargate profile was created.</p>', 'Nodegroup$createdAt' => '<p>The Unix epoch timestamp in seconds for when the managed node group was created.</p>', 'Nodegroup$modifiedAt' => '<p>The Unix epoch timestamp in seconds for when the managed node group was last modified.</p>', 'Update$createdAt' => '<p>The Unix epoch timestamp in seconds for when the update was created.</p>', ], ], 'UnsupportedAvailabilityZoneException' => [ 'base' => '<p>At least one of your specified cluster subnets is in an Availability Zone that does not support Amazon EKS. The exception output specifies the supported Availability Zones for your account, from which you can choose subnets for your cluster.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Update' => [ 'base' => '<p>An object representing an asynchronous update.</p>', 'refs' => [ 'DescribeUpdateResponse$update' => '<p>The full description of the specified update.</p>', 'UpdateClusterConfigResponse$update' => NULL, 'UpdateClusterVersionResponse$update' => '<p>The full description of the specified update</p>', 'UpdateNodegroupConfigResponse$update' => NULL, 'UpdateNodegroupVersionResponse$update' => NULL, ], ], 'UpdateClusterConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateClusterConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateClusterVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateClusterVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLabelsPayload' => [ 'base' => '<p>An object representing a Kubernetes label change for a managed node group.</p>', 'refs' => [ 'UpdateNodegroupConfigRequest$labels' => '<p>The Kubernetes labels to be applied to the nodes in the node group after the update.</p>', ], ], 'UpdateNodegroupConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNodegroupConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNodegroupVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNodegroupVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateParam' => [ 'base' => '<p>An object representing the details of an update request.</p>', 'refs' => [ 'UpdateParams$member' => NULL, ], ], 'UpdateParamType' => [ 'base' => NULL, 'refs' => [ 'UpdateParam$type' => '<p>The keys associated with an update request.</p>', ], ], 'UpdateParams' => [ 'base' => NULL, 'refs' => [ 'Update$params' => '<p>A key-value map that contains the parameters associated with the update.</p>', ], ], 'UpdateStatus' => [ 'base' => NULL, 'refs' => [ 'Update$status' => '<p>The current status of the update.</p>', ], ], 'UpdateType' => [ 'base' => NULL, 'refs' => [ 'Update$type' => '<p>The type of the update.</p>', ], ], 'VpcConfigRequest' => [ 'base' => '<p>An object representing the VPC configuration to use for an Amazon EKS cluster.</p>', 'refs' => [ 'CreateClusterRequest$resourcesVpcConfig' => '<p>The VPC configuration used by the cluster control plane. Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html">Cluster VPC Considerations</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Cluster Security Group Considerations</a> in the <i>Amazon EKS User Guide</i>. You must specify at least two subnets. You can specify up to five security groups, but we recommend that you use a dedicated security group for your cluster control plane.</p>', 'UpdateClusterConfigRequest$resourcesVpcConfig' => NULL, ], ], 'VpcConfigResponse' => [ 'base' => '<p>An object representing an Amazon EKS cluster VPC configuration response.</p>', 'refs' => [ 'Cluster$resourcesVpcConfig' => '<p>The VPC configuration used by the cluster control plane. Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html">Cluster VPC Considerations</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html">Cluster Security Group Considerations</a> in the <i>Amazon EKS User Guide</i>.</p>', ], ], 'labelKey' => [ 'base' => NULL, 'refs' => [ 'labelsMap$key' => NULL, ], ], 'labelValue' => [ 'base' => NULL, 'refs' => [ 'labelsMap$value' => NULL, ], ], 'labelsKeyList' => [ 'base' => NULL, 'refs' => [ 'UpdateLabelsPayload$removeLabels' => '<p>Kubernetes labels to be removed.</p>', ], ], 'labelsMap' => [ 'base' => NULL, 'refs' => [ 'CreateNodegroupRequest$labels' => '<p>The Kubernetes labels to be applied to the nodes in the node group when they are created.</p>', 'Nodegroup$labels' => '<p>The Kubernetes labels applied to the nodes in the node group.</p> <note> <p>Only labels that are applied with the Amazon EKS API are shown here. There may be other Kubernetes labels applied to the nodes in this group.</p> </note>', 'UpdateLabelsPayload$addOrUpdateLabels' => '<p>Kubernetes labels to be added or updated.</p>', ], ], ],];
