<?php
// This file was auto-generated from sdk-root/src/data/ec2/2016-11-15/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon Elastic Compute Cloud</fullname> <p>Amazon Elastic Compute Cloud (Amazon EC2) provides secure and resizable computing capacity in the AWS cloud. Using Amazon EC2 eliminates the need to invest in hardware up front, so you can develop and deploy applications faster.</p> <p>To learn more, see the following resources:</p> <ul> <li> <p>Amazon EC2: <a href="http://aws.amazon.com/ec2">AmazonEC2 product page</a>, <a href="http://aws.amazon.com/documentation/ec2">Amazon EC2 documentation</a> </p> </li> <li> <p>Amazon EBS: <a href="http://aws.amazon.com/ebs">Amazon EBS product page</a>, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AmazonEBS.html">Amazon EBS documentation</a> </p> </li> <li> <p>Amazon VPC: <a href="http://aws.amazon.com/vpc">Amazon VPC product page</a>, <a href="http://aws.amazon.com/documentation/vpc">Amazon VPC documentation</a> </p> </li> <li> <p>AWS VPN: <a href="http://aws.amazon.com/vpn">AWS VPN product page</a>, <a href="http://aws.amazon.com/documentation/vpn">AWS VPN documentation</a> </p> </li> </ul>', 'operations' => [ 'AcceptReservedInstancesExchangeQuote' => '<p>Accepts the Convertible Reserved Instance exchange quote described in the <a>GetReservedInstancesExchangeQuote</a> call.</p>', 'AcceptTransitGatewayPeeringAttachment' => '<p>Accepts a transit gateway peering attachment request. The peering attachment must be in the <code>pendingAcceptance</code> state.</p>', 'AcceptTransitGatewayVpcAttachment' => '<p>Accepts a request to attach a VPC to a transit gateway.</p> <p>The VPC attachment must be in the <code>pendingAcceptance</code> state. Use <a>DescribeTransitGatewayVpcAttachments</a> to view your pending VPC attachment requests. Use <a>RejectTransitGatewayVpcAttachment</a> to reject a VPC attachment request.</p>', 'AcceptVpcEndpointConnections' => '<p>Accepts one or more interface VPC endpoint connection requests to your VPC endpoint service.</p>', 'AcceptVpcPeeringConnection' => '<p>Accept a VPC peering connection request. To accept a request, the VPC peering connection must be in the <code>pending-acceptance</code> state, and you must be the owner of the peer VPC. Use <a>DescribeVpcPeeringConnections</a> to view your outstanding VPC peering connection requests.</p> <p>For an inter-Region VPC peering connection request, you must accept the VPC peering connection in the Region of the accepter VPC.</p>', 'AdvertiseByoipCidr' => '<p>Advertises an IPv4 or IPv6 address range that is provisioned for use with your AWS resources through bring your own IP addresses (BYOIP).</p> <p>You can perform this operation at most once every 10 seconds, even if you specify different address ranges each time.</p> <p>We recommend that you stop advertising the BYOIP CIDR from other locations when you advertise it from AWS. To minimize down time, you can configure your AWS resources to use an address from a BYOIP CIDR before it is advertised, and then simultaneously stop advertising it from the current location and start advertising it through AWS.</p> <p>It can take a few minutes before traffic to the specified addresses starts routing to AWS because of BGP propagation delays.</p> <p>To stop advertising the BYOIP CIDR, use <a>WithdrawByoipCidr</a>.</p>', 'AllocateAddress' => '<p>Allocates an Elastic IP address to your AWS account. After you allocate the Elastic IP address you can associate it with an instance or network interface. After you release an Elastic IP address, it is released to the IP address pool and can be allocated to a different AWS account.</p> <p>You can allocate an Elastic IP address from an address pool owned by AWS or from an address pool created from a public IPv4 address range that you have brought to AWS for use with your AWS resources using bring your own IP addresses (BYOIP). For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">Bring Your Own IP Addresses (BYOIP)</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>[EC2-VPC] If you release an Elastic IP address, you might be able to recover it. You cannot recover an Elastic IP address that you released after it is allocated to another AWS account. You cannot recover an Elastic IP address for EC2-Classic. To attempt to recover an Elastic IP address that you released, specify it in this operation.</p> <p>An Elastic IP address is for use either in the EC2-Classic platform or in a VPC. By default, you can allocate 5 Elastic IP addresses for EC2-Classic per Region and 5 Elastic IP addresses for EC2-VPC per Region.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>You can allocate a carrier IP address which is a public IP address from a telecommunication carrier, to a network interface which resides in a subnet in a Wavelength Zone (for example an EC2 instance). </p>', 'AllocateHosts' => '<p>Allocates a Dedicated Host to your account. At a minimum, specify the supported instance type or instance family, the Availability Zone in which to allocate the host, and the number of hosts to allocate.</p>', 'ApplySecurityGroupsToClientVpnTargetNetwork' => '<p>Applies a security group to the association between the target network and the Client VPN endpoint. This action replaces the existing security groups with the specified security groups.</p>', 'AssignIpv6Addresses' => '<p>Assigns one or more IPv6 addresses to the specified network interface. You can specify one or more specific IPv6 addresses, or you can specify the number of IPv6 addresses to be automatically assigned from within the subnet\'s IPv6 CIDR block range. You can assign as many IPv6 addresses to a network interface as you can assign private IPv4 addresses, and the limit varies per instance type. For information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI">IP Addresses Per Network Interface Per Instance Type</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>You must specify either the IPv6 addresses or the IPv6 address count in the request.</p>', 'AssignPrivateIpAddresses' => '<p>Assigns one or more secondary private IP addresses to the specified network interface.</p> <p>You can specify one or more specific secondary IP addresses, or you can specify the number of secondary IP addresses to be automatically assigned within the subnet\'s CIDR block range. The number of secondary IP addresses that you can assign to an instance varies by instance type. For information about instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. For more information about Elastic IP addresses, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>When you move a secondary private IP address to another network interface, any Elastic IP address that is associated with the IP address is also moved.</p> <p>Remapping an IP address is an asynchronous operation. When you move an IP address from one network interface to another, check <code>network/interfaces/macs/mac/local-ipv4s</code> in the instance metadata to confirm that the remapping is complete.</p> <p>You must specify either the IP addresses or the IP address count in the request.</p>', 'AssociateAddress' => '<p>Associates an Elastic IP address, or carrier IP address (for instances that are in subnets in Wavelength Zones) with an instance or a network interface. Before you can use an Elastic IP address, you must allocate it to your account.</p> <p>An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>[EC2-Classic, VPC in an EC2-VPC-only account] If the Elastic IP address is already associated with a different instance, it is disassociated from that instance and associated with the specified instance. If you associate an Elastic IP address with an instance that has an existing Elastic IP address, the existing address is disassociated from the instance, but remains allocated to your account.</p> <p>[VPC in an EC2-Classic account] If you don\'t specify a private IP address, the Elastic IP address is associated with the primary IP address. If the Elastic IP address is already associated with a different instance or a network interface, you get an error unless you allow reassociation. You cannot associate an Elastic IP address with an instance or network interface that has an existing Elastic IP address.</p> <p>[Subnets in Wavelength Zones] You can associate an IP address from the telecommunication carrier to the instance or network interface. </p> <p>You cannot associate an Elastic IP address with an interface in a different network border group.</p> <important> <p>This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn\'t return an error, and you may be charged for each time the Elastic IP address is remapped to the same instance. For more information, see the <i>Elastic IP Addresses</i> section of <a href="http://aws.amazon.com/ec2/pricing/">Amazon EC2 Pricing</a>.</p> </important>', 'AssociateClientVpnTargetNetwork' => '<p>Associates a target network with a Client VPN endpoint. A target network is a subnet in a VPC. You can associate multiple subnets from the same VPC with a Client VPN endpoint. You can associate only one subnet in each Availability Zone. We recommend that you associate at least two subnets to provide Availability Zone redundancy.</p> <p>If you specified a VPC when you created the Client VPN endpoint or if you have previous subnet associations, the specified subnet must be in the same VPC. To specify a subnet that\'s in a different VPC, you must first modify the Client VPN endpoint (<a>ModifyClientVpnEndpoint</a>) and change the VPC that\'s associated with it.</p>', 'AssociateDhcpOptions' => '<p>Associates a set of DHCP options (that you\'ve previously created) with the specified VPC, or associates no DHCP options with the VPC.</p> <p>After you associate the options with the VPC, any existing instances and all new instances that you launch in that VPC use the options. You don\'t need to restart or relaunch the instances. They automatically pick up the changes within a few hours, depending on how frequently the instance renews its DHCP lease. You can explicitly renew the lease using the operating system on the instance.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP Options Sets</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'AssociateIamInstanceProfile' => '<p>Associates an IAM instance profile with a running or stopped instance. You cannot associate more than one IAM instance profile with an instance.</p>', 'AssociateRouteTable' => '<p>Associates a subnet in your VPC or an internet gateway or virtual private gateway attached to your VPC with a route table in your VPC. This association causes traffic from the subnet or gateway to be routed according to the routes in the route table. The action returns an association ID, which you need in order to disassociate the route table later. A route table can be associated with multiple subnets.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route Tables</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'AssociateSubnetCidrBlock' => '<p>Associates a CIDR block with your subnet. You can only associate a single IPv6 CIDR block with your subnet. An IPv6 CIDR block must have a prefix length of /64.</p>', 'AssociateTransitGatewayMulticastDomain' => '<p>Associates the specified subnets and transit gateway attachments with the specified transit gateway multicast domain.</p> <p>The transit gateway attachment must be in the available state before you can add a resource. Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayAttachments.html">DescribeTransitGatewayAttachments</a> to see the state of the attachment.</p>', 'AssociateTransitGatewayRouteTable' => '<p>Associates the specified attachment with the specified transit gateway route table. You can associate only one route table with an attachment.</p>', 'AssociateVpcCidrBlock' => '<p>Associates a CIDR block with your VPC. You can associate a secondary IPv4 CIDR block, an Amazon-provided IPv6 CIDR block, or an IPv6 CIDR block from an IPv6 address pool that you provisioned through bring your own IP addresses (<a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">BYOIP</a>). The IPv6 CIDR block size is fixed at /56.</p> <p>You must specify one of the following in the request: an IPv4 CIDR block, an IPv6 pool, or an Amazon-provided IPv6 CIDR block.</p> <p>For more information about associating CIDR blocks with your VPC and applicable restrictions, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html#VPC_Sizing">VPC and Subnet Sizing</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'AttachClassicLinkVpc' => '<p>Links an EC2-Classic instance to a ClassicLink-enabled VPC through one or more of the VPC\'s security groups. You cannot link an EC2-Classic instance to more than one VPC at a time. You can only link an instance that\'s in the <code>running</code> state. An instance is automatically unlinked from a VPC when it\'s stopped - you can link it to the VPC again when you restart it.</p> <p>After you\'ve linked an instance, you cannot change the VPC security groups that are associated with it. To change the security groups, you must first unlink the instance, and then link it again.</p> <p>Linking your instance to a VPC is sometimes referred to as <i>attaching</i> your instance.</p>', 'AttachInternetGateway' => '<p>Attaches an internet gateway or a virtual private gateway to a VPC, enabling connectivity between the internet and the VPC. For more information about your VPC and internet gateway, see the <a href="https://docs.aws.amazon.com/vpc/latest/userguide/">Amazon Virtual Private Cloud User Guide</a>.</p>', 'AttachNetworkInterface' => '<p>Attaches a network interface to an instance.</p>', 'AttachVolume' => '<p>Attaches an EBS volume to a running or stopped instance and exposes it to the instance with the specified device name.</p> <p>Encrypted EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>After you attach an EBS volume, you must make it available. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-using-volumes.html">Making an EBS Volume Available For Use</a>.</p> <p>If a volume has an AWS Marketplace product code:</p> <ul> <li> <p>The volume can be attached only to a stopped instance.</p> </li> <li> <p>AWS Marketplace product codes are copied from the volume to the instance.</p> </li> <li> <p>You must be subscribed to the product.</p> </li> <li> <p>The instance type and operating system of the instance must support the product. For example, you can\'t detach a volume from a Windows instance and attach it to a Linux instance.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-attaching-volume.html">Attaching Amazon EBS Volumes</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'AttachVpnGateway' => '<p>Attaches a virtual private gateway to a VPC. You can attach one virtual private gateway to one VPC at a time.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">AWS Site-to-Site VPN</a> in the <i>AWS Site-to-Site VPN User Guide</i>.</p>', 'AuthorizeClientVpnIngress' => '<p>Adds an ingress authorization rule to a Client VPN endpoint. Ingress authorization rules act as firewall rules that grant access to networks. You must configure ingress authorization rules to enable clients to access resources in AWS or on-premises networks.</p>', 'AuthorizeSecurityGroupEgress' => '<p>[VPC only] Adds the specified egress rules to a security group for use with a VPC.</p> <p>An outbound rule permits instances to send traffic to the specified IPv4 or IPv6 CIDR address ranges, or to the instances associated with the specified destination security groups.</p> <p>You specify a protocol for each rule (for example, TCP). For the TCP and UDP protocols, you must also specify the destination port or port range. For the ICMP protocol, you must also specify the ICMP type and code. You can use -1 for the type or code to mean all types or all codes.</p> <p>Rule changes are propagated to affected instances as quickly as possible. However, a small delay might occur.</p> <p>For more information about VPC security group limits, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC Limits</a>.</p>', 'AuthorizeSecurityGroupIngress' => '<p>Adds the specified ingress rules to a security group.</p> <p>An inbound rule permits instances to receive traffic from the specified IPv4 or IPv6 CIDR address ranges, or from the instances associated with the specified destination security groups.</p> <p>You specify a protocol for each rule (for example, TCP). For TCP and UDP, you must also specify the destination port or port range. For ICMP/ICMPv6, you must also specify the ICMP/ICMPv6 type and code. You can use -1 to mean all types or all codes.</p> <p>Rule changes are propagated to instances within the security group as quickly as possible. However, a small delay might occur.</p> <p>For more information about VPC security group limits, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC Limits</a>.</p>', 'BundleInstance' => '<p>Bundles an Amazon instance store-backed Windows instance.</p> <p>During bundling, only the root device volume (C:\\) is bundled. Data on other instance store volumes is not preserved.</p> <note> <p>This action is not applicable for Linux/Unix instances or Windows instances that are backed by Amazon EBS.</p> </note>', 'CancelBundleTask' => '<p>Cancels a bundling operation for an instance store-backed Windows instance.</p>', 'CancelCapacityReservation' => '<p>Cancels the specified Capacity Reservation, releases the reserved capacity, and changes the Capacity Reservation\'s state to <code>cancelled</code>.</p> <p>Instances running in the reserved capacity continue running until you stop them. Stopped instances that target the Capacity Reservation can no longer launch. Modify these instances to either target a different Capacity Reservation, launch On-Demand Instance capacity, or run in any open Capacity Reservation that has matching attributes and sufficient capacity.</p>', 'CancelConversionTask' => '<p>Cancels an active conversion task. The task can be the import of an instance or volume. The action removes all artifacts of the conversion, including a partially uploaded volume or instance. If the conversion is complete or is in the process of transferring the final disk image, the command fails and returns an exception.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/ec2-cli-vmimport-export.html">Importing a Virtual Machine Using the Amazon EC2 CLI</a>.</p>', 'CancelExportTask' => '<p>Cancels an active export task. The request removes all artifacts of the export, including any partially-created Amazon S3 objects. If the export task is complete or is in the process of transferring the final disk image, the command fails and returns an error.</p>', 'CancelImportTask' => '<p>Cancels an in-process import virtual machine or import snapshot task.</p>', 'CancelReservedInstancesListing' => '<p>Cancels the specified Reserved Instance listing in the Reserved Instance Marketplace.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance Marketplace</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CancelSpotFleetRequests' => '<p>Cancels the specified Spot Fleet requests.</p> <p>After you cancel a Spot Fleet request, the Spot Fleet launches no new Spot Instances. You must specify whether the Spot Fleet should also terminate its Spot Instances. If you terminate the instances, the Spot Fleet request enters the <code>cancelled_terminating</code> state. Otherwise, the Spot Fleet request enters the <code>cancelled_running</code> state and the instances continue to run until they are interrupted or you terminate them manually.</p>', 'CancelSpotInstanceRequests' => '<p>Cancels one or more Spot Instance requests.</p> <important> <p>Canceling a Spot Instance request does not terminate running Spot Instances associated with the request.</p> </important>', 'ConfirmProductInstance' => '<p>Determines whether a product code is associated with an instance. This action can only be used by the owner of the product code. It is useful when a product code owner must verify whether another user\'s instance is eligible for support.</p>', 'CopyFpgaImage' => '<p>Copies the specified Amazon FPGA Image (AFI) to the current Region.</p>', 'CopyImage' => '<p>Initiates the copy of an AMI from the specified source Region to the current Region. You specify the destination Region by using its endpoint when making the request.</p> <p>Copies of encrypted backing snapshots for the AMI are encrypted. Copies of unencrypted backing snapshots remain unencrypted, unless you set <code>Encrypted</code> during the copy operation. You cannot create an unencrypted copy of an encrypted backing snapshot.</p> <p>For more information about the prerequisites and limits when copying an AMI, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html">Copying an AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CopySnapshot' => '<p>Copies a point-in-time snapshot of an EBS volume and stores it in Amazon S3. You can copy the snapshot within the same Region or from one Region to another. You can use the snapshot to create EBS volumes or Amazon Machine Images (AMIs).</p> <p>Copies of encrypted EBS snapshots remain encrypted. Copies of unencrypted snapshots remain unencrypted, unless you enable encryption for the snapshot copy operation. By default, encrypted snapshot copies use the default AWS Key Management Service (AWS KMS) customer master key (CMK); however, you can specify a different CMK.</p> <p>To copy an encrypted snapshot that has been shared from another account, you must have permissions for the CMK used to encrypt the snapshot.</p> <p>Snapshots created by copying another snapshot have an arbitrary volume ID that should not be used for any purpose.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-copy-snapshot.html">Copying an Amazon EBS Snapshot</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateCapacityReservation' => '<p>Creates a new Capacity Reservation with the specified attributes.</p> <p>Capacity Reservations enable you to reserve capacity for your Amazon EC2 instances in a specific Availability Zone for any duration. This gives you the flexibility to selectively add capacity reservations and still get the Regional RI discounts for that usage. By creating Capacity Reservations, you ensure that you always have access to Amazon EC2 capacity when you need it, for as long as you need it. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html">Capacity Reservations</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>Your request to create a Capacity Reservation could fail if Amazon EC2 does not have sufficient capacity to fulfill the request. If your request fails due to Amazon EC2 capacity constraints, either try again at a later time, try in a different Availability Zone, or request a smaller capacity reservation. If your application is flexible across instance types and sizes, try to create a Capacity Reservation with different instance attributes.</p> <p>Your request could also fail if the requested quantity exceeds your On-Demand Instance limit for the selected instance type. If your request fails due to limit constraints, increase your On-Demand Instance limit for the required instance type and try again. For more information about increasing your instance limits, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html">Amazon EC2 Service Limits</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateCarrierGateway' => '<p>Creates a carrier gateway. For more information about carrier gateways, see <a href="https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#wavelength-carrier-gateway">Carrier gateways</a> in the <i>AWS Wavelength Developer Guide</i>.</p>', 'CreateClientVpnEndpoint' => '<p>Creates a Client VPN endpoint. A Client VPN endpoint is the resource you create and configure to enable and manage client VPN sessions. It is the destination endpoint at which all client VPN sessions are terminated.</p>', 'CreateClientVpnRoute' => '<p>Adds a route to a network to a Client VPN endpoint. Each Client VPN endpoint has a route table that describes the available destination network routes. Each route in the route table specifies the path for traﬃc to speciﬁc resources or networks.</p>', 'CreateCustomerGateway' => '<p>Provides information to AWS about your VPN customer gateway device. The customer gateway is the appliance at your end of the VPN connection. (The device on the AWS side of the VPN connection is the virtual private gateway.) You must provide the Internet-routable IP address of the customer gateway\'s external interface. The IP address must be static and can be behind a device performing network address translation (NAT).</p> <p>For devices that use Border Gateway Protocol (BGP), you can also provide the device\'s BGP Autonomous System Number (ASN). You can use an existing ASN assigned to your network. If you don\'t have an ASN already, you can use a private ASN (in the 64512 - 65534 range).</p> <note> <p>Amazon EC2 supports all 2-byte ASN numbers in the range of 1 - 65534, with the exception of 7224, which is reserved in the <code>us-east-1</code> Region, and 9059, which is reserved in the <code>eu-west-1</code> Region.</p> </note> <p>For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">AWS Site-to-Site VPN</a> in the <i>AWS Site-to-Site VPN User Guide</i>.</p> <important> <p>To create more than one customer gateway with the same VPN type, IP address, and BGP ASN, specify a unique device name for each customer gateway. Identical requests return information about the existing customer gateway and do not create new customer gateways.</p> </important>', 'CreateDefaultSubnet' => '<p>Creates a default subnet with a size <code>/20</code> IPv4 CIDR block in the specified Availability Zone in your default VPC. You can have only one default subnet per Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html#create-default-subnet">Creating a Default Subnet</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'CreateDefaultVpc' => '<p>Creates a default VPC with a size <code>/16</code> IPv4 CIDR block and a default subnet in each Availability Zone. For more information about the components of a default VPC, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html">Default VPC and Default Subnets</a> in the <i>Amazon Virtual Private Cloud User Guide</i>. You cannot specify the components of the default VPC yourself.</p> <p>If you deleted your previous default VPC, you can create a default VPC. You cannot have more than one default VPC per Region.</p> <p>If your account supports EC2-Classic, you cannot use this action to create a default VPC in a Region that supports EC2-Classic. If you want a default VPC in a Region that supports EC2-Classic, see "I really want a default VPC for my existing EC2 account. Is that possible?" in the <a href="http://aws.amazon.com/vpc/faqs/#Default_VPCs">Default VPCs FAQ</a>.</p>', 'CreateDhcpOptions' => '<p>Creates a set of DHCP options for your VPC. After creating the set, you must associate it with the VPC, causing all existing and new instances that you launch in the VPC to use this set of DHCP options. The following are the individual DHCP options you can specify. For more information about the options, see <a href="http://www.ietf.org/rfc/rfc2132.txt">RFC 2132</a>.</p> <ul> <li> <p> <code>domain-name-servers</code> - The IP addresses of up to four domain name servers, or AmazonProvidedDNS. The default DHCP option set specifies AmazonProvidedDNS. If specifying more than one domain name server, specify the IP addresses in a single parameter, separated by commas. To have your instance receive a custom DNS hostname as specified in <code>domain-name</code>, you must set <code>domain-name-servers</code> to a custom DNS server.</p> </li> <li> <p> <code>domain-name</code> - If you\'re using AmazonProvidedDNS in <code>us-east-1</code>, specify <code>ec2.internal</code>. If you\'re using AmazonProvidedDNS in another Region, specify <code>region.compute.internal</code> (for example, <code>ap-northeast-1.compute.internal</code>). Otherwise, specify a domain name (for example, <code>ExampleCompany.com</code>). This value is used to complete unqualified DNS hostnames. <b>Important</b>: Some Linux operating systems accept multiple domain names separated by spaces. However, Windows and other Linux operating systems treat the value as a single domain, which results in unexpected behavior. If your DHCP options set is associated with a VPC that has instances with multiple operating systems, specify only one domain name.</p> </li> <li> <p> <code>ntp-servers</code> - The IP addresses of up to four Network Time Protocol (NTP) servers.</p> </li> <li> <p> <code>netbios-name-servers</code> - The IP addresses of up to four NetBIOS name servers.</p> </li> <li> <p> <code>netbios-node-type</code> - The NetBIOS node type (1, 2, 4, or 8). We recommend that you specify 2 (broadcast and multicast are not currently supported). For more information about these node types, see <a href="http://www.ietf.org/rfc/rfc2132.txt">RFC 2132</a>.</p> </li> </ul> <p>Your VPC automatically starts out with a set of DHCP options that includes only a DNS server that we provide (AmazonProvidedDNS). If you create a set of options, and if your VPC has an internet gateway, make sure to set the <code>domain-name-servers</code> option either to <code>AmazonProvidedDNS</code> or to a domain name server of your choice. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP Options Sets</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'CreateEgressOnlyInternetGateway' => '<p>[IPv6 only] Creates an egress-only internet gateway for your VPC. An egress-only internet gateway is used to enable outbound communication over IPv6 from instances in your VPC to the internet, and prevents hosts outside of your VPC from initiating an IPv6 connection with your instance.</p>', 'CreateFleet' => '<p>Launches an EC2 Fleet.</p> <p>You can create a single EC2 Fleet that includes multiple launch specifications that vary by instance type, AMI, Availability Zone, or subnet.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html">Launching an EC2 Fleet</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateFlowLogs' => '<p>Creates one or more flow logs to capture information about IP traffic for a specific network interface, subnet, or VPC. </p> <p>Flow log data for a monitored network interface is recorded as flow log records, which are log events consisting of fields that describe the traffic flow. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow Log Records</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p> <p>When publishing to CloudWatch Logs, flow log records are published to a log group, and each network interface has a unique log stream in the log group. When publishing to Amazon S3, flow log records for all of the monitored network interfaces are published to a single log file object that is stored in the specified bucket.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html">VPC Flow Logs</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'CreateFpgaImage' => '<p>Creates an Amazon FPGA Image (AFI) from the specified design checkpoint (DCP).</p> <p>The create operation is asynchronous. To verify that the AFI is ready for use, check the output logs.</p> <p>An AFI contains the FPGA bitstream that is ready to download to an FPGA. You can securely deploy an AFI on multiple FPGA-accelerated instances. For more information, see the <a href="https://github.com/aws/aws-fpga/">AWS FPGA Hardware Development Kit</a>.</p>', 'CreateImage' => '<p>Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that is either running or stopped.</p> <p>If you customized your instance with instance store volumes or EBS volumes in addition to the root device volume, the new AMI contains block device mapping information for those volumes. When you launch an instance from this new AMI, the instance automatically launches with those additional volumes.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Creating Amazon EBS-Backed Linux AMIs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateInstanceExportTask' => '<p>Exports a running or stopped instance to an Amazon S3 bucket.</p> <p>For information about the supported operating systems, image formats, and known limitations for the types of instances you can export, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html">Exporting an Instance as a VM Using VM Import/Export</a> in the <i>VM Import/Export User Guide</i>.</p>', 'CreateInternetGateway' => '<p>Creates an internet gateway for use with a VPC. After creating the internet gateway, you attach it to a VPC using <a>AttachInternetGateway</a>.</p> <p>For more information about your VPC and internet gateway, see the <a href="https://docs.aws.amazon.com/vpc/latest/userguide/">Amazon Virtual Private Cloud User Guide</a>.</p>', 'CreateKeyPair' => '<p>Creates a 2048-bit RSA key pair with the specified name. Amazon EC2 stores the public key and displays the private key for you to save to a file. The private key is returned as an unencrypted PEM encoded PKCS#1 private key. If a key with the specified name already exists, Amazon EC2 returns an error.</p> <p>You can have up to five thousand key pairs per Region.</p> <p>The key pair returned to you is available only in the Region in which you create it. If you prefer, you can create your own key pair using a third-party tool and upload it to any Region using <a>ImportKeyPair</a>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Key Pairs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateLaunchTemplate' => '<p>Creates a launch template. A launch template contains the parameters to launch an instance. When you launch an instance using <a>RunInstances</a>, you can specify a launch template instead of providing the launch parameters in the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Launching an instance from a launch template</a>in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateLaunchTemplateVersion' => '<p>Creates a new version for a launch template. You can specify an existing version of launch template from which to base the new version.</p> <p>Launch template versions are numbered in the order in which they are created. You cannot specify, change, or replace the numbering of launch template versions.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#manage-launch-template-versions">Managing launch template versions</a>in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateLocalGatewayRoute' => '<p>Creates a static route for the specified local gateway route table.</p>', 'CreateLocalGatewayRouteTableVpcAssociation' => '<p>Associates the specified VPC with the specified local gateway route table.</p>', 'CreateManagedPrefixList' => '<p>Creates a managed prefix list. You can specify one or more entries for the prefix list. Each entry consists of a CIDR block and an optional description.</p> <p>You must specify the maximum number of entries for the prefix list. The maximum number of entries cannot be changed later.</p>', 'CreateNatGateway' => '<p>Creates a NAT gateway in the specified public subnet. This action creates a network interface in the specified subnet with a private IP address from the IP address range of the subnet. Internet-bound traffic from a private subnet can be routed to the NAT gateway, therefore enabling instances in the private subnet to connect to the internet. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html">NAT Gateways</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'CreateNetworkAcl' => '<p>Creates a network ACL in a VPC. Network ACLs provide an optional layer of security (in addition to security groups) for the instances in your VPC.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network ACLs</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'CreateNetworkAclEntry' => '<p>Creates an entry (a rule) in a network ACL with the specified rule number. Each network ACL has a set of numbered ingress rules and a separate set of numbered egress rules. When determining whether a packet should be allowed in or out of a subnet associated with the ACL, we process the entries in the ACL according to the rule numbers, in ascending order. Each network ACL has a set of ingress rules and a separate set of egress rules.</p> <p>We recommend that you leave room between the rule numbers (for example, 100, 110, 120, ...), and not number them one right after the other (for example, 101, 102, 103, ...). This makes it easier to add a rule between existing ones without having to renumber the rules.</p> <p>After you add an entry, you can\'t modify it; you must either replace it, or create an entry and delete the old one.</p> <p>For more information about network ACLs, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network ACLs</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'CreateNetworkInterface' => '<p>Creates a network interface in the specified subnet.</p> <p>For more information about network interfaces, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html">Elastic Network Interfaces</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'CreateNetworkInterfacePermission' => '<p>Grants an AWS-authorized account permission to attach the specified network interface to an instance in their account.</p> <p>You can grant permission to a single AWS account only, and only one account at a time.</p>', 'CreatePlacementGroup' => '<p>Creates a placement group in which to launch instances. The strategy of the placement group determines how the instances are organized within the group. </p> <p>A <code>cluster</code> placement group is a logical grouping of instances within a single Availability Zone that benefit from low network latency, high network throughput. A <code>spread</code> placement group places instances on distinct hardware. A <code>partition</code> placement group places groups of instances in different partitions, where instances in one partition do not share the same hardware with instances in another partition.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateReservedInstancesListing' => '<p>Creates a listing for Amazon EC2 Standard Reserved Instances to be sold in the Reserved Instance Marketplace. You can submit one Standard Reserved Instance listing at a time. To get a list of your Standard Reserved Instances, you can use the <a>DescribeReservedInstances</a> operation.</p> <note> <p>Only Standard Reserved Instances can be sold in the Reserved Instance Marketplace. Convertible Reserved Instances cannot be sold.</p> </note> <p>The Reserved Instance Marketplace matches sellers who want to resell Standard Reserved Instance capacity that they no longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold through the Reserved Instance Marketplace work like any other Reserved Instances.</p> <p>To sell your Standard Reserved Instances, you must first register as a seller in the Reserved Instance Marketplace. After completing the registration process, you can create a Reserved Instance Marketplace listing of some or all of your Standard Reserved Instances, and specify the upfront price to receive for them. Your Standard Reserved Instance listings then become available for purchase. To view the details of your Standard Reserved Instance listing, you can use the <a>DescribeReservedInstancesListings</a> operation.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance Marketplace</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateRoute' => '<p>Creates a route in a route table within a VPC.</p> <p>You must specify one of the following targets: internet gateway or virtual private gateway, NAT instance, NAT gateway, VPC peering connection, network interface, egress-only internet gateway, or transit gateway.</p> <p>When determining how to route traffic, we use the route with the most specific match. For example, traffic is destined for the IPv4 address <code>192.0.2.3</code>, and the route table includes the following two IPv4 routes:</p> <ul> <li> <p> <code>192.0.2.0/24</code> (goes to some target A)</p> </li> <li> <p> <code>192.0.2.0/28</code> (goes to some target B)</p> </li> </ul> <p>Both routes apply to the traffic destined for <code>192.0.2.3</code>. However, the second route in the list covers a smaller number of IP addresses and is therefore more specific, so we use that route to determine where to target the traffic.</p> <p>For more information about route tables, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route Tables</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'CreateRouteTable' => '<p>Creates a route table for the specified VPC. After you create a route table, you can add routes and associate the table with a subnet.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route Tables</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'CreateSecurityGroup' => '<p>Creates a security group.</p> <p>A security group acts as a virtual firewall for your instance to control inbound and outbound traffic. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2 Security Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p> <p>When you create a security group, you specify a friendly name of your choice. You can have a security group for use in EC2-Classic with the same name as a security group for use in a VPC. However, you can\'t have two security groups for use in EC2-Classic with the same name or two security groups for use in a VPC with the same name.</p> <p>You have a default security group for use in EC2-Classic and a default security group for use in your VPC. If you don\'t specify a security group when you launch an instance, the instance is launched into the appropriate default security group. A default security group includes a default rule that grants instances unrestricted network access to each other.</p> <p>You can add or remove rules from your security groups using <a>AuthorizeSecurityGroupIngress</a>, <a>AuthorizeSecurityGroupEgress</a>, <a>RevokeSecurityGroupIngress</a>, and <a>RevokeSecurityGroupEgress</a>.</p> <p>For more information about VPC security group limits, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC Limits</a>.</p>', 'CreateSnapshot' => '<p>Creates a snapshot of an EBS volume and stores it in Amazon S3. You can use snapshots for backups, to make copies of EBS volumes, and to save data before shutting down an instance.</p> <p>When a snapshot is created, any AWS Marketplace product codes that are associated with the source volume are propagated to the snapshot.</p> <p>You can take a snapshot of an attached volume that is in use. However, snapshots only capture data that has been written to your EBS volume at the time the snapshot command is issued; this may exclude any data that has been cached by any applications or the operating system. If you can pause any file systems on the volume long enough to take a snapshot, your snapshot should be complete. However, if you cannot pause all file writes to the volume, you should unmount the volume from within the instance, issue the snapshot command, and then remount the volume to ensure a consistent and complete snapshot. You may remount and use your volume while the snapshot status is <code>pending</code>.</p> <p>To create a snapshot for EBS volumes that serve as root devices, you should stop the instance before taking the snapshot.</p> <p>Snapshots that are taken from encrypted volumes are automatically encrypted. Volumes that are created from encrypted snapshots are also automatically encrypted. Your encrypted volumes and any associated snapshots always remain protected.</p> <p>You can tag your snapshots during creation. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Amazon EC2 Resources</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AmazonEBS.html">Amazon Elastic Block Store</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateSnapshots' => '<p>Creates crash-consistent snapshots of multiple EBS volumes and stores the data in S3. Volumes are chosen by specifying an instance. Any attached volumes will produce one snapshot each that is crash-consistent across the instance. Boot volumes can be excluded by changing the parameters. </p>', 'CreateSpotDatafeedSubscription' => '<p>Creates a data feed for Spot Instances, enabling you to view Spot Instance usage logs. You can create one data feed per AWS account. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html">Spot Instance data feed</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>', 'CreateSubnet' => '<p>Creates a subnet in a specified VPC.</p> <p>You must specify an IPv4 CIDR block for the subnet. After you create a subnet, you can\'t change its CIDR block. The allowed block size is between a /16 netmask (65,536 IP addresses) and /28 netmask (16 IP addresses). The CIDR block must not overlap with the CIDR block of an existing subnet in the VPC.</p> <p>If you\'ve associated an IPv6 CIDR block with your VPC, you can create a subnet with an IPv6 CIDR block that uses a /64 prefix length. </p> <important> <p>AWS reserves both the first four and the last IPv4 address in each subnet\'s CIDR block. They\'re not available for use.</p> </important> <p>If you add more than one subnet to a VPC, they\'re set up in a star topology with a logical router in the middle.</p> <p>When you stop an instance in a subnet, it retains its private IPv4 address. It\'s therefore possible to have a subnet with no running instances (they\'re all stopped), but no remaining IP addresses available.</p> <p>For more information about subnets, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Your VPC and Subnets</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'CreateTags' => '<p>Adds or overwrites only the specified tags for the specified Amazon EC2 resource or resources. When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags. Each tag consists of a key and optional value. Tag keys must be unique per resource.</p> <p>For more information about tags, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Resources</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. For more information about creating IAM policies that control users\' access to resources based on tags, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-iam-actions-resources.html">Supported Resource-Level Permissions for Amazon EC2 API Actions</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateTrafficMirrorFilter' => '<p>Creates a Traffic Mirror filter.</p> <p>A Traffic Mirror filter is a set of rules that defines the traffic to mirror.</p> <p>By default, no traffic is mirrored. To mirror traffic, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilterRule.htm">CreateTrafficMirrorFilterRule</a> to add Traffic Mirror rules to the filter. The rules you add define what traffic gets mirrored. You can also use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorFilterNetworkServices.html">ModifyTrafficMirrorFilterNetworkServices</a> to mirror supported network services.</p>', 'CreateTrafficMirrorFilterRule' => '<p>Creates a Traffic Mirror filter rule. </p> <p>A Traffic Mirror rule defines the Traffic Mirror source traffic to mirror.</p> <p>You need the Traffic Mirror filter ID when you create the rule.</p>', 'CreateTrafficMirrorSession' => '<p>Creates a Traffic Mirror session.</p> <p>A Traffic Mirror session actively copies packets from a Traffic Mirror source to a Traffic Mirror target. Create a filter, and then assign it to the session to define a subset of the traffic to mirror, for example all TCP traffic.</p> <p>The Traffic Mirror source and the Traffic Mirror target (monitoring appliances) can be in the same VPC, or in a different VPC connected via VPC peering or a transit gateway. </p> <p>By default, no traffic is mirrored. Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilter.htm">CreateTrafficMirrorFilter</a> to create filter rules that specify the traffic to mirror.</p>', 'CreateTrafficMirrorTarget' => '<p>Creates a target for your Traffic Mirror session.</p> <p>A Traffic Mirror target is the destination for mirrored traffic. The Traffic Mirror source and the Traffic Mirror target (monitoring appliances) can be in the same VPC, or in different VPCs connected via VPC peering or a transit gateway.</p> <p>A Traffic Mirror target can be a network interface, or a Network Load Balancer.</p> <p>To use the target in a Traffic Mirror session, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorSession.htm">CreateTrafficMirrorSession</a>.</p>', 'CreateTransitGateway' => '<p>Creates a transit gateway.</p> <p>You can use a transit gateway to interconnect your virtual private clouds (VPC) and on-premises networks. After the transit gateway enters the <code>available</code> state, you can attach your VPCs and VPN connections to the transit gateway.</p> <p>To attach your VPCs, use <a>CreateTransitGatewayVpcAttachment</a>.</p> <p>To attach a VPN connection, use <a>CreateCustomerGateway</a> to create a customer gateway and specify the ID of the customer gateway and the ID of the transit gateway in a call to <a>CreateVpnConnection</a>.</p> <p>When you create a transit gateway, we create a default transit gateway route table and use it as the default association route table and the default propagation route table. You can use <a>CreateTransitGatewayRouteTable</a> to create additional transit gateway route tables. If you disable automatic route propagation, we do not create a default transit gateway route table. You can use <a>EnableTransitGatewayRouteTablePropagation</a> to propagate routes from a resource attachment to a transit gateway route table. If you disable automatic associations, you can use <a>AssociateTransitGatewayRouteTable</a> to associate a resource attachment with a transit gateway route table.</p>', 'CreateTransitGatewayMulticastDomain' => '<p>Creates a multicast domain using the specified transit gateway.</p> <p>The transit gateway must be in the available state before you create a domain. Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGateways.html">DescribeTransitGateways</a> to see the state of transit gateway.</p>', 'CreateTransitGatewayPeeringAttachment' => '<p>Requests a transit gateway peering attachment between the specified transit gateway (requester) and a peer transit gateway (accepter). The transit gateways must be in different Regions. The peer transit gateway can be in your account or a different AWS account. </p> <p>After you create the peering attachment, the owner of the accepter transit gateway must accept the attachment request.</p>', 'CreateTransitGatewayRoute' => '<p>Creates a static route for the specified transit gateway route table.</p>', 'CreateTransitGatewayRouteTable' => '<p>Creates a route table for the specified transit gateway.</p>', 'CreateTransitGatewayVpcAttachment' => '<p>Attaches the specified VPC to the specified transit gateway.</p> <p>If you attach a VPC with a CIDR range that overlaps the CIDR range of a VPC that is already attached, the new VPC CIDR range is not propagated to the default propagation route table.</p> <p>To send VPC traffic to an attached transit gateway, add a route to the VPC route table using <a>CreateRoute</a>.</p>', 'CreateVolume' => '<p>Creates an EBS volume that can be attached to an instance in the same Availability Zone. The volume is created in the regional endpoint that you send the HTTP request to. For more information see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.</p> <p>You can create a new empty volume or restore a volume from an EBS snapshot. Any AWS Marketplace product codes from the snapshot are propagated to the volume.</p> <p>You can create encrypted volumes. Encrypted volumes must be attached to instances that support Amazon EBS encryption. Volumes that are created from encrypted snapshots are also automatically encrypted. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>You can tag your volumes during creation. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Amazon EC2 Resources</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-creating-volume.html">Creating an Amazon EBS Volume</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateVpc' => '<p>Creates a VPC with the specified IPv4 CIDR block. The smallest VPC you can create uses a /28 netmask (16 IPv4 addresses), and the largest uses a /16 netmask (65,536 IPv4 addresses). For more information about how large to make your VPC, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Your VPC and Subnets</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p> <p>You can optionally request an IPv6 CIDR block for the VPC. You can request an Amazon-provided IPv6 CIDR block from Amazon\'s pool of IPv6 addresses, or an IPv6 CIDR block from an IPv6 address pool that you provisioned through bring your own IP addresses (<a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">BYOIP</a>).</p> <p>By default, each instance you launch in the VPC has the default DHCP options, which include only a default DNS server that we provide (AmazonProvidedDNS). For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP Options Sets</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p> <p>You can specify the instance tenancy value for the VPC when you create it. You can\'t change this value for the VPC after you create it. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html">Dedicated Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateVpcEndpoint' => '<p>Creates a VPC endpoint for a specified service. An endpoint enables you to create a private connection between your VPC and the service. The service may be provided by AWS, an AWS Marketplace Partner, or another AWS account. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints.html">VPC Endpoints</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p> <p>A <code>gateway</code> endpoint serves as a target for a route in your route table for traffic destined for the AWS service. You can specify an endpoint policy to attach to the endpoint, which will control access to the service from your VPC. You can also specify the VPC route tables that use the endpoint.</p> <p>An <code>interface</code> endpoint is a network interface in your subnet that serves as an endpoint for communicating with the specified service. You can specify the subnets in which to create an endpoint, and the security groups to associate with the endpoint network interface.</p> <p>Use <a>DescribeVpcEndpointServices</a> to get a list of supported services.</p>', 'CreateVpcEndpointConnectionNotification' => '<p>Creates a connection notification for a specified VPC endpoint or VPC endpoint service. A connection notification notifies you of specific endpoint events. You must create an SNS topic to receive notifications. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Create a Topic</a> in the <i>Amazon Simple Notification Service Developer Guide</i>.</p> <p>You can create a connection notification for interface endpoints only.</p>', 'CreateVpcEndpointServiceConfiguration' => '<p>Creates a VPC endpoint service configuration to which service consumers (AWS accounts, IAM users, and IAM roles) can connect. Service consumers can create an interface VPC endpoint to connect to your service.</p> <p>To create an endpoint service configuration, you must first create a Network Load Balancer for your service. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html">VPC Endpoint Services</a> in the <i>Amazon Virtual Private Cloud User Guide</i>. </p> <p>If you set the private DNS name, you must prove that you own the private DNS domain name. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-services-dns-validation.html">VPC Endpoint Service Private DNS Name Verification</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'CreateVpcPeeringConnection' => '<p>Requests a VPC peering connection between two VPCs: a requester VPC that you own and an accepter VPC with which to create the connection. The accepter VPC can belong to another AWS account and can be in a different Region to the requester VPC. The requester VPC and accepter VPC cannot have overlapping CIDR blocks.</p> <note> <p>Limitations and rules apply to a VPC peering connection. For more information, see the <a href="https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-basics.html#vpc-peering-limitations">limitations</a> section in the <i>VPC Peering Guide</i>.</p> </note> <p>The owner of the accepter VPC must accept the peering request to activate the peering connection. The VPC peering connection request expires after 7 days, after which it cannot be accepted or rejected.</p> <p>If you create a VPC peering connection request between VPCs with overlapping CIDR blocks, the VPC peering connection has a status of <code>failed</code>.</p>', 'CreateVpnConnection' => '<p>Creates a VPN connection between an existing virtual private gateway and a VPN customer gateway. The supported connection type is <code>ipsec.1</code>.</p> <p>The response includes information that you need to give to your network administrator to configure your customer gateway.</p> <important> <p>We strongly recommend that you use HTTPS when calling this operation because the response contains sensitive cryptographic information for configuring your customer gateway.</p> </important> <p>If you decide to shut down your VPN connection for any reason and later create a new VPN connection, you must reconfigure your customer gateway with the new information returned from this call.</p> <p>This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn\'t return an error.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">AWS Site-to-Site VPN</a> in the <i>AWS Site-to-Site VPN User Guide</i>.</p>', 'CreateVpnConnectionRoute' => '<p>Creates a static route associated with a VPN connection between an existing virtual private gateway and a VPN customer gateway. The static route allows traffic to be routed from the virtual private gateway to the VPN customer gateway.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">AWS Site-to-Site VPN</a> in the <i>AWS Site-to-Site VPN User Guide</i>.</p>', 'CreateVpnGateway' => '<p>Creates a virtual private gateway. A virtual private gateway is the endpoint on the VPC side of your VPN connection. You can create a virtual private gateway before creating the VPC itself.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">AWS Site-to-Site VPN</a> in the <i>AWS Site-to-Site VPN User Guide</i>.</p>', 'DeleteCarrierGateway' => '<p>Deletes a carrier gateway.</p> <important> <p>If you do not delete the route that contains the carrier gateway as the Target, the route is a blackhole route. For information about how to delete a route, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteRoute.html">DeleteRoute</a>.</p> </important>', 'DeleteClientVpnEndpoint' => '<p>Deletes the specified Client VPN endpoint. You must disassociate all target networks before you can delete a Client VPN endpoint.</p>', 'DeleteClientVpnRoute' => '<p>Deletes a route from a Client VPN endpoint. You can only delete routes that you manually added using the <b>CreateClientVpnRoute</b> action. You cannot delete routes that were automatically added when associating a subnet. To remove routes that have been automatically added, disassociate the target subnet from the Client VPN endpoint.</p>', 'DeleteCustomerGateway' => '<p>Deletes the specified customer gateway. You must delete the VPN connection before you can delete the customer gateway.</p>', 'DeleteDhcpOptions' => '<p>Deletes the specified set of DHCP options. You must disassociate the set of DHCP options before you can delete it. You can disassociate the set of DHCP options by associating either a new set of options or the default set of options with the VPC.</p>', 'DeleteEgressOnlyInternetGateway' => '<p>Deletes an egress-only internet gateway.</p>', 'DeleteFleets' => '<p>Deletes the specified EC2 Fleet.</p> <p>After you delete an EC2 Fleet, it launches no new instances. You must specify whether an EC2 Fleet should also terminate its instances. If you terminate the instances, the EC2 Fleet enters the <code>deleted_terminating</code> state. Otherwise, the EC2 Fleet enters the <code>deleted_running</code> state, and the instances continue to run until they are interrupted or you terminate them manually. </p>', 'DeleteFlowLogs' => '<p>Deletes one or more flow logs.</p>', 'DeleteFpgaImage' => '<p>Deletes the specified Amazon FPGA Image (AFI).</p>', 'DeleteInternetGateway' => '<p>Deletes the specified internet gateway. You must detach the internet gateway from the VPC before you can delete it.</p>', 'DeleteKeyPair' => '<p>Deletes the specified key pair, by removing the public key from Amazon EC2.</p>', 'DeleteLaunchTemplate' => '<p>Deletes a launch template. Deleting a launch template deletes all of its versions.</p>', 'DeleteLaunchTemplateVersions' => '<p>Deletes one or more versions of a launch template. You cannot delete the default version of a launch template; you must first assign a different version as the default. If the default version is the only version for the launch template, you must delete the entire launch template using <a>DeleteLaunchTemplate</a>.</p>', 'DeleteLocalGatewayRoute' => '<p>Deletes the specified route from the specified local gateway route table.</p>', 'DeleteLocalGatewayRouteTableVpcAssociation' => '<p>Deletes the specified association between a VPC and local gateway route table.</p>', 'DeleteManagedPrefixList' => '<p>Deletes the specified managed prefix list. You must first remove all references to the prefix list in your resources.</p>', 'DeleteNatGateway' => '<p>Deletes the specified NAT gateway. Deleting a NAT gateway disassociates its Elastic IP address, but does not release the address from your account. Deleting a NAT gateway does not delete any NAT gateway routes in your route tables.</p>', 'DeleteNetworkAcl' => '<p>Deletes the specified network ACL. You can\'t delete the ACL if it\'s associated with any subnets. You can\'t delete the default network ACL.</p>', 'DeleteNetworkAclEntry' => '<p>Deletes the specified ingress or egress entry (rule) from the specified network ACL.</p>', 'DeleteNetworkInterface' => '<p>Deletes the specified network interface. You must detach the network interface before you can delete it.</p>', 'DeleteNetworkInterfacePermission' => '<p>Deletes a permission for a network interface. By default, you cannot delete the permission if the account for which you\'re removing the permission has attached the network interface to an instance. However, you can force delete the permission, regardless of any attachment.</p>', 'DeletePlacementGroup' => '<p>Deletes the specified placement group. You must terminate all instances in the placement group before you can delete the placement group. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DeleteQueuedReservedInstances' => '<p>Deletes the queued purchases for the specified Reserved Instances.</p>', 'DeleteRoute' => '<p>Deletes the specified route from the specified route table.</p>', 'DeleteRouteTable' => '<p>Deletes the specified route table. You must disassociate the route table from any subnets before you can delete it. You can\'t delete the main route table.</p>', 'DeleteSecurityGroup' => '<p>Deletes a security group.</p> <p>If you attempt to delete a security group that is associated with an instance, or is referenced by another security group, the operation fails with <code>InvalidGroup.InUse</code> in EC2-Classic or <code>DependencyViolation</code> in EC2-VPC.</p>', 'DeleteSnapshot' => '<p>Deletes the specified snapshot.</p> <p>When you make periodic snapshots of a volume, the snapshots are incremental, and only the blocks on the device that have changed since your last snapshot are saved in the new snapshot. When you delete a snapshot, only the data not needed for any other snapshot is removed. So regardless of which prior snapshots have been deleted, all active snapshots will have access to all the information needed to restore the volume.</p> <p>You cannot delete a snapshot of the root device of an EBS volume used by a registered AMI. You must first de-register the AMI before you can delete the snapshot.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-snapshot.html">Deleting an Amazon EBS Snapshot</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DeleteSpotDatafeedSubscription' => '<p>Deletes the data feed for Spot Instances.</p>', 'DeleteSubnet' => '<p>Deletes the specified subnet. You must terminate all running instances in the subnet before you can delete the subnet.</p>', 'DeleteTags' => '<p>Deletes the specified set of tags from the specified set of resources.</p> <p>To list the current tags, use <a>DescribeTags</a>. For more information about tags, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Resources</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DeleteTrafficMirrorFilter' => '<p>Deletes the specified Traffic Mirror filter.</p> <p>You cannot delete a Traffic Mirror filter that is in use by a Traffic Mirror session.</p>', 'DeleteTrafficMirrorFilterRule' => '<p>Deletes the specified Traffic Mirror rule.</p>', 'DeleteTrafficMirrorSession' => '<p>Deletes the specified Traffic Mirror session.</p>', 'DeleteTrafficMirrorTarget' => '<p>Deletes the specified Traffic Mirror target.</p> <p>You cannot delete a Traffic Mirror target that is in use by a Traffic Mirror session.</p>', 'DeleteTransitGateway' => '<p>Deletes the specified transit gateway.</p>', 'DeleteTransitGatewayMulticastDomain' => '<p>Deletes the specified transit gateway multicast domain.</p>', 'DeleteTransitGatewayPeeringAttachment' => '<p>Deletes a transit gateway peering attachment.</p>', 'DeleteTransitGatewayRoute' => '<p>Deletes the specified route from the specified transit gateway route table.</p>', 'DeleteTransitGatewayRouteTable' => '<p>Deletes the specified transit gateway route table. You must disassociate the route table from any transit gateway route tables before you can delete it.</p>', 'DeleteTransitGatewayVpcAttachment' => '<p>Deletes the specified VPC attachment.</p>', 'DeleteVolume' => '<p>Deletes the specified EBS volume. The volume must be in the <code>available</code> state (not attached to an instance).</p> <p>The volume can remain in the <code>deleting</code> state for several minutes.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-volume.html">Deleting an Amazon EBS Volume</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DeleteVpc' => '<p>Deletes the specified VPC. You must detach or delete all gateways and resources that are associated with the VPC before you can delete it. For example, you must terminate all instances running in the VPC, delete all security groups associated with the VPC (except the default one), delete all route tables associated with the VPC (except the default one), and so on.</p>', 'DeleteVpcEndpointConnectionNotifications' => '<p>Deletes one or more VPC endpoint connection notifications.</p>', 'DeleteVpcEndpointServiceConfigurations' => '<p>Deletes one or more VPC endpoint service configurations in your account. Before you delete the endpoint service configuration, you must reject any <code>Available</code> or <code>PendingAcceptance</code> interface endpoint connections that are attached to the service.</p>', 'DeleteVpcEndpoints' => '<p>Deletes one or more specified VPC endpoints. Deleting a gateway endpoint also deletes the endpoint routes in the route tables that were associated with the endpoint. Deleting an interface endpoint deletes the endpoint network interfaces.</p>', 'DeleteVpcPeeringConnection' => '<p>Deletes a VPC peering connection. Either the owner of the requester VPC or the owner of the accepter VPC can delete the VPC peering connection if it\'s in the <code>active</code> state. The owner of the requester VPC can delete a VPC peering connection in the <code>pending-acceptance</code> state. You cannot delete a VPC peering connection that\'s in the <code>failed</code> state.</p>', 'DeleteVpnConnection' => '<p>Deletes the specified VPN connection.</p> <p>If you\'re deleting the VPC and its associated components, we recommend that you detach the virtual private gateway from the VPC and delete the VPC before deleting the VPN connection. If you believe that the tunnel credentials for your VPN connection have been compromised, you can delete the VPN connection and create a new one that has new keys, without needing to delete the VPC or virtual private gateway. If you create a new VPN connection, you must reconfigure the customer gateway device using the new configuration information returned with the new VPN connection ID.</p> <p>For certificate-based authentication, delete all AWS Certificate Manager (ACM) private certificates used for the AWS-side tunnel endpoints for the VPN connection before deleting the VPN connection.</p>', 'DeleteVpnConnectionRoute' => '<p>Deletes the specified static route associated with a VPN connection between an existing virtual private gateway and a VPN customer gateway. The static route allows traffic to be routed from the virtual private gateway to the VPN customer gateway.</p>', 'DeleteVpnGateway' => '<p>Deletes the specified virtual private gateway. You must first detach the virtual private gateway from the VPC. Note that you don\'t need to delete the virtual private gateway if you plan to delete and recreate the VPN connection between your VPC and your network.</p>', 'DeprovisionByoipCidr' => '<p>Releases the specified address range that you provisioned for use with your AWS resources through bring your own IP addresses (BYOIP) and deletes the corresponding address pool.</p> <p>Before you can release an address range, you must stop advertising it using <a>WithdrawByoipCidr</a> and you must not have any IP addresses allocated from its address range.</p>', 'DeregisterImage' => '<p>Deregisters the specified AMI. After you deregister an AMI, it can\'t be used to launch new instances; however, it doesn\'t affect any instances that you\'ve already launched from the AMI. You\'ll continue to incur usage costs for those instances until you terminate them.</p> <p>When you deregister an Amazon EBS-backed AMI, it doesn\'t affect the snapshot that was created for the root volume of the instance during the AMI creation process. When you deregister an instance store-backed AMI, it doesn\'t affect the files that you uploaded to Amazon S3 when you created the AMI.</p>', 'DeregisterInstanceEventNotificationAttributes' => '<p>Deregisters tag keys to prevent tags that have the specified tag keys from being included in scheduled event notifications for resources in the Region.</p>', 'DeregisterTransitGatewayMulticastGroupMembers' => '<p>Deregisters the specified members (network interfaces) from the transit gateway multicast group.</p>', 'DeregisterTransitGatewayMulticastGroupSources' => '<p>Deregisters the specified sources (network interfaces) from the transit gateway multicast group.</p>', 'DescribeAccountAttributes' => '<p>Describes attributes of your AWS account. The following are the supported account attributes:</p> <ul> <li> <p> <code>supported-platforms</code>: Indicates whether your account can launch instances into EC2-Classic and EC2-VPC, or only into EC2-VPC.</p> </li> <li> <p> <code>default-vpc</code>: The ID of the default VPC for your account, or <code>none</code>.</p> </li> <li> <p> <code>max-instances</code>: This attribute is no longer supported. The returned value does not reflect your actual vCPU limit for running On-Demand Instances. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-on-demand-instances.html#ec2-on-demand-instances-limits">On-Demand Instance Limits</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> </li> <li> <p> <code>vpc-max-security-groups-per-interface</code>: The maximum number of security groups that you can assign to a network interface.</p> </li> <li> <p> <code>max-elastic-ips</code>: The maximum number of Elastic IP addresses that you can allocate for use with EC2-Classic. </p> </li> <li> <p> <code>vpc-max-elastic-ips</code>: The maximum number of Elastic IP addresses that you can allocate for use with EC2-VPC.</p> </li> </ul>', 'DescribeAddresses' => '<p>Describes the specified Elastic IP addresses or all of your Elastic IP addresses.</p> <p>An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DescribeAggregateIdFormat' => '<p>Describes the longer ID format settings for all resource types in a specific Region. This request is useful for performing a quick audit to determine whether a specific Region is fully opted in for longer IDs (17-character IDs).</p> <p>This request only returns information about resource types that support longer IDs.</p> <p>The following resource types support longer IDs: <code>bundle</code> | <code>conversion-task</code> | <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> | <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> | <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code> | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> | <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code> | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> | <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> | <code>vpn-connection</code> | <code>vpn-gateway</code>.</p>', 'DescribeAvailabilityZones' => '<p>Describes the Availability Zones, Local Zones, and Wavelength Zones that are available to you. If there is an event impacting a zone, you can use this request to view the state and any provided messages for that zone.</p> <p>For more information about Availability Zones, Local Zones, and Wavelength Zones, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html">Regions, Zones and Outposts</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DescribeBundleTasks' => '<p>Describes the specified bundle tasks or all of your bundle tasks.</p> <note> <p>Completed bundle tasks are listed for only a limited time. If your bundle task is no longer in the list, you can still register an AMI from it. Just use <code>RegisterImage</code> with the Amazon S3 bucket name and image manifest name you provided to the bundle task.</p> </note>', 'DescribeByoipCidrs' => '<p>Describes the IP address ranges that were specified in calls to <a>ProvisionByoipCidr</a>.</p> <p>To describe the address pools that were created when you provisioned the address ranges, use <a>DescribePublicIpv4Pools</a> or <a>DescribeIpv6Pools</a>.</p>', 'DescribeCapacityReservations' => '<p>Describes one or more of your Capacity Reservations. The results describe only the Capacity Reservations in the AWS Region that you\'re currently using.</p>', 'DescribeCarrierGateways' => '<p>Describes one or more of your carrier gateways.</p>', 'DescribeClassicLinkInstances' => '<p>Describes one or more of your linked EC2-Classic instances. This request only returns information about EC2-Classic instances linked to a VPC through ClassicLink. You cannot use this request to return information about other instances.</p>', 'DescribeClientVpnAuthorizationRules' => '<p>Describes the authorization rules for a specified Client VPN endpoint.</p>', 'DescribeClientVpnConnections' => '<p>Describes active client connections and connections that have been terminated within the last 60 minutes for the specified Client VPN endpoint.</p>', 'DescribeClientVpnEndpoints' => '<p>Describes one or more Client VPN endpoints in the account.</p>', 'DescribeClientVpnRoutes' => '<p>Describes the routes for the specified Client VPN endpoint.</p>', 'DescribeClientVpnTargetNetworks' => '<p>Describes the target networks associated with the specified Client VPN endpoint.</p>', 'DescribeCoipPools' => '<p>Describes the specified customer-owned address pools or all of your customer-owned address pools.</p>', 'DescribeConversionTasks' => '<p>Describes the specified conversion tasks or all your conversion tasks. For more information, see the <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/">VM Import/Export User Guide</a>.</p> <p>For information about the import manifest referenced by this API action, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest</a>.</p>', 'DescribeCustomerGateways' => '<p>Describes one or more of your VPN customer gateways.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">AWS Site-to-Site VPN</a> in the <i>AWS Site-to-Site VPN User Guide</i>.</p>', 'DescribeDhcpOptions' => '<p>Describes one or more of your DHCP options sets.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP Options Sets</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'DescribeEgressOnlyInternetGateways' => '<p>Describes one or more of your egress-only internet gateways.</p>', 'DescribeElasticGpus' => '<p>Describes the Elastic Graphics accelerator associated with your instances. For more information about Elastic Graphics, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html">Amazon Elastic Graphics</a>.</p>', 'DescribeExportImageTasks' => '<p>Describes the specified export image tasks or all of your export image tasks.</p>', 'DescribeExportTasks' => '<p>Describes the specified export instance tasks or all of your export instance tasks.</p>', 'DescribeFastSnapshotRestores' => '<p>Describes the state of fast snapshot restores for your snapshots.</p>', 'DescribeFleetHistory' => '<p>Describes the events for the specified EC2 Fleet during the specified time.</p> <p>EC2 Fleet events are delayed by up to 30 seconds before they can be described. This ensures that you can query by the last evaluated time and not miss a recorded event. EC2 Fleet events are available for 48 hours.</p>', 'DescribeFleetInstances' => '<p>Describes the running instances for the specified EC2 Fleet.</p>', 'DescribeFleets' => '<p>Describes the specified EC2 Fleets or all of your EC2 Fleets.</p>', 'DescribeFlowLogs' => '<p>Describes one or more flow logs. To view the information in your flow logs (the log streams for the network interfaces), you must use the CloudWatch Logs console or the CloudWatch Logs API.</p>', 'DescribeFpgaImageAttribute' => '<p>Describes the specified attribute of the specified Amazon FPGA Image (AFI).</p>', 'DescribeFpgaImages' => '<p>Describes the Amazon FPGA Images (AFIs) available to you. These include public AFIs, private AFIs that you own, and AFIs owned by other AWS accounts for which you have load permissions.</p>', 'DescribeHostReservationOfferings' => '<p>Describes the Dedicated Host reservations that are available to purchase.</p> <p>The results describe all of the Dedicated Host reservation offerings, including offerings that might not match the instance family and Region of your Dedicated Hosts. When purchasing an offering, ensure that the instance family and Region of the offering matches that of the Dedicated Hosts with which it is to be associated. For more information about supported instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html">Dedicated Hosts Overview</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. </p>', 'DescribeHostReservations' => '<p>Describes reservations that are associated with Dedicated Hosts in your account.</p>', 'DescribeHosts' => '<p>Describes the specified Dedicated Hosts or all your Dedicated Hosts.</p> <p>The results describe only the Dedicated Hosts in the Region you\'re currently using. All listed instances consume capacity on your Dedicated Host. Dedicated Hosts that have recently been released are listed with the state <code>released</code>.</p>', 'DescribeIamInstanceProfileAssociations' => '<p>Describes your IAM instance profile associations.</p>', 'DescribeIdFormat' => '<p>Describes the ID format settings for your resources on a per-Region basis, for example, to view which resource types are enabled for longer IDs. This request only returns information about resource types whose ID formats can be modified; it does not return information about other resource types.</p> <p>The following resource types support longer IDs: <code>bundle</code> | <code>conversion-task</code> | <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> | <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> | <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code> | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> | <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code> | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> | <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> | <code>vpn-connection</code> | <code>vpn-gateway</code>. </p> <p>These settings apply to the IAM user who makes the request; they do not apply to the entire AWS account. By default, an IAM user defaults to the same settings as the root user, unless they explicitly override the settings by running the <a>ModifyIdFormat</a> command. Resources created with longer IDs are visible to all IAM users, regardless of these settings and provided that they have permission to use the relevant <code>Describe</code> command for the resource type.</p>', 'DescribeIdentityIdFormat' => '<p>Describes the ID format settings for resources for the specified IAM user, IAM role, or root user. For example, you can view the resource types that are enabled for longer IDs. This request only returns information about resource types whose ID formats can be modified; it does not return information about other resource types. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html">Resource IDs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. </p> <p>The following resource types support longer IDs: <code>bundle</code> | <code>conversion-task</code> | <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> | <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> | <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code> | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> | <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code> | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> | <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> | <code>vpn-connection</code> | <code>vpn-gateway</code>. </p> <p>These settings apply to the principal specified in the request. They do not apply to the principal that makes the request.</p>', 'DescribeImageAttribute' => '<p>Describes the specified attribute of the specified AMI. You can specify only one attribute at a time.</p>', 'DescribeImages' => '<p>Describes the specified images (AMIs, AKIs, and ARIs) available to you or all of the images available to you.</p> <p>The images available to you include public images, private images that you own, and private images owned by other AWS accounts for which you have explicit launch permissions.</p> <p>Recently deregistered images appear in the returned results for a short interval and then return empty results. After all instances that reference a deregistered AMI are terminated, specifying the ID of the image results in an error indicating that the AMI ID cannot be found.</p>', 'DescribeImportImageTasks' => '<p>Displays details about an import virtual machine or import snapshot tasks that are already created.</p>', 'DescribeImportSnapshotTasks' => '<p>Describes your import snapshot tasks.</p>', 'DescribeInstanceAttribute' => '<p>Describes the specified attribute of the specified instance. You can specify only one attribute at a time. Valid attribute values are: <code>instanceType</code> | <code>kernel</code> | <code>ramdisk</code> | <code>userData</code> | <code>disableApiTermination</code> | <code>instanceInitiatedShutdownBehavior</code> | <code>rootDeviceName</code> | <code>blockDeviceMapping</code> | <code>productCodes</code> | <code>sourceDestCheck</code> | <code>groupSet</code> | <code>ebsOptimized</code> | <code>sriovNetSupport</code> </p>', 'DescribeInstanceCreditSpecifications' => '<p>Describes the credit option for CPU usage of the specified burstable performance instances. The credit options are <code>standard</code> and <code>unlimited</code>.</p> <p>If you do not specify an instance ID, Amazon EC2 returns burstable performance instances with the <code>unlimited</code> credit option, as well as instances that were previously configured as T2, T3, and T3a with the <code>unlimited</code> credit option. For example, if you resize a T2 instance, while it is configured as <code>unlimited</code>, to an M4 instance, Amazon EC2 returns the M4 instance.</p> <p>If you specify one or more instance IDs, Amazon EC2 returns the credit option (<code>standard</code> or <code>unlimited</code>) of those instances. If you specify an instance ID that is not valid, such as an instance that is not a burstable performance instance, an error is returned.</p> <p>Recently terminated instances might appear in the returned results. This interval is usually less than one hour.</p> <p>If an Availability Zone is experiencing a service disruption and you specify instance IDs in the affected zone, or do not specify any instance IDs at all, the call fails. If you specify only instance IDs in an unaffected zone, the call works normally.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DescribeInstanceEventNotificationAttributes' => '<p>Describes the tag keys that are registered to appear in scheduled event notifications for resources in the current Region.</p>', 'DescribeInstanceStatus' => '<p>Describes the status of the specified instances or all of your instances. By default, only running instances are described, unless you specifically indicate to return the status of all instances.</p> <p>Instance status includes the following components:</p> <ul> <li> <p> <b>Status checks</b> - Amazon EC2 performs status checks on running EC2 instances to identify hardware and software issues. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-system-instance-status-check.html">Status checks for your instances</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstances.html">Troubleshooting instances with failed status checks</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> </li> <li> <p> <b>Scheduled events</b> - Amazon EC2 can schedule events (such as reboot, stop, or terminate) for your instances related to hardware issues, software updates, or system maintenance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-instances-status-check_sched.html">Scheduled events for your instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> </li> <li> <p> <b>Instance state</b> - You can manage your instances from the moment you launch them through their termination. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html">Instance lifecycle</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> </li> </ul>', 'DescribeInstanceTypeOfferings' => '<p>Returns a list of all instance types offered. The results can be filtered by location (Region or Availability Zone). If no location is specified, the instance types offered in the current Region are returned.</p>', 'DescribeInstanceTypes' => '<p>Describes the details of the instance types that are offered in a location. The results can be filtered by the attributes of the instance types.</p>', 'DescribeInstances' => '<p>Describes the specified instances or all instances.</p> <p>If you specify instance IDs, the output includes information for only the specified instances. If you specify filters, the output includes information for only those instances that meet the filter criteria. If you do not specify instance IDs or filters, the output includes information for all instances, which can affect performance. We recommend that you use pagination to ensure that the operation returns quickly and successfully.</p> <p>If you specify an instance ID that is not valid, an error is returned. If you specify an instance that you do not own, it is not included in the output.</p> <p>Recently terminated instances might appear in the returned results. This interval is usually less than one hour.</p> <p>If you describe instances in the rare case where an Availability Zone is experiencing a service disruption and you specify instance IDs that are in the affected zone, or do not specify any instance IDs at all, the call fails. If you describe instances and specify only instance IDs that are in an unaffected zone, the call works normally.</p>', 'DescribeInternetGateways' => '<p>Describes one or more of your internet gateways.</p>', 'DescribeIpv6Pools' => '<p>Describes your IPv6 address pools.</p>', 'DescribeKeyPairs' => '<p>Describes the specified key pairs or all of your key pairs.</p> <p>For more information about key pairs, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Key Pairs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DescribeLaunchTemplateVersions' => '<p>Describes one or more versions of a specified launch template. You can describe all versions, individual versions, or a range of versions. You can also describe all the latest versions or all the default versions of all the launch templates in your account.</p>', 'DescribeLaunchTemplates' => '<p>Describes one or more launch templates.</p>', 'DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations' => '<p>Describes the associations between virtual interface groups and local gateway route tables.</p>', 'DescribeLocalGatewayRouteTableVpcAssociations' => '<p>Describes the specified associations between VPCs and local gateway route tables.</p>', 'DescribeLocalGatewayRouteTables' => '<p>Describes one or more local gateway route tables. By default, all local gateway route tables are described. Alternatively, you can filter the results.</p>', 'DescribeLocalGatewayVirtualInterfaceGroups' => '<p>Describes the specified local gateway virtual interface groups.</p>', 'DescribeLocalGatewayVirtualInterfaces' => '<p>Describes the specified local gateway virtual interfaces.</p>', 'DescribeLocalGateways' => '<p>Describes one or more local gateways. By default, all local gateways are described. Alternatively, you can filter the results.</p>', 'DescribeManagedPrefixLists' => '<p>Describes your managed prefix lists and any AWS-managed prefix lists.</p> <p>To view the entries for your prefix list, use <a>GetManagedPrefixListEntries</a>.</p>', 'DescribeMovingAddresses' => '<p>Describes your Elastic IP addresses that are being moved to the EC2-VPC platform, or that are being restored to the EC2-Classic platform. This request does not return information about any other Elastic IP addresses in your account.</p>', 'DescribeNatGateways' => '<p>Describes one or more of your NAT gateways.</p>', 'DescribeNetworkAcls' => '<p>Describes one or more of your network ACLs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network ACLs</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'DescribeNetworkInterfaceAttribute' => '<p>Describes a network interface attribute. You can specify only one attribute at a time.</p>', 'DescribeNetworkInterfacePermissions' => '<p>Describes the permissions for your network interfaces. </p>', 'DescribeNetworkInterfaces' => '<p>Describes one or more of your network interfaces.</p>', 'DescribePlacementGroups' => '<p>Describes the specified placement groups or all of your placement groups. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DescribePrefixLists' => '<p>Describes available AWS services in a prefix list format, which includes the prefix list name and prefix list ID of the service and the IP address range for the service.</p> <p>We recommend that you use <a>DescribeManagedPrefixLists</a> instead.</p>', 'DescribePrincipalIdFormat' => '<p>Describes the ID format settings for the root user and all IAM roles and IAM users that have explicitly specified a longer ID (17-character ID) preference. </p> <p>By default, all IAM roles and IAM users default to the same ID settings as the root user, unless they explicitly override the settings. This request is useful for identifying those IAM users and IAM roles that have overridden the default ID settings.</p> <p>The following resource types support longer IDs: <code>bundle</code> | <code>conversion-task</code> | <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> | <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> | <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code> | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> | <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code> | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> | <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> | <code>vpn-connection</code> | <code>vpn-gateway</code>. </p>', 'DescribePublicIpv4Pools' => '<p>Describes the specified IPv4 address pools.</p>', 'DescribeRegions' => '<p>Describes the Regions that are enabled for your account, or all Regions.</p> <p>For a list of the Regions supported by Amazon EC2, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#ec2_region"> Regions and Endpoints</a>.</p> <p>For information about enabling and disabling Regions for your account, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html">Managing AWS Regions</a> in the <i>AWS General Reference</i>.</p>', 'DescribeReservedInstances' => '<p>Describes one or more of the Reserved Instances that you purchased.</p> <p>For more information about Reserved Instances, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/concepts-on-demand-reserved-instances.html">Reserved Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DescribeReservedInstancesListings' => '<p>Describes your account\'s Reserved Instance listings in the Reserved Instance Marketplace.</p> <p>The Reserved Instance Marketplace matches sellers who want to resell Reserved Instance capacity that they no longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold through the Reserved Instance Marketplace work like any other Reserved Instances.</p> <p>As a seller, you choose to list some or all of your Reserved Instances, and you specify the upfront price to receive for them. Your Reserved Instances are then listed in the Reserved Instance Marketplace and are available for purchase.</p> <p>As a buyer, you specify the configuration of the Reserved Instance to purchase, and the Marketplace matches what you\'re searching for with what\'s available. The Marketplace first sells the lowest priced Reserved Instances to you, and continues to sell available Reserved Instance listings to you until your demand is met. You are charged based on the total price of all of the listings that you purchase.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance Marketplace</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DescribeReservedInstancesModifications' => '<p>Describes the modifications made to your Reserved Instances. If no parameter is specified, information about all your Reserved Instances modification requests is returned. If a modification ID is specified, only information about the specific modification is returned.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html">Modifying Reserved Instances</a> in the Amazon Elastic Compute Cloud User Guide.</p>', 'DescribeReservedInstancesOfferings' => '<p>Describes Reserved Instance offerings that are available for purchase. With Reserved Instances, you purchase the right to launch instances for a period of time. During that time period, you do not receive insufficient capacity errors, and you pay a lower usage rate than the rate charged for On-Demand instances for the actual time used.</p> <p>If you have listed your own Reserved Instances for sale in the Reserved Instance Marketplace, they will be excluded from these results. This is to ensure that you do not purchase your own Reserved Instances.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance Marketplace</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DescribeRouteTables' => '<p>Describes one or more of your route tables.</p> <p>Each subnet in your VPC must be associated with a route table. If a subnet is not explicitly associated with any route table, it is implicitly associated with the main route table. This command does not return the subnet ID for implicit associations.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route Tables</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'DescribeScheduledInstanceAvailability' => '<p>Finds available schedules that meet the specified criteria.</p> <p>You can search for an available schedule no more than 3 months in advance. You must meet the minimum required duration of 1,200 hours per year. For example, the minimum daily schedule is 4 hours, the minimum weekly schedule is 24 hours, and the minimum monthly schedule is 100 hours.</p> <p>After you find a schedule that meets your needs, call <a>PurchaseScheduledInstances</a> to purchase Scheduled Instances with that schedule.</p>', 'DescribeScheduledInstances' => '<p>Describes the specified Scheduled Instances or all your Scheduled Instances.</p>', 'DescribeSecurityGroupReferences' => '<p>[VPC only] Describes the VPCs on the other side of a VPC peering connection that are referencing the security groups you\'ve specified in this request.</p>', 'DescribeSecurityGroups' => '<p>Describes the specified security groups or all of your security groups.</p> <p>A security group is for use with instances either in the EC2-Classic platform or in a specific VPC. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2 Security Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i> and <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'DescribeSnapshotAttribute' => '<p>Describes the specified attribute of the specified snapshot. You can specify only one attribute at a time.</p> <p>For more information about EBS snapshots, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html">Amazon EBS Snapshots</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DescribeSnapshots' => '<p>Describes the specified EBS snapshots available to you or all of the EBS snapshots available to you.</p> <p>The snapshots available to you include public snapshots, private snapshots that you own, and private snapshots owned by other AWS accounts for which you have explicit create volume permissions.</p> <p>The create volume permissions fall into the following categories:</p> <ul> <li> <p> <i>public</i>: The owner of the snapshot granted create volume permissions for the snapshot to the <code>all</code> group. All AWS accounts have create volume permissions for these snapshots.</p> </li> <li> <p> <i>explicit</i>: The owner of the snapshot granted create volume permissions to a specific AWS account.</p> </li> <li> <p> <i>implicit</i>: An AWS account has implicit create volume permissions for all snapshots it owns.</p> </li> </ul> <p>The list of snapshots returned can be filtered by specifying snapshot IDs, snapshot owners, or AWS accounts with create volume permissions. If no options are specified, Amazon EC2 returns all snapshots for which you have create volume permissions.</p> <p>If you specify one or more snapshot IDs, only snapshots that have the specified IDs are returned. If you specify an invalid snapshot ID, an error is returned. If you specify a snapshot ID for which you do not have access, it is not included in the returned results.</p> <p>If you specify one or more snapshot owners using the <code>OwnerIds</code> option, only snapshots from the specified owners and for which you have access are returned. The results can include the AWS account IDs of the specified owners, <code>amazon</code> for snapshots owned by Amazon, or <code>self</code> for snapshots that you own.</p> <p>If you specify a list of restorable users, only snapshots with create snapshot permissions for those users are returned. You can specify AWS account IDs (if you own the snapshots), <code>self</code> for snapshots for which you own or have explicit permissions, or <code>all</code> for public snapshots.</p> <p>If you are describing a long list of snapshots, we recommend that you paginate the output to make the list more manageable. The <code>MaxResults</code> parameter sets the maximum number of results returned in a single page. If the list of results exceeds your <code>MaxResults</code> value, then that number of results is returned along with a <code>NextToken</code> value that can be passed to a subsequent <code>DescribeSnapshots</code> request to retrieve the remaining results.</p> <p>To get the state of fast snapshot restores for a snapshot, use <a>DescribeFastSnapshotRestores</a>.</p> <p>For more information about EBS snapshots, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html">Amazon EBS Snapshots</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DescribeSpotDatafeedSubscription' => '<p>Describes the data feed for Spot Instances. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html">Spot Instance data feed</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>', 'DescribeSpotFleetInstances' => '<p>Describes the running instances for the specified Spot Fleet.</p>', 'DescribeSpotFleetRequestHistory' => '<p>Describes the events for the specified Spot Fleet request during the specified time.</p> <p>Spot Fleet events are delayed by up to 30 seconds before they can be described. This ensures that you can query by the last evaluated time and not miss a recorded event. Spot Fleet events are available for 48 hours.</p>', 'DescribeSpotFleetRequests' => '<p>Describes your Spot Fleet requests.</p> <p>Spot Fleet requests are deleted 48 hours after they are canceled and their instances are terminated.</p>', 'DescribeSpotInstanceRequests' => '<p>Describes the specified Spot Instance requests.</p> <p>You can use <code>DescribeSpotInstanceRequests</code> to find a running Spot Instance by examining the response. If the status of the Spot Instance is <code>fulfilled</code>, the instance ID appears in the response and contains the identifier of the instance. Alternatively, you can use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances">DescribeInstances</a> with a filter to look for instances where the instance lifecycle is <code>spot</code>.</p> <p>We recommend that you set <code>MaxResults</code> to a value between 5 and 1000 to limit the number of results returned. This paginates the output, which makes the list more manageable and returns the results faster. If the list of results exceeds your <code>MaxResults</code> value, then that number of results is returned along with a <code>NextToken</code> value that can be passed to a subsequent <code>DescribeSpotInstanceRequests</code> request to retrieve the remaining results.</p> <p>Spot Instance requests are deleted four hours after they are canceled and their instances are terminated.</p>', 'DescribeSpotPriceHistory' => '<p>Describes the Spot price history. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-spot-instances-history.html">Spot Instance pricing history</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p> <p>When you specify a start and end time, this operation returns the prices of the instance types within the time range that you specified and the time when the price changed. The price is valid within the time period that you specified; the response merely indicates the last time that the price changed.</p>', 'DescribeStaleSecurityGroups' => '<p>[VPC only] Describes the stale security group rules for security groups in a specified VPC. Rules are stale when they reference a deleted security group in a peer VPC, or a security group in a peer VPC for which the VPC peering connection has been deleted.</p>', 'DescribeSubnets' => '<p>Describes one or more of your subnets.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Your VPC and Subnets</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'DescribeTags' => '<p>Describes the specified tags for your EC2 resources.</p> <p>For more information about tags, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Resources</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DescribeTrafficMirrorFilters' => '<p>Describes one or more Traffic Mirror filters.</p>', 'DescribeTrafficMirrorSessions' => '<p>Describes one or more Traffic Mirror sessions. By default, all Traffic Mirror sessions are described. Alternatively, you can filter the results.</p>', 'DescribeTrafficMirrorTargets' => '<p>Information about one or more Traffic Mirror targets.</p>', 'DescribeTransitGatewayAttachments' => '<p>Describes one or more attachments between resources and transit gateways. By default, all attachments are described. Alternatively, you can filter the results by attachment ID, attachment state, resource ID, or resource owner.</p>', 'DescribeTransitGatewayMulticastDomains' => '<p>Describes one or more transit gateway multicast domains.</p>', 'DescribeTransitGatewayPeeringAttachments' => '<p>Describes your transit gateway peering attachments.</p>', 'DescribeTransitGatewayRouteTables' => '<p>Describes one or more transit gateway route tables. By default, all transit gateway route tables are described. Alternatively, you can filter the results.</p>', 'DescribeTransitGatewayVpcAttachments' => '<p>Describes one or more VPC attachments. By default, all VPC attachments are described. Alternatively, you can filter the results.</p>', 'DescribeTransitGateways' => '<p>Describes one or more transit gateways. By default, all transit gateways are described. Alternatively, you can filter the results.</p>', 'DescribeVolumeAttribute' => '<p>Describes the specified attribute of the specified volume. You can specify only one attribute at a time.</p> <p>For more information about EBS volumes, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumes.html">Amazon EBS Volumes</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DescribeVolumeStatus' => '<p>Describes the status of the specified volumes. Volume status provides the result of the checks performed on your volumes to determine events that can impair the performance of your volumes. The performance of a volume can be affected if an issue occurs on the volume\'s underlying host. If the volume\'s underlying host experiences a power outage or system issue, after the system is restored, there could be data inconsistencies on the volume. Volume events notify you if this occurs. Volume actions notify you if any action needs to be taken in response to the event.</p> <p>The <code>DescribeVolumeStatus</code> operation provides the following information about the specified volumes:</p> <p> <i>Status</i>: Reflects the current status of the volume. The possible values are <code>ok</code>, <code>impaired</code> , <code>warning</code>, or <code>insufficient-data</code>. If all checks pass, the overall status of the volume is <code>ok</code>. If the check fails, the overall status is <code>impaired</code>. If the status is <code>insufficient-data</code>, then the checks may still be taking place on your volume at the time. We recommend that you retry the request. For more information about volume status, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-volume-status.html">Monitoring the Status of Your Volumes</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p> <i>Events</i>: Reflect the cause of a volume status and may require you to take action. For example, if your volume returns an <code>impaired</code> status, then the volume event might be <code>potential-data-inconsistency</code>. This means that your volume has been affected by an issue with the underlying host, has all I/O operations disabled, and may have inconsistent data.</p> <p> <i>Actions</i>: Reflect the actions you may have to take in response to an event. For example, if the status of the volume is <code>impaired</code> and the volume event shows <code>potential-data-inconsistency</code>, then the action shows <code>enable-volume-io</code>. This means that you may want to enable the I/O operations for the volume by calling the <a>EnableVolumeIO</a> action and then check the volume for data consistency.</p> <p>Volume status is based on the volume status checks, and does not reflect the volume state. Therefore, volume status does not indicate volumes in the <code>error</code> state (for example, when a volume is incapable of accepting I/O.)</p>', 'DescribeVolumes' => '<p>Describes the specified EBS volumes or all of your EBS volumes.</p> <p>If you are describing a long list of volumes, we recommend that you paginate the output to make the list more manageable. The <code>MaxResults</code> parameter sets the maximum number of results returned in a single page. If the list of results exceeds your <code>MaxResults</code> value, then that number of results is returned along with a <code>NextToken</code> value that can be passed to a subsequent <code>DescribeVolumes</code> request to retrieve the remaining results.</p> <p>For more information about EBS volumes, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumes.html">Amazon EBS Volumes</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DescribeVolumesModifications' => '<p>Describes the most recent volume modification request for the specified EBS volumes.</p> <p>If a volume has never been modified, some information in the output will be null. If a volume has been modified more than once, the output includes only the most recent modification request.</p> <p>You can also use CloudWatch Events to check the status of a modification to an EBS volume. For information about CloudWatch Events, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/">Amazon CloudWatch Events User Guide</a>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-expand-volume.html#monitoring_mods">Monitoring Volume Modifications</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DescribeVpcAttribute' => '<p>Describes the specified attribute of the specified VPC. You can specify only one attribute at a time.</p>', 'DescribeVpcClassicLink' => '<p>Describes the ClassicLink status of one or more VPCs.</p>', 'DescribeVpcClassicLinkDnsSupport' => '<p>Describes the ClassicLink DNS support status of one or more VPCs. If enabled, the DNS hostname of a linked EC2-Classic instance resolves to its private IP address when addressed from an instance in the VPC to which it\'s linked. Similarly, the DNS hostname of an instance in a VPC resolves to its private IP address when addressed from a linked EC2-Classic instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DescribeVpcEndpointConnectionNotifications' => '<p>Describes the connection notifications for VPC endpoints and VPC endpoint services.</p>', 'DescribeVpcEndpointConnections' => '<p>Describes the VPC endpoint connections to your VPC endpoint services, including any endpoints that are pending your acceptance.</p>', 'DescribeVpcEndpointServiceConfigurations' => '<p>Describes the VPC endpoint service configurations in your account (your services).</p>', 'DescribeVpcEndpointServicePermissions' => '<p>Describes the principals (service consumers) that are permitted to discover your VPC endpoint service.</p>', 'DescribeVpcEndpointServices' => '<p>Describes available services to which you can create a VPC endpoint.</p>', 'DescribeVpcEndpoints' => '<p>Describes one or more of your VPC endpoints.</p>', 'DescribeVpcPeeringConnections' => '<p>Describes one or more of your VPC peering connections.</p>', 'DescribeVpcs' => '<p>Describes one or more of your VPCs.</p>', 'DescribeVpnConnections' => '<p>Describes one or more of your VPN connections.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">AWS Site-to-Site VPN</a> in the <i>AWS Site-to-Site VPN User Guide</i>.</p>', 'DescribeVpnGateways' => '<p>Describes one or more of your virtual private gateways.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">AWS Site-to-Site VPN</a> in the <i>AWS Site-to-Site VPN User Guide</i>.</p>', 'DetachClassicLinkVpc' => '<p>Unlinks (detaches) a linked EC2-Classic instance from a VPC. After the instance has been unlinked, the VPC security groups are no longer associated with it. An instance is automatically unlinked from a VPC when it\'s stopped.</p>', 'DetachInternetGateway' => '<p>Detaches an internet gateway from a VPC, disabling connectivity between the internet and the VPC. The VPC must not contain any running instances with Elastic IP addresses or public IPv4 addresses.</p>', 'DetachNetworkInterface' => '<p>Detaches a network interface from an instance.</p>', 'DetachVolume' => '<p>Detaches an EBS volume from an instance. Make sure to unmount any file systems on the device within your operating system before detaching the volume. Failure to do so can result in the volume becoming stuck in the <code>busy</code> state while detaching. If this happens, detachment can be delayed indefinitely until you unmount the volume, force detachment, reboot the instance, or all three. If an EBS volume is the root device of an instance, it can\'t be detached while the instance is running. To detach the root volume, stop the instance first.</p> <p>When a volume with an AWS Marketplace product code is detached from an instance, the product code is no longer associated with the instance.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-detaching-volume.html">Detaching an Amazon EBS Volume</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DetachVpnGateway' => '<p>Detaches a virtual private gateway from a VPC. You do this if you\'re planning to turn off the VPC and not use it anymore. You can confirm a virtual private gateway has been completely detached from a VPC by describing the virtual private gateway (any attachments to the virtual private gateway are also described).</p> <p>You must wait for the attachment\'s state to switch to <code>detached</code> before you can delete the VPC or attach a different VPC to the virtual private gateway.</p>', 'DisableEbsEncryptionByDefault' => '<p>Disables EBS encryption by default for your account in the current Region.</p> <p>After you disable encryption by default, you can still create encrypted volumes by enabling encryption when you create each volume.</p> <p>Disabling encryption by default does not change the encryption status of your existing volumes.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'DisableFastSnapshotRestores' => '<p>Disables fast snapshot restores for the specified snapshots in the specified Availability Zones.</p>', 'DisableTransitGatewayRouteTablePropagation' => '<p>Disables the specified resource attachment from propagating routes to the specified propagation route table.</p>', 'DisableVgwRoutePropagation' => '<p>Disables a virtual private gateway (VGW) from propagating routes to a specified route table of a VPC.</p>', 'DisableVpcClassicLink' => '<p>Disables ClassicLink for a VPC. You cannot disable ClassicLink for a VPC that has EC2-Classic instances linked to it.</p>', 'DisableVpcClassicLinkDnsSupport' => '<p>Disables ClassicLink DNS support for a VPC. If disabled, DNS hostnames resolve to public IP addresses when addressed between a linked EC2-Classic instance and instances in the VPC to which it\'s linked. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>You must specify a VPC ID in the request.</p>', 'DisassociateAddress' => '<p>Disassociates an Elastic IP address from the instance or network interface it\'s associated with.</p> <p>An Elastic IP address is for use in either the EC2-Classic platform or in a VPC. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn\'t return an error.</p>', 'DisassociateClientVpnTargetNetwork' => '<p>Disassociates a target network from the specified Client VPN endpoint. When you disassociate the last target network from a Client VPN, the following happens:</p> <ul> <li> <p>The route that was automatically added for the VPC is deleted</p> </li> <li> <p>All active client connections are terminated</p> </li> <li> <p>New client connections are disallowed</p> </li> <li> <p>The Client VPN endpoint\'s status changes to <code>pending-associate</code> </p> </li> </ul>', 'DisassociateIamInstanceProfile' => '<p>Disassociates an IAM instance profile from a running or stopped instance.</p> <p>Use <a>DescribeIamInstanceProfileAssociations</a> to get the association ID.</p>', 'DisassociateRouteTable' => '<p>Disassociates a subnet or gateway from a route table.</p> <p>After you perform this action, the subnet no longer uses the routes in the route table. Instead, it uses the routes in the VPC\'s main route table. For more information about route tables, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route Tables</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'DisassociateSubnetCidrBlock' => '<p>Disassociates a CIDR block from a subnet. Currently, you can disassociate an IPv6 CIDR block only. You must detach or delete all gateways and resources that are associated with the CIDR block before you can disassociate it. </p>', 'DisassociateTransitGatewayMulticastDomain' => '<p>Disassociates the specified subnets from the transit gateway multicast domain. </p>', 'DisassociateTransitGatewayRouteTable' => '<p>Disassociates a resource attachment from a transit gateway route table.</p>', 'DisassociateVpcCidrBlock' => '<p>Disassociates a CIDR block from a VPC. To disassociate the CIDR block, you must specify its association ID. You can get the association ID by using <a>DescribeVpcs</a>. You must detach or delete all gateways and resources that are associated with the CIDR block before you can disassociate it. </p> <p>You cannot disassociate the CIDR block with which you originally created the VPC (the primary CIDR block).</p>', 'EnableEbsEncryptionByDefault' => '<p>Enables EBS encryption by default for your account in the current Region.</p> <p>After you enable encryption by default, the EBS volumes that you create are are always encrypted, either using the default CMK or the CMK that you specified when you created each volume. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>You can specify the default CMK for encryption by default using <a>ModifyEbsDefaultKmsKeyId</a> or <a>ResetEbsDefaultKmsKeyId</a>.</p> <p>Enabling encryption by default has no effect on the encryption status of your existing volumes.</p> <p>After you enable encryption by default, you can no longer launch instances using instance types that do not support encryption. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances">Supported Instance Types</a>.</p>', 'EnableFastSnapshotRestores' => '<p>Enables fast snapshot restores for the specified snapshots in the specified Availability Zones.</p> <p>You get the full benefit of fast snapshot restores after they enter the <code>enabled</code> state. To get the current state of fast snapshot restores, use <a>DescribeFastSnapshotRestores</a>. To disable fast snapshot restores, use <a>DisableFastSnapshotRestores</a>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-fast-snapshot-restore.html">Amazon EBS Fast Snapshot Restore</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'EnableTransitGatewayRouteTablePropagation' => '<p>Enables the specified attachment to propagate routes to the specified propagation route table.</p>', 'EnableVgwRoutePropagation' => '<p>Enables a virtual private gateway (VGW) to propagate routes to the specified route table of a VPC.</p>', 'EnableVolumeIO' => '<p>Enables I/O operations for a volume that had I/O operations disabled because the data on the volume was potentially inconsistent.</p>', 'EnableVpcClassicLink' => '<p>Enables a VPC for ClassicLink. You can then link EC2-Classic instances to your ClassicLink-enabled VPC to allow communication over private IP addresses. You cannot enable your VPC for ClassicLink if any of your VPC route tables have existing routes for address ranges within the <code>10.0.0.0/8</code> IP address range, excluding local routes for VPCs in the <code>10.0.0.0/16</code> and <code>10.1.0.0/16</code> IP address ranges. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'EnableVpcClassicLinkDnsSupport' => '<p>Enables a VPC to support DNS hostname resolution for ClassicLink. If enabled, the DNS hostname of a linked EC2-Classic instance resolves to its private IP address when addressed from an instance in the VPC to which it\'s linked. Similarly, the DNS hostname of an instance in a VPC resolves to its private IP address when addressed from a linked EC2-Classic instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>You must specify a VPC ID in the request.</p>', 'ExportClientVpnClientCertificateRevocationList' => '<p>Downloads the client certificate revocation list for the specified Client VPN endpoint.</p>', 'ExportClientVpnClientConfiguration' => '<p>Downloads the contents of the Client VPN endpoint configuration file for the specified Client VPN endpoint. The Client VPN endpoint configuration file includes the Client VPN endpoint and certificate information clients need to establish a connection with the Client VPN endpoint.</p>', 'ExportImage' => '<p>Exports an Amazon Machine Image (AMI) to a VM file. For more information, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport_image.html">Exporting a VM Directory from an Amazon Machine Image (AMI)</a> in the <i>VM Import/Export User Guide</i>.</p>', 'ExportTransitGatewayRoutes' => '<p>Exports routes from the specified transit gateway route table to the specified S3 bucket. By default, all routes are exported. Alternatively, you can filter by CIDR range.</p> <p>The routes are saved to the specified bucket in a JSON file. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-route-tables.html#tgw-export-route-tables">Export Route Tables to Amazon S3</a> in <i>Transit Gateways</i>.</p>', 'GetAssociatedIpv6PoolCidrs' => '<p>Gets information about the IPv6 CIDR block associations for a specified IPv6 address pool.</p>', 'GetCapacityReservationUsage' => '<p>Gets usage information about a Capacity Reservation. If the Capacity Reservation is shared, it shows usage information for the Capacity Reservation owner and each AWS account that is currently using the shared capacity. If the Capacity Reservation is not shared, it shows only the Capacity Reservation owner\'s usage.</p>', 'GetCoipPoolUsage' => '<p>Describes the allocations from the specified customer-owned address pool.</p>', 'GetConsoleOutput' => '<p>Gets the console output for the specified instance. For Linux instances, the instance console output displays the exact console output that would normally be displayed on a physical monitor attached to a computer. For Windows instances, the instance console output includes the last three system event log errors.</p> <p>By default, the console output returns buffered information that was posted shortly after an instance transition state (start, stop, reboot, or terminate). This information is available for at least one hour after the most recent post. Only the most recent 64 KB of console output is available.</p> <p>You can optionally retrieve the latest serial console output at any time during the instance lifecycle. This option is supported on instance types that use the Nitro hypervisor.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-console.html#instance-console-console-output">Instance Console Output</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'GetConsoleScreenshot' => '<p>Retrieve a JPG-format screenshot of a running instance to help with troubleshooting.</p> <p>The returned content is Base64-encoded.</p>', 'GetDefaultCreditSpecification' => '<p>Describes the default credit option for CPU usage of a burstable performance instance family.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'GetEbsDefaultKmsKeyId' => '<p>Describes the default customer master key (CMK) for EBS encryption by default for your account in this Region. You can change the default CMK for encryption by default using <a>ModifyEbsDefaultKmsKeyId</a> or <a>ResetEbsDefaultKmsKeyId</a>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'GetEbsEncryptionByDefault' => '<p>Describes whether EBS encryption by default is enabled for your account in the current Region.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'GetGroupsForCapacityReservation' => '<p>Lists the resource groups to which a Capacity Reservation has been added.</p>', 'GetHostReservationPurchasePreview' => '<p>Preview a reservation purchase with configurations that match those of your Dedicated Host. You must have active Dedicated Hosts in your account before you purchase a reservation.</p> <p>This is a preview of the <a>PurchaseHostReservation</a> action and does not result in the offering being purchased.</p>', 'GetLaunchTemplateData' => '<p>Retrieves the configuration data of the specified instance. You can use this data to create a launch template. </p> <p>This action calls on other describe actions to get instance information. Depending on your instance configuration, you may need to allow the following actions in your IAM policy: DescribeSpotInstanceRequests, DescribeInstanceCreditSpecifications, DescribeVolumes, DescribeInstanceAttribute, and DescribeElasticGpus. Or, you can allow <code>describe*</code> depending on your instance requirements.</p>', 'GetManagedPrefixListAssociations' => '<p>Gets information about the resources that are associated with the specified managed prefix list.</p>', 'GetManagedPrefixListEntries' => '<p>Gets information about the entries for a specified managed prefix list.</p>', 'GetPasswordData' => '<p>Retrieves the encrypted administrator password for a running Windows instance.</p> <p>The Windows password is generated at boot by the <code>EC2Config</code> service or <code>EC2Launch</code> scripts (Windows Server 2016 and later). This usually only happens the first time an instance is launched. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/UsingConfig_WinAMI.html">EC2Config</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2launch.html">EC2Launch</a> in the Amazon Elastic Compute Cloud User Guide.</p> <p>For the <code>EC2Config</code> service, the password is not generated for rebundled AMIs unless <code>Ec2SetPassword</code> is enabled before bundling.</p> <p>The password is encrypted using the key pair that you specified when you launched the instance. You must provide the corresponding key pair file.</p> <p>When you launch an instance, password generation and encryption may take a few minutes. If you try to retrieve the password before it\'s available, the output returns an empty string. We recommend that you wait up to 15 minutes after launching an instance before trying to retrieve the generated password.</p>', 'GetReservedInstancesExchangeQuote' => '<p>Returns a quote and exchange information for exchanging one or more specified Convertible Reserved Instances for a new Convertible Reserved Instance. If the exchange cannot be performed, the reason is returned in the response. Use <a>AcceptReservedInstancesExchangeQuote</a> to perform the exchange.</p>', 'GetTransitGatewayAttachmentPropagations' => '<p>Lists the route tables to which the specified resource attachment propagates routes.</p>', 'GetTransitGatewayMulticastDomainAssociations' => '<p>Gets information about the associations for the transit gateway multicast domain.</p>', 'GetTransitGatewayRouteTableAssociations' => '<p>Gets information about the associations for the specified transit gateway route table.</p>', 'GetTransitGatewayRouteTablePropagations' => '<p>Gets information about the route table propagations for the specified transit gateway route table.</p>', 'ImportClientVpnClientCertificateRevocationList' => '<p>Uploads a client certificate revocation list to the specified Client VPN endpoint. Uploading a client certificate revocation list overwrites the existing client certificate revocation list.</p> <p>Uploading a client certificate revocation list resets existing client connections.</p>', 'ImportImage' => '<p>Import single or multi-volume disk images or EBS snapshots into an Amazon Machine Image (AMI). For more information, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html">Importing a VM as an Image Using VM Import/Export</a> in the <i>VM Import/Export User Guide</i>.</p>', 'ImportInstance' => '<p>Creates an import instance task using metadata from the specified disk image. <code>ImportInstance</code> only supports single-volume VMs. To import multi-volume VMs, use <a>ImportImage</a>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/ec2-cli-vmimport-export.html">Importing a Virtual Machine Using the Amazon EC2 CLI</a>.</p> <p>For information about the import manifest referenced by this API action, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest</a>.</p>', 'ImportKeyPair' => '<p>Imports the public key from an RSA key pair that you created with a third-party tool. Compare this with <a>CreateKeyPair</a>, in which AWS creates the key pair and gives the keys to you (AWS keeps a copy of the public key). With ImportKeyPair, you create the key pair and give AWS just the public key. The private key is never transferred between you and AWS.</p> <p>For more information about key pairs, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Key Pairs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'ImportSnapshot' => '<p>Imports a disk into an EBS snapshot.</p>', 'ImportVolume' => '<p>Creates an import volume task using metadata from the specified disk image.For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/importing-your-volumes-into-amazon-ebs.html">Importing Disks to Amazon EBS</a>.</p> <p>For information about the import manifest referenced by this API action, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest</a>.</p>', 'ModifyAvailabilityZoneGroup' => '<p>Changes the opt-in status of the Local Zone and Wavelength Zone group for your account.</p> <p>Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAvailabilityZones.html"> DescribeAvailabilityZones</a> to view the value for <code>GroupName</code>.</p>', 'ModifyCapacityReservation' => '<p>Modifies a Capacity Reservation\'s capacity and the conditions under which it is to be released. You cannot change a Capacity Reservation\'s instance type, EBS optimization, instance store settings, platform, Availability Zone, or instance eligibility. If you need to modify any of these attributes, we recommend that you cancel the Capacity Reservation, and then create a new one with the required attributes.</p>', 'ModifyClientVpnEndpoint' => '<p>Modifies the specified Client VPN endpoint. Modifying the DNS server resets existing client connections.</p>', 'ModifyDefaultCreditSpecification' => '<p>Modifies the default credit option for CPU usage of burstable performance instances. The default credit option is set at the account level per AWS Region, and is specified per instance family. All new burstable performance instances in the account launch using the default credit option.</p> <p> <code>ModifyDefaultCreditSpecification</code> is an asynchronous operation, which works at an AWS Region level and modifies the credit option for each Availability Zone. All zones in a Region are updated within five minutes. But if instances are launched during this operation, they might not get the new credit option until the zone is updated. To verify whether the update has occurred, you can call <code>GetDefaultCreditSpecification</code> and check <code>DefaultCreditSpecification</code> for updates.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'ModifyEbsDefaultKmsKeyId' => '<p>Changes the default customer master key (CMK) for EBS encryption by default for your account in this Region.</p> <p>AWS creates a unique AWS managed CMK in each Region for use with encryption by default. If you change the default CMK to a symmetric customer managed CMK, it is used instead of the AWS managed CMK. To reset the default CMK to the AWS managed CMK for EBS, use <a>ResetEbsDefaultKmsKeyId</a>. Amazon EBS does not support asymmetric CMKs.</p> <p>If you delete or disable the customer managed CMK that you specified for use with encryption by default, your instances will fail to launch.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'ModifyFleet' => '<p>Modifies the specified EC2 Fleet.</p> <p>You can only modify an EC2 Fleet request of type <code>maintain</code>.</p> <p>While the EC2 Fleet is being modified, it is in the <code>modifying</code> state.</p> <p>To scale up your EC2 Fleet, increase its target capacity. The EC2 Fleet launches the additional Spot Instances according to the allocation strategy for the EC2 Fleet request. If the allocation strategy is <code>lowest-price</code>, the EC2 Fleet launches instances using the Spot Instance pool with the lowest price. If the allocation strategy is <code>diversified</code>, the EC2 Fleet distributes the instances across the Spot Instance pools. If the allocation strategy is <code>capacity-optimized</code>, EC2 Fleet launches instances from Spot Instance pools with optimal capacity for the number of instances that are launching.</p> <p>To scale down your EC2 Fleet, decrease its target capacity. First, the EC2 Fleet cancels any open requests that exceed the new target capacity. You can request that the EC2 Fleet terminate Spot Instances until the size of the fleet no longer exceeds the new target capacity. If the allocation strategy is <code>lowest-price</code>, the EC2 Fleet terminates the instances with the highest price per unit. If the allocation strategy is <code>capacity-optimized</code>, the EC2 Fleet terminates the instances in the Spot Instance pools that have the least available Spot Instance capacity. If the allocation strategy is <code>diversified</code>, the EC2 Fleet terminates instances across the Spot Instance pools. Alternatively, you can request that the EC2 Fleet keep the fleet at its current size, but not replace any Spot Instances that are interrupted or that you terminate manually.</p> <p>If you are finished with your EC2 Fleet for now, but will use it again later, you can set the target capacity to 0.</p>', 'ModifyFpgaImageAttribute' => '<p>Modifies the specified attribute of the specified Amazon FPGA Image (AFI).</p>', 'ModifyHosts' => '<p>Modify the auto-placement setting of a Dedicated Host. When auto-placement is enabled, any instances that you launch with a tenancy of <code>host</code> but without a specific host ID are placed onto any available Dedicated Host in your account that has auto-placement enabled. When auto-placement is disabled, you need to provide a host ID to have the instance launch onto a specific host. If no host ID is provided, the instance is launched onto a suitable host with auto-placement enabled.</p> <p>You can also use this API action to modify a Dedicated Host to support either multiple instance types in an instance family, or to support a specific instance type only.</p>', 'ModifyIdFormat' => '<p>Modifies the ID format for the specified resource on a per-Region basis. You can specify that resources should receive longer IDs (17-character IDs) when they are created.</p> <p>This request can only be used to modify longer ID settings for resource types that are within the opt-in period. Resources currently in their opt-in period include: <code>bundle</code> | <code>conversion-task</code> | <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> | <code>import-task</code> | <code>internet-gateway</code> | <code>network-acl</code> | <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code> | <code>prefix-list</code> | <code>route-table</code> | <code>route-table-association</code> | <code>security-group</code> | <code>subnet</code> | <code>subnet-cidr-block-association</code> | <code>vpc</code> | <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> | <code>vpn-connection</code> | <code>vpn-gateway</code>.</p> <p>This setting applies to the IAM user who makes the request; it does not apply to the entire AWS account. By default, an IAM user defaults to the same settings as the root user. If you\'re using this action as the root user, then these settings apply to the entire account, unless an IAM user explicitly overrides these settings for themselves. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html">Resource IDs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>Resources created with longer IDs are visible to all IAM roles and users, regardless of these settings and provided that they have permission to use the relevant <code>Describe</code> command for the resource type.</p>', 'ModifyIdentityIdFormat' => '<p>Modifies the ID format of a resource for a specified IAM user, IAM role, or the root user for an account; or all IAM users, IAM roles, and the root user for an account. You can specify that resources should receive longer IDs (17-character IDs) when they are created. </p> <p>This request can only be used to modify longer ID settings for resource types that are within the opt-in period. Resources currently in their opt-in period include: <code>bundle</code> | <code>conversion-task</code> | <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> | <code>import-task</code> | <code>internet-gateway</code> | <code>network-acl</code> | <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code> | <code>prefix-list</code> | <code>route-table</code> | <code>route-table-association</code> | <code>security-group</code> | <code>subnet</code> | <code>subnet-cidr-block-association</code> | <code>vpc</code> | <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> | <code>vpn-connection</code> | <code>vpn-gateway</code>. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html">Resource IDs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. </p> <p>This setting applies to the principal specified in the request; it does not apply to the principal that makes the request. </p> <p>Resources created with longer IDs are visible to all IAM roles and users, regardless of these settings and provided that they have permission to use the relevant <code>Describe</code> command for the resource type.</p>', 'ModifyImageAttribute' => '<p>Modifies the specified attribute of the specified AMI. You can specify only one attribute at a time. You can use the <code>Attribute</code> parameter to specify the attribute or one of the following parameters: <code>Description</code>, <code>LaunchPermission</code>, or <code>ProductCode</code>.</p> <p>AWS Marketplace product codes cannot be modified. Images with an AWS Marketplace product code cannot be made public.</p> <p>To enable the SriovNetSupport enhanced networking attribute of an image, enable SriovNetSupport on an instance and create an AMI from the instance.</p>', 'ModifyInstanceAttribute' => '<p>Modifies the specified attribute of the specified instance. You can specify only one attribute at a time.</p> <p> <b>Note: </b>Using this action to change the security groups associated with an elastic network interface (ENI) attached to an instance in a VPC can result in an error if the instance has more than one ENI. To change the security groups associated with an ENI attached to an instance that has multiple ENIs, we recommend that you use the <a>ModifyNetworkInterfaceAttribute</a> action.</p> <p>To modify some attributes, the instance must be stopped. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_ChangingAttributesWhileInstanceStopped.html">Modifying attributes of a stopped instance</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'ModifyInstanceCapacityReservationAttributes' => '<p>Modifies the Capacity Reservation settings for a stopped instance. Use this action to configure an instance to target a specific Capacity Reservation, run in any <code>open</code> Capacity Reservation with matching attributes, or run On-Demand Instance capacity.</p>', 'ModifyInstanceCreditSpecification' => '<p>Modifies the credit option for CPU usage on a running or stopped burstable performance instance. The credit options are <code>standard</code> and <code>unlimited</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'ModifyInstanceEventStartTime' => '<p>Modifies the start time for a scheduled Amazon EC2 instance event.</p>', 'ModifyInstanceMetadataOptions' => '<p>Modify the instance metadata parameters on a running or stopped instance. When you modify the parameters on a stopped instance, they are applied when the instance is started. When you modify the parameters on a running instance, the API responds with a state of “pending”. After the parameter modifications are successfully applied to the instance, the state of the modifications changes from “pending” to “applied” in subsequent describe-instances API calls. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data</a>.</p>', 'ModifyInstancePlacement' => '<p>Modifies the placement attributes for a specified instance. You can do the following:</p> <ul> <li> <p>Modify the affinity between an instance and a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html">Dedicated Host</a>. When affinity is set to <code>host</code> and the instance is not associated with a specific Dedicated Host, the next time the instance is launched, it is automatically associated with the host on which it lands. If the instance is restarted or rebooted, this relationship persists.</p> </li> <li> <p>Change the Dedicated Host with which an instance is associated.</p> </li> <li> <p>Change the instance tenancy of an instance from <code>host</code> to <code>dedicated</code>, or from <code>dedicated</code> to <code>host</code>.</p> </li> <li> <p>Move an instance to or from a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">placement group</a>.</p> </li> </ul> <p>At least one attribute for affinity, host ID, tenancy, or placement group name must be specified in the request. Affinity and tenancy can be modified in the same request.</p> <p>To modify the host ID, tenancy, placement group, or partition for an instance, the instance must be in the <code>stopped</code> state.</p>', 'ModifyLaunchTemplate' => '<p>Modifies a launch template. You can specify which version of the launch template to set as the default version. When launching an instance, the default version applies when a launch template version is not specified.</p>', 'ModifyManagedPrefixList' => '<p>Modifies the specified managed prefix list.</p> <p>Adding or removing entries in a prefix list creates a new version of the prefix list. Changing the name of the prefix list does not affect the version.</p> <p>If you specify a current version number that does not match the true current version number, the request fails.</p>', 'ModifyNetworkInterfaceAttribute' => '<p>Modifies the specified network interface attribute. You can specify only one attribute at a time. You can use this action to attach and detach security groups from an existing EC2 instance.</p>', 'ModifyReservedInstances' => '<p>Modifies the Availability Zone, instance count, instance type, or network platform (EC2-Classic or EC2-VPC) of your Reserved Instances. The Reserved Instances to be modified must be identical, except for Availability Zone, network platform, and instance type.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html">Modifying Reserved Instances</a> in the Amazon Elastic Compute Cloud User Guide.</p>', 'ModifySnapshotAttribute' => '<p>Adds or removes permission settings for the specified snapshot. You may add or remove specified AWS account IDs from a snapshot\'s list of create volume permissions, but you cannot do both in a single operation. If you need to both add and remove account IDs for a snapshot, you must use multiple operations. You can make up to 500 modifications to a snapshot in a single operation.</p> <p>Encrypted snapshots and snapshots with AWS Marketplace product codes cannot be made public. Snapshots encrypted with your default CMK cannot be shared with other accounts.</p> <p>For more information about modifying snapshot permissions, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-modifying-snapshot-permissions.html">Sharing Snapshots</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'ModifySpotFleetRequest' => '<p>Modifies the specified Spot Fleet request.</p> <p>You can only modify a Spot Fleet request of type <code>maintain</code>.</p> <p>While the Spot Fleet request is being modified, it is in the <code>modifying</code> state.</p> <p>To scale up your Spot Fleet, increase its target capacity. The Spot Fleet launches the additional Spot Instances according to the allocation strategy for the Spot Fleet request. If the allocation strategy is <code>lowestPrice</code>, the Spot Fleet launches instances using the Spot Instance pool with the lowest price. If the allocation strategy is <code>diversified</code>, the Spot Fleet distributes the instances across the Spot Instance pools. If the allocation strategy is <code>capacityOptimized</code>, Spot Fleet launches instances from Spot Instance pools with optimal capacity for the number of instances that are launching.</p> <p>To scale down your Spot Fleet, decrease its target capacity. First, the Spot Fleet cancels any open requests that exceed the new target capacity. You can request that the Spot Fleet terminate Spot Instances until the size of the fleet no longer exceeds the new target capacity. If the allocation strategy is <code>lowestPrice</code>, the Spot Fleet terminates the instances with the highest price per unit. If the allocation strategy is <code>capacityOptimized</code>, the Spot Fleet terminates the instances in the Spot Instance pools that have the least available Spot Instance capacity. If the allocation strategy is <code>diversified</code>, the Spot Fleet terminates instances across the Spot Instance pools. Alternatively, you can request that the Spot Fleet keep the fleet at its current size, but not replace any Spot Instances that are interrupted or that you terminate manually.</p> <p>If you are finished with your Spot Fleet for now, but will use it again later, you can set the target capacity to 0.</p>', 'ModifySubnetAttribute' => '<p>Modifies a subnet attribute. You can only modify one attribute at a time.</p>', 'ModifyTrafficMirrorFilterNetworkServices' => '<p>Allows or restricts mirroring network services.</p> <p> By default, Amazon DNS network services are not eligible for Traffic Mirror. Use <code>AddNetworkServices</code> to add network services to a Traffic Mirror filter. When a network service is added to the Traffic Mirror filter, all traffic related to that network service will be mirrored. When you no longer want to mirror network services, use <code>RemoveNetworkServices</code> to remove the network services from the Traffic Mirror filter. </p> <p>For information about filter rule properties, see <a href="https://docs.aws.amazon.com/vpc/latest/mirroring/traffic-mirroring-considerations.html">Network Services</a> in the <i>Traffic Mirroring User Guide </i>.</p>', 'ModifyTrafficMirrorFilterRule' => '<p>Modifies the specified Traffic Mirror rule.</p> <p> <code>DestinationCidrBlock</code> and <code>SourceCidrBlock</code> must both be an IPv4 range or an IPv6 range.</p>', 'ModifyTrafficMirrorSession' => '<p>Modifies a Traffic Mirror session.</p>', 'ModifyTransitGatewayVpcAttachment' => '<p>Modifies the specified VPC attachment.</p>', 'ModifyVolume' => '<p>You can modify several parameters of an existing EBS volume, including volume size, volume type, and IOPS capacity. If your EBS volume is attached to a current-generation EC2 instance type, you may be able to apply these changes without stopping the instance or detaching the volume from it. For more information about modifying an EBS volume running Linux, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-expand-volume.html">Modifying the Size, IOPS, or Type of an EBS Volume on Linux</a>. For more information about modifying an EBS volume running Windows, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ebs-expand-volume.html">Modifying the Size, IOPS, or Type of an EBS Volume on Windows</a>. </p> <p> When you complete a resize operation on your volume, you need to extend the volume\'s file-system size to take advantage of the new storage capacity. For information about extending a Linux file system, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-expand-volume.html#recognize-expanded-volume-linux">Extending a Linux File System</a>. For information about extending a Windows file system, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ebs-expand-volume.html#recognize-expanded-volume-windows">Extending a Windows File System</a>. </p> <p> You can use CloudWatch Events to check the status of a modification to an EBS volume. For information about CloudWatch Events, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/">Amazon CloudWatch Events User Guide</a>. You can also track the status of a modification using <a>DescribeVolumesModifications</a>. For information about tracking status changes using either method, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-expand-volume.html#monitoring_mods">Monitoring Volume Modifications</a>. </p> <p>With previous-generation instance types, resizing an EBS volume may require detaching and reattaching the volume or stopping and restarting the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-expand-volume.html">Modifying the Size, IOPS, or Type of an EBS Volume on Linux</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ebs-expand-volume.html">Modifying the Size, IOPS, or Type of an EBS Volume on Windows</a>.</p> <p>If you reach the maximum volume modification rate per volume limit, you will need to wait at least six hours before applying further modifications to the affected EBS volume.</p>', 'ModifyVolumeAttribute' => '<p>Modifies a volume attribute.</p> <p>By default, all I/O operations for the volume are suspended when the data on the volume is determined to be potentially inconsistent, to prevent undetectable, latent data corruption. The I/O access to the volume can be resumed by first enabling I/O access and then checking the data consistency on your volume.</p> <p>You can change the default behavior to resume I/O operations. We recommend that you change this only for boot volumes or for volumes that are stateless or disposable.</p>', 'ModifyVpcAttribute' => '<p>Modifies the specified attribute of the specified VPC.</p>', 'ModifyVpcEndpoint' => '<p>Modifies attributes of a specified VPC endpoint. The attributes that you can modify depend on the type of VPC endpoint (interface or gateway). For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints.html">VPC Endpoints</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'ModifyVpcEndpointConnectionNotification' => '<p>Modifies a connection notification for VPC endpoint or VPC endpoint service. You can change the SNS topic for the notification, or the events for which to be notified. </p>', 'ModifyVpcEndpointServiceConfiguration' => '<p>Modifies the attributes of your VPC endpoint service configuration. You can change the Network Load Balancers for your service, and you can specify whether acceptance is required for requests to connect to your endpoint service through an interface VPC endpoint.</p> <p>If you set or modify the private DNS name, you must prove that you own the private DNS domain name. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-services-dns-validation.html">VPC Endpoint Service Private DNS Name Verification</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'ModifyVpcEndpointServicePermissions' => '<p>Modifies the permissions for your <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html">VPC endpoint service</a>. You can add or remove permissions for service consumers (IAM users, IAM roles, and AWS accounts) to connect to your endpoint service.</p> <p>If you grant permissions to all principals, the service is public. Any users who know the name of a public service can send a request to attach an endpoint. If the service does not require manual approval, attachments are automatically approved.</p>', 'ModifyVpcPeeringConnectionOptions' => '<p>Modifies the VPC peering connection options on one side of a VPC peering connection. You can do the following:</p> <ul> <li> <p>Enable/disable communication over the peering connection between an EC2-Classic instance that\'s linked to your VPC (using ClassicLink) and instances in the peer VPC.</p> </li> <li> <p>Enable/disable communication over the peering connection between instances in your VPC and an EC2-Classic instance that\'s linked to the peer VPC.</p> </li> <li> <p>Enable/disable the ability to resolve public DNS hostnames to private IP addresses when queried from instances in the peer VPC.</p> </li> </ul> <p>If the peered VPCs are in the same AWS account, you can enable DNS resolution for queries from the local VPC. This ensures that queries from the local VPC resolve to private IP addresses in the peer VPC. This option is not available if the peered VPCs are in different AWS accounts or different Regions. For peered VPCs in different AWS accounts, each AWS account owner must initiate a separate request to modify the peering connection options. For inter-region peering connections, you must use the Region for the requester VPC to modify the requester VPC peering options and the Region for the accepter VPC to modify the accepter VPC peering options. To verify which VPCs are the accepter and the requester for a VPC peering connection, use the <a>DescribeVpcPeeringConnections</a> command.</p>', 'ModifyVpcTenancy' => '<p>Modifies the instance tenancy attribute of the specified VPC. You can change the instance tenancy attribute of a VPC to <code>default</code> only. You cannot change the instance tenancy attribute to <code>dedicated</code>.</p> <p>After you modify the tenancy of the VPC, any new instances that you launch into the VPC have a tenancy of <code>default</code>, unless you specify otherwise during launch. The tenancy of any existing instances in the VPC is not affected.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html">Dedicated Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'ModifyVpnConnection' => '<p>Modifies the customer gateway or the target gateway of an AWS Site-to-Site VPN connection. To modify the target gateway, the following migration options are available:</p> <ul> <li> <p>An existing virtual private gateway to a new virtual private gateway</p> </li> <li> <p>An existing virtual private gateway to a transit gateway</p> </li> <li> <p>An existing transit gateway to a new transit gateway</p> </li> <li> <p>An existing transit gateway to a virtual private gateway</p> </li> </ul> <p>Before you perform the migration to the new gateway, you must configure the new gateway. Use <a>CreateVpnGateway</a> to create a virtual private gateway, or <a>CreateTransitGateway</a> to create a transit gateway.</p> <p>This step is required when you migrate from a virtual private gateway with static routes to a transit gateway. </p> <p>You must delete the static routes before you migrate to the new gateway.</p> <p>Keep a copy of the static route before you delete it. You will need to add back these routes to the transit gateway after the VPN connection migration is complete.</p> <p>After you migrate to the new gateway, you might need to modify your VPC route table. Use <a>CreateRoute</a> and <a>DeleteRoute</a> to make the changes described in <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/modify-vpn-target.html#step-update-routing">VPN Gateway Target Modification Required VPC Route Table Updates</a> in the <i>AWS Site-to-Site VPN User Guide</i>.</p> <p> When the new gateway is a transit gateway, modify the transit gateway route table to allow traffic between the VPC and the AWS Site-to-Site VPN connection. Use <a>CreateTransitGatewayRoute</a> to add the routes.</p> <p> If you deleted VPN static routes, you must add the static routes to the transit gateway route table.</p> <p>After you perform this operation, the AWS VPN endpoint\'s IP addresses on the AWS side and the tunnel options remain intact. Your AWS Site-to-Site VPN connection will be temporarily unavailable for a brief period while we provision the new endpoints.</p>', 'ModifyVpnTunnelCertificate' => '<p>Modifies the VPN tunnel endpoint certificate.</p>', 'ModifyVpnTunnelOptions' => '<p>Modifies the options for a VPN tunnel in an AWS Site-to-Site VPN connection. You can modify multiple options for a tunnel in a single request, but you can only modify one tunnel at a time. For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPNTunnels.html">Site-to-Site VPN Tunnel Options for Your Site-to-Site VPN Connection</a> in the <i>AWS Site-to-Site VPN User Guide</i>.</p>', 'MonitorInstances' => '<p>Enables detailed monitoring for a running instance. Otherwise, basic monitoring is enabled. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch.html">Monitoring your instances and volumes</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>To disable detailed monitoring, see .</p>', 'MoveAddressToVpc' => '<p>Moves an Elastic IP address from the EC2-Classic platform to the EC2-VPC platform. The Elastic IP address must be allocated to your account for more than 24 hours, and it must not be associated with an instance. After the Elastic IP address is moved, it is no longer available for use in the EC2-Classic platform, unless you move it back using the <a>RestoreAddressToClassic</a> request. You cannot move an Elastic IP address that was originally allocated for use in the EC2-VPC platform to the EC2-Classic platform. </p>', 'ProvisionByoipCidr' => '<p>Provisions an IPv4 or IPv6 address range for use with your AWS resources through bring your own IP addresses (BYOIP) and creates a corresponding address pool. After the address range is provisioned, it is ready to be advertised using <a>AdvertiseByoipCidr</a>.</p> <p>AWS verifies that you own the address range and are authorized to advertise it. You must ensure that the address range is registered to you and that you created an RPKI ROA to authorize Amazon ASNs 16509 and 14618 to advertise the address range. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">Bring Your Own IP Addresses (BYOIP)</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>Provisioning an address range is an asynchronous operation, so the call returns immediately, but the address range is not ready to use until its status changes from <code>pending-provision</code> to <code>provisioned</code>. To monitor the status of an address range, use <a>DescribeByoipCidrs</a>. To allocate an Elastic IP address from your IPv4 address pool, use <a>AllocateAddress</a> with either the specific address from the address pool or the ID of the address pool.</p>', 'PurchaseHostReservation' => '<p>Purchase a reservation with configurations that match those of your Dedicated Host. You must have active Dedicated Hosts in your account before you purchase a reservation. This action results in the specified reservation being purchased and charged to your account.</p>', 'PurchaseReservedInstancesOffering' => '<p>Purchases a Reserved Instance for use with your account. With Reserved Instances, you pay a lower hourly rate compared to On-Demand instance pricing.</p> <p>Use <a>DescribeReservedInstancesOfferings</a> to get a list of Reserved Instance offerings that match your specifications. After you\'ve purchased a Reserved Instance, you can check for your new Reserved Instance with <a>DescribeReservedInstances</a>.</p> <p>To queue a purchase for a future date and time, specify a purchase time. If you do not specify a purchase time, the default is the current time.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/concepts-on-demand-reserved-instances.html">Reserved Instances</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance Marketplace</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'PurchaseScheduledInstances' => '<p>Purchases the Scheduled Instances with the specified schedule.</p> <p>Scheduled Instances enable you to purchase Amazon EC2 compute capacity by the hour for a one-year term. Before you can purchase a Scheduled Instance, you must call <a>DescribeScheduledInstanceAvailability</a> to check for available schedules and obtain a purchase token. After you purchase a Scheduled Instance, you must call <a>RunScheduledInstances</a> during each scheduled time period.</p> <p>After you purchase a Scheduled Instance, you can\'t cancel, modify, or resell your purchase.</p>', 'RebootInstances' => '<p>Requests a reboot of the specified instances. This operation is asynchronous; it only queues a request to reboot the specified instances. The operation succeeds if the instances are valid and belong to you. Requests to reboot terminated instances are ignored.</p> <p>If an instance does not cleanly shut down within four minutes, Amazon EC2 performs a hard reboot.</p> <p>For more information about troubleshooting, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-console.html">Getting console output and rebooting instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'RegisterImage' => '<p>Registers an AMI. When you\'re creating an AMI, this is the final step you must complete before you can launch an instance from the AMI. For more information about creating AMIs, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami.html">Creating your own AMIs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <note> <p>For Amazon EBS-backed instances, <a>CreateImage</a> creates and registers the AMI in a single request, so you don\'t have to register the AMI yourself.</p> </note> <p>You can also use <code>RegisterImage</code> to create an Amazon EBS-backed Linux AMI from a snapshot of a root device volume. You specify the snapshot using the block device mapping. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-launch-snapshot.html">Launching a Linux instance from a backup</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>If any snapshots have AWS Marketplace product codes, they are copied to the new AMI.</p> <p>Windows and some Linux distributions, such as Red Hat Enterprise Linux (RHEL) and SUSE Linux Enterprise Server (SLES), use the EC2 billing product code associated with an AMI to verify the subscription status for package updates. To create a new AMI for operating systems that require a billing product code, instead of registering the AMI, do the following to preserve the billing product code association:</p> <ol> <li> <p>Launch an instance from an existing AMI with that billing product code.</p> </li> <li> <p>Customize the instance.</p> </li> <li> <p>Create an AMI from the instance using <a>CreateImage</a>.</p> </li> </ol> <p>If you purchase a Reserved Instance to apply to an On-Demand Instance that was launched from an AMI with a billing product code, make sure that the Reserved Instance has the matching billing product code. If you purchase a Reserved Instance without the matching billing product code, the Reserved Instance will not be applied to the On-Demand Instance. For information about how to obtain the platform details and billing information of an AMI, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-billing-info.html">Obtaining billing information</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>If needed, you can deregister an AMI at any time. Any modifications you make to an AMI backed by an instance store volume invalidates its registration. If you make changes to an image, deregister the previous image and register the new image.</p>', 'RegisterInstanceEventNotificationAttributes' => '<p>Registers a set of tag keys to include in scheduled event notifications for your resources. </p> <p>To remove tags, use .</p>', 'RegisterTransitGatewayMulticastGroupMembers' => '<p>Registers members (network interfaces) with the transit gateway multicast group. A member is a network interface associated with a supported EC2 instance that receives multicast traffic. For information about supported instances, see <a href="https://docs.aws.amazon.com/vpc/latest/tgw/transit-gateway-limits.html#multicast-limits">Multicast Consideration</a> in <i>Amazon VPC Transit Gateways</i>.</p> <p>After you add the members, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SearchTransitGatewayMulticastGroups.html">SearchTransitGatewayMulticastGroups</a> to verify that the members were added to the transit gateway multicast group.</p>', 'RegisterTransitGatewayMulticastGroupSources' => '<p>Registers sources (network interfaces) with the specified transit gateway multicast group.</p> <p>A multicast source is a network interface attached to a supported instance that sends multicast traffic. For information about supported instances, see <a href="https://docs.aws.amazon.com/vpc/latest/tgw/transit-gateway-limits.html#multicast-limits">Multicast Considerations</a> in <i>Amazon VPC Transit Gateways</i>.</p> <p>After you add the source, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SearchTransitGatewayMulticastGroups.html">SearchTransitGatewayMulticastGroups</a> to verify that the source was added to the multicast group.</p>', 'RejectTransitGatewayPeeringAttachment' => '<p>Rejects a transit gateway peering attachment request.</p>', 'RejectTransitGatewayVpcAttachment' => '<p>Rejects a request to attach a VPC to a transit gateway.</p> <p>The VPC attachment must be in the <code>pendingAcceptance</code> state. Use <a>DescribeTransitGatewayVpcAttachments</a> to view your pending VPC attachment requests. Use <a>AcceptTransitGatewayVpcAttachment</a> to accept a VPC attachment request.</p>', 'RejectVpcEndpointConnections' => '<p>Rejects one or more VPC endpoint connection requests to your VPC endpoint service.</p>', 'RejectVpcPeeringConnection' => '<p>Rejects a VPC peering connection request. The VPC peering connection must be in the <code>pending-acceptance</code> state. Use the <a>DescribeVpcPeeringConnections</a> request to view your outstanding VPC peering connection requests. To delete an active VPC peering connection, or to delete a VPC peering connection request that you initiated, use <a>DeleteVpcPeeringConnection</a>.</p>', 'ReleaseAddress' => '<p>Releases the specified Elastic IP address.</p> <p>[EC2-Classic, default VPC] Releasing an Elastic IP address automatically disassociates it from any instance that it\'s associated with. To disassociate an Elastic IP address without releasing it, use <a>DisassociateAddress</a>.</p> <p>[Nondefault VPC] You must use <a>DisassociateAddress</a> to disassociate the Elastic IP address before you can release it. Otherwise, Amazon EC2 returns an error (<code>InvalidIPAddress.InUse</code>).</p> <p>After releasing an Elastic IP address, it is released to the IP address pool. Be sure to update your DNS records and any servers or devices that communicate with the address. If you attempt to release an Elastic IP address that you already released, you\'ll get an <code>AuthFailure</code> error if the address is already allocated to another AWS account.</p> <p>[EC2-VPC] After you release an Elastic IP address for use in a VPC, you might be able to recover it. For more information, see <a>AllocateAddress</a>.</p>', 'ReleaseHosts' => '<p>When you no longer want to use an On-Demand Dedicated Host it can be released. On-Demand billing is stopped and the host goes into <code>released</code> state. The host ID of Dedicated Hosts that have been released can no longer be specified in another request, for example, to modify the host. You must stop or terminate all instances on a host before it can be released.</p> <p>When Dedicated Hosts are released, it may take some time for them to stop counting toward your limit and you may receive capacity errors when trying to allocate new Dedicated Hosts. Wait a few minutes and then try again.</p> <p>Released hosts still appear in a <a>DescribeHosts</a> response.</p>', 'ReplaceIamInstanceProfileAssociation' => '<p>Replaces an IAM instance profile for the specified running instance. You can use this action to change the IAM instance profile that\'s associated with an instance without having to disassociate the existing IAM instance profile first.</p> <p>Use <a>DescribeIamInstanceProfileAssociations</a> to get the association ID.</p>', 'ReplaceNetworkAclAssociation' => '<p>Changes which network ACL a subnet is associated with. By default when you create a subnet, it\'s automatically associated with the default network ACL. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network ACLs</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p> <p>This is an idempotent operation.</p>', 'ReplaceNetworkAclEntry' => '<p>Replaces an entry (rule) in a network ACL. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html">Network ACLs</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'ReplaceRoute' => '<p>Replaces an existing route within a route table in a VPC. You must provide only one of the following: internet gateway, virtual private gateway, NAT instance, NAT gateway, VPC peering connection, network interface, egress-only internet gateway, or transit gateway.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route Tables</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'ReplaceRouteTableAssociation' => '<p>Changes the route table associated with a given subnet, internet gateway, or virtual private gateway in a VPC. After the operation completes, the subnet or gateway uses the routes in the new route table. For more information about route tables, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route Tables</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p> <p>You can also use this operation to change which table is the main route table in the VPC. Specify the main route table\'s association ID and the route table ID of the new main route table.</p>', 'ReplaceTransitGatewayRoute' => '<p>Replaces the specified route in the specified transit gateway route table.</p>', 'ReportInstanceStatus' => '<p>Submits feedback about the status of an instance. The instance must be in the <code>running</code> state. If your experience with the instance differs from the instance status returned by <a>DescribeInstanceStatus</a>, use <a>ReportInstanceStatus</a> to report your experience with the instance. Amazon EC2 collects this information to improve the accuracy of status checks.</p> <p>Use of this action does not change the value returned by <a>DescribeInstanceStatus</a>.</p>', 'RequestSpotFleet' => '<p>Creates a Spot Fleet request.</p> <p>The Spot Fleet request specifies the total target capacity and the On-Demand target capacity. Amazon EC2 calculates the difference between the total capacity and On-Demand capacity, and launches the difference as Spot capacity.</p> <p>You can submit a single request that includes multiple launch specifications that vary by instance type, AMI, Availability Zone, or subnet.</p> <p>By default, the Spot Fleet requests Spot Instances in the Spot Instance pool where the price per unit is the lowest. Each launch specification can include its own instance weighting that reflects the value of the instance type to your application workload.</p> <p>Alternatively, you can specify that the Spot Fleet distribute the target capacity across the Spot pools included in its launch specifications. By ensuring that the Spot Instances in your Spot Fleet are in different Spot pools, you can improve the availability of your fleet.</p> <p>You can specify tags for the Spot Fleet request and instances launched by the fleet. You cannot tag other resource types in a Spot Fleet request because only the <code>spot-fleet-request</code> and <code>instance</code> resource types are supported.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-requests.html">Spot Fleet requests</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>', 'RequestSpotInstances' => '<p>Creates a Spot Instance request.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-requests.html">Spot Instance requests</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>', 'ResetEbsDefaultKmsKeyId' => '<p>Resets the default customer master key (CMK) for EBS encryption for your account in this Region to the AWS managed CMK for EBS.</p> <p>After resetting the default CMK to the AWS managed CMK, you can continue to encrypt by a customer managed CMK by specifying it when you create the volume. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'ResetFpgaImageAttribute' => '<p>Resets the specified attribute of the specified Amazon FPGA Image (AFI) to its default value. You can only reset the load permission attribute.</p>', 'ResetImageAttribute' => '<p>Resets an attribute of an AMI to its default value.</p> <note> <p>The productCodes attribute can\'t be reset.</p> </note>', 'ResetInstanceAttribute' => '<p>Resets an attribute of an instance to its default value. To reset the <code>kernel</code> or <code>ramdisk</code>, the instance must be in a stopped state. To reset the <code>sourceDestCheck</code>, the instance can be either running or stopped.</p> <p>The <code>sourceDestCheck</code> attribute controls whether source/destination checking is enabled. The default value is <code>true</code>, which means checking is enabled. This value must be <code>false</code> for a NAT instance to perform NAT. For more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html">NAT Instances</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'ResetNetworkInterfaceAttribute' => '<p>Resets a network interface attribute. You can specify only one attribute at a time.</p>', 'ResetSnapshotAttribute' => '<p>Resets permission settings for the specified snapshot.</p> <p>For more information about modifying snapshot permissions, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-modifying-snapshot-permissions.html">Sharing Snapshots</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'RestoreAddressToClassic' => '<p>Restores an Elastic IP address that was previously moved to the EC2-VPC platform back to the EC2-Classic platform. You cannot move an Elastic IP address that was originally allocated for use in EC2-VPC. The Elastic IP address must not be associated with an instance or network interface.</p>', 'RestoreManagedPrefixListVersion' => '<p>Restores the entries from a previous version of a managed prefix list to a new version of the prefix list.</p>', 'RevokeClientVpnIngress' => '<p>Removes an ingress authorization rule from a Client VPN endpoint. </p>', 'RevokeSecurityGroupEgress' => '<p>[VPC only] Removes the specified egress rules from a security group for EC2-VPC. This action doesn\'t apply to security groups for use in EC2-Classic. To remove a rule, the values that you specify (for example, ports) must match the existing rule\'s values exactly.</p> <p>Each rule consists of the protocol and the IPv4 or IPv6 CIDR range or source security group. For the TCP and UDP protocols, you must also specify the destination port or range of ports. For the ICMP protocol, you must also specify the ICMP type and code. If the security group rule has a description, you do not have to specify the description to revoke the rule.</p> <p>Rule changes are propagated to instances within the security group as quickly as possible. However, a small delay might occur.</p>', 'RevokeSecurityGroupIngress' => '<p>Removes the specified ingress rules from a security group. To remove a rule, the values that you specify (for example, ports) must match the existing rule\'s values exactly.</p> <note> <p>[EC2-Classic only] If the values you specify do not match the existing rule\'s values, no error is returned. Use <a>DescribeSecurityGroups</a> to verify that the rule has been removed.</p> </note> <p>Each rule consists of the protocol and the CIDR range or source security group. For the TCP and UDP protocols, you must also specify the destination port or range of ports. For the ICMP protocol, you must also specify the ICMP type and code. If the security group rule has a description, you do not have to specify the description to revoke the rule.</p> <p>Rule changes are propagated to instances within the security group as quickly as possible. However, a small delay might occur.</p>', 'RunInstances' => '<p>Launches the specified number of instances using an AMI for which you have permissions.</p> <p>You can specify a number of options, or leave the default options. The following rules apply:</p> <ul> <li> <p>[EC2-VPC] If you don\'t specify a subnet ID, we choose a default subnet from your default VPC for you. If you don\'t have a default VPC, you must specify a subnet ID in the request.</p> </li> <li> <p>[EC2-Classic] If don\'t specify an Availability Zone, we choose one for you.</p> </li> <li> <p>Some instance types must be launched into a VPC. If you do not have a default VPC, or if you do not specify a subnet ID, the request fails. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-vpc.html#vpc-only-instance-types">Instance types available only in a VPC</a>.</p> </li> <li> <p>[EC2-VPC] All instances have a network interface with a primary private IPv4 address. If you don\'t specify this address, we choose one from the IPv4 range of your subnet.</p> </li> <li> <p>Not all instance types support IPv6 addresses. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a>.</p> </li> <li> <p>If you don\'t specify a security group ID, we use the default security group. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Security groups</a>.</p> </li> <li> <p>If any of the AMIs have a product code attached for which the user has not subscribed, the request fails.</p> </li> </ul> <p>You can create a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">launch template</a>, which is a resource that contains the parameters to launch an instance. When you launch an instance using <a>RunInstances</a>, you can specify the launch template instead of specifying the launch parameters.</p> <p>To ensure faster instance launches, break up large requests into smaller batches. For example, create five separate launch requests for 100 instances each instead of one launch request for 500 instances.</p> <p>An instance is ready for you to use when it\'s in the <code>running</code> state. You can check the state of your instance using <a>DescribeInstances</a>. You can tag instances and EBS volumes during launch, after launch, or both. For more information, see <a>CreateTags</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging your Amazon EC2 resources</a>.</p> <p>Linux instances have access to the public key of the key pair at boot. You can use this key to provide secure access to the instance. Amazon EC2 public images use this feature to provide secure access without passwords. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Key pairs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>For troubleshooting, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_InstanceStraightToTerminated.html">What to do if an instance immediately terminates</a>, and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesConnecting.html">Troubleshooting connecting to your instance</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'RunScheduledInstances' => '<p>Launches the specified Scheduled Instances.</p> <p>Before you can launch a Scheduled Instance, you must purchase it and obtain an identifier using <a>PurchaseScheduledInstances</a>.</p> <p>You must launch a Scheduled Instance during its scheduled time period. You can\'t stop or reboot a Scheduled Instance, but you can terminate it as needed. If you terminate a Scheduled Instance before the current scheduled time period ends, you can launch it again after a few minutes. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-scheduled-instances.html">Scheduled Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'SearchLocalGatewayRoutes' => '<p>Searches for routes in the specified local gateway route table.</p>', 'SearchTransitGatewayMulticastGroups' => '<p>Searches one or more transit gateway multicast groups and returns the group membership information.</p>', 'SearchTransitGatewayRoutes' => '<p>Searches for routes in the specified transit gateway route table.</p>', 'SendDiagnosticInterrupt' => '<p>Sends a diagnostic interrupt to the specified Amazon EC2 instance to trigger a <i>kernel panic</i> (on Linux instances), or a <i>blue screen</i>/<i>stop error</i> (on Windows instances). For instances based on Intel and AMD processors, the interrupt is received as a <i>non-maskable interrupt</i> (NMI).</p> <p>In general, the operating system crashes and reboots when a kernel panic or stop error is triggered. The operating system can also be configured to perform diagnostic tasks, such as generating a memory dump file, loading a secondary kernel, or obtaining a call trace.</p> <p>Before sending a diagnostic interrupt to your instance, ensure that its operating system is configured to perform the required diagnostic tasks.</p> <p>For more information about configuring your operating system to generate a crash dump when a kernel panic or stop error occurs, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/diagnostic-interrupt.html">Send a diagnostic interrupt</a> (Linux instances) or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/diagnostic-interrupt.html">Send a Diagnostic Interrupt</a> (Windows instances).</p>', 'StartInstances' => '<p>Starts an Amazon EBS-backed instance that you\'ve previously stopped.</p> <p>Instances that use Amazon EBS volumes as their root devices can be quickly stopped and started. When an instance is stopped, the compute resources are released and you are not billed for instance usage. However, your root partition Amazon EBS volume remains and continues to persist your data, and you are charged for Amazon EBS volume usage. You can restart your instance at any time. Every time you start your Windows instance, Amazon EC2 charges you for a full instance hour. If you stop and restart your Windows instance, a new instance hour begins and Amazon EC2 charges you for another full instance hour even if you are still within the same 60-minute period when it was stopped. Every time you start your Linux instance, Amazon EC2 charges a one-minute minimum for instance usage, and thereafter charges per second for instance usage.</p> <p>Before stopping an instance, make sure it is in a state from which it can be restarted. Stopping an instance does not preserve data stored in RAM.</p> <p>Performing this operation on an instance that uses an instance store as its root device returns an error.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html">Stopping instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'StartVpcEndpointServicePrivateDnsVerification' => '<p>Initiates the verification process to prove that the service provider owns the private DNS name domain for the endpoint service.</p> <p>The service provider must successfully perform the verification before the consumer can use the name to access the service.</p> <p>Before the service provider runs this command, they must add a record to the DNS server. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/ndpoint-services-dns-validation.html#add-dns-txt-record">Adding a TXT Record to Your Domain\'s DNS Server </a> in the <i>Amazon VPC User Guide</i>.</p>', 'StopInstances' => '<p>Stops an Amazon EBS-backed instance.</p> <p>You can use the Stop action to hibernate an instance if the instance is <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#enabling-hibernation">enabled for hibernation</a> and it meets the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites">hibernation prerequisites</a>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>We don\'t charge usage for a stopped instance, or data transfer fees; however, your root partition Amazon EBS volume remains and continues to persist your data, and you are charged for Amazon EBS volume usage. Every time you start your Windows instance, Amazon EC2 charges you for a full instance hour. If you stop and restart your Windows instance, a new instance hour begins and Amazon EC2 charges you for another full instance hour even if you are still within the same 60-minute period when it was stopped. Every time you start your Linux instance, Amazon EC2 charges a one-minute minimum for instance usage, and thereafter charges per second for instance usage.</p> <p>You can\'t stop or hibernate instance store-backed instances. You can\'t use the Stop action to hibernate Spot Instances, but you can specify that Amazon EC2 should hibernate Spot Instances when they are interrupted. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-interruptions.html#hibernate-spot-instances">Hibernating interrupted Spot Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>When you stop or hibernate an instance, we shut it down. You can restart your instance at any time. Before stopping or hibernating an instance, make sure it is in a state from which it can be restarted. Stopping an instance does not preserve data stored in RAM, but hibernating an instance does preserve data stored in RAM. If an instance cannot hibernate successfully, a normal shutdown occurs.</p> <p>Stopping and hibernating an instance is different to rebooting or terminating it. For example, when you stop or hibernate an instance, the root device and any other devices attached to the instance persist. When you terminate an instance, the root device and any other devices attached during the instance launch are automatically deleted. For more information about the differences between rebooting, stopping, hibernating, and terminating instances, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html">Instance lifecycle</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>When you stop an instance, we attempt to shut it down forcibly after a short while. If your instance appears stuck in the stopping state after a period of time, there may be an issue with the underlying host computer. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesStopping.html">Troubleshooting stopping your instance</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'TerminateClientVpnConnections' => '<p>Terminates active Client VPN endpoint connections. This action can be used to terminate a specific client connection, or up to five connections established by a specific user.</p>', 'TerminateInstances' => '<p>Shuts down the specified instances. This operation is idempotent; if you terminate an instance more than once, each call succeeds. </p> <p>If you specify multiple instances and the request fails (for example, because of a single incorrect instance ID), none of the instances are terminated.</p> <p>Terminated instances remain visible after termination (for approximately one hour).</p> <p>By default, Amazon EC2 deletes all EBS volumes that were attached when the instance launched. Volumes attached after instance launch continue running.</p> <p>You can stop, start, and terminate EBS-backed instances. You can only terminate instance store-backed instances. What happens to an instance differs if you stop it or terminate it. For example, when you stop an instance, the root device and any other devices attached to the instance persist. When you terminate an instance, any attached EBS volumes with the <code>DeleteOnTermination</code> block device mapping parameter set to <code>true</code> are automatically deleted. For more information about the differences between stopping and terminating instances, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html">Instance lifecycle</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>For more information about troubleshooting, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesShuttingDown.html">Troubleshooting terminating your instance</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'UnassignIpv6Addresses' => '<p>Unassigns one or more IPv6 addresses from a network interface.</p>', 'UnassignPrivateIpAddresses' => '<p>Unassigns one or more secondary private IP addresses from a network interface.</p>', 'UnmonitorInstances' => '<p>Disables detailed monitoring for a running instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-cloudwatch.html">Monitoring your instances and volumes</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'UpdateSecurityGroupRuleDescriptionsEgress' => '<p>[VPC only] Updates the description of an egress (outbound) security group rule. You can replace an existing description, or add a description to a rule that did not have one previously.</p> <p>You specify the description as part of the IP permissions structure. You can remove a description for a security group rule by omitting the description parameter in the request.</p>', 'UpdateSecurityGroupRuleDescriptionsIngress' => '<p>Updates the description of an ingress (inbound) security group rule. You can replace an existing description, or add a description to a rule that did not have one previously.</p> <p>You specify the description as part of the IP permissions structure. You can remove a description for a security group rule by omitting the description parameter in the request.</p>', 'WithdrawByoipCidr' => '<p>Stops advertising an address range that is provisioned as an address pool.</p> <p>You can perform this operation at most once every 10 seconds, even if you specify different address ranges each time.</p> <p>It can take a few minutes before traffic to the specified addresses stops routing to AWS because of BGP propagation delays.</p>', ], 'shapes' => [ 'AcceptReservedInstancesExchangeQuoteRequest' => [ 'base' => '<p>Contains the parameters for accepting the quote.</p>', 'refs' => [], ], 'AcceptReservedInstancesExchangeQuoteResult' => [ 'base' => '<p>The result of the exchange and whether it was <code>successful</code>.</p>', 'refs' => [], ], 'AcceptTransitGatewayPeeringAttachmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'AcceptTransitGatewayPeeringAttachmentResult' => [ 'base' => NULL, 'refs' => [], ], 'AcceptTransitGatewayVpcAttachmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'AcceptTransitGatewayVpcAttachmentResult' => [ 'base' => NULL, 'refs' => [], ], 'AcceptVpcEndpointConnectionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'AcceptVpcEndpointConnectionsResult' => [ 'base' => NULL, 'refs' => [], ], 'AcceptVpcPeeringConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'AcceptVpcPeeringConnectionResult' => [ 'base' => NULL, 'refs' => [], ], 'AccountAttribute' => [ 'base' => '<p>Describes an account attribute.</p>', 'refs' => [ 'AccountAttributeList$member' => NULL, ], ], 'AccountAttributeList' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountAttributesResult$AccountAttributes' => '<p>Information about the account attributes.</p>', ], ], 'AccountAttributeName' => [ 'base' => NULL, 'refs' => [ 'AccountAttributeNameStringList$member' => NULL, ], ], 'AccountAttributeNameStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountAttributesRequest$AttributeNames' => '<p>The account attribute names.</p>', ], ], 'AccountAttributeValue' => [ 'base' => '<p>Describes a value of an account attribute.</p>', 'refs' => [ 'AccountAttributeValueList$member' => NULL, ], ], 'AccountAttributeValueList' => [ 'base' => NULL, 'refs' => [ 'AccountAttribute$AttributeValues' => '<p>The values for the account attribute.</p>', ], ], 'ActiveInstance' => [ 'base' => '<p>Describes a running instance in a Spot Fleet.</p>', 'refs' => [ 'ActiveInstanceSet$member' => NULL, ], ], 'ActiveInstanceSet' => [ 'base' => NULL, 'refs' => [ 'DescribeFleetInstancesResult$ActiveInstances' => '<p>The running instances. This list is refreshed periodically and might be out of date.</p>', 'DescribeSpotFleetInstancesResponse$ActiveInstances' => '<p>The running instances. This list is refreshed periodically and might be out of date.</p>', ], ], 'ActivityStatus' => [ 'base' => NULL, 'refs' => [ 'SpotFleetRequestConfig$ActivityStatus' => '<p>The progress of the Spot Fleet request. If there is an error, the status is <code>error</code>. After all requests are placed, the status is <code>pending_fulfillment</code>. If the size of the fleet is equal to or greater than its target capacity, the status is <code>fulfilled</code>. If the size of the fleet is decreased, the status is <code>pending_termination</code> while Spot Instances are terminating.</p>', ], ], 'AddPrefixListEntries' => [ 'base' => NULL, 'refs' => [ 'CreateManagedPrefixListRequest$Entries' => '<p>One or more entries for the prefix list.</p>', 'ModifyManagedPrefixListRequest$AddEntries' => '<p>One or more entries to add to the prefix list.</p>', ], ], 'AddPrefixListEntry' => [ 'base' => '<p>An entry for a prefix list.</p>', 'refs' => [ 'AddPrefixListEntries$member' => NULL, ], ], 'Address' => [ 'base' => '<p>Describes an Elastic IP address, or a carrier IP address.</p>', 'refs' => [ 'AddressList$member' => NULL, ], ], 'AddressList' => [ 'base' => NULL, 'refs' => [ 'DescribeAddressesResult$Addresses' => '<p>Information about the Elastic IP addresses.</p>', ], ], 'AdvertiseByoipCidrRequest' => [ 'base' => NULL, 'refs' => [], ], 'AdvertiseByoipCidrResult' => [ 'base' => NULL, 'refs' => [], ], 'Affinity' => [ 'base' => NULL, 'refs' => [ 'ModifyInstancePlacementRequest$Affinity' => '<p>The affinity setting for the instance.</p>', ], ], 'AllocateAddressRequest' => [ 'base' => NULL, 'refs' => [], ], 'AllocateAddressResult' => [ 'base' => NULL, 'refs' => [], ], 'AllocateHostsRequest' => [ 'base' => NULL, 'refs' => [], ], 'AllocateHostsResult' => [ 'base' => '<p>Contains the output of AllocateHosts.</p>', 'refs' => [], ], 'AllocationId' => [ 'base' => NULL, 'refs' => [ 'AllocationIdList$member' => NULL, 'AssociateAddressRequest$AllocationId' => '<p>[EC2-VPC] The allocation ID. This is required for EC2-VPC.</p>', 'CreateNatGatewayRequest$AllocationId' => '<p>The allocation ID of an Elastic IP address to associate with the NAT gateway. If the Elastic IP address is associated with another resource, you must first disassociate it.</p>', 'ReleaseAddressRequest$AllocationId' => '<p>[EC2-VPC] The allocation ID. Required for EC2-VPC.</p>', ], ], 'AllocationIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeAddressesRequest$AllocationIds' => '<p>[EC2-VPC] Information about the allocation IDs.</p>', ], ], 'AllocationState' => [ 'base' => NULL, 'refs' => [ 'Host$State' => '<p>The Dedicated Host\'s state.</p>', ], ], 'AllocationStrategy' => [ 'base' => NULL, 'refs' => [ 'SpotFleetRequestConfigData$AllocationStrategy' => '<p>Indicates how to allocate the target Spot Instance capacity across the Spot Instance pools specified by the Spot Fleet request.</p> <p>If the allocation strategy is <code>lowestPrice</code>, Spot Fleet launches instances from the Spot Instance pools with the lowest price. This is the default allocation strategy.</p> <p>If the allocation strategy is <code>diversified</code>, Spot Fleet launches instances from all the Spot Instance pools that you specify.</p> <p>If the allocation strategy is <code>capacityOptimized</code>, Spot Fleet launches instances from Spot Instance pools with optimal capacity for the number of instances that are launching.</p>', ], ], 'AllowedPrincipal' => [ 'base' => '<p>Describes a principal.</p>', 'refs' => [ 'AllowedPrincipalSet$member' => NULL, ], ], 'AllowedPrincipalSet' => [ 'base' => NULL, 'refs' => [ 'DescribeVpcEndpointServicePermissionsResult$AllowedPrincipals' => '<p>Information about one or more allowed principals.</p>', ], ], 'AllowsMultipleInstanceTypes' => [ 'base' => NULL, 'refs' => [ 'Host$AllowsMultipleInstanceTypes' => '<p>Indicates whether the Dedicated Host supports multiple instance types of the same instance family, or a specific instance type only. <code>one</code> indicates that the Dedicated Host supports multiple instance types in the instance family. <code>off</code> indicates that the Dedicated Host supports a single instance type only.</p>', ], ], 'ApplySecurityGroupsToClientVpnTargetNetworkRequest' => [ 'base' => NULL, 'refs' => [], ], 'ApplySecurityGroupsToClientVpnTargetNetworkResult' => [ 'base' => NULL, 'refs' => [], ], 'ArchitectureType' => [ 'base' => NULL, 'refs' => [ 'ArchitectureTypeList$member' => NULL, ], ], 'ArchitectureTypeList' => [ 'base' => NULL, 'refs' => [ 'ProcessorInfo$SupportedArchitectures' => '<p>A list of architectures supported by the instance type.</p>', ], ], 'ArchitectureValues' => [ 'base' => NULL, 'refs' => [ 'Image$Architecture' => '<p>The architecture of the image.</p>', 'ImportInstanceLaunchSpecification$Architecture' => '<p>The architecture of the instance.</p>', 'Instance$Architecture' => '<p>The architecture of the image.</p>', 'RegisterImageRequest$Architecture' => '<p>The architecture of the AMI.</p> <p>Default: For Amazon EBS-backed AMIs, <code>i386</code>. For instance store-backed AMIs, the architecture specified in the manifest file.</p>', ], ], 'AssignIpv6AddressesRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssignIpv6AddressesResult' => [ 'base' => NULL, 'refs' => [], ], 'AssignPrivateIpAddressesRequest' => [ 'base' => '<p>Contains the parameters for AssignPrivateIpAddresses.</p>', 'refs' => [], ], 'AssignPrivateIpAddressesResult' => [ 'base' => NULL, 'refs' => [], ], 'AssignedPrivateIpAddress' => [ 'base' => '<p>Describes the private IP addresses assigned to a network interface.</p>', 'refs' => [ 'AssignedPrivateIpAddressList$member' => NULL, ], ], 'AssignedPrivateIpAddressList' => [ 'base' => NULL, 'refs' => [ 'AssignPrivateIpAddressesResult$AssignedPrivateIpAddresses' => '<p>The private IP addresses assigned to the network interface.</p>', ], ], 'AssociateAddressRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateAddressResult' => [ 'base' => NULL, 'refs' => [], ], 'AssociateClientVpnTargetNetworkRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateClientVpnTargetNetworkResult' => [ 'base' => NULL, 'refs' => [], ], 'AssociateDhcpOptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateIamInstanceProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateIamInstanceProfileResult' => [ 'base' => NULL, 'refs' => [], ], 'AssociateRouteTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateRouteTableResult' => [ 'base' => NULL, 'refs' => [], ], 'AssociateSubnetCidrBlockRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateSubnetCidrBlockResult' => [ 'base' => NULL, 'refs' => [], ], 'AssociateTransitGatewayMulticastDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateTransitGatewayMulticastDomainResult' => [ 'base' => NULL, 'refs' => [], ], 'AssociateTransitGatewayRouteTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateTransitGatewayRouteTableResult' => [ 'base' => NULL, 'refs' => [], ], 'AssociateVpcCidrBlockRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateVpcCidrBlockResult' => [ 'base' => NULL, 'refs' => [], ], 'AssociatedNetworkType' => [ 'base' => NULL, 'refs' => [ 'AssociatedTargetNetwork$NetworkType' => '<p>The target network type.</p>', ], ], 'AssociatedTargetNetwork' => [ 'base' => '<p>Describes a target network that is associated with a Client VPN endpoint. A target network is a subnet in a VPC.</p>', 'refs' => [ 'AssociatedTargetNetworkSet$member' => NULL, ], ], 'AssociatedTargetNetworkSet' => [ 'base' => NULL, 'refs' => [ 'ClientVpnEndpoint$AssociatedTargetNetworks' => '<p>Information about the associated target networks. A target network is a subnet in a VPC.</p>', ], ], 'AssociationIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeIamInstanceProfileAssociationsRequest$AssociationIds' => '<p>The IAM instance profile associations.</p>', ], ], 'AssociationStatus' => [ 'base' => '<p>Describes the state of a target network association.</p>', 'refs' => [ 'AssociateClientVpnTargetNetworkResult$Status' => '<p>The current state of the target network association.</p>', 'DisassociateClientVpnTargetNetworkResult$Status' => '<p>The current state of the target network association.</p>', 'TargetNetwork$Status' => '<p>The current state of the target network association.</p>', ], ], 'AssociationStatusCode' => [ 'base' => NULL, 'refs' => [ 'AssociationStatus$Code' => '<p>The state of the target network association.</p>', ], ], 'AttachClassicLinkVpcRequest' => [ 'base' => NULL, 'refs' => [], ], 'AttachClassicLinkVpcResult' => [ 'base' => NULL, 'refs' => [], ], 'AttachInternetGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'AttachNetworkInterfaceRequest' => [ 'base' => '<p>Contains the parameters for AttachNetworkInterface.</p>', 'refs' => [], ], 'AttachNetworkInterfaceResult' => [ 'base' => '<p>Contains the output of AttachNetworkInterface.</p>', 'refs' => [], ], 'AttachVolumeRequest' => [ 'base' => NULL, 'refs' => [], ], 'AttachVpnGatewayRequest' => [ 'base' => '<p>Contains the parameters for AttachVpnGateway.</p>', 'refs' => [], ], 'AttachVpnGatewayResult' => [ 'base' => '<p>Contains the output of AttachVpnGateway.</p>', 'refs' => [], ], 'AttachmentStatus' => [ 'base' => NULL, 'refs' => [ 'EbsInstanceBlockDevice$Status' => '<p>The attachment state.</p>', 'InstanceNetworkInterfaceAttachment$Status' => '<p>The attachment state.</p>', 'InternetGatewayAttachment$State' => '<p>The current state of the attachment. For an internet gateway, the state is <code>available</code> when attached to a VPC; otherwise, this value is not returned.</p>', 'NetworkInterfaceAttachment$Status' => '<p>The attachment state.</p>', 'VpcAttachment$State' => '<p>The current state of the attachment.</p>', ], ], 'AttributeBooleanValue' => [ 'base' => '<p>Describes a value for a resource attribute that is a Boolean value.</p>', 'refs' => [ 'DescribeNetworkInterfaceAttributeResult$SourceDestCheck' => '<p>Indicates whether source/destination checking is enabled.</p>', 'DescribeVolumeAttributeResult$AutoEnableIO' => '<p>The state of <code>autoEnableIO</code> attribute.</p>', 'DescribeVpcAttributeResult$EnableDnsHostnames' => '<p>Indicates whether the instances launched in the VPC get DNS hostnames. If this attribute is <code>true</code>, instances in the VPC get DNS hostnames; otherwise, they do not.</p>', 'DescribeVpcAttributeResult$EnableDnsSupport' => '<p>Indicates whether DNS resolution is enabled for the VPC. If this attribute is <code>true</code>, the Amazon DNS server resolves DNS hostnames for your instances to their corresponding IP addresses; otherwise, it does not.</p>', 'InstanceAttribute$DisableApiTermination' => '<p>If the value is <code>true</code>, you can\'t terminate the instance through the Amazon EC2 console, CLI, or API; otherwise, you can.</p>', 'InstanceAttribute$EnaSupport' => '<p>Indicates whether enhanced networking with ENA is enabled.</p>', 'InstanceAttribute$EbsOptimized' => '<p>Indicates whether the instance is optimized for Amazon EBS I/O.</p>', 'InstanceAttribute$SourceDestCheck' => '<p>Indicates whether source/destination checking is enabled. A value of <code>true</code> means that checking is enabled, and <code>false</code> means that checking is disabled. This value must be <code>false</code> for a NAT instance to perform NAT.</p>', 'ModifyInstanceAttributeRequest$SourceDestCheck' => '<p>Specifies whether source/destination checking is enabled. A value of <code>true</code> means that checking is enabled, and <code>false</code> means that checking is disabled. This value must be <code>false</code> for a NAT instance to perform NAT.</p>', 'ModifyInstanceAttributeRequest$DisableApiTermination' => '<p>If the value is <code>true</code>, you can\'t terminate the instance using the Amazon EC2 console, CLI, or API; otherwise, you can. You cannot use this parameter for Spot Instances.</p>', 'ModifyInstanceAttributeRequest$EbsOptimized' => '<p>Specifies whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn\'t available with all instance types. Additional usage charges apply when using an EBS Optimized instance.</p>', 'ModifyInstanceAttributeRequest$EnaSupport' => '<p>Set to <code>true</code> to enable enhanced networking with ENA for the instance.</p> <p>This option is supported only for HVM instances. Specifying this option with a PV instance can make it unreachable.</p>', 'ModifyNetworkInterfaceAttributeRequest$SourceDestCheck' => '<p>Indicates whether source/destination checking is enabled. A value of <code>true</code> means checking is enabled, and <code>false</code> means checking is disabled. This value must be <code>false</code> for a NAT instance to perform NAT. For more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html">NAT Instances</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'ModifySubnetAttributeRequest$AssignIpv6AddressOnCreation' => '<p>Specify <code>true</code> to indicate that network interfaces created in the specified subnet should be assigned an IPv6 address. This includes a network interface that\'s created when launching an instance into the subnet (the instance therefore receives an IPv6 address). </p> <p>If you enable the IPv6 addressing feature for your subnet, your network interface or instance only receives an IPv6 address if it\'s created using version <code>2016-11-15</code> or later of the Amazon EC2 API.</p>', 'ModifySubnetAttributeRequest$MapPublicIpOnLaunch' => '<p>Specify <code>true</code> to indicate that network interfaces attached to instances created in the specified subnet should be assigned a public IPv4 address.</p>', 'ModifySubnetAttributeRequest$MapCustomerOwnedIpOnLaunch' => '<p>Specify <code>true</code> to indicate that network interfaces attached to instances created in the specified subnet should be assigned a customer-owned IPv4 address.</p> <p>When this value is <code>true</code>, you must specify the customer-owned IP pool using <code>CustomerOwnedIpv4Pool</code>.</p>', 'ModifyVolumeAttributeRequest$AutoEnableIO' => '<p>Indicates whether the volume should be auto-enabled for I/O operations.</p>', 'ModifyVpcAttributeRequest$EnableDnsHostnames' => '<p>Indicates whether the instances launched in the VPC get DNS hostnames. If enabled, instances in the VPC get DNS hostnames; otherwise, they do not.</p> <p>You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate requests for each attribute. You can only enable DNS hostnames if you\'ve enabled DNS support.</p>', 'ModifyVpcAttributeRequest$EnableDnsSupport' => '<p>Indicates whether the DNS resolution is supported for the VPC. If enabled, queries to the Amazon provided DNS server at the 169.254.169.253 IP address, or the reserved IP address at the base of the VPC network range "plus two" succeed. If disabled, the Amazon provided DNS service in the VPC that resolves public DNS hostnames to IP addresses is not enabled.</p> <p>You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate requests for each attribute.</p>', ], ], 'AttributeValue' => [ 'base' => '<p>Describes a value for a resource attribute that is a String.</p>', 'refs' => [ 'DescribeNetworkInterfaceAttributeResult$Description' => '<p>The description of the network interface.</p>', 'DhcpConfigurationValueList$member' => NULL, 'ImageAttribute$Description' => '<p>A description for the AMI.</p>', 'ImageAttribute$KernelId' => '<p>The kernel ID.</p>', 'ImageAttribute$RamdiskId' => '<p>The RAM disk ID.</p>', 'ImageAttribute$SriovNetSupport' => '<p>Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.</p>', 'InstanceAttribute$InstanceInitiatedShutdownBehavior' => '<p>Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).</p>', 'InstanceAttribute$InstanceType' => '<p>The instance type.</p>', 'InstanceAttribute$KernelId' => '<p>The kernel ID.</p>', 'InstanceAttribute$RamdiskId' => '<p>The RAM disk ID.</p>', 'InstanceAttribute$RootDeviceName' => '<p>The device name of the root device volume (for example, <code>/dev/sda1</code>).</p>', 'InstanceAttribute$SriovNetSupport' => '<p>Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.</p>', 'InstanceAttribute$UserData' => '<p>The user data.</p>', 'ModifyImageAttributeRequest$Description' => '<p>A new description for the AMI.</p>', 'ModifyInstanceAttributeRequest$InstanceInitiatedShutdownBehavior' => '<p>Specifies whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).</p>', 'ModifyInstanceAttributeRequest$InstanceType' => '<p>Changes the instance type to the specified value. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a>. If the instance type is not valid, the error returned is <code>InvalidInstanceAttributeValue</code>.</p>', 'ModifyInstanceAttributeRequest$Kernel' => '<p>Changes the instance\'s kernel to the specified value. We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">PV-GRUB</a>.</p>', 'ModifyInstanceAttributeRequest$Ramdisk' => '<p>Changes the instance\'s RAM disk to the specified value. We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">PV-GRUB</a>.</p>', 'ModifyInstanceAttributeRequest$SriovNetSupport' => '<p>Set to <code>simple</code> to enable enhanced networking with the Intel 82599 Virtual Function interface for the instance.</p> <p>There is no way to disable enhanced networking with the Intel 82599 Virtual Function interface at this time.</p> <p>This option is supported only for HVM instances. Specifying this option with a PV instance can make it unreachable.</p>', 'ModifyNetworkInterfaceAttributeRequest$Description' => '<p>A description for the network interface.</p>', ], ], 'AuthorizationRule' => [ 'base' => '<p>Information about an authorization rule.</p>', 'refs' => [ 'AuthorizationRuleSet$member' => NULL, ], ], 'AuthorizationRuleSet' => [ 'base' => NULL, 'refs' => [ 'DescribeClientVpnAuthorizationRulesResult$AuthorizationRules' => '<p>Information about the authorization rules.</p>', ], ], 'AuthorizeClientVpnIngressRequest' => [ 'base' => NULL, 'refs' => [], ], 'AuthorizeClientVpnIngressResult' => [ 'base' => NULL, 'refs' => [], ], 'AuthorizeSecurityGroupEgressRequest' => [ 'base' => NULL, 'refs' => [], ], 'AuthorizeSecurityGroupIngressRequest' => [ 'base' => NULL, 'refs' => [], ], 'AutoAcceptSharedAttachmentsValue' => [ 'base' => NULL, 'refs' => [ 'TransitGatewayOptions$AutoAcceptSharedAttachments' => '<p>Indicates whether attachment requests are automatically accepted.</p>', 'TransitGatewayRequestOptions$AutoAcceptSharedAttachments' => '<p>Enable or disable automatic acceptance of attachment requests. Disabled by default.</p>', ], ], 'AutoPlacement' => [ 'base' => NULL, 'refs' => [ 'AllocateHostsRequest$AutoPlacement' => '<p>Indicates whether the host accepts any untargeted instance launches that match its instance type configuration, or if it only accepts Host tenancy instance launches that specify its unique host ID. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding"> Understanding Instance Placement and Host Affinity</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p> <p>Default: <code>on</code> </p>', 'Host$AutoPlacement' => '<p>Whether auto-placement is on or off.</p>', 'ModifyHostsRequest$AutoPlacement' => '<p>Specify whether to enable or disable auto-placement.</p>', ], ], 'AutoRecoveryFlag' => [ 'base' => NULL, 'refs' => [ 'InstanceTypeInfo$AutoRecoverySupported' => '<p>Indicates whether auto recovery is supported.</p>', ], ], 'AvailabilityZone' => [ 'base' => '<p>Describes Availability Zones, Local Zones, and Wavelength Zones.</p>', 'refs' => [ 'AvailabilityZoneList$member' => NULL, ], ], 'AvailabilityZoneList' => [ 'base' => NULL, 'refs' => [ 'DescribeAvailabilityZonesResult$AvailabilityZones' => '<p>Information about the Availability Zones, Local Zones, and Wavelength Zones.</p>', ], ], 'AvailabilityZoneMessage' => [ 'base' => '<p>Describes a message about an Availability Zone, Local Zone, or Wavelength Zone.</p>', 'refs' => [ 'AvailabilityZoneMessageList$member' => NULL, ], ], 'AvailabilityZoneMessageList' => [ 'base' => NULL, 'refs' => [ 'AvailabilityZone$Messages' => '<p>Any messages about the Availability Zone, Local Zone, or Wavelength Zone.</p>', ], ], 'AvailabilityZoneOptInStatus' => [ 'base' => NULL, 'refs' => [ 'AvailabilityZone$OptInStatus' => '<p>For Availability Zones, this parameter always has the value of <code>opt-in-not-required</code>.</p> <p>For Local Zones and Wavelength Zones, this parameter is the opt-in status. The possible values are <code>opted-in</code>, and <code>not-opted-in</code>.</p>', ], ], 'AvailabilityZoneState' => [ 'base' => NULL, 'refs' => [ 'AvailabilityZone$State' => '<p>The state of the Availability Zone, Local Zone, or Wavelength Zone.</p>', ], ], 'AvailabilityZoneStringList' => [ 'base' => NULL, 'refs' => [ 'DisableFastSnapshotRestoresRequest$AvailabilityZones' => '<p>One or more Availability Zones. For example, <code>us-east-2a</code>.</p>', 'EnableFastSnapshotRestoresRequest$AvailabilityZones' => '<p>One or more Availability Zones. For example, <code>us-east-2a</code>.</p>', ], ], 'AvailableCapacity' => [ 'base' => '<p>The capacity information for instances that can be launched onto the Dedicated Host. </p>', 'refs' => [ 'Host$AvailableCapacity' => '<p>Information about the instances running on the Dedicated Host.</p>', ], ], 'AvailableInstanceCapacityList' => [ 'base' => NULL, 'refs' => [ 'AvailableCapacity$AvailableInstanceCapacity' => '<p>The number of instances that can be launched onto the Dedicated Host depending on the host\'s available capacity. For Dedicated Hosts that support multiple instance types, this parameter represents the number of instances for each instance size that is supported on the host.</p>', ], ], 'BareMetalFlag' => [ 'base' => NULL, 'refs' => [ 'InstanceTypeInfo$BareMetal' => '<p>Indicates whether the instance is bare metal.</p>', ], ], 'BaselineBandwidthInMbps' => [ 'base' => NULL, 'refs' => [ 'EbsOptimizedInfo$BaselineBandwidthInMbps' => '<p>The baseline bandwidth performance for an EBS-optimized instance type, in Mbps.</p>', ], ], 'BaselineIops' => [ 'base' => NULL, 'refs' => [ 'EbsOptimizedInfo$BaselineIops' => '<p>The baseline input/output storage operations per seconds for an EBS-optimized instance type.</p>', ], ], 'BaselineThroughputInMBps' => [ 'base' => NULL, 'refs' => [ 'EbsOptimizedInfo$BaselineThroughputInMBps' => '<p>The baseline throughput performance for an EBS-optimized instance type, in MBps.</p>', ], ], 'BatchState' => [ 'base' => NULL, 'refs' => [ 'CancelSpotFleetRequestsSuccessItem$CurrentSpotFleetRequestState' => '<p>The current state of the Spot Fleet request.</p>', 'CancelSpotFleetRequestsSuccessItem$PreviousSpotFleetRequestState' => '<p>The previous state of the Spot Fleet request.</p>', 'SpotFleetRequestConfig$SpotFleetRequestState' => '<p>The state of the Spot Fleet request.</p>', ], ], 'BillingProductList' => [ 'base' => NULL, 'refs' => [ 'RegisterImageRequest$BillingProducts' => '<p>The billing product codes. Your account must be authorized to specify billing product codes. Otherwise, you can use the AWS Marketplace to bill for the use of an AMI.</p>', ], ], 'Blob' => [ 'base' => NULL, 'refs' => [ 'BlobAttributeValue$Value' => NULL, 'ImportKeyPairRequest$PublicKeyMaterial' => '<p>The public key. For API calls, the text must be base64-encoded. For command line tools, base64 encoding is performed for you.</p>', 'S3Storage$UploadPolicy' => '<p>An Amazon S3 upload policy that gives Amazon EC2 permission to upload items into Amazon S3 on your behalf.</p>', ], ], 'BlobAttributeValue' => [ 'base' => NULL, 'refs' => [ 'ModifyInstanceAttributeRequest$UserData' => '<p>Changes the instance\'s user data to the specified value. If you are using an AWS SDK or command line tool, base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide base64-encoded text.</p>', ], ], 'BlockDeviceMapping' => [ 'base' => '<p>Describes a block device mapping.</p>', 'refs' => [ 'BlockDeviceMappingList$member' => NULL, 'BlockDeviceMappingRequestList$member' => NULL, ], ], 'BlockDeviceMappingList' => [ 'base' => NULL, 'refs' => [ 'Image$BlockDeviceMappings' => '<p>Any block device mapping entries.</p>', 'ImageAttribute$BlockDeviceMappings' => '<p>The block device mapping entries.</p>', 'LaunchSpecification$BlockDeviceMappings' => '<p>One or more block device mapping entries.</p>', 'RequestSpotLaunchSpecification$BlockDeviceMappings' => '<p>One or more block device mapping entries. You can\'t specify both a snapshot ID and an encryption value. This is because only blank volumes can be encrypted on creation. If a snapshot is the basis for a volume, it is not blank and its encryption status is used for the volume encryption status.</p>', 'SpotFleetLaunchSpecification$BlockDeviceMappings' => '<p>One or more block devices that are mapped to the Spot Instances. You can\'t specify both a snapshot ID and an encryption value. This is because only blank volumes can be encrypted on creation. If a snapshot is the basis for a volume, it is not blank and its encryption status is used for the volume encryption status.</p>', ], ], 'BlockDeviceMappingRequestList' => [ 'base' => NULL, 'refs' => [ 'CreateImageRequest$BlockDeviceMappings' => '<p>The block device mappings. This parameter cannot be used to modify the encryption status of existing volumes or snapshots. To create an AMI with encrypted snapshots, use the <a>CopyImage</a> action.</p>', 'RegisterImageRequest$BlockDeviceMappings' => '<p>The block device mapping entries.</p>', 'RunInstancesRequest$BlockDeviceMappings' => '<p>The block device mapping entries.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AcceptReservedInstancesExchangeQuoteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AcceptTransitGatewayPeeringAttachmentRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AcceptTransitGatewayVpcAttachmentRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AcceptVpcEndpointConnectionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AcceptVpcPeeringConnectionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AdvertiseByoipCidrRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AllocateAddressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ApplySecurityGroupsToClientVpnTargetNetworkRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AssignPrivateIpAddressesRequest$AllowReassignment' => '<p>Indicates whether to allow an IP address that is already assigned to another network interface or instance to be reassigned to the specified network interface.</p>', 'AssociateAddressRequest$AllowReassociation' => '<p>[EC2-VPC] For a VPC in an EC2-Classic account, specify true to allow an Elastic IP address that is already associated with an instance or network interface to be reassociated with the specified instance or network interface. Otherwise, the operation fails. In a VPC in an EC2-VPC-only account, reassociation is automatic, therefore you can specify false to ensure the operation fails if the Elastic IP address is already associated with another resource.</p>', 'AssociateAddressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AssociateClientVpnTargetNetworkRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AssociateDhcpOptionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AssociateRouteTableRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AssociateTransitGatewayMulticastDomainRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AssociateTransitGatewayRouteTableRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AssociateVpcCidrBlockRequest$AmazonProvidedIpv6CidrBlock' => '<p>Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IPv6 addresses, or the size of the CIDR block.</p>', 'AttachClassicLinkVpcRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AttachClassicLinkVpcResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'AttachInternetGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AttachNetworkInterfaceRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AttachVolumeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AttachVpnGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AttributeBooleanValue$Value' => '<p>The attribute value. The valid values are <code>true</code> or <code>false</code>.</p>', 'AuthorizationRule$AccessAll' => '<p>Indicates whether the authorization rule grants access to all clients.</p>', 'AuthorizeClientVpnIngressRequest$AuthorizeAllGroups' => '<p>Indicates whether to grant access to all clients. Specify <code>true</code> to grant all clients who successfully establish a VPN connection access to the network. Must be set to <code>true</code> if <code>AccessGroupId</code> is not specified.</p>', 'AuthorizeClientVpnIngressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AuthorizeSecurityGroupEgressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'AuthorizeSecurityGroupIngressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'BundleInstanceRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CancelBundleTaskRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CancelCapacityReservationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CancelCapacityReservationResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'CancelConversionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CancelImportTaskRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CancelSpotFleetRequestsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CancelSpotFleetRequestsRequest$TerminateInstances' => '<p>Indicates whether to terminate instances for a Spot Fleet request if it is canceled successfully.</p>', 'CancelSpotInstanceRequestsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CapacityReservation$EbsOptimized' => '<p>Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn\'t available with all instance types. Additional usage charges apply when using an EBS- optimized instance.</p>', 'CapacityReservation$EphemeralStorage' => '<p>Indicates whether the Capacity Reservation supports instances with temporary, block-level storage.</p>', 'ClassicLinkDnsSupport$ClassicLinkDnsSupported' => '<p>Indicates whether ClassicLink DNS support is enabled for the VPC.</p>', 'ClientVpnEndpoint$SplitTunnel' => '<p>Indicates whether split-tunnel is enabled in the AWS Client VPN endpoint.</p> <p>For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-Tunnel AWS Client VPN Endpoint</a> in the <i>AWS Client VPN Administrator Guide</i>.</p>', 'ConfirmProductInstanceRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ConfirmProductInstanceResult$Return' => '<p>The return value of the request. Returns <code>true</code> if the specified product code is owned by the requester and associated with the specified instance.</p>', 'ConnectionLogOptions$Enabled' => '<p>Indicates whether connection logging is enabled.</p>', 'ConnectionLogResponseOptions$Enabled' => '<p>Indicates whether client connection logging is enabled for the Client VPN endpoint.</p>', 'CopyFpgaImageRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CopyImageRequest$Encrypted' => '<p>Specifies whether the destination snapshots of the copied image should be encrypted. You can encrypt a copy of an unencrypted snapshot, but you cannot create an unencrypted copy of an encrypted snapshot. The default CMK for EBS is used unless you specify a non-default AWS Key Management Service (AWS KMS) CMK using <code>KmsKeyId</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CopyImageRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CopySnapshotRequest$Encrypted' => '<p>To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption using this parameter. Otherwise, omit this parameter. Encrypted snapshots are encrypted, even if you omit this parameter and encryption by default is not enabled. You cannot set this parameter to false. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CopySnapshotRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateCapacityReservationRequest$EbsOptimized' => '<p>Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn\'t available with all instance types. Additional usage charges apply when using an EBS- optimized instance.</p>', 'CreateCapacityReservationRequest$EphemeralStorage' => '<p>Indicates whether the Capacity Reservation supports instances with temporary, block-level storage.</p>', 'CreateCapacityReservationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateCarrierGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateClientVpnEndpointRequest$SplitTunnel' => '<p>Indicates whether split-tunnel is enabled on the AWS Client VPN endpoint.</p> <p>By default, split-tunnel on a VPN endpoint is disabled.</p> <p>For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-Tunnel AWS Client VPN Endpoint</a> in the <i>AWS Client VPN Administrator Guide</i>.</p>', 'CreateClientVpnEndpointRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateClientVpnRouteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateCustomerGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateDefaultSubnetRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateDefaultVpcRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateDhcpOptionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateEgressOnlyInternetGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateFleetRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateFleetRequest$TerminateInstancesWithExpiration' => '<p>Indicates whether running instances should be terminated when the EC2 Fleet expires.</p>', 'CreateFleetRequest$ReplaceUnhealthyInstances' => '<p>Indicates whether EC2 Fleet should replace unhealthy instances.</p>', 'CreateFlowLogsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateFpgaImageRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateImageRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateImageRequest$NoReboot' => '<p>By default, Amazon EC2 attempts to shut down and reboot the instance before creating the image. If the \'No Reboot\' option is set, Amazon EC2 doesn\'t shut down the instance before creating the image. When this option is used, file system integrity on the created image can\'t be guaranteed.</p>', 'CreateInternetGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateKeyPairRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateLaunchTemplateRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateLaunchTemplateVersionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateLocalGatewayRouteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateLocalGatewayRouteTableVpcAssociationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateManagedPrefixListRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateNatGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateNetworkAclEntryRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateNetworkAclEntryRequest$Egress' => '<p>Indicates whether this is an egress rule (rule is applied to traffic leaving the subnet).</p>', 'CreateNetworkAclRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateNetworkInterfacePermissionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateNetworkInterfaceRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreatePlacementGroupRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateRouteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateRouteResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'CreateRouteTableRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateSecurityGroupRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateSnapshotRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateSnapshotsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateSpotDatafeedSubscriptionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateSubnetRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateTagsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateTrafficMirrorFilterRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateTrafficMirrorFilterRuleRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateTrafficMirrorSessionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateTrafficMirrorTargetRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateTransitGatewayMulticastDomainRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateTransitGatewayPeeringAttachmentRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateTransitGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateTransitGatewayRouteRequest$Blackhole' => '<p>Indicates whether to drop traffic that matches this route.</p>', 'CreateTransitGatewayRouteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateTransitGatewayRouteTableRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateTransitGatewayVpcAttachmentRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateVolumeRequest$Encrypted' => '<p>Specifies whether the volume should be encrypted. The effect of setting the encryption state to <code>true</code> depends on the volume origin (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is enabled. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-by-default">Encryption by Default</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>Encrypted Amazon EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances">Supported Instance Types</a>.</p>', 'CreateVolumeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateVolumeRequest$MultiAttachEnabled' => '<p>Specifies whether to enable Amazon EBS Multi-Attach. If you enable Multi-Attach, you can attach the volume to up to 16 <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based instances</a> in the same Availability Zone. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volumes-multi.html"> Amazon EBS Multi-Attach</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'CreateVpcEndpointConnectionNotificationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateVpcEndpointRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateVpcEndpointRequest$PrivateDnsEnabled' => '<p>(Interface endpoint) Indicates whether to associate a private hosted zone with the specified VPC. The private hosted zone contains a record set for the default public DNS name for the service for the Region (for example, <code>kinesis.us-east-1.amazonaws.com</code>), which resolves to the private IP addresses of the endpoint network interfaces in the VPC. This enables you to make requests to the default public DNS name for the service instead of the public DNS names that are automatically generated by the VPC endpoint service.</p> <p>To use a private hosted zone, you must set the following VPC attributes to <code>true</code>: <code>enableDnsHostnames</code> and <code>enableDnsSupport</code>. Use <a>ModifyVpcAttribute</a> to set the VPC attributes.</p> <p>Default: <code>true</code> </p>', 'CreateVpcEndpointServiceConfigurationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateVpcEndpointServiceConfigurationRequest$AcceptanceRequired' => '<p>Indicates whether requests from service consumers to create an endpoint to your service must be accepted. To accept a request, use <a>AcceptVpcEndpointConnections</a>.</p>', 'CreateVpcPeeringConnectionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateVpcRequest$AmazonProvidedIpv6CidrBlock' => '<p>Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IP addresses, or the size of the CIDR block.</p>', 'CreateVpcRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateVpnConnectionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'CreateVpnGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteCarrierGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteClientVpnEndpointRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteClientVpnRouteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteCustomerGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteDhcpOptionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteEgressOnlyInternetGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteEgressOnlyInternetGatewayResult$ReturnCode' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'DeleteFleetsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteFleetsRequest$TerminateInstances' => '<p>Indicates whether to terminate instances for an EC2 Fleet if it is deleted successfully.</p>', 'DeleteFlowLogsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteFpgaImageRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteFpgaImageResult$Return' => '<p>Is <code>true</code> if the request succeeds, and an error otherwise.</p>', 'DeleteInternetGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteKeyPairRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteLaunchTemplateRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteLaunchTemplateVersionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteLocalGatewayRouteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteLocalGatewayRouteTableVpcAssociationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteManagedPrefixListRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteNatGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteNetworkAclEntryRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteNetworkAclEntryRequest$Egress' => '<p>Indicates whether the rule is an egress rule.</p>', 'DeleteNetworkAclRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteNetworkInterfacePermissionRequest$Force' => '<p>Specify <code>true</code> to remove the permission even if the network interface is attached to an instance.</p>', 'DeleteNetworkInterfacePermissionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteNetworkInterfacePermissionResult$Return' => '<p>Returns <code>true</code> if the request succeeds, otherwise returns an error.</p>', 'DeleteNetworkInterfaceRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeletePlacementGroupRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteQueuedReservedInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteRouteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteRouteTableRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteSecurityGroupRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteSnapshotRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteSpotDatafeedSubscriptionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteSubnetRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteTagsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteTrafficMirrorFilterRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteTrafficMirrorFilterRuleRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteTrafficMirrorSessionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteTrafficMirrorTargetRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteTransitGatewayMulticastDomainRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteTransitGatewayPeeringAttachmentRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteTransitGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteTransitGatewayRouteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteTransitGatewayRouteTableRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteTransitGatewayVpcAttachmentRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteVolumeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteVpcEndpointConnectionNotificationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteVpcEndpointServiceConfigurationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteVpcEndpointsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteVpcPeeringConnectionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteVpcPeeringConnectionResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'DeleteVpcRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteVpnConnectionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeleteVpnGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeprovisionByoipCidrRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeregisterImageRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeregisterInstanceEventNotificationAttributesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeregisterInstanceTagAttributeRequest$IncludeAllTagsOfInstance' => '<p>Indicates whether to deregister all tag keys in the current Region. Specify <code>false</code> to deregister all tag keys.</p>', 'DeregisterTransitGatewayMulticastGroupMembersRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DeregisterTransitGatewayMulticastGroupSourcesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeAccountAttributesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeAddressesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeAggregateIdFormatRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeAggregateIdFormatResult$UseLongIdsAggregated' => '<p>Indicates whether all resource types in the Region are configured to use longer IDs. This value is only <code>true</code> if all users are configured to use longer IDs for all resources types in the Region.</p>', 'DescribeAvailabilityZonesRequest$AllAvailabilityZones' => '<p>Include all Availability Zones, Local Zones, and Wavelength Zones regardless of your opt-in status.</p> <p>If you do not use this parameter, the results include only the zones for the Regions where you have chosen the option to opt in.</p>', 'DescribeAvailabilityZonesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeBundleTasksRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeByoipCidrsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeCapacityReservationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeCarrierGatewaysRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeClassicLinkInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeClientVpnAuthorizationRulesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeClientVpnConnectionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeClientVpnEndpointsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeClientVpnRoutesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeClientVpnTargetNetworksRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeCoipPoolsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeConversionTasksRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeCustomerGatewaysRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeDhcpOptionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeEgressOnlyInternetGatewaysRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeElasticGpusRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeExportImageTasksRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeFastSnapshotRestoresRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeFleetHistoryRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeFleetInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeFleetsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeFlowLogsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeFpgaImageAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeFpgaImagesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeImageAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeImagesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeImportImageTasksRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeImportSnapshotTasksRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeInstanceAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeInstanceCreditSpecificationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeInstanceEventNotificationAttributesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeInstanceStatusRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeInstanceStatusRequest$IncludeAllInstances' => '<p>When <code>true</code>, includes the health status for all instances. When <code>false</code>, includes the health status for running instances only.</p> <p>Default: <code>false</code> </p>', 'DescribeInstanceTypeOfferingsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeInstanceTypesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeInternetGatewaysRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeIpv6PoolsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeKeyPairsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeLaunchTemplateVersionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeLaunchTemplatesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeLocalGatewayRouteTableVpcAssociationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeLocalGatewayRouteTablesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeLocalGatewayVirtualInterfaceGroupsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeLocalGatewayVirtualInterfacesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeLocalGatewaysRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeManagedPrefixListsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeMovingAddressesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeNatGatewaysRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeNetworkAclsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeNetworkInterfaceAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeNetworkInterfacesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribePlacementGroupsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribePrefixListsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribePrincipalIdFormatRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeRegionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeRegionsRequest$AllRegions' => '<p>Indicates whether to display all Regions, including Regions that are disabled for your account.</p>', 'DescribeReservedInstancesOfferingsRequest$IncludeMarketplace' => '<p>Include Reserved Instance Marketplace offerings in the response.</p>', 'DescribeReservedInstancesOfferingsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeReservedInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeRouteTablesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeScheduledInstanceAvailabilityRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeScheduledInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSecurityGroupReferencesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSecurityGroupsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSnapshotAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSnapshotsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSpotDatafeedSubscriptionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSpotFleetInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSpotFleetRequestHistoryRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSpotFleetRequestsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSpotInstanceRequestsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSpotPriceHistoryRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeStaleSecurityGroupsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeSubnetsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeTagsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeTrafficMirrorFiltersRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeTrafficMirrorSessionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeTrafficMirrorTargetsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeTransitGatewayAttachmentsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeTransitGatewayMulticastDomainsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeTransitGatewayPeeringAttachmentsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeTransitGatewayRouteTablesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeTransitGatewayVpcAttachmentsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeTransitGatewaysRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVolumeAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVolumeStatusRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVolumesModificationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVolumesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpcAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpcClassicLinkRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpcEndpointConnectionNotificationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpcEndpointConnectionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpcEndpointServiceConfigurationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpcEndpointServicePermissionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpcEndpointServicesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpcEndpointsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpcPeeringConnectionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpcsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpnConnectionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DescribeVpnGatewaysRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DetachClassicLinkVpcRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DetachClassicLinkVpcResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'DetachInternetGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DetachNetworkInterfaceRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DetachNetworkInterfaceRequest$Force' => '<p>Specifies whether to force a detachment.</p> <note> <ul> <li> <p>Use the <code>Force</code> parameter only as a last resort to detach a network interface from a failed instance. </p> </li> <li> <p>If you use the <code>Force</code> parameter to detach a network interface, you might not be able to attach a different network interface to the same index on the instance without first stopping and starting the instance.</p> </li> <li> <p>If you force the detachment of a network interface, the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">instance metadata</a> might not get updated. This means that the attributes associated with the detached network interface might still be visible. The instance metadata will get updated when you stop and start the instance.</p> </li> </ul> </note>', 'DetachVolumeRequest$Force' => '<p>Forces detachment if the previous detachment attempt did not occur cleanly (for example, logging into an instance, unmounting the volume, and detaching normally). This option can lead to data loss or a corrupted file system. Use this option only as a last resort to detach a volume from a failed instance. The instance won\'t have an opportunity to flush file system caches or file system metadata. If you use this option, you must perform file system check and repair procedures.</p>', 'DetachVolumeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DetachVpnGatewayRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisableEbsEncryptionByDefaultRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisableEbsEncryptionByDefaultResult$EbsEncryptionByDefault' => '<p>The updated status of encryption by default.</p>', 'DisableFastSnapshotRestoresRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisableTransitGatewayRouteTablePropagationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisableVgwRoutePropagationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisableVpcClassicLinkDnsSupportResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'DisableVpcClassicLinkRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisableVpcClassicLinkResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'DisassociateAddressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisassociateClientVpnTargetNetworkRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisassociateRouteTableRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisassociateTransitGatewayMulticastDomainRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DisassociateTransitGatewayRouteTableRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'DnsServersOptionsModifyStructure$Enabled' => '<p>Indicates whether DNS servers should be used. Specify <code>False</code> to delete the existing DNS servers.</p>', 'EbsBlockDevice$DeleteOnTermination' => '<p>Indicates whether the EBS volume is deleted on instance termination. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#preserving-volumes-on-termination">Preserving Amazon EBS volumes on instance termination</a> in the Amazon Elastic Compute Cloud User Guide.</p>', 'EbsBlockDevice$Encrypted' => '<p>Indicates whether the encryption state of an EBS volume is changed while being restored from a backing snapshot. The effect of setting the encryption state to <code>true</code> depends on the volume origin (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is enabled. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-parameters">Amazon EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>In no case can you remove encryption from an encrypted volume.</p> <p>Encrypted volumes can only be attached to instances that support Amazon EBS encryption. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances">Supported instance types</a>.</p> <p>This parameter is not returned by .</p>', 'EbsInstanceBlockDevice$DeleteOnTermination' => '<p>Indicates whether the volume is deleted on instance termination.</p>', 'EbsInstanceBlockDeviceSpecification$DeleteOnTermination' => '<p>Indicates whether the volume is deleted on instance termination.</p>', 'EnableEbsEncryptionByDefaultRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'EnableEbsEncryptionByDefaultResult$EbsEncryptionByDefault' => '<p>The updated status of encryption by default.</p>', 'EnableFastSnapshotRestoresRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'EnableTransitGatewayRouteTablePropagationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'EnableVgwRoutePropagationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'EnableVolumeIORequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'EnableVpcClassicLinkDnsSupportResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'EnableVpcClassicLinkRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'EnableVpcClassicLinkResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'ExportClientVpnClientCertificateRevocationListRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ExportClientVpnClientConfigurationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ExportImageRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ExportTransitGatewayRoutesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'FleetData$TerminateInstancesWithExpiration' => '<p>Indicates whether running instances should be terminated when the EC2 Fleet expires. </p>', 'FleetData$ReplaceUnhealthyInstances' => '<p>Indicates whether EC2 Fleet should replace unhealthy instances.</p>', 'FpgaImage$Public' => '<p>Indicates whether the AFI is public.</p>', 'FpgaImage$DataRetentionSupport' => '<p>Indicates whether data retention support is enabled for the AFI.</p>', 'GetAssociatedIpv6PoolCidrsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetCapacityReservationUsageRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetCoipPoolUsageRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetConsoleOutputRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetConsoleOutputRequest$Latest' => '<p>When enabled, retrieves the latest console output for the instance.</p> <p>Default: disabled (<code>false</code>)</p>', 'GetConsoleScreenshotRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetConsoleScreenshotRequest$WakeUp' => '<p>When set to <code>true</code>, acts as keystroke input and wakes up an instance that\'s in standby or "sleep" mode.</p>', 'GetDefaultCreditSpecificationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetEbsDefaultKmsKeyIdRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetEbsEncryptionByDefaultRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetEbsEncryptionByDefaultResult$EbsEncryptionByDefault' => '<p>Indicates whether encryption by default is enabled.</p>', 'GetGroupsForCapacityReservationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetLaunchTemplateDataRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetManagedPrefixListAssociationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetManagedPrefixListEntriesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetPasswordDataRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetReservedInstancesExchangeQuoteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetReservedInstancesExchangeQuoteResult$IsValidExchange' => '<p>If <code>true</code>, the exchange is valid. If <code>false</code>, the exchange cannot be completed.</p>', 'GetTransitGatewayAttachmentPropagationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetTransitGatewayMulticastDomainAssociationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetTransitGatewayRouteTableAssociationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'GetTransitGatewayRouteTablePropagationsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'HibernationOptions$Configured' => '<p>If this parameter is set to <code>true</code>, your instance is enabled for hibernation; otherwise, it is not enabled for hibernation.</p>', 'HibernationOptionsRequest$Configured' => '<p>If you set this parameter to <code>true</code>, your instance is enabled for hibernation.</p> <p>Default: <code>false</code> </p>', 'Host$MemberOfServiceLinkedResourceGroup' => '<p>Indicates whether the Dedicated Host is in a host resource group. If <b>memberOfServiceLinkedResourceGroup</b> is <code>true</code>, the host is in a host resource group; otherwise, it is not.</p>', 'IdFormat$UseLongIds' => '<p>Indicates whether longer IDs (17-character IDs) are enabled for the resource.</p>', 'Image$Public' => '<p>Indicates whether the image has public launch permissions. The value is <code>true</code> if this image has public launch permissions or <code>false</code> if it has only implicit and explicit launch permissions.</p>', 'Image$EnaSupport' => '<p>Specifies whether enhanced networking with ENA is enabled.</p>', 'ImportClientVpnClientCertificateRevocationListRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ImportClientVpnClientCertificateRevocationListResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'ImportImageRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ImportImageRequest$Encrypted' => '<p>Specifies whether the destination AMI of the imported image should be encrypted. The default CMK for EBS is used unless you specify a non-default AWS Key Management Service (AWS KMS) CMK using <code>KmsKeyId</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'ImportImageResult$Encrypted' => '<p>Indicates whether the AMI is encrypted.</p>', 'ImportImageTask$Encrypted' => '<p>Indicates whether the image is encrypted.</p>', 'ImportInstanceLaunchSpecification$Monitoring' => '<p>Indicates whether monitoring is enabled.</p>', 'ImportInstanceRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ImportKeyPairRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ImportSnapshotRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ImportSnapshotRequest$Encrypted' => '<p>Specifies whether the destination snapshot of the imported image should be encrypted. The default CMK for EBS is used unless you specify a non-default AWS Key Management Service (AWS KMS) CMK using <code>KmsKeyId</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'ImportVolumeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'Instance$EbsOptimized' => '<p>Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn\'t available with all instance types. Additional usage charges apply when using an EBS Optimized instance.</p>', 'Instance$EnaSupport' => '<p>Specifies whether enhanced networking with ENA is enabled.</p>', 'Instance$SourceDestCheck' => '<p>Specifies whether to enable an instance launched in a VPC to perform NAT. This controls whether source/destination checking is enabled on the instance. A value of <code>true</code> means that checking is enabled, and <code>false</code> means that checking is disabled. The value must be <code>false</code> for the instance to perform NAT. For more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html">NAT Instances</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'InstanceNetworkInterface$SourceDestCheck' => '<p>Indicates whether to validate network traffic to or from this network interface.</p>', 'InstanceNetworkInterfaceAttachment$DeleteOnTermination' => '<p>Indicates whether the network interface is deleted when the instance is terminated.</p>', 'InstanceNetworkInterfaceSpecification$AssociatePublicIpAddress' => '<p>Indicates whether to assign a public IPv4 address to an instance you launch in a VPC. The public IP address can only be assigned to a network interface for eth0, and can only be assigned to a new network interface, not an existing one. You cannot specify more than one network interface in the request. If launching into a default subnet, the default value is <code>true</code>.</p>', 'InstanceNetworkInterfaceSpecification$DeleteOnTermination' => '<p>If set to <code>true</code>, the interface is deleted when the instance is terminated. You can specify <code>true</code> only if creating a new network interface when launching an instance.</p>', 'InstanceNetworkInterfaceSpecification$AssociateCarrierIpAddress' => '<p>Indicates whether to assign a carrier IP address to the network interface.</p> <p>You can only assign a carrier IP address to a network interface that is in a subnet in a Wavelength Zone. For more information about carrier IP addresses, see Carrier IP addresses in the AWS Wavelength Developer Guide.</p>', 'InstancePrivateIpAddress$Primary' => '<p>Indicates whether this IPv4 address is the primary private IP address of the network interface.</p>', 'InstanceSpecification$ExcludeBootVolume' => '<p>Excludes the root volume from being snapshotted.</p>', 'InstanceTagNotificationAttribute$IncludeAllTagsOfInstance' => '<p>Indicates wheter all tag keys in the current Region are registered to appear in scheduled event notifications. <code>true</code> indicates that all tag keys in the current Region are registered.</p>', 'LaunchSpecification$EbsOptimized' => '<p>Indicates whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn\'t available with all instance types. Additional usage charges apply when using an EBS Optimized instance.</p> <p>Default: <code>false</code> </p>', 'LaunchTemplateEbsBlockDevice$Encrypted' => '<p>Indicates whether the EBS volume is encrypted.</p>', 'LaunchTemplateEbsBlockDevice$DeleteOnTermination' => '<p>Indicates whether the EBS volume is deleted on instance termination.</p>', 'LaunchTemplateEbsBlockDeviceRequest$Encrypted' => '<p>Indicates whether the EBS volume is encrypted. Encrypted volumes can only be attached to instances that support Amazon EBS encryption. If you are creating a volume from a snapshot, you can\'t specify an encryption value.</p>', 'LaunchTemplateEbsBlockDeviceRequest$DeleteOnTermination' => '<p>Indicates whether the EBS volume is deleted on instance termination.</p>', 'LaunchTemplateHibernationOptions$Configured' => '<p>If this parameter is set to <code>true</code>, the instance is enabled for hibernation; otherwise, it is not enabled for hibernation.</p>', 'LaunchTemplateHibernationOptionsRequest$Configured' => '<p>If you set this parameter to <code>true</code>, the instance is enabled for hibernation.</p> <p>Default: <code>false</code> </p>', 'LaunchTemplateInstanceNetworkInterfaceSpecification$AssociateCarrierIpAddress' => '<p>Indicates whether to associate a Carrier IP address with eth0 for a new network interface.</p> <p>Use this option when you launch an instance in a Wavelength Zone and want to associate a Carrier IP address with the network interface. For more information about Carrier IP addresses, see <a href="https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip">Carrier IP addresses</a> in the <i>AWS Wavelength Developer Guide</i>.</p>', 'LaunchTemplateInstanceNetworkInterfaceSpecification$AssociatePublicIpAddress' => '<p>Indicates whether to associate a public IPv4 address with eth0 for a new network interface.</p>', 'LaunchTemplateInstanceNetworkInterfaceSpecification$DeleteOnTermination' => '<p>Indicates whether the network interface is deleted when the instance is terminated.</p>', 'LaunchTemplateInstanceNetworkInterfaceSpecificationRequest$AssociateCarrierIpAddress' => '<p>Associates a Carrier IP address with eth0 for a new network interface.</p> <p>Use this option when you launch an instance in a Wavelength Zone and want to associate a Carrier IP address with the network interface. For more information about Carrier IP addresses, see <a href="https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip">Carrier IP addresses</a> in the <i>AWS Wavelength Developer Guide</i>.</p>', 'LaunchTemplateInstanceNetworkInterfaceSpecificationRequest$AssociatePublicIpAddress' => '<p>Associates a public IPv4 address with eth0 for a new network interface.</p>', 'LaunchTemplateInstanceNetworkInterfaceSpecificationRequest$DeleteOnTermination' => '<p>Indicates whether the network interface is deleted when the instance is terminated.</p>', 'LaunchTemplateVersion$DefaultVersion' => '<p>Indicates whether the version is the default version.</p>', 'LaunchTemplatesMonitoring$Enabled' => '<p>Indicates whether detailed monitoring is enabled. Otherwise, basic monitoring is enabled.</p>', 'LaunchTemplatesMonitoringRequest$Enabled' => '<p>Specify <code>true</code> to enable detailed monitoring. Otherwise, basic monitoring is enabled.</p>', 'ModifyAvailabilityZoneGroupRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyAvailabilityZoneGroupResult$Return' => '<p>Is <code>true</code> if the request succeeds, and an error otherwise.</p>', 'ModifyCapacityReservationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyCapacityReservationResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'ModifyClientVpnEndpointRequest$SplitTunnel' => '<p>Indicates whether the VPN is split-tunnel.</p> <p>For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-Tunnel AWS Client VPN Endpoint</a> in the <i>AWS Client VPN Administrator Guide</i>.</p>', 'ModifyClientVpnEndpointRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyClientVpnEndpointResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'ModifyDefaultCreditSpecificationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyEbsDefaultKmsKeyIdRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyFleetRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyFleetResult$Return' => '<p>Is <code>true</code> if the request succeeds, and an error otherwise.</p>', 'ModifyFpgaImageAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyIdFormatRequest$UseLongIds' => '<p>Indicate whether the resource should use longer IDs (17-character IDs).</p>', 'ModifyIdentityIdFormatRequest$UseLongIds' => '<p>Indicates whether the resource should use longer IDs (17-character IDs)</p>', 'ModifyImageAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyInstanceAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyInstanceCapacityReservationAttributesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyInstanceCapacityReservationAttributesResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'ModifyInstanceCreditSpecificationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyInstanceEventStartTimeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyInstanceMetadataOptionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyInstancePlacementResult$Return' => '<p>Is <code>true</code> if the request succeeds, and an error otherwise.</p>', 'ModifyLaunchTemplateRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyManagedPrefixListRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyNetworkInterfaceAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifySnapshotAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifySpotFleetRequestResponse$Return' => '<p>Is <code>true</code> if the request succeeds, and an error otherwise.</p>', 'ModifyTrafficMirrorFilterNetworkServicesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyTrafficMirrorFilterRuleRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyTrafficMirrorSessionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyTransitGatewayVpcAttachmentRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVolumeAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVolumeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVpcEndpointConnectionNotificationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVpcEndpointConnectionNotificationResult$ReturnValue' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'ModifyVpcEndpointRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVpcEndpointRequest$ResetPolicy' => '<p>(Gateway endpoint) Specify <code>true</code> to reset the policy document to the default policy. The default policy allows full access to the service.</p>', 'ModifyVpcEndpointRequest$PrivateDnsEnabled' => '<p>(Interface endpoint) Indicates whether a private hosted zone is associated with the VPC.</p>', 'ModifyVpcEndpointResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'ModifyVpcEndpointServiceConfigurationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVpcEndpointServiceConfigurationRequest$RemovePrivateDnsName' => '<p>Removes the private DNS name of the endpoint service.</p>', 'ModifyVpcEndpointServiceConfigurationRequest$AcceptanceRequired' => '<p>Indicates whether requests to create an endpoint to your service must be accepted.</p>', 'ModifyVpcEndpointServiceConfigurationResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'ModifyVpcEndpointServicePermissionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVpcEndpointServicePermissionsResult$ReturnValue' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'ModifyVpcPeeringConnectionOptionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVpcTenancyRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVpcTenancyResult$ReturnValue' => '<p>Returns <code>true</code> if the request succeeds; otherwise, returns an error.</p>', 'ModifyVpnConnectionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVpnTunnelCertificateRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ModifyVpnTunnelOptionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'MonitorInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'MoveAddressToVpcRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'NetworkAcl$IsDefault' => '<p>Indicates whether this is the default network ACL for the VPC.</p>', 'NetworkAclEntry$Egress' => '<p>Indicates whether the rule is an egress rule (applied to traffic leaving the subnet).</p>', 'NetworkInterface$RequesterManaged' => '<p>Indicates whether the network interface is being managed by AWS.</p>', 'NetworkInterface$SourceDestCheck' => '<p>Indicates whether traffic to or from the instance is validated.</p>', 'NetworkInterfaceAttachment$DeleteOnTermination' => '<p>Indicates whether the network interface is deleted when the instance is terminated.</p>', 'NetworkInterfaceAttachmentChanges$DeleteOnTermination' => '<p>Indicates whether the network interface is deleted when the instance is terminated.</p>', 'NetworkInterfacePrivateIpAddress$Primary' => '<p>Indicates whether this IPv4 address is the primary private IPv4 address of the network interface.</p>', 'OnDemandOptions$SingleInstanceType' => '<p>Indicates that the fleet uses a single instance type to launch all On-Demand Instances in the fleet. Supported only for fleets of type <code>instant</code>.</p>', 'OnDemandOptions$SingleAvailabilityZone' => '<p>Indicates that the fleet launches all On-Demand Instances into a single Availability Zone. Supported only for fleets of type <code>instant</code>.</p>', 'OnDemandOptionsRequest$SingleInstanceType' => '<p>Indicates that the fleet uses a single instance type to launch all On-Demand Instances in the fleet. Supported only for fleets of type <code>instant</code>.</p>', 'OnDemandOptionsRequest$SingleAvailabilityZone' => '<p>Indicates that the fleet launches all On-Demand Instances into a single Availability Zone. Supported only for fleets of type <code>instant</code>.</p>', 'PeeringConnectionOptions$AllowDnsResolutionFromRemoteVpc' => '<p>If true, the public DNS hostnames of instances in the specified VPC resolve to private IP addresses when queried from instances in the peer VPC.</p>', 'PeeringConnectionOptions$AllowEgressFromLocalClassicLinkToRemoteVpc' => '<p>If true, enables outbound communication from an EC2-Classic instance that\'s linked to a local VPC using ClassicLink to instances in a peer VPC.</p>', 'PeeringConnectionOptions$AllowEgressFromLocalVpcToRemoteClassicLink' => '<p>If true, enables outbound communication from instances in a local VPC to an EC2-Classic instance that\'s linked to a peer VPC using ClassicLink.</p>', 'PeeringConnectionOptionsRequest$AllowDnsResolutionFromRemoteVpc' => '<p>If true, enables a local VPC to resolve public DNS hostnames to private IP addresses when queried from instances in the peer VPC.</p>', 'PeeringConnectionOptionsRequest$AllowEgressFromLocalClassicLinkToRemoteVpc' => '<p>If true, enables outbound communication from an EC2-Classic instance that\'s linked to a local VPC using ClassicLink to instances in a peer VPC.</p>', 'PeeringConnectionOptionsRequest$AllowEgressFromLocalVpcToRemoteClassicLink' => '<p>If true, enables outbound communication from instances in a local VPC to an EC2-Classic instance that\'s linked to a peer VPC using ClassicLink.</p>', 'PriceSchedule$Active' => '<p>The current price schedule, as determined by the term remaining for the Reserved Instance in the listing.</p> <p>A specific price schedule is always in effect, but only one price schedule can be active at any time. Take, for example, a Reserved Instance listing that has five months remaining in its term. When you specify price schedules for five months and two months, this means that schedule 1, covering the first three months of the remaining term, will be active during months 5, 4, and 3. Then schedule 2, covering the last two months of the term, will be active for months 2 and 1.</p>', 'PrivateIpAddressSpecification$Primary' => '<p>Indicates whether the private IPv4 address is the primary private IPv4 address. Only one IPv4 address can be designated as primary.</p>', 'ProvisionByoipCidrRequest$PubliclyAdvertisable' => '<p>(IPv6 only) Indicate whether the address range will be publicly advertised to the internet.</p> <p>Default: true</p>', 'ProvisionByoipCidrRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'PurchaseReservedInstancesOfferingRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'PurchaseScheduledInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RebootInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RegisterImageRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RegisterImageRequest$EnaSupport' => '<p>Set to <code>true</code> to enable enhanced networking with ENA for the AMI and any instances that you launch from the AMI.</p> <p>This option is supported only for HVM AMIs. Specifying this option with a PV AMI can make instances launched from the AMI unreachable.</p>', 'RegisterInstanceEventNotificationAttributesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RegisterInstanceTagAttributeRequest$IncludeAllTagsOfInstance' => '<p>Indicates whether to register all tag keys in the current Region. Specify <code>true</code> to register all tag keys.</p>', 'RegisterTransitGatewayMulticastGroupMembersRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RegisterTransitGatewayMulticastGroupSourcesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RejectTransitGatewayPeeringAttachmentRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RejectTransitGatewayVpcAttachmentRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RejectVpcEndpointConnectionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RejectVpcPeeringConnectionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RejectVpcPeeringConnectionResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'ReleaseAddressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ReplaceNetworkAclAssociationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ReplaceNetworkAclEntryRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ReplaceNetworkAclEntryRequest$Egress' => '<p>Indicates whether to replace the egress rule.</p> <p>Default: If no value is specified, we replace the ingress rule.</p>', 'ReplaceRouteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ReplaceRouteRequest$LocalTarget' => '<p>Specifies whether to reset the local route to its default target (<code>local</code>).</p>', 'ReplaceRouteTableAssociationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ReplaceTransitGatewayRouteRequest$Blackhole' => '<p>Indicates whether traffic matching this route is to be dropped.</p>', 'ReplaceTransitGatewayRouteRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ReportInstanceStatusRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RequestLaunchTemplateData$EbsOptimized' => '<p>Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This optimization isn\'t available with all instance types. Additional usage charges apply when using an EBS-optimized instance.</p>', 'RequestLaunchTemplateData$DisableApiTermination' => '<p>If you set this parameter to <code>true</code>, you can\'t terminate the instance using the Amazon EC2 console, CLI, or API; otherwise, you can. To change this attribute after launch, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html">ModifyInstanceAttribute</a>. Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code> to <code>terminate</code>, you can terminate the instance by running the shutdown command from the instance.</p>', 'RequestSpotFleetRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RequestSpotInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RequestSpotLaunchSpecification$EbsOptimized' => '<p>Indicates whether the instance is optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn\'t available with all instance types. Additional usage charges apply when using an EBS Optimized instance.</p> <p>Default: <code>false</code> </p>', 'ReservedInstancesOffering$Marketplace' => '<p>Indicates whether the offering is available through the Reserved Instance Marketplace (resale) or AWS. If it\'s a Reserved Instance Marketplace offering, this is <code>true</code>.</p>', 'ResetEbsDefaultKmsKeyIdRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ResetFpgaImageAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ResetFpgaImageAttributeResult$Return' => '<p>Is <code>true</code> if the request succeeds, and an error otherwise.</p>', 'ResetImageAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ResetInstanceAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ResetNetworkInterfaceAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ResetSnapshotAttributeRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ResponseLaunchTemplateData$EbsOptimized' => '<p>Indicates whether the instance is optimized for Amazon EBS I/O. </p>', 'ResponseLaunchTemplateData$DisableApiTermination' => '<p>If set to <code>true</code>, indicates that the instance cannot be terminated using the Amazon EC2 console, command line tool, or API.</p>', 'RestoreAddressToClassicRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RestoreManagedPrefixListVersionRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RevokeClientVpnIngressRequest$RevokeAllGroups' => '<p>Indicates whether access should be revoked for all clients.</p>', 'RevokeClientVpnIngressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RevokeSecurityGroupEgressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RevokeSecurityGroupIngressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RouteTableAssociation$Main' => '<p>Indicates whether this is the main route table.</p>', 'RunInstancesMonitoringEnabled$Enabled' => '<p>Indicates whether detailed monitoring is enabled. Otherwise, basic monitoring is enabled.</p>', 'RunInstancesRequest$DisableApiTermination' => '<p>If you set this parameter to <code>true</code>, you can\'t terminate the instance using the Amazon EC2 console, CLI, or API; otherwise, you can. To change this attribute after launch, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html">ModifyInstanceAttribute</a>. Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code> to <code>terminate</code>, you can terminate the instance by running the shutdown command from the instance.</p> <p>Default: <code>false</code> </p>', 'RunInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'RunInstancesRequest$EbsOptimized' => '<p>Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This optimization isn\'t available with all instance types. Additional usage charges apply when using an EBS-optimized instance.</p> <p>Default: <code>false</code> </p>', 'RunScheduledInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ScheduledInstanceRecurrence$OccurrenceRelativeToEnd' => '<p>Indicates whether the occurrence is relative to the end of the specified week or month.</p>', 'ScheduledInstanceRecurrenceRequest$OccurrenceRelativeToEnd' => '<p>Indicates whether the occurrence is relative to the end of the specified week or month. You can\'t specify this value with a daily schedule.</p>', 'ScheduledInstancesEbs$DeleteOnTermination' => '<p>Indicates whether the volume is deleted on instance termination.</p>', 'ScheduledInstancesEbs$Encrypted' => '<p>Indicates whether the volume is encrypted. You can attached encrypted volumes only to instances that support them.</p>', 'ScheduledInstancesLaunchSpecification$EbsOptimized' => '<p>Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn\'t available with all instance types. Additional usage charges apply when using an EBS-optimized instance.</p> <p>Default: <code>false</code> </p>', 'ScheduledInstancesMonitoring$Enabled' => '<p>Indicates whether monitoring is enabled.</p>', 'ScheduledInstancesNetworkInterface$AssociatePublicIpAddress' => '<p>Indicates whether to assign a public IPv4 address to instances launched in a VPC. The public IPv4 address can only be assigned to a network interface for eth0, and can only be assigned to a new network interface, not an existing one. You cannot specify more than one network interface in the request. If launching into a default subnet, the default value is <code>true</code>.</p>', 'ScheduledInstancesNetworkInterface$DeleteOnTermination' => '<p>Indicates whether to delete the interface when the instance is terminated.</p>', 'ScheduledInstancesPrivateIpAddressConfig$Primary' => '<p>Indicates whether this is a primary IPv4 address. Otherwise, this is a secondary IPv4 address.</p>', 'SearchLocalGatewayRoutesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'SearchTransitGatewayMulticastGroupsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'SearchTransitGatewayRoutesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'SearchTransitGatewayRoutesResult$AdditionalRoutesAvailable' => '<p>Indicates whether there are additional routes available.</p>', 'SendDiagnosticInterruptRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'ServiceConfiguration$AcceptanceRequired' => '<p>Indicates whether requests from other AWS accounts to create an endpoint to the service must first be accepted.</p>', 'ServiceConfiguration$ManagesVpcEndpoints' => '<p>Indicates whether the service manages its VPC endpoints. Management of the service VPC endpoints using the VPC endpoint API is restricted.</p>', 'ServiceDetail$VpcEndpointPolicySupported' => '<p>Indicates whether the service supports endpoint policies.</p>', 'ServiceDetail$AcceptanceRequired' => '<p>Indicates whether VPC endpoint connection requests to the service must be accepted by the service owner.</p>', 'ServiceDetail$ManagesVpcEndpoints' => '<p>Indicates whether the service manages its VPC endpoints. Management of the service VPC endpoints using the VPC endpoint API is restricted.</p>', 'Snapshot$Encrypted' => '<p>Indicates whether the snapshot is encrypted.</p>', 'SnapshotInfo$Encrypted' => '<p>Indicates whether the snapshot is encrypted.</p>', 'SnapshotTaskDetail$Encrypted' => '<p>Indicates whether the snapshot is encrypted.</p>', 'SpotFleetLaunchSpecification$EbsOptimized' => '<p>Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn\'t available with all instance types. Additional usage charges apply when using an EBS Optimized instance.</p> <p>Default: <code>false</code> </p>', 'SpotFleetMonitoring$Enabled' => '<p>Enables monitoring for the instance.</p> <p>Default: <code>false</code> </p>', 'SpotFleetRequestConfigData$TerminateInstancesWithExpiration' => '<p>Indicates whether running Spot Instances are terminated when the Spot Fleet request expires.</p>', 'SpotFleetRequestConfigData$ReplaceUnhealthyInstances' => '<p>Indicates whether Spot Fleet should replace unhealthy instances.</p>', 'SpotOptions$SingleInstanceType' => '<p>Indicates that the fleet uses a single instance type to launch all Spot Instances in the fleet. Supported only for fleets of type <code>instant</code>.</p>', 'SpotOptions$SingleAvailabilityZone' => '<p>Indicates that the fleet launches all Spot Instances into a single Availability Zone. Supported only for fleets of type <code>instant</code>.</p>', 'SpotOptionsRequest$SingleInstanceType' => '<p>Indicates that the fleet uses a single instance type to launch all Spot Instances in the fleet. Supported only for fleets of type <code>instant</code>.</p>', 'SpotOptionsRequest$SingleAvailabilityZone' => '<p>Indicates that the fleet launches all Spot Instances into a single Availability Zone. Supported only for fleets of type <code>instant</code>.</p>', 'StartInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'StartVpcEndpointServicePrivateDnsVerificationRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'StartVpcEndpointServicePrivateDnsVerificationResult$ReturnValue' => '<p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>', 'StopInstancesRequest$Hibernate' => '<p>Hibernates the instance if the instance was enabled for hibernation at launch. If the instance cannot hibernate successfully, a normal shutdown occurs. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p> Default: <code>false</code> </p>', 'StopInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'StopInstancesRequest$Force' => '<p>Forces the instances to stop. The instances do not have an opportunity to flush file system caches or file system metadata. If you use this option, you must perform file system check and repair procedures. This option is not recommended for Windows instances.</p> <p>Default: <code>false</code> </p>', 'Subnet$DefaultForAz' => '<p>Indicates whether this is the default subnet for the Availability Zone.</p>', 'Subnet$MapPublicIpOnLaunch' => '<p>Indicates whether instances launched in this subnet receive a public IPv4 address.</p>', 'Subnet$MapCustomerOwnedIpOnLaunch' => '<p>Indicates whether a network interface created in this subnet (including a network interface created by <a>RunInstances</a>) receives a customer-owned IPv4 address.</p>', 'Subnet$AssignIpv6AddressOnCreation' => '<p>Indicates whether a network interface created in this subnet (including a network interface created by <a>RunInstances</a>) receives an IPv6 address.</p>', 'TerminateClientVpnConnectionsRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'TerminateInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'TransitGatewayMulticastGroup$GroupMember' => '<p>Indicates that the resource is a transit gateway multicast group member.</p>', 'TransitGatewayMulticastGroup$GroupSource' => '<p>Indicates that the resource is a transit gateway multicast group member.</p>', 'TransitGatewayRouteTable$DefaultAssociationRouteTable' => '<p>Indicates whether this is the default association route table for the transit gateway.</p>', 'TransitGatewayRouteTable$DefaultPropagationRouteTable' => '<p>Indicates whether this is the default propagation route table for the transit gateway.</p>', 'UnmonitorInstancesRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'UpdateSecurityGroupRuleDescriptionsEgressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'UpdateSecurityGroupRuleDescriptionsEgressResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, returns an error.</p>', 'UpdateSecurityGroupRuleDescriptionsIngressRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', 'UpdateSecurityGroupRuleDescriptionsIngressResult$Return' => '<p>Returns <code>true</code> if the request succeeds; otherwise, returns an error.</p>', 'Volume$Encrypted' => '<p>Indicates whether the volume is encrypted.</p>', 'Volume$FastRestored' => '<p>Indicates whether the volume was created using fast snapshot restore.</p>', 'Volume$MultiAttachEnabled' => '<p>Indicates whether Amazon EBS Multi-Attach is enabled.</p>', 'VolumeAttachment$DeleteOnTermination' => '<p>Indicates whether the EBS volume is deleted on instance termination.</p>', 'Vpc$IsDefault' => '<p>Indicates whether the VPC is the default VPC.</p>', 'VpcClassicLink$ClassicLinkEnabled' => '<p>Indicates whether the VPC is enabled for ClassicLink.</p>', 'VpcEndpoint$PrivateDnsEnabled' => '<p>(Interface endpoint) Indicates whether the VPC is associated with a private hosted zone.</p>', 'VpcEndpoint$RequesterManaged' => '<p>Indicates whether the VPC endpoint is being managed by its service.</p>', 'VpcPeeringConnectionOptionsDescription$AllowDnsResolutionFromRemoteVpc' => '<p>Indicates whether a local VPC can resolve public DNS hostnames to private IP addresses when queried from instances in a peer VPC.</p>', 'VpcPeeringConnectionOptionsDescription$AllowEgressFromLocalClassicLinkToRemoteVpc' => '<p>Indicates whether a local ClassicLink connection can communicate with the peer VPC over the VPC peering connection.</p>', 'VpcPeeringConnectionOptionsDescription$AllowEgressFromLocalVpcToRemoteClassicLink' => '<p>Indicates whether a local VPC can communicate with a ClassicLink connection in the peer VPC over the VPC peering connection.</p>', 'VpnConnectionOptions$EnableAcceleration' => '<p>Indicates whether acceleration is enabled for the VPN connection.</p>', 'VpnConnectionOptions$StaticRoutesOnly' => '<p>Indicates whether the VPN connection uses static routes only. Static routes must be used for devices that don\'t support BGP.</p>', 'VpnConnectionOptionsSpecification$EnableAcceleration' => '<p>Indicate whether to enable acceleration for the VPN connection.</p> <p>Default: <code>false</code> </p>', 'VpnConnectionOptionsSpecification$StaticRoutesOnly' => '<p>Indicate whether the VPN connection uses static routes only. If you are creating a VPN connection for a device that does not support BGP, you must specify <code>true</code>. Use <a>CreateVpnConnectionRoute</a> to create a static route.</p> <p>Default: <code>false</code> </p>', 'WithdrawByoipCidrRequest$DryRun' => '<p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>', ], ], 'BundleId' => [ 'base' => NULL, 'refs' => [ 'BundleIdStringList$member' => NULL, 'CancelBundleTaskRequest$BundleId' => '<p>The ID of the bundle task.</p>', ], ], 'BundleIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeBundleTasksRequest$BundleIds' => '<p>The bundle task IDs.</p> <p>Default: Describes all your bundle tasks.</p>', ], ], 'BundleInstanceRequest' => [ 'base' => '<p>Contains the parameters for BundleInstance.</p>', 'refs' => [], ], 'BundleInstanceResult' => [ 'base' => '<p>Contains the output of BundleInstance.</p>', 'refs' => [], ], 'BundleTask' => [ 'base' => '<p>Describes a bundle task.</p>', 'refs' => [ 'BundleInstanceResult$BundleTask' => '<p>Information about the bundle task.</p>', 'BundleTaskList$member' => NULL, 'CancelBundleTaskResult$BundleTask' => '<p>Information about the bundle task.</p>', ], ], 'BundleTaskError' => [ 'base' => '<p>Describes an error for <a>BundleInstance</a>.</p>', 'refs' => [ 'BundleTask$BundleTaskError' => '<p>If the task fails, a description of the error.</p>', ], ], 'BundleTaskList' => [ 'base' => NULL, 'refs' => [ 'DescribeBundleTasksResult$BundleTasks' => '<p>Information about the bundle tasks.</p>', ], ], 'BundleTaskState' => [ 'base' => NULL, 'refs' => [ 'BundleTask$State' => '<p>The state of the task.</p>', ], ], 'BurstablePerformanceFlag' => [ 'base' => NULL, 'refs' => [ 'InstanceTypeInfo$BurstablePerformanceSupported' => '<p>Indicates whether the instance type is a burstable performance instance type.</p>', ], ], 'ByoipCidr' => [ 'base' => '<p>Information about an address range that is provisioned for use with your AWS resources through bring your own IP addresses (BYOIP).</p>', 'refs' => [ 'AdvertiseByoipCidrResult$ByoipCidr' => '<p>Information about the address range.</p>', 'ByoipCidrSet$member' => NULL, 'DeprovisionByoipCidrResult$ByoipCidr' => '<p>Information about the address range.</p>', 'ProvisionByoipCidrResult$ByoipCidr' => '<p>Information about the address range.</p>', 'WithdrawByoipCidrResult$ByoipCidr' => '<p>Information about the address pool.</p>', ], ], 'ByoipCidrSet' => [ 'base' => NULL, 'refs' => [ 'DescribeByoipCidrsResult$ByoipCidrs' => '<p>Information about your address ranges.</p>', ], ], 'ByoipCidrState' => [ 'base' => NULL, 'refs' => [ 'ByoipCidr$State' => '<p>The state of the address pool.</p>', ], ], 'CancelBatchErrorCode' => [ 'base' => NULL, 'refs' => [ 'CancelSpotFleetRequestsError$Code' => '<p>The error code.</p>', ], ], 'CancelBundleTaskRequest' => [ 'base' => '<p>Contains the parameters for CancelBundleTask.</p>', 'refs' => [], ], 'CancelBundleTaskResult' => [ 'base' => '<p>Contains the output of CancelBundleTask.</p>', 'refs' => [], ], 'CancelCapacityReservationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelCapacityReservationResult' => [ 'base' => NULL, 'refs' => [], ], 'CancelConversionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelExportTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelImportTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelImportTaskResult' => [ 'base' => NULL, 'refs' => [], ], 'CancelReservedInstancesListingRequest' => [ 'base' => '<p>Contains the parameters for CancelReservedInstancesListing.</p>', 'refs' => [], ], 'CancelReservedInstancesListingResult' => [ 'base' => '<p>Contains the output of CancelReservedInstancesListing.</p>', 'refs' => [], ], 'CancelSpotFleetRequestsError' => [ 'base' => '<p>Describes a Spot Fleet error.</p>', 'refs' => [ 'CancelSpotFleetRequestsErrorItem$Error' => '<p>The error.</p>', ], ], 'CancelSpotFleetRequestsErrorItem' => [ 'base' => '<p>Describes a Spot Fleet request that was not successfully canceled.</p>', 'refs' => [ 'CancelSpotFleetRequestsErrorSet$member' => NULL, ], ], 'CancelSpotFleetRequestsErrorSet' => [ 'base' => NULL, 'refs' => [ 'CancelSpotFleetRequestsResponse$UnsuccessfulFleetRequests' => '<p>Information about the Spot Fleet requests that are not successfully canceled.</p>', ], ], 'CancelSpotFleetRequestsRequest' => [ 'base' => '<p>Contains the parameters for CancelSpotFleetRequests.</p>', 'refs' => [], ], 'CancelSpotFleetRequestsResponse' => [ 'base' => '<p>Contains the output of CancelSpotFleetRequests.</p>', 'refs' => [], ], 'CancelSpotFleetRequestsSuccessItem' => [ 'base' => '<p>Describes a Spot Fleet request that was successfully canceled.</p>', 'refs' => [ 'CancelSpotFleetRequestsSuccessSet$member' => NULL, ], ], 'CancelSpotFleetRequestsSuccessSet' => [ 'base' => NULL, 'refs' => [ 'CancelSpotFleetRequestsResponse$SuccessfulFleetRequests' => '<p>Information about the Spot Fleet requests that are successfully canceled.</p>', ], ], 'CancelSpotInstanceRequestState' => [ 'base' => NULL, 'refs' => [ 'CancelledSpotInstanceRequest$State' => '<p>The state of the Spot Instance request.</p>', ], ], 'CancelSpotInstanceRequestsRequest' => [ 'base' => '<p>Contains the parameters for CancelSpotInstanceRequests.</p>', 'refs' => [], ], 'CancelSpotInstanceRequestsResult' => [ 'base' => '<p>Contains the output of CancelSpotInstanceRequests.</p>', 'refs' => [], ], 'CancelledSpotInstanceRequest' => [ 'base' => '<p>Describes a request to cancel a Spot Instance.</p>', 'refs' => [ 'CancelledSpotInstanceRequestList$member' => NULL, ], ], 'CancelledSpotInstanceRequestList' => [ 'base' => NULL, 'refs' => [ 'CancelSpotInstanceRequestsResult$CancelledSpotInstanceRequests' => '<p>One or more Spot Instance requests.</p>', ], ], 'CapacityReservation' => [ 'base' => '<p>Describes a Capacity Reservation.</p>', 'refs' => [ 'CapacityReservationSet$member' => NULL, 'CreateCapacityReservationResult$CapacityReservation' => '<p>Information about the Capacity Reservation.</p>', ], ], 'CapacityReservationGroup' => [ 'base' => '<p>Describes a resource group to which a Capacity Reservation has been added.</p>', 'refs' => [ 'CapacityReservationGroupSet$member' => NULL, ], ], 'CapacityReservationGroupSet' => [ 'base' => NULL, 'refs' => [ 'GetGroupsForCapacityReservationResult$CapacityReservationGroups' => '<p>Information about the resource groups to which the Capacity Reservation has been added.</p>', ], ], 'CapacityReservationId' => [ 'base' => NULL, 'refs' => [ 'CancelCapacityReservationRequest$CapacityReservationId' => '<p>The ID of the Capacity Reservation to be cancelled.</p>', 'CapacityReservationIdSet$member' => NULL, 'CapacityReservationTarget$CapacityReservationId' => '<p>The ID of the Capacity Reservation in which to run the instance.</p>', 'GetCapacityReservationUsageRequest$CapacityReservationId' => '<p>The ID of the Capacity Reservation.</p>', 'GetGroupsForCapacityReservationRequest$CapacityReservationId' => '<p>The ID of the Capacity Reservation.</p>', 'ModifyCapacityReservationRequest$CapacityReservationId' => '<p>The ID of the Capacity Reservation.</p>', ], ], 'CapacityReservationIdSet' => [ 'base' => NULL, 'refs' => [ 'DescribeCapacityReservationsRequest$CapacityReservationIds' => '<p>The ID of the Capacity Reservation.</p>', ], ], 'CapacityReservationInstancePlatform' => [ 'base' => NULL, 'refs' => [ 'CapacityReservation$InstancePlatform' => '<p>The type of operating system for which the Capacity Reservation reserves capacity.</p>', 'CreateCapacityReservationRequest$InstancePlatform' => '<p>The type of operating system for which to reserve capacity.</p>', ], ], 'CapacityReservationOptions' => [ 'base' => '<p>Describes the strategy for using unused Capacity Reservations for fulfilling On-Demand capacity.</p> <note> <p>This strategy can only be used if the EC2 Fleet is of type <code>instant</code>.</p> </note> <p>For more information about Capacity Reservations, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html">On-Demand Capacity Reservations</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. For examples of using Capacity Reservations in an EC2 Fleet, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-examples.html">EC2 Fleet Example Configurations</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'refs' => [ 'OnDemandOptions$CapacityReservationOptions' => '<p>The strategy for using unused Capacity Reservations for fulfilling On-Demand capacity. Supported only for fleets of type <code>instant</code>.</p>', ], ], 'CapacityReservationOptionsRequest' => [ 'base' => '<p>Describes the strategy for using unused Capacity Reservations for fulfilling On-Demand capacity.</p> <note> <p>This strategy can only be used if the EC2 Fleet is of type <code>instant</code>.</p> </note> <p>For more information about Capacity Reservations, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html">On-Demand Capacity Reservations</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. For examples of using Capacity Reservations in an EC2 Fleet, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-examples.html">EC2 Fleet Example Configurations</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'refs' => [ 'OnDemandOptionsRequest$CapacityReservationOptions' => '<p>The strategy for using unused Capacity Reservations for fulfilling On-Demand capacity. Supported only for fleets of type <code>instant</code>.</p>', ], ], 'CapacityReservationPreference' => [ 'base' => NULL, 'refs' => [ 'CapacityReservationSpecification$CapacityReservationPreference' => '<p>Indicates the instance\'s Capacity Reservation preferences. Possible preferences include:</p> <ul> <li> <p> <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).</p> </li> <li> <p> <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance runs as an On-Demand Instance.</p> </li> </ul>', 'CapacityReservationSpecificationResponse$CapacityReservationPreference' => '<p>Describes the instance\'s Capacity Reservation preferences. Possible preferences include:</p> <ul> <li> <p> <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).</p> </li> <li> <p> <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance runs in On-Demand capacity.</p> </li> </ul>', 'LaunchTemplateCapacityReservationSpecificationRequest$CapacityReservationPreference' => '<p>Indicates the instance\'s Capacity Reservation preferences. Possible preferences include:</p> <ul> <li> <p> <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).</p> </li> <li> <p> <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance runs in On-Demand capacity.</p> </li> </ul>', 'LaunchTemplateCapacityReservationSpecificationResponse$CapacityReservationPreference' => '<p>Indicates the instance\'s Capacity Reservation preferences. Possible preferences include:</p> <ul> <li> <p> <code>open</code> - The instance can run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).</p> </li> <li> <p> <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance runs in On-Demand capacity.</p> </li> </ul>', ], ], 'CapacityReservationSet' => [ 'base' => NULL, 'refs' => [ 'DescribeCapacityReservationsResult$CapacityReservations' => '<p>Information about the Capacity Reservations.</p>', ], ], 'CapacityReservationSpecification' => [ 'base' => '<p>Describes an instance\'s Capacity Reservation targeting option. You can specify only one parameter at a time. If you specify <code>CapacityReservationPreference</code> and <code>CapacityReservationTarget</code>, the request fails.</p> <p>Use the <code>CapacityReservationPreference</code> parameter to configure the instance to run as an On-Demand Instance or to run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone). Use the <code>CapacityReservationTarget</code> parameter to explicitly target a specific Capacity Reservation or a Capacity Reservation group.</p>', 'refs' => [ 'ModifyInstanceCapacityReservationAttributesRequest$CapacityReservationSpecification' => '<p>Information about the Capacity Reservation targeting option.</p>', 'RunInstancesRequest$CapacityReservationSpecification' => '<p>Information about the Capacity Reservation targeting option. If you do not specify this parameter, the instance\'s Capacity Reservation preference defaults to <code>open</code>, which enables it to run in any open Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).</p>', ], ], 'CapacityReservationSpecificationResponse' => [ 'base' => '<p>Describes the instance\'s Capacity Reservation targeting preferences. The action returns the <code>capacityReservationPreference</code> response element if the instance is configured to run in On-Demand capacity, or if it is configured in run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone). The action returns the <code>capacityReservationTarget</code> response element if the instance explicily targets a specific Capacity Reservation or Capacity Reservation group.</p>', 'refs' => [ 'Instance$CapacityReservationSpecification' => '<p>Information about the Capacity Reservation targeting option.</p>', ], ], 'CapacityReservationState' => [ 'base' => NULL, 'refs' => [ 'CapacityReservation$State' => '<p>The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:</p> <ul> <li> <p> <code>active</code> - The Capacity Reservation is active and the capacity is available for your use.</p> </li> <li> <p> <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in your request. The reserved capacity is no longer available for your use.</p> </li> <li> <p> <code>cancelled</code> - The Capacity Reservation was manually cancelled. The reserved capacity is no longer available for your use.</p> </li> <li> <p> <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is still pending.</p> </li> <li> <p> <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60 minutes.</p> </li> </ul>', 'GetCapacityReservationUsageResult$State' => '<p>The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:</p> <ul> <li> <p> <code>active</code> - The Capacity Reservation is active and the capacity is available for your use.</p> </li> <li> <p> <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in your request. The reserved capacity is no longer available for your use.</p> </li> <li> <p> <code>cancelled</code> - The Capacity Reservation was manually cancelled. The reserved capacity is no longer available for your use.</p> </li> <li> <p> <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is still pending.</p> </li> <li> <p> <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60 minutes.</p> </li> </ul>', ], ], 'CapacityReservationTarget' => [ 'base' => '<p>Describes a target Capacity Reservation or Capacity Reservation group.</p>', 'refs' => [ 'CapacityReservationSpecification$CapacityReservationTarget' => '<p>Information about the target Capacity Reservation or Capacity Reservation group.</p>', 'LaunchTemplateCapacityReservationSpecificationRequest$CapacityReservationTarget' => '<p>Information about the target Capacity Reservation or Capacity Reservation group.</p>', ], ], 'CapacityReservationTargetResponse' => [ 'base' => '<p>Describes a target Capacity Reservation or Capacity Reservation group.</p>', 'refs' => [ 'CapacityReservationSpecificationResponse$CapacityReservationTarget' => '<p>Information about the targeted Capacity Reservation or Capacity Reservation group.</p>', 'LaunchTemplateCapacityReservationSpecificationResponse$CapacityReservationTarget' => '<p>Information about the target Capacity Reservation or Capacity Reservation group.</p>', ], ], 'CapacityReservationTenancy' => [ 'base' => NULL, 'refs' => [ 'CapacityReservation$Tenancy' => '<p>Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:</p> <ul> <li> <p> <code>default</code> - The Capacity Reservation is created on hardware that is shared with other AWS accounts.</p> </li> <li> <p> <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single AWS account.</p> </li> </ul>', 'CreateCapacityReservationRequest$Tenancy' => '<p>Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:</p> <ul> <li> <p> <code>default</code> - The Capacity Reservation is created on hardware that is shared with other AWS accounts.</p> </li> <li> <p> <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single AWS account.</p> </li> </ul>', ], ], 'CarrierGateway' => [ 'base' => '<p>Describes a carrier gateway.</p>', 'refs' => [ 'CarrierGatewaySet$member' => NULL, 'CreateCarrierGatewayResult$CarrierGateway' => '<p>Information about the carrier gateway.</p>', 'DeleteCarrierGatewayResult$CarrierGateway' => '<p>Information about the carrier gateway.</p>', ], ], 'CarrierGatewayId' => [ 'base' => NULL, 'refs' => [ 'CarrierGateway$CarrierGatewayId' => '<p>The ID of the carrier gateway.</p>', 'CarrierGatewayIdSet$member' => NULL, 'CreateRouteRequest$CarrierGatewayId' => '<p>The ID of the carrier gateway.</p> <p>You can only use this option when the VPC contains a subnet which is associated with a Wavelength Zone.</p>', 'DeleteCarrierGatewayRequest$CarrierGatewayId' => '<p>The ID of the carrier gateway.</p>', 'ReplaceRouteRequest$CarrierGatewayId' => '<p>[IPv4 traffic only] The ID of a carrier gateway.</p>', 'Route$CarrierGatewayId' => '<p>The ID of the carrier gateway.</p>', ], ], 'CarrierGatewayIdSet' => [ 'base' => NULL, 'refs' => [ 'DescribeCarrierGatewaysRequest$CarrierGatewayIds' => '<p>One or more carrier gateway IDs.</p>', ], ], 'CarrierGatewayMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeCarrierGatewaysRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'CarrierGatewaySet' => [ 'base' => NULL, 'refs' => [ 'DescribeCarrierGatewaysResult$CarrierGateways' => '<p>Information about the carrier gateway.</p>', ], ], 'CarrierGatewayState' => [ 'base' => NULL, 'refs' => [ 'CarrierGateway$State' => '<p>The state of the carrier gateway.</p>', ], ], 'CertificateAuthentication' => [ 'base' => '<p>Information about the client certificate used for authentication.</p>', 'refs' => [ 'ClientVpnAuthentication$MutualAuthentication' => '<p>Information about the authentication certificates, if applicable.</p>', ], ], 'CertificateAuthenticationRequest' => [ 'base' => '<p>Information about the client certificate to be used for authentication.</p>', 'refs' => [ 'ClientVpnAuthenticationRequest$MutualAuthentication' => '<p>Information about the authentication certificates to be used, if applicable. You must provide this information if <b>Type</b> is <code>certificate-authentication</code>.</p>', ], ], 'CidrAuthorizationContext' => [ 'base' => '<p>Provides authorization for Amazon to bring a specific IP address range to a specific AWS account using bring your own IP addresses (BYOIP). For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html#prepare-for-byoip">Prepare to Bring Your Address Range to Your AWS Account</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'refs' => [ 'ProvisionByoipCidrRequest$CidrAuthorizationContext' => '<p>A signed document that proves that you are authorized to bring the specified IP address range to Amazon using BYOIP.</p>', ], ], 'CidrBlock' => [ 'base' => '<p>Describes an IPv4 CIDR block.</p>', 'refs' => [ 'CidrBlockSet$member' => NULL, ], ], 'CidrBlockSet' => [ 'base' => NULL, 'refs' => [ 'VpcPeeringConnectionVpcInfo$CidrBlockSet' => '<p>Information about the IPv4 CIDR blocks for the VPC.</p>', ], ], 'ClassicLinkDnsSupport' => [ 'base' => '<p>Describes the ClassicLink DNS support status of a VPC.</p>', 'refs' => [ 'ClassicLinkDnsSupportList$member' => NULL, ], ], 'ClassicLinkDnsSupportList' => [ 'base' => NULL, 'refs' => [ 'DescribeVpcClassicLinkDnsSupportResult$Vpcs' => '<p>Information about the ClassicLink DNS support status of the VPCs.</p>', ], ], 'ClassicLinkInstance' => [ 'base' => '<p>Describes a linked EC2-Classic instance.</p>', 'refs' => [ 'ClassicLinkInstanceList$member' => NULL, ], ], 'ClassicLinkInstanceList' => [ 'base' => NULL, 'refs' => [ 'DescribeClassicLinkInstancesResult$Instances' => '<p>Information about one or more linked EC2-Classic instances.</p>', ], ], 'ClassicLoadBalancer' => [ 'base' => '<p>Describes a Classic Load Balancer.</p>', 'refs' => [ 'ClassicLoadBalancers$member' => NULL, ], ], 'ClassicLoadBalancers' => [ 'base' => NULL, 'refs' => [ 'ClassicLoadBalancersConfig$ClassicLoadBalancers' => '<p>One or more Classic Load Balancers.</p>', ], ], 'ClassicLoadBalancersConfig' => [ 'base' => '<p>Describes the Classic Load Balancers to attach to a Spot Fleet. Spot Fleet registers the running Spot Instances with these Classic Load Balancers.</p>', 'refs' => [ 'LoadBalancersConfig$ClassicLoadBalancersConfig' => '<p>The Classic Load Balancers.</p>', ], ], 'ClientCertificateRevocationListStatus' => [ 'base' => '<p>Describes the state of a client certificate revocation list.</p>', 'refs' => [ 'ExportClientVpnClientCertificateRevocationListResult$Status' => '<p>The current state of the client certificate revocation list.</p>', ], ], 'ClientCertificateRevocationListStatusCode' => [ 'base' => NULL, 'refs' => [ 'ClientCertificateRevocationListStatus$Code' => '<p>The state of the client certificate revocation list.</p>', ], ], 'ClientData' => [ 'base' => '<p>Describes the client-specific data.</p>', 'refs' => [ 'ImportImageRequest$ClientData' => '<p>The client-specific data.</p>', 'ImportSnapshotRequest$ClientData' => '<p>The client-specific data.</p>', ], ], 'ClientVpnAssociationId' => [ 'base' => NULL, 'refs' => [ 'DisassociateClientVpnTargetNetworkRequest$AssociationId' => '<p>The ID of the target network association.</p>', ], ], 'ClientVpnAuthentication' => [ 'base' => '<p>Describes the authentication methods used by a Client VPN endpoint. For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/authentication-authrization.html#client-authentication">Authentication</a> in the <i>AWS Client VPN Administrator Guide</i>.</p>', 'refs' => [ 'ClientVpnAuthenticationList$member' => NULL, ], ], 'ClientVpnAuthenticationList' => [ 'base' => NULL, 'refs' => [ 'ClientVpnEndpoint$AuthenticationOptions' => '<p>Information about the authentication method used by the Client VPN endpoint.</p>', ], ], 'ClientVpnAuthenticationRequest' => [ 'base' => '<p>Describes the authentication method to be used by a Client VPN endpoint. For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/authentication-authrization.html#client-authentication">Authentication</a> in the <i>AWS Client VPN Administrator Guide</i>.</p>', 'refs' => [ 'ClientVpnAuthenticationRequestList$member' => NULL, ], ], 'ClientVpnAuthenticationRequestList' => [ 'base' => NULL, 'refs' => [ 'CreateClientVpnEndpointRequest$AuthenticationOptions' => '<p>Information about the authentication method to be used to authenticate clients.</p>', ], ], 'ClientVpnAuthenticationType' => [ 'base' => NULL, 'refs' => [ 'ClientVpnAuthentication$Type' => '<p>The authentication type used.</p>', 'ClientVpnAuthenticationRequest$Type' => '<p>The type of client authentication to be used.</p>', ], ], 'ClientVpnAuthorizationRuleStatus' => [ 'base' => '<p>Describes the state of an authorization rule.</p>', 'refs' => [ 'AuthorizationRule$Status' => '<p>The current state of the authorization rule.</p>', 'AuthorizeClientVpnIngressResult$Status' => '<p>The current state of the authorization rule.</p>', 'RevokeClientVpnIngressResult$Status' => '<p>The current state of the authorization rule.</p>', ], ], 'ClientVpnAuthorizationRuleStatusCode' => [ 'base' => NULL, 'refs' => [ 'ClientVpnAuthorizationRuleStatus$Code' => '<p>The state of the authorization rule.</p>', ], ], 'ClientVpnConnection' => [ 'base' => '<p>Describes a client connection.</p>', 'refs' => [ 'ClientVpnConnectionSet$member' => NULL, ], ], 'ClientVpnConnectionSet' => [ 'base' => NULL, 'refs' => [ 'DescribeClientVpnConnectionsResult$Connections' => '<p>Information about the active and terminated client connections.</p>', ], ], 'ClientVpnConnectionStatus' => [ 'base' => '<p>Describes the status of a client connection.</p>', 'refs' => [ 'ClientVpnConnection$Status' => '<p>The current state of the client connection.</p>', 'TerminateConnectionStatus$PreviousStatus' => '<p>The state of the client connection.</p>', 'TerminateConnectionStatus$CurrentStatus' => '<p>A message about the status of the client connection, if applicable.</p>', ], ], 'ClientVpnConnectionStatusCode' => [ 'base' => NULL, 'refs' => [ 'ClientVpnConnectionStatus$Code' => '<p>The state of the client connection.</p>', ], ], 'ClientVpnEndpoint' => [ 'base' => '<p>Describes a Client VPN endpoint.</p>', 'refs' => [ 'EndpointSet$member' => NULL, ], ], 'ClientVpnEndpointId' => [ 'base' => NULL, 'refs' => [ 'ApplySecurityGroupsToClientVpnTargetNetworkRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint.</p>', 'AssociateClientVpnTargetNetworkRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint.</p>', 'AuthorizeClientVpnIngressRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint.</p>', 'ClientVpnEndpointIdList$member' => NULL, 'CreateClientVpnRouteRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint to which to add the route.</p>', 'DeleteClientVpnEndpointRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN to be deleted.</p>', 'DeleteClientVpnRouteRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint from which the route is to be deleted.</p>', 'DescribeClientVpnAuthorizationRulesRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint.</p>', 'DescribeClientVpnConnectionsRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint.</p>', 'DescribeClientVpnRoutesRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint.</p>', 'DescribeClientVpnTargetNetworksRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint.</p>', 'DisassociateClientVpnTargetNetworkRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint from which to disassociate the target network.</p>', 'ExportClientVpnClientCertificateRevocationListRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint.</p>', 'ExportClientVpnClientConfigurationRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint.</p>', 'ImportClientVpnClientCertificateRevocationListRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint to which the client certificate revocation list applies.</p>', 'ModifyClientVpnEndpointRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint to modify.</p>', 'RevokeClientVpnIngressRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint with which the authorization rule is associated.</p>', 'TerminateClientVpnConnectionsRequest$ClientVpnEndpointId' => '<p>The ID of the Client VPN endpoint to which the client is connected.</p>', ], ], 'ClientVpnEndpointIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeClientVpnEndpointsRequest$ClientVpnEndpointIds' => '<p>The ID of the Client VPN endpoint.</p>', ], ], 'ClientVpnEndpointStatus' => [ 'base' => '<p>Describes the state of a Client VPN endpoint.</p>', 'refs' => [ 'ClientVpnEndpoint$Status' => '<p>The current state of the Client VPN endpoint.</p>', 'CreateClientVpnEndpointResult$Status' => '<p>The current state of the Client VPN endpoint.</p>', 'DeleteClientVpnEndpointResult$Status' => '<p>The current state of the Client VPN endpoint.</p>', ], ], 'ClientVpnEndpointStatusCode' => [ 'base' => NULL, 'refs' => [ 'ClientVpnEndpointStatus$Code' => '<p>The state of the Client VPN endpoint. Possible states include:</p> <ul> <li> <p> <code>pending-associate</code> - The Client VPN endpoint has been created but no target networks have been associated. The Client VPN endpoint cannot accept connections.</p> </li> <li> <p> <code>available</code> - The Client VPN endpoint has been created and a target network has been associated. The Client VPN endpoint can accept connections.</p> </li> <li> <p> <code>deleting</code> - The Client VPN endpoint is being deleted. The Client VPN endpoint cannot accept connections.</p> </li> <li> <p> <code>deleted</code> - The Client VPN endpoint has been deleted. The Client VPN endpoint cannot accept connections.</p> </li> </ul>', ], ], 'ClientVpnRoute' => [ 'base' => '<p>Information about a Client VPN endpoint route.</p>', 'refs' => [ 'ClientVpnRouteSet$member' => NULL, ], ], 'ClientVpnRouteSet' => [ 'base' => NULL, 'refs' => [ 'DescribeClientVpnRoutesResult$Routes' => '<p>Information about the Client VPN endpoint routes.</p>', ], ], 'ClientVpnRouteStatus' => [ 'base' => '<p>Describes the state of a Client VPN endpoint route.</p>', 'refs' => [ 'ClientVpnRoute$Status' => '<p>The current state of the route.</p>', 'CreateClientVpnRouteResult$Status' => '<p>The current state of the route.</p>', 'DeleteClientVpnRouteResult$Status' => '<p>The current state of the route.</p>', ], ], 'ClientVpnRouteStatusCode' => [ 'base' => NULL, 'refs' => [ 'ClientVpnRouteStatus$Code' => '<p>The state of the Client VPN endpoint route.</p>', ], ], 'ClientVpnSecurityGroupIdSet' => [ 'base' => NULL, 'refs' => [ 'ApplySecurityGroupsToClientVpnTargetNetworkRequest$SecurityGroupIds' => '<p>The IDs of the security groups to apply to the associated target network. Up to 5 security groups can be applied to an associated target network.</p>', 'ApplySecurityGroupsToClientVpnTargetNetworkResult$SecurityGroupIds' => '<p>The IDs of the applied security groups.</p>', 'ClientVpnEndpoint$SecurityGroupIds' => '<p>The IDs of the security groups for the target network.</p>', 'CreateClientVpnEndpointRequest$SecurityGroupIds' => '<p>The IDs of one or more security groups to apply to the target network. You must also specify the ID of the VPC that contains the security groups.</p>', 'ModifyClientVpnEndpointRequest$SecurityGroupIds' => '<p>The IDs of one or more security groups to apply to the target network.</p>', ], ], 'CoipAddressUsage' => [ 'base' => '<p>Describes address usage for a customer-owned address pool.</p>', 'refs' => [ 'CoipAddressUsageSet$member' => NULL, ], ], 'CoipAddressUsageSet' => [ 'base' => NULL, 'refs' => [ 'GetCoipPoolUsageResult$CoipAddressUsages' => '<p>Information about the address usage.</p>', ], ], 'CoipPool' => [ 'base' => '<p>Describes a customer-owned address pool.</p>', 'refs' => [ 'CoipPoolSet$member' => NULL, ], ], 'CoipPoolId' => [ 'base' => NULL, 'refs' => [ 'CoipPool$PoolId' => '<p>The ID of the address pool.</p>', 'CoipPoolIdSet$member' => NULL, 'GetCoipPoolUsageRequest$PoolId' => '<p>The ID of the address pool.</p>', 'ModifySubnetAttributeRequest$CustomerOwnedIpv4Pool' => '<p>The customer-owned IPv4 address pool associated with the subnet.</p> <p>You must set this value when you specify <code>true</code> for <code>MapCustomerOwnedIpOnLaunch</code>.</p>', 'Subnet$CustomerOwnedIpv4Pool' => '<p>The customer-owned IPv4 address pool associated with the subnet.</p>', ], ], 'CoipPoolIdSet' => [ 'base' => NULL, 'refs' => [ 'DescribeCoipPoolsRequest$PoolIds' => '<p>The IDs of the address pools.</p>', ], ], 'CoipPoolMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeCoipPoolsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', 'GetCoipPoolUsageRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'CoipPoolSet' => [ 'base' => NULL, 'refs' => [ 'DescribeCoipPoolsResult$CoipPools' => '<p>Information about the address pools.</p>', ], ], 'ConfirmProductInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ConfirmProductInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'ConnectionLogOptions' => [ 'base' => '<p>Describes the client connection logging options for the Client VPN endpoint.</p>', 'refs' => [ 'CreateClientVpnEndpointRequest$ConnectionLogOptions' => '<p>Information about the client connection logging options.</p> <p>If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log stream. The following information is logged:</p> <ul> <li> <p>Client connection requests</p> </li> <li> <p>Client connection results (successful and unsuccessful)</p> </li> <li> <p>Reasons for unsuccessful client connection requests</p> </li> <li> <p>Client connection termination time</p> </li> </ul>', 'ModifyClientVpnEndpointRequest$ConnectionLogOptions' => '<p>Information about the client connection logging options.</p> <p>If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log stream. The following information is logged:</p> <ul> <li> <p>Client connection requests</p> </li> <li> <p>Client connection results (successful and unsuccessful)</p> </li> <li> <p>Reasons for unsuccessful client connection requests</p> </li> <li> <p>Client connection termination time</p> </li> </ul>', ], ], 'ConnectionLogResponseOptions' => [ 'base' => '<p>Information about the client connection logging options for a Client VPN endpoint.</p>', 'refs' => [ 'ClientVpnEndpoint$ConnectionLogOptions' => '<p>Information about the client connection logging options for the Client VPN endpoint.</p>', ], ], 'ConnectionNotification' => [ 'base' => '<p>Describes a connection notification for a VPC endpoint or VPC endpoint service.</p>', 'refs' => [ 'ConnectionNotificationSet$member' => NULL, 'CreateVpcEndpointConnectionNotificationResult$ConnectionNotification' => '<p>Information about the notification.</p>', ], ], 'ConnectionNotificationId' => [ 'base' => NULL, 'refs' => [ 'ConnectionNotificationIdsList$member' => NULL, 'DescribeVpcEndpointConnectionNotificationsRequest$ConnectionNotificationId' => '<p>The ID of the notification.</p>', 'ModifyVpcEndpointConnectionNotificationRequest$ConnectionNotificationId' => '<p>The ID of the notification.</p>', ], ], 'ConnectionNotificationIdsList' => [ 'base' => NULL, 'refs' => [ 'DeleteVpcEndpointConnectionNotificationsRequest$ConnectionNotificationIds' => '<p>One or more notification IDs.</p>', ], ], 'ConnectionNotificationSet' => [ 'base' => NULL, 'refs' => [ 'DescribeVpcEndpointConnectionNotificationsResult$ConnectionNotificationSet' => '<p>One or more notifications.</p>', ], ], 'ConnectionNotificationState' => [ 'base' => NULL, 'refs' => [ 'ConnectionNotification$ConnectionNotificationState' => '<p>The state of the notification.</p>', ], ], 'ConnectionNotificationType' => [ 'base' => NULL, 'refs' => [ 'ConnectionNotification$ConnectionNotificationType' => '<p>The type of notification.</p>', ], ], 'ContainerFormat' => [ 'base' => NULL, 'refs' => [ 'ExportToS3Task$ContainerFormat' => '<p>The container format used to combine disk images with metadata (such as OVF). If absent, only the disk image is exported.</p>', 'ExportToS3TaskSpecification$ContainerFormat' => '<p>The container format used to combine disk images with metadata (such as OVF). If absent, only the disk image is exported.</p>', ], ], 'ConversionIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeConversionTasksRequest$ConversionTaskIds' => '<p>The conversion task IDs.</p>', ], ], 'ConversionTask' => [ 'base' => '<p>Describes a conversion task.</p>', 'refs' => [ 'DescribeConversionTaskList$member' => NULL, 'ImportInstanceResult$ConversionTask' => '<p>Information about the conversion task.</p>', 'ImportVolumeResult$ConversionTask' => '<p>Information about the conversion task.</p>', ], ], 'ConversionTaskId' => [ 'base' => NULL, 'refs' => [ 'CancelConversionRequest$ConversionTaskId' => '<p>The ID of the conversion task.</p>', 'ConversionIdStringList$member' => NULL, ], ], 'ConversionTaskState' => [ 'base' => NULL, 'refs' => [ 'ConversionTask$State' => '<p>The state of the conversion task.</p>', ], ], 'CopyFpgaImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'CopyFpgaImageResult' => [ 'base' => NULL, 'refs' => [], ], 'CopyImageRequest' => [ 'base' => '<p>Contains the parameters for CopyImage.</p>', 'refs' => [], ], 'CopyImageResult' => [ 'base' => '<p>Contains the output of CopyImage.</p>', 'refs' => [], ], 'CopySnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'CopySnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'CopyTagsFromSource' => [ 'base' => NULL, 'refs' => [ 'CreateSnapshotsRequest$CopyTagsFromSource' => '<p>Copies the tags from the specified volume to corresponding snapshot.</p>', ], ], 'CoreCount' => [ 'base' => NULL, 'refs' => [ 'CoreCountList$member' => NULL, 'VCpuInfo$DefaultCores' => '<p>The default number of cores for the instance type.</p>', ], ], 'CoreCountList' => [ 'base' => NULL, 'refs' => [ 'VCpuInfo$ValidCores' => '<p>List of the valid number of cores that can be configured for the instance type.</p>', ], ], 'CpuOptions' => [ 'base' => '<p>The CPU options for the instance.</p>', 'refs' => [ 'Instance$CpuOptions' => '<p>The CPU options for the instance.</p>', ], ], 'CpuOptionsRequest' => [ 'base' => '<p>The CPU options for the instance. Both the core count and threads per core must be specified in the request.</p>', 'refs' => [ 'RunInstancesRequest$CpuOptions' => '<p>The CPU options for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimizing CPU options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', ], ], 'CreateCapacityReservationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCapacityReservationResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateCarrierGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCarrierGatewayResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateClientVpnEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateClientVpnEndpointResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateClientVpnRouteRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateClientVpnRouteResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateCustomerGatewayRequest' => [ 'base' => '<p>Contains the parameters for CreateCustomerGateway.</p>', 'refs' => [], ], 'CreateCustomerGatewayResult' => [ 'base' => '<p>Contains the output of CreateCustomerGateway.</p>', 'refs' => [], ], 'CreateDefaultSubnetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDefaultSubnetResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDefaultVpcRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDefaultVpcResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateDhcpOptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDhcpOptionsResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateEgressOnlyInternetGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateEgressOnlyInternetGatewayResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateFleetError' => [ 'base' => '<p>Describes the instances that could not be launched by the fleet.</p>', 'refs' => [ 'CreateFleetErrorsSet$member' => NULL, ], ], 'CreateFleetErrorsSet' => [ 'base' => NULL, 'refs' => [ 'CreateFleetResult$Errors' => '<p>Information about the instances that could not be launched by the fleet. Valid only when <b>Type</b> is set to <code>instant</code>.</p>', ], ], 'CreateFleetInstance' => [ 'base' => '<p>Describes the instances that were launched by the fleet.</p>', 'refs' => [ 'CreateFleetInstancesSet$member' => NULL, ], ], 'CreateFleetInstancesSet' => [ 'base' => NULL, 'refs' => [ 'CreateFleetResult$Instances' => '<p>Information about the instances that were launched by the fleet. Valid only when <b>Type</b> is set to <code>instant</code>.</p>', ], ], 'CreateFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFleetResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateFlowLogsRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFlowLogsResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateFpgaImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFpgaImageResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateImageResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateInstanceExportTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateInstanceExportTaskResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateInternetGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateInternetGatewayResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateKeyPairRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLaunchTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLaunchTemplateResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateLaunchTemplateVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLaunchTemplateVersionResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateLocalGatewayRouteRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLocalGatewayRouteResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateLocalGatewayRouteTableVpcAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLocalGatewayRouteTableVpcAssociationResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateManagedPrefixListRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateManagedPrefixListResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateNatGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateNatGatewayResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateNetworkAclEntryRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateNetworkAclRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateNetworkAclResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateNetworkInterfacePermissionRequest' => [ 'base' => '<p>Contains the parameters for CreateNetworkInterfacePermission.</p>', 'refs' => [], ], 'CreateNetworkInterfacePermissionResult' => [ 'base' => '<p>Contains the output of CreateNetworkInterfacePermission.</p>', 'refs' => [], ], 'CreateNetworkInterfaceRequest' => [ 'base' => '<p>Contains the parameters for CreateNetworkInterface.</p>', 'refs' => [], ], 'CreateNetworkInterfaceResult' => [ 'base' => '<p>Contains the output of CreateNetworkInterface.</p>', 'refs' => [], ], 'CreatePlacementGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePlacementGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateReservedInstancesListingRequest' => [ 'base' => '<p>Contains the parameters for CreateReservedInstancesListing.</p>', 'refs' => [], ], 'CreateReservedInstancesListingResult' => [ 'base' => '<p>Contains the output of CreateReservedInstancesListing.</p>', 'refs' => [], ], 'CreateRouteRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRouteResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateRouteTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRouteTableResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateSecurityGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSecurityGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSnapshotsRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSnapshotsResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateSpotDatafeedSubscriptionRequest' => [ 'base' => '<p>Contains the parameters for CreateSpotDatafeedSubscription.</p>', 'refs' => [], ], 'CreateSpotDatafeedSubscriptionResult' => [ 'base' => '<p>Contains the output of CreateSpotDatafeedSubscription.</p>', 'refs' => [], ], 'CreateSubnetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSubnetResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrafficMirrorFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrafficMirrorFilterResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrafficMirrorFilterRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrafficMirrorFilterRuleResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrafficMirrorSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrafficMirrorSessionResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrafficMirrorTargetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrafficMirrorTargetResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayMulticastDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayMulticastDomainResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayPeeringAttachmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayPeeringAttachmentResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayRouteRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayRouteResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayRouteTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayRouteTableResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayVpcAttachmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransitGatewayVpcAttachmentRequestOptions' => [ 'base' => '<p>Describes the options for a VPC attachment.</p>', 'refs' => [ 'CreateTransitGatewayVpcAttachmentRequest$Options' => '<p>The VPC attachment options.</p>', ], ], 'CreateTransitGatewayVpcAttachmentResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateVolumePermission' => [ 'base' => '<p>Describes the user or group to be added or removed from the list of create volume permissions for a volume.</p>', 'refs' => [ 'CreateVolumePermissionList$member' => NULL, ], ], 'CreateVolumePermissionList' => [ 'base' => NULL, 'refs' => [ 'CreateVolumePermissionModifications$Add' => '<p>Adds the specified AWS account ID or group to the list.</p>', 'CreateVolumePermissionModifications$Remove' => '<p>Removes the specified AWS account ID or group from the list.</p>', 'DescribeSnapshotAttributeResult$CreateVolumePermissions' => '<p>The users and groups that have the permissions for creating volumes from the snapshot.</p>', ], ], 'CreateVolumePermissionModifications' => [ 'base' => '<p>Describes modifications to the list of create volume permissions for a volume.</p>', 'refs' => [ 'ModifySnapshotAttributeRequest$CreateVolumePermission' => '<p>A JSON representation of the snapshot attribute modification.</p>', ], ], 'CreateVolumeRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVpcEndpointConnectionNotificationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVpcEndpointConnectionNotificationResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateVpcEndpointRequest' => [ 'base' => '<p>Contains the parameters for CreateVpcEndpoint.</p>', 'refs' => [], ], 'CreateVpcEndpointResult' => [ 'base' => '<p>Contains the output of CreateVpcEndpoint.</p>', 'refs' => [], ], 'CreateVpcEndpointServiceConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVpcEndpointServiceConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateVpcPeeringConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVpcPeeringConnectionResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateVpcRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVpcResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateVpnConnectionRequest' => [ 'base' => '<p>Contains the parameters for CreateVpnConnection.</p>', 'refs' => [], ], 'CreateVpnConnectionResult' => [ 'base' => '<p>Contains the output of CreateVpnConnection.</p>', 'refs' => [], ], 'CreateVpnConnectionRouteRequest' => [ 'base' => '<p>Contains the parameters for CreateVpnConnectionRoute.</p>', 'refs' => [], ], 'CreateVpnGatewayRequest' => [ 'base' => '<p>Contains the parameters for CreateVpnGateway.</p>', 'refs' => [], ], 'CreateVpnGatewayResult' => [ 'base' => '<p>Contains the output of CreateVpnGateway.</p>', 'refs' => [], ], 'CreditSpecification' => [ 'base' => '<p>Describes the credit option for CPU usage of a T2, T3, or T3a instance.</p>', 'refs' => [ 'ResponseLaunchTemplateData$CreditSpecification' => '<p>The credit option for CPU usage of the instance.</p>', ], ], 'CreditSpecificationRequest' => [ 'base' => '<p>The credit option for CPU usage of a T2, T3, or T3a instance.</p>', 'refs' => [ 'RequestLaunchTemplateData$CreditSpecification' => '<p>The credit option for CPU usage of the instance. Valid for T2, T3, or T3a instances only.</p>', 'RunInstancesRequest$CreditSpecification' => '<p>The credit option for CPU usage of the burstable performance instance. Valid values are <code>standard</code> and <code>unlimited</code>. To change this attribute after launch, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceCreditSpecification.html"> ModifyInstanceCreditSpecification</a>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable performance instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>Default: <code>standard</code> (T2 instances) or <code>unlimited</code> (T3/T3a instances)</p>', ], ], 'CurrencyCodeValues' => [ 'base' => NULL, 'refs' => [ 'GetHostReservationPurchasePreviewResult$CurrencyCode' => '<p>The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are specified. At this time, the only supported currency is <code>USD</code>.</p>', 'HostOffering$CurrencyCode' => '<p>The currency of the offering.</p>', 'HostReservation$CurrencyCode' => '<p>The currency in which the <code>upfrontPrice</code> and <code>hourlyPrice</code> amounts are specified. At this time, the only supported currency is <code>USD</code>.</p>', 'PriceSchedule$CurrencyCode' => '<p>The currency for transacting the Reserved Instance resale. At this time, the only supported currency is <code>USD</code>.</p>', 'PriceScheduleSpecification$CurrencyCode' => '<p>The currency for transacting the Reserved Instance resale. At this time, the only supported currency is <code>USD</code>.</p>', 'Purchase$CurrencyCode' => '<p>The currency in which the <code>UpfrontPrice</code> and <code>HourlyPrice</code> amounts are specified. At this time, the only supported currency is <code>USD</code>.</p>', 'PurchaseHostReservationRequest$CurrencyCode' => '<p>The currency in which the <code>totalUpfrontPrice</code>, <code>LimitPrice</code>, and <code>totalHourlyPrice</code> amounts are specified. At this time, the only supported currency is <code>USD</code>.</p>', 'PurchaseHostReservationResult$CurrencyCode' => '<p>The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are specified. At this time, the only supported currency is <code>USD</code>.</p>', 'ReservedInstanceLimitPrice$CurrencyCode' => '<p>The currency in which the <code>limitPrice</code> amount is specified. At this time, the only supported currency is <code>USD</code>.</p>', 'ReservedInstances$CurrencyCode' => '<p>The currency of the Reserved Instance. It\'s specified using ISO 4217 standard currency codes. At this time, the only supported currency is <code>USD</code>.</p>', 'ReservedInstancesOffering$CurrencyCode' => '<p>The currency of the Reserved Instance offering you are purchasing. It\'s specified using ISO 4217 standard currency codes. At this time, the only supported currency is <code>USD</code>.</p>', ], ], 'CurrentGenerationFlag' => [ 'base' => NULL, 'refs' => [ 'InstanceTypeInfo$CurrentGeneration' => '<p>Indicates whether the instance type is a current generation.</p>', ], ], 'CustomerGateway' => [ 'base' => '<p>Describes a customer gateway.</p>', 'refs' => [ 'CreateCustomerGatewayResult$CustomerGateway' => '<p>Information about the customer gateway.</p>', 'CustomerGatewayList$member' => NULL, ], ], 'CustomerGatewayId' => [ 'base' => NULL, 'refs' => [ 'CreateVpnConnectionRequest$CustomerGatewayId' => '<p>The ID of the customer gateway.</p>', 'CustomerGatewayIdStringList$member' => NULL, 'DeleteCustomerGatewayRequest$CustomerGatewayId' => '<p>The ID of the customer gateway.</p>', 'ModifyVpnConnectionRequest$CustomerGatewayId' => '<p>The ID of the customer gateway at your end of the VPN connection.</p>', ], ], 'CustomerGatewayIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeCustomerGatewaysRequest$CustomerGatewayIds' => '<p>One or more customer gateway IDs.</p> <p>Default: Describes all your customer gateways.</p>', ], ], 'CustomerGatewayList' => [ 'base' => NULL, 'refs' => [ 'DescribeCustomerGatewaysResult$CustomerGateways' => '<p>Information about one or more customer gateways.</p>', ], ], 'DITMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceTypesRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the next token value.</p>', ], ], 'DITOMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceTypeOfferingsRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the next token value.</p>', ], ], 'DatafeedSubscriptionState' => [ 'base' => NULL, 'refs' => [ 'SpotDatafeedSubscription$State' => '<p>The state of the Spot Instance data feed subscription.</p>', ], ], 'DateTime' => [ 'base' => NULL, 'refs' => [ 'BundleTask$StartTime' => '<p>The time this task started.</p>', 'BundleTask$UpdateTime' => '<p>The time of the most recent update for the task.</p>', 'CapacityReservation$EndDate' => '<p>The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation\'s state changes to <code>expired</code> when it reaches its end date and time.</p>', 'CapacityReservation$CreateDate' => '<p>The date and time at which the Capacity Reservation was created.</p>', 'ClientData$UploadEnd' => '<p>The time that the disk upload ends.</p>', 'ClientData$UploadStart' => '<p>The time that the disk upload starts.</p>', 'CreateCapacityReservationRequest$EndDate' => '<p>The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation\'s state changes to <code>expired</code> when it reaches its end date and time.</p> <p>You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>. Omit <code>EndDate</code> if <code>EndDateType</code> is <code>unlimited</code>.</p> <p>If the <code>EndDateType</code> is <code>limited</code>, the Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.</p>', 'CreateFleetRequest$ValidFrom' => '<p>The start date and time of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The default is to start fulfilling the request immediately.</p>', 'CreateFleetRequest$ValidUntil' => '<p>The end date and time of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.</p>', 'DescribeFleetHistoryRequest$StartTime' => '<p>The start date and time for the events, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'DescribeFleetHistoryResult$LastEvaluatedTime' => '<p>The last date and time for the events, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). All records up to this time were retrieved.</p> <p>If <code>nextToken</code> indicates that there are more results, this value is not present.</p>', 'DescribeFleetHistoryResult$StartTime' => '<p>The start date and time for the events, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'DescribeSpotFleetRequestHistoryRequest$StartTime' => '<p>The starting date and time for the events, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'DescribeSpotFleetRequestHistoryResponse$LastEvaluatedTime' => '<p>The last date and time for the events, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). All records up to this time were retrieved.</p> <p>If <code>nextToken</code> indicates that there are more results, this value is not present.</p>', 'DescribeSpotFleetRequestHistoryResponse$StartTime' => '<p>The starting date and time for the events, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'DescribeSpotPriceHistoryRequest$EndTime' => '<p>The date and time, up to the current date, from which to stop retrieving the price history data, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'DescribeSpotPriceHistoryRequest$StartTime' => '<p>The date and time, up to the past 90 days, from which to start retrieving the price history data, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'EbsInstanceBlockDevice$AttachTime' => '<p>The time stamp when the attachment initiated.</p>', 'ElasticInferenceAcceleratorAssociation$ElasticInferenceAcceleratorAssociationTime' => '<p> The time at which the elastic inference accelerator is associated with an instance. </p>', 'FleetData$CreateTime' => '<p>The creation date and time of the EC2 Fleet.</p>', 'FleetData$ValidFrom' => '<p>The start date and time of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The default is to start fulfilling the request immediately. </p>', 'FleetData$ValidUntil' => '<p>The end date and time of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). At this point, no new instance requests are placed or able to fulfill the request. The default end date is 7 days from the current date. </p>', 'FpgaImage$CreateTime' => '<p>The date and time the AFI was created.</p>', 'FpgaImage$UpdateTime' => '<p>The time of the most recent update to the AFI.</p>', 'GetConsoleOutputResult$Timestamp' => '<p>The time at which the output was last updated.</p>', 'GetPasswordDataResult$Timestamp' => '<p>The time the data was last updated.</p>', 'GetReservedInstancesExchangeQuoteResult$OutputReservedInstancesWillExpireAt' => '<p>The new end date of the reservation term.</p>', 'HistoryRecord$Timestamp' => '<p>The date and time of the event, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'HistoryRecordEntry$Timestamp' => '<p>The date and time of the event, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'Host$AllocationTime' => '<p>The time that the Dedicated Host was allocated.</p>', 'Host$ReleaseTime' => '<p>The time that the Dedicated Host was released.</p>', 'HostReservation$End' => '<p>The date and time that the reservation ends.</p>', 'HostReservation$Start' => '<p>The date and time that the reservation started.</p>', 'IamInstanceProfileAssociation$Timestamp' => '<p>The time the IAM instance profile was associated with the instance.</p>', 'IdFormat$Deadline' => '<p>The date in UTC at which you are permanently switched over to using longer IDs. If a deadline is not yet available for this resource type, this field is not returned.</p>', 'Instance$LaunchTime' => '<p>The time the instance was launched.</p>', 'InstanceNetworkInterfaceAttachment$AttachTime' => '<p>The time stamp when the attachment initiated.</p>', 'InstanceStatusDetails$ImpairedSince' => '<p>The time when a status check failed. For an instance that was launched and impaired, this is the time when the instance was launched.</p>', 'InstanceStatusEvent$NotAfter' => '<p>The latest scheduled end time for the event.</p>', 'InstanceStatusEvent$NotBefore' => '<p>The earliest scheduled start time for the event.</p>', 'InstanceStatusEvent$NotBeforeDeadline' => '<p>The deadline for starting the event.</p>', 'LaunchTemplate$CreateTime' => '<p>The time launch template was created.</p>', 'LaunchTemplateSpotMarketOptions$ValidUntil' => '<p>The end date of the request. For a one-time request, the request remains active until all instances launch, the request is canceled, or this date is reached. If the request is persistent, it remains active until it is canceled or this date and time is reached.</p>', 'LaunchTemplateSpotMarketOptionsRequest$ValidUntil' => '<p>The end date of the request. For a one-time request, the request remains active until all instances launch, the request is canceled, or this date is reached. If the request is persistent, it remains active until it is canceled or this date and time is reached. The default end date is 7 days from the current date.</p>', 'LaunchTemplateVersion$CreateTime' => '<p>The time the version was created.</p>', 'ModifyCapacityReservationRequest$EndDate' => '<p>The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation\'s state changes to <code>expired</code> when it reaches its end date and time.</p> <p>The Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.</p> <p>You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>. Omit <code>EndDate</code> if <code>EndDateType</code> is <code>unlimited</code>.</p>', 'ModifyInstanceEventStartTimeRequest$NotBefore' => '<p>The new date and time when the event will take place.</p>', 'NatGateway$CreateTime' => '<p>The date and time the NAT gateway was created.</p>', 'NatGateway$DeleteTime' => '<p>The date and time the NAT gateway was deleted, if applicable.</p>', 'NetworkInterfaceAttachment$AttachTime' => '<p>The timestamp indicating when the attachment initiated.</p>', 'ProvisionedBandwidth$ProvisionTime' => '<p>Reserved. If you need to sustain traffic greater than the <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html">documented limits</a>, contact us through the <a href="https://console.aws.amazon.com/support/home?">Support Center</a>.</p>', 'ProvisionedBandwidth$RequestTime' => '<p>Reserved. If you need to sustain traffic greater than the <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html">documented limits</a>, contact us through the <a href="https://console.aws.amazon.com/support/home?">Support Center</a>.</p>', 'PurchaseReservedInstancesOfferingRequest$PurchaseTime' => '<p>The time at which to purchase the Reserved Instance, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'ReportInstanceStatusRequest$EndTime' => '<p>The time at which the reported instance health state ended.</p>', 'ReportInstanceStatusRequest$StartTime' => '<p>The time at which the reported instance health state began.</p>', 'RequestSpotInstancesRequest$ValidFrom' => '<p>The start date of the request. If this is a one-time request, the request becomes active at this date and time and remains active until all instances launch, the request expires, or the request is canceled. If the request is persistent, the request becomes active at this date and time and remains active until it expires or is canceled.</p> <p>The specified start date and time cannot be equal to the current date and time. You must specify a start date and time that occurs after the current date and time.</p>', 'RequestSpotInstancesRequest$ValidUntil' => '<p>The end date of the request. If this is a one-time request, the request remains active until all instances launch, the request is canceled, or this date is reached. If the request is persistent, it remains active until it is canceled or this date is reached. The default end date is 7 days from the current date.</p>', 'ReservedInstances$End' => '<p>The time when the Reserved Instance expires.</p>', 'ReservedInstances$Start' => '<p>The date and time the Reserved Instance started.</p>', 'ReservedInstancesListing$CreateDate' => '<p>The time the listing was created.</p>', 'ReservedInstancesListing$UpdateDate' => '<p>The last modified timestamp of the listing.</p>', 'ReservedInstancesModification$CreateDate' => '<p>The time when the modification request was created.</p>', 'ReservedInstancesModification$EffectiveDate' => '<p>The time for the modification to become effective.</p>', 'ReservedInstancesModification$UpdateDate' => '<p>The time when the modification request was last updated.</p>', 'ScheduledInstance$CreateDate' => '<p>The date when the Scheduled Instance was purchased.</p>', 'ScheduledInstance$NextSlotStartTime' => '<p>The time for the next schedule to start.</p>', 'ScheduledInstance$PreviousSlotEndTime' => '<p>The time that the previous schedule ended or will end.</p>', 'ScheduledInstance$TermEndDate' => '<p>The end date for the Scheduled Instance.</p>', 'ScheduledInstance$TermStartDate' => '<p>The start date for the Scheduled Instance.</p>', 'ScheduledInstanceAvailability$FirstSlotStartTime' => '<p>The time period for the first schedule to start.</p>', 'SlotDateTimeRangeRequest$EarliestTime' => '<p>The earliest date and time, in UTC, for the Scheduled Instance to start.</p>', 'SlotDateTimeRangeRequest$LatestTime' => '<p>The latest date and time, in UTC, for the Scheduled Instance to start. This value must be later than or equal to the earliest date and at most three months in the future.</p>', 'SlotStartTimeRangeRequest$EarliestTime' => '<p>The earliest date and time, in UTC, for the Scheduled Instance to start.</p>', 'SlotStartTimeRangeRequest$LatestTime' => '<p>The latest date and time, in UTC, for the Scheduled Instance to start.</p>', 'Snapshot$StartTime' => '<p>The time stamp when the snapshot was initiated.</p>', 'SpotFleetRequestConfigData$ValidFrom' => '<p>The start date and time of the request, in UTC format (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). By default, Amazon EC2 starts fulfilling the request immediately.</p>', 'SpotFleetRequestConfigData$ValidUntil' => '<p>The end date and time of the request, in UTC format (<i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). After the end date and time, no new Spot Instance requests are placed or able to fulfill the request. If no value is specified, the Spot Fleet request remains until you cancel it.</p>', 'SpotInstanceRequest$CreateTime' => '<p>The date and time when the Spot Instance request was created, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'SpotInstanceRequest$ValidFrom' => '<p>The start date of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The request becomes active at this date and time.</p>', 'SpotInstanceRequest$ValidUntil' => '<p>The end date of the request, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). If this is a one-time request, it remains active until all instances launch, the request is canceled, or this date is reached. If the request is persistent, it remains active until it is canceled or this date is reached. The default end date is 7 days from the current date.</p>', 'SpotInstanceStatus$UpdateTime' => '<p>The date and time of the most recent status update, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'SpotMarketOptions$ValidUntil' => '<p>The end date of the request. For a one-time request, the request remains active until all instances launch, the request is canceled, or this date is reached. If the request is persistent, it remains active until it is canceled or this date and time is reached. The default end date is 7 days from the current date.</p>', 'SpotPrice$Timestamp' => '<p>The date and time the request was created, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).</p>', 'TransitGateway$CreationTime' => '<p>The creation time.</p>', 'TransitGatewayAttachment$CreationTime' => '<p>The creation time.</p>', 'TransitGatewayMulticastDomain$CreationTime' => '<p>The time the transit gateway multicast domain was created.</p>', 'TransitGatewayPeeringAttachment$CreationTime' => '<p>The time the transit gateway peering attachment was created.</p>', 'TransitGatewayRouteTable$CreationTime' => '<p>The creation time.</p>', 'TransitGatewayVpcAttachment$CreationTime' => '<p>The creation time.</p>', 'VgwTelemetry$LastStatusChange' => '<p>The date and time of the last change in status.</p>', 'Volume$CreateTime' => '<p>The time stamp when volume creation was initiated.</p>', 'VolumeAttachment$AttachTime' => '<p>The time stamp when the attachment initiated.</p>', 'VolumeModification$StartTime' => '<p>The modification start time.</p>', 'VolumeModification$EndTime' => '<p>The modification completion or failure time.</p>', 'VpcPeeringConnection$ExpirationTime' => '<p>The time that an unaccepted VPC peering connection will expire.</p>', ], ], 'DedicatedHostFlag' => [ 'base' => NULL, 'refs' => [ 'InstanceTypeInfo$DedicatedHostsSupported' => '<p>Indicates whether Dedicated Hosts are supported on the instance type.</p>', ], ], 'DedicatedHostId' => [ 'base' => NULL, 'refs' => [ 'LaunchTemplatePlacementRequest$HostId' => '<p>The ID of the Dedicated Host for the instance.</p>', 'ModifyInstancePlacementRequest$HostId' => '<p>The ID of the Dedicated Host with which to associate the instance.</p>', 'RequestHostIdList$member' => NULL, 'RequestHostIdSet$member' => NULL, ], ], 'DefaultRouteTableAssociationValue' => [ 'base' => NULL, 'refs' => [ 'TransitGatewayOptions$DefaultRouteTableAssociation' => '<p>Indicates whether resource attachments are automatically associated with the default association route table.</p>', 'TransitGatewayRequestOptions$DefaultRouteTableAssociation' => '<p>Enable or disable automatic association with the default association route table. Enabled by default.</p>', ], ], 'DefaultRouteTablePropagationValue' => [ 'base' => NULL, 'refs' => [ 'TransitGatewayOptions$DefaultRouteTablePropagation' => '<p>Indicates whether resource attachments automatically propagate routes to the default propagation route table.</p>', 'TransitGatewayRequestOptions$DefaultRouteTablePropagation' => '<p>Enable or disable automatic propagation of routes to the default propagation route table. Enabled by default.</p>', ], ], 'DefaultTargetCapacityType' => [ 'base' => NULL, 'refs' => [ 'TargetCapacitySpecification$DefaultTargetCapacityType' => '<p>The default <code>TotalTargetCapacity</code>, which is either <code>Spot</code> or <code>On-Demand</code>.</p>', 'TargetCapacitySpecificationRequest$DefaultTargetCapacityType' => '<p>The default <code>TotalTargetCapacity</code>, which is either <code>Spot</code> or <code>On-Demand</code>.</p>', ], ], 'DefaultingDhcpOptionsId' => [ 'base' => NULL, 'refs' => [ 'AssociateDhcpOptionsRequest$DhcpOptionsId' => '<p>The ID of the DHCP options set, or <code>default</code> to associate no DHCP options with the VPC.</p>', ], ], 'DeleteCarrierGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCarrierGatewayResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteClientVpnEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteClientVpnEndpointResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteClientVpnRouteRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteClientVpnRouteResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCustomerGatewayRequest' => [ 'base' => '<p>Contains the parameters for DeleteCustomerGateway.</p>', 'refs' => [], ], 'DeleteDhcpOptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEgressOnlyInternetGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEgressOnlyInternetGatewayResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFleetError' => [ 'base' => '<p>Describes an EC2 Fleet error.</p>', 'refs' => [ 'DeleteFleetErrorItem$Error' => '<p>The error.</p>', ], ], 'DeleteFleetErrorCode' => [ 'base' => NULL, 'refs' => [ 'DeleteFleetError$Code' => '<p>The error code.</p>', ], ], 'DeleteFleetErrorItem' => [ 'base' => '<p>Describes an EC2 Fleet that was not successfully deleted.</p>', 'refs' => [ 'DeleteFleetErrorSet$member' => NULL, ], ], 'DeleteFleetErrorSet' => [ 'base' => NULL, 'refs' => [ 'DeleteFleetsResult$UnsuccessfulFleetDeletions' => '<p>Information about the EC2 Fleets that are not successfully deleted.</p>', ], ], 'DeleteFleetSuccessItem' => [ 'base' => '<p>Describes an EC2 Fleet that was successfully deleted.</p>', 'refs' => [ 'DeleteFleetSuccessSet$member' => NULL, ], ], 'DeleteFleetSuccessSet' => [ 'base' => NULL, 'refs' => [ 'DeleteFleetsResult$SuccessfulFleetDeletions' => '<p>Information about the EC2 Fleets that are successfully deleted.</p>', ], ], 'DeleteFleetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFleetsResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFlowLogsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFlowLogsResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFpgaImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFpgaImageResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInternetGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKeyPairRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLaunchTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLaunchTemplateResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLaunchTemplateVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLaunchTemplateVersionsResponseErrorItem' => [ 'base' => '<p>Describes a launch template version that could not be deleted.</p>', 'refs' => [ 'DeleteLaunchTemplateVersionsResponseErrorSet$member' => NULL, ], ], 'DeleteLaunchTemplateVersionsResponseErrorSet' => [ 'base' => NULL, 'refs' => [ 'DeleteLaunchTemplateVersionsResult$UnsuccessfullyDeletedLaunchTemplateVersions' => '<p>Information about the launch template versions that could not be deleted.</p>', ], ], 'DeleteLaunchTemplateVersionsResponseSuccessItem' => [ 'base' => '<p>Describes a launch template version that was successfully deleted.</p>', 'refs' => [ 'DeleteLaunchTemplateVersionsResponseSuccessSet$member' => NULL, ], ], 'DeleteLaunchTemplateVersionsResponseSuccessSet' => [ 'base' => NULL, 'refs' => [ 'DeleteLaunchTemplateVersionsResult$SuccessfullyDeletedLaunchTemplateVersions' => '<p>Information about the launch template versions that were successfully deleted.</p>', ], ], 'DeleteLaunchTemplateVersionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLocalGatewayRouteRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLocalGatewayRouteResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLocalGatewayRouteTableVpcAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLocalGatewayRouteTableVpcAssociationResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteManagedPrefixListRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteManagedPrefixListResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNatGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNatGatewayResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNetworkAclEntryRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNetworkAclRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNetworkInterfacePermissionRequest' => [ 'base' => '<p>Contains the parameters for DeleteNetworkInterfacePermission.</p>', 'refs' => [], ], 'DeleteNetworkInterfacePermissionResult' => [ 'base' => '<p>Contains the output for DeleteNetworkInterfacePermission.</p>', 'refs' => [], ], 'DeleteNetworkInterfaceRequest' => [ 'base' => '<p>Contains the parameters for DeleteNetworkInterface.</p>', 'refs' => [], ], 'DeletePlacementGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteQueuedReservedInstancesError' => [ 'base' => '<p>Describes the error for a Reserved Instance whose queued purchase could not be deleted.</p>', 'refs' => [ 'FailedQueuedPurchaseDeletion$Error' => '<p>The error.</p>', ], ], 'DeleteQueuedReservedInstancesErrorCode' => [ 'base' => NULL, 'refs' => [ 'DeleteQueuedReservedInstancesError$Code' => '<p>The error code.</p>', ], ], 'DeleteQueuedReservedInstancesIdList' => [ 'base' => NULL, 'refs' => [ 'DeleteQueuedReservedInstancesRequest$ReservedInstancesIds' => '<p>The IDs of the Reserved Instances.</p>', ], ], 'DeleteQueuedReservedInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteQueuedReservedInstancesResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRouteRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRouteTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSecurityGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSpotDatafeedSubscriptionRequest' => [ 'base' => '<p>Contains the parameters for DeleteSpotDatafeedSubscription.</p>', 'refs' => [], ], 'DeleteSubnetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrafficMirrorFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrafficMirrorFilterResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrafficMirrorFilterRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrafficMirrorFilterRuleResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrafficMirrorSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrafficMirrorSessionResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrafficMirrorTargetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrafficMirrorTargetResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayMulticastDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayMulticastDomainResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayPeeringAttachmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayPeeringAttachmentResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayRouteRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayRouteResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayRouteTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayRouteTableResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayVpcAttachmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransitGatewayVpcAttachmentResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVolumeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVpcEndpointConnectionNotificationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVpcEndpointConnectionNotificationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVpcEndpointServiceConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVpcEndpointServiceConfigurationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVpcEndpointsRequest' => [ 'base' => '<p>Contains the parameters for DeleteVpcEndpoints.</p>', 'refs' => [], ], 'DeleteVpcEndpointsResult' => [ 'base' => '<p>Contains the output of DeleteVpcEndpoints.</p>', 'refs' => [], ], 'DeleteVpcPeeringConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVpcPeeringConnectionResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVpcRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVpnConnectionRequest' => [ 'base' => '<p>Contains the parameters for DeleteVpnConnection.</p>', 'refs' => [], ], 'DeleteVpnConnectionRouteRequest' => [ 'base' => '<p>Contains the parameters for DeleteVpnConnectionRoute.</p>', 'refs' => [], ], 'DeleteVpnGatewayRequest' => [ 'base' => '<p>Contains the parameters for DeleteVpnGateway.</p>', 'refs' => [], ], 'DeprovisionByoipCidrRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeprovisionByoipCidrResult' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterImageRequest' => [ 'base' => '<p>Contains the parameters for DeregisterImage.</p>', 'refs' => [], ], 'DeregisterInstanceEventNotificationAttributesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterInstanceEventNotificationAttributesResult' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterInstanceTagAttributeRequest' => [ 'base' => '<p>Information about the tag keys to deregister for the current Region. You can either specify individual tag keys or deregister all tag keys in the current Region. You must specify either <code>IncludeAllTagsOfInstance</code> or <code>InstanceTagKeys</code> in the request</p>', 'refs' => [ 'DeregisterInstanceEventNotificationAttributesRequest$InstanceTagAttribute' => '<p>Information about the tag keys to deregister.</p>', ], ], 'DeregisterTransitGatewayMulticastGroupMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterTransitGatewayMulticastGroupMembersResult' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterTransitGatewayMulticastGroupSourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterTransitGatewayMulticastGroupSourcesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountAttributesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountAttributesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAddressesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAddressesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAggregateIdFormatRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAggregateIdFormatResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAvailabilityZonesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAvailabilityZonesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBundleTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBundleTasksResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeByoipCidrsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeByoipCidrsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'DescribeByoipCidrsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeByoipCidrsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCapacityReservationsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeCapacityReservationsRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.</p>', ], ], 'DescribeCapacityReservationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCapacityReservationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCarrierGatewaysRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCarrierGatewaysResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClassicLinkInstancesMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeClassicLinkInstancesRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p> <p>Constraint: If the value is greater than 1000, we return only 1000 items.</p>', ], ], 'DescribeClassicLinkInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClassicLinkInstancesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClientVpnAuthorizationRulesMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeClientVpnAuthorizationRulesRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>', ], ], 'DescribeClientVpnAuthorizationRulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClientVpnAuthorizationRulesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClientVpnConnectionsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeClientVpnConnectionsRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>', ], ], 'DescribeClientVpnConnectionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClientVpnConnectionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClientVpnEndpointMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeClientVpnEndpointsRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>', ], ], 'DescribeClientVpnEndpointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClientVpnEndpointsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClientVpnRoutesMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeClientVpnRoutesRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>', ], ], 'DescribeClientVpnRoutesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClientVpnRoutesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClientVpnTargetNetworksMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeClientVpnTargetNetworksRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>', ], ], 'DescribeClientVpnTargetNetworksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClientVpnTargetNetworksResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCoipPoolsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCoipPoolsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConversionTaskList' => [ 'base' => NULL, 'refs' => [ 'DescribeConversionTasksResult$ConversionTasks' => '<p>Information about the conversion tasks.</p>', ], ], 'DescribeConversionTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConversionTasksResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCustomerGatewaysRequest' => [ 'base' => '<p>Contains the parameters for DescribeCustomerGateways.</p>', 'refs' => [], ], 'DescribeCustomerGatewaysResult' => [ 'base' => '<p>Contains the output of DescribeCustomerGateways.</p>', 'refs' => [], ], 'DescribeDhcpOptionsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeDhcpOptionsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'DescribeDhcpOptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDhcpOptionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEgressOnlyInternetGatewaysMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeEgressOnlyInternetGatewaysRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'DescribeEgressOnlyInternetGatewaysRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEgressOnlyInternetGatewaysResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeElasticGpusMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeElasticGpusRequest$MaxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. This value can be between 5 and 1000.</p>', ], ], 'DescribeElasticGpusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeElasticGpusResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExportImageTasksMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeExportImageTasksRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', ], ], 'DescribeExportImageTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExportImageTasksResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExportTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExportTasksResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFastSnapshotRestoreSuccessItem' => [ 'base' => '<p>Describes fast snapshot restores for a snapshot.</p>', 'refs' => [ 'DescribeFastSnapshotRestoreSuccessSet$member' => NULL, ], ], 'DescribeFastSnapshotRestoreSuccessSet' => [ 'base' => NULL, 'refs' => [ 'DescribeFastSnapshotRestoresResult$FastSnapshotRestores' => '<p>Information about the state of fast snapshot restores.</p>', ], ], 'DescribeFastSnapshotRestoresMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeFastSnapshotRestoresRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'DescribeFastSnapshotRestoresRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFastSnapshotRestoresResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFleetError' => [ 'base' => '<p>Describes the instances that could not be launched by the fleet.</p>', 'refs' => [ 'DescribeFleetsErrorSet$member' => NULL, ], ], 'DescribeFleetHistoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFleetHistoryResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFleetInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFleetInstancesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFleetsErrorSet' => [ 'base' => NULL, 'refs' => [ 'FleetData$Errors' => '<p>Information about the instances that could not be launched by the fleet. Valid only when <b>Type</b> is set to <code>instant</code>.</p>', ], ], 'DescribeFleetsInstances' => [ 'base' => '<p>Describes the instances that were launched by the fleet.</p>', 'refs' => [ 'DescribeFleetsInstancesSet$member' => NULL, ], ], 'DescribeFleetsInstancesSet' => [ 'base' => NULL, 'refs' => [ 'FleetData$Instances' => '<p>Information about the instances that were launched by the fleet. Valid only when <b>Type</b> is set to <code>instant</code>.</p>', ], ], 'DescribeFleetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFleetsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFlowLogsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFlowLogsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFpgaImageAttributeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFpgaImageAttributeResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFpgaImagesMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeFpgaImagesRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', ], ], 'DescribeFpgaImagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFpgaImagesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHostReservationOfferingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHostReservationOfferingsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHostReservationsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeHostReservationOfferingsRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.</p>', ], ], 'DescribeHostReservationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHostReservationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHostsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHostsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIamInstanceProfileAssociationsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeIamInstanceProfileAssociationsRequest$MaxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', ], ], 'DescribeIamInstanceProfileAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIamInstanceProfileAssociationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIdFormatRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIdFormatResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIdentityIdFormatRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIdentityIdFormatResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImageAttributeRequest' => [ 'base' => '<p>Contains the parameters for DescribeImageAttribute.</p>', 'refs' => [], ], 'DescribeImagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImagesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImportImageTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImportImageTasksResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImportSnapshotTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImportSnapshotTasksResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceAttributeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceCreditSpecificationsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceCreditSpecificationsRequest$MaxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. This value can be between 5 and 1000. You cannot specify this parameter and the instance IDs parameter in the same call.</p>', ], ], 'DescribeInstanceCreditSpecificationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceCreditSpecificationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceEventNotificationAttributesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceEventNotificationAttributesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceStatusResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceTypeOfferingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceTypeOfferingsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceTypesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceTypesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstancesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInternetGatewaysMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeInternetGatewaysRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'DescribeInternetGatewaysRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInternetGatewaysResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIpv6PoolsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeIpv6PoolsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeKeyPairsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeKeyPairsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLaunchTemplateVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLaunchTemplateVersionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLaunchTemplatesMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeLaunchTemplatesRequest$MaxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. This value can be between 1 and 200.</p>', ], ], 'DescribeLaunchTemplatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLaunchTemplatesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocalGatewayRouteTableVpcAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocalGatewayRouteTableVpcAssociationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocalGatewayRouteTablesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocalGatewayRouteTablesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocalGatewayVirtualInterfaceGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocalGatewayVirtualInterfaceGroupsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocalGatewayVirtualInterfacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocalGatewayVirtualInterfacesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocalGatewaysRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLocalGatewaysResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeManagedPrefixListsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeManagedPrefixListsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMovingAddressesMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeMovingAddressesRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results of the initial request can be seen by sending another request with the returned <code>NextToken</code> value. This value can be between 5 and 1000; if <code>MaxResults</code> is given a value outside of this range, an error is returned.</p> <p>Default: If no value is provided, the default is 1000.</p>', ], ], 'DescribeMovingAddressesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMovingAddressesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNatGatewaysMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeNatGatewaysRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'DescribeNatGatewaysRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNatGatewaysResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNetworkAclsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeNetworkAclsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'DescribeNetworkAclsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNetworkAclsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNetworkInterfaceAttributeRequest' => [ 'base' => '<p>Contains the parameters for DescribeNetworkInterfaceAttribute.</p>', 'refs' => [], ], 'DescribeNetworkInterfaceAttributeResult' => [ 'base' => '<p>Contains the output of DescribeNetworkInterfaceAttribute.</p>', 'refs' => [], ], 'DescribeNetworkInterfacePermissionsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeNetworkInterfacePermissionsRequest$MaxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. If this parameter is not specified, up to 50 results are returned by default.</p>', ], ], 'DescribeNetworkInterfacePermissionsRequest' => [ 'base' => '<p>Contains the parameters for DescribeNetworkInterfacePermissions.</p>', 'refs' => [], ], 'DescribeNetworkInterfacePermissionsResult' => [ 'base' => '<p>Contains the output for DescribeNetworkInterfacePermissions.</p>', 'refs' => [], ], 'DescribeNetworkInterfacesMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeNetworkInterfacesRequest$MaxResults' => '<p>The maximum number of items to return for this request. The request returns a token that you can specify in a subsequent call to get the next set of results. You cannot specify this parameter and the network interface IDs parameter in the same request.</p>', ], ], 'DescribeNetworkInterfacesRequest' => [ 'base' => '<p>Contains the parameters for DescribeNetworkInterfaces.</p>', 'refs' => [], ], 'DescribeNetworkInterfacesResult' => [ 'base' => '<p>Contains the output of DescribeNetworkInterfaces.</p>', 'refs' => [], ], 'DescribePlacementGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePlacementGroupsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribePrefixListsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePrefixListsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribePrincipalIdFormatMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribePrincipalIdFormatRequest$MaxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned NextToken value. </p>', ], ], 'DescribePrincipalIdFormatRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePrincipalIdFormatResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribePublicIpv4PoolsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePublicIpv4PoolsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRegionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRegionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReservedInstancesListingsRequest' => [ 'base' => '<p>Contains the parameters for DescribeReservedInstancesListings.</p>', 'refs' => [], ], 'DescribeReservedInstancesListingsResult' => [ 'base' => '<p>Contains the output of DescribeReservedInstancesListings.</p>', 'refs' => [], ], 'DescribeReservedInstancesModificationsRequest' => [ 'base' => '<p>Contains the parameters for DescribeReservedInstancesModifications.</p>', 'refs' => [], ], 'DescribeReservedInstancesModificationsResult' => [ 'base' => '<p>Contains the output of DescribeReservedInstancesModifications.</p>', 'refs' => [], ], 'DescribeReservedInstancesOfferingsRequest' => [ 'base' => '<p>Contains the parameters for DescribeReservedInstancesOfferings.</p>', 'refs' => [], ], 'DescribeReservedInstancesOfferingsResult' => [ 'base' => '<p>Contains the output of DescribeReservedInstancesOfferings.</p>', 'refs' => [], ], 'DescribeReservedInstancesRequest' => [ 'base' => '<p>Contains the parameters for DescribeReservedInstances.</p>', 'refs' => [], ], 'DescribeReservedInstancesResult' => [ 'base' => '<p>Contains the output for DescribeReservedInstances.</p>', 'refs' => [], ], 'DescribeRouteTablesMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeRouteTablesRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'DescribeRouteTablesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRouteTablesResult' => [ 'base' => '<p>Contains the output of DescribeRouteTables.</p>', 'refs' => [], ], 'DescribeScheduledInstanceAvailabilityMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeScheduledInstanceAvailabilityRequest$MaxResults' => '<p>The maximum number of results to return in a single call. This value can be between 5 and 300. The default value is 300. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', ], ], 'DescribeScheduledInstanceAvailabilityRequest' => [ 'base' => '<p>Contains the parameters for DescribeScheduledInstanceAvailability.</p>', 'refs' => [], ], 'DescribeScheduledInstanceAvailabilityResult' => [ 'base' => '<p>Contains the output of DescribeScheduledInstanceAvailability.</p>', 'refs' => [], ], 'DescribeScheduledInstancesRequest' => [ 'base' => '<p>Contains the parameters for DescribeScheduledInstances.</p>', 'refs' => [], ], 'DescribeScheduledInstancesResult' => [ 'base' => '<p>Contains the output of DescribeScheduledInstances.</p>', 'refs' => [], ], 'DescribeSecurityGroupReferencesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSecurityGroupReferencesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSecurityGroupsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeSecurityGroupsRequest$MaxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another request with the returned <code>NextToken</code> value. This value can be between 5 and 1000. If this parameter is not specified, then all results are returned.</p>', ], ], 'DescribeSecurityGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSecurityGroupsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSnapshotAttributeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSnapshotAttributeResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSnapshotsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSnapshotsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSpotDatafeedSubscriptionRequest' => [ 'base' => '<p>Contains the parameters for DescribeSpotDatafeedSubscription.</p>', 'refs' => [], ], 'DescribeSpotDatafeedSubscriptionResult' => [ 'base' => '<p>Contains the output of DescribeSpotDatafeedSubscription.</p>', 'refs' => [], ], 'DescribeSpotFleetInstancesMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeSpotFleetInstancesRequest$MaxResults' => '<p>The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default value is 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', ], ], 'DescribeSpotFleetInstancesRequest' => [ 'base' => '<p>Contains the parameters for DescribeSpotFleetInstances.</p>', 'refs' => [], ], 'DescribeSpotFleetInstancesResponse' => [ 'base' => '<p>Contains the output of DescribeSpotFleetInstances.</p>', 'refs' => [], ], 'DescribeSpotFleetRequestHistoryMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeSpotFleetRequestHistoryRequest$MaxResults' => '<p>The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default value is 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', ], ], 'DescribeSpotFleetRequestHistoryRequest' => [ 'base' => '<p>Contains the parameters for DescribeSpotFleetRequestHistory.</p>', 'refs' => [], ], 'DescribeSpotFleetRequestHistoryResponse' => [ 'base' => '<p>Contains the output of DescribeSpotFleetRequestHistory.</p>', 'refs' => [], ], 'DescribeSpotFleetRequestsRequest' => [ 'base' => '<p>Contains the parameters for DescribeSpotFleetRequests.</p>', 'refs' => [], ], 'DescribeSpotFleetRequestsResponse' => [ 'base' => '<p>Contains the output of DescribeSpotFleetRequests.</p>', 'refs' => [], ], 'DescribeSpotInstanceRequestsRequest' => [ 'base' => '<p>Contains the parameters for DescribeSpotInstanceRequests.</p>', 'refs' => [], ], 'DescribeSpotInstanceRequestsResult' => [ 'base' => '<p>Contains the output of DescribeSpotInstanceRequests.</p>', 'refs' => [], ], 'DescribeSpotPriceHistoryRequest' => [ 'base' => '<p>Contains the parameters for DescribeSpotPriceHistory.</p>', 'refs' => [], ], 'DescribeSpotPriceHistoryResult' => [ 'base' => '<p>Contains the output of DescribeSpotPriceHistory.</p>', 'refs' => [], ], 'DescribeStaleSecurityGroupsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeStaleSecurityGroupsRequest$MaxResults' => '<p>The maximum number of items to return for this request. The request returns a token that you can specify in a subsequent call to get the next set of results.</p>', ], ], 'DescribeStaleSecurityGroupsNextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeStaleSecurityGroupsRequest$NextToken' => '<p>The token for the next set of items to return. (You received this token from a prior call.)</p>', ], ], 'DescribeStaleSecurityGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStaleSecurityGroupsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSubnetsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeSubnetsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'DescribeSubnetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSubnetsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTagsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrafficMirrorFiltersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrafficMirrorFiltersResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrafficMirrorSessionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrafficMirrorSessionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrafficMirrorTargetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrafficMirrorTargetsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewayAttachmentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewayAttachmentsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewayMulticastDomainsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewayMulticastDomainsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewayPeeringAttachmentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewayPeeringAttachmentsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewayRouteTablesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewayRouteTablesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewayVpcAttachmentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewayVpcAttachmentsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewaysRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransitGatewaysResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVolumeAttributeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVolumeAttributeResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVolumeStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVolumeStatusResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVolumesModificationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVolumesModificationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVolumesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVolumesResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcAttributeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcAttributeResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcClassicLinkDnsSupportMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeVpcClassicLinkDnsSupportRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'DescribeVpcClassicLinkDnsSupportNextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeVpcClassicLinkDnsSupportRequest$NextToken' => '<p>The token for the next page of results.</p>', 'DescribeVpcClassicLinkDnsSupportResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', ], ], 'DescribeVpcClassicLinkDnsSupportRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcClassicLinkDnsSupportResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcClassicLinkRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcClassicLinkResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcEndpointConnectionNotificationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcEndpointConnectionNotificationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcEndpointConnectionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcEndpointConnectionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcEndpointServiceConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcEndpointServiceConfigurationsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcEndpointServicePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcEndpointServicePermissionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcEndpointServicesRequest' => [ 'base' => '<p>Contains the parameters for DescribeVpcEndpointServices.</p>', 'refs' => [], ], 'DescribeVpcEndpointServicesResult' => [ 'base' => '<p>Contains the output of DescribeVpcEndpointServices.</p>', 'refs' => [], ], 'DescribeVpcEndpointsRequest' => [ 'base' => '<p>Contains the parameters for DescribeVpcEndpoints.</p>', 'refs' => [], ], 'DescribeVpcEndpointsResult' => [ 'base' => '<p>Contains the output of DescribeVpcEndpoints.</p>', 'refs' => [], ], 'DescribeVpcPeeringConnectionsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeVpcPeeringConnectionsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'DescribeVpcPeeringConnectionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcPeeringConnectionsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeVpcsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'DescribeVpcsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpnConnectionsRequest' => [ 'base' => '<p>Contains the parameters for DescribeVpnConnections.</p>', 'refs' => [], ], 'DescribeVpnConnectionsResult' => [ 'base' => '<p>Contains the output of DescribeVpnConnections.</p>', 'refs' => [], ], 'DescribeVpnGatewaysRequest' => [ 'base' => '<p>Contains the parameters for DescribeVpnGateways.</p>', 'refs' => [], ], 'DescribeVpnGatewaysResult' => [ 'base' => '<p>Contains the output of DescribeVpnGateways.</p>', 'refs' => [], ], 'DetachClassicLinkVpcRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetachClassicLinkVpcResult' => [ 'base' => NULL, 'refs' => [], ], 'DetachInternetGatewayRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetachNetworkInterfaceRequest' => [ 'base' => '<p>Contains the parameters for DetachNetworkInterface.</p>', 'refs' => [], ], 'DetachVolumeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetachVpnGatewayRequest' => [ 'base' => '<p>Contains the parameters for DetachVpnGateway.</p>', 'refs' => [], ], 'DeviceType' => [ 'base' => NULL, 'refs' => [ 'Image$RootDeviceType' => '<p>The type of root device used by the AMI. The AMI can use an EBS volume or an instance store volume.</p>', 'Instance$RootDeviceType' => '<p>The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.</p>', ], ], 'DhcpConfiguration' => [ 'base' => '<p>Describes a DHCP configuration option.</p>', 'refs' => [ 'DhcpConfigurationList$member' => NULL, ], ], 'DhcpConfigurationList' => [ 'base' => NULL, 'refs' => [ 'DhcpOptions$DhcpConfigurations' => '<p>One or more DHCP options in the set.</p>', ], ], 'DhcpConfigurationValueList' => [ 'base' => NULL, 'refs' => [ 'DhcpConfiguration$Values' => '<p>One or more values for the DHCP option.</p>', ], ], 'DhcpOptions' => [ 'base' => '<p>Describes a set of DHCP options.</p>', 'refs' => [ 'CreateDhcpOptionsResult$DhcpOptions' => '<p>A set of DHCP options.</p>', 'DhcpOptionsList$member' => NULL, ], ], 'DhcpOptionsId' => [ 'base' => NULL, 'refs' => [ 'DeleteDhcpOptionsRequest$DhcpOptionsId' => '<p>The ID of the DHCP options set.</p>', 'DhcpOptionsIdStringList$member' => NULL, ], ], 'DhcpOptionsIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeDhcpOptionsRequest$DhcpOptionsIds' => '<p>The IDs of one or more DHCP options sets.</p> <p>Default: Describes all your DHCP options sets.</p>', ], ], 'DhcpOptionsList' => [ 'base' => NULL, 'refs' => [ 'DescribeDhcpOptionsResult$DhcpOptions' => '<p>Information about one or more DHCP options sets.</p>', ], ], 'DirectoryServiceAuthentication' => [ 'base' => '<p>Describes an Active Directory.</p>', 'refs' => [ 'ClientVpnAuthentication$ActiveDirectory' => '<p>Information about the Active Directory, if applicable.</p>', ], ], 'DirectoryServiceAuthenticationRequest' => [ 'base' => '<p>Describes the Active Directory to be used for client authentication.</p>', 'refs' => [ 'ClientVpnAuthenticationRequest$ActiveDirectory' => '<p>Information about the Active Directory to be used, if applicable. You must provide this information if <b>Type</b> is <code>directory-service-authentication</code>.</p>', ], ], 'DisableEbsEncryptionByDefaultRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableEbsEncryptionByDefaultResult' => [ 'base' => NULL, 'refs' => [], ], 'DisableFastSnapshotRestoreErrorItem' => [ 'base' => '<p>Contains information about the errors that occurred when disabling fast snapshot restores.</p>', 'refs' => [ 'DisableFastSnapshotRestoreErrorSet$member' => NULL, ], ], 'DisableFastSnapshotRestoreErrorSet' => [ 'base' => NULL, 'refs' => [ 'DisableFastSnapshotRestoresResult$Unsuccessful' => '<p>Information about the snapshots for which fast snapshot restores could not be disabled.</p>', ], ], 'DisableFastSnapshotRestoreStateError' => [ 'base' => '<p>Describes an error that occurred when disabling fast snapshot restores.</p>', 'refs' => [ 'DisableFastSnapshotRestoreStateErrorItem$Error' => '<p>The error.</p>', ], ], 'DisableFastSnapshotRestoreStateErrorItem' => [ 'base' => '<p>Contains information about an error that occurred when disabling fast snapshot restores.</p>', 'refs' => [ 'DisableFastSnapshotRestoreStateErrorSet$member' => NULL, ], ], 'DisableFastSnapshotRestoreStateErrorSet' => [ 'base' => NULL, 'refs' => [ 'DisableFastSnapshotRestoreErrorItem$FastSnapshotRestoreStateErrors' => '<p>The errors.</p>', ], ], 'DisableFastSnapshotRestoreSuccessItem' => [ 'base' => '<p>Describes fast snapshot restores that were successfully disabled.</p>', 'refs' => [ 'DisableFastSnapshotRestoreSuccessSet$member' => NULL, ], ], 'DisableFastSnapshotRestoreSuccessSet' => [ 'base' => NULL, 'refs' => [ 'DisableFastSnapshotRestoresResult$Successful' => '<p>Information about the snapshots for which fast snapshot restores were successfully disabled.</p>', ], ], 'DisableFastSnapshotRestoresRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableFastSnapshotRestoresResult' => [ 'base' => NULL, 'refs' => [], ], 'DisableTransitGatewayRouteTablePropagationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableTransitGatewayRouteTablePropagationResult' => [ 'base' => NULL, 'refs' => [], ], 'DisableVgwRoutePropagationRequest' => [ 'base' => '<p>Contains the parameters for DisableVgwRoutePropagation.</p>', 'refs' => [], ], 'DisableVpcClassicLinkDnsSupportRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableVpcClassicLinkDnsSupportResult' => [ 'base' => NULL, 'refs' => [], ], 'DisableVpcClassicLinkRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisableVpcClassicLinkResult' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateAddressRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateClientVpnTargetNetworkRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateClientVpnTargetNetworkResult' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateIamInstanceProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateIamInstanceProfileResult' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateRouteTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateSubnetCidrBlockRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateSubnetCidrBlockResult' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateTransitGatewayMulticastDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateTransitGatewayMulticastDomainResult' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateTransitGatewayRouteTableRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateTransitGatewayRouteTableResult' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateVpcCidrBlockRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateVpcCidrBlockResult' => [ 'base' => NULL, 'refs' => [], ], 'DiskCount' => [ 'base' => NULL, 'refs' => [ 'DiskInfo$Count' => '<p>The number of disks with this configuration.</p>', ], ], 'DiskImage' => [ 'base' => '<p>Describes a disk image.</p>', 'refs' => [ 'DiskImageList$member' => NULL, ], ], 'DiskImageDescription' => [ 'base' => '<p>Describes a disk image.</p>', 'refs' => [ 'ImportInstanceVolumeDetailItem$Image' => '<p>The image.</p>', 'ImportVolumeTaskDetails$Image' => '<p>The image.</p>', ], ], 'DiskImageDetail' => [ 'base' => '<p>Describes a disk image.</p>', 'refs' => [ 'DiskImage$Image' => '<p>Information about the disk image.</p>', 'ImportVolumeRequest$Image' => '<p>The disk image.</p>', ], ], 'DiskImageFormat' => [ 'base' => NULL, 'refs' => [ 'DiskImageDescription$Format' => '<p>The disk image format.</p>', 'DiskImageDetail$Format' => '<p>The disk image format.</p>', 'ExportImageRequest$DiskImageFormat' => '<p>The disk image format.</p>', 'ExportImageResult$DiskImageFormat' => '<p>The disk image format for the exported image.</p>', 'ExportToS3Task$DiskImageFormat' => '<p>The format for the exported image.</p>', 'ExportToS3TaskSpecification$DiskImageFormat' => '<p>The format for the exported image.</p>', ], ], 'DiskImageList' => [ 'base' => NULL, 'refs' => [ 'ImportInstanceRequest$DiskImages' => '<p>The disk image.</p>', ], ], 'DiskImageVolumeDescription' => [ 'base' => '<p>Describes a disk image volume.</p>', 'refs' => [ 'ImportInstanceVolumeDetailItem$Volume' => '<p>The volume.</p>', 'ImportVolumeTaskDetails$Volume' => '<p>The volume.</p>', ], ], 'DiskInfo' => [ 'base' => '<p>Describes the disk.</p>', 'refs' => [ 'DiskInfoList$member' => NULL, ], ], 'DiskInfoList' => [ 'base' => NULL, 'refs' => [ 'InstanceStorageInfo$Disks' => '<p>Array describing the disks that are available for the instance type.</p>', ], ], 'DiskSize' => [ 'base' => NULL, 'refs' => [ 'DiskInfo$SizeInGB' => '<p>The size of the disk in GB.</p>', 'InstanceStorageInfo$TotalSizeInGB' => '<p>The total size of the disks, in GB.</p>', ], ], 'DiskType' => [ 'base' => NULL, 'refs' => [ 'DiskInfo$Type' => '<p>The type of disk.</p>', ], ], 'DnsEntry' => [ 'base' => '<p>Describes a DNS entry.</p>', 'refs' => [ 'DnsEntrySet$member' => NULL, ], ], 'DnsEntrySet' => [ 'base' => NULL, 'refs' => [ 'VpcEndpoint$DnsEntries' => '<p>(Interface endpoint) The DNS entries for the endpoint.</p>', 'VpcEndpointConnection$DnsEntries' => '<p>The DNS entries for the VPC endpoint.</p>', ], ], 'DnsNameState' => [ 'base' => NULL, 'refs' => [ 'PrivateDnsNameConfiguration$State' => '<p>The verification state of the VPC endpoint service.</p> <p>&gt;Consumers of the endpoint service can use the private name only when the state is <code>verified</code>.</p>', 'ServiceDetail$PrivateDnsNameVerificationState' => '<p>The verification state of the VPC endpoint service.</p> <p>Consumers of the endpoint service cannot use the private name when the state is not <code>verified</code>.</p>', ], ], 'DnsServersOptionsModifyStructure' => [ 'base' => '<p>Information about the DNS server to be used.</p>', 'refs' => [ 'ModifyClientVpnEndpointRequest$DnsServers' => '<p>Information about the DNS servers to be used by Client VPN connections. A Client VPN endpoint can have up to two DNS servers.</p>', ], ], 'DnsSupportValue' => [ 'base' => NULL, 'refs' => [ 'CreateTransitGatewayVpcAttachmentRequestOptions$DnsSupport' => '<p>Enable or disable DNS support. The default is <code>enable</code>.</p>', 'ModifyTransitGatewayVpcAttachmentRequestOptions$DnsSupport' => '<p>Enable or disable DNS support. The default is <code>enable</code>.</p>', 'TransitGatewayOptions$DnsSupport' => '<p>Indicates whether DNS support is enabled.</p>', 'TransitGatewayRequestOptions$DnsSupport' => '<p>Enable or disable DNS support. Enabled by default.</p>', 'TransitGatewayVpcAttachmentOptions$DnsSupport' => '<p>Indicates whether DNS support is enabled.</p>', ], ], 'DomainType' => [ 'base' => NULL, 'refs' => [ 'Address$Domain' => '<p>Indicates whether this Elastic IP address is for use with instances in EC2-Classic (<code>standard</code>) or instances in a VPC (<code>vpc</code>).</p>', 'AllocateAddressRequest$Domain' => '<p>Indicates whether the Elastic IP address is for use with instances in a VPC or instances in EC2-Classic.</p> <p>Default: If the Region supports EC2-Classic, the default is <code>standard</code>. Otherwise, the default is <code>vpc</code>.</p>', 'AllocateAddressResult$Domain' => '<p>Indicates whether the Elastic IP address is for use with instances in a VPC (<code>vpc</code>) or instances in EC2-Classic (<code>standard</code>).</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'ClientData$UploadSize' => '<p>The size of the uploaded disk image, in GiB.</p>', 'FleetData$FulfilledCapacity' => '<p>The number of units fulfilled by this request compared to the set target capacity.</p>', 'FleetData$FulfilledOnDemandCapacity' => '<p>The number of units fulfilled by this request compared to the set target On-Demand capacity.</p>', 'FleetLaunchTemplateOverrides$WeightedCapacity' => '<p>The number of units provided by the specified instance type.</p>', 'FleetLaunchTemplateOverrides$Priority' => '<p>The priority for the launch template override. If <b>AllocationStrategy</b> is set to <code>prioritized</code>, EC2 Fleet uses priority to determine which launch template override to use first in fulfilling On-Demand capacity. The highest priority is launched first. Valid values are whole numbers starting at <code>0</code>. The lower the number, the higher the priority. If no number is set, the override has the lowest priority.</p>', 'FleetLaunchTemplateOverridesRequest$WeightedCapacity' => '<p>The number of units provided by the specified instance type.</p>', 'FleetLaunchTemplateOverridesRequest$Priority' => '<p>The priority for the launch template override. If <b>AllocationStrategy</b> is set to <code>prioritized</code>, EC2 Fleet uses priority to determine which launch template override to use first in fulfilling On-Demand capacity. The highest priority is launched first. Valid values are whole numbers starting at <code>0</code>. The lower the number, the higher the priority. If no number is set, the launch template override has the lowest priority.</p>', 'LaunchTemplateOverrides$WeightedCapacity' => '<p>The number of units provided by the specified instance type.</p>', 'LaunchTemplateOverrides$Priority' => '<p>The priority for the launch template override. If <b>OnDemandAllocationStrategy</b> is set to <code>prioritized</code>, Spot Fleet uses priority to determine which launch template override to use first in fulfilling On-Demand capacity. The highest priority is launched first. Valid values are whole numbers starting at <code>0</code>. The lower the number, the higher the priority. If no number is set, the launch template override has the lowest priority.</p>', 'PriceSchedule$Price' => '<p>The fixed price for the term.</p>', 'PriceScheduleSpecification$Price' => '<p>The fixed price for the term.</p>', 'PricingDetail$Price' => '<p>The price per instance.</p>', 'RecurringCharge$Amount' => '<p>The amount of the recurring charge.</p>', 'ReservedInstanceLimitPrice$Amount' => '<p>Used for Reserved Instance Marketplace offerings. Specifies the limit price on the total order (instanceCount * price).</p>', 'SnapshotDetail$DiskImageSize' => '<p>The size of the disk in the snapshot, in GiB.</p>', 'SnapshotTaskDetail$DiskImageSize' => '<p>The size of the disk in the snapshot, in GiB.</p>', 'SpotFleetLaunchSpecification$WeightedCapacity' => '<p>The number of units provided by the specified instance type. These are the same units that you chose to set the target capacity in terms of instances, or a performance characteristic such as vCPUs, memory, or I/O.</p> <p>If the target capacity divided by this value is not a whole number, Amazon EC2 rounds the number of instances to the next whole number. If this value is not specified, the default is 1.</p>', 'SpotFleetRequestConfigData$FulfilledCapacity' => '<p>The number of units fulfilled by this request compared to the set target capacity. You cannot set this value.</p>', 'SpotFleetRequestConfigData$OnDemandFulfilledCapacity' => '<p>The number of On-Demand units fulfilled by this request compared to the set target On-Demand capacity.</p>', ], ], 'EbsBlockDevice' => [ 'base' => '<p>Describes a block device for an EBS volume.</p>', 'refs' => [ 'BlockDeviceMapping$Ebs' => '<p>Parameters used to automatically set up EBS volumes when the instance is launched.</p>', ], ], 'EbsEncryptionSupport' => [ 'base' => NULL, 'refs' => [ 'EbsInfo$EncryptionSupport' => '<p>Indicates whether Amazon EBS encryption is supported.</p>', ], ], 'EbsInfo' => [ 'base' => '<p>Describes the Amazon EBS features supported by the instance type.</p>', 'refs' => [ 'InstanceTypeInfo$EbsInfo' => '<p>Describes the Amazon EBS settings for the instance type.</p>', ], ], 'EbsInstanceBlockDevice' => [ 'base' => '<p>Describes a parameter used to set up an EBS volume in a block device mapping.</p>', 'refs' => [ 'InstanceBlockDeviceMapping$Ebs' => '<p>Parameters used to automatically set up EBS volumes when the instance is launched.</p>', ], ], 'EbsInstanceBlockDeviceSpecification' => [ 'base' => '<p>Describes information used to set up an EBS volume specified in a block device mapping.</p>', 'refs' => [ 'InstanceBlockDeviceMappingSpecification$Ebs' => '<p>Parameters used to automatically set up EBS volumes when the instance is launched.</p>', ], ], 'EbsNvmeSupport' => [ 'base' => NULL, 'refs' => [ 'EbsInfo$NvmeSupport' => '<p>Indicates whether non-volatile memory express (NVMe) is supported.</p>', ], ], 'EbsOptimizedInfo' => [ 'base' => '<p>Describes the optimized EBS performance for supported instance types.</p>', 'refs' => [ 'EbsInfo$EbsOptimizedInfo' => '<p>Describes the optimized EBS performance for the instance type.</p>', ], ], 'EbsOptimizedSupport' => [ 'base' => NULL, 'refs' => [ 'EbsInfo$EbsOptimizedSupport' => '<p>Indicates that the instance type is Amazon EBS-optimized. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-Optimized Instances</a> in <i>Amazon EC2 User Guide for Linux Instances</i>.</p>', ], ], 'EfaSupportedFlag' => [ 'base' => NULL, 'refs' => [ 'NetworkInfo$EfaSupported' => '<p>Indicates whether Elastic Fabric Adapter (EFA) is supported.</p>', ], ], 'EgressOnlyInternetGateway' => [ 'base' => '<p>Describes an egress-only internet gateway.</p>', 'refs' => [ 'CreateEgressOnlyInternetGatewayResult$EgressOnlyInternetGateway' => '<p>Information about the egress-only internet gateway.</p>', 'EgressOnlyInternetGatewayList$member' => NULL, ], ], 'EgressOnlyInternetGatewayId' => [ 'base' => NULL, 'refs' => [ 'CreateRouteRequest$EgressOnlyInternetGatewayId' => '<p>[IPv6 traffic only] The ID of an egress-only internet gateway.</p>', 'DeleteEgressOnlyInternetGatewayRequest$EgressOnlyInternetGatewayId' => '<p>The ID of the egress-only internet gateway.</p>', 'EgressOnlyInternetGateway$EgressOnlyInternetGatewayId' => '<p>The ID of the egress-only internet gateway.</p>', 'EgressOnlyInternetGatewayIdList$member' => NULL, 'ReplaceRouteRequest$EgressOnlyInternetGatewayId' => '<p>[IPv6 traffic only] The ID of an egress-only internet gateway.</p>', ], ], 'EgressOnlyInternetGatewayIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeEgressOnlyInternetGatewaysRequest$EgressOnlyInternetGatewayIds' => '<p>One or more egress-only internet gateway IDs.</p>', ], ], 'EgressOnlyInternetGatewayList' => [ 'base' => NULL, 'refs' => [ 'DescribeEgressOnlyInternetGatewaysResult$EgressOnlyInternetGateways' => '<p>Information about the egress-only internet gateways.</p>', ], ], 'ElasticGpuAssociation' => [ 'base' => '<p>Describes the association between an instance and an Elastic Graphics accelerator.</p>', 'refs' => [ 'ElasticGpuAssociationList$member' => NULL, ], ], 'ElasticGpuAssociationList' => [ 'base' => NULL, 'refs' => [ 'Instance$ElasticGpuAssociations' => '<p>The Elastic GPU associated with the instance.</p>', ], ], 'ElasticGpuHealth' => [ 'base' => '<p>Describes the status of an Elastic Graphics accelerator.</p>', 'refs' => [ 'ElasticGpus$ElasticGpuHealth' => '<p>The status of the Elastic Graphics accelerator.</p>', ], ], 'ElasticGpuId' => [ 'base' => NULL, 'refs' => [ 'ElasticGpuIdSet$member' => NULL, ], ], 'ElasticGpuIdSet' => [ 'base' => NULL, 'refs' => [ 'DescribeElasticGpusRequest$ElasticGpuIds' => '<p>The Elastic Graphics accelerator IDs.</p>', ], ], 'ElasticGpuSet' => [ 'base' => NULL, 'refs' => [ 'DescribeElasticGpusResult$ElasticGpuSet' => '<p>Information about the Elastic Graphics accelerators.</p>', ], ], 'ElasticGpuSpecification' => [ 'base' => '<p>A specification for an Elastic Graphics accelerator.</p>', 'refs' => [ 'ElasticGpuSpecificationList$member' => NULL, 'ElasticGpuSpecifications$member' => NULL, ], ], 'ElasticGpuSpecificationList' => [ 'base' => NULL, 'refs' => [ 'RequestLaunchTemplateData$ElasticGpuSpecifications' => '<p>An elastic GPU to associate with the instance.</p>', ], ], 'ElasticGpuSpecificationResponse' => [ 'base' => '<p>Describes an elastic GPU.</p>', 'refs' => [ 'ElasticGpuSpecificationResponseList$member' => NULL, ], ], 'ElasticGpuSpecificationResponseList' => [ 'base' => NULL, 'refs' => [ 'ResponseLaunchTemplateData$ElasticGpuSpecifications' => '<p>The elastic GPU specification.</p>', ], ], 'ElasticGpuSpecifications' => [ 'base' => NULL, 'refs' => [ 'RunInstancesRequest$ElasticGpuSpecification' => '<p>An elastic GPU to associate with the instance. An Elastic GPU is a GPU resource that you can attach to your Windows instance to accelerate the graphics performance of your applications. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html"> Amazon EC2 Elastic GPUs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', ], ], 'ElasticGpuState' => [ 'base' => NULL, 'refs' => [ 'ElasticGpus$ElasticGpuState' => '<p>The state of the Elastic Graphics accelerator.</p>', ], ], 'ElasticGpuStatus' => [ 'base' => NULL, 'refs' => [ 'ElasticGpuHealth$Status' => '<p>The health status.</p>', ], ], 'ElasticGpus' => [ 'base' => '<p>Describes an Elastic Graphics accelerator.</p>', 'refs' => [ 'ElasticGpuSet$member' => NULL, ], ], 'ElasticInferenceAccelerator' => [ 'base' => '<p> Describes an elastic inference accelerator. </p>', 'refs' => [ 'ElasticInferenceAccelerators$member' => NULL, ], ], 'ElasticInferenceAcceleratorAssociation' => [ 'base' => '<p> Describes the association between an instance and an elastic inference accelerator. </p>', 'refs' => [ 'ElasticInferenceAcceleratorAssociationList$member' => NULL, ], ], 'ElasticInferenceAcceleratorAssociationList' => [ 'base' => NULL, 'refs' => [ 'Instance$ElasticInferenceAcceleratorAssociations' => '<p> The elastic inference accelerator associated with the instance.</p>', ], ], 'ElasticInferenceAcceleratorCount' => [ 'base' => NULL, 'refs' => [ 'ElasticInferenceAccelerator$Count' => '<p> The number of elastic inference accelerators to attach to the instance. </p> <p>Default: 1</p>', ], ], 'ElasticInferenceAccelerators' => [ 'base' => NULL, 'refs' => [ 'RunInstancesRequest$ElasticInferenceAccelerators' => '<p>An elastic inference accelerator to associate with the instance. Elastic inference accelerators are a resource you can attach to your Amazon EC2 instances to accelerate your Deep Learning (DL) inference workloads.</p> <p>You cannot specify accelerators from different generations in the same request.</p>', ], ], 'ElasticIpAssociationId' => [ 'base' => NULL, 'refs' => [ 'DisassociateAddressRequest$AssociationId' => '<p>[EC2-VPC] The association ID. Required for EC2-VPC.</p>', ], ], 'EnaSupport' => [ 'base' => NULL, 'refs' => [ 'NetworkInfo$EnaSupport' => '<p>Indicates whether Elastic Network Adapter (ENA) is supported.</p>', ], ], 'EnableEbsEncryptionByDefaultRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableEbsEncryptionByDefaultResult' => [ 'base' => NULL, 'refs' => [], ], 'EnableFastSnapshotRestoreErrorItem' => [ 'base' => '<p>Contains information about the errors that occurred when enabling fast snapshot restores.</p>', 'refs' => [ 'EnableFastSnapshotRestoreErrorSet$member' => NULL, ], ], 'EnableFastSnapshotRestoreErrorSet' => [ 'base' => NULL, 'refs' => [ 'EnableFastSnapshotRestoresResult$Unsuccessful' => '<p>Information about the snapshots for which fast snapshot restores could not be enabled.</p>', ], ], 'EnableFastSnapshotRestoreStateError' => [ 'base' => '<p>Describes an error that occurred when enabling fast snapshot restores.</p>', 'refs' => [ 'EnableFastSnapshotRestoreStateErrorItem$Error' => '<p>The error.</p>', ], ], 'EnableFastSnapshotRestoreStateErrorItem' => [ 'base' => '<p>Contains information about an error that occurred when enabling fast snapshot restores.</p>', 'refs' => [ 'EnableFastSnapshotRestoreStateErrorSet$member' => NULL, ], ], 'EnableFastSnapshotRestoreStateErrorSet' => [ 'base' => NULL, 'refs' => [ 'EnableFastSnapshotRestoreErrorItem$FastSnapshotRestoreStateErrors' => '<p>The errors.</p>', ], ], 'EnableFastSnapshotRestoreSuccessItem' => [ 'base' => '<p>Describes fast snapshot restores that were successfully enabled.</p>', 'refs' => [ 'EnableFastSnapshotRestoreSuccessSet$member' => NULL, ], ], 'EnableFastSnapshotRestoreSuccessSet' => [ 'base' => NULL, 'refs' => [ 'EnableFastSnapshotRestoresResult$Successful' => '<p>Information about the snapshots for which fast snapshot restores were successfully enabled.</p>', ], ], 'EnableFastSnapshotRestoresRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableFastSnapshotRestoresResult' => [ 'base' => NULL, 'refs' => [], ], 'EnableTransitGatewayRouteTablePropagationRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableTransitGatewayRouteTablePropagationResult' => [ 'base' => NULL, 'refs' => [], ], 'EnableVgwRoutePropagationRequest' => [ 'base' => '<p>Contains the parameters for EnableVgwRoutePropagation.</p>', 'refs' => [], ], 'EnableVolumeIORequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableVpcClassicLinkDnsSupportRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableVpcClassicLinkDnsSupportResult' => [ 'base' => NULL, 'refs' => [], ], 'EnableVpcClassicLinkRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableVpcClassicLinkResult' => [ 'base' => NULL, 'refs' => [], ], 'EndDateType' => [ 'base' => NULL, 'refs' => [ 'CapacityReservation$EndDateType' => '<p>Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:</p> <ul> <li> <p> <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.</p> </li> <li> <p> <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.</p> </li> </ul>', 'CreateCapacityReservationRequest$EndDateType' => '<p>Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:</p> <ul> <li> <p> <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not provide an <code>EndDate</code> if the <code>EndDateType</code> is <code>unlimited</code>.</p> </li> <li> <p> <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You must provide an <code>EndDate</code> value if the <code>EndDateType</code> value is <code>limited</code>.</p> </li> </ul>', 'ModifyCapacityReservationRequest$EndDateType' => '<p>Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:</p> <ul> <li> <p> <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>unlimited</code>.</p> </li> <li> <p> <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>.</p> </li> </ul>', ], ], 'EndpointSet' => [ 'base' => NULL, 'refs' => [ 'DescribeClientVpnEndpointsResult$ClientVpnEndpoints' => '<p>Information about the Client VPN endpoints.</p>', ], ], 'ErrorSet' => [ 'base' => NULL, 'refs' => [ 'ValidationWarning$Errors' => '<p>The error codes and error messages.</p>', ], ], 'EventCode' => [ 'base' => NULL, 'refs' => [ 'InstanceStatusEvent$Code' => '<p>The event code.</p>', ], ], 'EventInformation' => [ 'base' => '<p>Describes an EC2 Fleet or Spot Fleet event.</p>', 'refs' => [ 'HistoryRecord$EventInformation' => '<p>Information about the event.</p>', 'HistoryRecordEntry$EventInformation' => '<p>Information about the event.</p>', ], ], 'EventType' => [ 'base' => NULL, 'refs' => [ 'DescribeSpotFleetRequestHistoryRequest$EventType' => '<p>The type of events to describe. By default, all events are described.</p>', 'HistoryRecord$EventType' => '<p>The event type.</p> <ul> <li> <p> <code>error</code> - An error with the Spot Fleet request.</p> </li> <li> <p> <code>fleetRequestChange</code> - A change in the status or configuration of the Spot Fleet request.</p> </li> <li> <p> <code>instanceChange</code> - An instance was launched or terminated.</p> </li> <li> <p> <code>Information</code> - An informational event.</p> </li> </ul>', ], ], 'ExcessCapacityTerminationPolicy' => [ 'base' => NULL, 'refs' => [ 'ModifySpotFleetRequestRequest$ExcessCapacityTerminationPolicy' => '<p>Indicates whether running Spot Instances should be terminated if the target capacity of the Spot Fleet request is decreased below the current size of the Spot Fleet.</p>', 'SpotFleetRequestConfigData$ExcessCapacityTerminationPolicy' => '<p>Indicates whether running Spot Instances should be terminated if you decrease the target capacity of the Spot Fleet request below the current size of the Spot Fleet.</p>', ], ], 'ExecutableByStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeImagesRequest$ExecutableUsers' => '<p>Scopes the images by users with explicit launch permissions. Specify an AWS account ID, <code>self</code> (the sender of the request), or <code>all</code> (public AMIs).</p>', ], ], 'ExportClientVpnClientCertificateRevocationListRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExportClientVpnClientCertificateRevocationListResult' => [ 'base' => NULL, 'refs' => [], ], 'ExportClientVpnClientConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExportClientVpnClientConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], 'ExportEnvironment' => [ 'base' => NULL, 'refs' => [ 'CreateInstanceExportTaskRequest$TargetEnvironment' => '<p>The target virtualization environment.</p>', 'InstanceExportDetails$TargetEnvironment' => '<p>The target virtualization environment.</p>', ], ], 'ExportImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExportImageResult' => [ 'base' => NULL, 'refs' => [], ], 'ExportImageTask' => [ 'base' => '<p>Describes an export image task.</p>', 'refs' => [ 'ExportImageTaskList$member' => NULL, ], ], 'ExportImageTaskId' => [ 'base' => NULL, 'refs' => [ 'ExportImageTaskIdList$member' => NULL, ], ], 'ExportImageTaskIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeExportImageTasksRequest$ExportImageTaskIds' => '<p>The IDs of the export image tasks.</p>', ], ], 'ExportImageTaskList' => [ 'base' => NULL, 'refs' => [ 'DescribeExportImageTasksResult$ExportImageTasks' => '<p>Information about the export image tasks.</p>', ], ], 'ExportTask' => [ 'base' => '<p>Describes an instance export task.</p>', 'refs' => [ 'CreateInstanceExportTaskResult$ExportTask' => '<p>Information about the instance export task.</p>', 'ExportTaskList$member' => NULL, ], ], 'ExportTaskId' => [ 'base' => NULL, 'refs' => [ 'ExportTaskIdStringList$member' => NULL, ], ], 'ExportTaskIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeExportTasksRequest$ExportTaskIds' => '<p>The export task IDs.</p>', ], ], 'ExportTaskList' => [ 'base' => NULL, 'refs' => [ 'DescribeExportTasksResult$ExportTasks' => '<p>Information about the export tasks.</p>', ], ], 'ExportTaskS3Location' => [ 'base' => '<p>Describes the destination for an export image task.</p>', 'refs' => [ 'ExportImageResult$S3ExportLocation' => '<p>Information about the destination Amazon S3 bucket.</p>', 'ExportImageTask$S3ExportLocation' => '<p>Information about the destination Amazon S3 bucket.</p>', ], ], 'ExportTaskS3LocationRequest' => [ 'base' => '<p>Describes the destination for an export image task.</p>', 'refs' => [ 'ExportImageRequest$S3ExportLocation' => '<p>Information about the destination Amazon S3 bucket. The bucket must exist and grant WRITE and READ_ACP permissions to the AWS account vm-import-export@amazon.com.</p>', ], ], 'ExportTaskState' => [ 'base' => NULL, 'refs' => [ 'ExportTask$State' => '<p>The state of the export task.</p>', ], ], 'ExportToS3Task' => [ 'base' => '<p>Describes the format and location for an instance export task.</p>', 'refs' => [ 'ExportTask$ExportToS3Task' => '<p>Information about the export task.</p>', ], ], 'ExportToS3TaskSpecification' => [ 'base' => '<p>Describes an instance export task.</p>', 'refs' => [ 'CreateInstanceExportTaskRequest$ExportToS3Task' => '<p>The format and location for an instance export task.</p>', ], ], 'ExportTransitGatewayRoutesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExportTransitGatewayRoutesResult' => [ 'base' => NULL, 'refs' => [], ], 'ExportVmTaskId' => [ 'base' => NULL, 'refs' => [ 'CancelExportTaskRequest$ExportTaskId' => '<p>The ID of the export task. This is the ID returned by <code>CreateInstanceExportTask</code>.</p>', ], ], 'FailedQueuedPurchaseDeletion' => [ 'base' => '<p>Describes a Reserved Instance whose queued purchase was not deleted.</p>', 'refs' => [ 'FailedQueuedPurchaseDeletionSet$member' => NULL, ], ], 'FailedQueuedPurchaseDeletionSet' => [ 'base' => NULL, 'refs' => [ 'DeleteQueuedReservedInstancesResult$FailedQueuedPurchaseDeletions' => '<p>Information about the queued purchases that could not be deleted.</p>', ], ], 'FastSnapshotRestoreStateCode' => [ 'base' => NULL, 'refs' => [ 'DescribeFastSnapshotRestoreSuccessItem$State' => '<p>The state of fast snapshot restores.</p>', 'DisableFastSnapshotRestoreSuccessItem$State' => '<p>The state of fast snapshot restores for the snapshot.</p>', 'EnableFastSnapshotRestoreSuccessItem$State' => '<p>The state of fast snapshot restores.</p>', ], ], 'FederatedAuthentication' => [ 'base' => '<p>Describes the IAM SAML identity provider used for federated authentication.</p>', 'refs' => [ 'ClientVpnAuthentication$FederatedAuthentication' => '<p>Information about the IAM SAML identity provider, if applicable.</p>', ], ], 'FederatedAuthenticationRequest' => [ 'base' => '<p>The IAM SAML identity provider used for federated authentication.</p>', 'refs' => [ 'ClientVpnAuthenticationRequest$FederatedAuthentication' => '<p>Information about the IAM SAML identity provider to be used, if applicable. You must provide this information if <b>Type</b> is <code>federated-authentication</code>.</p>', ], ], 'Filter' => [ 'base' => '<p>A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as tags, attributes, or IDs. The filters supported by a describe operation are documented with the describe operation. For example:</p> <ul> <li> <p> <a>DescribeAvailabilityZones</a> </p> </li> <li> <p> <a>DescribeImages</a> </p> </li> <li> <p> <a>DescribeInstances</a> </p> </li> <li> <p> <a>DescribeKeyPairs</a> </p> </li> <li> <p> <a>DescribeSecurityGroups</a> </p> </li> <li> <p> <a>DescribeSnapshots</a> </p> </li> <li> <p> <a>DescribeSubnets</a> </p> </li> <li> <p> <a>DescribeTags</a> </p> </li> <li> <p> <a>DescribeVolumes</a> </p> </li> <li> <p> <a>DescribeVpcs</a> </p> </li> </ul>', 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeAddressesRequest$Filters' => '<p>One or more filters. Filter names and values are case-sensitive.</p> <ul> <li> <p> <code>allocation-id</code> - [EC2-VPC] The allocation ID for the address.</p> </li> <li> <p> <code>association-id</code> - [EC2-VPC] The association ID for the address.</p> </li> <li> <p> <code>domain</code> - Indicates whether the address is for use in EC2-Classic (<code>standard</code>) or in a VPC (<code>vpc</code>).</p> </li> <li> <p> <code>instance-id</code> - The ID of the instance the address is associated with, if any.</p> </li> <li> <p> <code>network-border-group</code> - A unique set of Availability Zones, Local Zones, or Wavelength Zones from where AWS advertises IP addresses. </p> </li> <li> <p> <code>network-interface-id</code> - [EC2-VPC] The ID of the network interface that the address is associated with, if any.</p> </li> <li> <p> <code>network-interface-owner-id</code> - The AWS account ID of the owner.</p> </li> <li> <p> <code>private-ip-address</code> - [EC2-VPC] The private IP address associated with the Elastic IP address.</p> </li> <li> <p> <code>public-ip</code> - The Elastic IP address, or the carrier IP address.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul>', 'DescribeAvailabilityZonesRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>group-name</code> - For Availability Zones, use the Region name. For Local Zones, use the name of the group associated with the Local Zone (for example, <code>us-west-2-lax-1</code>) For Wavelength Zones, use the name of the group associated with the Wavelength Zone (for example, <code>us-east-1-wl1-bos-wlz-1</code>).</p> </li> <li> <p> <code>message</code> - The Zone message.</p> </li> <li> <p> <code>opt-in-status</code> - The opt-in status (<code>opted-in</code>, and <code>not-opted-in</code> | <code>opt-in-not-required</code>).</p> </li> <li> <p> <code>parent-zoneID</code> - The ID of the zone that handles some of the Local Zone and Wavelength Zone control plane operations, such as API calls.</p> </li> <li> <p> <code>parent-zoneName</code> - The ID of the zone that handles some of the Local Zone and Wavelength Zone control plane operations, such as API calls.</p> </li> <li> <p> <code>region-name</code> - The name of the Region for the Zone (for example, <code>us-east-1</code>).</p> </li> <li> <p> <code>state</code> - The state of the Availability Zone, the Local Zone, or the Wavelength Zone (<code>available</code> | <code>information</code> | <code>impaired</code> | <code>unavailable</code>).</p> </li> <li> <p> <code>zone-id</code> - The ID of the Availability Zone (for example, <code>use1-az1</code>), the Local Zone (for example, <code>usw2-lax1-az1</code>), or the Wavelength Zone (for example, <code>us-east-1-wl1-bos-wlz-1</code>).</p> </li> <li> <p> <code>zone-type</code> - The type of zone, for example, <code>local-zone</code>.</p> </li> <li> <p> <code>zone-name</code> - The name of the Availability Zone (for example, <code>us-east-1a</code>), the Local Zone (for example, <code>us-west-2-lax-1a</code>), or the Wavelength Zone (for example, <code>us-east-1-wl1-bos-wlz-1</code>).</p> </li> <li> <p> <code>zone-type</code> - The type of zone, for example, <code>local-zone</code>.</p> </li> </ul>', 'DescribeBundleTasksRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>bundle-id</code> - The ID of the bundle task.</p> </li> <li> <p> <code>error-code</code> - If the task failed, the error code returned.</p> </li> <li> <p> <code>error-message</code> - If the task failed, the error message returned.</p> </li> <li> <p> <code>instance-id</code> - The ID of the instance.</p> </li> <li> <p> <code>progress</code> - The level of task completion, as a percentage (for example, 20%).</p> </li> <li> <p> <code>s3-bucket</code> - The Amazon S3 bucket to store the AMI.</p> </li> <li> <p> <code>s3-prefix</code> - The beginning of the AMI name.</p> </li> <li> <p> <code>start-time</code> - The time the task started (for example, 2013-09-15T17:15:20.000Z).</p> </li> <li> <p> <code>state</code> - The state of the task (<code>pending</code> | <code>waiting-for-shutdown</code> | <code>bundling</code> | <code>storing</code> | <code>cancelling</code> | <code>complete</code> | <code>failed</code>).</p> </li> <li> <p> <code>update-time</code> - The time of the most recent update for the task.</p> </li> </ul>', 'DescribeCapacityReservationsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>instance-type</code> - The type of instance for which the Capacity Reservation reserves capacity.</p> </li> <li> <p> <code>owner-id</code> - The ID of the AWS account that owns the Capacity Reservation.</p> </li> <li> <p> <code>availability-zone-id</code> - The Availability Zone ID of the Capacity Reservation.</p> </li> <li> <p> <code>instance-platform</code> - The type of operating system for which the Capacity Reservation reserves capacity.</p> </li> <li> <p> <code>availability-zone</code> - The Availability Zone ID of the Capacity Reservation.</p> </li> <li> <p> <code>tenancy</code> - Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:</p> <ul> <li> <p> <code>default</code> - The Capacity Reservation is created on hardware that is shared with other AWS accounts.</p> </li> <li> <p> <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single AWS account.</p> </li> </ul> </li> <li> <p> <code>state</code> - The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:</p> <ul> <li> <p> <code>active</code>- The Capacity Reservation is active and the capacity is available for your use.</p> </li> <li> <p> <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in your request. The reserved capacity is no longer available for your use.</p> </li> <li> <p> <code>cancelled</code> - The Capacity Reservation was manually cancelled. The reserved capacity is no longer available for your use.</p> </li> <li> <p> <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is still pending.</p> </li> <li> <p> <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60 minutes.</p> </li> </ul> </li> <li> <p> <code>end-date</code> - The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation\'s state changes to expired when it reaches its end date and time.</p> </li> <li> <p> <code>end-date-type</code> - Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:</p> <ul> <li> <p> <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.</p> </li> <li> <p> <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.</p> </li> </ul> </li> <li> <p> <code>instance-match-criteria</code> - Indicates the type of instance launches that the Capacity Reservation accepts. The options include:</p> <ul> <li> <p> <code>open</code> - The Capacity Reservation accepts all instances that have matching attributes (instance type, platform, and Availability Zone). Instances that have matching attributes launch into the Capacity Reservation automatically without specifying any additional parameters.</p> </li> <li> <p> <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only permitted instances can use the reserved capacity.</p> </li> </ul> </li> </ul>', 'DescribeCarrierGatewaysRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>carrier-gateway-id</code> - The ID of the carrier gateway.</p> </li> <li> <p> <code>state</code> - The state of the carrier gateway (<code>pending</code> | <code>failed</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code>).</p> </li> <li> <p> <code>owner-id</code> - The AWS account ID of the owner of the carrier gateway.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC associated with the carrier gateway.</p> </li> </ul>', 'DescribeClassicLinkInstancesRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>group-id</code> - The ID of a VPC security group that\'s associated with the instance.</p> </li> <li> <p> <code>instance-id</code> - The ID of the instance.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC to which the instance is linked.</p> <p> <code>vpc-id</code> - The ID of the VPC that the instance is linked to.</p> </li> </ul>', 'DescribeClientVpnAuthorizationRulesRequest$Filters' => '<p>One or more filters. Filter names and values are case-sensitive.</p> <ul> <li> <p> <code>description</code> - The description of the authorization rule.</p> </li> <li> <p> <code>destination-cidr</code> - The CIDR of the network to which the authorization rule applies.</p> </li> <li> <p> <code>group-id</code> - The ID of the Active Directory group to which the authorization rule grants access.</p> </li> </ul>', 'DescribeClientVpnConnectionsRequest$Filters' => '<p>One or more filters. Filter names and values are case-sensitive.</p> <ul> <li> <p> <code>connection-id</code> - The ID of the connection.</p> </li> <li> <p> <code>username</code> - For Active Directory client authentication, the user name of the client who established the client connection.</p> </li> </ul>', 'DescribeClientVpnEndpointsRequest$Filters' => '<p>One or more filters. Filter names and values are case-sensitive.</p> <ul> <li> <p> <code>endpoint-id</code> - The ID of the Client VPN endpoint.</p> </li> <li> <p> <code>transport-protocol</code> - The transport protocol (<code>tcp</code> | <code>udp</code>).</p> </li> </ul>', 'DescribeClientVpnRoutesRequest$Filters' => '<p>One or more filters. Filter names and values are case-sensitive.</p> <ul> <li> <p> <code>destination-cidr</code> - The CIDR of the route destination.</p> </li> <li> <p> <code>origin</code> - How the route was associated with the Client VPN endpoint (<code>associate</code> | <code>add-route</code>).</p> </li> <li> <p> <code>target-subnet</code> - The ID of the subnet through which traffic is routed.</p> </li> </ul>', 'DescribeClientVpnTargetNetworksRequest$Filters' => '<p>One or more filters. Filter names and values are case-sensitive.</p> <ul> <li> <p> <code>association-id</code> - The ID of the association.</p> </li> <li> <p> <code>target-network-id</code> - The ID of the subnet specified as the target network.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC in which the target network is located.</p> </li> </ul>', 'DescribeCoipPoolsRequest$Filters' => '<p>The filters. The following are the possible values:</p> <ul> <li> <p> <code>coip-pool.pool-id</code> </p> </li> </ul> <ul> <li> <p> <code>coip-pool.local-gateway-route-table-id</code> </p> </li> </ul>', 'DescribeCustomerGatewaysRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>bgp-asn</code> - The customer gateway\'s Border Gateway Protocol (BGP) Autonomous System Number (ASN).</p> </li> <li> <p> <code>customer-gateway-id</code> - The ID of the customer gateway.</p> </li> <li> <p> <code>ip-address</code> - The IP address of the customer gateway\'s Internet-routable external interface.</p> </li> <li> <p> <code>state</code> - The state of the customer gateway (<code>pending</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code>).</p> </li> <li> <p> <code>type</code> - The type of customer gateway. Currently, the only supported type is <code>ipsec.1</code>.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul>', 'DescribeDhcpOptionsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>dhcp-options-id</code> - The ID of a DHCP options set.</p> </li> <li> <p> <code>key</code> - The key for one of the options (for example, <code>domain-name</code>).</p> </li> <li> <p> <code>value</code> - The value for one of the options.</p> </li> <li> <p> <code>owner-id</code> - The ID of the AWS account that owns the DHCP options set.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul>', 'DescribeEgressOnlyInternetGatewaysRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul>', 'DescribeElasticGpusRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>availability-zone</code> - The Availability Zone in which the Elastic Graphics accelerator resides.</p> </li> <li> <p> <code>elastic-gpu-health</code> - The status of the Elastic Graphics accelerator (<code>OK</code> | <code>IMPAIRED</code>).</p> </li> <li> <p> <code>elastic-gpu-state</code> - The state of the Elastic Graphics accelerator (<code>ATTACHED</code>).</p> </li> <li> <p> <code>elastic-gpu-type</code> - The type of Elastic Graphics accelerator; for example, <code>eg1.medium</code>.</p> </li> <li> <p> <code>instance-id</code> - The ID of the instance to which the Elastic Graphics accelerator is associated.</p> </li> </ul>', 'DescribeExportImageTasksRequest$Filters' => '<p>Filter tasks using the <code>task-state</code> filter and one of the following values: <code>active</code>, <code>completed</code>, <code>deleting</code>, or <code>deleted</code>.</p>', 'DescribeExportTasksRequest$Filters' => '<p>the filters for the export tasks.</p>', 'DescribeFastSnapshotRestoresRequest$Filters' => '<p>The filters. The possible values are:</p> <ul> <li> <p> <code>availability-zone</code>: The Availability Zone of the snapshot.</p> </li> <li> <p> <code>owner-id</code>: The ID of the AWS account that enabled fast snapshot restore on the snapshot.</p> </li> <li> <p> <code>snapshot-id</code>: The ID of the snapshot.</p> </li> <li> <p> <code>state</code>: The state of fast snapshot restores for the snapshot (<code>enabling</code> | <code>optimizing</code> | <code>enabled</code> | <code>disabling</code> | <code>disabled</code>).</p> </li> </ul>', 'DescribeFleetInstancesRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>instance-type</code> - The instance type.</p> </li> </ul>', 'DescribeFleetsRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>activity-status</code> - The progress of the EC2 Fleet ( <code>error</code> | <code>pending-fulfillment</code> | <code>pending-termination</code> | <code>fulfilled</code>).</p> </li> <li> <p> <code>excess-capacity-termination-policy</code> - Indicates whether to terminate running instances if the target capacity is decreased below the current EC2 Fleet size (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>fleet-state</code> - The state of the EC2 Fleet (<code>submitted</code> | <code>active</code> | <code>deleted</code> | <code>failed</code> | <code>deleted-running</code> | <code>deleted-terminating</code> | <code>modifying</code>).</p> </li> <li> <p> <code>replace-unhealthy-instances</code> - Indicates whether EC2 Fleet should replace unhealthy instances (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>type</code> - The type of request (<code>instant</code> | <code>request</code> | <code>maintain</code>).</p> </li> </ul>', 'DescribeFlowLogsRequest$Filter' => '<p>One or more filters.</p> <ul> <li> <p> <code>deliver-log-status</code> - The status of the logs delivery (<code>SUCCESS</code> | <code>FAILED</code>).</p> </li> <li> <p> <code>log-destination-type</code> - The type of destination to which the flow log publishes data. Possible destination types include <code>cloud-watch-logs</code> and <code>S3</code>.</p> </li> <li> <p> <code>flow-log-id</code> - The ID of the flow log.</p> </li> <li> <p> <code>log-group-name</code> - The name of the log group.</p> </li> <li> <p> <code>resource-id</code> - The ID of the VPC, subnet, or network interface.</p> </li> <li> <p> <code>traffic-type</code> - The type of traffic (<code>ACCEPT</code> | <code>REJECT</code> | <code>ALL</code>).</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul>', 'DescribeFpgaImagesRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>create-time</code> - The creation time of the AFI.</p> </li> <li> <p> <code>fpga-image-id</code> - The FPGA image identifier (AFI ID).</p> </li> <li> <p> <code>fpga-image-global-id</code> - The global FPGA image identifier (AGFI ID).</p> </li> <li> <p> <code>name</code> - The name of the AFI.</p> </li> <li> <p> <code>owner-id</code> - The AWS account ID of the AFI owner.</p> </li> <li> <p> <code>product-code</code> - The product code.</p> </li> <li> <p> <code>shell-version</code> - The version of the AWS Shell that was used to create the bitstream.</p> </li> <li> <p> <code>state</code> - The state of the AFI (<code>pending</code> | <code>failed</code> | <code>available</code> | <code>unavailable</code>).</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>update-time</code> - The time of the most recent update.</p> </li> </ul>', 'DescribeHostReservationOfferingsRequest$Filter' => '<p>The filters.</p> <ul> <li> <p> <code>instance-family</code> - The instance family of the offering (for example, <code>m4</code>).</p> </li> <li> <p> <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code> | <code>AllUpfront</code>).</p> </li> </ul>', 'DescribeHostReservationsRequest$Filter' => '<p>The filters.</p> <ul> <li> <p> <code>instance-family</code> - The instance family (for example, <code>m4</code>).</p> </li> <li> <p> <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code> | <code>AllUpfront</code>).</p> </li> <li> <p> <code>state</code> - The state of the reservation (<code>payment-pending</code> | <code>payment-failed</code> | <code>active</code> | <code>retired</code>).</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul>', 'DescribeHostsRequest$Filter' => '<p>The filters.</p> <ul> <li> <p> <code>auto-placement</code> - Whether auto-placement is enabled or disabled (<code>on</code> | <code>off</code>).</p> </li> <li> <p> <code>availability-zone</code> - The Availability Zone of the host.</p> </li> <li> <p> <code>client-token</code> - The idempotency token that you provided when you allocated the host.</p> </li> <li> <p> <code>host-reservation-id</code> - The ID of the reservation assigned to this host.</p> </li> <li> <p> <code>instance-type</code> - The instance type size that the Dedicated Host is configured to support.</p> </li> <li> <p> <code>state</code> - The allocation state of the Dedicated Host (<code>available</code> | <code>under-assessment</code> | <code>permanent-failure</code> | <code>released</code> | <code>released-permanent-failure</code>).</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul>', 'DescribeIamInstanceProfileAssociationsRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>instance-id</code> - The ID of the instance.</p> </li> <li> <p> <code>state</code> - The state of the association (<code>associating</code> | <code>associated</code> | <code>disassociating</code>).</p> </li> </ul>', 'DescribeImagesRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>architecture</code> - The image architecture (<code>i386</code> | <code>x86_64</code> | <code>arm64</code>).</p> </li> <li> <p> <code>block-device-mapping.delete-on-termination</code> - A Boolean value that indicates whether the Amazon EBS volume is deleted on instance termination.</p> </li> <li> <p> <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p> </li> <li> <p> <code>block-device-mapping.snapshot-id</code> - The ID of the snapshot used for the EBS volume.</p> </li> <li> <p> <code>block-device-mapping.volume-size</code> - The volume size of the EBS volume, in GiB.</p> </li> <li> <p> <code>block-device-mapping.volume-type</code> - The volume type of the EBS volume (<code>gp2</code> | <code>io1</code> | <code>st1 </code>| <code>sc1</code> | <code>standard</code>).</p> </li> <li> <p> <code>block-device-mapping.encrypted</code> - A Boolean that indicates whether the EBS volume is encrypted.</p> </li> <li> <p> <code>description</code> - The description of the image (provided during image creation).</p> </li> <li> <p> <code>ena-support</code> - A Boolean that indicates whether enhanced networking with ENA is enabled.</p> </li> <li> <p> <code>hypervisor</code> - The hypervisor type (<code>ovm</code> | <code>xen</code>).</p> </li> <li> <p> <code>image-id</code> - The ID of the image.</p> </li> <li> <p> <code>image-type</code> - The image type (<code>machine</code> | <code>kernel</code> | <code>ramdisk</code>).</p> </li> <li> <p> <code>is-public</code> - A Boolean that indicates whether the image is public.</p> </li> <li> <p> <code>kernel-id</code> - The kernel ID.</p> </li> <li> <p> <code>manifest-location</code> - The location of the image manifest.</p> </li> <li> <p> <code>name</code> - The name of the AMI (provided during image creation).</p> </li> <li> <p> <code>owner-alias</code> - The owner alias, from an Amazon-maintained list (<code>amazon</code> | <code>aws-marketplace</code>). This is not the user-configured AWS account alias set using the IAM console. We recommend that you use the related parameter instead of this filter.</p> </li> <li> <p> <code>owner-id</code> - The AWS account ID of the owner. We recommend that you use the related parameter instead of this filter.</p> </li> <li> <p> <code>platform</code> - The platform. To only list Windows-based AMIs, use <code>windows</code>.</p> </li> <li> <p> <code>product-code</code> - The product code.</p> </li> <li> <p> <code>product-code.type</code> - The type of the product code (<code>devpay</code> | <code>marketplace</code>).</p> </li> <li> <p> <code>ramdisk-id</code> - The RAM disk ID.</p> </li> <li> <p> <code>root-device-name</code> - The device name of the root device volume (for example, <code>/dev/sda1</code>).</p> </li> <li> <p> <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> | <code>instance-store</code>).</p> </li> <li> <p> <code>state</code> - The state of the image (<code>available</code> | <code>pending</code> | <code>failed</code>).</p> </li> <li> <p> <code>state-reason-code</code> - The reason code for the state change.</p> </li> <li> <p> <code>state-reason-message</code> - The message for the state change.</p> </li> <li> <p> <code>sriov-net-support</code> - A value of <code>simple</code> indicates that enhanced networking with the Intel 82599 VF interface is enabled.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>virtualization-type</code> - The virtualization type (<code>paravirtual</code> | <code>hvm</code>).</p> </li> </ul>', 'DescribeImportImageTasksRequest$Filters' => '<p>Filter tasks using the <code>task-state</code> filter and one of the following values: <code>active</code>, <code>completed</code>, <code>deleting</code>, or <code>deleted</code>.</p>', 'DescribeImportSnapshotTasksRequest$Filters' => '<p>The filters.</p>', 'DescribeInstanceCreditSpecificationsRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>instance-id</code> - The ID of the instance.</p> </li> </ul>', 'DescribeInstanceStatusRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>availability-zone</code> - The Availability Zone of the instance.</p> </li> <li> <p> <code>event.code</code> - The code for the scheduled event (<code>instance-reboot</code> | <code>system-reboot</code> | <code>system-maintenance</code> | <code>instance-retirement</code> | <code>instance-stop</code>).</p> </li> <li> <p> <code>event.description</code> - A description of the event.</p> </li> <li> <p> <code>event.instance-event-id</code> - The ID of the event whose date and time you are modifying.</p> </li> <li> <p> <code>event.not-after</code> - The latest end time for the scheduled event (for example, <code>2014-09-15T17:15:20.000Z</code>).</p> </li> <li> <p> <code>event.not-before</code> - The earliest start time for the scheduled event (for example, <code>2014-09-15T17:15:20.000Z</code>).</p> </li> <li> <p> <code>event.not-before-deadline</code> - The deadline for starting the event (for example, <code>2014-09-15T17:15:20.000Z</code>).</p> </li> <li> <p> <code>instance-state-code</code> - The code for the instance state, as a 16-bit unsigned integer. The high byte is used for internal purposes and should be ignored. The low byte is set based on the state represented. The valid values are 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).</p> </li> <li> <p> <code>instance-state-name</code> - The state of the instance (<code>pending</code> | <code>running</code> | <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> | <code>stopped</code>).</p> </li> <li> <p> <code>instance-status.reachability</code> - Filters on instance status where the name is <code>reachability</code> (<code>passed</code> | <code>failed</code> | <code>initializing</code> | <code>insufficient-data</code>).</p> </li> <li> <p> <code>instance-status.status</code> - The status of the instance (<code>ok</code> | <code>impaired</code> | <code>initializing</code> | <code>insufficient-data</code> | <code>not-applicable</code>).</p> </li> <li> <p> <code>system-status.reachability</code> - Filters on system status where the name is <code>reachability</code> (<code>passed</code> | <code>failed</code> | <code>initializing</code> | <code>insufficient-data</code>).</p> </li> <li> <p> <code>system-status.status</code> - The system status of the instance (<code>ok</code> | <code>impaired</code> | <code>initializing</code> | <code>insufficient-data</code> | <code>not-applicable</code>).</p> </li> </ul>', 'DescribeInstanceTypeOfferingsRequest$Filters' => '<p>One or more filters. Filter names and values are case-sensitive.</p> <ul> <li> <p> <code>location</code> - This depends on the location type. For example, if the location type is <code>region</code> (default), the location is the Region code (for example, <code>us-east-2</code>.)</p> </li> <li> <p> <code>instance-type</code> - The instance type.</p> </li> </ul>', 'DescribeInstanceTypesRequest$Filters' => '<p>One or more filters. Filter names and values are case-sensitive.</p> <ul> <li> <p> <code>auto-recovery-supported</code> - Indicates whether auto recovery is supported. (<code>true</code> | <code>false</code>)</p> </li> <li> <p> <code>bare-metal</code> - Indicates whether it is a bare metal instance type. (<code>true</code> | <code>false</code>)</p> </li> <li> <p> <code>burstable-performance-supported</code> - Indicates whether it is a burstable performance instance type. (<code>true</code> | <code>false</code>)</p> </li> <li> <p> <code>current-generation</code> - Indicates whether this instance type is the latest generation instance type of an instance family. (<code>true</code> | <code>false</code>)</p> </li> <li> <p> <code>ebs-info.ebs-optimized-info.baseline-bandwidth-in-mbps</code> - The baseline bandwidth performance for an EBS-optimized instance type, in Mbps.</p> </li> <li> <p> <code>ebs-info.ebs-optimized-info.baseline-throughput-in-mbps</code> - The baseline throughput performance for an EBS-optimized instance type, in MBps.</p> </li> <li> <p> <code>ebs-info.ebs-optimized-info.baseline-iops</code> - The baseline input/output storage operations per second for an EBS-optimized instance type.</p> </li> <li> <p> <code>ebs-info.ebs-optimized-info.maximum-bandwidth-in-mbps</code> - The maximum bandwidth performance for an EBS-optimized instance type, in Mbps.</p> </li> <li> <p> <code>ebs-info.ebs-optimized-info.maximum-throughput-in-mbps</code> - The maximum throughput performance for an EBS-optimized instance type, in MBps.</p> </li> <li> <p> <code>ebs-info.ebs-optimized-info.maximum-iops</code> - The maximum input/output storage operations per second for an EBS-optimized instance type.</p> </li> <li> <p> <code>ebs-info.ebs-optimized-support</code> - Indicates whether the instance type is EBS-optimized. (<code>supported</code> | <code>unsupported</code> | <code>default</code>)</p> </li> <li> <p> <code>ebs-info.encryption-support</code> - Indicates whether EBS encryption is supported. (<code>supported</code> | <code>unsupported</code>)</p> </li> <li> <p> <code>ebs-info.nvme-support</code> - Indicates whether non-volatile memory express (NVMe) is supported or required. (<code>required</code> | <code>supported</code> | <code>unsupported</code>)</p> </li> <li> <p> <code>free-tier-eligible</code> - Indicates whether the instance type is eligible to use in the free tier. (<code>true</code> | <code>false</code>)</p> </li> <li> <p> <code>hibernation-supported</code> - Indicates whether On-Demand hibernation is supported. (<code>true</code> | <code>false</code>)</p> </li> <li> <p> <code>hypervisor</code> - The hypervisor used. (<code>nitro</code> | <code>xen</code>)</p> </li> <li> <p> <code>instance-storage-info.disk.count</code> - The number of local disks.</p> </li> <li> <p> <code>instance-storage-info.disk.size-in-gb</code> - The storage size of each instance storage disk, in GB.</p> </li> <li> <p> <code>instance-storage-info.disk.type</code> - The storage technology for the local instance storage disks. (<code>hdd</code> | <code>ssd</code>)</p> </li> <li> <p> <code>instance-storage-info.total-size-in-gb</code> - The total amount of storage available from all local instance storage, in GB.</p> </li> <li> <p> <code>instance-storage-supported</code> - Indicates whether the instance type has local instance storage. (<code>true</code> | <code>false</code>)</p> </li> <li> <p> <code>memory-info.size-in-mib</code> - The memory size.</p> </li> <li> <p> <code>network-info.ena-support</code> - Indicates whether Elastic Network Adapter (ENA) is supported or required. (<code>required</code> | <code>supported</code> | <code>unsupported</code>)</p> </li> <li> <p> <code>network-info.efa-supported</code> - Indicates whether the instance type supports Elastic Fabric Adapter (EFA). (<code>true</code> | <code>false</code>)</p> </li> <li> <p> <code>network-info.ipv4-addresses-per-interface</code> - The maximum number of private IPv4 addresses per network interface.</p> </li> <li> <p> <code>network-info.ipv6-addresses-per-interface</code> - The maximum number of private IPv6 addresses per network interface.</p> </li> <li> <p> <code>network-info.ipv6-supported</code> - Indicates whether the instance type supports IPv6. (<code>true</code> | <code>false</code>)</p> </li> <li> <p> <code>network-info.maximum-network-interfaces</code> - The maximum number of network interfaces per instance.</p> </li> <li> <p> <code>network-info.network-performance</code> - Describes the network performance.</p> </li> <li> <p> <code>processor-info.sustained-clock-speed-in-ghz</code> - The CPU clock speed, in GHz.</p> </li> <li> <p> <code>vcpu-info.default-cores</code> - The default number of cores for the instance type.</p> </li> <li> <p> <code>vcpu-info.default-threads-per-core</code> - The default number of threads per core for the instance type.</p> </li> <li> <p> <code>vcpu-info.default-vcpus</code> - The default number of vCPUs for the instance type.</p> </li> </ul>', 'DescribeInstancesRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>affinity</code> - The affinity setting for an instance running on a Dedicated Host (<code>default</code> | <code>host</code>).</p> </li> <li> <p> <code>architecture</code> - The instance architecture (<code>i386</code> | <code>x86_64</code> | <code>arm64</code>).</p> </li> <li> <p> <code>availability-zone</code> - The Availability Zone of the instance.</p> </li> <li> <p> <code>block-device-mapping.attach-time</code> - The attach time for an EBS volume mapped to the instance, for example, <code>2010-09-15T17:15:20.000Z</code>.</p> </li> <li> <p> <code>block-device-mapping.delete-on-termination</code> - A Boolean that indicates whether the EBS volume is deleted on instance termination.</p> </li> <li> <p> <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p> </li> <li> <p> <code>block-device-mapping.status</code> - The status for the EBS volume (<code>attaching</code> | <code>attached</code> | <code>detaching</code> | <code>detached</code>).</p> </li> <li> <p> <code>block-device-mapping.volume-id</code> - The volume ID of the EBS volume.</p> </li> <li> <p> <code>client-token</code> - The idempotency token you provided when you launched the instance.</p> </li> <li> <p> <code>dns-name</code> - The public DNS name of the instance.</p> </li> <li> <p> <code>group-id</code> - The ID of the security group for the instance. EC2-Classic only.</p> </li> <li> <p> <code>group-name</code> - The name of the security group for the instance. EC2-Classic only.</p> </li> <li> <p> <code>hibernation-options.configured</code> - A Boolean that indicates whether the instance is enabled for hibernation. A value of <code>true</code> means that the instance is enabled for hibernation. </p> </li> <li> <p> <code>host-id</code> - The ID of the Dedicated Host on which the instance is running, if applicable.</p> </li> <li> <p> <code>hypervisor</code> - The hypervisor type of the instance (<code>ovm</code> | <code>xen</code>). The value <code>xen</code> is used for both Xen and Nitro hypervisors.</p> </li> <li> <p> <code>iam-instance-profile.arn</code> - The instance profile associated with the instance. Specified as an ARN.</p> </li> <li> <p> <code>image-id</code> - The ID of the image used to launch the instance.</p> </li> <li> <p> <code>instance-id</code> - The ID of the instance.</p> </li> <li> <p> <code>instance-lifecycle</code> - Indicates whether this is a Spot Instance or a Scheduled Instance (<code>spot</code> | <code>scheduled</code>).</p> </li> <li> <p> <code>instance-state-code</code> - The state of the instance, as a 16-bit unsigned integer. The high byte is used for internal purposes and should be ignored. The low byte is set based on the state represented. The valid values are: 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).</p> </li> <li> <p> <code>instance-state-name</code> - The state of the instance (<code>pending</code> | <code>running</code> | <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> | <code>stopped</code>).</p> </li> <li> <p> <code>instance-type</code> - The type of instance (for example, <code>t2.micro</code>).</p> </li> <li> <p> <code>instance.group-id</code> - The ID of the security group for the instance. </p> </li> <li> <p> <code>instance.group-name</code> - The name of the security group for the instance. </p> </li> <li> <p> <code>ip-address</code> - The public IPv4 address of the instance.</p> </li> <li> <p> <code>kernel-id</code> - The kernel ID.</p> </li> <li> <p> <code>key-name</code> - The name of the key pair used when the instance was launched.</p> </li> <li> <p> <code>launch-index</code> - When launching multiple instances, this is the index for the instance in the launch group (for example, 0, 1, 2, and so on). </p> </li> <li> <p> <code>launch-time</code> - The time when the instance was launched.</p> </li> <li> <p> <code>metadata-options.http-tokens</code> - The metadata request authorization state (<code>optional</code> | <code>required</code>)</p> </li> <li> <p> <code>metadata-options.http-put-response-hop-limit</code> - The http metadata request put response hop limit (integer, possible values <code>1</code> to <code>64</code>)</p> </li> <li> <p> <code>metadata-options.http-endpoint</code> - Enable or disable metadata access on http endpoint (<code>enabled</code> | <code>disabled</code>)</p> </li> <li> <p> <code>monitoring-state</code> - Indicates whether detailed monitoring is enabled (<code>disabled</code> | <code>enabled</code>).</p> </li> <li> <p> <code>network-interface.addresses.private-ip-address</code> - The private IPv4 address associated with the network interface.</p> </li> <li> <p> <code>network-interface.addresses.primary</code> - Specifies whether the IPv4 address of the network interface is the primary private IPv4 address.</p> </li> <li> <p> <code>network-interface.addresses.association.public-ip</code> - The ID of the association of an Elastic IP address (IPv4) with a network interface.</p> </li> <li> <p> <code>network-interface.addresses.association.ip-owner-id</code> - The owner ID of the private IPv4 address associated with the network interface.</p> </li> <li> <p> <code>network-interface.association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the network interface.</p> </li> <li> <p> <code>network-interface.association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated with the network interface.</p> </li> <li> <p> <code>network-interface.association.allocation-id</code> - The allocation ID returned when you allocated the Elastic IP address (IPv4) for your network interface.</p> </li> <li> <p> <code>network-interface.association.association-id</code> - The association ID returned when the network interface was associated with an IPv4 address.</p> </li> <li> <p> <code>network-interface.attachment.attachment-id</code> - The ID of the interface attachment.</p> </li> <li> <p> <code>network-interface.attachment.instance-id</code> - The ID of the instance to which the network interface is attached.</p> </li> <li> <p> <code>network-interface.attachment.instance-owner-id</code> - The owner ID of the instance to which the network interface is attached.</p> </li> <li> <p> <code>network-interface.attachment.device-index</code> - The device index to which the network interface is attached.</p> </li> <li> <p> <code>network-interface.attachment.status</code> - The status of the attachment (<code>attaching</code> | <code>attached</code> | <code>detaching</code> | <code>detached</code>).</p> </li> <li> <p> <code>network-interface.attachment.attach-time</code> - The time that the network interface was attached to an instance.</p> </li> <li> <p> <code>network-interface.attachment.delete-on-termination</code> - Specifies whether the attachment is deleted when an instance is terminated.</p> </li> <li> <p> <code>network-interface.availability-zone</code> - The Availability Zone for the network interface.</p> </li> <li> <p> <code>network-interface.description</code> - The description of the network interface.</p> </li> <li> <p> <code>network-interface.group-id</code> - The ID of a security group associated with the network interface.</p> </li> <li> <p> <code>network-interface.group-name</code> - The name of a security group associated with the network interface.</p> </li> <li> <p> <code>network-interface.ipv6-addresses.ipv6-address</code> - The IPv6 address associated with the network interface.</p> </li> <li> <p> <code>network-interface.mac-address</code> - The MAC address of the network interface.</p> </li> <li> <p> <code>network-interface.network-interface-id</code> - The ID of the network interface.</p> </li> <li> <p> <code>network-interface.owner-id</code> - The ID of the owner of the network interface.</p> </li> <li> <p> <code>network-interface.private-dns-name</code> - The private DNS name of the network interface.</p> </li> <li> <p> <code>network-interface.requester-id</code> - The requester ID for the network interface.</p> </li> <li> <p> <code>network-interface.requester-managed</code> - Indicates whether the network interface is being managed by AWS.</p> </li> <li> <p> <code>network-interface.status</code> - The status of the network interface (<code>available</code>) | <code>in-use</code>).</p> </li> <li> <p> <code>network-interface.source-dest-check</code> - Whether the network interface performs source/destination checking. A value of <code>true</code> means that checking is enabled, and <code>false</code> means that checking is disabled. The value must be <code>false</code> for the network interface to perform network address translation (NAT) in your VPC.</p> </li> <li> <p> <code>network-interface.subnet-id</code> - The ID of the subnet for the network interface.</p> </li> <li> <p> <code>network-interface.vpc-id</code> - The ID of the VPC for the network interface.</p> </li> <li> <p> <code>owner-id</code> - The AWS account ID of the instance owner.</p> </li> <li> <p> <code>placement-group-name</code> - The name of the placement group for the instance.</p> </li> <li> <p> <code>placement-partition-number</code> - The partition in which the instance is located.</p> </li> <li> <p> <code>platform</code> - The platform. To list only Windows instances, use <code>windows</code>.</p> </li> <li> <p> <code>private-dns-name</code> - The private IPv4 DNS name of the instance.</p> </li> <li> <p> <code>private-ip-address</code> - The private IPv4 address of the instance.</p> </li> <li> <p> <code>product-code</code> - The product code associated with the AMI used to launch the instance.</p> </li> <li> <p> <code>product-code.type</code> - The type of product code (<code>devpay</code> | <code>marketplace</code>).</p> </li> <li> <p> <code>ramdisk-id</code> - The RAM disk ID.</p> </li> <li> <p> <code>reason</code> - The reason for the current state of the instance (for example, shows "User Initiated [date]" when you stop or terminate the instance). Similar to the state-reason-code filter.</p> </li> <li> <p> <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example, AWS Management Console, Auto Scaling, and so on).</p> </li> <li> <p> <code>reservation-id</code> - The ID of the instance\'s reservation. A reservation ID is created any time you launch an instance. A reservation ID has a one-to-one relationship with an instance launch request, but can be associated with more than one instance if you launch multiple instances using the same launch request. For example, if you launch one instance, you get one reservation ID. If you launch ten instances using the same launch request, you also get one reservation ID.</p> </li> <li> <p> <code>root-device-name</code> - The device name of the root device volume (for example, <code>/dev/sda1</code>).</p> </li> <li> <p> <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> | <code>instance-store</code>).</p> </li> <li> <p> <code>source-dest-check</code> - Indicates whether the instance performs source/destination checking. A value of <code>true</code> means that checking is enabled, and <code>false</code> means that checking is disabled. The value must be <code>false</code> for the instance to perform network address translation (NAT) in your VPC. </p> </li> <li> <p> <code>spot-instance-request-id</code> - The ID of the Spot Instance request.</p> </li> <li> <p> <code>state-reason-code</code> - The reason code for the state change.</p> </li> <li> <p> <code>state-reason-message</code> - A message that describes the state change.</p> </li> <li> <p> <code>subnet-id</code> - The ID of the subnet for the instance.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources that have a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>tenancy</code> - The tenancy of an instance (<code>dedicated</code> | <code>default</code> | <code>host</code>).</p> </li> <li> <p> <code>virtualization-type</code> - The virtualization type of the instance (<code>paravirtual</code> | <code>hvm</code>).</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC that the instance is running in.</p> </li> </ul>', 'DescribeInternetGatewaysRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>attachment.state</code> - The current state of the attachment between the gateway and the VPC (<code>available</code>). Present only if a VPC is attached.</p> </li> <li> <p> <code>attachment.vpc-id</code> - The ID of an attached VPC.</p> </li> <li> <p> <code>internet-gateway-id</code> - The ID of the Internet gateway.</p> </li> <li> <p> <code>owner-id</code> - The ID of the AWS account that owns the internet gateway.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul>', 'DescribeIpv6PoolsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul>', 'DescribeKeyPairsRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>key-pair-id</code> - The ID of the key pair.</p> </li> <li> <p> <code>fingerprint</code> - The fingerprint of the key pair.</p> </li> <li> <p> <code>key-name</code> - The name of the key pair.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> </ul>', 'DescribeLaunchTemplateVersionsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>create-time</code> - The time the launch template version was created.</p> </li> <li> <p> <code>ebs-optimized</code> - A boolean that indicates whether the instance is optimized for Amazon EBS I/O.</p> </li> <li> <p> <code>iam-instance-profile</code> - The ARN of the IAM instance profile.</p> </li> <li> <p> <code>image-id</code> - The ID of the AMI.</p> </li> <li> <p> <code>instance-type</code> - The instance type.</p> </li> <li> <p> <code>is-default-version</code> - A boolean that indicates whether the launch template version is the default version.</p> </li> <li> <p> <code>kernel-id</code> - The kernel ID.</p> </li> <li> <p> <code>ram-disk-id</code> - The RAM disk ID.</p> </li> </ul>', 'DescribeLaunchTemplatesRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>create-time</code> - The time the launch template was created.</p> </li> <li> <p> <code>launch-template-name</code> - The name of the launch template.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul>', 'DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>local-gateway-id</code> - The ID of a local gateway.</p> </li> <li> <p> <code>local-gateway-route-table-id</code> - The ID of the local gateway route table.</p> </li> <li> <p> <code>local-gateway-route-table-virtual-interface-group-association-id</code> - The ID of the association.</p> </li> <li> <p> <code>local-gateway-route-table-virtual-interface-group-id</code> - The ID of the virtual interface group.</p> </li> <li> <p> <code>state</code> - The state of the association.</p> </li> </ul>', 'DescribeLocalGatewayRouteTableVpcAssociationsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>local-gateway-id</code> - The ID of a local gateway.</p> </li> <li> <p> <code>local-gateway-route-table-id</code> - The ID of the local gateway route table.</p> </li> <li> <p> <code>local-gateway-route-table-vpc-association-id</code> - The ID of the association.</p> </li> <li> <p> <code>state</code> - The state of the association.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC.</p> </li> </ul>', 'DescribeLocalGatewayRouteTablesRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>local-gateway-id</code> - The ID of a local gateway.</p> </li> <li> <p> <code>local-gateway-route-table-id</code> - The ID of a local gateway route table.</p> </li> <li> <p> <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost.</p> </li> <li> <p> <code>state</code> - The state of the local gateway route table.</p> </li> </ul>', 'DescribeLocalGatewayVirtualInterfaceGroupsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>local-gateway-id</code> - The ID of a local gateway.</p> </li> <li> <p> <code>local-gateway-virtual-interface-id</code> - The ID of the virtual interface.</p> </li> <li> <p> <code>local-gateway-virtual-interface-group-id</code> - The ID of the virtual interface group.</p> </li> </ul>', 'DescribeLocalGatewayVirtualInterfacesRequest$Filters' => '<p>One or more filters.</p>', 'DescribeLocalGatewaysRequest$Filters' => '<p>One or more filters.</p>', 'DescribeManagedPrefixListsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>owner-id</code> - The ID of the prefix list owner.</p> </li> <li> <p> <code>prefix-list-id</code> - The ID of the prefix list.</p> </li> <li> <p> <code>prefix-list-name</code> - The name of the prefix list.</p> </li> </ul>', 'DescribeMovingAddressesRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>moving-status</code> - The status of the Elastic IP address (<code>MovingToVpc</code> | <code>RestoringToClassic</code>).</p> </li> </ul>', 'DescribeNatGatewaysRequest$Filter' => '<p>One or more filters.</p> <ul> <li> <p> <code>nat-gateway-id</code> - The ID of the NAT gateway.</p> </li> <li> <p> <code>state</code> - The state of the NAT gateway (<code>pending</code> | <code>failed</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code>).</p> </li> <li> <p> <code>subnet-id</code> - The ID of the subnet in which the NAT gateway resides.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC in which the NAT gateway resides.</p> </li> </ul>', 'DescribeNetworkAclsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>association.association-id</code> - The ID of an association ID for the ACL.</p> </li> <li> <p> <code>association.network-acl-id</code> - The ID of the network ACL involved in the association.</p> </li> <li> <p> <code>association.subnet-id</code> - The ID of the subnet involved in the association.</p> </li> <li> <p> <code>default</code> - Indicates whether the ACL is the default network ACL for the VPC.</p> </li> <li> <p> <code>entry.cidr</code> - The IPv4 CIDR range specified in the entry.</p> </li> <li> <p> <code>entry.icmp.code</code> - The ICMP code specified in the entry, if any.</p> </li> <li> <p> <code>entry.icmp.type</code> - The ICMP type specified in the entry, if any.</p> </li> <li> <p> <code>entry.ipv6-cidr</code> - The IPv6 CIDR range specified in the entry.</p> </li> <li> <p> <code>entry.port-range.from</code> - The start of the port range specified in the entry. </p> </li> <li> <p> <code>entry.port-range.to</code> - The end of the port range specified in the entry. </p> </li> <li> <p> <code>entry.protocol</code> - The protocol specified in the entry (<code>tcp</code> | <code>udp</code> | <code>icmp</code> or a protocol number).</p> </li> <li> <p> <code>entry.rule-action</code> - Allows or denies the matching traffic (<code>allow</code> | <code>deny</code>).</p> </li> <li> <p> <code>entry.rule-number</code> - The number of an entry (in other words, rule) in the set of ACL entries.</p> </li> <li> <p> <code>network-acl-id</code> - The ID of the network ACL.</p> </li> <li> <p> <code>owner-id</code> - The ID of the AWS account that owns the network ACL.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC for the network ACL.</p> </li> </ul>', 'DescribeNetworkInterfacePermissionsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>network-interface-permission.network-interface-permission-id</code> - The ID of the permission.</p> </li> <li> <p> <code>network-interface-permission.network-interface-id</code> - The ID of the network interface.</p> </li> <li> <p> <code>network-interface-permission.aws-account-id</code> - The AWS account ID.</p> </li> <li> <p> <code>network-interface-permission.aws-service</code> - The AWS service.</p> </li> <li> <p> <code>network-interface-permission.permission</code> - The type of permission (<code>INSTANCE-ATTACH</code> | <code>EIP-ASSOCIATE</code>).</p> </li> </ul>', 'DescribeNetworkInterfacesRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>addresses.private-ip-address</code> - The private IPv4 addresses associated with the network interface.</p> </li> <li> <p> <code>addresses.primary</code> - Whether the private IPv4 address is the primary IP address associated with the network interface. </p> </li> <li> <p> <code>addresses.association.public-ip</code> - The association ID returned when the network interface was associated with the Elastic IP address (IPv4).</p> </li> <li> <p> <code>addresses.association.owner-id</code> - The owner ID of the addresses associated with the network interface.</p> </li> <li> <p> <code>association.association-id</code> - The association ID returned when the network interface was associated with an IPv4 address.</p> </li> <li> <p> <code>association.allocation-id</code> - The allocation ID returned when you allocated the Elastic IP address (IPv4) for your network interface.</p> </li> <li> <p> <code>association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated with the network interface.</p> </li> <li> <p> <code>association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the network interface.</p> </li> <li> <p> <code>association.public-dns-name</code> - The public DNS name for the network interface (IPv4).</p> </li> <li> <p> <code>attachment.attachment-id</code> - The ID of the interface attachment.</p> </li> <li> <p> <code>attachment.attach-time</code> - The time that the network interface was attached to an instance.</p> </li> <li> <p> <code>attachment.delete-on-termination</code> - Indicates whether the attachment is deleted when an instance is terminated.</p> </li> <li> <p> <code>attachment.device-index</code> - The device index to which the network interface is attached.</p> </li> <li> <p> <code>attachment.instance-id</code> - The ID of the instance to which the network interface is attached.</p> </li> <li> <p> <code>attachment.instance-owner-id</code> - The owner ID of the instance to which the network interface is attached.</p> </li> <li> <p> <code>attachment.status</code> - The status of the attachment (<code>attaching</code> | <code>attached</code> | <code>detaching</code> | <code>detached</code>).</p> </li> <li> <p> <code>availability-zone</code> - The Availability Zone of the network interface.</p> </li> <li> <p> <code>description</code> - The description of the network interface.</p> </li> <li> <p> <code>group-id</code> - The ID of a security group associated with the network interface.</p> </li> <li> <p> <code>group-name</code> - The name of a security group associated with the network interface.</p> </li> <li> <p> <code>ipv6-addresses.ipv6-address</code> - An IPv6 address associated with the network interface.</p> </li> <li> <p> <code>mac-address</code> - The MAC address of the network interface.</p> </li> <li> <p> <code>network-interface-id</code> - The ID of the network interface.</p> </li> <li> <p> <code>owner-id</code> - The AWS account ID of the network interface owner.</p> </li> <li> <p> <code>private-ip-address</code> - The private IPv4 address or addresses of the network interface.</p> </li> <li> <p> <code>private-dns-name</code> - The private DNS name of the network interface (IPv4).</p> </li> <li> <p> <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example, AWS Management Console, Auto Scaling, and so on).</p> </li> <li> <p> <code>requester-managed</code> - Indicates whether the network interface is being managed by an AWS service (for example, AWS Management Console, Auto Scaling, and so on).</p> </li> <li> <p> <code>source-dest-check</code> - Indicates whether the network interface performs source/destination checking. A value of <code>true</code> means checking is enabled, and <code>false</code> means checking is disabled. The value must be <code>false</code> for the network interface to perform network address translation (NAT) in your VPC. </p> </li> <li> <p> <code>status</code> - The status of the network interface. If the network interface is not attached to an instance, the status is <code>available</code>; if a network interface is attached to an instance the status is <code>in-use</code>.</p> </li> <li> <p> <code>subnet-id</code> - The ID of the subnet for the network interface.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC for the network interface.</p> </li> </ul>', 'DescribePlacementGroupsRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>group-name</code> - The name of the placement group.</p> </li> <li> <p> <code>state</code> - The state of the placement group (<code>pending</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code>).</p> </li> <li> <p> <code>strategy</code> - The strategy of the placement group (<code>cluster</code> | <code>spread</code> | <code>partition</code>).</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources that have a tag with a specific key, regardless of the tag value.</p> </li> </ul>', 'DescribePrefixListsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>prefix-list-id</code>: The ID of a prefix list.</p> </li> <li> <p> <code>prefix-list-name</code>: The name of a prefix list.</p> </li> </ul>', 'DescribePublicIpv4PoolsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul>', 'DescribeRegionsRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>endpoint</code> - The endpoint of the Region (for example, <code>ec2.us-east-1.amazonaws.com</code>).</p> </li> <li> <p> <code>opt-in-status</code> - The opt-in status of the Region (<code>opt-in-not-required</code> | <code>opted-in</code> | <code>not-opted-in</code>).</p> </li> <li> <p> <code>region-name</code> - The name of the Region (for example, <code>us-east-1</code>).</p> </li> </ul>', 'DescribeReservedInstancesListingsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>reserved-instances-id</code> - The ID of the Reserved Instances.</p> </li> <li> <p> <code>reserved-instances-listing-id</code> - The ID of the Reserved Instances listing.</p> </li> <li> <p> <code>status</code> - The status of the Reserved Instance listing (<code>pending</code> | <code>active</code> | <code>cancelled</code> | <code>closed</code>).</p> </li> <li> <p> <code>status-message</code> - The reason for the status.</p> </li> </ul>', 'DescribeReservedInstancesModificationsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>client-token</code> - The idempotency token for the modification request.</p> </li> <li> <p> <code>create-date</code> - The time when the modification request was created.</p> </li> <li> <p> <code>effective-date</code> - The time when the modification becomes effective.</p> </li> <li> <p> <code>modification-result.reserved-instances-id</code> - The ID for the Reserved Instances created as part of the modification request. This ID is only available when the status of the modification is <code>fulfilled</code>.</p> </li> <li> <p> <code>modification-result.target-configuration.availability-zone</code> - The Availability Zone for the new Reserved Instances.</p> </li> <li> <p> <code>modification-result.target-configuration.instance-count </code> - The number of new Reserved Instances.</p> </li> <li> <p> <code>modification-result.target-configuration.instance-type</code> - The instance type of the new Reserved Instances.</p> </li> <li> <p> <code>modification-result.target-configuration.platform</code> - The network platform of the new Reserved Instances (<code>EC2-Classic</code> | <code>EC2-VPC</code>).</p> </li> <li> <p> <code>reserved-instances-id</code> - The ID of the Reserved Instances modified.</p> </li> <li> <p> <code>reserved-instances-modification-id</code> - The ID of the modification request.</p> </li> <li> <p> <code>status</code> - The status of the Reserved Instances modification request (<code>processing</code> | <code>fulfilled</code> | <code>failed</code>).</p> </li> <li> <p> <code>status-message</code> - The reason for the status.</p> </li> <li> <p> <code>update-date</code> - The time when the modification request was last updated.</p> </li> </ul>', 'DescribeReservedInstancesOfferingsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>availability-zone</code> - The Availability Zone where the Reserved Instance can be used.</p> </li> <li> <p> <code>duration</code> - The duration of the Reserved Instance (for example, one year or three years), in seconds (<code>31536000</code> | <code>94608000</code>).</p> </li> <li> <p> <code>fixed-price</code> - The purchase price of the Reserved Instance (for example, 9800.0).</p> </li> <li> <p> <code>instance-type</code> - The instance type that is covered by the reservation.</p> </li> <li> <p> <code>marketplace</code> - Set to <code>true</code> to show only Reserved Instance Marketplace offerings. When this filter is not used, which is the default behavior, all offerings from both AWS and the Reserved Instance Marketplace are listed.</p> </li> <li> <p> <code>product-description</code> - The Reserved Instance product platform description. Instances that include <code>(Amazon VPC)</code> in the product platform description will only be displayed to EC2-Classic account holders and are for use with Amazon VPC. (<code>Linux/UNIX</code> | <code>Linux/UNIX (Amazon VPC)</code> | <code>SUSE Linux</code> | <code>SUSE Linux (Amazon VPC)</code> | <code>Red Hat Enterprise Linux</code> | <code>Red Hat Enterprise Linux (Amazon VPC)</code> | <code>Windows</code> | <code>Windows (Amazon VPC)</code> | <code>Windows with SQL Server Standard</code> | <code>Windows with SQL Server Standard (Amazon VPC)</code> | <code>Windows with SQL Server Web</code> | <code> Windows with SQL Server Web (Amazon VPC)</code> | <code>Windows with SQL Server Enterprise</code> | <code>Windows with SQL Server Enterprise (Amazon VPC)</code>) </p> </li> <li> <p> <code>reserved-instances-offering-id</code> - The Reserved Instances offering ID.</p> </li> <li> <p> <code>scope</code> - The scope of the Reserved Instance (<code>Availability Zone</code> or <code>Region</code>).</p> </li> <li> <p> <code>usage-price</code> - The usage price of the Reserved Instance, per hour (for example, 0.84).</p> </li> </ul>', 'DescribeReservedInstancesRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>availability-zone</code> - The Availability Zone where the Reserved Instance can be used.</p> </li> <li> <p> <code>duration</code> - The duration of the Reserved Instance (one year or three years), in seconds (<code>31536000</code> | <code>94608000</code>).</p> </li> <li> <p> <code>end</code> - The time when the Reserved Instance expires (for example, 2015-08-07T11:54:42.000Z).</p> </li> <li> <p> <code>fixed-price</code> - The purchase price of the Reserved Instance (for example, 9800.0).</p> </li> <li> <p> <code>instance-type</code> - The instance type that is covered by the reservation.</p> </li> <li> <p> <code>scope</code> - The scope of the Reserved Instance (<code>Region</code> or <code>Availability Zone</code>).</p> </li> <li> <p> <code>product-description</code> - The Reserved Instance product platform description. Instances that include <code>(Amazon VPC)</code> in the product platform description will only be displayed to EC2-Classic account holders and are for use with Amazon VPC (<code>Linux/UNIX</code> | <code>Linux/UNIX (Amazon VPC)</code> | <code>SUSE Linux</code> | <code>SUSE Linux (Amazon VPC)</code> | <code>Red Hat Enterprise Linux</code> | <code>Red Hat Enterprise Linux (Amazon VPC)</code> | <code>Windows</code> | <code>Windows (Amazon VPC)</code> | <code>Windows with SQL Server Standard</code> | <code>Windows with SQL Server Standard (Amazon VPC)</code> | <code>Windows with SQL Server Web</code> | <code>Windows with SQL Server Web (Amazon VPC)</code> | <code>Windows with SQL Server Enterprise</code> | <code>Windows with SQL Server Enterprise (Amazon VPC)</code>).</p> </li> <li> <p> <code>reserved-instances-id</code> - The ID of the Reserved Instance.</p> </li> <li> <p> <code>start</code> - The time at which the Reserved Instance purchase request was placed (for example, 2014-08-07T11:54:42.000Z).</p> </li> <li> <p> <code>state</code> - The state of the Reserved Instance (<code>payment-pending</code> | <code>active</code> | <code>payment-failed</code> | <code>retired</code>).</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>usage-price</code> - The usage price of the Reserved Instance, per hour (for example, 0.84).</p> </li> </ul>', 'DescribeRouteTablesRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>association.route-table-association-id</code> - The ID of an association ID for the route table.</p> </li> <li> <p> <code>association.route-table-id</code> - The ID of the route table involved in the association.</p> </li> <li> <p> <code>association.subnet-id</code> - The ID of the subnet involved in the association.</p> </li> <li> <p> <code>association.main</code> - Indicates whether the route table is the main route table for the VPC (<code>true</code> | <code>false</code>). Route tables that do not have an association ID are not returned in the response.</p> </li> <li> <p> <code>owner-id</code> - The ID of the AWS account that owns the route table.</p> </li> <li> <p> <code>route-table-id</code> - The ID of the route table.</p> </li> <li> <p> <code>route.destination-cidr-block</code> - The IPv4 CIDR range specified in a route in the table.</p> </li> <li> <p> <code>route.destination-ipv6-cidr-block</code> - The IPv6 CIDR range specified in a route in the route table.</p> </li> <li> <p> <code>route.destination-prefix-list-id</code> - The ID (prefix) of the AWS service specified in a route in the table.</p> </li> <li> <p> <code>route.egress-only-internet-gateway-id</code> - The ID of an egress-only Internet gateway specified in a route in the route table.</p> </li> <li> <p> <code>route.gateway-id</code> - The ID of a gateway specified in a route in the table.</p> </li> <li> <p> <code>route.instance-id</code> - The ID of an instance specified in a route in the table.</p> </li> <li> <p> <code>route.nat-gateway-id</code> - The ID of a NAT gateway.</p> </li> <li> <p> <code>route.transit-gateway-id</code> - The ID of a transit gateway.</p> </li> <li> <p> <code>route.origin</code> - Describes how the route was created. <code>CreateRouteTable</code> indicates that the route was automatically created when the route table was created; <code>CreateRoute</code> indicates that the route was manually added to the route table; <code>EnableVgwRoutePropagation</code> indicates that the route was propagated by route propagation.</p> </li> <li> <p> <code>route.state</code> - The state of a route in the route table (<code>active</code> | <code>blackhole</code>). The blackhole state indicates that the route\'s target isn\'t available (for example, the specified gateway isn\'t attached to the VPC, the specified NAT instance has been terminated, and so on).</p> </li> <li> <p> <code>route.vpc-peering-connection-id</code> - The ID of a VPC peering connection specified in a route in the table.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC for the route table.</p> </li> </ul>', 'DescribeScheduledInstanceAvailabilityRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).</p> </li> <li> <p> <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).</p> </li> <li> <p> <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).</p> </li> <li> <p> <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).</p> </li> </ul>', 'DescribeScheduledInstancesRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).</p> </li> <li> <p> <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).</p> </li> <li> <p> <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).</p> </li> <li> <p> <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).</p> </li> </ul>', 'DescribeSecurityGroupsRequest$Filters' => '<p>The filters. If using multiple filters for rules, the results include security groups for which any combination of rules - not necessarily a single rule - match all filters.</p> <ul> <li> <p> <code>description</code> - The description of the security group.</p> </li> <li> <p> <code>egress.ip-permission.cidr</code> - An IPv4 CIDR block for an outbound security group rule.</p> </li> <li> <p> <code>egress.ip-permission.from-port</code> - For an outbound rule, the start of port range for the TCP and UDP protocols, or an ICMP type number.</p> </li> <li> <p> <code>egress.ip-permission.group-id</code> - The ID of a security group that has been referenced in an outbound security group rule.</p> </li> <li> <p> <code>egress.ip-permission.group-name</code> - The name of a security group that has been referenced in an outbound security group rule.</p> </li> <li> <p> <code>egress.ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an outbound security group rule.</p> </li> <li> <p> <code>egress.ip-permission.prefix-list-id</code> - The ID of a prefix list to which a security group rule allows outbound access.</p> </li> <li> <p> <code>egress.ip-permission.protocol</code> - The IP protocol for an outbound security group rule (<code>tcp</code> | <code>udp</code> | <code>icmp</code> or a protocol number).</p> </li> <li> <p> <code>egress.ip-permission.to-port</code> - For an outbound rule, the end of port range for the TCP and UDP protocols, or an ICMP code.</p> </li> <li> <p> <code>egress.ip-permission.user-id</code> - The ID of an AWS account that has been referenced in an outbound security group rule.</p> </li> <li> <p> <code>group-id</code> - The ID of the security group. </p> </li> <li> <p> <code>group-name</code> - The name of the security group.</p> </li> <li> <p> <code>ip-permission.cidr</code> - An IPv4 CIDR block for an inbound security group rule.</p> </li> <li> <p> <code>ip-permission.from-port</code> - For an inbound rule, the start of port range for the TCP and UDP protocols, or an ICMP type number.</p> </li> <li> <p> <code>ip-permission.group-id</code> - The ID of a security group that has been referenced in an inbound security group rule.</p> </li> <li> <p> <code>ip-permission.group-name</code> - The name of a security group that has been referenced in an inbound security group rule.</p> </li> <li> <p> <code>ip-permission.ipv6-cidr</code> - An IPv6 CIDR block for an inbound security group rule.</p> </li> <li> <p> <code>ip-permission.prefix-list-id</code> - The ID of a prefix list from which a security group rule allows inbound access.</p> </li> <li> <p> <code>ip-permission.protocol</code> - The IP protocol for an inbound security group rule (<code>tcp</code> | <code>udp</code> | <code>icmp</code> or a protocol number).</p> </li> <li> <p> <code>ip-permission.to-port</code> - For an inbound rule, the end of port range for the TCP and UDP protocols, or an ICMP code.</p> </li> <li> <p> <code>ip-permission.user-id</code> - The ID of an AWS account that has been referenced in an inbound security group rule.</p> </li> <li> <p> <code>owner-id</code> - The AWS account ID of the owner of the security group.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC specified when the security group was created.</p> </li> </ul>', 'DescribeSnapshotsRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>description</code> - A description of the snapshot.</p> </li> <li> <p> <code>encrypted</code> - Indicates whether the snapshot is encrypted (<code>true</code> | <code>false</code>)</p> </li> <li> <p> <code>owner-alias</code> - The owner alias, from an Amazon-maintained list (<code>amazon</code>). This is not the user-configured AWS account alias set using the IAM console. We recommend that you use the related parameter instead of this filter.</p> </li> <li> <p> <code>owner-id</code> - The AWS account ID of the owner. We recommend that you use the related parameter instead of this filter.</p> </li> <li> <p> <code>progress</code> - The progress of the snapshot, as a percentage (for example, 80%).</p> </li> <li> <p> <code>snapshot-id</code> - The snapshot ID.</p> </li> <li> <p> <code>start-time</code> - The time stamp when the snapshot was initiated.</p> </li> <li> <p> <code>status</code> - The status of the snapshot (<code>pending</code> | <code>completed</code> | <code>error</code>).</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>volume-id</code> - The ID of the volume the snapshot is for.</p> </li> <li> <p> <code>volume-size</code> - The size of the volume, in GiB.</p> </li> </ul>', 'DescribeSpotInstanceRequestsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>availability-zone-group</code> - The Availability Zone group.</p> </li> <li> <p> <code>create-time</code> - The time stamp when the Spot Instance request was created.</p> </li> <li> <p> <code>fault-code</code> - The fault code related to the request.</p> </li> <li> <p> <code>fault-message</code> - The fault message related to the request.</p> </li> <li> <p> <code>instance-id</code> - The ID of the instance that fulfilled the request.</p> </li> <li> <p> <code>launch-group</code> - The Spot Instance launch group.</p> </li> <li> <p> <code>launch.block-device-mapping.delete-on-termination</code> - Indicates whether the EBS volume is deleted on instance termination.</p> </li> <li> <p> <code>launch.block-device-mapping.device-name</code> - The device name for the volume in the block device mapping (for example, <code>/dev/sdh</code> or <code>xvdh</code>).</p> </li> <li> <p> <code>launch.block-device-mapping.snapshot-id</code> - The ID of the snapshot for the EBS volume.</p> </li> <li> <p> <code>launch.block-device-mapping.volume-size</code> - The size of the EBS volume, in GiB.</p> </li> <li> <p> <code>launch.block-device-mapping.volume-type</code> - The type of EBS volume: <code>gp2</code> for General Purpose SSD, <code>io1</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code>for Cold HDD, or <code>standard</code> for Magnetic.</p> </li> <li> <p> <code>launch.group-id</code> - The ID of the security group for the instance.</p> </li> <li> <p> <code>launch.group-name</code> - The name of the security group for the instance.</p> </li> <li> <p> <code>launch.image-id</code> - The ID of the AMI.</p> </li> <li> <p> <code>launch.instance-type</code> - The type of instance (for example, <code>m3.medium</code>).</p> </li> <li> <p> <code>launch.kernel-id</code> - The kernel ID.</p> </li> <li> <p> <code>launch.key-name</code> - The name of the key pair the instance launched with.</p> </li> <li> <p> <code>launch.monitoring-enabled</code> - Whether detailed monitoring is enabled for the Spot Instance.</p> </li> <li> <p> <code>launch.ramdisk-id</code> - The RAM disk ID.</p> </li> <li> <p> <code>launched-availability-zone</code> - The Availability Zone in which the request is launched.</p> </li> <li> <p> <code>network-interface.addresses.primary</code> - Indicates whether the IP address is the primary private IP address.</p> </li> <li> <p> <code>network-interface.delete-on-termination</code> - Indicates whether the network interface is deleted when the instance is terminated.</p> </li> <li> <p> <code>network-interface.description</code> - A description of the network interface.</p> </li> <li> <p> <code>network-interface.device-index</code> - The index of the device for the network interface attachment on the instance.</p> </li> <li> <p> <code>network-interface.group-id</code> - The ID of the security group associated with the network interface.</p> </li> <li> <p> <code>network-interface.network-interface-id</code> - The ID of the network interface.</p> </li> <li> <p> <code>network-interface.private-ip-address</code> - The primary private IP address of the network interface.</p> </li> <li> <p> <code>network-interface.subnet-id</code> - The ID of the subnet for the instance.</p> </li> <li> <p> <code>product-description</code> - The product description associated with the instance (<code>Linux/UNIX</code> | <code>Windows</code>).</p> </li> <li> <p> <code>spot-instance-request-id</code> - The Spot Instance request ID.</p> </li> <li> <p> <code>spot-price</code> - The maximum hourly price for any Spot Instance launched to fulfill the request.</p> </li> <li> <p> <code>state</code> - The state of the Spot Instance request (<code>open</code> | <code>active</code> | <code>closed</code> | <code>cancelled</code> | <code>failed</code>). Spot request status information can help you track your Amazon EC2 Spot Instance requests. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html">Spot request status</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p> </li> <li> <p> <code>status-code</code> - The short code describing the most recent evaluation of your Spot Instance request.</p> </li> <li> <p> <code>status-message</code> - The message explaining the status of the Spot Instance request.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>type</code> - The type of Spot Instance request (<code>one-time</code> | <code>persistent</code>).</p> </li> <li> <p> <code>valid-from</code> - The start date of the request.</p> </li> <li> <p> <code>valid-until</code> - The end date of the request.</p> </li> </ul>', 'DescribeSpotPriceHistoryRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>availability-zone</code> - The Availability Zone for which prices should be returned.</p> </li> <li> <p> <code>instance-type</code> - The type of instance (for example, <code>m3.medium</code>).</p> </li> <li> <p> <code>product-description</code> - The product description for the Spot price (<code>Linux/UNIX</code> | <code>SUSE Linux</code> | <code>Windows</code> | <code>Linux/UNIX (Amazon VPC)</code> | <code>SUSE Linux (Amazon VPC)</code> | <code>Windows (Amazon VPC)</code>).</p> </li> <li> <p> <code>spot-price</code> - The Spot price. The value must match exactly (or use wildcards; greater than or less than comparison is not supported).</p> </li> <li> <p> <code>timestamp</code> - The time stamp of the Spot price history, in UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). You can use wildcards (* and ?). Greater than or less than comparison is not supported.</p> </li> </ul>', 'DescribeSubnetsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>availability-zone</code> - The Availability Zone for the subnet. You can also use <code>availabilityZone</code> as the filter name.</p> </li> <li> <p> <code>availability-zone-id</code> - The ID of the Availability Zone for the subnet. You can also use <code>availabilityZoneId</code> as the filter name.</p> </li> <li> <p> <code>available-ip-address-count</code> - The number of IPv4 addresses in the subnet that are available.</p> </li> <li> <p> <code>cidr-block</code> - The IPv4 CIDR block of the subnet. The CIDR block you specify must exactly match the subnet\'s CIDR block for information to be returned for the subnet. You can also use <code>cidr</code> or <code>cidrBlock</code> as the filter names.</p> </li> <li> <p> <code>default-for-az</code> - Indicates whether this is the default subnet for the Availability Zone. You can also use <code>defaultForAz</code> as the filter name.</p> </li> <li> <p> <code>ipv6-cidr-block-association.ipv6-cidr-block</code> - An IPv6 CIDR block associated with the subnet.</p> </li> <li> <p> <code>ipv6-cidr-block-association.association-id</code> - An association ID for an IPv6 CIDR block associated with the subnet.</p> </li> <li> <p> <code>ipv6-cidr-block-association.state</code> - The state of an IPv6 CIDR block associated with the subnet.</p> </li> <li> <p> <code>owner-id</code> - The ID of the AWS account that owns the subnet.</p> </li> <li> <p> <code>state</code> - The state of the subnet (<code>pending</code> | <code>available</code>).</p> </li> <li> <p> <code>subnet-arn</code> - The Amazon Resource Name (ARN) of the subnet.</p> </li> <li> <p> <code>subnet-id</code> - The ID of the subnet.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC for the subnet.</p> </li> </ul>', 'DescribeTagsRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>key</code> - The tag key.</p> </li> <li> <p> <code>resource-id</code> - The ID of the resource.</p> </li> <li> <p> <code>resource-type</code> - The resource type (<code>customer-gateway</code> | <code>dedicated-host</code> | <code>dhcp-options</code> | <code>elastic-ip</code> | <code>fleet</code> | <code>fpga-image</code> | <code>host-reservation</code> | <code>image</code> | <code>instance</code> | <code>internet-gateway</code> | <code>key-pair</code> | <code>launch-template</code> | <code>natgateway</code> | <code>network-acl</code> | <code>network-interface</code> | <code>placement-group</code> | <code>reserved-instances</code> | <code>route-table</code> | <code>security-group</code> | <code>snapshot</code> | <code>spot-instances-request</code> | <code>subnet</code> | <code>volume</code> | <code>vpc</code> | <code>vpc-endpoint</code> | <code>vpc-endpoint-service</code> | <code>vpc-peering-connection</code> | <code>vpn-connection</code> | <code>vpn-gateway</code>).</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of the tag. For example, specify "tag:Owner" for the filter name and "TeamA" for the filter value to find resources with the tag "Owner=TeamA".</p> </li> <li> <p> <code>value</code> - The tag value.</p> </li> </ul>', 'DescribeTrafficMirrorFiltersRequest$Filters' => '<p>One or more filters. The possible values are:</p> <ul> <li> <p> <code>description</code>: The Traffic Mirror filter description.</p> </li> <li> <p> <code>traffic-mirror-filter-id</code>: The ID of the Traffic Mirror filter.</p> </li> </ul>', 'DescribeTrafficMirrorSessionsRequest$Filters' => '<p>One or more filters. The possible values are:</p> <ul> <li> <p> <code>description</code>: The Traffic Mirror session description.</p> </li> <li> <p> <code>network-interface-id</code>: The ID of the Traffic Mirror session network interface.</p> </li> <li> <p> <code>owner-id</code>: The ID of the account that owns the Traffic Mirror session.</p> </li> <li> <p> <code>packet-length</code>: The assigned number of packets to mirror. </p> </li> <li> <p> <code>session-number</code>: The assigned session number. </p> </li> <li> <p> <code>traffic-mirror-filter-id</code>: The ID of the Traffic Mirror filter.</p> </li> <li> <p> <code>traffic-mirror-session-id</code>: The ID of the Traffic Mirror session.</p> </li> <li> <p> <code>traffic-mirror-target-id</code>: The ID of the Traffic Mirror target.</p> </li> <li> <p> <code>virtual-network-id</code>: The virtual network ID of the Traffic Mirror session.</p> </li> </ul>', 'DescribeTrafficMirrorTargetsRequest$Filters' => '<p>One or more filters. The possible values are:</p> <ul> <li> <p> <code>description</code>: The Traffic Mirror target description.</p> </li> <li> <p> <code>network-interface-id</code>: The ID of the Traffic Mirror session network interface.</p> </li> <li> <p> <code>network-load-balancer-arn</code>: The Amazon Resource Name (ARN) of the Network Load Balancer that is associated with the session.</p> </li> <li> <p> <code>owner-id</code>: The ID of the account that owns the Traffic Mirror session.</p> </li> <li> <p> <code>traffic-mirror-target-id</code>: The ID of the Traffic Mirror target.</p> </li> </ul>', 'DescribeTransitGatewayAttachmentsRequest$Filters' => '<p>One or more filters. The possible values are:</p> <ul> <li> <p> <code>association.state</code> - The state of the association (<code>associating</code> | <code>associated</code> | <code>disassociating</code>).</p> </li> <li> <p> <code>association.transit-gateway-route-table-id</code> - The ID of the route table for the transit gateway.</p> </li> <li> <p> <code>resource-id</code> - The ID of the resource.</p> </li> <li> <p> <code>resource-owner-id</code> - The ID of the AWS account that owns the resource.</p> </li> <li> <p> <code>resource-type</code> - The resource type (<code>vpc</code> | <code>vpn</code>).</p> </li> <li> <p> <code>state</code> - The state of the attachment (<code>available</code> | <code>deleted</code> | <code>deleting</code> | <code>failed</code> | <code>modifying</code> | <code>pendingAcceptance</code> | <code>pending</code> | <code>rollingBack</code> | <code>rejected</code> | <code>rejecting</code>).</p> </li> <li> <p> <code>transit-gateway-attachment-id</code> - The ID of the attachment.</p> </li> <li> <p> <code>transit-gateway-id</code> - The ID of the transit gateway.</p> </li> <li> <p> <code>transit-gateway-owner-id</code> - The ID of the AWS account that owns the transit gateway.</p> </li> </ul>', 'DescribeTransitGatewayMulticastDomainsRequest$Filters' => '<p>One or more filters. The possible values are:</p> <ul> <li> <p> <code>state</code> - The state of the transit gateway multicast domain. Valid values are <code>pending</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code>.</p> </li> <li> <p> <code>transit-gateway-id</code> - The ID of the transit gateway.</p> </li> <li> <p> <code>transit-gateway-multicast-domain-id</code> - The ID of the transit gateway multicast domain.</p> </li> </ul>', 'DescribeTransitGatewayPeeringAttachmentsRequest$Filters' => '<p>One or more filters. The possible values are:</p> <ul> <li> <p> <code>transit-gateway-attachment-id</code> - The ID of the transit gateway attachment.</p> </li> <li> <p> <code>local-owner-id</code> - The ID of your AWS account.</p> </li> <li> <p> <code>remote-owner-id</code> - The ID of the AWS account in the remote Region that owns the transit gateway.</p> </li> <li> <p> <code>state</code> - The state of the peering attachment (<code>available</code> | <code>deleted</code> | <code>deleting</code> | <code>failed</code> | <code>modifying</code> | <code>pendingAcceptance</code> | <code>pending</code> | <code>rollingBack</code> | <code>rejected</code> | <code>rejecting</code>).</p> </li> <li> <p> <code>transit-gateway-id</code> - The ID of the transit gateway.</p> </li> </ul>', 'DescribeTransitGatewayRouteTablesRequest$Filters' => '<p>One or more filters. The possible values are:</p> <ul> <li> <p> <code>default-association-route-table</code> - Indicates whether this is the default association route table for the transit gateway (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>default-propagation-route-table</code> - Indicates whether this is the default propagation route table for the transit gateway (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>state</code> - The state of the attachment (<code>available</code> | <code>deleted</code> | <code>deleting</code> | <code>failed</code> | <code>modifying</code> | <code>pendingAcceptance</code> | <code>pending</code> | <code>rollingBack</code> | <code>rejected</code> | <code>rejecting</code>).</p> </li> <li> <p> <code>transit-gateway-id</code> - The ID of the transit gateway.</p> </li> <li> <p> <code>transit-gateway-route-table-id</code> - The ID of the transit gateway route table.</p> </li> </ul>', 'DescribeTransitGatewayVpcAttachmentsRequest$Filters' => '<p>One or more filters. The possible values are:</p> <ul> <li> <p> <code>state</code> - The state of the attachment (<code>available</code> | <code>deleted</code> | <code>deleting</code> | <code>failed</code> | <code>modifying</code> | <code>pendingAcceptance</code> | <code>pending</code> | <code>rollingBack</code> | <code>rejected</code> | <code>rejecting</code>).</p> </li> <li> <p> <code>transit-gateway-attachment-id</code> - The ID of the attachment.</p> </li> <li> <p> <code>transit-gateway-id</code> - The ID of the transit gateway.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC.</p> </li> </ul>', 'DescribeTransitGatewaysRequest$Filters' => '<p>One or more filters. The possible values are:</p> <ul> <li> <p> <code>options.propagation-default-route-table-id</code> - The ID of the default propagation route table.</p> </li> <li> <p> <code>options.amazon-side-asn</code> - The private ASN for the Amazon side of a BGP session.</p> </li> <li> <p> <code>options.association-default-route-table-id</code> - The ID of the default association route table.</p> </li> <li> <p> <code>options.auto-accept-shared-attachments</code> - Indicates whether there is automatic acceptance of attachment requests (<code>enable</code> | <code>disable</code>).</p> </li> <li> <p> <code>options.default-route-table-association</code> - Indicates whether resource attachments are automatically associated with the default association route table (<code>enable</code> | <code>disable</code>).</p> </li> <li> <p> <code>options.default-route-table-propagation</code> - Indicates whether resource attachments automatically propagate routes to the default propagation route table (<code>enable</code> | <code>disable</code>).</p> </li> <li> <p> <code>options.dns-support</code> - Indicates whether DNS support is enabled (<code>enable</code> | <code>disable</code>).</p> </li> <li> <p> <code>options.vpn-ecmp-support</code> - Indicates whether Equal Cost Multipath Protocol support is enabled (<code>enable</code> | <code>disable</code>).</p> </li> <li> <p> <code>owner-id</code> - The ID of the AWS account that owns the transit gateway.</p> </li> <li> <p> <code>state</code> - The state of the attachment (<code>available</code> | <code>deleted</code> | <code>deleting</code> | <code>failed</code> | <code>modifying</code> | <code>pendingAcceptance</code> | <code>pending</code> | <code>rollingBack</code> | <code>rejected</code> | <code>rejecting</code>).</p> </li> <li> <p> <code>transit-gateway-id</code> - The ID of the transit gateway.</p> </li> </ul>', 'DescribeVolumeStatusRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>action.code</code> - The action code for the event (for example, <code>enable-volume-io</code>).</p> </li> <li> <p> <code>action.description</code> - A description of the action.</p> </li> <li> <p> <code>action.event-id</code> - The event ID associated with the action.</p> </li> <li> <p> <code>availability-zone</code> - The Availability Zone of the instance.</p> </li> <li> <p> <code>event.description</code> - A description of the event.</p> </li> <li> <p> <code>event.event-id</code> - The event ID.</p> </li> <li> <p> <code>event.event-type</code> - The event type (for <code>io-enabled</code>: <code>passed</code> | <code>failed</code>; for <code>io-performance</code>: <code>io-performance:degraded</code> | <code>io-performance:severely-degraded</code> | <code>io-performance:stalled</code>).</p> </li> <li> <p> <code>event.not-after</code> - The latest end time for the event.</p> </li> <li> <p> <code>event.not-before</code> - The earliest start time for the event.</p> </li> <li> <p> <code>volume-status.details-name</code> - The cause for <code>volume-status.status</code> (<code>io-enabled</code> | <code>io-performance</code>).</p> </li> <li> <p> <code>volume-status.details-status</code> - The status of <code>volume-status.details-name</code> (for <code>io-enabled</code>: <code>passed</code> | <code>failed</code>; for <code>io-performance</code>: <code>normal</code> | <code>degraded</code> | <code>severely-degraded</code> | <code>stalled</code>).</p> </li> <li> <p> <code>volume-status.status</code> - The status of the volume (<code>ok</code> | <code>impaired</code> | <code>warning</code> | <code>insufficient-data</code>).</p> </li> </ul>', 'DescribeVolumesModificationsRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>modification-state</code> - The current modification state (modifying | optimizing | completed | failed).</p> </li> <li> <p> <code>original-iops</code> - The original IOPS rate of the volume.</p> </li> <li> <p> <code>original-size</code> - The original size of the volume, in GiB.</p> </li> <li> <p> <code>original-volume-type</code> - The original volume type of the volume (standard | io1 | gp2 | sc1 | st1).</p> </li> <li> <p> <code>originalMultiAttachEnabled</code> - Indicates whether Multi-Attach support was enabled (true | false).</p> </li> <li> <p> <code>start-time</code> - The modification start time.</p> </li> <li> <p> <code>target-iops</code> - The target IOPS rate of the volume.</p> </li> <li> <p> <code>target-size</code> - The target size of the volume, in GiB.</p> </li> <li> <p> <code>target-volume-type</code> - The target volume type of the volume (standard | io1 | gp2 | sc1 | st1).</p> </li> <li> <p> <code>targetMultiAttachEnabled</code> - Indicates whether Multi-Attach support is to be enabled (true | false).</p> </li> <li> <p> <code>volume-id</code> - The ID of the volume.</p> </li> </ul>', 'DescribeVolumesRequest$Filters' => '<p>The filters.</p> <ul> <li> <p> <code>attachment.attach-time</code> - The time stamp when the attachment initiated.</p> </li> <li> <p> <code>attachment.delete-on-termination</code> - Whether the volume is deleted on instance termination.</p> </li> <li> <p> <code>attachment.device</code> - The device name specified in the block device mapping (for example, <code>/dev/sda1</code>).</p> </li> <li> <p> <code>attachment.instance-id</code> - The ID of the instance the volume is attached to.</p> </li> <li> <p> <code>attachment.status</code> - The attachment state (<code>attaching</code> | <code>attached</code> | <code>detaching</code>).</p> </li> <li> <p> <code>availability-zone</code> - The Availability Zone in which the volume was created.</p> </li> <li> <p> <code>create-time</code> - The time stamp when the volume was created.</p> </li> <li> <p> <code>encrypted</code> - Indicates whether the volume is encrypted (<code>true</code> | <code>false</code>)</p> </li> <li> <p> <code>multi-attach-enabled</code> - Indicates whether the volume is enabled for Multi-Attach (<code>true</code> | <code>false</code>)</p> </li> <li> <p> <code>fast-restored</code> - Indicates whether the volume was created from a snapshot that is enabled for fast snapshot restore (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>size</code> - The size of the volume, in GiB.</p> </li> <li> <p> <code>snapshot-id</code> - The snapshot from which the volume was created.</p> </li> <li> <p> <code>status</code> - The status of the volume (<code>creating</code> | <code>available</code> | <code>in-use</code> | <code>deleting</code> | <code>deleted</code> | <code>error</code>).</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>volume-id</code> - The volume ID.</p> </li> <li> <p> <code>volume-type</code> - The Amazon EBS volume type. This can be <code>gp2</code> for General Purpose SSD, <code>io1</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code> for Cold HDD, or <code>standard</code> for Magnetic volumes.</p> </li> </ul>', 'DescribeVpcClassicLinkRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>is-classic-link-enabled</code> - Whether the VPC is enabled for ClassicLink (<code>true</code> | <code>false</code>).</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul>', 'DescribeVpcEndpointConnectionNotificationsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>connection-notification-arn</code> - The ARN of the SNS topic for the notification.</p> </li> <li> <p> <code>connection-notification-id</code> - The ID of the notification.</p> </li> <li> <p> <code>connection-notification-state</code> - The state of the notification (<code>Enabled</code> | <code>Disabled</code>).</p> </li> <li> <p> <code>connection-notification-type</code> - The type of notification (<code>Topic</code>).</p> </li> <li> <p> <code>service-id</code> - The ID of the endpoint service.</p> </li> <li> <p> <code>vpc-endpoint-id</code> - The ID of the VPC endpoint.</p> </li> </ul>', 'DescribeVpcEndpointConnectionsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>service-id</code> - The ID of the service.</p> </li> <li> <p> <code>vpc-endpoint-owner</code> - The AWS account number of the owner of the endpoint.</p> </li> <li> <p> <code>vpc-endpoint-state</code> - The state of the endpoint (<code>pendingAcceptance</code> | <code>pending</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code> | <code>rejected</code> | <code>failed</code>).</p> </li> <li> <p> <code>vpc-endpoint-id</code> - The ID of the endpoint.</p> </li> </ul>', 'DescribeVpcEndpointServiceConfigurationsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>service-name</code> - The name of the service.</p> </li> <li> <p> <code>service-id</code> - The ID of the service.</p> </li> <li> <p> <code>service-state</code> - The state of the service (<code>Pending</code> | <code>Available</code> | <code>Deleting</code> | <code>Deleted</code> | <code>Failed</code>). </p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul>', 'DescribeVpcEndpointServicePermissionsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>principal</code> - The ARN of the principal.</p> </li> <li> <p> <code>principal-type</code> - The principal type (<code>All</code> | <code>Service</code> | <code>OrganizationUnit</code> | <code>Account</code> | <code>User</code> | <code>Role</code>).</p> </li> </ul>', 'DescribeVpcEndpointServicesRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>service-name</code> - The name of the service.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul>', 'DescribeVpcEndpointsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>service-name</code> - The name of the service.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC in which the endpoint resides.</p> </li> <li> <p> <code>vpc-endpoint-id</code> - The ID of the endpoint.</p> </li> <li> <p> <code>vpc-endpoint-state</code> - The state of the endpoint (<code>pendingAcceptance</code> | <code>pending</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code> | <code>rejected</code> | <code>failed</code>).</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> </ul>', 'DescribeVpcPeeringConnectionsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>accepter-vpc-info.cidr-block</code> - The IPv4 CIDR block of the accepter VPC.</p> </li> <li> <p> <code>accepter-vpc-info.owner-id</code> - The AWS account ID of the owner of the accepter VPC.</p> </li> <li> <p> <code>accepter-vpc-info.vpc-id</code> - The ID of the accepter VPC.</p> </li> <li> <p> <code>expiration-time</code> - The expiration date and time for the VPC peering connection.</p> </li> <li> <p> <code>requester-vpc-info.cidr-block</code> - The IPv4 CIDR block of the requester\'s VPC.</p> </li> <li> <p> <code>requester-vpc-info.owner-id</code> - The AWS account ID of the owner of the requester VPC.</p> </li> <li> <p> <code>requester-vpc-info.vpc-id</code> - The ID of the requester VPC.</p> </li> <li> <p> <code>status-code</code> - The status of the VPC peering connection (<code>pending-acceptance</code> | <code>failed</code> | <code>expired</code> | <code>provisioning</code> | <code>active</code> | <code>deleting</code> | <code>deleted</code> | <code>rejected</code>).</p> </li> <li> <p> <code>status-message</code> - A message that provides more information about the status of the VPC peering connection, if applicable.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>vpc-peering-connection-id</code> - The ID of the VPC peering connection.</p> </li> </ul>', 'DescribeVpcsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>cidr</code> - The primary IPv4 CIDR block of the VPC. The CIDR block you specify must exactly match the VPC\'s CIDR block for information to be returned for the VPC. Must contain the slash followed by one or two digits (for example, <code>/28</code>).</p> </li> <li> <p> <code>cidr-block-association.cidr-block</code> - An IPv4 CIDR block associated with the VPC.</p> </li> <li> <p> <code>cidr-block-association.association-id</code> - The association ID for an IPv4 CIDR block associated with the VPC.</p> </li> <li> <p> <code>cidr-block-association.state</code> - The state of an IPv4 CIDR block associated with the VPC.</p> </li> <li> <p> <code>dhcp-options-id</code> - The ID of a set of DHCP options.</p> </li> <li> <p> <code>ipv6-cidr-block-association.ipv6-cidr-block</code> - An IPv6 CIDR block associated with the VPC.</p> </li> <li> <p> <code>ipv6-cidr-block-association.ipv6-pool</code> - The ID of the IPv6 address pool from which the IPv6 CIDR block is allocated.</p> </li> <li> <p> <code>ipv6-cidr-block-association.association-id</code> - The association ID for an IPv6 CIDR block associated with the VPC.</p> </li> <li> <p> <code>ipv6-cidr-block-association.state</code> - The state of an IPv6 CIDR block associated with the VPC.</p> </li> <li> <p> <code>isDefault</code> - Indicates whether the VPC is the default VPC.</p> </li> <li> <p> <code>owner-id</code> - The ID of the AWS account that owns the VPC.</p> </li> <li> <p> <code>state</code> - The state of the VPC (<code>pending</code> | <code>available</code>).</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>vpc-id</code> - The ID of the VPC.</p> </li> </ul>', 'DescribeVpnConnectionsRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>customer-gateway-configuration</code> - The configuration information for the customer gateway.</p> </li> <li> <p> <code>customer-gateway-id</code> - The ID of a customer gateway associated with the VPN connection.</p> </li> <li> <p> <code>state</code> - The state of the VPN connection (<code>pending</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code>).</p> </li> <li> <p> <code>option.static-routes-only</code> - Indicates whether the connection has static routes only. Used for devices that do not support Border Gateway Protocol (BGP).</p> </li> <li> <p> <code>route.destination-cidr-block</code> - The destination CIDR block. This corresponds to the subnet used in a customer data center.</p> </li> <li> <p> <code>bgp-asn</code> - The BGP Autonomous System Number (ASN) associated with a BGP device.</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>type</code> - The type of VPN connection. Currently the only supported type is <code>ipsec.1</code>.</p> </li> <li> <p> <code>vpn-connection-id</code> - The ID of the VPN connection.</p> </li> <li> <p> <code>vpn-gateway-id</code> - The ID of a virtual private gateway associated with the VPN connection.</p> </li> <li> <p> <code>transit-gateway-id</code> - The ID of a transit gateway associated with the VPN connection.</p> </li> </ul>', 'DescribeVpnGatewaysRequest$Filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>amazon-side-asn</code> - The Autonomous System Number (ASN) for the Amazon side of the gateway.</p> </li> <li> <p> <code>attachment.state</code> - The current state of the attachment between the gateway and the VPC (<code>attaching</code> | <code>attached</code> | <code>detaching</code> | <code>detached</code>).</p> </li> <li> <p> <code>attachment.vpc-id</code> - The ID of an attached VPC.</p> </li> <li> <p> <code>availability-zone</code> - The Availability Zone for the virtual private gateway (if applicable).</p> </li> <li> <p> <code>state</code> - The state of the virtual private gateway (<code>pending</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code>).</p> </li> <li> <p> <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> </li> <li> <p> <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p> </li> <li> <p> <code>type</code> - The type of virtual private gateway. Currently the only supported type is <code>ipsec.1</code>.</p> </li> <li> <p> <code>vpn-gateway-id</code> - The ID of the virtual private gateway.</p> </li> </ul>', 'ExportTransitGatewayRoutesRequest$Filters' => '<p>One or more filters. The possible values are:</p> <ul> <li> <p> <code>attachment.transit-gateway-attachment-id</code> - The id of the transit gateway attachment.</p> </li> <li> <p> <code>attachment.resource-id</code> - The resource id of the transit gateway attachment.</p> </li> <li> <p> <code>route-search.exact-match</code> - The exact match of the specified filter.</p> </li> <li> <p> <code>route-search.longest-prefix-match</code> - The longest prefix that matches the route.</p> </li> <li> <p> <code>route-search.subnet-of-match</code> - The routes with a subnet that match the specified CIDR filter.</p> </li> <li> <p> <code>route-search.supernet-of-match</code> - The routes with a CIDR that encompass the CIDR filter. For example, if you have 10.0.1.0/29 and 10.0.1.0/31 routes in your route table and you specify supernet-of-match as 10.0.1.0/30, then the result returns 10.0.1.0/29.</p> </li> <li> <p> <code>state</code> - The state of the attachment (<code>available</code> | <code>deleted</code> | <code>deleting</code> | <code>failed</code> | <code>modifying</code> | <code>pendingAcceptance</code> | <code>pending</code> | <code>rollingBack</code> | <code>rejected</code> | <code>rejecting</code>).</p> </li> <li> <p> <code>transit-gateway-route-destination-cidr-block</code> - The CIDR range.</p> </li> <li> <p> <code>type</code> - The type of route (<code>active</code> | <code>blackhole</code>).</p> </li> </ul>', 'GetCoipPoolUsageRequest$Filters' => '<p>The filters. The following are the possible values:</p> <ul> <li> <p> <code>coip-address-usage.allocation-id</code> </p> </li> </ul> <ul> <li> <p> <code>coip-address-usage.aws-account-id</code> </p> </li> </ul> <ul> <li> <p> <code>coip-address-usage.aws-service</code> </p> </li> </ul> <ul> <li> <p> <code>coip-address-usage.co-ip</code> </p> </li> </ul>', 'GetTransitGatewayAttachmentPropagationsRequest$Filters' => '<p>One or more filters. The possible values are:</p> <ul> <li> <p> <code>transit-gateway-route-table-id</code> - The ID of the transit gateway route table.</p> </li> </ul>', 'GetTransitGatewayMulticastDomainAssociationsRequest$Filters' => '<p>One or more filters. The possible values are:</p> <ul> <li> <p> <code>resource-id</code> - The ID of the resource.</p> </li> <li> <p> <code>resource-type</code> - The type of resource. The valid value is: <code>vpc</code>.</p> </li> <li> <p> <code>state</code> - The state of the subnet association. Valid values are <code>associated</code> | <code>associating</code> | <code>disassociated</code> | <code>disassociating</code>.</p> </li> <li> <p> <code>subnet-id</code> - The ID of the subnet.</p> </li> <li> <p> <code>transit-gateway-attachment-id</code> - The id of the transit gateway attachment.</p> </li> </ul>', 'GetTransitGatewayRouteTableAssociationsRequest$Filters' => '<p>One or more filters. The possible values are:</p> <ul> <li> <p> <code>resource-id</code> - The ID of the resource.</p> </li> <li> <p> <code>resource-type</code> - The resource type (<code>vpc</code> | <code>vpn</code>).</p> </li> <li> <p> <code>transit-gateway-attachment-id</code> - The ID of the attachment.</p> </li> </ul>', 'GetTransitGatewayRouteTablePropagationsRequest$Filters' => '<p>One or more filters. The possible values are:</p> <ul> <li> <p> <code>resource-id</code> - The ID of the resource.</p> </li> <li> <p> <code>resource-type</code> - The resource type (<code>vpc</code> | <code>vpn</code>).</p> </li> <li> <p> <code>transit-gateway-attachment-id</code> - The ID of the attachment.</p> </li> </ul>', 'SearchLocalGatewayRoutesRequest$Filters' => '<p>One or more filters.</p>', 'SearchTransitGatewayMulticastGroupsRequest$Filters' => '<p>One or more filters. The possible values are:</p> <ul> <li> <p> <code>group-ip-address</code> - The IP address of the transit gateway multicast group.</p> </li> <li> <p> <code>is-group-member</code> - The resource is a group member. Valid values are <code>true</code> | <code>false</code>.</p> </li> <li> <p> <code>is-group-source</code> - The resource is a group source. Valid values are <code>true</code> | <code>false</code>.</p> </li> <li> <p> <code>member-type</code> - The member type. Valid values are <code>igmp</code> | <code>static</code>.</p> </li> <li> <p> <code>resource-id</code> - The ID of the resource.</p> </li> <li> <p> <code>resource-type</code> - The type of resource. Valid values are <code>vpc</code> | <code>vpn</code> | <code>direct-connect-gateway</code> | <code>tgw-peering</code>.</p> </li> <li> <p> <code>source-type</code> - The source type. Valid values are <code>igmp</code> | <code>static</code>.</p> </li> <li> <p> <code>state</code> - The state of the subnet association. Valid values are <code>associated</code> | <code>associated</code> | <code>disassociated</code> | <code>disassociating</code>.</p> </li> <li> <p> <code>subnet-id</code> - The ID of the subnet.</p> </li> <li> <p> <code>transit-gateway-attachment-id</code> - The id of the transit gateway attachment.</p> </li> </ul>', 'SearchTransitGatewayRoutesRequest$Filters' => '<p>One or more filters. The possible values are:</p> <ul> <li> <p> <code>attachment.transit-gateway-attachment-id</code>- The id of the transit gateway attachment.</p> </li> <li> <p> <code>attachment.resource-id</code> - The resource id of the transit gateway attachment.</p> </li> <li> <p> <code>attachment.resource-type</code> - The attachment resource type (<code>vpc</code> | <code>vpn</code>).</p> </li> <li> <p> <code>route-search.exact-match</code> - The exact match of the specified filter.</p> </li> <li> <p> <code>route-search.longest-prefix-match</code> - The longest prefix that matches the route.</p> </li> <li> <p> <code>route-search.subnet-of-match</code> - The routes with a subnet that match the specified CIDR filter.</p> </li> <li> <p> <code>route-search.supernet-of-match</code> - The routes with a CIDR that encompass the CIDR filter. For example, if you have 10.0.1.0/29 and 10.0.1.0/31 routes in your route table and you specify supernet-of-match as 10.0.1.0/30, then the result returns 10.0.1.0/29.</p> </li> <li> <p> <code>state</code> - The state of the route (<code>active</code> | <code>blackhole</code>).</p> </li> <li> <p> <code>type</code> - The type of route (<code>propagated</code> | <code>static</code>).</p> </li> </ul>', ], ], 'FleetActivityStatus' => [ 'base' => NULL, 'refs' => [ 'FleetData$ActivityStatus' => '<p>The progress of the EC2 Fleet. If there is an error, the status is <code>error</code>. After all requests are placed, the status is <code>pending_fulfillment</code>. If the size of the EC2 Fleet is equal to or greater than its target capacity, the status is <code>fulfilled</code>. If the size of the EC2 Fleet is decreased, the status is <code>pending_termination</code> while instances are terminating.</p>', ], ], 'FleetCapacityReservationUsageStrategy' => [ 'base' => NULL, 'refs' => [ 'CapacityReservationOptions$UsageStrategy' => '<p>Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity.</p> <p>If you specify <code>use-capacity-reservations-first</code>, the fleet uses unused Capacity Reservations to fulfill On-Demand capacity up to the target On-Demand capacity. If multiple instance pools have unused Capacity Reservations, the On-Demand allocation strategy (<code>lowest-price</code> or <code>prioritized</code>) is applied. If the number of unused Capacity Reservations is less than the On-Demand target capacity, the remaining On-Demand target capacity is launched according to the On-Demand allocation strategy (<code>lowest-price</code> or <code>prioritized</code>).</p> <p>If you do not specify a value, the fleet fulfils the On-Demand capacity according to the chosen On-Demand allocation strategy.</p>', 'CapacityReservationOptionsRequest$UsageStrategy' => '<p>Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity.</p> <p>If you specify <code>use-capacity-reservations-first</code>, the fleet uses unused Capacity Reservations to fulfill On-Demand capacity up to the target On-Demand capacity. If multiple instance pools have unused Capacity Reservations, the On-Demand allocation strategy (<code>lowest-price</code> or <code>prioritized</code>) is applied. If the number of unused Capacity Reservations is less than the On-Demand target capacity, the remaining On-Demand target capacity is launched according to the On-Demand allocation strategy (<code>lowest-price</code> or <code>prioritized</code>).</p> <p>If you do not specify a value, the fleet fulfils the On-Demand capacity according to the chosen On-Demand allocation strategy.</p>', ], ], 'FleetData' => [ 'base' => '<p>Describes an EC2 Fleet.</p>', 'refs' => [ 'FleetSet$member' => NULL, ], ], 'FleetEventType' => [ 'base' => NULL, 'refs' => [ 'DescribeFleetHistoryRequest$EventType' => '<p>The type of events to describe. By default, all events are described.</p>', 'HistoryRecordEntry$EventType' => '<p>The event type.</p>', ], ], 'FleetExcessCapacityTerminationPolicy' => [ 'base' => NULL, 'refs' => [ 'CreateFleetRequest$ExcessCapacityTerminationPolicy' => '<p>Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2 Fleet.</p>', 'FleetData$ExcessCapacityTerminationPolicy' => '<p>Indicates whether running instances should be terminated if the target capacity of the EC2 Fleet is decreased below the current size of the EC2 Fleet.</p>', 'ModifyFleetRequest$ExcessCapacityTerminationPolicy' => '<p>Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2 Fleet.</p>', ], ], 'FleetId' => [ 'base' => NULL, 'refs' => [ 'CreateFleetResult$FleetId' => '<p>The ID of the EC2 Fleet.</p>', 'DeleteFleetErrorItem$FleetId' => '<p>The ID of the EC2 Fleet.</p>', 'DeleteFleetSuccessItem$FleetId' => '<p>The ID of the EC2 Fleet.</p>', 'DescribeFleetHistoryRequest$FleetId' => '<p>The ID of the EC2 Fleet.</p>', 'DescribeFleetHistoryResult$FleetId' => '<p>The ID of the EC Fleet.</p>', 'DescribeFleetInstancesRequest$FleetId' => '<p>The ID of the EC2 Fleet.</p>', 'DescribeFleetInstancesResult$FleetId' => '<p>The ID of the EC2 Fleet.</p>', 'FleetData$FleetId' => '<p>The ID of the EC2 Fleet.</p>', 'FleetIdSet$member' => NULL, 'ModifyFleetRequest$FleetId' => '<p>The ID of the EC2 Fleet.</p>', ], ], 'FleetIdSet' => [ 'base' => NULL, 'refs' => [ 'DeleteFleetsRequest$FleetIds' => '<p>The IDs of the EC2 Fleets.</p>', 'DescribeFleetsRequest$FleetIds' => '<p>The ID of the EC2 Fleets.</p>', ], ], 'FleetLaunchTemplateConfig' => [ 'base' => '<p>Describes a launch template and overrides.</p>', 'refs' => [ 'FleetLaunchTemplateConfigList$member' => NULL, ], ], 'FleetLaunchTemplateConfigList' => [ 'base' => NULL, 'refs' => [ 'FleetData$LaunchTemplateConfigs' => '<p>The launch template and overrides.</p>', ], ], 'FleetLaunchTemplateConfigListRequest' => [ 'base' => NULL, 'refs' => [ 'CreateFleetRequest$LaunchTemplateConfigs' => '<p>The configuration for the EC2 Fleet.</p>', ], ], 'FleetLaunchTemplateConfigRequest' => [ 'base' => '<p>Describes a launch template and overrides.</p>', 'refs' => [ 'FleetLaunchTemplateConfigListRequest$member' => NULL, ], ], 'FleetLaunchTemplateOverrides' => [ 'base' => '<p>Describes overrides for a launch template.</p>', 'refs' => [ 'FleetLaunchTemplateOverridesList$member' => NULL, 'LaunchTemplateAndOverridesResponse$Overrides' => '<p>Any parameters that you specify override the same parameters in the launch template.</p>', ], ], 'FleetLaunchTemplateOverridesList' => [ 'base' => NULL, 'refs' => [ 'FleetLaunchTemplateConfig$Overrides' => '<p>Any parameters that you specify override the same parameters in the launch template.</p>', ], ], 'FleetLaunchTemplateOverridesListRequest' => [ 'base' => NULL, 'refs' => [ 'FleetLaunchTemplateConfigRequest$Overrides' => '<p>Any parameters that you specify override the same parameters in the launch template.</p>', ], ], 'FleetLaunchTemplateOverridesRequest' => [ 'base' => '<p>Describes overrides for a launch template.</p>', 'refs' => [ 'FleetLaunchTemplateOverridesListRequest$member' => NULL, ], ], 'FleetLaunchTemplateSpecification' => [ 'base' => '<p>Describes the Amazon EC2 launch template and the launch template version that can be used by a Spot Fleet request to configure Amazon EC2 instances. For information about launch templates, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Launching an instance from a launch template</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>', 'refs' => [ 'FleetLaunchTemplateConfig$LaunchTemplateSpecification' => '<p>The launch template.</p>', 'LaunchTemplateAndOverridesResponse$LaunchTemplateSpecification' => '<p>The launch template.</p>', 'LaunchTemplateConfig$LaunchTemplateSpecification' => '<p>The launch template.</p>', ], ], 'FleetLaunchTemplateSpecificationRequest' => [ 'base' => '<p>Describes the Amazon EC2 launch template and the launch template version that can be used by an EC2 Fleet to configure Amazon EC2 instances. For information about launch templates, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Launching an instance from a launch template</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'refs' => [ 'FleetLaunchTemplateConfigRequest$LaunchTemplateSpecification' => '<p>The launch template to use. You must specify either the launch template ID or launch template name in the request. </p>', ], ], 'FleetOnDemandAllocationStrategy' => [ 'base' => NULL, 'refs' => [ 'OnDemandOptions$AllocationStrategy' => '<p>The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify <code>lowest-price</code>, EC2 Fleet uses price to determine the order, launching the lowest price first. If you specify <code>prioritized</code>, EC2 Fleet uses the priority that you assigned to each launch template override, launching the highest priority first. If you do not specify a value, EC2 Fleet defaults to <code>lowest-price</code>.</p>', 'OnDemandOptionsRequest$AllocationStrategy' => '<p>The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify <code>lowest-price</code>, EC2 Fleet uses price to determine the order, launching the lowest price first. If you specify <code>prioritized</code>, EC2 Fleet uses the priority that you assigned to each launch template override, launching the highest priority first. If you do not specify a value, EC2 Fleet defaults to <code>lowest-price</code>.</p>', ], ], 'FleetSet' => [ 'base' => NULL, 'refs' => [ 'DescribeFleetsResult$Fleets' => '<p>Information about the EC2 Fleets.</p>', ], ], 'FleetStateCode' => [ 'base' => NULL, 'refs' => [ 'DeleteFleetSuccessItem$CurrentFleetState' => '<p>The current state of the EC2 Fleet.</p>', 'DeleteFleetSuccessItem$PreviousFleetState' => '<p>The previous state of the EC2 Fleet.</p>', 'FleetData$FleetState' => '<p>The state of the EC2 Fleet.</p>', ], ], 'FleetType' => [ 'base' => NULL, 'refs' => [ 'CreateFleetRequest$Type' => '<p>The type of the request. By default, the EC2 Fleet places an asynchronous request for your desired capacity, and maintains it by replenishing interrupted Spot Instances (<code>maintain</code>). A value of <code>instant</code> places a synchronous one-time request, and returns errors for any instances that could not be launched. A value of <code>request</code> places an asynchronous one-time request without maintaining capacity or submitting requests in alternative capacity pools if capacity is unavailable. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-configuration-strategies.html#ec2-fleet-request-type">EC2 Fleet Request Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'FleetData$Type' => '<p>The type of request. Indicates whether the EC2 Fleet only <code>requests</code> the target capacity, or also attempts to <code>maintain</code> it. If you request a certain target capacity, EC2 Fleet only places the required requests; it does not attempt to replenish instances if capacity is diminished, and it does not submit requests in alternative capacity pools if capacity is unavailable. To maintain a certain target capacity, EC2 Fleet places the required requests to meet this target capacity. It also automatically replenishes any interrupted Spot Instances. Default: <code>maintain</code>.</p>', 'SpotFleetRequestConfigData$Type' => '<p>The type of request. Indicates whether the Spot Fleet only requests the target capacity or also attempts to maintain it. When this value is <code>request</code>, the Spot Fleet only places the required requests. It does not attempt to replenish Spot Instances if capacity is diminished, nor does it submit requests in alternative Spot pools if capacity is not available. When this value is <code>maintain</code>, the Spot Fleet maintains the target capacity. The Spot Fleet places the required requests to meet capacity and automatically replenishes any interrupted instances. Default: <code>maintain</code>. <code>instant</code> is listed but is not used by Spot Fleet.</p>', ], ], 'Float' => [ 'base' => NULL, 'refs' => [ 'ReservedInstances$FixedPrice' => '<p>The purchase price of the Reserved Instance.</p>', 'ReservedInstances$UsagePrice' => '<p>The usage price of the Reserved Instance, per hour.</p>', 'ReservedInstancesOffering$FixedPrice' => '<p>The purchase price of the Reserved Instance.</p>', 'ReservedInstancesOffering$UsagePrice' => '<p>The usage price of the Reserved Instance, per hour.</p>', ], ], 'FlowLog' => [ 'base' => '<p>Describes a flow log.</p>', 'refs' => [ 'FlowLogSet$member' => NULL, ], ], 'FlowLogIdList' => [ 'base' => NULL, 'refs' => [ 'DeleteFlowLogsRequest$FlowLogIds' => '<p>One or more flow log IDs.</p> <p>Constraint: Maximum of 1000 flow log IDs.</p>', 'DescribeFlowLogsRequest$FlowLogIds' => '<p>One or more flow log IDs.</p> <p>Constraint: Maximum of 1000 flow log IDs.</p>', ], ], 'FlowLogResourceId' => [ 'base' => NULL, 'refs' => [ 'FlowLogResourceIds$member' => NULL, ], ], 'FlowLogResourceIds' => [ 'base' => NULL, 'refs' => [ 'CreateFlowLogsRequest$ResourceIds' => '<p>The ID of the subnet, network interface, or VPC for which you want to create a flow log.</p> <p>Constraints: Maximum of 1000 resources</p>', ], ], 'FlowLogSet' => [ 'base' => NULL, 'refs' => [ 'DescribeFlowLogsResult$FlowLogs' => '<p>Information about the flow logs.</p>', ], ], 'FlowLogsResourceType' => [ 'base' => NULL, 'refs' => [ 'CreateFlowLogsRequest$ResourceType' => '<p>The type of resource for which to create the flow log. For example, if you specified a VPC ID for the <code>ResourceId</code> property, specify <code>VPC</code> for this property.</p>', ], ], 'FpgaDeviceCount' => [ 'base' => NULL, 'refs' => [ 'FpgaDeviceInfo$Count' => '<p>The count of FPGA accelerators for the instance type.</p>', ], ], 'FpgaDeviceInfo' => [ 'base' => '<p>Describes the FPGA accelerator for the instance type.</p>', 'refs' => [ 'FpgaDeviceInfoList$member' => NULL, ], ], 'FpgaDeviceInfoList' => [ 'base' => NULL, 'refs' => [ 'FpgaInfo$Fpgas' => '<p>Describes the FPGAs for the instance type.</p>', ], ], 'FpgaDeviceManufacturerName' => [ 'base' => NULL, 'refs' => [ 'FpgaDeviceInfo$Manufacturer' => '<p>The manufacturer of the FPGA accelerator.</p>', ], ], 'FpgaDeviceMemoryInfo' => [ 'base' => '<p>Describes the memory for the FPGA accelerator for the instance type.</p>', 'refs' => [ 'FpgaDeviceInfo$MemoryInfo' => '<p>Describes the memory for the FPGA accelerator for the instance type.</p>', ], ], 'FpgaDeviceMemorySize' => [ 'base' => NULL, 'refs' => [ 'FpgaDeviceMemoryInfo$SizeInMiB' => '<p>The size (in MiB) for the memory available to the FPGA accelerator.</p>', ], ], 'FpgaDeviceName' => [ 'base' => NULL, 'refs' => [ 'FpgaDeviceInfo$Name' => '<p>The name of the FPGA accelerator.</p>', ], ], 'FpgaImage' => [ 'base' => '<p>Describes an Amazon FPGA image (AFI).</p>', 'refs' => [ 'FpgaImageList$member' => NULL, ], ], 'FpgaImageAttribute' => [ 'base' => '<p>Describes an Amazon FPGA image (AFI) attribute.</p>', 'refs' => [ 'DescribeFpgaImageAttributeResult$FpgaImageAttribute' => '<p>Information about the attribute.</p>', 'ModifyFpgaImageAttributeResult$FpgaImageAttribute' => '<p>Information about the attribute.</p>', ], ], 'FpgaImageAttributeName' => [ 'base' => NULL, 'refs' => [ 'DescribeFpgaImageAttributeRequest$Attribute' => '<p>The AFI attribute.</p>', 'ModifyFpgaImageAttributeRequest$Attribute' => '<p>The name of the attribute.</p>', ], ], 'FpgaImageId' => [ 'base' => NULL, 'refs' => [ 'DeleteFpgaImageRequest$FpgaImageId' => '<p>The ID of the AFI.</p>', 'DescribeFpgaImageAttributeRequest$FpgaImageId' => '<p>The ID of the AFI.</p>', 'FpgaImageIdList$member' => NULL, 'ModifyFpgaImageAttributeRequest$FpgaImageId' => '<p>The ID of the AFI.</p>', 'ResetFpgaImageAttributeRequest$FpgaImageId' => '<p>The ID of the AFI.</p>', ], ], 'FpgaImageIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeFpgaImagesRequest$FpgaImageIds' => '<p>The AFI IDs.</p>', ], ], 'FpgaImageList' => [ 'base' => NULL, 'refs' => [ 'DescribeFpgaImagesResult$FpgaImages' => '<p>Information about the FPGA images.</p>', ], ], 'FpgaImageState' => [ 'base' => '<p>Describes the state of the bitstream generation process for an Amazon FPGA image (AFI).</p>', 'refs' => [ 'FpgaImage$State' => '<p>Information about the state of the AFI.</p>', ], ], 'FpgaImageStateCode' => [ 'base' => NULL, 'refs' => [ 'FpgaImageState$Code' => '<p>The state. The following are the possible values:</p> <ul> <li> <p> <code>pending</code> - AFI bitstream generation is in progress.</p> </li> <li> <p> <code>available</code> - The AFI is available for use.</p> </li> <li> <p> <code>failed</code> - AFI bitstream generation failed.</p> </li> <li> <p> <code>unavailable</code> - The AFI is no longer available for use.</p> </li> </ul>', ], ], 'FpgaInfo' => [ 'base' => '<p>Describes the FPGAs for the instance type.</p>', 'refs' => [ 'InstanceTypeInfo$FpgaInfo' => '<p>Describes the FPGA accelerator settings for the instance type.</p>', ], ], 'FreeTierEligibleFlag' => [ 'base' => NULL, 'refs' => [ 'InstanceTypeInfo$FreeTierEligible' => '<p>Indicates whether the instance type is eligible for the free tier.</p>', ], ], 'GatewayType' => [ 'base' => NULL, 'refs' => [ 'CreateCustomerGatewayRequest$Type' => '<p>The type of VPN connection that this customer gateway supports (<code>ipsec.1</code>).</p>', 'CreateVpnGatewayRequest$Type' => '<p>The type of VPN connection this virtual private gateway supports.</p>', 'VpnConnection$Type' => '<p>The type of VPN connection.</p>', 'VpnGateway$Type' => '<p>The type of VPN connection the virtual private gateway supports.</p>', ], ], 'GetAssociatedIpv6PoolCidrsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAssociatedIpv6PoolCidrsResult' => [ 'base' => NULL, 'refs' => [], ], 'GetCapacityReservationUsageRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCapacityReservationUsageRequestMaxResults' => [ 'base' => NULL, 'refs' => [ 'GetCapacityReservationUsageRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.</p> <p>Valid range: Minimum value of 1. Maximum value of 1000.</p>', ], ], 'GetCapacityReservationUsageResult' => [ 'base' => NULL, 'refs' => [], ], 'GetCoipPoolUsageRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCoipPoolUsageResult' => [ 'base' => NULL, 'refs' => [], ], 'GetConsoleOutputRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetConsoleOutputResult' => [ 'base' => NULL, 'refs' => [], ], 'GetConsoleScreenshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetConsoleScreenshotResult' => [ 'base' => NULL, 'refs' => [], ], 'GetDefaultCreditSpecificationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDefaultCreditSpecificationResult' => [ 'base' => NULL, 'refs' => [], ], 'GetEbsDefaultKmsKeyIdRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEbsDefaultKmsKeyIdResult' => [ 'base' => NULL, 'refs' => [], ], 'GetEbsEncryptionByDefaultRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEbsEncryptionByDefaultResult' => [ 'base' => NULL, 'refs' => [], ], 'GetGroupsForCapacityReservationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetGroupsForCapacityReservationRequestMaxResults' => [ 'base' => NULL, 'refs' => [ 'GetGroupsForCapacityReservationRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.</p>', ], ], 'GetGroupsForCapacityReservationResult' => [ 'base' => NULL, 'refs' => [], ], 'GetHostReservationPurchasePreviewRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetHostReservationPurchasePreviewResult' => [ 'base' => NULL, 'refs' => [], ], 'GetLaunchTemplateDataRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLaunchTemplateDataResult' => [ 'base' => NULL, 'refs' => [], ], 'GetManagedPrefixListAssociationsMaxResults' => [ 'base' => NULL, 'refs' => [ 'GetManagedPrefixListAssociationsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'GetManagedPrefixListAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetManagedPrefixListAssociationsResult' => [ 'base' => NULL, 'refs' => [], ], 'GetManagedPrefixListEntriesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetManagedPrefixListEntriesResult' => [ 'base' => NULL, 'refs' => [], ], 'GetPasswordDataRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPasswordDataResult' => [ 'base' => NULL, 'refs' => [], ], 'GetReservedInstancesExchangeQuoteRequest' => [ 'base' => '<p>Contains the parameters for GetReservedInstanceExchangeQuote.</p>', 'refs' => [], ], 'GetReservedInstancesExchangeQuoteResult' => [ 'base' => '<p>Contains the output of GetReservedInstancesExchangeQuote.</p>', 'refs' => [], ], 'GetTransitGatewayAttachmentPropagationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTransitGatewayAttachmentPropagationsResult' => [ 'base' => NULL, 'refs' => [], ], 'GetTransitGatewayMulticastDomainAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTransitGatewayMulticastDomainAssociationsResult' => [ 'base' => NULL, 'refs' => [], ], 'GetTransitGatewayRouteTableAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTransitGatewayRouteTableAssociationsResult' => [ 'base' => NULL, 'refs' => [], ], 'GetTransitGatewayRouteTablePropagationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTransitGatewayRouteTablePropagationsResult' => [ 'base' => NULL, 'refs' => [], ], 'GpuDeviceCount' => [ 'base' => NULL, 'refs' => [ 'GpuDeviceInfo$Count' => '<p>The number of GPUs for the instance type.</p>', ], ], 'GpuDeviceInfo' => [ 'base' => '<p>Describes the GPU accelerators for the instance type.</p>', 'refs' => [ 'GpuDeviceInfoList$member' => NULL, ], ], 'GpuDeviceInfoList' => [ 'base' => NULL, 'refs' => [ 'GpuInfo$Gpus' => '<p>Describes the GPU accelerators for the instance type.</p>', ], ], 'GpuDeviceManufacturerName' => [ 'base' => NULL, 'refs' => [ 'GpuDeviceInfo$Manufacturer' => '<p>The manufacturer of the GPU accelerator.</p>', ], ], 'GpuDeviceMemoryInfo' => [ 'base' => '<p>Describes the memory available to the GPU accelerator.</p>', 'refs' => [ 'GpuDeviceInfo$MemoryInfo' => '<p>Describes the memory available to the GPU accelerator.</p>', ], ], 'GpuDeviceMemorySize' => [ 'base' => NULL, 'refs' => [ 'GpuDeviceMemoryInfo$SizeInMiB' => '<p>The size (in MiB) for the memory available to the GPU accelerator.</p>', ], ], 'GpuDeviceName' => [ 'base' => NULL, 'refs' => [ 'GpuDeviceInfo$Name' => '<p>The name of the GPU accelerator.</p>', ], ], 'GpuInfo' => [ 'base' => '<p>Describes the GPU accelerators for the instance type.</p>', 'refs' => [ 'InstanceTypeInfo$GpuInfo' => '<p>Describes the GPU accelerator settings for the instance type.</p>', ], ], 'GroupIdStringList' => [ 'base' => NULL, 'refs' => [ 'AttachClassicLinkVpcRequest$Groups' => '<p>The ID of one or more of the VPC\'s security groups. You cannot specify security groups from a different VPC.</p>', 'DescribeSecurityGroupsRequest$GroupIds' => '<p>The IDs of the security groups. Required for security groups in a nondefault VPC.</p> <p>Default: Describes all your security groups.</p>', 'LaunchTemplateInstanceNetworkInterfaceSpecification$Groups' => '<p>The IDs of one or more security groups.</p>', 'ModifyInstanceAttributeRequest$Groups' => '<p>[EC2-VPC] Changes the security groups of the instance. You must specify at least one security group, even if it\'s just the default security group for the VPC. You must specify the security group ID, not the security group name.</p>', ], ], 'GroupIdentifier' => [ 'base' => '<p>Describes a security group.</p>', 'refs' => [ 'GroupIdentifierList$member' => NULL, ], ], 'GroupIdentifierList' => [ 'base' => NULL, 'refs' => [ 'ClassicLinkInstance$Groups' => '<p>A list of security groups.</p>', 'DescribeNetworkInterfaceAttributeResult$Groups' => '<p>The security groups associated with the network interface.</p>', 'Instance$SecurityGroups' => '<p>The security groups for the instance.</p>', 'InstanceAttribute$Groups' => '<p>The security groups associated with the instance.</p>', 'InstanceNetworkInterface$Groups' => '<p>One or more security groups.</p>', 'LaunchSpecification$SecurityGroups' => '<p>One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security groups.</p>', 'NetworkInterface$Groups' => '<p>Any security groups for the network interface.</p>', 'Reservation$Groups' => '<p>[EC2-Classic only] The security groups.</p>', 'SpotFleetLaunchSpecification$SecurityGroups' => '<p>One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security groups.</p>', ], ], 'GroupIdentifierSet' => [ 'base' => NULL, 'refs' => [ 'VpcEndpoint$Groups' => '<p>(Interface endpoint) Information about the security groups that are associated with the network interface.</p>', ], ], 'GroupIds' => [ 'base' => NULL, 'refs' => [ 'DescribeSecurityGroupReferencesRequest$GroupId' => '<p>The IDs of the security groups in your account.</p>', ], ], 'GroupNameStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeSecurityGroupsRequest$GroupNames' => '<p>[EC2-Classic and default VPC only] The names of the security groups. You can specify either the security group name or the security group ID. For security groups in a nondefault VPC, use the <code>group-name</code> filter to describe security groups by name.</p> <p>Default: Describes all your security groups.</p>', 'ModifySnapshotAttributeRequest$GroupNames' => '<p>The group to modify for the snapshot.</p>', ], ], 'HibernationFlag' => [ 'base' => NULL, 'refs' => [ 'InstanceTypeInfo$HibernationSupported' => '<p>Indicates whether On-Demand hibernation is supported.</p>', ], ], 'HibernationOptions' => [ 'base' => '<p>Indicates whether your instance is configured for hibernation. This parameter is valid only if the instance meets the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites">hibernation prerequisites</a>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'refs' => [ 'Instance$HibernationOptions' => '<p>Indicates whether the instance is enabled for hibernation.</p>', ], ], 'HibernationOptionsRequest' => [ 'base' => '<p>Indicates whether your instance is configured for hibernation. This parameter is valid only if the instance meets the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites">hibernation prerequisites</a>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'refs' => [ 'RunInstancesRequest$HibernationOptions' => '<p>Indicates whether an instance is enabled for hibernation. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your instance</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', ], ], 'HistoryRecord' => [ 'base' => '<p>Describes an event in the history of the Spot Fleet request.</p>', 'refs' => [ 'HistoryRecords$member' => NULL, ], ], 'HistoryRecordEntry' => [ 'base' => '<p>Describes an event in the history of an EC2 Fleet.</p>', 'refs' => [ 'HistoryRecordSet$member' => NULL, ], ], 'HistoryRecordSet' => [ 'base' => NULL, 'refs' => [ 'DescribeFleetHistoryResult$HistoryRecords' => '<p>Information about the events in the history of the EC2 Fleet.</p>', ], ], 'HistoryRecords' => [ 'base' => NULL, 'refs' => [ 'DescribeSpotFleetRequestHistoryResponse$HistoryRecords' => '<p>Information about the events in the history of the Spot Fleet request.</p>', ], ], 'Host' => [ 'base' => '<p>Describes the properties of the Dedicated Host.</p>', 'refs' => [ 'HostList$member' => NULL, ], ], 'HostInstance' => [ 'base' => '<p>Describes an instance running on a Dedicated Host.</p>', 'refs' => [ 'HostInstanceList$member' => NULL, ], ], 'HostInstanceList' => [ 'base' => NULL, 'refs' => [ 'Host$Instances' => '<p>The IDs and instance type that are currently running on the Dedicated Host.</p>', ], ], 'HostList' => [ 'base' => NULL, 'refs' => [ 'DescribeHostsResult$Hosts' => '<p>Information about the Dedicated Hosts.</p>', ], ], 'HostOffering' => [ 'base' => '<p>Details about the Dedicated Host Reservation offering.</p>', 'refs' => [ 'HostOfferingSet$member' => NULL, ], ], 'HostOfferingSet' => [ 'base' => NULL, 'refs' => [ 'DescribeHostReservationOfferingsResult$OfferingSet' => '<p>Information about the offerings.</p>', ], ], 'HostProperties' => [ 'base' => '<p>Describes the properties of a Dedicated Host.</p>', 'refs' => [ 'Host$HostProperties' => '<p>The hardware specifications of the Dedicated Host.</p>', ], ], 'HostRecovery' => [ 'base' => NULL, 'refs' => [ 'AllocateHostsRequest$HostRecovery' => '<p>Indicates whether to enable or disable host recovery for the Dedicated Host. Host recovery is disabled by default. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html"> Host Recovery</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>Default: <code>off</code> </p>', 'Host$HostRecovery' => '<p>Indicates whether host recovery is enabled or disabled for the Dedicated Host.</p>', 'ModifyHostsRequest$HostRecovery' => '<p>Indicates whether to enable or disable host recovery for the Dedicated Host. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html"> Host Recovery</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', ], ], 'HostReservation' => [ 'base' => '<p>Details about the Dedicated Host Reservation and associated Dedicated Hosts.</p>', 'refs' => [ 'HostReservationSet$member' => NULL, ], ], 'HostReservationId' => [ 'base' => NULL, 'refs' => [ 'HostReservationIdSet$member' => NULL, ], ], 'HostReservationIdSet' => [ 'base' => NULL, 'refs' => [ 'DescribeHostReservationsRequest$HostReservationIdSet' => '<p>The host reservation IDs.</p>', ], ], 'HostReservationSet' => [ 'base' => NULL, 'refs' => [ 'DescribeHostReservationsResult$HostReservationSet' => '<p>Details about the reservation\'s configuration.</p>', ], ], 'HostTenancy' => [ 'base' => NULL, 'refs' => [ 'ModifyInstancePlacementRequest$Tenancy' => '<p>The tenancy for the instance.</p>', ], ], 'HttpTokensState' => [ 'base' => NULL, 'refs' => [ 'InstanceMetadataOptionsRequest$HttpTokens' => '<p>The state of token usage for your instance metadata requests. If the parameter is not specified in the request, the default state is <code>optional</code>.</p> <p>If the state is <code>optional</code>, you can choose to retrieve instance metadata with or without a signed token header on your request. If you retrieve the IAM role credentials without a token, the version 1.0 role credentials are returned. If you retrieve the IAM role credentials using a valid signed token, the version 2.0 role credentials are returned.</p> <p>If the state is <code>required</code>, you must send a signed token header with any instance metadata retrieval requests. In this state, retrieving the IAM role credentials always returns the version 2.0 credentials; the version 1.0 credentials are not available.</p>', 'InstanceMetadataOptionsResponse$HttpTokens' => '<p>The state of token usage for your instance metadata requests. If the parameter is not specified in the request, the default state is <code>optional</code>.</p> <p>If the state is <code>optional</code>, you can choose to retrieve instance metadata with or without a signed token header on your request. If you retrieve the IAM role credentials without a token, the version 1.0 role credentials are returned. If you retrieve the IAM role credentials using a valid signed token, the version 2.0 role credentials are returned.</p> <p>If the state is <code>required</code>, you must send a signed token header with any instance metadata retrieval requests. In this state, retrieving the IAM role credential always returns the version 2.0 credentials; the version 1.0 credentials are not available.</p>', 'ModifyInstanceMetadataOptionsRequest$HttpTokens' => '<p>The state of token usage for your instance metadata requests. If the parameter is not specified in the request, the default state is <code>optional</code>.</p> <p>If the state is <code>optional</code>, you can choose to retrieve instance metadata with or without a signed token header on your request. If you retrieve the IAM role credentials without a token, the version 1.0 role credentials are returned. If you retrieve the IAM role credentials using a valid signed token, the version 2.0 role credentials are returned.</p> <p>If the state is <code>required</code>, you must send a signed token header with any instance metadata retrieval requests. In this state, retrieving the IAM role credential always returns the version 2.0 credentials; the version 1.0 credentials are not available.</p>', ], ], 'HypervisorType' => [ 'base' => NULL, 'refs' => [ 'Image$Hypervisor' => '<p>The hypervisor type of the image.</p>', 'Instance$Hypervisor' => '<p>The hypervisor type of the instance. The value <code>xen</code> is used for both Xen and Nitro hypervisors.</p>', ], ], 'IKEVersionsList' => [ 'base' => NULL, 'refs' => [ 'TunnelOption$IkeVersions' => '<p>The IKE versions that are permitted for the VPN tunnel.</p>', ], ], 'IKEVersionsListValue' => [ 'base' => '<p>The internet key exchange (IKE) version permitted for the VPN tunnel.</p>', 'refs' => [ 'IKEVersionsList$member' => NULL, ], ], 'IKEVersionsRequestList' => [ 'base' => NULL, 'refs' => [ 'ModifyVpnTunnelOptionsSpecification$IKEVersions' => '<p>The IKE versions that are permitted for the VPN tunnel.</p> <p>Valid values: <code>ikev1</code> | <code>ikev2</code> </p>', 'VpnTunnelOptionsSpecification$IKEVersions' => '<p>The IKE versions that are permitted for the VPN tunnel.</p> <p>Valid values: <code>ikev1</code> | <code>ikev2</code> </p>', ], ], 'IKEVersionsRequestListValue' => [ 'base' => '<p>The IKE version that is permitted for the VPN tunnel.</p>', 'refs' => [ 'IKEVersionsRequestList$member' => NULL, ], ], 'IamInstanceProfile' => [ 'base' => '<p>Describes an IAM instance profile.</p>', 'refs' => [ 'IamInstanceProfileAssociation$IamInstanceProfile' => '<p>The IAM instance profile.</p>', 'Instance$IamInstanceProfile' => '<p>The IAM instance profile associated with the instance, if applicable.</p>', ], ], 'IamInstanceProfileAssociation' => [ 'base' => '<p>Describes an association between an IAM instance profile and an instance.</p>', 'refs' => [ 'AssociateIamInstanceProfileResult$IamInstanceProfileAssociation' => '<p>Information about the IAM instance profile association.</p>', 'DisassociateIamInstanceProfileResult$IamInstanceProfileAssociation' => '<p>Information about the IAM instance profile association.</p>', 'IamInstanceProfileAssociationSet$member' => NULL, 'ReplaceIamInstanceProfileAssociationResult$IamInstanceProfileAssociation' => '<p>Information about the IAM instance profile association.</p>', ], ], 'IamInstanceProfileAssociationId' => [ 'base' => NULL, 'refs' => [ 'AssociationIdList$member' => NULL, 'DisassociateIamInstanceProfileRequest$AssociationId' => '<p>The ID of the IAM instance profile association.</p>', 'ReplaceIamInstanceProfileAssociationRequest$AssociationId' => '<p>The ID of the existing IAM instance profile association.</p>', ], ], 'IamInstanceProfileAssociationSet' => [ 'base' => NULL, 'refs' => [ 'DescribeIamInstanceProfileAssociationsResult$IamInstanceProfileAssociations' => '<p>Information about the IAM instance profile associations.</p>', ], ], 'IamInstanceProfileAssociationState' => [ 'base' => NULL, 'refs' => [ 'IamInstanceProfileAssociation$State' => '<p>The state of the association.</p>', ], ], 'IamInstanceProfileSpecification' => [ 'base' => '<p>Describes an IAM instance profile.</p>', 'refs' => [ 'AssociateIamInstanceProfileRequest$IamInstanceProfile' => '<p>The IAM instance profile.</p>', 'LaunchSpecification$IamInstanceProfile' => '<p>The IAM instance profile.</p>', 'ReplaceIamInstanceProfileAssociationRequest$IamInstanceProfile' => '<p>The IAM instance profile.</p>', 'RequestSpotLaunchSpecification$IamInstanceProfile' => '<p>The IAM instance profile.</p>', 'RunInstancesRequest$IamInstanceProfile' => '<p>The IAM instance profile.</p>', 'SpotFleetLaunchSpecification$IamInstanceProfile' => '<p>The IAM instance profile.</p>', ], ], 'IcmpTypeCode' => [ 'base' => '<p>Describes the ICMP type and code.</p>', 'refs' => [ 'CreateNetworkAclEntryRequest$IcmpTypeCode' => '<p>ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying protocol 1 (ICMP) or protocol 58 (ICMPv6) with an IPv6 CIDR block.</p>', 'NetworkAclEntry$IcmpTypeCode' => '<p>ICMP protocol: The ICMP type and code.</p>', 'ReplaceNetworkAclEntryRequest$IcmpTypeCode' => '<p>ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying protocol 1 (ICMP) or protocol 58 (ICMPv6) with an IPv6 CIDR block.</p>', ], ], 'IdFormat' => [ 'base' => '<p>Describes the ID format for a resource.</p>', 'refs' => [ 'IdFormatList$member' => NULL, ], ], 'IdFormatList' => [ 'base' => NULL, 'refs' => [ 'DescribeAggregateIdFormatResult$Statuses' => '<p>Information about each resource\'s ID format.</p>', 'DescribeIdFormatResult$Statuses' => '<p>Information about the ID format for the resource.</p>', 'DescribeIdentityIdFormatResult$Statuses' => '<p>Information about the ID format for the resources.</p>', 'PrincipalIdFormat$Statuses' => '<p>PrincipalIdFormatStatuses description</p>', ], ], 'Image' => [ 'base' => '<p>Describes an image.</p>', 'refs' => [ 'ImageList$member' => NULL, ], ], 'ImageAttribute' => [ 'base' => '<p>Describes an image attribute.</p>', 'refs' => [], ], 'ImageAttributeName' => [ 'base' => NULL, 'refs' => [ 'DescribeImageAttributeRequest$Attribute' => '<p>The AMI attribute.</p> <p> <b>Note</b>: Depending on your account privileges, the <code>blockDeviceMapping</code> attribute may return a <code>Client.AuthFailure</code> error. If this happens, use <a>DescribeImages</a> to get information about the block device mapping for the AMI.</p>', ], ], 'ImageDiskContainer' => [ 'base' => '<p>Describes the disk container object for an import image task.</p>', 'refs' => [ 'ImageDiskContainerList$member' => NULL, ], ], 'ImageDiskContainerList' => [ 'base' => NULL, 'refs' => [ 'ImportImageRequest$DiskContainers' => '<p>Information about the disk containers.</p>', ], ], 'ImageId' => [ 'base' => NULL, 'refs' => [ 'DeregisterImageRequest$ImageId' => '<p>The ID of the AMI.</p>', 'DescribeImageAttributeRequest$ImageId' => '<p>The ID of the AMI.</p>', 'ExportImageRequest$ImageId' => '<p>The ID of the image.</p>', 'ImageIdStringList$member' => NULL, 'ModifyImageAttributeRequest$ImageId' => '<p>The ID of the AMI.</p>', 'RequestLaunchTemplateData$ImageId' => '<p>The ID of the AMI.</p>', 'RequestSpotLaunchSpecification$ImageId' => '<p>The ID of the AMI.</p>', 'ResetImageAttributeRequest$ImageId' => '<p>The ID of the AMI.</p>', 'RunInstancesRequest$ImageId' => '<p>The ID of the AMI. An AMI ID is required to launch an instance and must be specified here or in a launch template.</p>', 'ScheduledInstancesLaunchSpecification$ImageId' => '<p>The ID of the Amazon Machine Image (AMI).</p>', ], ], 'ImageIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeImagesRequest$ImageIds' => '<p>The image IDs.</p> <p>Default: Describes all images available to you.</p>', ], ], 'ImageList' => [ 'base' => NULL, 'refs' => [ 'DescribeImagesResult$Images' => '<p>Information about the images.</p>', ], ], 'ImageState' => [ 'base' => NULL, 'refs' => [ 'Image$State' => '<p>The current state of the AMI. If the state is <code>available</code>, the image is successfully registered and can be used to launch an instance.</p>', ], ], 'ImageTypeValues' => [ 'base' => NULL, 'refs' => [ 'Image$ImageType' => '<p>The type of image.</p>', ], ], 'ImportClientVpnClientCertificateRevocationListRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportClientVpnClientCertificateRevocationListResult' => [ 'base' => NULL, 'refs' => [], ], 'ImportImageLicenseConfigurationRequest' => [ 'base' => '<p>The request information of license configurations.</p>', 'refs' => [ 'ImportImageLicenseSpecificationListRequest$member' => NULL, ], ], 'ImportImageLicenseConfigurationResponse' => [ 'base' => '<p> The response information for license configurations.</p>', 'refs' => [ 'ImportImageLicenseSpecificationListResponse$member' => NULL, ], ], 'ImportImageLicenseSpecificationListRequest' => [ 'base' => NULL, 'refs' => [ 'ImportImageRequest$LicenseSpecifications' => '<p>The ARNs of the license configurations.</p>', ], ], 'ImportImageLicenseSpecificationListResponse' => [ 'base' => NULL, 'refs' => [ 'ImportImageResult$LicenseSpecifications' => '<p>The ARNs of the license configurations.</p>', 'ImportImageTask$LicenseSpecifications' => '<p>The ARNs of the license configurations that are associated with the import image task.</p>', ], ], 'ImportImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportImageResult' => [ 'base' => NULL, 'refs' => [], ], 'ImportImageTask' => [ 'base' => '<p>Describes an import image task.</p>', 'refs' => [ 'ImportImageTaskList$member' => NULL, ], ], 'ImportImageTaskId' => [ 'base' => NULL, 'refs' => [ 'ImportImageResult$ImportTaskId' => '<p>The task ID of the import image task.</p>', 'ImportTaskIdList$member' => NULL, ], ], 'ImportImageTaskList' => [ 'base' => NULL, 'refs' => [ 'DescribeImportImageTasksResult$ImportImageTasks' => '<p>A list of zero or more import image tasks that are currently active or were completed or canceled in the previous 7 days.</p>', ], ], 'ImportInstanceLaunchSpecification' => [ 'base' => '<p>Describes the launch specification for VM import.</p>', 'refs' => [ 'ImportInstanceRequest$LaunchSpecification' => '<p>The launch specification.</p>', ], ], 'ImportInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportInstanceResult' => [ 'base' => NULL, 'refs' => [], ], 'ImportInstanceTaskDetails' => [ 'base' => '<p>Describes an import instance task.</p>', 'refs' => [ 'ConversionTask$ImportInstance' => '<p>If the task is for importing an instance, this contains information about the import instance task.</p>', ], ], 'ImportInstanceVolumeDetailItem' => [ 'base' => '<p>Describes an import volume task.</p>', 'refs' => [ 'ImportInstanceVolumeDetailSet$member' => NULL, ], ], 'ImportInstanceVolumeDetailSet' => [ 'base' => NULL, 'refs' => [ 'ImportInstanceTaskDetails$Volumes' => '<p>The volumes.</p>', ], ], 'ImportKeyPairRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportKeyPairResult' => [ 'base' => NULL, 'refs' => [], ], 'ImportSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'ImportSnapshotTask' => [ 'base' => '<p>Describes an import snapshot task.</p>', 'refs' => [ 'ImportSnapshotTaskList$member' => NULL, ], ], 'ImportSnapshotTaskId' => [ 'base' => NULL, 'refs' => [ 'ImportSnapshotTaskIdList$member' => NULL, ], ], 'ImportSnapshotTaskIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeImportSnapshotTasksRequest$ImportTaskIds' => '<p>A list of import snapshot task IDs.</p>', ], ], 'ImportSnapshotTaskList' => [ 'base' => NULL, 'refs' => [ 'DescribeImportSnapshotTasksResult$ImportSnapshotTasks' => '<p>A list of zero or more import snapshot tasks that are currently active or were completed or canceled in the previous 7 days.</p>', ], ], 'ImportTaskId' => [ 'base' => NULL, 'refs' => [ 'CancelImportTaskRequest$ImportTaskId' => '<p>The ID of the import image or import snapshot task to be canceled.</p>', ], ], 'ImportTaskIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeImportImageTasksRequest$ImportTaskIds' => '<p>The IDs of the import image tasks.</p>', ], ], 'ImportVolumeRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportVolumeResult' => [ 'base' => NULL, 'refs' => [], ], 'ImportVolumeTaskDetails' => [ 'base' => '<p>Describes an import volume task.</p>', 'refs' => [ 'ConversionTask$ImportVolume' => '<p>If the task is for importing a volume, this contains information about the import volume task.</p>', ], ], 'InferenceAcceleratorInfo' => [ 'base' => '<p>Describes the Inference accelerators for the instance type.</p>', 'refs' => [ 'InstanceTypeInfo$InferenceAcceleratorInfo' => '<p>Describes the Inference accelerator settings for the instance type.</p>', ], ], 'InferenceDeviceCount' => [ 'base' => NULL, 'refs' => [ 'InferenceDeviceInfo$Count' => '<p>The number of Inference accelerators for the instance type.</p>', ], ], 'InferenceDeviceInfo' => [ 'base' => '<p>Describes the Inference accelerators for the instance type.</p>', 'refs' => [ 'InferenceDeviceInfoList$member' => NULL, ], ], 'InferenceDeviceInfoList' => [ 'base' => NULL, 'refs' => [ 'InferenceAcceleratorInfo$Accelerators' => '<p>Describes the Inference accelerators for the instance type.</p>', ], ], 'InferenceDeviceManufacturerName' => [ 'base' => NULL, 'refs' => [ 'InferenceDeviceInfo$Manufacturer' => '<p>The manufacturer of the Inference accelerator.</p>', ], ], 'InferenceDeviceName' => [ 'base' => NULL, 'refs' => [ 'InferenceDeviceInfo$Name' => '<p>The name of the Inference accelerator.</p>', ], ], 'Instance' => [ 'base' => '<p>Describes an instance.</p>', 'refs' => [ 'InstanceList$member' => NULL, ], ], 'InstanceAttribute' => [ 'base' => '<p>Describes an instance attribute.</p>', 'refs' => [], ], 'InstanceAttributeName' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceAttributeRequest$Attribute' => '<p>The instance attribute.</p> <p>Note: The <code>enaSupport</code> attribute is not supported at this time.</p>', 'ModifyInstanceAttributeRequest$Attribute' => '<p>The name of the attribute.</p>', 'ResetInstanceAttributeRequest$Attribute' => '<p>The attribute to reset.</p> <important> <p>You can only reset the following attributes: <code>kernel</code> | <code>ramdisk</code> | <code>sourceDestCheck</code>. To change an instance attribute, use <a>ModifyInstanceAttribute</a>.</p> </important>', ], ], 'InstanceBlockDeviceMapping' => [ 'base' => '<p>Describes a block device mapping.</p>', 'refs' => [ 'InstanceBlockDeviceMappingList$member' => NULL, ], ], 'InstanceBlockDeviceMappingList' => [ 'base' => NULL, 'refs' => [ 'Instance$BlockDeviceMappings' => '<p>Any block device mapping entries for the instance.</p>', 'InstanceAttribute$BlockDeviceMappings' => '<p>The block device mapping of the instance.</p>', ], ], 'InstanceBlockDeviceMappingSpecification' => [ 'base' => '<p>Describes a block device mapping entry.</p>', 'refs' => [ 'InstanceBlockDeviceMappingSpecificationList$member' => NULL, ], ], 'InstanceBlockDeviceMappingSpecificationList' => [ 'base' => NULL, 'refs' => [ 'ModifyInstanceAttributeRequest$BlockDeviceMappings' => '<p>Modifies the <code>DeleteOnTermination</code> attribute for volumes that are currently attached. The volume must be owned by the caller. If no value is specified for <code>DeleteOnTermination</code>, the default is <code>true</code> and the volume is deleted when the instance is terminated.</p> <p>To add instance store volumes to an Amazon EBS-backed instance, you must add them when you launch the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html#Using_OverridingAMIBDM">Updating the block device mapping when launching an instance</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', ], ], 'InstanceCapacity' => [ 'base' => '<p>Information about the number of instances that can be launched onto the Dedicated Host.</p>', 'refs' => [ 'AvailableInstanceCapacityList$member' => NULL, ], ], 'InstanceCount' => [ 'base' => '<p>Describes a Reserved Instance listing state.</p>', 'refs' => [ 'InstanceCountList$member' => NULL, ], ], 'InstanceCountList' => [ 'base' => NULL, 'refs' => [ 'ReservedInstancesListing$InstanceCounts' => '<p>The number of instances in this state.</p>', ], ], 'InstanceCreditSpecification' => [ 'base' => '<p>Describes the credit option for CPU usage of a burstable performance instance. </p>', 'refs' => [ 'InstanceCreditSpecificationList$member' => NULL, ], ], 'InstanceCreditSpecificationList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceCreditSpecificationsResult$InstanceCreditSpecifications' => '<p>Information about the credit option for CPU usage of an instance.</p>', ], ], 'InstanceCreditSpecificationListRequest' => [ 'base' => NULL, 'refs' => [ 'ModifyInstanceCreditSpecificationRequest$InstanceCreditSpecifications' => '<p>Information about the credit option for CPU usage.</p>', ], ], 'InstanceCreditSpecificationRequest' => [ 'base' => '<p>Describes the credit option for CPU usage of a burstable performance instance.</p>', 'refs' => [ 'InstanceCreditSpecificationListRequest$member' => NULL, ], ], 'InstanceEventId' => [ 'base' => NULL, 'refs' => [ 'InstanceStatusEvent$InstanceEventId' => '<p>The ID of the event.</p>', ], ], 'InstanceExportDetails' => [ 'base' => '<p>Describes an instance to export.</p>', 'refs' => [ 'ExportTask$InstanceExportDetails' => '<p>Information about the instance to export.</p>', ], ], 'InstanceFamilyCreditSpecification' => [ 'base' => '<p>Describes the default credit option for CPU usage of a burstable performance instance family.</p>', 'refs' => [ 'GetDefaultCreditSpecificationResult$InstanceFamilyCreditSpecification' => '<p>The default credit option for CPU usage of the instance family.</p>', 'ModifyDefaultCreditSpecificationResult$InstanceFamilyCreditSpecification' => '<p>The default credit option for CPU usage of the instance family.</p>', ], ], 'InstanceHealthStatus' => [ 'base' => NULL, 'refs' => [ 'ActiveInstance$InstanceHealth' => '<p>The health status of the instance. If the status of either the instance status check or the system status check is <code>impaired</code>, the health status of the instance is <code>unhealthy</code>. Otherwise, the health status is <code>healthy</code>.</p>', ], ], 'InstanceId' => [ 'base' => NULL, 'refs' => [ 'AssociateAddressRequest$InstanceId' => '<p>The ID of the instance. This is required for EC2-Classic. For EC2-VPC, you can specify either the instance ID or the network interface ID, but not both. The operation fails if you specify an instance ID unless exactly one network interface is attached.</p>', 'AssociateIamInstanceProfileRequest$InstanceId' => '<p>The ID of the instance.</p>', 'AttachClassicLinkVpcRequest$InstanceId' => '<p>The ID of an EC2-Classic instance to link to the ClassicLink-enabled VPC.</p>', 'AttachNetworkInterfaceRequest$InstanceId' => '<p>The ID of the instance.</p>', 'AttachVolumeRequest$InstanceId' => '<p>The ID of the instance.</p>', 'BundleInstanceRequest$InstanceId' => '<p>The ID of the instance to bundle.</p> <p>Type: String</p> <p>Default: None</p> <p>Required: Yes</p>', 'ConfirmProductInstanceRequest$InstanceId' => '<p>The ID of the instance.</p>', 'CreateImageRequest$InstanceId' => '<p>The ID of the instance.</p>', 'CreateInstanceExportTaskRequest$InstanceId' => '<p>The ID of the instance.</p>', 'CreateRouteRequest$InstanceId' => '<p>The ID of a NAT instance in your VPC. The operation fails if you specify an instance ID unless exactly one network interface is attached.</p>', 'DescribeInstanceAttributeRequest$InstanceId' => '<p>The ID of the instance.</p>', 'DetachClassicLinkVpcRequest$InstanceId' => '<p>The ID of the instance to unlink from the VPC.</p>', 'DetachVolumeRequest$InstanceId' => '<p>The ID of the instance. If you are detaching a Multi-Attach enabled volume, you must specify an instance ID.</p>', 'GetConsoleOutputRequest$InstanceId' => '<p>The ID of the instance.</p>', 'GetConsoleScreenshotRequest$InstanceId' => '<p>The ID of the instance.</p>', 'GetLaunchTemplateDataRequest$InstanceId' => '<p>The ID of the instance.</p>', 'GetPasswordDataRequest$InstanceId' => '<p>The ID of the Windows instance.</p>', 'InstanceCreditSpecificationRequest$InstanceId' => '<p>The ID of the instance.</p>', 'InstanceIdSet$member' => NULL, 'InstanceIdStringList$member' => NULL, 'InstanceIdsSet$member' => NULL, 'InstanceSpecification$InstanceId' => '<p>The instance to specify which volumes should be snapshotted.</p>', 'ModifyInstanceAttributeRequest$InstanceId' => '<p>The ID of the instance.</p>', 'ModifyInstanceCapacityReservationAttributesRequest$InstanceId' => '<p>The ID of the instance to be modified.</p>', 'ModifyInstanceEventStartTimeRequest$InstanceId' => '<p>The ID of the instance with the scheduled event.</p>', 'ModifyInstanceMetadataOptionsRequest$InstanceId' => '<p>The ID of the instance.</p>', 'ModifyInstancePlacementRequest$InstanceId' => '<p>The ID of the instance that you are modifying.</p>', 'ReplaceRouteRequest$InstanceId' => '<p>The ID of a NAT instance in your VPC.</p>', 'ResetInstanceAttributeRequest$InstanceId' => '<p>The ID of the instance.</p>', 'SendDiagnosticInterruptRequest$InstanceId' => '<p>The ID of the instance.</p>', 'SpotInstanceRequest$InstanceId' => '<p>The instance ID, if an instance has been launched to fulfill the Spot Instance request.</p>', ], ], 'InstanceIdSet' => [ 'base' => NULL, 'refs' => [ 'RunScheduledInstancesResult$InstanceIdSet' => '<p>The IDs of the newly launched instances.</p>', ], ], 'InstanceIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeClassicLinkInstancesRequest$InstanceIds' => '<p>One or more instance IDs. Must be instances linked to a VPC through ClassicLink.</p>', 'DescribeInstanceCreditSpecificationsRequest$InstanceIds' => '<p>The instance IDs.</p> <p>Default: Describes all your instances.</p> <p>Constraints: Maximum 1000 explicitly specified instance IDs.</p>', 'DescribeInstanceStatusRequest$InstanceIds' => '<p>The instance IDs.</p> <p>Default: Describes all your instances.</p> <p>Constraints: Maximum 100 explicitly specified instance IDs.</p>', 'DescribeInstancesRequest$InstanceIds' => '<p>The instance IDs.</p> <p>Default: Describes all your instances.</p>', 'MonitorInstancesRequest$InstanceIds' => '<p>The IDs of the instances.</p>', 'RebootInstancesRequest$InstanceIds' => '<p>The instance IDs.</p>', 'ReportInstanceStatusRequest$Instances' => '<p>The instances.</p>', 'StartInstancesRequest$InstanceIds' => '<p>The IDs of the instances.</p>', 'StopInstancesRequest$InstanceIds' => '<p>The IDs of the instances.</p>', 'TerminateInstancesRequest$InstanceIds' => '<p>The IDs of the instances.</p> <p>Constraints: Up to 1000 instance IDs. We recommend breaking up this request into smaller batches.</p>', 'UnmonitorInstancesRequest$InstanceIds' => '<p>The IDs of the instances.</p>', ], ], 'InstanceIdsSet' => [ 'base' => NULL, 'refs' => [ 'CreateFleetInstance$InstanceIds' => '<p>The IDs of the instances.</p>', 'DescribeFleetsInstances$InstanceIds' => '<p>The IDs of the instances.</p>', ], ], 'InstanceInterruptionBehavior' => [ 'base' => NULL, 'refs' => [ 'LaunchTemplateSpotMarketOptions$InstanceInterruptionBehavior' => '<p>The behavior when a Spot Instance is interrupted.</p>', 'LaunchTemplateSpotMarketOptionsRequest$InstanceInterruptionBehavior' => '<p>The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.</p>', 'RequestSpotInstancesRequest$InstanceInterruptionBehavior' => '<p>The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.</p>', 'SpotFleetRequestConfigData$InstanceInterruptionBehavior' => '<p>The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.</p>', 'SpotInstanceRequest$InstanceInterruptionBehavior' => '<p>The behavior when a Spot Instance is interrupted.</p>', 'SpotMarketOptions$InstanceInterruptionBehavior' => '<p>The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.</p>', ], ], 'InstanceIpv6Address' => [ 'base' => '<p>Describes an IPv6 address.</p>', 'refs' => [ 'InstanceIpv6AddressList$member' => NULL, ], ], 'InstanceIpv6AddressList' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkInterfaceRequest$Ipv6Addresses' => '<p>One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. You can\'t use this option if you\'re specifying a number of IPv6 addresses.</p>', 'InstanceNetworkInterface$Ipv6Addresses' => '<p>One or more IPv6 addresses associated with the network interface.</p>', 'InstanceNetworkInterfaceSpecification$Ipv6Addresses' => '<p>One or more IPv6 addresses to assign to the network interface. You cannot specify this option and the option to assign a number of IPv6 addresses in the same request. You cannot specify this option if you\'ve specified a minimum number of instances to launch.</p>', 'LaunchTemplateInstanceNetworkInterfaceSpecification$Ipv6Addresses' => '<p>The IPv6 addresses for the network interface.</p>', 'RunInstancesRequest$Ipv6Addresses' => '<p>[EC2-VPC] The IPv6 addresses from the range of the subnet to associate with the primary network interface. You cannot specify this option and the option to assign a number of IPv6 addresses in the same request. You cannot specify this option if you\'ve specified a minimum number of instances to launch.</p> <p>You cannot specify this option and the network interfaces option in the same request.</p>', ], ], 'InstanceIpv6AddressListRequest' => [ 'base' => NULL, 'refs' => [ 'LaunchTemplateInstanceNetworkInterfaceSpecificationRequest$Ipv6Addresses' => '<p>One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. You can\'t use this option if you\'re specifying a number of IPv6 addresses.</p>', ], ], 'InstanceIpv6AddressRequest' => [ 'base' => '<p>Describes an IPv6 address.</p>', 'refs' => [ 'InstanceIpv6AddressListRequest$member' => NULL, ], ], 'InstanceLifecycle' => [ 'base' => NULL, 'refs' => [ 'CreateFleetError$Lifecycle' => '<p>Indicates if the instance that could not be launched was a Spot Instance or On-Demand Instance.</p>', 'CreateFleetInstance$Lifecycle' => '<p>Indicates if the instance that was launched is a Spot Instance or On-Demand Instance.</p>', 'DescribeFleetError$Lifecycle' => '<p>Indicates if the instance that could not be launched was a Spot Instance or On-Demand Instance.</p>', 'DescribeFleetsInstances$Lifecycle' => '<p>Indicates if the instance that was launched is a Spot Instance or On-Demand Instance.</p>', ], ], 'InstanceLifecycleType' => [ 'base' => NULL, 'refs' => [ 'Instance$InstanceLifecycle' => '<p>Indicates whether this is a Spot Instance or a Scheduled Instance.</p>', ], ], 'InstanceList' => [ 'base' => NULL, 'refs' => [ 'Reservation$Instances' => '<p>The instances.</p>', ], ], 'InstanceMarketOptionsRequest' => [ 'base' => '<p>Describes the market (purchasing) option for the instances.</p>', 'refs' => [ 'RunInstancesRequest$InstanceMarketOptions' => '<p>The market (purchasing) option for the instances.</p> <p>For <a>RunInstances</a>, persistent Spot Instance requests are only supported when <b>InstanceInterruptionBehavior</b> is set to either <code>hibernate</code> or <code>stop</code>.</p>', ], ], 'InstanceMatchCriteria' => [ 'base' => NULL, 'refs' => [ 'CapacityReservation$InstanceMatchCriteria' => '<p>Indicates the type of instance launches that the Capacity Reservation accepts. The options include:</p> <ul> <li> <p> <code>open</code> - The Capacity Reservation accepts all instances that have matching attributes (instance type, platform, and Availability Zone). Instances that have matching attributes launch into the Capacity Reservation automatically without specifying any additional parameters.</p> </li> <li> <p> <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only permitted instances can use the reserved capacity. </p> </li> </ul>', 'CreateCapacityReservationRequest$InstanceMatchCriteria' => '<p>Indicates the type of instance launches that the Capacity Reservation accepts. The options include:</p> <ul> <li> <p> <code>open</code> - The Capacity Reservation automatically matches all instances that have matching attributes (instance type, platform, and Availability Zone). Instances that have matching attributes run in the Capacity Reservation automatically without specifying any additional parameters.</p> </li> <li> <p> <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only permitted instances can use the reserved capacity. </p> </li> </ul> <p>Default: <code>open</code> </p>', ], ], 'InstanceMetadataEndpointState' => [ 'base' => NULL, 'refs' => [ 'InstanceMetadataOptionsRequest$HttpEndpoint' => '<p>This parameter enables or disables the HTTP metadata endpoint on your instances. If the parameter is not specified, the default state is <code>enabled</code>.</p> <note> <p>If you specify a value of <code>disabled</code>, you will not be able to access your instance metadata.</p> </note>', 'InstanceMetadataOptionsResponse$HttpEndpoint' => '<p>This parameter enables or disables the HTTP metadata endpoint on your instances. If the parameter is not specified, the default state is <code>enabled</code>.</p> <note> <p>If you specify a value of <code>disabled</code>, you will not be able to access your instance metadata.</p> </note>', 'ModifyInstanceMetadataOptionsRequest$HttpEndpoint' => '<p>This parameter enables or disables the HTTP metadata endpoint on your instances. If the parameter is not specified, the existing state is maintained.</p> <note> <p>If you specify a value of <code>disabled</code>, you will not be able to access your instance metadata.</p> </note>', ], ], 'InstanceMetadataOptionsRequest' => [ 'base' => '<p>The metadata options for the instance.</p>', 'refs' => [ 'RunInstancesRequest$MetadataOptions' => '<p>The metadata options for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data</a>.</p>', ], ], 'InstanceMetadataOptionsResponse' => [ 'base' => '<p>The metadata options for the instance.</p>', 'refs' => [ 'Instance$MetadataOptions' => '<p>The metadata options for the instance.</p>', 'ModifyInstanceMetadataOptionsResult$InstanceMetadataOptions' => '<p>The metadata options for the instance.</p>', ], ], 'InstanceMetadataOptionsState' => [ 'base' => NULL, 'refs' => [ 'InstanceMetadataOptionsResponse$State' => '<p>The state of the metadata option changes.</p> <p> <code>pending</code> - The metadata options are being updated and the instance is not ready to process metadata traffic with the new selection.</p> <p> <code>applied</code> - The metadata options have been successfully applied on the instance.</p>', ], ], 'InstanceMonitoring' => [ 'base' => '<p>Describes the monitoring of an instance.</p>', 'refs' => [ 'InstanceMonitoringList$member' => NULL, ], ], 'InstanceMonitoringList' => [ 'base' => NULL, 'refs' => [ 'MonitorInstancesResult$InstanceMonitorings' => '<p>The monitoring information.</p>', 'UnmonitorInstancesResult$InstanceMonitorings' => '<p>The monitoring information.</p>', ], ], 'InstanceNetworkInterface' => [ 'base' => '<p>Describes a network interface.</p>', 'refs' => [ 'InstanceNetworkInterfaceList$member' => NULL, ], ], 'InstanceNetworkInterfaceAssociation' => [ 'base' => '<p>Describes association information for an Elastic IP address (IPv4).</p>', 'refs' => [ 'InstanceNetworkInterface$Association' => '<p>The association information for an Elastic IPv4 associated with the network interface.</p>', 'InstancePrivateIpAddress$Association' => '<p>The association information for an Elastic IP address for the network interface.</p>', ], ], 'InstanceNetworkInterfaceAttachment' => [ 'base' => '<p>Describes a network interface attachment.</p>', 'refs' => [ 'InstanceNetworkInterface$Attachment' => '<p>The network interface attachment.</p>', ], ], 'InstanceNetworkInterfaceList' => [ 'base' => NULL, 'refs' => [ 'Instance$NetworkInterfaces' => '<p>[EC2-VPC] The network interfaces for the instance.</p>', ], ], 'InstanceNetworkInterfaceSpecification' => [ 'base' => '<p>Describes a network interface.</p>', 'refs' => [ 'InstanceNetworkInterfaceSpecificationList$member' => NULL, ], ], 'InstanceNetworkInterfaceSpecificationList' => [ 'base' => NULL, 'refs' => [ 'LaunchSpecification$NetworkInterfaces' => '<p>One or more network interfaces. If you specify a network interface, you must specify subnet IDs and security group IDs using the network interface.</p>', 'RequestSpotLaunchSpecification$NetworkInterfaces' => '<p>One or more network interfaces. If you specify a network interface, you must specify subnet IDs and security group IDs using the network interface.</p>', 'RunInstancesRequest$NetworkInterfaces' => '<p>The network interfaces to associate with the instance. If you specify a network interface, you must specify any security groups and subnets as part of the network interface.</p>', 'SpotFleetLaunchSpecification$NetworkInterfaces' => '<p>One or more network interfaces. If you specify a network interface, you must specify subnet IDs and security group IDs using the network interface.</p>', ], ], 'InstancePrivateIpAddress' => [ 'base' => '<p>Describes a private IPv4 address.</p>', 'refs' => [ 'InstancePrivateIpAddressList$member' => NULL, ], ], 'InstancePrivateIpAddressList' => [ 'base' => NULL, 'refs' => [ 'InstanceNetworkInterface$PrivateIpAddresses' => '<p>One or more private IPv4 addresses associated with the network interface.</p>', ], ], 'InstanceSpecification' => [ 'base' => '<p>The instance details to specify which volumes should be snapshotted.</p>', 'refs' => [ 'CreateSnapshotsRequest$InstanceSpecification' => '<p>The instance to specify which volumes should be included in the snapshots.</p>', ], ], 'InstanceState' => [ 'base' => '<p>Describes the current state of an instance.</p>', 'refs' => [ 'Instance$State' => '<p>The current state of the instance.</p>', 'InstanceStateChange$CurrentState' => '<p>The current state of the instance.</p>', 'InstanceStateChange$PreviousState' => '<p>The previous state of the instance.</p>', 'InstanceStatus$InstanceState' => '<p>The intended state of the instance. <a>DescribeInstanceStatus</a> requires that an instance be in the <code>running</code> state.</p>', ], ], 'InstanceStateChange' => [ 'base' => '<p>Describes an instance state change.</p>', 'refs' => [ 'InstanceStateChangeList$member' => NULL, ], ], 'InstanceStateChangeList' => [ 'base' => NULL, 'refs' => [ 'StartInstancesResult$StartingInstances' => '<p>Information about the started instances.</p>', 'StopInstancesResult$StoppingInstances' => '<p>Information about the stopped instances.</p>', 'TerminateInstancesResult$TerminatingInstances' => '<p>Information about the terminated instances.</p>', ], ], 'InstanceStateName' => [ 'base' => NULL, 'refs' => [ 'InstanceState$Name' => '<p>The current state of the instance.</p>', ], ], 'InstanceStatus' => [ 'base' => '<p>Describes the status of an instance.</p>', 'refs' => [ 'InstanceStatusList$member' => NULL, ], ], 'InstanceStatusDetails' => [ 'base' => '<p>Describes the instance status.</p>', 'refs' => [ 'InstanceStatusDetailsList$member' => NULL, ], ], 'InstanceStatusDetailsList' => [ 'base' => NULL, 'refs' => [ 'InstanceStatusSummary$Details' => '<p>The system instance health or application instance health.</p>', ], ], 'InstanceStatusEvent' => [ 'base' => '<p>Describes a scheduled event for an instance.</p>', 'refs' => [ 'InstanceStatusEventList$member' => NULL, 'ModifyInstanceEventStartTimeResult$Event' => NULL, ], ], 'InstanceStatusEventList' => [ 'base' => NULL, 'refs' => [ 'InstanceStatus$Events' => '<p>Any scheduled events associated with the instance.</p>', ], ], 'InstanceStatusList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceStatusResult$InstanceStatuses' => '<p>Information about the status of the instances.</p>', ], ], 'InstanceStatusSummary' => [ 'base' => '<p>Describes the status of an instance.</p>', 'refs' => [ 'InstanceStatus$InstanceStatus' => '<p>Reports impaired functionality that stems from issues internal to the instance, such as impaired reachability.</p>', 'InstanceStatus$SystemStatus' => '<p>Reports impaired functionality that stems from issues related to the systems that support an instance, such as hardware failures and network connectivity problems.</p>', ], ], 'InstanceStorageFlag' => [ 'base' => NULL, 'refs' => [ 'InstanceTypeInfo$InstanceStorageSupported' => '<p>Indicates whether instance storage is supported.</p>', ], ], 'InstanceStorageInfo' => [ 'base' => '<p>Describes the disks that are available for the instance type.</p>', 'refs' => [ 'InstanceTypeInfo$InstanceStorageInfo' => '<p>Describes the disks for the instance type.</p>', ], ], 'InstanceTagKeySet' => [ 'base' => NULL, 'refs' => [ 'DeregisterInstanceTagAttributeRequest$InstanceTagKeys' => '<p>Information about the tag keys to deregister.</p>', 'InstanceTagNotificationAttribute$InstanceTagKeys' => '<p>The registered tag keys.</p>', 'RegisterInstanceTagAttributeRequest$InstanceTagKeys' => '<p>The tag keys to register.</p>', ], ], 'InstanceTagNotificationAttribute' => [ 'base' => '<p>Describes the registered tag keys for the current Region.</p>', 'refs' => [ 'DeregisterInstanceEventNotificationAttributesResult$InstanceTagAttribute' => '<p>The resulting set of tag keys.</p>', 'DescribeInstanceEventNotificationAttributesResult$InstanceTagAttribute' => '<p>Information about the registered tag keys.</p>', 'RegisterInstanceEventNotificationAttributesResult$InstanceTagAttribute' => '<p>The resulting set of tag keys.</p>', ], ], 'InstanceType' => [ 'base' => NULL, 'refs' => [ 'CreateFleetInstance$InstanceType' => '<p>The instance type.</p>', 'DescribeFleetsInstances$InstanceType' => '<p>The instance type.</p>', 'DescribeReservedInstancesOfferingsRequest$InstanceType' => '<p>The instance type that the reservation will cover (for example, <code>m1.small</code>). For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'FleetLaunchTemplateOverrides$InstanceType' => '<p>The instance type.</p>', 'FleetLaunchTemplateOverridesRequest$InstanceType' => '<p>The instance type.</p>', 'ImportInstanceLaunchSpecification$InstanceType' => '<p>The instance type. For more information about the instance types that you can import, see <a href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmie_prereqs.html#vmimport-instance-types">Instance Types</a> in the VM Import/Export User Guide.</p>', 'Instance$InstanceType' => '<p>The instance type.</p>', 'InstanceTypeInfo$InstanceType' => '<p>The instance type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'InstanceTypeList$member' => NULL, 'InstanceTypeOffering$InstanceType' => '<p>The instance type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'LaunchSpecification$InstanceType' => '<p>The instance type.</p>', 'LaunchTemplateOverrides$InstanceType' => '<p>The instance type.</p>', 'RequestInstanceTypeList$member' => NULL, 'RequestLaunchTemplateData$InstanceType' => '<p>The instance type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'RequestSpotLaunchSpecification$InstanceType' => '<p>The instance type.</p>', 'ReservedInstances$InstanceType' => '<p>The instance type on which the Reserved Instance can be used.</p>', 'ReservedInstancesConfiguration$InstanceType' => '<p>The instance type for the modified Reserved Instances.</p>', 'ReservedInstancesOffering$InstanceType' => '<p>The instance type on which the Reserved Instance can be used.</p>', 'ResponseLaunchTemplateData$InstanceType' => '<p>The instance type.</p>', 'RunInstancesRequest$InstanceType' => '<p>The instance type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>Default: <code>m1.small</code> </p>', 'SpotFleetLaunchSpecification$InstanceType' => '<p>The instance type.</p>', 'SpotPrice$InstanceType' => '<p>The instance type.</p>', ], ], 'InstanceTypeHypervisor' => [ 'base' => NULL, 'refs' => [ 'InstanceTypeInfo$Hypervisor' => '<p>Indicates the hypervisor used for the instance type.</p>', ], ], 'InstanceTypeInfo' => [ 'base' => '<p>Describes the instance type.</p>', 'refs' => [ 'InstanceTypeInfoList$member' => NULL, ], ], 'InstanceTypeInfoList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceTypesResult$InstanceTypes' => '<p>The instance type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', ], ], 'InstanceTypeList' => [ 'base' => NULL, 'refs' => [ 'DescribeSpotPriceHistoryRequest$InstanceTypes' => '<p>Filters the results by the specified instance types.</p>', ], ], 'InstanceTypeOffering' => [ 'base' => '<p>The instance types offered.</p>', 'refs' => [ 'InstanceTypeOfferingsList$member' => NULL, ], ], 'InstanceTypeOfferingsList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceTypeOfferingsResult$InstanceTypeOfferings' => '<p>The instance types offered.</p>', ], ], 'InstanceUsage' => [ 'base' => '<p>Information about the Capacity Reservation usage.</p>', 'refs' => [ 'InstanceUsageSet$member' => NULL, ], ], 'InstanceUsageSet' => [ 'base' => NULL, 'refs' => [ 'GetCapacityReservationUsageResult$InstanceUsages' => '<p>Information about the Capacity Reservation usage.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'AllocateHostsRequest$Quantity' => '<p>The number of Dedicated Hosts to allocate to your account with these parameters.</p>', 'AssignIpv6AddressesRequest$Ipv6AddressCount' => '<p>The number of IPv6 addresses to assign to the network interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. You can\'t use this option if specifying specific IPv6 addresses.</p>', 'AssignPrivateIpAddressesRequest$SecondaryPrivateIpAddressCount' => '<p>The number of secondary IP addresses to assign to the network interface. You can\'t specify this parameter when also specifying private IP addresses.</p>', 'AttachNetworkInterfaceRequest$DeviceIndex' => '<p>The index of the device for the network interface attachment.</p>', 'AuthorizeSecurityGroupEgressRequest$FromPort' => '<p>Not supported. Use a set of IP permissions to specify the port.</p>', 'AuthorizeSecurityGroupEgressRequest$ToPort' => '<p>Not supported. Use a set of IP permissions to specify the port.</p>', 'AuthorizeSecurityGroupIngressRequest$FromPort' => '<p>The start of port range for the TCP and UDP protocols, or an ICMP type number. For the ICMP type number, use <code>-1</code> to specify all types. If you specify all ICMP types, you must specify all codes.</p> <p>Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.</p>', 'AuthorizeSecurityGroupIngressRequest$ToPort' => '<p>The end of port range for the TCP and UDP protocols, or an ICMP code number. For the ICMP code number, use <code>-1</code> to specify all codes. If you specify all ICMP types, you must specify all codes.</p> <p>Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule.</p>', 'AvailableCapacity$AvailableVCpus' => '<p>The number of vCPUs available for launching instances onto the Dedicated Host.</p>', 'CapacityReservation$TotalInstanceCount' => '<p>The total number of instances for which the Capacity Reservation reserves capacity.</p>', 'CapacityReservation$AvailableInstanceCount' => '<p>The remaining capacity. Indicates the number of instances that can be launched in the Capacity Reservation.</p>', 'ClientVpnEndpoint$VpnPort' => '<p>The port number for the Client VPN endpoint.</p>', 'CpuOptions$CoreCount' => '<p>The number of CPU cores for the instance.</p>', 'CpuOptions$ThreadsPerCore' => '<p>The number of threads per CPU core.</p>', 'CpuOptionsRequest$CoreCount' => '<p>The number of CPU cores for the instance.</p>', 'CpuOptionsRequest$ThreadsPerCore' => '<p>The number of threads per CPU core. To disable multithreading for the instance, specify a value of <code>1</code>. Otherwise, specify the default value of <code>2</code>.</p>', 'CreateCapacityReservationRequest$InstanceCount' => '<p>The number of instances for which to reserve capacity.</p>', 'CreateClientVpnEndpointRequest$VpnPort' => '<p>The port number to assign to the Client VPN endpoint for TCP and UDP traffic.</p> <p>Valid Values: <code>443</code> | <code>1194</code> </p> <p>Default Value: <code>443</code> </p>', 'CreateCustomerGatewayRequest$BgpAsn' => '<p>For devices that support BGP, the customer gateway\'s BGP ASN.</p> <p>Default: 65000</p>', 'CreateFlowLogsRequest$MaxAggregationInterval' => '<p>The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record. You can specify 60 seconds (1 minute) or 600 seconds (10 minutes).</p> <p>When a network interface is attached to a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based instance</a>, the aggregation interval is always 60 seconds or less, regardless of the value that you specify.</p> <p>Default: 600</p>', 'CreateManagedPrefixListRequest$MaxEntries' => '<p>The maximum number of entries for the prefix list.</p>', 'CreateNetworkAclEntryRequest$RuleNumber' => '<p>The rule number for the entry (for example, 100). ACL entries are processed in ascending order by rule number.</p> <p>Constraints: Positive integer from 1 to 32766. The range 32767 to 65535 is reserved for internal use.</p>', 'CreateNetworkInterfaceRequest$Ipv6AddressCount' => '<p>The number of IPv6 addresses to assign to a network interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. You can\'t use this option if specifying specific IPv6 addresses. If your subnet has the <code>AssignIpv6AddressOnCreation</code> attribute set to <code>true</code>, you can specify <code>0</code> to override this setting.</p>', 'CreateNetworkInterfaceRequest$SecondaryPrivateIpAddressCount' => '<p>The number of secondary private IPv4 addresses to assign to a network interface. When you specify a number of secondary IPv4 addresses, Amazon EC2 selects these IP addresses within the subnet\'s IPv4 CIDR range. You can\'t specify this option and specify more than one private IP address using <code>privateIpAddresses</code>.</p> <p>The number of IP addresses you can assign to a network interface varies by instance type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI">IP Addresses Per ENI Per Instance Type</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'CreatePlacementGroupRequest$PartitionCount' => '<p>The number of partitions. Valid only when <b>Strategy</b> is set to <code>partition</code>.</p>', 'CreateReservedInstancesListingRequest$InstanceCount' => '<p>The number of instances that are a part of a Reserved Instance account to be listed in the Reserved Instance Marketplace. This number should be less than or equal to the instance count associated with the Reserved Instance ID specified in this call.</p>', 'CreateTrafficMirrorFilterRuleRequest$RuleNumber' => '<p>The number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given direction. The rules are processed in ascending order by rule number.</p>', 'CreateTrafficMirrorFilterRuleRequest$Protocol' => '<p>The protocol, for example UDP, to assign to the Traffic Mirror rule.</p> <p>For information about the protocol value, see <a href="https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a> on the Internet Assigned Numbers Authority (IANA) website.</p>', 'CreateTrafficMirrorSessionRequest$PacketLength' => '<p>The number of bytes in each packet to mirror. These are bytes after the VXLAN header. Do not specify this parameter when you want to mirror the entire packet. To mirror a subset of the packet, set this to the length (in bytes) that you want to mirror. For example, if you set this value to 100, then the first 100 bytes that meet the filter criteria are copied to the target.</p> <p>If you do not want to mirror the entire packet, use the <code>PacketLength</code> parameter to specify the number of bytes in each packet to mirror.</p>', 'CreateTrafficMirrorSessionRequest$SessionNumber' => '<p>The session number determines the order in which sessions are evaluated when an interface is used by multiple sessions. The first session with a matching filter is the one that mirrors the packets.</p> <p>Valid values are 1-32766.</p>', 'CreateTrafficMirrorSessionRequest$VirtualNetworkId' => '<p>The VXLAN ID for the Traffic Mirror session. For more information about the VXLAN protocol, see <a href="https://tools.ietf.org/html/rfc7348">RFC 7348</a>. If you do not specify a <code>VirtualNetworkId</code>, an account-wide unique id is chosen at random.</p>', 'CreateVolumeRequest$Iops' => '<p>The number of I/O operations per second (IOPS) to provision for the volume, with a maximum ratio of 50 IOPS/GiB. Range is 100 to 64,000 IOPS for volumes in most Regions. Maximum IOPS of 64,000 is guaranteed only on <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based instances</a>. Other instance families guarantee performance up to 32,000 IOPS. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS Volume Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>This parameter is valid only for Provisioned IOPS SSD (io1) volumes.</p>', 'CreateVolumeRequest$Size' => '<p>The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size.</p> <p>Constraints: 1-16,384 for <code>gp2</code>, 4-16,384 for <code>io1</code>, 500-16,384 for <code>st1</code>, 500-16,384 for <code>sc1</code>, and 1-1,024 for <code>standard</code>. If you specify a snapshot, the volume size must be equal to or larger than the snapshot size.</p> <p>Default: If you\'re creating the volume from a snapshot and don\'t specify a volume size, the default is the snapshot size.</p>', 'DeleteNetworkAclEntryRequest$RuleNumber' => '<p>The rule number of the entry to delete.</p>', 'DescribeElasticGpusResult$MaxResults' => '<p>The total number of items to return. If the total number of items available is more than the value specified in max-items then a Next-Token will be provided in the output that you can use to resume pagination.</p>', 'DescribeFleetHistoryRequest$MaxResults' => '<p>The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default value is 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', 'DescribeFleetInstancesRequest$MaxResults' => '<p>The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default value is 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', 'DescribeFleetsRequest$MaxResults' => '<p>The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default value is 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', 'DescribeFlowLogsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', 'DescribeHostReservationOfferingsRequest$MaxDuration' => '<p>This is the maximum duration of the reservation to purchase, specified in seconds. Reservations are available in one-year and three-year terms. The number of seconds specified must be the number of seconds in a year (365x24x60x60) times one of the supported durations (1 or 3). For example, specify 94608000 for three years.</p>', 'DescribeHostReservationOfferingsRequest$MinDuration' => '<p>This is the minimum duration of the reservation you\'d like to purchase, specified in seconds. Reservations are available in one-year and three-year terms. The number of seconds specified must be the number of seconds in a year (365x24x60x60) times one of the supported durations (1 or 3). For example, specify 31536000 for one year.</p>', 'DescribeHostReservationsRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.</p>', 'DescribeHostsRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.</p> <p>You cannot specify this parameter and the host IDs parameter in the same request.</p>', 'DescribeImportImageTasksRequest$MaxResults' => '<p>The maximum number of results to return in a single call.</p>', 'DescribeImportSnapshotTasksRequest$MaxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', 'DescribeInstanceStatusRequest$MaxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. This value can be between 5 and 1000. You cannot specify this parameter and the instance IDs parameter in the same call.</p>', 'DescribeInstancesRequest$MaxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. This value can be between 5 and 1000. You cannot specify this parameter and the instance IDs parameter in the same call.</p>', 'DescribeLaunchTemplateVersionsRequest$MaxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value. This value can be between 1 and 200.</p>', 'DescribePrefixListsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', 'DescribeReservedInstancesOfferingsRequest$MaxInstanceCount' => '<p>The maximum number of instances to filter when searching for offerings.</p> <p>Default: 20</p>', 'DescribeReservedInstancesOfferingsRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results of the initial request can be seen by sending another request with the returned <code>NextToken</code> value. The maximum is 100.</p> <p>Default: 100</p>', 'DescribeScheduledInstanceAvailabilityRequest$MaxSlotDurationInHours' => '<p>The maximum available duration, in hours. This value must be greater than <code>MinSlotDurationInHours</code> and less than 1,720.</p>', 'DescribeScheduledInstanceAvailabilityRequest$MinSlotDurationInHours' => '<p>The minimum available duration, in hours. The minimum required duration is 1,200 hours per year. For example, the minimum daily schedule is 4 hours, the minimum weekly schedule is 24 hours, and the minimum monthly schedule is 100 hours.</p>', 'DescribeScheduledInstancesRequest$MaxResults' => '<p>The maximum number of results to return in a single call. This value can be between 5 and 300. The default value is 100. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', 'DescribeSnapshotsRequest$MaxResults' => '<p>The maximum number of snapshot results returned by <code>DescribeSnapshots</code> in paginated output. When this parameter is used, <code>DescribeSnapshots</code> only returns <code>MaxResults</code> results in a single page along with a <code>NextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribeSnapshots</code> request with the returned <code>NextToken</code> value. This value can be between 5 and 1000; if <code>MaxResults</code> is given a value larger than 1000, only 1000 results are returned. If this parameter is not used, then <code>DescribeSnapshots</code> returns all results. You cannot specify this parameter and the snapshot IDs parameter in the same request.</p>', 'DescribeSpotFleetRequestsRequest$MaxResults' => '<p>The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default value is 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', 'DescribeSpotInstanceRequestsRequest$MaxResults' => '<p>The maximum number of results to return in a single call. Specify a value between 5 and 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', 'DescribeSpotPriceHistoryRequest$MaxResults' => '<p>The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default value is 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', 'DescribeTagsRequest$MaxResults' => '<p>The maximum number of results to return in a single call. This value can be between 5 and 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.</p>', 'DescribeVolumeStatusRequest$MaxResults' => '<p>The maximum number of volume results returned by <code>DescribeVolumeStatus</code> in paginated output. When this parameter is used, the request only returns <code>MaxResults</code> results in a single page along with a <code>NextToken</code> response element. The remaining results of the initial request can be seen by sending another request with the returned <code>NextToken</code> value. This value can be between 5 and 1000; if <code>MaxResults</code> is given a value larger than 1000, only 1000 results are returned. If this parameter is not used, then <code>DescribeVolumeStatus</code> returns all results. You cannot specify this parameter and the volume IDs parameter in the same request.</p>', 'DescribeVolumesModificationsRequest$MaxResults' => '<p>The maximum number of results (up to a limit of 500) to be returned in a paginated request.</p>', 'DescribeVolumesRequest$MaxResults' => '<p>The maximum number of volume results returned by <code>DescribeVolumes</code> in paginated output. When this parameter is used, <code>DescribeVolumes</code> only returns <code>MaxResults</code> results in a single page along with a <code>NextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribeVolumes</code> request with the returned <code>NextToken</code> value. This value can be between 5 and 500; if <code>MaxResults</code> is given a value larger than 500, only 500 results are returned. If this parameter is not used, then <code>DescribeVolumes</code> returns all results. You cannot specify this parameter and the volume IDs parameter in the same request.</p>', 'DescribeVpcEndpointConnectionNotificationsRequest$MaxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another request with the returned <code>NextToken</code> value.</p>', 'DescribeVpcEndpointConnectionsRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results of the initial request can be seen by sending another request with the returned <code>NextToken</code> value. This value can be between 5 and 1,000; if <code>MaxResults</code> is given a value larger than 1,000, only 1,000 results are returned.</p>', 'DescribeVpcEndpointServiceConfigurationsRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results of the initial request can be seen by sending another request with the returned <code>NextToken</code> value. This value can be between 5 and 1,000; if <code>MaxResults</code> is given a value larger than 1,000, only 1,000 results are returned.</p>', 'DescribeVpcEndpointServicePermissionsRequest$MaxResults' => '<p>The maximum number of results to return for the request in a single page. The remaining results of the initial request can be seen by sending another request with the returned <code>NextToken</code> value. This value can be between 5 and 1,000; if <code>MaxResults</code> is given a value larger than 1,000, only 1,000 results are returned.</p>', 'DescribeVpcEndpointServicesRequest$MaxResults' => '<p>The maximum number of items to return for this request. The request returns a token that you can specify in a subsequent call to get the next set of results.</p> <p>Constraint: If the value is greater than 1,000, we return only 1,000 items.</p>', 'DescribeVpcEndpointsRequest$MaxResults' => '<p>The maximum number of items to return for this request. The request returns a token that you can specify in a subsequent call to get the next set of results.</p> <p>Constraint: If the value is greater than 1,000, we return only 1,000 items.</p>', 'EbsBlockDevice$Iops' => '<p>The number of I/O operations per second (IOPS) that the volume supports. For <code>io1</code> volumes, this represents the number of IOPS that are provisioned for the volume. For <code>gp2</code> volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>Constraints: Range is 100-16,000 IOPS for <code>gp2</code> volumes and 100 to 64,000 IOPS for <code>io1</code> volumes in most Regions. Maximum <code>io1</code> IOPS of 64,000 is guaranteed only on <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based instances</a>. Other instance families guarantee performance up to 32,000 IOPS. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS Volume Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>Condition: This parameter is required for requests to create <code>io1</code> volumes; it is not used in requests to create <code>gp2</code>, <code>st1</code>, <code>sc1</code>, or <code>standard</code> volumes.</p>', 'EbsBlockDevice$VolumeSize' => '<p>The size of the volume, in GiB.</p> <p>Default: If you\'re creating the volume from a snapshot and don\'t specify a volume size, the default is the snapshot size.</p> <p>Constraints: 1-16384 for General Purpose SSD (<code>gp2</code>), 4-16384 for Provisioned IOPS SSD (<code>io1</code>), 500-16384 for Throughput Optimized HDD (<code>st1</code>), 500-16384 for Cold HDD (<code>sc1</code>), and 1-1024 for Magnetic (<code>standard</code>) volumes. If you specify a snapshot, the volume size must be equal to or larger than the snapshot size.</p>', 'FlowLog$MaxAggregationInterval' => '<p>The maximum interval of time, in seconds, during which a flow of packets is captured and aggregated into a flow log record.</p> <p>When a network interface is attached to a <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based instance</a>, the aggregation interval is always 60 seconds (1 minute) or less, regardless of the specified value.</p> <p>Valid Values: <code>60</code> | <code>600</code> </p>', 'GetCapacityReservationUsageResult$TotalInstanceCount' => '<p>The number of instances for which the Capacity Reservation reserves capacity.</p>', 'GetCapacityReservationUsageResult$AvailableInstanceCount' => '<p>The remaining capacity. Indicates the number of instances that can be launched in the Capacity Reservation.</p>', 'HostOffering$Duration' => '<p>The duration of the offering (in seconds).</p>', 'HostProperties$Cores' => '<p>The number of cores on the Dedicated Host.</p>', 'HostProperties$Sockets' => '<p>The number of sockets on the Dedicated Host.</p>', 'HostProperties$TotalVCpus' => '<p>The total number of vCPUs on the Dedicated Host.</p>', 'HostReservation$Count' => '<p>The number of Dedicated Hosts the reservation is associated with.</p>', 'HostReservation$Duration' => '<p>The length of the reservation\'s term, specified in seconds. Can be <code>31536000 (1 year)</code> | <code>94608000 (3 years)</code>.</p>', 'IcmpTypeCode$Code' => '<p>The ICMP code. A value of -1 means all codes for the specified ICMP type.</p>', 'IcmpTypeCode$Type' => '<p>The ICMP type. A value of -1 means all types.</p>', 'Instance$AmiLaunchIndex' => '<p>The AMI launch index, which can be used to find this instance in the launch group.</p>', 'InstanceCapacity$AvailableCapacity' => '<p>The number of instances that can be launched onto the Dedicated Host based on the host\'s available capacity.</p>', 'InstanceCapacity$TotalCapacity' => '<p>The total number of instances that can be launched onto the Dedicated Host if there are no instances running on it.</p>', 'InstanceCount$InstanceCount' => '<p>The number of listed Reserved Instances in the state specified by the <code>state</code>.</p>', 'InstanceMetadataOptionsRequest$HttpPutResponseHopLimit' => '<p>The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel.</p> <p>Default: 1</p> <p>Possible values: Integers from 1 to 64</p>', 'InstanceMetadataOptionsResponse$HttpPutResponseHopLimit' => '<p>The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel.</p> <p>Default: 1</p> <p>Possible values: Integers from 1 to 64</p>', 'InstanceNetworkInterfaceAttachment$DeviceIndex' => '<p>The index of the device on the instance for the network interface attachment.</p>', 'InstanceNetworkInterfaceSpecification$DeviceIndex' => '<p>The position of the network interface in the attachment order. A primary network interface has a device index of 0.</p> <p>If you specify a network interface when launching an instance, you must specify the device index.</p>', 'InstanceNetworkInterfaceSpecification$Ipv6AddressCount' => '<p>A number of IPv6 addresses to assign to the network interface. Amazon EC2 chooses the IPv6 addresses from the range of the subnet. You cannot specify this option and the option to assign specific IPv6 addresses in the same request. You can specify this option if you\'ve specified a minimum number of instances to launch.</p>', 'InstanceNetworkInterfaceSpecification$SecondaryPrivateIpAddressCount' => '<p>The number of secondary private IPv4 addresses. You can\'t specify this option and specify more than one private IP address using the private IP addresses option. You cannot specify this option if you\'re launching more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.</p>', 'InstanceState$Code' => '<p>The state of the instance as a 16-bit unsigned integer. </p> <p>The high byte is all of the bits between 2^8 and (2^16)-1, which equals decimal values between 256 and 65,535. These numerical values are used for internal purposes and should be ignored.</p> <p>The low byte is all of the bits between 2^0 and (2^8)-1, which equals decimal values between 0 and 255. </p> <p>The valid values for instance-state-code will all be in the range of the low byte and they are:</p> <ul> <li> <p> <code>0</code> : <code>pending</code> </p> </li> <li> <p> <code>16</code> : <code>running</code> </p> </li> <li> <p> <code>32</code> : <code>shutting-down</code> </p> </li> <li> <p> <code>48</code> : <code>terminated</code> </p> </li> <li> <p> <code>64</code> : <code>stopping</code> </p> </li> <li> <p> <code>80</code> : <code>stopped</code> </p> </li> </ul> <p>You can ignore the high byte value by zeroing out all of the bits above 2^8 or 256 in decimal.</p>', 'InstanceUsage$UsedInstanceCount' => '<p>The number of instances the AWS account currently has in the Capacity Reservation.</p>', 'IpPermission$FromPort' => '<p>The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of <code>-1</code> indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must specify all codes.</p>', 'IpPermission$ToPort' => '<p>The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of <code>-1</code> indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must specify all codes.</p>', 'LaunchTemplateCpuOptions$CoreCount' => '<p>The number of CPU cores for the instance.</p>', 'LaunchTemplateCpuOptions$ThreadsPerCore' => '<p>The number of threads per CPU core.</p>', 'LaunchTemplateCpuOptionsRequest$CoreCount' => '<p>The number of CPU cores for the instance.</p>', 'LaunchTemplateCpuOptionsRequest$ThreadsPerCore' => '<p>The number of threads per CPU core. To disable multithreading for the instance, specify a value of 1. Otherwise, specify the default value of 2.</p>', 'LaunchTemplateEbsBlockDevice$Iops' => '<p>The number of I/O operations per second (IOPS) that the volume supports. </p>', 'LaunchTemplateEbsBlockDevice$VolumeSize' => '<p>The size of the volume, in GiB.</p>', 'LaunchTemplateEbsBlockDeviceRequest$Iops' => '<p>The number of I/O operations per second (IOPS) that the volume supports. For io1, this represents the number of IOPS that are provisioned for the volume. For gp2, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting. For more information about General Purpose SSD baseline performance, I/O credits, and bursting, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS Volume Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>Condition: This parameter is required for requests to create io1 volumes; it is not used in requests to create gp2, st1, sc1, or standard volumes.</p>', 'LaunchTemplateEbsBlockDeviceRequest$VolumeSize' => '<p>The size of the volume, in GiB.</p> <p>Default: If you\'re creating the volume from a snapshot and don\'t specify a volume size, the default is the snapshot size.</p>', 'LaunchTemplateElasticInferenceAcceleratorResponse$Count' => '<p> The number of elastic inference accelerators to attach to the instance. </p> <p>Default: 1</p>', 'LaunchTemplateInstanceMetadataOptions$HttpPutResponseHopLimit' => '<p>The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel.</p> <p>Default: 1</p> <p>Possible values: Integers from 1 to 64</p>', 'LaunchTemplateInstanceMetadataOptionsRequest$HttpPutResponseHopLimit' => '<p>The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel.</p> <p>Default: 1</p> <p>Possible values: Integers from 1 to 64</p>', 'LaunchTemplateInstanceNetworkInterfaceSpecification$DeviceIndex' => '<p>The device index for the network interface attachment.</p>', 'LaunchTemplateInstanceNetworkInterfaceSpecification$Ipv6AddressCount' => '<p>The number of IPv6 addresses for the network interface.</p>', 'LaunchTemplateInstanceNetworkInterfaceSpecification$SecondaryPrivateIpAddressCount' => '<p>The number of secondary private IPv4 addresses for the network interface.</p>', 'LaunchTemplateInstanceNetworkInterfaceSpecificationRequest$DeviceIndex' => '<p>The device index for the network interface attachment.</p>', 'LaunchTemplateInstanceNetworkInterfaceSpecificationRequest$Ipv6AddressCount' => '<p>The number of IPv6 addresses to assign to a network interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. You can\'t use this option if specifying specific IPv6 addresses.</p>', 'LaunchTemplateInstanceNetworkInterfaceSpecificationRequest$SecondaryPrivateIpAddressCount' => '<p>The number of secondary private IPv4 addresses to assign to a network interface.</p>', 'LaunchTemplatePlacement$PartitionNumber' => '<p>The number of the partition the instance should launch in. Valid only if the placement group strategy is set to <code>partition</code>.</p>', 'LaunchTemplatePlacementRequest$PartitionNumber' => '<p>The number of the partition the instance should launch in. Valid only if the placement group strategy is set to <code>partition</code>.</p>', 'LaunchTemplateSpotMarketOptions$BlockDurationMinutes' => '<p>The required duration for the Spot Instances (also known as Spot blocks), in minutes. This value must be a multiple of 60 (60, 120, 180, 240, 300, or 360).</p>', 'LaunchTemplateSpotMarketOptionsRequest$BlockDurationMinutes' => '<p>The required duration for the Spot Instances (also known as Spot blocks), in minutes. This value must be a multiple of 60 (60, 120, 180, 240, 300, or 360).</p>', 'LocalGatewayVirtualInterface$Vlan' => '<p>The ID of the VLAN.</p>', 'LocalGatewayVirtualInterface$LocalBgpAsn' => '<p>The Border Gateway Protocol (BGP) Autonomous System Number (ASN) of the local gateway.</p>', 'LocalGatewayVirtualInterface$PeerBgpAsn' => '<p>The peer BGP ASN.</p>', 'ManagedPrefixList$MaxEntries' => '<p>The maximum number of entries for the prefix list.</p>', 'ModifyCapacityReservationRequest$InstanceCount' => '<p>The number of instances for which to reserve capacity.</p>', 'ModifyClientVpnEndpointRequest$VpnPort' => '<p>The port number to assign to the Client VPN endpoint for TCP and UDP traffic.</p> <p>Valid Values: <code>443</code> | <code>1194</code> </p> <p>Default Value: <code>443</code> </p>', 'ModifyInstanceMetadataOptionsRequest$HttpPutResponseHopLimit' => '<p>The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel. If no parameter is specified, the existing state is maintained.</p> <p>Possible values: Integers from 1 to 64</p>', 'ModifyInstancePlacementRequest$PartitionNumber' => '<p>Reserved for future use.</p>', 'ModifySpotFleetRequestRequest$TargetCapacity' => '<p>The size of the fleet.</p>', 'ModifySpotFleetRequestRequest$OnDemandTargetCapacity' => '<p>The number of On-Demand Instances in the fleet.</p>', 'ModifyTrafficMirrorFilterRuleRequest$RuleNumber' => '<p>The number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given direction. The rules are processed in ascending order by rule number.</p>', 'ModifyTrafficMirrorFilterRuleRequest$Protocol' => '<p>The protocol, for example TCP, to assign to the Traffic Mirror rule.</p>', 'ModifyTrafficMirrorSessionRequest$PacketLength' => '<p>The number of bytes in each packet to mirror. These are bytes after the VXLAN header. To mirror a subset, set this to the length (in bytes) to mirror. For example, if you set this value to 100, then the first 100 bytes that meet the filter criteria are copied to the target. Do not specify this parameter when you want to mirror the entire packet.</p>', 'ModifyTrafficMirrorSessionRequest$SessionNumber' => '<p>The session number determines the order in which sessions are evaluated when an interface is used by multiple sessions. The first session with a matching filter is the one that mirrors the packets.</p> <p>Valid values are 1-32766.</p>', 'ModifyTrafficMirrorSessionRequest$VirtualNetworkId' => '<p>The virtual network ID of the Traffic Mirror session.</p>', 'ModifyVolumeRequest$Size' => '<p>The target size of the volume, in GiB. The target volume size must be greater than or equal to than the existing size of the volume. For information about available EBS volume sizes, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS Volume Types</a>.</p> <p>Default: If no size is specified, the existing size is retained.</p>', 'ModifyVolumeRequest$Iops' => '<p>The target IOPS rate of the volume.</p> <p>This is only valid for Provisioned IOPS SSD (<code>io1</code>) volumes. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html#EBSVolumeTypes_piops">Provisioned IOPS SSD (io1) Volumes</a>.</p> <p>Default: If no IOPS value is specified, the existing value is retained.</p>', 'ModifyVpnTunnelOptionsSpecification$Phase1LifetimeSeconds' => '<p>The lifetime for phase 1 of the IKE negotiation, in seconds.</p> <p>Constraints: A value between 900 and 28,800.</p> <p>Default: <code>28800</code> </p>', 'ModifyVpnTunnelOptionsSpecification$Phase2LifetimeSeconds' => '<p>The lifetime for phase 2 of the IKE negotiation, in seconds.</p> <p>Constraints: A value between 900 and 3,600. The value must be less than the value for <code>Phase1LifetimeSeconds</code>.</p> <p>Default: <code>3600</code> </p>', 'ModifyVpnTunnelOptionsSpecification$RekeyMarginTimeSeconds' => '<p>The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for <code>RekeyFuzzPercentage</code>.</p> <p>Constraints: A value between 60 and half of <code>Phase2LifetimeSeconds</code>.</p> <p>Default: <code>540</code> </p>', 'ModifyVpnTunnelOptionsSpecification$RekeyFuzzPercentage' => '<p>The percentage of the rekey window (determined by <code>RekeyMarginTimeSeconds</code>) during which the rekey time is randomly selected.</p> <p>Constraints: A value between 0 and 100.</p> <p>Default: <code>100</code> </p>', 'ModifyVpnTunnelOptionsSpecification$ReplayWindowSize' => '<p>The number of packets in an IKE replay window.</p> <p>Constraints: A value between 64 and 2048.</p> <p>Default: <code>1024</code> </p>', 'ModifyVpnTunnelOptionsSpecification$DPDTimeoutSeconds' => '<p>The number of seconds after which a DPD timeout occurs.</p> <p>Constraints: A value between 0 and 30.</p> <p>Default: <code>30</code> </p>', 'NetworkAclEntry$RuleNumber' => '<p>The rule number for the entry. ACL entries are processed in ascending order by rule number.</p>', 'NetworkInterfaceAttachment$DeviceIndex' => '<p>The device index of the network interface attachment on the instance.</p>', 'OccurrenceDayRequestSet$member' => NULL, 'OccurrenceDaySet$member' => NULL, 'OnDemandOptions$MinTargetCapacity' => '<p>The minimum target capacity for On-Demand Instances in the fleet. If the minimum target capacity is not reached, the fleet launches no instances.</p>', 'OnDemandOptionsRequest$MinTargetCapacity' => '<p>The minimum target capacity for On-Demand Instances in the fleet. If the minimum target capacity is not reached, the fleet launches no instances.</p>', 'Phase1DHGroupNumbersListValue$Value' => '<p>The Diffie-Hellmann group number.</p>', 'Phase1DHGroupNumbersRequestListValue$Value' => '<p>The Diffie-Hellmann group number.</p>', 'Phase2DHGroupNumbersListValue$Value' => '<p>The Diffie-Hellmann group number.</p>', 'Phase2DHGroupNumbersRequestListValue$Value' => '<p>The Diffie-Hellmann group number.</p>', 'Placement$PartitionNumber' => '<p>The number of the partition the instance is in. Valid only if the placement group strategy is set to <code>partition</code>.</p> <p>This parameter is not supported by <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>.</p>', 'PlacementGroup$PartitionCount' => '<p>The number of partitions. Valid only if <b>strategy</b> is set to <code>partition</code>.</p>', 'PortRange$From' => '<p>The first port in the range.</p>', 'PortRange$To' => '<p>The last port in the range.</p>', 'PricingDetail$Count' => '<p>The number of reservations available for the price.</p>', 'PublicIpv4Pool$TotalAddressCount' => '<p>The total number of addresses.</p>', 'PublicIpv4Pool$TotalAvailableAddressCount' => '<p>The total number of available addresses.</p>', 'PublicIpv4PoolRange$AddressCount' => '<p>The number of addresses in the range.</p>', 'PublicIpv4PoolRange$AvailableAddressCount' => '<p>The number of available addresses in the range.</p>', 'Purchase$Duration' => '<p>The duration of the reservation\'s term in seconds.</p>', 'PurchaseRequest$InstanceCount' => '<p>The number of instances.</p>', 'PurchaseReservedInstancesOfferingRequest$InstanceCount' => '<p>The number of Reserved Instances to purchase.</p>', 'ReplaceNetworkAclEntryRequest$RuleNumber' => '<p>The rule number of the entry to replace.</p>', 'RequestSpotInstancesRequest$BlockDurationMinutes' => '<p>The required duration for the Spot Instances (also known as Spot blocks), in minutes. This value must be a multiple of 60 (60, 120, 180, 240, 300, or 360).</p> <p>The duration period starts as soon as your Spot Instance receives its instance ID. At the end of the duration period, Amazon EC2 marks the Spot Instance for termination and provides a Spot Instance termination notice, which gives the instance a two-minute warning before it terminates.</p> <p>You can\'t specify an Availability Zone group or a launch group if you specify a duration.</p>', 'RequestSpotInstancesRequest$InstanceCount' => '<p>The maximum number of Spot Instances to launch.</p> <p>Default: 1</p>', 'ReservedInstances$InstanceCount' => '<p>The number of reservations purchased.</p>', 'ReservedInstancesConfiguration$InstanceCount' => '<p>The number of modified Reserved Instances.</p> <note> <p>This is a required field for a request.</p> </note>', 'RevokeSecurityGroupEgressRequest$FromPort' => '<p>Not supported. Use a set of IP permissions to specify the port.</p>', 'RevokeSecurityGroupEgressRequest$ToPort' => '<p>Not supported. Use a set of IP permissions to specify the port.</p>', 'RevokeSecurityGroupIngressRequest$FromPort' => '<p>The start of port range for the TCP and UDP protocols, or an ICMP type number. For the ICMP type number, use <code>-1</code> to specify all ICMP types.</p>', 'RevokeSecurityGroupIngressRequest$ToPort' => '<p>The end of port range for the TCP and UDP protocols, or an ICMP code number. For the ICMP code number, use <code>-1</code> to specify all ICMP codes for the ICMP type.</p>', 'RunInstancesRequest$Ipv6AddressCount' => '<p>[EC2-VPC] The number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet. You cannot specify this option and the option to assign specific IPv6 addresses in the same request. You can specify this option if you\'ve specified a minimum number of instances to launch.</p> <p>You cannot specify this option and the network interfaces option in the same request.</p>', 'RunInstancesRequest$MaxCount' => '<p>The maximum number of instances to launch. If you specify more instances than Amazon EC2 can launch in the target Availability Zone, Amazon EC2 launches the largest possible number of instances above <code>MinCount</code>.</p> <p>Constraints: Between 1 and the maximum number you\'re allowed for the specified instance type. For more information about the default limits, and how to request an increase, see <a href="http://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2">How many instances can I run in Amazon EC2</a> in the Amazon EC2 FAQ.</p>', 'RunInstancesRequest$MinCount' => '<p>The minimum number of instances to launch. If you specify a minimum that is more instances than Amazon EC2 can launch in the target Availability Zone, Amazon EC2 launches no instances.</p> <p>Constraints: Between 1 and the maximum number you\'re allowed for the specified instance type. For more information about the default limits, and how to request an increase, see <a href="http://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2">How many instances can I run in Amazon EC2</a> in the Amazon EC2 General FAQ.</p>', 'RunScheduledInstancesRequest$InstanceCount' => '<p>The number of instances.</p> <p>Default: 1</p>', 'ScheduledInstance$InstanceCount' => '<p>The number of instances.</p>', 'ScheduledInstance$SlotDurationInHours' => '<p>The number of hours in the schedule.</p>', 'ScheduledInstance$TotalScheduledInstanceHours' => '<p>The total number of hours for a single instance for the entire term.</p>', 'ScheduledInstanceAvailability$AvailableInstanceCount' => '<p>The number of available instances.</p>', 'ScheduledInstanceAvailability$MaxTermDurationInDays' => '<p>The maximum term. The only possible value is 365 days.</p>', 'ScheduledInstanceAvailability$MinTermDurationInDays' => '<p>The minimum term. The only possible value is 365 days.</p>', 'ScheduledInstanceAvailability$SlotDurationInHours' => '<p>The number of hours in the schedule.</p>', 'ScheduledInstanceAvailability$TotalScheduledInstanceHours' => '<p>The total number of hours for a single instance for the entire term.</p>', 'ScheduledInstanceRecurrence$Interval' => '<p>The interval quantity. The interval unit depends on the value of <code>frequency</code>. For example, every 2 weeks or every 2 months.</p>', 'ScheduledInstanceRecurrenceRequest$Interval' => '<p>The interval quantity. The interval unit depends on the value of <code>Frequency</code>. For example, every 2 weeks or every 2 months.</p>', 'ScheduledInstancesEbs$Iops' => '<p>The number of I/O operations per second (IOPS) that the volume supports. For io1 volumes, this represents the number of IOPS that are provisioned for the volume. For <code>gp2</code> volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting. For more information about <code>gp2</code> baseline performance, I/O credits, and bursting, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS Volume Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>Constraint: Range is 100-20000 IOPS for <code>io1</code> volumes and 100-10000 IOPS for <code>gp2</code> volumes.</p> <p>Condition: This parameter is required for requests to create <code>io1</code>volumes; it is not used in requests to create <code>gp2</code>, <code>st1</code>, <code>sc1</code>, or <code>standard</code> volumes.</p>', 'ScheduledInstancesEbs$VolumeSize' => '<p>The size of the volume, in GiB.</p> <p>Default: If you\'re creating the volume from a snapshot and don\'t specify a volume size, the default is the snapshot size.</p>', 'ScheduledInstancesNetworkInterface$DeviceIndex' => '<p>The index of the device for the network interface attachment.</p>', 'ScheduledInstancesNetworkInterface$Ipv6AddressCount' => '<p>The number of IPv6 addresses to assign to the network interface. The IPv6 addresses are automatically selected from the subnet range.</p>', 'ScheduledInstancesNetworkInterface$SecondaryPrivateIpAddressCount' => '<p>The number of secondary private IPv4 addresses.</p>', 'Snapshot$VolumeSize' => '<p>The size of the volume, in GiB.</p>', 'SnapshotInfo$VolumeSize' => '<p>Size of the volume from which this snapshot was created.</p>', 'SpotFleetRequestConfigData$TargetCapacity' => '<p>The number of units to request for the Spot Fleet. You can choose to set the target capacity in terms of instances or a performance characteristic that is important to your application workload, such as vCPUs, memory, or I/O. If the request type is <code>maintain</code>, you can specify a target capacity of 0 and add capacity later.</p>', 'SpotFleetRequestConfigData$OnDemandTargetCapacity' => '<p>The number of On-Demand units to request. You can choose to set the target capacity in terms of instances or a performance characteristic that is important to your application workload, such as vCPUs, memory, or I/O. If the request type is <code>maintain</code>, you can specify a target capacity of 0 and add capacity later.</p>', 'SpotFleetRequestConfigData$InstancePoolsToUseCount' => '<p>The number of Spot pools across which to allocate your target Spot capacity. Valid only when Spot <b>AllocationStrategy</b> is set to <code>lowest-price</code>. Spot Fleet selects the cheapest Spot pools and evenly allocates your target Spot capacity across the number of Spot pools that you specify.</p>', 'SpotInstanceRequest$BlockDurationMinutes' => '<p>The duration for the Spot Instance, in minutes.</p>', 'SpotMarketOptions$BlockDurationMinutes' => '<p>The required duration for the Spot Instances (also known as Spot blocks), in minutes. This value must be a multiple of 60 (60, 120, 180, 240, 300, or 360).</p>', 'SpotOptions$InstancePoolsToUseCount' => '<p>The number of Spot pools across which to allocate your target Spot capacity. Valid only when <b>AllocationStrategy</b> is set to <code>lowest-price</code>. EC2 Fleet selects the cheapest Spot pools and evenly allocates your target Spot capacity across the number of Spot pools that you specify.</p>', 'SpotOptions$MinTargetCapacity' => '<p>The minimum target capacity for Spot Instances in the fleet. If the minimum target capacity is not reached, the fleet launches no instances.</p>', 'SpotOptionsRequest$InstancePoolsToUseCount' => '<p>The number of Spot pools across which to allocate your target Spot capacity. Valid only when Spot <b>AllocationStrategy</b> is set to <code>lowest-price</code>. EC2 Fleet selects the cheapest Spot pools and evenly allocates your target Spot capacity across the number of Spot pools that you specify.</p>', 'SpotOptionsRequest$MinTargetCapacity' => '<p>The minimum target capacity for Spot Instances in the fleet. If the minimum target capacity is not reached, the fleet launches no instances.</p>', 'StaleIpPermission$FromPort' => '<p>The start of the port range for the TCP and UDP protocols, or an ICMP type number. A value of <code>-1</code> indicates all ICMP types. </p>', 'StaleIpPermission$ToPort' => '<p>The end of the port range for the TCP and UDP protocols, or an ICMP type number. A value of <code>-1</code> indicates all ICMP types. </p>', 'Subnet$AvailableIpAddressCount' => '<p>The number of unused private IPv4 addresses in the subnet. The IPv4 addresses for any stopped instances are considered unavailable.</p>', 'TargetCapacitySpecification$TotalTargetCapacity' => '<p>The number of units to request, filled using <code>DefaultTargetCapacityType</code>.</p>', 'TargetCapacitySpecification$OnDemandTargetCapacity' => '<p>The number of On-Demand units to request. If you specify a target capacity for Spot units, you cannot specify a target capacity for On-Demand units.</p>', 'TargetCapacitySpecification$SpotTargetCapacity' => '<p>The maximum number of Spot units to launch. If you specify a target capacity for On-Demand units, you cannot specify a target capacity for Spot units.</p>', 'TargetCapacitySpecificationRequest$TotalTargetCapacity' => '<p>The number of units to request, filled using <code>DefaultTargetCapacityType</code>.</p>', 'TargetCapacitySpecificationRequest$OnDemandTargetCapacity' => '<p>The number of On-Demand units to request.</p>', 'TargetCapacitySpecificationRequest$SpotTargetCapacity' => '<p>The number of Spot units to request.</p>', 'TargetConfiguration$InstanceCount' => '<p>The number of instances the Convertible Reserved Instance offering can be applied to. This parameter is reserved and cannot be specified in a request</p>', 'TargetConfigurationRequest$InstanceCount' => '<p>The number of instances the Covertible Reserved Instance offering can be applied to. This parameter is reserved and cannot be specified in a request</p>', 'TrafficMirrorFilterRule$RuleNumber' => '<p>The rule number of the Traffic Mirror rule.</p>', 'TrafficMirrorFilterRule$Protocol' => '<p>The protocol assigned to the Traffic Mirror rule.</p>', 'TrafficMirrorPortRange$FromPort' => '<p>The start of the Traffic Mirror port range. This applies to the TCP and UDP protocols.</p>', 'TrafficMirrorPortRange$ToPort' => '<p>The end of the Traffic Mirror port range. This applies to the TCP and UDP protocols.</p>', 'TrafficMirrorPortRangeRequest$FromPort' => '<p>The first port in the Traffic Mirror port range. This applies to the TCP and UDP protocols.</p>', 'TrafficMirrorPortRangeRequest$ToPort' => '<p>The last port in the Traffic Mirror port range. This applies to the TCP and UDP protocols.</p>', 'TrafficMirrorSession$PacketLength' => '<p>The number of bytes in each packet to mirror. These are the bytes after the VXLAN header. To mirror a subset, set this to the length (in bytes) to mirror. For example, if you set this value to 100, then the first 100 bytes that meet the filter criteria are copied to the target. Do not specify this parameter when you want to mirror the entire packet</p>', 'TrafficMirrorSession$SessionNumber' => '<p>The session number determines the order in which sessions are evaluated when an interface is used by multiple sessions. The first session with a matching filter is the one that mirrors the packets.</p> <p>Valid values are 1-32766.</p>', 'TrafficMirrorSession$VirtualNetworkId' => '<p>The virtual network ID associated with the Traffic Mirror session.</p>', 'TunnelOption$Phase1LifetimeSeconds' => '<p>The lifetime for phase 1 of the IKE negotiation, in seconds.</p>', 'TunnelOption$Phase2LifetimeSeconds' => '<p>The lifetime for phase 2 of the IKE negotiation, in seconds.</p>', 'TunnelOption$RekeyMarginTimeSeconds' => '<p>The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the VPN connection performs an IKE rekey.</p>', 'TunnelOption$RekeyFuzzPercentage' => '<p>The percentage of the rekey window determined by <code>RekeyMarginTimeSeconds</code> during which the rekey time is randomly selected.</p>', 'TunnelOption$ReplayWindowSize' => '<p>The number of packets in an IKE replay window.</p>', 'TunnelOption$DpdTimeoutSeconds' => '<p>The number of seconds after which a DPD timeout occurs.</p>', 'VgwTelemetry$AcceptedRouteCount' => '<p>The number of accepted routes.</p>', 'Volume$Size' => '<p>The size of the volume, in GiBs.</p>', 'Volume$Iops' => '<p>The number of I/O operations per second (IOPS) that the volume supports. For Provisioned IOPS SSD volumes, this represents the number of IOPS that are provisioned for the volume. For General Purpose SSD volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS Volume Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> <p>Constraints: Range is 100-16,000 IOPS for <code>gp2</code> volumes and 100 to 64,000IOPS for <code>io1</code> volumes, in most Regions. The maximum IOPS for <code>io1</code> of 64,000 is guaranteed only on <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based instances</a>. Other instance families guarantee performance up to 32,000 IOPS.</p> <p>Condition: This parameter is required for requests to create <code>io1</code> volumes; it is not used in requests to create <code>gp2</code>, <code>st1</code>, <code>sc1</code>, or <code>standard</code> volumes.</p>', 'VolumeModification$TargetSize' => '<p>The target size of the volume, in GiB.</p>', 'VolumeModification$TargetIops' => '<p>The target IOPS rate of the volume.</p>', 'VolumeModification$OriginalSize' => '<p>The original size of the volume, in GiB.</p>', 'VolumeModification$OriginalIops' => '<p>The original IOPS rate of the volume.</p>', 'VpnTunnelOptionsSpecification$Phase1LifetimeSeconds' => '<p>The lifetime for phase 1 of the IKE negotiation, in seconds.</p> <p>Constraints: A value between 900 and 28,800.</p> <p>Default: <code>28800</code> </p>', 'VpnTunnelOptionsSpecification$Phase2LifetimeSeconds' => '<p>The lifetime for phase 2 of the IKE negotiation, in seconds.</p> <p>Constraints: A value between 900 and 3,600. The value must be less than the value for <code>Phase1LifetimeSeconds</code>.</p> <p>Default: <code>3600</code> </p>', 'VpnTunnelOptionsSpecification$RekeyMarginTimeSeconds' => '<p>The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the VPN connection performs an IKE rekey. The exact time of the rekey is randomly selected based on the value for <code>RekeyFuzzPercentage</code>.</p> <p>Constraints: A value between 60 and half of <code>Phase2LifetimeSeconds</code>.</p> <p>Default: <code>540</code> </p>', 'VpnTunnelOptionsSpecification$RekeyFuzzPercentage' => '<p>The percentage of the rekey window (determined by <code>RekeyMarginTimeSeconds</code>) during which the rekey time is randomly selected.</p> <p>Constraints: A value between 0 and 100.</p> <p>Default: <code>100</code> </p>', 'VpnTunnelOptionsSpecification$ReplayWindowSize' => '<p>The number of packets in an IKE replay window.</p> <p>Constraints: A value between 64 and 2048.</p> <p>Default: <code>1024</code> </p>', 'VpnTunnelOptionsSpecification$DPDTimeoutSeconds' => '<p>The number of seconds after which a DPD timeout occurs.</p> <p>Constraints: A value between 0 and 30.</p> <p>Default: <code>30</code> </p>', ], ], 'InterfacePermissionType' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkInterfacePermissionRequest$Permission' => '<p>The type of permission to grant.</p>', 'NetworkInterfacePermission$Permission' => '<p>The type of permission.</p>', ], ], 'InternetGateway' => [ 'base' => '<p>Describes an internet gateway.</p>', 'refs' => [ 'CreateInternetGatewayResult$InternetGateway' => '<p>Information about the internet gateway.</p>', 'InternetGatewayList$member' => NULL, ], ], 'InternetGatewayAttachment' => [ 'base' => '<p>Describes the attachment of a VPC to an internet gateway or an egress-only internet gateway.</p>', 'refs' => [ 'InternetGatewayAttachmentList$member' => NULL, ], ], 'InternetGatewayAttachmentList' => [ 'base' => NULL, 'refs' => [ 'EgressOnlyInternetGateway$Attachments' => '<p>Information about the attachment of the egress-only internet gateway.</p>', 'InternetGateway$Attachments' => '<p>Any VPCs attached to the internet gateway.</p>', ], ], 'InternetGatewayId' => [ 'base' => NULL, 'refs' => [ 'AttachInternetGatewayRequest$InternetGatewayId' => '<p>The ID of the internet gateway.</p>', 'DeleteInternetGatewayRequest$InternetGatewayId' => '<p>The ID of the internet gateway.</p>', 'DetachInternetGatewayRequest$InternetGatewayId' => '<p>The ID of the internet gateway.</p>', 'InternetGatewayIdList$member' => NULL, ], ], 'InternetGatewayIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeInternetGatewaysRequest$InternetGatewayIds' => '<p>One or more internet gateway IDs.</p> <p>Default: Describes all your internet gateways.</p>', ], ], 'InternetGatewayList' => [ 'base' => NULL, 'refs' => [ 'DescribeInternetGatewaysResult$InternetGateways' => '<p>Information about one or more internet gateways.</p>', ], ], 'IpPermission' => [ 'base' => '<p>Describes a set of permissions for a security group rule.</p>', 'refs' => [ 'IpPermissionList$member' => NULL, ], ], 'IpPermissionList' => [ 'base' => NULL, 'refs' => [ 'AuthorizeSecurityGroupEgressRequest$IpPermissions' => '<p>The sets of IP permissions. You can\'t specify a destination security group and a CIDR IP address range in the same set of permissions.</p>', 'AuthorizeSecurityGroupIngressRequest$IpPermissions' => '<p>The sets of IP permissions.</p>', 'RevokeSecurityGroupEgressRequest$IpPermissions' => '<p>The sets of IP permissions. You can\'t specify a destination security group and a CIDR IP address range in the same set of permissions.</p>', 'RevokeSecurityGroupIngressRequest$IpPermissions' => '<p>The sets of IP permissions. You can\'t specify a source security group and a CIDR IP address range in the same set of permissions.</p>', 'SecurityGroup$IpPermissions' => '<p>The inbound rules associated with the security group.</p>', 'SecurityGroup$IpPermissionsEgress' => '<p>[VPC only] The outbound rules associated with the security group.</p>', 'UpdateSecurityGroupRuleDescriptionsEgressRequest$IpPermissions' => '<p>The IP permissions for the security group rule.</p>', 'UpdateSecurityGroupRuleDescriptionsIngressRequest$IpPermissions' => '<p>The IP permissions for the security group rule. </p>', ], ], 'IpRange' => [ 'base' => '<p>Describes an IPv4 range.</p>', 'refs' => [ 'IpRangeList$member' => NULL, ], ], 'IpRangeList' => [ 'base' => NULL, 'refs' => [ 'IpPermission$IpRanges' => '<p>The IPv4 ranges.</p>', ], ], 'IpRanges' => [ 'base' => NULL, 'refs' => [ 'StaleIpPermission$IpRanges' => '<p>The IP ranges. Not applicable for stale security group rules.</p>', ], ], 'Ipv4PoolEc2Id' => [ 'base' => NULL, 'refs' => [ 'PublicIpv4PoolIdStringList$member' => NULL, ], ], 'Ipv6Address' => [ 'base' => NULL, 'refs' => [ 'ScheduledInstancesIpv6Address$Ipv6Address' => '<p>The IPv6 address.</p>', ], ], 'Ipv6AddressList' => [ 'base' => NULL, 'refs' => [ 'AssignIpv6AddressesRequest$Ipv6Addresses' => '<p>One or more specific IPv6 addresses to be assigned to the network interface. You can\'t use this option if you\'re specifying a number of IPv6 addresses.</p>', 'AssignIpv6AddressesResult$AssignedIpv6Addresses' => '<p>The IPv6 addresses assigned to the network interface.</p>', 'UnassignIpv6AddressesRequest$Ipv6Addresses' => '<p>The IPv6 addresses to unassign from the network interface.</p>', 'UnassignIpv6AddressesResult$UnassignedIpv6Addresses' => '<p>The IPv6 addresses that have been unassigned from the network interface.</p>', ], ], 'Ipv6CidrAssociation' => [ 'base' => '<p>Describes an IPv6 CIDR block association.</p>', 'refs' => [ 'Ipv6CidrAssociationSet$member' => NULL, ], ], 'Ipv6CidrAssociationSet' => [ 'base' => NULL, 'refs' => [ 'GetAssociatedIpv6PoolCidrsResult$Ipv6CidrAssociations' => '<p>Information about the IPv6 CIDR block associations.</p>', ], ], 'Ipv6CidrBlock' => [ 'base' => '<p>Describes an IPv6 CIDR block.</p>', 'refs' => [ 'Ipv6CidrBlockSet$member' => NULL, ], ], 'Ipv6CidrBlockSet' => [ 'base' => NULL, 'refs' => [ 'VpcPeeringConnectionVpcInfo$Ipv6CidrBlockSet' => '<p>The IPv6 CIDR block for the VPC.</p>', ], ], 'Ipv6Flag' => [ 'base' => NULL, 'refs' => [ 'NetworkInfo$Ipv6Supported' => '<p>Indicates whether IPv6 is supported.</p>', ], ], 'Ipv6Pool' => [ 'base' => '<p>Describes an IPv6 address pool.</p>', 'refs' => [ 'Ipv6PoolSet$member' => NULL, ], ], 'Ipv6PoolEc2Id' => [ 'base' => NULL, 'refs' => [ 'AssociateVpcCidrBlockRequest$Ipv6Pool' => '<p>The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.</p>', 'CreateVpcRequest$Ipv6Pool' => '<p>The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.</p>', 'GetAssociatedIpv6PoolCidrsRequest$PoolId' => '<p>The ID of the IPv6 address pool.</p>', 'Ipv6PoolIdList$member' => NULL, ], ], 'Ipv6PoolIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeIpv6PoolsRequest$PoolIds' => '<p>The IDs of the IPv6 address pools.</p>', ], ], 'Ipv6PoolMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeIpv6PoolsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', 'GetAssociatedIpv6PoolCidrsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'Ipv6PoolSet' => [ 'base' => NULL, 'refs' => [ 'DescribeIpv6PoolsResult$Ipv6Pools' => '<p>Information about the IPv6 address pools.</p>', ], ], 'Ipv6Range' => [ 'base' => '<p>[EC2-VPC only] Describes an IPv6 range.</p>', 'refs' => [ 'Ipv6RangeList$member' => NULL, ], ], 'Ipv6RangeList' => [ 'base' => NULL, 'refs' => [ 'IpPermission$Ipv6Ranges' => '<p>[VPC only] The IPv6 ranges.</p>', ], ], 'Ipv6SupportValue' => [ 'base' => NULL, 'refs' => [ 'CreateTransitGatewayVpcAttachmentRequestOptions$Ipv6Support' => '<p>Enable or disable IPv6 support. The default is <code>enable</code>.</p>', 'ModifyTransitGatewayVpcAttachmentRequestOptions$Ipv6Support' => '<p>Enable or disable IPv6 support. The default is <code>enable</code>.</p>', 'TransitGatewayVpcAttachmentOptions$Ipv6Support' => '<p>Indicates whether IPv6 support is disabled.</p>', ], ], 'KernelId' => [ 'base' => NULL, 'refs' => [ 'RegisterImageRequest$KernelId' => '<p>The ID of the kernel.</p>', 'RequestLaunchTemplateData$KernelId' => '<p>The ID of the kernel.</p> <important> <p>We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">User Provided Kernels</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> </important>', 'RequestSpotLaunchSpecification$KernelId' => '<p>The ID of the kernel.</p>', 'RunInstancesRequest$KernelId' => '<p>The ID of the kernel.</p> <important> <p>We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html"> PV-GRUB</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> </important>', 'ScheduledInstancesLaunchSpecification$KernelId' => '<p>The ID of the kernel.</p>', ], ], 'KeyNameStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeKeyPairsRequest$KeyNames' => '<p>The key pair names.</p> <p>Default: Describes all your key pairs.</p>', ], ], 'KeyPair' => [ 'base' => '<p>Describes a key pair.</p>', 'refs' => [], ], 'KeyPairId' => [ 'base' => NULL, 'refs' => [ 'DeleteKeyPairRequest$KeyPairId' => '<p>The ID of the key pair.</p>', 'KeyPairIdStringList$member' => NULL, ], ], 'KeyPairIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeKeyPairsRequest$KeyPairIds' => '<p>The IDs of the key pairs.</p>', ], ], 'KeyPairInfo' => [ 'base' => '<p>Describes a key pair.</p>', 'refs' => [ 'KeyPairList$member' => NULL, ], ], 'KeyPairList' => [ 'base' => NULL, 'refs' => [ 'DescribeKeyPairsResult$KeyPairs' => '<p>Information about the key pairs.</p>', ], ], 'KeyPairName' => [ 'base' => NULL, 'refs' => [ 'DeleteKeyPairRequest$KeyName' => '<p>The name of the key pair.</p>', 'KeyNameStringList$member' => NULL, 'RequestLaunchTemplateData$KeyName' => '<p>The name of the key pair. You can create a key pair using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html">CreateKeyPair</a> or <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html">ImportKeyPair</a>.</p> <important> <p>If you do not specify a key pair, you can\'t connect to the instance unless you choose an AMI that is configured to allow users another way to log in.</p> </important>', 'RequestSpotLaunchSpecification$KeyName' => '<p>The name of the key pair.</p>', 'RunInstancesRequest$KeyName' => '<p>The name of the key pair. You can create a key pair using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html">CreateKeyPair</a> or <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html">ImportKeyPair</a>.</p> <important> <p>If you do not specify a key pair, you can\'t connect to the instance unless you choose an AMI that is configured to allow users another way to log in.</p> </important>', 'ScheduledInstancesLaunchSpecification$KeyName' => '<p>The name of the key pair.</p>', ], ], 'KmsKeyId' => [ 'base' => NULL, 'refs' => [ 'CopyImageRequest$KmsKeyId' => '<p>An identifier for the symmetric AWS Key Management Service (AWS KMS) customer master key (CMK) to use when creating the encrypted volume. This parameter is only required if you want to use a non-default CMK; if this parameter is not specified, the default CMK for EBS is used. If a <code>KmsKeyId</code> is specified, the <code>Encrypted</code> flag must also be set. </p> <p>To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. When using an alias name, prefix it with "alias/". For example:</p> <ul> <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li> <li> <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code> </p> </li> </ul> <p>AWS parses <code>KmsKeyId</code> asynchronously, meaning that the action you call may appear to complete even though you provided an invalid identifier. This action will eventually report failure. </p> <p>The specified CMK must exist in the Region that the snapshot is being copied to. </p> <p>Amazon EBS does not support asymmetric CMKs.</p>', 'CopySnapshotRequest$KmsKeyId' => '<p>The identifier of the AWS Key Management Service (AWS KMS) customer master key (CMK) to use for Amazon EBS encryption. If this parameter is not specified, your AWS managed CMK for EBS is used. If <code>KmsKeyId</code> is specified, the encrypted state must be <code>true</code>.</p> <p>You can specify the CMK using any of the following:</p> <ul> <li> <p>Key ID. For example, key/1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li> <li> <p>Key alias. For example, alias/ExampleAlias.</p> </li> <li> <p>Key ARN. For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>.</p> </li> <li> <p>Alias ARN. For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:alias/<i>ExampleAlias</i>.</p> </li> </ul> <p>AWS authenticates the CMK asynchronously. Therefore, if you specify an ID, alias, or ARN that is not valid, the action can appear to complete, but eventually fails.</p>', 'CreateVolumeRequest$KmsKeyId' => '<p>The identifier of the AWS Key Management Service (AWS KMS) customer master key (CMK) to use for Amazon EBS encryption. If this parameter is not specified, your AWS managed CMK for EBS is used. If <code>KmsKeyId</code> is specified, the encrypted state must be <code>true</code>.</p> <p>You can specify the CMK using any of the following:</p> <ul> <li> <p>Key ID. For example, key/1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li> <li> <p>Key alias. For example, alias/ExampleAlias.</p> </li> <li> <p>Key ARN. For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>.</p> </li> <li> <p>Alias ARN. For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:alias/<i>ExampleAlias</i>.</p> </li> </ul> <p>AWS authenticates the CMK asynchronously. Therefore, if you specify an ID, alias, or ARN that is not valid, the action can appear to complete, but eventually fails.</p>', 'ImportImageRequest$KmsKeyId' => '<p>An identifier for the symmetric AWS Key Management Service (AWS KMS) customer master key (CMK) to use when creating the encrypted AMI. This parameter is only required if you want to use a non-default CMK; if this parameter is not specified, the default CMK for EBS is used. If a <code>KmsKeyId</code> is specified, the <code>Encrypted</code> flag must also be set. </p> <p>The CMK identifier may be provided in any of the following formats: </p> <ul> <li> <p>Key ID</p> </li> <li> <p>Key alias. The alias ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of the CMK, the AWS account ID of the CMK owner, the <code>alias</code> namespace, and then the CMK alias. For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:alias/<i>ExampleAlias</i>.</p> </li> <li> <p>ARN using key ID. The ID ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of the CMK, the AWS account ID of the CMK owner, the <code>key</code> namespace, and then the CMK ID. For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>.</p> </li> <li> <p>ARN using key alias. The alias ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of the CMK, the AWS account ID of the CMK owner, the <code>alias</code> namespace, and then the CMK alias. For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:alias/<i>ExampleAlias</i>. </p> </li> </ul> <p>AWS parses <code>KmsKeyId</code> asynchronously, meaning that the action you call may appear to complete even though you provided an invalid identifier. This action will eventually report failure. </p> <p>The specified CMK must exist in the Region that the AMI is being copied to.</p> <p>Amazon EBS does not support asymmetric CMKs.</p>', 'ImportImageResult$KmsKeyId' => '<p>The identifier for the symmetric AWS Key Management Service (AWS KMS) customer master key (CMK) that was used to create the encrypted AMI.</p>', 'ImportSnapshotRequest$KmsKeyId' => '<p>An identifier for the symmetric AWS Key Management Service (AWS KMS) customer master key (CMK) to use when creating the encrypted snapshot. This parameter is only required if you want to use a non-default CMK; if this parameter is not specified, the default CMK for EBS is used. If a <code>KmsKeyId</code> is specified, the <code>Encrypted</code> flag must also be set. </p> <p>The CMK identifier may be provided in any of the following formats: </p> <ul> <li> <p>Key ID</p> </li> <li> <p>Key alias. The alias ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of the CMK, the AWS account ID of the CMK owner, the <code>alias</code> namespace, and then the CMK alias. For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:alias/<i>ExampleAlias</i>.</p> </li> <li> <p>ARN using key ID. The ID ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of the CMK, the AWS account ID of the CMK owner, the <code>key</code> namespace, and then the CMK ID. For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>.</p> </li> <li> <p>ARN using key alias. The alias ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of the CMK, the AWS account ID of the CMK owner, the <code>alias</code> namespace, and then the CMK alias. For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:alias/<i>ExampleAlias</i>. </p> </li> </ul> <p>AWS parses <code>KmsKeyId</code> asynchronously, meaning that the action you call may appear to complete even though you provided an invalid identifier. This action will eventually report failure. </p> <p>The specified CMK must exist in the Region that the snapshot is being copied to.</p> <p>Amazon EBS does not support asymmetric CMKs.</p>', 'LaunchTemplateEbsBlockDevice$KmsKeyId' => '<p>The ARN of the AWS Key Management Service (AWS KMS) CMK used for encryption.</p>', 'LaunchTemplateEbsBlockDeviceRequest$KmsKeyId' => '<p>The ARN of the symmetric AWS Key Management Service (AWS KMS) CMK used for encryption.</p>', 'ModifyEbsDefaultKmsKeyIdRequest$KmsKeyId' => '<p>The identifier of the AWS Key Management Service (AWS KMS) customer master key (CMK) to use for Amazon EBS encryption. If this parameter is not specified, your AWS managed CMK for EBS is used. If <code>KmsKeyId</code> is specified, the encrypted state must be <code>true</code>.</p> <p>You can specify the CMK using any of the following:</p> <ul> <li> <p>Key ID. For example, key/1234abcd-12ab-34cd-56ef-1234567890ab.</p> </li> <li> <p>Key alias. For example, alias/ExampleAlias.</p> </li> <li> <p>Key ARN. For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>.</p> </li> <li> <p>Alias ARN. For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:alias/<i>ExampleAlias</i>.</p> </li> </ul> <p>AWS authenticates the CMK asynchronously. Therefore, if you specify an ID, alias, or ARN that is not valid, the action can appear to complete, but eventually fails.</p> <p>Amazon EBS does not support asymmetric CMKs.</p>', ], ], 'LastError' => [ 'base' => '<p>The last error that occurred for a VPC endpoint.</p>', 'refs' => [ 'VpcEndpoint$LastError' => '<p>The last error that occurred for VPC endpoint.</p>', ], ], 'LaunchPermission' => [ 'base' => '<p>Describes a launch permission.</p>', 'refs' => [ 'LaunchPermissionList$member' => NULL, ], ], 'LaunchPermissionList' => [ 'base' => NULL, 'refs' => [ 'ImageAttribute$LaunchPermissions' => '<p>The launch permissions.</p>', 'LaunchPermissionModifications$Add' => '<p>The AWS account ID to add to the list of launch permissions for the AMI.</p>', 'LaunchPermissionModifications$Remove' => '<p>The AWS account ID to remove from the list of launch permissions for the AMI.</p>', ], ], 'LaunchPermissionModifications' => [ 'base' => '<p>Describes a launch permission modification.</p>', 'refs' => [ 'ModifyImageAttributeRequest$LaunchPermission' => '<p>A new launch permission for the AMI.</p>', ], ], 'LaunchSpecification' => [ 'base' => '<p>Describes the launch specification for an instance.</p>', 'refs' => [ 'SpotInstanceRequest$LaunchSpecification' => '<p>Additional information for launching instances.</p>', ], ], 'LaunchSpecsList' => [ 'base' => NULL, 'refs' => [ 'SpotFleetRequestConfigData$LaunchSpecifications' => '<p>The launch specifications for the Spot Fleet request. If you specify <code>LaunchSpecifications</code>, you can\'t specify <code>LaunchTemplateConfigs</code>. If you include On-Demand capacity in your request, you must use <code>LaunchTemplateConfigs</code>.</p>', ], ], 'LaunchTemplate' => [ 'base' => '<p>Describes a launch template.</p>', 'refs' => [ 'CreateLaunchTemplateResult$LaunchTemplate' => '<p>Information about the launch template.</p>', 'DeleteLaunchTemplateResult$LaunchTemplate' => '<p>Information about the launch template.</p>', 'LaunchTemplateSet$member' => NULL, 'ModifyLaunchTemplateResult$LaunchTemplate' => '<p>Information about the launch template.</p>', ], ], 'LaunchTemplateAndOverridesResponse' => [ 'base' => '<p>Describes a launch template and overrides.</p>', 'refs' => [ 'CreateFleetError$LaunchTemplateAndOverrides' => '<p>The launch templates and overrides that were used for launching the instances. The values that you specify in the Overrides replace the values in the launch template.</p>', 'CreateFleetInstance$LaunchTemplateAndOverrides' => '<p>The launch templates and overrides that were used for launching the instances. The values that you specify in the Overrides replace the values in the launch template.</p>', 'DescribeFleetError$LaunchTemplateAndOverrides' => '<p>The launch templates and overrides that were used for launching the instances. The values that you specify in the Overrides replace the values in the launch template.</p>', 'DescribeFleetsInstances$LaunchTemplateAndOverrides' => '<p>The launch templates and overrides that were used for launching the instances. The values that you specify in the Overrides replace the values in the launch template.</p>', ], ], 'LaunchTemplateBlockDeviceMapping' => [ 'base' => '<p>Describes a block device mapping.</p>', 'refs' => [ 'LaunchTemplateBlockDeviceMappingList$member' => NULL, ], ], 'LaunchTemplateBlockDeviceMappingList' => [ 'base' => NULL, 'refs' => [ 'ResponseLaunchTemplateData$BlockDeviceMappings' => '<p>The block device mappings.</p>', ], ], 'LaunchTemplateBlockDeviceMappingRequest' => [ 'base' => '<p>Describes a block device mapping.</p>', 'refs' => [ 'LaunchTemplateBlockDeviceMappingRequestList$member' => NULL, ], ], 'LaunchTemplateBlockDeviceMappingRequestList' => [ 'base' => NULL, 'refs' => [ 'RequestLaunchTemplateData$BlockDeviceMappings' => '<p>The block device mapping.</p>', ], ], 'LaunchTemplateCapacityReservationSpecificationRequest' => [ 'base' => '<p>Describes an instance\'s Capacity Reservation targeting option. You can specify only one option at a time. Use the <code>CapacityReservationPreference</code> parameter to configure the instance to run in On-Demand capacity or to run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone). Use the <code>CapacityReservationTarget</code> parameter to explicitly target a specific Capacity Reservation or a Capacity Reservation group.</p>', 'refs' => [ 'RequestLaunchTemplateData$CapacityReservationSpecification' => '<p>The Capacity Reservation targeting option. If you do not specify this parameter, the instance\'s Capacity Reservation preference defaults to <code>open</code>, which enables it to run in any open Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).</p>', ], ], 'LaunchTemplateCapacityReservationSpecificationResponse' => [ 'base' => '<p>Information about the Capacity Reservation targeting option.</p>', 'refs' => [ 'ResponseLaunchTemplateData$CapacityReservationSpecification' => '<p>Information about the Capacity Reservation targeting option.</p>', ], ], 'LaunchTemplateConfig' => [ 'base' => '<p>Describes a launch template and overrides.</p>', 'refs' => [ 'LaunchTemplateConfigList$member' => NULL, ], ], 'LaunchTemplateConfigList' => [ 'base' => NULL, 'refs' => [ 'SpotFleetRequestConfigData$LaunchTemplateConfigs' => '<p>The launch template and overrides. If you specify <code>LaunchTemplateConfigs</code>, you can\'t specify <code>LaunchSpecifications</code>. If you include On-Demand capacity in your request, you must use <code>LaunchTemplateConfigs</code>.</p>', ], ], 'LaunchTemplateCpuOptions' => [ 'base' => '<p>The CPU options for the instance.</p>', 'refs' => [ 'ResponseLaunchTemplateData$CpuOptions' => '<p>The CPU options for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimizing CPU Options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', ], ], 'LaunchTemplateCpuOptionsRequest' => [ 'base' => '<p>The CPU options for the instance. Both the core count and threads per core must be specified in the request.</p>', 'refs' => [ 'RequestLaunchTemplateData$CpuOptions' => '<p>The CPU options for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimizing CPU Options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', ], ], 'LaunchTemplateEbsBlockDevice' => [ 'base' => '<p>Describes a block device for an EBS volume.</p>', 'refs' => [ 'LaunchTemplateBlockDeviceMapping$Ebs' => '<p>Information about the block device for an EBS volume.</p>', ], ], 'LaunchTemplateEbsBlockDeviceRequest' => [ 'base' => '<p>The parameters for a block device for an EBS volume.</p>', 'refs' => [ 'LaunchTemplateBlockDeviceMappingRequest$Ebs' => '<p>Parameters used to automatically set up EBS volumes when the instance is launched.</p>', ], ], 'LaunchTemplateElasticInferenceAccelerator' => [ 'base' => '<p> Describes an elastic inference accelerator. </p>', 'refs' => [ 'LaunchTemplateElasticInferenceAcceleratorList$member' => NULL, ], ], 'LaunchTemplateElasticInferenceAcceleratorCount' => [ 'base' => NULL, 'refs' => [ 'LaunchTemplateElasticInferenceAccelerator$Count' => '<p> The number of elastic inference accelerators to attach to the instance. </p> <p>Default: 1</p>', ], ], 'LaunchTemplateElasticInferenceAcceleratorList' => [ 'base' => NULL, 'refs' => [ 'RequestLaunchTemplateData$ElasticInferenceAccelerators' => '<p> The elastic inference accelerator for the instance. </p>', ], ], 'LaunchTemplateElasticInferenceAcceleratorResponse' => [ 'base' => '<p> Describes an elastic inference accelerator. </p>', 'refs' => [ 'LaunchTemplateElasticInferenceAcceleratorResponseList$member' => NULL, ], ], 'LaunchTemplateElasticInferenceAcceleratorResponseList' => [ 'base' => NULL, 'refs' => [ 'ResponseLaunchTemplateData$ElasticInferenceAccelerators' => '<p> The elastic inference accelerator for the instance. </p>', ], ], 'LaunchTemplateErrorCode' => [ 'base' => NULL, 'refs' => [ 'ResponseError$Code' => '<p>The error code.</p>', ], ], 'LaunchTemplateHibernationOptions' => [ 'base' => '<p>Indicates whether an instance is configured for hibernation.</p>', 'refs' => [ 'ResponseLaunchTemplateData$HibernationOptions' => '<p>Indicates whether an instance is configured for hibernation. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate Your Instance</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', ], ], 'LaunchTemplateHibernationOptionsRequest' => [ 'base' => '<p>Indicates whether the instance is configured for hibernation. This parameter is valid only if the instance meets the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites">hibernation prerequisites</a>.</p>', 'refs' => [ 'RequestLaunchTemplateData$HibernationOptions' => '<p>Indicates whether an instance is enabled for hibernation. This parameter is valid only if the instance meets the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites">hibernation prerequisites</a>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate Your Instance</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', ], ], 'LaunchTemplateHttpTokensState' => [ 'base' => NULL, 'refs' => [ 'LaunchTemplateInstanceMetadataOptions$HttpTokens' => '<p>The state of token usage for your instance metadata requests. If the parameter is not specified in the request, the default state is <code>optional</code>.</p> <p>If the state is <code>optional</code>, you can choose to retrieve instance metadata with or without a signed token header on your request. If you retrieve the IAM role credentials without a token, the version 1.0 role credentials are returned. If you retrieve the IAM role credentials using a valid signed token, the version 2.0 role credentials are returned.</p> <p>If the state is <code>required</code>, you must send a signed token header with any instance metadata retrieval requests. In this state, retrieving the IAM role credentials always returns the version 2.0 credentials; the version 1.0 credentials are not available.</p>', 'LaunchTemplateInstanceMetadataOptionsRequest$HttpTokens' => '<p>The state of token usage for your instance metadata requests. If the parameter is not specified in the request, the default state is <code>optional</code>.</p> <p>If the state is <code>optional</code>, you can choose to retrieve instance metadata with or without a signed token header on your request. If you retrieve the IAM role credentials without a token, the version 1.0 role credentials are returned. If you retrieve the IAM role credentials using a valid signed token, the version 2.0 role credentials are returned.</p> <p>If the state is <code>required</code>, you must send a signed token header with any instance metadata retrieval requests. In this state, retrieving the IAM role credentials always returns the version 2.0 credentials; the version 1.0 credentials are not available.</p>', ], ], 'LaunchTemplateIamInstanceProfileSpecification' => [ 'base' => '<p>Describes an IAM instance profile.</p>', 'refs' => [ 'ResponseLaunchTemplateData$IamInstanceProfile' => '<p>The IAM instance profile.</p>', ], ], 'LaunchTemplateIamInstanceProfileSpecificationRequest' => [ 'base' => '<p>An IAM instance profile.</p>', 'refs' => [ 'RequestLaunchTemplateData$IamInstanceProfile' => '<p>The IAM instance profile.</p>', ], ], 'LaunchTemplateId' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchTemplateVersionRequest$LaunchTemplateId' => '<p>The ID of the launch template. You must specify either the launch template ID or launch template name in the request.</p>', 'DeleteLaunchTemplateRequest$LaunchTemplateId' => '<p>The ID of the launch template. You must specify either the launch template ID or launch template name in the request.</p>', 'DeleteLaunchTemplateVersionsRequest$LaunchTemplateId' => '<p>The ID of the launch template. You must specify either the launch template ID or launch template name in the request.</p>', 'DescribeLaunchTemplateVersionsRequest$LaunchTemplateId' => '<p>The ID of the launch template. To describe one or more versions of a specified launch template, you must specify either the launch template ID or the launch template name in the request. To describe all the latest or default launch template versions in your account, you must omit this parameter.</p>', 'FleetLaunchTemplateSpecificationRequest$LaunchTemplateId' => '<p>The ID of the launch template. If you specify the template ID, you can\'t specify the template name.</p>', 'LaunchTemplateIdStringList$member' => NULL, 'LaunchTemplateSpecification$LaunchTemplateId' => '<p>The ID of the launch template.</p>', 'ModifyLaunchTemplateRequest$LaunchTemplateId' => '<p>The ID of the launch template. You must specify either the launch template ID or launch template name in the request.</p>', ], ], 'LaunchTemplateIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeLaunchTemplatesRequest$LaunchTemplateIds' => '<p>One or more launch template IDs.</p>', ], ], 'LaunchTemplateInstanceMarketOptions' => [ 'base' => '<p>The market (purchasing) option for the instances.</p>', 'refs' => [ 'ResponseLaunchTemplateData$InstanceMarketOptions' => '<p>The market (purchasing) option for the instances.</p>', ], ], 'LaunchTemplateInstanceMarketOptionsRequest' => [ 'base' => '<p>The market (purchasing) option for the instances.</p>', 'refs' => [ 'RequestLaunchTemplateData$InstanceMarketOptions' => '<p>The market (purchasing) option for the instances.</p>', ], ], 'LaunchTemplateInstanceMetadataEndpointState' => [ 'base' => NULL, 'refs' => [ 'LaunchTemplateInstanceMetadataOptions$HttpEndpoint' => '<p>This parameter enables or disables the HTTP metadata endpoint on your instances. If the parameter is not specified, the default state is <code>enabled</code>.</p> <note> <p>If you specify a value of <code>disabled</code>, you will not be able to access your instance metadata. </p> </note>', 'LaunchTemplateInstanceMetadataOptionsRequest$HttpEndpoint' => '<p>This parameter enables or disables the HTTP metadata endpoint on your instances. If the parameter is not specified, the default state is <code>enabled</code>.</p> <note> <p>If you specify a value of <code>disabled</code>, you will not be able to access your instance metadata. </p> </note>', ], ], 'LaunchTemplateInstanceMetadataOptions' => [ 'base' => '<p>The metadata options for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance Metadata and User Data</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'refs' => [ 'ResponseLaunchTemplateData$MetadataOptions' => '<p>The metadata options for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance Metadata and User Data</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', ], ], 'LaunchTemplateInstanceMetadataOptionsRequest' => [ 'base' => '<p>The metadata options for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance Metadata and User Data</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', 'refs' => [ 'RequestLaunchTemplateData$MetadataOptions' => '<p>The metadata options for the instance. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance Metadata and User Data</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', ], ], 'LaunchTemplateInstanceMetadataOptionsState' => [ 'base' => NULL, 'refs' => [ 'LaunchTemplateInstanceMetadataOptions$State' => '<p>The state of the metadata option changes.</p> <p> <code>pending</code> - The metadata options are being updated and the instance is not ready to process metadata traffic with the new selection.</p> <p> <code>applied</code> - The metadata options have been successfully applied on the instance.</p>', ], ], 'LaunchTemplateInstanceNetworkInterfaceSpecification' => [ 'base' => '<p>Describes a network interface.</p>', 'refs' => [ 'LaunchTemplateInstanceNetworkInterfaceSpecificationList$member' => NULL, ], ], 'LaunchTemplateInstanceNetworkInterfaceSpecificationList' => [ 'base' => NULL, 'refs' => [ 'ResponseLaunchTemplateData$NetworkInterfaces' => '<p>The network interfaces.</p>', ], ], 'LaunchTemplateInstanceNetworkInterfaceSpecificationRequest' => [ 'base' => '<p>The parameters for a network interface.</p>', 'refs' => [ 'LaunchTemplateInstanceNetworkInterfaceSpecificationRequestList$member' => NULL, ], ], 'LaunchTemplateInstanceNetworkInterfaceSpecificationRequestList' => [ 'base' => NULL, 'refs' => [ 'RequestLaunchTemplateData$NetworkInterfaces' => '<p>One or more network interfaces. If you specify a network interface, you must specify any security groups and subnets as part of the network interface.</p>', ], ], 'LaunchTemplateLicenseConfiguration' => [ 'base' => '<p>Describes a license configuration.</p>', 'refs' => [ 'LaunchTemplateLicenseList$member' => NULL, ], ], 'LaunchTemplateLicenseConfigurationRequest' => [ 'base' => '<p>Describes a license configuration.</p>', 'refs' => [ 'LaunchTemplateLicenseSpecificationListRequest$member' => NULL, ], ], 'LaunchTemplateLicenseList' => [ 'base' => NULL, 'refs' => [ 'ResponseLaunchTemplateData$LicenseSpecifications' => '<p>The license configurations.</p>', ], ], 'LaunchTemplateLicenseSpecificationListRequest' => [ 'base' => NULL, 'refs' => [ 'RequestLaunchTemplateData$LicenseSpecifications' => '<p>The license configurations.</p>', ], ], 'LaunchTemplateName' => [ 'base' => NULL, 'refs' => [ 'CreateLaunchTemplateRequest$LaunchTemplateName' => '<p>A name for the launch template.</p>', 'CreateLaunchTemplateVersionRequest$LaunchTemplateName' => '<p>The name of the launch template. You must specify either the launch template ID or launch template name in the request.</p>', 'DeleteLaunchTemplateRequest$LaunchTemplateName' => '<p>The name of the launch template. You must specify either the launch template ID or launch template name in the request.</p>', 'DeleteLaunchTemplateVersionsRequest$LaunchTemplateName' => '<p>The name of the launch template. You must specify either the launch template ID or launch template name in the request.</p>', 'DescribeLaunchTemplateVersionsRequest$LaunchTemplateName' => '<p>The name of the launch template. To describe one or more versions of a specified launch template, you must specify either the launch template ID or the launch template name in the request. To describe all the latest or default launch template versions in your account, you must omit this parameter.</p>', 'FleetLaunchTemplateSpecification$LaunchTemplateName' => '<p>The name of the launch template. If you specify the template name, you can\'t specify the template ID.</p>', 'FleetLaunchTemplateSpecificationRequest$LaunchTemplateName' => '<p>The name of the launch template. If you specify the template name, you can\'t specify the template ID.</p>', 'LaunchTemplate$LaunchTemplateName' => '<p>The name of the launch template.</p>', 'LaunchTemplateNameStringList$member' => NULL, 'LaunchTemplateVersion$LaunchTemplateName' => '<p>The name of the launch template.</p>', 'ModifyLaunchTemplateRequest$LaunchTemplateName' => '<p>The name of the launch template. You must specify either the launch template ID or launch template name in the request.</p>', ], ], 'LaunchTemplateNameStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeLaunchTemplatesRequest$LaunchTemplateNames' => '<p>One or more launch template names.</p>', ], ], 'LaunchTemplateOverrides' => [ 'base' => '<p>Describes overrides for a launch template.</p>', 'refs' => [ 'LaunchTemplateOverridesList$member' => NULL, ], ], 'LaunchTemplateOverridesList' => [ 'base' => NULL, 'refs' => [ 'LaunchTemplateConfig$Overrides' => '<p>Any parameters that you specify override the same parameters in the launch template.</p>', ], ], 'LaunchTemplatePlacement' => [ 'base' => '<p>Describes the placement of an instance.</p>', 'refs' => [ 'ResponseLaunchTemplateData$Placement' => '<p>The placement of the instance.</p>', ], ], 'LaunchTemplatePlacementRequest' => [ 'base' => '<p>Describes the placement of an instance.</p>', 'refs' => [ 'RequestLaunchTemplateData$Placement' => '<p>The placement for the instance.</p>', ], ], 'LaunchTemplateSet' => [ 'base' => NULL, 'refs' => [ 'DescribeLaunchTemplatesResult$LaunchTemplates' => '<p>Information about the launch templates.</p>', ], ], 'LaunchTemplateSpecification' => [ 'base' => '<p>The launch template to use. You must specify either the launch template ID or launch template name in the request, but not both.</p>', 'refs' => [ 'RunInstancesRequest$LaunchTemplate' => '<p>The launch template to use to launch the instances. Any parameters that you specify in <a>RunInstances</a> override the same parameters in the launch template. You can specify either the name or ID of a launch template, but not both.</p>', ], ], 'LaunchTemplateSpotMarketOptions' => [ 'base' => '<p>The options for Spot Instances.</p>', 'refs' => [ 'LaunchTemplateInstanceMarketOptions$SpotOptions' => '<p>The options for Spot Instances.</p>', ], ], 'LaunchTemplateSpotMarketOptionsRequest' => [ 'base' => '<p>The options for Spot Instances.</p>', 'refs' => [ 'LaunchTemplateInstanceMarketOptionsRequest$SpotOptions' => '<p>The options for Spot Instances.</p>', ], ], 'LaunchTemplateTagSpecification' => [ 'base' => '<p>The tag specification for the launch template.</p>', 'refs' => [ 'LaunchTemplateTagSpecificationList$member' => NULL, ], ], 'LaunchTemplateTagSpecificationList' => [ 'base' => NULL, 'refs' => [ 'ResponseLaunchTemplateData$TagSpecifications' => '<p>The tags.</p>', ], ], 'LaunchTemplateTagSpecificationRequest' => [ 'base' => '<p>The tags specification for the launch template.</p>', 'refs' => [ 'LaunchTemplateTagSpecificationRequestList$member' => NULL, ], ], 'LaunchTemplateTagSpecificationRequestList' => [ 'base' => NULL, 'refs' => [ 'RequestLaunchTemplateData$TagSpecifications' => '<p>The tags to apply to the resources during launch. You can only tag instances and volumes on launch. The specified tags are applied to all instances or volumes that are created during launch. To tag a resource after it has been created, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>.</p>', ], ], 'LaunchTemplateVersion' => [ 'base' => '<p>Describes a launch template version.</p>', 'refs' => [ 'CreateLaunchTemplateVersionResult$LaunchTemplateVersion' => '<p>Information about the launch template version.</p>', 'LaunchTemplateVersionSet$member' => NULL, ], ], 'LaunchTemplateVersionSet' => [ 'base' => NULL, 'refs' => [ 'DescribeLaunchTemplateVersionsResult$LaunchTemplateVersions' => '<p>Information about the launch template versions.</p>', ], ], 'LaunchTemplatesMonitoring' => [ 'base' => '<p>Describes the monitoring for the instance.</p>', 'refs' => [ 'ResponseLaunchTemplateData$Monitoring' => '<p>The monitoring for the instance.</p>', ], ], 'LaunchTemplatesMonitoringRequest' => [ 'base' => '<p>Describes the monitoring for the instance.</p>', 'refs' => [ 'RequestLaunchTemplateData$Monitoring' => '<p>The monitoring for the instance.</p>', ], ], 'LicenseConfiguration' => [ 'base' => '<p>Describes a license configuration.</p>', 'refs' => [ 'LicenseList$member' => NULL, ], ], 'LicenseConfigurationRequest' => [ 'base' => '<p>Describes a license configuration.</p>', 'refs' => [ 'LicenseSpecificationListRequest$member' => NULL, ], ], 'LicenseList' => [ 'base' => NULL, 'refs' => [ 'Instance$Licenses' => '<p>The license configurations.</p>', ], ], 'LicenseSpecificationListRequest' => [ 'base' => NULL, 'refs' => [ 'RunInstancesRequest$LicenseSpecifications' => '<p>The license configurations.</p>', ], ], 'ListingState' => [ 'base' => NULL, 'refs' => [ 'InstanceCount$State' => '<p>The states of the listed Reserved Instances.</p>', ], ], 'ListingStatus' => [ 'base' => NULL, 'refs' => [ 'ReservedInstancesListing$Status' => '<p>The status of the Reserved Instance listing.</p>', ], ], 'LoadBalancersConfig' => [ 'base' => '<p>Describes the Classic Load Balancers and target groups to attach to a Spot Fleet request.</p>', 'refs' => [ 'SpotFleetRequestConfigData$LoadBalancersConfig' => '<p>One or more Classic Load Balancers and target groups to attach to the Spot Fleet request. Spot Fleet registers the running Spot Instances with the specified Classic Load Balancers and target groups.</p> <p>With Network Load Balancers, Spot Fleet cannot register instances that have the following instance types: C1, CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2, M3, and T1.</p>', ], ], 'LoadPermission' => [ 'base' => '<p>Describes a load permission.</p>', 'refs' => [ 'LoadPermissionList$member' => NULL, ], ], 'LoadPermissionList' => [ 'base' => NULL, 'refs' => [ 'FpgaImageAttribute$LoadPermissions' => '<p>The load permissions.</p>', ], ], 'LoadPermissionListRequest' => [ 'base' => NULL, 'refs' => [ 'LoadPermissionModifications$Add' => '<p>The load permissions to add.</p>', 'LoadPermissionModifications$Remove' => '<p>The load permissions to remove.</p>', ], ], 'LoadPermissionModifications' => [ 'base' => '<p>Describes modifications to the load permissions of an Amazon FPGA image (AFI).</p>', 'refs' => [ 'ModifyFpgaImageAttributeRequest$LoadPermission' => '<p>The load permission for the AFI.</p>', ], ], 'LoadPermissionRequest' => [ 'base' => '<p>Describes a load permission.</p>', 'refs' => [ 'LoadPermissionListRequest$member' => NULL, ], ], 'LocalGateway' => [ 'base' => '<p>Describes a local gateway.</p>', 'refs' => [ 'LocalGatewaySet$member' => NULL, ], ], 'LocalGatewayId' => [ 'base' => NULL, 'refs' => [ 'CreateRouteRequest$LocalGatewayId' => '<p>The ID of the local gateway.</p>', 'LocalGateway$LocalGatewayId' => '<p>The ID of the local gateway.</p>', 'LocalGatewayIdSet$member' => NULL, 'LocalGatewayRouteTable$LocalGatewayId' => '<p>The ID of the local gateway.</p>', 'LocalGatewayRouteTableVirtualInterfaceGroupAssociation$LocalGatewayRouteTableId' => '<p>The ID of the local gateway route table.</p>', 'ReplaceRouteRequest$LocalGatewayId' => '<p>The ID of the local gateway.</p>', ], ], 'LocalGatewayIdSet' => [ 'base' => NULL, 'refs' => [ 'DescribeLocalGatewaysRequest$LocalGatewayIds' => '<p>One or more filters.</p> <ul> <li> <p> <code>local-gateway-id</code> - The ID of a local gateway.</p> </li> <li> <p> <code>local-gateway-route-table-id</code> - The ID of the local gateway route table.</p> </li> <li> <p> <code>local-gateway-route-table-virtual-interface-group-association-id</code> - The ID of the association.</p> </li> <li> <p> <code>local-gateway-route-table-virtual-interface-group-id</code> - The ID of the virtual interface group.</p> </li> <li> <p> <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost.</p> </li> <li> <p> <code>state</code> - The state of the association.</p> </li> </ul>', ], ], 'LocalGatewayMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', 'DescribeLocalGatewayRouteTableVpcAssociationsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', 'DescribeLocalGatewayRouteTablesRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', 'DescribeLocalGatewayVirtualInterfaceGroupsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', 'DescribeLocalGatewayVirtualInterfacesRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', 'DescribeLocalGatewaysRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'LocalGatewayRoute' => [ 'base' => '<p>Describes a route for a local gateway route table.</p>', 'refs' => [ 'CreateLocalGatewayRouteResult$Route' => '<p>Information about the route.</p>', 'DeleteLocalGatewayRouteResult$Route' => '<p>Information about the route.</p>', 'LocalGatewayRouteList$member' => NULL, ], ], 'LocalGatewayRouteList' => [ 'base' => NULL, 'refs' => [ 'SearchLocalGatewayRoutesResult$Routes' => '<p>Information about the routes.</p>', ], ], 'LocalGatewayRouteState' => [ 'base' => NULL, 'refs' => [ 'LocalGatewayRoute$State' => '<p>The state of the route.</p>', ], ], 'LocalGatewayRouteTable' => [ 'base' => '<p>Describes a local gateway route table.</p>', 'refs' => [ 'LocalGatewayRouteTableSet$member' => NULL, ], ], 'LocalGatewayRouteTableIdSet' => [ 'base' => NULL, 'refs' => [ 'DescribeLocalGatewayRouteTablesRequest$LocalGatewayRouteTableIds' => '<p>The IDs of the local gateway route tables.</p>', ], ], 'LocalGatewayRouteTableSet' => [ 'base' => NULL, 'refs' => [ 'DescribeLocalGatewayRouteTablesResult$LocalGatewayRouteTables' => '<p>Information about the local gateway route tables.</p>', ], ], 'LocalGatewayRouteTableVirtualInterfaceGroupAssociation' => [ 'base' => '<p>Describes an association between a local gateway route table and a virtual interface group.</p>', 'refs' => [ 'LocalGatewayRouteTableVirtualInterfaceGroupAssociationSet$member' => NULL, ], ], 'LocalGatewayRouteTableVirtualInterfaceGroupAssociationId' => [ 'base' => NULL, 'refs' => [ 'LocalGatewayRouteTableVirtualInterfaceGroupAssociation$LocalGatewayRouteTableVirtualInterfaceGroupAssociationId' => '<p>The ID of the association.</p>', 'LocalGatewayRouteTableVirtualInterfaceGroupAssociationIdSet$member' => NULL, ], ], 'LocalGatewayRouteTableVirtualInterfaceGroupAssociationIdSet' => [ 'base' => NULL, 'refs' => [ 'DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest$LocalGatewayRouteTableVirtualInterfaceGroupAssociationIds' => '<p>The IDs of the associations.</p>', ], ], 'LocalGatewayRouteTableVirtualInterfaceGroupAssociationSet' => [ 'base' => NULL, 'refs' => [ 'DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResult$LocalGatewayRouteTableVirtualInterfaceGroupAssociations' => '<p>Information about the associations.</p>', ], ], 'LocalGatewayRouteTableVpcAssociation' => [ 'base' => '<p>Describes an association between a local gateway route table and a VPC.</p>', 'refs' => [ 'CreateLocalGatewayRouteTableVpcAssociationResult$LocalGatewayRouteTableVpcAssociation' => '<p>Information about the association.</p>', 'DeleteLocalGatewayRouteTableVpcAssociationResult$LocalGatewayRouteTableVpcAssociation' => '<p>Information about the association.</p>', 'LocalGatewayRouteTableVpcAssociationSet$member' => NULL, ], ], 'LocalGatewayRouteTableVpcAssociationId' => [ 'base' => NULL, 'refs' => [ 'DeleteLocalGatewayRouteTableVpcAssociationRequest$LocalGatewayRouteTableVpcAssociationId' => '<p>The ID of the association.</p>', 'LocalGatewayRouteTableVpcAssociation$LocalGatewayRouteTableVpcAssociationId' => '<p>The ID of the association.</p>', 'LocalGatewayRouteTableVpcAssociationIdSet$member' => NULL, ], ], 'LocalGatewayRouteTableVpcAssociationIdSet' => [ 'base' => NULL, 'refs' => [ 'DescribeLocalGatewayRouteTableVpcAssociationsRequest$LocalGatewayRouteTableVpcAssociationIds' => '<p>The IDs of the associations.</p>', ], ], 'LocalGatewayRouteTableVpcAssociationSet' => [ 'base' => NULL, 'refs' => [ 'DescribeLocalGatewayRouteTableVpcAssociationsResult$LocalGatewayRouteTableVpcAssociations' => '<p>Information about the associations.</p>', ], ], 'LocalGatewayRouteType' => [ 'base' => NULL, 'refs' => [ 'LocalGatewayRoute$Type' => '<p>The route type.</p>', ], ], 'LocalGatewayRoutetableId' => [ 'base' => NULL, 'refs' => [ 'CoipPool$LocalGatewayRouteTableId' => '<p>The ID of the local gateway route table.</p>', 'CreateLocalGatewayRouteRequest$LocalGatewayRouteTableId' => '<p>The ID of the local gateway route table.</p>', 'CreateLocalGatewayRouteTableVpcAssociationRequest$LocalGatewayRouteTableId' => '<p>The ID of the local gateway route table.</p>', 'DeleteLocalGatewayRouteRequest$LocalGatewayRouteTableId' => '<p>The ID of the local gateway route table.</p>', 'LocalGatewayRoute$LocalGatewayRouteTableId' => '<p>The ID of the local gateway route table.</p>', 'LocalGatewayRouteTableIdSet$member' => NULL, 'SearchLocalGatewayRoutesRequest$LocalGatewayRouteTableId' => '<p>The ID of the local gateway route table.</p>', ], ], 'LocalGatewaySet' => [ 'base' => NULL, 'refs' => [ 'DescribeLocalGatewaysResult$LocalGateways' => '<p>Information about the local gateways.</p>', ], ], 'LocalGatewayVirtualInterface' => [ 'base' => '<p>Describes a local gateway virtual interface.</p>', 'refs' => [ 'LocalGatewayVirtualInterfaceSet$member' => NULL, ], ], 'LocalGatewayVirtualInterfaceGroup' => [ 'base' => '<p>Describes a local gateway virtual interface group.</p>', 'refs' => [ 'LocalGatewayVirtualInterfaceGroupSet$member' => NULL, ], ], 'LocalGatewayVirtualInterfaceGroupId' => [ 'base' => NULL, 'refs' => [ 'CreateLocalGatewayRouteRequest$LocalGatewayVirtualInterfaceGroupId' => '<p>The ID of the virtual interface group.</p>', 'LocalGatewayRoute$LocalGatewayVirtualInterfaceGroupId' => '<p>The ID of the virtual interface group.</p>', 'LocalGatewayRouteTableVirtualInterfaceGroupAssociation$LocalGatewayVirtualInterfaceGroupId' => '<p>The ID of the virtual interface group.</p>', 'LocalGatewayVirtualInterfaceGroup$LocalGatewayVirtualInterfaceGroupId' => '<p>The ID of the virtual interface group.</p>', 'LocalGatewayVirtualInterfaceGroupIdSet$member' => NULL, ], ], 'LocalGatewayVirtualInterfaceGroupIdSet' => [ 'base' => NULL, 'refs' => [ 'DescribeLocalGatewayVirtualInterfaceGroupsRequest$LocalGatewayVirtualInterfaceGroupIds' => '<p>The IDs of the virtual interface groups.</p>', ], ], 'LocalGatewayVirtualInterfaceGroupSet' => [ 'base' => NULL, 'refs' => [ 'DescribeLocalGatewayVirtualInterfaceGroupsResult$LocalGatewayVirtualInterfaceGroups' => '<p>The virtual interface groups.</p>', ], ], 'LocalGatewayVirtualInterfaceId' => [ 'base' => NULL, 'refs' => [ 'LocalGatewayVirtualInterface$LocalGatewayVirtualInterfaceId' => '<p>The ID of the virtual interface.</p>', 'LocalGatewayVirtualInterfaceIdSet$member' => NULL, ], ], 'LocalGatewayVirtualInterfaceIdSet' => [ 'base' => NULL, 'refs' => [ 'DescribeLocalGatewayVirtualInterfacesRequest$LocalGatewayVirtualInterfaceIds' => '<p>The IDs of the virtual interfaces.</p>', 'LocalGatewayVirtualInterfaceGroup$LocalGatewayVirtualInterfaceIds' => '<p>The IDs of the virtual interfaces.</p>', ], ], 'LocalGatewayVirtualInterfaceSet' => [ 'base' => NULL, 'refs' => [ 'DescribeLocalGatewayVirtualInterfacesResult$LocalGatewayVirtualInterfaces' => '<p>Information about the virtual interfaces.</p>', ], ], 'Location' => [ 'base' => NULL, 'refs' => [ 'InstanceTypeOffering$Location' => '<p>The identifier for the location. This depends on the location type. For example, if the location type is <code>region</code>, the location is the Region code (for example, <code>us-east-2</code>.)</p>', ], ], 'LocationType' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceTypeOfferingsRequest$LocationType' => '<p>The location type.</p>', 'InstanceTypeOffering$LocationType' => '<p>The location type.</p>', ], ], 'LogDestinationType' => [ 'base' => NULL, 'refs' => [ 'CreateFlowLogsRequest$LogDestinationType' => '<p>Specifies the type of destination to which the flow log data is to be published. Flow log data can be published to CloudWatch Logs or Amazon S3. To publish flow log data to CloudWatch Logs, specify <code>cloud-watch-logs</code>. To publish flow log data to Amazon S3, specify <code>s3</code>.</p> <p>If you specify <code>LogDestinationType</code> as <code>s3</code>, do not specify <code>DeliverLogsPermissionArn</code> or <code>LogGroupName</code>.</p> <p>Default: <code>cloud-watch-logs</code> </p>', 'FlowLog$LogDestinationType' => '<p>Specifies the type of destination to which the flow log data is published. Flow log data can be published to CloudWatch Logs or Amazon S3.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'CreateVpnGatewayRequest$AmazonSideAsn' => '<p>A private Autonomous System Number (ASN) for the Amazon side of a BGP session. If you\'re using a 16-bit ASN, it must be in the 64512 to 65534 range. If you\'re using a 32-bit ASN, it must be in the 4200000000 to 4294967294 range.</p> <p>Default: 64512</p>', 'DeleteLaunchTemplateVersionsResponseErrorItem$VersionNumber' => '<p>The version number of the launch template.</p>', 'DeleteLaunchTemplateVersionsResponseSuccessItem$VersionNumber' => '<p>The version number of the launch template.</p>', 'DescribeReservedInstancesOfferingsRequest$MaxDuration' => '<p>The maximum duration (in seconds) to filter when searching for offerings.</p> <p>Default: 94608000 (3 years)</p>', 'DescribeReservedInstancesOfferingsRequest$MinDuration' => '<p>The minimum duration (in seconds) to filter when searching for offerings.</p> <p>Default: 2592000 (1 month)</p>', 'DiskImageDescription$Size' => '<p>The size of the disk image, in GiB.</p>', 'DiskImageDetail$Bytes' => '<p>The size of the disk image, in GiB.</p>', 'DiskImageVolumeDescription$Size' => '<p>The size of the volume, in GiB.</p>', 'GetManagedPrefixListEntriesRequest$TargetVersion' => '<p>The version of the prefix list for which to return the entries. The default is the current version.</p>', 'ImportInstanceVolumeDetailItem$BytesConverted' => '<p>The number of bytes converted so far.</p>', 'ImportVolumeTaskDetails$BytesConverted' => '<p>The number of bytes converted so far.</p>', 'LaunchTemplate$DefaultVersionNumber' => '<p>The version number of the default version of the launch template.</p>', 'LaunchTemplate$LatestVersionNumber' => '<p>The version number of the latest version of the launch template.</p>', 'LaunchTemplateVersion$VersionNumber' => '<p>The version number.</p>', 'ManagedPrefixList$Version' => '<p>The version of the prefix list.</p>', 'ModifyManagedPrefixListRequest$CurrentVersion' => '<p>The current version of the prefix list.</p>', 'PriceSchedule$Term' => '<p>The number of months remaining in the reservation. For example, 2 is the second to the last month before the capacity reservation expires.</p>', 'PriceScheduleSpecification$Term' => '<p>The number of months remaining in the reservation. For example, 2 is the second to the last month before the capacity reservation expires.</p>', 'ReservedInstances$Duration' => '<p>The duration of the Reserved Instance, in seconds.</p>', 'ReservedInstancesOffering$Duration' => '<p>The duration of the Reserved Instance, in seconds.</p>', 'RestoreManagedPrefixListVersionRequest$PreviousVersion' => '<p>The version to restore.</p>', 'RestoreManagedPrefixListVersionRequest$CurrentVersion' => '<p>The current version number for the prefix list.</p>', 'TransitGatewayOptions$AmazonSideAsn' => '<p>A private Autonomous System Number (ASN) for the Amazon side of a BGP session. The range is 64512 to 65534 for 16-bit ASNs and 4200000000 to 4294967294 for 32-bit ASNs.</p>', 'TransitGatewayRequestOptions$AmazonSideAsn' => '<p>A private Autonomous System Number (ASN) for the Amazon side of a BGP session. The range is 64512 to 65534 for 16-bit ASNs and 4200000000 to 4294967294 for 32-bit ASNs. The default is <code>64512</code>.</p>', 'VolumeDetail$Size' => '<p>The size of the volume, in GiB.</p>', 'VolumeModification$Progress' => '<p>The modification progress, from 0 to 100 percent complete.</p>', 'VpnGateway$AmazonSideAsn' => '<p>The private Autonomous System Number (ASN) for the Amazon side of a BGP session.</p>', ], ], 'ManagedPrefixList' => [ 'base' => '<p>Describes a managed prefix list.</p>', 'refs' => [ 'CreateManagedPrefixListResult$PrefixList' => '<p>Information about the prefix list.</p>', 'DeleteManagedPrefixListResult$PrefixList' => '<p>Information about the prefix list.</p>', 'ManagedPrefixListSet$member' => NULL, 'ModifyManagedPrefixListResult$PrefixList' => '<p>Information about the prefix list.</p>', 'RestoreManagedPrefixListVersionResult$PrefixList' => '<p>Information about the prefix list.</p>', ], ], 'ManagedPrefixListSet' => [ 'base' => NULL, 'refs' => [ 'DescribeManagedPrefixListsResult$PrefixLists' => '<p>Information about the prefix lists.</p>', ], ], 'MarketType' => [ 'base' => NULL, 'refs' => [ 'InstanceMarketOptionsRequest$MarketType' => '<p>The market type.</p>', 'LaunchTemplateInstanceMarketOptions$MarketType' => '<p>The market type.</p>', 'LaunchTemplateInstanceMarketOptionsRequest$MarketType' => '<p>The market type.</p>', ], ], 'MaxIpv4AddrPerInterface' => [ 'base' => NULL, 'refs' => [ 'NetworkInfo$Ipv4AddressesPerInterface' => '<p>The maximum number of IPv4 addresses per network interface.</p>', ], ], 'MaxIpv6AddrPerInterface' => [ 'base' => NULL, 'refs' => [ 'NetworkInfo$Ipv6AddressesPerInterface' => '<p>The maximum number of IPv6 addresses per network interface.</p>', ], ], 'MaxNetworkInterfaces' => [ 'base' => NULL, 'refs' => [ 'NetworkInfo$MaximumNetworkInterfaces' => '<p>The maximum number of network interfaces for the instance type.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'SearchLocalGatewayRoutesRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'MaximumBandwidthInMbps' => [ 'base' => NULL, 'refs' => [ 'EbsOptimizedInfo$MaximumBandwidthInMbps' => '<p>The maximum bandwidth performance for an EBS-optimized instance type, in Mbps.</p>', ], ], 'MaximumIops' => [ 'base' => NULL, 'refs' => [ 'EbsOptimizedInfo$MaximumIops' => '<p>The maximum input/output storage operations per second for an EBS-optimized instance type.</p>', ], ], 'MaximumThroughputInMBps' => [ 'base' => NULL, 'refs' => [ 'EbsOptimizedInfo$MaximumThroughputInMBps' => '<p>The maximum throughput performance for an EBS-optimized instance type, in MBps.</p>', ], ], 'MembershipType' => [ 'base' => NULL, 'refs' => [ 'TransitGatewayMulticastGroup$MemberType' => '<p>The member type (for example, <code>static</code>).</p>', 'TransitGatewayMulticastGroup$SourceType' => '<p>The source type.</p>', ], ], 'MemoryInfo' => [ 'base' => '<p>Describes the memory for the instance type.</p>', 'refs' => [ 'InstanceTypeInfo$MemoryInfo' => '<p>Describes the memory for the instance type.</p>', ], ], 'MemorySize' => [ 'base' => NULL, 'refs' => [ 'MemoryInfo$SizeInMiB' => '<p>Size of the memory, in MiB.</p>', ], ], 'MillisecondDateTime' => [ 'base' => NULL, 'refs' => [ 'DescribeFastSnapshotRestoreSuccessItem$EnablingTime' => '<p>The time at which fast snapshot restores entered the <code>enabling</code> state.</p>', 'DescribeFastSnapshotRestoreSuccessItem$OptimizingTime' => '<p>The time at which fast snapshot restores entered the <code>optimizing</code> state.</p>', 'DescribeFastSnapshotRestoreSuccessItem$EnabledTime' => '<p>The time at which fast snapshot restores entered the <code>enabled</code> state.</p>', 'DescribeFastSnapshotRestoreSuccessItem$DisablingTime' => '<p>The time at which fast snapshot restores entered the <code>disabling</code> state.</p>', 'DescribeFastSnapshotRestoreSuccessItem$DisabledTime' => '<p>The time at which fast snapshot restores entered the <code>disabled</code> state.</p>', 'DisableFastSnapshotRestoreSuccessItem$EnablingTime' => '<p>The time at which fast snapshot restores entered the <code>enabling</code> state.</p>', 'DisableFastSnapshotRestoreSuccessItem$OptimizingTime' => '<p>The time at which fast snapshot restores entered the <code>optimizing</code> state.</p>', 'DisableFastSnapshotRestoreSuccessItem$EnabledTime' => '<p>The time at which fast snapshot restores entered the <code>enabled</code> state.</p>', 'DisableFastSnapshotRestoreSuccessItem$DisablingTime' => '<p>The time at which fast snapshot restores entered the <code>disabling</code> state.</p>', 'DisableFastSnapshotRestoreSuccessItem$DisabledTime' => '<p>The time at which fast snapshot restores entered the <code>disabled</code> state.</p>', 'EnableFastSnapshotRestoreSuccessItem$EnablingTime' => '<p>The time at which fast snapshot restores entered the <code>enabling</code> state.</p>', 'EnableFastSnapshotRestoreSuccessItem$OptimizingTime' => '<p>The time at which fast snapshot restores entered the <code>optimizing</code> state.</p>', 'EnableFastSnapshotRestoreSuccessItem$EnabledTime' => '<p>The time at which fast snapshot restores entered the <code>enabled</code> state.</p>', 'EnableFastSnapshotRestoreSuccessItem$DisablingTime' => '<p>The time at which fast snapshot restores entered the <code>disabling</code> state.</p>', 'EnableFastSnapshotRestoreSuccessItem$DisabledTime' => '<p>The time at which fast snapshot restores entered the <code>disabled</code> state.</p>', 'FlowLog$CreationTime' => '<p>The date and time the flow log was created.</p>', 'SnapshotInfo$StartTime' => '<p>Time this snapshot was started. This is the same for all snapshots initiated by the same request.</p>', 'SpotFleetRequestConfig$CreateTime' => '<p>The creation date and time of the request.</p>', 'VolumeStatusEvent$NotAfter' => '<p>The latest end time of the event.</p>', 'VolumeStatusEvent$NotBefore' => '<p>The earliest start time of the event.</p>', 'VpcEndpoint$CreationTimestamp' => '<p>The date and time that the VPC endpoint was created.</p>', 'VpcEndpointConnection$CreationTimestamp' => '<p>The date and time that the VPC endpoint was created.</p>', ], ], 'ModifyAvailabilityZoneGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyAvailabilityZoneGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyAvailabilityZoneOptInStatus' => [ 'base' => NULL, 'refs' => [ 'ModifyAvailabilityZoneGroupRequest$OptInStatus' => '<p>Indicates whether you are opted in to the Local Zone group or Wavelength Zone group. The only valid value is <code>opted-in</code>. You must contact <a href="https://console.aws.amazon.com/support/home#/case/create%3FissueType=customer-service%26serviceCode=general-info%26getting-started%26categoryCode=using-aws%26services">AWS Support</a> to opt out of a Local Zone group, or Wavelength Zone group.</p>', ], ], 'ModifyCapacityReservationRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyCapacityReservationResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyClientVpnEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyClientVpnEndpointResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDefaultCreditSpecificationRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyDefaultCreditSpecificationResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyEbsDefaultKmsKeyIdRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyEbsDefaultKmsKeyIdResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyFleetResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyFpgaImageAttributeRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyFpgaImageAttributeResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyHostsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyHostsResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyIdFormatRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyIdentityIdFormatRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyImageAttributeRequest' => [ 'base' => '<p>Contains the parameters for ModifyImageAttribute.</p>', 'refs' => [], ], 'ModifyInstanceAttributeRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyInstanceCapacityReservationAttributesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyInstanceCapacityReservationAttributesResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyInstanceCreditSpecificationRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyInstanceCreditSpecificationResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyInstanceEventStartTimeRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyInstanceEventStartTimeResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyInstanceMetadataOptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyInstanceMetadataOptionsResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyInstancePlacementRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyInstancePlacementResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyLaunchTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyLaunchTemplateResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyManagedPrefixListRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyManagedPrefixListResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyNetworkInterfaceAttributeRequest' => [ 'base' => '<p>Contains the parameters for ModifyNetworkInterfaceAttribute.</p>', 'refs' => [], ], 'ModifyReservedInstancesRequest' => [ 'base' => '<p>Contains the parameters for ModifyReservedInstances.</p>', 'refs' => [], ], 'ModifyReservedInstancesResult' => [ 'base' => '<p>Contains the output of ModifyReservedInstances.</p>', 'refs' => [], ], 'ModifySnapshotAttributeRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifySpotFleetRequestRequest' => [ 'base' => '<p>Contains the parameters for ModifySpotFleetRequest.</p>', 'refs' => [], ], 'ModifySpotFleetRequestResponse' => [ 'base' => '<p>Contains the output of ModifySpotFleetRequest.</p>', 'refs' => [], ], 'ModifySubnetAttributeRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyTrafficMirrorFilterNetworkServicesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyTrafficMirrorFilterNetworkServicesResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyTrafficMirrorFilterRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyTrafficMirrorFilterRuleResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyTrafficMirrorSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyTrafficMirrorSessionResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyTransitGatewayVpcAttachmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyTransitGatewayVpcAttachmentRequestOptions' => [ 'base' => '<p>Describes the options for a VPC attachment.</p>', 'refs' => [ 'ModifyTransitGatewayVpcAttachmentRequest$Options' => '<p>The new VPC attachment options.</p> <note> <p>You cannot modify the IPv6 options.</p> </note>', ], ], 'ModifyTransitGatewayVpcAttachmentResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyVolumeAttributeRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyVolumeRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyVolumeResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyVpcAttributeRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyVpcEndpointConnectionNotificationRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyVpcEndpointConnectionNotificationResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyVpcEndpointRequest' => [ 'base' => '<p>Contains the parameters for ModifyVpcEndpoint.</p>', 'refs' => [], ], 'ModifyVpcEndpointResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyVpcEndpointServiceConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyVpcEndpointServiceConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyVpcEndpointServicePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyVpcEndpointServicePermissionsResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyVpcPeeringConnectionOptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyVpcPeeringConnectionOptionsResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyVpcTenancyRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyVpcTenancyResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyVpnConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyVpnConnectionResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyVpnTunnelCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyVpnTunnelCertificateResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyVpnTunnelOptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyVpnTunnelOptionsResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyVpnTunnelOptionsSpecification' => [ 'base' => '<p>The AWS Site-to-Site VPN tunnel options to modify.</p>', 'refs' => [ 'ModifyVpnTunnelOptionsRequest$TunnelOptions' => '<p>The tunnel options to modify.</p>', ], ], 'MonitorInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'MonitorInstancesResult' => [ 'base' => NULL, 'refs' => [], ], 'Monitoring' => [ 'base' => '<p>Describes the monitoring of an instance.</p>', 'refs' => [ 'Instance$Monitoring' => '<p>The monitoring for the instance.</p>', 'InstanceMonitoring$Monitoring' => '<p>The monitoring for the instance.</p>', ], ], 'MonitoringState' => [ 'base' => NULL, 'refs' => [ 'Monitoring$State' => '<p>Indicates whether detailed monitoring is enabled. Otherwise, basic monitoring is enabled.</p>', ], ], 'MoveAddressToVpcRequest' => [ 'base' => NULL, 'refs' => [], ], 'MoveAddressToVpcResult' => [ 'base' => NULL, 'refs' => [], ], 'MoveStatus' => [ 'base' => NULL, 'refs' => [ 'MovingAddressStatus$MoveStatus' => '<p>The status of the Elastic IP address that\'s being moved to the EC2-VPC platform, or restored to the EC2-Classic platform.</p>', ], ], 'MovingAddressStatus' => [ 'base' => '<p>Describes the status of a moving Elastic IP address.</p>', 'refs' => [ 'MovingAddressStatusSet$member' => NULL, ], ], 'MovingAddressStatusSet' => [ 'base' => NULL, 'refs' => [ 'DescribeMovingAddressesResult$MovingAddressStatuses' => '<p>The status for each Elastic IP address.</p>', ], ], 'MulticastSupportValue' => [ 'base' => NULL, 'refs' => [ 'TransitGatewayOptions$MulticastSupport' => '<p>Indicates whether multicast is enabled on the transit gateway</p>', 'TransitGatewayRequestOptions$MulticastSupport' => '<p>Indicates whether multicast is enabled on the transit gateway</p>', ], ], 'NatGateway' => [ 'base' => '<p>Describes a NAT gateway.</p>', 'refs' => [ 'CreateNatGatewayResult$NatGateway' => '<p>Information about the NAT gateway.</p>', 'NatGatewayList$member' => NULL, ], ], 'NatGatewayAddress' => [ 'base' => '<p>Describes the IP addresses and network interface associated with a NAT gateway.</p>', 'refs' => [ 'NatGatewayAddressList$member' => NULL, ], ], 'NatGatewayAddressList' => [ 'base' => NULL, 'refs' => [ 'NatGateway$NatGatewayAddresses' => '<p>Information about the IP addresses and network interface associated with the NAT gateway.</p>', ], ], 'NatGatewayId' => [ 'base' => NULL, 'refs' => [ 'CreateRouteRequest$NatGatewayId' => '<p>[IPv4 traffic only] The ID of a NAT gateway.</p>', 'DeleteNatGatewayRequest$NatGatewayId' => '<p>The ID of the NAT gateway.</p>', 'NatGatewayIdStringList$member' => NULL, 'ReplaceRouteRequest$NatGatewayId' => '<p>[IPv4 traffic only] The ID of a NAT gateway.</p>', ], ], 'NatGatewayIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeNatGatewaysRequest$NatGatewayIds' => '<p>One or more NAT gateway IDs.</p>', ], ], 'NatGatewayList' => [ 'base' => NULL, 'refs' => [ 'DescribeNatGatewaysResult$NatGateways' => '<p>Information about the NAT gateways.</p>', ], ], 'NatGatewayState' => [ 'base' => NULL, 'refs' => [ 'NatGateway$State' => '<p>The state of the NAT gateway.</p> <ul> <li> <p> <code>pending</code>: The NAT gateway is being created and is not ready to process traffic.</p> </li> <li> <p> <code>failed</code>: The NAT gateway could not be created. Check the <code>failureCode</code> and <code>failureMessage</code> fields for the reason.</p> </li> <li> <p> <code>available</code>: The NAT gateway is able to process traffic. This status remains until you delete the NAT gateway, and does not indicate the health of the NAT gateway.</p> </li> <li> <p> <code>deleting</code>: The NAT gateway is in the process of being terminated and may still be processing traffic.</p> </li> <li> <p> <code>deleted</code>: The NAT gateway has been terminated and is no longer processing traffic.</p> </li> </ul>', ], ], 'NetworkAcl' => [ 'base' => '<p>Describes a network ACL.</p>', 'refs' => [ 'CreateNetworkAclResult$NetworkAcl' => '<p>Information about the network ACL.</p>', 'NetworkAclList$member' => NULL, ], ], 'NetworkAclAssociation' => [ 'base' => '<p>Describes an association between a network ACL and a subnet.</p>', 'refs' => [ 'NetworkAclAssociationList$member' => NULL, ], ], 'NetworkAclAssociationId' => [ 'base' => NULL, 'refs' => [ 'ReplaceNetworkAclAssociationRequest$AssociationId' => '<p>The ID of the current association between the original network ACL and the subnet.</p>', ], ], 'NetworkAclAssociationList' => [ 'base' => NULL, 'refs' => [ 'NetworkAcl$Associations' => '<p>Any associations between the network ACL and one or more subnets</p>', ], ], 'NetworkAclEntry' => [ 'base' => '<p>Describes an entry in a network ACL.</p>', 'refs' => [ 'NetworkAclEntryList$member' => NULL, ], ], 'NetworkAclEntryList' => [ 'base' => NULL, 'refs' => [ 'NetworkAcl$Entries' => '<p>One or more entries (rules) in the network ACL.</p>', ], ], 'NetworkAclId' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkAclEntryRequest$NetworkAclId' => '<p>The ID of the network ACL.</p>', 'DeleteNetworkAclEntryRequest$NetworkAclId' => '<p>The ID of the network ACL.</p>', 'DeleteNetworkAclRequest$NetworkAclId' => '<p>The ID of the network ACL.</p>', 'NetworkAclIdStringList$member' => NULL, 'ReplaceNetworkAclAssociationRequest$NetworkAclId' => '<p>The ID of the new network ACL to associate with the subnet.</p>', 'ReplaceNetworkAclEntryRequest$NetworkAclId' => '<p>The ID of the ACL.</p>', ], ], 'NetworkAclIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeNetworkAclsRequest$NetworkAclIds' => '<p>One or more network ACL IDs.</p> <p>Default: Describes all your network ACLs.</p>', ], ], 'NetworkAclList' => [ 'base' => NULL, 'refs' => [ 'DescribeNetworkAclsResult$NetworkAcls' => '<p>Information about one or more network ACLs.</p>', ], ], 'NetworkInfo' => [ 'base' => '<p>Describes the networking features of the instance type.</p>', 'refs' => [ 'InstanceTypeInfo$NetworkInfo' => '<p>Describes the network settings for the instance type.</p>', ], ], 'NetworkInterface' => [ 'base' => '<p>Describes a network interface.</p>', 'refs' => [ 'CreateNetworkInterfaceResult$NetworkInterface' => '<p>Information about the network interface.</p>', 'NetworkInterfaceList$member' => NULL, ], ], 'NetworkInterfaceAssociation' => [ 'base' => '<p>Describes association information for an Elastic IP address (IPv4 only), or a Carrier IP address (for a network interface which resides in a subnet in a Wavelength Zone).</p>', 'refs' => [ 'NetworkInterface$Association' => '<p>The association information for an Elastic IP address (IPv4) associated with the network interface.</p>', 'NetworkInterfacePrivateIpAddress$Association' => '<p>The association information for an Elastic IP address (IPv4) associated with the network interface.</p>', ], ], 'NetworkInterfaceAttachment' => [ 'base' => '<p>Describes a network interface attachment.</p>', 'refs' => [ 'DescribeNetworkInterfaceAttributeResult$Attachment' => '<p>The attachment (if any) of the network interface.</p>', 'NetworkInterface$Attachment' => '<p>The network interface attachment.</p>', ], ], 'NetworkInterfaceAttachmentChanges' => [ 'base' => '<p>Describes an attachment change.</p>', 'refs' => [ 'ModifyNetworkInterfaceAttributeRequest$Attachment' => '<p>Information about the interface attachment. If modifying the \'delete on termination\' attribute, you must specify the ID of the interface attachment.</p>', ], ], 'NetworkInterfaceAttachmentId' => [ 'base' => NULL, 'refs' => [ 'DetachNetworkInterfaceRequest$AttachmentId' => '<p>The ID of the attachment.</p>', 'NetworkInterfaceAttachmentChanges$AttachmentId' => '<p>The ID of the network interface attachment.</p>', ], ], 'NetworkInterfaceAttribute' => [ 'base' => NULL, 'refs' => [ 'DescribeNetworkInterfaceAttributeRequest$Attribute' => '<p>The attribute of the network interface. This parameter is required.</p>', ], ], 'NetworkInterfaceCreationType' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkInterfaceRequest$InterfaceType' => '<p>Indicates the type of network interface. To create an Elastic Fabric Adapter (EFA), specify <code>efa</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html"> Elastic Fabric Adapter</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', ], ], 'NetworkInterfaceId' => [ 'base' => NULL, 'refs' => [ 'AssignIpv6AddressesRequest$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'AssignPrivateIpAddressesRequest$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'AssociateAddressRequest$NetworkInterfaceId' => '<p>[EC2-VPC] The ID of the network interface. If the instance has more than one network interface, you must specify a network interface ID.</p> <p>For EC2-VPC, you can specify either the instance ID or the network interface ID, but not both. </p>', 'AttachNetworkInterfaceRequest$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'CreateNetworkInterfacePermissionRequest$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'CreateRouteRequest$NetworkInterfaceId' => '<p>The ID of a network interface.</p>', 'CreateTrafficMirrorSessionRequest$NetworkInterfaceId' => '<p>The ID of the source network interface.</p>', 'CreateTrafficMirrorTargetRequest$NetworkInterfaceId' => '<p>The network interface ID that is associated with the target.</p>', 'DeleteNetworkInterfaceRequest$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'DescribeNetworkInterfaceAttributeRequest$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'LaunchTemplateInstanceNetworkInterfaceSpecification$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'LaunchTemplateInstanceNetworkInterfaceSpecificationRequest$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'ModifyNetworkInterfaceAttributeRequest$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'NetworkInterfaceIdList$member' => NULL, 'ReplaceRouteRequest$NetworkInterfaceId' => '<p>The ID of a network interface.</p>', 'ResetNetworkInterfaceAttributeRequest$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'ScheduledInstancesNetworkInterface$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'TransitGatewayNetworkInterfaceIdList$member' => NULL, 'UnassignIpv6AddressesRequest$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'UnassignPrivateIpAddressesRequest$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', ], ], 'NetworkInterfaceIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeNetworkInterfacesRequest$NetworkInterfaceIds' => '<p>One or more network interface IDs.</p> <p>Default: Describes all your network interfaces.</p>', ], ], 'NetworkInterfaceIpv6Address' => [ 'base' => '<p>Describes an IPv6 address associated with a network interface.</p>', 'refs' => [ 'NetworkInterfaceIpv6AddressesList$member' => NULL, ], ], 'NetworkInterfaceIpv6AddressesList' => [ 'base' => NULL, 'refs' => [ 'NetworkInterface$Ipv6Addresses' => '<p>The IPv6 addresses associated with the network interface.</p>', ], ], 'NetworkInterfaceList' => [ 'base' => NULL, 'refs' => [ 'DescribeNetworkInterfacesResult$NetworkInterfaces' => '<p>Information about one or more network interfaces.</p>', ], ], 'NetworkInterfacePermission' => [ 'base' => '<p>Describes a permission for a network interface.</p>', 'refs' => [ 'CreateNetworkInterfacePermissionResult$InterfacePermission' => '<p>Information about the permission for the network interface.</p>', 'NetworkInterfacePermissionList$member' => NULL, ], ], 'NetworkInterfacePermissionId' => [ 'base' => NULL, 'refs' => [ 'DeleteNetworkInterfacePermissionRequest$NetworkInterfacePermissionId' => '<p>The ID of the network interface permission.</p>', 'NetworkInterfacePermissionIdList$member' => NULL, ], ], 'NetworkInterfacePermissionIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeNetworkInterfacePermissionsRequest$NetworkInterfacePermissionIds' => '<p>One or more network interface permission IDs.</p>', ], ], 'NetworkInterfacePermissionList' => [ 'base' => NULL, 'refs' => [ 'DescribeNetworkInterfacePermissionsResult$NetworkInterfacePermissions' => '<p>The network interface permissions.</p>', ], ], 'NetworkInterfacePermissionState' => [ 'base' => '<p>Describes the state of a network interface permission.</p>', 'refs' => [ 'NetworkInterfacePermission$PermissionState' => '<p>Information about the state of the permission.</p>', ], ], 'NetworkInterfacePermissionStateCode' => [ 'base' => NULL, 'refs' => [ 'NetworkInterfacePermissionState$State' => '<p>The state of the permission.</p>', ], ], 'NetworkInterfacePrivateIpAddress' => [ 'base' => '<p>Describes the private IPv4 address of a network interface.</p>', 'refs' => [ 'NetworkInterfacePrivateIpAddressList$member' => NULL, ], ], 'NetworkInterfacePrivateIpAddressList' => [ 'base' => NULL, 'refs' => [ 'NetworkInterface$PrivateIpAddresses' => '<p>The private IPv4 addresses associated with the network interface.</p>', ], ], 'NetworkInterfaceStatus' => [ 'base' => NULL, 'refs' => [ 'InstanceNetworkInterface$Status' => '<p>The status of the network interface.</p>', 'NetworkInterface$Status' => '<p>The status of the network interface.</p>', ], ], 'NetworkInterfaceType' => [ 'base' => NULL, 'refs' => [ 'NetworkInterface$InterfaceType' => '<p>The type of network interface.</p>', ], ], 'NetworkPerformance' => [ 'base' => NULL, 'refs' => [ 'NetworkInfo$NetworkPerformance' => '<p>Describes the network performance.</p>', ], ], 'NewDhcpConfiguration' => [ 'base' => NULL, 'refs' => [ 'NewDhcpConfigurationList$member' => NULL, ], ], 'NewDhcpConfigurationList' => [ 'base' => NULL, 'refs' => [ 'CreateDhcpOptionsRequest$DhcpConfigurations' => '<p>A DHCP configuration option.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeByoipCidrsRequest$NextToken' => '<p>The token for the next page of results.</p>', 'DescribeClientVpnAuthorizationRulesRequest$NextToken' => '<p>The token to retrieve the next page of results.</p>', 'DescribeClientVpnAuthorizationRulesResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeClientVpnConnectionsRequest$NextToken' => '<p>The token to retrieve the next page of results.</p>', 'DescribeClientVpnConnectionsResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeClientVpnEndpointsRequest$NextToken' => '<p>The token to retrieve the next page of results.</p>', 'DescribeClientVpnEndpointsResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeClientVpnRoutesRequest$NextToken' => '<p>The token to retrieve the next page of results.</p>', 'DescribeClientVpnRoutesResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeClientVpnTargetNetworksRequest$NextToken' => '<p>The token to retrieve the next page of results.</p>', 'DescribeClientVpnTargetNetworksResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeExportImageTasksRequest$NextToken' => '<p>A token that indicates the next page of results.</p>', 'DescribeExportImageTasksResult$NextToken' => '<p>The token to use to get the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeFastSnapshotRestoresRequest$NextToken' => '<p>The token for the next page of results.</p>', 'DescribeFastSnapshotRestoresResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeFpgaImagesRequest$NextToken' => '<p>The token to retrieve the next page of results.</p>', 'DescribeFpgaImagesResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeIamInstanceProfileAssociationsRequest$NextToken' => '<p>The token to request the next page of results.</p>', 'DescribeIamInstanceProfileAssociationsResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeInstanceTypeOfferingsRequest$NextToken' => '<p>The token to retrieve the next page of results.</p>', 'DescribeInstanceTypeOfferingsResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeInstanceTypesRequest$NextToken' => '<p>The token to retrieve the next page of results.</p>', 'DescribeInstanceTypesResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeIpv6PoolsRequest$NextToken' => '<p>The token for the next page of results.</p>', 'DescribeIpv6PoolsResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeManagedPrefixListsRequest$NextToken' => '<p>The token for the next page of results.</p>', 'DescribeManagedPrefixListsResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribePublicIpv4PoolsRequest$NextToken' => '<p>The token for the next page of results.</p>', 'DescribeTrafficMirrorFiltersRequest$NextToken' => '<p>The token for the next page of results.</p>', 'DescribeTrafficMirrorSessionsRequest$NextToken' => '<p>The token for the next page of results.</p>', 'DescribeTrafficMirrorTargetsRequest$NextToken' => '<p>The token for the next page of results.</p>', 'GetAssociatedIpv6PoolCidrsRequest$NextToken' => '<p>The token for the next page of results.</p>', 'GetManagedPrefixListAssociationsRequest$NextToken' => '<p>The token for the next page of results.</p>', 'GetManagedPrefixListEntriesRequest$NextToken' => '<p>The token for the next page of results.</p>', 'GetManagedPrefixListEntriesResult$NextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', ], ], 'OccurrenceDayRequestSet' => [ 'base' => NULL, 'refs' => [ 'ScheduledInstanceRecurrenceRequest$OccurrenceDays' => '<p>The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule, this is one or more days of the week (1-7, where 1 is Sunday). You can\'t specify this value with a daily schedule. If the occurrence is relative to the end of the month, you can specify only a single day.</p>', ], ], 'OccurrenceDaySet' => [ 'base' => NULL, 'refs' => [ 'ScheduledInstanceRecurrence$OccurrenceDaySet' => '<p>The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule, this is one or more days of the week (1-7, where 1 is Sunday).</p>', ], ], 'OfferingClassType' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedInstancesOfferingsRequest$OfferingClass' => '<p>The offering class of the Reserved Instance. Can be <code>standard</code> or <code>convertible</code>.</p>', 'DescribeReservedInstancesRequest$OfferingClass' => '<p>Describes whether the Reserved Instance is Standard or Convertible.</p>', 'ReservedInstances$OfferingClass' => '<p>The offering class of the Reserved Instance.</p>', 'ReservedInstancesOffering$OfferingClass' => '<p>If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary value, with different configurations. If <code>standard</code>, it is not possible to perform an exchange.</p>', ], ], 'OfferingId' => [ 'base' => NULL, 'refs' => [ 'DescribeHostReservationOfferingsRequest$OfferingId' => '<p>The ID of the reservation offering.</p>', 'GetHostReservationPurchasePreviewRequest$OfferingId' => '<p>The offering ID of the reservation.</p>', 'PurchaseHostReservationRequest$OfferingId' => '<p>The ID of the offering.</p>', ], ], 'OfferingTypeValues' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedInstancesOfferingsRequest$OfferingType' => '<p>The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version, you only have access to the <code>Medium Utilization</code> Reserved Instance offering type. </p>', 'DescribeReservedInstancesRequest$OfferingType' => '<p>The Reserved Instance offering type. If you are using tools that predate the 2011-11-01 API version, you only have access to the <code>Medium Utilization</code> Reserved Instance offering type.</p>', 'ReservedInstances$OfferingType' => '<p>The Reserved Instance offering type.</p>', 'ReservedInstancesOffering$OfferingType' => '<p>The Reserved Instance offering type.</p>', ], ], 'OnDemandAllocationStrategy' => [ 'base' => NULL, 'refs' => [ 'SpotFleetRequestConfigData$OnDemandAllocationStrategy' => '<p>The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify <code>lowestPrice</code>, Spot Fleet uses price to determine the order, launching the lowest price first. If you specify <code>prioritized</code>, Spot Fleet uses the priority that you assign to each Spot Fleet launch template override, launching the highest priority first. If you do not specify a value, Spot Fleet defaults to <code>lowestPrice</code>.</p>', ], ], 'OnDemandOptions' => [ 'base' => '<p>Describes the configuration of On-Demand Instances in an EC2 Fleet.</p>', 'refs' => [ 'FleetData$OnDemandOptions' => '<p>The allocation strategy of On-Demand Instances in an EC2 Fleet.</p>', ], ], 'OnDemandOptionsRequest' => [ 'base' => '<p>Describes the configuration of On-Demand Instances in an EC2 Fleet.</p>', 'refs' => [ 'CreateFleetRequest$OnDemandOptions' => '<p>Describes the configuration of On-Demand Instances in an EC2 Fleet.</p>', ], ], 'OperationType' => [ 'base' => NULL, 'refs' => [ 'ModifyFpgaImageAttributeRequest$OperationType' => '<p>The operation type.</p>', 'ModifyImageAttributeRequest$OperationType' => '<p>The operation type. This parameter can be used only when the <code>Attribute</code> parameter is <code>launchPermission</code>.</p>', 'ModifySnapshotAttributeRequest$OperationType' => '<p>The type of operation to perform to the attribute.</p>', ], ], 'OwnerStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeFpgaImagesRequest$Owners' => '<p>Filters the AFI by owner. Specify an AWS account ID, <code>self</code> (owner is the sender of the request), or an AWS owner alias (valid values are <code>amazon</code> | <code>aws-marketplace</code>).</p>', 'DescribeImagesRequest$Owners' => '<p>Scopes the results to images with the specified owners. You can specify a combination of AWS account IDs, <code>self</code>, <code>amazon</code>, and <code>aws-marketplace</code>. If you omit this parameter, the results include all images for which you have launch permissions, regardless of ownership.</p>', 'DescribeSnapshotsRequest$OwnerIds' => '<p>Scopes the results to snapshots with the specified owners. You can specify a combination of AWS account IDs, <code>self</code>, and <code>amazon</code>.</p>', ], ], 'PaymentOption' => [ 'base' => NULL, 'refs' => [ 'HostOffering$PaymentOption' => '<p>The available payment option.</p>', 'HostReservation$PaymentOption' => '<p>The payment option selected for this reservation.</p>', 'Purchase$PaymentOption' => '<p>The payment option for the reservation.</p>', ], ], 'PciId' => [ 'base' => '<p>Describes the data that identifies an Amazon FPGA image (AFI) on the PCI bus.</p>', 'refs' => [ 'FpgaImage$PciId' => '<p>Information about the PCI bus.</p>', ], ], 'PeeringAttachmentStatus' => [ 'base' => '<p>The status of the transit gateway peering attachment.</p>', 'refs' => [ 'TransitGatewayPeeringAttachment$Status' => '<p>The status of the transit gateway peering attachment.</p>', ], ], 'PeeringConnectionOptions' => [ 'base' => '<p>Describes the VPC peering connection options.</p>', 'refs' => [ 'ModifyVpcPeeringConnectionOptionsResult$AccepterPeeringConnectionOptions' => '<p>Information about the VPC peering connection options for the accepter VPC.</p>', 'ModifyVpcPeeringConnectionOptionsResult$RequesterPeeringConnectionOptions' => '<p>Information about the VPC peering connection options for the requester VPC.</p>', ], ], 'PeeringConnectionOptionsRequest' => [ 'base' => '<p>The VPC peering connection options.</p>', 'refs' => [ 'ModifyVpcPeeringConnectionOptionsRequest$AccepterPeeringConnectionOptions' => '<p>The VPC peering connection options for the accepter VPC.</p>', 'ModifyVpcPeeringConnectionOptionsRequest$RequesterPeeringConnectionOptions' => '<p>The VPC peering connection options for the requester VPC.</p>', ], ], 'PeeringTgwInfo' => [ 'base' => '<p>Information about the transit gateway in the peering attachment.</p>', 'refs' => [ 'TransitGatewayPeeringAttachment$RequesterTgwInfo' => '<p>Information about the requester transit gateway.</p>', 'TransitGatewayPeeringAttachment$AccepterTgwInfo' => '<p>Information about the accepter transit gateway.</p>', ], ], 'PermissionGroup' => [ 'base' => NULL, 'refs' => [ 'CreateVolumePermission$Group' => '<p>The group to be added or removed. The possible value is <code>all</code>.</p>', 'LaunchPermission$Group' => '<p>The name of the group.</p>', 'LoadPermission$Group' => '<p>The name of the group.</p>', 'LoadPermissionRequest$Group' => '<p>The name of the group.</p>', ], ], 'Phase1DHGroupNumbersList' => [ 'base' => NULL, 'refs' => [ 'TunnelOption$Phase1DHGroupNumbers' => '<p>The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 1 IKE negotiations.</p>', ], ], 'Phase1DHGroupNumbersListValue' => [ 'base' => '<p>The Diffie-Hellmann group number for phase 1 IKE negotiations.</p>', 'refs' => [ 'Phase1DHGroupNumbersList$member' => NULL, ], ], 'Phase1DHGroupNumbersRequestList' => [ 'base' => NULL, 'refs' => [ 'ModifyVpnTunnelOptionsSpecification$Phase1DHGroupNumbers' => '<p>One or more Diffie-Hellman group numbers that are permitted for the VPN tunnel for phase 1 IKE negotiations.</p> <p>Valid values: <code>2</code> | <code>14</code> | <code>15</code> | <code>16</code> | <code>17</code> | <code>18</code> | <code>22</code> | <code>23</code> | <code>24</code> </p>', 'VpnTunnelOptionsSpecification$Phase1DHGroupNumbers' => '<p>One or more Diffie-Hellman group numbers that are permitted for the VPN tunnel for phase 1 IKE negotiations.</p> <p>Valid values: <code>2</code> | <code>14</code> | <code>15</code> | <code>16</code> | <code>17</code> | <code>18</code> | <code>22</code> | <code>23</code> | <code>24</code> </p>', ], ], 'Phase1DHGroupNumbersRequestListValue' => [ 'base' => '<p>Specifies a Diffie-Hellman group number for the VPN tunnel for phase 1 IKE negotiations.</p>', 'refs' => [ 'Phase1DHGroupNumbersRequestList$member' => NULL, ], ], 'Phase1EncryptionAlgorithmsList' => [ 'base' => NULL, 'refs' => [ 'TunnelOption$Phase1EncryptionAlgorithms' => '<p>The permitted encryption algorithms for the VPN tunnel for phase 1 IKE negotiations.</p>', ], ], 'Phase1EncryptionAlgorithmsListValue' => [ 'base' => '<p>The encryption algorithm for phase 1 IKE negotiations.</p>', 'refs' => [ 'Phase1EncryptionAlgorithmsList$member' => NULL, ], ], 'Phase1EncryptionAlgorithmsRequestList' => [ 'base' => NULL, 'refs' => [ 'ModifyVpnTunnelOptionsSpecification$Phase1EncryptionAlgorithms' => '<p>One or more encryption algorithms that are permitted for the VPN tunnel for phase 1 IKE negotiations.</p> <p>Valid values: <code>AES128</code> | <code>AES256</code> </p>', 'VpnTunnelOptionsSpecification$Phase1EncryptionAlgorithms' => '<p>One or more encryption algorithms that are permitted for the VPN tunnel for phase 1 IKE negotiations.</p> <p>Valid values: <code>AES128</code> | <code>AES256</code> </p>', ], ], 'Phase1EncryptionAlgorithmsRequestListValue' => [ 'base' => '<p>Specifies the encryption algorithm for the VPN tunnel for phase 1 IKE negotiations.</p>', 'refs' => [ 'Phase1EncryptionAlgorithmsRequestList$member' => NULL, ], ], 'Phase1IntegrityAlgorithmsList' => [ 'base' => NULL, 'refs' => [ 'TunnelOption$Phase1IntegrityAlgorithms' => '<p>The permitted integrity algorithms for the VPN tunnel for phase 1 IKE negotiations.</p>', ], ], 'Phase1IntegrityAlgorithmsListValue' => [ 'base' => '<p>The integrity algorithm for phase 1 IKE negotiations.</p>', 'refs' => [ 'Phase1IntegrityAlgorithmsList$member' => NULL, ], ], 'Phase1IntegrityAlgorithmsRequestList' => [ 'base' => NULL, 'refs' => [ 'ModifyVpnTunnelOptionsSpecification$Phase1IntegrityAlgorithms' => '<p>One or more integrity algorithms that are permitted for the VPN tunnel for phase 1 IKE negotiations.</p> <p>Valid values: <code>SHA1</code> | <code>SHA2-256</code> </p>', 'VpnTunnelOptionsSpecification$Phase1IntegrityAlgorithms' => '<p>One or more integrity algorithms that are permitted for the VPN tunnel for phase 1 IKE negotiations.</p> <p>Valid values: <code>SHA1</code> | <code>SHA2-256</code> </p>', ], ], 'Phase1IntegrityAlgorithmsRequestListValue' => [ 'base' => '<p>Specifies the integrity algorithm for the VPN tunnel for phase 1 IKE negotiations.</p>', 'refs' => [ 'Phase1IntegrityAlgorithmsRequestList$member' => NULL, ], ], 'Phase2DHGroupNumbersList' => [ 'base' => NULL, 'refs' => [ 'TunnelOption$Phase2DHGroupNumbers' => '<p>The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 2 IKE negotiations.</p>', ], ], 'Phase2DHGroupNumbersListValue' => [ 'base' => '<p>The Diffie-Hellmann group number for phase 2 IKE negotiations.</p>', 'refs' => [ 'Phase2DHGroupNumbersList$member' => NULL, ], ], 'Phase2DHGroupNumbersRequestList' => [ 'base' => NULL, 'refs' => [ 'ModifyVpnTunnelOptionsSpecification$Phase2DHGroupNumbers' => '<p>One or more Diffie-Hellman group numbers that are permitted for the VPN tunnel for phase 2 IKE negotiations.</p> <p>Valid values: <code>2</code> | <code>5</code> | <code>14</code> | <code>15</code> | <code>16</code> | <code>17</code> | <code>18</code> | <code>22</code> | <code>23</code> | <code>24</code> </p>', 'VpnTunnelOptionsSpecification$Phase2DHGroupNumbers' => '<p>One or more Diffie-Hellman group numbers that are permitted for the VPN tunnel for phase 2 IKE negotiations.</p> <p>Valid values: <code>2</code> | <code>5</code> | <code>14</code> | <code>15</code> | <code>16</code> | <code>17</code> | <code>18</code> | <code>22</code> | <code>23</code> | <code>24</code> </p>', ], ], 'Phase2DHGroupNumbersRequestListValue' => [ 'base' => '<p>Specifies a Diffie-Hellman group number for the VPN tunnel for phase 2 IKE negotiations.</p>', 'refs' => [ 'Phase2DHGroupNumbersRequestList$member' => NULL, ], ], 'Phase2EncryptionAlgorithmsList' => [ 'base' => NULL, 'refs' => [ 'TunnelOption$Phase2EncryptionAlgorithms' => '<p>The permitted encryption algorithms for the VPN tunnel for phase 2 IKE negotiations.</p>', ], ], 'Phase2EncryptionAlgorithmsListValue' => [ 'base' => '<p>The encryption algorithm for phase 2 IKE negotiations.</p>', 'refs' => [ 'Phase2EncryptionAlgorithmsList$member' => NULL, ], ], 'Phase2EncryptionAlgorithmsRequestList' => [ 'base' => NULL, 'refs' => [ 'ModifyVpnTunnelOptionsSpecification$Phase2EncryptionAlgorithms' => '<p>One or more encryption algorithms that are permitted for the VPN tunnel for phase 2 IKE negotiations.</p> <p>Valid values: <code>AES128</code> | <code>AES256</code> </p>', 'VpnTunnelOptionsSpecification$Phase2EncryptionAlgorithms' => '<p>One or more encryption algorithms that are permitted for the VPN tunnel for phase 2 IKE negotiations.</p> <p>Valid values: <code>AES128</code> | <code>AES256</code> </p>', ], ], 'Phase2EncryptionAlgorithmsRequestListValue' => [ 'base' => '<p>Specifies the encryption algorithm for the VPN tunnel for phase 2 IKE negotiations.</p>', 'refs' => [ 'Phase2EncryptionAlgorithmsRequestList$member' => NULL, ], ], 'Phase2IntegrityAlgorithmsList' => [ 'base' => NULL, 'refs' => [ 'TunnelOption$Phase2IntegrityAlgorithms' => '<p>The permitted integrity algorithms for the VPN tunnel for phase 2 IKE negotiations.</p>', ], ], 'Phase2IntegrityAlgorithmsListValue' => [ 'base' => '<p>The integrity algorithm for phase 2 IKE negotiations.</p>', 'refs' => [ 'Phase2IntegrityAlgorithmsList$member' => NULL, ], ], 'Phase2IntegrityAlgorithmsRequestList' => [ 'base' => NULL, 'refs' => [ 'ModifyVpnTunnelOptionsSpecification$Phase2IntegrityAlgorithms' => '<p>One or more integrity algorithms that are permitted for the VPN tunnel for phase 2 IKE negotiations.</p> <p>Valid values: <code>SHA1</code> | <code>SHA2-256</code> </p>', 'VpnTunnelOptionsSpecification$Phase2IntegrityAlgorithms' => '<p>One or more integrity algorithms that are permitted for the VPN tunnel for phase 2 IKE negotiations.</p> <p>Valid values: <code>SHA1</code> | <code>SHA2-256</code> </p>', ], ], 'Phase2IntegrityAlgorithmsRequestListValue' => [ 'base' => '<p>Specifies the integrity algorithm for the VPN tunnel for phase 2 IKE negotiations.</p>', 'refs' => [ 'Phase2IntegrityAlgorithmsRequestList$member' => NULL, ], ], 'Placement' => [ 'base' => '<p>Describes the placement of an instance.</p>', 'refs' => [ 'FleetLaunchTemplateOverridesRequest$Placement' => '<p>The location where the instance launched, if applicable.</p>', 'ImportInstanceLaunchSpecification$Placement' => '<p>The placement information for the instance.</p>', 'Instance$Placement' => '<p>The location where the instance launched, if applicable.</p>', 'RunInstancesRequest$Placement' => '<p>The placement for the instance.</p>', ], ], 'PlacementGroup' => [ 'base' => '<p>Describes a placement group.</p>', 'refs' => [ 'CreatePlacementGroupResult$PlacementGroup' => NULL, 'PlacementGroupList$member' => NULL, ], ], 'PlacementGroupId' => [ 'base' => NULL, 'refs' => [ 'PlacementGroupIdStringList$member' => NULL, ], ], 'PlacementGroupIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribePlacementGroupsRequest$GroupIds' => '<p>The IDs of the placement groups.</p>', ], ], 'PlacementGroupInfo' => [ 'base' => '<p>Describes the placement group support of the instance type.</p>', 'refs' => [ 'InstanceTypeInfo$PlacementGroupInfo' => '<p>Describes the placement group settings for the instance type.</p>', ], ], 'PlacementGroupList' => [ 'base' => NULL, 'refs' => [ 'DescribePlacementGroupsResult$PlacementGroups' => '<p>Information about the placement groups.</p>', ], ], 'PlacementGroupName' => [ 'base' => NULL, 'refs' => [ 'DeletePlacementGroupRequest$GroupName' => '<p>The name of the placement group.</p>', 'LaunchTemplatePlacementRequest$GroupName' => '<p>The name of the placement group for the instance.</p>', 'ModifyInstancePlacementRequest$GroupName' => '<p>The name of the placement group in which to place the instance. For spread placement groups, the instance must have a tenancy of <code>default</code>. For cluster and partition placement groups, the instance must have a tenancy of <code>default</code> or <code>dedicated</code>.</p> <p>To remove an instance from a placement group, specify an empty string ("").</p>', 'PlacementGroupStringList$member' => NULL, 'ScheduledInstancesPlacement$GroupName' => '<p>The name of the placement group.</p>', ], ], 'PlacementGroupState' => [ 'base' => NULL, 'refs' => [ 'PlacementGroup$State' => '<p>The state of the placement group.</p>', ], ], 'PlacementGroupStrategy' => [ 'base' => NULL, 'refs' => [ 'PlacementGroupStrategyList$member' => NULL, ], ], 'PlacementGroupStrategyList' => [ 'base' => NULL, 'refs' => [ 'PlacementGroupInfo$SupportedStrategies' => '<p>A list of supported placement groups types.</p>', ], ], 'PlacementGroupStringList' => [ 'base' => NULL, 'refs' => [ 'DescribePlacementGroupsRequest$GroupNames' => '<p>The names of the placement groups.</p> <p>Default: Describes all your placement groups, or only those otherwise specified.</p>', ], ], 'PlacementResponse' => [ 'base' => '<p>Describes the placement of an instance.</p>', 'refs' => [ 'FleetLaunchTemplateOverrides$Placement' => '<p>The location where the instance launched, if applicable.</p>', ], ], 'PlacementStrategy' => [ 'base' => NULL, 'refs' => [ 'CreatePlacementGroupRequest$Strategy' => '<p>The placement strategy.</p>', 'PlacementGroup$Strategy' => '<p>The placement strategy.</p>', ], ], 'PlatformValues' => [ 'base' => NULL, 'refs' => [ 'CreateFleetInstance$Platform' => '<p>The value is <code>Windows</code> for Windows instances. Otherwise, the value is blank.</p>', 'DescribeFleetsInstances$Platform' => '<p>The value is <code>Windows</code> for Windows instances. Otherwise, the value is blank.</p>', 'Image$Platform' => '<p>This value is set to <code>windows</code> for Windows AMIs; otherwise, it is blank.</p>', 'ImportInstanceRequest$Platform' => '<p>The instance operating system.</p>', 'ImportInstanceTaskDetails$Platform' => '<p>The instance operating system.</p>', 'Instance$Platform' => '<p>The value is <code>Windows</code> for Windows instances; otherwise blank.</p>', ], ], 'PoolCidrBlock' => [ 'base' => '<p>Describes a CIDR block for an address pool.</p>', 'refs' => [ 'PoolCidrBlocksSet$member' => NULL, ], ], 'PoolCidrBlocksSet' => [ 'base' => NULL, 'refs' => [ 'Ipv6Pool$PoolCidrBlocks' => '<p>The CIDR blocks for the address pool.</p>', ], ], 'PoolMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribePublicIpv4PoolsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'PortRange' => [ 'base' => '<p>Describes a range of ports.</p>', 'refs' => [ 'CreateNetworkAclEntryRequest$PortRange' => '<p>TCP or UDP protocols: The range of ports the rule applies to. Required if specifying protocol 6 (TCP) or 17 (UDP).</p>', 'NetworkAclEntry$PortRange' => '<p>TCP or UDP protocols: The range of ports the rule applies to.</p>', 'ReplaceNetworkAclEntryRequest$PortRange' => '<p>TCP or UDP protocols: The range of ports the rule applies to. Required if specifying protocol 6 (TCP) or 17 (UDP).</p>', ], ], 'PrefixList' => [ 'base' => '<p>Describes prefixes for AWS services.</p>', 'refs' => [ 'PrefixListSet$member' => NULL, ], ], 'PrefixListAssociation' => [ 'base' => '<p>Describes the resource with which a prefix list is associated.</p>', 'refs' => [ 'PrefixListAssociationSet$member' => NULL, ], ], 'PrefixListAssociationSet' => [ 'base' => NULL, 'refs' => [ 'GetManagedPrefixListAssociationsResult$PrefixListAssociations' => '<p>Information about the associations.</p>', ], ], 'PrefixListEntry' => [ 'base' => '<p>Describes a prefix list entry.</p>', 'refs' => [ 'PrefixListEntrySet$member' => NULL, ], ], 'PrefixListEntrySet' => [ 'base' => NULL, 'refs' => [ 'GetManagedPrefixListEntriesResult$Entries' => '<p>Information about the prefix list entries.</p>', ], ], 'PrefixListId' => [ 'base' => '<p>Describes a prefix list ID.</p>', 'refs' => [ 'PrefixListIdList$member' => NULL, ], ], 'PrefixListIdList' => [ 'base' => NULL, 'refs' => [ 'IpPermission$PrefixListIds' => '<p>[VPC only] The prefix list IDs.</p>', ], ], 'PrefixListIdSet' => [ 'base' => NULL, 'refs' => [ 'StaleIpPermission$PrefixListIds' => '<p>The prefix list IDs. Not applicable for stale security group rules.</p>', ], ], 'PrefixListMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeManagedPrefixListsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', 'GetManagedPrefixListEntriesRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'PrefixListResourceId' => [ 'base' => NULL, 'refs' => [ 'CreateRouteRequest$DestinationPrefixListId' => '<p>The ID of a prefix list used for the destination match.</p>', 'DeleteManagedPrefixListRequest$PrefixListId' => '<p>The ID of the prefix list.</p>', 'DeleteRouteRequest$DestinationPrefixListId' => '<p>The ID of the prefix list for the route.</p>', 'GetManagedPrefixListAssociationsRequest$PrefixListId' => '<p>The ID of the prefix list.</p>', 'GetManagedPrefixListEntriesRequest$PrefixListId' => '<p>The ID of the prefix list.</p>', 'ManagedPrefixList$PrefixListId' => '<p>The ID of the prefix list.</p>', 'ModifyManagedPrefixListRequest$PrefixListId' => '<p>The ID of the prefix list.</p>', 'PrefixListResourceIdStringList$member' => NULL, 'ReplaceRouteRequest$DestinationPrefixListId' => '<p>The ID of the prefix list for the route.</p>', 'RestoreManagedPrefixListVersionRequest$PrefixListId' => '<p>The ID of the prefix list.</p>', ], ], 'PrefixListResourceIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribePrefixListsRequest$PrefixListIds' => '<p>One or more prefix list IDs.</p>', ], ], 'PrefixListSet' => [ 'base' => NULL, 'refs' => [ 'DescribePrefixListsResult$PrefixLists' => '<p>All available prefix lists.</p>', ], ], 'PrefixListState' => [ 'base' => NULL, 'refs' => [ 'ManagedPrefixList$State' => '<p>The state of the prefix list.</p>', ], ], 'PriceSchedule' => [ 'base' => '<p>Describes the price for a Reserved Instance.</p>', 'refs' => [ 'PriceScheduleList$member' => NULL, ], ], 'PriceScheduleList' => [ 'base' => NULL, 'refs' => [ 'ReservedInstancesListing$PriceSchedules' => '<p>The price of the Reserved Instance listing.</p>', ], ], 'PriceScheduleSpecification' => [ 'base' => '<p>Describes the price for a Reserved Instance.</p>', 'refs' => [ 'PriceScheduleSpecificationList$member' => NULL, ], ], 'PriceScheduleSpecificationList' => [ 'base' => NULL, 'refs' => [ 'CreateReservedInstancesListingRequest$PriceSchedules' => '<p>A list specifying the price of the Standard Reserved Instance for each month remaining in the Reserved Instance term.</p>', ], ], 'PricingDetail' => [ 'base' => '<p>Describes a Reserved Instance offering.</p>', 'refs' => [ 'PricingDetailsList$member' => NULL, ], ], 'PricingDetailsList' => [ 'base' => NULL, 'refs' => [ 'ReservedInstancesOffering$PricingDetails' => '<p>The pricing details of the Reserved Instance offering.</p>', ], ], 'PrincipalIdFormat' => [ 'base' => '<p>PrincipalIdFormat description</p>', 'refs' => [ 'PrincipalIdFormatList$member' => NULL, ], ], 'PrincipalIdFormatList' => [ 'base' => NULL, 'refs' => [ 'DescribePrincipalIdFormatResult$Principals' => '<p>Information about the ID format settings for the ARN.</p>', ], ], 'PrincipalType' => [ 'base' => NULL, 'refs' => [ 'AllowedPrincipal$PrincipalType' => '<p>The type of principal.</p>', ], ], 'PrivateDnsNameConfiguration' => [ 'base' => '<p>Information about the private DNS name for the service endpoint. For more information about these parameters, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/ndpoint-services-dns-validation.html">VPC Endpoint Service Private DNS Name Verification</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>', 'refs' => [ 'ServiceConfiguration$PrivateDnsNameConfiguration' => '<p>Information about the endpoint service private DNS name configuration.</p>', ], ], 'PrivateIpAddressConfigSet' => [ 'base' => NULL, 'refs' => [ 'ScheduledInstancesNetworkInterface$PrivateIpAddressConfigs' => '<p>The private IPv4 addresses.</p>', ], ], 'PrivateIpAddressSpecification' => [ 'base' => '<p>Describes a secondary private IPv4 address for a network interface.</p>', 'refs' => [ 'PrivateIpAddressSpecificationList$member' => NULL, ], ], 'PrivateIpAddressSpecificationList' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkInterfaceRequest$PrivateIpAddresses' => '<p>One or more private IPv4 addresses.</p>', 'InstanceNetworkInterfaceSpecification$PrivateIpAddresses' => '<p>One or more private IPv4 addresses to assign to the network interface. Only one private IPv4 address can be designated as primary. You cannot specify this option if you\'re launching more than one instance in a <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html">RunInstances</a> request.</p>', 'LaunchTemplateInstanceNetworkInterfaceSpecification$PrivateIpAddresses' => '<p>One or more private IPv4 addresses.</p>', 'LaunchTemplateInstanceNetworkInterfaceSpecificationRequest$PrivateIpAddresses' => '<p>One or more private IPv4 addresses.</p>', ], ], 'PrivateIpAddressStringList' => [ 'base' => NULL, 'refs' => [ 'AssignPrivateIpAddressesRequest$PrivateIpAddresses' => '<p>One or more IP addresses to be assigned as a secondary private IP address to the network interface. You can\'t specify this parameter when also specifying a number of secondary IP addresses.</p> <p>If you don\'t specify an IP address, Amazon EC2 automatically selects an IP address within the subnet range.</p>', 'UnassignPrivateIpAddressesRequest$PrivateIpAddresses' => '<p>The secondary private IP addresses to unassign from the network interface. You can specify this option multiple times to unassign more than one IP address.</p>', ], ], 'ProcessorInfo' => [ 'base' => '<p>Describes the processor used by the instance type.</p>', 'refs' => [ 'InstanceTypeInfo$ProcessorInfo' => '<p>Describes the processor.</p>', ], ], 'ProcessorSustainedClockSpeed' => [ 'base' => NULL, 'refs' => [ 'ProcessorInfo$SustainedClockSpeedInGhz' => '<p>The speed of the processor, in GHz.</p>', ], ], 'ProductCode' => [ 'base' => '<p>Describes a product code.</p>', 'refs' => [ 'ProductCodeList$member' => NULL, ], ], 'ProductCodeList' => [ 'base' => NULL, 'refs' => [ 'DescribeSnapshotAttributeResult$ProductCodes' => '<p>The product codes.</p>', 'DescribeVolumeAttributeResult$ProductCodes' => '<p>A list of product codes.</p>', 'FpgaImage$ProductCodes' => '<p>The product codes for the AFI.</p>', 'FpgaImageAttribute$ProductCodes' => '<p>The product codes.</p>', 'Image$ProductCodes' => '<p>Any product codes associated with the AMI.</p>', 'ImageAttribute$ProductCodes' => '<p>The product codes.</p>', 'Instance$ProductCodes' => '<p>The product codes attached to this instance, if applicable.</p>', 'InstanceAttribute$ProductCodes' => '<p>A list of product codes.</p>', ], ], 'ProductCodeStringList' => [ 'base' => NULL, 'refs' => [ 'ModifyFpgaImageAttributeRequest$ProductCodes' => '<p>The product codes. After you add a product code to an AFI, it can\'t be removed. This parameter is valid only when modifying the <code>productCodes</code> attribute.</p>', 'ModifyImageAttributeRequest$ProductCodes' => '<p>The DevPay product codes. After you add a product code to an AMI, it can\'t be removed.</p>', ], ], 'ProductCodeValues' => [ 'base' => NULL, 'refs' => [ 'ProductCode$ProductCodeType' => '<p>The type of product code.</p>', ], ], 'ProductDescriptionList' => [ 'base' => NULL, 'refs' => [ 'DescribeSpotPriceHistoryRequest$ProductDescriptions' => '<p>Filters the results by the specified basic product descriptions.</p>', ], ], 'PropagatingVgw' => [ 'base' => '<p>Describes a virtual private gateway propagating route.</p>', 'refs' => [ 'PropagatingVgwList$member' => NULL, ], ], 'PropagatingVgwList' => [ 'base' => NULL, 'refs' => [ 'RouteTable$PropagatingVgws' => '<p>Any virtual private gateway (VGW) propagating routes.</p>', ], ], 'ProvisionByoipCidrRequest' => [ 'base' => NULL, 'refs' => [], ], 'ProvisionByoipCidrResult' => [ 'base' => NULL, 'refs' => [], ], 'ProvisionedBandwidth' => [ 'base' => '<p>Reserved. If you need to sustain traffic greater than the <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html">documented limits</a>, contact us through the <a href="https://console.aws.amazon.com/support/home?">Support Center</a>.</p>', 'refs' => [ 'NatGateway$ProvisionedBandwidth' => '<p>Reserved. If you need to sustain traffic greater than the <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html">documented limits</a>, contact us through the <a href="https://console.aws.amazon.com/support/home?">Support Center</a>.</p>', ], ], 'PublicIpAddress' => [ 'base' => NULL, 'refs' => [ 'AllocateAddressRequest$Address' => '<p>[EC2-VPC] The Elastic IP address to recover or an IPv4 address from an address pool.</p>', ], ], 'PublicIpStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeAddressesRequest$PublicIps' => '<p>One or more Elastic IP addresses.</p> <p>Default: Describes all your Elastic IP addresses.</p>', ], ], 'PublicIpv4Pool' => [ 'base' => '<p>Describes an IPv4 address pool.</p>', 'refs' => [ 'PublicIpv4PoolSet$member' => NULL, ], ], 'PublicIpv4PoolIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribePublicIpv4PoolsRequest$PoolIds' => '<p>The IDs of the address pools.</p>', ], ], 'PublicIpv4PoolRange' => [ 'base' => '<p>Describes an address range of an IPv4 address pool.</p>', 'refs' => [ 'PublicIpv4PoolRangeSet$member' => NULL, ], ], 'PublicIpv4PoolRangeSet' => [ 'base' => NULL, 'refs' => [ 'PublicIpv4Pool$PoolAddressRanges' => '<p>The address ranges.</p>', ], ], 'PublicIpv4PoolSet' => [ 'base' => NULL, 'refs' => [ 'DescribePublicIpv4PoolsResult$PublicIpv4Pools' => '<p>Information about the address pools.</p>', ], ], 'Purchase' => [ 'base' => '<p>Describes the result of the purchase.</p>', 'refs' => [ 'PurchaseSet$member' => NULL, ], ], 'PurchaseHostReservationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PurchaseHostReservationResult' => [ 'base' => NULL, 'refs' => [], ], 'PurchaseRequest' => [ 'base' => '<p>Describes a request to purchase Scheduled Instances.</p>', 'refs' => [ 'PurchaseRequestSet$member' => NULL, ], ], 'PurchaseRequestSet' => [ 'base' => NULL, 'refs' => [ 'PurchaseScheduledInstancesRequest$PurchaseRequests' => '<p>The purchase requests.</p>', ], ], 'PurchaseReservedInstancesOfferingRequest' => [ 'base' => '<p>Contains the parameters for PurchaseReservedInstancesOffering.</p>', 'refs' => [], ], 'PurchaseReservedInstancesOfferingResult' => [ 'base' => '<p>Contains the output of PurchaseReservedInstancesOffering.</p>', 'refs' => [], ], 'PurchaseScheduledInstancesRequest' => [ 'base' => '<p>Contains the parameters for PurchaseScheduledInstances.</p>', 'refs' => [], ], 'PurchaseScheduledInstancesResult' => [ 'base' => '<p>Contains the output of PurchaseScheduledInstances.</p>', 'refs' => [], ], 'PurchaseSet' => [ 'base' => NULL, 'refs' => [ 'GetHostReservationPurchasePreviewResult$Purchase' => '<p>The purchase information of the Dedicated Host reservation and the Dedicated Hosts associated with it.</p>', 'PurchaseHostReservationResult$Purchase' => '<p>Describes the details of the purchase.</p>', ], ], 'PurchasedScheduledInstanceSet' => [ 'base' => NULL, 'refs' => [ 'PurchaseScheduledInstancesResult$ScheduledInstanceSet' => '<p>Information about the Scheduled Instances.</p>', ], ], 'RIProductDescription' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedInstancesOfferingsRequest$ProductDescription' => '<p>The Reserved Instance product platform description. Instances that include <code>(Amazon VPC)</code> in the description are for use with Amazon VPC.</p>', 'ReservedInstances$ProductDescription' => '<p>The Reserved Instance product platform description.</p>', 'ReservedInstancesOffering$ProductDescription' => '<p>The Reserved Instance product platform description.</p>', 'SpotInstanceRequest$ProductDescription' => '<p>The product description associated with the Spot Instance.</p>', 'SpotPrice$ProductDescription' => '<p>A general description of the AMI.</p>', ], ], 'RamdiskId' => [ 'base' => NULL, 'refs' => [ 'RegisterImageRequest$RamdiskId' => '<p>The ID of the RAM disk.</p>', 'RequestLaunchTemplateData$RamDiskId' => '<p>The ID of the RAM disk.</p> <important> <p>We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html">User Provided Kernels</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> </important>', 'RequestSpotLaunchSpecification$RamdiskId' => '<p>The ID of the RAM disk.</p>', 'RunInstancesRequest$RamdiskId' => '<p>The ID of the RAM disk to select. Some kernels require additional drivers at launch. Check the kernel requirements for information about whether you need to specify a RAM disk. To find kernel requirements, go to the AWS Resource Center and search for the kernel ID.</p> <important> <p>We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html"> PV-GRUB</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> </important>', 'ScheduledInstancesLaunchSpecification$RamdiskId' => '<p>The ID of the RAM disk.</p>', ], ], 'ReasonCodesList' => [ 'base' => NULL, 'refs' => [ 'ReportInstanceStatusRequest$ReasonCodes' => '<p>The reason codes that describe the health state of your instance.</p> <ul> <li> <p> <code>instance-stuck-in-state</code>: My instance is stuck in a state.</p> </li> <li> <p> <code>unresponsive</code>: My instance is unresponsive.</p> </li> <li> <p> <code>not-accepting-credentials</code>: My instance is not accepting my credentials.</p> </li> <li> <p> <code>password-not-available</code>: A password is not available for my instance.</p> </li> <li> <p> <code>performance-network</code>: My instance is experiencing performance problems that I believe are network related.</p> </li> <li> <p> <code>performance-instance-store</code>: My instance is experiencing performance problems that I believe are related to the instance stores.</p> </li> <li> <p> <code>performance-ebs-volume</code>: My instance is experiencing performance problems that I believe are related to an EBS volume.</p> </li> <li> <p> <code>performance-other</code>: My instance is experiencing performance problems.</p> </li> <li> <p> <code>other</code>: [explain using the description parameter]</p> </li> </ul>', ], ], 'RebootInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'RecurringCharge' => [ 'base' => '<p>Describes a recurring charge.</p>', 'refs' => [ 'RecurringChargesList$member' => NULL, ], ], 'RecurringChargeFrequency' => [ 'base' => NULL, 'refs' => [ 'RecurringCharge$Frequency' => '<p>The frequency of the recurring charge.</p>', ], ], 'RecurringChargesList' => [ 'base' => NULL, 'refs' => [ 'ReservedInstances$RecurringCharges' => '<p>The recurring charge tag assigned to the resource.</p>', 'ReservedInstancesOffering$RecurringCharges' => '<p>The recurring charge tag assigned to the resource.</p>', ], ], 'Region' => [ 'base' => '<p>Describes a Region.</p>', 'refs' => [ 'RegionList$member' => NULL, ], ], 'RegionList' => [ 'base' => NULL, 'refs' => [ 'DescribeRegionsResult$Regions' => '<p>Information about the Regions.</p>', ], ], 'RegionNameStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeRegionsRequest$RegionNames' => '<p>The names of the Regions. You can specify any Regions, whether they are enabled and disabled for your account.</p>', ], ], 'RegisterImageRequest' => [ 'base' => '<p>Contains the parameters for RegisterImage.</p>', 'refs' => [], ], 'RegisterImageResult' => [ 'base' => '<p>Contains the output of RegisterImage.</p>', 'refs' => [], ], 'RegisterInstanceEventNotificationAttributesRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterInstanceEventNotificationAttributesResult' => [ 'base' => NULL, 'refs' => [], ], 'RegisterInstanceTagAttributeRequest' => [ 'base' => '<p>Information about the tag keys to register for the current Region. You can either specify individual tag keys or register all tag keys in the current Region. You must specify either <code>IncludeAllTagsOfInstance</code> or <code>InstanceTagKeys</code> in the request</p>', 'refs' => [ 'RegisterInstanceEventNotificationAttributesRequest$InstanceTagAttribute' => '<p>Information about the tag keys to register.</p>', ], ], 'RegisterTransitGatewayMulticastGroupMembersRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterTransitGatewayMulticastGroupMembersResult' => [ 'base' => NULL, 'refs' => [], ], 'RegisterTransitGatewayMulticastGroupSourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterTransitGatewayMulticastGroupSourcesResult' => [ 'base' => NULL, 'refs' => [], ], 'RejectTransitGatewayPeeringAttachmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'RejectTransitGatewayPeeringAttachmentResult' => [ 'base' => NULL, 'refs' => [], ], 'RejectTransitGatewayVpcAttachmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'RejectTransitGatewayVpcAttachmentResult' => [ 'base' => NULL, 'refs' => [], ], 'RejectVpcEndpointConnectionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'RejectVpcEndpointConnectionsResult' => [ 'base' => NULL, 'refs' => [], ], 'RejectVpcPeeringConnectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'RejectVpcPeeringConnectionResult' => [ 'base' => NULL, 'refs' => [], ], 'ReleaseAddressRequest' => [ 'base' => NULL, 'refs' => [], ], 'ReleaseHostsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ReleaseHostsResult' => [ 'base' => NULL, 'refs' => [], ], 'RemovePrefixListEntries' => [ 'base' => NULL, 'refs' => [ 'ModifyManagedPrefixListRequest$RemoveEntries' => '<p>One or more entries to remove from the prefix list.</p>', ], ], 'RemovePrefixListEntry' => [ 'base' => '<p>An entry for a prefix list.</p>', 'refs' => [ 'RemovePrefixListEntries$member' => NULL, ], ], 'ReplaceIamInstanceProfileAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'ReplaceIamInstanceProfileAssociationResult' => [ 'base' => NULL, 'refs' => [], ], 'ReplaceNetworkAclAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'ReplaceNetworkAclAssociationResult' => [ 'base' => NULL, 'refs' => [], ], 'ReplaceNetworkAclEntryRequest' => [ 'base' => NULL, 'refs' => [], ], 'ReplaceRouteRequest' => [ 'base' => NULL, 'refs' => [], ], 'ReplaceRouteTableAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'ReplaceRouteTableAssociationResult' => [ 'base' => NULL, 'refs' => [], ], 'ReplaceTransitGatewayRouteRequest' => [ 'base' => NULL, 'refs' => [], ], 'ReplaceTransitGatewayRouteResult' => [ 'base' => NULL, 'refs' => [], ], 'ReportInstanceReasonCodes' => [ 'base' => NULL, 'refs' => [ 'ReasonCodesList$member' => NULL, ], ], 'ReportInstanceStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'ReportStatusType' => [ 'base' => NULL, 'refs' => [ 'ReportInstanceStatusRequest$Status' => '<p>The status of all instances listed.</p>', ], ], 'RequestHostIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeHostsRequest$HostIds' => '<p>The IDs of the Dedicated Hosts. The IDs are used for targeted instance launches.</p>', 'ModifyHostsRequest$HostIds' => '<p>The IDs of the Dedicated Hosts to modify.</p>', 'ReleaseHostsRequest$HostIds' => '<p>The IDs of the Dedicated Hosts to release.</p>', ], ], 'RequestHostIdSet' => [ 'base' => NULL, 'refs' => [ 'GetHostReservationPurchasePreviewRequest$HostIdSet' => '<p>The IDs of the Dedicated Hosts with which the reservation is associated.</p>', 'PurchaseHostReservationRequest$HostIdSet' => '<p>The IDs of the Dedicated Hosts with which the reservation will be associated.</p>', ], ], 'RequestInstanceTypeList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceTypesRequest$InstanceTypes' => '<p>The instance types. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>', ], ], 'RequestLaunchTemplateData' => [ 'base' => '<p>The information to include in the launch template.</p>', 'refs' => [ 'CreateLaunchTemplateRequest$LaunchTemplateData' => '<p>The information for the launch template.</p>', 'CreateLaunchTemplateVersionRequest$LaunchTemplateData' => '<p>The information for the launch template.</p>', ], ], 'RequestSpotFleetRequest' => [ 'base' => '<p>Contains the parameters for RequestSpotFleet.</p>', 'refs' => [], ], 'RequestSpotFleetResponse' => [ 'base' => '<p>Contains the output of RequestSpotFleet.</p>', 'refs' => [], ], 'RequestSpotInstancesRequest' => [ 'base' => '<p>Contains the parameters for RequestSpotInstances.</p>', 'refs' => [], ], 'RequestSpotInstancesResult' => [ 'base' => '<p>Contains the output of RequestSpotInstances.</p>', 'refs' => [], ], 'RequestSpotLaunchSpecification' => [ 'base' => '<p>Describes the launch specification for an instance.</p>', 'refs' => [ 'RequestSpotInstancesRequest$LaunchSpecification' => '<p>The launch specification.</p>', ], ], 'RequestSpotLaunchSpecificationSecurityGroupIdList' => [ 'base' => NULL, 'refs' => [ 'RequestSpotLaunchSpecification$SecurityGroupIds' => '<p>One or more security group IDs.</p>', ], ], 'RequestSpotLaunchSpecificationSecurityGroupList' => [ 'base' => NULL, 'refs' => [ 'RequestSpotLaunchSpecification$SecurityGroups' => '<p>One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security groups.</p>', ], ], 'Reservation' => [ 'base' => '<p>Describes a reservation.</p>', 'refs' => [ 'ReservationList$member' => NULL, ], ], 'ReservationId' => [ 'base' => NULL, 'refs' => [ 'CreateReservedInstancesListingRequest$ReservedInstancesId' => '<p>The ID of the active Standard Reserved Instance.</p>', 'DeleteQueuedReservedInstancesIdList$member' => NULL, 'DescribeReservedInstancesListingsRequest$ReservedInstancesId' => '<p>One or more Reserved Instance IDs.</p>', 'ReservedInstanceIdSet$member' => NULL, 'ReservedInstancesIdStringList$member' => NULL, ], ], 'ReservationList' => [ 'base' => NULL, 'refs' => [ 'DescribeInstancesResult$Reservations' => '<p>Information about the reservations.</p>', ], ], 'ReservationState' => [ 'base' => NULL, 'refs' => [ 'HostReservation$State' => '<p>The state of the reservation.</p>', ], ], 'ReservationValue' => [ 'base' => '<p>The cost associated with the Reserved Instance.</p>', 'refs' => [ 'GetReservedInstancesExchangeQuoteResult$ReservedInstanceValueRollup' => '<p>The cost associated with the Reserved Instance.</p>', 'GetReservedInstancesExchangeQuoteResult$TargetConfigurationValueRollup' => '<p>The cost associated with the Reserved Instance.</p>', 'ReservedInstanceReservationValue$ReservationValue' => '<p>The total value of the Convertible Reserved Instance that you are exchanging.</p>', 'TargetReservationValue$ReservationValue' => '<p>The total value of the Convertible Reserved Instances that make up the exchange. This is the sum of the list value, remaining upfront price, and additional upfront cost of the exchange.</p>', ], ], 'ReservedInstanceIdSet' => [ 'base' => NULL, 'refs' => [ 'AcceptReservedInstancesExchangeQuoteRequest$ReservedInstanceIds' => '<p>The IDs of the Convertible Reserved Instances to exchange for another Convertible Reserved Instance of the same or higher value.</p>', 'GetReservedInstancesExchangeQuoteRequest$ReservedInstanceIds' => '<p>The IDs of the Convertible Reserved Instances to exchange.</p>', ], ], 'ReservedInstanceLimitPrice' => [ 'base' => '<p>Describes the limit price of a Reserved Instance offering.</p>', 'refs' => [ 'PurchaseReservedInstancesOfferingRequest$LimitPrice' => '<p>Specified for Reserved Instance Marketplace offerings to limit the total order and ensure that the Reserved Instances are not purchased at unexpected prices.</p>', ], ], 'ReservedInstanceReservationValue' => [ 'base' => '<p>The total value of the Convertible Reserved Instance.</p>', 'refs' => [ 'ReservedInstanceReservationValueSet$member' => NULL, ], ], 'ReservedInstanceReservationValueSet' => [ 'base' => NULL, 'refs' => [ 'GetReservedInstancesExchangeQuoteResult$ReservedInstanceValueSet' => '<p>The configuration of your Convertible Reserved Instances.</p>', ], ], 'ReservedInstanceState' => [ 'base' => NULL, 'refs' => [ 'ReservedInstances$State' => '<p>The state of the Reserved Instance purchase.</p>', ], ], 'ReservedInstances' => [ 'base' => '<p>Describes a Reserved Instance.</p>', 'refs' => [ 'ReservedInstancesList$member' => NULL, ], ], 'ReservedInstancesConfiguration' => [ 'base' => '<p>Describes the configuration settings for the modified Reserved Instances.</p>', 'refs' => [ 'ReservedInstancesConfigurationList$member' => NULL, 'ReservedInstancesModificationResult$TargetConfiguration' => '<p>The target Reserved Instances configurations supplied as part of the modification request.</p>', ], ], 'ReservedInstancesConfigurationList' => [ 'base' => NULL, 'refs' => [ 'ModifyReservedInstancesRequest$TargetConfigurations' => '<p>The configuration settings for the Reserved Instances to modify.</p>', ], ], 'ReservedInstancesId' => [ 'base' => '<p>Describes the ID of a Reserved Instance.</p>', 'refs' => [ 'ReservedIntancesIds$member' => NULL, ], ], 'ReservedInstancesIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedInstancesRequest$ReservedInstancesIds' => '<p>One or more Reserved Instance IDs.</p> <p>Default: Describes all your Reserved Instances, or only those otherwise specified.</p>', 'ModifyReservedInstancesRequest$ReservedInstancesIds' => '<p>The IDs of the Reserved Instances to modify.</p>', ], ], 'ReservedInstancesList' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedInstancesResult$ReservedInstances' => '<p>A list of Reserved Instances.</p>', ], ], 'ReservedInstancesListing' => [ 'base' => '<p>Describes a Reserved Instance listing.</p>', 'refs' => [ 'ReservedInstancesListingList$member' => NULL, ], ], 'ReservedInstancesListingId' => [ 'base' => NULL, 'refs' => [ 'CancelReservedInstancesListingRequest$ReservedInstancesListingId' => '<p>The ID of the Reserved Instance listing.</p>', 'DescribeReservedInstancesListingsRequest$ReservedInstancesListingId' => '<p>One or more Reserved Instance listing IDs.</p>', ], ], 'ReservedInstancesListingList' => [ 'base' => NULL, 'refs' => [ 'CancelReservedInstancesListingResult$ReservedInstancesListings' => '<p>The Reserved Instance listing.</p>', 'CreateReservedInstancesListingResult$ReservedInstancesListings' => '<p>Information about the Standard Reserved Instance listing.</p>', 'DescribeReservedInstancesListingsResult$ReservedInstancesListings' => '<p>Information about the Reserved Instance listing.</p>', ], ], 'ReservedInstancesModification' => [ 'base' => '<p>Describes a Reserved Instance modification.</p>', 'refs' => [ 'ReservedInstancesModificationList$member' => NULL, ], ], 'ReservedInstancesModificationId' => [ 'base' => NULL, 'refs' => [ 'ReservedInstancesModificationIdStringList$member' => NULL, ], ], 'ReservedInstancesModificationIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedInstancesModificationsRequest$ReservedInstancesModificationIds' => '<p>IDs for the submitted modification request.</p>', ], ], 'ReservedInstancesModificationList' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedInstancesModificationsResult$ReservedInstancesModifications' => '<p>The Reserved Instance modification information.</p>', ], ], 'ReservedInstancesModificationResult' => [ 'base' => '<p>Describes the modification request/s.</p>', 'refs' => [ 'ReservedInstancesModificationResultList$member' => NULL, ], ], 'ReservedInstancesModificationResultList' => [ 'base' => NULL, 'refs' => [ 'ReservedInstancesModification$ModificationResults' => '<p>Contains target configurations along with their corresponding new Reserved Instance IDs.</p>', ], ], 'ReservedInstancesOffering' => [ 'base' => '<p>Describes a Reserved Instance offering.</p>', 'refs' => [ 'ReservedInstancesOfferingList$member' => NULL, ], ], 'ReservedInstancesOfferingId' => [ 'base' => NULL, 'refs' => [ 'PurchaseReservedInstancesOfferingRequest$ReservedInstancesOfferingId' => '<p>The ID of the Reserved Instance offering to purchase.</p>', 'ReservedInstancesOfferingIdStringList$member' => NULL, 'TargetConfigurationRequest$OfferingId' => '<p>The Convertible Reserved Instance offering ID.</p>', ], ], 'ReservedInstancesOfferingIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedInstancesOfferingsRequest$ReservedInstancesOfferingIds' => '<p>One or more Reserved Instances offering IDs.</p>', ], ], 'ReservedInstancesOfferingList' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedInstancesOfferingsResult$ReservedInstancesOfferings' => '<p>A list of Reserved Instances offerings.</p>', ], ], 'ReservedIntancesIds' => [ 'base' => NULL, 'refs' => [ 'ReservedInstancesModification$ReservedInstancesIds' => '<p>The IDs of one or more Reserved Instances.</p>', ], ], 'ResetEbsDefaultKmsKeyIdRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResetEbsDefaultKmsKeyIdResult' => [ 'base' => NULL, 'refs' => [], ], 'ResetFpgaImageAttributeName' => [ 'base' => NULL, 'refs' => [ 'ResetFpgaImageAttributeRequest$Attribute' => '<p>The attribute.</p>', ], ], 'ResetFpgaImageAttributeRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResetFpgaImageAttributeResult' => [ 'base' => NULL, 'refs' => [], ], 'ResetImageAttributeName' => [ 'base' => NULL, 'refs' => [ 'ResetImageAttributeRequest$Attribute' => '<p>The attribute to reset (currently you can only reset the launch permission attribute).</p>', ], ], 'ResetImageAttributeRequest' => [ 'base' => '<p>Contains the parameters for ResetImageAttribute.</p>', 'refs' => [], ], 'ResetInstanceAttributeRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResetNetworkInterfaceAttributeRequest' => [ 'base' => '<p>Contains the parameters for ResetNetworkInterfaceAttribute.</p>', 'refs' => [], ], 'ResetSnapshotAttributeRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'CoipPool$PoolArn' => '<p>The ARN of the address pool.</p>', 'ManagedPrefixList$PrefixListArn' => '<p>The Amazon Resource Name (ARN) for the prefix list.</p>', ], ], 'ResourceIdList' => [ 'base' => NULL, 'refs' => [ 'CreateTagsRequest$Resources' => '<p>The IDs of the resources, separated by spaces.</p> <p>Constraints: Up to 1000 resource IDs. We recommend breaking up this request into smaller batches.</p>', 'DeleteTagsRequest$Resources' => '<p>The IDs of the resources, separated by spaces.</p> <p>Constraints: Up to 1000 resource IDs. We recommend breaking up this request into smaller batches.</p>', ], ], 'ResourceList' => [ 'base' => NULL, 'refs' => [ 'DescribePrincipalIdFormatRequest$Resources' => '<p>The type of resource: <code>bundle</code> | <code>conversion-task</code> | <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> | <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> | <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code> | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> | <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code> | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> | <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> | <code>vpn-connection</code> | <code>vpn-gateway</code> </p>', ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'LaunchTemplateTagSpecification$ResourceType' => '<p>The type of resource.</p>', 'LaunchTemplateTagSpecificationRequest$ResourceType' => '<p>The type of resource to tag. Currently, the resource types that support tagging on creation are <code>instance</code> and <code>volume</code>. To tag a resource after it has been created, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>.</p>', 'SpotFleetTagSpecification$ResourceType' => '<p>The type of resource. Currently, the only resource type that is supported is <code>instance</code>. To tag the Spot Fleet request on creation, use the <code>TagSpecifications</code> parameter in <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotFleetRequestConfigData.html"> <code>SpotFleetRequestConfigData</code> </a>.</p>', 'TagDescription$ResourceType' => '<p>The resource type.</p>', 'TagSpecification$ResourceType' => '<p>The type of resource to tag. Currently, the resource types that support tagging on creation are: <code>capacity-reservation</code> | <code>client-vpn-endpoint</code> | <code>customer-gateway</code> | <code>dedicated-host</code> | <code>dhcp-options</code> | <code>export-image-task</code> | <code>export-instance-task</code> | <code>fleet</code> | <code>fpga-image</code> | <code>host-reservation</code> | <code>import-image-task</code> | <code>import-snapshot-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>ipv4pool-ec2</code> | <code>ipv6pool-ec2</code> | <code>key-pair</code> | <code>launch-template</code> | <code>placement-group</code> | <code>prefix-list</code> | <code>natgateway</code> | <code>network-acl</code> | <code>route-table</code> | <code>security-group</code> | <code>spot-fleet-request</code> | <code>spot-instances-request</code> | <code>snapshot</code> | <code>subnet</code> | <code>traffic-mirror-filter</code> | <code>traffic-mirror-session</code> | <code>traffic-mirror-target</code> | <code>transit-gateway</code> | <code>transit-gateway-attachment</code> | <code>transit-gateway-route-table</code> | <code>volume</code> |<code>vpc</code> | <code> vpc-peering-connection</code> | <code>vpc-endpoint</code> (for interface and gateway endpoints) | <code>vpc-endpoint-service</code> (for AWS PrivateLink) | <code>vpc-flow-log</code> | <code>vpn-connection</code> | <code>vpn-gateway</code>.</p> <p>To tag a resource after it has been created, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>.</p>', ], ], 'ResponseError' => [ 'base' => '<p>Describes the error that\'s returned when you cannot delete a launch template version.</p>', 'refs' => [ 'DeleteLaunchTemplateVersionsResponseErrorItem$ResponseError' => '<p>Information about the error.</p>', ], ], 'ResponseHostIdList' => [ 'base' => NULL, 'refs' => [ 'AllocateHostsResult$HostIds' => '<p>The ID of the allocated Dedicated Host. This is used to launch an instance onto a specific host.</p>', 'ModifyHostsResult$Successful' => '<p>The IDs of the Dedicated Hosts that were successfully modified.</p>', 'ReleaseHostsResult$Successful' => '<p>The IDs of the Dedicated Hosts that were successfully released.</p>', ], ], 'ResponseHostIdSet' => [ 'base' => NULL, 'refs' => [ 'HostReservation$HostIdSet' => '<p>The IDs of the Dedicated Hosts associated with the reservation.</p>', 'Purchase$HostIdSet' => '<p>The IDs of the Dedicated Hosts associated with the reservation.</p>', ], ], 'ResponseLaunchTemplateData' => [ 'base' => '<p>The information for a launch template. </p>', 'refs' => [ 'GetLaunchTemplateDataResult$LaunchTemplateData' => '<p>The instance data.</p>', 'LaunchTemplateVersion$LaunchTemplateData' => '<p>Information about the launch template.</p>', ], ], 'RestorableByStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeSnapshotsRequest$RestorableByUserIds' => '<p>The IDs of the AWS accounts that can create volumes from the snapshot.</p>', ], ], 'RestoreAddressToClassicRequest' => [ 'base' => NULL, 'refs' => [], ], 'RestoreAddressToClassicResult' => [ 'base' => NULL, 'refs' => [], ], 'RestoreManagedPrefixListVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'RestoreManagedPrefixListVersionResult' => [ 'base' => NULL, 'refs' => [], ], 'RevokeClientVpnIngressRequest' => [ 'base' => NULL, 'refs' => [], ], 'RevokeClientVpnIngressResult' => [ 'base' => NULL, 'refs' => [], ], 'RevokeSecurityGroupEgressRequest' => [ 'base' => NULL, 'refs' => [], ], 'RevokeSecurityGroupIngressRequest' => [ 'base' => NULL, 'refs' => [], ], 'RootDeviceType' => [ 'base' => NULL, 'refs' => [ 'RootDeviceTypeList$member' => NULL, ], ], 'RootDeviceTypeList' => [ 'base' => NULL, 'refs' => [ 'InstanceTypeInfo$SupportedRootDeviceTypes' => '<p>Indicates the supported root device types.</p>', ], ], 'Route' => [ 'base' => '<p>Describes a route in a route table.</p>', 'refs' => [ 'RouteList$member' => NULL, ], ], 'RouteGatewayId' => [ 'base' => NULL, 'refs' => [ 'AssociateRouteTableRequest$GatewayId' => '<p>The ID of the internet gateway or virtual private gateway.</p>', 'CreateRouteRequest$GatewayId' => '<p>The ID of an internet gateway or virtual private gateway attached to your VPC.</p>', 'ReplaceRouteRequest$GatewayId' => '<p>The ID of an internet gateway or virtual private gateway.</p>', ], ], 'RouteList' => [ 'base' => NULL, 'refs' => [ 'RouteTable$Routes' => '<p>The routes in the route table.</p>', ], ], 'RouteOrigin' => [ 'base' => NULL, 'refs' => [ 'Route$Origin' => '<p>Describes how the route was created.</p> <ul> <li> <p> <code>CreateRouteTable</code> - The route was automatically created when the route table was created.</p> </li> <li> <p> <code>CreateRoute</code> - The route was manually added to the route table.</p> </li> <li> <p> <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.</p> </li> </ul>', ], ], 'RouteState' => [ 'base' => NULL, 'refs' => [ 'Route$State' => '<p>The state of the route. The <code>blackhole</code> state indicates that the route\'s target isn\'t available (for example, the specified gateway isn\'t attached to the VPC, or the specified NAT instance has been terminated).</p>', ], ], 'RouteTable' => [ 'base' => '<p>Describes a route table.</p>', 'refs' => [ 'CreateRouteTableResult$RouteTable' => '<p>Information about the route table.</p>', 'RouteTableList$member' => NULL, ], ], 'RouteTableAssociation' => [ 'base' => '<p>Describes an association between a route table and a subnet or gateway.</p>', 'refs' => [ 'RouteTableAssociationList$member' => NULL, ], ], 'RouteTableAssociationId' => [ 'base' => NULL, 'refs' => [ 'DisassociateRouteTableRequest$AssociationId' => '<p>The association ID representing the current association between the route table and subnet or gateway.</p>', 'ReplaceRouteTableAssociationRequest$AssociationId' => '<p>The association ID.</p>', ], ], 'RouteTableAssociationList' => [ 'base' => NULL, 'refs' => [ 'RouteTable$Associations' => '<p>The associations between the route table and one or more subnets or a gateway.</p>', ], ], 'RouteTableAssociationState' => [ 'base' => '<p>Describes the state of an association between a route table and a subnet or gateway.</p>', 'refs' => [ 'AssociateRouteTableResult$AssociationState' => '<p>The state of the association.</p>', 'ReplaceRouteTableAssociationResult$AssociationState' => '<p>The state of the association.</p>', 'RouteTableAssociation$AssociationState' => '<p>The state of the association.</p>', ], ], 'RouteTableAssociationStateCode' => [ 'base' => NULL, 'refs' => [ 'RouteTableAssociationState$State' => '<p>The state of the association.</p>', ], ], 'RouteTableId' => [ 'base' => NULL, 'refs' => [ 'AssociateRouteTableRequest$RouteTableId' => '<p>The ID of the route table.</p>', 'CreateRouteRequest$RouteTableId' => '<p>The ID of the route table for the route.</p>', 'DeleteRouteRequest$RouteTableId' => '<p>The ID of the route table.</p>', 'DeleteRouteTableRequest$RouteTableId' => '<p>The ID of the route table.</p>', 'DisableVgwRoutePropagationRequest$RouteTableId' => '<p>The ID of the route table.</p>', 'EnableVgwRoutePropagationRequest$RouteTableId' => '<p>The ID of the route table. The routing table must be associated with the same VPC that the virtual private gateway is attached to. </p>', 'ReplaceRouteRequest$RouteTableId' => '<p>The ID of the route table.</p>', 'ReplaceRouteTableAssociationRequest$RouteTableId' => '<p>The ID of the new route table to associate with the subnet.</p>', 'RouteTableIdStringList$member' => NULL, 'VpcEndpointRouteTableIdList$member' => NULL, ], ], 'RouteTableIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeRouteTablesRequest$RouteTableIds' => '<p>One or more route table IDs.</p> <p>Default: Describes all your route tables.</p>', ], ], 'RouteTableList' => [ 'base' => NULL, 'refs' => [ 'DescribeRouteTablesResult$RouteTables' => '<p>Information about one or more route tables.</p>', ], ], 'RuleAction' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkAclEntryRequest$RuleAction' => '<p>Indicates whether to allow or deny the traffic that matches the rule.</p>', 'NetworkAclEntry$RuleAction' => '<p>Indicates whether to allow or deny the traffic that matches the rule.</p>', 'ReplaceNetworkAclEntryRequest$RuleAction' => '<p>Indicates whether to allow or deny the traffic that matches the rule.</p>', ], ], 'RunInstancesMonitoringEnabled' => [ 'base' => '<p>Describes the monitoring of an instance.</p>', 'refs' => [ 'LaunchSpecification$Monitoring' => NULL, 'RequestSpotLaunchSpecification$Monitoring' => '<p>Indicates whether basic or detailed monitoring is enabled for the instance.</p> <p>Default: Disabled</p>', 'RunInstancesRequest$Monitoring' => '<p>Specifies whether detailed monitoring is enabled for the instance.</p>', ], ], 'RunInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'RunScheduledInstancesRequest' => [ 'base' => '<p>Contains the parameters for RunScheduledInstances.</p>', 'refs' => [], ], 'RunScheduledInstancesResult' => [ 'base' => '<p>Contains the output of RunScheduledInstances.</p>', 'refs' => [], ], 'S3Storage' => [ 'base' => '<p>Describes the storage parameters for S3 and S3 buckets for an instance store-backed AMI.</p>', 'refs' => [ 'Storage$S3' => '<p>An Amazon S3 storage location.</p>', ], ], 'ScheduledInstance' => [ 'base' => '<p>Describes a Scheduled Instance.</p>', 'refs' => [ 'PurchasedScheduledInstanceSet$member' => NULL, 'ScheduledInstanceSet$member' => NULL, ], ], 'ScheduledInstanceAvailability' => [ 'base' => '<p>Describes a schedule that is available for your Scheduled Instances.</p>', 'refs' => [ 'ScheduledInstanceAvailabilitySet$member' => NULL, ], ], 'ScheduledInstanceAvailabilitySet' => [ 'base' => NULL, 'refs' => [ 'DescribeScheduledInstanceAvailabilityResult$ScheduledInstanceAvailabilitySet' => '<p>Information about the available Scheduled Instances.</p>', ], ], 'ScheduledInstanceId' => [ 'base' => NULL, 'refs' => [ 'RunScheduledInstancesRequest$ScheduledInstanceId' => '<p>The Scheduled Instance ID.</p>', 'ScheduledInstanceIdRequestSet$member' => NULL, ], ], 'ScheduledInstanceIdRequestSet' => [ 'base' => NULL, 'refs' => [ 'DescribeScheduledInstancesRequest$ScheduledInstanceIds' => '<p>The Scheduled Instance IDs.</p>', ], ], 'ScheduledInstanceRecurrence' => [ 'base' => '<p>Describes the recurring schedule for a Scheduled Instance.</p>', 'refs' => [ 'ScheduledInstance$Recurrence' => '<p>The schedule recurrence.</p>', 'ScheduledInstanceAvailability$Recurrence' => '<p>The schedule recurrence.</p>', ], ], 'ScheduledInstanceRecurrenceRequest' => [ 'base' => '<p>Describes the recurring schedule for a Scheduled Instance.</p>', 'refs' => [ 'DescribeScheduledInstanceAvailabilityRequest$Recurrence' => '<p>The schedule recurrence.</p>', ], ], 'ScheduledInstanceSet' => [ 'base' => NULL, 'refs' => [ 'DescribeScheduledInstancesResult$ScheduledInstanceSet' => '<p>Information about the Scheduled Instances.</p>', ], ], 'ScheduledInstancesBlockDeviceMapping' => [ 'base' => '<p>Describes a block device mapping for a Scheduled Instance.</p>', 'refs' => [ 'ScheduledInstancesBlockDeviceMappingSet$member' => NULL, ], ], 'ScheduledInstancesBlockDeviceMappingSet' => [ 'base' => NULL, 'refs' => [ 'ScheduledInstancesLaunchSpecification$BlockDeviceMappings' => '<p>The block device mapping entries.</p>', ], ], 'ScheduledInstancesEbs' => [ 'base' => '<p>Describes an EBS volume for a Scheduled Instance.</p>', 'refs' => [ 'ScheduledInstancesBlockDeviceMapping$Ebs' => '<p>Parameters used to set up EBS volumes automatically when the instance is launched.</p>', ], ], 'ScheduledInstancesIamInstanceProfile' => [ 'base' => '<p>Describes an IAM instance profile for a Scheduled Instance.</p>', 'refs' => [ 'ScheduledInstancesLaunchSpecification$IamInstanceProfile' => '<p>The IAM instance profile.</p>', ], ], 'ScheduledInstancesIpv6Address' => [ 'base' => '<p>Describes an IPv6 address.</p>', 'refs' => [ 'ScheduledInstancesIpv6AddressList$member' => NULL, ], ], 'ScheduledInstancesIpv6AddressList' => [ 'base' => NULL, 'refs' => [ 'ScheduledInstancesNetworkInterface$Ipv6Addresses' => '<p>The specific IPv6 addresses from the subnet range.</p>', ], ], 'ScheduledInstancesLaunchSpecification' => [ 'base' => '<p>Describes the launch specification for a Scheduled Instance.</p> <p>If you are launching the Scheduled Instance in EC2-VPC, you must specify the ID of the subnet. You can specify the subnet using either <code>SubnetId</code> or <code>NetworkInterface</code>.</p>', 'refs' => [ 'RunScheduledInstancesRequest$LaunchSpecification' => '<p>The launch specification. You must match the instance type, Availability Zone, network, and platform of the schedule that you purchased.</p>', ], ], 'ScheduledInstancesMonitoring' => [ 'base' => '<p>Describes whether monitoring is enabled for a Scheduled Instance.</p>', 'refs' => [ 'ScheduledInstancesLaunchSpecification$Monitoring' => '<p>Enable or disable monitoring for the instances.</p>', ], ], 'ScheduledInstancesNetworkInterface' => [ 'base' => '<p>Describes a network interface for a Scheduled Instance.</p>', 'refs' => [ 'ScheduledInstancesNetworkInterfaceSet$member' => NULL, ], ], 'ScheduledInstancesNetworkInterfaceSet' => [ 'base' => NULL, 'refs' => [ 'ScheduledInstancesLaunchSpecification$NetworkInterfaces' => '<p>The network interfaces.</p>', ], ], 'ScheduledInstancesPlacement' => [ 'base' => '<p>Describes the placement for a Scheduled Instance.</p>', 'refs' => [ 'ScheduledInstancesLaunchSpecification$Placement' => '<p>The placement information.</p>', ], ], 'ScheduledInstancesPrivateIpAddressConfig' => [ 'base' => '<p>Describes a private IPv4 address for a Scheduled Instance.</p>', 'refs' => [ 'PrivateIpAddressConfigSet$member' => NULL, ], ], 'ScheduledInstancesSecurityGroupIdSet' => [ 'base' => NULL, 'refs' => [ 'ScheduledInstancesLaunchSpecification$SecurityGroupIds' => '<p>The IDs of the security groups.</p>', 'ScheduledInstancesNetworkInterface$Groups' => '<p>The IDs of the security groups.</p>', ], ], 'SearchLocalGatewayRoutesRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchLocalGatewayRoutesResult' => [ 'base' => NULL, 'refs' => [], ], 'SearchTransitGatewayMulticastGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchTransitGatewayMulticastGroupsResult' => [ 'base' => NULL, 'refs' => [], ], 'SearchTransitGatewayRoutesRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchTransitGatewayRoutesResult' => [ 'base' => NULL, 'refs' => [], ], 'SecurityGroup' => [ 'base' => '<p>Describes a security group</p>', 'refs' => [ 'SecurityGroupList$member' => NULL, ], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'AuthorizeSecurityGroupEgressRequest$GroupId' => '<p>The ID of the security group.</p>', 'AuthorizeSecurityGroupIngressRequest$GroupId' => '<p>The ID of the security group. You must specify either the security group ID or the security group name in the request. For security groups in a nondefault VPC, you must specify the security group ID.</p>', 'ClientVpnSecurityGroupIdSet$member' => NULL, 'DeleteSecurityGroupRequest$GroupId' => '<p>The ID of the security group. Required for a nondefault VPC.</p>', 'GroupIds$member' => NULL, 'RequestSpotLaunchSpecificationSecurityGroupIdList$member' => NULL, 'RevokeSecurityGroupEgressRequest$GroupId' => '<p>The ID of the security group.</p>', 'RevokeSecurityGroupIngressRequest$GroupId' => '<p>The ID of the security group. You must specify either the security group ID or the security group name in the request. For security groups in a nondefault VPC, you must specify the security group ID.</p>', 'ScheduledInstancesSecurityGroupIdSet$member' => NULL, 'SecurityGroupIdStringList$member' => NULL, 'UpdateSecurityGroupRuleDescriptionsEgressRequest$GroupId' => '<p>The ID of the security group. You must specify either the security group ID or the security group name in the request. For security groups in a nondefault VPC, you must specify the security group ID.</p>', 'UpdateSecurityGroupRuleDescriptionsIngressRequest$GroupId' => '<p>The ID of the security group. You must specify either the security group ID or the security group name in the request. For security groups in a nondefault VPC, you must specify the security group ID.</p>', 'VpcEndpointSecurityGroupIdList$member' => NULL, ], ], 'SecurityGroupIdStringList' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkInterfaceRequest$Groups' => '<p>The IDs of one or more security groups.</p>', 'ImportInstanceLaunchSpecification$GroupIds' => '<p>The security group IDs.</p>', 'InstanceNetworkInterfaceSpecification$Groups' => '<p>The IDs of the security groups for the network interface. Applies only if creating a network interface when launching an instance.</p>', 'LaunchTemplateInstanceNetworkInterfaceSpecificationRequest$Groups' => '<p>The IDs of one or more security groups.</p>', 'ModifyNetworkInterfaceAttributeRequest$Groups' => '<p>Changes the security groups for the network interface. The new set of groups you specify replaces the current set. You must specify at least one group, even if it\'s just the default security group in the VPC. You must specify the ID of the security group, not the name.</p>', 'RequestLaunchTemplateData$SecurityGroupIds' => '<p>One or more security group IDs. You can create a security group using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html">CreateSecurityGroup</a>. You cannot specify both a security group ID and security name in the same request.</p>', 'RunInstancesRequest$SecurityGroupIds' => '<p>The IDs of the security groups. You can create a security group using <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html">CreateSecurityGroup</a>.</p> <p>If you specify a network interface, you must specify any security groups as part of the network interface.</p>', ], ], 'SecurityGroupIdentifier' => [ 'base' => '<p>Describes a security group.</p>', 'refs' => [ 'GroupIdentifierSet$member' => NULL, ], ], 'SecurityGroupList' => [ 'base' => NULL, 'refs' => [ 'DescribeSecurityGroupsResult$SecurityGroups' => '<p>Information about the security groups.</p>', ], ], 'SecurityGroupName' => [ 'base' => NULL, 'refs' => [ 'AuthorizeSecurityGroupIngressRequest$GroupName' => '<p>[EC2-Classic, default VPC] The name of the security group. You must specify either the security group ID or the security group name in the request.</p>', 'DeleteSecurityGroupRequest$GroupName' => '<p>[EC2-Classic, default VPC] The name of the security group. You can specify either the security group name or the security group ID.</p>', 'GroupNameStringList$member' => NULL, 'RequestSpotLaunchSpecificationSecurityGroupList$member' => NULL, 'RevokeSecurityGroupIngressRequest$GroupName' => '<p>[EC2-Classic, default VPC] The name of the security group. You must specify either the security group ID or the security group name in the request.</p>', 'SecurityGroupStringList$member' => NULL, 'UpdateSecurityGroupRuleDescriptionsEgressRequest$GroupName' => '<p>[Default VPC] The name of the security group. You must specify either the security group ID or the security group name in the request.</p>', 'UpdateSecurityGroupRuleDescriptionsIngressRequest$GroupName' => '<p>[EC2-Classic, default VPC] The name of the security group. You must specify either the security group ID or the security group name in the request.</p>', ], ], 'SecurityGroupReference' => [ 'base' => '<p>Describes a VPC with a security group that references your security group.</p>', 'refs' => [ 'SecurityGroupReferences$member' => NULL, ], ], 'SecurityGroupReferences' => [ 'base' => NULL, 'refs' => [ 'DescribeSecurityGroupReferencesResult$SecurityGroupReferenceSet' => '<p>Information about the VPCs with the referencing security groups.</p>', ], ], 'SecurityGroupStringList' => [ 'base' => NULL, 'refs' => [ 'ImportInstanceLaunchSpecification$GroupNames' => '<p>The security group names.</p>', 'RequestLaunchTemplateData$SecurityGroups' => '<p>[EC2-Classic, default VPC] One or more security group names. For a nondefault VPC, you must use security group IDs instead. You cannot specify both a security group ID and security name in the same request.</p>', 'RunInstancesRequest$SecurityGroups' => '<p>[EC2-Classic, default VPC] The names of the security groups. For a nondefault VPC, you must use security group IDs instead.</p> <p>If you specify a network interface, you must specify any security groups as part of the network interface.</p> <p>Default: Amazon EC2 uses the default security group.</p>', ], ], 'SendDiagnosticInterruptRequest' => [ 'base' => NULL, 'refs' => [], ], 'SensitiveUserData' => [ 'base' => NULL, 'refs' => [ 'KeyPair$KeyMaterial' => '<p>An unencrypted PEM encoded RSA private key.</p>', ], ], 'ServiceConfiguration' => [ 'base' => '<p>Describes a service configuration for a VPC endpoint service.</p>', 'refs' => [ 'CreateVpcEndpointServiceConfigurationResult$ServiceConfiguration' => '<p>Information about the service configuration.</p>', 'ServiceConfigurationSet$member' => NULL, ], ], 'ServiceConfigurationSet' => [ 'base' => NULL, 'refs' => [ 'DescribeVpcEndpointServiceConfigurationsResult$ServiceConfigurations' => '<p>Information about one or more services.</p>', ], ], 'ServiceDetail' => [ 'base' => '<p>Describes a VPC endpoint service.</p>', 'refs' => [ 'ServiceDetailSet$member' => NULL, ], ], 'ServiceDetailSet' => [ 'base' => NULL, 'refs' => [ 'DescribeVpcEndpointServicesResult$ServiceDetails' => '<p>Information about the service.</p>', ], ], 'ServiceState' => [ 'base' => NULL, 'refs' => [ 'ServiceConfiguration$ServiceState' => '<p>The service state.</p>', ], ], 'ServiceType' => [ 'base' => NULL, 'refs' => [ 'ServiceTypeDetail$ServiceType' => '<p>The type of service.</p>', ], ], 'ServiceTypeDetail' => [ 'base' => '<p>Describes the type of service for a VPC endpoint.</p>', 'refs' => [ 'ServiceTypeDetailSet$member' => NULL, ], ], 'ServiceTypeDetailSet' => [ 'base' => NULL, 'refs' => [ 'ServiceConfiguration$ServiceType' => '<p>The type of service.</p>', 'ServiceDetail$ServiceType' => '<p>The type of service.</p>', ], ], 'ShutdownBehavior' => [ 'base' => NULL, 'refs' => [ 'ImportInstanceLaunchSpecification$InstanceInitiatedShutdownBehavior' => '<p>Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).</p>', 'RequestLaunchTemplateData$InstanceInitiatedShutdownBehavior' => '<p>Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).</p> <p>Default: <code>stop</code> </p>', 'ResponseLaunchTemplateData$InstanceInitiatedShutdownBehavior' => '<p>Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).</p>', 'RunInstancesRequest$InstanceInitiatedShutdownBehavior' => '<p>Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).</p> <p>Default: <code>stop</code> </p>', ], ], 'SlotDateTimeRangeRequest' => [ 'base' => '<p>Describes the time period for a Scheduled Instance to start its first schedule. The time period must span less than one day.</p>', 'refs' => [ 'DescribeScheduledInstanceAvailabilityRequest$FirstSlotStartTimeRange' => '<p>The time period for the first schedule to start.</p>', ], ], 'SlotStartTimeRangeRequest' => [ 'base' => '<p>Describes the time period for a Scheduled Instance to start its first schedule.</p>', 'refs' => [ 'DescribeScheduledInstancesRequest$SlotStartTimeRange' => '<p>The time period for the first schedule to start.</p>', ], ], 'Snapshot' => [ 'base' => '<p>Describes a snapshot.</p>', 'refs' => [ 'SnapshotList$member' => NULL, ], ], 'SnapshotAttributeName' => [ 'base' => NULL, 'refs' => [ 'DescribeSnapshotAttributeRequest$Attribute' => '<p>The snapshot attribute you would like to view.</p>', 'ModifySnapshotAttributeRequest$Attribute' => '<p>The snapshot attribute to modify. Only volume creation permissions can be modified.</p>', 'ResetSnapshotAttributeRequest$Attribute' => '<p>The attribute to reset. Currently, only the attribute for permission to create volumes can be reset.</p>', ], ], 'SnapshotDetail' => [ 'base' => '<p>Describes the snapshot created from the imported disk.</p>', 'refs' => [ 'SnapshotDetailList$member' => NULL, ], ], 'SnapshotDetailList' => [ 'base' => NULL, 'refs' => [ 'ImportImageResult$SnapshotDetails' => '<p>Information about the snapshots.</p>', 'ImportImageTask$SnapshotDetails' => '<p>Information about the snapshots.</p>', ], ], 'SnapshotDiskContainer' => [ 'base' => '<p>The disk container object for the import snapshot request.</p>', 'refs' => [ 'ImportSnapshotRequest$DiskContainer' => '<p>Information about the disk container.</p>', ], ], 'SnapshotId' => [ 'base' => NULL, 'refs' => [ 'CreateVolumeRequest$SnapshotId' => '<p>The snapshot from which to create the volume. You must specify either a snapshot ID or a volume size.</p>', 'DeleteSnapshotRequest$SnapshotId' => '<p>The ID of the EBS snapshot.</p>', 'DescribeSnapshotAttributeRequest$SnapshotId' => '<p>The ID of the EBS snapshot.</p>', 'ImageDiskContainer$SnapshotId' => '<p>The ID of the EBS snapshot to be used for importing the snapshot.</p>', 'LaunchTemplateEbsBlockDevice$SnapshotId' => '<p>The ID of the snapshot.</p>', 'LaunchTemplateEbsBlockDeviceRequest$SnapshotId' => '<p>The ID of the snapshot.</p>', 'ModifySnapshotAttributeRequest$SnapshotId' => '<p>The ID of the snapshot.</p>', 'ResetSnapshotAttributeRequest$SnapshotId' => '<p>The ID of the snapshot.</p>', 'ScheduledInstancesEbs$SnapshotId' => '<p>The ID of the snapshot.</p>', 'SnapshotIdStringList$member' => NULL, ], ], 'SnapshotIdStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeSnapshotsRequest$SnapshotIds' => '<p>The snapshot IDs.</p> <p>Default: Describes the snapshots for which you have create volume permissions.</p>', 'DisableFastSnapshotRestoresRequest$SourceSnapshotIds' => '<p>The IDs of one or more snapshots. For example, <code>snap-1234567890abcdef0</code>.</p>', 'EnableFastSnapshotRestoresRequest$SourceSnapshotIds' => '<p>The IDs of one or more snapshots. For example, <code>snap-1234567890abcdef0</code>. You can specify a snapshot that was shared with you from another AWS account.</p>', ], ], 'SnapshotInfo' => [ 'base' => '<p>Information about a snapshot.</p>', 'refs' => [ 'SnapshotSet$member' => NULL, ], ], 'SnapshotList' => [ 'base' => NULL, 'refs' => [ 'DescribeSnapshotsResult$Snapshots' => '<p>Information about the snapshots.</p>', ], ], 'SnapshotSet' => [ 'base' => NULL, 'refs' => [ 'CreateSnapshotsResult$Snapshots' => '<p>List of snapshots.</p>', ], ], 'SnapshotState' => [ 'base' => NULL, 'refs' => [ 'Snapshot$State' => '<p>The snapshot state.</p>', 'SnapshotInfo$State' => '<p>Current state of the snapshot.</p>', ], ], 'SnapshotTaskDetail' => [ 'base' => '<p>Details about the import snapshot task.</p>', 'refs' => [ 'ImportSnapshotResult$SnapshotTaskDetail' => '<p>Information about the import snapshot task.</p>', 'ImportSnapshotTask$SnapshotTaskDetail' => '<p>Describes an import snapshot task.</p>', ], ], 'SpotAllocationStrategy' => [ 'base' => NULL, 'refs' => [ 'SpotOptions$AllocationStrategy' => '<p>Indicates how to allocate the target Spot Instance capacity across the Spot Instance pools specified by the EC2 Fleet.</p> <p>If the allocation strategy is <code>lowest-price</code>, EC2 Fleet launches instances from the Spot Instance pools with the lowest price. This is the default allocation strategy.</p> <p>If the allocation strategy is <code>diversified</code>, EC2 Fleet launches instances from all of the Spot Instance pools that you specify.</p> <p>If the allocation strategy is <code>capacity-optimized</code>, EC2 Fleet launches instances from Spot Instance pools with optimal capacity for the number of instances that are launching.</p>', 'SpotOptionsRequest$AllocationStrategy' => '<p>Indicates how to allocate the target Spot Instance capacity across the Spot Instance pools specified by the EC2 Fleet.</p> <p>If the allocation strategy is <code>lowest-price</code>, EC2 Fleet launches instances from the Spot Instance pools with the lowest price. This is the default allocation strategy.</p> <p>If the allocation strategy is <code>diversified</code>, EC2 Fleet launches instances from all of the Spot Instance pools that you specify.</p> <p>If the allocation strategy is <code>capacity-optimized</code>, EC2 Fleet launches instances from Spot Instance pools with optimal capacity for the number of instances that are launching.</p>', ], ], 'SpotDatafeedSubscription' => [ 'base' => '<p>Describes the data feed for a Spot Instance.</p>', 'refs' => [ 'CreateSpotDatafeedSubscriptionResult$SpotDatafeedSubscription' => '<p>The Spot Instance data feed subscription.</p>', 'DescribeSpotDatafeedSubscriptionResult$SpotDatafeedSubscription' => '<p>The Spot Instance data feed subscription.</p>', ], ], 'SpotFleetLaunchSpecification' => [ 'base' => '<p>Describes the launch specification for one or more Spot Instances. If you include On-Demand capacity in your fleet request, you can\'t use <code>SpotFleetLaunchSpecification</code>; you must use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_LaunchTemplateConfig.html">LaunchTemplateConfig</a>.</p>', 'refs' => [ 'LaunchSpecsList$member' => NULL, ], ], 'SpotFleetMonitoring' => [ 'base' => '<p>Describes whether monitoring is enabled.</p>', 'refs' => [ 'SpotFleetLaunchSpecification$Monitoring' => '<p>Enable or disable monitoring for the instances.</p>', ], ], 'SpotFleetRequestConfig' => [ 'base' => '<p>Describes a Spot Fleet request.</p>', 'refs' => [ 'SpotFleetRequestConfigSet$member' => NULL, ], ], 'SpotFleetRequestConfigData' => [ 'base' => '<p>Describes the configuration of a Spot Fleet request.</p>', 'refs' => [ 'RequestSpotFleetRequest$SpotFleetRequestConfig' => '<p>The configuration for the Spot Fleet request.</p>', 'SpotFleetRequestConfig$SpotFleetRequestConfig' => '<p>The configuration of the Spot Fleet request.</p>', ], ], 'SpotFleetRequestConfigSet' => [ 'base' => NULL, 'refs' => [ 'DescribeSpotFleetRequestsResponse$SpotFleetRequestConfigs' => '<p>Information about the configuration of your Spot Fleet.</p>', ], ], 'SpotFleetRequestId' => [ 'base' => NULL, 'refs' => [ 'DescribeSpotFleetInstancesRequest$SpotFleetRequestId' => '<p>The ID of the Spot Fleet request.</p>', 'DescribeSpotFleetRequestHistoryRequest$SpotFleetRequestId' => '<p>The ID of the Spot Fleet request.</p>', 'ModifySpotFleetRequestRequest$SpotFleetRequestId' => '<p>The ID of the Spot Fleet request.</p>', 'SpotFleetRequestIdList$member' => NULL, ], ], 'SpotFleetRequestIdList' => [ 'base' => NULL, 'refs' => [ 'CancelSpotFleetRequestsRequest$SpotFleetRequestIds' => '<p>The IDs of the Spot Fleet requests.</p>', 'DescribeSpotFleetRequestsRequest$SpotFleetRequestIds' => '<p>The IDs of the Spot Fleet requests.</p>', ], ], 'SpotFleetTagSpecification' => [ 'base' => '<p>The tags for a Spot Fleet resource.</p>', 'refs' => [ 'SpotFleetTagSpecificationList$member' => NULL, ], ], 'SpotFleetTagSpecificationList' => [ 'base' => NULL, 'refs' => [ 'SpotFleetLaunchSpecification$TagSpecifications' => '<p>The tags to apply during creation.</p>', ], ], 'SpotInstanceInterruptionBehavior' => [ 'base' => NULL, 'refs' => [ 'SpotOptions$InstanceInterruptionBehavior' => '<p>The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.</p>', 'SpotOptionsRequest$InstanceInterruptionBehavior' => '<p>The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.</p>', ], ], 'SpotInstanceRequest' => [ 'base' => '<p>Describes a Spot Instance request.</p>', 'refs' => [ 'SpotInstanceRequestList$member' => NULL, ], ], 'SpotInstanceRequestId' => [ 'base' => NULL, 'refs' => [ 'SpotInstanceRequestIdList$member' => NULL, ], ], 'SpotInstanceRequestIdList' => [ 'base' => NULL, 'refs' => [ 'CancelSpotInstanceRequestsRequest$SpotInstanceRequestIds' => '<p>One or more Spot Instance request IDs.</p>', 'DescribeSpotInstanceRequestsRequest$SpotInstanceRequestIds' => '<p>One or more Spot Instance request IDs.</p>', ], ], 'SpotInstanceRequestList' => [ 'base' => NULL, 'refs' => [ 'DescribeSpotInstanceRequestsResult$SpotInstanceRequests' => '<p>One or more Spot Instance requests.</p>', 'RequestSpotInstancesResult$SpotInstanceRequests' => '<p>One or more Spot Instance requests.</p>', ], ], 'SpotInstanceState' => [ 'base' => NULL, 'refs' => [ 'SpotInstanceRequest$State' => '<p>The state of the Spot Instance request. Spot status information helps track your Spot Instance requests. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html">Spot status</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>', ], ], 'SpotInstanceStateFault' => [ 'base' => '<p>Describes a Spot Instance state change.</p>', 'refs' => [ 'SpotDatafeedSubscription$Fault' => '<p>The fault codes for the Spot Instance request, if any.</p>', 'SpotInstanceRequest$Fault' => '<p>The fault codes for the Spot Instance request, if any.</p>', ], ], 'SpotInstanceStatus' => [ 'base' => '<p>Describes the status of a Spot Instance request.</p>', 'refs' => [ 'SpotInstanceRequest$Status' => '<p>The status code and status message describing the Spot Instance request.</p>', ], ], 'SpotInstanceType' => [ 'base' => NULL, 'refs' => [ 'LaunchTemplateSpotMarketOptions$SpotInstanceType' => '<p>The Spot Instance request type.</p>', 'LaunchTemplateSpotMarketOptionsRequest$SpotInstanceType' => '<p>The Spot Instance request type.</p>', 'RequestSpotInstancesRequest$Type' => '<p>The Spot Instance request type.</p> <p>Default: <code>one-time</code> </p>', 'SpotInstanceRequest$Type' => '<p>The Spot Instance request type.</p>', 'SpotMarketOptions$SpotInstanceType' => '<p>The Spot Instance request type. For <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances">RunInstances</a>, persistent Spot Instance requests are only supported when <b>InstanceInterruptionBehavior</b> is set to either <code>hibernate</code> or <code>stop</code>.</p>', ], ], 'SpotMarketOptions' => [ 'base' => '<p>The options for Spot Instances.</p>', 'refs' => [ 'InstanceMarketOptionsRequest$SpotOptions' => '<p>The options for Spot Instances.</p>', ], ], 'SpotOptions' => [ 'base' => '<p>Describes the configuration of Spot Instances in an EC2 Fleet.</p>', 'refs' => [ 'FleetData$SpotOptions' => '<p>The configuration of Spot Instances in an EC2 Fleet.</p>', ], ], 'SpotOptionsRequest' => [ 'base' => '<p>Describes the configuration of Spot Instances in an EC2 Fleet request.</p>', 'refs' => [ 'CreateFleetRequest$SpotOptions' => '<p>Describes the configuration of Spot Instances in an EC2 Fleet.</p>', ], ], 'SpotPlacement' => [ 'base' => '<p>Describes Spot Instance placement.</p>', 'refs' => [ 'LaunchSpecification$Placement' => '<p>The placement information for the instance.</p>', 'RequestSpotLaunchSpecification$Placement' => '<p>The placement information for the instance.</p>', 'SpotFleetLaunchSpecification$Placement' => '<p>The placement information.</p>', ], ], 'SpotPrice' => [ 'base' => '<p>Describes the maximum price per hour that you are willing to pay for a Spot Instance.</p>', 'refs' => [ 'SpotPriceHistoryList$member' => NULL, ], ], 'SpotPriceHistoryList' => [ 'base' => NULL, 'refs' => [ 'DescribeSpotPriceHistoryResult$SpotPriceHistory' => '<p>The historical Spot prices.</p>', ], ], 'StaleIpPermission' => [ 'base' => '<p>Describes a stale rule in a security group.</p>', 'refs' => [ 'StaleIpPermissionSet$member' => NULL, ], ], 'StaleIpPermissionSet' => [ 'base' => NULL, 'refs' => [ 'StaleSecurityGroup$StaleIpPermissions' => '<p>Information about the stale inbound rules in the security group.</p>', 'StaleSecurityGroup$StaleIpPermissionsEgress' => '<p>Information about the stale outbound rules in the security group.</p>', ], ], 'StaleSecurityGroup' => [ 'base' => '<p>Describes a stale security group (a security group that contains stale rules).</p>', 'refs' => [ 'StaleSecurityGroupSet$member' => NULL, ], ], 'StaleSecurityGroupSet' => [ 'base' => NULL, 'refs' => [ 'DescribeStaleSecurityGroupsResult$StaleSecurityGroupSet' => '<p>Information about the stale security groups.</p>', ], ], 'StartInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartInstancesResult' => [ 'base' => NULL, 'refs' => [], ], 'StartVpcEndpointServicePrivateDnsVerificationRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartVpcEndpointServicePrivateDnsVerificationResult' => [ 'base' => NULL, 'refs' => [], ], 'State' => [ 'base' => NULL, 'refs' => [ 'VpcEndpoint$State' => '<p>The state of the VPC endpoint.</p>', 'VpcEndpointConnection$VpcEndpointState' => '<p>The state of the VPC endpoint.</p>', ], ], 'StateReason' => [ 'base' => '<p>Describes a state change.</p>', 'refs' => [ 'Image$StateReason' => '<p>The reason for the state change.</p>', 'Instance$StateReason' => '<p>The reason for the most recent state transition.</p>', ], ], 'Status' => [ 'base' => NULL, 'refs' => [ 'MoveAddressToVpcResult$Status' => '<p>The status of the move of the IP address.</p>', 'RestoreAddressToClassicResult$Status' => '<p>The move status for the IP address.</p>', ], ], 'StatusName' => [ 'base' => NULL, 'refs' => [ 'InstanceStatusDetails$Name' => '<p>The type of instance status.</p>', ], ], 'StatusType' => [ 'base' => NULL, 'refs' => [ 'InstanceStatusDetails$Status' => '<p>The status.</p>', ], ], 'StopInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopInstancesResult' => [ 'base' => NULL, 'refs' => [], ], 'Storage' => [ 'base' => '<p>Describes the storage location for an instance store-backed AMI.</p>', 'refs' => [ 'BundleInstanceRequest$Storage' => '<p>The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2 returns an error.</p>', 'BundleTask$Storage' => '<p>The Amazon S3 storage locations.</p>', ], ], 'StorageLocation' => [ 'base' => '<p>Describes a storage location in Amazon S3.</p>', 'refs' => [ 'CreateFpgaImageRequest$InputStorageLocation' => '<p>The location of the encrypted design checkpoint in Amazon S3. The input must be a tarball.</p>', 'CreateFpgaImageRequest$LogsStorageLocation' => '<p>The location in Amazon S3 for the output logs.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AcceptReservedInstancesExchangeQuoteResult$ExchangeId' => '<p>The ID of the successful exchange.</p>', 'AccountAttribute$AttributeName' => '<p>The name of the account attribute.</p>', 'AccountAttributeValue$AttributeValue' => '<p>The value of the attribute.</p>', 'ActiveInstance$InstanceId' => '<p>The ID of the instance.</p>', 'ActiveInstance$InstanceType' => '<p>The instance type.</p>', 'ActiveInstance$SpotInstanceRequestId' => '<p>The ID of the Spot Instance request.</p>', 'AddPrefixListEntry$Cidr' => '<p>The CIDR block.</p>', 'AddPrefixListEntry$Description' => '<p>A description for the entry.</p> <p>Constraints: Up to 255 characters in length.</p>', 'Address$InstanceId' => '<p>The ID of the instance that the address is associated with (if any).</p>', 'Address$PublicIp' => '<p>The Elastic IP address.</p>', 'Address$AllocationId' => '<p>The ID representing the allocation of the address for use with EC2-VPC.</p>', 'Address$AssociationId' => '<p>The ID representing the association of the address with an instance in a VPC.</p>', 'Address$NetworkInterfaceId' => '<p>The ID of the network interface.</p>', 'Address$NetworkInterfaceOwnerId' => '<p>The ID of the AWS account that owns the network interface.</p>', 'Address$PrivateIpAddress' => '<p>The private IP address associated with the Elastic IP address.</p>', 'Address$PublicIpv4Pool' => '<p>The ID of an address pool.</p>', 'Address$NetworkBorderGroup' => '<p>The name of the unique set of Availability Zones, Local Zones, or Wavelength Zones from which AWS advertises IP addresses. </p>', 'Address$CustomerOwnedIp' => '<p>The customer-owned IP address.</p>', 'Address$CustomerOwnedIpv4Pool' => '<p>The ID of the customer-owned address pool.</p>', 'Address$CarrierIp' => '<p>The carrier IP address associated. This option is only available for network interfaces which reside in a subnet in a Wavelength Zone (for example an EC2 instance). </p>', 'AdvertiseByoipCidrRequest$Cidr' => '<p>The address range, in CIDR notation. This must be the exact range that you provisioned. You can\'t advertise only a portion of the provisioned range.</p>', 'AllocateAddressRequest$PublicIpv4Pool' => '<p>The ID of an address pool that you own. Use this parameter to let Amazon EC2 select an address from the address pool. To specify a specific address from the address pool, use the <code>Address</code> parameter instead.</p>', 'AllocateAddressRequest$NetworkBorderGroup' => '<p> A unique set of Availability Zones, Local Zones, or Wavelength Zones from which AWS advertises IP addresses. Use this parameter to limit the IP address to this location. IP addresses cannot move between network border groups.</p> <p>Use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAvailabilityZones.html">DescribeAvailabilityZones</a> to view the network border groups.</p> <note> <p>You cannot use a network border group with EC2 Classic. If you attempt this operation on EC2 classic, you will receive an <code>InvalidParameterCombination</code> error. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html">Error Codes</a>.</p> </note>', 'AllocateAddressRequest$CustomerOwnedIpv4Pool' => '<p>The ID of a customer-owned address pool. Use this parameter to let Amazon EC2 select an address from the address pool. Alternatively, specify a specific address from the address pool.</p>', 'AllocateAddressResult$PublicIp' => '<p>The Elastic IP address.</p>', 'AllocateAddressResult$AllocationId' => '<p>[EC2-VPC] The ID that AWS assigns to represent the allocation of the Elastic IP address for use with instances in a VPC.</p>', 'AllocateAddressResult$PublicIpv4Pool' => '<p>The ID of an address pool.</p>', 'AllocateAddressResult$NetworkBorderGroup' => '<p>The set of Availability Zones, Local Zones, or Wavelength Zones from which AWS advertises IP addresses.</p>', 'AllocateAddressResult$CustomerOwnedIp' => '<p>The customer-owned IP address.</p>', 'AllocateAddressResult$CustomerOwnedIpv4Pool' => '<p>The ID of the customer-owned address pool.</p>', 'AllocateAddressResult$CarrierIp' => '<p>The carrier IP address. This option is only available for network interfaces which reside in a subnet in a Wavelength Zone (for example an EC2 instance). </p>', 'AllocateHostsRequest$AvailabilityZone' => '<p>The Availability Zone in which to allocate the Dedicated Host.</p>', 'AllocateHostsRequest$ClientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure Idempotency</a>.</p>', 'AllocateHostsRequest$InstanceType' => '<p>Specifies the instance type to be supported by the Dedicated Hosts. If you specify an instance type, the Dedicated Hosts support instances of the specified instance type only.</p> <p>If you want the Dedicated Hosts to support multiple instance types in a specific instance family, omit this parameter and specify <b>InstanceFamily</b> instead. You cannot specify <b>InstanceType</b> and <b>InstanceFamily</b> in the same request.</p>', 'AllocateHostsRequest$InstanceFamily' => '<p>Specifies the instance family to be supported by the Dedicated Hosts. If you specify an instance family, the Dedicated Hosts support multiple instance types within that instance family.</p> <p>If you want the Dedicated Hosts to support a specific instance type only, omit this parameter and specify 