<?php
// This file was auto-generated from sdk-root/src/data/connect/2017-08-08/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Connect is a cloud-based contact center solution that makes it easy to set up and manage a customer contact center and provide reliable customer engagement at any scale.</p> <p>Amazon Connect provides rich metrics and real-time reporting that allow you to optimize contact routing. You can also resolve customer issues more efficiently by putting customers in touch with the right agents.</p> <p>There are limits to the number of Amazon Connect resources that you can create and limits to the number of requests that you can make per second. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon Connect Service Limits</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'operations' => [ 'CreateUser' => '<p>Creates a user account for the specified Amazon Connect instance.</p>', 'DeleteUser' => '<p>Deletes a user account from the specified Amazon Connect instance.</p>', 'DescribeUser' => '<p>Describes the specified user account. You can find the instance ID in the console (it’s the final part of the ARN). The console does not display the user IDs. Instead, list the users and note the IDs provided in the output.</p>', 'DescribeUserHierarchyGroup' => '<p>Describes the specified hierarchy group.</p>', 'DescribeUserHierarchyStructure' => '<p>Describes the hierarchy structure of the specified Amazon Connect instance.</p>', 'GetContactAttributes' => '<p>Retrieves the contact attributes for the specified contact.</p>', 'GetCurrentMetricData' => '<p>Gets the real-time metric data from the specified Amazon Connect instance.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-reports.html">Real-time Metrics Reports</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'GetFederationToken' => '<p>Retrieves a token for federation.</p>', 'GetMetricData' => '<p>Gets historical metric data from the specified Amazon Connect instance.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics.html">Historical Metrics Reports</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'ListContactFlows' => '<p>Provides information about the contact flows for the specified Amazon Connect instance.</p>', 'ListHoursOfOperations' => '<p>Provides information about the hours of operation for the specified Amazon Connect instance.</p>', 'ListPhoneNumbers' => '<p>Provides information about the phone numbers for the specified Amazon Connect instance.</p>', 'ListQueues' => '<p>Provides information about the queues for the specified Amazon Connect instance.</p>', 'ListRoutingProfiles' => '<p>Provides summary information about the routing profiles for the specified Amazon Connect instance.</p>', 'ListSecurityProfiles' => '<p>Provides summary information about the security profiles for the specified Amazon Connect instance.</p>', 'ListTagsForResource' => '<p>Lists the tags for the specified resource.</p>', 'ListUserHierarchyGroups' => '<p>Provides summary information about the hierarchy groups for the specified Amazon Connect instance.</p>', 'ListUsers' => '<p>Provides summary information about the users for the specified Amazon Connect instance.</p>', 'ResumeContactRecording' => '<p>When a contact is being recorded, and the recording has been suspended using SuspendContactRecording, this API resumes recording the call.</p> <p>Only voice recordings are supported at this time.</p>', 'StartChatContact' => '<p>Initiates a contact flow to start a new chat for the customer. Response of this API provides a token required to obtain credentials from the <a href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html">CreateParticipantConnection</a> API in the Amazon Connect Participant Service.</p> <p>When a new chat contact is successfully created, clients need to subscribe to the participant’s connection for the created chat within 5 minutes. This is achieved by invoking <a href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html">CreateParticipantConnection</a> with WEBSOCKET and CONNECTION_CREDENTIALS. </p>', 'StartContactRecording' => '<p>This API starts recording the contact when the agent joins the call. StartContactRecording is a one-time action. For example, if you use StopContactRecording to stop recording an ongoing call, you can\'t use StartContactRecording to restart it. For scenarios where the recording has started and you want to suspend and resume it, such as when collecting sensitive information (for example, a credit card number), use SuspendContactRecording and ResumeContactRecording.</p> <p>You can use this API to override the recording behavior configured in the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/set-recording-behavior.html">Set recording behavior</a> block.</p> <p>Only voice recordings are supported at this time.</p>', 'StartOutboundVoiceContact' => '<p>This API places an outbound call to a contact, and then initiates the contact flow. It performs the actions in the contact flow that\'s specified (in <code>ContactFlowId</code>).</p> <p>Agents are not involved in initiating the outbound API (that is, dialing the contact). If the contact flow places an outbound call to a contact, and then puts the contact in queue, that\'s when the call is routed to the agent, like any other inbound case.</p> <p>There is a 60 second dialing timeout for this operation. If the call is not connected after 60 seconds, it fails.</p>', 'StopContact' => '<p>Ends the specified contact.</p>', 'StopContactRecording' => '<p>When a contact is being recorded, this API stops recording the call. StopContactRecording is a one-time action. If you use StopContactRecording to stop recording an ongoing call, you can\'t use StartContactRecording to restart it. For scenarios where the recording has started and you want to suspend it for sensitive information (for example, to collect a credit card number), and then restart it, use SuspendContactRecording and ResumeContactRecording.</p> <p>Only voice recordings are supported at this time.</p>', 'SuspendContactRecording' => '<p>When a contact is being recorded, this API suspends recording the call. For example, you might suspend the call recording while collecting sensitive information, such as a credit card number. Then use ResumeContactRecording to restart recording. </p> <p>The period of time that the recording is suspended is filled with silence in the final recording. </p> <p>Only voice recordings are supported at this time.</p>', 'TagResource' => '<p>Adds the specified tags to the specified resource.</p> <p>The supported resource type is users.</p>', 'UntagResource' => '<p>Removes the specified tags from the specified resource.</p>', 'UpdateContactAttributes' => '<p>Creates or updates the contact attributes associated with the specified contact.</p> <p>You can add or update attributes for both ongoing and completed contacts. For example, you can update the customer\'s name or the reason the customer called while the call is active, or add notes about steps that the agent took during the call that are displayed to the next agent that takes the call. You can also update attributes for a contact using data from your CRM application and save the data with the contact in Amazon Connect. You could also flag calls for additional analysis, such as legal review or identifying abusive callers.</p> <p>Contact attributes are available in Amazon Connect for 24 months, and are then deleted.</p> <p> <b>Important:</b> You cannot use the operation to update attributes for contacts that occurred prior to the release of the API, September 12, 2018. You can update attributes only for contacts that started after the release of the API. If you attempt to update attributes for a contact that occurred prior to the release of the API, a 400 error is returned. This applies also to queued callbacks that were initiated prior to the release of the API but are still active in your instance.</p>', 'UpdateUserHierarchy' => '<p>Assigns the specified hierarchy group to the specified user.</p>', 'UpdateUserIdentityInfo' => '<p>Updates the identity information for the specified user.</p>', 'UpdateUserPhoneConfig' => '<p>Updates the phone configuration settings for the specified user.</p>', 'UpdateUserRoutingProfile' => '<p>Assigns the specified routing profile to the specified user.</p>', 'UpdateUserSecurityProfiles' => '<p>Assigns the specified security profiles to the specified user.</p>', ], 'shapes' => [ 'ARN' => [ 'base' => NULL, 'refs' => [ 'ContactFlowSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the contact flow.</p>', 'CreateUserResponse$UserArn' => '<p>The Amazon Resource Name (ARN) of the user account.</p>', 'HierarchyGroup$Arn' => '<p>The Amazon Resource Name (ARN) of the hierarchy group.</p>', 'HierarchyGroupSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the hierarchy group.</p>', 'HierarchyLevel$Arn' => '<p>The Amazon Resource Name (ARN) of the hierarchy level.</p>', 'HoursOfOperationSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the hours of operation.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'PhoneNumberSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the phone number.</p>', 'QueueReference$Arn' => '<p>The Amazon Resource Name (ARN) of the queue.</p>', 'QueueSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the queue.</p>', 'RoutingProfileSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the routing profile.</p>', 'SecurityProfileSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the security profile.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'User$Arn' => '<p>The Amazon Resource Name (ARN) of the user account.</p>', 'UserSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the user account.</p>', ], ], 'AfterContactWorkTimeLimit' => [ 'base' => NULL, 'refs' => [ 'UserPhoneConfig$AfterContactWorkTimeLimit' => '<p>The After Call Work (ACW) timeout setting, in seconds.</p>', ], ], 'AgentFirstName' => [ 'base' => NULL, 'refs' => [ 'UserIdentityInfo$FirstName' => '<p>The first name. This is required if you are using Amazon Connect or SAML for identity management.</p>', ], ], 'AgentLastName' => [ 'base' => NULL, 'refs' => [ 'UserIdentityInfo$LastName' => '<p>The last name. This is required if you are using Amazon Connect or SAML for identity management.</p>', ], ], 'AgentUsername' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$Username' => '<p>The user name for the account. For instances not using SAML for identity management, the user name can include up to 20 characters. If you are using SAML for identity management, the user name can include up to 64 characters from [a-zA-Z0-9_-.\\@]+.</p>', 'User$Username' => '<p>The user name assigned to the user account.</p>', 'UserSummary$Username' => '<p>The Amazon Connect user name of the user account.</p>', ], ], 'AttributeName' => [ 'base' => NULL, 'refs' => [ 'Attributes$key' => NULL, ], ], 'AttributeValue' => [ 'base' => NULL, 'refs' => [ 'Attributes$value' => NULL, ], ], 'Attributes' => [ 'base' => NULL, 'refs' => [ 'GetContactAttributesResponse$Attributes' => '<p>Information about the attributes.</p>', 'StartChatContactRequest$Attributes' => '<p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in contact flows just like any other contact attributes. </p> <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>', 'StartOutboundVoiceContactRequest$Attributes' => '<p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in contact flows just like any other contact attributes.</p> <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>', 'UpdateContactAttributesRequest$Attributes' => '<p>The Amazon Connect attributes. These attributes can be accessed in contact flows just like any other contact attributes.</p> <p>You can have up to 32,768 UTF-8 bytes across all attributes for a contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>', ], ], 'AutoAccept' => [ 'base' => NULL, 'refs' => [ 'UserPhoneConfig$AutoAccept' => '<p>The Auto accept setting.</p>', ], ], 'Channel' => [ 'base' => NULL, 'refs' => [ 'Channels$member' => NULL, 'Dimensions$Channel' => '<p>The channel used for grouping and filters.</p>', ], ], 'Channels' => [ 'base' => NULL, 'refs' => [ 'Filters$Channels' => '<p>The channel to use to filter the metrics.</p>', ], ], 'ChatContent' => [ 'base' => NULL, 'refs' => [ 'ChatMessage$Content' => '<p>The content of the chat message.</p>', ], ], 'ChatContentType' => [ 'base' => NULL, 'refs' => [ 'ChatMessage$ContentType' => '<p>The type of the content. Supported types are text/plain.</p>', ], ], 'ChatMessage' => [ 'base' => '<p>A chat message.</p>', 'refs' => [ 'StartChatContactRequest$InitialMessage' => '<p>The initial message to be sent to the newly created chat.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'StartChatContactRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'StartOutboundVoiceContactRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. The token is valid for 7 days after creation. If a contact is already started, the contact ID is returned. If the contact is disconnected, a new contact is started.</p>', ], ], 'Comparison' => [ 'base' => NULL, 'refs' => [ 'Threshold$Comparison' => '<p>The type of comparison. Only "less than" (LT) comparisons are supported.</p>', ], ], 'ContactFlowId' => [ 'base' => NULL, 'refs' => [ 'ContactFlowSummary$Id' => '<p>The identifier of the contact flow.</p>', 'StartChatContactRequest$ContactFlowId' => '<p>The identifier of the contact flow for the chat.</p>', 'StartOutboundVoiceContactRequest$ContactFlowId' => '<p>The identifier of the contact flow for the outbound call.</p>', ], ], 'ContactFlowName' => [ 'base' => NULL, 'refs' => [ 'ContactFlowSummary$Name' => '<p>The name of the contact flow.</p>', ], ], 'ContactFlowSummary' => [ 'base' => '<p>Contains summary information about a contact flow.</p>', 'refs' => [ 'ContactFlowSummaryList$member' => NULL, ], ], 'ContactFlowSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListContactFlowsResponse$ContactFlowSummaryList' => '<p>Information about the contact flows.</p>', ], ], 'ContactFlowType' => [ 'base' => NULL, 'refs' => [ 'ContactFlowSummary$ContactFlowType' => '<p>The type of contact flow.</p>', 'ContactFlowTypes$member' => NULL, ], ], 'ContactFlowTypes' => [ 'base' => NULL, 'refs' => [ 'ListContactFlowsRequest$ContactFlowTypes' => '<p>The type of contact flow.</p>', ], ], 'ContactId' => [ 'base' => NULL, 'refs' => [ 'GetContactAttributesRequest$InitialContactId' => '<p>The identifier of the initial contact.</p>', 'ResumeContactRecordingRequest$ContactId' => '<p>The identifier of the contact.</p>', 'ResumeContactRecordingRequest$InitialContactId' => '<p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>', 'StartChatContactResponse$ContactId' => '<p>The identifier of this contact within the Amazon Connect instance. </p>', 'StartContactRecordingRequest$ContactId' => '<p>The identifier of the contact.</p>', 'StartContactRecordingRequest$InitialContactId' => '<p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>', 'StartOutboundVoiceContactResponse$ContactId' => '<p>The identifier of this contact within the Amazon Connect instance.</p>', 'StopContactRecordingRequest$ContactId' => '<p>The identifier of the contact.</p>', 'StopContactRecordingRequest$InitialContactId' => '<p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>', 'StopContactRequest$ContactId' => '<p>The ID of the contact.</p>', 'SuspendContactRecordingRequest$ContactId' => '<p>The identifier of the contact.</p>', 'SuspendContactRecordingRequest$InitialContactId' => '<p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>', 'UpdateContactAttributesRequest$InitialContactId' => '<p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>', ], ], 'ContactNotFoundException' => [ 'base' => '<p>The contact with the specified ID is not active or does not exist.</p>', 'refs' => [], ], 'CreateUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'Credentials' => [ 'base' => '<p>Contains credentials to use for federation.</p>', 'refs' => [ 'GetFederationTokenResponse$Credentials' => '<p>The credentials to use for federation.</p>', ], ], 'CurrentMetric' => [ 'base' => '<p>Contains information about a real-time metric. For a description of each metric, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'refs' => [ 'CurrentMetricData$Metric' => '<p>Information about the metric.</p>', 'CurrentMetrics$member' => NULL, ], ], 'CurrentMetricData' => [ 'base' => '<p>Contains the data for a real-time metric.</p>', 'refs' => [ 'CurrentMetricDataCollections$member' => NULL, ], ], 'CurrentMetricDataCollections' => [ 'base' => NULL, 'refs' => [ 'CurrentMetricResult$Collections' => '<p>The set of metrics.</p>', ], ], 'CurrentMetricName' => [ 'base' => '<p>The current metric names.</p>', 'refs' => [ 'CurrentMetric$Name' => '<p>The name of the metric.</p>', ], ], 'CurrentMetricResult' => [ 'base' => '<p>Contains information about a set of real-time metrics.</p>', 'refs' => [ 'CurrentMetricResults$member' => NULL, ], ], 'CurrentMetricResults' => [ 'base' => NULL, 'refs' => [ 'GetCurrentMetricDataResponse$MetricResults' => '<p>Information about the real-time metrics.</p>', ], ], 'CurrentMetrics' => [ 'base' => NULL, 'refs' => [ 'GetCurrentMetricDataRequest$CurrentMetrics' => '<p>The metrics to retrieve. Specify the name and unit for each metric. The following metrics are available. For a description of each metric, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p> <dl> <dt>AGENTS_AFTER_CONTACT_WORK</dt> <dd> <p>Unit: COUNT</p> </dd> <dt>AGENTS_AVAILABLE</dt> <dd> <p>Unit: COUNT</p> </dd> <dt>AGENTS_ERROR</dt> <dd> <p>Unit: COUNT</p> </dd> <dt>AGENTS_NON_PRODUCTIVE</dt> <dd> <p>Unit: COUNT</p> </dd> <dt>AGENTS_ON_CALL</dt> <dd> <p>Unit: COUNT</p> </dd> <dt>AGENTS_ON_CONTACT</dt> <dd> <p>Unit: COUNT</p> </dd> <dt>AGENTS_ONLINE</dt> <dd> <p>Unit: COUNT</p> </dd> <dt>AGENTS_STAFFED</dt> <dd> <p>Unit: COUNT</p> </dd> <dt>CONTACTS_IN_QUEUE</dt> <dd> <p>Unit: COUNT</p> </dd> <dt>CONTACTS_SCHEDULED</dt> <dd> <p>Unit: COUNT</p> </dd> <dt>OLDEST_CONTACT_AGE</dt> <dd> <p>Unit: SECONDS</p> </dd> <dt>SLOTS_ACTIVE</dt> <dd> <p>Unit: COUNT</p> </dd> <dt>SLOTS_AVAILABLE</dt> <dd> <p>Unit: COUNT</p> </dd> </dl>', ], ], 'DeleteUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserHierarchyGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserHierarchyGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserHierarchyStructureRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserHierarchyStructureResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'DestinationNotAllowedException' => [ 'base' => '<p>Outbound calls to the destination number are not allowed.</p>', 'refs' => [], ], 'Dimensions' => [ 'base' => '<p>Contains information about the dimensions for a set of metrics.</p>', 'refs' => [ 'CurrentMetricResult$Dimensions' => '<p>The dimensions for the metrics.</p>', 'HistoricalMetricResult$Dimensions' => '<p>The dimension for the metrics.</p>', ], ], 'DirectoryUserId' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$DirectoryUserId' => '<p>The identifier of the user account in the directory used for identity management. If Amazon Connect cannot access the directory, you can specify this identifier to authenticate users. If you include the identifier, we assume that Amazon Connect cannot access the directory. Otherwise, the identity information is used to authenticate users from your directory.</p> <p>This parameter is required if you are using an existing directory for identity management in Amazon Connect when Amazon Connect cannot access your directory to authenticate users. If you are using SAML for identity management and include this parameter, an error is returned.</p>', 'User$DirectoryUserId' => '<p>The identifier of the user account in the directory used for identity management.</p>', ], ], 'DisplayName' => [ 'base' => NULL, 'refs' => [ 'ParticipantDetails$DisplayName' => '<p>Display name of the participant.</p>', ], ], 'DuplicateResourceException' => [ 'base' => '<p>A resource with the specified name already exists.</p>', 'refs' => [], ], 'Email' => [ 'base' => NULL, 'refs' => [ 'UserIdentityInfo$Email' => '<p>The email address. If you are using SAML for identity management and include this parameter, an error is returned.</p>', ], ], 'Filters' => [ 'base' => '<p>Contains the filter to apply when retrieving metrics.</p>', 'refs' => [ 'GetCurrentMetricDataRequest$Filters' => '<p>The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is retrieved only for the resources associated with the queues or channels included in the filter. You can include both queue IDs and queue ARNs in the same request. The only supported channel is <code>VOICE</code>.</p>', 'GetMetricDataRequest$Filters' => '<p>The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is retrieved only for the resources associated with the queues or channels included in the filter. You can include both queue IDs and queue ARNs in the same request. The only supported channel is <code>VOICE</code>.</p>', ], ], 'GetContactAttributesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetContactAttributesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCurrentMetricDataRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCurrentMetricDataResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFederationTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFederationTokenResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMetricDataRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMetricDataResponse' => [ 'base' => NULL, 'refs' => [], ], 'Grouping' => [ 'base' => NULL, 'refs' => [ 'Groupings$member' => NULL, ], ], 'Groupings' => [ 'base' => NULL, 'refs' => [ 'GetCurrentMetricDataRequest$Groupings' => '<p>The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the metrics returned apply to each queue rather than aggregated for all queues. If you group by <code>CHANNEL</code>, you should include a Channels filter. The only supported channel is <code>VOICE</code>.</p> <p>If no <code>Grouping</code> is included in the request, a summary of metrics is returned.</p>', 'GetMetricDataRequest$Groupings' => '<p>The grouping applied to the metrics returned. For example, when results are grouped by queue, the metrics returned are grouped by queue. The values returned apply to the metrics for each queue rather than aggregated for all queues.</p> <p>The only supported grouping is <code>QUEUE</code>.</p> <p>If no grouping is specified, a summary of metrics for all queues is returned.</p>', ], ], 'HierarchyGroup' => [ 'base' => '<p>Contains information about a hierarchy group.</p>', 'refs' => [ 'DescribeUserHierarchyGroupResponse$HierarchyGroup' => '<p>Information about the hierarchy group.</p>', ], ], 'HierarchyGroupId' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$HierarchyGroupId' => '<p>The identifier of the hierarchy group for the user.</p>', 'DescribeUserHierarchyGroupRequest$HierarchyGroupId' => '<p>The identifier of the hierarchy group.</p>', 'HierarchyGroup$Id' => '<p>The identifier of the hierarchy group.</p>', 'HierarchyGroupSummary$Id' => '<p>The identifier of the hierarchy group.</p>', 'UpdateUserHierarchyRequest$HierarchyGroupId' => '<p>The identifier of the hierarchy group.</p>', 'User$HierarchyGroupId' => '<p>The identifier of the hierarchy group for the user.</p>', ], ], 'HierarchyGroupName' => [ 'base' => NULL, 'refs' => [ 'HierarchyGroup$Name' => '<p>The name of the hierarchy group.</p>', 'HierarchyGroupSummary$Name' => '<p>The name of the hierarchy group.</p>', ], ], 'HierarchyGroupSummary' => [ 'base' => '<p>Contains summary information about a hierarchy group.</p>', 'refs' => [ 'HierarchyGroupSummaryList$member' => NULL, 'HierarchyPath$LevelOne' => '<p>Information about level one.</p>', 'HierarchyPath$LevelTwo' => '<p>Information about level two.</p>', 'HierarchyPath$LevelThree' => '<p>Information about level three.</p>', 'HierarchyPath$LevelFour' => '<p>Information about level four.</p>', 'HierarchyPath$LevelFive' => '<p>Information about level five.</p>', ], ], 'HierarchyGroupSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListUserHierarchyGroupsResponse$UserHierarchyGroupSummaryList' => '<p>Information about the hierarchy groups.</p>', ], ], 'HierarchyLevel' => [ 'base' => '<p>Contains information about a hierarchy level.</p>', 'refs' => [ 'HierarchyStructure$LevelOne' => '<p>Information about level one.</p>', 'HierarchyStructure$LevelTwo' => '<p>Information about level two.</p>', 'HierarchyStructure$LevelThree' => '<p>Information about level three.</p>', 'HierarchyStructure$LevelFour' => '<p>Information about level four.</p>', 'HierarchyStructure$LevelFive' => '<p>Information about level five.</p>', ], ], 'HierarchyLevelId' => [ 'base' => NULL, 'refs' => [ 'HierarchyGroup$LevelId' => '<p>The identifier of the level in the hierarchy group.</p>', 'HierarchyLevel$Id' => '<p>The identifier of the hierarchy level.</p>', ], ], 'HierarchyLevelName' => [ 'base' => NULL, 'refs' => [ 'HierarchyLevel$Name' => '<p>The name of the hierarchy level.</p>', ], ], 'HierarchyPath' => [ 'base' => '<p>Contains information about the levels of a hierarchy group.</p>', 'refs' => [ 'HierarchyGroup$HierarchyPath' => '<p>Information about the levels in the hierarchy group.</p>', ], ], 'HierarchyStructure' => [ 'base' => '<p>Contains information about a hierarchy structure.</p>', 'refs' => [ 'DescribeUserHierarchyStructureResponse$HierarchyStructure' => '<p>Information about the hierarchy structure.</p>', ], ], 'HistoricalMetric' => [ 'base' => '<p>Contains information about a historical metric. For a description of each metric, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'refs' => [ 'HistoricalMetricData$Metric' => '<p>Information about the metric.</p>', 'HistoricalMetrics$member' => NULL, ], ], 'HistoricalMetricData' => [ 'base' => '<p>Contains the data for a historical metric.</p>', 'refs' => [ 'HistoricalMetricDataCollections$member' => NULL, ], ], 'HistoricalMetricDataCollections' => [ 'base' => NULL, 'refs' => [ 'HistoricalMetricResult$Collections' => '<p>The set of metrics.</p>', ], ], 'HistoricalMetricName' => [ 'base' => '<p>The historical metric names.</p>', 'refs' => [ 'HistoricalMetric$Name' => '<p>The name of the metric.</p>', ], ], 'HistoricalMetricResult' => [ 'base' => '<p>Contains information about the historical metrics retrieved.</p>', 'refs' => [ 'HistoricalMetricResults$member' => NULL, ], ], 'HistoricalMetricResults' => [ 'base' => NULL, 'refs' => [ 'GetMetricDataResponse$MetricResults' => '<p>Information about the historical metrics.</p> <p>If no grouping is specified, a summary of metric data is returned.</p>', ], ], 'HistoricalMetrics' => [ 'base' => NULL, 'refs' => [ 'GetMetricDataRequest$HistoricalMetrics' => '<p>The metrics to retrieve. Specify the name, unit, and statistic for each metric. The following historical metrics are available. For a description of each metric, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p> <dl> <dt>ABANDON_TIME</dt> <dd> <p>Unit: SECONDS</p> <p>Statistic: AVG</p> </dd> <dt>AFTER_CONTACT_WORK_TIME</dt> <dd> <p>Unit: SECONDS</p> <p>Statistic: AVG</p> </dd> <dt>API_CONTACTS_HANDLED</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CALLBACK_CONTACTS_HANDLED</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_ABANDONED</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_AGENT_HUNG_UP_FIRST</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_CONSULTED</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_HANDLED</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_HANDLED_INCOMING</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_HANDLED_OUTBOUND</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_HOLD_ABANDONS</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_MISSED</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_QUEUED</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_TRANSFERRED_IN</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_TRANSFERRED_IN_FROM_QUEUE</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_TRANSFERRED_OUT</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>HANDLE_TIME</dt> <dd> <p>Unit: SECONDS</p> <p>Statistic: AVG</p> </dd> <dt>HOLD_TIME</dt> <dd> <p>Unit: SECONDS</p> <p>Statistic: AVG</p> </dd> <dt>INTERACTION_AND_HOLD_TIME</dt> <dd> <p>Unit: SECONDS</p> <p>Statistic: AVG</p> </dd> <dt>INTERACTION_TIME</dt> <dd> <p>Unit: SECONDS</p> <p>Statistic: AVG</p> </dd> <dt>OCCUPANCY</dt> <dd> <p>Unit: PERCENT</p> <p>Statistic: AVG</p> </dd> <dt>QUEUE_ANSWER_TIME</dt> <dd> <p>Unit: SECONDS</p> <p>Statistic: AVG</p> </dd> <dt>QUEUED_TIME</dt> <dd> <p>Unit: SECONDS</p> <p>Statistic: MAX</p> </dd> <dt>SERVICE_LEVEL</dt> <dd> <p>Unit: PERCENT</p> <p>Statistic: AVG</p> <p>Threshold: Only "Less than" comparisons are supported, with the following service level thresholds: 15, 20, 25, 30, 45, 60, 90, 120, 180, 240, 300, 600</p> </dd> </dl>', ], ], 'HoursOfOperationId' => [ 'base' => NULL, 'refs' => [ 'HoursOfOperationSummary$Id' => '<p>The identifier of the hours of operation.</p>', ], ], 'HoursOfOperationName' => [ 'base' => NULL, 'refs' => [ 'HoursOfOperationSummary$Name' => '<p>The name of the hours of operation.</p>', ], ], 'HoursOfOperationSummary' => [ 'base' => '<p>Contains summary information about hours of operation for a contact center.</p>', 'refs' => [ 'HoursOfOperationSummaryList$member' => NULL, ], ], 'HoursOfOperationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListHoursOfOperationsResponse$HoursOfOperationSummaryList' => '<p>Information about the hours of operation.</p>', ], ], 'InstanceId' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'DeleteUserRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'DescribeUserHierarchyGroupRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'DescribeUserHierarchyStructureRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'DescribeUserRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'GetContactAttributesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'GetCurrentMetricDataRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'GetFederationTokenRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'GetMetricDataRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'ListContactFlowsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'ListHoursOfOperationsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'ListPhoneNumbersRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'ListQueuesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'ListRoutingProfilesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'ListSecurityProfilesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'ListUserHierarchyGroupsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'ListUsersRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'ResumeContactRecordingRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'StartChatContactRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'StartContactRecordingRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'StartOutboundVoiceContactRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'StopContactRecordingRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'StopContactRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'SuspendContactRecordingRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'UpdateContactAttributesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'UpdateUserHierarchyRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'UpdateUserIdentityInfoRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'UpdateUserPhoneConfigRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'UpdateUserRoutingProfileRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'UpdateUserSecurityProfilesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', ], ], 'InternalServiceException' => [ 'base' => '<p>Request processing failed due to an error or failure with the service.</p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => '<p>One or more of the specified parameters are not valid.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>The request is not valid.</p>', 'refs' => [], ], 'LimitExceededException' => [ 'base' => '<p>The allowed limit for the resource has been exceeded.</p>', 'refs' => [], ], 'ListContactFlowsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListContactFlowsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListHoursOfOperationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListHoursOfOperationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPhoneNumbersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPhoneNumbersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListQueuesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListQueuesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRoutingProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRoutingProfilesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityProfilesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUserHierarchyGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUserHierarchyGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResult100' => [ 'base' => NULL, 'refs' => [ 'GetCurrentMetricDataRequest$MaxResults' => '<p>The maximimum number of results to return per page.</p>', 'GetMetricDataRequest$MaxResults' => '<p>The maximimum number of results to return per page.</p>', ], ], 'MaxResult1000' => [ 'base' => NULL, 'refs' => [ 'ListContactFlowsRequest$MaxResults' => '<p>The maximimum number of results to return per page.</p>', 'ListHoursOfOperationsRequest$MaxResults' => '<p>The maximimum number of results to return per page.</p>', 'ListPhoneNumbersRequest$MaxResults' => '<p>The maximimum number of results to return per page.</p>', 'ListQueuesRequest$MaxResults' => '<p>The maximimum number of results to return per page.</p>', 'ListRoutingProfilesRequest$MaxResults' => '<p>The maximimum number of results to return per page.</p>', 'ListSecurityProfilesRequest$MaxResults' => '<p>The maximimum number of results to return per page.</p>', 'ListUserHierarchyGroupsRequest$MaxResults' => '<p>The maximimum number of results to return per page.</p>', 'ListUsersRequest$MaxResults' => '<p>The maximimum number of results to return per page.</p>', ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'ContactNotFoundException$Message' => '<p>The message.</p>', 'DestinationNotAllowedException$Message' => '<p>The message.</p>', 'DuplicateResourceException$Message' => NULL, 'InternalServiceException$Message' => '<p>The message.</p>', 'InvalidParameterException$Message' => '<p>The message.</p>', 'InvalidRequestException$Message' => '<p>The message.</p>', 'LimitExceededException$Message' => '<p>The message.</p>', 'OutboundContactNotPermittedException$Message' => '<p>The message.</p>', 'ResourceNotFoundException$Message' => '<p>The message.</p>', 'ThrottlingException$Message' => NULL, 'UserNotFoundException$Message' => NULL, ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'GetCurrentMetricDataRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p> <p>The token expires after 5 minutes from the time it is created. Subsequent requests that use the token must use the same request parameters as the request that generated the token.</p>', 'GetCurrentMetricDataResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p> <p>The token expires after 5 minutes from the time it is created. Subsequent requests that use the token must use the same request parameters as the request that generated the token.</p>', 'GetMetricDataRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'GetMetricDataResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p> <p>The token expires after 5 minutes from the time it is created. Subsequent requests that use the token must use the same request parameters as the request that generated the token.</p>', 'ListContactFlowsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListContactFlowsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListHoursOfOperationsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListHoursOfOperationsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListPhoneNumbersRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListPhoneNumbersResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListQueuesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListQueuesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListRoutingProfilesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListRoutingProfilesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListSecurityProfilesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListSecurityProfilesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListUserHierarchyGroupsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListUserHierarchyGroupsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListUsersRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListUsersResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', ], ], 'OutboundContactNotPermittedException' => [ 'base' => '<p>The contact is not permitted.</p>', 'refs' => [], ], 'ParticipantDetails' => [ 'base' => '<p>The customer\'s details.</p>', 'refs' => [ 'StartChatContactRequest$ParticipantDetails' => '<p>Information identifying the participant.</p>', ], ], 'ParticipantId' => [ 'base' => NULL, 'refs' => [ 'StartChatContactResponse$ParticipantId' => '<p>The identifier for a chat participant. The participantId for a chat participant is the same throughout the chat lifecycle.</p>', ], ], 'ParticipantToken' => [ 'base' => NULL, 'refs' => [ 'StartChatContactResponse$ParticipantToken' => '<p>The token used by the chat participant to call <a href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html">CreateParticipantConnection</a>. The participant token is valid for the lifetime of a chat participant.</p>', ], ], 'Password' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$Password' => '<p>The password for the user account. A password is required if you are using Amazon Connect for identity management. Otherwise, it is an error to include a password.</p>', ], ], 'PhoneNumber' => [ 'base' => NULL, 'refs' => [ 'PhoneNumberSummary$PhoneNumber' => '<p>The phone number.</p>', 'StartOutboundVoiceContactRequest$DestinationPhoneNumber' => '<p>The phone number of the customer, in E.164 format.</p>', 'StartOutboundVoiceContactRequest$SourcePhoneNumber' => '<p>The phone number associated with the Amazon Connect instance, in E.164 format. If you do not specify a source phone number, you must specify a queue.</p>', 'UserPhoneConfig$DeskPhoneNumber' => '<p>The phone number for the user\'s desk phone.</p>', ], ], 'PhoneNumberCountryCode' => [ 'base' => NULL, 'refs' => [ 'PhoneNumberCountryCodes$member' => NULL, 'PhoneNumberSummary$PhoneNumberCountryCode' => '<p>The ISO country code.</p>', ], ], 'PhoneNumberCountryCodes' => [ 'base' => NULL, 'refs' => [ 'ListPhoneNumbersRequest$PhoneNumberCountryCodes' => '<p>The ISO country code.</p>', ], ], 'PhoneNumberId' => [ 'base' => NULL, 'refs' => [ 'PhoneNumberSummary$Id' => '<p>The identifier of the phone number.</p>', ], ], 'PhoneNumberSummary' => [ 'base' => '<p>Contains summary information about a phone number for a contact center.</p>', 'refs' => [ 'PhoneNumberSummaryList$member' => NULL, ], ], 'PhoneNumberSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListPhoneNumbersResponse$PhoneNumberSummaryList' => '<p>Information about the phone numbers.</p>', ], ], 'PhoneNumberType' => [ 'base' => NULL, 'refs' => [ 'PhoneNumberSummary$PhoneNumberType' => '<p>The type of phone number.</p>', 'PhoneNumberTypes$member' => NULL, ], ], 'PhoneNumberTypes' => [ 'base' => NULL, 'refs' => [ 'ListPhoneNumbersRequest$PhoneNumberTypes' => '<p>The type of phone number.</p>', ], ], 'PhoneType' => [ 'base' => NULL, 'refs' => [ 'UserPhoneConfig$PhoneType' => '<p>The phone type.</p>', ], ], 'QueueId' => [ 'base' => NULL, 'refs' => [ 'QueueReference$Id' => '<p>The identifier of the queue.</p>', 'QueueSummary$Id' => '<p>The identifier of the queue.</p>', 'Queues$member' => NULL, 'StartOutboundVoiceContactRequest$QueueId' => '<p>The queue for the call. If you specify a queue, the phone displayed for caller ID is the phone number specified in the queue. If you do not specify a queue, the queue defined in the contact flow is used. If you do not specify a queue, you must specify a source phone number.</p>', ], ], 'QueueName' => [ 'base' => NULL, 'refs' => [ 'QueueSummary$Name' => '<p>The name of the queue.</p>', ], ], 'QueueReference' => [ 'base' => '<p>Contains information about a queue resource for which metrics are returned.</p>', 'refs' => [ 'Dimensions$Queue' => '<p>Information about the queue for which metrics are returned.</p>', ], ], 'QueueSummary' => [ 'base' => '<p>Contains summary information about a queue.</p>', 'refs' => [ 'QueueSummaryList$member' => NULL, ], ], 'QueueSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListQueuesResponse$QueueSummaryList' => '<p>Information about the queues.</p>', ], ], 'QueueType' => [ 'base' => NULL, 'refs' => [ 'QueueSummary$QueueType' => '<p>The type of queue.</p>', 'QueueTypes$member' => NULL, ], ], 'QueueTypes' => [ 'base' => NULL, 'refs' => [ 'ListQueuesRequest$QueueTypes' => '<p>The type of queue.</p>', ], ], 'Queues' => [ 'base' => NULL, 'refs' => [ 'Filters$Queues' => '<p>The queues to use to filter the metrics. You can specify up to 100 queues per request.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource was not found.</p>', 'refs' => [], ], 'ResumeContactRecordingRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResumeContactRecordingResponse' => [ 'base' => NULL, 'refs' => [], ], 'RoutingProfileId' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$RoutingProfileId' => '<p>The identifier of the routing profile for the user.</p>', 'RoutingProfileSummary$Id' => '<p>The identifier of the routing profile.</p>', 'UpdateUserRoutingProfileRequest$RoutingProfileId' => '<p>The identifier of the routing profile for the user.</p>', 'User$RoutingProfileId' => '<p>The identifier of the routing profile for the user.</p>', ], ], 'RoutingProfileName' => [ 'base' => NULL, 'refs' => [ 'RoutingProfileSummary$Name' => '<p>The name of the routing profile.</p>', ], ], 'RoutingProfileSummary' => [ 'base' => '<p>Contains summary information about a routing profile.</p>', 'refs' => [ 'RoutingProfileSummaryList$member' => NULL, ], ], 'RoutingProfileSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListRoutingProfilesResponse$RoutingProfileSummaryList' => '<p>Information about the routing profiles.</p>', ], ], 'SecurityProfileId' => [ 'base' => NULL, 'refs' => [ 'SecurityProfileIds$member' => NULL, 'SecurityProfileSummary$Id' => '<p>The identifier of the security profile.</p>', ], ], 'SecurityProfileIds' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$SecurityProfileIds' => '<p>The identifier of the security profile for the user.</p>', 'UpdateUserSecurityProfilesRequest$SecurityProfileIds' => '<p>The identifiers of the security profiles for the user.</p>', 'User$SecurityProfileIds' => '<p>The identifiers of the security profiles for the user.</p>', ], ], 'SecurityProfileName' => [ 'base' => NULL, 'refs' => [ 'SecurityProfileSummary$Name' => '<p>The name of the security profile.</p>', ], ], 'SecurityProfileSummary' => [ 'base' => '<p>Contains information about a security profile.</p>', 'refs' => [ 'SecurityProfileSummaryList$member' => NULL, ], ], 'SecurityProfileSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListSecurityProfilesResponse$SecurityProfileSummaryList' => '<p>Information about the security profiles.</p>', ], ], 'SecurityToken' => [ 'base' => NULL, 'refs' => [ 'Credentials$AccessToken' => '<p>An access token generated for a federated user to access Amazon Connect.</p>', 'Credentials$RefreshToken' => '<p>Renews a token generated for a user to access the Amazon Connect instance.</p>', ], ], 'StartChatContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartChatContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartContactRecordingRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartContactRecordingResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartOutboundVoiceContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartOutboundVoiceContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'Statistic' => [ 'base' => NULL, 'refs' => [ 'HistoricalMetric$Statistic' => '<p>The statistic for the metric.</p>', ], ], 'StopContactRecordingRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopContactRecordingResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'SuspendContactRecordingRequest' => [ 'base' => NULL, 'refs' => [], ], 'SuspendContactRecordingResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The tag keys.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$Tags' => '<p>One or more tags.</p>', 'ListTagsForResourceResponse$tags' => '<p>Information about the tags.</p>', 'TagResourceRequest$tags' => '<p>One or more tags. For example, { "tags": {"key1":"value1", "key2":"value2"} }.</p>', 'User$Tags' => '<p>The tags.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'Threshold' => [ 'base' => '<p>Contains information about the threshold for service level metrics.</p>', 'refs' => [ 'HistoricalMetric$Threshold' => '<p>The threshold for the metric, used with service level metrics.</p>', ], ], 'ThresholdValue' => [ 'base' => NULL, 'refs' => [ 'Threshold$ThresholdValue' => '<p>The threshold value to compare.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The throttling limit has been exceeded.</p>', 'refs' => [], ], 'Unit' => [ 'base' => NULL, 'refs' => [ 'CurrentMetric$Unit' => '<p>The unit for the metric.</p>', 'HistoricalMetric$Unit' => '<p>The unit for the metric.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactAttributesRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactAttributesResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserHierarchyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserIdentityInfoRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserPhoneConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserRoutingProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserSecurityProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'User' => [ 'base' => '<p>Contains information about a user account for a Amazon Connect instance.</p>', 'refs' => [ 'DescribeUserResponse$User' => '<p>Information about the user account and configuration settings.</p>', ], ], 'UserId' => [ 'base' => NULL, 'refs' => [ 'CreateUserResponse$UserId' => '<p>The identifier of the user account.</p>', 'DeleteUserRequest$UserId' => '<p>The identifier of the user.</p>', 'DescribeUserRequest$UserId' => '<p>The identifier of the user account.</p>', 'UpdateUserHierarchyRequest$UserId' => '<p>The identifier of the user account.</p>', 'UpdateUserIdentityInfoRequest$UserId' => '<p>The identifier of the user account.</p>', 'UpdateUserPhoneConfigRequest$UserId' => '<p>The identifier of the user account.</p>', 'UpdateUserRoutingProfileRequest$UserId' => '<p>The identifier of the user account.</p>', 'UpdateUserSecurityProfilesRequest$UserId' => '<p>The identifier of the user account.</p>', 'User$Id' => '<p>The identifier of the user account.</p>', 'UserSummary$Id' => '<p>The identifier of the user account.</p>', ], ], 'UserIdentityInfo' => [ 'base' => '<p>Contains information about the identity of a user.</p>', 'refs' => [ 'CreateUserRequest$IdentityInfo' => '<p>The information about the identity of the user.</p>', 'UpdateUserIdentityInfoRequest$IdentityInfo' => '<p>The identity information for the user.</p>', 'User$IdentityInfo' => '<p>Information about the user identity.</p>', ], ], 'UserNotFoundException' => [ 'base' => '<p>No user with the specified credentials was found in the Amazon Connect instance.</p>', 'refs' => [], ], 'UserPhoneConfig' => [ 'base' => '<p>Contains information about the phone configuration settings for a user.</p>', 'refs' => [ 'CreateUserRequest$PhoneConfig' => '<p>The phone settings for the user.</p>', 'UpdateUserPhoneConfigRequest$PhoneConfig' => '<p>Information about phone configuration settings for the user.</p>', 'User$PhoneConfig' => '<p>Information about the phone configuration for the user.</p>', ], ], 'UserSummary' => [ 'base' => '<p>Contains summary information about a user.</p>', 'refs' => [ 'UserSummaryList$member' => NULL, ], ], 'UserSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListUsersResponse$UserSummaryList' => '<p>Information about the users.</p>', ], ], 'Value' => [ 'base' => NULL, 'refs' => [ 'CurrentMetricData$Value' => '<p>The value of the metric.</p>', 'HistoricalMetricData$Value' => '<p>The value of the metric.</p>', ], ], 'VoiceRecordingConfiguration' => [ 'base' => '<p>Contains information about the recording configuration settings.</p>', 'refs' => [ 'StartContactRecordingRequest$VoiceRecordingConfiguration' => '<p>Who is being recorded.</p>', ], ], 'VoiceRecordingTrack' => [ 'base' => NULL, 'refs' => [ 'VoiceRecordingConfiguration$VoiceRecordingTrack' => '<p>Identifies which track is being recorded.</p>', ], ], 'timestamp' => [ 'base' => NULL, 'refs' => [ 'Credentials$AccessTokenExpiration' => '<p>A token generated with an expiration time for the session a user is logged in to Amazon Connect.</p>', 'Credentials$RefreshTokenExpiration' => '<p>Renews the expiration timer for a generated token.</p>', 'GetCurrentMetricDataResponse$DataSnapshotTime' => '<p>The time at which the metrics were retrieved and cached for pagination.</p>', 'GetMetricDataRequest$StartTime' => '<p>The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of historical metrics data. The time must be specified using a multiple of 5 minutes, such as 10:05, 10:10, 10:15.</p> <p>The start time cannot be earlier than 24 hours before the time of the request. Historical metrics are available only for 24 hours.</p>', 'GetMetricDataRequest$EndTime' => '<p>The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of historical metrics data. The time must be specified using an interval of 5 minutes, such as 11:00, 11:05, 11:10, and must be later than the start time timestamp.</p> <p>The time range between the start and end time must be less than 24 hours.</p>', ], ], ],];
