<?php
// This file was auto-generated from sdk-root/src/data/codestar-connections/2019-12-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>AWS CodeStar Connections</fullname> <important> <p>The CodeStar Connections feature is in preview release and is subject to change.</p> </important> <p>This AWS CodeStar Connections API Reference provides descriptions and usage examples of the operations and data types for the AWS CodeStar Connections API. You can use the connections API to work with connections and installations.</p> <p> <i>Connections</i> are configurations that you use to connect AWS resources to external code repositories. Each connection is a resource that can be given to services such as CodePipeline to connect to a third-party repository such as Bitbucket. For example, you can add the connection in CodePipeline so that it triggers your pipeline when a code change is made to your third-party code repository. Each connection is named and associated with a unique ARN that is used to reference the connection.</p> <p>When you create a connection, the console initiates a third-party connection handshake. <i>Installations</i> are the apps that are used to conduct this handshake. For example, the installation for the Bitbucket provider type is the Bitbucket Cloud app. When you create a connection, you can choose an existing installation or create one.</p> <p>When you want to create a connection to an installed provider type such as GitHub Enterprise Server, you create a <i>host</i> for your connections.</p> <p>You can work with connections by calling:</p> <ul> <li> <p> <a>CreateConnection</a>, which creates a uniquely named connection that can be referenced by services such as CodePipeline.</p> </li> <li> <p> <a>DeleteConnection</a>, which deletes the specified connection.</p> </li> <li> <p> <a>GetConnection</a>, which returns information about the connection, including the connection status.</p> </li> <li> <p> <a>ListConnections</a>, which lists the connections associated with your account.</p> </li> </ul> <p>You can work with hosts by calling:</p> <ul> <li> <p> <a>CreateHost</a>, which creates a host that represents the infrastructure where your provider is installed.</p> </li> <li> <p> <a>DeleteHost</a>, which deletes the specified host.</p> </li> <li> <p> <a>GetHost</a>, which returns information about the host, including the setup status.</p> </li> <li> <p> <a>ListHosts</a>, which lists the hosts associated with your account.</p> </li> </ul> <p>You can work with tags in AWS CodeStar Connections by calling the following:</p> <ul> <li> <p> <a>ListTagsForResource</a>, which gets information about AWS tags for a specified Amazon Resource Name (ARN) in AWS CodeStar Connections.</p> </li> <li> <p> <a>TagResource</a>, which adds or updates tags for a resource in AWS CodeStar Connections.</p> </li> <li> <p> <a>UntagResource</a>, which removes tags for a resource in AWS CodeStar Connections.</p> </li> </ul> <p>For information about how to use AWS CodeStar Connections, see the <a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/welcome-connections.html">Developer Tools User Guide</a>.</p>', 'operations' => [ 'CreateConnection' => '<p>Creates a connection that can then be given to other AWS services like CodePipeline so that it can access third-party code repositories. The connection is in pending status until the third-party connection handshake is completed from the console.</p>', 'CreateHost' => '<p>Creates a resource that represents the infrastructure where a third-party provider is installed. The host is used when you create connections to an installed third-party provider type, such as GitHub Enterprise Server. You create one host for all connections to that provider.</p> <note> <p>A host created through the CLI or the SDK is in `PENDING` status by default. You can make its status `AVAILABLE` by setting up the host in the console.</p> </note>', 'DeleteConnection' => '<p>The connection to be deleted.</p>', 'DeleteHost' => '<p>The host to be deleted. Before you delete a host, all connections associated to the host must be deleted.</p> <note> <p>A host cannot be deleted if it is in the VPC_CONFIG_INITIALIZING or VPC_CONFIG_DELETING state.</p> </note>', 'GetConnection' => '<p>Returns the connection ARN and details such as status, owner, and provider type.</p>', 'GetHost' => '<p>Returns the host ARN and details such as status, provider type, endpoint, and, if applicable, the VPC configuration.</p>', 'ListConnections' => '<p>Lists the connections associated with your account.</p>', 'ListHosts' => '<p>Lists the hosts associated with your account.</p>', 'ListTagsForResource' => '<p>Gets the set of key-value pairs (metadata) that are used to manage the resource.</p>', 'TagResource' => '<p>Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.</p>', 'UntagResource' => '<p>Removes tags from an AWS resource.</p>', ], 'shapes' => [ 'AccountId' => [ 'base' => NULL, 'refs' => [ 'Connection$OwnerAccountId' => '<p>The identifier of the external provider where your third-party code repository is configured. For Bitbucket, this is the account ID of the owner of the Bitbucket repository.</p>', ], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource for which you want to get information about tags, if any.</p>', 'TagResourceInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to which you want to add or update tags.</p>', 'UntagResourceInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to remove tags from.</p>', ], ], 'Connection' => [ 'base' => '<p>A resource that is used to connect third-party source providers with services like AWS CodePipeline.</p> <p>Note: A connection created through CloudFormation, the CLI, or the SDK is in `PENDING` status by default. You can make its status `AVAILABLE` by updating the connection in the console.</p>', 'refs' => [ 'ConnectionList$member' => NULL, 'GetConnectionOutput$Connection' => '<p>The connection details, such as status, owner, and provider type.</p>', ], ], 'ConnectionArn' => [ 'base' => NULL, 'refs' => [ 'Connection$ConnectionArn' => '<p>The Amazon Resource Name (ARN) of the connection. The ARN is used as the connection reference when the connection is shared between AWS services.</p> <note> <p>The ARN is never reused if the connection is deleted.</p> </note>', 'CreateConnectionOutput$ConnectionArn' => '<p>The Amazon Resource Name (ARN) of the connection to be created. The ARN is used as the connection reference when the connection is shared between AWS services.</p> <note> <p>The ARN is never reused if the connection is deleted.</p> </note>', 'DeleteConnectionInput$ConnectionArn' => '<p>The Amazon Resource Name (ARN) of the connection to be deleted.</p> <note> <p>The ARN is never reused if the connection is deleted.</p> </note>', 'GetConnectionInput$ConnectionArn' => '<p>The Amazon Resource Name (ARN) of a connection.</p>', ], ], 'ConnectionList' => [ 'base' => NULL, 'refs' => [ 'ListConnectionsOutput$Connections' => '<p>A list of connections and the details for each connection, such as status, owner, and provider type.</p>', ], ], 'ConnectionName' => [ 'base' => NULL, 'refs' => [ 'Connection$ConnectionName' => '<p>The name of the connection. Connection names must be unique in an AWS user account.</p>', 'CreateConnectionInput$ConnectionName' => '<p>The name of the connection to be created. The name must be unique in the calling AWS account.</p>', ], ], 'ConnectionStatus' => [ 'base' => NULL, 'refs' => [ 'Connection$ConnectionStatus' => '<p>The current status of the connection. </p>', ], ], 'CreateConnectionInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateConnectionOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateHostInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateHostOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConnectionInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteConnectionOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteHostInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteHostOutput' => [ 'base' => NULL, 'refs' => [], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'LimitExceededException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ResourceUnavailableException$Message' => NULL, ], ], 'GetConnectionInput' => [ 'base' => NULL, 'refs' => [], ], 'GetConnectionOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetHostInput' => [ 'base' => NULL, 'refs' => [], ], 'GetHostOutput' => [ 'base' => NULL, 'refs' => [], ], 'Host' => [ 'base' => '<p>A resource that represents the infrastructure where a third-party provider is installed. The host is used when you create connections to an installed third-party provider type, such as GitHub Enterprise Server. You create one host for all connections to that provider.</p> <note> <p>A host created through the CLI or the SDK is in `PENDING` status by default. You can make its status `AVAILABLE` by setting up the host in the console.</p> </note>', 'refs' => [ 'HostList$member' => NULL, ], ], 'HostArn' => [ 'base' => NULL, 'refs' => [ 'Connection$HostArn' => '<p>The Amazon Resource Name (ARN) of the host associated with the connection.</p>', 'CreateConnectionInput$HostArn' => '<p>The Amazon Resource Name (ARN) of the host associated with the connection to be created.</p>', 'CreateHostOutput$HostArn' => '<p>The Amazon Resource Name (ARN) of the host to be created.</p>', 'DeleteHostInput$HostArn' => '<p>The Amazon Resource Name (ARN) of the host to be deleted.</p>', 'GetHostInput$HostArn' => '<p>The Amazon Resource Name (ARN) of the requested host.</p>', 'Host$HostArn' => '<p>The Amazon Resource Name (ARN) of the host.</p>', 'ListConnectionsInput$HostArnFilter' => '<p>Filters the list of connections to those associated with a specified host.</p>', ], ], 'HostList' => [ 'base' => NULL, 'refs' => [ 'ListHostsOutput$Hosts' => '<p>A list of hosts and the details for each host, such as status, endpoint, and provider type.</p>', ], ], 'HostName' => [ 'base' => NULL, 'refs' => [ 'CreateHostInput$Name' => '<p>The name of the host to be created. The name must be unique in the calling AWS account.</p>', 'GetHostOutput$Name' => '<p>The name of the requested host.</p>', 'Host$Name' => '<p>The name of the host.</p>', ], ], 'HostStatus' => [ 'base' => NULL, 'refs' => [ 'GetHostOutput$Status' => '<p>The status of the requested host.</p>', 'Host$Status' => '<p>The status of the host, such as PENDING, AVAILABLE, VPC_CONFIG_DELETING, VPC_CONFIG_INITIALIZING, and VPC_CONFIG_FAILED_INITIALIZATION.</p>', ], ], 'HostStatusMessage' => [ 'base' => NULL, 'refs' => [ 'Host$StatusMessage' => '<p>The status description for the host.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>Exceeded the maximum limit for connections.</p>', 'refs' => [], ], 'ListConnectionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListConnectionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListHostsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListHostsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListConnectionsInput$MaxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', 'ListHostsInput$MaxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListConnectionsInput$NextToken' => '<p>The token that was returned from the previous <code>ListConnections</code> call, which can be used to return the next set of connections in the list.</p>', 'ListConnectionsOutput$NextToken' => '<p>A token that can be used in the next <code>ListConnections</code> call. To view all items in the list, continue to call this operation with each subsequent token until no more <code>nextToken</code> values are returned.</p>', 'ListHostsInput$NextToken' => '<p>The token that was returned from the previous <code>ListHosts</code> call, which can be used to return the next set of hosts in the list.</p>', 'ListHostsOutput$NextToken' => '<p>A token that can be used in the next <code>ListHosts</code> call. To view all items in the list, continue to call this operation with each subsequent token until no more <code>nextToken</code> values are returned.</p>', ], ], 'ProviderType' => [ 'base' => NULL, 'refs' => [ 'Connection$ProviderType' => '<p>The name of the external provider where your third-party code repository is configured. The valid provider type is Bitbucket.</p>', 'CreateConnectionInput$ProviderType' => '<p>The name of the external provider where your third-party code repository is configured. The valid provider type is Bitbucket.</p>', 'CreateHostInput$ProviderType' => '<p>The name of the installed provider to be associated with your connection. The host resource represents the infrastructure where your provider type is installed. The valid provider type is GitHub Enterprise Server.</p>', 'GetHostOutput$ProviderType' => '<p>The provider type of the requested host, such as GitHub Enterprise Server.</p>', 'Host$ProviderType' => '<p>The name of the installed provider to be associated with your connection. The host resource represents the infrastructure where your provider type is installed. The valid provider type is GitHub Enterprise Server.</p>', 'ListConnectionsInput$ProviderTypeFilter' => '<p>Filters the list of connections to those associated with a specified provider, such as Bitbucket.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>Resource not found. Verify the connection resource ARN and try again.</p>', 'refs' => [], ], 'ResourceUnavailableException' => [ 'base' => '<p>Resource not found. Verify the ARN for the host resource and try again.</p>', 'refs' => [], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'SecurityGroupIds$member' => NULL, ], ], 'SecurityGroupIds' => [ 'base' => NULL, 'refs' => [ 'VpcConfiguration$SecurityGroupIds' => '<p>The ID of the security group or security groups associated with the Amazon VPC connected to the infrastructure where your provider type is installed.</p>', ], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'SubnetIds$member' => NULL, ], ], 'SubnetIds' => [ 'base' => NULL, 'refs' => [ 'VpcConfiguration$SubnetIds' => '<p>The ID of the subnet or subnets associated with the Amazon VPC connected to the infrastructure where your provider type is installed.</p>', ], ], 'Tag' => [ 'base' => '<p>A tag is a key-value pair that is used to manage the resource.</p> <p>This tag is available for use by AWS services that support tags.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The tag\'s key.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$TagKeys' => '<p>The list of keys for the tags to be removed from the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateConnectionInput$Tags' => '<p>The key-value pair to use when tagging the resource.</p>', 'CreateConnectionOutput$Tags' => '<p>Specifies the tags applied to the resource.</p>', 'ListTagsForResourceOutput$Tags' => '<p>A list of tag key and value pairs associated with the specified resource.</p>', 'TagResourceInput$Tags' => '<p>The tags you want to modify or add to the resource.</p>', ], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The tag\'s value.</p>', ], ], 'TlsCertificate' => [ 'base' => NULL, 'refs' => [ 'VpcConfiguration$TlsCertificate' => '<p>The value of the Transport Layer Security (TLS) certificate associated with the infrastructure where your provider type is installed.</p>', ], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'Url' => [ 'base' => NULL, 'refs' => [ 'CreateHostInput$ProviderEndpoint' => '<p>The endpoint of the infrastructure to be represented by the host after it is created.</p>', 'GetHostOutput$ProviderEndpoint' => '<p>The endpoint of the infrastructure represented by the requested host.</p>', 'Host$ProviderEndpoint' => '<p>The endpoint of the infrastructure where your provider type is installed.</p>', ], ], 'VpcConfiguration' => [ 'base' => '<p>The VPC configuration provisioned for the host.</p>', 'refs' => [ 'CreateHostInput$VpcConfiguration' => '<p>The VPC configuration to be provisioned for the host. A VPC must be configured and the infrastructure to be represented by the host must already be connected to the VPC.</p>', 'GetHostOutput$VpcConfiguration' => '<p>The VPC configuration of the requested host.</p>', 'Host$VpcConfiguration' => '<p>The VPC configuration provisioned for the host.</p>', ], ], 'VpcId' => [ 'base' => NULL, 'refs' => [ 'VpcConfiguration$VpcId' => '<p>The ID of the Amazon VPC connected to the infrastructure where your provider type is installed.</p>', ], ], ],];
