<?php
// This file was auto-generated from sdk-root/src/data/codepipeline/2015-07-09/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>AWS CodePipeline</fullname> <p> <b>Overview</b> </p> <p>This is the AWS CodePipeline API Reference. This guide provides descriptions of the actions and data types for AWS CodePipeline. Some functionality for your pipeline can only be configured through the API. For more information, see the <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/welcome.html">AWS CodePipeline User Guide</a>.</p> <p>You can use the AWS CodePipeline API to work with pipelines, stages, actions, and transitions.</p> <p> <i>Pipelines</i> are models of automated release processes. Each pipeline is uniquely named, and consists of stages, actions, and transitions. </p> <p>You can work with pipelines by calling:</p> <ul> <li> <p> <a>CreatePipeline</a>, which creates a uniquely named pipeline.</p> </li> <li> <p> <a>DeletePipeline</a>, which deletes the specified pipeline.</p> </li> <li> <p> <a>GetPipeline</a>, which returns information about the pipeline structure and pipeline metadata, including the pipeline Amazon Resource Name (ARN).</p> </li> <li> <p> <a>GetPipelineExecution</a>, which returns information about a specific execution of a pipeline.</p> </li> <li> <p> <a>GetPipelineState</a>, which returns information about the current state of the stages and actions of a pipeline.</p> </li> <li> <p> <a>ListActionExecutions</a>, which returns action-level details for past executions. The details include full stage and action-level details, including individual action duration, status, any errors that occurred during the execution, and input and output artifact location details.</p> </li> <li> <p> <a>ListPipelines</a>, which gets a summary of all of the pipelines associated with your account.</p> </li> <li> <p> <a>ListPipelineExecutions</a>, which gets a summary of the most recent executions for a pipeline.</p> </li> <li> <p> <a>StartPipelineExecution</a>, which runs the most recent revision of an artifact through the pipeline.</p> </li> <li> <p> <a>StopPipelineExecution</a>, which stops the specified pipeline execution from continuing through the pipeline.</p> </li> <li> <p> <a>UpdatePipeline</a>, which updates a pipeline with edits or changes to the structure of the pipeline.</p> </li> </ul> <p>Pipelines include <i>stages</i>. Each stage contains one or more actions that must complete before the next stage begins. A stage results in success or failure. If a stage fails, the pipeline stops at that stage and remains stopped until either a new version of an artifact appears in the source location, or a user takes action to rerun the most recent artifact through the pipeline. You can call <a>GetPipelineState</a>, which displays the status of a pipeline, including the status of stages in the pipeline, or <a>GetPipeline</a>, which returns the entire structure of the pipeline, including the stages of that pipeline. For more information about the structure of stages and actions, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/pipeline-structure.html">AWS CodePipeline Pipeline Structure Reference</a>.</p> <p>Pipeline stages include <i>actions</i> that are categorized into categories such as source or build actions performed in a stage of a pipeline. For example, you can use a source action to import artifacts into a pipeline from a source such as Amazon S3. Like stages, you do not work with actions directly in most cases, but you do define and interact with actions when working with pipeline operations such as <a>CreatePipeline</a> and <a>GetPipelineState</a>. Valid action categories are:</p> <ul> <li> <p>Source</p> </li> <li> <p>Build</p> </li> <li> <p>Test</p> </li> <li> <p>Deploy</p> </li> <li> <p>Approval</p> </li> <li> <p>Invoke</p> </li> </ul> <p>Pipelines also include <i>transitions</i>, which allow the transition of artifacts from one stage to the next in a pipeline after the actions in one stage complete.</p> <p>You can work with transitions by calling:</p> <ul> <li> <p> <a>DisableStageTransition</a>, which prevents artifacts from transitioning to the next stage in a pipeline.</p> </li> <li> <p> <a>EnableStageTransition</a>, which enables transition of artifacts between stages in a pipeline. </p> </li> </ul> <p> <b>Using the API to integrate with AWS CodePipeline</b> </p> <p>For third-party integrators or developers who want to create their own integrations with AWS CodePipeline, the expected sequence varies from the standard API user. To integrate with AWS CodePipeline, developers need to work with the following items:</p> <p> <b>Jobs</b>, which are instances of an action. For example, a job for a source action might import a revision of an artifact from a source. </p> <p>You can work with jobs by calling:</p> <ul> <li> <p> <a>AcknowledgeJob</a>, which confirms whether a job worker has received the specified job.</p> </li> <li> <p> <a>GetJobDetails</a>, which returns the details of a job.</p> </li> <li> <p> <a>PollForJobs</a>, which determines whether there are any jobs to act on.</p> </li> <li> <p> <a>PutJobFailureResult</a>, which provides details of a job failure. </p> </li> <li> <p> <a>PutJobSuccessResult</a>, which provides details of a job success.</p> </li> </ul> <p> <b>Third party jobs</b>, which are instances of an action created by a partner action and integrated into AWS CodePipeline. Partner actions are created by members of the AWS Partner Network.</p> <p>You can work with third party jobs by calling:</p> <ul> <li> <p> <a>AcknowledgeThirdPartyJob</a>, which confirms whether a job worker has received the specified job.</p> </li> <li> <p> <a>GetThirdPartyJobDetails</a>, which requests the details of a job for a partner action.</p> </li> <li> <p> <a>PollForThirdPartyJobs</a>, which determines whether there are any jobs to act on. </p> </li> <li> <p> <a>PutThirdPartyJobFailureResult</a>, which provides details of a job failure.</p> </li> <li> <p> <a>PutThirdPartyJobSuccessResult</a>, which provides details of a job success.</p> </li> </ul>', 'operations' => [ 'AcknowledgeJob' => '<p>Returns information about a specified job and whether that job has been received by the job worker. Used for custom actions only.</p>', 'AcknowledgeThirdPartyJob' => '<p>Confirms a job worker has received the specified job. Used for partner actions only.</p>', 'CreateCustomActionType' => '<p>Creates a new custom action that can be used in all pipelines associated with the AWS account. Only used for custom actions.</p>', 'CreatePipeline' => '<p>Creates a pipeline.</p> <note> <p>In the pipeline structure, you must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code>.</p> </note>', 'DeleteCustomActionType' => '<p>Marks a custom action as deleted. <code>PollForJobs</code> for the custom action fails after the action is marked for deletion. Used for custom actions only.</p> <important> <p>To re-create a custom action after it has been deleted you must use a string in the version field that has never been used before. This string can be an incremented version number, for example. To restore a deleted custom action, use a JSON file that is identical to the deleted action, including the original string in the version field.</p> </important>', 'DeletePipeline' => '<p>Deletes the specified pipeline.</p>', 'DeleteWebhook' => '<p>Deletes a previously created webhook by name. Deleting the webhook stops AWS CodePipeline from starting a pipeline every time an external event occurs. The API returns successfully when trying to delete a webhook that is already deleted. If a deleted webhook is re-created by calling PutWebhook with the same name, it will have a different URL.</p>', 'DeregisterWebhookWithThirdParty' => '<p>Removes the connection between the webhook that was created by CodePipeline and the external tool with events to be detected. Currently supported only for webhooks that target an action type of GitHub.</p>', 'DisableStageTransition' => '<p>Prevents artifacts in a pipeline from transitioning to the next stage in the pipeline.</p>', 'EnableStageTransition' => '<p>Enables artifacts in a pipeline to transition to a stage in a pipeline.</p>', 'GetJobDetails' => '<p>Returns information about a job. Used for custom actions only.</p> <important> <p>When this API is called, AWS CodePipeline returns temporary credentials for the S3 bucket used to store artifacts for the pipeline, if the action requires access to that S3 bucket for input or output artifacts. This API also returns any secret values defined for the action.</p> </important>', 'GetPipeline' => '<p>Returns the metadata, structure, stages, and actions of a pipeline. Can be used to return the entire structure of a pipeline in JSON format, which can then be modified and used to update the pipeline structure with <a>UpdatePipeline</a>.</p>', 'GetPipelineExecution' => '<p>Returns information about an execution of a pipeline, including details about artifacts, the pipeline execution ID, and the name, version, and status of the pipeline.</p>', 'GetPipelineState' => '<p>Returns information about the state of a pipeline, including the stages and actions.</p> <note> <p>Values returned in the <code>revisionId</code> and <code>revisionUrl</code> fields indicate the source revision information, such as the commit ID, for the current state.</p> </note>', 'GetThirdPartyJobDetails' => '<p>Requests the details of a job for a third party action. Used for partner actions only.</p> <important> <p>When this API is called, AWS CodePipeline returns temporary credentials for the S3 bucket used to store artifacts for the pipeline, if the action requires access to that S3 bucket for input or output artifacts. This API also returns any secret values defined for the action.</p> </important>', 'ListActionExecutions' => '<p>Lists the action executions that have occurred in a pipeline.</p>', 'ListActionTypes' => '<p>Gets a summary of all AWS CodePipeline action types associated with your account.</p>', 'ListPipelineExecutions' => '<p>Gets a summary of the most recent executions for a pipeline.</p>', 'ListPipelines' => '<p>Gets a summary of all of the pipelines associated with your account.</p>', 'ListTagsForResource' => '<p>Gets the set of key-value pairs (metadata) that are used to manage the resource.</p>', 'ListWebhooks' => '<p>Gets a listing of all the webhooks in this AWS Region for this account. The output lists all webhooks and includes the webhook URL and ARN and the configuration for each webhook.</p>', 'PollForJobs' => '<p>Returns information about any jobs for AWS CodePipeline to act on. <code>PollForJobs</code> is valid only for action types with "Custom" in the owner field. If the action type contains "AWS" or "ThirdParty" in the owner field, the <code>PollForJobs</code> action returns an error.</p> <important> <p>When this API is called, AWS CodePipeline returns temporary credentials for the S3 bucket used to store artifacts for the pipeline, if the action requires access to that S3 bucket for input or output artifacts. This API also returns any secret values defined for the action.</p> </important>', 'PollForThirdPartyJobs' => '<p>Determines whether there are any third party jobs for a job worker to act on. Used for partner actions only.</p> <important> <p>When this API is called, AWS CodePipeline returns temporary credentials for the S3 bucket used to store artifacts for the pipeline, if the action requires access to that S3 bucket for input or output artifacts.</p> </important>', 'PutActionRevision' => '<p>Provides information to AWS CodePipeline about new revisions to a source.</p>', 'PutApprovalResult' => '<p>Provides the response to a manual approval request to AWS CodePipeline. Valid responses include Approved and Rejected.</p>', 'PutJobFailureResult' => '<p>Represents the failure of a job as returned to the pipeline by a job worker. Used for custom actions only.</p>', 'PutJobSuccessResult' => '<p>Represents the success of a job as returned to the pipeline by a job worker. Used for custom actions only.</p>', 'PutThirdPartyJobFailureResult' => '<p>Represents the failure of a third party job as returned to the pipeline by a job worker. Used for partner actions only.</p>', 'PutThirdPartyJobSuccessResult' => '<p>Represents the success of a third party job as returned to the pipeline by a job worker. Used for partner actions only.</p>', 'PutWebhook' => '<p>Defines a webhook and returns a unique webhook URL generated by CodePipeline. This URL can be supplied to third party source hosting providers to call every time there\'s a code change. When CodePipeline receives a POST request on this URL, the pipeline defined in the webhook is started as long as the POST request satisfied the authentication and filtering requirements supplied when defining the webhook. RegisterWebhookWithThirdParty and DeregisterWebhookWithThirdParty APIs can be used to automatically configure supported third parties to call the generated webhook URL.</p>', 'RegisterWebhookWithThirdParty' => '<p>Configures a connection between the webhook that was created and the external tool with events to be detected.</p>', 'RetryStageExecution' => '<p>Resumes the pipeline execution by retrying the last failed actions in a stage. You can retry a stage immediately if any of the actions in the stage fail. When you retry, all actions that are still in progress continue working, and failed actions are triggered again.</p>', 'StartPipelineExecution' => '<p>Starts the specified pipeline. Specifically, it begins processing the latest commit to the source location specified as part of the pipeline.</p>', 'StopPipelineExecution' => '<p>Stops the specified pipeline execution. You choose to either stop the pipeline execution by completing in-progress actions without starting subsequent actions, or by abandoning in-progress actions. While completing or abandoning in-progress actions, the pipeline execution is in a <code>Stopping</code> state. After all in-progress actions are completed or abandoned, the pipeline execution is in a <code>Stopped</code> state.</p>', 'TagResource' => '<p>Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource. </p>', 'UntagResource' => '<p>Removes tags from an AWS resource.</p>', 'UpdatePipeline' => '<p>Updates a specified pipeline with edits or changes to its structure. Use a JSON file with the pipeline structure and <code>UpdatePipeline</code> to provide the full structure of the pipeline. Updating the pipeline increases the version number of the pipeline by 1.</p>', ], 'shapes' => [ 'AWSRegionName' => [ 'base' => NULL, 'refs' => [ 'ActionDeclaration$region' => '<p>The action declaration\'s AWS Region, such as us-east-1.</p>', 'ActionExecutionInput$region' => '<p>The AWS Region for the action, such as us-east-1.</p>', 'ArtifactStoreMap$key' => NULL, ], ], 'AWSSessionCredentials' => [ 'base' => '<p>Represents an AWS session credentials object. These credentials are temporary credentials that are issued by AWS Secure Token Service (STS). They can be used to access input and output artifacts in the S3 bucket used to store artifact for the pipeline in AWS CodePipeline.</p>', 'refs' => [ 'JobData$artifactCredentials' => '<p>Represents an AWS session credentials object. These credentials are temporary credentials that are issued by AWS Secure Token Service (STS). They can be used to access input and output artifacts in the S3 bucket used to store artifacts for the pipeline in AWS CodePipeline.</p>', 'ThirdPartyJobData$artifactCredentials' => '<p>Represents an AWS session credentials object. These credentials are temporary credentials that are issued by AWS Secure Token Service (STS). They can be used to access input and output artifacts in the S3 bucket used to store artifact for the pipeline in AWS CodePipeline. </p>', ], ], 'AccessKeyId' => [ 'base' => NULL, 'refs' => [ 'AWSSessionCredentials$accessKeyId' => '<p>The access key for the session.</p>', ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'Job$accountId' => '<p>The ID of the AWS account to use when performing the job.</p>', 'JobDetails$accountId' => '<p>The AWS account ID associated with the job.</p>', ], ], 'AcknowledgeJobInput' => [ 'base' => '<p>Represents the input of an AcknowledgeJob action.</p>', 'refs' => [], ], 'AcknowledgeJobOutput' => [ 'base' => '<p>Represents the output of an AcknowledgeJob action.</p>', 'refs' => [], ], 'AcknowledgeThirdPartyJobInput' => [ 'base' => '<p>Represents the input of an AcknowledgeThirdPartyJob action.</p>', 'refs' => [], ], 'AcknowledgeThirdPartyJobOutput' => [ 'base' => '<p>Represents the output of an AcknowledgeThirdPartyJob action.</p>', 'refs' => [], ], 'ActionCategory' => [ 'base' => NULL, 'refs' => [ 'ActionTypeId$category' => '<p>A category defines what kind of action can be taken in the stage, and constrains the provider type for the action. Valid categories are limited to one of the following values. </p>', 'CreateCustomActionTypeInput$category' => '<p>The category of the custom action, such as a build action or a test action.</p> <note> <p>Although <code>Source</code> and <code>Approval</code> are listed as valid values, they are not currently functional. These values are reserved for future use.</p> </note>', 'DeleteCustomActionTypeInput$category' => '<p>The category of the custom action that you want to delete, such as source or deploy.</p>', ], ], 'ActionConfiguration' => [ 'base' => '<p>Represents information about an action configuration.</p>', 'refs' => [ 'JobData$actionConfiguration' => '<p>Represents information about an action configuration.</p>', 'ThirdPartyJobData$actionConfiguration' => '<p>Represents information about an action configuration.</p>', ], ], 'ActionConfigurationKey' => [ 'base' => NULL, 'refs' => [ 'ActionConfigurationMap$key' => NULL, 'ActionConfigurationProperty$name' => '<p>The name of the action configuration property.</p>', 'QueryParamMap$key' => NULL, ], ], 'ActionConfigurationMap' => [ 'base' => NULL, 'refs' => [ 'ActionConfiguration$configuration' => '<p>The configuration data for the action.</p>', 'ActionDeclaration$configuration' => '<p>The action\'s configuration. These are key-value pairs that specify input values for an action. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements">Action Structure Requirements in CodePipeline</a>. For the list of configuration properties for the AWS CloudFormation action type in CodePipeline, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/continuous-delivery-codepipeline-action-reference.html">Configuration Properties Reference</a> in the <i>AWS CloudFormation User Guide</i>. For template snippets with examples, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/continuous-delivery-codepipeline-parameter-override-functions.html">Using Parameter Override Functions with CodePipeline Pipelines</a> in the <i>AWS CloudFormation User Guide</i>.</p> <p>The values can be represented in either JSON or YAML format. For example, the JSON configuration item format is as follows: </p> <p> <i>JSON:</i> </p> <p> <code>"Configuration" : { Key : Value },</code> </p>', 'ActionExecutionInput$configuration' => '<p>Configuration data for an action execution.</p>', ], ], 'ActionConfigurationProperty' => [ 'base' => '<p>Represents information about an action configuration property.</p>', 'refs' => [ 'ActionConfigurationPropertyList$member' => NULL, ], ], 'ActionConfigurationPropertyList' => [ 'base' => NULL, 'refs' => [ 'ActionType$actionConfigurationProperties' => '<p>The configuration properties for the action type.</p>', 'CreateCustomActionTypeInput$configurationProperties' => '<p>The configuration properties for the custom action.</p> <note> <p>You can refer to a name in the configuration properties of the custom action within the URL templates by following the format of {Config:name}, as long as the configuration property is both required and not secret. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/how-to-create-custom-action.html">Create a Custom Action for a Pipeline</a>.</p> </note>', ], ], 'ActionConfigurationPropertyType' => [ 'base' => NULL, 'refs' => [ 'ActionConfigurationProperty$type' => '<p>The type of the configuration property.</p>', ], ], 'ActionConfigurationQueryableValue' => [ 'base' => NULL, 'refs' => [ 'QueryParamMap$value' => NULL, ], ], 'ActionConfigurationValue' => [ 'base' => NULL, 'refs' => [ 'ActionConfigurationMap$value' => NULL, ], ], 'ActionContext' => [ 'base' => '<p>Represents the context of an action in the stage of a pipeline to a job worker.</p>', 'refs' => [ 'PipelineContext$action' => '<p>The context of an action to a job worker in the stage of a pipeline.</p>', ], ], 'ActionDeclaration' => [ 'base' => '<p>Represents information about an action declaration.</p>', 'refs' => [ 'StageActionDeclarationList$member' => NULL, ], ], 'ActionExecution' => [ 'base' => '<p>Represents information about the run of an action.</p>', 'refs' => [ 'ActionState$latestExecution' => '<p>Represents information about the run of an action.</p>', ], ], 'ActionExecutionDetail' => [ 'base' => '<p>Returns information about an execution of an action, including the action execution ID, and the name, version, and timing of the action. </p>', 'refs' => [ 'ActionExecutionDetailList$member' => NULL, ], ], 'ActionExecutionDetailList' => [ 'base' => NULL, 'refs' => [ 'ListActionExecutionsOutput$actionExecutionDetails' => '<p>The details for a list of recent executions, such as action execution ID.</p>', ], ], 'ActionExecutionFilter' => [ 'base' => '<p>Filter values for the action execution.</p>', 'refs' => [ 'ListActionExecutionsInput$filter' => '<p>Input information used to filter action execution history.</p>', ], ], 'ActionExecutionId' => [ 'base' => NULL, 'refs' => [ 'ActionContext$actionExecutionId' => '<p>The system-generated unique ID that corresponds to an action\'s execution.</p>', 'ActionExecutionDetail$actionExecutionId' => '<p>The action execution ID.</p>', ], ], 'ActionExecutionInput' => [ 'base' => '<p>Input information used for an action execution.</p>', 'refs' => [ 'ActionExecutionDetail$input' => '<p>Input details for the action execution, such as role ARN, Region, and input artifacts.</p>', ], ], 'ActionExecutionOutput' => [ 'base' => '<p>Output details listed for an action execution, such as the action execution result.</p>', 'refs' => [ 'ActionExecutionDetail$output' => '<p>Output details for the action execution, such as the action execution result.</p>', ], ], 'ActionExecutionResult' => [ 'base' => '<p>Execution result information, such as the external execution ID.</p>', 'refs' => [ 'ActionExecutionOutput$executionResult' => '<p>Execution result information listed in the output details for an action execution.</p>', ], ], 'ActionExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'ActionExecution$status' => '<p>The status of the action, or for a completed action, the last status of the action.</p>', 'ActionExecutionDetail$status' => '<p> The status of the action execution. Status categories are <code>InProgress</code>, <code>Succeeded</code>, and <code>Failed</code>.</p>', ], ], 'ActionExecutionToken' => [ 'base' => NULL, 'refs' => [ 'ActionExecution$token' => '<p>The system-generated token used to identify a unique approval request. The token for each open approval request can be obtained using the <code>GetPipelineState</code> command. It is used to validate that the approval request corresponding to this token is still valid.</p>', ], ], 'ActionName' => [ 'base' => NULL, 'refs' => [ 'ActionContext$name' => '<p>The name of the action in the context of a job.</p>', 'ActionDeclaration$name' => '<p>The action declaration\'s name.</p>', 'ActionExecutionDetail$actionName' => '<p>The name of the action.</p>', 'ActionState$actionName' => '<p>The name of the action.</p>', 'PutActionRevisionInput$actionName' => '<p>The name of the action that processes the revision.</p>', 'PutApprovalResultInput$actionName' => '<p>The name of the action for which approval is requested.</p>', 'SourceRevision$actionName' => '<p>The name of the action that processed the revision to the source artifact.</p>', 'WebhookDefinition$targetAction' => '<p>The name of the action in a pipeline you want to connect to the webhook. The action must be from the source (first) stage of the pipeline.</p>', ], ], 'ActionNamespace' => [ 'base' => NULL, 'refs' => [ 'ActionDeclaration$namespace' => '<p>The variable namespace associated with the action. All variables produced as output by this action fall under this namespace.</p>', 'ActionExecutionInput$namespace' => '<p>The variable namespace associated with the action. All variables produced as output by this action fall under this namespace.</p>', ], ], 'ActionNotFoundException' => [ 'base' => '<p>The specified action cannot be found.</p>', 'refs' => [], ], 'ActionOwner' => [ 'base' => NULL, 'refs' => [ 'ActionTypeId$owner' => '<p>The creator of the action being called.</p>', 'ListActionTypesInput$actionOwnerFilter' => '<p>Filters the list of action types to those created by a specified entity.</p>', ], ], 'ActionProvider' => [ 'base' => NULL, 'refs' => [ 'ActionTypeId$provider' => '<p>The provider of the service being called by the action. Valid providers are determined by the action category. For example, an action in the Deploy category type might have a provider of AWS CodeDeploy, which would be specified as CodeDeploy. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers">Valid Action Types and Providers in CodePipeline</a>.</p>', 'CreateCustomActionTypeInput$provider' => '<p>The provider of the service used in the custom action, such as AWS CodeDeploy.</p>', 'DeleteCustomActionTypeInput$provider' => '<p>The provider of the service used in the custom action, such as AWS CodeDeploy.</p>', ], ], 'ActionRevision' => [ 'base' => '<p>Represents information about the version (or revision) of an action.</p>', 'refs' => [ 'ActionState$currentRevision' => '<p>Represents information about the version (or revision) of an action.</p>', 'PutActionRevisionInput$actionRevision' => '<p>Represents information about the version (or revision) of an action.</p>', ], ], 'ActionRunOrder' => [ 'base' => NULL, 'refs' => [ 'ActionDeclaration$runOrder' => '<p>The order in which actions are run.</p>', ], ], 'ActionState' => [ 'base' => '<p>Represents information about the state of an action.</p>', 'refs' => [ 'ActionStateList$member' => NULL, ], ], 'ActionStateList' => [ 'base' => NULL, 'refs' => [ 'StageState$actionStates' => '<p>The state of the stage.</p>', ], ], 'ActionType' => [ 'base' => '<p>Returns information about the details of an action type.</p>', 'refs' => [ 'ActionTypeList$member' => NULL, 'CreateCustomActionTypeOutput$actionType' => '<p>Returns information about the details of an action type.</p>', ], ], 'ActionTypeId' => [ 'base' => '<p>Represents information about an action type.</p>', 'refs' => [ 'ActionDeclaration$actionTypeId' => '<p>Specifies the action type and the provider of the action.</p>', 'ActionExecutionInput$actionTypeId' => NULL, 'ActionType$id' => '<p>Represents information about an action type.</p>', 'JobData$actionTypeId' => '<p>Represents information about an action type.</p>', 'PollForJobsInput$actionTypeId' => '<p>Represents information about an action type.</p>', 'PollForThirdPartyJobsInput$actionTypeId' => '<p>Represents information about an action type.</p>', 'ThirdPartyJobData$actionTypeId' => '<p>Represents information about an action type.</p>', ], ], 'ActionTypeList' => [ 'base' => NULL, 'refs' => [ 'ListActionTypesOutput$actionTypes' => '<p>Provides details of the action types.</p>', ], ], 'ActionTypeNotFoundException' => [ 'base' => '<p>The specified action type cannot be found.</p>', 'refs' => [], ], 'ActionTypeSettings' => [ 'base' => '<p>Returns information about the settings for an action type.</p>', 'refs' => [ 'ActionType$settings' => '<p>The settings for the action type.</p>', 'CreateCustomActionTypeInput$settings' => '<p>URLs that provide users information about this custom action.</p>', ], ], 'ApprovalAlreadyCompletedException' => [ 'base' => '<p>The approval action has already been approved or rejected.</p>', 'refs' => [], ], 'ApprovalResult' => [ 'base' => '<p>Represents information about the result of an approval request.</p>', 'refs' => [ 'PutApprovalResultInput$result' => '<p>Represents information about the result of the approval request.</p>', ], ], 'ApprovalStatus' => [ 'base' => NULL, 'refs' => [ 'ApprovalResult$status' => '<p>The response submitted by a reviewer assigned to an approval action request.</p>', ], ], 'ApprovalSummary' => [ 'base' => NULL, 'refs' => [ 'ApprovalResult$summary' => '<p>The summary of the current status of the approval request.</p>', ], ], 'ApprovalToken' => [ 'base' => NULL, 'refs' => [ 'PutApprovalResultInput$token' => '<p>The system-generated token used to identify a unique approval request. The token for each open approval request can be obtained using the <a>GetPipelineState</a> action. It is used to validate that the approval request corresponding to this token is still valid.</p>', ], ], 'Artifact' => [ 'base' => '<p>Represents information about an artifact that is worked on by actions in the pipeline.</p>', 'refs' => [ 'ArtifactList$member' => NULL, ], ], 'ArtifactDetail' => [ 'base' => '<p>Artifact details for the action execution, such as the artifact location.</p>', 'refs' => [ 'ArtifactDetailList$member' => NULL, ], ], 'ArtifactDetailList' => [ 'base' => NULL, 'refs' => [ 'ActionExecutionInput$inputArtifacts' => '<p>Details of input artifacts of the action that correspond to the action execution.</p>', 'ActionExecutionOutput$outputArtifacts' => '<p>Details of output artifacts of the action that correspond to the action execution.</p>', ], ], 'ArtifactDetails' => [ 'base' => '<p>Returns information about the details of an artifact.</p>', 'refs' => [ 'ActionType$inputArtifactDetails' => '<p>The details of the input artifact for the action, such as its commit ID.</p>', 'ActionType$outputArtifactDetails' => '<p>The details of the output artifact of the action, such as its commit ID.</p>', 'CreateCustomActionTypeInput$inputArtifactDetails' => '<p>The details of the input artifact for the action, such as its commit ID.</p>', 'CreateCustomActionTypeInput$outputArtifactDetails' => '<p>The details of the output artifact of the action, such as its commit ID.</p>', ], ], 'ArtifactList' => [ 'base' => NULL, 'refs' => [ 'JobData$inputArtifacts' => '<p>The artifact supplied to the job.</p>', 'JobData$outputArtifacts' => '<p>The output of the job.</p>', 'ThirdPartyJobData$inputArtifacts' => '<p>The name of the artifact that is worked on by the action, if any. This name might be system-generated, such as "MyApp", or it might be defined by the user when the action is created. The input artifact name must match the name of an output artifact generated by an action in an earlier action or stage of the pipeline.</p>', 'ThirdPartyJobData$outputArtifacts' => '<p>The name of the artifact that is the result of the action, if any. This name might be system-generated, such as "MyBuiltApp", or it might be defined by the user when the action is created.</p>', ], ], 'ArtifactLocation' => [ 'base' => '<p>Represents information about the location of an artifact.</p>', 'refs' => [ 'Artifact$location' => '<p>The location of an artifact.</p>', ], ], 'ArtifactLocationType' => [ 'base' => NULL, 'refs' => [ 'ArtifactLocation$type' => '<p>The type of artifact in the location.</p>', ], ], 'ArtifactName' => [ 'base' => NULL, 'refs' => [ 'Artifact$name' => '<p>The artifact\'s name.</p>', 'ArtifactDetail$name' => '<p>The artifact object name for the action execution.</p>', 'ArtifactRevision$name' => '<p>The name of an artifact. This name might be system-generated, such as "MyApp", or defined by the user when an action is created.</p>', 'InputArtifact$name' => '<p>The name of the artifact to be worked on (for example, "My App").</p> <p>The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.</p>', 'OutputArtifact$name' => '<p>The name of the output of an artifact, such as "My App".</p> <p>The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.</p> <p>Output artifact names must be unique within a pipeline.</p>', ], ], 'ArtifactRevision' => [ 'base' => '<p>Represents revision details of an artifact. </p>', 'refs' => [ 'ArtifactRevisionList$member' => NULL, ], ], 'ArtifactRevisionList' => [ 'base' => NULL, 'refs' => [ 'PipelineExecution$artifactRevisions' => '<p>A list of <code>ArtifactRevision</code> objects included in a pipeline execution.</p>', ], ], 'ArtifactStore' => [ 'base' => '<p>The S3 bucket where artifacts for the pipeline are stored.</p> <note> <p>You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code>.</p> </note>', 'refs' => [ 'ArtifactStoreMap$value' => NULL, 'PipelineDeclaration$artifactStore' => '<p>Represents information about the S3 bucket where artifacts are stored for the pipeline.</p> <note> <p>You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code>.</p> </note>', ], ], 'ArtifactStoreLocation' => [ 'base' => NULL, 'refs' => [ 'ArtifactStore$location' => '<p>The S3 bucket used for storing the artifacts for a pipeline. You can specify the name of an S3 bucket but not a folder in the bucket. A folder to contain the pipeline artifacts is created for you based on the name of the pipeline. You can use any S3 bucket in the same AWS Region as the pipeline to store your pipeline artifacts.</p>', ], ], 'ArtifactStoreMap' => [ 'base' => NULL, 'refs' => [ 'PipelineDeclaration$artifactStores' => '<p>A mapping of <code>artifactStore</code> objects and their corresponding AWS Regions. There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.</p> <note> <p>You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code>.</p> </note>', ], ], 'ArtifactStoreType' => [ 'base' => NULL, 'refs' => [ 'ArtifactStore$type' => '<p>The type of the artifact store, such as S3.</p>', ], ], 'BlockerDeclaration' => [ 'base' => '<p>Reserved for future use.</p>', 'refs' => [ 'StageBlockerDeclarationList$member' => NULL, ], ], 'BlockerName' => [ 'base' => NULL, 'refs' => [ 'BlockerDeclaration$name' => '<p>Reserved for future use.</p>', ], ], 'BlockerType' => [ 'base' => NULL, 'refs' => [ 'BlockerDeclaration$type' => '<p>Reserved for future use.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'ActionConfigurationProperty$required' => '<p>Whether the configuration property is a required value.</p>', 'ActionConfigurationProperty$key' => '<p>Whether the configuration property is a key.</p>', 'ActionConfigurationProperty$secret' => '<p>Whether the configuration property is secret. Secrets are hidden from all calls except for <code>GetJobDetails</code>, <code>GetThirdPartyJobDetails</code>, <code>PollForJobs</code>, and <code>PollForThirdPartyJobs</code>.</p> <p>When updating a pipeline, passing * * * * * without changing any other values of the action preserves the previous value of the secret.</p>', 'ActionConfigurationProperty$queryable' => '<p>Indicates that the property is used with <code>PollForJobs</code>. When creating a custom action, an action can have up to one queryable property. If it has one, that property must be both required and not secret.</p> <p>If you create a pipeline with a custom action type, and that custom action contains a queryable property, the value for that configuration property is subject to other restrictions. The value must be less than or equal to twenty (20) characters. The value can contain only alphanumeric characters, underscores, and hyphens.</p>', 'PutActionRevisionOutput$newRevision' => '<p>Indicates whether the artifact revision was previously used in an execution of the specified pipeline.</p>', 'StopPipelineExecutionInput$abandon' => '<p>Use this option to stop the pipeline execution by abandoning, rather than finishing, in-progress actions.</p> <note> <p>This option can lead to failed or out-of-sequence tasks.</p> </note>', ], ], 'ClientId' => [ 'base' => NULL, 'refs' => [ 'ThirdPartyJob$clientId' => '<p>The <code>clientToken</code> portion of the <code>clientId</code> and <code>clientToken</code> pair used to verify that the calling entity is allowed access to the job and its details.</p>', ], ], 'ClientRequestToken' => [ 'base' => NULL, 'refs' => [ 'StartPipelineExecutionInput$clientRequestToken' => '<p>The system-generated unique ID used to identify a unique execution request.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'AcknowledgeThirdPartyJobInput$clientToken' => '<p>The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.</p>', 'GetThirdPartyJobDetailsInput$clientToken' => '<p>The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.</p>', 'PutThirdPartyJobFailureResultInput$clientToken' => '<p>The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.</p>', 'PutThirdPartyJobSuccessResultInput$clientToken' => '<p>The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.</p>', ], ], 'Code' => [ 'base' => NULL, 'refs' => [ 'ErrorDetails$code' => '<p>The system ID or number code of the error.</p>', ], ], 'ConcurrentModificationException' => [ 'base' => '<p>Unable to modify the tag due to a simultaneous update request.</p>', 'refs' => [], ], 'ContinuationToken' => [ 'base' => NULL, 'refs' => [ 'JobData$continuationToken' => '<p>A system-generated token, such as a AWS CodeDeploy deployment ID, required by a job to continue the job asynchronously.</p>', 'PutJobSuccessResultInput$continuationToken' => '<p>A token generated by a job worker, such as an AWS CodeDeploy deployment ID, that a successful job provides to identify a custom action in progress. Future jobs use this token to identify the running instance of the action. It can be reused to return more information about the progress of the custom action. When the action is complete, no continuation token should be supplied.</p>', 'PutThirdPartyJobSuccessResultInput$continuationToken' => '<p>A token generated by a job worker, such as an AWS CodeDeploy deployment ID, that a successful job provides to identify a partner action in progress. Future jobs use this token to identify the running instance of the action. It can be reused to return more information about the progress of the partner action. When the action is complete, no continuation token should be supplied.</p>', 'ThirdPartyJobData$continuationToken' => '<p>A system-generated token, such as a AWS CodeDeploy deployment ID, that a job requires to continue the job asynchronously.</p>', ], ], 'CreateCustomActionTypeInput' => [ 'base' => '<p>Represents the input of a CreateCustomActionType operation.</p>', 'refs' => [], ], 'CreateCustomActionTypeOutput' => [ 'base' => '<p>Represents the output of a <code>CreateCustomActionType</code> operation.</p>', 'refs' => [], ], 'CreatePipelineInput' => [ 'base' => '<p>Represents the input of a <code>CreatePipeline</code> action.</p>', 'refs' => [], ], 'CreatePipelineOutput' => [ 'base' => '<p>Represents the output of a <code>CreatePipeline</code> action.</p>', 'refs' => [], ], 'CurrentRevision' => [ 'base' => '<p>Represents information about a current revision.</p>', 'refs' => [ 'PutJobSuccessResultInput$currentRevision' => '<p>The ID of the current revision of the artifact successfully worked on by the job.</p>', 'PutThirdPartyJobSuccessResultInput$currentRevision' => '<p>Represents information about a current revision.</p>', ], ], 'DeleteCustomActionTypeInput' => [ 'base' => '<p>Represents the input of a <code>DeleteCustomActionType</code> operation. The custom action will be marked as deleted.</p>', 'refs' => [], ], 'DeletePipelineInput' => [ 'base' => '<p>Represents the input of a <code>DeletePipeline</code> action.</p>', 'refs' => [], ], 'DeleteWebhookInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWebhookOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterWebhookWithThirdPartyInput' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterWebhookWithThirdPartyOutput' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'ActionConfigurationProperty$description' => '<p>The description of the action configuration property that is displayed to users.</p>', ], ], 'DisableStageTransitionInput' => [ 'base' => '<p>Represents the input of a <code>DisableStageTransition</code> action.</p>', 'refs' => [], ], 'DisabledReason' => [ 'base' => NULL, 'refs' => [ 'DisableStageTransitionInput$reason' => '<p>The reason given to the user that a stage is disabled, such as waiting for manual approval or manual tests. This message is displayed in the pipeline console UI.</p>', 'TransitionState$disabledReason' => '<p>The user-specified reason why the transition between two stages of a pipeline was disabled.</p>', ], ], 'DuplicatedStopRequestException' => [ 'base' => '<p>The pipeline execution is already in a <code>Stopping</code> state. If you already chose to stop and wait, you cannot make that request again. You can choose to stop and abandon now, but be aware that this option can lead to failed tasks or out of sequence tasks. If you already chose to stop and abandon, you cannot make that request again.</p>', 'refs' => [], ], 'EnableStageTransitionInput' => [ 'base' => '<p>Represents the input of an <code>EnableStageTransition</code> action.</p>', 'refs' => [], ], 'Enabled' => [ 'base' => NULL, 'refs' => [ 'TransitionState$enabled' => '<p>Whether the transition between stages is enabled (true) or disabled (false).</p>', ], ], 'EncryptionKey' => [ 'base' => '<p>Represents information about the key used to encrypt data in the artifact store, such as an AWS Key Management Service (AWS KMS) key.</p>', 'refs' => [ 'ArtifactStore$encryptionKey' => '<p>The encryption key used to encrypt the data in the artifact store, such as an AWS Key Management Service (AWS KMS) key. If this is undefined, the default key for Amazon S3 is used.</p>', 'JobData$encryptionKey' => '<p>Represents information about the key used to encrypt data in the artifact store, such as an AWS Key Management Service (AWS KMS) key. </p>', 'ThirdPartyJobData$encryptionKey' => '<p>The encryption key used to encrypt and decrypt data in the artifact store for the pipeline, such as an AWS Key Management Service (AWS KMS) key. This is optional and might not be present.</p>', ], ], 'EncryptionKeyId' => [ 'base' => NULL, 'refs' => [ 'EncryptionKey$id' => '<p>The ID used to identify the key. For an AWS KMS key, you can use the key ID, the key ARN, or the alias ARN.</p> <note> <p>Aliases are recognized only in the account that created the customer master key (CMK). For cross-account actions, you can only use the key ID or key ARN to identify the key.</p> </note>', ], ], 'EncryptionKeyType' => [ 'base' => NULL, 'refs' => [ 'EncryptionKey$type' => '<p>The type of encryption key, such as an AWS Key Management Service (AWS KMS) key. When creating or updating a pipeline, the value must be set to \'KMS\'.</p>', ], ], 'ErrorDetails' => [ 'base' => '<p>Represents information about an error in AWS CodePipeline.</p>', 'refs' => [ 'ActionExecution$errorDetails' => '<p>The details of an error returned by a URL external to AWS.</p>', ], ], 'ExecutionDetails' => [ 'base' => '<p>The details of the actions taken and results produced on an artifact as it passes through stages in the pipeline.</p>', 'refs' => [ 'PutJobSuccessResultInput$executionDetails' => '<p>The execution details of the successful job, such as the actions taken by the job worker.</p>', 'PutThirdPartyJobSuccessResultInput$executionDetails' => '<p>The details of the actions taken and results produced on an artifact as it passes through stages in the pipeline. </p>', ], ], 'ExecutionId' => [ 'base' => NULL, 'refs' => [ 'ActionExecution$externalExecutionId' => '<p>The external ID of the run of the action.</p>', 'ExecutionDetails$externalExecutionId' => '<p>The system-generated unique ID of this action used to identify this job worker in any external systems, such as AWS CodeDeploy.</p>', 'FailureDetails$externalExecutionId' => '<p>The external ID of the run of the action that failed.</p>', ], ], 'ExecutionSummary' => [ 'base' => NULL, 'refs' => [ 'ActionExecution$summary' => '<p>A summary of the run of the action.</p>', 'ExecutionDetails$summary' => '<p>The summary of the current status of the actions.</p>', ], ], 'ExecutionTrigger' => [ 'base' => '<p>The interaction or event that started a pipeline execution.</p>', 'refs' => [ 'PipelineExecutionSummary$trigger' => '<p>The interaction or event that started a pipeline execution, such as automated change detection or a <code>StartPipelineExecution</code> API call.</p>', ], ], 'ExternalExecutionId' => [ 'base' => NULL, 'refs' => [ 'ActionExecutionResult$externalExecutionId' => '<p>The action provider\'s external ID for the action execution.</p>', ], ], 'ExternalExecutionSummary' => [ 'base' => NULL, 'refs' => [ 'ActionExecutionResult$externalExecutionSummary' => '<p>The action provider\'s summary for the action execution.</p>', ], ], 'FailureDetails' => [ 'base' => '<p>Represents information about failure details.</p>', 'refs' => [ 'PutJobFailureResultInput$failureDetails' => '<p>The details about the failure of a job.</p>', 'PutThirdPartyJobFailureResultInput$failureDetails' => '<p>Represents information about failure details.</p>', ], ], 'FailureType' => [ 'base' => NULL, 'refs' => [ 'FailureDetails$type' => '<p>The type of the failure.</p>', ], ], 'GetJobDetailsInput' => [ 'base' => '<p>Represents the input of a <code>GetJobDetails</code> action.</p>', 'refs' => [], ], 'GetJobDetailsOutput' => [ 'base' => '<p>Represents the output of a <code>GetJobDetails</code> action.</p>', 'refs' => [], ], 'GetPipelineExecutionInput' => [ 'base' => '<p>Represents the input of a <code>GetPipelineExecution</code> action.</p>', 'refs' => [], ], 'GetPipelineExecutionOutput' => [ 'base' => '<p>Represents the output of a <code>GetPipelineExecution</code> action.</p>', 'refs' => [], ], 'GetPipelineInput' => [ 'base' => '<p>Represents the input of a <code>GetPipeline</code> action.</p>', 'refs' => [], ], 'GetPipelineOutput' => [ 'base' => '<p>Represents the output of a <code>GetPipeline</code> action.</p>', 'refs' => [], ], 'GetPipelineStateInput' => [ 'base' => '<p>Represents the input of a <code>GetPipelineState</code> action.</p>', 'refs' => [], ], 'GetPipelineStateOutput' => [ 'base' => '<p>Represents the output of a <code>GetPipelineState</code> action.</p>', 'refs' => [], ], 'GetThirdPartyJobDetailsInput' => [ 'base' => '<p>Represents the input of a <code>GetThirdPartyJobDetails</code> action.</p>', 'refs' => [], ], 'GetThirdPartyJobDetailsOutput' => [ 'base' => '<p>Represents the output of a <code>GetThirdPartyJobDetails</code> action.</p>', 'refs' => [], ], 'InputArtifact' => [ 'base' => '<p>Represents information about an artifact to be worked on, such as a test or build artifact.</p>', 'refs' => [ 'InputArtifactList$member' => NULL, ], ], 'InputArtifactList' => [ 'base' => NULL, 'refs' => [ 'ActionDeclaration$inputArtifacts' => '<p>The name or ID of the artifact consumed by the action, such as a test or build artifact.</p>', ], ], 'InvalidActionDeclarationException' => [ 'base' => '<p>The action declaration was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidApprovalTokenException' => [ 'base' => '<p>The approval request already received a response or has expired.</p>', 'refs' => [], ], 'InvalidArnException' => [ 'base' => '<p>The specified resource ARN is invalid.</p>', 'refs' => [], ], 'InvalidBlockerDeclarationException' => [ 'base' => '<p>Reserved for future use.</p>', 'refs' => [], ], 'InvalidClientTokenException' => [ 'base' => '<p>The client token was specified in an invalid format</p>', 'refs' => [], ], 'InvalidJobException' => [ 'base' => '<p>The job was specified in an invalid format or cannot be found.</p>', 'refs' => [], ], 'InvalidJobStateException' => [ 'base' => '<p>The job state was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidNextTokenException' => [ 'base' => '<p>The next token was specified in an invalid format. Make sure that the next token you provide is the token returned by a previous call.</p>', 'refs' => [], ], 'InvalidNonceException' => [ 'base' => '<p>The nonce was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidStageDeclarationException' => [ 'base' => '<p>The stage declaration was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidStructureException' => [ 'base' => '<p>The structure was specified in an invalid format.</p>', 'refs' => [], ], 'InvalidTagsException' => [ 'base' => '<p>The specified resource tags are invalid.</p>', 'refs' => [], ], 'InvalidWebhookAuthenticationParametersException' => [ 'base' => '<p>The specified authentication type is in an invalid format.</p>', 'refs' => [], ], 'InvalidWebhookFilterPatternException' => [ 'base' => '<p>The specified event filter rule is in an invalid format.</p>', 'refs' => [], ], 'Job' => [ 'base' => '<p>Represents information about a job.</p>', 'refs' => [ 'JobList$member' => NULL, ], ], 'JobData' => [ 'base' => '<p>Represents other information about a job required for a job worker to complete the job.</p>', 'refs' => [ 'Job$data' => '<p>Other data about a job.</p>', 'JobDetails$data' => '<p>Represents other information about a job required for a job worker to complete the job. </p>', ], ], 'JobDetails' => [ 'base' => '<p>Represents information about the details of a job.</p>', 'refs' => [ 'GetJobDetailsOutput$jobDetails' => '<p>The details of the job.</p> <note> <p>If AWSSessionCredentials is used, a long-running job can call <code>GetJobDetails</code> again to obtain new credentials.</p> </note>', ], ], 'JobId' => [ 'base' => NULL, 'refs' => [ 'AcknowledgeJobInput$jobId' => '<p>The unique system-generated ID of the job for which you want to confirm receipt.</p>', 'GetJobDetailsInput$jobId' => '<p>The unique system-generated ID for the job.</p>', 'Job$id' => '<p>The unique system-generated ID of the job.</p>', 'JobDetails$id' => '<p>The unique system-generated ID of the job.</p>', 'PutJobFailureResultInput$jobId' => '<p>The unique system-generated ID of the job that failed. This is the same ID returned from <code>PollForJobs</code>.</p>', 'PutJobSuccessResultInput$jobId' => '<p>The unique system-generated ID of the job that succeeded. This is the same ID returned from <code>PollForJobs</code>.</p>', 'ThirdPartyJob$jobId' => '<p>The identifier used to identify the job in AWS CodePipeline.</p>', ], ], 'JobList' => [ 'base' => NULL, 'refs' => [ 'PollForJobsOutput$jobs' => '<p>Information about the jobs to take action on.</p>', ], ], 'JobNotFoundException' => [ 'base' => '<p>The job was specified in an invalid format or cannot be found.</p>', 'refs' => [], ], 'JobStatus' => [ 'base' => NULL, 'refs' => [ 'AcknowledgeJobOutput$status' => '<p>Whether the job worker has received the specified job.</p>', 'AcknowledgeThirdPartyJobOutput$status' => '<p>The status information for the third party job, if any.</p>', ], ], 'JsonPath' => [ 'base' => NULL, 'refs' => [ 'WebhookFilterRule$jsonPath' => '<p>A JsonPath expression that is applied to the body/payload of the webhook. The value selected by the JsonPath expression must match the value specified in the <code>MatchEquals</code> field. Otherwise, the request is ignored. For more information, see <a href="https://github.com/json-path/JsonPath">Java JsonPath implementation</a> in GitHub.</p>', ], ], 'LastChangedAt' => [ 'base' => NULL, 'refs' => [ 'TransitionState$lastChangedAt' => '<p>The timestamp when the transition state was last changed.</p>', ], ], 'LastChangedBy' => [ 'base' => NULL, 'refs' => [ 'TransitionState$lastChangedBy' => '<p>The ID of the user who last changed the transition state.</p>', ], ], 'LastUpdatedBy' => [ 'base' => NULL, 'refs' => [ 'ActionExecution$lastUpdatedBy' => '<p>The ARN of the user who last changed the pipeline.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The number of pipelines associated with the AWS account has exceeded the limit allowed for the account.</p>', 'refs' => [], ], 'ListActionExecutionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListActionExecutionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListActionTypesInput' => [ 'base' => '<p>Represents the input of a <code>ListActionTypes</code> action.</p>', 'refs' => [], ], 'ListActionTypesOutput' => [ 'base' => '<p>Represents the output of a <code>ListActionTypes</code> action.</p>', 'refs' => [], ], 'ListPipelineExecutionsInput' => [ 'base' => '<p>Represents the input of a <code>ListPipelineExecutions</code> action.</p>', 'refs' => [], ], 'ListPipelineExecutionsOutput' => [ 'base' => '<p>Represents the output of a <code>ListPipelineExecutions</code> action.</p>', 'refs' => [], ], 'ListPipelinesInput' => [ 'base' => '<p>Represents the input of a <code>ListPipelines</code> action.</p>', 'refs' => [], ], 'ListPipelinesOutput' => [ 'base' => '<p>Represents the output of a <code>ListPipelines</code> action.</p>', 'refs' => [], ], 'ListTagsForResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListWebhookItem' => [ 'base' => '<p>The detail returned for each webhook after listing webhooks, such as the webhook URL, the webhook name, and the webhook ARN.</p>', 'refs' => [ 'PutWebhookOutput$webhook' => '<p>The detail returned from creating the webhook, such as the webhook name, webhook URL, and webhook ARN.</p>', 'WebhookList$member' => NULL, ], ], 'ListWebhooksInput' => [ 'base' => NULL, 'refs' => [], ], 'ListWebhooksOutput' => [ 'base' => NULL, 'refs' => [], ], 'MatchEquals' => [ 'base' => NULL, 'refs' => [ 'WebhookFilterRule$matchEquals' => '<p>The value selected by the <code>JsonPath</code> expression must match what is supplied in the <code>MatchEquals</code> field. Otherwise, the request is ignored. Properties from the target action configuration can be included as placeholders in this value by surrounding the action configuration key with curly brackets. For example, if the value supplied here is "refs/heads/{Branch}" and the target action has an action configuration property called "Branch" with a value of "master", the <code>MatchEquals</code> value is evaluated as "refs/heads/master". For a list of action configuration properties for built-in action types, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements">Pipeline Structure Reference Action Requirements</a>.</p>', ], ], 'MaxBatchSize' => [ 'base' => NULL, 'refs' => [ 'PollForJobsInput$maxBatchSize' => '<p>The maximum number of jobs to return in a poll for jobs call.</p>', 'PollForThirdPartyJobsInput$maxBatchSize' => '<p>The maximum number of jobs to return in a poll for jobs call.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListActionExecutionsInput$maxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned nextToken value. Action execution history is retained for up to 12 months, based on action execution start times. Default value is 100. </p> <note> <p>Detailed execution history is available for executions run on or after February 21, 2019.</p> </note>', 'ListPipelineExecutionsInput$maxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned nextToken value. Pipeline history is limited to the most recent 12 months, based on pipeline execution start times. Default value is 100.</p>', 'ListTagsForResourceInput$maxResults' => '<p>The maximum number of results to return in a single call.</p>', 'ListWebhooksInput$MaxResults' => '<p>The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned nextToken value.</p>', ], ], 'MaximumArtifactCount' => [ 'base' => NULL, 'refs' => [ 'ArtifactDetails$maximumCount' => '<p>The maximum number of artifacts allowed for the action type.</p>', ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'ConcurrentModificationException$message' => NULL, 'DuplicatedStopRequestException$message' => NULL, 'ErrorDetails$message' => '<p>The text of the error message.</p>', 'FailureDetails$message' => '<p>The message about the failure.</p>', 'InvalidArnException$message' => NULL, 'InvalidTagsException$message' => NULL, 'OutputVariablesSizeExceededException$message' => NULL, 'PipelineExecutionNotStoppableException$message' => NULL, 'TooManyTagsException$message' => NULL, ], ], 'MinimumArtifactCount' => [ 'base' => NULL, 'refs' => [ 'ArtifactDetails$minimumCount' => '<p>The minimum number of artifacts allowed for the action type.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListActionExecutionsInput$nextToken' => '<p>The token that was returned from the previous <code>ListActionExecutions</code> call, which can be used to return the next set of action executions in the list.</p>', 'ListActionExecutionsOutput$nextToken' => '<p>If the amount of returned information is significantly large, an identifier is also returned and can be used in a subsequent <code>ListActionExecutions</code> call to return the next set of action executions in the list.</p>', 'ListActionTypesInput$nextToken' => '<p>An identifier that was returned from the previous list action types call, which can be used to return the next set of action types in the list.</p>', 'ListActionTypesOutput$nextToken' => '<p>If the amount of returned information is significantly large, an identifier is also returned. It can be used in a subsequent list action types call to return the next set of action types in the list.</p>', 'ListPipelineExecutionsInput$nextToken' => '<p>The token that was returned from the previous <code>ListPipelineExecutions</code> call, which can be used to return the next set of pipeline executions in the list.</p>', 'ListPipelineExecutionsOutput$nextToken' => '<p>A token that can be used in the next <code>ListPipelineExecutions</code> call. To view all items in the list, continue to call this operation with each subsequent token until no more nextToken values are returned.</p>', 'ListPipelinesInput$nextToken' => '<p>An identifier that was returned from the previous list pipelines call. It can be used to return the next set of pipelines in the list.</p>', 'ListPipelinesOutput$nextToken' => '<p>If the amount of returned information is significantly large, an identifier is also returned. It can be used in a subsequent list pipelines call to return the next set of pipelines in the list.</p>', 'ListTagsForResourceInput$nextToken' => '<p>The token that was returned from the previous API call, which would be used to return the next page of the list. The ListTagsforResource call lists all available tags in one call and does not use pagination.</p>', 'ListTagsForResourceOutput$nextToken' => '<p>If the amount of returned information is significantly large, an identifier is also returned and can be used in a subsequent API call to return the next page of the list. The ListTagsforResource call lists all available tags in one call and does not use pagination.</p>', 'ListWebhooksInput$NextToken' => '<p>The token that was returned from the previous ListWebhooks call, which can be used to return the next set of webhooks in the list.</p>', 'ListWebhooksOutput$NextToken' => '<p>If the amount of returned information is significantly large, an identifier is also returned and can be used in a subsequent ListWebhooks call to return the next set of webhooks in the list. </p>', ], ], 'Nonce' => [ 'base' => NULL, 'refs' => [ 'AcknowledgeJobInput$nonce' => '<p>A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only one job worker. Get this number from the response of the <a>PollForJobs</a> request that returned this job.</p>', 'AcknowledgeThirdPartyJobInput$nonce' => '<p>A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only one job worker. Get this number from the response to a <a>GetThirdPartyJobDetails</a> request.</p>', 'Job$nonce' => '<p>A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only one job worker. Use this number in an <a>AcknowledgeJob</a> request.</p>', 'ThirdPartyJobDetails$nonce' => '<p>A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only one job worker. Use this number in an <a>AcknowledgeThirdPartyJob</a> request.</p>', ], ], 'NotLatestPipelineExecutionException' => [ 'base' => '<p>The stage has failed in a later run of the pipeline and the pipelineExecutionId associated with the request is out of date.</p>', 'refs' => [], ], 'OutputArtifact' => [ 'base' => '<p>Represents information about the output of an action.</p>', 'refs' => [ 'OutputArtifactList$member' => NULL, ], ], 'OutputArtifactList' => [ 'base' => NULL, 'refs' => [ 'ActionDeclaration$outputArtifacts' => '<p>The name or ID of the result of the action declaration, such as a test or build artifact.</p>', ], ], 'OutputVariablesKey' => [ 'base' => NULL, 'refs' => [ 'OutputVariablesMap$key' => NULL, ], ], 'OutputVariablesMap' => [ 'base' => NULL, 'refs' => [ 'ActionExecutionOutput$outputVariables' => '<p>The outputVariables field shows the key-value pairs that were output as part of that execution.</p>', 'PutJobSuccessResultInput$outputVariables' => '<p>Key-value pairs produced as output by a job worker that can be made available to a downstream action configuration. <code>outputVariables</code> can be included only when there is no continuation token on the request.</p>', ], ], 'OutputVariablesSizeExceededException' => [ 'base' => '<p>Exceeded the total size limit for all variables in the pipeline.</p>', 'refs' => [], ], 'OutputVariablesValue' => [ 'base' => NULL, 'refs' => [ 'OutputVariablesMap$value' => NULL, ], ], 'Percentage' => [ 'base' => NULL, 'refs' => [ 'ActionExecution$percentComplete' => '<p>A percentage of completeness of the action as it runs.</p>', 'ExecutionDetails$percentComplete' => '<p>The percentage of work completed on the action, represented on a scale of 0 to 100 percent.</p>', ], ], 'PipelineArn' => [ 'base' => NULL, 'refs' => [ 'PipelineContext$pipelineArn' => '<p>The Amazon Resource Name (ARN) of the pipeline.</p>', 'PipelineMetadata$pipelineArn' => '<p>The Amazon Resource Name (ARN) of the pipeline.</p>', ], ], 'PipelineContext' => [ 'base' => '<p>Represents information about a pipeline to a job worker.</p> <note> <p>PipelineContext contains <code>pipelineArn</code> and <code>pipelineExecutionId</code> for custom action jobs. The <code>pipelineArn</code> and <code>pipelineExecutionId</code> fields are not populated for ThirdParty action jobs.</p> </note>', 'refs' => [ 'JobData$pipelineContext' => '<p>Represents information about a pipeline to a job worker.</p> <note> <p>Includes <code>pipelineArn</code> and <code>pipelineExecutionId</code> for custom jobs.</p> </note>', 'ThirdPartyJobData$pipelineContext' => '<p>Represents information about a pipeline to a job worker.</p> <note> <p>Does not include <code>pipelineArn</code> and <code>pipelineExecutionId</code> for ThirdParty jobs.</p> </note>', ], ], 'PipelineDeclaration' => [ 'base' => '<p>Represents the structure of actions and stages to be performed in the pipeline.</p>', 'refs' => [ 'CreatePipelineInput$pipeline' => '<p>Represents the structure of actions and stages to be performed in the pipeline. </p>', 'CreatePipelineOutput$pipeline' => '<p>Represents the structure of actions and stages to be performed in the pipeline. </p>', 'GetPipelineOutput$pipeline' => '<p>Represents the structure of actions and stages to be performed in the pipeline. </p>', 'UpdatePipelineInput$pipeline' => '<p>The name of the pipeline to be updated.</p>', 'UpdatePipelineOutput$pipeline' => '<p>The structure of the updated pipeline.</p>', ], ], 'PipelineExecution' => [ 'base' => '<p>Represents information about an execution of a pipeline.</p>', 'refs' => [ 'GetPipelineExecutionOutput$pipelineExecution' => '<p>Represents information about the execution of a pipeline.</p>', ], ], 'PipelineExecutionId' => [ 'base' => NULL, 'refs' => [ 'ActionExecutionDetail$pipelineExecutionId' => '<p>The pipeline execution ID for the action execution.</p>', 'ActionExecutionFilter$pipelineExecutionId' => '<p>The pipeline execution ID used to filter action execution history.</p>', 'GetPipelineExecutionInput$pipelineExecutionId' => '<p>The ID of the pipeline execution about which you want to get execution details.</p>', 'PipelineContext$pipelineExecutionId' => '<p>The execution ID of the pipeline.</p>', 'PipelineExecution$pipelineExecutionId' => '<p>The ID of the pipeline execution.</p>', 'PipelineExecutionSummary$pipelineExecutionId' => '<p>The ID of the pipeline execution.</p>', 'PutActionRevisionOutput$pipelineExecutionId' => '<p>The ID of the current workflow state of the pipeline.</p>', 'RetryStageExecutionInput$pipelineExecutionId' => '<p>The ID of the pipeline execution in the failed stage to be retried. Use the <a>GetPipelineState</a> action to retrieve the current pipelineExecutionId of the failed stage</p>', 'RetryStageExecutionOutput$pipelineExecutionId' => '<p>The ID of the current workflow execution in the failed stage.</p>', 'StageExecution$pipelineExecutionId' => '<p>The ID of the pipeline execution associated with the stage.</p>', 'StartPipelineExecutionOutput$pipelineExecutionId' => '<p>The unique system-generated ID of the pipeline execution that was started.</p>', 'StopPipelineExecutionInput$pipelineExecutionId' => '<p>The ID of the pipeline execution to be stopped in the current stage. Use the <code>GetPipelineState</code> action to retrieve the current pipelineExecutionId.</p>', 'StopPipelineExecutionOutput$pipelineExecutionId' => '<p>The unique system-generated ID of the pipeline execution that was stopped.</p>', ], ], 'PipelineExecutionNotFoundException' => [ 'base' => '<p>The pipeline execution was specified in an invalid format or cannot be found, or an execution ID does not belong to the specified pipeline. </p>', 'refs' => [], ], 'PipelineExecutionNotStoppableException' => [ 'base' => '<p>Unable to stop the pipeline execution. The execution might already be in a <code>Stopped</code> state, or it might no longer be in progress.</p>', 'refs' => [], ], 'PipelineExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'PipelineExecution$status' => '<p>The status of the pipeline execution.</p> <ul> <li> <p>InProgress: The pipeline execution is currently running.</p> </li> <li> <p>Stopped: The pipeline execution was manually stopped. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped">Stopped Executions</a>.</p> </li> <li> <p>Stopping: The pipeline execution received a request to be manually stopped. Depending on the selected stop mode, the execution is either completing or abandoning in-progress actions. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped">Stopped Executions</a>.</p> </li> <li> <p>Succeeded: The pipeline execution was completed successfully. </p> </li> <li> <p>Superseded: While this pipeline execution was waiting for the next stage to be completed, a newer pipeline execution advanced and continued through the pipeline instead. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-superseded">Superseded Executions</a>.</p> </li> <li> <p>Failed: The pipeline execution was not completed successfully.</p> </li> </ul>', 'PipelineExecutionSummary$status' => '<p>The status of the pipeline execution.</p> <ul> <li> <p>InProgress: The pipeline execution is currently running.</p> </li> <li> <p>Stopped: The pipeline execution was manually stopped. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped">Stopped Executions</a>.</p> </li> <li> <p>Stopping: The pipeline execution received a request to be manually stopped. Depending on the selected stop mode, the execution is either completing or abandoning in-progress actions. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-executions-stopped">Stopped Executions</a>.</p> </li> <li> <p>Succeeded: The pipeline execution was completed successfully. </p> </li> <li> <p>Superseded: While this pipeline execution was waiting for the next stage to be completed, a newer pipeline execution advanced and continued through the pipeline instead. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts.html#concepts-superseded">Superseded Executions</a>.</p> </li> <li> <p>Failed: The pipeline execution was not completed successfully.</p> </li> </ul>', ], ], 'PipelineExecutionSummary' => [ 'base' => '<p>Summary information about a pipeline execution.</p>', 'refs' => [ 'PipelineExecutionSummaryList$member' => NULL, ], ], 'PipelineExecutionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListPipelineExecutionsOutput$pipelineExecutionSummaries' => '<p>A list of executions in the history of a pipeline.</p>', ], ], 'PipelineList' => [ 'base' => NULL, 'refs' => [ 'ListPipelinesOutput$pipelines' => '<p>The list of pipelines.</p>', ], ], 'PipelineMetadata' => [ 'base' => '<p>Information about a pipeline.</p>', 'refs' => [ 'GetPipelineOutput$metadata' => '<p>Represents the pipeline metadata information returned as part of the output of a <code>GetPipeline</code> action.</p>', ], ], 'PipelineName' => [ 'base' => NULL, 'refs' => [ 'DeletePipelineInput$name' => '<p>The name of the pipeline to be deleted.</p>', 'DisableStageTransitionInput$pipelineName' => '<p>The name of the pipeline in which you want to disable the flow of artifacts from one stage to another.</p>', 'EnableStageTransitionInput$pipelineName' => '<p>The name of the pipeline in which you want to enable the flow of artifacts from one stage to another.</p>', 'GetPipelineExecutionInput$pipelineName' => '<p>The name of the pipeline about which you want to get execution details.</p>', 'GetPipelineInput$name' => '<p>The name of the pipeline for which you want to get information. Pipeline names must be unique under an AWS user account.</p>', 'GetPipelineStateInput$name' => '<p>The name of the pipeline about which you want to get information.</p>', 'GetPipelineStateOutput$pipelineName' => '<p>The name of the pipeline for which you want to get the state.</p>', 'ListActionExecutionsInput$pipelineName' => '<p> The name of the pipeline for which you want to list action execution history.</p>', 'ListPipelineExecutionsInput$pipelineName' => '<p>The name of the pipeline for which you want to get execution summary information.</p>', 'PipelineContext$pipelineName' => '<p>The name of the pipeline. This is a user-specified value. Pipeline names must be unique across all pipeline names under an Amazon Web Services account.</p>', 'PipelineDeclaration$name' => '<p>The name of the action to be performed.</p>', 'PipelineExecution$pipelineName' => '<p>The name of the pipeline with the specified pipeline execution.</p>', 'PipelineSummary$name' => '<p>The name of the pipeline.</p>', 'PutActionRevisionInput$pipelineName' => '<p>The name of the pipeline that starts processing the revision to the source.</p>', 'PutApprovalResultInput$pipelineName' => '<p>The name of the pipeline that contains the action. </p>', 'RetryStageExecutionInput$pipelineName' => '<p>The name of the pipeline that contains the failed stage.</p>', 'StartPipelineExecutionInput$name' => '<p>The name of the pipeline to start.</p>', 'StopPipelineExecutionInput$pipelineName' => '<p>The name of the pipeline to stop.</p>', 'WebhookDefinition$targetPipeline' => '<p>The name of the pipeline you want to connect to the webhook.</p>', ], ], 'PipelineNameInUseException' => [ 'base' => '<p>The specified pipeline name is already in use.</p>', 'refs' => [], ], 'PipelineNotFoundException' => [ 'base' => '<p>The pipeline was specified in an invalid format or cannot be found.</p>', 'refs' => [], ], 'PipelineStageDeclarationList' => [ 'base' => NULL, 'refs' => [ 'PipelineDeclaration$stages' => '<p>The stage in which to perform the action.</p>', ], ], 'PipelineSummary' => [ 'base' => '<p>Returns a summary of a pipeline.</p>', 'refs' => [ 'PipelineList$member' => NULL, ], ], 'PipelineVersion' => [ 'base' => NULL, 'refs' => [ 'ActionExecutionDetail$pipelineVersion' => '<p>The version of the pipeline where the action was run.</p>', 'GetPipelineInput$version' => '<p>The version number of the pipeline. If you do not specify a version, defaults to the current version.</p>', 'GetPipelineStateOutput$pipelineVersion' => '<p>The version number of the pipeline.</p> <note> <p>A newly created pipeline is always assigned a version number of <code>1</code>.</p> </note>', 'PipelineDeclaration$version' => '<p>The version number of the pipeline. A new pipeline always has a version number of 1. This number is incremented when a pipeline is updated.</p>', 'PipelineExecution$pipelineVersion' => '<p>The version number of the pipeline with the specified pipeline execution.</p>', 'PipelineSummary$version' => '<p>The version number of the pipeline.</p>', ], ], 'PipelineVersionNotFoundException' => [ 'base' => '<p>The pipeline version was specified in an invalid format or cannot be found.</p>', 'refs' => [], ], 'PollForJobsInput' => [ 'base' => '<p>Represents the input of a <code>PollForJobs</code> action.</p>', 'refs' => [], ], 'PollForJobsOutput' => [ 'base' => '<p>Represents the output of a <code>PollForJobs</code> action.</p>', 'refs' => [], ], 'PollForThirdPartyJobsInput' => [ 'base' => '<p>Represents the input of a <code>PollForThirdPartyJobs</code> action.</p>', 'refs' => [], ], 'PollForThirdPartyJobsOutput' => [ 'base' => '<p>Represents the output of a <code>PollForThirdPartyJobs</code> action.</p>', 'refs' => [], ], 'PutActionRevisionInput' => [ 'base' => '<p>Represents the input of a <code>PutActionRevision</code> action.</p>', 'refs' => [], ], 'PutActionRevisionOutput' => [ 'base' => '<p>Represents the output of a <code>PutActionRevision</code> action.</p>', 'refs' => [], ], 'PutApprovalResultInput' => [ 'base' => '<p>Represents the input of a <code>PutApprovalResult</code> action.</p>', 'refs' => [], ], 'PutApprovalResultOutput' => [ 'base' => '<p>Represents the output of a <code>PutApprovalResult</code> action.</p>', 'refs' => [], ], 'PutJobFailureResultInput' => [ 'base' => '<p>Represents the input of a <code>PutJobFailureResult</code> action.</p>', 'refs' => [], ], 'PutJobSuccessResultInput' => [ 'base' => '<p>Represents the input of a <code>PutJobSuccessResult</code> action.</p>', 'refs' => [], ], 'PutThirdPartyJobFailureResultInput' => [ 'base' => '<p>Represents the input of a <code>PutThirdPartyJobFailureResult</code> action.</p>', 'refs' => [], ], 'PutThirdPartyJobSuccessResultInput' => [ 'base' => '<p>Represents the input of a <code>PutThirdPartyJobSuccessResult</code> action.</p>', 'refs' => [], ], 'PutWebhookInput' => [ 'base' => NULL, 'refs' => [], ], 'PutWebhookOutput' => [ 'base' => NULL, 'refs' => [], ], 'QueryParamMap' => [ 'base' => NULL, 'refs' => [ 'PollForJobsInput$queryParam' => '<p>A map of property names and values. For an action type with no queryable properties, this value must be null or an empty map. For an action type with a queryable property, you must supply that property as a key in the map. Only jobs whose action configuration matches the mapped value are returned.</p>', ], ], 'RegisterWebhookWithThirdPartyInput' => [ 'base' => NULL, 'refs' => [], ], 'RegisterWebhookWithThirdPartyOutput' => [ 'base' => NULL, 'refs' => [], ], 'ResolvedActionConfigurationMap' => [ 'base' => NULL, 'refs' => [ 'ActionExecutionInput$resolvedConfiguration' => '<p>Configuration data for an action execution with all variable references replaced with their real values for the execution.</p>', ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceInput$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to get tags for.</p>', 'TagResourceInput$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource you want to add tags to.</p>', 'UntagResourceInput$resourceArn' => '<p> The Amazon Resource Name (ARN) of the resource to remove tags from.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource was specified in an invalid format.</p>', 'refs' => [], ], 'RetryStageExecutionInput' => [ 'base' => '<p>Represents the input of a <code>RetryStageExecution</code> action.</p>', 'refs' => [], ], 'RetryStageExecutionOutput' => [ 'base' => '<p>Represents the output of a <code>RetryStageExecution</code> action.</p>', 'refs' => [], ], 'Revision' => [ 'base' => NULL, 'refs' => [ 'ActionRevision$revisionId' => '<p>The system-generated unique ID that identifies the revision number of the action.</p>', 'Artifact$revision' => '<p>The artifact\'s revision ID. Depending on the type of object, this could be a commit ID (GitHub) or a revision ID (Amazon S3).</p>', 'ArtifactRevision$revisionId' => '<p>The revision ID of the artifact.</p>', 'CurrentRevision$revision' => '<p>The revision ID of the current version of an artifact.</p>', 'SourceRevision$revisionId' => '<p>The system-generated unique ID that identifies the revision number of the artifact.</p>', ], ], 'RevisionChangeIdentifier' => [ 'base' => NULL, 'refs' => [ 'ActionRevision$revisionChangeId' => '<p>The unique identifier of the change that set the state to this revision (for example, a deployment ID or timestamp).</p>', 'ArtifactRevision$revisionChangeIdentifier' => '<p>An additional identifier for a revision, such as a commit date or, for artifacts stored in Amazon S3 buckets, the ETag value.</p>', 'CurrentRevision$changeIdentifier' => '<p>The change identifier for the current revision.</p>', ], ], 'RevisionSummary' => [ 'base' => NULL, 'refs' => [ 'ArtifactRevision$revisionSummary' => '<p>Summary information about the most recent revision of the artifact. For GitHub and AWS CodeCommit repositories, the commit message. For Amazon S3 buckets or actions, the user-provided content of a <code>codepipeline-artifact-revision-summary</code> key specified in the object metadata.</p>', 'CurrentRevision$revisionSummary' => '<p>The summary of the most recent revision of the artifact.</p>', 'SourceRevision$revisionSummary' => '<p>Summary information about the most recent revision of the artifact. For GitHub and AWS CodeCommit repositories, the commit message. For Amazon S3 buckets or actions, the user-provided content of a <code>codepipeline-artifact-revision-summary</code> key specified in the object metadata.</p>', ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'ActionDeclaration$roleArn' => '<p>The ARN of the IAM service role that performs the declared action. This is assumed through the roleArn for the pipeline.</p>', 'ActionExecutionInput$roleArn' => '<p>The ARN of the IAM service role that performs the declared action. This is assumed through the roleArn for the pipeline. </p>', 'PipelineDeclaration$roleArn' => '<p>The Amazon Resource Name (ARN) for AWS CodePipeline to use to either perform actions with no <code>actionRoleArn</code>, or to use to assume roles for actions with an <code>actionRoleArn</code>.</p>', ], ], 'S3ArtifactLocation' => [ 'base' => '<p>The location of the S3 bucket that contains a revision.</p>', 'refs' => [ 'ArtifactLocation$s3Location' => '<p>The S3 bucket that contains the artifact.</p>', ], ], 'S3Bucket' => [ 'base' => NULL, 'refs' => [ 'S3Location$bucket' => '<p>The Amazon S3 artifact bucket for an action\'s artifacts.</p>', ], ], 'S3BucketName' => [ 'base' => NULL, 'refs' => [ 'S3ArtifactLocation$bucketName' => '<p>The name of the S3 bucket.</p>', ], ], 'S3Key' => [ 'base' => NULL, 'refs' => [ 'S3Location$key' => '<p>The artifact name.</p>', ], ], 'S3Location' => [ 'base' => '<p>The Amazon S3 artifact location for an action\'s artifacts.</p>', 'refs' => [ 'ArtifactDetail$s3location' => '<p>The Amazon S3 artifact location for the action execution.</p>', ], ], 'S3ObjectKey' => [ 'base' => NULL, 'refs' => [ 'S3ArtifactLocation$objectKey' => '<p>The key of the object in the S3 bucket, which uniquely identifies the object in the bucket.</p>', ], ], 'SecretAccessKey' => [ 'base' => NULL, 'refs' => [ 'AWSSessionCredentials$secretAccessKey' => '<p>The secret access key for the session.</p>', ], ], 'SessionToken' => [ 'base' => NULL, 'refs' => [ 'AWSSessionCredentials$sessionToken' => '<p>The token for the session.</p>', ], ], 'SourceRevision' => [ 'base' => '<p>Information about the version (or revision) of a source artifact that initiated a pipeline execution.</p>', 'refs' => [ 'SourceRevisionList$member' => NULL, ], ], 'SourceRevisionList' => [ 'base' => NULL, 'refs' => [ 'PipelineExecutionSummary$sourceRevisions' => '<p>A list of the source artifact revisions that initiated a pipeline execution.</p>', ], ], 'StageActionDeclarationList' => [ 'base' => NULL, 'refs' => [ 'StageDeclaration$actions' => '<p>The actions included in a stage.</p>', ], ], 'StageBlockerDeclarationList' => [ 'base' => NULL, 'refs' => [ 'StageDeclaration$blockers' => '<p>Reserved for future use.</p>', ], ], 'StageContext' => [ 'base' => '<p>Represents information about a stage to a job worker.</p>', 'refs' => [ 'PipelineContext$stage' => '<p>The stage of the pipeline.</p>', ], ], 'StageDeclaration' => [ 'base' => '<p>Represents information about a stage and its definition.</p>', 'refs' => [ 'PipelineStageDeclarationList$member' => NULL, ], ], 'StageExecution' => [ 'base' => '<p>Represents information about the run of a stage.</p>', 'refs' => [ 'StageState$latestExecution' => '<p>Information about the latest execution in the stage, including its ID and status.</p>', ], ], 'StageExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'StageExecution$status' => '<p>The status of the stage, or for a completed stage, the last status of the stage.</p>', ], ], 'StageName' => [ 'base' => NULL, 'refs' => [ 'ActionExecutionDetail$stageName' => '<p>The name of the stage that contains the action.</p>', 'DisableStageTransitionInput$stageName' => '<p>The name of the stage where you want to disable the inbound or outbound transition of artifacts.</p>', 'EnableStageTransitionInput$stageName' => '<p>The name of the stage where you want to enable the transition of artifacts, either into the stage (inbound) or from that stage to the next stage (outbound).</p>', 'PutActionRevisionInput$stageName' => '<p>The name of the stage that contains the action that acts on the revision.</p>', 'PutApprovalResultInput$stageName' => '<p>The name of the stage that contains the action.</p>', 'RetryStageExecutionInput$stageName' => '<p>The name of the failed stage to be retried.</p>', 'StageContext$name' => '<p>The name of the stage.</p>', 'StageDeclaration$name' => '<p>The name of the stage.</p>', 'StageState$stageName' => '<p>The name of the stage.</p>', ], ], 'StageNotFoundException' => [ 'base' => '<p>The stage was specified in an invalid format or cannot be found.</p>', 'refs' => [], ], 'StageNotRetryableException' => [ 'base' => '<p>Unable to retry. The pipeline structure or stage state might have changed while actions awaited retry, or the stage contains no failed actions.</p>', 'refs' => [], ], 'StageRetryMode' => [ 'base' => NULL, 'refs' => [ 'RetryStageExecutionInput$retryMode' => '<p>The scope of the retry attempt. Currently, the only supported value is FAILED_ACTIONS.</p>', ], ], 'StageState' => [ 'base' => '<p>Represents information about the state of the stage.</p>', 'refs' => [ 'StageStateList$member' => NULL, ], ], 'StageStateList' => [ 'base' => NULL, 'refs' => [ 'GetPipelineStateOutput$stageStates' => '<p>A list of the pipeline stage output information, including stage name, state, most recent run details, whether the stage is disabled, and other data.</p>', ], ], 'StageTransitionType' => [ 'base' => NULL, 'refs' => [ 'DisableStageTransitionInput$transitionType' => '<p>Specifies whether artifacts are prevented from transitioning into the stage and being processed by the actions in that stage (inbound), or prevented from transitioning from the stage after they have been processed by the actions in that stage (outbound).</p>', 'EnableStageTransitionInput$transitionType' => '<p>Specifies whether artifacts are allowed to enter the stage and be processed by the actions in that stage (inbound) or whether already processed artifacts are allowed to transition to the next stage (outbound).</p>', ], ], 'StartPipelineExecutionInput' => [ 'base' => '<p>Represents the input of a <code>StartPipelineExecution</code> action.</p>', 'refs' => [], ], 'StartPipelineExecutionOutput' => [ 'base' => '<p>Represents the output of a <code>StartPipelineExecution</code> action.</p>', 'refs' => [], ], 'StopExecutionTrigger' => [ 'base' => '<p>The interaction that stopped a pipeline execution.</p>', 'refs' => [ 'PipelineExecutionSummary$stopTrigger' => '<p>The interaction that stopped a pipeline execution.</p>', ], ], 'StopPipelineExecutionInput' => [ 'base' => NULL, 'refs' => [], ], 'StopPipelineExecutionOutput' => [ 'base' => NULL, 'refs' => [], ], 'StopPipelineExecutionReason' => [ 'base' => NULL, 'refs' => [ 'StopExecutionTrigger$reason' => '<p>The user-specified reason the pipeline was stopped.</p>', 'StopPipelineExecutionInput$reason' => '<p>Use this option to enter comments, such as the reason the pipeline was stopped.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'ResolvedActionConfigurationMap$key' => NULL, 'ResolvedActionConfigurationMap$value' => NULL, ], ], 'Tag' => [ 'base' => '<p>A tag is a key-value pair that is used to manage the resource.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$key' => '<p>The tag\'s key.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$tagKeys' => '<p>The list of keys for the tags to be removed from the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateCustomActionTypeInput$tags' => '<p>The tags for the custom action.</p>', 'CreateCustomActionTypeOutput$tags' => '<p>Specifies the tags applied to the custom action.</p>', 'CreatePipelineInput$tags' => '<p>The tags for the pipeline.</p>', 'CreatePipelineOutput$tags' => '<p>Specifies the tags applied to the pipeline.</p>', 'ListTagsForResourceOutput$tags' => '<p>The tags for the resource.</p>', 'ListWebhookItem$tags' => '<p>Specifies the tags applied to the webhook.</p>', 'PutWebhookInput$tags' => '<p>The tags for the webhook.</p>', 'TagResourceInput$tags' => '<p>The tags you want to modify or add to the resource.</p>', ], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$value' => '<p>The tag\'s value.</p>', ], ], 'ThirdPartyJob' => [ 'base' => '<p>A response to a <code>PollForThirdPartyJobs</code> request returned by AWS CodePipeline when there is a job to be worked on by a partner action.</p>', 'refs' => [ 'ThirdPartyJobList$member' => NULL, ], ], 'ThirdPartyJobData' => [ 'base' => '<p>Represents information about the job data for a partner action.</p>', 'refs' => [ 'ThirdPartyJobDetails$data' => '<p>The data to be returned by the third party job worker.</p>', ], ], 'ThirdPartyJobDetails' => [ 'base' => '<p>The details of a job sent in response to a <code>GetThirdPartyJobDetails</code> request.</p>', 'refs' => [ 'GetThirdPartyJobDetailsOutput$jobDetails' => '<p>The details of the job, including any protected values defined for the job.</p>', ], ], 'ThirdPartyJobId' => [ 'base' => NULL, 'refs' => [ 'AcknowledgeThirdPartyJobInput$jobId' => '<p>The unique system-generated ID of the job.</p>', 'GetThirdPartyJobDetailsInput$jobId' => '<p>The unique system-generated ID used for identifying the job.</p>', 'PutThirdPartyJobFailureResultInput$jobId' => '<p>The ID of the job that failed. This is the same ID returned from <code>PollForThirdPartyJobs</code>.</p>', 'PutThirdPartyJobSuccessResultInput$jobId' => '<p>The ID of the job that successfully completed. This is the same ID returned from <code>PollForThirdPartyJobs</code>.</p>', 'ThirdPartyJobDetails$id' => '<p>The identifier used to identify the job details in AWS CodePipeline.</p>', ], ], 'ThirdPartyJobList' => [ 'base' => NULL, 'refs' => [ 'PollForThirdPartyJobsOutput$jobs' => '<p>Information about the jobs to take action on.</p>', ], ], 'Time' => [ 'base' => NULL, 'refs' => [ 'CurrentRevision$created' => '<p>The date and time when the most recent revision of the artifact was created, in timestamp format.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ActionExecution$lastStatusChange' => '<p>The last status change of the action.</p>', 'ActionExecutionDetail$startTime' => '<p>The start time of the action execution.</p>', 'ActionExecutionDetail$lastUpdateTime' => '<p>The last update time of the action execution.</p>', 'ActionRevision$created' => '<p>The date and time when the most recent version of the action was created, in timestamp format.</p>', 'ArtifactRevision$created' => '<p>The date and time when the most recent revision of the artifact was created, in timestamp format.</p>', 'GetPipelineStateOutput$created' => '<p>The date and time the pipeline was created, in timestamp format.</p>', 'GetPipelineStateOutput$updated' => '<p>The date and time the pipeline was last updated, in timestamp format.</p>', 'PipelineExecutionSummary$startTime' => '<p>The date and time when the pipeline execution began, in timestamp format.</p>', 'PipelineExecutionSummary$lastUpdateTime' => '<p>The date and time of the last change to the pipeline execution, in timestamp format.</p>', 'PipelineMetadata$created' => '<p>The date and time the pipeline was created, in timestamp format.</p>', 'PipelineMetadata$updated' => '<p>The date and time the pipeline was last updated, in timestamp format.</p>', 'PipelineSummary$created' => '<p>The date and time the pipeline was created, in timestamp format.</p>', 'PipelineSummary$updated' => '<p>The date and time of the last update to the pipeline, in timestamp format.</p>', 'PutApprovalResultOutput$approvedAt' => '<p>The timestamp showing when the approval or rejection was submitted.</p>', ], ], 'TooManyTagsException' => [ 'base' => '<p>The tags limit for a resource has been exceeded.</p>', 'refs' => [], ], 'TransitionState' => [ 'base' => '<p>Represents information about the state of transitions between one stage and another stage.</p>', 'refs' => [ 'StageState$inboundTransitionState' => '<p>The state of the inbound transition, which is either enabled or disabled.</p>', ], ], 'TriggerDetail' => [ 'base' => NULL, 'refs' => [ 'ExecutionTrigger$triggerDetail' => '<p>Detail related to the event that started a pipeline execution, such as the webhook ARN of the webhook that triggered the pipeline execution or the user ARN for a user-initiated <code>start-pipeline-execution</code> CLI command.</p>', ], ], 'TriggerType' => [ 'base' => NULL, 'refs' => [ 'ExecutionTrigger$triggerType' => '<p>The type of change-detection method, command, or user interaction that started a pipeline execution.</p>', ], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePipelineInput' => [ 'base' => '<p>Represents the input of an <code>UpdatePipeline</code> action.</p>', 'refs' => [], ], 'UpdatePipelineOutput' => [ 'base' => '<p>Represents the output of an <code>UpdatePipeline</code> action.</p>', 'refs' => [], ], 'Url' => [ 'base' => NULL, 'refs' => [ 'ActionExecution$externalExecutionUrl' => '<p>The URL of a resource external to AWS that is used when running the action (for example, an external repository URL).</p>', 'ActionExecutionResult$externalExecutionUrl' => '<p>The deepest external link to the external resource (for example, a repository URL or deployment endpoint) that is used when running the action.</p>', 'ActionState$entityUrl' => '<p>A URL link for more information about the state of the action, such as a deployment group details page.</p>', 'ActionState$revisionUrl' => '<p>A URL link for more information about the revision, such as a commit details page.</p>', 'ActionTypeSettings$thirdPartyConfigurationUrl' => '<p>The URL of a sign-up page where users can sign up for an external service and perform initial configuration of the action provided by that service.</p>', 'ArtifactRevision$revisionUrl' => '<p>The commit ID for the artifact revision. For artifacts stored in GitHub or AWS CodeCommit repositories, the commit ID is linked to a commit details page.</p>', 'SourceRevision$revisionUrl' => '<p>The commit ID for the artifact revision. For artifacts stored in GitHub or AWS CodeCommit repositories, the commit ID is linked to a commit details page.</p>', ], ], 'UrlTemplate' => [ 'base' => NULL, 'refs' => [ 'ActionTypeSettings$entityUrlTemplate' => '<p>The URL returned to the AWS CodePipeline console that provides a deep link to the resources of the external system, such as the configuration page for an AWS CodeDeploy deployment group. This link is provided as part of the action display in the pipeline.</p>', 'ActionTypeSettings$executionUrlTemplate' => '<p>The URL returned to the AWS CodePipeline console that contains a link to the top-level landing page for the external system, such as the console page for AWS CodeDeploy. This link is shown on the pipeline view page in the AWS CodePipeline console and provides a link to the execution entity of the external action.</p>', 'ActionTypeSettings$revisionUrlTemplate' => '<p>The URL returned to the AWS CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The validation was specified in an invalid format.</p>', 'refs' => [], ], 'Version' => [ 'base' => NULL, 'refs' => [ 'ActionTypeId$version' => '<p>A string that describes the action version.</p>', 'CreateCustomActionTypeInput$version' => '<p>The version identifier of the custom action.</p>', 'DeleteCustomActionTypeInput$version' => '<p>The version of the custom action to delete.</p>', ], ], 'WebhookArn' => [ 'base' => NULL, 'refs' => [ 'ListWebhookItem$arn' => '<p>The Amazon Resource Name (ARN) of the webhook.</p>', ], ], 'WebhookAuthConfiguration' => [ 'base' => '<p>The authentication applied to incoming webhook trigger requests.</p>', 'refs' => [ 'WebhookDefinition$authenticationConfiguration' => '<p>Properties that configure the authentication applied to incoming webhook trigger requests. The required properties depend on the authentication type. For GITHUB_HMAC, only the <code>SecretToken </code>property must be set. For IP, only the <code>AllowedIPRange </code>property must be set to a valid CIDR range. For UNAUTHENTICATED, no properties can be set.</p>', ], ], 'WebhookAuthConfigurationAllowedIPRange' => [ 'base' => NULL, 'refs' => [ 'WebhookAuthConfiguration$AllowedIPRange' => '<p>The property used to configure acceptance of webhooks in an IP address range. For IP, only the <code>AllowedIPRange</code> property must be set. This property must be set to a valid CIDR range.</p>', ], ], 'WebhookAuthConfigurationSecretToken' => [ 'base' => NULL, 'refs' => [ 'WebhookAuthConfiguration$SecretToken' => '<p>The property used to configure GitHub authentication. For GITHUB_HMAC, only the <code>SecretToken</code> property must be set.</p>', ], ], 'WebhookAuthenticationType' => [ 'base' => NULL, 'refs' => [ 'WebhookDefinition$authentication' => '<p>Supported options are GITHUB_HMAC, IP, and UNAUTHENTICATED.</p> <ul> <li> <p>For information about the authentication scheme implemented by GITHUB_HMAC, see <a href="https://developer.github.com/webhooks/securing/">Securing your webhooks</a> on the GitHub Developer website.</p> </li> <li> <p> IP rejects webhooks trigger requests unless they originate from an IP address in the IP range whitelisted in the authentication configuration.</p> </li> <li> <p> UNAUTHENTICATED accepts all webhook trigger requests regardless of origin.</p> </li> </ul>', ], ], 'WebhookDefinition' => [ 'base' => '<p>Represents information about a webhook and its definition.</p>', 'refs' => [ 'ListWebhookItem$definition' => '<p>The detail returned for each webhook, such as the webhook authentication type and filter rules.</p>', 'PutWebhookInput$webhook' => '<p>The detail provided in an input file to create the webhook, such as the webhook name, the pipeline name, and the action name. Give the webhook a unique name that helps you identify it. You might name the webhook after the pipeline and action it targets so that you can easily recognize what it\'s used for later.</p>', ], ], 'WebhookErrorCode' => [ 'base' => NULL, 'refs' => [ 'ListWebhookItem$errorCode' => '<p>The number code of the error.</p>', ], ], 'WebhookErrorMessage' => [ 'base' => NULL, 'refs' => [ 'ListWebhookItem$errorMessage' => '<p>The text of the error message about the webhook.</p>', ], ], 'WebhookFilterRule' => [ 'base' => '<p>The event criteria that specify when a webhook notification is sent to your URL.</p>', 'refs' => [ 'WebhookFilters$member' => NULL, ], ], 'WebhookFilters' => [ 'base' => NULL, 'refs' => [ 'WebhookDefinition$filters' => '<p>A list of rules applied to the body/payload sent in the POST request to a webhook URL. All defined rules must pass for the request to be accepted and the pipeline started.</p>', ], ], 'WebhookLastTriggered' => [ 'base' => NULL, 'refs' => [ 'ListWebhookItem$lastTriggered' => '<p>The date and time a webhook was last successfully triggered, in timestamp format.</p>', ], ], 'WebhookList' => [ 'base' => NULL, 'refs' => [ 'ListWebhooksOutput$webhooks' => '<p>The JSON detail returned for each webhook in the list output for the ListWebhooks call.</p>', ], ], 'WebhookName' => [ 'base' => NULL, 'refs' => [ 'DeleteWebhookInput$name' => '<p>The name of the webhook you want to delete.</p>', 'DeregisterWebhookWithThirdPartyInput$webhookName' => '<p>The name of the webhook you want to deregister.</p>', 'RegisterWebhookWithThirdPartyInput$webhookName' => '<p>The name of an existing webhook created with PutWebhook to register with a supported third party. </p>', 'WebhookDefinition$name' => '<p>The name of the webhook.</p>', ], ], 'WebhookNotFoundException' => [ 'base' => '<p>The specified webhook was entered in an invalid format or cannot be found.</p>', 'refs' => [], ], 'WebhookUrl' => [ 'base' => NULL, 'refs' => [ 'ListWebhookItem$url' => '<p>A unique URL generated by CodePipeline. When a POST request is made to this URL, the defined pipeline is started as long as the body of the post request satisfies the defined authentication and filtering conditions. Deleting and re-creating a webhook makes the old URL invalid and generates a new one.</p>', ], ], ],];
