<?php
// This file was auto-generated from sdk-root/src/data/codeguru-reviewer/2019-09-19/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>This section provides documentation for the Amazon CodeGuru Reviewer API operations. CodeGuru Reviewer is a service that uses program analysis and machine learning to detect potential defects that are difficult for developers to find and recommends fixes in your Java code.</p> <p>By proactively detecting and providing recommendations for addressing code defects and implementing best practices, CodeGuru Reviewer improves the overall quality and maintainability of your code base during the code review stage. For more information about CodeGuru Reviewer, see the <i> <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/welcome.html">Amazon CodeGuru Reviewer User Guide</a>.</i> </p>', 'operations' => [ 'AssociateRepository' => '<p> Use to associate an AWS CodeCommit repository or a repostory managed by AWS CodeStar Connections with Amazon CodeGuru Reviewer. When you associate a repository, CodeGuru Reviewer reviews source code changes in the repository\'s pull requests and provides automatic recommendations. You can view recommendations using the CodeGuru Reviewer console. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/recommendations.html">Recommendations in Amazon CodeGuru Reviewer</a> in the <i>Amazon CodeGuru Reviewer User Guide.</i> </p> <p>If you associate a CodeCommit repository, it must be in the same AWS Region and AWS account where its CodeGuru Reviewer code reviews are configured.</p> <p> Bitbucket and GitHub Enterprise Server repositories are managed by AWS CodeStar Connections to connect to CodeGuru Reviewer. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/reviewer-ug/step-one.html#select-repository-source-provider">Connect to a repository source provider</a> in the <i>Amazon CodeGuru Reviewer User Guide.</i> </p> <note> <p> You cannot use the CodeGuru Reviewer SDK or the AWS CLI to associate a GitHub repository with Amazon CodeGuru Reviewer. To associate a GitHub repository, use the console. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/getting-started-with-guru.html">Getting started with CodeGuru Reviewer</a> in the <i>CodeGuru Reviewer User Guide.</i> </p> </note>', 'DescribeCodeReview' => '<p> Returns the metadata associated with the code review along with its status.</p>', 'DescribeRecommendationFeedback' => '<p> Describes the customer feedback for a CodeGuru Reviewer recommendation. </p>', 'DescribeRepositoryAssociation' => '<p> Returns a <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"> <code>RepositoryAssociation</code> </a> object that contains information about the requested repository association. </p>', 'DisassociateRepository' => '<p>Removes the association between Amazon CodeGuru Reviewer and a repository.</p>', 'ListCodeReviews' => '<p> Lists all the code reviews that the customer has created in the past 90 days. </p>', 'ListRecommendationFeedback' => '<p> Returns a list of <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RecommendationFeedbackSummary.html"> <code>RecommendationFeedbackSummary</code> </a> objects that contain customer recommendation feedback for all CodeGuru Reviewer users. </p>', 'ListRecommendations' => '<p> Returns the list of all recommendations for a completed code review. </p>', 'ListRepositoryAssociations' => '<p> Returns a list of <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html"> <code>RepositoryAssociationSummary</code> </a> objects that contain summary information about a repository association. You can filter the returned list by <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-ProviderType"> <code>ProviderType</code> </a>, <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-Name"> <code>Name</code> </a>, <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-State"> <code>State</code> </a>, and <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-Owner"> <code>Owner</code> </a>. </p>', 'PutRecommendationFeedback' => '<p> Stores customer feedback for a CodeGuru Reviewer recommendation. When this API is called again with different reactions the previous feedback is overwritten. </p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'CodeReview$CodeReviewArn' => '<p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a> object. </p>', 'CodeReviewSummary$CodeReviewArn' => '<p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a> object. </p>', 'DescribeCodeReviewRequest$CodeReviewArn' => '<p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a> object. </p>', 'DescribeRecommendationFeedbackRequest$CodeReviewArn' => '<p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a> object. </p>', 'DescribeRepositoryAssociationRequest$AssociationArn' => '<p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"> <code>RepositoryAssociation</code> </a> object. You can retrieve this ARN by calling <code>ListRepositories</code>.</p>', 'DisassociateRepositoryRequest$AssociationArn' => '<p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"> <code>RepositoryAssociation</code> </a> object. </p>', 'ListRecommendationFeedbackRequest$CodeReviewArn' => '<p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a> object. </p>', 'ListRecommendationsRequest$CodeReviewArn' => '<p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a> object. </p>', 'PutRecommendationFeedbackRequest$CodeReviewArn' => '<p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a> object. </p>', 'RecommendationFeedback$CodeReviewArn' => '<p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html"> <code>CodeReview</code> </a> object. </p>', 'RepositoryAssociation$AssociationArn' => '<p>The Amazon Resource Name (ARN) identifying the repository association.</p>', 'RepositoryAssociationSummary$AssociationArn' => '<p>The Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html"> <code>RepositoryAssociation</code> </a> object. </p>', ], ], 'AssociateRepositoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateRepositoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociationId' => [ 'base' => NULL, 'refs' => [ 'RepositoryAssociation$AssociationId' => '<p>The ID of the repository association.</p>', 'RepositoryAssociationSummary$AssociationId' => '<p> The repository association ID. </p>', ], ], 'ClientRequestToken' => [ 'base' => NULL, 'refs' => [ 'AssociateRepositoryRequest$ClientRequestToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p> <p>To add a new repository association, this parameter specifies a unique identifier for the new repository association that helps ensure idempotency.</p> <p>If you use the AWS CLI or one of the AWS SDKs to call this operation, you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes that in the request. If you don\'t use the SDK and instead generate a raw HTTP request to the Secrets Manager service endpoint, you must generate a ClientRequestToken yourself for new versions and include that value in the request.</p> <p>You typically interact with this value if you implement your own retry logic and want to ensure that a given repository association is not created twice. We recommend that you generate a UUID-type value to ensure uniqueness within the specified repository association.</p> <p>Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate repository associations if there are failures and retries. </p>', ], ], 'CodeCommitRepository' => [ 'base' => '<p>Information about an AWS CodeCommit repository. The CodeCommit repository must be in the same AWS Region and AWS account where its CodeGuru Reviewer code reviews are configured. </p>', 'refs' => [ 'Repository$CodeCommit' => '<p>Information about an AWS CodeCommit repository.</p>', ], ], 'CodeReview' => [ 'base' => '<p> Information about a code review. </p>', 'refs' => [ 'DescribeCodeReviewResponse$CodeReview' => '<p> Information about the code review. </p>', ], ], 'CodeReviewSummaries' => [ 'base' => NULL, 'refs' => [ 'ListCodeReviewsResponse$CodeReviewSummaries' => '<p> A list of code reviews that meet the criteria of the request. </p>', ], ], 'CodeReviewSummary' => [ 'base' => '<p> Information about the summary of the code review. </p>', 'refs' => [ 'CodeReviewSummaries$member' => NULL, ], ], 'CommitDiffSourceCodeType' => [ 'base' => '<p> The commit diff for the pull request. </p>', 'refs' => [ 'SourceCodeType$CommitDiff' => '<p> The commit diff for the pull request. </p>', ], ], 'CommitId' => [ 'base' => NULL, 'refs' => [ 'CommitDiffSourceCodeType$SourceCommit' => '<p> The SHA of the source commit. </p>', 'CommitDiffSourceCodeType$DestinationCommit' => '<p> The SHA of the destination commit. </p>', ], ], 'ConflictException' => [ 'base' => '<p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. </p>', 'refs' => [], ], 'ConnectionArn' => [ 'base' => NULL, 'refs' => [ 'RepositoryAssociation$ConnectionArn' => '<p> The Amazon Resource Name (ARN) of an AWS CodeStar Connections connection. Its format is <code>arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id</code>. For more information, see <a href="https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html">Connection</a> in the <i>AWS CodeStar Connections API Reference</i>. </p>', 'RepositoryAssociationSummary$ConnectionArn' => '<p> The Amazon Resource Name (ARN) of an AWS CodeStar Connections connection. Its format is <code>arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id</code>. For more information, see <a href="https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html">Connection</a> in the <i>AWS CodeStar Connections API Reference</i>. </p>', 'ThirdPartySourceRepository$ConnectionArn' => '<p> The Amazon Resource Name (ARN) of an AWS CodeStar Connections connection. Its format is <code>arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id</code>. For more information, see <a href="https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html">Connection</a> in the <i>AWS CodeStar Connections API Reference</i>. </p>', ], ], 'DescribeCodeReviewRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCodeReviewResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRecommendationFeedbackRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRecommendationFeedbackResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRepositoryAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRepositoryAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateRepositoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateRepositoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ConflictException$Message' => NULL, 'InternalServerException$Message' => NULL, 'NotFoundException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ThrottlingException$Message' => NULL, 'ValidationException$Message' => NULL, ], ], 'FilePath' => [ 'base' => NULL, 'refs' => [ 'RecommendationSummary$FilePath' => '<p>Name of the file on which a recommendation is provided.</p>', ], ], 'FindingsCount' => [ 'base' => NULL, 'refs' => [ 'Metrics$FindingsCount' => '<p> Total number of recommendations found in the code review. </p>', 'MetricsSummary$FindingsCount' => '<p> Total number of recommendations found in the code review. </p>', ], ], 'InternalServerException' => [ 'base' => '<p>The server encountered an internal error and is unable to complete the request.</p>', 'refs' => [], ], 'JobState' => [ 'base' => NULL, 'refs' => [ 'CodeReview$State' => '<p>The valid code review states are:</p> <ul> <li> <p> <code>Completed</code>: The code review is complete. </p> </li> <li> <p> <code>Pending</code>: The code review started and has not completed or failed. </p> </li> <li> <p> <code>Failed</code>: The code review failed. </p> </li> <li> <p> <code>Deleting</code>: The code review is being deleted. </p> </li> </ul>', 'CodeReviewSummary$State' => '<p> The state of the code review. </p> <p>The valid code review states are:</p> <ul> <li> <p> <code>Completed</code>: The code review is complete. </p> </li> <li> <p> <code>Pending</code>: The code review started and has not completed or failed. </p> </li> <li> <p> <code>Failed</code>: The code review failed. </p> </li> <li> <p> <code>Deleting</code>: The code review is being deleted. </p> </li> </ul>', 'JobStates$member' => NULL, ], ], 'JobStates' => [ 'base' => NULL, 'refs' => [ 'ListCodeReviewsRequest$States' => '<p> List of states for filtering that needs to be applied before displaying the result. For example, <code>states=[Pending]</code> lists code reviews in the Pending state. </p> <p>The valid code review states are:</p> <ul> <li> <p> <code>Completed</code>: The code review is complete. </p> </li> <li> <p> <code>Pending</code>: The code review started and has not completed or failed. </p> </li> <li> <p> <code>Failed</code>: The code review failed. </p> </li> <li> <p> <code>Deleting</code>: The code review is being deleted. </p> </li> </ul>', ], ], 'LineNumber' => [ 'base' => NULL, 'refs' => [ 'RecommendationSummary$StartLine' => '<p> Start line from where the recommendation is applicable in the source commit or source branch. </p>', 'RecommendationSummary$EndLine' => '<p> Last line where the recommendation is applicable in the source commit or source branch. For a single line comment the start line and end line values are the same. </p>', ], ], 'ListCodeReviewsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListCodeReviewsRequest$MaxResults' => '<p> The maximum number of results that are returned per call. The default is 100. </p>', ], ], 'ListCodeReviewsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCodeReviewsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRecommendationFeedbackRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRecommendationFeedbackResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRepositoryAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRepositoryAssociationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListRecommendationFeedbackRequest$MaxResults' => '<p> The maximum number of results that are returned per call. The default is 100. </p>', 'ListRecommendationsRequest$MaxResults' => '<p> The maximum number of results that are returned per call. The default is 100. </p>', 'ListRepositoryAssociationsRequest$MaxResults' => '<p>The maximum number of repository association results returned by <code>ListRepositoryAssociations</code> in paginated output. When this parameter is used, <code>ListRepositoryAssociations</code> only returns <code>maxResults</code> results in a single page with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListRepositoryAssociations</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, <code>ListRepositoryAssociations</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>', ], ], 'MeteredLinesOfCodeCount' => [ 'base' => NULL, 'refs' => [ 'Metrics$MeteredLinesOfCodeCount' => '<p> Lines of code metered in the code review. For the initial code review pull request and all subsequent revisions, this includes all lines of code in the files added to the pull request. In subsequent revisions, for files that already existed in the pull request, this includes only the changed lines of code. In both cases, this does not include non-code lines such as comments and import statements. For example, if you submit a pull request containing 5 files, each with 500 lines of code, and in a subsequent revision you added a new file with 200 lines of code, and also modified a total of 25 lines across the initial 5 files, <code>MeteredLinesOfCodeCount</code> includes the first 5 files (5 * 500 = 2,500 lines), the new file (200 lines) and the 25 changed lines of code for a total of 2,725 lines of code. </p>', 'MetricsSummary$MeteredLinesOfCodeCount' => '<p> Lines of code metered in the code review. For the initial code review pull request and all subsequent revisions, this includes all lines of code in the files added to the pull request. In subsequent revisions, for files that already existed in the pull request, this includes only the changed lines of code. In both cases, this does not include non-code lines such as comments and import statements. For example, if you submit a pull request containing 5 files, each with 500 lines of code, and in a subsequent revision you added a new file with 200 lines of code, and also modified a total of 25 lines across the initial 5 files, <code>MeteredLinesOfCodeCount</code> includes the first 5 files (5 * 500 = 2,500 lines), the new file (200 lines) and the 25 changed lines of code for a total of 2,725 lines of code. </p>', ], ], 'Metrics' => [ 'base' => '<p> Information about the statistics from the code review. </p>', 'refs' => [ 'CodeReview$Metrics' => '<p> The statistics from the code review. </p>', ], ], 'MetricsSummary' => [ 'base' => '<p> Information about metrics summaries. </p>', 'refs' => [ 'CodeReviewSummary$MetricsSummary' => '<p> The statistics from the code review. </p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'CodeCommitRepository$Name' => '<p>The name of the AWS CodeCommit repository. For more information, see <a href="https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetRepository.html#CodeCommit-GetRepository-request-repositoryName">repositoryName</a> in the <i>AWS CodeCommit API Reference</i>.</p>', 'CodeReview$Name' => '<p> The name of the code review. </p>', 'CodeReview$RepositoryName' => '<p> The name of the repository. </p>', 'CodeReviewSummary$Name' => '<p> The name of the code review. </p>', 'CodeReviewSummary$RepositoryName' => '<p> The name of the repository. </p>', 'Names$member' => NULL, 'RepositoryAssociation$Name' => '<p>The name of the repository.</p>', 'RepositoryAssociationSummary$Name' => '<p>The name of the repository association.</p>', 'RepositoryNames$member' => NULL, 'ThirdPartySourceRepository$Name' => '<p> The name of the third party source repository. </p>', ], ], 'Names' => [ 'base' => NULL, 'refs' => [ 'ListRepositoryAssociationsRequest$Names' => '<p>List of repository names to use as a filter.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListCodeReviewsRequest$NextToken' => '<p> If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>', 'ListCodeReviewsResponse$NextToken' => '<p> Pagination token. </p>', 'ListRecommendationFeedbackRequest$NextToken' => '<p> If <code>nextToken</code> is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>', 'ListRecommendationFeedbackResponse$NextToken' => '<p> If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>', 'ListRecommendationsRequest$NextToken' => '<p> Pagination token. </p>', 'ListRecommendationsResponse$NextToken' => '<p> Pagination token. </p>', 'ListRepositoryAssociationsRequest$NextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>ListRepositoryAssociations</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. </p> <note> <p>Treat this token as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListRepositoryAssociationsResponse$NextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListRecommendations</code> request. When the results of a <code>ListRecommendations</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return. </p>', ], ], 'NotFoundException' => [ 'base' => '<p>The resource specified in the request was not found.</p>', 'refs' => [], ], 'Owner' => [ 'base' => NULL, 'refs' => [ 'CodeReview$Owner' => '<p>The owner of the repository. For an AWS CodeCommit repository, this is the AWS account ID of the account that owns the repository. For a GitHub or Bitbucket repository, this is the username for the account that owns the repository.</p>', 'CodeReviewSummary$Owner' => '<p>The owner of the repository. For an AWS CodeCommit repository, this is the AWS account ID of the account that owns the repository. For a GitHub or Bitbucket repository, this is the username for the account that owns the repository.</p>', 'Owners$member' => NULL, 'RepositoryAssociation$Owner' => '<p>The owner of the repository. For an AWS CodeCommit repository, this is the AWS account ID of the account that owns the repository. For a GitHub or Bitbucket repository, this is the username for the account that owns the repository.</p>', 'RepositoryAssociationSummary$Owner' => '<p>The owner of the repository. For an AWS CodeCommit repository, this is the AWS account ID of the account that owns the repository. For a GitHub or Bitbucket repository, this is the username for the account that owns the repository.</p>', 'ThirdPartySourceRepository$Owner' => '<p> The owner of the repository. For a GitHub, GitHub Enterprise, or Bitbucket repository, this is the username for the account that owns the repository. </p>', ], ], 'Owners' => [ 'base' => NULL, 'refs' => [ 'ListRepositoryAssociationsRequest$Owners' => '<p>List of owners to use as a filter. For AWS CodeCommit, it is the name of the CodeCommit account that was used to associate the repository. For other repository source providers, such as Bitbucket, this is name of the account that was used to associate the repository. </p>', ], ], 'ProviderType' => [ 'base' => NULL, 'refs' => [ 'CodeReview$ProviderType' => '<p> The type of repository that contains the reviewed code (for example, GitHub or Bitbucket). </p>', 'CodeReviewSummary$ProviderType' => '<p> The provider type of the repository association. </p>', 'ProviderTypes$member' => NULL, 'RepositoryAssociation$ProviderType' => '<p>The provider type of the repository association.</p>', 'RepositoryAssociationSummary$ProviderType' => '<p>The provider type of the repository association.</p>', ], ], 'ProviderTypes' => [ 'base' => NULL, 'refs' => [ 'ListCodeReviewsRequest$ProviderTypes' => '<p> List of provider types for filtering that needs to be applied before displaying the result. For example, <code>providerTypes=[GitHub]</code> lists code reviews from GitHub. </p>', 'ListRepositoryAssociationsRequest$ProviderTypes' => '<p>List of provider types to use as a filter.</p>', ], ], 'PullRequestId' => [ 'base' => NULL, 'refs' => [ 'CodeReview$PullRequestId' => '<p> The pull request ID for the code review. </p>', 'CodeReviewSummary$PullRequestId' => '<p> The pull request ID for the code review. </p>', ], ], 'PutRecommendationFeedbackRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutRecommendationFeedbackResponse' => [ 'base' => NULL, 'refs' => [], ], 'Reaction' => [ 'base' => NULL, 'refs' => [ 'Reactions$member' => NULL, ], ], 'Reactions' => [ 'base' => NULL, 'refs' => [ 'PutRecommendationFeedbackRequest$Reactions' => '<p> List for storing reactions. Reactions are utf-8 text code for emojis. If you send an empty list it clears all your feedback. </p>', 'RecommendationFeedback$Reactions' => '<p> List for storing reactions. Reactions are utf-8 text code for emojis. You can send an empty list to clear off all your feedback. </p>', 'RecommendationFeedbackSummary$Reactions' => '<p> List for storing reactions. Reactions are utf-8 text code for emojis. </p>', ], ], 'RecommendationFeedback' => [ 'base' => '<p> Information about the recommendation feedback. </p>', 'refs' => [ 'DescribeRecommendationFeedbackResponse$RecommendationFeedback' => '<p> The recommendation feedback given by the user. </p>', ], ], 'RecommendationFeedbackSummaries' => [ 'base' => NULL, 'refs' => [ 'ListRecommendationFeedbackResponse$RecommendationFeedbackSummaries' => '<p> Recommendation feedback summaries corresponding to the code review ARN. </p>', ], ], 'RecommendationFeedbackSummary' => [ 'base' => '<p> Information about recommendation feedback summaries. </p>', 'refs' => [ 'RecommendationFeedbackSummaries$member' => NULL, ], ], 'RecommendationId' => [ 'base' => NULL, 'refs' => [ 'DescribeRecommendationFeedbackRequest$RecommendationId' => '<p> The recommendation ID that can be used to track the provided recommendations and then to collect the feedback. </p>', 'PutRecommendationFeedbackRequest$RecommendationId' => '<p> The recommendation ID that can be used to track the provided recommendations and then to collect the feedback. </p>', 'RecommendationFeedback$RecommendationId' => '<p> The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect the feedback. </p>', 'RecommendationFeedbackSummary$RecommendationId' => '<p> The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect the feedback. </p>', 'RecommendationIds$member' => NULL, 'RecommendationSummary$RecommendationId' => '<p> The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect the feedback. </p>', ], ], 'RecommendationIds' => [ 'base' => NULL, 'refs' => [ 'ListRecommendationFeedbackRequest$RecommendationIds' => '<p> Used to query the recommendation feedback for a given recommendation. </p>', ], ], 'RecommendationSummaries' => [ 'base' => NULL, 'refs' => [ 'ListRecommendationsResponse$RecommendationSummaries' => '<p> List of recommendations for the requested code review. </p>', ], ], 'RecommendationSummary' => [ 'base' => '<p> Information about recommendations. </p>', 'refs' => [ 'RecommendationSummaries$member' => NULL, ], ], 'Repository' => [ 'base' => '<p> Information about an associated AWS CodeCommit repository or an associated repository that is managed by AWS CodeStar Connections (for example, Bitbucket). This <code>Repository</code> object is not used if your source code is in an associated GitHub repository. </p>', 'refs' => [ 'AssociateRepositoryRequest$Repository' => '<p>The repository to associate.</p>', ], ], 'RepositoryAssociation' => [ 'base' => '<p>Information about a repository association. The <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_DescribeRepositoryAssociation.html"> <code>DescribeRepositoryAssociation</code> </a> operation returns a <code>RepositoryAssociation</code> object.</p>', 'refs' => [ 'AssociateRepositoryResponse$RepositoryAssociation' => '<p>Information about the repository association.</p>', 'DescribeRepositoryAssociationResponse$RepositoryAssociation' => '<p>Information about the repository association.</p>', 'DisassociateRepositoryResponse$RepositoryAssociation' => '<p>Information about the disassociated repository.</p>', ], ], 'RepositoryAssociationState' => [ 'base' => NULL, 'refs' => [ 'RepositoryAssociation$State' => '<p>The state of the repository association.</p> <p>The valid repository association states are:</p> <ul> <li> <p> <b>Associated</b>: The repository association is complete. </p> </li> <li> <p> <b>Associating</b>: CodeGuru Reviewer is: </p> <ul> <li> <p> Setting up pull request notifications. This is required for pull requests to trigger a CodeGuru Reviewer review. </p> <note> <p> If your repository <code>ProviderType</code> is <code>GitHub</code> or <code>Bitbucket</code>, CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these webhooks, reviews of code in your repository cannot be triggered. </p> </note> </li> <li> <p> Setting up source code access. This is required for CodeGuru Reviewer to securely clone code in your repository. </p> </li> </ul> </li> <li> <p> <b>Failed</b>: The repository failed to associate or disassociate. </p> </li> <li> <p> <b>Disassociating</b>: CodeGuru Reviewer is removing the repository\'s pull request notifications and source code access. </p> </li> </ul>', 'RepositoryAssociationStates$member' => NULL, 'RepositoryAssociationSummary$State' => '<p>The state of the repository association.</p> <p>The valid repository association states are:</p> <ul> <li> <p> <b>Associated</b>: The repository association is complete. </p> </li> <li> <p> <b>Associating</b>: CodeGuru Reviewer is: </p> <ul> <li> <p> Setting up pull request notifications. This is required for pull requests to trigger a CodeGuru Reviewer review. </p> <note> <p> If your repository <code>ProviderType</code> is <code>GitHub</code> or <code>Bitbucket</code>, CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these webhooks, reviews of code in your repository cannot be triggered. </p> </note> </li> <li> <p> Setting up source code access. This is required for CodeGuru Reviewer to securely clone code in your repository. </p> </li> </ul> </li> <li> <p> <b>Failed</b>: The repository failed to associate or disassociate. </p> </li> <li> <p> <b>Disassociating</b>: CodeGuru Reviewer is removing the repository\'s pull request notifications and source code access. </p> </li> </ul>', ], ], 'RepositoryAssociationStates' => [ 'base' => NULL, 'refs' => [ 'ListRepositoryAssociationsRequest$States' => '<p>List of repository association states to use as a filter.</p> <p>The valid repository association states are:</p> <ul> <li> <p> <b>Associated</b>: The repository association is complete. </p> </li> <li> <p> <b>Associating</b>: CodeGuru Reviewer is: </p> <ul> <li> <p> Setting up pull request notifications. This is required for pull requests to trigger a CodeGuru Reviewer review. </p> <note> <p> If your repository <code>ProviderType</code> is <code>GitHub</code> or <code>Bitbucket</code>, CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these webhooks, reviews of code in your repository cannot be triggered. </p> </note> </li> <li> <p> Setting up source code access. This is required for CodeGuru Reviewer to securely clone code in your repository. </p> </li> </ul> </li> <li> <p> <b>Failed</b>: The repository failed to associate or disassociate. </p> </li> <li> <p> <b>Disassociating</b>: CodeGuru Reviewer is removing the repository\'s pull request notifications and source code access. </p> </li> </ul>', ], ], 'RepositoryAssociationSummaries' => [ 'base' => NULL, 'refs' => [ 'ListRepositoryAssociationsResponse$RepositoryAssociationSummaries' => '<p>A list of repository associations that meet the criteria of the request.</p>', ], ], 'RepositoryAssociationSummary' => [ 'base' => '<p>Summary information about a repository association. The <a href="https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html"> <code>ListRepositoryAssociations</code> </a> operation returns a list of <code>RepositoryAssociationSummary</code> objects.</p>', 'refs' => [ 'RepositoryAssociationSummaries$member' => NULL, ], ], 'RepositoryNames' => [ 'base' => NULL, 'refs' => [ 'ListCodeReviewsRequest$RepositoryNames' => '<p> List of repository names for filtering that needs to be applied before displaying the result. </p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p> The resource specified in the request was not found. </p>', 'refs' => [], ], 'SourceCodeType' => [ 'base' => '<p> Information about the source code type. </p>', 'refs' => [ 'CodeReview$SourceCodeType' => '<p> The type of the source code for the code review. </p>', ], ], 'StateReason' => [ 'base' => NULL, 'refs' => [ 'CodeReview$StateReason' => '<p> The reason for the state of the code review. </p>', 'RepositoryAssociation$StateReason' => '<p>A description of why the repository association is in the current state.</p>', ], ], 'Text' => [ 'base' => NULL, 'refs' => [ 'RecommendationSummary$Description' => '<p> A description of the recommendation generated by CodeGuru Reviewer for the lines of code between the start line and the end line. </p>', ], ], 'ThirdPartySourceRepository' => [ 'base' => '<p> Information about a third-party source repository connected to CodeGuru Reviewer. </p>', 'refs' => [ 'Repository$Bitbucket' => '<p> Information about a Bitbucket repository. </p>', 'Repository$GitHubEnterpriseServer' => '<p> Information about a GitHub Enterprise Server repository. </p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'TimeStamp' => [ 'base' => NULL, 'refs' => [ 'CodeReview$CreatedTimeStamp' => '<p> The time, in milliseconds since the epoch, when the code review was created. </p>', 'CodeReview$LastUpdatedTimeStamp' => '<p> The time, in milliseconds since the epoch, when the code review was last updated. </p>', 'CodeReviewSummary$CreatedTimeStamp' => '<p> The time, in milliseconds since the epoch, when the code review was created. </p>', 'CodeReviewSummary$LastUpdatedTimeStamp' => '<p> The time, in milliseconds since the epoch, when the code review was last updated. </p>', 'RecommendationFeedback$CreatedTimeStamp' => '<p> The time at which the feedback was created. </p>', 'RecommendationFeedback$LastUpdatedTimeStamp' => '<p> The time at which the feedback was last updated. </p>', 'RepositoryAssociation$LastUpdatedTimeStamp' => '<p>The time, in milliseconds since the epoch, when the repository association was last updated.</p>', 'RepositoryAssociation$CreatedTimeStamp' => '<p>The time, in milliseconds since the epoch, when the repository association was created.</p>', 'RepositoryAssociationSummary$LastUpdatedTimeStamp' => '<p>The time, in milliseconds since the epoch, since the repository association was last updated. </p>', ], ], 'Type' => [ 'base' => NULL, 'refs' => [ 'CodeReview$Type' => '<p> The type of code review. </p>', 'CodeReviewSummary$Type' => '<p> The type of the code review. </p>', 'ListCodeReviewsRequest$Type' => '<p> The type of code reviews to list in the response. </p>', ], ], 'UserId' => [ 'base' => NULL, 'refs' => [ 'DescribeRecommendationFeedbackRequest$UserId' => '<p> Optional parameter to describe the feedback for a given user. If this is not supplied, it defaults to the user making the request. </p> <p> The <code>UserId</code> is an IAM principal that can be specified as an AWS account ID or an Amazon Resource Name (ARN). For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying"> Specifying a Principal</a> in the <i>AWS Identity and Access Management User Guide</i>. </p>', 'RecommendationFeedback$UserId' => '<p> The ID of the user that made the API call. </p> <p> The <code>UserId</code> is an IAM principal that can be specified as an AWS account ID or an Amazon Resource Name (ARN). For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying"> Specifying a Principal</a> in the <i>AWS Identity and Access Management User Guide</i>. </p>', 'RecommendationFeedbackSummary$UserId' => '<p> The ID of the user that gave the feedback. </p> <p> The <code>UserId</code> is an IAM principal that can be specified as an AWS account ID or an Amazon Resource Name (ARN). For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying"> Specifying a Principal</a> in the <i>AWS Identity and Access Management User Guide</i>. </p>', 'UserIds$member' => NULL, ], ], 'UserIds' => [ 'base' => NULL, 'refs' => [ 'ListRecommendationFeedbackRequest$UserIds' => '<p> An AWS user\'s account ID or Amazon Resource Name (ARN). Use this ID to query the recommendation feedback for a code review from that user. </p> <p> The <code>UserId</code> is an IAM principal that can be specified as an AWS account ID or an Amazon Resource Name (ARN). For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying"> Specifying a Principal</a> in the <i>AWS Identity and Access Management User Guide</i>. </p>', ], ], 'ValidationException' => [ 'base' => '<p>The input fails to satisfy the specified constraints.</p>', 'refs' => [], ], ],];
