<?php
// This file was auto-generated from sdk-root/src/data/cloudformation/2010-05-15/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>AWS CloudFormation</fullname> <p>AWS CloudFormation allows you to create and manage AWS infrastructure deployments predictably and repeatedly. You can use AWS CloudFormation to leverage AWS products, such as Amazon Elastic Compute Cloud, Amazon Elastic Block Store, Amazon Simple Notification Service, Elastic Load Balancing, and Auto Scaling to build highly-reliable, highly scalable, cost-effective applications without creating or configuring the underlying AWS infrastructure.</p> <p>With AWS CloudFormation, you declare all of your resources and dependencies in a template file. The template defines a collection of resources as a single unit called a stack. AWS CloudFormation creates and deletes all member resources of the stack together and manages all dependencies between the resources for you.</p> <p>For more information about AWS CloudFormation, see the <a href="http://aws.amazon.com/cloudformation/">AWS CloudFormation Product Page</a>.</p> <p>Amazon CloudFormation makes use of other AWS products. If you need additional technical information about a specific AWS product, you can find the product\'s technical documentation at <a href="https://docs.aws.amazon.com/">docs.aws.amazon.com</a>.</p>', 'operations' => [ 'CancelUpdateStack' => '<p>Cancels an update on the specified stack. If the call completes successfully, the stack rolls back the update and reverts to the previous stack configuration.</p> <note> <p>You can cancel only stacks that are in the UPDATE_IN_PROGRESS state.</p> </note>', 'ContinueUpdateRollback' => '<p>For a specified stack that is in the <code>UPDATE_ROLLBACK_FAILED</code> state, continues rolling it back to the <code>UPDATE_ROLLBACK_COMPLETE</code> state. Depending on the cause of the failure, you can manually <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed"> fix the error</a> and continue the rollback. By continuing the rollback, you can return your stack to a working state (the <code>UPDATE_ROLLBACK_COMPLETE</code> state), and then try to update the stack again.</p> <p>A stack goes into the <code>UPDATE_ROLLBACK_FAILED</code> state when AWS CloudFormation cannot roll back all changes after a failed stack update. For example, you might have a stack that is rolling back to an old database instance that was deleted outside of AWS CloudFormation. Because AWS CloudFormation doesn\'t know the database was deleted, it assumes that the database instance still exists and attempts to roll back to it, causing the update rollback to fail.</p>', 'CreateChangeSet' => '<p>Creates a list of changes that will be applied to a stack so that you can review the changes before executing them. You can create a change set for a stack that doesn\'t exist or an existing stack. If you create a change set for a stack that doesn\'t exist, the change set shows all of the resources that AWS CloudFormation will create. If you create a change set for an existing stack, AWS CloudFormation compares the stack\'s information with the information that you submit in the change set and lists the differences. Use change sets to understand which resources AWS CloudFormation will create or change, and how it will change resources in an existing stack, before you create or update a stack.</p> <p>To create a change set for a stack that doesn\'t exist, for the <code>ChangeSetType</code> parameter, specify <code>CREATE</code>. To create a change set for an existing stack, specify <code>UPDATE</code> for the <code>ChangeSetType</code> parameter. To create a change set for an import operation, specify <code>IMPORT</code> for the <code>ChangeSetType</code> parameter. After the <code>CreateChangeSet</code> call successfully completes, AWS CloudFormation starts creating the change set. To check the status of the change set or to review it, use the <a>DescribeChangeSet</a> action.</p> <p>When you are satisfied with the changes the change set will make, execute the change set by using the <a>ExecuteChangeSet</a> action. AWS CloudFormation doesn\'t make changes until you execute the change set.</p>', 'CreateStack' => '<p>Creates a stack as specified in the template. After the call completes successfully, the stack creation starts. You can check the status of the stack via the <a>DescribeStacks</a> API.</p>', 'CreateStackInstances' => '<p>Creates stack instances for the specified accounts, within the specified Regions. A stack instance refers to a stack in a specific account and Region. You must specify at least one value for either <code>Accounts</code> or <code>DeploymentTargets</code>, and you must specify at least one value for <code>Regions</code>.</p>', 'CreateStackSet' => '<p>Creates a stack set.</p>', 'DeleteChangeSet' => '<p>Deletes the specified change set. Deleting change sets ensures that no one executes the wrong change set.</p> <p>If the call successfully completes, AWS CloudFormation successfully deleted the change set.</p>', 'DeleteStack' => '<p>Deletes a specified stack. Once the call completes successfully, stack deletion starts. Deleted stacks do not show up in the <a>DescribeStacks</a> API if the deletion has been completed successfully.</p>', 'DeleteStackInstances' => '<p>Deletes stack instances for the specified accounts, in the specified Regions. </p>', 'DeleteStackSet' => '<p>Deletes a stack set. Before you can delete a stack set, all of its member stack instances must be deleted. For more information about how to do this, see <a>DeleteStackInstances</a>. </p>', 'DeregisterType' => '<p>Removes a type or type version from active use in the CloudFormation registry. If a type or type version is deregistered, it cannot be used in CloudFormation operations.</p> <p>To deregister a type, you must individually deregister all registered versions of that type. If a type has only a single registered version, deregistering that version results in the type itself being deregistered. </p> <p>You cannot deregister the default version of a type, unless it is the only registered version of that type, in which case the type itself is deregistered as well. </p>', 'DescribeAccountLimits' => '<p>Retrieves your account\'s AWS CloudFormation limits, such as the maximum number of stacks that you can create in your account. For more information about account limits, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">AWS CloudFormation Limits</a> in the <i>AWS CloudFormation User Guide</i>.</p>', 'DescribeChangeSet' => '<p>Returns the inputs for the change set and a list of changes that AWS CloudFormation will make if you execute the change set. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-changesets.html">Updating Stacks Using Change Sets</a> in the AWS CloudFormation User Guide.</p>', 'DescribeStackDriftDetectionStatus' => '<p>Returns information about a stack drift detection operation. A stack drift detection operation detects whether a stack\'s actual configuration differs, or has <i>drifted</i>, from it\'s expected configuration, as defined in the stack template and any values specified as template parameters. A stack is considered to have drifted if one or more of its resources have drifted. For more information on stack and resource drift, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p> <p>Use <a>DetectStackDrift</a> to initiate a stack drift detection operation. <code>DetectStackDrift</code> returns a <code>StackDriftDetectionId</code> you can use to monitor the progress of the operation using <code>DescribeStackDriftDetectionStatus</code>. Once the drift detection operation has completed, use <a>DescribeStackResourceDrifts</a> to return drift information about the stack and its resources.</p>', 'DescribeStackEvents' => '<p>Returns all stack related events for a specified stack in reverse chronological order. For more information about a stack\'s event history, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/concept-stack.html">Stacks</a> in the AWS CloudFormation User Guide.</p> <note> <p>You can list events for stacks that have failed to create or have been deleted by specifying the unique stack identifier (stack ID).</p> </note>', 'DescribeStackInstance' => '<p>Returns the stack instance that\'s associated with the specified stack set, AWS account, and Region.</p> <p>For a list of stack instances that are associated with a specific stack set, use <a>ListStackInstances</a>.</p>', 'DescribeStackResource' => '<p>Returns a description of the specified resource in the specified stack.</p> <p>For deleted stacks, DescribeStackResource returns resource information for up to 90 days after the stack has been deleted.</p>', 'DescribeStackResourceDrifts' => '<p>Returns drift information for the resources that have been checked for drift in the specified stack. This includes actual and expected configuration values for resources where AWS CloudFormation detects configuration drift.</p> <p>For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has been checked for drift. Resources that have not yet been checked for drift are not included. Resources that do not currently support drift detection are not checked, and so not included. For a list of resources that support drift detection, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html">Resources that Support Drift Detection</a>.</p> <p>Use <a>DetectStackResourceDrift</a> to detect drift on individual resources, or <a>DetectStackDrift</a> to detect drift on all supported resources for a given stack.</p>', 'DescribeStackResources' => '<p>Returns AWS resource descriptions for running and deleted stacks. If <code>StackName</code> is specified, all the associated resources that are part of the stack are returned. If <code>PhysicalResourceId</code> is specified, the associated resources of the stack that the resource belongs to are returned.</p> <note> <p>Only the first 100 resources will be returned. If your stack has more resources than this, you should use <code>ListStackResources</code> instead.</p> </note> <p>For deleted stacks, <code>DescribeStackResources</code> returns resource information for up to 90 days after the stack has been deleted.</p> <p>You must specify either <code>StackName</code> or <code>PhysicalResourceId</code>, but not both. In addition, you can specify <code>LogicalResourceId</code> to filter the returned result. For more information about resources, the <code>LogicalResourceId</code> and <code>PhysicalResourceId</code>, go to the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/">AWS CloudFormation User Guide</a>.</p> <note> <p>A <code>ValidationError</code> is returned if you specify both <code>StackName</code> and <code>PhysicalResourceId</code> in the same request.</p> </note>', 'DescribeStackSet' => '<p>Returns the description of the specified stack set. </p>', 'DescribeStackSetOperation' => '<p>Returns the description of the specified stack set operation. </p>', 'DescribeStacks' => '<p>Returns the description for the specified stack; if no stack name was specified, then it returns the description for all the stacks created.</p> <note> <p>If the stack does not exist, an <code>AmazonCloudFormationException</code> is returned.</p> </note>', 'DescribeType' => '<p>Returns detailed information about a type that has been registered.</p> <p>If you specify a <code>VersionId</code>, <code>DescribeType</code> returns information about that specific type version. Otherwise, it returns information about the default type version.</p>', 'DescribeTypeRegistration' => '<p>Returns information about a type\'s registration, including its current status and type and version identifiers.</p> <p>When you initiate a registration request using <code> <a>RegisterType</a> </code>, you can then use <code> <a>DescribeTypeRegistration</a> </code> to monitor the progress of that registration request.</p> <p>Once the registration request has completed, use <code> <a>DescribeType</a> </code> to return detailed informaiton about a type.</p>', 'DetectStackDrift' => '<p>Detects whether a stack\'s actual configuration differs, or has <i>drifted</i>, from it\'s expected configuration, as defined in the stack template and any values specified as template parameters. For each resource in the stack that supports drift detection, AWS CloudFormation compares the actual configuration of the resource with its expected template configuration. Only resource properties explicitly defined in the stack template are checked for drift. A stack is considered to have drifted if one or more of its resources differ from their expected template configurations. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p> <p>Use <code>DetectStackDrift</code> to detect drift on all supported resources for a given stack, or <a>DetectStackResourceDrift</a> to detect drift on individual resources.</p> <p>For a list of stack resources that currently support drift detection, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html">Resources that Support Drift Detection</a>.</p> <p> <code>DetectStackDrift</code> can take up to several minutes, depending on the number of resources contained within the stack. Use <a>DescribeStackDriftDetectionStatus</a> to monitor the progress of a detect stack drift operation. Once the drift detection operation has completed, use <a>DescribeStackResourceDrifts</a> to return drift information about the stack and its resources.</p> <p>When detecting drift on a stack, AWS CloudFormation does not detect drift on any nested stacks belonging to that stack. Perform <code>DetectStackDrift</code> directly on the nested stack itself.</p>', 'DetectStackResourceDrift' => '<p>Returns information about whether a resource\'s actual configuration differs, or has <i>drifted</i>, from it\'s expected configuration, as defined in the stack template and any values specified as template parameters. This information includes actual and expected property values for resources in which AWS CloudFormation detects drift. Only resource properties explicitly defined in the stack template are checked for drift. For more information about stack and resource drift, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p> <p>Use <code>DetectStackResourceDrift</code> to detect drift on individual resources, or <a>DetectStackDrift</a> to detect drift on all resources in a given stack that support drift detection.</p> <p>Resources that do not currently support drift detection cannot be checked. For a list of resources that support drift detection, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html">Resources that Support Drift Detection</a>.</p>', 'DetectStackSetDrift' => '<p>Detect drift on a stack set. When CloudFormation performs drift detection on a stack set, it performs drift detection on the stack associated with each stack instance in the stack set. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">How CloudFormation Performs Drift Detection on a Stack Set</a>.</p> <p> <code>DetectStackSetDrift</code> returns the <code>OperationId</code> of the stack set drift detection operation. Use this operation id with <code> <a>DescribeStackSetOperation</a> </code> to monitor the progress of the drift detection operation. The drift detection operation may take some time, depending on the number of stack instances included in the stack set, as well as the number of resources included in each stack.</p> <p>Once the operation has completed, use the following actions to return drift information:</p> <ul> <li> <p>Use <code> <a>DescribeStackSet</a> </code> to return detailed informaiton about the stack set, including detailed information about the last <i>completed</i> drift operation performed on the stack set. (Information about drift operations that are in progress is not included.)</p> </li> <li> <p>Use <code> <a>ListStackInstances</a> </code> to return a list of stack instances belonging to the stack set, including the drift status and last drift time checked of each instance.</p> </li> <li> <p>Use <code> <a>DescribeStackInstance</a> </code> to return detailed information about a specific stack instance, including its drift status and last drift time checked.</p> </li> </ul> <p>For more information on performing a drift detection operation on a stack set, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">Detecting Unmanaged Changes in Stack Sets</a>. </p> <p>You can only run a single drift detection operation on a given stack set at one time. </p> <p>To stop a drift detection stack set operation, use <code> <a>StopStackSetOperation</a> </code>.</p>', 'EstimateTemplateCost' => '<p>Returns the estimated monthly cost of a template. The return value is an AWS Simple Monthly Calculator URL with a query string that describes the resources required to run the template.</p>', 'ExecuteChangeSet' => '<p>Updates a stack using the input information that was provided when the specified change set was created. After the call successfully completes, AWS CloudFormation starts updating the stack. Use the <a>DescribeStacks</a> action to view the status of the update.</p> <p>When you execute a change set, AWS CloudFormation deletes all other change sets associated with the stack because they aren\'t valid for the updated stack.</p> <p>If a stack policy is associated with the stack, AWS CloudFormation enforces the policy during the update. You can\'t specify a temporary stack policy that overrides the current policy.</p>', 'GetStackPolicy' => '<p>Returns the stack policy for a specified stack. If a stack doesn\'t have a policy, a null value is returned.</p>', 'GetTemplate' => '<p>Returns the template body for a specified stack. You can get the template for running or deleted stacks.</p> <p>For deleted stacks, GetTemplate returns the template for up to 90 days after the stack has been deleted.</p> <note> <p> If the template does not exist, a <code>ValidationError</code> is returned. </p> </note>', 'GetTemplateSummary' => '<p>Returns information about a new or existing template. The <code>GetTemplateSummary</code> action is useful for viewing parameter information, such as default parameter values and parameter types, before you create or update a stack or stack set.</p> <p>You can use the <code>GetTemplateSummary</code> action when you submit a template, or you can get template information for a stack set, or a running or deleted stack.</p> <p>For deleted stacks, <code>GetTemplateSummary</code> returns the template information for up to 90 days after the stack has been deleted. If the template does not exist, a <code>ValidationError</code> is returned.</p>', 'ListChangeSets' => '<p>Returns the ID and status of each active change set for a stack. For example, AWS CloudFormation lists change sets that are in the <code>CREATE_IN_PROGRESS</code> or <code>CREATE_PENDING</code> state.</p>', 'ListExports' => '<p>Lists all exported output values in the account and Region in which you call this action. Use this action to see the exported output values that you can import into other stacks. To import values, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html"> <code>Fn::ImportValue</code> </a> function. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html"> AWS CloudFormation Export Stack Output Values</a>.</p>', 'ListImports' => '<p>Lists all stacks that are importing an exported output value. To modify or remove an exported output value, first use this action to see which stacks are using it. To see the exported output values in your account, see <a>ListExports</a>. </p> <p>For more information about importing an exported output value, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html"> <code>Fn::ImportValue</code> </a> function. </p>', 'ListStackInstances' => '<p>Returns summary information about stack instances that are associated with the specified stack set. You can filter for stack instances that are associated with a specific AWS account name or Region, or that have a specific status.</p>', 'ListStackResources' => '<p>Returns descriptions of all resources of the specified stack.</p> <p>For deleted stacks, ListStackResources returns resource information for up to 90 days after the stack has been deleted.</p>', 'ListStackSetOperationResults' => '<p>Returns summary information about the results of a stack set operation. </p>', 'ListStackSetOperations' => '<p>Returns summary information about operations performed on a stack set. </p>', 'ListStackSets' => '<p>Returns summary information about stack sets that are associated with the user.</p>', 'ListStacks' => '<p>Returns the summary information for stacks whose status matches the specified StackStatusFilter. Summary information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no StackStatusFilter is specified, summary information for all stacks is returned (including existing stacks and stacks that have been deleted).</p>', 'ListTypeRegistrations' => '<p>Returns a list of registration tokens for the specified type(s).</p>', 'ListTypeVersions' => '<p>Returns summary information about the versions of a type.</p>', 'ListTypes' => '<p>Returns summary information about types that have been registered with CloudFormation.</p>', 'RecordHandlerProgress' => '<p>Reports progress of a resource handler to CloudFormation.</p> <p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>. Do not use this API in your code.</p>', 'RegisterType' => '<p>Registers a type with the CloudFormation service. Registering a type makes it available for use in CloudFormation templates in your AWS account, and includes:</p> <ul> <li> <p>Validating the resource schema</p> </li> <li> <p>Determining which handlers have been specified for the resource</p> </li> <li> <p>Making the resource type available for use in your account</p> </li> </ul> <p>For more information on how to develop types and ready them for registeration, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-types.html">Creating Resource Providers</a> in the <i>CloudFormation CLI User Guide</i>.</p> <p>You can have a maximum of 50 resource type versions registered at a time. This maximum is per account and per region. Use <a href="AWSCloudFormation/latest/APIReference/API_DeregisterType.html">DeregisterType</a> to deregister specific resource type versions if necessary.</p> <p>Once you have initiated a registration request using <code> <a>RegisterType</a> </code>, you can use <code> <a>DescribeTypeRegistration</a> </code> to monitor the progress of the registration request.</p>', 'SetStackPolicy' => '<p>Sets a stack policy for a specified stack.</p>', 'SetTypeDefaultVersion' => '<p>Specify the default version of a type. The default version of a type will be used in CloudFormation operations.</p>', 'SignalResource' => '<p>Sends a signal to the specified resource with a success or failure status. You can use the SignalResource API in conjunction with a creation policy or update policy. AWS CloudFormation doesn\'t proceed with a stack creation or update until resources receive the required number of signals or the timeout period is exceeded. The SignalResource API is useful in cases where you want to send signals from anywhere other than an Amazon EC2 instance.</p>', 'StopStackSetOperation' => '<p>Stops an in-progress operation on a stack set and its associated stack instances. </p>', 'UpdateStack' => '<p>Updates a stack as specified in the template. After the call completes successfully, the stack update starts. You can check the status of the stack via the <a>DescribeStacks</a> action.</p> <p>To get a copy of the template for an existing stack, you can use the <a>GetTemplate</a> action.</p> <p>For more information about creating an update template, updating a stack, and monitoring the progress of the update, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html">Updating a Stack</a>.</p>', 'UpdateStackInstances' => '<p>Updates the parameter values for stack instances for the specified accounts, within the specified Regions. A stack instance refers to a stack in a specific account and Region. </p> <p>You can only update stack instances in Regions and accounts where they already exist; to create additional stack instances, use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackInstances.html">CreateStackInstances</a>. </p> <p>During stack set updates, any parameters overridden for a stack instance are not updated, but retain their overridden value.</p> <p>You can only update the parameter <i>values</i> that are specified in the stack set; to add or delete a parameter itself, use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet</a> to update the stack set template. If you add a parameter to a template, before you can override the parameter value specified in the stack set you must first use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet</a> to update all stack instances with the updated template and parameter value specified in the stack set. Once a stack instance has been updated with the new parameter, you can then override the parameter value using <code>UpdateStackInstances</code>.</p>', 'UpdateStackSet' => '<p>Updates the stack set, and associated stack instances in the specified accounts and Regions.</p> <p>Even if the stack set operation created by updating the stack set fails (completely or partially, below or above a specified failure tolerance), the stack set is updated with your changes. Subsequent <a>CreateStackInstances</a> calls on the specified stack set use the updated stack set.</p>', 'UpdateTerminationProtection' => '<p>Updates termination protection for the specified stack. If a user attempts to delete a stack with termination protection enabled, the operation fails and the stack remains unchanged. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html">Protecting a Stack From Being Deleted</a> in the <i>AWS CloudFormation User Guide</i>.</p> <p> For <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested stacks</a>, termination protection is set on the root stack and cannot be changed directly on the nested stack.</p>', 'ValidateTemplate' => '<p>Validates a specified template. AWS CloudFormation first checks if the template is valid JSON. If it isn\'t, AWS CloudFormation checks if the template is valid YAML. If both these checks fail, AWS CloudFormation returns a template validation error.</p>', ], 'shapes' => [ 'Account' => [ 'base' => NULL, 'refs' => [ 'AccountList$member' => NULL, 'DescribeStackInstanceInput$StackInstanceAccount' => '<p>The ID of an AWS account that\'s associated with this stack instance.</p>', 'ListStackInstancesInput$StackInstanceAccount' => '<p>The name of the AWS account that you want to list stack instances for.</p>', 'StackInstance$Account' => '<p>[<code>Self-managed</code> permissions] The name of the AWS account that the stack instance is associated with.</p>', 'StackInstanceSummary$Account' => '<p>[<code>Self-managed</code> permissions] The name of the AWS account that the stack instance is associated with.</p>', 'StackSetOperationResultSummary$Account' => '<p>[<code>Self-managed</code> permissions] The name of the AWS account for this operation result.</p>', ], ], 'AccountGateResult' => [ 'base' => '<p>Structure that contains the results of the account gate function which AWS CloudFormation invokes, if present, before proceeding with a stack set operation in an account and Region.</p> <p>For each account and Region, AWS CloudFormation lets you specify a Lamdba function that encapsulates any requirements that must be met before CloudFormation can proceed with a stack set operation in that account and Region. CloudFormation invokes the function each time a stack set operation is requested for that account and Region; if the function returns <code>FAILED</code>, CloudFormation cancels the operation in that account and Region, and sets the stack set operation result status for that account and Region to <code>FAILED</code>. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-account-gating.html">Configuring a target account gate</a>.</p>', 'refs' => [ 'StackSetOperationResultSummary$AccountGateResult' => '<p>The results of the account gate function AWS CloudFormation invokes, if present, before proceeding with stack set operations in an account</p>', ], ], 'AccountGateStatus' => [ 'base' => NULL, 'refs' => [ 'AccountGateResult$Status' => '<p>The status of the account gate function.</p> <ul> <li> <p> <code>SUCCEEDED</code>: The account gate function has determined that the account and Region passes any requirements for a stack set operation to occur. AWS CloudFormation proceeds with the stack operation in that account and Region. </p> </li> <li> <p> <code>FAILED</code>: The account gate function has determined that the account and Region does not meet the requirements for a stack set operation to occur. AWS CloudFormation cancels the stack set operation in that account and Region, and sets the stack set operation result status for that account and Region to <code>FAILED</code>. </p> </li> <li> <p> <code>SKIPPED</code>: AWS CloudFormation has skipped calling the account gate function for this account and Region, for one of the following reasons:</p> <ul> <li> <p>An account gate function has not been specified for the account and Region. AWS CloudFormation proceeds with the stack set operation in this account and Region.</p> </li> <li> <p>The <code>AWSCloudFormationStackSetExecutionRole</code> of the stack set adminstration account lacks permissions to invoke the function. AWS CloudFormation proceeds with the stack set operation in this account and Region.</p> </li> <li> <p>Either no action is necessary, or no action is possible, on the stack. AWS CloudFormation skips the stack set operation in this account and Region.</p> </li> </ul> </li> </ul>', ], ], 'AccountGateStatusReason' => [ 'base' => NULL, 'refs' => [ 'AccountGateResult$StatusReason' => '<p>The reason for the account gate status assigned to this account and Region for the stack set operation.</p>', ], ], 'AccountLimit' => [ 'base' => '<p>The AccountLimit data type. </p> <p>CloudFormation has the following limits per account:</p> <ul> <li> <p>Number of concurrent resources</p> </li> <li> <p>Number of stacks</p> </li> <li> <p>Number of stack outputs</p> </li> </ul> <p>For more information about these account limits, and other CloudFormation limits, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">AWS CloudFormation Limits</a> in the <i>AWS CloudFormation User Guide</i>.</p>', 'refs' => [ 'AccountLimitList$member' => NULL, ], ], 'AccountLimitList' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountLimitsOutput$AccountLimits' => '<p>An account limit structure that contain a list of AWS CloudFormation account limits and their values.</p>', ], ], 'AccountList' => [ 'base' => NULL, 'refs' => [ 'CreateStackInstancesInput$Accounts' => '<p>[<code>Self-managed</code> permissions] The names of one or more AWS accounts that you want to create stack instances in the specified Region(s) for.</p> <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not both.</p>', 'DeleteStackInstancesInput$Accounts' => '<p>[<code>Self-managed</code> permissions] The names of the AWS accounts that you want to delete stack instances for.</p> <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not both.</p>', 'DeploymentTargets$Accounts' => '<p>The names of one or more AWS accounts for which you want to deploy stack set updates.</p>', 'UpdateStackInstancesInput$Accounts' => '<p>[<code>Self-managed</code> permissions] The names of one or more AWS accounts for which you want to update parameter values for stack instances. The overridden parameter values will be applied to all stack instances in the specified accounts and Regions.</p> <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not both.</p>', 'UpdateStackSetInput$Accounts' => '<p>[<code>Self-managed</code> permissions] The accounts in which to update associated stack instances. If you specify accounts, you must also specify the Regions in which to update stack set instances.</p> <p>To update <i>all</i> the stack instances associated with this stack set, do not specify the <code>Accounts</code> or <code>Regions</code> properties.</p> <p>If the stack set update includes changes to the template (that is, if the <code>TemplateBody</code> or <code>TemplateURL</code> properties are specified), or the <code>Parameters</code> property, AWS CloudFormation marks all stack instances with a status of <code>OUTDATED</code> prior to updating the stack instances in the specified accounts and Regions. If the stack set update does not include changes to the template or parameters, AWS CloudFormation updates the stack instances in the specified accounts and Regions, while leaving all other stack instances with their existing stack instance status. </p>', ], ], 'AllowedValue' => [ 'base' => NULL, 'refs' => [ 'AllowedValues$member' => NULL, ], ], 'AllowedValues' => [ 'base' => NULL, 'refs' => [ 'ParameterConstraints$AllowedValues' => '<p>A list of values that are permitted for a parameter.</p>', ], ], 'AlreadyExistsException' => [ 'base' => '<p>The resource with the name requested already exists.</p>', 'refs' => [], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'RollbackTrigger$Arn' => '<p>The Amazon Resource Name (ARN) of the rollback trigger.</p> <p>If a specified trigger is missing, the entire stack operation fails and is rolled back. </p>', ], ], 'AutoDeployment' => [ 'base' => '<p>[<code>Service-managed</code> permissions] Describes whether StackSets automatically deploys to AWS Organizations accounts that are added to a target organization or organizational unit (OU).</p>', 'refs' => [ 'CreateStackSetInput$AutoDeployment' => '<p>Describes whether StackSets automatically deploys to AWS Organizations accounts that are added to the target organization or organizational unit (OU). Specify only if <code>PermissionModel</code> is <code>SERVICE_MANAGED</code>.</p>', 'StackSet$AutoDeployment' => '<p>[<code>Service-managed</code> permissions] Describes whether StackSets automatically deploys to AWS Organizations accounts that are added to a target organization or organizational unit (OU).</p>', 'StackSetSummary$AutoDeployment' => '<p>[<code>Service-managed</code> permissions] Describes whether StackSets automatically deploys to AWS Organizations accounts that are added to a target organizational unit (OU).</p>', 'UpdateStackSetInput$AutoDeployment' => '<p>[<code>Service-managed</code> permissions] Describes whether StackSets automatically deploys to AWS Organizations accounts that are added to a target organization or organizational unit (OU).</p> <p>If you specify <code>AutoDeployment</code>, do not specify <code>DeploymentTargets</code> or <code>Regions</code>.</p>', ], ], 'AutoDeploymentNullable' => [ 'base' => NULL, 'refs' => [ 'AutoDeployment$Enabled' => '<p>If set to <code>true</code>, StackSets automatically deploys additional stack instances to AWS Organizations accounts that are added to a target organization or organizational unit (OU) in the specified Regions. If an account is removed from a target organization or OU, StackSets deletes stack instances from the account in the specified Regions.</p>', ], ], 'BoxedInteger' => [ 'base' => NULL, 'refs' => [ 'DescribeStackDriftDetectionStatusOutput$DriftedStackResourceCount' => '<p>Total number of stack resources that have drifted. This is NULL until the drift detection operation reaches a status of <code>DETECTION_COMPLETE</code>. This value will be 0 for stacks whose drift status is <code>IN_SYNC</code>.</p>', ], ], 'BoxedMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeStackResourceDriftsInput$MaxResults' => '<p>The maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code> request parameter to get the next set of results.</p>', ], ], 'CFNRegistryException' => [ 'base' => '<p>An error occurred during a CloudFormation registry operation.</p>', 'refs' => [], ], 'CancelUpdateStackInput' => [ 'base' => '<p>The input for the <a>CancelUpdateStack</a> action.</p>', 'refs' => [], ], 'Capabilities' => [ 'base' => NULL, 'refs' => [ 'CreateChangeSetInput$Capabilities' => '<p>In some cases, you must explicitly acknowledge that your stack template contains certain capabilities in order for AWS CloudFormation to create the stack.</p> <ul> <li> <p> <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code> </p> <p>Some stack templates might include resources that can affect permissions in your AWS account; for example, by creating new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly acknowledge this by specifying one of these capabilities.</p> <p>The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code> capability.</p> <ul> <li> <p>If you have IAM resources, you can specify either capability. </p> </li> <li> <p>If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>. </p> </li> <li> <p>If you don\'t specify either of these capabilities, AWS CloudFormation returns an <code>InsufficientCapabilities</code> error.</p> </li> </ul> <p>If your stack template contains these resources, we recommend that you review all permissions associated with them and edit their permissions if necessary.</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html"> AWS::IAM::AccessKey</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html"> AWS::IAM::Group</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html"> AWS::IAM::Policy</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html"> AWS::IAM::Role</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html"> AWS::IAM::User</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a> </p> </li> </ul> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM Resources in AWS CloudFormation Templates</a>.</p> </li> <li> <p> <code>CAPABILITY_AUTO_EXPAND</code> </p> <p>Some template contain macros. Macros perform custom processing on templates; this can include simple actions like find-and-replace operations, all the way to extensive transformations of entire templates. Because of this, users typically create a change set from the processed template, so that they can review the changes resulting from the macros before actually creating the stack. If your stack template contains one or more macros, and you choose to create a stack directly from the processed template, without first reviewing the resulting changes in a change set, you must acknowledge this capability. This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include</a> and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.</p> <note> <p>This capacity does not apply to creating change sets, and specifying it when creating change sets has no effect.</p> <p>Also, change sets do not currently support nested stacks. If you want to create a stack from a stack template that contains macros <i>and</i> nested stacks, you must create or update the stack directly from the template using the <a>CreateStack</a> or <a>UpdateStack</a> action, and specifying this capability.</p> </note> <p>For more information on macros, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS CloudFormation Macros to Perform Custom Processing on Templates</a>.</p> </li> </ul>', 'CreateStackInput$Capabilities' => '<p>In some cases, you must explicitly acknowledge that your stack template contains certain capabilities in order for AWS CloudFormation to create the stack.</p> <ul> <li> <p> <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code> </p> <p>Some stack templates might include resources that can affect permissions in your AWS account; for example, by creating new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly acknowledge this by specifying one of these capabilities.</p> <p>The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code> capability.</p> <ul> <li> <p>If you have IAM resources, you can specify either capability. </p> </li> <li> <p>If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>. </p> </li> <li> <p>If you don\'t specify either of these capabilities, AWS CloudFormation returns an <code>InsufficientCapabilities</code> error.</p> </li> </ul> <p>If your stack template contains these resources, we recommend that you review all permissions associated with them and edit their permissions if necessary.</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html"> AWS::IAM::AccessKey</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html"> AWS::IAM::Group</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html"> AWS::IAM::Policy</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html"> AWS::IAM::Role</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html"> AWS::IAM::User</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a> </p> </li> </ul> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM Resources in AWS CloudFormation Templates</a>.</p> </li> <li> <p> <code>CAPABILITY_AUTO_EXPAND</code> </p> <p>Some template contain macros. Macros perform custom processing on templates; this can include simple actions like find-and-replace operations, all the way to extensive transformations of entire templates. Because of this, users typically create a change set from the processed template, so that they can review the changes resulting from the macros before actually creating the stack. If your stack template contains one or more macros, and you choose to create a stack directly from the processed template, without first reviewing the resulting changes in a change set, you must acknowledge this capability. This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include</a> and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.</p> <p>Change sets do not currently support nested stacks. If you want to create a stack from a stack template that contains macros <i>and</i> nested stacks, you must create the stack directly from the template using this capability.</p> <important> <p>You should only create stacks directly from a stack template that contains macros if you know what processing the macro performs.</p> <p>Each macro relies on an underlying Lambda service function for processing stack templates. Be aware that the Lambda function owner can update the function operation without AWS CloudFormation being notified.</p> </important> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS CloudFormation Macros to Perform Custom Processing on Templates</a>.</p> </li> </ul>', 'CreateStackSetInput$Capabilities' => '<p>In some cases, you must explicitly acknowledge that your stack set template contains certain capabilities in order for AWS CloudFormation to create the stack set and related stack instances.</p> <ul> <li> <p> <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code> </p> <p>Some stack templates might include resources that can affect permissions in your AWS account; for example, by creating new AWS Identity and Access Management (IAM) users. For those stack sets, you must explicitly acknowledge this by specifying one of these capabilities.</p> <p>The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code> capability.</p> <ul> <li> <p>If you have IAM resources, you can specify either capability. </p> </li> <li> <p>If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>. </p> </li> <li> <p>If you don\'t specify either of these capabilities, AWS CloudFormation returns an <code>InsufficientCapabilities</code> error.</p> </li> </ul> <p>If your stack template contains these resources, we recommend that you review all permissions associated with them and edit their permissions if necessary.</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html"> AWS::IAM::AccessKey</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html"> AWS::IAM::Group</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html"> AWS::IAM::Policy</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html"> AWS::IAM::Role</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html"> AWS::IAM::User</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a> </p> </li> </ul> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM Resources in AWS CloudFormation Templates</a>.</p> </li> <li> <p> <code>CAPABILITY_AUTO_EXPAND</code> </p> <p>Some templates contain macros. If your stack template contains one or more macros, and you choose to create a stack directly from the processed template, without first reviewing the resulting changes in a change set, you must acknowledge this capability. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS CloudFormation Macros to Perform Custom Processing on Templates</a>.</p> <note> <p>Stack sets do not currently support macros in stack templates. (This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include</a> and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.) Even if you specify this capability, if you include a macro in your template the stack set operation will fail.</p> </note> </li> </ul>', 'DescribeChangeSetOutput$Capabilities' => '<p>If you execute the change set, the list of capabilities that were explicitly acknowledged when the change set was created.</p>', 'GetTemplateSummaryOutput$Capabilities' => '<p>The capabilities found within the template. If your template contains IAM resources, you must specify the CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the <a>CreateStack</a> or <a>UpdateStack</a> actions with your template; otherwise, those actions return an InsufficientCapabilities error.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM Resources in AWS CloudFormation Templates</a>.</p>', 'Stack$Capabilities' => '<p>The capabilities allowed in the stack.</p>', 'StackSet$Capabilities' => '<p>The capabilities that are allowed in the stack set. Some stack set templates might include resources that can affect permissions in your AWS account—for example, by creating new AWS Identity and Access Management (IAM) users. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM Resources in AWS CloudFormation Templates.</a> </p>', 'UpdateStackInput$Capabilities' => '<p>In some cases, you must explicitly acknowledge that your stack template contains certain capabilities in order for AWS CloudFormation to update the stack.</p> <ul> <li> <p> <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code> </p> <p>Some stack templates might include resources that can affect permissions in your AWS account; for example, by creating new AWS Identity and Access Management (IAM) users. For those stacks, you must explicitly acknowledge this by specifying one of these capabilities.</p> <p>The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code> capability.</p> <ul> <li> <p>If you have IAM resources, you can specify either capability. </p> </li> <li> <p>If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>. </p> </li> <li> <p>If you don\'t specify either of these capabilities, AWS CloudFormation returns an <code>InsufficientCapabilities</code> error.</p> </li> </ul> <p>If your stack template contains these resources, we recommend that you review all permissions associated with them and edit their permissions if necessary.</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html"> AWS::IAM::AccessKey</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html"> AWS::IAM::Group</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html"> AWS::IAM::Policy</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html"> AWS::IAM::Role</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html"> AWS::IAM::User</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a> </p> </li> </ul> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM Resources in AWS CloudFormation Templates</a>.</p> </li> <li> <p> <code>CAPABILITY_AUTO_EXPAND</code> </p> <p>Some template contain macros. Macros perform custom processing on templates; this can include simple actions like find-and-replace operations, all the way to extensive transformations of entire templates. Because of this, users typically create a change set from the processed template, so that they can review the changes resulting from the macros before actually updating the stack. If your stack template contains one or more macros, and you choose to update a stack directly from the processed template, without first reviewing the resulting changes in a change set, you must acknowledge this capability. This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include</a> and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.</p> <p>Change sets do not currently support nested stacks. If you want to update a stack from a stack template that contains macros <i>and</i> nested stacks, you must update the stack directly from the template using this capability.</p> <important> <p>You should only update stacks directly from a stack template that contains macros if you know what processing the macro performs.</p> <p>Each macro relies on an underlying Lambda service function for processing stack templates. Be aware that the Lambda function owner can update the function operation without AWS CloudFormation being notified.</p> </important> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS CloudFormation Macros to Perform Custom Processing on Templates</a>.</p> </li> </ul>', 'UpdateStackSetInput$Capabilities' => '<p>In some cases, you must explicitly acknowledge that your stack template contains certain capabilities in order for AWS CloudFormation to update the stack set and its associated stack instances.</p> <ul> <li> <p> <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code> </p> <p>Some stack templates might include resources that can affect permissions in your AWS account; for example, by creating new AWS Identity and Access Management (IAM) users. For those stacks sets, you must explicitly acknowledge this by specifying one of these capabilities.</p> <p>The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or <code>CAPABILITY_NAMED_IAM</code> capability.</p> <ul> <li> <p>If you have IAM resources, you can specify either capability. </p> </li> <li> <p>If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>. </p> </li> <li> <p>If you don\'t specify either of these capabilities, AWS CloudFormation returns an <code>InsufficientCapabilities</code> error.</p> </li> </ul> <p>If your stack template contains these resources, we recommend that you review all permissions associated with them and edit their permissions if necessary.</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html"> AWS::IAM::AccessKey</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html"> AWS::IAM::Group</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"> AWS::IAM::InstanceProfile</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html"> AWS::IAM::Policy</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html"> AWS::IAM::Role</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html"> AWS::IAM::User</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"> AWS::IAM::UserToGroupAddition</a> </p> </li> </ul> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM Resources in AWS CloudFormation Templates</a>.</p> </li> <li> <p> <code>CAPABILITY_AUTO_EXPAND</code> </p> <p>Some templates contain macros. If your stack template contains one or more macros, and you choose to update a stack directly from the processed template, without first reviewing the resulting changes in a change set, you must acknowledge this capability. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS CloudFormation Macros to Perform Custom Processing on Templates</a>.</p> <important> <p>Stack sets do not currently support macros in stack templates. (This includes the <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html">AWS::Include</a> and <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html">AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.) Even if you specify this capability, if you include a macro in your template the stack set operation will fail.</p> </important> </li> </ul>', 'ValidateTemplateOutput$Capabilities' => '<p>The capabilities found within the template. If your template contains IAM resources, you must specify the CAPABILITY_IAM or CAPABILITY_NAMED_IAM value for this parameter when you use the <a>CreateStack</a> or <a>UpdateStack</a> actions with your template; otherwise, those actions return an InsufficientCapabilities error.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities">Acknowledging IAM Resources in AWS CloudFormation Templates</a>.</p>', ], ], 'CapabilitiesReason' => [ 'base' => NULL, 'refs' => [ 'GetTemplateSummaryOutput$CapabilitiesReason' => '<p>The list of resources that generated the values in the <code>Capabilities</code> response element.</p>', 'ValidateTemplateOutput$CapabilitiesReason' => '<p>The list of resources that generated the values in the <code>Capabilities</code> response element.</p>', ], ], 'Capability' => [ 'base' => NULL, 'refs' => [ 'Capabilities$member' => NULL, ], ], 'CausingEntity' => [ 'base' => NULL, 'refs' => [ 'ResourceChangeDetail$CausingEntity' => '<p>The identity of the entity that triggered this change. This entity is a member of the group that is specified by the <code>ChangeSource</code> field. For example, if you modified the value of the <code>KeyPairName</code> parameter, the <code>CausingEntity</code> is the name of the parameter (<code>KeyPairName</code>).</p> <p>If the <code>ChangeSource</code> value is <code>DirectModification</code>, no value is given for <code>CausingEntity</code>.</p>', ], ], 'Change' => [ 'base' => '<p>The <code>Change</code> structure describes the changes AWS CloudFormation will perform if you execute the change set.</p>', 'refs' => [ 'Changes$member' => NULL, ], ], 'ChangeAction' => [ 'base' => NULL, 'refs' => [ 'ResourceChange$Action' => '<p>The action that AWS CloudFormation takes on the resource, such as <code>Add</code> (adds a new resource), <code>Modify</code> (changes a resource), or <code>Remove</code> (deletes a resource).</p>', ], ], 'ChangeSetId' => [ 'base' => NULL, 'refs' => [ 'ChangeSetSummary$ChangeSetId' => '<p>The ID of the change set.</p>', 'CreateChangeSetOutput$Id' => '<p>The Amazon Resource Name (ARN) of the change set.</p>', 'DescribeChangeSetOutput$ChangeSetId' => '<p>The ARN of the change set.</p>', 'Stack$ChangeSetId' => '<p>The unique ID of the change set.</p>', ], ], 'ChangeSetName' => [ 'base' => NULL, 'refs' => [ 'ChangeSetSummary$ChangeSetName' => '<p>The name of the change set.</p>', 'CreateChangeSetInput$ChangeSetName' => '<p>The name of the change set. The name must be unique among all change sets that are associated with the specified stack.</p> <p>A change set name can contain only alphanumeric, case sensitive characters and hyphens. It must start with an alphabetic character and cannot exceed 128 characters.</p>', 'DescribeChangeSetOutput$ChangeSetName' => '<p>The name of the change set.</p>', ], ], 'ChangeSetNameOrId' => [ 'base' => NULL, 'refs' => [ 'DeleteChangeSetInput$ChangeSetName' => '<p>The name or Amazon Resource Name (ARN) of the change set that you want to delete.</p>', 'DescribeChangeSetInput$ChangeSetName' => '<p>The name or Amazon Resource Name (ARN) of the change set that you want to describe.</p>', 'ExecuteChangeSetInput$ChangeSetName' => '<p>The name or ARN of the change set that you want use to update the specified stack.</p>', 'GetTemplateInput$ChangeSetName' => '<p>The name or Amazon Resource Name (ARN) of a change set for which AWS CloudFormation returns the associated template. If you specify a name, you must also specify the <code>StackName</code>.</p>', ], ], 'ChangeSetNotFoundException' => [ 'base' => '<p>The specified change set name or ID doesn\'t exit. To view valid change sets for a stack, use the <code>ListChangeSets</code> action.</p>', 'refs' => [], ], 'ChangeSetStatus' => [ 'base' => NULL, 'refs' => [ 'ChangeSetSummary$Status' => '<p>The state of the change set, such as <code>CREATE_IN_PROGRESS</code>, <code>CREATE_COMPLETE</code>, or <code>FAILED</code>.</p>', 'DescribeChangeSetOutput$Status' => '<p>The current status of the change set, such as <code>CREATE_IN_PROGRESS</code>, <code>CREATE_COMPLETE</code>, or <code>FAILED</code>.</p>', ], ], 'ChangeSetStatusReason' => [ 'base' => NULL, 'refs' => [ 'ChangeSetSummary$StatusReason' => '<p>A description of the change set\'s status. For example, if your change set is in the <code>FAILED</code> state, AWS CloudFormation shows the error message.</p>', 'DescribeChangeSetOutput$StatusReason' => '<p>A description of the change set\'s status. For example, if your attempt to create a change set failed, AWS CloudFormation shows the error message.</p>', ], ], 'ChangeSetSummaries' => [ 'base' => NULL, 'refs' => [ 'ListChangeSetsOutput$Summaries' => '<p>A list of <code>ChangeSetSummary</code> structures that provides the ID and status of each change set for the specified stack.</p>', ], ], 'ChangeSetSummary' => [ 'base' => '<p>The <code>ChangeSetSummary</code> structure describes a change set, its status, and the stack with which it\'s associated.</p>', 'refs' => [ 'ChangeSetSummaries$member' => NULL, ], ], 'ChangeSetType' => [ 'base' => NULL, 'refs' => [ 'CreateChangeSetInput$ChangeSetType' => '<p>The type of change set operation. To create a change set for a new stack, specify <code>CREATE</code>. To create a change set for an existing stack, specify <code>UPDATE</code>. To create a change set for an import operation, specify <code>IMPORT</code>.</p> <p>If you create a change set for a new stack, AWS Cloudformation creates a stack with a unique stack ID, but no template or resources. The stack will be in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-describing-stacks.html#d0e11995"> <code>REVIEW_IN_PROGRESS</code> </a> state until you execute the change set.</p> <p>By default, AWS CloudFormation specifies <code>UPDATE</code>. You can\'t use the <code>UPDATE</code> type to create a change set for a new stack or the <code>CREATE</code> type to create a change set for an existing stack.</p>', ], ], 'ChangeSource' => [ 'base' => NULL, 'refs' => [ 'ResourceChangeDetail$ChangeSource' => '<p>The group to which the <code>CausingEntity</code> value belongs. There are five entity groups:</p> <ul> <li> <p> <code>ResourceReference</code> entities are <code>Ref</code> intrinsic functions that refer to resources in the template, such as <code>{ "Ref" : "MyEC2InstanceResource" }</code>.</p> </li> <li> <p> <code>ParameterReference</code> entities are <code>Ref</code> intrinsic functions that get template parameter values, such as <code>{ "Ref" : "MyPasswordParameter" }</code>.</p> </li> <li> <p> <code>ResourceAttribute</code> entities are <code>Fn::GetAtt</code> intrinsic functions that get resource attribute values, such as <code>{ "Fn::GetAtt" : [ "MyEC2InstanceResource", "PublicDnsName" ] }</code>.</p> </li> <li> <p> <code>DirectModification</code> entities are changes that are made directly to the template.</p> </li> <li> <p> <code>Automatic</code> entities are <code>AWS::CloudFormation::Stack</code> resource types, which are also known as nested stacks. If you made no changes to the <code>AWS::CloudFormation::Stack</code> resource, AWS CloudFormation sets the <code>ChangeSource</code> to <code>Automatic</code> because the nested stack\'s template might have changed. Changes to a nested stack\'s template aren\'t visible to AWS CloudFormation until you run an update on the parent stack.</p> </li> </ul>', ], ], 'ChangeType' => [ 'base' => NULL, 'refs' => [ 'Change$Type' => '<p>The type of entity that AWS CloudFormation changes. Currently, the only entity type is <code>Resource</code>.</p>', ], ], 'Changes' => [ 'base' => NULL, 'refs' => [ 'DescribeChangeSetOutput$Changes' => '<p>A list of <code>Change</code> structures that describes the resources AWS CloudFormation changes if you execute the change set.</p>', ], ], 'ClientRequestToken' => [ 'base' => NULL, 'refs' => [ 'CancelUpdateStackInput$ClientRequestToken' => '<p>A unique identifier for this <code>CancelUpdateStack</code> request. Specify this token if you plan to retry requests so that AWS CloudFormation knows that you\'re not attempting to cancel an update on a stack with the same name. You might retry <code>CancelUpdateStack</code> requests to ensure that AWS CloudFormation successfully received them.</p>', 'ContinueUpdateRollbackInput$ClientRequestToken' => '<p>A unique identifier for this <code>ContinueUpdateRollback</code> request. Specify this token if you plan to retry requests so that AWS CloudFormation knows that you\'re not attempting to continue the rollback to a stack with the same name. You might retry <code>ContinueUpdateRollback</code> requests to ensure that AWS CloudFormation successfully received them.</p>', 'CreateStackInput$ClientRequestToken' => '<p>A unique identifier for this <code>CreateStack</code> request. Specify this token if you plan to retry requests so that AWS CloudFormation knows that you\'re not attempting to create a stack with the same name. You might retry <code>CreateStack</code> requests to ensure that AWS CloudFormation successfully received them.</p> <p>All events triggered by a given stack operation are assigned the same client request token, which you can use to track operations. For example, if you execute a <code>CreateStack</code> operation with the token <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have <code>ClientRequestToken</code> set as <code>token1</code>.</p> <p>In the console, stack operations display the client request token on the Events tab. Stack operations that are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps you easily identify the stack operation . For example, if you create a stack using the console, each stack event would be assigned the same token in the following format: <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>. </p>', 'CreateStackInstancesInput$OperationId' => '<p>The unique identifier for this stack set operation. </p> <p>The operation ID also functions as an idempotency token, to ensure that AWS CloudFormation performs the stack set operation only once, even if you retry the request multiple times. You might retry stack set operation requests to ensure that AWS CloudFormation successfully received them.</p> <p>If you don\'t specify an operation ID, the SDK generates one automatically. </p> <p>Repeating this stack set operation with a new operation ID retries all stack instances whose status is <code>OUTDATED</code>. </p>', 'CreateStackInstancesOutput$OperationId' => '<p>The unique identifier for this stack set operation.</p>', 'CreateStackSetInput$ClientRequestToken' => '<p>A unique identifier for this <code>CreateStackSet</code> request. Specify this token if you plan to retry requests so that AWS CloudFormation knows that you\'re not attempting to create another stack set with the same name. You might retry <code>CreateStackSet</code> requests to ensure that AWS CloudFormation successfully received them.</p> <p>If you don\'t specify an operation ID, the SDK generates one automatically. </p>', 'DeleteStackInput$ClientRequestToken' => '<p>A unique identifier for this <code>DeleteStack</code> request. Specify this token if you plan to retry requests so that AWS CloudFormation knows that you\'re not attempting to delete a stack with the same name. You might retry <code>DeleteStack</code> requests to ensure that AWS CloudFormation successfully received them.</p> <p>All events triggered by a given stack operation are assigned the same client request token, which you can use to track operations. For example, if you execute a <code>CreateStack</code> operation with the token <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have <code>ClientRequestToken</code> set as <code>token1</code>.</p> <p>In the console, stack operations display the client request token on the Events tab. Stack operations that are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps you easily identify the stack operation . For example, if you create a stack using the console, each stack event would be assigned the same token in the following format: <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>. </p>', 'DeleteStackInstancesInput$OperationId' => '<p>The unique identifier for this stack set operation. </p> <p>If you don\'t specify an operation ID, the SDK generates one automatically. </p> <p>The operation ID also functions as an idempotency token, to ensure that AWS CloudFormation performs the stack set operation only once, even if you retry the request multiple times. You can retry stack set operation requests to ensure that AWS CloudFormation successfully received them.</p> <p>Repeating this stack set operation with a new operation ID retries all stack instances whose status is <code>OUTDATED</code>. </p>', 'DeleteStackInstancesOutput$OperationId' => '<p>The unique identifier for this stack set operation.</p>', 'DescribeStackSetOperationInput$OperationId' => '<p>The unique ID of the stack set operation. </p>', 'DetectStackSetDriftInput$OperationId' => '<p> <i>The ID of the stack set operation.</i> </p>', 'DetectStackSetDriftOutput$OperationId' => '<p>The ID of the drift detection stack set operation. </p> <p>you can use this operation id with <code> <a>DescribeStackSetOperation</a> </code> to monitor the progress of the drift detection operation. </p>', 'ExecuteChangeSetInput$ClientRequestToken' => '<p>A unique identifier for this <code>ExecuteChangeSet</code> request. Specify this token if you plan to retry requests so that AWS CloudFormation knows that you\'re not attempting to execute a change set to update a stack with the same name. You might retry <code>ExecuteChangeSet</code> requests to ensure that AWS CloudFormation successfully received them.</p>', 'ListStackSetOperationResultsInput$OperationId' => '<p>The ID of the stack set operation.</p>', 'RecordHandlerProgressInput$ClientRequestToken' => '<p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>', 'StackEvent$ClientRequestToken' => '<p>The token passed to the operation that generated this event.</p> <p>All events triggered by a given stack operation are assigned the same client request token, which you can use to track operations. For example, if you execute a <code>CreateStack</code> operation with the token <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have <code>ClientRequestToken</code> set as <code>token1</code>.</p> <p>In the console, stack operations display the client request token on the Events tab. Stack operations that are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps you easily identify the stack operation . For example, if you create a stack using the console, each stack event would be assigned the same token in the following format: <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>. </p>', 'StackSetOperation$OperationId' => '<p>The unique ID of a stack set operation.</p>', 'StackSetOperationSummary$OperationId' => '<p>The unique ID of the stack set operation.</p>', 'StopStackSetOperationInput$OperationId' => '<p>The ID of the stack operation. </p>', 'UpdateStackInput$ClientRequestToken' => '<p>A unique identifier for this <code>UpdateStack</code> request. Specify this token if you plan to retry requests so that AWS CloudFormation knows that you\'re not attempting to update a stack with the same name. You might retry <code>UpdateStack</code> requests to ensure that AWS CloudFormation successfully received them.</p> <p>All events triggered by a given stack operation are assigned the same client request token, which you can use to track operations. For example, if you execute a <code>CreateStack</code> operation with the token <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have <code>ClientRequestToken</code> set as <code>token1</code>.</p> <p>In the console, stack operations display the client request token on the Events tab. Stack operations that are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps you easily identify the stack operation . For example, if you create a stack using the console, each stack event would be assigned the same token in the following format: <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>. </p>', 'UpdateStackInstancesInput$OperationId' => '<p>The unique identifier for this stack set operation. </p> <p>The operation ID also functions as an idempotency token, to ensure that AWS CloudFormation performs the stack set operation only once, even if you retry the request multiple times. You might retry stack set operation requests to ensure that AWS CloudFormation successfully received them.</p> <p>If you don\'t specify an operation ID, the SDK generates one automatically. </p>', 'UpdateStackInstancesOutput$OperationId' => '<p>The unique identifier for this stack set operation. </p>', 'UpdateStackSetInput$OperationId' => '<p>The unique ID for this stack set operation. </p> <p>The operation ID also functions as an idempotency token, to ensure that AWS CloudFormation performs the stack set operation only once, even if you retry the request multiple times. You might retry stack set operation requests to ensure that AWS CloudFormation successfully received them.</p> <p>If you don\'t specify an operation ID, AWS CloudFormation generates one automatically.</p> <p>Repeating this stack set operation with a new operation ID retries all stack instances whose status is <code>OUTDATED</code>. </p>', 'UpdateStackSetOutput$OperationId' => '<p>The unique ID for this stack set operation.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateChangeSetInput$ClientToken' => '<p>A unique identifier for this <code>CreateChangeSet</code> request. Specify this token if you plan to retry requests so that AWS CloudFormation knows that you\'re not attempting to create another change set with the same name. You might retry <code>CreateChangeSet</code> requests to ensure that AWS CloudFormation successfully received them.</p>', 'RecordHandlerProgressInput$BearerToken' => '<p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>', ], ], 'ContinueUpdateRollbackInput' => [ 'base' => '<p>The input for the <a>ContinueUpdateRollback</a> action.</p>', 'refs' => [], ], 'ContinueUpdateRollbackOutput' => [ 'base' => '<p>The output for a <a>ContinueUpdateRollback</a> action.</p>', 'refs' => [], ], 'CreateChangeSetInput' => [ 'base' => '<p>The input for the <a>CreateChangeSet</a> action.</p>', 'refs' => [], ], 'CreateChangeSetOutput' => [ 'base' => '<p>The output for the <a>CreateChangeSet</a> action.</p>', 'refs' => [], ], 'CreateStackInput' => [ 'base' => '<p>The input for <a>CreateStack</a> action.</p>', 'refs' => [], ], 'CreateStackInstancesInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateStackInstancesOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateStackOutput' => [ 'base' => '<p>The output for a <a>CreateStack</a> action.</p>', 'refs' => [], ], 'CreateStackSetInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateStackSetOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreatedButModifiedException' => [ 'base' => '<p>The specified resource exists, but has been changed.</p>', 'refs' => [], ], 'CreationTime' => [ 'base' => NULL, 'refs' => [ 'ChangeSetSummary$CreationTime' => '<p>The start time when the change set was created, in UTC.</p>', 'DescribeChangeSetOutput$CreationTime' => '<p>The start time when the change set was created, in UTC.</p>', 'Stack$CreationTime' => '<p>The time at which the stack was created.</p>', 'StackSummary$CreationTime' => '<p>The time the stack was created.</p>', ], ], 'DeleteChangeSetInput' => [ 'base' => '<p>The input for the <a>DeleteChangeSet</a> action.</p>', 'refs' => [], ], 'DeleteChangeSetOutput' => [ 'base' => '<p>The output for the <a>DeleteChangeSet</a> action.</p>', 'refs' => [], ], 'DeleteStackInput' => [ 'base' => '<p>The input for <a>DeleteStack</a> action.</p>', 'refs' => [], ], 'DeleteStackInstancesInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStackInstancesOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStackSetInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStackSetOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeletionTime' => [ 'base' => NULL, 'refs' => [ 'Stack$DeletionTime' => '<p>The time the stack was deleted.</p>', 'StackSummary$DeletionTime' => '<p>The time the stack was deleted.</p>', ], ], 'DeploymentTargets' => [ 'base' => '<p>[<code>Service-managed</code> permissions] The AWS Organizations accounts to which StackSets deploys. StackSets does not deploy stack instances to the organization master account, even if the master account is in your organization or in an OU in your organization.</p> <p>For update operations, you can specify either <code>Accounts</code> or <code>OrganizationalUnitIds</code>. For create and delete operations, specify <code>OrganizationalUnitIds</code>.</p>', 'refs' => [ 'CreateStackInstancesInput$DeploymentTargets' => '<p>[<code>Service-managed</code> permissions] The AWS Organizations accounts for which to create stack instances in the specified Regions.</p> <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not both.</p>', 'DeleteStackInstancesInput$DeploymentTargets' => '<p>[<code>Service-managed</code> permissions] The AWS Organizations accounts from which to delete stack instances.</p> <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not both.</p>', 'StackSetOperation$DeploymentTargets' => '<p>[<code>Service-managed</code> permissions] The AWS Organizations accounts affected by the stack operation.</p>', 'UpdateStackInstancesInput$DeploymentTargets' => '<p>[<code>Service-managed</code> permissions] The AWS Organizations accounts for which you want to update parameter values for stack instances. If your update targets OUs, the overridden parameter values only apply to the accounts that are currently in the target OUs and their child OUs. Accounts added to the target OUs and their child OUs in the future won\'t use the overridden values.</p> <p>You can specify <code>Accounts</code> or <code>DeploymentTargets</code>, but not both.</p>', 'UpdateStackSetInput$DeploymentTargets' => '<p>[<code>Service-managed</code> permissions] The AWS Organizations accounts in which to update associated stack instances.</p> <p>To update all the stack instances associated with this stack set, do not specify <code>DeploymentTargets</code> or <code>Regions</code>.</p> <p>If the stack set update includes changes to the template (that is, if <code>TemplateBody</code> or <code>TemplateURL</code> is specified), or the <code>Parameters</code>, AWS CloudFormation marks all stack instances with a status of <code>OUTDATED</code> prior to updating the stack instances in the specified accounts and Regions. If the stack set update does not include changes to the template or parameters, AWS CloudFormation updates the stack instances in the specified accounts and Regions, while leaving all other stack instances with their existing stack instance status.</p>', ], ], 'DeprecatedStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeTypeOutput$DeprecatedStatus' => '<p>The deprecation status of the type.</p> <p>Valid values include:</p> <ul> <li> <p> <code>LIVE</code>: The type is registered and can be used in CloudFormation operations, dependent on its provisioning behavior and visibility scope.</p> </li> <li> <p> <code>DEPRECATED</code>: The type has been deregistered and can no longer be used in CloudFormation operations. </p> </li> </ul>', 'ListTypeVersionsInput$DeprecatedStatus' => '<p>The deprecation status of the type versions that you want to get summary information about.</p> <p>Valid values include:</p> <ul> <li> <p> <code>LIVE</code>: The type version is registered and can be used in CloudFormation operations, dependent on its provisioning behavior and visibility scope.</p> </li> <li> <p> <code>DEPRECATED</code>: The type version has been deregistered and can no longer be used in CloudFormation operations. </p> </li> </ul> <p>The default is <code>LIVE</code>.</p>', 'ListTypesInput$DeprecatedStatus' => '<p>The deprecation status of the types that you want to get summary information about.</p> <p>Valid values include:</p> <ul> <li> <p> <code>LIVE</code>: The type is registered for use in CloudFormation operations.</p> </li> <li> <p> <code>DEPRECATED</code>: The type has been deregistered and can no longer be used in CloudFormation operations. </p> </li> </ul>', ], ], 'DeregisterTypeInput' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterTypeOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountLimitsInput' => [ 'base' => '<p>The input for the <a>DescribeAccountLimits</a> action.</p>', 'refs' => [], ], 'DescribeAccountLimitsOutput' => [ 'base' => '<p>The output for the <a>DescribeAccountLimits</a> action.</p>', 'refs' => [], ], 'DescribeChangeSetInput' => [ 'base' => '<p>The input for the <a>DescribeChangeSet</a> action.</p>', 'refs' => [], ], 'DescribeChangeSetOutput' => [ 'base' => '<p>The output for the <a>DescribeChangeSet</a> action.</p>', 'refs' => [], ], 'DescribeStackDriftDetectionStatusInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStackDriftDetectionStatusOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStackEventsInput' => [ 'base' => '<p>The input for <a>DescribeStackEvents</a> action.</p>', 'refs' => [], ], 'DescribeStackEventsOutput' => [ 'base' => '<p>The output for a <a>DescribeStackEvents</a> action.</p>', 'refs' => [], ], 'DescribeStackInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStackInstanceOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStackResourceDriftsInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStackResourceDriftsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStackResourceInput' => [ 'base' => '<p>The input for <a>DescribeStackResource</a> action.</p>', 'refs' => [], ], 'DescribeStackResourceOutput' => [ 'base' => '<p>The output for a <a>DescribeStackResource</a> action.</p>', 'refs' => [], ], 'DescribeStackResourcesInput' => [ 'base' => '<p>The input for <a>DescribeStackResources</a> action.</p>', 'refs' => [], ], 'DescribeStackResourcesOutput' => [ 'base' => '<p>The output for a <a>DescribeStackResources</a> action.</p>', 'refs' => [], ], 'DescribeStackSetInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStackSetOperationInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStackSetOperationOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStackSetOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStacksInput' => [ 'base' => '<p>The input for <a>DescribeStacks</a> action.</p>', 'refs' => [], ], 'DescribeStacksOutput' => [ 'base' => '<p>The output for a <a>DescribeStacks</a> action.</p>', 'refs' => [], ], 'DescribeTypeInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTypeOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTypeRegistrationInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTypeRegistrationOutput' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'ChangeSetSummary$Description' => '<p>Descriptive information about the change set.</p>', 'CreateChangeSetInput$Description' => '<p>A description to help you identify this change set.</p>', 'CreateStackSetInput$Description' => '<p>A description of the stack set. You can use the description to identify the stack set\'s purpose or other important information.</p>', 'DescribeChangeSetOutput$Description' => '<p>Information about the change set.</p>', 'DescribeTypeOutput$Description' => '<p>The description of the registered type.</p>', 'DescribeTypeRegistrationOutput$Description' => '<p>The description of the type registration request.</p>', 'GetTemplateSummaryOutput$Description' => '<p>The value that is defined in the <code>Description</code> property of the template.</p>', 'Output$Description' => '<p>User defined description associated with the output.</p>', 'ParameterDeclaration$Description' => '<p>The description that is associate with the parameter.</p>', 'Stack$Description' => '<p>A user-defined description associated with the stack.</p>', 'StackResource$Description' => '<p>User defined description associated with the resource.</p>', 'StackResourceDetail$Description' => '<p>User defined description associated with the resource.</p>', 'StackSet$Description' => '<p>A description of the stack set that you specify when the stack set is created or updated.</p>', 'StackSetSummary$Description' => '<p>A description of the stack set that you specify when the stack set is created or updated.</p>', 'TemplateParameter$Description' => '<p>User defined description associated with the parameter.</p>', 'TypeSummary$Description' => '<p>The description of the type.</p>', 'TypeVersionSummary$Description' => '<p>The description of the type version.</p>', 'UpdateStackSetInput$Description' => '<p>A brief description of updates that you are making.</p>', 'ValidateTemplateOutput$Description' => '<p>The description found within the template.</p>', ], ], 'DetectStackDriftInput' => [ 'base' => NULL, 'refs' => [], ], 'DetectStackDriftOutput' => [ 'base' => NULL, 'refs' => [], ], 'DetectStackResourceDriftInput' => [ 'base' => NULL, 'refs' => [], ], 'DetectStackResourceDriftOutput' => [ 'base' => NULL, 'refs' => [], ], 'DetectStackSetDriftInput' => [ 'base' => NULL, 'refs' => [], ], 'DetectStackSetDriftOutput' => [ 'base' => NULL, 'refs' => [], ], 'DifferenceType' => [ 'base' => NULL, 'refs' => [ 'PropertyDifference$DifferenceType' => '<p>The type of property difference.</p> <ul> <li> <p> <code>ADD</code>: A value has been added to a resource property that is an array or list data type.</p> </li> <li> <p> <code>REMOVE</code>: The property has been removed from the current resource configuration.</p> </li> <li> <p> <code>NOT_EQUAL</code>: The current property value differs from its expected value (as defined in the stack template and any values specified as template parameters).</p> </li> </ul>', ], ], 'DisableRollback' => [ 'base' => NULL, 'refs' => [ 'CreateStackInput$DisableRollback' => '<p>Set to <code>true</code> to disable rollback of the stack if stack creation failed. You can specify either <code>DisableRollback</code> or <code>OnFailure</code>, but not both.</p> <p>Default: <code>false</code> </p>', 'Stack$DisableRollback' => '<p>Boolean to enable or disable rollback on stack creation failures:</p> <ul> <li> <p> <code>true</code>: disable rollback</p> </li> <li> <p> <code>false</code>: enable rollback</p> </li> </ul>', ], ], 'DriftedStackInstancesCount' => [ 'base' => NULL, 'refs' => [ 'StackSetDriftDetectionDetails$DriftedStackInstancesCount' => '<p>The number of stack instances that have drifted from the expected template and parameter configuration of the stack set. A stack instance is considered to have drifted if one or more of the resources in the associated stack do not match their expected configuration.</p>', ], ], 'EnableTerminationProtection' => [ 'base' => NULL, 'refs' => [ 'CreateStackInput$EnableTerminationProtection' => '<p>Whether to enable termination protection on the specified stack. If a user attempts to delete a stack with termination protection enabled, the operation fails and the stack remains unchanged. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html">Protecting a Stack From Being Deleted</a> in the <i>AWS CloudFormation User Guide</i>. Termination protection is disabled on stacks by default. </p> <p> For <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested stacks</a>, termination protection is set on the root stack and cannot be changed directly on the nested stack.</p>', 'Stack$EnableTerminationProtection' => '<p>Whether termination protection is enabled for the stack.</p> <p> For <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested stacks</a>, termination protection is set on the root stack and cannot be changed directly on the nested stack. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html">Protecting a Stack From Being Deleted</a> in the <i>AWS CloudFormation User Guide</i>.</p>', 'UpdateTerminationProtectionInput$EnableTerminationProtection' => '<p>Whether to enable termination protection on the specified stack.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'CFNRegistryException$Message' => NULL, ], ], 'EstimateTemplateCostInput' => [ 'base' => '<p>The input for an <a>EstimateTemplateCost</a> action.</p>', 'refs' => [], ], 'EstimateTemplateCostOutput' => [ 'base' => '<p>The output for a <a>EstimateTemplateCost</a> action.</p>', 'refs' => [], ], 'EvaluationType' => [ 'base' => NULL, 'refs' => [ 'ResourceChangeDetail$Evaluation' => '<p>Indicates whether AWS CloudFormation can determine the target value, and whether the target value will change before you execute a change set.</p> <p>For <code>Static</code> evaluations, AWS CloudFormation can determine that the target value will change, and its value. For example, if you directly modify the <code>InstanceType</code> property of an EC2 instance, AWS CloudFormation knows that this property value will change, and its value, so this is a <code>Static</code> evaluation.</p> <p>For <code>Dynamic</code> evaluations, cannot determine the target value because it depends on the result of an intrinsic function, such as a <code>Ref</code> or <code>Fn::GetAtt</code> intrinsic function, when the stack is updated. For example, if your template includes a reference to a resource that is conditionally recreated, the value of the reference (the physical ID of the resource) might change, depending on if the resource is recreated. If the resource is recreated, it will have a new physical ID, so all references to that resource will also be updated.</p>', ], ], 'EventId' => [ 'base' => NULL, 'refs' => [ 'StackEvent$EventId' => '<p>The unique ID of this event.</p>', ], ], 'ExecuteChangeSetInput' => [ 'base' => '<p>The input for the <a>ExecuteChangeSet</a> action.</p>', 'refs' => [], ], 'ExecuteChangeSetOutput' => [ 'base' => '<p>The output for the <a>ExecuteChangeSet</a> action.</p>', 'refs' => [], ], 'ExecutionRoleName' => [ 'base' => NULL, 'refs' => [ 'CreateStackSetInput$ExecutionRoleName' => '<p>The name of the IAM execution role to use to create the stack set. If you do not specify an execution role, AWS CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role for the stack set operation.</p> <p>Specify an IAM role only if you are using customized execution roles to control which stack resources users and groups can include in their stack sets. </p>', 'StackSet$ExecutionRoleName' => '<p>The name of the IAM execution role used to create or update the stack set. </p> <p>Use customized execution roles to control which stack resources users and groups can include in their stack sets. </p>', 'StackSetOperation$ExecutionRoleName' => '<p>The name of the IAM execution role used to create or update the stack set.</p> <p>Use customized execution roles to control which stack resources users and groups can include in their stack sets. </p>', 'UpdateStackSetInput$ExecutionRoleName' => '<p>The name of the IAM execution role to use to update the stack set. If you do not specify an execution role, AWS CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role for the stack set operation.</p> <p>Specify an IAM role only if you are using customized execution roles to control which stack resources users and groups can include in their stack sets. </p> <p> If you specify a customized execution role, AWS CloudFormation uses that role to update the stack. If you do not specify a customized execution role, AWS CloudFormation performs the update using the role previously associated with the stack set, so long as you have permissions to perform operations on the stack set.</p>', ], ], 'ExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'ChangeSetSummary$ExecutionStatus' => '<p>If the change set execution status is <code>AVAILABLE</code>, you can execute the change set. If you can’t execute the change set, the status indicates why. For example, a change set might be in an <code>UNAVAILABLE</code> state because AWS CloudFormation is still creating it or in an <code>OBSOLETE</code> state because the stack was already updated.</p>', 'DescribeChangeSetOutput$ExecutionStatus' => '<p>If the change set execution status is <code>AVAILABLE</code>, you can execute the change set. If you can’t execute the change set, the status indicates why. For example, a change set might be in an <code>UNAVAILABLE</code> state because AWS CloudFormation is still creating it or in an <code>OBSOLETE</code> state because the stack was already updated.</p>', ], ], 'Export' => [ 'base' => '<p>The <code>Export</code> structure describes the exported output values for a stack.</p>', 'refs' => [ 'Exports$member' => NULL, ], ], 'ExportName' => [ 'base' => NULL, 'refs' => [ 'Export$Name' => '<p>The name of exported output value. Use this name and the <code>Fn::ImportValue</code> function to import the associated value into other stacks. The name is defined in the <code>Export</code> field in the associated stack\'s <code>Outputs</code> section.</p>', 'ListImportsInput$ExportName' => '<p>The name of the exported output value. AWS CloudFormation returns the stack names that are importing this value. </p>', 'Output$ExportName' => '<p>The name of the export associated with the output.</p>', ], ], 'ExportValue' => [ 'base' => NULL, 'refs' => [ 'Export$Value' => '<p>The value of the exported output, such as a resource physical ID. This value is defined in the <code>Export</code> field in the associated stack\'s <code>Outputs</code> section.</p>', ], ], 'Exports' => [ 'base' => NULL, 'refs' => [ 'ListExportsOutput$Exports' => '<p>The output for the <a>ListExports</a> action.</p>', ], ], 'FailedStackInstancesCount' => [ 'base' => NULL, 'refs' => [ 'StackSetDriftDetectionDetails$FailedStackInstancesCount' => '<p>The number of stack instances for which the drift detection operation failed.</p>', ], ], 'FailureToleranceCount' => [ 'base' => NULL, 'refs' => [ 'StackSetOperationPreferences$FailureToleranceCount' => '<p>The number of accounts, per Region, for which this operation can fail before AWS CloudFormation stops the operation in that Region. If the operation is stopped in a Region, AWS CloudFormation doesn\'t attempt the operation in any subsequent Regions.</p> <p>Conditional: You must specify either <code>FailureToleranceCount</code> or <code>FailureTolerancePercentage</code> (but not both).</p>', ], ], 'FailureTolerancePercentage' => [ 'base' => NULL, 'refs' => [ 'StackSetOperationPreferences$FailureTolerancePercentage' => '<p>The percentage of accounts, per Region, for which this stack operation can fail before AWS CloudFormation stops the operation in that Region. If the operation is stopped in a Region, AWS CloudFormation doesn\'t attempt the operation in any subsequent Regions.</p> <p>When calculating the number of accounts based on the specified percentage, AWS CloudFormation rounds <i>down</i> to the next whole number.</p> <p>Conditional: You must specify either <code>FailureToleranceCount</code> or <code>FailureTolerancePercentage</code>, but not both.</p>', ], ], 'GetStackPolicyInput' => [ 'base' => '<p>The input for the <a>GetStackPolicy</a> action.</p>', 'refs' => [], ], 'GetStackPolicyOutput' => [ 'base' => '<p>The output for the <a>GetStackPolicy</a> action.</p>', 'refs' => [], ], 'GetTemplateInput' => [ 'base' => '<p>The input for a <a>GetTemplate</a> action.</p>', 'refs' => [], ], 'GetTemplateOutput' => [ 'base' => '<p>The output for <a>GetTemplate</a> action.</p>', 'refs' => [], ], 'GetTemplateSummaryInput' => [ 'base' => '<p>The input for the <a>GetTemplateSummary</a> action.</p>', 'refs' => [], ], 'GetTemplateSummaryOutput' => [ 'base' => '<p>The output for the <a>GetTemplateSummary</a> action.</p>', 'refs' => [], ], 'HandlerErrorCode' => [ 'base' => NULL, 'refs' => [ 'RecordHandlerProgressInput$ErrorCode' => '<p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>', ], ], 'Imports' => [ 'base' => NULL, 'refs' => [ 'ListImportsOutput$Imports' => '<p>A list of stack names that are importing the specified exported output value. </p>', ], ], 'InProgressStackInstancesCount' => [ 'base' => NULL, 'refs' => [ 'StackSetDriftDetectionDetails$InProgressStackInstancesCount' => '<p>The number of stack instances that are currently being checked for drift.</p>', ], ], 'InSyncStackInstancesCount' => [ 'base' => NULL, 'refs' => [ 'StackSetDriftDetectionDetails$InSyncStackInstancesCount' => '<p>The number of stack instances which match the expected template and parameter configuration of the stack set.</p>', ], ], 'InsufficientCapabilitiesException' => [ 'base' => '<p>The template contains resources with capabilities that weren\'t specified in the Capabilities parameter.</p>', 'refs' => [], ], 'InvalidChangeSetStatusException' => [ 'base' => '<p>The specified change set can\'t be used to update the stack. For example, the change set status might be <code>CREATE_IN_PROGRESS</code>, or the stack status might be <code>UPDATE_IN_PROGRESS</code>.</p>', 'refs' => [], ], 'InvalidOperationException' => [ 'base' => '<p>The specified operation isn\'t valid.</p>', 'refs' => [], ], 'InvalidStateTransitionException' => [ 'base' => '<p>Error reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>. CloudFormation does not return this error to users.</p>', 'refs' => [], ], 'IsDefaultVersion' => [ 'base' => NULL, 'refs' => [ 'DescribeTypeOutput$IsDefaultVersion' => '<p>Whether the specified type version is set as the default version.</p>', 'TypeVersionSummary$IsDefaultVersion' => '<p>Whether the specified type version is set as the default version.</p>', ], ], 'Key' => [ 'base' => NULL, 'refs' => [ 'PhysicalResourceIdContextKeyValuePair$Key' => '<p>The resource context key.</p>', ], ], 'LastUpdatedTime' => [ 'base' => NULL, 'refs' => [ 'Stack$LastUpdatedTime' => '<p>The time the stack was last updated. This field will only be returned if the stack has been updated at least once.</p>', 'StackSummary$LastUpdatedTime' => '<p>The time the stack was last updated. This field will only be returned if the stack has been updated at least once.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The quota for the resource has already been reached.</p> <p>For information on resource and stack limitations, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">Limits</a> in the <i>AWS CloudFormation User Guide</i>.</p>', 'refs' => [], ], 'LimitName' => [ 'base' => NULL, 'refs' => [ 'AccountLimit$Name' => '<p>The name of the account limit.</p> <p>Values: <code>ConcurrentResourcesLimit</code> | <code>StackLimit</code> | <code>StackOutputsLimit</code> </p>', ], ], 'LimitValue' => [ 'base' => NULL, 'refs' => [ 'AccountLimit$Value' => '<p>The value that is associated with the account limit name.</p>', ], ], 'ListChangeSetsInput' => [ 'base' => '<p>The input for the <a>ListChangeSets</a> action.</p>', 'refs' => [], ], 'ListChangeSetsOutput' => [ 'base' => '<p>The output for the <a>ListChangeSets</a> action.</p>', 'refs' => [], ], 'ListExportsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListExportsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListImportsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListImportsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListStackInstancesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListStackInstancesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListStackResourcesInput' => [ 'base' => '<p>The input for the <a>ListStackResource</a> action.</p>', 'refs' => [], ], 'ListStackResourcesOutput' => [ 'base' => '<p>The output for a <a>ListStackResources</a> action.</p>', 'refs' => [], ], 'ListStackSetOperationResultsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListStackSetOperationResultsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListStackSetOperationsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListStackSetOperationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListStackSetsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListStackSetsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListStacksInput' => [ 'base' => '<p>The input for <a>ListStacks</a> action.</p>', 'refs' => [], ], 'ListStacksOutput' => [ 'base' => '<p>The output for <a>ListStacks</a> action.</p>', 'refs' => [], ], 'ListTypeRegistrationsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTypeRegistrationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTypeVersionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTypeVersionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTypesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTypesOutput' => [ 'base' => NULL, 'refs' => [], ], 'LogGroupName' => [ 'base' => NULL, 'refs' => [ 'LoggingConfig$LogGroupName' => '<p>The Amazon CloudWatch log group to which CloudFormation sends error logging information when invoking the type\'s handlers.</p>', ], ], 'LoggingConfig' => [ 'base' => '<p>Contains logging configuration information for a type.</p>', 'refs' => [ 'DescribeTypeOutput$LoggingConfig' => '<p>Contains logging configuration information for a type.</p>', 'RegisterTypeInput$LoggingConfig' => '<p>Specifies logging configuration information for a type.</p>', ], ], 'LogicalResourceId' => [ 'base' => NULL, 'refs' => [ 'DescribeStackResourceInput$LogicalResourceId' => '<p>The logical name of the resource as specified in the template.</p> <p>Default: There is no default value.</p>', 'DescribeStackResourcesInput$LogicalResourceId' => '<p>The logical name of the resource as specified in the template.</p> <p>Default: There is no default value.</p>', 'DetectStackResourceDriftInput$LogicalResourceId' => '<p>The logical name of the resource for which to return drift information.</p>', 'LogicalResourceIds$member' => NULL, 'ResourceChange$LogicalResourceId' => '<p>The resource\'s logical ID, which is defined in the stack\'s template.</p>', 'ResourceToImport$LogicalResourceId' => '<p>The logical ID of the target resource as specified in the template.</p>', 'RetainResources$member' => NULL, 'SignalResourceInput$LogicalResourceId' => '<p>The logical ID of the resource that you want to signal. The logical ID is the name of the resource that given in the template.</p>', 'StackEvent$LogicalResourceId' => '<p>The logical name of the resource specified in the template.</p>', 'StackResource$LogicalResourceId' => '<p>The logical name of the resource specified in the template.</p>', 'StackResourceDetail$LogicalResourceId' => '<p>The logical name of the resource specified in the template.</p>', 'StackResourceDrift$LogicalResourceId' => '<p>The logical name of the resource specified in the template.</p>', 'StackResourceSummary$LogicalResourceId' => '<p>The logical name of the resource specified in the template.</p>', ], ], 'LogicalResourceIds' => [ 'base' => NULL, 'refs' => [ 'DetectStackDriftInput$LogicalResourceIds' => '<p>The logical names of any resources you want to use as filters.</p>', 'ResourceIdentifierSummary$LogicalResourceIds' => '<p>The logical IDs of the target resources of the specified <code>ResourceType</code>, as defined in the import template.</p>', ], ], 'MaxConcurrentCount' => [ 'base' => NULL, 'refs' => [ 'StackSetOperationPreferences$MaxConcurrentCount' => '<p>The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of <code>FailureToleranceCount</code>. <code>MaxConcurrentCount</code> is at most one more than the <code>FailureToleranceCount</code>.</p> <p>Note that this setting lets you specify the <i>maximum</i> for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.</p> <p>Conditional: You must specify either <code>MaxConcurrentCount</code> or <code>MaxConcurrentPercentage</code>, but not both.</p>', ], ], 'MaxConcurrentPercentage' => [ 'base' => NULL, 'refs' => [ 'StackSetOperationPreferences$MaxConcurrentPercentage' => '<p>The maximum percentage of accounts in which to perform this operation at one time.</p> <p>When calculating the number of accounts based on the specified percentage, AWS CloudFormation rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, CloudFormation sets the number as one instead.</p> <p>Note that this setting lets you specify the <i>maximum</i> for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.</p> <p>Conditional: You must specify either <code>MaxConcurrentCount</code> or <code>MaxConcurrentPercentage</code>, but not both.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListStackInstancesInput$MaxResults' => '<p>The maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code> request parameter to get the next set of results.</p>', 'ListStackSetOperationResultsInput$MaxResults' => '<p>The maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code> request parameter to get the next set of results.</p>', 'ListStackSetOperationsInput$MaxResults' => '<p>The maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code> request parameter to get the next set of results.</p>', 'ListStackSetsInput$MaxResults' => '<p>The maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code> request parameter to get the next set of results.</p>', 'ListTypeRegistrationsInput$MaxResults' => '<p>The maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code> request parameter to get the next set of results.</p>', 'ListTypeVersionsInput$MaxResults' => '<p>The maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code> request parameter to get the next set of results.</p>', 'ListTypesInput$MaxResults' => '<p>The maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code> request parameter to get the next set of results.</p>', ], ], 'Metadata' => [ 'base' => NULL, 'refs' => [ 'GetTemplateSummaryOutput$Metadata' => '<p>The value that is defined for the <code>Metadata</code> property of the template.</p>', 'StackResourceDetail$Metadata' => '<p>The content of the <code>Metadata</code> attribute declared for the resource. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-metadata.html">Metadata Attribute</a> in the AWS CloudFormation User Guide.</p>', ], ], 'MonitoringTimeInMinutes' => [ 'base' => NULL, 'refs' => [ 'RollbackConfiguration$MonitoringTimeInMinutes' => '<p>The amount of time, in minutes, during which CloudFormation should monitor all the rollback triggers after the stack creation or update operation deploys all necessary resources.</p> <p>The default is 0 minutes.</p> <p>If you specify a monitoring period but do not specify any rollback triggers, CloudFormation still waits the specified period of time before cleaning up old resources after update operations. You can use this monitoring period to perform any manual stack validation desired, and manually cancel the stack creation or update (using <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CancelUpdateStack.html">CancelUpdateStack</a>, for example) as necessary.</p> <p>If you specify 0 for this parameter, CloudFormation still monitors the specified rollback triggers during stack creation and update operations. Then, for update operations, it begins disposing of old resources immediately once the operation completes.</p>', ], ], 'NameAlreadyExistsException' => [ 'base' => '<p>The specified name is already in use.</p>', 'refs' => [], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountLimitsInput$NextToken' => '<p>A string that identifies the next page of limits that you want to retrieve.</p>', 'DescribeAccountLimitsOutput$NextToken' => '<p>If the output exceeds 1 MB in size, a string that identifies the next page of limits. If no additional page exists, this value is null.</p>', 'DescribeChangeSetInput$NextToken' => '<p>A string (provided by the <a>DescribeChangeSet</a> response output) that identifies the next page of information that you want to retrieve.</p>', 'DescribeChangeSetOutput$NextToken' => '<p>If the output exceeds 1 MB, a string that identifies the next page of changes. If there is no additional page, this value is null.</p>', 'DescribeStackEventsInput$NextToken' => '<p>A string that identifies the next page of events that you want to retrieve.</p>', 'DescribeStackEventsOutput$NextToken' => '<p>If the output exceeds 1 MB in size, a string that identifies the next page of events. If no additional page exists, this value is null.</p>', 'DescribeStackResourceDriftsInput$NextToken' => '<p>A string that identifies the next page of stack resource drift results.</p>', 'DescribeStackResourceDriftsOutput$NextToken' => '<p>If the request doesn\'t return all of the remaining results, <code>NextToken</code> is set to a token. To retrieve the next set of results, call <code>DescribeStackResourceDrifts</code> again and assign that token to the request object\'s <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to <code>null</code>.</p>', 'DescribeStacksInput$NextToken' => '<p>A string that identifies the next page of stacks that you want to retrieve.</p>', 'DescribeStacksOutput$NextToken' => '<p>If the output exceeds 1 MB in size, a string that identifies the next page of stacks. If no additional page exists, this value is null.</p>', 'ListChangeSetsInput$NextToken' => '<p>A string (provided by the <a>ListChangeSets</a> response output) that identifies the next page of change sets that you want to retrieve.</p>', 'ListChangeSetsOutput$NextToken' => '<p>If the output exceeds 1 MB, a string that identifies the next page of change sets. If there is no additional page, this value is null.</p>', 'ListExportsInput$NextToken' => '<p>A string (provided by the <a>ListExports</a> response output) that identifies the next page of exported output values that you asked to retrieve.</p>', 'ListExportsOutput$NextToken' => '<p>If the output exceeds 100 exported output values, a string that identifies the next page of exports. If there is no additional page, this value is null.</p>', 'ListImportsInput$NextToken' => '<p>A string (provided by the <a>ListImports</a> response output) that identifies the next page of stacks that are importing the specified exported output value. </p>', 'ListImportsOutput$NextToken' => '<p>A string that identifies the next page of exports. If there is no additional page, this value is null.</p>', 'ListStackInstancesInput$NextToken' => '<p>If the previous request didn\'t return all of the remaining results, the response\'s <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListStackInstances</code> again and assign that token to the request object\'s <code>NextToken</code> parameter. If there are no remaining results, the previous response object\'s <code>NextToken</code> parameter is set to <code>null</code>.</p>', 'ListStackInstancesOutput$NextToken' => '<p>If the request doesn\'t return all of the remaining results, <code>NextToken</code> is set to a token. To retrieve the next set of results, call <code>ListStackInstances</code> again and assign that token to the request object\'s <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to <code>null</code>.</p>', 'ListStackResourcesInput$NextToken' => '<p>A string that identifies the next page of stack resources that you want to retrieve.</p>', 'ListStackResourcesOutput$NextToken' => '<p>If the output exceeds 1 MB, a string that identifies the next page of stack resources. If no additional page exists, this value is null.</p>', 'ListStackSetOperationResultsInput$NextToken' => '<p>If the previous request didn\'t return all of the remaining results, the response object\'s <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListStackSetOperationResults</code> again and assign that token to the request object\'s <code>NextToken</code> parameter. If there are no remaining results, the previous response object\'s <code>NextToken</code> parameter is set to <code>null</code>.</p>', 'ListStackSetOperationResultsOutput$NextToken' => '<p>If the request doesn\'t return all results, <code>NextToken</code> is set to a token. To retrieve the next set of results, call <code>ListOperationResults</code> again and assign that token to the request object\'s <code>NextToken</code> parameter. If there are no remaining results, <code>NextToken</code> is set to <code>null</code>.</p>', 'ListStackSetOperationsInput$NextToken' => '<p>If the previous paginated request didn\'t return all of the remaining results, the response object\'s <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListStackSetOperations</code> again and assign that token to the request object\'s <code>NextToken</code> parameter. If there are no remaining results, the previous response object\'s <code>NextToken</code> parameter is set to <code>null</code>.</p>', 'ListStackSetOperationsOutput$NextToken' => '<p>If the request doesn\'t return all results, <code>NextToken</code> is set to a token. To retrieve the next set of results, call <code>ListOperationResults</code> again and assign that token to the request object\'s <code>NextToken</code> parameter. If there are no remaining results, <code>NextToken</code> is set to <code>null</code>.</p>', 'ListStackSetsInput$NextToken' => '<p>If the previous paginated request didn\'t return all of the remaining results, the response object\'s <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListStackSets</code> again and assign that token to the request object\'s <code>NextToken</code> parameter. If there are no remaining results, the previous response object\'s <code>NextToken</code> parameter is set to <code>null</code>.</p>', 'ListStackSetsOutput$NextToken' => '<p>If the request doesn\'t return all of the remaining results, <code>NextToken</code> is set to a token. To retrieve the next set of results, call <code>ListStackInstances</code> again and assign that token to the request object\'s <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to <code>null</code>.</p>', 'ListStacksInput$NextToken' => '<p>A string that identifies the next page of stacks that you want to retrieve.</p>', 'ListStacksOutput$NextToken' => '<p>If the output exceeds 1 MB in size, a string that identifies the next page of stacks. If no additional page exists, this value is null.</p>', 'ListTypeRegistrationsInput$NextToken' => '<p>If the previous paginated request didn\'t return all of the remaining results, the response object\'s <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call this action again and assign that token to the request object\'s <code>NextToken</code> parameter. If there are no remaining results, the previous response object\'s <code>NextToken</code> parameter is set to <code>null</code>.</p>', 'ListTypeRegistrationsOutput$NextToken' => '<p>If the request doesn\'t return all of the remaining results, <code>NextToken</code> is set to a token. To retrieve the next set of results, call this action again and assign that token to the request object\'s <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to <code>null</code>.</p>', 'ListTypeVersionsInput$NextToken' => '<p>If the previous paginated request didn\'t return all of the remaining results, the response object\'s <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call this action again and assign that token to the request object\'s <code>NextToken</code> parameter. If there are no remaining results, the previous response object\'s <code>NextToken</code> parameter is set to <code>null</code>.</p>', 'ListTypeVersionsOutput$NextToken' => '<p>If the request doesn\'t return all of the remaining results, <code>NextToken</code> is set to a token. To retrieve the next set of results, call this action again and assign that token to the request object\'s <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to <code>null</code>.</p>', 'ListTypesInput$NextToken' => '<p>If the previous paginated request didn\'t return all of the remaining results, the response object\'s <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call this action again and assign that token to the request object\'s <code>NextToken</code> parameter. If there are no remaining results, the previous response object\'s <code>NextToken</code> parameter is set to <code>null</code>.</p>', 'ListTypesOutput$NextToken' => '<p>If the request doesn\'t return all of the remaining results, <code>NextToken</code> is set to a token. To retrieve the next set of results, call this action again and assign that token to the request object\'s <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to <code>null</code>.</p>', ], ], 'NoEcho' => [ 'base' => NULL, 'refs' => [ 'ParameterDeclaration$NoEcho' => '<p>Flag that indicates whether the parameter value is shown as plain text in logs and in the AWS Management Console.</p>', 'TemplateParameter$NoEcho' => '<p>Flag indicating whether the parameter should be displayed as plain text in logs and UIs.</p>', ], ], 'NotificationARN' => [ 'base' => NULL, 'refs' => [ 'NotificationARNs$member' => NULL, ], ], 'NotificationARNs' => [ 'base' => NULL, 'refs' => [ 'CreateChangeSetInput$NotificationARNs' => '<p>The Amazon Resource Names (ARNs) of Amazon Simple Notification Service (Amazon SNS) topics that AWS CloudFormation associates with the stack. To remove all associated notification topics, specify an empty list.</p>', 'CreateStackInput$NotificationARNs' => '<p>The Simple Notification Service (SNS) topic ARNs to publish stack related events. You can find your SNS topic ARNs using the SNS console or your Command Line Interface (CLI).</p>', 'DescribeChangeSetOutput$NotificationARNs' => '<p>The ARNs of the Amazon Simple Notification Service (Amazon SNS) topics that will be associated with the stack if you execute the change set.</p>', 'Stack$NotificationARNs' => '<p>SNS topic ARNs to which stack related events are published.</p>', 'UpdateStackInput$NotificationARNs' => '<p>Amazon Simple Notification Service topic Amazon Resource Names (ARNs) that AWS CloudFormation associates with the stack. Specify an empty list to remove all notification topics.</p>', ], ], 'OnFailure' => [ 'base' => NULL, 'refs' => [ 'CreateStackInput$OnFailure' => '<p>Determines what action will be taken if stack creation fails. This must be one of: DO_NOTHING, ROLLBACK, or DELETE. You can specify either <code>OnFailure</code> or <code>DisableRollback</code>, but not both.</p> <p>Default: <code>ROLLBACK</code> </p>', ], ], 'OperationIdAlreadyExistsException' => [ 'base' => '<p>The specified operation ID already exists.</p>', 'refs' => [], ], 'OperationInProgressException' => [ 'base' => '<p>Another operation is currently in progress for this stack set. Only one operation can be performed for a stack set at a given time.</p>', 'refs' => [], ], 'OperationNotFoundException' => [ 'base' => '<p>The specified ID refers to an operation that doesn\'t exist.</p>', 'refs' => [], ], 'OperationStatus' => [ 'base' => NULL, 'refs' => [ 'RecordHandlerProgressInput$OperationStatus' => '<p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>', 'RecordHandlerProgressInput$CurrentOperationStatus' => '<p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>', ], ], 'OperationStatusCheckFailedException' => [ 'base' => '<p>Error reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>. CloudFormation does not return this error to users.</p>', 'refs' => [], ], 'OptionalSecureUrl' => [ 'base' => NULL, 'refs' => [ 'DescribeTypeOutput$SourceUrl' => '<p>The URL of the source code for the type.</p>', 'DescribeTypeOutput$DocumentationUrl' => '<p>The URL of a page providing detailed documentation for this type.</p>', ], ], 'OrganizationalUnitId' => [ 'base' => NULL, 'refs' => [ 'OrganizationalUnitIdList$member' => NULL, 'StackInstance$OrganizationalUnitId' => '<p>[<code>Service-managed</code> permissions] The organization root ID or organizational unit (OU) IDs that you specified for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html">DeploymentTargets</a>.</p>', 'StackInstanceSummary$OrganizationalUnitId' => '<p>[<code>Service-managed</code> permissions] The organization root ID or organizational unit (OU) IDs that you specified for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html">DeploymentTargets</a>.</p>', 'StackSetOperationResultSummary$OrganizationalUnitId' => '<p>[<code>Service-managed</code> permissions] The organization root ID or organizational unit (OU) IDs that you specified for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html">DeploymentTargets</a>.</p>', ], ], 'OrganizationalUnitIdList' => [ 'base' => NULL, 'refs' => [ 'DeploymentTargets$OrganizationalUnitIds' => '<p>The organization root ID or organizational unit (OU) IDs to which StackSets deploys.</p>', 'StackSet$OrganizationalUnitIds' => '<p>[<code>Service-managed</code> permissions] The organization root ID or organizational unit (OU) IDs that you specified for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeploymentTargets.html">DeploymentTargets</a>.</p>', ], ], 'Output' => [ 'base' => '<p>The Output data type.</p>', 'refs' => [ 'Outputs$member' => NULL, ], ], 'OutputKey' => [ 'base' => NULL, 'refs' => [ 'Output$OutputKey' => '<p>The key associated with the output.</p>', ], ], 'OutputValue' => [ 'base' => NULL, 'refs' => [ 'Output$OutputValue' => '<p>The value associated with the output.</p>', ], ], 'Outputs' => [ 'base' => NULL, 'refs' => [ 'Stack$Outputs' => '<p>A list of output structures.</p>', ], ], 'Parameter' => [ 'base' => '<p>The Parameter data type.</p>', 'refs' => [ 'Parameters$member' => NULL, ], ], 'ParameterConstraints' => [ 'base' => '<p>A set of criteria that AWS CloudFormation uses to validate parameter values. Although other constraints might be defined in the stack template, AWS CloudFormation returns only the <code>AllowedValues</code> property.</p>', 'refs' => [ 'ParameterDeclaration$ParameterConstraints' => '<p>The criteria that AWS CloudFormation uses to validate parameter values.</p>', ], ], 'ParameterDeclaration' => [ 'base' => '<p>The ParameterDeclaration data type.</p>', 'refs' => [ 'ParameterDeclarations$member' => NULL, ], ], 'ParameterDeclarations' => [ 'base' => NULL, 'refs' => [ 'GetTemplateSummaryOutput$Parameters' => '<p>A list of parameter declarations that describe various properties for each parameter.</p>', ], ], 'ParameterKey' => [ 'base' => NULL, 'refs' => [ 'Parameter$ParameterKey' => '<p>The key associated with the parameter. If you don\'t specify a key and value for a particular parameter, AWS CloudFormation uses the default value that is specified in your template.</p>', 'ParameterDeclaration$ParameterKey' => '<p>The name that is associated with the parameter.</p>', 'TemplateParameter$ParameterKey' => '<p>The name associated with the parameter.</p>', ], ], 'ParameterType' => [ 'base' => NULL, 'refs' => [ 'ParameterDeclaration$ParameterType' => '<p>The type of parameter.</p>', ], ], 'ParameterValue' => [ 'base' => NULL, 'refs' => [ 'Parameter$ParameterValue' => '<p>The input value associated with the parameter.</p>', 'Parameter$ResolvedValue' => '<p>Read-only. The value that corresponds to a Systems Manager parameter key. This field is returned only for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/parameters-section-structure.html#aws-ssm-parameter-types"> <code>SSM</code> parameter types</a> in the template.</p>', 'ParameterDeclaration$DefaultValue' => '<p>The default value of the parameter.</p>', 'TemplateParameter$DefaultValue' => '<p>The default value associated with the parameter.</p>', ], ], 'Parameters' => [ 'base' => NULL, 'refs' => [ 'CreateChangeSetInput$Parameters' => '<p>A list of <code>Parameter</code> structures that specify input parameters for the change set. For more information, see the <a>Parameter</a> data type.</p>', 'CreateStackInput$Parameters' => '<p>A list of <code>Parameter</code> structures that specify input parameters for the stack. For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data type.</p>', 'CreateStackInstancesInput$ParameterOverrides' => '<p>A list of stack set parameters whose values you want to override in the selected stack instances.</p> <p>Any overridden parameter values will be applied to all stack instances in the specified accounts and Regions. When specifying parameters and their values, be aware of how AWS CloudFormation sets parameter values during stack instance operations:</p> <ul> <li> <p>To override the current value for a parameter, include the parameter and specify its value.</p> </li> <li> <p>To leave a parameter set to its present value, you can do one of the following:</p> <ul> <li> <p>Do not include the parameter in the list.</p> </li> <li> <p>Include the parameter and specify <code>UsePreviousValue</code> as <code>true</code>. (You cannot specify both a value and set <code>UsePreviousValue</code> to <code>true</code>.)</p> </li> </ul> </li> <li> <p>To set all overridden parameter back to the values specified in the stack set, specify a parameter list but do not include any parameters.</p> </li> <li> <p>To leave all parameters set to their present values, do not specify this property at all.</p> </li> </ul> <p>During stack set updates, any parameter values overridden for a stack instance are not updated, but retain their overridden value.</p> <p>You can only override the parameter <i>values</i> that are specified in the stack set; to add or delete a parameter itself, use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet</a> to update the stack set template.</p>', 'CreateStackSetInput$Parameters' => '<p>The input parameters for the stack set template. </p>', 'DescribeChangeSetOutput$Parameters' => '<p>A list of <code>Parameter</code> structures that describes the input parameters and their values used to create the change set. For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data type.</p>', 'EstimateTemplateCostInput$Parameters' => '<p>A list of <code>Parameter</code> structures that specify input parameters.</p>', 'Stack$Parameters' => '<p>A list of <code>Parameter</code> structures.</p>', 'StackInstance$ParameterOverrides' => '<p>A list of parameters from the stack set template whose values have been overridden in this stack instance.</p>', 'StackSet$Parameters' => '<p>A list of input parameters for a stack set.</p>', 'UpdateStackInput$Parameters' => '<p>A list of <code>Parameter</code> structures that specify input parameters for the stack. For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html">Parameter</a> data type.</p>', 'UpdateStackInstancesInput$ParameterOverrides' => '<p> A list of input parameters whose values you want to update for the specified stack instances. </p> <p>Any overridden parameter values will be applied to all stack instances in the specified accounts and Regions. When specifying parameters and their values, be aware of how AWS CloudFormation sets parameter values during stack instance update operations:</p> <ul> <li> <p>To override the current value for a parameter, include the parameter and specify its value.</p> </li> <li> <p>To leave a parameter set to its present value, you can do one of the following:</p> <ul> <li> <p>Do not include the parameter in the list.</p> </li> <li> <p>Include the parameter and specify <code>UsePreviousValue</code> as <code>true</code>. (You cannot specify both a value and set <code>UsePreviousValue</code> to <code>true</code>.)</p> </li> </ul> </li> <li> <p>To set all overridden parameter back to the values specified in the stack set, specify a parameter list but do not include any parameters.</p> </li> <li> <p>To leave all parameters set to their present values, do not specify this property at all.</p> </li> </ul> <p>During stack set updates, any parameter values overridden for a stack instance are not updated, but retain their overridden value.</p> <p>You can only override the parameter <i>values</i> that are specified in the stack set; to add or delete a parameter itself, use <code>UpdateStackSet</code> to update the stack set template. If you add a parameter to a template, before you can override the parameter value specified in the stack set you must first use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet</a> to update all stack instances with the updated template and parameter value specified in the stack set. Once a stack instance has been updated with the new parameter, you can then override the parameter value using <code>UpdateStackInstances</code>.</p>', 'UpdateStackSetInput$Parameters' => '<p>A list of input parameters for the stack set template. </p>', ], ], 'PermissionModels' => [ 'base' => NULL, 'refs' => [ 'CreateStackSetInput$PermissionModel' => '<p>Describes how the IAM roles required for stack set operations are created. By default, <code>SELF-MANAGED</code> is specified.</p> <ul> <li> <p>With <code>self-managed</code> permissions, you must create the administrator and execution roles required to deploy to target accounts. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant Self-Managed Stack Set Permissions</a>.</p> </li> <li> <p>With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to deploy to accounts managed by AWS Organizations. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant Service-Managed Stack Set Permissions</a>.</p> </li> </ul>', 'StackSet$PermissionModel' => '<p>Describes how the IAM roles required for stack set operations are created.</p> <ul> <li> <p>With <code>self-managed</code> permissions, you must create the administrator and execution roles required to deploy to target accounts. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant Self-Managed Stack Set Permissions</a>.</p> </li> <li> <p>With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to deploy to accounts managed by AWS Organizations. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant Service-Managed Stack Set Permissions</a>.</p> </li> </ul>', 'StackSetSummary$PermissionModel' => '<p>Describes how the IAM roles required for stack set operations are created.</p> <ul> <li> <p>With <code>self-managed</code> permissions, you must create the administrator and execution roles required to deploy to target accounts. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant Self-Managed Stack Set Permissions</a>.</p> </li> <li> <p>With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to deploy to accounts managed by AWS Organizations. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant Service-Managed Stack Set Permissions</a>.</p> </li> </ul>', 'UpdateStackSetInput$PermissionModel' => '<p>Describes how the IAM roles required for stack set operations are created. You cannot modify <code>PermissionModel</code> if there are stack instances associated with your stack set.</p> <ul> <li> <p>With <code>self-managed</code> permissions, you must create the administrator and execution roles required to deploy to target accounts. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant Self-Managed Stack Set Permissions</a>.</p> </li> <li> <p>With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to deploy to accounts managed by AWS Organizations. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant Service-Managed Stack Set Permissions</a>.</p> </li> </ul>', ], ], 'PhysicalResourceId' => [ 'base' => NULL, 'refs' => [ 'DescribeStackResourcesInput$PhysicalResourceId' => '<p>The name or unique identifier that corresponds to a physical instance ID of a resource supported by AWS CloudFormation.</p> <p>For example, for an Amazon Elastic Compute Cloud (EC2) instance, <code>PhysicalResourceId</code> corresponds to the <code>InstanceId</code>. You can pass the EC2 <code>InstanceId</code> to <code>DescribeStackResources</code> to find which stack the instance belongs to and what other resources are part of the stack.</p> <p>Required: Conditional. If you do not specify <code>PhysicalResourceId</code>, you must specify <code>StackName</code>.</p> <p>Default: There is no default value.</p>', 'ResourceChange$PhysicalResourceId' => '<p>The resource\'s physical ID (resource name). Resources that you are adding don\'t have physical IDs because they haven\'t been created.</p>', 'StackEvent$PhysicalResourceId' => '<p>The name or unique identifier associated with the physical instance of the resource.</p>', 'StackResource$PhysicalResourceId' => '<p>The name or unique identifier that corresponds to a physical instance ID of a resource supported by AWS CloudFormation.</p>', 'StackResourceDetail$PhysicalResourceId' => '<p>The name or unique identifier that corresponds to a physical instance ID of a resource supported by AWS CloudFormation.</p>', 'StackResourceDrift$PhysicalResourceId' => '<p>The name or unique identifier that corresponds to a physical instance ID of a resource supported by AWS CloudFormation. </p>', 'StackResourceSummary$PhysicalResourceId' => '<p>The name or unique identifier that corresponds to a physical instance ID of the resource.</p>', ], ], 'PhysicalResourceIdContext' => [ 'base' => NULL, 'refs' => [ 'StackResourceDrift$PhysicalResourceIdContext' => '<p>Context information that enables AWS CloudFormation to uniquely identify a resource. AWS CloudFormation uses context key-value pairs in cases where a resource\'s logical and physical IDs are not enough to uniquely identify that resource. Each context key-value pair specifies a unique resource that contains the targeted resource.</p>', ], ], 'PhysicalResourceIdContextKeyValuePair' => [ 'base' => '<p>Context information that enables AWS CloudFormation to uniquely identify a resource. AWS CloudFormation uses context key-value pairs in cases where a resource\'s logical and physical IDs are not enough to uniquely identify that resource. Each context key-value pair specifies a resource that contains the targeted resource.</p>', 'refs' => [ 'PhysicalResourceIdContext$member' => NULL, ], ], 'PrivateTypeArn' => [ 'base' => NULL, 'refs' => [ 'DeregisterTypeInput$Arn' => '<p>The Amazon Resource Name (ARN) of the type.</p> <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.</p>', 'ListTypeVersionsInput$Arn' => '<p>The Amazon Resource Name (ARN) of the type for which you want version summary information.</p> <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.</p>', 'SetTypeDefaultVersionInput$Arn' => '<p>The Amazon Resource Name (ARN) of the type for which you want version summary information.</p> <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.</p>', ], ], 'Properties' => [ 'base' => NULL, 'refs' => [ 'StackResourceDrift$ExpectedProperties' => '<p>A JSON structure containing the expected property values of the stack resource, as defined in the stack template and any values specified as template parameters. </p> <p>For resources whose <code>StackResourceDriftStatus</code> is <code>DELETED</code>, this structure will not be present. </p>', 'StackResourceDrift$ActualProperties' => '<p>A JSON structure containing the actual property values of the stack resource.</p> <p>For resources whose <code>StackResourceDriftStatus</code> is <code>DELETED</code>, this structure will not be present. </p>', ], ], 'PropertyDifference' => [ 'base' => '<p>Information about a resource property whose actual value differs from its expected value, as defined in the stack template and any values specified as template parameters. These will be present only for resources whose <code>StackResourceDriftStatus</code> is <code>MODIFIED</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p>', 'refs' => [ 'PropertyDifferences$member' => NULL, ], ], 'PropertyDifferences' => [ 'base' => NULL, 'refs' => [ 'StackResourceDrift$PropertyDifferences' => '<p>A collection of the resource properties whose actual values differ from their expected values. These will be present only for resources whose <code>StackResourceDriftStatus</code> is <code>MODIFIED</code>. </p>', ], ], 'PropertyName' => [ 'base' => NULL, 'refs' => [ 'ResourceTargetDefinition$Name' => '<p>If the <code>Attribute</code> value is <code>Properties</code>, the name of the property. For all other attributes, the value is null.</p>', ], ], 'PropertyPath' => [ 'base' => NULL, 'refs' => [ 'PropertyDifference$PropertyPath' => '<p>The fully-qualified path to the resource property.</p>', ], ], 'PropertyValue' => [ 'base' => NULL, 'refs' => [ 'PropertyDifference$ExpectedValue' => '<p>The expected property value of the resource property, as defined in the stack template and any values specified as template parameters.</p>', 'PropertyDifference$ActualValue' => '<p>The actual property value of the resource property.</p>', ], ], 'ProvisioningType' => [ 'base' => NULL, 'refs' => [ 'DescribeTypeOutput$ProvisioningType' => '<p>The provisioning behavior of the type. AWS CloudFormation determines the provisioning type during registration, based on the types of handlers in the schema handler package submitted.</p> <p>Valid values include:</p> <ul> <li> <p> <code>FULLY_MUTABLE</code>: The type includes an update handler to process updates to the type during stack update operations.</p> </li> <li> <p> <code>IMMUTABLE</code>: The type does not include an update handler, so the type cannot be updated and must instead be replaced during stack update operations.</p> </li> <li> <p> <code>NON_PROVISIONABLE</code>: The type does not include all of the following handlers, and therefore cannot actually be provisioned.</p> <ul> <li> <p>create</p> </li> <li> <p>read</p> </li> <li> <p>delete</p> </li> </ul> </li> </ul>', 'ListTypesInput$ProvisioningType' => '<p>The provisioning behavior of the type. AWS CloudFormation determines the provisioning type during registration, based on the types of handlers in the schema handler package submitted.</p> <p>Valid values include:</p> <ul> <li> <p> <code>FULLY_MUTABLE</code>: The type includes an update handler to process updates to the type during stack update operations.</p> </li> <li> <p> <code>IMMUTABLE</code>: The type does not include an update handler, so the type cannot be updated and must instead be replaced during stack update operations.</p> </li> <li> <p> <code>NON_PROVISIONABLE</code>: The type does not include create, read, and delete handlers, and therefore cannot actually be provisioned.</p> </li> </ul>', ], ], 'Reason' => [ 'base' => NULL, 'refs' => [ 'StackInstance$StatusReason' => '<p>The explanation for the specific status code that is assigned to this stack instance.</p>', 'StackInstanceSummary$StatusReason' => '<p>The explanation for the specific status code assigned to this stack instance.</p>', 'StackSetOperationResultSummary$StatusReason' => '<p>The reason for the assigned result status.</p>', ], ], 'RecordHandlerProgressInput' => [ 'base' => NULL, 'refs' => [], ], 'RecordHandlerProgressOutput' => [ 'base' => NULL, 'refs' => [], ], 'Region' => [ 'base' => NULL, 'refs' => [ 'DescribeStackInstanceInput$StackInstanceRegion' => '<p>The name of a Region that\'s associated with this stack instance.</p>', 'ListStackInstancesInput$StackInstanceRegion' => '<p>The name of the Region where you want to list stack instances. </p>', 'RegionList$member' => NULL, 'StackInstance$Region' => '<p>The name of the AWS Region that the stack instance is associated with.</p>', 'StackInstanceSummary$Region' => '<p>The name of the AWS Region that the stack instance is associated with.</p>', 'StackSetOperationResultSummary$Region' => '<p>The name of the AWS Region for this operation result.</p>', ], ], 'RegionList' => [ 'base' => NULL, 'refs' => [ 'CreateStackInstancesInput$Regions' => '<p>The names of one or more Regions where you want to create stack instances using the specified AWS account(s). </p>', 'DeleteStackInstancesInput$Regions' => '<p>The Regions where you want to delete stack set instances. </p>', 'StackSetOperationPreferences$RegionOrder' => '<p>The order of the Regions in where you want to perform the stack operation.</p>', 'UpdateStackInstancesInput$Regions' => '<p>The names of one or more Regions in which you want to update parameter values for stack instances. The overridden parameter values will be applied to all stack instances in the specified accounts and Regions.</p>', 'UpdateStackSetInput$Regions' => '<p>The Regions in which to update associated stack instances. If you specify Regions, you must also specify accounts in which to update stack set instances.</p> <p>To update <i>all</i> the stack instances associated with this stack set, do not specify the <code>Accounts</code> or <code>Regions</code> properties.</p> <p>If the stack set update includes changes to the template (that is, if the <code>TemplateBody</code> or <code>TemplateURL</code> properties are specified), or the <code>Parameters</code> property, AWS CloudFormation marks all stack instances with a status of <code>OUTDATED</code> prior to updating the stack instances in the specified accounts and Regions. If the stack set update does not include changes to the template or parameters, AWS CloudFormation updates the stack instances in the specified accounts and Regions, while leaving all other stack instances with their existing stack instance status. </p>', ], ], 'RegisterTypeInput' => [ 'base' => NULL, 'refs' => [], ], 'RegisterTypeOutput' => [ 'base' => NULL, 'refs' => [], ], 'RegistrationStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeTypeRegistrationOutput$ProgressStatus' => '<p>The current status of the type registration request.</p>', 'ListTypeRegistrationsInput$RegistrationStatusFilter' => '<p>The current status of the type registration request.</p> <p>The default is <code>IN_PROGRESS</code>.</p>', ], ], 'RegistrationToken' => [ 'base' => NULL, 'refs' => [ 'DescribeTypeRegistrationInput$RegistrationToken' => '<p>The identifier for this registration request.</p> <p>This registration token is generated by CloudFormation when you initiate a registration request using <code> <a>RegisterType</a> </code>.</p>', 'RegisterTypeOutput$RegistrationToken' => '<p>The identifier for this registration request.</p> <p>Use this registration token when calling <code> <a>DescribeTypeRegistration</a> </code>, which returns information about the status and IDs of the type registration. </p>', 'RegistrationTokenList$member' => NULL, ], ], 'RegistrationTokenList' => [ 'base' => NULL, 'refs' => [ 'ListTypeRegistrationsOutput$RegistrationTokenList' => '<p> A list of type registration tokens.</p> <p>Use <code> <a>DescribeTypeRegistration</a> </code> to return detailed information about a type registration request.</p>', ], ], 'RegistryType' => [ 'base' => NULL, 'refs' => [ 'DeregisterTypeInput$Type' => '<p>The kind of type.</p> <p>Currently the only valid value is <code>RESOURCE</code>.</p> <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.</p>', 'DescribeTypeInput$Type' => '<p>The kind of type. </p> <p>Currently the only valid value is <code>RESOURCE</code>.</p> <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.</p>', 'DescribeTypeOutput$Type' => '<p>The kind of type. </p> <p>Currently the only valid value is <code>RESOURCE</code>.</p>', 'ListTypeRegistrationsInput$Type' => '<p>The kind of type.</p> <p>Currently the only valid value is <code>RESOURCE</code>.</p> <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.</p>', 'ListTypeVersionsInput$Type' => '<p>The kind of the type.</p> <p>Currently the only valid value is <code>RESOURCE</code>.</p> <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.</p>', 'RegisterTypeInput$Type' => '<p>The kind of type.</p> <p>Currently, the only valid value is <code>RESOURCE</code>.</p>', 'SetTypeDefaultVersionInput$Type' => '<p>The kind of type.</p> <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.</p>', 'TypeSummary$Type' => '<p>The kind of type.</p>', 'TypeVersionSummary$Type' => '<p>The kind of type.</p>', ], ], 'Replacement' => [ 'base' => NULL, 'refs' => [ 'ResourceChange$Replacement' => '<p>For the <code>Modify</code> action, indicates whether AWS CloudFormation will replace the resource by creating a new one and deleting the old one. This value depends on the value of the <code>RequiresRecreation</code> property in the <code>ResourceTargetDefinition</code> structure. For example, if the <code>RequiresRecreation</code> field is <code>Always</code> and the <code>Evaluation</code> field is <code>Static</code>, <code>Replacement</code> is <code>True</code>. If the <code>RequiresRecreation</code> field is <code>Always</code> and the <code>Evaluation</code> field is <code>Dynamic</code>, <code>Replacement</code> is <code>Conditionally</code>.</p> <p>If you have multiple changes with different <code>RequiresRecreation</code> values, the <code>Replacement</code> value depends on the change with the most impact. A <code>RequiresRecreation</code> value of <code>Always</code> has the most impact, followed by <code>Conditionally</code>, and then <code>Never</code>.</p>', ], ], 'RequestToken' => [ 'base' => NULL, 'refs' => [ 'RegisterTypeInput$ClientRequestToken' => '<p>A unique identifier that acts as an idempotency key for this registration request. Specifying a client request token prevents CloudFormation from generating more than one version of a type from the same registeration request, even if the request is submitted multiple times. </p>', ], ], 'RequiresRecreation' => [ 'base' => NULL, 'refs' => [ 'ResourceTargetDefinition$RequiresRecreation' => '<p>If the <code>Attribute</code> value is <code>Properties</code>, indicates whether a change to this property causes the resource to be recreated. The value can be <code>Never</code>, <code>Always</code>, or <code>Conditionally</code>. To determine the conditions for a <code>Conditionally</code> recreation, see the update behavior for that <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">property</a> in the AWS CloudFormation User Guide.</p>', ], ], 'ResourceAttribute' => [ 'base' => NULL, 'refs' => [ 'ResourceTargetDefinition$Attribute' => '<p>Indicates which resource attribute is triggering this update, such as a change in the resource attribute\'s <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.</p>', 'Scope$member' => NULL, ], ], 'ResourceChange' => [ 'base' => '<p>The <code>ResourceChange</code> structure describes the resource and the action that AWS CloudFormation will perform on it if you execute this change set.</p>', 'refs' => [ 'Change$ResourceChange' => '<p>A <code>ResourceChange</code> structure that describes the resource and action that AWS CloudFormation will perform.</p>', ], ], 'ResourceChangeDetail' => [ 'base' => '<p>For a resource with <code>Modify</code> as the action, the <code>ResourceChange</code> structure describes the changes AWS CloudFormation will make to that resource.</p>', 'refs' => [ 'ResourceChangeDetails$member' => NULL, ], ], 'ResourceChangeDetails' => [ 'base' => NULL, 'refs' => [ 'ResourceChange$Details' => '<p>For the <code>Modify</code> action, a list of <code>ResourceChangeDetail</code> structures that describes the changes that AWS CloudFormation will make to the resource. </p>', ], ], 'ResourceIdentifierProperties' => [ 'base' => NULL, 'refs' => [ 'ResourceToImport$ResourceIdentifier' => '<p>A key-value pair that identifies the target resource. The key is an identifier property (for example, <code>BucketName</code> for <code>AWS::S3::Bucket</code> resources) and the value is the actual property value (for example, <code>MyS3Bucket</code>).</p>', ], ], 'ResourceIdentifierPropertyKey' => [ 'base' => NULL, 'refs' => [ 'ResourceIdentifierProperties$key' => NULL, 'ResourceIdentifiers$member' => NULL, ], ], 'ResourceIdentifierPropertyValue' => [ 'base' => NULL, 'refs' => [ 'ResourceIdentifierProperties$value' => NULL, ], ], 'ResourceIdentifierSummaries' => [ 'base' => NULL, 'refs' => [ 'GetTemplateSummaryOutput$ResourceIdentifierSummaries' => '<p>A list of resource identifier summaries that describe the target resources of an import operation and the properties you can provide during the import to identify the target resources. For example, <code>BucketName</code> is a possible identifier property for an <code>AWS::S3::Bucket</code> resource. </p>', ], ], 'ResourceIdentifierSummary' => [ 'base' => '<p>Describes the target resources of a specific type in your import template (for example, all <code>AWS::S3::Bucket</code> resources) and the properties you can provide during the import to identify resources of that type.</p>', 'refs' => [ 'ResourceIdentifierSummaries$member' => NULL, ], ], 'ResourceIdentifiers' => [ 'base' => NULL, 'refs' => [ 'ResourceIdentifierSummary$ResourceIdentifiers' => '<p>The resource properties you can provide during the import to identify your target resources. For example, <code>BucketName</code> is a possible identifier property for <code>AWS::S3::Bucket</code> resources.</p>', ], ], 'ResourceModel' => [ 'base' => NULL, 'refs' => [ 'RecordHandlerProgressInput$ResourceModel' => '<p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>', ], ], 'ResourceProperties' => [ 'base' => NULL, 'refs' => [ 'StackEvent$ResourceProperties' => '<p>BLOB of the properties used to create the resource.</p>', ], ], 'ResourceSignalStatus' => [ 'base' => NULL, 'refs' => [ 'SignalResourceInput$Status' => '<p>The status of the signal, which is either success or failure. A failure signal causes AWS CloudFormation to immediately fail the stack creation or update.</p>', ], ], 'ResourceSignalUniqueId' => [ 'base' => NULL, 'refs' => [ 'SignalResourceInput$UniqueId' => '<p>A unique ID of the signal. When you signal Amazon EC2 instances or Auto Scaling groups, specify the instance ID that you are signaling as the unique ID. If you send multiple signals to a single resource (such as signaling a wait condition), each signal requires a different unique ID.</p>', ], ], 'ResourceStatus' => [ 'base' => NULL, 'refs' => [ 'StackEvent$ResourceStatus' => '<p>Current status of the resource.</p>', 'StackResource$ResourceStatus' => '<p>Current status of the resource.</p>', 'StackResourceDetail$ResourceStatus' => '<p>Current status of the resource.</p>', 'StackResourceSummary$ResourceStatus' => '<p>Current status of the resource.</p>', ], ], 'ResourceStatusReason' => [ 'base' => NULL, 'refs' => [ 'StackEvent$ResourceStatusReason' => '<p>Success/failure message associated with the resource.</p>', 'StackResource$ResourceStatusReason' => '<p>Success/failure message associated with the resource.</p>', 'StackResourceDetail$ResourceStatusReason' => '<p>Success/failure message associated with the resource.</p>', 'StackResourceSummary$ResourceStatusReason' => '<p>Success/failure message associated with the resource.</p>', ], ], 'ResourceTargetDefinition' => [ 'base' => '<p>The field that AWS CloudFormation will change, such as the name of a resource\'s property, and whether the resource will be recreated.</p>', 'refs' => [ 'ResourceChangeDetail$Target' => '<p>A <code>ResourceTargetDefinition</code> structure that describes the field that AWS CloudFormation will change and whether the resource will be recreated.</p>', ], ], 'ResourceToImport' => [ 'base' => '<p>Describes the target resource of an import operation.</p>', 'refs' => [ 'ResourcesToImport$member' => NULL, ], ], 'ResourceToSkip' => [ 'base' => NULL, 'refs' => [ 'ResourcesToSkip$member' => NULL, ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ResourceChange$ResourceType' => '<p>The type of AWS CloudFormation resource, such as <code>AWS::S3::Bucket</code>.</p>', 'ResourceIdentifierSummary$ResourceType' => '<p>The template resource type of the target resources, such as <code>AWS::S3::Bucket</code>.</p>', 'ResourceToImport$ResourceType' => '<p>The type of resource to import into your stack, such as <code>AWS::S3::Bucket</code>. For a list of supported resource types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html">Resources that support import operations</a> in the AWS CloudFormation User Guide.</p>', 'ResourceTypes$member' => NULL, 'StackEvent$ResourceType' => '<p>Type of resource. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"> AWS Resource Types Reference</a> in the AWS CloudFormation User Guide.)</p>', 'StackResource$ResourceType' => '<p>Type of resource. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"> AWS Resource Types Reference</a> in the AWS CloudFormation User Guide.)</p>', 'StackResourceDetail$ResourceType' => '<p>Type of resource. ((For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"> AWS Resource Types Reference</a> in the AWS CloudFormation User Guide.)</p>', 'StackResourceDrift$ResourceType' => '<p>The type of the resource.</p>', 'StackResourceSummary$ResourceType' => '<p>Type of resource. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"> AWS Resource Types Reference</a> in the AWS CloudFormation User Guide.)</p>', ], ], 'ResourceTypes' => [ 'base' => NULL, 'refs' => [ 'CreateChangeSetInput$ResourceTypes' => '<p>The template resource types that you have permissions to work with if you execute this change set, such as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>.</p> <p>If the list of resource types doesn\'t include a resource type that you\'re updating, the stack update fails. By default, AWS CloudFormation grants permissions to all resource types. AWS Identity and Access Management (IAM) uses this parameter for condition keys in IAM policies for AWS CloudFormation. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling Access with AWS Identity and Access Management</a> in the AWS CloudFormation User Guide.</p>', 'CreateStackInput$ResourceTypes' => '<p>The template resource types that you have permissions to work with for this create stack action, such as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>. Use the following syntax to describe template resource types: <code>AWS::*</code> (for all AWS resource), <code>Custom::*</code> (for all custom resources), <code>Custom::<i>logical_ID</i> </code> (for a specific custom resource), <code>AWS::<i>service_name</i>::*</code> (for all resources of a particular AWS service), and <code>AWS::<i>service_name</i>::<i>resource_logical_ID</i> </code> (for a specific AWS resource).</p> <p>If the list of resource types doesn\'t include a resource that you\'re creating, the stack creation fails. By default, AWS CloudFormation grants permissions to all resource types. AWS Identity and Access Management (IAM) uses this parameter for AWS CloudFormation-specific condition keys in IAM policies. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling Access with AWS Identity and Access Management</a>.</p>', 'GetTemplateSummaryOutput$ResourceTypes' => '<p>A list of all the template resource types that are defined in the template, such as <code>AWS::EC2::Instance</code>, <code>AWS::Dynamo::Table</code>, and <code>Custom::MyCustomInstance</code>.</p>', 'UpdateStackInput$ResourceTypes' => '<p>The template resource types that you have permissions to work with for this update stack action, such as <code>AWS::EC2::Instance</code>, <code>AWS::EC2::*</code>, or <code>Custom::MyCustomInstance</code>.</p> <p>If the list of resource types doesn\'t include a resource that you\'re updating, the stack update fails. By default, AWS CloudFormation grants permissions to all resource types. AWS Identity and Access Management (IAM) uses this parameter for AWS CloudFormation-specific condition keys in IAM policies. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html">Controlling Access with AWS Identity and Access Management</a>.</p>', ], ], 'ResourcesToImport' => [ 'base' => NULL, 'refs' => [ 'CreateChangeSetInput$ResourcesToImport' => '<p>The resources to import into your stack.</p>', ], ], 'ResourcesToSkip' => [ 'base' => NULL, 'refs' => [ 'ContinueUpdateRollbackInput$ResourcesToSkip' => '<p>A list of the logical IDs of the resources that AWS CloudFormation skips during the continue update rollback operation. You can specify only resources that are in the <code>UPDATE_FAILED</code> state because a rollback failed. You can\'t specify resources that are in the <code>UPDATE_FAILED</code> state for other reasons, for example, because an update was cancelled. To check why a resource update failed, use the <a>DescribeStackResources</a> action, and view the resource status reason. </p> <important> <p>Specify this property to skip rolling back resources that AWS CloudFormation can\'t successfully roll back. We recommend that you <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed"> troubleshoot</a> resources before skipping them. AWS CloudFormation sets the status of the specified resources to <code>UPDATE_COMPLETE</code> and continues to roll back the stack. After the rollback is complete, the state of the skipped resources will be inconsistent with the state of the resources in the stack template. Before performing another stack update, you must update the stack or resources to be consistent with each other. If you don\'t, subsequent stack updates might fail, and the stack will become unrecoverable. </p> </important> <p>Specify the minimum number of resources required to successfully roll back your stack. For example, a failed resource update might cause dependent resources to fail. In this case, it might not be necessary to skip the dependent resources. </p> <p>To skip resources that are part of nested stacks, use the following format: <code>NestedStackName.ResourceLogicalID</code>. If you want to specify the logical ID of a stack resource (<code>Type: AWS::CloudFormation::Stack</code>) in the <code>ResourcesToSkip</code> list, then its corresponding embedded stack must be in one of the following states: <code>DELETE_IN_PROGRESS</code>, <code>DELETE_COMPLETE</code>, or <code>DELETE_FAILED</code>. </p> <note> <p>Don\'t confuse a child stack\'s name with its corresponding logical ID defined in the parent stack. For an example of a continue update rollback operation with nested stacks, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html#nested-stacks">Using ResourcesToSkip to recover a nested stacks hierarchy</a>. </p> </note>', ], ], 'RetainResources' => [ 'base' => NULL, 'refs' => [ 'DeleteStackInput$RetainResources' => '<p>For stacks in the <code>DELETE_FAILED</code> state, a list of resource logical IDs that are associated with the resources you want to retain. During deletion, AWS CloudFormation deletes the stack but does not delete the retained resources.</p> <p>Retaining resources is useful when you cannot delete a resource, such as a non-empty S3 bucket, but you want to delete the stack.</p>', ], ], 'RetainStacks' => [ 'base' => NULL, 'refs' => [ 'DeleteStackInstancesInput$RetainStacks' => '<p>Removes the stack instances from the specified stack set, but doesn\'t delete the stacks. You can\'t reassociate a retained stack or add an existing, saved stack to a new stack set.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options">Stack set operation options</a>.</p>', ], ], 'RetainStacksNullable' => [ 'base' => NULL, 'refs' => [ 'StackSetOperation$RetainStacks' => '<p>For stack set operations of action type <code>DELETE</code>, specifies whether to remove the stack instances from the specified stack set, but doesn\'t delete the stacks. You can\'t reassociate a retained stack, or add an existing, saved stack to a new stack set.</p>', ], ], 'RetainStacksOnAccountRemovalNullable' => [ 'base' => NULL, 'refs' => [ 'AutoDeployment$RetainStacksOnAccountRemoval' => '<p>If set to <code>true</code>, stack resources are retained when an account is removed from a target organization or OU. If set to <code>false</code>, stack resources are deleted. Specify only if <code>Enabled</code> is set to <code>True</code>.</p>', ], ], 'RoleARN' => [ 'base' => NULL, 'refs' => [ 'ContinueUpdateRollbackInput$RoleARN' => '<p>The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS CloudFormation assumes to roll back the stack. AWS CloudFormation uses the role\'s credentials to make calls on your behalf. AWS CloudFormation always uses this role for all future operations on the stack. As long as users have permission to operate on the stack, AWS CloudFormation uses this role even if the users don\'t have permission to pass it. Ensure that the role grants least privilege.</p> <p>If you don\'t specify a value, AWS CloudFormation uses the role that was previously associated with the stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from your user credentials.</p>', 'CreateChangeSetInput$RoleARN' => '<p>The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS CloudFormation assumes when executing the change set. AWS CloudFormation uses the role\'s credentials to make calls on your behalf. AWS CloudFormation uses this role for all future operations on the stack. As long as users have permission to operate on the stack, AWS CloudFormation uses this role even if the users don\'t have permission to pass it. Ensure that the role grants least privilege.</p> <p>If you don\'t specify a value, AWS CloudFormation uses the role that was previously associated with the stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from your user credentials.</p>', 'CreateStackInput$RoleARN' => '<p>The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS CloudFormation assumes to create the stack. AWS CloudFormation uses the role\'s credentials to make calls on your behalf. AWS CloudFormation always uses this role for all future operations on the stack. As long as users have permission to operate on the stack, AWS CloudFormation uses this role even if the users don\'t have permission to pass it. Ensure that the role grants least privilege.</p> <p>If you don\'t specify a value, AWS CloudFormation uses the role that was previously associated with the stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from your user credentials.</p>', 'CreateStackSetInput$AdministrationRoleARN' => '<p>The Amazon Resource Number (ARN) of the IAM role to use to create this stack set. </p> <p>Specify an IAM role only if you are using customized administrator roles to control which users or groups can manage specific stack sets within the same administrator account. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Prerequisites: Granting Permissions for Stack Set Operations</a> in the <i>AWS CloudFormation User Guide</i>.</p>', 'DeleteStackInput$RoleARN' => '<p>The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS CloudFormation assumes to delete the stack. AWS CloudFormation uses the role\'s credentials to make calls on your behalf.</p> <p>If you don\'t specify a value, AWS CloudFormation uses the role that was previously associated with the stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from your user credentials.</p>', 'Stack$RoleARN' => '<p>The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that is associated with the stack. During a stack operation, AWS CloudFormation uses this role\'s credentials to make calls on your behalf.</p>', 'StackSet$AdministrationRoleARN' => '<p>The Amazon Resource Number (ARN) of the IAM role used to create or update the stack set.</p> <p>Use customized administrator roles to control which users or groups can manage specific stack sets within the same administrator account. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Prerequisites: Granting Permissions for Stack Set Operations</a> in the <i>AWS CloudFormation User Guide</i>.</p>', 'StackSetOperation$AdministrationRoleARN' => '<p>The Amazon Resource Number (ARN) of the IAM role used to perform this stack set operation. </p> <p>Use customized administrator roles to control which users or groups can manage specific stack sets within the same administrator account. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Define Permissions for Multiple Administrators</a> in the <i>AWS CloudFormation User Guide</i>.</p>', 'UpdateStackInput$RoleARN' => '<p>The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM) role that AWS CloudFormation assumes to update the stack. AWS CloudFormation uses the role\'s credentials to make calls on your behalf. AWS CloudFormation always uses this role for all future operations on the stack. As long as users have permission to operate on the stack, AWS CloudFormation uses this role even if the users don\'t have permission to pass it. Ensure that the role grants least privilege.</p> <p>If you don\'t specify a value, AWS CloudFormation uses the role that was previously associated with the stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from your user credentials.</p>', 'UpdateStackSetInput$AdministrationRoleARN' => '<p>The Amazon Resource Number (ARN) of the IAM role to use to update this stack set.</p> <p>Specify an IAM role only if you are using customized administrator roles to control which users or groups can manage specific stack sets within the same administrator account. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Granting Permissions for Stack Set Operations</a> in the <i>AWS CloudFormation User Guide</i>.</p> <p>If you specified a customized administrator role when you created the stack set, you must specify a customized administrator role, even if it is the same customized administrator role used with this stack set previously.</p>', ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'DescribeTypeOutput$ExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM execution role used to register the type. If your resource type calls AWS APIs in any of its handlers, you must create an <i> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM execution role</a> </i> that includes the necessary permissions to call those AWS APIs, and provision that execution role in your account. CloudFormation then assumes that execution role to provide your resource type with the appropriate credentials.</p>', 'LoggingConfig$LogRoleArn' => '<p>The ARN of the role that CloudFormation should assume when sending log entries to CloudWatch logs.</p>', 'RegisterTypeInput$ExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role for CloudFormation to assume when invoking the resource provider. If your resource type calls AWS APIs in any of its handlers, you must create an <i> <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM execution role</a> </i> that includes the necessary permissions to call those AWS APIs, and provision that execution role in your account. When CloudFormation needs to invoke the resource provider handler, CloudFormation assumes this execution role to create a temporary session token, which it then passes to the resource provider handler, thereby supplying your resource provider with the appropriate credentials.</p>', ], ], 'RollbackConfiguration' => [ 'base' => '<p>Structure containing the rollback triggers for AWS CloudFormation to monitor during stack creation and updating operations, and for the specified monitoring period afterwards.</p> <p>Rollback triggers enable you to have AWS CloudFormation monitor the state of your application during stack creation and updating, and to roll back that operation if the application breaches the threshold of any of the alarms you\'ve specified. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-rollback-triggers.html">Monitor and Roll Back Stack Operations</a>.</p>', 'refs' => [ 'CreateChangeSetInput$RollbackConfiguration' => '<p>The rollback triggers for AWS CloudFormation to monitor during stack creation and updating operations, and for the specified monitoring period afterwards.</p>', 'CreateStackInput$RollbackConfiguration' => '<p>The rollback triggers for AWS CloudFormation to monitor during stack creation and updating operations, and for the specified monitoring period afterwards.</p>', 'DescribeChangeSetOutput$RollbackConfiguration' => '<p>The rollback triggers for AWS CloudFormation to monitor during stack creation and updating operations, and for the specified monitoring period afterwards.</p>', 'Stack$RollbackConfiguration' => '<p>The rollback triggers for AWS CloudFormation to monitor during stack creation and updating operations, and for the specified monitoring period afterwards.</p>', 'UpdateStackInput$RollbackConfiguration' => '<p>The rollback triggers for AWS CloudFormation to monitor during stack creation and updating operations, and for the specified monitoring period afterwards.</p>', ], ], 'RollbackTrigger' => [ 'base' => '<p>A rollback trigger AWS CloudFormation monitors during creation and updating of stacks. If any of the alarms you specify goes to ALARM state during the stack operation or within the specified monitoring period afterwards, CloudFormation rolls back the entire stack operation. </p>', 'refs' => [ 'RollbackTriggers$member' => NULL, ], ], 'RollbackTriggers' => [ 'base' => NULL, 'refs' => [ 'RollbackConfiguration$RollbackTriggers' => '<p>The triggers to monitor during stack creation or update actions. </p> <p>By default, AWS CloudFormation saves the rollback triggers specified for a stack and applies them to any subsequent update operations for the stack, unless you specify otherwise. If you do specify rollback triggers for this parameter, those triggers replace any list of triggers previously specified for the stack. This means:</p> <ul> <li> <p>To use the rollback triggers previously specified for this stack, if any, don\'t specify this parameter.</p> </li> <li> <p>To specify new or updated rollback triggers, you must specify <i>all</i> the triggers that you want used for this stack, even triggers you\'ve specifed before (for example, when creating the stack or during a previous stack update). Any triggers that you don\'t include in the updated list of triggers are no longer applied to the stack.</p> </li> <li> <p>To remove all currently specified triggers, specify an empty list for this parameter.</p> </li> </ul> <p>If a specified trigger is missing, the entire stack operation fails and is rolled back. </p>', ], ], 'S3Url' => [ 'base' => NULL, 'refs' => [ 'RegisterTypeInput$SchemaHandlerPackage' => '<p>A url to the S3 bucket containing the schema handler package that contains the schema, event handlers, and associated files for the type you want to register.</p> <p>For information on generating a schema handler package for the type you want to register, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-cli-submit.html">submit</a> in the <i>CloudFormation CLI User Guide</i>.</p> <note> <p>As part of registering a resource provider type, CloudFormation must be able to access the S3 bucket which contains the schema handler package for that resource provider. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry.html#registry-register-permissions">IAM Permissions for Registering a Resource Provider</a> in the <i>AWS CloudFormation User Guide</i>.</p> </note>', ], ], 'Scope' => [ 'base' => NULL, 'refs' => [ 'ResourceChange$Scope' => '<p>For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such as a change in the resource attribute\'s <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.</p>', ], ], 'SetStackPolicyInput' => [ 'base' => '<p>The input for the <a>SetStackPolicy</a> action.</p>', 'refs' => [], ], 'SetTypeDefaultVersionInput' => [ 'base' => NULL, 'refs' => [], ], 'SetTypeDefaultVersionOutput' => [ 'base' => NULL, 'refs' => [], ], 'SignalResourceInput' => [ 'base' => '<p>The input for the <a>SignalResource</a> action.</p>', 'refs' => [], ], 'Stack' => [ 'base' => '<p>The Stack data type.</p>', 'refs' => [ 'Stacks$member' => NULL, ], ], 'StackDriftDetectionId' => [ 'base' => NULL, 'refs' => [ 'DescribeStackDriftDetectionStatusInput$StackDriftDetectionId' => '<p>The ID of the drift detection results of this operation. </p> <p>AWS CloudFormation generates new results, with a new drift detection ID, each time this operation is run. However, the number of drift results AWS CloudFormation retains for any given stack, and for how long, may vary. </p>', 'DescribeStackDriftDetectionStatusOutput$StackDriftDetectionId' => '<p>The ID of the drift detection results of this operation. </p> <p>AWS CloudFormation generates new results, with a new drift detection ID, each time this operation is run. However, the number of reports AWS CloudFormation retains for any given stack, and for how long, may vary.</p>', 'DetectStackDriftOutput$StackDriftDetectionId' => '<p>The ID of the drift detection results of this operation. </p> <p>AWS CloudFormation generates new results, with a new drift detection ID, each time this operation is run. However, the number of drift results AWS CloudFormation retains for any given stack, and for how long, may vary. </p>', ], ], 'StackDriftDetectionStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeStackDriftDetectionStatusOutput$DetectionStatus' => '<p>The status of the stack drift detection operation.</p> <ul> <li> <p> <code>DETECTION_COMPLETE</code>: The stack drift detection operation has successfully completed for all resources in the stack that support drift detection. (Resources that do not currently support stack detection remain unchecked.)</p> <p>If you specified logical resource IDs for AWS CloudFormation to use as a filter for the stack drift detection operation, only the resources with those logical IDs are checked for drift.</p> </li> <li> <p> <code>DETECTION_FAILED</code>: The stack drift detection operation has failed for at least one resource in the stack. Results will be available for resources on which AWS CloudFormation successfully completed drift detection.</p> </li> <li> <p> <code>DETECTION_IN_PROGRESS</code>: The stack drift detection operation is currently in progress.</p> </li> </ul>', ], ], 'StackDriftDetectionStatusReason' => [ 'base' => NULL, 'refs' => [ 'DescribeStackDriftDetectionStatusOutput$DetectionStatusReason' => '<p>The reason the stack drift detection operation has its current status.</p>', ], ], 'StackDriftInformation' => [ 'base' => '<p>Contains information about whether the stack\'s actual configuration differs, or has <i>drifted</i>, from its expected configuration, as defined in the stack template and any values specified as template parameters. A stack is considered to have drifted if one or more of its resources have drifted.</p>', 'refs' => [ 'Stack$DriftInformation' => '<p>Information on whether a stack\'s actual configuration differs, or has <i>drifted</i>, from it\'s expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p>', ], ], 'StackDriftInformationSummary' => [ 'base' => '<p>Contains information about whether the stack\'s actual configuration differs, or has <i>drifted</i>, from its expected configuration, as defined in the stack template and any values specified as template parameters. A stack is considered to have drifted if one or more of its resources have drifted.</p>', 'refs' => [ 'StackSummary$DriftInformation' => '<p>Summarizes information on whether a stack\'s actual configuration differs, or has <i>drifted</i>, from it\'s expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p>', ], ], 'StackDriftStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeStackDriftDetectionStatusOutput$StackDriftStatus' => '<p>Status of the stack\'s actual configuration compared to its expected configuration. </p> <ul> <li> <p> <code>DRIFTED</code>: The stack differs from its expected template configuration. A stack is considered to have drifted if one or more of its resources have drifted.</p> </li> <li> <p> <code>NOT_CHECKED</code>: AWS CloudFormation has not checked if the stack differs from its expected template configuration.</p> </li> <li> <p> <code>IN_SYNC</code>: The stack\'s actual configuration matches its expected template configuration.</p> </li> <li> <p> <code>UNKNOWN</code>: This value is reserved for future use.</p> </li> </ul>', 'StackDriftInformation$StackDriftStatus' => '<p>Status of the stack\'s actual configuration compared to its expected template configuration. </p> <ul> <li> <p> <code>DRIFTED</code>: The stack differs from its expected template configuration. A stack is considered to have drifted if one or more of its resources have drifted.</p> </li> <li> <p> <code>NOT_CHECKED</code>: AWS CloudFormation has not checked if the stack differs from its expected template configuration.</p> </li> <li> <p> <code>IN_SYNC</code>: The stack\'s actual configuration matches its expected template configuration.</p> </li> <li> <p> <code>UNKNOWN</code>: This value is reserved for future use.</p> </li> </ul>', 'StackDriftInformationSummary$StackDriftStatus' => '<p>Status of the stack\'s actual configuration compared to its expected template configuration. </p> <ul> <li> <p> <code>DRIFTED</code>: The stack differs from its expected template configuration. A stack is considered to have drifted if one or more of its resources have drifted.</p> </li> <li> <p> <code>NOT_CHECKED</code>: AWS CloudFormation has not checked if the stack differs from its expected template configuration.</p> </li> <li> <p> <code>IN_SYNC</code>: The stack\'s actual configuration matches its expected template configuration.</p> </li> <li> <p> <code>UNKNOWN</code>: This value is reserved for future use.</p> </li> </ul>', 'StackInstance$DriftStatus' => '<p>Status of the stack instance\'s actual configuration compared to the expected template and parameter configuration of the stack set to which it belongs. </p> <ul> <li> <p> <code>DRIFTED</code>: The stack differs from the expected template and parameter configuration of the stack set to which it belongs. A stack instance is considered to have drifted if one or more of the resources in the associated stack have drifted.</p> </li> <li> <p> <code>NOT_CHECKED</code>: AWS CloudFormation has not checked if the stack instance differs from its expected stack set configuration.</p> </li> <li> <p> <code>IN_SYNC</code>: The stack instance\'s actual configuration matches its expected stack set configuration.</p> </li> <li> <p> <code>UNKNOWN</code>: This value is reserved for future use.</p> </li> </ul>', 'StackInstanceSummary$DriftStatus' => '<p>Status of the stack instance\'s actual configuration compared to the expected template and parameter configuration of the stack set to which it belongs. </p> <ul> <li> <p> <code>DRIFTED</code>: The stack differs from the expected template and parameter configuration of the stack set to which it belongs. A stack instance is considered to have drifted if one or more of the resources in the associated stack have drifted.</p> </li> <li> <p> <code>NOT_CHECKED</code>: AWS CloudFormation has not checked if the stack instance differs from its expected stack set configuration.</p> </li> <li> <p> <code>IN_SYNC</code>: The stack instance\'s actual configuration matches its expected stack set configuration.</p> </li> <li> <p> <code>UNKNOWN</code>: This value is reserved for future use.</p> </li> </ul>', 'StackSetSummary$DriftStatus' => '<p>Status of the stack set\'s actual configuration compared to its expected template and parameter configuration. A stack set is considered to have drifted if one or more of its stack instances have drifted from their expected template and parameter configuration.</p> <ul> <li> <p> <code>DRIFTED</code>: One or more of the stack instances belonging to the stack set stack differs from the expected template and parameter configuration. A stack instance is considered to have drifted if one or more of the resources in the associated stack have drifted.</p> </li> <li> <p> <code>NOT_CHECKED</code>: AWS CloudFormation has not checked the stack set for drift.</p> </li> <li> <p> <code>IN_SYNC</code>: All of the stack instances belonging to the stack set stack match from the expected template and parameter configuration.</p> </li> <li> <p> <code>UNKNOWN</code>: This value is reserved for future use.</p> </li> </ul>', ], ], 'StackEvent' => [ 'base' => '<p>The StackEvent data type.</p>', 'refs' => [ 'StackEvents$member' => NULL, ], ], 'StackEvents' => [ 'base' => NULL, 'refs' => [ 'DescribeStackEventsOutput$StackEvents' => '<p>A list of <code>StackEvents</code> structures.</p>', ], ], 'StackId' => [ 'base' => NULL, 'refs' => [ 'ChangeSetSummary$StackId' => '<p>The ID of the stack with which the change set is associated.</p>', 'CreateChangeSetOutput$StackId' => '<p>The unique ID of the stack.</p>', 'CreateStackOutput$StackId' => '<p>Unique identifier of the stack.</p>', 'DescribeChangeSetOutput$StackId' => '<p>The ARN of the stack that is associated with the change set.</p>', 'DescribeStackDriftDetectionStatusOutput$StackId' => '<p>The ID of the stack.</p>', 'Export$ExportingStackId' => '<p>The stack that contains the exported output name and value.</p>', 'Stack$StackId' => '<p>Unique identifier of the stack.</p>', 'Stack$ParentId' => '<p>For nested stacks--stacks created as resources for another stack--the stack ID of the direct parent of this stack. For the first level of nested stacks, the root stack is also the parent stack.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Working with Nested Stacks</a> in the <i>AWS CloudFormation User Guide</i>.</p>', 'Stack$RootId' => '<p>For nested stacks--stacks created as resources for another stack--the stack ID of the top-level stack to which the nested stack ultimately belongs.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Working with Nested Stacks</a> in the <i>AWS CloudFormation User Guide</i>.</p>', 'StackEvent$StackId' => '<p>The unique ID name of the instance of the stack.</p>', 'StackInstance$StackId' => '<p>The ID of the stack instance.</p>', 'StackInstanceSummary$StackId' => '<p>The ID of the stack instance.</p>', 'StackResource$StackId' => '<p>Unique identifier of the stack.</p>', 'StackResourceDetail$StackId' => '<p>Unique identifier of the stack.</p>', 'StackResourceDrift$StackId' => '<p>The ID of the stack.</p>', 'StackSummary$StackId' => '<p>Unique stack identifier.</p>', 'StackSummary$ParentId' => '<p>For nested stacks--stacks created as resources for another stack--the stack ID of the direct parent of this stack. For the first level of nested stacks, the root stack is also the parent stack.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Working with Nested Stacks</a> in the <i>AWS CloudFormation User Guide</i>.</p>', 'StackSummary$RootId' => '<p>For nested stacks--stacks created as resources for another stack--the stack ID of the top-level stack to which the nested stack ultimately belongs.</p> <p>For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Working with Nested Stacks</a> in the <i>AWS CloudFormation User Guide</i>.</p>', 'UpdateStackOutput$StackId' => '<p>Unique identifier of the stack.</p>', 'UpdateTerminationProtectionOutput$StackId' => '<p>The unique ID of the stack.</p>', ], ], 'StackInstance' => [ 'base' => '<p>An AWS CloudFormation stack, in a specific account and Region, that\'s part of a stack set operation. A stack instance is a reference to an attempted or actual stack in a given account within a given Region. A stack instance can exist without a stack—for example, if the stack couldn\'t be created for some reason. A stack instance is associated with only one stack set. Each stack instance contains the ID of its associated stack set, as well as the ID of the actual stack and the stack status.</p>', 'refs' => [ 'DescribeStackInstanceOutput$StackInstance' => '<p>The stack instance that matches the specified request parameters.</p>', ], ], 'StackInstanceComprehensiveStatus' => [ 'base' => '<p>The detailed status of the stack instance.</p>', 'refs' => [ 'StackInstance$StackInstanceStatus' => '<p>The detailed status of the stack instance.</p>', 'StackInstanceSummary$StackInstanceStatus' => '<p>The detailed status of the stack instance.</p>', ], ], 'StackInstanceDetailedStatus' => [ 'base' => NULL, 'refs' => [ 'StackInstanceComprehensiveStatus$DetailedStatus' => '<ul> <li> <p> <code>CANCELLED</code>: The operation in the specified account and Region has been cancelled. This is either because a user has stopped the stack set operation, or because the failure tolerance of the stack set operation has been exceeded.</p> </li> <li> <p> <code>FAILED</code>: The operation in the specified account and Region failed. If the stack set operation fails in enough accounts within a Region, the failure tolerance for the stack set operation as a whole might be exceeded.</p> </li> <li> <p> <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to <code>true</code>, to delete the stack instance, and then delete the stack manually.</p> </li> <li> <p> <code>PENDING</code>: The operation in the specified account and Region has yet to start.</p> </li> <li> <p> <code>RUNNING</code>: The operation in the specified account and Region is currently in progress.</p> </li> <li> <p> <code>SUCCEEDED</code>: The operation in the specified account and Region completed successfully.</p> </li> </ul>', ], ], 'StackInstanceFilter' => [ 'base' => '<p>The status that stack instances are filtered by.</p>', 'refs' => [ 'StackInstanceFilters$member' => NULL, ], ], 'StackInstanceFilterName' => [ 'base' => NULL, 'refs' => [ 'StackInstanceFilter$Name' => '<p>The type of filter to apply.</p>', ], ], 'StackInstanceFilterValues' => [ 'base' => NULL, 'refs' => [ 'StackInstanceFilter$Values' => '<p>The status to filter by.</p>', ], ], 'StackInstanceFilters' => [ 'base' => NULL, 'refs' => [ 'ListStackInstancesInput$Filters' => '<p>The status that stack instances are filtered by.</p>', ], ], 'StackInstanceNotFoundException' => [ 'base' => '<p>The specified stack instance doesn\'t exist.</p>', 'refs' => [], ], 'StackInstanceStatus' => [ 'base' => NULL, 'refs' => [ 'StackInstance$Status' => '<p>The status of the stack instance, in terms of its synchronization with its associated stack set.</p> <ul> <li> <p> <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to <code>true</code>, to delete the stack instance, and then delete the stack manually.</p> </li> <li> <p> <code>OUTDATED</code>: The stack isn\'t currently up to date with the stack set because:</p> <ul> <li> <p>The associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation. </p> </li> <li> <p>The stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that failed or was stopped before the stack was created or updated. </p> </li> </ul> </li> <li> <p> <code>CURRENT</code>: The stack is currently up to date with the stack set.</p> </li> </ul>', 'StackInstanceSummary$Status' => '<p>The status of the stack instance, in terms of its synchronization with its associated stack set.</p> <ul> <li> <p> <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to <code>true</code>, to delete the stack instance, and then delete the stack manually.</p> </li> <li> <p> <code>OUTDATED</code>: The stack isn\'t currently up to date with the stack set because:</p> <ul> <li> <p>The associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation. </p> </li> <li> <p>The stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that failed or was stopped before the stack was created or updated. </p> </li> </ul> </li> <li> <p> <code>CURRENT</code>: The stack is currently up to date with the stack set.</p> </li> </ul>', ], ], 'StackInstanceSummaries' => [ 'base' => NULL, 'refs' => [ 'ListStackInstancesOutput$Summaries' => '<p>A list of <code>StackInstanceSummary</code> structures that contain information about the specified stack instances.</p>', ], ], 'StackInstanceSummary' => [ 'base' => '<p>The structure that contains summary information about a stack instance.</p>', 'refs' => [ 'StackInstanceSummaries$member' => NULL, ], ], 'StackName' => [ 'base' => NULL, 'refs' => [ 'CancelUpdateStackInput$StackName' => '<p>The name or the unique stack ID that is associated with the stack.</p>', 'ChangeSetSummary$StackName' => '<p>The name of the stack with which the change set is associated.</p>', 'CreateStackInput$StackName' => '<p>The name that is associated with the stack. The name must be unique in the Region in which you are creating the stack.</p> <note> <p>A stack name can contain only alphanumeric characters (case sensitive) and hyphens. It must start with an alphabetic character and cannot be longer than 128 characters.</p> </note>', 'DeleteStackInput$StackName' => '<p>The name or the unique stack ID that is associated with the stack.</p>', 'DescribeChangeSetOutput$StackName' => '<p>The name of the stack that is associated with the change set.</p>', 'DescribeStackEventsInput$StackName' => '<p>The name or the unique stack ID that is associated with the stack, which are not always interchangeable:</p> <ul> <li> <p>Running stacks: You can specify either the stack\'s name or its unique stack ID.</p> </li> <li> <p>Deleted stacks: You must specify the unique stack ID.</p> </li> </ul> <p>Default: There is no default value.</p>', 'DescribeStackResourceInput$StackName' => '<p>The name or the unique stack ID that is associated with the stack, which are not always interchangeable:</p> <ul> <li> <p>Running stacks: You can specify either the stack\'s name or its unique stack ID.</p> </li> <li> <p>Deleted stacks: You must specify the unique stack ID.</p> </li> </ul> <p>Default: There is no default value.</p>', 'DescribeStackResourcesInput$StackName' => '<p>The name or the unique stack ID that is associated with the stack, which are not always interchangeable:</p> <ul> <li> <p>Running stacks: You can specify either the stack\'s name or its unique stack ID.</p> </li> <li> <p>Deleted stacks: You must specify the unique stack ID.</p> </li> </ul> <p>Default: There is no default value.</p> <p>Required: Conditional. If you do not specify <code>StackName</code>, you must specify <code>PhysicalResourceId</code>.</p>', 'DescribeStacksInput$StackName' => '<p>The name or the unique stack ID that is associated with the stack, which are not always interchangeable:</p> <ul> <li> <p>Running stacks: You can specify either the stack\'s name or its unique stack ID.</p> </li> <li> <p>Deleted stacks: You must specify the unique stack ID.</p> </li> </ul> <p>Default: There is no default value.</p>', 'GetStackPolicyInput$StackName' => '<p>The name or unique stack ID that is associated with the stack whose policy you want to get.</p>', 'GetTemplateInput$StackName' => '<p>The name or the unique stack ID that is associated with the stack, which are not always interchangeable:</p> <ul> <li> <p>Running stacks: You can specify either the stack\'s name or its unique stack ID.</p> </li> <li> <p>Deleted stacks: You must specify the unique stack ID.</p> </li> </ul> <p>Default: There is no default value.</p>', 'Imports$member' => NULL, 'ListStackResourcesInput$StackName' => '<p>The name or the unique stack ID that is associated with the stack, which are not always interchangeable:</p> <ul> <li> <p>Running stacks: You can specify either the stack\'s name or its unique stack ID.</p> </li> <li> <p>Deleted stacks: You must specify the unique stack ID.</p> </li> </ul> <p>Default: There is no default value.</p>', 'SetStackPolicyInput$StackName' => '<p>The name or unique stack ID that you want to associate a policy with.</p>', 'Stack$StackName' => '<p>The name associated with the stack.</p>', 'StackEvent$StackName' => '<p>The name associated with a stack.</p>', 'StackResource$StackName' => '<p>The name associated with the stack.</p>', 'StackResourceDetail$StackName' => '<p>The name associated with the stack.</p>', 'StackSummary$StackName' => '<p>The name associated with the stack.</p>', 'UpdateStackInput$StackName' => '<p>The name or unique stack ID of the stack to update.</p>', ], ], 'StackNameOrId' => [ 'base' => NULL, 'refs' => [ 'ContinueUpdateRollbackInput$StackName' => '<p>The name or the unique ID of the stack that you want to continue rolling back.</p> <note> <p>Don\'t specify the name of a nested stack (a stack that was created by using the <code>AWS::CloudFormation::Stack</code> resource). Instead, use this operation on the parent stack (the stack that contains the <code>AWS::CloudFormation::Stack</code> resource).</p> </note>', 'CreateChangeSetInput$StackName' => '<p>The name or the unique ID of the stack for which you are creating a change set. AWS CloudFormation generates the change set by comparing this stack\'s information with the information that you submit, such as a modified template or different parameter input values.</p>', 'DeleteChangeSetInput$StackName' => '<p>If you specified the name of a change set to delete, specify the stack name or ID (ARN) that is associated with it.</p>', 'DescribeChangeSetInput$StackName' => '<p>If you specified the name of a change set, specify the stack name or ID (ARN) of the change set you want to describe.</p>', 'DescribeStackResourceDriftsInput$StackName' => '<p>The name of the stack for which you want drift information.</p>', 'DetectStackDriftInput$StackName' => '<p>The name of the stack for which you want to detect drift. </p>', 'DetectStackResourceDriftInput$StackName' => '<p>The name of the stack to which the resource belongs.</p>', 'ExecuteChangeSetInput$StackName' => '<p>If you specified the name of a change set, specify the stack name or ID (ARN) that is associated with the change set you want to execute.</p>', 'GetTemplateSummaryInput$StackName' => '<p>The name or the stack ID that is associated with the stack, which are not always interchangeable. For running stacks, you can specify either the stack\'s name or its unique stack ID. For deleted stack, you must specify the unique stack ID.</p> <p>Conditional: You must specify only one of the following parameters: <code>StackName</code>, <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.</p>', 'ListChangeSetsInput$StackName' => '<p>The name or the Amazon Resource Name (ARN) of the stack for which you want to list change sets.</p>', 'SignalResourceInput$StackName' => '<p>The stack name or unique stack ID that includes the resource that you want to signal.</p>', 'UpdateTerminationProtectionInput$StackName' => '<p>The name or unique ID of the stack for which you want to set termination protection.</p>', ], ], 'StackPolicyBody' => [ 'base' => NULL, 'refs' => [ 'CreateStackInput$StackPolicyBody' => '<p>Structure containing the stack policy body. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"> Prevent Updates to Stack Resources</a> in the <i>AWS CloudFormation User Guide</i>. You can specify either the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.</p>', 'GetStackPolicyOutput$StackPolicyBody' => '<p>Structure containing the stack policy body. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"> Prevent Updates to Stack Resources</a> in the AWS CloudFormation User Guide.)</p>', 'SetStackPolicyInput$StackPolicyBody' => '<p>Structure containing the stack policy body. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"> Prevent Updates to Stack Resources</a> in the AWS CloudFormation User Guide. You can specify either the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.</p>', 'UpdateStackInput$StackPolicyBody' => '<p>Structure containing a new stack policy body. You can specify either the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.</p> <p>You might update the stack policy, for example, in order to protect a new resource that you created during a stack update. If you do not specify a stack policy, the current policy that is associated with the stack is unchanged.</p>', ], ], 'StackPolicyDuringUpdateBody' => [ 'base' => NULL, 'refs' => [ 'UpdateStackInput$StackPolicyDuringUpdateBody' => '<p>Structure containing the temporary overriding stack policy body. You can specify either the <code>StackPolicyDuringUpdateBody</code> or the <code>StackPolicyDuringUpdateURL</code> parameter, but not both.</p> <p>If you want to update protected resources, specify a temporary overriding stack policy during this update. If you do not specify a stack policy, the current policy that is associated with the stack will be used.</p>', ], ], 'StackPolicyDuringUpdateURL' => [ 'base' => NULL, 'refs' => [ 'UpdateStackInput$StackPolicyDuringUpdateURL' => '<p>Location of a file containing the temporary overriding stack policy. The URL must point to a policy (max size: 16KB) located in an S3 bucket in the same Region as the stack. You can specify either the <code>StackPolicyDuringUpdateBody</code> or the <code>StackPolicyDuringUpdateURL</code> parameter, but not both.</p> <p>If you want to update protected resources, specify a temporary overriding stack policy during this update. If you do not specify a stack policy, the current policy that is associated with the stack will be used.</p>', ], ], 'StackPolicyURL' => [ 'base' => NULL, 'refs' => [ 'CreateStackInput$StackPolicyURL' => '<p>Location of a file containing the stack policy. The URL must point to a policy (maximum size: 16 KB) located in an S3 bucket in the same Region as the stack. You can specify either the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.</p>', 'SetStackPolicyInput$StackPolicyURL' => '<p>Location of a file containing the stack policy. The URL must point to a policy (maximum size: 16 KB) located in an S3 bucket in the same Region as the stack. You can specify either the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.</p>', 'UpdateStackInput$StackPolicyURL' => '<p>Location of a file containing the updated stack policy. The URL must point to a policy (max size: 16KB) located in an S3 bucket in the same Region as the stack. You can specify either the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.</p> <p>You might update the stack policy, for example, in order to protect a new resource that you created during a stack update. If you do not specify a stack policy, the current policy that is associated with the stack is unchanged.</p>', ], ], 'StackResource' => [ 'base' => '<p>The StackResource data type.</p>', 'refs' => [ 'StackResources$member' => NULL, ], ], 'StackResourceDetail' => [ 'base' => '<p>Contains detailed information about the specified stack resource.</p>', 'refs' => [ 'DescribeStackResourceOutput$StackResourceDetail' => '<p>A <code>StackResourceDetail</code> structure containing the description of the specified resource in the specified stack.</p>', ], ], 'StackResourceDrift' => [ 'base' => '<p>Contains the drift information for a resource that has been checked for drift. This includes actual and expected property values for resources in which AWS CloudFormation has detected drift. Only resource properties explicitly defined in the stack template are checked for drift. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p> <p>Resources that do not currently support drift detection cannot be checked. For a list of resources that support drift detection, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html">Resources that Support Drift Detection</a>.</p> <p>Use <a>DetectStackResourceDrift</a> to detect drift on individual resources, or <a>DetectStackDrift</a> to detect drift on all resources in a given stack that support drift detection.</p>', 'refs' => [ 'DetectStackResourceDriftOutput$StackResourceDrift' => '<p>Information about whether the resource\'s actual configuration has drifted from its expected template configuration, including actual and expected property values and any differences detected.</p>', 'StackResourceDrifts$member' => NULL, ], ], 'StackResourceDriftInformation' => [ 'base' => '<p>Contains information about whether the resource\'s actual configuration differs, or has <i>drifted</i>, from its expected configuration.</p>', 'refs' => [ 'StackResource$DriftInformation' => '<p>Information about whether the resource\'s actual configuration differs, or has <i>drifted</i>, from its expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p>', 'StackResourceDetail$DriftInformation' => '<p>Information about whether the resource\'s actual configuration differs, or has <i>drifted</i>, from its expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p>', ], ], 'StackResourceDriftInformationSummary' => [ 'base' => '<p>Summarizes information about whether the resource\'s actual configuration differs, or has <i>drifted</i>, from its expected configuration.</p>', 'refs' => [ 'StackResourceSummary$DriftInformation' => '<p>Information about whether the resource\'s actual configuration differs, or has <i>drifted</i>, from its expected configuration, as defined in the stack template and any values specified as template parameters. For more information, see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting Unregulated Configuration Changes to Stacks and Resources</a>.</p>', ], ], 'StackResourceDriftStatus' => [ 'base' => NULL, 'refs' => [ 'StackResourceDrift$StackResourceDriftStatus' => '<p>Status of the resource\'s actual configuration compared to its expected configuration</p> <ul> <li> <p> <code>DELETED</code>: The resource differs from its expected template configuration because the resource has been deleted.</p> </li> <li> <p> <code>MODIFIED</code>: One or more resource properties differ from their expected values (as defined in the stack template and any values specified as template parameters).</p> </li> <li> <p> <code>IN_SYNC</code>: The resources\'s actual configuration matches its expected template configuration.</p> </li> <li> <p> <code>NOT_CHECKED</code>: AWS CloudFormation does not currently return this value.</p> </li> </ul>', 'StackResourceDriftInformation$StackResourceDriftStatus' => '<p>Status of the resource\'s actual configuration compared to its expected configuration</p> <ul> <li> <p> <code>DELETED</code>: The resource differs from its expected configuration in that it has been deleted.</p> </li> <li> <p> <code>MODIFIED</code>: The resource differs from its expected configuration.</p> </li> <li> <p> <code>NOT_CHECKED</code>: AWS CloudFormation has not checked if the resource differs from its expected configuration.</p> <p>Any resources that do not currently support drift detection have a status of <code>NOT_CHECKED</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html">Resources that Support Drift Detection</a>. </p> </li> <li> <p> <code>IN_SYNC</code>: The resources\'s actual configuration matches its expected configuration.</p> </li> </ul>', 'StackResourceDriftInformationSummary$StackResourceDriftStatus' => '<p>Status of the resource\'s actual configuration compared to its expected configuration</p> <ul> <li> <p> <code>DELETED</code>: The resource differs from its expected configuration in that it has been deleted.</p> </li> <li> <p> <code>MODIFIED</code>: The resource differs from its expected configuration.</p> </li> <li> <p> <code>NOT_CHECKED</code>: AWS CloudFormation has not checked if the resource differs from its expected configuration.</p> <p>Any resources that do not currently support drift detection have a status of <code>NOT_CHECKED</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html">Resources that Support Drift Detection</a>. If you performed an <a>ContinueUpdateRollback</a> operation on a stack, any resources included in <code>ResourcesToSkip</code> will also have a status of <code>NOT_CHECKED</code>. For more information on skipping resources during rollback operations, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html">Continue Rolling Back an Update</a> in the AWS CloudFormation User Guide.</p> </li> <li> <p> <code>IN_SYNC</code>: The resources\'s actual configuration matches its expected configuration.</p> </li> </ul>', 'StackResourceDriftStatusFilters$member' => NULL, ], ], 'StackResourceDriftStatusFilters' => [ 'base' => NULL, 'refs' => [ 'DescribeStackResourceDriftsInput$StackResourceDriftStatusFilters' => '<p>The resource drift status values to use as filters for the resource drift results returned.</p> <ul> <li> <p> <code>DELETED</code>: The resource differs from its expected template configuration in that the resource has been deleted.</p> </li> <li> <p> <code>MODIFIED</code>: One or more resource properties differ from their expected template values.</p> </li> <li> <p> <code>IN_SYNC</code>: The resources\'s actual configuration matches its expected template configuration.</p> </li> <li> <p> <code>NOT_CHECKED</code>: AWS CloudFormation does not currently return this value.</p> </li> </ul>', ], ], 'StackResourceDrifts' => [ 'base' => NULL, 'refs' => [ 'DescribeStackResourceDriftsOutput$StackResourceDrifts' => '<p>Drift information for the resources that have been checked for drift in the specified stack. This includes actual and expected configuration values for resources where AWS CloudFormation detects drift.</p> <p>For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has been checked for drift. Resources that have not yet been checked for drift are not included. Resources that do not currently support drift detection are not checked, and so not included. For a list of resources that support drift detection, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html">Resources that Support Drift Detection</a>.</p>', ], ], 'StackResourceSummaries' => [ 'base' => NULL, 'refs' => [ 'ListStackResourcesOutput$StackResourceSummaries' => '<p>A list of <code>StackResourceSummary</code> structures.</p>', ], ], 'StackResourceSummary' => [ 'base' => '<p>Contains high-level information about the specified stack resource.</p>', 'refs' => [ 'StackResourceSummaries$member' => NULL, ], ], 'StackResources' => [ 'base' => NULL, 'refs' => [ 'DescribeStackResourcesOutput$StackResources' => '<p>A list of <code>StackResource</code> structures.</p>', ], ], 'StackSet' => [ 'base' => '<p>A structure that contains information about a stack set. A stack set enables you to provision stacks into AWS accounts and across Regions by using a single CloudFormation template. In the stack set, you specify the template to use, as well as any parameters and capabilities that the template requires. </p>', 'refs' => [ 'DescribeStackSetOutput$StackSet' => '<p>The specified stack set.</p>', ], ], 'StackSetARN' => [ 'base' => NULL, 'refs' => [ 'StackSet$StackSetARN' => '<p>The Amazon Resource Number (ARN) of the stack set.</p>', ], ], 'StackSetDriftDetectionDetails' => [ 'base' => '<p>Detailed information about the drift status of the stack set.</p> <p>For stack sets, contains information about the last <i>completed</i> drift operation performed on the stack set. Information about drift operations in-progress is not included. </p> <p>For stack set operations, includes information about drift operations currently being performed on the stack set.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">Detecting Unmanaged Changes in Stack Sets</a> in the <i>AWS CloudFormation User Guide</i>.</p>', 'refs' => [ 'StackSet$StackSetDriftDetectionDetails' => '<p>Detailed information about the drift status of the stack set.</p> <p>For stack sets, contains information about the last <i>completed</i> drift operation performed on the stack set. Information about drift operations currently in progress is not included.</p>', 'StackSetOperation$StackSetDriftDetectionDetails' => '<p>Detailed information about the drift status of the stack set. This includes information about drift operations currently being performed on the stack set.</p> <p>this information will only be present for stack set operations whose <code>Action</code> type is <code>DETECT_DRIFT</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">Detecting Unmanaged Changes in Stack Sets</a> in the AWS CloudFormation User Guide.</p>', ], ], 'StackSetDriftDetectionStatus' => [ 'base' => NULL, 'refs' => [ 'StackSetDriftDetectionDetails$DriftDetectionStatus' => '<p>The status of the stack set drift detection operation.</p> <ul> <li> <p> <code>COMPLETED</code>: The drift detection operation completed without failing on any stack instances.</p> </li> <li> <p> <code>FAILED</code>: The drift detection operation exceeded the specified failure tolerance. </p> </li> <li> <p> <code>PARTIAL_SUCCESS</code>: The drift detection operation completed without exceeding the failure tolerance for the operation.</p> </li> <li> <p> <code>IN_PROGRESS</code>: The drift detection operation is currently being performed.</p> </li> <li> <p> <code>STOPPED</code>: The user has cancelled the drift detection operation.</p> </li> </ul>', ], ], 'StackSetDriftStatus' => [ 'base' => NULL, 'refs' => [ 'StackSetDriftDetectionDetails$DriftStatus' => '<p>Status of the stack set\'s actual configuration compared to its expected template and parameter configuration. A stack set is considered to have drifted if one or more of its stack instances have drifted from their expected template and parameter configuration.</p> <ul> <li> <p> <code>DRIFTED</code>: One or more of the stack instances belonging to the stack set stack differs from the expected template and parameter configuration. A stack instance is considered to have drifted if one or more of the resources in the associated stack have drifted.</p> </li> <li> <p> <code>NOT_CHECKED</code>: AWS CloudFormation has not checked the stack set for drift.</p> </li> <li> <p> <code>IN_SYNC</code>: All of the stack instances belonging to the stack set stack match from the expected template and parameter configuration.</p> </li> </ul>', ], ], 'StackSetId' => [ 'base' => NULL, 'refs' => [ 'CreateStackSetOutput$StackSetId' => '<p>The ID of the stack set that you\'re creating.</p>', 'StackInstance$StackSetId' => '<p>The name or unique ID of the stack set that the stack instance is associated with.</p>', 'StackInstanceSummary$StackSetId' => '<p>The name or unique ID of the stack set that the stack instance is associated with.</p>', 'StackSet$StackSetId' => '<p>The ID of the stack set.</p>', 'StackSetOperation$StackSetId' => '<p>The ID of the stack set.</p>', 'StackSetSummary$StackSetId' => '<p>The ID of the stack set.</p>', ], ], 'StackSetName' => [ 'base' => NULL, 'refs' => [ 'CreateStackInstancesInput$StackSetName' => '<p>The name or unique ID of the stack set that you want to create stack instances from.</p>', 'CreateStackSetInput$StackSetName' => '<p>The name to associate with the stack set. The name must be unique in the Region where you create your stack set.</p> <note> <p>A stack name can contain only alphanumeric characters (case-sensitive) and hyphens. It must start with an alphabetic character and can\'t be longer than 128 characters.</p> </note>', 'DeleteStackInstancesInput$StackSetName' => '<p>The name or unique ID of the stack set that you want to delete stack instances for.</p>', 'DeleteStackSetInput$StackSetName' => '<p>The name or unique ID of the stack set that you\'re deleting. You can obtain this value by running <a>ListStackSets</a>.</p>', 'DescribeStackInstanceInput$StackSetName' => '<p>The name or the unique stack ID of the stack set that you want to get stack instance information for.</p>', 'DescribeStackSetInput$StackSetName' => '<p>The name or unique ID of the stack set whose description you want.</p>', 'DescribeStackSetOperationInput$StackSetName' => '<p>The name or the unique stack ID of the stack set for the stack operation.</p>', 'ListStackInstancesInput$StackSetName' => '<p>The name or unique ID of the stack set that you want to list stack instances for.</p>', 'ListStackSetOperationResultsInput$StackSetName' => '<p>The name or unique ID of the stack set that you want to get operation results for.</p>', 'ListStackSetOperationsInput$StackSetName' => '<p>The name or unique ID of the stack set that you want to get operation summaries for.</p>', 'StackSet$StackSetName' => '<p>The name that\'s associated with the stack set.</p>', 'StackSetSummary$StackSetName' => '<p>The name of the stack set.</p>', 'StopStackSetOperationInput$StackSetName' => '<p>The name or unique ID of the stack set that you want to stop the operation for.</p>', 'UpdateStackSetInput$StackSetName' => '<p>The name or unique ID of the stack set that you want to update.</p>', ], ], 'StackSetNameOrId' => [ 'base' => NULL, 'refs' => [ 'DetectStackSetDriftInput$StackSetName' => '<p>The name of the stack set on which to perform the drift detection operation.</p>', 'GetTemplateSummaryInput$StackSetName' => '<p>The name or unique ID of the stack set from which the stack was created.</p> <p>Conditional: You must specify only one of the following parameters: <code>StackName</code>, <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.</p>', 'UpdateStackInstancesInput$StackSetName' => '<p>The name or unique ID of the stack set associated with the stack instances.</p>', ], ], 'StackSetNotEmptyException' => [ 'base' => '<p>You can\'t yet delete this stack set, because it still contains one or more stack instances. Delete all stack instances from the stack set before deleting the stack set.</p>', 'refs' => [], ], 'StackSetNotFoundException' => [ 'base' => '<p>The specified stack set doesn\'t exist.</p>', 'refs' => [], ], 'StackSetOperation' => [ 'base' => '<p>The structure that contains information about a stack set operation. </p>', 'refs' => [ 'DescribeStackSetOperationOutput$StackSetOperation' => '<p>The specified stack set operation.</p>', ], ], 'StackSetOperationAction' => [ 'base' => NULL, 'refs' => [ 'StackSetOperation$Action' => '<p>The type of stack set operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create and delete operations affect only the specified stack set instances that are associated with the specified stack set. Update operations affect both the stack set itself, as well as <i>all</i> associated stack set instances.</p>', 'StackSetOperationSummary$Action' => '<p>The type of operation: <code>CREATE</code>, <code>UPDATE</code>, or <code>DELETE</code>. Create and delete operations affect only the specified stack instances that are associated with the specified stack set. Update operations affect both the stack set itself as well as <i>all</i> associated stack set instances.</p>', ], ], 'StackSetOperationPreferences' => [ 'base' => '<p>The user-specified preferences for how AWS CloudFormation performs a stack set operation. </p> <p>For more information on maximum concurrent accounts and failure tolerance, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options">Stack set operation options</a>.</p>', 'refs' => [ 'CreateStackInstancesInput$OperationPreferences' => '<p>Preferences for how AWS CloudFormation performs this stack set operation.</p>', 'DeleteStackInstancesInput$OperationPreferences' => '<p>Preferences for how AWS CloudFormation performs this stack set operation.</p>', 'DetectStackSetDriftInput$OperationPreferences' => NULL, 'StackSetOperation$OperationPreferences' => '<p>The preferences for how AWS CloudFormation performs this stack set operation.</p>', 'UpdateStackInstancesInput$OperationPreferences' => '<p>Preferences for how AWS CloudFormation performs this stack set operation.</p>', 'UpdateStackSetInput$OperationPreferences' => '<p>Preferences for how AWS CloudFormation performs this stack set operation.</p>', ], ], 'StackSetOperationResultStatus' => [ 'base' => NULL, 'refs' => [ 'StackSetOperationResultSummary$Status' => '<p>The result status of the stack set operation for the given account in the given Region.</p> <ul> <li> <p> <code>CANCELLED</code>: The operation in the specified account and Region has been cancelled. This is either because a user has stopped the stack set operation, or because the failure tolerance of the stack set operation has been exceeded.</p> </li> <li> <p> <code>FAILED</code>: The operation in the specified account and Region failed. </p> <p>If the stack set operation fails in enough accounts within a Region, the failure tolerance for the stack set operation as a whole might be exceeded. </p> </li> <li> <p> <code>RUNNING</code>: The operation in the specified account and Region is currently in progress.</p> </li> <li> <p> <code>PENDING</code>: The operation in the specified account and Region has yet to start. </p> </li> <li> <p> <code>SUCCEEDED</code>: The operation in the specified account and Region completed successfully.</p> </li> </ul>', ], ], 'StackSetOperationResultSummaries' => [ 'base' => NULL, 'refs' => [ 'ListStackSetOperationResultsOutput$Summaries' => '<p>A list of <code>StackSetOperationResultSummary</code> structures that contain information about the specified operation results, for accounts and Regions that are included in the operation.</p>', ], ], 'StackSetOperationResultSummary' => [ 'base' => '<p>The structure that contains information about a specified operation\'s results for a given account in a given Region.</p>', 'refs' => [ 'StackSetOperationResultSummaries$member' => NULL, ], ], 'StackSetOperationStatus' => [ 'base' => NULL, 'refs' => [ 'StackSetOperation$Status' => '<p>The status of the operation. </p> <ul> <li> <p> <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance value that you\'ve set for an operation is applied for each Region during stack create and update operations. If the number of failed stacks within a Region exceeds the failure tolerance, the status of the operation in the Region is set to <code>FAILED</code>. This in turn sets the status of the operation as a whole to <code>FAILED</code>, and AWS CloudFormation cancels the operation in any remaining Regions.</p> </li> <li> <p> <code>QUEUED</code>: [<code>Service-managed</code> permissions] For automatic deployments that require a sequence of operations, the operation is queued to be performed. For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-status-codes">stack set operation status codes</a> in the AWS CloudFormation User Guide.</p> </li> <li> <p> <code>RUNNING</code>: The operation is currently being performed.</p> </li> <li> <p> <code>STOPPED</code>: The user has cancelled the operation.</p> </li> <li> <p> <code>STOPPING</code>: The operation is in the process of stopping, at user request. </p> </li> <li> <p> <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without exceeding the failure tolerance for the operation.</p> </li> </ul>', 'StackSetOperationSummary$Status' => '<p>The overall status of the operation.</p> <ul> <li> <p> <code>FAILED</code>: The operation exceeded the specified failure tolerance. The failure tolerance value that you\'ve set for an operation is applied for each Region during stack create and update operations. If the number of failed stacks within a Region exceeds the failure tolerance, the status of the operation in the Region is set to <code>FAILED</code>. This in turn sets the status of the operation as a whole to <code>FAILED</code>, and AWS CloudFormation cancels the operation in any remaining Regions.</p> </li> <li> <p> <code>QUEUED</code>: [<code>Service-managed</code> permissions] For automatic deployments that require a sequence of operations, the operation is queued to be performed. For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-status-codes">stack set operation status codes</a> in the AWS CloudFormation User Guide.</p> </li> <li> <p> <code>RUNNING</code>: The operation is currently being performed.</p> </li> <li> <p> <code>STOPPED</code>: The user has cancelled the operation.</p> </li> <li> <p> <code>STOPPING</code>: The operation is in the process of stopping, at user request. </p> </li> <li> <p> <code>SUCCEEDED</code>: The operation completed creating or updating all the specified stacks without exceeding the failure tolerance for the operation.</p> </li> </ul>', ], ], 'StackSetOperationSummaries' => [ 'base' => NULL, 'refs' => [ 'ListStackSetOperationsOutput$Summaries' => '<p>A list of <code>StackSetOperationSummary</code> structures that contain summary information about operations for the specified stack set.</p>', ], ], 'StackSetOperationSummary' => [ 'base' => '<p>The structures that contain summary information about the specified operation.</p>', 'refs' => [ 'StackSetOperationSummaries$member' => NULL, ], ], 'StackSetStatus' => [ 'base' => NULL, 'refs' => [ 'ListStackSetsInput$Status' => '<p>The status of the stack sets that you want to get summary information about.</p>', 'StackSet$Status' => '<p>The status of the stack set.</p>', 'StackSetSummary$Status' => '<p>The status of the stack set.</p>', ], ], 'StackSetSummaries' => [ 'base' => NULL, 'refs' => [ 'ListStackSetsOutput$Summaries' => '<p>A list of <code>StackSetSummary</code> structures that contain information about the user\'s stack sets.</p>', ], ], 'StackSetSummary' => [ 'base' => '<p>The structures that contain summary information about the specified stack set.</p>', 'refs' => [ 'StackSetSummaries$member' => NULL, ], ], 'StackStatus' => [ 'base' => NULL, 'refs' => [ 'Stack$StackStatus' => '<p>Current status of the stack.</p>', 'StackStatusFilter$member' => NULL, 'StackSummary$StackStatus' => '<p>The current status of the stack.</p>', ], ], 'StackStatusFilter' => [ 'base' => NULL, 'refs' => [ 'ListStacksInput$StackStatusFilter' => '<p>Stack status to use as a filter. Specify one or more stack status codes to list only stacks with the specified status codes. For a complete list of stack status codes, see the <code>StackStatus</code> parameter of the <a>Stack</a> data type.</p>', ], ], 'StackStatusReason' => [ 'base' => NULL, 'refs' => [ 'Stack$StackStatusReason' => '<p>Success/failure message associated with the stack status.</p>', 'StackSummary$StackStatusReason' => '<p>Success/Failure message associated with the stack status.</p>', ], ], 'StackSummaries' => [ 'base' => NULL, 'refs' => [ 'ListStacksOutput$StackSummaries' => '<p>A list of <code>StackSummary</code> structures containing information about the specified stacks.</p>', ], ], 'StackSummary' => [ 'base' => '<p>The StackSummary Data Type</p>', 'refs' => [ 'StackSummaries$member' => NULL, ], ], 'Stacks' => [ 'base' => NULL, 'refs' => [ 'DescribeStacksOutput$Stacks' => '<p>A list of stack structures.</p>', ], ], 'StageList' => [ 'base' => NULL, 'refs' => [ 'GetTemplateOutput$StagesAvailable' => '<p>The stage of the template that you can retrieve. For stacks, the <code>Original</code> and <code>Processed</code> templates are always available. For change sets, the <code>Original</code> template is always available. After AWS CloudFormation finishes creating the change set, the <code>Processed</code> template becomes available.</p>', ], ], 'StaleRequestException' => [ 'base' => '<p>Another operation has been performed on this stack set since the specified operation was performed. </p>', 'refs' => [], ], 'StatusMessage' => [ 'base' => NULL, 'refs' => [ 'RecordHandlerProgressInput$StatusMessage' => '<p>Reserved for use by the <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html">CloudFormation CLI</a>.</p>', ], ], 'StopStackSetOperationInput' => [ 'base' => NULL, 'refs' => [], ], 'StopStackSetOperationOutput' => [ 'base' => NULL, 'refs' => [], ], 'Tag' => [ 'base' => '<p>The Tag type enables you to specify a key-value pair that can be used to store information about an AWS CloudFormation stack.</p>', 'refs' => [ 'Tags$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p> <i>Required</i>. A string used to identify this tag. You can specify a maximum of 128 characters for a tag key. Tags owned by Amazon Web Services (AWS) have the reserved prefix: <code>aws:</code>.</p>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p> <i>Required</i>. A string containing the value for this tag. You can specify a maximum of 256 characters for a tag value.</p>', ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'CreateChangeSetInput$Tags' => '<p>Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to resources in the stack. You can specify a maximum of 50 tags.</p>', 'CreateStackInput$Tags' => '<p>Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to the resources created in the stack. A maximum number of 50 tags can be specified.</p>', 'CreateStackSetInput$Tags' => '<p>The key-value pairs to associate with this stack set and the stacks created from it. AWS CloudFormation also propagates these tags to supported resources that are created in the stacks. A maximum number of 50 tags can be specified.</p> <p>If you specify tags as part of a <code>CreateStackSet</code> action, AWS CloudFormation checks to see if you have the required IAM permission to tag resources. If you don\'t, the entire <code>CreateStackSet</code> action fails with an <code>access denied</code> error, and the stack set is not created.</p>', 'DescribeChangeSetOutput$Tags' => '<p>If you execute the change set, the tags that will be associated with the stack.</p>', 'Stack$Tags' => '<p>A list of <code>Tag</code>s that specify information about the stack.</p>', 'StackSet$Tags' => '<p>A list of tags that specify information about the stack set. A maximum number of 50 tags can be specified.</p>', 'UpdateStackInput$Tags' => '<p>Key-value pairs to associate with this stack. AWS CloudFormation also propagates these tags to supported resources in the stack. You can specify a maximum number of 50 tags.</p> <p>If you don\'t specify this parameter, AWS CloudFormation doesn\'t modify the stack\'s tags. If you specify an empty value, AWS CloudFormation removes all associated tags.</p>', 'UpdateStackSetInput$Tags' => '<p>The key-value pairs to associate with this stack set and the stacks created from it. AWS CloudFormation also propagates these tags to supported resources that are created in the stacks. You can specify a maximum number of 50 tags.</p> <p>If you specify tags for this parameter, those tags replace any list of tags that are currently associated with this stack set. This means:</p> <ul> <li> <p>If you don\'t specify this parameter, AWS CloudFormation doesn\'t modify the stack\'s tags. </p> </li> <li> <p>If you specify <i>any</i> tags using this parameter, you must specify <i>all</i> the tags that you want associated with this stack set, even tags you\'ve specifed before (for example, when creating the stack set or during a previous update of the stack set.). Any tags that you don\'t include in the updated list of tags are removed from the stack set, and therefore from the stacks and resources as well. </p> </li> <li> <p>If you specify an empty value, AWS CloudFormation removes all currently associated tags.</p> </li> </ul> <p>If you specify new tags as part of an <code>UpdateStackSet</code> action, AWS CloudFormation checks to see if you have the required IAM permission to tag resources. If you omit tags that are currently associated with the stack set from the list of tags you specify, AWS CloudFormation assumes that you want to remove those tags from the stack set, and checks to see if you have permission to untag resources. If you don\'t have the necessary permission(s), the entire <code>UpdateStackSet</code> action fails with an <code>access denied</code> error, and the stack set is not updated.</p>', ], ], 'TemplateBody' => [ 'base' => NULL, 'refs' => [ 'CreateChangeSetInput$TemplateBody' => '<p>A structure that contains the body of the revised template, with a minimum length of 1 byte and a maximum length of 51,200 bytes. AWS CloudFormation generates the change set by comparing this template with the template of the stack that you specified.</p> <p>Conditional: You must specify only <code>TemplateBody</code> or <code>TemplateURL</code>.</p>', 'CreateStackInput$TemplateBody' => '<p>Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.</p> <p>Conditional: You must specify either the <code>TemplateBody</code> or the <code>TemplateURL</code> parameter, but not both.</p>', 'CreateStackSetInput$TemplateBody' => '<p>The structure that contains the template body, with a minimum length of 1 byte and a maximum length of 51,200 bytes. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.</p> <p>Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.</p>', 'EstimateTemplateCostInput$TemplateBody' => '<p>Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.)</p> <p>Conditional: You must pass <code>TemplateBody</code> or <code>TemplateURL</code>. If both are passed, only <code>TemplateBody</code> is used.</p>', 'GetTemplateOutput$TemplateBody' => '<p>Structure containing the template body. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.)</p> <p>AWS CloudFormation returns the same template that was used when the stack was created.</p>', 'GetTemplateSummaryInput$TemplateBody' => '<p>Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes. For more information about templates, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.</p> <p>Conditional: You must specify only one of the following parameters: <code>StackName</code>, <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.</p>', 'StackSet$TemplateBody' => '<p>The structure that contains the body of the template that was used to create or update the stack set.</p>', 'UpdateStackInput$TemplateBody' => '<p>Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes. (For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.)</p> <p>Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>, <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.</p>', 'UpdateStackSetInput$TemplateBody' => '<p>The structure that contains the template body, with a minimum length of 1 byte and a maximum length of 51,200 bytes. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.</p> <p>Conditional: You must specify only one of the following parameters: <code>TemplateBody</code> or <code>TemplateURL</code>—or set <code>UsePreviousTemplate</code> to true.</p>', 'ValidateTemplateInput$TemplateBody' => '<p>Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.</p> <p>Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If both are passed, only <code>TemplateBody</code> is used.</p>', ], ], 'TemplateDescription' => [ 'base' => NULL, 'refs' => [ 'StackSummary$TemplateDescription' => '<p>The template description of the template used to create the stack.</p>', ], ], 'TemplateParameter' => [ 'base' => '<p>The TemplateParameter data type.</p>', 'refs' => [ 'TemplateParameters$member' => NULL, ], ], 'TemplateParameters' => [ 'base' => NULL, 'refs' => [ 'ValidateTemplateOutput$Parameters' => '<p>A list of <code>TemplateParameter</code> structures.</p>', ], ], 'TemplateStage' => [ 'base' => NULL, 'refs' => [ 'GetTemplateInput$TemplateStage' => '<p>For templates that include transforms, the stage of the template that AWS CloudFormation returns. To get the user-submitted template, specify <code>Original</code>. To get the template after AWS CloudFormation has processed all transforms, specify <code>Processed</code>. </p> <p>If the template doesn\'t include transforms, <code>Original</code> and <code>Processed</code> return the same template. By default, AWS CloudFormation specifies <code>Original</code>. </p>', 'StageList$member' => NULL, ], ], 'TemplateURL' => [ 'base' => NULL, 'refs' => [ 'CreateChangeSetInput$TemplateURL' => '<p>The location of the file that contains the revised template. The URL must point to a template (max size: 460,800 bytes) that is located in an S3 bucket. AWS CloudFormation generates the change set by comparing this template with the stack that you specified.</p> <p>Conditional: You must specify only <code>TemplateBody</code> or <code>TemplateURL</code>.</p>', 'CreateStackInput$TemplateURL' => '<p>Location of file containing the template body. The URL must point to a template (max size: 460,800 bytes) that is located in an Amazon S3 bucket. For more information, go to the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.</p> <p>Conditional: You must specify either the <code>TemplateBody</code> or the <code>TemplateURL</code> parameter, but not both.</p>', 'CreateStackSetInput$TemplateURL' => '<p>The location of the file that contains the template body. The URL must point to a template (maximum size: 460,800 bytes) that\'s located in an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.</p> <p>Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.</p>', 'EstimateTemplateCostInput$TemplateURL' => '<p>Location of file containing the template body. The URL must point to a template that is located in an Amazon S3 bucket. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.</p> <p>Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If both are passed, only <code>TemplateBody</code> is used.</p>', 'GetTemplateSummaryInput$TemplateURL' => '<p>Location of file containing the template body. The URL must point to a template (max size: 460,800 bytes) that is located in an Amazon S3 bucket. For more information about templates, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.</p> <p>Conditional: You must specify only one of the following parameters: <code>StackName</code>, <code>StackSetName</code>, <code>TemplateBody</code>, or <code>TemplateURL</code>.</p>', 'UpdateStackInput$TemplateURL' => '<p>Location of file containing the template body. The URL must point to a template that is located in an Amazon S3 bucket. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.</p> <p>Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>, <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.</p>', 'UpdateStackSetInput$TemplateURL' => '<p>The location of the file that contains the template body. The URL must point to a template (maximum size: 460,800 bytes) that is located in an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.</p> <p>Conditional: You must specify only one of the following parameters: <code>TemplateBody</code> or <code>TemplateURL</code>—or set <code>UsePreviousTemplate</code> to true. </p>', 'ValidateTemplateInput$TemplateURL' => '<p>Location of file containing the template body. The URL must point to a template (max size: 460,800 bytes) that is located in an Amazon S3 bucket. For more information, go to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a> in the AWS CloudFormation User Guide.</p> <p>Conditional: You must pass <code>TemplateURL</code> or <code>TemplateBody</code>. If both are passed, only <code>TemplateBody</code> is used.</p>', ], ], 'TimeoutMinutes' => [ 'base' => NULL, 'refs' => [ 'CreateStackInput$TimeoutInMinutes' => '<p>The amount of time that can pass before the stack status becomes CREATE_FAILED; if <code>DisableRollback</code> is not set or is set to <code>false</code>, the stack will be rolled back.</p>', 'Stack$TimeoutInMinutes' => '<p>The amount of time within which stack creation should complete.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'DescribeStackDriftDetectionStatusOutput$Timestamp' => '<p>Time at which the stack drift detection operation was initiated.</p>', 'DescribeTypeOutput$LastUpdated' => '<p>When the specified type version was registered.</p>', 'DescribeTypeOutput$TimeCreated' => '<p>When the specified type version was registered.</p>', 'StackDriftInformation$LastCheckTimestamp' => '<p>Most recent time when a drift detection operation was initiated on the stack, or any of its individual resources that support drift detection.</p>', 'StackDriftInformationSummary$LastCheckTimestamp' => '<p>Most recent time when a drift detection operation was initiated on the stack, or any of its individual resources that support drift detection.</p>', 'StackEvent$Timestamp' => '<p>Time the status was updated.</p>', 'StackInstance$LastDriftCheckTimestamp' => '<p>Most recent time when CloudFormation performed a drift detection operation on the stack instance. This value will be <code>NULL</code> for any stack instance on which drift detection has not yet been performed.</p>', 'StackInstanceSummary$LastDriftCheckTimestamp' => '<p>Most recent time when CloudFormation performed a drift detection operation on the stack instance. This value will be <code>NULL</code> for any stack instance on which drift detection has not yet been performed.</p>', 'StackResource$Timestamp' => '<p>Time the status was updated.</p>', 'StackResourceDetail$LastUpdatedTimestamp' => '<p>Time the status was updated.</p>', 'StackResourceDrift$Timestamp' => '<p>Time at which AWS CloudFormation performed drift detection on the stack resource.</p>', 'StackResourceDriftInformation$LastCheckTimestamp' => '<p>When AWS CloudFormation last checked if the resource had drifted from its expected configuration.</p>', 'StackResourceDriftInformationSummary$LastCheckTimestamp' => '<p>When AWS CloudFormation last checked if the resource had drifted from its expected configuration.</p>', 'StackResourceSummary$LastUpdatedTimestamp' => '<p>Time the status was updated.</p>', 'StackSetDriftDetectionDetails$LastDriftCheckTimestamp' => '<p>Most recent time when CloudFormation performed a drift detection operation on the stack set. This value will be <code>NULL</code> for any stack set on which drift detection has not yet been performed.</p>', 'StackSetOperation$CreationTimestamp' => '<p>The time at which the operation was initiated. Note that the creation times for the stack set operation might differ from the creation time of the individual stacks themselves. This is because AWS CloudFormation needs to perform preparatory work for the operation, such as dispatching the work to the requested Regions, before actually creating the first stacks.</p>', 'StackSetOperation$EndTimestamp' => '<p>The time at which the stack set operation ended, across all accounts and Regions specified. Note that this doesn\'t necessarily mean that the stack set operation was successful, or even attempted, in each account or Region.</p>', 'StackSetOperationSummary$CreationTimestamp' => '<p>The time at which the operation was initiated. Note that the creation times for the stack set operation might differ from the creation time of the individual stacks themselves. This is because AWS CloudFormation needs to perform preparatory work for the operation, such as dispatching the work to the requested Regions, before actually creating the first stacks.</p>', 'StackSetOperationSummary$EndTimestamp' => '<p>The time at which the stack set operation ended, across all accounts and Regions specified. Note that this doesn\'t necessarily mean that the stack set operation was successful, or even attempted, in each account or Region.</p>', 'StackSetSummary$LastDriftCheckTimestamp' => '<p>Most recent time when CloudFormation performed a drift detection operation on the stack set. This value will be <code>NULL</code> for any stack set on which drift detection has not yet been performed.</p>', 'TypeSummary$LastUpdated' => '<p>When the current default version of the type was registered.</p>', 'TypeVersionSummary$TimeCreated' => '<p>When the version was registered.</p>', ], ], 'TokenAlreadyExistsException' => [ 'base' => '<p>A client request token already exists.</p>', 'refs' => [], ], 'TotalStackInstancesCount' => [ 'base' => NULL, 'refs' => [ 'StackSetDriftDetectionDetails$TotalStackInstancesCount' => '<p>The total number of stack instances belonging to this stack set. </p> <p>The total number of stack instances is equal to the total of:</p> <ul> <li> <p>Stack instances that match the stack set configuration. </p> </li> <li> <p>Stack instances that have drifted from the stack set configuration. </p> </li> <li> <p>Stack instances where the drift detection operation has failed.</p> </li> <li> <p>Stack instances currently being checked for drift.</p> </li> </ul>', ], ], 'TransformName' => [ 'base' => NULL, 'refs' => [ 'TransformsList$member' => NULL, ], ], 'TransformsList' => [ 'base' => NULL, 'refs' => [ 'GetTemplateSummaryOutput$DeclaredTransforms' => '<p>A list of the transforms that are declared in the template.</p>', 'ValidateTemplateOutput$DeclaredTransforms' => '<p>A list of the transforms that are declared in the template.</p>', ], ], 'Type' => [ 'base' => NULL, 'refs' => [ 'RollbackTrigger$Type' => '<p>The resource type of the rollback trigger. Currently, <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html">AWS::CloudWatch::Alarm</a> is the only supported resource type.</p>', ], ], 'TypeArn' => [ 'base' => NULL, 'refs' => [ 'DescribeTypeInput$Arn' => '<p>The Amazon Resource Name (ARN) of the type.</p> <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.</p>', 'DescribeTypeOutput$Arn' => '<p>The Amazon Resource Name (ARN) of the type.</p>', 'DescribeTypeRegistrationOutput$TypeArn' => '<p>The Amazon Resource Name (ARN) of the type being registered.</p> <p>For registration requests with a <code>ProgressStatus</code> of other than <code>COMPLETE</code>, this will be <code>null</code>.</p>', 'DescribeTypeRegistrationOutput$TypeVersionArn' => '<p>The Amazon Resource Name (ARN) of this specific version of the type being registered.</p> <p>For registration requests with a <code>ProgressStatus</code> of other than <code>COMPLETE</code>, this will be <code>null</code>.</p>', 'ListTypeRegistrationsInput$TypeArn' => '<p>The Amazon Resource Name (ARN) of the type.</p> <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.</p>', 'TypeSummary$TypeArn' => '<p>The Amazon Resource Name (ARN) of the type.</p>', 'TypeVersionSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the type version.</p>', ], ], 'TypeName' => [ 'base' => NULL, 'refs' => [ 'DeregisterTypeInput$TypeName' => '<p>The name of the type.</p> <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.</p>', 'DescribeTypeInput$TypeName' => '<p>The name of the type.</p> <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.</p>', 'DescribeTypeOutput$TypeName' => '<p>The name of the registered type.</p>', 'ListTypeRegistrationsInput$TypeName' => '<p>The name of the type.</p> <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.</p>', 'ListTypeVersionsInput$TypeName' => '<p>The name of the type for which you want version summary information.</p> <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.</p>', 'RegisterTypeInput$TypeName' => '<p>The name of the type being registered.</p> <p>We recommend that type names adhere to the following pattern: <i>company_or_organization</i>::<i>service</i>::<i>type</i>.</p> <note> <p>The following organization namespaces are reserved and cannot be used in your resource type names:</p> <ul> <li> <p> <code>Alexa</code> </p> </li> <li> <p> <code>AMZN</code> </p> </li> <li> <p> <code>Amazon</code> </p> </li> <li> <p> <code>AWS</code> </p> </li> <li> <p> <code>Custom</code> </p> </li> <li> <p> <code>Dev</code> </p> </li> </ul> </note>', 'SetTypeDefaultVersionInput$TypeName' => '<p>The name of the type.</p> <p>Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.</p>', 'TypeSummary$TypeName' => '<p>The name of the type.</p>', 'TypeVersionSummary$TypeName' => '<p>The name of the type.</p>', ], ], 'TypeNotFoundException' => [ 'base' => '<p>The specified type does not exist in the CloudFormation registry.</p>', 'refs' => [], ], 'TypeSchema' => [ 'base' => NULL, 'refs' => [ 'DescribeTypeOutput$Schema' => '<p>The schema that defines the type.</p> <p>For more information on type schemas, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">Resource Provider Schema</a> in the <i>CloudFormation CLI User Guide</i>.</p>', ], ], 'TypeSummaries' => [ 'base' => NULL, 'refs' => [ 'ListTypesOutput$TypeSummaries' => '<p>A list of <code>TypeSummary</code> structures that contain information about the specified types.</p>', ], ], 'TypeSummary' => [ 'base' => '<p>Contains summary information about the specified CloudFormation type.</p>', 'refs' => [ 'TypeSummaries$member' => NULL, ], ], 'TypeVersionId' => [ 'base' => NULL, 'refs' => [ 'DeregisterTypeInput$VersionId' => '<p>The ID of a specific version of the type. The version ID is the value at the end of the Amazon Resource Name (ARN) assigned to the type version when it is registered.</p>', 'DescribeTypeInput$VersionId' => '<p>The ID of a specific version of the type. The version ID is the value at the end of the Amazon Resource Name (ARN) assigned to the type version when it is registered.</p> <p>If you specify a <code>VersionId</code>, <code>DescribeType</code> returns information about that specific type version. Otherwise, it returns information about the default type version.</p>', 'DescribeTypeOutput$DefaultVersionId' => '<p>The ID of the default version of the type. The default version is used when the type version is not specified.</p> <p>To set the default version of a type, use <code> <a>SetTypeDefaultVersion</a> </code>. </p>', 'SetTypeDefaultVersionInput$VersionId' => '<p>The ID of a specific version of the type. The version ID is the value at the end of the Amazon Resource Name (ARN) assigned to the type version when it is registered.</p>', 'TypeSummary$DefaultVersionId' => '<p>The ID of the default version of the type. The default version is used when the type version is not specified.</p> <p>To set the default version of a type, use <code> <a>SetTypeDefaultVersion</a> </code>. </p>', 'TypeVersionSummary$VersionId' => '<p>The ID of a specific version of the type. The version ID is the value at the end of the Amazon Resource Name (ARN) assigned to the type version when it is registered.</p>', ], ], 'TypeVersionSummaries' => [ 'base' => NULL, 'refs' => [ 'ListTypeVersionsOutput$TypeVersionSummaries' => '<p>A list of <code>TypeVersionSummary</code> structures that contain information about the specified type\'s versions.</p>', ], ], 'TypeVersionSummary' => [ 'base' => '<p>Contains summary information about a specific version of a CloudFormation type.</p>', 'refs' => [ 'TypeVersionSummaries$member' => NULL, ], ], 'UpdateStackInput' => [ 'base' => '<p>The input for an <a>UpdateStack</a> action.</p>', 'refs' => [], ], 'UpdateStackInstancesInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStackInstancesOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStackOutput' => [ 'base' => '<p>The output for an <a>UpdateStack</a> action.</p>', 'refs' => [], ], 'UpdateStackSetInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStackSetOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTerminationProtectionInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTerminationProtectionOutput' => [ 'base' => NULL, 'refs' => [], ], 'Url' => [ 'base' => NULL, 'refs' => [ 'EstimateTemplateCostOutput$Url' => '<p>An AWS Simple Monthly Calculator URL with a query string that describes the resources required to run the template.</p>', ], ], 'UsePreviousTemplate' => [ 'base' => NULL, 'refs' => [ 'CreateChangeSetInput$UsePreviousTemplate' => '<p>Whether to reuse the template that is associated with the stack to create the change set.</p>', 'UpdateStackInput$UsePreviousTemplate' => '<p>Reuse the existing template that is associated with the stack that you are updating.</p> <p>Conditional: You must specify only one of the following parameters: <code>TemplateBody</code>, <code>TemplateURL</code>, or set the <code>UsePreviousTemplate</code> to <code>true</code>.</p>', 'UpdateStackSetInput$UsePreviousTemplate' => '<p>Use the existing template that\'s associated with the stack set that you\'re updating.</p> <p>Conditional: You must specify only one of the following parameters: <code>TemplateBody</code> or <code>TemplateURL</code>—or set <code>UsePreviousTemplate</code> to true. </p>', ], ], 'UsePreviousValue' => [ 'base' => NULL, 'refs' => [ 'Parameter$UsePreviousValue' => '<p>During a stack update, use the existing parameter value that the stack is using for a given parameter key. If you specify <code>true</code>, do not specify a parameter value.</p>', ], ], 'ValidateTemplateInput' => [ 'base' => '<p>The input for <a>ValidateTemplate</a> action.</p>', 'refs' => [], ], 'ValidateTemplateOutput' => [ 'base' => '<p>The output for <a>ValidateTemplate</a> action.</p>', 'refs' => [], ], 'Value' => [ 'base' => NULL, 'refs' => [ 'PhysicalResourceIdContextKeyValuePair$Value' => '<p>The resource context value.</p>', ], ], 'Version' => [ 'base' => NULL, 'refs' => [ 'GetTemplateSummaryOutput$Version' => '<p>The AWS template format version, which identifies the capabilities of the template.</p>', ], ], 'Visibility' => [ 'base' => NULL, 'refs' => [ 'DescribeTypeOutput$Visibility' => '<p>The scope at which the type is visible and usable in CloudFormation operations.</p> <p>Valid values include:</p> <ul> <li> <p> <code>PRIVATE</code>: The type is only visible and usable within the account in which it is registered. Currently, AWS CloudFormation marks any types you register as <code>PRIVATE</code>.</p> </li> <li> <p> <code>PUBLIC</code>: The type is publically visible and usable within any Amazon account.</p> </li> </ul>', 'ListTypesInput$Visibility' => '<p>The scope at which the type is visible and usable in CloudFormation operations.</p> <p>Valid values include:</p> <ul> <li> <p> <code>PRIVATE</code>: The type is only visible and usable within the account in which it is registered. Currently, AWS CloudFormation marks any types you create as <code>PRIVATE</code>.</p> </li> <li> <p> <code>PUBLIC</code>: The type is publically visible and usable within any Amazon account.</p> </li> </ul> <p>The default is <code>PRIVATE</code>.</p>', ], ], ],];
