<?php
// This file was auto-generated from sdk-root/src/data/appmesh/2019-01-25/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>AWS App Mesh is a service mesh based on the Envoy proxy that makes it easy to monitor and control microservices. App Mesh standardizes how your microservices communicate, giving you end-to-end visibility and helping to ensure high availability for your applications.</p> <p>App Mesh gives you consistent visibility and network traffic controls for every microservice in an application. You can use App Mesh with AWS Fargate, Amazon ECS, Amazon EKS, Kubernetes on AWS, and Amazon EC2.</p> <note> <p>App Mesh supports microservice applications that use service discovery naming for their components. For more information about service discovery on Amazon ECS, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service Discovery</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. Kubernetes <code>kube-dns</code> and <code>coredns</code> are supported. For more information, see <a href="https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/">DNS for Services and Pods</a> in the Kubernetes documentation.</p> </note>', 'operations' => [ 'CreateGatewayRoute' => '<p>Creates a gateway route.</p> <p>A gateway route is attached to a virtual gateway and routes traffic to an existing virtual service. If a route matches a request, it can distribute traffic to a target virtual service.</p> <p>For more information about gateway routes, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/gateway-routes.html">Gateway routes</a>.</p>', 'CreateMesh' => '<p>Creates a service mesh.</p> <p> A service mesh is a logical boundary for network traffic between services that are represented by resources within the mesh. After you create your service mesh, you can create virtual services, virtual nodes, virtual routers, and routes to distribute traffic between the applications in your mesh.</p> <p>For more information about service meshes, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/meshes.html">Service meshes</a>.</p>', 'CreateRoute' => '<p>Creates a route that is associated with a virtual router.</p> <p> You can route several different protocols and define a retry policy for a route. Traffic can be routed to one or more virtual nodes.</p> <p>For more information about routes, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/routes.html">Routes</a>.</p>', 'CreateVirtualGateway' => '<p>Creates a virtual gateway.</p> <p>A virtual gateway allows resources outside your mesh to communicate to resources that are inside your mesh. The virtual gateway represents an Envoy proxy running in an Amazon ECS task, in a Kubernetes service, or on an Amazon EC2 instance. Unlike a virtual node, which represents an Envoy running with an application, a virtual gateway represents Envoy deployed by itself.</p> <p>For more information about virtual gateways, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_gateways.html">Virtual gateways</a>.</p>', 'CreateVirtualNode' => '<p>Creates a virtual node within a service mesh.</p> <p> A virtual node acts as a logical pointer to a particular task group, such as an Amazon ECS service or a Kubernetes deployment. When you create a virtual node, you can specify the service discovery information for your task group, and whether the proxy running in a task group will communicate with other proxies using Transport Layer Security (TLS).</p> <p>You define a <code>listener</code> for any inbound traffic that your virtual node expects. Any virtual service that your virtual node expects to communicate to is specified as a <code>backend</code>.</p> <p>The response metadata for your new virtual node contains the <code>arn</code> that is associated with the virtual node. Set this value (either the full ARN or the truncated resource name: for example, <code>mesh/default/virtualNode/simpleapp</code>) as the <code>APPMESH_VIRTUAL_NODE_NAME</code> environment variable for your task group\'s Envoy proxy container in your task definition or pod spec. This is then mapped to the <code>node.id</code> and <code>node.cluster</code> Envoy parameters.</p> <note> <p>If you require your Envoy stats or tracing to use a different name, you can override the <code>node.cluster</code> value that is set by <code>APPMESH_VIRTUAL_NODE_NAME</code> with the <code>APPMESH_VIRTUAL_NODE_CLUSTER</code> environment variable.</p> </note> <p>For more information about virtual nodes, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_nodes.html">Virtual nodes</a>.</p>', 'CreateVirtualRouter' => '<p>Creates a virtual router within a service mesh.</p> <p>Specify a <code>listener</code> for any inbound traffic that your virtual router receives. Create a virtual router for each protocol and port that you need to route. Virtual routers handle traffic for one or more virtual services within your mesh. After you create your virtual router, create and associate routes for your virtual router that direct incoming requests to different virtual nodes.</p> <p>For more information about virtual routers, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_routers.html">Virtual routers</a>.</p>', 'CreateVirtualService' => '<p>Creates a virtual service within a service mesh.</p> <p>A virtual service is an abstraction of a real service that is provided by a virtual node directly or indirectly by means of a virtual router. Dependent services call your virtual service by its <code>virtualServiceName</code>, and those requests are routed to the virtual node or virtual router that is specified as the provider for the virtual service.</p> <p>For more information about virtual services, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_services.html">Virtual services</a>.</p>', 'DeleteGatewayRoute' => '<p>Deletes an existing gateway route.</p>', 'DeleteMesh' => '<p>Deletes an existing service mesh.</p> <p>You must delete all resources (virtual services, routes, virtual routers, and virtual nodes) in the service mesh before you can delete the mesh itself.</p>', 'DeleteRoute' => '<p>Deletes an existing route.</p>', 'DeleteVirtualGateway' => '<p>Deletes an existing virtual gateway. You cannot delete a virtual gateway if any gateway routes are associated to it.</p>', 'DeleteVirtualNode' => '<p>Deletes an existing virtual node.</p> <p>You must delete any virtual services that list a virtual node as a service provider before you can delete the virtual node itself.</p>', 'DeleteVirtualRouter' => '<p>Deletes an existing virtual router.</p> <p>You must delete any routes associated with the virtual router before you can delete the router itself.</p>', 'DeleteVirtualService' => '<p>Deletes an existing virtual service.</p>', 'DescribeGatewayRoute' => '<p>Describes an existing gateway route.</p>', 'DescribeMesh' => '<p>Describes an existing service mesh.</p>', 'DescribeRoute' => '<p>Describes an existing route.</p>', 'DescribeVirtualGateway' => '<p>Describes an existing virtual gateway.</p>', 'DescribeVirtualNode' => '<p>Describes an existing virtual node.</p>', 'DescribeVirtualRouter' => '<p>Describes an existing virtual router.</p>', 'DescribeVirtualService' => '<p>Describes an existing virtual service.</p>', 'ListGatewayRoutes' => '<p>Returns a list of existing gateway routes that are associated to a virtual gateway.</p>', 'ListMeshes' => '<p>Returns a list of existing service meshes.</p>', 'ListRoutes' => '<p>Returns a list of existing routes in a service mesh.</p>', 'ListTagsForResource' => '<p>List the tags for an App Mesh resource.</p>', 'ListVirtualGateways' => '<p>Returns a list of existing virtual gateways in a service mesh.</p>', 'ListVirtualNodes' => '<p>Returns a list of existing virtual nodes.</p>', 'ListVirtualRouters' => '<p>Returns a list of existing virtual routers in a service mesh.</p>', 'ListVirtualServices' => '<p>Returns a list of existing virtual services in a service mesh.</p>', 'TagResource' => '<p>Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a resource aren\'t specified in the request parameters, they aren\'t changed. When a resource is deleted, the tags associated with that resource are also deleted.</p>', 'UntagResource' => '<p>Deletes specified tags from a resource.</p>', 'UpdateGatewayRoute' => '<p>Updates an existing gateway route that is associated to a specified virtual gateway in a service mesh.</p>', 'UpdateMesh' => '<p>Updates an existing service mesh.</p>', 'UpdateRoute' => '<p>Updates an existing route for a specified service mesh and virtual router.</p>', 'UpdateVirtualGateway' => '<p>Updates an existing virtual gateway in a specified service mesh.</p>', 'UpdateVirtualNode' => '<p>Updates an existing virtual node in a specified service mesh.</p>', 'UpdateVirtualRouter' => '<p>Updates an existing virtual router in a specified service mesh.</p>', 'UpdateVirtualService' => '<p>Updates an existing virtual service in a specified service mesh.</p>', ], 'shapes' => [ 'AccessLog' => [ 'base' => '<p>An object that represents the access logging information for a virtual node.</p>', 'refs' => [ 'AccessLog$file' => '<p>The file object to send virtual node access logs to.</p>', ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [], ], 'Arn' => [ 'base' => NULL, 'refs' => [], ], 'AwsCloudMapInstanceAttribute' => [ 'base' => '<p>An object that represents the AWS Cloud Map attribute information for your virtual node.</p>', 'refs' => [ 'AwsCloudMapInstanceAttribute$key' => '<p>The name of an AWS Cloud Map service instance attribute key. Any AWS Cloud Map service instance that contains the specified key and value is returned.</p>', 'AwsCloudMapInstanceAttribute$value' => '<p>The value of an AWS Cloud Map service instance attribute key. Any AWS Cloud Map service instance that contains the specified key and value is returned.</p>', ], ], 'AwsCloudMapInstanceAttributeKey' => [ 'base' => NULL, 'refs' => [], ], 'AwsCloudMapInstanceAttributeValue' => [ 'base' => NULL, 'refs' => [], ], 'AwsCloudMapInstanceAttributes' => [ 'base' => NULL, 'refs' => [ 'AwsCloudMapInstanceAttributes$member' => NULL, ], ], 'AwsCloudMapName' => [ 'base' => NULL, 'refs' => [], ], 'AwsCloudMapServiceDiscovery' => [ 'base' => '<p>An object that represents the AWS Cloud Map service discovery information for your virtual node.</p>', 'refs' => [ 'AwsCloudMapServiceDiscovery$attributes' => '<p>A string map that contains attributes with values that you can use to filter instances by any custom attribute that you specified when you registered the instance. Only instances that match all of the specified key/value pairs will be returned.</p>', 'AwsCloudMapServiceDiscovery$namespaceName' => '<p>The name of the AWS Cloud Map namespace to use.</p>', 'AwsCloudMapServiceDiscovery$serviceName' => '<p>The name of the AWS Cloud Map service to use.</p>', ], ], 'Backend' => [ 'base' => '<p>An object that represents the backends that a virtual node is expected to send outbound traffic to. </p>', 'refs' => [ 'Backend$virtualService' => '<p>Specifies a virtual service to use as a backend for a virtual node. </p>', ], ], 'BackendDefaults' => [ 'base' => '<p>An object that represents the default properties for a backend.</p>', 'refs' => [ 'BackendDefaults$clientPolicy' => '<p>A reference to an object that represents a client policy.</p>', ], ], 'Backends' => [ 'base' => NULL, 'refs' => [ 'Backends$member' => NULL, ], ], 'BadRequestException' => [ 'base' => '<p>The request syntax was malformed. Check your request syntax and try again.</p>', 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [], ], 'CertificateAuthorityArns' => [ 'base' => NULL, 'refs' => [ 'CertificateAuthorityArns$member' => NULL, ], ], 'ClientPolicy' => [ 'base' => '<p>An object that represents a client policy.</p>', 'refs' => [ 'ClientPolicy$tls' => '<p>A reference to an object that represents a Transport Layer Security (TLS) client policy.</p>', ], ], 'ClientPolicyTls' => [ 'base' => '<p>An object that represents a Transport Layer Security (TLS) client policy.</p>', 'refs' => [ 'ClientPolicyTls$enforce' => '<p>Whether the policy is enforced. The default is <code>True</code>, if a value isn\'t specified.</p>', 'ClientPolicyTls$ports' => '<p>One or more ports that the policy is enforced for.</p>', 'ClientPolicyTls$validation' => '<p>A reference to an object that represents a TLS validation context.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The request contains a client token that was used for a previous update resource call with different specifications. Try the request again with a new client token.</p>', 'refs' => [], ], 'CreateGatewayRouteInput' => [ 'base' => NULL, 'refs' => [ 'CreateGatewayRouteInput$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>', 'CreateGatewayRouteInput$gatewayRouteName' => '<p>The name to use for the gateway route.</p>', 'CreateGatewayRouteInput$meshName' => '<p>The name of the service mesh to create the gateway route in.</p>', 'CreateGatewayRouteInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'CreateGatewayRouteInput$spec' => '<p>The gateway route specification to apply.</p>', 'CreateGatewayRouteInput$tags' => '<p>Optional metadata that you can apply to the gateway route to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>', 'CreateGatewayRouteInput$virtualGatewayName' => '<p>The name of the virtual gateway to associate the gateway route with. If the virtual gateway is in a shared mesh, then you must be the owner of the virtual gateway resource.</p>', ], ], 'CreateGatewayRouteOutput' => [ 'base' => NULL, 'refs' => [ 'CreateGatewayRouteOutput$gatewayRoute' => '<p>The full description of your gateway route following the create call.</p>', ], ], 'CreateMeshInput' => [ 'base' => '', 'refs' => [ 'CreateMeshInput$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>', 'CreateMeshInput$meshName' => '<p>The name to use for the service mesh.</p>', 'CreateMeshInput$spec' => '<p>The service mesh specification to apply.</p>', 'CreateMeshInput$tags' => '<p>Optional metadata that you can apply to the service mesh to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>', ], ], 'CreateMeshOutput' => [ 'base' => '', 'refs' => [ 'CreateMeshOutput$mesh' => '<p>The full description of your service mesh following the create call.</p>', ], ], 'CreateRouteInput' => [ 'base' => '', 'refs' => [ 'CreateRouteInput$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>', 'CreateRouteInput$meshName' => '<p>The name of the service mesh to create the route in.</p>', 'CreateRouteInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'CreateRouteInput$routeName' => '<p>The name to use for the route.</p>', 'CreateRouteInput$spec' => '<p>The route specification to apply.</p>', 'CreateRouteInput$tags' => '<p>Optional metadata that you can apply to the route to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>', 'CreateRouteInput$virtualRouterName' => '<p>The name of the virtual router in which to create the route. If the virtual router is in a shared mesh, then you must be the owner of the virtual router resource.</p>', ], ], 'CreateRouteOutput' => [ 'base' => '', 'refs' => [ 'CreateRouteOutput$route' => '<p>The full description of your mesh following the create call.</p>', ], ], 'CreateVirtualGatewayInput' => [ 'base' => NULL, 'refs' => [ 'CreateVirtualGatewayInput$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>', 'CreateVirtualGatewayInput$meshName' => '<p>The name of the service mesh to create the virtual gateway in.</p>', 'CreateVirtualGatewayInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'CreateVirtualGatewayInput$spec' => '<p>The virtual gateway specification to apply.</p>', 'CreateVirtualGatewayInput$tags' => '<p>Optional metadata that you can apply to the virtual gateway to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>', 'CreateVirtualGatewayInput$virtualGatewayName' => '<p>The name to use for the virtual gateway.</p>', ], ], 'CreateVirtualGatewayOutput' => [ 'base' => NULL, 'refs' => [ 'CreateVirtualGatewayOutput$virtualGateway' => '<p>The full description of your virtual gateway following the create call.</p>', ], ], 'CreateVirtualNodeInput' => [ 'base' => '', 'refs' => [ 'CreateVirtualNodeInput$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>', 'CreateVirtualNodeInput$meshName' => '<p>The name of the service mesh to create the virtual node in.</p>', 'CreateVirtualNodeInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'CreateVirtualNodeInput$spec' => '<p>The virtual node specification to apply.</p>', 'CreateVirtualNodeInput$tags' => '<p>Optional metadata that you can apply to the virtual node to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>', 'CreateVirtualNodeInput$virtualNodeName' => '<p>The name to use for the virtual node.</p>', ], ], 'CreateVirtualNodeOutput' => [ 'base' => '', 'refs' => [ 'CreateVirtualNodeOutput$virtualNode' => '<p>The full description of your virtual node following the create call.</p>', ], ], 'CreateVirtualRouterInput' => [ 'base' => '', 'refs' => [ 'CreateVirtualRouterInput$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>', 'CreateVirtualRouterInput$meshName' => '<p>The name of the service mesh to create the virtual router in.</p>', 'CreateVirtualRouterInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'CreateVirtualRouterInput$spec' => '<p>The virtual router specification to apply.</p>', 'CreateVirtualRouterInput$tags' => '<p>Optional metadata that you can apply to the virtual router to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>', 'CreateVirtualRouterInput$virtualRouterName' => '<p>The name to use for the virtual router.</p>', ], ], 'CreateVirtualRouterOutput' => [ 'base' => '', 'refs' => [ 'CreateVirtualRouterOutput$virtualRouter' => '<p>The full description of your virtual router following the create call.</p>', ], ], 'CreateVirtualServiceInput' => [ 'base' => '', 'refs' => [ 'CreateVirtualServiceInput$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>', 'CreateVirtualServiceInput$meshName' => '<p>The name of the service mesh to create the virtual service in.</p>', 'CreateVirtualServiceInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'CreateVirtualServiceInput$spec' => '<p>The virtual service specification to apply.</p>', 'CreateVirtualServiceInput$tags' => '<p>Optional metadata that you can apply to the virtual service to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>', 'CreateVirtualServiceInput$virtualServiceName' => '<p>The name to use for the virtual service.</p>', ], ], 'CreateVirtualServiceOutput' => [ 'base' => '', 'refs' => [ 'CreateVirtualServiceOutput$virtualService' => '<p>The full description of your virtual service following the create call.</p>', ], ], 'DeleteGatewayRouteInput' => [ 'base' => NULL, 'refs' => [ 'DeleteGatewayRouteInput$gatewayRouteName' => '<p>The name of the gateway route to delete.</p>', 'DeleteGatewayRouteInput$meshName' => '<p>The name of the service mesh to delete the gateway route from.</p>', 'DeleteGatewayRouteInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'DeleteGatewayRouteInput$virtualGatewayName' => '<p>The name of the virtual gateway to delete the route from.</p>', ], ], 'DeleteGatewayRouteOutput' => [ 'base' => NULL, 'refs' => [ 'DeleteGatewayRouteOutput$gatewayRoute' => '<p>The gateway route that was deleted.</p>', ], ], 'DeleteMeshInput' => [ 'base' => '', 'refs' => [ 'DeleteMeshInput$meshName' => '<p>The name of the service mesh to delete.</p>', ], ], 'DeleteMeshOutput' => [ 'base' => '', 'refs' => [ 'DeleteMeshOutput$mesh' => '<p>The service mesh that was deleted.</p>', ], ], 'DeleteRouteInput' => [ 'base' => '', 'refs' => [ 'DeleteRouteInput$meshName' => '<p>The name of the service mesh to delete the route in.</p>', 'DeleteRouteInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'DeleteRouteInput$routeName' => '<p>The name of the route to delete.</p>', 'DeleteRouteInput$virtualRouterName' => '<p>The name of the virtual router to delete the route in.</p>', ], ], 'DeleteRouteOutput' => [ 'base' => '', 'refs' => [ 'DeleteRouteOutput$route' => '<p>The route that was deleted.</p>', ], ], 'DeleteVirtualGatewayInput' => [ 'base' => NULL, 'refs' => [ 'DeleteVirtualGatewayInput$meshName' => '<p>The name of the service mesh to delete the virtual gateway from.</p>', 'DeleteVirtualGatewayInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'DeleteVirtualGatewayInput$virtualGatewayName' => '<p>The name of the virtual gateway to delete.</p>', ], ], 'DeleteVirtualGatewayOutput' => [ 'base' => NULL, 'refs' => [ 'DeleteVirtualGatewayOutput$virtualGateway' => '<p>The virtual gateway that was deleted.</p>', ], ], 'DeleteVirtualNodeInput' => [ 'base' => '', 'refs' => [ 'DeleteVirtualNodeInput$meshName' => '<p>The name of the service mesh to delete the virtual node in.</p>', 'DeleteVirtualNodeInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'DeleteVirtualNodeInput$virtualNodeName' => '<p>The name of the virtual node to delete.</p>', ], ], 'DeleteVirtualNodeOutput' => [ 'base' => '', 'refs' => [ 'DeleteVirtualNodeOutput$virtualNode' => '<p>The virtual node that was deleted.</p>', ], ], 'DeleteVirtualRouterInput' => [ 'base' => '', 'refs' => [ 'DeleteVirtualRouterInput$meshName' => '<p>The name of the service mesh to delete the virtual router in.</p>', 'DeleteVirtualRouterInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'DeleteVirtualRouterInput$virtualRouterName' => '<p>The name of the virtual router to delete.</p>', ], ], 'DeleteVirtualRouterOutput' => [ 'base' => '', 'refs' => [ 'DeleteVirtualRouterOutput$virtualRouter' => '<p>The virtual router that was deleted.</p>', ], ], 'DeleteVirtualServiceInput' => [ 'base' => '', 'refs' => [ 'DeleteVirtualServiceInput$meshName' => '<p>The name of the service mesh to delete the virtual service in.</p>', 'DeleteVirtualServiceInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'DeleteVirtualServiceInput$virtualServiceName' => '<p>The name of the virtual service to delete.</p>', ], ], 'DeleteVirtualServiceOutput' => [ 'base' => '', 'refs' => [ 'DeleteVirtualServiceOutput$virtualService' => '<p>The virtual service that was deleted.</p>', ], ], 'DescribeGatewayRouteInput' => [ 'base' => NULL, 'refs' => [ 'DescribeGatewayRouteInput$gatewayRouteName' => '<p>The name of the gateway route to describe.</p>', 'DescribeGatewayRouteInput$meshName' => '<p>The name of the service mesh that the gateway route resides in.</p>', 'DescribeGatewayRouteInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'DescribeGatewayRouteInput$virtualGatewayName' => '<p>The name of the virtual gateway that the gateway route is associated with.</p>', ], ], 'DescribeGatewayRouteOutput' => [ 'base' => NULL, 'refs' => [ 'DescribeGatewayRouteOutput$gatewayRoute' => '<p>The full description of your gateway route.</p>', ], ], 'DescribeMeshInput' => [ 'base' => '', 'refs' => [ 'DescribeMeshInput$meshName' => '<p>The name of the service mesh to describe.</p>', 'DescribeMeshInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', ], ], 'DescribeMeshOutput' => [ 'base' => '', 'refs' => [ 'DescribeMeshOutput$mesh' => '<p>The full description of your service mesh.</p>', ], ], 'DescribeRouteInput' => [ 'base' => '', 'refs' => [ 'DescribeRouteInput$meshName' => '<p>The name of the service mesh that the route resides in.</p>', 'DescribeRouteInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'DescribeRouteInput$routeName' => '<p>The name of the route to describe.</p>', 'DescribeRouteInput$virtualRouterName' => '<p>The name of the virtual router that the route is associated with.</p>', ], ], 'DescribeRouteOutput' => [ 'base' => '', 'refs' => [ 'DescribeRouteOutput$route' => '<p>The full description of your route.</p>', ], ], 'DescribeVirtualGatewayInput' => [ 'base' => NULL, 'refs' => [ 'DescribeVirtualGatewayInput$meshName' => '<p>The name of the service mesh that the gateway route resides in.</p>', 'DescribeVirtualGatewayInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'DescribeVirtualGatewayInput$virtualGatewayName' => '<p>The name of the virtual gateway to describe.</p>', ], ], 'DescribeVirtualGatewayOutput' => [ 'base' => NULL, 'refs' => [ 'DescribeVirtualGatewayOutput$virtualGateway' => '<p>The full description of your virtual gateway.</p>', ], ], 'DescribeVirtualNodeInput' => [ 'base' => '', 'refs' => [ 'DescribeVirtualNodeInput$meshName' => '<p>The name of the service mesh that the virtual node resides in.</p>', 'DescribeVirtualNodeInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'DescribeVirtualNodeInput$virtualNodeName' => '<p>The name of the virtual node to describe.</p>', ], ], 'DescribeVirtualNodeOutput' => [ 'base' => '', 'refs' => [ 'DescribeVirtualNodeOutput$virtualNode' => '<p>The full description of your virtual node.</p>', ], ], 'DescribeVirtualRouterInput' => [ 'base' => '', 'refs' => [ 'DescribeVirtualRouterInput$meshName' => '<p>The name of the service mesh that the virtual router resides in.</p>', 'DescribeVirtualRouterInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'DescribeVirtualRouterInput$virtualRouterName' => '<p>The name of the virtual router to describe.</p>', ], ], 'DescribeVirtualRouterOutput' => [ 'base' => '', 'refs' => [ 'DescribeVirtualRouterOutput$virtualRouter' => '<p>The full description of your virtual router.</p>', ], ], 'DescribeVirtualServiceInput' => [ 'base' => '', 'refs' => [ 'DescribeVirtualServiceInput$meshName' => '<p>The name of the service mesh that the virtual service resides in.</p>', 'DescribeVirtualServiceInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'DescribeVirtualServiceInput$virtualServiceName' => '<p>The name of the virtual service to describe.</p>', ], ], 'DescribeVirtualServiceOutput' => [ 'base' => '', 'refs' => [ 'DescribeVirtualServiceOutput$virtualService' => '<p>The full description of your virtual service.</p>', ], ], 'DnsServiceDiscovery' => [ 'base' => '<p>An object that represents the DNS service discovery information for your virtual node.</p>', 'refs' => [ 'DnsServiceDiscovery$hostname' => '<p>Specifies the DNS service discovery hostname for the virtual node. </p>', ], ], 'Duration' => [ 'base' => '<p>An object that represents a duration of time.</p>', 'refs' => [ 'Duration$unit' => '<p>A unit of time.</p>', 'Duration$value' => '<p>A number of time units.</p>', ], ], 'DurationUnit' => [ 'base' => NULL, 'refs' => [], ], 'DurationValue' => [ 'base' => NULL, 'refs' => [], ], 'EgressFilter' => [ 'base' => '<p>An object that represents the egress filter rules for a service mesh.</p>', 'refs' => [ 'EgressFilter$type' => '<p>The egress filter type. By default, the type is <code>DROP_ALL</code>, which allows egress only from virtual nodes to other defined resources in the service mesh (and any traffic to <code>*.amazonaws.com</code> for AWS API calls). You can set the egress filter type to <code>ALLOW_ALL</code> to allow egress to any endpoint inside or outside of the service mesh.</p>', ], ], 'EgressFilterType' => [ 'base' => NULL, 'refs' => [], ], 'FileAccessLog' => [ 'base' => '<p>An object that represents an access log file.</p>', 'refs' => [ 'FileAccessLog$path' => '<p>The file path to write access logs to. You can use <code>/dev/stdout</code> to send access logs to standard out and configure your Envoy container to use a log driver, such as <code>awslogs</code>, to export the access logs to a log storage service such as Amazon CloudWatch Logs. You can also specify a path in the Envoy container\'s file system to write the files to disk.</p> <note> <p>The Envoy process must have write permissions to the path that you specify here. Otherwise, Envoy fails to bootstrap properly.</p> </note>', ], ], 'FilePath' => [ 'base' => NULL, 'refs' => [], ], 'ForbiddenException' => [ 'base' => '<p>You don\'t have permissions to perform this action.</p>', 'refs' => [], ], 'GatewayRouteData' => [ 'base' => '<p>An object that represents a gateway route returned by a describe operation.</p>', 'refs' => [ 'GatewayRouteData$gatewayRouteName' => '<p>The name of the gateway route.</p>', 'GatewayRouteData$meshName' => '<p>The name of the service mesh that the resource resides in. </p>', 'GatewayRouteData$spec' => '<p>The specifications of the gateway route.</p>', 'GatewayRouteData$status' => '<p>The status of the gateway route.</p>', 'GatewayRouteData$virtualGatewayName' => '<p>The virtual gateway that the gateway route is associated with.</p>', ], ], 'GatewayRouteList' => [ 'base' => NULL, 'refs' => [ 'GatewayRouteList$member' => NULL, ], ], 'GatewayRouteRef' => [ 'base' => '<p>An object that represents a gateway route returned by a list operation.</p>', 'refs' => [ 'GatewayRouteRef$arn' => '<p>The full Amazon Resource Name (ARN) for the gateway route.</p>', 'GatewayRouteRef$createdAt' => '<p>The Unix epoch timestamp in seconds for when the resource was created.</p>', 'GatewayRouteRef$gatewayRouteName' => '<p>The name of the gateway route.</p>', 'GatewayRouteRef$lastUpdatedAt' => '<p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>', 'GatewayRouteRef$meshName' => '<p>The name of the service mesh that the resource resides in. </p>', 'GatewayRouteRef$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'GatewayRouteRef$resourceOwner' => '<p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it\'s the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'GatewayRouteRef$version' => '<p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they\'re updated.</p>', 'GatewayRouteRef$virtualGatewayName' => '<p>The virtual gateway that the gateway route is associated with.</p>', ], ], 'GatewayRouteSpec' => [ 'base' => '<p>An object that represents a gateway route specification. Specify one gateway route type.</p>', 'refs' => [ 'GatewayRouteSpec$grpcRoute' => '<p>An object that represents the specification of a gRPC gateway route.</p>', 'GatewayRouteSpec$http2Route' => '<p>An object that represents the specification of an HTTP/2 gateway route.</p>', 'GatewayRouteSpec$httpRoute' => '<p>An object that represents the specification of an HTTP gateway route.</p>', ], ], 'GatewayRouteStatus' => [ 'base' => '<p>An object that represents the current status of a gateway route.</p>', 'refs' => [ 'GatewayRouteStatus$status' => '<p>The current status for the gateway route.</p>', ], ], 'GatewayRouteStatusCode' => [ 'base' => NULL, 'refs' => [], ], 'GatewayRouteTarget' => [ 'base' => '<p>An object that represents a gateway route target.</p>', 'refs' => [ 'GatewayRouteTarget$virtualService' => '<p>An object that represents a virtual service gateway route target.</p>', ], ], 'GatewayRouteVirtualService' => [ 'base' => '<p>An object that represents the virtual service that traffic is routed to.</p>', 'refs' => [ 'GatewayRouteVirtualService$virtualServiceName' => '<p>The name of the virtual service that traffic is routed to.</p>', ], ], 'GrpcGatewayRoute' => [ 'base' => '<p>An object that represents a gRPC gateway route.</p>', 'refs' => [ 'GrpcGatewayRoute$action' => '<p>An object that represents the action to take if a match is determined.</p>', 'GrpcGatewayRoute$match' => '<p>An object that represents the criteria for determining a request match.</p>', ], ], 'GrpcGatewayRouteAction' => [ 'base' => '<p>An object that represents the action to take if a match is determined.</p>', 'refs' => [ 'GrpcGatewayRouteAction$target' => '<p>An object that represents the target that traffic is routed to when a request matches the gateway route.</p>', ], ], 'GrpcGatewayRouteMatch' => [ 'base' => '<p>An object that represents the criteria for determining a request match.</p>', 'refs' => [ 'GrpcGatewayRouteMatch$serviceName' => '<p>The fully qualified domain name for the service to match from the request.</p>', ], ], 'GrpcRetryPolicy' => [ 'base' => '<p>An object that represents a retry policy. Specify at least one value for at least one of the types of <code>RetryEvents</code>, a value for <code>maxRetries</code>, and a value for <code>perRetryTimeout</code>.</p>', 'refs' => [ 'GrpcRetryPolicy$grpcRetryEvents' => '<p>Specify at least one of the valid values.</p>', 'GrpcRetryPolicy$httpRetryEvents' => '<p>Specify at least one of the following values.</p> <ul> <li> <p> <b>server-error</b> – HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511</p> </li> <li> <p> <b>gateway-error</b> – HTTP status codes 502, 503, and 504</p> </li> <li> <p> <b>client-error</b> – HTTP status code 409</p> </li> <li> <p> <b>stream-error</b> – Retry on refused stream</p> </li> </ul>', 'GrpcRetryPolicy$maxRetries' => '<p>The maximum number of retry attempts.</p>', 'GrpcRetryPolicy$perRetryTimeout' => '<p>An object that represents a duration of time.</p>', 'GrpcRetryPolicy$tcpRetryEvents' => '<p>Specify a valid value.</p>', ], ], 'GrpcRetryPolicyEvent' => [ 'base' => NULL, 'refs' => [], ], 'GrpcRetryPolicyEvents' => [ 'base' => NULL, 'refs' => [ 'GrpcRetryPolicyEvents$member' => NULL, ], ], 'GrpcRoute' => [ 'base' => '<p>An object that represents a gRPC route type.</p>', 'refs' => [ 'GrpcRoute$action' => '<p>An object that represents the action to take if a match is determined.</p>', 'GrpcRoute$match' => '<p>An object that represents the criteria for determining a request match.</p>', 'GrpcRoute$retryPolicy' => '<p>An object that represents a retry policy.</p>', 'GrpcRoute$timeout' => '<p>An object that represents types of timeouts. </p>', ], ], 'GrpcRouteAction' => [ 'base' => '<p>An object that represents the action to take if a match is determined.</p>', 'refs' => [ 'GrpcRouteAction$weightedTargets' => '<p>An object that represents the targets that traffic is routed to when a request matches the route.</p>', ], ], 'GrpcRouteMatch' => [ 'base' => '<p>An object that represents the criteria for determining a request match.</p>', 'refs' => [ 'GrpcRouteMatch$metadata' => '<p>An object that represents the data to match from the request.</p>', 'GrpcRouteMatch$methodName' => '<p>The method name to match from the request. If you specify a name, you must also specify a <code>serviceName</code>.</p>', 'GrpcRouteMatch$serviceName' => '<p>The fully qualified domain name for the service to match from the request.</p>', ], ], 'GrpcRouteMetadata' => [ 'base' => '<p>An object that represents the match metadata for the route.</p>', 'refs' => [ 'GrpcRouteMetadata$invert' => '<p>Specify <code>True</code> to match anything except the match criteria. The default value is <code>False</code>.</p>', 'GrpcRouteMetadata$match' => '<p>An object that represents the data to match from the request.</p>', 'GrpcRouteMetadata$name' => '<p>The name of the route.</p>', ], ], 'GrpcRouteMetadataList' => [ 'base' => NULL, 'refs' => [ 'GrpcRouteMetadataList$member' => NULL, ], ], 'GrpcRouteMetadataMatchMethod' => [ 'base' => '<p>An object that represents the match method. Specify one of the match values.</p>', 'refs' => [ 'GrpcRouteMetadataMatchMethod$exact' => '<p>The value sent by the client must match the specified value exactly.</p>', 'GrpcRouteMetadataMatchMethod$prefix' => '<p>The value sent by the client must begin with the specified characters.</p>', 'GrpcRouteMetadataMatchMethod$range' => '<p>An object that represents the range of values to match on.</p>', 'GrpcRouteMetadataMatchMethod$regex' => '<p>The value sent by the client must include the specified characters.</p>', 'GrpcRouteMetadataMatchMethod$suffix' => '<p>The value sent by the client must end with the specified characters.</p>', ], ], 'GrpcTimeout' => [ 'base' => '<p>An object that represents types of timeouts. </p>', 'refs' => [ 'GrpcTimeout$idle' => '<p>An object that represents an idle timeout. An idle timeout bounds the amount of time that a connection may be idle. The default value is none.</p>', 'GrpcTimeout$perRequest' => '<p>An object that represents a per request timeout. The default value is 15 seconds. If you set a higher timeout, then make sure that the higher value is set for each App Mesh resource in a conversation. For example, if a virtual node backend uses a virtual router provider to route to another virtual node, then the timeout should be greater than 15 seconds for the source and destination virtual node and the route.</p>', ], ], 'HeaderMatch' => [ 'base' => NULL, 'refs' => [], ], 'HeaderMatchMethod' => [ 'base' => '<p>An object that represents the method and value to match with the header value sent in a request. Specify one match method.</p>', 'refs' => [ 'HeaderMatchMethod$exact' => '<p>The value sent by the client must match the specified value exactly.</p>', 'HeaderMatchMethod$prefix' => '<p>The value sent by the client must begin with the specified characters.</p>', 'HeaderMatchMethod$range' => '<p>An object that represents the range of values to match on.</p>', 'HeaderMatchMethod$regex' => '<p>The value sent by the client must include the specified characters.</p>', 'HeaderMatchMethod$suffix' => '<p>The value sent by the client must end with the specified characters.</p>', ], ], 'HeaderName' => [ 'base' => NULL, 'refs' => [], ], 'HealthCheckIntervalMillis' => [ 'base' => NULL, 'refs' => [], ], 'HealthCheckPolicy' => [ 'base' => '<p>An object that represents the health check policy for a virtual node\'s listener.</p>', 'refs' => [ 'HealthCheckPolicy$healthyThreshold' => '<p>The number of consecutive successful health checks that must occur before declaring listener healthy.</p>', 'HealthCheckPolicy$intervalMillis' => '<p>The time period in milliseconds between each health check execution.</p>', 'HealthCheckPolicy$path' => '<p>The destination path for the health check request. This value is only used if the specified protocol is HTTP or HTTP/2. For any other protocol, this value is ignored.</p>', 'HealthCheckPolicy$port' => '<p>The destination port for the health check request. This port must match the port defined in the <a>PortMapping</a> for the listener.</p>', 'HealthCheckPolicy$protocol' => '<p>The protocol for the health check request. If you specify <code>grpc</code>, then your service must conform to the <a href="https://github.com/grpc/grpc/blob/master/doc/health-checking.md">GRPC Health Checking Protocol</a>.</p>', 'HealthCheckPolicy$timeoutMillis' => '<p>The amount of time to wait when receiving a response from the health check, in milliseconds.</p>', 'HealthCheckPolicy$unhealthyThreshold' => '<p>The number of consecutive failed health checks that must occur before declaring a virtual node unhealthy. </p>', ], ], 'HealthCheckThreshold' => [ 'base' => NULL, 'refs' => [], ], 'HealthCheckTimeoutMillis' => [ 'base' => NULL, 'refs' => [], ], 'Hostname' => [ 'base' => NULL, 'refs' => [], ], 'HttpGatewayRoute' => [ 'base' => '<p>An object that represents an HTTP gateway route.</p>', 'refs' => [ 'HttpGatewayRoute$action' => '<p>An object that represents the action to take if a match is determined.</p>', 'HttpGatewayRoute$match' => '<p>An object that represents the criteria for determining a request match.</p>', ], ], 'HttpGatewayRouteAction' => [ 'base' => '<p>An object that represents the action to take if a match is determined.</p>', 'refs' => [ 'HttpGatewayRouteAction$target' => '<p>An object that represents the target that traffic is routed to when a request matches the gateway route.</p>', ], ], 'HttpGatewayRouteMatch' => [ 'base' => '<p>An object that represents the criteria for determining a request match.</p>', 'refs' => [ 'HttpGatewayRouteMatch$prefix' => '<p>Specifies the path to match requests with. This parameter must always start with <code>/</code>, which by itself matches all requests to the virtual service name. You can also match for path-based routing of requests. For example, if your virtual service name is <code>my-service.local</code> and you want the route to match requests to <code>my-service.local/metrics</code>, your prefix should be <code>/metrics</code>.</p>', ], ], 'HttpMethod' => [ 'base' => NULL, 'refs' => [], ], 'HttpRetryPolicy' => [ 'base' => '<p>An object that represents a retry policy. Specify at least one value for at least one of the types of <code>RetryEvents</code>, a value for <code>maxRetries</code>, and a value for <code>perRetryTimeout</code>.</p>', 'refs' => [ 'HttpRetryPolicy$httpRetryEvents' => '<p>Specify at least one of the following values.</p> <ul> <li> <p> <b>server-error</b> – HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511</p> </li> <li> <p> <b>gateway-error</b> – HTTP status codes 502, 503, and 504</p> </li> <li> <p> <b>client-error</b> – HTTP status code 409</p> </li> <li> <p> <b>stream-error</b> – Retry on refused stream</p> </li> </ul>', 'HttpRetryPolicy$maxRetries' => '<p>The maximum number of retry attempts.</p>', 'HttpRetryPolicy$perRetryTimeout' => '<p>An object that represents a duration of time.</p>', 'HttpRetryPolicy$tcpRetryEvents' => '<p>Specify a valid value.</p>', ], ], 'HttpRetryPolicyEvent' => [ 'base' => NULL, 'refs' => [], ], 'HttpRetryPolicyEvents' => [ 'base' => NULL, 'refs' => [ 'HttpRetryPolicyEvents$member' => NULL, ], ], 'HttpRoute' => [ 'base' => '<p>An object that represents an HTTP or HTTP/2 route type.</p>', 'refs' => [ 'HttpRoute$action' => '<p>An object that represents the action to take if a match is determined.</p>', 'HttpRoute$match' => '<p>An object that represents the criteria for determining a request match.</p>', 'HttpRoute$retryPolicy' => '<p>An object that represents a retry policy.</p>', 'HttpRoute$timeout' => '<p>An object that represents types of timeouts. </p>', ], ], 'HttpRouteAction' => [ 'base' => '<p>An object that represents the action to take if a match is determined.</p>', 'refs' => [ 'HttpRouteAction$weightedTargets' => '<p>An object that represents the targets that traffic is routed to when a request matches the route.</p>', ], ], 'HttpRouteHeader' => [ 'base' => '<p>An object that represents the HTTP header in the request.</p>', 'refs' => [ 'HttpRouteHeader$invert' => '<p>Specify <code>True</code> to match anything except the match criteria. The default value is <code>False</code>.</p>', 'HttpRouteHeader$match' => '<p>The <code>HeaderMatchMethod</code> object.</p>', 'HttpRouteHeader$name' => '<p>A name for the HTTP header in the client request that will be matched on.</p>', ], ], 'HttpRouteHeaders' => [ 'base' => NULL, 'refs' => [ 'HttpRouteHeaders$member' => NULL, ], ], 'HttpRouteMatch' => [ 'base' => '<p>An object that represents the requirements for a route to match HTTP requests for a virtual router.</p>', 'refs' => [ 'HttpRouteMatch$headers' => '<p>An object that represents the client request headers to match on.</p>', 'HttpRouteMatch$method' => '<p>The client request method to match on. Specify only one.</p>', 'HttpRouteMatch$prefix' => '<p>Specifies the path to match requests with. This parameter must always start with <code>/</code>, which by itself matches all requests to the virtual service name. You can also match for path-based routing of requests. For example, if your virtual service name is <code>my-service.local</code> and you want the route to match requests to <code>my-service.local/metrics</code>, your prefix should be <code>/metrics</code>.</p>', 'HttpRouteMatch$scheme' => '<p>The client request scheme to match on. Specify only one.</p>', ], ], 'HttpScheme' => [ 'base' => NULL, 'refs' => [], ], 'HttpTimeout' => [ 'base' => '<p>An object that represents types of timeouts. </p>', 'refs' => [], ], 'InternalServerErrorException' => [ 'base' => '<p>The request processing has failed because of an unknown error, exception, or failure.</p>', 'refs' => [], ], 'LimitExceededException' => [ 'base' => '<p>You have exceeded a service limit for your account. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in the <i>AWS App Mesh User Guide</i>.</p>', 'refs' => [], ], 'ListGatewayRoutesInput' => [ 'base' => NULL, 'refs' => [ 'ListGatewayRoutesInput$limit' => '<p>The maximum number of results returned by <code>ListGatewayRoutes</code> in paginated output. When you use this parameter, <code>ListGatewayRoutes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListGatewayRoutes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don\'t use this parameter, <code>ListGatewayRoutes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>', 'ListGatewayRoutesInput$meshName' => '<p>The name of the service mesh to list gateway routes in.</p>', 'ListGatewayRoutesInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'ListGatewayRoutesInput$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>ListGatewayRoutes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>', 'ListGatewayRoutesInput$virtualGatewayName' => '<p>The name of the virtual gateway to list gateway routes in.</p>', ], ], 'ListGatewayRoutesLimit' => [ 'base' => NULL, 'refs' => [], ], 'ListGatewayRoutesOutput' => [ 'base' => NULL, 'refs' => [ 'ListGatewayRoutesOutput$gatewayRoutes' => '<p>The list of existing gateway routes for the specified service mesh and virtual gateway.</p>', 'ListGatewayRoutesOutput$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListGatewayRoutes</code> request. When the results of a <code>ListGatewayRoutes</code> request exceed <code>limit</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', ], ], 'ListMeshesInput' => [ 'base' => '', 'refs' => [ 'ListMeshesInput$limit' => '<p>The maximum number of results returned by <code>ListMeshes</code> in paginated output. When you use this parameter, <code>ListMeshes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListMeshes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don\'t use this parameter, <code>ListMeshes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>', 'ListMeshesInput$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>ListMeshes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p> <note> <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', ], ], 'ListMeshesLimit' => [ 'base' => NULL, 'refs' => [], ], 'ListMeshesOutput' => [ 'base' => '', 'refs' => [ 'ListMeshesOutput$meshes' => '<p>The list of existing service meshes.</p>', 'ListMeshesOutput$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListMeshes</code> request. When the results of a <code>ListMeshes</code> request exceed <code>limit</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', ], ], 'ListRoutesInput' => [ 'base' => '', 'refs' => [ 'ListRoutesInput$limit' => '<p>The maximum number of results returned by <code>ListRoutes</code> in paginated output. When you use this parameter, <code>ListRoutes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListRoutes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don\'t use this parameter, <code>ListRoutes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>', 'ListRoutesInput$meshName' => '<p>The name of the service mesh to list routes in.</p>', 'ListRoutesInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'ListRoutesInput$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>ListRoutes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>', 'ListRoutesInput$virtualRouterName' => '<p>The name of the virtual router to list routes in.</p>', ], ], 'ListRoutesLimit' => [ 'base' => NULL, 'refs' => [], ], 'ListRoutesOutput' => [ 'base' => '', 'refs' => [ 'ListRoutesOutput$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListRoutes</code> request. When the results of a <code>ListRoutes</code> request exceed <code>limit</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'ListRoutesOutput$routes' => '<p>The list of existing routes for the specified service mesh and virtual router.</p>', ], ], 'ListTagsForResourceInput' => [ 'base' => '', 'refs' => [ 'ListTagsForResourceInput$limit' => '<p>The maximum number of tag results returned by <code>ListTagsForResource</code> in paginated output. When this parameter is used, <code>ListTagsForResource</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListTagsForResource</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don\'t use this parameter, <code>ListTagsForResource</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>', 'ListTagsForResourceInput$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>ListTagsForResource</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>', 'ListTagsForResourceInput$resourceArn' => '<p>The Amazon Resource Name (ARN) that identifies the resource to list the tags for.</p>', ], ], 'ListTagsForResourceOutput' => [ 'base' => '', 'refs' => [ 'ListTagsForResourceOutput$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListTagsForResource</code> request. When the results of a <code>ListTagsForResource</code> request exceed <code>limit</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'ListTagsForResourceOutput$tags' => '<p>The tags for the resource.</p>', ], ], 'ListVirtualGatewaysInput' => [ 'base' => NULL, 'refs' => [ 'ListVirtualGatewaysInput$limit' => '<p>The maximum number of results returned by <code>ListVirtualGateways</code> in paginated output. When you use this parameter, <code>ListVirtualGateways</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualGateways</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don\'t use this parameter, <code>ListVirtualGateways</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>', 'ListVirtualGatewaysInput$meshName' => '<p>The name of the service mesh to list virtual gateways in.</p>', 'ListVirtualGatewaysInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'ListVirtualGatewaysInput$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualGateways</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>', ], ], 'ListVirtualGatewaysLimit' => [ 'base' => NULL, 'refs' => [], ], 'ListVirtualGatewaysOutput' => [ 'base' => NULL, 'refs' => [ 'ListVirtualGatewaysOutput$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListVirtualGateways</code> request. When the results of a <code>ListVirtualGateways</code> request exceed <code>limit</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'ListVirtualGatewaysOutput$virtualGateways' => '<p>The list of existing virtual gateways for the specified service mesh.</p>', ], ], 'ListVirtualNodesInput' => [ 'base' => '', 'refs' => [ 'ListVirtualNodesInput$limit' => '<p>The maximum number of results returned by <code>ListVirtualNodes</code> in paginated output. When you use this parameter, <code>ListVirtualNodes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualNodes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don\'t use this parameter, <code>ListVirtualNodes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>', 'ListVirtualNodesInput$meshName' => '<p>The name of the service mesh to list virtual nodes in.</p>', 'ListVirtualNodesInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'ListVirtualNodesInput$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualNodes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>', ], ], 'ListVirtualNodesLimit' => [ 'base' => NULL, 'refs' => [], ], 'ListVirtualNodesOutput' => [ 'base' => '', 'refs' => [ 'ListVirtualNodesOutput$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListVirtualNodes</code> request. When the results of a <code>ListVirtualNodes</code> request exceed <code>limit</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'ListVirtualNodesOutput$virtualNodes' => '<p>The list of existing virtual nodes for the specified service mesh.</p>', ], ], 'ListVirtualRoutersInput' => [ 'base' => '', 'refs' => [ 'ListVirtualRoutersInput$limit' => '<p>The maximum number of results returned by <code>ListVirtualRouters</code> in paginated output. When you use this parameter, <code>ListVirtualRouters</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualRouters</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don\'t use this parameter, <code>ListVirtualRouters</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>', 'ListVirtualRoutersInput$meshName' => '<p>The name of the service mesh to list virtual routers in.</p>', 'ListVirtualRoutersInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'ListVirtualRoutersInput$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualRouters</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>', ], ], 'ListVirtualRoutersLimit' => [ 'base' => NULL, 'refs' => [], ], 'ListVirtualRoutersOutput' => [ 'base' => '', 'refs' => [ 'ListVirtualRoutersOutput$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListVirtualRouters</code> request. When the results of a <code>ListVirtualRouters</code> request exceed <code>limit</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'ListVirtualRoutersOutput$virtualRouters' => '<p>The list of existing virtual routers for the specified service mesh.</p>', ], ], 'ListVirtualServicesInput' => [ 'base' => '', 'refs' => [ 'ListVirtualServicesInput$limit' => '<p>The maximum number of results returned by <code>ListVirtualServices</code> in paginated output. When you use this parameter, <code>ListVirtualServices</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualServices</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don\'t use this parameter, <code>ListVirtualServices</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>', 'ListVirtualServicesInput$meshName' => '<p>The name of the service mesh to list virtual services in.</p>', 'ListVirtualServicesInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'ListVirtualServicesInput$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualServices</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>', ], ], 'ListVirtualServicesLimit' => [ 'base' => NULL, 'refs' => [], ], 'ListVirtualServicesOutput' => [ 'base' => '', 'refs' => [ 'ListVirtualServicesOutput$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListVirtualServices</code> request. When the results of a <code>ListVirtualServices</code> request exceed <code>limit</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'ListVirtualServicesOutput$virtualServices' => '<p>The list of existing virtual services for the specified service mesh.</p>', ], ], 'Listener' => [ 'base' => '<p>An object that represents a listener for a virtual node.</p>', 'refs' => [ 'Listener$healthCheck' => '<p>The health check information for the listener.</p>', 'Listener$portMapping' => '<p>The port mapping information for the listener.</p>', 'Listener$timeout' => '<p>An object that represents timeouts for different protocols.</p>', 'Listener$tls' => '<p>A reference to an object that represents the Transport Layer Security (TLS) properties for a listener.</p>', ], ], 'ListenerTimeout' => [ 'base' => '<p>An object that represents timeouts for different protocols.</p>', 'refs' => [ 'ListenerTimeout$http' => '<p>An object that represents types of timeouts. </p>', 'ListenerTimeout$http2' => '<p>An object that represents types of timeouts. </p>', 'ListenerTimeout$tcp' => '<p>An object that represents types of timeouts. </p>', ], ], 'ListenerTls' => [ 'base' => '<p>An object that represents the Transport Layer Security (TLS) properties for a listener.</p>', 'refs' => [ 'ListenerTls$certificate' => '<p>A reference to an object that represents a listener\'s TLS certificate.</p>', 'ListenerTls$mode' => '<p>Specify one of the following modes.</p> <ul> <li> <p> <b/>STRICT – Listener only accepts connections with TLS enabled. </p> </li> <li> <p> <b/>PERMISSIVE – Listener accepts connections with or without TLS enabled.</p> </li> <li> <p> <b/>DISABLED – Listener only accepts connections without TLS. </p> </li> </ul>', ], ], 'ListenerTlsAcmCertificate' => [ 'base' => '<p>An object that represents an AWS Certicate Manager (ACM) certificate.</p>', 'refs' => [ 'ListenerTlsAcmCertificate$certificateArn' => '<p>The Amazon Resource Name (ARN) for the certificate. The certificate must meet specific requirements and you must have proxy authorization enabled. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites">Transport Layer Security (TLS)</a>.</p>', ], ], 'ListenerTlsCertificate' => [ 'base' => '<p>An object that represents a listener\'s Transport Layer Security (TLS) certificate.</p>', 'refs' => [ 'ListenerTlsCertificate$acm' => '<p>A reference to an object that represents an AWS Certicate Manager (ACM) certificate.</p>', 'ListenerTlsCertificate$file' => '<p>A reference to an object that represents a local file certificate.</p>', ], ], 'ListenerTlsFileCertificate' => [ 'base' => '<p>An object that represents a local file certificate. The certificate must meet specific requirements and you must have proxy authorization enabled. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites">Transport Layer Security (TLS)</a>.</p>', 'refs' => [ 'ListenerTlsFileCertificate$certificateChain' => '<p>The certificate chain for the certificate.</p>', 'ListenerTlsFileCertificate$privateKey' => '<p>The private key for a certificate stored on the file system of the virtual node that the proxy is running on.</p>', ], ], 'ListenerTlsMode' => [ 'base' => NULL, 'refs' => [], ], 'Listeners' => [ 'base' => NULL, 'refs' => [ 'Listeners$member' => NULL, ], ], 'Logging' => [ 'base' => '<p>An object that represents the logging information for a virtual node.</p>', 'refs' => [ 'Logging$accessLog' => '<p>The access log configuration for a virtual node.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [], ], 'MatchRange' => [ 'base' => '<p>An object that represents the range of values to match on. The first character of the range is included in the range, though the last character is not. For example, if the range specified were 1-100, only values 1-99 would be matched.</p>', 'refs' => [ 'MatchRange$end' => '<p>The end of the range.</p>', 'MatchRange$start' => '<p>The start of the range.</p>', ], ], 'MaxRetries' => [ 'base' => NULL, 'refs' => [], ], 'MeshData' => [ 'base' => '<p>An object that represents a service mesh returned by a describe operation.</p>', 'refs' => [ 'MeshData$meshName' => '<p>The name of the service mesh.</p>', 'MeshData$metadata' => '<p>The associated metadata for the service mesh.</p>', 'MeshData$spec' => '<p>The associated specification for the service mesh.</p>', 'MeshData$status' => '<p>The status of the service mesh.</p>', ], ], 'MeshList' => [ 'base' => NULL, 'refs' => [ 'MeshList$member' => NULL, ], ], 'MeshRef' => [ 'base' => '<p>An object that represents a service mesh returned by a list operation.</p>', 'refs' => [ 'MeshRef$arn' => '<p>The full Amazon Resource Name (ARN) of the service mesh.</p>', 'MeshRef$createdAt' => '<p>The Unix epoch timestamp in seconds for when the resource was created.</p>', 'MeshRef$lastUpdatedAt' => '<p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>', 'MeshRef$meshName' => '<p>The name of the service mesh.</p>', 'MeshRef$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'MeshRef$resourceOwner' => '<p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it\'s the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'MeshRef$version' => '<p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they\'re updated.</p>', ], ], 'MeshSpec' => [ 'base' => '<p>An object that represents the specification of a service mesh.</p>', 'refs' => [ 'MeshSpec$egressFilter' => '<p>The egress filter rules for the service mesh.</p>', ], ], 'MeshStatus' => [ 'base' => '<p>An object that represents the status of a service mesh.</p>', 'refs' => [ 'MeshStatus$status' => '<p>The current mesh status.</p>', ], ], 'MeshStatusCode' => [ 'base' => NULL, 'refs' => [], ], 'MethodName' => [ 'base' => NULL, 'refs' => [], ], 'NotFoundException' => [ 'base' => '<p>The specified resource doesn\'t exist. Check your request syntax and try again.</p>', 'refs' => [], ], 'PercentInt' => [ 'base' => NULL, 'refs' => [], ], 'PortMapping' => [ 'base' => '<p>An object that represents a port mapping.</p>', 'refs' => [ 'PortMapping$port' => '<p>The port used for the port mapping.</p>', 'PortMapping$protocol' => '<p>The protocol used for the port mapping. Specify one protocol.</p>', ], ], 'PortNumber' => [ 'base' => NULL, 'refs' => [], ], 'PortProtocol' => [ 'base' => NULL, 'refs' => [], ], 'PortSet' => [ 'base' => NULL, 'refs' => [ 'PortSet$member' => NULL, ], ], 'ResourceInUseException' => [ 'base' => '<p>You can\'t delete the specified resource because it\'s in use or required by another resource.</p>', 'refs' => [], ], 'ResourceMetadata' => [ 'base' => '<p>An object that represents metadata for a resource.</p>', 'refs' => [ 'ResourceMetadata$arn' => '<p>The full Amazon Resource Name (ARN) for the resource.</p>', 'ResourceMetadata$createdAt' => '<p>The Unix epoch timestamp in seconds for when the resource was created.</p>', 'ResourceMetadata$lastUpdatedAt' => '<p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>', 'ResourceMetadata$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'ResourceMetadata$resourceOwner' => '<p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it\'s the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'ResourceMetadata$uid' => '<p>The unique identifier for the resource.</p>', 'ResourceMetadata$version' => '<p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they\'re updated.</p>', ], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [], ], 'RouteData' => [ 'base' => '<p>An object that represents a route returned by a describe operation.</p>', 'refs' => [ 'RouteData$meshName' => '<p>The name of the service mesh that the route resides in.</p>', 'RouteData$metadata' => '<p>The associated metadata for the route.</p>', 'RouteData$routeName' => '<p>The name of the route.</p>', 'RouteData$spec' => '<p>The specifications of the route.</p>', 'RouteData$status' => '<p>The status of the route.</p>', 'RouteData$virtualRouterName' => '<p>The virtual router that the route is associated with.</p>', ], ], 'RouteList' => [ 'base' => NULL, 'refs' => [ 'RouteList$member' => NULL, ], ], 'RoutePriority' => [ 'base' => NULL, 'refs' => [], ], 'RouteRef' => [ 'base' => '<p>An object that represents a route returned by a list operation.</p>', 'refs' => [ 'RouteRef$arn' => '<p>The full Amazon Resource Name (ARN) for the route.</p>', 'RouteRef$createdAt' => '<p>The Unix epoch timestamp in seconds for when the resource was created.</p>', 'RouteRef$lastUpdatedAt' => '<p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>', 'RouteRef$meshName' => '<p>The name of the service mesh that the route resides in.</p>', 'RouteRef$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'RouteRef$resourceOwner' => '<p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it\'s the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'RouteRef$routeName' => '<p>The name of the route.</p>', 'RouteRef$version' => '<p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they\'re updated.</p>', 'RouteRef$virtualRouterName' => '<p>The virtual router that the route is associated with.</p>', ], ], 'RouteSpec' => [ 'base' => '<p>An object that represents a route specification. Specify one route type.</p>', 'refs' => [ 'RouteSpec$grpcRoute' => '<p>An object that represents the specification of a gRPC route.</p>', 'RouteSpec$http2Route' => '<p>An object that represents the specification of an HTTP/2 route.</p>', 'RouteSpec$httpRoute' => '<p>An object that represents the specification of an HTTP route.</p>', 'RouteSpec$priority' => '<p>The priority for the route. Routes are matched based on the specified value, where 0 is the highest priority.</p>', 'RouteSpec$tcpRoute' => '<p>An object that represents the specification of a TCP route.</p>', ], ], 'RouteStatus' => [ 'base' => '<p>An object that represents the current status of a route.</p>', 'refs' => [ 'RouteStatus$status' => '<p>The current status for the route.</p>', ], ], 'RouteStatusCode' => [ 'base' => NULL, 'refs' => [], ], 'ServiceDiscovery' => [ 'base' => '<p>An object that represents the service discovery information for a virtual node.</p>', 'refs' => [ 'ServiceDiscovery$awsCloudMap' => '<p>Specifies any AWS Cloud Map information for the virtual node.</p>', 'ServiceDiscovery$dns' => '<p>Specifies the DNS information for the virtual node.</p>', ], ], 'ServiceName' => [ 'base' => NULL, 'refs' => [], ], 'ServiceUnavailableException' => [ 'base' => '<p>The request has failed due to a temporary failure of the service.</p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [], ], 'TagKey' => [ 'base' => NULL, 'refs' => [], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'TagList$member' => NULL, ], ], 'TagRef' => [ 'base' => '<p>Optional metadata that you apply to a resource to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>', 'refs' => [ 'TagRef$key' => '<p>One part of a key-value pair that make up a tag. A <code>key</code> is a general label that acts like a category for more specific tag values.</p>', 'TagRef$value' => '<p>The optional part of a key-value pair that make up a tag. A <code>value</code> acts as a descriptor within a tag category (key).</p>', ], ], 'TagResourceInput' => [ 'base' => '', 'refs' => [ 'TagResourceInput$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to add tags to.</p>', 'TagResourceInput$tags' => '<p>The tags to add to the resource. A tag is an array of key-value pairs. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>', ], ], 'TagResourceOutput' => [ 'base' => '', 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [], ], 'TagsLimit' => [ 'base' => NULL, 'refs' => [], ], 'TcpRetryPolicyEvent' => [ 'base' => NULL, 'refs' => [], ], 'TcpRetryPolicyEvents' => [ 'base' => NULL, 'refs' => [ 'TcpRetryPolicyEvents$member' => NULL, ], ], 'TcpRoute' => [ 'base' => '<p>An object that represents a TCP route type.</p>', 'refs' => [ 'TcpRoute$action' => '<p>The action to take if a match is determined.</p>', 'TcpRoute$timeout' => '<p>An object that represents types of timeouts. </p>', ], ], 'TcpRouteAction' => [ 'base' => '<p>An object that represents the action to take if a match is determined.</p>', 'refs' => [ 'TcpRouteAction$weightedTargets' => '<p>An object that represents the targets that traffic is routed to when a request matches the route.</p>', ], ], 'TcpTimeout' => [ 'base' => '<p>An object that represents types of timeouts. </p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [], ], 'TlsValidationContext' => [ 'base' => '<p>An object that represents a Transport Layer Security (TLS) validation context.</p>', 'refs' => [ 'TlsValidationContext$trust' => '<p>A reference to an object that represents a TLS validation context trust.</p>', ], ], 'TlsValidationContextAcmTrust' => [ 'base' => '<p>An object that represents a TLS validation context trust for an AWS Certicate Manager (ACM) certificate.</p>', 'refs' => [ 'TlsValidationContextAcmTrust$certificateAuthorityArns' => '<p>One or more ACM Amazon Resource Name (ARN)s.</p>', ], ], 'TlsValidationContextFileTrust' => [ 'base' => '<p>An object that represents a Transport Layer Security (TLS) validation context trust for a local file.</p>', 'refs' => [ 'TlsValidationContextFileTrust$certificateChain' => '<p>The certificate trust chain for a certificate stored on the file system of the virtual node that the proxy is running on.</p>', ], ], 'TlsValidationContextTrust' => [ 'base' => '<p>An object that represents a Transport Layer Security (TLS) validation context trust.</p>', 'refs' => [ 'TlsValidationContextTrust$acm' => '<p>A reference to an object that represents a TLS validation context trust for an AWS Certicate Manager (ACM) certificate.</p>', 'TlsValidationContextTrust$file' => '<p>An object that represents a TLS validation context trust for a local file.</p>', ], ], 'TooManyRequestsException' => [ 'base' => '<p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>', 'refs' => [], ], 'TooManyTagsException' => [ 'base' => '<p>The request exceeds the maximum allowed number of tags allowed per resource. The current limit is 50 user tags per resource. You must reduce the number of tags in the request. None of the tags in this request were applied.</p>', 'refs' => [], ], 'UntagResourceInput' => [ 'base' => '', 'refs' => [ 'UntagResourceInput$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to delete tags from.</p>', 'UntagResourceInput$tagKeys' => '<p>The keys of the tags to be removed.</p>', ], ], 'UntagResourceOutput' => [ 'base' => '', 'refs' => [], ], 'UpdateGatewayRouteInput' => [ 'base' => NULL, 'refs' => [ 'UpdateGatewayRouteInput$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>', 'UpdateGatewayRouteInput$gatewayRouteName' => '<p>The name of the gateway route to update.</p>', 'UpdateGatewayRouteInput$meshName' => '<p>The name of the service mesh that the gateway route resides in.</p>', 'UpdateGatewayRouteInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'UpdateGatewayRouteInput$spec' => '<p>The new gateway route specification to apply. This overwrites the existing data.</p>', 'UpdateGatewayRouteInput$virtualGatewayName' => '<p>The name of the virtual gateway that the gateway route is associated with.</p>', ], ], 'UpdateGatewayRouteOutput' => [ 'base' => NULL, 'refs' => [ 'UpdateGatewayRouteOutput$gatewayRoute' => '<p>A full description of the gateway route that was updated.</p>', ], ], 'UpdateMeshInput' => [ 'base' => '', 'refs' => [ 'UpdateMeshInput$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>', 'UpdateMeshInput$meshName' => '<p>The name of the service mesh to update.</p>', 'UpdateMeshInput$spec' => '<p>The service mesh specification to apply.</p>', ], ], 'UpdateMeshOutput' => [ 'base' => '', 'refs' => [], ], 'UpdateRouteInput' => [ 'base' => '', 'refs' => [ 'UpdateRouteInput$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>', 'UpdateRouteInput$meshName' => '<p>The name of the service mesh that the route resides in.</p>', 'UpdateRouteInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'UpdateRouteInput$routeName' => '<p>The name of the route to update.</p>', 'UpdateRouteInput$spec' => '<p>The new route specification to apply. This overwrites the existing data.</p>', 'UpdateRouteInput$virtualRouterName' => '<p>The name of the virtual router that the route is associated with.</p>', ], ], 'UpdateRouteOutput' => [ 'base' => '', 'refs' => [ 'UpdateRouteOutput$route' => '<p>A full description of the route that was updated.</p>', ], ], 'UpdateVirtualGatewayInput' => [ 'base' => NULL, 'refs' => [ 'UpdateVirtualGatewayInput$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>', 'UpdateVirtualGatewayInput$meshName' => '<p>The name of the service mesh that the virtual gateway resides in.</p>', 'UpdateVirtualGatewayInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'UpdateVirtualGatewayInput$spec' => '<p>The new virtual gateway specification to apply. This overwrites the existing data.</p>', 'UpdateVirtualGatewayInput$virtualGatewayName' => '<p>The name of the virtual gateway to update.</p>', ], ], 'UpdateVirtualGatewayOutput' => [ 'base' => NULL, 'refs' => [ 'UpdateVirtualGatewayOutput$virtualGateway' => '<p>A full description of the virtual gateway that was updated.</p>', ], ], 'UpdateVirtualNodeInput' => [ 'base' => '', 'refs' => [ 'UpdateVirtualNodeInput$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>', 'UpdateVirtualNodeInput$meshName' => '<p>The name of the service mesh that the virtual node resides in.</p>', 'UpdateVirtualNodeInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'UpdateVirtualNodeInput$spec' => '<p>The new virtual node specification to apply. This overwrites the existing data.</p>', 'UpdateVirtualNodeInput$virtualNodeName' => '<p>The name of the virtual node to update.</p>', ], ], 'UpdateVirtualNodeOutput' => [ 'base' => '', 'refs' => [ 'UpdateVirtualNodeOutput$virtualNode' => '<p>A full description of the virtual node that was updated.</p>', ], ], 'UpdateVirtualRouterInput' => [ 'base' => '', 'refs' => [ 'UpdateVirtualRouterInput$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>', 'UpdateVirtualRouterInput$meshName' => '<p>The name of the service mesh that the virtual router resides in.</p>', 'UpdateVirtualRouterInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'UpdateVirtualRouterInput$spec' => '<p>The new virtual router specification to apply. This overwrites the existing data.</p>', 'UpdateVirtualRouterInput$virtualRouterName' => '<p>The name of the virtual router to update.</p>', ], ], 'UpdateVirtualRouterOutput' => [ 'base' => '', 'refs' => [ 'UpdateVirtualRouterOutput$virtualRouter' => '<p>A full description of the virtual router that was updated.</p>', ], ], 'UpdateVirtualServiceInput' => [ 'base' => '', 'refs' => [ 'UpdateVirtualServiceInput$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of therequest. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>', 'UpdateVirtualServiceInput$meshName' => '<p>The name of the service mesh that the virtual service resides in.</p>', 'UpdateVirtualServiceInput$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'UpdateVirtualServiceInput$spec' => '<p>The new virtual service specification to apply. This overwrites the existing data.</p>', 'UpdateVirtualServiceInput$virtualServiceName' => '<p>The name of the virtual service to update.</p>', ], ], 'UpdateVirtualServiceOutput' => [ 'base' => '', 'refs' => [ 'UpdateVirtualServiceOutput$virtualService' => '<p>A full description of the virtual service that was updated.</p>', ], ], 'VirtualGatewayAccessLog' => [ 'base' => '<p>The access log configuration for a virtual gateway.</p>', 'refs' => [ 'VirtualGatewayAccessLog$file' => '<p>The file object to send virtual gateway access logs to.</p>', ], ], 'VirtualGatewayBackendDefaults' => [ 'base' => '<p>An object that represents the default properties for a backend.</p>', 'refs' => [ 'VirtualGatewayBackendDefaults$clientPolicy' => '<p>A reference to an object that represents a client policy.</p>', ], ], 'VirtualGatewayCertificateAuthorityArns' => [ 'base' => NULL, 'refs' => [ 'VirtualGatewayCertificateAuthorityArns$member' => NULL, ], ], 'VirtualGatewayClientPolicy' => [ 'base' => '<p>An object that represents a client policy.</p>', 'refs' => [ 'VirtualGatewayClientPolicy$tls' => '<p>A reference to an object that represents a Transport Layer Security (TLS) client policy.</p>', ], ], 'VirtualGatewayClientPolicyTls' => [ 'base' => '<p>An object that represents a Transport Layer Security (TLS) client policy.</p>', 'refs' => [ 'VirtualGatewayClientPolicyTls$enforce' => '<p>Whether the policy is enforced. The default is <code>True</code>, if a value isn\'t specified.</p>', 'VirtualGatewayClientPolicyTls$ports' => '<p>One or more ports that the policy is enforced for.</p>', 'VirtualGatewayClientPolicyTls$validation' => '<p>A reference to an object that represents a TLS validation context.</p>', ], ], 'VirtualGatewayData' => [ 'base' => '<p>An object that represents a virtual gateway returned by a describe operation.</p>', 'refs' => [ 'VirtualGatewayData$meshName' => '<p>The name of the service mesh that the virtual gateway resides in.</p>', 'VirtualGatewayData$spec' => '<p>The specifications of the virtual gateway.</p>', 'VirtualGatewayData$status' => '<p>The current status of the virtual gateway.</p>', 'VirtualGatewayData$virtualGatewayName' => '<p>The name of the virtual gateway.</p>', ], ], 'VirtualGatewayFileAccessLog' => [ 'base' => '<p>An object that represents an access log file.</p>', 'refs' => [ 'VirtualGatewayFileAccessLog$path' => '<p>The file path to write access logs to. You can use <code>/dev/stdout</code> to send access logs to standard out and configure your Envoy container to use a log driver, such as <code>awslogs</code>, to export the access logs to a log storage service such as Amazon CloudWatch Logs. You can also specify a path in the Envoy container\'s file system to write the files to disk.</p>', ], ], 'VirtualGatewayHealthCheckIntervalMillis' => [ 'base' => NULL, 'refs' => [], ], 'VirtualGatewayHealthCheckPolicy' => [ 'base' => '<p>An object that represents the health check policy for a virtual gateway\'s listener.</p>', 'refs' => [ 'VirtualGatewayHealthCheckPolicy$healthyThreshold' => '<p>The number of consecutive successful health checks that must occur before declaring the listener healthy.</p>', 'VirtualGatewayHealthCheckPolicy$intervalMillis' => '<p>The time period in milliseconds between each health check execution.</p>', 'VirtualGatewayHealthCheckPolicy$path' => '<p>The destination path for the health check request. This value is only used if the specified protocol is HTTP or HTTP/2. For any other protocol, this value is ignored.</p>', 'VirtualGatewayHealthCheckPolicy$port' => '<p>The destination port for the health check request. This port must match the port defined in the <a>PortMapping</a> for the listener.</p>', 'VirtualGatewayHealthCheckPolicy$protocol' => '<p>The protocol for the health check request. If you specify <code>grpc</code>, then your service must conform to the <a href="https://github.com/grpc/grpc/blob/master/doc/health-checking.md">GRPC Health Checking Protocol</a>.</p>', 'VirtualGatewayHealthCheckPolicy$timeoutMillis' => '<p>The amount of time to wait when receiving a response from the health check, in milliseconds.</p>', 'VirtualGatewayHealthCheckPolicy$unhealthyThreshold' => '<p>The number of consecutive failed health checks that must occur before declaring a virtual gateway unhealthy.</p>', ], ], 'VirtualGatewayHealthCheckThreshold' => [ 'base' => NULL, 'refs' => [], ], 'VirtualGatewayHealthCheckTimeoutMillis' => [ 'base' => NULL, 'refs' => [], ], 'VirtualGatewayList' => [ 'base' => NULL, 'refs' => [ 'VirtualGatewayList$member' => NULL, ], ], 'VirtualGatewayListener' => [ 'base' => '<p>An object that represents a listener for a virtual gateway.</p>', 'refs' => [ 'VirtualGatewayListener$healthCheck' => '<p>The health check information for the listener.</p>', 'VirtualGatewayListener$portMapping' => '<p>The port mapping information for the listener.</p>', 'VirtualGatewayListener$tls' => '<p>A reference to an object that represents the Transport Layer Security (TLS) properties for the listener.</p>', ], ], 'VirtualGatewayListenerTls' => [ 'base' => '<p>An object that represents the Transport Layer Security (TLS) properties for a listener.</p>', 'refs' => [ 'VirtualGatewayListenerTls$certificate' => '<p>An object that represents a Transport Layer Security (TLS) certificate.</p>', 'VirtualGatewayListenerTls$mode' => '<p>Specify one of the following modes.</p> <ul> <li> <p> <b/>STRICT – Listener only accepts connections with TLS enabled. </p> </li> <li> <p> <b/>PERMISSIVE – Listener accepts connections with or without TLS enabled.</p> </li> <li> <p> <b/>DISABLED – Listener only accepts connections without TLS. </p> </li> </ul>', ], ], 'VirtualGatewayListenerTlsAcmCertificate' => [ 'base' => '<p>An object that represents an AWS Certicate Manager (ACM) certificate.</p>', 'refs' => [ 'VirtualGatewayListenerTlsAcmCertificate$certificateArn' => '<p>The Amazon Resource Name (ARN) for the certificate. The certificate must meet specific requirements and you must have proxy authorization enabled. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites">Transport Layer Security (TLS)</a>.</p>', ], ], 'VirtualGatewayListenerTlsCertificate' => [ 'base' => '<p>An object that represents a listener\'s Transport Layer Security (TLS) certificate.</p>', 'refs' => [ 'VirtualGatewayListenerTlsCertificate$acm' => '<p>A reference to an object that represents an AWS Certicate Manager (ACM) certificate.</p>', 'VirtualGatewayListenerTlsCertificate$file' => '<p>A reference to an object that represents a local file certificate.</p>', ], ], 'VirtualGatewayListenerTlsFileCertificate' => [ 'base' => '<p>An object that represents a local file certificate. The certificate must meet specific requirements and you must have proxy authorization enabled. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites">Transport Layer Security (TLS)</a>.</p>', 'refs' => [ 'VirtualGatewayListenerTlsFileCertificate$certificateChain' => '<p>The certificate chain for the certificate.</p>', 'VirtualGatewayListenerTlsFileCertificate$privateKey' => '<p>The private key for a certificate stored on the file system of the mesh endpoint that the proxy is running on.</p>', ], ], 'VirtualGatewayListenerTlsMode' => [ 'base' => NULL, 'refs' => [], ], 'VirtualGatewayListeners' => [ 'base' => NULL, 'refs' => [ 'VirtualGatewayListeners$member' => NULL, ], ], 'VirtualGatewayLogging' => [ 'base' => '<p>An object that represents logging information.</p>', 'refs' => [ 'VirtualGatewayLogging$accessLog' => '<p>The access log configuration.</p>', ], ], 'VirtualGatewayPortMapping' => [ 'base' => '<p>An object that represents a port mapping.</p>', 'refs' => [ 'VirtualGatewayPortMapping$port' => '<p>The port used for the port mapping. Specify one protocol.</p>', 'VirtualGatewayPortMapping$protocol' => '<p>The protocol used for the port mapping.</p>', ], ], 'VirtualGatewayPortProtocol' => [ 'base' => NULL, 'refs' => [], ], 'VirtualGatewayRef' => [ 'base' => '<p>An object that represents a virtual gateway returned by a list operation.</p>', 'refs' => [ 'VirtualGatewayRef$arn' => '<p>The full Amazon Resource Name (ARN) for the resource.</p>', 'VirtualGatewayRef$createdAt' => '<p>The Unix epoch timestamp in seconds for when the resource was created.</p>', 'VirtualGatewayRef$lastUpdatedAt' => '<p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>', 'VirtualGatewayRef$meshName' => '<p>The name of the service mesh that the resource resides in.</p>', 'VirtualGatewayRef$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'VirtualGatewayRef$resourceOwner' => '<p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it\'s the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'VirtualGatewayRef$version' => '<p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they\'re updated.</p>', 'VirtualGatewayRef$virtualGatewayName' => '<p>The name of the resource.</p>', ], ], 'VirtualGatewaySpec' => [ 'base' => '<p>An object that represents the specification of a service mesh resource.</p>', 'refs' => [ 'VirtualGatewaySpec$backendDefaults' => '<p>A reference to an object that represents the defaults for backends.</p>', 'VirtualGatewaySpec$listeners' => '<p>The listeners that the mesh endpoint is expected to receive inbound traffic from. You can specify one listener.</p>', ], ], 'VirtualGatewayStatus' => [ 'base' => '<p>An object that represents the status of the mesh resource.</p>', 'refs' => [ 'VirtualGatewayStatus$status' => '<p>The current status.</p>', ], ], 'VirtualGatewayStatusCode' => [ 'base' => NULL, 'refs' => [], ], 'VirtualGatewayTlsValidationContext' => [ 'base' => '<p>An object that represents a Transport Layer Security (TLS) validation context.</p>', 'refs' => [ 'VirtualGatewayTlsValidationContext$trust' => '<p>A reference to an object that represents a TLS validation context trust.</p>', ], ], 'VirtualGatewayTlsValidationContextAcmTrust' => [ 'base' => '<p>An object that represents a TLS validation context trust for an AWS Certicate Manager (ACM) certificate.</p>', 'refs' => [ 'VirtualGatewayTlsValidationContextAcmTrust$certificateAuthorityArns' => '<p>One or more ACM Amazon Resource Name (ARN)s.</p>', ], ], 'VirtualGatewayTlsValidationContextFileTrust' => [ 'base' => '<p>An object that represents a Transport Layer Security (TLS) validation context trust for a local file.</p>', 'refs' => [ 'VirtualGatewayTlsValidationContextFileTrust$certificateChain' => '<p>The certificate trust chain for a certificate stored on the file system of the virtual node that the proxy is running on.</p>', ], ], 'VirtualGatewayTlsValidationContextTrust' => [ 'base' => '<p>An object that represents a Transport Layer Security (TLS) validation context trust.</p>', 'refs' => [ 'VirtualGatewayTlsValidationContextTrust$acm' => '<p>A reference to an object that represents a TLS validation context trust for an AWS Certicate Manager (ACM) certificate.</p>', 'VirtualGatewayTlsValidationContextTrust$file' => '<p>An object that represents a TLS validation context trust for a local file.</p>', ], ], 'VirtualNodeData' => [ 'base' => '<p>An object that represents a virtual node returned by a describe operation.</p>', 'refs' => [ 'VirtualNodeData$meshName' => '<p>The name of the service mesh that the virtual node resides in.</p>', 'VirtualNodeData$metadata' => '<p>The associated metadata for the virtual node.</p>', 'VirtualNodeData$spec' => '<p>The specifications of the virtual node.</p>', 'VirtualNodeData$status' => '<p>The current status for the virtual node.</p>', 'VirtualNodeData$virtualNodeName' => '<p>The name of the virtual node.</p>', ], ], 'VirtualNodeList' => [ 'base' => NULL, 'refs' => [ 'VirtualNodeList$member' => NULL, ], ], 'VirtualNodeRef' => [ 'base' => '<p>An object that represents a virtual node returned by a list operation.</p>', 'refs' => [ 'VirtualNodeRef$arn' => '<p>The full Amazon Resource Name (ARN) for the virtual node.</p>', 'VirtualNodeRef$createdAt' => '<p>The Unix epoch timestamp in seconds for when the resource was created.</p>', 'VirtualNodeRef$lastUpdatedAt' => '<p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>', 'VirtualNodeRef$meshName' => '<p>The name of the service mesh that the virtual node resides in.</p>', 'VirtualNodeRef$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'VirtualNodeRef$resourceOwner' => '<p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it\'s the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'VirtualNodeRef$version' => '<p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they\'re updated.</p>', 'VirtualNodeRef$virtualNodeName' => '<p>The name of the virtual node.</p>', ], ], 'VirtualNodeServiceProvider' => [ 'base' => '<p>An object that represents a virtual node service provider.</p>', 'refs' => [ 'VirtualNodeServiceProvider$virtualNodeName' => '<p>The name of the virtual node that is acting as a service provider.</p>', ], ], 'VirtualNodeSpec' => [ 'base' => '<p>An object that represents the specification of a virtual node.</p>', 'refs' => [ 'VirtualNodeSpec$backendDefaults' => '<p>A reference to an object that represents the defaults for backends.</p>', 'VirtualNodeSpec$backends' => '<p>The backends that the virtual node is expected to send outbound traffic to.</p>', 'VirtualNodeSpec$listeners' => '<p>The listener that the virtual node is expected to receive inbound traffic from. You can specify one listener.</p>', 'VirtualNodeSpec$logging' => '<p>The inbound and outbound access logging information for the virtual node.</p>', 'VirtualNodeSpec$serviceDiscovery' => '<p>The service discovery information for the virtual node. If your virtual node does not expect ingress traffic, you can omit this parameter. If you specify a <code>listener</code>, then you must specify service discovery information.</p>', ], ], 'VirtualNodeStatus' => [ 'base' => '<p>An object that represents the current status of the virtual node.</p>', 'refs' => [ 'VirtualNodeStatus$status' => '<p>The current status of the virtual node.</p>', ], ], 'VirtualNodeStatusCode' => [ 'base' => NULL, 'refs' => [], ], 'VirtualRouterData' => [ 'base' => '<p>An object that represents a virtual router returned by a describe operation.</p>', 'refs' => [ 'VirtualRouterData$meshName' => '<p>The name of the service mesh that the virtual router resides in.</p>', 'VirtualRouterData$metadata' => '<p>The associated metadata for the virtual router.</p>', 'VirtualRouterData$spec' => '<p>The specifications of the virtual router.</p>', 'VirtualRouterData$status' => '<p>The current status of the virtual router.</p>', 'VirtualRouterData$virtualRouterName' => '<p>The name of the virtual router.</p>', ], ], 'VirtualRouterList' => [ 'base' => NULL, 'refs' => [ 'VirtualRouterList$member' => NULL, ], ], 'VirtualRouterListener' => [ 'base' => '<p>An object that represents a virtual router listener.</p>', 'refs' => [], ], 'VirtualRouterListeners' => [ 'base' => NULL, 'refs' => [ 'VirtualRouterListeners$member' => NULL, ], ], 'VirtualRouterRef' => [ 'base' => '<p>An object that represents a virtual router returned by a list operation.</p>', 'refs' => [ 'VirtualRouterRef$arn' => '<p>The full Amazon Resource Name (ARN) for the virtual router.</p>', 'VirtualRouterRef$createdAt' => '<p>The Unix epoch timestamp in seconds for when the resource was created.</p>', 'VirtualRouterRef$lastUpdatedAt' => '<p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>', 'VirtualRouterRef$meshName' => '<p>The name of the service mesh that the virtual router resides in.</p>', 'VirtualRouterRef$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'VirtualRouterRef$resourceOwner' => '<p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it\'s the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'VirtualRouterRef$version' => '<p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they\'re updated.</p>', 'VirtualRouterRef$virtualRouterName' => '<p>The name of the virtual router.</p>', ], ], 'VirtualRouterServiceProvider' => [ 'base' => '<p>An object that represents a virtual node service provider.</p>', 'refs' => [ 'VirtualRouterServiceProvider$virtualRouterName' => '<p>The name of the virtual router that is acting as a service provider.</p>', ], ], 'VirtualRouterSpec' => [ 'base' => '<p>An object that represents the specification of a virtual router.</p>', 'refs' => [ 'VirtualRouterSpec$listeners' => '<p>The listeners that the virtual router is expected to receive inbound traffic from. You can specify one listener.</p>', ], ], 'VirtualRouterStatus' => [ 'base' => '<p>An object that represents the status of a virtual router. </p>', 'refs' => [ 'VirtualRouterStatus$status' => '<p>The current status of the virtual router.</p>', ], ], 'VirtualRouterStatusCode' => [ 'base' => NULL, 'refs' => [], ], 'VirtualServiceBackend' => [ 'base' => '<p>An object that represents a virtual service backend for a virtual node.</p>', 'refs' => [ 'VirtualServiceBackend$clientPolicy' => '<p>A reference to an object that represents the client policy for a backend.</p>', 'VirtualServiceBackend$virtualServiceName' => '<p>The name of the virtual service that is acting as a virtual node backend.</p>', ], ], 'VirtualServiceData' => [ 'base' => '<p>An object that represents a virtual service returned by a describe operation.</p>', 'refs' => [ 'VirtualServiceData$meshName' => '<p>The name of the service mesh that the virtual service resides in.</p>', 'VirtualServiceData$spec' => '<p>The specifications of the virtual service.</p>', 'VirtualServiceData$status' => '<p>The current status of the virtual service.</p>', 'VirtualServiceData$virtualServiceName' => '<p>The name of the virtual service.</p>', ], ], 'VirtualServiceList' => [ 'base' => NULL, 'refs' => [ 'VirtualServiceList$member' => NULL, ], ], 'VirtualServiceProvider' => [ 'base' => '<p>An object that represents the provider for a virtual service.</p>', 'refs' => [ 'VirtualServiceProvider$virtualNode' => '<p>The virtual node associated with a virtual service.</p>', 'VirtualServiceProvider$virtualRouter' => '<p>The virtual router associated with a virtual service.</p>', ], ], 'VirtualServiceRef' => [ 'base' => '<p>An object that represents a virtual service returned by a list operation.</p>', 'refs' => [ 'VirtualServiceRef$arn' => '<p>The full Amazon Resource Name (ARN) for the virtual service.</p>', 'VirtualServiceRef$createdAt' => '<p>The Unix epoch timestamp in seconds for when the resource was created.</p>', 'VirtualServiceRef$lastUpdatedAt' => '<p>The Unix epoch timestamp in seconds for when the resource was last updated.</p>', 'VirtualServiceRef$meshName' => '<p>The name of the service mesh that the virtual service resides in.</p>', 'VirtualServiceRef$meshOwner' => '<p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it\'s the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'VirtualServiceRef$resourceOwner' => '<p>The AWS IAM account ID of the resource owner. If the account ID is not your own, then it\'s the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>', 'VirtualServiceRef$version' => '<p>The version of the resource. Resources are created at version 1, and this version is incremented each time that they\'re updated.</p>', 'VirtualServiceRef$virtualServiceName' => '<p>The name of the virtual service.</p>', ], ], 'VirtualServiceSpec' => [ 'base' => '<p>An object that represents the specification of a virtual service.</p>', 'refs' => [ 'VirtualServiceSpec$provider' => '<p>The App Mesh object that is acting as the provider for a virtual service. You can specify a single virtual node or virtual router.</p>', ], ], 'VirtualServiceStatus' => [ 'base' => '<p>An object that represents the status of a virtual service.</p>', 'refs' => [ 'VirtualServiceStatus$status' => '<p>The current status of the virtual service.</p>', ], ], 'VirtualServiceStatusCode' => [ 'base' => NULL, 'refs' => [], ], 'WeightedTarget' => [ 'base' => '<p>An object that represents a target and its relative weight. Traffic is distributed across targets according to their relative weight. For example, a weighted target with a relative weight of 50 receives five times as much traffic as one with a relative weight of 10. The total weight for all targets combined must be less than or equal to 100.</p>', 'refs' => [ 'WeightedTarget$virtualNode' => '<p>The virtual node to associate with the weighted target.</p>', 'WeightedTarget$weight' => '<p>The relative weight of the weighted target.</p>', ], ], 'WeightedTargets' => [ 'base' => NULL, 'refs' => [ 'WeightedTargets$member' => NULL, ], ], ],];
