<?php
// This file was auto-generated from sdk-root/src/data/apigateway/2015-07-09/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon API Gateway</fullname> <p>Amazon API Gateway helps developers deliver robust, secure, and scalable mobile and web application back ends. API Gateway allows developers to securely connect mobile and web applications to APIs that run on AWS Lambda, Amazon EC2, or other publicly addressable web services that are hosted outside of AWS.</p>', 'operations' => [ 'CreateApiKey' => '<p>Create an <a>ApiKey</a> resource. </p> <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/create-api-key.html">AWS CLI</a></div>', 'CreateAuthorizer' => '<p>Adds a new <a>Authorizer</a> resource to an existing <a>RestApi</a> resource.</p> <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/create-authorizer.html">AWS CLI</a></div>', 'CreateBasePathMapping' => '<p>Creates a new <a>BasePathMapping</a> resource.</p>', 'CreateDeployment' => '<p>Creates a <a>Deployment</a> resource, which makes a specified <a>RestApi</a> callable over the internet.</p>', 'CreateDocumentationPart' => NULL, 'CreateDocumentationVersion' => NULL, 'CreateDomainName' => '<p>Creates a new domain name.</p>', 'CreateModel' => '<p>Adds a new <a>Model</a> resource to an existing <a>RestApi</a> resource.</p>', 'CreateRequestValidator' => '<p>Creates a <a>ReqeustValidator</a> of a given <a>RestApi</a>.</p>', 'CreateResource' => '<p>Creates a <a>Resource</a> resource.</p>', 'CreateRestApi' => '<p>Creates a new <a>RestApi</a> resource.</p>', 'CreateStage' => '<p>Creates a new <a>Stage</a> resource that references a pre-existing <a>Deployment</a> for the API. </p>', 'CreateUsagePlan' => '<p>Creates a usage plan with the throttle and quota limits, as well as the associated API stages, specified in the payload. </p>', 'CreateUsagePlanKey' => '<p>Creates a usage plan key for adding an existing API key to a usage plan.</p>', 'CreateVpcLink' => '<p>Creates a VPC link, under the caller\'s account in a selected region, in an asynchronous operation that typically takes 2-4 minutes to complete and become operational. The caller must have permissions to create and update VPC Endpoint services.</p>', 'DeleteApiKey' => '<p>Deletes the <a>ApiKey</a> resource.</p>', 'DeleteAuthorizer' => '<p>Deletes an existing <a>Authorizer</a> resource.</p> <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/delete-authorizer.html">AWS CLI</a></div>', 'DeleteBasePathMapping' => '<p>Deletes the <a>BasePathMapping</a> resource.</p>', 'DeleteClientCertificate' => '<p>Deletes the <a>ClientCertificate</a> resource.</p>', 'DeleteDeployment' => '<p>Deletes a <a>Deployment</a> resource. Deleting a deployment will only succeed if there are no <a>Stage</a> resources associated with it.</p>', 'DeleteDocumentationPart' => NULL, 'DeleteDocumentationVersion' => NULL, 'DeleteDomainName' => '<p>Deletes the <a>DomainName</a> resource.</p>', 'DeleteGatewayResponse' => '<p>Clears any customization of a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a> and resets it with the default settings.</p>', 'DeleteIntegration' => '<p>Represents a delete integration.</p>', 'DeleteIntegrationResponse' => '<p>Represents a delete integration response.</p>', 'DeleteMethod' => '<p>Deletes an existing <a>Method</a> resource.</p>', 'DeleteMethodResponse' => '<p>Deletes an existing <a>MethodResponse</a> resource.</p>', 'DeleteModel' => '<p>Deletes a model.</p>', 'DeleteRequestValidator' => '<p>Deletes a <a>RequestValidator</a> of a given <a>RestApi</a>.</p>', 'DeleteResource' => '<p>Deletes a <a>Resource</a> resource.</p>', 'DeleteRestApi' => '<p>Deletes the specified API.</p>', 'DeleteStage' => '<p>Deletes a <a>Stage</a> resource.</p>', 'DeleteUsagePlan' => '<p>Deletes a usage plan of a given plan Id.</p>', 'DeleteUsagePlanKey' => '<p>Deletes a usage plan key and remove the underlying API key from the associated usage plan.</p>', 'DeleteVpcLink' => '<p>Deletes an existing <a>VpcLink</a> of a specified identifier.</p>', 'FlushStageAuthorizersCache' => '<p>Flushes all authorizer cache entries on a stage.</p>', 'FlushStageCache' => '<p>Flushes a stage\'s cache.</p>', 'GenerateClientCertificate' => '<p>Generates a <a>ClientCertificate</a> resource.</p>', 'GetAccount' => '<p>Gets information about the current <a>Account</a> resource.</p>', 'GetApiKey' => '<p>Gets information about the current <a>ApiKey</a> resource.</p>', 'GetApiKeys' => '<p>Gets information about the current <a>ApiKeys</a> resource.</p>', 'GetAuthorizer' => '<p>Describe an existing <a>Authorizer</a> resource.</p> <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-authorizer.html">AWS CLI</a></div>', 'GetAuthorizers' => '<p>Describe an existing <a>Authorizers</a> resource.</p> <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-authorizers.html">AWS CLI</a></div>', 'GetBasePathMapping' => '<p>Describe a <a>BasePathMapping</a> resource.</p>', 'GetBasePathMappings' => '<p>Represents a collection of <a>BasePathMapping</a> resources.</p>', 'GetClientCertificate' => '<p>Gets information about the current <a>ClientCertificate</a> resource.</p>', 'GetClientCertificates' => '<p>Gets a collection of <a>ClientCertificate</a> resources.</p>', 'GetDeployment' => '<p>Gets information about a <a>Deployment</a> resource.</p>', 'GetDeployments' => '<p>Gets information about a <a>Deployments</a> collection.</p>', 'GetDocumentationPart' => NULL, 'GetDocumentationParts' => NULL, 'GetDocumentationVersion' => NULL, 'GetDocumentationVersions' => NULL, 'GetDomainName' => '<p>Represents a domain name that is contained in a simpler, more intuitive URL that can be called.</p>', 'GetDomainNames' => '<p>Represents a collection of <a>DomainName</a> resources.</p>', 'GetExport' => '<p>Exports a deployed version of a <a>RestApi</a> in a specified format.</p>', 'GetGatewayResponse' => '<p>Gets a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a>.</p>', 'GetGatewayResponses' => '<p>Gets the <a>GatewayResponses</a> collection on the given <a>RestApi</a>. If an API developer has not added any definitions for gateway responses, the result will be the API Gateway-generated default <a>GatewayResponses</a> collection for the supported response types.</p>', 'GetIntegration' => '<p>Get the integration settings.</p>', 'GetIntegrationResponse' => '<p>Represents a get integration response.</p>', 'GetMethod' => '<p>Describe an existing <a>Method</a> resource.</p>', 'GetMethodResponse' => '<p>Describes a <a>MethodResponse</a> resource.</p>', 'GetModel' => '<p>Describes an existing model defined for a <a>RestApi</a> resource.</p>', 'GetModelTemplate' => '<p>Generates a sample mapping template that can be used to transform a payload into the structure of a model.</p>', 'GetModels' => '<p>Describes existing <a>Models</a> defined for a <a>RestApi</a> resource.</p>', 'GetRequestValidator' => '<p>Gets a <a>RequestValidator</a> of a given <a>RestApi</a>.</p>', 'GetRequestValidators' => '<p>Gets the <a>RequestValidators</a> collection of a given <a>RestApi</a>.</p>', 'GetResource' => '<p>Lists information about a resource.</p>', 'GetResources' => '<p>Lists information about a collection of <a>Resource</a> resources.</p>', 'GetRestApi' => '<p>Lists the <a>RestApi</a> resource in the collection.</p>', 'GetRestApis' => '<p>Lists the <a>RestApis</a> resources for your collection.</p>', 'GetSdk' => '<p>Generates a client SDK for a <a>RestApi</a> and <a>Stage</a>.</p>', 'GetSdkType' => NULL, 'GetSdkTypes' => NULL, 'GetStage' => '<p>Gets information about a <a>Stage</a> resource.</p>', 'GetStages' => '<p>Gets information about one or more <a>Stage</a> resources.</p>', 'GetTags' => '<p>Gets the <a>Tags</a> collection for a given resource.</p>', 'GetUsage' => '<p>Gets the usage data of a usage plan in a specified time interval.</p>', 'GetUsagePlan' => '<p>Gets a usage plan of a given plan identifier.</p>', 'GetUsagePlanKey' => '<p>Gets a usage plan key of a given key identifier.</p>', 'GetUsagePlanKeys' => '<p>Gets all the usage plan keys representing the API keys added to a specified usage plan.</p>', 'GetUsagePlans' => '<p>Gets all the usage plans of the caller\'s account.</p>', 'GetVpcLink' => '<p>Gets a specified VPC link under the caller\'s account in a region.</p>', 'GetVpcLinks' => '<p>Gets the <a>VpcLinks</a> collection under the caller\'s account in a selected region.</p>', 'ImportApiKeys' => '<p>Import API keys from an external source, such as a CSV-formatted file.</p>', 'ImportDocumentationParts' => NULL, 'ImportRestApi' => '<p>A feature of the API Gateway control service for creating a new API from an external API definition file.</p>', 'PutGatewayResponse' => '<p>Creates a customization of a <a>GatewayResponse</a> of a specified response type and status code on the given <a>RestApi</a>.</p>', 'PutIntegration' => '<p>Sets up a method\'s integration.</p>', 'PutIntegrationResponse' => '<p>Represents a put integration.</p>', 'PutMethod' => '<p>Add a method to an existing <a>Resource</a> resource.</p>', 'PutMethodResponse' => '<p>Adds a <a>MethodResponse</a> to an existing <a>Method</a> resource.</p>', 'PutRestApi' => '<p>A feature of the API Gateway control service for updating an existing API with an input of external API definitions. The update can take the form of merging the supplied definition into the existing API or overwriting the existing API.</p>', 'TagResource' => '<p>Adds or updates a tag on a given resource.</p>', 'TestInvokeAuthorizer' => '<p>Simulate the execution of an <a>Authorizer</a> in your <a>RestApi</a> with headers, parameters, and an incoming request body.</p> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html">Use Lambda Function as Authorizer</a> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html">Use Cognito User Pool as Authorizer</a> </div>', 'TestInvokeMethod' => '<p>Simulate the execution of a <a>Method</a> in your <a>RestApi</a> with headers, parameters, and an incoming request body.</p>', 'UntagResource' => '<p>Removes a tag from a given resource.</p>', 'UpdateAccount' => '<p>Changes information about the current <a>Account</a> resource.</p>', 'UpdateApiKey' => '<p>Changes information about an <a>ApiKey</a> resource.</p>', 'UpdateAuthorizer' => '<p>Updates an existing <a>Authorizer</a> resource.</p> <div class="seeAlso"><a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/update-authorizer.html">AWS CLI</a></div>', 'UpdateBasePathMapping' => '<p>Changes information about the <a>BasePathMapping</a> resource.</p>', 'UpdateClientCertificate' => '<p>Changes information about an <a>ClientCertificate</a> resource.</p>', 'UpdateDeployment' => '<p>Changes information about a <a>Deployment</a> resource.</p>', 'UpdateDocumentationPart' => NULL, 'UpdateDocumentationVersion' => NULL, 'UpdateDomainName' => '<p>Changes information about the <a>DomainName</a> resource.</p>', 'UpdateGatewayResponse' => '<p>Updates a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a>.</p>', 'UpdateIntegration' => '<p>Represents an update integration.</p>', 'UpdateIntegrationResponse' => '<p>Represents an update integration response.</p>', 'UpdateMethod' => '<p>Updates an existing <a>Method</a> resource.</p>', 'UpdateMethodResponse' => '<p>Updates an existing <a>MethodResponse</a> resource.</p>', 'UpdateModel' => '<p>Changes information about a model.</p>', 'UpdateRequestValidator' => '<p>Updates a <a>RequestValidator</a> of a given <a>RestApi</a>.</p>', 'UpdateResource' => '<p>Changes information about a <a>Resource</a> resource.</p>', 'UpdateRestApi' => '<p>Changes information about the specified API.</p>', 'UpdateStage' => '<p>Changes information about a <a>Stage</a> resource.</p>', 'UpdateUsage' => '<p>Grants a temporary extension to the remaining quota of a usage plan associated with a specified API key.</p>', 'UpdateUsagePlan' => '<p>Updates a usage plan of a given plan Id.</p>', 'UpdateVpcLink' => '<p>Updates an existing <a>VpcLink</a> of a specified identifier.</p>', ], 'shapes' => [ 'AccessLogSettings' => [ 'base' => '<p>Access log settings, including the access log format and access log destination ARN.</p>', 'refs' => [ 'Stage$accessLogSettings' => '<p>Settings for logging access in this stage.</p>', ], ], 'Account' => [ 'base' => '<p>Represents an AWS account that is associated with API Gateway.</p> <div class="remarks"> <p>To view the account info, call <code>GET</code> on this resource.</p> <h4>Error Codes</h4> <p>The following exception may be thrown when the request fails.</p> <ul> <li>UnauthorizedException</li> <li>NotFoundException</li> <li>TooManyRequestsException</li> </ul> <p>For detailed error code information, including the corresponding HTTP Status Codes, see <a href="https://docs.aws.amazon.com/apigateway/api-reference/handling-errors/#api-error-codes">API Gateway Error Codes</a></p> <h4>Example: Get the information about an account.</h4> <h5>Request</h5> <pre><code>GET /account HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com X-Amz-Date: 20160531T184618Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash} </code></pre> <h5>Response</h5> <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p> <pre><code>{ "_links": { "curies": { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/account-apigateway-{rel}.html", "name": "account", "templated": true }, "self": { "href": "/account" }, "account:update": { "href": "/account" } }, "cloudwatchRoleArn": "arn:aws:iam::123456789012:role/apigAwsProxyRole", "throttleSettings": { "rateLimit": 500, "burstLimit": 1000 } } </code></pre> <p>In addition to making the REST API call directly, you can use the AWS CLI and an AWS SDK to access this resource.</p> </div> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-limits.html">API Gateway Limits</a> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/welcome.html">Developer Guide</a>, <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-account.html">AWS CLI</a> </div>', 'refs' => [], ], 'ApiKey' => [ 'base' => '<p>A resource that can be distributed to callers for executing <a>Method</a> resources that require an API key. API keys can be mapped to any <a>Stage</a> on any <a>RestApi</a>, which indicates that the callers with the API key can make requests to that stage.</p> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-api-keys.html">Use API Keys</a> </div>', 'refs' => [ 'ListOfApiKey$member' => NULL, ], ], 'ApiKeyIds' => [ 'base' => '<p>The identifier of an <a>ApiKey</a> used in a <a>UsagePlan</a>.</p>', 'refs' => [], ], 'ApiKeySourceType' => [ 'base' => NULL, 'refs' => [ 'CreateRestApiRequest$apiKeySource' => '<p>The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul> </p>', 'RestApi$apiKeySource' => '<p>The source of the API key for metering requests according to a usage plan. Valid values are: <ul><li><code>HEADER</code> to read the API key from the <code>X-API-Key</code> header of a request. </li><li><code>AUTHORIZER</code> to read the API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</li></ul> </p>', ], ], 'ApiKeys' => [ 'base' => '<p>Represents a collection of API keys as represented by an <a>ApiKeys</a> resource.</p> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-api-keys.html">Use API Keys</a> </div>', 'refs' => [], ], 'ApiKeysFormat' => [ 'base' => NULL, 'refs' => [ 'ImportApiKeysRequest$format' => '<p>A query parameter to specify the input format to imported API keys. Currently, only the <code>csv</code> format is supported.</p>', ], ], 'ApiStage' => [ 'base' => '<p>API stage name of the associated API stage in a usage plan.</p>', 'refs' => [ 'ListOfApiStage$member' => NULL, ], ], 'Authorizer' => [ 'base' => '<p>Represents an authorization layer for methods. If enabled on a method, API Gateway will activate the authorizer when a client calls the method.</p> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html">Use Lambda Function as Authorizer</a> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html">Use Cognito User Pool as Authorizer</a> </div>', 'refs' => [ 'ListOfAuthorizer$member' => NULL, ], ], 'AuthorizerType' => [ 'base' => '<p>The authorizer type. Valid values are <code>TOKEN</code> for a Lambda function using a single authorization token submitted in a custom header, <code>REQUEST</code> for a Lambda function using incoming request parameters, and <code>COGNITO_USER_POOLS</code> for using an Amazon Cognito user pool.</p>', 'refs' => [ 'Authorizer$type' => '<p>The authorizer type. Valid values are <code>TOKEN</code> for a Lambda function using a single authorization token submitted in a custom header, <code>REQUEST</code> for a Lambda function using incoming request parameters, and <code>COGNITO_USER_POOLS</code> for using an Amazon Cognito user pool.</p>', 'CreateAuthorizerRequest$type' => '<p>[Required] The authorizer type. Valid values are <code>TOKEN</code> for a Lambda function using a single authorization token submitted in a custom header, <code>REQUEST</code> for a Lambda function using incoming request parameters, and <code>COGNITO_USER_POOLS</code> for using an Amazon Cognito user pool.</p>', ], ], 'Authorizers' => [ 'base' => '<p>Represents a collection of <a>Authorizer</a> resources.</p> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html">Use Lambda Function as Authorizer</a> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html">Use Cognito User Pool as Authorizer</a> </div>', 'refs' => [], ], 'BadRequestException' => [ 'base' => '<p>The submitted request is not valid, for example, the input is incomplete or incorrect. See the accompanying error message for details.</p>', 'refs' => [], ], 'BasePathMapping' => [ 'base' => '<p>Represents the base path that callers of the API must provide as part of the URL after the domain name.</p> <div class="remarks">A custom domain name plus a <code>BasePathMapping</code> specification identifies a deployed <a>RestApi</a> in a given stage of the owner <a>Account</a>.</div> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html">Use Custom Domain Names</a> </div>', 'refs' => [ 'ListOfBasePathMapping$member' => NULL, ], ], 'BasePathMappings' => [ 'base' => '<p>Represents a collection of <a>BasePathMapping</a> resources.</p> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html">Use Custom Domain Names</a> </div>', 'refs' => [], ], 'Blob' => [ 'base' => NULL, 'refs' => [ 'ExportResponse$body' => '<p>The binary blob response to <a>GetExport</a>, which contains the export.</p>', 'ImportApiKeysRequest$body' => '<p>The payload of the POST request to import API keys. For the payload format, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-key-file-format.html">API Key File Format</a>.</p>', 'ImportDocumentationPartsRequest$body' => '<p>[Required] Raw byte array representing the to-be-imported documentation parts. To import from an OpenAPI file, this is a JSON object.</p>', 'ImportRestApiRequest$body' => '<p>[Required] The POST request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.</p>', 'PutRestApiRequest$body' => '<p>[Required] The PUT request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.</p>', 'SdkResponse$body' => '<p>The binary blob response to <a>GetSdk</a>, which contains the generated SDK.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'ApiKey$enabled' => '<p>Specifies whether the API Key can be used by callers.</p>', 'CanarySettings$useStageCache' => '<p>A Boolean flag to indicate whether the canary deployment uses the stage cache or not.</p>', 'CreateApiKeyRequest$enabled' => '<p>Specifies whether the <a>ApiKey</a> can be used by callers.</p>', 'CreateApiKeyRequest$generateDistinctId' => '<p>Specifies whether (<code>true</code>) or not (<code>false</code>) the key identifier is distinct from the created API key value. This parameter is deprecated and should not be used.</p>', 'CreateRequestValidatorRequest$validateRequestBody' => '<p>A Boolean flag to indicate whether to validate request body according to the configured model schema for the method (<code>true</code>) or not (<code>false</code>).</p>', 'CreateRequestValidatorRequest$validateRequestParameters' => '<p>A Boolean flag to indicate whether to validate request parameters, <code>true</code>, or not <code>false</code>.</p>', 'CreateStageRequest$cacheClusterEnabled' => '<p>Whether cache clustering is enabled for the stage.</p>', 'CreateStageRequest$tracingEnabled' => '<p>Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.</p>', 'DeploymentCanarySettings$useStageCache' => '<p>A Boolean flag to indicate whether the canary release deployment uses the stage cache or not.</p>', 'GatewayResponse$defaultResponse' => '<p>A Boolean flag to indicate whether this <a>GatewayResponse</a> is the default gateway response (<code>true</code>) or not (<code>false</code>). A default gateway response is one generated by API Gateway without any customization by an API developer. </p>', 'GetModelRequest$flatten' => '<p>A query parameter of a Boolean value to resolve (<code>true</code>) all external model references and returns a flattened model schema or not (<code>false</code>) The default is <code>false</code>.</p>', 'ImportApiKeysRequest$failOnWarnings' => '<p>A query parameter to indicate whether to rollback <a>ApiKey</a> importation (<code>true</code>) or not (<code>false</code>) when error is encountered.</p>', 'ImportDocumentationPartsRequest$failOnWarnings' => '<p>A query parameter to specify whether to rollback the documentation importation (<code>true</code>) or not (<code>false</code>) when a warning is encountered. The default value is <code>false</code>.</p>', 'ImportRestApiRequest$failOnWarnings' => '<p>A query parameter to indicate whether to rollback the API creation (<code>true</code>) or not (<code>false</code>) when a warning is encountered. The default value is <code>false</code>.</p>', 'MethodSetting$metricsEnabled' => '<p>Specifies whether Amazon CloudWatch metrics are enabled for this method. The PATCH path for this setting is <code>/{method_setting_key}/metrics/enabled</code>, and the value is a Boolean.</p>', 'MethodSetting$dataTraceEnabled' => '<p>Specifies whether data trace logging is enabled for this method, which affects the log entries pushed to Amazon CloudWatch Logs. The PATCH path for this setting is <code>/{method_setting_key}/logging/dataTrace</code>, and the value is a Boolean.</p>', 'MethodSetting$cachingEnabled' => '<p>Specifies whether responses should be cached and returned for requests. A cache cluster must be enabled on the stage for responses to be cached. The PATCH path for this setting is <code>/{method_setting_key}/caching/enabled</code>, and the value is a Boolean.</p>', 'MethodSetting$cacheDataEncrypted' => '<p>Specifies whether the cached responses are encrypted. The PATCH path for this setting is <code>/{method_setting_key}/caching/dataEncrypted</code>, and the value is a Boolean.</p>', 'MethodSetting$requireAuthorizationForCacheControl' => '<p>Specifies whether authorization is required for a cache invalidation request. The PATCH path for this setting is <code>/{method_setting_key}/caching/requireAuthorizationForCacheControl</code>, and the value is a Boolean.</p>', 'MethodSnapshot$apiKeyRequired' => '<p>Specifies whether the method requires a valid <a>ApiKey</a>.</p>', 'PutMethodRequest$apiKeyRequired' => '<p>Specifies whether the method required a valid <a>ApiKey</a>.</p>', 'PutRestApiRequest$failOnWarnings' => '<p>A query parameter to indicate whether to rollback the API update (<code>true</code>) or not (<code>false</code>) when a warning is encountered. The default value is <code>false</code>.</p>', 'RequestValidator$validateRequestBody' => '<p>A Boolean flag to indicate whether to validate a request body according to the configured <a>Model</a> schema.</p>', 'RequestValidator$validateRequestParameters' => '<p>A Boolean flag to indicate whether to validate request parameters (<code>true</code>) or not (<code>false</code>).</p>', 'SdkConfigurationProperty$required' => '<p>A boolean flag of an <a>SdkType</a> configuration property to indicate if the associated SDK configuration property is required (<code>true</code>) or not (<code>false</code>).</p>', 'Stage$cacheClusterEnabled' => '<p>Specifies whether a cache cluster is enabled for the stage.</p>', 'Stage$tracingEnabled' => '<p>Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.</p>', 'TlsConfig$insecureSkipVerification' => '<p>Specifies whether or not API Gateway skips verification that the certificate for an integration endpoint is issued by a <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-supported-certificate-authorities-for-http-endpoints.html">supported certificate authority</a>. This isn’t recommended, but it enables you to use certificates that are signed by private certificate authorities, or certificates that are self-signed. If enabled, API Gateway still performs basic certificate validation, which includes checking the certificate\'s expiration date, hostname, and presence of a root certificate authority. Supported only for <code>HTTP</code> and <code>HTTP_PROXY</code> integrations.</p>', ], ], 'CacheClusterSize' => [ 'base' => '<p>Returns the size of the <b>CacheCluster</b>.</p>', 'refs' => [ 'CreateDeploymentRequest$cacheClusterSize' => '<p>Specifies the cache cluster size for the <a>Stage</a> resource specified in the input, if a cache cluster is enabled.</p>', 'CreateStageRequest$cacheClusterSize' => '<p>The stage\'s cache cluster size.</p>', 'Stage$cacheClusterSize' => '<p>The size of the cache cluster for the stage, if enabled.</p>', ], ], 'CacheClusterStatus' => [ 'base' => '<p>Returns the status of the <b>CacheCluster</b>.</p>', 'refs' => [ 'Stage$cacheClusterStatus' => '<p>The status of the cache cluster for the stage, if enabled.</p>', ], ], 'CanarySettings' => [ 'base' => '<p>Configuration settings of a canary deployment.</p>', 'refs' => [ 'CreateStageRequest$canarySettings' => '<p>The canary deployment settings of this stage.</p>', 'Stage$canarySettings' => '<p>Settings for the canary deployment in this stage.</p>', ], ], 'ClientCertificate' => [ 'base' => '<p>Represents a client certificate used to configure client-side SSL authentication while sending requests to the integration endpoint.</p> <div class="remarks">Client certificates are used to authenticate an API by the backend server. To authenticate an API client (or user), use IAM roles and policies, a custom <a>Authorizer</a> or an Amazon Cognito user pool.</div> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/getting-started-client-side-ssl-authentication.html">Use Client-Side Certificate</a> </div>', 'refs' => [ 'ListOfClientCertificate$member' => NULL, ], ], 'ClientCertificates' => [ 'base' => '<p>Represents a collection of <a>ClientCertificate</a> resources.</p> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/getting-started-client-side-ssl-authentication.html">Use Client-Side Certificate</a> </div>', 'refs' => [], ], 'ConflictException' => [ 'base' => '<p>The request configuration has conflicts. For details, see the accompanying error message.</p>', 'refs' => [], ], 'ConnectionType' => [ 'base' => NULL, 'refs' => [ 'Integration$connectionType' => '<p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>', 'PutIntegrationRequest$connectionType' => '<p>The type of the network connection to the integration endpoint. The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code>.</p>', ], ], 'ContentHandlingStrategy' => [ 'base' => NULL, 'refs' => [ 'Integration$contentHandling' => '<p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p> <ul> <li><p><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</p></li> <li><p><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</p></li> </ul> <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>', 'IntegrationResponse$contentHandling' => '<p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p> <ul> <li><p><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p></li> <li><p><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</p></li> </ul> <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>', 'PutIntegrationRequest$contentHandling' => '<p>Specifies how to handle request payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p> <ul> <li><p><code>CONVERT_TO_BINARY</code>: Converts a request payload from a Base64-encoded string to the corresponding binary blob.</p></li> <li><p><code>CONVERT_TO_TEXT</code>: Converts a request payload from a binary blob to a Base64-encoded string.</p></li> </ul> <p>If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the <code>passthroughBehavior</code> is configured to support payload pass-through.</p>', 'PutIntegrationResponseRequest$contentHandling' => '<p>Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code>, with the following behaviors:</p> <ul> <li><p><code>CONVERT_TO_BINARY</code>: Converts a response payload from a Base64-encoded string to the corresponding binary blob.</p></li> <li><p><code>CONVERT_TO_TEXT</code>: Converts a response payload from a binary blob to a Base64-encoded string.</p></li> </ul> <p>If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.</p>', ], ], 'CreateApiKeyRequest' => [ 'base' => '<p>Request to create an <a>ApiKey</a> resource.</p>', 'refs' => [], ], 'CreateAuthorizerRequest' => [ 'base' => '<p>Request to add a new <a>Authorizer</a> to an existing <a>RestApi</a> resource.</p>', 'refs' => [], ], 'CreateBasePathMappingRequest' => [ 'base' => '<p>Requests API Gateway to create a new <a>BasePathMapping</a> resource.</p>', 'refs' => [], ], 'CreateDeploymentRequest' => [ 'base' => '<p>Requests API Gateway to create a <a>Deployment</a> resource.</p>', 'refs' => [], ], 'CreateDocumentationPartRequest' => [ 'base' => '<p>Creates a new documentation part of a given API.</p>', 'refs' => [], ], 'CreateDocumentationVersionRequest' => [ 'base' => '<p>Creates a new documentation version of a given API.</p>', 'refs' => [], ], 'CreateDomainNameRequest' => [ 'base' => '<p>A request to create a new domain name.</p>', 'refs' => [], ], 'CreateModelRequest' => [ 'base' => '<p>Request to add a new <a>Model</a> to an existing <a>RestApi</a> resource.</p>', 'refs' => [], ], 'CreateRequestValidatorRequest' => [ 'base' => '<p>Creates a <a>RequestValidator</a> of a given <a>RestApi</a>.</p>', 'refs' => [], ], 'CreateResourceRequest' => [ 'base' => '<p>Requests API Gateway to create a <a>Resource</a> resource.</p>', 'refs' => [], ], 'CreateRestApiRequest' => [ 'base' => '<p>The POST Request to add a new <a>RestApi</a> resource to your collection.</p>', 'refs' => [], ], 'CreateStageRequest' => [ 'base' => '<p>Requests API Gateway to create a <a>Stage</a> resource.</p>', 'refs' => [], ], 'CreateUsagePlanKeyRequest' => [ 'base' => '<p>The POST request to create a usage plan key for adding an existing API key to a usage plan.</p>', 'refs' => [], ], 'CreateUsagePlanRequest' => [ 'base' => '<p>The POST request to create a usage plan with the name, description, throttle limits and quota limits, as well as the associated API stages, specified in the payload.</p>', 'refs' => [], ], 'CreateVpcLinkRequest' => [ 'base' => '<p>Creates a VPC link, under the caller\'s account in a selected region, in an asynchronous operation that typically takes 2-4 minutes to complete and become operational. The caller must have permissions to create and update VPC Endpoint services.</p>', 'refs' => [], ], 'DeleteApiKeyRequest' => [ 'base' => '<p>A request to delete the <a>ApiKey</a> resource.</p>', 'refs' => [], ], 'DeleteAuthorizerRequest' => [ 'base' => '<p>Request to delete an existing <a>Authorizer</a> resource.</p>', 'refs' => [], ], 'DeleteBasePathMappingRequest' => [ 'base' => '<p>A request to delete the <a>BasePathMapping</a> resource.</p>', 'refs' => [], ], 'DeleteClientCertificateRequest' => [ 'base' => '<p>A request to delete the <a>ClientCertificate</a> resource.</p>', 'refs' => [], ], 'DeleteDeploymentRequest' => [ 'base' => '<p>Requests API Gateway to delete a <a>Deployment</a> resource.</p>', 'refs' => [], ], 'DeleteDocumentationPartRequest' => [ 'base' => '<p>Deletes an existing documentation part of an API.</p>', 'refs' => [], ], 'DeleteDocumentationVersionRequest' => [ 'base' => '<p>Deletes an existing documentation version of an API.</p>', 'refs' => [], ], 'DeleteDomainNameRequest' => [ 'base' => '<p>A request to delete the <a>DomainName</a> resource.</p>', 'refs' => [], ], 'DeleteGatewayResponseRequest' => [ 'base' => '<p>Clears any customization of a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a> and resets it with the default settings.</p>', 'refs' => [], ], 'DeleteIntegrationRequest' => [ 'base' => '<p>Represents a delete integration request.</p>', 'refs' => [], ], 'DeleteIntegrationResponseRequest' => [ 'base' => '<p>Represents a delete integration response request.</p>', 'refs' => [], ], 'DeleteMethodRequest' => [ 'base' => '<p>Request to delete an existing <a>Method</a> resource.</p>', 'refs' => [], ], 'DeleteMethodResponseRequest' => [ 'base' => '<p>A request to delete an existing <a>MethodResponse</a> resource.</p>', 'refs' => [], ], 'DeleteModelRequest' => [ 'base' => '<p>Request to delete an existing model in an existing <a>RestApi</a> resource.</p>', 'refs' => [], ], 'DeleteRequestValidatorRequest' => [ 'base' => '<p>Deletes a specified <a>RequestValidator</a> of a given <a>RestApi</a>.</p>', 'refs' => [], ], 'DeleteResourceRequest' => [ 'base' => '<p>Request to delete a <a>Resource</a>.</p>', 'refs' => [], ], 'DeleteRestApiRequest' => [ 'base' => '<p>Request to delete the specified API from your collection.</p>', 'refs' => [], ], 'DeleteStageRequest' => [ 'base' => '<p>Requests API Gateway to delete a <a>Stage</a> resource.</p>', 'refs' => [], ], 'DeleteUsagePlanKeyRequest' => [ 'base' => '<p>The DELETE request to delete a usage plan key and remove the underlying API key from the associated usage plan.</p>', 'refs' => [], ], 'DeleteUsagePlanRequest' => [ 'base' => '<p>The DELETE request to delete a usage plan of a given plan Id.</p>', 'refs' => [], ], 'DeleteVpcLinkRequest' => [ 'base' => '<p>Deletes an existing <a>VpcLink</a> of a specified identifier.</p>', 'refs' => [], ], 'Deployment' => [ 'base' => '<p>An immutable representation of a <a>RestApi</a> resource that can be called by users using <a>Stages</a>. A deployment must be associated with a <a>Stage</a> for it to be callable over the Internet.</p> <div class="remarks">To create a deployment, call <code>POST</code> on the <a>Deployments</a> resource of a <a>RestApi</a>. To view, update, or delete a deployment, call <code>GET</code>, <code>PATCH</code>, or <code>DELETE</code> on the specified deployment resource (<code>/restapis/{restapi_id}/deployments/{deployment_id}</code>).</div> <div class="seeAlso"><a>RestApi</a>, <a>Deployments</a>, <a>Stage</a>, <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-deployment.html">AWS CLI</a>, <a href="https://aws.amazon.com/tools/">AWS SDKs</a> </div>', 'refs' => [ 'ListOfDeployment$member' => NULL, ], ], 'DeploymentCanarySettings' => [ 'base' => '<p>The input configuration for a canary deployment.</p>', 'refs' => [ 'CreateDeploymentRequest$canarySettings' => '<p>The input configuration for the canary deployment when the deployment is a canary release deployment. </p>', ], ], 'Deployments' => [ 'base' => '<p>Represents a collection resource that contains zero or more references to your existing deployments, and links that guide you on how to interact with your collection. The collection offers a paginated view of the contained deployments.</p> <div class="remarks">To create a new deployment of a <a>RestApi</a>, make a <code>POST</code> request against this resource. To view, update, or delete an existing deployment, make a <code>GET</code>, <code>PATCH</code>, or <code>DELETE</code> request, respectively, on a specified <a>Deployment</a> resource.</div> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-deploy-api.html">Deploying an API</a>, <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-deployment.html">AWS CLI</a>, <a href="https://aws.amazon.com/tools/">AWS SDKs</a> </div>', 'refs' => [], ], 'DocumentationPart' => [ 'base' => '<p>A documentation part for a targeted API entity.</p> <div class="remarks"> <p>A documentation part consists of a content map (<code>properties</code>) and a target (<code>location</code>). The target specifies an API entity to which the documentation content applies. The supported API entity types are <code>API</code>, <code>AUTHORIZER</code>, <code>MODEL</code>, <code>RESOURCE</code>, <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. Valid <code>location</code> fields depend on the API entity type. All valid fields are not required.</p> <p>The content map is a JSON string of API-specific key-value pairs. Although an API can use any shape for the content map, only the OpenAPI-compliant documentation fields will be injected into the associated API entity definition in the exported OpenAPI definition file.</p></div> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-documenting-api.html">Documenting an API</a>, <a>DocumentationParts</a> </div>', 'refs' => [ 'ListOfDocumentationPart$member' => NULL, ], ], 'DocumentationPartIds' => [ 'base' => '<p>A collection of the imported <a>DocumentationPart</a> identifiers.</p> <div class="remarks">This is used to return the result when documentation parts in an external (e.g., OpenAPI) file are imported into API Gateway</div> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-documenting-api.html">Documenting an API</a>, <a href="https://docs.aws.amazon.com/apigateway/api-reference/link-relation/documentationpart-import/">documentationpart:import</a>, <a>DocumentationPart</a> </div>', 'refs' => [], ], 'DocumentationPartLocation' => [ 'base' => '<p>Specifies the target API entity to which the documentation applies.</p>', 'refs' => [ 'CreateDocumentationPartRequest$location' => '<p>[Required] The location of the targeted API entity of the to-be-created documentation part.</p>', 'DocumentationPart$location' => '<p>The location of the API entity to which the documentation applies. Valid fields depend on the targeted API entity type. All the valid location fields are not required. If not explicitly specified, a valid location field is treated as a wildcard and associated documentation content may be inherited by matching entities, unless overridden.</p>', ], ], 'DocumentationPartLocationStatusCode' => [ 'base' => NULL, 'refs' => [ 'DocumentationPartLocation$statusCode' => '<p>The HTTP status code of a response. It is a valid field for the API entity types of <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>*</code> for any status code. When an applicable child entity inherits the content of an entity of the same type with more general specifications of the other <code>location</code> attributes, the child entity\'s <code>statusCode</code> attribute must match that of the parent entity exactly.</p>', ], ], 'DocumentationPartType' => [ 'base' => NULL, 'refs' => [ 'DocumentationPartLocation$type' => '<p>[Required] The type of API entity to which the documentation content applies. Valid values are <code>API</code>, <code>AUTHORIZER</code>, <code>MODEL</code>, <code>RESOURCE</code>, <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. Content inheritance does not apply to any entity of the <code>API</code>, <code>AUTHORIZER</code>, <code>METHOD</code>, <code>MODEL</code>, <code>REQUEST_BODY</code>, or <code>RESOURCE</code> type.</p>', 'GetDocumentationPartsRequest$type' => '<p>The type of API entities of the to-be-retrieved documentation parts. </p>', ], ], 'DocumentationParts' => [ 'base' => '<p>The collection of documentation parts of an API.</p> <div class="remarks"/> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-documenting-api.html">Documenting an API</a>, <a>DocumentationPart</a> </div>', 'refs' => [], ], 'DocumentationVersion' => [ 'base' => '<p>A snapshot of the documentation of an API.</p> <div class="remarks"><p>Publishing API documentation involves creating a documentation version associated with an API stage and exporting the versioned documentation to an external (e.g., OpenAPI) file.</p></div> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-documenting-api.html">Documenting an API</a>, <a>DocumentationPart</a>, <a>DocumentationVersions</a> </div>', 'refs' => [ 'ListOfDocumentationVersion$member' => NULL, ], ], 'DocumentationVersions' => [ 'base' => '<p>The collection of documentation snapshots of an API. </p> <div class="remarks"><p>Use the <a>DocumentationVersions</a> to manage documentation snapshots associated with various API stages.</p></div> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-documenting-api.html">Documenting an API</a>, <a>DocumentationPart</a>, <a>DocumentationVersion</a> </div>', 'refs' => [], ], 'DomainName' => [ 'base' => '<p>Represents a custom domain name as a user-friendly host name of an API (<a>RestApi</a>).</p> <div class="Remarks"> <p>When you deploy an API, API Gateway creates a default host name for the API. This default API host name is of the <code>{restapi-id}.execute-api.{region}.amazonaws.com</code> format. With the default host name, you can access the API\'s root resource with the URL of <code>https://{restapi-id}.execute-api.{region}.amazonaws.com/{stage}/</code>. When you set up a custom domain name of <code>apis.example.com</code> for this API, you can then access the same resource using the URL of the <code>https://apis.examples.com/myApi</code>, where <code>myApi</code> is the base path mapping (<a>BasePathMapping</a>) of your API under the custom domain name. </p> </div> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html">Set a Custom Host Name for an API</a> </div>', 'refs' => [ 'ListOfDomainName$member' => NULL, ], ], 'DomainNameStatus' => [ 'base' => NULL, 'refs' => [ 'DomainName$domainNameStatus' => '<p>The status of the <a>DomainName</a> migration. The valid values are <code>AVAILABLE</code> and <code>UPDATING</code>. If the status is <code>UPDATING</code>, the domain cannot be modified further until the existing operation is complete. If it is <code>AVAILABLE</code>, the domain can be updated.</p>', ], ], 'DomainNames' => [ 'base' => '<p>Represents a collection of <a>DomainName</a> resources.</p> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html">Use Client-Side Certificate</a> </div>', 'refs' => [], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'CanarySettings$percentTraffic' => '<p>The percent (0-100) of traffic diverted to a canary deployment.</p>', 'DeploymentCanarySettings$percentTraffic' => '<p>The percentage (0.0-100.0) of traffic routed to the canary deployment.</p>', 'MethodSetting$throttlingRateLimit' => '<p>Specifies the throttling rate limit. The PATCH path for this setting is <code>/{method_setting_key}/throttling/rateLimit</code>, and the value is a double.</p>', 'ThrottleSettings$rateLimit' => '<p>The API request steady-state rate limit.</p>', ], ], 'EndpointConfiguration' => [ 'base' => '<p>The endpoint configuration to indicate the types of endpoints an API (<a>RestApi</a>) or its custom domain name (<a>DomainName</a>) has. </p>', 'refs' => [ 'CreateDomainNameRequest$endpointConfiguration' => '<p>The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name. </p>', 'CreateRestApiRequest$endpointConfiguration' => '<p>The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API. </p>', 'DomainName$endpointConfiguration' => '<p>The endpoint configuration of this <a>DomainName</a> showing the endpoint types of the domain name. </p>', 'RestApi$endpointConfiguration' => '<p>The endpoint configuration of this <a>RestApi</a> showing the endpoint types of the API. </p>', ], ], 'EndpointType' => [ 'base' => '<p>The endpoint type. The valid values are <code>EDGE</code> for edge-optimized API setup, most suitable for mobile applications; <code>REGIONAL</code> for regional API endpoint setup, most suitable for calling from AWS Region; and <code>PRIVATE</code> for private APIs.</p>', 'refs' => [ 'ListOfEndpointType$member' => NULL, ], ], 'ExportResponse' => [ 'base' => '<p>The binary blob response to <a>GetExport</a>, which contains the generated SDK.</p>', 'refs' => [], ], 'FlushStageAuthorizersCacheRequest' => [ 'base' => '<p>Request to flush authorizer cache entries on a specified stage.</p>', 'refs' => [], ], 'FlushStageCacheRequest' => [ 'base' => '<p>Requests API Gateway to flush a stage\'s cache.</p>', 'refs' => [], ], 'GatewayResponse' => [ 'base' => '<p>A gateway response of a given response type and status code, with optional response parameters and mapping templates.</p> <div class="remarks"> For more information about valid gateway response types, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html">Gateway Response Types Supported by API Gateway</a> <div class="example"> <h4>Example: Get a Gateway Response of a given response type</h4> <h5>Request</h5> <p>This example shows how to get a gateway response of the <code>MISSING_AUTHENTICATION_TOKEN</code> type.</p> <pre><code>GET /restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN HTTP/1.1 Host: beta-apigateway.us-east-1.amazonaws.com Content-Type: application/json X-Amz-Date: 20170503T202516Z Authorization: AWS4-HMAC-SHA256 Credential={access-key-id}/20170503/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature=1b52460e3159c1a26cff29093855d50ea141c1c5b937528fecaf60f51129697a Cache-Control: no-cache Postman-Token: 3b2a1ce9-c848-2e26-2e2f-9c2caefbed45 </code></pre> <p>The response type is specified as a URL path.</p> <h5>Response</h5> <p>The successful operation returns the <code>200 OK</code> status code and a payload similar to the following:</p> <pre><code>{ "_links": { "curies": { "href": "http://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-gatewayresponse-{rel}.html", "name": "gatewayresponse", "templated": true }, "self": { "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN" }, "gatewayresponse:delete": { "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN" }, "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN" } }, "defaultResponse": false, "responseParameters": { "gatewayresponse.header.x-request-path": "method.request.path.petId", "gatewayresponse.header.Access-Control-Allow-Origin": "&apos;a.b.c&apos;", "gatewayresponse.header.x-request-query": "method.request.querystring.q", "gatewayresponse.header.x-request-header": "method.request.header.Accept" }, "responseTemplates": { "application/json": "{\\n \\"message\\": $context.error.messageString,\\n \\"type\\": \\"$context.error.responseType\\",\\n \\"stage\\": \\"$context.stage\\",\\n \\"resourcePath\\": \\"$context.resourcePath\\",\\n \\"stageVariables.a\\": \\"$stageVariables.a\\",\\n \\"statusCode\\": \\"&apos;404&apos;\\"\\n}" }, "responseType": "MISSING_AUTHENTICATION_TOKEN", "statusCode": "404" }</code></pre> <p></p> </div> </div> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/customize-gateway-responses.html">Customize Gateway Responses</a> </div>', 'refs' => [ 'ListOfGatewayResponse$member' => NULL, ], ], 'GatewayResponseType' => [ 'base' => NULL, 'refs' => [ 'DeleteGatewayResponseRequest$responseType' => '<p>[Required] <p>The response type of the associated <a>GatewayResponse</a>. Valid values are <ul><li>ACCESS_DENIED</li><li>API_CONFIGURATION_ERROR</li><li>AUTHORIZER_FAILURE</li><li> AUTHORIZER_CONFIGURATION_ERROR</li><li>BAD_REQUEST_PARAMETERS</li><li>BAD_REQUEST_BODY</li><li>DEFAULT_4XX</li><li>DEFAULT_5XX</li><li>EXPIRED_TOKEN</li><li>INVALID_SIGNATURE</li><li>INTEGRATION_FAILURE</li><li>INTEGRATION_TIMEOUT</li><li>INVALID_API_KEY</li><li>MISSING_AUTHENTICATION_TOKEN</li><li> QUOTA_EXCEEDED</li><li>REQUEST_TOO_LARGE</li><li>RESOURCE_NOT_FOUND</li><li>THROTTLED</li><li>UNAUTHORIZED</li><li>UNSUPPORTED_MEDIA_TYPE</li></ul> </p></p>', 'GatewayResponse$responseType' => '<p>The response type of the associated <a>GatewayResponse</a>. Valid values are <ul><li>ACCESS_DENIED</li><li>API_CONFIGURATION_ERROR</li><li>AUTHORIZER_FAILURE</li><li> AUTHORIZER_CONFIGURATION_ERROR</li><li>BAD_REQUEST_PARAMETERS</li><li>BAD_REQUEST_BODY</li><li>DEFAULT_4XX</li><li>DEFAULT_5XX</li><li>EXPIRED_TOKEN</li><li>INVALID_SIGNATURE</li><li>INTEGRATION_FAILURE</li><li>INTEGRATION_TIMEOUT</li><li>INVALID_API_KEY</li><li>MISSING_AUTHENTICATION_TOKEN</li><li> QUOTA_EXCEEDED</li><li>REQUEST_TOO_LARGE</li><li>RESOURCE_NOT_FOUND</li><li>THROTTLED</li><li>UNAUTHORIZED</li><li>UNSUPPORTED_MEDIA_TYPE</li></ul> </p>', 'GetGatewayResponseRequest$responseType' => '<p>[Required] <p>The response type of the associated <a>GatewayResponse</a>. Valid values are <ul><li>ACCESS_DENIED</li><li>API_CONFIGURATION_ERROR</li><li>AUTHORIZER_FAILURE</li><li> AUTHORIZER_CONFIGURATION_ERROR</li><li>BAD_REQUEST_PARAMETERS</li><li>BAD_REQUEST_BODY</li><li>DEFAULT_4XX</li><li>DEFAULT_5XX</li><li>EXPIRED_TOKEN</li><li>INVALID_SIGNATURE</li><li>INTEGRATION_FAILURE</li><li>INTEGRATION_TIMEOUT</li><li>INVALID_API_KEY</li><li>MISSING_AUTHENTICATION_TOKEN</li><li> QUOTA_EXCEEDED</li><li>REQUEST_TOO_LARGE</li><li>RESOURCE_NOT_FOUND</li><li>THROTTLED</li><li>UNAUTHORIZED</li><li>UNSUPPORTED_MEDIA_TYPE</li></ul> </p></p>', 'PutGatewayResponseRequest$responseType' => '<p>[Required] <p>The response type of the associated <a>GatewayResponse</a>. Valid values are <ul><li>ACCESS_DENIED</li><li>API_CONFIGURATION_ERROR</li><li>AUTHORIZER_FAILURE</li><li> AUTHORIZER_CONFIGURATION_ERROR</li><li>BAD_REQUEST_PARAMETERS</li><li>BAD_REQUEST_BODY</li><li>DEFAULT_4XX</li><li>DEFAULT_5XX</li><li>EXPIRED_TOKEN</li><li>INVALID_SIGNATURE</li><li>INTEGRATION_FAILURE</li><li>INTEGRATION_TIMEOUT</li><li>INVALID_API_KEY</li><li>MISSING_AUTHENTICATION_TOKEN</li><li> QUOTA_EXCEEDED</li><li>REQUEST_TOO_LARGE</li><li>RESOURCE_NOT_FOUND</li><li>THROTTLED</li><li>UNAUTHORIZED</li><li>UNSUPPORTED_MEDIA_TYPE</li></ul> </p></p>', 'UpdateGatewayResponseRequest$responseType' => '<p>[Required] <p>The response type of the associated <a>GatewayResponse</a>. Valid values are <ul><li>ACCESS_DENIED</li><li>API_CONFIGURATION_ERROR</li><li>AUTHORIZER_FAILURE</li><li> AUTHORIZER_CONFIGURATION_ERROR</li><li>BAD_REQUEST_PARAMETERS</li><li>BAD_REQUEST_BODY</li><li>DEFAULT_4XX</li><li>DEFAULT_5XX</li><li>EXPIRED_TOKEN</li><li>INVALID_SIGNATURE</li><li>INTEGRATION_FAILURE</li><li>INTEGRATION_TIMEOUT</li><li>INVALID_API_KEY</li><li>MISSING_AUTHENTICATION_TOKEN</li><li> QUOTA_EXCEEDED</li><li>REQUEST_TOO_LARGE</li><li>RESOURCE_NOT_FOUND</li><li>THROTTLED</li><li>UNAUTHORIZED</li><li>UNSUPPORTED_MEDIA_TYPE</li></ul> </p></p>', ], ], 'GatewayResponses' => [ 'base' => '<p>The collection of the <a>GatewayResponse</a> instances of a <a>RestApi</a> as a <code>responseType</code>-to-<a>GatewayResponse</a> object map of key-value pairs. As such, pagination is not supported for querying this collection.</p> <div class="remarks"> For more information about valid gateway response types, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html">Gateway Response Types Supported by API Gateway</a> <div class="example"> <h4>Example: Get the collection of gateway responses of an API</h4> <h5>Request</h5> <p>This example request shows how to retrieve the <a>GatewayResponses</a> collection from an API.</p> <pre><code>GET /restapis/o81lxisefl/gatewayresponses HTTP/1.1 Host: beta-apigateway.us-east-1.amazonaws.com Content-Type: application/json X-Amz-Date: 20170503T220604Z Authorization: AWS4-HMAC-SHA256 Credential={access-key-id}/20170503/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature=59b42fe54a76a5de8adf2c67baa6d39206f8e9ad49a1d77ccc6a5da3103a398a Cache-Control: no-cache Postman-Token: 5637af27-dc29-fc5c-9dfe-0645d52cb515 </code></pre> <p></p> <h5>Response</h5> <p>The successful operation returns the <code>200 OK</code> status code and a payload similar to the following:</p> <pre><code>{ "_links": { "curies": { "href": "http://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-gatewayresponse-{rel}.html", "name": "gatewayresponse", "templated": true }, "self": { "href": "/restapis/o81lxisefl/gatewayresponses" }, "first": { "href": "/restapis/o81lxisefl/gatewayresponses" }, "gatewayresponse:by-type": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated": true }, "item": [ { "href": "/restapis/o81lxisefl/gatewayresponses/INTEGRATION_FAILURE" }, { "href": "/restapis/o81lxisefl/gatewayresponses/RESOURCE_NOT_FOUND" }, { "href": "/restapis/o81lxisefl/gatewayresponses/REQUEST_TOO_LARGE" }, { "href": "/restapis/o81lxisefl/gatewayresponses/THROTTLED" }, { "href": "/restapis/o81lxisefl/gatewayresponses/UNSUPPORTED_MEDIA_TYPE" }, { "href": "/restapis/o81lxisefl/gatewayresponses/AUTHORIZER_CONFIGURATION_ERROR" }, { "href": "/restapis/o81lxisefl/gatewayresponses/DEFAULT_5XX" }, { "href": "/restapis/o81lxisefl/gatewayresponses/DEFAULT_4XX" }, { "href": "/restapis/o81lxisefl/gatewayresponses/BAD_REQUEST_PARAMETERS" }, { "href": "/restapis/o81lxisefl/gatewayresponses/BAD_REQUEST_BODY" }, { "href": "/restapis/o81lxisefl/gatewayresponses/EXPIRED_TOKEN" }, { "href": "/restapis/o81lxisefl/gatewayresponses/ACCESS_DENIED" }, { "href": "/restapis/o81lxisefl/gatewayresponses/INVALID_API_KEY" }, { "href": "/restapis/o81lxisefl/gatewayresponses/UNAUTHORIZED" }, { "href": "/restapis/o81lxisefl/gatewayresponses/API_CONFIGURATION_ERROR" }, { "href": "/restapis/o81lxisefl/gatewayresponses/QUOTA_EXCEEDED" }, { "href": "/restapis/o81lxisefl/gatewayresponses/INTEGRATION_TIMEOUT" }, { "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN" }, { "href": "/restapis/o81lxisefl/gatewayresponses/INVALID_SIGNATURE" }, { "href": "/restapis/o81lxisefl/gatewayresponses/AUTHORIZER_FAILURE" } ] }, "_embedded": { "item": [ { "_links": { "self": { "href": "/restapis/o81lxisefl/gatewayresponses/INTEGRATION_FAILURE" }, "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/INTEGRATION_FAILURE" } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates": { "application/json": "{\\"message\\":$context.error.messageString}" }, "responseType": "INTEGRATION_FAILURE", "statusCode": "504" }, { "_links": { "self": { "href": "/restapis/o81lxisefl/gatewayresponses/RESOURCE_NOT_FOUND" }, "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/RESOURCE_NOT_FOUND" } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates": { "application/json": "{\\"message\\":$context.error.messageString}" }, "responseType": "RESOURCE_NOT_FOUND", "statusCode": "404" }, { "_links": { "self": { "href": "/restapis/o81lxisefl/gatewayresponses/REQUEST_TOO_LARGE" }, "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/REQUEST_TOO_LARGE" } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates": { "application/json": "{\\"message\\":$context.error.messageString}" }, "responseType": "REQUEST_TOO_LARGE", "statusCode": "413" }, { "_links": { "self": { "href": "/restapis/o81lxisefl/gatewayresponses/THROTTLED" }, "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/THROTTLED" } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates": { "application/json": "{\\"message\\":$context.error.messageString}" }, "responseType": "THROTTLED", "statusCode": "429" }, { "_links": { "self": { "href": "/restapis/o81lxisefl/gatewayresponses/UNSUPPORTED_MEDIA_TYPE" }, "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/UNSUPPORTED_MEDIA_TYPE" } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates": { "application/json": "{\\"message\\":$context.error.messageString}" }, "responseType": "UNSUPPORTED_MEDIA_TYPE", "statusCode": "415" }, { "_links": { "self": { "href": "/restapis/o81lxisefl/gatewayresponses/AUTHORIZER_CONFIGURATION_ERROR" }, "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/AUTHORIZER_CONFIGURATION_ERROR" } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates": { "application/json": "{\\"message\\":$context.error.messageString}" }, "responseType": "AUTHORIZER_CONFIGURATION_ERROR", "statusCode": "500" }, { "_links": { "self": { "href": "/restapis/o81lxisefl/gatewayresponses/DEFAULT_5XX" }, "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/DEFAULT_5XX" } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates": { "application/json": "{\\"message\\":$context.error.messageString}" }, "responseType": "DEFAULT_5XX" }, { "_links": { "self": { "href": "/restapis/o81lxisefl/gatewayresponses/DEFAULT_4XX" }, "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/DEFAULT_4XX" } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates": { "application/json": "{\\"message\\":$context.error.messageString}" }, "responseType": "DEFAULT_4XX" }, { "_links": { "self": { "href": "/restapis/o81lxisefl/gatewayresponses/BAD_REQUEST_PARAMETERS" }, "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/BAD_REQUEST_PARAMETERS" } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates": { "application/json": "{\\"message\\":$context.error.messageString}" }, "responseType": "BAD_REQUEST_PARAMETERS", "statusCode": "400" }, { "_links": { "self": { "href": "/restapis/o81lxisefl/gatewayresponses/BAD_REQUEST_BODY" }, "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/BAD_REQUEST_BODY" } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates": { "application/json": "{\\"message\\":$context.error.messageString}" }, "responseType": "BAD_REQUEST_BODY", "statusCode": "400" }, { "_links": { "self": { "href": "/restapis/o81lxisefl/gatewayresponses/EXPIRED_TOKEN" }, "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/EXPIRED_TOKEN" } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates": { "application/json": "{\\"message\\":$context.error.messageString}" }, "responseType": "EXPIRED_TOKEN", "statusCode": "403" }, { "_links": { "self": { "href": "/restapis/o81lxisefl/gatewayresponses/ACCESS_DENIED" }, "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/ACCESS_DENIED" } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates": { "application/json": "{\\"message\\":$context.error.messageString}" }, "responseType": "ACCESS_DENIED", "statusCode": "403" }, { "_links": { "self": { "href": "/restapis/o81lxisefl/gatewayresponses/INVALID_API_KEY" }, "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/INVALID_API_KEY" } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates": { "application/json": "{\\"message\\":$context.error.messageString}" }, "responseType": "INVALID_API_KEY", "statusCode": "403" }, { "_links": { "self": { "href": "/restapis/o81lxisefl/gatewayresponses/UNAUTHORIZED" }, "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/UNAUTHORIZED" } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates": { "application/json": "{\\"message\\":$context.error.messageString}" }, "responseType": "UNAUTHORIZED", "statusCode": "401" }, { "_links": { "self": { "href": "/restapis/o81lxisefl/gatewayresponses/API_CONFIGURATION_ERROR" }, "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/API_CONFIGURATION_ERROR" } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates": { "application/json": "{\\"message\\":$context.error.messageString}" }, "responseType": "API_CONFIGURATION_ERROR", "statusCode": "500" }, { "_links": { "self": { "href": "/restapis/o81lxisefl/gatewayresponses/QUOTA_EXCEEDED" }, "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/QUOTA_EXCEEDED" } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates": { "application/json": "{\\"message\\":$context.error.messageString}" }, "responseType": "QUOTA_EXCEEDED", "statusCode": "429" }, { "_links": { "self": { "href": "/restapis/o81lxisefl/gatewayresponses/INTEGRATION_TIMEOUT" }, "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/INTEGRATION_TIMEOUT" } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates": { "application/json": "{\\"message\\":$context.error.messageString}" }, "responseType": "INTEGRATION_TIMEOUT", "statusCode": "504" }, { "_links": { "self": { "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN" }, "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN" } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates": { "application/json": "{\\"message\\":$context.error.messageString}" }, "responseType": "MISSING_AUTHENTICATION_TOKEN", "statusCode": "403" }, { "_links": { "self": { "href": "/restapis/o81lxisefl/gatewayresponses/INVALID_SIGNATURE" }, "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/INVALID_SIGNATURE" } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates": { "application/json": "{\\"message\\":$context.error.messageString}" }, "responseType": "INVALID_SIGNATURE", "statusCode": "403" }, { "_links": { "self": { "href": "/restapis/o81lxisefl/gatewayresponses/AUTHORIZER_FAILURE" }, "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/AUTHORIZER_FAILURE" } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates": { "application/json": "{\\"message\\":$context.error.messageString}" }, "responseType": "AUTHORIZER_FAILURE", "statusCode": "500" } ] } }</code></pre> <p></p> </div> </div> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/customize-gateway-responses.html">Customize Gateway Responses</a> </div>', 'refs' => [], ], 'GenerateClientCertificateRequest' => [ 'base' => '<p>A request to generate a <a>ClientCertificate</a> resource.</p>', 'refs' => [], ], 'GetAccountRequest' => [ 'base' => '<p>Requests API Gateway to get information about the current <a>Account</a> resource.</p>', 'refs' => [], ], 'GetApiKeyRequest' => [ 'base' => '<p>A request to get information about the current <a>ApiKey</a> resource.</p>', 'refs' => [], ], 'GetApiKeysRequest' => [ 'base' => '<p>A request to get information about the current <a>ApiKeys</a> resource.</p>', 'refs' => [], ], 'GetAuthorizerRequest' => [ 'base' => '<p>Request to describe an existing <a>Authorizer</a> resource.</p>', 'refs' => [], ], 'GetAuthorizersRequest' => [ 'base' => '<p>Request to describe an existing <a>Authorizers</a> resource.</p>', 'refs' => [], ], 'GetBasePathMappingRequest' => [ 'base' => '<p>Request to describe a <a>BasePathMapping</a> resource.</p>', 'refs' => [], ], 'GetBasePathMappingsRequest' => [ 'base' => '<p>A request to get information about a collection of <a>BasePathMapping</a> resources.</p>', 'refs' => [], ], 'GetClientCertificateRequest' => [ 'base' => '<p>A request to get information about the current <a>ClientCertificate</a> resource.</p>', 'refs' => [], ], 'GetClientCertificatesRequest' => [ 'base' => '<p>A request to get information about a collection of <a>ClientCertificate</a> resources.</p>', 'refs' => [], ], 'GetDeploymentRequest' => [ 'base' => '<p>Requests API Gateway to get information about a <a>Deployment</a> resource.</p>', 'refs' => [], ], 'GetDeploymentsRequest' => [ 'base' => '<p>Requests API Gateway to get information about a <a>Deployments</a> collection.</p>', 'refs' => [], ], 'GetDocumentationPartRequest' => [ 'base' => '<p>Gets a specified documentation part of a given API.</p>', 'refs' => [], ], 'GetDocumentationPartsRequest' => [ 'base' => '<p>Gets the documentation parts of an API. The result may be filtered by the type, name, or path of API entities (targets).</p>', 'refs' => [], ], 'GetDocumentationVersionRequest' => [ 'base' => '<p>Gets a documentation snapshot of an API.</p>', 'refs' => [], ], 'GetDocumentationVersionsRequest' => [ 'base' => '<p>Gets the documentation versions of an API.</p>', 'refs' => [], ], 'GetDomainNameRequest' => [ 'base' => '<p>Request to get the name of a <a>DomainName</a> resource.</p>', 'refs' => [], ], 'GetDomainNamesRequest' => [ 'base' => '<p>Request to describe a collection of <a>DomainName</a> resources.</p>', 'refs' => [], ], 'GetExportRequest' => [ 'base' => '<p>Request a new export of a <a>RestApi</a> for a particular <a>Stage</a>.</p>', 'refs' => [], ], 'GetGatewayResponseRequest' => [ 'base' => '<p>Gets a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a>.</p>', 'refs' => [], ], 'GetGatewayResponsesRequest' => [ 'base' => '<p>Gets the <a>GatewayResponses</a> collection on the given <a>RestApi</a>. If an API developer has not added any definitions for gateway responses, the result will be the API Gateway-generated default <a>GatewayResponses</a> collection for the supported response types.</p>', 'refs' => [], ], 'GetIntegrationRequest' => [ 'base' => '<p>Represents a request to get the integration configuration.</p>', 'refs' => [], ], 'GetIntegrationResponseRequest' => [ 'base' => '<p>Represents a get integration response request.</p>', 'refs' => [], ], 'GetMethodRequest' => [ 'base' => '<p>Request to describe an existing <a>Method</a> resource.</p>', 'refs' => [], ], 'GetMethodResponseRequest' => [ 'base' => '<p>Request to describe a <a>MethodResponse</a> resource.</p>', 'refs' => [], ], 'GetModelRequest' => [ 'base' => '<p>Request to list information about a model in an existing <a>RestApi</a> resource.</p>', 'refs' => [], ], 'GetModelTemplateRequest' => [ 'base' => '<p>Request to generate a sample mapping template used to transform the payload.</p>', 'refs' => [], ], 'GetModelsRequest' => [ 'base' => '<p>Request to list existing <a>Models</a> defined for a <a>RestApi</a> resource.</p>', 'refs' => [], ], 'GetRequestValidatorRequest' => [ 'base' => '<p>Gets a <a>RequestValidator</a> of a given <a>RestApi</a>.</p>', 'refs' => [], ], 'GetRequestValidatorsRequest' => [ 'base' => '<p>Gets the <a>RequestValidators</a> collection of a given <a>RestApi</a>.</p>', 'refs' => [], ], 'GetResourceRequest' => [ 'base' => '<p>Request to list information about a resource.</p>', 'refs' => [], ], 'GetResourcesRequest' => [ 'base' => '<p>Request to list information about a collection of resources.</p>', 'refs' => [], ], 'GetRestApiRequest' => [ 'base' => '<p>The GET request to list an existing <a>RestApi</a> defined for your collection. </p>', 'refs' => [], ], 'GetRestApisRequest' => [ 'base' => '<p>The GET request to list existing <a>RestApis</a> defined for your collection.</p>', 'refs' => [], ], 'GetSdkRequest' => [ 'base' => '<p>Request a new generated client SDK for a <a>RestApi</a> and <a>Stage</a>.</p>', 'refs' => [], ], 'GetSdkTypeRequest' => [ 'base' => '<p>Get an <a>SdkType</a> instance.</p>', 'refs' => [], ], 'GetSdkTypesRequest' => [ 'base' => '<p>Get the <a>SdkTypes</a> collection.</p>', 'refs' => [], ], 'GetStageRequest' => [ 'base' => '<p>Requests API Gateway to get information about a <a>Stage</a> resource.</p>', 'refs' => [], ], 'GetStagesRequest' => [ 'base' => '<p>Requests API Gateway to get information about one or more <a>Stage</a> resources.</p>', 'refs' => [], ], 'GetTagsRequest' => [ 'base' => '<p>Gets the <a>Tags</a> collection for a given resource.</p>', 'refs' => [], ], 'GetUsagePlanKeyRequest' => [ 'base' => '<p>The GET request to get a usage plan key of a given key identifier.</p>', 'refs' => [], ], 'GetUsagePlanKeysRequest' => [ 'base' => '<p>The GET request to get all the usage plan keys representing the API keys added to a specified usage plan.</p>', 'refs' => [], ], 'GetUsagePlanRequest' => [ 'base' => '<p>The GET request to get a usage plan of a given plan identifier.</p>', 'refs' => [], ], 'GetUsagePlansRequest' => [ 'base' => '<p>The GET request to get all the usage plans of the caller\'s account.</p>', 'refs' => [], ], 'GetUsageRequest' => [ 'base' => '<p>The GET request to get the usage data of a usage plan in a specified time interval.</p>', 'refs' => [], ], 'GetVpcLinkRequest' => [ 'base' => '<p>Gets a specified VPC link under the caller\'s account in a region.</p>', 'refs' => [], ], 'GetVpcLinksRequest' => [ 'base' => '<p>Gets the <a>VpcLinks</a> collection under the caller\'s account in a selected region.</p>', 'refs' => [], ], 'ImportApiKeysRequest' => [ 'base' => '<p>The POST request to import API keys from an external source, such as a CSV-formatted file.</p>', 'refs' => [], ], 'ImportDocumentationPartsRequest' => [ 'base' => '<p>Import documentation parts from an external (e.g., OpenAPI) definition file. </p>', 'refs' => [], ], 'ImportRestApiRequest' => [ 'base' => '<p>A POST request to import an API to API Gateway using an input of an API definition file.</p>', 'refs' => [], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'Integration$timeoutInMillis' => '<p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>', 'MethodSetting$throttlingBurstLimit' => '<p>Specifies the throttling burst limit. The PATCH path for this setting is <code>/{method_setting_key}/throttling/burstLimit</code>, and the value is an integer.</p>', 'MethodSetting$cacheTtlInSeconds' => '<p>Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response will be cached. The PATCH path for this setting is <code>/{method_setting_key}/caching/ttlInSeconds</code>, and the value is an integer.</p>', 'QuotaSettings$limit' => '<p>The maximum number of requests that can be made in a given time period.</p>', 'QuotaSettings$offset' => '<p>The number of requests subtracted from the given limit in the initial time period.</p>', 'TestInvokeAuthorizerResponse$clientStatus' => '<p>The HTTP status code that the client would have received. Value is 0 if the authorizer succeeded.</p>', 'TestInvokeMethodResponse$status' => '<p>The HTTP status code.</p>', 'ThrottleSettings$burstLimit' => '<p>The API request burst limit, the maximum rate limit over a time ranging from one to a few seconds, depending upon whether the underlying token bucket is at its full capacity.</p>', ], ], 'Integration' => [ 'base' => '<p>Represents an HTTP, HTTP_PROXY, AWS, AWS_PROXY, or Mock integration.</p> <div class="remarks">In the API Gateway console, the built-in Lambda integration is an AWS integration.</div> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a> </div>', 'refs' => [ 'Method$methodIntegration' => '<p>Gets the method\'s integration responsible for passing the client-submitted request to the back end and performing necessary transformations to make the request compliant with the back end.</p> <div class="remarks"> <p/> <h4>Example: </h4> <h5>Request</h5> <p/> <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com Content-Length: 117 X-Amz-Date: 20160613T213210Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre> <h5>Response</h5> <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p> <pre><code>{ "_links": { "curies": [ { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html", "name": "integration", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html", "name": "integrationresponse", "templated": true } ], "self": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration" }, "integration:delete": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration" }, "integration:responses": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200", "name": "200", "title": "200" }, "integration:update": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration" }, "integrationresponse:put": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/{status_code}", "templated": true } }, "cacheKeyParameters": [], "cacheNamespace": "0cjtch", "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole", "httpMethod": "POST", "passthroughBehavior": "WHEN_NO_MATCH", "requestTemplates": { "application/json": "{\\n \\"a\\": \\"$input.params(\'operand1\')\\",\\n \\"b\\": \\"$input.params(\'operand2\')\\", \\n \\"op\\": \\"$input.params(\'operator\')\\" \\n}" }, "type": "AWS", "uri": "arn:aws:apigateway:us-west-2:lambda:path//2015-03-31/functions/arn:aws:lambda:us-west-2:123456789012:function:Calc/invocations", "_embedded": { "integration:responses": { "_links": { "self": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200", "name": "200", "title": "200" }, "integrationresponse:delete": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200" }, "integrationresponse:update": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200" } }, "responseParameters": { "method.response.header.operator": "integration.response.body.op", "method.response.header.operand_2": "integration.response.body.b", "method.response.header.operand_1": "integration.response.body.a" }, "responseTemplates": { "application/json": "#set($res = $input.path(\'$\'))\\n{\\n \\"result\\": \\"$res.a, $res.b, $res.op => $res.c\\",\\n \\"a\\" : \\"$res.a\\",\\n \\"b\\" : \\"$res.b\\",\\n \\"op\\" : \\"$res.op\\",\\n \\"c\\" : \\"$res.c\\"\\n}" }, "selectionPattern": "", "statusCode": "200" } } }</code></pre> <p/> </div> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-integration.html">AWS CLI</a> </div>', ], ], 'IntegrationResponse' => [ 'base' => '<p>Represents an integration response. The status code must map to an existing <a>MethodResponse</a>, and parameters and templates can be used to transform the back-end response.</p> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a> </div>', 'refs' => [ 'MapOfIntegrationResponse$value' => NULL, ], ], 'IntegrationType' => [ 'base' => '<p>The integration type. The valid value is <code>HTTP</code> for integrating an API method with an HTTP backend; <code>AWS</code> with any AWS service endpoints; <code>MOCK</code> for testing without actually invoking the backend; <code>HTTP_PROXY</code> for integrating with the HTTP proxy integration; <code>AWS_PROXY</code> for integrating with the Lambda proxy integration. </p>', 'refs' => [ 'Integration$type' => '<p>Specifies an API method integration type. The valid value is one of the following:</p> <ul> <li><code>AWS</code>: for integrating the API method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration.</li> <li><code>AWS_PROXY</code>: for integrating the API method request with the Lambda function-invoking action with the client request passed through as-is. This integration is also referred to as the Lambda proxy integration.</li> <li><code>HTTP</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC. This integration is also referred to as the HTTP custom integration.</li> <li><code>HTTP_PROXY</code>: for integrating the API method request with an HTTP endpoint, including a private HTTP endpoint within a VPC, with the client request passed through as-is. This is also referred to as the HTTP proxy integration.</li> <li><code>MOCK</code>: for integrating the API method request with API Gateway as a "loop-back" endpoint without invoking any backend.</li> </ul> <p>For the HTTP and HTTP proxy integrations, each integration can specify a protocol (<code>http/https</code>), port and path. Standard 80 and 443 ports are supported as well as custom ports above 1024. An HTTP or HTTP proxy integration with a <code>connectionType</code> of <code>VPC_LINK</code> is referred to as a private integration and uses a <a>VpcLink</a> to connect API Gateway to a network load balancer of a VPC.</p>', 'PutIntegrationRequest$type' => '<p>[Required] Specifies a put integration input\'s type.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The request exceeded the rate limit. Retry after the specified time period.</p>', 'refs' => [], ], 'ListOfARNs' => [ 'base' => NULL, 'refs' => [ 'Authorizer$providerARNs' => '<p>A list of the Amazon Cognito user pool ARNs for the <code>COGNITO_USER_POOLS</code> authorizer. Each element is of this format: <code>arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}</code>. For a <code>TOKEN</code> or <code>REQUEST</code> authorizer, this is not defined. </p>', 'CreateAuthorizerRequest$providerARNs' => '<p>A list of the Amazon Cognito user pool ARNs for the <code>COGNITO_USER_POOLS</code> authorizer. Each element is of this format: <code>arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}</code>. For a <code>TOKEN</code> or <code>REQUEST</code> authorizer, this is not defined. </p>', ], ], 'ListOfApiKey' => [ 'base' => NULL, 'refs' => [ 'ApiKeys$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfApiStage' => [ 'base' => NULL, 'refs' => [ 'CreateUsagePlanRequest$apiStages' => '<p>The associated API stages of the usage plan.</p>', 'UsagePlan$apiStages' => '<p>The associated API stages of a usage plan.</p>', ], ], 'ListOfAuthorizer' => [ 'base' => NULL, 'refs' => [ 'Authorizers$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfBasePathMapping' => [ 'base' => NULL, 'refs' => [ 'BasePathMappings$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfClientCertificate' => [ 'base' => NULL, 'refs' => [ 'ClientCertificates$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfDeployment' => [ 'base' => NULL, 'refs' => [ 'Deployments$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfDocumentationPart' => [ 'base' => NULL, 'refs' => [ 'DocumentationParts$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfDocumentationVersion' => [ 'base' => NULL, 'refs' => [ 'DocumentationVersions$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfDomainName' => [ 'base' => NULL, 'refs' => [ 'DomainNames$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfEndpointType' => [ 'base' => NULL, 'refs' => [ 'EndpointConfiguration$types' => '<p>A list of endpoint types of an API (<a>RestApi</a>) or its custom domain name (<a>DomainName</a>). For an edge-optimized API and its custom domain name, the endpoint type is <code>"EDGE"</code>. For a regional API and its custom domain name, the endpoint type is <code>REGIONAL</code>. For a private API, the endpoint type is <code>PRIVATE</code>.</p>', ], ], 'ListOfGatewayResponse' => [ 'base' => NULL, 'refs' => [ 'GatewayResponses$items' => '<p>Returns the entire collection, because of no pagination support.</p>', ], ], 'ListOfLong' => [ 'base' => NULL, 'refs' => [ 'ListOfUsage$member' => NULL, ], ], 'ListOfModel' => [ 'base' => NULL, 'refs' => [ 'Models$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfPatchOperation' => [ 'base' => 'A list of operations describing the updates to apply to the specified resource. The patches are applied in the order specified in the list.', 'refs' => [ 'UpdateAccountRequest$patchOperations' => '<p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>', 'UpdateApiKeyRequest$patchOperations' => '<p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>', 'UpdateAuthorizerRequest$patchOperations' => '<p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>', 'UpdateBasePathMappingRequest$patchOperations' => '<p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>', 'UpdateClientCertificateRequest$patchOperations' => '<p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>', 'UpdateDeploymentRequest$patchOperations' => '<p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>', 'UpdateDocumentationPartRequest$patchOperations' => '<p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>', 'UpdateDocumentationVersionRequest$patchOperations' => '<p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>', 'UpdateDomainNameRequest$patchOperations' => '<p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>', 'UpdateGatewayResponseRequest$patchOperations' => '<p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>', 'UpdateIntegrationRequest$patchOperations' => '<p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>', 'UpdateIntegrationResponseRequest$patchOperations' => '<p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>', 'UpdateMethodRequest$patchOperations' => '<p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>', 'UpdateMethodResponseRequest$patchOperations' => '<p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>', 'UpdateModelRequest$patchOperations' => '<p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>', 'UpdateRequestValidatorRequest$patchOperations' => '<p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>', 'UpdateResourceRequest$patchOperations' => '<p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>', 'UpdateRestApiRequest$patchOperations' => '<p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>', 'UpdateStageRequest$patchOperations' => '<p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>', 'UpdateUsagePlanRequest$patchOperations' => '<p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>', 'UpdateUsageRequest$patchOperations' => '<p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>', 'UpdateVpcLinkRequest$patchOperations' => '<p>A list of update operations to be applied to the specified resource and in the order specified in this list.</p>', ], ], 'ListOfRequestValidator' => [ 'base' => NULL, 'refs' => [ 'RequestValidators$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfResource' => [ 'base' => NULL, 'refs' => [ 'Resources$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfRestApi' => [ 'base' => NULL, 'refs' => [ 'RestApis$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfSdkConfigurationProperty' => [ 'base' => NULL, 'refs' => [ 'SdkType$configurationProperties' => '<p>A list of configuration properties of an <a>SdkType</a>.</p>', ], ], 'ListOfSdkType' => [ 'base' => NULL, 'refs' => [ 'SdkTypes$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfStage' => [ 'base' => NULL, 'refs' => [ 'Stages$item' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfStageKeys' => [ 'base' => NULL, 'refs' => [ 'CreateApiKeyRequest$stageKeys' => '<p>DEPRECATED FOR USAGE PLANS - Specifies stages associated with the API key.</p>', ], ], 'ListOfString' => [ 'base' => NULL, 'refs' => [ 'Account$features' => '<p>A list of features supported for the account. When usage plans are enabled, the features list will include an entry of <code>"UsagePlans"</code>.</p>', 'ApiKey$stageKeys' => '<p>A list of <a>Stage</a> resources that are associated with the <a>ApiKey</a> resource.</p>', 'ApiKeyIds$ids' => '<p>A list of all the <a>ApiKey</a> identifiers.</p>', 'ApiKeyIds$warnings' => '<p>A list of warning messages.</p>', 'ApiKeys$warnings' => '<p>A list of warning messages logged during the import of API keys when the <code>failOnWarnings</code> option is set to true.</p>', 'CreateRestApiRequest$binaryMediaTypes' => '<p>The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.</p>', 'CreateVpcLinkRequest$targetArns' => '<p>[Required] The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.</p>', 'DocumentationPartIds$ids' => '<p>A list of the returned documentation part identifiers.</p>', 'DocumentationPartIds$warnings' => '<p>A list of warning messages reported during import of documentation parts.</p>', 'EndpointConfiguration$vpcEndpointIds' => '<p>A list of VpcEndpointIds of an API (<a>RestApi</a>) against which to create Route53 ALIASes. It is only supported for <code>PRIVATE</code> endpoint type.</p>', 'GetDeploymentRequest$embed' => '<p>A query parameter to retrieve the specified embedded resources of the returned <a>Deployment</a> resource in the response. In a REST API call, this <code>embed</code> parameter value is a list of comma-separated strings, as in <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=var1,var2</code>. The SDK and other platform-dependent libraries might use a different format for the list. Currently, this request supports only retrieval of the embedded API summary this way. Hence, the parameter value must be a single-valued list containing only the <code>"apisummary"</code> string. For example, <code>GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=apisummary</code>.</p>', 'GetResourceRequest$embed' => '<p>A query parameter to retrieve the specified resources embedded in the returned <a>Resource</a> representation in the response. This <code>embed</code> parameter value is a list of comma-separated strings. Currently, the request supports only retrieval of the embedded <a>Method</a> resources this way. The query parameter value must be a single-valued list and contain the <code>"methods"</code> string. For example, <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code>.</p>', 'GetResourcesRequest$embed' => '<p>A query parameter used to retrieve the specified resources embedded in the returned <a>Resources</a> resource in the response. This <code>embed</code> parameter value is a list of comma-separated strings. Currently, the request supports only retrieval of the embedded <a>Method</a> resources this way. The query parameter value must be a single-valued list and contain the <code>"methods"</code> string. For example, <code>GET /restapis/{restapi_id}/resources?embed=methods</code>.</p>', 'Integration$cacheKeyParameters' => '<p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.</p>', 'MapOfStringToList$value' => NULL, 'Method$authorizationScopes' => '<p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>', 'PutIntegrationRequest$cacheKeyParameters' => '<p>A list of request parameters whose values API Gateway caches. To be valid values for <code>cacheKeyParameters</code>, these parameters must also be specified for <a>Method</a> <code>requestParameters</code>.</p>', 'PutMethodRequest$authorizationScopes' => '<p>A list of authorization scopes configured on the method. The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.</p>', 'RestApi$warnings' => '<p>The warning messages reported when <code>failonwarnings</code> is turned on during API import.</p>', 'RestApi$binaryMediaTypes' => '<p>The list of binary media types supported by the <a>RestApi</a>. By default, the <a>RestApi</a> supports only UTF-8-encoded text payloads.</p>', 'UntagResourceRequest$tagKeys' => '<p>[Required] The Tag keys to delete.</p>', 'VpcLink$targetArns' => '<p>The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.</p>', ], ], 'ListOfUsage' => [ 'base' => NULL, 'refs' => [ 'MapOfKeyUsages$value' => NULL, ], ], 'ListOfUsagePlan' => [ 'base' => NULL, 'refs' => [ 'UsagePlans$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfUsagePlanKey' => [ 'base' => NULL, 'refs' => [ 'UsagePlanKeys$items' => '<p>The current page of elements from this collection.</p>', ], ], 'ListOfVpcLink' => [ 'base' => NULL, 'refs' => [ 'VpcLinks$items' => '<p>The current page of elements from this collection.</p>', ], ], 'LocationStatusType' => [ 'base' => NULL, 'refs' => [ 'GetDocumentationPartsRequest$locationStatus' => '<p>The status of the API documentation parts to retrieve. Valid values are <code>DOCUMENTED</code> for retrieving <a>DocumentationPart</a> resources with content and <code>UNDOCUMENTED</code> for <a>DocumentationPart</a> resources without content.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'ListOfLong$member' => NULL, 'TestInvokeAuthorizerResponse$latency' => '<p>The execution latency of the test authorizer request.</p>', 'TestInvokeMethodResponse$latency' => '<p>The execution latency of the test invoke request.</p>', ], ], 'MapOfApiStageThrottleSettings' => [ 'base' => NULL, 'refs' => [ 'ApiStage$throttle' => '<p>Map containing method level throttling information for API stage in a usage plan.</p>', ], ], 'MapOfIntegrationResponse' => [ 'base' => NULL, 'refs' => [ 'Integration$integrationResponses' => '<p>Specifies the integration\'s responses.</p> <div class="remarks"> <p/> <h4>Example: Get integration responses of a method</h4> <h5>Request</h5> <p/> <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200 HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com X-Amz-Date: 20160607T191449Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash} </code></pre> <h5>Response</h5> <p>The successful response returns <code>200 OK</code> status and a payload as follows:</p> <pre><code>{ "_links": { "curies": { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html", "name": "integrationresponse", "templated": true }, "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200", "title": "200" }, "integrationresponse:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200" }, "integrationresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200" } }, "responseParameters": { "method.response.header.Content-Type": "\'application/xml\'" }, "responseTemplates": { "application/json": "$util.urlDecode(\\"%3CkinesisStreams%3E#foreach($stream in $input.path(\'$.StreamNames\'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\\")\\n" }, "statusCode": "200" }</code></pre> <p/> </div> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a> </div>', ], ], 'MapOfKeyUsages' => [ 'base' => NULL, 'refs' => [ 'Usage$items' => '<p>The usage data, as daily logs of used and remaining quotas, over the specified time interval indexed over the API keys in a usage plan. For example, <code>{..., "values" : { "{api_key}" : [ [0, 100], [10, 90], [100, 10]]}</code>, where <code>{api_key}</code> stands for an API key value and the daily log entry is of the format <code>[used quota, remaining quota]</code>.</p>', ], ], 'MapOfMethod' => [ 'base' => NULL, 'refs' => [ 'Resource$resourceMethods' => '<p>Gets an API resource\'s method of a given HTTP verb.</p> <div class="remarks"> <p>The resource methods are a map of methods indexed by methods\' HTTP verbs enabled on the resource. This method map is included in the <code>200 OK</code> response of the <code>GET /restapis/{restapi_id}/resources/{resource_id}</code> or <code>GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods</code> request.</p> <h4>Example: Get the GET method of an API resource</h4> <h5>Request</h5> <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com X-Amz-Date: 20170223T031827Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20170223/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre> <h5>Response</h5> <pre><code>{ "_links": { "curies": [ { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html", "name": "integration", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html", "name": "integrationresponse", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html", "name": "method", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html", "name": "methodresponse", "templated": true } ], "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET", "name": "GET", "title": "GET" }, "integration:put": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration" }, "method:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET" }, "method:integration": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration" }, "method:responses": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200", "name": "200", "title": "200" }, "method:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET" }, "methodresponse:put": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}", "templated": true } }, "apiKeyRequired": false, "authorizationType": "NONE", "httpMethod": "GET", "_embedded": { "method:integration": { "_links": { "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration" }, "integration:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration" }, "integration:responses": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200", "name": "200", "title": "200" }, "integration:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration" }, "integrationresponse:put": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}", "templated": true } }, "cacheKeyParameters": [], "cacheNamespace": "3kzxbg5sa2", "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole", "httpMethod": "POST", "passthroughBehavior": "WHEN_NO_MATCH", "requestParameters": { "integration.request.header.Content-Type": "\'application/x-amz-json-1.1\'" }, "requestTemplates": { "application/json": "{\\n}" }, "type": "AWS", "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams", "_embedded": { "integration:responses": { "_links": { "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200", "name": "200", "title": "200" }, "integrationresponse:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200" }, "integrationresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200" } }, "responseParameters": { "method.response.header.Content-Type": "\'application/xml\'" }, "responseTemplates": { "application/json": "$util.urlDecode(\\"%3CkinesisStreams%3E#foreach($stream in $input.path(\'$.StreamNames\'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\\")\\n" }, "statusCode": "200" } } }, "method:responses": { "_links": { "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200", "name": "200", "title": "200" }, "methodresponse:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200" }, "methodresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200" } }, "responseModels": { "application/json": "Empty" }, "responseParameters": { "method.response.header.Content-Type": false }, "statusCode": "200" } } }</code></pre> <p>If the <code>OPTIONS</code> is enabled on the resource, you can follow the example here to get that method. Just replace the <code>GET</code> of the last path segment in the request URL with <code>OPTIONS</code>.</p> </div> <div class="seeAlso"> </div>', ], ], 'MapOfMethodResponse' => [ 'base' => NULL, 'refs' => [ 'Method$methodResponses' => '<p>Gets a method response associated with a given HTTP status code. </p> <div class="remarks"> <p>The collection of method responses are encapsulated in a key-value map, where the key is a response\'s HTTP status code and the value is a <a>MethodResponse</a> resource that specifies the response returned to the caller from the back end through the integration response.</p> <h4>Example: Get a 200 OK response of a GET method</h4> <h5>Request</h5> <p/> <pre><code>GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200 HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com Content-Length: 117 X-Amz-Date: 20160613T215008Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre> <h5>Response</h5> <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p> <pre><code>{ "_links": { "curies": { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html", "name": "methodresponse", "templated": true }, "self": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200", "title": "200" }, "methodresponse:delete": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200" }, "methodresponse:update": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200" } }, "responseModels": { "application/json": "Empty" }, "responseParameters": { "method.response.header.operator": false, "method.response.header.operand_2": false, "method.response.header.operand_1": false }, "statusCode": "200" }</code></pre> <p/> </div> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-method-response.html">AWS CLI</a> </div>', ], ], 'MapOfMethodSettings' => [ 'base' => NULL, 'refs' => [ 'Stage$methodSettings' => '<p>A map that defines the method settings for a <a>Stage</a> resource. Keys (designated as <code>/{method_setting_key</code> below) are method paths defined as <code>{resource_path}/{http_method}</code> for an individual method override, or <code>/\\*/\\*</code> for overriding all methods in the stage. </p>', ], ], 'MapOfMethodSnapshot' => [ 'base' => NULL, 'refs' => [ 'PathToMapOfMethodSnapshot$value' => NULL, ], ], 'MapOfStringToBoolean' => [ 'base' => NULL, 'refs' => [ 'Method$requestParameters' => '<p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key is a method request parameter name matching the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>). The method request parameter names defined here are available in <a>Integration</a> to be mapped to integration request parameters or templates.</p>', 'MethodResponse$responseParameters' => '<p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API\'s <a>IntegrationResponse</a>. The integration response data that can be mapped include an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>\'application/json\'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>', 'PutMethodRequest$requestParameters' => '<p>A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key defines a method request parameter name matching the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (<code>true</code>) or optional (<code>false</code>). The method request parameter names defined here are available in <a>Integration</a> to be mapped to integration request parameters or body-mapping templates.</p>', 'PutMethodResponseRequest$responseParameters' => '<p>A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header name and the associated value is a Boolean flag indicating whether the method response parameter is required or not. The method response header names must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The response parameter names defined here are available in the integration response to be mapped from an integration response header expressed in <code>integration.response.header.{name}</code>, a static value enclosed within a pair of single quotes (e.g., <code>\'application/json\'</code>), or a JSON expression from the back-end response payload in the form of <code>integration.response.body.{JSON-expression}</code>, where <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.)</p>', ], ], 'MapOfStringToList' => [ 'base' => NULL, 'refs' => [ 'TestInvokeAuthorizerRequest$multiValueHeaders' => '<p>[Optional] The headers as a map from string to list of values to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, may be specified.</p>', 'TestInvokeAuthorizerResponse$authorization' => NULL, 'TestInvokeMethodRequest$multiValueHeaders' => '<p>The headers as a map from string to list of values to simulate an incoming invocation request.</p>', 'TestInvokeMethodResponse$multiValueHeaders' => '<p>The headers of the HTTP response as a map from string to list of values.</p>', ], ], 'MapOfStringToString' => [ 'base' => NULL, 'refs' => [ 'ApiKey$tags' => '<p>The collection of tags. Each tag element is associated with a given resource.</p>', 'CanarySettings$stageVariableOverrides' => '<p>Stage variables overridden for a canary release deployment, including new stage variables introduced in the canary. These stage variables are represented as a string-to-string map between stage variable names and their values.</p>', 'ClientCertificate$tags' => '<p>The collection of tags. Each tag element is associated with a given resource.</p>', 'CreateApiKeyRequest$tags' => '<p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>', 'CreateDeploymentRequest$variables' => '<p>A map that defines the stage variables for the <a>Stage</a> resource that is associated with the new deployment. Variable names can have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.</p>', 'CreateDomainNameRequest$tags' => '<p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>', 'CreateRestApiRequest$tags' => '<p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>', 'CreateStageRequest$variables' => '<p>A map that defines the stage variables for the new <a>Stage</a> resource. Variable names can have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.</p>', 'CreateStageRequest$tags' => '<p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>', 'CreateUsagePlanRequest$tags' => '<p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>', 'CreateVpcLinkRequest$tags' => '<p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>', 'DeploymentCanarySettings$stageVariableOverrides' => '<p>A stage variable overrides used for the canary release deployment. They can override existing stage variables or add new stage variables for the canary release deployment. These stage variables are represented as a string-to-string map between stage variable names and their values.</p>', 'DomainName$tags' => '<p>The collection of tags. Each tag element is associated with a given resource.</p>', 'GatewayResponse$responseParameters' => '<p>Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.</p>', 'GatewayResponse$responseTemplates' => '<p>Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.</p>', 'GenerateClientCertificateRequest$tags' => '<p>The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>', 'GetExportRequest$parameters' => '<p>A key-value map of query string parameters that specify properties of the export, depending on the requested <code>exportType</code>. For <code>exportType</code> <code>oas30</code> and <code>swagger</code>, any combination of the following parameters are supported: <code>extensions=\'integrations\'</code> or <code>extensions=\'apigateway\'</code> will export the API with x-amazon-apigateway-integration extensions. <code>extensions=\'authorizers\'</code> will export the API with x-amazon-apigateway-authorizer extensions. <code>postman</code> will export the API with Postman extensions, allowing for import to the Postman tool</p>', 'GetSdkRequest$parameters' => '<p>A string-to-string key-value map of query parameters <code>sdkType</code>-dependent properties of the SDK. For <code>sdkType</code> of <code>objectivec</code> or <code>swift</code>, a parameter named <code>classPrefix</code> is required. For <code>sdkType</code> of <code>android</code>, parameters named <code>groupId</code>, <code>artifactId</code>, <code>artifactVersion</code>, and <code>invokerPackage</code> are required. For <code>sdkType</code> of <code>java</code>, parameters named <code>serviceName</code> and <code>javaPackageName</code> are required. </p>', 'ImportRestApiRequest$parameters' => '<p>A key-value map of context-specific query string parameters specifying the behavior of different API importing operations. The following shows operation-specific parameters and their supported values.</p> <p> To exclude <a>DocumentationParts</a> from the import, set <code>parameters</code> as <code>ignore=documentation</code>.</p> <p> To configure the endpoint type, set <code>parameters</code> as <code>endpointConfigurationTypes=EDGE</code>, <code>endpointConfigurationTypes=REGIONAL</code>, or <code>endpointConfigurationTypes=PRIVATE</code>. The default endpoint type is <code>EDGE</code>.</p> <p> To handle imported <code>basepath</code>, set <code>parameters</code> as <code>basepath=ignore</code>, <code>basepath=prepend</code> or <code>basepath=split</code>.</p> <p>For example, the AWS CLI command to exclude documentation from the imported API is:</p> <pre><code>aws apigateway import-rest-api --parameters ignore=documentation --body \'file:///path/to/imported-api-body.json\'</code></pre> <p>The AWS CLI command to set the regional endpoint on the imported API is:</p> <pre><code>aws apigateway import-rest-api --parameters endpointConfigurationTypes=REGIONAL --body \'file:///path/to/imported-api-body.json\'</code></pre>', 'Integration$requestParameters' => '<p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>', 'Integration$requestTemplates' => '<p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>', 'IntegrationResponse$responseParameters' => '<p>A key-value map specifying response parameters that are passed to the method response from the back end. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> is a valid and unique response header name and <code>JSON-expression</code> is a valid JSON expression without the <code>$</code> prefix.</p>', 'IntegrationResponse$responseTemplates' => '<p>Specifies the templates used to transform the integration response body. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.</p>', 'Method$requestModels' => '<p>A key-value map specifying data schemas, represented by <a>Model</a> resources, (as the mapped value) of the request payloads of given content types (as the mapping key).</p>', 'MethodResponse$responseModels' => '<p>Specifies the <a>Model</a> resources used for the response\'s content-type. Response models are represented as a key/value map, with a content-type as the key and a <a>Model</a> name as the value.</p>', 'PutGatewayResponseRequest$responseParameters' => '<p><p>Response parameters (paths, query strings and headers) of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.</p></p>', 'PutGatewayResponseRequest$responseTemplates' => '<p><p>Response templates of the <a>GatewayResponse</a> as a string-to-string map of key-value pairs.</p></p>', 'PutIntegrationRequest$requestParameters' => '<p>A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of <code>method.request.{location}.{name}</code>, where <code>location</code> is <code>querystring</code>, <code>path</code>, or <code>header</code> and <code>name</code> must be a valid and unique method request parameter name.</p>', 'PutIntegrationRequest$requestTemplates' => '<p>Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.</p>', 'PutIntegrationResponseRequest$responseParameters' => '<p>A key-value map specifying response parameters that are passed to the method response from the back end. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header.{name}</code>, where <code>name</code> is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header.{name}</code> or <code>integration.response.body.{JSON-expression}</code>, where <code>name</code> must be a valid and unique response header name and <code>JSON-expression</code> a valid JSON expression without the <code>$</code> prefix.</p>', 'PutIntegrationResponseRequest$responseTemplates' => '<p>Specifies a put integration response\'s templates.</p>', 'PutMethodRequest$requestModels' => '<p>Specifies the <a>Model</a> resources used for the request\'s content type. Request models are represented as a key/value map, with a content type as the key and a <a>Model</a> name as the value.</p>', 'PutMethodResponseRequest$responseModels' => '<p>Specifies the <a>Model</a> resources used for the response\'s content type. Response models are represented as a key/value map, with a content type as the key and a <a>Model</a> name as the value.</p>', 'PutRestApiRequest$parameters' => '<p>Custom header parameters as part of the request. For example, to exclude <a>DocumentationParts</a> from an imported API, set <code>ignore=documentation</code> as a <code>parameters</code> value, as in the AWS CLI command of <code>aws apigateway import-rest-api --parameters ignore=documentation --body \'file:///path/to/imported-api-body.json\'</code>.</p>', 'RestApi$tags' => '<p>The collection of tags. Each tag element is associated with a given resource.</p>', 'Stage$variables' => '<p>A map that defines the stage variables for a <a>Stage</a> resource. Variable names can have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code>.</p>', 'Stage$tags' => '<p>The collection of tags. Each tag element is associated with a given resource.</p>', 'TagResourceRequest$tags' => '<p>[Required] The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with <code>aws:</code>. The tag value can be up to 256 characters.</p>', 'Tags$tags' => '<p>The collection of tags. Each tag element is associated with a given resource.</p>', 'TestInvokeAuthorizerRequest$headers' => '<p>[Required] A key-value map of headers to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, should be specified.</p>', 'TestInvokeAuthorizerRequest$stageVariables' => '<p>A key-value map of stage variables to simulate an invocation on a deployed <a>Stage</a>.</p>', 'TestInvokeAuthorizerRequest$additionalContext' => '<p>[Optional] A key-value map of additional context variables.</p>', 'TestInvokeAuthorizerResponse$claims' => '<p>The <a href="https://openid.net/specs/openid-connect-core-1_0.html#StandardClaims">open identity claims</a>, with any supported custom attributes, returned from the Cognito Your User Pool configured for the API.</p>', 'TestInvokeMethodRequest$headers' => '<p>A key-value map of headers to simulate an incoming invocation request.</p>', 'TestInvokeMethodRequest$stageVariables' => '<p>A key-value map of stage variables to simulate an invocation on a deployed <a>Stage</a>.</p>', 'TestInvokeMethodResponse$headers' => '<p>The headers of the HTTP response.</p>', 'UsagePlan$tags' => '<p>The collection of tags. Each tag element is associated with a given resource.</p>', 'VpcLink$tags' => '<p>The collection of tags. Each tag element is associated with a given resource.</p>', ], ], 'Method' => [ 'base' => '<p> Represents a client-facing interface by which the client calls the API to access back-end resources. A <b>Method</b> resource is integrated with an <a>Integration</a> resource. Both consist of a request and one or more responses. The method request takes the client input that is passed to the back end through the integration request. A method response returns the output from the back end to the client through an integration response. A method request is embodied in a <b>Method</b> resource, whereas an integration request is embodied in an <a>Integration</a> resource. On the other hand, a method response is represented by a <a>MethodResponse</a> resource, whereas an integration response is represented by an <a>IntegrationResponse</a> resource. </p> <div class="remarks"> <p/> <h4>Example: Retrive the GET method on a specified resource</h4> <h5>Request</h5> <p>The following example request retrieves the information about the GET method on an API resource (<code>3kzxbg5sa2</code>) of an API (<code>fugvjdxtri</code>). </p> <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com X-Amz-Date: 20160603T210259Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160603/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre> <h5>Response</h5> <p>The successful response returns a <code>200 OK</code> status code and a payload similar to the following:</p> <pre><code>{ "_links": { "curies": [ { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html", "name": "integration", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html", "name": "integrationresponse", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html", "name": "method", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html", "name": "methodresponse", "templated": true } ], "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET", "name": "GET", "title": "GET" }, "integration:put": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration" }, "method:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET" }, "method:integration": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration" }, "method:responses": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200", "name": "200", "title": "200" }, "method:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET" }, "methodresponse:put": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}", "templated": true } }, "apiKeyRequired": true, "authorizationType": "NONE", "httpMethod": "GET", "_embedded": { "method:integration": { "_links": { "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration" }, "integration:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration" }, "integration:responses": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200", "name": "200", "title": "200" }, "integration:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration" }, "integrationresponse:put": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}", "templated": true } }, "cacheKeyParameters": [], "cacheNamespace": "3kzxbg5sa2", "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole", "httpMethod": "POST", "passthroughBehavior": "WHEN_NO_MATCH", "requestParameters": { "integration.request.header.Content-Type": "\'application/x-amz-json-1.1\'" }, "requestTemplates": { "application/json": "{\\n}" }, "type": "AWS", "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams", "_embedded": { "integration:responses": { "_links": { "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200", "name": "200", "title": "200" }, "integrationresponse:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200" }, "integrationresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200" } }, "responseParameters": { "method.response.header.Content-Type": "\'application/xml\'" }, "responseTemplates": { "application/json": "$util.urlDecode(\\"%3CkinesisStreams%3E%23foreach(%24stream%20in%20%24input.path(%27%24.StreamNames%27))%3Cstream%3E%3Cname%3E%24stream%3C%2Fname%3E%3C%2Fstream%3E%23end%3C%2FkinesisStreams%3E\\")" }, "statusCode": "200" } } }, "method:responses": { "_links": { "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200", "name": "200", "title": "200" }, "methodresponse:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200" }, "methodresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200" } }, "responseModels": { "application/json": "Empty" }, "responseParameters": { "method.response.header.Content-Type": false }, "statusCode": "200" } } }</code></pre> <p>In the example above, the response template for the <code>200 OK</code> response maps the JSON output from the <code>ListStreams</code> action in the back end to an XML output. The mapping template is URL-encoded as <code>%3CkinesisStreams%3E%23foreach(%24stream%20in%20%24input.path(%27%24.StreamNames%27))%3Cstream%3E%3Cname%3E%24stream%3C%2Fname%3E%3C%2Fstream%3E%23end%3C%2FkinesisStreams%3E</code> and the output is decoded using the <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#util-templat-reference">$util.urlDecode()</a> helper function.</p> </div> <div class="seeAlso"> <a>MethodResponse</a>, <a>Integration</a>, <a>IntegrationResponse</a>, <a>Resource</a>, <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-method-settings.html">Set up an API\'s method</a> </div>', 'refs' => [ 'MapOfMethod$value' => NULL, ], ], 'MethodResponse' => [ 'base' => '<p>Represents a method response of a given HTTP status code returned to the client. The method response is passed from the back end through the associated integration response that can be transformed using a mapping template. </p> <div class="remarks"> <p/> <h4>Example: A <b>MethodResponse</b> instance of an API</h4> <h5>Request</h5> <p>The example request retrieves a <b>MethodResponse</b> of the 200 status code.</p> <pre><code>GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200 HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com X-Amz-Date: 20160603T222952Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160603/us-east-1/apigateway/aws4_request, SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}</code></pre> <h5>Response</h5> <p>The successful response returns <code>200 OK</code> status and a payload as follows:</p> <pre><code>{ "_links": { "curies": { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html", "name": "methodresponse", "templated": true }, "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200", "title": "200" }, "methodresponse:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200" }, "methodresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200" } }, "responseModels": { "application/json": "Empty" }, "responseParameters": { "method.response.header.Content-Type": false }, "statusCode": "200" }</code></pre> <p/> </div> <div class="seeAlso"> <a>Method</a>, <a>IntegrationResponse</a>, <a>Integration</a> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Creating an API</a> </div>', 'refs' => [ 'MapOfMethodResponse$value' => NULL, ], ], 'MethodSetting' => [ 'base' => '<p>Specifies the method setting properties.</p>', 'refs' => [ 'MapOfMethodSettings$value' => NULL, ], ], 'MethodSnapshot' => [ 'base' => '<p>Represents a summary of a <a>Method</a> resource, given a particular date and time.</p>', 'refs' => [ 'MapOfMethodSnapshot$value' => NULL, ], ], 'Model' => [ 'base' => '<p>Represents the data structure of a method\'s request or response payload.</p> <div class="remarks"> <p>A request model defines the data structure of the client-supplied request payload. A response model defines the data structure of the response payload returned by the back end. Although not required, models are useful for mapping payloads between the front end and back end.</p> <p>A model is used for generating an API\'s SDK, validating the input request body, and creating a skeletal mapping template.</p> </div> <div class="seeAlso"> <a>Method</a>, <a>MethodResponse</a>, <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/models-mappings.html">Models and Mappings</a> </div>', 'refs' => [ 'ListOfModel$member' => NULL, ], ], 'Models' => [ 'base' => '<p>Represents a collection of <a>Model</a> resources.</p> <div class="seeAlso"> <a>Method</a>, <a>MethodResponse</a>, <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/models-mappings.html">Models and Mappings</a> </div>', 'refs' => [], ], 'NotFoundException' => [ 'base' => '<p>The requested resource is not found. Make sure that the request URI is correct.</p>', 'refs' => [], ], 'NullableBoolean' => [ 'base' => NULL, 'refs' => [ 'CreateDeploymentRequest$cacheClusterEnabled' => '<p>Enables a cache cluster for the <a>Stage</a> resource specified in the input.</p>', 'CreateDeploymentRequest$tracingEnabled' => '<p>Specifies whether active tracing with X-ray is enabled for the <a>Stage</a>.</p>', 'GetApiKeyRequest$includeValue' => '<p>A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains the key value.</p>', 'GetApiKeysRequest$includeValues' => '<p>A boolean flag to specify whether (<code>true</code>) or not (<code>false</code>) the result contains key values.</p>', 'MapOfStringToBoolean$value' => NULL, 'Method$apiKeyRequired' => '<p>A boolean flag specifying whether a valid <a>ApiKey</a> is required to invoke this method.</p>', ], ], 'NullableInteger' => [ 'base' => NULL, 'refs' => [ 'Authorizer$authorizerResultTtlInSeconds' => '<p>The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.</p>', 'CreateAuthorizerRequest$authorizerResultTtlInSeconds' => '<p>The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour.</p>', 'CreateRestApiRequest$minimumCompressionSize' => '<p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>', 'GetApiKeysRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetAuthorizersRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetBasePathMappingsRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetClientCertificatesRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetDeploymentsRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetDocumentationPartsRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetDocumentationVersionsRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetDomainNamesRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetGatewayResponsesRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500. The <a>GatewayResponses</a> collection does not support pagination and the limit does not apply here.</p>', 'GetModelsRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetRequestValidatorsRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetResourcesRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetRestApisRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetSdkTypesRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetTagsRequest$limit' => '<p>(Not currently supported) The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetUsagePlanKeysRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetUsagePlansRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetUsageRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'GetVpcLinksRequest$limit' => '<p>The maximum number of returned results per page. The default value is 25 and the maximum value is 500.</p>', 'PutIntegrationRequest$timeoutInMillis' => '<p>Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.</p>', 'RestApi$minimumCompressionSize' => '<p>A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size.</p>', ], ], 'Op' => [ 'base' => NULL, 'refs' => [ 'PatchOperation$op' => '<p> An update operation to be performed with this PATCH request. The valid value can be <code>add</code>, <code>remove</code>, <code>replace</code> or <code>copy</code>. Not all valid operations are supported for a given resource. Support of the operations depends on specific operational contexts. Attempts to apply an unsupported operation on a resource will return an error message.</p>', ], ], 'PatchOperation' => [ 'base' => 'A single patch operation to apply to the specified resource. Please refer to http://tools.ietf.org/html/rfc6902#section-4 for an explanation of how each operation is used.', 'refs' => [ 'ListOfPatchOperation$member' => NULL, ], ], 'PathToMapOfMethodSnapshot' => [ 'base' => NULL, 'refs' => [ 'Deployment$apiSummary' => '<p>A summary of the <a>RestApi</a> at the date and time that the deployment resource was created.</p>', ], ], 'ProviderARN' => [ 'base' => NULL, 'refs' => [ 'ListOfARNs$member' => NULL, ], ], 'PutGatewayResponseRequest' => [ 'base' => '<p>Creates a customization of a <a>GatewayResponse</a> of a specified response type and status code on the given <a>RestApi</a>.</p>', 'refs' => [], ], 'PutIntegrationRequest' => [ 'base' => '<p>Sets up a method\'s integration.</p>', 'refs' => [], ], 'PutIntegrationResponseRequest' => [ 'base' => '<p>Represents a put integration response request.</p>', 'refs' => [], ], 'PutMethodRequest' => [ 'base' => '<p>Request to add a method to an existing <a>Resource</a> resource.</p>', 'refs' => [], ], 'PutMethodResponseRequest' => [ 'base' => '<p>Request to add a <a>MethodResponse</a> to an existing <a>Method</a> resource.</p>', 'refs' => [], ], 'PutMode' => [ 'base' => NULL, 'refs' => [ 'ImportDocumentationPartsRequest$mode' => '<p>A query parameter to indicate whether to overwrite (<code>OVERWRITE</code>) any existing <a>DocumentationParts</a> definition or to merge (<code>MERGE</code>) the new definition into the existing one. The default value is <code>MERGE</code>.</p>', 'PutRestApiRequest$mode' => '<p>The <code>mode</code> query parameter to specify the update mode. Valid values are "merge" and "overwrite". By default, the update mode is "merge".</p>', ], ], 'PutRestApiRequest' => [ 'base' => '<p>A PUT request to update an existing API, with external API definitions specified as the request body.</p>', 'refs' => [], ], 'QuotaPeriodType' => [ 'base' => NULL, 'refs' => [ 'QuotaSettings$period' => '<p>The time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".</p>', ], ], 'QuotaSettings' => [ 'base' => '<p>Quotas configured for a usage plan.</p>', 'refs' => [ 'CreateUsagePlanRequest$quota' => '<p>The quota of the usage plan.</p>', 'UsagePlan$quota' => '<p>The maximum number of permitted requests per a given unit time interval.</p>', ], ], 'RequestValidator' => [ 'base' => '<p>A set of validation rules for incoming <a>Method</a> requests.</p> <div class="remarks"> <p>In OpenAPI, a <a>RequestValidator</a> of an API is defined by the <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions.html#api-gateway-swagger-extensions-request-validators.requestValidator.html">x-amazon-apigateway-request-validators.requestValidator</a> object. It the referenced using the <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions.html#api-gateway-swagger-extensions-request-validator">x-amazon-apigateway-request-validator</a> property.</p> </div> <div class="seeAlso"><a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-method-request-validation.html">Enable Basic Request Validation in API Gateway</a></div>', 'refs' => [ 'ListOfRequestValidator$member' => NULL, ], ], 'RequestValidators' => [ 'base' => '<p>A collection of <a>RequestValidator</a> resources of a given <a>RestApi</a>.</p> <div class="remarks"> <p>In OpenAPI, the <a>RequestValidators</a> of an API is defined by the <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions.html#api-gateway-swagger-extensions-request-validators.html">x-amazon-apigateway-request-validators</a> extension.</p> </div> <div class="seeAlso"><a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-method-request-validation.html">Enable Basic Request Validation in API Gateway</a></div>', 'refs' => [], ], 'Resource' => [ 'base' => '<p>Represents an API resource.</p> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Create an API</a> </div>', 'refs' => [ 'ListOfResource$member' => NULL, ], ], 'Resources' => [ 'base' => '<p>Represents a collection of <a>Resource</a> resources.</p> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Create an API</a> </div>', 'refs' => [], ], 'RestApi' => [ 'base' => '<p>Represents a REST API.</p> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Create an API</a> </div>', 'refs' => [ 'ListOfRestApi$member' => NULL, ], ], 'RestApis' => [ 'base' => '<p>Contains references to your APIs and links that guide you in how to interact with your collection. A collection offers a paginated view of your APIs.</p> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html">Create an API</a> </div>', 'refs' => [], ], 'SdkConfigurationProperty' => [ 'base' => '<p>A configuration property of an SDK type.</p>', 'refs' => [ 'ListOfSdkConfigurationProperty$member' => NULL, ], ], 'SdkResponse' => [ 'base' => '<p>The binary blob response to <a>GetSdk</a>, which contains the generated SDK.</p>', 'refs' => [], ], 'SdkType' => [ 'base' => '<p>A type of SDK that API Gateway can generate.</p>', 'refs' => [ 'ListOfSdkType$member' => NULL, ], ], 'SdkTypes' => [ 'base' => '<p>The collection of <a>SdkType</a> instances.</p>', 'refs' => [], ], 'SecurityPolicy' => [ 'base' => NULL, 'refs' => [ 'CreateDomainNameRequest$securityPolicy' => '<p>The Transport Layer Security (TLS) version + cipher suite for this <a>DomainName</a>. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.</p>', 'DomainName$securityPolicy' => '<p>The Transport Layer Security (TLS) version + cipher suite for this <a>DomainName</a>. The valid values are <code>TLS_1_0</code> and <code>TLS_1_2</code>.</p>', ], ], 'ServiceUnavailableException' => [ 'base' => '<p>The requested service is not available. For details see the accompanying error message. Retry after the specified time period.</p>', 'refs' => [], ], 'Stage' => [ 'base' => '<p>Represents a unique identifier for a version of a deployed <a>RestApi</a> that is callable by users.</p> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-deploy-api.html">Deploy an API</a> </div>', 'refs' => [ 'ListOfStage$member' => NULL, ], ], 'StageKey' => [ 'base' => '<p>A reference to a unique stage identified in the format <code>{restApiId}/{stage}</code>.</p>', 'refs' => [ 'ListOfStageKeys$member' => NULL, ], ], 'Stages' => [ 'base' => '<p>A list of <a>Stage</a> resources that are associated with the <a>ApiKey</a> resource.</p> <div class="seeAlso"><a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/stages.html">Deploying API in Stages</a></div>', 'refs' => [], ], 'StatusCode' => [ 'base' => '<p>The status code.</p>', 'refs' => [ 'DeleteIntegrationResponseRequest$statusCode' => '<p>[Required] Specifies a delete integration response request\'s status code.</p>', 'DeleteMethodResponseRequest$statusCode' => '<p>[Required] The status code identifier for the <a>MethodResponse</a> resource.</p>', 'GatewayResponse$statusCode' => '<p>The HTTP status code for this <a>GatewayResponse</a>.</p>', 'GetIntegrationResponseRequest$statusCode' => '<p>[Required] Specifies a get integration response request\'s status code.</p>', 'GetMethodResponseRequest$statusCode' => '<p>[Required] The status code for the <a>MethodResponse</a> resource.</p>', 'IntegrationResponse$statusCode' => '<p>Specifies the status code that is used to map the integration response to an existing <a>MethodResponse</a>.</p>', 'MethodResponse$statusCode' => '<p>The method response\'s status code.</p>', 'PutGatewayResponseRequest$statusCode' => 'The HTTP status code of the <a>GatewayResponse</a>.', 'PutIntegrationResponseRequest$statusCode' => '<p>[Required] Specifies the status code that is used to map the integration response to an existing <a>MethodResponse</a>.</p>', 'PutMethodResponseRequest$statusCode' => '<p>[Required] The method response\'s status code.</p>', 'UpdateIntegrationResponseRequest$statusCode' => '<p>[Required] Specifies an update integration response request\'s status code.</p>', 'UpdateMethodResponseRequest$statusCode' => '<p>[Required] The status code for the <a>MethodResponse</a> resource.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessLogSettings$format' => '<p>A single line format of the access logs of data, as specified by selected <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#context-variable-reference">$context variables</a>. The format must include at least <code>$context.requestId</code>.</p>', 'AccessLogSettings$destinationArn' => '<p>The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with <code>amazon-apigateway-</code>.</p>', 'Account$cloudwatchRoleArn' => '<p>The ARN of an Amazon CloudWatch role for the current <a>Account</a>. </p>', 'Account$apiKeyVersion' => '<p>The version of the API keys used for the account.</p>', 'ApiKey$id' => '<p>The identifier of the API Key.</p>', 'ApiKey$value' => '<p>The value of the API Key.</p>', 'ApiKey$name' => '<p>The name of the API Key.</p>', 'ApiKey$customerId' => '<p>An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.</p>', 'ApiKey$description' => '<p>The description of the API Key.</p>', 'ApiKeys$position' => NULL, 'ApiStage$apiId' => '<p>API Id of the associated API stage in a usage plan.</p>', 'ApiStage$stage' => '<p>API stage name of the associated API stage in a usage plan.</p>', 'Authorizer$id' => '<p>The identifier for the authorizer resource.</p>', 'Authorizer$name' => '<p>[Required] The name of the authorizer.</p>', 'Authorizer$authType' => '<p>Optional customer-defined field, used in OpenAPI imports and exports without functional impact.</p>', 'Authorizer$authorizerUri' => '<p>Specifies the authorizer\'s Uniform Resource Identifier (URI). For <code>TOKEN</code> or <code>REQUEST</code> authorizers, this must be a well-formed Lambda function URI, for example, <code>arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations</code>. In general, the URI has this form <code>arn:aws:apigateway:{region}:lambda:path/{service_api}</code>, where <code>{region}</code> is the same as the region hosting the Lambda function, <code>path</code> indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial <code>/</code>. For Lambda functions, this is usually of the form <code>/2015-03-31/functions/[FunctionARN]/invocations</code>.</p>', 'Authorizer$authorizerCredentials' => '<p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role\'s Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.</p>', 'Authorizer$identitySource' => '<p>The identity source for which authorization is requested. <ul><li>For a <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is <code>Auth</code>, the header mapping expression is <code>method.request.header.Auth</code>.</li><li>For the <code>REQUEST</code> authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an <code>Auth</code> header, a <code>Name</code> query string parameter are defined as identity sources, this value is <code>method.request.header.Auth, method.request.querystring.Name</code>. These parameters will be used to derive the authorization caching key and to perform runtime validation of the <code>REQUEST</code> authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.</li></ul></p>', 'Authorizer$identityValidationExpression' => '<p>A validation expression for the incoming identity token. For <code>TOKEN</code> authorizers, this value is a regular expression. For <code>COGNITO_USER_POOLS</code> authorizers, API Gateway will match the <code>aud</code> field of the incoming token from the client against the specified regular expression. It will invoke the authorizer\'s Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the <code>REQUEST</code> authorizer.</p>', 'Authorizers$position' => NULL, 'BadRequestException$message' => NULL, 'BasePathMapping$basePath' => '<p>The base path name that callers of the API must provide as part of the URL after the domain name.</p>', 'BasePathMapping$restApiId' => '<p>The string identifier of the associated <a>RestApi</a>.</p>', 'BasePathMapping$stage' => '<p>The name of the associated stage.</p>', 'BasePathMappings$position' => NULL, 'CanarySettings$deploymentId' => '<p>The ID of the canary deployment.</p>', 'ClientCertificate$clientCertificateId' => '<p>The identifier of the client certificate.</p>', 'ClientCertificate$description' => '<p>The description of the client certificate.</p>', 'ClientCertificate$pemEncodedCertificate' => '<p>The PEM-encoded public key of the client certificate, which can be used to configure certificate authentication in the integration endpoint .</p>', 'ClientCertificates$position' => NULL, 'ConflictException$message' => NULL, 'CreateApiKeyRequest$name' => '<p>The name of the <a>ApiKey</a>.</p>', 'CreateApiKeyRequest$description' => '<p>The description of the <a>ApiKey</a>.</p>', 'CreateApiKeyRequest$value' => '<p>Specifies a value of the API key.</p>', 'CreateApiKeyRequest$customerId' => '<p>An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.</p>', 'CreateAuthorizerRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'CreateAuthorizerRequest$name' => '<p>[Required] The name of the authorizer.</p>', 'CreateAuthorizerRequest$authType' => '<p>Optional customer-defined field, used in OpenAPI imports and exports without functional impact.</p>', 'CreateAuthorizerRequest$authorizerUri' => '<p>Specifies the authorizer\'s Uniform Resource Identifier (URI). For <code>TOKEN</code> or <code>REQUEST</code> authorizers, this must be a well-formed Lambda function URI, for example, <code>arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations</code>. In general, the URI has this form <code>arn:aws:apigateway:{region}:lambda:path/{service_api}</code>, where <code>{region}</code> is the same as the region hosting the Lambda function, <code>path</code> indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial <code>/</code>. For Lambda functions, this is usually of the form <code>/2015-03-31/functions/[FunctionARN]/invocations</code>.</p>', 'CreateAuthorizerRequest$authorizerCredentials' => '<p>Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role\'s Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.</p>', 'CreateAuthorizerRequest$identitySource' => '<p>The identity source for which authorization is requested. <ul><li>For a <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is <code>Auth</code>, the header mapping expression is <code>method.request.header.Auth</code>.</li><li>For the <code>REQUEST</code> authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an <code>Auth</code> header, a <code>Name</code> query string parameter are defined as identity sources, this value is <code>method.request.header.Auth, method.request.querystring.Name</code>. These parameters will be used to derive the authorization caching key and to perform runtime validation of the <code>REQUEST</code> authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional.</li></ul></p>', 'CreateAuthorizerRequest$identityValidationExpression' => '<p>A validation expression for the incoming identity token. For <code>TOKEN</code> authorizers, this value is a regular expression. For <code>COGNITO_USER_POOLS</code> authorizers, API Gateway will match the <code>aud</code> field of the incoming token from the client against the specified regular expression. It will invoke the authorizer\'s Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the <code>REQUEST</code> authorizer.</p>', 'CreateBasePathMappingRequest$domainName' => '<p>[Required] The domain name of the <a>BasePathMapping</a> resource to create.</p>', 'CreateBasePathMappingRequest$basePath' => '<p>The base path name that callers of the API must provide as part of the URL after the domain name. This value must be unique for all of the mappings across a single API. Specify \'(none)\' if you do not want callers to specify a base path name after the domain name.</p>', 'CreateBasePathMappingRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'CreateBasePathMappingRequest$stage' => '<p>The name of the API\'s stage that you want to use for this mapping. Specify \'(none)\' if you want callers to explicitly specify the stage name after any base path name.</p>', 'CreateDeploymentRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'CreateDeploymentRequest$stageName' => '<p>The name of the <a>Stage</a> resource for the <a>Deployment</a> resource to create.</p>', 'CreateDeploymentRequest$stageDescription' => '<p>The description of the <a>Stage</a> resource for the <a>Deployment</a> resource to create.</p>', 'CreateDeploymentRequest$description' => '<p>The description for the <a>Deployment</a> resource to create.</p>', 'CreateDocumentationPartRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'CreateDocumentationPartRequest$properties' => '<p>[Required] The new documentation content map of the targeted API entity. Enclosed key-value pairs are API-specific, but only OpenAPI-compliant key-value pairs can be exported and, hence, published.</p>', 'CreateDocumentationVersionRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'CreateDocumentationVersionRequest$documentationVersion' => '<p>[Required] The version identifier of the new snapshot.</p>', 'CreateDocumentationVersionRequest$stageName' => '<p>The stage name to be associated with the new documentation snapshot.</p>', 'CreateDocumentationVersionRequest$description' => '<p>A description about the new documentation snapshot.</p>', 'CreateDomainNameRequest$domainName' => '<p>[Required] The name of the <a>DomainName</a> resource.</p>', 'CreateDomainNameRequest$certificateName' => '<p>The user-friendly name of the certificate that will be used by edge-optimized endpoint for this domain name.</p>', 'CreateDomainNameRequest$certificateBody' => '<p>[Deprecated] The body of the server certificate that will be used by edge-optimized endpoint for this domain name provided by your certificate authority.</p>', 'CreateDomainNameRequest$certificatePrivateKey' => '<p>[Deprecated] Your edge-optimized endpoint\'s domain name certificate\'s private key.</p>', 'CreateDomainNameRequest$certificateChain' => '<p>[Deprecated] The intermediate certificates and optionally the root certificate, one after the other without any blank lines, used by an edge-optimized endpoint for this domain name. If you include the root certificate, your certificate chain must start with intermediate certificates and end with the root certificate. Use the intermediate certificates that were provided by your certificate authority. Do not include any intermediaries that are not in the chain of trust path.</p>', 'CreateDomainNameRequest$certificateArn' => '<p>The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>', 'CreateDomainNameRequest$regionalCertificateName' => '<p>The user-friendly name of the certificate that will be used by regional endpoint for this domain name.</p>', 'CreateDomainNameRequest$regionalCertificateArn' => '<p>The reference to an AWS-managed certificate that will be used by regional endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>', 'CreateModelRequest$restApiId' => '<p>[Required] The <a>RestApi</a> identifier under which the <a>Model</a> will be created.</p>', 'CreateModelRequest$name' => '<p>[Required] The name of the model. Must be alphanumeric.</p>', 'CreateModelRequest$description' => '<p>The description of the model.</p>', 'CreateModelRequest$schema' => '<p>The schema for the model. For <code>application/json</code> models, this should be <a href="https://tools.ietf.org/html/draft-zyp-json-schema-04" target="_blank">JSON schema draft 4</a> model.</p>', 'CreateModelRequest$contentType' => '<p>[Required] The content-type for the model.</p>', 'CreateRequestValidatorRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'CreateRequestValidatorRequest$name' => '<p>The name of the to-be-created <a>RequestValidator</a>.</p>', 'CreateResourceRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'CreateResourceRequest$parentId' => '<p>[Required] The parent resource\'s identifier.</p>', 'CreateResourceRequest$pathPart' => '<p>The last path segment for this resource.</p>', 'CreateRestApiRequest$name' => '<p>[Required] The name of the <a>RestApi</a>.</p>', 'CreateRestApiRequest$description' => '<p>The description of the <a>RestApi</a>.</p>', 'CreateRestApiRequest$version' => '<p>A version identifier for the API.</p>', 'CreateRestApiRequest$cloneFrom' => '<p>The ID of the <a>RestApi</a> that you want to clone from.</p>', 'CreateRestApiRequest$policy' => 'A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.', 'CreateStageRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'CreateStageRequest$stageName' => '<p>[Required] The name for the <a>Stage</a> resource. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>', 'CreateStageRequest$deploymentId' => '<p>[Required] The identifier of the <a>Deployment</a> resource for the <a>Stage</a> resource.</p>', 'CreateStageRequest$description' => '<p>The description of the <a>Stage</a> resource.</p>', 'CreateStageRequest$documentationVersion' => '<p>The version of the associated API documentation.</p>', 'CreateUsagePlanKeyRequest$usagePlanId' => '<p>[Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-created <a>UsagePlanKey</a> resource representing a plan customer.</p>', 'CreateUsagePlanKeyRequest$keyId' => '<p>[Required] The identifier of a <a>UsagePlanKey</a> resource for a plan customer.</p>', 'CreateUsagePlanKeyRequest$keyType' => '<p>[Required] The type of a <a>UsagePlanKey</a> resource for a plan customer.</p>', 'CreateUsagePlanRequest$name' => '<p>[Required] The name of the usage plan.</p>', 'CreateUsagePlanRequest$description' => '<p>The description of the usage plan.</p>', 'CreateVpcLinkRequest$name' => '<p>[Required] The name used to label and identify the VPC link.</p>', 'CreateVpcLinkRequest$description' => '<p>The description of the VPC link.</p>', 'DeleteApiKeyRequest$apiKey' => '<p>[Required] The identifier of the <a>ApiKey</a> resource to be deleted.</p>', 'DeleteAuthorizerRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'DeleteAuthorizerRequest$authorizerId' => '<p>[Required] The identifier of the <a>Authorizer</a> resource.</p>', 'DeleteBasePathMappingRequest$domainName' => '<p>[Required] The domain name of the <a>BasePathMapping</a> resource to delete.</p>', 'DeleteBasePathMappingRequest$basePath' => '<p>[Required] The base path name of the <a>BasePathMapping</a> resource to delete.</p> <p>To specify an empty base path, set this parameter to <code>\'(none)\'</code>.</p>', 'DeleteClientCertificateRequest$clientCertificateId' => '<p>[Required] The identifier of the <a>ClientCertificate</a> resource to be deleted.</p>', 'DeleteDeploymentRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'DeleteDeploymentRequest$deploymentId' => '<p>[Required] The identifier of the <a>Deployment</a> resource to delete.</p>', 'DeleteDocumentationPartRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'DeleteDocumentationPartRequest$documentationPartId' => '<p>[Required] The identifier of the to-be-deleted documentation part.</p>', 'DeleteDocumentationVersionRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'DeleteDocumentationVersionRequest$documentationVersion' => '<p>[Required] The version identifier of a to-be-deleted documentation snapshot.</p>', 'DeleteDomainNameRequest$domainName' => '<p>[Required] The name of the <a>DomainName</a> resource to be deleted.</p>', 'DeleteGatewayResponseRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'DeleteIntegrationRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'DeleteIntegrationRequest$resourceId' => '<p>[Required] Specifies a delete integration request\'s resource identifier.</p>', 'DeleteIntegrationRequest$httpMethod' => '<p>[Required] Specifies a delete integration request\'s HTTP method.</p>', 'DeleteIntegrationResponseRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'DeleteIntegrationResponseRequest$resourceId' => '<p>[Required] Specifies a delete integration response request\'s resource identifier.</p>', 'DeleteIntegrationResponseRequest$httpMethod' => '<p>[Required] Specifies a delete integration response request\'s HTTP method.</p>', 'DeleteMethodRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'DeleteMethodRequest$resourceId' => '<p>[Required] The <a>Resource</a> identifier for the <a>Method</a> resource.</p>', 'DeleteMethodRequest$httpMethod' => '<p>[Required] The HTTP verb of the <a>Method</a> resource.</p>', 'DeleteMethodResponseRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'DeleteMethodResponseRequest$resourceId' => '<p>[Required] The <a>Resource</a> identifier for the <a>MethodResponse</a> resource.</p>', 'DeleteMethodResponseRequest$httpMethod' => '<p>[Required] The HTTP verb of the <a>Method</a> resource.</p>', 'DeleteModelRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'DeleteModelRequest$modelName' => '<p>[Required] The name of the model to delete.</p>', 'DeleteRequestValidatorRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'DeleteRequestValidatorRequest$requestValidatorId' => '<p>[Required] The identifier of the <a>RequestValidator</a> to be deleted.</p>', 'DeleteResourceRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'DeleteResourceRequest$resourceId' => '<p>[Required] The identifier of the <a>Resource</a> resource.</p>', 'DeleteRestApiRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'DeleteStageRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'DeleteStageRequest$stageName' => '<p>[Required] The name of the <a>Stage</a> resource to delete.</p>', 'DeleteUsagePlanKeyRequest$usagePlanId' => '<p>[Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-deleted <a>UsagePlanKey</a> resource representing a plan customer.</p>', 'DeleteUsagePlanKeyRequest$keyId' => '<p>[Required] The Id of the <a>UsagePlanKey</a> resource to be deleted.</p>', 'DeleteUsagePlanRequest$usagePlanId' => '<p>[Required] The Id of the to-be-deleted usage plan.</p>', 'DeleteVpcLinkRequest$vpcLinkId' => '<p>[Required] The identifier of the <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.</p>', 'Deployment$id' => '<p>The identifier for the deployment resource.</p>', 'Deployment$description' => '<p>The description for the deployment resource.</p>', 'Deployments$position' => NULL, 'DocumentationPart$id' => '<p>The <a>DocumentationPart</a> identifier, generated by API Gateway when the <code>DocumentationPart</code> is created.</p>', 'DocumentationPart$properties' => '<p>A content map of API-specific key-value pairs describing the targeted API entity. The map must be encoded as a JSON string, e.g., <code>"{ \\"description\\": \\"The API does ...\\" }"</code>. Only OpenAPI-compliant documentation-related fields from the <literal>properties</literal> map are exported and, hence, published as part of the API entity definitions, while the original documentation parts are exported in a OpenAPI extension of <code>x-amazon-apigateway-documentation</code>.</p>', 'DocumentationPartLocation$path' => '<p>The URL path of the target. It is a valid field for the API entity types of <code>RESOURCE</code>, <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>/</code> for the root resource. When an applicable child entity inherits the content of another entity of the same type with more general specifications of the other <code>location</code> attributes, the child entity\'s <code>path</code> attribute must match that of the parent entity as a prefix.</p>', 'DocumentationPartLocation$method' => '<p>The HTTP verb of a method. It is a valid field for the API entity types of <code>METHOD</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code>, <code>RESPONSE</code>, <code>RESPONSE_HEADER</code>, and <code>RESPONSE_BODY</code>. The default value is <code>*</code> for any method. When an applicable child entity inherits the content of an entity of the same type with more general specifications of the other <code>location</code> attributes, the child entity\'s <code>method</code> attribute must match that of the parent entity exactly.</p>', 'DocumentationPartLocation$name' => '<p>The name of the targeted API entity. It is a valid and required field for the API entity types of <code>AUTHORIZER</code>, <code>MODEL</code>, <code>PATH_PARAMETER</code>, <code>QUERY_PARAMETER</code>, <code>REQUEST_HEADER</code>, <code>REQUEST_BODY</code> and <code>RESPONSE_HEADER</code>. It is an invalid field for any other entity type.</p>', 'DocumentationParts$position' => NULL, 'DocumentationVersion$version' => '<p>The version identifier of the API documentation snapshot.</p>', 'DocumentationVersion$description' => '<p>The description of the API documentation snapshot.</p>', 'DocumentationVersions$position' => NULL, 'DomainName$domainName' => '<p>The custom domain name as an API host name, for example, <code>my-api.example.com</code>.</p>', 'DomainName$certificateName' => '<p>The name of the certificate that will be used by edge-optimized endpoint for this domain name.</p>', 'DomainName$certificateArn' => '<p>The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.</p>', 'DomainName$regionalDomainName' => '<p>The domain name associated with the regional endpoint for this custom domain name. You set up this association by adding a DNS record that points the custom domain name to this regional domain name. The regional domain name is returned by API Gateway when you create a regional endpoint.</p>', 'DomainName$regionalHostedZoneId' => '<p>The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>. </p>', 'DomainName$regionalCertificateName' => '<p>The name of the certificate that will be used for validating the regional domain name.</p>', 'DomainName$regionalCertificateArn' => '<p>The reference to an AWS-managed certificate that will be used for validating the regional domain name. AWS Certificate Manager is the only supported source.</p>', 'DomainName$distributionDomainName' => '<p>The domain name of the Amazon CloudFront distribution associated with this custom domain name for an edge-optimized endpoint. You set up this association when adding a DNS record pointing the custom domain name to this distribution name. For more information about CloudFront distributions, see the <a href="https://aws.amazon.com/documentation/cloudfront/" target="_blank">Amazon CloudFront documentation</a>.</p>', 'DomainName$distributionHostedZoneId' => '<p>The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized endpoint. The valid value is <code>Z2FDTNDATAQYW2</code> for all the regions. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html">Set up a Regional Custom Domain Name</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region">AWS Regions and Endpoints for API Gateway</a>. </p>', 'DomainName$domainNameStatusMessage' => '<p>An optional text message containing detailed information about status of the <a>DomainName</a> migration.</p>', 'DomainNames$position' => NULL, 'ExportResponse$contentType' => '<p>The content-type header value in the HTTP response. This will correspond to a valid \'accept\' type in the request.</p>', 'ExportResponse$contentDisposition' => '<p>The content-disposition header value in the HTTP response.</p>', 'FlushStageAuthorizersCacheRequest$restApiId' => '<p>The string identifier of the associated <a>RestApi</a>.</p>', 'FlushStageAuthorizersCacheRequest$stageName' => '<p>The name of the stage to flush.</p>', 'FlushStageCacheRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'FlushStageCacheRequest$stageName' => '<p>[Required] The name of the stage to flush its cache.</p>', 'GatewayResponses$position' => NULL, 'GenerateClientCertificateRequest$description' => '<p>The description of the <a>ClientCertificate</a>.</p>', 'GetApiKeyRequest$apiKey' => '<p>[Required] The identifier of the <a>ApiKey</a> resource.</p>', 'GetApiKeysRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetApiKeysRequest$nameQuery' => '<p>The name of queried API keys.</p>', 'GetApiKeysRequest$customerId' => '<p>The identifier of a customer in AWS Marketplace or an external system, such as a developer portal.</p>', 'GetAuthorizerRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'GetAuthorizerRequest$authorizerId' => '<p>[Required] The identifier of the <a>Authorizer</a> resource.</p>', 'GetAuthorizersRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'GetAuthorizersRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetBasePathMappingRequest$domainName' => '<p>[Required] The domain name of the <a>BasePathMapping</a> resource to be described.</p>', 'GetBasePathMappingRequest$basePath' => '<p>[Required] The base path name that callers of the API must provide as part of the URL after the domain name. This value must be unique for all of the mappings across a single API. Specify \'(none)\' if you do not want callers to specify any base path name after the domain name.</p>', 'GetBasePathMappingsRequest$domainName' => '<p>[Required] The domain name of a <a>BasePathMapping</a> resource.</p>', 'GetBasePathMappingsRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetClientCertificateRequest$clientCertificateId' => '<p>[Required] The identifier of the <a>ClientCertificate</a> resource to be described.</p>', 'GetClientCertificatesRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetDeploymentRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'GetDeploymentRequest$deploymentId' => '<p>[Required] The identifier of the <a>Deployment</a> resource to get information about.</p>', 'GetDeploymentsRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'GetDeploymentsRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetDocumentationPartRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'GetDocumentationPartRequest$documentationPartId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'GetDocumentationPartsRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'GetDocumentationPartsRequest$nameQuery' => '<p>The name of API entities of the to-be-retrieved documentation parts.</p>', 'GetDocumentationPartsRequest$path' => '<p>The path of API entities of the to-be-retrieved documentation parts.</p>', 'GetDocumentationPartsRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetDocumentationVersionRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'GetDocumentationVersionRequest$documentationVersion' => '<p>[Required] The version identifier of the to-be-retrieved documentation snapshot.</p>', 'GetDocumentationVersionsRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'GetDocumentationVersionsRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetDomainNameRequest$domainName' => '<p>[Required] The name of the <a>DomainName</a> resource.</p>', 'GetDomainNamesRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetExportRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'GetExportRequest$stageName' => '<p>[Required] The name of the <a>Stage</a> that will be exported.</p>', 'GetExportRequest$exportType' => '<p>[Required] The type of export. Acceptable values are \'oas30\' for OpenAPI 3.0.x and \'swagger\' for Swagger/OpenAPI 2.0.</p>', 'GetExportRequest$accepts' => '<p>The content-type of the export, for example <code>application/json</code>. Currently <code>application/json</code> and <code>application/yaml</code> are supported for <code>exportType</code> of<code>oas30</code> and <code>swagger</code>. This should be specified in the <code>Accept</code> header for direct API requests.</p>', 'GetGatewayResponseRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'GetGatewayResponsesRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'GetGatewayResponsesRequest$position' => '<p>The current pagination position in the paged result set. The <a>GatewayResponse</a> collection does not support pagination and the position does not apply here.</p>', 'GetIntegrationRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'GetIntegrationRequest$resourceId' => '<p>[Required] Specifies a get integration request\'s resource identifier</p>', 'GetIntegrationRequest$httpMethod' => '<p>[Required] Specifies a get integration request\'s HTTP method.</p>', 'GetIntegrationResponseRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'GetIntegrationResponseRequest$resourceId' => '<p>[Required] Specifies a get integration response request\'s resource identifier.</p>', 'GetIntegrationResponseRequest$httpMethod' => '<p>[Required] Specifies a get integration response request\'s HTTP method.</p>', 'GetMethodRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'GetMethodRequest$resourceId' => '<p>[Required] The <a>Resource</a> identifier for the <a>Method</a> resource.</p>', 'GetMethodRequest$httpMethod' => '<p>[Required] Specifies the method request\'s HTTP method type.</p>', 'GetMethodResponseRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'GetMethodResponseRequest$resourceId' => '<p>[Required] The <a>Resource</a> identifier for the <a>MethodResponse</a> resource.</p>', 'GetMethodResponseRequest$httpMethod' => '<p>[Required] The HTTP verb of the <a>Method</a> resource.</p>', 'GetModelRequest$restApiId' => '<p>[Required] The <a>RestApi</a> identifier under which the <a>Model</a> exists.</p>', 'GetModelRequest$modelName' => '<p>[Required] The name of the model as an identifier.</p>', 'GetModelTemplateRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'GetModelTemplateRequest$modelName' => '<p>[Required] The name of the model for which to generate a template.</p>', 'GetModelsRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'GetModelsRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetRequestValidatorRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'GetRequestValidatorRequest$requestValidatorId' => '<p>[Required] The identifier of the <a>RequestValidator</a> to be retrieved.</p>', 'GetRequestValidatorsRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'GetRequestValidatorsRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetResourceRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'GetResourceRequest$resourceId' => '<p>[Required] The identifier for the <a>Resource</a> resource.</p>', 'GetResourcesRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'GetResourcesRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetRestApiRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'GetRestApisRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetSdkRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'GetSdkRequest$stageName' => '<p>[Required] The name of the <a>Stage</a> that the SDK will use.</p>', 'GetSdkRequest$sdkType' => '<p>[Required] The language for the generated SDK. Currently <code>java</code>, <code>javascript</code>, <code>android</code>, <code>objectivec</code> (for iOS), <code>swift</code> (for iOS), and <code>ruby</code> are supported.</p>', 'GetSdkTypeRequest$id' => '<p>[Required] The identifier of the queried <a>SdkType</a> instance.</p>', 'GetSdkTypesRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetStageRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'GetStageRequest$stageName' => '<p>[Required] The name of the <a>Stage</a> resource to get information about.</p>', 'GetStagesRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'GetStagesRequest$deploymentId' => '<p>The stages\' deployment identifiers.</p>', 'GetTagsRequest$resourceArn' => '<p>[Required] The ARN of a resource that can be tagged.</p>', 'GetTagsRequest$position' => '<p>(Not currently supported) The current pagination position in the paged result set.</p>', 'GetUsagePlanKeyRequest$usagePlanId' => '<p>[Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.</p>', 'GetUsagePlanKeyRequest$keyId' => '<p>[Required] The key Id of the to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.</p>', 'GetUsagePlanKeysRequest$usagePlanId' => '<p>[Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.</p>', 'GetUsagePlanKeysRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetUsagePlanKeysRequest$nameQuery' => '<p>A query parameter specifying the name of the to-be-returned usage plan keys.</p>', 'GetUsagePlanRequest$usagePlanId' => '<p>[Required] The identifier of the <a>UsagePlan</a> resource to be retrieved.</p>', 'GetUsagePlansRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetUsagePlansRequest$keyId' => '<p>The identifier of the API key associated with the usage plans.</p>', 'GetUsageRequest$usagePlanId' => '<p>[Required] The Id of the usage plan associated with the usage data.</p>', 'GetUsageRequest$keyId' => '<p>The Id of the API key associated with the resultant usage data.</p>', 'GetUsageRequest$startDate' => '<p>[Required] The starting date (e.g., 2016-01-01) of the usage data.</p>', 'GetUsageRequest$endDate' => '<p>[Required] The ending date (e.g., 2016-12-31) of the usage data.</p>', 'GetUsageRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'GetVpcLinkRequest$vpcLinkId' => '<p>[Required] The identifier of the <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.</p>', 'GetVpcLinksRequest$position' => '<p>The current pagination position in the paged result set.</p>', 'ImportDocumentationPartsRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'Integration$httpMethod' => '<p>Specifies the integration\'s HTTP method type.</p>', 'Integration$uri' => '<p>Specifies Uniform Resource Identifier (URI) of the integration endpoint.</p> <ul> <li><p> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing. </p> </li> <li><p> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&amp;{p1}={v1}&amp;p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&amp;Bucket={bucket}&amp;Key={key}</code> or <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code></p> </li></ul>', 'Integration$connectionId' => '<p>The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <a>VpcLink</a> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.</p>', 'Integration$credentials' => '<p>Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role\'s Amazon Resource Name (ARN). To require that the caller\'s identity be passed through from the request, specify the string <code>arn:aws:iam::\\*:user/\\*</code>. To use resource-based permissions on supported AWS services, specify null.</p>', 'Integration$passthroughBehavior' => '<div> <p> Specifies how the method request body of an unmapped content type will be passed through the integration request to the back end without transformation. A content type is unmapped if no mapping template is defined in the integration or the content type does not match any of the mapped content types, as specified in <code>requestTemplates</code>. The valid value is one of the following: </p> <ul> <li> <code>WHEN_NO_MATCH</code>: passes the method request body through the integration request to the back end without transformation when the method request content type does not match any content type associated with the mapping templates defined in the integration request. </li> <li> <code>WHEN_NO_TEMPLATES</code>: passes the method request body through the integration request to the back end without transformation when no mapping template is defined in the integration request. If a template is defined when this option is selected, the method request of an unmapped content-type will be rejected with an HTTP <code>415 Unsupported Media Type</code> response. </li> <li> <code>NEVER</code>: rejects the method request with an HTTP <code>415 Unsupported Media Type</code> response when either the method request content type does not match any content type associated with the mapping templates defined in the integration request or no mapping template is defined in the integration request. </li> </ul> </div>', 'Integration$cacheNamespace' => '<p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>', 'IntegrationResponse$selectionPattern' => '<p>Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end. For example, if the success response returns nothing and the error response returns some string, you could use the <code>.+</code> regex to match error response. However, make sure that the error response does not contain any newline (<code>\\n</code>) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.</p>', 'LimitExceededException$retryAfterSeconds' => NULL, 'LimitExceededException$message' => NULL, 'ListOfString$member' => NULL, 'MapOfApiStageThrottleSettings$key' => NULL, 'MapOfIntegrationResponse$key' => NULL, 'MapOfKeyUsages$key' => NULL, 'MapOfMethod$key' => NULL, 'MapOfMethodResponse$key' => NULL, 'MapOfMethodSettings$key' => NULL, 'MapOfMethodSnapshot$key' => NULL, 'MapOfStringToBoolean$key' => NULL, 'MapOfStringToList$key' => NULL, 'MapOfStringToString$key' => NULL, 'MapOfStringToString$value' => NULL, 'Method$httpMethod' => '<p>The method\'s HTTP verb.</p>', 'Method$authorizationType' => '<p>The method\'s authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>', 'Method$authorizerId' => '<p>The identifier of an <a>Authorizer</a> to use on this method. The <code>authorizationType</code> must be <code>CUSTOM</code>.</p>', 'Method$requestValidatorId' => '<p>The identifier of a <a>RequestValidator</a> for request validation.</p>', 'Method$operationName' => '<p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>', 'MethodSetting$loggingLevel' => '<p>Specifies the logging level for this method, which affects the log entries pushed to Amazon CloudWatch Logs. The PATCH path for this setting is <code>/{method_setting_key}/logging/loglevel</code>, and the available levels are <code>OFF</code>, <code>ERROR</code>, and <code>INFO</code>. Choose <code>ERROR</code> to write only error-level entries to CloudWatch Logs, or choose <code>INFO</code> to include all <code>ERROR</code> events as well as extra informational events.</p>', 'MethodSnapshot$authorizationType' => '<p>The method\'s authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>', 'Model$id' => '<p>The identifier for the model resource.</p>', 'Model$name' => '<p>The name of the model. Must be an alphanumeric string.</p>', 'Model$description' => '<p>The description of the model.</p>', 'Model$schema' => '<p>The schema for the model. For <code>application/json</code> models, this should be <a href="https://tools.ietf.org/html/draft-zyp-json-schema-04" target="_blank">JSON schema draft 4</a> model. Do not include "\\*/" characters in the description of any properties because such "\\*/" characters may be interpreted as the closing marker for comments in some languages, such as Java or JavaScript, causing the installation of your API\'s SDK generated by API Gateway to fail.</p>', 'Model$contentType' => '<p>The content-type for the model.</p>', 'Models$position' => NULL, 'NotFoundException$message' => NULL, 'PatchOperation$path' => '<p>The <code>op</code> operation\'s target, as identified by a <a href="https://tools.ietf.org/html/draft-ietf-appsawg-json-pointer-08">JSON Pointer</a> value that references a location within the targeted resource. For example, if the target resource has an updateable property of <code>{"name":"value"}</code>, the path for this property is <code>/name</code>. If the <code>name</code> property value is a JSON object (e.g., <code>{"name": {"child/name": "child-value"}}</code>), the path for the <code>child/name</code> property will be <code>/name/child~1name</code>. Any slash ("/") character appearing in path names must be escaped with "~1", as shown in the example above. Each <code>op</code> operation can have only one <code>path</code> associated with it.</p>', 'PatchOperation$value' => '<p>The new target value of the update operation. It is applicable for the <code>add</code> or <code>replace</code> operation. When using AWS CLI to update a property of a JSON value, enclose the JSON object with a pair of single quotes in a Linux shell, e.g., \'{"a": ...}\'. In a Windows shell, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON for Parameters</a>.</p>', 'PatchOperation$from' => '<p>The <code>copy</code> update operation\'s source as identified by a <code>JSON-Pointer</code> value referencing the location within the targeted resource to copy the value from. For example, to promote a canary deployment, you copy the canary deployment ID to the affiliated deployment ID by calling a PATCH request on a <a>Stage</a> resource with <code>"op":"copy"</code>, <code>"from":"/canarySettings/deploymentId"</code> and <code>"path":"/deploymentId"</code>.</p>', 'PathToMapOfMethodSnapshot$key' => NULL, 'PutGatewayResponseRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'PutIntegrationRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'PutIntegrationRequest$resourceId' => '<p>[Required] Specifies a put integration request\'s resource ID.</p>', 'PutIntegrationRequest$httpMethod' => '<p>[Required] Specifies a put integration request\'s HTTP method.</p>', 'PutIntegrationRequest$integrationHttpMethod' => '<p>Specifies a put integration HTTP method. When the integration type is HTTP or AWS, this field is required.</p>', 'PutIntegrationRequest$uri' => '<p>Specifies Uniform Resource Identifier (URI) of the integration endpoint.</p> <ul> <li><p> For <code>HTTP</code> or <code>HTTP_PROXY</code> integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the <a target="_blank" href="https://en.wikipedia.org/wiki/Uniform_Resource_Identifier">RFC-3986 specification</a>, for either standard integration, where <code>connectionType</code> is not <code>VPC_LINK</code>, or private integration, where <code>connectionType</code> is <code>VPC_LINK</code>. For a private HTTP integration, the URI is not used for routing. </p> </li> <li><p> For <code>AWS</code> or <code>AWS_PROXY</code> integrations, the URI is of the form <code>arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}</code>. Here, <code>{Region}</code> is the API Gateway region (e.g., <code>us-east-1</code>); <code>{service}</code> is the name of the integrated AWS service (e.g., <code>s3</code>); and <code>{subdomain}</code> is a designated subdomain supported by certain AWS service for fast host-name lookup. <code>action</code> can be used for an AWS service action-based API, using an <code>Action={name}&amp;{p1}={v1}&amp;p2={v2}...</code> query string. The ensuing <code>{service_api}</code> refers to a supported action <code>{name}</code> plus any required input parameters. Alternatively, <code>path</code> can be used for an AWS service path-based API. The ensuing <code>service_api</code> refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of <code><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html">GetObject</a></code>, the <code>uri</code> can be either <code>arn:aws:apigateway:us-west-2:s3:action/GetObject&amp;Bucket={bucket}&amp;Key={key}</code> or <code>arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}</code></p> </li></ul>', 'PutIntegrationRequest$connectionId' => '<p>The (<a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id"><code>id</code></a>) of the <a>VpcLink</a> used for the integration when <code>connectionType=VPC_LINK</code> and undefined, otherwise.</p>', 'PutIntegrationRequest$credentials' => '<p>Specifies whether credentials are required for a put integration.</p>', 'PutIntegrationRequest$passthroughBehavior' => '<p>Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the <code>requestTemplates</code> property on the Integration resource. There are three valid values: <code>WHEN_NO_MATCH</code>, <code>WHEN_NO_TEMPLATES</code>, and <code>NEVER</code>. </p> <ul> <li><p><code>WHEN_NO_MATCH</code> passes the request body for unmapped content types through to the integration back end without transformation.</p></li> <li><p><code>NEVER</code> rejects unmapped content types with an HTTP 415 \'Unsupported Media Type\' response.</p></li> <li><p><code>WHEN_NO_TEMPLATES</code> allows pass-through when the integration has NO content types mapped to templates. However if there is at least one content type defined, unmapped content types will be rejected with the same 415 response.</p></li> </ul>', 'PutIntegrationRequest$cacheNamespace' => '<p>Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the <code>cacheNamespace</code>. You can specify the same <code>cacheNamespace</code> across resources to return the same cached data for requests to different resources.</p>', 'PutIntegrationResponseRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'PutIntegrationResponseRequest$resourceId' => '<p>[Required] Specifies a put integration response request\'s resource identifier.</p>', 'PutIntegrationResponseRequest$httpMethod' => '<p>[Required] Specifies a put integration response request\'s HTTP method.</p>', 'PutIntegrationResponseRequest$selectionPattern' => '<p>Specifies the selection pattern of a put integration response.</p>', 'PutMethodRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'PutMethodRequest$resourceId' => '<p>[Required] The <a>Resource</a> identifier for the new <a>Method</a> resource.</p>', 'PutMethodRequest$httpMethod' => '<p>[Required] Specifies the method request\'s HTTP method type.</p>', 'PutMethodRequest$authorizationType' => '<p>[Required] The method\'s authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.</p>', 'PutMethodRequest$authorizerId' => '<p>Specifies the identifier of an <a>Authorizer</a> to use on this Method, if the type is CUSTOM or COGNITO_USER_POOLS. The authorizer identifier is generated by API Gateway when you created the authorizer.</p>', 'PutMethodRequest$operationName' => '<p>A human-friendly operation identifier for the method. For example, you can assign the <code>operationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method in the <code>PetStore</code> example.</p>', 'PutMethodRequest$requestValidatorId' => '<p>The identifier of a <a>RequestValidator</a> for validating the method request.</p>', 'PutMethodResponseRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'PutMethodResponseRequest$resourceId' => '<p>[Required] The <a>Resource</a> identifier for the <a>Method</a> resource.</p>', 'PutMethodResponseRequest$httpMethod' => '<p>[Required] The HTTP verb of the <a>Method</a> resource.</p>', 'PutRestApiRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'RequestValidator$id' => '<p>The identifier of this <a>RequestValidator</a>.</p>', 'RequestValidator$name' => '<p>The name of this <a>RequestValidator</a></p>', 'RequestValidators$position' => NULL, 'Resource$id' => '<p>The resource\'s identifier.</p>', 'Resource$parentId' => '<p>The parent resource\'s identifier.</p>', 'Resource$pathPart' => '<p>The last path segment for this resource.</p>', 'Resource$path' => '<p>The full path for this resource.</p>', 'Resources$position' => NULL, 'RestApi$id' => '<p>The API\'s identifier. This identifier is unique across all of your APIs in API Gateway.</p>', 'RestApi$name' => '<p>The API\'s name.</p>', 'RestApi$description' => '<p>The API\'s description.</p>', 'RestApi$version' => '<p>A version identifier for the API.</p>', 'RestApi$policy' => 'A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.', 'RestApis$position' => NULL, 'SdkConfigurationProperty$name' => '<p>The name of a an <a>SdkType</a> configuration property.</p>', 'SdkConfigurationProperty$friendlyName' => '<p>The user-friendly name of an <a>SdkType</a> configuration property.</p>', 'SdkConfigurationProperty$description' => '<p>The description of an <a>SdkType</a> configuration property.</p>', 'SdkConfigurationProperty$defaultValue' => '<p>The default value of an <a>SdkType</a> configuration property.</p>', 'SdkResponse$contentType' => '<p>The content-type header value in the HTTP response.</p>', 'SdkResponse$contentDisposition' => '<p>The content-disposition header value in the HTTP response.</p>', 'SdkType$id' => '<p>The identifier of an <a>SdkType</a> instance.</p>', 'SdkType$friendlyName' => '<p>The user-friendly name of an <a>SdkType</a> instance.</p>', 'SdkType$description' => '<p>The description of an <a>SdkType</a>.</p>', 'SdkTypes$position' => NULL, 'ServiceUnavailableException$retryAfterSeconds' => NULL, 'ServiceUnavailableException$message' => NULL, 'Stage$deploymentId' => '<p>The identifier of the <a>Deployment</a> that the stage points to.</p>', 'Stage$clientCertificateId' => '<p>The identifier of a client certificate for an API stage.</p>', 'Stage$stageName' => '<p>The name of the stage is the first path segment in the Uniform Resource Identifier (URI) of a call to API Gateway. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.</p>', 'Stage$description' => '<p>The stage\'s description.</p>', 'Stage$documentationVersion' => '<p>The version of the associated API documentation.</p>', 'Stage$webAclArn' => '<p>The ARN of the WebAcl associated with the <a>Stage</a>.</p>', 'StageKey$restApiId' => '<p>The string identifier of the associated <a>RestApi</a>.</p>', 'StageKey$stageName' => '<p>The stage name associated with the stage key.</p>', 'TagResourceRequest$resourceArn' => '<p>[Required] The ARN of a resource that can be tagged.</p>', 'Template$value' => '<p>The Apache <a href="https://velocity.apache.org/engine/devel/vtl-reference.html" target="_blank">Velocity Template Language (VTL)</a> template content used for the template resource.</p>', 'TestInvokeAuthorizerRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'TestInvokeAuthorizerRequest$authorizerId' => '<p>[Required] Specifies a test invoke authorizer request\'s <a>Authorizer</a> ID.</p>', 'TestInvokeAuthorizerRequest$pathWithQueryString' => '<p>[Optional] The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.</p>', 'TestInvokeAuthorizerRequest$body' => '<p>[Optional] The simulated request body of an incoming invocation request.</p>', 'TestInvokeAuthorizerResponse$log' => '<p>The API Gateway execution log for the test authorizer request.</p>', 'TestInvokeAuthorizerResponse$principalId' => '<p>The principal identity returned by the <a>Authorizer</a></p>', 'TestInvokeAuthorizerResponse$policy' => '<p>The JSON policy document returned by the <a>Authorizer</a></p>', 'TestInvokeMethodRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'TestInvokeMethodRequest$resourceId' => '<p>[Required] Specifies a test invoke method request\'s resource ID.</p>', 'TestInvokeMethodRequest$httpMethod' => '<p>[Required] Specifies a test invoke method request\'s HTTP method.</p>', 'TestInvokeMethodRequest$pathWithQueryString' => '<p>The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters.</p>', 'TestInvokeMethodRequest$body' => '<p>The simulated request body of an incoming invocation request.</p>', 'TestInvokeMethodRequest$clientCertificateId' => '<p>A <a>ClientCertificate</a> identifier to use in the test invocation. API Gateway will use the certificate when making the HTTPS request to the defined back-end endpoint.</p>', 'TestInvokeMethodResponse$body' => '<p>The body of the HTTP response.</p>', 'TestInvokeMethodResponse$log' => '<p>The API Gateway execution log for the test invoke request.</p>', 'TooManyRequestsException$retryAfterSeconds' => NULL, 'TooManyRequestsException$message' => NULL, 'UnauthorizedException$message' => NULL, 'UntagResourceRequest$resourceArn' => '<p>[Required] The ARN of a resource that can be tagged.</p>', 'UpdateApiKeyRequest$apiKey' => '<p>[Required] The identifier of the <a>ApiKey</a> resource to be updated.</p>', 'UpdateAuthorizerRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'UpdateAuthorizerRequest$authorizerId' => '<p>[Required] The identifier of the <a>Authorizer</a> resource.</p>', 'UpdateBasePathMappingRequest$domainName' => '<p>[Required] The domain name of the <a>BasePathMapping</a> resource to change.</p>', 'UpdateBasePathMappingRequest$basePath' => '<p>[Required] The base path of the <a>BasePathMapping</a> resource to change.</p> <p>To specify an empty base path, set this parameter to <code>\'(none)\'</code>.</p>', 'UpdateClientCertificateRequest$clientCertificateId' => '<p>[Required] The identifier of the <a>ClientCertificate</a> resource to be updated.</p>', 'UpdateDeploymentRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'UpdateDeploymentRequest$deploymentId' => '<p>The replacement identifier for the <a>Deployment</a> resource to change information about.</p>', 'UpdateDocumentationPartRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'UpdateDocumentationPartRequest$documentationPartId' => '<p>[Required] The identifier of the to-be-updated documentation part.</p>', 'UpdateDocumentationVersionRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>..</p>', 'UpdateDocumentationVersionRequest$documentationVersion' => '<p>[Required] The version identifier of the to-be-updated documentation version.</p>', 'UpdateDomainNameRequest$domainName' => '<p>[Required] The name of the <a>DomainName</a> resource to be changed.</p>', 'UpdateGatewayResponseRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'UpdateIntegrationRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'UpdateIntegrationRequest$resourceId' => '<p>[Required] Represents an update integration request\'s resource identifier.</p>', 'UpdateIntegrationRequest$httpMethod' => '<p>[Required] Represents an update integration request\'s HTTP method.</p>', 'UpdateIntegrationResponseRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'UpdateIntegrationResponseRequest$resourceId' => '<p>[Required] Specifies an update integration response request\'s resource identifier.</p>', 'UpdateIntegrationResponseRequest$httpMethod' => '<p>[Required] Specifies an update integration response request\'s HTTP method.</p>', 'UpdateMethodRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'UpdateMethodRequest$resourceId' => '<p>[Required] The <a>Resource</a> identifier for the <a>Method</a> resource.</p>', 'UpdateMethodRequest$httpMethod' => '<p>[Required] The HTTP verb of the <a>Method</a> resource.</p>', 'UpdateMethodResponseRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'UpdateMethodResponseRequest$resourceId' => '<p>[Required] The <a>Resource</a> identifier for the <a>MethodResponse</a> resource.</p>', 'UpdateMethodResponseRequest$httpMethod' => '<p>[Required] The HTTP verb of the <a>Method</a> resource.</p>', 'UpdateModelRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'UpdateModelRequest$modelName' => '<p>[Required] The name of the model to update.</p>', 'UpdateRequestValidatorRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'UpdateRequestValidatorRequest$requestValidatorId' => '<p>[Required] The identifier of <a>RequestValidator</a> to be updated.</p>', 'UpdateResourceRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'UpdateResourceRequest$resourceId' => '<p>[Required] The identifier of the <a>Resource</a> resource.</p>', 'UpdateRestApiRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'UpdateStageRequest$restApiId' => '<p>[Required] The string identifier of the associated <a>RestApi</a>.</p>', 'UpdateStageRequest$stageName' => '<p>[Required] The name of the <a>Stage</a> resource to change information about.</p>', 'UpdateUsagePlanRequest$usagePlanId' => '<p>[Required] The Id of the to-be-updated usage plan.</p>', 'UpdateUsageRequest$usagePlanId' => '<p>[Required] The Id of the usage plan associated with the usage data.</p>', 'UpdateUsageRequest$keyId' => '<p>[Required] The identifier of the API key associated with the usage plan in which a temporary extension is granted to the remaining quota.</p>', 'UpdateVpcLinkRequest$vpcLinkId' => '<p>[Required] The identifier of the <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.</p>', 'Usage$usagePlanId' => '<p>The plan Id associated with this usage data.</p>', 'Usage$startDate' => '<p>The starting date of the usage data.</p>', 'Usage$endDate' => '<p>The ending date of the usage data.</p>', 'Usage$position' => NULL, 'UsagePlan$id' => '<p>The identifier of a <a>UsagePlan</a> resource.</p>', 'UsagePlan$name' => '<p>The name of a usage plan.</p>', 'UsagePlan$description' => '<p>The description of a usage plan.</p>', 'UsagePlan$productCode' => '<p>The AWS Markeplace product identifier to associate with the usage plan as a SaaS product on AWS Marketplace.</p>', 'UsagePlanKey$id' => '<p>The Id of a usage plan key.</p>', 'UsagePlanKey$type' => '<p>The type of a usage plan key. Currently, the valid key type is <code>API_KEY</code>.</p>', 'UsagePlanKey$value' => '<p>The value of a usage plan key.</p>', 'UsagePlanKey$name' => '<p>The name of a usage plan key.</p>', 'UsagePlanKeys$position' => NULL, 'UsagePlans$position' => NULL, 'VpcLink$id' => '<p>The identifier of the <a>VpcLink</a>. It is used in an <a>Integration</a> to reference this <a>VpcLink</a>.</p>', 'VpcLink$name' => '<p>The name used to label and identify the VPC link.</p>', 'VpcLink$description' => '<p>The description of the VPC link.</p>', 'VpcLink$statusMessage' => '<p>A description about the VPC link status.</p>', 'VpcLinks$position' => NULL, ], ], 'TagResourceRequest' => [ 'base' => '<p>Adds or updates a tag on a given resource.</p>', 'refs' => [], ], 'Tags' => [ 'base' => '<p>The collection of tags. Each tag element is associated with a given resource.</p>', 'refs' => [], ], 'Template' => [ 'base' => '<p>Represents a mapping template used to transform a payload.</p> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/models-mappings.html#models-mappings-mappings">Mapping Templates</a> </div>', 'refs' => [], ], 'TestInvokeAuthorizerRequest' => [ 'base' => '<p>Make a request to simulate the execution of an <a>Authorizer</a>.</p>', 'refs' => [], ], 'TestInvokeAuthorizerResponse' => [ 'base' => '<p>Represents the response of the test invoke request for a custom <a>Authorizer</a></p>', 'refs' => [], ], 'TestInvokeMethodRequest' => [ 'base' => '<p>Make a request to simulate the execution of a <a>Method</a>.</p>', 'refs' => [], ], 'TestInvokeMethodResponse' => [ 'base' => '<p>Represents the response of the test invoke request in the HTTP method.</p> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-test-method.html#how-to-test-method-console">Test API using the API Gateway console</a> </div>', 'refs' => [], ], 'ThrottleSettings' => [ 'base' => '<p> The API request rate limits.</p>', 'refs' => [ 'Account$throttleSettings' => '<p>Specifies the API request limits configured for the current <a>Account</a>.</p>', 'CreateUsagePlanRequest$throttle' => '<p>The throttling limits of the usage plan.</p>', 'MapOfApiStageThrottleSettings$value' => NULL, 'UsagePlan$throttle' => '<p>The request throttle limits of a usage plan.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ApiKey$createdDate' => '<p>The timestamp when the API Key was created.</p>', 'ApiKey$lastUpdatedDate' => '<p>The timestamp when the API Key was last updated.</p>', 'ClientCertificate$createdDate' => '<p>The timestamp when the client certificate was created.</p>', 'ClientCertificate$expirationDate' => '<p>The timestamp when the client certificate will expire.</p>', 'Deployment$createdDate' => '<p>The date and time that the deployment resource was created.</p>', 'DocumentationVersion$createdDate' => '<p>The date when the API documentation snapshot is created.</p>', 'DomainName$certificateUploadDate' => '<p>The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.</p>', 'RestApi$createdDate' => '<p>The timestamp when the API was created.</p>', 'Stage$createdDate' => '<p>The timestamp when the stage was created.</p>', 'Stage$lastUpdatedDate' => '<p>The timestamp when the stage last updated.</p>', ], ], 'TlsConfig' => [ 'base' => NULL, 'refs' => [ 'Integration$tlsConfig' => '<p>Specifies the TLS configuration for an integration.</p>', 'PutIntegrationRequest$tlsConfig' => NULL, ], ], 'TooManyRequestsException' => [ 'base' => '<p>The request has reached its throttling limit. Retry after the specified time period.</p>', 'refs' => [], ], 'UnauthorizedCacheControlHeaderStrategy' => [ 'base' => NULL, 'refs' => [ 'MethodSetting$unauthorizedCacheControlHeaderStrategy' => '<p>Specifies how to handle unauthorized requests for cache invalidation. The PATCH path for this setting is <code>/{method_setting_key}/caching/unauthorizedCacheControlHeaderStrategy</code>, and the available values are <code>FAIL_WITH_403</code>, <code>SUCCEED_WITH_RESPONSE_HEADER</code>, <code>SUCCEED_WITHOUT_RESPONSE_HEADER</code>.</p>', ], ], 'UnauthorizedException' => [ 'base' => '<p>The request is denied because the caller has insufficient permissions.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => '<p>Removes a tag from a given resource.</p>', 'refs' => [], ], 'UpdateAccountRequest' => [ 'base' => '<p>Requests API Gateway to change information about the current <a>Account</a> resource.</p>', 'refs' => [], ], 'UpdateApiKeyRequest' => [ 'base' => '<p>A request to change information about an <a>ApiKey</a> resource.</p>', 'refs' => [], ], 'UpdateAuthorizerRequest' => [ 'base' => '<p>Request to update an existing <a>Authorizer</a> resource.</p>', 'refs' => [], ], 'UpdateBasePathMappingRequest' => [ 'base' => '<p>A request to change information about the <a>BasePathMapping</a> resource.</p>', 'refs' => [], ], 'UpdateClientCertificateRequest' => [ 'base' => '<p>A request to change information about an <a>ClientCertificate</a> resource.</p>', 'refs' => [], ], 'UpdateDeploymentRequest' => [ 'base' => '<p>Requests API Gateway to change information about a <a>Deployment</a> resource.</p>', 'refs' => [], ], 'UpdateDocumentationPartRequest' => [ 'base' => '<p>Updates an existing documentation part of a given API.</p>', 'refs' => [], ], 'UpdateDocumentationVersionRequest' => [ 'base' => '<p>Updates an existing documentation version of an API.</p>', 'refs' => [], ], 'UpdateDomainNameRequest' => [ 'base' => '<p>A request to change information about the <a>DomainName</a> resource.</p>', 'refs' => [], ], 'UpdateGatewayResponseRequest' => [ 'base' => '<p>Updates a <a>GatewayResponse</a> of a specified response type on the given <a>RestApi</a>.</p>', 'refs' => [], ], 'UpdateIntegrationRequest' => [ 'base' => '<p>Represents an update integration request.</p>', 'refs' => [], ], 'UpdateIntegrationResponseRequest' => [ 'base' => '<p>Represents an update integration response request.</p>', 'refs' => [], ], 'UpdateMethodRequest' => [ 'base' => '<p>Request to update an existing <a>Method</a> resource.</p>', 'refs' => [], ], 'UpdateMethodResponseRequest' => [ 'base' => '<p>A request to update an existing <a>MethodResponse</a> resource.</p>', 'refs' => [], ], 'UpdateModelRequest' => [ 'base' => '<p>Request to update an existing model in an existing <a>RestApi</a> resource.</p>', 'refs' => [], ], 'UpdateRequestValidatorRequest' => [ 'base' => '<p>Updates a <a>RequestValidator</a> of a given <a>RestApi</a>.</p>', 'refs' => [], ], 'UpdateResourceRequest' => [ 'base' => '<p>Request to change information about a <a>Resource</a> resource.</p>', 'refs' => [], ], 'UpdateRestApiRequest' => [ 'base' => '<p>Request to update an existing <a>RestApi</a> resource in your collection.</p>', 'refs' => [], ], 'UpdateStageRequest' => [ 'base' => '<p>Requests API Gateway to change information about a <a>Stage</a> resource.</p>', 'refs' => [], ], 'UpdateUsagePlanRequest' => [ 'base' => '<p>The PATCH request to update a usage plan of a given plan Id.</p>', 'refs' => [], ], 'UpdateUsageRequest' => [ 'base' => '<p>The PATCH request to grant a temporary extension to the remaining quota of a usage plan associated with a specified API key.</p>', 'refs' => [], ], 'UpdateVpcLinkRequest' => [ 'base' => '<p>Updates an existing <a>VpcLink</a> of a specified identifier.</p>', 'refs' => [], ], 'Usage' => [ 'base' => '<p>Represents the usage data of a usage plan.</p> <div class="remarks"/> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html">Create and Use Usage Plans</a>, <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-create-usage-plans-with-console.html#api-gateway-usage-plan-manage-usage">Manage Usage in a Usage Plan</a> </div>', 'refs' => [], ], 'UsagePlan' => [ 'base' => '<p>Represents a usage plan than can specify who can assess associated API stages with specified request limits and quotas.</p> <div class="remarks"> <p>In a usage plan, you associate an API by specifying the API\'s Id and a stage name of the specified API. You add plan customers by adding API keys to the plan. </p> </div> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html">Create and Use Usage Plans</a> </div>', 'refs' => [ 'ListOfUsagePlan$member' => NULL, ], ], 'UsagePlanKey' => [ 'base' => '<p>Represents a usage plan key to identify a plan customer.</p> <div class="remarks"> <p>To associate an API stage with a selected API key in a usage plan, you must create a UsagePlanKey resource to represent the selected <a>ApiKey</a>.</p> </div>" <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html">Create and Use Usage Plans</a> </div>', 'refs' => [ 'ListOfUsagePlanKey$member' => NULL, ], ], 'UsagePlanKeys' => [ 'base' => '<p>Represents the collection of usage plan keys added to usage plans for the associated API keys and, possibly, other types of keys.</p> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html">Create and Use Usage Plans</a> </div>', 'refs' => [], ], 'UsagePlans' => [ 'base' => '<p>Represents a collection of usage plans for an AWS account.</p> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html">Create and Use Usage Plans</a> </div>', 'refs' => [], ], 'VpcLink' => [ 'base' => '<p>An API Gateway VPC link for a <a>RestApi</a> to access resources in an Amazon Virtual Private Cloud (VPC).</p> <div class="remarks"> <p><p>To enable access to a resource in an Amazon Virtual Private Cloud through Amazon API Gateway, you, as an API developer, create a <a>VpcLink</a> resource targeted for one or more network load balancers of the VPC and then integrate an API method with a private integration that uses the <a>VpcLink</a>. The private integration has an integration type of <code>HTTP</code> or <code>HTTP_PROXY</code> and has a connection type of <code>VPC_LINK</code>. The integration uses the <code>connectionId</code> property to identify the <a>VpcLink</a> used.</p> </p> </div>', 'refs' => [ 'ListOfVpcLink$member' => NULL, ], ], 'VpcLinkStatus' => [ 'base' => NULL, 'refs' => [ 'VpcLink$status' => '<p>The status of the VPC link. The valid values are <code>AVAILABLE</code>, <code>PENDING</code>, <code>DELETING</code>, or <code>FAILED</code>. Deploying an API will wait if the status is <code>PENDING</code> and will fail if the status is <code>DELETING</code>. </p>', ], ], 'VpcLinks' => [ 'base' => '<p>The collection of VPC links under the caller\'s account in a region.</p> <div class="seeAlso"> <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/getting-started-with-private-integration.html">Getting Started with Private Integrations</a>, <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-private-integration.html">Set up Private Integrations</a> </div>', 'refs' => [], ], ],];
