<?php
// This file was auto-generated from sdk-root/src/data/acm-pca/2017-08-22/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>This is the <i>ACM Private CA API Reference</i>. It provides descriptions, syntax, and usage examples for each of the actions and data types involved in creating and managing private certificate authorities (CA) for your organization.</p> <p>The documentation for each action shows the Query API request parameters and the XML response. Alternatively, you can use one of the AWS SDKs to access an API that\'s tailored to the programming language or platform that you\'re using. For more information, see <a href="https://aws.amazon.com/tools/#SDKs">AWS SDKs</a>.</p> <note> <p>Each ACM Private CA API action has a throttling limit which determines the number of times the action can be called per second. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaLimits.html#PcaLimits-api">API Rate Limits in ACM Private CA</a> in the ACM Private CA user guide.</p> </note>', 'operations' => [ 'CreateCertificateAuthority' => '<p>Creates a root or subordinate private certificate authority (CA). You must specify the CA configuration, the certificate revocation list (CRL) configuration, the CA type, and an optional idempotency token to avoid accidental creation of multiple CAs. The CA configuration specifies the name of the algorithm and key size to be used to create the CA private key, the type of signing algorithm that the CA uses, and X.500 subject information. The CRL configuration specifies the CRL expiration period in days (the validity period of the CRL), the Amazon S3 bucket that will contain the CRL, and a CNAME alias for the S3 bucket that is included in certificates issued by the CA. If successful, this action returns the Amazon Resource Name (ARN) of the CA.</p>', 'CreateCertificateAuthorityAuditReport' => '<p>Creates an audit report that lists every time that your CA private key is used. The report is saved in the Amazon S3 bucket that you specify on input. The <a>IssueCertificate</a> and <a>RevokeCertificate</a> actions use the private key.</p>', 'CreatePermission' => '<p>Assigns permissions from a private CA to a designated AWS service. Services are specified by their service principals and can be given permission to create and retrieve certificates on a private CA. Services can also be given permission to list the active permissions that the private CA has granted. For ACM to automatically renew your private CA\'s certificates, you must assign all possible permissions from the CA to the ACM service principal.</p> <p>At this time, you can only assign permissions to ACM (<code>acm.amazonaws.com</code>). Permissions can be revoked with the <a>DeletePermission</a> action and listed with the <a>ListPermissions</a> action.</p>', 'DeleteCertificateAuthority' => '<p>Deletes a private certificate authority (CA). You must provide the Amazon Resource Name (ARN) of the private CA that you want to delete. You can find the ARN by calling the <a>ListCertificateAuthorities</a> action. </p> <note> <p>Deleting a CA will invalidate other CAs and certificates below it in your CA hierarchy.</p> </note> <p>Before you can delete a CA that you have created and activated, you must disable it. To do this, call the <a>UpdateCertificateAuthority</a> action and set the <b>CertificateAuthorityStatus</b> parameter to <code>DISABLED</code>. </p> <p>Additionally, you can delete a CA if you are waiting for it to be created (that is, the status of the CA is <code>CREATING</code>). You can also delete it if the CA has been created but you haven\'t yet imported the signed certificate into ACM Private CA (that is, the status of the CA is <code>PENDING_CERTIFICATE</code>). </p> <p>When you successfully call <a>DeleteCertificateAuthority</a>, the CA\'s status changes to <code>DELETED</code>. However, the CA won\'t be permanently deleted until the restoration period has passed. By default, if you do not set the <code>PermanentDeletionTimeInDays</code> parameter, the CA remains restorable for 30 days. You can set the parameter from 7 to 30 days. The <a>DescribeCertificateAuthority</a> action returns the time remaining in the restoration window of a private CA in the <code>DELETED</code> state. To restore an eligible CA, call the <a>RestoreCertificateAuthority</a> action.</p>', 'DeletePermission' => '<p>Revokes permissions that a private CA assigned to a designated AWS service. Permissions can be created with the <a>CreatePermission</a> action and listed with the <a>ListPermissions</a> action. </p>', 'DescribeCertificateAuthority' => '<p>Lists information about your private certificate authority (CA). You specify the private CA on input by its ARN (Amazon Resource Name). The output contains the status of your CA. This can be any of the following: </p> <ul> <li> <p> <code>CREATING</code> - ACM Private CA is creating your private certificate authority.</p> </li> <li> <p> <code>PENDING_CERTIFICATE</code> - The certificate is pending. You must use your ACM Private CA-hosted or on-premises root or subordinate CA to sign your private CA CSR and then import it into PCA. </p> </li> <li> <p> <code>ACTIVE</code> - Your private CA is active.</p> </li> <li> <p> <code>DISABLED</code> - Your private CA has been disabled.</p> </li> <li> <p> <code>EXPIRED</code> - Your private CA certificate has expired.</p> </li> <li> <p> <code>FAILED</code> - Your private CA has failed. Your CA can fail because of problems such a network outage or backend AWS failure or other errors. A failed CA can never return to the pending state. You must create a new CA. </p> </li> <li> <p> <code>DELETED</code> - Your private CA is within the restoration period, after which it is permanently deleted. The length of time remaining in the CA\'s restoration period is also included in this action\'s output.</p> </li> </ul>', 'DescribeCertificateAuthorityAuditReport' => '<p>Lists information about a specific audit report created by calling the <a>CreateCertificateAuthorityAuditReport</a> action. Audit information is created every time the certificate authority (CA) private key is used. The private key is used when you call the <a>IssueCertificate</a> action or the <a>RevokeCertificate</a> action. </p>', 'GetCertificate' => '<p>Retrieves a certificate from your private CA. The ARN of the certificate is returned when you call the <a>IssueCertificate</a> action. You must specify both the ARN of your private CA and the ARN of the issued certificate when calling the <b>GetCertificate</b> action. You can retrieve the certificate if it is in the <b>ISSUED</b> state. You can call the <a>CreateCertificateAuthorityAuditReport</a> action to create a report that contains information about all of the certificates issued and revoked by your private CA. </p>', 'GetCertificateAuthorityCertificate' => '<p>Retrieves the certificate and certificate chain for your private certificate authority (CA). Both the certificate and the chain are base64 PEM-encoded. The chain does not include the CA certificate. Each certificate in the chain signs the one before it. </p>', 'GetCertificateAuthorityCsr' => '<p>Retrieves the certificate signing request (CSR) for your private certificate authority (CA). The CSR is created when you call the <a>CreateCertificateAuthority</a> action. Sign the CSR with your ACM Private CA-hosted or on-premises root or subordinate CA. Then import the signed certificate back into ACM Private CA by calling the <a>ImportCertificateAuthorityCertificate</a> action. The CSR is returned as a base64 PEM-encoded string. </p>', 'ImportCertificateAuthorityCertificate' => '<p>Imports a signed private CA certificate into ACM Private CA. This action is used when you are using a chain of trust whose root is located outside ACM Private CA. Before you can call this action, the following preparations must in place:</p> <ol> <li> <p>In ACM Private CA, call the <a>CreateCertificateAuthority</a> action to create the private CA that that you plan to back with the imported certificate.</p> </li> <li> <p>Call the <a>GetCertificateAuthorityCsr</a> action to generate a certificate signing request (CSR).</p> </li> <li> <p>Sign the CSR using a root or intermediate CA hosted either by an on-premises PKI hierarchy or a commercial CA..</p> </li> <li> <p>Create a certificate chain and copy the signed certificate and the certificate chain to your working directory.</p> </li> </ol> <p>The following requirements apply when you import a CA certificate.</p> <ul> <li> <p>You cannot import a non-self-signed certificate for use as a root CA.</p> </li> <li> <p>You cannot import a self-signed certificate for use as a subordinate CA.</p> </li> <li> <p>Your certificate chain must not include the private CA certificate that you are importing.</p> </li> <li> <p>Your ACM Private CA-hosted or on-premises CA certificate must be the last certificate in your chain. The subordinate certificate, if any, that your root CA signed must be next to last. The subordinate certificate signed by the preceding subordinate CA must come next, and so on until your chain is built. </p> </li> <li> <p>The chain must be PEM-encoded.</p> </li> </ul>', 'IssueCertificate' => '<p>Uses your private certificate authority (CA) to issue a client certificate. This action returns the Amazon Resource Name (ARN) of the certificate. You can retrieve the certificate by calling the <a>GetCertificate</a> action and specifying the ARN. </p> <note> <p>You cannot use the ACM <b>ListCertificateAuthorities</b> action to retrieve the ARNs of the certificates that you issue by using ACM Private CA.</p> </note>', 'ListCertificateAuthorities' => '<p>Lists the private certificate authorities that you created by using the <a>CreateCertificateAuthority</a> action.</p>', 'ListPermissions' => '<p>Lists all the permissions, if any, that have been assigned by a private CA. Permissions can be granted with the <a>CreatePermission</a> action and revoked with the <a>DeletePermission</a> action.</p>', 'ListTags' => '<p>Lists the tags, if any, that are associated with your private CA. Tags are labels that you can use to identify and organize your CAs. Each tag consists of a key and an optional value. Call the <a>TagCertificateAuthority</a> action to add one or more tags to your CA. Call the <a>UntagCertificateAuthority</a> action to remove tags. </p>', 'RestoreCertificateAuthority' => '<p>Restores a certificate authority (CA) that is in the <code>DELETED</code> state. You can restore a CA during the period that you defined in the <b>PermanentDeletionTimeInDays</b> parameter of the <a>DeleteCertificateAuthority</a> action. Currently, you can specify 7 to 30 days. If you did not specify a <b>PermanentDeletionTimeInDays</b> value, by default you can restore the CA at any time in a 30 day period. You can check the time remaining in the restoration period of a private CA in the <code>DELETED</code> state by calling the <a>DescribeCertificateAuthority</a> or <a>ListCertificateAuthorities</a> actions. The status of a restored CA is set to its pre-deletion status when the <b>RestoreCertificateAuthority</b> action returns. To change its status to <code>ACTIVE</code>, call the <a>UpdateCertificateAuthority</a> action. If the private CA was in the <code>PENDING_CERTIFICATE</code> state at deletion, you must use the <a>ImportCertificateAuthorityCertificate</a> action to import a certificate authority into the private CA before it can be activated. You cannot restore a CA after the restoration period has ended.</p>', 'RevokeCertificate' => '<p>Revokes a certificate that was issued inside ACM Private CA. If you enable a certificate revocation list (CRL) when you create or update your private CA, information about the revoked certificates will be included in the CRL. ACM Private CA writes the CRL to an S3 bucket that you specify. For more information about revocation, see the <a>CrlConfiguration</a> structure. ACM Private CA also writes revocation information to the audit report. For more information, see <a>CreateCertificateAuthorityAuditReport</a>. </p> <note> <p>You cannot revoke a root CA self-signed certificate.</p> </note>', 'TagCertificateAuthority' => '<p>Adds one or more tags to your private CA. Tags are labels that you can use to identify and organize your AWS resources. Each tag consists of a key and an optional value. You specify the private CA on input by its Amazon Resource Name (ARN). You specify the tag by using a key-value pair. You can apply a tag to just one private CA if you want to identify a specific characteristic of that CA, or you can apply the same tag to multiple private CAs if you want to filter for a common relationship among those CAs. To remove one or more tags, use the <a>UntagCertificateAuthority</a> action. Call the <a>ListTags</a> action to see what tags are associated with your CA. </p>', 'UntagCertificateAuthority' => '<p>Remove one or more tags from your private CA. A tag consists of a key-value pair. If you do not specify the value portion of the tag when calling this action, the tag will be removed regardless of value. If you specify a value, the tag is removed only if it is associated with the specified value. To add tags to a private CA, use the <a>TagCertificateAuthority</a>. Call the <a>ListTags</a> action to see what tags are associated with your CA. </p>', 'UpdateCertificateAuthority' => '<p>Updates the status or configuration of a private certificate authority (CA). Your private CA must be in the <code>ACTIVE</code> or <code>DISABLED</code> state before you can update it. You can disable a private CA that is in the <code>ACTIVE</code> state or make a CA that is in the <code>DISABLED</code> state active again.</p>', ], 'shapes' => [ 'ASN1Subject' => [ 'base' => '<p>Contains information about the certificate subject. The certificate can be one issued by your private certificate authority (CA) or it can be your private CA certificate. The <b>Subject</b> field in the certificate identifies the entity that owns or controls the public key in the certificate. The entity can be a user, computer, device, or service. The <b>Subject</b> must contain an X.500 distinguished name (DN). A DN is a sequence of relative distinguished names (RDNs). The RDNs are separated by commas in the certificate. The DN must be unique for each entity, but your private CA can issue more than one certificate with the same DN to the same entity. </p>', 'refs' => [ 'CertificateAuthorityConfiguration$Subject' => '<p>Structure that contains X.500 distinguished name information for your private CA.</p>', ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'CreatePermissionRequest$SourceAccount' => '<p>The ID of the calling account.</p>', 'DeletePermissionRequest$SourceAccount' => '<p>The AWS account that calls this action.</p>', ], ], 'ActionList' => [ 'base' => NULL, 'refs' => [ 'CreatePermissionRequest$Actions' => '<p>The actions that the specified AWS service principal can use. These include <code>IssueCertificate</code>, <code>GetCertificate</code>, and <code>ListPermissions</code>.</p>', 'Permission$Actions' => '<p>The private CA actions that can be performed by the designated AWS service.</p>', ], ], 'ActionType' => [ 'base' => NULL, 'refs' => [ 'ActionList$member' => NULL, ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'CertificateAuthority$Arn' => '<p>Amazon Resource Name (ARN) for your private certificate authority (CA). The format is <code> <i>12345678-1234-1234-1234-123456789012</i> </code>.</p>', 'CreateCertificateAuthorityAuditReportRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) of the CA to be audited. This is of the form:</p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>.</p>', 'CreateCertificateAuthorityResponse$CertificateAuthorityArn' => '<p>If successful, the Amazon Resource Name (ARN) of the certificate authority (CA). This is of the form: </p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>', 'CreatePermissionRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) of the CA that grants the permissions. You can find the ARN by calling the <a>ListCertificateAuthorities</a> action. This must have the following form: </p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>', 'DeleteCertificateAuthorityRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a>CreateCertificateAuthority</a>. This must have the following form: </p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>', 'DeletePermissionRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Number (ARN) of the private CA that issued the permissions. You can find the CA\'s ARN by calling the <a>ListCertificateAuthorities</a> action. This must have the following form: </p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>', 'DescribeCertificateAuthorityAuditReportRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) of the private CA. This must be of the form:</p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>', 'DescribeCertificateAuthorityRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a>CreateCertificateAuthority</a>. This must be of the form: </p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>', 'GetCertificateAuthorityCertificateRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) of your private CA. This is of the form:</p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>', 'GetCertificateAuthorityCsrRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called the <a>CreateCertificateAuthority</a> action. This must be of the form: </p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>', 'GetCertificateRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a>CreateCertificateAuthority</a>. This must be of the form: </p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>. </p>', 'GetCertificateRequest$CertificateArn' => '<p>The ARN of the issued certificate. The ARN contains the certificate serial number and must be in the following form: </p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>/certificate/<i>286535153982981100925020015808220737245</i> </code> </p>', 'ImportCertificateAuthorityCertificateRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a>CreateCertificateAuthority</a>. This must be of the form: </p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>', 'IssueCertificateRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a>CreateCertificateAuthority</a>. This must be of the form:</p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>', 'IssueCertificateRequest$TemplateArn' => '<p>Specifies a custom configuration template to use when issuing a certificate. If this parameter is not provided, ACM Private CA defaults to the <code>EndEntityCertificate/V1</code> template.</p> <p>The following service-owned <code>TemplateArn</code> values are supported by ACM Private CA: </p> <ul> <li> <p>arn:aws:acm-pca:::template/EndEntityCertificate/V1</p> </li> <li> <p>arn:aws:acm-pca:::template/SubordinateCACertificate_PathLen0/V1</p> </li> <li> <p>arn:aws:acm-pca:::template/SubordinateCACertificate_PathLen1/V1</p> </li> <li> <p>arn:aws:acm-pca:::template/SubordinateCACertificate_PathLen2/V1</p> </li> <li> <p>arn:aws:acm-pca:::template/SubordinateCACertificate_PathLen3/V1</p> </li> <li> <p>arn:aws:acm-pca:::template/RootCACertificate/V1</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html">Using Templates</a>.</p>', 'IssueCertificateResponse$CertificateArn' => '<p>The Amazon Resource Name (ARN) of the issued certificate and the certificate serial number. This is of the form:</p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>/certificate/<i>286535153982981100925020015808220737245</i> </code> </p>', 'ListPermissionsRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Number (ARN) of the private CA to inspect. You can find the ARN by calling the <a>ListCertificateAuthorities</a> action. This must be of the form: <code>arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012</code> You can get a private CA\'s ARN by running the <a>ListCertificateAuthorities</a> action.</p>', 'ListTagsRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called the <a>CreateCertificateAuthority</a> action. This must be of the form: </p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>', 'Permission$CertificateAuthorityArn' => '<p>The Amazon Resource Number (ARN) of the private CA from which the permission was issued.</p>', 'RestoreCertificateAuthorityRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called the <a>CreateCertificateAuthority</a> action. This must be of the form: </p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>', 'RevokeCertificateRequest$CertificateAuthorityArn' => '<p>Amazon Resource Name (ARN) of the private CA that issued the certificate to be revoked. This must be of the form:</p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>', 'TagCertificateAuthorityRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a>CreateCertificateAuthority</a>. This must be of the form: </p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>', 'UntagCertificateAuthorityRequest$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a>CreateCertificateAuthority</a>. This must be of the form: </p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>', 'UpdateCertificateAuthorityRequest$CertificateAuthorityArn' => '<p>Amazon Resource Name (ARN) of the private CA that issued the certificate to be revoked. This must be of the form:</p> <p> <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code> </p>', ], ], 'AuditReportId' => [ 'base' => NULL, 'refs' => [ 'CreateCertificateAuthorityAuditReportResponse$AuditReportId' => '<p>An alphanumeric string that contains a report identifier.</p>', 'DescribeCertificateAuthorityAuditReportRequest$AuditReportId' => '<p>The report ID returned by calling the <a>CreateCertificateAuthorityAuditReport</a> action.</p>', ], ], 'AuditReportResponseFormat' => [ 'base' => NULL, 'refs' => [ 'CreateCertificateAuthorityAuditReportRequest$AuditReportResponseFormat' => '<p>The format in which to create the report. This can be either <b>JSON</b> or <b>CSV</b>.</p>', ], ], 'AuditReportStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeCertificateAuthorityAuditReportResponse$AuditReportStatus' => '<p>Specifies whether report creation is in progress, has succeeded, or has failed.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CrlConfiguration$Enabled' => '<p>Boolean value that specifies whether certificate revocation lists (CRLs) are enabled. You can use this value to enable certificate revocation for a new CA when you call the <a>CreateCertificateAuthority</a> action or for an existing CA when you call the <a>UpdateCertificateAuthority</a> action. </p>', ], ], 'CertificateAuthorities' => [ 'base' => NULL, 'refs' => [ 'ListCertificateAuthoritiesResponse$CertificateAuthorities' => '<p>Summary information about each certificate authority you have created.</p>', ], ], 'CertificateAuthority' => [ 'base' => '<p>Contains information about your private certificate authority (CA). Your private CA can issue and revoke X.509 digital certificates. Digital certificates verify that the entity named in the certificate <b>Subject</b> field owns or controls the public key contained in the <b>Subject Public Key Info</b> field. Call the <a>CreateCertificateAuthority</a> action to create your private CA. You must then call the <a>GetCertificateAuthorityCertificate</a> action to retrieve a private CA certificate signing request (CSR). Sign the CSR with your ACM Private CA-hosted or on-premises root or subordinate CA certificate. Call the <a>ImportCertificateAuthorityCertificate</a> action to import the signed certificate into AWS Certificate Manager (ACM). </p>', 'refs' => [ 'CertificateAuthorities$member' => NULL, 'DescribeCertificateAuthorityResponse$CertificateAuthority' => '<p>A <a>CertificateAuthority</a> structure that contains information about your private CA.</p>', ], ], 'CertificateAuthorityConfiguration' => [ 'base' => '<p>Contains configuration information for your private certificate authority (CA). This includes information about the class of public key algorithm and the key pair that your private CA creates when it issues a certificate. It also includes the signature algorithm that it uses when issuing certificates, and its X.500 distinguished name. You must specify this information when you call the <a>CreateCertificateAuthority</a> action. </p>', 'refs' => [ 'CertificateAuthority$CertificateAuthorityConfiguration' => '<p>Your private CA configuration.</p>', 'CreateCertificateAuthorityRequest$CertificateAuthorityConfiguration' => '<p>Name and bit size of the private key algorithm, the name of the signing algorithm, and X.500 certificate subject information.</p>', ], ], 'CertificateAuthorityStatus' => [ 'base' => NULL, 'refs' => [ 'CertificateAuthority$Status' => '<p>Status of your private CA.</p>', 'UpdateCertificateAuthorityRequest$Status' => '<p>Status of your private CA.</p>', ], ], 'CertificateAuthorityType' => [ 'base' => NULL, 'refs' => [ 'CertificateAuthority$Type' => '<p>Type of your private CA.</p>', 'CreateCertificateAuthorityRequest$CertificateAuthorityType' => '<p>The type of the certificate authority.</p>', ], ], 'CertificateBody' => [ 'base' => NULL, 'refs' => [ 'GetCertificateAuthorityCertificateResponse$Certificate' => '<p>Base64-encoded certificate authority (CA) certificate.</p>', 'GetCertificateResponse$Certificate' => '<p>The base64 PEM-encoded certificate specified by the <code>CertificateArn</code> parameter.</p>', ], ], 'CertificateBodyBlob' => [ 'base' => NULL, 'refs' => [ 'ImportCertificateAuthorityCertificateRequest$Certificate' => '<p>The PEM-encoded certificate for a private CA. This may be a self-signed certificate in the case of a root CA, or it may be signed by another CA that you control.</p>', ], ], 'CertificateChain' => [ 'base' => NULL, 'refs' => [ 'GetCertificateAuthorityCertificateResponse$CertificateChain' => '<p>Base64-encoded certificate chain that includes any intermediate certificates and chains up to root on-premises certificate that you used to sign your private CA certificate. The chain does not include your private CA certificate. If this is a root CA, the value will be null.</p>', 'GetCertificateResponse$CertificateChain' => '<p>The base64 PEM-encoded certificate chain that chains up to the on-premises root CA certificate that you used to sign your private CA certificate. </p>', ], ], 'CertificateChainBlob' => [ 'base' => NULL, 'refs' => [ 'ImportCertificateAuthorityCertificateRequest$CertificateChain' => '<p>A PEM-encoded file that contains all of your certificates, other than the certificate you\'re importing, chaining up to your root CA. Your ACM Private CA-hosted or on-premises root certificate is the last in the chain, and each certificate in the chain signs the one preceding. </p> <p>This parameter must be supplied when you import a subordinate CA. When you import a root CA, there is no chain.</p>', ], ], 'CertificateMismatchException' => [ 'base' => '<p>The certificate authority certificate you are importing does not comply with conditions specified in the certificate that signed it.</p>', 'refs' => [], ], 'ConcurrentModificationException' => [ 'base' => '<p>A previous update to your private CA is still ongoing.</p>', 'refs' => [], ], 'CountryCodeString' => [ 'base' => NULL, 'refs' => [ 'ASN1Subject$Country' => '<p>Two-digit code that specifies the country in which the certificate subject located.</p>', ], ], 'CreateCertificateAuthorityAuditReportRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCertificateAuthorityAuditReportResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateCertificateAuthorityRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCertificateAuthorityResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePermissionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CrlConfiguration' => [ 'base' => '<p>Contains configuration information for a certificate revocation list (CRL). Your private certificate authority (CA) creates base CRLs. Delta CRLs are not supported. You can enable CRLs for your new or an existing private CA by setting the <b>Enabled</b> parameter to <code>true</code>. Your private CA writes CRLs to an S3 bucket that you specify in the <b>S3BucketName</b> parameter. You can hide the name of your bucket by specifying a value for the <b>CustomCname</b> parameter. Your private CA copies the CNAME or the S3 bucket name to the <b>CRL Distribution Points</b> extension of each certificate it issues. Your S3 bucket policy must give write permission to ACM Private CA. </p> <p>Your private CA uses the value in the <b>ExpirationInDays</b> parameter to calculate the <b>nextUpdate</b> field in the CRL. The CRL is refreshed at 1/2 the age of next update or when a certificate is revoked. When a certificate is revoked, it is recorded in the next CRL that is generated and in the next audit report. Only time valid certificates are listed in the CRL. Expired certificates are not included. </p> <p>CRLs contain the following fields:</p> <ul> <li> <p> <b>Version</b>: The current version number defined in RFC 5280 is V2. The integer value is 0x1. </p> </li> <li> <p> <b>Signature Algorithm</b>: The name of the algorithm used to sign the CRL.</p> </li> <li> <p> <b>Issuer</b>: The X.500 distinguished name of your private CA that issued the CRL.</p> </li> <li> <p> <b>Last Update</b>: The issue date and time of this CRL.</p> </li> <li> <p> <b>Next Update</b>: The day and time by which the next CRL will be issued.</p> </li> <li> <p> <b>Revoked Certificates</b>: List of revoked certificates. Each list item contains the following information.</p> <ul> <li> <p> <b>Serial Number</b>: The serial number, in hexadecimal format, of the revoked certificate.</p> </li> <li> <p> <b>Revocation Date</b>: Date and time the certificate was revoked.</p> </li> <li> <p> <b>CRL Entry Extensions</b>: Optional extensions for the CRL entry.</p> <ul> <li> <p> <b>X509v3 CRL Reason Code</b>: Reason the certificate was revoked.</p> </li> </ul> </li> </ul> </li> <li> <p> <b>CRL Extensions</b>: Optional extensions for the CRL.</p> <ul> <li> <p> <b>X509v3 Authority Key Identifier</b>: Identifies the public key associated with the private key used to sign the certificate.</p> </li> <li> <p> <b>X509v3 CRL Number:</b>: Decimal sequence number for the CRL.</p> </li> </ul> </li> <li> <p> <b>Signature Algorithm</b>: Algorithm used by your private CA to sign the CRL.</p> </li> <li> <p> <b>Signature Value</b>: Signature computed over the CRL.</p> </li> </ul> <p>Certificate revocation lists created by ACM Private CA are DER-encoded. You can use the following OpenSSL command to list a CRL.</p> <p> <code>openssl crl -inform DER -text -in <i>crl_path</i> -noout</code> </p>', 'refs' => [ 'RevocationConfiguration$CrlConfiguration' => '<p>Configuration of the certificate revocation list (CRL), if any, maintained by your private CA.</p>', ], ], 'CsrBlob' => [ 'base' => NULL, 'refs' => [ 'IssueCertificateRequest$Csr' => '<p>The certificate signing request (CSR) for the certificate you want to issue. You can use the following OpenSSL command to create the CSR and a 2048 bit RSA private key. </p> <p> <code>openssl req -new -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr</code> </p> <p>If you have a configuration file, you can use the following OpenSSL command. The <code>usr_cert</code> block in the configuration file contains your X509 version 3 extensions. </p> <p> <code>openssl req -new -config openssl_rsa.cnf -extensions usr_cert -newkey rsa:2048 -days -365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr</code> </p>', ], ], 'CsrBody' => [ 'base' => NULL, 'refs' => [ 'GetCertificateAuthorityCsrResponse$Csr' => '<p>The base64 PEM-encoded certificate signing request (CSR) for your private CA certificate.</p>', ], ], 'DeleteCertificateAuthorityRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePermissionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCertificateAuthorityAuditReportRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCertificateAuthorityAuditReportResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCertificateAuthorityRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCertificateAuthorityResponse' => [ 'base' => NULL, 'refs' => [], ], 'DistinguishedNameQualifierString' => [ 'base' => NULL, 'refs' => [ 'ASN1Subject$DistinguishedNameQualifier' => '<p>Disambiguating information for the certificate subject.</p>', ], ], 'FailureReason' => [ 'base' => NULL, 'refs' => [ 'CertificateAuthority$FailureReason' => '<p>Reason the request to create your private CA failed.</p>', ], ], 'GetCertificateAuthorityCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCertificateAuthorityCertificateResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCertificateAuthorityCsrRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCertificateAuthorityCsrResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCertificateResponse' => [ 'base' => NULL, 'refs' => [], ], 'IdempotencyToken' => [ 'base' => NULL, 'refs' => [ 'CreateCertificateAuthorityRequest$IdempotencyToken' => '<p>Alphanumeric string that can be used to distinguish between calls to <b>CreateCertificateAuthority</b>. Idempotency tokens time out after five minutes. Therefore, if you call <b>CreateCertificateAuthority</b> multiple times with the same idempotency token within a five minute period, ACM Private CA recognizes that you are requesting only one certificate. As a result, ACM Private CA issues only one. If you change the idempotency token for each call, however, ACM Private CA recognizes that you are requesting multiple certificates.</p>', 'IssueCertificateRequest$IdempotencyToken' => '<p>Custom string that can be used to distinguish between calls to the <b>IssueCertificate</b> action. Idempotency tokens time out after one hour. Therefore, if you call <b>IssueCertificate</b> multiple times with the same idempotency token within 5 minutes, ACM Private CA recognizes that you are requesting only one certificate and will issue only one. If you change the idempotency token for each call, PCA recognizes that you are requesting multiple certificates.</p>', ], ], 'ImportCertificateAuthorityCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'Integer1To5000' => [ 'base' => NULL, 'refs' => [ 'CrlConfiguration$ExpirationInDays' => '<p>Number of days until a certificate expires.</p>', ], ], 'InvalidArgsException' => [ 'base' => '<p>One or more of the specified arguments was not valid.</p>', 'refs' => [], ], 'InvalidArnException' => [ 'base' => '<p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>', 'refs' => [], ], 'InvalidNextTokenException' => [ 'base' => '<p>The token specified in the <code>NextToken</code> argument is not valid. Use the token returned from your previous call to <a>ListCertificateAuthorities</a>.</p>', 'refs' => [], ], 'InvalidPolicyException' => [ 'base' => '<p>The S3 bucket policy is not valid. The policy must give ACM Private CA rights to read from and write to the bucket and find the bucket location.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>The request action cannot be performed or is prohibited.</p>', 'refs' => [], ], 'InvalidStateException' => [ 'base' => '<p>The private CA is in a state during which a report or certificate cannot be generated.</p>', 'refs' => [], ], 'InvalidTagException' => [ 'base' => '<p>The tag associated with the CA is not valid. The invalid argument is contained in the message field.</p>', 'refs' => [], ], 'IssueCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'IssueCertificateResponse' => [ 'base' => NULL, 'refs' => [], ], 'KeyAlgorithm' => [ 'base' => NULL, 'refs' => [ 'CertificateAuthorityConfiguration$KeyAlgorithm' => '<p>Type of the public key algorithm and size, in bits, of the key pair that your CA creates when it issues a certificate. When you create a subordinate CA, you must use a key algorithm supported by the parent CA.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>An ACM Private CA limit has been exceeded. See the exception message returned to determine the limit that was exceeded.</p>', 'refs' => [], ], 'ListCertificateAuthoritiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCertificateAuthoritiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsResponse' => [ 'base' => NULL, 'refs' => [], ], 'MalformedCSRException' => [ 'base' => '<p>The certificate signing request is invalid.</p>', 'refs' => [], ], 'MalformedCertificateException' => [ 'base' => '<p>One or more fields in the certificate are invalid.</p>', 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListCertificateAuthoritiesRequest$MaxResults' => '<p>Use this parameter when paginating results to specify the maximum number of items to return in the response on each page. If additional items exist beyond the number you specify, the <code>NextToken</code> element is sent in the response. Use this <code>NextToken</code> value in a subsequent request to retrieve additional items.</p>', 'ListPermissionsRequest$MaxResults' => '<p>When paginating results, use this parameter to specify the maximum number of items to return in the response. If additional items exist beyond the number you specify, the <b>NextToken</b> element is sent in the response. Use this <b>NextToken</b> value in a subsequent request to retrieve additional items.</p>', 'ListTagsRequest$MaxResults' => '<p>Use this parameter when paginating results to specify the maximum number of items to return in the response. If additional items exist beyond the number you specify, the <b>NextToken</b> element is sent in the response. Use this <b>NextToken</b> value in a subsequent request to retrieve additional items.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListCertificateAuthoritiesRequest$NextToken' => '<p>Use this parameter when paginating results in a subsequent request after you receive a response with truncated results. Set it to the value of the <code>NextToken</code> parameter from the response you just received.</p>', 'ListCertificateAuthoritiesResponse$NextToken' => '<p>When the list is truncated, this value is present and should be used for the <code>NextToken</code> parameter in a subsequent pagination request.</p>', 'ListPermissionsRequest$NextToken' => '<p>When paginating results, use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of <b>NextToken</b> from the response you just received.</p>', 'ListPermissionsResponse$NextToken' => '<p>When the list is truncated, this value is present and should be used for the <b>NextToken</b> parameter in a subsequent pagination request. </p>', 'ListTagsRequest$NextToken' => '<p>Use this parameter when paginating results in a subsequent request after you receive a response with truncated results. Set it to the value of <b>NextToken</b> from the response you just received.</p>', 'ListTagsResponse$NextToken' => '<p>When the list is truncated, this value is present and should be used for the <b>NextToken</b> parameter in a subsequent pagination request. </p>', ], ], 'PermanentDeletionTimeInDays' => [ 'base' => NULL, 'refs' => [ 'DeleteCertificateAuthorityRequest$PermanentDeletionTimeInDays' => '<p>The number of days to make a CA restorable after it has been deleted. This can be anywhere from 7 to 30 days, with 30 being the default.</p>', ], ], 'Permission' => [ 'base' => '<p>Permissions designate which private CA actions can be performed by an AWS service or entity. In order for ACM to automatically renew private certificates, you must give the ACM service principal all available permissions (<code>IssueCertificate</code>, <code>GetCertificate</code>, and <code>ListPermissions</code>). Permissions can be assigned with the <a>CreatePermission</a> action, removed with the <a>DeletePermission</a> action, and listed with the <a>ListPermissions</a> action.</p>', 'refs' => [ 'PermissionList$member' => NULL, ], ], 'PermissionAlreadyExistsException' => [ 'base' => '<p>The designated permission has already been given to the user.</p>', 'refs' => [], ], 'PermissionList' => [ 'base' => NULL, 'refs' => [ 'ListPermissionsResponse$Permissions' => '<p>Summary information about each permission assigned by the specified private CA, including the action enabled, the policy provided, and the time of creation.</p>', ], ], 'PositiveLong' => [ 'base' => NULL, 'refs' => [ 'Validity$Value' => '<p>Time period.</p>', ], ], 'Principal' => [ 'base' => NULL, 'refs' => [ 'CreatePermissionRequest$Principal' => '<p>The AWS service or identity that receives the permission. At this time, the only valid principal is <code>acm.amazonaws.com</code>.</p>', 'DeletePermissionRequest$Principal' => '<p>The AWS service or identity that will have its CA permissions revoked. At this time, the only valid service principal is <code>acm.amazonaws.com</code> </p>', ], ], 'RequestAlreadyProcessedException' => [ 'base' => '<p>Your request has already been completed.</p>', 'refs' => [], ], 'RequestFailedException' => [ 'base' => '<p>The request has failed for an unspecified reason.</p>', 'refs' => [], ], 'RequestInProgressException' => [ 'base' => '<p>Your request is already in progress.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>A resource such as a private CA, S3 bucket, certificate, or audit report cannot be found.</p>', 'refs' => [], ], 'RestoreCertificateAuthorityRequest' => [ 'base' => NULL, 'refs' => [], ], 'RevocationConfiguration' => [ 'base' => '<p>Certificate revocation information used by the <a>CreateCertificateAuthority</a> and <a>UpdateCertificateAuthority</a> actions. Your private certificate authority (CA) can create and maintain a certificate revocation list (CRL). A CRL contains information about certificates revoked by your CA. For more information, see <a>RevokeCertificate</a>.</p>', 'refs' => [ 'CertificateAuthority$RevocationConfiguration' => '<p>Information about the certificate revocation list (CRL) created and maintained by your private CA. </p>', 'CreateCertificateAuthorityRequest$RevocationConfiguration' => '<p>Contains a Boolean value that you can use to enable a certification revocation list (CRL) for the CA, the name of the S3 bucket to which ACM Private CA will write the CRL, and an optional CNAME alias that you can use to hide the name of your bucket in the <b>CRL Distribution Points</b> extension of your CA certificate. For more information, see the <a>CrlConfiguration</a> structure. </p>', 'UpdateCertificateAuthorityRequest$RevocationConfiguration' => '<p>Revocation information for your private CA.</p>', ], ], 'RevocationReason' => [ 'base' => NULL, 'refs' => [ 'RevokeCertificateRequest$RevocationReason' => '<p>Specifies why you revoked the certificate.</p>', ], ], 'RevokeCertificateRequest' => [ 'base' => NULL, 'refs' => [], ], 'SigningAlgorithm' => [ 'base' => NULL, 'refs' => [ 'CertificateAuthorityConfiguration$SigningAlgorithm' => '<p>Name of the algorithm your private CA uses to sign certificate requests.</p>', 'IssueCertificateRequest$SigningAlgorithm' => '<p>The name of the algorithm that will be used to sign the certificate to be issued.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'CertificateAuthority$Serial' => '<p>Serial number of your private CA.</p>', 'CertificateMismatchException$message' => NULL, 'ConcurrentModificationException$message' => NULL, 'CreateCertificateAuthorityAuditReportRequest$S3BucketName' => '<p>The name of the S3 bucket that will contain the audit report.</p>', 'CreateCertificateAuthorityAuditReportResponse$S3Key' => '<p>The <b>key</b> that uniquely identifies the report file in your S3 bucket.</p>', 'DescribeCertificateAuthorityAuditReportResponse$S3BucketName' => '<p>Name of the S3 bucket that contains the report.</p>', 'DescribeCertificateAuthorityAuditReportResponse$S3Key' => '<p>S3 <b>key</b> that uniquely identifies the report file in your S3 bucket.</p>', 'InvalidArgsException$message' => NULL, 'InvalidArnException$message' => NULL, 'InvalidNextTokenException$message' => NULL, 'InvalidPolicyException$message' => NULL, 'InvalidRequestException$message' => NULL, 'InvalidStateException$message' => NULL, 'InvalidTagException$message' => NULL, 'LimitExceededException$message' => NULL, 'MalformedCSRException$message' => NULL, 'MalformedCertificateException$message' => NULL, 'Permission$Principal' => '<p>The AWS service or entity that holds the permission. At this time, the only valid principal is <code>acm.amazonaws.com</code>.</p>', 'Permission$SourceAccount' => '<p>The ID of the account that assigned the permission.</p>', 'Permission$Policy' => '<p>The name of the policy that is associated with the permission.</p>', 'PermissionAlreadyExistsException$message' => NULL, 'RequestAlreadyProcessedException$message' => NULL, 'RequestFailedException$message' => NULL, 'RequestInProgressException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'TooManyTagsException$message' => NULL, ], ], 'String128' => [ 'base' => NULL, 'refs' => [ 'ASN1Subject$State' => '<p>State in which the subject of the certificate is located.</p>', 'ASN1Subject$Locality' => '<p>The locality (such as a city or town) in which the certificate subject is located.</p>', 'ASN1Subject$Pseudonym' => '<p>Typically a shortened version of a longer <b>GivenName</b>. For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth, Liz, or Eliza.</p>', 'RevokeCertificateRequest$CertificateSerial' => '<p>Serial number of the certificate to be revoked. This must be in hexadecimal format. You can retrieve the serial number by calling <a>GetCertificate</a> with the Amazon Resource Name (ARN) of the certificate you want and the ARN of your private CA. The <b>GetCertificate</b> action retrieves the certificate in the PEM format. You can use the following OpenSSL command to list the certificate in text format and copy the hexadecimal serial number. </p> <p> <code>openssl x509 -in <i>file_path</i> -text -noout</code> </p> <p>You can also copy the serial number from the console or use the <a href="https://docs.aws.amazon.com/acm/latest/APIReference/API_DescribeCertificate.html">DescribeCertificate</a> action in the <i>AWS Certificate Manager API Reference</i>. </p>', ], ], 'String16' => [ 'base' => NULL, 'refs' => [ 'ASN1Subject$GivenName' => '<p>First name.</p>', ], ], 'String253' => [ 'base' => NULL, 'refs' => [ 'CrlConfiguration$CustomCname' => '<p>Name inserted into the certificate <b>CRL Distribution Points</b> extension that enables the use of an alias for the CRL distribution point. Use this value if you don\'t want the name of your S3 bucket to be public.</p>', ], ], 'String3' => [ 'base' => NULL, 'refs' => [ 'ASN1Subject$GenerationQualifier' => '<p>Typically a qualifier appended to the name of an individual. Examples include Jr. for junior, Sr. for senior, and III for third.</p>', ], ], 'String3To255' => [ 'base' => NULL, 'refs' => [ 'CrlConfiguration$S3BucketName' => '<p>Name of the S3 bucket that contains the CRL. If you do not provide a value for the <b>CustomCname</b> argument, the name of your S3 bucket is placed into the <b>CRL Distribution Points</b> extension of the issued certificate. You can change the name of your bucket by calling the <a>UpdateCertificateAuthority</a> action. You must specify a bucket policy that allows ACM Private CA to write the CRL to your bucket.</p>', ], ], 'String40' => [ 'base' => NULL, 'refs' => [ 'ASN1Subject$Surname' => '<p>Family name. In the US and the UK, for example, the surname of an individual is ordered last. In Asian cultures the surname is typically ordered first.</p>', ], ], 'String5' => [ 'base' => NULL, 'refs' => [ 'ASN1Subject$Initials' => '<p>Concatenation that typically contains the first letter of the <b>GivenName</b>, the first letter of the middle name if one exists, and the first letter of the <b>SurName</b>.</p>', ], ], 'String64' => [ 'base' => NULL, 'refs' => [ 'ASN1Subject$Organization' => '<p>Legal name of the organization with which the certificate subject is affiliated. </p>', 'ASN1Subject$OrganizationalUnit' => '<p>A subdivision or unit of the organization (such as sales or finance) with which the certificate subject is affiliated.</p>', 'ASN1Subject$CommonName' => '<p>Fully qualified domain name (FQDN) associated with the certificate subject.</p>', 'ASN1Subject$SerialNumber' => '<p>The certificate serial number.</p>', 'ASN1Subject$Title' => '<p>A title such as Mr. or Ms., which is pre-pended to the name to refer formally to the certificate subject.</p>', ], ], 'TStamp' => [ 'base' => NULL, 'refs' => [ 'CertificateAuthority$CreatedAt' => '<p>Date and time at which your private CA was created.</p>', 'CertificateAuthority$LastStateChangeAt' => '<p>Date and time at which your private CA was last updated.</p>', 'CertificateAuthority$NotBefore' => '<p>Date and time before which your private CA certificate is not valid.</p>', 'CertificateAuthority$NotAfter' => '<p>Date and time after which your private CA certificate is not valid.</p>', 'CertificateAuthority$RestorableUntil' => '<p>The period during which a deleted CA can be restored. For more information, see the <code>PermanentDeletionTimeInDays</code> parameter of the <a>DeleteCertificateAuthorityRequest</a> action. </p>', 'DescribeCertificateAuthorityAuditReportResponse$CreatedAt' => '<p>The date and time at which the report was created.</p>', 'Permission$CreatedAt' => '<p>The time at which the permission was created.</p>', ], ], 'Tag' => [ 'base' => '<p>Tags are labels that you can use to identify and organize your private CAs. Each tag consists of a key and an optional value. You can associate up to 50 tags with a private CA. To add one or more tags to a private CA, call the <a>TagCertificateAuthority</a> action. To remove a tag, call the <a>UntagCertificateAuthority</a> action. </p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagCertificateAuthorityRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>Key (name) of the tag.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateCertificateAuthorityRequest$Tags' => '<p>Key-value pairs that will be attached to the new private CA. You can associate up to 50 tags with a private CA. For information using tags with </p> <p>IAM to manage permissions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags</a>.</p>', 'ListTagsResponse$Tags' => '<p>The tags associated with your private CA.</p>', 'TagCertificateAuthorityRequest$Tags' => '<p>List of tags to be associated with the CA.</p>', 'UntagCertificateAuthorityRequest$Tags' => '<p>List of tags to be removed from the CA.</p>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>Value of the tag.</p>', ], ], 'TooManyTagsException' => [ 'base' => '<p>You can associate up to 50 tags with a private CA. Exception information is contained in the exception message field.</p>', 'refs' => [], ], 'UntagCertificateAuthorityRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCertificateAuthorityRequest' => [ 'base' => NULL, 'refs' => [], ], 'Validity' => [ 'base' => '<p>Length of time for which the certificate issued by your private certificate authority (CA), or by the private CA itself, is valid in days, months, or years. You can issue a certificate by calling the <a>IssueCertificate</a> action.</p>', 'refs' => [ 'IssueCertificateRequest$Validity' => '<p>The type of the validity period.</p>', ], ], 'ValidityPeriodType' => [ 'base' => NULL, 'refs' => [ 'Validity$Type' => '<p>Specifies whether the <code>Value</code> parameter represents days, months, or years.</p>', ], ], ],];
