<?php
// This file was auto-generated from sdk-root/src/data/accessanalyzer/2019-11-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>AWS IAM Access Analyzer helps identify potential resource-access risks by enabling you to identify any policies that grant access to an external principal. It does this by using logic-based reasoning to analyze resource-based policies in your AWS environment. An external principal can be another AWS account, a root user, an IAM user or role, a federated user, an AWS service, or an anonymous user. This guide describes the AWS IAM Access Analyzer operations that you can call programmatically. For general information about Access Analyzer, see the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/what-is-access-analyzer.html">AWS IAM Access Analyzer section of the IAM User Guide</a>.</p> <p>To start using Access Analyzer, you first need to create an analyzer.</p>', 'operations' => [ 'CreateAnalyzer' => '<p>Creates an analyzer for your account.</p>', 'CreateArchiveRule' => '<p>Creates an archive rule for the specified analyzer. Archive rules automatically archive findings that meet the criteria you define when you create the rule.</p>', 'DeleteAnalyzer' => '<p>Deletes the specified analyzer. When you delete an analyzer, Access Analyzer is disabled for the account in the current or specific Region. All findings that were generated by the analyzer are deleted. You cannot undo this action.</p>', 'DeleteArchiveRule' => '<p>Deletes the specified archive rule.</p>', 'GetAnalyzedResource' => '<p>Retrieves information about a resource that was analyzed.</p>', 'GetAnalyzer' => '<p>Retrieves information about the specified analyzer.</p>', 'GetArchiveRule' => '<p>Retrieves information about an archive rule.</p>', 'GetFinding' => '<p>Retrieves information about the specified finding.</p>', 'ListAnalyzedResources' => '<p>Retrieves a list of resources of the specified type that have been analyzed by the specified analyzer..</p>', 'ListAnalyzers' => '<p>Retrieves a list of analyzers.</p>', 'ListArchiveRules' => '<p>Retrieves a list of archive rules created for the specified analyzer.</p>', 'ListFindings' => '<p>Retrieves a list of findings generated by the specified analyzer.</p>', 'ListTagsForResource' => '<p>Retrieves a list of tags applied to the specified resource.</p>', 'StartResourceScan' => '<p>Immediately starts a scan of the policies applied to the specified resource.</p>', 'TagResource' => '<p>Adds a tag to the specified resource.</p>', 'UntagResource' => '<p>Removes a tag from the specified resource.</p>', 'UpdateArchiveRule' => '<p>Updates the criteria and values for the specified archive rule.</p>', 'UpdateFindings' => '<p>Updates the status for the specified findings.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'ActionList' => [ 'base' => NULL, 'refs' => [ 'AnalyzedResource$actions' => '<p>The actions that an external principal is granted permission to use by the policy that generated the finding.</p>', 'Finding$action' => '<p>The action in the analyzed policy statement that an external principal has permission to use.</p>', 'FindingSummary$action' => '<p>The action in the analyzed policy statement that an external principal has permission to use.</p>', ], ], 'AnalyzedResource' => [ 'base' => '<p>Contains details about the analyzed resource.</p>', 'refs' => [ 'GetAnalyzedResourceResponse$resource' => '<p>An <code>AnalyedResource</code> object that contains information that Access Analyzer found when it analyzed the resource.</p>', ], ], 'AnalyzedResourceSummary' => [ 'base' => '<p>Contains the ARN of the analyzed resource.</p>', 'refs' => [ 'AnalyzedResourcesList$member' => NULL, ], ], 'AnalyzedResourcesList' => [ 'base' => NULL, 'refs' => [ 'ListAnalyzedResourcesResponse$analyzedResources' => '<p>A list of resources that were analyzed.</p>', ], ], 'AnalyzerArn' => [ 'base' => NULL, 'refs' => [ 'AnalyzerSummary$arn' => '<p>The ARN of the analyzer.</p>', 'CreateAnalyzerResponse$arn' => '<p>The ARN of the analyzer that was created by the request.</p>', 'GetAnalyzedResourceRequest$analyzerArn' => '<p>The ARN of the analyzer to retrieve information from.</p>', 'GetFindingRequest$analyzerArn' => '<p>The ARN of the analyzer that generated the finding.</p>', 'ListAnalyzedResourcesRequest$analyzerArn' => '<p>The ARN of the analyzer to retrieve a list of analyzed resources from.</p>', 'ListFindingsRequest$analyzerArn' => '<p>The ARN of the analyzer to retrieve findings from.</p>', 'StartResourceScanRequest$analyzerArn' => '<p>The ARN of the analyzer to use to scan the policies applied to the specified resource.</p>', 'UpdateFindingsRequest$analyzerArn' => '<p>The ARN of the analyzer that generated the findings to update.</p>', ], ], 'AnalyzerStatus' => [ 'base' => NULL, 'refs' => [ 'AnalyzerSummary$status' => '<p>The status of the analyzer. An <code>Active</code> analyzer successfully monitors supported resources and generates new findings. The analyzer is <code>Disabled</code> when a user action, such as removing trusted access for IAM Access Analyzer from AWS Organizations, causes the analyzer to stop generating new findings. The status is <code>Creating</code> when the analyzer creation is in progress and <code>Failed</code> when the analyzer creation has failed. </p>', ], ], 'AnalyzerSummary' => [ 'base' => '<p>Contains information about the analyzer.</p>', 'refs' => [ 'AnalyzersList$member' => NULL, 'GetAnalyzerResponse$analyzer' => '<p>An <code>AnalyzerSummary</code> object that contains information about the analyzer.</p>', ], ], 'AnalyzersList' => [ 'base' => NULL, 'refs' => [ 'ListAnalyzersResponse$analyzers' => '<p>The analyzers retrieved.</p>', ], ], 'ArchiveRuleSummary' => [ 'base' => '<p>Contains information about an archive rule.</p>', 'refs' => [ 'ArchiveRulesList$member' => NULL, 'GetArchiveRuleResponse$archiveRule' => NULL, ], ], 'ArchiveRulesList' => [ 'base' => NULL, 'refs' => [ 'ListArchiveRulesResponse$archiveRules' => '<p>A list of archive rules created for the specified analyzer.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AnalyzedResource$isPublic' => '<p>Indicates whether the policy that generated the finding grants public access to the resource.</p>', 'Criterion$exists' => '<p>An "exists" operator to match for the filter used to create the rule. </p>', 'Finding$isPublic' => '<p>Indicates whether the policy that generated the finding allows public access to the resource.</p>', 'FindingSummary$isPublic' => '<p>Indicates whether the finding reports a resource that has a policy that allows public access.</p>', ], ], 'ConditionKeyMap' => [ 'base' => NULL, 'refs' => [ 'Finding$condition' => '<p>The condition in the analyzed policy statement that resulted in a finding.</p>', 'FindingSummary$condition' => '<p>The condition in the analyzed policy statement that resulted in a finding.</p>', ], ], 'ConflictException' => [ 'base' => '<p>A conflict exception error.</p>', 'refs' => [], ], 'CreateAnalyzerRequest' => [ 'base' => '<p>Creates an analyzer.</p>', 'refs' => [], ], 'CreateAnalyzerResponse' => [ 'base' => '<p>The response to the request to create an analyzer.</p>', 'refs' => [], ], 'CreateArchiveRuleRequest' => [ 'base' => '<p>Creates an archive rule.</p>', 'refs' => [], ], 'Criterion' => [ 'base' => '<p>The criteria to use in the filter that defines the archive rule.</p>', 'refs' => [ 'FilterCriteriaMap$value' => NULL, ], ], 'DeleteAnalyzerRequest' => [ 'base' => '<p>Deletes an analyzer.</p>', 'refs' => [], ], 'DeleteArchiveRuleRequest' => [ 'base' => '<p>Deletes an archive rule.</p>', 'refs' => [], ], 'FilterCriteriaMap' => [ 'base' => NULL, 'refs' => [ 'ArchiveRuleSummary$filter' => '<p>A filter used to define the archive rule.</p>', 'CreateArchiveRuleRequest$filter' => '<p>The criteria for the rule.</p>', 'InlineArchiveRule$filter' => '<p>The condition and values for a criterion.</p>', 'ListFindingsRequest$filter' => '<p>A filter to match for the findings to return.</p>', 'UpdateArchiveRuleRequest$filter' => '<p>A filter to match for the rules to update. Only rules that match the filter are updated.</p>', ], ], 'Finding' => [ 'base' => '<p>Contains information about a finding.</p>', 'refs' => [ 'GetFindingResponse$finding' => '<p>A <code>finding</code> object that contains finding details.</p>', ], ], 'FindingId' => [ 'base' => NULL, 'refs' => [ 'Finding$id' => '<p>The ID of the finding.</p>', 'FindingIdList$member' => NULL, 'FindingSummary$id' => '<p>The ID of the finding.</p>', 'GetFindingRequest$id' => '<p>The ID of the finding to retrieve.</p>', ], ], 'FindingIdList' => [ 'base' => NULL, 'refs' => [ 'UpdateFindingsRequest$ids' => '<p>The IDs of the findings to update.</p>', ], ], 'FindingSource' => [ 'base' => '<p>The source of the finding. This indicates how the access that generated the finding is granted. It is populated for Amazon S3 bucket findings.</p>', 'refs' => [ 'FindingSourceList$member' => NULL, ], ], 'FindingSourceDetail' => [ 'base' => '<p>Includes details about how the access that generated the finding is granted. This is populated for Amazon S3 bucket findings.</p>', 'refs' => [ 'FindingSource$detail' => '<p>Includes details about how the access that generated the finding is granted. This is populated for Amazon S3 bucket findings.</p>', ], ], 'FindingSourceList' => [ 'base' => NULL, 'refs' => [ 'Finding$sources' => '<p>The sources of the finding. This indicates how the access that generated the finding is granted. It is populated for Amazon S3 bucket findings.</p>', 'FindingSummary$sources' => '<p>The sources of the finding. This indicates how the access that generated the finding is granted. It is populated for Amazon S3 bucket findings.</p>', ], ], 'FindingSourceType' => [ 'base' => NULL, 'refs' => [ 'FindingSource$type' => '<p>Indicates the type of access that generated the finding.</p>', ], ], 'FindingStatus' => [ 'base' => NULL, 'refs' => [ 'AnalyzedResource$status' => '<p>The current status of the finding generated from the analyzed resource.</p>', 'Finding$status' => '<p>The current status of the finding.</p>', 'FindingSummary$status' => '<p>The status of the finding.</p>', ], ], 'FindingStatusUpdate' => [ 'base' => NULL, 'refs' => [ 'UpdateFindingsRequest$status' => '<p>The state represents the action to take to update the finding Status. Use <code>ARCHIVE</code> to change an Active finding to an Archived finding. Use <code>ACTIVE</code> to change an Archived finding to an Active finding.</p>', ], ], 'FindingSummary' => [ 'base' => '<p>Contains information about a finding.</p>', 'refs' => [ 'FindingsList$member' => NULL, ], ], 'FindingsList' => [ 'base' => NULL, 'refs' => [ 'ListFindingsResponse$findings' => '<p>A list of findings retrieved from the analyzer that match the filter criteria specified, if any.</p>', ], ], 'GetAnalyzedResourceRequest' => [ 'base' => '<p>Retrieves an analyzed resource.</p>', 'refs' => [], ], 'GetAnalyzedResourceResponse' => [ 'base' => '<p>The response to the request.</p>', 'refs' => [], ], 'GetAnalyzerRequest' => [ 'base' => '<p>Retrieves an analyzer.</p>', 'refs' => [], ], 'GetAnalyzerResponse' => [ 'base' => '<p>The response to the request.</p>', 'refs' => [], ], 'GetArchiveRuleRequest' => [ 'base' => '<p>Retrieves an archive rule.</p>', 'refs' => [], ], 'GetArchiveRuleResponse' => [ 'base' => '<p>The response to the request.</p>', 'refs' => [], ], 'GetFindingRequest' => [ 'base' => '<p>Retrieves a finding.</p>', 'refs' => [], ], 'GetFindingResponse' => [ 'base' => '<p>The response to the request.</p>', 'refs' => [], ], 'InlineArchiveRule' => [ 'base' => '<p>An criterion statement in an archive rule. Each archive rule may have multiple criteria.</p>', 'refs' => [ 'InlineArchiveRulesList$member' => NULL, ], ], 'InlineArchiveRulesList' => [ 'base' => NULL, 'refs' => [ 'CreateAnalyzerRequest$archiveRules' => '<p>Specifies the archive rules to add for the analyzer. Archive rules automatically archive findings that meet the criteria you define for the rule.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$retryAfterSeconds' => '<p>The seconds to wait to retry.</p>', 'ListAnalyzedResourcesRequest$maxResults' => '<p>The maximum number of results to return in the response.</p>', 'ListAnalyzersRequest$maxResults' => '<p>The maximum number of results to return in the response.</p>', 'ListArchiveRulesRequest$maxResults' => '<p>The maximum number of results to return in the request.</p>', 'ListFindingsRequest$maxResults' => '<p>The maximum number of results to return in the response.</p>', 'ThrottlingException$retryAfterSeconds' => '<p>The seconds to wait to retry.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>Internal server error.</p>', 'refs' => [], ], 'ListAnalyzedResourcesRequest' => [ 'base' => '<p>Retrieves a list of resources that have been analyzed.</p>', 'refs' => [], ], 'ListAnalyzedResourcesResponse' => [ 'base' => '<p>The response to the request.</p>', 'refs' => [], ], 'ListAnalyzersRequest' => [ 'base' => '<p>Retrieves a list of analyzers.</p>', 'refs' => [], ], 'ListAnalyzersResponse' => [ 'base' => '<p>The response to the request.</p>', 'refs' => [], ], 'ListArchiveRulesRequest' => [ 'base' => '<p>Retrieves a list of archive rules created for the specified analyzer.</p>', 'refs' => [], ], 'ListArchiveRulesResponse' => [ 'base' => '<p>The response to the request.</p>', 'refs' => [], ], 'ListFindingsRequest' => [ 'base' => '<p>Retrieves a list of findings generated by the specified analyzer.</p>', 'refs' => [], ], 'ListFindingsResponse' => [ 'base' => '<p>The response to the request.</p>', 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => '<p>Retrieves a list of tags applied to the specified resource.</p>', 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => '<p>The response to the request.</p>', 'refs' => [], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'AnalyzerSummary$name' => '<p>The name of the analyzer.</p>', 'ArchiveRuleSummary$ruleName' => '<p>The name of the archive rule.</p>', 'CreateAnalyzerRequest$analyzerName' => '<p>The name of the analyzer to create.</p>', 'CreateArchiveRuleRequest$analyzerName' => '<p>The name of the created analyzer.</p>', 'CreateArchiveRuleRequest$ruleName' => '<p>The name of the rule to create.</p>', 'DeleteAnalyzerRequest$analyzerName' => '<p>The name of the analyzer to delete.</p>', 'DeleteArchiveRuleRequest$analyzerName' => '<p>The name of the analyzer that associated with the archive rule to delete.</p>', 'DeleteArchiveRuleRequest$ruleName' => '<p>The name of the rule to delete.</p>', 'GetAnalyzerRequest$analyzerName' => '<p>The name of the analyzer retrieved.</p>', 'GetArchiveRuleRequest$analyzerName' => '<p>The name of the analyzer to retrieve rules from.</p>', 'GetArchiveRuleRequest$ruleName' => '<p>The name of the rule to retrieve.</p>', 'InlineArchiveRule$ruleName' => '<p>The name of the rule.</p>', 'ListArchiveRulesRequest$analyzerName' => '<p>The name of the analyzer to retrieve rules from.</p>', 'UpdateArchiveRuleRequest$analyzerName' => '<p>The name of the analyzer to update the archive rules for.</p>', 'UpdateArchiveRuleRequest$ruleName' => '<p>The name of the rule to update.</p>', ], ], 'OrderBy' => [ 'base' => NULL, 'refs' => [ 'SortCriteria$orderBy' => '<p>The sort order, ascending or descending.</p>', ], ], 'PrincipalMap' => [ 'base' => NULL, 'refs' => [ 'Finding$principal' => '<p>The external principal that access to a resource within the zone of trust.</p>', 'FindingSummary$principal' => '<p>The external principal that has access to a resource within the zone of trust.</p>', ], ], 'ReasonCode' => [ 'base' => NULL, 'refs' => [ 'StatusReason$code' => '<p>The reason code for the current status of the analyzer.</p>', ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'AnalyzedResource$resourceArn' => '<p>The ARN of the resource that was analyzed.</p>', 'AnalyzedResourceSummary$resourceArn' => '<p>The ARN of the analyzed resource.</p>', 'GetAnalyzedResourceRequest$resourceArn' => '<p>The ARN of the resource to retrieve information about.</p>', 'StartResourceScanRequest$resourceArn' => '<p>The ARN of the resource to scan.</p>', 'UpdateFindingsRequest$resourceArn' => '<p>The ARN of the resource identified in the finding.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource could not be found.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'AnalyzedResource$resourceType' => '<p>The type of the resource that was analyzed.</p>', 'AnalyzedResourceSummary$resourceType' => '<p>The type of resource that was analyzed.</p>', 'Finding$resourceType' => '<p>The type of the resource reported in the finding.</p>', 'FindingSummary$resourceType' => '<p>The type of the resource that the external principal has access to.</p>', 'ListAnalyzedResourcesRequest$resourceType' => '<p>The type of resource.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>Service quote met error.</p>', 'refs' => [], ], 'SharedViaList' => [ 'base' => NULL, 'refs' => [ 'AnalyzedResource$sharedVia' => '<p>Indicates how the access that generated the finding is granted. This is populated for Amazon S3 bucket findings.</p>', ], ], 'SortCriteria' => [ 'base' => '<p>The criteria used to sort.</p>', 'refs' => [ 'ListFindingsRequest$sort' => '<p>The sort order for the findings returned.</p>', ], ], 'StartResourceScanRequest' => [ 'base' => '<p>Starts a scan of the policies applied to the specified resource.</p>', 'refs' => [], ], 'StatusReason' => [ 'base' => '<p>Provides more details about the current status of the analyzer. For example, if the creation for the analyzer fails, a <code>Failed</code> status is displayed. For an analyzer with organization as the type, this failure can be due to an issue with creating the service-linked roles required in the member accounts of the AWS organization.</p>', 'refs' => [ 'AnalyzerSummary$statusReason' => '<p>The <code>statusReason</code> provides more details about the current status of the analyzer. For example, if the creation for the analyzer fails, a <code>Failed</code> status is displayed. For an analyzer with organization as the type, this failure can be due to an issue with creating the service-linked roles required in the member accounts of the AWS organization.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ActionList$member' => NULL, 'AnalyzedResource$error' => '<p>An error message.</p>', 'AnalyzedResource$resourceOwnerAccount' => '<p>The AWS account ID that owns the resource.</p>', 'AnalyzedResourceSummary$resourceOwnerAccount' => '<p>The AWS account ID that owns the resource.</p>', 'AnalyzerSummary$lastResourceAnalyzed' => '<p>The resource that was most recently analyzed by the analyzer.</p>', 'ConditionKeyMap$key' => NULL, 'ConditionKeyMap$value' => NULL, 'ConflictException$message' => NULL, 'ConflictException$resourceId' => '<p>The ID of the resource.</p>', 'ConflictException$resourceType' => '<p>The resource type.</p>', 'CreateAnalyzerRequest$clientToken' => '<p>A client token.</p>', 'CreateArchiveRuleRequest$clientToken' => '<p>A client token.</p>', 'DeleteAnalyzerRequest$clientToken' => '<p>A client token.</p>', 'DeleteArchiveRuleRequest$clientToken' => '<p>A client token.</p>', 'FilterCriteriaMap$key' => NULL, 'Finding$error' => '<p>An error.</p>', 'Finding$resource' => '<p>The resource that an external principal has access to.</p>', 'Finding$resourceOwnerAccount' => '<p>The AWS account ID that owns the resource.</p>', 'FindingSourceDetail$accessPointArn' => '<p>The ARN of the access point that generated the finding.</p>', 'FindingSummary$error' => '<p>The error that resulted in an Error finding.</p>', 'FindingSummary$resource' => '<p>The resource that the external principal has access to.</p>', 'FindingSummary$resourceOwnerAccount' => '<p>The AWS account ID that owns the resource.</p>', 'InternalServerException$message' => NULL, 'ListTagsForResourceRequest$resourceArn' => '<p>The ARN of the resource to retrieve tags from.</p>', 'PrincipalMap$key' => NULL, 'PrincipalMap$value' => NULL, 'ResourceNotFoundException$message' => NULL, 'ResourceNotFoundException$resourceId' => '<p>The ID of the resource.</p>', 'ResourceNotFoundException$resourceType' => '<p>The type of the resource.</p>', 'ServiceQuotaExceededException$message' => NULL, 'ServiceQuotaExceededException$resourceId' => '<p>The resource ID.</p>', 'ServiceQuotaExceededException$resourceType' => '<p>The resource type.</p>', 'SharedViaList$member' => NULL, 'SortCriteria$attributeName' => '<p>The name of the attribute to sort on.</p>', 'TagKeys$member' => NULL, 'TagResourceRequest$resourceArn' => '<p>The ARN of the resource to add the tag to.</p>', 'TagsMap$key' => NULL, 'TagsMap$value' => NULL, 'ThrottlingException$message' => NULL, 'UntagResourceRequest$resourceArn' => '<p>The ARN of the resource to remove the tag from.</p>', 'UpdateArchiveRuleRequest$clientToken' => '<p>A client token.</p>', 'UpdateFindingsRequest$clientToken' => '<p>A client token.</p>', 'ValidationException$message' => NULL, 'ValidationExceptionField$message' => '<p>A message about the validation exception.</p>', 'ValidationExceptionField$name' => '<p>The name of the validation exception.</p>', 'ValueList$member' => NULL, ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The key for the tag to add.</p>', ], ], 'TagResourceRequest' => [ 'base' => '<p>Adds a tag to the specified resource.</p>', 'refs' => [], ], 'TagResourceResponse' => [ 'base' => '<p>The response to the request.</p>', 'refs' => [], ], 'TagsMap' => [ 'base' => NULL, 'refs' => [ 'AnalyzerSummary$tags' => '<p>The tags added to the analyzer.</p>', 'CreateAnalyzerRequest$tags' => '<p>The tags to apply to the analyzer.</p>', 'ListTagsForResourceResponse$tags' => '<p>The tags that are applied to the specified resource.</p>', 'TagResourceRequest$tags' => '<p>The tags to add to the resource.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>Throttling limit exceeded error.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AnalyzedResource$analyzedAt' => '<p>The time at which the resource was analyzed.</p>', 'AnalyzedResource$createdAt' => '<p>The time at which the finding was created.</p>', 'AnalyzedResource$updatedAt' => '<p>The time at which the finding was updated.</p>', 'AnalyzerSummary$createdAt' => '<p>A timestamp for the time at which the analyzer was created.</p>', 'AnalyzerSummary$lastResourceAnalyzedAt' => '<p>The time at which the most recently analyzed resource was analyzed.</p>', 'ArchiveRuleSummary$createdAt' => '<p>The time at which the archive rule was created.</p>', 'ArchiveRuleSummary$updatedAt' => '<p>The time at which the archive rule was last updated.</p>', 'Finding$analyzedAt' => '<p>The time at which the resource was analyzed.</p>', 'Finding$createdAt' => '<p>The time at which the finding was generated.</p>', 'Finding$updatedAt' => '<p>The time at which the finding was updated.</p>', 'FindingSummary$analyzedAt' => '<p>The time at which the resource-based policy that generated the finding was analyzed.</p>', 'FindingSummary$createdAt' => '<p>The time at which the finding was created.</p>', 'FindingSummary$updatedAt' => '<p>The time at which the finding was most recently updated.</p>', ], ], 'Token' => [ 'base' => NULL, 'refs' => [ 'ListAnalyzedResourcesRequest$nextToken' => '<p>A token used for pagination of results returned.</p>', 'ListAnalyzedResourcesResponse$nextToken' => '<p>A token used for pagination of results returned.</p>', 'ListAnalyzersRequest$nextToken' => '<p>A token used for pagination of results returned.</p>', 'ListAnalyzersResponse$nextToken' => '<p>A token used for pagination of results returned.</p>', 'ListArchiveRulesRequest$nextToken' => '<p>A token used for pagination of results returned.</p>', 'ListArchiveRulesResponse$nextToken' => '<p>A token used for pagination of results returned.</p>', 'ListFindingsRequest$nextToken' => '<p>A token used for pagination of results returned.</p>', 'ListFindingsResponse$nextToken' => '<p>A token used for pagination of results returned.</p>', ], ], 'Type' => [ 'base' => NULL, 'refs' => [ 'AnalyzerSummary$type' => '<p>The type of analyzer, which corresponds to the zone of trust chosen for the analyzer.</p>', 'CreateAnalyzerRequest$type' => '<p>The type of analyzer to create. Only ACCOUNT analyzers are supported. You can create only one analyzer per account per Region.</p>', 'ListAnalyzersRequest$type' => '<p>The type of analyzer.</p>', ], ], 'UntagResourceRequest' => [ 'base' => '<p>Removes a tag from the specified resource.</p>', 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => '<p>The response to the request.</p>', 'refs' => [], ], 'UpdateArchiveRuleRequest' => [ 'base' => '<p>Updates the specified archive rule.</p>', 'refs' => [], ], 'UpdateFindingsRequest' => [ 'base' => '<p>Updates findings with the new values provided in the request.</p>', 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>Validation exception error.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>Contains information about a validation exception.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fieldList' => '<p>A list of fields that didn\'t validate.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p>The reason for the exception.</p>', ], ], 'ValueList' => [ 'base' => NULL, 'refs' => [ 'Criterion$contains' => '<p>A "contains" operator to match for the filter used to create the rule.</p>', 'Criterion$eq' => '<p>An "equals" operator to match for the filter used to create the rule.</p>', 'Criterion$neq' => '<p>A "not equals" operator to match for the filter used to create the rule.</p>', ], ], ],];
