<?php $__env->startSection('content'); ?>

    <div id="login-form">
        <div class="uk-container uk-container-expand uk-margin-medium-top">
            <div uk-grid>
                <div class="uk-width-xlarge@s uk-width-large uk-margin margin-auto" >
                    <div class="login-card">
                        <?php if(session()->has('message')): ?>
                            <div class="alert alert-success">
                                <?php echo e(session()->get('message')); ?>

                            </div>
                        <?php endif; ?>
                        <div class="uk-grid header-page">
                            <div class="uk-width-1-3"><i class="material-icons">language</i></div>
                            <div class="uk-width-1-3"><p class="uk-text-center p-login-lable uk-margin-medium-bottom">خرید سامانه</p></div>
                            <div class="uk-width-1-3 uk-text-left"><a href="/<?php echo e($lang); ?>/shop"><i class="material-icons">arrow_back</i></a></div>
                        </div>
                        <ul uk-accordion>
                            <li class="card">
                                <a class="uk-accordion-title">سامانه یکیتا</a>
                                <div class="uk-text-center">
                                    <input class="uk-input uk-input-num" placeholder="1" disabled >
                                </div>
                                <div class="uk-float-left">
                                    <span class="price"><?php echo e(number_format($amount_without_discount)); ?></span> <span class="price">تومان</span>
                                </div>
                                <div class="uk-accordion-content">
                                    <ul class="uk-margin-medium-top">
                                        <?php if(isset($suffix)): ?>
                                        <li>دامنه <?php echo e($suffix); ?></li>
                                        <?php endif; ?>
                                        <li>میزبانی</li>
                                        <li>پکیج پیامک 500 عددی</li>
                                    </ul>
                                </div>
                            </li>
                        </ul>
                        <div class="" id="invoice">
                            <ul>
                                <li class="border-bottom">
                                    <span id="basket_price" class="uk-float-left"><?php echo e(number_format($amount_without_discount)); ?></span>
                                    <span>مجموع سبد خرید</span><br>
                                </li>
                                <li class="border-bottom">
                                    <span id="basket_price" class="uk-float-left"><?php echo e(number_format($discount_amount)); ?></span>
                                    <span>تخفیف</span><br>
                                </li>
                                <li class="border-bottom uk-margin-medium-top">
                                    <span id="payment" class="uk-float-left"><?php echo e(number_format($amount_with_discount)); ?></span>
                                    <span>خالص پرداختی</span><br>
                                    <span class="uk-float-left"><?php echo e(number_format($wallet_amount)); ?></span>
                                    <span>موجودی کیف پول</span>
                                </li>
                                <li class="uk-margin-medium-top">
                                    <span id="basket_payment" class="uk-float-left" style="font-size: 16px; font-weight: 500"><?php echo e($amount_with_wallet); ?></span>
                                    <span style="font-size: 16px; font-weight: 500">مبلغ قابل پرداخت</span>
                                </li>
                            </ul>
                        </div>
                        <?php if(session()->has('discount_status')): ?>
                            <ul class="" id="Domain">
                                <li class="uk-position-relative">
                                    <input class="uk-input uk-input uk-input-discount input-shop" disabled type="text" placeholder="<?php echo e(session()->get('discount_status')[1]); ?>">
                                    <a href="<?php echo e(route('home_discount_delete' , session()->get('discount_status')[1])); ?>"><i class="material-icons uk-text-danger delete-icon">cancel</i></a>
                                </li>
                                <?php if($status == 1): ?>
                                    <li>
                                        <div class="uk-alert-success text-center">کد تخفیف با موفقیت اعمال شد</div>
                                    </li>
                                <?php endif; ?>
                            </ul>

                        <?php else: ?>
                        <ul uk-accordion>
                            <li class="card uk-open">
                                <a class="uk-accordion-title">کد تخفیف دارید؟</a>
                                <div class="uk-accordion-content">
                                    <br>
                                    <form action="<?php echo e(route('home_discount')); ?>" method="post">
                                        <?php echo csrf_field(); ?>
                                        <input class="uk-input uk-input-discount" name="discount"  placeholder="کد تخفیف خود را وارد کنید.">
                                        <button class="uk-button button-discount">بررسی</button>
                                        <?php if($status == 0): ?>
                                            <div class="uk-alert-danger text-center">کد تخفیف وارد شده نا معتبر است</div>
                                        <?php endif; ?>
                                    </form>
                                </div>
                            </li>
                        </ul>
                        <?php endif; ?>

                        <div class="uk-float-right uk-margin uk-grid-small uk-child-width-auto uk-grid">
                            <label class="rul"><input class="uk-checkbox" type="checkbox" checked > قوانین و مقررات را خوانده مورد تایید است</label>
                        </div>

                        <div class="uk-float-left uk-margin uk-grid-small uk-child-width-auto uk-grid">
                            <a href="<?php echo e(route('home_save_basket')); ?>" rel="nofollow"><button class="uk-button button-accept-order">پرداخت</button></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="<?php echo e(asset('front/buy/js/jquery.js')); ?>"></script>
    <script src="<?php echo e(asset('front/buy/js/uikit-icons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('front/buy/js/uikit.min.js')); ?>"></script>
    <script>

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.buy', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\yekita-core\resources\views/front/basket.blade.php ENDPATH**/ ?>