<?php $__env->startSection('header'); ?>
    <script src="<?php echo e(asset('dashboard/css/datatables.css')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <table id="licenses" class="table" cellspacing="0" width="100%">
        <thead>
        <tr>
            <th>ردیف</th>
            <th>کد مجوز</th>
            <th>دامنه </th>
            <th>تاریخ اتمام مجوز</th>
            <th>وضعیت</th>
        </tr>
        </thead>
        <tfoot>
        <tr>
            <th>ردیف</th>
            <th>کد مجوز</th>
            <th>دامنه </th>
            <th>تاریخ اتمام مجوز</th>
            <th>وضعیت</th>
        </tr>
        </tfoot>
        <tbody>
        <?php $__currentLoopData = $licenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><a href="<?php echo e(route('dash_license' , $value->code)); ?>"><?php echo e($loop->iteration); ?></a></td>
                <td><a href="<?php echo e(route('dash_license' , $value->code)); ?>"><?php echo e($value->code); ?></a></td>
                <?php if($value->domain == ''): ?>
                    <td><a href="<?php echo e(route('dash_license' , $value->code)); ?>">دامنه ندارد</a></td>
                    <td><a href="#">-</a></td>
                <?php else: ?>
                    <td><a href="<?php echo e(route('dash_license' , $value->code)); ?>"><?php echo e($value->domain.'.'.strtolower($value->suffix_domain)); ?></a></td>
                    <td><a href="<?php echo e(route('dash_license' , $value->code)); ?>"><?php echo e(\App\Traits\Date::dateView($value->expire_date , $language)); ?></a></td>
                <?php endif; ?>
                <?php if($value->status): ?>
                    <td><a href="<?php echo e(route('dash_license' , $value->code)); ?>">فعال</a></td>
                <?php else: ?>
                    <td><a href="<?php echo e(route('dash_license' , $value->code)); ?>">غیرفعال</a></td>
                <?php endif; ?>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <div>
        <div>
            <?php echo e($licenses->links()); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
    <script src="<?php echo e(asset('dashboard/js/datatables.js')); ?>"></script>
    <script>
    $(document).ready(function() {
    var table = $('#licenses').DataTable( {
    responsive: true,
    bFilter: false,
    bInfo: false,
    "paging":   false,
    "bLengthChange": false,
    'info' : false,
    "order": [],

    } );
    } );

    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\yekita-core\resources\views/dashboard/license/licenses.blade.php ENDPATH**/ ?>