
<!DOCTYPE html>
<html lang="en" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>یکیتا - پلتفرم آموزش مجازی و آنلاین</title>
    <meta name="description" content=" یکیتا پلتفرم آموزش مجازی و آنلاین که امکان ارائه وب سایت اختصاصی آموزش ">
    <link rel="stylesheet" href="<?php echo e(asset('front/yekita/css/uikit-rtl.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('front/yekita/css/yekita.css')); ?>">
    <meta property="og:image" content="<?php echo e(asset('front/img/logo.png')); ?>" />
    <link rel="shortcut icon" href="<?php echo e(asset("front/img/logo.png")); ?>" type="image/x-icon">
    <link rel="icon" href="<?php echo e(asset("front/img/logo.png")); ?>" type="image/x-icon">
</head>
<body>

    
    <header>
        <?php if(session()->has('user_information')): ?>
        <nav class="uk-navbar-container uk-hidden@s uk-margin-medium-bottom" uk-navbar>
            <div class="uk-navbar-center">
                <!-- This is a button toggling the modal -->
                <button class="uk-button button-oauth" type="button" uk-toggle="target: #modal-example">
                    <div>
                        <?php if(!is_null(session()->get('user_information')->avatar)): ?>
                            <img src="<?php echo e(session()->get('user_information')->avatar); ?>" class="image-user">
                        <?php endif; ?>
                            <p class="name-user">
                                <?php echo e(session()->get('user_information')->name.' '.session()->get('user_information')->lastname); ?>

                            </p>
                    </div>
                </button>
                <div id="modal-example" class="uk-flex-top" uk-modal>
                    <div class="uk-modal-dialog uk-modal-body">
                        <button class="uk-modal-close-default" type="button" uk-close></button>
                        <ul class="uk-list uk-list-large">
                            <ul class="ul-modal">
                                <li class="link-border">
                                    <a href="">
                                        <p>
                                            <i class="material-icons material-icons-user">contact_phone</i><span class="detail-material-user"><?php echo e(session()->get('user_information')->mobile_number); ?></span>
                                        </p>
                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo e(route('dash_profile')); ?>">
                                        <p>
                                            <i class="material-icons material-icons-modal">face</i><span class="detail-material">ویرایش مشخصات</span>
                                        </p>
                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo e(route('dash_manage_password')); ?>">
                                        <p>
                                            <i class="material-icons material-icons-modal">lock</i><span class="detail-material">مدیریت رمز عبور</span>
                                        </p>
                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo e(route('dash_licenses')); ?>">
                                        <p>
                                            <i class="material-icons material-icons-modal">view_quilt</i><span class="detail-material">ناحیه کاربری</span>
                                        </p>
                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo e(route('dash_wallet')); ?>">
                                        <p>
                                            <i class="material-icons material-icons-modal">account_balance_wallet</i><span class="detail-material">کیف پول </span>
                                        </p>
                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo e(route('dash_logout')); ?>">
                                        <p>
                                            <i class="material-icons material-icons-modal">input</i><span class="detail-material">خروج از حساب کاربری</span>
                                        </p>
                                    </a>
                                </li>
                            </ul>
                        </ul>
                    </div>
                </div>
            </div>
        </nav>
        <nav class="uk-navbar-container uk-visible@s" uk-navbar>
            <div class="uk-navbar-center">
                <!-- This is a button toggling the modal -->
                <button class="uk-button button-oauth" type="button" >
                    <div class="uk-grid padding-top">
                        <div class="no-padding uk-flex-inline">
                            <?php if(!is_null(session()->get('user_information')->avatar)): ?>
                                <img src="<?php echo e(session()->get('user_information')->avatar); ?>" class="image-user">
                            <?php endif; ?>
                            <p class="name-user">
                                <?php echo e(session()->get('user_information')->name.' '.session()->get('user_information')->lastname); ?>

                            </p>
                        </div>
                        <div class="no-padding" style="margin-top: .5rem;">
                            <i class="material-icons">contact_phone</i>
                            <a href="<?php echo e(route('dash_licenses')); ?>"><i class="material-icons" uk-tooltip="title: ناحیه کاربری; pos: right">view_quilt</i></a>
                            <a href="<?php echo e(route('dash_profile')); ?>"><i class="material-icons" uk-tooltip="title: ویرایش پروفایل; pos: right">face</i></a>
                            <a href="<?php echo e(route('dash_wallet')); ?>"><i class="material-icons" uk-tooltip="title: کیف پول ; pos: right">account_balance_wallet</i></a>
                            <a href="<?php echo e(route('dash_manage_password')); ?>"><i class="material-icons" uk-tooltip="title: مدیریت رمز عبور; pos: right">lock</i></a>
                            <a href="<?php echo e(route('dash_logout')); ?>"><i class="material-icons" uk-tooltip="title: خروج; pos: right">input</i></a>
                        </div>
                    </div>
                </button>
            </div>
        </nav>
        <?php else: ?>
            <nav class="uk-navbar-container" uk-navbar>
                <div class="uk-navbar-center">
                    <!-- This is a button toggling the modal -->
                    <a href="<?php echo e(route('sign-in')); ?>">
                        <button class="uk-button button-login" type="button" >
                            <div class="uk-grid">
                                <span class="login-position">ورود / ثبت نام</span>
                            </div>
                        </button>
                    </a>
                </div>
            </nav>
        <?php endif; ?>
    </header>

    
    <div class="nav">
        <div class="uk-container">
            <div uk-grid  id="nav-display">
                
                <div class="uk-navbar-right uk-width-3-4@s">
                    <div class="header_background_image ">
                        <nav class="uk-navbar-container uk-navbar-transparent" uk-navbar>
                            <div class="uk-navbar-left button_nav_style">
            
                                <ul class="uk-navbar-nav uk-visible">
                                    <li><a class="nav_style" href="<?php echo e(route('home.1')); ?>"> خانه</a></li>
                                    <li><a class="nav_style" href="/<?php echo e($lang); ?>/about">درباره ما</a></li>
                                    <li><a class="nav_style" href="/<?php echo e($lang); ?>/contact">تماس با ما</a></li>
                                    <li><a class="nav_style" href="/<?php echo e($lang); ?>/application">دوره های برگزارکنندگان </a></li>
            
                                </ul>
                                
                            </div>
                        </nav>
                    </div>
                </div>
                <div class="uk-navbar-left uk-width-1-4@s order-0">
            
                    <img src="images/logo.webp" class="uk-align-center logo" alt="logo">
                
                </div>
            </div>
        </div>
    </div>

    
    <?php echo $__env->yieldContent('content'); ?>


    
    <footer class="footer">

        <div class="uk-container">
            <a href="/<?php echo e($lang); ?>/download">
                <img src="images/slider-app.webp" height="" alt="دانلود اپلیکیشن یکیتا" class="uk-align-center uk-padding footer-img">
            </a>        
        </div>
        
        <div class="uk-container">
            <footer class=" footer_background_image uk-padding-small uk-padding  " id="contactus">
                <div class="uk-grid-small uk-child-width-expand@s uk-text-center footer-column" uk-grid>
                    <div class="uk-flex-left" uk-grid>
                        <div class="uk-flex-center uk-text-right">
                            <p style="color: #FFB331"> درباره یکیتا</p>
                            <ul class="uk-list footer-link">
                                <li><a href="/<?php echo e($lang); ?>/about">درباره ما</a></li>
                                <li><a href="/<?php echo e($lang); ?>/contact">تماس با ما</a></li>
                                <li><a href="/<?php echo e($lang); ?>/privacy">قوانین و مقرات</a></li>
                                <li><a href="">حریم شخصی</a></li>
                            </ul>
                        </div>
                        <div>
                            <p style="color: #FFB331"> پشتیبانی</p>
                            <ul class="uk-list uk-text-right footer-link">
                                <li><a href="">پشتیبانی</a></li>
                                <li><a href="">آموزش</a></li>
                                <li><a href="/<?php echo e($lang); ?>/download">دانلود</a></li>
                                <li><a href="">اپلیکیشن</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="footer-logo uk-padding-large">
                        <div class="footer-logo-margin">
                            <div class="uk-flex-center" uk-grid>
                                <div>
                                    <img src="images/Group-8256.webp"  height="100px" alt="سیمرغ" class="uk-margin-small-left" uk-img>
                                    <img src="images/Group-8263.webp"  height="100px" alt="یکیتا" class="uk-margin-small-right" uk-img>
            
                                </div>
                            </div>
                            <p> لوگو، کاراکتر و نرم افزار یکیتا ثبت شده و
                                تحت حمایت قانون مالکیت معنوی است
                            <br>
                                <span class="copy-right">Copyright 2020 Simorgh Internet Group</span>
                            </p>
                        </div>
        
                    </div>
        
                    <div class="uk-flex-center footer-social">
                        <div class="uk-margin-bottom footer-icon">
                            <div class="uk-flex uk-flex-middle"> 
                                <span class="material-icons uk-grid-margin-medium">arrow_downward</span>
                                دانلود کاتالوگ
                            </div>
                            <div class="uk-flex uk-flex-middle phones"> 
                                <span class="material-icons uk-grid-margin-medium">phone</span>
                                88065862 - 88065876
                            </div>
                        </div>

                        <div  class="social_media_icon_style icon_style">
                            <a  href="#" class="uk-icon-button"><img src="images/Path 432.svg" alt="شبکه های اجتماعی"></a>
                            <a  href="#" class="uk-icon-button uk-margin-small-right "><img src="images/Path 434.svg" alt="شبکه های اجتماعی"></a>
                            <a  href="#" class="uk-icon-button uk-margin-small-right "><img src="images/Path 430.svg" alt="شبکه های اجتماعی"></a>
                            <a  href="#" class="uk-icon-button uk-margin-small-right "><img src="images/Path 433.svg" alt="شبکه های اجتماعی"></a>
                        </div>
                        <div  class="social_media_icon_style icon_style uk-margin-small-top">
                            <a  href="#" class="uk-icon-button"><img src="images/Path 431.svg" alt="شبکه های اجتماعی"></a>
                            <a  href="#" class="uk-icon-button uk-margin-small-right "><img src="images/Repeat Grid 2.svg" alt="شبکه های اجتماعی"></a>
                            <a  href="#" class="uk-icon-button uk-margin-small-right "><img src="images/Path 428.svg" alt="شبکه های اجتماعی"></a>
                            <a  href="#" class="uk-icon-button uk-margin-small-right "><img src="images/Path 429.svg" alt="شبکه های اجتماعی"></a>
                        </div>
                    </div>
                </div>
            </footer>
        
        </div>
        
    </footer>
    <script src="<?php echo e(asset('front/yekita/js/jquery.js')); ?>"></script>
    <script src="<?php echo e(asset('front/yekita/js/uikit.min.js')); ?>"></script>
    <script src="<?php echo e(asset('front/yekita/js/uikit-icons.min.js')); ?>"></script>
    <?php echo $__env->yieldContent('footer'); ?>



</body>
</html><?php /**PATH D:\xampp\htdocs\yekita-core\resources\views/layouts/yekita.blade.php ENDPATH**/ ?>