<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use App\Events\BuyLicense;
use App\Listeners\RegisterArvan;
use App\Model\Product;
use App\Model\License;
use App\User;
use Carbon\Carbon;
use GuzzleHttp\Client;

Route::get('/verify/tranasction/zarinpal', 'TransactionController@verify_zarinpal')->name('verify_zarinpal');


Route::get('test',function (){

    $license = License::find(717);
    $platform = new BuyLicense($license);
    event($platform);
});

/* Route::view("/hmp",'front.information');

function param($name){
    return [
        'headers' => ['Accept' => 'application/json','Authorization' => 'Apikey ' . config('global.arvan_key')],
        'form_params' => [
            "type" =>  "a",
            "name" =>  $name,
            "value" => [
                (object) [
                "ip"=> config('global.server_ip'),
                "port"=> null,
                "weight"=> 100,
                "country"=> ""
                ]
            ],
            "ttl" =>  120,
            "cloud" =>  false,
            "upstream_https" =>  "default",
            "ip_filter_mode" =>   (object) [
                "count"=> "single",
                "order"=> "none",
                "geo_filter"=> "none"
            ],
        ]
    ];
        
}

Route::get('test2',function(){
    $client = new Client;
    $url = config('global.arvan_url') . '/domains/dns-service';
    $res = $client->request('POST', $url, [
        'headers' => ['Authorization' => 'Apikey ' . config('global.arvan_key')],
        'form_params' => ['domain' => 'yekitabestplatform.ir']
    ]);
    $data =  json_decode($res->getBody()->getContents())->data;
 
    $client = new Client;
    $url = config('global.arvan_url') . "/domains/$data->domain/dns-records";


    $data = $client->request('POST', $url, param('www'));

    $data = $client->request('POST', $url, param('@'));
});
 */



/* Route::get('testtt',function(){

    $user = User::find(7440);
    $user->licenses()->create([
        'code' => rand(1100000000000,9100000000000),
        'domain' => 'snsjnfjsneddjf',
        'suffixdomain' => 'ir',
        'host' => 'package_a',
        'has_domain' => 0,
        'expire_date' => Carbon::today(),
        'iscompleted' => 1,
        'sms_balance' => 500,
    ]);
});
 */
Auth::routes();

/* redirect 404 to home page */
Route::fallback(function () {
    return \Illuminate\Support\Facades\Redirect::to('/',301); 
});

/*
 *  Set up locale and locale_prefix if other language is selected
 */


Route::middleware('auth')->prefix('admin')->namespace('Admin')->group(function () {

    Route::get('/login', 'ProfileController@index');
    Route::get('/profile', 'ProfileController@index')->name('profile');

    Route::group(['middleware' => ['role:manager|content']], function () {
        Route::get('/blog', 'BlogController@index')->name('list_blog');
        Route::get('/blog/create', 'BlogController@create')->name('create_blog');
        Route::get('/blog/create/{id}/{lang}', 'BlogController@create_translate')->name('create_lang_blog');
        Route::post('/blog/store', 'BlogController@store')->name('store_blog');
        Route::post('/blog/store_translate', 'BlogController@store_translate')->name('store_translate_blog');
        Route::get('/blog/lang/{id}', 'BlogController@language')->name('lang_blog');
        Route::put('/blog/update/{id}', 'BlogController@update')->name('update_blog');
        Route::delete('/blog/delete/{id}', 'BlogController@destroy')->name('destory_blog');
        Route::delete('/blog/delete_translate/{id}', 'BlogController@destroy_translate')->name('destory_translate_blog');
        Route::get('/blog/{id}/{lang}', 'BlogController@show')->name('show_blog');
        Route::get('/blog/{id}/edit/{lang}', 'BlogController@edit')->name('edit_blog');
        Route::post('/blog/status/{id}', 'BlogController@chang_status')->name('chang_status');
    });

    Route::group(['middleware' => ['role:manager|course']], function () {
        Route::get('/courses', 'CourseController@index')->name('list_course');
        Route::get('/course/{id}', 'CourseController@course')->name('course_information');
        Route::put('/course/reject/{id}', 'CourseController@reject')->name('course_reject');
        Route::get('/course/accept/{id}', 'CourseController@accept')->name('course_accept');
        Route::get('/courses/request', 'CourseController@request_list')->name('course_request_list');
        Route::get('/courses/request/{id}', 'CourseController@request_show')->name('course_request_show');
        Route::post('/courses/request', 'CourseController@request_show')->name('course_request_show');
        Route::post('/courses/new_group/{id}', 'CourseController@newCourseGroup')->name('course_new_course_group_insert');
    });

    Route::group(['middleware' => ['role:manager|users']], function () {
        Route::get('/users', 'UserController@index')->name('users_list');
        Route::get('/user/{id}', 'UserController@user')->name('user_information');
        Route::get('/user/invoices/{id}', 'UserController@invoices')->name('user_invoices');
        Route::get('/user/invoice/{id}', 'UserController@invoice')->name('user_invoice');
        Route::get('/user/{user}/websites', 'UserController@websites')->name('user_websites');
        Route::get('/user/website/{id}', 'UserController@website')->name('user_website');
    });

    Route::group(['middleware' => ['role:manager|financial']], function () {
        Route::get('/invoices', 'AccountController@invoices')->name('invoices');
        Route::get('/invoice/{id}', 'AccountController@invoice')->name('invoice');
        Route::get('account/products', 'AccountController@products')->name('products');
        Route::get('account/product/{id}', 'AccountController@product')->name('product');
        Route::put('account/product/update/{id}', 'AccountController@product_update')->name('product_update');
    });

    Route::group(['middleware' => ['role:manager|event']], function () {
        Route::get('/events', 'EventController@index')->name('events');
        Route::post('/addevent', 'EventController@store')->name('add_admin_event');
    });


    Route::group(['middleware' => ['role:manager']], function () {
        Route::get('/products', 'ProductController@index')->name('all_products');
        Route::get('/product/create', 'ProductController@create')->name('product_create');
        Route::post('/product/create', 'ProductController@store')->name('product_store');
        Route::get('/product/edit/{id}', 'ProductController@edit')->name('product_edit');
        Route::post('/product/edit/{id}', 'ProductController@update')->name('product_update');
        Route::post('/product/delete/{id}', 'ProductController@destroy')->name('product_delete');
    });

    Route::group(['middleware' => ['role:manager']], function () {
        Route::get('/discounts', 'DiscountController@index')->name('all_discounts');
        Route::get('/discount/create', 'DiscountController@create')->name('discount_create');
        Route::post('/discount/create', 'DiscountController@store')->name('discount_store');
        Route::get('/discount/edit/{id}', 'DiscountController@edit')->name('discount_edit');
        Route::post('/discount/edit/{id}', 'DiscountController@update')->name('discount_update');
        Route::post('/discount/delete/{id}', 'DiscountController@destroy')->name('discount_delete');
    });

    Route::group(['middleware' => ['role:manager']], function () {
        Route::get('/setting', 'SettingController@index')->name('setting');
        Route::get('/setting/slider', 'SettingController@slider')->name('slider_setting');
        Route::get('/setting/slider/create', 'SettingController@sliderCreate')->name('slider_create');
        Route::post('/setting/slider/create', 'SettingController@sliderStore')->name('slider_create');
        Route::get('/setting/slider/edit/{id}', 'SettingController@sliderEdit')->name('slider_edit');
        Route::post('/setting/slider/edit/{id}', 'SettingController@sliderUpdate')->name('slider_edit');
        Route::post('/setting/slider/delete/{id}', 'SettingController@sliderDelete')->name('slider_delete');
    });

});

Route::middleware('OAuthSimorgh')->prefix('dashboard')->namespace('Dashboard')->group(function () {
    Route::get('/', 'ProfileController@index')->name('dash_home');
    Route::get('/profile', 'ProfileController@index')->name('dash_profile');
    Route::post('/update_user', 'ProfileController@update_user')->name('dash_update_user');
    Route::get('/manage_password', 'ProfileController@getManagePassword')->name('dash_manage_password');
    Route::post('/update_password', 'ProfileController@postUpdatePassword')->name('dash_update_password');

    Route::get('/invoices', 'InvoiceController@invoices')->name('dash_invoices');
    Route::get('/invoice/{id}', 'InvoiceController@invoice')->name('dash_invoice');

    Route::get('/licenses', 'LicenseController@licenses')->name('dash_licenses');
    Route::get('/license/{key}', 'LicenseController@license')->name('dash_license');
    Route::get('/pay_credit', 'LicenseController@pay_credit')->name('dash_pay_credit');
    Route::get('/activation/{key}', 'LicenseController@activation')->name('dash_activation');
    Route::get('/activation_with_domain/{key}', 'LicenseController@activation_with_domain')->name('dash_activation_with_domain');
    Route::get('/activation_without_domain/{key}', 'LicenseController@activation_without_domain')->name('dash_activation_without_domain');
    Route::get('/credit', 'LicenseController@credit')->name('dash_credit');
    Route::post('/check_domain', 'LicenseController@check_domain')->name('dash_check_domain');
    Route::post('/validate_domain', 'LicenseController@validate_domain')->name('dash_validate_domain');
    Route::post('/reg_license', 'LicenseController@reg_license')->name('dash_reg_license');
    Route::get('/credit_assign', 'LicenseController@credit_assign')->name('dash_credit_assign');

    Route::get('/credit_assign_form/{code}', 'LicenseController@credit_assign_form')->name('dash_credit_assign_form');
    Route::post('/add_credit_basket', 'LicenseController@add_credit_basket')->name('dash_add_credit_basket');
    Route::get('/credit_assigning', 'LicenseController@credit_assigning')->name('dash_credit_assigning');
    Route::post('/credit_discount', 'LicenseController@credit_discount')->name('dash_credit_discount');
    Route::get('/credit_discount_delete/{id}', 'LicenseController@credit_discount_delete')->name('dash_credit_discount_delete');
    Route::get('/credit_save_basket', 'LicenseController@credit_save_basket')->name('dash_credit_save_basket');

    Route::get('/sms', 'LicenseController@sms')->name('dash_sms');
    Route::get('/sms_assign', 'LicenseController@sms_assign')->name('dash_sms_assign');
    Route::get('/sms_assign_form/{code}', 'LicenseController@sms_assign_form')->name('dash_sms_assign_form');
    Route::post('/add_sms_basket', 'LicenseController@add_sms_basket')->name('dash_add_sms_basket');
    Route::get('/sms_assigning/{code}', 'LicenseController@sms_assigning')->name('dash_sms_assigning');
    Route::post('/sms_discount', 'LicenseController@sms_discount')->name('dash_sms_discount');
    Route::get('/sms_discount_delete/{id}', 'LicenseController@sms_discount_delete')->name('dash_sms_discount_delete');
    Route::get('/sms_save_basket', 'LicenseController@sms_save_basket')->name('dash_sms_save_basket');

    Route::get('/wallet', 'WalletController@index')->name('dash_wallet');
    Route::post('/charge', 'WalletController@charge')->name('dash_charge');
    Route::get('/verify_charge', 'WalletController@verify_charge')->name('dash_verify_charge');
    Route::post('/payment/callback', 'WalletController@paymentCallback')->name('payment_callback');

    Route::get('/event', 'EventController@index')->name('dash_event');
    Route::POST('/add_event', 'EventController@index')->name('add_event');

    Route::get('/shop', 'ShopController@index')->name('dash_shop');
    Route::post('/shop/add', 'ShopController@add_to_basket')->name('dash_add_product');
    Route::get('/shop/delete/{id}', 'ShopController@delete_product')->name('dash_delete_product');
    Route::get('/basket', 'ShopController@basket')->name('dash_cart');
    Route::post('/discount', 'ShopController@discount')->name('dash_discount');
    Route::get('/discount/delete/{id}', 'ShopController@discount_delete')->name('dash_discount_delete');
    Route::get('/basket/save', 'ShopController@save_basket')->name('dash_save_basket');
    Route::get('/order/{id}', 'ShopController@order')->name('dash_order');
    Route::get('/pay/{id}', 'ShopController@pay')->name('dash_pay');

    Route::get('/logout', 'ProfileController@logout')->name('dash_logout');

});

Route::middleware('LoginCheck')->prefix('sign-in/')->group(function () {

    Route::get('/', 'LoginController@index')->name('sign-in');
    Route::get('/login_with_password', 'LoginController@getLoginWithPassword')->name('login-with-password');
    Route::post('/validate_mobile', 'LoginController@validate_mobile')->name('validate_mobile');
    Route::get('/verify', 'LoginController@verify')->name('verify');
    Route::get('/resend', 'LoginController@resend')->name('resend');
    Route::post('/verification', 'LoginController@verification')->name('verification');
    Route::get('/authorization', 'LoginController@authorization')->name('authorization');
    Route::post('/authorization_password', 'LoginController@postAuthorizationWithPassword')->name('authorization-with-password');
    Route::get('/register', 'LoginController@register')->name('register_user');
    Route::post('/save_information', 'LoginController@save_information')->name('save_information');

});


Route::get('/application/{application}/{lang}', 'Api\DownloadAppController@index')->name('download_application');

Route::get('/', 'HomeController@application')->name('home.1');
Route::post('/check_domain', 'HomeController@check_domain')->name('home_check_domain');
Route::post('/number_format', 'HomeController@number_format')->name('home_number_format');
Route::get('/content/{id}/{lang}', 'BlogController@blog')->name('blog');
Route::get('/articles/{lang}/{id}', 'BlogController@blog')->name('blog_old');
Route::get('/blog/{lang}/{a}/{b}', 'BlogController@index')->name('blog_list_old');
Route::post('/contact_store', 'HomeController@contact_store')->name('send_message');
Route::post('/search_conductor', 'HomeController@search_conductor')->name('home_search_conductor');
Route::post('/search_teacher', 'HomeController@search_teacher')->name('home_search_teacher');
Route::get('/privacypolicy', 'HomeController@privacypolicy')->name('home_privacypolicy');
Route::post('/buy/plan', 'BasketController@buy_plan')->name('buy_plan');


Route::middleware('OAuthSimorgh')->group(function () {
    Route::get('/{locale}/shop', 'BasketController@shop')->name('home_shop');
    Route::get('/basket', 'BasketController@basket')->name('home_basket');
    Route::get('/basket/information', 'BasketController@basket_information')->name('home_basket_information');
    Route::post('/basket/information', 'BasketController@save_basket_information')->name('home_basket_information');
    Route::post('/add_basket', 'BasketController@add_to_basket')->name('home_add_basket');
    Route::get('/discount_delete/{discount}', 'BasketController@discount_delete')->name('home_discount_delete');
    Route::get('/discount', 'BasketController@discount')->name('home_discount');
    Route::post('/save_basket', 'BasketController@save_basket')->name('home_save_basket');
    Route::post('/checking_rules', 'BasketController@checking_rules')->name('order_checking_rules');
    Route::get('/pay_basket', 'BasketController@pay_basket')->name('home_pay_basket');
});

Route::get('/points', 'MapController@courses')->name('map_points');

if (in_array(Request::segment(1), Config::get('app.alt_langs'))) {
    App::setLocale(Request::segment(1));
    Route::get('/{locale}', 'HomeController@application')->name('home.2');
    Route::get('/{locale}/home', 'HomeController@index')->name('home.3');
    Route::get('/{locale}/blog', 'BlogController@index')->name('blog_list');
    Route::get('/{locale}/courses', 'CourseController@index')->name('courses_list');
    Route::get('/{locale}/conductors', 'ConductorController@index')->name('conductors_list');
    Route::get('/{locale}/teachers', 'TeacherController@index')->name('teachers_list');
    Route::get('/{locale}/course/{id}', 'CourseController@course')->name('course_info');
    Route::get('/{locale}/contact', 'HomeController@contact')->name('home_contact');
    Route::get('/{locale}/about', 'HomeController@about')->name('home_about');
    Route::get('/{locale}/price', 'HomeController@price')->name('home_price');
    Route::get('/{locale}/privacy', 'HomeController@privacy')->name('home_privacy');
    Route::get('/{locale}/rules', 'HomeController@rules')->name('home_rules');
    Route::get('/{locale}/application', 'HomeController@index')->name('home_application');
    Route::get('/{locale}/desktop', 'HomeController@desktop')->name('home_desktop');
    Route::get('/{locale}/map', 'MapController@index')->name('map_index');
    Route::get('/{locale}/download', 'HomeController@download')->name('home_download');

}

Route::post('/pay_customer', 'UserController@pay_customer')->name('pay_customer');
Route::post('/callback_customer', 'UserController@callback_customer')->name('callback_customer');

Route::post('/wallet_charge', 'UserController@wallet_charge')->name('wallet_charge');
Route::post('/wallet_callback', 'UserController@wallet_callback')->name('wallet_callback');

Route::get('/download_application/{type}', 'UserController@download_application')->name('download_application');

Route::post('/comment/store', 'CommentController@store')->name('store_comment');

Route::get('/get/cities/{id}', 'LoginController@cities')->name('cities_list');
