<?php

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/license/{code}', 'Dashboard\LicenseController@checkLicense');
Route::middleware('auth:api')->post('/license', 'Dashboard\LicenseController@addResToLicense');

Route::middleware('auth:api')->get('/user/{mobile}', 'UserController@get_access_token_user');
Route::middleware('auth:api')->post('/user/login', 'UserController@get_access_token_user_with_password')->name('loginWithPassword');
Route::middleware('auth:api')->post('/user', 'UserController@update_user');
Route::middleware('auth:api')->post('/user/password', 'UserController@update_password');

Route::middleware('auth:api')->get('/basket/{currency}/{token}', 'UserController@get_basket');
Route::middleware('auth:api')->post('/basket', 'UserController@add_to_basket');
Route::middleware('auth:api')->post('/discount', 'UserController@discount');
Route::middleware('auth:api')->post('/del_discount', 'UserController@del_discount');

Route::middleware('auth:api')->get('/wallet/{id}', 'UserController@balance_wallet');
Route::middleware('auth:api')->post('/wallet', 'UserController@update_user');

Route::middleware('auth:api')->post('/update_software', 'UserController@update_software');

Route::middleware('auth:api')->post('/deposit', 'IncomeController@deposit');

Route::post('/token', 'Admin\ProfileController@getTokenForCustomer');
Route::post('/save_image', 'Dashboard\LicenseController@save_image');

Route::namespace('Api')->middleware('auth:api')->group(function () {
//Route::namespace('Api')->group(function () {
    //Aws
    Route::post('/upload_aws', 'AwsController@upload_file');
    Route::post('/download_aws', 'AwsController@download_file');
    //Live
    Route::post('/create_room', 'LiveController@create_room');
    Route::post('/is_meeting_running', 'LiveController@is_meeting_running');
    Route::post('/meeting_info', 'LiveController@meeting_info');
    Route::post('/join_room_teacher', 'LiveController@join_room_teacher');
    Route::post('/join_room_student', 'LiveController@join_room_student');
    Route::post('/get_course_info', 'LiveController@getCourseInfo');
    //Event
    Route::get('/domains/{mobile}', 'EventController@domains');
    Route::post('/get_types_domain', 'EventController@get_types_domain');
    Route::post('/create_event', 'EventController@create_event');
    Route::post('/list_event', 'EventController@list_event');
    Route::post('/delete_event', 'EventController@delete_event');
    Route::post('/update_event/{id}', 'EventController@update_event');
    Route::post('/register_conflict', 'EventController@register_conflict');
    Route::post('/course_conflict', 'EventController@course_conflict');
    Route::post('/teacher_conflict', 'EventController@teacher_conflict');
    Route::post('/events_system', 'EventController@events_system');
    Route::get('/details_event/{id}', 'EventController@details_event');
    Route::post('/get_user_id', 'EventController@get_user_id');
    //document
    Route::post('/user/save_document', 'UserController@save_document');
    Route::post('/user/delete_document', 'UserController@delete_document');
    Route::get('/user/get_document/{id}', 'UserController@get_document');
    //charge
    Route::post('/referral_gift', 'WalletController@referral_gift');
    //pamphlet
    Route::post('/pamphlet/add', 'PamphletsController@add_pamphlet');
    Route::post('/pamphlet/edit/{id}', 'PamphletsController@edit_pamphlet');
    Route::post('/pamphlet/editupload/{id}', 'PamphletsController@edit_upload_pamphlet');
    Route::post('/pamphlet/delete/{id}', 'PamphletsController@remove_pamphlet');
    Route::post('/pamphlet/update/show', 'PamphletsController@change_show_pamphlets');
    //Recommender
    Route::get('/rec/users', 'RecommenderController@users');
    Route::get('/rec/users/today', 'RecommenderController@users_today');
    Route::get('/rec/courses', 'RecommenderController@courses');
    Route::get('/rec/courses/today', 'RecommenderController@courses_today');
    Route::get('/rec/participants', 'RecommenderController@participants');
    Route::get('/rec/participants/today', 'RecommenderController@participants_today');
    Route::get('/rec/teachers', 'RecommenderController@teachers');
    //teacher
    Route::get('/teacher/check/{mobile}', 'TeacherController@check_teacher');
    Route::post('/teacher/add', 'TeacherController@add_teacher');
    Route::post('/teacher/attr', 'TeacherController@add_teacher_attr');
    Route::post('/teacher/add/form', 'TeacherController@add_teacher_form');
});