@extends('layouts.login')

@section('header')
    <style>
        span.disable{
            color: #9e9b9c !important;
        }
        span.enable{
            color: #0c0c0c !important;
            cursor: pointer !important;
        }
    </style>
@endsection
@section('content')
    <section id="resend">
        <div id="form">
            <div class="uk-container uk-container-expand uk-margin-large-top">
                <div uk-grid>
                    <div class="uk-width-large uk-margin margin-auto" >
                        <div class="login-card">
                            <form action="{{route('verification')}}" method="post">
                                @csrf
                            <div class=" uk-text-center" >
                                <ul class="form-header">
                                    <li>
                                        <i class="material-icons">language</i>
                                    </li>
                                    <li>
                                        <p class="uk-text-center p-login-lable uk-margin-medium-bottom">{{__('login.Login to the Yekita')}}</p>
                                    </li>
                                    <li>
                                        <a href="/"><i class="material-icons">arrow_back</i></a>
                                    </li>
                                </ul>
                                <ul class="uk-text-center uk-margin-medium-bottom">
                                    <li>
                                        <img src="{{ asset('front/Ouath/img/code.svg') }}" class="svg" alt="">
                                    </li>
                                </ul>
                                <ul class="">
                                    <li class=" login-lable">
                                        <span>کد تایید را وارد کنید</span>
                                    </li>
                                    <li class="code">
                                        <div class="input-login-verification">
                                            <table class="enterPINTable">
                                                <tr>
                                                    <td>
                                                        <input name="txtPIN4" id="txtPIN4" class="pinchar" size="1" autocomplete="off" fo>
                                                    </td>
                                                    <td>
                                                        <input name="txtPIN3" id="txtPIN3" class="pinchar" size="1" autocomplete="off">
                                                    </td>
                                                    <td>
                                                        <input name="txtPIN2" id="txtPIN2" class="pinchar" size="1" autocomplete="off">
                                                    </td>
                                                    <td>
                                                        <input name="txtPIN1" id="txtPIN1" class="pinchar" size="1" autocomplete="off" autofocus>
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                    </li>
                                    <li id="li-time">
                                        <span class="login-lable-center" id="time"> 01:30</span>
                                    </li>
                                    <li class="display-li-inline li-margin"><a href="{{route('sign-in')}}" class=" login-lable"><span>تعییر شماره</span></a></li>
                                    <li class="display-li-inline li-margin" id="resend-code"><a href="{{route('resend')}}" class=" login-lable"><span>ارسال دوباره</span></a></li>
                                    <li class="display-li-inline li-margin" id="resend-code"><a href="{{route('login-with-password')}}" class=" login-lable"><span>ورود با رمز عبور</span></a></li>
                                    <li class="li">
                                        <button type="submit" class="uk-button button-login margin-top-bottom">تایید</button>
                                    </li>
                                </ul>
                            </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <script src="{{ asset('front/Ouath/js/jquery.js') }}"></script>
    <script src="{{ asset('front/Ouath/js/uikit.min.js') }}"></script>
    <script src="{{ asset('front/Ouath/js/uikit-icons.min.js') }}"></script>
    <script src="{{ asset('front/Ouath/js/select2.min.js') }}"></script>
    <script src="{{ asset('front/Ouath/js/croppie.js') }}"></script>
    <script src="https://unpkg.com/persian-date@1.0.5/dist/persian-date.js"></script>
    <script src="https://unpkg.com/persian-datepicker@1.1.3/dist/js/persian-datepicker.js"></script>
    <script>
        function step(inp, dir, clr) {
            if (clr) $(inp).val('');
            var $next = $(inp).parent()[['next','prev'][dir]]().find('.pinchar');
            if (!$next.length) $next = $(inp);
            $next.focus();
            setTimeout(function () {
                $next.select();
            }, 0);
            return false;
        }
        $(document).ready(function () {
            $('.pinchar').on('focus', function () {
                $(this).select(); // always select the "whole" (1 char) text
            });
            $('.pinchar').on('keydown', function (e) {
                // arrows
                if (e.which == 37 || e.which == 38) return step(this, 0);
                if (e.which == 39 || e.which == 40) return step(this, 1);
                // backspace
                if (e.which == 8) return step(this, 0, 1);
            });
            $('.pinchar').on('input', function (e) {
                step(this, 1);
            });
        });
    </script>
    <script>
        function startTimer(duration, display) {
            var timer = duration, minutes, seconds;
            setInterval(function () {
                minutes = parseInt(timer / 60, 10);
                seconds = parseInt(timer % 60, 10);

                minutes = minutes < 10 ? "0" + minutes : minutes;
                seconds = seconds < 10 ? "0" + seconds : seconds;

                display.textContent = minutes + ":" + seconds;

                if (--timer < 0) {
                    timer = duration;
                }
            }, 1000);
        }

        window.onload = function () {
            var fiveMinutes = 60 * 1.5,
                display = document.querySelector('#time');
            startTimer(fiveMinutes, display);
        };
    </script>
    <script>
        $(document).ready(function() {
            $('.js-example-basic-single').select2();
        });
    </script>
@endsection
