@extends('layouts.login')

@section('content')
    <section id="form">
        <div class="uk-container uk-container-expand uk-margin-large-top">
            <div uk-grid>
                <div class="uk-width-large uk-margin margin-auto">
                    <div class="login-card">
                        <form action="{{route('save_information')}}" method="post">
                            @csrf
                        <div class="uk-text-center" >
                            <ul class="form-header">
                                <li>
                                    <i class="material-icons">language</i>
                                </li>

                                <li>
                                    <p class="uk-text-center p-login-lable uk-margin-medium-bottom">مشخصات کاربری</p>
                                </li>

                                <li>
                                    <a href="/"><i class="material-icons">arrow_back</i></a>
                                </li>
                            </ul>
                            <ul>
                                @if ($errors)
                                    <br>
                                    <span class="invalid-feedback md-text-danger" role="alert">
                                        <strong>{{ $errors->first() }}</strong>
                                    </span>
                                @endif
                            </ul>
                            <ul>
                                <li style="color: #bbbbbb;">
                                    <span>شماره تلفن همراه</span> <span>{{$mobile}}</span>
                                </li>

                                <li>
                                    <div class="uk-width-1-1" id="Div-image">
                                        <button type="button" class=" remove_photo_croper close-button"><span uk-icon="close"></span></button>
                                        <div id="upload-demo" class="max-width-220"></div>
                                        <input type="hidden" id="image-code" name="avatar" value="{{ old('avatar') }}">
                                        <input class="Upload_Croper" type="file" id="upload-image" data-parsley-id="7">
                                        <div class="clearfix"><br></div>
                                    </div>
                                </li>
                                    <li class=" login-lable">
                                        <span>{{__('login.Name')}}<span style="color:#ffb331">*</span></span>
                                    </li>
                                    <li>
                                        <input type="text"  name="name" class="input-login{{ $errors->has('name') ? ' md-input-danger' : '' }}"  value="{{ old('name') }}">
                                        @if ($errors->has('name'))
                                            <span class="invalid-feedback md-text-danger" role="alert">
                                                <strong>{{ $errors->first('name') }}</strong>
                                            </span>
                                        @endif
                                    </li>
                                    <li class="login-lable">
                                        <span>{{__('login.Last name')}}<span style="color:#ffb331">*</span></span>
                                    </li>
                                    <li>
                                        <input type="text" name="lastname" class="input-login{{ $errors->has('lastname') ? ' md-input-danger' : '' }}" value="{{ old('lastname') }}">
                                        @if ($errors->has('lastname'))
                                            <span class="invalid-feedback md-text-danger" role="alert">
                                                <strong>{{ $errors->first('lastname') }}</strong>
                                            </span>
                                        @endif
                                    </li>

                                    <li class="login-lable">
                                        <span>{{__('login.Password')}}<span style="color:#ffb331">*</span></span>
                                    </li>
                                    <li>
                                        <input type="password" name="password" class="input-login{{ $errors->has('password') ? ' md-input-danger' : '' }}" value="{{ old('password') }}">
                                        @if ($errors->has('password'))
                                            <span class="invalid-feedback md-text-danger" role="alert">
                                                <strong>{{ $errors->first('password') }}</strong>
                                            </span>
                                        @endif
                                    </li>
                                
                                    <li class="li-border-bottom">
                                        <span class="login-lable">کشور</span><span style="color:#ffb331">*</span><br>
                                        <select class="js-example-basic-single" name="country" style="width: 100px !important;" data-select2-id="3" tabindex="-1" aria-hidden="true">
                                            @foreach($countries as $value)
                                                <option value="{{$value->id}}">{{$value->name}}</option>
                                            @endforeach
                                        </select>
                                    </li>
                                    <li class="li-border-bottom">
                                        <span class="login-lable">استان</span><span style="color:#ffb331">*</span><br>
                                        <select id="province-option" class="js-example-basic-single" name="province" style="width: 100px !important;" data-select2-id="5" tabindex="-1" aria-hidden="true">
                                            @foreach($provinces as $value)
                                                @if($value->id == 8)
                                                    <option selected value="{{$value->id}}">{{$value->name}}</option>
                                                @else
                                                    <option value="{{$value->id}}">{{$value->name}}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                    </li>
                                
                                    <li class="li-border-bottom">
                                        <span class="login-lable">شهر</span><span style="color:#ffb331">*</span><br>
                                        <select id="city-option" class="js-example-basic-single" name="city" style="width: 100px !important;" data-select2-id="7" tabindex="-1" aria-hidden="true"></select>
                                    </li>

                                    <li class=" login-lable">
                                        <span>{{__('login.Address')}}<span style="color:#ffb331">*</span></span>
                                    </li>
                                    <li>
                                        <input type="text" name="address" class="input-login{{ $errors->has('address') ? ' md-input-danger' : '' }}" value="{{ old('address') }}">
                                    </li>

                                    <li class=" login-lable">
                                        <span>{{__('login.Email')}}<span style="color:#ffb331">*</span></span>
                                    </li>
        
                                    <li>
                                        <input type="text" name="email" class="input-login{{ $errors->has('email') ? ' md-input-danger' : '' }}" value="{{ old('email') }}">
                                    </li>
                                
                                    <li class=" login-lable">
                                        <span>{{__('login.Birthday')}}</span>
                                    </li>
                                    <li class="">
                                        <input name="birth_date" id="birth_date" type="hidden" value="{{ old('birth_date') }}">
                                        <input type="text" class="input-login observer-example {{ $errors->has('birth_date') ? ' md-input-danger' : '' }}" id="initial-value-type-example" readonly autocomplete="off"/>
                                    </li>
                                    <div class="uk-margin">
                                        <label><input class="uk-radio" type="radio" name="gender" value="male" checked><span class="radio-label">مرد</span></label>
                                        <label><input class="uk-radio" type="radio" name="gender" value="female"><span class="radio-label"> زن</span></label>
                                    </div>
                                <li class="li">
                                    <a href="#"><button id="submit-btn" class="uk-button button-login margin-top-bottom">ثبت</button></a>
                                </li>
                            </ul>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <script src="{{ asset('front/Ouath/js/uikit.min.js') }}"></script>
    <script src="{{ asset('front/Ouath/js/uikit-icons.min.js') }}"></script>
    <script src="{{ asset('front/Ouath/js/jquery.js') }}"></script>
    <script src="{{ asset('front/Ouath/js/select2.min.js') }}"></script>
    <script src="{{ asset('front/Ouath/js/croppie.js') }}"></script>
    <script src="https://unpkg.com/persian-date@1.0.5/dist/persian-date.js"></script>
    <script src="https://unpkg.com/persian-datepicker@1.1.3/dist/js/persian-datepicker.js"></script>
    <script>
        $(document).ready(function() {
            $('.js-example-basic-single').select2();
        });
        var def_city = [{!! html_entity_decode($cities) !!}][0];

        var option = {
            language: "fa",
            data: def_city
        };

        var $select = $('#city-option').select2(option);

        $('#province-option').on('select2:select', function (e) {
            console.log(e.params.data.id);

            $.get("/get/cities/"+e.params.data.id , function(data, status){

                option.data = data;

                $select.empty();

                $select.select2(option);
            });

        });


        //start image 1
        $uploadCrop = $('#upload-demo').croppie({
            enableExif: true,
            viewport: {
                width: 150,
                height: 150
            },
            boundary: {
                width: 150,
                height: 150,
                type: 'circle'
            }
        });

        $('#upload-image').on('change', function () {
            $('.cr-viewport').css('background-image' , 'none');
            var reader = new FileReader();
            reader.onload = function (e) {
                $uploadCrop.croppie('bind', {
                    url: e.target.result
                }).then(function(){
                    GetCode();
                });
            }
            reader.readAsDataURL(this.files[0]);
        });


        $('.cr-viewport').click(function () {
            $('#upload-image').trigger('click');
        });

        $('img.cr-image').attr('src' , '{{old('avatar')}}');

        $('.remove_photo_croper').on('click', function() {
            $('.cr-image').attr('src', '');
            $('#upload-image').val('');
            $('#image-code').val('delete');
            $('div.cr-overlay').attr('style' , '');
        });

        function GetCode() {
            $uploadCrop.croppie('result', {
                type: 'canvas',
                size: {
                    width: 150,
                    height: 150,
                    type: 'square'
                },
                format: "jpeg",
                quality: '0.7'
            }).then(function (resp) {
                $('#image-code').val(resp);
            });
        }

        $('.cr-overlay').mouseup(function () {
            GetCode();
        });

        $('.cr-overlay').bind('mousewheel', function(e){
            GetCode();
        });

        $('#initial-value-type-example').persianDatepicker({
            viewMode: 'year',
            initialValue: false,
            format: 'YYYY/MM/DD',
            altField: '.observer-example-alt',
            @if($language != 'fa')
                calendarType: 'gregorian',
            @endif
            maxDate: new persianDate().add('month', 0).valueOf(),
            minDate: new persianDate().subtract('month', 1800).valueOf()
        });

        $(document).on('click', "table.table-days td", function() {
            var time = $(this).attr('data-unix');
            $('#birth_date').val(time);
        });
    </script>
@endsection
