@extends('layouts.login')

@section('header')
<style>
    span.disable{
        color: #9e9b9c !important;
    }
    span.enable{
        color: #0c0c0c !important;
        cursor: pointer !important;
    }
</style>
@endsection
@section('content')
<section id="form-section">
    <div class="uk-container uk-container-expand margin-top">
        <div uk-grid>
            <div class="uk-width-large uk-margin margin-auto" >
                <div class="uk-card uk-card-default uk-card-large login-card" style="margin-bottom: 50px">
                    <div class="uk-card-body uk-text-center" >
                        <p class="uk-text-center p-login-lable">مدیریت رمز عبور</p>
                        <form action="{{route('verification')}}" method="post">
                            @csrf
                            <ul>
                                <li class=" login-lable">
                                    <span>رمز عبور خود را وارد کنید</span>
                                </li>
                                <li>
                                    <input autofocus maxlength="6" type="text" name="verifyCode" value="" class="input-login{{ $errors->has('verifyCode') ? ' md-input-danger' : '' }}" autocomplete="off" />
                                    @if ($errors->has('verifyCode'))
                                    <span class="invalid-feedback md-text-danger" role="alert">
                                            <strong>{{ $errors->first('verifyCode') }}</strong>
                                        </span>
                                    @endif
                                </li>
                                <li class=" li-margin"><a id="change-number" href="{{route('sign-in')}}" class="link-border btn-action">ورود با پیامک</a></li>
                                <li class=" li-margin"><a id="change-number" href="{{route('sign-in')}}" class="link-border btn-action">تغییر شماره</a></li>
                            </ul>
                            <ul>
                                <li class="li">
                                    <button id="submit-btn" type="button" class="uk-button button-login btn-action">{{__('login.Confirm')}}</button>
                                </li>
                            </ul>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<script src="https://yekitaapp.com/cdn/login/js/uikit-icons.min.js"></script>
<script src="https://yekitaapp.com/cdn/login/js/uikit.min.js"></script>
<script src="https://yekitaapp.com/cdn/login/js/jquery.js"></script>
<script src="https://yekitaapp.com/cdn/login/js/select2.min.js"></script>
<script>
    $( document ).ready(function() {
        $('#change-number').click(function (e) {
            $('#loader').removeClass('hidden');
            $('#confirm').addClass('hidden');
            window.location = "mobile_number";
        });
    });
</script>
@endsection