@extends('layouts.login')

@section('header')
    <style>
        span.disable {
            color: #9e9b9c !important;
        }

        span.enable {
            color: #0c0c0c !important;
            cursor: pointer !important;
        }
    </style>
@endsection
@section('content')
    <div id="login-form">
        <div class="uk-container uk-container-expand uk-margin-large-top">
            <div uk-grid>
                <div class="uk-width-large uk-margin margin-auto">
                    <div class="login-card">
                        <div class=" uk-text-center">
                            <form method="post" action="{{ route('authorization-with-password') }}" id="form_validation"
                                  class="uk-form-horizontal">
                                @csrf
                                <ul class="form-header">
                                    <li>
                                        <i class="material-icons">language</i>
                                    </li>

                                    <li>
                                        <p class="uk-text-center p-login-lable uk-margin-medium-bottom">ورود با
                                            پیامک</p>
                                    </li>

                                    <li>
                                        <a href="/"><i class="material-icons">arrow_back</i></a>
                                    </li>

                                </ul>
                                <ul class="uk-text-center uk-margin-medium-bottom">
                                    <li>
                                        <img src="{{asset('front/Ouath/img/pass.svg')}}" class="svg" alt="">
                                    </li>
                                </ul>
                                @if ($errors->has('msg'))
                                    <br>
                                    <span class="invalid-feedback md-text-danger" role="alert">
                                        <strong>{{ $errors->first() }}</strong>
                                    </span>
                                @endif
                                <ul>
                                    <li class=" login-lable">
                                        <span>شماره تلفن</span>
                                    </li>
                                    <li>
                                        <input type="text" required name="mobile" class="input-login">
                                        {{--                                        {{dd($errors)}}--}}
                                        @if ($errors->has('mobile'))
                                            <br><span class="invalid-feedback md-text-danger" role="alert">
                                                <strong>{{ $errors->first('mobile') }}</strong>
                                            </span>
                                        @endif
                                    </li>
                                    <li class=" login-lable">
                                        <span>رمز عبور</span>
                                    </li>
                                    <li class="uk-position-relative">
                                        <img src="{{asset('front/Ouath/img/eye.svg')}}" toggle="#password-field"
                                             class="eye-password toggle-password">
                                        <input class="input-login" id="password-field" name="password" type="password">
                                        @if ($errors->has('password'))
                                            <br><span class="invalid-feedback md-text-danger" role="alert">
                                                <strong>{{ $errors->first('password') }}</strong>
                                            </span>
                                        @endif
                                    </li>
                                    <li class="login-lable uk-margin-large-top">
                                        <a href="{{route('sign-in')}}"><span>ورود با پیامک</span></a>
                                    </li>
                                    <li class="li">
                                        <button type="submit" class="uk-button button-login margin-top-bottom">تایید
                                        </button>
                                    </li>
                                </ul>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="{{ asset('front/Ouath/js/jquery.js') }}"></script>
    <script src="{{ asset('front/Ouath/js/uikit.min.js') }}"></script>
    <script src="{{ asset('front/Ouath/js/uikit-icons.min.js') }}"></script>
    <script src="{{ asset('front/Ouath/js/select2.min.js') }}"></script>
    <script src="{{ asset('front/Ouath/js/croppie.js') }}"></script>
    <script src="https://unpkg.com/persian-date@1.0.5/dist/persian-date.js"></script>
    <script src="https://unpkg.com/persian-datepicker@1.1.3/dist/js/persian-datepicker.js"></script>
    <script>
        $(".toggle-password").click(function () {

            $(this).toggleClass("fa-eye fa-eye-slash");
            var input = $($(this).attr("toggle"));
            if (input.attr("type") == "password") {
                input.attr("type", "text");
            } else {
                input.attr("type", "password");
            }
        });
    </script>
@endsection
