
<!DOCTYPE html>
<html lang="en" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>یکیتا - پلتفرم آموزش مجازی و آنلاین</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
{{--    <link rel="stylesheet" href="https://code.getmdl.io/1.3.0/material.indigo-pink.min.css">--}}
    <link rel="stylesheet" href="{{ asset('front/yekita/css/uikit.min.css') }}">
    <meta name="description" content=" یکیتا پلتفرم آموزش مجازی و آنلاین که امکان ارائه وب سایت اختصاصی آموزش ">
    <link rel="stylesheet" href="{{ asset('front/yekita/css/uikit-rtl.min.css') }}">
    <link rel="stylesheet" href="{{ asset('front/yekita/css/yekita.css') }}">
    <meta property="og:image" content="{{ asset('front/img/logo.png') }}" />
    <link rel="shortcut icon" href="{{ asset("front/img/logo.png") }}" type="image/x-icon">
    <link rel="icon" href="{{ asset("front/img/logo.png") }}" type="image/x-icon">


    
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-104084789-9"></script>
    <script>
    window.dataLayer = window.dataLayer || [];
    function gtag(){dataLayer.push(arguments);}
    gtag('js', new Date());

    gtag('config', 'UA-104084789-9');
    </script>
</head>
<body>
<header>
    @if(session()->has('user_information'))
    <nav class="uk-navbar-container uk-hidden@s uk-margin-medium-bottom" uk-navbar>
        <div class="uk-navbar-center">
            <!-- This is a button toggling the modal -->
            <button class="uk-button button-oauth" type="button" uk-toggle="target: #modal-example">
                <div>
                    @if(!is_null(session()->get('user_information')->avatar))
                        <img src="{{session()->get('user_information')->avatar}}" class="image-user">
                    @endif
                        <p class="name-user">
                            {{session()->get('user_information')->name.' '.session()->get('user_information')->lastname}}
                        </p>
                </div>
            </button>
            <div id="modal-example" class="uk-flex-top" uk-modal>
                <div class="uk-modal-dialog uk-modal-body">
                    <button class="uk-modal-close-default" type="button" uk-close></button>
                    <ul class="uk-list uk-list-large">
                        <ul class="ul-modal">
                            <li class="link-border">
                                <a href="">
                                    <p>
                                        <i class="material-icons material-icons-user">contact_phone</i><span class="detail-material-user">09121261175</span>
                                    </p>
                                </a>
                            </li>
                            <li>
                                <a href="{{route('dash_profile')}}">
                                    <p>
                                        <i class="material-icons material-icons-modal">face</i><span class="detail-material">ویرایش مشخصات</span>
                                    </p>
                                </a>
                            </li>
                            <li>
                                <a href="{{route('dash_manage_password')}}">
                                    <p>
                                        <i class="material-icons material-icons-modal">lock</i><span class="detail-material">ویرایش مشخصات</span>
                                    </p>
                                </a>
                            </li>
                            <li>
                                <a href="{{route('dash_licenses')}}">
                                    <p>
                                        <i class="material-icons material-icons-modal">view_quilt</i><span class="detail-material">ویرایش مشخصات</span>
                                    </p>
                                </a>
                            </li>
                            <li>
                                <a href="{{route('dash_wallet')}}">
                                    <p>
                                        <i class="material-icons material-icons-modal">account_balance_wallet</i><span class="detail-material">کیف پول </span>
                                    </p>
                                </a>
                            </li>
                            <li>
                                <a href="{{route('dash_logout')}}">
                                    <p>
                                        <i class="material-icons material-icons-modal">input</i><span class="detail-material">خروج از حساب کاربری</span>
                                    </p>
                                </a>
                            </li>
                        </ul>
                    </ul>
                </div>
            </div>
        </div>
    </nav>
    <nav class="uk-navbar-container uk-visible@s" uk-navbar>
        <div class="uk-navbar-center">
            <!-- This is a button toggling the modal -->
            <button class="uk-button button-oauth" type="button" >
                <div class="uk-grid padding-top">
                    <div class="no-padding">
                        @if(!is_null(session()->get('user_information')->avatar))
                            <img src="{{session()->get('user_information')->avatar}}" class="image-user">
                        @endif
                        <p class="name-user">
                            {{session()->get('user_information')->name.' '.session()->get('user_information')->lastname}}
                        </p>
                    </div>
                    <div class="no-padding">
                        <i class="material-icons">contact_phone</i>
                        <a href="{{route('dash_licenses')}}"><i class="material-icons" uk-tooltip="title: ناحیه کاربری; pos: right">view_quilt</i></a>
                        <a href="{{route('dash_profile')}}"><i class="material-icons" uk-tooltip="title: ویرایش پروفایل; pos: right">face</i></a>
                        <a href="{{route('dash_wallet')}}"><i class="material-icons" uk-tooltip="title: کیف پول ; pos: right">account_balance_wallet</i></a>
                        <a href="{{route('dash_manage_password')}}"><i class="material-icons" uk-tooltip="title: مدیریت رمز عبور; pos: right">lock</i></a>
                        <a href="{{route('dash_logout')}}"><i class="material-icons" uk-tooltip="title: خروج; pos: right">input</i></a>
                    </div>
                </div>
            </button>
        </div>
    </nav>
@else
        <nav class="uk-navbar-container" uk-navbar>
            <div class="uk-navbar-center">
                <!-- This is a button toggling the modal -->
                <a href="/sign-in">
                    <button class="uk-button button-login" type="button" >
                        <div class="uk-grid">
                            <span class="login-position">ورود / ثبت نام</span>
                        </div>
                    </button>
                </a>
            </div>
        </nav>
        @endif
        <div class="uk-container">
            <nav class="uk-navbar-container uk-navbar uk-grid" uk-navbar="" uk-grid="">
                <div class="uk-text-right no-padding uk-first-column">
                    <ul class="uk-navbar-nav">
                        <li class="uk-active">
                            <a href="/" class="logo"><img src="https://yekitaapp.com/front/img/logo.png" alt="logo"></a>
                        </li>
                        <li>
                            <span class="name-web">یکیتا</span>
                            <p class="title-web">مدیریت آموزش</p>
                        </li>
                    </ul>
                </div>
                <div class="uk-navbar-left-right no-padding">
                    <ul class="uk-navbar-nav menu-contact uk-position-relative">
                        <li class="phone"><a class="phone" href="tel:+989394755974"><i class="material-icons-phone">local_phone</i><span class="span">09394755974</span></a></li>
                        <li><a href="/fa/application"><button class="uk-button buy-button">دوره ها</button></a></li>
{{--                        <li><i class="material-icons-language">language</i></li>--}}
                    </ul>
                </div>
            </nav>
        </div>
</header>
@yield('content')
<a class="uk-button go-top" href="#navbar" uk-scroll><img src="{{ asset('front/yekita/img/go-top.svg') }}" alt=""></a>

<footer>
    <div class="uk-container">
        <div class="wrapper">
            <img src="{{ asset('front/yekita/img/yekita.png')}}" class="yekitaap" alt="yekita">
            <a href="http://www.mysimorgh.com/"><img src="{{ asset('front/yekita/img/simorgh.png')}}" class="simorgh" alt="simorgh"></a>
            <div class="uk-width-1-1 uk-text-center download" id="contact">
                <div class="uk-flex uk-flex-center">
                    <ul>
                        <li><a href="/{{$lang}}/about">درباره یکیتا</a> </li>
                        <li><a href="/{{$lang}}/privacy">قوانین و مقررات</a></li>
                        <li><a href="/{{$lang}}/contact">تماس باما</a> </li>
                    </ul>
                    <ul class="uk-hidden">
                        <li>قیمت</li>
                        <li>شکایات</li>
                        <li>پشتیبانی</li>
                    </ul>
                    <ul class="uk-hidden">
                        <li>مجوز و تاییدیه</li>
                        <li>نسخه آزمایشی</li>
                        <li>همکاران</li>
                    </ul>
                </div>
                <div class="uk-flex uk-flex-center">
                    <ul class="display-nav">
                        <li><a href="https://www.facebook.com/yekita.app.16"><img src="{{ asset('front/yekita/img/Path%20427.svg')}}" alt="facebook" class="facebook"> </a></li>
                        <li><a href="https://www.youtube.com/channel/UC3P7Q5ObxOQn_Pq0anbCAnQ?view_as=subscriber"><img src="{{ asset('front/yekita/img/Path%20428.svg')}}" alt="youtube" class="social"></a></li>
                        <li><a href="https://www.pinterest.com/myyekita/"><img src="{{ asset('front/yekita/img/Path%20429.svg')}}" alt="pinterest" class="social"></a></li>
                        <li><a href="https://www.linkedin.com/company/yekita-app/"><img src="{{ asset('front/yekita/img/Path%20430.svg')}}" alt="linkedin" class="social"></a></li>
                        <li><a href="https://twitter.com/AppYekita"><img src="{{ asset('front/yekita/img/Path%20431.svg')}}" alt="twitter" class="social"></a></li>
                        <li><a href="https://www.instagram.com/yekita.app/?hl=en"><img src="{{ asset('front/yekita/img/Path%20432.svg')}}" alt="instagram" class="social"></a></li>
                        <li><a href="https://www.aparat.com/yekita.app"><img src="{{ asset('front/yekita/img/Path%20433.svg')}}" alt="aparat" class="social"></a></li>
                        <li><a href="https://t.me/yekitaapp"><img src="{{ asset('front/yekita/img/Path%20434.svg')}}" alt="telegram" class="social"></a></li>
                    </ul>
                </div>
            </div>
            <div class="uk-flex uk-flex-center">
                <ul>
                    <li class="pre">لوگو، کاراکتر و نرم افزار یکیتا ثبت شده
                        و تحت حمایت قانون مالکیت معنوی است.
                    </li>
                </ul>
            </div>
            <div class="uk-width-1-1 uk-text-center download">
                <div class="clearfix border-blue">
                    <img src="{{ asset('front/yekita/img/Union%203.svg')}}" alt="">
                    <p class="download">اپلیکیشن یکیتا | دانلود کنید</p>
                </div>
                <ul class="ul-list">
                    <li><img src="{{ asset('front/yekita/img/Group%20103.svg')}}" alt="Qrapple"></li>
                    <li><a href="https://play.google.com/store/apps/details?id=com.mysimorgh.workshop"><img src="{{ asset('front/yekita/img/Group%20100.svg')}}" alt="googleplay"></a></li>
                    <li><a href="http://bit.ly/2IriQNp"><img src="{{ asset('front/img/iapps.svg')}}" alt="appatore" style="width: 150px;height: 33px;"></a></li>
                    <li><img src="{{ asset('front/yekita/img/Group%20104.svg')}}" alt="Qrgoogle"></li>
                </ul>
            </div>
        </div>
    </div>
</footer>
<script src="{{ asset('front/yekita/js/jquery.js') }}"></script>
<script src="{{ asset('front/yekita/js/uikit.min.js') }}"></script>
<script src="{{ asset('front/yekita/js/uikit-icons.min.js') }}"></script>
{{--<script defer src="https://code.getmdl.io/1.3.0/material.min.js"></script>--}}
@yield('footer')
</body>
</html>
