<!DOCTYPE html>
<html lang="{{ $language }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="canonical" href="index.html">
    <title>{{ $page_title }}</title>
    <link rel="stylesheet" href="{{ asset('dashboard/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
    <link rel="stylesheet" href="https://code.getmdl.io/1.3.0/material.indigo-pink.min.css">
    @if($language == 'fa' || $language == 'ar')
        <link rel="stylesheet" href="{{ asset('dashboard/css/bootstrap-rtl.min.css') }}">
    @endif

    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.3.1/css/all.css" integrity="sha384-mzrmE5qonljUremFsqc01SB46JvROS7bZs3IO2EmfFsd15uHvIt+Y8vEf7N7fWAU" crossorigin="anonymous">
    <link rel="stylesheet" href="{{ asset('dashboard/css/datatables.css') }}" media="all">
    <link rel="stylesheet" href="{{ asset('dashboard/css/main.css') }}">
    @yield('header')
</head>
<body>

<nav class="navbar navbar-default" role="navigation">
    <div class="container">
        <div class="navbar-header">
            <a id="menu-toggle" href="#" class="navbar-toggle">
                <span class="sr-only">Toggle navigation</span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
            </a>
            <a class="navbar-brand" href="{{route('home.1')}}">
                <i class="fas fa-home"></i>
            </a>
        </div>
        <div id="sidebar-wrapper" class="sidebar-toggle">
            <ul class="sidebar-nav">

                <li class="li-user-avatar">
                    <a href="{{route('dash_licenses')}}">{{__('dashboard.My licenses')}}</a>
                </li>
                <!--
                <li>
                    <a href="{{route('dash_credit')}}">{{__('dashboard.Creation course credits')}}</a>
                </li>
                <li>
                    <a href="{{route('dash_sms')}}">{{__('dashboard.SMS')}}</a>
                </li>

                <li>
                    <a href="{{route('dash_shop')}}">{{__('dashboard.Store')}}</a>
                </li>
                -->
                <li>
                    <a href="{{route('dash_wallet')}}">{{__('dashboard.Wallet')}}</a>
                </li>
                <!--
                <li>
                    <a href="{{route('dash_event')}}">{{__('dashboard.Events')}}</a>
                </li>
                -->
                <li>
                    <a href="{{route('dash_invoices')}}">{{__('dashboard.The bills')}}</a>
                </li>
            </ul>
        </div>
    </div>
</nav>
<div class="main">
    <div class="container-fluid">
        <div class="main-content">
            <div class="col-xs-12 text-center">
                <a >
                    <button type="button" class="button-information-user" data-toggle="modal" data-target="#myModal">
                        <div class="">
                            <p class="name-information-user">{{session()->get('user_information')->name.' '.session()->get('user_information')->lastname}} </p>
                        </div>
                        @if(!is_null(session()->get('user_information')->avatar))
                            <img src="{{session()->get('user_information')->avatar}}" class="img-information-user">
                        @endif

                    </button>
                    <div class="modal fade" id="myModal" role="dialog">
                        <div class="modal-dialog">

                            <!-- Modal content-->
                            <div class="modal-content">
                                <div class="modal-body">
                                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                                    <ul class="uk-list uk-list-large">
                                        <ul class="ul-modal">
                                            <li class="link-border">
                                                <p>
                                                    <i class="material-icons material-icons-user">contact_phone</i><span class="detail-material-user">{{session()->get('user_information')->mobile_number}}</span>
                                                </p>
                                            </li>
                                            <li class="margin-bottom-modal">
                                                <a href="{{route('dash_licenses')}}">
                                                    <p>
                                                        <i class="material-icons material-icons-modal">view_quilt</i><span class="detail-material">ناحیه کاربری</span>
                                                    </p>
                                                </a>
                                            </li>
                                            <li class="margin-bottom-modal">
                                                <a href="{{route('dash_profile')}}">
                                                    <p>
                                                        <i class="material-icons material-icons-modal">face</i><span class="detail-material">ویرایش مشخصات</span>
                                                    </p>
                                                </a>
                                            </li>
                                            <li class="margin-bottom-modal">
                                                <a href="{{route('dash_manage_password')}}">
                                                    <p>
                                                        <i class="material-icons material-icons-modal">lock</i><span class="detail-material">مدیریت رمز عبور</span>
                                                    </p>
                                                </a>
                                            </li>
                                            <li class="margin-bottom-modal">
                                                <a href="{{route('dash_wallet')}}">
                                                    <p>
                                                        <i class="material-icons material-icons-modal">account_balance_wallet</i><span class="detail-material">کیف پول </span>
                                                    </p>
                                                </a>
                                            </li>
                                            {{--<li>--}}
                                            {{--<a href="">--}}
                                            {{--<p>--}}
                                            {{--<i class="material-icons material-icons-modal">language</i><span class="detail-material">language</span>--}}
                                            {{--</p>--}}
                                            {{--</a>--}}
                                            {{--</li>--}}
                                            <li class="margin-bottom-modal">
                                                <a href="{{route('dash_logout')}}">
                                                    <p>
                                                        <i class="material-icons material-icons-modal">input</i><span class="detail-material">خروج از حساب کاربری</span>
                                                    </p>
                                                </a>
                                            </li>
                                        </ul>

                                    </ul>
                                </div>
                            </div>

                        </div>
                    </div>
                </a>
            </div>
            <div class="header">
                <h3>{{ $page_title }}</h3>
            </div>
            <div class="content-body">
                @yield('content')
            </div>
        </div>
    </div>
</div>
<!-- Modal -->

<!--/.container-->
<!-- /#wrapper -->
<!-- Menu Toggle Script -->
<script src="{{ asset('dashboard/js/jquery.min.js') }}"></script>
<script src="{{ asset('dashboard/js/bootstrap.min.js') }}"></script>
<script src="{{ asset('dashboard/js/fontawesome.min.js') }}"></script>
@yield('footer')
<script>
    $(window).resize(function() {
        var path = $(this);
        var contW = path.width();
        if(contW >= 751){
            document.getElementsByClassName("sidebar-toggle")[0].style.right="200px";
        }else{
            document.getElementsByClassName("sidebar-toggle")[0].style.right="-200px";
        }
    });
    $(document).ready(function() {
        $('.dropdown').on('show.bs.dropdown', function(e){
            $(this).find('.dropdown-menu').first().stop(true, true).slideDown(300);
        });
        $('.dropdown').on('hide.bs.dropdown', function(e){
            $(this).find('.dropdown-menu').first().stop(true, true).slideUp(300);
        });
        $("#menu-toggle").click(function(e) {
            e.preventDefault();
            var elem = document.getElementById("sidebar-wrapper");
            right = window.getComputedStyle(elem,null).getPropertyValue("right");
            if(right == "200px"){
                document.getElementsByClassName("sidebar-toggle")[0].style.right="-200px";
            }
            else if(right == "-200px"){
                document.getElementsByClassName("sidebar-toggle")[0].style.right="200px";
            }
        });
    });
</script>
</body>
</html>