
<!doctype html>
<!--[if lte IE 9]> <html class="lte-ie9" lang="en" dir="rtl"> <![endif]-->
<!--[if gt IE 9]><!--> <html lang="en" dir="rtl"> <!--<![endif]-->

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="initial-scale=1.0,maximum-scale=1.0,user-scalable=no">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Remove Tap Highlight on Windows Phone IE -->
    <meta name="msapplication-tap-highlight" content="no"/>

    <link rel="icon" type="image/png" href="{{ asset('admin/assets/img/favicon-16x16.png') }}" sizes="16x16">
    <link rel="icon" type="image/png" href="{{ asset('admin/assets/img/favicon-32x32.png') }}" sizes="32x32">

    <title>{{$page_title}}</title>
    <link rel="stylesheet" href="{{ asset('admin/assets/css/weather-icons.css') }}" media="all">
    <link rel="stylesheet" href="{{ asset('admin/assets/css/metricsgraphics.css') }}" media="all">
    <link rel="stylesheet" href="{{ asset('admin/assets/css/chartist.css') }}" media="all">
    <link rel="stylesheet" href="{{ asset('admin/assets/css/dropify.css') }}" media="all">
    <!-- uikit rtl -->
    <link rel="stylesheet" href="{{ asset('admin/assets/css/uikit.rtl.css') }}" media="all">

    <!-- flag icons -->
    <link rel="stylesheet" href="{{ asset('admin/assets/icons/flags/flags.min.css') }}" media="all">
    <link rel="stylesheet" href="{{ asset('admin/assets/css/style_switcher.css') }}" media="all">

    <!-- altair admin -->
    <link rel="stylesheet" href="{{ asset('admin/assets/css/main.css') }}" media="all">
    <!-- themes -->
    <link rel="stylesheet" href="{{ asset('admin/assets/css/themes/themes_combined.min.css') }}" media="all">
    <link rel="stylesheet" href="{{ asset('admin/assets/css/themes/simorgh_theme.css') }}" media="all">
    <link rel="stylesheet" href="{{ asset('admin/assets/css/jquery.fancybox.min.css') }}" media="all">

    <!-- matchMedia polyfill for testing media queries in JS -->
    <!--[if lte IE 9]>
    <script type="text/javascript" src="{{ asset('admin/bower_components/matchMedia/matchMedia.js') }}"></script>
    <script type="text/javascript" src="{{ asset('admin/bower_components/matchMedia/matchMedia.addListener.js') }}"></script>
    <link rel="stylesheet" href="{{ asset('admin/assets/css/ie.css') }}" media="all">
    <![endif]-->
    <link href='{{asset('calendar/css/fullcalendar.css')}}' rel='stylesheet' />
    <link href='{{asset('calendar/css/customize.css')}}' rel='stylesheet' />
    <link href='{{asset('calendar/css/fancymetags.css')}}' rel='stylesheet' />
    <link rel="stylesheet" href="https://unpkg.com/persian-datepicker@1.1.3/dist/css/persian-datepicker.css"/>
    <script src="{{asset('calendar/js/jquery.min.js')}}"></script>
    <script src="{{asset('calendar/js/jqueryui.js')}}"></script>
    <script src="{{asset('calendar/js/index.js')}}"></script>
    @yield('header')

</head>
<body class="app_simorgh_theme sidebar_main_open sidebar_main_swipe">
<!-- main header -->
<header id="header_main">
    <div class="header_main_content">
        <nav class="uk-navbar">

            <!-- main sidebar switch -->
            <a href="#" id="sidebar_main_toggle" class="sSwitch sSwitch_left">
                <span class="sSwitchIcon"></span>
            </a>

            <!-- secondary sidebar switch -->
            <a href="#" id="sidebar_secondary_toggle" class="sSwitch sSwitch_right sidebar_secondary_check">
                <span class="sSwitchIcon"></span>
            </a>

            <div class="uk-navbar-flip">
                <ul class="uk-navbar-nav user_actions">
                    <li data-uk-dropdown="{mode:'click',pos:'bottom-right'}">
                        <a href="#" class="user_action_image"><img class="md-user-image" src="" alt=""/></a>
                        <div class="uk-dropdown uk-dropdown-small">
                            <ul class="uk-nav js-uk-prevent user-actions">
                                <li>
                                    <a href="page_user_profile.html">
                                        <span class="menu_icon icon-wrap"><i class="material-icons">mode_edit</i></span>
                                        <span class="menu_title">ویرایش مشخصات</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="login.html">
                                        <span class="menu_icon icon-wrap"><i class="material-icons">exit_to_app</i></span>
                                        <span class="menu_title">خروج از حساب کاربری</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                </ul>
            </div>
        </nav>
    </div>

</header><!-- main header end -->
<!-- main sidebar -->
<aside id="sidebar_main">
    <div class="sidebar_main_header">
        <div class="sidebar_logo">
            <a href="index.html" class="sSidebar_hide sidebar_logo_large">
            </a>
        </div>
    </div>
    <div class="menu_section">
        <ul>
            @hasanyrole('manager|content')
            <li title="بلاگ">
                <ul id='menu'>
                    <li>
                        <a class='prett' href='#' title='Menu'>
                            <span class="menu_icon icon-wrap"><i class="material-icons">import_contacts</i></span>
                            <span class="menu_title">بلاگ</span>
                        </a>
                        <ul class='menus' style="display: none">
                            <li><a href='{{route('list_blog')}}' title='Dropdown 2'>لیست بلاگ</a></li>
                            <li><a href='{{route('create_blog')}}' title='Dropdown 3'>افزودن بلاگ</a></li>
                        </ul>
                    </li>
                </ul>
            </li>
            @endhasanyrole
            @hasanyrole('manager|course')
            <li title="دوره های آموزشی">
                <a href="{{route('list_course')}}">
                    <span class="menu_icon icon-wrap"><i class="material-icons">group</i></span>
                    <span class="menu_title">دوره های آموزشی</span>
                </a>
            </li>
            @endhasanyrole
            @hasanyrole('manager|users')
            <li title="کاربران">
                <ul id='menu'>
                    <li>
                        <a class='prett' href='#' title='Menu'>
                            <span class="menu_icon icon-wrap"><i class="material-icons">record_voice_over</i></span>
                            <span class="menu_title">کاربران</span>
                        </a>
                        <ul class='menus' style="display: none">
                            <li><a href='{{route('users_list')}}' title='Dropdown 2'>لیست کاربران</a></li>
                            <!--
                            <li><a href='#' title='Dropdown 3'>افزودن کاربر</a></li>
                            -->
                        </ul>
                    </li>
                </ul>
            </li>
            @endhasanyrole
            @hasanyrole('manager|financial')
            <li title="مالی">
                <ul id='menu'>
                    <li>
                        <a class='prett' href='#' title='Menu'>
                            <span class="menu_icon icon-wrap"><i class="material-icons">attach_money</i></span>
                            <span class="menu_title">مالی</span>
                        </a>
                        <ul class='menus' style="display: none">
                            <li>
                                <a href='{{route('invoices')}}' title='Dropdown 2'>صورت حساب</a>
                            </li>
                        <!--
                            <li><a href='{{route('products')}}' title='Dropdown 3'>لیست محصولات</a></li>
                            <li><a href='#' title='Dropdown 4'>افزودن محصول</a></li>
                            -->
                        </ul>
                    </li>
                </ul>
            </li>
            @endhasanyrole
            @hasanyrole('manager|event')
            <li title="رویداد">
                <a href="{{route('events')}}">
                    <span class="menu_icon icon-wrap"><i class="material-icons">calendar_view_day</i></span>
                    <span class="menu_title">رویداد</span>
                </a>
            </li>
            @endhasanyrole
            @hasanyrole('manager')
            <li title="تنظیمات">
                <a href="{{route('setting')}}">
                    <span class="menu_icon icon-wrap"><i class="material-icons">settings</i></span>
                    <span class="menu_title">تنظیمات</span>
                </a>
            </li>
            @endhasanyrole
            <li title="خروج">
                <a onclick="logout()">
                    <form id="logout" method="post" action="{{route('logout')}}">
                        @csrf
                        <span class="menu_icon icon-wrap"><i class="material-icons">settings</i></span>
                        <span class="menu_title">خروج</span>
                    </form>
                </a>
            </li>
        </ul>
    </div>
</aside><!-- main sidebar end -->

<div id="page_content">
    @yield('content')
</div>

<footer id="footer" class="uk-visible-small">
    <div class="footer_main_content">
        <div class="uk-grid uk-vertical-align uk-text-center">

        </div>
    </div>
</footer>
<!-- common functions -->
<script src="{{ asset('admin/assets/js/common.min.js') }}"></script>
<!-- uikit functions -->
<script src="{{ asset('admin/assets/js/uikit_custom.min.js') }}"></script>
<!-- altair common functions/helpers -->
<script src="{{ asset('admin/assets/js/altair_admin_common.min.js') }}"></script>

<script src="{{ asset('admin/assets/js/jquery.fancybox.min.js') }}"></script>
<script src='{{asset('calendar/js/moment.min.js')}}'></script>
<script src='{{asset('calendar/js/moment-jalaali.js')}}'></script>
<script src='{{asset('calendar/js/fullcalendar.js')}}'></script>
<script src='{{asset('calendar/js/callendar.js')}}'></script>
<script src='{{asset('calendar/lang/fa.js')}}'></script>
<script src='{{asset('calendar/js/fancymetags.js')}}'></script>
<script src="https://unpkg.com/persian-date@1.0.5/dist/persian-date.js"></script>
<script src="https://unpkg.com/persian-datepicker@1.1.3/dist/js/persian-datepicker.js"></script>
<script>
    function show1(){
        document.getElementById('div2').style.display ='none';
        document.getElementById('div4').style.display ='none';
        document.getElementById('div5').style.display ='none';
        document.getElementById('div1').style.display = 'block';
    }


    function create_event() {
        var id_event   = $('#id_event').val();
        var start_date = $('#start_date').val();
        var start_time = $('#start_time').val();
        var end_date   = $('#end_date').val();
        var end_time   = $('#end_time').val();
        var title      = $('#modalTitle').val();
        var type       = "private";
        var lang       = 'fa';
        if(title == ''){
            $('#modalTitle').addClass("input-danger");
            return;
        }else {
            $('#modalTitle').removeClass("input-danger");
        }
        $(".close-btn").trigger('click');
        $.post(
            "<?= base_url(); ?>dashboard/event/create_event_personal",
            {id_event:id_event , title: title , lang: lang , type: type , start_date: start_date , start_time: start_time , end_date: end_date , end_time: end_time , reminder_date: "" , reminder_time: "" },
            function(result){
                insert_event(result.title , result.start , result.end , result.color , result.start_date , result.start_time , result.end_date , result.end_time );
            });
    }

    function insert_event(title, start, end , color , start_date , start_time , end_date , end_time) {
        var formData = {
            'title'              : title,
            'description'        : 'description',
            'start'              : start,
            'end'                : end,
            'color'              : color,
            'start_date'         : start_date,
            'start_time'         : start_time,
            'end_date'           : end_date,
            'end_time'           : end_time
        };
        $('#calendar').fullCalendar('renderEvent', formData, true); // stick? = true
        $('#calendar').fullCalendar('unselect');
    }

    $(".popup-btn").fancybox({
        'closeBtn'    : false
    });
    var close_btn = $(document).find('.close-btn');
    close_btn.on('click',function() {
        $.fancybox.close( true );
    });

    var my_events = [];
    $(document).ready(function() {

        var lang_web = $('html').attr('lang');
        var isJalaali = false;
        var isRTL = false;
        if(lang_web == 'fa'){isJalaali = true; isRTL = true;}
        var start_date = '2018-11-27';

        $(function() {
            var type_events = ["general_events" , "google_events" , "yekita_events"];
            $('.events-filter-checkbox').click(function () {
                var type = $(this).val();
                if ($(this).is(':checked')) {
                    type_events.push(type);
                }else{
                    var index = type_events.indexOf(type);
                    if (index > -1) {
                        type_events.splice(index, 1);
                    }
                }
                $(".fc-custom1-button").trigger('click');
                setTitle();
            });
            $('#calendar').fullCalendar({
                header: {
                    left: 'prev,next today,custom1',
                    center: 'title',
                    right: 'month,agendaWeek,agendaDay'
                },
                views: {
                    week: {
                        titleFormat: 'D',
                        titleRangeSeparator: '-',
                    },
                    day: {
                        titleFormat: ' D MMMM YYYY '
                    }
                },
                lang: lang_web,
                isJalaali: isJalaali,
                isRTL: isRTL,
                editable: true,
                eventLimit: true,
                eventLimitText: "رویداد ها",
                defaultDate: datetime,
                selectable: true,
                selectHelper: true,
                select: function(startDate, endDate) {
                    $('#modalTitle').val('');
                    $.post("<?= base_url(); ?>dashboard/event/standard_date",
                        {
                            start: startDate.format(),
                            end: endDate.format()
                        },
                        function(events){
                            $('#start_date').val(events.start);
                            $('#end_date').val(events.end);
                        });
                },
                eventClick:  function(event, jsEvent, view) {

                    var start_date = event.start_date;
                    start_date = start_date.replace(/\//g, '-')+'T12:00';
                    var end_date = event.end_date;
                    end_date = end_date.replace(/\//g, '-')+'T12:00';
                    $.post("<?= base_url(); ?>dashboard/event/standard_date_view",
                        {
                            title: '',
                            color: '',
                            date: start_date
                        },
                        function(events){
                            console.log(events.date);
                            $('#start_date').val(events.date);
                        });

                    $.post("<?= base_url(); ?>dashboard/event/standard_date_view",
                        {
                            title: '',
                            color: '',
                            date: end_date
                        },
                        function(events){
                            console.log(events.date);
                            $('#end_date').val(events.date);
                        });

                    $('#id_event').val(event.id);
                    $('#start_time').val(event.start_time);
                    $('#end_time').val(event.end_time);
                    $('#modalTitle').val(event.title);

                    $('#delete-event').click(function (events) {
                        var id = $('#id_event').val();
                        $('#calendar').fullCalendar('removeEvents', id);
                        $("#calendar").fullCalendar('addEventSource', events);
                        $.post("<?= base_url(); ?>dashboard/event/delete", { event_id: id });
                    });
                },
                events: function(start, end, timezone, callback) {
                    start_date = start.format('YYYY-MM-DD');
                    $.post("<?= base_url(); ?>dashboard/event/list",
                        {
                            types: type_events,
                            date: start.format('YYYY-MM-DD'),
                            lang: 'en'
                        },
                        function(events){
                            my_events = events;
                            event_list(events);
                            callback(events);
                        });
                },
                customButtons: {
                    custom1: {
                        text: 'custom 1',
                        click: function() {
                            $.post("<?= base_url(); ?>dashboard/event/list",
                                {
                                    types: type_events,
                                    date: start_date,
                                    lang: 'en'
                                },
                                function(events){
                                    my_events = events;
                                    $('#calendar').fullCalendar('removeEvents');
                                    var length = Object.keys(events).length;
                                    for (var i = 0 ; i < length ; i++ ){
                                        $('#calendar').fullCalendar('renderEvent', events[i]);
                                    }
                                    event_list(events);
                                });
                        }
                    }
                }
            });

        });

        setTimeout(function () {
            setTitle();
        } , 100);

    });

    $('#event_title_search').keyup(function () {
        search_events();
    });

    function event_list(events) {
        $('#event-title').html('');
        var length = Object.keys(events).length;
        for (var i = 0 ; i < length ; i++){
            var title = events[i].title;
            if(title == null || title == ''){ title = 'بدون عنوان'; }
            $.post("<?= base_url(); ?>dashboard/event/standard_date_view",
                {
                    title: title,
                    color: events[i].color,
                    date: events[i].start
                },
                function(event_info){
                    $('#event-title').append(
                        '<ul class="md-list uk-grid" id="no-border-list">' +
                        '<li class="uk-width-medium-1-2">' +
                        '<i class="material-icons-private" style="color: '+event_info.color+' !important;">today</i><span class="event-list-title">'+event_info.title+'</span>' +
                        '</li>' +
                        '<li class="uk-width-medium-1-2 li-date-event">' +
                        '<span class="event-list-title">'+event_info.date+'</span>' +
                        '</li>' +
                        '</ul>');
                });
        }
    }

    function search_events() {
        var searchTerm = $('#event_title_search').val();
        var Start      = $('#start_search').val();
        var End        = $('#end_search').val();
        var results = my_events.filter(function(my_event) {
            return my_event.title.indexOf(searchTerm) > -1;
        });
        var length = Object.keys(results).length;
        var events_reulte = [];
        for (var i = 0 ; i < length ; i++){
            events_reulte.push(results[i]);
        }
        event_list(events_reulte);
    }

    $('.time-picker').persianDatepicker({
        onlyTimePicker: true,
        format: 'HH:MM',

    });

    $('#left-btn').click(function () {
        $(".fc-next-button").trigger('click');
        setTitle();
    });
    $('#right-btn').click(function () {
        $(".fc-prev-button").trigger('click');
        setTitle();
    });
    $('#month-btn').click(function () {
        $(".fc-month-button").trigger('click');
        setTitle();
    });
    $('#week-btn').click(function () {
        $(".fc-agendaWeek-button").trigger('click');
        setTitle();
    });
    $('#day-btn').click(function () {
        $(".fc-agendaDay-button").trigger('click');
        setTitle();
    });
    $('#month-btn-1').click(function () {
        $(".fc-month-button").trigger('click');
        setTitle();
    });
    $('#week-btn-1').click(function () {
        $(".fc-agendaWeek-button").trigger('click');
        setTitle();
    });
    $('#day-btn-1').click(function () {
        $(".fc-agendaDay-button").trigger('click');
        setTitle();
    });
    $('td.fc-day-number').click(function () {
        $(".fc-agendaDay-button").trigger('click');
        setTitle();
    });

    function setTitle() {
        var title = $('#calendar>.fc-toolbar>.fc-center>h4').html();
        $('#title-calender').html(title);
    }

    $('.initial-date').persianDatepicker({
        initialValue: true,
        format: 'YYYY/MM/DD',
        autoClose: true
    });

    $(function() {
        $("#tagfield").fancymetags({theme: "black"});
    });

    function startTime() {
        var today = new Date();
        var h = today.getHours();
        var m = today.getMinutes();
        var s = today.getSeconds();
        m = checkTime(m);
        s = checkTime(s);
        document.getElementById('txt').innerHTML =
            h + ":" + m + ":" + s;
        var t = setTimeout(startTime, 500);
    }
    function checkTime(i) {
        if (i < 10) {i = "0" + i};  // add zero in front of numbers < 10
        return i;
    }
</script>
@yield('footer')

</body>
</html>