<!doctype html>
<!--[if lte IE 9]> <html class="lte-ie9" lang="en" dir="rtl"> <![endif]-->
<!--[if gt IE 9]><!--> <html lang="en" dir="rtl"> <!--<![endif]-->

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="initial-scale=1.0,maximum-scale=1.0,user-scalable=no">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Remove Tap Highlight on Windows Phone IE -->
    <meta name="msapplication-tap-highlight" content="no"/>

    <link rel="icon" type="image/png" href="{{ asset('admin/assets/img/favicon-16x16.png') }}" sizes="16x16">
    <link rel="icon" type="image/png" href="{{ asset('admin/assets/img/favicon-32x32.png') }}" sizes="32x32">

    <title>{{$page_title}}</title>

    <!-- uikit rtl -->

    <link rel="stylesheet" href="{{ asset('front/yekita/css/uikit-rtl.min.css') }}">

    <!-- flag icons -->
    <link rel="stylesheet" href="{{ asset('admin/assets/icons/flags/flags.min.css') }}" media="all">

    <!-- altair admin -->
    <link rel="stylesheet" href="{{ asset('admin/assets/css/main.css') }}" media="all">

    <link rel="stylesheet" href="{{ asset('admin/assets/css/jquery.fancybox.min.css') }}" media="all">

    <!-- themes -->
    <link rel="stylesheet" href="{{ asset('admin/assets/css/themes/themes_combined.min.css') }}" media="all">
    <link rel="stylesheet" href="{{ asset('admin/assets/css/themes/simorgh_theme.css') }}" media="all">

    <!-- matchMedia polyfill for testing media queries in JS -->
    <!--[if lte IE 9]>
    <script type="text/javascript" src="{{ asset('admin/bower_components/matchMedia/matchMedia.js') }}"></script>
    <script type="text/javascript" src="{{ asset('admin/bower_components/matchMedia/matchMedia.addListener.js') }}"></script>
    <link rel="stylesheet" href="{{ asset('admin/assets/css/ie.css') }}" media="all">
    <![endif]-->

    @yield('header')

</head>
<body class="app_simorgh_theme sidebar_main_open sidebar_main_swipe">
<!-- main header -->
<header id="header_main">
    <div class="header_main_content">
        <nav class="uk-navbar">

            <!-- main sidebar switch -->
            <a href="#" id="sidebar_main_toggle" class="sSwitch sSwitch_left">
                <span class="sSwitchIcon"></span>
            </a>

            <!-- secondary sidebar switch -->
            <a href="#" id="sidebar_secondary_toggle" class="sSwitch sSwitch_right sidebar_secondary_check">
                <span class="sSwitchIcon"></span>
            </a>

            <div class="uk-navbar-flip">
                <ul class="uk-navbar-nav user_actions">
                    <li data-uk-dropdown="{mode:'click',pos:'bottom-right'}">
                        <a href="#" class="user_action_image"><img class="md-user-image" src="assets/img/avatars/avatar_11_tn@4x.png" alt=""/></a>
                        <div class="uk-dropdown uk-dropdown-small">
                            <ul class="uk-nav js-uk-prevent user-actions">
                                <li><a href="page_user_profile.html">
                                        <span class="menu_icon icon-wrap"><i class="material-icons">mode_edit</i></span>
                                        <span class="menu_title">ویرایش مشخصات</span>
                                    </a></li>
                                <li><a href="login.html">
                                        <span class="menu_icon icon-wrap"><i class="material-icons">exit_to_app</i></span>
                                        <span class="menu_title">خروج از حساب کاربری</span>
                                    </a></li>
                            </ul>
                        </div>
                    </li>
                </ul>
            </div>
        </nav>
    </div>

</header><!-- main header end -->
<!-- main sidebar -->
<aside id="sidebar_main">
    <div class="sidebar_main_header">
        <div class="sidebar_logo">
            <a href="index.html" class="sSidebar_hide sidebar_logo_large">
            </a>
        </div>
    </div>
    <div class="menu_section">
        <ul>
            @hasanyrole('manager|content')
            <li title="بلاگ">
                <ul id='menu'>
                    <li>
                        <a class='prett' href='#' title='Menu'>
                            <span class="menu_icon icon-wrap"><i class="material-icons">import_contacts</i></span>
                            <span class="menu_title">بلاگ</span>
                        </a>
                        <ul class='menus' style="display: none">
                            <li><a href='{{route('list_blog')}}' title='Dropdown 2'>لیست بلاگ</a></li>
                            <li><a href='{{route('create_blog')}}' title='Dropdown 3'>افزودن بلاگ</a></li>
                        </ul>
                    </li>
                </ul>
            </li>
            @endhasanyrole
            @hasanyrole('manager')
            <li title="فروشگاه">
                <ul id='shop'>
                    <li>
                        <a class='prett' href='#' title='Menu'>
                            <span class="menu_icon icon-wrap"><i class="material-icons">shop</i></span>
                            <span class="menu_title">فروشگاه</span>
                        </a>
                        <ul class='menus' style="display: none">
                            <li><a href='{{route('all_products')}}' title='Dropdown 2'>محصولات</a></li>
                            <li><a href='{{route('all_discounts')}}' title='Dropdown 3'>کد تخفیف</a></li>
                        </ul>
                    </li>
                </ul>
            </li>
            @endhasanyrole
            @hasanyrole('manager|course')
            <li title="دوره های آموزشی">
                <a href="{{route('list_course')}}">
                    <span class="menu_icon icon-wrap"><i class="material-icons">group</i></span>
                    <span class="menu_title">دوره های آموزشی</span>
                </a>
            </li>
            @endhasanyrole
            @hasanyrole('manager|users')
            <li title="کاربران">
                <ul id='menu'>
                    <li>
                        <a class='prett' href='#' title='Menu'>
                            <span class="menu_icon icon-wrap"><i class="material-icons">record_voice_over</i></span>
                            <span class="menu_title">کاربران</span>
                        </a>
                        <ul class='menus' style="display: none">
                            <li><a href='{{route('users_list')}}' title='Dropdown 2'>لیست کاربران</a></li>
                            <!--
                            <li><a href='#' title='Dropdown 3'>افزودن کاربر</a></li>
                            -->
                        </ul>
                    </li>
                </ul>
            </li>
            @endhasanyrole
            @hasanyrole('manager|financial')
            <li title="مالی">
                <ul id='menu'>
                    <li>
                        <a class='prett' href='#' title='Menu'>
                            <span class="menu_icon icon-wrap"><i class="material-icons">attach_money</i></span>
                            <span class="menu_title">مالی</span>
                        </a>
                        <ul class='menus' style="display: none">
                            <li><a href='{{route('invoices')}}' title='Dropdown 2'>صورت حساب</a></li>
                            <!--
                            <li><a href='{{route('products')}}' title='Dropdown 3'>لیست محصولات</a></li>
                            <li><a href='#' title='Dropdown 4'>افزودن محصول</a></li>
                            -->
                        </ul>
                    </li>
                </ul>
            </li>
            @endhasanyrole
            @hasanyrole('manager|event')
            <li title="رویداد">
                <a href="{{route('events')}}">
                    <span class="menu_icon icon-wrap"><i class="material-icons">calendar_view_day</i></span>
                    <span class="menu_title">رویداد</span>
                </a>
            </li>
            @endhasanyrole
            
            @hasanyrole('manager')
            <li title="تنظیمات">
                <a href="{{route('setting')}}">
                    <span class="menu_icon icon-wrap"><i class="material-icons">settings</i></span>
                    <span class="menu_title">تنظیمات</span>
                </a>
            </li>
            @endhasanyrole
            <li title="خروج">
                <a onclick="logout()">
                    <form id="logout" method="post" action="{{route('logout')}}">
                        @csrf
                            <span class="menu_icon icon-wrap"><i class="material-icons">exit_to_app</i></span>
                            <span class="menu_title">خروج</span>
                    </form>
                </a>
            </li>
        </ul>
    </div>
</aside><!-- main sidebar end -->

<div id="page_content">
    @yield('content')
</div>



<footer id="footer" class="uk-visible-small">
    <div class="footer_main_content">
        <div class="uk-grid uk-vertical-align uk-text-center">

        </div>
    </div>
</footer>

<!-- common functions -->
<script src="{{ asset('admin/assets/js/common.min.js') }}"></script>
<!-- uikit functions -->
<script src="{{ asset('admin/assets/js/uikit_custom.min.js') }}"></script>
<!-- altair common functions/helpers -->
<script src="{{ asset('admin/assets/js/altair_admin_common.min.js') }}"></script>

<script src="{{ asset('admin/assets/js/jquery.fancybox.min.js') }}"></script>

<script>
    function logout() {
        $('#logout').submit();
    }
</script>

@yield('footer')

</body>
</html>