@extends('layouts.buy')


@section('content')
    <section id="payment" class="margin-bottom-card">
        <div class="uk-container uk-container-expand margin-top">
            <div uk-grid>
                <div class="uk-width-large uk-margin margin-auto" >
                    <div class="uk-card uk-card-default uk-card-large margin-top-card login-card">
                        <div class="uk-card-body uk-text-center" >
                            <h2>خرید</h2>
                            <ul class="accordion">
                                <li class="login-lable-number">
                                    <span>سامانه یکیتا : </span>
                                    <span>{{$amount_without_discount}}</span>
                                    <span>ریال</span>
                                </li>
                                <li class="login-lable-number">
                                    <span>  تخفیف : </span>
                                    <span>{{$discount_amount}}</span>
                                    <span>ریال</span>
                                </li>
                            </ul>
                            <ul class="accordion">
                                <li class="login-lable-number">
                                    <span> مبلغ مانده : </span>
                                    <span> {{$amount_with_discount}} </span>
                                    <span>ریال</span>
                                </li>
                                <li class="login-lable-number">
                                    <span> مالیات بر ارزش افزوده : </span>
                                    <span> {{$tax_amount}} </span>
                                    <span>ریال</span>
                                </li>
                            </ul>
                            <ul>
                                <li class="login-lable-number">
                                    <span > مبلغ قابل پرداخت: </span>
                                    <span class="amount-color"> {{number_format($amount_with_tax)}} </span>
                                    <span class="amount-color">ریال</span>
                                </li>
                            </ul>
                            <ul>
                                <li>
                                    <input id="checking_rules" value="1" @if(session()->get('checking_rules')) checked @endif onclick="checking_rules()" class="uk-checkbox" type="checkbox"><a target="_blank" href="/fa/rules">قوانین را مطالعه نموده و تایید می نمایم</a>
                                </li>
                            </ul>

                            <div id="pay-div" @if(!session()->get('checking_rules')) style="display: none" @endif>
                                @if($amount_with_tax < 1)
                                    <a href="{{route('home_save_basket')}}"><button class="uk-button button-accept">پرداخت</button></a>
                                @else
                                    <a uk-toggle="target: #modal-payment"><button class="uk-button button-accept">پرداخت</button></a>
                                @endif

                                @if(session()->has('message'))
                                    <div class="uk-alert-danger text-center">{{session()->get('message')}}</div>
                                @endif

                                <div>

                                    @if(session()->has('discount_status'))

                                        <ul class="" id="Domain">
                                            <li class="position-relative">
                                            <input class="uk-input input-shop" disabled type="text" placeholder="{{session()->get('discount_status')[1]}}">
                                            <a href="{{route('home_discount_delete' , session()->get('discount_status')[1])}}"><i class="material-icons uk-text-danger delete-icon">cancel</i></a>
                                            </li>
                                            @if($status == 1)
                                                <li>
                                                    <div class="uk-alert-success text-center">کد تخفیف با موفقیت اعمال شد</div>
                                                </li>
                                            @endif
                                        </ul>

                                    @else
                                            <ul class="" id="Domain">
                                                <li>
                                                    <div class="uk-accordion-content">
                                                        <form action="{{route('home_discount')}}" method="post">
                                                            @csrf
                                                            <div class="uk-margin uk-text-center">
                                                                <ul>
                                                                    <li class=" login-lable">
                                                                        <span>کد تخفیف وارد کنید</span>
                                                                    </li>
                                                                </ul>
                                                                <input name="discount" class="uk-input input-shop" id="discount" type="text" placeholder="">
                                                                <button class="uk-button button-accept-order">بررسی</button>
                                                                @if($status == 0)
                                                                    <div class="uk-alert-danger text-center">کد تخفیف وارد شده نا معتبر است</div>
                                                                @endif
                                                            </div>
                                                        </form>
                                                    </div>
                                                </li>
                                            </ul>
                                    @endif

                                </div>
                            </div>

                            <div>
                                <div id="modal-payment" uk-modal="" class="uk-modal">
                                    <div uk-grid="" class="uk-grid">
                                        <div class="uk-child-width-1-1 margin-auto">
                                            <div class="uk-card uk-card-default uk-card-large">
                                                <button class="uk-modal-close-default uk-close uk-icon" type="button" uk-close=""></button>
                                                <div class="uk-card-body uk-text-center">
                                                    <ul>
                                                        <li>
                                                            <span>مبلغ صورتحساب :</span>
                                                            <span>{{number_format($amount_with_tax)}}</span>
                                                            <span>ریال</span>
                                                        </li>
                                                        <li>
                                                            <span>موجودی کیف پول :</span>
                                                            <span>{{$wallet_amount}}</span>
                                                            <span>ریال</span>
                                                        </li>
                                                        <li>
                                                            <span>مبلغ قابل پرداخت :</span>
                                                            <span>{{number_format($amount_with_wallet)}}</span>
                                                            <span>ریال</span>
                                                        </li>
                                                        @if($amount_with_wallet > 0)
                                                            <li>
                                                                <span class="uk-alert-danger">کیف پول خود را شارژ کنید</span>
                                                            </li>
                                                            <li>
                                                                <a href="{{route('home_save_basket')}}" rel="nofollow"><button class="uk-button button-accept-order">افزایش موجودی</button></a>
                                                            </li>
                                                        @else
                                                            <li>
                                                                <span class="uk-alert-success">موجودی کیف پول شما کافی است</span>
                                                            </li>
                                                            <li>
                                                                <a href="{{route('home_save_basket')}}" rel="nofollow"><button class="uk-button button-accept-order">پرداخت</button></a>
                                                            </li>
                                                        @endif
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


@endsection

<script src="{{ asset('front/buy/js/uikit-icons.min.js') }}"></script>
<script src="{{ asset('front/buy/js/jquery.js') }}"></script>
<script src="{{ asset('front/buy/js/uikit.min.js') }}"></script>
<script>
    function checking_rules(){var e=1;e=$("#checking_rules").is(":checked")?1:0;$.ajax({url:"{{route('order_checking_rules')}}",type:"POST",data:{_token:"{{ csrf_token() }}",status:e},dataType:"JSON",success:function(e){1==e.status?$("#pay-div").slideDown(100):$("#pay-div").slideUp(100)}})}
</script>
