@extends('layouts.pages')

@section('header')

@endsection

@section('content')
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCqdq1BBP9hTxYACzXwv2x7uxDRGpjDeWw&callback=initMap" type="text/javascript"></script>
    <section id="Map" class="uk-margin-medium-top">
        <div class="uk-container">
            <br/>
            <div class="uk-grid" style="padding: 15px; background: #fff">
                <div class="uk-width-1-6@m uk-width-1-1" style="height: 400px; overflow-y: scroll;">
                    @foreach($province as $value)
                        <input type="radio" class="province-key" name="province" id="input-pr-{{$value->id}}" value="{{$value->id}}"><span id="pr-{{$value->id}}" class="province-name" style="cursor: pointer;font-size: 12px;">{{$value->name}}</span>
                        <br/>
                    @endforeach
                </div>
                <div class="uk-width-5-6@m uk-width-1-1" id="map-box" style="height: 400px; padding: 0px !important; margin: 0px !important;"></div>
            </div>
        </div>
    </section>
    <script type="text/javascript">

        var lang = getParameterByName('lang');
        var lat = getParameterByName('lat');
        var lon = getParameterByName('lon');
        if(lang == null){ lang = '{{$lang}}'; }
        if(lat == null){ lat = '{{$location_info->lat}}'; }
        if(lon == null){ lon = '{{$location_info->lon}}'; }
        get_courses(lang , lat , lon);

        var province = [];

        @foreach($province as $value)
            province['{{$value->id}}'] = '{{$value->latitude.','.$value->longitude}}';
        @endforeach

        var map = new google.maps.Map(document.getElementById('map-box'), {
            zoom: 14,
            center: new google.maps.LatLng(lat , lon),
            mapTypeId: google.maps.MapTypeId.ROADMAP
        });

        $('.province-name').click(function () {
            var id = $(this).attr('id');
            $('#input-'+id).trigger('click');
        });

        $('.province-key').click(function () {
            console.log(province[$(this).val()]);
            var locCenter = province[$(this).val()].split(',');
            map = new google.maps.Map(document.getElementById('map-box'), {
                zoom: 14,
                center: new google.maps.LatLng(locCenter[0] , locCenter[1]),
                mapTypeId: google.maps.MapTypeId.ROADMAP
            });
            get_courses(lang ,locCenter[0], locCenter[1]);
        });

        var infowindow = new google.maps.InfoWindow();

        var marker, i;

        $('#map').mouseup(function () {
            var center = map.getCenter();
            var lat = center.lat();
            var lon = center.lng();
            get_courses(lang ,lat, lon);
        });

        function get_courses(lang ,lat, lon) {
            $.ajax({
                type: 'GET', //THIS NEEDS TO BE GET
                url: "{{route('map_points')}}?lang="+lang+"&lat="+lat+"&lon="+lon,
                dataType: 'json',
                success: function (data) {
                    var locations = data;
                    for (i = 0; i < locations.length; i++) {
                        marker = new google.maps.Marker({
                            position: new google.maps.LatLng(locations[i][1], locations[i][2]),
                            map: map
                        });
                        google.maps.event.addListener(marker, 'click', (function(marker, i) {
                            return function() {
                                infowindow.setContent(locations[i][0]);
                                infowindow.open(map, marker);
                            }
                        })(marker, i));
                    }
                },error:function(){
                    console.log(data);
                }
            });
        }

        function getParameterByName(name, url) {
            if (!url) url = window.location.href;
            name = name.replace(/[\[\]]/g, '\\$&');
            var regex = new RegExp('[?&]' + name + '(=([^&#]*)|&|#|$)'),
                results = regex.exec(url);
            if (!results) return null;
            if (!results[2]) return '';
            return decodeURIComponent(results[2].replace(/\+/g, ' '));
        }

    </script>
@endsection

@section('footer')

@endsection