@extends('layouts.buy')

@section('header')
    @endsection
@section('content')
    <div id="login-form">
      
        <div class="uk-container uk-container-expand uk-margin-medium-top">
            <div uk-grid>
                <div class="uk-width-xlarge@s uk-width-large uk-margin margin-auto" >
                    <div class="login-card ">
                         
                        <div class="uk-grid header-page uk-flex uk-flex-between">
                            <div class="uk-width-1-4"><i class="material-icons">language</i></div>
                            <div class="uk-width-2-4 navbar-payment uk-position-top-center"> 
                                <button class="uk-button button-oauth" type="button">
                                    <div class="uk-grid navbar-payment-content">
                                        <div class="no-padding uk-flex-inline uk-flex-between">
                                            <img src="{{App\User::AVATAR_DIRECTORY . session()->get('user_information')->avatar}}" class="image-user">
                                            <p class="name-user">
                                                {{session()->get('user_information')->name}} 
                                            </p>
                                            <p class="type-user">
                                                برگزار کننده
                                            </p>
                                        </div>
                                        <div class="no-padding" style="margin-top: .5rem;">
                                            
                                        </div>
                                    </div>
                                </button>
                            </div>
                            <div class="uk-width-1-4 uk-text-left">
                                <a href="{{route('home_shop',App::getLocale())}}"><i class="material-icons">arrow_back</i></a>
                            </div>
                        </div>

                        @if ($errors->has('license_email'))
                            <div class="uk-alert-warning" uk-alert>
                                <a class="uk-alert-close" uk-close></a>
                                <p>{{ $errors->first('license_email') }}</p>
                            </div>
                        @endif
                        <div class="payment uk-flex uk-flex-center">
                            <h2>اطلاعات تکمیلی</h2>
                        </div> 
                        <div class="payment uk-flex uk-flex-center uk-margin-medium-top">
                            <p> ورود اطلاعات زیر الزامی نیست. در صورت نیاز آن ها را تکمیل کنید.</p>
                        </div>
                        
                        <div class="uk-margin-medium-top">
                            <form action="{{route('home_basket_information')}}" method="post">
                                {{ csrf_field() }}
                                <div class="uk-flex uk-flex-center">
                                    <h5 class="enter-domain-text uk-margin-remove-bottom">
                                       شناسه ایرنیک
                                    </h5>
                                </div>

                                <div class="uk-flex uk-flex-center">
                                    <input class="uk-input uk-input-domain uk-margin-small-right uk-text-center" name="nic_id" placeholder="xxxx-irnic" type="text" autocomplete="off" value="{{old("nic_id")}}">
                                </div>
                                
                                <div class="payment uk-flex uk-flex-center uk-margin-small-top">
                                    <p> برای ثبت مالکیت دامنه به نام شما.</p>
                                </div>

                                <div class="uk-flex uk-flex-center uk-margin-medium-top">
                                    <h5 class="enter-domain-text uk-margin-remove-bottom">
                                       پست الکترونیک
                                    </h5>
                                </div>

                                <div class="uk-flex uk-flex-center">
                                    <input class="uk-input uk-input-domain uk-margin-small-right uk-text-center" name="license_email" placeholder="xxxx-irnic"  type="email" autocomplete="off" value="{{old("license_email")}}">
                                </div>

                                
                                <div class="payment uk-flex uk-flex-center uk-margin-small-top">
                                    <p>برای دریافت آمار مدیریتی بازدید وب سایت</p>
                                </div>

                                <div class="uk-flex uk-flex-center uk-margin-medium-top">
                                    <button class="btn-next" type="submit"> <span>تایید</span></button>
                                </div>

                            </form>
                        </div>

                        
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="{{ asset('front/buy/js/jquery.js') }}"></script>
    <script src="{{ asset('front/buy/js/uikit-icons.min.js') }}"></script>
    <script src="{{ asset('front/buy/js/uikit.min.js') }}"></script>

@endsection

